/*
 * libwbxml, the WBXML Library.
 * Copyright (C) 2002-2005 Aymerick Jehanne <aymerick@jehanne.org>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 * 
 * LGPL v2.1: http://www.gnu.org/copyleft/lesser.txt
 * 
 * Contact: libwbxml@aymerick.com
 * Home: http://libwbxml.aymerick.com
 */
 
/**
 * @file wbxml_mem.c
 * @ingroup wbxml_mem
 *
 * @author Aymerick Jehanne <libwbxml@aymerick.com>
 * @date 02/11/24
 *
 * @brief Memory Functions
 */

#include "wbxml.h"


//SHINSEUNGHOON 2008919 Link error for making WBXmlConverter library [START]
#if 0
char* strdup (const char *pcConstStringP)
{
	char* pNew_str;

	if (!pcConstStringP) 
	{
		return NULL;
	}
	/* allocate memory for new copy */
	pNew_str = (char*)malloc(strlen(pcConstStringP) + 1);
	
	/* Copy the string into the new memory */
	if (pNew_str != NULL)
	{
		memset(pNew_str, 0, strlen(pcConstStringP) + 1);
		strcpy(pNew_str, pcConstStringP);
	}
	   
	return pNew_str;
}
#endif
//SHINSEUNGHOON 2008919 Link error for making WBXmlConverter library [END]

/***************************************************
 *    Public Functions
 */

WBXML_DECLARE(void *) wbxml_malloc(size_t size)
{
#ifdef USE_EAS_OEMUTILS
	void* pRet = EAS_malloc(size);
	return pRet;
#else
#ifdef WBXML_USE_LEAKTRACKER
    return lt_malloc(size);
#else
    return malloc(size);
#endif
#endif
}


WBXML_DECLARE(void) wbxml_free(void *memblock)
{
#ifdef USE_EAS_OEMUTILS
	EAS_free(memblock);
#else
#ifdef WBXML_USE_LEAKTRACKER
    lt_free(memblock);
#else
    free(memblock);
#endif
#endif
}


WBXML_DECLARE(void *) wbxml_realloc(void *memblock, size_t size)
{
#ifdef USE_EAS_OEMUTILS
	return EAS_realloc(memblock, size);
#else
#ifdef WBXML_USE_LEAKTRACKER
    return lt_realloc(memblock, size);
#else
    return realloc(memblock, size);
#endif
#endif
}


WBXML_DECLARE(char *) wbxml_strdup(const char *str)
{
#ifdef USE_EAS_OEMUTILS
	return EAS_strdup((char*)str);
#else
#ifdef WBXML_USE_LEAKTRACKER
    return lt_strdup(str);
#else
    return strdup(str);
#endif
#endif
}
