/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ScopedDOMDataStore_h
#define ScopedDOMDataStore_h

#include "DOMDataStore.h"

namespace WebCore {

    // ScopedDOMDataStore
    //
    // ScopedDOMDataStore is a DOMDataStore that controls limits the lifetime of
    // the store to the lifetime of the object itself.  In other words, when the
    // ScopedDOMDataStore object is deallocated, the maps that belong to the store
    // are deallocated as well.
    //
    class ScopedDOMDataStore : public DOMDataStore {
    public:
// CAPPFIX_WEB_WEBWORKERS_START
        ScopedDOMDataStore();
// CAPPFIX_WEB_WEBWORKERS_END

        // This can be called when WTF thread is tearing down.
        // We assume that all child threads running V8 instances are created by WTF.
        virtual ~ScopedDOMDataStore();
    };

} // namespace WebCore

#endif // ScopedDOMDataStore_h
