#include "fb_sensor.h"

static Bool mIsRunning = false;

extern Bool SensorService_GetInfo(int32_t sensor_type, SensorData* data);
extern int SensorService_Command(SensorCommand cmd);
extern Bool SensorService_GetIsReady(void);
extern int SensorService_Start(void);

Bool SensorManager_Status()
{
    return mIsRunning & SensorService_GetIsReady();
}

Bool SensorManager_GetInfo(int32_t sensor_type, SensorData* data)
{
    Bool result = false;

    if(mIsRunning && SensorService_GetIsReady()) {
        result = SensorService_GetInfo(sensor_type, data);
    }
    else {
        printf("Error : sensor is not ready\n");
        result = false;
    }

    return result;
}

int SensorManager_SetCommand(int32_t sensor_type, int32_t command)
{
    int result = 0;
    SensorCommand cmd;

    if(mIsRunning && SensorService_GetIsReady()) {
        memset(&cmd, 0x0, sizeof(SensorCommand));
        cmd.type = sensor_type;
        cmd.command = command;
        result = SensorService_Command(cmd);
    }
    else {
        printf("Error : sensor is not ready\n");
    }

    return result;
}

Bool SensorManager_Start()
{
    if(!mIsRunning) {
        if(SensorService_Start() != 0) {
            return false;
        }

        mIsRunning = true;
    }
    else {
        printf("Info : sensor manager is already started\n");
    }

    return true;
}
