/* Copyright (c) 2011-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {4024, 4078, 4086, 4088, 4065},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{827, 188, 100, 91, 88},
				{827, 188, 100, 91, 88},
				{822, 193, 100, 92, 89},
				{813, 198, 103, 93, 90},
				{780, 204, 104, 94, 90},
				{760, 216, 107, 95, 92},
				{749, 220, 110, 96, 93},
				{742, 209, 118, 101, 95},
				{747, 187, 125, 105, 98},
				{774, 180, 106, 98, 92},
				{817, 180, 100, 91, 90},
				{874, 180, 100, 91, 90},
				{949, 181, 100, 93, 90},
				{1042, 185, 101, 95, 93},
				{1159, 194, 102, 95, 93},
				{1309, 205, 100, 91, 90},
				{1500, 217, 100, 90, 90},
				{1725, 226, 100, 91, 89},
				{2108, 240, 98, 90, 89},
				{2305, 257, 100, 91, 90},
				{2410, 273, 102, 92, 91},
				{2744, 296, 103, 94, 94},
				{3176, 328, 105, 96, 97},
				{3716, 370, 109, 100, 98},
				{4466, 427, 112, 100, 94},
				{5489, 491, 105, 93, 92},
				{7025, 573, 107, 95, 94},
				{9562, 733, 111, 99, 98},
				{14484, 1036, 123, 107, 110},
				{26868, 2041, 486, 590, 323}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4324, 4322, 4317, 4313, 4306},
				{4218, 4247, 4252, 4250, 4245},
				{4142, 4188, 4195, 4193, 4189},
				{4076, 4133, 4141, 4139, 4135},
				{4010, 4082, 4090, 4088, 4084},
				{3953, 4034, 4042, 4040, 4036},
				{3905, 3986, 3998, 3997, 3993},
				{3864, 3937, 3960, 3959, 3955},
				{3832, 3891, 3920, 3921, 3918},
				{3812, 3856, 3869, 3871, 3868},
				{3798, 3829, 3838, 3838, 3838},
				{3785, 3807, 3816, 3817, 3816},
				{3771, 3790, 3798, 3800, 3798},
				{3758, 3777, 3784, 3785, 3783},
				{3743, 3768, 3772, 3770, 3765},
				{3726, 3756, 3759, 3751, 3738},
				{3707, 3735, 3737, 3729, 3715},
				{3689, 3708, 3711, 3703, 3687},
				{3672, 3688, 3688, 3681, 3670},
				{3657, 3680, 3685, 3679, 3667},
				{3647, 3676, 3684, 3678, 3666},
				{3637, 3672, 3682, 3676, 3664},
				{3624, 3667, 3680, 3675, 3662},
				{3607, 3661, 3677, 3671, 3655},
				{3586, 3652, 3669, 3660, 3631},
				{3556, 3633, 3639, 3624, 3587},
				{3514, 3591, 3586, 3570, 3529},
				{3455, 3528, 3515, 3499, 3452},
				{3367, 3442, 3418, 3399, 3341},
				{3248, 3310, 3264, 3241, 3183},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data LGE_BL_T12_4000mAh_TOCAD_data = {
	.fcc				= 4000,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 121,
	.flat_ocv_threshold_uv	= 3800000,
};
