

#include "CSSThread.h"

#if USE(FAST_CSS)

#define LOG_TAG "FASTCSS"

#include "ThreadGlobalData.h"
#include "CSSStyleSelector.h"
#include <utils/Log.h>

namespace WebCore {
	static CSSThreadManager * s_CSSThreadManager;

	static ThreadGlobalData * s_mainThreadData = 0;

	CSSThread::CSSThread(CSSThread *prev)
		: m_tid(0)
		, m_canContinue(false)
		, m_next(0)
		, m_cssThreadData(0)
		, m_count(0)
	{
		if(prev != 0)
			prev->m_next = this;
	}

	static void* threadEntry(void *arg)
	{
		CSSThread *thread = (CSSThread *)arg;
		thread->runLoop();
		return 0;
	}

	void CSSThread::start()
	{
		m_tid = createThread(threadEntry, reinterpret_cast<void *>(this), "CSSThread");
	}
	
	void CSSThread::waitMainThread()
	{
		m_mutex.lock();
		if(!m_canContinue)
		{
			m_condition.wait(m_mutex);			
		}
		m_canContinue = false;
		m_mutex.unlock();
		
//		s_CSSThreadManager->sync();
		atomicIncrement(&(s_CSSThreadManager->m_numRunningThreads));
		while(s_CSSThreadManager->m_numRunningThreads < s_CSSThreadManager->m_numThreads) {}
	}

	void CSSThread::resume()
	{
		m_mutex.lock();
		m_canContinue = true;
		m_condition.signal();
		m_mutex.unlock();
	}

	void CSSThread::runLoop()
	{
		threadGlobalData().m_isCSSThread = true;
		threadGlobalData().m_mainThreadData = s_mainThreadData;
		threadGlobalData().m_cssThread = this;
//		struct sched_param param;
//		param.sched_priority = this->getNext() != 0 ? 30: 31;
//		pthread_setschedparam(pthread_self(), SCHED_FIFO, &param);
		while(true)
		{
			runLoopBody();
		}
		ASSERT(0); // never return
	}

	void CSSThread::runLoopBody()
	{
		waitMainThread();
		CSSThreadData *data = m_cssThreadData;
		CSSStyleSelector *sel = m_styleSelector;
		int count = m_count;
		int i = 0;
		while(i < count)
		{
			if(atomicIncrement(&(data->lock)) == 0)
				data->result = sel->checkSelector(data->sel);
			data++;
			i++;
		}
		s_CSSThreadManager->notifyMainThread();
	}

	////////////////////////////////////////////////////////////////////////////

	CSSThreadManager::CSSThreadManager(int numThreads)
		: m_numIdleThreads(numThreads)
		, m_numThreads(numThreads)
	{
		s_mainThreadData = &threadGlobalData();
		CSSThread *prev = 0;
		LOGE("Creating CSSThreadManager with %d threads.\n", numThreads);
		for(int i=0; i<m_numThreads; i++)
		{
			CSSThread *thread = new CSSThread(prev);
//			if(i != 0) 
				thread->start();
			if(!prev)
				m_threads = thread;
			prev = thread;
		}
	}

	CSSThreadManager *CSSThreadManager::getInstance()
	{
		int numThreads = 2;
		static bool initialized = false;
		if(!initialized)
		{
			initialized = true;
			s_CSSThreadManager = new CSSThreadManager(numThreads);
		}
		return s_CSSThreadManager;
	}

	void CSSThreadManager::notifyMainThread()
	{
		m_mutex.lock();
		m_numIdleThreads++;
		if(m_numIdleThreads == m_numThreads)
			m_condition.signal();
		m_mutex.unlock();
	}
	
	void CSSThreadManager::sync()
	{
		atomicIncrement(&m_numRunningThreads);
		while(m_numRunningThreads < m_numThreads) {}
	}

	void CSSThreadManager::doCheckSelector(CSSStyleSelector* styleSelector, CSSThreadData *data, int total_count)
	{
		// partition the data
		CSSThread *cssThread = m_threads;
		m_mutex.lock();
//		int numItemPerThread = (total_count + m_numThreads - 1) / m_numThreads;
//		int numItemLastThread = total_count % numItemPerThread == 0 ? numItemPerThread : total_count % numItemPerThread;
		while(cssThread)
		{
//			if(cssThread->getNext())
//				cssThread->setData(styleSelector, data, numItemPerThread);
//			else
//				cssThread->setData(styleSelector, data, numItemLastThread);
			
			cssThread->setData(styleSelector, data, total_count);

//			data += numItemPerThread;
			cssThread = cssThread->getNext();
			m_numIdleThreads--;
		}
		m_mutex.unlock();
		
		// resume CSS threads
		m_numRunningThreads = 0;
		cssThread = m_threads;
		while(cssThread)
		{
			cssThread->resume();			
			cssThread = cssThread->getNext();
		}
		
		// wait until all CSS threads complete
		m_mutex.lock();
		while(m_numIdleThreads < m_numThreads)
		{
			m_condition.wait(m_mutex);
		}
		m_mutex.unlock();
		ASSERT(m_numIdleThreads == m_numThreads);
	}

} // namespace WebCore

#endif
