/* Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

#ifndef MT9T113_REG_H
#define MT9T113_REG_H

#include "mt9t113.h"

static struct mt9t113_register_address_value_pair const
init_reg_settings_array[] = {
  // PLL
  {0x0018, 0x4129, WORD_LEN},	//012A 	// STANDBY_CONTROL_AND_STATUS
  {0x0018, 0x4029, WORD_LEN}, 	// STANDBY_CONTROL_AND_STATUS
  {0x0010, 0x0118, WORD_LEN}, 	// PLL_DIVIDERS
  {0x0012, 0x0070, WORD_LEN}, 	// PLL_P_DIVIDERS
  {0x002A, 0x76A9, WORD_LEN},	//76A7 	// PLL_P4_P5_P6_DIVIDERS  // 2011-3-18  
  //{0x0018, 0x402E, WORD_LEN},	//402E 	// STANDBY_CONTROL_AND_STATUS
  //    2010-12-24 isangmin.lee@lge.com
  {0x0014, 0x0447, WORD_LEN},	//PLL_CONTROL
  {0x0014, 0x0047, WORD_LEN},	//PLL_CONTROL
  //2010-12-15 delay=10
  {0xeeee, 0x000A, WORD_LEN},
  {0x0014, 0x0046, WORD_LEN},	//PLL_CONTROL
  {0x0018, 0x4028, WORD_LEN},	//STANDBY_CONTROL_AND_STATUS

};

static struct mt9t113_register_address_value_pair const
tuning_reg_settings_array[] = {

  //init
  {0x0022, 0x0140, WORD_LEN}, 	// VDD_DIS_COUNTER
  {0x001E, 0x0700, WORD_LEN},	//771 	// PAD_SLEW_PAD_CONFIG
  {0x0112, 0x0012, WORD_LEN},	// RX_FIFO_CONTROL
  {0x3B84, 0x0062, WORD_LEN},     //0x0197, // I2C_MASTER_FREQUENCY_DIVIDER    2011-3-18 2011-04-20
  {0x098E, 0x2C03, WORD_LEN}, // MCU_ADDRESS [AWB_ALGO]
  {0x0990, 0x0000, WORD_LEN}, // MCU_DATA_0 
  {0x098E, 0x2803, WORD_LEN}, // MCU_ADDRESS [AE_ALGO]
  {0x0990, 0x0000, WORD_LEN}, // MCU_DATA_0 
  {0x098E, 0x4800, WORD_LEN},	//Row Start (A)
  {0x0990, 0x0010, WORD_LEN},	//      = 16
  {0x098E, 0x4802, WORD_LEN},	//Column Start (A)
  {0x0990, 0x0010, WORD_LEN},	//      = 16
  {0x098E, 0x4804, WORD_LEN},	//Row End (A)
  {0x0990, 0x062D, WORD_LEN},	//      = 1581
  {0x098E, 0x4806, WORD_LEN},	//Column End (A)
  {0x0990, 0x082D, WORD_LEN},	//      = 2093
  {0x098E, 0x4808, WORD_LEN},	//Base Frame Lines (A)
  {0x0990, 0x0359, WORD_LEN},	//      = 857
  {0x098E, 0x480A, WORD_LEN},	//Line Length (A)
  {0x0990, 0x0ab7, WORD_LEN},    	//0x0d65      = 3429
  {0x098E, 0x480C, WORD_LEN},	//Fine Correction (A)
  {0x0990, 0x0399, WORD_LEN},	//      = 921
  {0x098E, 0x480E, WORD_LEN},	//Row Speed (A)
  {0x0990, 0x0111, WORD_LEN},	//      = 273
  {0x098E, 0x4810, WORD_LEN},	//Read Mode (A)
  {0x0990, 0x046F, WORD_LEN},	//      = 1132
  {0x098E, 0x4812, WORD_LEN},	//Fine IT Min (A)
  {0x0990, 0x0510, WORD_LEN},	//      = 1296
  {0x098E, 0x4814, WORD_LEN},	//Fine IT Max Margin (A)
  {0x0990, 0x01BA, WORD_LEN},	//      = 442
  {0x098E, 0x482D, WORD_LEN},	//Row Start (B)
  {0x0990, 0x0018, WORD_LEN},	//      = 24
  {0x098E, 0x482F, WORD_LEN},	//Column Start (B)
  {0x0990, 0x0018, WORD_LEN},	//      = 24
  {0x098E, 0x4831, WORD_LEN},	//Row End (B)
  {0x0990, 0x0627, WORD_LEN},	//      = 1575
  {0x098E, 0x4833, WORD_LEN},	//Column End (B)
  {0x0990, 0x0827, WORD_LEN},	//      = 2087
  {0x098E, 0x4835, WORD_LEN},	//Base Frame Lines (B)
  {0x0990, 0x065D, WORD_LEN},	//      = 1629
  {0x098E, 0x4837, WORD_LEN},	//Line Length (B)
  {0x0990, 0x0e8a, WORD_LEN},    	//0x122c      = 4209
  {0x098E, 0x4839, WORD_LEN},	//Fine Correction (B)
  {0x0990, 0x019F, WORD_LEN},	//      = 415
  {0x098E, 0x483B, WORD_LEN},	//Row Speed (B)
  {0x0990, 0x0111, WORD_LEN},	//      = 273
  {0x098E, 0x483D, WORD_LEN},	//Read Mode (B)
  {0x0990, 0x0027, WORD_LEN},	//      = 36
  {0x098E, 0x483F, WORD_LEN},	//Fine IT Min (B)
  {0x0990, 0x0266, WORD_LEN},	//      = 614
  {0x098E, 0x4841, WORD_LEN},	//Fine IT Max Margin (B)
  {0x0990, 0x010A, WORD_LEN},	//      = 266
  {0x098E, 0xB81A, WORD_LEN},	//fd_zone_height
  {0x0990, 0x0005, WORD_LEN},	//      = 5
  {0x098E, 0x481A, WORD_LEN},	//fd_period_50Hz (A)
  {0x0990, 0x00D2, WORD_LEN},	//      = 210
  {0x098E, 0x481C, WORD_LEN},	//fd_period_60Hz (A)
  {0x0990, 0x00AF, WORD_LEN},	//      = 175
  {0x098E, 0xC81E, WORD_LEN},	//fd_search_f1_50hz (A)
  {0x0990, 0x0022, WORD_LEN},	//      = 34
  {0x098E, 0xC81F, WORD_LEN},	//fd_search_f2_50hz (A)
  {0x0990, 0x0024, WORD_LEN},	//      = 36
  {0x098E, 0xC820, WORD_LEN},	//fd_search_f1_60hz (A)
  {0x0990, 0x0029, WORD_LEN},	//      = 41
  {0x098E, 0xC821, WORD_LEN},	//fd_search_f2_60hz (A)
  {0x0990, 0x002B, WORD_LEN},	//      = 43
  {0x098E, 0x4847, WORD_LEN},	//fd_period_50Hz (B)
  {0x0990, 0x009B, WORD_LEN}, 	//      = 155
  {0x098E, 0x4849, WORD_LEN},	//fd_period_60Hz (B)
  {0x0990, 0x0081, WORD_LEN}, 	//      = 129
  {0x098E, 0xC84B, WORD_LEN},	//fd_search_f1_50hz (B)
  {0x0990, 0x0018, WORD_LEN}, 	//      = 24
  {0x098E, 0xC84C, WORD_LEN},	//fd_search_f2_50hz (B)
  {0x0990, 0x001A, WORD_LEN}, 	//      = 26
  {0x098E, 0xC84D, WORD_LEN},	//fd_search_f1_60hz (B)
  {0x0990, 0x001E, WORD_LEN}, 	//      = 30
  {0x098E, 0xC84E, WORD_LEN},	//fd_search_f2_60hz (B)
  {0x0990, 0x0020, WORD_LEN}, 	//      = 32
  {0x098E, 0x6800, WORD_LEN},	//Output Width (A)
  {0x0990, 0x0280, WORD_LEN},	//      = 320 ==] 640
  {0x098E, 0x6802, WORD_LEN},	//Output Height (A)
  {0x0990, 0x01E0, WORD_LEN},	//      = 240 ==] 480
  {0x098E, 0x6804, WORD_LEN},	//FOV Width (A)
  {0x0990, 0x0400, WORD_LEN},	//      = 1024  //pre.0x0400
  {0x098E, 0x6806, WORD_LEN},	//FOV Height (A)
  {0x0990, 0x0300, WORD_LEN},	//      = 768 //pre.0x0300
  {0x098E, 0xE892, WORD_LEN},	//JPEG Mode (A)
  {0x0990, 0x0000, WORD_LEN},	//      = 0
  {0x098E, 0x6C00, WORD_LEN},	//Output Width (B)
  {0x0990, 0x0800, WORD_LEN},	//      = 2048
  {0x098E, 0x6C02, WORD_LEN},	//Output Height (B)
  {0x0990, 0x0600, WORD_LEN},	//      = 1536
  {0x098E, 0x6C04, WORD_LEN},	//FOV Width (B)
  {0x0990, 0x0800, WORD_LEN},	//      = 2048
  {0x098E, 0x6C06, WORD_LEN},	//FOV Height (B)
  {0x0990, 0x0600, WORD_LEN},	//      = 1536
  {0x098E, 0xEC92, WORD_LEN},	//JPEG Mode (B)
  {0x0990, 0x0000, WORD_LEN},	//      = 0
  {0x098E, 0x6CA6, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_JPEG_OB_TX_CONTROL_VAR]
  {0x0990, 0x082D, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xECA5, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_JPEG_OB_SPOOF_CONTROL_VAR]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6C94, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_JPEG_CONFIG]
  {0x0990, 0x0C34, WORD_LEN}, 	// MCU_DATA_0
  {0x3C86, 0x00E1, WORD_LEN}, 	// OB_PCLK1_CONFIG
  {0x3C20, 0x0000, WORD_LEN}, 	// TX_SS_CONTROL
  //AE
  {0x098E, 0x6820, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_FDZONE]
  {0x0990, 0x0005, WORD_LEN},   	// MCU_DATA_0
  {0x098E, 0x6822, WORD_LEN},   	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_AGAIN]
  {0x0990, 0x0080, WORD_LEN},   	// MCU_DATA_0
  {0x098E, 0x6824, WORD_LEN},   	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_DGAIN]
  {0x0990, 0x0080, WORD_LEN},   	// MCU_DATA_0
  {0x098E, 0xE826, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_BASE_TARGET]
  {0x0990, 0x003c, WORD_LEN},   	// 40 MCU_DATA_0  
  {0x098E, 0x6829, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MIN_VIRT_DGAIN]
  {0x0990, 0x0080, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x682B, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_DGAIN]
  {0x0990, 0x0080, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x682D, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MIN_VIRT_AGAIN]
  {0x0990, 0x0038, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4871, WORD_LEN}, 	// MCU_ADDRESS [CAM1_CTL_MIN_ANALOG_GAIN]
  {0x0990, 0x0038, WORD_LEN}, 	//0x0039 	// MCU_DATA_0
  {0x098E, 0x682F, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
  {0x0990, 0x0120, WORD_LEN},	//1F8 	// MCU_DATA_0
  {0x098E, 0x6815, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_FD_MAX_FDZONE_50HZ]
  {0x0990, 0x000a, WORD_LEN},   	// MCU_DATA_0
  {0x098E, 0x6817, WORD_LEN},   	// MCU_ADDRESS [PRI_A_CONFIG_FD_MAX_FDZONE_60HZ]
  {0x0990, 0x000c, WORD_LEN},   	// MCU_DATA_0
  //FD_set
  {0x098E, 0x680F, WORD_LEN}, 	 	// MCU_ADDRESS [PRI_A_CONFIG_FD_ALGO_ENTER]
  {0x0990, 0x0003, WORD_LEN}, 	 	// MCU_DATA_0 //important point
  {0x098E, 0xA006, WORD_LEN}, 	 	// MCU_ADDRESS [FD_SMOOTH_COUNTER]
  {0x0990, 0x0008, WORD_LEN}, 	 	// MCU_DATA_0
  {0x098E, 0xA007, WORD_LEN}, 	 	// MCU_ADDRESS [FD_STAT_MIN]
  {0x0990, 0x0003, WORD_LEN}, 	 	// MCU_DATA_0
  {0x098E, 0xA008, WORD_LEN}, 	 	// MCU_ADDRESS [FD_STAT_MAX]
  {0x0990, 0x0005, WORD_LEN}, 	 	// MCU_DATA_0
  {0x098E, 0xA00A, WORD_LEN}, 	 	// MCU_ADDRESS [FD_MIN_AMPLITUDE]
  {0x0990, 0x0000, WORD_LEN}, 	 	// MCU_DATA_0
  //AWB
  {0x098E, 0xAC02, WORD_LEN}, 	// MCU_ADDRESS [AWB_MODE]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x442A, WORD_LEN}, 	// MCU_ADDRESS [awb_start_num_ini_lines]
  {0x0990, 0x00C8, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x442C, WORD_LEN}, 	// MCU_ADDRESS [awb_end_num_int_lines]
  {0x0990, 0x0060, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC42E, WORD_LEN}, 	// MCU_ADDRESS [awb_rg_min]
  {0x0990, 0x0036, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC42F, WORD_LEN}, 	// MCU_ADDRESS [awb_rg_max]
  {0x0990, 0x0057, WORD_LEN}, 	//5E// MCU_DATA_0
  {0x098E, 0xC430, WORD_LEN}, 	// MCU_ADDRESS [awb_rg_min_bright]
  {0x0990, 0x0036, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC431, WORD_LEN}, 	// MCU_ADDRESS [awb_rg_max_bright]
  {0x0990, 0x0057, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC432, WORD_LEN}, 	// MCU_ADDRESS [awb_bg_min]
  {0x0990, 0x0026, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC433, WORD_LEN}, 	// MCU_ADDRESS [awb_bg_max]
  {0x0990, 0x0050, WORD_LEN}, 	//4B// MCU_DATA_0
  {0x098E, 0xC434, WORD_LEN}, 	// MCU_ADDRESS [awb_bg_min_bright]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC435, WORD_LEN}, 	// MCU_ADDRESS [awb_bg_max_bright]
  {0x0990, 0x0050, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4436, WORD_LEN}, 	// MCU_ADDRESS [awb_sharpness_th]
  {0x0990, 0x01F4, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4873, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_0]
  {0x0990, 0x01E1, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4875, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_1]
  {0x0990, 0xFEFA, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4877, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_2]
  {0x0990, 0x0024, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4879, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_3]
  {0x0990, 0xFFD0, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x487B, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_4]
  {0x0990, 0x0136, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x487D, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_5]
  {0x0990, 0xFFF7, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x487F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_6]
  {0x0990, 0xFFD7, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4881, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_7]
  {0x0990, 0xFF56, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4883, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_8]
  {0x0990, 0x01D1, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4885, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_9]
  {0x0990, 0x0022, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4887, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_L_10]
  {0x0990, 0x005F, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4889, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_0]
  {0x0990, 0x001A, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x488B, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_1]
  {0x0990, 0x005B, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x488D, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_2]
  {0x0990, 0xFF8A, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x488F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_3]
  {0x0990, 0xFFF2, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4891, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_4]
  {0x0990, 0x0022, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4893, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_5]
  {0x0990, 0xFFEA, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4895, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_6]
  {0x0990, 0x0021, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4897, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_7]
  {0x0990, 0x0037, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4899, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_8]
  {0x0990, 0xFFA7, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x489B, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_9]
  {0x0990, 0x0016, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x489D, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_CCM_RL_10]
  {0x0990, 0xFFC8, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x489F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_0]
  {0x0990, 0x0100, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48A1, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_1]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48A3, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_2]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48A5, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_3]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48A7, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_4]
  {0x0990, 0x0100, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48A9, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_5]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48AB, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_6]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48AD, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_7]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48AF, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LL_CCM_8]
  {0x0990, 0x0100, WORD_LEN}, 	// MCU_DATA_0
  //AWB
  {0x098E, 0x4887, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0x004E, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x489D, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0xFFE1, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48B8, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_X_SHIFT]
  {0x0990, 0x002D, WORD_LEN},   	// MCU_DATA_0
  {0x098E, 0x48BA, WORD_LEN},   	// MCU_ADDRESS [CAM1_AWB_Y_SHIFT] 2011-04-22
  {0x0990, 0x0018, WORD_LEN},   	// 11 MCU_DATA_0
  {0x098E, 0x48BC, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_RECIP_XSCALE]
  {0x0990, 0x0080, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48BE, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_RECIP_YSCALE]
  {0x0990, 0x00AB, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48C0, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_ROT_CENTER_X]
  {0x0990, 0x03FC, WORD_LEN}, 	// 0x3FC MCU_DATA_0
  {0x098E, 0x48C2, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_ROT_CENTER_Y]
  {0x0990, 0x03E7, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC8C4, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_ROT_SIN]
  {0x0990, 0x0034, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC8C5, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_ROT_COS]
  {0x0990, 0x0026, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48C6, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_0]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48C8, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_1]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48CA, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_2]
  {0x0990, 0x1100, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48CC, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_3]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48CE, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_4]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48D0, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_5]
  {0x0990, 0x0011, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48D2, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_6]
  {0x0990, 0x1111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48D4, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_7]
  {0x0990, 0x1100, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48D6, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_8]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48D8, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_9]
  {0x0990, 0x0011, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48DA, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_10]
  {0x0990, 0x1111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48DC, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_11]
  {0x0990, 0x1110, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48DE, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_12]
  {0x0990, 0x0111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48E0, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_13]
  {0x0990, 0x1111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48E2, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_14]
  {0x0990, 0x2122, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48E4, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_15]
  {0x0990, 0x2110, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48E6, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_16]
  {0x0990, 0x0123, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48E8, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_17]
  {0x0990, 0x3332, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48EA, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_18]
  {0x0990, 0x2123, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48EC, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_19]
  {0x0990, 0x3321, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48EE, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_20]
  {0x0990, 0x0134, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48F0, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_21]
  {0x0990, 0x4443, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48F2, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_22]
  {0x0990, 0x2112, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48F4, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_23]
  {0x0990, 0x3321, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48F6, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_24]
  {0x0990, 0x0123, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48F8, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_25]
  {0x0990, 0x3432, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48FA, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_26]
  {0x0990, 0x1111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48FC, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_27]
  {0x0990, 0x2221, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x48FE, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_28]
  {0x0990, 0x0111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4900, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_29]
  {0x0990, 0x1111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4902, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_30]
  {0x0990, 0x1111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4904, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_WEIGHT_TABLE_31]
  {0x0990, 0x1111, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC8B6, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LUMA_THRESH_LOW]
  {0x0990, 0x0008, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC8B5, WORD_LEN}, 	// MCU_ADDRESS [CAM1_AWB_LUMA_THRESH_HIGH]
  {0x0990, 0x00F5, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC37, WORD_LEN}, 	// MCU_ADDRESS [AWB_R_SCENE_RATIO_LOWER]
  {0x0990, 0x0036, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC38, WORD_LEN}, 	// MCU_ADDRESS [AWB_R_SCENE_RATIO_UPPER]
  {0x0990, 0x005E, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC39, WORD_LEN}, 	// MCU_ADDRESS [AWB_B_SCENE_RATIO_LOWER]
  {0x0990, 0x0026, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC3A, WORD_LEN}, 	// MCU_ADDRESS [AWB_B_SCENE_RATIO_UPPER]
  {0x0990, 0x004B, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC3B, WORD_LEN}, 	// MCU_ADDRESS [AWB_R_RATIO_PRE_AWB]
  {0x0990, 0x0055, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC3C, WORD_LEN}, 	// MCU_ADDRESS [AWB_B_RATIO_PRE_AWB]
  {0x0990, 0x0025, WORD_LEN}, 	// MCU_DATA_0
  //Patch_5_2
  {0x098E, 0x6883, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_ALGO_RUN]
  {0x0990, 0x010B, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xE88B, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_Y_OFFSET]
  {0x0990, 0x0008, WORD_LEN}, 	// MCU_DATA_0
  {0x0982, 0x0000, WORD_LEN}, 	// ACCESS_CTL_STAT
  {0x098A, 0x0A80, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x3C3C, WORD_LEN},
  {0x0992, 0xCE05, WORD_LEN},
  {0x0994, 0x1F1F, WORD_LEN},
  {0x0996, 0x0204, WORD_LEN},
  {0x0998, 0x0CCC, WORD_LEN},
  {0x099A, 0x33D4, WORD_LEN},
  {0x099C, 0x30ED, WORD_LEN},
  {0x099E, 0x00FC, WORD_LEN},
  {0x098A, 0x0A90, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0590, WORD_LEN},
  {0x0992, 0xBDA8, WORD_LEN},
  {0x0994, 0x93CE, WORD_LEN},
  {0x0996, 0x051F, WORD_LEN},
  {0x0998, 0x1F02, WORD_LEN},
  {0x099A, 0x0110, WORD_LEN},
  {0x099C, 0xCC33, WORD_LEN},
  {0x099E, 0xD830, WORD_LEN},
  {0x098A, 0x0AA0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xED02, WORD_LEN},
  {0x0992, 0xCC05, WORD_LEN},
  {0x0994, 0xB8ED, WORD_LEN},
  {0x0996, 0x00C6, WORD_LEN},
  {0x0998, 0x06BD, WORD_LEN},
  {0x099A, 0xA8B1, WORD_LEN},
  {0x099C, 0xCE05, WORD_LEN},
  {0x099E, 0x1F1F, WORD_LEN},
  {0x098A, 0x0AB0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0208, WORD_LEN},
  {0x0992, 0x0CCC, WORD_LEN},
  {0x0994, 0x33D6, WORD_LEN},
  {0x0996, 0x30ED, WORD_LEN},
  {0x0998, 0x00FC, WORD_LEN},
  {0x099A, 0x0592, WORD_LEN},
  {0x099C, 0xBDA8, WORD_LEN},
  {0x099E, 0x93CC, WORD_LEN},
  {0x098A, 0x0AC0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x33F4, WORD_LEN},
  {0x0992, 0x30ED, WORD_LEN},
  {0x0994, 0x02CC, WORD_LEN},
  {0x0996, 0xFFE9, WORD_LEN},
  {0x0998, 0xED00, WORD_LEN},
  {0x099A, 0xFC05, WORD_LEN},
  {0x099C, 0x94C4, WORD_LEN},
  {0x099E, 0x164F, WORD_LEN},
  {0x098A, 0x0AD0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xBDA9, WORD_LEN},
  {0x0992, 0x0ACE, WORD_LEN},
  {0x0994, 0x051F, WORD_LEN},
  {0x0996, 0x1F02, WORD_LEN},
  {0x0998, 0x020A, WORD_LEN},
  {0x099A, 0xCC32, WORD_LEN},
  {0x099C, 0x1030, WORD_LEN},
  {0x099E, 0xED00, WORD_LEN},
  {0x098A, 0x0AE0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x4FBD, WORD_LEN},
  {0x0992, 0xA8E4, WORD_LEN},
  {0x0994, 0x3838, WORD_LEN},
  {0x0996, 0x393C, WORD_LEN},
  {0x0998, 0x3CFC, WORD_LEN},
  {0x099A, 0x0322, WORD_LEN},
  {0x099C, 0xB303, WORD_LEN},
  {0x099E, 0x2030, WORD_LEN},
  {0x098A, 0x0AF0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xED02, WORD_LEN},
  {0x0992, 0xCE03, WORD_LEN},
  {0x0994, 0x141F, WORD_LEN},
  {0x0996, 0x0408, WORD_LEN},
  {0x0998, 0x3ECE, WORD_LEN},
  {0x099A, 0x0314, WORD_LEN},
  {0x099C, 0x1F0B, WORD_LEN},
  {0x099E, 0x0134, WORD_LEN},
  {0x098A, 0x0B00, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x30EC, WORD_LEN},
  {0x0992, 0x0227, WORD_LEN},
  {0x0994, 0x2F83, WORD_LEN},
  {0x0996, 0x0000, WORD_LEN},
  {0x0998, 0x2C18, WORD_LEN},
  {0x099A, 0xF603, WORD_LEN},
  {0x099C, 0x244F, WORD_LEN},
  {0x099E, 0xED00, WORD_LEN},
  {0x098A, 0x0B10, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xFC03, WORD_LEN},
  {0x0992, 0x20A3, WORD_LEN},
  {0x0994, 0x00B3, WORD_LEN},
  {0x0996, 0x0322, WORD_LEN},
  {0x0998, 0x241A, WORD_LEN},
  {0x099A, 0xFC03, WORD_LEN},
  {0x099C, 0x22FD, WORD_LEN},
  {0x099E, 0x0320, WORD_LEN},
  {0x098A, 0x0B20, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x2012, WORD_LEN},
  {0x0992, 0xF603, WORD_LEN},
  {0x0994, 0x244F, WORD_LEN},
  {0x0996, 0xF303, WORD_LEN},
  {0x0998, 0x20B3, WORD_LEN},
  {0x099A, 0x0322, WORD_LEN},
  {0x099C, 0x2306, WORD_LEN},
  {0x099E, 0xFC03, WORD_LEN},
  {0x098A, 0x0B30, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x22FD, WORD_LEN},
  {0x0992, 0x0320, WORD_LEN},
  {0x0994, 0xBD7D, WORD_LEN},
  {0x0996, 0x9038, WORD_LEN},
  {0x0998, 0x3839, WORD_LEN},
  {0x099A, 0x3C3C, WORD_LEN},
  {0x099C, 0xFC07, WORD_LEN},
  {0x099E, 0x4327, WORD_LEN},
  {0x098A, 0x0B40, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x5FDE, WORD_LEN},
  {0x0992, 0x431F, WORD_LEN},
  {0x0994, 0xB410, WORD_LEN},
  {0x0996, 0x563C, WORD_LEN},
  {0x0998, 0xFC07, WORD_LEN},
  {0x099A, 0x4130, WORD_LEN},
  {0x099C, 0xED00, WORD_LEN},
  {0x099E, 0x3CCC, WORD_LEN},
  {0x098A, 0x0B50, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0008, WORD_LEN},
  {0x0992, 0x30ED, WORD_LEN},
  {0x0994, 0x00FC, WORD_LEN},
  {0x0996, 0x0743, WORD_LEN},
  {0x0998, 0xBDAA, WORD_LEN},
  {0x099A, 0x7C38, WORD_LEN},
  {0x099C, 0x38BD, WORD_LEN},
  {0x099E, 0xE9E4, WORD_LEN},
  {0x098A, 0x0B60, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x30ED, WORD_LEN},
  {0x0992, 0x02CC, WORD_LEN},
  {0x0994, 0x0064, WORD_LEN},
  {0x0996, 0xED00, WORD_LEN},
  {0x0998, 0xCC01, WORD_LEN},
  {0x099A, 0x00BD, WORD_LEN},
  {0x099C, 0xAA7C, WORD_LEN},
  {0x099E, 0xFD03, WORD_LEN},
  {0x098A, 0x0B70, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x103C, WORD_LEN},
  {0x0992, 0xFC07, WORD_LEN},
  {0x0994, 0x4530, WORD_LEN},
  {0x0996, 0xED00, WORD_LEN},
  {0x0998, 0x3CCC, WORD_LEN},
  {0x099A, 0x0008, WORD_LEN},
  {0x099C, 0x30ED, WORD_LEN},
  {0x099E, 0x00FC, WORD_LEN},
  {0x098A, 0x0B80, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0743, WORD_LEN},
  {0x0992, 0xBDAA, WORD_LEN},
  {0x0994, 0x7C38, WORD_LEN},
  {0x0996, 0x38BD, WORD_LEN},
  {0x0998, 0xE9E4, WORD_LEN},
  {0x099A, 0x30ED, WORD_LEN},
  {0x099C, 0x02CC, WORD_LEN},
  {0x099E, 0x0064, WORD_LEN},
  {0x098A, 0x0B90, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xED00, WORD_LEN},
  {0x0992, 0xCC01, WORD_LEN},
  {0x0994, 0x00BD, WORD_LEN},
  {0x0996, 0xAA7C, WORD_LEN},
  {0x0998, 0xFD03, WORD_LEN},
  {0x099A, 0x1220, WORD_LEN},
  {0x099C, 0x03BD, WORD_LEN},
  {0x099E, 0x7993, WORD_LEN},
  {0x098A, 0x0BA0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x3838, WORD_LEN},
  {0x0992, 0x39F6, WORD_LEN},
  {0x0994, 0x0008, WORD_LEN},
  {0x0996, 0xC103, WORD_LEN},
  {0x0998, 0x2704, WORD_LEN},
  {0x099A, 0xC107, WORD_LEN},
  {0x099C, 0x2609, WORD_LEN},
  {0x099E, 0xD601, WORD_LEN},
  {0x098A, 0x0BB0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xC10B, WORD_LEN},
  {0x0992, 0x2603, WORD_LEN},
  {0x0994, 0x5FD7, WORD_LEN},
  {0x0996, 0x017E, WORD_LEN},
  {0x0998, 0x6C43, WORD_LEN},
  {0x099A, 0x0FF6, WORD_LEN},
  {0x099C, 0x0105, WORD_LEN},
  {0x099E, 0xC103, WORD_LEN},
  {0x098A, 0x0BC0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x2614, WORD_LEN},
  {0x0992, 0xF601, WORD_LEN},
  {0x0994, 0x06C1, WORD_LEN},
  {0x0996, 0x0626, WORD_LEN},
  {0x0998, 0x0DF6, WORD_LEN},
  {0x099A, 0x304D, WORD_LEN},
  {0x099C, 0xC4F0, WORD_LEN},
  {0x099E, 0xCA08, WORD_LEN},
  {0x098A, 0x0BD0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xF730, WORD_LEN},
  {0x0992, 0x4DBD, WORD_LEN},
  {0x0994, 0x0BD8, WORD_LEN},
  {0x0996, 0x0E39, WORD_LEN},
  {0x0998, 0xF630, WORD_LEN},
  {0x099A, 0x4DC4, WORD_LEN},
  {0x099C, 0xF0CA, WORD_LEN},
  {0x099E, 0x09F7, WORD_LEN},
  {0x098A, 0x0BE0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x304D, WORD_LEN},
  {0x0992, 0xDEF2, WORD_LEN},
  {0x0994, 0x18CE, WORD_LEN},
  {0x0996, 0x0A00, WORD_LEN},
  {0x0998, 0xCC00, WORD_LEN},
  {0x099A, 0x1DBD, WORD_LEN},
  {0x099C, 0xB531, WORD_LEN},
  {0x099E, 0xDEA8, WORD_LEN},
  {0x098A, 0x0BF0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x18CE, WORD_LEN},
  {0x0992, 0x0A1E, WORD_LEN},
  {0x0994, 0xCC00, WORD_LEN},
  {0x0996, 0x1DBD, WORD_LEN},
  {0x0998, 0xB531, WORD_LEN},
  {0x099A, 0xDEA6, WORD_LEN},
  {0x099C, 0x18CE, WORD_LEN},
  {0x099E, 0x0A3C, WORD_LEN},
  {0x098A, 0x0C00, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xCC00, WORD_LEN},
  {0x0992, 0x13BD, WORD_LEN},
  {0x0994, 0xB531, WORD_LEN},
  {0x0996, 0xFE00, WORD_LEN},
  {0x0998, 0xA2EC, WORD_LEN},
  {0x099A, 0x00FD, WORD_LEN},
  {0x099C, 0x0A50, WORD_LEN},
  {0x099E, 0xEC02, WORD_LEN},
  {0x098A, 0x0C10, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xFD0A, WORD_LEN},
  {0x0992, 0x52CC, WORD_LEN},
  {0x0994, 0x0A80, WORD_LEN},
  {0x0996, 0xFD0A, WORD_LEN},
  {0x0998, 0x0ECC, WORD_LEN},
  {0x099A, 0x0AE7, WORD_LEN},
  {0x099C, 0xFD0A, WORD_LEN},
  {0x099E, 0x30CC, WORD_LEN},
  {0x098A, 0x0C20, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0D57, WORD_LEN},
  {0x0992, 0xFD0A, WORD_LEN},
  {0x0994, 0x22CC, WORD_LEN},
  {0x0996, 0x0B3A, WORD_LEN},
  {0x0998, 0xFD0A, WORD_LEN},
  {0x099A, 0x4CCC, WORD_LEN},
  {0x099C, 0x0C57, WORD_LEN},
  {0x099E, 0xFD0A, WORD_LEN},
  {0x098A, 0x0C30, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x4ECC, WORD_LEN},
  {0x0992, 0x0BA3, WORD_LEN},
  {0x0994, 0xFD0A, WORD_LEN},
  {0x0996, 0x50CC, WORD_LEN},
  {0x0998, 0x0A00, WORD_LEN},
  {0x099A, 0xDDF2, WORD_LEN},
  {0x099C, 0xCC0A, WORD_LEN},
  {0x099E, 0x1EDD, WORD_LEN},
  {0x098A, 0x0C40, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xA8CC, WORD_LEN},
  {0x0992, 0x0A3C, WORD_LEN},
  {0x0994, 0xDDA6, WORD_LEN},
  {0x0996, 0xCC0A, WORD_LEN},
  {0x0998, 0x50FD, WORD_LEN},
  {0x099A, 0x00A2, WORD_LEN},
  {0x099C, 0xC605, WORD_LEN},
  {0x099E, 0xF701, WORD_LEN},
  {0x098A, 0x0C50, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0CC6, WORD_LEN},
  {0x0992, 0x02F7, WORD_LEN},
  {0x0994, 0x010D, WORD_LEN},
  {0x0996, 0x393C, WORD_LEN},
  {0x0998, 0x3C3C, WORD_LEN},
  {0x099A, 0x3C3C, WORD_LEN},
  {0x099C, 0xCC30, WORD_LEN},
  {0x099E, 0x12BD, WORD_LEN},
  {0x098A, 0x0C60, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xA83D, WORD_LEN},
  {0x0992, 0x30ED, WORD_LEN},
  {0x0994, 0x0818, WORD_LEN},
  {0x0996, 0xCE02, WORD_LEN},
  {0x0998, 0xD318, WORD_LEN},
  {0x099A, 0x1E02, WORD_LEN},
  {0x099C, 0x1003, WORD_LEN},
  {0x099E, 0x7E0D, WORD_LEN},
  {0x098A, 0x0C70, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x4EDC, WORD_LEN},
  {0x0992, 0xDCA3, WORD_LEN},
  {0x0994, 0x0824, WORD_LEN},
  {0x0996, 0x18D6, WORD_LEN},
  {0x0998, 0xE0F7, WORD_LEN},
  {0x099A, 0x030A, WORD_LEN},
  {0x099C, 0xD6E1, WORD_LEN},
  {0x099E, 0xF703, WORD_LEN},
  {0x098A, 0x0C80, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0BD6, WORD_LEN},
  {0x0992, 0xE4F7, WORD_LEN},
  {0x0994, 0x030C, WORD_LEN},
  {0x0996, 0xD6E5, WORD_LEN},
  {0x0998, 0xF703, WORD_LEN},
  {0x099A, 0x0D18, WORD_LEN},
  {0x099C, 0x1D01, WORD_LEN},
  {0x099E, 0x20DC, WORD_LEN},
  {0x098A, 0x0C90, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xDC1A, WORD_LEN},
  {0x0992, 0xA308, WORD_LEN},
  {0x0994, 0x2574, WORD_LEN},
  {0x0996, 0xDCDE, WORD_LEN},
  {0x0998, 0x1AA3, WORD_LEN},
  {0x099A, 0x0824, WORD_LEN},
  {0x099C, 0x6DEC, WORD_LEN},
  {0x099E, 0x08ED, WORD_LEN},
  {0x098A, 0x0CA0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x06DC, WORD_LEN},
  {0x0992, 0xDCED, WORD_LEN},
  {0x0994, 0x04DC, WORD_LEN},
  {0x0996, 0xDEED, WORD_LEN},
  {0x0998, 0x02D6, WORD_LEN},
  {0x099A, 0xE04F, WORD_LEN},
  {0x099C, 0xED00, WORD_LEN},
  {0x099E, 0xD6E2, WORD_LEN},
  {0x098A, 0x0CB0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xBDAC, WORD_LEN},
  {0x0992, 0xBDF7, WORD_LEN},
  {0x0994, 0x030A, WORD_LEN},
  {0x0996, 0x30EC, WORD_LEN},
  {0x0998, 0x08ED, WORD_LEN},
  {0x099A, 0x06DC, WORD_LEN},
  {0x099C, 0xDCED, WORD_LEN},
  {0x099E, 0x04DC, WORD_LEN},
  {0x098A, 0x0CC0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xDEED, WORD_LEN},
  {0x0992, 0x02D6, WORD_LEN},
  {0x0994, 0xE14F, WORD_LEN},
  {0x0996, 0xED00, WORD_LEN},
  {0x0998, 0xD6E3, WORD_LEN},
  {0x099A, 0xBDAC, WORD_LEN},
  {0x099C, 0xBDF7, WORD_LEN},
  {0x099E, 0x030B, WORD_LEN},
  {0x098A, 0x0CD0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x30EC, WORD_LEN},
  {0x0992, 0x08ED, WORD_LEN},
  {0x0994, 0x06DC, WORD_LEN},
  {0x0996, 0xDCED, WORD_LEN},
  {0x0998, 0x04DC, WORD_LEN},
  {0x099A, 0xDEED, WORD_LEN},
  {0x099C, 0x02D6, WORD_LEN},
  {0x099E, 0xE44F, WORD_LEN},
  {0x098A, 0x0CE0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xED00, WORD_LEN},
  {0x0992, 0xD6E6, WORD_LEN},
  {0x0994, 0xBDAC, WORD_LEN},
  {0x0996, 0xBDF7, WORD_LEN},
  {0x0998, 0x030C, WORD_LEN},
  {0x099A, 0x30EC, WORD_LEN},
  {0x099C, 0x08ED, WORD_LEN},
  {0x099E, 0x06DC, WORD_LEN},
  {0x098A, 0x0CF0, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xDCED, WORD_LEN},
  {0x0992, 0x04DC, WORD_LEN},
  {0x0994, 0xDEED, WORD_LEN},
  {0x0996, 0x02D6, WORD_LEN},
  {0x0998, 0xE54F, WORD_LEN},
  {0x099A, 0xED00, WORD_LEN},
  {0x099C, 0xD6E7, WORD_LEN},
  {0x099E, 0xBDAC, WORD_LEN},
  {0x098A, 0x0D00, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xBDF7, WORD_LEN},
  {0x0992, 0x030D, WORD_LEN},
  {0x0994, 0xCE02, WORD_LEN},
  {0x0996, 0xD31D, WORD_LEN},
  {0x0998, 0x0120, WORD_LEN},
  {0x099A, 0xDCDE, WORD_LEN},
  {0x099C, 0x30A3, WORD_LEN},
  {0x099E, 0x0825, WORD_LEN},
  {0x098A, 0x0D10, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x3DFC, WORD_LEN},
  {0x0992, 0x05E5, WORD_LEN},
  {0x0994, 0x93E8, WORD_LEN},
  {0x0996, 0x241C, WORD_LEN},
  {0x0998, 0xD6E0, WORD_LEN},
  {0x099A, 0xF703, WORD_LEN},
  {0x099C, 0x0AD6, WORD_LEN},
  {0x099E, 0xE1F7, WORD_LEN},
  {0x098A, 0x0D20, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x030B, WORD_LEN},
  {0x0992, 0xD6E4, WORD_LEN},
  {0x0994, 0xF703, WORD_LEN},
  {0x0996, 0x0CD6, WORD_LEN},
  {0x0998, 0xE5F7, WORD_LEN},
  {0x099A, 0x030D, WORD_LEN},
  {0x099C, 0xCE02, WORD_LEN},
  {0x099E, 0xD31C, WORD_LEN},
  {0x098A, 0x0D30, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0120, WORD_LEN},
  {0x0992, 0x201A, WORD_LEN},
  {0x0994, 0xD6E2, WORD_LEN},
  {0x0996, 0xF703, WORD_LEN},
  {0x0998, 0x0AD6, WORD_LEN},
  {0x099A, 0xE3F7, WORD_LEN},
  {0x099C, 0x030B, WORD_LEN},
  {0x099E, 0xD6E6, WORD_LEN},
  {0x098A, 0x0D40, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xF703, WORD_LEN},
  {0x0992, 0x0CD6, WORD_LEN},
  {0x0994, 0xE7F7, WORD_LEN},
  {0x0996, 0x030D, WORD_LEN},
  {0x0998, 0xCE02, WORD_LEN},
  {0x099A, 0xD31D, WORD_LEN},
  {0x099C, 0x0120, WORD_LEN},
  {0x099E, 0xBD79, WORD_LEN},
  {0x098A, 0x0D50, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0xC530, WORD_LEN},
  {0x0992, 0xC60A, WORD_LEN},
  {0x0994, 0x3A35, WORD_LEN},
  {0x0996, 0x39CE, WORD_LEN},
  {0x0998, 0x0314, WORD_LEN},
  {0x099A, 0x1F03, WORD_LEN},
  {0x099C, 0x0103, WORD_LEN},
  {0x099E, 0xBD0D, WORD_LEN},
  {0x098A, 0x0D60, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x647E, WORD_LEN},
  {0x0992, 0x7B26, WORD_LEN},
  {0x0994, 0x3CCC, WORD_LEN},
  {0x0996, 0x337E, WORD_LEN},
  {0x0998, 0x30ED, WORD_LEN},
  {0x099A, 0x00DE, WORD_LEN},
  {0x099C, 0x49E6, WORD_LEN},
  {0x099E, 0x8B4F, WORD_LEN},
  {0x098A, 0x0D70, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x175F, WORD_LEN},
  {0x0992, 0xBDA8, WORD_LEN},
  {0x0994, 0x9338, WORD_LEN},
  {0x098A, 0x8D76, WORD_LEN}, 	// PHYSICAL_ADDR_ACCESS
  {0x0990, 0x0039, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x0012, WORD_LEN}, 	// MCU_ADDRESS [MON_ADDR]
  {0x0990, 0x0BBA, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x0003, WORD_LEN}, 	// MCU_ADDRESS [MON_ALGO]
  {0x0990, 0x0004, WORD_LEN}, 	// MCU_DATA_0
  //POLL_FIELD=MON_RAM_PATCH_ID,!=5,DELAY=10,TIMEOUT=50         // wait for the patch to complete initialization
  //{0xfff1, 5, WORD_LEN},
  //POLL_FIELD=MON_RAM_PATCH_VERSION,!=2,DELAY=10,TIMEOUT=50         // wait for the patch to complete initialization
  {0x3ED6, 0x0F00, WORD_LEN}, 	// RESERVED_CORE_3ED6
  {0x3EF2, 0xD965, WORD_LEN}, 	// RESERVED_CORE_3EF2
  {0x3FD2, 0xD965, WORD_LEN},
  {0x3EF8, 0x7F7F, WORD_LEN}, 	// RESERVED_CORE_3EF8
  {0x3ED8, 0x7F1D, WORD_LEN}, 	// RESERVED_CORE_3ED8
  {0x3172, 0x0033, WORD_LEN}, 	// RESERVED_CORE_3172
  {0x3EEA, 0x0200, WORD_LEN}, 	// RESERVED_CORE_3EEA
  {0x3EE2, 0x0050, WORD_LEN}, 	// RESERVED_CORE_3EE2
  {0x316A, 0x8200, WORD_LEN}, 	// RESERVED_CORE_316A
  {0x316C, 0x8200, WORD_LEN}, 	// RESERVED_CORE_316C
  {0x3EFC, 0xA8E8, WORD_LEN}, 	// RESERVED_CORE_3EFC
  {0x3EFE, 0x130D, WORD_LEN}, 	// RESERVED_CORE_3EFE
  //[Low_Power_Mode] 2010-12-24   ̻  isangmin.lee@lge.com
  {0x3170, 0x000A, WORD_LEN},    //0x02AA //Dynamic pwr setting
  {0x3174, 0x8060, WORD_LEN},      //Dynamic pwr setting
  {0x3ECC, 0x22B0, WORD_LEN},     //0x22F0 //Dynamic pwr setting
  {0x098E, 0x482B, WORD_LEN},       //LP Mode (A)
  {0x0990, 0x22B0, WORD_LEN},       //0x22F0
  {0x098E, 0x4858, WORD_LEN},       //LP Mode (B)
  {0x0990, 0x22B0, WORD_LEN},	//0x22F0
  //2010-12-24   ̻ ߰κ isangmin.lee@lge.com
  {0x098E, 0x4822, WORD_LEN},	// MCU_ADDRESS [CAM1_CTX_A_DYN_POWER_START]
  {0x0990, 0x000A, WORD_LEN},	// MCU_DATA_0
  {0x098E, 0x484F, WORD_LEN},	// MCU_ADDRESS [CAM1_CTX_B_DYN_POWER_START]
  {0x0990, 0x000A, WORD_LEN},	// MCU_DATA_0
         //
  // Additional Optimized Settings             
  // greenish issue                            
  {0x3180, 0xB3FF, WORD_LEN}, // RESERVED // 2011-03-18
  {0x30B2, 0xC000, WORD_LEN}, // RESERVED // 2011-03-18
  // pinkish saturation issue                  
  {0x30BC, 0x0384, WORD_LEN}, // RESERVED // 2011-03-18
  {0x30C0, 0x1220, WORD_LEN}, // RESERVED // 2011-03-18         
  //[Lens Correction 85% 2010/10/26 23:05:06_152]
  {0x3640, 0x0670, WORD_LEN}, 	//  0270  P_G1_P0Q0 2011-04-25
  {0x3642, 0x75AD, WORD_LEN}, 	//  P_G1_P0Q1
  {0x3644, 0x3971, WORD_LEN}, 	//  P_G1_P0Q2
  {0x3646, 0xDB6E, WORD_LEN}, 	//  P_G1_P0Q3
  {0x3648, 0xA2D1, WORD_LEN}, 	//  P_G1_P0Q4
  {0x364A, 0x02d0, WORD_LEN},   //  0x03D0	//  P_R_P0Q0 2011.04.07
  {0x364C, 0xE66E, WORD_LEN}, 	//  P_R_P0Q1
  {0x364E, 0x1631, WORD_LEN},   //0x3631 	//  P_R_P0Q2
  {0x3650, 0x2210, WORD_LEN}, 	//  P_R_P0Q3
  {0x3652, 0xB1B1, WORD_LEN}, 	//  P_R_P0Q4
  {0x3654, 0X1Bd0, WORD_LEN},   //  1b90, 0b90, 0x0390 	//  P_B_P0Q0 2011.04.07
  {0x3656, 0x4CCE, WORD_LEN}, 	//  P_B_P0Q1
  {0x3658, 0x57F0, WORD_LEN}, 	//  P_B_P0Q2
  {0x365A, 0xEC8F, WORD_LEN}, 	//  P_B_P0Q3
  {0x365C, 0x97EF, WORD_LEN}, 	//  P_B_P0Q4
  {0x365E, 0x0690, WORD_LEN}, 	//  P_G2_P0Q0
  {0x3660, 0x8D2F, WORD_LEN}, 	//  P_G2_P0Q1
  {0x3662, 0x51F1, WORD_LEN}, 	//  P_G2_P0Q2
  {0x3664, 0x1DEF, WORD_LEN}, 	//  P_G2_P0Q3
  {0x3666, 0xE811, WORD_LEN}, 	//  P_G2_P0Q4
  {0x3680, 0xBA6D, WORD_LEN}, 	//  P_G1_P1Q0
  {0x3682, 0xD76E, WORD_LEN}, 	//  P_G1_P1Q1
  {0x3684, 0xF46F, WORD_LEN}, 	//  P_G1_P1Q2
  {0x3686, 0x696F, WORD_LEN}, 	//  P_G1_P1Q3
  {0x3688, 0x46F0, WORD_LEN}, 	//  P_G1_P1Q4
  {0x368A, 0x99CD, WORD_LEN}, 	//  P_R_P1Q0
  {0x368C, 0x060F, WORD_LEN}, 	//  P_R_P1Q1
  {0x368E, 0xAFEF, WORD_LEN}, 	//  P_R_P1Q2
  {0x3690, 0xA7B0, WORD_LEN}, 	//  P_R_P1Q3
  {0x3692, 0x76D0, WORD_LEN}, 	//  P_R_P1Q4
  {0x3694, 0x6CAC, WORD_LEN}, 	//  P_B_P1Q0
  {0x3696, 0x26EF, WORD_LEN}, 	//  P_B_P1Q1
  {0x3698, 0x0230, WORD_LEN}, 	//  P_B_P1Q2
  {0x369A, 0xBA30, WORD_LEN}, 	//  P_B_P1Q3
  {0x369C, 0xE5D1, WORD_LEN}, 	//  P_B_P1Q4
  {0x369E, 0x566D, WORD_LEN}, 	//  P_G2_P1Q0
  {0x36A0, 0xB46F, WORD_LEN}, 	//  P_G2_P1Q1
  {0x36A2, 0x0B90, WORD_LEN}, 	//  P_G2_P1Q2
  {0x36A4, 0x6E10, WORD_LEN}, 	//  P_G2_P1Q3
  {0x36A6, 0x8EF2, WORD_LEN}, 	//  P_G2_P1Q4
  {0x36C0, 0x4EB1, WORD_LEN}, 	//  P_G1_P2Q0
  {0x36C2, 0x1D0F, WORD_LEN}, 	//  P_G1_P2Q1
  {0x36C4, 0x5C6F, WORD_LEN}, 	//  P_G1_P2Q2
  {0x36C6, 0x114F, WORD_LEN}, 	//  P_G1_P2Q3
  {0x36C8, 0x9233, WORD_LEN}, 	//  P_G1_P2Q4
  {0x36CA, 0x4DB1, WORD_LEN},   //0x6DB1 	//  P_R_P2Q0
  {0x36CC, 0xB9B0, WORD_LEN}, 	//  P_R_P2Q1
  {0x36CE, 0x7F70, WORD_LEN}, 	//  P_R_P2Q2
  {0x36D0, 0x996D, WORD_LEN}, 	//  P_R_P2Q3
  {0x36D2, 0x8DD3, WORD_LEN}, 	//  P_R_P2Q4
  {0x36D4, 0x20B1, WORD_LEN}, 	//  P_B_P2Q0
  {0x36D6, 0x14AF, WORD_LEN}, 	//  P_B_P2Q1
  {0x36D8, 0x3E11, WORD_LEN}, 	//  P_B_P2Q2
  {0x36DA, 0x1750, WORD_LEN}, 	//  P_B_P2Q3
  {0x36DC, 0xABD3, WORD_LEN}, 	//  P_B_P2Q4
  {0x36DE, 0x4DB1, WORD_LEN}, 	//  P_G2_P2Q0
  {0x36E0, 0xAE30, WORD_LEN}, 	//  P_G2_P2Q1
  {0x36E2, 0x242E, WORD_LEN}, 	//  P_G2_P2Q2
  {0x36E4, 0x860E, WORD_LEN}, 	//  P_G2_P2Q3
  {0x36E6, 0x8632, WORD_LEN}, 	//  P_G2_P2Q4
  {0x3700, 0xA18F, WORD_LEN}, 	//  P_G1_P3Q0
  {0x3702, 0x388E, WORD_LEN}, 	//  P_G1_P3Q1
  {0x3704, 0x1B2E, WORD_LEN}, 	//  P_G1_P3Q2
  {0x3706, 0xE90F, WORD_LEN}, 	//  P_G1_P3Q3
  {0x3708, 0xA5ED, WORD_LEN}, 	//  P_G1_P3Q4
  {0x370A, 0xCD23, WORD_LEN}, 	//  P_R_P3Q0
  {0x370C, 0x26CF, WORD_LEN}, 	//  P_R_P3Q1
  {0x370E, 0xE230, WORD_LEN}, 	//  P_R_P3Q2
  {0x3710, 0xAD50, WORD_LEN}, 	//  P_R_P3Q3
  {0x3712, 0xE970, WORD_LEN}, 	//  P_R_P3Q4
  {0x3714, 0xA92F, WORD_LEN}, 	//  P_B_P3Q0
  {0x3716, 0xD1D0, WORD_LEN}, 	//  P_B_P3Q1
  {0x3718, 0x8431, WORD_LEN}, 	//  P_B_P3Q2
  {0x371A, 0x0E32, WORD_LEN}, 	//  P_B_P3Q3
  {0x371C, 0x62D2, WORD_LEN}, 	//  P_B_P3Q4
  {0x371E, 0xCA8F, WORD_LEN}, 	//  P_G2_P3Q0
  {0x3720, 0x6610, WORD_LEN}, 	//  P_G2_P3Q1
  {0x3722, 0xC251, WORD_LEN}, 	//  P_G2_P3Q2
  {0x3724, 0xC0F2, WORD_LEN}, 	//  P_G2_P3Q3
  {0x3726, 0x7A52, WORD_LEN}, 	//  P_G2_P3Q4
  {0x3740, 0x9C12, WORD_LEN}, 	//  P_G1_P4Q0
  {0x3742, 0x9030, WORD_LEN}, 	//  P_G1_P4Q1
  {0x3744, 0xDC11, WORD_LEN}, 	//  P_G1_P4Q2
  {0x3746, 0x06F1, WORD_LEN}, 	//  P_G1_P4Q3
  {0x3748, 0xD5F5, WORD_LEN}, 	//  P_G1_P4Q4
  {0x374A, 0xD251, WORD_LEN}, 	//  P_R_P4Q0
  {0x374C, 0x7911, WORD_LEN}, 	//  P_R_P4Q1
  {0x374E, 0xB9B3, WORD_LEN}, 	//  P_R_P4Q2
  {0x3750, 0x12F1, WORD_LEN}, 	//  P_R_P4Q3
  {0x3752, 0xD3F4, WORD_LEN}, 	//  P_R_P4Q4
  {0x3754, 0x97B1, WORD_LEN}, 	//  P_B_P4Q0
  {0x3756, 0xDE91, WORD_LEN}, 	//  P_B_P4Q1
  {0x3758, 0x9813, WORD_LEN}, 	//  P_B_P4Q2
  {0x375A, 0x0B33, WORD_LEN}, 	//  P_B_P4Q3
  {0x375C, 0x1773, WORD_LEN}, 	//  P_B_P4Q4
  {0x375E, 0x86B2, WORD_LEN}, 	//  P_G2_P4Q0
  {0x3760, 0x1C72, WORD_LEN}, 	//  P_G2_P4Q1
  {0x3762, 0xAEF3, WORD_LEN}, 	//  P_G2_P4Q2
  {0x3764, 0x01D3, WORD_LEN}, 	//  P_G2_P4Q3
  {0x3766, 0xD3B4, WORD_LEN}, 	//  P_G2_P4Q4
  {0x3784, 0x03B0, WORD_LEN}, 	//  CENTER_COLUMN
  {0x3782, 0x0310, WORD_LEN}, 	//  CENTER_ROW
  {0x326A, 0x0408, WORD_LEN}, 	// APERTURE_PARAMETERS_1D 2011.04.5
  {0x3210, 0X05B8, WORD_LEN},   //0x01B8   	// COLOR_PIPELINE_CONTROL 2011.04.5
 
  {0x098E, 0xE856, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_K_B_R] 2011-04-25
  {0x0990, 0x007D, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xE850, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_X0] 2011-04-25
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0        
  //low_light
  {0x098E, 0x4918, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_START_GAIN_METRIC]
  {0x0990, 0x0030, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x491A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_STOP_GAIN_METRIC]
  {0x0990, 0x0100, WORD_LEN},	//1F4 	// MCU_DATA_0
  {0x098E, 0x6872, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_START_BRIGHTNESS]
  {0x0990, 0x0005, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6874, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_STOP_BRIGHTNESS]
  {0x0990, 0x008C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4956, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DC_START_GAIN_METRIC]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4958, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DC_STOP_GAIN_METRIC]
  {0x0990, 0x0100, WORD_LEN},	//1F4 	// MCU_DATA_0
  {0x098E, 0x495A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DC_START]
  {0x0990, 0x000A, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x495C, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DC_STOP]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x495E, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_AGG_START_GAIN_METRIC]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4960, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_AGG_STOP_GAIN_METRIC]
  {0x0990, 0x0100, WORD_LEN},	//1F4 	// MCU_DATA_0
  {0x098E, 0xC962, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_AGG_START]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC963, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_AGG_STOP]
  {0x0990, 0x0003, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4964, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_START_GAIN_METRIC]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4966, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_STOP_GAIN_METRIC]
  {0x0990, 0x0100, WORD_LEN},	//1F4 	// MCU_DATA_0
  {0x098E, 0x4968, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_T3START]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x496A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_T3STOP]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x496C, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_T4START]
  {0x0990, 0x00C8, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x496E, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_T4STOP]
  {0x0990, 0x003C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC970, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_TO_START]
  {0x0990, 0x0004, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC971, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_BRIGHT_TO_STOP]
  {0x0990, 0x000F, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4972, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_START_GAIN_METRIC]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4974, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_STOP_GAIN_METRIC]
  {0x0990, 0x0100, WORD_LEN},	//1F4 	// MCU_DATA_0
  {0x098E, 0x4976, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_T3START]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4978, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_T3STOP]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x497A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_T4START]
  {0x0990, 0x00C8, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x497C, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_T4STOP]
  {0x0990, 0x003C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC97E, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_TO_START]
  {0x0990, 0x0004, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC97F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_CDC_DARK_TO_STOP]
  {0x0990, 0x000F, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x491C, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_GRB_START_GAIN_METRIC]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x491E, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_GRB_STOP_GAIN_METRIC]
  {0x0990, 0x0100, WORD_LEN},	//1F4 	// MCU_DATA_0
  {0x098E, 0xC920, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_GRB_SLOPE_START]
  {0x0990, 0x000B, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC921, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_GRB_SLOPE_STOP]
  {0x0990, 0x002C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC922, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_GRB_OFFSET_START]
  {0x0990, 0x0007, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC923, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_GRB_OFFSET_STOP]
  {0x0990, 0x001D, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4926, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_START_ANALOG_GAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4928, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_END_ANALOG_GAIN]
  {0x0990, 0x00A0, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x492A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_RAMP_START]
  {0x0990, 0x0082, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x492C, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_RAMP_STOP]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x492E, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_SLOPE_START]
  {0x0990, 0x0015, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4930, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_SLOPE_STOP]
  {0x0990, 0x0015, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4932, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_LOW_THRESH1START]
  {0x0990, 0x0002, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4934, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_LOW_THRESH1STOP]
  {0x0990, 0x0004, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4936, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_LOW_THRESH2START]
  {0x0990, 0x0008, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4938, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_LOW_THRESH2STOP]
  {0x0990, 0x0009, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x493A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_LOW_THRESH3START]
  {0x0990, 0x000C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x493C, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_LOW_THRESH3STOP]
  {0x0990, 0x000D, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x493E, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_MAX_THRESH_START]
  {0x0990, 0x0015, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4940, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_MAX_THRESH_STOP]
  {0x0990, 0x0013, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC944, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_FLATNESS_START]
  {0x0990, 0x0023, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC945, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_FLATNESS_STOP]
  {0x0990, 0x007F, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC946, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_TRANSITION_START]
  {0x0990, 0x0007, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC947, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_TRANSITION_STOP]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC948, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_SOBEL_FLAT_START]
  {0x0990, 0x000A, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC949, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_SOBEL_FLAT_STOP]
  {0x0990, 0x0002, WORD_LEN},	//1F 	// MCU_DATA_0
  {0x098E, 0xC94A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_SOBEL_SHARP_START]
  {0x0990, 0x00FF, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC94B, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_SFFB_SOBEL_SHARP_STOP]
  {0x0990, 0x00FF, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC906, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DM_EDGE_TH_START]
  {0x0990, 0x000A, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC907, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DM_EDGE_TH_STOP]
  {0x0990, 0x0010, WORD_LEN},  	// 50 MCU_DATA_0
  {0x098E, 0xBC02, WORD_LEN}, 	// MCU_ADDRESS [LL_MODE]
  {0x0990, 0x0005, WORD_LEN}, 	//D //2010-12-24  Defect  // MCU_DATA_0
  {0x098E, 0xC908, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_AP_KNEE_START]
  {0x0990, 0x000A, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC909, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_AP_KNEE_STOP]
  {0x0990, 0x0050, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC90A, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_AP_MANTISSA_START]
  {0x0990, 0x0007, WORD_LEN}, 	// MCU_DATA_0
  {0x326C, 0x161e, WORD_LEN}, 	// APERTURE_PARAMETERS_2D
  {0x098E, 0xC94C, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DELTA_GAIN]
  {0x0990, 0x0003, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC94E, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DELTA_THRESHOLD_START]
  {0x0990, 0x003C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xC94F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_DELTA_THRESHOLD_STOP]
  {0x0990, 0x0064, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xE877, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_LL_END_SATURATION]
  {0x0990, 0x0060, WORD_LEN}, 	// 50 MCU_DATA_0                                          
  //gamma
  {0x098E, 0x3C42, WORD_LEN}, 	// MCU_ADDRESS [LL_START_GAMMA_FTB]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x3C44, WORD_LEN}, 	// MCU_ADDRESS [LL_STOP_GAMMA_FTB]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4912, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_START_GAMMA_BM]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4914, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_MID_GAMMA_BM]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x4916, WORD_LEN}, 	// MCU_ADDRESS [CAM1_LL_STOP_GAMMA_BM]
  {0x0990, 0x0037, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC09, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_0]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC0A, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_1]
  {0x0990, 0x0011, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC0B, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_2]
  {0x0990, 0x0023, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC0C, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_3]
  {0x0990, 0x003F, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC0D, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_4]
  {0x0990, 0x0067, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC0E, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_5]
  {0x0990, 0x0085, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC0F, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_6]
  {0x0990, 0x009B, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC10, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_7]
  {0x0990, 0x00AD, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC11, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_8]
  {0x0990, 0x00BB, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC12, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_9]
  {0x0990, 0x00C7, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC13, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_10]
  {0x0990, 0x00D1, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC14, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_11]
  {0x0990, 0x00DA, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC15, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_12]
  {0x0990, 0x00E1, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC16, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_13]
  {0x0990, 0x00E8, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC17, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_14]
  {0x0990, 0x00EE, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC18, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_15]
  {0x0990, 0x00F3, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC19, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_16]
  {0x0990, 0x00F7, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC1A, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_17]
  {0x0990, 0x00FB, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC1B, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_CONTRAST_CURVE_18]
  {0x0990, 0x00FF, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC1C, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_0]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC1D, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_1]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC1E, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_2]
  {0x0990, 0x0014, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC1F, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_3]
  {0x0990, 0x0036, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC20, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_4]
  {0x0990, 0x005C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC21, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_5]
  {0x0990, 0x0079, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC22, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_6]
  {0x0990, 0x0091, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC23, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_7]
  {0x0990, 0x00A4, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC24, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_8]
  {0x0990, 0x00B3, WORD_LEN}, 	// MCU_DATA_0

  {0x098E, 0xBC25, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_9]
  {0x0990, 0x00BF, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC26, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_10]
  {0x0990, 0x00CA, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC27, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_11]
  {0x0990, 0x00D3, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC28, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_12]
  {0x0990, 0x00DB, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC29, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_13]
  {0x0990, 0x00E3, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC2A, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_14]
  {0x0990, 0x00E9, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC2B, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_15]
  {0x0990, 0x00EF, WORD_LEN}, 	// MCU_DATA_0

  {0x098E, 0xBC2C, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_16]
  {0x0990, 0x00F5, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC2D, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_17]
  {0x0990, 0x00FA, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC2E, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NEUTRAL_CURVE_18]
  {0x0990, 0x00FF, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC2F, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_0]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC30, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_1]
  {0x0990, 0x0017, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC31, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_2]
  {0x0990, 0x0020, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC32, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_3]
  {0x0990, 0x0032, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC33, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_4]
  {0x0990, 0x005A, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC34, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_5]
  {0x0990, 0x0078, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC35, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_6]
  {0x0990, 0x0089, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC36, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_7]
  {0x0990, 0x0098, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC37, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_8]
  {0x0990, 0x00A6, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC38, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_9]
  {0x0990, 0x00B4, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC39, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_10]
  {0x0990, 0x00C3, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC3A, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_11]
  {0x0990, 0x00CB, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC3B, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_12]
  {0x0990, 0x00D0, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC3C, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_13]
  {0x0990, 0x00D4, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC3D, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_14]
  {0x0990, 0x00DC, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC3E, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_15]
  {0x0990, 0x00E4, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC3F, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_16]
  {0x0990, 0x00EA, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC40, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_17]
  {0x0990, 0x00F5, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xBC41, WORD_LEN}, 	// MCU_ADDRESS [LL_GAMMA_NRCURVE_18]
  {0x0990, 0x00FF, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x3C42, WORD_LEN}, 	// MCU_ADDRESS [LL_START_GAMMA_FTB]
  {0x0990, 0x0032, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x3C44, WORD_LEN}, 	// MCU_ADDRESS [LL_STOP_GAMMA_FTB]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x0018, 0x002A, WORD_LEN}, 	// STANDBY_CONTROL_AND_STATUS
  {0x098E, 0xAC02, WORD_LEN}, 	// MCU_ADDRESS [AWB_MODE]
  {0x0990, 0x0016, WORD_LEN}, 	// 16	//MCU_DATA_0
  {0x098E, 0x2800, WORD_LEN}, 	// MCU_ADDRESS [AE_TRACK_STATUS]
  {0x0990, 0x001C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};


/* framerate mode end */

static struct mt9t113_register_address_value_pair const
preview_mode_reg_settings_array[] = {
  //[Preview]
  {0x098E, 0xEC09, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0x0005, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN}, 	// MCU_DATA_0
  // 2010-12-31 for upgrading sensor stablity
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0x0005, WORD_LEN}, 	// MCU_DATA_0
  {0xddd1, 0xddd1, WORD_LEN}, 	// MCU_DATA_0
};

static struct mt9t113_register_address_value_pair const
snapshot_mode_reg_settings_array[] = {
  {0x098E, 0xEC09, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0 //pre.0x0009
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS
  {0x0990, 0x0002, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* effect setting start */
/* effect - off */
static struct mt9t113_register_address_value_pair const
effect_mode_off_reg_settings_array[] = {
  {0x098E, 0xE887, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC87, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* effect - mono */
static struct mt9t113_register_address_value_pair const
effect_mode_mono_reg_settings_array[] = {
  {0x098E, 0xE887, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC87, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0001, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* effect - negative */
static struct mt9t113_register_address_value_pair const
effect_mode_negative_reg_settings_array[] = {
  {0x098E, 0xE887, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0003, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC87, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0003, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* effect - solarize */
static struct mt9t113_register_address_value_pair const
effect_mode_solarize_reg_settings_array[] = {
  {0x098E, 0xE887, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0004, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC87, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0004, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* effect - sepia */
static struct mt9t113_register_address_value_pair const
effect_mode_sepia_reg_settings_array[] = {
  {0x098E, 0xE887, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0002, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC87, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0002, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xE889, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
  {0x0990, 0x0012, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xE88A, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
  {0x0990, 0x00E6, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC89, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
  {0x0990, 0x0012, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC8A, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
  {0x0990, 0x00E6, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* effect - aqua */
static struct mt9t113_register_address_value_pair const
effect_mode_aqua_reg_settings_array[] = {
  {0x098E, 0xE887, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0002, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC87, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SELECT_FX]
  {0x0990, 0x0002, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xE889, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CR]
  {0x0990, 0x00CE, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xE88A, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_SYSCTRL_SEPIA_CB]
  {0x0990, 0x0020, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC89, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CR]
  {0x0990, 0x00CE, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xEC8A, WORD_LEN}, 	// MCU_ADDRESS [PRI_B_CONFIG_SYSCTRL_SEPIA_CB]
  {0x0990, 0x0020, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};
/* effect setting end */

/* White Balance setting start */
/* WB - auto */
static struct mt9t113_register_address_value_pair const
wb_mode_auto_reg_settings_array[] = {
  {0x098E, 0x6848, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
  {0x0990, 0x003F, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6865, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_ENTER]
  {0x0990, 0x801F, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6867, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_RUN]
  {0x0990, 0x12F7, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* WB - incandescent */
static struct mt9t113_register_address_value_pair const
wb_mode_incandescent_reg_settings_array[] = {
 
  {0x098E, 0x6848, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6865, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_ENTER]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6867, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x364A, 0x02D0, WORD_LEN}, 	// P_R_P0Q0 2011-04-20
  {0x364E, 0x4031, WORD_LEN}, 	// P_R_P0Q2 2011-04-20  
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
  //polling
  {0x098E, 0xAC3B, WORD_LEN}, 	// MCU_ADDRESS [AWB_R_RATIO_PRE_AWB]
  {0x0990, 0x005B, WORD_LEN}, 	// 65 MCU_DATA_0  2011-04-20
  {0x098E, 0xAC3C, WORD_LEN}, 	// MCU_ADDRESS [AWB_B_RATIO_PRE_AWB]
  {0x0990, 0x002B, WORD_LEN}, 	// 28 MCU_DATA_0 2011-04-20
};

/* WB - fluorescent */
static struct mt9t113_register_address_value_pair const
wb_mode_fluorescent_reg_settings_array[] = {
 
  {0x098E, 0x6848, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6865, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_ENTER]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6867, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
  //polling
  {0x098E, 0xAC3B, WORD_LEN}, 	// MCU_ADDRESS [AWB_R_RATIO_PRE_AWB]
  {0x0990, 0x004C, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC3C, WORD_LEN}, 	// MCU_ADDRESS [AWB_B_RATIO_PRE_AWB]
  {0x0990, 0x0039, WORD_LEN}, 	// 30 MCU_DATA_0   11-04-20
};

/* WB - daylight */
static struct mt9t113_register_address_value_pair const
wb_mode_daylight_reg_settings_array[] = {
  {0x098E, 0x6848, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6865, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_ENTER]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6867, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
  //polling
  {0x098E, 0xAC3B, WORD_LEN}, 	// MCU_ADDRESS [AWB_R_RATIO_PRE_AWB]
  {0x0990, 0x0044, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0xAC3C, WORD_LEN}, 	// MCU_ADDRESS [AWB_B_RATIO_PRE_AWB]
  {0x0990, 0x0048, WORD_LEN}, 	// MCU_DATA_0
};

/* WB - cloudy */
static struct mt9t113_register_address_value_pair const
wb_mode_cloudy_reg_settings_array[] = {
 
  {0x098E, 0x6848, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AWB_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6865, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_ENTER]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6867, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_STAT_ALGO_RUN]
  {0x0990, 0x0000, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN}, 	// MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN}, 	// MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
  //polling
  {0x098E, 0xAC3B, WORD_LEN}, 	// MCU_ADDRESS [AWB_R_RATIO_PRE_AWB]
  {0x0990, 0x0041, WORD_LEN}, 	// 48 MCU_DATA_0   2011-04-20
  {0x098E, 0xAC3C, WORD_LEN}, 	// MCU_ADDRESS [AWB_B_RATIO_PRE_AWB]
  {0x0990, 0x004f, WORD_LEN}, 	// 4b MCU_DATA_0   2011-04-20
};
/* White Balance setting end */
/* ISO setting start */
/* ISO - auto */
static struct mt9t113_register_address_value_pair const
iso_mode_auto_reg_settings_array[] = {
  {0x098E, 0x682D, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MIN_VIRT_AGAIN]
  {0x0990, 0x0038, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x682F, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
  {0x0990, 0x0120, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x486F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_CTL_MAX_ANALOG_GAIN]
  {0x0990, 0x0120, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6822, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_AGAIN]
  {0x0990, 0x0080, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x2800, WORD_LEN}, 	// MCU_ADDRESS [AE_TRACK_STATUS]
  {0x0990, 0x001C, WORD_LEN}, 	// MCU_DATA_0
};

/* ISO - 100 */
static struct mt9t113_register_address_value_pair const
iso_mode_100_reg_settings_array[] = {
  {0x098E, 0x682D, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MIN_VIRT_AGAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x682F, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x486F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_CTL_MAX_ANALOG_GAIN]
  {0x0990, 0x0060, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6822, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_AGAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x2800, WORD_LEN}, 	// MCU_ADDRESS [AE_TRACK_STATUS]
  {0x0990, 0x001C, WORD_LEN}, 	// MCU_DATA_0
};

/* ISO - 200 */
static struct mt9t113_register_address_value_pair const
iso_mode_200_reg_settings_array[] = {
  {0x098E, 0x682D, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MIN_VIRT_AGAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x682F, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
  {0x0990, 0x0080, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x486F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_CTL_MAX_ANALOG_GAIN]
  {0x0990, 0x0080, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6822, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_AGAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x2800, WORD_LEN}, 	// MCU_ADDRESS [AE_TRACK_STATUS]
  {0x0990, 0x001C, WORD_LEN}, 	// MCU_DATA_0
};

/* ISO - 400 */
static struct mt9t113_register_address_value_pair const
iso_mode_400_reg_settings_array[] = {
  {0x098E, 0x682D, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MIN_VIRT_AGAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x682F, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_AE_MAX_VIRT_AGAIN]
  {0x0990, 0x0120, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x486F, WORD_LEN}, 	// MCU_ADDRESS [CAM1_CTL_MAX_ANALOG_GAIN]
  {0x0990, 0x0120, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x6822, WORD_LEN}, 	// MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_AGAIN]
  {0x0990, 0x0040, WORD_LEN}, 	// MCU_DATA_0
  {0x098E, 0x2800, WORD_LEN}, 	// MCU_ADDRESS [AE_TRACK_STATUS]
  {0x0990, 0x001C, WORD_LEN}, 	// MCU_DATA_0
};
/* ISO setting end */

// 20101103
/* Brightness start */
static struct mt9t113_register_address_value_pair const
brightness_reg_settings_array[] = {
  {0x098E, 0xE88B, WORD_LEN},
  {0x0990, 0x00B5, WORD_LEN}, // -5
  {0x0990, 0x00C5, WORD_LEN}, // -4
  {0x0990, 0x00D5, WORD_LEN}, // -3
  {0x0990, 0x00E5, WORD_LEN}, // -2
  {0x0990, 0x00F5, WORD_LEN}, // -1
  {0x0990, 0x0008, WORD_LEN}, // 0
  {0x0990, 0x0012, WORD_LEN}, // 1
  {0x0990, 0x001c, WORD_LEN}, // 2
  {0x0990, 0x0026, WORD_LEN}, // 3
  {0x0990, 0x0030, WORD_LEN}, // 4
  {0x0990, 0x003a, WORD_LEN}, // 5
};
/* Brightness end */
/* framerate mode start */
/* auto */
static struct mt9t113_register_address_value_pair const
auto_framerate_mode_reg_settings_array[] = {
  {0x098E, 0x480A, WORD_LEN},     // MCU_ADDRESS [CAM1_CTX_A_LINE_LENGTH_PCLK]
  {0x0990, 0x0ab7, WORD_LEN},     // MCU_DATA_0
  {0x098E, 0x6815, WORD_LEN},      // MCU_ADDRESS [PRI_A_CONFIG_FD_MAX_FDZONE_50HZ]
  {0x0990, 0x000a, WORD_LEN},      // 8 MCU_DATA_0
  {0x098E, 0x6817, WORD_LEN},      // MCU_ADDRESS [PRI_A_CONFIG_FD_MAX_FDZONE_60HZ]
  {0x0990, 0x000c, WORD_LEN},      // a MCU_DATA_0
  {0x098E, 0x6820, WORD_LEN},      // MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_FDZONE]
  {0x0990, 0x0005, WORD_LEN},      // MCU_DATA_0
  {0x098E, 0x2800, WORD_LEN},      // MCU_ADDRESS [AE_TRACK_STATUS]
  {0x0990, 0x001C, WORD_LEN},     // MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN},      // MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN},      // MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

/* fixed */
static struct mt9t113_register_address_value_pair const
fixed_framerate_mode_reg_settings_array[] = {
  // 24fps
  {0x098E, 0x480A, WORD_LEN},     // MCU_ADDRESS [CAM1_CTX_A_LINE_LENGTH_PCLK]
  {0x0990, 0x0ab7, WORD_LEN},     // MCU_DATA_0
  {0x098E, 0x6815, WORD_LEN},      // MCU_ADDRESS [PRI_A_CONFIG_FD_MAX_FDZONE_50HZ]
  {0x0990, 0x0005, WORD_LEN},      // MCU_DATA_0
  {0x098E, 0x6817, WORD_LEN},      // MCU_ADDRESS [PRI_A_CONFIG_FD_MAX_FDZONE_60HZ]
  {0x0990, 0x0005, WORD_LEN},      // MCU_DATA_0
  {0x098E, 0x6820, WORD_LEN},      // MCU_ADDRESS [PRI_A_CONFIG_AE_TRACK_TARGET_FDZONE]
  {0x0990, 0x0005, WORD_LEN},      // MCU_DATA_0
  {0x098E, 0x2800, WORD_LEN},      // MCU_ADDRESS [AE_TRACK_STATUS]
  {0x0990, 0x001C, WORD_LEN},     // MCU_DATA_0
  {0x098E, 0x8400, WORD_LEN},      // MCU_ADDRESS [SEQ_CMD]
  {0x0990, 0x0006, WORD_LEN},      // MCU_DATA_0
  {0xdddd, 0xdddd, WORD_LEN},
};

struct mt9t113_reg mt9t113_regs = {
	.init_reg_settings = init_reg_settings_array,
	.init_reg_settings_size = ARRAY_SIZE(
		init_reg_settings_array),

	.tuning_reg_settings = tuning_reg_settings_array,
	.tuning_reg_settings_size = ARRAY_SIZE(
		tuning_reg_settings_array),

	.auto_framerate_reg_settings = auto_framerate_mode_reg_settings_array,
	.auto_framerate_reg_settings_size = ARRAY_SIZE(
		auto_framerate_mode_reg_settings_array),

	.fixed_framerate_reg_settings = fixed_framerate_mode_reg_settings_array,
	.fixed_framerate_reg_settings_size = ARRAY_SIZE(
		fixed_framerate_mode_reg_settings_array),

	.prev_reg_settings = preview_mode_reg_settings_array,
	.prev_reg_settings_size = ARRAY_SIZE(
		preview_mode_reg_settings_array),

	.snap_reg_settings = snapshot_mode_reg_settings_array,
	.snap_reg_settings_size = ARRAY_SIZE(
		snapshot_mode_reg_settings_array),

	.effect_off_reg_settings = effect_mode_off_reg_settings_array,
	.effect_off_reg_settings_size = ARRAY_SIZE(
		effect_mode_off_reg_settings_array),

	.effect_mono_reg_settings = effect_mode_mono_reg_settings_array,
	.effect_mono_reg_settings_size = ARRAY_SIZE(
		effect_mode_mono_reg_settings_array),

	.effect_negative_reg_settings = effect_mode_negative_reg_settings_array,
	.effect_negative_reg_settings_size = ARRAY_SIZE(
		effect_mode_negative_reg_settings_array),

	.effect_solarize_reg_settings = effect_mode_solarize_reg_settings_array,
	.effect_solarize_reg_settings_size = ARRAY_SIZE(
		effect_mode_solarize_reg_settings_array),

	.effect_sepia_reg_settings = effect_mode_sepia_reg_settings_array,
	.effect_sepia_reg_settings_size = ARRAY_SIZE(
		effect_mode_sepia_reg_settings_array),

	.effect_aqua_reg_settings = effect_mode_aqua_reg_settings_array,
	.effect_aqua_reg_settings_size = ARRAY_SIZE(
		effect_mode_aqua_reg_settings_array),

	.wb_auto_reg_settings = wb_mode_auto_reg_settings_array,
	.wb_auto_reg_settings_size = ARRAY_SIZE(
		wb_mode_auto_reg_settings_array),

	.wb_incandescent_reg_settings = wb_mode_incandescent_reg_settings_array,
	.wb_incandescent_reg_settings_size = ARRAY_SIZE(
		wb_mode_incandescent_reg_settings_array),

	.wb_fluorescent_reg_settings = wb_mode_fluorescent_reg_settings_array,
	.wb_fluorescent_reg_settings_size = ARRAY_SIZE(
		wb_mode_fluorescent_reg_settings_array),

	.wb_daylight_reg_settings = wb_mode_daylight_reg_settings_array,
	.wb_daylight_reg_settings_size = ARRAY_SIZE(
		wb_mode_daylight_reg_settings_array),

	.wb_cloudy_reg_settings = wb_mode_cloudy_reg_settings_array,
	.wb_cloudy_reg_settings_size = ARRAY_SIZE(
		wb_mode_cloudy_reg_settings_array),

	.iso_auto_reg_settings = iso_mode_auto_reg_settings_array,
	.iso_auto_reg_settings_size = ARRAY_SIZE(
	 iso_mode_auto_reg_settings_array),

	.iso_100_reg_settings = iso_mode_100_reg_settings_array,
	.iso_100_reg_settings_size = ARRAY_SIZE(
	 iso_mode_100_reg_settings_array),

	.iso_200_reg_settings = iso_mode_200_reg_settings_array,
	.iso_200_reg_settings_size = ARRAY_SIZE(
	 iso_mode_200_reg_settings_array),

	.iso_400_reg_settings = iso_mode_400_reg_settings_array,
	.iso_400_reg_settings_size = ARRAY_SIZE(
	 iso_mode_400_reg_settings_array),

	.brightness_reg_settings = brightness_reg_settings_array,
	.brightness_reg_settings_size = ARRAY_SIZE(
	 brightness_reg_settings_array),
};

#endif /* #define MT9T113_REG_H */

