/****************************************************************************
 *
 *	Copyright(c) 2012 Yamaha Corporation. All rights reserved.
 *
 *	Module		: mcdevprof.c
 *
 *	Description	: MC Driver device profile
 *
 *	Version		: 1.0.0	2012.12.13
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.	In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *	claim that you wrote the original software. If you use this software
 *	in a product, an acknowledgment in the product documentation would be
 *	appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *	misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 ****************************************************************************/


#include "mcdevprof.h"
#include "mcmachdep.h"
#include "mcdefs.h"
#if MCDRV_DEBUG_LEVEL
#include "mcdebuglog.h"
#endif



static	enum MCDRV_DEV_ID	geDevID	= eMCDRV_DEV_ID_80_90H;

static UINT8	gabSlaveAddr[]	= {
	0x11,	/*	Digital	*/
	0x3A,	/*	Analog	*/
};

/*	register access available	*/
static const enum MCDRV_REG_ACCSESS	gawRegAccessAvailable_IF[256]	= {
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	0	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	2	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	4	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	6	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	8	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	10	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	12	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	14	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	16	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	18	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	20	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	22	*/
	eMCDRV_CAN_READ,	eMCDRV_ACCESS_DENY,	/*	24	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	26	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	28	*/
	eMCDRV_CAN_WRITE,	eMCDRV_CAN_WRITE,	/*	30	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	32	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	34	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	36	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	38	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	40	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	42	*/
	eMCDRV_READ_WRITE,	eMCDRV_CAN_WRITE,	/*	44	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	46	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	48	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	50	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	52	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	54	*/
	eMCDRV_CAN_READ,	eMCDRV_READ_WRITE,	/*	56	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	58	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	60	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	62	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	64	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	66	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	68	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	70	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	72	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	74	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	76	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	78	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	80	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	82	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	84	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	86	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	88	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	90	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	92	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	94	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	96	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	98	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	100	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	102	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	104	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	106	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	108	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	110	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	112	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	114	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	116	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	118	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	120	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	122	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	124	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	126	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	128	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	130	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	132	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	134	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	136	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	138	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	140	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	142	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	144	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	146	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	148	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	150	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	152	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	154	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	156	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	158	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	160	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	162	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	164	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	166	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	168	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	170	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	172	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	174	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	176	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	178	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	180	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	182	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	184	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	186	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	188	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	190	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	192	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	194	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	196	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	198	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	200	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	202	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	204	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	206	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	208	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	210	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	212	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	214	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	216	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	218	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	220	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	222	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	224	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	226	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	228	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	230	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	232	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	234	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	236	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	238	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	240	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	242	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	244	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	246	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	248	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	250	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	252	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY	/*	254	*/
};
static const enum MCDRV_REG_ACCSESS	gawRegAccessAvailable_A[256]	= {
	eMCDRV_CAN_READ,	eMCDRV_READ_WRITE,	/*	0	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	2	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	4	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	6	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	8	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	10	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	12	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	14	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	16	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	18	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	20	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	22	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	24	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	26	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	28	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	30	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	32	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	34	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	36	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	38	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	40	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	42	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	44	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	46	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	48	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	50	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	52	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	54	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	56	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	58	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	60	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	62	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	64	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	66	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	68	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	70	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	72	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	74	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	76	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	78	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	80	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	82	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	84	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	86	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	88	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	90	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	92	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	94	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	96	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	98	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	100	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	102	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	104	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	106	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	108	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	110	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	112	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	114	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	116	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	118	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	120	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	122	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	124	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	126	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	128	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	130	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	132	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	134	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	136	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	138	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	140	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	142	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	144	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	146	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	148	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	150	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	152	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	154	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	156	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	158	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	160	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	162	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	164	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	166	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	168	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	170	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	172	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	174	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	176	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	178	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	180	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	182	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	184	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	186	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	188	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	190	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	192	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	194	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	196	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	198	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	200	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	202	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	204	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	206	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	208	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	210	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	212	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	214	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	216	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	218	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	220	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	222	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	224	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	226	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	228	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	230	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	232	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	234	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	236	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	238	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	240	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	242	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	244	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	246	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	248	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	250	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	252	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY	/*	254	*/
};
static const enum MCDRV_REG_ACCSESS	gawRegAccessAvailable_MA[256]	= {
	eMCDRV_CAN_READ,	eMCDRV_CAN_READ,	/*	0	*/
	eMCDRV_CAN_READ,	eMCDRV_CAN_READ,	/*	2	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	4	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	6	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	8	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	10	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	12	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	14	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	16	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	18	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	20	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	22	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	24	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	26	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	28	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	30	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	32	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	34	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	36	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	38	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	40	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	42	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	44	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	46	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	48	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	50	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	52	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	54	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	56	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	58	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	60	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	62	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	64	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	66	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	68	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	70	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	72	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	74	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	76	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	78	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	80	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	82	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	84	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	86	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	88	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	90	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	92	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	94	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	96	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	98	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	100	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	102	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	104	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	106	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	108	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	110	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	112	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	114	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	116	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	118	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	120	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	122	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	124	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	126	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	128	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	130	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	132	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	134	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	136	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	138	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	140	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	142	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	144	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	146	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	148	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	150	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	152	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	154	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	156	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	158	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	160	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	162	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	164	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	166	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	168	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	170	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	172	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	174	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	176	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	178	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	180	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	182	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	184	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	186	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	188	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	190	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	192	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	194	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	196	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	198	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	200	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	202	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	204	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	206	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	208	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	210	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	212	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	214	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	216	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	218	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	220	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	222	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	224	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	226	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	228	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	230	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	232	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	234	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	236	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	238	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	240	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	242	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	244	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	246	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	248	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	250	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	252	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	254	*/
};
static const enum MCDRV_REG_ACCSESS	gawRegAccessAvailable_MB[256]	= {
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	0	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	2	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	4	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	6	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	8	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	10	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	12	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	14	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	16	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	18	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	20	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	22	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	24	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	26	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	28	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	30	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	32	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	34	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	36	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	38	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	40	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	42	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	44	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	46	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	48	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	50	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	52	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	54	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	56	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	58	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	60	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	62	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	64	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	66	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	68	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	70	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	72	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	74	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	76	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	78	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	80	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	82	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	84	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	86	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	88	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	90	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	92	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	94	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	96	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	98	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	100	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	102	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	104	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	106	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	108	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	110	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	112	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	114	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	116	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	118	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	120	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	122	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	124	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	126	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	128	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	130	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	132	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	134	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	136	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	138	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	140	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	142	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	144	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	146	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	148	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	150	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	152	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	154	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	156	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	158	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	160	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	162	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	164	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	166	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	168	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	170	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	172	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	174	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	176	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	178	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	180	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	182	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	184	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	186	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	188	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	190	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	192	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	194	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	196	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	198	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	200	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	202	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	204	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	206	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	208	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	210	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	212	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	214	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	216	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	218	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	220	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	222	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	224	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	226	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	228	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	230	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	232	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	234	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	236	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	238	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	240	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	242	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	244	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	246	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	248	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	250	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	252	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	254	*/
};
static const enum MCDRV_REG_ACCSESS	gawRegAccessAvailable_E[256]	= {
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	0	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	2	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	4	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	6	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	8	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	10	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	12	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	14	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	16	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	18	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	20	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	22	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	24	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	26	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	28	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	30	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	32	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	34	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	36	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	38	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	40	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	42	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	44	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	46	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	48	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	50	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	52	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	54	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	56	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	58	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	60	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	62	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	64	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	66	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	68	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	70	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	72	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	74	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	76	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	78	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	80	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	82	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	84	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	86	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	88	*/
	eMCDRV_READ_WRITE,	eMCDRV_CAN_READ,	/*	90	*/
	eMCDRV_CAN_READ,	eMCDRV_CAN_READ,	/*	92	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	94	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	96	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	98	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	100	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	102	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	104	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	106	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	108	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	110	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	112	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	114	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	116	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	118	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	120	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	122	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	124	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	126	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	128	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	130	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	132	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	134	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	136	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	138	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	140	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	142	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	144	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	146	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	148	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	150	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	152	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	154	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	156	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	158	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	160	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	162	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	164	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	166	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	168	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	170	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	172	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	174	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	176	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	178	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	180	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	182	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	184	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	186	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	188	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	190	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	192	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	194	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	196	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	198	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	200	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	202	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	204	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	206	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	208	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	210	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	212	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	214	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	216	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	218	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	220	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	222	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	224	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	226	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	228	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	230	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	232	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	234	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	236	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	238	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	240	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	242	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	244	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	246	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	248	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	250	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	252	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	254	*/
};
static const enum MCDRV_REG_ACCSESS	gawRegAccessAvailable_ANA[256]	= {
	eMCDRV_CAN_READ,	eMCDRV_READ_WRITE,	/*	0	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	2	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	4	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	6	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	8	*/
	eMCDRV_READ_WRITE,	eMCDRV_CAN_READ,	/*	10	*/
	eMCDRV_CAN_READ,	eMCDRV_READ_WRITE,	/*	12	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	14	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	16	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	18	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	20	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	22	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	24	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	26	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	28	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	30	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	32	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	34	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	36	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	38	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	40	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	42	*/
	eMCDRV_READ_WRITE,	eMCDRV_CAN_READ,	/*	44	*/
	eMCDRV_CAN_READ,	eMCDRV_READ_WRITE,	/*	46	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	48	*/
	eMCDRV_READ_WRITE,	eMCDRV_CAN_READ,	/*	50	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	52	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	54	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	56	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	58	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	60	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	62	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	64	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	66	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	68	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	70	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	72	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	74	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	76	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	78	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	80	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	82	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	84	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	86	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	88	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_CAN_READ,	/*	90	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	92	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	94	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	96	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	98	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	100	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	102	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	104	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	106	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	108	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	110	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	112	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	114	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	116	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	118	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	120	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	122	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	124	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	126	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	128	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	130	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	132	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	134	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	136	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	138	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	140	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	142	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	144	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	146	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	148	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	150	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	152	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	154	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	156	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	158	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	160	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	162	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	164	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	166	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	168	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	170	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	172	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	174	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	176	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	178	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	180	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	182	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	184	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	186	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	188	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	190	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	192	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	194	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	196	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	198	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	200	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	202	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	204	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	206	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	208	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	210	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	212	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	214	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	216	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	218	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	220	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	222	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	224	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	226	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	228	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	230	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	232	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	234	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	236	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	238	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	240	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	242	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	244	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	246	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	248	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	250	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	252	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	254	*/
};
static const enum MCDRV_REG_ACCSESS	gawRegAccessAvailable_CD[256]	= {
	eMCDRV_CAN_READ,	eMCDRV_READ_WRITE,	/*	0	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	2	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	4	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	6	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	8	*/
	eMCDRV_READ_WRITE,	eMCDRV_CAN_READ,	/*	10	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	12	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	14	*/
	eMCDRV_READ_WRITE,	eMCDRV_CAN_READ,	/*	16	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	18	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	20	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	22	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	24	*/
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	/*	26	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	28	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	30	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	32	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	34	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	36	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	/*	38	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	40	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	42	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	44	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	46	*/
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	/*	48	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	50	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	52	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	54	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	56	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	58	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	60	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	62	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	64	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	66	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	68	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	70	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	72	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	74	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	76	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	78	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	80	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	82	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	84	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	86	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	88	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	90	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	92	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	94	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	96	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	98	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	100	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	102	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	104	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	106	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	108	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	110	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	112	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	114	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	116	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	118	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	120	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	122	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	124	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	126	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	128	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	130	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	132	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	134	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	136	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	138	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	140	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	142	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	144	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	146	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	148	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	150	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	152	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	154	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	156	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	158	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	160	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	162	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	164	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	166	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	168	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	170	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	172	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	174	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	176	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	178	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	180	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	182	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	184	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	186	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	188	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	190	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	192	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	194	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	196	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	198	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	200	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	202	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	204	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	206	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	208	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	210	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	212	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	214	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	216	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	218	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	220	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	222	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	224	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	226	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	228	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	230	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	232	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	234	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	236	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	238	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	240	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	242	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	244	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	246	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	248	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	250	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	252	*/
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	/*	254	*/
};

/****************************************************************************
 *	McDevProf_SetDevId
 *
 *	Description:
 *			Set device ID.
 *	Arguments:
 *			eDevId	device ID
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McDevProf_SetDevId(enum MCDRV_DEV_ID eDevId)
{
#if (MCDRV_DEBUG_LEVEL >= 4)
	McDebugLog_FuncIn("McDevProf_SetDevId");
#endif

	geDevID	= eDevId;

#if (MCDRV_DEBUG_LEVEL >= 4)
	McDebugLog_FuncOut("McDevProf_SetDevId", 0);
#endif
}

/****************************************************************************
 *	McDevProf_GetDevId
 *
 *	Description:
 *			Get device ID.
 *	Arguments:
 *			none
 *	Return:
 *			device ID
 *
 ****************************************************************************/
enum MCDRV_DEV_ID	McDevProf_GetDevId(void)
{
#if (MCDRV_DEBUG_LEVEL >= 4)
	SINT32	sdRet	= geDevID;
	McDebugLog_FuncIn("McDevProf_GetDevId");
#endif

#if (MCDRV_DEBUG_LEVEL >= 4)
	McDebugLog_FuncOut("McDevProf_GetDevId", &sdRet);
#endif

	return geDevID;
}

/****************************************************************************
 *	McDevProf_GetSlaveAddr
 *
 *	Description:
 *			get slave address.
 *	Arguments:
 *			eSlaveAddrKind	slave address kind
 *	Return:
 *			slave address
 *
 ****************************************************************************/
UINT8	McDevProf_GetSlaveAddr(
	enum MCDRV_SLAVE_ADDR_KIND	eSlaveAddrKind
)
{
	UINT8	bData	= gabSlaveAddr[eSlaveAddrKind];

#if (MCDRV_DEBUG_LEVEL >= 4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McDevProf_GetSlaveAddr");
#endif

#if (MCDRV_DEBUG_LEVEL >= 4)
	sdRet	= (SINT32)bData;
	McDebugLog_FuncOut("McDevProf_GetSlaveAddr", &sdRet);
#endif

	return bData;
}

/****************************************************************************
 *	McDevProf_GetRegAccess
 *
 *	Description:
 *			Get register access availability
 *	Arguments:
 *			psRegInfo	register information
 *	Return:
 *			MCDRV_REG_ACCSESS
 *
 ****************************************************************************/
enum MCDRV_REG_ACCSESS	McDevProf_GetRegAccess(
	const struct MCDRV_REG_INFO	*psRegInfo
)
{
	enum MCDRV_REG_ACCSESS	eAccess	= eMCDRV_ACCESS_DENY;

#if (MCDRV_DEBUG_LEVEL >= 4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McDevProf_GetRegAccess");
#endif

	switch (psRegInfo->bRegType) {
	case	MCDRV_REGTYPE_IF:
#if 1	/*for FPGA*/
		eAccess	= eMCDRV_READ_WRITE;
#else
		eAccess	= gawRegAccessAvailable_IF[psRegInfo->bAddress];
#endif
		break;
	case	MCDRV_REGTYPE_A:
		if (McDevProf_GetDevId() == eMCDRV_DEV_ID_80_90H) {
			if ((psRegInfo->bAddress == MCI_DOA_DRV)
			|| (psRegInfo->bAddress == MCI_SCKMSKON_B)) {
				eAccess	= eMCDRV_ACCESS_DENY;
				break;
			}
		}
		eAccess	= gawRegAccessAvailable_A[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_MA:
		if (McDevProf_GetDevId() == eMCDRV_DEV_ID_80_90H) {
			if ((psRegInfo->bAddress == MCI_CLK_SEL)
			|| (psRegInfo->bAddress == MCI_LINK_LOCK)) {
				eAccess	= eMCDRV_ACCESS_DENY;
				break;
			}
		}
		eAccess	= gawRegAccessAvailable_MA[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_MB:
		if (McDevProf_GetDevId() == eMCDRV_DEV_ID_80_90H) {
			if (psRegInfo->bAddress == MCI_T_DPLL_FAST) {
				eAccess	= eMCDRV_ACCESS_DENY;
				break;
			}
		}
		eAccess	= gawRegAccessAvailable_MB[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_B:
		eAccess	= eMCDRV_READ_WRITE;
		break;
	case	MCDRV_REGTYPE_E:
		if (McDevProf_GetDevId() == eMCDRV_DEV_ID_80_90H) {
			switch (psRegInfo->bAddress) {
			case	MCI_DAC_DCC_SEL:
			case	MCI_DET_LVL:
			case	MCI_OSF_SEL:
			case	MCI_CLIP_MD:
			case	MCI_CLIP_ATT:
			case	MCI_CLIP_REL:
			case	MCI_CLIP_G:
			case	MCI_OSF_GAIN0_15_8:
			case	MCI_OSF_GAIN0_7_0:
			case	MCI_OSF_GAIN1_15_8:
			case	MCI_OSF_GAIN1_7_0:
			case	MCI_DNG0_ES1:
			case	MCI_DNG1_ES1:
			case	MCI_DNG_ON_ES1:
			case	MCI_DSF_SEL:
			case	MCI_ADC_DCC_SEL:
			case	MCI_ADC_DNG_ON:
			case	MCI_ADC_DNG0_FW:
			case	MCI_ADC_DNG0_TIM:
			case	MCI_ADC_DNG0_ZERO_15_8:
			case	MCI_ADC_DNG0_ZERO_7_0:
			case	MCI_ADC_DNG0_TGT_15_8:
			case	MCI_ADC_DNG0_TGT_7_0:
			case	MCI_ADC_DNG1_FW:
			case	MCI_ADC_DNG1_TIM:
			case	MCI_ADC_DNG1_ZERO_15_8:
			case	MCI_ADC_DNG1_ZERO_7_0:
			case	MCI_ADC_DNG1_TGT_15_8:
			case	MCI_ADC_DNG1_TGT_7_0:
			case	MCI_ADC_DNG2_FW:
			case	MCI_ADC_DNG2_TIM:
			case	MCI_ADC_DNG2_ZERO_15_8:
			case	MCI_ADC_DNG2_ZERO_7_0:
			case	MCI_ADC_DNG2_TGT_15_8:
			case	MCI_ADC_DNG2_TGT_7_0:
			case	MCI_DEPOP0:
			case	MCI_DEPOP1:
			case	MCI_DEPOP2:
			case	MCI_IMPSEL:
				eAccess	= eMCDRV_CAN_WRITE;
				break;
			case	MCI_ECLK_SEL:
				eAccess	= eMCDRV_ACCESS_DENY;
				break;
			case	MCI_SYSEQ:
				eAccess	= eMCDRV_CAN_WRITE;
				break;
			case	MCI_DITHER0:
			case	MCI_DITHER1:
				eAccess	= eMCDRV_READ_WRITE;
				break;
			case	MCI_ADJ_HOLD:
			case	MCI_ADJ_CNT:
			case	MCI_ADJ_MAX_15_8:
			case	MCI_ADJ_MAX_7_0:
				eAccess	= eMCDRV_CAN_WRITE;
				break;
			case	MCI_DNG0:
			case	MCI_DNG1:
			case	MCI_DNG_ON:
				eAccess	= eMCDRV_ACCESS_DENY;
				break;
			default:
				eAccess	=
				gawRegAccessAvailable_E[psRegInfo->bAddress];
				break;
			}
			break;
		}
		eAccess	= gawRegAccessAvailable_E[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_C:
		eAccess	= eMCDRV_READ_WRITE;
		break;
	case	MCDRV_REGTYPE_F:
		eAccess	= eMCDRV_READ_WRITE;
		break;
	case	MCDRV_REGTYPE_ANA:
		if (McDevProf_GetDevId() == eMCDRV_DEV_ID_80_90H) {
			switch (psRegInfo->bAddress) {
			case	MCI_RBSEL:
			case	MCI_DNG_ES1:
			case	MCI_DNG_HP_ES1:
			case	MCI_DNG_SP_ES1:
			case	MCI_DNG_RC_ES1:
			case	MCI_DNG_LO1_ES1:
			case	MCI_DNG_LO2_ES1:
				eAccess	= eMCDRV_READ_WRITE;
				break;
			case	10:
			case	91:
			case	MCI_DNG:
			case	MCI_DNG_HP:
			case	MCI_DNG_SP:
			case	MCI_DNG_RC:
			case	MCI_DNG_LO1:
			case	MCI_DNG_LO2:
				eAccess	= eMCDRV_ACCESS_DENY;
				break;
			default:
				eAccess	=
				gawRegAccessAvailable_ANA[psRegInfo->bAddress];
				break;
			}
			break;
		}
		eAccess	= gawRegAccessAvailable_ANA[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_CD:
		if (McDevProf_GetDevId() == eMCDRV_DEV_ID_80_90H) {
			if ((psRegInfo->bAddress == MCI_SCKMSKON_R)
			|| (psRegInfo->bAddress == MCI_IRQM_KEYOFF)) {
				eAccess	= eMCDRV_ACCESS_DENY;
				break;
			}
			if (psRegInfo->bAddress == MCI_STDPLUGSEL) {
				eAccess	= eMCDRV_READ_WRITE;
				break;
			}
		}
		eAccess	= gawRegAccessAvailable_CD[psRegInfo->bAddress];
		break;
	default:
		break;
	}

#if (MCDRV_DEBUG_LEVEL >= 4)
	sdRet	= eAccess;
	McDebugLog_FuncOut("McDevProf_GetRegAccess", &sdRet);
#endif

	return eAccess;
}



