/****************************************************************************
 *
 *		Copyright(c) 2010 Yamaha Corporation. All rights reserved.
 *
 *		Module		: mcresctrl.c
 *
 *		Description	: MC Driver resource control
 *
 *		Version		: 1.0.0 	2010.09.10
 *
 ****************************************************************************/


#include "mcresctrl.h"
#include "mcdevif.h"
#include "mcservice.h"
#include "mcdriver.h"
#include "mcdefs.h"
#include "mcdevprof.h"
#include "mcmachdep.h"
#if MCDRV_DEBUG_LEVEL
#include "mcdebuglog.h"
#endif



/* wait time */
#define	MCDRV_INTERVAL_MUTE	(1000)
#define	MCDRV_TIME_OUT_MUTE	(1000)


static MCDRV_STATE	geState	= eMCDRV_STATE_NOTINIT;

static MCDRV_GLOBAL_INFO	gsGlobalInfo;
static MCDRV_PACKET			gasPacket[MCDRV_MAX_PACKETS+1];

/* register next address */
static const UINT16	gawNextAddressA[MCDRV_A_REG_NUM] =
{
	0,		1,		2,		0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	8,		0xFFFF,	0xFFFF,	0xFFFF,	12,		13,		14,		15,
	16,		17,		18,		19,		20,		21,		22,		23,		0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,
	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,
	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF
};

static const UINT16	gawNextAddressB_BASE[MCDRV_B_BASE_REG_NUM] =
{
	1,		2,		3,		4,		5,		6,		7,		0xFFFF,	9,		10,		11,		12,		13,		0xFFFF,	0xFFFF,	0xFFFF,
	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	26,		0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	31,		0xFFFF
};

static const UINT16	gawNextAddressB_MIXER[MCDRV_B_MIXER_REG_NUM] =
{
	1,		2,		3,		4,		5,		6,		7,		8,		9,		10,		11,		12,		13,		14,		15,		16,
	17,		18,		19,		20,		21,		22,		23,		24,		25,		26,		27,		28,		29,		30,		31,		32,
	33,		34,		35,		36,		37,		38,		39,		40,		41,		42,		43,		44,		45,		46,		47,		48,
	49,		50,		51,		52,		53,		54,		55,		56,		57,		58,		59,		60,		61,		62,		63,		64,
	65,		66,		67,		68,		69,		70,		71,		72,		73,		74,		75,		76,		77,		78,		79,		80,
	81,		82,		83,		84,		85,		86,		87,		88,		89,		90,		91,		92,		93,		94,		95,		96,
	97,		98,		99,		100,	101,	102,	103,	104,	105,	106,	107,	108,	109,	110,	111,	112,
	113,	114,	115,	116,	117,	118,	119,	120,	121,	122,	123,	124,	125,	126,	127,	128,
	129,	130,	131,	132,	133,	134,	135,	136,	137,	138,	139,	140,	141,	142,	143,	144,
	145,	146,	147,	148,	149,	150,	151,	152,	153,	154,	155,	156,	157,	158,	159,	160,
	161,	162,	163,	164,	165,	166,	167,	168,	169,	170,	171,	172,	173,	174,	175,	176,
	177,	178,	179,	180,	181,	182,	183,	184,	185,	186,	187,	188,	189,	190,	191,	192,
	193,	194,	195,	196,	197,	198,	199,	200,	201,	202,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,
	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF,	0xFFFF
};

static const UINT16	gawNextAddressB_AE[MCDRV_B_AE_REG_NUM] =
{
	1,		2,		3,		4,		5,		6,		7,		8,		9,		10,		11,		12,		13,		14,		15,		16,
	17,		18,		19,		20,		21,		22,		23,		24,		25,		26,		27,		28,		29,		30,		31,		32,
	33,		34,		35,		36,		37,		38,		39,		40,		41,		42,		43,		44,		45,		46,		47,		48,
	49,		50,		51,		52,		53,		54,		55,		56,		57,		58,		59,		60,		61,		62,		63,		64,
	65,		66,		67,		68,		69,		70,		71,		72,		73,		74,		75,		76,		77,		78,		79,		80,
	81,		82,		83,		84,		85,		86,		87,		88,		89,		90,		91,		92,		93,		94,		95,		96,
	97,		98,		99,		100,	101,	102,	103,	104,	105,	106,	107,	108,	109,	110,	111,	112,
	113,	114,	115,	116,	117,	118,	119,	120,	121,	122,	123,	124,	125,	126,	127,	128,
	129,	130,	131,	132,	133,	134,	135,	136,	137,	138,	139,	140,	141,	142,	143,	144,
	145,	146,	147,	148,	149,	150,	151,	152,	153,	154,	155,	156,	157,	158,	159,	160,
	161,	162,	163,	164,	165,	166,	167,	168,	169,	170,	171,	172,	173,	174,	175,	176,
	177,	178,	179,	180,	181,	182,	183,	184,	185,	186,	187,	188,	189,	190,	191,	192,
	193,	194,	195,	196,	197,	198,	199,	200,	201,	202,	203,	204,	205,	206,	207,	208,
	209,	210,	211,	212,	213,	214,	215,	216,	217,	218,	219,	220,	221,	222,	223,	224,
	225,	226,	227,	228,	229,	230,	231,	232,	233,	234,	235,	236,	237,	238,	239,	240,
	241,	242,	243,	244,	245,	246,	247,	248,	249,	250,	251,	252,	253,	254,	0xFFFF
};

static const UINT16	gawNextAddressB_CDSP[MCDRV_B_CDSP_REG_NUM] =
{
	1,		2,		3,		4,		5,		6,		7,		8,		9,		10,		11,		12,		13,		14,		15,		16,
	17,		18,		19,		20,		21,		22,		23,		24,		25,		26,		27,		28,		29,		30,		31,		32,
	33,		34,		35,		36,		37,		38,		39,		40,		41,		42,		43,		44,		45,		46,		47,		48,
	49,		50,		51,		52,		53,		54,		55,		56,		57,		58,		59,		60,		61,		62,		63,		64,
	65,		66,		67,		68,		69,		70,		71,		72,		73,		74,		75,		76,		77,		78,		79,		80,
	81,		82,		83,		84,		85,		86,		87,		88,		89,		90,		91,		92,		93,		94,		95,		96,
	97,		98,		99,		100,	101,	102,	103,	104,	105,	106,	107,	108,	109,	110,	111,	112,
	113,	114,	115,	116,	117,	118,	119,	120,	121,	122,	123,	124,	125,	126,	127,	128,
	129,	0xFFFF
};

static const UINT16	gawNextAddressB_CODEC[MCDRV_B_CODEC_REG_NUM] =
{
	1,		2,		3,		4,		5,		6,		7,		8,		9,		10,		11,		12,		13,		14,		15,		16,
	17,		18,		19,		20,		21,		22,		23,		24,		25,		26,		27,		28,		29,		30,		31,		32,
	33,		34,		35,		36,		37,		38,		39,		40,		41,		42,		43,		44,		45,		46,		47,		48,
	49,		50,		51,		52,		53,		54,		55,		56,		57,		58,		59,		60,		61,		62,		63,		64,
	65,		66,		67,		68,		69,		70,		71,		72,		73,		74,		75,		76,		77,		78,		79,		80,
	81,		82,		83,		84,		85,		86,		87,		88,		89,		90,		91,		92,		93,		94,		95,		96,
	97,		98,		99,		100,	101,	102,	103,	104,	105,	106,	107,	108,	109,	110,	111,	112,
	113,	114,	115,	116,	117,	118,	119,	120,	121,	122,	123,	124,	125,	126,	127,	0xFFFF
};

static const UINT16	gawNextAddressB_Ana[MCDRV_B_ANA_REG_NUM] =
{
	1,		2,		3,		4,		5,		6,		7,		8,		9,		10,		11,		12,		13,		14,		15,		16,
	17,		18,		19,		20,		21,		22,		23,		24,		25,		26,		27,		28,		29,		30,		31,		32,
	33,		34,		35,		36,		37,		38,		39,		40,		41,		42,		43,		44,		45,		46,		47,		48,
	49,		50,		51,		52,		53,		54,		55,		56,		57,		58,		59,		60,		61,		62,		63,		64,
	65,		66,		67,		68,		69,		70,		71,		72,		73,		74,		75,		76,		77,		0xFFFF,	79,		80,
	81,		82,		83,		84,		85,		86,		87,		88,		89,		90,		91,		92,		93,		94,		95,		96,
	97,		98,		99,		100,	101,	102,	103,	104,	105,	106,	107,	108,	109,	110,	111,	112,
	113,	114,	115,	116,	117,	118,	119,	120,	121,	122,	123,	124,	125,	126,	127,	0xFFFF
};

/*	register access available	*/
static const MCDRV_REG_ACCSESS	gawRegAccessAvailableA[256] =
{
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_ONLY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_WRITE_ONLY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
};
static const MCDRV_REG_ACCSESS	gawRegAccessAvailableB_BASE[256] =
{
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
};
static const MCDRV_REG_ACCSESS	gawRegAccessAvailableB_ANA[256] =
{
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_ONLY,
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_ONLY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_ONLY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
};
static const MCDRV_REG_ACCSESS	gawRegAccessAvailableB_CODEC[256] =
{
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_ONLY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_READ_WRITE,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
};
static const MCDRV_REG_ACCSESS	gawRegAccessAvailableB_MIX[256] =
{
	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,
	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_ONLY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,
	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_READ_WRITE,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
};
static const MCDRV_REG_ACCSESS	gawRegAccessAvailableB_AE[256] =
{
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,
	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_WRITE_ONLY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,	eMCDRV_ACCESS_DENY,
};


static void		SetRegDefault(void);
static void		InitPathInfo(void);
static void		InitVolInfo(void);
static void		InitDioInfo(void);
static void		InitDacInfo(void);
static void		InitAdcInfo(void);
static void		InitSpInfo(void);
static void		InitDngInfo(void);
static void		InitAeInfo(void);
static void		InitPdmInfo(void);
static void		InitGpMode(void);
static void		InitGpMask(void);
static void		InitSysEq(void);
static void		InitClockSwitch(void);

static void		ValidateADC(void);
static void		ValidateDAC(void);
static void		ValidateAE(void);
static void		ValidateMix(void);

static void		SetHPSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetSPSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetRCVSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetLO1SourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetLO2SourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetPMSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetDIT0SourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetDIT1SourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetDIT2SourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetDACSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetAESourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetCDSPSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetADC0SourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetADC1SourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetMixSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);
static void		SetBiasSourceOnOff(const MCDRV_PATH_INFO* psPathInfo);

static void		SetDIOCommon(const MCDRV_DIO_INFO* psDioInfo, UINT8 bPort);
static void		SetDIODIR(const MCDRV_DIO_INFO* psDioInfo, UINT8 bPort);
static void		SetDIODIT(const MCDRV_DIO_INFO* psDioInfo, UINT8 bPort);

static SINT16	GetDigitalVolReg(SINT16 swVol);
static SINT16	GetADVolReg(SINT16 swVol);
static SINT16	GetLIVolReg(SINT16 swVol);
static SINT16	GetMcVolReg(SINT16 swVol);
static SINT16	GetMcGainReg(SINT16 swVol);
static SINT16	GetHpVolReg(SINT16 swVol);
static SINT16	GetHpGainReg(SINT16 swVol);
static SINT16	GetSpVolReg(SINT16 swVol);
static SINT16	GetRcVolReg(SINT16 swVol);
static SINT16	GetLoVolReg(SINT16 swVol);

static SINT32	WaitBitSet(UINT8 bSlaveAddr, UINT16 wRegAddr, UINT8 bBit, UINT32 dCycleTime, UINT32 dTimeOut);
static SINT32	WaitBitRelease(UINT8 bSlaveAddr, UINT16 wRegAddr, UINT8 bBit, UINT32 dCycleTime, UINT32 dTimeOut);

/****************************************************************************
 *	McResCtrl_SetHwId
 *
 *	Description:
 *			Set hardware ID.
 *	Arguments:
 *			bHwId	hardware ID
 *	Return:
 *			MCDRV_SUCCESS
 *			MCDRV_ERROR_INIT
 *
 ****************************************************************************/
SINT32	McResCtrl_SetHwId
(
	UINT8	bHwId
)
{
	SINT32	sdRet	= MCDRV_SUCCESS;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetHwId");
#endif

	gsGlobalInfo.bHwId	= bHwId;

	switch (bHwId)
	{
	case MCDRV_HWID_AA:
		McDevProf_SetDevId(eMCDRV_DEV_ID_1N2);
		break;
	case MCDRV_HWID_AB:
		McDevProf_SetDevId(eMCDRV_DEV_ID_1N2);
		break;
	default:
		sdRet	= MCDRV_ERROR_INIT;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetHwId", &sdRet);
#endif

	return sdRet;
}

/****************************************************************************
 *	McResCtrl_GetHwId
 *
 *	Description:
 *			Get hardware ID.
 *	Arguments:
 *			none
 *	Return:
 *			hardware ID
 *
 ****************************************************************************/
UINT8	McResCtrl_GetHwId
(
	void
)
{
	SINT32	sdRet	= gsGlobalInfo.bHwId;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetHwId");
#endif

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetHwId", &sdRet);
#endif

	return (UINT8)sdRet;
}

/****************************************************************************
 *	McResCtrl_Init
 *
 *	Description:
 *			initialize the resource controller.
 *	Arguments:
 *			psInitInfo	pointer to the initialize information struct
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_Init
(
	const MCDRV_INIT_INFO*	psInitInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_Init");
#endif

	gsGlobalInfo.ePacketBufAlloc	= eMCDRV_PACKETBUF_FREE;
	SetRegDefault();

	gsGlobalInfo.sInitInfo.bCkSel	= psInitInfo->bCkSel;
	gsGlobalInfo.sInitInfo.bDivR0	= psInitInfo->bDivR0;
	gsGlobalInfo.sInitInfo.bDivF0	= psInitInfo->bDivF0;
	gsGlobalInfo.sInitInfo.bDivR1	= psInitInfo->bDivR1;
	gsGlobalInfo.sInitInfo.bDivF1	= psInitInfo->bDivF1;
	if(McDevProf_IsValid(eMCDRV_FUNC_RANGE) == 1)
	{
		gsGlobalInfo.sInitInfo.bRange0	= psInitInfo->bRange0;
		gsGlobalInfo.sInitInfo.bRange1	= psInitInfo->bRange1;
	}
	else
	{
		gsGlobalInfo.sInitInfo.bRange0	= 0;
		gsGlobalInfo.sInitInfo.bRange1	= 0;
	}
	if(McDevProf_IsValid(eMCDRV_FUNC_BYPASS) == 1)
	{
		gsGlobalInfo.sInitInfo.bBypass	= psInitInfo->bBypass;
	}
	else
	{
		gsGlobalInfo.sInitInfo.bBypass	= 0;
	}
	gsGlobalInfo.sInitInfo.bDioSdo0Hiz	= psInitInfo->bDioSdo0Hiz;
	gsGlobalInfo.sInitInfo.bDioSdo1Hiz	= psInitInfo->bDioSdo1Hiz;
	gsGlobalInfo.sInitInfo.bDioSdo2Hiz	= psInitInfo->bDioSdo2Hiz;
	gsGlobalInfo.sInitInfo.bDioClk0Hiz	= psInitInfo->bDioClk0Hiz;
	gsGlobalInfo.sInitInfo.bDioClk1Hiz	= psInitInfo->bDioClk1Hiz;
	gsGlobalInfo.sInitInfo.bDioClk2Hiz	= psInitInfo->bDioClk2Hiz;
	gsGlobalInfo.sInitInfo.bPcmHiz		= psInitInfo->bPcmHiz;
	gsGlobalInfo.sInitInfo.bLineIn1Dif	= psInitInfo->bLineIn1Dif;
	if(McDevProf_IsValid(eMCDRV_FUNC_LI2) == 1)
	{
		gsGlobalInfo.sInitInfo.bLineIn2Dif	= psInitInfo->bLineIn2Dif;
	}
	else
	{
		gsGlobalInfo.sInitInfo.bLineIn2Dif	= MCDRV_LINE_STEREO;
	}
	gsGlobalInfo.sInitInfo.bLineOut1Dif	= psInitInfo->bLineOut1Dif;
	gsGlobalInfo.sInitInfo.bLineOut2Dif	= psInitInfo->bLineOut2Dif;
	gsGlobalInfo.sInitInfo.bSpmn		= psInitInfo->bSpmn;
	gsGlobalInfo.sInitInfo.bMic1Sng		= psInitInfo->bMic1Sng;
	gsGlobalInfo.sInitInfo.bMic2Sng		= psInitInfo->bMic2Sng;
	gsGlobalInfo.sInitInfo.bMic3Sng		= psInitInfo->bMic3Sng;
	gsGlobalInfo.sInitInfo.bPowerMode	= psInitInfo->bPowerMode;
	gsGlobalInfo.sInitInfo.bSpHiz		= psInitInfo->bSpHiz;
	gsGlobalInfo.sInitInfo.bLdo			= psInitInfo->bLdo;
	gsGlobalInfo.sInitInfo.bPad0Func	= psInitInfo->bPad0Func;
	gsGlobalInfo.sInitInfo.bPad1Func	= psInitInfo->bPad1Func;
	if(McDevProf_IsValid(eMCDRV_FUNC_PAD2) == 1)
	{
		gsGlobalInfo.sInitInfo.bPad2Func	= psInitInfo->bPad2Func;
	}
	else
	{
		gsGlobalInfo.sInitInfo.bPad2Func	= MCDRV_PAD_GPIO;
	}
	gsGlobalInfo.sInitInfo.bAvddLev		= psInitInfo->bAvddLev;
	gsGlobalInfo.sInitInfo.bVrefLev		= psInitInfo->bVrefLev;
	gsGlobalInfo.sInitInfo.bDclGain		= psInitInfo->bDclGain;
	gsGlobalInfo.sInitInfo.bDclLimit	= psInitInfo->bDclLimit;
	gsGlobalInfo.sInitInfo.bCpMod		= psInitInfo->bCpMod;
	gsGlobalInfo.sInitInfo.bReserved1	= psInitInfo->bReserved1;
	gsGlobalInfo.sInitInfo.bReserved2	= psInitInfo->bReserved2;
	gsGlobalInfo.sInitInfo.bReserved3	= psInitInfo->bReserved3;
	gsGlobalInfo.sInitInfo.bReserved4	= psInitInfo->bReserved4;
	gsGlobalInfo.sInitInfo.bReserved5	= psInitInfo->bReserved5;
	gsGlobalInfo.sInitInfo.sWaitTime	= psInitInfo->sWaitTime;

	InitPathInfo();
	InitVolInfo();
	InitDioInfo();
	InitDacInfo();
	InitAdcInfo();
	InitSpInfo();
	InitDngInfo();
	InitAeInfo();
	InitPdmInfo();
	InitGpMode();
	InitGpMask();
	InitSysEq();
	InitClockSwitch();

	McResCtrl_InitRegUpdate();

	gsGlobalInfo.eAPMode = eMCDRV_APM_OFF;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_Init", 0);
#endif
}

/****************************************************************************
 *	SetRegDefault
 *
 *	Description:
 *			Initialize the virtual registers.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetRegDefault
(
	void
)
{
	UINT16	i;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetRegDefault");
#endif

	for(i = 0; i < MCDRV_A_REG_NUM; i++)
	{
		gsGlobalInfo.abRegValA[i]	= 0;
	}
	gsGlobalInfo.abRegValA[MCI_RST]		= MCI_RST_DEF;
	gsGlobalInfo.abRegValA[MCI_HW_ID]	= MCI_HW_ID_DEF;

	for(i = 0; i < MCDRV_B_BASE_REG_NUM; i++)
	{
		gsGlobalInfo.abRegValB_BASE[i]	= 0;
	}
	gsGlobalInfo.abRegValB_BASE[MCI_RSTB]				= MCI_RSTB_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_PWM_DIGITAL]		= MCI_PWM_DIGITAL_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_PWM_DIGITAL_1]		= MCI_PWM_DIGITAL_1_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_PWM_DIGITAL_CDSP]	= MCI_PWM_DIGITAL_CDSP_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_PWM_DIGITAL_BDSP]	= MCI_PWM_DIGITAL_BDSP_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_SD_MSK]				= MCI_SD_MSK_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_SD_MSK_1]			= MCI_SD_MSK_1_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_BCLK_MSK]			= MCI_BCLK_MSK_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_BCLK_MSK_1]			= MCI_BCLK_MSK_1_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_BCKP]				= MCI_BCKP_DEF;
	gsGlobalInfo.abRegValB_BASE[MCI_PA_MSK]				= MCI_PA_MSK_DEF;

	for(i = 0; i < MCDRV_B_MIXER_REG_NUM; i++)
	{
		gsGlobalInfo.abRegValB_MIXER[i]	= 0;
	}
	gsGlobalInfo.abRegValB_MIXER[MCI_DIT_ININTP]	= MCI_DIT_ININTP_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DIR_INTP]		= MCI_DIR_INTP_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_ADC_INTP]		= MCI_ADC_INTP_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_AINTP]			= MCI_AINTP_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_IINTP]			= MCI_IINTP_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DAC_INTP]		= MCI_DAC_INTP_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DIR0_CH]		= MCI_DIR0_CH_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DIT0_SLOT]		= MCI_DIT0_SLOT_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_RX0]		= MCI_PCM_RX0_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_TX0]		= MCI_PCM_TX0_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_SLOT_TX0]	= MCI_PCM_SLOT_TX0_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DIR1_CH]		= MCI_DIR1_CH_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DIT1_SLOT]		= MCI_DIT1_SLOT_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_RX1]		= MCI_PCM_RX1_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_TX1]		= MCI_PCM_TX1_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_SLOT_TX1]	= MCI_PCM_SLOT_TX1_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DIR2_CH]		= MCI_DIR2_CH_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_DIT2_SLOT]		= MCI_DIT2_SLOT_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_RX2]		= MCI_PCM_RX2_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_TX2]		= MCI_PCM_TX2_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PCM_SLOT_TX2]	= MCI_PCM_SLOT_TX2_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_CDI_CH]		= MCI_CDI_CH_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_CDO_SLOT]		= MCI_CDO_SLOT_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PDM_AGC]		= MCI_PDM_AGC_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_PDM_STWAIT]	= MCI_PDM_STWAIT_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_CHP_H]			= MCI_CHP_H_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_CHP_M]			= MCI_CHP_M_DEF;
	gsGlobalInfo.abRegValB_MIXER[MCI_CHP_L]			= MCI_CHP_L_DEF;

	for(i = 0; i < MCDRV_B_AE_REG_NUM; i++)
	{
		gsGlobalInfo.abRegValB_AE[i]	= 0;
	}
	gsGlobalInfo.abRegValB_AE[MCI_BAND0_CEQ0]	= MCI_BAND0_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_BAND1_CEQ0]	= MCI_BAND1_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_BAND2_CEQ0]	= MCI_BAND2_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_BAND3H_CEQ0]	= MCI_BAND3H_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_BAND4H_CEQ0]	= MCI_BAND4H_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_BAND5_CEQ0]	= MCI_BAND5_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_BAND6H_CEQ0]	= MCI_BAND6H_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_BAND7H_CEQ0]	= MCI_BAND7H_CEQ0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP0_H]	= MCI_PDM_CHP0_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP0_M]	= MCI_PDM_CHP0_M_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP0_L]	= MCI_PDM_CHP0_L_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP1_H]	= MCI_PDM_CHP1_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP1_M]	= MCI_PDM_CHP1_M_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP1_L]	= MCI_PDM_CHP1_L_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP3_H]	= MCI_PDM_CHP3_H_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP3_M]	= MCI_PDM_CHP3_M_DEF;
	gsGlobalInfo.abRegValB_AE[MCI_PDM_CHP3_L]	= MCI_PDM_CHP3_L_DEF;

	for(i = 0; i < MCDRV_B_CDSP_REG_NUM; i++)
	{
		gsGlobalInfo.abRegValB_CDSP[i]	= 0;
	}
	gsGlobalInfo.abRegValB_CDSP[MCI_JOEMP]		= MCI_JOEMP_DEF;
	gsGlobalInfo.abRegValB_CDSP[MCI_JEEMP]		= MCI_JEEMP_DEF;
	gsGlobalInfo.abRegValB_CDSP[MCI_CDSP_SRST]	= MCI_CDSP_SRST_DEF;

	for(i = 0; i < MCDRV_B_ANA_REG_NUM; i++)
	{
		gsGlobalInfo.abRegValB_ANA[i]	= 0;
	}
	gsGlobalInfo.abRegValB_ANA[MCI_ANA_RST]			= MCI_ANA_RST_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_0]	= MCI_PWM_ANALOG_0_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_1]	= MCI_PWM_ANALOG_1_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_2]	= MCI_PWM_ANALOG_2_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_3]	= MCI_PWM_ANALOG_3_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_4]	= MCI_PWM_ANALOG_4_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_HPVOL_L]			= MCI_HPVOL_L_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_SPVOL_L]			= MCI_SPVOL_L_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_RCVOL]			= MCI_RCVOL_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_LEV]				= MCI_LEV_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGATRT_HP]		= MCI_DNGATRT_HP_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGTARGET_HP]	= MCI_DNGTARGET_HP_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGON_HP]		= MCI_DNGON_HP_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGATRT_SP]		= MCI_DNGATRT_SP_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGTARGET_SP]	= MCI_DNGTARGET_SP_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGON_SP]		= MCI_DNGON_SP_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGATRT_RC]		= MCI_DNGATRT_RC_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGTARGET_RC]	= MCI_DNGTARGET_RC_DEF;
	gsGlobalInfo.abRegValB_ANA[MCI_DNGON_RC]		= MCI_DNGON_RC_DEF;

	for(i = 0; i < MCDRV_B_CODEC_REG_NUM; i++)
	{
		gsGlobalInfo.abRegValB_CODEC[i]	= 0;
	}
	gsGlobalInfo.abRegValB_CODEC[MCI_DPADIF]		= MCI_DPADIF_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_PLL_RST]		= MCI_PLL_RST_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_DIVR0]			= MCI_DIVR0_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_DIVF0]			= MCI_DIVF0_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_DIVR1]			= MCI_DIVR1_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_DIVF1]			= MCI_DIVF1_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_AD_AGC]		= MCI_AD_AGC_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_DAC_CONFIG]	= MCI_DAC_CONFIG_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ0_19_12]= MCI_SYS_CEQ0_19_12_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ0_11_4]	= MCI_SYS_CEQ0_11_4_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ0_3_0]	= MCI_SYS_CEQ0_3_0_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ1_19_12]= MCI_SYS_CEQ1_19_12_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ1_11_4]	= MCI_SYS_CEQ1_11_4_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ1_3_0]	= MCI_SYS_CEQ1_3_0_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ2_19_12]= MCI_SYS_CEQ2_19_12_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ2_11_4]	= MCI_SYS_CEQ2_11_4_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ2_3_0]	= MCI_SYS_CEQ2_3_0_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ3_19_12]= MCI_SYS_CEQ3_19_12_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ3_11_4]	= MCI_SYS_CEQ3_11_4_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ3_3_0]	= MCI_SYS_CEQ3_3_0_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ4_19_12]= MCI_SYS_CEQ4_19_12_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ4_11_4]	= MCI_SYS_CEQ4_11_4_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYS_CEQ4_3_0]	= MCI_SYS_CEQ4_3_0_DEF;
	gsGlobalInfo.abRegValB_CODEC[MCI_SYSTEM_EQON]	= MCI_SYSTEM_EQON_DEF;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetRegDefault", 0);
#endif
}

/****************************************************************************
 *	InitPathInfo
 *
 *	Description:
 *			Initialize path info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitPathInfo
(
	void
)
{
	UINT8	bCh, bBlockIdx;
	UINT8	abOnOff[SOURCE_BLOCK_NUM];

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitPathInfo");
#endif

	abOnOff[0]	= (MCDRV_SRC0_MIC1_OFF|MCDRV_SRC0_MIC2_OFF|MCDRV_SRC0_MIC3_OFF);
	abOnOff[1]	= (MCDRV_SRC1_LINE1_L_OFF|MCDRV_SRC1_LINE1_R_OFF|MCDRV_SRC1_LINE1_M_OFF);
	abOnOff[2]	= (MCDRV_SRC2_LINE2_L_OFF|MCDRV_SRC2_LINE2_R_OFF|MCDRV_SRC2_LINE2_M_OFF);
	abOnOff[3]	= (MCDRV_SRC3_DIR0_OFF|MCDRV_SRC3_DIR1_OFF|MCDRV_SRC3_DIR2_OFF|MCDRV_SRC3_DIR2_DIRECT_OFF);
	abOnOff[4]	= (MCDRV_SRC4_DTMF_OFF|MCDRV_SRC4_PDM_OFF|MCDRV_SRC4_ADC0_OFF|MCDRV_SRC4_ADC1_OFF);
	abOnOff[5]	= (MCDRV_SRC5_DAC_L_OFF|MCDRV_SRC5_DAC_R_OFF|MCDRV_SRC5_DAC_M_OFF);
	abOnOff[6]	= (MCDRV_SRC6_MIX_OFF|MCDRV_SRC6_AE_OFF|MCDRV_SRC6_CDSP_OFF|MCDRV_SRC6_CDSP_DIRECT_OFF);

	for(bCh = 0; bCh < HP_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asHpOut[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < SP_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asSpOut[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < RC_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asRcOut[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < LOUT1_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asLout1[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < LOUT2_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asLout2[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < PEAK_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asPeak[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < DIT0_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asDit0[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < DIT1_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asDit1[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < DIT2_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asDit2[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < DAC_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < AE_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asAe[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < CDSP_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asCdsp[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < ADC0_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asAdc0[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < ADC1_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asAdc1[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < MIX_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asMix[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	for(bCh = 0; bCh < BIAS_PATH_CHANNELS; bCh++)
	{
		for(bBlockIdx = 0; bBlockIdx < SOURCE_BLOCK_NUM; bBlockIdx++)
		{
			gsGlobalInfo.sPathInfo.asBias[bCh].abSrcOnOff[bBlockIdx]	= abOnOff[bBlockIdx];
		}
	}
	gsGlobalInfo.sPathInfoVirtual	= gsGlobalInfo.sPathInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitPathInfo", 0);
#endif
}

/****************************************************************************
 *	InitVolInfo
 *
 *	Description:
 *			Initialize volume info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitVolInfo
(
	void
)
{
	UINT8	bCh;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitVolInfo");
#endif

	for(bCh = 0; bCh < AD0_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Ad0[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Ad1[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < AENG6_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Aeng6[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < PDM_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Pdm[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DTMF_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dtmfb[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dir0[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dir1[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dir2[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < AD0_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Ad0Att[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Ad1Att[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dir0Att[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dir1Att[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dir2Att[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < PDM_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_SideTone[bCh]	= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DTFM_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_DtmfAtt[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_DacMaster[bCh]	= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_DacVoice[bCh]	= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_DacAtt[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dit0[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dit1[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswD_Dit2[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < AD0_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Ad0[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Ad1[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < LIN1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Lin1[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < LIN2_VOL_CHANNELS; bCh++)	
	{
		gsGlobalInfo.sVolInfo.aswA_Lin2[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < MIC1_VOL_CHANNELS; bCh++)	
	{
		gsGlobalInfo.sVolInfo.aswA_Mic1[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < MIC2_VOL_CHANNELS; bCh++)	
	{
		gsGlobalInfo.sVolInfo.aswA_Mic2[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < MIC3_VOL_CHANNELS; bCh++)	
	{
		gsGlobalInfo.sVolInfo.aswA_Mic3[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < HP_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Hp[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < SP_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Sp[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < RC_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Rc[bCh]			= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < LOUT1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Lout1[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < LOUT2_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Lout2[bCh]		= MCDRV_LOGICAL_VOL_MUTE;
	}
	for(bCh = 0; bCh < MIC1_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Mic1Gain[bCh]	= MCDRV_LOGICAL_MICGAIN_DEF;
	}
	for(bCh = 0; bCh < MIC2_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Mic2Gain[bCh]	= MCDRV_LOGICAL_MICGAIN_DEF;
	}
	for(bCh = 0; bCh < MIC3_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_Mic3Gain[bCh]	= MCDRV_LOGICAL_MICGAIN_DEF;
	}
	for(bCh = 0; bCh < HPGAIN_VOL_CHANNELS; bCh++)
	{
		gsGlobalInfo.sVolInfo.aswA_HpGain[bCh]		= MCDRV_LOGICAL_HPGAIN_DEF;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitVolInfo", 0);
#endif
}

/****************************************************************************
 *	InitDioInfo
 *
 *	Description:
 *			Initialize Digital I/O info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitDioInfo
(
	void
)
{
	UINT8	bDioIdx, bDioCh;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitDioInfo");
#endif

	for(bDioIdx = 0; bDioIdx < 3; bDioIdx++)
	{
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bMasterSlave	= MCDRV_DIO_SLAVE;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bAutoFs		= MCDRV_AUTOFS_ON;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bFs			= MCDRV_FS_48000;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bBckFs			= MCDRV_BCKFS_64;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bInterface		= MCDRV_DIO_DA;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bBckInvert		= MCDRV_BCLK_NORMAL;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bPcmHizTim		= MCDRV_PCMHIZTIM_FALLING;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bPcmClkDown	= MCDRV_PCM_CLKDOWN_OFF;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bPcmFrame		= MCDRV_PCM_SHORTFRAME;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDioCommon.bPcmHighPeriod	= 0;

		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.wSrcRate				= 0x0000;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.sDaFormat.bBitSel	= MCDRV_BITSEL_16;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.sDaFormat.bMode		= MCDRV_DAMODE_HEADALIGN;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.sPcmFormat.bMono		= MCDRV_PCM_MONO;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.sPcmFormat.bOrder	= MCDRV_PCM_MSB_FIRST;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.sPcmFormat.bLaw		= MCDRV_PCM_LINEAR;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.sPcmFormat.bBitSel	= MCDRV_PCM_BITSEL_8;
		for(bDioCh = 0; bDioCh < DIO_CHANNELS; bDioCh++)
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDir.abSlot[bDioCh]	= bDioCh;
		}

		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.wSrcRate				= 0x0000;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.sDaFormat.bBitSel	= MCDRV_BITSEL_16;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.sDaFormat.bMode		= MCDRV_DAMODE_HEADALIGN;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.sPcmFormat.bMono		= MCDRV_PCM_MONO;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.sPcmFormat.bOrder	= MCDRV_PCM_MSB_FIRST;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.sPcmFormat.bLaw		= MCDRV_PCM_LINEAR;
		gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.sPcmFormat.bBitSel	= MCDRV_PCM_BITSEL_8;
		for(bDioCh = 0; bDioCh < DIO_CHANNELS; bDioCh++)
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bDioIdx].sDit.abSlot[bDioCh]	= bDioCh;
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitDioInfo", 0);
#endif
}

/****************************************************************************
 *	InitDacInfo
 *
 *	Description:
 *			Initialize Dac info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitDacInfo
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitDacInfo");
#endif

	gsGlobalInfo.sDacInfo.bMasterSwap	= MCDRV_DSWAP_OFF;
	gsGlobalInfo.sDacInfo.bVoiceSwap	= MCDRV_DSWAP_OFF;
	gsGlobalInfo.sDacInfo.bDcCut		= MCDRV_DCCUT_ON;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitDacInfo", 0);
#endif
}

/****************************************************************************
 *	InitAdcInfo
 *
 *	Description:
 *			Initialize Adc info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitAdcInfo
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitAdcInfo");
#endif

	gsGlobalInfo.sAdcInfo.bAgcAdjust	= MCDRV_AGCADJ_0;
	gsGlobalInfo.sAdcInfo.bAgcOn		= MCDRV_AGC_OFF;
	gsGlobalInfo.sAdcInfo.bMono			= MCDRV_ADC_STEREO;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitAdcInfo", 0);
#endif
}

/****************************************************************************
 *	InitSpInfo
 *
 *	Description:
 *			Initialize SP info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitSpInfo
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitSpInfo");
#endif

	gsGlobalInfo.sSpInfo.bSwap	= MCDRV_SPSWAP_OFF;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitSpInfo", 0);
#endif
}

/****************************************************************************
 *	InitDngInfo
 *
 *	Description:
 *			Initialize DNG info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitDngInfo
(
	void
)
{
	UINT8	bItem;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitDngInfo");
#endif

	for(bItem = MCDRV_DNG_ITEM_HP; bItem <= MCDRV_DNG_ITEM_RC; bItem++)
	{
		gsGlobalInfo.sDngInfo.abOnOff[bItem]		= MCDRV_DNG_OFF;
		gsGlobalInfo.sDngInfo.abThreshold[bItem]	= MCDRV_DNG_THRES_60;
		gsGlobalInfo.sDngInfo.abHold[bItem]		= MCDRV_DNG_HOLD_500;
		gsGlobalInfo.sDngInfo.abAttack[bItem]	= MCDRV_DNG_ATTACK_800;
		gsGlobalInfo.sDngInfo.abRelease[bItem]	= MCDRV_DNG_RELEASE_940;
		gsGlobalInfo.sDngInfo.abTarget[bItem]	= MCDRV_DNG_TARGET_MUTE;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitDngInfo", 0);
#endif
}

/****************************************************************************
 *	InitAeInfo
 *
 *	Description:
 *			Initialize Audio Engine info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitAeInfo
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitAeInfo");
#endif

	gsGlobalInfo.sAeInfo.bOnOff		= 0;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitAeInfo", 0);
#endif
}

/****************************************************************************
 *	InitPdmInfo
 *
 *	Description:
 *			Initialize Pdm info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitPdmInfo
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitPdmInfo");
#endif

	gsGlobalInfo.sPdmInfo.bClk			= MCDRV_PDM_CLK_64;
	gsGlobalInfo.sPdmInfo.bAgcAdjust	= MCDRV_AGCADJ_0;
	gsGlobalInfo.sPdmInfo.bAgcOn		= MCDRV_AGC_OFF;
	gsGlobalInfo.sPdmInfo.bPdmEdge		= MCDRV_PDMEDGE_LH;
	gsGlobalInfo.sPdmInfo.bPdmWait		= MCDRV_PDMWAIT_10;
	gsGlobalInfo.sPdmInfo.bPdmSel		= MCDRV_PDMSEL_L1R2;
	gsGlobalInfo.sPdmInfo.bMono			= MCDRV_PDM_STEREO;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitPdmInfo", 0);
#endif
}

/****************************************************************************
 *	InitGpMode
 *
 *	Description:
 *			Initialize Gp mode.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitGpMode
(
	void
)
{
	UINT8	bGpioIdx;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitGpMode");
#endif

	for(bGpioIdx = 0; bGpioIdx < GPIO_PAD_NUM; bGpioIdx++)
	{
		gsGlobalInfo.sGpMode.abGpDdr[bGpioIdx]		= MCDRV_GPDDR_IN;
		gsGlobalInfo.sGpMode.abGpMode[bGpioIdx]		= MCDRV_GPMODE_RISING;
		gsGlobalInfo.sGpMode.abGpHost[bGpioIdx]		= MCDRV_GPHOST_SCU;
		gsGlobalInfo.sGpMode.abGpInvert[bGpioIdx]	= MCDRV_GPINV_NORMAL;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitGpMode", 0);
#endif
}

/****************************************************************************
 *	InitGpMask
 *
 *	Description:
 *			Initialize Gp mask.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitGpMask
(
	void
)
{
	UINT8	bGpioIdx;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitGpMask");
#endif

	for(bGpioIdx = 0; bGpioIdx < GPIO_PAD_NUM; bGpioIdx++)
	{
		gsGlobalInfo.abGpMask[bGpioIdx]		= MCDRV_GPMASK_ON;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitGpMask", 0);
#endif
}

/****************************************************************************
 *	InitSysEq
 *
 *	Description:
 *			Initialize System EQ.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitSysEq
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitSysEq");
#endif

	gsGlobalInfo.sSysEq.bOnOff		= MCDRV_SYSEQ_ON;
	gsGlobalInfo.sSysEq.abParam[0]	= 0x10;
	gsGlobalInfo.sSysEq.abParam[1]	= 0xC4;
	gsGlobalInfo.sSysEq.abParam[2]	= 0x50;
	gsGlobalInfo.sSysEq.abParam[3]	= 0x12;
	gsGlobalInfo.sSysEq.abParam[4]	= 0xC4;
	gsGlobalInfo.sSysEq.abParam[5]	= 0x40;
	gsGlobalInfo.sSysEq.abParam[6]	= 0x02;
	gsGlobalInfo.sSysEq.abParam[7]	= 0xA9;
	gsGlobalInfo.sSysEq.abParam[8]	= 0x60;
	gsGlobalInfo.sSysEq.abParam[9]	= 0xED;
	gsGlobalInfo.sSysEq.abParam[10]	= 0x3B;
	gsGlobalInfo.sSysEq.abParam[11]	= 0xC0;
	gsGlobalInfo.sSysEq.abParam[12]	= 0xFC;
	gsGlobalInfo.sSysEq.abParam[13]	= 0x92;
	gsGlobalInfo.sSysEq.abParam[14]	= 0x40;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitSysEq", 0);
#endif
}

/****************************************************************************
 *	InitClockSwitch
 *
 *	Description:
 *			Initialize switch clock info.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	InitClockSwitch
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("InitClockSwitch");
#endif

	gsGlobalInfo.sClockSwitch.bClkSrc	= MCDRV_CLKSW_CLKI0;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("InitClockSwitch", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_UpdateState
 *
 *	Description:
 *			update state.
 *	Arguments:
 *			eState	state
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_UpdateState
(
	MCDRV_STATE	eState
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_UpdateState");
#endif

	geState = eState;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_UpdateState", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetState
 *
 *	Description:
 *			Get state.
 *	Arguments:
 *			none
 *	Return:
 *			current state
 *
 ****************************************************************************/
MCDRV_STATE	McResCtrl_GetState
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet	= geState;
	McDebugLog_FuncIn("McResCtrl_GetState");
#endif

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetState", &sdRet);
#endif

	return geState;
}

/****************************************************************************
 *	McResCtrl_GetRegVal
 *
 *	Description:
 *			Get register value.
 *	Arguments:
 *			wRegType	register type
 *			wRegAddr	address
 *	Return:
 *			register value
 *
 ****************************************************************************/
UINT8	McResCtrl_GetRegVal
(
	UINT16	wRegType,
	UINT16	wRegAddr
)
{
	UINT8	bVal	= 0;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_GetRegVal");
#endif

	switch(wRegType)
	{
	case	MCDRV_PACKET_REGTYPE_A:
		bVal	= gsGlobalInfo.abRegValA[wRegAddr];
		break;
	case	MCDRV_PACKET_REGTYPE_B_BASE:
		bVal	= gsGlobalInfo.abRegValB_BASE[wRegAddr];
		break;
	case	MCDRV_PACKET_REGTYPE_B_MIXER:
		bVal	= gsGlobalInfo.abRegValB_MIXER[wRegAddr];
		break;
	case	MCDRV_PACKET_REGTYPE_B_AE:
		bVal	= gsGlobalInfo.abRegValB_AE[wRegAddr];
		break;
	case	MCDRV_PACKET_REGTYPE_B_CDSP:
		bVal	= gsGlobalInfo.abRegValB_CDSP[wRegAddr];
		break;
	case	MCDRV_PACKET_REGTYPE_B_CODEC:
		bVal	= gsGlobalInfo.abRegValB_CODEC[wRegAddr];
		break;
	case	MCDRV_PACKET_REGTYPE_B_ANA:
		bVal	= gsGlobalInfo.abRegValB_ANA[wRegAddr];
		break;
	default:
		break;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= (SINT32)bVal;
	McDebugLog_FuncOut("McResCtrl_GetRegVal", &sdRet);
#endif

	return bVal;
}

/****************************************************************************
 *	McResCtrl_SetRegVal
 *
 *	Description:
 *			Set register value.
 *	Arguments:
 *			wRegType	register type
 *			wRegAddr	address
 *			bRegVal		register value
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetRegVal
(
	UINT16	wRegType,
	UINT16	wRegAddr,
	UINT8	bRegVal
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetRegVal");
#endif

	switch(wRegType)
	{
	case	MCDRV_PACKET_REGTYPE_A:
		gsGlobalInfo.abRegValA[wRegAddr]		= bRegVal;
		break;
	case	MCDRV_PACKET_REGTYPE_B_BASE:
		gsGlobalInfo.abRegValB_BASE[wRegAddr]	= bRegVal;
		break;
	case	MCDRV_PACKET_REGTYPE_B_MIXER:
		gsGlobalInfo.abRegValB_MIXER[wRegAddr]	= bRegVal;
		break;
	case	MCDRV_PACKET_REGTYPE_B_AE:
		gsGlobalInfo.abRegValB_AE[wRegAddr]		= bRegVal;
		break;
	case	MCDRV_PACKET_REGTYPE_B_CDSP:
		gsGlobalInfo.abRegValB_CDSP[wRegAddr]	= bRegVal;
		break;
	case	MCDRV_PACKET_REGTYPE_B_CODEC:
		gsGlobalInfo.abRegValB_CODEC[wRegAddr]	= bRegVal;
		break;
	case	MCDRV_PACKET_REGTYPE_B_ANA:
		gsGlobalInfo.abRegValB_ANA[wRegAddr]	= bRegVal;
		break;
	default:
		break;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetRegVal", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetInitInfo
 *
 *	Description:
 *			Get Initialize information.
 *	Arguments:
 *			psInitInfo	Initialize information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetInitInfo
(
	MCDRV_INIT_INFO*	psInitInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetInitInfo");
#endif

	*psInitInfo	= gsGlobalInfo.sInitInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetInitInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetClockInfo
 *
 *	Description:
 *			Set clock information.
 *	Arguments:
 *			psClockInfo	clock information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetClockInfo
(
	const MCDRV_CLOCK_INFO* psClockInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetClockInfo");
#endif


	gsGlobalInfo.sInitInfo.bCkSel	= psClockInfo->bCkSel;
	gsGlobalInfo.sInitInfo.bDivR0	= psClockInfo->bDivR0;
	gsGlobalInfo.sInitInfo.bDivF0	= psClockInfo->bDivF0;
	gsGlobalInfo.sInitInfo.bDivR1	= psClockInfo->bDivR1;
	gsGlobalInfo.sInitInfo.bDivF1	= psClockInfo->bDivF1;
	if(McDevProf_IsValid(eMCDRV_FUNC_RANGE) == 1)
	{
		gsGlobalInfo.sInitInfo.bRange0	= psClockInfo->bRange0;
		gsGlobalInfo.sInitInfo.bRange1	= psClockInfo->bRange1;
	}
	if(McDevProf_IsValid(eMCDRV_FUNC_BYPASS) == 1)
	{
		gsGlobalInfo.sInitInfo.bBypass	= psClockInfo->bBypass;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetClockInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetPathInfo
 *
 *	Description:
 *			Set path information.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetPathInfo
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetPathInfo");
#endif


	gsGlobalInfo.sPathInfo	= gsGlobalInfo.sPathInfoVirtual;

	/*	HP source on/off	*/
	SetHPSourceOnOff(psPathInfo);

	/*	SP source on/off	*/
	SetSPSourceOnOff(psPathInfo);

	/*	RCV source on/off	*/
	SetRCVSourceOnOff(psPathInfo);

	/*	LOut1 source on/off	*/
	SetLO1SourceOnOff(psPathInfo);

	/*	LOut2 source on/off	*/
	SetLO2SourceOnOff(psPathInfo);

	/*	Peak source on/off	*/
	SetPMSourceOnOff(psPathInfo);

	/*	DIT0 source on/off	*/
	SetDIT0SourceOnOff(psPathInfo);

	/*	DIT1 source on/off	*/
	SetDIT1SourceOnOff(psPathInfo);

	/*	DIT2 source on/off	*/
	SetDIT2SourceOnOff(psPathInfo);

	/*	DAC source on/off	*/
	SetDACSourceOnOff(psPathInfo);

	/*	AE source on/off	*/
	SetAESourceOnOff(psPathInfo);

	/*	CDSP source on/off	*/
	SetCDSPSourceOnOff(psPathInfo);

	/*	ADC0 source on/off	*/
	SetADC0SourceOnOff(psPathInfo);

	/*	ADC1 source on/off	*/
	SetADC1SourceOnOff(psPathInfo);

	/*	Mix source on/off	*/
	SetMixSourceOnOff(psPathInfo);

	/*	Bias source on/off	*/
	SetBiasSourceOnOff(psPathInfo);

	gsGlobalInfo.sPathInfoVirtual	= gsGlobalInfo.sPathInfo;

	ValidateADC();
	ValidateDAC();

	ValidateAE();
	ValidateMix();
	ValidateAE();

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetPathInfo", 0);
#endif
}

/****************************************************************************
 *	ValidateADC
 *
 *	Description:
 *			Validate ADC setting.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	ValidateADC
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("ValidateADC");
#endif

	if((McResCtrl_IsDstUsed(eMCDRV_DST_ADC0, eMCDRV_DST_CH0) == 0)
	&& (McResCtrl_IsDstUsed(eMCDRV_DST_ADC0, eMCDRV_DST_CH1) == 0))
	{/*	ADC0 source all off	*/
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]		&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]		|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
	}

	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_ADC0) == 0)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]		&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]		&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]		&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]		&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]		&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]		&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;

		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]		|= MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]		|= MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]		|= MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]		|= MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]		|= MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]		|= MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("ValidateADC", 0);
#endif
}

/****************************************************************************
 *	ValidateDAC
 *
 *	Description:
 *			Validate DAC setting.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	ValidateDAC
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("ValidateDAC");
#endif

	if((McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_L) == 0)
	&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_M) == 0)
	&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_R) == 0))
	{/*	DAC is unused	*/
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]		&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]		&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]		|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		|= MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]		|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		|= MCDRV_SRC6_MIX_OFF;

		ValidateADC();
	}

	if((McResCtrl_GetDACSource(eMCDRV_DAC_MASTER) == eMCDRV_SRC_NONE)
	&& (McResCtrl_GetDACSource(eMCDRV_DAC_VOICE) == eMCDRV_SRC_NONE))
	{/*	DAC source all off	*/
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("ValidateDAC", 0);
#endif
}

/****************************************************************************
 *	VlidateAE
 *
 *	Description:
 *			Validate AE path setting.
 *	Arguments:
 *			eCh	AE path channel
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	ValidateAE
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("ValidateAE");
#endif

	if(McResCtrl_GetAESource() == eMCDRV_SRC_NONE)
	{/*	AE source all off	*/
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;

		ValidateDAC();
	}
	else if(McResCtrl_IsSrcUsed(eMCDRV_SRC_AE) == 0)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else
	{
	}

	ValidateMix();

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("ValidateAE", 0);
#endif
}

/****************************************************************************
 *	ValidateMix
 *
 *	Description:
 *			Validate Mix path setting.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	ValidateMix
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("ValidateMix");
#endif

	if(McResCtrl_IsDstUsed(eMCDRV_DST_MIX, eMCDRV_DST_CH0) == 0)
	{/*	MIX source all off	*/
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		|= MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		|= MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]		|= MCDRV_SRC6_MIX_OFF;

		ValidateDAC();
	}
	else if(McResCtrl_IsSrcUsed(eMCDRV_SRC_MIX) == 0)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]		&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]		|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("ValidateMix", 0);
#endif
}

/****************************************************************************
 *	SetHPSourceOnOff
 *
 *	Description:
 *			Set HP source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetHPSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetHPSourceOnOff");
#endif

	if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_ON;
	}
	else if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_ON;
	}
	else if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_ON;
	}
	else if((psPathInfo->asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_ON;
	}
	else if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_ON;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_OFF;
	}
	else
	{
	}

	if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_ON)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_ON;
	}
	else if((psPathInfo->asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetHPSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetSPSourceOnOff
 *
 *	Description:
 *			Set SP source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetSPSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetSPSourceOnOff");
#endif

	if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_ON;
	}
	else if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_ON;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_ON;
	}
	else if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_ON;
	}
	else if((psPathInfo->asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_ON;
	}
	else if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_ON;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_OFF;
	}
	else
	{
	}

	if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_ON;
	}
	else if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
	}
	else
	{
	}

	if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_ON)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_ON;
	}
	else if((psPathInfo->asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetSPSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetRCVSourceOnOff
 *
 *	Description:
 *			Set RCV source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetRCVSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetRCVSourceOnOff");
#endif

	if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_ON)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_ON;
	}
	else if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_ON)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_ON;
	}
	else if((psPathInfo->asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetRCVSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetLO1SourceOnOff
 *
 *	Description:
 *			Set LOut1 source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetLO1SourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetLO1SourceOnOff");
#endif

	if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_ON;
	}
	else if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_ON;
	}
	else if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_ON;
	}
	else if((psPathInfo->asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_OFF;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_ON;
	}
	else if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_ON;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_ON)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_ON;
	}
	else if((psPathInfo->asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetLO1SourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetLO2SourceOnOff
 *
 *	Description:
 *			Set LOut2 source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetLO2SourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetLO2SourceOnOff");
#endif

	if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_ON;
	}
	else if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_ON;
	}
	else if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & (MCDRV_SRC5_DAC_L_ON|MCDRV_SRC5_DAC_L_OFF)) == MCDRV_SRC5_DAC_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_L_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK]	|= MCDRV_SRC5_DAC_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_OFF;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_ON;
	}
	else if((psPathInfo->asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & (MCDRV_SRC5_DAC_M_ON|MCDRV_SRC5_DAC_M_OFF)) == MCDRV_SRC5_DAC_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_M_ON;
		gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK]	|= MCDRV_SRC5_DAC_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_OFF;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_ON;
	}
	else if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_ON;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_OFF;
	}
	else
	{
	}

	if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_ON)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_OFF;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_ON;
	}
	else if((psPathInfo->asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & (MCDRV_SRC5_DAC_R_ON|MCDRV_SRC5_DAC_R_OFF)) == MCDRV_SRC5_DAC_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	&= (UINT8)~MCDRV_SRC5_DAC_R_ON;
		gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK]	|= MCDRV_SRC5_DAC_R_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetLO2SourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetPMSourceOnOff
 *
 *	Description:
 *			Set PeakMeter source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetPMSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetPMSourceOnOff");
#endif

	(void)psPathInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetPMSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetDIT0SourceOnOff
 *
 *	Description:
 *			Set DIT0 source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetDIT0SourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetDIT0SourceOnOff");
#endif

	if(((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_ON)
	&& (gsGlobalInfo.sInitInfo.bPad0Func == MCDRV_PAD_PDMCK))
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_ON)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_ON)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_ON)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_ON)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_ON)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_ON)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_ON;
	}
	else if((psPathInfo->asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetDIT0SourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetDIT1SourceOnOff
 *
 *	Description:
 *			Set DIT1 source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetDIT1SourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetDIT1SourceOnOff");
#endif

	if(((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_ON)
	&& (gsGlobalInfo.sInitInfo.bPad0Func == MCDRV_PAD_PDMCK))
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_ON)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_ON)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_ON)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_ON)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_ON)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_ON)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_ON;
	}
	else if((psPathInfo->asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetDIT1SourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetDIT2SourceOnOff
 *
 *	Description:
 *			Set DIT2 source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetDIT2SourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetDIT2SourceOnOff");
#endif

	if(((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_ON)
	&& (gsGlobalInfo.sInitInfo.bPad0Func == MCDRV_PAD_PDMCK))
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_ON)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_ON)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_ON)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_ON)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_ON)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
	}
	else
	{
	}

	if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_ON)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]		|= MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_ON;
	}
	else if((psPathInfo->asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_OFF)
	{
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetDIT2SourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetDACSourceOnOff
 *
 *	Description:
 *			Set DAC source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetDACSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
	UINT8	bCh;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetDACSourceOnOff");
#endif

	for(bCh = 0; bCh < DAC_PATH_CHANNELS; bCh++)
	{
		if(((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_ON)
		&& (gsGlobalInfo.sInitInfo.bPad0Func == MCDRV_PAD_PDMCK))
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		}
		else if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_OFF)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		}
		else
		{
		}

		if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_ON)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		}
		else if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_OFF)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		}
		else
		{
		}

		if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_ON)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		}
		else if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_OFF)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		}
		else
		{
		}

		if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_ON)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		}
		else if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_OFF)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		}
		else
		{
		}

		if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_ON)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		}
		else if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_OFF)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		}
		else
		{
		}

		if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_ON)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		}
		else if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_OFF)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
		}
		else
		{
		}

		if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_ON)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_OFF;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_ON;
		}
		else if((psPathInfo->asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_OFF)
		{
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
			gsGlobalInfo.sPathInfo.asDac[bCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
		}
		else
		{
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetDACSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetAESourceOnOff
 *
 *	Description:
 *			Set AE source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetAESourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetAESourceOnOff");
#endif

	if(((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_ON)
	&& (gsGlobalInfo.sInitInfo.bPad0Func == MCDRV_PAD_PDMCK))
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_OFF)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_ON)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_OFF)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_ON)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_OFF)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_ON)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_OFF)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_ON)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_OFF)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_ON)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_OFF;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_ON;
	}
	else if((psPathInfo->asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & (MCDRV_SRC6_MIX_ON|MCDRV_SRC6_MIX_OFF)) == MCDRV_SRC6_MIX_OFF)
	{
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	&= (UINT8)~MCDRV_SRC6_MIX_ON;
		gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK]	|= MCDRV_SRC6_MIX_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetAESourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetCDSPSourceOnOff
 *
 *	Description:
 *			Set CDSP source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetCDSPSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetCDSPSourceOnOff");
#endif

	(void)psPathInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetCDSPSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetADC0SourceOnOff
 *
 *	Description:
 *			Set ADC0 source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetADC0SourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetADC0SourceOnOff");
#endif

	if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_ON;
	}
	else if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & (MCDRV_SRC1_LINE1_L_ON|MCDRV_SRC1_LINE1_L_OFF)) == MCDRV_SRC1_LINE1_L_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_L_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK]	|= MCDRV_SRC1_LINE1_L_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_ON;
	}
	else if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & (MCDRV_SRC1_LINE1_R_ON|MCDRV_SRC1_LINE1_R_OFF)) == MCDRV_SRC1_LINE1_R_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_R_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK]	|= MCDRV_SRC1_LINE1_R_OFF;
	}
	else
	{
	}

	if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_ON)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_OFF;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_ON;
	}
	else if((psPathInfo->asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & (MCDRV_SRC1_LINE1_M_ON|MCDRV_SRC1_LINE1_M_OFF)) == MCDRV_SRC1_LINE1_M_OFF)
	{
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	&= (UINT8)~MCDRV_SRC1_LINE1_M_ON;
		gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK]	|= MCDRV_SRC1_LINE1_M_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetADC0SourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetADC1SourceOnOff
 *
 *	Description:
 *			Set ADC1 source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetADC1SourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetADC1SourceOnOff");
#endif

	(void)psPathInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetADC1SourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetMixSourceOnOff
 *
 *	Description:
 *			Set Mix source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetMixSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetMixSourceOnOff");
#endif

	if(((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_ON)
	&& (gsGlobalInfo.sInitInfo.bPad0Func == MCDRV_PAD_PDMCK))
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_ON;
	}
	else if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & (MCDRV_SRC4_PDM_ON|MCDRV_SRC4_PDM_OFF)) == MCDRV_SRC4_PDM_OFF)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	&= (UINT8)~MCDRV_SRC4_PDM_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK]	|= MCDRV_SRC4_PDM_OFF;
	}
	else
	{
	}

	if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_ON)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_ON;
	}
	else if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & (MCDRV_SRC4_ADC0_ON|MCDRV_SRC4_ADC0_OFF)) == MCDRV_SRC4_ADC0_OFF)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	&= (UINT8)~MCDRV_SRC4_ADC0_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK]	|= MCDRV_SRC4_ADC0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_ON)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_ON;
	}
	else if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & (MCDRV_SRC3_DIR0_ON|MCDRV_SRC3_DIR0_OFF)) == MCDRV_SRC3_DIR0_OFF)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR0_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK]	|= MCDRV_SRC3_DIR0_OFF;
	}
	else
	{
	}

	if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_ON)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_ON;
	}
	else if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & (MCDRV_SRC3_DIR1_ON|MCDRV_SRC3_DIR1_OFF)) == MCDRV_SRC3_DIR1_OFF)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR1_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK]	|= MCDRV_SRC3_DIR1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_ON)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_ON;
	}
	else if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & (MCDRV_SRC3_DIR2_ON|MCDRV_SRC3_DIR2_OFF)) == MCDRV_SRC3_DIR2_OFF)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	&= (UINT8)~MCDRV_SRC3_DIR2_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK]	|= MCDRV_SRC3_DIR2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_ON)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_OFF;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_ON;
	}
	else if((psPathInfo->asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & (MCDRV_SRC6_AE_ON|MCDRV_SRC6_AE_OFF)) == MCDRV_SRC6_AE_OFF)
	{
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	&= (UINT8)~MCDRV_SRC6_AE_ON;
		gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK]	|= MCDRV_SRC6_AE_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetMixSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	SetExtBiasOnOff
 *
 *	Description:
 *			Set Bias source On/Off.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetBiasSourceOnOff
(
	const MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetBiasSourceOnOff");
#endif

	if((psPathInfo->asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_ON)
	{
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_OFF;
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_ON;
	}
	else if((psPathInfo->asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & (MCDRV_SRC0_MIC1_ON|MCDRV_SRC0_MIC1_OFF)) == MCDRV_SRC0_MIC1_OFF)
	{
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC1_ON;
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK]	|= MCDRV_SRC0_MIC1_OFF;
	}
	else
	{
	}

	if((psPathInfo->asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_ON)
	{
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_OFF;
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_ON;
	}
	else if((psPathInfo->asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & (MCDRV_SRC0_MIC2_ON|MCDRV_SRC0_MIC2_OFF)) == MCDRV_SRC0_MIC2_OFF)
	{
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC2_ON;
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK]	|= MCDRV_SRC0_MIC2_OFF;
	}
	else
	{
	}

	if((psPathInfo->asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_ON)
	{
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_OFF;
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_ON;
	}
	else if((psPathInfo->asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & (MCDRV_SRC0_MIC3_ON|MCDRV_SRC0_MIC3_OFF)) == MCDRV_SRC0_MIC3_OFF)
	{
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	&= (UINT8)~MCDRV_SRC0_MIC3_ON;
		gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK]	|= MCDRV_SRC0_MIC3_OFF;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetBiasSourceOnOff", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetPathInfo
 *
 *	Description:
 *			Get path information.
 *	Arguments:
 *			psPathInfo	path information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetPathInfo
(
	MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetPathInfo");
#endif

	*psPathInfo	= gsGlobalInfo.sPathInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetPathInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetPathInfoVirtual
 *
 *	Description:
 *			Get virtaul path information.
 *	Arguments:
 *			psPathInfo	virtaul path information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetPathInfoVirtual
(
	MCDRV_PATH_INFO*	psPathInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetPathInfoVirtual");
#endif

	*psPathInfo	= gsGlobalInfo.sPathInfoVirtual;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetPathInfoVirtual", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetDioInfo
 *
 *	Description:
 *			Set digital io information.
 *	Arguments:
 *			psDioInfo	digital io information
 *			dUpdateInfo	update information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetDioInfo
(
	const MCDRV_DIO_INFO*	psDioInfo,
	UINT32	dUpdateInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetDioInfo");
#endif


	if((dUpdateInfo & MCDRV_DIO0_COM_UPDATE_FLAG) != 0UL)
	{
		SetDIOCommon(psDioInfo, 0);
	}
	if((dUpdateInfo & MCDRV_DIO1_COM_UPDATE_FLAG) != 0UL)
	{
		SetDIOCommon(psDioInfo, 1);
	}
	if((dUpdateInfo & MCDRV_DIO2_COM_UPDATE_FLAG) != 0UL)
	{
		SetDIOCommon(psDioInfo, 2);
	}

	if((dUpdateInfo & MCDRV_DIO0_DIR_UPDATE_FLAG) != 0UL)
	{
		SetDIODIR(psDioInfo, 0);
	}
	if((dUpdateInfo & MCDRV_DIO1_DIR_UPDATE_FLAG) != 0UL)
	{
		SetDIODIR(psDioInfo, 1);
	}
	if((dUpdateInfo & MCDRV_DIO2_DIR_UPDATE_FLAG) != 0UL)
	{
		SetDIODIR(psDioInfo, 2);
	}

	if((dUpdateInfo & MCDRV_DIO0_DIT_UPDATE_FLAG) != 0UL)
	{
		SetDIODIT(psDioInfo, 0);
	}
	if((dUpdateInfo & MCDRV_DIO1_DIT_UPDATE_FLAG) != 0UL)
	{
		SetDIODIT(psDioInfo, 1);
	}
	if((dUpdateInfo & MCDRV_DIO2_DIT_UPDATE_FLAG) != 0UL)
	{
		SetDIODIT(psDioInfo, 2);
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetDioInfo", 0);
#endif
}

/****************************************************************************
 *	SetDIOCommon
 *
 *	Description:
 *			Set digital io common information.
 *	Arguments:
 *			psDioInfo	digital io information
 *			bPort		port number
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetDIOCommon
(
	const MCDRV_DIO_INFO*	psDioInfo,
	UINT8	bPort
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetDIOCommon");
#endif

	if((psDioInfo->asPortInfo[bPort].sDioCommon.bMasterSlave == MCDRV_DIO_SLAVE)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bMasterSlave == MCDRV_DIO_MASTER))
	{
		gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bMasterSlave	= psDioInfo->asPortInfo[bPort].sDioCommon.bMasterSlave;
	}
	if((psDioInfo->asPortInfo[bPort].sDioCommon.bAutoFs == MCDRV_AUTOFS_OFF)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bAutoFs == MCDRV_AUTOFS_ON))
	{
		gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bAutoFs	= psDioInfo->asPortInfo[bPort].sDioCommon.bAutoFs;
	}
	if((psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_48000)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_44100)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_32000)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_24000)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_22050)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_16000)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_12000)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_11025)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bFs == MCDRV_FS_8000))
	{
		gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bFs	= psDioInfo->asPortInfo[bPort].sDioCommon.bFs;
	}
	if((psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs == MCDRV_BCKFS_64)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs == MCDRV_BCKFS_48)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs == MCDRV_BCKFS_32)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs == MCDRV_BCKFS_512)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs == MCDRV_BCKFS_256)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs == MCDRV_BCKFS_128)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs == MCDRV_BCKFS_16))
	{
		gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bBckFs	= psDioInfo->asPortInfo[bPort].sDioCommon.bBckFs;
	}
	if((psDioInfo->asPortInfo[bPort].sDioCommon.bInterface == MCDRV_DIO_DA)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bInterface == MCDRV_DIO_PCM))
	{
		gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bInterface	= psDioInfo->asPortInfo[bPort].sDioCommon.bInterface;
	}
	if((psDioInfo->asPortInfo[bPort].sDioCommon.bBckInvert == MCDRV_BCLK_NORMAL)
	|| (psDioInfo->asPortInfo[bPort].sDioCommon.bBckInvert == MCDRV_BCLK_INVERT))
	{
		gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bBckInvert	= psDioInfo->asPortInfo[bPort].sDioCommon.bBckInvert;
	}
	if(psDioInfo->asPortInfo[bPort].sDioCommon.bInterface == MCDRV_DIO_PCM)
	{
		if((psDioInfo->asPortInfo[bPort].sDioCommon.bPcmHizTim == MCDRV_PCMHIZTIM_FALLING)
		|| (psDioInfo->asPortInfo[bPort].sDioCommon.bPcmHizTim == MCDRV_PCMHIZTIM_RISING))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bPcmHizTim	= psDioInfo->asPortInfo[bPort].sDioCommon.bPcmHizTim;
		}
		if((psDioInfo->asPortInfo[bPort].sDioCommon.bPcmClkDown == MCDRV_PCM_CLKDOWN_OFF)
		|| (psDioInfo->asPortInfo[bPort].sDioCommon.bPcmClkDown == MCDRV_PCM_CLKDOWN_HALF))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bPcmClkDown	= psDioInfo->asPortInfo[bPort].sDioCommon.bPcmClkDown;
		}
		if((psDioInfo->asPortInfo[bPort].sDioCommon.bPcmFrame == MCDRV_PCM_SHORTFRAME)
		|| (psDioInfo->asPortInfo[bPort].sDioCommon.bPcmFrame == MCDRV_PCM_LONGFRAME))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bPcmFrame	= psDioInfo->asPortInfo[bPort].sDioCommon.bPcmFrame;
		}
		if(psDioInfo->asPortInfo[bPort].sDioCommon.bPcmHighPeriod <= 31)
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bPcmHighPeriod	= psDioInfo->asPortInfo[bPort].sDioCommon.bPcmHighPeriod;
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetDIOCommon", 0);
#endif
}

/****************************************************************************
 *	SetDIODIR
 *
 *	Description:
 *			Set digital io dir information.
 *	Arguments:
 *			psDioInfo	digital io information
 *			bPort		port number
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetDIODIR
(
	const MCDRV_DIO_INFO*	psDioInfo,
	UINT8	bPort
)
{
	UINT8	bDIOCh;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetDIODIR");
#endif

	gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.wSrcRate	= psDioInfo->asPortInfo[bPort].sDir.wSrcRate;
	if(gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bInterface == MCDRV_DIO_DA)
	{
		if((psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bBitSel == MCDRV_BITSEL_16)
		|| (psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bBitSel == MCDRV_BITSEL_20)
		|| (psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bBitSel == MCDRV_BITSEL_24))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.sDaFormat.bBitSel	= psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bBitSel;
		}
		if((psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bMode == MCDRV_DAMODE_HEADALIGN)
		|| (psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bMode == MCDRV_DAMODE_I2S)
		|| (psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bMode == MCDRV_DAMODE_TAILALIGN))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.sDaFormat.bMode	= psDioInfo->asPortInfo[bPort].sDir.sDaFormat.bMode;
		}
	}
	else if(gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bInterface == MCDRV_DIO_PCM)
	{
		if((psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bMono == MCDRV_PCM_STEREO)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bMono == MCDRV_PCM_MONO))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.sPcmFormat.bMono	= psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bMono;
		}
		if((psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bOrder == MCDRV_PCM_MSB_FIRST)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bOrder == MCDRV_PCM_LSB_FIRST)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bOrder == MCDRV_PCM_MSB_FIRST_SIGN)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bOrder == MCDRV_PCM_LSB_FIRST_SIGN)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bOrder == MCDRV_PCM_MSB_FIRST_ZERO)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bOrder == MCDRV_PCM_LSB_FIRST_ZERO))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.sPcmFormat.bOrder	= psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bOrder;
		}
		if((psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bLaw == MCDRV_PCM_LINEAR)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bLaw == MCDRV_PCM_ALAW)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bLaw == MCDRV_PCM_MULAW))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.sPcmFormat.bLaw	= psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bLaw;
		}
		if((psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_8)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_13)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_14)
		|| (psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_16))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.sPcmFormat.bBitSel	= psDioInfo->asPortInfo[bPort].sDir.sPcmFormat.bBitSel;
		}
	}
	else
	{
	}

	for(bDIOCh = 0; bDIOCh < DIO_CHANNELS; bDIOCh++)
	{
		if(psDioInfo->asPortInfo[bPort].sDir.abSlot[bDIOCh] < 2)
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDir.abSlot[bDIOCh]	= psDioInfo->asPortInfo[bPort].sDir.abSlot[bDIOCh];
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetDIODIR", 0);
#endif
}

/****************************************************************************
 *	SetDIODIT
 *
 *	Description:
 *			Set digital io dit information.
 *	Arguments:
 *			psDioInfo	digital io information
 *			bPort		port number
 *	Return:
 *			none
 *
 ****************************************************************************/
static void	SetDIODIT
(
	const MCDRV_DIO_INFO*	psDioInfo,
	UINT8	bPort
)
{
	UINT8	bDIOCh;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("SetDIODIT");
#endif

	gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.wSrcRate	= psDioInfo->asPortInfo[bPort].sDit.wSrcRate;
	if(gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bInterface == MCDRV_DIO_DA)
	{
		if((psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bBitSel == MCDRV_BITSEL_16)
		|| (psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bBitSel == MCDRV_BITSEL_20)
		|| (psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bBitSel == MCDRV_BITSEL_24))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.sDaFormat.bBitSel	= psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bBitSel;
		}
		if((psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bMode == MCDRV_DAMODE_HEADALIGN)
		|| (psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bMode == MCDRV_DAMODE_I2S)
		|| (psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bMode == MCDRV_DAMODE_TAILALIGN))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.sDaFormat.bMode	= psDioInfo->asPortInfo[bPort].sDit.sDaFormat.bMode;
		}
	}
	else if(gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDioCommon.bInterface == MCDRV_DIO_PCM)
	{
		if((psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bMono == MCDRV_PCM_STEREO)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bMono == MCDRV_PCM_MONO))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.sPcmFormat.bMono	= psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bMono;
		}
		if((psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bOrder == MCDRV_PCM_MSB_FIRST)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bOrder == MCDRV_PCM_LSB_FIRST)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bOrder == MCDRV_PCM_MSB_FIRST_SIGN)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bOrder == MCDRV_PCM_LSB_FIRST_SIGN)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bOrder == MCDRV_PCM_MSB_FIRST_ZERO)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bOrder == MCDRV_PCM_LSB_FIRST_ZERO))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.sPcmFormat.bOrder	= psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bOrder;
		}
		if((psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bLaw == MCDRV_PCM_LINEAR)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bLaw == MCDRV_PCM_ALAW)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bLaw == MCDRV_PCM_MULAW))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.sPcmFormat.bLaw	= psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bLaw;
		}
		if((psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_8)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_13)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_14)
		|| (psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bBitSel == MCDRV_PCM_BITSEL_16))
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.sPcmFormat.bBitSel	= psDioInfo->asPortInfo[bPort].sDit.sPcmFormat.bBitSel;
		}
	}
	else
	{
	}

	for(bDIOCh = 0; bDIOCh < DIO_CHANNELS; bDIOCh++)
	{
		if(psDioInfo->asPortInfo[bPort].sDit.abSlot[bDIOCh] < 2)
		{
			gsGlobalInfo.sDioInfo.asPortInfo[bPort].sDit.abSlot[bDIOCh]	= psDioInfo->asPortInfo[bPort].sDit.abSlot[bDIOCh];
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("SetDIODIT", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetDioInfo
 *
 *	Description:
 *			Get digital io information.
 *	Arguments:
 *			psDioInfo	digital io information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetDioInfo
(
	MCDRV_DIO_INFO*	psDioInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetDioInfo");
#endif

	*psDioInfo	= gsGlobalInfo.sDioInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetDioInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetVolInfo
 *
 *	Description:
 *			Update volume.
 *	Arguments:
 *			psVolInfo		volume setting
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetVolInfo
(
	const MCDRV_VOL_INFO*	psVolInfo
)
{
	UINT8	bCh;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetVolInfo");
#endif


	for(bCh = 0; bCh < AD0_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Ad0[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Ad0[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Ad0[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Ad0Att[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Ad0Att[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Ad0Att[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswA_Ad0[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Ad0[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Ad0[bCh] & 0xFFFE);
		}
	}
	for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Ad1[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Ad1[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Ad1[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Ad1Att[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Ad1Att[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Ad1Att[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswA_Ad1[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Ad1[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Ad1[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < AENG6_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Aeng6[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Aeng6[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Aeng6[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < PDM_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Pdm[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Pdm[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Pdm[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_SideTone[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_SideTone[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_SideTone[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < DTMF_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Dtmfb[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dtmfb[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dtmfb[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_DtmfAtt[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_DtmfAtt[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_DtmfAtt[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Dir0[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dir0[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dir0[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Dir0Att[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dir0Att[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dir0Att[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Dit0[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dit0[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dit0[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Dir1[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dir1[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dir1[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Dir1Att[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dir1Att[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dir1Att[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Dit1[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dit1[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dit1[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_Dir2[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dir2[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dir2[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Dir2Att[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dir2Att[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dir2Att[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_Dit2[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_Dit2[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_Dit2[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswD_DacMaster[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_DacMaster[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_DacMaster[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_DacVoice[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_DacVoice[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_DacVoice[bCh] & 0xFFFE);
		}
		if(((UINT16)psVolInfo->aswD_DacAtt[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswD_DacAtt[bCh]	= (SINT16)((UINT16)psVolInfo->aswD_DacAtt[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < LIN1_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Lin1[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Lin1[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Lin1[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < LIN2_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Lin2[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Lin2[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Lin2[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < MIC1_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Mic1[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Mic1[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Mic1[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < MIC2_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Mic2[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Mic2[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Mic2[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < MIC3_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Mic3[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Mic3[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Mic3[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < HP_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Hp[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Hp[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Hp[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < SP_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Sp[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Sp[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Sp[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < RC_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Rc[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Rc[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Rc[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < LOUT1_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Lout1[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Lout1[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Lout1[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < LOUT2_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Lout2[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Lout2[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Lout2[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < MIC1_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Mic1Gain[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Mic1Gain[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Mic1Gain[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < MIC2_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Mic2Gain[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Mic2Gain[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Mic2Gain[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < MIC3_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_Mic3Gain[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_Mic3Gain[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_Mic3Gain[bCh] & 0xFFFE);
		}
	}

	for(bCh = 0; bCh < HPGAIN_VOL_CHANNELS; bCh++)
	{
		if(((UINT16)psVolInfo->aswA_HpGain[bCh] & 0x01) != 0)
		{
			gsGlobalInfo.sVolInfo.aswA_HpGain[bCh]	= (SINT16)((UINT16)psVolInfo->aswA_HpGain[bCh] & 0xFFFE);
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetVolInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetVolInfo
 *
 *	Description:
 *			Get volume setting.
 *	Arguments:
 *			psVolInfo		volume setting
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetVolInfo
(
	MCDRV_VOL_INFO*	psVolInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetVolInfo");
#endif

	*psVolInfo	= gsGlobalInfo.sVolInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetVolInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetDacInfo
 *
 *	Description:
 *			Set DAC information.
 *	Arguments:
 *			psDacInfo	DAC information
 *			dUpdateInfo	update information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetDacInfo
(
	const MCDRV_DAC_INFO*	psDacInfo,
	UINT32	dUpdateInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetDacInfo");
#endif


	if((dUpdateInfo & MCDRV_DAC_MSWP_UPDATE_FLAG) != 0UL)
	{
		switch(psDacInfo->bMasterSwap)
		{
		case	MCDRV_DSWAP_OFF:
		case	MCDRV_DSWAP_SWAP:
		case	MCDRV_DSWAP_MUTE:
		case	MCDRV_DSWAP_RMVCENTER:
		case	MCDRV_DSWAP_MONO:
		case	MCDRV_DSWAP_MONOHALF:
		case	MCDRV_DSWAP_BOTHL:
		case	MCDRV_DSWAP_BOTHR:
			gsGlobalInfo.sDacInfo.bMasterSwap	= psDacInfo->bMasterSwap;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_DAC_VSWP_UPDATE_FLAG) != 0UL)
	{
		switch(psDacInfo->bVoiceSwap)
		{
		case	MCDRV_DSWAP_OFF:
		case	MCDRV_DSWAP_SWAP:
		case	MCDRV_DSWAP_MUTE:
		case	MCDRV_DSWAP_RMVCENTER:
		case	MCDRV_DSWAP_MONO:
		case	MCDRV_DSWAP_MONOHALF:
		case	MCDRV_DSWAP_BOTHL:
		case	MCDRV_DSWAP_BOTHR:
			gsGlobalInfo.sDacInfo.bVoiceSwap	= psDacInfo->bVoiceSwap;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_DAC_HPF_UPDATE_FLAG) != 0UL)
	{
		if((psDacInfo->bDcCut == MCDRV_DCCUT_ON) || (psDacInfo->bDcCut == MCDRV_DCCUT_OFF))
		{
			gsGlobalInfo.sDacInfo.bDcCut	= psDacInfo->bDcCut;
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetDacInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetDacInfo
 *
 *	Description:
 *			Get DAC information.
 *	Arguments:
 *			psDacInfo	DAC information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetDacInfo
(
	MCDRV_DAC_INFO*	psDacInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetDacInfo");
#endif

	*psDacInfo	= gsGlobalInfo.sDacInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetDacInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetAdcInfo
 *
 *	Description:
 *			Set ADC information.
 *	Arguments:
 *			psAdcInfo	ADC information
 *			dUpdateInfo	update information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetAdcInfo
(
	const MCDRV_ADC_INFO*	psAdcInfo,
	UINT32	dUpdateInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetAdcInfo");
#endif


	if((dUpdateInfo & MCDRV_ADCADJ_UPDATE_FLAG) != 0UL)
	{
		switch(psAdcInfo->bAgcAdjust)
		{
		case	MCDRV_AGCADJ_24:
		case	MCDRV_AGCADJ_18:
		case	MCDRV_AGCADJ_12:
		case	MCDRV_AGCADJ_0:
			gsGlobalInfo.sAdcInfo.bAgcAdjust	= psAdcInfo->bAgcAdjust;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_ADCAGC_UPDATE_FLAG) != 0UL)
	{
		if((psAdcInfo->bAgcOn == MCDRV_AGC_OFF) || (psAdcInfo->bAgcOn == MCDRV_AGC_ON))
		{
			gsGlobalInfo.sAdcInfo.bAgcOn	= psAdcInfo->bAgcOn;
		}
	}
	if((dUpdateInfo & MCDRV_ADCMONO_UPDATE_FLAG) != 0UL)
	{
		if((psAdcInfo->bMono == MCDRV_ADC_STEREO) || (psAdcInfo->bMono == MCDRV_ADC_MONO))
		{
			gsGlobalInfo.sAdcInfo.bMono	= psAdcInfo->bMono;
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetAdcInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetAdcInfo
 *
 *	Description:
 *			Get ADC information.
 *	Arguments:
 *			psAdcInfo	ADC information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetAdcInfo
(
	MCDRV_ADC_INFO*	psAdcInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetAdcInfo");
#endif

	*psAdcInfo	= gsGlobalInfo.sAdcInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetAdcInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetSpInfo
 *
 *	Description:
 *			Set SP information.
 *	Arguments:
 *			psSpInfo	SP information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetSpInfo
(
	const MCDRV_SP_INFO*	psSpInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetSpInfo");
#endif


	if((psSpInfo->bSwap == MCDRV_SPSWAP_OFF) || (psSpInfo->bSwap == MCDRV_SPSWAP_SWAP))
	{
		gsGlobalInfo.sSpInfo.bSwap	= psSpInfo->bSwap;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetSpInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetSpInfo
 *
 *	Description:
 *			Get SP information.
 *	Arguments:
 *			psSpInfo	SP information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetSpInfo
(
	MCDRV_SP_INFO*	psSpInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetSpInfo");
#endif

	*psSpInfo	= gsGlobalInfo.sSpInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetSpInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetDngInfo
 *
 *	Description:
 *			Set Digital Noise Gate information.
 *	Arguments:
 *			psDngInfo	DNG information
 *			dUpdateInfo	update information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetDngInfo
(
	const MCDRV_DNG_INFO*	psDngInfo,
	UINT32	dUpdateInfo
)
{
	UINT8	bItem;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetDngInfo");
#endif


	for(bItem = MCDRV_DNG_ITEM_HP; bItem <= MCDRV_DNG_ITEM_RC; bItem++)
	{
		if((dUpdateInfo & (MCDRV_DNGSW_HP_UPDATE_FLAG<<(8*bItem))) != 0UL)
		{
			if((psDngInfo->abOnOff[bItem] == MCDRV_DNG_OFF) || (psDngInfo->abOnOff[bItem] == MCDRV_DNG_ON))
			{
				gsGlobalInfo.sDngInfo.abOnOff[bItem]	= psDngInfo->abOnOff[bItem];
			}
		}
		if((dUpdateInfo & (MCDRV_DNGTHRES_HP_UPDATE_FLAG<<(8*bItem))) != 0UL)
		{
			switch(psDngInfo->abThreshold[bItem])
			{
			case	MCDRV_DNG_THRES_30:
			case	MCDRV_DNG_THRES_36:
			case	MCDRV_DNG_THRES_42:
			case	MCDRV_DNG_THRES_48:
			case	MCDRV_DNG_THRES_54:
			case	MCDRV_DNG_THRES_60:
			case	MCDRV_DNG_THRES_66:
			case	MCDRV_DNG_THRES_72:
			case	MCDRV_DNG_THRES_78:
			case	MCDRV_DNG_THRES_84:
				gsGlobalInfo.sDngInfo.abThreshold[bItem]	= psDngInfo->abThreshold[bItem];
				break;
			default:
				break;
			}
		}
		if((dUpdateInfo & (MCDRV_DNGHOLD_HP_UPDATE_FLAG<<(8*bItem))) != 0UL)
		{
			switch(psDngInfo->abHold[bItem])
			{
			case	MCDRV_DNG_HOLD_30:
			case	MCDRV_DNG_HOLD_120:
			case	MCDRV_DNG_HOLD_500:
				gsGlobalInfo.sDngInfo.abHold[bItem]	= psDngInfo->abHold[bItem];
				break;
			default:
				break;
			}
		}
		if((dUpdateInfo & (MCDRV_DNGATK_HP_UPDATE_FLAG<<(8*bItem))) != 0UL)
		{
			switch(psDngInfo->abAttack[bItem])
			{
			case	MCDRV_DNG_ATTACK_25:
			case	MCDRV_DNG_ATTACK_100:
			case	MCDRV_DNG_ATTACK_400:
			case	MCDRV_DNG_ATTACK_800:
				gsGlobalInfo.sDngInfo.abAttack[bItem]	= psDngInfo->abAttack[bItem];
				break;
			default:
				break;
			}
		}
		if((dUpdateInfo & (MCDRV_DNGREL_HP_UPDATE_FLAG<<(8*bItem))) != 0UL)
		{
			switch(psDngInfo->abRelease[bItem])
			{
			case	MCDRV_DNG_RELEASE_7950:
			case	MCDRV_DNG_RELEASE_470:
			case	MCDRV_DNG_RELEASE_940:
				gsGlobalInfo.sDngInfo.abRelease[bItem]	= psDngInfo->abRelease[bItem];
				break;
			default:
				break;
			}
		}
		if((dUpdateInfo & (MCDRV_DNGTARGET_HP_UPDATE_FLAG<<(8*bItem))) != 0UL)
		{
			switch(psDngInfo->abTarget[bItem])
			{
			case	MCDRV_DNG_TARGET_6:
			case	MCDRV_DNG_TARGET_9:
			case	MCDRV_DNG_TARGET_12:
			case	MCDRV_DNG_TARGET_15:
			case	MCDRV_DNG_TARGET_18:
			case	MCDRV_DNG_TARGET_MUTE:
				gsGlobalInfo.sDngInfo.abTarget[bItem]	= psDngInfo->abTarget[bItem];
				break;
			default:
				break;
			}
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetDngInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetDngInfo
 *
 *	Description:
 *			Get Digital Noise Gate information.
 *	Arguments:
 *			psDngInfo	DNG information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetDngInfo
(
	MCDRV_DNG_INFO*	psDngInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetDngInfo");
#endif

	*psDngInfo	= gsGlobalInfo.sDngInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetDngInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetAeInfo
 *
 *	Description:
 *			Set Audio Engine information.
 *	Arguments:
 *			psAeInfo	AE information
 *			dUpdateInfo	update information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetAeInfo
(
	const MCDRV_AE_INFO*	psAeInfo,
	UINT32	dUpdateInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetAeInfo");
#endif


	if((McDevProf_IsValid(eMCDRV_FUNC_DBEX) == 1)
	&& ((dUpdateInfo & MCDRV_AEUPDATE_FLAG_BEXWIDE_ONOFF) != 0UL))
	{
		if((psAeInfo->bOnOff & MCDRV_BEXWIDE_ON) != 0)
		{
			gsGlobalInfo.sAeInfo.bOnOff	|= MCDRV_BEXWIDE_ON;
		}
		else
		{
			gsGlobalInfo.sAeInfo.bOnOff &= (UINT8)~MCDRV_BEXWIDE_ON;
		}
	}
	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_DRC_ONOFF) != 0UL)
	{
		if((psAeInfo->bOnOff & MCDRV_DRC_ON) != 0)
		{
			gsGlobalInfo.sAeInfo.bOnOff	|= MCDRV_DRC_ON;
		}
		else
		{
			gsGlobalInfo.sAeInfo.bOnOff &= (UINT8)~MCDRV_DRC_ON;
		}
	}
	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_EQ5_ONOFF) != 0UL)
	{
		if((psAeInfo->bOnOff & MCDRV_EQ5_ON) != 0)
		{
			gsGlobalInfo.sAeInfo.bOnOff	|= MCDRV_EQ5_ON;
		}
		else
		{
			gsGlobalInfo.sAeInfo.bOnOff &= (UINT8)~MCDRV_EQ5_ON;
		}
	}
	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_EQ3_ONOFF) != 0UL)
	{
		if((psAeInfo->bOnOff & MCDRV_EQ3_ON) != 0)
		{
			gsGlobalInfo.sAeInfo.bOnOff	|= MCDRV_EQ3_ON;
		}
		else
		{
			gsGlobalInfo.sAeInfo.bOnOff &= (UINT8)~MCDRV_EQ3_ON;
		}
	}

	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_BEX) != 0UL)
	{
		McSrv_MemCopy(psAeInfo->abBex, gsGlobalInfo.sAeInfo.abBex, BEX_PARAM_SIZE);
	}

	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_WIDE) != 0UL)
	{
		McSrv_MemCopy(psAeInfo->abWide, gsGlobalInfo.sAeInfo.abWide, WIDE_PARAM_SIZE);
	}

	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_DRC) != 0UL)
	{
		McSrv_MemCopy(psAeInfo->abDrc, gsGlobalInfo.sAeInfo.abDrc, DRC_PARAM_SIZE);
	}

	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_EQ5) != 0UL)
	{
		McSrv_MemCopy(psAeInfo->abEq5, gsGlobalInfo.sAeInfo.abEq5, EQ5_PARAM_SIZE);
	}

	if((dUpdateInfo & MCDRV_AEUPDATE_FLAG_EQ3) != 0UL)
	{
		McSrv_MemCopy(psAeInfo->abEq3, gsGlobalInfo.sAeInfo.abEq3, EQ3_PARAM_SIZE);
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetAeInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetAeInfo
 *
 *	Description:
 *			Get Audio Engine information.
 *	Arguments:
 *			psAeInfo	AE information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetAeInfo
(
	MCDRV_AE_INFO*	psAeInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetAeInfo");
#endif

	*psAeInfo	= gsGlobalInfo.sAeInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetAeInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetPdmInfo
 *
 *	Description:
 *			Set PDM information.
 *	Arguments:
 *			psPdmInfo	PDM information
 *			dUpdateInfo	update information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetPdmInfo
(
	const MCDRV_PDM_INFO*	psPdmInfo,
	UINT32	dUpdateInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetPdmInfo");
#endif


	if((dUpdateInfo & MCDRV_PDMCLK_UPDATE_FLAG) != 0UL)
	{
		switch(psPdmInfo->bClk)
		{
		case	MCDRV_PDM_CLK_128:
		case	MCDRV_PDM_CLK_64:
		case	MCDRV_PDM_CLK_32:
			gsGlobalInfo.sPdmInfo.bClk	= psPdmInfo->bClk;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_PDMADJ_UPDATE_FLAG) != 0UL)
	{
		switch(psPdmInfo->bAgcAdjust)
		{
		case	MCDRV_AGCADJ_24:
		case	MCDRV_AGCADJ_18:
		case	MCDRV_AGCADJ_12:
		case	MCDRV_AGCADJ_0:
			gsGlobalInfo.sPdmInfo.bAgcAdjust	= psPdmInfo->bAgcAdjust;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_PDMAGC_UPDATE_FLAG) != 0UL)
	{
		switch(psPdmInfo->bAgcOn)
		{
		case	MCDRV_AGC_OFF:
		case	MCDRV_AGC_ON:
			gsGlobalInfo.sPdmInfo.bAgcOn	= psPdmInfo->bAgcOn;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_PDMEDGE_UPDATE_FLAG) != 0UL)
	{
		switch(psPdmInfo->bPdmEdge)
		{
		case	MCDRV_PDMEDGE_LH:
		case	MCDRV_PDMEDGE_HL:
			gsGlobalInfo.sPdmInfo.bPdmEdge	= psPdmInfo->bPdmEdge;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_PDMWAIT_UPDATE_FLAG) != 0UL)
	{
		switch(psPdmInfo->bPdmWait)
		{
		case	MCDRV_PDMWAIT_0:
		case	MCDRV_PDMWAIT_1:
		case	MCDRV_PDMWAIT_10:
		case	MCDRV_PDMWAIT_20:
			gsGlobalInfo.sPdmInfo.bPdmWait	= psPdmInfo->bPdmWait;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_PDMSEL_UPDATE_FLAG) != 0UL)
	{
		switch(psPdmInfo->bPdmSel)
		{
		case	MCDRV_PDMSEL_L1R2:
		case	MCDRV_PDMSEL_L2R1:
		case	MCDRV_PDMSEL_L1R1:
		case	MCDRV_PDMSEL_L2R2:
			gsGlobalInfo.sPdmInfo.bPdmSel	= psPdmInfo->bPdmSel;
			break;
		default:
			break;
		}
	}
	if((dUpdateInfo & MCDRV_PDMMONO_UPDATE_FLAG) != 0UL)
	{
		switch(psPdmInfo->bMono)
		{
		case	MCDRV_PDM_STEREO:
		case	MCDRV_PDM_MONO:
			gsGlobalInfo.sPdmInfo.bMono	= psPdmInfo->bMono;
			break;
		default:
			break;
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetPdmInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetPdmInfo
 *
 *	Description:
 *			Get PDM information.
 *	Arguments:
 *			psPdmInfo	PDM information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetPdmInfo
(
	MCDRV_PDM_INFO*	psPdmInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetPdmInfo");
#endif

	*psPdmInfo	= gsGlobalInfo.sPdmInfo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetPdmInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetGPMode
 *
 *	Description:
 *			Set GP mode.
 *	Arguments:
 *			psGpMode	GP mode
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetGPMode
(
	const MCDRV_GP_MODE*	psGpMode
)
{
	UINT8	bPad;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetGPMode");
#endif


	for(bPad = 0; bPad < GPIO_PAD_NUM; bPad++)
	{
		if((psGpMode->abGpDdr[bPad] == MCDRV_GPDDR_IN)
		|| (psGpMode->abGpDdr[bPad] == MCDRV_GPDDR_OUT))
		{
			gsGlobalInfo.sGpMode.abGpDdr[bPad]	= psGpMode->abGpDdr[bPad];
		}
		if(McDevProf_IsValid(eMCDRV_FUNC_GPMODE) == 1)
		{
			if((psGpMode->abGpMode[bPad] == MCDRV_GPMODE_RISING)
			|| (psGpMode->abGpMode[bPad] == MCDRV_GPMODE_FALLING)
			|| (psGpMode->abGpMode[bPad] == MCDRV_GPMODE_BOTH))
			{
				gsGlobalInfo.sGpMode.abGpMode[bPad]	= psGpMode->abGpMode[bPad];
			}
			if((psGpMode->abGpHost[bPad] == MCDRV_GPHOST_SCU)
			|| (psGpMode->abGpHost[bPad] == MCDRV_GPHOST_CDSP))
			{
				gsGlobalInfo.sGpMode.abGpHost[bPad]	= psGpMode->abGpHost[bPad];
			}
			if((psGpMode->abGpInvert[bPad] == MCDRV_GPINV_NORMAL)
			|| (psGpMode->abGpInvert[bPad] == MCDRV_GPINV_INVERT))
			{
				gsGlobalInfo.sGpMode.abGpInvert[bPad]	= psGpMode->abGpInvert[bPad];
			}
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetGPMode", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetGPMode
 *
 *	Description:
 *			Get GP mode.
 *	Arguments:
 *			psGpMode	GP mode
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetGPMode
(
	MCDRV_GP_MODE*	psGpMode
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetGPMode");
#endif

	*psGpMode	= gsGlobalInfo.sGpMode;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetGPMode", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetGPMask
 *
 *	Description:
 *			Set GP mask.
 *	Arguments:
 *			bMask	GP mask
 *			dPadNo	PAD Number
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetGPMask
(
	UINT8	bMask,
	UINT32	dPadNo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetGPMask");
#endif

	if(dPadNo == MCDRV_GP_PAD0)
	{
		if((gsGlobalInfo.sInitInfo.bPad0Func == MCDRV_PAD_GPIO)
		&& (gsGlobalInfo.sGpMode.abGpDdr[dPadNo] == MCDRV_GPDDR_IN))
		{
			if((bMask == MCDRV_GPMASK_ON) || (bMask == MCDRV_GPMASK_OFF))
			{
				gsGlobalInfo.abGpMask[dPadNo]	= bMask;
			}
		}
	}
	else if(dPadNo == MCDRV_GP_PAD1)
	{
		if((gsGlobalInfo.sInitInfo.bPad1Func == MCDRV_PAD_GPIO)
		&& (gsGlobalInfo.sGpMode.abGpDdr[dPadNo] == MCDRV_GPDDR_IN))
		{
			if((bMask == MCDRV_GPMASK_ON) || (bMask == MCDRV_GPMASK_OFF))
			{
				gsGlobalInfo.abGpMask[dPadNo]	= bMask;
			}
		}
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetGPMask", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetGPMask
 *
 *	Description:
 *			Get GP mask.
 *	Arguments:
 *			pabMask	GP mask
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetGPMask
(
	UINT8*	pabMask
)
{
	UINT8	bPadNo;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetGPMask");
#endif

	for(bPadNo = 0; bPadNo < GPIO_PAD_NUM; bPadNo++)
	{
		pabMask[bPadNo]	= gsGlobalInfo.abGpMask[bPadNo];
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetGPMask", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetSysEq
 *
 *	Description:
 *			Get System EQ.
 *	Arguments:
 *			psSysEq		pointer to MCDRV_SYSEQ_INFO struct
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetSysEq
(
	MCDRV_SYSEQ_INFO*	psSysEq
)
{
	UINT8	i;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetSysEq");
#endif

	psSysEq->bOnOff	= gsGlobalInfo.sSysEq.bOnOff;
	for(i = 0; i < sizeof(gsGlobalInfo.sSysEq.abParam); i++)
	{
		psSysEq->abParam[i]	= gsGlobalInfo.sSysEq.abParam[i];
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetSysEq", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetSysEq
 *
 *	Description:
 *			Set System EQ.
 *	Arguments:
 *			psSysEq		pointer to MCDRV_SYSEQ_INFO struct
 *			dUpdateInfo	update information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetSysEq
(
	const MCDRV_SYSEQ_INFO*	psSysEq,
	UINT32					dUpdateInfo
)
{
	UINT8	i;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetSysEq");
#endif

	if((dUpdateInfo & MCDRV_SYSEQ_ONOFF_UPDATE_FLAG) != 0UL)
	{
		if((psSysEq->bOnOff == MCDRV_SYSEQ_OFF) || (psSysEq->bOnOff == MCDRV_SYSEQ_ON))
		{
			gsGlobalInfo.sSysEq.bOnOff	= psSysEq->bOnOff;
		}
	}

	if((dUpdateInfo & MCDRV_SYSEQ_PARAM_UPDATE_FLAG) != 0UL)
	{
		for(i = 0; i < sizeof(gsGlobalInfo.sSysEq.abParam); i++)
		{
			gsGlobalInfo.sSysEq.abParam[i]	= psSysEq->abParam[i];
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetSysEq", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetClockSwitch
 *
 *	Description:
 *			Get switch clock info.
 *	Arguments:
 *			psClockInfo		pointer to MCDRV_CLKSW_INFO struct
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetClockSwitch
(
	MCDRV_CLKSW_INFO*	psClockInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetClockSwitch");
#endif

	psClockInfo->bClkSrc	= gsGlobalInfo.sClockSwitch.bClkSrc;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetClockSwitch", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_SetClockSwitch
 *
 *	Description:
 *			Get switch clock info.
 *	Arguments:
 *			psClockInfo		pointer to MCDRV_CLKSW_INFO struct
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_SetClockSwitch
(
	const MCDRV_CLKSW_INFO*	psClockInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_SetClockSwitch");
#endif

	gsGlobalInfo.sClockSwitch.bClkSrc	= psClockInfo->bClkSrc;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_SetClockSwitch", 0);
#endif
}


/****************************************************************************
 *	McResCtrl_GetVolReg
 *
 *	Description:
 *			Get value of volume registers.
 *	Arguments:
 *			psVolInfo	volume information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetVolReg
(
	MCDRV_VOL_INFO*	psVolInfo
)
{
	UINT8	bCh;
	MCDRV_DST_CH	abDSTCh[]	= {eMCDRV_DST_CH0, eMCDRV_DST_CH1};
	SINT16	swGainUp;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetVolReg");
#endif


	*psVolInfo	= gsGlobalInfo.sVolInfo;

	if(gsGlobalInfo.sInitInfo.bDclGain == MCDRV_DCLGAIN_6)
	{
		swGainUp	= 6 * 256;
	}
	else if(gsGlobalInfo.sInitInfo.bDclGain == MCDRV_DCLGAIN_12)
	{
		swGainUp	= 12 * 256;
	}
	else if(gsGlobalInfo.sInitInfo.bDclGain == MCDRV_DCLGAIN_18)
	{
		swGainUp	= 18 * 256;
	}
	else
	{
		swGainUp	= 0;
	}

	psVolInfo->aswA_HpGain[0]	= MCDRV_REG_MUTE;
	if(McResCtrl_IsDstUsed(eMCDRV_DST_HP, eMCDRV_DST_CH0) == 0)
	{
		psVolInfo->aswA_Hp[0]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Hp[0]		= GetHpVolReg(gsGlobalInfo.sVolInfo.aswA_Hp[0]);
		psVolInfo->aswA_HpGain[0]	= GetHpGainReg(gsGlobalInfo.sVolInfo.aswA_HpGain[0]);
	}
	if(McResCtrl_IsDstUsed(eMCDRV_DST_HP, eMCDRV_DST_CH1) == 0)
	{
		psVolInfo->aswA_Hp[1]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Hp[1]	= GetHpVolReg(gsGlobalInfo.sVolInfo.aswA_Hp[1]);
		psVolInfo->aswA_HpGain[0]	= GetHpGainReg(gsGlobalInfo.sVolInfo.aswA_HpGain[0]);
	}

	if(McResCtrl_IsDstUsed(eMCDRV_DST_SP, eMCDRV_DST_CH0) == 0)
	{
		psVolInfo->aswA_Sp[0]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Sp[0]	= GetSpVolReg(gsGlobalInfo.sVolInfo.aswA_Sp[0]);
	}
	if(McResCtrl_IsDstUsed(eMCDRV_DST_SP, eMCDRV_DST_CH1) == 0)
	{
		psVolInfo->aswA_Sp[1]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Sp[1]	= GetSpVolReg(gsGlobalInfo.sVolInfo.aswA_Sp[1]);
	}

	if(McResCtrl_IsDstUsed(eMCDRV_DST_RCV, eMCDRV_DST_CH0) == 0)
	{
		psVolInfo->aswA_Rc[0]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Rc[0]	= GetRcVolReg(gsGlobalInfo.sVolInfo.aswA_Rc[0]);
	}

	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT1, eMCDRV_DST_CH0) == 0)
	{
		psVolInfo->aswA_Lout1[0]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Lout1[0]	= GetLoVolReg(gsGlobalInfo.sVolInfo.aswA_Lout1[0]);
	}
	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT1, eMCDRV_DST_CH1) == 0)
	{
		psVolInfo->aswA_Lout1[1]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Lout1[1]	= GetLoVolReg(gsGlobalInfo.sVolInfo.aswA_Lout1[1]);
	}

	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT2, eMCDRV_DST_CH0) == 0)
	{
		psVolInfo->aswA_Lout2[0]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Lout2[0]	= GetLoVolReg(gsGlobalInfo.sVolInfo.aswA_Lout2[0]);
	}
	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT2, eMCDRV_DST_CH1) == 0)
	{
		psVolInfo->aswA_Lout2[1]	= MCDRV_REG_MUTE;
	}
	else
	{
		psVolInfo->aswA_Lout2[1]	= GetLoVolReg(gsGlobalInfo.sVolInfo.aswA_Lout2[1]);
	}

	for(bCh = 0; bCh < AD0_VOL_CHANNELS; bCh++)
	{
		if(McResCtrl_IsDstUsed(eMCDRV_DST_ADC0, abDSTCh[bCh]) == 0)
		{/*	ADC0 source all off	*/
			psVolInfo->aswA_Ad0[bCh]	= MCDRV_REG_MUTE;
			psVolInfo->aswD_Ad0[bCh]	= MCDRV_REG_MUTE;
		}
		else
		{
			psVolInfo->aswA_Ad0[bCh]	= GetADVolReg(gsGlobalInfo.sVolInfo.aswA_Ad0[bCh]);
			psVolInfo->aswD_Ad0[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Ad0[bCh] - swGainUp);
		}
	}
	if(((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
	|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
	|| (((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		&& ((McResCtrl_GetAESource() == eMCDRV_SRC_PDM) || (McResCtrl_GetAESource() == eMCDRV_SRC_ADC0))))
	{
		for(bCh = 0; bCh < AD0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Ad0Att[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Ad0Att[bCh]);
		}
	}
	else
	{
		for(bCh = 0; bCh < AD0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Ad0Att[bCh]	= MCDRV_REG_MUTE;
		}
	}

	if(McDevProf_IsValid(eMCDRV_FUNC_ADC1) == 1)
	{
		if(McResCtrl_IsDstUsed(eMCDRV_DST_ADC1, eMCDRV_DST_CH0) == 0)
		{/*	ADC1 source all off	*/
			for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswA_Ad1[bCh]	= MCDRV_REG_MUTE;
				psVolInfo->aswD_Ad1[bCh]	= MCDRV_REG_MUTE;
			}
		}
		else
		{
			for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswA_Ad1[bCh]	= GetADVolReg(gsGlobalInfo.sVolInfo.aswA_Ad1[bCh]);
				psVolInfo->aswD_Ad1[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Ad1[bCh] - swGainUp);
			}
		}
		if((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC1_BLOCK] & MCDRV_SRC4_ADC1_ON) == MCDRV_SRC4_ADC1_ON)
		{
			for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswD_Ad1Att[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Ad1Att[bCh]);
			}
		}
		else
		{
			for(bCh = 0; bCh < AD1_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswD_Ad1Att[bCh]	= MCDRV_REG_MUTE;
			}
		}
	}

	if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
	|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
	|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON))
	{
		psVolInfo->aswA_Lin1[0]	= GetLIVolReg(gsGlobalInfo.sVolInfo.aswA_Lin1[0]);
	}
	else
	{
		psVolInfo->aswA_Lin1[0]	= MCDRV_REG_MUTE;
	}

	if(((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
	|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
	|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
	|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON))
	{
		psVolInfo->aswA_Lin1[1]	= GetLIVolReg(gsGlobalInfo.sVolInfo.aswA_Lin1[1]);
	}
	else
	{
		psVolInfo->aswA_Lin1[1]	= MCDRV_REG_MUTE;
	}

	if(McDevProf_IsValid(eMCDRV_FUNC_LI2) == 1)
	{
		psVolInfo->aswA_Lin2[0]	= MCDRV_REG_MUTE;
		psVolInfo->aswA_Lin2[1]	= MCDRV_REG_MUTE;
	}

	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_MIC1) == 0)
	{/*	MIC1 is unused	*/
		for(bCh = 0; bCh < MIC1_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswA_Mic1[bCh]		= MCDRV_REG_MUTE;
			psVolInfo->aswA_Mic1Gain[bCh]	= (SINT16)(McResCtrl_GetRegVal(MCDRV_PACKET_REGTYPE_B_ANA, MCI_MC_GAIN) & MCB_MC1GAIN);
		}
	}
	else
	{
		for(bCh = 0; bCh < MIC1_VOL_CHANNELS; bCh++)
		{
			if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON)
			&& ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON)
			&& ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON))
			{
				psVolInfo->aswA_Mic1[bCh]	= MCDRV_REG_MUTE;
			}
			else
			{
				psVolInfo->aswA_Mic1[bCh]	= GetMcVolReg(gsGlobalInfo.sVolInfo.aswA_Mic1[bCh]);
			}
			psVolInfo->aswA_Mic1Gain[bCh]	= GetMcGainReg(gsGlobalInfo.sVolInfo.aswA_Mic1Gain[bCh]);
		}
	}
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_MIC2) == 0)
	{/*	MIC2 is unused	*/
		for(bCh = 0; bCh < MIC2_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswA_Mic2[bCh]		= MCDRV_REG_MUTE;
			psVolInfo->aswA_Mic2Gain[bCh]	= (SINT16)((McResCtrl_GetRegVal(MCDRV_PACKET_REGTYPE_B_ANA, MCI_MC_GAIN) & MCB_MC2GAIN) >> 4);
		}
	}
	else
	{
		for(bCh = 0; bCh < MIC2_VOL_CHANNELS; bCh++)
		{
			if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON)
			&& ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON)
			&& ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON))
			{
				psVolInfo->aswA_Mic2[bCh]	= MCDRV_REG_MUTE;
			}
			else
			{
				psVolInfo->aswA_Mic2[bCh]	= GetMcVolReg(gsGlobalInfo.sVolInfo.aswA_Mic2[bCh]);
			}
			psVolInfo->aswA_Mic2Gain[bCh]	= GetMcGainReg(gsGlobalInfo.sVolInfo.aswA_Mic2Gain[bCh]);
		}
	}
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_MIC3) == 0)
	{/*	MIC3 is unused	*/
		for(bCh = 0; bCh < MIC3_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswA_Mic3[bCh]		= MCDRV_REG_MUTE;
			psVolInfo->aswA_Mic3Gain[bCh]	= (SINT16)(McResCtrl_GetRegVal(MCDRV_PACKET_REGTYPE_B_ANA, MCI_MC3_GAIN) & MCB_MC3GAIN);
		}
	}
	else
	{
		for(bCh = 0; bCh < MIC3_VOL_CHANNELS; bCh++)
		{
			if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON)
			&& ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON)
			&& ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON)
			&& ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON))
			{
				psVolInfo->aswA_Mic3[bCh]	= MCDRV_REG_MUTE;
			}
			else
			{
				psVolInfo->aswA_Mic3[bCh]	= GetMcVolReg(gsGlobalInfo.sVolInfo.aswA_Mic3[bCh]);
			}
			psVolInfo->aswA_Mic3Gain[bCh]	= GetMcGainReg(gsGlobalInfo.sVolInfo.aswA_Mic3Gain[bCh]);
		}
	}

	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_DIR0) == 0)
	{/*	DIR0 is unused	*/
		for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir0[bCh]		= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir0[bCh]		= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dir0[bCh] - swGainUp);
		}
	}
	if(((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
	|| (((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		&& (McResCtrl_GetAESource() == eMCDRV_SRC_DIR0)))
	{
		for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir0Att[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dir0Att[bCh]);
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir0Att[bCh]	= MCDRV_REG_MUTE;
		}
	}
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_DIR1) == 0)
	{/*	DIR1 is unused	*/
		for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir1[bCh]		= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir1[bCh]		= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dir1[bCh] - swGainUp);
		}
	}
	if(((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
	|| (((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		&& (McResCtrl_GetAESource() == eMCDRV_SRC_DIR1)))
	{
		for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir1Att[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dir1Att[bCh]);
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir1Att[bCh]	= MCDRV_REG_MUTE;
		}
	}
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_DIR2) == 0)
	{/*	DIR2 is unused	*/
		for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir2[bCh]		= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir2[bCh]		= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dir2[bCh] - swGainUp);
		}
	}
	if(((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
	|| (((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		&& (McResCtrl_GetAESource() == eMCDRV_SRC_DIR2)))
	{
		for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir2Att[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dir2Att[bCh]);
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dir2Att[bCh]	= MCDRV_REG_MUTE;
		}
	}

	if(McResCtrl_GetDITSource(eMCDRV_DIO_0) == eMCDRV_SRC_NONE)
	{/*	DIT0 source all off	*/
		for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dit0[bCh]	= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO0_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dit0[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dit0[bCh] + swGainUp);
		}
	}
	if(McResCtrl_GetDITSource(eMCDRV_DIO_1) == eMCDRV_SRC_NONE)
	{/*	DIT1 source all off	*/
		for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dit1[bCh]	= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO1_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dit1[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dit1[bCh] + swGainUp);
		}
	}
	if(McResCtrl_GetDITSource(eMCDRV_DIO_2) == eMCDRV_SRC_NONE)
	{/*	DIT2 source all off	*/
		for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dit2[bCh]	= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < DIO2_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dit2[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dit2[bCh] + swGainUp);
		}
	}

	if((McResCtrl_GetDACSource(eMCDRV_DAC_MASTER) == eMCDRV_SRC_NONE)
	&& (McResCtrl_GetDACSource(eMCDRV_DAC_VOICE) == eMCDRV_SRC_NONE))
	{
		for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_DacAtt[bCh]		= MCDRV_REG_MUTE;
			psVolInfo->aswD_DacMaster[bCh]	= MCDRV_REG_MUTE;
			psVolInfo->aswD_DacVoice[bCh]	= MCDRV_REG_MUTE;
		}
	}
	else
	{
		if(McResCtrl_GetDACSource(eMCDRV_DAC_MASTER) == eMCDRV_SRC_NONE)
		{
			for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswD_DacMaster[bCh]	= MCDRV_REG_MUTE;
			}
		}
		else
		{
			for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswD_DacMaster[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_DacMaster[bCh]);
			}
		}
		if(McResCtrl_GetDACSource(eMCDRV_DAC_VOICE) == eMCDRV_SRC_NONE)
		{
			for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswD_DacVoice[bCh]	= MCDRV_REG_MUTE;
			}
		}
		else
		{
			for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
			{
				psVolInfo->aswD_DacVoice[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_DacVoice[bCh]);
			}
		}
		for(bCh = 0; bCh < DAC_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_DacAtt[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_DacAtt[bCh]);
		}
	}

	if((McResCtrl_IsSrcUsed(eMCDRV_SRC_PDM) == 0)
	&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_ADC0) == 0))
	{/*	PDM&ADC0 is unused	*/
		for(bCh = 0; bCh < AENG6_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Aeng6[bCh]	= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < AENG6_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Aeng6[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Aeng6[bCh]);
		}
	}

	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_PDM) == 0)
	{/*	PDM is unused	*/
		for(bCh = 0; bCh < PDM_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Pdm[bCh]		= MCDRV_REG_MUTE;
			psVolInfo->aswD_SideTone[bCh]	= MCDRV_REG_MUTE;
		}
	}
	else
	{
		for(bCh = 0; bCh < PDM_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Pdm[bCh]		= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Pdm[bCh] - swGainUp);
			psVolInfo->aswD_SideTone[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_SideTone[bCh] - swGainUp);
		}
	}

	if(McDevProf_IsValid(eMCDRV_FUNC_DTMF) == 1)
	{
		/*	DTMF	*/
		for(bCh = 0; bCh < DTMF_VOL_CHANNELS; bCh++)
		{
			psVolInfo->aswD_Dtmfb[bCh]		= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_Dtmfb[bCh] - swGainUp);
			psVolInfo->aswD_DtmfAtt[bCh]	= GetDigitalVolReg(gsGlobalInfo.sVolInfo.aswD_DtmfAtt[bCh] - swGainUp);
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetVolReg", 0);
#endif
}

/****************************************************************************
 *	GetDigitalVolReg
 *
 *	Description:
 *			Get value of digital volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetDigitalVolReg
(
	SINT16	swVol
)
{
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetDigitalVolReg");
#endif

	if(swVol < (-74*256))
	{
		swRet	= 0;
	}
	else if(swVol < 0)
	{
		swRet	= 96 + (swVol-128)/256;
	}
	else
	{
		swRet	= 96 + (swVol+128)/256;
	}

	if(swRet < 22)
	{
		swRet	= 0;
	}

	if(swRet > 114)
	{
		swRet	= 114;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetDigitalVolReg", &sdRet);
#endif

	return swRet;
}

/****************************************************************************
 *	GetADVolReg
 *
 *	Description:
 *			Get update value of analog AD volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetADVolReg
(
	SINT16	swVol
)
{
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetADVolReg");
#endif

	if(swVol < (-27*256))
	{
		swRet	= 0;
	}
	else if(swVol < 0)
	{
		swRet	= 19 + (swVol-192) * 2 / (256*3);
	}
	else
	{
		swRet	= 19 + (swVol+192) * 2 / (256*3);
	}

	if(swRet < 0)
	{
		swRet	= 0;
	}

	if(swRet > 31)
	{
		swRet	= 31;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetADVolReg", &sdRet);
#endif

	return swRet;
}

/****************************************************************************
 *	GetLIVolReg
 *
 *	Description:
 *			Get update value of analog LIN volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetLIVolReg
(
	SINT16	swVol
)
{
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetLIVolReg");
#endif

	if(swVol < (-30*256))
	{
		swRet	= 0;
	}
	else if(swVol < 0)
	{
		swRet	= 21 + (swVol-192) * 2 / (256*3);
	}
	else
	{
		swRet	= 21 + (swVol+192) * 2 / (256*3);
	}

	if(swRet < 0)
	{
		swRet	= 0;
	}
	if(swRet > 31)
	{
		swRet	= 31;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetLIVolReg", &sdRet);
#endif
	return swRet;
}

/****************************************************************************
 *	GetMcVolReg
 *
 *	Description:
 *			Get update value of analog Mic volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetMcVolReg
(
	SINT16	swVol
)
{
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetMcVolReg");
#endif

	if(swVol < (-30*256))
	{
		swRet	= 0;
	}
	else if(swVol < 0)
	{
		swRet	= 21 + (swVol-192) * 2 / (256*3);
	}
	else
	{
		swRet	= 21 + (swVol+192) * 2 / (256*3);
	}

	if(swRet < 0)
	{
		swRet	= 0;
	}
	if(swRet > 31)
	{
		swRet	= 31;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetMcVolReg", &sdRet);
#endif
	return swRet;
}

/****************************************************************************
 *	GetMcGainReg
 *
 *	Description:
 *			Get update value of analog Mic gain registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetMcGainReg
(
	SINT16	swVol
)
{
	SINT16	swGain	= (swVol+128)/256;
	SINT16	swRet	= 3;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetMcGainReg");
#endif

	if(swGain < 18)
	{
		swRet	= 0;
	}
	else if(swGain < 23)
	{
		swRet	= 1;
	}
	else if(swGain < 28)
	{
		swRet	= 2;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetMcGainReg", &sdRet);
#endif

	return swRet;
}

/****************************************************************************
 *	GetHpVolReg
 *
 *	Description:
 *			Get update value of analog Hp volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetHpVolReg
(
	SINT16	swVol
)
{
	SINT16	swDB	= swVol/256;
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetHpVolReg");
#endif

	if(swVol >= 0)
	{
		swRet	= 31;
	}
	else if(swDB <= -8)
	{
		if(swVol < (-36*256))
		{
			swRet	= 0;
		}
		else if(swDB <= -32)
		{
			swRet	= 1;
		}
		else if(swDB <= -26)
		{
			swRet	= 2;
		}
		else if(swDB <= -23)
		{
			swRet	= 3;
		}
		else if(swDB <= -21)
		{
			swRet	= 4;
		}
		else if(swDB <= -19)
		{
			swRet	= 5;
		}
		else if(swDB <= -17)
		{
			swRet	= 6;
		}
		else
		{
			swRet	= 23+(swVol-128)/256;
		}
	}
	else
	{
		swRet	= 31 + (swVol-64)*2/256;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetHpVolReg", &sdRet);
#endif

	return swRet;
}

/****************************************************************************
 *	GetHpGainReg
 *
 *	Description:
 *			Get update value of analog Hp gain registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetHpGainReg
(
	SINT16	swVol
)
{
	SINT16	swDB	= swVol/(256/4);
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetHpGainReg");
#endif

	if(swDB < 3)
	{
		swRet	= 0;
	}
	else if(swDB < 9)
	{
		swRet	= 1;
	}
	else if(swDB < 18)
	{
		swRet	= 2;
	}
	else
	{
		swRet	= 3;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetHpGainReg", &sdRet);
#endif

	return swRet;
}

/****************************************************************************
 *	GetSpVolReg
 *
 *	Description:
 *			Get update value of analog Sp volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetSpVolReg
(
	SINT16	swVol
)
{
	SINT16	swDB	= swVol/256;
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetSpVolReg");
#endif

	if(swVol >= 0)
	{
		swRet	= 31;
	}
	else if(swDB <= -8)
	{
		if(swVol < (-36*256))
		{
			swRet	= 0;
		}
		else if(swDB <= -32)
		{
			swRet	= 1;
		}
		else if(swDB <= -26)
		{
			swRet	= 2;
		}
		else if(swDB <= -23)
		{
			swRet	= 3;
		}
		else if(swDB <= -21)
		{
			swRet	= 4;
		}
		else if(swDB <= -19)
		{
			swRet	= 5;
		}
		else if(swDB <= -17)
		{
			swRet	= 6;
		}
		else
		{
			swRet	= 23+(swVol-128)/256;
		}
	}
	else
	{
		swRet	= 31 + (swVol-64)*2/256;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetSpVolReg", &sdRet);
#endif

	return swRet;
}

/****************************************************************************
 *	GetRcVolReg
 *
 *	Description:
 *			Get update value of analog Rcv volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetRcVolReg
(
	SINT16	swVol
)
{
	SINT16	swDB	= swVol/256;
	SINT16	swRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetRcVolReg");
#endif

	if(swVol >= 0)
	{
		swRet	= 31;
	}
	else if(swDB <= -8)
	{
		if(swVol < (-36*256))
		{
			swRet	= 0;
		}
		else if(swDB <= -32)
		{
			swRet	= 1;
		}
		else if(swDB <= -26)
		{
			swRet	= 2;
		}
		else if(swDB <= -23)
		{
			swRet	= 3;
		}
		else if(swDB <= -21)
		{
			swRet	= 4;
		}
		else if(swDB <= -19)
		{
			swRet	= 5;
		}
		else if(swDB <= -17)
		{
			swRet	= 6;
		}
		else
		{
			swRet	= 23+(swVol-128)/256;
		}
	}
	else
	{
		swRet	= 31 + (swVol-64)*2/256;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetRcVolReg", &sdRet);
#endif

	return swRet;
}

/****************************************************************************
 *	GetLoVolReg
 *
 *	Description:
 *			Get update value of analog Lout volume registers.
 *	Arguments:
 *			swVol	volume(dB value*256)
 *	Return:
 *			value of registers
 *
 ****************************************************************************/
static SINT16	GetLoVolReg
(
	SINT16	swVol
)
{
	SINT16	swRet	= 31 + (swVol-128)/256;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("GetLoVolReg");
#endif

	if(swVol < (-30*256))
	{
		swRet	= 0;
	}
	if(swRet < 0)
	{
		swRet	= 0;
	}
	if(swRet > 31)
	{
		swRet	= 31;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= swRet;
	McDebugLog_FuncOut("GetLoVolReg", &sdRet);
#endif
	return swRet;
}

/****************************************************************************
 *	McResCtrl_GetPowerInfo
 *
 *	Description:
 *			Get power information.
 *	Arguments:
 *			psPowerInfo	power information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetPowerInfo
(
	MCDRV_POWER_INFO*	psPowerInfo
)
{
	UINT8	i;
	UINT8	bAnalogOn	= 0;
	UINT8	bPowerMode	= gsGlobalInfo.sInitInfo.bPowerMode;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetPowerInfo");
#endif

	/*	Digital power	*/
	psPowerInfo->dDigital	= 0;
	if((bPowerMode & MCDRV_POWMODE_CLKON) == 0)
	{
		psPowerInfo->dDigital |= (MCDRV_POWINFO_DIGITAL_DP0 | MCDRV_POWINFO_DIGITAL_DP1 | MCDRV_POWINFO_DIGITAL_DP2 | MCDRV_POWINFO_DIGITAL_PLLRST0);
	}
	if((McResCtrl_GetDITSource(eMCDRV_DIO_0)	!= eMCDRV_SRC_NONE)
	|| (McResCtrl_GetDITSource(eMCDRV_DIO_1)	!= eMCDRV_SRC_NONE)
	|| (McResCtrl_GetDITSource(eMCDRV_DIO_2)	!= eMCDRV_SRC_NONE)
	|| (McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_L)	!= 0)
	|| (McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_M)	!= 0)
	|| (McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_R)	!= 0)
	|| (McResCtrl_IsSrcUsed(eMCDRV_SRC_ADC0)	!= 0)
	|| (McResCtrl_IsSrcUsed(eMCDRV_SRC_AE)		!= 0)
	|| (McResCtrl_IsSrcUsed(eMCDRV_SRC_MIX)		!= 0))
	{
		/*	DP0-2, PLLRST0 on	*/
		psPowerInfo->dDigital &= ~(MCDRV_POWINFO_DIGITAL_DP0 | MCDRV_POWINFO_DIGITAL_DP1 | MCDRV_POWINFO_DIGITAL_DP2 | MCDRV_POWINFO_DIGITAL_PLLRST0);
	}
	else
	{
		psPowerInfo->dDigital |= MCDRV_POWINFO_DIGITAL_DPB;
	}

	/*	DPBDSP	*/
	if((McResCtrl_IsSrcUsed(eMCDRV_SRC_AE) == 0)
	|| ((gsGlobalInfo.sAeInfo.bOnOff&(MCDRV_BEXWIDE_ON|MCDRV_DRC_ON)) == 0))
	{
		psPowerInfo->dDigital |= MCDRV_POWINFO_DIGITAL_DPBDSP;
	}

	/*	DPADIF	*/
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_ADC0) == 0)
	{
		psPowerInfo->dDigital |= MCDRV_POWINFO_DIGITAL_DPADIF;
	}

	/*	DPPDM	*/
	if((gsGlobalInfo.sInitInfo.bPad0Func != MCDRV_PAD_PDMCK) || (McResCtrl_IsSrcUsed(eMCDRV_SRC_PDM) == 0))
	{
		psPowerInfo->dDigital |= MCDRV_POWINFO_DIGITAL_DPPDM;
	}

	/*	DPDI*	*/
	if((gsGlobalInfo.sDioInfo.asPortInfo[0].sDioCommon.bMasterSlave == MCDRV_DIO_SLAVE)
	|| (((McResCtrl_IsSrcUsed(eMCDRV_SRC_DIR0) == 0) && (McResCtrl_GetDITSource(eMCDRV_DIO_0) == eMCDRV_SRC_NONE))))
	{
		psPowerInfo->dDigital |= MCDRV_POWINFO_DIGITAL_DPDI0;
	}
	if((gsGlobalInfo.sDioInfo.asPortInfo[1].sDioCommon.bMasterSlave == MCDRV_DIO_SLAVE)
	|| (((McResCtrl_IsSrcUsed(eMCDRV_SRC_DIR1) == 0) && (McResCtrl_GetDITSource(eMCDRV_DIO_1) == eMCDRV_SRC_NONE))))
	{
		psPowerInfo->dDigital |= MCDRV_POWINFO_DIGITAL_DPDI1;
	}
	if((gsGlobalInfo.sDioInfo.asPortInfo[2].sDioCommon.bMasterSlave == MCDRV_DIO_SLAVE)
	|| (((McResCtrl_IsSrcUsed(eMCDRV_SRC_DIR2) == 0) && (McResCtrl_GetDITSource(eMCDRV_DIO_2) == eMCDRV_SRC_NONE))))
	{
		psPowerInfo->dDigital |= MCDRV_POWINFO_DIGITAL_DPDI2;
	}

	/*	Analog power	*/
	for(i = 0; i < 5; i++)
	{
		psPowerInfo->abAnalog[i]	= 0;
	}

	/*	SPL*	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_SP, eMCDRV_DST_CH0) == 0)
	{
		psPowerInfo->abAnalog[1] |= MCB_PWM_SPL1;
		psPowerInfo->abAnalog[1] |= MCB_PWM_SPL2;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	SPR*	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_SP, eMCDRV_DST_CH1) == 0)
	{
		psPowerInfo->abAnalog[1] |= MCB_PWM_SPR1;
		psPowerInfo->abAnalog[1] |= MCB_PWM_SPR2;
	}
	else
	{
		bAnalogOn	= 1;
	}

	/*	HPL	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_HP, eMCDRV_DST_CH0) == 0)
	{
		psPowerInfo->abAnalog[1] |= MCB_PWM_HPL;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	HPR	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_HP, eMCDRV_DST_CH1) == 0)
	{
		psPowerInfo->abAnalog[1] |= MCB_PWM_HPR;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	CP	*/
	if(((psPowerInfo->abAnalog[1] & MCB_PWM_HPL) != 0) && ((psPowerInfo->abAnalog[1] & MCB_PWM_HPR) != 0))
	{
		psPowerInfo->abAnalog[0] |= MCB_PWM_CP;
	}

	/*	LOUT1L	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT1, eMCDRV_DST_CH0) == 0)
	{
		psPowerInfo->abAnalog[2] |= MCB_PWM_LO1L;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	LOUT1R	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT1, eMCDRV_DST_CH1) == 0)
	{
		psPowerInfo->abAnalog[2] |= MCB_PWM_LO1R;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	LOUT2L	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT2, eMCDRV_DST_CH0) == 0)
	{
		psPowerInfo->abAnalog[2] |= MCB_PWM_LO2L;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	LOUT2R	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_LOUT2, eMCDRV_DST_CH1) == 0)
	{
		psPowerInfo->abAnalog[2] |= MCB_PWM_LO2R;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	RCV	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_RCV, eMCDRV_DST_CH0) == 0)
	{
		psPowerInfo->abAnalog[2] |= MCB_PWM_RC1;
		psPowerInfo->abAnalog[2] |= MCB_PWM_RC2;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	DA	*/
	if((McResCtrl_IsDstUsed(eMCDRV_DST_DAC, eMCDRV_DST_CH0) == 0)
	&& (McResCtrl_IsDstUsed(eMCDRV_DST_DAC, eMCDRV_DST_CH1) == 0))
	{
		psPowerInfo->abAnalog[3] |= MCB_PWM_DAL;
		psPowerInfo->abAnalog[3] |= MCB_PWM_DAR;
	}
	else
	{
		if((McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_L) == 0)
		&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_M) == 0))
		{
			psPowerInfo->abAnalog[3] |= MCB_PWM_DAL;
		}
		if((McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_R) == 0)
		&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_DAC_M) == 0))
		{
			psPowerInfo->abAnalog[3] |= MCB_PWM_DAR;
		}
		bAnalogOn	= 1;
	}
	/*	ADC0L	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_ADC0, eMCDRV_DST_CH0) == 1)
	{
		bAnalogOn	= 1;
	}
	else
	{
		if((McDevProf_IsValid(eMCDRV_FUNC_LI2) == 1)
		&& (((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE2_L_BLOCK] & MCDRV_SRC2_LINE2_L_ON) == MCDRV_SRC2_LINE2_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)))
		{
			bAnalogOn	= 1;
		}
		else
		{
			psPowerInfo->abAnalog[1] |= MCB_PWM_ADL;
		}
	}
	/*	ADC0R	*/
	if(McResCtrl_IsDstUsed(eMCDRV_DST_ADC0, eMCDRV_DST_CH1) == 1)
	{
		bAnalogOn	= 1;
	}
	else
	{
		if((McDevProf_IsValid(eMCDRV_FUNC_LI2) == 1)
		&& (((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE2_R_BLOCK] & MCDRV_SRC2_LINE2_R_ON) == MCDRV_SRC2_LINE2_R_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)))
		{
			bAnalogOn	= 1;
		}
		else
		{
			psPowerInfo->abAnalog[1] |= MCB_PWM_ADR;
		}
	}
	if(McDevProf_IsValid(eMCDRV_FUNC_ADC1) == 1)
	{
	}
	/*	LI	*/
	if((McResCtrl_IsSrcUsed(eMCDRV_SRC_LINE1_L) == 0)
	&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_LINE1_M) == 0)
	&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_LINE1_R) == 0))
	{
		psPowerInfo->abAnalog[4] |= MCB_PWM_LI;
	}
	else
	{
		bAnalogOn	= 1;
	}
	if(McDevProf_IsValid(eMCDRV_FUNC_LI2) == 1)
	{
		if((McResCtrl_IsSrcUsed(eMCDRV_SRC_LINE2_L) == 0)
		&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_LINE2_M) == 0)
		&& (McResCtrl_IsSrcUsed(eMCDRV_SRC_LINE2_R) == 0))
		{
			/*psPowerInfo->abAnalog[4] |= MCB_PWM_LI2;*/
		}
		else
		{
			bAnalogOn	= 1;
		}
	}
	/*	MC1	*/
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_MIC1) == 0)
	{
		psPowerInfo->abAnalog[4] |= MCB_PWM_MC1;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	MC2	*/
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_MIC2) == 0)
	{
		psPowerInfo->abAnalog[4] |= MCB_PWM_MC2;
	}
	else
	{
		bAnalogOn	= 1;
	}
	/*	MC3	*/
	if(McResCtrl_IsSrcUsed(eMCDRV_SRC_MIC3) == 0)
	{
		psPowerInfo->abAnalog[4] |= MCB_PWM_MC3;
	}
	else
	{
		bAnalogOn	= 1;
	}
	if((gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) != MCDRV_SRC0_MIC1_ON)
	{
		psPowerInfo->abAnalog[3] |= MCB_PWM_MB1;
	}
	else
	{
		bAnalogOn	= 1;
	}
	if((gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) != MCDRV_SRC0_MIC2_ON)
	{
		psPowerInfo->abAnalog[3] |= MCB_PWM_MB2;
	}
	else
	{
		bAnalogOn	= 1;
	}
	if((gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) != MCDRV_SRC0_MIC3_ON)
	{
		psPowerInfo->abAnalog[3] |= MCB_PWM_MB3;
	}
	else
	{
		bAnalogOn	= 1;
	}

	/*	VR/LDOA/REFA	*/
	if ((0 == bAnalogOn) && ((bPowerMode & MCDRV_POWMODE_VREFON) == 0))
	{
		psPowerInfo->abAnalog[0] |= MCB_PWM_VR;
		psPowerInfo->abAnalog[0] |= MCB_PWM_REFA;
		psPowerInfo->abAnalog[0] |= MCB_PWM_LDOA;
	}
	else
	{
		if (MCDRV_LDO_OFF == gsGlobalInfo.sInitInfo.bLdo)
		{
			psPowerInfo->abAnalog[0] |= MCB_PWM_LDOA;
		}
		else
		{
			psPowerInfo->abAnalog[0] |= MCB_PWM_REFA;
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetPowerInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetPowerInfoRegAccess
 *
 *	Description:
 *			Get power information to access register.
 *	Arguments:
 *			psRegInfo	register information
 *			psPowerInfo	power information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetPowerInfoRegAccess
(
	const MCDRV_REG_INFO*	psRegInfo,
	MCDRV_POWER_INFO*		psPowerInfo
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetPowerInfoRegAccess");
#endif


	McResCtrl_GetPowerInfo(psPowerInfo);

	switch(psRegInfo->bRegType)
	{
	default:
	case	MCDRV_REGTYPE_A:
	case	MCDRV_REGTYPE_B_BASE:
	case	MCDRV_REGTYPE_B_AE:
		break;
	case	MCDRV_REGTYPE_B_ANALOG:
		switch(psRegInfo->bAddress)
		{
		case	MCI_APMOFF:
		case	MCI_HPVOL_L:
		case	MCI_HPVOL_R:
		case	MCI_SPVOL_L:
		case	MCI_SPVOL_R:
		case	MCI_RCVOL:
		case	MCI_HPL_MIX:
		case	MCI_HPL_MONO:
		case	MCI_HPR_MIX:
		case	MCI_SPL_MIX:
		case	MCI_SPL_MONO:
		case	MCI_SPR_MIX:
		case	MCI_SPR_MONO:
		case	MCI_RC_MIX:
			psPowerInfo->abAnalog[0]	&= (UINT8)~MCB_PWM_VR;
			break;
		default:
			break;
		}
		break;

	case	MCDRV_REGTYPE_B_CODEC:
		switch(psRegInfo->bAddress)
		{
		case	MCI_DPADIF:
		case	MCI_CD_HW_ID:
		case	MCI_PLL_RST:
		case	MCI_DIVR0:
		case	MCI_DIVF0:
		case	MCI_DIVR1:
		case	MCI_DIVF1:
		case	MCI_AD_AGC:
		case	MCI_DCCUTOFF:
		case	MCI_DCL:
			break;
		default:
			if((psRegInfo->bAddress >= MCI_SYS_CEQ0_19_12) && (psRegInfo->bAddress <= MCI_SYS_CEQ4_3_0))
			{
				break;
			}
			psPowerInfo->dDigital	&= ~(MCDRV_POWINFO_DIGITAL_DP0 | MCDRV_POWINFO_DIGITAL_DP1
										| MCDRV_POWINFO_DIGITAL_DP2 | MCDRV_POWINFO_DIGITAL_PLLRST0 | MCDRV_POWINFO_DIGITAL_DPB);
			break;
		}
		break;

	case	MCDRV_REGTYPE_B_MIXER:
		switch(psRegInfo->bAddress)
		{
		case	MCI_SWP:
		case	MCI_DIMODE0:
		case	MCI_DIMODE1:
		case	MCI_DIMODE2:
		case	MCI_DI_FS0:
		case	MCI_DI_FS1:
		case	MCI_DI_FS2:
		case	MCI_DI0_SRC:
		case	MCI_DI1_SRC:
		case	MCI_DI2_SRC:
		case	MCI_DIRSRC_RATE0_MSB:
		case	MCI_DIRSRC_RATE0_LSB:
		case	MCI_DIRSRC_RATE1_MSB:
		case	MCI_DIRSRC_RATE1_LSB:
		case	MCI_DIRSRC_RATE2_MSB:
		case	MCI_DIRSRC_RATE2_LSB:
		case	MCI_DIX0_FMT:
		case	MCI_DIX1_FMT:
		case	MCI_DIX2_FMT:
		case	MCI_DIR0_CH:
		case	MCI_DIR1_CH:
		case	MCI_DIR2_CH:
		case	MCI_DIT0_SLOT:
		case	MCI_DIT1_SLOT:
		case	MCI_DIT2_SLOT:
		case	MCI_HIZ_REDGE0:
		case	MCI_HIZ_REDGE1:
		case	MCI_HIZ_REDGE2:
		case	MCI_PCM_RX0:
		case	MCI_PCM_RX1:
		case	MCI_PCM_RX2:
		case	MCI_PCM_SLOT_RX0:
		case	MCI_PCM_SLOT_RX1:
		case	MCI_PCM_SLOT_RX2:
		case	MCI_PCM_TX0:
		case	MCI_PCM_TX1:
		case	MCI_PCM_TX2:
		case	MCI_PCM_SLOT_TX0:
		case	MCI_PCM_SLOT_TX1:
		case	MCI_PCM_SLOT_TX2:
		case	MCI_PDM_AGC:
		case	MCI_PDM_STWAIT:
			break;
		default:
			psPowerInfo->dDigital	&= ~(MCDRV_POWINFO_DIGITAL_DP0 | MCDRV_POWINFO_DIGITAL_DP1
										| MCDRV_POWINFO_DIGITAL_DP2 | MCDRV_POWINFO_DIGITAL_PLLRST0 | MCDRV_POWINFO_DIGITAL_DPB);
			break;
		}
		break;

	case	MCDRV_REGTYPE_B_CDSP:
		break;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetPowerInfoRegAccess", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetCurPowerInfo
 *
 *	Description:
 *			Get current power setting.
 *	Arguments:
 *			psPowerInfo	power information
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_GetCurPowerInfo
(
	MCDRV_POWER_INFO*	psPowerInfo
)
{
	UINT8	bReg;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_GetCurPowerInfo");
#endif


	psPowerInfo->abAnalog[0]	= gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_0];
	psPowerInfo->abAnalog[1]	= gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_1];
	psPowerInfo->abAnalog[2]	= gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_2];
	psPowerInfo->abAnalog[3]	= gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_3];
	psPowerInfo->abAnalog[4]	= gsGlobalInfo.abRegValB_ANA[MCI_PWM_ANALOG_4];

	psPowerInfo->dDigital	= 0;
	bReg	= gsGlobalInfo.abRegValB_CODEC[MCI_DPADIF];
	if((bReg & (MCB_DP0_CLKI1|MCB_DP0_CLKI0)) == (MCB_DP0_CLKI1|MCB_DP0_CLKI0))
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DP0;
	}
	bReg	= gsGlobalInfo.abRegValB_BASE[MCI_PWM_DIGITAL];
	if((bReg & MCB_PWM_DP1) == MCB_PWM_DP1)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DP1;
	}
	if((bReg & MCB_PWM_DP2) == MCB_PWM_DP2)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DP2;
	}

	bReg	= gsGlobalInfo.abRegValB_BASE[MCI_PWM_DIGITAL_1];
	if((bReg & MCB_PWM_DPB) == MCB_PWM_DPB)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DPB;
	}
	if((bReg & MCB_PWM_DPDI0) == MCB_PWM_DPDI0)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DPDI0;
	}
	if((bReg & MCB_PWM_DPDI1) == MCB_PWM_DPDI1)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DPDI1;
	}
	if((bReg & MCB_PWM_DPDI2) == MCB_PWM_DPDI2)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DPDI2;
	}
	if((bReg & MCB_PWM_DPPDM) == MCB_PWM_DPPDM)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DPPDM;
	}

	bReg	= gsGlobalInfo.abRegValB_BASE[MCI_PWM_DIGITAL_BDSP];
	if((bReg & MCB_PWM_DPBDSP) == MCB_PWM_DPBDSP)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DPBDSP;
	}

	bReg	= gsGlobalInfo.abRegValB_CODEC[MCI_PLL_RST];
	if((bReg & MCB_PLLRST0) == MCB_PLLRST0)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_PLLRST0;
	}

	bReg	= gsGlobalInfo.abRegValB_CODEC[MCI_DPADIF];
	if((bReg & MCB_DPADIF) == MCB_DPADIF)
	{
		psPowerInfo->dDigital	|= MCDRV_POWINFO_DIGITAL_DPADIF;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetCurPowerInfo", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_GetDACSource
 *
 *	Description:
 *			Get DAC source information.
 *	Arguments:
 *			eCh	0:Master/1:Voice
 *	Return:
 *			path source(MCDRV_SRC_TYPE)
 *
 ****************************************************************************/
MCDRV_SRC_TYPE	McResCtrl_GetDACSource
(
	MCDRV_DAC_CH	eCh
)
{
	MCDRV_SRC_TYPE	eSrcType	= eMCDRV_SRC_NONE;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_GetDACSource");
#endif


	if((gsGlobalInfo.sPathInfo.asDac[eCh].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
	{
		eSrcType	= eMCDRV_SRC_PDM;
	}
	else if((gsGlobalInfo.sPathInfo.asDac[eCh].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
	{
		eSrcType	= eMCDRV_SRC_ADC0;
	}
	else if((gsGlobalInfo.sPathInfo.asDac[eCh].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
	{
		eSrcType	= eMCDRV_SRC_DIR0;
	}
	else if((gsGlobalInfo.sPathInfo.asDac[eCh].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
	{
		eSrcType	= eMCDRV_SRC_DIR1;
	}
	else if((gsGlobalInfo.sPathInfo.asDac[eCh].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
	{
		eSrcType	= eMCDRV_SRC_DIR2;
	}
	else if((gsGlobalInfo.sPathInfo.asDac[eCh].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
	{
		eSrcType	= eMCDRV_SRC_MIX;
	}
	else if((gsGlobalInfo.sPathInfo.asDac[eCh].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
	{
		eSrcType	= McResCtrl_GetAESource();
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= eSrcType;
	McDebugLog_FuncOut("McResCtrl_GetDACSource", &sdRet);
#endif
	return eSrcType;
}

/****************************************************************************
 *	McResCtrl_GetDITSource
 *
 *	Description:
 *			Get DIT source information.
 *	Arguments:
 *			ePort	port number
 *	Return:
 *			path source(MCDRV_SRC_TYPE)
 *
 ****************************************************************************/
MCDRV_SRC_TYPE	McResCtrl_GetDITSource
(
	MCDRV_DIO_PORT_NO	ePort
)
{
	MCDRV_SRC_TYPE	eSrcType	= eMCDRV_SRC_NONE;
	MCDRV_CHANNEL*	pasDit		= NULL;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_GetDITSource");
#endif

	if(ePort == 0)
	{
		pasDit	= &gsGlobalInfo.sPathInfo.asDit0[0];
	}
	else if(ePort == 1)
	{
		pasDit	= &gsGlobalInfo.sPathInfo.asDit1[0];
	}
	else if(ePort == 2)
	{
		pasDit	= &gsGlobalInfo.sPathInfo.asDit2[0];
	}
	else
	{
	}

	if(pasDit != NULL)
	{
		if((pasDit->abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		{
			eSrcType	= eMCDRV_SRC_PDM;
		}
		else if((pasDit->abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		{
			eSrcType	= eMCDRV_SRC_ADC0;
		}
		else if((pasDit->abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		{
			eSrcType	= eMCDRV_SRC_DIR0;
		}
		else if((pasDit->abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		{
			eSrcType	= eMCDRV_SRC_DIR1;
		}
		else if((pasDit->abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		{
			eSrcType	= eMCDRV_SRC_DIR2;
		}
		else if((pasDit->abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
		{
			eSrcType	= eMCDRV_SRC_MIX;
		}
		else if((pasDit->abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		{
			eSrcType	= McResCtrl_GetAESource();
		}
		else
		{
		}
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= eSrcType;
	McDebugLog_FuncOut("McResCtrl_GetDITSource", &sdRet);
#endif

	return eSrcType;
}

/****************************************************************************
 *	McResCtrl_GetAESource
 *
 *	Description:
 *			Get AE source information.
 *	Arguments:
 *			none
 *	Return:
 *			path source(MCDRV_SRC_TYPE)
 *
 ****************************************************************************/
MCDRV_SRC_TYPE	McResCtrl_GetAESource
(
	void
)
{
	MCDRV_SRC_TYPE	eSrcType	= eMCDRV_SRC_NONE;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_GetAESource");
#endif

	if((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
	{
		eSrcType	= eMCDRV_SRC_PDM;
	}
	else if((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
	{
		eSrcType	= eMCDRV_SRC_ADC0;
	}
	else if((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
	{
		eSrcType	= eMCDRV_SRC_DIR0;
	}
	else if((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
	{
		eSrcType	= eMCDRV_SRC_DIR1;
	}
	else if((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
	{
		eSrcType	= eMCDRV_SRC_DIR2;
	}
	else if((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
	{
		eSrcType	= eMCDRV_SRC_MIX;
	}
	else
	{
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= eSrcType;
	McDebugLog_FuncOut("McResCtrl_GetAESource", &sdRet);
#endif

	return eSrcType;
}

/****************************************************************************
 *	McResCtrl_IsSrcUsed
 *
 *	Description:
 *			Is Src used
 *	Arguments:
 *			ePathSrc	path src type
 *	Return:
 *			0:unused/1:used
 *
 ****************************************************************************/
UINT8	McResCtrl_IsSrcUsed
(
	MCDRV_SRC_TYPE	ePathSrc
)
{
	UINT8	bUsed	= 0;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_IsSrcUsed");
#endif

	switch(ePathSrc)
	{
	case	eMCDRV_SRC_MIC1:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_MIC2:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_MIC3:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_LINE1_L:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_LINE1_R:
		if(((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_LINE1_M:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_LINE2_L:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE2_L_BLOCK] & MCDRV_SRC2_LINE2_L_ON) == MCDRV_SRC2_LINE2_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE2_L_BLOCK] & MCDRV_SRC2_LINE2_L_ON) == MCDRV_SRC2_LINE2_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE2_L_BLOCK] & MCDRV_SRC2_LINE2_L_ON) == MCDRV_SRC2_LINE2_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE2_L_BLOCK] & MCDRV_SRC2_LINE2_L_ON) == MCDRV_SRC2_LINE2_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE2_L_BLOCK] & MCDRV_SRC2_LINE2_L_ON) == MCDRV_SRC2_LINE2_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE2_L_BLOCK] & MCDRV_SRC2_LINE2_L_ON) == MCDRV_SRC2_LINE2_L_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_LINE2_R:
		if(((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE2_R_BLOCK] & MCDRV_SRC2_LINE2_R_ON) == MCDRV_SRC2_LINE2_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE2_R_BLOCK] & MCDRV_SRC2_LINE2_R_ON) == MCDRV_SRC2_LINE2_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE2_R_BLOCK] & MCDRV_SRC2_LINE2_R_ON) == MCDRV_SRC2_LINE2_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE2_R_BLOCK] & MCDRV_SRC2_LINE2_R_ON) == MCDRV_SRC2_LINE2_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE2_R_BLOCK] & MCDRV_SRC2_LINE2_R_ON) == MCDRV_SRC2_LINE2_R_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_LINE2_M:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE2_M_BLOCK] & MCDRV_SRC2_LINE2_M_ON) == MCDRV_SRC2_LINE2_M_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_DIR0:
		if(((gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		|| ((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_DIR1:
		if(((gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		|| ((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_DIR2:
		if(((gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		|| ((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_DTMF:
		break;

	case	eMCDRV_SRC_PDM:
		if(((gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		|| ((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_ADC0:
		if(((gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		|| ((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_ADC1:
		break;

	case	eMCDRV_SRC_DAC_L:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_DAC_R:
		if(((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_DAC_M:
		if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON)
		|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_AE:
		if(((gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_CDSP:
		break;

	case	eMCDRV_SRC_MIX:
		if(((gsGlobalInfo.sPathInfo.asDit0[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit1[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
		|| ((gsGlobalInfo.sPathInfo.asDit2[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
		|| ((gsGlobalInfo.sPathInfo.asDac[1].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON)
		|| ((gsGlobalInfo.sPathInfo.asAe[0].abSrcOnOff[MCDRV_SRC_MIX_BLOCK] & MCDRV_SRC6_MIX_ON) == MCDRV_SRC6_MIX_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_SRC_DIR2_DIRECT:
		break;

	case	eMCDRV_SRC_CDSP_DIRECT:
		break;

	default:
		break;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= (SINT32)bUsed;
	McDebugLog_FuncOut("McResCtrl_IsSrcUsed", &sdRet);
#endif

	return bUsed;
}

/****************************************************************************
 *	McResCtrl_IsDstUsed
 *
 *	Description:
 *			Is Destination used
 *	Arguments:
 *			eType	path destination
 *			eCh		channel
 *	Return:
 *			0:unused/1:used
 *
 ****************************************************************************/
UINT8	McResCtrl_IsDstUsed
(
	MCDRV_DST_TYPE	eType,
	MCDRV_DST_CH	eCh
)
{
	UINT8	bUsed	= 0;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_IsDstUsed");
#endif

	switch(eType)
	{
	case	eMCDRV_DST_HP:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON))
			{
				bUsed	= 1;
			}
		}
		else if(eCh == eMCDRV_DST_CH1)
		{
			if(((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
			|| ((gsGlobalInfo.sPathInfo.asHpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON))
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_SP:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
			|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asSpOut[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON))
			{
				bUsed	= 1;
			}
		}
		else if(eCh == eMCDRV_DST_CH1)
		{
			if(((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
			|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
			|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON)
			|| ((gsGlobalInfo.sPathInfo.asSpOut[1].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON))
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_RCV:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
			|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asRcOut[0].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) ==MCDRV_SRC5_DAC_R_ON))
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_LOUT1:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON))
			{
				bUsed	= 1;
			}
		}
		else if(eCh == eMCDRV_DST_CH1)
		{
			if(((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout1[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON))
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_LOUT2:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_L_BLOCK] & MCDRV_SRC5_DAC_L_ON) == MCDRV_SRC5_DAC_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[0].abSrcOnOff[MCDRV_SRC_DAC_M_BLOCK] & MCDRV_SRC5_DAC_M_ON) == MCDRV_SRC5_DAC_M_ON))
			{
				bUsed	= 1;
			}
		}
		else if(eCh == eMCDRV_DST_CH1)
		{
			if(((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
			|| ((gsGlobalInfo.sPathInfo.asLout2[1].abSrcOnOff[MCDRV_SRC_DAC_R_BLOCK] & MCDRV_SRC5_DAC_R_ON) == MCDRV_SRC5_DAC_R_ON))
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_PEAK:
		break;

	case	eMCDRV_DST_DIT0:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(McResCtrl_GetDITSource(eMCDRV_DIO_0) != eMCDRV_SRC_NONE)
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_DIT1:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(McResCtrl_GetDITSource(eMCDRV_DIO_1) != eMCDRV_SRC_NONE)
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_DIT2:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(McResCtrl_GetDITSource(eMCDRV_DIO_2) != eMCDRV_SRC_NONE)
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_DAC:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(McResCtrl_GetDACSource(eMCDRV_DAC_MASTER) != eMCDRV_SRC_NONE)
			{
				bUsed	= 1;
			}
		}
		else if(eCh == eMCDRV_DST_CH1)
		{
			if(McResCtrl_GetDACSource(eMCDRV_DAC_VOICE) != eMCDRV_SRC_NONE)
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_AE:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(McResCtrl_GetAESource() != eMCDRV_SRC_NONE)
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_CDSP:
		break;

	case	eMCDRV_DST_ADC0:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON))
			{
				bUsed	= 1;
			}
		}
		else if(eCh == eMCDRV_DST_CH1)
		{
			if(((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_R_BLOCK] & MCDRV_SRC1_LINE1_R_ON) == MCDRV_SRC1_LINE1_R_ON)
			|| ((gsGlobalInfo.sPathInfo.asAdc0[1].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON))
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	case	eMCDRV_DST_ADC1:
		if(McDevProf_IsValid(eMCDRV_FUNC_ADC1) == 1)
		{
			if(eCh == eMCDRV_DST_CH0)
			{
				if(((gsGlobalInfo.sPathInfo.asAdc1[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
				|| ((gsGlobalInfo.sPathInfo.asAdc1[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
				|| ((gsGlobalInfo.sPathInfo.asAdc1[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON)
				|| ((gsGlobalInfo.sPathInfo.asAdc1[0].abSrcOnOff[MCDRV_SRC_LINE1_L_BLOCK] & MCDRV_SRC1_LINE1_L_ON) == MCDRV_SRC1_LINE1_L_ON)
				|| ((gsGlobalInfo.sPathInfo.asAdc1[0].abSrcOnOff[MCDRV_SRC_LINE1_M_BLOCK] & MCDRV_SRC1_LINE1_M_ON) == MCDRV_SRC1_LINE1_M_ON))
				{
					bUsed	= 1;
				}
			}
			else
			{
			}
		}
		break;

	case	eMCDRV_DST_MIX:
		if(eCh != 0)
		{
			break;
		}
		if(((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_PDM_BLOCK] & MCDRV_SRC4_PDM_ON) == MCDRV_SRC4_PDM_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_ADC0_BLOCK] & MCDRV_SRC4_ADC0_ON) == MCDRV_SRC4_ADC0_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR0_BLOCK] & MCDRV_SRC3_DIR0_ON) == MCDRV_SRC3_DIR0_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR1_BLOCK] & MCDRV_SRC3_DIR1_ON) == MCDRV_SRC3_DIR1_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_DIR2_BLOCK] & MCDRV_SRC3_DIR2_ON) == MCDRV_SRC3_DIR2_ON)
		|| ((gsGlobalInfo.sPathInfo.asMix[0].abSrcOnOff[MCDRV_SRC_AE_BLOCK] & MCDRV_SRC6_AE_ON) == MCDRV_SRC6_AE_ON))
		{
			bUsed	= 1;
		}
		break;

	case	eMCDRV_DST_BIAS:
		if(eCh == eMCDRV_DST_CH0)
		{
			if(((gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC1_BLOCK] & MCDRV_SRC0_MIC1_ON) == MCDRV_SRC0_MIC1_ON)
			|| ((gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC2_BLOCK] & MCDRV_SRC0_MIC2_ON) == MCDRV_SRC0_MIC2_ON)
			|| ((gsGlobalInfo.sPathInfo.asBias[0].abSrcOnOff[MCDRV_SRC_MIC3_BLOCK] & MCDRV_SRC0_MIC3_ON) == MCDRV_SRC0_MIC3_ON))
			{
				bUsed	= 1;
			}
		}
		else
		{
		}
		break;

	default:
		break;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= (SINT32)bUsed;
	McDebugLog_FuncOut("McResCtrl_IsDstUsed", &sdRet);
#endif

	return bUsed;
}

/****************************************************************************
 *	McResCtrl_GetRegAccess
 *
 *	Description:
 *			Get register access availability
 *	Arguments:
 *			psRegInfo	register information
 *	Return:
 *			MCDRV_REG_ACCSESS
 *
 ****************************************************************************/
MCDRV_REG_ACCSESS	McResCtrl_GetRegAccess
(
	const MCDRV_REG_INFO*	psRegInfo
)
{
	MCDRV_REG_ACCSESS	eAccess	= eMCDRV_ACCESS_DENY;

#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_GetRegAccess");
#endif

	switch(psRegInfo->bRegType)
	{
	case	MCDRV_REGTYPE_A:
		eAccess	= gawRegAccessAvailableA[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_B_BASE:
		eAccess	= gawRegAccessAvailableB_BASE[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_B_ANALOG:
		eAccess	= gawRegAccessAvailableB_ANA[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_B_CODEC:
		eAccess	= gawRegAccessAvailableB_CODEC[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_B_MIXER:
		eAccess	= gawRegAccessAvailableB_MIX[psRegInfo->bAddress];
		break;
	case	MCDRV_REGTYPE_B_AE:
		eAccess	= gawRegAccessAvailableB_AE[psRegInfo->bAddress];
		break;
	default:
		break;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	sdRet	= eAccess;
	McDebugLog_FuncOut("McResCtrl_GetRegAccess", &sdRet);
#endif

	return eAccess;
}

/****************************************************************************
 *	McResCtrl_GetAPMode
 *
 *	Description:
 *			get auto power management mode.
 *	Arguments:
 *			none
 *	Return:
 *			eMCDRV_APM_ON
 *			eMCDRV_APM_OFF
 *
 ****************************************************************************/
MCDRV_PMODE	McResCtrl_GetAPMode
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet	= gsGlobalInfo.eAPMode;
	McDebugLog_FuncIn("McResCtrl_GetAPMode");
#endif

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_GetAPMode", &sdRet);
#endif

	return gsGlobalInfo.eAPMode;
}


/****************************************************************************
 *	McResCtrl_AllocPacketBuf
 *
 *	Description:
 *			allocate the buffer for register setting packets.
 *	Arguments:
 *			none
 *	Return:
 *			pointer to the area to store packets
 *
 ****************************************************************************/
MCDRV_PACKET*	McResCtrl_AllocPacketBuf
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	SINT32	sdRet;
	McDebugLog_FuncIn("McResCtrl_AllocPacketBuf");
#endif

	if(eMCDRV_PACKETBUF_ALLOCATED == gsGlobalInfo.ePacketBufAlloc)
	{
		#if (MCDRV_DEBUG_LEVEL>=4)
			sdRet	= 0;
			McDebugLog_FuncOut("McResCtrl_AllocPacketBuf", &sdRet);
		#endif
		return NULL;
	}

	gsGlobalInfo.ePacketBufAlloc = eMCDRV_PACKETBUF_ALLOCATED;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_AllocPacketBuf", 0);
#endif
	return gasPacket;
}

/****************************************************************************
 *	McResCtrl_ReleasePacketBuf
 *
 *	Description:
 *			Release the buffer for register setting packets.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_ReleasePacketBuf
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_ReleasePacketBuf");
#endif

	gsGlobalInfo.ePacketBufAlloc = eMCDRV_PACKETBUF_FREE;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_ReleasePacketBuf", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_InitRegUpdate
 *
 *	Description:
 *			Initialize the process of register update.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_InitRegUpdate
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_InitRegUpdate");
#endif

	gsGlobalInfo.sCtrlPacket.wDataNum	= 0;
	gsGlobalInfo.wCurSlaveAddress		= 0xFFFF;
	gsGlobalInfo.wCurRegType			= 0xFFFF;
	gsGlobalInfo.wCurRegAddress			= 0xFFFF;
	gsGlobalInfo.wDataContinueCount		= 0;
	gsGlobalInfo.wPrevAddressIndex		= 0;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_InitRegUpdate", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_AddRegUpdate
 *
 *	Description:
 *			Add register update packet and save register value.
 *	Arguments:
 *			wRegType	register type
 *			wAddress	address
 *			bData		write data
 *			eUpdateMode	updete mode
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_AddRegUpdate
(
	UINT16	wRegType,
	UINT16	wAddress,
	UINT8	bData,
	MCDRV_UPDATE_MODE	eUpdateMode
)
{
	UINT8			*pbRegVal;
	UINT8			bAddressADR;
	UINT8			bAddressWINDOW;
	UINT8			*pbCtrlData;
	UINT16			*pwCtrlDataNum;
	const UINT16	*pwNextAddress;
	UINT16			wNextAddress;
	UINT16			wSlaveAddress;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_AddRegUpdate");
#endif

	switch (wRegType)
	{
	case MCDRV_PACKET_REGTYPE_A:
		wSlaveAddress	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		pbRegVal		= gsGlobalInfo.abRegValA;
		pwNextAddress	= gawNextAddressA;
		bAddressADR		= (UINT8)wAddress;
		bAddressWINDOW	= bAddressADR;
		if(MCDRV_A_REG_NUM <= wAddress)
		{
			#if (MCDRV_DEBUG_LEVEL>=4)
				McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
			#endif
			return;
		}
		break;

	case MCDRV_PACKET_REGTYPE_B_BASE:
		wSlaveAddress	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		pbRegVal		= gsGlobalInfo.abRegValB_BASE;
		pwNextAddress	= gawNextAddressB_BASE;
		bAddressADR		= MCI_BASE_ADR;
		bAddressWINDOW	= MCI_BASE_WINDOW;
		if(MCDRV_B_BASE_REG_NUM <= wAddress)
		{
			#if (MCDRV_DEBUG_LEVEL>=4)
				McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
			#endif
			return;
		}
		break;

	case MCDRV_PACKET_REGTYPE_B_CODEC:
		wSlaveAddress	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		pbRegVal		= gsGlobalInfo.abRegValB_CODEC;
		pwNextAddress	= gawNextAddressB_CODEC;
		bAddressADR		= MCI_CD_ADR;
		bAddressWINDOW	= MCI_CD_WINDOW;
		if(MCDRV_B_CODEC_REG_NUM <= wAddress)
		{
			#if (MCDRV_DEBUG_LEVEL>=4)
				McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
			#endif
			return;
		}
		break;

	case MCDRV_PACKET_REGTYPE_B_ANA:
		wSlaveAddress	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_ANA);
		pbRegVal		= gsGlobalInfo.abRegValB_ANA;
		pwNextAddress	= gawNextAddressB_Ana;
		bAddressADR		= MCI_ANA_ADR;
		bAddressWINDOW	= MCI_ANA_WINDOW;
		if(MCDRV_B_ANA_REG_NUM <= wAddress)
		{
			#if (MCDRV_DEBUG_LEVEL>=4)
				McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
			#endif
			return;
		}
		break;

	case MCDRV_PACKET_REGTYPE_B_MIXER:
		wSlaveAddress	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		pbRegVal		= gsGlobalInfo.abRegValB_MIXER;
		pwNextAddress	= gawNextAddressB_MIXER;
		bAddressADR		= MCI_MIX_ADR;
		bAddressWINDOW	= MCI_MIX_WINDOW;
		if(MCDRV_B_MIXER_REG_NUM <= wAddress)
		{
			#if (MCDRV_DEBUG_LEVEL>=4)
				McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
			#endif
			return;
		}
		break;

	case MCDRV_PACKET_REGTYPE_B_AE:
		wSlaveAddress	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		pbRegVal		= gsGlobalInfo.abRegValB_AE;
		pwNextAddress	= gawNextAddressB_AE;
		bAddressADR		= MCI_AE_ADR;
		bAddressWINDOW	= MCI_AE_WINDOW;
		if(MCDRV_B_AE_REG_NUM <= wAddress)
		{
			#if (MCDRV_DEBUG_LEVEL>=4)
				McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
			#endif
			return;
		}
		break;

	case MCDRV_PACKET_REGTYPE_B_CDSP:
		wSlaveAddress	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		pbRegVal		= gsGlobalInfo.abRegValB_CDSP;
		pwNextAddress	= gawNextAddressB_CDSP;
		bAddressADR		= MCI_CDSP_ADR;
		bAddressWINDOW	= MCI_CDSP_WINDOW;
		if(MCDRV_B_CDSP_REG_NUM <= wAddress)
		{
			#if (MCDRV_DEBUG_LEVEL>=4)
				McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
			#endif
			return;
		}
		break;

	default:
		#if (MCDRV_DEBUG_LEVEL>=4)
			McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
		#endif
		return;
	}

	if((gsGlobalInfo.wCurSlaveAddress != 0xFFFF) && (gsGlobalInfo.wCurSlaveAddress != wSlaveAddress))
	{
		McResCtrl_ExecuteRegUpdate();
		McResCtrl_InitRegUpdate();
	}

	if((gsGlobalInfo.wCurRegType != 0xFFFF) && (gsGlobalInfo.wCurRegType != wRegType))
	{
		McResCtrl_ExecuteRegUpdate();
		McResCtrl_InitRegUpdate();
	}

	if((eMCDRV_UPDATE_FORCE == eUpdateMode) || (bData != pbRegVal[wAddress]))
	{
		if(gsGlobalInfo.wCurRegAddress == 0xFFFF)
		{
			gsGlobalInfo.wCurRegAddress	= wAddress;
		}

		if (eMCDRV_UPDATE_DUMMY != eUpdateMode)
		{
			pbCtrlData		= gsGlobalInfo.sCtrlPacket.abData;
			pwCtrlDataNum	= &(gsGlobalInfo.sCtrlPacket.wDataNum);
			wNextAddress	= pwNextAddress[gsGlobalInfo.wCurRegAddress];

			if ((wSlaveAddress == gsGlobalInfo.wCurSlaveAddress)
			&& (wRegType == gsGlobalInfo.wCurRegType)
			&& (0xFFFF != wNextAddress)
			&& (wAddress != wNextAddress))
			{
				if (pwNextAddress[wNextAddress] == wAddress)
				{
					if (0 == gsGlobalInfo.wDataContinueCount)
					{
						pbCtrlData[gsGlobalInfo.wPrevAddressIndex] |= MCDRV_BURST_WRITE_ENABLE;
					}
					pbCtrlData[*pwCtrlDataNum]	= pbRegVal[wNextAddress];
					(*pwCtrlDataNum)++;
					gsGlobalInfo.wDataContinueCount++;
					wNextAddress				= pwNextAddress[wNextAddress];
				}
				else if ((0xFFFF != pwNextAddress[wNextAddress])
						&& (pwNextAddress[pwNextAddress[wNextAddress]] == wAddress))
				{
					if (0 == gsGlobalInfo.wDataContinueCount)
					{
						pbCtrlData[gsGlobalInfo.wPrevAddressIndex] |= MCDRV_BURST_WRITE_ENABLE;
					}
					pbCtrlData[*pwCtrlDataNum]	= pbRegVal[wNextAddress];
					(*pwCtrlDataNum)++;
					pbCtrlData[*pwCtrlDataNum]	= pbRegVal[pwNextAddress[wNextAddress]];
					(*pwCtrlDataNum)++;
					gsGlobalInfo.wDataContinueCount += 2;
					wNextAddress				= pwNextAddress[pwNextAddress[wNextAddress]];
				}
				else
				{
				}
			}

			if ((0 == *pwCtrlDataNum) || (wAddress != wNextAddress))
			{
				if (0 != gsGlobalInfo.wDataContinueCount)
				{
					McResCtrl_ExecuteRegUpdate();
					McResCtrl_InitRegUpdate();
				}

				if (MCDRV_PACKET_REGTYPE_A == (UINT32)wRegType)
				{
					pbCtrlData[*pwCtrlDataNum]		= (bAddressADR << 1);
					gsGlobalInfo.wPrevAddressIndex	= *pwCtrlDataNum;
					(*pwCtrlDataNum)++;
				}
				else
				{
					pbCtrlData[(*pwCtrlDataNum)++]	= (bAddressADR << 1);
					pbCtrlData[(*pwCtrlDataNum)++]	= (UINT8)wAddress;
					pbCtrlData[*pwCtrlDataNum]		= (bAddressWINDOW << 1);
					gsGlobalInfo.wPrevAddressIndex	= (*pwCtrlDataNum)++;
				}
			}
			else
			{
				if (0 == gsGlobalInfo.wDataContinueCount)
				{
					pbCtrlData[gsGlobalInfo.wPrevAddressIndex] |= MCDRV_BURST_WRITE_ENABLE;
				}
				gsGlobalInfo.wDataContinueCount++;
			}

			pbCtrlData[(*pwCtrlDataNum)++]	= bData;
		}

		gsGlobalInfo.wCurSlaveAddress	= wSlaveAddress;
		gsGlobalInfo.wCurRegType		= wRegType;
		gsGlobalInfo.wCurRegAddress		= wAddress;

		/* save register value */
		pbRegVal[wAddress] = bData;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_AddRegUpdate", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_ExecuteRegUpdate
 *
 *	Description:
 *			Add register update packet and save register value.
 *	Arguments:
 *			none
 *	Return:
 *			none
 *
 ****************************************************************************/
void	McResCtrl_ExecuteRegUpdate
(
	void
)
{
#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_ExecuteRegUpdate");
#endif

	if (0 != gsGlobalInfo.sCtrlPacket.wDataNum)
	{
		McSrv_WriteI2C((UINT8)gsGlobalInfo.wCurSlaveAddress, gsGlobalInfo.sCtrlPacket.abData, gsGlobalInfo.sCtrlPacket.wDataNum);
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_ExecuteRegUpdate", 0);
#endif
}

/****************************************************************************
 *	McResCtrl_WaitEvent
 *
 *	Description:
 *			Wait event.
 *	Arguments:
 *			dEvent	event to wait
 *			dParam	event parameter
 *	Return:
 *			MCDRV_SUCCESS
 *			MCDRV_ERROR_TIMEOUT
 *
 ****************************************************************************/
SINT32	McResCtrl_WaitEvent
(
	UINT32	dEvent,
	UINT32	dParam
)
{
	SINT32	sdRet	= MCDRV_SUCCESS;
	UINT32	dInterval;
	UINT32	dTimeOut;
	UINT8	bSlaveAddr;
	UINT8	abWriteData[2];

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("McResCtrl_WaitEvent");
#endif


	switch(dEvent)
	{
	case	MCDRV_EVT_INSFLG:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		if((dParam>>8) != (UINT32)0)
		{
			abWriteData[0]	= MCI_MIX_ADR<<1;
			abWriteData[1]	= MCI_DAC_INS_FLAG;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, MCI_MIX_WINDOW, (UINT8)(dParam>>8), dInterval, dTimeOut);
			if(MCDRV_SUCCESS != sdRet)
			{
				break;
			}
		}
		else if((dParam&(UINT32)0xFF) != (UINT32)0)
		{
			abWriteData[0]	= MCI_MIX_ADR<<1;
			abWriteData[1]	= MCI_INS_FLAG;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (UINT8)(dParam&(UINT32)0xFF), dInterval, dTimeOut);
		}
		else
		{
		}
		break;

	case	MCDRV_EVT_ALLMUTE:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_DIT_INVFLAGL;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_DIT0_INVFLAGL|MCB_DIT1_INVFLAGL|MCB_DIT2_INVFLAGL), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_DIT_INVFLAGR;
		McSrv_WriteI2C(McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG), abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_DIT0_INVFLAGR|MCB_DIT1_INVFLAGR|MCB_DIT2_INVFLAGR), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_DIR_VFLAGL;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_PDM0_VFLAGL|MCB_DIR0_VFLAGL|MCB_DIR1_VFLAGL|MCB_DIR2_VFLAGL), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_DIR_VFLAGR;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_PDM0_VFLAGR|MCB_DIR0_VFLAGR|MCB_DIR1_VFLAGR|MCB_DIR2_VFLAGR), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_AD_VFLAGL;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_ADC_VFLAGL|MCB_AENG6_VFLAGL), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_AD_VFLAGR;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_ADC_VFLAGR|MCB_AENG6_VFLAGR), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_AFLAGL;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_ADC_AFLAGL|MCB_DIR0_AFLAGL|MCB_DIR1_AFLAGL|MCB_DIR2_AFLAGL), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_AFLAGR;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_ADC_AFLAGR|MCB_DIR0_AFLAGR|MCB_DIR1_AFLAGR|MCB_DIR2_AFLAGR), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_DAC_FLAGL;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_ST_FLAGL|MCB_MASTER_OFLAGL|MCB_VOICE_FLAGL|MCB_DAC_FLAGL), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_MIX_ADR<<1;
		abWriteData[1]	= MCI_DAC_FLAGR;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (MCB_ST_FLAGR|MCB_MASTER_OFLAGR|MCB_VOICE_FLAGR|MCB_DAC_FLAGR), dInterval, dTimeOut);
		break;

	case	MCDRV_EVT_DITMUTE:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		if((dParam>>8) != (UINT32)0)
		{
			abWriteData[0]	= MCI_MIX_ADR<<1;
			abWriteData[1]	= MCI_DIT_INVFLAGL;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (UINT8)(dParam>>8), dInterval, dTimeOut);
			if(MCDRV_SUCCESS != sdRet)
			{
				break;
			}
		}
		if((dParam&(UINT32)0xFF) != (UINT32)0)
		{
			abWriteData[0]	= MCI_MIX_ADR<<1;
			abWriteData[1]	= MCI_DIT_INVFLAGR;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (UINT8)(dParam&(UINT32)0xFF), dInterval, dTimeOut);
		}
		break;

	case	MCDRV_EVT_DACMUTE:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		if((dParam>>8) != (UINT32)0)
		{
			abWriteData[0]	= MCI_MIX_ADR<<1;
			abWriteData[1]	= MCI_DAC_FLAGL;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (UINT8)(dParam>>8), dInterval, dTimeOut);
			if(MCDRV_SUCCESS != sdRet)
			{
				break;
			}
		}
		if((dParam&(UINT32)0xFF) != (UINT32)0)
		{
			abWriteData[0]	= MCI_MIX_ADR<<1;
			abWriteData[1]	= MCI_DAC_FLAGR;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, (UINT8)(dParam&(UINT32)0xFF), dInterval, dTimeOut);
		}
		break;

	case	MCDRV_EVT_SVOL_DONE:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_ANA);
		if((dParam>>8) != (UINT32)0)
		{
			abWriteData[0]	= MCI_ANA_ADR<<1;
			abWriteData[1]	= MCI_BUSY1;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_ANA_WINDOW, (UINT8)(dParam>>8), dInterval, dTimeOut);
			if(MCDRV_SUCCESS != sdRet)
			{
				break;
			}
		}
		if((dParam&(UINT32)0xFF) != (UINT32)0)
		{
			abWriteData[0]	= MCI_ANA_ADR<<1;
			abWriteData[1]	= MCI_BUSY2;
			McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
			sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_ANA_WINDOW, (UINT8)(dParam&(UINT8)0xFF), dInterval, dTimeOut);
		}
		break;

	case	MCDRV_EVT_APM_DONE:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_ANA);
		abWriteData[0]	= MCI_ANA_ADR<<1;
		abWriteData[1]	= MCI_AP_A1;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitSet(bSlaveAddr, (UINT16)MCI_ANA_WINDOW, (UINT8)(dParam>>8), dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			break;
		}
		abWriteData[0]	= MCI_ANA_ADR<<1;
		abWriteData[1]	= MCI_AP_A2;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitSet(bSlaveAddr, (UINT16)MCI_ANA_WINDOW, (UINT8)(dParam&(UINT8)0xFF), dInterval, dTimeOut);
		break;

	case	MCDRV_EVT_ANA_RDY:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dAnaRdyInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dAnaRdyTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_ANA);
		abWriteData[0]	= MCI_ANA_ADR<<1;
		abWriteData[1]	= MCI_RDY_FLAG;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitSet(bSlaveAddr, (UINT16)MCI_ANA_WINDOW, (UINT8)dParam, dInterval, dTimeOut);
		break;

	case	MCDRV_EVT_SYSEQ_FLAG_RESET:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		abWriteData[0]	= MCI_CD_ADR<<1;
		abWriteData[1]	= MCI_SYSTEM_EQON;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_CD_WINDOW, MCB_SYSEQ_FLAG, dInterval, dTimeOut);
		break;

	case	MCDRV_EVT_CLKBUSY_RESET:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		abWriteData[0]	= MCI_CD_ADR<<1;
		abWriteData[1]	= MCI_DPADIF;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_CD_WINDOW, MCB_CLKBUSY, dInterval, dTimeOut);
		break;

	case	MCDRV_EVT_CLKSRC_SET:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		abWriteData[0]	= MCI_CD_ADR<<1;
		abWriteData[1]	= MCI_DPADIF;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitSet(bSlaveAddr, (UINT16)MCI_CD_WINDOW, MCB_CLKSRC, dInterval, dTimeOut);
		break;

	case	MCDRV_EVT_CLKSRC_RESET:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		abWriteData[0]	= MCI_CD_ADR<<1;
		abWriteData[1]	= MCI_DPADIF;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_CD_WINDOW, MCB_CLKSRC, dInterval, dTimeOut);
		break;

	case	MCDRV_EVT_ADCMUTE:
		dInterval	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolInterval;
		dTimeOut	= gsGlobalInfo.sInitInfo.sWaitTime.dSvolTimeOut;
		bSlaveAddr 	= McDevProf_GetSlaveAddr(eMCDRV_SLAVE_ADDR_DIG);
		abWriteData[0] 	 = MCI_MIX_ADR<<1;
		abWriteData[1] 	 = MCI_AD_VFLAGL;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, MCB_ADC_VFLAGL, dInterval, dTimeOut);
		if(MCDRV_SUCCESS != sdRet)
		{
			 break;
		}
		abWriteData[1] 	 = MCI_AD_VFLAGR;
		McSrv_WriteI2C(bSlaveAddr, abWriteData, 2);
		sdRet	= WaitBitRelease(bSlaveAddr, (UINT16)MCI_MIX_WINDOW, MCB_ADC_VFLAGR, dInterval, dTimeOut);
		break;


	default:
		sdRet	= MCDRV_ERROR_ARGUMENT;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("McResCtrl_WaitEvent", &sdRet);
#endif

	return sdRet;
}

/****************************************************************************
 *	WaitBitSet
 *
 *	Description:
 *			Wait register bit to set.
 *	Arguments:
 *			bSlaveAddr	slave address
 *			wRegAddr	register address
 *			bBit		bit
 *			dCycleTime	cycle time to poll [us]
 *			dTimeOut	number of read cycles for time out
 *	Return:
 *			MCDRV_SUCCESS
 *			MCDRV_ERROR_TIMEOUT
 *
 ****************************************************************************/
static SINT32	WaitBitSet
(
	UINT8	bSlaveAddr,
	UINT16	wRegAddr,
	UINT8	bBit,
	UINT32	dCycleTime,
	UINT32	dTimeOut
)
{
	UINT8	bData;
	UINT32	dCycles;
	SINT32	sdRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("WaitBitSet");
#endif


	dCycles	= 0;
	sdRet	= MCDRV_ERROR_TIMEOUT;

	while(dCycles < dTimeOut)
	{
		bData	= McSrv_ReadI2C(bSlaveAddr, wRegAddr);
		if((bData & bBit) == bBit)
		{
			sdRet	= MCDRV_SUCCESS;
			break;
		}

		McSrv_Sleep(dCycleTime);
		dCycles++;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("WaitBitSet", &sdRet);
#endif

	return sdRet;
}

/****************************************************************************
 *	WaitBitRelease
 *
 *	Description:
 *			Wait register bit to release.
 *	Arguments:
 *			bSlaveAddr	slave address
 *			wRegAddr	register address
 *			bBit		bit
 *			dCycleTime	cycle time to poll [us]
 *			dTimeOut	number of read cycles for time out
 *	Return:
 *			MCDRV_SUCCESS
 *			MCDRV_ERROR_TIMEOUT
 *
 ****************************************************************************/
static SINT32	WaitBitRelease
(
	UINT8	bSlaveAddr,
	UINT16	wRegAddr,
	UINT8	bBit,
	UINT32	dCycleTime,
	UINT32	dTimeOut
)
{
	UINT8	bData;
	UINT32	dCycles;
	SINT32	sdRet;

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncIn("WaitBitRelease");
#endif


	dCycles	= 0;
	sdRet	= MCDRV_ERROR_TIMEOUT;

	while(dCycles < dTimeOut)
	{
		bData	= McSrv_ReadI2C(bSlaveAddr, wRegAddr);
		if(0 == (bData & bBit))
		{
			sdRet	= MCDRV_SUCCESS;
			break;
		}

		McSrv_Sleep(dCycleTime);
		dCycles++;
	}

#if (MCDRV_DEBUG_LEVEL>=4)
	McDebugLog_FuncOut("WaitBitRelease", &sdRet);
#endif

	return sdRet;
}

