/*
 * MC-1N2 ASoC codec driver
 *
 * Copyright (c) 2010-2011 Yamaha Corporation
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

#ifndef MC1N2_CFG_H
#define MC1N2_CFG_H

#include "mcdriver.h"

/*
 * ALSA Version
 */
/* #define ALSA_VER_1_0_19 */
/* #define ALSA_VER_1_0_21 */
/* #define ALSA_VER_1_0_23 */
/* #define ALSA_VER_ANDROID_2_6_35 */
#define ALSA_VER_ANDROID_3_0

#define DIO0_DAI_ENABLE
/* #define DIO1_DAI_ENABLE */
/* #define DIO2_DAI_ENABLE */

#ifdef ALSA_VER_ANDROID_3_0
static struct mc1n2_setup mc1n2_cfg_setup = {
	{  /* MCDRV_INIT_INFO */
		MCDRV_CKSEL_CMOS, /* bCkSel */
		41,               /* bDivR0 */
		126,              /* bDivF0 */
		41,               /* bDivR1 */
		126,              /* bDivF1 */
		0,                /* bRange0*/
		0,                /* bRange1*/
		0,                /* bBypass*/
		MCDRV_DAHIZ_LOW,  /* bDioSdo0Hiz */
		MCDRV_DAHIZ_LOW,  /* bDioSdo1Hiz */
		MCDRV_DAHIZ_LOW,  /* bDioSdo2Hiz */
		MCDRV_DAHIZ_HIZ,  /* bDioClk0Hiz */
		MCDRV_DAHIZ_HIZ,  /* bDioClk1Hiz */
		MCDRV_DAHIZ_HIZ,  /* bDioClk2Hiz */
		MCDRV_PCMHIZ_HIZ, /* bPcmHiz */
		MCDRV_LINE_STEREO,/* bLineIn1Dif */
		0,                /* bLineIn2Dif */
		MCDRV_LINE_STEREO,/* bLineOut1Dif */
		MCDRV_LINE_STEREO,/* bLineOUt2Dif */
		MCDRV_SPMN_ON,    /* bSpmn */
		MCDRV_MIC_DIF,    /* bMic1Sng */
		MCDRV_MIC_DIF,    /* bMic2Sng */
		MCDRV_MIC_DIF,    /* bMic3Sng */
		MCDRV_POWMODE_NORMAL, /* bPowerMode */
		MCDRV_SPHIZ_PULLDOWN, /* bSpHiz */
		MCDRV_LDO_ON,     /* bLdo */
		MCDRV_PAD_GPIO,   /* bPad0Func */
		MCDRV_PAD_GPIO,   /* bPad1Func */
		MCDRV_PAD_GPIO,   /* bPad2Func */
		MCDRV_OUTLEV_4,   /* bAvddLev */
		0,                /* bVrefLev */
		MCDRV_DCLGAIN_12, /* bDclGain */
		MCDRV_DCLLIMIT_0, /* bDclLimit */
		1,                   /* set Hi-power mode 0: HP mode 1: normal */
		0,                /* bReserved1 */
		0,                /* bReserved2 */
		0,                /* bReserved3 */
		0,                /* bReserved4 */
		0,                /* bReserved5 */
		{                 /* sWaitTime */
			130000,         /* dAdHpf */
			25000,          /* dMic1Cin */
			25000,          /* dMic2Cin */
			25000,          /* dMic3Cin */
			25000,          /* dLine1Cin */
			25000,          /* dLine2Cin */
			5000,           /* dVrefRdy1 */
			15000,          /* dVrefRdy2 */
			9000,           /* dHpRdy */
			13000,          /* dSpRdy */
			0,              /* dPdm */
			1000,           /* dAnaRdyInterval */
			1000,           /* dSvolInterval */
			1000,           /* dAnaRdyTimeOut */
			1000            /* dSvolTimeOut */
		}
	}, /* MCDRV_INIT_INFO end */
	{  /* pcm_extend */
		0, 0, 0
	}, /* pcm_extend end */
	{  /* pcm_hiz_redge */
		MCDRV_PCMHIZTIM_FALLING, MCDRV_PCMHIZTIM_FALLING, MCDRV_PCMHIZTIM_FALLING
	}, /* pcm_hiz_redge end */
	{  /* pcm_hperiod */
		1, 1, 1
	}, /* pcm_hperiod end */
	{  /* slot */
		{ {0, 1}, {0, 1} },
		{ {0, 1}, {0, 1} },
		{ {0, 1}, {0, 1} }
	},
};
#endif

static const MCDRV_DIO_INFO stDioInfo_Default = {
	{
		/* DIO port 0 */
		{
			/* sDioCommon */
			{
				/* bMasterSlave : Master / Slave Setting */
				/*     MCDRV_DIO_SLAVE (0)  : Slave      */
				/*     MCDRV_DIO_MASTER(1)  : Master     */
				MCDRV_DIO_MASTER,
				/* bAutoFs : Sampling frequency automatic measurement ON/OFF Setting in slave mode */
				/*     MCDRV_AUTOFS_OFF(0)  : OFF */
				/*     MCDRV_AUTOFS_ON (1)  : ON  */
				MCDRV_AUTOFS_ON ,
				/* bFs : Sampling Rate Setting        */
				/*     MCDRV_FS_48000(0)  : 48kHz     */
				/*     MCDRV_FS_44100(1)  : 44.1kHz   */
				/*     MCDRV_FS_32000(2)  : 32kHz     */
				/*     MCDRV_FS_24000(4)  : 24kHz     */
				/*     MCDRV_FS_22050(5)  : 22.05kHz  */
				/*     MCDRV_FS_16000(6)  : 16kHz     */
				/*     MCDRV_FS_12000(8)  : 12kHz     */
				/*     MCDRV_FS_11025(9)  : 11.025kHz */
				/*     MCDRV_FS_8000 (10) : 8kHz      */
				MCDRV_FS_44100,
				/* bBckFs : Bit Clock Frequency Setting */
				/*     MCDRV_BCKFS_64 (0)  : LRCK x  64 */
				/*     MCDRV_BCKFS_48 (1)  : LRCK x  48 */
				/*     MCDRV_BCKFS_32 (2)  : LRCK x  32 */
				/*     MCDRV_BCKFS_512(4)  : LRCK x 512 */
				/*     MCDRV_BCKFS_256(5)  : LRCK x 256 */
				/*     MCDRV_BCKFS_128(6)  : LRCK x 128 */
				/*     MCDRV_BCKFS_16 (7)  : LRCK x  16 */
				MCDRV_BCKFS_32,
				/* bInterface : Interface Selection      */
				/*     MCDRV_DIO_DA (0)  : Digital Audio */
				/*     MCDRV_DIO_PCM(1)  : PCM           */
				MCDRV_DIO_DA,
				/* bBckInvert : Bit Clock Inversion Setting     */
				/*     MCDRV_BCLK_NORMAL(0)  : Normal Operation */
				/*     MCDRV_BCLK_INVERT(1)  : Clock Inverted   */
				MCDRV_BCLK_NORMAL,
				/* bPcmHizTim : High Impedance transition timing after transmitting the last PCM I/F data */
				/*     MCDRV_PCMHIZTIM_FALLING(0)  : BCLK#* Falling Edge */
				/*     MCDRV_PCMHIZTIM_RISING (1)  : BCLK#* Rising Edge  */
				MCDRV_PCMHIZTIM_FALLING,
				/* bPcmClkDown : Bit Clock Setting with PCM selected and Master selected                */
				/*     MCDRV_PCM_CLKDOWN_OFF (0)  : A bit clock value specified with bBckFs             */
				/*     MCDRV_PCM_CLKDOWN_HALF(1)  : A half of the bit clock value specified with bBckFs */
				MCDRV_PCM_CLKDOWN_OFF,
				/* bPcmFrame : Frame Mode Setting with PCM interface */
				/*     MCDRV_PCM_SHORTFRAME(0)  : Short Frame        */
				/*     MCDRV_PCM_LONGFRAME (1)  : Long Frame         */
				MCDRV_PCM_SHORTFRAME,
				/* bPcmHighPeriod : LR clock High time setting with PCM selected and Master selected */
				/*     0 to 31  : High level keeps during the period of time of         */
				/*                (setting value + 1) of the bit clock.                 */
				0,
			},
			/* sDir       */
			{
				/* wSrcRate : Sampling Rate Converter Setting */
				0,
				/* sDaFormat : Digital Audio Format Information */
				{
					/* bBitSel : Bit Width Setting     */
					/*     MCDRV_BITSEL_16(0)  : 16bit */
					/*     MCDRV_BITSEL_20(1)  : 20bit */
					/*     MCDRV_BITSEL_24(2)  : 24bit */
					MCDRV_BITSEL_16,
					/* bMode : Data Format Setting                             */
					/*     MCDRV_DAMODE_HEADALIGN(0)  : Left-justified Format  */
					/*     MCDRV_DAMODE_I2S      (1)  : I2S                    */
					/*     MCDRV_DAMODE_TAILALIGN(2)  : Right-justified Format */
					MCDRV_DAMODE_I2S
				},
				/* sPcmFormat : PCM Format Information */
				{
					/* bMono : Mono / Stereo Setting  */
					/*     MCDRV_PCM_STEREO(0) Stereo */
					/*     MCDRV_PCM_MONO  (1) Mono   */
					MCDRV_PCM_MONO ,
					/* bOrder : Bit Order Setting                                     */
					/*     MCDRV_PCM_MSB_FIRST      (0)  : MSB First                  */
					/*     MCDRV_PCM_LSB_FIRST      (1)  : LSB First                  */
					/*     MCDRV_PCM_MSB_FIRST_SIGN (2)  : MSB First (Sign Extension) */
					/*     MCDRV_PCM_LSB_FIRST_SIGN (3)  : LSB First (Sign Extension) */
					/*     MCDRV_PCM_MSB_FIRST_ZERO (4)  : MSB First (Zeros Padding)  */
					/*     MCDRV_PCM_LSB_FIRST_ZERO (5)  : LSB First (Zeros Padding)  */
					MCDRV_PCM_MSB_FIRST,
					/* bLaw : Data Format Setting        */
					/*     MCDRV_PCM_LINEAR(0)  : Linear */
					/*     MCDRV_PCM_ALAW  (1)  : A-Law  */
					/*     MCDRV_PCM_MULAW (2)  : u-Law */
					MCDRV_PCM_LINEAR,
					/* bBitSel : Bit Width Setting        */
					/*     MCDRV_PCM_BITSEL_8 (0)  8 bits */
					/*     MCDRV_PCM_BITSEL_13(1) 13 bits */
					/*     MCDRV_PCM_BITSEL_14(2) 14 bits */
					/*     MCDRV_PCM_BITSEL_16(3) 16 bits */
					MCDRV_PCM_BITSEL_8
				},
				/* asSlot : Setting of a slot number of data to be fed to each channel */
				{0, 1}
			},
			/* sDit       */
			{
				/* wSrcRate : Sampling Rate Converter Setting */
				0,
				/* sDaFormat : Digital Audio Format Information */
				{
					/* bBitSel : Bit Width Setting     */
					/*     MCDRV_BITSEL_16(0)  : 16bit */
					/*     MCDRV_BITSEL_20(1)  : 20bit */
					/*     MCDRV_BITSEL_24(2)  : 24bit */
					MCDRV_BITSEL_16,
					/* bMode : Data Format Setting                             */
					/*     MCDRV_DAMODE_HEADALIGN(0)  : Left-justified Format  */
					/*     MCDRV_DAMODE_I2S      (1)  : I2S                    */
					/*     MCDRV_DAMODE_TAILALIGN(2)  : Right-justified Format */
					MCDRV_DAMODE_I2S
				},
				/* sPcmFormat : PCM Format Information */
				{
					/* bMono : Mono / Stereo Setting  */
					/*     MCDRV_PCM_STEREO(0) Stereo */
					/*     MCDRV_PCM_MONO  (1) Mono   */
					MCDRV_PCM_MONO ,
					/* bOrder : Bit Order Setting                                     */
					/*     MCDRV_PCM_MSB_FIRST      (0)  : MSB First                  */
					/*     MCDRV_PCM_LSB_FIRST      (1)  : LSB First                  */
					/*     MCDRV_PCM_MSB_FIRST_SIGN (2)  : MSB First (Sign Extension) */
					/*     MCDRV_PCM_LSB_FIRST_SIGN (3)  : LSB First (Sign Extension) */
					/*     MCDRV_PCM_MSB_FIRST_ZERO (4)  : MSB First (Zeros Padding)  */
					/*     MCDRV_PCM_LSB_FIRST_ZERO (5)  : LSB First (Zeros Padding)  */
					MCDRV_PCM_MSB_FIRST,
					/* bLaw : Data Format Setting        */
					/*     MCDRV_PCM_LINEAR(0)  : Linear */
					/*     MCDRV_PCM_ALAW  (1)  : A-Law  */
					/*     MCDRV_PCM_MULAW (2)  : u-Law */
					MCDRV_PCM_LINEAR,
					/* bBitSel : Bit Width Setting        */
					/*     MCDRV_PCM_BITSEL_8 (0)  8 bits */
					/*     MCDRV_PCM_BITSEL_13(1) 13 bits */
					/*     MCDRV_PCM_BITSEL_14(2) 14 bits */
					/*     MCDRV_PCM_BITSEL_16(3) 16 bits */
					MCDRV_PCM_BITSEL_8
				},
				/* asSlot Setting of a slot number of data to be transmitted from each channel */
				{0, 1}
			}
		},
		/* DIO port 1 */
		{
			/* sDioCommon */
			{
				/* bMasterSlave : Master / Slave Setting */
				/*     MCDRV_DIO_SLAVE (0)  : Slave      */
				/*     MCDRV_DIO_MASTER(1)  : Master     */
				MCDRV_DIO_SLAVE,
				/* bAutoFs : Sampling frequency automatic measurement ON/OFF Setting in slave mode */
				/*     MCDRV_AUTOFS_OFF(0)  : OFF */
				/*     MCDRV_AUTOFS_ON (1)  : ON  */
				MCDRV_AUTOFS_ON ,
				/* bFs : Sampling Rate Setting        */
				/*     MCDRV_FS_48000(0)  : 48kHz     */
				/*     MCDRV_FS_44100(1)  : 44.1kHz   */
				/*     MCDRV_FS_32000(2)  : 32kHz     */
				/*     MCDRV_FS_24000(4)  : 24kHz     */
				/*     MCDRV_FS_22050(5)  : 22.05kHz  */
				/*     MCDRV_FS_16000(6)  : 16kHz     */
				/*     MCDRV_FS_12000(8)  : 12kHz     */
				/*     MCDRV_FS_11025(9)  : 11.025kHz */
				/*     MCDRV_FS_8000 (10) : 8kHz      */
				MCDRV_FS_8000,
				/* bBckFs : Bit Clock Frequency Setting */
				/*     MCDRV_BCKFS_64 (0)  : LRCK x  64 */
				/*     MCDRV_BCKFS_48 (1)  : LRCK x  48 */
				/*     MCDRV_BCKFS_32 (2)  : LRCK x  32 */
				/*     MCDRV_BCKFS_512(4)  : LRCK x 512 */
				/*     MCDRV_BCKFS_256(5)  : LRCK x 256 */
				/*     MCDRV_BCKFS_128(6)  : LRCK x 128 */
				/*     MCDRV_BCKFS_16 (7)  : LRCK x  16 */
				MCDRV_BCKFS_32,
				/* bInterface : Interface Selection      */
				/*     MCDRV_DIO_DA (0)  : Digital Audio */
				/*     MCDRV_DIO_PCM(1)  : PCM           */
				MCDRV_DIO_PCM,
				/* bBckInvert : Bit Clock Inversion Setting     */
				/*     MCDRV_BCLK_NORMAL(0)  : Normal Operation */
				/*     MCDRV_BCLK_INVERT(1)  : Clock Inverted   */
				MCDRV_BCLK_NORMAL,
				/* bPcmHizTim : High Impedance transition timing after transmitting the last PCM I/F data */
				/*     MCDRV_PCMHIZTIM_FALLING(0)  : BCLK#* Falling Edge */
				/*     MCDRV_PCMHIZTIM_RISING (1)  : BCLK#* Rising Edge  */
				MCDRV_PCMHIZTIM_FALLING,
				/* bPcmClkDown : Bit Clock Setting with PCM selected and Master selected                */
				/*     MCDRV_PCM_CLKDOWN_OFF (0)  : A bit clock value specified with bBckFs             */
				/*     MCDRV_PCM_CLKDOWN_HALF(1)  : A half of the bit clock value specified with bBckFs */
				MCDRV_PCM_CLKDOWN_OFF,
				/* bPcmFrame : Frame Mode Setting with PCM interface */
				/*     MCDRV_PCM_SHORTFRAME(0)  : Short Frame        */
				/*     MCDRV_PCM_LONGFRAME (1)  : Long Frame         */
				MCDRV_PCM_SHORTFRAME,
				/* bPcmHighPeriod : LR clock High time setting with PCM selected and Master selected */
				/*     0 to 31  : High level keeps during the period of time of         */
				/*                (setting value + 1) of the bit clock.                 */
				0,
			},
			/* sDir       */
			{
				/* wSrcRate : Sampling Rate Converter Setting */
				0,
				/* sDaFormat : Digital Audio Format Information */
				{
					/* bBitSel : Bit Width Setting     */
					/*     MCDRV_BITSEL_16(0)  : 16bit */
					/*     MCDRV_BITSEL_20(1)  : 20bit */
					/*     MCDRV_BITSEL_24(2)  : 24bit */
					MCDRV_BITSEL_16,
					/* bMode : Data Format Setting                             */
					/*     MCDRV_DAMODE_HEADALIGN(0)  : Left-justified Format  */
					/*     MCDRV_DAMODE_I2S      (1)  : I2S                    */
					/*     MCDRV_DAMODE_TAILALIGN(2)  : Right-justified Format */
					MCDRV_DAMODE_HEADALIGN
				},
				/* sPcmFormat : PCM Format Information */
				{
					/* bMono : Mono / Stereo Setting  */
					/*     MCDRV_PCM_STEREO(0) Stereo */
					/*     MCDRV_PCM_MONO  (1) Mono   */
					MCDRV_PCM_STEREO ,
					/* bOrder : Bit Order Setting                                     */
					/*     MCDRV_PCM_MSB_FIRST      (0)  : MSB First                  */
					/*     MCDRV_PCM_LSB_FIRST      (1)  : LSB First                  */
					/*     MCDRV_PCM_MSB_FIRST_SIGN (2)  : MSB First (Sign Extension) */
					/*     MCDRV_PCM_LSB_FIRST_SIGN (3)  : LSB First (Sign Extension) */
					/*     MCDRV_PCM_MSB_FIRST_ZERO (4)  : MSB First (Zeros Padding)  */
					/*     MCDRV_PCM_LSB_FIRST_ZERO (5)  : LSB First (Zeros Padding)  */
					MCDRV_PCM_MSB_FIRST,
					/* bLaw : Data Format Setting        */
					/*     MCDRV_PCM_LINEAR(0)  : Linear */
					/*     MCDRV_PCM_ALAW  (1)  : A-Law  */
					/*     MCDRV_PCM_MULAW (2)  : u-Law */
					MCDRV_PCM_LINEAR,
					/* bBitSel : Bit Width Setting        */
					/*     MCDRV_PCM_BITSEL_8 (0)  8 bits */
					/*     MCDRV_PCM_BITSEL_13(1) 13 bits */
					/*     MCDRV_PCM_BITSEL_14(2) 14 bits */
					/*     MCDRV_PCM_BITSEL_16(3) 16 bits */
					MCDRV_PCM_BITSEL_16
				},
				/* asSlot : Setting of a slot number of data to be fed to each channel */
				{0, 0}
			},
			/* sDit       */
			{
				/* wSrcRate : Sampling Rate Converter Setting */
				0,
				/* sDaFormat : Digital Audio Format Information */
				{
					/* bBitSel : Bit Width Setting     */
					/*     MCDRV_BITSEL_16(0)  : 16bit */
					/*     MCDRV_BITSEL_20(1)  : 20bit */
					/*     MCDRV_BITSEL_24(2)  : 24bit */
					MCDRV_BITSEL_16,
					/* bMode : Data Format Setting                             */
					/*     MCDRV_DAMODE_HEADALIGN(0)  : Left-justified Format  */
					/*     MCDRV_DAMODE_I2S      (1)  : I2S                    */
					/*     MCDRV_DAMODE_TAILALIGN(2)  : Right-justified Format */
					MCDRV_DAMODE_HEADALIGN
				},
				/* sPcmFormat : PCM Format Information */
				{
					/* bMono : Mono / Stereo Setting  */
					/*     MCDRV_PCM_STEREO(0) Stereo */
					/*     MCDRV_PCM_MONO  (1) Mono   */
					MCDRV_PCM_STEREO ,
					/* bOrder : Bit Order Setting                                     */
					/*     MCDRV_PCM_MSB_FIRST      (0)  : MSB First                  */
					/*     MCDRV_PCM_LSB_FIRST      (1)  : LSB First                  */
					/*     MCDRV_PCM_MSB_FIRST_SIGN (2)  : MSB First (Sign Extension) */
					/*     MCDRV_PCM_LSB_FIRST_SIGN (3)  : LSB First (Sign Extension) */
					/*     MCDRV_PCM_MSB_FIRST_ZERO (4)  : MSB First (Zeros Padding)  */
					/*     MCDRV_PCM_LSB_FIRST_ZERO (5)  : LSB First (Zeros Padding)  */
					MCDRV_PCM_MSB_FIRST,
					/* bLaw : Data Format Setting        */
					/*     MCDRV_PCM_LINEAR(0)  : Linear */
					/*     MCDRV_PCM_ALAW  (1)  : A-Law  */
					/*     MCDRV_PCM_MULAW (2)  : u-Law */
					MCDRV_PCM_LINEAR,
					/* bBitSel : Bit Width Setting        */
					/*     MCDRV_PCM_BITSEL_8 (0)  8 bits */
					/*     MCDRV_PCM_BITSEL_13(1) 13 bits */
					/*     MCDRV_PCM_BITSEL_14(2) 14 bits */
					/*     MCDRV_PCM_BITSEL_16(3) 16 bits */
					MCDRV_PCM_BITSEL_16
				},
				/* asSlot Setting of a slot number of data to be transmitted from each channel */
				{0, 1}
			}
		},
		/* DIO port 2 */
		{
			/* sDioCommon */
			{
				/* bMasterSlave : Master / Slave Setting */
				/*     MCDRV_DIO_SLAVE (0)  : Slave      */
				/*     MCDRV_DIO_MASTER(1)  : Master     */
				MCDRV_DIO_MASTER,
				/* bAutoFs : Sampling frequency automatic measurement ON/OFF Setting in slave mode */
				/*     MCDRV_AUTOFS_OFF(0)  : OFF */
				/*     MCDRV_AUTOFS_ON (1)  : ON  */
				MCDRV_AUTOFS_ON ,
				/* bFs : Sampling Rate Setting        */
				/*     MCDRV_FS_48000(0)  : 48kHz     */
				/*     MCDRV_FS_44100(1)  : 44.1kHz   */
				/*     MCDRV_FS_32000(2)  : 32kHz     */
				/*     MCDRV_FS_24000(4)  : 24kHz     */
				/*     MCDRV_FS_22050(5)  : 22.05kHz  */
				/*     MCDRV_FS_16000(6)  : 16kHz     */
				/*     MCDRV_FS_12000(8)  : 12kHz     */
				/*     MCDRV_FS_11025(9)  : 11.025kHz */
				/*     MCDRV_FS_8000 (10) : 8kHz      */
				MCDRV_FS_8000,
				/* bBckFs : Bit Clock Frequency Setting */
				/*     MCDRV_BCKFS_64 (0)  : LRCK x  64 */
				/*     MCDRV_BCKFS_48 (1)  : LRCK x  48 */
				/*     MCDRV_BCKFS_32 (2)  : LRCK x  32 */
				/*     MCDRV_BCKFS_512(4)  : LRCK x 512 */
				/*     MCDRV_BCKFS_256(5)  : LRCK x 256 */
				/*     MCDRV_BCKFS_128(6)  : LRCK x 128 */
				/*     MCDRV_BCKFS_16 (7)  : LRCK x  16 */
				MCDRV_BCKFS_32,
				/* bInterface : Interface Selection      */
				/*     MCDRV_DIO_DA (0)  : Digital Audio */
				/*     MCDRV_DIO_PCM(1)  : PCM           */
				MCDRV_DIO_PCM,
				/* bBckInvert : Bit Clock Inversion Setting     */
				/*     MCDRV_BCLK_NORMAL(0)  : Normal Operation */
				/*     MCDRV_BCLK_INVERT(1)  : Clock Inverted   */
				MCDRV_BCLK_NORMAL,
				/* bPcmHizTim : High Impedance transition timing after transmitting the last PCM I/F data */
				/*     MCDRV_PCMHIZTIM_FALLING(0)  : BCLK#* Falling Edge */
				/*     MCDRV_PCMHIZTIM_RISING (1)  : BCLK#* Rising Edge  */
				MCDRV_PCMHIZTIM_FALLING,
				/* bPcmClkDown : Bit Clock Setting with PCM selected and Master selected                */
				/*     MCDRV_PCM_CLKDOWN_OFF (0)  : A bit clock value specified with bBckFs             */
				/*     MCDRV_PCM_CLKDOWN_HALF(1)  : A half of the bit clock value specified with bBckFs */
				MCDRV_PCM_CLKDOWN_OFF,
				/* bPcmFrame : Frame Mode Setting with PCM interface */
				/*     MCDRV_PCM_SHORTFRAME(0)  : Short Frame        */
				/*     MCDRV_PCM_LONGFRAME (1)  : Long Frame         */
				MCDRV_PCM_SHORTFRAME,
				/* bPcmHighPeriod : LR clock High time setting with PCM selected and Master selected */
				/*     0 to 31  : High level keeps during the period of time of         */
				/*                (setting value + 1) of the bit clock.                 */
				0,
			},
			/* sDir       */
			{
				/* wSrcRate : Sampling Rate Converter Setting */
				0,
				/* sDaFormat : Digital Audio Format Information */
				{
					/* bBitSel : Bit Width Setting     */
					/*     MCDRV_BITSEL_16(0)  : 16bit */
					/*     MCDRV_BITSEL_20(1)  : 20bit */
					/*     MCDRV_BITSEL_24(2)  : 24bit */
					MCDRV_BITSEL_16,
					/* bMode : Data Format Setting                             */
					/*     MCDRV_DAMODE_HEADALIGN(0)  : Left-justified Format  */
					/*     MCDRV_DAMODE_I2S      (1)  : I2S                    */
					/*     MCDRV_DAMODE_TAILALIGN(2)  : Right-justified Format */
					MCDRV_DAMODE_HEADALIGN
				},
				/* sPcmFormat : PCM Format Information */
				{
					/* bMono : Mono / Stereo Setting  */
					/*     MCDRV_PCM_STEREO(0) Stereo */
					/*     MCDRV_PCM_MONO  (1) Mono   */
					MCDRV_PCM_STEREO ,
					/* bOrder : Bit Order Setting                                     */
					/*     MCDRV_PCM_MSB_FIRST      (0)  : MSB First                  */
					/*     MCDRV_PCM_LSB_FIRST      (1)  : LSB First                  */
					/*     MCDRV_PCM_MSB_FIRST_SIGN (2)  : MSB First (Sign Extension) */
					/*     MCDRV_PCM_LSB_FIRST_SIGN (3)  : LSB First (Sign Extension) */
					/*     MCDRV_PCM_MSB_FIRST_ZERO (4)  : MSB First (Zeros Padding)  */
					/*     MCDRV_PCM_LSB_FIRST_ZERO (5)  : LSB First (Zeros Padding)  */
					MCDRV_PCM_MSB_FIRST,
					/* bLaw : Data Format Setting        */
					/*     MCDRV_PCM_LINEAR(0)  : Linear */
					/*     MCDRV_PCM_ALAW  (1)  : A-Law  */
					/*     MCDRV_PCM_MULAW (2)  : u-Law */
					MCDRV_PCM_LINEAR,
					/* bBitSel : Bit Width Setting        */
					/*     MCDRV_PCM_BITSEL_8 (0)  8 bits */
					/*     MCDRV_PCM_BITSEL_13(1) 13 bits */
					/*     MCDRV_PCM_BITSEL_14(2) 14 bits */
					/*     MCDRV_PCM_BITSEL_16(3) 16 bits */
					MCDRV_PCM_BITSEL_16
				},
				/* asSlot : Setting of a slot number of data to be fed to each channel */
				{0, 0}
			},
			/* sDit       */
			{
				/* wSrcRate : Sampling Rate Converter Setting */
				0,
				/* sDaFormat : Digital Audio Format Information */
				{
					/* bBitSel : Bit Width Setting     */
					/*     MCDRV_BITSEL_16(0)  : 16bit */
					/*     MCDRV_BITSEL_20(1)  : 20bit */
					/*     MCDRV_BITSEL_24(2)  : 24bit */
					MCDRV_BITSEL_16,
					/* bMode : Data Format Setting                             */
					/*     MCDRV_DAMODE_HEADALIGN(0)  : Left-justified Format  */
					/*     MCDRV_DAMODE_I2S      (1)  : I2S                    */
					/*     MCDRV_DAMODE_TAILALIGN(2)  : Right-justified Format */
					MCDRV_DAMODE_HEADALIGN
				},
				/* sPcmFormat : PCM Format Information */
				{
					/* bMono : Mono / Stereo Setting  */
					/*     MCDRV_PCM_STEREO(0) Stereo */
					/*     MCDRV_PCM_MONO  (1) Mono   */
					MCDRV_PCM_MONO ,
					/* bOrder : Bit Order Setting                                     */
					/*     MCDRV_PCM_MSB_FIRST      (0)  : MSB First                  */
					/*     MCDRV_PCM_LSB_FIRST      (1)  : LSB First                  */
					/*     MCDRV_PCM_MSB_FIRST_SIGN (2)  : MSB First (Sign Extension) */
					/*     MCDRV_PCM_LSB_FIRST_SIGN (3)  : LSB First (Sign Extension) */
					/*     MCDRV_PCM_MSB_FIRST_ZERO (4)  : MSB First (Zeros Padding)  */
					/*     MCDRV_PCM_LSB_FIRST_ZERO (5)  : LSB First (Zeros Padding)  */
					MCDRV_PCM_MSB_FIRST,
					/* bLaw : Data Format Setting        */
					/*     MCDRV_PCM_LINEAR(0)  : Linear */
					/*     MCDRV_PCM_ALAW  (1)  : A-Law  */
					/*     MCDRV_PCM_MULAW (2)  : u-Law */
					MCDRV_PCM_LINEAR,
					/* bBitSel : Bit Width Setting        */
					/*     MCDRV_PCM_BITSEL_8 (0)  8 bits */
					/*     MCDRV_PCM_BITSEL_13(1) 13 bits */
					/*     MCDRV_PCM_BITSEL_14(2) 14 bits */
					/*     MCDRV_PCM_BITSEL_16(3) 16 bits */
					MCDRV_PCM_BITSEL_16
				},
				/* asSlot Setting of a slot number of data to be transmitted from each channel */
				{0, 1}
			}
		}
	}
};

/* ========================================
   DAC settings
   ========================================*/
static const MCDRV_DAC_INFO stDacInfo_Default = {
	/* bMasterSwap : DAC Master Path SWAP Setting                          */
	/*     MCDRV_DSWAP_OFF      (0)  : No SWAP                             */
	/*     MCDRV_DSWAP_SWAP     (1)  : SWAP                                */
	/*     MCDRV_DSWAP_MUTE     (2)  : MUTE                                */
	/*     MCDRV_DSWAP_RMVCENTER(3)  : Center Removed                      */
	/*     MCDRV_DSWAP_MONO     (4)  : Mono                                */
	/*     MCDRV_DSWAP_MONOHALF (5)  : Reserved (do not use this setting)  */
	/*     MCDRV_DSWAP_BOTHL    (6)  : Lch data output in both Lch and Rch */
	/*     MCDRV_DSWAP_BOTHR    (7)  : Rch data output in both Lch and Rch */
	MCDRV_DSWAP_OFF,
	/* bVoiceSwap : DAC Voice Path SWAP Setting                            */
	/*     MCDRV_DSWAP_OFF      (0)  : No SWAP                             */
	/*     MCDRV_DSWAP_SWAP     (1)  : SWAP                                */
	/*     MCDRV_DSWAP_MUTE     (2)  : MUTE                                */
	/*     MCDRV_DSWAP_RMVCENTER(3)  : Center Removed                      */
	/*     MCDRV_DSWAP_MONO     (4)  : Mono (-6dB)                         */
	/*     MCDRV_DSWAP_MONOHALF (5)  : Reserved (do not use this setting)  */
	/*     MCDRV_DSWAP_BOTHL    (6)  : Lch data output in both Lch and Rch */
	/*     MCDRV_DSWAP_BOTHR    (7)  : Rch data output in both Lch and Rch */
	MCDRV_DSWAP_OFF,
	/* bDcCut : HP, SP Protection DC-ct Filter Setting  */
	/*     MCDRV_DCCUT_ON (0)  : DC-cut Filter ON       */
	/*     MCDRV_DCCUT_OFF(1)  : DC-cut Filter OFF      */
	MCDRV_DCCUT_ON
};

/* ========================================
   ADC settings
   ========================================*/

static const MCDRV_ADC_INFO stAdcInfo_Default = {
	/* bAgcAdjust : AGC Gain Control Range     */
	/*     MCDRV_AGCADJ_24(0)  : -3dB to +24dB */
	/*     MCDRV_AGCADJ_18(1)  : -3dB to +18dB */
	/*     MCDRV_AGCADJ_12(2)  : -3dB to +12dB */
	/*     MCDRV_AGCADJ_0 (3)  : -3dB to  +0dB */
	MCDRV_AGCADJ_0,
	/* bAgcOn : AGC ON/OFF Setting */
	/*     MCDRV_AGC_OFF(0)  : OFF */
	/*     MCDRV_AGC_ON (1)  : ON  */
	MCDRV_AGC_OFF,
	/* bMonot : Mono / Stereo Setting    */
	/*     MCDRV_ADC_STEREO(0)  : Stereo */
	/*     MCDRV_ADC_MONO  (1)  : Mono   */
	MCDRV_ADC_STEREO
};

/* ========================================
   SP settings
   ========================================*/
static const MCDRV_SP_INFO stSpInfo_Default = {
	/* bSwap : Swap setting                */
	/*     MCDRV_SPSWAP_OFF (0)  : No SWAP */
	/*     MCDRV_SPSWAP_SWAP(1)  : SWAP    */
	MCDRV_SPSWAP_OFF
};

/* ========================================
   DNG settings
   ========================================*/
static const MCDRV_DNG_INFO stDngInfo_Default = {
	/* bOnOff[] : Digital Noise Gate On/Off Setting */
	/*     MCDRV_DNG_OFF(0)  : OFF                */
	/*     MCDRV_DNG_ON (1)  : ON                 */
	{MCDRV_DNG_OFF, MCDRV_DNG_OFF, MCDRV_DNG_OFF},

	/* bThreshold[] : Threshold Setting    */
	/*     MCDRV_DNG_THRES_30    (0) */
	/*     MCDRV_DNG_THRES_36    (1) */
	/*     MCDRV_DNG_THRES_42    (2) */
	/*     MCDRV_DNG_THRES_48    (3) */
	/*     MCDRV_DNG_THRES_54    (4) */
	/*     MCDRV_DNG_THRES_60    (5) */
	/*     MCDRV_DNG_THRES_66    (6) */
	/*     MCDRV_DNG_THRES_72    (7) */
	/*     MCDRV_DNG_THRES_78    (8) */
	/*     MCDRV_DNG_THRES_84    (9) */
	{MCDRV_DNG_THRES_60, MCDRV_DNG_THRES_60, MCDRV_DNG_THRES_60},

	/* bHold[] : Hold Time Setting         */
	/*     MCDRV_DNG_HOLD_30 (0)  :  30ms */
	/*     MCDRV_DNG_HOLD_120(1)  : 120ms */
	/*     MCDRV_DNG_HOLD_500(2)  : 500ms */
	{MCDRV_DNG_HOLD_500, MCDRV_DNG_HOLD_500, MCDRV_DNG_HOLD_500},

	/* bAttack[] : Attack Time Setting        */
	/*     MCDRV_DNG_ATTACK_25   (0)  :   25ms */
	/*     MCDRV_DNG_ATTACK_100  (1)  :  100ms */
	/*     MCDRV_DNG_ATTACK_400  (2)  :  400ms */
	/*     MCDRV_DNG_ATTACK_800  (3)  :  800ms */
	{MCDRV_DNG_ATTACK_100, MCDRV_DNG_ATTACK_100, MCDRV_DNG_ATTACK_100},

	/* bRelease[] : Release Time Setting        */
	/*     MCDRV_DNG_RELEASE_7950(0)  : 7.95ms */
	/*     MCDRV_DNG_RELEASE_470 (1)  : 0.47ms */
	/*     MCDRV_DNG_RELEASE_940 (2)  : 0.94ms */
	{MCDRV_DNG_RELEASE_940, MCDRV_DNG_RELEASE_940, MCDRV_DNG_RELEASE_940},

	/* bTarget[] : Target Volume Setting        */
	/*     MCDRV_DNG_TARGET_6    (0)  : -6dB  */
	/*     MCDRV_DNG_TARGET_9    (1)  : -9dB  */
	/*     MCDRV_DNG_TARGET_12   (2)  : -12dB */
	/*     MCDRV_DNG_TARGET_15   (3)  : -15dB */
	/*     MCDRV_DNG_TARGET_18   (4)  : -18dB */
	/*     MCDRV_DNG_TARGET_MUTE (5)  : Mute  */
	{MCDRV_DNG_TARGET_MUTE, MCDRV_DNG_TARGET_MUTE, MCDRV_DNG_TARGET_MUTE},
};
#if 0
static const MCDRV_DNG_INFO stDngInfo_Default = {
	/* bOnOff : Digital Noise Gate On/Off Setting */
	/*     MCDRV_DNG_OFF(0)  : OFF                */
	/*     MCDRV_DNG_ON (1)  : ON                 */
	MCDRV_DNG_OFF,

	/* bThreshold : Threshold Setting    */
	/*     MCDRV_DNG_THRES_5BIT  (0) */
	/*     MCDRV_DNG_THRES_7BIT  (1) */
	/*     MCDRV_DNG_THRES_9BIT  (2) */
	/*     MCDRV_DNG_THRES_11BIT (3) */
	/*     MCDRV_DNG_THRES_13BIT (4) */
	/*     MCDRV_DNG_THRES_15BIT (5) */
	/*     MCDRV_DNG_THRES_17BIT (6) */
	/*     MCDRV_DNG_THRES_21BIT (7) */
	MCDRV_DNG_THRES_11BIT,

	/* bHold : Hold Time Setting         */
	/*     MCDRV_DNG_HOLD_30 (0)  :  30ms */
	/*     MCDRV_DNG_HOLD_120(1)  : 120ms */
	/*     MCDRV_DNG_HOLD_500(2)  : 500ms */
	MCDRV_DNG_HOLD_500,

	/* bAttack : Attack Time Setting        */
	/*     MCDRV_DNG_ATTACK_25   (0)  :   25ms */
	/*     MCDRV_DNG_ATTACK_800  (1)  :  800ms */
	/*     MCDRV_DNG_ATTACK_1100 (2)  : 1100ms */
	MCDRV_DNG_ATTACK_1100,

	/* bRelease : Release Time Setting        */
	/*     MCDRV_DNG_RELEASE_7950(0)  : 7.95ms */
	/*     MCDRV_DNG_RELEASE_470 (1)  : 0.47ms */
	/*     MCDRV_DNG_RELEASE_940 (2)  : 0.94ms */
	MCDRV_DNG_RELEASE_940,

};
#endif

/* ========================================
   AudioEngine settings
   ========================================*/
static MCDRV_AE_INFO sAeInfo_1 = {
	/* On/Off */
	0x00,
	/* BEX */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* WIDE */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00
	},
	/* DRC */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* EQ5 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00
	},
	/* EQ3 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00
	}
};

static MCDRV_AE_INFO sAeInfo_2 = {
	/* On/Off */
	0x00,
	/* BEX */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* WIDE */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00
	},
	/* DRC */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* EQ5 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00
	},
	/* EQ3 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00
	}
};

static MCDRV_AE_INFO sAeInfo_3 = {
	/* On/Off */
	0x00,
	/* BEX */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* WIDE */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00
	},
	/* DRC */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* EQ5 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00
	},
	/* EQ3 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00
	}
};

static MCDRV_AE_INFO sAeInfo_4 = {
	/* On/Off */
	0x00,
	/* BEX */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* WIDE */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00
	},
	/* DRC */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* EQ5 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00
	},
	/* EQ3 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00
	}
};

static MCDRV_AE_INFO sAeInfo_5 = {
	/* On/Off */
	0x00,
	/* BEX */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* WIDE */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00
	},
	/* DRC */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
	},
	/* EQ5 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00
	},
	/* EQ3 */
	{
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		0x00,0x00,0x00
	}
};

/* ========================================
   System EQ settings
   ========================================*/
static MCDRV_SYSEQ_INFO stSyseqInfo_Default = {
	/* On/Off */
	0x00,
	/* EQ */
	{
		0x10,0xc4,0x50,0x12,0xc4,0x40,0x02,0xa9,
		0x60,0xed,0x3b,0xc0,0xfc,0x92,0x40,
	},
};

#endif
