/*
 * max8997-private.h - Voltage regulator driver for the Maxim 8997
 *
 *  Copyright (C) 2009-2010 Samsung Electrnoics
 *
 *  based on max8998-private.h
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LINUX_MFD_MAX8997_PRIV_H
#define __LINUX_MFD_MAX8997_PRIV_H

#define MAX8997_NUM_IRQ_PMIC_REGS	4
#define MAX8997_NUM_IRQ_MUIC_REGS	3
#define MAX8997_NUM_IRQ_REGS		(MAX8997_NUM_IRQ_PMIC_REGS +\
					 MAX8997_NUM_IRQ_MUIC_REGS)

/* MAX 8997 PMIC registers */
enum max8997_pmic_reg {
	MAX8997_REG_ID,
	MAX8997_REG_VER,
	MAX8997_REG_IRQ_SOURCE,
	MAX8997_REG_IRQ1,
	MAX8997_REG_IRQ2,
	MAX8997_REG_IRQ3,
	MAX8997_REG_IRQ4,
	MAX8997_REG_RESERVED_0x07,
	MAX8997_REG_IRQM1,
	MAX8997_REG_IRQM2,
	MAX8997_REG_IRQM3,
	MAX8997_REG_IRQM4,
	MAX8997_REG_RESERVED_0x0C,
	MAX8997_REG_STATUS1,
	MAX8997_REG_STATUS2,
	MAX8997_REG_STATUS3,
	MAX8997_REG_STATUS4,
	MAX8997_REG_RESERVED_0x11,
	MAX8997_REG_RESERVED_0x12,
	MAX8997_REG_CONTROL1,
	MAX8997_REG_CONTROL2,
	MAX8997_REG_BUCKRAMP,
	MAX8997_REG_RESERVED_0x16,
	MAX8997_REG_RESERVED_0x17,
	MAX8997_REG_BUCK1CTRL,
	MAX8997_REG_BUCK1DVSTV1,
	MAX8997_REG_BUCK1DVSTV2,
	MAX8997_REG_BUCK1DVSTV3,
	MAX8997_REG_BUCK1DVSTV4,
	MAX8997_REG_BUCK1DVSTV5,
	MAX8997_REG_BUCK1DVSTV6,
	MAX8997_REG_BUCK1DVSTV7,
	MAX8997_REG_BUCK1DVSTV8,
	MAX8997_REG_BUCK2CTRL,
	MAX8997_REG_BUCK2DVSTV1,
	MAX8997_REG_BUCK2DVSTV2,
	MAX8997_REG_BUCK2DVSTV3,
	MAX8997_REG_BUCK2DVSTV4,
	MAX8997_REG_BUCK2DVSTV5,
	MAX8997_REG_BUCK2DVSTV6,
	MAX8997_REG_BUCK2DVSTV7,
	MAX8997_REG_BUCK2DVSTV8,
	MAX8997_REG_BUCK3CTRL,
	MAX8997_REG_BUCK3DVSTV,
	MAX8997_REG_BUCK4CTRL,
	MAX8997_REG_BUCK4DVSTV,
	MAX8997_REG_BUCK5CTRL,
	MAX8997_REG_BUCK5DVSTV1,
	MAX8997_REG_BUCK5DVSTV2,
	MAX8997_REG_BUCK5DVSTV3,
	MAX8997_REG_BUCK5DVSTV4,
	MAX8997_REG_BUCK5DVSTV5,
	MAX8997_REG_BUCK5DVSTV6,
	MAX8997_REG_BUCK5DVSTV7,
	MAX8997_REG_BUCK5DVSTV8,
	MAX8997_REG_BUCK6CTRL1,
	MAX8997_REG_BUCK6CTRL2,
	MAX8997_REG_BUCK7CTRL,
	MAX8997_REG_BUCK7DVSTV,
	MAX8997_REG_LDO1CTRL,
	MAX8997_REG_LDO2CTRL,
	MAX8997_REG_LDO3CTRL,
	MAX8997_REG_LDO4CTRL,
	MAX8997_REG_LDO5CTRL,
	MAX8997_REG_LDO6CTRL,
	MAX8997_REG_LDO7CTRL,
	MAX8997_REG_LDO8CTRL,
	MAX8997_REG_LDO9CTRL,
	MAX8997_REG_LDO10CTRL,
	MAX8997_REG_LDO11CTRL,
	MAX8997_REG_LDO12CTRL,
	MAX8997_REG_LDO13CTRL,
	MAX8997_REG_LDO14CTRL,
	MAX8997_REG_LDO15CTRL,
	MAX8997_REG_LDO16CTRL,
	MAX8997_REG_LDO17CTRL,
	MAX8997_REG_LDO18CTRL,
	MAX8997_REG_LDO21CTRL,
	MAX8997_REG_RESERVED_0x4E,
	MAX8997_REG_RESERVED_0x4F,
	MAX8997_REG_MBCCTRL1,
	MAX8997_REG_MBCCTRL2,
	MAX8997_REG_MBCCTRL3,
	MAX8997_REG_MBCCTRL4,
	MAX8997_REG_MBCCTRL5,
	MAX8997_REG_MBCCTRL6,
	MAX8997_REG_OTPCGHCVS,
	MAX8997_REG_RESERVED_0x57,
	MAX8997_REG_RESERVED_0x58,
	MAX8997_REG_RESERVED_0x59,
	MAX8997_REG_SAFEOUTCTRL,
	MAX8997_REG_RESERVED_0x5B,
	MAX8997_REG_RESERVED_0x5C,
	MAX8997_REG_RESERVED_0x5D,
	MAX8997_REG_LBCNFG1,
	MAX8997_REG_LBCNFG2,
	MAX8997_REG_BBCTRL,
	MAX8997_REG_RESERVED_0x61,
	MAX8997_REG_RESERVED_0x62,
	MAX8997_REG_FLASH1_CUR,
	MAX8997_REG_FLASH2_CUR,
	MAX8997_REG_MOVIE_CUR,
	MAX8997_REG_GSMB_CUR,
	MAX8997_REG_BOOST_CNTL,
	MAX8997_REG_LED_CNTL,
	MAX8997_REG_FLASH_CNTL,
	MAX8997_REG_WDT_CNTL,
	MAX8997_REG_MAXFLASH1,
	MAX8997_REG_MAXFLASH2,
	MAX8997_REG_FLASH_STATUS,
	MAX8997_REG_FLASH_STATUS_MASK,
	MAX8997_REG_RESERVED_0x6F,
	MAX8997_REG_GPIOCNTL1,
	MAX8997_REG_GPIOCNTL2,
	MAX8997_REG_GPIOCNTL3,
	MAX8997_REG_GPIOCNTL4,
	MAX8997_REG_GPIOCNTL5,
	MAX8997_REG_GPIOCNTL6,
	MAX8997_REG_GPIOCNTL7,
	MAX8997_REG_GPIOCNTL8,
	MAX8997_REG_GPIOCNTL9,
	MAX8997_REG_GPIOCNTL10,
	MAX8997_REG_GPIOCNTL11,
	MAX8997_REG_GPIOCNTL12,
	MAX8997_REG_RESERVED_0x7C,
	MAX8997_REG_RESERVED_0x7D,
	MAX8997_REG_RESERVED_0x7E,
	MAX8997_REG_RESERVED_0x7F,
	MAX8997_REG_LDO1CONFIG,
	MAX8997_REG_LDO2CONFIG,
	MAX8997_REG_LDO3CONFIG,
	MAX8997_REG_LDO4CONFIG,
	MAX8997_REG_LDO5CONFIG,
	MAX8997_REG_LDO6CONFIG,
	MAX8997_REG_LDO7CONFIG,
	MAX8997_REG_LDO8CONFIG,
	MAX8997_REG_LDO9CONFIG,
	MAX8997_REG_LDO10CONFIG,
	MAX8997_REG_LDO11CONFIG,
	MAX8997_REG_LDO12CONFIG,
	MAX8997_REG_LDO13CONFIG,
	MAX8997_REG_LDO14CONFIG,
	MAX8997_REG_LDO15CONFIG,
	MAX8997_REG_LDO16CONFIG,
	MAX8997_REG_LDO17CONFIG,
	MAX8997_REG_LDO18CONFIG,
	MAX8997_REG_LDO21CONFIG,
	MAX8997_REG_RESERVED_0x93,
	MAX8997_REG_RESERVED_0x94,
	MAX8997_REG_RESERVED_0x95,
	MAX8997_REG_RESERVED_0x96,
	MAX8997_REG_DVSOKTIMER1,
	MAX8997_REG_DVSOKTIMER2,
	MAX8997_REG_DVSOKTIMER4,
	MAX8997_REG_DVSOKTIMER5,

	MAX8997_REG_PMIC_END
};

/* MAX8997 MUIC registers */
enum max8997_muic_reg {
	MAX8997_MUIC_REG_ID = 0,
	MAX8997_MUIC_REG_INT1,
	MAX8997_MUIC_REG_INT2,
	MAX8997_MUIC_REG_INT3,
	MAX8997_MUIC_REG_STATUS1,
	MAX8997_MUIC_REG_STATUS2,
	MAX8997_MUIC_REG_STATUS3,
	MAX8997_MUIC_REG_INTMASK1,
	MAX8997_MUIC_REG_INTMASK2,
	MAX8997_MUIC_REG_INTMASK3,
	MAX8997_MUIC_REG_CDETCTRL,
	MAX8997_MUIC_REG_RESERVED_0x0B,
	MAX8997_MUIC_REG_CTRL1,
	MAX8997_MUIC_REG_CTRL2,
	MAX8997_MUIC_REG_CTRL3,
	MAX8997_MUIC_REG_RESERVED_0x0F,

	MAX8997_MUIC_REG_END
};

enum max8997_haptic_reg {
	MAX8997_HAPTIC_REG_GENERAL      = 0x00,
	MAX8997_HAPTIC_REG_CONF1        = 0x01,
	MAX8997_HAPTIC_REG_CONF2        = 0x02,
	MAX8997_HAPTIC_REG_DRVCONF      = 0x03,
	MAX8997_HAPTIC_REG_CYCLECONF1   = 0x04,
	MAX8997_HAPTIC_REG_CYCLECONF2   = 0x05,
	MAX8997_HAPTIC_REG_SIGCONF1     = 0x06,
	MAX8997_HAPTIC_REG_SIGCONF2     = 0x07,
	MAX8997_HAPTIC_REG_SIGCONF3     = 0x08,
	MAX8997_HAPTIC_REG_SIGCONF4     = 0x09,
	MAX8997_HAPTIC_REG_SIGDC1       = 0x0a,
	MAX8997_HAPTIC_REG_SIGDC2       = 0x0b,
	MAX8997_HAPTIC_REG_SIGPWMDC1    = 0x0c,
	MAX8997_HAPTIC_REG_SIGPWMDC2    = 0x0d,
	MAX8997_HAPTIC_REG_SIGPWMDC3    = 0x0e,
	MAX8997_HAPTIC_REG_SIGPWMDC4    = 0x0f,
	MAX8997_HAPTIC_REG_MTR_REV      = 0x10,

	MAX8997_HAPTIC_REG_END          = 0x11,
};

/* IRQ definitions */
/* The interrupts for board specific purporse are only 18. */
/* refer arch/arm/mach-s5pv310/include/mach/irqs.h */
enum {
	/* PMIC / RTC */
	/** IRQ1 **/
	MAX8997_IRQ_PWRONR,
	MAX8997_IRQ_PWRONF,
	MAX8997_IRQ_PWRON1SEC,
	MAX8997_IRQ_JIGONR,
	MAX8997_IRQ_JIGONF,
	MAX8997_IRQ_LOWBAT2,
	MAX8997_IRQ_LOWBAT1,
	/** IRQ2 **/
	MAX8997_IRQ_JIGR,
	MAX8997_IRQ_JIGF,
	MAX8997_IRQ_MR,
	MAX8997_IRQ_DVS1OK,
	MAX8997_IRQ_DVS2OK,
	MAX8997_IRQ_DVS4OK,
	MAX8997_IRQ_DVS5OK,
	/** IRQ3 **/
	MAX8997_IRQ_CHGINS,
	MAX8997_IRQ_CHGRM,
	MAX8997_IRQ_DCINOVP,
	MAX8997_IRQ_TOPOFF,
	MAX8997_IRQ_CHGRSTF,
	MAX8997_IRQ_MBCHGTMEXPD,
	/** IRQ4 **/
	MAX8997_IRQ_RTC60S,
	MAX8997_IRQ_RTCA1,
	MAX8997_IRQ_RTCA2,
	MAX8997_IRQ_SMPL_INT,
	MAX8997_IRQ_RTC1S,
	MAX8997_IRQ_WTSR,
	/* MUIC */
	/** IRQ1 **/
	MAX8997_IRQ_ADC,
	MAX8997_IRQ_ADCLOW,
	MAX8997_IRQ_ADCERR,
	/** IRQ2 **/
	MAX8997_IRQ_CHGTYP,
	MAX8997_IRQ_CHGDETRUN,
	MAX8997_IRQ_DCDTMR,
	MAX8997_IRQ_DBCHG,
	MAX8997_IRQ_VBVOLT,
	/** IRQ3 **/
	MAX8997_IRQ_OVP,

	MAX8997_IRQ_NR
};

/* MAX8997 various variants */
enum {
	TYPE_MAX8997 = 0, /* Default */
};

/* Interrupt source mask */
#define MAX8997_INTR_PMIC_MASK		(1 << 1)
#define MAX8997_INTR_FUELGAUGE_MASK	(1 << 2)
#define MAX8997_INTR_MUIC_MASK		(1 << 3)
#define MAX8997_INTR_GPIO_MASK		(1 << 4)
#define MAX8997_INTR_FLASH_MASK		(1 << 5)

/* PMIC / RTC interrupt mask */
#define MAX8997_IRQ_PWRONR_MASK		(1 << 0)
#define MAX8997_IRQ_PWRONF_MASK		(1 << 1)
#define MAX8997_IRQ_PWRON1SEC_MASK	(1 << 3)
#define MAX8997_IRQ_JIGONR_MASK		(1 << 4)
#define MAX8997_IRQ_JIGONF_MASK		(1 << 5)
#define MAX8997_IRQ_LOWBAT2_MASK	(1 << 6)
#define MAX8997_IRQ_LOWBAT1_MASK	(1 << 7)

#define MAX8997_IRQ_JIGR_MASK		(1 << 0)
#define MAX8997_IRQ_JIGF_MASK		(1 << 1)
#define MAX8997_IRQ_MR_MASK		(1 << 2)
#define MAX8997_IRQ_DVS1OK_MASK		(1 << 3)
#define MAX8997_IRQ_DVS2OK_MASK		(1 << 4)
#define MAX8997_IRQ_DVS4OK_MASK		(1 << 5)
#define MAX8997_IRQ_DVS5OK_MASK		(1 << 6)

#define MAX8997_IRQ_CHGINS_MASK		(1 << 0)
#define MAX8997_IRQ_CHGRM_MASK		(1 << 1)
#define MAX8997_IRQ_DCINOVP_MASK	(1 << 2)
#define MAX8997_IRQ_TOPOFF_MASK		(1 << 3)
#define MAX8997_IRQ_CHGRSTF_MASK	(1 << 5)
#define MAX8997_IRQ_MBCHGTMEXPD_MASK	(1 << 7)

#define MAX8997_IRQ_RTC60S_MASK		(1 << 0)
#define MAX8997_IRQ_RTCA1_MASK		(1 << 1)
#define MAX8997_IRQ_RTCA2_MASK		(1 << 2)
#define MAX8997_IRQ_SMPL_INT_MASK	(1 << 3)
#define MAX8997_IRQ_RTC1S_MASK		(1 << 4)
#define MAX8997_IRQ_WTSR_MASK		(1 << 5)

/* MUIC interrupt mask */
#define MAX8997_IRQ_ADC_MASK		(1 << 0)
#define MAX8997_IRQ_ADCLOW_MASK		(1 << 1)
#define MAX8997_IRQ_ADCERR_MASK		(1 << 2)

#define MAX8997_IRQ_CHGTYP_MASK		(1 << 0)
#define MAX8997_IRQ_CHGDETRUN_MASK	(1 << 1)
#define MAX8997_IRQ_DCDTMR_MASK		(1 << 2)
#define MAX8997_IRQ_DBCHG_MASK		(1 << 3)
#define MAX8997_IRQ_VBVOLT_MASK		(1 << 4)

#define MAX8997_IRQ_OVP_MASK		(1 << 2)

/* RAMP BUCKs register mask */
#define MAX8997_ENRAMPBUCK1		(1 << 4)
#define MAX8997_ENRAMPBUCK2		(1 << 5)
#define MAX8997_ENRAMPBUCK4		(1 << 6)
#define MAX8997_ENRAMPBUCK5		(1 << 7)

/* Flash LED register mask */
#define MAX8997_BOOST_EN_MASK		(1 << 6)
#define MAX8997_BOOST_EN_SHIFT		6
#define MAX8997_FLASH_EN_MASK		(7 << 0)
#define MAX8997_FLASH_EN_SHIFT		0
#define MAX8997_MOVIE_EN_MASK		(7 << 3)
#define MAX8997_MOVIE_EN_SHIFT		3

/**
 * struct max8997_dev - max8997 master device for sub-drivers
 * @dev: master device of the chip (can be used to access platform data)
 * @i2c: i2c client private data for regulator
 * @rtc: i2c client private data for rtc
 * @muic: i2c client private data for muic
 * @hmotor: i2c client private data for haptic motor
 * @iolock: mutex for serializing io access
 * @irqlock: mutex for buslock
 * @irq_base: base IRQ number for max8997, required for IRQs
 * @irq: generic IRQ number for max8997
 * @ono: power onoff IRQ number for max8997
 * @irq_masks_cur: currently active value
 * @irq_masks_cache: cached hardware value
 * @type: indicate which max8997 "variant" is used
 */
struct max8997_dev {
	struct device *dev;
	struct i2c_client *i2c;
	struct i2c_client *rtc;
	struct i2c_client *muic;
	struct i2c_client *hmotor;
	struct mutex iolock;
	struct mutex irqlock;

	int irq_base;
	int irq;
	int ono;
	u8 irq_masks_cur[MAX8997_NUM_IRQ_REGS];
	u8 irq_masks_cache[MAX8997_NUM_IRQ_REGS];
	int type;
	int wakeup;

	/* For hiberantion */
	u8 reg_dump[MAX8997_REG_PMIC_END + MAX8997_MUIC_REG_END +
		MAX8997_HAPTIC_REG_END];
};

int max8997_irq_init(struct max8997_dev *max8997);
void max8997_irq_exit(struct max8997_dev *max8997);

extern int max8997_read_reg(struct i2c_client *i2c, u8 reg, u8 *dest);
extern int max8997_bulk_read(struct i2c_client *i2c, u8 reg, int count,
		u8 *buf);
extern int max8997_write_reg(struct i2c_client *i2c, u8 reg, u8 value);
extern int max8997_bulk_write(struct i2c_client *i2c, u8 reg, int count,
		u8 *buf);
extern int max8997_update_reg(struct i2c_client *i2c, u8 reg, u8 val, u8 mask);

#endif /*  __LINUX_MFD_MAX8997_PRIV_H */

