#ifndef __REF_VOLT_TABLE_H__
#define __REF_VOLT_TABLE_H__

u32 volt_table_vt_ub[16] = {
	425984000,	420020224,	414121984,	408158208,
	402194432,	396296192,	390332416,	384368640,
	378404864,	372506624,	357629952,	352649216,
	347734016,	342753280,	337838080,	333840384,

};

u32 volt_table_v255_ub[505] = {
	390320223	,	389824893	,	389329563	,	388834233	,	388338902	,	387843572	,	387348242	,	386852912	,
	386357581	,	385862251	,	385366921	,	384871591	,	384376260	,	383880930	,	383385600	,	382890270	,
	382394940	,	381899609	,	381404279	,	380908949	,	380413619	,	379918288	,	379422958	,	378927628	,
	378432298	,	377936967	,	377441637	,	376946307	,	376450977	,	375955647	,	375460316	,	374964986	,
	374469656	,	373974326	,	373478995	,	372983665	,	372488335	,	371993005	,	371497674	,	371002344	,
	370507014	,	370011684	,	369516353	,	369021023	,	368525693	,	368030363	,	367535033	,	367039702	,
	366544372	,	366049042	,	365553712	,	365058381	,	364563051	,	364067721	,	363572391	,	363077060	,
	362581730	,	362086400	,	361591070	,	361095740	,	360600409	,	360105079	,	359609749	,	359114419	,
	358619088	,	358123758	,	357628428	,	357133098	,	356637767	,	356142437	,	355647107	,	355151777	,
	354656447	,	354161116	,	353665786	,	353170456	,	352675126	,	352179795	,	351684465	,	351189135	,
	350693805	,	350198474	,	349703144	,	349207814	,	348712484	,	348217153	,	347721823	,	347226493	,
	346731163	,	346235833	,	345740502	,	345245172	,	344749842	,	344254512	,	343759181	,	343263851	,
	342768521	,	342273191	,	341777860	,	341282530	,	340787200	,	340291870	,	339796540	,	339301209	,
	338805879	,	338310549	,	337815219	,	337319888	,	336824558	,	336329228	,	335833898	,	335338567	,
	334843237	,	334347907	,	333852577	,	333357247	,	332861916	,	332366586	,	331871256	,	331375926	,
	330880595	,	330385265	,	329889935	,	329394605	,	328899274	,	328403944	,	327908614	,	327413284	,
	326917953	,	326422623	,	325927293	,	325431963	,	324936633	,	324441302	,	323945972	,	323450642	,
	322955312	,	322459981	,	321964651	,	321469321	,	320973991	,	320478660	,	319983330	,	319488000	,
	318992670	,	318497340	,	318002009	,	317506679	,	317011349	,	316516019	,	316020688	,	315525358	,
	315030028	,	314534698	,	314039367	,	313544037	,	313048707	,	312553377	,	312058047	,	311562716	,
	311067386	,	310572056	,	310076726	,	309581395	,	309086065	,	308590735	,	308095405	,	307600074	,
	307104744	,	306609414	,	306114084	,	305618753	,	305123423	,	304628093	,	304132763	,	303637433	,
	303142102	,	302646772	,	302151442	,	301656112	,	301160781	,	300665451	,	300170121	,	299674791	,
	299179460	,	298684130	,	298188800	,	297693470	,	297198140	,	296702809	,	296207479	,	295712149	,
	295216819	,	294721488	,	294226158	,	293730828	,	293235498	,	292740167	,	292244837	,	291749507	,
	291254177	,	290758847	,	290263516	,	289768186	,	289272856	,	288777526	,	288282195	,	287786865	,
	287291535	,	286796205	,	286300874	,	285805544	,	285310214	,	284814884	,	284319553	,	283824223	,
	283328893	,	282833563	,	282338233	,	281842902	,	281347572	,	280852242	,	280356912	,	279861581	,
	279366251	,	278870921	,	278375591	,	277880260	,	277384930	,	276889600	,	276394270	,	275898940	,
	275403609	,	274908279	,	274412949	,	273917619	,	273422288	,	272926958	,	272431628	,	271936298	,
	271440967	,	270945637	,	270450307	,	269954977	,	269459647	,	268964316	,	268468986	,	267973656	,
	267478326	,	266982995	,	266487665	,	265992335	,	265497005	,	265001674	,	264506344	,	264011014	,
	263515684	,	263020353	,	262525023	,	262029693	,	261534363	,	261039033	,	260543702	,	260048372	,
	259553042	,	259057712	,	258562381	,	258067051	,	257571721	,	257076391	,	256581060	,	256085730	,
	255590400	,	255095070	,	254599740	,	254104409	,	253609079	,	253113749	,	252618419	,	252123088	,
	251627758	,	251132428	,	250637098	,	250141767	,	249646437	,	249151107	,	248655777	,	248160447	,
	247665116	,	247169786	,	246674456	,	246179126	,	245683795	,	245188465	,	244693135	,	244197805	,
	243702474	,	243207144	,	242711814	,	242216484	,	241721153	,	241225823	,	240730493	,	240235163	,
	239739833	,	239244502	,	238749172	,	238253842	,	237758512	,	237263181	,	236767851	,	236272521	,
	235777191	,	235281860	,	234786530	,	234291200	,	233795870	,	233300540	,	232805209	,	232309879	,
	231814549	,	231319219	,	230823888	,	230328558	,	229833228	,	229337898	,	228842567	,	228347237	,
	227851907	,	227356577	,	226861247	,	226365916	,	225870586	,	225375256	,	224879926	,	224384595	,
	223889265	,	223393935	,	222898605	,	222403274	,	221907944	,	221412614	,	220917284	,	220421953	,
	219926623	,	219431293	,	218935963	,	218440633	,	217945302	,	217449972	,	216954642	,	216459312	,
	215963981	,	215468651	,	214973321	,	214477991	,	213982660	,	213487330	,	212992000	,	212496670	,
	212001340	,	211506009	,	211010679	,	210515349	,	210020019	,	209524688	,	209029358	,	208534028	,
	208038698	,	207543367	,	207048037	,	206552707	,	206057377	,	205562047	,	205066716	,	204571386	,
	204076056	,	203580726	,	203085395	,	202590065	,	202094735	,	201599405	,	201104074	,	200608744	,
	200113414	,	199618084	,	199122753	,	198627423	,	198132093	,	197636763	,	197141433	,	196646102	,
	196150772	,	195655442	,	195160112	,	194664781	,	194169451	,	193674121	,	193178791	,	192683460	,
	192188130	,	191692800	,	191197470	,	190702140	,	190206809	,	189711479	,	189216149	,	188720819	,
	188225488	,	187730158	,	187234828	,	186739498	,	186244167	,	185748837	,	185253507	,	184758177	,
	184262847	,	183767516	,	183272186	,	182776856	,	182281526	,	181786195	,	181290865	,	180795535	,
	180300205	,	179804874	,	179309544	,	178814214	,	178318884	,	177823553	,	177328223	,	176832893	,
	176337563	,	175842233	,	175346902	,	174851572	,	174356242	,	173860912	,	173365581	,	172870251	,
	172374921	,	171879591	,	171384260	,	170888930	,	170393600	,	169898270	,	169402940	,	168907609	,
	168412279	,	167916949	,	167421619	,	166926288	,	166430958	,	165935628	,	165440298	,	164944967	,
	164449637	,	163954307	,	163458977	,	162963647	,	162468316	,	161972986	,	161477656	,	160982326	,
	160486995	,	159991665	,	159496335	,	159001005	,	158505674	,	158010344	,	157515014	,	157019684	,
	156524353	,	156029023	,	155533693	,	155038363	,	154543033	,	154047702	,	153552372	,	153057042	,
	152561712	,	152066381	,	151571051	,	151075721	,	150580391	,	150085060	,	149589730	,	149094400	,
	148599070	,	148103740	,	147608409	,	147113079	,	146617749	,	146122419	,	145627088	,	145131758	,
	144636428	,	144141098	,	143645767	,	143150437	,	142655107	,	142159777	,	141664447	,	141169116	,
	140673786	,
};

u32 volt_table_cv_64_dv_320[256] = {
	13104,	13308,	13513,	13718,	13923,	14127,	14332,	14537,
	14742,	14946,	15151,	15356,	15561,	15765,	15970,	16175,
	16380,	16585,	16789,	16994,	17199,	17404,	17608,	17813,
	18018,	18223,	18427,	18632,	18837,	19042,	19246,	19451,
	19656,	19861,	20065,	20270,	20475,	20680,	20884,	21089,
	21294,	21499,	21703,	21908,	22113,	22318,	22522,	22727,
	22932,	23137,	23341,	23546,	23751,	23956,	24160,	24365,
	24570,	24775,	24979,	25184,	25389,	25594,	25798,	26003,
	26208,	26413,	26617,	26822,	27027,	27232,	27436,	27641,
	27846,	28051,	28255,	28460,	28665,	28870,	29074,	29279,
	29484,	29689,	29893,	30098,	30303,	30508,	30712,	30917,
	31122,	31327,	31531,	31736,	31941,	32146,	32350,	32555,
	32760,	32965,	33170,	33374,	33579,	33784,	33989,	34193,
	34398,	34603,	34808,	35012,	35217,	35422,	35627,	35831,
	36036,	36241,	36446,	36650,	36855,	37060,	37265,	37469,
	37674,	37879,	38084,	38288,	38493,	38698,	38903,	39107,
	39312,	39517,	39722,	39926,	40131,	40336,	40541,	40745,
	40950,	41155,	41360,	41564,	41769,	41974,	42179,	42383,
	42588,	42793,	42998,	43202,	43407,	43612,	43817,	44021,
	44226,	44431,	44636,	44840,	45045,	45250,	45455,	45659,
	45864,	46069,	46274,	46478,	46683,	46888,	47093,	47297,
	47502,	47707,	47912,	48116,	48321,	48526,	48731,	48935,
	49140,	49345,	49550,	49755,	49959,	50164,	50369,	50574,
	50778,	50983,	51188,	51393,	51597,	51802,	52007,	52212,
	52416,	52621,	52826,	53031,	53235,	53440,	53645,	53850,
	54054,	54259,	54464,	54669,	54873,	55078,	55283,	55488,
	55692,	55897,	56102,	56307,	56511,	56716,	56921,	57126,
	57330,	57535,	57740,	57945,	58149,	58354,	58559,	58764,
	58968,	59173,	59378,	59583,	59787,	59992,	60197,	60402,
	60606,	60811,	61016,	61221,	61425,	61630,	61835,	62040,
	62244,	62449,	62654,	62859,	63063,	63268,	63473,	63678,
	63882,	64087,	64292,	64497,	64701,	64906,	65111,	65316
};

const u32 gamma_300_gra_table[256] = {
	0,	2,	7,	17,	32,	53,	78, 110,
	148,	191,	241,	298,	361,	430,	506,	589,
	679,	776,	880,	991,	1109,	1235,	1368,	1508,
	1657,	1812,	1975,	2147,	2325,	2512,	2706,	2909,
	3119,	3338,	3564,	3799,	4042,	4293,	4553,	4820,
	5096,	5381,	5674,	5975,	6285,	6604,	6931,	7267,
	7611,	7965,	8327,	8697,	9077,	9465,	9863,	10269,
	10684,	11109,	11542,	11984,	12436,	12896,	13366,	13845,
	14333,	14830,	15337,	15852,	16378,	16912,	17456,	18009,
	18572,	19144,	19726,	20317,	20918,	21528,	22148,	22778,
	23417,	24066,	24724,	25392,	26070,	26758,	27456,	28163,
	28880,	29607,	30344,	31090,	31847,	32613,	33390,	34176,
	34973,	35779,	36596,	37422,	38259,	39106,	39963,	40830,
	41707,	42594,	43492,	44399,	45317,	46246,	47184,	48133,
	49092,	50062,	51042,	52032,	53032,	54043,	55065,	56097,
	57139,	58192,	59255,	60329,	61413,	62508,	63613,	64729,
	65856,	66993,	68141,	69299,	70469,	71648,	72839,	74040,
	75252,	76475,	77708,	78952,	80207,	81473,	82750,	84037,
	85336,	86645,	87965,	89296,	90638,	91990,	93354,	94729,
	96114,	97511,	98919,	100337,	101767,	103208,	104659,	106122,
	107596,	109081,	110577,	112085,	113603,	115132,	116673,	118225,
	119788,	121362,	122948,	124544,	126152,	127772,	129402,	131044,
	132697,	134361,	136037,	137724,	139422,	141132,	142853,	144586,
	146330,	148085,	149852,	151630,	153419,	155220,	157033,	158857,
	160692,	162540,	164398,	166268,	168150,	170043,	171948,	173864,
	175792,	177731,	179683,	181645,	183620,	185606,	187603,	189613,
	191634,	193667,	195711,	197767,	199835,	201915,	204006,	206109,
	208224,	210351,	212489,	214640,	216802,	218976,	221161,	223359,
	225569,	227790,	230023,	232268,	234525,	236794,	239075,	241368,
	243672,	245989,	248318,	250658,	253011,	255375,	257752,	260141,
	262541,	264954,	267379,	269815,	272264,	274725,	277198,	279683,
	282180,	284689,	287211,	289744,	292290,	294848,	297418,	300000
};

const u32 gamma_control_set_207[] = {
0	,	10	,	43	,	101	,	183	,	291	,	425	,	585	,
772	,	985	,	1225	,	1493	,	1787	,	2110	,	2460	,	2837	,
3243	,	3676	,	4138	,	4628	,	5147	,	5694	,	6270	,	6874	,
7507	,	8169	,	8860	,	9580	,	10329	,	11107	,	11915	,	12752	,
13618	,	14513	,	15439	,	16393	,	17378	,	18392	,	19436	,	20509	,
21613	,	22747	,	23910	,	25103	,	26327	,	27581	,	28864	,	30178	,
31523	,	32897	,	34302	,	35738	,	37203	,	38700	,	40226	,	41784	,
43372	,	44990	,	46639	,	48319	,	50030	,	51771	,	53544	,	55347	,
57181	,	59046	,	60942	,	62869	,	64826	,	66815	,	68835	,	70887	,
72969	,	75082	,	77227	,	79403	,	81610	,	83848	,	86118	,	88419	,
90752	,	93116	,	95511	,	97938	,	100396	,	102886	,	105408	,	107960	,
110545	,	113161	,	115809	,	118488	,	121200	,	123942	,	126717	,	129523	,
132361	,	135231	,	138133	,	141067	,	144032	,	147030	,	150059	,	153121	,
156214	,	159339	,	162496	,	165686	,	168907	,	172160	,	175446	,	178764	,
182113	,	185495	,	188909	,	192356	,	195834	,	199345	,	202888	,	206463	,
210071	,	213711	,	217383	,	221088	,	224825	,	228594	,	232396	,	236230	,
240096	,	243995	,	247927	,	251891	,	255887	,	259917	,	263978	,	268072	,
272199	,	276358	,	280550	,	284775	,	289032	,	293322	,	297645	,	302000	,
306388	,	310809	,	315262	,	319748	,	324267	,	328819	,	333403	,	338021	,
342671	,	347354	,	352070	,	356819	,	361601	,	366415	,	371263	,	376143	,
381057	,	386003	,	390983	,	395995	,	401040	,	406119	,	411230	,	416375	,
421552	,	426763	,	432007	,	437284	,	442594	,	447937	,	453313	,	458723	,
464165	,	469641	,	475150	,	480692	,	486268	,	491876	,	497518	,	503194	,
508902	,	514644	,	520419	,	526227	,	532069	,	537944	,	543853	,	549795	,
555770	,	561778	,	567820	,	573896	,	580005	,	586147	,	592323	,	598532	,
604775	,	611051	,	617360	,	623704	,	630080	,	636491	,	642934	,	649412	,
655923	,	662467	,	669045	,	675657	,	682302	,	688981	,	695694	,	702440	,
709220	,	716033	,	722880	,	729761	,	736676	,	743624	,	750606	,	757622	,
764672	,	771755	,	778872	,	786023	,	793207	,	800426	,	807678	,	814964	,
822284	,	829637	,	837025	,	844446	,	851902	,	859391	,	866914	,	874471	,
882061	,	889686	,	897345	,	905037	,	912764	,	920525	,	928319	,	936148	,
944010	,	951906	,	959837	,	967801	,	975800	,	983832	,	991899	,	1000000
};

const u32 gamma_control_set_208[] = {
0	,	9	,	41	,	97	,	176	,	280	,	410	,	565	,
746	,	953	,	1186	,	1447	,	1734	,	2048	,	2389	,	2758	,
3154	,	3578	,	4030	,	4510	,	5018	,	5554	,	6118	,	6711	,
7332	,	7981	,	8660	,	9367	,	10103	,	10868	,	11662	,	12486	,
13338	,	14220	,	15131	,	16071	,	17041	,	18040	,	19069	,	20128	,
21216	,	22335	,	23483	,	24661	,	25868	,	27106	,	28374	,	29672	,
31001	,	32359	,	33748	,	35167	,	36617	,	38096	,	39607	,	41148	,
42719	,	44321	,	45954	,	47617	,	49311	,	51036	,	52792	,	54578	,
56396	,	58244	,	60123	,	62034	,	63975	,	65948	,	67951	,	69986	,
72052	,	74149	,	76277	,	78437	,	80628	,	82850	,	85104	,	87389	,
89706	,	92054	,	94434	,	96845	,	99288	,	101762	,	104268	,	106806	,
109375	,	111976	,	114609	,	117274	,	119970	,	122698	,	125459	,	128251	,
131075	,	133931	,	136819	,	139738	,	142690	,	145674	,	148691	,	151739	,
154819	,	157932	,	161076	,	164253	,	167462	,	170703	,	173977	,	177283	,
180621	,	183992	,	187395	,	190830	,	194298	,	197798	,	201331	,	204896	,
208493	,	212124	,	215786	,	219482	,	223209	,	226970	,	230763	,	234589	,
238447	,	242338	,	246262	,	250219	,	254208	,	258230	,	262285	,	266373	,
270493	,	274647	,	278833	,	283052	,	287304	,	291589	,	295907	,	300258	,
304642	,	309059	,	313509	,	317992	,	322508	,	327057	,	331639	,	336254	,
340903	,	345584	,	350299	,	355047	,	359828	,	364642	,	369490	,	374371	,
379285	,	384232	,	389213	,	394227	,	399274	,	404355	,	409469	,	414616	,
419797	,	425011	,	430259	,	435540	,	440854	,	446202	,	451584	,	456999	,
462447	,	467929	,	473445	,	478994	,	484577	,	490193	,	495843	,	501527	,
507244	,	512995	,	518780	,	524598	,	530450	,	536336	,	542255	,	548208	,
554195	,	560216	,	566270	,	572358	,	578480	,	584636	,	590826	,	597050	,
603307	,	609598	,	615924	,	622283	,	628676	,	635103	,	641564	,	648059	,
654588	,	661151	,	667747	,	674378	,	681043	,	687742	,	694475	,	701242	,
708043	,	714879	,	721748	,	728652	,	735589	,	742561	,	749567	,	756607	,
763681	,	770789	,	777932	,	785109	,	792320	,	799565	,	806845	,	814159	,
821507	,	828889	,	836306	,	843757	,	851242	,	858762	,	866316	,	873904	,
881527	,	889184	,	896875	,	904601	,	912362	,	920156	,	927986	,	935849	,
943747	,	951680	,	959647	,	967648	,	975684	,	983755	,	991860	,	1000000
};

const u32 gamma_control_set_21[] = {
	0,	9,	38,	89,	163,	260,	381,	526,
	697,	892,	1113,	1359,	1632,	1930,	2255,	2607,
	2985,	3391,	3823,	4283,	4770,	5284,	5826,	6396,
	6994,	7620,	8274,	8957,	9668,	10407,	11175,	11971,
	12797,	13651,	14534,	15446,	16388,	17358,	18358,	19387,
	20446,	21534,	22652,	23799,	24976,	26183,	27420,	28687,
	29983,	31310,	32667,	34054,	35471,	36919,	38397,	39905,
	41444,	43014,	44614,	46244,	47906,	49598,	51321,	53074,
	54859,	56674,	58521,	60399,	62307,	64247,	66218,	68220,
	70253,	72318,	74414,	76542,	78700,	80891,	83113,	85366,
	87651,	89968,	92316,	94696,	97108,	99551,	102027,	104534,
	107073,	109644,	112248,	114883,	117550,	120249,	122980,	125744,
	128540,	131367,	134228,	137120,	140045,	143002,	145991,	149013,
	152068,	155155,	158274,	161426,	164610,	167827,	171077,	174359,
	177674,	181022,	184403,	187816,	191262,	194741,	198253,	201797,
	205375,	208985,	212629,	216305,	220015,	223758,	227533,	231342,
	235184,	239059,	242967,	246909,	250883,	254891,	258932,	263007,
	267115,	271256,	275431,	279639,	283880,	288155,	292464,	296806,
	301181,	305590,	310033,	314509,	319019,	323562,	328139,	332750,
	337394,	342073,	346785,	351530,	356310,	361123,	365971,	370852,
	375767,	380715,	385698,	390715,	395766,	400851,	405969,	411122,
	416309,	421530,	426785,	432074,	437397,	442754,	448146,	453572,
	459032,	464526,	470054,	475617,	481214,	486845,	492511,	498211,
	503945,	509714,	515517,	521355,	527227,	533133,	539074,	545050,
	551060,	557104,	563183,	569297,	575445,	581628,	587845,	594097,
	600384,	606705,	613061,	619452,	625877,	632338,	638833,	645362,
	651927,	658526,	665161,	671830,	678533,	685272,	692046,	698854,
	705698,	712576,	719490,	726438,	733421,	740440,	747493,	754581,
	761705,	768863,	776057,	783286,	790550,	797848,	805183,	812552,
	819956,	827396,	834871,	842381,	849926,	857506,	865122,	872773,
	880460,	888181,	895938,	903731,	911558,	919421,	927320,	935254,
	943223,	951228,	959268,	967343,	975454,	983601,	991783,	1000000
};

const u32 gamma_control_set_212[] = {
0	,	7	,	34	,	81	,	149	,	239	,	353	,	489	,
649	,	833	,	1042	,	1276	,	1534	,	1818	,	2127	,	2462	,
2824	,	3211	,	3625	,	4065	,	4532	,	5026	,	5547	,	6095	,
6670	,	7273	,	7904	,	8563	,	9249	,	9963	,	10706	,	11476	,
12275	,	13103	,	13959	,	14844	,	15757	,	16700	,	17671	,	18672	,
19701	,	20760	,	21848	,	22966	,	24113	,	25289	,	26496	,	27732	,
28997	,	30293	,	31619	,	32974	,	34360	,	35776	,	37222	,	38699	,
40206	,	41743	,	43311	,	44909	,	46538	,	48198	,	49889	,	51610	,
53362	,	55145	,	56959	,	58804	,	60681	,	62588	,	64527	,	66497	,
68498	,	70530	,	72594	,	74690	,	76817	,	78976	,	81166	,	83388	,
85641	,	87927	,	90244	,	92593	,	94974	,	97387	,	99832	,	102309	,
104818	,	107359	,	109933	,	112538	,	115176	,	117847	,	120549	,	123284	,
126052	,	128851	,	131684	,	134549	,	137446	,	140377	,	143339	,	146335	,
149363	,	152424	,	155518	,	158645	,	161805	,	164998	,	168223	,	171482	,
174774	,	178098	,	181456	,	184847	,	188272	,	191729	,	195220	,	198744	,
202301	,	205892	,	209516	,	213173	,	216864	,	220589	,	224347	,	228138	,
231963	,	235822	,	239714	,	243640	,	247600	,	251594	,	255621	,	259682	,
263777	,	267905	,	272068	,	276265	,	280495	,	284760	,	289058	,	293391	,
297757	,	302158	,	306593	,	311062	,	315565	,	320102	,	324674	,	329280	,
333920	,	338595	,	343303	,	348047	,	352824	,	357636	,	362483	,	367364	,
372279	,	377229	,	382214	,	387233	,	392286	,	397375	,	402498	,	407655	,
412848	,	418075	,	423337	,	428633	,	433965	,	439331	,	444732	,	450168	,
455639	,	461145	,	466686	,	472262	,	477873	,	483518	,	489199	,	494915	,
500666	,	506452	,	512273	,	518130	,	524021	,	529948	,	535910	,	541907	,
547940	,	554008	,	560111	,	566249	,	572423	,	578633	,	584877	,	591157	,
597473	,	603824	,	610210	,	616632	,	623089	,	629583	,	636111	,	642675	,
649275	,	655911	,	662582	,	669288	,	676031	,	682809	,	689623	,	696473	,
703358	,	710279	,	717236	,	724229	,	731258	,	738323	,	745423	,	752559	,
759732	,	766940	,	774184	,	781465	,	788781	,	796133	,	803522	,	810946	,
818407	,	825903	,	833436	,	841005	,	848610	,	856251	,	863928	,	871642	,
879392	,	887178	,	895000	,	902859	,	910754	,	918685	,	926653	,	934657	,
942697	,	950774	,	958887	,	967037	,	975223	,	983445	,	991704	,	1000000
};

const u32 gamma_control_set_214[] = {
0	,	7	,	31	,	74	,	137	,	221	,	327	,	455	,
606	,	779	,	977	,	1198	,	1443	,	1713	,	2007	,	2327	,
2671	,	3042	,	3437	,	3859	,	4307	,	4781	,	5281	,	5809	,
6362	,	6943	,	7551	,	8186	,	8849	,	9539	,	10257	,	11003	,
11776	,	12578	,	13408	,	14266	,	15152	,	16067	,	17011	,	17983	,
18985	,	20015	,	21074	,	22162	,	23280	,	24427	,	25603	,	26809	,
28045	,	29310	,	30605	,	31930	,	33285	,	34670	,	36084	,	37530	,
39005	,	40511	,	42047	,	43614	,	45211	,	46839	,	48497	,	50187	,
51907	,	53658	,	55440	,	57253	,	59098	,	60973	,	62880	,	64818	,
66787	,	68788	,	70820	,	72884	,	74979	,	77107	,	79265	,	81456	,
83679	,	85933	,	88219	,	90538	,	92888	,	95270	,	97685	,	100132	,
102611	,	105123	,	107667	,	110243	,	112852	,	115493	,	118167	,	120873	,
123613	,	126384	,	129189	,	132027	,	134897	,	137800	,	140737	,	143706	,
146708	,	149743	,	152812	,	155914	,	159048	,	162217	,	165418	,	168653	,
171921	,	175223	,	178558	,	181927	,	185329	,	188765	,	192234	,	195737	,
199274	,	202845	,	206449	,	210087	,	213759	,	217466	,	221206	,	224980	,
228788	,	232630	,	236506	,	240416	,	244361	,	248339	,	252352	,	256400	,
260481	,	264597	,	268748	,	272932	,	277151	,	281405	,	285693	,	290016	,
294374	,	298766	,	303192	,	307654	,	312150	,	316681	,	321247	,	325847	,
330483	,	335153	,	339858	,	344598	,	349374	,	354184	,	359029	,	363909	,
368825	,	373775	,	378761	,	383782	,	388839	,	393930	,	399057	,	404219	,
409417	,	414649	,	419918	,	425221	,	430561	,	435935	,	441346	,	446792	,
452273	,	457790	,	463343	,	468931	,	474555	,	480215	,	485911	,	491642	,
497409	,	503212	,	509051	,	514926	,	520836	,	526783	,	532766	,	538784	,
544839	,	550930	,	557057	,	563220	,	569419	,	575654	,	581925	,	588233	,
594577	,	600957	,	607373	,	613826	,	620315	,	626840	,	633402	,	640000	,
646635	,	653306	,	660014	,	666758	,	673539	,	680356	,	687210	,	694100	,
701027	,	707991	,	714991	,	722028	,	729102	,	736212	,	743360	,	750544	,
757765	,	765023	,	772317	,	779649	,	787017	,	794423	,	801865	,	809344	,
816861	,	824414	,	832005	,	839632	,	847297	,	854998	,	862737	,	870513	,
878326	,	886177	,	894064	,	901989	,	909951	,	917950	,	925987	,	934061	,
942172	,	950321	,	958507	,	966731	,	974992	,	983290	,	991626	,	1000000
};

const u32 gamma_control_set_215[] = {
	0,	7,	30,	72, 132,	214,	316,	440,
	586,	755,	947,	1162,	1401,	1664,	1951,	2263,
	2599,	2961,	3348,	3761,	4200,	4664,	5155,	5671,
	6215,	6785,	7382,	8006,	8657,	9335,	10041,	10774,
	11535,	12324,	13141,	13986,	14859,	15761,	16691,	17650,
	18637,	19653,	20698,	21772,	22876,	24008,	25170,	26361,
	27581,	28832,	30111,	31421,	32761,	34130,	35530,	36959,
	38419,	39909,	41430,	42981,	44562,	46175,	47817,	49491,
	51195,	52931,	54697,	56494,	58323,	60182,	62073,	63995,
	65949,	67934,	69950,	71998,	74078,	76190,	78333,	80508,
	82715,	84954,	87225,	89528,	91863,	94231,	96630,	99062,
	101526,	104023,	106552,	109114,	111708,	114335,	116994,	119687,
	122412,	125170,	127961,	130784,	133641,	136531,	139454,	142410,
	145399,	148422,	151477,	154566,	157689,	160845,	164034,	167257,
	170513,	173803,	177127,	180485,	183876,	187301,	190759,	194252,
	197779,	201339,	204934,	208562,	212225,	215922,	219653,	223418,
	227217,	231051,	234919,	238821,	242758,	246729,	250735,	254775,
	258850,	262959,	267103,	271282,	275496,	279744,	284027,	288345,
	292697,	297085,	301507,	305965,	310457,	314985,	319548,	324145,
	328778,	333446,	338150,	342888,	347662,	352471,	357316,	362195,
	367111,	372062,	377048,	382070,	387127,	392220,	397348,	402513,
	407713,	412948,	418220,	423527,	428870,	434248,	439663,	445114,
	450600,	456123,	461681,	467276,	472906,	478573,	484276,	490014,
	495790,	501601,	507448,	513332,	519252,	525209,	531201,	537231,
	543296,	549398,	555537,	561712,	567923,	574171,	580456,	586777,
	593135,	599529,	605961,	612429,	618933,	625475,	632053,	638668,
	645320,	652009,	658735,	665497,	672297,	679133,	686007,	692918,
	699865,	706850,	713872,	720931,	728027,	735161,	742331,	749539,
	756784,	764067,	771387,	778744,	786138,	793570,	801039,	808546,
	816090,	823672,	831291,	838947,	846642,	854374,	862143,	869950,
	877795,	885677,	893597,	901555,	909551,	917584,	925655,	933764,
	941911,	950096,	958318,	966579,	974877,	983214,	991588,	1000000
};


const u32 *GAMMA_CONTROL_TABLE[G_MAX] = {
	gamma_control_set_207,
	gamma_control_set_208,
	gamma_control_set_21,
	gamma_control_set_212,
	gamma_control_set_214,
	gamma_control_set_215,
};

const struct str_flookup_table flookup_table[302] = {
	{  0,   0},  {  1,  20},
	{ 20,   7},  { 27,   5},
	{ 32,   4},  { 36,   4},
	{ 40,   4},  { 44,   3},
	{ 47,   3},  { 50,   2},
	{ 52,   3},  { 55,   2},
	{ 57,   3},  { 60,   2},
	{ 62,   2},  { 64,   2},
	{ 66,   2},  { 68,   2},
	{ 70,   1},  { 71,   2},
	{ 73,   2},  { 75,   2},
	{ 77,   1},  { 78,   2},
	{ 80,   1},  { 81,   2},
	{ 83,   1},  { 84,   2},
	{ 86,   1},  { 87,   2},
	{ 89,   1},  { 90,   1},
	{ 91,   2},  { 93,   1},
	{ 94,   1},  { 95,   2},
	{ 97,   1},  { 98,   1},
	{ 99,   1},  {100,   1},
	{101,   2},  {103,   1},
	{104,   1},  {105,   1},
	{106,   1},  {107,   1},
	{108,   1},  {109,   1},
	{110,   1},  {111,   1},
	{112,   1},  {113,   1},
	{114,   1},  {115,   1},
	{116,   1},  {117,   1},
	{118,   1},  {119,   1},
	{120,   1},  {121,   1},
	{122,   1},  {123,   1},
	{124,   1},  {125,   1},
	{126,   1},  {127,   1},
	{128,   1},  {129,   1},
	{  0,   0},  {130,   1},
	{131,   1},  {132,   1},
	{133,   1},  {134,   1},
	{  0,   0},  {135,   1},
	{136,   1},  {137,   1},
	{138,   1},  {139,   1},
	{  0,   0},  {140,   1},
	{141,   1},  {142,   1},
	{  0,   0},  {143,   1},
	{144,   1},  {145,   1},
	{146,   1},  {  0,   0},
	{147,   1},  {148,   1},
	{149,   1},  {  0,   0},
	{150,   1},  {151,   1},
	{  0,   0},  {152,   1},
	{153,   1},  {154,   1},
	{  0,   0},  {155,   1},
	{156,   1},  {  0,   0},
	{157,   1},  {158,   1},
	{  0,   0},  {159,   1},
	{160,   1},  {  0,   0},
	{161,   1},  {162,   1},
	{  0,   0},  {163,   1},
	{164,   1},  {  0,   0},
	{165,   1},  {166,   1},
	{  0,   0},  {167,   1},
	{168,   1},  {  0,   0},
	{169,   1},  {170,   1},
	{  0,   0},  {171,   1},
	{  0,   0},  {172,   1},
	{173,   1},  {  0,   0},
	{174,   1},  {  0,   0},
	{175,   1},  {176,   1},
	{  0,   0},  {177,   1},
	{  0,   0},  {178,   1},
	{179,   1},  {  0,   0},
	{180,   1},  {  0,   0},
	{181,   1},  {182,   1},
	{  0,   0},  {183,   1},
	{  0,   0},  {184,   1},
	{  0,   0},  {185,   1},
	{186,   1},  {  0,   0},
	{187,   1},  {  0,   0},
	{188,   1},  {  0,   0},
	{189,   1},  {  0,   0},
	{190,   1},  {191,   1},
	{  0,   0},  {192,   1},
	{  0,   0},  {193,   1},
	{  0,   0},  {194,   1},
	{  0,   0},  {195,   1},
	{  0,   0},  {196,   1},
	{  0,   0},  {197,   1},
	{198,   1},  {  0,   0},
	{199,   1},  {  0,   0},
	{200,   1},  {  0,   0},
	{201,   1},  {  0,   0},
	{202,   1},  {  0,   0},
	{203,   1},  {  0,   0},
	{204,   1},  {  0,   0},
	{205,   1},  {  0,   0},
	{206,   1},  {  0,   0},
	{207,   1},  {  0,   0},
	{208,   1},  {  0,   0},
	{209,   1},  {  0,   0},
	{210,   1},  {  0,   0},
	{211,   1},  {  0,   0},
	{212,   1},  {  0,   0},
	{213,   1},  {  0,   0},
	{  0,   0},  {214,   1},
	{  0,   0},  {215,   1},
	{  0,   0},  {216,   1},
	{  0,   0},  {217,   1},
	{  0,   0},  {218,   1},
	{  0,   0},  {219,   1},
	{  0,   0},  {220,   1},
	{  0,   0},  {221,   1},
	{  0,   0},  {  0,   0},
	{222,   1},  {  0,   0},
	{223,   1},  {  0,   0},
	{224,   1},  {  0,   0},
	{225,   1},  {  0,   0},
	{  0,   0},  {226,   1},
	{  0,   0},  {227,   1},
	{  0,   0},  {228,   1},
	{  0,   0},  {229,   1},
	{  0,   0},  {  0,   0},
	{230,   1},  {  0,   0},
	{231,   1},  {  0,   0},
	{232,   1},  {  0,   0},
	{233,   1},  {  0,   0},
	{  0,   0},  {234,   1},
	{  0,   0},  {235,   1},
	{  0,   0},  {  0,   0},
	{236,   1},  {  0,   0},
	{237,   1},  {  0,   0},
	{238,   1},  {  0,   0},
	{  0,   0},  {239,   1},
	{  0,   0},  {240,   1},
	{  0,   0},  {241,   1},
	{  0,   0},  {  0,   0},
	{242,   1},  {  0,   0},
	{243,   1},  {  0,   0},
	{  0,   0},  {244,   1},
	{  0,   0},  {245,   1},
	{  0,   0},  {  0,   0},
	{246,   1},  {  0,   0},
	{247,   1},  {  0,   0},
	{  0,   0},  {248,   1},
	{  0,   0},  {249,   1},
	{  0,   0},  {  0,   0},
	{250,   1},  {  0,   0},
	{251,   1},  {  0,   0},
	{  0,   0},  {252,   1},
	{  0,   0},  {253,   1},
	{  0,   0},  {  0,   0},
	{254,   1},  {  0,   0},
	{  0,   0},  {255,   1},
};

#endif
