/* drivers/video/samsung/s6e8aa0a_volt_tbl.h
 *
 * Copyright (C) 2012 Samsung Electronics Co, Ltd.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __REF_VOLT_TABLE_H__
#define __REF_VOLT_TABLE_H__

#ifdef CONFIG_AID_DIMMING
#include "s6e8aa0a_volt_tbl_aid.h"
#else
#include "s6e8aa0a_volt_tbl_def.h"
#endif /* COFNIG_AID_DIMMING */

static u32 volt_table_cv_20_dv_320[256] = {
	 64,  67,  70,  74,  77,  80,  83,  86,
	 90,  93,  96,  99, 102, 106, 109, 112,
	115, 118, 122, 125, 128, 131, 134, 138,
	141, 144, 147, 150, 154, 157, 160, 163,
	166, 170, 173, 176, 179, 182, 186, 189,
	192, 195, 198, 202, 205, 208, 211, 214,
	218, 221, 224, 227, 230, 234, 237, 240,
	243, 246, 250, 253, 256, 259, 262, 266,
	269, 272, 275, 278, 282, 285, 288, 291,
	294, 298, 301, 304, 307, 310, 314, 317,
	320, 323, 326, 330, 333, 336, 339, 342,
	346, 349, 352, 355, 358, 362, 365, 368,
	371, 374, 378, 381, 384, 387, 390, 394,
	397, 400, 403, 406, 410, 413, 416, 419,
	422, 426, 429, 432, 435, 438, 442, 445,
	448, 451, 454, 458, 461, 464, 467, 470,
	474, 477, 480, 483, 486, 490, 493, 496,
	499, 502, 506, 509, 512, 515, 518, 522,
	525, 528, 531, 534, 538, 541, 544, 547,
	550, 554, 557, 560, 563, 566, 570, 573,
	576, 579, 582, 586, 589, 592, 595, 598,
	602, 605, 608, 611, 614, 618, 621, 624,
	627, 630, 634, 637, 640, 643, 646, 650,
	653, 656, 659, 662, 666, 669, 672, 675,
	678, 682, 685, 688, 691, 694, 698, 701,
	704, 707, 710, 714, 717, 720, 723, 726,
	730, 733, 736, 739, 742, 746, 749, 752,
	755, 758, 762, 765, 768, 771, 774, 778,
	781, 784, 787, 790, 794, 797, 800, 803,
	806, 810, 813, 816, 819, 822, 826, 829,
	832, 835, 838, 842, 845, 848, 851, 854,
	858, 861, 864, 867, 870, 874, 877, 880,
};

static u32 volt_table_cv_65_dv_320[256] = {
	 208,  211,  214,  218,  221,  224,  227,  230,
	 234,  237,  240,  243,  246,  250,  253,  256,
	 259,  262,  266,  269,  272,  275,  278,  282,
	 285,  288,  291,  294,  298,  301,  304,  307,
	 310,  314,  317,  320,  323,  326,  330,  333,
	 336,  339,  342,  346,  349,  352,  355,  358,
	 362,  365,  368,  371,  374,  378,  381,  384,
	 387,  390,  394,  397,  400,  403,  406,  410,
	 413,  416,  419,  422,  426,  429,  432,  435,
	 438,  442,  445,  448,  451,  454,  458,  461,
	 464,  467,  470,  474,  477,  480,  483,  486,
	 490,  493,  496,  499,  502,  506,  509,  512,
	 515,  518,  522,  525,  528,  531,  534,  538,
	 541,  544,  547,  550,  554,  557,  560,  563,
	 566,  570,  573,  576,  579,  582,  586,  589,
	 592,  595,  598,  602,  605,  608,  611,  614,
	 618,  621,  624,  627,  630,  634,  637,  640,
	 643,  646,  650,  653,  656,  659,  662,  666,
	 669,  672,  675,  678,  682,  685,  688,  691,
	 694,  698,  701,  704,  707,  710,  714,  717,
	 720,  723,  726,  730,  733,  736,  739,  742,
	 746,  749,  752,  755,  758,  762,  765,  768,
	 771,  774,  778,  781,  784,  787,  790,  794,
	 797,  800,  803,  806,  810,  813,  816,  819,
	 822,  826,  829,  832,  835,  838,  842,  845,
	 848,  851,  854,  858,  861,  864,  867,  870,
	 874,  877,  880,  883,  886,  890,  893,  896,
	 899,  902,  906,  909,  912,  915,  918,  922,
	 925,  928,  931,  934,  938,  941,  944,  947,
	 950,  954,  957,  960,  963,  966,  970,  973,
	 976,  979,  982,  986,  989,  992,  995,  998,
	1002, 1005, 1008, 1011, 1014, 1018, 1021, 1024,
};

static const u32 gamma_300_gra_table[256] = {
	     0,      2,      7,     17,
	    32,     53,     78,    110,
	   148,    191,    241,    298,
	   361,    430,    506,    589,
	   679,    776,    880,    991,
	  1109,   1235,   1368,   1508,
	  1657,   1812,   1975,   2147,
	  2325,   2512,   2706,   2909,
	  3119,   3338,   3564,   3799,
	  4042,   4293,   4553,   4820,
	  5096,   5381,   5674,   5975,
	  6285,   6604,   6931,   7267,
	  7611,   7965,   8327,   8697,
	  9077,   9465,   9863,  10269,
	 10684,  11109,  11542,  11984,
	 12436,  12896,  13366,  13845,
	 14333,  14830,  15337,  15852,
	 16378,  16912,  17456,  18009,
	 18572,  19144,  19726,  20317,
	 20918,  21528,  22148,  22778,
	 23417,  24066,  24724,  25392,
	 26070,  26758,  27456,  28163,
	 28880,  29607,  30344,  31090,
	 31847,  32613,  33390,  34176,
	 34973,  35779,  36596,  37422,
	 38259,  39106,  39963,  40830,
	 41707,  42594,  43492,  44399,
	 45317,  46246,  47184,  48133,
	 49092,  50062,  51042,  52032,
	 53032,  54043,  55065,  56097,
	 57139,  58192,  59255,  60329,
	 61413,  62508,  63613,  64729,
	 65856,  66993,  68141,  69299,
	 70469,  71648,  72839,  74040,
	 75252,  76475,  77708,  78952,
	 80207,  81473,  82750,  84037,
	 85336,  86645,  87965,  89296,
	 90638,  91990,  93354,  94729,
	 96114,  97511,  98919, 100337,
	101767, 103208, 104659, 106122,
	107596, 109081, 110577, 112085,
	113603, 115132, 116673, 118225,
	119788, 121362, 122948, 124544,
	126152, 127772, 129402, 131044,
	132697, 134361, 136037, 137724,
	139422, 141132, 142853, 144586,
	146330, 148085, 149852, 151630,
	153419, 155220, 157033, 158857,
	160692, 162540, 164398, 166268,
	168150, 170043, 171948, 173864,
	175792, 177731, 179683, 181645,
	183620, 185606, 187603, 189613,
	191634, 193667, 195711, 197767,
	199835, 201915, 204006, 206109,
	208224, 210351, 212489, 214640,
	216802, 218976, 221161, 223359,
	225569, 227790, 230023, 232268,
	234525, 236794, 239075, 241368,
	243672, 245989, 248318, 250658,
	253011, 255375, 257752, 260141,
	262541, 264954, 267379, 269815,
	272264, 274725, 277198, 279683,
	282180, 284689, 287211, 289744,
	292290, 294848, 297418, 300000,
};

static const struct str_flookup_table flookup_table[302] = {
	{  0,   0},  {  1,  20},
	{ 20,   7},  { 27,   5},
	{ 32,   4},  { 36,   4},
	{ 40,   4},  { 44,   3},
	{ 47,   3},  { 50,   2},
	{ 52,   3},  { 55,   2},
	{ 57,   3},  { 60,   2},
	{ 62,   2},  { 64,   2},
	{ 66,   2},  { 68,   2},
	{ 70,   1},  { 71,   2},
	{ 73,   2},  { 75,   2},
	{ 77,   1},  { 78,   2},
	{ 80,   1},  { 81,   2},
	{ 83,   1},  { 84,   2},
	{ 86,   1},  { 87,   2},
	{ 89,   1},  { 90,   1},
	{ 91,   2},  { 93,   1},
	{ 94,   1},  { 95,   2},
	{ 97,   1},  { 98,   1},
	{ 99,   1},  {100,   1},
	{101,   2},  {103,   1},
	{104,   1},  {105,   1},
	{106,   1},  {107,   1},
	{108,   1},  {109,   1},
	{110,   1},  {111,   1},
	{112,   1},  {113,   1},
	{114,   1},  {115,   1},
	{116,   1},  {117,   1},
	{118,   1},  {119,   1},
	{120,   1},  {121,   1},
	{122,   1},  {123,   1},
	{124,   1},  {125,   1},
	{126,   1},  {127,   1},
	{128,   1},  {129,   1},
	{  0,   0},  {130,   1},
	{131,   1},  {132,   1},
	{133,   1},  {134,   1},
	{  0,   0},  {135,   1},
	{136,   1},  {137,   1},
	{138,   1},  {139,   1},
	{  0,   0},  {140,   1},
	{141,   1},  {142,   1},
	{  0,   0},  {143,   1},
	{144,   1},  {145,   1},
	{146,   1},  {  0,   0},
	{147,   1},  {148,   1},
	{149,   1},  {  0,   0},
	{150,   1},  {151,   1},
	{  0,   0},  {152,   1},
	{153,   1},  {154,   1},
	{  0,   0},  {155,   1},
	{156,   1},  {  0,   0},
	{157,   1},  {158,   1},
	{  0,   0},  {159,   1},
	{160,   1},  {  0,   0},
	{161,   1},  {162,   1},
	{  0,   0},  {163,   1},
	{164,   1},  {  0,   0},
	{165,   1},  {166,   1},
	{  0,   0},  {167,   1},
	{168,   1},  {  0,   0},
	{169,   1},  {170,   1},
	{  0,   0},  {171,   1},
	{  0,   0},  {172,   1},
	{173,   1},  {  0,   0},
	{174,   1},  {  0,   0},
	{175,   1},  {176,   1},
	{  0,   0},  {177,   1},
	{  0,   0},  {178,   1},
	{179,   1},  {  0,   0},
	{180,   1},  {  0,   0},
	{181,   1},  {182,   1},
	{  0,   0},  {183,   1},
	{  0,   0},  {184,   1},
	{  0,   0},  {185,   1},
	{186,   1},  {  0,   0},
	{187,   1},  {  0,   0},
	{188,   1},  {  0,   0},
	{189,   1},  {  0,   0},
	{190,   1},  {191,   1},
	{  0,   0},  {192,   1},
	{  0,   0},  {193,   1},
	{  0,   0},  {194,   1},
	{  0,   0},  {195,   1},
	{  0,   0},  {196,   1},
	{  0,   0},  {197,   1},
	{198,   1},  {  0,   0},
	{199,   1},  {  0,   0},
	{200,   1},  {  0,   0},
	{201,   1},  {  0,   0},
	{202,   1},  {  0,   0},
	{203,   1},  {  0,   0},
	{204,   1},  {  0,   0},
	{205,   1},  {  0,   0},
	{206,   1},  {  0,   0},
	{207,   1},  {  0,   0},
	{208,   1},  {  0,   0},
	{209,   1},  {  0,   0},
	{210,   1},  {  0,   0},
	{211,   1},  {  0,   0},
	{212,   1},  {  0,   0},
	{213,   1},  {  0,   0},
	{  0,   0},  {214,   1},
	{  0,   0},  {215,   1},
	{  0,   0},  {216,   1},
	{  0,   0},  {217,   1},
	{  0,   0},  {218,   1},
	{  0,   0},  {219,   1},
	{  0,   0},  {220,   1},
	{  0,   0},  {221,   1},
	{  0,   0},  {  0,   0},
	{222,   1},  {  0,   0},
	{223,   1},  {  0,   0},
	{224,   1},  {  0,   0},
	{225,   1},  {  0,   0},
	{  0,   0},  {226,   1},
	{  0,   0},  {227,   1},
	{  0,   0},  {228,   1},
	{  0,   0},  {229,   1},
	{  0,   0},  {  0,   0},
	{230,   1},  {  0,   0},
	{231,   1},  {  0,   0},
	{232,   1},  {  0,   0},
	{233,   1},  {  0,   0},
	{  0,   0},  {234,   1},
	{  0,   0},  {235,   1},
	{  0,   0},  {  0,   0},
	{236,   1},  {  0,   0},
	{237,   1},  {  0,   0},
	{238,   1},  {  0,   0},
	{  0,   0},  {239,   1},
	{  0,   0},  {240,   1},
	{  0,   0},  {241,   1},
	{  0,   0},  {  0,   0},
	{242,   1},  {  0,   0},
	{243,   1},  {  0,   0},
	{  0,   0},  {244,   1},
	{  0,   0},  {245,   1},
	{  0,   0},  {  0,   0},
	{246,   1},  {  0,   0},
	{247,   1},  {  0,   0},
	{  0,   0},  {248,   1},
	{  0,   0},  {249,   1},
	{  0,   0},  {  0,   0},
	{250,   1},  {  0,   0},
	{251,   1},  {  0,   0},
	{  0,   0},  {252,   1},
	{  0,   0},  {253,   1},
	{  0,   0},  {  0,   0},
	{254,   1},  {  0,   0},
	{  0,   0},  {255,   1},
};

#endif /* __REF_VOLT_TABLE_H__ */
