#ifndef __S6E8AA0_GAMMA_H__
#define __S6E8AA0_GAMMA_H__

#include "s6e8aa0_param.h"

#define ACL_PARAM_SIZE	ARRAY_SIZE(SEQ_ACL_CUTOFF_50)

enum {
	ACL_STATUS_0P = 0,
	ACL_STATUS_20P,
	ACL_STATUS_33P,
	ACL_STATUS_43P,
	ACL_STATUS_45P_80CD,
	ACL_STATUS_45P,
	ACL_STATUS_46P_160CD,
	ACL_STATUS_46P,
	ACL_STATUS_47P,
	ACL_STATUS_48P,
	ACL_STATUS_49P,
	ACL_STATUS_50P,
	ACL_STATUS_MAX,
};

static const unsigned char SEQ_PANEL_CONDITION_SET[] = {
	0xF8,
	0x25, 0x34, 0x00, 0x00, 0x00, 0x95, 0x00, 0x3C, 0x7D, 0x08,
	0x27, 0x00, 0x00, 0x10, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x02, 0x08, 0x08, 0x23, 0x63, 0xC0, 0xC1,
	0x01, 0x81, 0xC1, 0x00, 0xC8, 0xC1, 0xD3, 0x01
};

static const unsigned char SEQ_ETC_SOURCE_CONTROL[] = {
	0xF6,
	0x00, 0x02, 0x00
};

static const unsigned char SEQ_ETC_PENTILE_CONTROL[] = {
	0xB6,
	0x0C, 0x02, 0x03, 0x32, 0xC0,
	0x44, 0x44, 0xC0, 0x00
};

static const unsigned char SEQ_ETC_POWER_CONTROL[] = {
	0xF4,
	0xCF, 0x0A, 0x12, 0x10, 0x19,
	0x33, 0x03
};

static const unsigned char SEQ_ELVSS_NVM_SETTING[] = {
	0xD9,
	0x14, 0x40, 0x0C, 0xCB, 0xCE,
	0x6E, 0xC4, 0x0F, 0x40, 0x41,
	0xD9, 0x00, 0x00, 0x00
};

static const unsigned char SEQ_LTPS_DELAY[] = {
	0xFE,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x0B, 0x53, 0x3C
};

static const unsigned char SEQ_ACL_CUTOFF_20[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x04, 0x06,
	0x09, 0x0C, 0x0F, 0x11, 0x14,
	0x17, 0x19, 0x1C
};

static const unsigned char SEQ_ACL_CUTOFF_33[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x05, 0x0A,
	0x0E, 0x13, 0x17, 0x1B, 0x20,
	0x24, 0x29, 0x2D
};

static const unsigned char SEQ_ACL_CUTOFF_43[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x07, 0x0D,
	0x13, 0x19, 0x20, 0x26, 0x2C,
	0x32, 0x38, 0x3E
};

static const unsigned char SEQ_ACL_CUTOFF_45_80CD[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x07, 0x0E,
	0x14, 0x1B, 0x21, 0x27, 0x2E,
	0x34, 0x3B, 0x41
};

static const unsigned char SEQ_ACL_CUTOFF_45[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x07, 0x0E,
	0x14, 0x1A, 0x21, 0x27, 0x2D,
	0x33, 0x3A, 0x40
};

static const unsigned char SEQ_ACL_CUTOFF_46_160CD[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x07, 0x0E,
	0x14, 0x1A, 0x21, 0x27, 0x2D,
	0x33, 0x3A, 0x41
};

static const unsigned char SEQ_ACL_CUTOFF_46[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x07, 0x0E,
	0x14, 0x1B, 0x21, 0x27, 0x2E,
	0x34, 0x3B, 0x41
};

static const unsigned char SEQ_ACL_CUTOFF_47[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x0E,
	0x15, 0x1B, 0x22, 0x29, 0x2F,
	0x36, 0x3C, 0x43
};

static const unsigned char SEQ_ACL_CUTOFF_48[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x0F,
	0x15, 0x1C, 0x23, 0x2A, 0x31,
	0x37, 0x3E, 0x45
};

static const unsigned char SEQ_ACL_CUTOFF_49[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x0F,
	0x16, 0x1D, 0x24, 0x2A, 0x31,
	0x38, 0x3F, 0x46
};

static const unsigned char SEQ_ACL_CUTOFF_50[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00,
	0x00, 0x03, 0x1F, 0x00, 0x00,
	0x04, 0xFF, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x01, 0x08, 0x0F,
	0x16, 0x1D, 0x24, 0x2B, 0x32,
	0x39, 0x40, 0x47
};


static const unsigned char *ACL_CUTOFF_TABLE[ACL_STATUS_MAX] = {
	SEQ_ACL_OFF,
	SEQ_ACL_CUTOFF_20,
	SEQ_ACL_CUTOFF_33,
	SEQ_ACL_CUTOFF_43,
	SEQ_ACL_CUTOFF_45_80CD,
	SEQ_ACL_CUTOFF_45,
	SEQ_ACL_CUTOFF_46_160CD,
	SEQ_ACL_CUTOFF_46,
	SEQ_ACL_CUTOFF_47,
	SEQ_ACL_CUTOFF_48,
	SEQ_ACL_CUTOFF_49,
	SEQ_ACL_CUTOFF_50,

};

#endif /* __S6E8AA0_GAMMA_H__ */
