#ifndef __S6E8AA0_GAMMA_H__
#define __S6E8AA0_GAMMA_H__

#define ACL_PARAM_SIZE	ARRAY_SIZE(acl_cutoff_50)
#define AID_PARAM_SIZE	ARRAY_SIZE(SEQ_PANEL_CONDITION_SET_500MBPS)

enum {
	GAMMA_20CD,
	GAMMA_30CD,
	GAMMA_40CD,
	GAMMA_50CD,
	GAMMA_60CD,
	GAMMA_70CD,
	GAMMA_80CD,
	GAMMA_90CD,
	GAMMA_100CD,
	GAMMA_110CD,
	GAMMA_120CD,
	GAMMA_130CD,
	GAMMA_140CD,
	GAMMA_150CD,
	GAMMA_160CD,
	GAMMA_170CD,
	GAMMA_180CD,
	GAMMA_190CD,
	GAMMA_200CD,
	GAMMA_210CD,
	GAMMA_220CD,
	GAMMA_230CD,
	GAMMA_240CD,
	GAMMA_250CD,
	GAMMA_300CD,
	GAMMA_MAX
};

enum {
	ELVSS_MIN = 0,
	ELVSS_1,
	ELVSS_2,
	ELVSS_MAX,
	ELVSS_STATUS_MAX,
};

static const unsigned char SEQ_APPLY_LEVEL_1_KEY[] = {
	0xF0,
	0x5A, 0x5A
};

static const unsigned char SEQ_PWRSEQCTL[] = {
	0xF5,
	0x54, 0x96, 0x33, 0x01, 0x35
};

static const unsigned char SEQ_DISPLAY_BRIGHTNESSS[] = {
	0x51,
	0xFF, 0x00
};

static const unsigned char SEQ_CONTROL_DISPLAY[] = {
	0x53,
	0x20, 0x00
};

static const unsigned char SEQ_APPLY_MTP_KEY_ENABLE[] = {
	0xF1,
	0x5A, 0x5A
};

static const unsigned char SEQ_SLEEP_OUT[] = {
	0x11,
	0x00, 0x00
};

static const unsigned char SEQ_PANEL_CONDITION_SET[] = {
	0xF8,
	0x21, 0x02, 0x00, 0xC8, 0x00, 0x00, 0x00, 0x00, 0x3D, 0x7D,
	0x08, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x00,
	0x00, 0x08, 0x5E, 0x08, 0x5E, 0x08, 0x08, 0x23, 0x5E, 0xC0,
	0xC1, 0x00, 0x01, 0x00, 0x00, 0x80, 0xC1, 0x00, 0xC3, 0xF0,
	0x67, 0x89, 0xC1
};

static const unsigned char SEQ_DISPLAY_CONDITION_SET[] = {
	0xF2,
	0x00, 0xA0, 0x08, 0x08
};

static const unsigned char SEQ_GAMMA_CONDITION_SET[] = {
	0xFA,
	0x00, 0x07, 0x2B, 0x37, 0x44, 0xD4, 0xD5, 0xCF, 0xCF, 0xD2,
	0xCB, 0xB3, 0xB7, 0xA9, 0xBC, 0xC0, 0xAE, 0xD0, 0xD2, 0xC3,
	0xCD, 0xCD, 0xBC, 0xB6, 0xB3, 0x9E, 0xE4, 0xDB, 0xEC, 0x56,
	0x08
};

static const unsigned char SEQ_GAMMA_UPDATE[] = {
	0xF7, 0x03,
	0x00
};

static const unsigned char SEQ_GAMMA_UPDATE2[] = {
	0xF7, 0x00,
	0x00
};

static const unsigned char SEQ_ETC_SOURCE_CONTROL[] = {
	0xF6,
	0x2B, 0x2B, 0x2B, 0x00
};

static const unsigned char SEQ_ETC_NVM_SETTING[] = {
	0xD9,
	0x00, 0x08, 0x97, 0x7E, 0xAB, 0x10, 0x00, 0xA0, 0x02, 0xFF,
	0x1B, 0x56, 0x20, 0xA7, 0x50, 0x43, 0x26, 0x35, 0xA8, 0x55,
	0x10, 0xA4, 0xA2
};


static const unsigned char SEQ_ETC_POWER_CONTROL[] = {
	0xF4,
	0x0D, 0x00, 0x06, 0x0F, 0x00, 0x0A, 0x00, 0x00, 0x33, 0x00,
	0x00, 0xC0, 0x2C, 0xC8, 0x1B, 0x8C
};

static const unsigned char SEQ_ELVSS_CONTROL[] = {
	0xB1,
	0x10, 0x00
};

static const unsigned char SEQ_DISPLAY_ON[] = {
	0x29,
	0x00, 0x00
};

static const unsigned char SEQ_DISPLAY_OFF[] = {
	0x28,
	0x00, 0x00
};

static const unsigned char SEQ_STANDBY_ON[] = {
	0x10,
	0x00, 0x00
};

enum {
	ACL_STATUS_0P = 0,
	ACL_STATUS_20P,
	ACL_STATUS_33P,
	ACL_STATUS_40P,
	ACL_STATUS_43P,
	ACL_STATUS_45P,
	ACL_STATUS_48P,
	ACL_STATUS_50P,
	ACL_STATUS_52P,
	ACL_STATUS_53P,
	ACL_STATUS_55P,
	ACL_STATUS_MAX
} ACL_STATUS;

static const unsigned char SEQ_ACL_OFF[] = {
	0xC0, 0x00,
	0x00
};

const unsigned char acl_cutoff_20[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x04, 0x07, 0x0A, 0x0D, 0x10,
	0x12, 0x15, 0x18, 0x1B, 0x1E
};

const unsigned char acl_cutoff_33[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x06, 0x0A, 0x0F, 0x14, 0x19,
	0x1D, 0x22, 0x27, 0x2B, 0x30
};

const unsigned char acl_cutoff_40[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x07, 0x0C, 0x12, 0x17, 0x1D,
	0x23, 0x28, 0x2E, 0x33, 0x39
};

const unsigned char acl_cutoff_43[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x07, 0x0D, 0x14, 0x1A, 0x20,
	0x26, 0x2C, 0x33, 0x39, 0x3F
};

const unsigned char acl_cutoff_45[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x07, 0x0E, 0x14, 0x1B, 0x21,
	0x27, 0x2E, 0x34, 0x3B, 0x41
};

const unsigned char acl_cutoff_48[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x08, 0x0F, 0x17, 0x1E, 0x25,
	0x2C, 0x33, 0x3B, 0x42, 0x49
};

const unsigned char acl_cutoff_50[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x09, 0x10, 0x18, 0x1F, 0x27,
	0x2E, 0x36, 0x3D, 0x45, 0x4C
};

const unsigned char acl_cutoff_52[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x09, 0x11, 0x19, 0x21, 0x29,
	0x31, 0x39, 0x41, 0x49, 0x51
};

const unsigned char acl_cutoff_53[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x09, 0x11, 0x1A, 0x22, 0x2A,
	0x32, 0x3A, 0x43, 0x4B, 0x53
};

const unsigned char acl_cutoff_55[] = {
	0xC1,
	0x47, 0x53, 0x13, 0x53, 0x00, 0x00,
	0x02, 0xCF, 0x00, 0x00, 0x04, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00,

	0x01, 0x0A, 0x12, 0x1B, 0x23, 0x2C,
	0x35, 0x3D, 0x46, 0x4E, 0x57
};

const unsigned char *ACL_CUTOFF_TABLE[ACL_STATUS_MAX] = {
	SEQ_ACL_OFF,
	acl_cutoff_20,
	acl_cutoff_33,
	acl_cutoff_40,
	acl_cutoff_43,
	acl_cutoff_45,
	acl_cutoff_48,
	acl_cutoff_50,
	acl_cutoff_52,
	acl_cutoff_53,
	acl_cutoff_55,
};

#endif /* __S6E8AA0_GAMMA_H__ */
