#ifndef __MDNIE_TABLE_H__
#define __MDNIE_TABLE_H__

#include "mdnie.h"


static unsigned short tune_dynamic_gallery[] = {
	/*start P8,  dynamic,  gallery */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x03FF, /*DE SHARPNESS ## */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x00a0, /*CS GAIN ## */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF, /*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF, /*yw B */
	0x00D6, 0x1d00, /*GAMMA ## */
	0x00D7, 0x1d00,
	0x00D8, 0x1d00,
	0x00D9, 0x1d00,
	0x00DA, 0x1d00,
	0x00DB, 0x1d00,
	0x00DC, 0x1d00,
	0x00DD, 0x1d00,
	0x00DE, 0x1d00,
	0x00DF, 0x1d00,
	0x00E0, 0x1d00,
	0x00E1, 0x1d00,
	0x00E2, 0x1d00,
	0x00E3, 0x1d00,
	0x00E4, 0x1d00,
	0x00E5, 0xa40e,
	0x00E6, 0xa40e,
	0x00E7, 0xa40e,
	0x00E8, 0xa819,
	0x00E9, 0xa40a,
	0x00EA, 0x2200,
	0x00EB, 0x1c25,
	0x00EC, 0x1842,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_ui[] = {
	/*start P8,  dynamic,  ui */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x0000, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x00a0, /*CS GAIN ## */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF, /*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF, /*yw B */
	0x00D6, 0x1d00, /*GAMMA ## */
	0x00D7, 0x1d00,
	0x00D8, 0x1d00,
	0x00D9, 0x1d00,
	0x00DA, 0x1d00,
	0x00DB, 0x1d00,
	0x00DC, 0x1d00,
	0x00DD, 0x1d00,
	0x00DE, 0x1d00,
	0x00DF, 0x1d00,
	0x00E0, 0x1d00,
	0x00E1, 0x1d00,
	0x00E2, 0x1d00,
	0x00E3, 0x1d00,
	0x00E4, 0x1d00,
	0x00E5, 0xa40e,
	0x00E6, 0xa40e,
	0x00E7, 0xa40e,
	0x00E8, 0xa819,
	0x00E9, 0xa40a,
	0x00EA, 0x2200,
	0x00EB, 0x1c25,
	0x00EC, 0x1842,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_video[] = {
	/*start P8,  dynamic,  video */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D,	/*HDTR DE CS */
	0x003B, 0x03FF, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x00a0, /*CS GAIN ## */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF, /*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF, /*yw B */
	0x00D6, 0x1d00, /*GAMMA ## */
	0x00D7, 0x1d00,
	0x00D8, 0x1d00,
	0x00D9, 0x1d00,
	0x00DA, 0x1d00,
	0x00DB, 0x1d00,
	0x00DC, 0x1d00,
	0x00DD, 0x1d00,
	0x00DE, 0x1d00,
	0x00DF, 0x1d00,
	0x00E0, 0x1d00,
	0x00E1, 0x1d00,
	0x00E2, 0x1d00,
	0x00E3, 0x1d00,
	0x00E4, 0x1d00,
	0x00E5, 0xa40e,
	0x00E6, 0xa40e,
	0x00E7, 0xa40e,
	0x00E8, 0xa819,
	0x00E9, 0xa40a,
	0x00EA, 0x2200,
	0x00EB, 0x1c25,
	0x00EC, 0x1842,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_vt[] = {
	/*start P8,  dynamic,  vt */
	0x0001, 0x0040, /*SCR HDTR */
	0x002c, 0x0fff, /*DNR bypass, dir_th   0x003c */
	0x002d, 0x19ff, /*DNR dir_num, decont7 0x0a08 */
	0x002e, 0xff16, /*DNR decont5, mask_th 0x1010 */
	0x002F, 0x0000, /*DNR block_th        0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x03FF, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x00a0, /*CS GAIN ## */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000,	/*rm G */
	0x00CF, 0xFFFF,	/*yw G */
	0x00D0, 0x00FF,	/*kb B */
	0x00D1, 0x00FF,	/*gc B */
	0x00D2, 0x00FF,	/*rm B */
	0x00D3, 0x00FF,	/*yw B */
	0x00D6, 0x1d00, /*GAMMA ## */
	0x00D7, 0x1d00,
	0x00D8, 0x1d00,
	0x00D9, 0x1d00,
	0x00DA, 0x1d00,
	0x00DB, 0x1d00,
	0x00DC, 0x1d00,
	0x00DD, 0x1d00,
	0x00DE, 0x1d00,
	0x00DF, 0x1d00,
	0x00E0, 0x1d00,
	0x00E1, 0x1d00,
	0x00E2, 0x1d00,
	0x00E3, 0x1d00,
	0x00E4, 0x1d00,
	0x00E5, 0xa40e,
	0x00E6, 0xa40e,
	0x00E7, 0xa40e,
	0x00E8, 0xa819,
	0x00E9, 0xa40a,
	0x00EA, 0x2200,
	0x00EB, 0x1c25,
	0x00EC, 0x1842,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_movie_gallery[] = {
	/*start P8,  movie,  gallery */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x0009, /*HDTR CS ## */
	0x003B, 0x0300, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0xa5af, /*gc R */
	0x00CA, 0xd5fe, /*rm R */
	0x00CB, 0xffff, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xffff, /*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7f8, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f0, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_movie_ui[] = {
	/*start P8,  movie,  ui */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x0009, /*HDTR CS ## */
	0x003B, 0x0000, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0xa5af, /*gc R */
	0x00CA, 0xd5fe, /*rm R */
	0x00CB, 0xffff, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xffff, /*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7f8, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f0, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_movie_video[] = {
	/*start P8,  movie,  video */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x0009, /*HDTR CS ## */
	0x003B, 0x03FF, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0xa5af, /*gc R */
	0x00CA, 0xd5fe, /*rm R */
	0x00CB, 0xffff, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xffff, /*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7f8, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f0, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_movie_vt[] = {
	/*start P8,  movie,  vt */
	0x0001, 0x0040, /*SCR HDTR */
	0x002c, 0x0fff, /*DNR bypass, dir_th   0x003c */
	0x002d, 0x19ff, /*DNR dir_num, decont7 0x0a08 */
	0x002e, 0xff16, /*DNR decont5, mask_th 0x1010 */
	0x002F, 0x0000, /*DNR block_th        0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x0030, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0xa5af, /*gc R */
	0x00CA, 0xd5fe, /*rm R */
	0x00CB, 0xffff, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xffff, /*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7f8, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f0, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_gallery[] = {
	/*start P8,  standard,  gallery */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x0300, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF,	/*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_ui[] = {
	/*start P8,  standard,  ui */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x0000, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF, /*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_video[] = {
	/*start P8,  standard,  video */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x03FF, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF, /*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF,	/*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_vt[] = {
	/*start P8,  standard,  vt */
	0x0001, 0x0040, /*SCR HDTR */
	0x002c, 0x0fff, /*DNR bypass, dir_th   0x003c */
	0x002d, 0x19ff, /*DNR dir_num, decont7 0x0a08 */
	0x002e, 0xff16, /*DNR decont5, mask_th 0x1010 */
	0x002F, 0x0000, /*DNR block_th        0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x03FF, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0038, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF, /*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_natural_gallery[] = {
	/*start P8,  natural,  gallery */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x0300, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0180, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0xa5af, /*gc R */
	0x00CA, 0xd5fe, /*rm R */
	0x00CB, 0xffff, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xffff, /*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7fa, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f8, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_natural_ui[] = {
	/*start P8,  natural,  ui */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x0000, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0180, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0xa5af, /*gc R */
	0x00CA, 0xd5fe, /*rm R */
	0x00CB, 0xffff, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xffff, /*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7fa, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f8, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_natural_video[] = {
	/*start P8,  natural,  video */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900,	/*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x03FF,	/*DE SHARPNESS */
	0x003C, 0x0000,	/*NOISE LEVEL */
	0x003F, 0x0180,	/*CS GAIN */
	0x0042, 0x0000,	/*DE TH (MAX DIFF) */
	0x00C8, 0x0000,	/*kb R	SCR */
	0x00C9, 0xa5af,	/*gc R */
	0x00CA, 0xd5fe,	/*rm R */
	0x00CB, 0xffff,	/*yw R */
	0x00CC, 0x0000,	/*kb G */
	0x00CD, 0xffff,	/*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7fa, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f8, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_natural_vt[] = {
	/*start P8,  natural,  vt */
	0x0001, 0x0040, /*SCR HDTR */
	0x002c, 0x0fff, /*DNR bypass, dir_th   0x003c */
	0x002d, 0x19ff, /*DNR dir_num, decont7 0x0a08 */
	0x002e, 0xff16, /*DNR decont5, mask_th 0x1010 */
	0x002F, 0x0000, /*DNR block_th        0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x03FF, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0180, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0xa5af, /*gc R */
	0x00CA, 0xd5fe, /*rm R */
	0x00CB, 0xffff, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xffff, /*gc G */
	0x00CE, 0x374d, /*rm G */
	0x00CF, 0xf7fa, /*yw G */
	0x00D0, 0x00ff, /*kb B */
	0x00D1, 0x63fb, /*gc B */
	0x00D2, 0x30ff, /*rm B */
	0x00D3, 0x69f8, /*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

static unsigned short tune_camera[] = {
	/*start P8,  camera */
	0x0001, 0x0040, /*SCR HDTR */
	0x002C, 0x0FFF, /*DNR bypass 0x003C */
	0x002D, 0x1900, /*DNR bypass 0x0a08 */
	0x002E, 0x0000, /*DNR bypass 0x1010 */
	0x002F, 0x0FFF, /*DNR bypass 0x0400 */
	0x003A, 0x000D, /*HDTR DE CS */
	0x003B, 0x0000, /*DE SHARPNESS */
	0x003C, 0x0000, /*NOISE LEVEL */
	0x003F, 0x0028, /*CS GAIN */
	0x0042, 0x0000, /*DE TH (MAX DIFF) */
	0x00C8, 0x0000, /*kb R	SCR */
	0x00C9, 0x0000, /*gc R */
	0x00CA, 0xFFFF, /*rm R */
	0x00CB, 0xFFFF, /*yw R */
	0x00CC, 0x0000, /*kb G */
	0x00CD, 0xFFFF, /*gc G */
	0x00CE, 0x0000, /*rm G */
	0x00CF, 0xFFFF, /*yw G */
	0x00D0, 0x00FF, /*kb B */
	0x00D1, 0x00FF, /*gc B */
	0x00D2, 0x00FF, /*rm B */
	0x00D3, 0x00FF,	/*yw B */
	0x00D6, 0x3F00, /*GAMMA  */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000, /* Mask */
	/*end */
	END_SEQ, 0x0000
};

struct mdnie_tuning_info tuning_table[CABC_MAX][MODE_MAX][SCENARIO_MAX] = {
	{
		{
			{"dynamic_ui",		tune_dynamic_ui},
			{"dynamic_video",	tune_dynamic_video},
			{"dynamic_video",	tune_dynamic_video},
			{"dynamic_video",	tune_dynamic_video},
			{"camera",		tune_camera},
			{"dynamic_ui",		tune_dynamic_ui},
			{"dynamic_gallery",	tune_dynamic_gallery},
			{"dynamic_vt",		tune_dynamic_vt}
		}, {
			{"standard_ui",		tune_standard_ui},
			{"standard_video",	tune_standard_video},
			{"standard_video",	tune_standard_video},
			{"standard_video",	tune_standard_video},
			{"camera",		tune_camera},
			{"standard_ui",		tune_standard_ui},
			{"standard_gallery",	tune_standard_gallery},
			{"standard_vt",		tune_standard_vt}
		}, {
			{"natural_ui",		tune_natural_ui},
			{"natural_video",	tune_natural_video},
			{"natural_video",	tune_natural_video},
			{"natural_video",	tune_natural_video},
			{"camera",		tune_camera},
			{"natural_ui",		tune_natural_ui},
			{"natural_gallery",	tune_natural_gallery},
			{"natural_vt",		tune_natural_vt}
		}, {
			{"movie_ui",		tune_movie_ui},
			{"movie_video",		tune_movie_video},
			{"movie_video",		tune_movie_video},
			{"movie_video",		tune_movie_video},
			{"camera",		tune_camera},
			{"movie_ui",		tune_movie_ui},
			{"movie_gallery",	tune_movie_gallery},
			{"movie_vt",		tune_movie_vt}
		}
	}
};

#endif /* __MDNIE_TABLE_H__ */
