#ifndef __MDNIE_TABLE_P4_WACOM_H__
#define __MDNIE_TABLE_P4_WACOM_H__

#include "mdnie.h"


static struct mdnie_backlight_value backlight_table[3] = {
	{
		.max = 1216,	/* 76% */
		.mid = 679,	/* 39% */
		.low = 16,	/* 1% */
		.dim = 16,	/* 1% */
	}, {
		.max = 1441,
		.mid = 784,
		.low = 16,
		.dim = 16,
	}, {
		.max = 1216,	/* 76% */
		.mid = 679,	/* 39% */
		.low = 16,	/* 1% */
		.dim = 16,	/* 1% */
	}
};

static const unsigned char power_lut[2][9] = {
	{0x42, 0x47, 0x3E, 0x52, 0x42, 0x3F, 0x3A, 0x37, 0x3F},
	{0x38, 0x3d, 0x34, 0x48, 0x38, 0x35, 0x30, 0x2d, 0x35},
};

static unsigned short tune_dynamic_gallery[] = {
	/*start P4 dynamic, gallery, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x03ff,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x01a0,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4, 0x4640,	 Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xFFf8,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1a00,	/*GAMMA n1d 2517*/
	0x00D7, 0x1a00,
	0x00D8, 0x1a00,
	0x00D9, 0x1a00,
	0x00DA, 0x1a00,
	0x00DB, 0x1a00,
	0x00DC, 0x1a00,
	0x00DD, 0x1a00,
	0x00DE, 0x1a00,
	0x00DF, 0x1a00,
	0x00E0, 0xa40c,
	0x00E1, 0xa40c,
	0x00E2, 0xa40c,
	0x00E3, 0xa40c,
	0x00E4, 0xa40c,
	0x00E5, 0xa40c,
	0x00E6, 0xa40c,
	0x00E7, 0xa40c,
	0x00E8, 0xa40c,
	0x00E9, 0xa40c,
	0x00EA, 0xa40c,
	0x00EB, 0x1c26,
	0x00EC, 0x1652,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_ui[] = {
	/*start P4 dynamic, ui, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x01a0,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4, 0x4640,	 Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xFFf8,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1a00,	/*GAMMA n1d 2517*/
	0x00D7, 0x1a00,
	0x00D8, 0x1a00,
	0x00D9, 0x1a00,
	0x00DA, 0x1a00,
	0x00DB, 0x1a00,
	0x00DC, 0x1a00,
	0x00DD, 0x1a00,
	0x00DE, 0x1a00,
	0x00DF, 0x1a00,
	0x00E0, 0xa40c,
	0x00E1, 0xa40c,
	0x00E2, 0xa40c,
	0x00E3, 0xa40c,
	0x00E4, 0xa40c,
	0x00E5, 0xa40c,
	0x00E6, 0xa40c,
	0x00E7, 0xa40c,
	0x00E8, 0xa40c,
	0x00E9, 0xa40c,
	0x00EA, 0xa40c,
	0x00EB, 0x1c26,
	0x00EC, 0x1652,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_video[] = {
	/*start P4 dynamic, video, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0FFF,	/*DNR*/
	0x002d, 0x1905,	/*dirnum,decon7*/
	0x002e, 0x0507,	/*decon5,maskth*/
	0x002f, 0x0000,
	0x003A, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x03ff,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x01a0,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4,0x4640,	Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff8,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1a00,	/*GAMMA n1d 2517*/
	0x00D7, 0x1a00,
	0x00D8, 0x1a00,
	0x00D9, 0x1a00,
	0x00DA, 0x1a00,
	0x00DB, 0x1a00,
	0x00DC, 0x1a00,
	0x00DD, 0x1a00,
	0x00DE, 0x1a00,
	0x00DF, 0x1a00,
	0x00E0, 0xa40c,
	0x00E1, 0xa40c,
	0x00E2, 0xa40c,
	0x00E3, 0xa40c,
	0x00E4, 0xa40c,
	0x00E5, 0xa40c,
	0x00E6, 0xa40c,
	0x00E7, 0xa40c,
	0x00E8, 0xa40c,
	0x00E9, 0xa40c,
	0x00EA, 0xa40c,
	0x00EB, 0x1c26,
	0x00EC, 0x1652,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_vt[] = {
	/*start P4 standard, vt, cabcoff*/
	0x0001, 0x0060,	/*LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass,dir_th   0x003c*/
	0x002d, 0x19ff,	/*DNR dir_num,decont7 0x0a08*/
	0x002e, 0xff16,	/*DNR decont5,mask_th 0x1010*/
	0x002F, 0x0000,	/*DNR block_th	      0x0400*/
	0x003a, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x0300,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0100,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4,0x4640,	CABC PWM set*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff8,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1500,	/*GAMMA p1va-0.5*/
	0x00D7, 0x1500,
	0x00D8, 0x1500,
	0x00D9, 0x1500,
	0x00DA, 0x1500,
	0x00DB, 0x1500,
	0x00DC, 0x1500,
	0x00DD, 0x1500,
	0x00DE, 0x1500,
	0x00DF, 0x1500,
	0x00E0, 0x1500,
	0x00E1, 0x1500,
	0x00E2, 0xa315,
	0x00E3, 0xa315,
	0x00E4, 0xa315,
	0x00E5, 0xa315,
	0x00E6, 0xa315,
	0x00E7, 0xa315,
	0x00E8, 0xa315,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_gallery[] = {
	/*start P4 movie, gallery, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4, 0x4640,	Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x1500,	/*GAMMA p1va-0.5*/
	0x00D7, 0x1500,
	0x00D8, 0x1500,
	0x00D9, 0x1500,
	0x00DA, 0x1500,
	0x00DB, 0x1500,
	0x00DC, 0x1500,
	0x00DD, 0x1500,
	0x00DE, 0x1500,
	0x00DF, 0x1500,
	0x00E0, 0x1500,
	0x00E1, 0x1500,
	0x00E2, 0xa315,
	0x00E3, 0xa315,
	0x00E4, 0xa315,
	0x00E5, 0xa315,
	0x00E6, 0xa315,
	0x00E7, 0xa315,
	0x00E8, 0xa315,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_ui[] = {
	/*start P4 movie, ui, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4,0x4640,	Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x1500,	/*GAMMA p1va-0.5*/
	0x00D7, 0x1500,
	0x00D8, 0x1500,
	0x00D9, 0x1500,
	0x00DA, 0x1500,
	0x00DB, 0x1500,
	0x00DC, 0x1500,
	0x00DD, 0x1500,
	0x00DE, 0x1500,
	0x00DF, 0x1500,
	0x00E0, 0x1500,
	0x00E1, 0x1500,
	0x00E2, 0xa315,
	0x00E3, 0xa315,
	0x00E4, 0xa315,
	0x00E5, 0xa315,
	0x00E6, 0xa315,
	0x00E7, 0xa315,
	0x00E8, 0xa315,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_video[] = {
	/*start P4 movie, video, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0FFF,	/*DNR*/
	0x002d, 0x1905,	/*dirnum,decon7*/
	0x002e, 0x0507,	/*decon5,maskth*/
	0x002f, 0x0000,
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4, 0x4640,	Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x2000,	/*Gamma p1va+2*/
	0x00D7, 0x2000,
	0x00D8, 0x2000,
	0x00D9, 0x2000,
	0x00DA, 0x2000,
	0x00DB, 0x2000,
	0x00DC, 0x2000,
	0x00DD, 0x2000,
	0x00DE, 0x2000,
	0x00DF, 0x2000,
	0x00E0, 0x2000,
	0x00E1, 0x2000,
	0x00E2, 0x1c06,
	0x00E3, 0x1c06,
	0x00E4, 0x1c06,
	0x00E5, 0x1c06,
	0x00E6, 0x1c06,
	0x00E7, 0x1c06,
	0x00E8, 0x1c06,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_vt[] = {
	/*start P4 movie, vt, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0fff,	/*DNR bypass,dir_th   0x003c*/
	0x002d, 0x19ff,	/*DNR dir_num,decont7 0x0a08*/
	0x002e, 0xff16,	/*DNR decont5,mask_th 0x1010*/
	0x002F, 0x0000,	/*DNR block_th        0x0400*/
	0x003A, 0x000d,	/*HDTR DE CS*/
	0x003B, 0x0030,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4,0x4640,	Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x1500,	/*GAMMA p1va-0.5*/
	0x00D7, 0x1500,
	0x00D8, 0x1500,
	0x00D9, 0x1500,
	0x00DA, 0x1500,
	0x00DB, 0x1500,
	0x00DC, 0x1500,
	0x00DD, 0x1500,
	0x00DE, 0x1500,
	0x00DF, 0x1500,
	0x00E0, 0x1500,
	0x00E1, 0x1500,
	0x00E2, 0xa315,
	0x00E3, 0xa315,
	0x00E4, 0xa315,
	0x00E5, 0xa315,
	0x00E6, 0xa315,
	0x00E7, 0xa315,
	0x00E8, 0xa315,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_standard_gallery[] = {
	/* start P4 standard, gallery, cabcoff */
	0x0001, 0x0060,	/* LABC CABC */
	0x002c, 0x0fff,	/* DNR bypass */
	0x002d, 0x1900,	/* DNR bypass */
	0x002e, 0x0000,	/* DNR bypass */
	0x002f, 0x0FFF,	/* DNR bypass */
	0x003a, 0x000D,	/* HDTR DE CS */
	0x003B, 0x03ff,	/* DE SHARPNESS */
	0x003C, 0x0000,	/* NOISE LEVEL */
	0x003F, 0x0100,	/* CS GAIN */
	0x0042, 0x0000,	/* DE TH (MAX DIFF) */
	/* 0x00b4,0x4640,	CABC PWM set */
	0x00c8, 0x0000,	/* kb R	SCR */
	0x00c9, 0x0000,	/* gc R */
	0x00ca, 0xffff,	/* rm R */
	0x00cb, 0xffff,	/* yw R */
	0x00cc, 0x0000,	/* kb G */
	0x00cd, 0xffff,	/* gc G */
	0x00ce, 0x0000,	/* rm G */
	0x00cf, 0xfff8,	/* yw G */
	0x00d0, 0x00ff,	/* kb B */
	0x00d1, 0x00ff,	/* gc B */
	0x00d2, 0x00ff,	/* rm B */
	0x00d3, 0x00ff,	/* yw B */
	0x00D6, 0x1500,	/* GAMMA p1va-0.5 */
	0x00D7, 0x1500,
	0x00D8, 0x1500,
	0x00D9, 0x1500,
	0x00DA, 0x1500,
	0x00DB, 0x1500,
	0x00DC, 0x1500,
	0x00DD, 0x1500,
	0x00DE, 0x1500,
	0x00DF, 0x1500,
	0x00E0, 0x1500,
	0x00E1, 0x1500,
	0x00E2, 0xa315,
	0x00E3, 0xa315,
	0x00E4, 0xa315,
	0x00E5, 0xa315,
	0x00E6, 0xa315,
	0x00E7, 0xa315,
	0x00E8, 0xa315,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,
	/* end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_ui[] = {
	/*start P4 standard, ui, cabcoff */
	0x0001, 0x0020,	/*SCR LABC */
	0x002c, 0x0fff,	/*DNR bypass 0x003C */
	0x002d, 0x1900,	/*DNR bypass 0x0a08 */
	0x002e, 0x0000,	/*DNR bypass 0x1010 */
	0x002f, 0x0fff,	/*DNR bypass 0x0400 */
	0x003A, 0x0009,	/*HDTR CS */
	0x003B, 0x0030,	/*DE SHARPNESS */
	0x003C, 0x0000,	/*NOISE LEVEL */
	0x003F, 0x0000,	/*CS GAIN */
	0x0042, 0x0000,	/*DE TH (MAX DIFF) */
	/*0x00b4,0x4640,	Count PWM */
	0x00c8, 0x0000,	/*kb R	SCR */
	0x00c9, 0x0000,	/*gc R */
	0x00ca, 0xffff,	/*rm R */
	0x00cb, 0xffff,	/*yw R */
	0x00cc, 0x0000,	/*kb G */
	0x00cd, 0xffff,	/*gc G */
	0x00ce, 0x0000,	/*rm G */
	0x00cf, 0xfff8,	/*yw G */
	0x00d0, 0x00ff,	/*kb B */
	0x00d1, 0x00ff,	/*gc B */
	0x00d2, 0x00ff,	/*rm B */
	0x00d3, 0x00ff,	/*yw B */
	0x00D6, 0x1800,	/*GAMMA 2.6 */
	0x00D7, 0x1800,
	0x00D8, 0x1800,
	0x00D9, 0x1800,
	0x00DA, 0x1800,
	0x00DB, 0x1800,
	0x00DC, 0x1800,
	0x00DD, 0x1800,
	0x00DE, 0x1800,
	0x00DF, 0x1800,
	0x00E0, 0x1800,
	0x00E1, 0x1800,
	0x00E2, 0x1800,
	0x00E3, 0x1800,
	0x00E4, 0x1800,
	0x00E5, 0x1800,
	0x00E6, 0x1800,
	0x00E7, 0x9f10,
	0x00E8, 0xa41d,
	0x00E9, 0xa41d,
	0x00EA, 0xa41d,
	0x00EB, 0xa41d,
	0x00EC, 0xa41d,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/* Register Mask */
	/* end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_video[] = {
	/*start P4 standard, video, cabcoff*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0FFF,	/*DNR*/
	0x002d, 0x1905,	/* dirnum,decon7 */
	0x002e, 0x0507,	/* decon5,maskth */
	0x002f, 0x0000,	/*  */
	0x003A, 0x000D,	/* HDTR DE CS */
	0x003B, 0x03ff,	/* DE SHARPNESS */
	0x003C, 0x0000,	/* NOISE LEVEL */
	0x003F, 0x0110,	/* CS GAIN */
	0x0042, 0x0000,	/* DE TH (MAX DIFF) */
	/* 0x00b4,0x4640,	Count PWM */
	0x00c8, 0x0000,	/* kb R	SCR */
	0x00c9, 0x0000,	/* gc R */
	0x00ca, 0xffff,	/* rm R */
	0x00cb, 0xffff,	/* yw R */
	0x00cc, 0x0000,	/* kb G */
	0x00cd, 0xffff,	/* gc G */
	0x00ce, 0x0000,	/* rm G */
	0x00cf, 0xfff8,	/* yw G */
	0x00d0, 0x00ff,	/* kb B */
	0x00d1, 0x00ff,	/* gc B */
	0x00d2, 0x00ff,	/* rm B */
	0x00d3, 0x00ff,	/* yw B */
	0x00D6, 0x2000,	/* Gamma p1va+2 */
	0x00D7, 0x2000,
	0x00D8, 0x2000,
	0x00D9, 0x2000,
	0x00DA, 0x2000,
	0x00DB, 0x2000,
	0x00DC, 0x2000,
	0x00DD, 0x2000,
	0x00DE, 0x2000,
	0x00DF, 0x2000,
	0x00E0, 0x2000,
	0x00E1, 0x2000,
	0x00E2, 0x1c06,
	0x00E3, 0x1c06,
	0x00E4, 0x1c06,
	0x00E5, 0x1c06,
	0x00E6, 0x1c06,
	0x00E7, 0x1c06,
	0x00E8, 0x1c06,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/* Register Mask */
	/* end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_vt[] = {
	/*start P4 standard, vt, cabcoff*/
	0x0001, 0x0060,	/*LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass,dir_th   0x003c*/
	0x002d, 0x19ff,	/*DNR dir_num,decont7 0x0a08*/
	0x002e, 0xff16,	/*DNR decont5,mask_th 0x1010*/
	0x002F, 0x0000,	/*DNR block_th        0x0400*/
	0x003a, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x0300,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0100,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4,0x4640,	CABC PWM set*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff8,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1500,	/*GAMMA p1va-0.5*/
	0x00D7, 0x1500,
	0x00D8, 0x1500,
	0x00D9, 0x1500,
	0x00DA, 0x1500,
	0x00DB, 0x1500,
	0x00DC, 0x1500,
	0x00DD, 0x1500,
	0x00DE, 0x1500,
	0x00DF, 0x1500,
	0x00E0, 0x1500,
	0x00E1, 0x1500,
	0x00E2, 0xa315,
	0x00E3, 0xa315,
	0x00E4, 0xa315,
	0x00E5, 0xa315,
	0x00E6, 0xa315,
	0x00E7, 0xa315,
	0x00E8, 0xa315,
	0x00E9, 0xa315,
	0x00EA, 0xa315,
	0x00EB, 0xa315,
	0x00EC, 0xa315,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_gallery_cabc[] = {
	/*start P4 dynamic, gallery, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x03ff,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x01a0,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076, 0x383d,	PowerLUT 3C50*/
	/*0x0077, 0x3442,	PowerLUT 2D64*/
	/*0x0078, 0x3835,	PowerLUT 3C32*/
	/*0x0079, 0x302d,	PowerLUT 1E00*/
	/*0x007a, 0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4, 0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff5,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1a00,	/*GAMMA n1dc, 2215*/
	0x00D7, 0x1a00,
	0x00D8, 0x1a00,
	0x00D9, 0x1a00,
	0x00DA, 0x1a00,
	0x00DB, 0xa407,
	0x00DC, 0xa407,
	0x00DD, 0xa407,
	0x00DE, 0xa407,
	0x00DF, 0xa407,
	0x00E0, 0xa407,
	0x00E1, 0xa407,
	0x00E2, 0xa407,
	0x00E3, 0xa407,
	0x00E4, 0xa407,
	0x00E5, 0xa407,
	0x00E6, 0xa407,
	0x00E7, 0xa407,
	0x00E8, 0xa407,
	0x00E9, 0xa407,
	0x00EA, 0xa407,
	0x00EB, 0x1844,
	0x00EC, 0x1461,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_ui_cabc[] = {
	/*start P4 dynamic, ui, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x01a0,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076, 0x383d,	PowerLUT 3C50*/
	/*0x0077, 0x3442,	PowerLUT 2D64*/
	/*0x0078, 0x3835,	PowerLUT 3C32*/
	/*0x0079, 0x302d,	PowerLUT 1E00*/
	/*0x007a, 0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4, 0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff5,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1a00,	/*GAMMA n1dc, 2215*/
	0x00D7, 0x1a00,
	0x00D8, 0x1a00,
	0x00D9, 0x1a00,
	0x00DA, 0x1a00,
	0x00DB, 0xa407,
	0x00DC, 0xa407,
	0x00DD, 0xa407,
	0x00DE, 0xa407,
	0x00DF, 0xa407,
	0x00E0, 0xa407,
	0x00E1, 0xa407,
	0x00E2, 0xa407,
	0x00E3, 0xa407,
	0x00E4, 0xa407,
	0x00E5, 0xa407,
	0x00E6, 0xa407,
	0x00E7, 0xa407,
	0x00E8, 0xa407,
	0x00E9, 0xa407,
	0x00EA, 0xa407,
	0x00EB, 0x1844,
	0x00EC, 0x1461,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_video_cabc[] = {
	/*start P4 dynamic, video, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0FFF,	/*DNR*/
	0x002d, 0x1905,	/*dirnum,decon7*/
	0x002e, 0x0507,	/*decon5,maskth*/
	0x002f, 0x0000,
	0x003A, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x03ff,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x01a0,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076, 0x383d,	PowerLUT 3C50*/
	/*0x0077, 0x3442,	PowerLUT 2D64*/
	/*0x0078, 0x3835,	PowerLUT 3C32*/
	/*0x0079, 0x302d,	PowerLUT 1E00*/
	/*0x007a, 0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4, 0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff5,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x2600,	/*GAMMA p5_dvc 2011*/
	0x00D7, 0x2600,
	0x00D8, 0x2600,
	0x00D9, 0x2600,
	0x00DA, 0x2501,
	0x00DB, 0x2501,
	0x00DC, 0x2501,
	0x00DD, 0x2501,
	0x00DE, 0x2501,
	0x00DF, 0x2501,
	0x00E0, 0x2501,
	0x00E1, 0x2501,
	0x00E2, 0x2501,
	0x00E3, 0x2501,
	0x00E4, 0x2501,
	0x00E5, 0x2501,
	0x00E6, 0x2501,
	0x00E7, 0x2501,
	0x00E8, 0x2501,
	0x00E9, 0x2501,
	0x00EA, 0x1f20,
	0x00EB, 0x136b,
	0x00EC, 0x1081,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_dynamic_vt_cabc[] = {
	/*start P4 dynamic, vt, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass,dir_th   0x003c*/
	0x002d, 0x19ff,	/*DNR dir_num,decont7 0x0a08*/
	0x002e, 0xff16,	/*DNR decont5,mask_th 0x1010*/
	0x002F, 0x0000,	/*DNR block_th        0x0400*/
	0x003A, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x03ff,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x01a0,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076,0x383d,	PowerLUT 3C50*/
	/*0x0077,0x3442,	PowerLUT 2D64*/
	/*0x0078,0x3835,	PowerLUT 3C32*/
	/*0x0079,0x302d,	PowerLUT 1E00*/
	/*0x007a,0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4,0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff5,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x1a00,	/*GAMMA n1dc, 2215*/
	0x00D7, 0x1a00,
	0x00D8, 0x1a00,
	0x00D9, 0x1a00,
	0x00DA, 0x1a00,
	0x00DB, 0xa407,
	0x00DC, 0xa407,
	0x00DD, 0xa407,
	0x00DE, 0xa407,
	0x00DF, 0xa407,
	0x00E0, 0xa407,
	0x00E1, 0xa407,
	0x00E2, 0xa407,
	0x00E3, 0xa407,
	0x00E4, 0xa407,
	0x00E5, 0xa407,
	0x00E6, 0xa407,
	0x00E7, 0xa407,
	0x00E8, 0xa407,
	0x00E9, 0xa407,
	0x00EA, 0xa407,
	0x00EB, 0x1844,
	0x00EC, 0x1461,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_gallery_cabc[] = {
	/*start P4 movie, gallery, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076, 0x383d,	PowerLUT 3C50*/
	/*0x0077, 0x3442,	PowerLUT 2D64*/
	/*0x0078, 0x3835,	PowerLUT 3C32*/
	/*0x0079, 0x302d,	PowerLUT 1E00*/
	/*0x007a, 0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4, 0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x3f00,	/*GAMMA p5_mc 22*/
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_ui_cabc[] = {
	/*start P4 movie, ui, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076, 0x383d,	PowerLUT 3C50*/
	/*0x0077, 0x3442,	PowerLUT 2D64*/
	/*0x0078, 0x3835,	PowerLUT 3C32*/
	/*0x0079, 0x302d,	PowerLUT 1E00*/
	/*0x007a, 0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4, 0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x3f00,	/*GAMMA p5_mc 22*/
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_video_cabc[] = {
	/*start P4 movie, video, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0FFF,	/*DNR*/
	0x002d, 0x1905,	/*dirnum,decon7*/
	0x002e, 0x0507,	/*decon5,maskth*/
	0x002f, 0x0000,
	0x003A, 0x0009,	/*HDTR CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076, 0x383d,	PowerLUT 3C50*/
	/*0x0077, 0x3442,	PowerLUT 2D64*/
	/*0x0078, 0x3835,	PowerLUT 3C32*/
	/*0x0079, 0x302d,	PowerLUT 1E00*/
	/*0x007a, 0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4, 0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x6800,	/*GAMMA p5_mvc 20*/
	0x00D7, 0x2007,
	0x00D8, 0x2007,
	0x00D9, 0x2007,
	0x00DA, 0x2007,
	0x00DB, 0x2007,
	0x00DC, 0x2007,
	0x00DD, 0x2007,
	0x00DE, 0x2007,
	0x00DF, 0x2007,
	0x00E0, 0x2007,
	0x00E1, 0x2007,
	0x00E2, 0x2007,
	0x00E3, 0x2007,
	0x00E4, 0x2007,
	0x00E5, 0x2007,
	0x00E6, 0x2007,
	0x00E7, 0x2007,
	0x00E8, 0x2007,
	0x00E9, 0x2007,
	0x00EA, 0x2007,
	0x00EB, 0x2007,
	0x00EC, 0x1a33,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_movie_vt_cabc[] = {
	/*start P4 movie, vt, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass,dir_th   0x003c*/
	0x002d, 0x19ff,	/*DNR dir_num,decont7 0x0a08*/
	0x002e, 0xff16,	/*DNR decont5,mask_th 0x1010*/
	0x002F, 0x0000,	/*DNR block_th        0x0400*/
	0x003A, 0x000d,	/*HDTR DE CS*/
	0x003B, 0x0030,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076,0x383d,	PowerLUT 3C50*/
	/*0x0077,0x3442,	PowerLUT 2D64*/
	/*0x0078,0x3835,	PowerLUT 3C32*/
	/*0x0079,0x302d,	PowerLUT 1E00*/
	/*0x007a,0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4,0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xffee,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00e9,	/*yw B*/
	0x00D6, 0x3f00,	/*GAMMA p5_mc 22*/
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2003,
	0x00E9, 0x2003,
	0x00EA, 0x2003,
	0x00EB, 0x2003,
	0x00EC, 0x2003,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_standard_gallery_cabc[] = {
	/* start P4 standard, gallery, cabcon */
	0x0001, 0x0070,	/* SCR LABC CABC  */
	0x002c, 0x0fff,	/* DNR bypass 0x003C */
	0x002d, 0x1900,	/* DNR bypass 0x0a08 */
	0x002e, 0x0000,	/* DNR bypass 0x1010 */
	0x002f, 0x0fff,	/* DNR bypass 0x0400 */
	0x003A, 0x000D,	/* HDTR DE CS */
	0x003B, 0x03ff,	/* DE SHARPNESS */
	0x003C, 0x0000,	/* NOISE LEVEL */
	0x003F, 0x0100,	/* CS GAIN */
	0x0042, 0x0000,	/* DE TH (MAX DIFF) */
	0x0072, 0x0000,	/* CABC Dgain */
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/* 0x0076, 0x383d,	PowerLUT 3C50 */
	/* 0x0077, 0x3442,	PowerLUT 2D64 */
	/* 0x0078, 0x3835,	PowerLUT 3C32 */
	/* 0x0079, 0x302d,	PowerLUT 1E00 */
	/* 0x007a, 0x3500,	PowerLUT 3200 */
	0x007C, 0x0002,	/* Dynamic LCD */
	/* 0x00b4, 0x5640,	CABC PWM */
	0x00c8, 0x0000,	/* kb R	SCR */
	0x00c9, 0x0000,	/* gc R */
	0x00ca, 0xffff,	/* rm R */
	0x00cb, 0xffff,	/* yw R */
	0x00cc, 0x0000,	/* kb G */
	0x00cd, 0xffff,	/* gc G */
	0x00ce, 0x0000,	/* rm G */
	0x00cf, 0xfff5,	/* yw G */
	0x00d0, 0x00ff,	/* kb B */
	0x00d1, 0x00ff,	/* gc B */
	0x00d2, 0x00ff,	/* rm B */
	0x00d3, 0x00ff,	/* yw B */
	0x00D6, 0x3f00,	/* GAMMA n1sc, 2217 */
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2100,
	0x00E9, 0xa40c,
	0x00EA, 0xa40c,
	0x00EB, 0x1c26,
	0x00EC, 0x1652,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/* Register Mask */
	/* end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_ui_cabc[] = {
	/*start P4 standard, ui, cabcon */
	0x0001, 0x0030,	/*SCR LABC CABC */
	0x002c, 0x0fff,	/*DNR bypass 0x003C */
	0x002d, 0x1900,	/*DNR bypass 0x0a08 */
	0x002e, 0x0000,	/*DNR bypass 0x1010 */
	0x002f, 0x0fff,	/*DNR bypass 0x0400 */
	0x003A, 0x0009,	/*HDTR CS */
	0x003B, 0x0030,	/*DE SHARPNESS */
	0x003C, 0x0000,	/*NOISE LEVEL */
	0x003F, 0x0000,	/*CS GAIN */
	0x0042, 0x0000,	/*DE TH (MAX DIFF) */
	0x0072, 0x0000,	/*CABC Dgain */
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076, 0x383d,	PowerLUT 3C50 */
	/*0x0077, 0x3442,	PowerLUT 2D64 */
	/*0x0078, 0x3835,	PowerLUT 3C32 */
	/*0x0079, 0x302d,	PowerLUT 1E00 */
	/*0x007a, 0x3500,	PowerLUT 3200 */
	0x007C, 0x0002,	/*Dynamic LCD */
	/*0x00b4, 0x5640,	CABC PWM */
	0x00c8, 0x0000,	/*kb R	SCR */
	0x00c9, 0x0000,	/*gc R */
	0x00ca, 0xffff,	/*rm R */
	0x00cb, 0xffff,	/*yw R */
	0x00cc, 0x0000,	/*kb G */
	0x00cd, 0xffff,	/*gc G */
	0x00ce, 0x0000,	/*rm G */
	0x00cf, 0xfff5,	/*yw G */
	0x00d0, 0x00ff,	/*kb B */
	0x00d1, 0x00ff,	/*gc B */
	0x00d2, 0x00ff,	/*rm B */
	0x00d3, 0x00ff,	/*yw B */
	0x00D6, 0x1800,	/*GAMMA 2.6c */
	0x00D7, 0x1800,
	0x00D8, 0x1800,
	0x00D9, 0x1800,
	0x00DA, 0x1800,
	0x00DB, 0x1800,
	0x00DC, 0x1800,
	0x00DD, 0x1800,
	0x00DE, 0x1800,
	0x00DF, 0x1800,
	0x00E0, 0x1800,
	0x00E1, 0x1800,
	0x00E2, 0x1800,
	0x00E3, 0x1800,
	0x00E4, 0x1800,
	0x00E5, 0x1800,
	0x00E6, 0x1800,
	0x00E7, 0xa825,
	0x00E8, 0xa825,
	0x00E9, 0xa825,
	0x00EA, 0xa825,
	0x00EB, 0x1c26,
	0x00EC, 0x1652,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/* Register Mask */
	/* end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_video_cabc[] = {
	/* start P4 standard, video, cabcon */
	0x0001, 0x0070,	/* SCR LABC CABC  */
	0x002c, 0x0FFF,	/* DNR */
	0x002d, 0x1905,	/* dirnum,decon7 */
	0x002e, 0x0507,	/* decon5,maskth */
	0x002f, 0x0000,
	0x003A, 0x000D,	/* HDTR DE CS */
	0x003B, 0x03ff,	/* DE SHARPNESS */
	0x003C, 0x0000,	/* NOISE LEVEL */
	0x003F, 0x0110,	/* CS GAIN */
	0x0042, 0x0000,	/* DE TH (MAX DIFF) */
	0x0072, 0x0000,	/* CABC Dgain */
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/* 0x0076, 0x383d,	PowerLUT 3C50 */
	/* 0x0077, 0x3442,	PowerLUT 2D64 */
	/* 0x0078, 0x3835,	PowerLUT 3C32 */
	/* 0x0079, 0x302d,	PowerLUT 1E00 */
	/* 0x007a, 0x3500,	PowerLUT 3200 */
	0x007C, 0x0002,	/* Dynamic LCD */
	/* 0x00b4, 0x5640,	CABC PWM */
	0x00c8, 0x0000,	/* kb R	SCR */
	0x00c9, 0x0000,	/* gc R */
	0x00ca, 0xffff,	/*rm R */
	0x00cb, 0xffff,	/* yw R */
	0x00cc, 0x0000,	/* kb G */
	0x00cd, 0xffff,	/* gc G */
	0x00ce, 0x0000,	/* rm G */
	0x00cf, 0xfff5,	/* yw G */
	0x00d0, 0x00ff,	/* kb B */
	0x00d1, 0x00ff,	/* gc B */
	0x00d2, 0x00ff,	/* rm B */
	0x00d3, 0x00ff,	/* yw B */
	0x00D6, 0x2600,	/* GAMMA p5_svc 2013 */
	0x00D7, 0x2600,
	0x00D8, 0x2600,
	0x00D9, 0x2401,
	0x00DA, 0x2401,
	0x00DB, 0x2401,
	0x00DC, 0x2401,
	0x00DD, 0x2401,
	0x00DE, 0x2401,
	0x00DF, 0x2401,
	0x00E0, 0x2401,
	0x00E1, 0x2401,
	0x00E2, 0x2401,
	0x00E3, 0x2401,
	0x00E4, 0x2401,
	0x00E5, 0x2401,
	0x00E6, 0x2401,
	0x00E7, 0x2401,
	0x00E8, 0x2401,
	0x00E9, 0x2401,
	0x00EA, 0x2016,
	0x00EB, 0x1654,
	0x00EC, 0x1179,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/* Register Mask */
	/* end */
	END_SEQ, 0x0000
};

static unsigned short tune_standard_vt_cabc[] = {
	/*start P4 standard, vt, cabcon*/
	0x0001, 0x0070,	/*SCR LABC CABC*/
	0x002c, 0x0fff,	/*DNR bypass,dir_th   0x003c*/
	0x002d, 0x19ff,	/*DNR dir_num,decont7 0x0a08*/
	0x002e, 0xff16,	/*DNR decont5,mask_th 0x1010*/
	0x002F, 0x0000,	/*DNR block_th	      0x0400*/
	0x003A, 0x000D,	/*HDTR DE CS*/
	0x003B, 0x0300,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0100,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	0x0072, 0x0000,	/*CABC Dgain*/
	0x0073, 0x0000,
	0x0074, 0x0000,
	0x0075, 0x0000,
	/*0x0076,0x383d,	PowerLUT 3C50*/
	/*0x0077,0x3442,	PowerLUT 2D64*/
	/*0x0078,0x3835,	PowerLUT 3C32*/
	/*0x0079,0x302d,	PowerLUT 1E00*/
	/*0x007a,0x3500,	PowerLUT 3200*/
	0x007C, 0x0002,	/*Dynamic LCD*/
	/*0x00b4,0x5640,	CABC PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xfff5,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x3f00,	/*GAMMA n1sc, 2217*/
	0x00D7, 0x2003,
	0x00D8, 0x2003,
	0x00D9, 0x2003,
	0x00DA, 0x2003,
	0x00DB, 0x2003,
	0x00DC, 0x2003,
	0x00DD, 0x2003,
	0x00DE, 0x2003,
	0x00DF, 0x2003,
	0x00E0, 0x2003,
	0x00E1, 0x2003,
	0x00E2, 0x2003,
	0x00E3, 0x2003,
	0x00E4, 0x2003,
	0x00E5, 0x2003,
	0x00E6, 0x2003,
	0x00E7, 0x2003,
	0x00E8, 0x2100,
	0x00E9, 0xa40c,
	0x00EA, 0xa40c,
	0x00EB, 0x1c26,
	0x00EC, 0x1652,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

static unsigned short tune_camera[] = {
	/*start P4 camera*/
	0x0001, 0x0060,	/*SCR LABC*/
	0x002c, 0x0fff,	/*DNR bypass 0x003C*/
	0x002d, 0x1900,	/*DNR bypass 0x0a08*/
	0x002e, 0x0000,	/*DNR bypass 0x1010*/
	0x002f, 0x0fff,	/*DNR bypass 0x0400*/
	0x003A, 0x0009,	/*HDTR DE CS*/
	0x003B, 0x0000,	/*DE SHARPNESS*/
	0x003C, 0x0000,	/*NOISE LEVEL*/
	0x003F, 0x0080,	/*CS GAIN*/
	0x0042, 0x0000,	/*DE TH (MAX DIFF)*/
	/*0x00b4, 0x4640,	Count PWM*/
	0x00c8, 0x0000,	/*kb R	SCR*/
	0x00c9, 0x0000,	/*gc R*/
	0x00ca, 0xffff,	/*rm R*/
	0x00cb, 0xffff,	/*yw R*/
	0x00cc, 0x0000,	/*kb G*/
	0x00cd, 0xffff,	/*gc G*/
	0x00ce, 0x0000,	/*rm G*/
	0x00cf, 0xFFf8,	/*yw G*/
	0x00d0, 0x00ff,	/*kb B*/
	0x00d1, 0x00ff,	/*gc B*/
	0x00d2, 0x00ff,	/*rm B*/
	0x00d3, 0x00ff,	/*yw B*/
	0x00D6, 0x2000,	/*GAMMA 2.2*/
	0x00D7, 0x2000,
	0x00D8, 0x2000,
	0x00D9, 0x2000,
	0x00DA, 0x2000,
	0x00DB, 0x2000,
	0x00DC, 0x2000,
	0x00DD, 0x2000,
	0x00DE, 0x2000,
	0x00DF, 0x2000,
	0x00E0, 0x2000,
	0x00E1, 0x2000,
	0x00E2, 0x2000,
	0x00E3, 0x2000,
	0x00E4, 0x2000,
	0x00E5, 0x2000,
	0x00E6, 0x2000,
	0x00E7, 0x2000,
	0x00E8, 0x2000,
	0x00E9, 0x2000,
	0x00EA, 0x2000,
	0x00EB, 0x2000,
	0x00EC, 0x2000,
	0x00ED, 0xFF00,
	0x00D5, 0x0001,
	0x0028, 0x0000,	/*Register Mask*/
	/*end*/
	END_SEQ, 0x0000
};

struct mdnie_tuning_info tuning_table[CABC_MAX][MODE_MAX][SCENARIO_MAX] = {
	{
		{
			{"dynamic_ui",		tune_dynamic_ui},
			{"dynamic_video",	tune_dynamic_video},
			{"dynamic_video",	tune_dynamic_video},
			{"dynamic_video",	tune_dynamic_video},
			{"camera",		tune_camera},
			{"dynamic_ui",		tune_dynamic_ui},
			{"dynamic_gallery",	tune_dynamic_gallery},
			{"dynamic_vt",		tune_dynamic_vt}
		}, {
			{"standard_ui",		tune_standard_ui},
			{"standard_video",	tune_standard_video},
			{"standard_video",	tune_standard_video},
			{"standard_video",	tune_standard_video},
			{"camera",		tune_camera},
			{"standard_ui",		tune_standard_ui},
			{"standard_gallery",	tune_standard_gallery},
			{"standard_vt",		tune_standard_vt}
		}, {
			{"movie_ui",		tune_movie_ui},
			{"movie_video",		tune_movie_video},
			{"movie_video",		tune_movie_video},
			{"movie_video",		tune_movie_video},
			{"camera",		tune_camera},
			{"movie_ui",		tune_movie_ui},
			{"movie_gallery",	tune_movie_gallery},
			{"movie_vt",		tune_movie_vt}
		}
	}, {
		{
			{"dynamic_ui_cabc",		tune_dynamic_ui_cabc},
			{"dynamic_video_cabc",		tune_dynamic_video_cabc},
			{"dynamic_video_cabc",		tune_dynamic_video_cabc},
			{"dynamic_video_cabc",		tune_dynamic_video_cabc},
			{"camera",			tune_camera},
			{"dynamic_ui_cabc",		tune_dynamic_ui_cabc},
			{"dynamic_gallery_cabc",	tune_dynamic_gallery_cabc},
			{"dynamic_vt_cabc",		tune_dynamic_vt_cabc}
		}, {
			{"standard_ui_cabc",		tune_standard_ui_cabc},
			{"standard_video_cabc",		tune_standard_video_cabc},
			{"standard_video_cabc",		tune_standard_video_cabc},
			{"standard_video_cabc",		tune_standard_video_cabc},
			{"camera",			tune_camera},
			{"standard_ui_cabc",		tune_standard_ui_cabc},
			{"standard_gallery_cabc",	tune_standard_gallery_cabc},
			{"standard_vt_cabc",		tune_standard_vt_cabc}
		}, {
			{"movie_ui_cabc",		tune_movie_ui_cabc},
			{"movie_video_cabc",		tune_movie_video_cabc},
			{"movie_video_cabc",		tune_movie_video_cabc},
			{"movie_video_cabc",		tune_movie_video_cabc},
			{"camera",			tune_camera},
			{"movie_ui_cabc",		tune_movie_ui_cabc},
			{"movie_gallery_cabc",		tune_movie_gallery_cabc},
			{"movie_vt_cabc",		tune_movie_vt_cabc}
		}
	}
};

#endif /* __MDNIE_TABLE_P4_H__ */
