#ifndef __LD9042_PANEL_H__
#define __LD9042_PANEL_H__

static unsigned short SEQ_ELVSS_MAX[] = {
	0xB2, 0x00,

	DATA_ONLY, 0x00,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x00,
	ENDDEF, 0x00
};

static unsigned short SEQ_ELVSS_2[] = {
	0xB2, 0x09,

	DATA_ONLY, 0x09,
	DATA_ONLY, 0x09,
	DATA_ONLY, 0x09,
	ENDDEF, 0x00
};

static unsigned short SEQ_ELVSS_1[] = {
	0xB2, 0x0C,

	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x0C,
	ENDDEF, 0x00
};

static unsigned short SEQ_ELVSS_MIN[] = {
	0xB2, 0x0D,

	DATA_ONLY, 0x0D,
	DATA_ONLY, 0x0D,
	DATA_ONLY, 0x0D,
	ENDDEF, 0x00
};

static unsigned short *ELVSS_TABLE[] = {
	SEQ_ELVSS_MIN,
	SEQ_ELVSS_1,
	SEQ_ELVSS_2,
	SEQ_ELVSS_MAX,
};


/* LD9042, 4.27", SM2 A2 Panel Gamma Data */
static unsigned short ld9042_a2_22_300[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xBC,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xBC,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xCC,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_290[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xCA,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_280[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC7,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_270[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xBF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA3,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xBF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xBF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC4,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_260[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA1,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xBF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xBF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC1,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_250[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9E,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBE,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_240[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9C,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBB,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_230[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x99,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC1,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC1,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB7,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_220[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC1,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x96,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC2,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB4,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_210[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC2,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x94,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC2,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB1,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_200[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC2,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x91,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAE,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_190[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8E,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAB,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_180[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA5,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA4,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA7,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_170[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA5,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x89,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA3,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA1,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA4,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_160[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA5,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x85,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA2,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9D,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9F,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_150[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x82,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA1,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x99,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9B,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_140[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA5,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x7F,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA0,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x95,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x97,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_130[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA5,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x7C,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x9F,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x91,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x93,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_120[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA4,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x77,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x9D,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8C,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8E,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_110[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA4,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x73,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x9C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x88,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xCB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x89,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_100[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA4,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x70,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x9B,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x85,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xCB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x86,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_90[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA3,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xCC,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x6B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x97,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xCD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x7F,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xCE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x80,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_70[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xA2,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xCC,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x62,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x94,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xCE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x74,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xCF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x75,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_40[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0x9D,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xCF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x50,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x88,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xD1,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x60,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xC1,
	DATA_ONLY, 0xD3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x60,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_22_30[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0x91,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xD1,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x48,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x7A,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0xD4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x57,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0xD5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x56,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_300[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xC3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xCC,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_290[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA5,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xCA,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_280[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA2,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC1,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC8,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_270[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA0,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA6,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC5,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_260[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9D,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xC1,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_250[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9A,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBD,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_240[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x97,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA8,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xBA,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_230[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x95,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC4,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB7,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_220[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x91,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xA9,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xB3,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_210[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8E,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC6,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC5,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAF,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_200[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA7,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xAB,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_190[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x88,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA3,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA8,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_180[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x85,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9F,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC7,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA4,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_170[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x82,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAA,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xC8,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0xA0,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_160[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x7F,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x97,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBC,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x9C,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_150[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x7B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAB,
	DATA_ONLY, 0xCB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x93,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xC9,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x97,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_140[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x77,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xCB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8F,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBC,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xCA,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x92,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_130[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xCB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x73,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xCB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBC,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xCB,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x8D,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_120[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xCD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x6F,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAC,
	DATA_ONLY, 0xCC,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x86,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBC,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xCC,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x89,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_110[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xCD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x6B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB6,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xCD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x81,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBF,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xCC,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x84,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_100[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xB8,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xCD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x66,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB4,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAD,
	DATA_ONLY, 0xCE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x7C,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xCD,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x7E,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_90[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xCE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x61,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xAE,
	DATA_ONLY, 0xCE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x77,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xCE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x78,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_70[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xCF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x56,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xBB,
	DATA_ONLY, 0xAF,
	DATA_ONLY, 0xCF,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x6B,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0xBF,
	DATA_ONLY, 0xB3,
	DATA_ONLY, 0xCE,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x6C,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_40[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xBA,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xD0,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x42,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xA4,
	DATA_ONLY, 0xBD,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xD2,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x53,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0xC1,
	DATA_ONLY, 0xB5,
	DATA_ONLY, 0xD1,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x53,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

static unsigned short ld9042_a2_19_30[] = {
	0xF9, 0x0C,
	DATA_ONLY, 0xB0,
	DATA_ONLY, 0xB9,
	DATA_ONLY, 0xB1,
	DATA_ONLY, 0xD1,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x38,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0x97,
	DATA_ONLY, 0xBE,
	DATA_ONLY, 0xB2,
	DATA_ONLY, 0xD3,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x49,
	DATA_ONLY, 0x0C,
	DATA_ONLY, 0xBC,
	DATA_ONLY, 0xC2,
	DATA_ONLY, 0xB7,
	DATA_ONLY, 0xD2,
	DATA_ONLY, 0x00,
	DATA_ONLY, 0x48,
	0xFB, 0x02,
	DATA_ONLY, 0x5A,
	ENDDEF, 0x00
};

/* LD9042, 4.27", SM2 A2 Panel Gamma Table */
static unsigned short *ld9042_22gamma_table[] = {
	ld9042_a2_22_30,
	ld9042_a2_22_40,
	ld9042_a2_22_70,
	ld9042_a2_22_90,
	ld9042_a2_22_100,
	ld9042_a2_22_110,
	ld9042_a2_22_120,
	ld9042_a2_22_130,
	ld9042_a2_22_140,
	ld9042_a2_22_150,
	ld9042_a2_22_160,
	ld9042_a2_22_170,
	ld9042_a2_22_180,
	ld9042_a2_22_190,
	ld9042_a2_22_200,
	ld9042_a2_22_210,
	ld9042_a2_22_220,
	ld9042_a2_22_230,
	ld9042_a2_22_240,
	ld9042_a2_22_250,
	ld9042_a2_22_300,
};

static unsigned short *ld9042_19gamma_table[] = {
	ld9042_a2_19_30,
	ld9042_a2_19_40,
	ld9042_a2_19_70,
	ld9042_a2_19_90,
	ld9042_a2_19_100,
	ld9042_a2_19_110,
	ld9042_a2_19_120,
	ld9042_a2_19_130,
	ld9042_a2_19_140,
	ld9042_a2_19_150,
	ld9042_a2_19_160,
	ld9042_a2_19_170,
	ld9042_a2_19_180,
	ld9042_a2_19_190,
	ld9042_a2_19_200,
	ld9042_a2_19_210,
	ld9042_a2_19_220,
	ld9042_a2_19_230,
	ld9042_a2_19_240,
	ld9042_a2_19_250,
	ld9042_a2_19_300,
};

#endif
