#ifndef __EA8061_PARAM_H__
#define __EA8061_PARAM_H__

#define GAMMA_PARAM_SIZE	34
#define ACL_PARAM_SIZE	ARRAY_SIZE(acl_cutoff_33)
#define ELVSS_PARAM_SIZE	ARRAY_SIZE(elvss_control_set_20)
#define AID_PARAM_SIZE	ARRAY_SIZE(SEQ_LTPS_AID)

enum {
	GAMMA_20CD,
	GAMMA_30CD,
	GAMMA_40CD,
	GAMMA_50CD,
	GAMMA_60CD,
	GAMMA_70CD,
	GAMMA_80CD,
	GAMMA_90CD,
	GAMMA_100CD,
	GAMMA_102CD,
	GAMMA_104CD,
	GAMMA_106CD,
	GAMMA_108CD,
	GAMMA_110CD,
	GAMMA_120CD,
	GAMMA_130CD,
	GAMMA_140CD,
	GAMMA_150CD,
	GAMMA_160CD,
	GAMMA_170CD,
	GAMMA_180CD,
	GAMMA_182CD,
	GAMMA_184CD,
	GAMMA_186CD,
	GAMMA_188CD,
	GAMMA_190CD,
	GAMMA_200CD,
	GAMMA_210CD,
	GAMMA_220CD,
	GAMMA_230CD,
	GAMMA_240CD,
	GAMMA_250CD,
	GAMMA_300CD,
	GAMMA_MAX
};

static const unsigned char SEQ_APPLY_LEVEL_2_KEY_ENABLE[] = {
	0xF0,
	0x5A, 0x5A
};

static const unsigned char SEQ_APPLY_LEVEL_2_KEY_DISABLE[] = {
	0xF0,
	0xA5, 0xA5
};

static const unsigned char SEQ_APPLY_LEVEL_3_KEY[] = {
	0xFC,
	0x5A, 0x5A
};

static const unsigned char SEQ_MAGNA_GP[] = {
	0xB0,
	0x0E,
};

static const unsigned char SEQ_MAGNA_REFRESH_DISABLE[] = {
	0xDD,
	0x00, 0x00,
};

static const unsigned char SEQ_FRAME_GAMMA_UPDATE_KEY[] = {
	0xF7,
	0x5A, 0x5A
};

static const unsigned char SEQ_FRAME_GAMMA_UPDATE_KEY2[] = {
	0xF7,
	0xA5, 0xA5
};

static const unsigned char SEQ_SLEEP_OUT[] = {
	0x11,
	0x00, 0x00
};

static const unsigned char SEQ_SLEEP_IN[] = {
	0x10,
	0x00, 0x00
};

static const unsigned char SEQ_PANEL_CONDITION_SET[] = {
	0xC4,
	0x4E, 0xBD, 0x00, 0x00, 0x58, 0xA7, 0x0B, 0x34, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0B, 0x92, 0x0B, 0x92, 0x08, 0x08, 0x07,
	0x30, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04,
	0x04,
};

static const unsigned char SEQ_M4_PANEL_CONDITION_SET[] = {
	0xC4,
	0x4E, 0xBD, 0x00, 0x00, 0x58, 0xA7, 0x0B, 0x34, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0B, 0x92, 0x0B, 0x92, 0x08, 0x08, 0x07,
	0x30, 0x50, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04,
	0x04,
};

static const unsigned char SEQ_GAMMA_CONDITION_SET[] = {
	0xCA,
	0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB, 0xDC, 0xD9,
	0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3, 0xD7, 0xE6, 0xE6,
	0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3, 0xCF, 0xB9, 0x9D, 0xDE,
	0x11, 0x00
};

static const unsigned char SEQ_M4_GAMMA_CONDITION_SET[] = {
	0xCA,
	0x00, 0xB6, 0x00, 0xB7, 0x00, 0xD5,	0xD7, 0xDA, 0xDC, 0xD3,
	0xD6, 0xD8, 0xBC, 0xC0, 0xC3, 0xBF, 0xC5, 0xCC, 0xD0, 0xD5,
	0xE0, 0xC8, 0xD1, 0xD8,	0x96, 0xAF, 0xB9, 0x82, 0xB6, 0xC2,
	0x11, 0x00,
};

static const unsigned char SEQ_LTPS_AID[] = {
	0xB3,
	0x00, 0x0A,
};

static const unsigned char ELVSS_CONTROL_SET[] = {
	0xB2, 0x0E,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char SEQ_DISPLAY_CONDITION_SET[] = {
	0x36,
	0x02, 0x00
};

static const unsigned char SEQ_ETC_WCABC_CONTROL[] = {
	0x55,
	0x00, 0x00
};

static const unsigned char SEQ_SLEW_REV00[] = {
	0xB4,
	0x33, 0x0E, 0x00
};

static const unsigned char SEQ_SLEW_REV01[] = {
	0xB4,
	0x33, 0x0E, 0x00
};

static const unsigned char SEQ_SLEW_REV02[] = {
	0xB4,
	0x33, 0x09, 0x00
};

static const unsigned char SEQ_SLEW_REV03[] = {
	0xB4,
	0x33, 0x0D, 0x00
};

static const unsigned char SEQ_SLEW_REV04[] = {
	0xB4,
	0x33, 0x0A, 0x00
};

static const unsigned char SEQ_M4_SLEW[] = {
	0xB4,
	0x33, 0x0D, 0x00
};

static const unsigned char SEQ_DISPLAY_ON[] = {
	0x29,
	0x00, 0x00
};

static const unsigned char SEQ_DISPLAY_OFF[] = {
	0x28,
	0x00, 0x00
};

enum {
	ELVSS_STATUS_20,
	ELVSS_STATUS_30,
	ELVSS_STATUS_40,
	ELVSS_STATUS_50,
	ELVSS_STATUS_60,
	ELVSS_STATUS_70,
	ELVSS_STATUS_80,
	ELVSS_STATUS_90,
	ELVSS_STATUS_100,
	ELVSS_STATUS_110,
	ELVSS_STATUS_120,
	ELVSS_STATUS_130,
	ELVSS_STATUS_140,
	ELVSS_STATUS_150,
	ELVSS_STATUS_160,
	ELVSS_STATUS_170,
	ELVSS_STATUS_180,
	ELVSS_STATUS_190,
	ELVSS_STATUS_200,
	ELVSS_STATUS_210,
	ELVSS_STATUS_220,
	ELVSS_STATUS_230,
	ELVSS_STATUS_240,
	ELVSS_STATUS_250,
	ELVSS_STATUS_300,
	ELVSS_STATUS_MAX
};

static const unsigned char elvss_control_set_20[] = {
	0xB2, 0x20,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_30[] = {
	0xB2, 0x20,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_40[] = {
	0xB2, 0x20,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_50[] = {
	0xB2, 0x1F,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_60[] = {
	0xB2, 0x1F,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_70[] = {
	0xB2, 0x1F,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_80[] = {
	0xB2, 0x1E,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_90[] = {
	0xB2, 0x1E,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_100[] = {
	0xB2, 0x1C,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_110[] = {
	0xB2, 0x1B,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_120[] = {
	0xB2, 0x19,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_130[] = {
	0xB2, 0x17,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_140[] = {
	0xB2, 0x16,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_150[] = {
	0xB2, 0x14,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_160[] = {
	0xB2, 0x12,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_170[] = {
	0xB2, 0x10,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_180[] = {
	0xB2, 0x0F,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_190[] = {
	0xB2, 0x15,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_200[] = {
	0xB2, 0x14,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_210[] = {
	0xB2, 0x13,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_220[] = {
	0xB2, 0x12,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_230[] = {
	0xB2, 0x11,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_240[] = {
	0xB2, 0x10,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_250[] = {
	0xB2, 0x10,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};

static const unsigned char elvss_control_set_300[] = {
	0xB2, 0x0B,
	0xB4, 0xA0, 0x00, 0x00, 0x00, 0x00
};


const unsigned char *ELVSS_CONTROL_TABLE[ELVSS_STATUS_MAX] = {
	elvss_control_set_20,
	elvss_control_set_30,
	elvss_control_set_40,
	elvss_control_set_50,
	elvss_control_set_60,
	elvss_control_set_70,
	elvss_control_set_80,
	elvss_control_set_90,
	elvss_control_set_100,
	elvss_control_set_110,
	elvss_control_set_120,
	elvss_control_set_130,
	elvss_control_set_140,
	elvss_control_set_150,
	elvss_control_set_160,
	elvss_control_set_170,
	elvss_control_set_180,
	elvss_control_set_190,
	elvss_control_set_200,
	elvss_control_set_210,
	elvss_control_set_220,
	elvss_control_set_230,
	elvss_control_set_240,
	elvss_control_set_250,
	elvss_control_set_300
};


enum {
	ACL_STATUS_0P = 0,
	ACL_STATUS_33P,
	ACL_STATUS_40P,
	ACL_STATUS_50P,
	ACL_STATUS_MAX
};

static const unsigned char SEQ_ACL_OFF[] = {
	0x55, 0x00,
	0x00
};

static const unsigned char acl_cutoff_33[] = {
	0x55, 0x01,
	0x00
};

static const unsigned char acl_cutoff_40[] = {
	0x55, 0x02,
	0x00
};

static const unsigned char acl_cutoff_50[] = {
	0x55, 0x03,
	0x00
};

static const unsigned char *ACL_CUTOFF_TABLE[ACL_STATUS_MAX] = {
	SEQ_ACL_OFF,
	acl_cutoff_33,
	acl_cutoff_40,
	acl_cutoff_50,
};
#endif /* __EA8061_PARAM_H__ */
