/* linux/drivers/video/backlight/s6e8aa0_brightness.h
 *
 * Brightness level definition.
 *
 * Copyright (c) 2011 Samsung Electronics
 *
 * Inki Dae, <inki.dae@samsung.com>
 * Donghwa Lee <dh09.lee@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef _S6E8AA0_BRIGHTNESS_H
#define _S6E8AA0_BRIGHTNESS_H

#define MAX_GAMMA_LEVEL		25
#define GAMMA_TABLE_COUNT	26

/* gamma value: 2.2 */
static const unsigned char s6e8aa0_22_gamma_30[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF, 0xDF, 0x1F,
	0xD7, 0xDC, 0xB7, 0xE1,	0xC0, 0xAF, 0xC4, 0xD2, 0xD0, 0xCF,
	0x00, 0x4D, 0x00, 0x40, 0x00, 0x5F,
};

static const unsigned char s6e8aa0_22_gamma_40[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF,	0xD5, 0x35,
	0xCF, 0xDC, 0xC1, 0xE1,	0xBF, 0xB3, 0xC1, 0xD2, 0xD1, 0xCE,
	0x00, 0x53, 0x00, 0x46, 0x00, 0x67,

};

static const unsigned char s6e8aa0_22_gamma_50[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF,	0xD2, 0x64,
	0xCF, 0xDB, 0xC6, 0xE1,	0xBD, 0xB3, 0xBD, 0xD2, 0xD2, 0xCE,
	0x00, 0x59, 0x00, 0x4B, 0x00, 0x6E,
};

static const unsigned char s6e8aa0_22_gamma_60[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF,	0xD0, 0x7C,
	0xCF, 0xDB, 0xC9, 0xE0,	0xBC, 0xB4, 0xBB, 0xCF, 0xD1, 0xCC,
	0x00, 0x5F, 0x00, 0x50, 0x00, 0x75,
};

static const unsigned char s6e8aa0_22_gamma_70[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF,	0xD0, 0x8E,
	0xD1, 0xDB, 0xCC, 0xDF,	0xBB, 0xB6, 0xB9, 0xD0, 0xD1, 0xCD,
	0x00, 0x63, 0x00, 0x54, 0x00, 0x7A,
};

static const unsigned char s6e8aa0_22_gamma_80[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF,	0xD1, 0x9E,
	0xD5, 0xDA, 0xCD, 0xDD,	0xBB, 0xB7, 0xB9, 0xCE, 0xCE, 0xC9,
	0x00, 0x68, 0x00, 0x59, 0x00, 0x81,
};

static const unsigned char s6e8aa0_22_gamma_90[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF,	0xD0, 0xA5,
	0xD6, 0xDA, 0xCF, 0xDD,	0xBB, 0xB7, 0xB8, 0xCC, 0xCD, 0xC7,
	0x00, 0x6C, 0x00, 0x5C, 0x00, 0x86,
};

static const unsigned char s6e8aa0_22_gamma_100[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x00, 0xFF,	0xCF, 0xA7,
	0xD6, 0xDA, 0xD0, 0xDC,	0xB8, 0xB6, 0xB5, 0xCB, 0xCC, 0xC6,
	0x00, 0x71, 0x00, 0x60, 0x00, 0x8C,
};

static const unsigned char s6e8aa0_22_gamma_110[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x1F, 0xFE,	0xD0, 0xAE,
	0xD7, 0xD9, 0xD0, 0xDB,	0xB9, 0xB6, 0xB5, 0xCA, 0xCC, 0xC5,
	0x00, 0x74, 0x00, 0x63, 0x00, 0x90,
};

static const unsigned char s6e8aa0_22_gamma_120[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x1F, 0xF9,	0xCF, 0xB0,
	0xD6, 0xD9, 0xD1, 0xDB,	0xB9, 0xB6, 0xB4, 0xCA, 0xCB, 0xC5,
	0x00, 0x77, 0x00, 0x66, 0x00, 0x94,
};

static const unsigned char s6e8aa0_22_gamma_130[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFF, 0x1F, 0xF7,	0xCF, 0xB3,
	0xD7, 0xD8, 0xD1, 0xD9,	0xB7, 0xB6, 0xB3, 0xC9, 0xCA, 0xC3,
	0x00, 0x7B, 0x00, 0x69, 0x00, 0x99,
};

static const unsigned char s6e8aa0_22_gamma_140[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFD, 0x2F, 0xF7,	0xDF, 0xB5,
	0xD6, 0xD8, 0xD1, 0xD8,	0xB6, 0xB5, 0xB2, 0xCA, 0xCB, 0xC4,
	0x00, 0x7E, 0x00, 0x6C, 0x00, 0x9D,
};

static const unsigned char s6e8aa0_22_gamma_150[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFB, 0x2F, 0xF5,	0xD0, 0xB7,
	0xD7, 0xD7, 0xD1, 0xD8,	0xB6, 0xB5, 0xB1, 0xC8, 0xCA, 0xC3,
	0x00, 0x81, 0x00, 0x6E, 0x00, 0xA0,
};

static const unsigned char s6e8aa0_22_gamma_160[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xFA, 0x2F, 0xF5,	0xCE, 0xB6,
	0xD5, 0xD7, 0xD2, 0xD8,	0xB6, 0xB4, 0xB0, 0xC7, 0xC9, 0xC1,
	0x00, 0x84, 0x00, 0x71, 0x00, 0xA5,
};

static const unsigned char s6e8aa0_22_gamma_170[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xF7, 0x2F, 0xF2,	0xCE, 0xB9,
	0xD5, 0xD8, 0xD2, 0xD8,	0xB4, 0xB4, 0xAF, 0xC7, 0xC9, 0xC1,
	0x00, 0x87, 0x00, 0x73, 0x00, 0xA8,
};

static const unsigned char s6e8aa0_22_gamma_180[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xF5, 0x2F, 0xF0,	0xDF, 0xBA,
	0xD5, 0xD7, 0xD2, 0xD7,	0xB4, 0xB4, 0xAF, 0xC5, 0xC7, 0xBF,
	0x00, 0x8A, 0x00, 0x76, 0x00, 0xAC,
};

static const unsigned char s6e8aa0_22_gamma_190[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xF2, 0x2F, 0xED,	0xCE, 0xBB,
	0xD4, 0xD6, 0xD2, 0xD6,	0xB5, 0xB4, 0xAF, 0xC5, 0xC7, 0xBF,
	0x00, 0x8c, 0x00, 0x78, 0x00, 0xAF,
};

static const unsigned char s6e8aa0_22_gamma_200[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xF2, 0x2F, 0xED,	0xCE, 0xBB,
	0xD4, 0xD7, 0xD3, 0xD6,	0xB3, 0xB3, 0xAE, 0xC6, 0xC7, 0xBF,
	0x00, 0x8E, 0x00, 0x7A, 0x00, 0xB2,
};

static const unsigned char s6e8aa0_22_gamma_210[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEF, 0x2F, 0xEB,	0xCD, 0xBB,
	0xD2, 0xD7, 0xD3, 0xD6,	0xB3, 0xB4, 0xAE, 0xC5, 0xC6, 0xBE,
	0x00, 0x91, 0x00, 0x7D, 0x00, 0xB6,
};

static const unsigned char s6e8aa0_22_gamma_220[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEE, 0x2F, 0xEA,	0xCE, 0xBD,
	0xD4, 0xD6, 0xD2, 0xD5,	0xB2, 0xB3, 0xAD, 0xC3, 0xC4, 0xBB,
	0x00, 0x94, 0x00, 0x7F, 0x00, 0xBA,
};

static const unsigned char s6e8aa0_22_gamma_230[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEC, 0x2F, 0xE8,	0xCE, 0xBE,
	0xD3, 0xD6, 0xD3, 0xD5,	0xB2, 0xB2, 0xAC, 0xC3, 0xC5, 0xBC,
	0x00, 0x96, 0x00, 0x81, 0x00, 0xBD,
};

static const unsigned char s6e8aa0_22_gamma_240[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEB, 0x2F, 0xE7,	0xCE, 0xBF,
	0xD3, 0xD6, 0xD2, 0xD5,	0xB1, 0xB2, 0xAB, 0xC2, 0xC4, 0xBB,
	0x00, 0x99, 0x00, 0x83, 0x00, 0xC0,
};

static const unsigned char s6e8aa0_22_gamma_250[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEF, 0x5F, 0xE9,	0xCA, 0xBF,
	0xD3, 0xD5, 0xD2, 0xD4,	0xB2, 0xB2, 0xAB, 0xC1, 0xC4, 0xBA,
	0x00, 0x9B, 0x00, 0x85, 0x00, 0xC3,
};

static const unsigned char s6e8aa0_22_gamma_260[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEA, 0x5F, 0xE8,	0xCE, 0xBF,
	0xD2, 0xD5, 0xD2, 0xD4,	0xB1, 0xB2, 0xAB, 0xC1, 0xC2, 0xB9,
	0x00, 0x9D, 0x00, 0x87, 0x00, 0xC6,
};

static const unsigned char s6e8aa0_22_gamma_270[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xE9, 0x5F, 0xE7,	0xCD, 0xBF,
	0xD2, 0xD6, 0xD2, 0xD4,	0xB1, 0xB2, 0xAB, 0xBE, 0xC0, 0xB7,
	0x00, 0xA1, 0x00, 0x8A, 0x00, 0xCA,
};

static const unsigned char s6e8aa0_22_gamma_280[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xE8, 0x61, 0xE6,	0xCD, 0xBF,
	0xD1, 0xD6, 0xD3, 0xD4,	0xAF, 0xB0, 0xA9, 0xBE, 0xC1, 0xB7,
	0x00, 0xA3, 0x00, 0x8B, 0x00, 0xCE,
};

static const unsigned char s6e8aa0_22_gamma_290[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xE8, 0x62, 0xE5,	0xCC, 0xC0,
	0xD0, 0xD6, 0xD2, 0xD4,	0xAF, 0xB1, 0xA9, 0xBD, 0xC0, 0xB6,
	0x00, 0xA5, 0x00, 0x8D, 0x00, 0xD0,

};

static const unsigned char s6e8aa0_22_gamma_300[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xE7, 0x7F, 0xE3,	0xCC, 0xC1,
	0xD0, 0xD5, 0xD3, 0xD3,	0xAE, 0xAF, 0xA8, 0xBE, 0xC0, 0xB7,
	0x00, 0xA8, 0x00, 0x90, 0x00, 0xD3,
};

static const unsigned char *s6e8aa0_22_gamma_table[MAX_GAMMA_LEVEL] = {
	s6e8aa0_22_gamma_30,
	s6e8aa0_22_gamma_50,
	s6e8aa0_22_gamma_60,
	s6e8aa0_22_gamma_70,
	s6e8aa0_22_gamma_80,
	s6e8aa0_22_gamma_90,
	s6e8aa0_22_gamma_100,
	s6e8aa0_22_gamma_110,
	s6e8aa0_22_gamma_120,
	s6e8aa0_22_gamma_130,
	s6e8aa0_22_gamma_140,
	s6e8aa0_22_gamma_150,
	s6e8aa0_22_gamma_160,
	s6e8aa0_22_gamma_170,
	s6e8aa0_22_gamma_180,
	s6e8aa0_22_gamma_190,
	s6e8aa0_22_gamma_200,
	s6e8aa0_22_gamma_210,
	s6e8aa0_22_gamma_220,
	s6e8aa0_22_gamma_230,
	s6e8aa0_22_gamma_240,
	s6e8aa0_22_gamma_270,
	s6e8aa0_22_gamma_280,
	s6e8aa0_22_gamma_290,
	s6e8aa0_22_gamma_300,
};

#endif
