/* linux/drivers/video/backlight/s6e8aa0_brightness.h
 *
 * Brightness level definition.
 *
 * Copyright (c) 2011 Samsung Electronics
 *
 * Inki Dae, <inki.dae@samsung.com>
 * Donghwa Lee <dh09.lee@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef _S6E39A0X02_BRIGHTNESS_H
#define _S6E39A0X02_BRIGHTNESS_H

#define MAX_GAMMA_LEVEL		11
#define GAMMA_TABLE_COUNT	26

/* gamma value: 2.2 */
static const unsigned char s6e39a0x02_22_gamma_70[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xD1, 0x34, 0xD0,	0xD6, 0xBA,
	0xDC, 0xE0, 0xD9, 0xE2,	0xC2, 0xC0, 0xBF, 0xD4, 0xD5, 0xD0,
	0x00, 0x73, 0x00, 0x59, 0x00, 0x82
};

static const unsigned char s6e39a0x02_22_gamma_80[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xD7, 0x39, 0xD6,	0xD6, 0xBF,
	0xDD, 0xE1, 0xDA, 0xE2,	0xC0, 0xBF, 0xBD, 0xD3, 0xD5, 0xCF,
	0x00, 0x78, 0x00, 0x5D, 0x00, 0x88
};

static const unsigned char s6e39a0x02_22_gamma_90[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xD7, 0x39, 0xD5,	0xD5, 0xBF,
	0xDC, 0xDF, 0xDA, 0xE0,	0xC1, 0xC0, 0xBD, 0xD2, 0xD4, 0xCF,
	0x00, 0x7C, 0x00, 0x60, 0x00, 0x8C
};

static const unsigned char s6e39a0x02_22_gamma_100[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xDD, 0x3A, 0xE3,	0xD7, 0xC5,
	0xDD, 0xDF, 0xDA, 0xDF,	0xC0, 0xBF, 0xBC, 0xD0, 0xD3, 0xCD,
	0x00, 0x81, 0x00, 0x64, 0x00, 0x92
};

static const unsigned char s6e39a0x02_22_gamma_110[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xE1, 0x43, 0xE2,	0xD6, 0xC5,
	0xDC, 0xDE, 0xDA, 0xDF,	0xBF, 0xBF, 0xBB, 0xD0, 0xD3, 0xCD,
	0x00, 0x85, 0x00, 0x67, 0x00, 0x96
};

static const unsigned char s6e39a0x02_22_gamma_120[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xE5, 0x48, 0xE4,	0xD5, 0xC5,
	0xDB, 0xDE, 0xDA, 0xDD,	0xBE, 0xBF, 0xBB, 0xD0, 0xD2, 0xCC,
	0x00, 0x88, 0x00, 0x6A, 0x00, 0x9A
};

static const unsigned char s6e39a0x02_22_gamma_130[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xE6, 0x4D, 0xE3,	0xD5, 0xC5,
	0xDA, 0xDD, 0xDA, 0xDD,	0xBE, 0xBE, 0xBA, 0xCE, 0xD1, 0xCA,
	0x00, 0x8C, 0x00, 0x6D, 0x00, 0x9F
};

static const unsigned char s6e39a0x02_22_gamma_140[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xE8, 0x51, 0xE4,	0xD6, 0xC9,
	0xDB, 0xDC, 0xD9, 0xDC,	0xBE, 0xBF, 0xBA, 0xCD, 0xD0, 0xC9,
	0x00, 0x90, 0x00, 0x70, 0x00, 0xA3
};

static const unsigned char s6e39a0x02_22_gamma_150[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xEA, 0x57, 0xE9,	0xD6, 0xC9,
	0xDA, 0xDD, 0xDA, 0xDC,	0xBC, 0xBE, 0xB8, 0xCE, 0xD0, 0xCA,
	0x00, 0x92, 0x00, 0x72, 0x00, 0xA6
};

static const unsigned char s6e39a0x02_22_gamma_160[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xF0, 0x61, 0xEE,	0xD5, 0xC9,
	0xD9, 0xDD, 0xDA, 0xDB,	0xBC, 0xBE, 0xB9, 0xCC, 0xCF, 0xC8,
	0x00, 0x96, 0x00, 0x75, 0x00, 0xAA
};

static const unsigned char s6e39a0x02_22_gamma_170[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xF1, 0x81, 0xEE,	0xD4, 0xC9,
	0xD9, 0xDD, 0xDB, 0xDB,	0xBB, 0xBD, 0xB7, 0xCC, 0xCE, 0xC8,
	0x00, 0x99, 0x00, 0x78, 0x00, 0xAE
};

static const unsigned char s6e39a0x02_22_gamma_180[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xF0, 0x8C, 0xED,	0xD5, 0xCA,
	0xD8, 0xDC, 0xDB, 0xDC,	0xBB, 0xBD, 0xB7, 0xCB, 0xCD, 0xC5,
	0x00, 0x9C, 0x00, 0x7A, 0x00, 0xB2
};

static const unsigned char s6e39a0x02_22_gamma_190[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xED, 0x90, 0xEC,	0xD4, 0xC9,
	0xD7, 0xDD, 0xDB, 0xDB,	0xBA, 0xBD, 0xB7, 0xCA, 0xCD, 0xC5,
	0x00, 0x9F, 0x00, 0x7C, 0x00, 0xB5
};

static const unsigned char s6e39a0x02_22_gamma_200[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xED, 0x8F, 0xED,	0xD2, 0xC7,
	0xD5, 0xDC, 0xDA, 0xDA,	0xBA, 0xBB, 0xB5, 0xCA, 0xCC, 0xC4,
	0x00, 0xA0, 0x00, 0x7F, 0x00, 0xBB
};

static const unsigned char s6e39a0x02_22_gamma_210[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xEF, 0x96, 0xEF,	0xD1, 0xC7,
	0xD3, 0xDB, 0xD9, 0xD9,	0xB9, 0xBB, 0xB4, 0xCA, 0xCC, 0xC6,
	0x00, 0xA3, 0x00, 0x81, 0x00, 0xBD
};

static const unsigned char s6e39a0x02_22_gamma_220[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xED, 0x99, 0xEE,	0xD3, 0xC8,
	0xD3, 0xDB, 0xD9, 0xD9,	0xB8, 0xBB, 0xB4, 0xC9, 0xCC, 0xC4,
	0x00, 0xA6, 0x00, 0x83, 0x00, 0xC1
};

static const unsigned char s6e39a0x02_22_gamma_230[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xEE, 0xA3, 0xEF,	0xD2, 0xC9,
	0xD3, 0xDB, 0xD9, 0xD9,	0xB9, 0xBA, 0xB3, 0xC8, 0xCC, 0xC4,
	0x00, 0xA8, 0x00, 0x85, 0x00, 0xC4
};

static const unsigned char s6e39a0x02_22_gamma_240[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xED, 0xA4, 0xEE,	0xD2, 0xC9,
	0xD3, 0xDC, 0xD9, 0xD9,	0xB7, 0xBA, 0xB3, 0xC8, 0xCB, 0xC2,
	0x00, 0xAB, 0x00, 0x87, 0x00, 0xC8
};

static const unsigned char s6e39a0x02_22_gamma_250[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xED, 0xA8, 0xEF,	0xD2, 0xC8,
	0xD2, 0xDA, 0xD9, 0xD8,	0xB7, 0xB9, 0xB2, 0xC8, 0xCB, 0xC2,
	0x00, 0xAD, 0x00, 0x89, 0x00, 0xCB
};

static const unsigned char s6e39a0x02_22_gamma_260[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xEB, 0xB2, 0xEF,	0xD2, 0xC9,
	0xD3, 0xDB, 0xDA, 0xD9,	0xB6, 0xB9, 0xBA, 0xC7, 0xCA, 0xC1,
	0x00, 0xB0, 0x00, 0x8B, 0x00, 0xCE
};

static const unsigned char s6e39a0x02_22_gamma_270[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xEC, 0xB0, 0xEF,	0xD1, 0xC9,
	0xD2, 0xDB, 0xDA, 0xD9,	0xB7, 0xB9, 0xB1, 0xC6, 0xC9, 0xC0,
	0x00, 0xB2, 0x00, 0x8D, 0x00, 0xD1
};

static const unsigned char s6e39a0x02_22_gamma_280[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xED, 0xB6, 0xF0,	0xD1, 0xC9,
	0xD2, 0xDB, 0xDA, 0xD9,	0xB6, 0xB8, 0xAF, 0xC7, 0xCA, 0xC2,
	0x00, 0xB4, 0x00, 0x8F, 0x00, 0xD3
};

static const unsigned char s6e39a0x02_22_gamma_290[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xEC, 0xB7, 0xEE,	0xD0, 0xC8,
	0xD1, 0xDB, 0xDA, 0xD9,	0xB6, 0xB8, 0xB0, 0xC5, 0xC9, 0xC1,
	0x00, 0xB7, 0x00, 0x91, 0x00, 0xD5
};

static const unsigned char s6e39a0x02_22_gamma_300[] = {
	0xFA, 0x02, 0x10, 0x10, 0x10, 0xEC, 0xB7, 0xEF,	0xD1, 0xCA,
	0xD1, 0xDB, 0xDA, 0xD8,	0xB5, 0xB8, 0xB0, 0xC5, 0xC8, 0xBF,
	0x00, 0xB9, 0x00, 0x93, 0x00, 0xD9
};

static const unsigned char *s6e39a0x02_22_gamma_table[MAX_GAMMA_LEVEL] = {
	s6e39a0x02_22_gamma_70,
	s6e39a0x02_22_gamma_90,
	s6e39a0x02_22_gamma_110,
	s6e39a0x02_22_gamma_130,
	s6e39a0x02_22_gamma_150,
	s6e39a0x02_22_gamma_170,
	s6e39a0x02_22_gamma_190,
	s6e39a0x02_22_gamma_210,
	s6e39a0x02_22_gamma_240,
	s6e39a0x02_22_gamma_270,
	s6e39a0x02_22_gamma_300,
};

#endif
