/* linux/drivers/video/backlight/ea8061_gamma.h
 *
 * Brightness level definition.
 *
 * Copyright (c) 2012 Samsung Electronics
 *
 * Joongmock Shin <jmock.shin@samsung.com>
 * Eunchul Kim <chulspro.kim@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef _EA8061_GAMMA_H
#define _EA8061_GAMMA_H

#define MAX_GAMMA_LEVEL		25
#define GAMMA_TABLE_COUNT	26

static const unsigned char ea8061_gamma22_20[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_30[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_40[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_50[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_60[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_70[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEA, 0xC9, 0xEA, 0xD6,
	0xD2, 0xD2, 0xDF, 0xE1, 0xE3, 0xC2, 0xC1, 0xC0, 0xD1,
	0xD0, 0xCE, 0x00, 0x84, 0x00, 0x84, 0x00, 0x96
};

static const unsigned char ea8061_gamma22_80[] = {
	0xFA, 0x01, 0x1F, 0x1F, 0x1F, 0xEB, 0xCC, 0xE9, 0xD5,
	0xD4, 0xD3, 0xDE, 0xE1, 0xE2, 0xC2, 0xBF, 0xBF, 0xCF,
	0xCF, 0xCC, 0x00, 0x89, 0x00, 0x89, 0x00, 0x9C
};

static const unsigned char ea8061_gamma22_90[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_100[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_110[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_120[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_130[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_140[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_150[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_160[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_170[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_180[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_190[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_200[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_210[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_220[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_230[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_240[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_250[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_260[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_270[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_280[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_290[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char ea8061_gamma22_300[] = {
	0xCA, 0x00, 0xE8, 0x00, 0xF7, 0x01, 0x03, 0xDB, 0xDB,
	0xDC, 0xD9, 0xD8, 0xDA, 0xCB, 0xC8, 0xCB, 0xD4, 0xD3,
	0xD7, 0xE6, 0xE6, 0xEA, 0xE2, 0xE4, 0xE5, 0xCE, 0xC3,
	0xCF, 0xB9, 0x9D, 0xDE, 0x11, 0x00
};

static const unsigned char *ea8061_gamma22_table[MAX_GAMMA_LEVEL] = {
	ea8061_gamma22_30,
	ea8061_gamma22_50,
	ea8061_gamma22_60,
	ea8061_gamma22_70,
	ea8061_gamma22_80,
	ea8061_gamma22_90,
	ea8061_gamma22_100,
	ea8061_gamma22_110,
	ea8061_gamma22_120,
	ea8061_gamma22_130,
	ea8061_gamma22_140,
	ea8061_gamma22_150,
	ea8061_gamma22_160,
	ea8061_gamma22_170,
	ea8061_gamma22_180,
	ea8061_gamma22_190,
	ea8061_gamma22_200,
	ea8061_gamma22_210,
	ea8061_gamma22_220,
	ea8061_gamma22_230,
	ea8061_gamma22_240,
	ea8061_gamma22_270,
	ea8061_gamma22_280,
	ea8061_gamma22_290,
	ea8061_gamma22_300
};

#endif /* _EA8061_GAMMA_H */
