/* sr300pc20_regs.h
 *
 * Driver for sr300pc20 (3MP Camera) from siliconfile
 *
 * Copyright (C) 2010, SAMSUNG ELECTRONICS
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Change Date: 2012.06.28
 */

#ifndef __SR300PC20_REGS_H__
#define __SR300PC20_REGS_H__

/* PV 1st */

static const sr300pc20_regset_t SR300PC20_Init_Reg[] = {
	0x0300,
	0x01f1,
	0x01f1,
	0x01f3,
	0x01f1,
	0x027f, /*pad divility set*/
/*/////////////////////////////////////////*/
/* 0 Page PLL setting*/
/*/////////////////////////////////////////*/
	0x0300,
	0x0725, /*24/(5+1) = 4Mhz*/
	0x0860, /*4.333 x 96 x 1/4 = 104Mhz*/
	0x0982,
	0x07a5,
	0x07a5,
	0x09a2, /*clock divider enable*/
	0x0A01, /*MCU hardware reset*/
	0x0A00,
	0x0A01,
	0x0A00,
/*/////////////////////////////////////////*/
/* 20 Page OTP/ROM LSC download select setting*/
/*/////////////////////////////////////////*/
	0x0320,
	0x3a00,
	0x3b00,
	0x3c00,
/*/////////////////////////////////////////*/
/* 30 Page MCU reset and configration*/
/*/////////////////////////////////////////*/
	0x0330,
	0x3086,
	0x3100,
	0x320c,
	0xe000,
	0x1080, /* mcu reset high*/
	0x108a, /* mcu enable high*/
	0x1108, /* xdata memory reset high*/
	0x1100, /* xdata memory reset low*/
/*/////////////////////////////////////////*/
/* Copy OTP register to Xdata.*/
/*/////////////////////////////////////////*/
	0x0307, /* otp page*/
	0x1201, /* memory mux on(mcu)*/
/*108M*/
	0x4035, /* otp_cfg1 value is different by PLLMCLK*/
	0x470B, /* otp_cfg8 value is different by PLLMCLK*/
/*DPC reg in otp down to xdata*/
	0x2E00, /* OTP (DPC block) start addr h(OTP DPC -> xdata DPC)*/
	0x2F20, /* OTP (DPC block) start addr l*/
	0x3000, /* MCU (DPC block) sram addr h(OTP DPC -> xdata DPC)*/
	0x31D6, /* MCU (DPC block) sram addr l*/
	0x3200, /* Copy reg sram size h(DPC reg size)*/
	0x33FF, /* Copy reg sram size l*/
	0x1002, /* Copy mcu down set(OTP DPC -> xdata DPC)*/
	0x8C08, /*OTP DPC pos offset*/
	0x8F20,
	0x9200,
	0x9354, /*Full size normal No_flip case*/
	0x9400,
	0x9511, /*Full size normal No_flip case*/
	0x0300,
	0xff05, /*Delay 50ms*/
/* Color ratio reg in otp down to xdata*/
	0x0307, /* otp page*/
	0x2E03, /* OTP (ColorRatio block) start addr h(OTP ColorRatio->xdata ColorRatio)*/
	0x2F20, /* OTP (ColorRatio block) start addr l*/
	0x3020, /* MCU(ColorRatio block) sram addr h(OTP ColorRatio->xdata ColorRatio)*/
	0x31A6, /* MCU (ColorRatio block) sram addr l*/
	0x3201, /* Copy reg sram size h(MCU reg size)*/
	0x3300, /* Copy reg sram size l*/
	0x1002, /* Copy mcu down set(OTP ColorRatio -> xdata ColorRatio)*/
	0x0300,
	0xff05, /*Delay 50ms*/
	0x0307, /* otp page*/
	0x1200, /* memory mux off*/
	0x9800, /* dpc_mem_ctl1*/
	0x9701, /* otp_dpc_ctl1*/
/*/////////////////////////////////////////*/
/* 30 Page MCU reset, enable setting*/
/*/////////////////////////////////////////*/
	0x0330,
	0x100a, /* mcu on div 1/3, MCU=36Mhz*/
/*/////////////////////////////////////////*/
/* 0 Page*/
/*/////////////////////////////////////////*/
	0x0300,
	0x0B02, /*PLL lock time*/
	0x1000, /*Full*/
	0x1180, /*0 frame skip*/
	0x1380,
	0x1430,
	0x1503,
	0x1704, /*Parallel, MIPI : 04, JPEG : 0c*/
	0x2000, /*START Height*/
	0x2104,
	0x2200, /*START Width*/
	0x230a,
	0x2406, /*Height Size*/
	0x2500,
	0x2608, /*Widht Size*/
	0x2700,
	0x5001, /*HBLANK 2180 + 320 = 2500*/
	0x5140,
	0x5200, /*VBLANK >= 33*/
	0x5321,
/*BLC*/
	0x8002,
	0x8187,
	0x8228,
	0x8308,
	0x848c,
	0x850c,/*blc on*/
	0x8600,
	0x8700,
	0x8898,
	0x8910,
	0x8a80,
	0x8b00,
	0x8e80,
	0x8f0f,
	0x900f, /*BLC_TIME_TH_ON*/
	0x910f, /*BLC_TIME_TH_OFF*/
	0x92a0, /*BLC_AG_TH_ON*/
	0x9390, /*BLC_AG_TH_OFF*/
	0x96fe, /*BLC_OUT_TH*/
	0x97E0, /*BLC_OUT_TH*/
	0x9820,
	0xa182, /*odd_adj_out*/
	0xa283, /*odd_adj_in*/
	0xa387, /*odd_adj_dark*/
	0xa582, /*even_adj_out*/
	0xa683, /*even_adj_in*/
	0xa787, /*even_adj_dark*/
	0xbb20,
/*/////////////////////////////////////////*/
/* 2 Page*/
/*/////////////////////////////////////////*/
	0x0302,
	0x1a00, /*adaptive dcdc off*/
	0x2033,
	0x2101,
	0x2222,
	0x2330,
	0x2433,
	0x2777,
	0x31f0,
	0x3222,
	0x3342,
	0x3430,
	0x3500,
	0x3608,
	0x3740,
	0x4001,
	0x418a,
	0x4200,
	0x483C,
	0x4910,
	0x54c0,
	0x5540,
	0x5b00,
	0x7802,
	0x7936,
	0x7a02,
	0x7b3a,
	0xa001,
	0xa1c4,
	0xa202,
	0xa3de,
	0xa403,
	0xa53b,
	0xa608,
	0xa7ee,
	0xa800,
	0xa9cd,
	0xaa01,
	0xabba,
	0xac02,
	0xad8a,
	0xae05,
	0xaF96,
	0xb000,
	0xb176,
	0xb200,
	0xb3e6,
	0xb400,
	0xb52d,
	0xb601,
	0xb7b8,
	0xb800,
	0xb967,
	0xba00,
	0xbbe7,
	0xbc00,
	0xbd03,
	0xbe03,
	0xbF01,
	0xc000,
	0xc176,
	0xc200,
	0xc3e8,
	0xc400,
	0xc52d,
	0xc601,
	0xc7ba,
	0xc800,
	0xc967,
	0xca00,
	0xcbeb,
	0xcc00,
	0xcd03,
	0xce03,
	0xcf05,
/*DCDC*/
	0xd40f, /*DCDC_TIME_TH_ON*/
	0xd50f, /*DCDC_TIME_TH_OFF*/
	0xd6a8, /*DCDC_AG_TH_ON*/
	0xd7a0, /*DCDC_AG_TH_OFF*/
	0xEF65,
	0xF00c,
	0xF40a,
/*///////////////////////////////////////////*/
/* 3 Page*/
/*///////////////////////////////////////////*/
	0x0303,
	0x1000,
	0x11dc,
	0x1200,
	0x1382,
	0x1402,
	0x15d3,
	0x1602,
	0x17db,
	0x1801,
	0x1919,
	0x1a02,
	0x1b3c,
	0x1c01,
	0x1d19,
	0x1e02,
	0x1F3c,
	0x2001,
	0x2119,
	0x2201,
	0x234a,
	0x2401,
	0x2519,
	0x2601,
	0x274a,
	0x2801,
	0x2919,
	0x2a01,
	0x2b4b,
	0x2c01,
	0x2d19,
	0x2e01,
	0x2F4b,
	0x3000,
	0x3101,
	0x3205,
	0x33b1,
	0x3400,
	0x3501,
	0x3605,
	0x37b1,
	0x3800,
	0x3901,
	0x3a03,
	0x3b1d,
	0x3c00,
	0x3d01,
	0x3e03,
	0x3F05,
	0x4000,
	0x4104,
	0x4200,
	0x4344,
	0x4400,
	0x4502,
	0x4600,
	0x4773,
	0x4800,
	0x4906,
	0x4a00,
	0x4b42,
	0x4c00,
	0x4d06,
	0x4e00,
	0x4F42,
	0x5000,
	0x5108,
	0x5200,
	0x532d,
	0x5400,
	0x5508,
	0x5600,
	0x572d,
	0x5800,
	0x5908,
	0x5a00,
	0x5b2d,
	0x5c00,
	0x5d06,
	0x5e00,
	0x5F44,
	0x6800,
	0x6904,
	0x6a00,
	0x6b46,
	0x7000,
	0x71e8,
	0x7202,
	0x7338,
	0x7400,
	0x75ed,
	0x7601,
	0x7715,
	0x7802,
	0x7936,
	0x7a02,
	0x7b3a,
	0x7c02,
	0x7d36,
	0x7e02,
	0x7F3a,
	0x8001,
	0x81cc,
	0x8202,
	0x8312,
	0x8402,
	0x8536,
	0x8602,
	0x873a,
	0x8802,
	0x8936,
	0x8a02,
	0x8b3a,
	0x8c00,
	0x8dea,
	0x8e01,
	0x8F18,
	0x9000,
	0x91e8,
	0x9202,
	0x9332,
	0x9400,
	0x95e8,
	0x9602,
	0x9732,
	0x9802,
	0x9932,
	0x9a00,
	0x9be8,
	0x9c02,
	0x9d32,
	0x9e00,
	0x9Fe8,
	0xa000,
	0xa10a,
	0xa200,
	0xa306,
	0xa400,
	0xa50a,
	0xa600,
	0xa706,
	0xa800,
	0xa9F5,
	0xaa00,
	0xabe6,
	0xac00,
	0xadF5,
	0xae00,
	0xaFe6,
	0xc000,
	0xc148,
	0xc200,
	0xc36E,
	0xc400,
	0xc548,
	0xc600,
	0xc76E,
	0xc800,
	0xc94a,
	0xca00,
	0xcb6c,
	0xcc00,
	0xcd4a,
	0xce00,
	0xcF6c,
	0xd000,
	0xd14c,
	0xd200,
	0xd36a,
	0xd400,
	0xd54c,
	0xd600,
	0xd76a,
	0xd800,
	0xd94e,
	0xda00,
	0xdb68,
	0xdc00,
	0xdd4e,
	0xde00,
	0xdF68,
	0xe000,
	0xe1ed,
	0xe201,
	0xe354,
	0xe401,
	0xe568,
	0xe602,
	0xe759,
	0xe801,
	0xe917,
	0xea01,
	0xebc8,
	0xec00,
	0xeddd,
	0xee00,
	0xef00,
	0xf000,
	0xf134,
/*/////////////////////////////////////////*/
/* 10 Page*/
/*/////////////////////////////////////////*/
	0x0310,
	0x1001, /*YUV422-YUYV*/
	0x1230, /*Y,DY offset Enb*/
	0x130a, /*Bright2, Contrast Enb*/
	0x2080,
	0x410a, /*DY OFFSET*/
	0x50a0,
	0x6003, /*Sat, Trans Enb*/
/*Desat - Chroma*/
/*10 1.25, 20 1.30, 40 1.15*/
	0x700c,
	0x7100,
	0x727a,
	0x7328,
	0x7414,
	0x750d,
	0x7640,
	0x7749,
	0x7899,
	0x794c,
	0x7acc,
	0x7b49,
	0x7c99,
	0x7d14,
	0x7e28,
	0x7f50,
	0xe0ff, /*don't touch*/
	0xe13f, /*don't touch*/
	0xe2ff, /*don't touch*/
	0xe3ff, /*don't touch*/
	0xe4f7, /*don't touch*/
	0xe579, /*don't touch*/
	0xe6ce, /*don't touch*/
	0xe71f, /*don't touch*/
	0xe85f, /*don't touch*/
	0xf03f, /*don't touch*/
/*/////////////////////////////////////////*/
/* 11 page D-LPF*/
/*/////////////////////////////////////////*/
/*LPF*/
	0x0311,
	0x1013, /*DLPF*/
	0xf040, /*lpf_auto_ctl1*/
	0xf26e, /*LPF_AG_TH_ON*/
	0xf364, /*LPF_AG_TH_OFF*/
	0xf4fe, /*lpf_out_th_h*/
	0xf5fd, /*lpf_out_th_lo*/
	0xf600, /*lpf_ymean_th_hi*/
	0xf700, /*lpf_ymean_th_lo*/
/*/////////////////////////////////////////*/
/* 12 page DPC / GBGR /LensDebulr*/
/*/////////////////////////////////////////*/
	0x0312,
	0x1208,
	0x2b08, /*white*/
	0x2c08, /*mid_high*/
	0x2d08, /*mid_low*/
	0x2e06, /*dark*/
	0x3309,
	0x3503,
	0x360f,
	0x370d,
	0x3802,
	0x6021,
	0x610e,
	0x6270,
	0x6370,
	0x6501,
	0xE158,
	0xEC32,
	0xEE03,
/*/////////////////////////////////////////*/
/* 13 page YC2D LPF*/
/*/////////////////////////////////////////*/
	0x0313,
	0x1033, /*Don't touch*/
	0xa00f, /*Don't touch*/
	0xe107,
/*/////////////////////////////////////////*/
/* 14 page Sharpness*/
/*/////////////////////////////////////////*/
	0x0314,
	0x1027, /*Don't touch*/
	0x1102, /*Don't touch*/
	0x1240, /*Don't touch*/
	0x2082, /*Don't touch*/
	0x3082, /*Don't touch*/
	0x4084, /*Don't touch*/
	0x5084, /*Don't touch*/
	0x0300,
	0xff01, /*Delay 10ms*/
/*/////////////////////////////////////////*/
/* 15 Page LSC off*/
/*/////////////////////////////////////////*/
	0x0315,
	0x1082,
	0x0307,
	0x1204,
	0x3400,
	0x3500,
	0x1385,
	0x1305,
	0x374d,
	0x374f,
	0x374c,
	0x3747,
	0x3741,
	0x373c,
	0x3738,
	0x3735,
	0x3733,
	0x3733,
	0x3735,
	0x3739,
	0x373e,
	0x3743,
	0x3748,
	0x374e,
	0x3752,
	0x3750,
	0x374e,
	0x374c,
	0x3747,
	0x3741,
	0x373b,
	0x3734,
	0x3730,
	0x372c,
	0x372a,
	0x372a,
	0x372c,
	0x3730,
	0x3736,
	0x373c,
	0x3743,
	0x3749,
	0x374f,
	0x3752,
	0x3749,
	0x3745,
	0x373f,
	0x3738,
	0x3730,
	0x3729,
	0x3723,
	0x3720,
	0x371d,
	0x371d,
	0x371f,
	0x3723,
	0x372a,
	0x3731,
	0x3739,
	0x3741,
	0x3749,
	0x374f,
	0x3746,
	0x3741,
	0x3739,
	0x3731,
	0x3728,
	0x3720,
	0x371a,
	0x3715,
	0x3713,
	0x3713,
	0x3715,
	0x3719,
	0x3720,
	0x3728,
	0x3731,
	0x373b,
	0x3744,
	0x374b,
	0x3741,
	0x373b,
	0x3733,
	0x3729,
	0x3720,
	0x3717,
	0x3711,
	0x370d,
	0x370a,
	0x370a,
	0x370c,
	0x3710,
	0x3716,
	0x371f,
	0x372a,
	0x3735,
	0x373f,
	0x3748,
	0x373e,
	0x3737,
	0x372e,
	0x3723,
	0x371a,
	0x3711,
	0x370b,
	0x3706,
	0x3704,
	0x3704,
	0x3705,
	0x3709,
	0x3710,
	0x3719,
	0x3723,
	0x372f,
	0x373b,
	0x3744,
	0x373c,
	0x3735,
	0x372c,
	0x3721,
	0x3716,
	0x370e,
	0x3707,
	0x3703,
	0x3700,
	0x3700,
	0x3702,
	0x3706,
	0x370c,
	0x3715,
	0x3720,
	0x372d,
	0x3739,
	0x3743,
	0x373b,
	0x3734,
	0x372a,
	0x371f,
	0x3715,
	0x370c,
	0x3706,
	0x3701,
	0x3700,
	0x3700,
	0x3700,
	0x3705,
	0x370b,
	0x3714,
	0x371f,
	0x372b,
	0x3738,
	0x3741,
	0x373c,
	0x3735,
	0x372b,
	0x3720,
	0x3716,
	0x370d,
	0x3707,
	0x3703,
	0x3700,
	0x3700,
	0x3702,
	0x3706,
	0x370d,
	0x3715,
	0x3720,
	0x372c,
	0x3739,
	0x3742,
	0x373e,
	0x3738,
	0x372f,
	0x3724,
	0x371a,
	0x3712,
	0x370b,
	0x3707,
	0x3705,
	0x3704,
	0x3706,
	0x370a,
	0x3711,
	0x371a,
	0x3725,
	0x3731,
	0x373c,
	0x3745,
	0x3740,
	0x373a,
	0x3733,
	0x3729,
	0x3720,
	0x3717,
	0x3711,
	0x370d,
	0x370b,
	0x370b,
	0x370c,
	0x3711,
	0x3718,
	0x3720,
	0x372a,
	0x3735,
	0x373f,
	0x3747,
	0x3743,
	0x373e,
	0x3738,
	0x3730,
	0x3727,
	0x371f,
	0x371a,
	0x3716,
	0x3714,
	0x3713,
	0x3715,
	0x371a,
	0x3720,
	0x3729,
	0x3732,
	0x373b,
	0x3744,
	0x374a,
	0x3746,
	0x3743,
	0x373d,
	0x3737,
	0x372f,
	0x3729,
	0x3724,
	0x3720,
	0x371e,
	0x371e,
	0x3720,
	0x3725,
	0x372b,
	0x3732,
	0x373a,
	0x3741,
	0x3748,
	0x374d,
	0x3746,
	0x3745,
	0x3741,
	0x373c,
	0x3736,
	0x3730,
	0x372c,
	0x3728,
	0x3727,
	0x3727,
	0x3729,
	0x372d,
	0x3732,
	0x3738,
	0x373f,
	0x3745,
	0x374b,
	0x374e,
	0x3757,
	0x375a,
	0x3755,
	0x374f,
	0x3748,
	0x3742,
	0x373d,
	0x3739,
	0x3738,
	0x3737,
	0x3739,
	0x373c,
	0x3741,
	0x3746,
	0x374b,
	0x3750,
	0x3754,
	0x3753,
	0x3757,
	0x3755,
	0x374f,
	0x3748,
	0x3741,
	0x3739,
	0x3733,
	0x372f,
	0x372c,
	0x372c,
	0x372e,
	0x3732,
	0x3737,
	0x373e,
	0x3744,
	0x374b,
	0x3750,
	0x3754,
	0x3752,
	0x374d,
	0x3746,
	0x373d,
	0x3735,
	0x372c,
	0x3725,
	0x3721,
	0x371e,
	0x371e,
	0x3720,
	0x3724,
	0x372a,
	0x3732,
	0x373a,
	0x3742,
	0x3749,
	0x374e,
	0x374c,
	0x3748,
	0x373f,
	0x3735,
	0x372b,
	0x3722,
	0x371b,
	0x3715,
	0x3713,
	0x3713,
	0x3714,
	0x3719,
	0x3720,
	0x3728,
	0x3732,
	0x373b,
	0x3744,
	0x374a,
	0x3748,
	0x3742,
	0x3738,
	0x372d,
	0x3722,
	0x3719,
	0x3711,
	0x370c,
	0x370a,
	0x3709,
	0x370b,
	0x370f,
	0x3716,
	0x371f,
	0x3729,
	0x3734,
	0x373f,
	0x3746,
	0x3744,
	0x373d,
	0x3733,
	0x3727,
	0x371c,
	0x3712,
	0x370b,
	0x3706,
	0x3703,
	0x3703,
	0x3705,
	0x3709,
	0x370f,
	0x3719,
	0x3724,
	0x372f,
	0x373b,
	0x3743,
	0x3743,
	0x373c,
	0x3731,
	0x3724,
	0x3719,
	0x370f,
	0x3707,
	0x3703,
	0x3700,
	0x3700,
	0x3701,
	0x3706,
	0x370c,
	0x3715,
	0x3721,
	0x372d,
	0x3739,
	0x3742,
	0x3741,
	0x373a,
	0x372f,
	0x3723,
	0x3717,
	0x370d,
	0x3706,
	0x3701,
	0x3700,
	0x3700,
	0x3700,
	0x3704,
	0x370b,
	0x3714,
	0x371f,
	0x372b,
	0x3737,
	0x3740,
	0x3742,
	0x373b,
	0x3730,
	0x3724,
	0x3718,
	0x370e,
	0x3707,
	0x3702,
	0x3700,
	0x3700,
	0x3701,
	0x3705,
	0x370c,
	0x3715,
	0x3720,
	0x372c,
	0x3738,
	0x3740,
	0x3744,
	0x373d,
	0x3733,
	0x3728,
	0x371d,
	0x3713,
	0x370b,
	0x3706,
	0x3704,
	0x3704,
	0x3705,
	0x370a,
	0x3710,
	0x371a,
	0x3724,
	0x3730,
	0x373b,
	0x3742,
	0x3747,
	0x3740,
	0x3738,
	0x372d,
	0x3722,
	0x3719,
	0x3711,
	0x370c,
	0x370a,
	0x370a,
	0x370b,
	0x3710,
	0x3716,
	0x3720,
	0x372a,
	0x3734,
	0x373e,
	0x3744,
	0x374a,
	0x3745,
	0x373d,
	0x3734,
	0x372a,
	0x3721,
	0x371b,
	0x3716,
	0x3713,
	0x3713,
	0x3715,
	0x3719,
	0x3720,
	0x3728,
	0x3732,
	0x373b,
	0x3743,
	0x3748,
	0x374f,
	0x374b,
	0x3744,
	0x373c,
	0x3733,
	0x372c,
	0x3725,
	0x3721,
	0x371f,
	0x371f,
	0x3721,
	0x3725,
	0x372a,
	0x3732,
	0x373a,
	0x3741,
	0x3748,
	0x374d,
	0x374f,
	0x374d,
	0x3747,
	0x3742,
	0x373b,
	0x3734,
	0x372e,
	0x372b,
	0x3729,
	0x3729,
	0x372a,
	0x372e,
	0x3733,
	0x3739,
	0x3740,
	0x3746,
	0x374b,
	0x374e,
	0x3740,
	0x3743,
	0x3742,
	0x373d,
	0x3739,
	0x3734,
	0x3730,
	0x372c,
	0x372b,
	0x372b,
	0x372d,
	0x3730,
	0x3734,
	0x3739,
	0x373d,
	0x3740,
	0x3742,
	0x3740,
	0x3740,
	0x3740,
	0x373d,
	0x3738,
	0x3732,
	0x372c,
	0x3727,
	0x3724,
	0x3722,
	0x3722,
	0x3724,
	0x3727,
	0x372c,
	0x3731,
	0x3737,
	0x373b,
	0x373f,
	0x3742,
	0x373b,
	0x3739,
	0x3736,
	0x3730,
	0x3728,
	0x3722,
	0x371d,
	0x3719,
	0x3717,
	0x3717,
	0x3719,
	0x371c,
	0x3721,
	0x3728,
	0x372e,
	0x3734,
	0x373a,
	0x373f,
	0x3737,
	0x3734,
	0x3730,
	0x3729,
	0x3721,
	0x371a,
	0x3715,
	0x3711,
	0x370e,
	0x370e,
	0x3710,
	0x3714,
	0x3719,
	0x3720,
	0x3727,
	0x372f,
	0x3736,
	0x373c,
	0x3733,
	0x372f,
	0x372a,
	0x3722,
	0x371a,
	0x3713,
	0x370d,
	0x3709,
	0x3707,
	0x3707,
	0x3709,
	0x370c,
	0x3712,
	0x3719,
	0x3721,
	0x3729,
	0x3731,
	0x3739,
	0x3730,
	0x372b,
	0x3725,
	0x371d,
	0x3715,
	0x370e,
	0x3708,
	0x3704,
	0x3702,
	0x3702,
	0x3704,
	0x3707,
	0x370d,
	0x3714,
	0x371c,
	0x3725,
	0x372e,
	0x3736,
	0x372f,
	0x372a,
	0x3723,
	0x371b,
	0x3712,
	0x370b,
	0x3705,
	0x3702,
	0x3700,
	0x3700,
	0x3701,
	0x3705,
	0x370a,
	0x3711,
	0x371a,
	0x3723,
	0x372d,
	0x3735,
	0x372e,
	0x3729,
	0x3722,
	0x371a,
	0x3711,
	0x3709,
	0x3704,
	0x3701,
	0x3700,
	0x3700,
	0x3701,
	0x3704,
	0x3709,
	0x3710,
	0x3719,
	0x3722,
	0x372c,
	0x3735,
	0x372f,
	0x372a,
	0x3723,
	0x371a,
	0x3712,
	0x370a,
	0x3705,
	0x3702,
	0x3700,
	0x3700,
	0x3702,
	0x3705,
	0x370a,
	0x3712,
	0x371a,
	0x3724,
	0x372d,
	0x3735,
	0x3731,
	0x372d,
	0x3726,
	0x371e,
	0x3715,
	0x370e,
	0x3709,
	0x3705,
	0x3703,
	0x3703,
	0x3705,
	0x3709,
	0x370e,
	0x3716,
	0x371e,
	0x3727,
	0x3730,
	0x3737,
	0x3734,
	0x3730,
	0x372a,
	0x3722,
	0x371a,
	0x3713,
	0x370d,
	0x370a,
	0x3708,
	0x3708,
	0x370a,
	0x370e,
	0x3714,
	0x371b,
	0x3723,
	0x372b,
	0x3733,
	0x3739,
	0x3737,
	0x3734,
	0x372f,
	0x3728,
	0x3720,
	0x371a,
	0x3714,
	0x3711,
	0x370f,
	0x370f,
	0x3711,
	0x3715,
	0x371b,
	0x3722,
	0x3729,
	0x3731,
	0x3737,
	0x373c,
	0x373a,
	0x3738,
	0x3734,
	0x372e,
	0x3727,
	0x3721,
	0x371c,
	0x3719,
	0x3717,
	0x3717,
	0x3719,
	0x371d,
	0x3722,
	0x3728,
	0x372f,
	0x3735,
	0x373a,
	0x373f,
	0x373b,
	0x373a,
	0x3737,
	0x3733,
	0x372d,
	0x3727,
	0x3722,
	0x371f,
	0x371d,
	0x371d,
	0x3720,
	0x3723,
	0x3728,
	0x372d,
	0x3733,
	0x3738,
	0x373c,
	0x373f,
	0x374a,
	0x374d,
	0x374b,
	0x3747,
	0x3741,
	0x373c,
	0x3738,
	0x3735,
	0x3733,
	0x3733,
	0x3734,
	0x3738,
	0x373c,
	0x3741,
	0x3745,
	0x3749,
	0x374c,
	0x374a,
	0x374b,
	0x374a,
	0x3746,
	0x3741,
	0x373b,
	0x3734,
	0x372f,
	0x372b,
	0x3729,
	0x3729,
	0x372a,
	0x372e,
	0x3733,
	0x3739,
	0x373f,
	0x3744,
	0x3749,
	0x374c,
	0x3747,
	0x3744,
	0x373e,
	0x3737,
	0x3730,
	0x3728,
	0x3722,
	0x371e,
	0x371c,
	0x371b,
	0x371d,
	0x3721,
	0x3727,
	0x372e,
	0x3735,
	0x373c,
	0x3743,
	0x3747,
	0x3742,
	0x373e,
	0x3738,
	0x3730,
	0x3727,
	0x371f,
	0x3719,
	0x3714,
	0x3712,
	0x3711,
	0x3713,
	0x3717,
	0x371d,
	0x3725,
	0x372d,
	0x3736,
	0x373e,
	0x3744,
	0x373e,
	0x3739,
	0x3732,
	0x3729,
	0x371f,
	0x3717,
	0x3710,
	0x370c,
	0x3709,
	0x3709,
	0x370b,
	0x370f,
	0x3715,
	0x371d,
	0x3726,
	0x3730,
	0x3739,
	0x3740,
	0x373a,
	0x3735,
	0x372d,
	0x3723,
	0x371a,
	0x3711,
	0x370a,
	0x3706,
	0x3703,
	0x3703,
	0x3705,
	0x3709,
	0x370f,
	0x3717,
	0x3721,
	0x372b,
	0x3735,
	0x373d,
	0x3739,
	0x3734,
	0x372b,
	0x3721,
	0x3717,
	0x370e,
	0x3707,
	0x3703,
	0x3700,
	0x3700,
	0x3702,
	0x3706,
	0x370c,
	0x3715,
	0x371f,
	0x3729,
	0x3734,
	0x373c,
	0x3738,
	0x3732,
	0x372a,
	0x3720,
	0x3715,
	0x370d,
	0x3706,
	0x3701,
	0x3700,
	0x3700,
	0x3700,
	0x3705,
	0x370b,
	0x3713,
	0x371d,
	0x3728,
	0x3733,
	0x373b,
	0x3739,
	0x3733,
	0x372b,
	0x3720,
	0x3716,
	0x370e,
	0x3707,
	0x3702,
	0x3700,
	0x3700,
	0x3702,
	0x3706,
	0x370c,
	0x3715,
	0x371f,
	0x372a,
	0x3734,
	0x373c,
	0x373b,
	0x3736,
	0x372e,
	0x3724,
	0x371a,
	0x3711,
	0x370b,
	0x3706,
	0x3704,
	0x3703,
	0x3705,
	0x370a,
	0x3710,
	0x3719,
	0x3723,
	0x372d,
	0x3737,
	0x373e,
	0x373d,
	0x3739,
	0x3731,
	0x3728,
	0x371f,
	0x3717,
	0x3710,
	0x370b,
	0x3709,
	0x3709,
	0x370b,
	0x370f,
	0x3716,
	0x371e,
	0x3728,
	0x3731,
	0x373a,
	0x3740,
	0x3741,
	0x373d,
	0x3737,
	0x372f,
	0x3726,
	0x371e,
	0x3718,
	0x3713,
	0x3711,
	0x3711,
	0x3713,
	0x3718,
	0x371e,
	0x3726,
	0x372f,
	0x3737,
	0x373e,
	0x3744,
	0x3745,
	0x3743,
	0x373d,
	0x3736,
	0x372f,
	0x3728,
	0x3722,
	0x371e,
	0x371b,
	0x371c,
	0x371e,
	0x3722,
	0x3728,
	0x372f,
	0x3736,
	0x373d,
	0x3743,
	0x3747,
	0x3746,
	0x3745,
	0x3741,
	0x373b,
	0x3735,
	0x372f,
	0x372a,
	0x3726,
	0x3724,
	0x3724,
	0x3727,
	0x372a,
	0x372f,
	0x3736,
	0x373c,
	0x3741,
	0x3746,
	0x3748,
	0x1200,
	0x1300,
	0x0315,
	0x1083,
/*/////////////////////////////////////////*/
/* 16 Page CMC*/
/*/////////////////////////////////////////*/
	0x0316,
	0x100f, /*cmc*/
	0x60ff, /*mcmc*/
/*automatic saturation*/
	0x8a68,
	0x8b7c,
	0x8c7f,
	0x8d7f,
	0x8e7f,
	0x8f7f,
	0x907f,
	0x917f,
	0x927f,
	0x937f,
	0x947a,
	0x9578,
	0x9674,
	0x9770,
	0x986c,
	0x9968,
	0x9a64,
/*WB gain*/
	0xa081, /*Manual WB gain enable*/
	0xa100,
	0xa258, /*R_start_gain*/
	0xa382, /*B_start_gain*/
	0xa6f0, /*r max*/
	0xa8f0, /*b max*/
/* Pre WB gain setting(after AWB setting)*/
	0xF001, /*Pre WB gain enable Gain resolution_1x*/
	0xF140,
	0xF240,
	0xF340,
	0xF440,
/*/////////////////////////////////////////*/
/* 17 Page Gamma*/
/*/////////////////////////////////////////*/
	0x0317,
	0x1001,
/*/////////////////////////////////////////*/
/* 18 Page Histogram*/
/*/////////////////////////////////////////*/
	0x0318,
	0x1000,
/*/////////////////////////////////////////*/
/* 20 Page AE*/
/*/////////////////////////////////////////*/
	0x0320,
	0x109f, /*50Hz*/
	0x122d, /*en_ramp_gain_auto*/
	0x17a0, /*AE fuzzy (Y Mean)*/
	0x1f1f,
	0x2000, /*EXP Normal 33.33 fps*/
	0x2117,
	0x22cd,
	0x23c0,
	0x2400, /*EXP Max 8.33 fps*/
	0x255f,
	0x2637,
	0x2700,
	0x2800, /*EXPMin 10400.00 fps*/
	0x2913,
	0x2a88,
	0x3007, /*EXP100*/
	0x31ef,
	0x3240,
	0x3306, /*EXP120*/
	0x3499,
	0x3574,
	0x3600, /*EXP Unit*/
	0x3709,
	0x38c4,
	0x4000, /*exp 12000*/
	0x4107,
	0x42ef,
	0x51f0, /*pga_max_total*/
	0x5224, /*pga_min_total*/
	0x7184, /*DG MAX*/
	0x7280, /*DG MIN*/
	0x8032, /*AE target*/
/*/////////////////////////////////////////*/
/* 30 page MCU Set*/
/*/////////////////////////////////////////*/
	0x0330,
	0x1200,
	0x2008,
	0x5000,
	0xe002, /*Don't touch*/
	0xf000,
	0x1105, /*B[0]: MCU holding*/
	0x03c0,
	0xe4A0, /*delay*/
/*/////////////////////////////////////////*/
/* 30 Page DMA address set*/
/*/////////////////////////////////////////*/
	0x0330, /*DMA*/
	0x7c2c, /*Extra str*/
	0x7dce,
	0x7e2c, /*Extra end*/
	0x7fd1,
	0x8024, /*Outdoor str*/
	0x8170,
	0x8224, /*Outdoor end*/
	0x8373,
	0x8421, /*Indoor str*/
	0x85a6,
	0x8621, /*Indoor end*/
	0x87a9,
	0x8827, /*Dark1 str*/
	0x893a,
	0x8a27, /*Dark1 end*/
	0x8b3d,
	0x8c2a, /*Dark2 str*/
	0x8d04,
	0x8e2a, /*Dark2 end*/
	0x8f07,
	0x03C0,
	0x2Ff0, /*DMA busy flag check*/
	0x3120, /*Delay before DMA write*/
	0x3320, /*DMA full stuck mode*/
	0x3201, /*DMA on first*/
	0x03C0,
	0x2Ff0, /*DMA busy flag check*/
	0x3120, /*Delay before DMA write*/
	0x3320,
	0x3201, /*DMA on second*/
	0x0300,
	0x1013, /* Preview2*/
	0x01F0, /* sleep off*/
/*/////////////////////////////////////////*/
/* 30 page*/
/*/////////////////////////////////////////*/
	0x0330,
	0xDE20, /*OTP color ratio xdata address set*/
	0xDFA5,
	0x03E7,
	0x1F18, /*OTP color ratio Rg typical set = 6300*/
	0x209c,
	0x210F, /*OTP color ratio Bg typical set = 3920*/
	0x2250,
/*/////////////////////////////////////////*/
/* CD Page Adaptive Mode(Color ratio)*/
/*/////////////////////////////////////////*/
	0x03CD,
	0x4700,
	0x1240,
	0x1340, /*Ratio WB R gain min*/
	0x1448, /*Ratio WB R gain max*/
	0x1540, /*Ratio WB B gain min*/
	0x1648, /*Ratio WB B gain max*/
	0x10B9, /*enable*/
/*/////////////////////////////////////////*/
/* 1F Page SSD*/
/*/////////////////////////////////////////*/
	0x031f, /*1F page*/
	0x1100, /*bit[5:4]: debug mode*/
	0x1260,
	0x1314,
	0x1410,
	0x1500,
	0x2018, /*ssd_x_start_pos*/
	0x2114, /*ssd_y_start_pos*/
	0x228C, /*ssd_blk_width*/
	0x2360, /*ssd_blk_height*/
	0x2818,
	0x2902,
	0x3B18,
	0x3C8C,
	0x1019, /*SSD enable*/
/*/////////////////////////////////////////*/
/* C4 Page MCU AE*/
/*/////////////////////////////////////////*/
	0x03c4,
	0x1290,
	0x1510, /*Th1*/
	0x160a, /*Th2*/
	0x1708, /*Th3*/
	0x1804, /*Th4*/
/*Shutter Setting*/
	0x193c, /*Band1 Gain*/
	0x1e00, /*Bnd1 33.33fps*/
	0x1f17,
	0x20cd,
	0x21c0,
	0x1a46, /*Band2 Gain*/
	0x2200, /*Bnd2 20fps*/
	0x2327,
	0x24ac,
	0x2540,
	0x1b5c, /*Bnd3 Gain*/
	0x2600, /*Bnd3 12.5fps*/
	0x273f,
	0x287a,
	0x2900,
	0x3611, /*B[7:4]Lock, B[3:0]Unlock0 (x2)*/
/*/////////////////////////////////////////*/
/* c3 Page MCU AE Weight*/
/*/////////////////////////////////////////*/
	0x03c3,
	0x1000,
	0x38FF,
	0x39FF,
/*AE_CenterWeighted*/
	0x7000,
	0x7100,
	0x7200,
	0x7300,
	0x7400,
	0x7500,
	0x7600,
	0x7700,
	0x7800,
	0x7900,
	0x7A00,
	0x7B00,
	0x7C11,
	0x7D11,
	0x7E11,
	0x7F11,
	0x8011,
	0x8111,
	0x8211,
	0x8321,
	0x8444,
	0x8544,
	0x8612,
	0x8711,
	0x8811,
	0x8922,
	0x8A64,
	0x8B46,
	0x8C22,
	0x8D11,
	0x8E21,
	0x8F33,
	0x9064,
	0x9146,
	0x9233,
	0x9312,
	0x9421,
	0x9533,
	0x9644,
	0x9744,
	0x9833,
	0x9912,
	0x9A21,
	0x9B33,
	0x9C33,
	0x9D33,
	0x9E33,
	0x9F12,
	0xA011,
	0xA111,
	0xA211,
	0xA311,
	0xA411,
	0xA511,
	0xE125, /*Outdoor AG Max*/
	0xE203,
/*/////////////////////////////////////////*/
/* Capture Setting*/
/*/////////////////////////////////////////*/
	0x03d5,
	0x1199, /*PLL, Line time, Y Correction*/
	0x1e04, /*Main x1*/
	0x8608, /*Prev x2*/
	0x1f01, /*Capture Hblank  320*/
	0x2040,
	0x2109, /*Capture oneline 2500*/
	0x22c4,
	0x8c01, /*Preview Hblank  320*/
	0x8d40,
	0x9209, /*Preview oneline 2500*/
	0x93c4,
	0x3300,
/*/////////////////////////////////////////*/
/* C0 Page Firmware system*/
/*/////////////////////////////////////////*/
	0x03c0,
	0x1680,
	0x1681, /*MCU main roof holding on*/
/*/////////////////////////////////////////*/
/* C5 Page AWB*/
/*/////////////////////////////////////////*/
	0x03c5,
	0x0e01, /*burst start*/
	0x1030,
	0x11a5,
	0x1293,
	0x131d,
	0x1402, /*bLockTh*/
	0x150A, /*bTraceStep*/
	0x1606, /*bTraceStepLmt*/
	0x1708, /*bBlkPtBndWdhTh*/
	0x180a, /*bBlkPtBndCntTh*/
	0x1903, /*bBlkPtBndCntLmt*/
	0x1aa0, /*bBrtUnStbYThhi*/
	0x1b08, /*bBrtUnStbYThLo*/
	0x1c10, /*bBrtUnStbCntTh*/
	0x1d40, /*bGgainDef*/
	0x1e00, /*iOut2AglMaxLmt*/
	0x1fc8,
	0x2000, /*iOut2AglMinLmt*/
	0x219b,
	0x2200, /*iOut1AglMaxLmt*/
	0x23c8,
	0x2400, /*iOut1AglMinLmt*/
	0x25a5,
	0x2601, /*iInAglMaxLmt*/
	0x2709,
	0x2800, /*iInAglMinLmt*/
	0x2955,
	0x2a00, /*iDakAglMaxLmt*/
	0x2bd2,
	0x2c00, /*iDakAglMinLmt*/
	0x2d55,
	0x2e00, /*dwOut2LmtTh*/
	0x2f01,
	0x30f9,
	0x315f,
	0x3200, /*dwOut2StrLmtTh*/
	0x3302,
	0x343b,
	0x354a,
	0x3600, /*dwOut1LmtTh*/
	0x3708,
	0x38ed,
	0x3928,
	0x3a00, /*dwOut1StrLmtTh*/
	0x3b11,
	0x3cda,
	0x3d50,
	0x3e01, /*dwDakStrLmtTh*/
	0x3fdc,
	0x4013,
	0x4100,
	0x4202, /*dwDakLmtTh*/
	0x433b,
	0x444a,
	0x4500,
	0x4600, /*dwOutdoorCondTh*/
	0x4708,
	0x48ed,
	0x4928,
	0x4a00, /*dwOutdoorCondOutTh*/
	0x4b11,
	0x4cda,
	0x4d50,
	0x4e00, /*bRgOfs*/
	0x4f00, /*bBgOfs*/
	0x5055, /*aSsdBlkWgt*/
	0x5155,
	0x5255,
	0x5355,
	0x5455,
	0x5555,
	0x5655,
	0x5755,
	0x5855,
	0x5955,
	0x5aaa,
	0x5b55,
	0x5c55,
	0x5daa,
	0x5e55,
	0x5f55,
	0x60aa,
	0x6155,
	0x6255,
	0x6355,
	0x6455,
	0x6555,
	0x6655,
	0x6755,
	0x6855,
	0x6955,
	0x6a55,
	0x6b16, /*aInWhtRgnBg_a00*/
	0x6c25,
	0x6d29,
	0x6e30,
	0x6f33,
	0x7039,
	0x7142,
	0x724e,
	0x7359,
	0x7464,
	0x75ad,
	0x76C0, /*aInWhtRgnRgLeftLmt_a00*/
	0x7783,
	0x7871,
	0x795C,
	0x7a4E,
	0x7b45,
	0x7c3e,
	0x7d3a,
	0x7e37,
	0x7f35,
	0x802a,
	0x81D0, /*aInWhtRgnRgRightLmt_a00*/
	0x82A7,
	0x839F,
	0x8486,
	0x857c,
	0x8671,
	0x8762,
	0x884f,
	0x8945,
	0x8a3f,
	0x8b31,
	0x8c16, /*aInWhtLineBg_a00*/
	0x8d24,
	0x8e27,
	0x8f2b,
	0x902e,
	0x9132,
	0x9237,
	0x933e,
	0x9447,
	0x9562,
	0x96ad,
	0x97C8, /*aInWhtLineRg_a00*/
	0x989F,
	0x9990,
	0x9a83,
	0x9b73,
	0x9c68,
	0x9d5A,
	0x9e50,
	0x9f45,
	0xa03b,
	0xa12d,
	0xa23c, /*aInTgtAngle_a00*/
	0xa33f, /*01*/
	0xa441, /*02*/
	0xa546, /*03*/
	0xa64b, /*04*/
	0xa750, /*05*/
	0xa85a, /*06*/
	0xa96e, /*07*/
	0xaa06, /*aInRgTgtOfs_a00*/
	0xab06, /*01*/
	0xac03, /*02*/
	0xad03, /*03*/
	0xae00, /*04*/
	0xaf00, /*05*/
	0xb000, /*06*/
	0xb100, /*07*/
	0xb294, /*aInBgTgtOfs_a00*/
	0xb394, /*01*/
	0xb494, /*02*/
	0xb594, /*03*/
	0xb600, /*04*/
	0xb781, /*05*/
	0xb881, /*06*/
	0xb981, /*07*/
	0xba00, /*aInLeftOfs_a00*/
	0xbb00, /*01*/
	0xbc00, /*02*/
	0xbd00, /*03*/
	0xbe00, /*04*/
	0xbf00, /*05*/
	0xc000, /*06*/
	0xc100, /*07*/
	0xc200, /*aInRightOfs_a00*/
	0xc300, /*01*/
	0xc400, /*02*/
	0xc500, /*03*/
	0xc600, /*04*/
	0xc700, /*05*/
	0xc800, /*06*/
	0xc900, /*07*/
	0xca00, /*aInCorWhtPtWgt_a00*/
	0xcb00, /*01*/
	0xcc00, /*02*/
	0xcd00, /*03*/
	0xce20, /*04*/
	0xcf80, /*05*/
	0xd020, /*06*/
	0xd100, /*07*/
	0xd20a, /*aInYlvlWgt*/
	0xd319,
	0xd42d,
	0xd53c,
	0xd64b,
	0xd755,
	0xd864,
	0xd964,
	0xda5a,
	0xdb4b,
	0xdc3c,
	0xdd28,
	0xde1e,
	0xdf14,
	0xe00a,
	0xe10a,
	0xe2ff, /*aInHiTmpWgtHiLmt_a00_n00*/
	0xe3ff, /*01*/
	0xe4ff, /*02*/
	0xe5ff, /*03*/
	0xe6ff, /*04*/
	0xe7ff, /*05*/
	0xe880, /*06*/
	0xe930, /*07*/
	0xea1e, /*08*/
	0xeb1e, /*09*/
	0xec1e, /*10*/
	0xed80, /*aInHiTmpWgtLoLmt_a00_n00*/
	0xee80, /*01*/
	0xef80, /*02*/
	0xf080, /*03*/
	0xf180, /*04*/
	0xf240, /*05*/
	0xf320, /*06*/
	0xf40a, /*07*/
	0xf50a, /*08*/
	0xf60a, /*09*/
	0xf70a, /*10*/
	0xf832, /*aInHiTmpWgtRatio_50%*/
	0xf902, /*bInDyAglDiffMin*/
	0xfa32, /*bInDyAglDiffMax*/
	0xfb28, /*bInDyMinMaxTempWgt*/
	0xfc64, /*bInSplTmpAgl*/
	0xfd1E, /*bInSplTmpAglOfs*/
	0x0e00, /*burst end*/
	0x03c6,
	0x0e01, /*burst start*/
	0x1028, /*bInSplTmpBpCntTh*/
	0x1150, /*bInSplTmpPtCorWgt*/
	0x121e, /*bInSplTmpPtWgtRatio*/
	0x1332, /*bInSplTmpAglMinLmt*/
	0x144B, /*bInSplTmpAglMaxLmt*/
	0x151e, /*bInSplTmpDistTh*/
	0x1608, /*bInYlvlMin*/
	0x17e0, /*bInYlvlMax*/
	0x1846, /*bInRgainMin*/
	0x1990, /*bInRgainMax*/
	0x1a40, /*bInBgainMin*/
	0x1ba4, /*bInBgainMax*/
	0x1c0a, /*bInCntLmtHiTh*/
	0x1d04, /*bInCntLmtLoTh*/
	0x1e14, /*aOutWhtRgnBg*/
	0x1f29,
	0x202E,
	0x2134,
	0x223B,
	0x2343,
	0x244A,
	0x2551,
	0x2659,
	0x2761,
	0x28A0,
	0x299F, /*aOutWhtRgnRgLeftLmt*/
	0x2a58,
	0x2b54,
	0x2c4F,
	0x2d49,
	0x2e46,
	0x2f44,
	0x3042,
	0x3141,
	0x3240,
	0x333C,
	0x34AA, /*aOutWhtRgnRgRightLmt*/
	0x3568,
	0x3666,
	0x3764,
	0x3862,
	0x395F,
	0x3a5C,
	0x3b59,
	0x3c53,
	0x3d50,
	0x3e4A,
	0x3f14, /*aOutWhtLineBg*/
	0x402A,
	0x4130,
	0x4237,
	0x433E,
	0x4446,
	0x454D,
	0x4654,
	0x475B,
	0x4861,
	0x49A0,
	0x4aA5, /*aOutWhtLineRg*/
	0x4b5F,
	0x4c5C,
	0x4d57,
	0x4e54,
	0x4f50,
	0x504E,
	0x514B,
	0x5248,
	0x5347,
	0x5443,
	0x5550, /*aOutTgtAngle_a00*/
	0x5655, /*01*/
	0x575a, /*02*/
	0x585f, /*03*/
	0x5964, /*04*/
	0x5a69, /*05*/
	0x5b6e, /*06*/
	0x5c73, /*07*/
	0x5d00, /*aOutRgTgtOfs_a00*/
	0x5e00, /*01*/
	0x5f00, /*02*/
	0x6000, /*03*/
	0x6100, /*04*/
	0x6200, /*05*/
	0x6300, /*06*/
	0x6400, /*07*/
	0x6500, /*aOutBgTgtOfs_a00_n00*/
	0x6600, /*01*/
	0x6700, /*02*/
	0x6800, /*03*/
	0x6900, /*04*/
	0x6a00, /*05*/
	0x6b00, /*06*/
	0x6c00, /*07*/
	0x6d00, /*aOutLeftOfs_a00_n00*/
	0x6e00, /*01*/
	0x6f00, /*02*/
	0x7000, /*03*/
	0x7100, /*04*/
	0x7200, /*05*/
	0x7300, /*06*/
	0x7400, /*07*/
	0x7500, /*aOutRightOfs_a00_n00*/
	0x7600, /*01*/
	0x7700, /*02*/
	0x7800, /*03*/
	0x7900, /*04*/
	0x7a00, /*05*/
	0x7b00, /*06*/
	0x7c00, /*07*/
	0x7d00, /*aOutCorWhtPtWgt_a00*/
	0x7e00, /*01*/
	0x7f00, /*02*/
	0x8011, /*03*/
	0x8122, /*04*/
	0x8222, /*05*/
	0x8333, /*06*/
	0x8433, /*07*/
	0x8512, /*aOutYlvlWgt*/
	0x861e,
	0x8728,
	0x882d,
	0x892d,
	0x8a12,
	0x8b0a,
	0x8c15,
	0x8d1f,
	0x8e16,
	0x8f15,
	0x900a,
	0x910a,
	0x920a,
	0x930a,
	0x940a,
	0x95ff, /*aOutHiTmpWgtHiLmt_a00_n00*/
	0x96ff, /*01*/
	0x97ff, /*02*/
	0x98ff, /*03*/
	0x99ff, /*04*/
	0x9aff, /*05*/
	0x9bff, /*06*/
	0x9cff, /*07*/
	0x9dff, /*08*/
	0x9eff, /*09*/
	0x9fff, /*10*/
	0xa008, /*aOutHiTmpWgtLoLmt_a00_n00*/
	0xa108, /*01*/
	0xa208, /*02*/
	0xa30d, /*03*/
	0xa410, /*04*/
	0xa512, /*05*/
	0xa612, /*06*/
	0xa712, /*07*/
	0xa813, /*08*/
	0xa913, /*09*/
	0xaa14, /*10*/
	0xab0a, /*aOutHiTmpWgtRatio*/
	0xac01, /*bOutDyAglDiffMin*/
	0xad14, /*bOutDyAglDiffMax*/
	0xae19, /*bOutDyMinMaxTempWgt*/
	0xaf55, /*bOutSplTmpAgl*/
	0xb01E, /*bOutSplTmpAglOfs*/
	0xb128, /*bOutSplTmpBpCntTh*/
	0xb21E, /*bOutSplTmpPtCorWgt*/
	0xb350, /*bOutSplTmpPtWgtRatio*/
	0xb41e, /*bOutSplTmpAglMinLmt*/
	0xb53c, /*bOutSplTmpAglMaxLmt*/
	0xb61e, /*bOutSplTmpDistTh*/
	0xb708, /*bOutYlvlMin*/
	0xb8d2, /*bOutYlvlMax*/
	0xb960, /*bOutRgainMin*/
	0xba66, /*bOutRgainMax*/
	0xbb66, /*bOutBgainMin*/
	0xbc80, /*bOutBgainMax*/
	0xbd0a, /*bOutCntLmtHiTh*/
	0xbe04, /*bOutCntLmtLoTh*/
	0x0e00, /*burst end*/
	0x03d4,
	0x315e, /*out2 r_min*/
	0x326a, /*out2 r_max*/
	0x356c, /*out2 b_min*/
	0x367e, /*out2 b_max*/
	0x375e, /*out1 r_min*/
	0x3872, /*out1 r_max*/
	0x3b6c, /*out1 b_min*/
	0x3c7b, /*out1 b_max*/
	0x3d47, /*in r_min*/
	0x3e90, /*in r_max*/
	0x4140, /*in b_min*/
	0x42a5, /*in b_max*/
	0x03c9,
	0x4268, /*Rgain (16a2)*/
	0x4340, /*Ggain*/
	0x4470, /*Bgain (16a4)*/
/*/////////////////////////////////////////*/
/* CD Page (Color ratio)*/
/*/////////////////////////////////////////*/
	0x03CD,
	0x4706,
	0x10B8, /*enable*/
/*/////////////////////////////////////////*/
/* Cf Page Adaptive Mode*/
/*/////////////////////////////////////////*/
	0x03cf, /*page cf*/
	0x0e01, /*burst_start*/
	0x1000, /*control*/
	0x1105,
	0x1201,
	0x1302, /*Y_LUM_MAX*/
	0x146a,
	0x15e5,
	0x1680,
	0x1700, /*Y_LUM mid1*/
	0x18c7,
	0x195b,
	0x1a28,
	0x1b00, /*Y_LUM mid2*/
	0x1c08,
	0x1ded,
	0x1e28,
	0x1f00, /*Y_LUM min*/
	0x2000,
	0x2115,
	0x22f9,
	0x2378, /*CTEM high2*/
	0x2458, /*CTEM middle*/
	0x2538, /*CTEM low*/
	0x2660, /*YCON high*/
	0x2740, /*YCON middle*/
	0x2801, /*YCON low*/
	0x2900, /*Y_LUM max_TH*/
	0x2a00,
	0x2b00,
	0x2c00,
	0x2d00, /*Y_LUM mid1_TH*/
	0x2eb5,
	0x2f80,
	0x30d8,
	0x3100, /*Y_LUM mid2_TH*/
	0x3200,
	0x3300,
	0x3400,
	0x3500, /*Y_LUM min_TH*/
	0x3600,
	0x3700,
	0x3800,
	0x3900, /*CTEM high_TH*/
	0x3a14, /*CTEM middle_TH*/
	0x3b00, /*CTEM low_TH*/
	0x3c00, /*YCON high_TH*/
	0x3d00, /*YCON middle_TH*/
	0x3e00, /*YCON low_TH*/
/*//////////////////////////////////////////*/
/* CF Page Adaptive Y Target*/
/*/////////////////////////////////////////*/
	0x3f28, /*YLVL_00*/
	0x4028, /*YLVL_01*/
	0x4128, /*YLVL_02*/
	0x422e, /*YLVL_03*/
	0x432e, /*YLVL_04*/
	0x442e, /*YLVL_05*/
	0x4533, /*YLVL_06*/
	0x4633, /*YLVL_07*/
	0x4733, /*YLVL_08*/
	0x4833, /*YLVL_09*/
	0x4933, /*YLVL_10*/
	0x4a33, /*YLVL_11*/
/*/////////////////////////////////////////*/
/* CF Page Adaptive Y Contrast (4b~56)*/
/*/////////////////////////////////////////*/
	0x4b80, /*YCON_00*/
	0x4c80, /*YCON_01*/
	0x4d80, /*YCON_02*/
	0x4e80, /*YCON_03*/
	0x4f80, /*YCON_04*/
	0x5080, /*YCON_05*/
	0x5180, /*YCON_06*/
	0x5280, /*YCON_07*/
	0x5380, /*YCON_08*/
	0x5480, /*YCON_09*/
	0x5580, /*YCON_10*/
	0x5680, /*YCON_11*/
/*/////////////////////////////////////////*/
/* CF Page Adaptive Y OFFSET (57~62)*/
/*/////////////////////////////////////////*/
	0x5700, /*y offset 0*/
	0x5800, /*y offset 1*/
	0x5900, /*y offset 2*/
	0x5a00, /*y offset 3*/
	0x5b00, /*y offset 4*/
	0x5c00, /*y offset 5*/
	0x5d00, /*y offset 6*/
	0x5e00, /*y offset 7*/
	0x5f00, /*y offset 8*/
	0x6000, /*y offset 9*/
	0x6100, /*y offset 10*/
	0x6200, /*y offset 11*/
/*/////////////////////////////////////////*/
/* CF~D0~D1 Page Adaptive GAMMA*/
/*/////////////////////////////////////////*/
	0x6300, /*GMA00*/
	0x6402,
	0x6504,
	0x660a,
	0x6711,
	0x6823,
	0x6936,
	0x6a46,
	0x6b57,
	0x6c64,
	0x6d6f,
	0x6e78,
	0x6f80,
	0x7087,
	0x718c,
	0x7291,
	0x7396,
	0x749a,
	0x759f,
	0x76a3,
	0x77a8,
	0x78af,
	0x79b6,
	0x7abc,
	0x7bc6,
	0x7cd1,
	0x7ddb,
	0x7ee2,
	0x7fe9,
	0x80f0,
	0x81f6,
	0x82fa,
	0x83fe,
	0x84ff,
	0x8500, /*GMA01*/
	0x8602,
	0x8704,
	0x880a,
	0x8911,
	0x8a23,
	0x8b36,
	0x8c46,
	0x8d57,
	0x8e64,
	0x8f6f,
	0x9078,
	0x9180,
	0x9287,
	0x938c,
	0x9491,
	0x9596,
	0x969a,
	0x979f,
	0x98a3,
	0x99a8,
	0x9aaf,
	0x9bb6,
	0x9cbc,
	0x9dc6,
	0x9ed1,
	0x9fdb,
	0xa0e2,
	0xa1e9,
	0xa2f0,
	0xa3f6,
	0xa4fa,
	0xa5fe,
	0xa6ff,
	0xa700, /*GMA02*/
	0xa802,
	0xa904,
	0xaa0a,
	0xab11,
	0xac23,
	0xad36,
	0xae46,
	0xaf57,
	0xb064,
	0xb16f,
	0xb278,
	0xb380,
	0xb487,
	0xb58c,
	0xb691,
	0xb796,
	0xb89a,
	0xb99f,
	0xbaa3,
	0xbba8,
	0xbcaf,
	0xbdb6,
	0xbebc,
	0xbfc6,
	0xc0d1,
	0xc1db,
	0xc2e2,
	0xc3e9,
	0xc4f0,
	0xc5f6,
	0xc6fa,
	0xc7fe,
	0xc8ff,
	0xc900, /*GMA03*/
	0xca02,
	0xcb04,
	0xcc0a,
	0xcd15,
	0xce24,
	0xcf34,
	0xd044,
	0xd151,
	0xd25f,
	0xd36b,
	0xd475,
	0xd57d,
	0xd685,
	0xd78a,
	0xd88f,
	0xd993,
	0xda98,
	0xdb9c,
	0xdca0,
	0xdda5,
	0xdeab,
	0xdfb3,
	0xe0bd,
	0xe1cb,
	0xe2d9,
	0xe3e3,
	0xe4ea,
	0xe5f0,
	0xe6f4,
	0xe7f8,
	0xe8fb,
	0xe9fe,
	0xeaff,
	0xeb00, /*GMA04*/
	0xec02,
	0xed04,
	0xee0a,
	0xef15,
	0xf024,
	0xf134,
	0xf244,
	0xf351,
	0xf45f,
	0xf56b,
	0xf675,
	0xf77d,
	0xf885,
	0xf98a,
	0xfa8f,
	0xfb93,
	0xfc98,
	0xfd9c,
	0x0e00, /*burst end*/
	0x03d0, /*Page d0*/
	0x0e01, /*burst start*/
	0x10a0,
	0x11a5,
	0x12ab,
	0x13b3,
	0x14bd,
	0x15cb,
	0x16d9,
	0x17e3,
	0x18ea,
	0x19f0,
	0x1af4,
	0x1bf8,
	0x1cfb,
	0x1dfe,
	0x1eff,
	0x1f00, /*GMA05*/
	0x2002,
	0x2104,
	0x220a,
	0x2315,
	0x2424,
	0x2534,
	0x2644,
	0x2751,
	0x285f,
	0x296b,
	0x2a75,
	0x2b7d,
	0x2c85,
	0x2d8a,
	0x2e8f,
	0x2f93,
	0x3098,
	0x319c,
	0x32a0,
	0x33a5,
	0x34ab,
	0x35b3,
	0x36bd,
	0x37cb,
	0x38d9,
	0x39e3,
	0x3aea,
	0x3bf0,
	0x3cf4,
	0x3df8,
	0x3efb,
	0x3ffe,
	0x40ff,
	0x4100, /*GMA06*/
	0x4201,
	0x4304,
	0x440a,
	0x4514,
	0x4623,
	0x4730,
	0x4840,
	0x494d,
	0x4a57,
	0x4b62,
	0x4c6b,
	0x4d73,
	0x4e7a,
	0x4f82,
	0x5089,
	0x518e,
	0x5294,
	0x5399,
	0x549e,
	0x55a2,
	0x56aa,
	0x57b1,
	0x58b9,
	0x59c4,
	0x5ace,
	0x5bd6,
	0x5cdc,
	0x5de1,
	0x5ee6,
	0x5fec,
	0x60f1,
	0x61f5,
	0x62f9,
	0x6300, /*GMA07*/
	0x6401,
	0x6504,
	0x660a,
	0x6714,
	0x6823,
	0x6930,
	0x6a40,
	0x6b4d,
	0x6c57,
	0x6d62,
	0x6e6b,
	0x6f73,
	0x707a,
	0x7182,
	0x7289,
	0x738e,
	0x7494,
	0x7599,
	0x769e,
	0x77a2,
	0x78aa,
	0x79b1,
	0x7ab9,
	0x7bc4,
	0x7cce,
	0x7dd6,
	0x7edc,
	0x7fe1,
	0x80e6,
	0x81ec,
	0x82f1,
	0x83f5,
	0x84f9,
	0x8500, /*GMA08*/
	0x8601,
	0x8704,
	0x880a,
	0x8914,
	0x8a23,
	0x8b30,
	0x8c40,
	0x8d4d,
	0x8e57,
	0x8f62,
	0x906b,
	0x9173,
	0x927a,
	0x9382,
	0x9489,
	0x958e,
	0x9694,
	0x9799,
	0x989e,
	0x99a2,
	0x9aaa,
	0x9bb1,
	0x9cb9,
	0x9dc4,
	0x9ece,
	0x9fd6,
	0xa0dc,
	0xa1e1,
	0xa2e6,
	0xa3ec,
	0xa4f1,
	0xa5f5,
	0xa6f9,
	0xa700, /*GMA09*/
	0xa801,
	0xa904,
	0xaa0a,
	0xab14,
	0xac23,
	0xad30,
	0xae40,
	0xaf4d,
	0xb057,
	0xb162,
	0xb26b,
	0xb373,
	0xb47a,
	0xb582,
	0xb689,
	0xb78e,
	0xb894,
	0xb999,
	0xba9e,
	0xbba2,
	0xbcaa,
	0xbdb1,
	0xbeb9,
	0xbfc4,
	0xc0ce,
	0xc1d6,
	0xc2dc,
	0xc3e1,
	0xc4e6,
	0xc5ec,
	0xc6f1,
	0xc7f5,
	0xc8f9,
	0xc900, /*GMA10*/
	0xca01,
	0xcb04,
	0xcc0a,
	0xcd14,
	0xce23,
	0xcf30,
	0xd040,
	0xd14d,
	0xd257,
	0xd362,
	0xd46b,
	0xd573,
	0xd67a,
	0xd782,
	0xd889,
	0xd98e,
	0xda94,
	0xdb99,
	0xdc9e,
	0xdda2,
	0xdeaa,
	0xdfb1,
	0xe0b9,
	0xe1c4,
	0xe2ce,
	0xe3d6,
	0xe4dc,
	0xe5e1,
	0xe6e6,
	0xe7ec,
	0xe8f1,
	0xe9f5,
	0xeaf9,
	0xeb00, /*GMA11*/
	0xec01,
	0xed04,
	0xee0a,
	0xef14,
	0xf023,
	0xf130,
	0xf240,
	0xf34d,
	0xf457,
	0xf562,
	0xf66b,
	0xf773,
	0xf87a,
	0xf982,
	0xfa89,
	0xfb8e,
	0xfc94,
	0xfd99,
	0x0e00, /*burst_end*/
	0x03d1, /*Page d1*/
	0x0e01, /*burst_start*/
	0x109e,
	0x11a2,
	0x12aa,
	0x13b1,
	0x14b9,
	0x15c4,
	0x16ce,
	0x17d6,
	0x18dc,
	0x19e1,
	0x1ae6,
	0x1bec,
	0x1cf1,
	0x1df5,
	0x1ef9,
/*/////////////////////////////////////////*/
/* D1 Page Adaptive Y Target delta (1f~2a)*/
/*/////////////////////////////////////////*/
	0x1f80, /*Y target delta 0*/
	0x2080, /*Y target delta 1*/
	0x2180, /*Y target delta 2*/
	0x2280, /*Y target delta 3*/
	0x2380, /*Y target delta 4*/
	0x2480, /*Y target delta 5*/
	0x2580, /*Y target delta 6*/
	0x2680, /*Y target delta 7*/
	0x2780, /*Y target delta 8*/
	0x2880, /*Y target delta 9*/
	0x2980, /*Y target delta 10*/
	0x2a80, /*Y target delta 11*/
/*/////////////////////////////////////////*/
/* D1 Page Adaptive R/B saturation*/
/*/////////////////////////////////////////*/
/*SATB*/
	0x2b88, /*SATB_00*/
	0x2c88, /*SATB_01*/
	0x2d88, /*SATB_02*/
	0x2e88, /*SATB_03*/
	0x2f88, /*SATB_04*/
	0x308c, /*SATB_05*/
	0x3198, /*SATB_06*/
	0x3298, /*SATB_07*/
	0x3398, /*SATB_08*/
	0x3498, /*SATB_09*/
	0x3598, /*SATB_10*/
	0x3698, /*SATB_11*/
/*SATR*/
	0x3780, /*SATR_00*/
	0x3880, /*SATR_01*/
	0x3980, /*SATR_02*/
	0x3a78, /*SATR_03*/
	0x3b88, /*SATR_04*/
	0x3c84, /*SATR_05*/
	0x3d8c, /*SATR_06*/
	0x3e8c, /*SATR_07*/
	0x3f8c, /*SATR_08*/
	0x408c, /*SATR_09*/
	0x418c, /*SATR_10*/
	0x428c, /*SATR_11*/
/*/////////////////////////////////////////*/
/* D1 Page Adaptive CMC*/
/*/////////////////////////////////////////*/
	0x432f, /*CMC_00*/
	0x4468,
	0x4529,
	0x4601,
	0x4719,
	0x486c,
	0x4913,
	0x4a13,
	0x4b1e,
	0x4c71,
	0x4d2f, /*CMC_01*/
	0x4e68,
	0x4f29,
	0x5001,
	0x5119,
	0x526c,
	0x5313,
	0x5413,
	0x551e,
	0x5671,
	0x572f, /*CMC_02*/
	0x5868,
	0x5929,
	0x5a01,
	0x5b19,
	0x5c6c,
	0x5d13,
	0x5e13,
	0x5f1e,
	0x6071,
	0x612f, /*CMC_03*/
	0x626a,
	0x6332,
	0x6408,
	0x651a,
	0x666c,
	0x6712,
	0x6803,
	0x6930,
	0x6a73,
	0x6b2f, /*CMC_04*/
	0x6c68,
	0x6d29,
	0x6e01,
	0x6f17,
	0x706c,
	0x7115,
	0x7201,
	0x7330,
	0x7471,
	0x752f, /*CMC_05*/
	0x7668,
	0x7729,
	0x7801,
	0x7917,
	0x7a6c,
	0x7b15,
	0x7c01,
	0x7d30,
	0x7e71,
	0x7f2f, /*CMC_06*/
	0x806a,
	0x813c,
	0x8212,
	0x8321,
	0x8470,
	0x850f,
	0x8606,
	0x872d,
	0x8873,
	0x892f, /*CMC_07*/
	0x8a6a,
	0x8b3c,
	0x8c12,
	0x8d21,
	0x8e70,
	0x8f0f,
	0x9006,
	0x912d,
	0x9273,
	0x932f, /*CMC_08*/
	0x946a,
	0x953c,
	0x9612,
	0x9721,
	0x9870,
	0x990f,
	0x9a06,
	0x9b2d,
	0x9c73,
	0x9d2f, /*CMC_09*/
	0x9e6a,
	0x9f3c,
	0xa012,
	0xa121,
	0xa270,
	0xa30f,
	0xa406,
	0xa52d,
	0xa673,
	0xa72f, /*CMC_10*/
	0xa86a,
	0xa93c,
	0xaa12,
	0xab21,
	0xac70,
	0xad0f,
	0xae06,
	0xaf2d,
	0xb073,
	0xb12f, /*CMC_11*/
	0xb26a,
	0xb33c,
	0xb412,
	0xb521,
	0xb670,
	0xb70f,
	0xb806,
	0xb92d,
	0xba73,
/*/////////////////////////////////////////*/
/* D1~D2~D3 Page Adaptive Multi-CMC*/
/*/////////////////////////////////////////*/
/*MCMC_00*/
	0xbb80, /*GLB_GAIN*/
	0xbc00, /*GLB_HUE*/
	0xbd80, /*0_GAIN*/
	0xbe00, /*0_HUE*/
	0xbf35, /*0_CENTER*/
	0xc013, /*0_DELTA*/
	0xc180, /*1_GAIN*/
	0xc200, /*1_HUE*/
	0xc36a, /*1_CENTER*/
	0xc41c, /*1_DELTA*/
	0xc580, /*2_GAIN*/
	0xc600, /*2_HUE*/
	0xc7ac, /*2_CENTER*/
	0xc81c, /*2_DELTA*/
	0xc995, /*3_GAIN*/
	0xca00, /*3_HUE*/
	0xcb50, /*3_CENTER*/
	0xcc20, /*3_DELTA*/
	0xcd80, /*4_GAIN*/
	0xce00, /*4_HUE*/
	0xcf7c, /*4_CENTER*/
	0xd01c, /*4_DELTA*/
	0xd180, /*5_GAIN*/
	0xd200, /*5_HUE*/
	0xd399, /*5_CENTER*/
	0xd41d, /*5_DELTA*/
/*MCMC_01*/
	0xd580, /*GLB_GAIN*/
	0xd600, /*GLB_HUE*/
	0xd780, /*0_GAIN*/
	0xd800, /*0_HUE*/
	0xd935, /*0_CENTER*/
	0xda13, /*0_DELTA*/
	0xdb80, /*1_GAIN*/
	0xdc00, /*1_HUE*/
	0xdd6a, /*1_CENTER*/
	0xde1c, /*1_DELTA*/
	0xdf80, /*2_GAIN*/
	0xe000, /*2_HUE*/
	0xe1ac, /*2_CENTER*/
	0xe21c, /*2_DELTA*/
	0xe395, /*3_GAIN*/
	0xe400, /*3_HUE*/
	0xe550, /*3_CENTER*/
	0xe620, /*3_DELTA*/
	0xe780, /*4_GAIN*/
	0xe800, /*4_HUE*/
	0xe97c, /*4_CENTER*/
	0xea1c, /*4_DELTA*/
	0xeb80, /*5_GAIN*/
	0xec00, /*5_HUE*/
	0xed99, /*5_CENTER*/
	0xee1d, /*5_DELTA*/
/*MCMC_02*/
	0xef80, /*GLB_GAIN*/
	0xf000, /*GLB_HUE*/
	0xf180, /*0_GAIN*/
	0xf200, /*0_HUE*/
	0xf335, /*0_CENTER*/
	0xf413, /*0_DELTA*/
	0xf580, /*1_GAIN*/
	0xf600, /*1_HUE*/
	0xf76a, /*1_CENTER*/
	0xf81c, /*1_DELTA*/
	0xf980, /*2_GAIN*/
	0xfa00, /*2_HUE*/
	0xfbac, /*2_CENTER*/
	0xfc1c, /*2_DELTA*/
	0xfd95, /*3_GAIN*/
	0x0e00, /*burst end*/
	0x03d2, /*Page d2*/
	0x0e01, /*burst start*/
	0x1000, /*3_HUE*/
	0x1150, /*3_CENTER*/
	0x1220, /*3_DELTA*/
	0x1380, /*4_GAIN*/
	0x1400, /*4_HUE*/
	0x157c, /*4_CENTER*/
	0x161c, /*4_DELTA*/
	0x1780, /*5_GAIN*/
	0x1800, /*5_HUE*/
	0x1999, /*5_CENTER*/
	0x1a1d, /*5_DELTA*/
/*MCMC_03*/
	0x1b80, /*GLB_GAIN*/
	0x1c00, /*GLB_HUE*/
	0x1d70, /*0_GAIN*/
	0x1e04, /*0_HUE*/
	0x1f36, /*0_CENTER*/
	0x200d, /*0_DELTA*/
	0x21be, /*1_GAIN*/
	0x2210, /*1_HUE*/
	0x236b, /*1_CENTER*/
	0x241e, /*1_DELTA*/
	0x2580, /*2_GAIN*/
	0x2600, /*2_HUE*/
	0x27af, /*2_CENTER*/
	0x281c, /*2_DELTA*/
	0x2980, /*3_GAIN*/
	0x2a87, /*3_HUE*/
	0x2b51, /*3_CENTER*/
	0x2c1c, /*3_DELTA*/
	0x2dbe, /*4_GAIN*/
	0x2e10, /*4_HUE*/
	0x2f76, /*4_CENTER*/
	0x301e, /*4_DELTA*/
	0x3180, /*5_GAIN*/
	0x3200, /*5_HUE*/
	0x339a, /*5_CENTER*/
	0x3414, /*5_DELTA*/
/*MCMC_04*/
	0x3580, /*GLB_GAIN*/
	0x3600, /*GLB_HUE*/
	0x3780, /*0_GAIN*/
	0x380a, /*0_HUE*/
	0x3932, /*0_CENTER*/
	0x3a0f, /*0_DELTA*/
	0x3b90, /*1_GAIN*/
	0x3c14, /*1_HUE*/
	0x3d6a, /*1_CENTER*/
	0x3e14, /*1_DELTA*/
	0x3f70, /*2_GAIN*/
	0x408e, /*2_HUE*/
	0x41af, /*2_CENTER*/
	0x421c, /*2_DELTA*/
	0x439a, /*3_GAIN*/
	0x4400, /*3_HUE*/
	0x4551, /*3_CENTER*/
	0x4618, /*3_DELTA*/
	0x47a9, /*4_GAIN*/
	0x4810, /*4_HUE*/
	0x497c, /*4_CENTER*/
	0x4a18, /*4_DELTA*/
	0x4ba0, /*5_GAIN*/
	0x4c00, /*5_HUE*/
	0x4d99, /*5_CENTER*/
	0x4e1e, /*5_DELTA*/
/*MCMC_05*/
	0x4f80, /*GLB_GAIN*/
	0x5000, /*GLB_HUE*/
	0x5178, /*0_GAIN*/
	0x5208, /*0_HUE*/
	0x5332, /*0_CENTER*/
	0x540f, /*0_DELTA*/
	0x559a, /*1_GAIN*/
	0x560a, /*1_HUE*/
	0x576a, /*1_CENTER*/
	0x5814, /*1_DELTA*/
	0x5970, /*2_GAIN*/
	0x5a88, /*2_HUE*/
	0x5baf, /*2_CENTER*/
	0x5c1c, /*2_DELTA*/
	0x5da6, /*3_GAIN*/
	0x5e08, /*3_HUE*/
	0x5f4b, /*3_CENTER*/
	0x601e, /*3_DELTA*/
	0x6190, /*4_GAIN*/
	0x6210, /*4_HUE*/
	0x637c, /*4_CENTER*/
	0x6418, /*4_DELTA*/
	0x65a0, /*5_GAIN*/
	0x6600, /*5_HUE*/
	0x6799, /*5_CENTER*/
	0x681e, /*5_DELTA*/
/*MCMC_06*/
	0x6980, /*GLB_GAIN*/
	0x6a00, /*GLB_HUE*/
	0x6b60, /*0_GAIN*/
	0x6c08, /*0_HUE*/
	0x6d34, /*0_CENTER*/
	0x6e0c, /*0_DELTA*/
	0x6f93, /*1_GAIN*/
	0x7010, /*1_HUE*/
	0x715e, /*1_CENTER*/
	0x7214, /*1_DELTA*/
	0x73a0, /*2_GAIN*/
	0x7488, /*2_HUE*/
	0x75af, /*2_CENTER*/
	0x7628, /*2_DELTA*/
	0x7780, /*3_GAIN*/
	0x788a, /*3_HUE*/
	0x7948, /*3_CENTER*/
	0x7a14, /*3_DELTA*/
	0x7b80, /*4_GAIN*/
	0x7c0c, /*4_HUE*/
	0x7d72, /*4_CENTER*/
	0x7e14, /*4_DELTA*/
	0x7f80, /*5_GAIN*/
	0x8000, /*5_HUE*/
	0x819a, /*5_CENTER*/
	0x8214, /*5_DELTA*/
/*MCMC_07*/
	0x8380, /*GLB_GAIN*/
	0x8400, /*GLB_HUE*/
	0x8560, /*0_GAIN*/
	0x8608, /*0_HUE*/
	0x8734, /*0_CENTER*/
	0x880c, /*0_DELTA*/
	0x8993, /*1_GAIN*/
	0x8a10, /*1_HUE*/
	0x8b5e, /*1_CENTER*/
	0x8c14, /*1_DELTA*/
	0x8da0, /*2_GAIN*/
	0x8e88, /*2_HUE*/
	0x8faf, /*2_CENTER*/
	0x9028, /*2_DELTA*/
	0x9180, /*3_GAIN*/
	0x928a, /*3_HUE*/
	0x9348, /*3_CENTER*/
	0x9414, /*3_DELTA*/
	0x9580, /*4_GAIN*/
	0x960c, /*4_HUE*/
	0x9772, /*4_CENTER*/
	0x9814, /*4_DELTA*/
	0x9980, /*5_GAIN*/
	0x9a00, /*5_HUE*/
	0x9b9a, /*5_CENTER*/
	0x9c14, /*5_DELTA*/
/*MCMC_08*/
	0x9d80, /*GLB_GAIN*/
	0x9e00, /*GLB_HUE*/
	0x9f60, /*0_GAIN*/
	0xa008, /*0_HUE*/
	0xa134, /*0_CENTER*/
	0xa20c, /*0_DELTA*/
	0xa393, /*1_GAIN*/
	0xa410, /*1_HUE*/
	0xa55e, /*1_CENTER*/
	0xa614, /*1_DELTA*/
	0xa7a0, /*2_GAIN*/
	0xa888, /*2_HUE*/
	0xa9af, /*2_CENTER*/
	0xaa28, /*2_DELTA*/
	0xab80, /*3_GAIN*/
	0xac8a, /*3_HUE*/
	0xad48, /*3_CENTER*/
	0xae14, /*3_DELTA*/
	0xaf80, /*4_GAIN*/
	0xb00c, /*4_HUE*/
	0xb172, /*4_CENTER*/
	0xb214, /*4_DELTA*/
	0xb380, /*5_GAIN*/
	0xb400, /*5_HUE*/
	0xb59a, /*5_CENTER*/
	0xb614, /*5_DELTA*/
/*MCMC_09*/
	0xb780, /*GLB_GAIN*/
	0xb800, /*GLB_HUE*/
	0xb960, /*0_GAIN*/
	0xba08, /*0_HUE*/
	0xbb34, /*0_CENTER*/
	0xbc0c, /*0_DELTA*/
	0xbd93, /*1_GAIN*/
	0xbe10, /*1_HUE*/
	0xbf5e, /*1_CENTER*/
	0xc014, /*1_DELTA*/
	0xc1a0, /*2_GAIN*/
	0xc288, /*2_HUE*/
	0xc3af, /*2_CENTER*/
	0xc428, /*2_DELTA*/
	0xc580, /*3_GAIN*/
	0xc68a, /*3_HUE*/
	0xc748, /*3_CENTER*/
	0xc814, /*3_DELTA*/
	0xc980, /*4_GAIN*/
	0xca0c, /*4_HUE*/
	0xcb72, /*4_CENTER*/
	0xcc14, /*4_DELTA*/
	0xcd80, /*5_GAIN*/
	0xce00, /*5_HUE*/
	0xcf9a, /*5_CENTER*/
	0xd014, /*5_DELTA*/
/*MCMC_10*/
	0xd180, /*GLB_GAIN*/
	0xd200, /*GLB_HUE*/
	0xd360, /*0_GAIN*/
	0xd408, /*0_HUE*/
	0xd534, /*0_CENTER*/
	0xd60c, /*0_DELTA*/
	0xd793, /*1_GAIN*/
	0xd810, /*1_HUE*/
	0xd95e, /*1_CENTER*/
	0xda14, /*1_DELTA*/
	0xdba0, /*2_GAIN*/
	0xdc88, /*2_HUE*/
	0xddaf, /*2_CENTER*/
	0xde28, /*2_DELTA*/
	0xdf80, /*3_GAIN*/
	0xe08a, /*3_HUE*/
	0xe148, /*3_CENTER*/
	0xe214, /*3_DELTA*/
	0xe380, /*4_GAIN*/
	0xe40c, /*4_HUE*/
	0xe572, /*4_CENTER*/
	0xe614, /*4_DELTA*/
	0xe780, /*5_GAIN*/
	0xe800, /*5_HUE*/
	0xe99a, /*5_CENTER*/
	0xea14, /*5_DELTA*/
/*MCMC_11*/
	0xeb80, /*GLB_GAIN*/
	0xec00, /*GLB_HUE*/
	0xed60, /*0_GAIN*/
	0xee08, /*0_HUE*/
	0xef34, /*0_CENTER*/
	0xf00c, /*0_DELTA*/
	0xf193, /*1_GAIN*/
	0xf210, /*1_HUE*/
	0xf35e, /*1_CENTER*/
	0xf414, /*1_DELTA*/
	0xf5a0, /*2_GAIN*/
	0xf688, /*2_HUE*/
	0xf7af, /*2_CENTER*/
	0xf828, /*2_DELTA*/
	0xf980, /*3_GAIN*/
	0xfa8a, /*3_HUE*/
	0xfb48, /*3_CENTER*/
	0xfc14, /*3_DELTA*/
	0xfd80, /*4_GAIN*/
	0x0e00, /*burst_end*/
	0x03d3, /*Page d3*/
	0x0e01, /*burst_start*/
	0x100c, /*4_HUE*/
	0x1172, /*4_CENTER*/
	0x1214, /*4_DELTA*/
	0x1380, /*5_GAIN*/
	0x1400, /*5_HUE*/
	0x159a, /*5_CENTER*/
	0x1614, /*5_DELTA*/
/*/////////////////////////////////////////*/
/* D3 Page Adaptive LSC*/
/*/////////////////////////////////////////*/
	0x1700, /*LSC 00 ofs GB*/
	0x1800, /*LSC 00 ofs B*/
	0x1900, /*LSC 00 ofs R*/
	0x1a00, /*LSC 00 ofs GR*/
	0x1b5c, /*LSC 00 Gain GB*/
	0x1c60, /*LSC 00 Gain B*/
	0x1d60, /*LSC 00 Gain R*/
	0x1e5c, /*LSC 00 Gain GR*/
	0x1f00, /*LSC 01 ofs GB*/
	0x2000, /*LSC 01 ofs B*/
	0x2100, /*LSC 01 ofs R*/
	0x2200, /*LSC 01 ofs GR*/
	0x235c, /*LSC 01 Gain GB*/
	0x2460, /*LSC 01 Gain B*/
	0x2560, /*LSC 01 Gain R*/
	0x265c, /*LSC 01 Gain GR*/
	0x2700, /*LSC 02 ofs GB*/
	0x2800, /*LSC 02 ofs B*/
	0x2900, /*LSC 02 ofs R*/
	0x2a00, /*LSC 02 ofs GR*/
	0x2b5c, /*LSC 02 Gain GB*/
	0x2c60, /*LSC 02 Gain B*/
	0x2d60, /*LSC 02 Gain R*/
	0x2e5c, /*LSC 02 Gain GR*/
	0x2f00, /*LSC 03 ofs GB*/
	0x3000, /*LSC 03 ofs B*/
	0x3100, /*LSC 03 ofs R*/
	0x3200, /*LSC 03 ofs GR*/
	0x3380, /*LSC 03 Gain GB*/
	0x3480, /*LSC 03 Gain B*/
	0x3576, /*LSC 03 Gain R*/
	0x3680, /*LSC 03 Gain GR*/
	0x3700, /*LSC 04 ofs GB*/
	0x3800, /*LSC 04 ofs B*/
	0x3900, /*LSC 04 ofs R*/
	0x3a00, /*LSC 04 ofs GR*/
	0x3b80, /*LSC 04 Gain GB*/
	0x3c80, /*LSC 04 Gain B*/
	0x3d76, /*LSC 04 Gain R*/
	0x3e80, /*LSC 04 Gain GR*/
	0x3f00, /*LSC 05 ofs GB*/
	0x4000, /*LSC 05 ofs B*/
	0x4100, /*LSC 05 ofs R*/
	0x4200, /*LSC 05 ofs GR*/
	0x4380, /*LSC 05 Gain GB*/
	0x4480, /*LSC 05 Gain B*/
	0x4576, /*LSC 05 Gain R*/
	0x4680, /*LSC 05 Gain GR*/
	0x4700, /*LSC 06 ofs GB*/
	0x4800, /*LSC 06 ofs B*/
	0x4900, /*LSC 06 ofs R*/
	0x4a00, /*LSC 06 ofs GR*/
	0x4b80, /*LSC 06 Gain GB*/
	0x4c80, /*LSC 06 Gain B*/
	0x4d80, /*LSC 06 Gain R*/
	0x4e80, /*LSC 06 Gain GR*/
	0x4f00, /*LSC 07 ofs GB*/
	0x5000, /*LSC 07 ofs B*/
	0x5100, /*LSC 07 ofs R*/
	0x5200, /*LSC 07 ofs GR*/
	0x5380, /*LSC 07 Gain GB*/
	0x5480, /*LSC 07 Gain B*/
	0x5580, /*LSC 07 Gain R*/
	0x5680, /*LSC 07 Gain GR*/
	0x5700, /*LSC 08 ofs GB*/
	0x5800, /*LSC 08 ofs B*/
	0x5900, /*LSC 08 ofs R*/
	0x5a00, /*LSC 08 ofs GR*/
	0x5b80, /*LSC 08 Gain GB*/
	0x5c80, /*LSC 08 Gain B*/
	0x5d80, /*LSC 08 Gain R*/
	0x5e80, /*LSC 08 Gain GR*/
	0x5f00, /*LSC 09 ofs GB*/
	0x6000, /*LSC 09 ofs B*/
	0x6100, /*LSC 09 ofs R*/
	0x6200, /*LSC 09 ofs GR*/
	0x6380, /*LSC 09 Gain GB*/
	0x6480, /*LSC 09 Gain B*/
	0x6580, /*LSC 09 Gain R*/
	0x6680, /*LSC 09 Gain GR*/
	0x6700, /*LSC 10 ofs GB*/
	0x6800, /*LSC 10 ofs B*/
	0x6900, /*LSC 10 ofs R*/
	0x6a00, /*LSC 10 ofs GR*/
	0x6b80, /*LSC 10 Gain GB*/
	0x6c80, /*LSC 10 Gain B*/
	0x6d80, /*LSC 10 Gain R*/
	0x6e80, /*LSC 10 Gain GR*/
	0x6f00, /*LSC 11 ofs GB*/
	0x7000, /*LSC 11 ofs B*/
	0x7100, /*LSC 11 ofs R*/
	0x7200, /*LSC 11 ofs GR*/
	0x7380, /*LSC 11 Gain GB*/
	0x7480, /*LSC 11 Gain B*/
	0x7580, /*LSC 11 Gain R*/
	0x7680, /*LSC 11 Gain GR*/
/*/////////////////////////////////////////*/
/* D3 Page OTP, ROM Select TH*/
/*/////////////////////////////////////////*/
	0x7760, /*2 ROM High*/
	0x7820, /*2 ROM Low*/
	0x7960, /*3 OTP High*/
	0x7a40, /*3 OTP Mid*/
	0x7b20, /*3 OTP Low*/
/*/////////////////////////////////////////*/
/* D3 Page Adaptive */
/*/////////////////////////////////////////*/
	0x7c00, /*EV Thresold max*/
	0x7d03,
	0x7eb0,
	0x7fd3,
	0x8000, /*EV Thresold min*/
	0x8101,
	0x821d,
	0x83a5,
	0x8476, /*CTEM Thresold max*/
	0x8562, /*CTEM Threshold min*/
	0x8604, /*Y Thresold max*/
	0x8700, /*Y Thresold min*/
	0x8800, /*offset*/
	0x8900,
	0x8a00,
	0x8b00,
	0x8c80, /*gain*/
	0x8d80,
	0x8e80,
	0x8f80,
	0x9050,
	0x9150,
	0x0e00, /*burst_end*/
/*/////////////////////////////////*/
/* D9 Page DMA EXTRA*/
/*/////////////////////////////////*/
	0x03d9,
	0x0e01, /*BURST_START*/
	0x1003, /*Page 10*/
	0x1110,
	0x1261,
	0x1380, /*1061 : SATB*/
	0x1462,
	0x1580, /*1062 : SATR*/
	0x1640,
	0x1700, /*1040 : Brightness*/
	0x1848,
	0x1980, /*1048 : Contrast*/
	0x1a03, /*Page 16*/
	0x1b16,
	0x1c30,
	0x1d7f, /*1630 : CMC*/
	0x1e31,
	0x1f42, /*1631*/
	0x2032,
	0x2103, /*1632*/
	0x2233,
	0x2322, /*1633*/
	0x2434,
	0x257b, /*1634*/
	0x2635,
	0x2719, /*1635*/
	0x2836,
	0x2901, /*1636*/
	0x2a37,
	0x2b43, /*1637*/
	0x2c38,
	0x2d84, /*1638*/
	0x2e70,
	0x2f80, /*1670 : MCMC*/
	0x3071,
	0x3100, /*1671*/
	0x3272,
	0x339b, /*1672*/
	0x3473,
	0x3505, /*1673*/
	0x3674,
	0x3734, /*1674*/
	0x3875,
	0x391e, /*1675*/
	0x3a76,
	0x3ba6, /*1676*/
	0x3c77,
	0x3d10, /*1677*/
	0x3e78,
	0x3f69, /*1678*/
	0x4079,
	0x411e, /*1679*/
	0x427a,
	0x4380, /*167a*/
	0x447b,
	0x4580, /*167b*/
	0x467c,
	0x47ad, /*167c*/
	0x487d,
	0x491e, /*167d*/
	0x4a7e,
	0x4b98, /*167e*/
	0x4c7f,
	0x4d80, /*167f*/
	0x4e80,
	0x4f51, /*1680*/
	0x5081,
	0x511e, /*1681*/
	0x5282,
	0x5380, /*1682*/
	0x5483,
	0x550c, /*1683*/
	0x5684,
	0x5723, /*1684*/
	0x5885,
	0x591e, /*1685*/
	0x5a86,
	0x5bb3, /*1686*/
	0x5c87,
	0x5d8a, /*1687*/
	0x5e88,
	0x5f52, /*1688*/
	0x6089,
	0x611e, /*1689*/
	0x6203, /*Page 17 Gamma*/
	0x6317,
	0x6420,
	0x6500, /*1720 : GMA*/
	0x6621,
	0x6702, /*1721*/
	0x6822,
	0x6904, /*1722*/
	0x6a23,
	0x6b09, /*1723*/
	0x6c24,
	0x6d12, /*1724*/
	0x6e25,
	0x6f23, /*1725*/
	0x7026,
	0x7137, /*1726*/
	0x7227,
	0x7347, /*1727*/
	0x7428,
	0x7557, /*1728*/
	0x7629,
	0x7761, /*1729*/
	0x782a,
	0x796b, /*172a*/
	0x7a2b,
	0x7b71, /*172b*/
	0x7c2c,
	0x7d76, /*172c*/
	0x7e2d,
	0x7f7a, /*172d*/
	0x802e,
	0x817f, /*172e*/
	0x822f,
	0x8384, /*172f*/
	0x8430,
	0x8588, /*1730*/
	0x8631,
	0x878c, /*1731*/
	0x8832,
	0x8991, /*1732*/
	0x8a33,
	0x8b94, /*1733*/
	0x8c34,
	0x8d98, /*1734*/
	0x8e35,
	0x8f9f, /*1735*/
	0x9036,
	0x91a6, /*1736*/
	0x9237,
	0x93ae, /*1737*/
	0x9438,
	0x95bb, /*1738*/
	0x9639,
	0x97c9, /*1739*/
	0x983a,
	0x99d3, /*173a*/
	0x9a3b,
	0x9bdc, /*173b*/
	0x9c3c,
	0x9de2, /*173c*/
	0x9e3d,
	0x9fe8, /*173d*/
	0xa03e,
	0xa1ed, /*173e*/
	0xa23f,
	0xa3f4, /*173f*/
	0xa440,
	0xa5fa, /*1740*/
	0xa641,
	0xa7ff, /*1741*/
	0xa803, /*page 20 AE*/
	0xa920,
	0xaa39,
	0xab40, /*2039 : Y target*/
	0xac03, /*Page 15 SHD*/
	0xad15,
	0xae24,
	0xaf00, /*1524 : Shading*/
	0xb025,
	0xb100, /*1525*/
	0xb226,
	0xb300, /*1526*/
	0xb427,
	0xb500, /*1527*/
	0xb628,
	0xb780, /*1528*/
	0xb829,
	0xb980, /*1529*/
	0xba2a,
	0xbb80, /*152a*/
	0xbc2b,
	0xbd80, /*152b*/
	0xbe11,
	0xbf40, /*1511*/
	0x0e00, /*burst_end*/
/*/////////////////////////////////*/
/* DA Page (DMA Outdoor)*/
/*/////////////////////////////////*/
	0x03da,
	0x0e01, /*burst_start*/
	0x1003,
	0x1111, /*11 page*/
	0x1210,
	0x1313, /*Outdoor 1110*/
	0x1411,
	0x1525, /*Outdoor 1111*/
	0x1612,
	0x1722, /*Outdoor 1112*/
	0x1813,
	0x1911, /*Outdoor 1113*/
	0x1a14,
	0x1b21, /*Outdoor 1114*/
	0x1c30,
	0x1d20, /*Outdoor 1130*/
	0x1e31,
	0x1f20, /*Outdoor 1131*/
	0x2032,
	0x2170, /*Outdoor 1132*/
	0x2233,
	0x234a, /*Outdoor 1133*/
	0x2434,
	0x252a, /*Outdoor 1134*/
	0x2635,
	0x272b, /*Outdoor 1135*/
	0x2836,
	0x2916, /*Outdoor 1136*/
	0x2a37,
	0x2b1b, /*Outdoor 1137*/
	0x2c38,
	0x2d14, /*Outdoor 1138*/
	0x2e39,
	0x2f10, /*Outdoor 1139 : R2 Lum Lv 01 NR Gain*/
	0x303a,
	0x3110, /*Outdoor 113a : R2 Lum Lv 02 NR Gain*/
	0x323b,
	0x332c, /*Outdoor 113b : R2 Lum Lv 03 NR Gain*/
	0x343c,
	0x3560, /*Outdoor 113c : R2 Lum Lv 04 NR Gain*/
	0x363d,
	0x3738, /*Outdoor 113d : R2 Lum Lv 05 NR Gain*/
	0x383e,
	0x3968, /*Outdoor 113e : R2 Lum Lv 06 NR Gain*/
	0x3a3f,
	0x3b68, /*Outdoor 113f : R2 Lum Lv 07 NR Gain*/
	0x3c40,
	0x3d68, /*Outdoor 1140 : R2 Lum Lv 08 NR Gain*/
	0x3e41,
	0x3f1a, /*Outdoor 1141 : R2 Lum Lv 01 NR offset*/
	0x4042,
	0x411a, /*Outdoor 1142 : R2 Lum Lv 02 NR offset*/
	0x4243,
	0x431a, /*Outdoor 1143 : R2 Lum Lv 03 NR offset*/
	0x4444,
	0x4530, /*Outdoor 1144 : R2 Lum Lv 04 NR offset*/
	0x4645,
	0x4730, /*Outdoor 1145 : R2 Lum Lv 05 NR offset*/
	0x4846,
	0x4940, /*Outdoor 1146 : R2 Lum Lv 06 NR offset*/
	0x4a47,
	0x4b40, /*Outdoor 1147 : R2 Lum Lv 07 NR offset*/
	0x4c48,
	0x4d40, /*Outdoor 1148 : R2 Lum Lv 08 NR offset*/
	0x4e49,
	0x4ff0, /*Outdoor 1149*/
	0x504a,
	0x51f0, /*Outdoor 114a*/
	0x524b,
	0x53f0, /*Outdoor 114b*/
	0x544c,
	0x55f0, /*Outdoor 114c*/
	0x564d,
	0x57f0, /*Outdoor 114d*/
	0x584e,
	0x59f0, /*Outdoor 114e*/
	0x5a4f,
	0x5bf0, /*Outdoor 114f*/
	0x5c50,
	0x5df0, /*Outdoor 1150*/
	0x5e51,
	0x5f60, /*Outdoor 1151*/
	0x6052,
	0x6160, /*Outdoor 1152*/
	0x6253,
	0x6360, /*Outdoor 1153*/
	0x6454,
	0x6560, /*Outdoor 1154*/
	0x6655,
	0x6760, /*Outdoor 1155*/
	0x6856,
	0x6960, /*Outdoor 1156*/
	0x6a57,
	0x6b60, /*Outdoor 1157*/
	0x6c58,
	0x6d60, /*Outdoor 1158*/
	0x6e59,
	0x6f80, /*Outdoor 1159*/
	0x705a,
	0x7180, /*Outdoor 115a*/
	0x725b,
	0x7380, /*Outdoor 115b*/
	0x745c,
	0x7580, /*Outdoor 115c*/
	0x765d,
	0x7780, /*Outdoor 115d*/
	0x785e,
	0x7980, /*Outdoor 115e*/
	0x7a5f,
	0x7b80, /*Outdoor 115f*/
	0x7c60,
	0x7d80, /*Outdoor 1160*/
	0x7e61,
	0x7ff0, /*Outdoor 1161*/
	0x8062,
	0x81fc, /*Outdoor 1162*/
	0x8263,
	0x8360, /*Outdoor 1163*/
	0x8464,
	0x8520, /*Outdoor 1164*/
	0x8665,
	0x8724, /*Outdoor 1165 Imp Lv1 Hi Gain*/
	0x8866,
	0x8924, /*Outdoor 1166 Imp Lv1 Middle Gain*/
	0x8a67,
	0x8b1a, /*Outdoor 1167 Imp Lv1 Low Gain*/
	0x8c68,
	0x8d5a, /*Outdoor 1168*/
	0x8e69,
	0x8f24, /*Outdoor 1169*/
	0x906a,
	0x9124, /*Outdoor 116a Imp Lv2 Hi Gain*/
	0x926b,
	0x9324, /*Outdoor 116b Imp Lv2 Middle Gain*/
	0x946c,
	0x951a, /*Outdoor 116c Imp Lv2 Low Gain*/
	0x966d,
	0x975c, /*Outdoor 116d*/
	0x986e,
	0x9920, /*Outdoor 116e*/
	0x9a6f,
	0x9b26, /*Outdoor 116f Imp Lv3 Hi Gain*/
	0x9c70,
	0x9d26, /*Outdoor 1170 Imp Lv3 Middle Gain*/
	0x9e71,
	0x9f30, /*Outdoor 1171 Imp Lv3 Low Gain*/
	0xa072,
	0xa15c, /*Outdoor 1172*/
	0xa273,
	0xa320, /*Outdoor 1173*/
	0xa474,
	0xa590, /*Outdoor 1174 Imp Lv4 Hi Gain*/
	0xa675,
	0xa790, /*Outdoor 1175 Imp Lv4 Middle Gain*/
	0xa876,
	0xa980, /*Outdoor 1176 Imp Lv4 Low Gain*/
	0xaa77,
	0xab40, /*Outdoor 1177*/
	0xac78,
	0xad26, /*Outdoor 1178*/
	0xae79,
	0xaf90, /*Outdoor 1179 Imp Lv5 Hi Gain*/
	0xb07a,
	0xb190, /*Outdoor 117a Imp Lv5 Middle Gain*/
	0xb27b,
	0xb380, /*Outdoor 117b Imp Lv5 Low Gain*/
	0xb47c,
	0xb538, /*Outdoor 117c*/
	0xb67d,
	0xb71c, /*Outdoor 117d*/
	0xb87e,
	0xb968, /*Outdoor 117e Imp Lv6 Hi Gain*/
	0xba7f,
	0xbb58, /*Outdoor 117f Imp Lv6 Middle Gain*/
	0xbc80,
	0xbd48, /*Outdoor 1180 Imp Lv6 Low Gain*/
	0xbe81,
	0xbf32, /*Outdoor 1181*/
	0xc082,
	0xc110, /*Outdoor 1182*/
	0xc283,
	0xc368, /*Outdoor 1183 Imp Lv7 Hi Gain*/
	0xc484,
	0xc558, /*Outdoor 1184 Imp Lv7 Middle Gain*/
	0xc685,
	0xc748, /*Outdoor 1185 Imp Lv7 Low Gain*/
	0xc886,
	0xc91c, /*Outdoor 1186*/
	0xca87,
	0xcb08, /*Outdoor 1187*/
	0xcc88,
	0xcd64, /*Outdoor 1188*/
	0xce89,
	0xcf64, /*Outdoor 1189*/
	0xd08a,
	0xd148, /*Outdoor 118a*/
	0xd290,
	0xd302, /*Outdoor 1190*/
	0xd491,
	0xd548, /*Outdoor 1191*/
	0xd692,
	0xd700, /*Outdoor 1192*/
	0xd893,
	0xd904, /*Outdoor 1193*/
	0xda94,
	0xdb02, /*Outdoor 1194*/
	0xdc95,
	0xdd64, /*Outdoor 1195*/
	0xde96,
	0xdf14, /*Outdoor 1196*/
	0xe097,
	0xe190, /*Outdoor 1197*/
	0xe2b0,
	0xe360, /*Outdoor 11b0*/
	0xe4b1,
	0xe590, /*Outdoor 11b1*/
	0xe6b2,
	0xe710, /*Outdoor 11b2*/
	0xe8b3,
	0xe908, /*Outdoor 11b3*/
	0xeab4,
	0xeb04, /*Outdoor 11b4*/
	0xec03,
	0xed12,
	0xee10,
	0xef03, /*Outdoor 1210*/
	0xf011,
	0xf129, /*Outdoor 1211*/
	0xf212,
	0xf330, /*Outdoor 1212*/
	0xf440,
	0xf537, /*Outdoor 1240*/
	0xf641,
	0xf724, /*Outdoor 1241*/
	0xf842,
	0xf900, /*Outdoor 1242*/
	0xfa43,
	0xfb62, /*Outdoor 1243*/
	0xfc44,
	0xfd02, /*Outdoor 1244*/
	0x0e00, /*burst_end*/
	0x03db,
	0x0e01, /*burst_start*/
	0x1045,
	0x110a, /*Outdoor 1245*/
	0x1246,
	0x1340, /*Outdoor 1246*/
	0x1460,
	0x1502, /*Outdoor 1260*/
	0x1661,
	0x1704, /*Outdoor 1261*/
	0x1862,
	0x194b, /*Outdoor 1262*/
	0x1a63,
	0x1b41, /*Outdoor 1263*/
	0x1c64,
	0x1d14, /*Outdoor 1264*/
	0x1e65,
	0x1f00, /*Outdoor 1265*/
	0x2068,
	0x210a, /*Outdoor 1268*/
	0x2269,
	0x2304, /*Outdoor 1269*/
	0x246a,
	0x250a, /*Outdoor 126a*/
	0x266b,
	0x270a, /*Outdoor 126b*/
	0x286c,
	0x2924, /*Outdoor 126c*/
	0x2a6d,
	0x2b01, /*Outdoor 126d*/
	0x2c70,
	0x2d01, /*Outdoor 1270*/
	0x2e71,
	0x2f3d, /*Outdoor 1271*/
	0x3080,
	0x3180, /*Outdoor 1280*/
	0x3281,
	0x338a, /*Outdoor 1281*/
	0x3482,
	0x350a, /*Outdoor 1282*/
	0x3683,
	0x3712, /*Outdoor 1283*/
	0x3884,
	0x39c8, /*Outdoor 1284*/
	0x3a85,
	0x3b92, /*Outdoor 1285*/
	0x3c86,
	0x3d20, /*Outdoor 1286*/
	0x3e87,
	0x3f00, /*Outdoor 1287*/
	0x4088,
	0x4170, /*Outdoor 1288 lmt center*/
	0x4289,
	0x43aa, /*Outdoor 1289*/
	0x448a,
	0x4550, /*Outdoor 128a*/
	0x468b,
	0x4710, /*Outdoor 128b*/
	0x488c,
	0x4904, /*Outdoor 128c*/
	0x4a8d,
	0x4b02, /*Outdoor 128d*/
	0x4ce6,
	0x4dff, /*Outdoor 12e6*/
	0x4ee7,
	0x4f18, /*Outdoor 12e7*/
	0x50e8,
	0x5120, /*Outdoor 12e8*/
	0x52e9,
	0x5304, /*Outdoor 12e9*/
	0x5403,
	0x5513,
	0x5610,
	0x573f, /*Outdoor 1310 Skin Color On*/
	0x5820,
	0x5920, /*Outdoor 1320*/
	0x5a21,
	0x5b30, /*Outdoor 1321*/
	0x5c22,
	0x5d36, /*Outdoor 1322*/
	0x5e23,
	0x5f6a, /*Outdoor 1323*/
	0x6024,
	0x61a0, /*Outdoor 1324*/
	0x6225,
	0x63c0, /*Outdoor 1325*/
	0x6426,
	0x65e0, /*Outdoor 1326*/
	0x6627,
	0x670a, /*Outdoor 1327*/
	0x6828,
	0x690a, /*Outdoor 1328*/
	0x6a29,
	0x6b0a, /*Outdoor 1329*/
	0x6c2a,
	0x6d08, /*Outdoor 132a*/
	0x6e2b,
	0x6f06, /*Outdoor 132b*/
	0x702c,
	0x7105, /*Outdoor 132c*/
	0x722d,
	0x7304, /*Outdoor 132d*/
	0x742e,
	0x7503, /*Outdoor 132e*/
	0x762f,
	0x7701, /*Outdoor 132f weight skin*/
	0x7830,
	0x7902, /*Outdoor 1330 weight blue*/
	0x7a31,
	0x7b78, /*Outdoor 1331 weight green*/
	0x7c32,
	0x7d01, /*Outdoor 1332 weight strong color*/
	0x7e33,
	0x7f80, /*Outdoor 1333*/
	0x8034,
	0x81f0, /*Outdoor 1334*/
	0x8235,
	0x8310, /*Outdoor 1335*/
	0x8436,
	0x85f0, /*Outdoor 1336*/
	0x86a0,
	0x8707, /*Outdoor 13a0*/
	0x88a8,
	0x8924, /*Outdoor 13a8 Outdoor Cb-filter*/
	0x8aa9,
	0x8b24, /*Outdoor 13a9 Outdoor Cr-filter*/
	0x8caa,
	0x8d20, /*Outdoor 13aa*/
	0x8eab,
	0x8f02, /*Outdoor 13ab*/
	0x90c0,
	0x9127, /*Outdoor 13c0*/
	0x92c2,
	0x9308, /*Outdoor 13c2*/
	0x94c3,
	0x9508, /*Outdoor 13c3*/
	0x96c4,
	0x9740, /*Outdoor 13c4 Green Detect*/
	0x98c5,
	0x9978, /*Outdoor 13c5*/
	0x9ac6,
	0x9bf0, /*Outdoor 13c6*/
	0x9cc7,
	0x9d10, /*Outdoor 13c7*/
	0x9ec8,
	0x9f44, /*Outdoor 13c8*/
	0xa0c9,
	0xa187, /*Outdoor 13c9*/
	0xa2ca,
	0xa3ff, /*Outdoor 13ca*/
	0xa4cb,
	0xa520, /*Outdoor 13cb*/
	0xa6cc,
	0xa761, /*Outdoor 13cc skin range_cb_l*/
	0xa8cd,
	0xa987, /*Outdoor 13cd skin range_cb_h*/
	0xaace,
	0xab8a, /*Outdoor 13ce skin range_cr_l*/
	0xaccf,
	0xada5, /*Outdoor 13cf skin range_cr_h*/
	0xae03,
	0xaf14,
	0xb011,
	0xb102, /*Outdoor 1410*/
	0xb211,
	0xb302, /*Outdoor 1411*/
	0xb412,
	0xb560, /*Outdoor 1412 Top H_Clip*/
	0xb613,
	0xb762, /*Outdoor 1413*/
	0xb814,
	0xb920, /*Outdoor 1414*/
	0xba15,
	0xbb30, /*Outdoor 1415 sharp positive ya*/
	0xbc16,
	0xbd30, /*Outdoor 1416 sharp positive mi*/
	0xbe17,
	0xbf30, /*Outdoor 1417 sharp positive low*/
	0xc018,
	0xc154, /*Outdoor 1418 sharp negative ya*/
	0xc219,
	0xc354, /*Outdoor 1419 sharp negative mi*/
	0xc41a,
	0xc540, /*Outdoor 141a sharp negative low*/
	0xc620,
	0xc7d2, /*Outdoor 1420*/
	0xc821,
	0xc903, /*Outdoor 1421*/
	0xca22,
	0xcb04, /*Outdoor 1422*/
	0xcc23,
	0xcd04, /*Outdoor 1423*/
	0xce24,
	0xcf05, /*Outdoor 1424*/
	0xd025,
	0xd132, /*Outdoor 1425*/
	0xd226,
	0xd330, /*Outdoor 1426*/
	0xd427,
	0xd520, /*Outdoor 1427*/
	0xd628,
	0xd73c, /*Outdoor 1428*/
	0xd829,
	0xd900, /*Outdoor 1429*/
	0xda2a,
	0xdb16, /*Outdoor 142a S_Diff Hi Dr_Gain*/
	0xdc2b,
	0xdd16, /*Outdoor 142b S_Diff Middle Dr_Gain*/
	0xde2c,
	0xdf16, /*Outdoor 142c S_Diff Low Dr_Gain*/
	0xe02d,
	0xe154, /*Outdoor 142d*/
	0xe22e,
	0xe354, /*Outdoor 142e*/
	0xe42f,
	0xe554, /*Outdoor 142f*/
	0xe630,
	0xe782, /*Outdoor 1430*/
	0xe831,
	0xe902, /*Outdoor 1431*/
	0xea32,
	0xeb04, /*Outdoor 1432*/
	0xec33,
	0xed04, /*Outdoor 1433*/
	0xee34,
	0xef0a, /*Outdoor 1434*/
	0xf035,
	0xf146, /*Outdoor 1435*/
	0xf236,
	0xf332, /*Outdoor 1436*/
	0xf437,
	0xf528, /*Outdoor 1437*/
	0xf638,
	0xf712, /*Outdoor 1438*/
	0xf839,
	0xf900, /*Outdoor 1439*/
	0xfa3a,
	0xfb24, /*Outdoor 143a L_Diff Hi Dr_Gain*/
	0xfc3b,
	0xfd24, /*Outdoor 143b L_Diff Middle Dr_Gain*/
	0x0e00, /*burst_end*/
	0x03dc,
	0x0e01, /*burst_start*/
	0x103c,
	0x1124, /*Outdoor 143c L_Diff Low Dr_Gain*/
	0x123d,
	0x1324, /*Outdoor 143d L_Diff Hi_Normal Gain*/
	0x143e,
	0x1524, /*Outdoor 143e L_Diff Middle_Normal Gain*/
	0x163f,
	0x1714, /*Outdoor 143f L_Diff Low_Normal Gain*/
	0x1840,
	0x1982, /*Outdoor 1440*/
	0x1a41,
	0x1b1a, /*Outdoor 1441 H Clip*/
	0x1c42,
	0x1d70, /*Outdoor 1442*/
	0x1e43,
	0x1f20, /*Outdoor 1443*/
	0x2044,
	0x2126, /*Outdoor 1444 M_Diff Hi Dr_Gain*/
	0x2245,
	0x231e, /*Outdoor 1445 M_Diff Low Dr_Gain*/
	0x2446,
	0x2524, /*Outdoor 1446 M_Diff Middle Dr_Gain*/
	0x2647,
	0x2718, /*Outdoor 1447*/
	0x2848,
	0x290a, /*Outdoor 1448*/
	0x2a49,
	0x2b10, /*Outdoor 1449*/
	0x2c50,
	0x2d82, /*Outdoor 1450*/
	0x2e51,
	0x2f38, /*Outdoor 1451*/
	0x3052,
	0x31f0, /*Outdoor 1452*/
	0x3253,
	0x3378, /*Outdoor 1453*/
	0x3454,
	0x3524, /*Outdoor 1454*/
	0x3655,
	0x3724, /*Outdoor 1455*/
	0x3856,
	0x3924, /*Outdoor 1456*/
	0x3a57,
	0x3b10, /*Outdoor 1457*/
	0x3c58,
	0x3d14, /*Outdoor 1458*/
	0x3e59,
	0x3f10, /*Outdoor 1459*/
	0x4060,
	0x4101, /*Outdoor 1460 skin opt*/
	0x4261,
	0x43a0, /*Outdoor 1461*/
	0x4462,
	0x4598, /*Outdoor 1462*/
	0x4663,
	0x47e4, /*Outdoor 1463 skin_std_th_h*/
	0x4864,
	0x49a4, /*Outdoor 1464 skin_std_th_l*/
	0x4a65,
	0x4b7d, /*Outdoor 1465 sharp_std_th_h*/
	0x4c66,
	0x4d4b, /*Outdoor 1466 sharp_std_th_l*/
	0x4e70,
	0x4f10, /*Outdoor 1470*/
	0x5071,
	0x5110, /*Outdoor 1471*/
	0x5272,
	0x5310, /*Outdoor 1472*/
	0x5473,
	0x5510, /*Outdoor 1473*/
	0x5674,
	0x5710, /*Outdoor 1474*/
	0x5875,
	0x5910, /*Outdoor 1475*/
	0x5a76,
	0x5b38, /*Outdoor 1476 green sharp pos High*/
	0x5c77,
	0x5d38, /*Outdoor 1477 green sharp pos Middle*/
	0x5e78,
	0x5f38, /*Outdoor 1478 green sharp pos Low*/
	0x6079,
	0x6158, /*Outdoor 1479 green sharp nega High*/
	0x627a,
	0x6358, /*Outdoor 147a green sharp nega Middle*/
	0x647b,
	0x6558, /*Outdoor 147b green sharp nega Low*/
	0x6603,
	0x6710, /*10 page*/
	0x6860,
	0x6903, /*1060*/
	0x6a70,
	0x6b0c, /*1070*/
	0x6c71,
	0x6d00, /*1071*/
	0x6e72,
	0x6f7a, /*1072*/
	0x7073,
	0x7128, /*1073*/
	0x7274,
	0x7314, /*1074*/
	0x7475,
	0x750d, /*1075*/
	0x7676,
	0x7740, /*1076*/
	0x7877,
	0x7949, /*1077*/
	0x7a78,
	0x7b99, /*1078*/
	0x7c79,
	0x7d4c, /*1079*/
	0x7e7a,
	0x7fcc, /*107a*/
	0x807b,
	0x8149, /*107b*/
	0x827c,
	0x8399, /*107c*/
	0x847d,
	0x8514, /*107d*/
	0x867e,
	0x8728, /*107e*/
	0x887f,
	0x8950, /*107f*/
	0x8a03, /*16 page*/
	0x8b16,
	0x8c8a, /*168a*/
	0x8d68,
	0x8e8b, /*168b*/
	0x8f7c,
	0x908c, /*168c*/
	0x917f,
	0x928d, /*168d*/
	0x937f,
	0x948e, /*168e*/
	0x957f,
	0x968f, /*168f*/
	0x977f,
	0x9890, /*1690*/
	0x997f,
	0x9a91, /*1691*/
	0x9b7f,
	0x9c92, /*1692*/
	0x9d7f,
	0x0e00, /*burst_end*/
/*////////////////*/
/* dd Page (DMA Indoor)*/
/*////////////////*/
	0x03dd,
	0x0e01, /*burst_start*/
	0x1003,
	0x1111,
	0x1210,
	0x1313, /*Indoor 1110*/
	0x1411,
	0x1508, /*Indoor 1111*/
	0x1612,
	0x171e, /*Indoor 1112*/
	0x1813,
	0x190e, /*Indoor 1113*/
	0x1a14,
	0x1b31, /*Indoor 1114*/
	0x1c30,
	0x1d20, /*Indoor 1130*/
	0x1e31,
	0x1f20, /*Indoor 1131*/
	0x2032,
	0x2152, /*Indoor 1132*/
	0x2233,
	0x233b, /*Indoor 1133*/
	0x2434,
	0x251d, /*Indoor 1134*/
	0x2635,
	0x2721, /*Indoor 1135*/
	0x2836,
	0x291b, /*Indoor 1136*/
	0x2a37,
	0x2b21, /*Indoor 1137*/
	0x2c38,
	0x2d18, /*Indoor 1138*/
	0x2e39,
	0x2f18, /*Indoor 1139 R2 lvl1 gain*/
	0x303a,
	0x3118, /*Indoor 113a R2 lvl2 gain*/
	0x323b,
	0x3318, /*Indoor 113b R2 lvl3 gain*/
	0x343c,
	0x351a, /*Indoor 113c R2 lvl4 gain*/
	0x363d,
	0x371a, /*Indoor 113d R2 lvl5 gain*/
	0x383e,
	0x3920, /*Indoor 113e R2 lvl6 gain*/
	0x3a3f,
	0x3b22, /*Indoor 113f R2 lvl7 gain*/
	0x3c40,
	0x3d20, /*Indoor 1140 R2 lvl8 gain*/
	0x3e41,
	0x3f10, /*Indoor 1141 R2 Lvl1 offset*/
	0x4042,
	0x4110, /*Indoor 1142 R2 Lvl2 offset*/
	0x4243,
	0x4310, /*Indoor 1143 R2 Lvl3 offset*/
	0x4444,
	0x4510, /*Indoor 1144 R2 Lvl4 offset*/
	0x4645,
	0x4718, /*Indoor 1145 R2 Lvl5 offset*/
	0x4846,
	0x4918, /*Indoor 1146 R2 Lvl6 offset*/
	0x4a47,
	0x4b40, /*Indoor 1147 R2 Lvl7 offset*/
	0x4c48,
	0x4d40, /*Indoor 1148 R2 Lvl8 offset*/
	0x4e49,
	0x4fe0, /*Indoor 1149 Lv1 h_clip*/
	0x504a,
	0x51f0, /*Indoor 114a Lv2 h_clip*/
	0x524b,
	0x53fc, /*Indoor 114b Lv3 h_clip*/
	0x544c,
	0x55fc, /*Indoor 114c Lv4 h_clip*/
	0x564d,
	0x57fc, /*Indoor 114d Lv5 h_clip*/
	0x584e,
	0x59f0, /*Indoor 114e Lv6 h_clip*/
	0x5a4f,
	0x5bf0, /*Indoor 114f Lv7 h_clip*/
	0x5c50,
	0x5df0, /*Indoor 1150 Lv8 h_clip*/
	0x5e51,
	0x5f68, /*Indoor 1151 color gain start*/
	0x6052,
	0x6168, /*Indoor 1152*/
	0x6253,
	0x6368, /*Indoor 1153*/
	0x6454,
	0x6568, /*Indoor 1154*/
	0x6655,
	0x6768, /*Indoor 1155*/
	0x6856,
	0x6968, /*Indoor 1156*/
	0x6a57,
	0x6b68, /*Indoor 1157*/
	0x6c58,
	0x6d68, /*Indoor 1158 color gain end*/
	0x6e59,
	0x6f70, /*Indoor 1159 color ofs lmt start*/
	0x705a,
	0x7170, /*Indoor 115a*/
	0x725b,
	0x7370, /*Indoor 115b*/
	0x745c,
	0x7570, /*Indoor 115c*/
	0x765d,
	0x7770, /*Indoor 115d*/
	0x785e,
	0x7970, /*Indoor 115e*/
	0x7a5f,
	0x7b70, /*Indoor 115f*/
	0x7c60,
	0x7d70, /*Indoor 1160 color ofs lmt end*/
	0x7e61,
	0x7fc0, /*Indoor 1161*/
	0x8062,
	0x81f0, /*Indoor 1162*/
	0x8263,
	0x8380, /*Indoor 1163*/
	0x8464,
	0x8540, /*Indoor 1164*/
	0x8665,
	0x8780, /*Indoor 1165*/
	0x8866,
	0x8980, /*Indoor 1166*/
	0x8a67,
	0x8b80, /*Indoor 1167*/
	0x8c68,
	0x8d80, /*Indoor 1168*/
	0x8e69,
	0x8f40, /*Indoor 1169*/
	0x906a,
	0x9180, /*Indoor 116a Imp Lv2 High Gain*/
	0x926b,
	0x9380, /*Indoor 116b Imp Lv2 Middle Gain*/
	0x946c,
	0x9580, /*Indoor 116c Imp Lv2 Low Gain*/
	0x966d,
	0x9780, /*Indoor 116d*/
	0x986e,
	0x9940, /*Indoor 116e*/
	0x9a6f,
	0x9b80, /*Indoor 116f Imp Lv3 Hi Gain*/
	0x9c70,
	0x9d60, /*Indoor 1170 Imp Lv3 Middle Gain*/
	0x9e71,
	0x9f40, /*Indoor 1171 Imp Lv3 Low Gain*/
	0xa072,
	0xa16e, /*Indoor 1172*/
	0xa273,
	0xa33a, /*Indoor 1173*/
	0xa474,
	0xa580, /*Indoor 1174 Imp Lv4 Hi Gain*/
	0xa675,
	0xa780, /*Indoor 1175 Imp Lv4 Middle Gain*/
	0xa876,
	0xa940, /*Indoor 1176 Imp Lv4 Low Gain*/
	0xaa77,
	0xab6e, /*Indoor 1177 Imp Lv5 Hi Th*/
	0xac78,
	0xad66, /*Indoor 1178 Imp Lv5 Middle Th*/
	0xae79,
	0xaf60, /*Indoor 1179 Imp Lv5 Hi Gain*/
	0xb07a,
	0xb130, /*Indoor 117a Imp Lv5 Middle Gain*/
	0xb27b,
	0xb320, /*Indoor 117b Imp Lv5 Low Gain*/
	0xb47c,
	0xb55c, /*Indoor 117c Imp Lv6 Hi Th*/
	0xb67d,
	0xb730, /*Indoor 117d Imp Lv6 Middle Th*/
	0xb87e,
	0xb960, /*Indoor 117e Imp Lv6 Hi Gain*/
	0xba7f,
	0xbb60, /*Indoor 117f Imp Lv6 Middle Gain*/
	0xbc80,
	0xbd20, /*Indoor 1180 Imp Lv6 Low Gain*/
	0xbe81,
	0xbf62, /*Indoor 1181*/
	0xc082,
	0xc126, /*Indoor 1182*/
	0xc283,
	0xc360, /*Indoor 1183 Imp Lv7 Hi Gain*/
	0xc484,
	0xc560, /*Indoor 1184 Imp Lv7 Middle Gain*/
	0xc685,
	0xc760, /*Indoor 1185 Imp Lv7 Low Gain*/
	0xc886,
	0xc962, /*Indoor 1186*/
	0xca87,
	0xcb26, /*Indoor 1187*/
	0xcc88,
	0xcd60, /*Indoor 1188*/
	0xce89,
	0xcf60, /*Indoor 1189*/
	0xd08a,
	0xd160, /*Indoor 118a*/
	0xd290,
	0xd300, /*Indoor 1190*/
	0xd491,
	0xd54e, /*Indoor 1191*/
	0xd692,
	0xd700, /*Indoor 1192*/
	0xd893,
	0xd916, /*Indoor 1193*/
	0xda94,
	0xdb01, /*Indoor 1194*/
	0xdc95,
	0xdd80, /*Indoor 1195*/
	0xde96,
	0xdf55, /*Indoor 1196*/
	0xe097,
	0xe18d, /*Indoor 1197*/
	0xe2b0,
	0xe360, /*Indoor 11b0*/
	0xe4b1,
	0xe5b0, /*Indoor 11b1*/
	0xe6b2,
	0xe788, /*Indoor 11b2*/
	0xe8b3,
	0xe910, /*Indoor 11b3*/
	0xeab4,
	0xeb04, /*Indoor 11b4*/
	0xec03,
	0xed12,
	0xee10,
	0xef03, /*Indoor 1210*/
	0xf011,
	0xf129, /*Indoor 1211*/
	0xf212,
	0xf308, /*Indoor 1212*/
	0xf440,
	0xf533, /*Indoor 1240*/
	0xf641,
	0xf70a, /*Indoor 1241*/
	0xf842,
	0xf96a, /*Indoor 1242*/
	0xfa43,
	0xfb80, /*Indoor 1243*/
	0xfc44,
	0xfd02, /*Indoor 1244*/
	0x0e00, /*burst_end*/
	0x03de,
	0x0e01, /*burst_start*/
	0x1045,
	0x110a, /*Indoor 1245*/
	0x1246,
	0x1380, /*Indoor 1246*/
	0x1460,
	0x1521, /*Indoor 1260*/
	0x1661,
	0x170e, /*Indoor 1261*/
	0x1862,
	0x1970, /*Indoor 1262*/
	0x1a63,
	0x1b70, /*Indoor 1263*/
	0x1c64,
	0x1d14, /*Indoor 1264*/
	0x1e65,
	0x1f01, /*Indoor 1265*/
	0x2068,
	0x210a, /*Indoor 1268*/
	0x2269,
	0x2304, /*Indoor 1269*/
	0x246a,
	0x250a, /*Indoor 126a*/
	0x266b,
	0x270a, /*Indoor 126b*/
	0x286c,
	0x2924, /*Indoor 126c*/
	0x2a6d,
	0x2b01, /*Indoor 126d*/
	0x2c70,
	0x2d01, /*Indoor 1270*/
	0x2e71,
	0x2f3d, /*Indoor 1271*/
	0x3080,
	0x3180, /*Indoor 1280*/
	0x3281,
	0x3388, /*Indoor 1281*/
	0x3482,
	0x3508, /*Indoor 1282*/
	0x3683,
	0x370c, /*Indoor 1283*/
	0x3884,
	0x3990, /*Indoor 1284*/
	0x3a85,
	0x3b92, /*Indoor 1285*/
	0x3c86,
	0x3d20, /*Indoor 1286*/
	0x3e87,
	0x3f00, /*Indoor 1287*/
	0x4088,
	0x4170, /*Indoor 1288*/
	0x4289,
	0x43aa, /*Indoor 1289*/
	0x448a,
	0x4550, /*Indoor 128a*/
	0x468b,
	0x4710, /*Indoor 128b*/
	0x488c,
	0x4904, /*Indoor 128c*/
	0x4a8d,
	0x4b02, /*Indoor 128d*/
	0x4ce6,
	0x4dff, /*Indoor 12e6*/
	0x4ee7,
	0x4f18, /*Indoor 12e7*/
	0x50e8,
	0x5120, /*Indoor 12e8*/
	0x52e9,
	0x5306, /*Indoor 12e9*/
	0x5403,
	0x5513,
	0x5610,
	0x5733, /*Indoor 1310*/
	0x5820,
	0x5920, /*Indoor 1320*/
	0x5a21,
	0x5b30, /*Indoor 1321*/
	0x5c22,
	0x5d36, /*Indoor 1322*/
	0x5e23,
	0x5f6a, /*Indoor 1323*/
	0x6024,
	0x61a0, /*Indoor 1324*/
	0x6225,
	0x63c0, /*Indoor 1325*/
	0x6426,
	0x65e0, /*Indoor 1326*/
	0x6627,
	0x6702, /*Indoor 1327*/
	0x6828,
	0x6903, /*Indoor 1328*/
	0x6a29,
	0x6b03, /*Indoor 1329*/
	0x6c2a,
	0x6d10, /*Indoor 132a*/
	0x6e2b,
	0x6f10, /*Indoor 132b*/
	0x702c,
	0x7104, /*Indoor 132c*/
	0x722d,
	0x7303, /*Indoor 132d*/
	0x742e,
	0x7503, /*Indoor 132e*/
	0x762f,
	0x7718, /*Indoor 132f*/
	0x7830,
	0x7903, /*Indoor 1330*/
	0x7a31,
	0x7b03, /*Indoor 1331*/
	0x7c32,
	0x7d03, /*Indoor 1332*/
	0x7e33,
	0x7f40, /*Indoor 1333*/
	0x8034,
	0x8180, /*Indoor 1334*/
	0x8235,
	0x8300, /*Indoor 1335*/
	0x8436,
	0x85f0, /*Indoor 1336*/
	0x86a0,
	0x8707, /*Indoor 13a0*/
	0x88a8,
	0x8924, /*Indoor 13a8 Cb_Filter*/
	0x8aa9,
	0x8b24, /*Indoor 13a9 Cr_Filter*/
	0x8caa,
	0x8d20, /*Indoor 13aa*/
	0x8eab,
	0x8f02, /*Indoor 13ab*/
	0x90c0,
	0x9127, /*Indoor 13c0*/
	0x92c2,
	0x9308, /*Indoor 13c2*/
	0x94c3,
	0x9508, /*Indoor 13c3*/
	0x96c4,
	0x9740, /*Indoor 13c4*/
	0x98c5,
	0x9938, /*Indoor 13c5*/
	0x9ac6,
	0x9bf0, /*Indoor 13c6*/
	0x9cc7,
	0x9d10, /*Indoor 13c7*/
	0x9ec8,
	0x9f44, /*Indoor 13c8*/
	0xa0c9,
	0xa187, /*Indoor 13c9*/
	0xa2ca,
	0xa3ff, /*Indoor 13ca*/
	0xa4cb,
	0xa520, /*Indoor 13cb*/
	0xa6cc,
	0xa761, /*Indoor 13cc*/
	0xa8cd,
	0xa987, /*Indoor 13cd*/
	0xaace,
	0xab8a, /*Indoor 13ce*/
	0xaccf,
	0xada5, /*Indoor 13cf*/
	0xae03,
	0xaf14,
	0xb011,
	0xb102, /*Indoor 1410*/
	0xb211,
	0xb302, /*Indoor 1411 TOP L_clip*/
	0xb412,
	0xb540, /*Indoor 1412*/
	0xb613,
	0xb798, /*Indoor 1413*/
	0xb814,
	0xb93a, /*Indoor 1414*/
	0xba15,
	0xbb30, /*Indoor 1415*/
	0xbc16,
	0xbd30, /*Indoor 1416*/
	0xbe17,
	0xbf30, /*Indoor 1417*/
	0xc018,
	0xc158, /*Indoor 1418  Negative High Gain*/
	0xc219,
	0xc360, /*Indoor 1419  Negative Middle Gain*/
	0xc41a,
	0xc560, /*Indoor 141a  Negative Low Gain*/
	0xc620,
	0xc782, /*Indoor 1420  s_diff L_clip*/
	0xc821,
	0xc903, /*Indoor 1421*/
	0xca22,
	0xcb05, /*Indoor 1422*/
	0xcc23,
	0xcd07, /*Indoor 1423*/
	0xce24,
	0xcf0a, /*Indoor 1424*/
	0xd025,
	0xd146, /*Indoor 1425*/
	0xd226,
	0xd332, /*Indoor 1426*/
	0xd427,
	0xd51e, /*Indoor 1427*/
	0xd628,
	0xd710, /*Indoor 1428*/
	0xd829,
	0xd900, /*Indoor 1429*/
	0xda2a,
	0xdb18, /*Indoor 142a*/
	0xdc2b,
	0xdd18, /*Indoor 142b*/
	0xde2c,
	0xdf18, /*Indoor 142c*/
	0xe02d,
	0xe130, /*Indoor 142d*/
	0xe22e,
	0xe330, /*Indoor 142e*/
	0xe42f,
	0xe530, /*Indoor 142f*/
	0xe630,
	0xe782, /*Indoor 1430 Ldiff_L_cip*/
	0xe831,
	0xe902, /*Indoor 1431*/
	0xea32,
	0xeb04, /*Indoor 1432*/
	0xec33,
	0xed04, /*Indoor 1433*/
	0xee34,
	0xef0a, /*Indoor 1434*/
	0xf035,
	0xf146, /*Indoor 1435*/
	0xf236,
	0xf332, /*Indoor 1436*/
	0xf437,
	0xf528, /*Indoor 1437*/
	0xf638,
	0xf712, /*Indoor 1438*/
	0xf839,
	0xf900, /*Indoor 1439*/
	0xfa3a,
	0xfb20, /*Indoor 143a*/
	0xfc3b,
	0xfd30, /*Indoor 143b*/
	0x0e00, /*burst_end*/
	0x03df,
	0x0e01, /*burst_start*/
	0x103c,
	0x1120, /*Indoor 143c*/
	0x123d,
	0x1318, /*Indoor 143d*/
	0x143e,
	0x1528, /*Indoor 143e*/
	0x163f,
	0x1714, /*Indoor 143f*/
	0x1840,
	0x1984, /*Indoor 1440  Mdiff Low Clip*/
	0x1a41,
	0x1b10, /*Indoor 1441*/
	0x1c42,
	0x1d70, /*Indoor 1442*/
	0x1e43,
	0x1f20, /*Indoor 1443*/
	0x2044,
	0x2118, /*Indoor 1444*/
	0x2245,
	0x2318, /*Indoor 1445*/
	0x2446,
	0x2510, /*Indoor 1446*/
	0x2647,
	0x2718, /*Indoor 1447*/
	0x2848,
	0x290a, /*Indoor 1448*/
	0x2a49,
	0x2b10, /*Indoor 1449*/
	0x2c50,
	0x2d84, /*Indoor 1450 Hdiff Low Clip*/
	0x2e51,
	0x2f30, /*Indoor 1451 hclip*/
	0x3052,
	0x31b0, /*Indoor 1452*/
	0x3253,
	0x3337, /*Indoor 1453*/
	0x3454,
	0x3533, /*Indoor 1454*/
	0x3655,
	0x3733, /*Indoor 1455*/
	0x3856,
	0x3933, /*Indoor 1456*/
	0x3a57,
	0x3b10, /*Indoor 1457*/
	0x3c58,
	0x3d20, /*Indoor 1458*/
	0x3e59,
	0x3f20, /*Indoor 1459*/
	0x4060,
	0x4101, /*Indoor 1460*/
	0x4261,
	0x43a0, /*Indoor 1461*/
	0x4462,
	0x4598, /*Indoor 1462*/
	0x4663,
	0x47e4, /*Indoor 1463*/
	0x4864,
	0x49a4, /*Indoor 1464*/
	0x4a65,
	0x4b7d, /*Indoor 1465*/
	0x4c66,
	0x4d4b, /*Indoor 1466*/
	0x4e70,
	0x4f10, /*Indoor 1470*/
	0x5071,
	0x5110, /*Indoor 1471*/
	0x5272,
	0x5310, /*Indoor 1472*/
	0x5473,
	0x5510, /*Indoor 1473*/
	0x5674,
	0x5710, /*Indoor 1474*/
	0x5875,
	0x5910, /*Indoor 1475*/
	0x5a76,
	0x5b38, /*Indoor 1476    green sharp pos High*/
	0x5c77,
	0x5d38, /*Indoor 1477    green sharp pos Middle*/
	0x5e78,
	0x5f38, /*Indoor 1478    green sharp pos Low*/
	0x6079,
	0x6170, /*Indoor 1479    green sharp nega High*/
	0x627a,
	0x6370, /*Indoor 147a    green sharp nega Middle*/
	0x647b,
	0x6570, /*Indoor 147b    green sharp nega Low*/
	0x6603,
	0x6710, /*10 page*/
	0x6860,
	0x6903, /*1060*/
	0x6a70,
	0x6b0c, /*1070*/
	0x6c71,
	0x6d00, /*1071*/
	0x6e72,
	0x6f83, /*1072*/
	0x7073,
	0x7199, /*1073*/
	0x7274,
	0x731b, /*1074*/
	0x7475,
	0x750b, /*1075*/
	0x7676,
	0x773c, /*1076*/
	0x7877,
	0x7943, /*1077*/
	0x7a78,
	0x7b33, /*1078*/
	0x7c79,
	0x7d4c, /*1079*/
	0x7e7a,
	0x7fcc, /*107a*/
	0x807b,
	0x8149, /*107b*/
	0x827c,
	0x8399, /*107c*/
	0x847d,
	0x850e, /*107d*/
	0x867e,
	0x871e, /*107e*/
	0x887f,
	0x893c, /*107f*/
	0x8a03, /*16 page*/
	0x8b16,
	0x8c8a, /*168a*/
	0x8d68,
	0x8e8b, /*168b*/
	0x8f7c,
	0x908c, /*168c*/
	0x917f,
	0x928d, /*168d*/
	0x937f,
	0x948e, /*168e*/
	0x957f,
	0x968f, /*168f*/
	0x977f,
	0x9890, /*1690*/
	0x997f,
	0x9a91, /*1691*/
	0x9b7f,
	0x9c92, /*1692*/
	0x9d7f,
	0x0e00, /*burst_end*/
/*////////////////*/
/* e0 Page (DMA Dark1)*/
/*////////////////*/
	0x03e0,
	0x0e01, /*burst_start*/
	0x1003,
	0x1111,
	0x1210,
	0x1313, /*Dark1 1110*/
	0x1411,
	0x1508, /*Dark1 1111*/
	0x1612,
	0x171e, /*Dark1 1112*/
	0x1813,
	0x190e, /*Dark1 1113*/
	0x1a14,
	0x1b31, /*Dark1 1114*/
	0x1c30,
	0x1d20, /*Dark1 1130*/
	0x1e31,
	0x1f20, /*Dark1 1131*/
	0x2032,
	0x2152, /*Dark1 1132*/
	0x2233,
	0x233b, /*Dark1 1133*/
	0x2434,
	0x251d, /*Dark1 1134*/
	0x2635,
	0x2721, /*Dark1 1135*/
	0x2836,
	0x291b, /*Dark1 1136*/
	0x2a37,
	0x2b21, /*Dark1 1137*/
	0x2c38,
	0x2d18, /*Dark1 1138*/
	0x2e39,
	0x2f18, /*Dark1 1139 R2 lvl1 gain*/
	0x303a,
	0x3120, /*Dark1 113a R2 lvl2 gain*/
	0x323b,
	0x3328, /*Dark1 113b R2 lvl3 gain*/
	0x343c,
	0x3520, /*Dark1 113c R2 lvl4 gain*/
	0x363d,
	0x3720, /*Dark1 113d R2 lvl5 gain*/
	0x383e,
	0x391e, /*Dark1 113e R2 lvl6 gain*/
	0x3a3f,
	0x3b1e, /*Dark1 113f R2 lvl7 gain*/
	0x3c40,
	0x3d1e, /*Dark1 1140 R2 lvl8 gain*/
	0x3e41,
	0x3f10, /*Dark1 1141 R2 Lvl1 offset*/
	0x4042,
	0x4110, /*Dark1 1142 R2 Lvl2 offset*/
	0x4243,
	0x4320, /*Dark1 1143 R2 Lvl3 offset*/
	0x4444,
	0x452a, /*Dark1 1144 R2 Lvl4 offset*/
	0x4645,
	0x4730, /*Dark1 1145 R2 Lvl5 offset*/
	0x4846,
	0x4950, /*Dark1 1146 R2 Lvl6 offset*/
	0x4a47,
	0x4b40, /*Dark1 1147 R2 Lvl7 offset*/
	0x4c48,
	0x4d40, /*Dark1 1148 R2 Lvl8 offset*/
	0x4e49,
	0x4f60, /*Dark1 1149 Lv1 h_clip*/
	0x504a,
	0x5180, /*Dark1 114a Lv2 h_clip*/
	0x524b,
	0x53a0, /*Dark1 114b Lv3 h_clip*/
	0x544c,
	0x55a0, /*Dark1 114c Lv4 h_clip*/
	0x564d,
	0x57a0, /*Dark1 114d Lv5 h_clip*/
	0x584e,
	0x5990, /*Dark1 114e Lv6 h_clip*/
	0x5a4f,
	0x5b90, /*Dark1 114f Lv7 h_clip*/
	0x5c50,
	0x5d90, /*Dark1 1150 Lv8 h_clip*/
	0x5e51,
	0x5f68, /*Dark1 1151 color gain start*/
	0x6052,
	0x6168, /*Dark1 1152*/
	0x6253,
	0x6368, /*Dark1 1153*/
	0x6454,
	0x6568, /*Dark1 1154*/
	0x6655,
	0x6768, /*Dark1 1155*/
	0x6856,
	0x6968, /*Dark1 1156*/
	0x6a57,
	0x6b68, /*Dark1 1157*/
	0x6c58,
	0x6d68, /*Dark1 1158 color gain end*/
	0x6e59,
	0x6f70, /*Dark1 1159 color ofs lmt start*/
	0x705a,
	0x7170, /*Dark1 115a*/
	0x725b,
	0x7370, /*Dark1 115b*/
	0x745c,
	0x7570, /*Dark1 115c*/
	0x765d,
	0x7770, /*Dark1 115d*/
	0x785e,
	0x7970, /*Dark1 115e*/
	0x7a5f,
	0x7b70, /*Dark1 115f*/
	0x7c60,
	0x7d70, /*Dark1 1160 color ofs lmt end*/
	0x7e61,
	0x7fc0, /*Dark1 1161*/
	0x8062,
	0x81f0, /*Dark1 1162*/
	0x8263,
	0x8380, /*Dark1 1163*/
	0x8464,
	0x8540, /*Dark1 1164*/
	0x8665,
	0x8740, /*Dark1 1165*/
	0x8866,
	0x8940, /*Dark1 1166*/
	0x8a67,
	0x8b40, /*Dark1 1167*/
	0x8c68,
	0x8d80, /*Dark1 1168*/
	0x8e69,
	0x8f40, /*Dark1 1169*/
	0x906a,
	0x9140, /*Dark1 116a Imp Lv2 High Gain*/
	0x926b,
	0x9340, /*Dark1 116b Imp Lv2 Middle Gain*/
	0x946c,
	0x9540, /*Dark1 116c Imp Lv2 Low Gain*/
	0x966d,
	0x9780, /*Dark1 116d*/
	0x986e,
	0x9940, /*Dark1 116e*/
	0x9a6f,
	0x9b50, /*Dark1 116f Imp Lv3 Hi Gain*/
	0x9c70,
	0x9d50, /*Dark1 1170 Imp Lv3 Middle Gain*/
	0x9e71,
	0x9f50, /*Dark1 1171 Imp Lv3 Low Gain*/
	0xa072,
	0xa16e, /*Dark1 1172*/
	0xa273,
	0xa33a, /*Dark1 1173*/
	0xa474,
	0xa550, /*Dark1 1174 Imp Lv4 Hi Gain*/
	0xa675,
	0xa750, /*Dark1 1175 Imp Lv4 Middle Gain*/
	0xa876,
	0xa950, /*Dark1 1176 Imp Lv4 Low Gain*/
	0xaa77,
	0xab6e, /*Dark1 1177 Imp Lv5 Hi Th*/
	0xac78,
	0xad66, /*Dark1 1178 Imp Lv5 Middle Th*/
	0xae79,
	0xaf40, /*Dark1 1179 Imp Lv5 Hi Gain*/
	0xb07a,
	0xb140, /*Dark1 117a Imp Lv5 Middle Gain*/
	0xb27b,
	0xb340, /*Dark1 117b Imp Lv5 Low Gain*/
	0xb47c,
	0xb55c, /*Dark1 117c Imp Lv6 Hi Th*/
	0xb67d,
	0xb730, /*Dark1 117d Imp Lv6 Middle Th*/
	0xb87e,
	0xb940, /*Dark1 117e Imp Lv6 Hi Gain*/
	0xba7f,
	0xbb40, /*Dark1 117f Imp Lv6 Middle Gain*/
	0xbc80,
	0xbd40, /*Dark1 1180 Imp Lv6 Low Gain*/
	0xbe81,
	0xbf62, /*Dark1 1181*/
	0xc082,
	0xc126, /*Dark1 1182*/
	0xc283,
	0xc340, /*Dark1 1183 Imp Lv7 Hi Gain*/
	0xc484,
	0xc540, /*Dark1 1184 Imp Lv7 Middle Gain*/
	0xc685,
	0xc740, /*Dark1 1185 Imp Lv7 Low Gain*/
	0xc886,
	0xc962, /*Dark1 1186*/
	0xca87,
	0xcb26, /*Dark1 1187*/
	0xcc88,
	0xcd30, /*Dark1 1188*/
	0xce89,
	0xcf30, /*Dark1 1189*/
	0xd08a,
	0xd130, /*Dark1 118a*/
	0xd290,
	0xd300, /*Dark1 1190*/
	0xd491,
	0xd54e, /*Dark1 1191*/
	0xd692,
	0xd700, /*Dark1 1192*/
	0xd893,
	0xd916, /*Dark1 1193*/
	0xda94,
	0xdb01, /*Dark1 1194*/
	0xdc95,
	0xdd80, /*Dark1 1195*/
	0xde96,
	0xdf55, /*Dark1 1196*/
	0xe097,
	0xe18d, /*Dark1 1197*/
	0xe2b0,
	0xe360, /*Dark1 11b0*/
	0xe4b1,
	0xe5b0, /*Dark1 11b1*/
	0xe6b2,
	0xe788, /*Dark1 11b2*/
	0xe8b3,
	0xe910, /*Dark1 11b3*/
	0xeab4,
	0xeb04, /*Dark1 11b4*/
	0xec03,
	0xed12,
	0xee10,
	0xef03, /*Dark1 1210*/
	0xf011,
	0xf129, /*Dark1 1211*/
	0xf212,
	0xf304, /*Dark1 1212*/
	0xf440,
	0xf533, /*Dark1 1240*/
	0xf641,
	0xf70a, /*Dark1 1241*/
	0xf842,
	0xf96a, /*Dark1 1242*/
	0xfa43,
	0xfb80, /*Dark1 1243*/
	0xfc44,
	0xfd02, /*Dark1 1244*/
	0x0e00, /*burst_end*/
	0x03e1,
	0x0e01, /*burst_start*/
	0x1045,
	0x110a, /*Dark1 1245*/
	0x1246,
	0x1380, /*Dark1 1246*/
	0x1460,
	0x1521, /*Dark1 1260*/
	0x1661,
	0x170e, /*Dark1 1261*/
	0x1862,
	0x1970, /*Dark1 1262*/
	0x1a63,
	0x1b70, /*Dark1 1263*/
	0x1c64,
	0x1d14, /*Dark1 1264*/
	0x1e65,
	0x1f01, /*Dark1 1265*/
	0x2068,
	0x210a, /*Dark1 1268*/
	0x2269,
	0x2304, /*Dark1 1269*/
	0x246a,
	0x250a, /*Dark1 126a*/
	0x266b,
	0x270a, /*Dark1 126b*/
	0x286c,
	0x2924, /*Dark1 126c*/
	0x2a6d,
	0x2b01, /*Dark1 126d*/
	0x2c70,
	0x2d01, /*Dark1 1270*/
	0x2e71,
	0x2f3d, /*Dark1 1271*/
	0x3080,
	0x3180, /*Dark1 1280*/
	0x3281,
	0x3388, /*Dark1 1281*/
	0x3482,
	0x3508, /*Dark1 1282*/
	0x3683,
	0x370c, /*Dark1 1283*/
	0x3884,
	0x3990, /*Dark1 1284*/
	0x3a85,
	0x3b92, /*Dark1 1285*/
	0x3c86,
	0x3d20, /*Dark1 1286*/
	0x3e87,
	0x3f00, /*Dark1 1287*/
	0x4088,
	0x4170, /*Dark1 1288*/
	0x4289,
	0x43aa, /*Dark1 1289*/
	0x448a,
	0x4550, /*Dark1 128a*/
	0x468b,
	0x4710, /*Dark1 128b*/
	0x488c,
	0x4904, /*Dark1 128c*/
	0x4a8d,
	0x4b02, /*Dark1 128d*/
	0x4ce6,
	0x4dff, /*Dark1 12e6*/
	0x4ee7,
	0x4f18, /*Dark1 12e7*/
	0x50e8,
	0x5120, /*Dark1 12e8*/
	0x52e9,
	0x5306, /*Dark1 12e9*/
	0x5403,
	0x5513,
	0x5610,
	0x5731, /*Dark1 1310*/
	0x5820,
	0x5920, /*Dark1 1320*/
	0x5a21,
	0x5b30, /*Dark1 1321*/
	0x5c22,
	0x5d36, /*Dark1 1322*/
	0x5e23,
	0x5f6a, /*Dark1 1323*/
	0x6024,
	0x61a0, /*Dark1 1324*/
	0x6225,
	0x63c0, /*Dark1 1325*/
	0x6426,
	0x65e0, /*Dark1 1326*/
	0x6627,
	0x6702, /*Dark1 1327*/
	0x6828,
	0x6903, /*Dark1 1328*/
	0x6a29,
	0x6b03, /*Dark1 1329*/
	0x6c2a,
	0x6d02, /*Dark1 132a*/
	0x6e2b,
	0x6f04, /*Dark1 132b*/
	0x702c,
	0x7104, /*Dark1 132c*/
	0x722d,
	0x7303, /*Dark1 132d*/
	0x742e,
	0x7503, /*Dark1 132e*/
	0x762f,
	0x7714, /*Dark1 132f*/
	0x7830,
	0x7903, /*Dark1 1330*/
	0x7a31,
	0x7b03, /*Dark1 1331*/
	0x7c32,
	0x7d03, /*Dark1 1332*/
	0x7e33,
	0x7f40, /*Dark1 1333*/
	0x8034,
	0x8180, /*Dark1 1334*/
	0x8235,
	0x8300, /*Dark1 1335*/
	0x8436,
	0x85f0, /*Dark1 1336*/
	0x86a0,
	0x8707, /*Dark1 13a0*/
	0x88a8,
	0x8924, /*Dark1 13a8 Cb_Filter*/
	0x8aa9,
	0x8b24, /*Dark1 13a9 Cr_Filter*/
	0x8caa,
	0x8d20, /*Dark1 13aa*/
	0x8eab,
	0x8f02, /*Dark1 13ab*/
	0x90c0,
	0x9127, /*Dark1 13c0*/
	0x92c2,
	0x9308, /*Dark1 13c2*/
	0x94c3,
	0x9508, /*Dark1 13c3*/
	0x96c4,
	0x9740, /*Dark1 13c4*/
	0x98c5,
	0x9938, /*Dark1 13c5*/
	0x9ac6,
	0x9bf0, /*Dark1 13c6*/
	0x9cc7,
	0x9d10, /*Dark1 13c7*/
	0x9ec8,
	0x9f44, /*Dark1 13c8*/
	0xa0c9,
	0xa187, /*Dark1 13c9*/
	0xa2ca,
	0xa3ff, /*Dark1 13ca*/
	0xa4cb,
	0xa520, /*Dark1 13cb*/
	0xa6cc,
	0xa761, /*Dark1 13cc*/
	0xa8cd,
	0xa987, /*Dark1 13cd*/
	0xaace,
	0xab8a, /*Dark1 13ce*/
	0xaccf,
	0xada5, /*Dark1 13cf*/
	0xae03,
	0xaf14,
	0xb011,
	0xb104, /*Dark1 1410*/
	0xb211,
	0xb304, /*Dark1 1411 TOP L_clip*/
	0xb412,
	0xb540, /*Dark1 1412*/
	0xb613,
	0xb798, /*Dark1 1413*/
	0xb814,
	0xb93a, /*Dark1 1414*/
	0xba15,
	0xbb30, /*Dark1 1415*/
	0xbc16,
	0xbd30, /*Dark1 1416*/
	0xbe17,
	0xbf30, /*Dark1 1417*/
	0xc018,
	0xc138, /*Dark1 1418  Negative High Gain*/
	0xc219,
	0xc340, /*Dark1 1419  Negative Middle Gain*/
	0xc41a,
	0xc540, /*Dark1 141a  Negative Low Gain*/
	0xc620,
	0xc784, /*Dark1 1420  s_diff L_clip*/
	0xc821,
	0xc903, /*Dark1 1421*/
	0xca22,
	0xcb05, /*Dark1 1422*/
	0xcc23,
	0xcd07, /*Dark1 1423*/
	0xce24,
	0xcf0a, /*Dark1 1424*/
	0xd025,
	0xd146, /*Dark1 1425*/
	0xd226,
	0xd332, /*Dark1 1426*/
	0xd427,
	0xd51e, /*Dark1 1427*/
	0xd628,
	0xd710, /*Dark1 1428*/
	0xd829,
	0xd900, /*Dark1 1429*/
	0xda2a,
	0xdb18, /*Dark1 142a*/
	0xdc2b,
	0xdd18, /*Dark1 142b*/
	0xde2c,
	0xdf18, /*Dark1 142c*/
	0xe02d,
	0xe130, /*Dark1 142d*/
	0xe22e,
	0xe330, /*Dark1 142e*/
	0xe42f,
	0xe530, /*Dark1 142f*/
	0xe630,
	0xe784, /*Dark1 1430 Ldiff_L_cip*/
	0xe831,
	0xe902, /*Dark1 1431*/
	0xea32,
	0xeb04, /*Dark1 1432*/
	0xec33,
	0xed04, /*Dark1 1433*/
	0xee34,
	0xef0a, /*Dark1 1434*/
	0xf035,
	0xf146, /*Dark1 1435*/
	0xf236,
	0xf332, /*Dark1 1436*/
	0xf437,
	0xf528, /*Dark1 1437*/
	0xf638,
	0xf712, /*Dark1 1438*/
	0xf839,
	0xf900, /*Dark1 1439*/
	0xfa3a,
	0xfb20, /*Dark1 143a*/
	0xfc3b,
	0xfd20, /*Dark1 143b*/
	0x0e00, /*burst_end*/
	0x03e2,
	0x0e01, /*burst_start*/
	0x103c,
	0x1120, /*Dark1 143c*/
	0x123d,
	0x1310, /*Dark1 143d*/
	0x143e,
	0x1518, /*Dark1 143e*/
	0x163f,
	0x1714, /*Dark1 143f*/
	0x1840,
	0x1904, /*Dark11440  Mdiff Low Clip off*/
	0x1a41,
	0x1b10, /*Dark1 1441*/
	0x1c42,
	0x1d70, /*Dark1 1442*/
	0x1e43,
	0x1f20, /*Dark1 1443*/
	0x2044,
	0x2110, /*Dark1 1444*/
	0x2245,
	0x230c, /*Dark1 1445*/
	0x2446,
	0x2510, /*Dark1 1446*/
	0x2647,
	0x2718, /*Dark1 1447*/
	0x2848,
	0x290a, /*Dark1 1448*/
	0x2a49,
	0x2b10, /*Dark1 1449*/
	0x2c50,
	0x2d85, /*Dark1 1450 Hdiff Low Clip*/
	0x2e51,
	0x2f30, /*Dark1 1451 hclip*/
	0x3052,
	0x31b0, /*Dark1 1452*/
	0x3253,
	0x3337, /*Dark1 1453*/
	0x3454,
	0x3533, /*Dark1 1454*/
	0x3655,
	0x3733, /*Dark1 1455*/
	0x3856,
	0x3933, /*Dark1 1456*/
	0x3a57,
	0x3b10, /*Dark1 1457*/
	0x3c58,
	0x3d14, /*Dark1 1458*/
	0x3e59,
	0x3f10, /*Dark1 1459*/
	0x4060,
	0x4101, /*Dark1 1460*/
	0x4261,
	0x43a0, /*Dark1 1461*/
	0x4462,
	0x4598, /*Dark1 1462*/
	0x4663,
	0x47e4, /*Dark1 1463*/
	0x4864,
	0x49a4, /*Dark1 1464*/
	0x4a65,
	0x4b7d, /*Dark1 1465*/
	0x4c66,
	0x4d4b, /*Dark1 1466*/
	0x4e70,
	0x4f10, /*Dark1 1470*/
	0x5071,
	0x5110, /*Dark1 1471*/
	0x5272,
	0x5310, /*Dark1 1472*/
	0x5473,
	0x5510, /*Dark1 1473*/
	0x5674,
	0x5710, /*Dark1 1474*/
	0x5875,
	0x5910, /*Dark1 1475*/
	0x5a76,
	0x5b38, /*Dark1 1476    green sharp pos High*/
	0x5c77,
	0x5d38, /*Dark1 1477    green sharp pos Middle*/
	0x5e78,
	0x5f38, /*Dark1 1478    green sharp pos Low*/
	0x6079,
	0x6170, /*Dark1 1479    green sharp nega High*/
	0x627a,
	0x6370, /*Dark1 147a    green sharp nega Middle*/
	0x647b,
	0x6570, /*Dark1 147b    green sharp nega Low*/
	0x6603,
	0x6710, /*10 page*/
	0x6860,
	0x6903, /*1060*/
	0x6a70,
	0x6b0c, /*1070*/
	0x6c71,
	0x6d05, /*1071*/
	0x6e72,
	0x6f5f, /*1072*/
	0x7073,
	0x7133, /*1073*/
	0x7274,
	0x731b, /*1074*/
	0x7475,
	0x7503, /*1075*/
	0x7676,
	0x7720, /*1076*/
	0x7877,
	0x7933, /*1077*/
	0x7a78,
	0x7b33, /*1078*/
	0x7c79,
	0x7d46, /*1079*/
	0x7e7a,
	0x7f66, /*107a*/
	0x807b,
	0x8143, /*107b*/
	0x827c,
	0x8333, /*107c*/
	0x847d,
	0x850e, /*107d*/
	0x867e,
	0x871e, /*107e*/
	0x887f,
	0x893c, /*107f*/
	0x8a03, /*16 page*/
	0x8b16,
	0x8c8a, /*168a*/
	0x8d68,
	0x8e8b, /*168b*/
	0x8f7c,
	0x908c, /*168c*/
	0x917f,
	0x928d, /*168d*/
	0x937f,
	0x948e, /*168e*/
	0x957f,
	0x968f, /*168f*/
	0x977f,
	0x9890, /*1690*/
	0x997f,
	0x9a91, /*1691*/
	0x9b7f,
	0x9c92, /*1692*/
	0x9d7f,
	0x0e00, /*burst_end*/
/*////////////////*/
/* e3 Page (DMA Dark2)*/
/*////////////////*/
	0x03e3,
	0x0e01, /*burst_start*/
	0x1003, /*Dark2 Page11*/
	0x1111,
	0x1210,
	0x131f, /*Dark2 1110*/
	0x1411,
	0x152a, /*Dark2 1111*/
	0x1612,
	0x171c, /*Dark2 1112*/
	0x1813,
	0x191c, /*Dark2 1113*/
	0x1a14,
	0x1b3a, /*Dark2 1114*/
	0x1c30,
	0x1d20, /*Dark2 1130*/
	0x1e31,
	0x1f20, /*Dark2 1131*/
	0x2032,
	0x2140, /*Dark2 1132 :Lum level1*/
	0x2233,
	0x2328, /*Dark2 1133 :Lum level2*/
	0x2434,
	0x251a, /*Dark2 1134 :Lum level3*/
	0x2635,
	0x2714, /*Dark2 1135 :Lum level4*/
	0x2836,
	0x290c, /*Dark2 1136 :Lum level5*/
	0x2a37,
	0x2b0a, /*Dark2 1137 :Lum level6*/
	0x2c38,
	0x2d00, /*Dark2 1138 :Lum level7*/
	0x2e39,
	0x2f8a, /*Dark2 1139 gain 1*/
	0x303a,
	0x318a, /*Dark2 113a*/
	0x323b,
	0x338a, /*Dark2 113b*/
	0x343c,
	0x358a, /*Dark2 113c*/
	0x363d,
	0x378a, /*Dark2 113d*/
	0x383e,
	0x398a, /*Dark2 113e*/
	0x3a3f,
	0x3b8a, /*Dark2 113f*/
	0x3c40,
	0x3d8a, /*Dark2 1140 gain 8*/
	0x3e41,
	0x3f40, /*Dark2 1141 offset 1*/
	0x4042,
	0x4110, /*Dark2 1142 offset 2*/
	0x4243,
	0x4310, /*Dark2 1143 offset 3*/
	0x4444,
	0x4510, /*Dark2 1144 offset 4*/
	0x4645,
	0x4710, /*Dark2 1145 offset 5*/
	0x4846,
	0x4910, /*Dark2 1146 offset 6*/
	0x4a47,
	0x4b10, /*Dark2 1147 offset 7*/
	0x4c48,
	0x4d10, /*Dark2 1148 offset 8*/
	0x4e49,
	0x4f40, /*Dark2 1149 high_clip_start*/
	0x504a,
	0x5140, /*Dark2 114a*/
	0x524b,
	0x5340, /*Dark2 114b*/
	0x544c,
	0x5540, /*Dark2 114c*/
	0x564d,
	0x5740, /*Dark2 114d*/
	0x584e,
	0x5940, /*Dark2 114e Lv 6 h_clip*/
	0x5a4f,
	0x5b40, /*Dark2 114f Lv 7 h_clip*/
	0x5c50,
	0x5d40, /*Dark2 1150 clip 8*/
	0x5e51,
	0x5ff0, /*Dark2 1151 color gain start*/
	0x6052,
	0x61f0, /*Dark2 1152*/
	0x6253,
	0x63f0, /*Dark2 1153*/
	0x6454,
	0x65f0, /*Dark2 1154*/
	0x6655,
	0x67f0, /*Dark2 1155*/
	0x6856,
	0x69f0, /*Dark2 1156*/
	0x6a57,
	0x6bf0, /*Dark2 1157*/
	0x6c58,
	0x6df0, /*Dark2 1158 color gain end*/
	0x6e59,
	0x6ff8, /*Dark2 1159 color ofs lmt start*/
	0x705a,
	0x71f8, /*Dark2 115a*/
	0x725b,
	0x73f8, /*Dark2 115b*/
	0x745c,
	0x75f8, /*Dark2 115c*/
	0x765d,
	0x77f8, /*Dark2 115d*/
	0x785e,
	0x79f8, /*Dark2 115e*/
	0x7a5f,
	0x7bf8, /*Dark2 115f*/
	0x7c60,
	0x7df8, /*Dark2 1160 color ofs lmt end*/
	0x7e61,
	0x7fc0, /*Dark2 1161*/
	0x8062,
	0x81f0, /*Dark2 1162*/
	0x8263,
	0x8380, /*Dark2 1163*/
	0x8464,
	0x8540, /*Dark2 1164*/
	0x8665,
	0x8702, /*Dark2 1165 : lmp_1_gain_h*/
	0x8866,
	0x8902, /*Dark2 1166 : lmp_1_gain_m*/
	0x8a67,
	0x8b02, /*Dark2 1167 : lmp_1_gain_l*/
	0x8c68,
	0x8d80, /*Dark2 1168*/
	0x8e69,
	0x8f40, /*Dark2 1169*/
	0x906a,
	0x9101, /*Dark2 116a : lmp_2_gain_h*/
	0x926b,
	0x9301, /*Dark2 116b : lmp_2_gain_m*/
	0x946c,
	0x9501, /*Dark2 116c : lmp_2_gain_l*/
	0x966d,
	0x9780, /*Dark2 116d*/
	0x986e,
	0x9940, /*Dark2 116e*/
	0x9a6f,
	0x9b01, /*Dark2 116f : lmp_3_gain_h*/
	0x9c70,
	0x9d01, /*Dark2 1170 : lmp_3_gain_m*/
	0x9e71,
	0x9f01, /*Dark2 1171 : lmp_3_gain_l*/
	0xa072,
	0xa16e, /*Dark2 1172*/
	0xa273,
	0xa33a, /*Dark2 1173*/
	0xa474,
	0xa501, /*Dark2 1174 : lmp_4_gain_h*/
	0xa675,
	0xa701, /*Dark2 1175 : lmp_4_gain_m*/
	0xa876,
	0xa901, /*Dark2 1176 : lmp_4_gain_l*/
	0xaa77,
	0xab6e, /*Dark2 1177*/
	0xac78,
	0xad3a, /*Dark2 1178*/
	0xae79,
	0xaf01, /*Dark2 1179 : lmp_5_gain_h*/
	0xb07a,
	0xb101, /*Dark2 117a : lmp_5_gain_m*/
	0xb27b,
	0xb301, /*Dark2 117b : lmp_5_gain_l*/
	0xb47c,
	0xb55c, /*Dark2 117c*/
	0xb67d,
	0xb730, /*Dark2 117d*/
	0xb87e,
	0xb901, /*Dark2 117e : lmp_6_gain_h*/
	0xba7f,
	0xbb01, /*Dark2 117f : lmp_6_gain_m*/
	0xbc80,
	0xbd01, /*Dark2 1180 : lmp_6_gain_l*/
	0xbe81,
	0xbf62, /*Dark2 1181*/
	0xc082,
	0xc126, /*Dark2 1182*/
	0xc283,
	0xc301, /*Dark2 1183 : lmp_7_gain_h*/
	0xc484,
	0xc501, /*Dark2 1184 : lmp_7_gain_m*/
	0xc685,
	0xc701, /*Dark2 1185 : lmp_7_gain_l*/
	0xc886,
	0xc962, /*Dark2 1186*/
	0xca87,
	0xcb26, /*Dark2 1187*/
	0xcc88,
	0xcd01, /*Dark2 1188 : lmp_8_gain_h*/
	0xce89,
	0xcf01, /*Dark2 1189 : lmp_8_gain_m*/
	0xd08a,
	0xd101, /*Dark2 118a : lmp_8_gain_l*/
	0xd290,
	0xd300, /*Dark2 1190*/
	0xd491,
	0xd54e, /*Dark2 1191*/
	0xd692,
	0xd700, /*Dark2 1192*/
	0xd893,
	0xd916, /*Dark2 1193*/
	0xda94,
	0xdb01, /*Dark2 1194*/
	0xdc95,
	0xdd80, /*Dark2 1195*/
	0xde96,
	0xdf55, /*Dark2 1196*/
	0xe097,
	0xe18d, /*Dark2 1197*/
	0xe2b0,
	0xe330, /*Dark2 11b0*/
	0xe4b1,
	0xe590, /*Dark2 11b1*/
	0xe6b2,
	0xe708, /*Dark2 11b2*/
	0xe8b3,
	0xe900, /*Dark2 11b3*/
	0xeab4,
	0xeb04, /*Dark2 11b4*/
	0xec03,
	0xed12,
	0xee10,
	0xef03, /*Dark2 1210*/
	0xf011,
	0xf129, /*Dark2 1211*/
	0xf212,
	0xf303, /*Dark2 1212*/
	0xf440,
	0xf502, /*Dark2 1240*/
	0xf641,
	0xf70a, /*Dark2 1241*/
	0xf842,
	0xf96a, /*Dark2 1242*/
	0xfa43,
	0xfb80, /*Dark2 1243*/
	0xfc44,
	0xfd02, /*Dark2 1244*/
	0x0e00, /*burst_end*/
	0x03e4,
	0x0e01, /*burst_start*/
	0x1045,
	0x110a, /*Dark2 1245*/
	0x1246,
	0x1380, /*Dark2 1246*/
	0x1460,
	0x1502, /*Dark2 1260*/
	0x1661,
	0x1704, /*Dark2 1261*/
	0x1862,
	0x194b, /*Dark2 1262*/
	0x1a63,
	0x1b41, /*Dark2 1263*/
	0x1c64,
	0x1d14, /*Dark2 1264*/
	0x1e65,
	0x1f00, /*Dark2 1265*/
	0x2068,
	0x210a, /*Dark2 1268*/
	0x2269,
	0x2304, /*Dark2 1269*/
	0x246a,
	0x250a, /*Dark2 126a*/
	0x266b,
	0x270a, /*Dark2 126b*/
	0x286c,
	0x2924, /*Dark2 126c*/
	0x2a6d,
	0x2b01, /*Dark2 126d*/
	0x2c70,
	0x2d18, /*Dark2 1270*/
	0x2e71,
	0x2fbf, /*Dark2 1271*/
	0x3080,
	0x3164, /*Dark2 1280*/
	0x3281,
	0x33b1, /*Dark2 1281*/
	0x3482,
	0x352c, /*Dark2 1282*/
	0x3683,
	0x3702, /*Dark2 1283*/
	0x3884,
	0x3930, /*Dark2 1284*/
	0x3a85,
	0x3b90, /*Dark2 1285*/
	0x3c86,
	0x3d10, /*Dark2 1286*/
	0x3e87,
	0x3f01, /*Dark2 1287*/
	0x4088,
	0x413a, /*Dark2 1288*/
	0x4289,
	0x4390, /*Dark2 1289*/
	0x448a,
	0x450e, /*Dark2 128a*/
	0x468b,
	0x470c, /*Dark2 128b*/
	0x488c,
	0x4905, /*Dark2 128c*/
	0x4a8d,
	0x4b03, /*Dark2 128d*/
	0x4ce6,
	0x4dff, /*Dark2 12e6*/
	0x4ee7,
	0x4f18, /*Dark2 12e7*/
	0x50e8,
	0x510a, /*Dark2 12e8*/
	0x52e9,
	0x5306, /*Dark2 12e9*/
	0x5403,
	0x5513,
	0x5610,
	0x573f, /*Dark2 1310*/
	0x5820,
	0x5920, /*Dark2 1320*/
	0x5a21,
	0x5b30, /*Dark2 1321*/
	0x5c22,
	0x5d36, /*Dark2 1322*/
	0x5e23,
	0x5f6a, /*Dark2 1323*/
	0x6024,
	0x61a0, /*Dark2 1324*/
	0x6225,
	0x63c0, /*Dark2 1325*/
	0x6426,
	0x65e0, /*Dark2 1326*/
	0x6627,
	0x6700, /*Dark2 1327 lum 0*/
	0x6828,
	0x6900, /*Dark2 1328*/
	0x6a29,
	0x6b00, /*Dark2 1329*/
	0x6c2a,
	0x6d00, /*Dark2 132a*/
	0x6e2b,
	0x6f00, /*Dark2 132b*/
	0x702c,
	0x7100, /*Dark2 132c*/
	0x722d,
	0x7300, /*Dark2 132d*/
	0x742e,
	0x7500, /*Dark2 132e lum7*/
	0x762f,
	0x7704, /*Dark2 132f weight skin*/
	0x7830,
	0x7904, /*Dark2 1330 weight blue*/
	0x7a31,
	0x7b04, /*Dark2 1331 weight green*/
	0x7c32,
	0x7d04, /*Dark2 1332 weight strong color*/
	0x7e33,
	0x7f10, /*Dark2 1333*/
	0x8034,
	0x8110, /*Dark2 1334*/
	0x8235,
	0x8300, /*Dark2 1335*/
	0x8436,
	0x8580, /*Dark2 1336*/
	0x86a0,
	0x8707, /*Dark2 13a0*/
	0x88a8,
	0x8930, /*Dark2 13a8 Dark2 Cb-filter*/
	0x8aa9,
	0x8b30, /*Dark2 13a9 Dark2 Cr-filter*/
	0x8caa,
	0x8d30, /*Dark2 13aa*/
	0x8eab,
	0x8f02, /*Dark2 13ab*/
	0x90c0,
	0x9127, /*Dark2 13c0*/
	0x92c2,
	0x9308, /*Dark2 13c2*/
	0x94c3,
	0x9508, /*Dark2 13c3*/
	0x96c4,
	0x9746, /*Dark2 13c4*/
	0x98c5,
	0x9978, /*Dark2 13c5*/
	0x9ac6,
	0x9bf0, /*Dark2 13c6*/
	0x9cc7,
	0x9d10, /*Dark2 13c7*/
	0x9ec8,
	0x9f44, /*Dark2 13c8*/
	0xa0c9,
	0xa187, /*Dark2 13c9*/
	0xa2ca,
	0xa3ff, /*Dark2 13ca*/
	0xa4cb,
	0xa520, /*Dark2 13cb*/
	0xa6cc,
	0xa761, /*Dark2 13cc skin range_cb_l*/
	0xa8cd,
	0xa987, /*Dark2 13cd skin range_cb_h*/
	0xaace,
	0xab8a, /*Dark2 13ce skin range_cr_l*/
	0xaccf,
	0xada5, /*Dark2 13cf skin range_cr_h*/
	0xae03,
	0xaf14,
	0xb011,
	0xb103, /*Dark2 1410*/
	0xb211,
	0xb303, /*Dark2 1411*/
	0xb412,
	0xb540, /*Dark2 1412 Top H_Clip*/
	0xb613,
	0xb788, /*Dark2 1413*/
	0xb814,
	0xb934, /*Dark2 1414*/
	0xba15,
	0xbb00, /*Dark2 1415 sharp positive ya*/
	0xbc16,
	0xbd00, /*Dark2 1416 sharp positive mi*/
	0xbe17,
	0xbf00, /*Dark2 1417 sharp positive low*/
	0xc018,
	0xc110, /*Dark2 1418 sharp negative ya*/
	0xc219,
	0xc310, /*Dark2 1419 sharp negative mi*/
	0xc41a,
	0xc510, /*Dark2 141a sharp negative low*/
	0xc620,
	0xc783, /*Dark2 1420*/
	0xc821,
	0xc903, /*Dark2 1421*/
	0xca22,
	0xcb05, /*Dark2 1422*/
	0xcc23,
	0xcd07, /*Dark2 1423*/
	0xce24,
	0xcf0a, /*Dark2 1424*/
	0xd025,
	0xd146, /*Dark2 1425*/
	0xd226,
	0xd332, /*Dark2 1426*/
	0xd427,
	0xd51e, /*Dark2 1427*/
	0xd628,
	0xd719, /*Dark2 1428*/
	0xd829,
	0xd900, /*Dark2 1429*/
	0xda2a,
	0xdb10, /*Dark2 142a*/
	0xdc2b,
	0xdd10, /*Dark2 142b*/
	0xde2c,
	0xdf10, /*Dark2 142c*/
	0xe02d,
	0xe180, /*Dark2 142d*/
	0xe22e,
	0xe380, /*Dark2 142e*/
	0xe42f,
	0xe580, /*Dark2 142f*/
	0xe630,
	0xe783, /*Dark2 1430*/
	0xe831,
	0xe902, /*Dark2 1431*/
	0xea32,
	0xeb04, /*Dark2 1432*/
	0xec33,
	0xed04, /*Dark2 1433*/
	0xee34,
	0xef0a, /*Dark2 1434*/
	0xf035,
	0xf146, /*Dark2 1435*/
	0xf236,
	0xf332, /*Dark2 1436*/
	0xf437,
	0xf528, /*Dark2 1437*/
	0xf638,
	0xf712, /*Dark2 1438*/
	0xf839,
	0xf900, /*Dark2 1439*/
	0xfa3a,
	0xfb18, /*Dark2 143a dr gain*/
	0xfc3b,
	0xfd20, /*Dark2 143b*/
	0x0e00, /*burst_end*/
	0x03e5,
	0x0e01, /*burst_start*/
	0x103c,
	0x1118, /*Dark2 143c*/
	0x123d,
	0x1320, /*Dark2 143d nor gain*/
	0x143e,
	0x1522, /*Dark2 143e*/
	0x163f,
	0x1710, /*Dark2 143f*/
	0x1840,
	0x1903, /*Dark2 1440*/
	0x1a41,
	0x1b12, /*Dark2 1441*/
	0x1c42,
	0x1db0, /*Dark2 1442*/
	0x1e43,
	0x1f20, /*Dark2 1443*/
	0x2044,
	0x210a, /*Dark2 1444*/
	0x2245,
	0x230a, /*Dark2 1445*/
	0x2446,
	0x250a, /*Dark2 1446*/
	0x2647,
	0x2708, /*Dark2 1447*/
	0x2848,
	0x2908, /*Dark2 1448*/
	0x2a49,
	0x2b08, /*Dark2 1449*/
	0x2c50,
	0x2d03, /*Dark2 1450*/
	0x2e51,
	0x2f32, /*Dark2 1451*/
	0x3052,
	0x3140, /*Dark2 1452*/
	0x3253,
	0x3319, /*Dark2 1453*/
	0x3454,
	0x3560, /*Dark2 1454*/
	0x3655,
	0x3760, /*Dark2 1455*/
	0x3856,
	0x3960, /*Dark2 1456*/
	0x3a57,
	0x3b20, /*Dark2 1457*/
	0x3c58,
	0x3d20, /*Dark2 1458*/
	0x3e59,
	0x3f20, /*Dark2 1459*/
	0x4060,
	0x4103, /*Dark2 1460 skin opt en*/
	0x4261,
	0x43a0, /*Dark2 1461*/
	0x4462,
	0x4598, /*Dark2 1462*/
	0x4663,
	0x47e4, /*Dark2 1463 skin_std_th_h*/
	0x4864,
	0x49a4, /*Dark2 1464 skin_std_th_l*/
	0x4a65,
	0x4b7d, /*Dark2 1465 sharp_std_th_h*/
	0x4c66,
	0x4d4b, /*Dark2 1466 sharp_std_th_l*/
	0x4e70,
	0x4f10, /*Dark2 1470*/
	0x5071,
	0x5110, /*Dark2 1471*/
	0x5272,
	0x5310, /*Dark2 1472*/
	0x5473,
	0x5510, /*Dark2 1473*/
	0x5674,
	0x5710, /*Dark2 1474*/
	0x5875,
	0x5910, /*Dark2 1475*/
	0x5a76,
	0x5b28, /*Dark2 1476*/
	0x5c77,
	0x5d28, /*Dark2 1477*/
	0x5e78,
	0x5f28, /*Dark2 1478*/
	0x6079,
	0x6128, /*Dark2 1479*/
	0x627a,
	0x6328, /*Dark2 147a*/
	0x647b,
	0x6528, /*Dark2 147b*/
	0x6603,
	0x6710, /*10 page*/
	0x6860,
	0x6903, /*1060*/
	0x6a70,
	0x6b0c, /*1070*/
	0x6c71,
	0x6d08, /*1071*/
	0x6e72,
	0x6fed, /*1072*/
	0x7073,
	0x7100, /*1073*/
	0x7274,
	0x7336, /*1074*/
	0x7475,
	0x7508, /*1075*/
	0x7676,
	0x7713, /*1076*/
	0x7877,
	0x7920, /*1077*/
	0x7a78,
	0x7b00, /*1078*/
	0x7c79,
	0x7d40, /*1079*/
	0x7e7a,
	0x7f00, /*107a*/
	0x807b,
	0x8139, /*107b*/
	0x827c,
	0x8399, /*107c*/
	0x847d,
	0x850e, /*107d*/
	0x867e,
	0x871e, /*107e*/
	0x887f,
	0x893c, /*107f*/
	0x8a03, /*16 page*/
	0x8b16,
	0x8c8a, /*168a*/
	0x8d60,
	0x8e8b, /*168b*/
	0x8f68,
	0x908c, /*168c*/
	0x916a,
	0x928d, /*168d*/
	0x9374,
	0x948e, /*168e*/
	0x957a,
	0x968f, /*168f*/
	0x977f,
	0x9890, /*1690*/
	0x997f,
	0x9a91, /*1691*/
	0x9b7f,
	0x9c92, /*1692*/
	0x9d7f,
	0x0e00, /*burst_end*/
/* DMA End*/
	0x0300,
	0x01f1, /*Sleep mode on*/
	0x03c0,
	0x1680, /*MCU main roof holding off*/
	0x03C0,
	0x3301, /*DMA hand shake mode set*/
	0x3201, /*DMA off*/
	0x0330,
	0x1104, /*MCU holding off*/
/*/////////////////////////////////////////*/
/* 1F Page SSD*/
/*/////////////////////////////////////////*/
	0x031f, /*1F page*/
	0x1100, /*bit[5:4]: debug mode*/
	0x1260,
	0x1314,
	0x1410,
	0x1500,
	0x2018, /*ssd_x_start_pos*/
	0x2114, /*ssd_y_start_pos*/
	0x228C, /*ssd_blk_width*/
	0x239C, /*ssd_blk_height*/
	0x2818,
	0x2902,
	0x3B18,
	0x3C8C,
	0x1019, /*SSD enable*/
	0x03c4, /*AE en*/
	0x6608, /*ae stat*/
	0x6700, /*ae stat*/
	0x10ff, /*ae on & reset*/
	0x03c3, /*AE Static en*/
	0x1084,
	0xff02, /*Delay 20ms*/
/*/////////////////////////////////////////*/
/* 30 Page DMA address set*/
/*/////////////////////////////////////////*/
	0x0330, /*DMA*/
	0x7c2c, /*Extra str*/
	0x7dce,
	0x7e2d, /*Extra end*/
	0x7fbb,
	0x8024, /*Outdoor str*/
	0x8170,
	0x8227, /*Outdoor end*/
	0x8339,
	0x8421, /*Indoor str*/
	0x85a6,
	0x8624, /*Indoor end*/
	0x876f,
	0x8827, /*Dark1 str*/
	0x893a,
	0x8a2a, /*Dark1 end*/
	0x8b03,
	0x8c2a, /*Dark2 str*/
	0x8d04,
	0x8e2c, /*Dark2 end*/
	0x8fcd,
/*/////////////////////////////////////////*/
/* CD Page (Color ratio)*/
/*/////////////////////////////////////////*/
	0x03CD,
	0x1038, /*ColorRatio disable*/
	0x03c9, /*AWB Start Point*/
	0x2a00,
	0x2bb2,
	0x2c00,
	0x2d79,
	0x2e00,
	0x2fb2,
	0x3000,
	0x3179,
	0x03c5, /*AWB en*/
	0x1081,
	0x03cf, /*Adative en*/
	0x10af, /*Yoffset, Contrast Off*/
/*/////////////////////////////////////////*/
/* Preview Setting*/
/*/////////////////////////////////////////*/
	0x0330,
	0x3629, /*Capture Function - Capture*/
	0x0300,
	0xff01, /*Delay 10ms*/
	0x0300,
	0x1041, /*Binning + Pre1*/
	0x2000,
	0x2101, /*preview row start set.*/
	0x4200, /*720p Start pixel*/
	0x4301,
	0x0315, /*Shading*/
	0x1081,
	0x2007, /*Shading Width 2048*/
	0x21f8,
	0x2202, /*Shading Height 768*/
	0x23fc,
	0x0319,
	0x1000,
	0x1100,
	0x1206,
	0x1301,
	0x2002, /*zoom width 640*/
	0x2180,
	0x2201, /*zoom height 480*/
	0x23e0,
	0x2400, /*stx*/
	0x2503,
	0x2600, /*sty*/
	0x2701,
	0x2802, /*edx*/
	0x2983,
	0x2a01, /*edy*/
	0x2be1,
	0x2c0c,
	0x2dcc,
	0x2e0c,
	0x2fcc,
	0x3042,
	0x1007, /*Scaler On*/
/*/////////////////////////////////////////*/
/* 48 Page MIPI setting*/
/*/////////////////////////////////////////*/
	0x0348,
	0x09a6, /*MIPI CLK*/
	0x101C, /*MIPI ON*/
	0x1100, /*Normal Mode*/
	0x1450, /*Skew*/
	0x1604,
	0x1a11,
	0x1b0d, /*Short Packet*/
	0x1c01, /*Control DP*/
	0x1d0f, /*Control DN*/
	0x1e09,
	0x1f05,
	0x2000,
	0x241e, /*Bayer8 : 2a, Bayer10 : 2b, YUV : 1e*/
	0x3000, /*640*2 */
	0x3105,
	0x3404,
	0x3903, /*Drivability 00*/
	0x0300,
	0x0cf0, /*Parallel Line Off*/
/*///////MIPI END///////////*/
	0x0330,
	0x3628, /*Capture Function - Preview*/
	0x0300,
	0xff01, /*Delay 10ms*/
	0x0300,
	0x01f0, /*sleep off*/
	0x03c5, /*AWB en*/
	0x1081,
	0xff03, /*Delay 30ms*/
	0x03c4, /*AE en*/
	0x10ee,
	0x03C0,
	0x3300,
	0x3201, /*DMA on*/

/* sr300pc20_preview_camera_regs */
	0x0300,
	0x01f1, /*Sleep on*/
	0x0330,
	0x36A3, /*DMA off*/
	0x03c4,
	0x106e, /*AE Off*/
	0x03c5,
	0x1000, /*AWB off*/
	0x0300,
	0xff01, /*Delay 10ms*/
	0x0330,
	0x3629, /*Capture Function - Capture*/
	0x0300,
	0xff01, /*Delay 10ms*/
	0x0319, /*Scaler On*/
	0x1007,
	0x0300,
	0x1041, /*Binning + Pre1*/
	0x1190, /*Fix Frame Off*/
	0x1380,
	0x1430,
	0x1704, /*CLK 1/1*/
	0x0302,
	0x2102,
	0x0300,
	0xff01, /*Delay 10ms  */
	0x2000,
	0x2100, /*preview row START set*/
	0x2200,
	0x2300, /*preview col start set*/
	0x5200, /*Vblank 33*/
	0x5321,
	0x0315, /*Shading*/
	0x1081,
	0x2007, /*Shading Width 2048*/
	0x21f8,
	0x2202, /*Shading Height 768*/
	0x23fc,
	0x0348,
	0x101C, /*MIPI On*/
	0x1604,
	0x3000, /*640 * 2*/
	0x3105,
	0x0320,
	0x2403, /*EXP Max 1.00 fps*/
	0x2519,
	0x2675,
	0x2700,
	0x03d5,
	0x4189,
	0x0330,
	0x3628, /*Capture Function - Preview*/
	0x0300,
	0xff01, /*Delay 10ms  */
	0x03c4,
	0x10ef, /*AE On*/
	0x0300,
	0xff01, /*Delay 10ms  */
	0x03c5,
	0x10b0, /*AWB en*/
	0x0314,
	0x1000,
	0x0300,
	0x01f0, /*sleep off*/
	0x03cf, /*Adative en*/
	0x10af, /*Yoffset, Contrast Off*/
	0x03c0,
	0x3300,
	0x3201, /*DMA On*/
	0xff05,

};

static const sr300pc20_regset_t sr300pc20_preview_camera_regs[] =
{
 
	0x0300,
	0x01f1, /*Sleep on*/
	0x0330,
	0x36A3, /*DMA off*/
	0x03c4,
	0x106e, /*AE Off*/
	0x03c5,
	0x1000, /*AWB off*/
	0x0300,
	0xff01, /*Delay 10ms*/
	0x0330,
	0x3629, /*Capture Function - Capture*/
	0x0300,
	0xff01, /*Delay 10ms*/
	0x0319, /*Scaler On*/
	0x1007,
	0x0300,
	0x1041, /*Binning + Pre1*/
	0x1190, /*Fix Frame Off*/
	0x1380,
	0x1430,
	0x1704, /*CLK 1/1*/
	0x0302,
	0x2102,
	0x0300,
	0xff01, /*Delay 10ms  */
	0x2000,
	0x2100, /*preview row START set*/
	0x2200,
	0x2300, /*preview col start set*/
	0x5200, /*Vblank 33*/
	0x5321,
	0x0315, /*Shading*/
	0x1081,
	0x2007, /*Shading Width 2048*/
	0x21f8,
	0x2202, /*Shading Height 768*/
	0x23fc,
	0x0348,
	0x101C, /*MIPI On*/
	0x1604,
	0x3000, /*640 * 2*/
	0x3105,
	0x0320,
	0x2403, /*EXP Max 1.00 fps*/
	0x2519,
	0x2675,
	0x2700,
	0x03d5,
	0x4189,
	0x0330,
	0x3628, /*Capture Function - Preview*/
	0x0300,
	0xff01, /*Delay 10ms  */
	0x03c4,
	0x10ef, /*AE On*/
	0x0300,
	0xff01, /*Delay 10ms  */
	0x03c5,
	0x10b0, /*AWB en*/
	0x0314,
	0x1000,
	0x0300,
	0x01f0, /*sleep off*/
	0x03cf, /*Adative en*/
	0x10af, /*Yoffset, Contrast Off*/
	0x03c0,
	0x3300,
	0x3201, /*DMA On*/
	0xff05,	
	  
   
   
 } ;

static const sr300pc20_regset_t sr300pc20_stop_stream[]  = {
0x0300,
0x0101,

0xff0a,
};

static const isx012_regset_t SR300PC20_Pll_Setting_2[] =
{
{0x0007,0x01,0x01},                   // PLL_CKSEL                 : PLL 648MHz
{0x0008,0x03,0x01},                   // SRCCK_DIV                 : 1/8 frequency

{0x0004,0x03,0x01},                  //I2C_ADR_SEL 2: 0x3C MIPI selected, 3: 0x3D MIPI selected
{0x5008,0x00,0x01},                  //ENDIAN_SEL : 0:Little Endian
{0x6DA8,0x01,0x01},                  //SHD_CoEF (OTP shading ON flag)
{0x6DA9,0x09,0x01},                  // WHITE_CTRL
{0x6DCB,0x22,0x01},    // YGAM_CONFIG2 :

{0x00C4,0x11,0x01},                   // VIF_CLKCONFIG1            : VIFSEL and VIFDIV setting value with full frame pixel setting for other then JPG
{0x00C5,0x11,0x01},                   // VIF_CLKCONFIG2            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other then JPG
{0x00C6,0x11,0x01},                   // VIF_CLKCONFIG3            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other then JPG
{0x00C7,0x11,0x01},                   // VIF_CLKCONFIG4            : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other then JPG
{0x00C8,0x11,0x01},                   // VIF_CLKCONFIG5            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00C9,0x11,0x01},                   // VIF_CLKCONFIG6            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00CA,0x11,0x01},                   // VIF_CLKCONFIG7            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for JPG mode
{0x018C,0x0000,0x02},                // VADJ_SENS_1_1             : VMAX adjustment value for full frame pixel
{0x018E,0x0000,0x02},                // VADJ_SENS_1_2             : VMAX adjustment value for 1/2 sub-sampling
{0x0190,0x0000,0x02},                // VADJ_SENS_1_4             : VMAX adjustment value for 1/4 sub-sampling
{0x0192,0x0000,0x02},                // VADJ_SENS_1_8             : VMAX adjustment value for 1/8 sub-sampling
{0x0194,0x0000,0x02},                // VADJ_SENS_HD_1_1          : VMAX adjustment value for HD full frame pixel
{0x0196,0x0000,0x02},                // VADJ_SENS_HD_1_2          : VMAX adjustment value for HD 1/2 sub-sampling
{0x6A16,0x0400,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_1 : Detection window vertical size with all 32 windows for FLC full frame pixel
{0x6A18,0x03C0,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_2 : Detection window vertical size with all 32 windows for FLC 1/2 sub-sampling
{0x6A1A,0x01E0,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_4 : Detection window vertical size with all 32 windows for FLC 1/4 sub-sampling
{0x6A1C,0x00E0,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_8 : Detection window vertical size with all 32 windows for FLC 1/8 sub-sampling
{0x6A1E,0x0400,0x02},                // FLC_OPD_HEIGHT_HD_1_1     : Detection window vertical size with all 32 windows for FLC HD full frame pixel
{0x6A20,0x02C0,0x02},                // FLC_OPD_HEIGHT_HD_1_2     : Detection window vertical size with all 32 windows for FLC HD 1/2 sub-sampling
{0x0016,0x0010,0x02},                // GPIO_FUNCSEL              : GPIO setting
{0x5C01,0x00,0x01},                   // RGLANESEL                 : Select 1Lane or 2Lane

{0x5C04,0x06,0x01},                   // RGTLPX                    : //0x5C04   0x4  ->  0x6
{0x5C05,0x05,0x01},                   // RGTCLKPREPARE             : //0x5C05   0x3  ->  0x5
{0x5C06,0x14,0x01},                   // RGTCLKZERO                :
{0x5C07,0x02,0x01},                   // RGTCLKPRE                 :
{0x5C08,0x0D,0x01},                   // RGTCLKPOST                : //0x5C08   0x11 ->  0xD
{0x5C09,0x07,0x01},                   // RGTCLKTRAIL               : //0x5C09   0x5  ->  0x7
{0x5C0A,0x0A,0x01},                   // RGTHSEXIT                 : //0x5C0A   0x7  ->  0xA
{0x5C0B,0x05,0x01},                   // RGTHSPREPARE              : //0x5C0B   0x3  ->  0x5
{0x5C0C,0x08,0x01},                   // RGTHSZERO                 : //0x5C0C   0x7  ->  0x8
{0x5C0D,0x07,0x01},                   // RGTHSTRAIL                : //0x5C0D   0x5  ->  0x7

{0x0009,0x01,0x01},                 // EXT_PLL_CKSEL       : PLL 648MHz
{0x00D0,0x11,0x01},                 // VIF_CLKCONFIG_EXT1  : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG and interleave mode
{0x00D1,0x11,0x01},                 // VIF_CLKCONFIG_EXT2  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG and interleave mode
{0x00D4,0x11,0x01},                 // VIF_CLKCONFIG_EXT5  : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00D5,0x11,0x01},                 // VIF_CLKCONFIG_EXT6  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00D8,0x11,0x01},                 // VIF_CLKCONFIG_EXT9  : VIFSEL and VIFDIV setting value with full frame pixel setting for other than JPG
{0x00D9,0x11,0x01},                 // VIF_CLKCONFIG_EXT10 : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other than JPG

//init Preview setting
{0x0089,0x00,0x01},//OUTFMT_MONI
{0x0090,0x0280,0x02},//HSIZE_MONI : 640
{0x0096,0x01E0,0x02},//VSIZE_MONI : 480
{0x0083,0x01,0x01},//SENSMODE_MONI
{0x0086,0x02,0x01},//FPSTYPE_MONI
{0x0081,0x00,0x01},//MODESEL
{0x0082,0x01,0x01},//MONI_REFRESH

//jpeg setting
//Apex40 is not Jpeg Capture

//Fast mode setting
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT

//Select sensor inversion link control
{0x501A,0x00,0x01},    //SENS_REVERSE_CTRL

//shading
{0x6DBC,0x03,0x01},    // WHITE_EDGE_MAX :
{0x6DF6,0xFF,0x01},    // WHITE_SHD_JUDGE_BODY_COLOR_RATIO :
{0x6DF7,0xF0,0x01},    // WHITE_SHD_JUDGE_RED_RATIO :
{0x6DAD,0x0C,0x01},    // WHITE_OFSET1_UP :
{0x6DAE,0x0C,0x01},    // WHITE_OFSET1_DOWN :
{0x6DAF,0x11,0x01},    // WHITE_OFSET1_RIGHT :
{0x6DB0,0x1B,0x01},    // WHITE_OFSET1_LEFT :
{0x6DB1,0x0D,0x01},    // WHITE_OFSET2_UP :
{0x6DB2,0x13,0x01},    // WHITE_OFSET2_DOWN :
{0x6DB3,0x11,0x01},    // WHITE_OFSET2_RIGHT :
{0x6DB4,0x17,0x01},    // WHITE_OFSET2_LEFT :

//addtional code
{0xF200,0xB9B9,0x02},
{0xF202,0x4E12,0x02},
{0xF204,0x6055,0x02},
{0xF206,0x008B,0x02},
{0xF208,0xF177,0x02},
{0xF20A,0xFA70,0x02},
{0xF20C,0x0000,0x02},
{0xF20E,0x0000,0x02},
{0xF210,0x0000,0x02},
{0xF212,0x0000,0x02},
{0xF214,0x0000,0x02},
{0xF216,0x0000,0x02},
{0xF218,0x0000,0x02},
{0xF21A,0x0000,0x02},
{0xF21C,0x0000,0x02},
{0xF21E,0x0000,0x02},
{0xF220,0x0000,0x02},
{0xF222,0x0000,0x02},
{0xF224,0x0000,0x02},
{0xF226,0x0000,0x02},
{0xF228,0x0000,0x02},
{0xF22A,0x0000,0x02},
{0xF22C,0x0000,0x02},
{0xF22E,0x0000,0x02},
{0xF230,0x0000,0x02},
{0xF232,0x0000,0x02},
{0xF234,0x0000,0x02},
{0xF236,0x0000,0x02},
{0xF238,0x0000,0x02},
{0xF23A,0x0000,0x02},
{0xF23C,0x0000,0x02},
{0xF23E,0x0000,0x02},
{0xF240,0x0000,0x02},
{0xF242,0x0000,0x02},
{0xF244,0xB47E,0x02},
{0xF246,0x4808,0x02},
{0xF248,0x7800,0x02},
{0xF24A,0x07C0,0x02},
{0xF24C,0x0FC0,0x02},
{0xF24E,0xF687,0x02},
{0xF250,0xF8ED,0x02},
{0xF252,0xF68E,0x02},
{0xF254,0xFE2B,0x02},
{0xF256,0xF688,0x02},
{0xF258,0xFF6B,0x02},
{0xF25A,0xF693,0x02},
{0xF25C,0xFB6B,0x02},
{0xF25E,0xF687,0x02},
{0xF260,0xF947,0x02},
{0xF262,0xBC7E,0x02},
{0xF264,0xF688,0x02},
{0xF266,0xFD8F,0x02},
{0xF268,0x239C,0x02},
{0xF26A,0x0018,0x02},


{0x0006,0x16,0x01},                  //INCK_SET : 24MHz
};

// SR300PC20-0
// MIPI 2LANE 432/LANE
//        PLL   432MHz
//        DCK       54
// inifile
// size address data
//
static const isx012_regset_t SR300PC20_Pll_Setting_3[] =
{
{0x0007,0x00,0x01},                  // PLL_CKSEL                 : PLL 432MHz
{0x0008,0x00,0x01},                  // SRCCK_DIV                 : 1/5 frequency

{0x0004,0x03,0x01},                  //I2C_ADR_SEL 2: 0x3C MIPI selected, 3: 0x3D MIPI selected
{0x5008,0x00,0x01},                  //ENDIAN_SEL : 0:Little Endian
{0x6DA8,0x01,0x01},                  //SHD_CoEF (OTP shading ON flag)
{0x6DA9,0x09,0x01},                  // WHITE_CTRL
{0x6DCB,0x22,0x01},    // YGAM_CONFIG2 :

{0x00C4,0x11,0x01},                  // VIF_CLKCONFIG1            : VIFSEL and VIFDIV setting value with full frame pixel setting for other then JPG
{0x00C5,0x11,0x01},                  // VIF_CLKCONFIG2            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other then JPG
{0x00C6,0x11,0x01},                  // VIF_CLKCONFIG3            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other then JPG
{0x00C7,0x11,0x01},                  // VIF_CLKCONFIG4            : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other then JPG
{0x00C8,0x11,0x01},                  // VIF_CLKCONFIG5            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00C9,0x11,0x01},                  // VIF_CLKCONFIG6            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00CA,0x11,0x01},                  // VIF_CLKCONFIG7            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for JPG mode
{0x00CC,0x11,0x01},                  // VIF_CLKCONFIG9            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG and interleave mode
{0x00CD,0x11,0x01},                  // VIF_CLKCONFIG10           : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG and interleave mode
{0x6A12,0x11,0x01},                  // VIF_CLKCONFIG13 for RAW8  : VIFSEL and VIFDIV setting value with full frame pixel setting for RAW mode
{0x6A13,0x11,0x01},                  // VIF_CLKCONFIG14 for RAW8  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for RAW mode
{0x6A14,0x11,0x01},                  // VIF_CLKCONFIG15 for RAW8  : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for RAW mode
{0x6A15,0x11,0x01},                  // VIF_CLKCONFIG16 for RAW8  : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for RAW mode
{0x018C,0x0000,0x02},                // VADJ_SENS_1_1             : VMAX adjustment value for full frame pixel
{0x018E,0x0012,0x02},                // VADJ_SENS_1_2             : VMAX adjustment value for 1/2 sub-sampling
{0x0190,0x0000,0x02},               // VADJ_SENS_1_4             : VMAX adjustment value for 1/4 sub-sampling
{0x0192,0x0000,0x02},               // VADJ_SENS_1_8             : VMAX adjustment value for 1/8 sub-sampling
{0x0194,0x0027,0x02},               // VADJ_SENS_HD_1_1          : VMAX adjustment value for HD full frame pixel
{0x0196,0x0015,0x02},               // VADJ_SENS_HD_1_2          : VMAX adjustment value for HD 1/2 sub-sampling
{0x6A16,0x0440,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_1 : Detection window vertical size with all 32 windows for FLC full frame pixel
{0x6A18,0x03C0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_2 : Detection window vertical size with all 32 windows for FLC 1/2 sub-sampling
{0x6A1A,0x01E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_4 : Detection window vertical size with all 32 windows for FLC 1/4 sub-sampling
{0x6A1C,0x00E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_8 : Detection window vertical size with all 32 windows for FLC 1/8 sub-sampling
{0x6A1E,0x0420,0x02},               // FLC_OPD_HEIGHT_HD_1_1     : Detection window vertical size with all 32 windows for FLC HD full frame pixel
{0x6A20,0x02C0,0x02},               // FLC_OPD_HEIGHT_HD_1_2     : Detection window vertical size with all 32 windows for FLC HD 1/2 sub-sampling
{0x0016,0x0010,0x02},               // GPIO_FUNCSEL              : GPIO setting
{0x5C01,0x00,0x01},                  // RGLANESEL                 :
{0x5C04,0x04,0x01},                  // RGTLPX                    :
{0x5C05,0x03,0x01},                  // RGTCLKPREPARE             :
{0x5C06,0x0E,0x01},                  // RGTCLKZERO                :
{0x5C07,0x02,0x01},                  // RGTCLKPRE                 :
{0x5C08,0x0B,0x01},                  // RGTCLKPOST                :
{0x5C09,0x05,0x01},                  // RGTCLKTRAIL               :
{0x5C0A,0x07,0x01},                  // RGTHSEXIT                 :
{0x5C0B,0x03,0x01},                  // RGTHSPREPARE              :
{0x5C0C,0x07,0x01},                  // RGTHSZERO                 :
{0x5C0D,0x05,0x01},                  // RGTHSTRAIL                :

{0x0009,0x01,0x01},		//
{0x000A,0x03,0x01},		// EXT_SRCCK_DIV	: 1/8 frequency
{0x00D8,0x11,0x01},                 // VIF_CLKCONFIG_EXT9  : VIFSEL and VIFDIV setting value with full frame pixel setting for other than JPG
{0x00D9,0x11,0x01},                 // VIF_CLKCONFIG_EXT10 : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other than JPG
{0x00DA,0x11,0x01},                 // VIF_CLKCONFIG_EXT11 : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other than JPG
{0x00DB,0x11,0x01},                 // VIF_CLKCONFIG_EXT12 : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other than JPG
{0x00AC,0x02,0x01},                 //

//init Preview setting
{0x0089,0x00,0x01},//OUTFMT_MONI
{0x0090,0x0280,0x02},//HSIZE_MONI : 640
{0x0096,0x01E0,0x02},//VSIZE_MONI : 480
{0x0083,0x01,0x01},//SENSMODE_MONI
{0x0086,0x02,0x01},//FPSTYPE_MONI
{0x0081,0x00,0x01},//MODESEL
{0x0082,0x01,0x01},//MONI_REFRESH

//jpeg setting
//Apex40 is not Jpeg Capture

//Fast mode setting
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT

//Select sensor inversion link control
{0x501A,0x00,0x01},    //SENS_REVERSE_CTRL

//shading
{0x6DBC,0x03,0x01},    // WHITE_EDGE_MAX :
{0x6DF6,0xFF,0x01},    // WHITE_SHD_JUDGE_BODY_COLOR_RATIO :
{0x6DF7,0xF0,0x01},    // WHITE_SHD_JUDGE_RED_RATIO :
{0x6DAD,0x0C,0x01},    // WHITE_OFSET1_UP :
{0x6DAE,0x0C,0x01},    // WHITE_OFSET1_DOWN :
{0x6DAF,0x11,0x01},    // WHITE_OFSET1_RIGHT :
{0x6DB0,0x1B,0x01},    // WHITE_OFSET1_LEFT :
{0x6DB1,0x0D,0x01},    // WHITE_OFSET2_UP :
{0x6DB2,0x13,0x01},    // WHITE_OFSET2_DOWN :
{0x6DB3,0x11,0x01},    // WHITE_OFSET2_RIGHT :
{0x6DB4,0x17,0x01},    // WHITE_OFSET2_LEFT :

//additional code
{0xF200,0xB9B9,0x02},
{0xF202,0x4E12,0x02},
{0xF204,0x6055,0x02},
{0xF206,0x008B,0x02},
{0xF208,0xF177,0x02},
{0xF20A,0xFA70,0x02},
{0xF20C,0x0000,0x02},
{0xF20E,0x0000,0x02},
{0xF210,0x0000,0x02},
{0xF212,0x0000,0x02},
{0xF214,0x0000,0x02},
{0xF216,0x0000,0x02},
{0xF218,0x0000,0x02},
{0xF21A,0x0000,0x02},
{0xF21C,0x0000,0x02},
{0xF21E,0x0000,0x02},
{0xF220,0x0000,0x02},
{0xF222,0x0000,0x02},
{0xF224,0x0000,0x02},
{0xF226,0x0000,0x02},
{0xF228,0x0000,0x02},
{0xF22A,0x0000,0x02},
{0xF22C,0x0000,0x02},
{0xF22E,0x0000,0x02},
{0xF230,0x0000,0x02},
{0xF232,0x0000,0x02},
{0xF234,0x0000,0x02},
{0xF236,0x0000,0x02},
{0xF238,0x0000,0x02},
{0xF23A,0x0000,0x02},
{0xF23C,0x0000,0x02},
{0xF23E,0x0000,0x02},
{0xF240,0x0000,0x02},
{0xF242,0x0000,0x02},
{0xF244,0xB47E,0x02},
{0xF246,0x4808,0x02},
{0xF248,0x7800,0x02},
{0xF24A,0x07C0,0x02},
{0xF24C,0x0FC0,0x02},
{0xF24E,0xF687,0x02},
{0xF250,0xF8ED,0x02},
{0xF252,0xF68E,0x02},
{0xF254,0xFE2B,0x02},
{0xF256,0xF688,0x02},
{0xF258,0xFF6B,0x02},
{0xF25A,0xF693,0x02},
{0xF25C,0xFB6B,0x02},
{0xF25E,0xF687,0x02},
{0xF260,0xF947,0x02},
{0xF262,0xBC7E,0x02},
{0xF264,0xF688,0x02},
{0xF266,0xFD8F,0x02},
{0xF268,0x239C,0x02},
{0xF26A,0x0018,0x02},

{0x0006,0x16,0x01},                  //INCK_SET : 24MHz
};

// SR300PC20-0
// MIPI 2LANE 432/LANE
//        PLL   432MHz
//        DCK       54
// inifile
// size address data
//
static const isx012_regset_t SR300PC20_Pll_Setting_4[] =
{
{0x0007,0x00,0x01},                  // PLL_CKSEL                 : PLL 432MHz
{0x0008,0x00,0x01},                  // SRCCK_DIV                 : 1/5 frequency

{0x0004,0x03,0x01},                  //I2C_ADR_SEL 2: 0x3C MIPI selected, 3: 0x3D MIPI selected
{0x5008,0x00,0x01},                  //ENDIAN_SEL : 0:Little Endian
{0x6DA8,0x01,0x01},                  //SHD_CoEF (OTP shading ON flag)
{0x6DA9,0x09,0x01},                  // WHITE_CTRL
{0x6DCB,0x22,0x01},    // YGAM_CONFIG2 :

{0x00C4,0x11,0x01},                  // VIF_CLKCONFIG1            : VIFSEL and VIFDIV setting value with full frame pixel setting for other then JPG
{0x00C5,0x11,0x01},                  // VIF_CLKCONFIG2            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other then JPG
{0x00C6,0x11,0x01},                  // VIF_CLKCONFIG3            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other then JPG
{0x00C7,0x11,0x01},                  // VIF_CLKCONFIG4            : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other then JPG
{0x00C8,0x11,0x01},                  // VIF_CLKCONFIG5            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00C9,0x11,0x01},                  // VIF_CLKCONFIG6            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00CA,0x11,0x01},                  // VIF_CLKCONFIG7            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for JPG mode
{0x00CC,0x11,0x01},                  // VIF_CLKCONFIG9            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG and interleave mode
{0x00CD,0x11,0x01},                  // VIF_CLKCONFIG10           : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG and interleave mode
{0x6A12,0x11,0x01},                  // VIF_CLKCONFIG13 for RAW8  : VIFSEL and VIFDIV setting value with full frame pixel setting for RAW mode
{0x6A13,0x11,0x01},                  // VIF_CLKCONFIG14 for RAW8  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for RAW mode
{0x6A14,0x11,0x01},                  // VIF_CLKCONFIG15 for RAW8  : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for RAW mode
{0x6A15,0x11,0x01},                  // VIF_CLKCONFIG16 for RAW8  : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for RAW mode
{0x018C,0x0026,0x02},                // VADJ_SENS_1_1             : VMAX adjustment value for full frame pixel
{0x018E,0x0012,0x02},                // VADJ_SENS_1_2             : VMAX adjustment value for 1/2 sub-sampling
{0x0190,0x0000,0x02},               // VADJ_SENS_1_4             : VMAX adjustment value for 1/4 sub-sampling
{0x0192,0x0000,0x02},               // VADJ_SENS_1_8             : VMAX adjustment value for 1/8 sub-sampling
{0x0194,0x0027,0x02},               // VADJ_SENS_HD_1_1          : VMAX adjustment value for HD full frame pixel
{0x0196,0x0015,0x02},               // VADJ_SENS_HD_1_2          : VMAX adjustment value for HD 1/2 sub-sampling
{0x6A16,0x0440,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_1 : Detection window vertical size with all 32 windows for FLC full frame pixel
{0x6A18,0x03C0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_2 : Detection window vertical size with all 32 windows for FLC 1/2 sub-sampling
{0x6A1A,0x01E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_4 : Detection window vertical size with all 32 windows for FLC 1/4 sub-sampling
{0x6A1C,0x00E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_8 : Detection window vertical size with all 32 windows for FLC 1/8 sub-sampling
{0x6A1E,0x0420,0x02},               // FLC_OPD_HEIGHT_HD_1_1     : Detection window vertical size with all 32 windows for FLC HD full frame pixel
{0x6A20,0x02C0,0x02},               // FLC_OPD_HEIGHT_HD_1_2     : Detection window vertical size with all 32 windows for FLC HD 1/2 sub-sampling
{0x0016,0x0010,0x02},               // GPIO_FUNCSEL              : GPIO setting
{0x5C01,0x00,0x01},                  // RGLANESEL                 :
{0x5C04,0x04,0x01},                  // RGTLPX                    :
{0x5C05,0x03,0x01},                  // RGTCLKPREPARE             :
{0x5C06,0x0E,0x01},                  // RGTCLKZERO                :
{0x5C07,0x02,0x01},                  // RGTCLKPRE                 :
{0x5C08,0x0B,0x01},                  // RGTCLKPOST                :
{0x5C09,0x05,0x01},                  // RGTCLKTRAIL               :
{0x5C0A,0x07,0x01},                  // RGTHSEXIT                 :
{0x5C0B,0x03,0x01},                  // RGTHSPREPARE              :
{0x5C0C,0x07,0x01},                  // RGTHSZERO                 :
{0x5C0D,0x05,0x01},                  // RGTHSTRAIL                :

{0x6A9E,0x15C0,0x02},                //HMAX_1_1(0x6A9E)=0x15C0

{0x0009,0x01,0x01},		//
{0x000A,0x03,0x01},		// EXT_SRCCK_DIV	: 1/8 frequency
{0x00D8,0x11,0x01},                 // VIF_CLKCONFIG_EXT9  : VIFSEL and VIFDIV setting value with full frame pixel setting for other than JPG
{0x00D9,0x11,0x01},                 // VIF_CLKCONFIG_EXT10 : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other than JPG
{0x00DA,0x11,0x01},                 // VIF_CLKCONFIG_EXT11 : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other than JPG
{0x00DB,0x11,0x01},                 // VIF_CLKCONFIG_EXT12 : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other than JPG
{0x00AC,0x00,0x01},                 //

//init Preview setting
{0x0089,0x00,0x01},//OUTFMT_MONI
{0x0090,0x0280,0x02},//HSIZE_MONI : 640
{0x0096,0x01E0,0x02},//VSIZE_MONI : 480
{0x0083,0x01,0x01},//SENSMODE_MONI
{0x0086,0x02,0x01},//FPSTYPE_MONI
{0x0081,0x00,0x01},//MODESEL
{0x0082,0x01,0x01},//MONI_REFRESH

//jpeg setting
//Apex40 is not Jpeg Capture

//Fast mode setting
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT

//Select sensor inversion link control
{0x501A,0x00,0x01},    //SENS_REVERSE_CTRL

//shading
{0x6DBC,0x03,0x01},    // WHITE_EDGE_MAX :
{0x6DF6,0xFF,0x01},    // WHITE_SHD_JUDGE_BODY_COLOR_RATIO :
{0x6DF7,0xF0,0x01},    // WHITE_SHD_JUDGE_RED_RATIO :
{0x6DAD,0x0C,0x01},    // WHITE_OFSET1_UP :
{0x6DAE,0x0C,0x01},    // WHITE_OFSET1_DOWN :
{0x6DAF,0x11,0x01},    // WHITE_OFSET1_RIGHT :
{0x6DB0,0x1B,0x01},    // WHITE_OFSET1_LEFT :
{0x6DB1,0x0D,0x01},    // WHITE_OFSET2_UP :
{0x6DB2,0x13,0x01},    // WHITE_OFSET2_DOWN :
{0x6DB3,0x11,0x01},    // WHITE_OFSET2_RIGHT :
{0x6DB4,0x17,0x01},    // WHITE_OFSET2_LEFT :

//additional code
{0xF200,0xB9B9,0x02},
{0xF202,0x4E12,0x02},
{0xF204,0x6055,0x02},
{0xF206,0x008B,0x02},
{0xF208,0xF177,0x02},
{0xF20A,0xFA70,0x02},
{0xF20C,0x0000,0x02},
{0xF20E,0x0000,0x02},
{0xF210,0x0000,0x02},
{0xF212,0x0000,0x02},
{0xF214,0x0000,0x02},
{0xF216,0x0000,0x02},
{0xF218,0x0000,0x02},
{0xF21A,0x0000,0x02},
{0xF21C,0x0000,0x02},
{0xF21E,0x0000,0x02},
{0xF220,0x0000,0x02},
{0xF222,0x0000,0x02},
{0xF224,0x0000,0x02},
{0xF226,0x0000,0x02},
{0xF228,0x0000,0x02},
{0xF22A,0x0000,0x02},
{0xF22C,0x0000,0x02},
{0xF22E,0x0000,0x02},
{0xF230,0x0000,0x02},
{0xF232,0x0000,0x02},
{0xF234,0x0000,0x02},
{0xF236,0x0000,0x02},
{0xF238,0x0000,0x02},
{0xF23A,0x0000,0x02},
{0xF23C,0x0000,0x02},
{0xF23E,0x0000,0x02},
{0xF240,0x0000,0x02},
{0xF242,0x0000,0x02},
{0xF244,0xB47E,0x02},
{0xF246,0x4808,0x02},
{0xF248,0x7800,0x02},
{0xF24A,0x07C0,0x02},
{0xF24C,0x0FC0,0x02},
{0xF24E,0xF687,0x02},
{0xF250,0xF8ED,0x02},
{0xF252,0xF68E,0x02},
{0xF254,0xFE2B,0x02},
{0xF256,0xF688,0x02},
{0xF258,0xFF6B,0x02},
{0xF25A,0xF693,0x02},
{0xF25C,0xFB6B,0x02},
{0xF25E,0xF687,0x02},
{0xF260,0xF947,0x02},
{0xF262,0xBC7E,0x02},
{0xF264,0xF688,0x02},
{0xF266,0xFD8F,0x02},
{0xF268,0x239C,0x02},
{0xF26A,0x0018,0x02},

{0x0006,0x16,0x01},                  //INCK_SET : 24MHz
};

static const isx012_regset_t SR300PC20_Preview_SizeSetting[] =
{
{0x0090,0x0280,0x02},    //HSIZE_MONI : 640
{0x0096,0x01E0,0x02},    //VSIZE_MONI : 480
};

static const isx012_regset_t SR300PC20_Preview_Mode[] =
{
{0x5000,0x00,0x01}, /* CPUEXT, added by SAMSUNG TN */
{0x5E32,0x0F,0x01}, /* for Fast-AE reset */
{0x5E3D,0x0A,0x01}, /* for Fast-AE reset */
{0x0181,0x00,0x01},    // CAP_HALF_AE_CTRL

{0x0089,0x00,0x01},    //OUTFMT_MONI
{0x0083,0x01,0x01},    //SENSMODE_MONI
{0x0086,0x02,0x01},    //FPSTYPE_MONI
{0x0012,0xFF,0x01},    //INTCLR0
{0x00F7,0x52,0x01},    // INIT_QLTY0 : Standard 82
{0x00F8,0x59,0x01},    // INIT_QLTY1 : Fine 89
{0x00F9,0x5F,0x01},    // INIT_QLTY2 : SuperFine 95
{0x0081,0x00,0x01},    //MODESEL
{0x0082,0x01,0x01},    //MONI_REFRESH
{0xFFFF,0x1E,0x01},    //$wait,30
};

static const isx012_regset_t SR300PC20_Camcorder_Mode_ON[] =
{
//SN setting
{0x0308,0x02,0x01},    // AELINE_MONI_SN1_2 :
{0x0320,0x02,0x01},    // AELINE_MONI_SN1_2 :
{0x00B2,0x02,0x01},    /* AFMODE_MONI : manual mode */

//BRIGHTNESS setting
{0x01C6,0x10,0x01},    //UIBRIGHTNESS

//AE speed
{0x02AC,0x00,0x01},    // AE_SUB_SN1 :
{0x5E2D,0x0C,0x01},    // AEMOVECNT :
{0x5E2E,0x20,0x01},    // AEINDEADBAND :
{0x5E2F,0x08,0x01},    // AEOUTDEADBAND :
{0x5E30,0xA0,0x01},    // AESPEED :

{0x5E31,0x0F,0x01},    // AESPEED_INIT :
{0x5E32,0x0F,0x01},    // AESPEED_FAST :

{0x621E,0x18,0x01},    // AIM_NR_TH_UP :
{0x621F,0x18,0x01},    // AIM_NR_TH_DOWN :
{0x6220,0x18,0x01},    // AIM_NR_TH_RIGHT :
{0x6221,0x18,0x01},    // AIM_NR_TH_LEFT :

//AWB speed
{0x6222,0x00,0x01},    // INIT_AIMW :
{0x6223,0x04,0x01},    // INIT_GAINS :
{0x6224,0x10,0x01},    // ATW_DELAY :
{0x6225,0x00,0x01},    // ATW_AIMW :

{0x6226,0x20,0x01},    // ATW_GAINS_IN_NR :
{0x6227,0x30,0x01},    // ATW_GAINS_IN :
{0x6228,0x20,0x01},    // ATW_GAINS_OUT_NR :
{0x6229,0x30,0x01},    // ATW_GAINS_OUT :
{0x622A,0x0D,0x01},    // ALLWB_GAINS :

//Gammma Table 0
{0x7000,0x0000,0x02},    // G0_KNOT_G0 :
{0x7002,0x0000,0x02},    // G0_KNOT_G1 :
{0x7004,0x001E,0x02},    // G0_KNOT_G2 :
{0x7006,0x0038,0x02},    // G0_KNOT_G3 :
{0x7008,0x0046,0x02},    // G0_KNOT_G4 :
{0x700A,0x0053,0x02},    // G0_KNOT_G5 :
{0x700C,0x005A,0x02},    // G0_KNOT_G6 :
{0x700E,0x0063,0x02},    // G0_KNOT_G7 :
{0x7010,0x006D,0x02},    // G0_KNOT_G8 :
{0x7012,0x0076,0x02},    // G0_KNOT_G9 :
{0x7014,0x0055,0x02},    // G0_KNOT_G10 :
{0x7016,0x008E,0x02},    // G0_KNOT_G11 :
{0x7018,0x00B9,0x02},    // G0_KNOT_G12 :
{0x701A,0x00D5,0x02},    // G0_KNOT_G13 :
{0x701C,0x00E4,0x02},    // G0_KNOT_G14 :
{0x701E,0x00F0,0x02},    // G0_KNOT_G15 :
{0x7020,0x00F9,0x02},    // G0_KNOT_G16 :
{0x7022,0x0103,0x02},    // G0_KNOT_G17 :
{0x7024,0x010C,0x02},    // G0_KNOT_G18 :
{0x7026,0x00,0x01},    // G0_KNOT_R0_OFFSET :
{0x7027,0x00,0x01},    // G0_KNOT_R2_OFFSET :
{0x7028,0x00,0x01},    // G0_KNOT_R4_OFFSET :
{0x7029,0x00,0x01},    // G0_KNOT_R6_OFFSET :
{0x702A,0x00,0x01},    // G0_KNOT_R8_OFFSET :
{0x702B,0x00,0x01},    // G0_KNOT_R10_OFFSET :
{0x702C,0x00,0x01},    // G0_KNOT_R12_OFFSET :
{0x702D,0x00,0x01},    // G0_KNOT_R14_OFFSET :
{0x702E,0x00,0x01},    // G0_KNOT_R16_OFFSET :
{0x702F,0x00,0x01},    // G0_KNOT_R18_OFFSET :
{0x7030,0x00,0x01},    // G0_KNOT_B0_OFFSET :
{0x7031,0x00,0x01},    // G0_KNOT_B2_OFFSET :
{0x7032,0x00,0x01},    // G0_KNOT_B4_OFFSET :
{0x7033,0x00,0x01},    // G0_KNOT_B6_OFFSET :
{0x7034,0x00,0x01},    // G0_KNOT_B8_OFFSET :
{0x7035,0x00,0x01},    // G0_KNOT_B10_OFFSET :
{0x7036,0x00,0x01},    // G0_KNOT_B12_OFFSET :
{0x7037,0x00,0x01},    // G0_KNOT_B14_OFFSET :
{0x7038,0x00,0x01},    // G0_KNOT_B16_OFFSET :
{0x7039,0x00,0x01},    // G0_KNOT_B18_OFFSET :
{0x703A,0x0611,0x02},    // G0_LOWGM_ON_R :
{0x703C,0x1E0A,0x02},    // G0_0CLIP_R :
{0x703E,0x0611,0x02},    // G0_LOWGM_ON_G :
{0x7040,0x1E0A,0x02},    // G0_0CLIP_G :
{0x7042,0x0611,0x02},    // G0_LOWGM_ON_B :
{0x7044,0x1E0A,0x02},    // G0_0CLIP_B :
{0x7046,0x91,0x01},    // G0_KNOT_GAINCTRL_TH_L :
{0x7047,0x96,0x01},    // G0_KNOT_GAINCTRL_TH_H :
{0x7048,0x0000,0x02},    // G0_KNOT_L_G0 :
{0x704A,0x0000,0x02},    // G0_KNOT_L_G1 :
{0x704C,0x000E,0x02},    // G0_KNOT_L_G2 :
{0x704E,0x002F,0x02},    // G0_KNOT_L_G3 :
{0x7050,0x003D,0x02},    // G0_KNOT_L_G4 :
{0x7052,0x004A,0x02},    // G0_KNOT_L_G5 :
{0x7054,0x0051,0x02},    // G0_KNOT_L_G6 :
{0x7056,0x005A,0x02},    // G0_KNOT_L_G7 :
{0x7058,0x0061,0x02},    // G0_KNOT_L_G8 :
{0x705A,0x006A,0x02},    // G0_KNOT_L_G9 :
{0x705C,0x0049,0x02},    // G0_KNOT_L_G10 :
{0x705E,0x0082,0x02},    // G0_KNOT_L_G11 :
{0x7060,0x00AD,0x02},    // G0_KNOT_L_G12 :
{0x7062,0x00CC,0x02},    // G0_KNOT_L_G13 :
{0x7064,0x00E1,0x02},    // G0_KNOT_L_G14 :
{0x7066,0x00ED,0x02},    // G0_KNOT_L_G15 :
{0x7068,0x00F6,0x02},    // G0_KNOT_L_G16 :
{0x706A,0x0106,0x02},    // G0_KNOT_L_G17 :
{0x706C,0x010C,0x02},    // G0_KNOT_L_G18 :


{0x6400,0x00,0x01},    // INFRM_LEFT00 :
{0x6401,0x00,0x01},    // INFRM_LEFT01 :
{0x6402,0x00,0x01},    // INFRM_LEFT02 :
{0x6403,0x00,0x01},    // INFRM_LEFT03 :
{0x6404,0x00,0x01},    // INFRM_LEFT04 :
{0x6405,0x00,0x01},    // INFRM_LEFT05 :
{0x6406,0x00,0x01},    // INFRM_LEFT06 :
{0x6407,0x00,0x01},    // INFRM_LEFT07 :
{0x6408,0x00,0x01},    // INFRM_LEFT08 :
{0x6409,0x00,0x01},    // INFRM_LEFT09 :
{0x640A,0x00,0x01},    // INFRM_LEFT10 :
{0x640B,0x00,0x01},    // INFRM_LEFT11 :
{0x640C,0x00,0x01},    // INFRM_LEFT12 :
{0x640D,0x00,0x01},    // INFRM_LEFT13 :
{0x640E,0x00,0x01},    // INFRM_LEFT14 :
{0x640F,0x00,0x01},    // INFRM_LEFT15 :
{0x6410,0x00,0x01},    // INFRM_LEFT16 :
{0x6411,0x00,0x01},    // INFRM_LEFT17 :
{0x6412,0x00,0x01},    // INFRM_LEFT18 :
{0x6413,0x00,0x01},    // INFRM_LEFT19 :
{0x6414,0x00,0x01},    // INFRM_LEFT20 :
{0x6415,0x00,0x01},    // INFRM_LEFT21 :
{0x6416,0x00,0x01},    // INFRM_LEFT22 :
{0x6417,0x00,0x01},    // INFRM_LEFT23 :
{0x6418,0x00,0x01},    // INFRM_LEFT24 :
{0x6419,0x00,0x01},    // INFRM_LEFT25 :
{0x641A,0x00,0x01},    // INFRM_LEFT26 :
{0x641B,0x00,0x01},    // INFRM_LEFT27 :
{0x641C,0x00,0x01},    // INFRM_LEFT28 :
{0x641D,0x00,0x01},    // INFRM_LEFT29 :
{0x641E,0x00,0x01},    // INFRM_LEFT30 :
{0x641F,0x00,0x01},    // INFRM_LEFT31 :
{0x6420,0x00,0x01},    // INFRM_LEFT32 :
{0x6421,0x00,0x01},    // INFRM_LEFT33 :
{0x6422,0x00,0x01},    // INFRM_LEFT34 :
{0x6423,0x00,0x01},    // INFRM_LEFT35 :
{0x6424,0x00,0x01},    // INFRM_LEFT36 :
{0x6425,0x00,0x01},    // INFRM_LEFT37 :
{0x6426,0xFF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xFF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xFF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xFF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xFF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xFF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xFF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xFF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xFF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xFF,0x01},    // INFRM_RIGHT09 :
{0x6430,0xFF,0x01},    // INFRM_RIGHT10 :
{0x6431,0xFF,0x01},    // INFRM_RIGHT11 :
{0x6432,0xFF,0x01},    // INFRM_RIGHT12 :
{0x6433,0xFF,0x01},    // INFRM_RIGHT13 :
{0x6434,0xFF,0x01},    // INFRM_RIGHT14 :
{0x6435,0xFF,0x01},    // INFRM_RIGHT15 :
{0x6436,0xFF,0x01},    // INFRM_RIGHT16 :
{0x6437,0xFF,0x01},    // INFRM_RIGHT17 :
{0x6438,0xFF,0x01},    // INFRM_RIGHT18 :
{0x6439,0xFF,0x01},    // INFRM_RIGHT19 :
{0x643A,0xFF,0x01},    // INFRM_RIGHT20 :
{0x643B,0xFF,0x01},    // INFRM_RIGHT21 :
{0x643C,0xFF,0x01},    // INFRM_RIGHT22 :
{0x643D,0xFF,0x01},    // INFRM_RIGHT23 :
{0x643E,0xFF,0x01},    // INFRM_RIGHT24 :
{0x643F,0xFF,0x01},    // INFRM_RIGHT25 :
{0x6440,0xFF,0x01},    // INFRM_RIGHT26 :
{0x6441,0xFF,0x01},    // INFRM_RIGHT27 :
{0x6442,0xFF,0x01},    // INFRM_RIGHT28 :
{0x6443,0xFF,0x01},    // INFRM_RIGHT29 :
{0x6444,0xFF,0x01},    // INFRM_RIGHT30 :
{0x6445,0xFF,0x01},    // INFRM_RIGHT31 :
{0x6446,0xFF,0x01},    // INFRM_RIGHT32 :
{0x6447,0xFF,0x01},    // INFRM_RIGHT33 :
{0x6448,0xFF,0x01},    // INFRM_RIGHT34 :
{0x6449,0xFF,0x01},    // INFRM_RIGHT35 :
{0x644A,0xFF,0x01},    // INFRM_RIGHT36 :
{0x644B,0xFF,0x01},    // INFRM_RIGHT37 :
{0x644C,0xFFFF,0x02},	 // INFRM_TOP :
{0x644E,0x0000,0x02},	 // INFRM_BOTM :
{0x6450,0x25,0x01},    // INFRM_FLTOP :
{0x6451,0x00,0x01},    // INFRM_FLBOTM :
{0x6452,0x91,0x01},    // INAIM_LEFT00 :
{0x6453,0x91,0x01},    // INAIM_LEFT01 :
{0x6454,0x91,0x01},    // INAIM_LEFT02 :
{0x6455,0x91,0x01},    // INAIM_LEFT03 :
{0x6456,0x91,0x01},    // INAIM_LEFT04 :
{0x6457,0x91,0x01},    // INAIM_LEFT05 :
{0x6458,0x91,0x01},    // INAIM_LEFT06 :
{0x6459,0x91,0x01},    // INAIM_LEFT07 :
{0x645A,0x91,0x01},    // INAIM_LEFT08 :
{0x645B,0x91,0x01},    // INAIM_LEFT09 :
{0x645C,0x91,0x01},    // INAIM_LEFT10 :
{0x645D,0x91,0x01},    // INAIM_LEFT11 :
{0x645E,0x91,0x01},    // INAIM_LEFT12 :
{0x645F,0x66,0x01},    // INAIM_LEFT13 :
{0x6460,0x5D,0x01},    // INAIM_LEFT14 :
{0x6461,0x69,0x01},    // INAIM_LEFT15 :
{0x6462,0x54,0x01},    // INAIM_LEFT16 :
{0x6463,0x4B,0x01},    // INAIM_LEFT17 :
{0x6464,0x42,0x01},    // INAIM_LEFT18 :
{0x6465,0x3C,0x01},    // INAIM_LEFT19 :
{0x6466,0x38,0x01},    // INAIM_LEFT20 :
{0x6467,0x36,0x01},    // INAIM_LEFT21 :
{0x6468,0x35,0x01},    // INAIM_LEFT22 :
{0x6469,0x33,0x01},    // INAIM_LEFT23 :
{0x646A,0x32,0x01},    // INAIM_LEFT24 :
{0x646B,0x30,0x01},    // INAIM_LEFT25 :
{0x646C,0x2F,0x01},    // INAIM_LEFT26 :
{0x646D,0x2D,0x01},    // INAIM_LEFT27 :
{0x646E,0x2C,0x01},    // INAIM_LEFT28 :
{0x646F,0x2B,0x01},    // INAIM_LEFT29 :
{0x6470,0x2A,0x01},    // INAIM_LEFT30 :
{0x6471,0x28,0x01},    // INAIM_LEFT31 :
{0x6472,0x26,0x01},    // INAIM_LEFT32 :
{0x6473,0x24,0x01},    // INAIM_LEFT33 :
{0x6474,0x29,0x01},    // INAIM_LEFT34 :
{0x6475,0x28,0x01},    // INAIM_LEFT35 :
{0x6476,0x29,0x01},    // INAIM_LEFT36 :
{0x6477,0x26,0x01},    // INAIM_LEFT37 :
{0x6478,0xFF,0x01},    // INAIM_RIGHT00 :
{0x6479,0xFF,0x01},    // INAIM_RIGHT01 :
{0x647A,0xFF,0x01},    // INAIM_RIGHT02 :
{0x647B,0xFF,0x01},    // INAIM_RIGHT03 :
{0x647C,0xFF,0x01},    // INAIM_RIGHT04 :
{0x647D,0xFF,0x01},    // INAIM_RIGHT05 :
{0x647E,0xFF,0x01},    // INAIM_RIGHT06 :
{0x647F,0xFF,0x01},    // INAIM_RIGHT07 :
{0x6480,0xFF,0x01},    // INAIM_RIGHT08 :
{0x6481,0xFF,0x01},    // INAIM_RIGHT09 :
{0x6482,0xD9,0x01},    // INAIM_RIGHT10 :
{0x6483,0xB7,0x01},    // INAIM_RIGHT11 :
{0x6484,0x96,0x01},    // INAIM_RIGHT12 :
{0x6485,0x68,0x01},    // INAIM_RIGHT13 :
{0x6486,0x70,0x01},    // INAIM_RIGHT14 :
{0x6487,0x72,0x01},    // INAIM_RIGHT15 :
{0x6488,0x71,0x01},    // INAIM_RIGHT16 :
{0x6489,0x6B,0x01},    // INAIM_RIGHT17 :
{0x648A,0x65,0x01},    // INAIM_RIGHT18 :
{0x648B,0x60,0x01},    // INAIM_RIGHT19 :
{0x648C,0x5B,0x01},    // INAIM_RIGHT20 :
{0x648D,0x56,0x01},    // INAIM_RIGHT21 :
{0x648E,0x51,0x01},    // INAIM_RIGHT22 :
{0x648F,0x4C,0x01},    // INAIM_RIGHT23 :
{0x6490,0x47,0x01},    // INAIM_RIGHT24 :
{0x6491,0x44,0x01},    // INAIM_RIGHT25 :
{0x6492,0x41,0x01},    // INAIM_RIGHT26 :
{0x6493,0x3E,0x01},    // INAIM_RIGHT27 :
{0x6494,0x3B,0x01},    // INAIM_RIGHT28 :
{0x6495,0x39,0x01},    // INAIM_RIGHT29 :
{0x6496,0x37,0x01},    // INAIM_RIGHT30 :
{0x6497,0x34,0x01},    // INAIM_RIGHT31 :
{0x6498,0x33,0x01},    // INAIM_RIGHT32 :
{0x6499,0x32,0x01},    // INAIM_RIGHT33 :
{0x649A,0x31,0x01},    // INAIM_RIGHT34 :
{0x649B,0x30,0x01},    // INAIM_RIGHT35 :
{0x649C,0x2F,0x01},    // INAIM_RIGHT36 :
{0x649D,0x2E,0x01},    // INAIM_RIGHT37 :
{0x649E,0x1E00,0x02},	 // INAIM_TOP :
{0x64A0,0x0F48,0x02},	 // INAIM_BOTM :
{0x64A2,0x18,0x01},    // INAIM_FLTOP :
{0x64A3,0x11,0x01},    // INAIM_FLBOTM :
{0x64A4,0x00,0x01},   // OUTFRM_LEFT00 :
{0x64A5,0x00,0x01},   // OUTFRM_LEFT01 :
{0x64A6,0x00,0x01},   // OUTFRM_LEFT02 :
{0x64A7,0x00,0x01},   // OUTFRM_LEFT03 :
{0x64A8,0x00,0x01},   // OUTFRM_LEFT04 :
{0x64A9,0x00,0x01},   // OUTFRM_LEFT05 :
{0x64AA,0x00,0x01},   // OUTFRM_LEFT06 :
{0x64AB,0x00,0x01},   // OUTFRM_LEFT07 :
{0x64AC,0x00,0x01},   // OUTFRM_LEFT08 :
{0x64AD,0x00,0x01},   // OUTFRM_LEFT09 :
{0x64AE,0x00,0x01},   // OUTFRM_LEFT10 :
{0x64AF,0x00,0x01},   // OUTFRM_LEFT11 :
{0x64B0,0x00,0x01},   // OUTFRM_LEFT12 :
{0x64B1,0x00,0x01},   // OUTFRM_LEFT13 :
{0x64B2,0x00,0x01},   // OUTFRM_LEFT14 :
{0x64B3,0x00,0x01},   // OUTFRM_LEFT15 :
{0x64B4,0x00,0x01},   // OUTFRM_LEFT16 :
{0x64B5,0x00,0x01},   // OUTFRM_LEFT17 :
{0x64B6,0x00,0x01},   // OUTFRM_LEFT18 :
{0x64B7,0x00,0x01},   // OUTFRM_LEFT19 :
{0x64B8,0x00,0x01},   // OUTFRM_LEFT20 :
{0x64B9,0x00,0x01},   // OUTFRM_LEFT21 :
{0x64BA,0x00,0x01},   // OUTFRM_LEFT22 :
{0x64BB,0x00,0x01},   // OUTFRM_LEFT23 :
{0x64BC,0x00,0x01},   // OUTFRM_LEFT24 :
{0x64BD,0x00,0x01},   // OUTFRM_LEFT25 :
{0x64BE,0x00,0x01},   // OUTFRM_LEFT26 :
{0x64BF,0x00,0x01},   // OUTFRM_LEFT27 :
{0x64C0,0x00,0x01},   // OUTFRM_LEFT28 :
{0x64C1,0x00,0x01},   // OUTFRM_LEFT29 :
{0x64C2,0x00,0x01},   // OUTFRM_LEFT30 :
{0x64C3,0x00,0x01},   // OUTFRM_LEFT31 :
{0x64C4,0x00,0x01},   // OUTFRM_LEFT32 :
{0x64C5,0x00,0x01},   // OUTFRM_LEFT33 :
{0x64C6,0x00,0x01},   // OUTFRM_LEFT34 :
{0x64C7,0x00,0x01},   // OUTFRM_LEFT35 :
{0x64C8,0x00,0x01},   // OUTFRM_LEFT36 :
{0x64C9,0x00,0x01},   // OUTFRM_LEFT37 :
{0x64CA,0xFF,0x01},   // OUTFRM_RIGHT00 :
{0x64CB,0xFF,0x01},   // OUTFRM_RIGHT01 :
{0x64CC,0xFF,0x01},   // OUTFRM_RIGHT02 :
{0x64CD,0xFF,0x01},   // OUTFRM_RIGHT03 :
{0x64CE,0xFF,0x01},   // OUTFRM_RIGHT04 :
{0x64CF,0xFF,0x01},   // OUTFRM_RIGHT05 :
{0x64D0,0xFF,0x01},   // OUTFRM_RIGHT06 :
{0x64D1,0xFF,0x01},   // OUTFRM_RIGHT07 :
{0x64D2,0xFF,0x01},   // OUTFRM_RIGHT08 :
{0x64D3,0xFF,0x01},   // OUTFRM_RIGHT09 :
{0x64D4,0xFF,0x01},   // OUTFRM_RIGHT10 :
{0x64D5,0xFF,0x01},   // OUTFRM_RIGHT11 :
{0x64D6,0xFF,0x01},   // OUTFRM_RIGHT12 :
{0x64D7,0xFF,0x01},   // OUTFRM_RIGHT13 :
{0x64D8,0xFF,0x01},   // OUTFRM_RIGHT14 :
{0x64D9,0xFF,0x01},   // OUTFRM_RIGHT15 :
{0x64DA,0xFF,0x01},   // OUTFRM_RIGHT16 :
{0x64DB,0xFF,0x01},   // OUTFRM_RIGHT17 :
{0x64DC,0xFF,0x01},   // OUTFRM_RIGHT18 :
{0x64DD,0xFF,0x01},   // OUTFRM_RIGHT19 :
{0x64DE,0xFF,0x01},   // OUTFRM_RIGHT20 :
{0x64DF,0xFF,0x01},   // OUTFRM_RIGHT21 :
{0x64E0,0xFF,0x01},   // OUTFRM_RIGHT22 :
{0x64E1,0xFF,0x01},   // OUTFRM_RIGHT23 :
{0x64E2,0xFF,0x01},   // OUTFRM_RIGHT24 :
{0x64E3,0xFF,0x01},   // OUTFRM_RIGHT25 :
{0x64E4,0xFF,0x01},   // OUTFRM_RIGHT26 :
{0x64E5,0xFF,0x01},   // OUTFRM_RIGHT27 :
{0x64E6,0xFF,0x01},   // OUTFRM_RIGHT28 :
{0x64E7,0xFF,0x01},   // OUTFRM_RIGHT29 :
{0x64E8,0xFF,0x01},   // OUTFRM_RIGHT30 :
{0x64E9,0xFF,0x01},   // OUTFRM_RIGHT31 :
{0x64EA,0xFF,0x01},   // OUTFRM_RIGHT32 :
{0x64EB,0xFF,0x01},   // OUTFRM_RIGHT33 :
{0x64EC,0xFF,0x01},   // OUTFRM_RIGHT34 :
{0x64ED,0xFF,0x01},   // OUTFRM_RIGHT35 :
{0x64EE,0xFF,0x01},   // OUTFRM_RIGHT36 :
{0x64EF,0xFF,0x01},   // OUTFRM_RIGHT37 :
{0x64F0,0x24F0,0x02},	// OUTFRM_TOP :
{0x64F2,0x1400,0x02},	// OUTFRM_BOTM :
{0x64F4,0x37,0x01},   // OUTFRM_FLTOP :
{0x64F5,0x00,0x01},   // OUTFRM_FLBOTM :

//AWB
{0x6232,0x07,0x01},//ATW_SFTLMT_OUT_NR
{0x6234,0x05,0x01},//ATW_SFTLMT_OUT

/////MC3 Setting/////
{0x7600,0x07,0x01},    // MC3_PXDEF0_SEL :
{0x7601,0x07,0x01},    // MC3_PYDEF0_SEL :
{0x7602,0x07,0x01},    // MC3_PXDEF1_SEL :
{0x7603,0x07,0x01},    // MC3_PYDEF1_SEL :
{0x7604,0x07,0x01},    // MC3_PXDEF2_SEL :
{0x7605,0x07,0x01},    // MC3_PYDEF2_SEL :
{0x7606,0x07,0x01},    // MC3_PXDEF3_SEL :
{0x7607,0x07,0x01},    // MC3_PYDEF3_SEL :
{0x7608,0x40,0x01},    // MC3_PXDEF0_A :
{0x7609,0x40,0x01},    // MC3_PXDEF0_B :
{0x760A,0x40,0x01},    // MC3_PXDEF0_C :
{0x760B,0x40,0x01},    // MC3_PYDEF0_A :
{0x760C,0x40,0x01},    // MC3_PYDEF0_B :
{0x760D,0x40,0x01},    // MC3_PYDEF0_C :
{0x760E,0x40,0x01},    // MC3_PXDEF1_A :
{0x760F,0x40,0x01},    // MC3_PXDEF1_B :
{0x7610,0x40,0x01},    // MC3_PXDEF1_C :
{0x7611,0x40,0x01},    // MC3_PYDEF1_A :
{0x7612,0x40,0x01},    // MC3_PYDEF1_B :
{0x7613,0x40,0x01},    // MC3_PYDEF1_C :
{0x7614,0x40,0x01},    // MC3_PXDEF2_A :
{0x7615,0x40,0x01},    // MC3_PXDEF2_B :
{0x7616,0x40,0x01},    // MC3_PXDEF2_C :
{0x7617,0x40,0x01},    // MC3_PYDEF2_A :
{0x7618,0x40,0x01},    // MC3_PYDEF2_B :
{0x7619,0x40,0x01},    // MC3_PYDEF2_C :
{0x761A,0x40,0x01},    // MC3_PXDEF3_A :
{0x761B,0x40,0x01},    // MC3_PXDEF3_B :
{0x761C,0x40,0x01},    // MC3_PXDEF3_C :
{0x761D,0x40,0x01},    // MC3_PYDEF3_A :
{0x761E,0x40,0x01},    // MC3_PYDEF3_B :
{0x761F,0x40,0x01},    // MC3_PYDEF3_C :
{0x7620,0x00,0x01},    // MC3_LUMSL0_IN :
{0x7621,0x06,0x01},    // MC3_LUMSL1_IN :
{0x7622,0x03,0x01},    // MC3_LUMSL2_IN :
{0x7623,0x06,0x01},    // MC3_LUMSL3_IN :
{0x7624,0x00,0x01},    // MC3_LUMSL0_OUT :
{0x7625,0x03,0x01},    // MC3_LUMSL1_OUT :
{0x7626,0x00,0x01},    // MC3_LUMSL2_OUT :
{0x7627,0x00,0x01},    // MC3_LUMSL3_OUT :
{0x7628,0x0000,0x02},    // MC3_L0DEF0_IN :
{0x762A,0x008C,0x02},    // MC3_L0DEF1_IN :
{0x762C,0x0078,0x02},    // MC3_L0DEF2_IN :
{0x762E,0x00E6,0x02},    // MC3_L0DEF3_IN :
{0x7630,0x0000,0x02},    // MC3_L0DEF0_OUT :
{0x7632,0x0082,0x02},    // MC3_L0DEF1_OUT :
{0x7634,0x0000,0x02},    // MC3_L0DEF2_OUT :
{0x7636,0x0000,0x02},    // MC3_L0DEF3_OUT :
{0x7638,0x41,0x01},    // MC3_RDEF0_POS1 :
{0x7639,0x10,0x01},    // MC3_RDEF1_POS1 :
{0x763A,0x15,0x01},    // MC3_RDEF2_POS1 :
{0x763B,0x71,0x01},    // MC3_RDEF3_POS1 :
{0x763C,0x41,0x01},    // MC3_RDEF0_POS2 :
{0x763D,0x10,0x01},    // MC3_RDEF1_POS2 :
{0x763E,0x15,0x01},    // MC3_RDEF2_POS2 :
{0x763F,0x71,0x01},    // MC3_RDEF3_POS2 :
{0x7640,0x3C,0x01},    // MC3_RDEF0_POS3 :
{0x7641,0x10,0x01},    // MC3_RDEF1_POS3 :
{0x7642,0x15,0x01},    // MC3_RDEF2_POS3 :
{0x7643,0x71,0x01},    // MC3_RDEF3_POS3 :
{0x7644,0x46,0x01},    // MC3_RDEF0_POS4 :
{0x7645,0x32,0x01},    // MC3_RDEF1_POS4 :
{0x7646,0x15,0x01},    // MC3_RDEF2_POS4 :
{0x7647,0x71,0x01},    // MC3_RDEF3_POS4 :
{0x7648,0x46,0x01},    // MC3_RDEF0_POS5 :
{0x7649,0x32,0x01},    // MC3_RDEF1_POS5 :
{0x764A,0x15,0x01},    // MC3_RDEF2_POS5 :
{0x764B,0x71,0x01},    // MC3_RDEF3_POS5 :
{0x764C,0x46,0x01},    // MC3_RDEF0_POS6 :
{0x764D,0x10,0x01},    // MC3_RDEF1_POS6 :
{0x764E,0x15,0x01},    // MC3_RDEF2_POS6 :
{0x764F,0x71,0x01},    // MC3_RDEF3_POS6 :
{0x7650,0x46,0x01},    // MC3_RDEF0_POS7 :
{0x7651,0x10,0x01},    // MC3_RDEF1_POS7 :
{0x7652,0x15,0x01},    // MC3_RDEF2_POS7 :
{0x7653,0x71,0x01},    // MC3_RDEF3_POS7 :
{0x7654,0x2D,0x01},    // MC3_RDEF0_OUT :
{0x7655,0x10,0x01},    // MC3_RDEF1_OUT :
{0x7656,0x15,0x01},    // MC3_RDEF2_OUT :
{0x7657,0x54,0x01},    // MC3_RDEF3_OUT :
{0x7658,0x46,0x01},    // MC3_RDEF0_R2_POS4 :
{0x7659,0x32,0x01},    // MC3_RDEF1_R2_POS4 :
{0x765A,0x15,0x01},    // MC3_RDEF2_R2_POS4 :
{0x765B,0x71,0x01},    // MC3_RDEF3_R2_POS4 :
{0x765C,0x46,0x01},    // MC3_RDEF0_R2_POS5 :
{0x765D,0x32,0x01},    // MC3_RDEF1_R2_POS5 :
{0x765E,0x15,0x01},    // MC3_RDEF2_R2_POS5 :
{0x765F,0x71,0x01},    // MC3_RDEF3_R2_POS5 :
{0x7660,0xFFBA,0x02},    // MC3_X0DEF0_POS1 :
{0x7662,0xFFBA,0x02},    // MC3_Y0DEF0_POS1 :
{0x7664,0xFFFE,0x02},    // MC3_X0DEF1_POS1 :
{0x7666,0x000D,0x02},    // MC3_Y0DEF1_POS1 :
{0x7668,0x0002,0x02},    // MC3_X0DEF2_POS1 :
{0x766A,0xFFF6,0x02},    // MC3_Y0DEF2_POS1 :
{0x766C,0x003B,0x02},    // MC3_X0DEF3_POS1 :
{0x766E,0xFFBB,0x02},    // MC3_Y0DEF3_POS1 :
{0x7670,0xFFBA,0x02},    // MC3_X0DEF0_POS2 :
{0x7672,0xFFBA,0x02},    // MC3_Y0DEF0_POS2 :
{0x7674,0xFFFE,0x02},    // MC3_X0DEF1_POS2 :
{0x7676,0x000D,0x02},    // MC3_Y0DEF1_POS2 :
{0x7678,0x0002,0x02},    // MC3_X0DEF2_POS2 :
{0x767A,0xFFF6,0x02},    // MC3_Y0DEF2_POS2 :
{0x767C,0x003B,0x02},    // MC3_X0DEF3_POS2 :
{0x767E,0xFFBB,0x02},    // MC3_Y0DEF3_POS2 :
{0x7680,0xFFCE,0x02},    // MC3_X0DEF0_POS3 :
{0x7682,0xFFBA,0x02},    // MC3_Y0DEF0_POS3 :
{0x7684,0xFFFE,0x02},    // MC3_X0DEF1_POS3 :
{0x7686,0x000D,0x02},    // MC3_Y0DEF1_POS3 :
{0x7688,0x0002,0x02},    // MC3_X0DEF2_POS3 :
{0x768A,0xFFF6,0x02},    // MC3_Y0DEF2_POS3 :
{0x768C,0x003B,0x02},    // MC3_X0DEF3_POS3 :
{0x768E,0xFFBB,0x02},    // MC3_Y0DEF3_POS3 :
{0x7690,0xFFCE,0x02},    // MC3_X0DEF0_POS4 :
{0x7692,0xFFC9,0x02},    // MC3_Y0DEF0_POS4 :
{0x7694,0xFFD0,0x02},    // MC3_X0DEF1_POS4 :
{0x7696,0x0037,0x02},    // MC3_Y0DEF1_POS4 :
{0x7698,0x0002,0x02},    // MC3_X0DEF2_POS4 :
{0x769A,0xFFF6,0x02},    // MC3_Y0DEF2_POS4 :
{0x769C,0x003B,0x02},    // MC3_X0DEF3_POS4 :
{0x769E,0xFFBB,0x02},    // MC3_Y0DEF3_POS4 :
{0x76A0,0xFFCE,0x02},    // MC3_X0DEF0_POS5 :
{0x76A2,0xFFC9,0x02},    // MC3_Y0DEF0_POS5 :
{0x76A4,0xFFD0,0x02},    // MC3_X0DEF1_POS5 :
{0x76A6,0x0037,0x02},    // MC3_Y0DEF1_POS5 :
{0x76A8,0x0002,0x02},    // MC3_X0DEF2_POS5 :
{0x76AA,0xFFF6,0x02},    // MC3_Y0DEF2_POS5 :
{0x76AC,0x003B,0x02},    // MC3_X0DEF3_POS5 :
{0x76AE,0xFFBB,0x02},    // MC3_Y0DEF3_POS5 :
{0x76B0,0xFFCE,0x02},    // MC3_X0DEF0_POS6 :
{0x76B2,0xFFC9,0x02},    // MC3_Y0DEF0_POS6 :
{0x76B4,0xFFFE,0x02},    // MC3_X0DEF1_POS6 :
{0x76B6,0x000D,0x02},    // MC3_Y0DEF1_POS6 :
{0x76B8,0x0002,0x02},    // MC3_X0DEF2_POS6 :
{0x76BA,0xFFF6,0x02},    // MC3_Y0DEF2_POS6 :
{0x76BC,0x003B,0x02},    // MC3_X0DEF3_POS6 :
{0x76BE,0xFFBB,0x02},    // MC3_Y0DEF3_POS6 :
{0x76C0,0xFFCE,0x02},    // MC3_X0DEF0_POS7 :
{0x76C2,0xFFC9,0x02},    // MC3_Y0DEF0_POS7 :
{0x76C4,0xFFFE,0x02},    // MC3_X0DEF1_POS7 :
{0x76C6,0x000D,0x02},    // MC3_Y0DEF1_POS7 :
{0x76C8,0x0002,0x02},    // MC3_X0DEF2_POS7 :
{0x76CA,0xFFF6,0x02},    // MC3_Y0DEF2_POS7 :
{0x76CC,0x003B,0x02},    // MC3_X0DEF3_POS7 :
{0x76CE,0xFFBB,0x02},    // MC3_Y0DEF3_POS7 :
{0x76D0,0xFF7E,0x02},    // MC3_X0DEF0_OUT :
{0x76D2,0xFFE2,0x02},    // MC3_Y0DEF0_OUT :
{0x76D4,0xFFFE,0x02},    // MC3_X0DEF1_OUT :
{0x76D6,0x000D,0x02},    // MC3_Y0DEF1_OUT :
{0x76D8,0x0002,0x02},    // MC3_X0DEF2_OUT :
{0x76DA,0xFFF6,0x02},    // MC3_Y0DEF2_OUT :
{0x76DC,0xFFC4,0x02},    // MC3_X0DEF3_OUT :
{0x76DE,0xFFEC,0x02},    // MC3_Y0DEF3_OUT :
{0x76E0,0xFFCE,0x02},    // MC3_X0DEF0_R2_POS4 :
{0x76E2,0xFFC9,0x02},    // MC3_Y0DEF0_R2_POS4 :
{0x76E4,0xFFD0,0x02},    // MC3_X0DEF1_R2_POS4 :
{0x76E6,0x0037,0x02},    // MC3_Y0DEF1_R2_POS4 :
{0x76E8,0x0002,0x02},    // MC3_X0DEF2_R2_POS4 :
{0x76EA,0xFFF6,0x02},    // MC3_Y0DEF2_R2_POS4 :
{0x76EC,0x003B,0x02},    // MC3_X0DEF3_R2_POS4 :
{0x76EE,0xFFBB,0x02},    // MC3_Y0DEF3_R2_POS4 :
{0x76F0,0xFFCE,0x02},    // MC3_X0DEF0_R2_POS5 :
{0x76F2,0xFFC9,0x02},    // MC3_Y0DEF0_R2_POS5 :
{0x76F4,0xFFD0,0x02},    // MC3_X0DEF1_R2_POS5 :
{0x76F6,0x0037,0x02},    // MC3_Y0DEF1_R2_POS5 :
{0x76F8,0x0002,0x02},    // MC3_X0DEF2_R2_POS5 :
{0x76FA,0xFFF6,0x02},    // MC3_Y0DEF2_R2_POS5 :
{0x76FC,0x003B,0x02},    // MC3_X0DEF3_R2_POS5 :
{0x76FE,0xFFBB,0x02},    // MC3_Y0DEF3_R2_POS5 :
{0x7700,0x0019,0x02},    // MC3_PXDEF0_POS1 :
{0x7702,0xFF66,0x02},    // MC3_PYDEF0_POS1 :
{0x7704,0x0000,0x02},    // MC3_PXDEF1_POS1 :
{0x7706,0x0000,0x02},    // MC3_PYDEF1_POS1 :
{0x7708,0x0000,0x02},    // MC3_PXDEF2_POS1 :
{0x770A,0x0000,0x02},    // MC3_PYDEF2_POS1 :
{0x770C,0xFFD7,0x02},    // MC3_PXDEF3_POS1 :
{0x770E,0x0068,0x02},    // MC3_PYDEF3_POS1 :
{0x7710,0x0000,0x02},    // MC3_PXDEF0_POS2 :
{0x7712,0xFF66,0x02},    // MC3_PYDEF0_POS2 :
{0x7714,0x0033,0x02},    // MC3_PXDEF1_POS2 :
{0x7716,0xFF4C,0x02},    // MC3_PYDEF1_POS2 :
{0x7718,0x0000,0x02},    // MC3_PXDEF2_POS2 :
{0x771A,0x00B3,0x02},    // MC3_PYDEF2_POS2 :
{0x771C,0xFFD7,0x02},    // MC3_PXDEF3_POS2 :
{0x771E,0x0068,0x02},    // MC3_PYDEF3_POS2 :
{0x7720,0x0000,0x02},    // MC3_PXDEF0_POS3 :
{0x7722,0xFF80,0x02},    // MC3_PYDEF0_POS3 :
{0x7724,0x0000,0x02},    // MC3_PXDEF1_POS3 :
{0x7726,0x0000,0x02},    // MC3_PYDEF1_POS3 :
{0x7728,0x0000,0x02},    // MC3_PXDEF2_POS3 :
{0x772A,0x0000,0x02},    // MC3_PYDEF2_POS3 :
{0x772C,0xFFD7,0x02},    // MC3_PXDEF3_POS3 :
{0x772E,0x0068,0x02},    // MC3_PYDEF3_POS3 :
{0x7730,0x0000,0x02},    // MC3_PXDEF0_POS4 :
{0x7732,0xFFCC,0x02},    // MC3_PYDEF0_POS4 :
{0x7734,0x0000,0x02},    // MC3_PXDEF1_POS4 :
{0x7736,0x0000,0x02},    // MC3_PYDEF1_POS4 :
{0x7738,0x0000,0x02},    // MC3_PXDEF2_POS4 :
{0x773A,0x0000,0x02},    // MC3_PYDEF2_POS4 :
{0x773C,0xFFD7,0x02},    // MC3_PXDEF3_POS4 :
{0x773E,0x0068,0x02},    // MC3_PYDEF3_POS4 :
{0x7740,0x0000,0x02},    // MC3_PXDEF0_POS5 :
{0x7742,0xFFCC,0x02},    // MC3_PYDEF0_POS5 :
{0x7744,0x0000,0x02},    // MC3_PXDEF1_POS5 :
{0x7746,0x0000,0x02},    // MC3_PYDEF1_POS5 :
{0x7748,0x0000,0x02},    // MC3_PXDEF2_POS5 :
{0x774A,0x0000,0x02},    // MC3_PYDEF2_POS5 :
{0x774C,0xFFD7,0x02},    // MC3_PXDEF3_POS5 :
{0x774E,0x0068,0x02},    // MC3_PYDEF3_POS5 :
{0x7750,0xFFB3,0x02},    // MC3_PXDEF0_POS6 :
{0x7752,0x0000,0x02},    // MC3_PYDEF0_POS6 :
{0x7754,0x0033,0x02},    // MC3_PXDEF1_POS6 :
{0x7756,0xFF4C,0x02},    // MC3_PYDEF1_POS6 :
{0x7758,0x0000,0x02},    // MC3_PXDEF2_POS6 :
{0x775A,0x00B3,0x02},    // MC3_PYDEF2_POS6 :
{0x775C,0xFFD7,0x02},    // MC3_PXDEF3_POS6 :
{0x775E,0x0068,0x02},    // MC3_PYDEF3_POS6 :
{0x7760,0xFFB3,0x02},    // MC3_PXDEF0_POS7 :
{0x7762,0x0000,0x02},    // MC3_PYDEF0_POS7 :
{0x7764,0x0000,0x02},    // MC3_PXDEF1_POS7 :
{0x7766,0x0000,0x02},    // MC3_PYDEF1_POS7 :
{0x7768,0x0000,0x02},    // MC3_PXDEF2_POS7 :
{0x776A,0x0000,0x02},    // MC3_PYDEF2_POS7 :
{0x776C,0xFFD7,0x02},    // MC3_PXDEF3_POS7 :
{0x776E,0x0068,0x02},    // MC3_PYDEF3_POS7 :
{0x7770,0x0019,0x02},    // MC3_PXDEF0_OUT :
{0x7772,0xFFE6,0x02},    // MC3_PYDEF0_OUT :
{0x7774,0x0000,0x02},    // MC3_PXDEF1_OUT :
{0x7776,0x0000,0x02},    // MC3_PYDEF1_OUT :
{0x7778,0x0000,0x02},    // MC3_PXDEF2_OUT :
{0x777A,0x0000,0x02},    // MC3_PYDEF2_OUT :
{0x777C,0xFFE1,0x02},    // MC3_PXDEF3_OUT :
{0x777E,0xFFEB,0x02},    // MC3_PYDEF3_OUT :
{0x7780,0x0000,0x02},    // MC3_PXDEF0_R2_POS4 :
{0x7782,0xFFCC,0x02},    // MC3_PYDEF0_R2_POS4 :
{0x7784,0x0000,0x02},    // MC3_PXDEF1_R2_POS4 :
{0x7786,0x0000,0x02},    // MC3_PYDEF1_R2_POS4 :
{0x7788,0x0000,0x02},    // MC3_PXDEF2_R2_POS4 :
{0x778A,0x0000,0x02},    // MC3_PYDEF2_R2_POS4 :
{0x778C,0xFFD7,0x02},    // MC3_PXDEF3_R2_POS4 :
{0x778E,0x0068,0x02},    // MC3_PYDEF3_R2_POS4 :
{0x7790,0x0000,0x02},    // MC3_PXDEF0_R2_POS5 :
{0x7792,0xFFCC,0x02},    // MC3_PYDEF0_R2_POS5 :
{0x7794,0x0000,0x02},    // MC3_PXDEF1_R2_POS5 :
{0x7796,0x0000,0x02},    // MC3_PYDEF1_R2_POS5 :
{0x7798,0x0000,0x02},    // MC3_PXDEF2_R2_POS5 :
{0x779A,0x0000,0x02},    // MC3_PYDEF2_R2_POS5 :
{0x779C,0xFFD7,0x02},    // MC3_PXDEF3_R2_POS5 :
{0x779E,0x0068,0x02},    // MC3_PYDEF3_R2_POS5 :

};

static const isx012_regset_t SR300PC20_Camcorder_Mode_OFF[] = {
//SN setting
{0x0308,0x11,0x01},    // AELINE_MONI_SN1_2 :
{0x0320,0x22,0x01},    // AELINE_MONI_SN1_2 :
{0x00B2,0x02,0x01},    // AFMODE_MONI :
//BRIGHTNESS setting
{0x01C6,0x00,0x01},    // UIBRIGHTNESS
//AE speed
{0x02AC,0x01,0x01},    // AE_SUB_SN1 :
{0x5E2D,0x08,0x01},    // AEMOVECNT :
{0x5E2E,0x1A,0x01},    // AEINDEADBAND :
{0x5E2F,0x04,0x01},    // AEOUTDEADBAND :
{0x5E30,0x20,0x01},    // AESPEED :
{0x5E31,0x0F,0x01},    // AESPEED_INIT :
{0x5E32,0x0F,0x01},    // AESPEED_FAST :
{0x621E,0x20,0x01},    // AIM_NR_TH_UP :
{0x621F,0x20,0x01},    // AIM_NR_TH_DOWN :
{0x6220,0x20,0x01},    // AIM_NR_TH_RIGHT :
{0x6221,0x20,0x01},    // AIM_NR_TH_LEFT :
//AWB speed
{0x6222,0x00,0x01},    // INIT_AIMW :
{0x6223,0x04,0x01},    // INIT_GAINS :
{0x6224,0x04,0x01},    // ATW_DELAY :
{0x6225,0x00,0x01},    // ATW_AIMW :
{0x6226,0x08,0x01},    // ATW_GAINS_IN_NR :
{0x6227,0x04,0x01},    // ATW_GAINS_IN :
{0x6228,0x08,0x01},    // ATW_GAINS_OUT_NR :
{0x6229,0x04,0x01},    // ATW_GAINS_OUT :
{0x622A,0x02,0x01},    // ALLWB_GAINS :
//Gammma Table 0
{0x7000,0x0000,0x02},	 // G0_KNOT_G0 :
{0x7002,0x0015,0x02},	 // G0_KNOT_G1 :
{0x7004,0x002C,0x02},	 // G0_KNOT_G2 :
{0x7006,0x0041,0x02},	 // G0_KNOT_G3 :
{0x7008,0x004D,0x02},	 // G0_KNOT_G4 :
{0x700A,0x005B,0x02},	 // G0_KNOT_G5 :
{0x700C,0x0060,0x02},	 // G0_KNOT_G6 :
{0x700E,0x0068,0x02},	 // G0_KNOT_G7 :
{0x7010,0x006F,0x02},	 // G0_KNOT_G8 :
{0x7012,0x0078,0x02},	 // G0_KNOT_G9 :
{0x7014,0x0057,0x02},	 // G0_KNOT_G10 :
{0x7016,0x0090,0x02},	 // G0_KNOT_G11 :
{0x7018,0x00BB,0x02},	 // G0_KNOT_G12 :
{0x701A,0x00D6,0x02},	 // G0_KNOT_G13 :
{0x701C,0x00E5,0x02},	 // G0_KNOT_G14 :
{0x701E,0x00F0,0x02},	 // G0_KNOT_G15 :
{0x7020,0x00F9,0x02},	 // G0_KNOT_G16 :
{0x7022,0x0103,0x02},	 // G0_KNOT_G17 :
{0x7024,0x010C,0x02},	 // G0_KNOT_G18 :
{0x7026,0x00,0x01},    // G0_KNOT_R0_OFFSET :
{0x7027,0x00,0x01},    // G0_KNOT_R2_OFFSET :
{0x7028,0x00,0x01},    // G0_KNOT_R4_OFFSET :
{0x7029,0x00,0x01},    // G0_KNOT_R6_OFFSET :
{0x702A,0x00,0x01},    // G0_KNOT_R8_OFFSET :
{0x702B,0x00,0x01},    // G0_KNOT_R10_OFFSET :
{0x702C,0x00,0x01},    // G0_KNOT_R12_OFFSET :
{0x702D,0x00,0x01},    // G0_KNOT_R14_OFFSET :
{0x702E,0x00,0x01},    // G0_KNOT_R16_OFFSET :
{0x702F,0x00,0x01},    // G0_KNOT_R18_OFFSET :
{0x7030,0x00,0x01},    // G0_KNOT_B0_OFFSET :
{0x7031,0x00,0x01},    // G0_KNOT_B2_OFFSET :
{0x7032,0x00,0x01},    // G0_KNOT_B4_OFFSET :
{0x7033,0x00,0x01},    // G0_KNOT_B6_OFFSET :
{0x7034,0x00,0x01},    // G0_KNOT_B8_OFFSET :
{0x7035,0x00,0x01},    // G0_KNOT_B10_OFFSET :
{0x7036,0x00,0x01},    // G0_KNOT_B12_OFFSET :
{0x7037,0x00,0x01},    // G0_KNOT_B14_OFFSET :
{0x7038,0x00,0x01},    // G0_KNOT_B16_OFFSET :
{0x7039,0x00,0x01},    // G0_KNOT_B18_OFFSET :
{0x703A,0x0611,0x02},	 // G0_LOWGM_ON_R :
{0x703C,0x1E0A,0x02},	 // G0_0CLIP_R :
{0x703E,0x0611,0x02},	 // G0_LOWGM_ON_G :
{0x7040,0x1E0A,0x02},	 // G0_0CLIP_G :
{0x7042,0x0611,0x02},	 // G0_LOWGM_ON_B :
{0x7044,0x1E0A,0x02},	 // G0_0CLIP_B :
{0x7046,0x9C,0x01},    // G0_KNOT_GAINCTRL_TH_L :
{0x7047,0xA1,0x01},    // G0_KNOT_GAINCTRL_TH_H :
{0x7048,0x0000,0x02},	 // G0_KNOT_L_G0 :
{0x704A,0x0007,0x02},	 // G0_KNOT_L_G1 :
{0x704C,0x0016,0x02},	 // G0_KNOT_L_G2 :
{0x704E,0x002A,0x02},	 // G0_KNOT_L_G3 :
{0x7050,0x0039,0x02},	 // G0_KNOT_L_G4 :
{0x7052,0x004A,0x02},	 // G0_KNOT_L_G5 :
{0x7054,0x0051,0x02},	 // G0_KNOT_L_G6 :
{0x7056,0x005D,0x02},	 // G0_KNOT_L_G7 :
{0x7058,0x0065,0x02},	 // G0_KNOT_L_G8 :
{0x705A,0x006C,0x02},	 // G0_KNOT_L_G9 :
{0x705C,0x004E,0x02},	 // G0_KNOT_L_G10 :
{0x705E,0x0083,0x02},	 // G0_KNOT_L_G11 :
{0x7060,0x00AA,0x02},	 // G0_KNOT_L_G12 :
{0x7062,0x00C8,0x02},	 // G0_KNOT_L_G13 :
{0x7064,0x00E1,0x02},	 // G0_KNOT_L_G14 :
{0x7066,0x00F5,0x02},	 // G0_KNOT_L_G15 :
{0x7068,0x0100,0x02},	 // G0_KNOT_L_G16 :
{0x706A,0x0106,0x02},	 // G0_KNOT_L_G17 :
{0x706C,0x010C,0x02},	 // G0_KNOT_L_G18 :
{0x6400,0xAA,0x01},    // INFRM_LEFT00 :
{0x6401,0xAA,0x01},    // INFRM_LEFT01 :
{0x6402,0xAA,0x01},    // INFRM_LEFT02 :
{0x6403,0xAA,0x01},    // INFRM_LEFT03 :
{0x6404,0xAA,0x01},    // INFRM_LEFT04 :
{0x6405,0xAA,0x01},    // INFRM_LEFT05 :
{0x6406,0xAA,0x01},    // INFRM_LEFT06 :
{0x6407,0xAA,0x01},    // INFRM_LEFT07 :
{0x6408,0xAA,0x01},    // INFRM_LEFT08 :
{0x6409,0xAE,0x01},    // INFRM_LEFT09 :
{0x640A,0xA0,0x01},    // INFRM_LEFT10 :
{0x640B,0x8C,0x01},    // INFRM_LEFT11 :
{0x640C,0x72,0x01},    // INFRM_LEFT12 :
{0x640D,0x64,0x01},    // INFRM_LEFT13 :
{0x640E,0x5A,0x01},    // INFRM_LEFT14 :
{0x640F,0x52,0x01},    // INFRM_LEFT15 :
{0x6410,0x48,0x01},    // INFRM_LEFT16 :
{0x6411,0x43,0x01},    // INFRM_LEFT17 :
{0x6412,0x3D,0x01},    // INFRM_LEFT18 :
{0x6413,0x37,0x01},    // INFRM_LEFT19 :
{0x6414,0x33,0x01},    // INFRM_LEFT20 :
{0x6415,0x30,0x01},    // INFRM_LEFT21 :
{0x6416,0x2E,0x01},    // INFRM_LEFT22 :
{0x6417,0x2B,0x01},    // INFRM_LEFT23 :
{0x6418,0x28,0x01},    // INFRM_LEFT24 :
{0x6419,0x26,0x01},    // INFRM_LEFT25 :
{0x641A,0x24,0x01},    // INFRM_LEFT26 :
{0x641B,0x23,0x01},    // INFRM_LEFT27 :
{0x641C,0x22,0x01},    // INFRM_LEFT28 :
{0x641D,0x22,0x01},    // INFRM_LEFT29 :
{0x641E,0x21,0x01},    // INFRM_LEFT30 :
{0x641F,0x20,0x01},    // INFRM_LEFT31 :
{0x6420,0x1D,0x01},    // INFRM_LEFT32 :
{0x6421,0x1A,0x01},    // INFRM_LEFT33 :
{0x6422,0x18,0x01},    // INFRM_LEFT34 :
{0x6423,0x17,0x01},    // INFRM_LEFT35 :
{0x6424,0x16,0x01},    // INFRM_LEFT36 :
{0x6425,0x17,0x01},    // INFRM_LEFT37 :
{0x6426,0xAF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xAF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xAF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xAF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xAF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xAF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xAF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xAF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xAF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xAA,0x01},    // INFRM_RIGHT09 :
{0x6430,0xB2,0x01},    // INFRM_RIGHT10 :
{0x6431,0xB4,0x01},    // INFRM_RIGHT11 :
{0x6432,0xB6,0x01},    // INFRM_RIGHT12 :
{0x6433,0xB4,0x01},    // INFRM_RIGHT13 :
{0x6434,0x9B,0x01},    // INFRM_RIGHT14 :
{0x6435,0x8E,0x01},    // INFRM_RIGHT15 :
{0x6436,0x84,0x01},    // INFRM_RIGHT16 :
{0x6437,0x7A,0x01},    // INFRM_RIGHT17 :
{0x6438,0x72,0x01},    // INFRM_RIGHT18 :
{0x6439,0x6A,0x01},    // INFRM_RIGHT19 :
{0x643A,0x63,0x01},    // INFRM_RIGHT20 :
{0x643B,0x5E,0x01},    // INFRM_RIGHT21 :
{0x643C,0x58,0x01},    // INFRM_RIGHT22 :
{0x643D,0x53,0x01},    // INFRM_RIGHT23 :
{0x643E,0x4E,0x01},    // INFRM_RIGHT24 :
{0x643F,0x4A,0x01},    // INFRM_RIGHT25 :
{0x6440,0x46,0x01},    // INFRM_RIGHT26 :
{0x6441,0x42,0x01},    // INFRM_RIGHT27 :
{0x6442,0x3F,0x01},    // INFRM_RIGHT28 :
{0x6443,0x3C,0x01},    // INFRM_RIGHT29 :
{0x6444,0x3A,0x01},    // INFRM_RIGHT30 :
{0x6445,0x38,0x01},    // INFRM_RIGHT31 :
{0x6446,0x37,0x01},    // INFRM_RIGHT32 :
{0x6447,0x35,0x01},    // INFRM_RIGHT33 :
{0x6448,0x33,0x01},    // INFRM_RIGHT34 :
{0x6449,0x32,0x01},    // INFRM_RIGHT35 :
{0x644A,0x32,0x01},    // INFRM_RIGHT36 :
{0x644B,0x32,0x01},    // INFRM_RIGHT37 :
{0x644C,0x24FA,0x02},	 // INFRM_TOP :
{0x644E,0x0940,0x02},	 // INFRM_BOTM :
{0x6450,0x19,0x01},    // INFRM_FLTOP :
{0x6451,0x10,0x01},    // INFRM_FLBOTM :
{0x6452,0x91,0x01},    // INAIM_LEFT00 :
{0x6453,0x91,0x01},    // INAIM_LEFT01 :
{0x6454,0x91,0x01},    // INAIM_LEFT02 :
{0x6455,0x91,0x01},    // INAIM_LEFT03 :
{0x6456,0x91,0x01},    // INAIM_LEFT04 :
{0x6457,0x91,0x01},    // INAIM_LEFT05 :
{0x6458,0x91,0x01},    // INAIM_LEFT06 :
{0x6459,0x91,0x01},    // INAIM_LEFT07 :
{0x645A,0x91,0x01},    // INAIM_LEFT08 :
{0x645B,0x91,0x01},    // INAIM_LEFT09 :
{0x645C,0x91,0x01},    // INAIM_LEFT10 :
{0x645D,0x91,0x01},    // INAIM_LEFT11 :
{0x645E,0x91,0x01},    // INAIM_LEFT12 :
{0x645F,0x66,0x01},    // INAIM_LEFT13 :
{0x6460,0x71,0x01},    // INAIM_LEFT14 :
{0x6461,0x5A,0x01},    // INAIM_LEFT15 :
{0x6462,0x4E,0x01},    // INAIM_LEFT16 :
{0x6463,0x47,0x01},    // INAIM_LEFT17 :
{0x6464,0x42,0x01},    // INAIM_LEFT18 :
{0x6465,0x3C,0x01},    // INAIM_LEFT19 :
{0x6466,0x38,0x01},    // INAIM_LEFT20 :
{0x6467,0x36,0x01},    // INAIM_LEFT21 :
{0x6468,0x33,0x01},    // INAIM_LEFT22 :
{0x6469,0x30,0x01},    // INAIM_LEFT23 :
{0x646A,0x2F,0x01},    // INAIM_LEFT24 :
{0x646B,0x2B,0x01},    // INAIM_LEFT25 :
{0x646C,0x29,0x01},    // INAIM_LEFT26 :
{0x646D,0x27,0x01},    // INAIM_LEFT27 :
{0x646E,0x26,0x01},    // INAIM_LEFT28 :
{0x646F,0x28,0x01},    // INAIM_LEFT29 :
{0x6470,0x2A,0x01},    // INAIM_LEFT30 :
{0x6471,0x28,0x01},    // INAIM_LEFT31 :
{0x6472,0x26,0x01},    // INAIM_LEFT32 :
{0x6473,0x24,0x01},    // INAIM_LEFT33 :
{0x6474,0x29,0x01},    // INAIM_LEFT34 :
{0x6475,0x28,0x01},    // INAIM_LEFT35 :
{0x6476,0x29,0x01},    // INAIM_LEFT36 :
{0x6477,0x26,0x01},    // INAIM_LEFT37 :
{0x6478,0xFF,0x01},    // INAIM_RIGHT00 :
{0x6479,0xFF,0x01},    // INAIM_RIGHT01 :
{0x647A,0xFF,0x01},    // INAIM_RIGHT02 :
{0x647B,0xFF,0x01},    // INAIM_RIGHT03 :
{0x647C,0xFF,0x01},    // INAIM_RIGHT04 :
{0x647D,0xFF,0x01},    // INAIM_RIGHT05 :
{0x647E,0xFF,0x01},    // INAIM_RIGHT06 :
{0x647F,0xFF,0x01},    // INAIM_RIGHT07 :
{0x6480,0xFF,0x01},    // INAIM_RIGHT08 :
{0x6481,0xFF,0x01},    // INAIM_RIGHT09 :
{0x6482,0xD9,0x01},    // INAIM_RIGHT10 :
{0x6483,0xB7,0x01},    // INAIM_RIGHT11 :
{0x6484,0x96,0x01},    // INAIM_RIGHT12 :
{0x6485,0x68,0x01},    // INAIM_RIGHT13 :
{0x6486,0x72,0x01},    // INAIM_RIGHT14 :
{0x6487,0x71,0x01},    // INAIM_RIGHT15 :
{0x6488,0x6E,0x01},    // INAIM_RIGHT16 :
{0x6489,0x6A,0x01},    // INAIM_RIGHT17 :
{0x648A,0x65,0x01},    // INAIM_RIGHT18 :
{0x648B,0x60,0x01},    // INAIM_RIGHT19 :
{0x648C,0x5B,0x01},    // INAIM_RIGHT20 :
{0x648D,0x56,0x01},    // INAIM_RIGHT21 :
{0x648E,0x51,0x01},    // INAIM_RIGHT22 :
{0x648F,0x4C,0x01},    // INAIM_RIGHT23 :
{0x6490,0x47,0x01},    // INAIM_RIGHT24 :
{0x6491,0x44,0x01},    // INAIM_RIGHT25 :
{0x6492,0x41,0x01},    // INAIM_RIGHT26 :
{0x6493,0x3E,0x01},    // INAIM_RIGHT27 :
{0x6494,0x3B,0x01},    // INAIM_RIGHT28 :
{0x6495,0x39,0x01},    // INAIM_RIGHT29 :
{0x6496,0x37,0x01},    // INAIM_RIGHT30 :
{0x6497,0x34,0x01},    // INAIM_RIGHT31 :
{0x6498,0x33,0x01},    // INAIM_RIGHT32 :
{0x6499,0x32,0x01},    // INAIM_RIGHT33 :
{0x649A,0x31,0x01},    // INAIM_RIGHT34 :
{0x649B,0x30,0x01},    // INAIM_RIGHT35 :
{0x649C,0x2F,0x01},    // INAIM_RIGHT36 :
{0x649D,0x2E,0x01},    // INAIM_RIGHT37 :
{0x649E,0x1E00,0x02},	 // INAIM_TOP :
{0x64A0,0x0DFF,0x02},	 // INAIM_BOTM :
{0x64A2,0x18,0x01},    // INAIM_FLTOP :
{0x64A3,0x09,0x01},    // INAIM_FLBOTM :
{0x64A4,0xFF,0x01},    // OUTFRM_LEFT00 :
{0x64A5,0xFF,0x01},    // OUTFRM_LEFT01 :
{0x64A6,0xFF,0x01},    // OUTFRM_LEFT02 :
{0x64A7,0xFF,0x01},    // OUTFRM_LEFT03 :
{0x64A8,0xFF,0x01},    // OUTFRM_LEFT04 :
{0x64A9,0xFF,0x01},    // OUTFRM_LEFT05 :
{0x64AA,0xFF,0x01},    // OUTFRM_LEFT06 :
{0x64AB,0xFF,0x01},    // OUTFRM_LEFT07 :
{0x64AC,0xFF,0x01},    // OUTFRM_LEFT08 :
{0x64AD,0xFD,0x01},    // OUTFRM_LEFT09 :
{0x64AE,0xCB,0x01},    // OUTFRM_LEFT10 :
{0x64AF,0xA9,0x01},    // OUTFRM_LEFT11 :
{0x64B0,0x90,0x01},    // OUTFRM_LEFT12 :
{0x64B1,0x7D,0x01},    // OUTFRM_LEFT13 :
{0x64B2,0x70,0x01},    // OUTFRM_LEFT14 :
{0x64B3,0x65,0x01},    // OUTFRM_LEFT15 :
{0x64B4,0x5C,0x01},    // OUTFRM_LEFT16 :
{0x64B5,0x55,0x01},    // OUTFRM_LEFT17 :
{0x64B6,0x4F,0x01},    // OUTFRM_LEFT18 :
{0x64B7,0x32,0x01},    // OUTFRM_LEFT19 :
{0x64B8,0x4D,0x01},    // OUTFRM_LEFT20 :
{0x64B9,0x40,0x01},    // OUTFRM_LEFT21 :
{0x64BA,0x2D,0x01},    // OUTFRM_LEFT22 :
{0x64BB,0x2B,0x01},    // OUTFRM_LEFT23 :
{0x64BC,0x29,0x01},    // OUTFRM_LEFT24 :
{0x64BD,0x27,0x01},    // OUTFRM_LEFT25 :
{0x64BE,0x25,0x01},    // OUTFRM_LEFT26 :
{0x64BF,0x23,0x01},    // OUTFRM_LEFT27 :
{0x64C0,0x21,0x01},    // OUTFRM_LEFT28 :
{0x64C1,0x1F,0x01},    // OUTFRM_LEFT29 :
{0x64C2,0x1D,0x01},    // OUTFRM_LEFT30 :
{0x64C3,0x1B,0x01},    // OUTFRM_LEFT31 :
{0x64C4,0x1A,0x01},    // OUTFRM_LEFT32 :
{0x64C5,0x1A,0x01},    // OUTFRM_LEFT33 :
{0x64C6,0x1A,0x01},    // OUTFRM_LEFT34 :
{0x64C7,0x28,0x01},    // OUTFRM_LEFT35 :
{0x64C8,0x27,0x01},    // OUTFRM_LEFT36 :
{0x64C9,0x26,0x01},    // OUTFRM_LEFT37 :
{0x64CA,0xFF,0x01},   // OUTFRM_RIGHT00 :
{0x64CB,0xFF,0x01},   // OUTFRM_RIGHT01 :
{0x64CC,0xFF,0x01},   // OUTFRM_RIGHT02 :
{0x64CD,0xFF,0x01},   // OUTFRM_RIGHT03 :
{0x64CE,0xFF,0x01},   // OUTFRM_RIGHT04 :
{0x64CF,0xFF,0x01},   // OUTFRM_RIGHT05 :
{0x64D0,0xFF,0x01},   // OUTFRM_RIGHT06 :
{0x64D1,0xFF,0x01},   // OUTFRM_RIGHT07 :
{0x64D2,0xFF,0x01},   // OUTFRM_RIGHT08 :
{0x64D3,0xFF,0x01},   // OUTFRM_RIGHT09 :
{0x64D4,0xD3,0x01},    // OUTFRM_RIGHT10 :
{0x64D5,0xB1,0x01},    // OUTFRM_RIGHT11 :
{0x64D6,0x98,0x01},    // OUTFRM_RIGHT12 :
{0x64D7,0x85,0x01},    // OUTFRM_RIGHT13 :
{0x64D8,0x78,0x01},    // OUTFRM_RIGHT14 :
{0x64D9,0x6D,0x01},    // OUTFRM_RIGHT15 :
{0x64DA,0x64,0x01},    // OUTFRM_RIGHT16 :
{0x64DB,0x5D,0x01},    // OUTFRM_RIGHT17 :
{0x64DC,0x57,0x01},    // OUTFRM_RIGHT18 :
{0x64DD,0x63,0x01},    // OUTFRM_RIGHT19 :
{0x64DE,0x5E,0x01},    // OUTFRM_RIGHT20 :
{0x64DF,0x5A,0x01},    // OUTFRM_RIGHT21 :
{0x64E0,0x56,0x01},    // OUTFRM_RIGHT22 :
{0x64E1,0x52,0x01},    // OUTFRM_RIGHT23 :
{0x64E2,0x50,0x01},    // OUTFRM_RIGHT24 :
{0x64E3,0x4E,0x01},    // OUTFRM_RIGHT25 :
{0x64E4,0x4C,0x01},    // OUTFRM_RIGHT26 :
{0x64E5,0x4A,0x01},    // OUTFRM_RIGHT27 :
{0x64E6,0x48,0x01},    // OUTFRM_RIGHT28 :
{0x64E7,0x46,0x01},    // OUTFRM_RIGHT29 :
{0x64E8,0x44,0x01},    // OUTFRM_RIGHT30 :
{0x64E9,0x43,0x01},    // OUTFRM_RIGHT31 :
{0x64EA,0x42,0x01},    // OUTFRM_RIGHT32 :
{0x64EB,0x42,0x01},    // OUTFRM_RIGHT33 :
{0x64EC,0x42,0x01},    // OUTFRM_RIGHT34 :
{0x64ED,0x30,0x01},    // OUTFRM_RIGHT35 :
{0x64EE,0x2F,0x01},    // OUTFRM_RIGHT36 :
{0x64EF,0x2E,0x01},    // OUTFRM_RIGHT37 :
{0x64F0,0x2163,0x02},    // OUTFRM_TOP :
{0x64F2,0x1400,0x02},	// OUTFRM_BOTM :
{0x64F4,0x19,0x01},    // OUTFRM_FLTOP :
{0x64F5,0x14,0x01},    // OUTFRM_FLBOTM :
//AWB
{0x6232,0xFF,0x01},    // ATW_SFTLMT_OUT_NR
{0x6234,0xFF,0x01},    // ATW_SFTLMT_OUT
/////MC3 Setting/////
{0x7600,0x07,0x01},    // MC3_PXDEF0_SEL :
{0x7601,0x07,0x01},    // MC3_PYDEF0_SEL :
{0x7602,0x07,0x01},    // MC3_PXDEF1_SEL :
{0x7603,0x07,0x01},    // MC3_PYDEF1_SEL :
{0x7604,0x07,0x01},    // MC3_PXDEF2_SEL :
{0x7605,0x07,0x01},    // MC3_PYDEF2_SEL :
{0x7606,0x07,0x01},    // MC3_PXDEF3_SEL :
{0x7607,0x07,0x01},    // MC3_PYDEF3_SEL :
{0x7608,0x40,0x01},    // MC3_PXDEF0_A :
{0x7609,0x40,0x01},    // MC3_PXDEF0_B :
{0x760A,0x40,0x01},    // MC3_PXDEF0_C :
{0x760B,0x40,0x01},    // MC3_PYDEF0_A :
{0x760C,0x40,0x01},    // MC3_PYDEF0_B :
{0x760D,0x40,0x01},    // MC3_PYDEF0_C :
{0x760E,0x40,0x01},    // MC3_PXDEF1_A :
{0x760F,0x40,0x01},    // MC3_PXDEF1_B :
{0x7610,0x40,0x01},    // MC3_PXDEF1_C :
{0x7611,0x40,0x01},    // MC3_PYDEF1_A :
{0x7612,0x40,0x01},    // MC3_PYDEF1_B :
{0x7613,0x40,0x01},    // MC3_PYDEF1_C :
{0x7614,0x40,0x01},    // MC3_PXDEF2_A :
{0x7615,0x40,0x01},    // MC3_PXDEF2_B :
{0x7616,0x40,0x01},    // MC3_PXDEF2_C :
{0x7617,0x40,0x01},    // MC3_PYDEF2_A :
{0x7618,0x40,0x01},    // MC3_PYDEF2_B :
{0x7619,0x40,0x01},    // MC3_PYDEF2_C :
{0x761A,0x40,0x01},    // MC3_PXDEF3_A :
{0x761B,0x40,0x01},    // MC3_PXDEF3_B :
{0x761C,0x40,0x01},    // MC3_PXDEF3_C :
{0x761D,0x40,0x01},    // MC3_PYDEF3_A :
{0x761E,0x40,0x01},    // MC3_PYDEF3_B :
{0x761F,0x40,0x01},    // MC3_PYDEF3_C :
{0x7620,0x00,0x01},    // MC3_LUMSL0_IN :
{0x7621,0x06,0x01},    // MC3_LUMSL1_IN :
{0x7622,0x03,0x01},    // MC3_LUMSL2_IN :
{0x7623,0x06,0x01},    // MC3_LUMSL3_IN :
{0x7624,0x00,0x01},    // MC3_LUMSL0_OUT :
{0x7625,0x03,0x01},    // MC3_LUMSL1_OUT :
{0x7626,0x00,0x01},    // MC3_LUMSL2_OUT :
{0x7627,0x00,0x01},    // MC3_LUMSL3_OUT :
{0x7628,0x0000,0x02},	 // MC3_L0DEF0_IN :
{0x762A,0x008C,0x02},	 // MC3_L0DEF1_IN :
{0x762C,0x0078,0x02},	 // MC3_L0DEF2_IN :
{0x762E,0x00E6,0x02},	 // MC3_L0DEF3_IN :
{0x7630,0x0000,0x02},	 // MC3_L0DEF0_OUT :
{0x7632,0x0082,0x02},	 // MC3_L0DEF1_OUT :
{0x7634,0x0000,0x02},	 // MC3_L0DEF2_OUT :
{0x7636,0x0000,0x02},	 // MC3_L0DEF3_OUT :
{0x7638,0x41,0x01},    // MC3_RDEF0_POS1 :
{0x7639,0x10,0x01},    // MC3_RDEF1_POS1 :
{0x763A,0x15,0x01},    // MC3_RDEF2_POS1 :
{0x763B,0x71,0x01},    // MC3_RDEF3_POS1 :
{0x763C,0x41,0x01},    // MC3_RDEF0_POS2 :
{0x763D,0x10,0x01},    // MC3_RDEF1_POS2 :
{0x763E,0x15,0x01},    // MC3_RDEF2_POS2 :
{0x763F,0x71,0x01},    // MC3_RDEF3_POS2 :
{0x7640,0x3C,0x01},    // MC3_RDEF0_POS3 :
{0x7641,0x10,0x01},    // MC3_RDEF1_POS3 :
{0x7642,0x15,0x01},    // MC3_RDEF2_POS3 :
{0x7643,0x71,0x01},    // MC3_RDEF3_POS3 :
{0x7644,0x46,0x01},    // MC3_RDEF0_POS4 :
{0x7645,0x32,0x01},    // MC3_RDEF1_POS4 :
{0x7646,0x15,0x01},    // MC3_RDEF2_POS4 :
{0x7647,0x71,0x01},    // MC3_RDEF3_POS4 :
{0x7648,0x46,0x01},    // MC3_RDEF0_POS5 :
{0x7649,0x32,0x01},    // MC3_RDEF1_POS5 :
{0x764A,0x15,0x01},    // MC3_RDEF2_POS5 :
{0x764B,0x71,0x01},    // MC3_RDEF3_POS5 :
{0x764C,0x46,0x01},    // MC3_RDEF0_POS6 :
{0x764D,0x10,0x01},    // MC3_RDEF1_POS6 :
{0x764E,0x15,0x01},    // MC3_RDEF2_POS6 :
{0x764F,0x71,0x01},    // MC3_RDEF3_POS6 :
{0x7650,0x46,0x01},    // MC3_RDEF0_POS7 :
{0x7651,0x10,0x01},    // MC3_RDEF1_POS7 :
{0x7652,0x15,0x01},    // MC3_RDEF2_POS7 :
{0x7653,0x71,0x01},    // MC3_RDEF3_POS7 :
{0x7654,0x2D,0x01},    // MC3_RDEF0_OUT :
{0x7655,0x10,0x01},    // MC3_RDEF1_OUT :
{0x7656,0x15,0x01},    // MC3_RDEF2_OUT :
{0x7657,0x54,0x01},    // MC3_RDEF3_OUT :
{0x7658,0x46,0x01},    // MC3_RDEF0_R2_POS4 :
{0x7659,0x32,0x01},    // MC3_RDEF1_R2_POS4 :
{0x765A,0x15,0x01},    // MC3_RDEF2_R2_POS4 :
{0x765B,0x71,0x01},    // MC3_RDEF3_R2_POS4 :
{0x765C,0x46,0x01},    // MC3_RDEF0_R2_POS5 :
{0x765D,0x32,0x01},    // MC3_RDEF1_R2_POS5 :
{0x765E,0x15,0x01},    // MC3_RDEF2_R2_POS5 :
{0x765F,0x71,0x01},    // MC3_RDEF3_R2_POS5 :
{0x7660,0xFFBA,0x02},	 // MC3_X0DEF0_POS1 :
{0x7662,0xFFBA,0x02},	 // MC3_Y0DEF0_POS1 :
{0x7664,0xFFFE,0x02},	 // MC3_X0DEF1_POS1 :
{0x7666,0x000D,0x02},	 // MC3_Y0DEF1_POS1 :
{0x7668,0x0002,0x02},	 // MC3_X0DEF2_POS1 :
{0x766A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS1 :
{0x766C,0x003B,0x02},	 // MC3_X0DEF3_POS1 :
{0x766E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS1 :
{0x7670,0xFFBA,0x02},	 // MC3_X0DEF0_POS2 :
{0x7672,0xFFBA,0x02},	 // MC3_Y0DEF0_POS2 :
{0x7674,0xFFFE,0x02},	 // MC3_X0DEF1_POS2 :
{0x7676,0x000D,0x02},	 // MC3_Y0DEF1_POS2 :
{0x7678,0x0002,0x02},	 // MC3_X0DEF2_POS2 :
{0x767A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS2 :
{0x767C,0x003B,0x02},	 // MC3_X0DEF3_POS2 :
{0x767E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS2 :
{0x7680,0xFFCE,0x02},	 // MC3_X0DEF0_POS3 :
{0x7682,0xFFBA,0x02},	 // MC3_Y0DEF0_POS3 :
{0x7684,0xFFFE,0x02},	 // MC3_X0DEF1_POS3 :
{0x7686,0x000D,0x02},	 // MC3_Y0DEF1_POS3 :
{0x7688,0x0002,0x02},	 // MC3_X0DEF2_POS3 :
{0x768A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS3 :
{0x768C,0x003B,0x02},	 // MC3_X0DEF3_POS3 :
{0x768E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS3 :
{0x7690,0xFFCE,0x02},	 // MC3_X0DEF0_POS4 :
{0x7692,0xFFC9,0x02},	 // MC3_Y0DEF0_POS4 :
{0x7694,0xFFD0,0x02},	 // MC3_X0DEF1_POS4 :
{0x7696,0x0037,0x02},	 // MC3_Y0DEF1_POS4 :
{0x7698,0x0002,0x02},	 // MC3_X0DEF2_POS4 :
{0x769A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS4 :
{0x769C,0x003B,0x02},	 // MC3_X0DEF3_POS4 :
{0x769E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS4 :
{0x76A0,0xFFCE,0x02},	 // MC3_X0DEF0_POS5 :
{0x76A2,0xFFC9,0x02},	 // MC3_Y0DEF0_POS5 :
{0x76A4,0xFFD0,0x02},	 // MC3_X0DEF1_POS5 :
{0x76A6,0x0037,0x02},	 // MC3_Y0DEF1_POS5 :
{0x76A8,0x0002,0x02},	 // MC3_X0DEF2_POS5 :
{0x76AA,0xFFF6,0x02},	 // MC3_Y0DEF2_POS5 :
{0x76AC,0x003B,0x02},	 // MC3_X0DEF3_POS5 :
{0x76AE,0xFFBB,0x02},	 // MC3_Y0DEF3_POS5 :
{0x76B0,0xFFCE,0x02},	 // MC3_X0DEF0_POS6 :
{0x76B2,0xFFC9,0x02},	 // MC3_Y0DEF0_POS6 :
{0x76B4,0xFFFE,0x02},	 // MC3_X0DEF1_POS6 :
{0x76B6,0x000D,0x02},	 // MC3_Y0DEF1_POS6 :
{0x76B8,0x0002,0x02},	 // MC3_X0DEF2_POS6 :
{0x76BA,0xFFF6,0x02},	 // MC3_Y0DEF2_POS6 :
{0x76BC,0x003B,0x02},	 // MC3_X0DEF3_POS6 :
{0x76BE,0xFFBB,0x02},	 // MC3_Y0DEF3_POS6 :
{0x76C0,0xFFCE,0x02},	 // MC3_X0DEF0_POS7 :
{0x76C2,0xFFC9,0x02},	 // MC3_Y0DEF0_POS7 :
{0x76C4,0xFFFE,0x02},	 // MC3_X0DEF1_POS7 :
{0x76C6,0x000D,0x02},	 // MC3_Y0DEF1_POS7 :
{0x76C8,0x0002,0x02},	 // MC3_X0DEF2_POS7 :
{0x76CA,0xFFF6,0x02},	 // MC3_Y0DEF2_POS7 :
{0x76CC,0x003B,0x02},	 // MC3_X0DEF3_POS7 :
{0x76CE,0xFFBB,0x02},	 // MC3_Y0DEF3_POS7 :
{0x76D0,0xFF7E,0x02},	 // MC3_X0DEF0_OUT :
{0x76D2,0xFFE2,0x02},	 // MC3_Y0DEF0_OUT :
{0x76D4,0xFFFE,0x02},	 // MC3_X0DEF1_OUT :
{0x76D6,0x000D,0x02},	 // MC3_Y0DEF1_OUT :
{0x76D8,0x0002,0x02},	 // MC3_X0DEF2_OUT :
{0x76DA,0xFFF6,0x02},	 // MC3_Y0DEF2_OUT :
{0x76DC,0xFFC4,0x02},	 // MC3_X0DEF3_OUT :
{0x76DE,0xFFEC,0x02},	 // MC3_Y0DEF3_OUT :
{0x76E0,0xFFCE,0x02},	 // MC3_X0DEF0_R2_POS4 :
{0x76E2,0xFFC9,0x02},	 // MC3_Y0DEF0_R2_POS4 :
{0x76E4,0xFFD0,0x02},	 // MC3_X0DEF1_R2_POS4 :
{0x76E6,0x0037,0x02},	 // MC3_Y0DEF1_R2_POS4 :
{0x76E8,0x0002,0x02},	 // MC3_X0DEF2_R2_POS4 :
{0x76EA,0xFFF6,0x02},	 // MC3_Y0DEF2_R2_POS4 :
{0x76EC,0x003B,0x02},	 // MC3_X0DEF3_R2_POS4 :
{0x76EE,0xFFBB,0x02},	 // MC3_Y0DEF3_R2_POS4 :
{0x76F0,0xFFCE,0x02},	 // MC3_X0DEF0_R2_POS5 :
{0x76F2,0xFFC9,0x02},	 // MC3_Y0DEF0_R2_POS5 :
{0x76F4,0xFFD0,0x02},	 // MC3_X0DEF1_R2_POS5 :
{0x76F6,0x0037,0x02},	 // MC3_Y0DEF1_R2_POS5 :
{0x76F8,0x0002,0x02},	 // MC3_X0DEF2_R2_POS5 :
{0x76FA,0xFFF6,0x02},	 // MC3_Y0DEF2_R2_POS5 :
{0x76FC,0x003B,0x02},	 // MC3_X0DEF3_R2_POS5 :
{0x76FE,0xFFBB,0x02},	 // MC3_Y0DEF3_R2_POS5 :
{0x7700,0x0019,0x02},	 // MC3_PXDEF0_POS1 :
{0x7702,0xFF66,0x02},	 // MC3_PYDEF0_POS1 :
{0x7704,0x0000,0x02},	 // MC3_PXDEF1_POS1 :
{0x7706,0x0000,0x02},	 // MC3_PYDEF1_POS1 :
{0x7708,0x0000,0x02},	 // MC3_PXDEF2_POS1 :
{0x770A,0x0000,0x02},	 // MC3_PYDEF2_POS1 :
{0x770C,0xFFD7,0x02},	 // MC3_PXDEF3_POS1 :
{0x770E,0x0068,0x02},	 // MC3_PYDEF3_POS1 :
{0x7710,0x0000,0x02},	 // MC3_PXDEF0_POS2 :
{0x7712,0xFF66,0x02},	 // MC3_PYDEF0_POS2 :
{0x7714,0x0033,0x02},	 // MC3_PXDEF1_POS2 :
{0x7716,0xFF4C,0x02},	 // MC3_PYDEF1_POS2 :
{0x7718,0x0000,0x02},	 // MC3_PXDEF2_POS2 :
{0x771A,0x00B3,0x02},	 // MC3_PYDEF2_POS2 :
{0x771C,0xFFD7,0x02},	 // MC3_PXDEF3_POS2 :
{0x771E,0x0068,0x02},	 // MC3_PYDEF3_POS2 :
{0x7720,0x0000,0x02},	 // MC3_PXDEF0_POS3 :
{0x7722,0xFF80,0x02},	 // MC3_PYDEF0_POS3 :
{0x7724,0x0000,0x02},	 // MC3_PXDEF1_POS3 :
{0x7726,0x0000,0x02},	 // MC3_PYDEF1_POS3 :
{0x7728,0x0000,0x02},	 // MC3_PXDEF2_POS3 :
{0x772A,0x0000,0x02},	 // MC3_PYDEF2_POS3 :
{0x772C,0xFFD7,0x02},	 // MC3_PXDEF3_POS3 :
{0x772E,0x0068,0x02},	 // MC3_PYDEF3_POS3 :
{0x7730,0x0000,0x02},	 // MC3_PXDEF0_POS4 :
{0x7732,0xFFCC,0x02},	 // MC3_PYDEF0_POS4 :
{0x7734,0x0000,0x02},	 // MC3_PXDEF1_POS4 :
{0x7736,0x0000,0x02},	 // MC3_PYDEF1_POS4 :
{0x7738,0x0000,0x02},	 // MC3_PXDEF2_POS4 :
{0x773A,0x0000,0x02},	 // MC3_PYDEF2_POS4 :
{0x773C,0xFFD7,0x02},	 // MC3_PXDEF3_POS4 :
{0x773E,0x0068,0x02},	 // MC3_PYDEF3_POS4 :
{0x7740,0x0000,0x02},	 // MC3_PXDEF0_POS5 :
{0x7742,0xFFCC,0x02},	 // MC3_PYDEF0_POS5 :
{0x7744,0x0000,0x02},	 // MC3_PXDEF1_POS5 :
{0x7746,0x0000,0x02},	 // MC3_PYDEF1_POS5 :
{0x7748,0x0000,0x02},	 // MC3_PXDEF2_POS5 :
{0x774A,0x0000,0x02},	 // MC3_PYDEF2_POS5 :
{0x774C,0xFFD7,0x02},	 // MC3_PXDEF3_POS5 :
{0x774E,0x0068,0x02},	 // MC3_PYDEF3_POS5 :
{0x7750,0xFFB3,0x02},	 // MC3_PXDEF0_POS6 :
{0x7752,0x0000,0x02},	 // MC3_PYDEF0_POS6 :
{0x7754,0x0033,0x02},	 // MC3_PXDEF1_POS6 :
{0x7756,0xFF4C,0x02},	 // MC3_PYDEF1_POS6 :
{0x7758,0x0000,0x02},	 // MC3_PXDEF2_POS6 :
{0x775A,0x00B3,0x02},	 // MC3_PYDEF2_POS6 :
{0x775C,0xFFD7,0x02},	 // MC3_PXDEF3_POS6 :
{0x775E,0x0068,0x02},	 // MC3_PYDEF3_POS6 :
{0x7760,0xFFB3,0x02},	 // MC3_PXDEF0_POS7 :
{0x7762,0x0000,0x02},	 // MC3_PYDEF0_POS7 :
{0x7764,0x0000,0x02},	 // MC3_PXDEF1_POS7 :
{0x7766,0x0000,0x02},	 // MC3_PYDEF1_POS7 :
{0x7768,0x0000,0x02},	 // MC3_PXDEF2_POS7 :
{0x776A,0x0000,0x02},	 // MC3_PYDEF2_POS7 :
{0x776C,0xFFD7,0x02},	 // MC3_PXDEF3_POS7 :
{0x776E,0x0068,0x02},	 // MC3_PYDEF3_POS7 :
{0x7770,0x0019,0x02},	 // MC3_PXDEF0_OUT :
{0x7772,0xFFE6,0x02},	 // MC3_PYDEF0_OUT :
{0x7774,0x0000,0x02},	 // MC3_PXDEF1_OUT :
{0x7776,0x0000,0x02},	 // MC3_PYDEF1_OUT :
{0x7778,0x0000,0x02},	 // MC3_PXDEF2_OUT :
{0x777A,0x0000,0x02},	 // MC3_PYDEF2_OUT :
{0x777C,0xFFE1,0x02},	 // MC3_PXDEF3_OUT :
{0x777E,0xFFEB,0x02},	 // MC3_PYDEF3_OUT :
{0x7780,0x0000,0x02},	 // MC3_PXDEF0_R2_POS4 :
{0x7782,0xFFCC,0x02},	 // MC3_PYDEF0_R2_POS4 :
{0x7784,0x0000,0x02},	 // MC3_PXDEF1_R2_POS4 :
{0x7786,0x0000,0x02},	 // MC3_PYDEF1_R2_POS4 :
{0x7788,0x0000,0x02},	 // MC3_PXDEF2_R2_POS4 :
{0x778A,0x0000,0x02},	 // MC3_PYDEF2_R2_POS4 :
{0x778C,0xFFD7,0x02},	 // MC3_PXDEF3_R2_POS4 :
{0x778E,0x0068,0x02},	 // MC3_PYDEF3_R2_POS4 :
{0x7790,0x0000,0x02},	 // MC3_PXDEF0_R2_POS5 :
{0x7792,0xFFCC,0x02},	 // MC3_PYDEF0_R2_POS5 :
{0x7794,0x0000,0x02},	 // MC3_PXDEF1_R2_POS5 :
{0x7796,0x0000,0x02},	 // MC3_PYDEF1_R2_POS5 :
{0x7798,0x0000,0x02},	 // MC3_PXDEF2_R2_POS5 :
{0x779A,0x0000,0x02},	 // MC3_PYDEF2_R2_POS5 :
{0x779C,0xFFD7,0x02},	 // MC3_PXDEF3_R2_POS5 :
{0x779E,0x0068,0x02},	 // MC3_PYDEF3_R2_POS5 :
};

static const isx012_regset_t SR300PC20_Halfrelease_Mode[] =
{
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x00,0x01},    //AFMODE_HREL :
{0xFFFF,0x42,0x01},//$wait, 66
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t SR300PC20_Barcode_SAF[] =
{
{0x00B1,0x01,0x01},    //AF_RESTART_F :
{0xFFFF,0x21,0x01},    //$wait, 33
{0x00B2,0x00,0x01},    //AFMODE_MONI :
};

static const isx012_regset_t SR300PC20_Lowlux_night_Halfrelease_Mode[] =
{
{0x660E,0x04,0x01},    // AF_HBPF_PEAK_OPD_TH_MIN
{0x6610,0x04,0x01},    // AF_HBPF_PEAK_OPD_TH_MAX
{0x664A,0x01,0x01},    // AF_DROPN_ON_PEAK_DETECT :
{0x6640,0x01,0x01},    // AF_DROPN_ON_PEAK_DETECT_SECOND :
{0x0289,0x21,0x01},    //AWB_SN8
{0x00B1,0x01,0x01},    //AF_RESTART_F
{0x00B3,0x00,0x01},    //AFMODE_HREL :
{0xFFFF,0x42,0x01},//$wait, 66
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t SR300PC20_AF_Cancel_Macro_ON[] =
{
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x02BC,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x00B1,0x01,0x01},    //AF_RESTART_F
};

static const isx012_regset_t SR300PC20_AF_Cancel_Macro_OFF[] =
{
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x00C8,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x00B1,0x01,0x01},    //AF_RESTART_F
};

static const isx012_regset_t SR300PC20_AF_ReStart[] =
{
{0x00B1,0x01,0x01},    //AF_RESTART_F
};

static const isx012_regset_t SR300PC20_AF_Macro_OFF[] =
{
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x00C8,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x66DC,0x02BC,0x02},    //AF_JUDGE_MONO_POS_S
{0x665A,0x00C8,0x02},    // AF_LENSPOS_ON_AFNG :
{0x028E,0x00,0x01},    //AF_SEARCH_DIR : NEAR->FAR
{0x00B3,0x00,0x01},    //AFMODE_HREL : Manual AF mode
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0xFFFF,0x21,0x01},//$wait, 33
};

static const isx012_regset_t SR300PC20_AF_Macro_ON[] =
{
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x02BC,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x66DC,0x00C8,0x02},    //AF_JUDGE_MONO_POS_S
{0x665A,0x02BC,0x02},    // AF_LENSPOS_ON_AFNG :
{0x028E,0x01,0x01},    //AF_SEARCH_DIR : NEAR->FAR
{0x00B3,0x00,0x01},    //AFMODE_HREL : Manual AF mode
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0xFFFF,0x21,0x01},//$wait, 33
};

static const isx012_regset_t SR300PC20_AF_SAF[] =
{
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x00,0x01},    //AFMODE_HREL :
{0xFFFF,0x21,0x01},//$wait, 33
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t SR300PC20_AF_SAF_OFF[] =
{
{0xFFFF,0x42,0x01},//$wait, 66
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x03,0x01},    //AFMODE_HREL : AF OFF
};

static const isx012_regset_t SR300PC20_AF_TouchSAF_OFF[] =
{
{0xFFFF,0x42,0x01},//$wait, 66
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x03,0x01},    //AFMODE_HREL : AF OFF
{0x0081,0x00,0x01},    //MODESEL
};

static const isx012_regset_t SR300PC20_Camcorder_SAF_Start[] =
{
{0x00B1,0x01,0x01}, /* AF_RESTART_F */
{0xFFFF,0x21,0x01}, /* $wait, 33 */
{0x00B2,0x00,0x01}, /* AFMODE_MONI */
};

static const isx012_regset_t SR300PC20_Camcorder_CAF_Start[] =
{
{0x00B2,0x01,0x01}, /* AFMODE_MONI */
};

static const isx012_regset_t SR300PC20_AF_Window_Reset[] =
{
//AF opd window setting
{0x6A30,0x044E,0x02},    // AF_OPD0_HDELAY :
{0x6A32,0x02E5,0x02},    // AF_OPD0_VDELAY :
{0x6A34,0x01D8,0x02},    // AF_OPD0_HVALID :
{0x6A36,0x01D8,0x02},    // AF_OPD0_VVALID :
{0x6A38,0x0412,0x02},    // AF_OPD1_HDELAY :
{0x6A3A,0x02A9,0x02},    // AF_OPD1_VDELAY :
{0x6A3C,0x0251,0x02},    // AF_OPD1_HVALID :
{0x6A3E,0x0251,0x02},    // AF_OPD1_VVALID :
{0x6A40,0x04B4,0x02},    // AF_OPD2_HDELAY :
{0x6A42,0x0114,0x02},    // AF_OPD2_VDELAY :
{0x6A44,0x0118,0x02},    // AF_OPD2_HVALID :
{0x6A46,0x0118,0x02},    // AF_OPD2_VVALID :
{0x6A48,0x0469,0x02},    // AF_OPD3_HDELAY :
{0x6A4A,0x00C9,0x02},    // AF_OPD3_VDELAY :
{0x6A4C,0x01AE,0x02},    // AF_OPD3_HVALID :
{0x6A4E,0x01AE,0x02},    // AF_OPD3_VVALID :
{0x6A50,0x04C6,0x02},    // AF_OPD4_HDELAY :
{0x6A52,0x035D,0x02},    // AF_OPD4_VDELAY :
{0x6A54,0x00E6,0x02},    // AF_OPD4_HVALID :
{0x6A56,0x00E6,0x02},    // AF_OPD4_VVALID :
{0x6A58,0x048A,0x02},    // AF_OPD5_HDELAY :
{0x6A5A,0x0321,0x02},    // AF_OPD5_VDELAY :
{0x6A5C,0x015F,0x02},    // AF_OPD5_HVALID :
{0x6A5E,0x015F,0x02},    // AF_OPD5_VVALID :
{0x6A60,0x04B4,0x02},    // AF_OPD6_HDELAY :
{0x6A62,0x0579,0x02},    // AF_OPD6_VDELAY :
{0x6A64,0x0118,0x02},    // AF_OPD6_HVALID :
{0x6A66,0x0118,0x02},    // AF_OPD6_VVALID :
{0x6A68,0x0469,0x02},    // AF_OPD7_HDELAY :
{0x6A6A,0x052C,0x02},    // AF_OPD7_VDELAY :
{0x6A6C,0x01AE,0x02},    // AF_OPD7_HVALID :
{0x6A6E,0x01AE,0x02},    // AF_OPD7_VVALID :
{0x6A70,0x021D,0x02},    // AF_OPD8_HDELAY :
{0x6A72,0x02F5,0x02},    // AF_OPD8_VDELAY :
{0x6A74,0x01AE,0x02},    // AF_OPD8_HVALID :
{0x6A76,0x01AE,0x02},    // AF_OPD8_VVALID :
{0x6A78,0x06A4,0x02},    // AF_OPD9_HDELAY :
{0x6A7A,0x02F5,0x02},    // AF_OPD9_VDELAY :
{0x6A7C,0x01AE,0x02},    // AF_OPD9_HVALID :
{0x6A7E,0x01AE,0x02},    // AF_OPD9_VVALID :
{0x6A80,0x06,0x01},    // AF_OPD1A_WEIGHT :
{0x6A81,0x05,0x01},    // AF_OPD1B_WEIGHT :
{0x6A82,0x02,0x01},    // AF_OPD2A_WEIGHT :
{0x6A83,0x02,0x01},    // AF_OPD2B_WEIGHT :
{0x6A84,0x08,0x01},    // AF_OPD3A_WEIGHT :
{0x6A85,0x07,0x01},    // AF_OPD3B_WEIGHT :
{0x6A86,0x04,0x01},    // AF_OPD4A_WEIGHT :
{0x6A87,0x03,0x01},    // AF_OPD4B_WEIGHT :
{0x6A88,0x01,0x01},    // AF_OPD5A_WEIGHT :
{0x6A89,0x01,0x01},    // AF_OPD5B_WEIGHT :
{0x6646,0x08,0x01},    // AF_OPD_WEIGHT_TH :
};

/* Added by Samsung TN */
static const isx012_regset_t SR300PC20_AF_Window_Set[] =
{
{0x6A80,0x00,0x01},
{0x6A81,0x00,0x01},
{0x6A82,0x00,0x01},
{0x6A83,0x00,0x01},
{0x6A84,0x08,0x01},
{0x6A85,0x00,0x01},
{0x6A86,0x00,0x01},
{0x6A87,0x00,0x01},
{0x6A88,0x00,0x01},
{0x6A89,0x00,0x01},
{0x6646,0x08,0x01},
};

static const isx012_regset_t sr300pc20_Contrast_Minus_2[] =
{
{0x01C7,0x58,0x01},    //UICONTRAST
};

static const isx012_regset_t sr300pc20_Contrast_Minus_1[] =
{
{0x01C7,0x6C,0x01},    //UICONTRAST
};

static const isx012_regset_t sr300pc20_Contrast_Default[] =
{
{0x01C7,0x80,0x01},    //UICONTRAST
};

static const isx012_regset_t sr300pc20_Contrast_Plus_1[] =
{
{0x01C7,0x94,0x01},    //UICONTRAST
};

static const isx012_regset_t sr300pc20_Contrast_Plus_2[] =
{
{0x01C7,0xA8,0x01},    //UICONTRAST
};

static const isx012_regset_t sr300pc20_Effect_Sketch[] =
{
{0x01C5,0x06,0x01}, /* FMODE */
{0x6C5F,0x04,0x01}, /* SKETCH_APGAIN */
};

static const isx012_regset_t sr300pc20_Effect_Pastel[] =
{
{0x01C5,0x05,0x01}, /* FMODE */
};

static const isx012_regset_t sr300pc20_Effect_Black_White[] =
{
{0x01C5,0x04,0x01},    //FMODE
};

static const isx012_regset_t SR300PC20_Effect_Negative[] =
{
{0x01C5,0x02,0x01},    //FMODE
};

static const isx012_regset_t sr300pc20_Effect_Solar[] =
{
{0x01C5,0x01,0x01},    /* FMODE */
};

static const isx012_regset_t sr300pc20_Effect_Normal[] =
{
{0x01C5,0x00,0x01},    //FMODE
};

static const isx012_regset_t sr300pc20_Effect_Sepia[] =
{
{0x01C5,0x03,0x01},    //FMODE
};

static const isx012_regset_t sr300pc20_Metering_Center[] =
{
{0x02AC,0x01,0x01},    //AE_SUB_SN1
{0x02B6,0x01,0x01},    //AE_SUB_SN11
};

static const isx012_regset_t sr300pc20_Metering_Matrix[] =
{
{0x02AC,0x00,0x01},    //AE_SUB_SN1
};

static const isx012_regset_t sr300pc20_Metering_Spot[] =
{
{0x02AC,0x02,0x01},    //AE_SUB_SN1
{0x02B6,0x02,0x01},    //AE_SUB_SN11
};

static const isx012_regset_t SR300PC20_ExpSetting_Default[] =
{
{0x0180,0x00,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_M1Step[] =
{
{0x0180,0xFF,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_M2Step[] =
{
{0x0180,0xFE,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_M3Step[] =
{
{0x0180,0xFD,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_M4Step[] =
{
{0x0180,0xFC,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_P1Step[] =
{
{0x0180,0x01,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_P2Step[] =
{
{0x0180,0x02,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_P3Step[] =
{
{0x0180,0x03,0x01},    //EVSEL
};

static const isx012_regset_t SR300PC20_ExpSetting_P4Step[] =
{
{0x0180,0x04,0x01},    //EVSEL
};

static const isx012_regset_t sr300pc20_ISO_50[] =
{
{0x02A8,0x04,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t sr300pc20_ISO_100[] =
{
{0x02A8,0x07,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t sr300pc20_ISO_200[] =
{
{0x02A8,0x0A,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t sr300pc20_ISO_400[] =
{
{0x02A8,0x0D,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

#if 0
static const isx012_regset_t SR300PC20_ISO_800[] =
{
{0x02A8,0x10,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};
#endif

static const isx012_regset_t sr300pc20_ISO_Auto[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1
{0x5E8A,0x02,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x02,0x01},    // EVREF_GAIN_B :
{0x0362,0x55,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x55,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t SR300PC20_Capture_SizeSetting[] =
{
{0x0092,0x0A20,0x02},    //HSIZE_CAP : 2592
{0x0098,0x0798,0x02},    //VSIZE_CAP : 1944
};

static const isx012_regset_t SR300PC20_Capture_Mode[] =
{
{0x008A,0x00,0x01},    //OUTFMT_CAP
{0x0084,0x00,0x01},    //SENSMODE_CAP
{0x0087,0x03,0x01},    //FPSTYPE_CAP
{0x0012,0xFF,0x01},    //INTCLR0
{0x0081,0x02,0x01},    //MODESEL
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t SR300PC20_Lowlux_Night_Capture_Mode[] =
{
{0x03A0,0xA0,0x01},    //UISATURATION_TYPE3 :
{0x039D,0xF4,0x01},    //UIHUE_TYPE3 :
{0x982A,0xFFD8,0x02},    // CS_CBLLEV_A :
{0x9830,0xFFD8,0x02},    // CS_CRLLEV_A :
{0x9805,0x06,0x01},    // CS_SLP_C_A :
{0x008A,0x00,0x01},    //OUTFMT_CAP
{0x0084,0x00,0x01},    //SENSMODE_CAP
{0x0087,0x03,0x01},    //FPSTYPE_CAP
{0x0012,0xFF,0x01},    //INTCLR0
{0x0081,0x02,0x01},    //MODESEL
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t sr300pc20_Saturation_Default[] =
{
{0x039E,0x80,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t sr300pc20_Saturation_Minus_1[] =
{
{0x039E,0x62,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t sr300pc20_Saturation_Minus_2[] =
{
{0x039E,0x44,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t sr300pc20_Saturation_Plus_1[] =
{
{0x039E,0x9E,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t sr300pc20_Saturation_Plus_2[] =
{
{0x039E,0xBC,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t sr300pc20_Scene_Default[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Landscape[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x039F,0x9E,0x01},    //UISATURATION_TYPE2 :
{0x03A3,0x2C,0x01},    //UISHARPNESS_POS_TYPE3 : +1
{0x03A6,0x2C,0x01},    //UISHARPNESS_NEG_TYPE3 : +1
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x01,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Sports[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x02,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Party_Indoor[] =
{
{0x02A8,0x0A,0x01},    //ISO_TYPE1 : ISO200
{0x039F,0x9E,0x01},    //UISATURATION_TYPE2 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x04,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Beach_Snow[] =
{
{0x02A8,0x04,0x01},    //ISO_TYPE1 : ISO50
{0x039F,0x9E,0x01},    //UISATURATION_TYPE2 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x04,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Sunset[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x0287,0x25,0x01},    //AWB_SN6 : daylight
{0x0394,0x00,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Duskdawn[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x0287,0x27,0x01},    //AWB_SN6 : CWF
{0x0394,0x00,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Candle_Light[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x0287,0x25,0x01},    //AWB_SN6 : daylight
{0x0394,0x00,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Fall_Color[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x039F,0xBC,0x01},    //UISATURATION_TYPE2 :
{0x0287,0x20,0x01},    //AWB_SN6 : AWB
{0x0394,0x04,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Portrait[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x50,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Nightshot[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x07,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Fireworks[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : AUTO
{0x5E06,0x04,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x08,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Text[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x03A3,0x38,0x01},    //UISHARPNESS_POS_TYPE3 : +2
{0x03A6,0x38,0x01},    //UISHARPNESS_NEG_TYPE3 : +2
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0xA0,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Scene_Backlight[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t sr300pc20_Sharpness_Default[] =
{
{0x00A1,0x20,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x20,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t sr300pc20_Sharpness_Minus_1[] =
{
{0x00A1,0x14,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x14,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t sr300pc20_Sharpness_Minus_2[] =
{
{0x00A1,0x08,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x08,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t sr300pc20_Sharpness_Plus_1[] =
{
{0x00A1,0x2C,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x2C,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t sr300pc20_Sharpness_Plus_2[] =
{
{0x00A1,0x38,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x38,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t sr300pc20_WB_Auto[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_WB_Cloudy[] =
{
{0x0282,0x26,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_WB_Sunny[] =
{
{0x0282,0x25,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_WB_Fluorescent[] =
{
{0x0282,0x27,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_WB_Tungsten[] =
{
{0x0282,0x28,0x01},    //AWB_SN1
};

static const isx012_regset_t SR300PC20_Image_Quality_Standard[] =
{
{0x00F6,0x00,0x01},    //JPG_QLTY
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t SR300PC20_Image_Quality_Fine[] =
{
{0x00F6,0x01,0x01},    //JPG_QLTY
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t SR300PC20_Image_Quality_Super_Fine[] =
{
{0x00F6,0x02,0x01},    //JPG_QLTY
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t SR300PC20_Image_Quality_Table[] =
{
{0x00F7,0x52,0x01},    // INIT_QLTY0 : Standard 82
{0x00F8,0x59,0x01},    // INIT_QLTY1 : Fine 89
{0x00F9,0x5F,0x01},    // INIT_QLTY2 : SuperFine 95
};

static const isx012_regset_t SR300PC20_Sensor_Off_VCM[] =
{
{0x6674,0x00,0x01},    // AF_MONICHG_MOVE_F
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6600,0x0000,0x02},    // AF_SEARCH_AREA_LOW
{0x6666,0x0000,0x02},    // AF_AREA_LOW_TYPE1
{0x6648,0x00C8,0x02},    // AF_MANUAL_POS :
{0x00B1,0x01,0x01},    //AF_RESTART_F
{0xFFFF,0x64,0x01},    // $wait, 100
{0x6648,0x0019,0x02},    // AF_MANUAL_POS :
{0x00B1,0x01,0x01},    // AF_RESTART_F
{0xFFFF,0x64,0x01},    // $wait, 100
};

static const isx012_regset_t sr300pc20_1280_Preview_E[] =
{
{0x0090,0x0500,0x02},	 //HSIZE_MONI : 1280
{0x0096,0x02D0,0x02},	 //VSIZE_MONI : 720
};

static const isx012_regset_t sr300pc20_1024_768_Preview[] = {
{0x0090,0x0400,0x02}, /* HSIZE_MONI : 1024 */
{0x0096,0x0300,0x02}, /* VSIZE_MONI : 768 */
};

static const isx012_regset_t sr300pc20_800_Preview[] =
{
{0x0090,0x0320,0x02},	 //HSIZE_MONI : 800
{0x0096,0x01E0,0x02},	 //VSIZE_MONI : 480
};

static const isx012_regset_t sr300pc20_720_Preview[] =
{
{0x0090,0x02D0,0x02},	 //HSIZE_MONI : 720
{0x0096,0x01E0,0x02},	 //VSIZE_MONI : 480
};

static const isx012_regset_t sr300pc20_640_Preview[] =
{
{0x0090,0x0280,0x02},	 //HSIZE_MONI : 640
{0x0096,0x01E0,0x02},	 //VSIZE_MONI : 480
};

#if defined(CONFIG_MACH_P4NOTELTE_KOR_SKT) \
	|| defined(CONFIG_MACH_P4NOTELTE_KOR_KT) \
	|| defined(CONFIG_MACH_P4NOTELTE_KOR_LGT) /*For 4G VT call in Domestic*/
static const isx012_regset_t sr300pc20_480_Preview[] = {
{0x0090, 0x01E0, 0x02},		/* HSIZE_MONI : 480 */
{0x0096, 0x0280, 0x02},		/* VSIZE_MONI : 640 */
};
#endif

static const isx012_regset_t sr300pc20_320_Preview[] =
{
{0x0090,0x0140,0x02},	 //HSIZE_MONI : 320
{0x0096,0x00F0,0x02},	 //VSIZE_MONI :240

};
static const isx012_regset_t sr300pc20_176_Preview[] =
{
{0x0090,0x00B0,0x02},	 //HSIZE_MONI : 176
{0x0096,0x0090,0x02},	 //VSIZE_MONI : 144
};


static const isx012_regset_t sr300pc20_5M_Capture[] = {
{0x0092,0x0A00,0x02}, /* HSIZE_CAP: 2560 */
{0x0098,0x0780,0x02}, /* VSIZE_CAP: 1920 */
};

static const isx012_regset_t sr300pc20_4M_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_3M_Capture[] = {
{0x0092,0x0800,0x02}, /* HSIZE_CAP : 2048 */
{0x0098,0x0600,0x02}, /* VSIZE_CAP : 1536 */
};

static const isx012_regset_t sr300pc20_2_4M_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_1_5M_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_960_720_Capture[] = {
{0x0092,0x03C0,0x02}, /* HSIZE_CAP : 960 */
{0x0098,0x02D0,0x02}, /* VSIZE_CAP : 720 */
};

static const isx012_regset_t sr300pc20_1M_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_4K_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_VGA_Capture[] = {
{0x0092,0x0280,0x02}, /* HSIZE_CAP : 640 */
{0x0098,0x01E0,0x02}, /* VSIZE_CAP : 480 */
};

static const isx012_regset_t sr300pc20_QVGA_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_DTP_init[] =
{
{0x01BC,0x50,0x01},//Shading Gain off
{0x5E00,0x07,0x01},//Flicker off

// Pre-WB
{0x6804,0x1000,0x02}, // NORMR
{0x6806,0x1000,0x02}, // NORMB
{0x6808,0x0100,0x02}, // AWBPRER
{0x680A,0x0100,0x02}, // AWBPREB
{0x6818,0x00,0x01},    //REFERENCE SENSITIVITY RATIO OF SENSOR (R/G)
{0x6819,0x00,0x01},    //REFERENCE SENSITIVITY RATIO OF SENSOR (B/G)

{0x036B,0x11,0x01},
{0x0377,0x11,0x01},
{0x0383,0x11,0x01},

//
{0x6C44,0x00,0x01},    // G_CTRL_SEL :

//CNR
{0x6C4A,0x07,0x01},    // MAIN_CONFIG5 :

//ITP NR
{0x5005,0xBB,0x01},    // DM_SW1 :
{0x5006,0x03,0x01},    // DM_SW2 :
{0x0362,0x00,0x01},

{0x6C0B,0x04,0x01},    // PICT_FLAG :
{0x9800,0x80,0x01},    // LMT_WEIGHT_A :
{0x9801,0x80,0x01},    // LMT_WEIGHT_B :

{0x6C46,0x00,0x01},    // MAIN_CONFIG1 :
{0x6C47,0x00,0x01},    // MAIN_CONFIG2 :
{0x6C48,0x00,0x01},    // MAIN_CONFIG3 :
{0x6C49,0x00,0x01},    // MAIN_CONFIG4 :
{0x6C4A,0x00,0x01},    // MAIN_CONFIG5 :


{0x5001,0x04,0x01},    // MUTECNT :
{0x5002,0x00,0x01},    // WDT_EN :
{0x5003,0x07,0x01},    // Z1_SEL1 :
{0x5004,0x00,0x01},    // Z1_SEL2 :
{0x5005,0x00,0x01},    // DM_SW1 :
{0x5006,0x00,0x01},    // DM_SW2 :
{0x5007,0x00,0x01},    // CLMP_CTRL :
{0x5009,0x00,0x01},    // CPUSLEEP_EN :
{0x500A,0x00,0x01},    // FAST_MODECHG_EN :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL :
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT :
{0x500E,0x06D0,0x02},    // SYSINT3_VDLY_1_1 :
{0x5010,0x02F8,0x02},    // SYSINT3_VDLY_1_2 :
{0x5012,0x0118,0x02},    // SYSINT3_VDLY_1_4 :
{0x5014,0x0028,0x02},    // SYSINT3_VDLY_1_8 :
{0x5016,0x0370,0x02},    // SYSINT3_VDLY_1_1_HD :
{0x5018,0x0208,0x02},    // SYSINT3_VDLY_1_2_HD :
{0x501A,0x00,0x01},    // SENS_REVERSE_CTRL :
{0x501B,0x19,0x01},    // EEP_ADDRESS :
{0x501C,0x5180,0x02},    // SRCCK :
{0x501E,0x0001,0x02},

{0x6E86,0x0000,0x02},    // IBYHUE1_POS1 :
{0x6E88,0xFFF5,0x02},    // IRYHUE1_POS1 :
{0x6E8A,0xFFF8,0x02},    // IBYHUE2_POS1 :
{0x6E8C,0xFFF5,0x02},    // IRYHUE2_POS1 :
{0x6E8E,0xFFF8,0x02},    // IBYHUE3_POS1 :
{0x6E90,0xFFEE,0x02},    // IRYHUE3_POS1 :
{0x6E92,0x0000,0x02},    // IBYHUE4_POS1 :
{0x6E94,0xFFEC,0x02},    // IRYHUE4_POS1 :
{0x6F26,0x4E,0x01},    // IRYGAIN1_POS1 :
{0x6F27,0x50,0x01},    // IBYGAIN1_POS1 :
{0x6F28,0x4E,0x01},    // IRYGAIN2_POS1 :
{0x6F29,0x5A,0x01},    // IBYGAIN2_POS1 :
{0x6F2A,0x50,0x01},    // IRYGAIN3_POS1 :
{0x6F2B,0x5A,0x01},    // IBYGAIN3_POS1 :
{0x6F2C,0x50,0x01},    // IRYGAIN4_POS1 :
{0x6F2D,0x50,0x01},    // IBYGAIN4_POS1 :

//ae
{0x5E12,0x0000,0x02},
{0x5E14,0x0000,0x02},
{0x0294,0x03,0x01},

//AWB
{0x625F,0x35,0x01},//CAT_AWB_1
{0x0282,0x05,0x01},//AWB_SN1
//S, 5000, 3F, 8,    // CPUEXT :


{0x5021,0x00,0x01},    // PG_GAIN_SEL :
{0x5022,0x01,0x01},    // PG_WIDTH_SEL :
{0x5023,0x04,0x01},    // PG_MODE_SEL :
{0x5024,0x0000,0x02},    // PG_LEVEL_SEL :
{0x5026,0x00,0x01},    // PG_DATEN_OFF_SEL :
{0x5020,0x01,0x01},    // PGSEL :

};

static const isx012_regset_t sr300pc20_DTP_stop[] =
{
{0x01BC,0x57,0x01},    // Shading Gain off
{0x5E00,0x00,0x01},    // Flicker off
{0x6804,0x11F0,0x02},    // NORMR
{0x6806,0x106F,0x02},    // NORMB
{0x6808,0x014C,0x02},    // AWBPRER
{0x680A,0x021E,0x02},    // AWBPREB
{0x6818,0x00,0x01},    // REFERENCE SENSITIVITY RATIO OF SENSOR (R/G)
{0x6819,0x00,0x01},    // REFERENCE SENSITIVITY RATIO OF SENSOR (B/G)
{0x036B,0x80,0x01},    //
{0x0377,0x80,0x01},    //
{0x0383,0x80,0x01},    //
{0x6C44,0x13,0x01},    // G_CTRL_SEL :
{0x6C4A,0x07,0x01},    // MAIN_CONFIG5 :
{0x5005,0xBB,0x01},    // DM_SW1 :
{0x5006,0x03,0x01},    // DM_SW2 :
{0x0362,0x55,0x01},    //
{0x6C0B,0x00,0x01},    // PICT_FLAG :
{0x9800,0x40,0x01},    // LMT_WEIGHT_A :
{0x9801,0x80,0x01},    // LMT_WEIGHT_B :
{0x6C46,0x1C,0x01},    // MAIN_CONFIG1 :
{0x6C47,0x0F,0x01},    // MAIN_CONFIG2 :
{0x6C48,0x03,0x01},    // MAIN_CONFIG3 :
{0x6C49,0xF5,0x01},    // MAIN_CONFIG4 :
{0x6C4A,0x07,0x01},    // MAIN_CONFIG5 :
{0x5001,0x04,0x01},    // MUTECNT :
{0x5002,0x01,0x01},    // WDT_EN :
{0x5003,0x04,0x01},    // Z1_SEL1 :
{0x5004,0x00,0x01},    // Z1_SEL2 :
{0x5005,0xBB,0x01},    // DM_SW1 :
{0x5006,0x03,0x01},    // DM_SW2 :
{0x5007,0x01,0x01},    // CLMP_CTRL :
{0x5009,0x00,0x01},    // CPUSLEEP_EN :
{0x500A,0x00,0x01},    // FAST_MODECHG_EN :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL :
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT :
{0x500E,0x06D0,0x02},    // SYSINT3_VDLY_1_1 :
{0x5010,0x02F8,0x02},    // SYSINT3_VDLY_1_2 :
{0x5012,0x0118,0x02},    // SYSINT3_VDLY_1_4 :
{0x5014,0x0028,0x02},    // SYSINT3_VDLY_1_8 :
{0x5016,0x0370,0x02},    // SYSINT3_VDLY_1_1_HD :
{0x5018,0x0208,0x02},    // SYSINT3_VDLY_1_2_HD :
{0x501A,0x00,0x01},    // SENS_REVERSE_CTRL :
{0x501B,0x50,0x01},    // EEP_ADDRESS :
{0x501C,0x5180,0x02},    // SRCCK :
{0x501E,0x0001,0x02},
{0x6E86,0x0000,0x02},    // IBYHUE1_POS1 :
{0x6E88,0xFFF5,0x02},    // IRYHUE1_POS1 :
{0x6E8A,0xFFF8,0x02},    // IBYHUE2_POS1 :
{0x6E8C,0xFFF5,0x02},    // IRYHUE2_POS1 :
{0x6E8E,0xFFF8,0x02},    // IBYHUE3_POS1 :
{0x6E90,0xFFEE,0x02},    // IRYHUE3_POS1 :
{0x6E92,0x0000,0x02},    // IBYHUE4_POS1 :
{0x6E94,0xFFEC,0x02},    // IRYHUE4_POS1 :
{0x6F26,0x4E,0x01},    // IRYGAIN1_POS1 :
{0x6F27,0x50,0x01},    // IBYGAIN1_POS1 :
{0x6F28,0x4E,0x01},    // IRYGAIN2_POS1 :
{0x6F29,0x5A,0x01},    // IBYGAIN2_POS1 :
{0x6F2A,0x50,0x01},    // IRYGAIN3_POS1 :
{0x6F2B,0x5A,0x01},    // IBYGAIN3_POS1 :
{0x6F2C,0x50,0x01},    // IRYGAIN4_POS1 :
{0x6F2D,0x50,0x01},    // IBYGAIN4_POS1 :
{0x5E12,0x014A,0x02},    //
{0x5E14,0x000D,0x02},    //
{0x0294,0x00,0x01},    //
{0x625F,0x35,0x01},    // CAT_AWB_1
{0x0282,0x20,0x01},    // AWB_SN1
{0x5021,0x00,0x01},    // PG_GAIN_SEL :
{0x5022,0x00,0x01},    // PG_WIDTH_SEL :
{0x5023,0x00,0x01},    // PG_MODE_SEL :
{0x5024,0x0000,0x02},    // PG_LEVEL_SEL :
{0x5026,0x00,0x01},    // PG_DATEN_OFF_SEL :
{0x5020,0x00,0x01},    // PGSEL :

};

static const isx012_regset_t sr300pc20_Preview_Return[] =
{
{0x0282,0x20,0x01},    //AWB_SN1

};

static const isx012_regset_t sr300pc20_Capture_Start[] =
{
	{0x008A,0x00,0x01},    //OUTFMT_CAP
	{0x0084,0x00,0x01},	  //SENSMODE_CAP
	{0x0087,0x03,0x01},    //FPSTYPE_CAP
	{0x0012,0x06,0x01},    //INTCLR0
	{0x0081,0x02,0x01},    //MODESEL
	{0x0082,0x01,0x01},    //MONI_REFRESH
};
#if 0
static const isx012_regset_t sr300pc20_Preview_Return[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};
#endif

static const isx012_regset_t sr300pc20_fps_auto[] =
{
{0x0308,0x11,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x0012,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t sr300pc20_fps_7fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x0D59,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t sr300pc20_fps_15fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x041C,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t sr300pc20_fps_25fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x00E1,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t sr300pc20_fps_30fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x0012,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t sr300pc20_ae_lock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_ae_unlock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_awb_lock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t sr300pc20_awb_unlock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};


static const isx012_regset_t SR300PC20_Shading_Nocal[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0x61,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xBE,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x9E,0x01},
{0xED09,0x2C,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x47,0x01},
{0xED0C,0x49,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0x61,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xA8,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x31,0x01},
{0xED15,0xA1,0x01},
{0xED16,0xC7,0x01},
{0xED17,0x4C,0x01},
{0xED18,0xDE,0x01},
{0xED19,0xC1,0x01},
{0xED1A,0xD2,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x76,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x10,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xC6,0x01},
{0xED22,0x40,0x01},
{0xED23,0xA2,0x01},
{0xED24,0x99,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xDC,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFC,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0xA6,0x01},
{0xED2D,0x41,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x49,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0x8C,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0B,0x01},
{0xED36,0x91,0x01},
{0xED37,0x86,0x01},
{0xED38,0x3D,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x39,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x50,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x16,0x01},
{0xED40,0xCF,0x01},
{0xED41,0xBC,0x01},
{0xED42,0x45,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x41,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xE8,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x16,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x86,0x01},
{0xED4E,0x3E,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xC1,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x02,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAE,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x44,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0xF9,0x01},
{0xED5C,0xCA,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x0C,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x98,0x01},
{0xED61,0xE2,0x01},
{0xED62,0xA8,0x01},
{0xED63,0x26,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xC1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x1C,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x93,0x01},
{0xED6C,0xA7,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xD9,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x54,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x93,0x01},
{0xED77,0xAA,0x01},
{0xED78,0x98,0x01},
{0xED79,0xE5,0x01},
{0xED7A,0x32,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x29,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x8E,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBB,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xA4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0x84,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF1,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA2,0x01},
{0xED96,0x43,0x01},
{0xED97,0x99,0x01},
{0xED98,0xE4,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x25,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB1,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x24,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x00,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEA,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0xC6,0x01},
{0xEDB1,0x3B,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0x99,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA4,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB2,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCD,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x86,0x01},
{0xEDC7,0x3D,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x01,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x80,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC3,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x25,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB1,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCC,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC7,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0xA6,0x01},
{0xEDDD,0x39,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0x91,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x54,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x1B,0x01},
{0xEDE5,0xFC,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0x46,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x71,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x46,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x17,0x01},
{0xEDF0,0xD9,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0x86,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x09,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x6A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x1E,0x01},
{0xEDFB,0x25,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x67,0x01},
{0xEDFE,0x45,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x69,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0xF6,0x01},
{0xEE04,0x93,0x01},
{0xEE05,0x9A,0x01},
{0xEE06,0xFA,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0x26,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xB9,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x6E,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x2D,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x49,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0xB9,0x01},
{0xEE17,0x52,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0x98,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x1E,0x01},
{0xEE1C,0x22,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xA7,0x01},
{0xEE1F,0x48,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x49,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xB4,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x1F,0x01},
{0xEE27,0x31,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4B,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x28,0x01},
{0xEF55,0xC2,0x01},
{0xEF56,0x11,0x01},
{0xEF57,0x8C,0x01},
{0xEF58,0x46,0x01},
{0xEF59,0x34,0x01},
{0xEF5A,0xA2,0x01},
{0xEF5B,0x12,0x01},
{0xEF5C,0xCD,0x01},
{0xEF5D,0x08,0x01},
{0xEF5E,0x47,0x01},
{0xEF5F,0x27,0x01},
{0xEF60,0xAA,0x01},
{0xEF61,0x10,0x01},
{0xEF62,0x7F,0x01},
{0xEF63,0xC2,0x01},
{0xEF64,0xF3,0x01},
{0xEF65,0x1C,0x01},
{0xEF66,0xE4,0x01},
{0xEF67,0x40,0x01},
{0xEF68,0x27,0x01},
{0xEF69,0x3C,0x01},
{0xEF6A,0xFB,0x01},
{0xEF6B,0xA1,0x01},
{0xEF6C,0x90,0x01},
{0xEF6D,0x7C,0x01},
{0xEF6E,0x92,0x01},
{0xEF6F,0x63,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC5,0x01},
{0xEF72,0x0C,0x01},
{0xEF73,0x66,0x01},
{0xEF74,0x31,0x01},
{0xEF75,0xA4,0x01},
{0xEF76,0x49,0x01},
{0xEF77,0x0E,0x01},
{0xEF78,0x7F,0x01},
{0xEF79,0xA0,0x01},
{0xEF7A,0xB3,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB6,0x01},
{0xEF7D,0x34,0x01},
{0xEF7E,0x85,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4D,0x01},
{0xEF81,0x61,0x01},
{0xEF82,0x0B,0x01},
{0xEF83,0x68,0x01},
{0xEF84,0xB6,0x01},
{0xEF85,0x73,0x01},
{0xEF86,0x9B,0x01},
{0xEF87,0xBB,0x01},
{0xEF88,0x0C,0x01},
{0xEF89,0x45,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x17,0x01},
{0xEF8C,0x11,0x01},
{0xEF8D,0x49,0x01},
{0xEF8E,0x51,0x01},
{0xEF8F,0xF4,0x01},
{0xEF90,0xC2,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD4,0x01},
{0xEF93,0x94,0x01},
{0xEF94,0xC5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0B,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x62,0x01},
{0xEF9B,0x62,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD5,0x01},
{0xEF9E,0xA4,0x01},
{0xEF9F,0xC6,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x2F,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x22,0x01},
{0xEFA7,0x13,0x01},
{0xEFA8,0xB4,0x01},
{0xEFA9,0xC0,0x01},
{0xEFAA,0x86,0x01},
{0xEFAB,0x37,0x01},
{0xEFAC,0x7B,0x01},
{0xEFAD,0x29,0x01},
{0xEFAE,0x8A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x52,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA4,0x01},
{0xEFB4,0xF4,0x01},
{0xEFB5,0x25,0x01},
{0xEFB6,0x38,0x01},
{0xEFB7,0xD9,0x01},
{0xEFB8,0x01,0x01},
{0xEFB9,0xCD,0x01},
{0xEFBA,0x5B,0x01},
{0xEFBB,0xA0,0x01},
{0xEFBC,0x72,0x01},
{0xEFBD,0x14,0x01},
{0xEFBE,0xA9,0x01},
{0xEFBF,0xCC,0x01},
{0xEFC0,0xC5,0x01},
{0xEFC1,0x34,0x01},
{0xEFC2,0xE3,0x01},
{0xEFC3,0xF1,0x01},
{0xEFC4,0x0F,0x01},
{0xEFC5,0x74,0x01},
{0xEFC6,0x50,0x01},
{0xEFC7,0xF3,0x01},
{0xEFC8,0x98,0x01},
{0xEFC9,0xC2,0x01},
{0xEFCA,0x40,0x01},
{0xEFCB,0x86,0x01},
{0xEFCC,0x35,0x01},
{0xEFCD,0xD4,0x01},
{0xEFCE,0x29,0x01},
{0xEFCF,0xD0,0x01},
{0xEFD0,0x86,0x01},
{0xEFD1,0xFE,0x01},
{0xEFD2,0x23,0x01},
{0xEFD3,0x9E,0x01},
{0xEFD4,0xE8,0x01},
{0xEFD5,0x28,0x01},
{0xEFD6,0x87,0x01},
{0xEFD7,0x3A,0x01},
{0xEFD8,0xE7,0x01},
{0xEFD9,0x21,0x01},
{0xEFDA,0x10,0x01},
{0xEFDB,0x89,0x01},
{0xEFDC,0x3E,0x01},
{0xEFDD,0x64,0x01},
{0xEFDE,0xA2,0x01},
{0xEFDF,0x0D,0x01},
{0xEFE0,0x41,0x01},
{0xEFE1,0xC8,0x01},
{0xEFE2,0x41,0x01},
{0xEFE3,0x14,0x01},
{0xEFE4,0x02,0x01},
{0xEFE5,0x11,0x01},
{0xEFE6,0x8A,0x01},
{0xEFE7,0x4C,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},


//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x12,0x01},
{0xEFEF,0x42,0x01},
{0xEFF0,0x51,0x01},
{0xEFF1,0x89,0x01},
{0xEFF2,0x38,0x01},
{0xEFF3,0xD4,0x01},
{0xEFF4,0x21,0x01},
{0xEFF5,0x10,0x01},
{0xEFF6,0xAD,0x01},
{0xEFF7,0xA8,0x01},
{0xEFF8,0x45,0x01},
{0xEFF9,0x18,0x01},
{0xEFFA,0x4A,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7D,0x01},
{0xEFFD,0xBA,0x01},
{0xEFFE,0xD3,0x01},
{0xEFFF,0x1C,0x01},
{0xF000,0xE4,0x01},
{0xF001,0x40,0x01},
{0xF002,0x27,0x01},
{0xF003,0x3C,0x01},
{0xF004,0xF8,0x01},
{0xF005,0x69,0x01},
{0xF006,0x10,0x01},
{0xF007,0x7B,0x01},
{0xF008,0x8E,0x01},
{0xF009,0x63,0x01},
{0xF00A,0x1A,0x01},
{0xF00B,0xC6,0x01},
{0xF00C,0x10,0x01},
{0xF00D,0xA6,0x01},
{0xF00E,0x31,0x01},
{0xF00F,0xA6,0x01},
{0xF010,0x59,0x01},
{0xF011,0x8E,0x01},
{0xF012,0x7E,0x01},
{0xF013,0x9A,0x01},
{0xF014,0xB3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB6,0x01},
{0xF017,0x38,0x01},
{0xF018,0xA5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x4F,0x01},
{0xF01B,0x79,0x01},
{0xF01C,0xCB,0x01},
{0xF01D,0x68,0x01},
{0xF01E,0xBA,0x01},
{0xF01F,0x53,0x01},
{0xF020,0x9B,0x01},
{0xF021,0xBB,0x01},
{0xF022,0x0C,0x01},
{0xF023,0x65,0x01},
{0xF024,0x24,0x01},
{0xF025,0x17,0x01},
{0xF026,0x21,0x01},
{0xF027,0xC9,0x01},
{0xF028,0x51,0x01},
{0xF029,0xFC,0x01},
{0xF02A,0xF2,0x01},
{0xF02B,0x9B,0x01},
{0xF02C,0xD3,0x01},
{0xF02D,0x94,0x01},
{0xF02E,0xC5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x48,0x01},
{0xF033,0x43,0x01},
{0xF034,0x66,0x01},
{0xF035,0x92,0x01},
{0xF036,0x96,0x01},
{0xF037,0xD7,0x01},
{0xF038,0xA0,0x01},
{0xF039,0xE6,0x01},
{0xF03A,0x2C,0x01},
{0xF03B,0x2F,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x93,0x01},
{0xF042,0xB5,0x01},
{0xF043,0xCC,0x01},
{0xF044,0x46,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7C,0x01},
{0xF047,0x29,0x01},
{0xF048,0x8A,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x12,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0x00,0x01},
{0xF04F,0xA6,0x01},
{0xF050,0x38,0x01},
{0xF051,0xD7,0x01},
{0xF052,0x01,0x01},
{0xF053,0x0D,0x01},
{0xF054,0x5C,0x01},
{0xF055,0xA2,0x01},
{0xF056,0x82,0x01},
{0xF057,0x94,0x01},
{0xF058,0xAA,0x01},
{0xF059,0xD8,0x01},
{0xF05A,0x45,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xE5,0x01},
{0xF05D,0xC9,0x01},
{0xF05E,0xCF,0x01},
{0xF05F,0x73,0x01},
{0xF060,0x50,0x01},
{0xF061,0x03,0x01},
{0xF062,0x99,0x01},
{0xF063,0xC3,0x01},
{0xF064,0x4C,0x01},
{0xF065,0xE6,0x01},
{0xF066,0x35,0x01},
{0xF067,0xD7,0x01},
{0xF068,0x21,0x01},
{0xF069,0x10,0x01},
{0xF06A,0x84,0x01},
{0xF06B,0xF2,0x01},
{0xF06C,0x03,0x01},
{0xF06D,0x9E,0x01},
{0xF06E,0xE8,0x01},
{0xF06F,0x2C,0x01},
{0xF070,0xA7,0x01},
{0xF071,0x3A,0x01},
{0xF072,0xE8,0x01},
{0xF073,0x11,0x01},
{0xF074,0x90,0x01},
{0xF075,0x87,0x01},
{0xF076,0x18,0x01},
{0xF077,0x94,0x01},
{0xF078,0x21,0x01},
{0xF079,0x09,0x01},
{0xF07A,0x2D,0x01},
{0xF07B,0x68,0x01},
{0xF07C,0x41,0x01},
{0xF07D,0x11,0x01},
{0xF07E,0xDA,0x01},
{0xF07F,0x10,0x01},
{0xF080,0x88,0x01},
{0xF081,0x2A,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000C,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFF,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t SR300PC20_Shading_0[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0x61,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xBE,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x9E,0x01},
{0xED09,0x2C,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x47,0x01},
{0xED0C,0x49,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0x61,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xA8,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x31,0x01},
{0xED15,0xA1,0x01},
{0xED16,0xC7,0x01},
{0xED17,0x4C,0x01},
{0xED18,0xDE,0x01},
{0xED19,0xC1,0x01},
{0xED1A,0xD2,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x76,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x10,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xC6,0x01},
{0xED22,0x40,0x01},
{0xED23,0xA2,0x01},
{0xED24,0x99,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xDC,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFC,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0xA6,0x01},
{0xED2D,0x41,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x49,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0x8C,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0B,0x01},
{0xED36,0x91,0x01},
{0xED37,0x86,0x01},
{0xED38,0x3D,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x39,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x50,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x16,0x01},
{0xED40,0xCF,0x01},
{0xED41,0xBC,0x01},
{0xED42,0x45,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x41,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xE8,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x16,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x86,0x01},
{0xED4E,0x3E,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xC1,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x02,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAE,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x44,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0xF9,0x01},
{0xED5C,0xCA,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x0C,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x98,0x01},
{0xED61,0xE2,0x01},
{0xED62,0xA8,0x01},
{0xED63,0x26,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xC1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x1C,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x93,0x01},
{0xED6C,0xA7,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xD9,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x54,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x93,0x01},
{0xED77,0xAA,0x01},
{0xED78,0x98,0x01},
{0xED79,0xE5,0x01},
{0xED7A,0x32,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x29,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x8E,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBB,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xA4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0x84,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF1,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA2,0x01},
{0xED96,0x43,0x01},
{0xED97,0x99,0x01},
{0xED98,0xE4,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x25,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB1,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x24,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x00,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEA,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0xC6,0x01},
{0xEDB1,0x3B,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0x99,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA4,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB2,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCD,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x86,0x01},
{0xEDC7,0x3D,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x01,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x80,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC3,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x25,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB1,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCC,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC7,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0xA6,0x01},
{0xEDDD,0x39,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0x91,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x54,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x1B,0x01},
{0xEDE5,0xFC,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0x46,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x71,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x46,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x17,0x01},
{0xEDF0,0xD9,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0x86,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x09,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x6A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x1E,0x01},
{0xEDFB,0x25,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x67,0x01},
{0xEDFE,0x45,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x69,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0xF6,0x01},
{0xEE04,0x93,0x01},
{0xEE05,0x9A,0x01},
{0xEE06,0xFA,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0x26,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xB9,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x6E,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x2D,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x49,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0xB9,0x01},
{0xEE17,0x52,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0x98,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x1E,0x01},
{0xEE1C,0x22,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xA7,0x01},
{0xEE1F,0x48,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x49,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xB4,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x1F,0x01},
{0xEE27,0x31,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4B,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x28,0x01},
{0xEF55,0xC2,0x01},
{0xEF56,0x11,0x01},
{0xEF57,0x8C,0x01},
{0xEF58,0x46,0x01},
{0xEF59,0x34,0x01},
{0xEF5A,0xA2,0x01},
{0xEF5B,0x12,0x01},
{0xEF5C,0xCD,0x01},
{0xEF5D,0x08,0x01},
{0xEF5E,0x47,0x01},
{0xEF5F,0x27,0x01},
{0xEF60,0xAA,0x01},
{0xEF61,0x10,0x01},
{0xEF62,0x7F,0x01},
{0xEF63,0xC2,0x01},
{0xEF64,0xF3,0x01},
{0xEF65,0x1C,0x01},
{0xEF66,0xE4,0x01},
{0xEF67,0x40,0x01},
{0xEF68,0x27,0x01},
{0xEF69,0x3C,0x01},
{0xEF6A,0xFB,0x01},
{0xEF6B,0xA1,0x01},
{0xEF6C,0x90,0x01},
{0xEF6D,0x7C,0x01},
{0xEF6E,0x92,0x01},
{0xEF6F,0x63,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC5,0x01},
{0xEF72,0x0C,0x01},
{0xEF73,0x66,0x01},
{0xEF74,0x31,0x01},
{0xEF75,0xA4,0x01},
{0xEF76,0x49,0x01},
{0xEF77,0x0E,0x01},
{0xEF78,0x7F,0x01},
{0xEF79,0xA0,0x01},
{0xEF7A,0xB3,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB6,0x01},
{0xEF7D,0x34,0x01},
{0xEF7E,0x85,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4D,0x01},
{0xEF81,0x61,0x01},
{0xEF82,0x0B,0x01},
{0xEF83,0x68,0x01},
{0xEF84,0xB6,0x01},
{0xEF85,0x73,0x01},
{0xEF86,0x9B,0x01},
{0xEF87,0xBB,0x01},
{0xEF88,0x0C,0x01},
{0xEF89,0x45,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x17,0x01},
{0xEF8C,0x11,0x01},
{0xEF8D,0x49,0x01},
{0xEF8E,0x51,0x01},
{0xEF8F,0xF4,0x01},
{0xEF90,0xC2,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD4,0x01},
{0xEF93,0x94,0x01},
{0xEF94,0xC5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0B,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x62,0x01},
{0xEF9B,0x62,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD5,0x01},
{0xEF9E,0xA4,0x01},
{0xEF9F,0xC6,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x2F,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x22,0x01},
{0xEFA7,0x13,0x01},
{0xEFA8,0xB4,0x01},
{0xEFA9,0xC0,0x01},
{0xEFAA,0x86,0x01},
{0xEFAB,0x37,0x01},
{0xEFAC,0x7B,0x01},
{0xEFAD,0x29,0x01},
{0xEFAE,0x8A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x52,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA4,0x01},
{0xEFB4,0xF4,0x01},
{0xEFB5,0x25,0x01},
{0xEFB6,0x38,0x01},
{0xEFB7,0xD9,0x01},
{0xEFB8,0x01,0x01},
{0xEFB9,0xCD,0x01},
{0xEFBA,0x5B,0x01},
{0xEFBB,0xA0,0x01},
{0xEFBC,0x72,0x01},
{0xEFBD,0x14,0x01},
{0xEFBE,0xA9,0x01},
{0xEFBF,0xCC,0x01},
{0xEFC0,0xC5,0x01},
{0xEFC1,0x34,0x01},
{0xEFC2,0xE3,0x01},
{0xEFC3,0xF1,0x01},
{0xEFC4,0x0F,0x01},
{0xEFC5,0x74,0x01},
{0xEFC6,0x50,0x01},
{0xEFC7,0xF3,0x01},
{0xEFC8,0x98,0x01},
{0xEFC9,0xC2,0x01},
{0xEFCA,0x40,0x01},
{0xEFCB,0x86,0x01},
{0xEFCC,0x35,0x01},
{0xEFCD,0xD4,0x01},
{0xEFCE,0x29,0x01},
{0xEFCF,0xD0,0x01},
{0xEFD0,0x86,0x01},
{0xEFD1,0xFE,0x01},
{0xEFD2,0x23,0x01},
{0xEFD3,0x9E,0x01},
{0xEFD4,0xE8,0x01},
{0xEFD5,0x28,0x01},
{0xEFD6,0x87,0x01},
{0xEFD7,0x3A,0x01},
{0xEFD8,0xE7,0x01},
{0xEFD9,0x21,0x01},
{0xEFDA,0x10,0x01},
{0xEFDB,0x89,0x01},
{0xEFDC,0x3E,0x01},
{0xEFDD,0x64,0x01},
{0xEFDE,0xA2,0x01},
{0xEFDF,0x0D,0x01},
{0xEFE0,0x41,0x01},
{0xEFE1,0xC8,0x01},
{0xEFE2,0x41,0x01},
{0xEFE3,0x14,0x01},
{0xEFE4,0x02,0x01},
{0xEFE5,0x11,0x01},
{0xEFE6,0x8A,0x01},
{0xEFE7,0x4C,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},


//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x12,0x01},
{0xEFEF,0x42,0x01},
{0xEFF0,0x51,0x01},
{0xEFF1,0x89,0x01},
{0xEFF2,0x38,0x01},
{0xEFF3,0xD4,0x01},
{0xEFF4,0x21,0x01},
{0xEFF5,0x10,0x01},
{0xEFF6,0xAD,0x01},
{0xEFF7,0xA8,0x01},
{0xEFF8,0x45,0x01},
{0xEFF9,0x18,0x01},
{0xEFFA,0x4A,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7D,0x01},
{0xEFFD,0xBA,0x01},
{0xEFFE,0xD3,0x01},
{0xEFFF,0x1C,0x01},
{0xF000,0xE4,0x01},
{0xF001,0x40,0x01},
{0xF002,0x27,0x01},
{0xF003,0x3C,0x01},
{0xF004,0xF8,0x01},
{0xF005,0x69,0x01},
{0xF006,0x10,0x01},
{0xF007,0x7B,0x01},
{0xF008,0x8E,0x01},
{0xF009,0x63,0x01},
{0xF00A,0x1A,0x01},
{0xF00B,0xC6,0x01},
{0xF00C,0x10,0x01},
{0xF00D,0xA6,0x01},
{0xF00E,0x31,0x01},
{0xF00F,0xA6,0x01},
{0xF010,0x59,0x01},
{0xF011,0x8E,0x01},
{0xF012,0x7E,0x01},
{0xF013,0x9A,0x01},
{0xF014,0xB3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB6,0x01},
{0xF017,0x38,0x01},
{0xF018,0xA5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x4F,0x01},
{0xF01B,0x79,0x01},
{0xF01C,0xCB,0x01},
{0xF01D,0x68,0x01},
{0xF01E,0xBA,0x01},
{0xF01F,0x53,0x01},
{0xF020,0x9B,0x01},
{0xF021,0xBB,0x01},
{0xF022,0x0C,0x01},
{0xF023,0x65,0x01},
{0xF024,0x24,0x01},
{0xF025,0x17,0x01},
{0xF026,0x21,0x01},
{0xF027,0xC9,0x01},
{0xF028,0x51,0x01},
{0xF029,0xFC,0x01},
{0xF02A,0xF2,0x01},
{0xF02B,0x9B,0x01},
{0xF02C,0xD3,0x01},
{0xF02D,0x94,0x01},
{0xF02E,0xC5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x48,0x01},
{0xF033,0x43,0x01},
{0xF034,0x66,0x01},
{0xF035,0x92,0x01},
{0xF036,0x96,0x01},
{0xF037,0xD7,0x01},
{0xF038,0xA0,0x01},
{0xF039,0xE6,0x01},
{0xF03A,0x2C,0x01},
{0xF03B,0x2F,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x93,0x01},
{0xF042,0xB5,0x01},
{0xF043,0xCC,0x01},
{0xF044,0x46,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7C,0x01},
{0xF047,0x29,0x01},
{0xF048,0x8A,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x12,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0x00,0x01},
{0xF04F,0xA6,0x01},
{0xF050,0x38,0x01},
{0xF051,0xD7,0x01},
{0xF052,0x01,0x01},
{0xF053,0x0D,0x01},
{0xF054,0x5C,0x01},
{0xF055,0xA2,0x01},
{0xF056,0x82,0x01},
{0xF057,0x94,0x01},
{0xF058,0xAA,0x01},
{0xF059,0xD8,0x01},
{0xF05A,0x45,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xE5,0x01},
{0xF05D,0xC9,0x01},
{0xF05E,0xCF,0x01},
{0xF05F,0x73,0x01},
{0xF060,0x50,0x01},
{0xF061,0x03,0x01},
{0xF062,0x99,0x01},
{0xF063,0xC3,0x01},
{0xF064,0x4C,0x01},
{0xF065,0xE6,0x01},
{0xF066,0x35,0x01},
{0xF067,0xD7,0x01},
{0xF068,0x21,0x01},
{0xF069,0x10,0x01},
{0xF06A,0x84,0x01},
{0xF06B,0xF2,0x01},
{0xF06C,0x03,0x01},
{0xF06D,0x9E,0x01},
{0xF06E,0xE8,0x01},
{0xF06F,0x2C,0x01},
{0xF070,0xA7,0x01},
{0xF071,0x3A,0x01},
{0xF072,0xE8,0x01},
{0xF073,0x11,0x01},
{0xF074,0x90,0x01},
{0xF075,0x87,0x01},
{0xF076,0x18,0x01},
{0xF077,0x94,0x01},
{0xF078,0x21,0x01},
{0xF079,0x09,0x01},
{0xF07A,0x2D,0x01},
{0xF07B,0x68,0x01},
{0xF07C,0x41,0x01},
{0xF07D,0x11,0x01},
{0xF07E,0xDA,0x01},
{0xF07F,0x10,0x01},
{0xF080,0x88,0x01},
{0xF081,0x2A,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000C,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFF,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t SR300PC20_Shading_1[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0x61,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xBE,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x9E,0x01},
{0xED09,0x2C,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x47,0x01},
{0xED0C,0x49,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0x61,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xA8,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x31,0x01},
{0xED15,0xA1,0x01},
{0xED16,0xC7,0x01},
{0xED17,0x4C,0x01},
{0xED18,0xDE,0x01},
{0xED19,0xC1,0x01},
{0xED1A,0xD2,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x76,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x10,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xC6,0x01},
{0xED22,0x40,0x01},
{0xED23,0xA2,0x01},
{0xED24,0x99,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xDC,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFC,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0xA6,0x01},
{0xED2D,0x41,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x49,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0x8C,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0B,0x01},
{0xED36,0x91,0x01},
{0xED37,0x86,0x01},
{0xED38,0x3D,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x39,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x50,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x16,0x01},
{0xED40,0xCF,0x01},
{0xED41,0xBC,0x01},
{0xED42,0x45,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x41,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xE8,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x16,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x86,0x01},
{0xED4E,0x3E,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xC1,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x02,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAE,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x44,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0xF9,0x01},
{0xED5C,0xCA,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x0C,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x98,0x01},
{0xED61,0xE2,0x01},
{0xED62,0xA8,0x01},
{0xED63,0x26,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xC1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x1C,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x93,0x01},
{0xED6C,0xA7,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xD9,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x54,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x93,0x01},
{0xED77,0xAA,0x01},
{0xED78,0x98,0x01},
{0xED79,0xE5,0x01},
{0xED7A,0x32,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x29,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x8E,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBB,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xA4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0x84,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF1,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA2,0x01},
{0xED96,0x43,0x01},
{0xED97,0x99,0x01},
{0xED98,0xE4,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x25,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB1,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x24,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x00,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEA,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0xC6,0x01},
{0xEDB1,0x3B,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0x99,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA4,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB2,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCD,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x86,0x01},
{0xEDC7,0x3D,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x01,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x80,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC3,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x25,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB1,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCC,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC7,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0xA6,0x01},
{0xEDDD,0x39,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0x91,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x54,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x1B,0x01},
{0xEDE5,0xFC,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0x46,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x71,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x46,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x17,0x01},
{0xEDF0,0xD9,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0x86,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x09,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x6A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x1E,0x01},
{0xEDFB,0x25,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x67,0x01},
{0xEDFE,0x45,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x69,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0xF6,0x01},
{0xEE04,0x93,0x01},
{0xEE05,0x9A,0x01},
{0xEE06,0xFA,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0x26,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xB9,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x6E,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x2D,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x49,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0xB9,0x01},
{0xEE17,0x52,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0x98,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x1E,0x01},
{0xEE1C,0x22,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xA7,0x01},
{0xEE1F,0x48,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x49,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xB4,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x1F,0x01},
{0xEE27,0x31,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4B,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x0B,0x01},
{0xEF55,0xFA,0x01},
{0xEF56,0x10,0x01},
{0xEF57,0x87,0x01},
{0xEF58,0x24,0x01},
{0xEF59,0x24,0x01},
{0xEF5A,0xA1,0x01},
{0xEF5B,0x09,0x01},
{0xEF5C,0x7D,0x01},
{0xEF5D,0x08,0x01},
{0xEF5E,0x44,0x01},
{0xEF5F,0x0A,0x01},
{0xEF60,0x0A,0x01},
{0xEF61,0x50,0x01},
{0xEF62,0x7B,0x01},
{0xEF63,0xAA,0x01},
{0xEF64,0x53,0x01},
{0xEF65,0x9C,0x01},
{0xEF66,0xDF,0x01},
{0xEF67,0x18,0x01},
{0xEF68,0xC7,0x01},
{0xEF69,0x3A,0x01},
{0xEF6A,0xEC,0x01},
{0xEF6B,0xF9,0x01},
{0xEF6C,0x0F,0x01},
{0xEF6D,0x79,0x01},
{0xEF6E,0x80,0x01},
{0xEF6F,0x03,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC3,0x01},
{0xEF72,0xF8,0x01},
{0xEF73,0xE5,0x01},
{0xEF74,0x30,0x01},
{0xEF75,0x9D,0x01},
{0xEF76,0x01,0x01},
{0xEF77,0x4E,0x01},
{0xEF78,0x7B,0x01},
{0xEF79,0x8C,0x01},
{0xEF7A,0x53,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB4,0x01},
{0xEF7D,0x2C,0x01},
{0xEF7E,0x45,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4B,0x01},
{0xEF81,0x49,0x01},
{0xEF82,0x8B,0x01},
{0xEF83,0x66,0x01},
{0xEF84,0xA0,0x01},
{0xEF85,0xF3,0x01},
{0xEF86,0x9A,0x01},
{0xEF87,0xB9,0x01},
{0xEF88,0x04,0x01},
{0xEF89,0x45,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x16,0x01},
{0xEF8C,0x09,0x01},
{0xEF8D,0xC9,0x01},
{0xEF8E,0x50,0x01},
{0xEF8F,0xEC,0x01},
{0xEF90,0x42,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD1,0x01},
{0xEF93,0x88,0x01},
{0xEF94,0xA5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0A,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x60,0x01},
{0xEF9B,0x32,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD2,0x01},
{0xEF9E,0x88,0x01},
{0xEF9F,0x66,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x2E,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x12,0x01},
{0xEFA7,0x93,0x01},
{0xEFA8,0xB2,0x01},
{0xEFA9,0xA4,0x01},
{0xEFAA,0x86,0x01},
{0xEFAB,0x36,0x01},
{0xEFAC,0x77,0x01},
{0xEFAD,0x19,0x01},
{0xEFAE,0x4A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x52,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA3,0x01},
{0xEFB4,0xE4,0x01},
{0xEFB5,0x25,0x01},
{0xEFB6,0x37,0x01},
{0xEFB7,0xCF,0x01},
{0xEFB8,0xD1,0x01},
{0xEFB9,0xCC,0x01},
{0xEFBA,0x5A,0x01},
{0xEFBB,0x9A,0x01},
{0xEFBC,0x52,0x01},
{0xEFBD,0x14,0x01},
{0xEFBE,0xA8,0x01},
{0xEFBF,0xC0,0x01},
{0xEFC0,0x05,0x01},
{0xEFC1,0x34,0x01},
{0xEFC2,0xD8,0x01},
{0xEFC3,0x79,0x01},
{0xEFC4,0xCF,0x01},
{0xEFC5,0x71,0x01},
{0xEFC6,0x42,0x01},
{0xEFC7,0xA3,0x01},
{0xEFC8,0x98,0x01},
{0xEFC9,0xC0,0x01},
{0xEFCA,0x30,0x01},
{0xEFCB,0xA6,0x01},
{0xEFCC,0x34,0x01},
{0xEFCD,0xCA,0x01},
{0xEFCE,0xB1,0x01},
{0xEFCF,0x8F,0x01},
{0xEFD0,0x81,0x01},
{0xEFD1,0xE0,0x01},
{0xEFD2,0x73,0x01},
{0xEFD3,0x9D,0x01},
{0xEFD4,0xE3,0x01},
{0xEFD5,0x04,0x01},
{0xEFD6,0x47,0x01},
{0xEFD7,0x39,0x01},
{0xEFD8,0xDB,0x01},
{0xEFD9,0xA9,0x01},
{0xEFDA,0x8F,0x01},
{0xEFDB,0x83,0x01},
{0xEFDC,0x06,0x01},
{0xEFDD,0xE4,0x01},
{0xEFDE,0xA0,0x01},
{0xEFDF,0x03,0x01},
{0xEFE0,0xFD,0x01},
{0xEFE1,0xA7,0x01},
{0xEFE2,0x3F,0x01},
{0xEFE3,0x03,0x01},
{0xEFE4,0x62,0x01},
{0xEFE5,0x10,0x01},
{0xEFE6,0x84,0x01},
{0xEFE7,0x12,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},



//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x0B,0x01},
{0xEFEF,0x12,0x01},
{0xEFF0,0x11,0x01},
{0xEFF1,0x88,0x01},
{0xEFF2,0x2E,0x01},
{0xEFF3,0x94,0x01},
{0xEFF4,0x21,0x01},
{0xEFF5,0x0E,0x01},
{0xEFF6,0x99,0x01},
{0xEFF7,0xE8,0x01},
{0xEFF8,0x44,0x01},
{0xEFF9,0x10,0x01},
{0xEFFA,0x22,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7C,0x01},
{0xEFFD,0xB6,0x01},
{0xEFFE,0xB3,0x01},
{0xEFFF,0x1C,0x01},
{0xF000,0xE3,0x01},
{0xF001,0x38,0x01},
{0xF002,0xC7,0x01},
{0xF003,0x3B,0x01},
{0xF004,0xF4,0x01},
{0xF005,0x39,0x01},
{0xF006,0x10,0x01},
{0xF007,0x7A,0x01},
{0xF008,0x8A,0x01},
{0xF009,0x53,0x01},
{0xF00A,0x9A,0x01},
{0xF00B,0xC5,0x01},
{0xF00C,0x0C,0x01},
{0xF00D,0x86,0x01},
{0xF00E,0x31,0x01},
{0xF00F,0xA5,0x01},
{0xF010,0x49,0x01},
{0xF011,0xCE,0x01},
{0xF012,0x7D,0x01},
{0xF013,0x94,0x01},
{0xF014,0xA3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB6,0x01},
{0xF017,0x38,0x01},
{0xF018,0xA5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x4F,0x01},
{0xF01B,0x79,0x01},
{0xF01C,0x8B,0x01},
{0xF01D,0x68,0x01},
{0xF01E,0xB4,0x01},
{0xF01F,0x43,0x01},
{0xF020,0x1B,0x01},
{0xF021,0xBB,0x01},
{0xF022,0x0C,0x01},
{0xF023,0x45,0x01},
{0xF024,0x24,0x01},
{0xF025,0x17,0x01},
{0xF026,0x19,0x01},
{0xF027,0xC9,0x01},
{0xF028,0x51,0x01},
{0xF029,0xFA,0x01},
{0xF02A,0xD2,0x01},
{0xF02B,0x1B,0x01},
{0xF02C,0xD3,0x01},
{0xF02D,0x94,0x01},
{0xF02E,0xC5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x48,0x01},
{0xF033,0x43,0x01},
{0xF034,0x66,0x01},
{0xF035,0x82,0x01},
{0xF036,0x96,0x01},
{0xF037,0xD6,0x01},
{0xF038,0x98,0x01},
{0xF039,0xC6,0x01},
{0xF03A,0x2C,0x01},
{0xF03B,0x2F,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x13,0x01},
{0xF042,0xB5,0x01},
{0xF043,0xC8,0x01},
{0xF044,0x06,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7B,0x01},
{0xF047,0x29,0x01},
{0xF048,0x8A,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x12,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0xFC,0x01},
{0xF04F,0x65,0x01},
{0xF050,0x38,0x01},
{0xF051,0xD4,0x01},
{0xF052,0xF9,0x01},
{0xF053,0xCC,0x01},
{0xF054,0x5B,0x01},
{0xF055,0xA0,0x01},
{0xF056,0x82,0x01},
{0xF057,0x14,0x01},
{0xF058,0xAA,0x01},
{0xF059,0xD4,0x01},
{0xF05A,0x05,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xE2,0x01},
{0xF05D,0xA9,0x01},
{0xF05E,0x4F,0x01},
{0xF05F,0x73,0x01},
{0xF060,0x4E,0x01},
{0xF061,0xF3,0x01},
{0xF062,0x18,0x01},
{0xF063,0xC3,0x01},
{0xF064,0x48,0x01},
{0xF065,0xC6,0x01},
{0xF066,0x35,0x01},
{0xF067,0xD4,0x01},
{0xF068,0x01,0x01},
{0xF069,0xD0,0x01},
{0xF06A,0x82,0x01},
{0xF06B,0xEA,0x01},
{0xF06C,0xD3,0x01},
{0xF06D,0x1D,0x01},
{0xF06E,0xE7,0x01},
{0xF06F,0x24,0x01},
{0xF070,0x47,0x01},
{0xF071,0x3A,0x01},
{0xF072,0xE5,0x01},
{0xF073,0xF1,0x01},
{0xF074,0x0F,0x01},
{0xF075,0x86,0x01},
{0xF076,0x0A,0x01},
{0xF077,0x34,0x01},
{0xF078,0xA1,0x01},
{0xF079,0x06,0x01},
{0xF07A,0x19,0x01},
{0xF07B,0xE8,0x01},
{0xF07C,0x40,0x01},
{0xF07D,0x0D,0x01},
{0xF07E,0xB2,0x01},
{0xF07F,0x90,0x01},
{0xF080,0x86,0x01},
{0xF081,0x1C,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000D,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFE,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t SR300PC20_Shading_2[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0xD9,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xD8,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x1E,0x01},
{0xED09,0x32,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x67,0x01},
{0xED0C,0x4A,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0xA9,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xBC,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x37,0x01},
{0xED15,0xA1,0x01},
{0xED16,0x87,0x01},
{0xED17,0x4E,0x01},
{0xED18,0xDE,0x01},
{0xED19,0x41,0x01},
{0xED1A,0xD3,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x8C,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x14,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xA6,0x01},
{0xED22,0x41,0x01},
{0xED23,0xA2,0x01},
{0xED24,0xC1,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xE6,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFF,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0x66,0x01},
{0xED2D,0x42,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x91,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0xA2,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0F,0x01},
{0xED36,0x91,0x01},
{0xED37,0x26,0x01},
{0xED38,0x3E,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x51,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x54,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x96,0x01},
{0xED40,0xD0,0x01},
{0xED41,0xBC,0x01},
{0xED42,0xA5,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x61,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xF2,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x1A,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x46,0x01},
{0xED4E,0x3F,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xD9,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x06,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAF,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x64,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0x01,0x01},
{0xED5C,0xCB,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x10,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x18,0x01},
{0xED61,0xE4,0x01},
{0xED62,0xA8,0x01},
{0xED63,0xE6,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xE1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x20,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x13,0x01},
{0xED6C,0xA8,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xE1,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x56,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x13,0x01},
{0xED77,0xAB,0x01},
{0xED78,0x98,0x01},
{0xED79,0x25,0x01},
{0xED7A,0x33,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x49,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x96,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBC,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xC4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0xA4,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF9,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA8,0x01},
{0xED96,0x43,0x01},
{0xED97,0x19,0x01},
{0xED98,0xE6,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x45,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB9,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x44,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x04,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEC,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0x66,0x01},
{0xEDB1,0x3C,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0xA9,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA6,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB4,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCE,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x06,0x01},
{0xEDC7,0x3E,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x31,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x86,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC4,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x45,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB9,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCE,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC8,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0x06,0x01},
{0xEDDD,0x3A,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0xC1,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x64,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x9B,0x01},
{0xEDE5,0xFE,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0xA6,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x89,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x4A,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x97,0x01},
{0xEDF0,0xDA,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0xE6,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x39,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x7A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x9E,0x01},
{0xEDFB,0x2A,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x87,0x01},
{0xEDFE,0x46,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x99,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0x02,0x01},
{0xEE04,0x94,0x01},
{0xEE05,0x1A,0x01},
{0xEE06,0xFD,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0xE6,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xF1,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x80,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x33,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x4B,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0x21,0x01},
{0xEE17,0x53,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0xAE,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x9E,0x01},
{0xEE1C,0x26,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xC7,0x01},
{0xEE1F,0x49,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x99,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xCA,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x9F,0x01},
{0xEE27,0x37,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4D,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x2F,0x01},
{0xEF55,0xF2,0x01},
{0xEF56,0x51,0x01},
{0xEF57,0x8D,0x01},
{0xEF58,0x50,0x01},
{0xEF59,0x74,0x01},
{0xEF5A,0xA2,0x01},
{0xEF5B,0x14,0x01},
{0xEF5C,0xE1,0x01},
{0xEF5D,0xC8,0x01},
{0xEF5E,0x47,0x01},
{0xEF5F,0x2E,0x01},
{0xEF60,0xD2,0x01},
{0xEF61,0x10,0x01},
{0xEF62,0x80,0x01},
{0xEF63,0xC8,0x01},
{0xEF64,0x13,0x01},
{0xEF65,0x9D,0x01},
{0xEF66,0xE5,0x01},
{0xEF67,0x48,0x01},
{0xEF68,0x87,0x01},
{0xEF69,0x3C,0x01},
{0xEF6A,0xFE,0x01},
{0xEF6B,0xC9,0x01},
{0xEF6C,0x50,0x01},
{0xEF6D,0x7D,0x01},
{0xEF6E,0x96,0x01},
{0xEF6F,0x83,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC6,0x01},
{0xEF72,0x10,0x01},
{0xEF73,0xA6,0x01},
{0xEF74,0x31,0x01},
{0xEF75,0xA5,0x01},
{0xEF76,0x61,0x01},
{0xEF77,0xCE,0x01},
{0xEF78,0x7F,0x01},
{0xEF79,0xA4,0x01},
{0xEF7A,0xD3,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB6,0x01},
{0xEF7D,0x38,0x01},
{0xEF7E,0xA5,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4E,0x01},
{0xEF81,0x69,0x01},
{0xEF82,0x4B,0x01},
{0xEF83,0x68,0x01},
{0xEF84,0xBA,0x01},
{0xEF85,0x93,0x01},
{0xEF86,0x1B,0x01},
{0xEF87,0xBC,0x01},
{0xEF88,0x0C,0x01},
{0xEF89,0x65,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x17,0x01},
{0xEF8C,0x19,0x01},
{0xEF8D,0x49,0x01},
{0xEF8E,0x51,0x01},
{0xEF8F,0xF6,0x01},
{0xEF90,0xE2,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD5,0x01},
{0xEF93,0x98,0x01},
{0xEF94,0xC5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0B,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x64,0x01},
{0xEF9B,0x72,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD6,0x01},
{0xEF9E,0xA8,0x01},
{0xEF9F,0xE6,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x30,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x22,0x01},
{0xEFA7,0x93,0x01},
{0xEFA8,0xB4,0x01},
{0xEFA9,0xC8,0x01},
{0xEFAA,0xA6,0x01},
{0xEFAB,0x37,0x01},
{0xEFAC,0x7C,0x01},
{0xEFAD,0x29,0x01},
{0xEFAE,0x8A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x62,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA4,0x01},
{0xEFB4,0xF8,0x01},
{0xEFB5,0x65,0x01},
{0xEFB6,0x38,0x01},
{0xEFB7,0xDB,0x01},
{0xEFB8,0x11,0x01},
{0xEFB9,0x0D,0x01},
{0xEFBA,0x5C,0x01},
{0xEFBB,0xA0,0x01},
{0xEFBC,0x72,0x01},
{0xEFBD,0x94,0x01},
{0xEFBE,0xA9,0x01},
{0xEFBF,0xD0,0x01},
{0xEFC0,0x05,0x01},
{0xEFC1,0x35,0x01},
{0xEFC2,0xE5,0x01},
{0xEFC3,0x11,0x01},
{0xEFC4,0xD0,0x01},
{0xEFC5,0x74,0x01},
{0xEFC6,0x52,0x01},
{0xEFC7,0x03,0x01},
{0xEFC8,0x19,0x01},
{0xEFC9,0xC3,0x01},
{0xEFCA,0x48,0x01},
{0xEFCB,0xC6,0x01},
{0xEFCC,0x35,0x01},
{0xEFCD,0xD7,0x01},
{0xEFCE,0x41,0x01},
{0xEFCF,0x10,0x01},
{0xEFD0,0x88,0x01},
{0xEFD1,0x06,0x01},
{0xEFD2,0x54,0x01},
{0xEFD3,0x9E,0x01},
{0xEFD4,0xE9,0x01},
{0xEFD5,0x30,0x01},
{0xEFD6,0xC7,0x01},
{0xEFD7,0x3A,0x01},
{0xEFD8,0xEA,0x01},
{0xEFD9,0x41,0x01},
{0xEFDA,0x50,0x01},
{0xEFDB,0x8A,0x01},
{0xEFDC,0x4E,0x01},
{0xEFDD,0xB4,0x01},
{0xEFDE,0x22,0x01},
{0xEFDF,0x10,0x01},
{0xEFE0,0x51,0x01},
{0xEFE1,0x48,0x01},
{0xEFE2,0x42,0x01},
{0xEFE3,0x19,0x01},
{0xEFE4,0x2A,0x01},
{0xEFE5,0x91,0x01},
{0xEFE6,0x8B,0x01},
{0xEFE7,0x5A,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},



//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x21,0x01},
{0xEFEF,0xAA,0x01},
{0xEFF0,0xD1,0x01},
{0xEFF1,0x8B,0x01},
{0xEFF2,0x4A,0x01},
{0xEFF3,0x64,0x01},
{0xEFF4,0x22,0x01},
{0xEFF5,0x15,0x01},
{0xEFF6,0xD9,0x01},
{0xEFF7,0x28,0x01},
{0xEFF8,0x47,0x01},
{0xEFF9,0x26,0x01},
{0xEFFA,0xA2,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7F,0x01},
{0xEFFD,0xC6,0x01},
{0xEFFE,0x23,0x01},
{0xEFFF,0x9D,0x01},
{0xF000,0xE6,0x01},
{0xF001,0x54,0x01},
{0xF002,0xE7,0x01},
{0xF003,0x3C,0x01},
{0xF004,0x00,0x01},
{0xF005,0xBA,0x01},
{0xF006,0xD0,0x01},
{0xF007,0x7C,0x01},
{0xF008,0x98,0x01},
{0xF009,0xA3,0x01},
{0xF00A,0x9A,0x01},
{0xF00B,0xC7,0x01},
{0xF00C,0x18,0x01},
{0xF00D,0x06,0x01},
{0xF00E,0x32,0x01},
{0xF00F,0xAA,0x01},
{0xF010,0x81,0x01},
{0xF011,0x8E,0x01},
{0xF012,0x80,0x01},
{0xF013,0xA4,0x01},
{0xF014,0xE3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB7,0x01},
{0xF017,0x3C,0x01},
{0xF018,0xC5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x51,0x01},
{0xF01B,0x89,0x01},
{0xF01C,0x8B,0x01},
{0xF01D,0x69,0x01},
{0xF01E,0xC4,0x01},
{0xF01F,0x93,0x01},
{0xF020,0x9B,0x01},
{0xF021,0xBC,0x01},
{0xF022,0x10,0x01},
{0xF023,0x65,0x01},
{0xF024,0x24,0x01},
{0xF025,0x18,0x01},
{0xF026,0x21,0x01},
{0xF027,0x09,0x01},
{0xF028,0x52,0x01},
{0xF029,0x00,0x01},
{0xF02A,0x33,0x01},
{0xF02B,0x9C,0x01},
{0xF02C,0xD5,0x01},
{0xF02D,0x9C,0x01},
{0xF02E,0xE5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x88,0x01},
{0xF033,0x43,0x01},
{0xF034,0x68,0x01},
{0xF035,0xA2,0x01},
{0xF036,0x16,0x01},
{0xF037,0xD9,0x01},
{0xF038,0xAC,0x01},
{0xF039,0x06,0x01},
{0xF03A,0x2D,0x01},
{0xF03B,0x30,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x93,0x01},
{0xF042,0xB6,0x01},
{0xF043,0xDC,0x01},
{0xF044,0xC6,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7E,0x01},
{0xF047,0x31,0x01},
{0xF048,0xCA,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x92,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0x08,0x01},
{0xF04F,0x26,0x01},
{0xF050,0x39,0x01},
{0xF051,0xDC,0x01},
{0xF052,0x19,0x01},
{0xF053,0x8D,0x01},
{0xF054,0x5C,0x01},
{0xF055,0xA4,0x01},
{0xF056,0x92,0x01},
{0xF057,0x14,0x01},
{0xF058,0xAB,0x01},
{0xF059,0xE0,0x01},
{0xF05A,0xA5,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xEA,0x01},
{0xF05D,0x09,0x01},
{0xF05E,0x10,0x01},
{0xF05F,0x75,0x01},
{0xF060,0x58,0x01},
{0xF061,0x33,0x01},
{0xF062,0x99,0x01},
{0xF063,0xC4,0x01},
{0xF064,0x58,0x01},
{0xF065,0x66,0x01},
{0xF066,0x36,0x01},
{0xF067,0xDB,0x01},
{0xF068,0x61,0x01},
{0xF069,0xD0,0x01},
{0xF06A,0x86,0x01},
{0xF06B,0x02,0x01},
{0xF06C,0x64,0x01},
{0xF06D,0x1E,0x01},
{0xF06E,0xEB,0x01},
{0xF06F,0x40,0x01},
{0xF070,0x47,0x01},
{0xF071,0x3B,0x01},
{0xF072,0xEE,0x01},
{0xF073,0x51,0x01},
{0xF074,0x10,0x01},
{0xF075,0x8A,0x01},
{0xF076,0x36,0x01},
{0xF077,0x54,0x01},
{0xF078,0x22,0x01},
{0xF079,0x0E,0x01},
{0xF07A,0x51,0x01},
{0xF07B,0x88,0x01},
{0xF07C,0x42,0x01},
{0xF07D,0x1A,0x01},
{0xF07E,0x2A,0x01},
{0xF07F,0x11,0x01},
{0xF080,0x8B,0x01},
{0xF081,0x48,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000B,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFD,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t SR300PC20_Flash_ON[] =
{
//Flash_ON_SET
{0x00B7,0x15,0x01},    // LED_ON
{0x0016,0x10,0x01},    // GPIO_FUNCSEL
{0x0181,0x05,0x01},    // CAP_HALF_AE_CTRL
{0x01AE,0x01,0x01},    // HALF_AWB_CTRL
{0x6223,0x01,0x01},    // INIT_GAINS
{0x6226,0x01,0x01},    // ATW_GAINS_IN_NR
{0x6227,0x01,0x01},    // ATW_GAINS_IN
{0x6228,0x01,0x01},    // ATW_GAINS_OUT_NR
{0x6229,0x01,0x01},    // ATW_GAINS_OUT
{0x5E3D,0x0F,0x01},    // FASTMOVE_TIMEOUT
{0x5E32,0x0F,0x01},    // AESPEED_FAST
{0x5E2E,0x1A,0x01},    // AEIINDEADBAND
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x01AF,0x01,0x01},    // CAP_AWB_CTRL
{0x6224,0x01,0x01},    // ATW_DELAY
//AWB boundary set
{0x6400,0x00,0x01},    // INFRM_LEFT00 :
{0x6401,0x00,0x01},    // INFRM_LEFT01 :
{0x6402,0x00,0x01},    // INFRM_LEFT02 :
{0x6403,0x00,0x01},    // INFRM_LEFT03 :
{0x6404,0x00,0x01},    // INFRM_LEFT04 :
{0x6405,0x00,0x01},    // INFRM_LEFT05 :
{0x6406,0x00,0x01},    // INFRM_LEFT06 :
{0x6407,0x00,0x01},    // INFRM_LEFT07 :
{0x6408,0x00,0x01},    // INFRM_LEFT08 :
{0x6409,0x00,0x01},    // INFRM_LEFT09 :
{0x640A,0x00,0x01},    // INFRM_LEFT10 :
{0x640B,0x00,0x01},    // INFRM_LEFT11 :
{0x640C,0x00,0x01},    // INFRM_LEFT12 :
{0x640D,0x00,0x01},    // INFRM_LEFT13 :
{0x640E,0x00,0x01},    // INFRM_LEFT14 :
{0x640F,0x00,0x01},    // INFRM_LEFT15 :
{0x6410,0x00,0x01},    // INFRM_LEFT16 :
{0x6411,0x00,0x01},    // INFRM_LEFT17 :
{0x6412,0x00,0x01},    // INFRM_LEFT18 :
{0x6413,0x00,0x01},    // INFRM_LEFT19 :
{0x6414,0x00,0x01},    // INFRM_LEFT20 :
{0x6415,0x00,0x01},    // INFRM_LEFT21 :
{0x6416,0x00,0x01},    // INFRM_LEFT22 :
{0x6417,0x00,0x01},    // INFRM_LEFT23 :
{0x6418,0x00,0x01},    // INFRM_LEFT24 :
{0x6419,0x00,0x01},    // INFRM_LEFT25 :
{0x641A,0x00,0x01},    // INFRM_LEFT26 :
{0x641B,0x00,0x01},    // INFRM_LEFT27 :
{0x641C,0x00,0x01},    // INFRM_LEFT28 :
{0x641D,0x00,0x01},    // INFRM_LEFT29 :
{0x641E,0x00,0x01},    // INFRM_LEFT30 :
{0x641F,0x00,0x01},    // INFRM_LEFT31 :
{0x6420,0x00,0x01},    // INFRM_LEFT32 :
{0x6421,0x00,0x01},    // INFRM_LEFT33 :
{0x6422,0x00,0x01},    // INFRM_LEFT34 :
{0x6423,0x00,0x01},    // INFRM_LEFT35 :
{0x6424,0x00,0x01},    // INFRM_LEFT36 :
{0x6425,0x00,0x01},    // INFRM_LEFT37 :
{0x6426,0xFF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xFF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xFF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xFF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xFF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xFF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xFF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xFF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xFF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xFF,0x01},    // INFRM_RIGHT09 :
{0x6430,0xFF,0x01},    // INFRM_RIGHT10 :
{0x6431,0xFF,0x01},    // INFRM_RIGHT11 :
{0x6432,0xFF,0x01},    // INFRM_RIGHT12 :
{0x6433,0xFF,0x01},    // INFRM_RIGHT13 :
{0x6434,0xFF,0x01},    // INFRM_RIGHT14 :
{0x6435,0xFF,0x01},    // INFRM_RIGHT15 :
{0x6436,0xFF,0x01},    // INFRM_RIGHT16 :
{0x6437,0xFF,0x01},    // INFRM_RIGHT17 :
{0x6438,0xFF,0x01},    // INFRM_RIGHT18 :
{0x6439,0xFF,0x01},    // INFRM_RIGHT19 :
{0x643A,0xFF,0x01},    // INFRM_RIGHT20 :
{0x643B,0xFF,0x01},    // INFRM_RIGHT21 :
{0x643C,0xFF,0x01},    // INFRM_RIGHT22 :
{0x643D,0xFF,0x01},    // INFRM_RIGHT23 :
{0x643E,0xFF,0x01},    // INFRM_RIGHT24 :
{0x643F,0xFF,0x01},    // INFRM_RIGHT25 :
{0x6440,0xFF,0x01},    // INFRM_RIGHT26 :
{0x6441,0xFF,0x01},    // INFRM_RIGHT27 :
{0x6442,0xFF,0x01},    // INFRM_RIGHT28 :
{0x6443,0xFF,0x01},    // INFRM_RIGHT29 :
{0x6444,0xFF,0x01},    // INFRM_RIGHT30 :
{0x6445,0xFF,0x01},    // INFRM_RIGHT31 :
{0x6446,0xFF,0x01},    // INFRM_RIGHT32 :
{0x6447,0xFF,0x01},    // INFRM_RIGHT33 :
{0x6448,0xFF,0x01},    // INFRM_RIGHT34 :
{0x6449,0xFF,0x01},    // INFRM_RIGHT35 :
{0x644A,0xFF,0x01},    // INFRM_RIGHT36 :
{0x644B,0xFF,0x01},    // INFRM_RIGHT37 :
{0x644C,0x25C2,0x02},    // INFRM_TOP :
{0x644E,0x0348,0x02},    // INFRM_BOTM :
{0x6450,0x1D,0x01},    // INFRM_FLTOP :
{0x6451,0x00,0x01},    // INFRM_FLBOTM :
//halfrelease_mode value
{0x00B1,0x01,0x01},    //AF_RESTART_F
{0x00B3,0x00,0x01},    //AFMODE_HREL :
{0xFFFF,0x21,0x01},//$wait, 33
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t SR300PC20_Flash_OFF[] =
{
//Flash_OFF_RESET
{0x00B7,0x00,0x01},    // LED_ON
{0x0016,0x10,0x01},    // GPIO_FUNCSEL
{0x0181,0x00,0x01},    // CAP_HALF_AE_CTRL
{0x01AE,0x00,0x01},    // HALF_AWB_CTRL
{0x6223,0x04,0x01},    // INIT_GAINS
{0x6226,0x08,0x01},    // ATW_GAINS_IN_NR
{0x6227,0x04,0x01},    // ATW_GAINS_IN
{0x6228,0x08,0x01},    // ATW_GAINS_OUT_NR
{0x6229,0x04,0x01},    // ATW_GAINS_OUT
{0x5E3D,0x0A,0x01},    // FASTMOVE_TIMEOUT
{0x5E32,0x0F,0x01},    // AESPEED_FAST
{0x5E2E,0x1A,0x01},    // AEIINDEADBAND
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x01AF,0x00,0x01},    // CAP_AWB_CTRL
{0x6224,0x04,0x01},    // ATW_DELAY
//AWB boundary reset
{0x6400,0xAA,0x01},    // INFRM_LEFT00 :
{0x6401,0xAA,0x01},    // INFRM_LEFT01 :
{0x6402,0xAA,0x01},    // INFRM_LEFT02 :
{0x6403,0xAA,0x01},    // INFRM_LEFT03 :
{0x6404,0xAA,0x01},    // INFRM_LEFT04 :
{0x6405,0xAA,0x01},    // INFRM_LEFT05 :
{0x6406,0xAA,0x01},    // INFRM_LEFT06 :
{0x6407,0xAA,0x01},    // INFRM_LEFT07 :
{0x6408,0xAA,0x01},    // INFRM_LEFT08 :
{0x6409,0xAE,0x01},    // INFRM_LEFT09 :
{0x640A,0xA0,0x01},    // INFRM_LEFT10 :
{0x640B,0x8C,0x01},    // INFRM_LEFT11 :
{0x640C,0x72,0x01},    // INFRM_LEFT12 :
{0x640D,0x64,0x01},    // INFRM_LEFT13 :
{0x640E,0x5A,0x01},    // INFRM_LEFT14 :
{0x640F,0x52,0x01},    // INFRM_LEFT15 :
{0x6410,0x48,0x01},    // INFRM_LEFT16 :
{0x6411,0x43,0x01},    // INFRM_LEFT17 :
{0x6412,0x3D,0x01},    // INFRM_LEFT18 :
{0x6413,0x37,0x01},    // INFRM_LEFT19 :
{0x6414,0x33,0x01},    // INFRM_LEFT20 :
{0x6415,0x30,0x01},    // INFRM_LEFT21 :
{0x6416,0x2E,0x01},    // INFRM_LEFT22 :
{0x6417,0x2B,0x01},    // INFRM_LEFT23 :
{0x6418,0x28,0x01},    // INFRM_LEFT24 :
{0x6419,0x26,0x01},    // INFRM_LEFT25 :
{0x641A,0x24,0x01},    // INFRM_LEFT26 :
{0x641B,0x23,0x01},    // INFRM_LEFT27 :
{0x641C,0x22,0x01},    // INFRM_LEFT28 :
{0x641D,0x22,0x01},    // INFRM_LEFT29 :
{0x641E,0x21,0x01},    // INFRM_LEFT30 :
{0x641F,0x20,0x01},    // INFRM_LEFT31 :
{0x6420,0x1D,0x01},    // INFRM_LEFT32 :
{0x6421,0x1A,0x01},    // INFRM_LEFT33 :
{0x6422,0x18,0x01},    // INFRM_LEFT34 :
{0x6423,0x17,0x01},    // INFRM_LEFT35 :
{0x6424,0x16,0x01},    // INFRM_LEFT36 :
{0x6425,0x17,0x01},    // INFRM_LEFT37 :
{0x6426,0xAF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xAF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xAF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xAF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xAF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xAF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xAF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xAF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xAF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xAA,0x01},    // INFRM_RIGHT09 :
{0x6430,0xB2,0x01},    // INFRM_RIGHT10 :
{0x6431,0xB4,0x01},    // INFRM_RIGHT11 :
{0x6432,0xB6,0x01},    // INFRM_RIGHT12 :
{0x6433,0xB4,0x01},    // INFRM_RIGHT13 :
{0x6434,0x9B,0x01},    // INFRM_RIGHT14 :
{0x6435,0x8E,0x01},    // INFRM_RIGHT15 :
{0x6436,0x84,0x01},    // INFRM_RIGHT16 :
{0x6437,0x7A,0x01},    // INFRM_RIGHT17 :
{0x6438,0x72,0x01},    // INFRM_RIGHT18 :
{0x6439,0x6A,0x01},    // INFRM_RIGHT19 :
{0x643A,0x63,0x01},    // INFRM_RIGHT20 :
{0x643B,0x5E,0x01},    // INFRM_RIGHT21 :
{0x643C,0x58,0x01},    // INFRM_RIGHT22 :
{0x643D,0x53,0x01},    // INFRM_RIGHT23 :
{0x643E,0x4E,0x01},    // INFRM_RIGHT24 :
{0x643F,0x4A,0x01},    // INFRM_RIGHT25 :
{0x6440,0x46,0x01},    // INFRM_RIGHT26 :
{0x6441,0x42,0x01},    // INFRM_RIGHT27 :
{0x6442,0x3F,0x01},    // INFRM_RIGHT28 :
{0x6443,0x3C,0x01},    // INFRM_RIGHT29 :
{0x6444,0x3A,0x01},    // INFRM_RIGHT30 :
{0x6445,0x38,0x01},    // INFRM_RIGHT31 :
{0x6446,0x37,0x01},    // INFRM_RIGHT32 :
{0x6447,0x35,0x01},    // INFRM_RIGHT33 :
{0x6448,0x33,0x01},    // INFRM_RIGHT34 :
{0x6449,0x32,0x01},    // INFRM_RIGHT35 :
{0x644A,0x32,0x01},    // INFRM_RIGHT36 :
{0x644B,0x32,0x01},    // INFRM_RIGHT37 :
{0x644C,0x24FA,0x02},    // INFRM_TOP :
{0x644E,0x0940,0x02},    // INFRM_BOTM :
{0x6450,0x19,0x01},    // INFRM_FLTOP :
{0x6451,0x10,0x01},    // INFRM_FLBOTM :
////Flash_ON_RESET
{0x0308,0x11,0x01},    // AELINE_MONI_SN1_2 :
{0x0309,0x13,0x01},    // AELINE_MONI_SN3_4 :
{0x030B,0x41,0x01},    // AELINE_MONI_SN7_8 :
{0x030D,0x11,0x01},    // AELINE_MONI_SN11_12 :
{0x030E,0x11,0x01},    // AELINE_HALF_SN1_2 :
{0x030F,0x13,0x01},    // AELINE_HALF_SN3_4 :
{0x0311,0x41,0x01},    // AELINE_HALF_SN7_8 :
{0x0313,0x11,0x01},    // AELINE_HALF_SN11_12 :
{0x0314,0x11,0x01},    // AELINE_HALF_AFEND_SN1_2 :
{0x0315,0x13,0x01},    // AELINE_HALF_AFEND_SN3_4 :
{0x0317,0x41,0x01},    // AELINE_HALF_AFEND_SN7_8 :
{0x0319,0x11,0x01},    // AELINE_HALF_AFEND_SN11_12 :
{0x031A,0x00,0x01},    // AELINE_CAP_SN1_2 :
{0x031B,0x03,0x01},    // AELINE_CAP_SN3_4 :
{0x031D,0x50,0x01},    // AELINE_CAP_SN7_8 :
{0x031F,0x00,0x01},    // AELINE_CAP_SN11_12 :
{0x0294,0x00,0x01},    // AE_SN1
{0x0297,0x00,0x01},    // AE_SN4
{0x029A,0x00,0x01},    // AE_SN7
{0x029E,0x00,0x01},    // AE_SN11
};

static const isx012_regset_t SR300PC20_Flash_AELINE[] =
{
//Flash_ON_SET
{0x0308,0x12,0x01},    // AELINE_MONI_SN1_2 :
{0x0309,0x23,0x01},    // AELINE_MONI_SN3_4 :
{0x030B,0x42,0x01},    // AELINE_MONI_SN7_8 :
{0x030D,0x12,0x01},    // AELINE_MONI_SN11_12 :
{0x030E,0x12,0x01},    // AELINE_HALF_SN1_2 :
{0x030F,0x23,0x01},    // AELINE_HALF_SN3_4 :
{0x0311,0x42,0x01},    // AELINE_HALF_SN7_8 :
{0x0313,0x12,0x01},    // AELINE_HALF_SN11_12 :
{0x0314,0x12,0x01},    // AELINE_HALF_AFEND_SN1_2 :
{0x0315,0x23,0x01},    // AELINE_HALF_AFEND_SN3_4 :
{0x0317,0x42,0x01},    // AELINE_HALF_AFEND_SN7_8 :
{0x0319,0x12,0x01},    // AELINE_HALF_AFEND_SN11_12 :
{0x031A,0x02,0x01},    // AELINE_CAP_SN1_2 :
{0x031B,0x23,0x01},    // AELINE_CAP_SN3_4 :
{0x031D,0x52,0x01},    // AELINE_CAP_SN7_8 :
{0x031F,0x02,0x01},    // AELINE_CAP_SN11_12 :
};

static const isx012_regset_t SR300PC20_ae_manual_mode[] =
{
{0x0294,0x02,0x01}, /* AE_SN1 */
{0x0297,0x02,0x01}, /* AE_SN4 */
{0x029A,0x02,0x01}, /* AE_SN7 */
{0x029E,0x02,0x01}, /* AE_SN11 */
{0xFFFF,0x42,0x01}, /* $wait, 66 */
};

static const isx012_regset_t SR300PC20_flash_fast_ae_awb[] =
{
{0x5E32,0x0A,0x01},
{0x5E3D,0x05,0x01}, /* Don't fix me. 0x05 */

{0x0181,0x01,0x01},    // CAP_HALF_AE_CTRL
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x03,0x01},    //AFMODE_HREL : AF OFF
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t SR300PC20_Lowlux_Night_Reset[] =
{
{0x039D,0x00,0x01},    //UIHUE_TYPE3 :
{0x03A0,0x80,0x01},    //UISATURATION_TYPE3 :
{0x982A,0xFFEC,0x02},	 // CS_CBLLEV_A :
{0x9830,0xFFEC,0x02},	 // CS_CRLLEV_A :
{0x9805,0x0A,0x01},    // CS_SLP_C_A :
{0x6A9E,0x15C0,0x02},	 //HMAX_1_1(0x6A9E)=0x15C0
{0x00AC,0x00,0x01},    //
{0x660E,0x5A,0x01},    // AF_HBPF_PEAK_OPD_TH_MIN
{0x6610,0x5A,0x01},    // AF_HBPF_PEAK_OPD_TH_MAX
{0x664A,0x04,0x01},    // AF_DROPN_ON_PEAK_DETECT :
{0x6640,0x02,0x01},    // AF_DROPN_ON_PEAK_DETECT_SECOND :
{0x0289,0x20,0x01},    //AWB_SN8
};

#endif /* __SR300PC20_REGS_H__ */
