/*
 * Driver for SR200PC20 2M ISP from Samsung
 *
 * Copyright (C) 2011,
 * DongSeong Lim<dongseong.lim@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef __SR200PC200_REGS_P2_H__
#define __SR200PC200_REGS_P2_H__

#include <linux/types.h>

/*
 * sr200pc20 register configuration for combinations of initialization
 */
/* 2M parallel setting-common from PARTRON */
/*******************************************************
* Name		: SR200PC20 Initial Setfile
* PLL mode	: MCLK=24MHz / SYSCLK=28MHz / PCLK=48MHz
* FPS		: VGA 7.5~15fps / UXGA 7.5fps / recording 25fps
* Made by	: emine
* Date		: 2011.09.21
* History	:
*******************************************************/
//==========================================================
//	CAMERA INITIAL for Self Camera(Variable Frame)
//==========================================================
regs_short_t front_init_50hz_regs[] = {

/////// Start Sleep ///////
{0x01, 0xf9}, //sleep on
{0x08, 0x0f}, //Hi-Z on
{0x01, 0xf8}, //sleep off

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x03}, //PLL On
{0x0e, 0x73}, //PLLx2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x00}, //PLL off
{0x01, 0xf9}, //sleep on
{0x08, 0x00}, //Hi-Z off

{0x01, 0xfb},
{0x01, 0xf9},

/////// PAGE 20 ///////
{0x03, 0x20}, //page 20
{0x10, 0x1c}, //AE off 50hz

/////// PAGE 22 ///////
{0x03, 0x22}, //page 22
{0x10, 0x69}, //AWB off


//Initial Start
/////// PAGE 0 START ///////
{0x03, 0x00},
{0x10, 0x19}, //Vsync Active High B:[3]
#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x90},
#else
{0x11, 0x92},
#endif
{0x12, 0x00}, //Pclk Falling Edge B:[2]

{0x0b, 0xaa}, //ESD Check Register
{0x0c, 0xaa}, //ESD Check Register
{0x0d, 0xaa}, //ESD Check Register

{0x20, 0x00},
{0x21, 0x02},  //modify 20110929 0x04->0x02
{0x22, 0x00},
{0x23, 0x0a}, //modify 20110929 0x14->0x0a

{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},

{0x28, 0x0c},
{0x29, 0x04},
{0x2a, 0x02},
{0x2b, 0x04},
{0x2c, 0x06},
{0x2d, 0x02},

{0x40, 0x01}, //Hblank_360
{0x41, 0x68},
{0x42, 0x00},
{0x43, 0x58}, //Flick Stop 50hz

{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},

//BLC
{0x80, 0x2e},
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x0c}, //BLC_TIME_TH_ON
{0x91, 0x0c}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},

//Dark BLC
{0xa0, 0x00},
{0xa2, 0x00},
{0xa4, 0x00},
{0xa6, 0x00},

//Normal BLC
{0xa8, 0x43},
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},

//OutDoor  BLC
{0x99, 0x43},
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
/////// PAGE 0 END ///////

/////// PAGE 2 START ///////
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG//
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},

{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00},
{0x2f, 0x00},
{0x30, 0x05}, //For Hi-253 never no change 0x05

{0x50, 0x20},
{0x51, 0x03}, //20110826 ߰
{0x52, 0x01}, //0x03 --> 0x01
{0x53, 0xc1}, //20110818 ߰
{0x55, 0x1c},
{0x56, 0x11},
{0x5d, 0xa2},
{0x5e, 0x5a},

{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},

{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},

{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},

{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},

{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},

{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},

{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},

{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa},

{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},

{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x0c}, //DCDC_TIME_TH_ON
{0xd5, 0x0c}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},

{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},

/////// PAGE 2 END ///////

/////// PAGE 3 ///////
{0x03, 0x03},
{0x10, 0x10},
/////// PAGE 3 END ///////

/////// PAGE 10 START ///////
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},

{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x02}, //For Preview

{0x40, 0x80},
{0x41, 0x00},

{0x60, 0x6b},
{0x61, 0x7a}, //77
{0x62, 0x74}, //77
{0x63, 0x50}, // Double_AG 50->30
{0x64, 0x41},

{0x66, 0x42},
{0x67, 0x20},

{0x6a, 0x80}, //8a
{0x6b, 0x84}, //74
{0x6c, 0x7a}, //7e
{0x6d, 0x80}, //8e

/////// PAGE 11 START ///////
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, // Blue Max-Filter Delete
{0x13, 0xbb},

{0x26, 0x31}, // Double_AG 31->20
{0x27, 0x34}, // Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},

//Out2 D-LPF th
{0x30, 0x70},
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},

//Out1 D-LPF th
{0x36, 0x70},
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x20},
{0x3a, 0x1f},
{0x3b, 0x03},

//Indoor D-LPF th
{0x3c, 0x80},
{0x3d, 0x18},
{0x3e, 0x80},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},

//Dark1 D-LPF th
{0x42, 0x80},
{0x43, 0x18},
{0x44, 0x80},
{0x45, 0x0c},
{0x46, 0x09},
{0x47, 0x06},

//Dark2 D-LPF th
{0x48, 0x80},
{0x49, 0x18},
{0x4a, 0x80},
{0x4b, 0x0c},
{0x4c, 0x09},
{0x4d, 0x06},

//Dark3 D-LPF th
{0x4e, 0x80},
{0x4f, 0x18},
{0x50, 0x80},
{0x51, 0x0c},
{0x52, 0x09},
{0x53, 0x06},

{0x54, 0x11},
{0x55, 0x17},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},

{0x5a, 0x18},
{0x5b, 0x00},
{0x5c, 0x00},

{0x60, 0x3f},
{0x62, 0x60},
{0x70, 0x06},
/////// PAGE 11 END ///////

/////// PAGE 12 START ///////
{0x03, 0x12},
{0x20, 0x00},
{0x21, 0x00},

{0x25, 0x00}, //0x30

{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},

{0x30, 0x50},
{0x31, 0x18},
{0x32, 0x32},
{0x33, 0x40},
{0x34, 0x50},
{0x35, 0x70},
{0x36, 0xa0},

//Out2 th
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},

//Out1 th
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xb0},
{0x49, 0xb0},
{0x4a, 0x90},
{0x4b, 0x80},

//Indoor th
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0x90},
{0x4f, 0x90},
{0x50, 0xa0},
{0x51, 0x80},

//Dark1 th
{0x52, 0xb0},
{0x53, 0x40},
{0x54, 0x90},
{0x55, 0x90},
{0x56, 0xa0},
{0x57, 0x78},

//Dark2 th
{0x58, 0xb0},
{0x59, 0x40},
{0x5a, 0x90},
{0x5b, 0x90},
{0x5c, 0xa0},
{0x5d, 0x78},

//Dark3 th
{0x5e, 0xb0},
{0x5f, 0x40},
{0x60, 0x90},
{0x61, 0x90},
{0x62, 0xa0},
{0x63, 0x78},

{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register

{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register

{0x74, 0x25},
{0x75, 0x15},

{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x00}, //For Preview

//Dont Touch register
{0xD0, 0x0c},
{0xD1, 0x80},

//only for Preview DPC 
{0xD2, 0x17},

{0xD3, 0x00},
{0xD4, 0x00},

//only for Preview DPC 
{0xd5, 0x0f},

{0xD6, 0xff},

//only for Preview DPC 
{0xd7, 0xff},

//End
{0x3b, 0x06},
{0x3c, 0x06},

//Dont Touch register
{0xc5, 0x30},//55->48
{0xc6, 0x2a},//48->40
/////// PAGE 12 END ///////

/////// PAGE 13 START ///////
{0x03, 0x13},
//Edge
{0x10, 0xcb},
{0x11, 0x7b},
{0x12, 0x07},
{0x14, 0x00},

{0x20, 0x15},
{0x21, 0x13},
{0x22, 0x33},
{0x23, 0x05},
{0x24, 0x09},

{0x25, 0x0a},

{0x26, 0x18},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},

//Low clip th
{0x2b, 0x02},
{0x2c, 0x02},
{0x25, 0x06},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},

//Out2 Edge
{0x50, 0x10},
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0c},

//Out1 Edge
{0x56, 0x0f},
{0x57, 0x12},
{0x58, 0x12},
{0x59, 0x09},
{0x5a, 0x0c},
{0x5b, 0x0c},

//Indoor Edge
{0x5c, 0x0a},
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},

//Dark1 Edge
{0x62, 0x0a},
{0x63, 0x0b},
{0x64, 0x0a},
{0x65, 0x08},
{0x66, 0x09},
{0x67, 0x08},

//Dark2 Edge
{0x68, 0x0a},
{0x69, 0x0b},
{0x6a, 0x0a},
{0x6b, 0x08},
{0x6c, 0x09},
{0x6d, 0x08},

//Dark3 Edge
{0x6e, 0x0a},
{0x6f, 0x0b},
{0x70, 0x0a},
{0x71, 0x08},
{0x72, 0x09},
{0x73, 0x08},

//2DY
{0x80, 0x00},
{0x81, 0x1f},
{0x82, 0x05},
{0x83, 0x31},

{0x90, 0x05},
{0x91, 0x05},
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x03},
{0x95, 0x14},
{0x97, 0x20},
{0x99, 0x20},

{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x05},
{0xa5, 0x05},
{0xa6, 0x07},
{0xa7, 0x08},
{0xa8, 0x07},
{0xa9, 0x08},
{0xaa, 0x07},
{0xab, 0x08},

//Out2
{0xb0, 0x22},
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},

//Out1
{0xb6, 0x22},
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},

//Indoor
{0xbc, 0x25},
{0xbd, 0x2a},
{0xbe, 0x27},
{0xbf, 0x25},
{0xc0, 0x2a},
{0xc1, 0x27},

//Dark1
{0xc2, 0x1e},
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},

//Dark2
{0xc8, 0x18},
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},

//Dark3
{0xce, 0x18},
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
/////// PAGE 13 END ///////

/////// PAGE 14 START ///////
{0x03, 0x14},
{0x10, 0x11},

{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY

{0x20, 0x80}, //X
{0x21, 0x80}, //Y

{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},

{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},

{0x40, 0x3e},
{0x50, 0x28}, //2d
{0x60, 0x24}, //26
{0x70, 0x28}, //2d
/////// PAGE 14 END ///////

/////// PAGE 15 START ///////
{0x03, 0x15},
{0x10, 0x0f},

//Rstep H 16
//Rstep L 14
{0x14, 0x46}, //CMCOFSGH
{0x15, 0x36}, //CMCOFSGM
{0x16, 0x26}, //CMCOFSGL
{0x17, 0x2f}, //CMC SIGN

//CMC
{0x30, 0x8f},
{0x31, 0x59},
{0x32, 0x0a},
{0x33, 0x15},
{0x34, 0x5b},
{0x35, 0x06},
{0x36, 0x07},
{0x37, 0x40},
{0x38, 0x87}, //86

//CMC OFS
{0x40, 0x94},
{0x41, 0x20},
{0x42, 0x89},
{0x43, 0x84},
{0x44, 0x03},
{0x45, 0x01},
{0x46, 0x88},
{0x47, 0x9c},
{0x48, 0x28},

//CMC POFS
{0x50, 0x02},
{0x51, 0x82},
{0x52, 0x00},
{0x53, 0x07},
{0x54, 0x11},
{0x55, 0x98},
{0x56, 0x00},
{0x57, 0x0b},
{0x58, 0x8b},

{0x80, 0x03},
{0x85, 0x40},
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
/////// PAGE 15 END ///////

/////// PAGE 16 START ///////
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e},// Double_AG 5e->37
{0x19, 0x5d},// Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},

//GMA Default
{0x30, 0x00},
{0x31, 0x08},
{0x32, 0x1c},
{0x33, 0x32},
{0x34, 0x54},
{0x35, 0x70},
{0x36, 0x87},
{0x37, 0x9a},
{0x38, 0xaa},
{0x39, 0xb9},
{0x3a, 0xc4},
{0x3b, 0xcf},
{0x3c, 0xd8},
{0x3d, 0xe0},
{0x3e, 0xe9},
{0x3f, 0xf0},
{0x40, 0xf7},
{0x41, 0xfc},
{0x42, 0xff},

{0x50, 0x00},
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x5a},
{0x55, 0x75},
{0x56, 0x8d},
{0x57, 0xa1},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc9},
{0x5b, 0xd2},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},

{0x70, 0x00},
{0x71, 0x0b},
{0x72, 0x1a},
{0x73, 0x37},
{0x74, 0x58},
{0x75, 0x70},
{0x76, 0x86},
{0x77, 0x99},
{0x78, 0xa9},
{0x79, 0xb7},
{0x7a, 0xc3},
{0x7b, 0xcf},
{0x7c, 0xd9},
{0x7d, 0xe1},
{0x7e, 0xe8},
{0x7f, 0xef},
{0x80, 0xf4},
{0x81, 0xfa},
{0x82, 0xff},
/////// PAGE 16 END ///////

/////// PAGE 17 START ///////
{0x03, 0x17},
{0x10, 0xf7},
/////// PAGE 17 END ///////

/////// PAGE 20 START ///////
{0x03, 0x20},
{0x11, 0x1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x05},
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},

{0x28, 0xef},
{0x29, 0x0d}, //20100305 ad->0d
{0x2a, 0xff},
{0x2b, 0xf4},

{0x2c, 0xc2},
{0x2d, 0xff},
{0x2e, 0x33},
{0x30, 0xf8},
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x22},
{0x3a, 0xde},
{0x3b, 0x22},
{0x3c, 0xde},

{0x50, 0x45},
{0x51, 0x88},

{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},

{0x60, 0xaa},
{0x61, 0xaa},
{0x62, 0xaa},
{0x63, 0xaa},
{0x64, 0xaa},
{0x65, 0xaa},
{0x66, 0xab},
{0x67, 0xEa},
{0x68, 0xab},
{0x69, 0xEa},
{0x6a, 0xaa},
{0x6b, 0xaa},
{0x6c, 0xaa},
{0x6d, 0xaa},
{0x6e, 0xaa},
{0x6f, 0xaa},

{0x70, 0x70}, //6c
{0x71, 0x82}, //82(+8)

{0x76, 0x43},
{0x77, 0x02},
{0x78, 0x24}, //24
{0x79, 0x48}, // Y Target 70 => 25, 72 => 26 //
{0x7a, 0x23}, //23
{0x7b, 0x22}, //22
{0x7d, 0x23},

{0x83, 0x01}, //EXP Normal 33.33 fps
{0x84, 0x5f},
{0x85, 0x90},

{0x86, 0x01}, //EXPMin 6000.00 fps
{0x87, 0xf4},

{0x88, 0x05}, //EXP Max 8.33 fps
{0x89, 0x7e},
{0x8a, 0x40},

{0x8B, 0x75}, //EXP100, PLLx2 Mclk24
{0x8C, 0x30},

{0x8D, 0x61}, //EXP120, PLLx2 Mclk24
{0x8E, 0xa8},

{0x98, 0x9d}, //9d
{0x99, 0x45},
{0x9a, 0x0d},
{0x9b, 0xde},

{0x9c, 0x17}, //EXP Limit 500.00 fps, PLLx2 Mclk24
{0x9d, 0x70},

{0x9e, 0x01}, //EXP Unit, PLLx2 Mclk24
{0x9f, 0xf4},

{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xe0},
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x32},
{0xbd, 0x32},

{0xc0, 0x10},
{0xc1, 0x2b},
{0xc2, 0x2b},
{0xc3, 0x2b},
{0xc4, 0x08},

{0xc8, 0x40},
{0xc9, 0x40},
/////// PAGE 20 END ///////

/////// PAGE 22 START ///////
{0x03, 0x22},
{0x10, 0xfd},
{0x11, 0x2e},
{0x19, 0x01}, // Low On //
{0x20, 0x10},
{0x21, 0x80},
{0x24, 0x01},
//{0x25, 0x00}, //7f New Lock Cond & New light stable

{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x11},
{0x39, 0x34},
{0x40, 0xf3},

{0x41, 0x32}, //33 //44
{0x42, 0x22}, //22 //43
{0x43, 0xf0}, //f6
{0x44, 0x44}, //44
{0x45, 0x44}, //33
{0x46, 0x00},
{0x50, 0xb2},
{0x51, 0x81},
{0x52, 0x98},

{0x80, 0x38},
{0x81, 0x20},
{0x82, 0x36}, //3a

{0x83, 0x5e}, //5e
{0x84, 0x21}, //24
{0x85, 0x51}, //54
{0x86, 0x20}, //24 //22

{0x87, 0x49},
{0x88, 0x39},
{0x89, 0x37}, //38
{0x8a, 0x29}, //2a

{0x8b, 0x41}, //47
{0x8c, 0x39},
{0x8d, 0x34},
{0x8e, 0x29}, //2c

{0x8f,	0x5c},
{0x90,	0x5b},
{0x91,	0x57},
{0x92,	0x4f},
{0x93,	0x43},
{0x94,	0x3e},
{0x95,	0x34},
{0x96,	0x2c},
{0x97, 0x23},
{0x98, 0x20},
{0x99, 0x1f},
{0x9a, 0x1f},

{0x9b, 0x77},
{0x9c, 0x66},
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},

{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},

{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, // 700fps
{0xa6, 0xcf},

{0xad, 0x40},
{0xae, 0x4a},

{0xaf, 0x28},  // low temp Rgain
{0xb0, 0x26},  // low temp Rgain

{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xb0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
/////// PAGE 22 END ///////

/////// PAGE 20 ///////
{0x03, 0x20},
{0x10, 0x9c}, //AE on 50hz

/////// PAGE 22 ///////
{0x03, 0x22},
{0x10, 0xe9},

/////// PAGE 0 ///////
{0x03, 0x00},
{0x0e, 0x03},
{0x0e, 0x73},

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00},
{0x01, 0xf8},

{0xff, 0x0a},//NEED Delay 100ms//

};

regs_short_t front_init_60hz_regs[] = {

/////// Start Sleep ///////
{0x01, 0xf9}, //sleep on
{0x08, 0x0f}, //Hi-Z on
{0x01, 0xf8}, //sleep off

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x03}, //PLL On
{0x0e, 0x73}, //PLLx2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x00}, //PLL off
{0x01, 0xf9}, //sleep on
{0x08, 0x00}, //Hi-Z off

{0x01, 0xfb},
{0x01, 0xf9},

/////// PAGE 20 ///////
{0x03, 0x20}, //page 20
{0x10, 0x0c}, //AE off 60hz

/////// PAGE 22 ///////
{0x03, 0x22}, //page 22
{0x10, 0x69}, //AWB off


//Initial Start
/////// PAGE 0 START ///////
{0x03, 0x00},
{0x10, 0x19}, //Vsync Active High B:[3]
#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x90},
#else
{0x11, 0x92},
#endif
{0x12, 0x00}, //Pclk Falling Edge B:[2]

{0x0b, 0xaa}, //ESD Check Register
{0x0c, 0xaa}, //ESD Check Register
{0x0d, 0xaa}, //ESD Check Register

{0x20, 0x00},
{0x21, 0x02},  //modify 20110929 0x04->0x02
{0x22, 0x00},
{0x23, 0x0a}, //modify 20110929 0x14->0x0a

{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},

{0x28, 0x0c},
{0x29, 0x04},
{0x2a, 0x02},
{0x2b, 0x04},
{0x2c, 0x06},
{0x2d, 0x02},

{0x40, 0x01}, //Hblank_360
{0x41, 0x68},
{0x42, 0x00},
{0x43, 0x44}, //Flick Stop 60hz

{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},

//BLC
{0x80, 0x2e},
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x0f}, //BLC_TIME_TH_ON
{0x91, 0x0f}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},

//Dark BLC
{0xa0, 0x00},
{0xa2, 0x00},
{0xa4, 0x00},
{0xa6, 0x00},

//Normal BLC
{0xa8, 0x43},
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},

//OutDoor  BLC
{0x99, 0x43},
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
/////// PAGE 0 END ///////

/////// PAGE 2 START ///////
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG//
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},

{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00},
{0x2f, 0x00},
{0x30, 0x05}, //For Hi-253 never no change 0x05

{0x50, 0x20},
{0x51, 0x03}, //20110826 ߰
{0x52, 0x01}, //0x03 --> 0x01
{0x53, 0xc1}, //20110818 ߰
{0x55, 0x1c},
{0x56, 0x11},
{0x5d, 0xa2},
{0x5e, 0x5a},

{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},

{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},

{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},

{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},

{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},

{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},

{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},

{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa},

{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},

{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x0f}, //DCDC_TIME_TH_ON
{0xd5, 0x0f}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},

{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},

/////// PAGE 2 END ///////

/////// PAGE 3 ///////
{0x03, 0x03},
{0x10, 0x10},
/////// PAGE 3 END ///////

/////// PAGE 10 START ///////
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},

{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x02}, //For Preview

{0x40, 0x80},
{0x41, 0x00},

{0x60, 0x6b},
{0x61, 0x7a}, //77
{0x62, 0x74}, //77
{0x63, 0x50}, // Double_AG 50->30
{0x64, 0x41},

{0x66, 0x42},
{0x67, 0x20},

{0x6a, 0x80}, //8a
{0x6b, 0x84}, //74
{0x6c, 0x7a}, //7e
{0x6d, 0x80}, //8e

/////// PAGE 11 START ///////
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, // Blue Max-Filter Delete
{0x13, 0xbb},

{0x26, 0x31}, // Double_AG 31->20
{0x27, 0x34}, // Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},

//Out2 D-LPF th
{0x30, 0x70},
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},

//Out1 D-LPF th
{0x36, 0x70},
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x20},
{0x3a, 0x1f},
{0x3b, 0x03},

//Indoor D-LPF th
{0x3c, 0x80},
{0x3d, 0x18},
{0x3e, 0x80},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},

//Dark1 D-LPF th
{0x42, 0x80},
{0x43, 0x18},
{0x44, 0x80},
{0x45, 0x0c},
{0x46, 0x09},
{0x47, 0x06},

//Dark2 D-LPF th
{0x48, 0x80},
{0x49, 0x18},
{0x4a, 0x80},
{0x4b, 0x0c},
{0x4c, 0x09},
{0x4d, 0x06},

//Dark3 D-LPF th
{0x4e, 0x80},
{0x4f, 0x18},
{0x50, 0x80},
{0x51, 0x0c},
{0x52, 0x09},
{0x53, 0x06},

{0x54, 0x11},
{0x55, 0x17},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},

{0x5a, 0x18},
{0x5b, 0x00},
{0x5c, 0x00},

{0x60, 0x3f},
{0x62, 0x60},
{0x70, 0x06},
/////// PAGE 11 END ///////

/////// PAGE 12 START ///////
{0x03, 0x12},
{0x20, 0x00},
{0x21, 0x00},

{0x25, 0x00}, //0x30

{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},

{0x30, 0x50},
{0x31, 0x18},
{0x32, 0x32},
{0x33, 0x40},
{0x34, 0x50},
{0x35, 0x70},
{0x36, 0xa0},

//Out2 th
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},

//Out1 th
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xb0},
{0x49, 0xb0},
{0x4a, 0x90},
{0x4b, 0x80},

//Indoor th
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0x90},
{0x4f, 0x90},
{0x50, 0xa0},
{0x51, 0x80},

//Dark1 th
{0x52, 0xb0},
{0x53, 0x40},
{0x54, 0x90},
{0x55, 0x90},
{0x56, 0xa0},
{0x57, 0x78},

//Dark2 th
{0x58, 0xb0},
{0x59, 0x40},
{0x5a, 0x90},
{0x5b, 0x90},
{0x5c, 0xa0},
{0x5d, 0x78},

//Dark3 th
{0x5e, 0xb0},
{0x5f, 0x40},
{0x60, 0x90},
{0x61, 0x90},
{0x62, 0xa0},
{0x63, 0x78},

{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register

{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register

{0x74, 0x25},
{0x75, 0x15},

{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x00}, //For Preview

//Dont Touch register
{0xD0, 0x0c},
{0xD1, 0x80},

//only for Preview DPC 
{0xD2, 0x17},

{0xD3, 0x00},
{0xD4, 0x00},

//only for Preview DPC 
{0xd5, 0x0f},

{0xD6, 0xff},

//only for Preview DPC 
{0xd7, 0xff},

//End
{0x3b, 0x06},
{0x3c, 0x06},

//Dont Touch register
{0xc5, 0x30},//55->48
{0xc6, 0x2a},//48->40
/////// PAGE 12 END ///////

/////// PAGE 13 START ///////
{0x03, 0x13},
//Edge
{0x10, 0xcb},
{0x11, 0x7b},
{0x12, 0x07},
{0x14, 0x00},

{0x20, 0x15},
{0x21, 0x13},
{0x22, 0x33},
{0x23, 0x05},
{0x24, 0x09},

{0x25, 0x0a},

{0x26, 0x18},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},

//Low clip th
{0x2b, 0x02},
{0x2c, 0x02},
{0x25, 0x06},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},

//Out2 Edge
{0x50, 0x10},
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0c},

//Out1 Edge
{0x56, 0x0f},
{0x57, 0x12},
{0x58, 0x12},
{0x59, 0x09},
{0x5a, 0x0c},
{0x5b, 0x0c},

//Indoor Edge
{0x5c, 0x0a},
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},

//Dark1 Edge
{0x62, 0x0a},
{0x63, 0x0b},
{0x64, 0x0a},
{0x65, 0x08},
{0x66, 0x09},
{0x67, 0x08},

//Dark2 Edge
{0x68, 0x0a},
{0x69, 0x0b},
{0x6a, 0x0a},
{0x6b, 0x08},
{0x6c, 0x09},
{0x6d, 0x08},

//Dark3 Edge
{0x6e, 0x0a},
{0x6f, 0x0b},
{0x70, 0x0a},
{0x71, 0x08},
{0x72, 0x09},
{0x73, 0x08},

//2DY
{0x80, 0x00},
{0x81, 0x1f},
{0x82, 0x05},
{0x83, 0x31},

{0x90, 0x05},
{0x91, 0x05},
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x03},
{0x95, 0x14},
{0x97, 0x20},
{0x99, 0x20},

{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x05},
{0xa5, 0x05},
{0xa6, 0x07},
{0xa7, 0x08},
{0xa8, 0x07},
{0xa9, 0x08},
{0xaa, 0x07},
{0xab, 0x08},

//Out2
{0xb0, 0x22},
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},

//Out1
{0xb6, 0x22},
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},

//Indoor
{0xbc, 0x25},
{0xbd, 0x2a},
{0xbe, 0x27},
{0xbf, 0x25},
{0xc0, 0x2a},
{0xc1, 0x27},

//Dark1
{0xc2, 0x1e},
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},

//Dark2
{0xc8, 0x18},
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},

//Dark3
{0xce, 0x18},
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
/////// PAGE 13 END ///////

/////// PAGE 14 START ///////
{0x03, 0x14},
{0x10, 0x11},

{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY

{0x20, 0x80}, //X
{0x21, 0x80}, //Y

{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},

{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},

{0x40, 0x3e},
{0x50, 0x28}, //2d
{0x60, 0x24}, //26
{0x70, 0x28}, //2d
/////// PAGE 14 END ///////

/////// PAGE 15 START ///////
{0x03, 0x15},
{0x10, 0x0f},

//Rstep H 16
//Rstep L 14
{0x14, 0x46}, //CMCOFSGH
{0x15, 0x36}, //CMCOFSGM
{0x16, 0x26}, //CMCOFSGL
{0x17, 0x2f}, //CMC SIGN

//CMC
{0x30, 0x8f},
{0x31, 0x59},
{0x32, 0x0a},
{0x33, 0x15},
{0x34, 0x5b},
{0x35, 0x06},
{0x36, 0x07},
{0x37, 0x40},
{0x38, 0x87}, //86

//CMC OFS
{0x40, 0x94},
{0x41, 0x20},
{0x42, 0x89},
{0x43, 0x84},
{0x44, 0x03},
{0x45, 0x01},
{0x46, 0x88},
{0x47, 0x9c},
{0x48, 0x28},

//CMC POFS
{0x50, 0x02},
{0x51, 0x82},
{0x52, 0x00},
{0x53, 0x07},
{0x54, 0x11},
{0x55, 0x98},
{0x56, 0x00},
{0x57, 0x0b},
{0x58, 0x8b},

{0x80, 0x03},
{0x85, 0x40},
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
/////// PAGE 15 END ///////

/////// PAGE 16 START ///////
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e},// Double_AG 5e->37
{0x19, 0x5d},// Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},

//GMA Default
{0x30, 0x00},
{0x31, 0x08},
{0x32, 0x1c},
{0x33, 0x32},
{0x34, 0x54},
{0x35, 0x70},
{0x36, 0x87},
{0x37, 0x9a},
{0x38, 0xaa},
{0x39, 0xb9},
{0x3a, 0xc4},
{0x3b, 0xcf},
{0x3c, 0xd8},
{0x3d, 0xe0},
{0x3e, 0xe9},
{0x3f, 0xf0},
{0x40, 0xf7},
{0x41, 0xfc},
{0x42, 0xff},

{0x50, 0x00},
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x5a},
{0x55, 0x75},
{0x56, 0x8d},
{0x57, 0xa1},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc9},
{0x5b, 0xd2},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},

{0x70, 0x00},
{0x71, 0x0b},
{0x72, 0x1a},
{0x73, 0x37},
{0x74, 0x58},
{0x75, 0x70},
{0x76, 0x86},
{0x77, 0x99},
{0x78, 0xa9},
{0x79, 0xb7},
{0x7a, 0xc3},
{0x7b, 0xcf},
{0x7c, 0xd9},
{0x7d, 0xe1},
{0x7e, 0xe8},
{0x7f, 0xef},
{0x80, 0xf4},
{0x81, 0xfa},
{0x82, 0xff},
/////// PAGE 16 END ///////

/////// PAGE 17 START ///////
{0x03, 0x17},
{0x10, 0xf7},
/////// PAGE 17 END ///////

/////// PAGE 20 START ///////
{0x03, 0x20},
{0x11, 0x1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x05},
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},

{0x28, 0xef},
{0x29, 0x0d}, //20100305 ad->0d
{0x2a, 0xff},
{0x2b, 0xf4},

{0x2c, 0xc2},
{0x2d, 0xff},
{0x2e, 0x33},
{0x30, 0xf8},
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x22},
{0x3a, 0xde},
{0x3b, 0x22},
{0x3c, 0xde},

{0x50, 0x45},
{0x51, 0x88},

{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},

{0x60, 0xaa},
{0x61, 0xaa},
{0x62, 0xaa},
{0x63, 0xaa},
{0x64, 0xaa},
{0x65, 0xaa},
{0x66, 0xab},
{0x67, 0xEa},
{0x68, 0xab},
{0x69, 0xEa},
{0x6a, 0xaa},
{0x6b, 0xaa},
{0x6c, 0xaa},
{0x6d, 0xaa},
{0x6e, 0xaa},
{0x6f, 0xaa},

{0x70, 0x70}, //6c
{0x71, 0x82}, //82(+8)

{0x76, 0x43},
{0x77, 0x02},
{0x78, 0x24}, //24
{0x79, 0x48}, // Y Target 70 => 25, 72 => 26 //
{0x7a, 0x23}, //23
{0x7b, 0x22}, //22
{0x7d, 0x23},

{0x83, 0x01}, //EXP Normal 30.00 fps
{0x84, 0x86},
{0x85, 0xa0},

{0x86, 0x01}, //EXPMin 6000.00 fps
{0x87, 0xf4},

{0x88, 0x05}, //EXP Max 8.00 fps
{0x89, 0xb8},
{0x8a, 0xd8},

{0x8B, 0x75}, //EXP100, PLLx2 Mclk24
{0x8C, 0x30},

{0x8D, 0x61}, //EXP120, PLLx2 Mclk24
{0x8E, 0xa8},

{0x98, 0x9d}, //9d
{0x99, 0x45},
{0x9a, 0x0d},
{0x9b, 0xde},

{0x9c, 0x17}, //EXP Limit 500.00 fps, PLLx2 Mclk24
{0x9d, 0x70},

{0x9e, 0x01}, //EXP Unit, PLLx2 Mclk24
{0x9f, 0xf4},

{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xe0},
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x32},
{0xbd, 0x32},

{0xc0, 0x10},
{0xc1, 0x2b},
{0xc2, 0x2b},
{0xc3, 0x2b},
{0xc4, 0x08},

{0xc8, 0x40},
{0xc9, 0x40},
/////// PAGE 20 END ///////

/////// PAGE 22 START ///////
{0x03, 0x22},
{0x10, 0xfd},
{0x11, 0x2e},
{0x19, 0x01}, // Low On //
{0x20, 0x10},
{0x21, 0x80},
{0x24, 0x01},
//{0x25, 0x00}, //7f New Lock Cond & New light stable

{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x11},
{0x39, 0x34},
{0x40, 0xf3},

{0x41, 0x32}, //33 //44
{0x42, 0x22}, //22 //43
{0x43, 0xf0}, //f6
{0x44, 0x44}, //44
{0x45, 0x44}, //33
{0x46, 0x00},
{0x50, 0xb2},
{0x51, 0x81},
{0x52, 0x98},

{0x80, 0x38},
{0x81, 0x20},
{0x82, 0x36}, //3a

{0x83, 0x5e}, //5e
{0x84, 0x21}, //24
{0x85, 0x51}, //54
{0x86, 0x20}, //24 //22

{0x87, 0x49},
{0x88, 0x39},
{0x89, 0x37}, //38
{0x8a, 0x29}, //2a

{0x8b, 0x41}, //47
{0x8c, 0x39},
{0x8d, 0x34},
{0x8e, 0x29}, //2c

{0x8f,	0x5c},
{0x90,	0x5b},
{0x91,	0x57},
{0x92,	0x4f},
{0x93,	0x43},
{0x94,	0x3e},
{0x95,	0x34},
{0x96,	0x2c},
{0x97, 0x23},
{0x98, 0x20},
{0x99, 0x1f},
{0x9a, 0x1f},

{0x9b, 0x77},
{0x9c, 0x66},
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},

{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},

{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, // 700fps
{0xa6, 0xcf},

{0xad, 0x40},
{0xae, 0x4a},

{0xaf, 0x28},  // low temp Rgain
{0xb0, 0x26},  // low temp Rgain

{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xb0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
/////// PAGE 22 END ///////

/////// PAGE 20 ///////
{0x03, 0x20},
{0x10, 0x8c}, //AE on 60hz

/////// PAGE 22 ///////
{0x03, 0x22},
{0x10, 0xe9},

/////// PAGE 0 ///////
{0x03, 0x00},
{0x0e, 0x03},
{0x0e, 0x73},

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00},
{0x01, 0xf8},

{0xff, 0x0a},//NEED Delay 100ms//

};

//==========================================================
//	CAMERA INITIAL for Self Recording 24 Fixed Frame
//==========================================================
regs_short_t  front_init_vt_50hz_regs[] = {

{0x01, 0xf9}, //sleep on
{0x08, 0x0f}, //Hi-Z on
{0x01, 0xf8}, //sleep off

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x03}, //PLL On
{0x0e, 0x73}, //x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x00}, //PLL off
{0x01, 0xf9}, //sleep on
{0x08, 0x00}, //Hi-Z off

{0x01, 0xfb},
{0x01, 0xf9},

/////// PAGE 20 ///////
{0x03, 0x20}, //page 20
{0x10, 0x1c}, //AE off 50hz

/////// PAGE 22 ///////
{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off


//Initial Start
/////// PAGE 0 START ///////
{0x03, 0x00},
{0x10, 0x1b}, //Vsync Active High B:[3]

#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x94},
#else
{0x11, 0x96},
#endif

{0x12, 0x00}, //Pclk Falling Edge B:[2]

{0x0b, 0xaa},
{0x0c, 0xaa},
{0x0d, 0xaa},

{0x20, 0x00},
{0x21, 0x04},
{0x22, 0x00},
{0x23, 0x06},

{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},

{0x28, 0x0c},
{0x29, 0x04},
{0x2a, 0x02},
{0x2b, 0x04},
{0x2c, 0x06},
{0x2d, 0x02},

{0x40, 0x01}, //Hblank 352
{0x41, 0x60},
{0x42, 0x00}, //Vblank 20
{0x43, 0x14},

{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},

//BLC
{0x80, 0x2e},
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x04}, //BLC_TIME_TH_ON
{0x91, 0x04}, //BLC_TIME_TH_OFF
{0x92, 0xb0}, //BLC_AG_TH_ON
{0x93, 0xa8}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},

//Dark BLC
{0xa0, 0x00},
{0xa2, 0x00},
{0xa4, 0x00},
{0xa6, 0x00},

//Normal BLC
{0xa8, 0x43},
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},

//OutDoor  BLC
{0x99, 0x43},
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
/////// PAGE 0 END ///////

/////// PAGE 2 START ///////
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG//
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},

{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00},
{0x2f, 0x00},
{0x30, 0x05}, //For Hi-253 never no change 0x05

{0x50, 0x20},
{0x51, 0x03}, //20110826
{0x52, 0x01}, //0x03 --> 0x01
{0x53, 0xc1}, //20110818 ߰
{0x55, 0x1c},
{0x56, 0x11},
{0x5d, 0xa2},
{0x5e, 0x5a},

{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},

{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},

{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},

{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},

{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},

{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},

{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},

{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa},

{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},

{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x04}, //DCDC_TIME_TH_ON
{0xd5, 0x04}, //DCDC_TIME_TH_OFF
{0xd6, 0xb0}, //DCDC_AG_TH_ON
{0xd7, 0xa8}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},

{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},

/////// PAGE 2 END ///////

/////// PAGE 3 ///////
{0x03, 0x03},
{0x10, 0x10},
/////// PAGE 3 END ///////

/////// PAGE 10 START ///////
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},

{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x00}, //Setting For Camcorder 24

{0x40, 0x80},
{0x41, 0x00},

{0x60, 0x67}, //Setting For Camcorder 24
{0x61, 0x7a}, //77
{0x62, 0x79}, //77
{0x63, 0x50}, // Double_AG 50->30
{0x64, 0x41},

{0x66, 0x42},
{0x67, 0x20},

{0x6a, 0x80}, //8a
{0x6b, 0x84}, //74
{0x6c, 0x7a}, //7e
{0x6d, 0x80}, //8e

/////// PAGE 11 START ///////
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, // Blue Max-Filter Delete
{0x13, 0xbb},

{0x26, 0x31}, // Double_AG 31->20
{0x27, 0x34}, // Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},

//Out2 D-LPF th
{0x30, 0x70},
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},

//Out1 D-LPF th
{0x36, 0x70},
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x20},
{0x3a, 0x1f},
{0x3b, 0x03},

//Indoor D-LPF th
{0x3c, 0x80},
{0x3d, 0x18},
{0x3e, 0x80},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},

//Dark1 D-LPF th
{0x42, 0x80},
{0x43, 0x18},
{0x44, 0x80},
{0x45, 0x0c},
{0x46, 0x09},
{0x47, 0x06},

//Dark2 D-LPF th
{0x48, 0x80},
{0x49, 0x18},
{0x4a, 0x80},
{0x4b, 0x0c},
{0x4c, 0x09},
{0x4d, 0x06},

//Dark3 D-LPF th
{0x4e, 0x80},
{0x4f, 0x18},
{0x50, 0x80},
{0x51, 0x0c},
{0x52, 0x09},
{0x53, 0x06},

{0x54, 0x11},
{0x55, 0x17},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},

{0x5a, 0x18},
{0x5b, 0x00},
{0x5c, 0x00},

{0x60, 0x3f},
{0x62, 0x60},
{0x70, 0x06},
/////// PAGE 11 END ///////

/////// PAGE 12 START ///////
{0x03, 0x12},
{0x20, 0x0f}, //Setting For Camcorder 24
{0x21, 0x0f}, //Setting For Camcorder 24

{0x25, 0x00}, //0x30

{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},

{0x30, 0x50},
{0x31, 0x18},
{0x32, 0x32},
{0x33, 0x40},
{0x34, 0x50},
{0x35, 0x70},
{0x36, 0xa0},

//Out2 th
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},

//Out1 th
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xb0},
{0x49, 0xb0},
{0x4a, 0x90},
{0x4b, 0x80},

//Indoor th
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0x90},
{0x4f, 0x90},
{0x50, 0xa0},
{0x51, 0x80},

//Dark1 th
{0x52, 0xb0},
{0x53, 0x40},
{0x54, 0x90},
{0x55, 0x90},
{0x56, 0xa0},
{0x57, 0x78},

//Dark2 th
{0x58, 0xb0},
{0x59, 0x40},
{0x5a, 0x90},
{0x5b, 0x90},
{0x5c, 0xa0},
{0x5d, 0x78},

//Dark3 th
{0x5e, 0xb0},
{0x5f, 0x40},
{0x60, 0x90},
{0x61, 0x90},
{0x62, 0xa0},
{0x63, 0x78},

{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register

{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register

{0x74, 0x25},
{0x75, 0x15},

{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x5d}, //Setting For Camcorder 24

//Dont Touch register
{0xD0, 0x0c},
{0xD1, 0x80},
{0xD2, 0x67},
{0xD3, 0x00},
{0xD4, 0x00},
{0xD5, 0x02},
{0xD6, 0xff},
{0xD7, 0x18},
//End
{0x3b, 0x06},
{0x3c, 0x06},

//Dont Touch register
{0xc5, 0x30},//55->48
{0xc6, 0x2a},//48->40
/////// PAGE 12 END ///////

/////// PAGE 13 START ///////
{0x03, 0x13},
//Edge
{0x10, 0xcb},
{0x11, 0x7b},
{0x12, 0x07},
{0x14, 0x00},

{0x20, 0x15},
{0x21, 0x13},
{0x22, 0x33},
{0x23, 0x05},
{0x24, 0x09},

{0x25, 0x0a},

{0x26, 0x18},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},

//Low clip th
{0x2b, 0x02},
{0x2c, 0x02},
{0x25, 0x06},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},

//Out2 Edge
{0x50, 0x10},
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0c},

//Out1 Edge
{0x56, 0x0f},
{0x57, 0x12},
{0x58, 0x12},
{0x59, 0x09},
{0x5a, 0x0c},
{0x5b, 0x0c},

//Indoor Edge
{0x5c, 0x0a},
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},

//Dark1 Edge
{0x62, 0x0a},
{0x63, 0x0b},
{0x64, 0x0a},
{0x65, 0x08},
{0x66, 0x09},
{0x67, 0x08},

//Dark2 Edge
{0x68, 0x0a},
{0x69, 0x0b},
{0x6a, 0x0a},
{0x6b, 0x08},
{0x6c, 0x09},
{0x6d, 0x08},

//Dark3 Edge
{0x6e, 0x0a},
{0x6f, 0x0b},
{0x70, 0x0a},
{0x71, 0x08},
{0x72, 0x09},
{0x73, 0x08},

//2DY
{0x80, 0xfd}, //Setting For Camcorder 24
{0x81, 0x1f},
{0x82, 0x05},
{0x83, 0x31},

{0x90, 0x05},
{0x91, 0x05},
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x03},
{0x95, 0x14},
{0x97, 0x20},
{0x99, 0x20},

{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x05},
{0xa5, 0x05},
{0xa6, 0x07},
{0xa7, 0x08},
{0xa8, 0x07},
{0xa9, 0x08},
{0xaa, 0x07},
{0xab, 0x08},

//Out2
{0xb0, 0x22},
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},

//Out1
{0xb6, 0x22},
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},

//Indoor
{0xbc, 0x25},
{0xbd, 0x2a},
{0xbe, 0x27},
{0xbf, 0x25},
{0xc0, 0x2a},
{0xc1, 0x27},

//Dark1
{0xc2, 0x1e},
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},

//Dark2
{0xc8, 0x18},
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},

//Dark3
{0xce, 0x18},
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
/////// PAGE 13 END ///////

/////// PAGE 14 START ///////
{0x03, 0x14},
{0x10, 0x11},

{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY

{0x20, 0x80}, //X
{0x21, 0x80}, //Y

{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},

{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},

{0x40, 0x3e},
{0x50, 0x28}, //2d
{0x60, 0x24}, //26
{0x70, 0x28}, //2d
/////// PAGE 14 END ///////

/////// PAGE 15 START ///////
{0x03, 0x15},
{0x10, 0x0f},

//Rstep H 16
//Rstep L 14
{0x14, 0x46}, //CMCOFSGH
{0x15, 0x36}, //CMCOFSGM
{0x16, 0x26}, //CMCOFSGL
{0x17, 0x2f}, //CMC SIGN

//CMC
{0x30, 0x8f},
{0x31, 0x59},
{0x32, 0x0a},
{0x33, 0x15},
{0x34, 0x5b},
{0x35, 0x06},
{0x36, 0x07},
{0x37, 0x40},
{0x38, 0x87}, //86

//CMC OFS
{0x40, 0x94},
{0x41, 0x20},
{0x42, 0x89},
{0x43, 0x84},
{0x44, 0x03},
{0x45, 0x01},
{0x46, 0x88},
{0x47, 0x9c},
{0x48, 0x28},

//CMC POFS
{0x50, 0x02},
{0x51, 0x82},
{0x52, 0x00},
{0x53, 0x07},
{0x54, 0x11},
{0x55, 0x98},
{0x56, 0x00},
{0x57, 0x0b},
{0x58, 0x8b},

{0x80, 0x03},
{0x85, 0x40},
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
/////// PAGE 15 END ///////

/////// PAGE 16 START ///////
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e},// Double_AG 5e->37
{0x19, 0x5d},// Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},

//GMA Default
{0x30, 0x00},
{0x31, 0x08},
{0x32, 0x1c},
{0x33, 0x32},
{0x34, 0x54},
{0x35, 0x70},
{0x36, 0x87},
{0x37, 0x9a},
{0x38, 0xaa},
{0x39, 0xb9},
{0x3a, 0xc4},
{0x3b, 0xcf},
{0x3c, 0xd8},
{0x3d, 0xe0},
{0x3e, 0xe9},
{0x3f, 0xf0},
{0x40, 0xf7},
{0x41, 0xfc},
{0x42, 0xff},

{0x50, 0x00},
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x5a},
{0x55, 0x75},
{0x56, 0x8d},
{0x57, 0xa1},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc9},
{0x5b, 0xd2},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},

{0x70, 0x00},
{0x71, 0x08},
{0x72, 0x1c},
{0x73, 0x32},
{0x74, 0x54},
{0x75, 0x70},
{0x76, 0x87},
{0x77, 0x9a},
{0x78, 0xaa},
{0x79, 0xb9},
{0x7a, 0xc4},
{0x7b, 0xcf},
{0x7c, 0xd8},
{0x7d, 0xe0},
{0x7e, 0xe9},
{0x7f, 0xf0},
{0x80, 0xf7},
{0x81, 0xfc},
{0x82, 0xff},
/////// PAGE 16 END ///////

/////// PAGE 17 START ///////
{0x03, 0x17},
{0x10, 0xf7},
/////// PAGE 17 END ///////

/////// PAGE 20 START ///////
{0x03, 0x20},
{0x11, 0x1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x05},
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},

{0x28, 0xef},
{0x29, 0x0d}, //20100305 ad->0d
{0x2a, 0x03},
{0x2b, 0xf5},

{0x2c, 0xc2},
{0x2d, 0xff},
{0x2e, 0x33},
{0x30, 0xf8},
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x22},
{0x3a, 0xde},
{0x3b, 0x22},
{0x3c, 0xde},

{0x50, 0x45},
{0x51, 0x88},

{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},

{0x60, 0xaa},
{0x61, 0xaa},
{0x62, 0xaa},
{0x63, 0xaa},
{0x64, 0xaa},
{0x65, 0xaa},
{0x66, 0xab},
{0x67, 0xEa},
{0x68, 0xab},
{0x69, 0xEa},
{0x6a, 0xaa},
{0x6b, 0xaa},
{0x6c, 0xaa},
{0x6d, 0xaa},
{0x6e, 0xaa},
{0x6f, 0xaa},

{0x70, 0x7a},
{0x71, 0x80},

{0x76, 0x43},
{0x77, 0x02},
{0x78, 0x24},
{0x79, 0x49},
{0x7a, 0x23},
{0x7b, 0x22},
{0x7d, 0x23},

{0x83, 0x01}, //EXP Normal 33.33 fps
{0x84, 0x5f},
{0x85, 0x6c},

{0x86, 0x01}, //EXPMin 10204.08 fps
{0x87, 0x26},

{0x88, 0x01}, //EXP Max 25.00 fps
{0x89, 0xd4},
{0x8a, 0x90},

{0x8B, 0x75}, //EXP100
{0x8C, 0x24},

{0x8D, 0x61}, //EXP120
{0x8E, 0x9e},

{0x91, 0x01}, //EXP Fix 23.93 fps
{0x92, 0xe9},
{0x93, 0xcf},

{0x98, 0x9d}, //9d
{0x99, 0x45},
{0x9a, 0x0d},
{0x9b, 0xde},

{0x9c, 0x0e}, //EXP Limit 784.93 fps
{0x9d, 0xee},

{0x9e, 0x01}, //EXP Unit
{0x9f, 0x26},

{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xb8},
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x32},
{0xbd, 0x32},

{0xc0, 0x10},
{0xc1, 0x2b},
{0xc2, 0x2b},
{0xc3, 0x2b},
{0xc4, 0x08},

{0xc8, 0x40},
{0xc9, 0x20},
/////// PAGE 20 END ///////

/////// PAGE 22 START ///////
{0x03, 0x22},
{0x10, 0xfd},
{0x11, 0x2e},
{0x19, 0x01},
{0x20, 0x30},
{0x21, 0x80},
{0x24, 0x01},
//{0x25, 0x00}, //7f New Lock Cond & New light stable

{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x11},
{0x39, 0x34},
{0x40, 0xf3},

{0x41, 0x32}, //33 //44
{0x42, 0x22}, //22 //43
{0x43, 0xf0}, //f6
{0x44, 0x44}, //44
{0x45, 0x44}, //33
{0x46, 0x00},
{0x50, 0xb2},
{0x51, 0x81},
{0x52, 0x98},

{0x80, 0x38},
{0x81, 0x20},
{0x82, 0x36}, //3a

{0x83, 0x5e}, //5e
{0x84, 0x21}, //24
{0x85, 0x51}, //54
{0x86, 0x20}, //24 //22

{0x87, 0x49},
{0x88, 0x39},
{0x89, 0x37}, //38
{0x8a, 0x29}, //2a

{0x8b, 0x41}, //47
{0x8c, 0x39},
{0x8d, 0x34},
{0x8e, 0x29}, //2c

{0x8f,	0x5c},
{0x90,	0x5b},
{0x91,	0x57},
{0x92,	0x4f},
{0x93,	0x43},
{0x94,	0x3e},
{0x95,	0x34},
{0x96,	0x2c},
{0x97, 0x23},
{0x98, 0x20},
{0x99, 0x1f},
{0x9a, 0x1f},

{0x9b, 0x77},
{0x9c, 0x66},
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},

{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},

{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, // 700fps
{0xa6, 0xcf},

{0xad, 0x40},
{0xae, 0x4a},

{0xaf, 0x28},  // low temp Rgain
{0xb0, 0x26},  // low temp Rgain

{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xb0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
/////// PAGE 22 END ///////

/////// PAGE 20 ///////
{0x03, 0x20},
{0x10, 0x9c}, //AE on 50hz

/////// PAGE 22 ///////
{0x03, 0x22},
{0x10, 0xe9},

/////// PAGE 0 ///////
{0x03, 0x00},
{0x0e, 0x03},
{0x0e, 0x73},

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00},
{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//

};

regs_short_t  front_init_vt_60hz_regs[] = {

{0x01, 0xf9}, //sleep on
{0x08, 0x0f}, //Hi-Z on
{0x01, 0xf8}, //sleep off

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x03}, //PLL On
{0x0e, 0x73}, //x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x00}, //PLL off
{0x01, 0xf9}, //sleep on
{0x08, 0x00}, //Hi-Z off

{0x01, 0xfb},
{0x01, 0xf9},

/////// PAGE 20 ///////
{0x03, 0x20}, //page 20
{0x10, 0x0c}, //AE off 60hz

/////// PAGE 22 ///////
{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off


//Initial Start
/////// PAGE 0 START ///////
{0x03, 0x00},
{0x10, 0x1b}, //Vsync Active High B:[3]

#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x94},
#else
{0x11, 0x96},
#endif

{0x12, 0x00}, //Pclk Falling Edge B:[2]

{0x0b, 0xaa},
{0x0c, 0xaa},
{0x0d, 0xaa},

{0x20, 0x00},
{0x21, 0x04},
{0x22, 0x00},
{0x23, 0x06},

{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},

{0x28, 0x0c},
{0x29, 0x04},
{0x2a, 0x02},
{0x2b, 0x04},
{0x2c, 0x06},
{0x2d, 0x02},

{0x40, 0x01}, //Hblank 352
{0x41, 0x60},
{0x42, 0x00}, //Vblank 20
{0x43, 0x14},

{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},

//BLC
{0x80, 0x2e},
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x05}, //BLC_TIME_TH_ON
{0x91, 0x05}, //BLC_TIME_TH_OFF
{0x92, 0xb0}, //BLC_AG_TH_ON
{0x93, 0xa8}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},

//Dark BLC
{0xa0, 0x00},
{0xa2, 0x00},
{0xa4, 0x00},
{0xa6, 0x00},

//Normal BLC
{0xa8, 0x43},
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},

//OutDoor  BLC
{0x99, 0x43},
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
/////// PAGE 0 END ///////

/////// PAGE 2 START ///////
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG//
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},

{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00},
{0x2f, 0x00},
{0x30, 0x05}, //For Hi-253 never no change 0x05

{0x50, 0x20},
{0x51, 0x03}, //20110826
{0x52, 0x01}, //0x03 --> 0x01
{0x53, 0xc1}, //20110818 ߰
{0x55, 0x1c},
{0x56, 0x11},
{0x5d, 0xa2},
{0x5e, 0x5a},

{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},

{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},

{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},

{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},

{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},

{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},

{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},

{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa},

{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},

{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x05}, //DCDC_TIME_TH_ON
{0xd5, 0x05}, //DCDC_TIME_TH_OFF
{0xd6, 0xb0}, //DCDC_AG_TH_ON
{0xd7, 0xa8}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},

{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},

/////// PAGE 2 END ///////

/////// PAGE 3 ///////
{0x03, 0x03},
{0x10, 0x10},
/////// PAGE 3 END ///////

/////// PAGE 10 START ///////
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},

{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x00}, //Setting For Camcorder 24

{0x40, 0x80},
{0x41, 0x00},

{0x60, 0x67}, //Setting For Camcorder 24
{0x61, 0x7a}, //77
{0x62, 0x79}, //77
{0x63, 0x50}, // Double_AG 50->30
{0x64, 0x41},

{0x66, 0x42},
{0x67, 0x20},

{0x6a, 0x80}, //8a
{0x6b, 0x84}, //74
{0x6c, 0x7a}, //7e
{0x6d, 0x80}, //8e

/////// PAGE 11 START ///////
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, // Blue Max-Filter Delete
{0x13, 0xbb},

{0x26, 0x31}, // Double_AG 31->20
{0x27, 0x34}, // Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},

//Out2 D-LPF th
{0x30, 0x70},
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},

//Out1 D-LPF th
{0x36, 0x70},
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x20},
{0x3a, 0x1f},
{0x3b, 0x03},

//Indoor D-LPF th
{0x3c, 0x80},
{0x3d, 0x18},
{0x3e, 0x80},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},

//Dark1 D-LPF th
{0x42, 0x80},
{0x43, 0x18},
{0x44, 0x80},
{0x45, 0x0c},
{0x46, 0x09},
{0x47, 0x06},

//Dark2 D-LPF th
{0x48, 0x80},
{0x49, 0x18},
{0x4a, 0x80},
{0x4b, 0x0c},
{0x4c, 0x09},
{0x4d, 0x06},

//Dark3 D-LPF th
{0x4e, 0x80},
{0x4f, 0x18},
{0x50, 0x80},
{0x51, 0x0c},
{0x52, 0x09},
{0x53, 0x06},

{0x54, 0x11},
{0x55, 0x17},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},

{0x5a, 0x18},
{0x5b, 0x00},
{0x5c, 0x00},

{0x60, 0x3f},
{0x62, 0x60},
{0x70, 0x06},
/////// PAGE 11 END ///////

/////// PAGE 12 START ///////
{0x03, 0x12},
{0x20, 0x0f}, //Setting For Camcorder 24
{0x21, 0x0f}, //Setting For Camcorder 24

{0x25, 0x00}, //0x30

{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},

{0x30, 0x50},
{0x31, 0x18},
{0x32, 0x32},
{0x33, 0x40},
{0x34, 0x50},
{0x35, 0x70},
{0x36, 0xa0},

//Out2 th
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},

//Out1 th
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xb0},
{0x49, 0xb0},
{0x4a, 0x90},
{0x4b, 0x80},

//Indoor th
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0x90},
{0x4f, 0x90},
{0x50, 0xa0},
{0x51, 0x80},

//Dark1 th
{0x52, 0xb0},
{0x53, 0x40},
{0x54, 0x90},
{0x55, 0x90},
{0x56, 0xa0},
{0x57, 0x78},

//Dark2 th
{0x58, 0xb0},
{0x59, 0x40},
{0x5a, 0x90},
{0x5b, 0x90},
{0x5c, 0xa0},
{0x5d, 0x78},

//Dark3 th
{0x5e, 0xb0},
{0x5f, 0x40},
{0x60, 0x90},
{0x61, 0x90},
{0x62, 0xa0},
{0x63, 0x78},

{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register

{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register

{0x74, 0x25},
{0x75, 0x15},

{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x5d}, //Setting For Camcorder 24

//Dont Touch register
{0xD0, 0x0c},
{0xD1, 0x80},
{0xD2, 0x67},
{0xD3, 0x00},
{0xD4, 0x00},
{0xD5, 0x02},
{0xD6, 0xff},
{0xD7, 0x18},
//End
{0x3b, 0x06},
{0x3c, 0x06},

//Dont Touch register
{0xc5, 0x30},//55->48
{0xc6, 0x2a},//48->40
/////// PAGE 12 END ///////

/////// PAGE 13 START ///////
{0x03, 0x13},
//Edge
{0x10, 0xcb},
{0x11, 0x7b},
{0x12, 0x07},
{0x14, 0x00},

{0x20, 0x15},
{0x21, 0x13},
{0x22, 0x33},
{0x23, 0x05},
{0x24, 0x09},

{0x25, 0x0a},

{0x26, 0x18},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},

//Low clip th
{0x2b, 0x02},
{0x2c, 0x02},
{0x25, 0x06},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},

//Out2 Edge
{0x50, 0x10},
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0c},

//Out1 Edge
{0x56, 0x0f},
{0x57, 0x12},
{0x58, 0x12},
{0x59, 0x09},
{0x5a, 0x0c},
{0x5b, 0x0c},

//Indoor Edge
{0x5c, 0x0a},
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},

//Dark1 Edge
{0x62, 0x0a},
{0x63, 0x0b},
{0x64, 0x0a},
{0x65, 0x08},
{0x66, 0x09},
{0x67, 0x08},

//Dark2 Edge
{0x68, 0x0a},
{0x69, 0x0b},
{0x6a, 0x0a},
{0x6b, 0x08},
{0x6c, 0x09},
{0x6d, 0x08},

//Dark3 Edge
{0x6e, 0x0a},
{0x6f, 0x0b},
{0x70, 0x0a},
{0x71, 0x08},
{0x72, 0x09},
{0x73, 0x08},

//2DY
{0x80, 0xfd}, //Setting For Camcorder 24
{0x81, 0x1f},
{0x82, 0x05},
{0x83, 0x31},

{0x90, 0x05},
{0x91, 0x05},
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x03},
{0x95, 0x14},
{0x97, 0x20},
{0x99, 0x20},

{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x05},
{0xa5, 0x05},
{0xa6, 0x07},
{0xa7, 0x08},
{0xa8, 0x07},
{0xa9, 0x08},
{0xaa, 0x07},
{0xab, 0x08},

//Out2
{0xb0, 0x22},
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},

//Out1
{0xb6, 0x22},
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},

//Indoor
{0xbc, 0x25},
{0xbd, 0x2a},
{0xbe, 0x27},
{0xbf, 0x25},
{0xc0, 0x2a},
{0xc1, 0x27},

//Dark1
{0xc2, 0x1e},
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},

//Dark2
{0xc8, 0x18},
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},

//Dark3
{0xce, 0x18},
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
/////// PAGE 13 END ///////

/////// PAGE 14 START ///////
{0x03, 0x14},
{0x10, 0x11},

{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY

{0x20, 0x80}, //X
{0x21, 0x80}, //Y

{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},

{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},

{0x40, 0x3e},
{0x50, 0x28}, //2d
{0x60, 0x24}, //26
{0x70, 0x28}, //2d
/////// PAGE 14 END ///////

/////// PAGE 15 START ///////
{0x03, 0x15},
{0x10, 0x0f},

//Rstep H 16
//Rstep L 14
{0x14, 0x46}, //CMCOFSGH
{0x15, 0x36}, //CMCOFSGM
{0x16, 0x26}, //CMCOFSGL
{0x17, 0x2f}, //CMC SIGN

//CMC
{0x30, 0x8f},
{0x31, 0x59},
{0x32, 0x0a},
{0x33, 0x15},
{0x34, 0x5b},
{0x35, 0x06},
{0x36, 0x07},
{0x37, 0x40},
{0x38, 0x87}, //86

//CMC OFS
{0x40, 0x94},
{0x41, 0x20},
{0x42, 0x89},
{0x43, 0x84},
{0x44, 0x03},
{0x45, 0x01},
{0x46, 0x88},
{0x47, 0x9c},
{0x48, 0x28},

//CMC POFS
{0x50, 0x02},
{0x51, 0x82},
{0x52, 0x00},
{0x53, 0x07},
{0x54, 0x11},
{0x55, 0x98},
{0x56, 0x00},
{0x57, 0x0b},
{0x58, 0x8b},

{0x80, 0x03},
{0x85, 0x40},
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
/////// PAGE 15 END ///////

/////// PAGE 16 START ///////
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e},// Double_AG 5e->37
{0x19, 0x5d},// Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},

//GMA Default
{0x30, 0x00},
{0x31, 0x08},
{0x32, 0x1c},
{0x33, 0x32},
{0x34, 0x54},
{0x35, 0x70},
{0x36, 0x87},
{0x37, 0x9a},
{0x38, 0xaa},
{0x39, 0xb9},
{0x3a, 0xc4},
{0x3b, 0xcf},
{0x3c, 0xd8},
{0x3d, 0xe0},
{0x3e, 0xe9},
{0x3f, 0xf0},
{0x40, 0xf7},
{0x41, 0xfc},
{0x42, 0xff},

{0x50, 0x00},
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x5a},
{0x55, 0x75},
{0x56, 0x8d},
{0x57, 0xa1},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc9},
{0x5b, 0xd2},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},

{0x70, 0x00},
{0x71, 0x08},
{0x72, 0x1c},
{0x73, 0x32},
{0x74, 0x54},
{0x75, 0x70},
{0x76, 0x87},
{0x77, 0x9a},
{0x78, 0xaa},
{0x79, 0xb9},
{0x7a, 0xc4},
{0x7b, 0xcf},
{0x7c, 0xd8},
{0x7d, 0xe0},
{0x7e, 0xe9},
{0x7f, 0xf0},
{0x80, 0xf7},
{0x81, 0xfc},
{0x82, 0xff},
/////// PAGE 16 END ///////

/////// PAGE 17 START ///////
{0x03, 0x17},
{0x10, 0xf7},
/////// PAGE 17 END ///////

/////// PAGE 20 START ///////
{0x03, 0x20},
{0x11, 0x1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x05},
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},

{0x28, 0xef},
{0x29, 0x0d}, //20100305 ad->0d
{0x2a, 0x03},
{0x2b, 0xf5},

{0x2c, 0xc2},
{0x2d, 0xff},
{0x2e, 0x33},
{0x30, 0xf8},
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x39, 0x22},
{0x3a, 0xde},
{0x3b, 0x22},
{0x3c, 0xde},

{0x50, 0x45},
{0x51, 0x88},

{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},

{0x60, 0xaa},
{0x61, 0xaa},
{0x62, 0xaa},
{0x63, 0xaa},
{0x64, 0xaa},
{0x65, 0xaa},
{0x66, 0xab},
{0x67, 0xEa},
{0x68, 0xab},
{0x69, 0xEa},
{0x6a, 0xaa},
{0x6b, 0xaa},
{0x6c, 0xaa},
{0x6d, 0xaa},
{0x6e, 0xaa},
{0x6f, 0xaa},

{0x70, 0x7a},
{0x71, 0x80},

{0x76, 0x43},
{0x77, 0x02},
{0x78, 0x24},
{0x79, 0x49},
{0x7a, 0x23},
{0x7b, 0x22},
{0x7d, 0x23},

{0x83, 0x01}, //EXP Normal 30.00 fps
{0x84, 0x86},
{0x85, 0x78},

{0x86, 0x01}, //EXPMin 10204.08 fps
{0x87, 0x26},

{0x88, 0x01}, //EXP Max 24.00 fps
{0x89, 0xe8},
{0x8a, 0x16},

{0x8B, 0x75}, //EXP100
{0x8C, 0x24},

{0x8D, 0x61}, //EXP120
{0x8E, 0x9e},

{0x91, 0x01}, //EXP Fix 23.93 fps
{0x92, 0xe9},
{0x93, 0xcf},

{0x98, 0x9d}, //9d
{0x99, 0x45},
{0x9a, 0x0d},
{0x9b, 0xde},

{0x9c, 0x0e}, //EXP Limit 784.93 fps
{0x9d, 0xee},

{0x9e, 0x01}, //EXP Unit
{0x9f, 0x26},

{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xb8},
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x32},
{0xbd, 0x32},

{0xc0, 0x10},
{0xc1, 0x2b},
{0xc2, 0x2b},
{0xc3, 0x2b},
{0xc4, 0x08},

{0xc8, 0x40},
{0xc9, 0x20},
/////// PAGE 20 END ///////

/////// PAGE 22 START ///////
{0x03, 0x22},
{0x10, 0xfd},
{0x11, 0x2e},
{0x19, 0x01},
{0x20, 0x30},
{0x21, 0x80},
{0x24, 0x01},
//{0x25, 0x00}, //7f New Lock Cond & New light stable

{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x11},
{0x39, 0x34},
{0x40, 0xf3},

{0x41, 0x32}, //33 //44
{0x42, 0x22}, //22 //43
{0x43, 0xf0}, //f6
{0x44, 0x44}, //44
{0x45, 0x44}, //33
{0x46, 0x00},
{0x50, 0xb2},
{0x51, 0x81},
{0x52, 0x98},

{0x80, 0x38},
{0x81, 0x20},
{0x82, 0x36}, //3a

{0x83, 0x5e}, //5e
{0x84, 0x21}, //24
{0x85, 0x51}, //54
{0x86, 0x20}, //24 //22

{0x87, 0x49},
{0x88, 0x39},
{0x89, 0x37}, //38
{0x8a, 0x29}, //2a

{0x8b, 0x41}, //47
{0x8c, 0x39},
{0x8d, 0x34},
{0x8e, 0x29}, //2c

{0x8f,	0x5c},
{0x90,	0x5b},
{0x91,	0x57},
{0x92,	0x4f},
{0x93,	0x43},
{0x94,	0x3e},
{0x95,	0x34},
{0x96,	0x2c},
{0x97, 0x23},
{0x98, 0x20},
{0x99, 0x1f},
{0x9a, 0x1f},

{0x9b, 0x77},
{0x9c, 0x66},
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},

{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},

{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, // 700fps
{0xa6, 0xcf},

{0xad, 0x40},
{0xae, 0x4a},

{0xaf, 0x28},  // low temp Rgain
{0xb0, 0x26},  // low temp Rgain

{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xb0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
/////// PAGE 22 END ///////

/////// PAGE 20 ///////
{0x03, 0x20},
{0x10, 0x8c}, //AE on 60hz

/////// PAGE 22 ///////
{0x03, 0x22},
{0x10, 0xe9},

/////// PAGE 0 ///////
{0x03, 0x00},
{0x0e, 0x03},
{0x0e, 0x73},

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00},
{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//

};

//==========================================================
//	CAMERA INITIAL for VT 15 Fixed Frame
//==========================================================
regs_short_t  front_init_vt_15_50hz_regs[] = {
/////// Start Sleep ///////
{0x01, 0xf9}, //sleep on
{0x08, 0x0f}, //Hi-Z on
{0x01, 0xf8}, //sleep off

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x03}, //PLL On
{0x0e, 0x73}, //x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x00}, //PLL off
{0x01, 0xf9}, //sleep on
{0x08, 0x00}, //Hi-Z off

{0x01, 0xfb},
{0x01, 0xf9},

/////// PAGE 20 ///////
{0x03, 0x20}, //page 20
{0x10, 0x1c}, //AE off 50hz

/////// PAGE 22 ///////
{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off


//Initial Start
/////// PAGE 0 START ///////
{0x03, 0x00},
{0x10, 0x19}, //Vsync Active High B:[3]
#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x94},
#else
{0x11, 0x96},
#endif
{0x12, 0x00}, //Pclk Falling Edge B:[2]

{0x0b, 0xaa},
{0x0c, 0xaa},
{0x0d, 0xaa},

{0x20, 0x00},
{0x21, 0x02}, //modify 20110929 0x04->0x02
{0x22, 0x00},
{0x23, 0x0a}, //modify 20110929 0x14->0x0a

{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},

{0x28, 0x0c},
{0x29, 0x04},
{0x2a, 0x02},
{0x2b, 0x04},
{0x2c, 0x06},
{0x2d, 0x02},

{0x40, 0x01}, //Hblank_360
{0x41, 0x68},
{0x42, 0x00},
{0x43, 0x14},

{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},

//BLC
{0x80, 0x2e},
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x06}, //BLC_TIME_TH_ON
{0x91, 0x06}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},

//Dark BLC
{0xa0, 0x00},
{0xa2, 0x00},
{0xa4, 0x00},
{0xa6, 0x00},

//Normal BLC
{0xa8, 0x43},
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},

//OutDoor  BLC
{0x99, 0x43},
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
/////// PAGE 0 END ///////

/////// PAGE 2 START ///////
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG//
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},

{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00},
{0x2f, 0x00},
{0x30, 0x05}, //For Hi-253 never no change 0x05

{0x50, 0x20},
{0x51, 0x03}, //20110826
{0x52, 0x01}, //0x03 --> 0x01
{0x53, 0xc1}, //20110818 ߰
{0x55, 0x1c},
{0x56, 0x11},
{0x5d, 0xa2},
{0x5e, 0x5a},

{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},

{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},

{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},

{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},

{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},

{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},

{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},

{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa},

{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},

{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x06}, //DCDC_TIME_TH_ON
{0xd5, 0x06}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},

{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},

/////// PAGE 2 END ///////

/////// PAGE 3 ///////
{0x03, 0x03},
{0x10, 0x10},
/////// PAGE 3 END ///////

/////// PAGE 10 START ///////
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},

{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x02}, //For Preview

{0x40, 0x80},
{0x41, 0x00},

{0x60, 0x6b},
{0x61, 0x7a}, //77
{0x62, 0x79}, //77
{0x63, 0x50}, // Double_AG 50->30
{0x64, 0x41},

{0x66, 0x42},
{0x67, 0x20},

{0x6a, 0x80}, //8a
{0x6b, 0x84}, //74
{0x6c, 0x7a}, //7e
{0x6d, 0x80}, //8e

/////// PAGE 11 START ///////
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, // Blue Max-Filter Delete
{0x13, 0xbb},

{0x26, 0x31}, // Double_AG 31->20
{0x27, 0x34}, // Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},

//Out2 D-LPF th
{0x30, 0x70},
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},

//Out1 D-LPF th
{0x36, 0x70},
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x09},
{0x3a, 0x06},
{0x3b, 0x03},

//Indoor D-LPF th
{0x3c, 0x80},
{0x3d, 0x18},
{0x3e, 0x80},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},

//Dark1 D-LPF th
{0x42, 0x80},
{0x43, 0x18},
{0x44, 0x80},
{0x45, 0x12},
{0x46, 0x10},
{0x47, 0x10},

//Dark2 D-LPF th
{0x48, 0x90},
{0x49, 0x40},
{0x4a, 0x80},
{0x4b, 0x13},
{0x4c, 0x10},
{0x4d, 0x11},

//Dark3 D-LPF th
{0x4e, 0x80},
{0x4f, 0x30},
{0x50, 0x80},
{0x51, 0x13},
{0x52, 0x10},
{0x53, 0x13},

{0x54, 0x11},
{0x55, 0x17},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},

{0x5a, 0x18},
{0x5b, 0x00},
{0x5c, 0x00},

{0x60, 0x3f},
{0x62, 0x60},
{0x70, 0x06},
/////// PAGE 11 END ///////

/////// PAGE 12 START ///////
{0x03, 0x12},
{0x20, 0x00},
{0x21, 0x00},

{0x25, 0x00}, //0x30

{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},

{0x30, 0x50},
{0x31, 0x18},
{0x32, 0x32},
{0x33, 0x40},
{0x34, 0x50},
{0x35, 0x70},
{0x36, 0xa0},

//Out2 th
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},

//Out1 th
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xa0},
{0x49, 0x90},
{0x4a, 0x90},
{0x4b, 0x80},

//Indoor th
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0x90},
{0x4f, 0x90},
{0x50, 0xa0},
{0x51, 0x80},

//Dark1 th
{0x52, 0xb0},
{0x53, 0x60},
{0x54, 0xc0},
{0x55, 0xc0},
{0x56, 0xc0},
{0x57, 0x80},

//Dark2 th
{0x58, 0x90},
{0x59, 0x40},
{0x5a, 0xd0},
{0x5b, 0xd0},
{0x5c, 0xe0},
{0x5d, 0x80},

//Dark3 th
{0x5e, 0x88},
{0x5f, 0x40},
{0x60, 0xe0},
{0x61, 0xe0},
{0x62, 0xe0},
{0x63, 0x80},

{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register

{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register

{0x74, 0x25},
{0x75, 0x15},

{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x00}, //For Preview

//Dont Touch register
{0xD0, 0x0c},
{0xD1, 0x80},

//only for Preview DPC 
{0xD2, 0x17},

{0xD3, 0x00},
{0xD4, 0x00},

//only for Preview DPC 
{0xd5, 0x0f},

{0xD6, 0xff},

//only for Preview DPC 
{0xd7, 0xff},

//End
{0x3b, 0x06},
{0x3c, 0x06},

//Dont Touch register
{0xc5, 0x30},//55->48
{0xc6, 0x2a},//48->40
/////// PAGE 12 END ///////

/////// PAGE 13 START ///////
{0x03, 0x13},
//Edge
{0x10, 0xcb},
{0x11, 0x7b},
{0x12, 0x07},
{0x14, 0x00},

{0x20, 0x15},
{0x21, 0x13},
{0x22, 0x33},
{0x23, 0x05},
{0x24, 0x09},

{0x25, 0x0a},

{0x26, 0x18},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},

//Low clip th
{0x2b, 0x02},
{0x2c, 0x02},
{0x25, 0x06},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},

//Out2 Edge
{0x50, 0x10},
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0c},

//Out1 Edge
{0x56, 0x10},
{0x57, 0x13},
{0x58, 0x12},
{0x59, 0x0c},
{0x5a, 0x0f},
{0x5b, 0x0c},

//Indoor Edge
{0x5c, 0x0a},
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},

//Dark1 Edge
{0x62, 0x08},
{0x63, 0x08},
{0x64, 0x08},
{0x65, 0x06},
{0x66, 0x06},
{0x67, 0x06},

//Dark2 Edge
{0x68, 0x07},
{0x69, 0x07},
{0x6a, 0x07},
{0x6b, 0x05},
{0x6c, 0x05},
{0x6d, 0x05},

//Dark3 Edge
{0x6e, 0x07},
{0x6f, 0x07},
{0x70, 0x07},
{0x71, 0x05},
{0x72, 0x05},
{0x73, 0x05},

//2DY
{0x80, 0x00},
{0x81, 0x1f},
{0x82, 0x05},
{0x83, 0x31},

{0x90, 0x05},
{0x91, 0x05},
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x03},
{0x95, 0x14},
{0x97, 0x20},
{0x99, 0x20},

{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x05},
{0xa5, 0x05},
{0xa6, 0x07},
{0xa7, 0x08},
{0xa8, 0x07},
{0xa9, 0x08},
{0xaa, 0x07},
{0xab, 0x08},

//Out2
{0xb0, 0x22},
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},

//Out1
{0xb6, 0x22},
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},

//Indoor
{0xbc, 0x25},
{0xbd, 0x2a},
{0xbe, 0x27},
{0xbf, 0x25},
{0xc0, 0x2a},
{0xc1, 0x27},

//Dark1
{0xc2, 0x1e},
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},

//Dark2
{0xc8, 0x18},
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},

//Dark3
{0xce, 0x18},
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
/////// PAGE 13 END ///////

/////// PAGE 14 START ///////
{0x03, 0x14},
{0x10, 0x11},

{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY

{0x20, 0x80}, //X
{0x21, 0x80}, //Y

{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},

{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},

{0x40, 0x3e},
{0x50, 0x28}, //2d
{0x60, 0x24}, //26
{0x70, 0x28}, //2d
/////// PAGE 14 END ///////

/////// PAGE 15 START ///////
{0x03, 0x15},
{0x10, 0x0f},

//Rstep H 16
//Rstep L 14
{0x14, 0x46}, //CMCOFSGH
{0x15, 0x36}, //CMCOFSGM
{0x16, 0x26}, //CMCOFSGL
{0x17, 0x2f}, //CMC SIGN

//CMC
{0x30, 0x8f},
{0x31, 0x59},
{0x32, 0x0a},
{0x33, 0x15},
{0x34, 0x5b},
{0x35, 0x06},
{0x36, 0x07},
{0x37, 0x40},
{0x38, 0x87}, //86

//CMC OFS
{0x40, 0x94},
{0x41, 0x20},
{0x42, 0x89},
{0x43, 0x84},
{0x44, 0x03},
{0x45, 0x01},
{0x46, 0x88},
{0x47, 0x9c},
{0x48, 0x28},

//CMC POFS
{0x50, 0x02},
{0x51, 0x82},
{0x52, 0x00},
{0x53, 0x07},
{0x54, 0x11},
{0x55, 0x98},
{0x56, 0x00},
{0x57, 0x0b},
{0x58, 0x8b},

{0x80, 0x03},
{0x85, 0x40},
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
/////// PAGE 15 END ///////

/////// PAGE 16 START ///////
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e},// Double_AG 5e->37
{0x19, 0x5d},// Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},

//GMA Default
{0x30, 0x00},
{0x31, 0x0a},
{0x32, 0x1f},
{0x33, 0x33},
{0x34, 0x53},
{0x35, 0x6c},
{0x36, 0x81},
{0x37, 0x94},
{0x38, 0xa4},
{0x39, 0xb3},
{0x3a, 0xc0},
{0x3b, 0xcb},
{0x3c, 0xd5},
{0x3d, 0xde},
{0x3e, 0xe6},
{0x3f, 0xee},
{0x40, 0xf5},
{0x41, 0xfc},
{0x42, 0xff},

{0x50, 0x00},
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x5a},
{0x55, 0x75},
{0x56, 0x8d},
{0x57, 0xa1},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc9},
{0x5b, 0xd2},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},

{0x70, 0x00},
{0x71, 0x08},
{0x72, 0x17},
{0x73, 0x2f},
{0x74, 0x53},
{0x75, 0x6c},
{0x76, 0x81},
{0x77, 0x94},
{0x78, 0xa4},
{0x79, 0xb3},
{0x7a, 0xc0},
{0x7b, 0xcb},
{0x7c, 0xd5},
{0x7d, 0xde},
{0x7e, 0xe6},
{0x7f, 0xee},
{0x80, 0xf4},
{0x81, 0xfa},
{0x82, 0xff},
/////// PAGE 16 END ///////

/////// PAGE 17 START ///////
{0x03, 0x17},
{0x10, 0xf7},
/////// PAGE 17 END ///////

/////// PAGE 20 START ///////
{0x03, 0x20},
{0x11, 0x1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x05},
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},

{0x28, 0xef},
{0x29, 0x0d}, //20100305 ad->0d
{0x2a, 0x03},
{0x2b, 0xf5},

{0x2c, 0xc2},
{0x2d, 0xff},
{0x2e, 0x33},
{0x30, 0xf8},
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x3a, 0xde},
{0x3c, 0xde},

{0x50, 0x45},
{0x51, 0x88},

{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},

{0x60, 0xaa},
{0x61, 0xaa},
{0x62, 0xaa},
{0x63, 0xaa},
{0x64, 0xaa},
{0x65, 0xaa},
{0x66, 0xab},
{0x67, 0xEa},
{0x68, 0xab},
{0x69, 0xEa},
{0x6a, 0xaa},
{0x6b, 0xaa},
{0x6c, 0xaa},
{0x6d, 0xaa},
{0x6e, 0xaa},
{0x6f, 0xaa},

{0x70, 0x70}, //6c
{0x71, 0x82}, //82(+8)

{0x76, 0x43},
{0x77, 0x02},
{0x78, 0x24}, //24
{0x79, 0x48}, // Y Target 70 => 25, 72 => 26 //
{0x7a, 0x23}, //23
{0x7b, 0x22}, //22
{0x7d, 0x23},

{0x83, 0x01}, //EXP Normal 33.33 fps
{0x84, 0x5f},
{0x85, 0x90},

{0x86, 0x01}, //EXPMin 6000.00 fps
{0x87, 0xf4},

{0x88, 0x02}, //EXP Max 16.67 fps
{0x89, 0xbf},
{0x8a, 0x20},

{0x8B, 0x75}, //EXP100, PLLx2 Mclk24
{0x8C, 0x30},

{0x8D, 0x61}, //EXP120, PLLx2 Mclk24
{0x8E, 0xa8},

{0x91, 0x03}, //EXP Fix 14.91 fps
{0x92, 0x12},
{0x93, 0x22},

{0x98, 0x9d}, //9d
{0x99, 0x45},
{0x9a, 0x0d},
{0x9b, 0xde},

{0x9c, 0x17}, //EXP Limit 500.00 fps, PLLx2 Mclk24
{0x9d, 0x70},

{0x9e, 0x01}, //EXP Unit, PLLx2 Mclk24
{0x9f, 0xf4},

{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xe0},
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x32},
{0xbd, 0x32},

{0xc0, 0x10},
{0xc1, 0x2b},
{0xc2, 0x2b},
{0xc3, 0x2b},
{0xc4, 0x08},

{0xc8, 0x40},
{0xc9, 0x40},
/////// PAGE 20 END ///////

/////// PAGE 22 START ///////
{0x03, 0x22},
{0x10, 0xfd},
{0x11, 0x2e},
{0x19, 0x01}, // Low On //
{0x20, 0x10},
{0x21, 0x80},
{0x24, 0x01},
//{0x25, 0x00}, //7f New Lock Cond & New light stable

{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x11},
{0x39, 0x34},
{0x40, 0xf3},

{0x41, 0x32}, //33 //44
{0x42, 0x22}, //22 //43
{0x43, 0xf0}, //f6
{0x44, 0x44}, //44
{0x45, 0x44}, //33
{0x46, 0x00},
{0x50, 0xb2},
{0x51, 0x81},
{0x52, 0x98},

{0x80, 0x38},
{0x81, 0x20},
{0x82, 0x36}, //3a

{0x83, 0x5e}, //5e
{0x84, 0x21}, //24
{0x85, 0x51}, //54
{0x86, 0x20}, //24 //22

{0x87, 0x49},
{0x88, 0x39},
{0x89, 0x37}, //38
{0x8a, 0x29}, //2a

{0x8b, 0x41}, //47
{0x8c, 0x39},
{0x8d, 0x34},
{0x8e, 0x29}, //2c

{0x8f,	0x5c},
{0x90,	0x5b},
{0x91,	0x57},
{0x92,	0x4f},
{0x93,	0x43},
{0x94,	0x3e},
{0x95,	0x34},
{0x96,	0x2c},
{0x97, 0x23},
{0x98, 0x20},
{0x99, 0x1f},
{0x9a, 0x1f},

{0x9b, 0x77},
{0x9c, 0x66},
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},

{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},

{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, // 700fps
{0xa6, 0xcf},

{0xad, 0x40},
{0xae, 0x4a},

{0xaf, 0x28},  // low temp Rgain
{0xb0, 0x26},  // low temp Rgain

{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xb0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
/////// PAGE 22 END ///////

/////// PAGE 20 ///////
{0x03, 0x20},
{0x10, 0x9c}, //AE on 50hz

/////// PAGE 22 ///////
{0x03, 0x22},
{0x10, 0xe9},

/////// PAGE 0 ///////
{0x03, 0x00},
{0x0e, 0x03},
{0x0e, 0x73},

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00},
{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//

};

regs_short_t  front_init_vt_15_60hz_regs[] = {
/////// Start Sleep ///////
{0x01, 0xf9}, //sleep on
{0x08, 0x0f}, //Hi-Z on
{0x01, 0xf8}, //sleep off

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x03}, //PLL On
{0x0e, 0x73}, //x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x0e, 0x00}, //PLL off
{0x01, 0xf9}, //sleep on
{0x08, 0x00}, //Hi-Z off

{0x01, 0xfb},
{0x01, 0xf9},

/////// PAGE 20 ///////
{0x03, 0x20}, //page 20
{0x10, 0x0c}, //AE off 60hz

/////// PAGE 22 ///////
{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off


//Initial Start
/////// PAGE 0 START ///////
{0x03, 0x00},
{0x10, 0x19}, //Vsync Active High B:[3]
#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x94},
#else
{0x11, 0x96},
#endif
{0x12, 0x00}, //Pclk Falling Edge B:[2]

{0x0b, 0xaa},
{0x0c, 0xaa},
{0x0d, 0xaa},

{0x20, 0x00},
{0x21, 0x02}, //modify 20110929 0x04->0x02
{0x22, 0x00},
{0x23, 0x0a}, //modify 20110929 0x14->0x0a

{0x24, 0x04},
{0x25, 0xb0},
{0x26, 0x06},
{0x27, 0x40},

{0x28, 0x0c},
{0x29, 0x04},
{0x2a, 0x02},
{0x2b, 0x04},
{0x2c, 0x06},
{0x2d, 0x02},

{0x40, 0x01}, //Hblank_360
{0x41, 0x68},
{0x42, 0x00},
{0x43, 0x14},

{0x45, 0x04},
{0x46, 0x18},
{0x47, 0xd8},

//BLC
{0x80, 0x2e},
{0x81, 0x7e},
{0x82, 0x90},
{0x83, 0x00},
{0x84, 0x0c},
{0x85, 0x00},
{0x90, 0x08}, //BLC_TIME_TH_ON
{0x91, 0x08}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF
{0x94, 0xff},
{0x95, 0xff},
{0x96, 0xdc},
{0x97, 0xfe},
{0x98, 0x38},

//Dark BLC
{0xa0, 0x00},
{0xa2, 0x00},
{0xa4, 0x00},
{0xa6, 0x00},

//Normal BLC
{0xa8, 0x43},
{0xaa, 0x43},
{0xac, 0x43},
{0xae, 0x43},

//OutDoor  BLC
{0x99, 0x43},
{0x9a, 0x43},
{0x9b, 0x43},
{0x9c, 0x43},
/////// PAGE 0 END ///////

/////// PAGE 2 START ///////
{0x03, 0x02},
{0x12, 0x03},
{0x13, 0x03},
{0x16, 0x00},
{0x17, 0x8C},
{0x18, 0x4c}, //Double_AG//
{0x19, 0x00},
{0x1a, 0x39}, //Double_AG/ 38 ->39
{0x1c, 0x09},
{0x1d, 0x40},
{0x1e, 0x30},
{0x1f, 0x10},

{0x20, 0x77},
{0x21, 0xde},
{0x22, 0xa7},
{0x23, 0x30}, //CLAMP
{0x27, 0x3c},
{0x2b, 0x80},
{0x2e, 0x00},
{0x2f, 0x00},
{0x30, 0x05}, //For Hi-253 never no change 0x05

{0x50, 0x20},
{0x51, 0x03}, //20110826
{0x52, 0x01}, //0x03 --> 0x01
{0x53, 0xc1}, //20110818 ߰
{0x55, 0x1c},
{0x56, 0x11},
{0x5d, 0xa2},
{0x5e, 0x5a},

{0x60, 0x87},
{0x61, 0x99},
{0x62, 0x88},
{0x63, 0x97},
{0x64, 0x88},
{0x65, 0x97},

{0x67, 0x0c},
{0x68, 0x0c},
{0x69, 0x0c},

{0x72, 0x89},
{0x73, 0x96},
{0x74, 0x89},
{0x75, 0x96},
{0x76, 0x89},
{0x77, 0x96},

{0x7c, 0x85},
{0x7d, 0xaf},
{0x80, 0x01},
{0x81, 0x7f},
{0x82, 0x13},
{0x83, 0x24},
{0x84, 0x7d},
{0x85, 0x81},
{0x86, 0x7d},
{0x87, 0x81},

{0x92, 0x48},
{0x93, 0x54},
{0x94, 0x7d},
{0x95, 0x81},
{0x96, 0x7d},
{0x97, 0x81},

{0xa0, 0x02},
{0xa1, 0x7b},
{0xa2, 0x02},
{0xa3, 0x7b},
{0xa4, 0x7b},
{0xa5, 0x02},
{0xa6, 0x7b},
{0xa7, 0x02},

{0xa8, 0x85},
{0xa9, 0x8c},
{0xaa, 0x85},
{0xab, 0x8c},
{0xac, 0x10},
{0xad, 0x16},
{0xae, 0x10},
{0xaf, 0x16},

{0xb0, 0x99},
{0xb1, 0xa3},
{0xb2, 0xa4},
{0xb3, 0xae},
{0xb4, 0x9b},
{0xb5, 0xa2},
{0xb6, 0xa6},
{0xb7, 0xac},
{0xb8, 0x9b},
{0xb9, 0x9f},
{0xba, 0xa6},
{0xbb, 0xaa},
{0xbc, 0x9b},
{0xbd, 0x9f},
{0xbe, 0xa6},
{0xbf, 0xaa},

{0xc4, 0x2c},
{0xc5, 0x43},
{0xc6, 0x63},
{0xc7, 0x79},

{0xc8, 0x2d},
{0xc9, 0x42},
{0xca, 0x2d},
{0xcb, 0x42},
{0xcc, 0x64},
{0xcd, 0x78},
{0xce, 0x64},
{0xcf, 0x78},
{0xd0, 0x0a},
{0xd1, 0x09},
{0xd4, 0x08}, //DCDC_TIME_TH_ON
{0xd5, 0x08}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF
{0xe0, 0xc4},
{0xe1, 0xc4},
{0xe2, 0xc4},
{0xe3, 0xc4},
{0xe4, 0x00},
{0xe8, 0x80},
{0xe9, 0x40},
{0xea, 0x7f},

{0xf0, 0x01},
{0xf1, 0x01},
{0xf2, 0x01},
{0xf3, 0x01},
{0xf4, 0x01},

/////// PAGE 2 END ///////

/////// PAGE 3 ///////
{0x03, 0x03},
{0x10, 0x10},
/////// PAGE 3 END ///////

/////// PAGE 10 START ///////
{0x03, 0x10},
{0x10, 0x03}, // CrYCbY // For Demoset 0x03
{0x12, 0x30},
{0x20, 0x00},
{0x30, 0x00},
{0x31, 0x00},
{0x32, 0x00},
{0x33, 0x00},

{0x34, 0x30},
{0x35, 0x00},
{0x36, 0x00},
{0x38, 0x00},
{0x3e, 0x58},
{0x3f, 0x02}, //For Preview

{0x40, 0x80},
{0x41, 0x00},

{0x60, 0x6b},
{0x61, 0x7a}, //77
{0x62, 0x79}, //77
{0x63, 0x50}, // Double_AG 50->30
{0x64, 0x41},

{0x66, 0x42},
{0x67, 0x20},

{0x6a, 0x80}, //8a
{0x6b, 0x84}, //74
{0x6c, 0x7a}, //7e
{0x6d, 0x80}, //8e

/////// PAGE 11 START ///////
{0x03, 0x11},
{0x10, 0x7f},
{0x11, 0x40},
{0x12, 0x0a}, // Blue Max-Filter Delete
{0x13, 0xbb},

{0x26, 0x31}, // Double_AG 31->20
{0x27, 0x34}, // Double_AG 34->22
{0x28, 0x0f},
{0x29, 0x10},
{0x2b, 0x30},
{0x2c, 0x32},

//Out2 D-LPF th
{0x30, 0x70},
{0x31, 0x10},
{0x32, 0x58},
{0x33, 0x09},
{0x34, 0x06},
{0x35, 0x03},

//Out1 D-LPF th
{0x36, 0x70},
{0x37, 0x18},
{0x38, 0x58},
{0x39, 0x09},
{0x3a, 0x06},
{0x3b, 0x03},

//Indoor D-LPF th
{0x3c, 0x80},
{0x3d, 0x18},
{0x3e, 0x80},
{0x3f, 0x0c},
{0x40, 0x09},
{0x41, 0x06},

//Dark1 D-LPF th
{0x42, 0x80},
{0x43, 0x18},
{0x44, 0x80},
{0x45, 0x12},
{0x46, 0x10},
{0x47, 0x10},

//Dark2 D-LPF th
{0x48, 0x90},
{0x49, 0x40},
{0x4a, 0x80},
{0x4b, 0x13},
{0x4c, 0x10},
{0x4d, 0x11},

//Dark3 D-LPF th
{0x4e, 0x80},
{0x4f, 0x30},
{0x50, 0x80},
{0x51, 0x13},
{0x52, 0x10},
{0x53, 0x13},

{0x54, 0x11},
{0x55, 0x17},
{0x56, 0x20},
{0x57, 0x01},
{0x58, 0x00},
{0x59, 0x00},

{0x5a, 0x18},
{0x5b, 0x00},
{0x5c, 0x00},

{0x60, 0x3f},
{0x62, 0x60},
{0x70, 0x06},
/////// PAGE 11 END ///////

/////// PAGE 12 START ///////
{0x03, 0x12},
{0x20, 0x00},
{0x21, 0x00},

{0x25, 0x00}, //0x30

{0x28, 0x00},
{0x29, 0x00},
{0x2a, 0x00},

{0x30, 0x50},
{0x31, 0x18},
{0x32, 0x32},
{0x33, 0x40},
{0x34, 0x50},
{0x35, 0x70},
{0x36, 0xa0},

//Out2 th
{0x40, 0xa0},
{0x41, 0x40},
{0x42, 0xa0},
{0x43, 0x90},
{0x44, 0x90},
{0x45, 0x80},

//Out1 th
{0x46, 0xb0},
{0x47, 0x55},
{0x48, 0xa0},
{0x49, 0x90},
{0x4a, 0x90},
{0x4b, 0x80},

//Indoor th
{0x4c, 0xb0},
{0x4d, 0x40},
{0x4e, 0x90},
{0x4f, 0x90},
{0x50, 0xa0},
{0x51, 0x80},

//Dark1 th
{0x52, 0xb0},
{0x53, 0x60},
{0x54, 0xc0},
{0x55, 0xc0},
{0x56, 0xc0},
{0x57, 0x80},

//Dark2 th
{0x58, 0x90},
{0x59, 0x40},
{0x5a, 0xd0},
{0x5b, 0xd0},
{0x5c, 0xe0},
{0x5d, 0x80},

//Dark3 th
{0x5e, 0x88},
{0x5f, 0x40},
{0x60, 0xe0},
{0x61, 0xe0},
{0x62, 0xe0},
{0x63, 0x80},

{0x70, 0x15},
{0x71, 0x01}, //Don't Touch register

{0x72, 0x18},
{0x73, 0x01}, //Don't Touch register

{0x74, 0x25},
{0x75, 0x15},

{0x80, 0x20},
{0x81, 0x40},
{0x82, 0x65},
{0x85, 0x1a},
{0x88, 0x00},
{0x89, 0x00},
{0x90, 0x00}, //For Preview

//Dont Touch register
{0xD0, 0x0c},
{0xD1, 0x80},

//only for Preview DPC 
{0xD2, 0x17},

{0xD3, 0x00},
{0xD4, 0x00},

//only for Preview DPC 
{0xd5, 0x0f},

{0xD6, 0xff},

//only for Preview DPC 
{0xd7, 0xff},

//End
{0x3b, 0x06},
{0x3c, 0x06},

//Dont Touch register
{0xc5, 0x30},//55->48
{0xc6, 0x2a},//48->40
/////// PAGE 12 END ///////

/////// PAGE 13 START ///////
{0x03, 0x13},
//Edge
{0x10, 0xcb},
{0x11, 0x7b},
{0x12, 0x07},
{0x14, 0x00},

{0x20, 0x15},
{0x21, 0x13},
{0x22, 0x33},
{0x23, 0x05},
{0x24, 0x09},

{0x25, 0x0a},

{0x26, 0x18},
{0x27, 0x30},
{0x29, 0x12},
{0x2a, 0x50},

//Low clip th
{0x2b, 0x02},
{0x2c, 0x02},
{0x25, 0x06},
{0x2d, 0x0c},
{0x2e, 0x12},
{0x2f, 0x12},

//Out2 Edge
{0x50, 0x10},
{0x51, 0x14},
{0x52, 0x12},
{0x53, 0x0c},
{0x54, 0x0f},
{0x55, 0x0c},

//Out1 Edge
{0x56, 0x10},
{0x57, 0x13},
{0x58, 0x12},
{0x59, 0x0c},
{0x5a, 0x0f},
{0x5b, 0x0c},

//Indoor Edge
{0x5c, 0x0a},
{0x5d, 0x0b},
{0x5e, 0x0a},
{0x5f, 0x08},
{0x60, 0x09},
{0x61, 0x08},

//Dark1 Edge
{0x62, 0x08},
{0x63, 0x08},
{0x64, 0x08},
{0x65, 0x06},
{0x66, 0x06},
{0x67, 0x06},

//Dark2 Edge
{0x68, 0x07},
{0x69, 0x07},
{0x6a, 0x07},
{0x6b, 0x05},
{0x6c, 0x05},
{0x6d, 0x05},

//Dark3 Edge
{0x6e, 0x07},
{0x6f, 0x07},
{0x70, 0x07},
{0x71, 0x05},
{0x72, 0x05},
{0x73, 0x05},

//2DY
{0x80, 0x00},
{0x81, 0x1f},
{0x82, 0x05},
{0x83, 0x31},

{0x90, 0x05},
{0x91, 0x05},
{0x92, 0x33},
{0x93, 0x30},
{0x94, 0x03},
{0x95, 0x14},
{0x97, 0x20},
{0x99, 0x20},

{0xa0, 0x01},
{0xa1, 0x02},
{0xa2, 0x01},
{0xa3, 0x02},
{0xa4, 0x05},
{0xa5, 0x05},
{0xa6, 0x07},
{0xa7, 0x08},
{0xa8, 0x07},
{0xa9, 0x08},
{0xaa, 0x07},
{0xab, 0x08},

//Out2
{0xb0, 0x22},
{0xb1, 0x2a},
{0xb2, 0x28},
{0xb3, 0x22},
{0xb4, 0x2a},
{0xb5, 0x28},

//Out1
{0xb6, 0x22},
{0xb7, 0x2a},
{0xb8, 0x28},
{0xb9, 0x22},
{0xba, 0x2a},
{0xbb, 0x28},

//Indoor
{0xbc, 0x25},
{0xbd, 0x2a},
{0xbe, 0x27},
{0xbf, 0x25},
{0xc0, 0x2a},
{0xc1, 0x27},

//Dark1
{0xc2, 0x1e},
{0xc3, 0x24},
{0xc4, 0x20},
{0xc5, 0x1e},
{0xc6, 0x24},
{0xc7, 0x20},

//Dark2
{0xc8, 0x18},
{0xc9, 0x20},
{0xca, 0x1e},
{0xcb, 0x18},
{0xcc, 0x20},
{0xcd, 0x1e},

//Dark3
{0xce, 0x18},
{0xcf, 0x20},
{0xd0, 0x1e},
{0xd1, 0x18},
{0xd2, 0x20},
{0xd3, 0x1e},
/////// PAGE 13 END ///////

/////// PAGE 14 START ///////
{0x03, 0x14},
{0x10, 0x11},

{0x14, 0x80}, // GX
{0x15, 0x80}, // GY
{0x16, 0x80}, // RX
{0x17, 0x80}, // RY
{0x18, 0x80}, // BX
{0x19, 0x80}, // BY

{0x20, 0x80}, //X
{0x21, 0x80}, //Y

{0x22, 0x80},
{0x23, 0x80},
{0x24, 0x80},

{0x30, 0xc8},
{0x31, 0x2b},
{0x32, 0x00},
{0x33, 0x00},
{0x34, 0x90},

{0x40, 0x3e},
{0x50, 0x28}, //2d
{0x60, 0x24}, //26
{0x70, 0x28}, //2d
/////// PAGE 14 END ///////

/////// PAGE 15 START ///////
{0x03, 0x15},
{0x10, 0x0f},

//Rstep H 16
//Rstep L 14
{0x14, 0x46}, //CMCOFSGH
{0x15, 0x36}, //CMCOFSGM
{0x16, 0x26}, //CMCOFSGL
{0x17, 0x2f}, //CMC SIGN

//CMC
{0x30, 0x8f},
{0x31, 0x59},
{0x32, 0x0a},
{0x33, 0x15},
{0x34, 0x5b},
{0x35, 0x06},
{0x36, 0x07},
{0x37, 0x40},
{0x38, 0x87}, //86

//CMC OFS
{0x40, 0x94},
{0x41, 0x20},
{0x42, 0x89},
{0x43, 0x84},
{0x44, 0x03},
{0x45, 0x01},
{0x46, 0x88},
{0x47, 0x9c},
{0x48, 0x28},

//CMC POFS
{0x50, 0x02},
{0x51, 0x82},
{0x52, 0x00},
{0x53, 0x07},
{0x54, 0x11},
{0x55, 0x98},
{0x56, 0x00},
{0x57, 0x0b},
{0x58, 0x8b},

{0x80, 0x03},
{0x85, 0x40},
{0x87, 0x02},
{0x88, 0x00},
{0x89, 0x00},
{0x8a, 0x00},
/////// PAGE 15 END ///////

/////// PAGE 16 START ///////
{0x03, 0x16},
{0x10, 0x31},
{0x18, 0x5e},// Double_AG 5e->37
{0x19, 0x5d},// Double_AG 5e->36
{0x1a, 0x0e},
{0x1b, 0x01},
{0x1c, 0xdc},
{0x1d, 0xfe},

//GMA Default
{0x30, 0x00},
{0x31, 0x0a},
{0x32, 0x1f},
{0x33, 0x33},
{0x34, 0x53},
{0x35, 0x6c},
{0x36, 0x81},
{0x37, 0x94},
{0x38, 0xa4},
{0x39, 0xb3},
{0x3a, 0xc0},
{0x3b, 0xcb},
{0x3c, 0xd5},
{0x3d, 0xde},
{0x3e, 0xe6},
{0x3f, 0xee},
{0x40, 0xf5},
{0x41, 0xfc},
{0x42, 0xff},

{0x50, 0x00},
{0x51, 0x08},
{0x52, 0x1e},
{0x53, 0x36},
{0x54, 0x5a},
{0x55, 0x75},
{0x56, 0x8d},
{0x57, 0xa1},
{0x58, 0xb2},
{0x59, 0xbe},
{0x5a, 0xc9},
{0x5b, 0xd2},
{0x5c, 0xdb},
{0x5d, 0xe3},
{0x5e, 0xeb},
{0x5f, 0xf0},
{0x60, 0xf5},
{0x61, 0xf7},
{0x62, 0xf8},

{0x70, 0x00},
{0x71, 0x08},
{0x72, 0x17},
{0x73, 0x2f},
{0x74, 0x53},
{0x75, 0x6c},
{0x76, 0x81},
{0x77, 0x94},
{0x78, 0xa4},
{0x79, 0xb3},
{0x7a, 0xc0},
{0x7b, 0xcb},
{0x7c, 0xd5},
{0x7d, 0xde},
{0x7e, 0xe6},
{0x7f, 0xee},
{0x80, 0xf4},
{0x81, 0xfa},
{0x82, 0xff},
/////// PAGE 16 END ///////

/////// PAGE 17 START ///////
{0x03, 0x17},
{0x10, 0xf7},
/////// PAGE 17 END ///////

/////// PAGE 20 START ///////
{0x03, 0x20},
{0x11, 0x1c},
{0x18, 0x30},
{0x1a, 0x08},
{0x20, 0x05},
{0x21, 0x30},
{0x22, 0x10},
{0x23, 0x00},
{0x24, 0x00},

{0x28, 0xef},
{0x29, 0x0d}, //20100305 ad->0d
{0x2a, 0x03},
{0x2b, 0xf5},

{0x2c, 0xc2},
{0x2d, 0xff},
{0x2e, 0x33},
{0x30, 0xf8},
{0x32, 0x03},
{0x33, 0x2e},
{0x34, 0x30},
{0x35, 0xd4},
{0x36, 0xfe},
{0x37, 0x32},
{0x38, 0x04},
{0x3a, 0xde},
{0x3c, 0xde},

{0x50, 0x45},
{0x51, 0x88},

{0x56, 0x03},
{0x57, 0xf7},
{0x58, 0x14},
{0x59, 0x88},
{0x5a, 0x04},

{0x60, 0xaa},
{0x61, 0xaa},
{0x62, 0xaa},
{0x63, 0xaa},
{0x64, 0xaa},
{0x65, 0xaa},
{0x66, 0xab},
{0x67, 0xEa},
{0x68, 0xab},
{0x69, 0xEa},
{0x6a, 0xaa},
{0x6b, 0xaa},
{0x6c, 0xaa},
{0x6d, 0xaa},
{0x6e, 0xaa},
{0x6f, 0xaa},

{0x70, 0x70}, //6c
{0x71, 0x82}, //82(+8)

{0x76, 0x43},
{0x77, 0x02},
{0x78, 0x24}, //24
{0x79, 0x48}, // Y Target 70 => 25, 72 => 26 //
{0x7a, 0x23}, //23
{0x7b, 0x22}, //22
{0x7d, 0x23},

{0x83, 0x01}, //EXP Normal 30.00 fps
{0x84, 0x86},
{0x85, 0xa0},

{0x86, 0x01}, //EXPMin 6000.00 fps
{0x87, 0xf4},

{0x88, 0x03}, //EXP Max 15.00 fps
{0x89, 0x0d},
{0x8a, 0x40},

{0x8B, 0x75}, //EXP100, PLLx2 Mclk24
{0x8C, 0x30},

{0x8D, 0x61}, //EXP120, PLLx2 Mclk24
{0x8E, 0xa8},

{0x91, 0x03}, //EXP Fix 14.91 fps
{0x92, 0x12},
{0x93, 0x22},

{0x98, 0x9d}, //9d
{0x99, 0x45},
{0x9a, 0x0d},
{0x9b, 0xde},

{0x9c, 0x17}, //EXP Limit 500.00 fps, PLLx2 Mclk24
{0x9d, 0x70},

{0x9e, 0x01}, //EXP Unit, PLLx2 Mclk24
{0x9f, 0xf4},

{0xb0, 0x18},
{0xb1, 0x14},
{0xb2, 0xe0},
{0xb3, 0x18},
{0xb4, 0x1a},
{0xb5, 0x44},
{0xb6, 0x2f},
{0xb7, 0x28},
{0xb8, 0x25},
{0xb9, 0x22},
{0xba, 0x21},
{0xbb, 0x20},
{0xbc, 0x32},
{0xbd, 0x32},

{0xc0, 0x10},
{0xc1, 0x2b},
{0xc2, 0x2b},
{0xc3, 0x2b},
{0xc4, 0x08},

{0xc8, 0x40},
{0xc9, 0x40},
/////// PAGE 20 END ///////

/////// PAGE 22 START ///////
{0x03, 0x22},
{0x10, 0xfd},
{0x11, 0x2e},
{0x19, 0x01}, // Low On //
{0x20, 0x10},
{0x21, 0x80},
{0x24, 0x01},
//{0x25, 0x00}, //7f New Lock Cond & New light stable

{0x30, 0x80},
{0x31, 0x80},
{0x38, 0x11},
{0x39, 0x34},
{0x40, 0xf3},

{0x41, 0x32}, //33 //44
{0x42, 0x22}, //22 //43
{0x43, 0xf0}, //f6
{0x44, 0x44}, //44
{0x45, 0x44}, //33
{0x46, 0x00},
{0x50, 0xb2},
{0x51, 0x81},
{0x52, 0x98},

{0x80, 0x38},
{0x81, 0x20},
{0x82, 0x36}, //3a

{0x83, 0x5e}, //5e
{0x84, 0x21}, //24
{0x85, 0x51}, //54
{0x86, 0x20}, //24 //22

{0x87, 0x49},
{0x88, 0x39},
{0x89, 0x37}, //38
{0x8a, 0x29}, //2a

{0x8b, 0x41}, //47
{0x8c, 0x39},
{0x8d, 0x34},
{0x8e, 0x29}, //2c

{0x8f,	0x5c},
{0x90,	0x5b},
{0x91,	0x57},
{0x92,	0x4f},
{0x93,	0x43},
{0x94,	0x3e},
{0x95,	0x34},
{0x96,	0x2c},
{0x97, 0x23},
{0x98, 0x20},
{0x99, 0x1f},
{0x9a, 0x1f},

{0x9b, 0x77},
{0x9c, 0x66},
{0x9d, 0x48},
{0x9e, 0x38},
{0x9f, 0x30},

{0xa0, 0x60},
{0xa1, 0x34},
{0xa2, 0x6f},
{0xa3, 0xff},

{0xa4, 0x14}, //1500fps
{0xa5, 0x2c}, // 700fps
{0xa6, 0xcf},

{0xad, 0x40},
{0xae, 0x4a},

{0xaf, 0x28},  // low temp Rgain
{0xb0, 0x26},  // low temp Rgain

{0xb1, 0x00}, //0x20 -> 0x00 0405 modify
{0xb4, 0xea},
{0xb8, 0xb0}, //a2: b-2, R+2  //b4 B-3, R+4 lowtemp
{0xb9, 0x00},
/////// PAGE 22 END ///////

/////// PAGE 20 ///////
{0x03, 0x20},
{0x10, 0x8c}, //AE on 60hz

/////// PAGE 22 ///////
{0x03, 0x22},
{0x10, 0xe9},

/////// PAGE 0 ///////
{0x03, 0x00},
{0x0e, 0x03},
{0x0e, 0x73},

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00},
{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//

};

regs_short_t front_preview_camera_50hz_regs[] = {

{0x03, 0x00}, //Sleep On
{0x01, 0xf9},

{0x0e, 0x03}, //Pll off

{0x03, 0x20}, //page 20
{0x18, 0x30}, //for Preview
{0x10, 0x1c}, //AE off 50hz

{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off

{0x03, 0x00},
{0x10, 0x19},

#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x90},
#else
{0x11, 0x92},
#endif

{0x20, 0x00},
{0x21, 0x02}, //modify 20110929 0x04->0x02
{0x22, 0x00},
{0x23, 0x0a}, //modify 20110929 0x14->0x0a

{0x42, 0x00}, //VBlank
{0x43, 0x58}, //88

//Page10
{0x03, 0x10},
{0x3f, 0x02},
{0x60, 0x6b},

//Page12
{0x03, 0x12},
{0x20, 0x00},
{0x21, 0x00},
{0x90, 0x00},

//only for Preview DPC 
{0xd2, 0x17},
{0xd5, 0x0f},
{0xd7, 0xff},

//Page13
{0x03, 0x13},
{0x80, 0x00},

{0x03, 0x20},
{0x10, 0x9c}, //AE on 50hz

{0x03, 0x22},
{0x10, 0xe9}, //AWB ON

{0x03, 0x00},
{0x0e, 0x03}, //PLL ON
{0x0e, 0x73}, // x2

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00}, //Sleep Off
{0x01, 0xf8},

{0xff, 0x28}, //400ms

};

regs_short_t front_preview_camera_60hz_regs[] = {

{0x03, 0x00}, //Sleep On
{0x01, 0xf9},

{0x0e, 0x03}, //Pll off

{0x03, 0x20}, //page 20
{0x18, 0x30}, //for Preview
{0x10, 0x0c}, //AE off 60hz

{0x03, 0x22}, //page 22
{0x10, 0x69}, //awb off

{0x03, 0x00},
{0x10, 0x19},

#if 1 /* defined(CONFIG_MACH_P2_REV02) */
{0x11, 0x90},
#else
{0x11, 0x92},
#endif

{0x20, 0x00},
{0x21, 0x02}, //modify 20110929 0x04->0x02
{0x22, 0x00},
{0x23, 0x0a}, //modify 20110929 0x14->0x0a

{0x42, 0x00}, //VBlank
{0x43, 0x44}, //68

//Page10
{0x03, 0x10},
{0x3f, 0x02},
{0x60, 0x6b},

//Page12
{0x03, 0x12},
{0x20, 0x00},
{0x21, 0x00},
{0x90, 0x00},

//only for Preview DPC 
{0xd2, 0x17},
{0xd5, 0x0f},
{0xd7, 0xff},

//Page13
{0x03, 0x13},
{0x80, 0x00},

{0x03, 0x20},
{0x10, 0x8c}, //AE on 60hz

{0x03, 0x22},
{0x10, 0xe9}, //AWB ON

{0x03, 0x00},
{0x0e, 0x03}, //PLL ON
{0x0e, 0x73}, // x2

{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00}, //Sleep Off
{0x01, 0xf8},

{0xff, 0x28}, //400ms

};

regs_short_t front_snapshot_normal_regs[] = {
{0x03, 0x00},
{0x01, 0xf9},

{0x0e, 0x03}, //PLL Off

{0x03, 0x22}, //Page 22
{0x10, 0x69}, //AWB Off

{0x03, 0x00},
{0x10, 0x08},
{0x11, 0x90},

{0x20, 0x00},
{0x21, 0x0a}, //modify 20110929 0x0c->0x0a
{0x22, 0x00},
{0x23, 0x0a}, //modify 20110929 0x14->0x0a

//Page10
{0x03, 0x10},
{0x3f, 0x00},
{0x60, 0x67},

//Page12
{0x03, 0x12},
{0x20, 0x0f},
{0x21, 0x0f},
{0x90, 0x5d},

//only for Preview DPC Off
{0xd2, 0x67},
{0xd5, 0x02},
{0xd7, 0x18},

//Page13
{0x03, 0x13},
{0x80, 0xfd},

//Page0
{0x03, 0x00},
{0x03, 0x00},
{0x0e, 0x03}, //PLL ON
{0x0e, 0x73}, //PLL ON x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x03, 0x00},
{0x01, 0xf8}, //Sleep Off

{0xff, 0x03},  //Increase from 30ms
};

regs_short_t front_ev_minus_4_regs[] = {
{0x03, 0x10},
{0x40, 0xd0},
};

regs_short_t front_ev_minus_3_regs[] = {
{0x03, 0x10},
{0x40, 0xc0},
};

regs_short_t front_ev_minus_2_regs[] = {
{0x03, 0x10},
{0x40, 0xb0},
};

regs_short_t front_ev_minus_1_regs[] = {
{0x03, 0x10},
{0x40, 0xa0},
};

regs_short_t front_ev_default_regs[] = {
{0x03, 0x10},
{0x40, 0x00},
};

regs_short_t front_ev_plus_1_regs[] = {
{0x03, 0x10},
{0x40, 0x20},
};

regs_short_t front_ev_plus_2_regs[] = {
{0x03, 0x10},
{0x40, 0x30},
};

regs_short_t front_ev_plus_3_regs[] = {
{0x03, 0x10},
{0x40, 0x40},
};

regs_short_t front_ev_plus_4_regs[] = {
{0x03, 0x10},
{0x40, 0x50},
};

regs_short_t front_wb_auto_regs[] = {
{0x03, 0x22},
{0x11, 0x2e},  	//awbctrl2
{0x80, 0x38},
{0x81, 0x20},
{0x82, 0x36}, //3a
{0x83, 0x5e}, //5e
{0x84, 0x21}, //24
{0x85, 0x51}, //54
{0x86, 0x20}, //24 //22
};

regs_short_t front_wb_sunny_regs[] = {
{0x03, 0x22},
{0x11, 0x2c},
{0x80, 0x52},
{0x81, 0x20},
{0x82, 0x27},
{0x83, 0x58},
{0x84, 0x4d},
{0x85, 0x2c},
{0x86, 0x22},
};

regs_short_t front_wb_cloudy_regs[] = {
{0x03, 0x22},
{0x11, 0x2c},
{0x80, 0x71},//71 //R
{0x81, 0x20},//1e //G //1b
{0x82, 0x20},//1f //B 1c
{0x83, 0x72},//72 // Rmax 6f
{0x84, 0x6e},//70 70 // Rmin 68
{0x85, 0x21},//20 // Bmax 1b
{0x86, 0x1f},//1e // Bmin 16
};

regs_short_t front_wb_tungsten_regs[] = {
{0x03, 0x22},
{0x11, 0x2c},
{0x80, 0x20},
{0x81, 0x20},
{0x82, 0x58},
{0x83, 0x23},
{0x84, 0x1f},
{0x85, 0x58},
{0x86, 0x52},
};

regs_short_t front_wb_fluorescent_regs[] = {
{0x03, 0x22},
{0x11, 0x2c},
{0x80, 0x3d},
{0x81, 0x20},
{0x82, 0x4a},
{0x83, 0x42},
{0x84, 0x3c},
{0x85, 0x51},
{0x86, 0x47},
};

regs_short_t front_effect_normal_regs[] = {
{0x03, 0x10},
{0x11, 0x03},
{0x12, 0x30},
{0x44, 0x80},
{0x45, 0x80},
};

regs_short_t front_effect_negative_regs[] = {
{0x03, 0x10},
{0x11, 0x03},
{0x12, 0x38},
{0x13, 0x08},
{0x44, 0x80},
{0x45, 0x80},
};

regs_short_t front_effect_sepia_regs[] = {
{0x03, 0x10},
{0x11, 0x03},
{0x12, 0x33},
{0x13, 0x08},
{0x44, 0x70},
{0x45, 0x98},
};

regs_short_t front_effect_mono_regs[] = {
{0x03, 0x10},
{0x11, 0x03},
{0x12, 0x33},
{0x13, 0x08},
{0x44, 0x80},
{0x45, 0x80},
};

regs_short_t front_fps_auto_regs[] = {
};

regs_short_t front_fps_7_50hz_regs[] = {
{0x03, 0x00},
{0x01, 0xf9},
{0x0e, 0x03}, //PLL Off
{0x11, 0x90},

{0x40, 0x01}, //Hblank 360
{0x41, 0x68},
{0x42, 0x00}, //Vsync 20
{0x43, 0x14},

{0x90, 0x0e}, //BLC_TIME_TH_ON
{0x91, 0x0e}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF

{0x03, 0x02}, //PAGE 2
{0xd4, 0x0e}, //DCDC_TIME_TH_ON
{0xd5, 0x0e}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF

{0x03, 0x20},
{0x10, 0x1C}, //AE off 50hz

{0x03, 0x22},
{0x10, 0x69},

{0x03, 0x20},
{0x2a, 0x03},
{0x2b, 0xf5},

{0x88, 0x06}, //EXP Max 07.14 fps
{0x89, 0x68},
{0x8a, 0xa0},

{0x91, 0x06}, //EXP Fix 07.00 fps
{0x92, 0x89},
{0x93, 0xd4},

{0x9c, 0x17}, //EXP Limit 500.00 fps
{0x9d, 0x70},
{0x9e, 0x01}, //EXP Unit
{0x9f, 0xf4},

{0x03, 0x20},
{0x10, 0x9C}, //AE on 50hz

{0x03, 0x22},
{0x10, 0xe9},

{0x03, 0x00},
{0x11, 0x94},

{0x03, 0x00},
{0x0e, 0x03}, //PLL Off
{0x0e, 0x73}, //PLL ON x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//
};

regs_short_t front_fps_10_50hz_regs[] = {
{0x03, 0x00},
{0x01, 0xf9},
{0x0e, 0x03}, //PLL Off
{0x11, 0x90},

{0x40, 0x01}, //Hblank 360
{0x41, 0x68},
{0x42, 0x00}, //Vsync 20
{0x43, 0x14},

{0x90, 0x09}, //BLC_TIME_TH_ON
{0x91, 0x09}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF

{0x03, 0x02}, //PAGE 2
{0xd4, 0x09}, //DCDC_TIME_TH_ON
{0xd5, 0x09}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF

{0x03, 0x20},
{0x10, 0x1C}, //AE off 50hz

{0x03, 0x22},
{0x10, 0x69},

{0x03, 0x20},
{0x2a, 0x03},
{0x2b, 0xf5},

{0x88, 0x04}, //EXP Max 11.11 fps
{0x89, 0x1e},
{0x8a, 0xb0},

{0x91, 0x04}, //EXP Fix 10.00 fps
{0x92, 0x93},
{0x93, 0xe0},

{0x9c, 0x17}, //EXP Limit 500.00 fps
{0x9d, 0x70},
{0x9e, 0x01}, //EXP Unit
{0x9f, 0xf4},

{0x03, 0x20},
{0x10, 0x9C}, //AE on 50hz

{0x03, 0x22},
{0x10, 0xe9},

{0x03, 0x00},
{0x11, 0x94},

{0x03, 0x00},
{0x0e, 0x03}, //PLL Off
{0x0e, 0x73}, //PLL ON x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//
};

regs_short_t front_fps_15_50hz_regs[] = {
{0x03, 0x00},
{0x01, 0xf9},
{0x0e, 0x03}, //PLL Off
{0x11, 0x90},

{0x40, 0x01}, //Hblank 360
{0x41, 0x68},
{0x42, 0x00}, //Vsync 20
{0x43, 0x14},

{0x90, 0x06}, //BLC_TIME_TH_ON
{0x91, 0x06}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF

{0x03, 0x02}, //PAGE 2
{0xd4, 0x06}, //DCDC_TIME_TH_ON
{0xd5, 0x06}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF

{0x03, 0x20},
{0x10, 0x1C}, //AE off 50hz

{0x03, 0x22},
{0x10, 0x69},

{0x03, 0x20},
{0x2a, 0x03},
{0x2b, 0xf5},

{0x88, 0x02}, //EXP Max 16.67 fps
{0x89, 0xbf},
{0x8a, 0x20},

{0x91, 0x03}, //EXP Fix 14.91 fps
{0x92, 0x12},
{0x93, 0x22},

{0x9c, 0x17}, //EXP Limit 500.00 fps
{0x9d, 0x70},
{0x9e, 0x01}, //EXP Unit
{0x9f, 0xf4},

{0x03, 0x20},
{0x10, 0x9C}, //AE on 50hz

{0x03, 0x22},
{0x10, 0xe9},

{0x03, 0x00},
{0x11, 0x94},

{0x03, 0x00},
{0x0e, 0x03}, //PLL Off
{0x0e, 0x73}, //PLL ON x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//
};

regs_short_t front_fps_7_60hz_regs[] = {
{0x03, 0x00},
{0x01, 0xf9},
{0x0e, 0x03}, //PLL Off
{0x11, 0x90},

{0x40, 0x01}, //Hblank 360
{0x41, 0x68},
{0x42, 0x00}, //Vsync 20
{0x43, 0x14},

{0x90, 0x11}, //BLC_TIME_TH_ON
{0x91, 0x11}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF

{0x03, 0x02}, //PAGE 2
{0xd4, 0x11}, //DCDC_TIME_TH_ON
{0xd5, 0x11}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF

{0x03, 0x20},
{0x10, 0x0C}, //AE off 60hz

{0x03, 0x22},
{0x10, 0x69},

{0x03, 0x20},
{0x2a, 0x03},
{0x2b, 0xf5},

{0x88, 0x06}, //EXP Max 7.06 fps
{0x89, 0x7c},
{0x8a, 0x28},

{0x91, 0x06}, //EXP Fix 07.00 fps
{0x92, 0x89},
{0x93, 0xd4},

{0x9c, 0x17}, //EXP Limit 500.00 fps
{0x9d, 0x70},
{0x9e, 0x01}, //EXP Unit
{0x9f, 0xf4},

{0x03, 0x20},
{0x10, 0x8C}, //AE on 60hz

{0x03, 0x22},
{0x10, 0xe9},

{0x03, 0x00},
{0x11, 0x94},

{0x03, 0x00},
{0x0e, 0x03}, //PLL Off
{0x0e, 0x73}, //PLL ON x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//
};

regs_short_t front_fps_10_60hz_regs[] = {
{0x03, 0x00},
{0x01, 0xf9},
{0x0e, 0x03}, //PLL Off
{0x11, 0x90},

{0x40, 0x01}, //Hblank 360
{0x41, 0x68},
{0x42, 0x00}, //Vsync 20
{0x43, 0x14},

{0x90, 0x0b}, //BLC_TIME_TH_ON
{0x91, 0x0b}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF

{0x03, 0x02}, //PAGE 2
{0xd4, 0x0b}, //DCDC_TIME_TH_ON
{0xd5, 0x0b}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF

{0x03, 0x20},
{0x10, 0x0C}, //AE off 60hz

{0x03, 0x22},
{0x10, 0x69},

{0x03, 0x20},
{0x2a, 0x03},
{0x2b, 0xf5},

{0x88, 0x04}, //EXP Max 10.91 fps
{0x89, 0x32},
{0x8a, 0x38},

{0x91, 0x04}, //EXP Fix 10.00 fps
{0x92, 0x93},
{0x93, 0xe0},

{0x9c, 0x17}, //EXP Limit 500.00 fps
{0x9d, 0x70},
{0x9e, 0x01}, //EXP Unit
{0x9f, 0xf4},

{0x03, 0x20},
{0x10, 0x8C}, //AE on 60hz

{0x03, 0x22},
{0x10, 0xe9},

{0x03, 0x00},
{0x11, 0x94},

{0x03, 0x00},
{0x0e, 0x03}, //PLL Off
{0x0e, 0x73}, //PLL ON x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//
};

regs_short_t front_fps_15_60hz_regs[] = {
{0x03, 0x00},
{0x01, 0xf9},
{0x0e, 0x03}, //PLL Off
{0x11, 0x90},

{0x40, 0x01}, //Hblank 360
{0x41, 0x68},
{0x42, 0x00}, //Vsync 20
{0x43, 0x14},

{0x90, 0x08}, //BLC_TIME_TH_ON
{0x91, 0x08}, //BLC_TIME_TH_OFF
{0x92, 0xd8}, //BLC_AG_TH_ON
{0x93, 0xd0}, //BLC_AG_TH_OFF

{0x03, 0x02}, //PAGE 2
{0xd4, 0x08}, //DCDC_TIME_TH_ON
{0xd5, 0x08}, //DCDC_TIME_TH_OFF
{0xd6, 0xd8}, //DCDC_AG_TH_ON
{0xd7, 0xd0}, //DCDC_AG_TH_OFF

{0x03, 0x20},
{0x10, 0x0C}, //AE off 60hz

{0x03, 0x22},
{0x10, 0x69},

{0x03, 0x20},
{0x2a, 0x03},
{0x2b, 0xf5},

{0x88, 0x03}, //EXP Max 15.00 fps
{0x89, 0x0d},
{0x8a, 0x40},

{0x91, 0x03}, //EXP Fix 14.91 fps
{0x92, 0x12},
{0x93, 0x22},

{0x9c, 0x17}, //EXP Limit 500.00 fps
{0x9d, 0x70},
{0x9e, 0x01}, //EXP Unit
{0x9f, 0xf4},

{0x03, 0x20},
{0x10, 0x8C}, //AE on 60hz

{0x03, 0x22},
{0x10, 0xe9},

{0x03, 0x00},
{0x11, 0x94},

{0x03, 0x00},
{0x0e, 0x03}, //PLL Off
{0x0e, 0x73}, //PLL ON x2

{0x03, 0x00}, //Dummy 750us
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},
{0x03, 0x00},

{0x01, 0xf8},

{0xff, 0x28},//NEED Delay 400ms//
};

regs_short_t front_fps_vt_auto_regs[] = {
};

regs_short_t front_fps_vt_7_regs[] = {
};

regs_short_t front_fps_vt_10_regs[] = {
};

regs_short_t front_fps_vt_15_regs[] = {
};

regs_short_t front_pattern_on_regs[] =  {
{0x03, 0x00},
{0x50, 0x05},
};

regs_short_t front_pattern_off_regs[] =  {
{0x03, 0x00},
{0x50, 0x00},
};


#endif /* __SR200PC20_REGS_H */
