/* drivers/media/video/s5k5ccgx_regs-p4w.h
 *
 * Driver for s5k5ccgx (5MP Camera) from SEC(LSI), firmware EVT1.1
 *
 * Copyright (C) 2010, SAMSUNG ELECTRONICS
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */


#ifndef __S5K5CCGX_REG_P4W_H__
#define __S5K5CCGX_REG_P4W_H__

#if defined(FEATURE_YUV_CAPTURE)
/* Init regs for YUV capture */
static const u32 s5k5ccgx_init_reg[] =
{
	0xFCFCD000,	//Reset                                  //
	0x00140001,   //Wait100mSec                            //
	0x10021101,

	//****************************************/
	0xFCFCD000,
	//****************************************/
	//===================================================================
	// History
	//===================================================================
	//20100717 : 1st release
	//20100806 : 2nd release for EVT0.1
	//20101028 : 3rd release for EVT1
	//WRITE #awbb_otp_disable  0000          //awb otp use
	//============================================================================
	//-->The below registers are for FACTORY ONLY. if you change them without prio
	//   YOU are RESPONSIBLE for the FAILURE that will happen in the future.
	//============================================================================
	//===================================================================
	// Reset & Trap and Patch
	//===================================================================

	// Start of Trap and Patch
	//  2010-08-11 13:53:35
	0x00100001,
	0x10300000,
	0x00140001,

	0xFFFF000A,     //p10
	// Start of Patch data
	0x00287000,
	/*++ Add ESD */
	0x002A0150,
	0x0F12AAAA,
	/*-- Add ESD */
	0x00287000,
	0x002A352C,
	0x0F12B5F8,    // 7000352C
	0x0F124A22,    // 7000352E
	0x0F124922,    // 70003530
	0x0F124823,    // 70003532
	0x0F124B23,    // 70003534
	0x0F122500,    // 70003536
	0x0F12801D,    // 70003538
	0x0F12C004,    // 7000353A
	0x0F126001,    // 7000353C
	0x0F124922,    // 7000353E
	0x0F124822,    // 70003540
	0x0F12F000,    // 70003542
	0x0F12FB71,    // 70003544
	0x0F124922,    // 70003546
	0x0F124822,    // 70003548
	0x0F12F000,    // 7000354A
	0x0F12FB6D,    // 7000354C
	0x0F124822,    // 7000354E
	0x0F124E22,    // 70003550
	0x0F126430,    // 70003552
	0x0F124922,    // 70003554
	0x0F124823,    // 70003556
	0x0F12F000,    // 70003558
	0x0F12FB66,    // 7000355A
	0x0F124822,    // 7000355C
	0x0F120037,    // 7000355E
	0x0F123780,    // 70003560
	0x0F126178,    // 70003562
	0x0F124C21,    // 70003564
	0x0F128365,    // 70003566
	0x0F124921,    // 70003568
	0x0F124822,    // 7000356A
	0x0F12F000,    // 7000356C
	0x0F12FB5C,    // 7000356E
	0x0F124921,    // 70003570
	0x0F124822,    // 70003572
	0x0F12F000,    // 70003574
	0x0F12FB58,    // 70003576
	0x0F124921,    // 70003578
	0x0F124822,    // 7000357A
	0x0F12F000,    // 7000357C
	0x0F12FB54,    // 7000357E
	0x0F124921,    // 70003580
	0x0F124822,    // 70003582
	0x0F12F000,    // 70003584
	0x0F12FB50,    // 70003586
	0x0F1283A5,    // 70003588
	0x0F124821,    // 7000358A
	0x0F126470,    // 7000358C
	0x0F122001,    // 7000358E
	0x0F120340,    // 70003590
	0x0F123420,    // 70003592
	0x0F128060,    // 70003594
	0x0F122085,    // 70003596
	0x0F1280A0,    // 70003598
	0x0F12481E,    // 7000359A
	0x0F1280E0,    // 7000359C
	0x0F12481E,    // 7000359E
	0x0F126730,    // 700035A0
	0x0F12491E,    // 700035A2
	0x0F12481E,    // 700035A4
	0x0F12F000,    // 700035A6
	0x0F12FB3F,    // 700035A8
	0x0F12480F,    // 700035AA
	0x0F126178,    // 700035AC
	0x0F1281E5,    // 700035AE
	0x0F128225,    // 700035B0
	0x0F12BCF8,    // 700035B2
	0x0F12BC08,    // 700035B4
	0x0F124718,    // 700035B6
	0x0F1200D4,    // 700035B8
	0x0F125CC1,    // 700035BA
	0x0F12633D,    // 700035BC
	0x0F120000,    // 700035BE
	0x0F121C08,    // 700035C0
	0x0F127000,    // 700035C2
	0x0F123290,    // 700035C4
	0x0F127000,    // 700035C6
	0x0F123643,    // 700035C8
	0x0F127000,    // 700035CA
	0x0F12D9E7,    // 700035CC
	0x0F120000,    // 700035CE
	0x0F12382B,    // 700035D0
	0x0F127000,    // 700035D2
	0x0F12395D,    // 700035D4
	0x0F120000,    // 700035D6
	0x0F1238BD,    // 700035D8
	0x0F127000,    // 700035DA
	0x0F120000,    // 700035DC
	0x0F127000,    // 700035DE
	0x0F123989,    // 700035E0
	0x0F127000,    // 700035E2
	0x0F12F903,    // 700035E4
	0x0F120000,    // 700035E6
	0x0F123B83,    // 700035E8
	0x0F127000,    // 700035EA
	0x0F123FC8,    // 700035EC
	0x0F127000,    // 700035EE
	0x0F12367B,    // 700035F0
	0x0F127000,    // 700035F2
	0x0F12495F,    // 700035F4
	0x0F120000,    // 700035F6
	0x0F1236D9,    // 700035F8
	0x0F127000,    // 700035FA
	0x0F12E421,    // 700035FC
	0x0F120000,    // 700035FE
	0x0F123797,    // 70003600
	0x0F127000,    // 70003602
	0x0F12216D,    // 70003604
	0x0F120000,    // 70003606
	0x0F12380B,    // 70003608
	0x0F127000,    // 7000360A
	0x0F120179,    // 7000360C
	0x0F120001,    // 7000360E
	0x0F123AAD,    // 70003610
	0x0F127000,    // 70003612
	0x0F1207FF,    // 70003614
	0x0F120000,    // 70003616
	0x0F123B21,    // 70003618
	0x0F127000,    // 7000361A
	0x0F123B49,    // 7000361C
	0x0F127000,    // 7000361E
	0x0F12E8AD,    // 70003620
	0x0F120000,    // 70003622
	0x0F12B570,    // 70003624
	0x0F12000D,    // 70003626
	0x0F124CFC,    // 70003628
	0x0F128821,    // 7000362A
	0x0F12F000,    // 7000362C
	0x0F12FB04,    // 7000362E
	0x0F128820,    // 70003630
	0x0F124AFB,    // 70003632
	0x0F120081,    // 70003634
	0x0F125055,    // 70003636
	0x0F121C40,    // 70003638
	0x0F128020,    // 7000363A
	0x0F12BC70,    // 7000363C
	0x0F12BC08,    // 7000363E
	0x0F124718,    // 70003640
	0x0F126801,    // 70003642
	0x0F120409,    // 70003644
	0x0F120C09,    // 70003646
	0x0F126840,    // 70003648
	0x0F120400,    // 7000364A
	0x0F120C00,    // 7000364C
	0x0F124AF5,    // 7000364E
	0x0F128992,    // 70003650
	0x0F122A00,    // 70003652
	0x0F12D00D,    // 70003654
	0x0F122300,    // 70003656
	0x0F121A80,    // 70003658
	0x0F12D400,    // 7000365A
	0x0F120003,    // 7000365C
	0x0F120418,    // 7000365E
	0x0F120C00,    // 70003660
	0x0F124BF1,    // 70003662
	0x0F121851,    // 70003664
	0x0F12891B,    // 70003666
	0x0F12428B,    // 70003668
	0x0F12D300,    // 7000366A
	0x0F12000B,    // 7000366C
	0x0F120419,    // 7000366E
	0x0F120C09,    // 70003670
	0x0F124AEE,    // 70003672
	0x0F128151,    // 70003674
	0x0F128190,    // 70003676
	0x0F124770,    // 70003678
	0x0F12B510,    // 7000367A
	0x0F124CEC,    // 7000367C
	0x0F1248ED,    // 7000367E
	0x0F1278A1,    // 70003680
	0x0F122900,    // 70003682
	0x0F12D101,    // 70003684
	0x0F1287C1,    // 70003686
	0x0F12E004,    // 70003688
	0x0F127AE1,    // 7000368A
	0x0F122900,    // 7000368C
	0x0F12D001,    // 7000368E
	0x0F122101,    // 70003690
	0x0F1287C1,    // 70003692
	0x0F12F000,    // 70003694
	0x0F12FAD8,    // 70003696
	0x0F1249E7,    // 70003698
	0x0F128B08,    // 7000369A
	0x0F1206C2,    // 7000369C
	0x0F12D50A,    // 7000369E
	0x0F127AA2,    // 700036A0
	0x0F120652,    // 700036A2
	0x0F12D507,    // 700036A4
	0x0F122210,    // 700036A6
	0x0F124390,    // 700036A8
	0x0F128308,    // 700036AA
	0x0F1248E3,    // 700036AC
	0x0F127AE1,    // 700036AE
	0x0F126B00,    // 700036B0
	0x0F12F000,    // 700036B2
	0x0F12FAD1,    // 700036B4
	0x0F1248DB,    // 700036B6
	0x0F1289C0,    // 700036B8
	0x0F122801,    // 700036BA
	0x0F12D109,    // 700036BC
	0x0F1278A0,    // 700036BE
	0x0F122800,    // 700036C0
	0x0F12D006,    // 700036C2
	0x0F127AE0,    // 700036C4
	0x0F122800,    // 700036C6
	0x0F12D003,    // 700036C8
	0x0F127AA0,    // 700036CA
	0x0F122140,    // 700036CC
	0x0F124308,    // 700036CE
	0x0F1272A0,    // 700036D0
	0x0F12BC10,    // 700036D2
	0x0F12BC08,    // 700036D4
	0x0F124718,    // 700036D6
	0x0F12B570,    // 700036D8
	0x0F124DD7,    // 700036DA
	0x0F124CD7,    // 700036DC
	0x0F128B28,    // 700036DE
	0x0F120701,    // 700036E0
	0x0F12D507,    // 700036E2
	0x0F122108,    // 700036E4
	0x0F124388,    // 700036E6
	0x0F128328,    // 700036E8
	0x0F1249D5,    // 700036EA
	0x0F126B20,    // 700036EC
	0x0F126B89,    // 700036EE
	0x0F12F000,    // 700036F0
	0x0F12FABA,    // 700036F2
	0x0F128B28,    // 700036F4
	0x0F1206C1,    // 700036F6
	0x0F12D5A0,    // 700036F8
	0x0F1249CD,    // 700036FA
	0x0F127A8A,    // 700036FC
	0x0F120652,    // 700036FE
	0x0F12D49C,    // 70003700
	0x0F122210,    // 70003702
	0x0F124390,    // 70003704
	0x0F128328,    // 70003706
	0x0F127AC9,    // 70003708
	0x0F126B20,    // 7000370A
	0x0F12F000,    // 7000370C
	0x0F12FAA4,    // 7000370E
	0x0F12E794,    // 70003710
	0x0F12B5F8,    // 70003712
	0x0F1249CB,    // 70003714
	0x0F128F08,    // 70003716
	0x0F12000C,    // 70003718
	0x0F123480,    // 7000371A
	0x0F122800,    // 7000371C
	0x0F12D000,    // 7000371E
	0x0F128360,    // 70003720
	0x0F122000,    // 70003722
	0x0F128708,    // 70003724
	0x0F124DC8,    // 70003726
	0x0F1226FF,    // 70003728
	0x0F128828,    // 7000372A
	0x0F121C76,    // 7000372C
	0x0F122702,    // 7000372E
	0x0F122803,    // 70003730
	0x0F12D112,    // 70003732
	0x0F128868,    // 70003734
	0x0F122800,    // 70003736
	0x0F12D10F,    // 70003738
	0x0F1288E8,    // 7000373A
	0x0F122800,    // 7000373C
	0x0F12D10C,    // 7000373E
	0x0F12F000,    // 70003740
	0x0F12FA9A,    // 70003742
	0x0F122800,    // 70003744
	0x0F12D008,    // 70003746
	0x0F128B60,    // 70003748
	0x0F122800,    // 7000374A
	0x0F12D001,    // 7000374C
	0x0F1280EE,    // 7000374E
	0x0F1280AF,    // 70003750
	0x0F122001,    // 70003752
	0x0F127268,    // 70003754
	0x0F12F000,    // 70003756
	0x0F12FA97,    // 70003758
	0x0F128828,    // 7000375A
	0x0F122802,    // 7000375C
	0x0F12D10E,    // 7000375E
	0x0F128868,    // 70003760
	0x0F122800,    // 70003762
	0x0F12D10B,    // 70003764
	0x0F1288E8,    // 70003766
	0x0F122800,    // 70003768
	0x0F12D108,    // 7000376A
	0x0F128B60,    // 7000376C
	0x0F122800,    // 7000376E
	0x0F12D001,    // 70003770
	0x0F1280EE,    // 70003772
	0x0F1280AF,    // 70003774
	0x0F122001,    // 70003776
	0x0F127268,    // 70003778
	0x0F12F000,    // 7000377A
	0x0F12FA85,    // 7000377C
	0x0F1288E8,    // 7000377E
	0x0F122800,    // 70003780
	0x0F12D006,    // 70003782
	0x0F121FC1,    // 70003784
	0x0F1239FD,    // 70003786
	0x0F12D003,    // 70003788
	0x0F122001,    // 7000378A
	0x0F12BCF8,    // 7000378C
	0x0F12BC08,    // 7000378E
	0x0F124718,    // 70003790
	0x0F122000,    // 70003792
	0x0F12E7FA,    // 70003794
	0x0F12B570,    // 70003796
	0x0F124CAC,    // 70003798
	0x0F128860,    // 7000379A
	0x0F122800,    // 7000379C
	0x0F12D00C,    // 7000379E
	0x0F128820,    // 700037A0
	0x0F124DA3,    // 700037A2
	0x0F122800,    // 700037A4
	0x0F12D009,    // 700037A6
	0x0F120029,    // 700037A8
	0x0F1231A0,    // 700037AA
	0x0F127AC9,    // 700037AC
	0x0F122900,    // 700037AE
	0x0F12D004,    // 700037B0
	0x0F127AA8,    // 700037B2
	0x0F122180,    // 700037B4
	0x0F124308,    // 700037B6
	0x0F1272A8,    // 700037B8
	0x0F12E73F,    // 700037BA
	0x0F122800,    // 700037BC
	0x0F12D003,    // 700037BE
	0x0F12F7FF,    // 700037C0
	0x0F12FFA7,    // 700037C2
	0x0F122800,    // 700037C4
	0x0F12D1F8,    // 700037C6
	0x0F122000,    // 700037C8
	0x0F128060,    // 700037CA
	0x0F128820,    // 700037CC
	0x0F122800,    // 700037CE
	0x0F12D003,    // 700037D0
	0x0F122008,    // 700037D2
	0x0F12F000,    // 700037D4
	0x0F12FA60,    // 700037D6
	0x0F12E00B,    // 700037D8
	0x0F12489C,    // 700037DA
	0x0F123020,    // 700037DC
	0x0F128880,    // 700037DE
	0x0F122800,    // 700037E0
	0x0F12D103,    // 700037E2
	0x0F127AA8,    // 700037E4
	0x0F122101,    // 700037E6
	0x0F124308,    // 700037E8
	0x0F1272A8,    // 700037EA
	0x0F122010,    // 700037EC
	0x0F12F000,    // 700037EE
	0x0F12FA53,    // 700037F0
	0x0F128820,    // 700037F2
	0x0F122800,    // 700037F4
	0x0F12D1E0,    // 700037F6
	0x0F12488A,    // 700037F8
	0x0F1289C0,    // 700037FA
	0x0F122801,    // 700037FC
	0x0F12D1DC,    // 700037FE
	0x0F127AA8,    // 70003800
	0x0F1221BF,    // 70003802
	0x0F124008,    // 70003804
	0x0F1272A8,    // 70003806
	0x0F12E718,    // 70003808
	0x0F126800,    // 7000380A
	0x0F124990,    // 7000380C
	0x0F128188,    // 7000380E
	0x0F124890,    // 70003810
	0x0F122201,    // 70003812
	0x0F128981,    // 70003814
	0x0F124890,    // 70003816
	0x0F120252,    // 70003818
	0x0F124291,    // 7000381A
	0x0F12D902,    // 7000381C
	0x0F122102,    // 7000381E
	0x0F128181,    // 70003820
	0x0F124770,    // 70003822
	0x0F122101,    // 70003824
	0x0F128181,    // 70003826
	0x0F124770,    // 70003828
	0x0F12B5F1,    // 7000382A
	0x0F124E80,    // 7000382C
	0x0F128834,    // 7000382E
	0x0F122C00,    // 70003830
	0x0F12D03F,    // 70003832
	0x0F122001,    // 70003834
	0x0F122C08,    // 70003836
	0x0F12D000,    // 70003838
	0x0F122000,    // 7000383A
	0x0F1270B0,    // 7000383C
	0x0F124D7F,    // 7000383E
	0x0F122800,    // 70003840
	0x0F12D009,    // 70003842
	0x0F12F000,    // 70003844
	0x0F12FA30,    // 70003846
	0x0F120028,    // 70003848
	0x0F1238F0,    // 7000384A
	0x0F126328,    // 7000384C
	0x0F127AB0,    // 7000384E
	0x0F12217E,    // 70003850
	0x0F124008,    // 70003852
	0x0F1272B0,    // 70003854
	0x0F12E00F,    // 70003856
	0x0F124F7A,    // 70003858
	0x0F123780,    // 7000385A
	0x0F128B78,    // 7000385C
	0x0F122800,    // 7000385E
	0x0F12D005,    // 70003860
	0x0F12F000,    // 70003862
	0x0F12FA29,    // 70003864
	0x0F122000,    // 70003866
	0x0F128378,    // 70003868
	0x0F124976,    // 7000386A
	0x0F128708,    // 7000386C
	0x0F122000,    // 7000386E
	0x0F12F000,    // 70003870
	0x0F12FA2A,    // 70003872
	0x0F124879,    // 70003874
	0x0F126328,    // 70003876
	0x0F1278B1,    // 70003878
	0x0F122700,    // 7000387A
	0x0F120038,    // 7000387C
	0x0F122900,    // 7000387E
	0x0F12D008,    // 70003880
	0x0F124972,    // 70003882
	0x0F123920,    // 70003884
	0x0F128ACA,    // 70003886
	0x0F122A00,    // 70003888
	0x0F12D003,    // 7000388A
	0x0F128B09,    // 7000388C
	0x0F122900,    // 7000388E
	0x0F12D000,    // 70003890
	0x0F122001,    // 70003892
	0x0F127170,    // 70003894
	0x0F122C02,    // 70003896
	0x0F12D102,    // 70003898
	0x0F124868,    // 7000389A
	0x0F123860,    // 7000389C
	0x0F126328,    // 7000389E
	0x0F122201,    // 700038A0
	0x0F122C02,    // 700038A2
	0x0F12D000,    // 700038A4
	0x0F122200,    // 700038A6
	0x0F124861,    // 700038A8
	0x0F122110,    // 700038AA
	0x0F12300A,    // 700038AC
	0x0F12F000,    // 700038AE
	0x0F12FA13,    // 700038B0
	0x0F128037,    // 700038B2
	0x0F129900,    // 700038B4
	0x0F120020,    // 700038B6
	0x0F12600C,    // 700038B8
	0x0F12E767,    // 700038BA
	0x0F12B538,    // 700038BC
	0x0F124865,    // 700038BE
	0x0F124669,    // 700038C0
	0x0F123848,    // 700038C2
	0x0F12F000,    // 700038C4
	0x0F12FA10,    // 700038C6
	0x0F124A5E,    // 700038C8
	0x0F124862,    // 700038CA
	0x0F128F51,    // 700038CC
	0x0F122400,    // 700038CE
	0x0F123020,    // 700038D0
	0x0F122900,    // 700038D2
	0x0F12D00A,    // 700038D4
	0x0F128754,    // 700038D6
	0x0F126941,    // 700038D8
	0x0F126451,    // 700038DA
	0x0F126491,    // 700038DC
	0x0F12466B,    // 700038DE
	0x0F128819,    // 700038E0
	0x0F1287D1,    // 700038E2
	0x0F12885B,    // 700038E4
	0x0F120011,    // 700038E6
	0x0F123140,    // 700038E8
	0x0F12800B,    // 700038EA
	0x0F128F91,    // 700038EC
	0x0F122900,    // 700038EE
	0x0F12D002,    // 700038F0
	0x0F128794,    // 700038F2
	0x0F126940,    // 700038F4
	0x0F126490,    // 700038F6
	0x0F12F000,    // 700038F8
	0x0F12F9FE,    // 700038FA
	0x0F12BC38,    // 700038FC
	0x0F12BC08,    // 700038FE
	0x0F124718,    // 70003900
	0x0F12B5F8,    // 70003902
	0x0F124C56,    // 70003904
	0x0F1289E0,    // 70003906
	0x0F12F000,    // 70003908
	0x0F12F9FE,    // 7000390A
	0x0F120006,    // 7000390C
	0x0F128A20,    // 7000390E
	0x0F12F000,    // 70003910
	0x0F12FA02,    // 70003912
	0x0F120007,    // 70003914
	0x0F12484F,    // 70003916
	0x0F124D4A,    // 70003918
	0x0F123020,    // 7000391A
	0x0F126CA9,    // 7000391C
	0x0F126940,    // 7000391E
	0x0F121809,    // 70003920
	0x0F120200,    // 70003922
	0x0F12F000,    // 70003924
	0x0F12FA00,    // 70003926
	0x0F120400,    // 70003928
	0x0F120C00,    // 7000392A
	0x0F12002A,    // 7000392C
	0x0F12326E,    // 7000392E
	0x0F120011,    // 70003930
	0x0F12390A,    // 70003932
	0x0F122305,    // 70003934
	0x0F12F000,    // 70003936
	0x0F12F9FD,    // 70003938
	0x0F124C43,    // 7000393A
	0x0F1261A0,    // 7000393C
	0x0F128FEB,    // 7000393E
	0x0F120002,    // 70003940
	0x0F120031,    // 70003942
	0x0F120018,    // 70003944
	0x0F12F000,    // 70003946
	0x0F12F9FD,    // 70003948
	0x0F12466B,    // 7000394A
	0x0F120005,    // 7000394C
	0x0F128018,    // 7000394E
	0x0F12483C,    // 70003950
	0x0F1269A2,    // 70003952
	0x0F123040,    // 70003954
	0x0F128800,    // 70003956
	0x0F120039,    // 70003958
	0x0F12F000,    // 7000395A
	0x0F12F9F3,    // 7000395C
	0x0F12466B,    // 7000395E
	0x0F120006,    // 70003960
	0x0F128058,    // 70003962
	0x0F120021,    // 70003964
	0x0F129800,    // 70003966
	0x0F12311C,    // 70003968
	0x0F12F000,    // 7000396A
	0x0F12F9F3,    // 7000396C
	0x0F124935,    // 7000396E
	0x0F123180,    // 70003970
	0x0F12808D,    // 70003972
	0x0F1280CE,    // 70003974
	0x0F128BA1,    // 70003976
	0x0F124836,    // 70003978
	0x0F123820,    // 7000397A
	0x0F128001,    // 7000397C
	0x0F128BE1,    // 7000397E
	0x0F128041,    // 70003980
	0x0F128C21,    // 70003982
	0x0F128081,    // 70003984
	0x0F12E701,    // 70003986
	0x0F12B5F8,    // 70003988
	0x0F124E2E,    // 7000398A
	0x0F126C70,    // 7000398C
	0x0F126CB1,    // 7000398E
	0x0F120200,    // 70003990
	0x0F12F000,    // 70003992
	0x0F12F9C9,    // 70003994
	0x0F120400,    // 70003996
	0x0F120C00,    // 70003998
	0x0F122401,    // 7000399A
	0x0F120364,    // 7000399C
	0x0F1242A0,    // 7000399E
	0x0F12D200,    // 700039A0
	0x0F120004,    // 700039A2
	0x0F124A27,    // 700039A4
	0x0F120020,    // 700039A6
	0x0F12327E,    // 700039A8
	0x0F121F91,    // 700039AA
	0x0F122303,    // 700039AC
	0x0F12F000,    // 700039AE
	0x0F12F9C1,    // 700039B0
	0x0F120405,    // 700039B2
	0x0F120C2D,    // 700039B4
	0x0F124A23,    // 700039B6
	0x0F120020,    // 700039B8
	0x0F12325A,    // 700039BA
	0x0F120011,    // 700039BC
	0x0F12390A,    // 700039BE
	0x0F122305,    // 700039C0
	0x0F12F000,    // 700039C2
	0x0F12F9B7,    // 700039C4
	0x0F12491F,    // 700039C6
	0x0F1264C8,    // 700039C8
	0x0F12491F,    // 700039CA
	0x0F124E21,    // 700039CC
	0x0F1288C8,    // 700039CE
	0x0F122701,    // 700039D0
	0x0F122800,    // 700039D2
	0x0F12D009,    // 700039D4
	0x0F124C23,    // 700039D6
	0x0F1238FF,    // 700039D8
	0x0F121E40,    // 700039DA
	0x0F12D00A,    // 700039DC
	0x0F122804,    // 700039DE
	0x0F12D042,    // 700039E0
	0x0F122806,    // 700039E2
	0x0F12D101,    // 700039E4
	0x0F122000,    // 700039E6
	0x0F1280C8,    // 700039E8
	0x0F1282B7,    // 700039EA
	0x0F122001,    // 700039EC
	0x0F12F000,    // 700039EE
	0x0F12F9B9,    // 700039F0
	0x0F12E6CB,    // 700039F2
	0x0F12000D,    // 700039F4
	0x0F12724F,    // 700039F6
	0x0F122001,    // 700039F8
	0x0F12F000,    // 700039FA
	0x0F12F9BB,    // 700039FC
	0x0F12F000,    // 700039FE
	0x0F12F9C1,    // 70003A00
	0x0F124910,    // 70003A02
	0x0F123148,    // 70003A04
	0x0F12C903,    // 70003A06
	0x0F124348,    // 70003A08
	0x0F120A00,    // 70003A0A
	0x0F126160,    // 70003A0C
	0x0F1220FF,    // 70003A0E
	0x0F121D40,    // 70003A10
	0x0F1280E8,    // 70003A12
	0x0F12480C,    // 70003A14
	0x0F123040,    // 70003A16
	0x0F127707,    // 70003A18
	0x0F12E7E6,    // 70003A1A
	0x0F123290,    // 70003A1C
	0x0F127000,    // 70003A1E
	0x0F123294,    // 70003A20
	0x0F127000,    // 70003A22
	0x0F1204A8,    // 70003A24
	0x0F127000,    // 70003A26
	0x0F1215DC,    // 70003A28
	0x0F127000,    // 70003A2A
	0x0F125000,    // 70003A2C
	0x0F12D000,    // 70003A2E
	0x0F121E84,    // 70003A30
	0x0F127000,    // 70003A32
	0x0F121BE4,    // 70003A34
	0x0F127000,    // 70003A36
	0x0F122EA8,    // 70003A38
	0x0F127000,    // 70003A3A
	0x0F1221A4,    // 70003A3C
	0x0F127000,    // 70003A3E
	0x0F120100,    // 70003A40
	0x0F127000,    // 70003A42
	0x0F123F48,    // 70003A44
	0x0F127000,    // 70003A46
	0x0F1231A0,    // 70003A48
	0x0F127000,    // 70003A4A
	0x0F1201E8,    // 70003A4C
	0x0F127000,    // 70003A4E
	0x0F12F2A0,    // 70003A50
	0x0F12D000,    // 70003A52
	0x0F122A44,    // 70003A54
	0x0F127000,    // 70003A56
	0x0F12F400,    // 70003A58
	0x0F12D000,    // 70003A5A
	0x0F122024,    // 70003A5C
	0x0F127000,    // 70003A5E
	0x0F121650,    // 70003A60
	0x0F127000,    // 70003A62
	0x0F122A64,    // 70003A64
	0x0F127000,    // 70003A66
	0x0F124962,    // 70003A68
	0x0F12724F,    // 70003A6A
	0x0F1220FF,    // 70003A6C
	0x0F121DC0,    // 70003A6E
	0x0F1280C8,    // 70003A70
	0x0F12F000,    // 70003A72
	0x0F12F98F,    // 70003A74
	0x0F124960,    // 70003A76
	0x0F126ACA,    // 70003A78
	0x0F12604A,    // 70003A7A
	0x0F122800,    // 70003A7C
	0x0F12D006,    // 70003A7E
	0x0F12436A,    // 70003A80
	0x0F120001,    // 70003A82
	0x0F120010,    // 70003A84
	0x0F12F000,    // 70003A86
	0x0F12F94F,    // 70003A88
	0x0F126160,    // 70003A8A
	0x0F12E001,    // 70003A8C
	0x0F12436A,    // 70003A8E
	0x0F126162,    // 70003A90
	0x0F128BF0,    // 70003A92
	0x0F122800,    // 70003A94
	0x0F12D001,    // 70003A96
	0x0F12F7FF,    // 70003A98
	0x0F12FF33,    // 70003A9A
	0x0F122000,    // 70003A9C
	0x0F12F000,    // 70003A9E
	0x0F12F969,    // 70003AA0
	0x0F124954,    // 70003AA2
	0x0F1220FF,    // 70003AA4
	0x0F121DC0,    // 70003AA6
	0x0F1280C8,    // 70003AA8
	0x0F12E79E,    // 70003AAA
	0x0F12B570,    // 70003AAC
	0x0F120004,    // 70003AAE
	0x0F12F000,    // 70003AB0
	0x0F12F978,    // 70003AB2
	0x0F124D51,    // 70003AB4
	0x0F128C29,    // 70003AB6
	0x0F121A40,    // 70003AB8
	0x0F1242A0,    // 70003ABA
	0x0F12D803,    // 70003ABC
	0x0F12F000,    // 70003ABE
	0x0F12F971,    // 70003AC0
	0x0F128C29,    // 70003AC2
	0x0F121A44,    // 70003AC4
	0x0F120020,    // 70003AC6
	0x0F12626C,    // 70003AC8
	0x0F12F000,    // 70003ACA
	0x0F12F973,    // 70003ACC
	0x0F1262A8,    // 70003ACE
	0x0F12F000,    // 70003AD0
	0x0F12F978,    // 70003AD2
	0x0F126328,    // 70003AD4
	0x0F128869,    // 70003AD6
	0x0F122900,    // 70003AD8
	0x0F12D000,    // 70003ADA
	0x0F1262A8,    // 70003ADC
	0x0F124848,    // 70003ADE
	0x0F126B00,    // 70003AE0
	0x0F128C00,    // 70003AE2
	0x0F122800,    // 70003AE4
	0x0F12D117,    // 70003AE6
	0x0F126AA8,    // 70003AE8
	0x0F12F000,    // 70003AEA
	0x0F12F973,    // 70003AEC
	0x0F1261E8,    // 70003AEE
	0x0F124944,    // 70003AF0
	0x0F128B8A,    // 70003AF2
	0x0F122A00,    // 70003AF4
	0x0F12D00C,    // 70003AF6
	0x0F128BC9,    // 70003AF8
	0x0F124288,    // 70003AFA
	0x0F12D90A,    // 70003AFC
	0x0F124841,    // 70003AFE
	0x0F123020,    // 70003B00
	0x0F128800,    // 70003B02
	0x0F1261E8,    // 70003B04
	0x0F128C29,    // 70003B06
	0x0F121A40,    // 70003B08
	0x0F1262A8,    // 70003B0A
	0x0F12F000,    // 70003B0C
	0x0F12F952,    // 70003B0E
	0x0F1262A8,    // 70003B10
	0x0F12E593,    // 70003B12
	0x0F1261E9,    // 70003B14
	0x0F12E591,    // 70003B16
	0x0F12F000,    // 70003B18
	0x0F12F944,    // 70003B1A
	0x0F1261E8,    // 70003B1C
	0x0F12E58D,    // 70003B1E
	0x0F12B510,    // 70003B20
	0x0F12F000,    // 70003B22
	0x0F12F95F,    // 70003B24
	0x0F124837,    // 70003B26
	0x0F123020,    // 70003B28
	0x0F128841,    // 70003B2A
	0x0F122900,    // 70003B2C
	0x0F12D007,    // 70003B2E
	0x0F124A31,    // 70003B30
	0x0F123280,    // 70003B32
	0x0F126953,    // 70003B34
	0x0F124A34,    // 70003B36
	0x0F12428B,    // 70003B38
	0x0F12D202,    // 70003B3A
	0x0F128880,    // 70003B3C
	0x0F1281D0,    // 70003B3E
	0x0F12E5C7,    // 70003B40
	0x0F1288C0,    // 70003B42
	0x0F1281D0,    // 70003B44
	0x0F12E5C4,    // 70003B46
	0x0F12B570,    // 70003B48
	0x0F126800,    // 70003B4A
	0x0F120605,    // 70003B4C
	0x0F120E2D,    // 70003B4E
	0x0F124C2E,    // 70003B50
	0x0F128B60,    // 70003B52
	0x0F122800,    // 70003B54
	0x0F12D010,    // 70003B56
	0x0F12482D,    // 70003B58
	0x0F128A00,    // 70003B5A
	0x0F1206C0,    // 70003B5C
	0x0F12D50C,    // 70003B5E
	0x0F12482C,    // 70003B60
	0x0F127800,    // 70003B62
	0x0F122800,    // 70003B64
	0x0F12D008,    // 70003B66
	0x0F122000,    // 70003B68
	0x0F12F000,    // 70003B6A
	0x0F12F943,    // 70003B6C
	0x0F128B20,    // 70003B6E
	0x0F122201,    // 70003B70
	0x0F122180,    // 70003B72
	0x0F12F000,    // 70003B74
	0x0F12F946,    // 70003B76
	0x0F128320,    // 70003B78
	0x0F120028,    // 70003B7A
	0x0F12F000,    // 70003B7C
	0x0F12F94A,    // 70003B7E
	0x0F12E55C,    // 70003B80
	0x0F12B5F8,    // 70003B82
	0x0F124D1B,    // 70003B84
	0x0F1226FF,    // 70003B86
	0x0F1288E8,    // 70003B88
	0x0F121D76,    // 70003B8A
	0x0F1242B0,    // 70003B8C
	0x0F12D026,    // 70003B8E
	0x0F124821,    // 70003B90
	0x0F124F22,    // 70003B92
	0x0F127883,    // 70003B94
	0x0F120038,    // 70003B96
	0x0F124921,    // 70003B98
	0x0F1230FF,    // 70003B9A
	0x0F1237FF,    // 70003B9C
	0x0F124A19,    // 70003B9E
	0x0F12698C,    // 70003BA0
	0x0F1230E1,    // 70003BA2
	0x0F1237C1,    // 70003BA4
	0x0F128800,    // 70003BA6
	0x0F128BF9,    // 70003BA8
	0x0F123220,    // 70003BAA
	0x0F122B00,    // 70003BAC
	0x0F12D00B,    // 70003BAE
	0x0F1289D2,    // 70003BB0
	0x0F122A00,    // 70003BB2
	0x0F12D013,    // 70003BB4
	0x0F124350,    // 70003BB6
	0x0F12F000,    // 70003BB8
	0x0F12F8B6,    // 70003BBA
	0x0F121C40,    // 70003BBC
	0x0F120400,    // 70003BBE
	0x0F120C00,    // 70003BC0
	0x0F12F000,    // 70003BC2
	0x0F12F92F,    // 70003BC4
	0x0F12E00A,    // 70003BC6
	0x0F128A12,    // 70003BC8
	0x0F122A00,    // 70003BCA
	0x0F12D007,    // 70003BCC
	0x0F124350,    // 70003BCE
	0x0F12F000,    // 70003BD0
	0x0F12F8AA,    // 70003BD2
	0x0F121C40,    // 70003BD4
	0x0F120400,    // 70003BD6
	0x0F120C00,    // 70003BD8
	0x0F12F000,    // 70003BDA
	0x0F12F923,    // 70003BDC
	0x0F12F000,    // 70003BDE
	0x0F12F929,    // 70003BE0
	0x0F1288E8,    // 70003BE2
	0x0F1242B0,    // 70003BE4
	0x0F12D103,    // 70003BE6
	0x0F12490E,    // 70003BE8
	0x0F1220FF,    // 70003BEA
	0x0F121C40,    // 70003BEC
	0x0F128048,    // 70003BEE
	0x0F12E5CC,    // 70003BF0
	0x0F120000,    // 70003BF2
	0x0F1231A0,    // 70003BF4
	0x0F127000,    // 70003BF6
	0x0F1229E4,    // 70003BF8
	0x0F127000,    // 70003BFA
	0x0F121E3C,    // 70003BFC
	0x0F127000,    // 70003BFE
	0x0F1221A4,    // 70003C00
	0x0F127000,    // 70003C02
	0x0F123FC8,    // 70003C04
	0x0F127000,    // 70003C06
	0x0F12E200,    // 70003C08
	0x0F12D000,    // 70003C0A
	0x0F122EA8,    // 70003C0C
	0x0F127000,    // 70003C0E
	0x0F12B040,    // 70003C10
	0x0F12D000,    // 70003C12
	0x0F12323C,    // 70003C14
	0x0F127000,    // 70003C16
	0x0F121E84,    // 70003C18
	0x0F127000,    // 70003C1A
	0x0F122024,    // 70003C1C
	0x0F127000,    // 70003C1E
	0x0F120080,    // 70003C20
	0x0F127000,    // 70003C22
	0x0F12C100,    // 70003C24
	0x0F12D000,    // 70003C26
	0x0F124778,    // 70003C28
	0x0F1246C0,    // 70003C2A
	0x0F12C000,    // 70003C2C
	0x0F12E59F,    // 70003C2E
	0x0F12FF1C,    // 70003C30
	0x0F12E12F,    // 70003C32
	0x0F121F63,    // 70003C34
	0x0F120001,    // 70003C36
	0x0F124778,    // 70003C38
	0x0F1246C0,    // 70003C3A
	0x0F12C000,    // 70003C3C
	0x0F12E59F,    // 70003C3E
	0x0F12FF1C,    // 70003C40
	0x0F12E12F,    // 70003C42
	0x0F121EDF,    // 70003C44
	0x0F120001,    // 70003C46
	0x0F124778,    // 70003C48
	0x0F1246C0,    // 70003C4A
	0x0F12C000,    // 70003C4C
	0x0F12E59F,    // 70003C4E
	0x0F12FF1C,    // 70003C50
	0x0F12E12F,    // 70003C52
	0x0F12495F,    // 70003C54
	0x0F120000,    // 70003C56
	0x0F124778,    // 70003C58
	0x0F1246C0,    // 70003C5A
	0x0F12C000,    // 70003C5C
	0x0F12E59F,    // 70003C5E
	0x0F12FF1C,    // 70003C60
	0x0F12E12F,    // 70003C62
	0x0F12E403,    // 70003C64
	0x0F120000,    // 70003C66
	0x0F124778,    // 70003C68
	0x0F1246C0,    // 70003C6A
	0x0F12C000,    // 70003C6C
	0x0F12E59F,    // 70003C6E
	0x0F12FF1C,    // 70003C70
	0x0F12E12F,    // 70003C72
	0x0F1224B3,    // 70003C74
	0x0F120001,    // 70003C76
	0x0F124778,    // 70003C78
	0x0F1246C0,    // 70003C7A
	0x0F12C000,    // 70003C7C
	0x0F12E59F,    // 70003C7E
	0x0F12FF1C,    // 70003C80
	0x0F12E12F,    // 70003C82
	0x0F12EECD,    // 70003C84
	0x0F120000,    // 70003C86
	0x0F124778,    // 70003C88
	0x0F1246C0,    // 70003C8A
	0x0F12C000,    // 70003C8C
	0x0F12E59F,    // 70003C8E
	0x0F12FF1C,    // 70003C90
	0x0F12E12F,    // 70003C92
	0x0F12F049,    // 70003C94
	0x0F120000,    // 70003C96
	0x0F124778,    // 70003C98
	0x0F1246C0,    // 70003C9A
	0x0F12C000,    // 70003C9C
	0x0F12E59F,    // 70003C9E
	0x0F12FF1C,    // 70003CA0
	0x0F12E12F,    // 70003CA2
	0x0F1212DF,    // 70003CA4
	0x0F120000,    // 70003CA6
	0x0F124778,    // 70003CA8
	0x0F1246C0,    // 70003CAA
	0x0F12C000,    // 70003CAC
	0x0F12E59F,    // 70003CAE
	0x0F12FF1C,    // 70003CB0
	0x0F12E12F,    // 70003CB2
	0x0F12F05B,    // 70003CB4
	0x0F120000,    // 70003CB6
	0x0F124778,    // 70003CB8
	0x0F1246C0,    // 70003CBA
	0x0F12C000,    // 70003CBC
	0x0F12E59F,    // 70003CBE
	0x0F12FF1C,    // 70003CC0
	0x0F12E12F,    // 70003CC2
	0x0F12F07B,    // 70003CC4
	0x0F120000,    // 70003CC6
	0x0F124778,    // 70003CC8
	0x0F1246C0,    // 70003CCA
	0x0F12C000,    // 70003CCC
	0x0F12E59F,    // 70003CCE
	0x0F12FF1C,    // 70003CD0
	0x0F12E12F,    // 70003CD2
	0x0F12FE6D,    // 70003CD4
	0x0F120000,    // 70003CD6
	0x0F124778,    // 70003CD8
	0x0F1246C0,    // 70003CDA
	0x0F12C000,    // 70003CDC
	0x0F12E59F,    // 70003CDE
	0x0F12FF1C,    // 70003CE0
	0x0F12E12F,    // 70003CE2
	0x0F123295,    // 70003CE4
	0x0F120000,    // 70003CE6
	0x0F124778,    // 70003CE8
	0x0F1246C0,    // 70003CEA
	0x0F12C000,    // 70003CEC
	0x0F12E59F,    // 70003CEE
	0x0F12FF1C,    // 70003CF0
	0x0F12E12F,    // 70003CF2
	0x0F12234F,    // 70003CF4
	0x0F120000,    // 70003CF6
	0x0F124778,    // 70003CF8
	0x0F1246C0,    // 70003CFA
	0x0F12C000,    // 70003CFC
	0x0F12E59F,    // 70003CFE
	0x0F12FF1C,    // 70003D00
	0x0F12E12F,    // 70003D02
	0x0F124521,    // 70003D04
	0x0F120000,    // 70003D06
	0x0F124778,    // 70003D08
	0x0F1246C0,    // 70003D0A
	0x0F12C000,    // 70003D0C
	0x0F12E59F,    // 70003D0E
	0x0F12FF1C,    // 70003D10
	0x0F12E12F,    // 70003D12
	0x0F127C0D,    // 70003D14
	0x0F120000,    // 70003D16
	0x0F124778,    // 70003D18
	0x0F1246C0,    // 70003D1A
	0x0F12C000,    // 70003D1C
	0x0F12E59F,    // 70003D1E
	0x0F12FF1C,    // 70003D20
	0x0F12E12F,    // 70003D22
	0x0F127C2B,    // 70003D24
	0x0F120000,    // 70003D26
	0x0F124778,    // 70003D28
	0x0F1246C0,    // 70003D2A
	0x0F12F004,    // 70003D2C
	0x0F12E51F,    // 70003D2E
	0x0F1224C4,    // 70003D30
	0x0F120001,    // 70003D32
	0x0F124778,    // 70003D34
	0x0F1246C0,    // 70003D36
	0x0F12C000,    // 70003D38
	0x0F12E59F,    // 70003D3A
	0x0F12FF1C,    // 70003D3C
	0x0F12E12F,    // 70003D3E
	0x0F123183,    // 70003D40
	0x0F120000,    // 70003D42
	0x0F124778,    // 70003D44
	0x0F1246C0,    // 70003D46
	0x0F12C000,    // 70003D48
	0x0F12E59F,    // 70003D4A
	0x0F12FF1C,    // 70003D4C
	0x0F12E12F,    // 70003D4E
	0x0F12302F,    // 70003D50
	0x0F120000,    // 70003D52
	0x0F124778,    // 70003D54
	0x0F1246C0,    // 70003D56
	0x0F12C000,    // 70003D58
	0x0F12E59F,    // 70003D5A
	0x0F12FF1C,    // 70003D5C
	0x0F12E12F,    // 70003D5E
	0x0F12EF07,    // 70003D60
	0x0F120000,    // 70003D62
	0x0F124778,    // 70003D64
	0x0F1246C0,    // 70003D66
	0x0F12C000,    // 70003D68
	0x0F12E59F,    // 70003D6A
	0x0F12FF1C,    // 70003D6C
	0x0F12E12F,    // 70003D6E
	0x0F1248FB,    // 70003D70
	0x0F120000,    // 70003D72
	0x0F124778,    // 70003D74
	0x0F1246C0,    // 70003D76
	0x0F12C000,    // 70003D78
	0x0F12E59F,    // 70003D7A
	0x0F12FF1C,    // 70003D7C
	0x0F12E12F,    // 70003D7E
	0x0F12F0B1,    // 70003D80
	0x0F120000,    // 70003D82
	0x0F124778,    // 70003D84
	0x0F1246C0,    // 70003D86
	0x0F12C000,    // 70003D88
	0x0F12E59F,    // 70003D8A
	0x0F12FF1C,    // 70003D8C
	0x0F12E12F,    // 70003D8E
	0x0F12EEDF,    // 70003D90
	0x0F120000,    // 70003D92
	0x0F124778,    // 70003D94
	0x0F1246C0,    // 70003D96
	0x0F12C000,    // 70003D98
	0x0F12E59F,    // 70003D9A
	0x0F12FF1C,    // 70003D9C
	0x0F12E12F,    // 70003D9E
	0x0F12AEF1,    // 70003DA0
	0x0F120000,    // 70003DA2
	0x0F124778,    // 70003DA4
	0x0F1246C0,    // 70003DA6
	0x0F12C000,    // 70003DA8
	0x0F12E59F,    // 70003DAA
	0x0F12FF1C,    // 70003DAC
	0x0F12E12F,    // 70003DAE
	0x0F1239DF,    // 70003DB0
	0x0F120000,    // 70003DB2
	0x0F124778,    // 70003DB4
	0x0F1246C0,    // 70003DB6
	0x0F12C000,    // 70003DB8
	0x0F12E59F,    // 70003DBA
	0x0F12FF1C,    // 70003DBC
	0x0F12E12F,    // 70003DBE
	0x0F126177,    // 70003DC0
	0x0F120000,    // 70003DC2
	0x0F124778,    // 70003DC4
	0x0F1246C0,    // 70003DC6
	0x0F12C000,    // 70003DC8
	0x0F12E59F,    // 70003DCA
	0x0F12FF1C,    // 70003DCC
	0x0F12E12F,    // 70003DCE
	0x0F12424F,    // 70003DD0
	0x0F120000,    // 70003DD2
	0x0F124778,    // 70003DD4
	0x0F1246C0,    // 70003DD6
	0x0F12C000,    // 70003DD8
	0x0F12E59F,    // 70003DDA
	0x0F12FF1C,    // 70003DDC
	0x0F12E12F,    // 70003DDE
	0x0F123F0D,    // 70003DE0
	0x0F120000,    // 70003DE2
	0x0F124778,    // 70003DE4
	0x0F1246C0,    // 70003DE6
	0x0F12C000,    // 70003DE8
	0x0F12E59F,    // 70003DEA
	0x0F12FF1C,    // 70003DEC
	0x0F12E12F,    // 70003DEE
	0x0F1202B9,    // 70003DF0
	0x0F120001,    // 70003DF2
	0x0F124778,    // 70003DF4
	0x0F1246C0,    // 70003DF6
	0x0F12C000,    // 70003DF8
	0x0F12E59F,    // 70003DFA
	0x0F12FF1C,    // 70003DFC
	0x0F12E12F,    // 70003DFE
	0x0F12FE45,    // 70003E00
	0x0F120000,    // 70003E02
	0x0F124778,    // 70003E04
	0x0F1246C0,    // 70003E06
	0x0F12C000,    // 70003E08
	0x0F12E59F,    // 70003E0A
	0x0F12FF1C,    // 70003E0C
	0x0F12E12F,    // 70003E0E
	0x0F1232A7,    // 70003E10
	0x0F120000,    // 70003E12
	0x0F124778,    // 70003E14
	0x0F1246C0,    // 70003E16
	0x0F12C000,    // 70003E18
	0x0F12E59F,    // 70003E1A
	0x0F12FF1C,    // 70003E1C
	0x0F12E12F,    // 70003E1E
	0x0F12E8AD,    // 70003E20
	0x0F120000,    // 70003E22
	0x0F124778,    // 70003E24
	0x0F1246C0,    // 70003E26
	0x0F12C000,    // 70003E28
	0x0F12E59F,    // 70003E2A
	0x0F12FF1C,    // 70003E2C
	0x0F12E12F,    // 70003E2E
	0x0F1224B9,    // 70003E30
	0x0F120001,    // 70003E32
	0x0F124778,    // 70003E34
	0x0F1246C0,    // 70003E36
	0x0F12C000,    // 70003E38
	0x0F12E59F,    // 70003E3A
	0x0F12FF1C,    // 70003E3C
	0x0F12E12F,    // 70003E3E
	0x0F1202EB,    // 70003E40
	0x0F120001,    // 70003E42
	// End of Patch Data(Last : 70003EDAh)
	// Total Size 2480 (09B0)
	// Addr : 352C , Size : 2478(9AEh)
	0x10000001,

	0x0028D000,
	0x002A0070,
	0x0F120007,         // clks_src_gf_force_enable

	//	TNP_USER_MBCV_CONTROL
	//	TNP_FLS_SEC_CONFIG
	//	TNP_SINGLE_FRAME_CAPTURE
	//	TNP_CAPTURE_DONE_INFO
	//	TNP_5CC_SENSOR_TUNE
	//	TNP_GAS_ALPHA_OTP
	//	TNP_FR_ACCURATE_DYNAMIC
	//	TNP_ADLC_TUNE

	//MBCV Control
	0x00287000,
	0x002A04B4,
	0x0F120064,

	// AFIT by Normalized Brightness Tuning parameter
	0x00287000,
	0x002A3302,
	0x0F120000, // on/off AFIT by NB option

	0x0F120005, // NormBR[0]
	0x0F120019, // NormBR[1]
	0x0F120050, // NormBR[2]
	0x0F120300, // NormBR[3]
	0x0F120375, // NormBR[4]

	// Flash
	0x002A3F82,
	0x0F120000,	// TNP_Regs_PreflashStart
	0x0F120000,	// TNP_Regs_PreflashEnd
	0x0F120260,	// TNP_Regs_PreWP_r
	0x0F120240, // TNP_Regs_PreWP_b

	0x002A3F98,	// BR Tuning
	0x0F120100,	// TNP_Regs_BrRatioIn_0_
	0x0F120150,
	0x0F120200,
	0x0F120300,
	0x0F120400,

	0x0F120100,	// TNP_Regs_BrRatioOut_0_
	0x0F1200A0,
	0x0F120080,
	0x0F120040,
	0x0F120020,

	0x0F120030,	// WP Tuning
	0x0F120040,	// TNP_Regs_WPThresTbl_0_
	0x0F120048,
	0x0F120050,
	0x0F120060,

	0x0F120100,	// TNP_Regs_WPWeightTbl_0_
	0x0F1200C0,
	0x0F120080,
	0x0F12000A,
	0x0F120000,

	0x0F120120,	// T_BR tune
	0x0F120150,	// TNP_Regs_FlBRIn_0_
	0x0F120200,

	0x0F12003C,	//TNP_Regs_FlBRInOut_0_
	0x0F12003B,
	0x0F12002E,

	0x002A0430,	//REG_TC_FLS_Mode
	0x0F120002,
	0x002A3F80,	//TNP_Regs_FastFlashAlg
	0x0F120000,

	0x002A165E,
	0x0F120235,           //0244 0258 AWB R point          //0258 0245 0258
	0x0F12024A,           //024D 0220 AWB B point          //0220 0245 0245


	//         //         //         //         //         //         //         /  //         //         //         //         //         //         //         //
	//         ///
	// Analog & APS settings         //         //         //         //         /  ///
	// This register is for FACTORY ONLY. If you change it without prior notificat
	// YOU are RESPONSIBLE for the FAILURE that will happen in the future
	//         //         //         //         //         //         //         /  //         //         //         //         //         //         //         //
	//         ///

	//============================================================================
	// 5CC EVT0 analog register setting
	// '10.07.14. Initial Draft
	// '10.07.24. sE404=0000 -> 1FC0 (Depedestal 0 -> -64d)
	// '10.08.16. sF410=0001 -> 0000 (for SHBN)
	// '10.08.25. sF438=0020 -> 0002 (VTGSL=2.96V) by APS
	//            sF43A=0020 -> 0001 (VRG=2.83V) by APS
	// '10.09.28. sF402=1F02 -> 3F02 ([13]: pixel bias powerdown according to HADR
	//		    sF416=0000 -> 0001 (AAC_EN enable) for Darkshading
	//============================================================================
	//============================= Analog & APS Control =========================
	0x0028D000,
	0x002AF2AC,
	0x0F120100, // analog gain; 0200 x16 0100 x8 0080 x4 0040 x2 0020 x1
	0x002AF400,
	0x0F12001D, // ldb_en[4] ld_en[3] clp_en[2](N/A) smp_en[1] dshut_en[0]
	0x0F123F02, // cds_test[15:0]; refer to the ATOP_TEST_INFORMATION.

	0x002AF40A,
	0x0F120054, // adc_sat[7:0]=84d (500mV)
	0x0F120002, // ms[2:0]; 2h@Normal 2h@PLA 1h@CNT.AVG
	0x0F120008, // rmp_option[7:0]; [3]SL_Low_PWR_SAVE On
	0x0F120000, // msoff_en; No MS if gain gain is lower than x2
	0x0F1200A4, // rmp_init[7:0]

	0x002AF416,
	0x0F120001, // dbs_option[11:4] dbs_mode[3:2] dbs_bist_en[1] aac_en[0]

	0x002AF41E,
	0x0F120065, // comp2_bias[7:4] comp1_bias[3:0]

	0x002AF422,
	0x0F120005, // pix_bias[3:0]

	0x002AF426,
	0x0F1200D4, // clp_lvl[7:0]

	0x002AF42A,
	0x0F120001, // ref_option[7:0]; [4]OB_PIX monit en [3]Clamp monit en [2]Monit

	0x002AF42E,
	0x0F120406, // fb_lv[11:10] pd_fblv[9] capa_ctrl_en[8] pd_inrush_ctrl[7] pd_re

	0x002AF434,
	0x0F120003, // dbr_clk_sel[1:0]; PLL_mode=3h ROSC_mode=0h
	0x0F120004, // reg_tune_pix[7:0]
	0x0F120002, // reg_tune_tgsl[7:0] (2.96V)
	0x0F120001, // reg_tune_rg[7:0] (2.83V)
	0x0F120004, // reg_tune_ntg[7:0]

	0x002AF446,
	0x0F120000, // blst_en_cintr[15:0]

	0x002AF462,
	0x0F120001, // atx_option add 0714

	0x002AF2A5,
	0x0F1201FF, // atx_width  add 0714

	0x002AF466,
	0x0F120000, // srx_en[0]

	0x002A0054,
	0x0F120028, // pll_pd[10](0:enable 1:disable) div_clk_en[0](0:enable 1:disable
	0x0F128888, // div_dbr[7:4]

	0x002AF132,
	0x0F120206, // tgr_frame_decription 4
	0x002AF152,
	0x0F120206, // tgr_frame_decription 7
	0x002AF1A2,
	0x0F120200, // tgr_frame_params_descriptor_3
	0x002AF1B2,
	0x0F120202, // tgr_frame_params_descriptor_6
	//============================================================================

	//============================= Line-ADLC Tuning =============================
	0x002AE412,
	0x0F120008, // adlc_tune_offset_gr[7:0]
	0x0F120008, // adlc_tune_offset_r[7:0]
	0x0F120010, // adlc_tune_offset_b[7:0]
	0x0F120010, // adlc_tune_offset_gb[7:0]
	0x002AE42E,
	0x0F120004, // adlc_qec[2:0]
	//============================================================================

	//===================================================================
	// AWB white locus setting - Have to be written after TnP
	//===================================================================
	0x00287000,
	0x002A1014,
	0x0F120132, //0138//awbb_IntcR
	0x0F12010A, //011C//awbb_IntcB

	//===================================================================
	// AF
	//===================================================================
	//1. AF interface setting
	0x002A01A2,
	0x0F120003,          //REG_TC_IPRM_CM_Init_AfModeType        // VCM_I2C actuat
	0x0F120000,          //REG_TC_IPRM_CM_Init_PwmConfig1       // No PWM
	0x0F120000,          //REG_TC_IPRM_CM_Init_PwmConfig2
	0x0F120041,          //REG_TC_IPRM_CM_Init_GpioConfig1        // Use GPIO_4 fo
	0x0F120000,          //REG_TC_IPRM_CM_Init_GpioConfig2
	0x0F122A0C,          //REG_TC_IPRM_CM_Init_Mi2cBits        // Use GPIO_5 for S
	0x0F120190,          //REG_TC_IPRM_CM_Init_Mi2cRateKhz        // MI2C Speed :

	//2. AF window setting
	0x002A022C,
	0x0F120100, //REG_TC_AF_FstWinStartX
	0x0F1200E3, //REG_TC_AF_FstWinStartY
	0x0F120200, //REG_TC_AF_FstWinSizeX
	0x0F120238, //REG_TC_AF_FstWinSizeY
	0x0F12018C, //REG_TC_AF_ScndWinStartX
	0x0F120166, //REG_TC_AF_ScndWinStartY
	0x0F1200E6, //REG_TC_AF_ScndWinSizeX
	0x0F120132, //REG_TC_AF_ScndWinSizeY
	0x0F120001, //REG_TC_AF_WinSizesUpdated

	//3. AF Fine Search Settings
	0x002A063A,
	0x0F1200C0,          //#skl_af_StatOvlpExpFactor
	0x002A064A,
	0x0F120000, //0000          //#skl_af_bAfStatOff
	0x002A1488,
	0x0F120000,          //#af_search_usAeStable
	0x002A1494,
	0x0F121002, //#af_search_usSingleAfFlags 1000- fine search disable 1002- fine
	0x002A149E,
	0x0F120003,          //#af_search_usFinePeakCount
	0x0F120000,          //#af_search_usFineMaxScale
	0x002A142C,
	0x0F120602, //#af_pos_usFineStepNumSize
	0x002A14A2,
	0x0F120000,          //#af_search_usCapturePolicy 0000 : Shutter_Priority_Curr

	//4.  AF Peak Threshold Setting
	0x002A1498,
	0x0F120003, //#af_search_usMinPeakSamples
	0x002A148A,
	0x0F1200CC, //#af_search_usPeakThr  for 80%
	0x0F1200A0,          //#af_search_usPeakThrLow

	//5.  AF Default Position
	0x002A1420,
	0x0F120000, //#af_pos_usHomePos
	0x0F12952F, //#af_pos_usLowConfPos

	//6. AF statistics
	0x002A14B4,
	0x0F120280,          //#af_search_usConfThr_4_  LowEdgeBoth GRAD
	0x002A14C0,
	0x0F1203A0,          //#af_search_usConfThr_10_ LowLight HPF
	0x0F120320,          //#af_search_usConfThr_11_
	0x002A14F4,
	0x0F120030,          //#af_stat_usMinStatVal
	0x002A1514,
	0x0F120060,          //#af_scene_usSceneLowNormBrThr
	// AF Scene Settings
	0x002A151E,
	0x0F120003,          //#af_scene_usSaturatedScene

	//7. AF Lens Position Table Settings
	0x002A1434,
	0x0F120010,           //#af_pos_usTableLastInd 10h + 1h = 17 Steps

	0x0F120030,           //#af_pos_usTable_0_  48
	0x0F120033,           //#af_pos_usTable_1_  51
	0x0F120036,           //#af_pos_usTable_2_  54
	0x0F120039,           //#af_pos_usTable_3_  57
	0x0F12003D,           //#af_pos_usTable_4_  61
	0x0F120041,           //#af_pos_usTable_5_  65
	0x0F120045,           //#af_pos_usTable_6_  69
	0x0F120049,           //#af_pos_usTable_7_  73
	0x0F12004E,           //#af_pos_usTable_8_  78
	0x0F120053,           //#af_pos_usTable_9_  83
	0x0F120059,           //#af_pos_usTable_10_ 89
	0x0F120060,           //#af_pos_usTable_11_ 104
	0x0F120068,           //#af_pos_usTable_12_ 109
	0x0F120072,           //#af_pos_usTable_13_ 114
	0x0F12007D,           //#af_pos_usTable_14_ 125
	0x0F120089,           //#af_pos_usTable_15_ 137
	0x0F120096,           //#af_pos_usTable_16_ 150

	//8. VCM AF driver with PWM/I2C
	0x002A1558,
	0x0F128000,          //#afd_usParam[0]  I2C power down command
	0x0F120006,          //#afd_usParam[1]  Position Right Shift
	0x0F123FF0,          //#afd_usParam[2]  I2C Data Mask
	0x0F1203E8,          //#afd_usParam[3]  PWM Period
	0x0F120000,          //#afd_usParam[4]  PWM Divider
	0x0F120050,          //#afd_usParam[5]  SlowMotion Delay    reduce lens collision noise.
	0x0F120008,          //#afd_usParam[6]  SlowMotion Threshold
	0x0F120008,          //#afd_usParam[7]  Signal Shaping
	0x0F120040,          //#afd_usParam[8]  Signal Shaping level
	0x0F120080,          //#afd_usParam[9]  Signal Shaping level
	0x0F1200C0,          //#afd_usParam[10] Signal Shaping level
	0x0F1200E0,          //#afd_usParam[11] Signal Shaping level

	0x002A0224,
	0x0F120003, //REG_TC_AF_AfCmd//Initialize AF subsystem (AF driver AF algorithm

	//===================================================================
	// Flash setting
	//===================================================================
	0x002A018C,
	0x0F120001, //REG_TC_IPRM_AuxConfig// bit[0] : Flash is in use bit[1] : Mechan
	0x0F120003, //REG_TC_IPRM_AuxPolarity// bit[0] : Flash polarity (1 is active h
	0x0F120003, //REG_TC_IPRM_AuxGpios//1-4 : Flash GPIO number If GPIO number is

	//===================================================================
	// 1-H timing setting
	//===================================================================
	0x002A1686,
	0x0F12005C, //senHal_uAddColsBin
	0x0F12005C, //senHal_uAddColsNoBin
	0x0F12085C, //senHal_uMinColsHorBin
	0x0F12005C, //senHal_uMinColsNoHorBin
	0x0F12025A, //senHal_uMinColsAddAnalogBin

	//===================================================================
	// Forbidden area setting
	//===================================================================
	0x002A1844,
	0x0F120000,                   //senHal_bSRX                  //SRX off

	0x002A1680,
	0x0F120002,                   //senHal_NExpLinesCheckFine                  //0

	0x002A0ED2,
	0x0F120FA0,	                  //setot_uOnlineClocksDiv40

	//===================================================================
	// Preview subsampling mode
	//===================================================================
	0x002A18F8,
	0x0F120001,                   //senHal_bAACActiveWait2Start
	0x002A18F6,
	0x0F120001,                   //senHal_bAlwaysAAC
	0x002A182C,
	0x0F120001,                   //senHal_bSenAAC
	0x002A0EE4,
	0x0F120001,                   //setot_bUseDigitalHbin
	0x002A1674,
	0x0F120002,                   //senHal_SenBinFactor                  // 2:2x2
	0x0F120002,                   //senHal_SamplingType                  // 0:Full
	0x0F120000,                   //senHal_SamplingMode                  // 0:2x2

	//===================================================================
	// PLL setting for Max frequency (EVT0.1) 2010.08.05 - Do not remove
	//===================================================================
	0x002A19AE,
	0x0F12EA60,                   //pll_uMaxSysFreqKhz
	0x0F127530,                   //pll_uMaxPVIFreq4KH
	0x002A19C2,
	0x0F127530,                   //pll_uMaxMIPIFreq4KH
	0x002A0244,
	0x0F127530,                   //REG_0TC_PCFG_usMaxOut4KHzRate
	0x002A0336,
	0x0F127530,                   //REG_0TC_CCFG_usMaxOut4KHzRate

	//===================================================================
	// Init Parameters
	//===================================================================
	//MCLK
	0x002A0188,
	0x0F125DC0,                   //REG_TC_IPRM_InClockLSBs
	0x0F120000,                   //REG_TC_IPRM_InClockMSBs
	0x002A01B2,
	0x0F120001,                   //REG_TC_IPRM_UseNPviClocks
	0x0F120002,                   //REG_TC_IPRM_UseNMipiClocks
	0x002A01B8,
	0x0F120001,                   //REG_TC_IPRM_bBlockInternalPllCalc


	//SCLK & PCLK                    // clock set 0
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98
	0x0F1254F8,	                  //57E4	                  //61A8

	//SCLK & PCLK                    // clock set 1
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98
	0x0F1254F8,	                  //57E4	                  //61A8

	//SCLK & PCLK                    // clock set 2
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98
	0x0F1254F8,	                  //57E4	                  //61A8

	0x002A1B78,
	0x0F1238A4,                           //  REGM_gSensorClocks_0__PLL_usClkFreqD
	0x0F120074,                           //  REGM_gSensorClocks_0__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_0__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_0__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_0__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_0__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_SysD
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_PviD
	0x0F120006,                           //  REGM_gSensorClocks_0__PLL_PllHW_DblD
	0x0F12000C,                           //  REGM_gSensorClocks_0__PLL_PllHW_OIF_
	0x0F125DC0,                           //  REGM_gSensorClocks_0__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_0__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_0__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_0__usOIFDenum

	0x002A1B9C,
	0x0F1238A4,                           //  REGM_gSensorClocks_1__PLL_usClkFreqD
	0x0F120074,                           //  REGM_gSensorClocks_1__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_1__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_1__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_1__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_1__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_SysD
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_PviD
	0x0F120006,                           //  REGM_gSensorClocks_1__PLL_PllHW_DblD
	0x0F12000C,                           //  REGM_gSensorClocks_1__PLL_PllHW_OIF_
	0x0F125DC0,                           //  REGM_gSensorClocks_1__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_1__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_1__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_1__usOIFDenum

	0x002A1BC0,
	0x0F1238A4,                           //  REGM_gSensorClocks_2__PLL_usClkFreqD
	0x0F120074,                           //  REGM_gSensorClocks_2__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_2__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_2__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_2__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_2__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_SysD
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_PviD
	0x0F120006,                           //  REGM_gSensorClocks_2__PLL_PllHW_DblD
	0x0F12000C,                           //  REGM_gSensorClocks_2__PLL_PllHW_OIF_
	0x0F125DC0,                           //  REGM_gSensorClocks_2__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_2__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_2__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_2__usOIFDenum


	0x002A01CC,
	0x0F120001,                   //REG_TC_IPRM_InitParamsUpdated

	0xFFFF000A,     //p10


	//===================================================================
	// Input Width & Height
	//===================================================================
	0x002A01F6,
	0x0F120800, //REG_TC_GP_PrevReqInputWidth	//Sensor Crop Width	2048
	0x0F120600, //REG_TC_GP_PrevReqInputHeight//Sensor Crop Height 1536
	0x0F120000, //REG_TC_GP_PrevInputWidthOfs	//Sensor HOffset 0
	0x0F120000, //REG_TC_GP_PrevInputHeightOfs//Sensor VOffset 0
	0x0F120800, //REG_TC_GP_CapReqInputWidth	//Sensor Crop Width	2048
	0x0F120600, //REG_TC_GP_CapReqInputHeight	//Sensor Crop Height 1536
	0x0F120000, //REG_TC_GP_CapInputWidthOfs	//Sensor HOffset 0
	0x0F120000, //REG_TC_GP_CapInputHeightOfs	//Sensor VOffset 0

	0x002A0216,
	0x0F120001, //REG_TC_GP_bUseReqInputInPre
	0x0F120001, //REG_TC_GP_bUseReqInputInCap

	0x002A043C,
	0x0F120800, //REG_TC_PZOOM_ZoomInputWidth
	0x0F120600, //REG_TC_PZOOM_ZoomInputHeight
	0x0F120000, //REG_TC_PZOOM_ZoomInputWidthOfs
	0x0F120000, //REG_TC_PZOOM_ZoomInputHeightOfs

	//===================================================================
	// Preview 0 640 480 system 52M PCLK 87M
	//===================================================================
	0x002A023E,
	0x0F120400, //REG_0TC_PCFG_usWidth
	0x0F120300, //REG_0TC_PCFG_usHeight
	0x0F120005, //REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate

	0x002A024C,
	0x0F120012, //REG_0TC_PCFG_PVIMask    => cmk 2010.10.29 s0042 => s0052 Invert
	0x0F120010, //REG_0TC_PCFG_OIFMask

	0x002A0254,
	0x0F120001, //REG_0TC_PCFG_uClockInd
	0x0F120000, //REG_0TC_PCFG_usFrTimeType
	0x0F120001, //REG_0TC_PCFG_FrRateQualityType
	0x0F1203E8, //REG_0TC_PCFG_usMaxFrTimeMsecMult10//max frame time : 30fps 014D
	0x0F12014E, //REG_0TC_PCFG_usMinFrTimeMsecMult10//min frame time : 30fps 014D

	0x0F120000, //REG_0TC_PCFG_bSmearOutput
	0x0F120000, //REG_0TC_PCFG_sSaturation
	0x0F120000, //REG_0TC_PCFG_sSharpBlur
	0x0F120000, //REG_0TC_PCFG_sColorTemp
	0x0F120000, //REG_0TC_PCFG_uDeviceGammaIndex
#if 1 /* [P4W] fix rotation to 180*/
	0x0F120003, //REG_0TC_PCFG_uPrevMirror
	0x0F120003, //REG_0TC_PCFG_uCaptureMirror
#endif
	0x0F120000, //REG_0TC_PCFG_uRotation


	//===================================================================
	// Capture 0 2048x1536 system 52M PCLK 87M
	//===================================================================

	0x002A032E,
	0x0F120000,                   //REG_0TC_CCFG_uCaptureMode

	0x0F120800,                   //REG_0TC_CCFG_usWidth
	0x0F120600,                   //REG_0TC_CCFG_usHeight
	0x0F120005,                   //REG_0TC_CCFG_Format
	0x0F1254F6,	                  //REG_0TC_CCFG_usMaxOut4KHzRate
	0x0F1254F6,	                  //REG_0TC_CCFG_usMinOut4KHzRate

	0x002A033E,
	0x0F120010,                   //REG_0TC_CCFG_PVIMask        => cmk 2010.10.29
	0x0F120010,                   //REG_0TC_CCFG_OIFMask
	0x0F1203C0,                   //REG_0TC_CCFG_usJpegPacketSize

	0x002A0346,
	0x0F120001,                   //REG_0TC_CCFG_uClockInd
	0x0F120002,                   //REG_0TC_CCFG_usFrTimeType
	0x0F120002,                   //REG_0TC_CCFG_FrRateQualityType
	0x0F120535,                   //REG_0TC_CCFG_usMaxFrTimeMsecMult10
	0x0F12029A,                   //REG_0TC_CCFG_usMinFrTimeMsecMult10
	0x0F120000,                   //REG_0TC_CCFG_bSmearOutput
	0x0F120000,                   //REG_0TC_CCFG_sSaturation
	0x0F120000,                   //REG_0TC_CCFG_sSharpBlur
	0x0F120000,                   //REG_0TC_CCFG_sColorTemp
	0x0F120000,                   //REG_0TC_CCFG_uDeviceGammaIndex

	0x002A0426,
	0x0F120055,                   //REG_TC_BRC_usCaptureQuality


	0x002A1E5C,            //Mon_LT_uDefMinFrExpDelta
	0x0F120000,

	//===================================================================
	// Capture 1 640x480 system 52M PCLK 87M
	//===================================================================
	0x002A035A,
	0x0F120000,                   //REG_1TC_CCFG_uCaptureMode

	0x0F120280,                   //REG_1TC_CCFG_usWidth
	0x0F1201E0,                   //REG_1TC_CCFG_usHeight
	0x0F120005,                   //REG_1TC_CCFG_Format
	0x0F1254F6,	                  //REG_1TC_CCFG_usMaxOut4KHzRate
	0x0F1254F6,	                  //REG_1TC_CCFG_usMinOut4KHzRate

	0x002A036A,
	0x0F120010,                   //REG_1TC_CCFG_PVIMask        => cmk 2010.10.29
	0x0F120010,                   //REG_1TC_CCFG_OIFMask
	0x0F1203C0,                   //REG_1TC_CCFG_usJpegPacketSize

	0x002A0372,
	0x0F120001,                   //REG_1TC_CCFG_uClockInd
	0x0F120002,                   //REG_1TC_CCFG_usFrTimeType
	0x0F120002,                   //REG_1TC_CCFG_FrRateQualityType
	0x0F120535,                  //REG_1TC_CCFG_usMaxFrTimeMsecMult10
	0x0F12029A,                   //REG_1TC_CCFG_usMinFrTimeMsecMult10
	0x0F120000,                   //REG_1TC_CCFG_bSmearOutput
	0x0F120000,                   //REG_1TC_CCFG_sSaturation
	0x0F120000,                   //REG_1TC_CCFG_sSharpBlur
	0x0F120000,                   //REG_1TC_CCFG_sColorTemp
	0x0F120000,                   //REG_1TC_CCFG_uDeviceGammaIndex

	0x002A0426,
	0x0F120055,                   //REG_1TC_BRC_usCaptureQuality


	0x002A1E5C,            //Mon_LT_uDefMinFrExpDelta
	0x0F120000,

	//===================================================================
	// AFC
	//===================================================================
	//Auto
	0x002A0F08,
	0x0F120000, //AFC_Default60Hz   01:60hz 00:50Hz
	0x002A04A4,
	0x0F12067F, //REG_TC_DBG_AutoAlgEnBits 065f : Manual AFC on   067f : Manual AF

	//===================================================================
	// Shading (AF module)
	//===================================================================
	// TVAR_ash_pGAS_high
	0x002A0D22,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,

	// TVAR_ash_pGAS_low
	0x0F126E49,
	0x0F12FB98,
	0x0F12F348,
	0x0F121BD6,
	0x0F12EBEF,
	0x0F1203D3,
	0x0F12EC8D,
	0x0F12F239,
	0x0F120E64,
	0x0F12F7EA,
	0x0F12FD3B,
	0x0F120A7C,
	0x0F12FC9C,
	0x0F120BD3,
	0x0F12F2E5,
	0x0F120619,
	0x0F120772,
	0x0F12F0B0,
	0x0F12184E,
	0x0F12F95F,
	0x0F120B1A,
	0x0F12FC45,
	0x0F12F716,
	0x0F120DCD,
	0x0F12EF24,
	0x0F120221,
	0x0F12F6BD,
	0x0F1204CB,
	0x0F1200B1,
	0x0F12FEB0,
	0x0F120268,
	0x0F1202C7,
	0x0F12010A,
	0x0F12FF93,
	0x0F12036D,
	0x0F12F859,
	0x0F1281D0,
	0x0F12FA32,
	0x0F12EFDB,
	0x0F12234D,
	0x0F12E799,
	0x0F120337,
	0x0F12EB05,
	0x0F12E8F9,
	0x0F12152E,
	0x0F12F0D5,
	0x0F120842,
	0x0F12043A,
	0x0F12F461,
	0x0F120E58,
	0x0F12F658,
	0x0F12075D,
	0x0F12F78D,
	0x0F12FDE9,
	0x0F12277A,
	0x0F12FFDE,
	0x0F12FD3B,
	0x0F12FE50,
	0x0F120AD1,
	0x0F12FE2C,
	0x0F12E90D,
	0x0F12F7B0,
	0x0F1205DB,
	0x0F1202CD,
	0x0F12F4F1,
	0x0F1202A8,
	0x0F12FDDC,
	0x0F120B59,
	0x0F12F74E,
	0x0F1203D5,
	0x0F12FF4F,
	0x0F1200F7,
	0x0F126A44,
	0x0F12FAD6,
	0x0F12F261,
	0x0F121F28,
	0x0F12E691,
	0x0F1207D2,
	0x0F12EE85,
	0x0F12F426,
	0x0F120F26,
	0x0F12F34B,
	0x0F120036,
	0x0F120C0F,
	0x0F12FDA9,
	0x0F1209EA,
	0x0F12F27A,
	0x0F120CD5,
	0x0F1201E1,
	0x0F12ED41,
	0x0F121DB5,
	0x0F12FD26,
	0x0F1203F7,
	0x0F12F7BB,
	0x0F12FE81,
	0x0F1212D3,
	0x0F12E061,
	0x0F12F81C,
	0x0F1207B1,
	0x0F120408,
	0x0F12F860,
	0x0F12FC9A,
	0x0F120DDE,
	0x0F120C9C,
	0x0F12F2A4,
	0x0F1202EB,
	0x0F12099B,
	0x0F12F5A6,
	0x0F127243,
	0x0F12F74D,
	0x0F12F74B,
	0x0F121800,
	0x0F12EF22,
	0x0F120263,
	0x0F12EBE7,
	0x0F12F5A4,
	0x0F1209D3,
	0x0F12FAB8,
	0x0F12FDFF,
	0x0F12086B,
	0x0F120338,
	0x0F120514,
	0x0F12F840,
	0x0F120768,
	0x0F12FE55,
	0x0F12F884,
	0x0F121488,
	0x0F12FFCD,
	0x0F12035B,
	0x0F12FA4E,
	0x0F1201DB,
	0x0F1206D6,
	0x0F12EE19,
	0x0F12FEA3,
	0x0F12FE8C,
	0x0F1203A3,
	0x0F12FDDB,
	0x0F12FD9B,
	0x0F12035E,
	0x0F1203F2,
	0x0F12FCBD,
	0x0F120300,
	0x0F12FF2E,
	0x0F12FE03,

	0x002A04A8,
	0x0F120001, //REG_TC_DBG_ReInitCmd

	//===================================================================
	// Shading - Alpha
	//===================================================================
	0x002A07E8,
	0x0F1200BC, //TVAR_ash_AwbAshCord_0_//HOR
	0x0F1200ED, //TVAR_ash_AwbAshCord_1_//INCA
	0x0F120101, //TVAR_ash_AwbAshCord_2_//WW
	0x0F12012D, //TVAR_ash_AwbAshCord_3_//CW
	0x0F120166, //TVAR_ash_AwbAshCord_4_//D50
	0x0F120184, //TVAR_ash_AwbAshCord_5_//D65
	0x0F1201A0, //TVAR_ash_AwbAshCord_6_//D75
	0x002A07FE,
	0x0F123200, //TVAR_ash_GASAlpha_0__0_
	0x0F124000, //TVAR_ash_GASAlpha_0__1_
	0x0F124000, //TVAR_ash_GASAlpha_0__2_
	0x0F123C00, //TVAR_ash_GASAlpha_0__3_
	0x0F123200, //TVAR_ash_GASAlpha_1__0_
	0x0F124000, //TVAR_ash_GASAlpha_1__1_
	0x0F124000, //TVAR_ash_GASAlpha_1__2_
	0x0F123C00, //TVAR_ash_GASAlpha_1__3_
	0x0F123200, //TVAR_ash_GASAlpha_2__0_
	0x0F124000, //TVAR_ash_GASAlpha_2__1_
	0x0F124000, //TVAR_ash_GASAlpha_2__2_
	0x0F123C00, //TVAR_ash_GASAlpha_2__3_
	0x0F123200, //TVAR_ash_GASAlpha_3__0_
	0x0F124000, //TVAR_ash_GASAlpha_3__1_
	0x0F124000, //TVAR_ash_GASAlpha_3__2_
	0x0F123C00, //TVAR_ash_GASAlpha_3__3_
	0x0F123200, //TVAR_ash_GASAlpha_4__0_
	0x0F124000, //TVAR_ash_GASAlpha_4__1_
	0x0F124000, //TVAR_ash_GASAlpha_4__2_
	0x0F123C00, //TVAR_ash_GASAlpha_4__3_
	0x0F123200, //TVAR_ash_GASAlpha_5__0_
	0x0F124000, //TVAR_ash_GASAlpha_5__1_
	0x0F124000, //TVAR_ash_GASAlpha_5__2_
	0x0F123C00, //TVAR_ash_GASAlpha_5__3_
	0x0F123F00,	//TVAR_ash_GASAlpha_6__0_
	0x0F124000, //TVAR_ash_GASAlpha_6__1_
	0x0F124000, //TVAR_ash_GASAlpha_6__2_
	0x0F124000, //TVAR_ash_GASAlpha_6__3_

	0x002A0836,
	0x0F123F00,	//TVAR_ash_GASOutdoorAlpha_0_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_1_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_2_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_3_

	//===================================================================
	// Gamma
	//===================================================================
	//	param_start	SARR_usGammaLutRGBIndoor
	0x002A0660,
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[0][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[0][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[0][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[0][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[0][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[0][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[0][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[0][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[0][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[0][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[0][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[0][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[0][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[0][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[0][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[0][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[0][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[0][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[0][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[0][19]
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[1][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[1][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[1][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[1][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[1][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[1][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[1][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[1][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[1][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[1][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[1][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[1][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[1][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[1][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[1][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[1][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[1][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[1][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[1][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[1][19]
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[2][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[2][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[2][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[2][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[2][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[2][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[2][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[2][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[2][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[2][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[2][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[2][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[2][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[2][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[2][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[2][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[2][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[2][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[2][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[2][19]

	//s002A06D8
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[0][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[0][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[0][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[0][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[0][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[0][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[0][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[0][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[0][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[0][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[0][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[0][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[0][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[0][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[0][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[0][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[0][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[0][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[0][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[0][19]
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[1][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[1][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[1][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[1][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[1][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[1][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[1][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[1][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[1][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[1][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[1][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[1][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[1][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[1][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[1][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[1][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[1][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[1][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[1][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[1][19]
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[2][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[2][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[2][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[2][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[2][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[2][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[2][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[2][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[2][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[2][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[2][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[2][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[2][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[2][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[2][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[2][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[2][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[2][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[2][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[2][19]

	//===================================================================
	// AE - shutter
	//===================================================================
	//****************************************/
	// AE 2009 03 08 - based on TN
	//****************************************/
	//============================================================
	// Frame rate setting
	//============================================================
	// How to set
	// 1. Exposure value
	// dec2hex((1 / (frame rate you want(ms))) * 100d * 5d)
	//
	//
	// 2. Analog Digital gain
	// dec2hex((Analog gain you want) * 256d)
	//              Ex1) Simple Caculation for x3.25?:   3.25x256 = 832[dec] = 034
	//============================================================
	//MBR
	0x002A01DE,
	0x0F120000, //REG_TC_bUseMBR//MBR off
	//MBR off is needed to prevent a shorter integration time when the scene has b

	//AE_Target
	0x002A1308,
	0x0F12003E, //TVAR_ae_BrAve
	0x002A130E,
	0x0F12000F, //ae_StatMode
	//ae_StatMode bit[3] BLC has to be bypassed to prevent AE weight change especi

	//AE_state
	0x002A04EE,
	0x0F12010E, //#lt_uLimitHigh
	0x0F1200F5, //#lt_uLimitLow

	//For 60Hz
	0x002A0504,
	0x0F123415, //#lt_uMaxExp1
	0x002A0508,
	0x0F12681F, //#lt_uMaxExp2
	0x002A050C,
	0x0F128227, //#lt_uMaxExp3
	0x002A0510,
	0x0F12C350, //#lt_uMaxExp4

	0x002A0514,
	0x0F123415, //#lt_uCapMaxExp1
	0x002A0518,
	0x0F12681F, //#lt_uCapMaxExp2
	0x002A051C,
	0x0F128227, //#lt_uCapMaxExp3
	0x002A0520,
	0x0F12C350, //#lt_uCapMaxExp4

	0x002A0524,
	0x0F1201E0, //#lt_uMaxAnGain1
	0x0F1201E0, //#lt_uMaxAnGain2
	0x0F120300, //#lt_uMaxAnGain3
	0x0F120840, //#lt_uMaxAnGain4

	0x0F120100, //#lt_uMaxDigGain
	0x0F128000, //#lt_uMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	0x0F1201E0, //#lt_uCapMaxAnGain1
	0x0F1201E0, //#lt_uCapMaxAnGain2
	0x0F120300, //#lt_uCapMaxAnGain3
	0x0F120710, //#lt_uCapMaxAnGain4

	0x0F120100, //#lt_uCapMaxDigGain
	0x0F128000, //#lt_uCapMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	//===================================================================
	//AE - Weights
	//===================================================================
	0x002A1316,
	0x0F120000, //ae_WeightTbl_16[0]
	0x0F120000, //ae_WeightTbl_16[1]
	0x0F120000, //ae_WeightTbl_16[2]
	0x0F120000, //ae_WeightTbl_16[3]
	0x0F120101, //ae_WeightTbl_16[4]
	0x0F120101, //ae_WeightTbl_16[5]
	0x0F120101, //ae_WeightTbl_16[6]
	0x0F120101, //ae_WeightTbl_16[7]
	0x0F120101, //ae_WeightTbl_16[8]
	0x0F120201, //ae_WeightTbl_16[9]
	0x0F120102, //ae_WeightTbl_16[10]
	0x0F120101, //ae_WeightTbl_16[11]
	0x0F120101, //ae_WeightTbl_16[12]
	0x0F120202, //ae_WeightTbl_16[13]
	0x0F120202, //ae_WeightTbl_16[14]
	0x0F120101, //ae_WeightTbl_16[15]
	0x0F120101, //ae_WeightTbl_16[16]
	0x0F120202, //ae_WeightTbl_16[17]
	0x0F120202, //ae_WeightTbl_16[18]
	0x0F120101, //ae_WeightTbl_16[19]
	0x0F120201, //ae_WeightTbl_16[20]
	0x0F120202, //ae_WeightTbl_16[21]
	0x0F120202, //ae_WeightTbl_16[22]
	0x0F120102, //ae_WeightTbl_16[23]
	0x0F120201, //ae_WeightTbl_16[24]
	0x0F120202, //ae_WeightTbl_16[25]
	0x0F120202, //ae_WeightTbl_16[26]
	0x0F120102, //ae_WeightTbl_16[27]
	0x0F120101, //ae_WeightTbl_16[28]
	0x0F120101, //ae_WeightTbl_16[29]
	0x0F120101, //ae_WeightTbl_16[30]
	0x0F120101, //ae_WeightTbl_16[31]

	//===================================================================
	//AWB-BASIC setting
	//===================================================================
	0x002A1018,
	0x0F1202A7, //awbb_GLocusR
	0x0F120343, //awbb_GLocusB
	0x002A0FFC,
	0x0F12036C, //awbb_CrclLowT_R_c
	0x002A1000,
	0x0F12011D, //awbb_CrclLowT_B_c
	0x002A1004,
	0x0F1262C1, //awbb_CrclLowT_Rad_c
	0x002A1034,
	0x0F1205F0, //awbb_GamutWidthThr1
	0x0F1201F4, //awbb_GamutHeightThr1
	0x0F12006C, //awbb_GamutWidthThr2
	0x0F120038, //awbb_GamutHeightThr2
	0x002A1020,
	0x0F12000C, //awbb_MinNumOfFinalPatches
	0x0F12001E, //awbb_MinNumOfLowBrFinalPatches
	0x0F120046, //awbb_MinNumOfLowBr0_FinalPatches
	0x002A291A,
	0x0F120006, // #Mon_AWB_ByPassMode          // [0]Outdoor [1]LowBr [2]LowTemp

	0x002A11C2,
	0x0F120000, //awbb_RGainOff
	0x0F120000, //awbb_BGainOff
	0x0F120000, //awbb_GGainOff
	0x0F1200C2, //awbb_Alpha_Comp_Mode
	0x0F120002, //awbb_Rpl_InvalidOutDoor
	0x0F120001, //awbb_UseGrThrCorr
	0x0F1200E4, //awbb_Use_Filters
	0x0F12053C, //awbb_GainsInit[0]
	0x0F120400, //awbb_GainsInit[1]
	0x0F12055C, //awbb_GainsInit[2]
	0x0F120008,	//001E	//awbb_WpFilterMinThr
	0x0F120160,	//0190	//awbb_WpFilterMaxThr
	0x0F1200A0, //awbb_WpFilterCoef
	0x0F120004, //awbb_WpFilterSize
	0x0F120001, //awbb_otp_disable

	//===================================================================
	//AWB-Zone
	//===================================================================
	//	param_start	awbb_IndoorGrZones_m_BGrid
	0x002A0F28,
	0x0F1203C0, //03C0//03C0//awbb_IndoorGrZones_m_BGrid[0]
	0x0F1203E2, //03E2//03E2//awbb_IndoorGrZones_m_BGrid[1]
	0x0F120356, //0356//0356//awbb_IndoorGrZones_m_BGrid[2]
	0x0F1203FC, //03FC//03FC//awbb_IndoorGrZones_m_BGrid[3]
	0x0F12031E, //031E//031E//awbb_IndoorGrZones_m_BGrid[4]
	0x0F1203FE, //03FE//03FE//awbb_IndoorGrZones_m_BGrid[5]
	0x0F1202F0, //02F0//02F0//awbb_IndoorGrZones_m_BGrid[6]
	0x0F1203F0, //03F0//03F0//awbb_IndoorGrZones_m_BGrid[7]
	0x0F1202CA, //02CA//02CA//awbb_IndoorGrZones_m_BGrid[8]
	0x0F1203CC, //03CC//03CC//awbb_IndoorGrZones_m_BGrid[9]
	0x0F1202A8, //02A8//02A8//awbb_IndoorGrZones_m_BGrid[10]
	0x0F12037A, //037A//037A//awbb_IndoorGrZones_m_BGrid[11]
	0x0F120280, //0288//0288//awbb_IndoorGrZones_m_BGrid[12]
	0x0F12033C, //033C//033C//awbb_IndoorGrZones_m_BGrid[13]
	0x0F120260, //0266//0266//awbb_IndoorGrZones_m_BGrid[14]
	0x0F12030A, //030A//031E//awbb_IndoorGrZones_m_BGrid[15]
	0x0F120242, //0246//0246//awbb_IndoorGrZones_m_BGrid[16]
	0x0F1202DC, //02EC//0300//awbb_IndoorGrZones_m_BGrid[17]
	0x0F120228, //0228//0228//awbb_IndoorGrZones_m_BGrid[18]
	0x0F1202B2, //02CE//02E8//awbb_IndoorGrZones_m_BGrid[19]
	0x0F12020E, //020E//020E//awbb_IndoorGrZones_m_BGrid[20]
	0x0F120290, //02B0//02CA//awbb_IndoorGrZones_m_BGrid[21]
	0x0F1201F8, //01F8//01F8//awbb_IndoorGrZones_m_BGrid[22]
	0x0F120276, //0292//02B0//awbb_IndoorGrZones_m_BGrid[23]
	0x0F1201E8, //01E8//01E8//awbb_IndoorGrZones_m_BGrid[24]
	0x0F120268, //0276//0296//awbb_IndoorGrZones_m_BGrid[25]
	0x0F1201DC, //01DC//01DC//awbb_IndoorGrZones_m_BGrid[26]
	0x0F120256, //0256//027A//awbb_IndoorGrZones_m_BGrid[27]
	0x0F1201E0, //01E0//01E0//awbb_IndoorGrZones_m_BGrid[28]
	0x0F120238, //0238//0252//awbb_IndoorGrZones_m_BGrid[29]
	0x0F1201EC, //01EC//01F2//awbb_IndoorGrZones_m_BGrid[30]
	0x0F12020E, //020E//0226//awbb_IndoorGrZones_m_BGrid[31]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[32]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[33]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[34]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[35]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[36]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[37]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[38]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[39]
	//	param_end	awbb_IndoorGrZones_m_BGrid

	0x0F120005, //awbb_IndoorGrZones_m_Grid
	0x002A0F80,
	0x0F1200E6, //awbb_IndoorGrZones_m_Boff
	0x002A0F7C,
	0x0F120010,

	//	param_start	awbb_OutdoorGrZones_m_BGrid
	0x002A0F84,
	0x0F12028E,	//awbb_OutdoorGrZones_m_BGrid[0]
	0x0F1202A6,	//awbb_OutdoorGrZones_m_BGrid[1]
	0x0F120276, //awbb_OutdoorGrZones_m_BGrid[2]
	0x0F1202B8,	//awbb_OutdoorGrZones_m_BGrid[3]
	0x0F120264,	//awbb_OutdoorGrZones_m_BGrid[4]
	0x0F1202BE,	//awbb_OutdoorGrZones_m_BGrid[5]
	0x0F120252,	//awbb_OutdoorGrZones_m_BGrid[6]
	0x0F1202C0,	//awbb_OutdoorGrZones_m_BGrid[7]
	0x0F120244,	//awbb_OutdoorGrZones_m_BGrid[8]
	0x0F1202BC,	//awbb_OutdoorGrZones_m_BGrid[9]
	0x0F120234,	//awbb_OutdoorGrZones_m_BGrid[10]
	0x0F1202B2,	//awbb_OutdoorGrZones_m_BGrid[11]
	0x0F120228,	//awbb_OutdoorGrZones_m_BGrid[12]
	0x0F1202A6,	//awbb_OutdoorGrZones_m_BGrid[13]
	0x0F12021E,	//awbb_OutdoorGrZones_m_BGrid[14]
	0x0F12029C, //awbb_OutdoorGrZones_m_BGrid[15]
	0x0F120216,	//awbb_OutdoorGrZones_m_BGrid[16]
	0x0F12028A,	//awbb_OutdoorGrZones_m_BGrid[17]
	0x0F120216, //awbb_OutdoorGrZones_m_BGrid[18]
	0x0F120278,	//awbb_OutdoorGrZones_m_BGrid[19]
	0x0F120220,	//awbb_OutdoorGrZones_m_BGrid[20]
	0x0F12026A,	//awbb_OutdoorGrZones_m_BGrid[21]
	0x0F120232,	//awbb_OutdoorGrZones_m_BGrid[22]
	0x0F12024A,	//awbb_OutdoorGrZones_m_BGrid[23]
	//	param_end	awbb_OutdoorGrZones_m_BGrid

	0x0F120004, //awbb_OutdoorGrZones_m_Gri
	0x002A0FB8,
	0x0F12000C,	//awbb_OutdoorGrZones_ZInfo_m_GridSz
	0x002A0FBC,
	0x0F1201E4,	//awbb_OutdoorGrZones_m_Bof

	//	param_start	awbb_LowBrGrZones_m_BGrid
	0x002A0FC0,
	0x0F1203B2, //awbb_LowBrGrZones_m_BGrid[0]
	0x0F12044E, //awbb_LowBrGrZones_m_BGrid[1]
	0x0F120330, //awbb_LowBrGrZones_m_BGrid[2]
	0x0F120454, //awbb_LowBrGrZones_m_BGrid[3]
	0x0F1202CC, //awbb_LowBrGrZones_m_BGrid[4]
	0x0F120414, //awbb_LowBrGrZones_m_BGrid[5]
	0x0F12026E, //awbb_LowBrGrZones_m_BGrid[6]
	0x0F1203D0, //awbb_LowBrGrZones_m_BGrid[7]
	0x0F120226, //awbb_LowBrGrZones_m_BGrid[8]
	0x0F120362, //awbb_LowBrGrZones_m_BGrid[9]
	0x0F1201F0, //awbb_LowBrGrZones_m_BGrid[10]
	0x0F120312, //awbb_LowBrGrZones_m_BGrid[11]
	0x0F1201CE, //awbb_LowBrGrZones_m_BGrid[12]
	0x0F1202CC, //awbb_LowBrGrZones_m_BGrid[13]
	0x0F1201B2, //awbb_LowBrGrZones_m_BGrid[14]
	0x0F12029E, //awbb_LowBrGrZones_m_BGrid[15]
	0x0F1201AC, //awbb_LowBrGrZones_m_BGrid[16]
	0x0F120278, //awbb_LowBrGrZones_m_BGrid[17]
	0x0F1201B6, //awbb_LowBrGrZones_m_BGrid[18]
	0x0F120248, //awbb_LowBrGrZones_m_BGrid[19]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[20]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[21]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[22]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[23]

	//	param_end	awbb_LowBrGrZones_m_BGrid
	0x0F120006, //awbb_LowBrGrZones_m_GridStep
	0x002A0FF4,
	0x0F12000A, //awbb_LowBrGrZones_ZInfo_m_GridSz
	0x002A0FF8,
	0x0F1200C2, //awbb_LowBrGrZones_m_Boffs

	//===================================================================
	//AWB Scene Detection
	//===================================================================
	0x002A1098,
	0x0F12FE82, //awbb_SCDetectionMap_SEC_StartR_B
	0x0F12001E, //awbb_SCDetectionMap_SEC_StepR_B
	0x0F1209C4, //awbb_SCDetectionMap_SEC_SunnyNB
	0x0F120122, //awbb_SCDetectionMap_SEC_StepNB
	0x0F1200E4, //awbb_SCDetectionMap_SEC_LowTempR_B
	0x0F120096, //awbb_SCDetectionMap_SEC_SunnyNBZone
	0x0F12000E, //awbb_SCDetectionMap_SEC_LowTempR_BZone

	0x002A105C,
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__2_
	0x0F120500, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__4_
	0x0F125555, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__1_
	0x0F125455, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__3_
	0x0F12AA55, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__0_
	0x0F12AAAA, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__2_
	0x0F12BF54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__3_
	0x0F12FF6F, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__2_
	0x0F121B54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__3_
	0x0F12FF06, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__2_
	0x0F120154, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__4_
	0x0F12BFBF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__1_
	0x0F1254BE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__3_

	//===================================================================
	//AWB - GridCorrection
	//===================================================================

	0x002A11E0,
	0x0F120002, //awbb_GridEnable

	0x002A11A8,
	0x0F1202C8, //awbb_GridConst_1[0]
	0x0F120325, //awbb_GridConst_1[1]
	0x0F12038F, //awbb_GridConst_1[2]

	0x0F120F8E, //awbb_GridConst_2[0]
	0x0F1210B3, //awbb_GridConst_2[1]
	0x0F121136, //awbb_GridConst_2[2]
	0x0F121138, //awbb_GridConst_2[3]
	0x0F12118E, //awbb_GridConst_2[4]
	0x0F121213, //awbb_GridConst_2[5]

	0x0F1200A7, //awbb_GridCoeff_R_1
	0x0F1200C2, //awbb_GridCoeff_B_1
	0x0F1200BD, //awbb_GridCoeff_R_2
	0x0F1200AC, //awbb_GridCoeff_B_2

	0x002A1118,
	0x0F120050, //0032//awbb_GridCorr_R[0][0]
	0x0F120032, //0012//awbb_GridCorr_R[0][1]
	0x0F120032, //0012//awbb_GridCorr_R[0][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[0][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[0][4]
	0x0F120060, //0050//awbb_GridCorr_R[0][5]
	0x0F120050, //0032//awbb_GridCorr_R[1][0]
	0x0F120032, //0012//awbb_GridCorr_R[1][1]
	0x0F120032, //0012//awbb_GridCorr_R[1][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[1][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[1][4]
	0x0F120060, //0050//awbb_GridCorr_R[1][5]
	0x0F120050, //0032//awbb_GridCorr_R[2][0]
	0x0F120032, //0012//awbb_GridCorr_R[2][1]
	0x0F120032, //0012//awbb_GridCorr_R[2][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[2][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[2][4]
	0x0F120060, //0050//awbb_GridCorr_R[2][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[0][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[0][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[0][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[0][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[0][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[0][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[1][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[1][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[1][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[1][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[1][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[1][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[2][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[2][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[2][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[2][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[2][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[2][5]

	0x002A1160,
	0x0F12000A, //awbb_GridCorr_R_Out[0][0]
	0x0F12000A, //awbb_GridCorr_R_Out[0][1]
	0x0F120000, //awbb_GridCorr_R_Out[0][2]
	0x0F120000, //awbb_GridCorr_R_Out[0][3]
	0x0F120000, //awbb_GridCorr_R_Out[0][4]
	0x0F120000, //awbb_GridCorr_R_Out[0][5]
	0x0F12000A, //awbb_GridCorr_R_Out[1][0]
	0x0F12000A, //awbb_GridCorr_R_Out[1][1]
	0x0F120000, //awbb_GridCorr_R_Out[1][2]
	0x0F120000, //awbb_GridCorr_R_Out[1][3]
	0x0F120000, //awbb_GridCorr_R_Out[1][4]
	0x0F120000, //awbb_GridCorr_R_Out[1][5]
	0x0F12000A, //awbb_GridCorr_R_Out[2][0]
	0x0F12000A, //awbb_GridCorr_R_Out[2][1]
	0x0F120000, //awbb_GridCorr_R_Out[2][2]
	0x0F120000, //awbb_GridCorr_R_Out[2][3]
	0x0F120000, //awbb_GridCorr_R_Out[2][4]
	0x0F120000, //awbb_GridCorr_R_Out[2][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[0][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[0][1]
	0x0F120000, //awbb_GridCorr_B_Out[0][2]
	0x0F120000, //awbb_GridCorr_B_Out[0][3]
	0x0F120000, //awbb_GridCorr_B_Out[0][4]
	0x0F120000, //awbb_GridCorr_B_Out[0][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[1][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[1][1]
	0x0F120000, //awbb_GridCorr_B_Out[1][2]
	0x0F120000, //awbb_GridCorr_B_Out[1][3]
	0x0F120000, //awbb_GridCorr_B_Out[1][4]
	0x0F120000, //awbb_GridCorr_B_Out[1][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[2][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[2][1]
	0x0F120000, //awbb_GridCorr_B_Out[2][2]
	0x0F120000, //awbb_GridCorr_B_Out[2][3]
	0x0F120000, //awbb_GridCorr_B_Out[2][4]
	0x0F120000, //awbb_GridCorr_B_Out[2][5]

	//===================================================================
	// CCM
	//===================================================================
	0x002A07D2,
	0x0F1200C0, //SARR_AwbCcmCord_0_
	0x0F1200E0, //SARR_AwbCcmCord_1_
	0x0F120110, //SARR_AwbCcmCord_2_
	0x0F120139, //SARR_AwbCcmCord_3_
	0x0F120166, //SARR_AwbCcmCord_4_
	0x0F12019F, //SARR_AwbCcmCord_5_

	//	param_start	TVAR_wbt_pBaseCcms
	0x002A07C4,
	0x0F124000, //TVAR_wbt_pBaseCcms
	0x0F127000,

	0x002A4000,
	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[0]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[1]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[2]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[3]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[4]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[5]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[6]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[7]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[8]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[9]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[10]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[11]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[12]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[13]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[14]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[15]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[16]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[17]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[18]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[19]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[20]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[21]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[22]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[23]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[24]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[25]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[26]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[27]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[28]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[29]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[30]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[31]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[32]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[33]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[34]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[35]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[36]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[37]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[38]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[39]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[40]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[41]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[42]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[43]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[44]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[45]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[46]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[47]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[48]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[49]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[50]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[51]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[52]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[53]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[54]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[55]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[56]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[57]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[58]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[59]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[60]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[61]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[62]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[63]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[64]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[65]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[66]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[67]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[68]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[69]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[70]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[71]

	0x0F12011D, //00F4          //TVAR_wbt_pBaseCcms[72]
	0x0F12FFA7, //FFC2//TVAR_wbt_pBaseCcms[73]
	0x0F12FFEC, //FFFA//TVAR_wbt_pBaseCcms[74]
	0x0F12FF0D, //FF3E//TVAR_wbt_pBaseCcms[75]
	0x0F120193, //0163//TVAR_wbt_pBaseCcms[76]
	0x0F12FF34, //FF5F//TVAR_wbt_pBaseCcms[77]
	0x0F12FFCE, //FFCE//TVAR_wbt_pBaseCcms[78]
	0x0F12FFDF, //FFDF//TVAR_wbt_pBaseCcms[79]
	0x0F12015E, //015E//TVAR_wbt_pBaseCcms[80]
	0x0F120095, //0095//TVAR_wbt_pBaseCcms[81]
	0x0F120096, //0096//TVAR_wbt_pBaseCcms[82]
	0x0F12FF0B, //FF0B//TVAR_wbt_pBaseCcms[83]
	0x0F1200C3, //00C3//TVAR_wbt_pBaseCcms[84]
	0x0F12FF5C, //FF5C//TVAR_wbt_pBaseCcms[85]
	0x0F12013D, //013D//TVAR_wbt_pBaseCcms[86]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[87]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[88]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[89]

	0x0F12011D, //00F4          //TVAR_wbt_pBaseCcms[90]
	0x0F12FFA7, //FFC2//TVAR_wbt_pBaseCcms[91]
	0x0F12FFEC, //FFFA//TVAR_wbt_pBaseCcms[92]
	0x0F12FF0D, //FF3E//TVAR_wbt_pBaseCcms[93]
	0x0F120193, //0163//TVAR_wbt_pBaseCcms[94]
	0x0F12FF34, //FF5F//TVAR_wbt_pBaseCcms[95]
	0x0F12FFCE, //FFCE//TVAR_wbt_pBaseCcms[96]
	0x0F12FFDF, //FFDF//TVAR_wbt_pBaseCcms[97]
	0x0F12015E, //015E//TVAR_wbt_pBaseCcms[98]
	0x0F120095, //0095//TVAR_wbt_pBaseCcms[99]
	0x0F120096, //0096//TVAR_wbt_pBaseCcms[100]
	0x0F12FF0B, //FF0B//TVAR_wbt_pBaseCcms[101]
	0x0F1200C3, //00C3//TVAR_wbt_pBaseCcms[102]
	0x0F12FF5C, //FF5C//TVAR_wbt_pBaseCcms[103]
	0x0F12013D, //013D//TVAR_wbt_pBaseCcms[104]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[105]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[106]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[107]
	//	param_end	TVAR_wbt_pBasecms


	0x002A07CC,
	0x0F1240D8, //#TVAR_wbt_pOutdoorCcm
	0x0F127000,

	//	param_start	TVAR_wbt_pOutdoorCcm
	0x002A40D8,
	0x0F1201F6, //01F6//01F8//TVAR_wbt_pOutdoorCcm[0]
	0x0F12FF9F, //FF9F//FFAF//TVAR_wbt_pOutdoorCcm[1]
	0x0F12FFE5, //FFE5//FFD3//TVAR_wbt_pOutdoorCcm[2]
	0x0F12FED2, //FED2//FEC4//TVAR_wbt_pOutdoorCcm[3]
	0x0F120193, //0193//0191//TVAR_wbt_pOutdoorCcm[4]
	0x0F12FF23, //FF23//FF33//TVAR_wbt_pOutdoorCcm[5]
	0x0F12FFF7, //FFF7//FFED//TVAR_wbt_pOutdoorCcm[6]
	0x0F12000C, //000C//0017//TVAR_wbt_pOutdoorCcm[7]
	0x0F120211, //0211//0210//TVAR_wbt_pOutdoorCcm[8]
	0x0F1200FF, //00F1//00E3//TVAR_wbt_pOutdoorCcm[9]
	0x0F1200EC, //00FA//0107//TVAR_wbt_pOutdoorCcm[10]
	0x0F12FF2E, //FF2E//FF2F//TVAR_wbt_pOutdoorCcm[11]
	0x0F120220, //0220//0220//TVAR_wbt_pOutdoorCcm[12]
	0x0F12FFE7, //FFE7//FFE7//TVAR_wbt_pOutdoorCcm[13]
	0x0F1201A1, //01A1//01A1//TVAR_wbt_pOutdoorCcm[14]
	0x0F12FEC7, //FEC7//FEC8//TVAR_wbt_pOutdoorCcm[15]
	0x0F12016D, //016D//017D//TVAR_wbt_pOutdoorCcm[16]
	0x0F120153, //0153//0142//TVAR_wbt_pOutdoorCcm[17]
	//	param_end	TVAR_wbt_pOutdoorCcm


	0x002A2A64,
	0x0F120001, //#MVAR_AAIO_bFIT
	0x002A2A68,
	0x0F120001, //#MVAR_AAIO_bAutoCCMandASH
	0x002A2A3C,
	0x0F1201DD, //#Mon_AAIO_PrevFrmData_NormBr

	//===================================================================
	// AFIT
	//===================================================================

	//	param_start	afit_uNoiseIndInDoor
	0x002A085C,
	0x0F12004A, //0049//#afit_uNoiseIndInDoor_0_
	0x0F12004E, //005F//#afit_uNoiseIndInDoor_1_
	0x0F1200CB, //00CB//#afit_uNoiseIndInDoor_2_
	0x0F1201C0, //01E0//#afit_uNoiseIndInDoor_3_
	0x0F120200, //0220//#afit_uNoiseIndInDoor_4_

	0x002A08C0,
	0x0F120007, //0007//700008C0//AFIT16_BRIGHTNESS
	0x0F120000, //0000//700008C2           //AFIT16_CONTRAST
	0x0F120000, //0000//700008C4           //AFIT16_SATURATION
	0x0F120002, //0000//700008C6           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//700008C8           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//700008CA           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//700008CC
	0x0F1203FF, //03FF//700008CE           //AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//700008D0           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//700008D2           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//700008D4           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//700008D6           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//700008D8           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//700008DA           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//700008DC           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//700008DE           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//700008E0           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//700008E2           //AFIT16_demsharpmix1_iTune
	0x0F120010, //0010//700008E4//AFIT16_demsharpmix1_iHystThLow
	0x0F120010, //0010//700008E6//AFIT16_demsharpmix1_iHystThHigh
	0x0F1201F4, //01F4//700008E8//AFIT16_demsharpmix1_iHystCenter
	0x0F12006E, //003C//700008EA           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0008//700008EC           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//700008EE           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//700008F0           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//700008F2           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//700008F4           //AFIT16_Sharpening_iHighSharpClamp_sBi
	0x0F120A24, //0A24//700008F6           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sdd
	0x0F121701, //1701//700008F8           //AFIT8_sddd8a_repl_force [7:0] AFIT8_s
	0x0F120229, //0229//700008FA           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8
	0x0F121403, //1403//700008FC           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sdd
	0x0F120004, //0004//700008FE           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT
	0x0F120300, //0300//70000900           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFI
	0x0F120000, //0000//70000902           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT
	0x0F1202FF, //02FF//70000904           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8
	0x0F1205E8, //09E8//70000906           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8
	0x0F121414, //1414//70000908           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0
	0x0F120301, //0301//7000090A           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFI
	0x0F120007, //0007//7000090C           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F124000, //4000//7000090E
	0x0F127803, //7803//70000910
	0x0F123C50, //3C50//70000912
	0x0F12003C, //003C//70000914
	0x0F121E80, //1E80//70000916           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT
	0x0F121E08, //1E08//70000918           //AFIT8_Demosaicing_iDecisionThresh[7:0
	0x0F12000A, //000A//7000091A           //AFIT8_Demosaicing_iEnhThresh[7:0] AFI
	0x0F120000, //0000//7000091C           //AFIT8_Demosaicing_iGBDenoiseVal[7:0]
	0x0F12120A, //120A//7000091E           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:
	0x0F121400, //0F00//70000920           //AFIT8_Sharpening_iMShThresh[7:0] AFIT
	0x0F120200, //0200//70000922           //AFIT8_Sharpening_iWShThresh[7:0] AFIT
	0x0F12FF00, //FF00//70000924           //AFIT8_Sharpening_iReduceNegative[7:0]
	0x0F120200, //0200//70000926           //AFIT8_demsharpmix1_iRGBMultiplier[7:0
	0x0F121B11, //1B11//70000928           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8
	0x0F120000, //0000//7000092A           //AFIT8_demsharpmix1_iWideMult[7:0] AFI
	0x0F120009, //0009//7000092C           //AFIT8_demsharpmix1_iHystFalloff[7:0]
	0x0F120406, //0406//7000092E           //AFIT8_demsharpmix1_iHystWidth[7:0] AF
	0x0F120605, //0605//70000930           //AFIT8_demsharpmix1_iHystFallHigh[7:0]
	0x0F120307, //0307//70000932
	0x0F120609, //0609//70000934
	0x0F122C07, //2C07//70000936
	0x0F12142C, //142C//70000938
	0x0F120B18, //0718//7000093A//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F12800B, //8007//7000093C//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPowe
	0x0F120880, //0880//7000093E           //AFIT8_RGBGamma2_iLinearity [7:0]  AFI
	0x0F120B50, //0B50//70000940           //AFIT8_ccm_oscar_iSaturation[7:0]   AF
	0x0F120080, //0080//70000942           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_
	0x0F120101, //0101//70000944           //AFIT8_sddd8a_iClustThresh_H [7:0]  AF
	0x0F120707, //0707//70000946           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFI
	0x0F124601, //4601//70000948           //AFIT8_sddd8a_nClustLevel_H [7:0]   AF
	0x0F12A444, //C844//7000094A           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT
	0x0F1250A4, //50C8//7000094C           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AF
	0x0F120500, //0500//7000094E           //AFIT8_Demosaicing_iEdgeDesatThrLow [7
	0x0F120303, //0003//70000950           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0
	0x0F121001, //1C01//70000952           //AFIT8_Demosaicing_iDemSharpenHigh[7:0
	0x0F120710, //0714//70000954           //AFIT8_Demosaicing_iDemShLowLimit [7:0
	0x0F121448, //1464//70000956           //AFIT8_Demosaicing_iDemBlurLow[7:0]
	0x0F125A03, //5A04//70000958           //AFIT8_Demosaicing_iDemBlurRange[7:0]
	0x0F12281E, //3C1E//7000095A           //AFIT8_Sharpening_iHighSharpPower[7:0]
	0x0F12200F, //400F//7000095C           //AFIT8_Sharpening_iHighShDenoise [7:0]
	0x0F120204, //0204//7000095E           //AFIT8_Sharpening_iReduceEdgeSlope [7:
	0x0F121403, //1403//70000960           //AFIT8_demsharpmix1_iNarrFiltReduce [7
	0x0F120114, //0114//70000962           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]
	0x0F120101, //0101//70000964           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]
	0x0F124446, //4446//70000966           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   A
	0x0F12646E, //646E//70000968           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]
	0x0F120028, //0028//7000096A           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]
	0x0F12030A, //030A//7000096C           //AFIT8_Demosaicing_iEdgeDesatThrHigh_B
	0x0F120000, //0000//7000096E           //AFIT8_Demosaicing_iDemSharpenLow_Bin
	0x0F12141E, //141E//70000970           //AFIT8_Demosaicing_iDemSharpThresh_Bin
	0x0F12FF07, //FF07//70000972           //AFIT8_Demosaicing_iDespeckleForDemsha
	0x0F120432, //0432//70000974           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7
	0x0F120000, //0000//70000976           //AFIT8_Sharpening_iLowSharpPower_Bin [
	0x0F120F0F, //0F0F//70000978           //AFIT8_Sharpening_iLowShDenoise_Bin [7
	0x0F120440, //0440//7000097A           //AFIT8_Sharpening_iReduceEdgeMinMult_B
	0x0F120302, //0302//7000097C           //AFIT8_demsharpmix1_iWideFiltReduce_Bi
	0x0F121414, //1414//7000097E           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]
	0x0F120101, //0101//70000980           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]
	0x0F124601, //4601//70000982           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]
	0x0F126E44, //6E44//70000984           //AFIT8_sddd8a_DispTH_High_sBin [7:0]
	0x0F122864, //2864//70000986           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]
	0x0F120A00, //0A00//70000988           //AFIT8_Demosaicing_iEdgeDesatThrLow_sB
	0x0F120003, //0003//7000098A           //AFIT8_Demosaicing_iEdgeDesatLimit_sBi
	0x0F121E00, //1E00//7000098C           //AFIT8_Demosaicing_iDemSharpenHigh_sBi
	0x0F120714, //0714//7000098E           //AFIT8_Demosaicing_iDemShLowLimit_sBin
	0x0F1232FF, //32FF//70000990           //AFIT8_Demosaicing_iDemBlurLow_sBin [7
	0x0F120004, //0004//70000992           //AFIT8_Demosaicing_iDemBlurRange_sBin
	0x0F120F00, //0F00//70000994           //AFIT8_Sharpening_iHighSharpPower_sBin
	0x0F12400F, //400F//70000996           //AFIT8_Sharpening_iHighShDenoise_sBin
	0x0F120204, //0204//70000998           //AFIT8_Sharpening_iReduceEdgeSlope_sBi
	0x0F120003, //0003//7000099A           //AFIT8_demsharpmix1_iNarrFiltReduce_sB
	0x0F120001, //0001//7000099C
	0x0F120000, //0000//7000099E//AFIT16_BRIGHTNESS
	0x0F120000, //0000//700009A0           //AFIT16_CONTRAST
	0x0F120000, //0000//700009A2           //AFIT16_SATURATION
	0x0F120002, //0000//700009A4           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//700009A6           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//700009A8           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//700009AA
	0x0F1203FF, //03FF//700009AC           //AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//700009AE           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//700009B0           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//700009B2           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//700009B4           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//700009B6           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//700009B8           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//700009BA           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//700009BC           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//700009BE           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//700009C0           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//700009C2//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//700009C4//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//700009C6//AFIT16_demsharpmix1_iHystCenter
	0x0F12006E, //006E//700009C8           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//700009CA           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//700009CC           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//700009CE           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//700009D0           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//700009D2           //AFIT16_Sharpening_iHighSharpClamp_sBi
	0x0F120A24, //0A24//700009D4           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sdd
	0x0F121701, //1701//700009D6           //AFIT8_sddd8a_repl_force [7:0] AFIT8_s
	0x0F120229, //0229//700009D8           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8
	0x0F121403, //1403//700009DA           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sdd
	0x0F120004, //0004//700009DC           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT
	0x0F120300, //0300//700009DE           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFI
	0x0F120000, //0000//700009E0           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT
	0x0F1202FF, //02FF//700009E2           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8
	0x0F1205E8, //05E8//700009E4           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8
	0x0F121414, //1414//700009E6           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0
	0x0F120301, //0301//700009E8           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFI
	0x0F120007, //0007//700009EA           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F122000, //2000//700009EC
	0x0F125003, //5003//700009EE
	0x0F123228, //3228//700009F0
	0x0F120032, //0032//700009F2
	0x0F121E80, //1E80//700009F4           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT
	0x0F121E08, //1E08//700009F6           //AFIT8_Demosaicing_iDecisionThresh[7:0
	0x0F12000A, //000A//700009F8           //AFIT8_Demosaicing_iEnhThresh[7:0] AFI
	0x0F120000, //0000//700009FA           //AFIT8_Demosaicing_iGBDenoiseVal[7:0]
	0x0F12120A, //120A//700009FC           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:
	0x0F121400, //1400//700009FE           //AFIT8_Sharpening_iMShThresh[7:0] AFIT
	0x0F120200, //0200//70000A00           //AFIT8_Sharpening_iWShThresh[7:0] AFIT
	0x0F12FF00, //FF00//70000A02           //AFIT8_Sharpening_iReduceNegative[7:0]
	0x0F120200, //0200//70000A04           //AFIT8_demsharpmix1_iRGBMultiplier[7:0
	0x0F121B11, //1B11//70000A06           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8
	0x0F120000, //0000//70000A08           //AFIT8_demsharpmix1_iWideMult[7:0] AFI
	0x0F120009, //0009//70000A0A           //AFIT8_demsharpmix1_iHystFalloff[7:0]
	0x0F120406, //0406//70000A0C           //AFIT8_demsharpmix1_iHystWidth[7:0] AF
	0x0F120605, //0605//70000A0E           //AFIT8_demsharpmix1_iHystFallHigh[7:0]
	0x0F120307, //0307//70000A10
	0x0F120609, //0609//70000A12
	0x0F122C07, //2C07//70000A14
	0x0F12142C, //142C//70000A16
	0x0F120518, //0518//70000A18//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000A1A//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPowe
	0x0F120580, //0580//70000A1C           //AFIT8_RGBGamma2_iLinearity [7:0]  AFI
	0x0F120080, //0080//70000A1E           //AFIT8_ccm_oscar_iSaturation[7:0]   AF
	0x0F120080, //0080//70000A20           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_
	0x0F120101, //0101//70000A22           //AFIT8_sddd8a_iClustThresh_H [7:0]  AF
	0x0F120707, //0707//70000A24           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFI
	0x0F124B01, //4B01//70000A26           //AFIT8_sddd8a_nClustLevel_H [7:0]   AF
	0x0F12494B, //444B 494B//70000A28           //AFIT8_sddd8a_DispTH_High [7:0]
	0x0F125044, //503C 5044//70000A2A           //AFIT8_sddd8a_iDenThreshHigh[7:0]
	0x0F120500, //0500//70000A2C           //AFIT8_Demosaicing_iEdgeDesatThrLow [7
	0x0F120603, //0503//70000A2E           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0
	0x0F120D03, //0D02//70000A30           //AFIT8_Demosaicing_iDemSharpenHigh[7:0
	0x0F12071E, //071E//70000A32           //AFIT8_Demosaicing_iDemShLowLimit [7:0
	0x0F121432, //1432//70000A34           //AFIT8_Demosaicing_iDemBlurLow[7:0]
	0x0F125A01, //5A01//70000A36           //AFIT8_Demosaicing_iDemBlurRange[7:0]
	0x0F12281E, //281E//70000A38           //AFIT8_Sharpening_iHighSharpPower[7:0]
	0x0F12200F, //200F//70000A3A           //AFIT8_Sharpening_iHighShDenoise [7:0]
	0x0F120204, //0204//70000A3C           //AFIT8_Sharpening_iReduceEdgeSlope [7:
	0x0F121E03, //1E03//70000A3E           //AFIT8_demsharpmix1_iNarrFiltReduce [7
	0x0F12011E, //011E//70000A40           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]
	0x0F120101, //0101//70000A42           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]
	0x0F123A3C, //3A3C//70000A44           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   A
	0x0F12585A, //585A//70000A46           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]
	0x0F120028, //0028//70000A48           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]
	0x0F12030A, //030A//70000A4A           //AFIT8_Demosaicing_iEdgeDesatThrHigh_B
	0x0F120000, //0000//70000A4C           //AFIT8_Demosaicing_iDemSharpenLow_Bin
	0x0F12141E, //141E//70000A4E           //AFIT8_Demosaicing_iDemSharpThresh_Bin
	0x0F12FF07, //FF07//70000A50           //AFIT8_Demosaicing_iDespeckleForDemsha
	0x0F120432, //0432//70000A52           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7
	0x0F120000, //0000//70000A54           //AFIT8_Sharpening_iLowSharpPower_Bin [
	0x0F120F0F, //0F0F//70000A56           //AFIT8_Sharpening_iLowShDenoise_Bin [7
	0x0F120440, //0440//70000A58           //AFIT8_Sharpening_iReduceEdgeMinMult_B
	0x0F120302, //0302//70000A5A           //AFIT8_demsharpmix1_iWideFiltReduce_Bi
	0x0F121E1E, //1E1E//70000A5C           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]
	0x0F120101, //0101//70000A5E           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]
	0x0F123C01, //3C01//70000A60           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]
	0x0F125A3A, //5A3A//70000A62           //AFIT8_sddd8a_DispTH_High_sBin [7:0]
	0x0F122858, //2858//70000A64           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]
	0x0F120A00, //0A00//70000A66           //AFIT8_Demosaicing_iEdgeDesatThrLow_sB
	0x0F120003, //0003//70000A68           //AFIT8_Demosaicing_iEdgeDesatLimit_sBi
	0x0F121E00, //1E00//70000A6A           //AFIT8_Demosaicing_iDemSharpenHigh_sBi
	0x0F120714, //0714//70000A6C           //AFIT8_Demosaicing_iDemShLowLimit_sBin
	0x0F1232FF, //32FF//70000A6E           //AFIT8_Demosaicing_iDemBlurLow_sBin [7
	0x0F120004, //0004//70000A70           //AFIT8_Demosaicing_iDemBlurRange_sBin
	0x0F120F00, //0F00//70000A72           //AFIT8_Sharpening_iHighSharpPower_sBin
	0x0F12400F, //400F//70000A74           //AFIT8_Sharpening_iHighShDenoise_sBin
	0x0F120204, //0204//70000A76           //AFIT8_Sharpening_iReduceEdgeSlope_sBi
	0x0F120003, //0003//70000A78           //AFIT8_demsharpmix1_iNarrFiltReduce_sB
	0x0F120001, //0001//70000A7A
	0x0F120000, //0000//70000A7C//AFIT16_BRIGHTNESS
	0x0F120000, //0000//70000A7E           //AFIT16_CONTRAST
	0x0F120000, //0000//70000A80           //AFIT16_SATURATION
	0x0F120000, //0000//70000A82           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//70000A84           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//70000A86           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//70000A88
	0x0F1203FF, //03FF//70000A8A           //AFIT16_Demosaicing_iSatVal
	0x0F12009E, //009E//70000A8C           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//70000A8E           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//70000A90           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//70000A92           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//70000A94           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//70000A96           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//70000A98           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//70000A9A           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//70000A9C           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//70000A9E           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//70000AA0//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//70000AA2//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//70000AA4//AFIT16_demsharpmix1_iHystCenter
	0x0F12008C, //008C//70000AA6           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//70000AA8           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//70000AAA           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//70000AAC           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//70000AAE           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//70000AB0           //AFIT16_Sharpening_iHighSharpClamp_sBi
	0x0F120A24, //0A24//70000AB2           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sdd
	0x0F121701, //1701//70000AB4           //AFIT8_sddd8a_repl_force [7:0] AFIT8_s
	0x0F120229, //0229//70000AB6           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8
	0x0F121403, //1403//70000AB8           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sdd
	0x0F120004, //0004//70000ABA           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT
	0x0F120300, //0300//70000ABC           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFI
	0x0F120000, //0000//70000ABE           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT
	0x0F1202FF, //02FF//70000AC0           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8
	0x0F1205DE, //05DE//70000AC2           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8
	0x0F121414, //1414//70000AC4           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0
	0x0F120301, //0301//70000AC6           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFI
	0x0F120007, //0007//70000AC8           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//70000ACA
	0x0F122803, //2803//70000ACC
	0x0F12261E, //261E//70000ACE
	0x0F120026, //0026//70000AD0
	0x0F121E80, //1E80//70000AD2           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT
	0x0F121E08, //1E08//70000AD4           //AFIT8_Demosaicing_iDecisionThresh[7:0
	0x0F12010A, //010A//70000AD6           //AFIT8_Demosaicing_iEnhThresh[7:0] AFI
	0x0F120001, //0001//70000AD8           //AFIT8_Demosaicing_iGBDenoiseVal[7:0]
	0x0F123C0A, //3C0A//70000ADA           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:
	0x0F122300, //2300//70000ADC           //AFIT8_Sharpening_iMShThresh[7:0] AFIT
	0x0F120200, //0200//70000ADE           //AFIT8_Sharpening_iWShThresh[7:0] AFIT
	0x0F12FF00, //FF00//70000AE0           //AFIT8_Sharpening_iReduceNegative[7:0]
	0x0F120200, //0200//70000AE2           //AFIT8_demsharpmix1_iRGBMultiplier[7:0
	0x0F121B11, //1B11//70000AE4           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8
	0x0F120000, //0000//70000AE6           //AFIT8_demsharpmix1_iWideMult[7:0] AFI
	0x0F120009, //0009//70000AE8           //AFIT8_demsharpmix1_iHystFalloff[7:0]
	0x0F120406, //0406//70000AEA           //AFIT8_demsharpmix1_iHystWidth[7:0] AF
	0x0F120605, //0605//70000AEC           //AFIT8_demsharpmix1_iHystFallHigh[7:0]
	0x0F120307, //0307//70000AEE
	0x0F120609, //0609//70000AF0
	0x0F121C07, //1C07//70000AF2
	0x0F121014, //1014//70000AF4
	0x0F120510, //0510//70000AF6//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000AF8//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPowe
	0x0F120080, //0080//70000AFA           //AFIT8_RGBGamma2_iLinearity [7:0]  AFI
	0x0F120080, //0080//70000AFC           //AFIT8_ccm_oscar_iSaturation[7:0]   AF
	0x0F120080, //0080//70000AFE           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_
	0x0F120101, //0101//70000B00           //AFIT8_sddd8a_iClustThresh_H [7:0]  AF
	0x0F120707, //0707//70000B02           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFI
	0x0F124B01, //4B01//70000B04           //AFIT8_sddd8a_nClustLevel_H [7:0]   AF
	0x0F122A4B, //2A4B//70000B06           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT
	0x0F125020, //5020//70000B08           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AF
	0x0F120500, //0500//70000B0A           //AFIT8_Demosaicing_iEdgeDesatThrLow [7
	0x0F121C03, //1C03//70000B0C           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0
	0x0F120D0C, //0D0C//70000B0E           //AFIT8_Demosaicing_iDemSharpenHigh[7:0
	0x0F120823, //0823//70000B10           //AFIT8_Demosaicing_iDemShLowLimit [7:0
	0x0F121428, //1428//70000B12           //AFIT8_Demosaicing_iDemBlurLow[7:0]
	0x0F126401, //6401//70000B14           //AFIT8_Demosaicing_iDemBlurRange[7:0]
	0x0F12282D, //282D//70000B16           //AFIT8_Sharpening_iHighSharpPower[7:0]
	0x0F122012, //2012//70000B18           //AFIT8_Sharpening_iHighShDenoise [7:0]
	0x0F120204, //0204//70000B1A           //AFIT8_Sharpening_iReduceEdgeSlope [7:
	0x0F122803, //2803//70000B1C           //AFIT8_demsharpmix1_iNarrFiltReduce [7
	0x0F120128, //0128//70000B1E           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]
	0x0F120101, //0101//70000B20           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]
	0x0F122224, //2224//70000B22           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   A
	0x0F123236, //3236//70000B24           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]
	0x0F120028, //0028//70000B26           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]
	0x0F12030A, //030A//70000B28           //AFIT8_Demosaicing_iEdgeDesatThrHigh_B
	0x0F120410, //0410//70000B2A           //AFIT8_Demosaicing_iDemSharpenLow_Bin
	0x0F12141E, //141E//70000B2C           //AFIT8_Demosaicing_iDemSharpThresh_Bin
	0x0F12FF07, //FF07//70000B2E           //AFIT8_Demosaicing_iDespeckleForDemsha
	0x0F120432, //0432//70000B30           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7
	0x0F124050, //4050//70000B32           //AFIT8_Sharpening_iLowSharpPower_Bin [
	0x0F120F0F, //0F0F//70000B34           //AFIT8_Sharpening_iLowShDenoise_Bin [7
	0x0F120440, //0440//70000B36           //AFIT8_Sharpening_iReduceEdgeMinMult_B
	0x0F120302, //0302//70000B38           //AFIT8_demsharpmix1_iWideFiltReduce_Bi
	0x0F122828, //2828//70000B3A           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]
	0x0F120101, //0101//70000B3C           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]
	0x0F122401, //2401//70000B3E           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]
	0x0F123622, //3622//70000B40           //AFIT8_sddd8a_DispTH_High_sBin [7:0]
	0x0F122832, //2832//70000B42           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]
	0x0F120A00, //0A00//70000B44           //AFIT8_Demosaicing_iEdgeDesatThrLow_sB
	0x0F121003, //1003//70000B46           //AFIT8_Demosaicing_iEdgeDesatLimit_sBi
	0x0F121E04, //1E04//70000B48           //AFIT8_Demosaicing_iDemSharpenHigh_sBi
	0x0F120714, //0714//70000B4A           //AFIT8_Demosaicing_iDemShLowLimit_sBin
	0x0F1232FF, //32FF//70000B4C           //AFIT8_Demosaicing_iDemBlurLow_sBin [7
	0x0F125004, //5004//70000B4E           //AFIT8_Demosaicing_iDemBlurRange_sBin
	0x0F120F40, //0F40//70000B50           //AFIT8_Sharpening_iHighSharpPower_sBin
	0x0F12400F, //400F//70000B52           //AFIT8_Sharpening_iHighShDenoise_sBin
	0x0F120204, //0204//70000B54           //AFIT8_Sharpening_iReduceEdgeSlope_sBi
	0x0F120003, //0003//70000B56           //AFIT8_demsharpmix1_iNarrFiltReduce_sB
	0x0F120001, //0001//70000B58
	0x0F120000, //0000//70000B5A//AFIT16_BRIGHTNESS
	0x0F120000, //0000//70000B5C           //AFIT16_CONTRAST
	0x0F120000, //0000//70000B5E           //AFIT16_SATURATION
	0x0F120000, //0000//70000B60           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//70000B62           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//70000B64           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//70000B66
	0x0F1203FF, //03FF//70000B68           //AFIT16_Demosaicing_iSatVal
	0x0F12009E, //009E//70000B6A           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//70000B6C           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//70000B6E           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//70000B70           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//70000B72           //AFIT16_demsharpmix1_iHighThreshold
	0x0F1200C8, //00C8//70000B74           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//70000B76           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//70000B78           //AFIT16_demsharpmix1_iLowSat
	0x0F120050, //0050//70000B7A           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//70000B7C           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//70000B7E//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//70000B80//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//70000B82//AFIT16_demsharpmix1_iHystCenter
	0x0F12008C, //008C//70000B84           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//70000B86           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12002D, //002D//70000B88           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F120019, //0019//70000B8A           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12002D, //002D//70000B8C           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F120019, //0019//70000B8E           //AFIT16_Sharpening_iHighSharpClamp_sBi
	0x0F120A24, //0A24//70000B90           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sdd
	0x0F121701, //1701//70000B92           //AFIT8_sddd8a_repl_force [7:0] AFIT8_s
	0x0F120229, //0229//70000B94           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8
	0x0F121403, //1403//70000B96           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sdd
	0x0F120004, //0004//70000B98           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT
	0x0F120300, //0300//70000B9A           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFI
	0x0F120000, //0000//70000B9C           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT
	0x0F1202FF, //02FF//70000B9E           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8
	0x0F1205DE, //05DE//70000BA0           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8
	0x0F121414, //1414//70000BA2           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0
	0x0F120301, //0301//70000BA4           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFI
	0x0F120007, //0007//70000BA6           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//70000BA8
	0x0F122303, //2303//70000BAA
	0x0F12231A, //231A//70000BAC
	0x0F120023, //0023//70000BAE
	0x0F121E80, //1E80//70000BB0           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT
	0x0F121E08, //1E08//70000BB2           //AFIT8_Demosaicing_iDecisionThresh[7:0
	0x0F12010A, //010A//70000BB4           //AFIT8_Demosaicing_iEnhThresh[7:0] AFI
	0x0F120001, //0001//70000BB6           //AFIT8_Demosaicing_iGBDenoiseVal[7:0]
	0x0F123C0A, //3C0A//70000BB8           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:
	0x0F122300, //2300//70000BBA           //AFIT8_Sharpening_iMShThresh[7:0] AFIT
	0x0F120200, //0200//70000BBC           //AFIT8_Sharpening_iWShThresh[7:0] AFIT
	0x0F12FF00, //FF00//70000BBE           //AFIT8_Sharpening_iReduceNegative[7:0]
	0x0F120200, //0200//70000BC0           //AFIT8_demsharpmix1_iRGBMultiplier[7:0
	0x0F121E10, //1E10//70000BC2           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8
	0x0F120000, //0000//70000BC4           //AFIT8_demsharpmix1_iWideMult[7:0] AFI
	0x0F120009, //0009//70000BC6           //AFIT8_demsharpmix1_iHystFalloff[7:0]
	0x0F120406, //0406//70000BC8           //AFIT8_demsharpmix1_iHystWidth[7:0] AF
	0x0F120705, //0705//70000BCA           //AFIT8_demsharpmix1_iHystFallHigh[7:0]
	0x0F120306, //0306//70000BCC
	0x0F120509, //0509//70000BCE
	0x0F122806, //2806//70000BD0
	0x0F121428, //1428//70000BD2
	0x0F120518, //0518//70000BD4//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000BD6//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPowe
	0x0F120080, //0080//70000BD8           //AFIT8_RGBGamma2_iLinearity [7:0]  AFI
	0x0F120080, //0080//70000BDA           //AFIT8_ccm_oscar_iSaturation[7:0]   AF
	0x0F120080, //0080//70000BDC           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_
	0x0F120101, //0101//70000BDE           //AFIT8_sddd8a_iClustThresh_H [7:0]  AF
	0x0F120707, //0707//70000BE0           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFI
	0x0F124B01, //4B01//70000BE2           //AFIT8_sddd8a_nClustLevel_H [7:0]   AF
	0x0F122A4B, //2A4B//70000BE4           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT
	0x0F125020, //5020//70000BE6           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AF
	0x0F120500, //0500//70000BE8           //AFIT8_Demosaicing_iEdgeDesatThrLow [7
	0x0F121C03, //1C03//70000BEA           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0
	0x0F120D0C, //0D0C//70000BEC           //AFIT8_Demosaicing_iDemSharpenHigh[7:0
	0x0F120823, //0823//70000BEE           //AFIT8_Demosaicing_iDemShLowLimit [7:0
	0x0F121428, //1428//70000BF0           //AFIT8_Demosaicing_iDemBlurLow[7:0]
	0x0F126401, //6401//70000BF2           //AFIT8_Demosaicing_iDemBlurRange[7:0]
	0x0F12282D, //282D//70000BF4           //AFIT8_Sharpening_iHighSharpPower[7:0]
	0x0F122012, //2012//70000BF6           //AFIT8_Sharpening_iHighShDenoise [7:0]
	0x0F120204, //0204//70000BF8           //AFIT8_Sharpening_iReduceEdgeSlope [7:
	0x0F123C03, //3C03//70000BFA           //AFIT8_demsharpmix1_iNarrFiltReduce [7
	0x0F12013C, //013C//70000BFC           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]
	0x0F120101, //0101//70000BFE           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]
	0x0F121C1E, //1C1E//70000C00           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   A
	0x0F121E22, //1E22//70000C02           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]
	0x0F120028, //0028//70000C04           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]
	0x0F12030A, //030A//70000C06           //AFIT8_Demosaicing_iEdgeDesatThrHigh_B
	0x0F120214, //0214//70000C08           //AFIT8_Demosaicing_iDemSharpenLow_Bin
	0x0F120E14, //0E14//70000C0A           //AFIT8_Demosaicing_iDemSharpThresh_Bin
	0x0F12FF06, //FF06//70000C0C           //AFIT8_Demosaicing_iDespeckleForDemsha
	0x0F120432, //0432//70000C0E           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7
	0x0F124052, //4052//70000C10           //AFIT8_Sharpening_iLowSharpPower_Bin [
	0x0F12150C, //150C//70000C12           //AFIT8_Sharpening_iLowShDenoise_Bin [7
	0x0F120440, //0440//70000C14           //AFIT8_Sharpening_iReduceEdgeMinMult_B
	0x0F120302, //0302//70000C16           //AFIT8_demsharpmix1_iWideFiltReduce_Bi
	0x0F123C3C, //3C3C//70000C18           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]
	0x0F120101, //0101//70000C1A           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]
	0x0F121E01, //1E01//70000C1C           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]
	0x0F12221C, //221C//70000C1E           //AFIT8_sddd8a_DispTH_High_sBin [7:0]
	0x0F12281E, //281E//70000C20           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]
	0x0F120A00, //0A00//70000C22           //AFIT8_Demosaicing_iEdgeDesatThrLow_sB
	0x0F121403, //1403//70000C24           //AFIT8_Demosaicing_iEdgeDesatLimit_sBi
	0x0F121402, //1402//70000C26           //AFIT8_Demosaicing_iDemSharpenHigh_sBi
	0x0F12060E, //060E//70000C28           //AFIT8_Demosaicing_iDemShLowLimit_sBin
	0x0F1232FF, //32FF//70000C2A           //AFIT8_Demosaicing_iDemBlurLow_sBin [7
	0x0F125204, //5204//70000C2C           //AFIT8_Demosaicing_iDemBlurRange_sBin
	0x0F120C40, //0C40//70000C2E           //AFIT8_Sharpening_iHighSharpPower_sBin
	0x0F124015, //4015//70000C30           //AFIT8_Sharpening_iHighShDenoise_sBin
	0x0F120204, //0204//70000C32           //AFIT8_Sharpening_iReduceEdgeSlope_sBi
	0x0F120003, //0003//70000C34           //AFIT8_demsharpmix1_iNarrFiltReduce_sB
	0x0F120001, //0001//70000C36
	0x0F120003, //0000//0000//70000C38//AFIT16_BRIGHTNESS
	0x0F120000, //0000//0000//70000C3A//AFIT16_CONTRAST
	0x0F120000, //0000//0000//70000C3C//AFIT16_SATURATION
	0x0F120000, //0000//0000//70000C3E//AFIT16_SHARP_BLUR
	0x0F120000, //0000//0000//70000C40//AFIT16_GLAMOUR
	0x0F1200C1, //00C1//00C1//70000C42//AFIT16_sddd8a_edge_high
	0x0F120000, //0000//0000//70000C44
	0x0F1203FF, //03FF//03FF//70000C46//AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//0008//70000C48//AFIT16_Sharpening_iReduceEdgeThresh
	0x0F120251, //0251//017C//70000C4A//AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//03FF//70000C4C//AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//000C//70000C4E//AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//0010//70000C50//AFIT16_demsharpmix1_iHighThreshold
	0x0F120032, //0032//0032//70000C52//AFIT16_demsharpmix1_iLowBright
	0x0F12028A, //028A//028A//70000C54//AFIT16_demsharpmix1_iHighBright
	0x0F120032, //0032//0032//70000C56//AFIT16_demsharpmix1_iLowSat
	0x0F1201F4, //01F4//01F4//70000C58//AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//0070//70000C5A//AFIT16_demsharpmix1_iTune
	0x0F120002, //0002//0002//70000C5C//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//0000//70000C5E//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//0320//70000C60//AFIT16_demsharpmix1_iHystCenter
	0x0F120044, //0044//0070//70000C62//AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//0014//70000C64//AFIT16_Sharpening_iHighSharpClamp
	0x0F120046, //0046//0046//70000C66//AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F120019, //0019//0019//70000C68//AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F120046, //0046//0046//70000C6A//AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F120019, //0019//0019//70000C6C//AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//0A24//70000C6E//AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_r
	0x0F121701, //1701//1701//70000C70//AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a
	0x0F120229, //0229//0229//70000C72//AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat
	0x0F120503, //0503//0503//70000C74//AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_i
	0x0F12080F, //080F//0101//70000C76//AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sdd
	0x0F120808, //0808//0101//70000C78//AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sd
	0x0F120000, //0000//0000//70000C7A//AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sdd
	0x0F1200FF, //00FF//02FF//70000C7C//AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRa
	0x0F12012D, //012D//0396//70000C7E//AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd
	0x0F121414, //1414//1414//70000C80//AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFI
	0x0F120301, //0301//0301//70000C82//AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sd
	0x0F120007, //0007//0007//70000C84//AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//1000//70000C86
	0x0F122003, //2003//2003//70000C88
	0x0F121020, //1020//1020//70000C8A
	0x0F120010, //0010//0010//70000C8C
	0x0F121EFF, //1EFF//1E80//70000C8E//AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Dem
	0x0F121E06, //1E06//1E06//70000C90//AFIT8_Demosaicing_iDecisionThresh[7:0] AFI
	0x0F12060A, //060A//030C//70000C92//AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_De
	0x0F120306, //0306//0103//70000C94//AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8
	0x0F128B0A, //8B0A//5A0A//70000C96//AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AF
	0x0F122837, //2837//2D00//70000C98//AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sha
	0x0F120110, //0110//0100//70000C9A//AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sha
	0x0F12FF00, //FF00//FF00//70000C9C//AFIT8_Sharpening_iReduceNegative[7:0] AFIT
	0x0F120200, //0200//0200//70000C9E//AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFI
	0x0F121E10, //1E10//1E10//70000CA0//AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_dems
	0x0F120000, //0000//0000//70000CA2//AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_de
	0x0F120009, //0009//0009//70000CA4//AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8
	0x0F120406, //0406//0406//70000CA6//AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_d
	0x0F120705, //0705//0705//70000CA8//AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT
	0x0F120305, //0305//0305//70000CAA
	0x0F120609, //0609//0609//70000CAC
	0x0F122C07, //2C07//2C07//70000CAE
	0x0F12142C, //142C//142C//70000CB0
	0x0F120B18, //0B18//0B18//70000CB2//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F12800B, //800B//800B//70000CB4//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadi
	0x0F120080, //0080//0080//70000CB6//AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RG
	0x0F120080, //0080//0080//70000CB8//AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_R
	0x0F120080, //0080//0080//70000CBA//AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2Y
	0x0F125050, //5050//0101//70000CBC//AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_s
	0x0F120101, //0101//0A0A//70000CBE//AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sd
	0x0F123201, //3201//3201//70000CC0//AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_s
	0x0F121832, //1832//1428//70000CC2//AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sdd
	0x0F12210C, //210C//100C//70000CC4//AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_D
	0x0F120A00, //0A00//0500//70000CC6//AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]
	0x0F121E04, //1E04//1E02//70000CC8//AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AF
	0x0F120A08, //0A08//040C//70000CCA//AFIT8_Demosaicing_iDemSharpenHigh[7:0]   A
	0x0F12070C, //070C//0828//70000CCC//AFIT8_Demosaicing_iDemShLowLimit [7:0]   A
	0x0F123264, //3264//5064//70000CCE//AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8
	0x0F125A02, //5A02//4605//70000CD0//AFIT8_Demosaicing_iDemBlurRange[7:0]   AFI
	0x0F121040, //1040//1E68//70000CD2//AFIT8_Sharpening_iHighSharpPower[7:0]   AF
	0x0F124012, //4012//201E//70000CD4//AFIT8_Sharpening_iHighShDenoise [7:0]   AF
	0x0F120604, //0604//0604//70000CD6//AFIT8_Sharpening_iReduceEdgeSlope [7:0]  A
	0x0F124606, //4606//4606//70000CD8//AFIT8_demsharpmix1_iNarrFiltReduce [7:0]
	0x0F120146, //0146//0146//70000CDA//AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AF
	0x0F120101, //0101//0101//70000CDC//AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT
	0x0F121C18, //1C18//1C18//70000CDE//AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_
	0x0F121819, //1819//1819//70000CE0//AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFI
	0x0F120028, //0028//0028//70000CE2//AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AF
	0x0F12030A, //030A//030A//70000CE4//AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7
	0x0F120514, //0514//0514//70000CE6//AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]
	0x0F120C14, //0C14//0C14//70000CE8//AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0
	0x0F12FF05, //FF05//FF05//70000CEA//AFIT8_Demosaicing_iDespeckleForDemsharp_Bi
	0x0F120432, //0432//0432//70000CEC//AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]
	0x0F124052, //4052//4052//70000CEE//AFIT8_Sharpening_iLowSharpPower_Bin [7:0]
	0x0F121514, //1514//1514//70000CF0//AFIT8_Sharpening_iLowShDenoise_Bin [7:0]
	0x0F120440, //0440//0440//70000CF2//AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7
	0x0F120302, //0302//0302//70000CF4//AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:
	0x0F124646, //4646//4646//70000CF6//AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AF
	0x0F120101, //0101//0101//70000CF8//AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFI
	0x0F121801, //1801//1801//70000CFA//AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AF
	0x0F12191C, //191C//191C//70000CFC//AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT
	0x0F122818, //2818//2818//70000CFE//AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AF
	0x0F120A00, //0A00//0A00//70000D00//AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7
	0x0F121403, //1403//1403//70000D02//AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:
	0x0F121405, //1405//1405//70000D04//AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:
	0x0F12050C, //050C//050C//70000D06//AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0
	0x0F1232FF, //32FF//32FF//70000D08//AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]
	0x0F125204, //5204//5204//70000D0A//AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]
	0x0F121440, //1440//1440//70000D0C//AFIT8_Sharpening_iHighSharpPower_sBin [7:0
	0x0F124015, //4015//4015//70000D0E//AFIT8_Sharpening_iHighShDenoise_sBin [7:0]
	0x0F120204, //0204//0204//70000D10//AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:
	0x0F120003, //0003//0003//70000D12//AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7
	0x0F120001, //0001//0001//70000D14

	0x0F12BA7A, //70000D16
	0x0F124FDE, //70000D18
	0x0F12137F, //70000D1A
	0x0F123BDE, //70000D1C
	0x0F122102, //70000D1E
	0x0F1200B5, //70000D20

	//===================================================================
	// Brightness setting
	//===================================================================
	0x002A1300,
	0x0F12019D,

	0x002A1306,
	0x0F120280,
};
#else
/* Init regs for Jpeg capture */
static const u32 s5k5ccgx_init_reg[] =
{
	//****************************************/
	0xFCFCD000,
	//****************************************/
	//===================================================================
	// History
	//===================================================================
	//20100717 : 1st release
	//20100806 : 2nd release for EVT0.1
	//20101028 : 3rd release for EVT1
	//WRITE #awbb_otp_disable  0000          //awb otp use
	//==========================================================================================
	//-->The below registers are for FACTORY ONLY. if you change them without prior notification
	//   YOU are RESPONSIBLE for the FAILURE that will happen in the future.
	//==========================================================================================
	//===================================================================
	// Reset & Trap and Patch
	//===================================================================

	// Start of Trap and Patch
	//  2010-08-11 13:53:35
	0x00100001,
	0x10300000,
	0x00140001,

	0xFFFF000A,     //p10
	// Start of Patch data
	0x00287000,
	/*++ Add ESD */
	0x002A0150,
	0x0F12AAAA,
	/*-- Add ESD */
	0x002A352C,
	0x0F12B570,    // 7000352C
	0x0F124A24,    // 7000352E
	0x0F124924,    // 70003530
	0x0F124825,    // 70003532
	0x0F124B25,    // 70003534
	0x0F122500,    // 70003536
	0x0F12801D,    // 70003538
	0x0F12C004,    // 7000353A
	0x0F126001,    // 7000353C
	0x0F124924,    // 7000353E
	0x0F124824,    // 70003540
	0x0F12F000,    // 70003542
	0x0F12FBBD,    // 70003544
	0x0F124924,    // 70003546
	0x0F124824,    // 70003548
	0x0F12F000,    // 7000354A
	0x0F12FBB9,    // 7000354C
	0x0F124824,    // 7000354E
	0x0F124E24,    // 70003550
	0x0F126430,    // 70003552
	0x0F124924,    // 70003554
	0x0F124825,    // 70003556
	0x0F12F000,    // 70003558
	0x0F12FBB2,    // 7000355A
	0x0F124924,    // 7000355C
	0x0F120030,    // 7000355E
	0x0F123080,    // 70003560
	0x0F126141,    // 70003562
	0x0F124C23,    // 70003564
	0x0F128365,    // 70003566
	0x0F124923,    // 70003568
	0x0F124824,    // 7000356A
	0x0F12F000,    // 7000356C
	0x0F12FBA8,    // 7000356E
	0x0F124923,    // 70003570
	0x0F124824,    // 70003572
	0x0F12F000,    // 70003574
	0x0F12FBA4,    // 70003576
	0x0F124923,    // 70003578
	0x0F124824,    // 7000357A
	0x0F12F000,    // 7000357C
	0x0F12FBA0,    // 7000357E
	0x0F124923,    // 70003580
	0x0F124824,    // 70003582
	0x0F12F000,    // 70003584
	0x0F12FB9C,    // 70003586
	0x0F128125,    // 70003588
	0x0F124923,    // 7000358A
	0x0F124823,    // 7000358C
	0x0F12F000,    // 7000358E
	0x0F12FB97,    // 70003590
	0x0F124923,    // 70003592
	0x0F124823,    // 70003594
	0x0F12F000,    // 70003596
	0x0F12FB93,    // 70003598
	0x0F1283A5,    // 7000359A
	0x0F124922,    // 7000359C
	0x0F124823,    // 7000359E
	0x0F12F000,    // 700035A0
	0x0F12FB8E,    // 700035A2
	0x0F122101,    // 700035A4
	0x0F120349,    // 700035A6
	0x0F120020,    // 700035A8
	0x0F123020,    // 700035AA
	0x0F128041,    // 700035AC
	0x0F122185,    // 700035AE
	0x0F128081,    // 700035B0
	0x0F12491F,    // 700035B2
	0x0F1280C1,    // 700035B4
	0x0F12481F,    // 700035B6
	0x0F126730,    // 700035B8
	0x0F12BC70,    // 700035BA
	0x0F12BC08,    // 700035BC
	0x0F124718,    // 700035BE
	0x0F1200CA,    // 700035C0
	0x0F125CC1,    // 700035C2
	0x0F1203BD,    // 700035C4
	0x0F120000,    // 700035C6
	0x0F121C08,    // 700035C8
	0x0F127000,    // 700035CA
	0x0F123290,    // 700035CC
	0x0F127000,    // 700035CE
	0x0F123657,    // 700035D0
	0x0F127000,    // 700035D2
	0x0F12D9E7,    // 700035D4
	0x0F120000,    // 700035D6
	0x0F12383F,    // 700035D8
	0x0F127000,    // 700035DA
	0x0F12395D,    // 700035DC
	0x0F120000,    // 700035DE
	0x0F1238D1,    // 700035E0
	0x0F127000,    // 700035E2
	0x0F120000,    // 700035E4
	0x0F127000,    // 700035E6
	0x0F12399D,    // 700035E8
	0x0F127000,    // 700035EA
	0x0F12F903,    // 700035EC
	0x0F120000,    // 700035EE
	0x0F123AC1,    // 700035F0
	0x0F127000,    // 700035F2
	0x0F123FC8,    // 700035F4
	0x0F127000,    // 700035F6
	0x0F12368F,    // 700035F8
	0x0F127000,    // 700035FA
	0x0F12495F,    // 700035FC
	0x0F120000,    // 700035FE
	0x0F1236ED,    // 70003600
	0x0F127000,    // 70003602
	0x0F12E421,    // 70003604
	0x0F120000,    // 70003606
	0x0F1237AB,    // 70003608
	0x0F127000,    // 7000360A
	0x0F12216D,    // 7000360C
	0x0F120000,    // 7000360E
	0x0F12381F,    // 70003610
	0x0F127000,    // 70003612
	0x0F120179,    // 70003614
	0x0F120001,    // 70003616
	0x0F123BD5,    // 70003618
	0x0F127000,    // 7000361A
	0x0F1204C9,    // 7000361C
	0x0F120000,    // 7000361E
	0x0F123B25,    // 70003620
	0x0F127000,    // 70003622
	0x0F125027,    // 70003624
	0x0F120000,    // 70003626
	0x0F123BE1,    // 70003628
	0x0F127000,    // 7000362A
	0x0F1242B7,    // 7000362C
	0x0F120000,    // 7000362E
	0x0F1207FF,    // 70003630
	0x0F120000,    // 70003632
	0x0F123C5F,    // 70003634
	0x0F127000,    // 70003636
	0x0F12B570,    // 70003638
	0x0F12000D,    // 7000363A
	0x0F124CFC,    // 7000363C
	0x0F128821,    // 7000363E
	0x0F12F000,    // 70003640
	0x0F12FB46,    // 70003642
	0x0F128820,    // 70003644
	0x0F124AFB,    // 70003646
	0x0F120081,    // 70003648
	0x0F125055,    // 7000364A
	0x0F121C40,    // 7000364C
	0x0F128020,    // 7000364E
	0x0F12BC70,    // 70003650
	0x0F12BC08,    // 70003652
	0x0F124718,    // 70003654
	0x0F126801,    // 70003656
	0x0F120409,    // 70003658
	0x0F120C09,    // 7000365A
	0x0F126840,    // 7000365C
	0x0F120400,    // 7000365E
	0x0F120C00,    // 70003660
	0x0F124AF5,    // 70003662
	0x0F128992,    // 70003664
	0x0F122A00,    // 70003666
	0x0F12D00D,    // 70003668
	0x0F122300,    // 7000366A
	0x0F121A80,    // 7000366C
	0x0F12D400,    // 7000366E
	0x0F120003,    // 70003670
	0x0F120418,    // 70003672
	0x0F120C00,    // 70003674
	0x0F124BF1,    // 70003676
	0x0F121851,    // 70003678
	0x0F12891B,    // 7000367A
	0x0F12428B,    // 7000367C
	0x0F12D300,    // 7000367E
	0x0F12000B,    // 70003680
	0x0F120419,    // 70003682
	0x0F120C09,    // 70003684
	0x0F124AEE,    // 70003686
	0x0F128151,    // 70003688
	0x0F128190,    // 7000368A
	0x0F124770,    // 7000368C
	0x0F12B510,    // 7000368E
	0x0F124CEC,    // 70003690
	0x0F1248ED,    // 70003692
	0x0F1278A1,    // 70003694
	0x0F122900,    // 70003696
	0x0F12D101,    // 70003698
	0x0F1287C1,    // 7000369A
	0x0F12E004,    // 7000369C
	0x0F127AE1,    // 7000369E
	0x0F122900,    // 700036A0
	0x0F12D001,    // 700036A2
	0x0F122101,    // 700036A4
	0x0F1287C1,    // 700036A6
	0x0F12F000,    // 700036A8
	0x0F12FB1A,    // 700036AA
	0x0F1249E7,    // 700036AC
	0x0F128B08,    // 700036AE
	0x0F1206C2,    // 700036B0
	0x0F12D50A,    // 700036B2
	0x0F127AA2,    // 700036B4
	0x0F120652,    // 700036B6
	0x0F12D507,    // 700036B8
	0x0F122210,    // 700036BA
	0x0F124390,    // 700036BC
	0x0F128308,    // 700036BE
	0x0F1248E3,    // 700036C0
	0x0F127AE1,    // 700036C2
	0x0F126B00,    // 700036C4
	0x0F12F000,    // 700036C6
	0x0F12FB13,    // 700036C8
	0x0F1248DB,    // 700036CA
	0x0F1289C0,    // 700036CC
	0x0F122801,    // 700036CE
	0x0F12D109,    // 700036D0
	0x0F1278A0,    // 700036D2
	0x0F122800,    // 700036D4
	0x0F12D006,    // 700036D6
	0x0F127AE0,    // 700036D8
	0x0F122800,    // 700036DA
	0x0F12D003,    // 700036DC
	0x0F127AA0,    // 700036DE
	0x0F122140,    // 700036E0
	0x0F124308,    // 700036E2
	0x0F1272A0,    // 700036E4
	0x0F12BC10,    // 700036E6
	0x0F12BC08,    // 700036E8
	0x0F124718,    // 700036EA
	0x0F12B570,    // 700036EC
	0x0F124DD7,    // 700036EE
	0x0F124CD7,    // 700036F0
	0x0F128B28,    // 700036F2
	0x0F120701,    // 700036F4
	0x0F12D507,    // 700036F6
	0x0F122108,    // 700036F8
	0x0F124388,    // 700036FA
	0x0F128328,    // 700036FC
	0x0F1249D5,    // 700036FE
	0x0F126B20,    // 70003700
	0x0F126B89,    // 70003702
	0x0F12F000,    // 70003704
	0x0F12FAFC,    // 70003706
	0x0F128B28,    // 70003708
	0x0F1206C1,    // 7000370A
	0x0F12D5A0,    // 7000370C
	0x0F1249CD,    // 7000370E
	0x0F127A8A,    // 70003710
	0x0F120652,    // 70003712
	0x0F12D49C,    // 70003714
	0x0F122210,    // 70003716
	0x0F124390,    // 70003718
	0x0F128328,    // 7000371A
	0x0F127AC9,    // 7000371C
	0x0F126B20,    // 7000371E
	0x0F12F000,    // 70003720
	0x0F12FAE6,    // 70003722
	0x0F12E794,    // 70003724
	0x0F12B5F8,    // 70003726
	0x0F1249CB,    // 70003728
	0x0F128F08,    // 7000372A
	0x0F12000C,    // 7000372C
	0x0F123480,    // 7000372E
	0x0F122800,    // 70003730
	0x0F12D000,    // 70003732
	0x0F128360,    // 70003734
	0x0F122000,    // 70003736
	0x0F128708,    // 70003738
	0x0F124DC8,    // 7000373A
	0x0F1226FF,    // 7000373C
	0x0F128828,    // 7000373E
	0x0F121C76,    // 70003740
	0x0F122702,    // 70003742
	0x0F122803,    // 70003744
	0x0F12D112,    // 70003746
	0x0F128868,    // 70003748
	0x0F122800,    // 7000374A
	0x0F12D10F,    // 7000374C
	0x0F1288E8,    // 7000374E
	0x0F122800,    // 70003750
	0x0F12D10C,    // 70003752
	0x0F12F000,    // 70003754
	0x0F12FADC,    // 70003756
	0x0F122800,    // 70003758
	0x0F12D008,    // 7000375A
	0x0F128B60,    // 7000375C
	0x0F122800,    // 7000375E
	0x0F12D001,    // 70003760
	0x0F1280EE,    // 70003762
	0x0F1280AF,    // 70003764
	0x0F122001,    // 70003766
	0x0F127268,    // 70003768
	0x0F12F000,    // 7000376A
	0x0F12FAD9,    // 7000376C
	0x0F128828,    // 7000376E
	0x0F122802,    // 70003770
	0x0F12D10E,    // 70003772
	0x0F128868,    // 70003774
	0x0F122800,    // 70003776
	0x0F12D10B,    // 70003778
	0x0F1288E8,    // 7000377A
	0x0F122800,    // 7000377C
	0x0F12D108,    // 7000377E
	0x0F128B60,    // 70003780
	0x0F122800,    // 70003782
	0x0F12D001,    // 70003784
	0x0F1280EE,    // 70003786
	0x0F1280AF,    // 70003788
	0x0F122001,    // 7000378A
	0x0F127268,    // 7000378C
	0x0F12F000,    // 7000378E
	0x0F12FAC7,    // 70003790
	0x0F1288E8,    // 70003792
	0x0F122800,    // 70003794
	0x0F12D006,    // 70003796
	0x0F121FC1,    // 70003798
	0x0F1239FD,    // 7000379A
	0x0F12D003,    // 7000379C
	0x0F122001,    // 7000379E
	0x0F12BCF8,    // 700037A0
	0x0F12BC08,    // 700037A2
	0x0F124718,    // 700037A4
	0x0F122000,    // 700037A6
	0x0F12E7FA,    // 700037A8
	0x0F12B570,    // 700037AA
	0x0F124CAC,    // 700037AC
	0x0F128860,    // 700037AE
	0x0F122800,    // 700037B0
	0x0F12D00C,    // 700037B2
	0x0F128820,    // 700037B4
	0x0F124DA3,    // 700037B6
	0x0F122800,    // 700037B8
	0x0F12D009,    // 700037BA
	0x0F120029,    // 700037BC
	0x0F1231A0,    // 700037BE
	0x0F127AC9,    // 700037C0
	0x0F122900,    // 700037C2
	0x0F12D004,    // 700037C4
	0x0F127AA8,    // 700037C6
	0x0F122180,    // 700037C8
	0x0F124308,    // 700037CA
	0x0F1272A8,    // 700037CC
	0x0F12E73F,    // 700037CE
	0x0F122800,    // 700037D0
	0x0F12D003,    // 700037D2
	0x0F12F7FF,    // 700037D4
	0x0F12FFA7,    // 700037D6
	0x0F122800,    // 700037D8
	0x0F12D1F8,    // 700037DA
	0x0F122000,    // 700037DC
	0x0F128060,    // 700037DE
	0x0F128820,    // 700037E0
	0x0F122800,    // 700037E2
	0x0F12D003,    // 700037E4
	0x0F122008,    // 700037E6
	0x0F12F000,    // 700037E8
	0x0F12FAA2,    // 700037EA
	0x0F12E00B,    // 700037EC
	0x0F12489C,    // 700037EE
	0x0F123020,    // 700037F0
	0x0F128880,    // 700037F2
	0x0F122800,    // 700037F4
	0x0F12D103,    // 700037F6
	0x0F127AA8,    // 700037F8
	0x0F122101,    // 700037FA
	0x0F124308,    // 700037FC
	0x0F1272A8,    // 700037FE
	0x0F122010,    // 70003800
	0x0F12F000,    // 70003802
	0x0F12FA95,    // 70003804
	0x0F128820,    // 70003806
	0x0F122800,    // 70003808
	0x0F12D1E0,    // 7000380A
	0x0F12488A,    // 7000380C
	0x0F1289C0,    // 7000380E
	0x0F122801,    // 70003810
	0x0F12D1DC,    // 70003812
	0x0F127AA8,    // 70003814
	0x0F1221BF,    // 70003816
	0x0F124008,    // 70003818
	0x0F1272A8,    // 7000381A
	0x0F12E718,    // 7000381C
	0x0F126800,    // 7000381E
	0x0F124990,    // 70003820
	0x0F128188,    // 70003822
	0x0F124890,    // 70003824
	0x0F122201,    // 70003826
	0x0F128981,    // 70003828
	0x0F124890,    // 7000382A
	0x0F120252,    // 7000382C
	0x0F124291,    // 7000382E
	0x0F12D902,    // 70003830
	0x0F122102,    // 70003832
	0x0F128181,    // 70003834
	0x0F124770,    // 70003836
	0x0F122101,    // 70003838
	0x0F128181,    // 7000383A
	0x0F124770,    // 7000383C
	0x0F12B5F1,    // 7000383E
	0x0F124E80,    // 70003840
	0x0F128834,    // 70003842
	0x0F122C00,    // 70003844
	0x0F12D03F,    // 70003846
	0x0F122001,    // 70003848
	0x0F122C08,    // 7000384A
	0x0F12D000,    // 7000384C
	0x0F122000,    // 7000384E
	0x0F1270B0,    // 70003850
	0x0F124D7F,    // 70003852
	0x0F122800,    // 70003854
	0x0F12D009,    // 70003856
	0x0F12F000,    // 70003858
	0x0F12FA72,    // 7000385A
	0x0F120028,    // 7000385C
	0x0F1238F0,    // 7000385E
	0x0F126328,    // 70003860
	0x0F127AB0,    // 70003862
	0x0F12217E,    // 70003864
	0x0F124008,    // 70003866
	0x0F1272B0,    // 70003868
	0x0F12E00F,    // 7000386A
	0x0F124F7A,    // 7000386C
	0x0F123780,    // 7000386E
	0x0F128B78,    // 70003870
	0x0F122800,    // 70003872
	0x0F12D005,    // 70003874
	0x0F12F000,    // 70003876
	0x0F12FA6B,    // 70003878
	0x0F122000,    // 7000387A
	0x0F128378,    // 7000387C
	0x0F124976,    // 7000387E
	0x0F128708,    // 70003880
	0x0F122000,    // 70003882
	0x0F12F000,    // 70003884
	0x0F12FA6C,    // 70003886
	0x0F124879,    // 70003888
	0x0F126328,    // 7000388A
	0x0F1278B1,    // 7000388C
	0x0F122700,    // 7000388E
	0x0F120038,    // 70003890
	0x0F122900,    // 70003892
	0x0F12D008,    // 70003894
	0x0F124972,    // 70003896
	0x0F123920,    // 70003898
	0x0F128ACA,    // 7000389A
	0x0F122A00,    // 7000389C
	0x0F12D003,    // 7000389E
	0x0F128B09,    // 700038A0
	0x0F122900,    // 700038A2
	0x0F12D000,    // 700038A4
	0x0F122001,    // 700038A6
	0x0F127170,    // 700038A8
	0x0F122C02,    // 700038AA
	0x0F12D102,    // 700038AC
	0x0F124868,    // 700038AE
	0x0F123860,    // 700038B0
	0x0F126328,    // 700038B2
	0x0F122201,    // 700038B4
	0x0F122C02,    // 700038B6
	0x0F12D000,    // 700038B8
	0x0F122200,    // 700038BA
	0x0F124861,    // 700038BC
	0x0F122110,    // 700038BE
	0x0F12300A,    // 700038C0
	0x0F12F000,    // 700038C2
	0x0F12FA55,    // 700038C4
	0x0F128037,    // 700038C6
	0x0F129900,    // 700038C8
	0x0F120020,    // 700038CA
	0x0F12600C,    // 700038CC
	0x0F12E767,    // 700038CE
	0x0F12B538,    // 700038D0
	0x0F124865,    // 700038D2
	0x0F124669,    // 700038D4
	0x0F123848,    // 700038D6
	0x0F12F000,    // 700038D8
	0x0F12FA52,    // 700038DA
	0x0F124A5E,    // 700038DC
	0x0F124862,    // 700038DE
	0x0F128F51,    // 700038E0
	0x0F122400,    // 700038E2
	0x0F123020,    // 700038E4
	0x0F122900,    // 700038E6
	0x0F12D00A,    // 700038E8
	0x0F128754,    // 700038EA
	0x0F126941,    // 700038EC
	0x0F126451,    // 700038EE
	0x0F126491,    // 700038F0
	0x0F12466B,    // 700038F2
	0x0F128819,    // 700038F4
	0x0F1287D1,    // 700038F6
	0x0F12885B,    // 700038F8
	0x0F120011,    // 700038FA
	0x0F123140,    // 700038FC
	0x0F12800B,    // 700038FE
	0x0F128F91,    // 70003900
	0x0F122900,    // 70003902
	0x0F12D002,    // 70003904
	0x0F128794,    // 70003906
	0x0F126940,    // 70003908
	0x0F126490,    // 7000390A
	0x0F12F000,    // 7000390C
	0x0F12FA40,    // 7000390E
	0x0F12BC38,    // 70003910
	0x0F12BC08,    // 70003912
	0x0F124718,    // 70003914
	0x0F12B5F8,    // 70003916
	0x0F124C56,    // 70003918
	0x0F1289E0,    // 7000391A
	0x0F12F000,    // 7000391C
	0x0F12FA40,    // 7000391E
	0x0F120006,    // 70003920
	0x0F128A20,    // 70003922
	0x0F12F000,    // 70003924
	0x0F12FA44,    // 70003926
	0x0F120007,    // 70003928
	0x0F12484F,    // 7000392A
	0x0F124D4A,    // 7000392C
	0x0F123020,    // 7000392E
	0x0F126CA9,    // 70003930
	0x0F126940,    // 70003932
	0x0F121809,    // 70003934
	0x0F120200,    // 70003936
	0x0F12F000,    // 70003938
	0x0F12FA42,    // 7000393A
	0x0F120400,    // 7000393C
	0x0F120C00,    // 7000393E
	0x0F12002A,    // 70003940
	0x0F12326E,    // 70003942
	0x0F120011,    // 70003944
	0x0F12390A,    // 70003946
	0x0F122305,    // 70003948
	0x0F12F000,    // 7000394A
	0x0F12FA3F,    // 7000394C
	0x0F124C43,    // 7000394E
	0x0F1261A0,    // 70003950
	0x0F128FEB,    // 70003952
	0x0F120002,    // 70003954
	0x0F120031,    // 70003956
	0x0F120018,    // 70003958
	0x0F12F000,    // 7000395A
	0x0F12FA3F,    // 7000395C
	0x0F12466B,    // 7000395E
	0x0F120005,    // 70003960
	0x0F128018,    // 70003962
	0x0F12483C,    // 70003964
	0x0F1269A2,    // 70003966
	0x0F123040,    // 70003968
	0x0F128800,    // 7000396A
	0x0F120039,    // 7000396C
	0x0F12F000,    // 7000396E
	0x0F12FA35,    // 70003970
	0x0F12466B,    // 70003972
	0x0F120006,    // 70003974
	0x0F128058,    // 70003976
	0x0F120021,    // 70003978
	0x0F129800,    // 7000397A
	0x0F12311C,    // 7000397C
	0x0F12F000,    // 7000397E
	0x0F12FA35,    // 70003980
	0x0F124935,    // 70003982
	0x0F123180,    // 70003984
	0x0F12808D,    // 70003986
	0x0F1280CE,    // 70003988
	0x0F128BA1,    // 7000398A
	0x0F124836,    // 7000398C
	0x0F123820,    // 7000398E
	0x0F128001,    // 70003990
	0x0F128BE1,    // 70003992
	0x0F128041,    // 70003994
	0x0F128C21,    // 70003996
	0x0F128081,    // 70003998
	0x0F12E701,    // 7000399A
	0x0F12B5F8,    // 7000399C
	0x0F124E2E,    // 7000399E
	0x0F126C70,    // 700039A0
	0x0F126CB1,    // 700039A2
	0x0F120200,    // 700039A4
	0x0F12F000,    // 700039A6
	0x0F12FA0B,    // 700039A8
	0x0F120400,    // 700039AA
	0x0F120C00,    // 700039AC
	0x0F122401,    // 700039AE
	0x0F120364,    // 700039B0
	0x0F1242A0,    // 700039B2
	0x0F12D200,    // 700039B4
	0x0F120004,    // 700039B6
	0x0F124A27,    // 700039B8
	0x0F120020,    // 700039BA
	0x0F12327E,    // 700039BC
	0x0F121F91,    // 700039BE
	0x0F122303,    // 700039C0
	0x0F12F000,    // 700039C2
	0x0F12FA03,    // 700039C4
	0x0F120405,    // 700039C6
	0x0F120C2D,    // 700039C8
	0x0F124A23,    // 700039CA
	0x0F120020,    // 700039CC
	0x0F12325A,    // 700039CE
	0x0F120011,    // 700039D0
	0x0F12390A,    // 700039D2
	0x0F122305,    // 700039D4
	0x0F12F000,    // 700039D6
	0x0F12F9F9,    // 700039D8
	0x0F12491F,    // 700039DA
	0x0F1264C8,    // 700039DC
	0x0F12491F,    // 700039DE
	0x0F124E21,    // 700039E0
	0x0F1288C8,    // 700039E2
	0x0F122701,    // 700039E4
	0x0F122800,    // 700039E6
	0x0F12D009,    // 700039E8
	0x0F124C23,    // 700039EA
	0x0F1238FF,    // 700039EC
	0x0F121E40,    // 700039EE
	0x0F12D00A,    // 700039F0
	0x0F122804,    // 700039F2
	0x0F12D042,    // 700039F4
	0x0F122806,    // 700039F6
	0x0F12D101,    // 700039F8
	0x0F122000,    // 700039FA
	0x0F1280C8,    // 700039FC
	0x0F1282B7,    // 700039FE
	0x0F122001,    // 70003A00
	0x0F12F000,    // 70003A02
	0x0F12F9FB,    // 70003A04
	0x0F12E6CB,    // 70003A06
	0x0F12000D,    // 70003A08
	0x0F12724F,    // 70003A0A
	0x0F122001,    // 70003A0C
	0x0F12F000,    // 70003A0E
	0x0F12F9FD,    // 70003A10
	0x0F12F000,    // 70003A12
	0x0F12FA03,    // 70003A14
	0x0F124910,    // 70003A16
	0x0F123148,    // 70003A18
	0x0F12C903,    // 70003A1A
	0x0F124348,    // 70003A1C
	0x0F120A00,    // 70003A1E
	0x0F126160,    // 70003A20
	0x0F1220FF,    // 70003A22
	0x0F121D40,    // 70003A24
	0x0F1280E8,    // 70003A26
	0x0F12480C,    // 70003A28
	0x0F123040,    // 70003A2A
	0x0F127707,    // 70003A2C
	0x0F12E7E6,    // 70003A2E
	0x0F123290,    // 70003A30
	0x0F127000,    // 70003A32
	0x0F123294,    // 70003A34
	0x0F127000,    // 70003A36
	0x0F1204A8,    // 70003A38
	0x0F127000,    // 70003A3A
	0x0F1215DC,    // 70003A3C
	0x0F127000,    // 70003A3E
	0x0F125000,    // 70003A40
	0x0F12D000,    // 70003A42
	0x0F121E84,    // 70003A44
	0x0F127000,    // 70003A46
	0x0F121BE4,    // 70003A48
	0x0F127000,    // 70003A4A
	0x0F122EA8,    // 70003A4C
	0x0F127000,    // 70003A4E
	0x0F1221A4,    // 70003A50
	0x0F127000,    // 70003A52
	0x0F120100,    // 70003A54
	0x0F127000,    // 70003A56
	0x0F123F48,    // 70003A58
	0x0F127000,    // 70003A5A
	0x0F1231A0,    // 70003A5C
	0x0F127000,    // 70003A5E
	0x0F1201E8,    // 70003A60
	0x0F127000,    // 70003A62
	0x0F12F2A0,    // 70003A64
	0x0F12D000,    // 70003A66
	0x0F122A44,    // 70003A68
	0x0F127000,    // 70003A6A
	0x0F12F400,    // 70003A6C
	0x0F12D000,    // 70003A6E
	0x0F122024,    // 70003A70
	0x0F127000,    // 70003A72
	0x0F121650,    // 70003A74
	0x0F127000,    // 70003A76
	0x0F122A64,    // 70003A78
	0x0F127000,    // 70003A7A
	0x0F124982,    // 70003A7C
	0x0F12724F,    // 70003A7E
	0x0F1220FF,    // 70003A80
	0x0F121DC0,    // 70003A82
	0x0F1280C8,    // 70003A84
	0x0F12F000,    // 70003A86
	0x0F12F9D1,    // 70003A88
	0x0F124980,    // 70003A8A
	0x0F126ACA,    // 70003A8C
	0x0F12604A,    // 70003A8E
	0x0F122800,    // 70003A90
	0x0F12D006,    // 70003A92
	0x0F12436A,    // 70003A94
	0x0F120001,    // 70003A96
	0x0F120010,    // 70003A98
	0x0F12F000,    // 70003A9A
	0x0F12F991,    // 70003A9C
	0x0F126160,    // 70003A9E
	0x0F12E001,    // 70003AA0
	0x0F12436A,    // 70003AA2
	0x0F126162,    // 70003AA4
	0x0F128BF0,    // 70003AA6
	0x0F122800,    // 70003AA8
	0x0F12D001,    // 70003AAA
	0x0F12F7FF,    // 70003AAC
	0x0F12FF33,    // 70003AAE
	0x0F122000,    // 70003AB0
	0x0F12F000,    // 70003AB2
	0x0F12F9AB,    // 70003AB4
	0x0F124974,    // 70003AB6
	0x0F1220FF,    // 70003AB8
	0x0F121DC0,    // 70003ABA
	0x0F1280C8,    // 70003ABC
	0x0F12E79E,    // 70003ABE
	0x0F12B510,    // 70003AC0
	0x0F12F000,    // 70003AC2
	0x0F12F9BB,    // 70003AC4
	0x0F124870,    // 70003AC6
	0x0F1288C0,    // 70003AC8
	0x0F121FC1,    // 70003ACA
	0x0F1239FD,    // 70003ACC
	0x0F12D103,    // 70003ACE
	0x0F12496F,    // 70003AD0
	0x0F1220FF,    // 70003AD2
	0x0F121C40,    // 70003AD4
	0x0F128048,    // 70003AD6
	0x0F12E605,    // 70003AD8
	0x0F12B5F8,    // 70003ADA
	0x0F122400,    // 70003ADC
	0x0F124D6D,    // 70003ADE
	0x0F12486D,    // 70003AE0
	0x0F12210E,    // 70003AE2
	0x0F128041,    // 70003AE4
	0x0F122101,    // 70003AE6
	0x0F128001,    // 70003AE8
	0x0F12F000,    // 70003AEA
	0x0F12F9AF,    // 70003AEC
	0x0F12486B,    // 70003AEE
	0x0F128840,    // 70003AF0
	0x0F12F000,    // 70003AF2
	0x0F12F9B3,    // 70003AF4
	0x0F124E6A,    // 70003AF6
	0x0F12270D,    // 70003AF8
	0x0F12073F,    // 70003AFA
	0x0F1219E8,    // 70003AFC
	0x0F128803,    // 70003AFE
	0x0F1200E2,    // 70003B00
	0x0F121991,    // 70003B02
	0x0F12804B,    // 70003B04
	0x0F128843,    // 70003B06
	0x0F1252B3,    // 70003B08
	0x0F128882,    // 70003B0A
	0x0F1280CA,    // 70003B0C
	0x0F1288C0,    // 70003B0E
	0x0F128088,    // 70003B10
	0x0F123508,    // 70003B12
	0x0F12042D,    // 70003B14
	0x0F120C2D,    // 70003B16
	0x0F121C64,    // 70003B18
	0x0F120424,    // 70003B1A
	0x0F120C24,    // 70003B1C
	0x0F122C07,    // 70003B1E
	0x0F12D3EC,    // 70003B20
	0x0F12E63D,    // 70003B22
	0x0F12B5F0,    // 70003B24
	0x0F12B085,    // 70003B26
	0x0F126801,    // 70003B28
	0x0F129103,    // 70003B2A
	0x0F126881,    // 70003B2C
	0x0F12040A,    // 70003B2E
	0x0F120C12,    // 70003B30
	0x0F12495C,    // 70003B32
	0x0F128B89,    // 70003B34
	0x0F122900,    // 70003B36
	0x0F12D001,    // 70003B38
	0x0F120011,    // 70003B3A
	0x0F12E000,    // 70003B3C
	0x0F122100,    // 70003B3E
	0x0F129102,    // 70003B40
	0x0F126840,    // 70003B42
	0x0F120401,    // 70003B44
	0x0F129803,    // 70003B46
	0x0F120C09,    // 70003B48
	0x0F12F000,    // 70003B4A
	0x0F12F98F,    // 70003B4C
	0x0F124854,    // 70003B4E
	0x0F123080,    // 70003B50
	0x0F128900,    // 70003B52
	0x0F122800,    // 70003B54
	0x0F12D039,    // 70003B56
	0x0F122100,    // 70003B58
	0x0F124854,    // 70003B5A
	0x0F124D52,    // 70003B5C
	0x0F124684,    // 70003B5E
	0x0F124B53,    // 70003B60
	0x0F124C4F,    // 70003B62
	0x0F1288DA,    // 70003B64
	0x0F120048,    // 70003B66
	0x0F1200D7,    // 70003B68
	0x0F12193E,    // 70003B6A
	0x0F12197F,    // 70003B6C
	0x0F12183F,    // 70003B6E
	0x0F125A36,    // 70003B70
	0x0F128AFF,    // 70003B72
	0x0F12437E,    // 70003B74
	0x0F1200B6,    // 70003B76
	0x0F120C37,    // 70003B78
	0x0F121906,    // 70003B7A
	0x0F123680,    // 70003B7C
	0x0F128177,    // 70003B7E
	0x0F121C52,    // 70003B80
	0x0F1200D2,    // 70003B82
	0x0F121914,    // 70003B84
	0x0F121952,    // 70003B86
	0x0F121812,    // 70003B88
	0x0F125A24,    // 70003B8A
	0x0F128AD2,    // 70003B8C
	0x0F124354,    // 70003B8E
	0x0F1200A2,    // 70003B90
	0x0F120C12,    // 70003B92
	0x0F128272,    // 70003B94
	0x0F12891C,    // 70003B96
	0x0F12895B,    // 70003B98
	0x0F124367,    // 70003B9A
	0x0F12435A,    // 70003B9C
	0x0F121943,    // 70003B9E
	0x0F123340,    // 70003BA0
	0x0F1289DB,    // 70003BA2
	0x0F129C02,    // 70003BA4
	0x0F1218BA,    // 70003BA6
	0x0F124363,    // 70003BA8
	0x0F1218D2,    // 70003BAA
	0x0F120212,    // 70003BAC
	0x0F120C12,    // 70003BAE
	0x0F12466B,    // 70003BB0
	0x0F12521A,    // 70003BB2
	0x0F124663,    // 70003BB4
	0x0F127DDB,    // 70003BB6
	0x0F12435A,    // 70003BB8
	0x0F129B03,    // 70003BBA
	0x0F120252,    // 70003BBC
	0x0F120C12,    // 70003BBE
	0x0F12521A,    // 70003BC0
	0x0F121C49,    // 70003BC2
	0x0F120409,    // 70003BC4
	0x0F120C09,    // 70003BC6
	0x0F122904,    // 70003BC8
	0x0F12D3C9,    // 70003BCA
	0x0F12B005,    // 70003BCC
	0x0F12BCF0,    // 70003BCE
	0x0F12BC08,    // 70003BD0
	0x0F124718,    // 70003BD2
	0x0F12B510,    // 70003BD4
	0x0F12F7FF,    // 70003BD6
	0x0F12FF80,    // 70003BD8
	0x0F12F000,    // 70003BDA
	0x0F12F94F,    // 70003BDC
	0x0F12E582,    // 70003BDE
	0x0F12B570,    // 70003BE0
	0x0F126804,    // 70003BE2
	0x0F12F000,    // 70003BE4
	0x0F12F952,    // 70003BE6
	0x0F124D32,    // 70003BE8
	0x0F128C29,    // 70003BEA
	0x0F121A40,    // 70003BEC
	0x0F1242A0,    // 70003BEE
	0x0F12D901,    // 70003BF0
	0x0F120020,    // 70003BF2
	0x0F12E003,    // 70003BF4
	0x0F12F000,    // 70003BF6
	0x0F12F949,    // 70003BF8
	0x0F128C29,    // 70003BFA
	0x0F121A40,    // 70003BFC
	0x0F126268,    // 70003BFE
	0x0F12F000,    // 70003C00
	0x0F12F94C,    // 70003C02
	0x0F1262A8,    // 70003C04
	0x0F12F000,    // 70003C06
	0x0F12F951,    // 70003C08
	0x0F126328,    // 70003C0A
	0x0F128869,    // 70003C0C
	0x0F122900,    // 70003C0E
	0x0F12D000,    // 70003C10
	0x0F1262A8,    // 70003C12
	0x0F124828,    // 70003C14
	0x0F126B00,    // 70003C16
	0x0F128C00,    // 70003C18
	0x0F122800,    // 70003C1A
	0x0F12D11B,    // 70003C1C
	0x0F126AA8,    // 70003C1E
	0x0F12F000,    // 70003C20
	0x0F12F94C,    // 70003C22
	0x0F1261E8,    // 70003C24
	0x0F124A1E,    // 70003C26
	0x0F123280,    // 70003C28
	0x0F128B91,    // 70003C2A
	0x0F122900,    // 70003C2C
	0x0F12D00B,    // 70003C2E
	0x0F120011,    // 70003C30
	0x0F123120,    // 70003C32
	0x0F128809,    // 70003C34
	0x0F124288,    // 70003C36
	0x0F12D907,    // 70003C38
	0x0F1261E9,    // 70003C3A
	0x0F128C28,    // 70003C3C
	0x0F121A08,    // 70003C3E
	0x0F1262A8,    // 70003C40
	0x0F12F000,    // 70003C42
	0x0F12F92B,    // 70003C44
	0x0F1262A8,    // 70003C46
	0x0F12E502,    // 70003C48
	0x0F128BD1,    // 70003C4A
	0x0F124288,    // 70003C4C
	0x0F12D800,    // 70003C4E
	0x0F120008,    // 70003C50
	0x0F1261E8,    // 70003C52
	0x0F12E4FC,    // 70003C54
	0x0F12F000,    // 70003C56
	0x0F12F919,    // 70003C58
	0x0F1261E8,    // 70003C5A
	0x0F12E4F8,    // 70003C5C
	0x0F12B510,    // 70003C5E
	0x0F12F000,    // 70003C60
	0x0F12F934,    // 70003C62
	0x0F12480E,    // 70003C64
	0x0F1230A0,    // 70003C66
	0x0F128841,    // 70003C68
	0x0F122900,    // 70003C6A
	0x0F12D007,    // 70003C6C
	0x0F124A07,    // 70003C6E
	0x0F123280,    // 70003C70
	0x0F126953,    // 70003C72
	0x0F124A11,    // 70003C74
	0x0F12428B,    // 70003C76
	0x0F12D202,    // 70003C78
	0x0F128880,    // 70003C7A
	0x0F1281D0,    // 70003C7C
	0x0F12E532,    // 70003C7E
	0x0F1288C0,    // 70003C80
	0x0F1281D0,    // 70003C82
	0x0F12E52F,    // 70003C84
	0x0F120000,    // 70003C86
	0x0F1231A0,    // 70003C88
	0x0F127000,    // 70003C8A
	0x0F1229E4,    // 70003C8C
	0x0F127000,    // 70003C8E
	0x0F12C100,    // 70003C90
	0x0F12D000,    // 70003C92
	0x0F12A006,    // 70003C94
	0x0F120000,    // 70003C96
	0x0F12A000,    // 70003C98
	0x0F12D000,    // 70003C9A
	0x0F12064C,    // 70003C9C
	0x0F127000,    // 70003C9E
	0x0F123F48,    // 70003CA0
	0x0F127000,    // 70003CA2
	0x0F1207C4,    // 70003CA4
	0x0F127000,    // 70003CA6
	0x0F1207E8,    // 70003CA8
	0x0F127000,    // 70003CAA
	0x0F122B24,    // 70003CAC
	0x0F127000,    // 70003CAE
	0x0F121FA0,    // 70003CB0
	0x0F127000,    // 70003CB2
	0x0F121E3C,    // 70003CB4
	0x0F127000,    // 70003CB6
	0x0F1221A4,    // 70003CB8
	0x0F127000,    // 70003CBA
	0x0F12E200,    // 70003CBC
	0x0F12D000,    // 70003CBE
	0x0F124778,    // 70003CC0
	0x0F1246C0,    // 70003CC2
	0x0F12C000,    // 70003CC4
	0x0F12E59F,    // 70003CC6
	0x0F12FF1C,    // 70003CC8
	0x0F12E12F,    // 70003CCA
	0x0F121F63,    // 70003CCC
	0x0F120001,    // 70003CCE
	0x0F124778,    // 70003CD0
	0x0F1246C0,    // 70003CD2
	0x0F12C000,    // 70003CD4
	0x0F12E59F,    // 70003CD6
	0x0F12FF1C,    // 70003CD8
	0x0F12E12F,    // 70003CDA
	0x0F121EDF,    // 70003CDC
	0x0F120001,    // 70003CDE
	0x0F124778,    // 70003CE0
	0x0F1246C0,    // 70003CE2
	0x0F12C000,    // 70003CE4
	0x0F12E59F,    // 70003CE6
	0x0F12FF1C,    // 70003CE8
	0x0F12E12F,    // 70003CEA
	0x0F12495F,    // 70003CEC
	0x0F120000,    // 70003CEE
	0x0F124778,    // 70003CF0
	0x0F1246C0,    // 70003CF2
	0x0F12C000,    // 70003CF4
	0x0F12E59F,    // 70003CF6
	0x0F12FF1C,    // 70003CF8
	0x0F12E12F,    // 70003CFA
	0x0F12E403,    // 70003CFC
	0x0F120000,    // 70003CFE
	0x0F124778,    // 70003D00
	0x0F1246C0,    // 70003D02
	0x0F12C000,    // 70003D04
	0x0F12E59F,    // 70003D06
	0x0F12FF1C,    // 70003D08
	0x0F12E12F,    // 70003D0A
	0x0F1224B3,    // 70003D0C
	0x0F120001,    // 70003D0E
	0x0F124778,    // 70003D10
	0x0F1246C0,    // 70003D12
	0x0F12C000,    // 70003D14
	0x0F12E59F,    // 70003D16
	0x0F12FF1C,    // 70003D18
	0x0F12E12F,    // 70003D1A
	0x0F12EECD,    // 70003D1C
	0x0F120000,    // 70003D1E
	0x0F124778,    // 70003D20
	0x0F1246C0,    // 70003D22
	0x0F12C000,    // 70003D24
	0x0F12E59F,    // 70003D26
	0x0F12FF1C,    // 70003D28
	0x0F12E12F,    // 70003D2A
	0x0F12F049,    // 70003D2C
	0x0F120000,    // 70003D2E
	0x0F124778,    // 70003D30
	0x0F1246C0,    // 70003D32
	0x0F12C000,    // 70003D34
	0x0F12E59F,    // 70003D36
	0x0F12FF1C,    // 70003D38
	0x0F12E12F,    // 70003D3A
	0x0F1212DF,    // 70003D3C
	0x0F120000,    // 70003D3E
	0x0F124778,    // 70003D40
	0x0F1246C0,    // 70003D42
	0x0F12C000,    // 70003D44
	0x0F12E59F,    // 70003D46
	0x0F12FF1C,    // 70003D48
	0x0F12E12F,    // 70003D4A
	0x0F12F05B,    // 70003D4C
	0x0F120000,    // 70003D4E
	0x0F124778,    // 70003D50
	0x0F1246C0,    // 70003D52
	0x0F12C000,    // 70003D54
	0x0F12E59F,    // 70003D56
	0x0F12FF1C,    // 70003D58
	0x0F12E12F,    // 70003D5A
	0x0F12F07B,    // 70003D5C
	0x0F120000,    // 70003D5E
	0x0F124778,    // 70003D60
	0x0F1246C0,    // 70003D62
	0x0F12C000,    // 70003D64
	0x0F12E59F,    // 70003D66
	0x0F12FF1C,    // 70003D68
	0x0F12E12F,    // 70003D6A
	0x0F12FE6D,    // 70003D6C
	0x0F120000,    // 70003D6E
	0x0F124778,    // 70003D70
	0x0F1246C0,    // 70003D72
	0x0F12C000,    // 70003D74
	0x0F12E59F,    // 70003D76
	0x0F12FF1C,    // 70003D78
	0x0F12E12F,    // 70003D7A
	0x0F123295,    // 70003D7C
	0x0F120000,    // 70003D7E
	0x0F124778,    // 70003D80
	0x0F1246C0,    // 70003D82
	0x0F12C000,    // 70003D84
	0x0F12E59F,    // 70003D86
	0x0F12FF1C,    // 70003D88
	0x0F12E12F,    // 70003D8A
	0x0F12234F,    // 70003D8C
	0x0F120000,    // 70003D8E
	0x0F124778,    // 70003D90
	0x0F1246C0,    // 70003D92
	0x0F12C000,    // 70003D94
	0x0F12E59F,    // 70003D96
	0x0F12FF1C,    // 70003D98
	0x0F12E12F,    // 70003D9A
	0x0F124521,    // 70003D9C
	0x0F120000,    // 70003D9E
	0x0F124778,    // 70003DA0
	0x0F1246C0,    // 70003DA2
	0x0F12C000,    // 70003DA4
	0x0F12E59F,    // 70003DA6
	0x0F12FF1C,    // 70003DA8
	0x0F12E12F,    // 70003DAA
	0x0F127C0D,    // 70003DAC
	0x0F120000,    // 70003DAE
	0x0F124778,    // 70003DB0
	0x0F1246C0,    // 70003DB2
	0x0F12C000,    // 70003DB4
	0x0F12E59F,    // 70003DB6
	0x0F12FF1C,    // 70003DB8
	0x0F12E12F,    // 70003DBA
	0x0F127C2B,    // 70003DBC
	0x0F120000,    // 70003DBE
	0x0F124778,    // 70003DC0
	0x0F1246C0,    // 70003DC2
	0x0F12F004,    // 70003DC4
	0x0F12E51F,    // 70003DC6
	0x0F1224C4,    // 70003DC8
	0x0F120001,    // 70003DCA
	0x0F124778,    // 70003DCC
	0x0F1246C0,    // 70003DCE
	0x0F12C000,    // 70003DD0
	0x0F12E59F,    // 70003DD2
	0x0F12FF1C,    // 70003DD4
	0x0F12E12F,    // 70003DD6
	0x0F123183,    // 70003DD8
	0x0F120000,    // 70003DDA
	0x0F124778,    // 70003DDC
	0x0F1246C0,    // 70003DDE
	0x0F12C000,    // 70003DE0
	0x0F12E59F,    // 70003DE2
	0x0F12FF1C,    // 70003DE4
	0x0F12E12F,    // 70003DE6
	0x0F12302F,    // 70003DE8
	0x0F120000,    // 70003DEA
	0x0F124778,    // 70003DEC
	0x0F1246C0,    // 70003DEE
	0x0F12C000,    // 70003DF0
	0x0F12E59F,    // 70003DF2
	0x0F12FF1C,    // 70003DF4
	0x0F12E12F,    // 70003DF6
	0x0F12EF07,    // 70003DF8
	0x0F120000,    // 70003DFA
	0x0F124778,    // 70003DFC
	0x0F1246C0,    // 70003DFE
	0x0F12C000,    // 70003E00
	0x0F12E59F,    // 70003E02
	0x0F12FF1C,    // 70003E04
	0x0F12E12F,    // 70003E06
	0x0F1248FB,    // 70003E08
	0x0F120000,    // 70003E0A
	0x0F124778,    // 70003E0C
	0x0F1246C0,    // 70003E0E
	0x0F12C000,    // 70003E10
	0x0F12E59F,    // 70003E12
	0x0F12FF1C,    // 70003E14
	0x0F12E12F,    // 70003E16
	0x0F12F0B1,    // 70003E18
	0x0F120000,    // 70003E1A
	0x0F124778,    // 70003E1C
	0x0F1246C0,    // 70003E1E
	0x0F12C000,    // 70003E20
	0x0F12E59F,    // 70003E22
	0x0F12FF1C,    // 70003E24
	0x0F12E12F,    // 70003E26
	0x0F12EEDF,    // 70003E28
	0x0F120000,    // 70003E2A
	0x0F124778,    // 70003E2C
	0x0F1246C0,    // 70003E2E
	0x0F12C000,    // 70003E30
	0x0F12E59F,    // 70003E32
	0x0F12FF1C,    // 70003E34
	0x0F12E12F,    // 70003E36
	0x0F12AEF1,    // 70003E38
	0x0F120000,    // 70003E3A
	0x0F124778,    // 70003E3C
	0x0F1246C0,    // 70003E3E
	0x0F12C000,    // 70003E40
	0x0F12E59F,    // 70003E42
	0x0F12FF1C,    // 70003E44
	0x0F12E12F,    // 70003E46
	0x0F1202EB,    // 70003E48
	0x0F120001,    // 70003E4A
	0x0F124778,    // 70003E4C
	0x0F1246C0,    // 70003E4E
	0x0F12C000,    // 70003E50
	0x0F12E59F,    // 70003E52
	0x0F12FF1C,    // 70003E54
	0x0F12E12F,    // 70003E56
	0x0F12FD21,    // 70003E58
	0x0F120000,    // 70003E5A
	0x0F124778,    // 70003E5C
	0x0F1246C0,    // 70003E5E
	0x0F12C000,    // 70003E60
	0x0F12E59F,    // 70003E62
	0x0F12FF1C,    // 70003E64
	0x0F12E12F,    // 70003E66
	0x0F12FDAF,    // 70003E68
	0x0F120000,    // 70003E6A
	0x0F124778,    // 70003E6C
	0x0F1246C0,    // 70003E6E
	0x0F12C000,    // 70003E70
	0x0F12E59F,    // 70003E72
	0x0F12FF1C,    // 70003E74
	0x0F12E12F,    // 70003E76
	0x0F125027,    // 70003E78
	0x0F120000,    // 70003E7A
	0x0F124778,    // 70003E7C
	0x0F1246C0,    // 70003E7E
	0x0F12C000,    // 70003E80
	0x0F12E59F,    // 70003E82
	0x0F12FF1C,    // 70003E84
	0x0F12E12F,    // 70003E86
	0x0F1204C9,    // 70003E88
	0x0F120000,    // 70003E8A
	0x0F124778,    // 70003E8C
	0x0F1246C0,    // 70003E8E
	0x0F12C000,    // 70003E90
	0x0F12E59F,    // 70003E92
	0x0F12FF1C,    // 70003E94
	0x0F12E12F,    // 70003E96
	0x0F1239DF,    // 70003E98
	0x0F120000,    // 70003E9A
	0x0F124778,    // 70003E9C
	0x0F1246C0,    // 70003E9E
	0x0F12C000,    // 70003EA0
	0x0F12E59F,    // 70003EA2
	0x0F12FF1C,    // 70003EA4
	0x0F12E12F,    // 70003EA6
	0x0F126177,    // 70003EA8
	0x0F120000,    // 70003EAA
	0x0F124778,    // 70003EAC
	0x0F1246C0,    // 70003EAE
	0x0F12C000,    // 70003EB0
	0x0F12E59F,    // 70003EB2
	0x0F12FF1C,    // 70003EB4
	0x0F12E12F,    // 70003EB6
	0x0F12424F,    // 70003EB8
	0x0F120000,    // 70003EBA
	0x0F124778,    // 70003EBC
	0x0F1246C0,    // 70003EBE
	0x0F12C000,    // 70003EC0
	0x0F12E59F,    // 70003EC2
	0x0F12FF1C,    // 70003EC4
	0x0F12E12F,    // 70003EC6
	0x0F123F0D,    // 70003EC8
	0x0F120000,    // 70003ECA
	0x0F124778,    // 70003ECC
	0x0F1246C0,    // 70003ECE
	0x0F12C000,    // 70003ED0
	0x0F12E59F,    // 70003ED2
	0x0F12FF1C,    // 70003ED4
	0x0F12E12F,    // 70003ED6
	0x0F1202B9,    // 70003ED8
	0x0F120001,    // 70003EDA
	// End of Patch Data(Last : 70003EDAh)
	// Total Size 2480 (09B0)
	// Addr : 352C , Size : 2478(9AEh)
	0x10000001,

	0x0028D000,
	0x002A0070,
	0x0F120007,         // clks_src_gf_force_enable

	//	TNP_USER_MBCV_CONTROL
	//	TNP_FLS_SEC_CONFIG
	//	TNP_SINGLE_FRAME_CAPTURE
	//	TNP_CAPTURE_DONE_INFO
	//	TNP_5CC_SENSOR_TUNE
	//	TNP_GAS_ALPHA_OTP
	//	TNP_FR_ACCURATE_DYNAMIC
	//	TNP_ADLC_TUNE

	//MBCV Control
	0x00287000,
	0x002A04B4,
	0x0F120064,

	// AFIT by Normalized Brightness Tuning parameter
	0x00287000,
	0x002A3302,
	0x0F120000, // on/off AFIT by NB option

	0x0F120005, // NormBR[0]
	0x0F120019, // NormBR[1]
	0x0F120050, // NormBR[2]
	0x0F120300, // NormBR[3]
	0x0F120375, // NormBR[4]

	// Flash
	0x002A3F82,
	0x0F120000,	// TNP_Regs_PreflashStart
	0x0F120000,	// TNP_Regs_PreflashEnd
	0x0F120260,	// TNP_Regs_PreWP_r
	0x0F120240, // TNP_Regs_PreWP_b

	0x002A3F98,	// BR Tuning
	0x0F120100,	// TNP_Regs_BrRatioIn_0_
	0x0F120150,
	0x0F120200,
	0x0F120300,
	0x0F120400,

	0x0F120100,	// TNP_Regs_BrRatioOut_0_
	0x0F1200A0,
	0x0F120080,
	0x0F120040,
	0x0F120020,

	0x0F120030,	// WP Tuning
	0x0F120040,	// TNP_Regs_WPThresTbl_0_
	0x0F120048,
	0x0F120050,
	0x0F120060,

	0x0F120100,	// TNP_Regs_WPWeightTbl_0_
	0x0F1200C0,
	0x0F120080,
	0x0F12000A,
	0x0F120000,

	0x0F120120,	// T_BR tune
	0x0F120150,	// TNP_Regs_FlBRIn_0_
	0x0F120200,

	0x0F12003C,	//TNP_Regs_FlBRInOut_0_
	0x0F12003B,
	0x0F12002E,

	0x002A0430,	//REG_TC_FLS_Mode
	0x0F120002,
	0x002A3F80,	//TNP_Regs_FastFlashAlg
	0x0F120000,

	0x002A165E,
	0x0F120235,           //0244 0258 AWB R point          //0258 0245 0258
	0x0F12024A,           //024D 0220 AWB B point          //0220 0245 0245


	/* Analog & APS settings


	This register is for FACTORY ONLY. If you change it without prior notification.
	YOU are RESPONSIBLE for the FAILURE that will happen in the future.*/


	//========================================================================================
	// 5CC EVT0 analog register setting
	// '10.07.14. Initial Draft
	// '10.07.24. sE404=0000 -> 1FC0 (Depedestal 0 -> -64d)
	// '10.08.16. sF410=0001 -> 0000 (for SHBN)
	// '10.08.25. sF438=0020 -> 0002 (VTGSL=2.96V) by APS
	//            sF43A=0020 -> 0001 (VRG=2.83V) by APS
	// '10.09.28. sF402=1F02 -> 3F02 ([13]: pixel bias powerdown according to HADR) for Darkshading
	//		    sF416=0000 -> 0001 (AAC_EN enable) for Darkshading
	//========================================================================================
	//============================= Analog & APS Control =====================================
	0x0028D000,
	0x002AF2AC,
	0x0F120100, // analog gain; 0200 x16 0100 x8 0080 x4 0040 x2 0020 x1
	0x002AF400,
	0x0F12001D, // ldb_en[4] ld_en[3] clp_en[2](N/A) smp_en[1] dshut_en[0]
	0x0F123F02, // cds_test[15:0]; refer to the ATOP_TEST_INFORMATION.

	0x002AF40A,
	0x0F120054, // adc_sat[7:0]=84d (500mV)
	0x0F120002, // ms[2:0]; 2h@Normal 2h@PLA 1h@CNT.AVG
	0x0F120008, // rmp_option[7:0]; [3]SL_Low_PWR_SAVE On
	0x0F120000, // msoff_en; No MS if gain gain is lower than x2
	0x0F1200A4, // rmp_init[7:0]

	0x002AF416,
	0x0F120001, // dbs_option[11:4] dbs_mode[3:2] dbs_bist_en[1] aac_en[0]

	0x002AF41E,
	0x0F120065, // comp2_bias[7:4] comp1_bias[3:0]

	0x002AF422,
	0x0F120005, // pix_bias[3:0]

	0x002AF426,
	0x0F1200D4, // clp_lvl[7:0]

	0x002AF42A,
	0x0F120001, // ref_option[7:0]; [4]OB_PIX monit en [3]Clamp monit en [2]Monit amp en [1]Clamp power-down [0]CDS power-down during SL=low

	0x002AF42E,
	0x0F120406, // fb_lv[11:10] pd_fblv[9] capa_ctrl_en[8] pd_inrush_ctrl[7] pd_reg_ntg[6] pd_reg_tgsl[5] pd_reg_rg[4] pd_reg_pix[3] pd_ncp_rosc[2] pd_cp_rosc[1] pd_cp[0]

	0x002AF434,
	0x0F120003, // dbr_clk_sel[1:0]; PLL_mode=3h ROSC_mode=0h
	0x0F120004, // reg_tune_pix[7:0]
	0x0F120002, // reg_tune_tgsl[7:0] (2.96V)
	0x0F120001, // reg_tune_rg[7:0] (2.83V)
	0x0F120004, // reg_tune_ntg[7:0]

	0x002AF446,
	0x0F120000, // blst_en_cintr[15:0]

	0x002AF466,
	0x0F120000, // srx_en[0]

	0x002A0054,
	0x0F120028, // pll_pd[10](0:enable 1:disable) div_clk_en[0](0:enable 1:disable)
	0x0F128888, // div_dbr[7:4]

	0x002AF132,
	0x0F120206, // tgr_frame_decription 4
	0x002AF152,
	0x0F120206, // tgr_frame_decription 7
	0x002AF1A2,
	0x0F120200, // tgr_frame_params_descriptor_3
	0x002AF1B2,
	0x0F120202, // tgr_frame_params_descriptor_6
	//===========================================================================================

	//============================= Line-ADLC Tuning ============================================
	0x002AE412,
	0x0F120008, // adlc_tune_offset_gr[7:0]
	0x0F120008, // adlc_tune_offset_r[7:0]
	0x0F120010, // adlc_tune_offset_b[7:0]
	0x0F120010, // adlc_tune_offset_gb[7:0]
	0x002AE42E,
	0x0F120004, // adlc_qec[2:0]
	//===========================================================================================

	//===================================================================
	// AWB white locus setting - Have to be written after TnP
	//===================================================================
	0x00287000,
	0x002A1014,
	0x0F120132, //0138//awbb_IntcR
	0x0F12010A, //011C//awbb_IntcB

	//===================================================================
	// AF
	//===================================================================
	//1. AF interface setting
	0x002A01A2,
	0x0F120003,          //REG_TC_IPRM_CM_Init_AfModeType        // VCM_I2C actuator
	0x0F120000,          //REG_TC_IPRM_CM_Init_PwmConfig1       // No PWM
	0x0F120000,          //REG_TC_IPRM_CM_Init_PwmConfig2
	0x0F120041,          //REG_TC_IPRM_CM_Init_GpioConfig1        // Use GPIO_4 for enable port
	0x0F120000,          //REG_TC_IPRM_CM_Init_GpioConfig2
	0x0F122A0C,          //REG_TC_IPRM_CM_Init_Mi2cBits        // Use GPIO_5 for SCL GPIO_6 for SDA
	0x0F120190,          //REG_TC_IPRM_CM_Init_Mi2cRateKhz        // MI2C Speed : 400KHz

	//2. AF window setting
	0x002A022C,
	0x0F120100, //REG_TC_AF_FstWinStartX
	0x0F1200E3, //REG_TC_AF_FstWinStartY
	0x0F120200, //REG_TC_AF_FstWinSizeX
	0x0F120238, //REG_TC_AF_FstWinSizeY
	0x0F12018C, //REG_TC_AF_ScndWinStartX
	0x0F120166, //REG_TC_AF_ScndWinStartY
	0x0F1200E6, //REG_TC_AF_ScndWinSizeX
	0x0F120132, //REG_TC_AF_ScndWinSizeY
	0x0F120001, //REG_TC_AF_WinSizesUpdated

	//3. AF Fine Search Settings
	0x002A063A,
	0x0F1200C0,          //#skl_af_StatOvlpExpFactor
	0x002A064A,
	0x0F120000, //0000          //#skl_af_bAfStatOff
	0x002A1488,
	0x0F120000,          //#af_search_usAeStable
	0x002A1494,
	0x0F121002, //#af_search_usSingleAfFlags 1000- fine search disable 1002- fine search on
	0x002A149E,
	0x0F120003,          //#af_search_usFinePeakCount
	0x0F120000,          //#af_search_usFineMaxScale
	0x002A142C,
	0x0F120602, //#af_pos_usFineStepNumSize
	0x002A14A2,
	0x0F120000,          //#af_search_usCapturePolicy 0000 : Shutter_Priority_Current

	//4.  AF Peak Threshold Setting
	0x002A1498,
	0x0F120003, //#af_search_usMinPeakSamples
	0x002A148A,
	0x0F1200CC, //#af_search_usPeakThr  for 80%
	0x0F1200A0,          //#af_search_usPeakThrLow

	//5.  AF Default Position
	0x002A1420,
	0x0F120000, //#af_pos_usHomePos
	0x0F12952F, //#af_pos_usLowConfPos

	//6. AF statistics
	0x002A14B4,
	0x0F120280,          //#af_search_usConfThr_4_  LowEdgeBoth GRAD
	0x002A14C0,
	0x0F1203A0,          //#af_search_usConfThr_10_ LowLight HPF
	0x0F120320,          //#af_search_usConfThr_11_
	0x002A14F4,
	0x0F120030,          //#af_stat_usMinStatVal
	0x002A1514,
	0x0F120060,          //#af_scene_usSceneLowNormBrThr
	// AF Scene Settings
	0x002A151E,
	0x0F120003,          //#af_scene_usSaturatedScene

	//7. AF Lens Position Table Settings
	0x002A1434,
	0x0F120010,           //#af_pos_usTableLastInd 10h + 1h = 17 Steps

	0x0F120030,           //#af_pos_usTable_0_  48
	0x0F120033,           //#af_pos_usTable_1_  51
	0x0F120036,           //#af_pos_usTable_2_  54
	0x0F120039,           //#af_pos_usTable_3_  57
	0x0F12003D,           //#af_pos_usTable_4_  61
	0x0F120041,           //#af_pos_usTable_5_  65
	0x0F120045,           //#af_pos_usTable_6_  69
	0x0F120049,           //#af_pos_usTable_7_  73
	0x0F12004E,           //#af_pos_usTable_8_  78
	0x0F120053,           //#af_pos_usTable_9_  83
	0x0F120059,           //#af_pos_usTable_10_ 89
	0x0F120060,           //#af_pos_usTable_11_ 104
	0x0F120068,           //#af_pos_usTable_12_ 109
	0x0F120072,           //#af_pos_usTable_13_ 114
	0x0F12007D,           //#af_pos_usTable_14_ 125
	0x0F120089,           //#af_pos_usTable_15_ 137
	0x0F120096,           //#af_pos_usTable_16_ 150

	//8. VCM AF driver with PWM/I2C
	0x002A1558,
	0x0F128000,          //#afd_usParam[0]  I2C power down command
	0x0F120006,          //#afd_usParam[1]  Position Right Shift
	0x0F123FF0,          //#afd_usParam[2]  I2C Data Mask
	0x0F1203E8,          //#afd_usParam[3]  PWM Period
	0x0F120000,          //#afd_usParam[4]  PWM Divider
	0x0F120050,          //#afd_usParam[5]  SlowMotion Delay    reduce lens collision noise.
	0x0F120008,          //#afd_usParam[6]  SlowMotion Threshold
	0x0F120008,          //#afd_usParam[7]  Signal Shaping
	0x0F120040,          //#afd_usParam[8]  Signal Shaping level
	0x0F120080,          //#afd_usParam[9]  Signal Shaping level
	0x0F1200C0,          //#afd_usParam[10] Signal Shaping level
	0x0F1200E0,          //#afd_usParam[11] Signal Shaping level

	0x002A0224,
	0x0F120003, //REG_TC_AF_AfCmd//Initialize AF subsystem (AF driver AF algorithm)

	//===================================================================
	// Flash setting
	//===================================================================
	0x002A018C,
	0x0F120001, //REG_TC_IPRM_AuxConfig// bit[0] : Flash is in use bit[1] : Mechanical shutter is in use          // 0 : do not use 1 : use
	0x0F120003, //REG_TC_IPRM_AuxPolarity// bit[0] : Flash polarity (1 is active high) bit[1] : Mechanical shutter polarity (1 is active high)
	0x0F120003, //REG_TC_IPRM_AuxGpios//1-4 : Flash GPIO number If GPIO number is overaped with AF GPIO F/W could be stop.

	//===================================================================
	// 1-H timing setting
	//===================================================================
	0x002A1686,
	0x0F12005C, //senHal_uAddColsBin
	0x0F12005C, //senHal_uAddColsNoBin
	0x0F12085C, //senHal_uMinColsHorBin
	0x0F12005C, //senHal_uMinColsNoHorBin
	0x0F12025A, //senHal_uMinColsAddAnalogBin

	//===================================================================
	// Forbidden area setting
	//===================================================================
	0x002A1844,
	0x0F120000,                   //senHal_bSRX                  //SRX off

	0x002A1680,
	0x0F120002,                   //senHal_NExpLinesCheckFine                  //0004                  //extend Forbidden area line

	0x002A0ED2,
	0x0F120FA0,	                  //setot_uOnlineClocksDiv40

	//===================================================================
	// Preview subsampling mode
	//===================================================================
	0x002A18F8,
	0x0F120001,                   //senHal_bAACActiveWait2Start
	0x002A18F6,
	0x0F120001,                   //senHal_bAlwaysAAC
	0x002A182C,
	0x0F120001,                   //senHal_bSenAAC
	0x002A0EE4,
	0x0F120001,                   //setot_bUseDigitalHbin
	0x002A1674,
	0x0F120002,                   //senHal_SenBinFactor                  // 2:2x2 4:4x4
	0x0F120002,                   //senHal_SamplingType                  // 0:Full 1:digital 2:PLA 3:CA
	0x0F120000,                   //senHal_SamplingMode                  // 0:2x2	1:4x4

	//===================================================================
	// PLL setting for Max frequency (EVT0.1) 2010.08.05 - Do not remove
	//===================================================================
	0x002A19AE,
	0x0F12EA60,                   //pll_uMaxSysFreqKhz
	0x0F127530,                   //pll_uMaxPVIFreq4KH
	0x002A19C2,
	0x0F127530,                   //pll_uMaxMIPIFreq4KH
	0x002A0244,
	0x0F127530,                   //REG_0TC_PCFG_usMaxOut4KHzRate
	0x002A0336,
	0x0F127530,                   //REG_0TC_CCFG_usMaxOut4KHzRate

	//===================================================================
	// Init Parameters
	//===================================================================
	//MCLK
	0x002A0188,
	0x0F125DC0,                   //REG_TC_IPRM_InClockLSBs
	0x0F120000,                   //REG_TC_IPRM_InClockMSBs
	0x002A01B2,
	0x0F120001,                   //REG_TC_IPRM_UseNPviClocks
	0x0F120002,                   //REG_TC_IPRM_UseNMipiClocks
	0x002A01B8,
	0x0F120001,                   //REG_TC_IPRM_bBlockInternalPllCalc  //1:pll bypass


	//SCLK & PCLK                    // clock set 0
	0x0F1238A4, //38A4 //36B0 //34BC //32C8	//REG_TC_IPRM_OpClk4KHz_0 //52Mhz
	0x0F1254F0, //4E20 //3A98 //7148 //4B32	//34BC //REG_TC_IPRM_MinOutRate4KHz_0 //54Mhz
	0x0F1254F8, //57E4 //61A8 //7148 //4B32	//34BC //REG_TC_IPRM_MaxOutRate4KHz_0 //54Mhz

	//SCLK & PCLK                    // clock set 1
	0x0F1238A4, //38A4 //36B0 //34BC //32C8	//REG_TC_IPRM_OpClk4KHz_0 //52Mhz
	0x0F1254F0, //4E20 //3A98 //7148 //4B32	//34BC //REG_TC_IPRM_MinOutRate4KHz_0//54Mhz
	0x0F1254F8, //57E4 //61A8 //7148 //4B32	//34BC //REG_TC_IPRM_MaxOutRate4KHz_0//54Mhz

	//SCLK & PCLK                    // clock set 2
	0x0F1238A4, //38A4 //36B0 //34BC //32C8 //REG_TC_IPRM_OpClk4KHz_0 //52Mhz
	0x0F1254F0, //4E20 //3A98 //7148 //4B32 //34BC //REG_TC_IPRM_MinOutRate4KHz_0 //54Mhz
	0x0F1254F8, //57E4 //61A8 //7148 //4B32 //34BC //REG_TC_IPRM_MaxOutRate4KHz_0 //54Mhz

	0x002A1B78,
	0x0F1238A4,                           //  REGM_gSensorClocks_0__PLL_usClkFreqDiv4
	0x0F120074,                           //  REGM_gSensorClocks_0__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_0__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_0__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_0__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_0__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_SysDiv
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_PviDiv
	0x0F120006,                           //  REGM_gSensorClocks_0__PLL_PllHW_DblDiv
	0x0F12000C,                           //  REGM_gSensorClocks_0__PLL_PllHW_OIF_dphy_val
	0x0F125DC0,                           //  REGM_gSensorClocks_0__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_0__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_0__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_0__usOIFDenum

	0x002A1B9C,
	0x0F1238A4,                           //  REGM_gSensorClocks_1__PLL_usClkFreqDiv4
	0x0F120074,                           //  REGM_gSensorClocks_1__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_1__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_1__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_1__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_1__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_SysDiv
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_PviDiv
	0x0F120006,                           //  REGM_gSensorClocks_1__PLL_PllHW_DblDiv
	0x0F12000C,                           //  REGM_gSensorClocks_1__PLL_PllHW_OIF_dphy_val
	0x0F125DC0,                           //  REGM_gSensorClocks_1__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_1__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_1__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_1__usOIFDenum

	0x002A1BC0,
	0x0F1238A4,                           //  REGM_gSensorClocks_2__PLL_usClkFreqDiv4
	0x0F120074,                           //  REGM_gSensorClocks_2__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_2__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_2__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_2__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_2__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_SysDiv
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_PviDiv
	0x0F120006,                           //  REGM_gSensorClocks_2__PLL_PllHW_DblDiv
	0x0F12000C,                           //  REGM_gSensorClocks_2__PLL_PllHW_OIF_dphy_val
	0x0F125DC0,                           //  REGM_gSensorClocks_2__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_2__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_2__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_2__usOIFDenum


	0x002A01CC,
	0x0F120001,                   //REG_TC_IPRM_InitParamsUpdated

	0xFFFF000A,     //p10

	//thumbnail set
	0x002A0428,
	0x0F120001,	//REG_TC_THUMB_Thumb_bActive	//Thumbnail Enable
	0x0F120140,	//REG_TC_THUMB_Thumb_uWidth		//Thumbnail Width 320
	0x0F1200F0,	//REG_TC_THUMB_Thumb_uHeight	//Thumbnail Height 240
	0x0F120005,	//REG_TC_THUMB_Thumb_Format		//Thumbnail Output Format 5:YUV



	//===================================================================
	// Input Width & Height
	//===================================================================
	0x002A01F6,
	0x0F120800, //REG_TC_GP_PrevReqInputWidth	//Sensor Crop Width	2048
	0x0F120600, //REG_TC_GP_PrevReqInputHeight//Sensor Crop Height 1536
	0x0F120000, //REG_TC_GP_PrevInputWidthOfs	//Sensor HOffset 0
	0x0F120000, //REG_TC_GP_PrevInputHeightOfs//Sensor VOffset 0
	0x0F120800, //REG_TC_GP_CapReqInputWidth	//Sensor Crop Width	2048
	0x0F120600, //REG_TC_GP_CapReqInputHeight	//Sensor Crop Height 1536
	0x0F120000, //REG_TC_GP_CapInputWidthOfs	//Sensor HOffset 0
	0x0F120000, //REG_TC_GP_CapInputHeightOfs	//Sensor VOffset 0

	0x002A0216,
	0x0F120001, //REG_TC_GP_bUseReqInputInPre
	0x0F120001, //REG_TC_GP_bUseReqInputInCap

	0x002A043C,
	0x0F120800, //REG_TC_PZOOM_ZoomInputWidth
	0x0F120600, //REG_TC_PZOOM_ZoomInputHeight
	0x0F120000, //REG_TC_PZOOM_ZoomInputWidthOfs
	0x0F120000, //REG_TC_PZOOM_ZoomInputHeightOfs

	//===================================================================
	// Preview 0 640 480 system 52M PCLK 87M
	//===================================================================
	0x002A023E,
	0x0F120400, //REG_0TC_PCFG_usWidth
	0x0F120300, //REG_0TC_PCFG_usHeight
	0x0F120005, //REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate

	0x002A024C,
	0x0F120012, //REG_0TC_PCFG_PVIMask    => cmk 2010.10.29 s0042 => s0052 Invert Y C order
	0x0F120010, //REG_0TC_PCFG_OIFMask

	0x002A0254,
	0x0F120001, //REG_0TC_PCFG_uClockInd
	0x0F120000, //REG_0TC_PCFG_usFrTimeType
	0x0F120001, //REG_0TC_PCFG_FrRateQualityType
	0x0F1203E8, //REG_0TC_PCFG_usMaxFrTimeMsecMult10//max frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS
	0x0F12014E, //REG_0TC_PCFG_usMinFrTimeMsecMult10//min frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS

	0x0F120000, //REG_0TC_PCFG_bSmearOutput
	0x0F120000, //REG_0TC_PCFG_sSaturation
	0x0F120000, //REG_0TC_PCFG_sSharpBlur
	0x0F120000, //REG_0TC_PCFG_sColorTemp
	0x0F120000, //REG_0TC_PCFG_uDeviceGammaIndex
#if 1 /* [P4W] fix rotation to 180 */
	0x0F120003, //REG_0TC_PCFG_uPrevMirror
	0x0F120003, //REG_0TC_PCFG_uCaptureMirror
#endif
	0x0F120000, //REG_0TC_PCFG_uRotation


	//===================================================================
	// Capture 0 2048x1536 system 52M PCLK 87M
	//===================================================================

	0x002A032E,
	0x0F120000,                   //REG_0TC_CCFG_uCaptureMode

	0x0F120800,                   //REG_0TC_CCFG_usWidth
	0x0F120600,                   //REG_0TC_CCFG_usHeight
	0x0F120009,                   //REG_0TC_CCFG_Format                              //PCAM 5:YUV   9:JPEG
	0x0F1254F6,	                  //REG_0TC_CCFG_usMaxOut4KHzRate
	0x0F1254F6,	                  //REG_0TC_CCFG_usMinOut4KHzRate

	0x002A033E,
#if 0 /* UYVY -> YUYV */
	0x0F120010,                   //REG_0TC_CCFG_PVIMask        => cmk 2010.10.29 s0042 => s0052 Invert Y C order
#else
	0x0F120000,                   //REG_0TC_CCFG_PVIMask
#endif
	0x0F120050,                   //REG_0TC_CCFG_OIFMask
	0x0F1203C0,                   //REG_0TC_CCFG_usJpegPacketSize

	0x002A0346,
	0x0F120001,                   //REG_0TC_CCFG_uClockInd
	0x0F120002,                   //REG_0TC_CCFG_usFrTimeType
	0x0F120002,                   //REG_0TC_CCFG_FrRateQualityType
	0x0F120535,                   //REG_0TC_CCFG_usMaxFrTimeMsecMult10
	0x0F12029A,                   //REG_0TC_CCFG_usMinFrTimeMsecMult10
	0x0F120000,                   //REG_0TC_CCFG_bSmearOutput
	0x0F120000,                   //REG_0TC_CCFG_sSaturation
	0x0F120000,                   //REG_0TC_CCFG_sSharpBlur
	0x0F120000,                   //REG_0TC_CCFG_sColorTemp
	0x0F120000,                   //REG_0TC_CCFG_uDeviceGammaIndex

	0x002A0426,
	0x0F120055,                   //REG_TC_BRC_usCaptureQuality


	0x002A1E5C,            //Mon_LT_uDefMinFrExpDelta
	0x0F120000,

	//===================================================================
	// Capture 1 640x480 system 52M PCLK 87M
	//===================================================================
	0x002A035A,
	0x0F120000,                   //REG_1TC_CCFG_uCaptureMode

	0x0F120400,                   //REG_1TC_CCFG_usWidth
	0x0F120300,                   //REG_1TC_CCFG_usHeight
	0x0F120009,                   //REG_1TC_CCFG_Format                              //PCAM 5:YUV   9:JPEG
	0x0F1254F6,	                  //REG_1TC_CCFG_usMaxOut4KHzRate
	0x0F1254F6,	                  //REG_1TC_CCFG_usMinOut4KHzRate

	0x002A036A,
#if 0 /* UYVY -> YUYV */
	0x0F120010,                   //REG_1TC_CCFG_PVIMask        => cmk 2010.10.29 s0042 => s0052 Invert Y C order
#else
	0x0F120000,                   //REG_1TC_CCFG_PVIMask
#endif
	0x0F120050,                   //REG_1TC_CCFG_OIFMask
	0x0F1203C0,                   //REG_1TC_CCFG_usJpegPacketSize

	0x002A0372,
	0x0F120001,                   //REG_1TC_CCFG_uClockInd
	0x0F120002,                   //REG_1TC_CCFG_usFrTimeType
	0x0F120002,                   //REG_1TC_CCFG_FrRateQualityType
	0x0F120535,                  //REG_1TC_CCFG_usMaxFrTimeMsecMult10
	0x0F12029A,                   //REG_1TC_CCFG_usMinFrTimeMsecMult10
	0x0F120000,                   //REG_1TC_CCFG_bSmearOutput
	0x0F120000,                   //REG_1TC_CCFG_sSaturation
	0x0F120000,                   //REG_1TC_CCFG_sSharpBlur
	0x0F120000,                   //REG_1TC_CCFG_sColorTemp
	0x0F120000,                   //REG_1TC_CCFG_uDeviceGammaIndex

	0x002A0426,
	0x0F120055,                   //REG_1TC_BRC_usCaptureQuality


	0x002A1E5C,            //Mon_LT_uDefMinFrExpDelta
	0x0F120000,

	//===================================================================
	// AFC
	//===================================================================
	//Auto
	0x002A0F08,
	0x0F120000, //AFC_Default60Hz   01:60hz 00:50Hz
	0x002A04A4,
	0x0F12067F, //REG_TC_DBG_AutoAlgEnBits 065f : Manual AFC on   067f : Manual AFC off

	//===================================================================
	// Shading (AF module)
	//===================================================================
	// TVAR_ash_pGAS_high
	0x002A0D22,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,

	// TVAR_ash_pGAS_low
	0x0F126E49,
	0x0F12FB98,
	0x0F12F348,
	0x0F121BD6,
	0x0F12EBEF,
	0x0F1203D3,
	0x0F12EC8D,
	0x0F12F239,
	0x0F120E64,
	0x0F12F7EA,
	0x0F12FD3B,
	0x0F120A7C,
	0x0F12FC9C,
	0x0F120BD3,
	0x0F12F2E5,
	0x0F120619,
	0x0F120772,
	0x0F12F0B0,
	0x0F12184E,
	0x0F12F95F,
	0x0F120B1A,
	0x0F12FC45,
	0x0F12F716,
	0x0F120DCD,
	0x0F12EF24,
	0x0F120221,
	0x0F12F6BD,
	0x0F1204CB,
	0x0F1200B1,
	0x0F12FEB0,
	0x0F120268,
	0x0F1202C7,
	0x0F12010A,
	0x0F12FF93,
	0x0F12036D,
	0x0F12F859,
	0x0F1281D0,
	0x0F12FA32,
	0x0F12EFDB,
	0x0F12234D,
	0x0F12E799,
	0x0F120337,
	0x0F12EB05,
	0x0F12E8F9,
	0x0F12152E,
	0x0F12F0D5,
	0x0F120842,
	0x0F12043A,
	0x0F12F461,
	0x0F120E58,
	0x0F12F658,
	0x0F12075D,
	0x0F12F78D,
	0x0F12FDE9,
	0x0F12277A,
	0x0F12FFDE,
	0x0F12FD3B,
	0x0F12FE50,
	0x0F120AD1,
	0x0F12FE2C,
	0x0F12E90D,
	0x0F12F7B0,
	0x0F1205DB,
	0x0F1202CD,
	0x0F12F4F1,
	0x0F1202A8,
	0x0F12FDDC,
	0x0F120B59,
	0x0F12F74E,
	0x0F1203D5,
	0x0F12FF4F,
	0x0F1200F7,
	0x0F126A44,
	0x0F12FAD6,
	0x0F12F261,
	0x0F121F28,
	0x0F12E691,
	0x0F1207D2,
	0x0F12EE85,
	0x0F12F426,
	0x0F120F26,
	0x0F12F34B,
	0x0F120036,
	0x0F120C0F,
	0x0F12FDA9,
	0x0F1209EA,
	0x0F12F27A,
	0x0F120CD5,
	0x0F1201E1,
	0x0F12ED41,
	0x0F121DB5,
	0x0F12FD26,
	0x0F1203F7,
	0x0F12F7BB,
	0x0F12FE81,
	0x0F1212D3,
	0x0F12E061,
	0x0F12F81C,
	0x0F1207B1,
	0x0F120408,
	0x0F12F860,
	0x0F12FC9A,
	0x0F120DDE,
	0x0F120C9C,
	0x0F12F2A4,
	0x0F1202EB,
	0x0F12099B,
	0x0F12F5A6,
	0x0F127243,
	0x0F12F74D,
	0x0F12F74B,
	0x0F121800,
	0x0F12EF22,
	0x0F120263,
	0x0F12EBE7,
	0x0F12F5A4,
	0x0F1209D3,
	0x0F12FAB8,
	0x0F12FDFF,
	0x0F12086B,
	0x0F120338,
	0x0F120514,
	0x0F12F840,
	0x0F120768,
	0x0F12FE55,
	0x0F12F884,
	0x0F121488,
	0x0F12FFCD,
	0x0F12035B,
	0x0F12FA4E,
	0x0F1201DB,
	0x0F1206D6,
	0x0F12EE19,
	0x0F12FEA3,
	0x0F12FE8C,
	0x0F1203A3,
	0x0F12FDDB,
	0x0F12FD9B,
	0x0F12035E,
	0x0F1203F2,
	0x0F12FCBD,
	0x0F120300,
	0x0F12FF2E,
	0x0F12FE03,

	0x002A04A8,
	0x0F120001, //REG_TC_DBG_ReInitCmd

	//===================================================================
	// Shading - Alpha
	//===================================================================
	0x002A07E8,
	0x0F1200BC, //TVAR_ash_AwbAshCord_0_//HOR
	0x0F1200ED, //TVAR_ash_AwbAshCord_1_//INCA
	0x0F120101, //TVAR_ash_AwbAshCord_2_//WW
	0x0F12012D, //TVAR_ash_AwbAshCord_3_//CW
	0x0F120166, //TVAR_ash_AwbAshCord_4_//D50
	0x0F120184, //TVAR_ash_AwbAshCord_5_//D65
	0x0F1201A0, //TVAR_ash_AwbAshCord_6_//D75
	0x002A07FE,
	0x0F123200, //TVAR_ash_GASAlpha_0__0_
	0x0F124000, //TVAR_ash_GASAlpha_0__1_
	0x0F124000, //TVAR_ash_GASAlpha_0__2_
	0x0F123C00, //TVAR_ash_GASAlpha_0__3_
	0x0F123200, //TVAR_ash_GASAlpha_1__0_
	0x0F124000, //TVAR_ash_GASAlpha_1__1_
	0x0F124000, //TVAR_ash_GASAlpha_1__2_
	0x0F123C00, //TVAR_ash_GASAlpha_1__3_
	0x0F123200, //TVAR_ash_GASAlpha_2__0_
	0x0F124000, //TVAR_ash_GASAlpha_2__1_
	0x0F124000, //TVAR_ash_GASAlpha_2__2_
	0x0F123C00, //TVAR_ash_GASAlpha_2__3_
	0x0F123200, //TVAR_ash_GASAlpha_3__0_
	0x0F124000, //TVAR_ash_GASAlpha_3__1_
	0x0F124000, //TVAR_ash_GASAlpha_3__2_
	0x0F123C00, //TVAR_ash_GASAlpha_3__3_
	0x0F123200, //TVAR_ash_GASAlpha_4__0_
	0x0F124000, //TVAR_ash_GASAlpha_4__1_
	0x0F124000, //TVAR_ash_GASAlpha_4__2_
	0x0F123C00, //TVAR_ash_GASAlpha_4__3_
	0x0F123200, //TVAR_ash_GASAlpha_5__0_
	0x0F124000, //TVAR_ash_GASAlpha_5__1_
	0x0F124000, //TVAR_ash_GASAlpha_5__2_
	0x0F123C00, //TVAR_ash_GASAlpha_5__3_
	0x0F123F00,	//TVAR_ash_GASAlpha_6__0_
	0x0F124000, //TVAR_ash_GASAlpha_6__1_
	0x0F124000, //TVAR_ash_GASAlpha_6__2_
	0x0F124000, //TVAR_ash_GASAlpha_6__3_

	0x002A0836,
	0x0F123F00,	//TVAR_ash_GASOutdoorAlpha_0_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_1_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_2_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_3_

	//===================================================================
	// Gamma
	//===================================================================
	//	param_start	SARR_usGammaLutRGBIndoor
	0x002A0660,
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[0][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[0][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[0][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[0][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[0][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[0][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[0][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[0][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[0][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[0][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[0][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[0][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[0][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[0][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[0][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[0][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[0][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[0][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[0][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[0][19]
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[1][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[1][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[1][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[1][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[1][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[1][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[1][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[1][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[1][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[1][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[1][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[1][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[1][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[1][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[1][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[1][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[1][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[1][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[1][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[1][19]
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[2][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[2][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[2][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[2][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[2][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[2][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[2][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[2][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[2][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[2][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[2][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[2][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[2][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[2][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[2][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[2][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[2][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[2][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[2][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[2][19]

	//s002A06D8
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[0][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[0][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[0][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[0][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[0][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[0][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[0][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[0][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[0][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[0][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[0][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[0][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[0][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[0][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[0][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[0][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[0][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[0][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[0][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[0][19]
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[1][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[1][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[1][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[1][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[1][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[1][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[1][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[1][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[1][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[1][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[1][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[1][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[1][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[1][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[1][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[1][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[1][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[1][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[1][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[1][19]
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[2][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[2][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[2][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[2][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[2][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[2][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[2][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[2][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[2][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[2][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[2][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[2][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[2][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[2][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[2][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[2][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[2][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[2][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[2][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[2][19]

	//===================================================================
	// AE - shutter
	//===================================================================
	//****************************************/
	// AE 2009 03 08 - based on TN
	//****************************************/
	//============================================================
	// Frame rate setting
	//============================================================
	// How to set
	// 1. Exposure value
	// dec2hex((1 / (frame rate you want(ms))) * 100d * 5d)
	//
	//
	// 2. Analog Digital gain
	// dec2hex((Analog gain you want) * 256d)
	//              Ex1) Simple Caculation for x3.25?:   3.25x256 = 832[dec] = 0340[hex]
	//============================================================
	//MBR
	0x002A01DE,
	0x0F120000, //REG_TC_bUseMBR//MBR off
	//MBR off is needed to prevent a shorter integration time when the scene has blurring in Night shot

	//AE_Target
	0x002A1308,
	0x0F12003E, //TVAR_ae_BrAve
	0x002A130E,
	0x0F12000F, //ae_StatMode
	//ae_StatMode bit[3] BLC has to be bypassed to prevent AE weight change especially backlight scene

	//AE_state
	0x002A04EE,
	0x0F12010E, //#lt_uLimitHigh
	0x0F1200F5, //#lt_uLimitLow

	//For 60Hz
	0x002A0504,
	0x0F123415, //#lt_uMaxExp1
	0x002A0508,
	0x0F12681F, //#lt_uMaxExp2
	0x002A050C,
	0x0F128227, //#lt_uMaxExp3
	0x002A0510,
	0x0F12C350, //#lt_uMaxExp4

	0x002A0514,
	0x0F123415, //#lt_uCapMaxExp1
	0x002A0518,
	0x0F12681F, //#lt_uCapMaxExp2
	0x002A051C,
	0x0F128227, //#lt_uCapMaxExp3
	0x002A0520,
	0x0F12C350, //#lt_uCapMaxExp4

	0x002A0524,
	0x0F1201E0, //#lt_uMaxAnGain1
	0x0F1201E0, //#lt_uMaxAnGain2
	0x0F120300, //#lt_uMaxAnGain3
	0x0F120840, //#lt_uMaxAnGain4

	0x0F120100, //#lt_uMaxDigGain
	0x0F128000, //#lt_uMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	0x0F1201E0, //#lt_uCapMaxAnGain1
	0x0F1201E0, //#lt_uCapMaxAnGain2
	0x0F120300, //#lt_uCapMaxAnGain3
	0x0F120710, //#lt_uCapMaxAnGain4

	0x0F120100, //#lt_uCapMaxDigGain
	0x0F128000, //#lt_uCapMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	//===================================================================
	//AE - Weights
	//===================================================================
	0x002A1316,
	0x0F120000, //ae_WeightTbl_16[0]
	0x0F120000, //ae_WeightTbl_16[1]
	0x0F120000, //ae_WeightTbl_16[2]
	0x0F120000, //ae_WeightTbl_16[3]
	0x0F120101, //ae_WeightTbl_16[4]
	0x0F120101, //ae_WeightTbl_16[5]
	0x0F120101, //ae_WeightTbl_16[6]
	0x0F120101, //ae_WeightTbl_16[7]
	0x0F120101, //ae_WeightTbl_16[8]
	0x0F120201, //ae_WeightTbl_16[9]
	0x0F120102, //ae_WeightTbl_16[10]
	0x0F120101, //ae_WeightTbl_16[11]
	0x0F120101, //ae_WeightTbl_16[12]
	0x0F120202, //ae_WeightTbl_16[13]
	0x0F120202, //ae_WeightTbl_16[14]
	0x0F120101, //ae_WeightTbl_16[15]
	0x0F120101, //ae_WeightTbl_16[16]
	0x0F120202, //ae_WeightTbl_16[17]
	0x0F120202, //ae_WeightTbl_16[18]
	0x0F120101, //ae_WeightTbl_16[19]
	0x0F120201, //ae_WeightTbl_16[20]
	0x0F120202, //ae_WeightTbl_16[21]
	0x0F120202, //ae_WeightTbl_16[22]
	0x0F120102, //ae_WeightTbl_16[23]
	0x0F120201, //ae_WeightTbl_16[24]
	0x0F120202, //ae_WeightTbl_16[25]
	0x0F120202, //ae_WeightTbl_16[26]
	0x0F120102, //ae_WeightTbl_16[27]
	0x0F120101, //ae_WeightTbl_16[28]
	0x0F120101, //ae_WeightTbl_16[29]
	0x0F120101, //ae_WeightTbl_16[30]
	0x0F120101, //ae_WeightTbl_16[31]

	//===================================================================
	//AWB-BASIC setting
	//===================================================================
	0x002A1018,
	0x0F1202A7, //awbb_GLocusR
	0x0F120343, //awbb_GLocusB
	0x002A0FFC,
	0x0F12036C, //awbb_CrclLowT_R_c
	0x002A1000,
	0x0F12011D, //awbb_CrclLowT_B_c
	0x002A1004,
	0x0F1262C1, //awbb_CrclLowT_Rad_c
	0x002A1034,
	0x0F1205F0, //awbb_GamutWidthThr1
	0x0F1201F4, //awbb_GamutHeightThr1
	0x0F12006C, //awbb_GamutWidthThr2
	0x0F120038, //awbb_GamutHeightThr2
	0x002A1020,
	0x0F12000C, //awbb_MinNumOfFinalPatches
	0x0F12001E, //awbb_MinNumOfLowBrFinalPatches
	0x0F120046, //awbb_MinNumOfLowBr0_FinalPatches
	0x002A291A,
	0x0F120006, // #Mon_AWB_ByPassMode          // [0]Outdoor [1]LowBr [2]LowTemp

	0x002A11C2,
	0x0F120000, //awbb_RGainOff
	0x0F120000, //awbb_BGainOff
	0x0F120000, //awbb_GGainOff
	0x0F1200C2, //awbb_Alpha_Comp_Mode
	0x0F120002, //awbb_Rpl_InvalidOutDoor
	0x0F120001, //awbb_UseGrThrCorr
	0x0F1200E4, //awbb_Use_Filters
	0x0F12053C, //awbb_GainsInit[0]
	0x0F120400, //awbb_GainsInit[1]
	0x0F12055C, //awbb_GainsInit[2]
	0x0F120008,	//001E	//awbb_WpFilterMinThr
	0x0F120160,	//0190	//awbb_WpFilterMaxThr
	0x0F1200A0, //awbb_WpFilterCoef
	0x0F120004, //awbb_WpFilterSize
	0x0F120001, //awbb_otp_disable

	//===================================================================
	//AWB-Zone
	//===================================================================
	//	param_start	awbb_IndoorGrZones_m_BGrid
	0x002A0F28,
	0x0F1203C0, //03C0//03C0//awbb_IndoorGrZones_m_BGrid[0]
	0x0F1203E2, //03E2//03E2//awbb_IndoorGrZones_m_BGrid[1]
	0x0F120356, //0356//0356//awbb_IndoorGrZones_m_BGrid[2]
	0x0F1203FC, //03FC//03FC//awbb_IndoorGrZones_m_BGrid[3]
	0x0F12031E, //031E//031E//awbb_IndoorGrZones_m_BGrid[4]
	0x0F1203FE, //03FE//03FE//awbb_IndoorGrZones_m_BGrid[5]
	0x0F1202F0, //02F0//02F0//awbb_IndoorGrZones_m_BGrid[6]
	0x0F1203F0, //03F0//03F0//awbb_IndoorGrZones_m_BGrid[7]
	0x0F1202CA, //02CA//02CA//awbb_IndoorGrZones_m_BGrid[8]
	0x0F1203CC, //03CC//03CC//awbb_IndoorGrZones_m_BGrid[9]
	0x0F1202A8, //02A8//02A8//awbb_IndoorGrZones_m_BGrid[10]
	0x0F12037A, //037A//037A//awbb_IndoorGrZones_m_BGrid[11]
	0x0F120280, //0288//0288//awbb_IndoorGrZones_m_BGrid[12]
	0x0F12033C, //033C//033C//awbb_IndoorGrZones_m_BGrid[13]
	0x0F120260, //0266//0266//awbb_IndoorGrZones_m_BGrid[14]
	0x0F12030A, //030A//031E//awbb_IndoorGrZones_m_BGrid[15]
	0x0F120242, //0246//0246//awbb_IndoorGrZones_m_BGrid[16]
	0x0F1202DC, //02EC//0300//awbb_IndoorGrZones_m_BGrid[17]
	0x0F120228, //0228//0228//awbb_IndoorGrZones_m_BGrid[18]
	0x0F1202B2, //02CE//02E8//awbb_IndoorGrZones_m_BGrid[19]
	0x0F12020E, //020E//020E//awbb_IndoorGrZones_m_BGrid[20]
	0x0F120290, //02B0//02CA//awbb_IndoorGrZones_m_BGrid[21]
	0x0F1201F8, //01F8//01F8//awbb_IndoorGrZones_m_BGrid[22]
	0x0F120276, //0292//02B0//awbb_IndoorGrZones_m_BGrid[23]
	0x0F1201E8, //01E8//01E8//awbb_IndoorGrZones_m_BGrid[24]
	0x0F120268, //0276//0296//awbb_IndoorGrZones_m_BGrid[25]
	0x0F1201DC, //01DC//01DC//awbb_IndoorGrZones_m_BGrid[26]
	0x0F120256, //0256//027A//awbb_IndoorGrZones_m_BGrid[27]
	0x0F1201E0, //01E0//01E0//awbb_IndoorGrZones_m_BGrid[28]
	0x0F120238, //0238//0252//awbb_IndoorGrZones_m_BGrid[29]
	0x0F1201EC, //01EC//01F2//awbb_IndoorGrZones_m_BGrid[30]
	0x0F12020E, //020E//0226//awbb_IndoorGrZones_m_BGrid[31]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[32]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[33]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[34]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[35]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[36]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[37]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[38]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[39]
	//	param_end	awbb_IndoorGrZones_m_BGrid

	0x0F120005, //awbb_IndoorGrZones_m_Grid
	0x002A0F80,
	0x0F1200E6, //awbb_IndoorGrZones_m_Boff
	0x002A0F7C,
	0x0F120010,

	//	param_start	awbb_OutdoorGrZones_m_BGrid
	0x002A0F84,
	0x0F12028E,	//awbb_OutdoorGrZones_m_BGrid[0]
	0x0F1202A6,	//awbb_OutdoorGrZones_m_BGrid[1]
	0x0F120276, //awbb_OutdoorGrZones_m_BGrid[2]
	0x0F1202B8,	//awbb_OutdoorGrZones_m_BGrid[3]
	0x0F120264,	//awbb_OutdoorGrZones_m_BGrid[4]
	0x0F1202BE,	//awbb_OutdoorGrZones_m_BGrid[5]
	0x0F120252,	//awbb_OutdoorGrZones_m_BGrid[6]
	0x0F1202C0,	//awbb_OutdoorGrZones_m_BGrid[7]
	0x0F120244,	//awbb_OutdoorGrZones_m_BGrid[8]
	0x0F1202BC,	//awbb_OutdoorGrZones_m_BGrid[9]
	0x0F120234,	//awbb_OutdoorGrZones_m_BGrid[10]
	0x0F1202B2,	//awbb_OutdoorGrZones_m_BGrid[11]
	0x0F120228,	//awbb_OutdoorGrZones_m_BGrid[12]
	0x0F1202A6,	//awbb_OutdoorGrZones_m_BGrid[13]
	0x0F12021E,	//awbb_OutdoorGrZones_m_BGrid[14]
	0x0F12029C, //awbb_OutdoorGrZones_m_BGrid[15]
	0x0F120216,	//awbb_OutdoorGrZones_m_BGrid[16]
	0x0F12028A,	//awbb_OutdoorGrZones_m_BGrid[17]
	0x0F120216, //awbb_OutdoorGrZones_m_BGrid[18]
	0x0F120278,	//awbb_OutdoorGrZones_m_BGrid[19]
	0x0F120220,	//awbb_OutdoorGrZones_m_BGrid[20]
	0x0F12026A,	//awbb_OutdoorGrZones_m_BGrid[21]
	0x0F120232,	//awbb_OutdoorGrZones_m_BGrid[22]
	0x0F12024A,	//awbb_OutdoorGrZones_m_BGrid[23]
	//	param_end	awbb_OutdoorGrZones_m_BGrid

	0x0F120004, //awbb_OutdoorGrZones_m_Gri
	0x002A0FB8,
	0x0F12000C,	//awbb_OutdoorGrZones_ZInfo_m_GridSz
	0x002A0FBC,
	0x0F1201E4,	//awbb_OutdoorGrZones_m_Bof

	//	param_start	awbb_LowBrGrZones_m_BGrid
	0x002A0FC0,
	0x0F1203B2, //awbb_LowBrGrZones_m_BGrid[0]
	0x0F12044E, //awbb_LowBrGrZones_m_BGrid[1]
	0x0F120330, //awbb_LowBrGrZones_m_BGrid[2]
	0x0F120454, //awbb_LowBrGrZones_m_BGrid[3]
	0x0F1202CC, //awbb_LowBrGrZones_m_BGrid[4]
	0x0F120414, //awbb_LowBrGrZones_m_BGrid[5]
	0x0F12026E, //awbb_LowBrGrZones_m_BGrid[6]
	0x0F1203D0, //awbb_LowBrGrZones_m_BGrid[7]
	0x0F120226, //awbb_LowBrGrZones_m_BGrid[8]
	0x0F120362, //awbb_LowBrGrZones_m_BGrid[9]
	0x0F1201F0, //awbb_LowBrGrZones_m_BGrid[10]
	0x0F120312, //awbb_LowBrGrZones_m_BGrid[11]
	0x0F1201CE, //awbb_LowBrGrZones_m_BGrid[12]
	0x0F1202CC, //awbb_LowBrGrZones_m_BGrid[13]
	0x0F1201B2, //awbb_LowBrGrZones_m_BGrid[14]
	0x0F12029E, //awbb_LowBrGrZones_m_BGrid[15]
	0x0F1201AC, //awbb_LowBrGrZones_m_BGrid[16]
	0x0F120278, //awbb_LowBrGrZones_m_BGrid[17]
	0x0F1201B6, //awbb_LowBrGrZones_m_BGrid[18]
	0x0F120248, //awbb_LowBrGrZones_m_BGrid[19]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[20]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[21]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[22]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[23]

	//	param_end	awbb_LowBrGrZones_m_BGrid
	0x0F120006, //awbb_LowBrGrZones_m_GridStep
	0x002A0FF4,
	0x0F12000A, //awbb_LowBrGrZones_ZInfo_m_GridSz
	0x002A0FF8,
	0x0F1200C2, //awbb_LowBrGrZones_m_Boffs

	//===================================================================
	//AWB Scene Detection
	//===================================================================
	0x002A1098,
	0x0F12FE82, //awbb_SCDetectionMap_SEC_StartR_B
	0x0F12001E, //awbb_SCDetectionMap_SEC_StepR_B
	0x0F1209C4, //awbb_SCDetectionMap_SEC_SunnyNB
	0x0F120122, //awbb_SCDetectionMap_SEC_StepNB
	0x0F1200E4, //awbb_SCDetectionMap_SEC_LowTempR_B
	0x0F120096, //awbb_SCDetectionMap_SEC_SunnyNBZone
	0x0F12000E, //awbb_SCDetectionMap_SEC_LowTempR_BZone

	0x002A105C,
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__2_
	0x0F120500, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__4_
	0x0F125555, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__1_
	0x0F125455, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__3_
	0x0F12AA55, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__0_
	0x0F12AAAA, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__2_
	0x0F12BF54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__3_
	0x0F12FF6F, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__2_
	0x0F121B54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__3_
	0x0F12FF06, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__2_
	0x0F120154, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__4_
	0x0F12BFBF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__1_
	0x0F1254BE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__3_

	//===================================================================
	//AWB - GridCorrection
	//===================================================================

	0x002A11E0,
	0x0F120002, //awbb_GridEnable

	0x002A11A8,
	0x0F1202C8, //awbb_GridConst_1[0]
	0x0F120325, //awbb_GridConst_1[1]
	0x0F12038F, //awbb_GridConst_1[2]

	0x0F120F8E, //awbb_GridConst_2[0]
	0x0F1210B3, //awbb_GridConst_2[1]
	0x0F121136, //awbb_GridConst_2[2]
	0x0F121138, //awbb_GridConst_2[3]
	0x0F12118E, //awbb_GridConst_2[4]
	0x0F121213, //awbb_GridConst_2[5]

	0x0F1200A7, //awbb_GridCoeff_R_1
	0x0F1200C2, //awbb_GridCoeff_B_1
	0x0F1200BD, //awbb_GridCoeff_R_2
	0x0F1200AC, //awbb_GridCoeff_B_2

	0x002A1118,
	0x0F120050, //0032//awbb_GridCorr_R[0][0]
	0x0F120032, //0012//awbb_GridCorr_R[0][1]
	0x0F120032, //0012//awbb_GridCorr_R[0][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[0][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[0][4]
	0x0F120060, //0050//awbb_GridCorr_R[0][5]
	0x0F120050, //0032//awbb_GridCorr_R[1][0]
	0x0F120032, //0012//awbb_GridCorr_R[1][1]
	0x0F120032, //0012//awbb_GridCorr_R[1][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[1][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[1][4]
	0x0F120060, //0050//awbb_GridCorr_R[1][5]
	0x0F120050, //0032//awbb_GridCorr_R[2][0]
	0x0F120032, //0012//awbb_GridCorr_R[2][1]
	0x0F120032, //0012//awbb_GridCorr_R[2][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[2][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[2][4]
	0x0F120060, //0050//awbb_GridCorr_R[2][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[0][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[0][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[0][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[0][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[0][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[0][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[1][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[1][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[1][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[1][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[1][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[1][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[2][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[2][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[2][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[2][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[2][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[2][5]

	0x002A1160,
	0x0F12000A, //awbb_GridCorr_R_Out[0][0]
	0x0F12000A, //awbb_GridCorr_R_Out[0][1]
	0x0F120000, //awbb_GridCorr_R_Out[0][2]
	0x0F120000, //awbb_GridCorr_R_Out[0][3]
	0x0F120000, //awbb_GridCorr_R_Out[0][4]
	0x0F120000, //awbb_GridCorr_R_Out[0][5]
	0x0F12000A, //awbb_GridCorr_R_Out[1][0]
	0x0F12000A, //awbb_GridCorr_R_Out[1][1]
	0x0F120000, //awbb_GridCorr_R_Out[1][2]
	0x0F120000, //awbb_GridCorr_R_Out[1][3]
	0x0F120000, //awbb_GridCorr_R_Out[1][4]
	0x0F120000, //awbb_GridCorr_R_Out[1][5]
	0x0F12000A, //awbb_GridCorr_R_Out[2][0]
	0x0F12000A, //awbb_GridCorr_R_Out[2][1]
	0x0F120000, //awbb_GridCorr_R_Out[2][2]
	0x0F120000, //awbb_GridCorr_R_Out[2][3]
	0x0F120000, //awbb_GridCorr_R_Out[2][4]
	0x0F120000, //awbb_GridCorr_R_Out[2][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[0][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[0][1]
	0x0F120000, //awbb_GridCorr_B_Out[0][2]
	0x0F120000, //awbb_GridCorr_B_Out[0][3]
	0x0F120000, //awbb_GridCorr_B_Out[0][4]
	0x0F120000, //awbb_GridCorr_B_Out[0][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[1][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[1][1]
	0x0F120000, //awbb_GridCorr_B_Out[1][2]
	0x0F120000, //awbb_GridCorr_B_Out[1][3]
	0x0F120000, //awbb_GridCorr_B_Out[1][4]
	0x0F120000, //awbb_GridCorr_B_Out[1][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[2][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[2][1]
	0x0F120000, //awbb_GridCorr_B_Out[2][2]
	0x0F120000, //awbb_GridCorr_B_Out[2][3]
	0x0F120000, //awbb_GridCorr_B_Out[2][4]
	0x0F120000, //awbb_GridCorr_B_Out[2][5]

	//===================================================================
	// CCM
	//===================================================================
	0x002A07D2,
	0x0F1200C0, //SARR_AwbCcmCord_0_
	0x0F1200E0, //SARR_AwbCcmCord_1_
	0x0F120110, //SARR_AwbCcmCord_2_
	0x0F120139, //SARR_AwbCcmCord_3_
	0x0F120166, //SARR_AwbCcmCord_4_
	0x0F12019F, //SARR_AwbCcmCord_5_

	//	param_start	TVAR_wbt_pBaseCcms
	0x002A07C4,
	0x0F124000, //TVAR_wbt_pBaseCcms
	0x0F127000,

	0x002A4000,
	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[0]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[1]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[2]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[3]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[4]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[5]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[6]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[7]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[8]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[9]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[10]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[11]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[12]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[13]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[14]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[15]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[16]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[17]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[18]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[19]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[20]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[21]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[22]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[23]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[24]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[25]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[26]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[27]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[28]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[29]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[30]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[31]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[32]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[33]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[34]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[35]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[36]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[37]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[38]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[39]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[40]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[41]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[42]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[43]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[44]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[45]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[46]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[47]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[48]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[49]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[50]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[51]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[52]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[53]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[54]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[55]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[56]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[57]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[58]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[59]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[60]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[61]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[62]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[63]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[64]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[65]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[66]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[67]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[68]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[69]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[70]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[71]

	0x0F12011D, //00F4          //TVAR_wbt_pBaseCcms[72]
	0x0F12FFA7, //FFC2//TVAR_wbt_pBaseCcms[73]
	0x0F12FFEC, //FFFA//TVAR_wbt_pBaseCcms[74]
	0x0F12FF0D, //FF3E//TVAR_wbt_pBaseCcms[75]
	0x0F120193, //0163//TVAR_wbt_pBaseCcms[76]
	0x0F12FF34, //FF5F//TVAR_wbt_pBaseCcms[77]
	0x0F12FFCE, //FFCE//TVAR_wbt_pBaseCcms[78]
	0x0F12FFDF, //FFDF//TVAR_wbt_pBaseCcms[79]
	0x0F12015E, //015E//TVAR_wbt_pBaseCcms[80]
	0x0F120095, //0095//TVAR_wbt_pBaseCcms[81]
	0x0F120096, //0096//TVAR_wbt_pBaseCcms[82]
	0x0F12FF0B, //FF0B//TVAR_wbt_pBaseCcms[83]
	0x0F1200C3, //00C3//TVAR_wbt_pBaseCcms[84]
	0x0F12FF5C, //FF5C//TVAR_wbt_pBaseCcms[85]
	0x0F12013D, //013D//TVAR_wbt_pBaseCcms[86]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[87]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[88]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[89]

	0x0F12011D, //00F4          //TVAR_wbt_pBaseCcms[90]
	0x0F12FFA7, //FFC2//TVAR_wbt_pBaseCcms[91]
	0x0F12FFEC, //FFFA//TVAR_wbt_pBaseCcms[92]
	0x0F12FF0D, //FF3E//TVAR_wbt_pBaseCcms[93]
	0x0F120193, //0163//TVAR_wbt_pBaseCcms[94]
	0x0F12FF34, //FF5F//TVAR_wbt_pBaseCcms[95]
	0x0F12FFCE, //FFCE//TVAR_wbt_pBaseCcms[96]
	0x0F12FFDF, //FFDF//TVAR_wbt_pBaseCcms[97]
	0x0F12015E, //015E//TVAR_wbt_pBaseCcms[98]
	0x0F120095, //0095//TVAR_wbt_pBaseCcms[99]
	0x0F120096, //0096//TVAR_wbt_pBaseCcms[100]
	0x0F12FF0B, //FF0B//TVAR_wbt_pBaseCcms[101]
	0x0F1200C3, //00C3//TVAR_wbt_pBaseCcms[102]
	0x0F12FF5C, //FF5C//TVAR_wbt_pBaseCcms[103]
	0x0F12013D, //013D//TVAR_wbt_pBaseCcms[104]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[105]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[106]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[107]
	//	param_end	TVAR_wbt_pBasecms


	0x002A07CC,
	0x0F1240D8, //#TVAR_wbt_pOutdoorCcm
	0x0F127000,

	//	param_start	TVAR_wbt_pOutdoorCcm
	0x002A40D8,
	0x0F1201F6, //01F6//01F8//TVAR_wbt_pOutdoorCcm[0]
	0x0F12FF9F, //FF9F//FFAF//TVAR_wbt_pOutdoorCcm[1]
	0x0F12FFE5, //FFE5//FFD3//TVAR_wbt_pOutdoorCcm[2]
	0x0F12FED2, //FED2//FEC4//TVAR_wbt_pOutdoorCcm[3]
	0x0F120193, //0193//0191//TVAR_wbt_pOutdoorCcm[4]
	0x0F12FF23, //FF23//FF33//TVAR_wbt_pOutdoorCcm[5]
	0x0F12FFF7, //FFF7//FFED//TVAR_wbt_pOutdoorCcm[6]
	0x0F12000C, //000C//0017//TVAR_wbt_pOutdoorCcm[7]
	0x0F120211, //0211//0210//TVAR_wbt_pOutdoorCcm[8]
	0x0F1200FF, //00F1//00E3//TVAR_wbt_pOutdoorCcm[9]
	0x0F1200EC, //00FA//0107//TVAR_wbt_pOutdoorCcm[10]
	0x0F12FF2E, //FF2E//FF2F//TVAR_wbt_pOutdoorCcm[11]
	0x0F120220, //0220//0220//TVAR_wbt_pOutdoorCcm[12]
	0x0F12FFE7, //FFE7//FFE7//TVAR_wbt_pOutdoorCcm[13]
	0x0F1201A1, //01A1//01A1//TVAR_wbt_pOutdoorCcm[14]
	0x0F12FEC7, //FEC7//FEC8//TVAR_wbt_pOutdoorCcm[15]
	0x0F12016D, //016D//017D//TVAR_wbt_pOutdoorCcm[16]
	0x0F120153, //0153//0142//TVAR_wbt_pOutdoorCcm[17]
	//	param_end	TVAR_wbt_pOutdoorCcm


	0x002A2A64,
	0x0F120001, //#MVAR_AAIO_bFIT
	0x002A2A68,
	0x0F120001, //#MVAR_AAIO_bAutoCCMandASH
	0x002A2A3C,
	0x0F1201DD, //#Mon_AAIO_PrevFrmData_NormBr

	//===================================================================
	// AFIT
	//===================================================================

	//	param_start	afit_uNoiseIndInDoor
	0x002A085C,
	0x0F12004A, //0049//#afit_uNoiseIndInDoor_0_
	0x0F12004E, //005F//#afit_uNoiseIndInDoor_1_
	0x0F1200CB, //00CB//#afit_uNoiseIndInDoor_2_
	0x0F1201C0, //01E0//#afit_uNoiseIndInDoor_3_
	0x0F120200, //0220//#afit_uNoiseIndInDoor_4_

	0x002A08C0,
	0x0F120007, //0007//700008C0//AFIT16_BRIGHTNESS
	0x0F120000, //0000//700008C2           //AFIT16_CONTRAST
	0x0F120000, //0000//700008C4           //AFIT16_SATURATION
	0x0F120002, //0000//700008C6           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//700008C8           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//700008CA           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//700008CC
	0x0F1203FF, //03FF//700008CE           //AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//700008D0           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//700008D2           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//700008D4           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//700008D6           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//700008D8           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//700008DA           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//700008DC           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//700008DE           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//700008E0           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//700008E2           //AFIT16_demsharpmix1_iTune
	0x0F120010, //0010//700008E4//AFIT16_demsharpmix1_iHystThLow
	0x0F120010, //0010//700008E6//AFIT16_demsharpmix1_iHystThHigh
	0x0F1201F4, //01F4//700008E8//AFIT16_demsharpmix1_iHystCenter
	0x0F12006E, //003C//700008EA           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0008//700008EC           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//700008EE           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//700008F0           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//700008F2           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//700008F4           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//700008F6           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh [15:8]
	0x0F121701, //1701//700008F8           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level [15:8]
	0x0F120229, //0229//700008FA           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8]
	0x0F121403, //1403//700008FC           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAllowed [15:8]
	0x0F120004, //0004//700008FE           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotThreshLow [15:8]
	0x0F120300, //0300//70000900           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iColdThreshLow [15:8]
	0x0F120000, //0000//70000902           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoisePower2 [15:8]
	0x0F1202FF, //02FF//70000904           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [15:8]
	0x0F1205E8, //09E8//70000906           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadialPower [15:8]
	0x0F121414, //1414//70000908           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]
	0x0F120301, //0301//7000090A           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHighSlopeThresh [15:8]
	0x0F120007, //0007//7000090C           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F124000, //4000//7000090E
	0x0F127803, //7803//70000910
	0x0F123C50, //3C50//70000912
	0x0F12003C, //003C//70000914
	0x0F121E80, //1E80//70000916           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_iMonochrom[15:8]
	0x0F121E08, //1E08//70000918           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosaicing_iDesatThresh[15:8]
	0x0F12000A, //000A//7000091A           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_iGRDenoiseVal[15:8]
	0x0F120000, //0000//7000091C           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaicing_iNearGrayDesat[15:8]
	0x0F12120A, //120A//7000091E           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpening_iMSharpen[15:8]
	0x0F121400, //0F00//70000920           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iWSharpen[15:8]
	0x0F120200, //0200//70000922           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nSharpWidth[15:8]
	0x0F12FF00, //FF00//70000924           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpening_iShDespeckle[15:8]
	0x0F120200, //0200//70000926           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demsharpmix1_iFilterPower[15:8]
	0x0F121B11, //1B11//70000928           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_iGCoeff[15:8]
	0x0F120000, //0000//7000092A           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1_iNarrMult[15:8]
	0x0F120009, //0009//7000092C           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpmix1_iHystMinMult[15:8]
	0x0F120406, //0406//7000092E           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix1_iHystFallLow[15:8]
	0x0F120605, //0605//70000930           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharpmix1_iHystTune[15:8]
	0x0F120307, //0307//70000932
	0x0F120609, //0609//70000934
	0x0F122C07, //2C07//70000936
	0x0F12142C, //142C//70000938
	0x0F120B18, //0718//7000093A//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F12800B, //8007//7000093C//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120880, //0880//7000093E           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iDarkReduce [15:8]
	0x0F120B50, //0B50//70000940           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYOffset [15:8]
	0x0F120080, //0080//70000942           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSaturation [15:8]
	0x0F120101, //0101//70000944           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClustThresh_C [15:8]
	0x0F120707, //0707//70000946           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClustMulT_C [15:8]
	0x0F124601, //4601//70000948           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_DispTH_Low [15:8]
	0x0F12A444, //C844//7000094A           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenThreshLow [15:8]
	0x0F1250A4, //50C8//7000094C           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing_iEdgeDesat [15:8]
	0x0F120500, //0500//7000094E           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]
	0x0F120303, //0003//70000950           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosaicing_iDemSharpenLow [15:8]
	0x0F121001, //1C01//70000952           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demosaicing_iDemSharpThresh [15:8]
	0x0F120710, //0714//70000954           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]
	0x0F121448, //1464//70000956           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaicing_iDemBlurHigh [15:8]
	0x0F125A03, //5A04//70000958           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpening_iLowSharpPower [15:8]
	0x0F12281E, //3C1E//7000095A           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpening_iLowShDenoise [15:8]
	0x0F12200F, //400F//7000095C           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpening_iReduceEdgeMinMult [15:8]
	0x0F120204, //0204//7000095E           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsharpmix1_iWideFiltReduce [15:8]
	0x0F121403, //1403//70000960           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd8a_iClustThresh_H_Bin [15:8]
	0x0F120114, //0114//70000962           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a_iClustMulT_H_Bin [15:8]
	0x0F120101, //0101//70000964           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_nClustLevel_H_Bin [15:8]
	0x0F124446, //4446//70000966           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_DispTH_High_Bin [15:8]
	0x0F12646E, //646E//70000968           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]
	0x0F120028, //0028//7000096A           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]
	0x0F12030A, //030A//7000096C           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]
	0x0F120000, //0000//7000096E           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]
	0x0F12141E, //141E//70000970           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]
	0x0F12FF07, //FF07//70000972           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]
	0x0F120432, //0432//70000974           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]
	0x0F120000, //0000//70000976           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sharpening_iHighSharpPower_Bin [15:8]
	0x0F120F0F, //0F0F//70000978           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Sharpening_iHighShDenoise_Bin [15:8]
	0x0F120440, //0440//7000097A           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]
	0x0F120302, //0302//7000097C           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]
	0x0F121414, //1414//7000097E           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a_iClustThresh_C_sBin [15:8]
	0x0F120101, //0101//70000980           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_iClustMulT_C_sBin [15:8]
	0x0F124601, //4601//70000982           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a_DispTH_Low_sBin [15:8]
	0x0F126E44, //6E44//70000984           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_iDenThreshLow_sBin [15:8]
	0x0F122864, //2864//70000986           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]
	0x0F120A00, //0A00//70000988           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]
	0x0F120003, //0003//7000098A           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]
	0x0F121E00, //1E00//7000098C           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]
	0x0F120714, //0714//7000098E           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]
	0x0F1232FF, //32FF//70000990           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]
	0x0F120004, //0004//70000992           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sharpening_iLowSharpPower_sBin [15:8]
	0x0F120F00, //0F00//70000994           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_Sharpening_iLowShDenoise_sBin [15:8]
	0x0F12400F, //400F//70000996           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]
	0x0F120204, //0204//70000998           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]
	0x0F120003, //0003//7000099A           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//7000099C
	0x0F120000, //0000//7000099E//AFIT16_BRIGHTNESS
	0x0F120000, //0000//700009A0           //AFIT16_CONTRAST
	0x0F120000, //0000//700009A2           //AFIT16_SATURATION
	0x0F120002, //0000//700009A4           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//700009A6           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//700009A8           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//700009AA
	0x0F1203FF, //03FF//700009AC           //AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//700009AE           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//700009B0           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//700009B2           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//700009B4           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//700009B6           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//700009B8           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//700009BA           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//700009BC           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//700009BE           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//700009C0           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//700009C2//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//700009C4//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//700009C6//AFIT16_demsharpmix1_iHystCenter
	0x0F12006E, //006E//700009C8           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//700009CA           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//700009CC           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//700009CE           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//700009D0           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//700009D2           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//700009D4           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh [15:8]
	0x0F121701, //1701//700009D6           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level [15:8]
	0x0F120229, //0229//700009D8           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8]
	0x0F121403, //1403//700009DA           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAllowed [15:8]
	0x0F120004, //0004//700009DC           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotThreshLow [15:8]
	0x0F120300, //0300//700009DE           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iColdThreshLow [15:8]
	0x0F120000, //0000//700009E0           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoisePower2 [15:8]
	0x0F1202FF, //02FF//700009E2           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [15:8]
	0x0F1205E8, //05E8//700009E4           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadialPower [15:8]
	0x0F121414, //1414//700009E6           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]
	0x0F120301, //0301//700009E8           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHighSlopeThresh [15:8]
	0x0F120007, //0007//700009EA           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F122000, //2000//700009EC
	0x0F125003, //5003//700009EE
	0x0F123228, //3228//700009F0
	0x0F120032, //0032//700009F2
	0x0F121E80, //1E80//700009F4           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_iMonochrom[15:8]
	0x0F121E08, //1E08//700009F6           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosaicing_iDesatThresh[15:8]
	0x0F12000A, //000A//700009F8           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_iGRDenoiseVal[15:8]
	0x0F120000, //0000//700009FA           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaicing_iNearGrayDesat[15:8]
	0x0F12120A, //120A//700009FC           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpening_iMSharpen[15:8]
	0x0F121400, //1400//700009FE           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iWSharpen[15:8]
	0x0F120200, //0200//70000A00           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nSharpWidth[15:8]
	0x0F12FF00, //FF00//70000A02           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpening_iShDespeckle[15:8]
	0x0F120200, //0200//70000A04           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demsharpmix1_iFilterPower[15:8]
	0x0F121B11, //1B11//70000A06           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_iGCoeff[15:8]
	0x0F120000, //0000//70000A08           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1_iNarrMult[15:8]
	0x0F120009, //0009//70000A0A           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpmix1_iHystMinMult[15:8]
	0x0F120406, //0406//70000A0C           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix1_iHystFallLow[15:8]
	0x0F120605, //0605//70000A0E           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharpmix1_iHystTune[15:8]
	0x0F120307, //0307//70000A10
	0x0F120609, //0609//70000A12
	0x0F122C07, //2C07//70000A14
	0x0F12142C, //142C//70000A16
	0x0F120518, //0518//70000A18//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000A1A//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120580, //0580//70000A1C           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iDarkReduce [15:8]
	0x0F120080, //0080//70000A1E           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYOffset [15:8]
	0x0F120080, //0080//70000A20           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSaturation [15:8]
	0x0F120101, //0101//70000A22           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClustThresh_C [15:8]
	0x0F120707, //0707//70000A24           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClustMulT_C [15:8]
	0x0F124B01, //4B01//70000A26           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_DispTH_Low [15:8]
	0x0F12494B, //444B 494B//70000A28           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenThreshLow [15:8]
	0x0F125044, //503C 5044//70000A2A           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing_iEdgeDesat [15:8]
	0x0F120500, //0500//70000A2C           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]
	0x0F120603, //0503//70000A2E           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosaicing_iDemSharpenLow [15:8]
	0x0F120D03, //0D02//70000A30           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demosaicing_iDemSharpThresh [15:8]
	0x0F12071E, //071E//70000A32           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]
	0x0F121432, //1432//70000A34           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaicing_iDemBlurHigh [15:8]
	0x0F125A01, //5A01//70000A36           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpening_iLowSharpPower [15:8]
	0x0F12281E, //281E//70000A38           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpening_iLowShDenoise [15:8]
	0x0F12200F, //200F//70000A3A           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpening_iReduceEdgeMinMult [15:8]
	0x0F120204, //0204//70000A3C           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsharpmix1_iWideFiltReduce [15:8]
	0x0F121E03, //1E03//70000A3E           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd8a_iClustThresh_H_Bin [15:8]
	0x0F12011E, //011E//70000A40           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a_iClustMulT_H_Bin [15:8]
	0x0F120101, //0101//70000A42           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_nClustLevel_H_Bin [15:8]
	0x0F123A3C, //3A3C//70000A44           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_DispTH_High_Bin [15:8]
	0x0F12585A, //585A//70000A46           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]
	0x0F120028, //0028//70000A48           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]
	0x0F12030A, //030A//70000A4A           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]
	0x0F120000, //0000//70000A4C           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]
	0x0F12141E, //141E//70000A4E           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]
	0x0F12FF07, //FF07//70000A50           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]
	0x0F120432, //0432//70000A52           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]
	0x0F120000, //0000//70000A54           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sharpening_iHighSharpPower_Bin [15:8]
	0x0F120F0F, //0F0F//70000A56           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Sharpening_iHighShDenoise_Bin [15:8]
	0x0F120440, //0440//70000A58           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]
	0x0F120302, //0302//70000A5A           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]
	0x0F121E1E, //1E1E//70000A5C           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a_iClustThresh_C_sBin [15:8]
	0x0F120101, //0101//70000A5E           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_iClustMulT_C_sBin [15:8]
	0x0F123C01, //3C01//70000A60           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a_DispTH_Low_sBin [15:8]
	0x0F125A3A, //5A3A//70000A62           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_iDenThreshLow_sBin [15:8]
	0x0F122858, //2858//70000A64           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]
	0x0F120A00, //0A00//70000A66           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]
	0x0F120003, //0003//70000A68           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]
	0x0F121E00, //1E00//70000A6A           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]
	0x0F120714, //0714//70000A6C           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]
	0x0F1232FF, //32FF//70000A6E           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]
	0x0F120004, //0004//70000A70           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sharpening_iLowSharpPower_sBin [15:8]
	0x0F120F00, //0F00//70000A72           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_Sharpening_iLowShDenoise_sBin [15:8]
	0x0F12400F, //400F//70000A74           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]
	0x0F120204, //0204//70000A76           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]
	0x0F120003, //0003//70000A78           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//70000A7A
	0x0F120000, //0000//70000A7C//AFIT16_BRIGHTNESS
	0x0F120000, //0000//70000A7E           //AFIT16_CONTRAST
	0x0F120000, //0000//70000A80           //AFIT16_SATURATION
	0x0F120000, //0000//70000A82           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//70000A84           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//70000A86           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//70000A88
	0x0F1203FF, //03FF//70000A8A           //AFIT16_Demosaicing_iSatVal
	0x0F12009E, //009E//70000A8C           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//70000A8E           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//70000A90           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//70000A92           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//70000A94           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//70000A96           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//70000A98           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//70000A9A           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//70000A9C           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//70000A9E           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//70000AA0//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//70000AA2//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//70000AA4//AFIT16_demsharpmix1_iHystCenter
	0x0F12008C, //008C//70000AA6           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//70000AA8           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//70000AAA           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//70000AAC           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//70000AAE           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//70000AB0           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//70000AB2           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh [15:8]
	0x0F121701, //1701//70000AB4           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level [15:8]
	0x0F120229, //0229//70000AB6           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8]
	0x0F121403, //1403//70000AB8           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAllowed [15:8]
	0x0F120004, //0004//70000ABA           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotThreshLow [15:8]
	0x0F120300, //0300//70000ABC           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iColdThreshLow [15:8]
	0x0F120000, //0000//70000ABE           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoisePower2 [15:8]
	0x0F1202FF, //02FF//70000AC0           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [15:8]
	0x0F1205DE, //05DE//70000AC2           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadialPower [15:8]
	0x0F121414, //1414//70000AC4           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]
	0x0F120301, //0301//70000AC6           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHighSlopeThresh [15:8]
	0x0F120007, //0007//70000AC8           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//70000ACA
	0x0F122803, //2803//70000ACC
	0x0F12261E, //261E//70000ACE
	0x0F120026, //0026//70000AD0
	0x0F121E80, //1E80//70000AD2           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_iMonochrom[15:8]
	0x0F121E08, //1E08//70000AD4           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosaicing_iDesatThresh[15:8]
	0x0F12010A, //010A//70000AD6           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_iGRDenoiseVal[15:8]
	0x0F120001, //0001//70000AD8           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaicing_iNearGrayDesat[15:8]
	0x0F123C0A, //3C0A//70000ADA           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpening_iMSharpen[15:8]
	0x0F122300, //2300//70000ADC           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iWSharpen[15:8]
	0x0F120200, //0200//70000ADE           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nSharpWidth[15:8]
	0x0F12FF00, //FF00//70000AE0           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpening_iShDespeckle[15:8]
	0x0F120200, //0200//70000AE2           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demsharpmix1_iFilterPower[15:8]
	0x0F121B11, //1B11//70000AE4           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_iGCoeff[15:8]
	0x0F120000, //0000//70000AE6           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1_iNarrMult[15:8]
	0x0F120009, //0009//70000AE8           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpmix1_iHystMinMult[15:8]
	0x0F120406, //0406//70000AEA           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix1_iHystFallLow[15:8]
	0x0F120605, //0605//70000AEC           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharpmix1_iHystTune[15:8]
	0x0F120307, //0307//70000AEE
	0x0F120609, //0609//70000AF0
	0x0F121C07, //1C07//70000AF2
	0x0F121014, //1014//70000AF4
	0x0F120510, //0510//70000AF6//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000AF8//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120080, //0080//70000AFA           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iDarkReduce [15:8]
	0x0F120080, //0080//70000AFC           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYOffset [15:8]
	0x0F120080, //0080//70000AFE           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSaturation [15:8]
	0x0F120101, //0101//70000B00           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClustThresh_C [15:8]
	0x0F120707, //0707//70000B02           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClustMulT_C [15:8]
	0x0F124B01, //4B01//70000B04           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_DispTH_Low [15:8]
	0x0F122A4B, //2A4B//70000B06           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenThreshLow [15:8]
	0x0F125020, //5020//70000B08           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing_iEdgeDesat [15:8]
	0x0F120500, //0500//70000B0A           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]
	0x0F121C03, //1C03//70000B0C           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosaicing_iDemSharpenLow [15:8]
	0x0F120D0C, //0D0C//70000B0E           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demosaicing_iDemSharpThresh [15:8]
	0x0F120823, //0823//70000B10           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]
	0x0F121428, //1428//70000B12           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaicing_iDemBlurHigh [15:8]
	0x0F126401, //6401//70000B14           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpening_iLowSharpPower [15:8]
	0x0F12282D, //282D//70000B16           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpening_iLowShDenoise [15:8]
	0x0F122012, //2012//70000B18           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpening_iReduceEdgeMinMult [15:8]
	0x0F120204, //0204//70000B1A           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsharpmix1_iWideFiltReduce [15:8]
	0x0F122803, //2803//70000B1C           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd8a_iClustThresh_H_Bin [15:8]
	0x0F120128, //0128//70000B1E           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a_iClustMulT_H_Bin [15:8]
	0x0F120101, //0101//70000B20           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_nClustLevel_H_Bin [15:8]
	0x0F122224, //2224//70000B22           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_DispTH_High_Bin [15:8]
	0x0F123236, //3236//70000B24           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]
	0x0F120028, //0028//70000B26           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]
	0x0F12030A, //030A//70000B28           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]
	0x0F120410, //0410//70000B2A           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]
	0x0F12141E, //141E//70000B2C           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]
	0x0F12FF07, //FF07//70000B2E           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]
	0x0F120432, //0432//70000B30           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]
	0x0F124050, //4050//70000B32           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sharpening_iHighSharpPower_Bin [15:8]
	0x0F120F0F, //0F0F//70000B34           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Sharpening_iHighShDenoise_Bin [15:8]
	0x0F120440, //0440//70000B36           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]
	0x0F120302, //0302//70000B38           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]
	0x0F122828, //2828//70000B3A           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a_iClustThresh_C_sBin [15:8]
	0x0F120101, //0101//70000B3C           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_iClustMulT_C_sBin [15:8]
	0x0F122401, //2401//70000B3E           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a_DispTH_Low_sBin [15:8]
	0x0F123622, //3622//70000B40           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_iDenThreshLow_sBin [15:8]
	0x0F122832, //2832//70000B42           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]
	0x0F120A00, //0A00//70000B44           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]
	0x0F121003, //1003//70000B46           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]
	0x0F121E04, //1E04//70000B48           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]
	0x0F120714, //0714//70000B4A           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]
	0x0F1232FF, //32FF//70000B4C           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]
	0x0F125004, //5004//70000B4E           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sharpening_iLowSharpPower_sBin [15:8]
	0x0F120F40, //0F40//70000B50           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_Sharpening_iLowShDenoise_sBin [15:8]
	0x0F12400F, //400F//70000B52           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]
	0x0F120204, //0204//70000B54           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]
	0x0F120003, //0003//70000B56           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//70000B58
	0x0F120000, //0000//70000B5A//AFIT16_BRIGHTNESS
	0x0F120000, //0000//70000B5C           //AFIT16_CONTRAST
	0x0F120000, //0000//70000B5E           //AFIT16_SATURATION
	0x0F120000, //0000//70000B60           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//70000B62           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//70000B64           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//70000B66
	0x0F1203FF, //03FF//70000B68           //AFIT16_Demosaicing_iSatVal
	0x0F12009E, //009E//70000B6A           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//70000B6C           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//70000B6E           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//70000B70           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//70000B72           //AFIT16_demsharpmix1_iHighThreshold
	0x0F1200C8, //00C8//70000B74           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//70000B76           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//70000B78           //AFIT16_demsharpmix1_iLowSat
	0x0F120050, //0050//70000B7A           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//70000B7C           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//70000B7E//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//70000B80//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//70000B82//AFIT16_demsharpmix1_iHystCenter
	0x0F12008C, //008C//70000B84           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//70000B86           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12002D, //002D//70000B88           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F120019, //0019//70000B8A           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12002D, //002D//70000B8C           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F120019, //0019//70000B8E           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//70000B90           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh [15:8]
	0x0F121701, //1701//70000B92           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level [15:8]
	0x0F120229, //0229//70000B94           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8]
	0x0F121403, //1403//70000B96           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAllowed [15:8]
	0x0F120004, //0004//70000B98           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotThreshLow [15:8]
	0x0F120300, //0300//70000B9A           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iColdThreshLow [15:8]
	0x0F120000, //0000//70000B9C           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoisePower2 [15:8]
	0x0F1202FF, //02FF//70000B9E           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [15:8]
	0x0F1205DE, //05DE//70000BA0           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadialPower [15:8]
	0x0F121414, //1414//70000BA2           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]
	0x0F120301, //0301//70000BA4           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHighSlopeThresh [15:8]
	0x0F120007, //0007//70000BA6           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//70000BA8
	0x0F122303, //2303//70000BAA
	0x0F12231A, //231A//70000BAC
	0x0F120023, //0023//70000BAE
	0x0F121E80, //1E80//70000BB0           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_iMonochrom[15:8]
	0x0F121E08, //1E08//70000BB2           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosaicing_iDesatThresh[15:8]
	0x0F12010A, //010A//70000BB4           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_iGRDenoiseVal[15:8]
	0x0F120001, //0001//70000BB6           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaicing_iNearGrayDesat[15:8]
	0x0F123C0A, //3C0A//70000BB8           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpening_iMSharpen[15:8]
	0x0F122300, //2300//70000BBA           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iWSharpen[15:8]
	0x0F120200, //0200//70000BBC           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nSharpWidth[15:8]
	0x0F12FF00, //FF00//70000BBE           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpening_iShDespeckle[15:8]
	0x0F120200, //0200//70000BC0           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demsharpmix1_iFilterPower[15:8]
	0x0F121E10, //1E10//70000BC2           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_iGCoeff[15:8]
	0x0F120000, //0000//70000BC4           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1_iNarrMult[15:8]
	0x0F120009, //0009//70000BC6           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpmix1_iHystMinMult[15:8]
	0x0F120406, //0406//70000BC8           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix1_iHystFallLow[15:8]
	0x0F120705, //0705//70000BCA           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharpmix1_iHystTune[15:8]
	0x0F120306, //0306//70000BCC
	0x0F120509, //0509//70000BCE
	0x0F122806, //2806//70000BD0
	0x0F121428, //1428//70000BD2
	0x0F120518, //0518//70000BD4//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000BD6//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120080, //0080//70000BD8           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iDarkReduce [15:8]
	0x0F120080, //0080//70000BDA           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYOffset [15:8]
	0x0F120080, //0080//70000BDC           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSaturation [15:8]
	0x0F120101, //0101//70000BDE           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClustThresh_C [15:8]
	0x0F120707, //0707//70000BE0           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClustMulT_C [15:8]
	0x0F124B01, //4B01//70000BE2           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_DispTH_Low [15:8]
	0x0F122A4B, //2A4B//70000BE4           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenThreshLow [15:8]
	0x0F125020, //5020//70000BE6           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing_iEdgeDesat [15:8]
	0x0F120500, //0500//70000BE8           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]
	0x0F121C03, //1C03//70000BEA           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosaicing_iDemSharpenLow [15:8]
	0x0F120D0C, //0D0C//70000BEC           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demosaicing_iDemSharpThresh [15:8]
	0x0F120823, //0823//70000BEE           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]
	0x0F121428, //1428//70000BF0           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaicing_iDemBlurHigh [15:8]
	0x0F126401, //6401//70000BF2           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpening_iLowSharpPower [15:8]
	0x0F12282D, //282D//70000BF4           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpening_iLowShDenoise [15:8]
	0x0F122012, //2012//70000BF6           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpening_iReduceEdgeMinMult [15:8]
	0x0F120204, //0204//70000BF8           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsharpmix1_iWideFiltReduce [15:8]
	0x0F123C03, //3C03//70000BFA           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd8a_iClustThresh_H_Bin [15:8]
	0x0F12013C, //013C//70000BFC           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a_iClustMulT_H_Bin [15:8]
	0x0F120101, //0101//70000BFE           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_nClustLevel_H_Bin [15:8]
	0x0F121C1E, //1C1E//70000C00           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_DispTH_High_Bin [15:8]
	0x0F121E22, //1E22//70000C02           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]
	0x0F120028, //0028//70000C04           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]
	0x0F12030A, //030A//70000C06           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]
	0x0F120214, //0214//70000C08           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]
	0x0F120E14, //0E14//70000C0A           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]
	0x0F12FF06, //FF06//70000C0C           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]
	0x0F120432, //0432//70000C0E           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]
	0x0F124052, //4052//70000C10           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sharpening_iHighSharpPower_Bin [15:8]
	0x0F12150C, //150C//70000C12           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Sharpening_iHighShDenoise_Bin [15:8]
	0x0F120440, //0440//70000C14           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]
	0x0F120302, //0302//70000C16           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]
	0x0F123C3C, //3C3C//70000C18           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a_iClustThresh_C_sBin [15:8]
	0x0F120101, //0101//70000C1A           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_iClustMulT_C_sBin [15:8]
	0x0F121E01, //1E01//70000C1C           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a_DispTH_Low_sBin [15:8]
	0x0F12221C, //221C//70000C1E           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_iDenThreshLow_sBin [15:8]
	0x0F12281E, //281E//70000C20           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]
	0x0F120A00, //0A00//70000C22           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]
	0x0F121403, //1403//70000C24           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]
	0x0F121402, //1402//70000C26           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]
	0x0F12060E, //060E//70000C28           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]
	0x0F1232FF, //32FF//70000C2A           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]
	0x0F125204, //5204//70000C2C           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sharpening_iLowSharpPower_sBin [15:8]
	0x0F120C40, //0C40//70000C2E           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_Sharpening_iLowShDenoise_sBin [15:8]
	0x0F124015, //4015//70000C30           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]
	0x0F120204, //0204//70000C32           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]
	0x0F120003, //0003//70000C34           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//70000C36
	0x0F120003, //0000//0000//70000C38//AFIT16_BRIGHTNESS
	0x0F120000, //0000//0000//70000C3A//AFIT16_CONTRAST
	0x0F120000, //0000//0000//70000C3C//AFIT16_SATURATION
	0x0F120000, //0000//0000//70000C3E//AFIT16_SHARP_BLUR
	0x0F120000, //0000//0000//70000C40//AFIT16_GLAMOUR
	0x0F1200C1, //00C1//00C1//70000C42//AFIT16_sddd8a_edge_high
	0x0F120000, //0000//0000//70000C44
	0x0F1203FF, //03FF//03FF//70000C46//AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//0008//70000C48//AFIT16_Sharpening_iReduceEdgeThresh
	0x0F120251, //0251//017C//70000C4A//AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//03FF//70000C4C//AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//000C//70000C4E//AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//0010//70000C50//AFIT16_demsharpmix1_iHighThreshold
	0x0F120032, //0032//0032//70000C52//AFIT16_demsharpmix1_iLowBright
	0x0F12028A, //028A//028A//70000C54//AFIT16_demsharpmix1_iHighBright
	0x0F120032, //0032//0032//70000C56//AFIT16_demsharpmix1_iLowSat
	0x0F1201F4, //01F4//01F4//70000C58//AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//0070//70000C5A//AFIT16_demsharpmix1_iTune
	0x0F120002, //0002//0002//70000C5C//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//0000//70000C5E//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//0320//70000C60//AFIT16_demsharpmix1_iHystCenter
	0x0F120044, //0044//0070//70000C62//AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//0014//70000C64//AFIT16_Sharpening_iHighSharpClamp
	0x0F120046, //0046//0046//70000C66//AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F120019, //0019//0019//70000C68//AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F120046, //0046//0046//70000C6A//AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F120019, //0019//0019//70000C6C//AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//0A24//70000C6E//AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh [15:8]
	0x0F121701, //1701//1701//70000C70//AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level [15:8]
	0x0F120229, //0229//0229//70000C72//AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8]
	0x0F120503, //0503//0503//70000C74//AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAllowed [15:8]
	0x0F12080F, //080F//0101//70000C76//AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotThreshLow [15:8]
	0x0F120808, //0808//0101//70000C78//AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iColdThreshLow [15:8]
	0x0F120000, //0000//0000//70000C7A//AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoisePower2 [15:8]
	0x0F1200FF, //00FF//02FF//70000C7C//AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [15:8]
	0x0F12012D, //012D//0396//70000C7E//AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadialPower [15:8]
	0x0F121414, //1414//1414//70000C80//AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]
	0x0F120301, //0301//0301//70000C82//AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHighSlopeThresh [15:8]
	0x0F120007, //0007//0007//70000C84//AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//1000//70000C86
	0x0F122003, //2003//2003//70000C88
	0x0F121020, //1020//1020//70000C8A
	0x0F120010, //0010//0010//70000C8C
	0x0F121EFF, //1EFF//1E80//70000C8E//AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_iMonochrom[15:8]
	0x0F121E06, //1E06//1E06//70000C90//AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosaicing_iDesatThresh[15:8]
	0x0F12060A, //060A//030C//70000C92//AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_iGRDenoiseVal[15:8]
	0x0F120306, //0306//0103//70000C94//AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaicing_iNearGrayDesat[15:8]
	0x0F128B0A, //8B0A//5A0A//70000C96//AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpening_iMSharpen[15:8]
	0x0F122837, //2837//2D00//70000C98//AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iWSharpen[15:8]
	0x0F120110, //0110//0100//70000C9A//AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nSharpWidth[15:8]
	0x0F12FF00, //FF00//FF00//70000C9C//AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpening_iShDespeckle[15:8]
	0x0F120200, //0200//0200//70000C9E//AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demsharpmix1_iFilterPower[15:8]
	0x0F121E10, //1E10//1E10//70000CA0//AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_iGCoeff[15:8]
	0x0F120000, //0000//0000//70000CA2//AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1_iNarrMult[15:8]
	0x0F120009, //0009//0009//70000CA4//AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpmix1_iHystMinMult[15:8]
	0x0F120406, //0406//0406//70000CA6//AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix1_iHystFallLow[15:8]
	0x0F120705, //0705//0705//70000CA8//AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharpmix1_iHystTune[15:8]
	0x0F120305, //0305//0305//70000CAA
	0x0F120609, //0609//0609//70000CAC
	0x0F122C07, //2C07//2C07//70000CAE
	0x0F12142C, //142C//142C//70000CB0
	0x0F120B18, //0B18//0B18//70000CB2//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F12800B, //800B//800B//70000CB4//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120080, //0080//0080//70000CB6//AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iDarkReduce [15:8]
	0x0F120080, //0080//0080//70000CB8//AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYOffset [15:8]
	0x0F120080, //0080//0080//70000CBA//AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSaturation [15:8]
	0x0F125050, //5050//0101//70000CBC//AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClustThresh_C [15:8]
	0x0F120101, //0101//0A0A//70000CBE//AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClustMulT_C [15:8]
	0x0F123201, //3201//3201//70000CC0//AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_DispTH_Low [15:8]
	0x0F121832, //1832//1428//70000CC2//AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenThreshLow [15:8]
	0x0F12210C, //210C//100C//70000CC4//AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing_iEdgeDesat [15:8]
	0x0F120A00, //0A00//0500//70000CC6//AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]
	0x0F121E04, //1E04//1E02//70000CC8//AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosaicing_iDemSharpenLow [15:8]
	0x0F120A08, //0A08//040C//70000CCA//AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demosaicing_iDemSharpThresh [15:8]
	0x0F12070C, //070C//0828//70000CCC//AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]
	0x0F123264, //3264//5064//70000CCE//AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaicing_iDemBlurHigh [15:8]
	0x0F125A02, //5A02//4605//70000CD0//AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpening_iLowSharpPower [15:8]
	0x0F121040, //1040//1E68//70000CD2//AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpening_iLowShDenoise [15:8]
	0x0F124012, //4012//201E//70000CD4//AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpening_iReduceEdgeMinMult [15:8]
	0x0F120604, //0604//0604//70000CD6//AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsharpmix1_iWideFiltReduce [15:8]
	0x0F124606, //4606//4606//70000CD8//AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd8a_iClustThresh_H_Bin [15:8]
	0x0F120146, //0146//0146//70000CDA//AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a_iClustMulT_H_Bin [15:8]
	0x0F120101, //0101//0101//70000CDC//AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_nClustLevel_H_Bin [15:8]
	0x0F121C18, //1C18//1C18//70000CDE//AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_DispTH_High_Bin [15:8]
	0x0F121819, //1819//1819//70000CE0//AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]
	0x0F120028, //0028//0028//70000CE2//AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]
	0x0F12030A, //030A//030A//70000CE4//AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]
	0x0F120514, //0514//0514//70000CE6//AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]
	0x0F120C14, //0C14//0C14//70000CE8//AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]
	0x0F12FF05, //FF05//FF05//70000CEA//AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]
	0x0F120432, //0432//0432//70000CEC//AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]
	0x0F124052, //4052//4052//70000CEE//AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sharpening_iHighSharpPower_Bin [15:8]
	0x0F121514, //1514//1514//70000CF0//AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Sharpening_iHighShDenoise_Bin [15:8]
	0x0F120440, //0440//0440//70000CF2//AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]
	0x0F120302, //0302//0302//70000CF4//AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]
	0x0F124646, //4646//4646//70000CF6//AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a_iClustThresh_C_sBin [15:8]
	0x0F120101, //0101//0101//70000CF8//AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_iClustMulT_C_sBin [15:8]
	0x0F121801, //1801//1801//70000CFA//AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a_DispTH_Low_sBin [15:8]
	0x0F12191C, //191C//191C//70000CFC//AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_iDenThreshLow_sBin [15:8]
	0x0F122818, //2818//2818//70000CFE//AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]
	0x0F120A00, //0A00//0A00//70000D00//AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]
	0x0F121403, //1403//1403//70000D02//AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]
	0x0F121405, //1405//1405//70000D04//AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]
	0x0F12050C, //050C//050C//70000D06//AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]
	0x0F1232FF, //32FF//32FF//70000D08//AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]
	0x0F125204, //5204//5204//70000D0A//AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sharpening_iLowSharpPower_sBin [15:8]
	0x0F121440, //1440//1440//70000D0C//AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_Sharpening_iLowShDenoise_sBin [15:8]
	0x0F124015, //4015//4015//70000D0E//AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]
	0x0F120204, //0204//0204//70000D10//AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]
	0x0F120003, //0003//0003//70000D12//AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//0001//70000D14

	0x0F12BA7A, //70000D16
	0x0F124FDE, //70000D18
	0x0F12137F, //70000D1A
	0x0F123BDE, //70000D1C
	0x0F122102, //70000D1E
	0x0F1200B5, //70000D20

	//===================================================================
	// Brightness setting
	//===================================================================
	0x002A1300,
	0x0F12019D,

	0x002A1306,
	0x0F120280,

};
#endif

static const u32 s5k5ccgx_camcorder_set[] = {
0xFCFCD000,
0x00287000,
0x002A01F6,
0x0F120800,	//REG_TC_GP_PrevReqInputWidth		//Sensor Crop Width	2048
0x0F120600,	//REG_TC_GP_PrevReqInputHeight	//Sensor Crop Height 1536
0x0F120000,	//REG_TC_GP_PrevInputWidthOfs		//Sensor HOffset 0
0x0F120000,	//REG_TC_GP_PrevInputHeightOfs	//Sensor VOffset 0
0x0F120800,	//REG_TC_GP_CapReqInputWidth		//Sensor Crop Width	2048
0x0F120600,	//REG_TC_GP_CapReqInputHeight		//Sensor Crop Height 1368
0x0F120000,	//REG_TC_GP_CapInputWidthOfs		//Sensor HOffset 0
0x0F120000,	//REG_TC_GP_CapInputHeightOfs		//Sensor VOffset 0
0x002A0216,
0x0F120001,	//REG_TC_GP_bUseReqInputInPre
0x0F120001,	//REG_TC_GP_bUseReqInputInCap


//Preview Size
0x002A0400,
0x0F120300,	//REG_0TC_PCFG_usWidth
0x0F1201E0,	//REG_0TC_PCFG_usHeight

0x002A029E,
0x0F120400,		//REG_2TC_PCFG_usWidth
0x0F120300,   //REG_2TC_PCFG_usHeight

//Capture Size
0x002A0330,
0x0F120800,	//REG_0TC_CCFG_usWidth
0x0F120600,	//REG_0TC_CCFG_usHeight

0x002A0388,
0x0F120800,   //REG_2TC_CCFG_usWidth
0x0F120600,   //REG_2TC_CCFG_usHeight

};

static const u32 s5k5ccgx_update_preview_reg[] = {
	//PREVIEW
	0x002A0208,
	0x0F120000, //REG_TC_GP_ActivePrevConfig
	0x002A0210,
	0x0F120000, //REG_TC_GP_ActiveCapConfig
	0x002A020C,
	0x0F120001, //REG_TC_GP_PrevOpenAfterChange
	0x002A01F4,
	0x0F120001, //REG_TC_GP_NewConfigSync
	0x002A020A,
	0x0F120001, //REG_TC_GP_PrevConfigChanged
	0x002A0212,
	0x0F120001, //REG_TC_GP_CapConfigChanged
	0x002A01E8,
	0x0F120000, //REG_TC_GP_EnableCapture
	0x0F120001, //REG_TC_GP_EnableCaptureChanged
	0xFFFF0064, //Delay 100ms
};

static const u32 s5k5ccgx_update_hd_preview_reg[] = {
	/* PREVIEW */
	0x002A0208,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0210,
	0x0F120000, /* REG_TC_GP_ActiveCapConfig */
	0x002A020C,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F4,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A020A,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A0212,
	0x0F120001, /* REG_TC_GP_CapConfigChanged */
	0x002A01E8,
	0x0F120000, /* REG_TC_GP_EnableCapture */
	0x0F120001, /* REG_TC_GP_EnableCaptureChanged */

	/* TNP_Regs_bUseAccurateFR */
	0x00287000,
	0x002A3FE4,
	0x0F120001, /* on/off TNP_Regs_bAccuDynamicFR */
	0x0F1234A2, /* on/off TNP_Regs_usMinAccuDynamicFrTme */
	0x0F1240FD, /* on/off TNP_Regs_usMaxAccuDynamicFrTme */

	0xFFFF0064, /* Delay 100ms */
};


static const u32 s5k5ccgx_stream_stop_reg[] = {
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120000,
	0x0F120001,
};

static const u32 s5k5ccgx_176_144_Preview[] = {
	0xFCFCD000, // 0601 update preview setting
	0x00287000,
	0x002A01F6,
	0x0F120738,
	0x0F120600,
	0x0F120064,
	0x0F120000,
	0x0F120738,
	0x0F120600,
	0x0F120064,
	0x0F120000,
	0x002A0216,
	0x0F120001,
	0x0F120001,
	0x002A0428,
	0x0F120001,
	0x0F1200B0,
	0x0F120090,
	0x0F120005,
	0x002A043C,
	0x0F120738,
	0x0F120600,
	0x0F120064,
	0x0F120000,
	0x002A023E, //Preview Size
	0x0F1200B0, //REG_0TC_PCFG_usWidth
	0x0F120090, //REG_0TC_PCFG_usHeight
	0x002A0D1E,
	0x0F122102,
};

static const u32 s5k5ccgx_320_240_Preview[] = {
	0x002A023E,
	0x0F120140,	//REG_0TC_PCFG_usWidth 320
	0x0F1200F0,	//REG_0TC_PCFG_usHeight 240
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_352_288_Preview[] = {
	0x002A023E,
	0x0F120160,	//REG_0TC_PCFG_usWidth 280
	0x0F120120,	//REG_0TC_PCFG_usHeight 1E0
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_528_432_Preview[] = {
	0xFCFCD000, // 0601 update preview setting
	0x00287000,
	0x002A01F6,
	0x0F120738,
	0x0F120600,
	0x0F120064,
	0x0F120000,
	0x0F120738,
	0x0F120600,
	0x0F120064,
	0x0F120000,
	0x002A0216,
	0x0F120001,
	0x0F120001,
	0x002A0428,
	0x0F120001,
	0x0F1200B0,
	0x0F120090,
	0x0F120005,
	0x002A043C,
	0x0F120738,
	0x0F120600,
	0x0F120064,
	0x0F120000,
	0x002A023E, //Preview Size
	0x0F120210, //REG_0TC_PCFG_usWidth
	0x0F1201B0, //REG_0TC_PCFG_usHeight
	0x002A0D1E,
	0x0F122102,
};

static const u32 s5k5ccgx_640_480_Preview[] = {
	0x002A023E,
	0x0F120280,	//REG_0TC_PCFG_usWidth 280
	0x0F1201E0,	//REG_0TC_PCFG_usHeight 1E0
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_720_480_Preview[] = {
	0x002A023E,
	0x0F1202D0,	//REG_0TC_PCFG_usWidth 280
	0x0F1201E0,	//REG_0TC_PCFG_usHeight 1E0
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_800_600_Preview[] = {
	0x002A023E,
	0x0F120320,	//REG_0TC_PCFG_usWidth 280
	0x0F120258,	//REG_0TC_PCFG_usHeight 1E0
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_1024_550_Preview[] = {
	0x002A023E,
	0x0F120400,	//REG_0TC_PCFG_usWidth 400
	0x0F120226,	//REG_0TC_PCFG_usHeight 226
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

#define S5K5CCGX_WIDE_PREVIEW_REG s5k5ccgx_1024_576_Preview
static const u32 s5k5ccgx_1024_576_Preview[] = {
	0x002A023E,
	0x0F120400,	//REG_0TC_PCFG_usWidth 400
	0x0F120240,	//REG_0TC_PCFG_usHeight 240
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_1024_616_Preview[] = {
	0x002A023E,
	0x0F120400,	//REG_0TC_PCFG_usWidth 400
	0x0F120268,	//REG_0TC_PCFG_usHeight 268
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_1024_768_Preview[] = {
	0x002A023E,
	0x0F120400,	//REG_0TC_PCFG_usWidth 280
	0x0F120300,	//REG_0TC_PCFG_usHeight 1E0
	0x0F120005,	//REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate
};

static const u32 s5k5ccgx_1280_1024_Preview[] = {

	//****************************************/
	0xFCFCD000,
	//****************************************/
	//===================================================================
	// History
	//===================================================================
	//20100717 : 1st release
	//20100806 : 2nd release for EVT0.1
	//20101028 : 3rd release for EVT1
	//WRITE #awbb_otp_disable  0000          //awb otp use
	//==========================================================================================
	//-->The below registers are for FACTORY ONLY. if you change them without prior notification
	//   YOU are RESPONSIBLE for the FAILURE that will happen in the future.
	//==========================================================================================
	//===================================================================
	// Reset & Trap and Patch
	//===================================================================

	// Start of Trap and Patch
	//  2010-08-11 13:53:35
	0x00100001,
	0x10300000,
	0x00140001,

	0xFFFF000A,     //p10
	// Start of Patch data
	0x00287000,
	0x002A352C,
	0x0F12B570,    // 7000352C
	0x0F124A24,    // 7000352E
	0x0F124924,    // 70003530
	0x0F124825,    // 70003532
	0x0F124B25,    // 70003534
	0x0F122500,    // 70003536
	0x0F12801D,    // 70003538
	0x0F12C004,    // 7000353A
	0x0F126001,    // 7000353C
	0x0F124924,    // 7000353E
	0x0F124824,    // 70003540
	0x0F12F000,    // 70003542
	0x0F12FBBD,    // 70003544
	0x0F124924,    // 70003546
	0x0F124824,    // 70003548
	0x0F12F000,    // 7000354A
	0x0F12FBB9,    // 7000354C
	0x0F124824,    // 7000354E
	0x0F124E24,    // 70003550
	0x0F126430,    // 70003552
	0x0F124924,    // 70003554
	0x0F124825,    // 70003556
	0x0F12F000,    // 70003558
	0x0F12FBB2,    // 7000355A
	0x0F124924,    // 7000355C
	0x0F120030,    // 7000355E
	0x0F123080,    // 70003560
	0x0F126141,    // 70003562
	0x0F124C23,    // 70003564
	0x0F128365,    // 70003566
	0x0F124923,    // 70003568
	0x0F124824,    // 7000356A
	0x0F12F000,    // 7000356C
	0x0F12FBA8,    // 7000356E
	0x0F124923,    // 70003570
	0x0F124824,    // 70003572
	0x0F12F000,    // 70003574
	0x0F12FBA4,    // 70003576
	0x0F124923,    // 70003578
	0x0F124824,    // 7000357A
	0x0F12F000,    // 7000357C
	0x0F12FBA0,    // 7000357E
	0x0F124923,    // 70003580
	0x0F124824,    // 70003582
	0x0F12F000,    // 70003584
	0x0F12FB9C,    // 70003586
	0x0F128125,    // 70003588
	0x0F124923,    // 7000358A
	0x0F124823,    // 7000358C
	0x0F12F000,    // 7000358E
	0x0F12FB97,    // 70003590
	0x0F124923,    // 70003592
	0x0F124823,    // 70003594
	0x0F12F000,    // 70003596
	0x0F12FB93,    // 70003598
	0x0F1283A5,    // 7000359A
	0x0F124922,    // 7000359C
	0x0F124823,    // 7000359E
	0x0F12F000,    // 700035A0
	0x0F12FB8E,    // 700035A2
	0x0F122101,    // 700035A4
	0x0F120349,    // 700035A6
	0x0F120020,    // 700035A8
	0x0F123020,    // 700035AA
	0x0F128041,    // 700035AC
	0x0F122185,    // 700035AE
	0x0F128081,    // 700035B0
	0x0F12491F,    // 700035B2
	0x0F1280C1,    // 700035B4
	0x0F12481F,    // 700035B6
	0x0F126730,    // 700035B8
	0x0F12BC70,    // 700035BA
	0x0F12BC08,    // 700035BC
	0x0F124718,    // 700035BE
	0x0F1200CA,    // 700035C0
	0x0F125CC1,    // 700035C2
	0x0F1203BD,    // 700035C4
	0x0F120000,    // 700035C6
	0x0F121C08,    // 700035C8
	0x0F127000,    // 700035CA
	0x0F123290,    // 700035CC
	0x0F127000,    // 700035CE
	0x0F123657,    // 700035D0
	0x0F127000,    // 700035D2
	0x0F12D9E7,    // 700035D4
	0x0F120000,    // 700035D6
	0x0F12383F,    // 700035D8
	0x0F127000,    // 700035DA
	0x0F12395D,    // 700035DC
	0x0F120000,    // 700035DE
	0x0F1238D1,    // 700035E0
	0x0F127000,    // 700035E2
	0x0F120000,    // 700035E4
	0x0F127000,    // 700035E6
	0x0F12399D,    // 700035E8
	0x0F127000,    // 700035EA
	0x0F12F903,    // 700035EC
	0x0F120000,    // 700035EE
	0x0F123AC1,    // 700035F0
	0x0F127000,    // 700035F2
	0x0F123FC8,    // 700035F4
	0x0F127000,    // 700035F6
	0x0F12368F,    // 700035F8
	0x0F127000,    // 700035FA
	0x0F12495F,    // 700035FC
	0x0F120000,    // 700035FE
	0x0F1236ED,    // 70003600
	0x0F127000,    // 70003602
	0x0F12E421,    // 70003604
	0x0F120000,    // 70003606
	0x0F1237AB,    // 70003608
	0x0F127000,    // 7000360A
	0x0F12216D,    // 7000360C
	0x0F120000,    // 7000360E
	0x0F12381F,    // 70003610
	0x0F127000,    // 70003612
	0x0F120179,    // 70003614
	0x0F120001,    // 70003616
	0x0F123BD5,    // 70003618
	0x0F127000,    // 7000361A
	0x0F1204C9,    // 7000361C
	0x0F120000,    // 7000361E
	0x0F123B25,    // 70003620
	0x0F127000,    // 70003622
	0x0F125027,    // 70003624
	0x0F120000,    // 70003626
	0x0F123BE1,    // 70003628
	0x0F127000,    // 7000362A
	0x0F1242B7,    // 7000362C
	0x0F120000,    // 7000362E
	0x0F1207FF,    // 70003630
	0x0F120000,    // 70003632
	0x0F123C5F,    // 70003634
	0x0F127000,    // 70003636
	0x0F12B570,    // 70003638
	0x0F12000D,    // 7000363A
	0x0F124CFC,    // 7000363C
	0x0F128821,    // 7000363E
	0x0F12F000,    // 70003640
	0x0F12FB46,    // 70003642
	0x0F128820,    // 70003644
	0x0F124AFB,    // 70003646
	0x0F120081,    // 70003648
	0x0F125055,    // 7000364A
	0x0F121C40,    // 7000364C
	0x0F128020,    // 7000364E
	0x0F12BC70,    // 70003650
	0x0F12BC08,    // 70003652
	0x0F124718,    // 70003654
	0x0F126801,    // 70003656
	0x0F120409,    // 70003658
	0x0F120C09,    // 7000365A
	0x0F126840,    // 7000365C
	0x0F120400,    // 7000365E
	0x0F120C00,    // 70003660
	0x0F124AF5,    // 70003662
	0x0F128992,    // 70003664
	0x0F122A00,    // 70003666
	0x0F12D00D,    // 70003668
	0x0F122300,    // 7000366A
	0x0F121A80,    // 7000366C
	0x0F12D400,    // 7000366E
	0x0F120003,    // 70003670
	0x0F120418,    // 70003672
	0x0F120C00,    // 70003674
	0x0F124BF1,    // 70003676
	0x0F121851,    // 70003678
	0x0F12891B,    // 7000367A
	0x0F12428B,    // 7000367C
	0x0F12D300,    // 7000367E
	0x0F12000B,    // 70003680
	0x0F120419,    // 70003682
	0x0F120C09,    // 70003684
	0x0F124AEE,    // 70003686
	0x0F128151,    // 70003688
	0x0F128190,    // 7000368A
	0x0F124770,    // 7000368C
	0x0F12B510,    // 7000368E
	0x0F124CEC,    // 70003690
	0x0F1248ED,    // 70003692
	0x0F1278A1,    // 70003694
	0x0F122900,    // 70003696
	0x0F12D101,    // 70003698
	0x0F1287C1,    // 7000369A
	0x0F12E004,    // 7000369C
	0x0F127AE1,    // 7000369E
	0x0F122900,    // 700036A0
	0x0F12D001,    // 700036A2
	0x0F122101,    // 700036A4
	0x0F1287C1,    // 700036A6
	0x0F12F000,    // 700036A8
	0x0F12FB1A,    // 700036AA
	0x0F1249E7,    // 700036AC
	0x0F128B08,    // 700036AE
	0x0F1206C2,    // 700036B0
	0x0F12D50A,    // 700036B2
	0x0F127AA2,    // 700036B4
	0x0F120652,    // 700036B6
	0x0F12D507,    // 700036B8
	0x0F122210,    // 700036BA
	0x0F124390,    // 700036BC
	0x0F128308,    // 700036BE
	0x0F1248E3,    // 700036C0
	0x0F127AE1,    // 700036C2
	0x0F126B00,    // 700036C4
	0x0F12F000,    // 700036C6
	0x0F12FB13,    // 700036C8
	0x0F1248DB,    // 700036CA
	0x0F1289C0,    // 700036CC
	0x0F122801,    // 700036CE
	0x0F12D109,    // 700036D0
	0x0F1278A0,    // 700036D2
	0x0F122800,    // 700036D4
	0x0F12D006,    // 700036D6
	0x0F127AE0,    // 700036D8
	0x0F122800,    // 700036DA
	0x0F12D003,    // 700036DC
	0x0F127AA0,    // 700036DE
	0x0F122140,    // 700036E0
	0x0F124308,    // 700036E2
	0x0F1272A0,    // 700036E4
	0x0F12BC10,    // 700036E6
	0x0F12BC08,    // 700036E8
	0x0F124718,    // 700036EA
	0x0F12B570,    // 700036EC
	0x0F124DD7,    // 700036EE
	0x0F124CD7,    // 700036F0
	0x0F128B28,    // 700036F2
	0x0F120701,    // 700036F4
	0x0F12D507,    // 700036F6
	0x0F122108,    // 700036F8
	0x0F124388,    // 700036FA
	0x0F128328,    // 700036FC
	0x0F1249D5,    // 700036FE
	0x0F126B20,    // 70003700
	0x0F126B89,    // 70003702
	0x0F12F000,    // 70003704
	0x0F12FAFC,    // 70003706
	0x0F128B28,    // 70003708
	0x0F1206C1,    // 7000370A
	0x0F12D5A0,    // 7000370C
	0x0F1249CD,    // 7000370E
	0x0F127A8A,    // 70003710
	0x0F120652,    // 70003712
	0x0F12D49C,    // 70003714
	0x0F122210,    // 70003716
	0x0F124390,    // 70003718
	0x0F128328,    // 7000371A
	0x0F127AC9,    // 7000371C
	0x0F126B20,    // 7000371E
	0x0F12F000,    // 70003720
	0x0F12FAE6,    // 70003722
	0x0F12E794,    // 70003724
	0x0F12B5F8,    // 70003726
	0x0F1249CB,    // 70003728
	0x0F128F08,    // 7000372A
	0x0F12000C,    // 7000372C
	0x0F123480,    // 7000372E
	0x0F122800,    // 70003730
	0x0F12D000,    // 70003732
	0x0F128360,    // 70003734
	0x0F122000,    // 70003736
	0x0F128708,    // 70003738
	0x0F124DC8,    // 7000373A
	0x0F1226FF,    // 7000373C
	0x0F128828,    // 7000373E
	0x0F121C76,    // 70003740
	0x0F122702,    // 70003742
	0x0F122803,    // 70003744
	0x0F12D112,    // 70003746
	0x0F128868,    // 70003748
	0x0F122800,    // 7000374A
	0x0F12D10F,    // 7000374C
	0x0F1288E8,    // 7000374E
	0x0F122800,    // 70003750
	0x0F12D10C,    // 70003752
	0x0F12F000,    // 70003754
	0x0F12FADC,    // 70003756
	0x0F122800,    // 70003758
	0x0F12D008,    // 7000375A
	0x0F128B60,    // 7000375C
	0x0F122800,    // 7000375E
	0x0F12D001,    // 70003760
	0x0F1280EE,    // 70003762
	0x0F1280AF,    // 70003764
	0x0F122001,    // 70003766
	0x0F127268,    // 70003768
	0x0F12F000,    // 7000376A
	0x0F12FAD9,    // 7000376C
	0x0F128828,    // 7000376E
	0x0F122802,    // 70003770
	0x0F12D10E,    // 70003772
	0x0F128868,    // 70003774
	0x0F122800,    // 70003776
	0x0F12D10B,    // 70003778
	0x0F1288E8,    // 7000377A
	0x0F122800,    // 7000377C
	0x0F12D108,    // 7000377E
	0x0F128B60,    // 70003780
	0x0F122800,    // 70003782
	0x0F12D001,    // 70003784
	0x0F1280EE,    // 70003786
	0x0F1280AF,    // 70003788
	0x0F122001,    // 7000378A
	0x0F127268,    // 7000378C
	0x0F12F000,    // 7000378E
	0x0F12FAC7,    // 70003790
	0x0F1288E8,    // 70003792
	0x0F122800,    // 70003794
	0x0F12D006,    // 70003796
	0x0F121FC1,    // 70003798
	0x0F1239FD,    // 7000379A
	0x0F12D003,    // 7000379C
	0x0F122001,    // 7000379E
	0x0F12BCF8,    // 700037A0
	0x0F12BC08,    // 700037A2
	0x0F124718,    // 700037A4
	0x0F122000,    // 700037A6
	0x0F12E7FA,    // 700037A8
	0x0F12B570,    // 700037AA
	0x0F124CAC,    // 700037AC
	0x0F128860,    // 700037AE
	0x0F122800,    // 700037B0
	0x0F12D00C,    // 700037B2
	0x0F128820,    // 700037B4
	0x0F124DA3,    // 700037B6
	0x0F122800,    // 700037B8
	0x0F12D009,    // 700037BA
	0x0F120029,    // 700037BC
	0x0F1231A0,    // 700037BE
	0x0F127AC9,    // 700037C0
	0x0F122900,    // 700037C2
	0x0F12D004,    // 700037C4
	0x0F127AA8,    // 700037C6
	0x0F122180,    // 700037C8
	0x0F124308,    // 700037CA
	0x0F1272A8,    // 700037CC
	0x0F12E73F,    // 700037CE
	0x0F122800,    // 700037D0
	0x0F12D003,    // 700037D2
	0x0F12F7FF,    // 700037D4
	0x0F12FFA7,    // 700037D6
	0x0F122800,    // 700037D8
	0x0F12D1F8,    // 700037DA
	0x0F122000,    // 700037DC
	0x0F128060,    // 700037DE
	0x0F128820,    // 700037E0
	0x0F122800,    // 700037E2
	0x0F12D003,    // 700037E4
	0x0F122008,    // 700037E6
	0x0F12F000,    // 700037E8
	0x0F12FAA2,    // 700037EA
	0x0F12E00B,    // 700037EC
	0x0F12489C,    // 700037EE
	0x0F123020,    // 700037F0
	0x0F128880,    // 700037F2
	0x0F122800,    // 700037F4
	0x0F12D103,    // 700037F6
	0x0F127AA8,    // 700037F8
	0x0F122101,    // 700037FA
	0x0F124308,    // 700037FC
	0x0F1272A8,    // 700037FE
	0x0F122010,    // 70003800
	0x0F12F000,    // 70003802
	0x0F12FA95,    // 70003804
	0x0F128820,    // 70003806
	0x0F122800,    // 70003808
	0x0F12D1E0,    // 7000380A
	0x0F12488A,    // 7000380C
	0x0F1289C0,    // 7000380E
	0x0F122801,    // 70003810
	0x0F12D1DC,    // 70003812
	0x0F127AA8,    // 70003814
	0x0F1221BF,    // 70003816
	0x0F124008,    // 70003818
	0x0F1272A8,    // 7000381A
	0x0F12E718,    // 7000381C
	0x0F126800,    // 7000381E
	0x0F124990,    // 70003820
	0x0F128188,    // 70003822
	0x0F124890,    // 70003824
	0x0F122201,    // 70003826
	0x0F128981,    // 70003828
	0x0F124890,    // 7000382A
	0x0F120252,    // 7000382C
	0x0F124291,    // 7000382E
	0x0F12D902,    // 70003830
	0x0F122102,    // 70003832
	0x0F128181,    // 70003834
	0x0F124770,    // 70003836
	0x0F122101,    // 70003838
	0x0F128181,    // 7000383A
	0x0F124770,    // 7000383C
	0x0F12B5F1,    // 7000383E
	0x0F124E80,    // 70003840
	0x0F128834,    // 70003842
	0x0F122C00,    // 70003844
	0x0F12D03F,    // 70003846
	0x0F122001,    // 70003848
	0x0F122C08,    // 7000384A
	0x0F12D000,    // 7000384C
	0x0F122000,    // 7000384E
	0x0F1270B0,    // 70003850
	0x0F124D7F,    // 70003852
	0x0F122800,    // 70003854
	0x0F12D009,    // 70003856
	0x0F12F000,    // 70003858
	0x0F12FA72,    // 7000385A
	0x0F120028,    // 7000385C
	0x0F1238F0,    // 7000385E
	0x0F126328,    // 70003860
	0x0F127AB0,    // 70003862
	0x0F12217E,    // 70003864
	0x0F124008,    // 70003866
	0x0F1272B0,    // 70003868
	0x0F12E00F,    // 7000386A
	0x0F124F7A,    // 7000386C
	0x0F123780,    // 7000386E
	0x0F128B78,    // 70003870
	0x0F122800,    // 70003872
	0x0F12D005,    // 70003874
	0x0F12F000,    // 70003876
	0x0F12FA6B,    // 70003878
	0x0F122000,    // 7000387A
	0x0F128378,    // 7000387C
	0x0F124976,    // 7000387E
	0x0F128708,    // 70003880
	0x0F122000,    // 70003882
	0x0F12F000,    // 70003884
	0x0F12FA6C,    // 70003886
	0x0F124879,    // 70003888
	0x0F126328,    // 7000388A
	0x0F1278B1,    // 7000388C
	0x0F122700,    // 7000388E
	0x0F120038,    // 70003890
	0x0F122900,    // 70003892
	0x0F12D008,    // 70003894
	0x0F124972,    // 70003896
	0x0F123920,    // 70003898
	0x0F128ACA,    // 7000389A
	0x0F122A00,    // 7000389C
	0x0F12D003,    // 7000389E
	0x0F128B09,    // 700038A0
	0x0F122900,    // 700038A2
	0x0F12D000,    // 700038A4
	0x0F122001,    // 700038A6
	0x0F127170,    // 700038A8
	0x0F122C02,    // 700038AA
	0x0F12D102,    // 700038AC
	0x0F124868,    // 700038AE
	0x0F123860,    // 700038B0
	0x0F126328,    // 700038B2
	0x0F122201,    // 700038B4
	0x0F122C02,    // 700038B6
	0x0F12D000,    // 700038B8
	0x0F122200,    // 700038BA
	0x0F124861,    // 700038BC
	0x0F122110,    // 700038BE
	0x0F12300A,    // 700038C0
	0x0F12F000,    // 700038C2
	0x0F12FA55,    // 700038C4
	0x0F128037,    // 700038C6
	0x0F129900,    // 700038C8
	0x0F120020,    // 700038CA
	0x0F12600C,    // 700038CC
	0x0F12E767,    // 700038CE
	0x0F12B538,    // 700038D0
	0x0F124865,    // 700038D2
	0x0F124669,    // 700038D4
	0x0F123848,    // 700038D6
	0x0F12F000,    // 700038D8
	0x0F12FA52,    // 700038DA
	0x0F124A5E,    // 700038DC
	0x0F124862,    // 700038DE
	0x0F128F51,    // 700038E0
	0x0F122400,    // 700038E2
	0x0F123020,    // 700038E4
	0x0F122900,    // 700038E6
	0x0F12D00A,    // 700038E8
	0x0F128754,    // 700038EA
	0x0F126941,    // 700038EC
	0x0F126451,    // 700038EE
	0x0F126491,    // 700038F0
	0x0F12466B,    // 700038F2
	0x0F128819,    // 700038F4
	0x0F1287D1,    // 700038F6
	0x0F12885B,    // 700038F8
	0x0F120011,    // 700038FA
	0x0F123140,    // 700038FC
	0x0F12800B,    // 700038FE
	0x0F128F91,    // 70003900
	0x0F122900,    // 70003902
	0x0F12D002,    // 70003904
	0x0F128794,    // 70003906
	0x0F126940,    // 70003908
	0x0F126490,    // 7000390A
	0x0F12F000,    // 7000390C
	0x0F12FA40,    // 7000390E
	0x0F12BC38,    // 70003910
	0x0F12BC08,    // 70003912
	0x0F124718,    // 70003914
	0x0F12B5F8,    // 70003916
	0x0F124C56,    // 70003918
	0x0F1289E0,    // 7000391A
	0x0F12F000,    // 7000391C
	0x0F12FA40,    // 7000391E
	0x0F120006,    // 70003920
	0x0F128A20,    // 70003922
	0x0F12F000,    // 70003924
	0x0F12FA44,    // 70003926
	0x0F120007,    // 70003928
	0x0F12484F,    // 7000392A
	0x0F124D4A,    // 7000392C
	0x0F123020,    // 7000392E
	0x0F126CA9,    // 70003930
	0x0F126940,    // 70003932
	0x0F121809,    // 70003934
	0x0F120200,    // 70003936
	0x0F12F000,    // 70003938
	0x0F12FA42,    // 7000393A
	0x0F120400,    // 7000393C
	0x0F120C00,    // 7000393E
	0x0F12002A,    // 70003940
	0x0F12326E,    // 70003942
	0x0F120011,    // 70003944
	0x0F12390A,    // 70003946
	0x0F122305,    // 70003948
	0x0F12F000,    // 7000394A
	0x0F12FA3F,    // 7000394C
	0x0F124C43,    // 7000394E
	0x0F1261A0,    // 70003950
	0x0F128FEB,    // 70003952
	0x0F120002,    // 70003954
	0x0F120031,    // 70003956
	0x0F120018,    // 70003958
	0x0F12F000,    // 7000395A
	0x0F12FA3F,    // 7000395C
	0x0F12466B,    // 7000395E
	0x0F120005,    // 70003960
	0x0F128018,    // 70003962
	0x0F12483C,    // 70003964
	0x0F1269A2,    // 70003966
	0x0F123040,    // 70003968
	0x0F128800,    // 7000396A
	0x0F120039,    // 7000396C
	0x0F12F000,    // 7000396E
	0x0F12FA35,    // 70003970
	0x0F12466B,    // 70003972
	0x0F120006,    // 70003974
	0x0F128058,    // 70003976
	0x0F120021,    // 70003978
	0x0F129800,    // 7000397A
	0x0F12311C,    // 7000397C
	0x0F12F000,    // 7000397E
	0x0F12FA35,    // 70003980
	0x0F124935,    // 70003982
	0x0F123180,    // 70003984
	0x0F12808D,    // 70003986
	0x0F1280CE,    // 70003988
	0x0F128BA1,    // 7000398A
	0x0F124836,    // 7000398C
	0x0F123820,    // 7000398E
	0x0F128001,    // 70003990
	0x0F128BE1,    // 70003992
	0x0F128041,    // 70003994
	0x0F128C21,    // 70003996
	0x0F128081,    // 70003998
	0x0F12E701,    // 7000399A
	0x0F12B5F8,    // 7000399C
	0x0F124E2E,    // 7000399E
	0x0F126C70,    // 700039A0
	0x0F126CB1,    // 700039A2
	0x0F120200,    // 700039A4
	0x0F12F000,    // 700039A6
	0x0F12FA0B,    // 700039A8
	0x0F120400,    // 700039AA
	0x0F120C00,    // 700039AC
	0x0F122401,    // 700039AE
	0x0F120364,    // 700039B0
	0x0F1242A0,    // 700039B2
	0x0F12D200,    // 700039B4
	0x0F120004,    // 700039B6
	0x0F124A27,    // 700039B8
	0x0F120020,    // 700039BA
	0x0F12327E,    // 700039BC
	0x0F121F91,    // 700039BE
	0x0F122303,    // 700039C0
	0x0F12F000,    // 700039C2
	0x0F12FA03,    // 700039C4
	0x0F120405,    // 700039C6
	0x0F120C2D,    // 700039C8
	0x0F124A23,    // 700039CA
	0x0F120020,    // 700039CC
	0x0F12325A,    // 700039CE
	0x0F120011,    // 700039D0
	0x0F12390A,    // 700039D2
	0x0F122305,    // 700039D4
	0x0F12F000,    // 700039D6
	0x0F12F9F9,    // 700039D8
	0x0F12491F,    // 700039DA
	0x0F1264C8,    // 700039DC
	0x0F12491F,    // 700039DE
	0x0F124E21,    // 700039E0
	0x0F1288C8,    // 700039E2
	0x0F122701,    // 700039E4
	0x0F122800,    // 700039E6
	0x0F12D009,    // 700039E8
	0x0F124C23,    // 700039EA
	0x0F1238FF,    // 700039EC
	0x0F121E40,    // 700039EE
	0x0F12D00A,    // 700039F0
	0x0F122804,    // 700039F2
	0x0F12D042,    // 700039F4
	0x0F122806,    // 700039F6
	0x0F12D101,    // 700039F8
	0x0F122000,    // 700039FA
	0x0F1280C8,    // 700039FC
	0x0F1282B7,    // 700039FE
	0x0F122001,    // 70003A00
	0x0F12F000,    // 70003A02
	0x0F12F9FB,    // 70003A04
	0x0F12E6CB,    // 70003A06
	0x0F12000D,    // 70003A08
	0x0F12724F,    // 70003A0A
	0x0F122001,    // 70003A0C
	0x0F12F000,    // 70003A0E
	0x0F12F9FD,    // 70003A10
	0x0F12F000,    // 70003A12
	0x0F12FA03,    // 70003A14
	0x0F124910,    // 70003A16
	0x0F123148,    // 70003A18
	0x0F12C903,    // 70003A1A
	0x0F124348,    // 70003A1C
	0x0F120A00,    // 70003A1E
	0x0F126160,    // 70003A20
	0x0F1220FF,    // 70003A22
	0x0F121D40,    // 70003A24
	0x0F1280E8,    // 70003A26
	0x0F12480C,    // 70003A28
	0x0F123040,    // 70003A2A
	0x0F127707,    // 70003A2C
	0x0F12E7E6,    // 70003A2E
	0x0F123290,    // 70003A30
	0x0F127000,    // 70003A32
	0x0F123294,    // 70003A34
	0x0F127000,    // 70003A36
	0x0F1204A8,    // 70003A38
	0x0F127000,    // 70003A3A
	0x0F1215DC,    // 70003A3C
	0x0F127000,    // 70003A3E
	0x0F125000,    // 70003A40
	0x0F12D000,    // 70003A42
	0x0F121E84,    // 70003A44
	0x0F127000,    // 70003A46
	0x0F121BE4,    // 70003A48
	0x0F127000,    // 70003A4A
	0x0F122EA8,    // 70003A4C
	0x0F127000,    // 70003A4E
	0x0F1221A4,    // 70003A50
	0x0F127000,    // 70003A52
	0x0F120100,    // 70003A54
	0x0F127000,    // 70003A56
	0x0F123F48,    // 70003A58
	0x0F127000,    // 70003A5A
	0x0F1231A0,    // 70003A5C
	0x0F127000,    // 70003A5E
	0x0F1201E8,    // 70003A60
	0x0F127000,    // 70003A62
	0x0F12F2A0,    // 70003A64
	0x0F12D000,    // 70003A66
	0x0F122A44,    // 70003A68
	0x0F127000,    // 70003A6A
	0x0F12F400,    // 70003A6C
	0x0F12D000,    // 70003A6E
	0x0F122024,    // 70003A70
	0x0F127000,    // 70003A72
	0x0F121650,    // 70003A74
	0x0F127000,    // 70003A76
	0x0F122A64,    // 70003A78
	0x0F127000,    // 70003A7A
	0x0F124982,    // 70003A7C
	0x0F12724F,    // 70003A7E
	0x0F1220FF,    // 70003A80
	0x0F121DC0,    // 70003A82
	0x0F1280C8,    // 70003A84
	0x0F12F000,    // 70003A86
	0x0F12F9D1,    // 70003A88
	0x0F124980,    // 70003A8A
	0x0F126ACA,    // 70003A8C
	0x0F12604A,    // 70003A8E
	0x0F122800,    // 70003A90
	0x0F12D006,    // 70003A92
	0x0F12436A,    // 70003A94
	0x0F120001,    // 70003A96
	0x0F120010,    // 70003A98
	0x0F12F000,    // 70003A9A
	0x0F12F991,    // 70003A9C
	0x0F126160,    // 70003A9E
	0x0F12E001,    // 70003AA0
	0x0F12436A,    // 70003AA2
	0x0F126162,    // 70003AA4
	0x0F128BF0,    // 70003AA6
	0x0F122800,    // 70003AA8
	0x0F12D001,    // 70003AAA
	0x0F12F7FF,    // 70003AAC
	0x0F12FF33,    // 70003AAE
	0x0F122000,    // 70003AB0
	0x0F12F000,    // 70003AB2
	0x0F12F9AB,    // 70003AB4
	0x0F124974,    // 70003AB6
	0x0F1220FF,    // 70003AB8
	0x0F121DC0,    // 70003ABA
	0x0F1280C8,    // 70003ABC
	0x0F12E79E,    // 70003ABE
	0x0F12B510,    // 70003AC0
	0x0F12F000,    // 70003AC2
	0x0F12F9BB,    // 70003AC4
	0x0F124870,    // 70003AC6
	0x0F1288C0,    // 70003AC8
	0x0F121FC1,    // 70003ACA
	0x0F1239FD,    // 70003ACC
	0x0F12D103,    // 70003ACE
	0x0F12496F,    // 70003AD0
	0x0F1220FF,    // 70003AD2
	0x0F121C40,    // 70003AD4
	0x0F128048,    // 70003AD6
	0x0F12E605,    // 70003AD8
	0x0F12B5F8,    // 70003ADA
	0x0F122400,    // 70003ADC
	0x0F124D6D,    // 70003ADE
	0x0F12486D,    // 70003AE0
	0x0F12210E,    // 70003AE2
	0x0F128041,    // 70003AE4
	0x0F122101,    // 70003AE6
	0x0F128001,    // 70003AE8
	0x0F12F000,    // 70003AEA
	0x0F12F9AF,    // 70003AEC
	0x0F12486B,    // 70003AEE
	0x0F128840,    // 70003AF0
	0x0F12F000,    // 70003AF2
	0x0F12F9B3,    // 70003AF4
	0x0F124E6A,    // 70003AF6
	0x0F12270D,    // 70003AF8
	0x0F12073F,    // 70003AFA
	0x0F1219E8,    // 70003AFC
	0x0F128803,    // 70003AFE
	0x0F1200E2,    // 70003B00
	0x0F121991,    // 70003B02
	0x0F12804B,    // 70003B04
	0x0F128843,    // 70003B06
	0x0F1252B3,    // 70003B08
	0x0F128882,    // 70003B0A
	0x0F1280CA,    // 70003B0C
	0x0F1288C0,    // 70003B0E
	0x0F128088,    // 70003B10
	0x0F123508,    // 70003B12
	0x0F12042D,    // 70003B14
	0x0F120C2D,    // 70003B16
	0x0F121C64,    // 70003B18
	0x0F120424,    // 70003B1A
	0x0F120C24,    // 70003B1C
	0x0F122C07,    // 70003B1E
	0x0F12D3EC,    // 70003B20
	0x0F12E63D,    // 70003B22
	0x0F12B5F0,    // 70003B24
	0x0F12B085,    // 70003B26
	0x0F126801,    // 70003B28
	0x0F129103,    // 70003B2A
	0x0F126881,    // 70003B2C
	0x0F12040A,    // 70003B2E
	0x0F120C12,    // 70003B30
	0x0F12495C,    // 70003B32
	0x0F128B89,    // 70003B34
	0x0F122900,    // 70003B36
	0x0F12D001,    // 70003B38
	0x0F120011,    // 70003B3A
	0x0F12E000,    // 70003B3C
	0x0F122100,    // 70003B3E
	0x0F129102,    // 70003B40
	0x0F126840,    // 70003B42
	0x0F120401,    // 70003B44
	0x0F129803,    // 70003B46
	0x0F120C09,    // 70003B48
	0x0F12F000,    // 70003B4A
	0x0F12F98F,    // 70003B4C
	0x0F124854,    // 70003B4E
	0x0F123080,    // 70003B50
	0x0F128900,    // 70003B52
	0x0F122800,    // 70003B54
	0x0F12D039,    // 70003B56
	0x0F122100,    // 70003B58
	0x0F124854,    // 70003B5A
	0x0F124D52,    // 70003B5C
	0x0F124684,    // 70003B5E
	0x0F124B53,    // 70003B60
	0x0F124C4F,    // 70003B62
	0x0F1288DA,    // 70003B64
	0x0F120048,    // 70003B66
	0x0F1200D7,    // 70003B68
	0x0F12193E,    // 70003B6A
	0x0F12197F,    // 70003B6C
	0x0F12183F,    // 70003B6E
	0x0F125A36,    // 70003B70
	0x0F128AFF,    // 70003B72
	0x0F12437E,    // 70003B74
	0x0F1200B6,    // 70003B76
	0x0F120C37,    // 70003B78
	0x0F121906,    // 70003B7A
	0x0F123680,    // 70003B7C
	0x0F128177,    // 70003B7E
	0x0F121C52,    // 70003B80
	0x0F1200D2,    // 70003B82
	0x0F121914,    // 70003B84
	0x0F121952,    // 70003B86
	0x0F121812,    // 70003B88
	0x0F125A24,    // 70003B8A
	0x0F128AD2,    // 70003B8C
	0x0F124354,    // 70003B8E
	0x0F1200A2,    // 70003B90
	0x0F120C12,    // 70003B92
	0x0F128272,    // 70003B94
	0x0F12891C,    // 70003B96
	0x0F12895B,    // 70003B98
	0x0F124367,    // 70003B9A
	0x0F12435A,    // 70003B9C
	0x0F121943,    // 70003B9E
	0x0F123340,    // 70003BA0
	0x0F1289DB,    // 70003BA2
	0x0F129C02,    // 70003BA4
	0x0F1218BA,    // 70003BA6
	0x0F124363,    // 70003BA8
	0x0F1218D2,    // 70003BAA
	0x0F120212,    // 70003BAC
	0x0F120C12,    // 70003BAE
	0x0F12466B,    // 70003BB0
	0x0F12521A,    // 70003BB2
	0x0F124663,    // 70003BB4
	0x0F127DDB,    // 70003BB6
	0x0F12435A,    // 70003BB8
	0x0F129B03,    // 70003BBA
	0x0F120252,    // 70003BBC
	0x0F120C12,    // 70003BBE
	0x0F12521A,    // 70003BC0
	0x0F121C49,    // 70003BC2
	0x0F120409,    // 70003BC4
	0x0F120C09,    // 70003BC6
	0x0F122904,    // 70003BC8
	0x0F12D3C9,    // 70003BCA
	0x0F12B005,    // 70003BCC
	0x0F12BCF0,    // 70003BCE
	0x0F12BC08,    // 70003BD0
	0x0F124718,    // 70003BD2
	0x0F12B510,    // 70003BD4
	0x0F12F7FF,    // 70003BD6
	0x0F12FF80,    // 70003BD8
	0x0F12F000,    // 70003BDA
	0x0F12F94F,    // 70003BDC
	0x0F12E582,    // 70003BDE
	0x0F12B570,    // 70003BE0
	0x0F126804,    // 70003BE2
	0x0F12F000,    // 70003BE4
	0x0F12F952,    // 70003BE6
	0x0F124D32,    // 70003BE8
	0x0F128C29,    // 70003BEA
	0x0F121A40,    // 70003BEC
	0x0F1242A0,    // 70003BEE
	0x0F12D901,    // 70003BF0
	0x0F120020,    // 70003BF2
	0x0F12E003,    // 70003BF4
	0x0F12F000,    // 70003BF6
	0x0F12F949,    // 70003BF8
	0x0F128C29,    // 70003BFA
	0x0F121A40,    // 70003BFC
	0x0F126268,    // 70003BFE
	0x0F12F000,    // 70003C00
	0x0F12F94C,    // 70003C02
	0x0F1262A8,    // 70003C04
	0x0F12F000,    // 70003C06
	0x0F12F951,    // 70003C08
	0x0F126328,    // 70003C0A
	0x0F128869,    // 70003C0C
	0x0F122900,    // 70003C0E
	0x0F12D000,    // 70003C10
	0x0F1262A8,    // 70003C12
	0x0F124828,    // 70003C14
	0x0F126B00,    // 70003C16
	0x0F128C00,    // 70003C18
	0x0F122800,    // 70003C1A
	0x0F12D11B,    // 70003C1C
	0x0F126AA8,    // 70003C1E
	0x0F12F000,    // 70003C20
	0x0F12F94C,    // 70003C22
	0x0F1261E8,    // 70003C24
	0x0F124A1E,    // 70003C26
	0x0F123280,    // 70003C28
	0x0F128B91,    // 70003C2A
	0x0F122900,    // 70003C2C
	0x0F12D00B,    // 70003C2E
	0x0F120011,    // 70003C30
	0x0F123120,    // 70003C32
	0x0F128809,    // 70003C34
	0x0F124288,    // 70003C36
	0x0F12D907,    // 70003C38
	0x0F1261E9,    // 70003C3A
	0x0F128C28,    // 70003C3C
	0x0F121A08,    // 70003C3E
	0x0F1262A8,    // 70003C40
	0x0F12F000,    // 70003C42
	0x0F12F92B,    // 70003C44
	0x0F1262A8,    // 70003C46
	0x0F12E502,    // 70003C48
	0x0F128BD1,    // 70003C4A
	0x0F124288,    // 70003C4C
	0x0F12D800,    // 70003C4E
	0x0F120008,    // 70003C50
	0x0F1261E8,    // 70003C52
	0x0F12E4FC,    // 70003C54
	0x0F12F000,    // 70003C56
	0x0F12F919,    // 70003C58
	0x0F1261E8,    // 70003C5A
	0x0F12E4F8,    // 70003C5C
	0x0F12B510,    // 70003C5E
	0x0F12F000,    // 70003C60
	0x0F12F934,    // 70003C62
	0x0F12480E,    // 70003C64
	0x0F1230A0,    // 70003C66
	0x0F128841,    // 70003C68
	0x0F122900,    // 70003C6A
	0x0F12D007,    // 70003C6C
	0x0F124A07,    // 70003C6E
	0x0F123280,    // 70003C70
	0x0F126953,    // 70003C72
	0x0F124A11,    // 70003C74
	0x0F12428B,    // 70003C76
	0x0F12D202,    // 70003C78
	0x0F128880,    // 70003C7A
	0x0F1281D0,    // 70003C7C
	0x0F12E532,    // 70003C7E
	0x0F1288C0,    // 70003C80
	0x0F1281D0,    // 70003C82
	0x0F12E52F,    // 70003C84
	0x0F120000,    // 70003C86
	0x0F1231A0,    // 70003C88
	0x0F127000,    // 70003C8A
	0x0F1229E4,    // 70003C8C
	0x0F127000,    // 70003C8E
	0x0F12C100,    // 70003C90
	0x0F12D000,    // 70003C92
	0x0F12A006,    // 70003C94
	0x0F120000,    // 70003C96
	0x0F12A000,    // 70003C98
	0x0F12D000,    // 70003C9A
	0x0F12064C,    // 70003C9C
	0x0F127000,    // 70003C9E
	0x0F123F48,    // 70003CA0
	0x0F127000,    // 70003CA2
	0x0F1207C4,    // 70003CA4
	0x0F127000,    // 70003CA6
	0x0F1207E8,    // 70003CA8
	0x0F127000,    // 70003CAA
	0x0F122B24,    // 70003CAC
	0x0F127000,    // 70003CAE
	0x0F121FA0,    // 70003CB0
	0x0F127000,    // 70003CB2
	0x0F121E3C,    // 70003CB4
	0x0F127000,    // 70003CB6
	0x0F1221A4,    // 70003CB8
	0x0F127000,    // 70003CBA
	0x0F12E200,    // 70003CBC
	0x0F12D000,    // 70003CBE
	0x0F124778,    // 70003CC0
	0x0F1246C0,    // 70003CC2
	0x0F12C000,    // 70003CC4
	0x0F12E59F,    // 70003CC6
	0x0F12FF1C,    // 70003CC8
	0x0F12E12F,    // 70003CCA
	0x0F121F63,    // 70003CCC
	0x0F120001,    // 70003CCE
	0x0F124778,    // 70003CD0
	0x0F1246C0,    // 70003CD2
	0x0F12C000,    // 70003CD4
	0x0F12E59F,    // 70003CD6
	0x0F12FF1C,    // 70003CD8
	0x0F12E12F,    // 70003CDA
	0x0F121EDF,    // 70003CDC
	0x0F120001,    // 70003CDE
	0x0F124778,    // 70003CE0
	0x0F1246C0,    // 70003CE2
	0x0F12C000,    // 70003CE4
	0x0F12E59F,    // 70003CE6
	0x0F12FF1C,    // 70003CE8
	0x0F12E12F,    // 70003CEA
	0x0F12495F,    // 70003CEC
	0x0F120000,    // 70003CEE
	0x0F124778,    // 70003CF0
	0x0F1246C0,    // 70003CF2
	0x0F12C000,    // 70003CF4
	0x0F12E59F,    // 70003CF6
	0x0F12FF1C,    // 70003CF8
	0x0F12E12F,    // 70003CFA
	0x0F12E403,    // 70003CFC
	0x0F120000,    // 70003CFE
	0x0F124778,    // 70003D00
	0x0F1246C0,    // 70003D02
	0x0F12C000,    // 70003D04
	0x0F12E59F,    // 70003D06
	0x0F12FF1C,    // 70003D08
	0x0F12E12F,    // 70003D0A
	0x0F1224B3,    // 70003D0C
	0x0F120001,    // 70003D0E
	0x0F124778,    // 70003D10
	0x0F1246C0,    // 70003D12
	0x0F12C000,    // 70003D14
	0x0F12E59F,    // 70003D16
	0x0F12FF1C,    // 70003D18
	0x0F12E12F,    // 70003D1A
	0x0F12EECD,    // 70003D1C
	0x0F120000,    // 70003D1E
	0x0F124778,    // 70003D20
	0x0F1246C0,    // 70003D22
	0x0F12C000,    // 70003D24
	0x0F12E59F,    // 70003D26
	0x0F12FF1C,    // 70003D28
	0x0F12E12F,    // 70003D2A
	0x0F12F049,    // 70003D2C
	0x0F120000,    // 70003D2E
	0x0F124778,    // 70003D30
	0x0F1246C0,    // 70003D32
	0x0F12C000,    // 70003D34
	0x0F12E59F,    // 70003D36
	0x0F12FF1C,    // 70003D38
	0x0F12E12F,    // 70003D3A
	0x0F1212DF,    // 70003D3C
	0x0F120000,    // 70003D3E
	0x0F124778,    // 70003D40
	0x0F1246C0,    // 70003D42
	0x0F12C000,    // 70003D44
	0x0F12E59F,    // 70003D46
	0x0F12FF1C,    // 70003D48
	0x0F12E12F,    // 70003D4A
	0x0F12F05B,    // 70003D4C
	0x0F120000,    // 70003D4E
	0x0F124778,    // 70003D50
	0x0F1246C0,    // 70003D52
	0x0F12C000,    // 70003D54
	0x0F12E59F,    // 70003D56
	0x0F12FF1C,    // 70003D58
	0x0F12E12F,    // 70003D5A
	0x0F12F07B,    // 70003D5C
	0x0F120000,    // 70003D5E
	0x0F124778,    // 70003D60
	0x0F1246C0,    // 70003D62
	0x0F12C000,    // 70003D64
	0x0F12E59F,    // 70003D66
	0x0F12FF1C,    // 70003D68
	0x0F12E12F,    // 70003D6A
	0x0F12FE6D,    // 70003D6C
	0x0F120000,    // 70003D6E
	0x0F124778,    // 70003D70
	0x0F1246C0,    // 70003D72
	0x0F12C000,    // 70003D74
	0x0F12E59F,    // 70003D76
	0x0F12FF1C,    // 70003D78
	0x0F12E12F,    // 70003D7A
	0x0F123295,    // 70003D7C
	0x0F120000,    // 70003D7E
	0x0F124778,    // 70003D80
	0x0F1246C0,    // 70003D82
	0x0F12C000,    // 70003D84
	0x0F12E59F,    // 70003D86
	0x0F12FF1C,    // 70003D88
	0x0F12E12F,    // 70003D8A
	0x0F12234F,    // 70003D8C
	0x0F120000,    // 70003D8E
	0x0F124778,    // 70003D90
	0x0F1246C0,    // 70003D92
	0x0F12C000,    // 70003D94
	0x0F12E59F,    // 70003D96
	0x0F12FF1C,    // 70003D98
	0x0F12E12F,    // 70003D9A
	0x0F124521,    // 70003D9C
	0x0F120000,    // 70003D9E
	0x0F124778,    // 70003DA0
	0x0F1246C0,    // 70003DA2
	0x0F12C000,    // 70003DA4
	0x0F12E59F,    // 70003DA6
	0x0F12FF1C,    // 70003DA8
	0x0F12E12F,    // 70003DAA
	0x0F127C0D,    // 70003DAC
	0x0F120000,    // 70003DAE
	0x0F124778,    // 70003DB0
	0x0F1246C0,    // 70003DB2
	0x0F12C000,    // 70003DB4
	0x0F12E59F,    // 70003DB6
	0x0F12FF1C,    // 70003DB8
	0x0F12E12F,    // 70003DBA
	0x0F127C2B,    // 70003DBC
	0x0F120000,    // 70003DBE
	0x0F124778,    // 70003DC0
	0x0F1246C0,    // 70003DC2
	0x0F12F004,    // 70003DC4
	0x0F12E51F,    // 70003DC6
	0x0F1224C4,    // 70003DC8
	0x0F120001,    // 70003DCA
	0x0F124778,    // 70003DCC
	0x0F1246C0,    // 70003DCE
	0x0F12C000,    // 70003DD0
	0x0F12E59F,    // 70003DD2
	0x0F12FF1C,    // 70003DD4
	0x0F12E12F,    // 70003DD6
	0x0F123183,    // 70003DD8
	0x0F120000,    // 70003DDA
	0x0F124778,    // 70003DDC
	0x0F1246C0,    // 70003DDE
	0x0F12C000,    // 70003DE0
	0x0F12E59F,    // 70003DE2
	0x0F12FF1C,    // 70003DE4
	0x0F12E12F,    // 70003DE6
	0x0F12302F,    // 70003DE8
	0x0F120000,    // 70003DEA
	0x0F124778,    // 70003DEC
	0x0F1246C0,    // 70003DEE
	0x0F12C000,    // 70003DF0
	0x0F12E59F,    // 70003DF2
	0x0F12FF1C,    // 70003DF4
	0x0F12E12F,    // 70003DF6
	0x0F12EF07,    // 70003DF8
	0x0F120000,    // 70003DFA
	0x0F124778,    // 70003DFC
	0x0F1246C0,    // 70003DFE
	0x0F12C000,    // 70003E00
	0x0F12E59F,    // 70003E02
	0x0F12FF1C,    // 70003E04
	0x0F12E12F,    // 70003E06
	0x0F1248FB,    // 70003E08
	0x0F120000,    // 70003E0A
	0x0F124778,    // 70003E0C
	0x0F1246C0,    // 70003E0E
	0x0F12C000,    // 70003E10
	0x0F12E59F,    // 70003E12
	0x0F12FF1C,    // 70003E14
	0x0F12E12F,    // 70003E16
	0x0F12F0B1,    // 70003E18
	0x0F120000,    // 70003E1A
	0x0F124778,    // 70003E1C
	0x0F1246C0,    // 70003E1E
	0x0F12C000,    // 70003E20
	0x0F12E59F,    // 70003E22
	0x0F12FF1C,    // 70003E24
	0x0F12E12F,    // 70003E26
	0x0F12EEDF,    // 70003E28
	0x0F120000,    // 70003E2A
	0x0F124778,    // 70003E2C
	0x0F1246C0,    // 70003E2E
	0x0F12C000,    // 70003E30
	0x0F12E59F,    // 70003E32
	0x0F12FF1C,    // 70003E34
	0x0F12E12F,    // 70003E36
	0x0F12AEF1,    // 70003E38
	0x0F120000,    // 70003E3A
	0x0F124778,    // 70003E3C
	0x0F1246C0,    // 70003E3E
	0x0F12C000,    // 70003E40
	0x0F12E59F,    // 70003E42
	0x0F12FF1C,    // 70003E44
	0x0F12E12F,    // 70003E46
	0x0F1202EB,    // 70003E48
	0x0F120001,    // 70003E4A
	0x0F124778,    // 70003E4C
	0x0F1246C0,    // 70003E4E
	0x0F12C000,    // 70003E50
	0x0F12E59F,    // 70003E52
	0x0F12FF1C,    // 70003E54
	0x0F12E12F,    // 70003E56
	0x0F12FD21,    // 70003E58
	0x0F120000,    // 70003E5A
	0x0F124778,    // 70003E5C
	0x0F1246C0,    // 70003E5E
	0x0F12C000,    // 70003E60
	0x0F12E59F,    // 70003E62
	0x0F12FF1C,    // 70003E64
	0x0F12E12F,    // 70003E66
	0x0F12FDAF,    // 70003E68
	0x0F120000,    // 70003E6A
	0x0F124778,    // 70003E6C
	0x0F1246C0,    // 70003E6E
	0x0F12C000,    // 70003E70
	0x0F12E59F,    // 70003E72
	0x0F12FF1C,    // 70003E74
	0x0F12E12F,    // 70003E76
	0x0F125027,    // 70003E78
	0x0F120000,    // 70003E7A
	0x0F124778,    // 70003E7C
	0x0F1246C0,    // 70003E7E
	0x0F12C000,    // 70003E80
	0x0F12E59F,    // 70003E82
	0x0F12FF1C,    // 70003E84
	0x0F12E12F,    // 70003E86
	0x0F1204C9,    // 70003E88
	0x0F120000,    // 70003E8A
	0x0F124778,    // 70003E8C
	0x0F1246C0,    // 70003E8E
	0x0F12C000,    // 70003E90
	0x0F12E59F,    // 70003E92
	0x0F12FF1C,    // 70003E94
	0x0F12E12F,    // 70003E96
	0x0F1239DF,    // 70003E98
	0x0F120000,    // 70003E9A
	0x0F124778,    // 70003E9C
	0x0F1246C0,    // 70003E9E
	0x0F12C000,    // 70003EA0
	0x0F12E59F,    // 70003EA2
	0x0F12FF1C,    // 70003EA4
	0x0F12E12F,    // 70003EA6
	0x0F126177,    // 70003EA8
	0x0F120000,    // 70003EAA
	0x0F124778,    // 70003EAC
	0x0F1246C0,    // 70003EAE
	0x0F12C000,    // 70003EB0
	0x0F12E59F,    // 70003EB2
	0x0F12FF1C,    // 70003EB4
	0x0F12E12F,    // 70003EB6
	0x0F12424F,    // 70003EB8
	0x0F120000,    // 70003EBA
	0x0F124778,    // 70003EBC
	0x0F1246C0,    // 70003EBE
	0x0F12C000,    // 70003EC0
	0x0F12E59F,    // 70003EC2
	0x0F12FF1C,    // 70003EC4
	0x0F12E12F,    // 70003EC6
	0x0F123F0D,    // 70003EC8
	0x0F120000,    // 70003ECA
	0x0F124778,    // 70003ECC
	0x0F1246C0,    // 70003ECE
	0x0F12C000,    // 70003ED0
	0x0F12E59F,    // 70003ED2
	0x0F12FF1C,    // 70003ED4
	0x0F12E12F,    // 70003ED6
	0x0F1202B9,    // 70003ED8
	0x0F120001,    // 70003EDA
	// End of Patch Data(Last : 70003EDAh)
	// Total Size 2480 (09B0)
	// Addr : 352C , Size : 2478(9AEh)
	0x10000001,

	0x0028D000,
	0x002A0070,
	0x0F120007,         // clks_src_gf_force_enable

	//	TNP_USER_MBCV_CONTROL
	//	TNP_FLS_SEC_CONFIG
	//	TNP_SINGLE_FRAME_CAPTURE
	//	TNP_CAPTURE_DONE_INFO
	//	TNP_5CC_SENSOR_TUNE
	//	TNP_GAS_ALPHA_OTP
	//	TNP_FR_ACCURATE_DYNAMIC
	//	TNP_ADLC_TUNE

	//MBCV Control
	0x00287000,
	0x002A04B4,
	0x0F120064,

	// AFIT by Normalized Brightness Tuning parameter
	0x00287000,
	0x002A3302,
	0x0F120000, // on/off AFIT by NB option

	0x0F120005, // NormBR[0]
	0x0F120019, // NormBR[1]
	0x0F120050, // NormBR[2]
	0x0F120300, // NormBR[3]
	0x0F120375, // NormBR[4]

	// Flash
	0x002A3F82,
	0x0F120000,	// TNP_Regs_PreflashStart
	0x0F120000,	// TNP_Regs_PreflashEnd
	0x0F120260,	// TNP_Regs_PreWP_r
	0x0F120240, // TNP_Regs_PreWP_b

	0x002A3F98,	// BR Tuning
	0x0F120100,	// TNP_Regs_BrRatioIn_0_
	0x0F120150,
	0x0F120200,
	0x0F120300,
	0x0F120400,

	0x0F120100,	// TNP_Regs_BrRatioOut_0_
	0x0F1200A0,
	0x0F120080,
	0x0F120040,
	0x0F120020,

	0x0F120030,	// WP Tuning
	0x0F120040,	// TNP_Regs_WPThresTbl_0_
	0x0F120048,
	0x0F120050,
	0x0F120060,

	0x0F120100,	// TNP_Regs_WPWeightTbl_0_
	0x0F1200C0,
	0x0F120080,
	0x0F12000A,
	0x0F120000,

	0x0F120120,	// T_BR tune
	0x0F120150,	// TNP_Regs_FlBRIn_0_
	0x0F120200,

	0x0F12003C,	//TNP_Regs_FlBRInOut_0_
	0x0F12003B,
	0x0F12002E,

	0x002A0430,	//REG_TC_FLS_Mode
	0x0F120002,
	0x002A3F80,	//TNP_Regs_FastFlashAlg
	0x0F120000,

	0x002A165E,
	0x0F120235,           //0244 0258 AWB R point          //0258 0245 0258
	0x0F12024A,           //024D 0220 AWB B point          //0220 0245 0245


	//         //         //         //         //         //         //         //         //
	// Analog & APS settings         //         //         //         //         //         //
	// This register is for FACTORY ONLY. If you change it without prior notification         //
	// YOU are RESPONSIBLE for the FAILURE that will happen in the future         //         //
	//         //         //         //         //         //         //         //         //

	//========================================================================================
	// 5CC EVT0 analog register setting
	// '10.07.14. Initial Draft
	// '10.07.24. sE404=0000 -> 1FC0 (Depedestal 0 -> -64d)
	// '10.08.16. sF410=0001 -> 0000 (for SHBN)
	// '10.08.25. sF438=0020 -> 0002 (VTGSL=2.96V) by APS
	//            sF43A=0020 -> 0001 (VRG=2.83V) by APS
	// '10.09.28. sF402=1F02 -> 3F02 ([13]: pixel bias powerdown according to HADR) for Darkshadi
	//		    sF416=0000 -> 0001 (AAC_EN enable) for Darkshading
	//========================================================================================
	//============================= Analog & APS Control =====================================
	0x0028D000,
	0x002AF2AC,
	0x0F120100, // analog gain; 0200 x16 0100 x8 0080 x4 0040 x2 0020 x1
	0x002AF400,
	0x0F12001D, // ldb_en[4] ld_en[3] clp_en[2](N/A) smp_en[1] dshut_en[0]
	0x0F123F02, // cds_test[15:0]; refer to the ATOP_TEST_INFORMATION.

	0x002AF40A,
	0x0F120054, // adc_sat[7:0]=84d (500mV)
	0x0F120002, // ms[2:0]; 2h@Normal 2h@PLA 1h@CNT.AVG
	0x0F120008, // rmp_option[7:0]; [3]SL_Low_PWR_SAVE On
	0x0F120000, // msoff_en; No MS if gain gain is lower than x2
	0x0F1200A4, // rmp_init[7:0]

	0x002AF416,
	0x0F120001, // dbs_option[11:4] dbs_mode[3:2] dbs_bist_en[1] aac_en[0]

	0x002AF41E,
	0x0F120065, // comp2_bias[7:4] comp1_bias[3:0]

	0x002AF422,
	0x0F120005, // pix_bias[3:0]

	0x002AF426,
	0x0F1200D4, // clp_lvl[7:0]

	0x002AF42A,
	0x0F120001, // ref_option[7:0]; [4]OB_PIX monit en [3]Clamp monit en [2]Monit amp en [1]Clamp

	0x002AF42E,
	0x0F120406, // fb_lv[11:10] pd_fblv[9] capa_ctrl_en[8] pd_inrush_ctrl[7] pd_reg_ntg[6] pd_reg

	0x002AF434,
	0x0F120003, // dbr_clk_sel[1:0]; PLL_mode=3h ROSC_mode=0h
	0x0F120004, // reg_tune_pix[7:0]
	0x0F120002, // reg_tune_tgsl[7:0] (2.96V)
	0x0F120001, // reg_tune_rg[7:0] (2.83V)
	0x0F120004, // reg_tune_ntg[7:0]

	0x002AF446,
	0x0F120000, // blst_en_cintr[15:0]

	0x002AF466,
	0x0F120000, // srx_en[0]

	0x002A0054,
	0x0F120028, // pll_pd[10](0:enable 1:disable) div_clk_en[0](0:enable 1:disable)
	0x0F128888, // div_dbr[7:4]

	0x002AF132,
	0x0F120206, // tgr_frame_decription 4
	0x002AF152,
	0x0F120206, // tgr_frame_decription 7
	0x002AF1A2,
	0x0F120200, // tgr_frame_params_descriptor_3
	0x002AF1B2,
	0x0F120202, // tgr_frame_params_descriptor_6
	//===========================================================================================

	//============================= Line-ADLC Tuning ============================================
	0x002AE412,
	0x0F120008, // adlc_tune_offset_gr[7:0]
	0x0F120008, // adlc_tune_offset_r[7:0]
	0x0F120010, // adlc_tune_offset_b[7:0]
	0x0F120010, // adlc_tune_offset_gb[7:0]
	0x002AE42E,
	0x0F120004, // adlc_qec[2:0]
	//===========================================================================================

	//===================================================================
	// AWB white locus setting - Have to be written after TnP
	//===================================================================
	0x00287000,
	0x002A1014,
	0x0F120132, //0138//awbb_IntcR
	0x0F12010A, //011C//awbb_IntcB

	//===================================================================
	// AF
	//===================================================================
	//1. AF interface setting
	0x002A01A2,
	0x0F120003,          //REG_TC_IPRM_CM_Init_AfModeType        // VCM_I2C actuator
	0x0F120000,          //REG_TC_IPRM_CM_Init_PwmConfig1       // No PWM
	0x0F120000,          //REG_TC_IPRM_CM_Init_PwmConfig2
	0x0F120041,          //REG_TC_IPRM_CM_Init_GpioConfig1        // Use GPIO_4 for enable port
	0x0F120000,          //REG_TC_IPRM_CM_Init_GpioConfig2
	0x0F122A0C,          //REG_TC_IPRM_CM_Init_Mi2cBits        // Use GPIO_5 for SCL GPIO_6 for S
	0x0F120190,          //REG_TC_IPRM_CM_Init_Mi2cRateKhz        // MI2C Speed : 400KHz

	//2. AF window setting
	0x002A022C,
	0x0F120100, //REG_TC_AF_FstWinStartX
	0x0F1200E3, //REG_TC_AF_FstWinStartY
	0x0F120200, //REG_TC_AF_FstWinSizeX
	0x0F120238, //REG_TC_AF_FstWinSizeY
	0x0F12018C, //REG_TC_AF_ScndWinStartX
	0x0F120166, //REG_TC_AF_ScndWinStartY
	0x0F1200E6, //REG_TC_AF_ScndWinSizeX
	0x0F120132, //REG_TC_AF_ScndWinSizeY
	0x0F120001, //REG_TC_AF_WinSizesUpdated

	//3. AF Fine Search Settings
	0x002A063A,
	0x0F1200C0,          //#skl_af_StatOvlpExpFactor
	0x002A064A,
	0x0F120000, //0000          //#skl_af_bAfStatOff
	0x002A1488,
	0x0F120000,          //#af_search_usAeStable
	0x002A1494,
	0x0F121002, //#af_search_usSingleAfFlags 1000- fine search disable 1002- fine search on
	0x002A149E,
	0x0F120003,          //#af_search_usFinePeakCount
	0x0F120000,          //#af_search_usFineMaxScale
	0x002A142C,
	0x0F120602, //#af_pos_usFineStepNumSize
	0x002A14A2,
	0x0F120000,          //#af_search_usCapturePolicy 0000 : Shutter_Priority_Current

	//4.  AF Peak Threshold Setting
	0x002A1498,
	0x0F120003, //#af_search_usMinPeakSamples
	0x002A148A,
	0x0F1200CC, //#af_search_usPeakThr  for 80%
	0x0F1200A0,          //#af_search_usPeakThrLow

	//5.  AF Default Position
	0x002A1420,
	0x0F120000, //#af_pos_usHomePos
	0x0F12952F, //#af_pos_usLowConfPos

	//6. AF statistics
	0x002A14B4,
	0x0F120280,          //#af_search_usConfThr_4_  LowEdgeBoth GRAD
	0x002A14C0,
	0x0F1203A0,          //#af_search_usConfThr_10_ LowLight HPF
	0x0F120320,          //#af_search_usConfThr_11_
	0x002A14F4,
	0x0F120030,          //#af_stat_usMinStatVal
	0x002A1514,
	0x0F120060,          //#af_scene_usSceneLowNormBrThr
	// AF Scene Settings
	0x002A151E,
	0x0F120003,          //#af_scene_usSaturatedScene

	//7. AF Lens Position Table Settings
	0x002A1434,
	0x0F120010,           //#af_pos_usTableLastInd 10h + 1h = 17 Steps

	0x0F120030,           //#af_pos_usTable_0_  48
	0x0F120033,           //#af_pos_usTable_1_  51
	0x0F120036,           //#af_pos_usTable_2_  54
	0x0F120039,           //#af_pos_usTable_3_  57
	0x0F12003D,           //#af_pos_usTable_4_  61
	0x0F120041,           //#af_pos_usTable_5_  65
	0x0F120045,           //#af_pos_usTable_6_  69
	0x0F120049,           //#af_pos_usTable_7_  73
	0x0F12004E,           //#af_pos_usTable_8_  78
	0x0F120053,           //#af_pos_usTable_9_  83
	0x0F120059,           //#af_pos_usTable_10_ 89
	0x0F120060,           //#af_pos_usTable_11_ 104
	0x0F120068,           //#af_pos_usTable_12_ 109
	0x0F120072,           //#af_pos_usTable_13_ 114
	0x0F12007D,           //#af_pos_usTable_14_ 125
	0x0F120089,           //#af_pos_usTable_15_ 137
	0x0F120096,           //#af_pos_usTable_16_ 150

	//8. VCM AF driver with PWM/I2C
	0x002A1558,
	0x0F128000,          //#afd_usParam[0]  I2C power down command
	0x0F120006,          //#afd_usParam[1]  Position Right Shift
	0x0F123FF0,          //#afd_usParam[2]  I2C Data Mask
	0x0F1203E8,          //#afd_usParam[3]  PWM Period
	0x0F120000,          //#afd_usParam[4]  PWM Divider
	0x0F120020,          //#afd_usParam[5]  SlowMotion Delay    reduce lens collision noise.
	0x0F120008,          //#afd_usParam[6]  SlowMotion Threshold
	0x0F120008,          //#afd_usParam[7]  Signal Shaping
	0x0F120040,          //#afd_usParam[8]  Signal Shaping level
	0x0F120080,          //#afd_usParam[9]  Signal Shaping level
	0x0F1200C0,          //#afd_usParam[10] Signal Shaping level
	0x0F1200E0,          //#afd_usParam[11] Signal Shaping level

	0x002A0224,
	0x0F120003, //REG_TC_AF_AfCmd//Initialize AF subsystem (AF driver AF algorithm)

	//===================================================================
	// Flash setting
	//===================================================================
	0x002A018C,
	0x0F120001, //REG_TC_IPRM_AuxConfig// bit[0] : Flash is in use bit[1] : Mechanical shutter is
	0x0F120003, //REG_TC_IPRM_AuxPolarity// bit[0] : Flash polarity (1 is active high) bit[1] : M
	0x0F120003, //REG_TC_IPRM_AuxGpios//1-4 : Flash GPIO number If GPIO number is overaped with A

	//===================================================================
	// 1-H timing setting
	//===================================================================
	0x002A1686,
	0x0F12005C, //senHal_uAddColsBin
	0x0F12005C, //senHal_uAddColsNoBin
	0x0F12085C, //senHal_uMinColsHorBin
	0x0F12005C, //senHal_uMinColsNoHorBin
	0x0F12025A, //senHal_uMinColsAddAnalogBin

	//===================================================================
	// Forbidden area setting
	//===================================================================
	0x002A1844,
	0x0F120000,                   //senHal_bSRX                  //SRX off

	0x002A1680,
	0x0F120002,                   //senHal_NExpLinesCheckFine                  //0004

	0x002A0ED2,
	0x0F120FA0,	                  //setot_uOnlineClocksDiv40

	//===================================================================
	// Preview subsampling mode
	//===================================================================
	0x002A18F8,
	0x0F120001,                   //senHal_bAACActiveWait2Start
	0x002A18F6,
	0x0F120001,                   //senHal_bAlwaysAAC
	0x002A182C,
	0x0F120001,                   //senHal_bSenAAC
	0x002A0EE4,
	0x0F120001,                   //setot_bUseDigitalHbin
	0x002A1674,
	0x0F120002,                   //senHal_SenBinFactor                  // 2:2x2 4:4x4
	0x0F120002,                   //senHal_SamplingType                  // 0:Full 1:digital 2:PL
	0x0F120000,                   //senHal_SamplingMode                  // 0:2x2	1:4x4

	//===================================================================
	// PLL setting for Max frequency (EVT0.1) 2010.08.05 - Do not remove
	//===================================================================
	0x002A19AE,
	0x0F12EA60,                   //pll_uMaxSysFreqKhz
	0x0F127530,                   //pll_uMaxPVIFreq4KH
	0x002A19C2,
	0x0F127530,                   //pll_uMaxMIPIFreq4KH
	0x002A0244,
	0x0F127530,                   //REG_0TC_PCFG_usMaxOut4KHzRate
	0x002A0336,
	0x0F127530,                   //REG_0TC_CCFG_usMaxOut4KHzRate

	//===================================================================
	// Init Parameters
	//===================================================================
	//MCLK
	0x002A0188,
	0x0F125DC0,                   //REG_TC_IPRM_InClockLSBs
	0x0F120000,                   //REG_TC_IPRM_InClockMSBs
	0x002A01B2,
	0x0F120001,                   //REG_TC_IPRM_UseNPviClocks
	0x0F120002,                   //REG_TC_IPRM_UseNMipiClocks
	0x002A01B8,
	0x0F120001,                   //REG_TC_IPRM_bBlockInternalPllCalc                  //1:pll by


	//SCLK & PCLK                    // clock set 0
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98
	0x0F1254F8,	                  //57E4	                  //61A8

	//SCLK & PCLK                    // clock set 1
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98
	0x0F1254F8,	                  //57E4	                  //61A8

	//SCLK & PCLK                    // clock set 2
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98
	0x0F1254F8,	                  //57E4	                  //61A8

	0x002A1B78,
	0x0F1238A4,                           //  REGM_gSensorClocks_0__PLL_usClkFreqDiv4
	0x0F120074,                           //  REGM_gSensorClocks_0__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_0__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_0__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_0__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_0__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_SysDiv
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_0__PLL_PllHW_PviDiv
	0x0F120006,                           //  REGM_gSensorClocks_0__PLL_PllHW_DblDiv
	0x0F12000C,                           //  REGM_gSensorClocks_0__PLL_PllHW_OIF_dphy_val
	0x0F125DC0,                           //  REGM_gSensorClocks_0__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_0__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_0__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_0__usOIFDenum

	0x002A1B9C,
	0x0F1238A4,                           //  REGM_gSensorClocks_1__PLL_usClkFreqDiv4
	0x0F120074,                           //  REGM_gSensorClocks_1__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_1__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_1__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_1__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_1__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_SysDiv
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_1__PLL_PllHW_PviDiv
	0x0F120006,                           //  REGM_gSensorClocks_1__PLL_PllHW_DblDiv
	0x0F12000C,                           //  REGM_gSensorClocks_1__PLL_PllHW_OIF_dphy_val
	0x0F125DC0,                           //  REGM_gSensorClocks_1__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_1__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_1__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_1__usOIFDenum

	0x002A1BC0,
	0x0F1238A4,                           //  REGM_gSensorClocks_2__PLL_usClkFreqDiv4
	0x0F120074,                           //  REGM_gSensorClocks_2__PLL_PllHW_M
	0x0F120004,                           //  REGM_gSensorClocks_2__PLL_PllHW_P
	0x0F120000,                           //  REGM_gSensorClocks_2__PLL_PllHW_S
	0x0F120002,                           //  REGM_gSensorClocks_2__PLL_PllHW_VS
	0x0F120003,                           //  REGM_gSensorClocks_2__PLL_PllHW_VP
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_SysDiv
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_OS
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_OP
	0x0F120001,                           //  REGM_gSensorClocks_2__PLL_PllHW_PviDiv
	0x0F120006,                           //  REGM_gSensorClocks_2__PLL_PllHW_DblDiv
	0x0F12000C,                           //  REGM_gSensorClocks_2__PLL_PllHW_OIF_dphy_val
	0x0F125DC0,                           //  REGM_gSensorClocks_2__InputClk
	0x0F120000,
	0x0F1254F6,                           //  REGM_gSensorClocks_2__usPviFreqDiv4
	0x0F12000C,                           //  REGM_gSensorClocks_2__usSysDiv
	0x0F120001,                           //  REGM_gSensorClocks_2__usOIFDenum


	0x002A01CC,
	0x0F120001,                   //REG_TC_IPRM_InitParamsUpdated

	0xFFFF000A,     //p10


	//===================================================================
	// Input Width & Height
	//===================================================================
	0x002A01F6,
	0x0F120800, //REG_TC_GP_PrevReqInputWidth	//Sensor Crop Width	2048
	0x0F120600, //REG_TC_GP_PrevReqInputHeight//Sensor Crop Height 1536
	0x0F120000, //REG_TC_GP_PrevInputWidthOfs	//Sensor HOffset 0
	0x0F120000, //REG_TC_GP_PrevInputHeightOfs//Sensor VOffset 0
	0x0F120800, //REG_TC_GP_CapReqInputWidth	//Sensor Crop Width	2048
	0x0F120600, //REG_TC_GP_CapReqInputHeight	//Sensor Crop Height 1536
	0x0F120000, //REG_TC_GP_CapInputWidthOfs	//Sensor HOffset 0
	0x0F120000, //REG_TC_GP_CapInputHeightOfs	//Sensor VOffset 0

	0x002A0216,
	0x0F120001, //REG_TC_GP_bUseReqInputInPre
	0x0F120001, //REG_TC_GP_bUseReqInputInCap

	0x002A043C,
	0x0F120800, //REG_TC_PZOOM_ZoomInputWidth
	0x0F120600, //REG_TC_PZOOM_ZoomInputHeight
	0x0F120000, //REG_TC_PZOOM_ZoomInputWidthOfs
	0x0F120000, //REG_TC_PZOOM_ZoomInputHeightOfs

	//===================================================================
	// Preview 0 640 480 system 52M PCLK 87M
	//===================================================================
	0x002A023E,
	0x0F120500, //REG_0TC_PCFG_usWidth
	0x0F120400, //REG_0TC_PCFG_usHeight
	0x0F120005, //REG_0TC_PCFG_Format
	0x0F1254F6,	//REG_0TC_PCFG_usMaxOut4KHzRate
	0x0F1254F6,	//REG_0TC_PCFG_usMinOut4KHzRate

	0x002A024C,
	0x0F120012, //REG_0TC_PCFG_PVIMask    => cmk 2010.10.29 s0042 => s0052 Invert Y C order
	0x0F120010, //REG_0TC_PCFG_OIFMask

	0x002A0254,
	0x0F120001, //REG_0TC_PCFG_uClockInd
	0x0F120000, //REG_0TC_PCFG_usFrTimeType
	0x0F120002, //REG_0TC_PCFG_FrRateQualityType
	0x0F120535, //REG_0TC_PCFG_usMaxFrTimeMsecMult10//max frame time : 30fps 014D 15fps 029a; a6a
	0x0F12029A, //REG_0TC_PCFG_usMinFrTimeMsecMult10//min frame time : 30fps 014D 15fps 029a; a6a

	0x0F120000, //REG_0TC_PCFG_bSmearOutput
	0x0F120000, //REG_0TC_PCFG_sSaturation
	0x0F120000, //REG_0TC_PCFG_sSharpBlur
	0x0F120000, //REG_0TC_PCFG_sColorTemp
	0x0F120000, //REG_0TC_PCFG_uDeviceGammaIndex
	0x0F120003, //REG_0TC_PCFG_uPrevMirror
	0x0F120003, //REG_0TC_PCFG_uCaptureMirror
	0x0F120000, //REG_0TC_PCFG_uRotation


	//===================================================================
	// Capture 0 2048x1536 system 52M PCLK 87M
	//===================================================================

	0x002A032E,
	0x0F120000,                   //REG_0TC_CCFG_uCaptureMode

	0x0F120800,                   //REG_0TC_CCFG_usWidth
	0x0F120600,                   //REG_0TC_CCFG_usHeight
	0x0F120005,                   //REG_0TC_CCFG_Format                              //PCAM 5:YUV
	0x0F1254F6,	                  //REG_0TC_CCFG_usMaxOut4KHzRate
	0x0F1254F6,	                  //REG_0TC_CCFG_usMinOut4KHzRate

	0x002A033E,
	0x0F120010,                   //REG_0TC_CCFG_PVIMask        => cmk 2010.10.29 s0042 => s0052
	0x0F120010,                   //REG_0TC_CCFG_OIFMask
	0x0F1203C0,                   //REG_0TC_CCFG_usJpegPacketSize

	0x002A0346,
	0x0F120001,                   //REG_0TC_CCFG_uClockInd
	0x0F120002,                   //REG_0TC_CCFG_usFrTimeType
	0x0F120002,                   //REG_0TC_CCFG_FrRateQualityType
	0x0F120535,                   //REG_0TC_CCFG_usMaxFrTimeMsecMult10
	0x0F12029A,                   //REG_0TC_CCFG_usMinFrTimeMsecMult10
	0x0F120000,                   //REG_0TC_CCFG_bSmearOutput
	0x0F120000,                   //REG_0TC_CCFG_sSaturation
	0x0F120000,                   //REG_0TC_CCFG_sSharpBlur
	0x0F120000,                   //REG_0TC_CCFG_sColorTemp
	0x0F120000,                   //REG_0TC_CCFG_uDeviceGammaIndex

	0x002A0426,
	0x0F120055,                   //REG_TC_BRC_usCaptureQuality


	0x002A1E5C,            //Mon_LT_uDefMinFrExpDelta
	0x0F120000,


	//===================================================================
	// AFC
	//===================================================================
	//Auto
	0x002A0F08,
	0x0F120000, //AFC_Default60Hz   01:60hz 00:50Hz
	0x002A04A4,
	0x0F12067F, //REG_TC_DBG_AutoAlgEnBits 065f : Manual AFC on   067f : Manual AFC off

	//===================================================================
	// Shading (AF module)
	//===================================================================
	// TVAR_ash_pGAS_high
	0x002A0D22,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,

	// TVAR_ash_pGAS_low
	0x0F126E49,
	0x0F12FB98,
	0x0F12F348,
	0x0F121BD6,
	0x0F12EBEF,
	0x0F1203D3,
	0x0F12EC8D,
	0x0F12F239,
	0x0F120E64,
	0x0F12F7EA,
	0x0F12FD3B,
	0x0F120A7C,
	0x0F12FC9C,
	0x0F120BD3,
	0x0F12F2E5,
	0x0F120619,
	0x0F120772,
	0x0F12F0B0,
	0x0F12184E,
	0x0F12F95F,
	0x0F120B1A,
	0x0F12FC45,
	0x0F12F716,
	0x0F120DCD,
	0x0F12EF24,
	0x0F120221,
	0x0F12F6BD,
	0x0F1204CB,
	0x0F1200B1,
	0x0F12FEB0,
	0x0F120268,
	0x0F1202C7,
	0x0F12010A,
	0x0F12FF93,
	0x0F12036D,
	0x0F12F859,
	0x0F1281D0,
	0x0F12FA32,
	0x0F12EFDB,
	0x0F12234D,
	0x0F12E799,
	0x0F120337,
	0x0F12EB05,
	0x0F12E8F9,
	0x0F12152E,
	0x0F12F0D5,
	0x0F120842,
	0x0F12043A,
	0x0F12F461,
	0x0F120E58,
	0x0F12F658,
	0x0F12075D,
	0x0F12F78D,
	0x0F12FDE9,
	0x0F12277A,
	0x0F12FFDE,
	0x0F12FD3B,
	0x0F12FE50,
	0x0F120AD1,
	0x0F12FE2C,
	0x0F12E90D,
	0x0F12F7B0,
	0x0F1205DB,
	0x0F1202CD,
	0x0F12F4F1,
	0x0F1202A8,
	0x0F12FDDC,
	0x0F120B59,
	0x0F12F74E,
	0x0F1203D5,
	0x0F12FF4F,
	0x0F1200F7,
	0x0F126A44,
	0x0F12FAD6,
	0x0F12F261,
	0x0F121F28,
	0x0F12E691,
	0x0F1207D2,
	0x0F12EE85,
	0x0F12F426,
	0x0F120F26,
	0x0F12F34B,
	0x0F120036,
	0x0F120C0F,
	0x0F12FDA9,
	0x0F1209EA,
	0x0F12F27A,
	0x0F120CD5,
	0x0F1201E1,
	0x0F12ED41,
	0x0F121DB5,
	0x0F12FD26,
	0x0F1203F7,
	0x0F12F7BB,
	0x0F12FE81,
	0x0F1212D3,
	0x0F12E061,
	0x0F12F81C,
	0x0F1207B1,
	0x0F120408,
	0x0F12F860,
	0x0F12FC9A,
	0x0F120DDE,
	0x0F120C9C,
	0x0F12F2A4,
	0x0F1202EB,
	0x0F12099B,
	0x0F12F5A6,
	0x0F127243,
	0x0F12F74D,
	0x0F12F74B,
	0x0F121800,
	0x0F12EF22,
	0x0F120263,
	0x0F12EBE7,
	0x0F12F5A4,
	0x0F1209D3,
	0x0F12FAB8,
	0x0F12FDFF,
	0x0F12086B,
	0x0F120338,
	0x0F120514,
	0x0F12F840,
	0x0F120768,
	0x0F12FE55,
	0x0F12F884,
	0x0F121488,
	0x0F12FFCD,
	0x0F12035B,
	0x0F12FA4E,
	0x0F1201DB,
	0x0F1206D6,
	0x0F12EE19,
	0x0F12FEA3,
	0x0F12FE8C,
	0x0F1203A3,
	0x0F12FDDB,
	0x0F12FD9B,
	0x0F12035E,
	0x0F1203F2,
	0x0F12FCBD,
	0x0F120300,
	0x0F12FF2E,
	0x0F12FE03,

	0x002A04A8,
	0x0F120001, //REG_TC_DBG_ReInitCmd

	//===================================================================
	// Shading - Alpha
	//===================================================================
	0x002A07E8,
	0x0F1200BC, //TVAR_ash_AwbAshCord_0_//HOR
	0x0F1200ED, //TVAR_ash_AwbAshCord_1_//INCA
	0x0F120101, //TVAR_ash_AwbAshCord_2_//WW
	0x0F12012D, //TVAR_ash_AwbAshCord_3_//CW
	0x0F120166, //TVAR_ash_AwbAshCord_4_//D50
	0x0F120184, //TVAR_ash_AwbAshCord_5_//D65
	0x0F1201A0, //TVAR_ash_AwbAshCord_6_//D75
	0x002A07FE,
	0x0F123200, //TVAR_ash_GASAlpha_0__0_
	0x0F124000, //TVAR_ash_GASAlpha_0__1_
	0x0F124000, //TVAR_ash_GASAlpha_0__2_
	0x0F123C00, //TVAR_ash_GASAlpha_0__3_
	0x0F123200, //TVAR_ash_GASAlpha_1__0_
	0x0F124000, //TVAR_ash_GASAlpha_1__1_
	0x0F124000, //TVAR_ash_GASAlpha_1__2_
	0x0F123C00, //TVAR_ash_GASAlpha_1__3_
	0x0F123200, //TVAR_ash_GASAlpha_2__0_
	0x0F124000, //TVAR_ash_GASAlpha_2__1_
	0x0F124000, //TVAR_ash_GASAlpha_2__2_
	0x0F123C00, //TVAR_ash_GASAlpha_2__3_
	0x0F123200, //TVAR_ash_GASAlpha_3__0_
	0x0F124000, //TVAR_ash_GASAlpha_3__1_
	0x0F124000, //TVAR_ash_GASAlpha_3__2_
	0x0F123C00, //TVAR_ash_GASAlpha_3__3_
	0x0F123200, //TVAR_ash_GASAlpha_4__0_
	0x0F124000, //TVAR_ash_GASAlpha_4__1_
	0x0F124000, //TVAR_ash_GASAlpha_4__2_
	0x0F123C00, //TVAR_ash_GASAlpha_4__3_
	0x0F123200, //TVAR_ash_GASAlpha_5__0_
	0x0F124000, //TVAR_ash_GASAlpha_5__1_
	0x0F124000, //TVAR_ash_GASAlpha_5__2_
	0x0F123C00, //TVAR_ash_GASAlpha_5__3_
	0x0F123F00,	//TVAR_ash_GASAlpha_6__0_
	0x0F124000, //TVAR_ash_GASAlpha_6__1_
	0x0F124000, //TVAR_ash_GASAlpha_6__2_
	0x0F124000, //TVAR_ash_GASAlpha_6__3_

	0x002A0836,
	0x0F123F00,	//TVAR_ash_GASOutdoorAlpha_0_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_1_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_2_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_3_

	//===================================================================
	// Gamma
	//===================================================================
	//	param_start	SARR_usGammaLutRGBIndoor
	0x002A0660,
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[0][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[0][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[0][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[0][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[0][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[0][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[0][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[0][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[0][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[0][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[0][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[0][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[0][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[0][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[0][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[0][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[0][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[0][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[0][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[0][19]
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[1][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[1][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[1][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[1][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[1][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[1][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[1][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[1][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[1][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[1][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[1][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[1][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[1][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[1][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[1][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[1][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[1][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[1][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[1][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[1][19]
	0x0F120000,          //saRR_usDualGammaLutRGBIndoor[2][0]
	0x0F120008,          //saRR_usDualGammaLutRGBIndoor[2][1]
	0x0F120015,          //saRR_usDualGammaLutRGBIndoor[2][2]
	0x0F120032,          //saRR_usDualGammaLutRGBIndoor[2][3]
	0x0F12006C,          //saRR_usDualGammaLutRGBIndoor[2][4]
	0x0F1200D0,          //saRR_usDualGammaLutRGBIndoor[2][5]
	0x0F120129,          //saRR_usDualGammaLutRGBIndoor[2][6]
	0x0F120151,          //saRR_usDualGammaLutRGBIndoor[2][7]
	0x0F120174,          //saRR_usDualGammaLutRGBIndoor[2][8]
	0x0F1201AA,          //saRR_usDualGammaLutRGBIndoor[2][9]
	0x0F1201D7,          //saRR_usDualGammaLutRGBIndoor[2][10]
	0x0F1201FE,          //saRR_usDualGammaLutRGBIndoor[2][11]
	0x0F120221,          //saRR_usDualGammaLutRGBIndoor[2][12]
	0x0F120252,          //saRR_usDualGammaLutRGBIndoor[2][13]
	0x0F120281,          //saRR_usDualGammaLutRGBIndoor[2][14]
	0x0F1202E1,          //saRR_usDualGammaLutRGBIndoor[2][15]
	0x0F120345,          //saRR_usDualGammaLutRGBIndoor[2][16]
	0x0F12039C,          //saRR_usDualGammaLutRGBIndoor[2][17]
	0x0F1203D9,          //saRR_usDualGammaLutRGBIndoor[2][18]
	0x0F1203FF,          //saRR_usDualGammaLutRGBIndoor[2][19]

	//s002A06D8
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[0][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[0][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[0][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[0][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[0][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[0][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[0][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[0][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[0][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[0][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[0][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[0][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[0][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[0][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[0][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[0][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[0][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[0][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[0][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[0][19]
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[1][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[1][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[1][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[1][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[1][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[1][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[1][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[1][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[1][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[1][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[1][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[1][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[1][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[1][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[1][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[1][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[1][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[1][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[1][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[1][19]
	0x0F120000, //saRR_usDualGammaLutRGBOutdoor[2][0]
	0x0F120008, //saRR_usDualGammaLutRGBOutdoor[2][1]
	0x0F120013, //saRR_usDualGammaLutRGBOutdoor[2][2]
	0x0F12002C, //saRR_usDualGammaLutRGBOutdoor[2][3]
	0x0F12005C, //saRR_usDualGammaLutRGBOutdoor[2][4]
	0x0F1200BB, //saRR_usDualGammaLutRGBOutdoor[2][5]
	0x0F120109, //saRR_usDualGammaLutRGBOutdoor[2][6]
	0x0F12012C, //saRR_usDualGammaLutRGBOutdoor[2][7]
	0x0F12014C, //saRR_usDualGammaLutRGBOutdoor[2][8]
	0x0F120185, //saRR_usDualGammaLutRGBOutdoor[2][9]
	0x0F1201B9, //saRR_usDualGammaLutRGBOutdoor[2][10]
	0x0F1201E8, //saRR_usDualGammaLutRGBOutdoor[2][11]
	0x0F120210, //saRR_usDualGammaLutRGBOutdoor[2][12]
	0x0F12024C, //saRR_usDualGammaLutRGBOutdoor[2][13]
	0x0F120280, //saRR_usDualGammaLutRGBOutdoor[2][14]
	0x0F1202D4, //saRR_usDualGammaLutRGBOutdoor[2][15]
	0x0F120324, //saRR_usDualGammaLutRGBOutdoor[2][16]
	0x0F12036C, //saRR_usDualGammaLutRGBOutdoor[2][17]
	0x0F1203AC, //saRR_usDualGammaLutRGBOutdoor[2][18]
	0x0F1203E6, //saRR_usDualGammaLutRGBOutdoor[2][19]

	//===================================================================
	// AE - shutter
	//===================================================================
	//****************************************/
	// AE 2009 03 08 - based on TN
	//****************************************/
	//============================================================
	// Frame rate setting
	//============================================================
	// How to set
	// 1. Exposure value
	// dec2hex((1 / (frame rate you want(ms))) * 100d * 5d)
	//
	//
	// 2. Analog Digital gain
	// dec2hex((Analog gain you want) * 256d)
	//              Ex1) Simple Caculation for x3.25?:   3.25x256 = 832[dec] = 0340[hex]
	//============================================================
	//MBR
	0x002A01DE,
	0x0F120000, //REG_TC_bUseMBR//MBR off
	//MBR off is needed to prevent a shorter integration time when the scene has blurring in Nigh

	//AE_Target
	0x002A1308,
	0x0F12003E, //TVAR_ae_BrAve
	0x002A130E,
	0x0F12000F, //ae_StatMode
	//ae_StatMode bit[3] BLC has to be bypassed to prevent AE weight change especially backlight

	//AE_state
	0x002A04EE,
	0x0F12010E, //#lt_uLimitHigh
	0x0F1200F5, //#lt_uLimitLow

	//For 60Hz
	0x002A0504,
	0x0F123415, //#lt_uMaxExp1
	0x002A0508,
	0x0F12681F, //#lt_uMaxExp2
	0x002A050C,
	0x0F128227, //#lt_uMaxExp3
	0x002A0510,
	0x0F12C350, //#lt_uMaxExp4

	0x002A0514,
	0x0F123415, //#lt_uCapMaxExp1
	0x002A0518,
	0x0F12681F, //#lt_uCapMaxExp2
	0x002A051C,
	0x0F128227, //#lt_uCapMaxExp3
	0x002A0520,
	0x0F12C350, //#lt_uCapMaxExp4

	0x002A0524,
	0x0F1201E0, //#lt_uMaxAnGain1
	0x0F1201E0, //#lt_uMaxAnGain2
	0x0F120300, //#lt_uMaxAnGain3
	0x0F120710, //#lt_uMaxAnGain4

	0x0F120100, //#lt_uMaxDigGain
	0x0F128000, //#lt_uMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	0x0F1201E0, //#lt_uCapMaxAnGain1
	0x0F1201E0, //#lt_uCapMaxAnGain2
	0x0F120300, //#lt_uCapMaxAnGain3
	0x0F120710, //#lt_uCapMaxAnGain4

	0x0F120100, //#lt_uCapMaxDigGain
	0x0F128000, //#lt_uCapMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	//===================================================================
	//AE - Weights
	//===================================================================
	0x002A1316,
	0x0F120000, //ae_WeightTbl_16[0]
	0x0F120000, //ae_WeightTbl_16[1]
	0x0F120000, //ae_WeightTbl_16[2]
	0x0F120000, //ae_WeightTbl_16[3]
	0x0F120101, //ae_WeightTbl_16[4]
	0x0F120101, //ae_WeightTbl_16[5]
	0x0F120101, //ae_WeightTbl_16[6]
	0x0F120101, //ae_WeightTbl_16[7]
	0x0F120101, //ae_WeightTbl_16[8]
	0x0F120201, //ae_WeightTbl_16[9]
	0x0F120102, //ae_WeightTbl_16[10]
	0x0F120101, //ae_WeightTbl_16[11]
	0x0F120101, //ae_WeightTbl_16[12]
	0x0F120202, //ae_WeightTbl_16[13]
	0x0F120202, //ae_WeightTbl_16[14]
	0x0F120101, //ae_WeightTbl_16[15]
	0x0F120101, //ae_WeightTbl_16[16]
	0x0F120202, //ae_WeightTbl_16[17]
	0x0F120202, //ae_WeightTbl_16[18]
	0x0F120101, //ae_WeightTbl_16[19]
	0x0F120201, //ae_WeightTbl_16[20]
	0x0F120202, //ae_WeightTbl_16[21]
	0x0F120202, //ae_WeightTbl_16[22]
	0x0F120102, //ae_WeightTbl_16[23]
	0x0F120201, //ae_WeightTbl_16[24]
	0x0F120202, //ae_WeightTbl_16[25]
	0x0F120202, //ae_WeightTbl_16[26]
	0x0F120102, //ae_WeightTbl_16[27]
	0x0F120101, //ae_WeightTbl_16[28]
	0x0F120101, //ae_WeightTbl_16[29]
	0x0F120101, //ae_WeightTbl_16[30]
	0x0F120101, //ae_WeightTbl_16[31]

	//===================================================================
	//AWB-BASIC setting
	//===================================================================
	0x002A1018,
	0x0F1202A7, //awbb_GLocusR
	0x0F120343, //awbb_GLocusB
	0x002A0FFC,
	0x0F12036C, //awbb_CrclLowT_R_c
	0x002A1000,
	0x0F12011D, //awbb_CrclLowT_B_c
	0x002A1004,
	0x0F1262C1, //awbb_CrclLowT_Rad_c
	0x002A1034,
	0x0F1205F0, //awbb_GamutWidthThr1
	0x0F1201F4, //awbb_GamutHeightThr1
	0x0F12006C, //awbb_GamutWidthThr2
	0x0F120038, //awbb_GamutHeightThr2
	0x002A1020,
	0x0F12000C, //awbb_MinNumOfFinalPatches
	0x0F12001E, //awbb_MinNumOfLowBrFinalPatches
	0x0F120046, //awbb_MinNumOfLowBr0_FinalPatches
	0x002A291A,
	0x0F120006, // #Mon_AWB_ByPassMode          // [0]Outdoor [1]LowBr [2]LowTemp

	0x002A11C2,
	0x0F120000, //awbb_RGainOff
	0x0F120000, //awbb_BGainOff
	0x0F120000, //awbb_GGainOff
	0x0F1200C2, //awbb_Alpha_Comp_Mode
	0x0F120002, //awbb_Rpl_InvalidOutDoor
	0x0F120001, //awbb_UseGrThrCorr
	0x0F1200E4, //awbb_Use_Filters
	0x0F12053C, //awbb_GainsInit[0]
	0x0F120400, //awbb_GainsInit[1]
	0x0F12055C, //awbb_GainsInit[2]
	0x0F120008,	//001E	//awbb_WpFilterMinThr
	0x0F120160,	//0190	//awbb_WpFilterMaxThr
	0x0F1200A0, //awbb_WpFilterCoef
	0x0F120004, //awbb_WpFilterSize
	0x0F120001, //awbb_otp_disable

	//===================================================================
	//AWB-Zone
	//===================================================================
	//	param_start	awbb_IndoorGrZones_m_BGrid
	0x002A0F28,
	0x0F1203C0, //03C0//03C0//awbb_IndoorGrZones_m_BGrid[0]
	0x0F1203E2, //03E2//03E2//awbb_IndoorGrZones_m_BGrid[1]
	0x0F120356, //0356//0356//awbb_IndoorGrZones_m_BGrid[2]
	0x0F1203FC, //03FC//03FC//awbb_IndoorGrZones_m_BGrid[3]
	0x0F12031E, //031E//031E//awbb_IndoorGrZones_m_BGrid[4]
	0x0F1203FE, //03FE//03FE//awbb_IndoorGrZones_m_BGrid[5]
	0x0F1202F0, //02F0//02F0//awbb_IndoorGrZones_m_BGrid[6]
	0x0F1203F0, //03F0//03F0//awbb_IndoorGrZones_m_BGrid[7]
	0x0F1202CA, //02CA//02CA//awbb_IndoorGrZones_m_BGrid[8]
	0x0F1203CC, //03CC//03CC//awbb_IndoorGrZones_m_BGrid[9]
	0x0F1202A8, //02A8//02A8//awbb_IndoorGrZones_m_BGrid[10]
	0x0F12037A, //037A//037A//awbb_IndoorGrZones_m_BGrid[11]
	0x0F120280, //0288//0288//awbb_IndoorGrZones_m_BGrid[12]
	0x0F12033C, //033C//033C//awbb_IndoorGrZones_m_BGrid[13]
	0x0F120260, //0266//0266//awbb_IndoorGrZones_m_BGrid[14]
	0x0F12030A, //030A//031E//awbb_IndoorGrZones_m_BGrid[15]
	0x0F120242, //0246//0246//awbb_IndoorGrZones_m_BGrid[16]
	0x0F1202DC, //02EC//0300//awbb_IndoorGrZones_m_BGrid[17]
	0x0F120228, //0228//0228//awbb_IndoorGrZones_m_BGrid[18]
	0x0F1202B2, //02CE//02E8//awbb_IndoorGrZones_m_BGrid[19]
	0x0F12020E, //020E//020E//awbb_IndoorGrZones_m_BGrid[20]
	0x0F120290, //02B0//02CA//awbb_IndoorGrZones_m_BGrid[21]
	0x0F1201F8, //01F8//01F8//awbb_IndoorGrZones_m_BGrid[22]
	0x0F120276, //0292//02B0//awbb_IndoorGrZones_m_BGrid[23]
	0x0F1201E8, //01E8//01E8//awbb_IndoorGrZones_m_BGrid[24]
	0x0F120268, //0276//0296//awbb_IndoorGrZones_m_BGrid[25]
	0x0F1201DC, //01DC//01DC//awbb_IndoorGrZones_m_BGrid[26]
	0x0F120256, //0256//027A//awbb_IndoorGrZones_m_BGrid[27]
	0x0F1201E0, //01E0//01E0//awbb_IndoorGrZones_m_BGrid[28]
	0x0F120238, //0238//0252//awbb_IndoorGrZones_m_BGrid[29]
	0x0F1201EC, //01EC//01F2//awbb_IndoorGrZones_m_BGrid[30]
	0x0F12020E, //020E//0226//awbb_IndoorGrZones_m_BGrid[31]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[32]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[33]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[34]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[35]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[36]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[37]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[38]
	0x0F120000, //0000//0000//awbb_IndoorGrZones_m_BGrid[39]
	//	param_end	awbb_IndoorGrZones_m_BGrid

	0x0F120005, //awbb_IndoorGrZones_m_Grid
	0x002A0F80,
	0x0F1200E6, //awbb_IndoorGrZones_m_Boff
	0x002A0F7C,
	0x0F120010,

	//	param_start	awbb_OutdoorGrZones_m_BGrid
	0x002A0F84,
	0x0F12028E,	//awbb_OutdoorGrZones_m_BGrid[0]
	0x0F1202A6,	//awbb_OutdoorGrZones_m_BGrid[1]
	0x0F120276, //awbb_OutdoorGrZones_m_BGrid[2]
	0x0F1202B8,	//awbb_OutdoorGrZones_m_BGrid[3]
	0x0F120264,	//awbb_OutdoorGrZones_m_BGrid[4]
	0x0F1202BE,	//awbb_OutdoorGrZones_m_BGrid[5]
	0x0F120252,	//awbb_OutdoorGrZones_m_BGrid[6]
	0x0F1202C0,	//awbb_OutdoorGrZones_m_BGrid[7]
	0x0F120244,	//awbb_OutdoorGrZones_m_BGrid[8]
	0x0F1202BC,	//awbb_OutdoorGrZones_m_BGrid[9]
	0x0F120234,	//awbb_OutdoorGrZones_m_BGrid[10]
	0x0F1202B2,	//awbb_OutdoorGrZones_m_BGrid[11]
	0x0F120228,	//awbb_OutdoorGrZones_m_BGrid[12]
	0x0F1202A6,	//awbb_OutdoorGrZones_m_BGrid[13]
	0x0F12021E,	//awbb_OutdoorGrZones_m_BGrid[14]
	0x0F12029C, //awbb_OutdoorGrZones_m_BGrid[15]
	0x0F120216,	//awbb_OutdoorGrZones_m_BGrid[16]
	0x0F12028A,	//awbb_OutdoorGrZones_m_BGrid[17]
	0x0F120216, //awbb_OutdoorGrZones_m_BGrid[18]
	0x0F120278,	//awbb_OutdoorGrZones_m_BGrid[19]
	0x0F120220,	//awbb_OutdoorGrZones_m_BGrid[20]
	0x0F12026A,	//awbb_OutdoorGrZones_m_BGrid[21]
	0x0F120232,	//awbb_OutdoorGrZones_m_BGrid[22]
	0x0F12024A,	//awbb_OutdoorGrZones_m_BGrid[23]
	//	param_end	awbb_OutdoorGrZones_m_BGrid

	0x0F120004, //awbb_OutdoorGrZones_m_Gri
	0x002A0FB8,
	0x0F12000C,	//awbb_OutdoorGrZones_ZInfo_m_GridSz
	0x002A0FBC,
	0x0F1201E4,	//awbb_OutdoorGrZones_m_Bof

	//	param_start	awbb_LowBrGrZones_m_BGrid
	0x002A0FC0,
	0x0F1203B2, //awbb_LowBrGrZones_m_BGrid[0]
	0x0F12044E, //awbb_LowBrGrZones_m_BGrid[1]
	0x0F120330, //awbb_LowBrGrZones_m_BGrid[2]
	0x0F120454, //awbb_LowBrGrZones_m_BGrid[3]
	0x0F1202CC, //awbb_LowBrGrZones_m_BGrid[4]
	0x0F120414, //awbb_LowBrGrZones_m_BGrid[5]
	0x0F12026E, //awbb_LowBrGrZones_m_BGrid[6]
	0x0F1203D0, //awbb_LowBrGrZones_m_BGrid[7]
	0x0F120226, //awbb_LowBrGrZones_m_BGrid[8]
	0x0F120362, //awbb_LowBrGrZones_m_BGrid[9]
	0x0F1201F0, //awbb_LowBrGrZones_m_BGrid[10]
	0x0F120312, //awbb_LowBrGrZones_m_BGrid[11]
	0x0F1201CE, //awbb_LowBrGrZones_m_BGrid[12]
	0x0F1202CC, //awbb_LowBrGrZones_m_BGrid[13]
	0x0F1201B2, //awbb_LowBrGrZones_m_BGrid[14]
	0x0F12029E, //awbb_LowBrGrZones_m_BGrid[15]
	0x0F1201AC, //awbb_LowBrGrZones_m_BGrid[16]
	0x0F120278, //awbb_LowBrGrZones_m_BGrid[17]
	0x0F1201B6, //awbb_LowBrGrZones_m_BGrid[18]
	0x0F120248, //awbb_LowBrGrZones_m_BGrid[19]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[20]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[21]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[22]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[23]

	//	param_end	awbb_LowBrGrZones_m_BGrid
	0x0F120006, //awbb_LowBrGrZones_m_GridStep
	0x002A0FF4,
	0x0F12000A, //awbb_LowBrGrZones_ZInfo_m_GridSz
	0x002A0FF8,
	0x0F1200C2, //awbb_LowBrGrZones_m_Boffs

	//===================================================================
	//AWB Scene Detection
	//===================================================================
	0x002A1098,
	0x0F12FE82, //awbb_SCDetectionMap_SEC_StartR_B
	0x0F12001E, //awbb_SCDetectionMap_SEC_StepR_B
	0x0F1209C4, //awbb_SCDetectionMap_SEC_SunnyNB
	0x0F120122, //awbb_SCDetectionMap_SEC_StepNB
	0x0F1200E4, //awbb_SCDetectionMap_SEC_LowTempR_B
	0x0F120096, //awbb_SCDetectionMap_SEC_SunnyNBZone
	0x0F12000E, //awbb_SCDetectionMap_SEC_LowTempR_BZone

	0x002A105C,
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__2_
	0x0F120500, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__4_
	0x0F125555, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__1_
	0x0F125455, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__3_
	0x0F12AA55, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__0_
	0x0F12AAAA, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__2_
	0x0F12BF54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__3_
	0x0F12FF6F, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__2_
	0x0F121B54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__3_
	0x0F12FF06, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__2_
	0x0F120154, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__4_
	0x0F12BFBF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__1_
	0x0F1254BE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__3_

	//===================================================================
	//AWB - GridCorrection
	//===================================================================

	0x002A11E0,
	0x0F120002, //awbb_GridEnable

	0x002A11A8,
	0x0F1202C8, //awbb_GridConst_1[0]
	0x0F120325, //awbb_GridConst_1[1]
	0x0F12038F, //awbb_GridConst_1[2]

	0x0F120F8E, //awbb_GridConst_2[0]
	0x0F1210B3, //awbb_GridConst_2[1]
	0x0F121136, //awbb_GridConst_2[2]
	0x0F121138, //awbb_GridConst_2[3]
	0x0F12118E, //awbb_GridConst_2[4]
	0x0F121213, //awbb_GridConst_2[5]

	0x0F1200A7, //awbb_GridCoeff_R_1
	0x0F1200C2, //awbb_GridCoeff_B_1
	0x0F1200BD, //awbb_GridCoeff_R_2
	0x0F1200AC, //awbb_GridCoeff_B_2

	0x002A1118,
	0x0F120050, //0032//awbb_GridCorr_R[0][0]
	0x0F120032, //0012//awbb_GridCorr_R[0][1]
	0x0F120032, //0012//awbb_GridCorr_R[0][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[0][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[0][4]
	0x0F120060, //0050//awbb_GridCorr_R[0][5]
	0x0F120050, //0032//awbb_GridCorr_R[1][0]
	0x0F120032, //0012//awbb_GridCorr_R[1][1]
	0x0F120032, //0012//awbb_GridCorr_R[1][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[1][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[1][4]
	0x0F120060, //0050//awbb_GridCorr_R[1][5]
	0x0F120050, //0032//awbb_GridCorr_R[2][0]
	0x0F120032, //0012//awbb_GridCorr_R[2][1]
	0x0F120032, //0012//awbb_GridCorr_R[2][2]
	0x0F120000, //FFEC//awbb_GridCorr_R[2][3]
	0x0F120000, //FFEC//awbb_GridCorr_R[2][4]
	0x0F120060, //0050//awbb_GridCorr_R[2][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[0][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[0][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[0][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[0][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[0][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[0][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[1][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[1][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[1][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[1][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[1][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[1][5]
	0x0F12FF9C, //FF9C//awbb_GridCorr_B[2][0]
	0x0F12FFD8, //FFCE//awbb_GridCorr_B[2][1]
	0x0F12FFEC, //FFCE//awbb_GridCorr_B[2][2]
	0x0F12FF97, //FF97//awbb_GridCorr_B[2][3]
	0x0F12FF97, //FF97//awbb_GridCorr_B[2][4]
	0x0F12FE30, //FDA8//awbb_GridCorr_B[2][5]

	0x002A1160,
	0x0F12000A, //awbb_GridCorr_R_Out[0][0]
	0x0F12000A, //awbb_GridCorr_R_Out[0][1]
	0x0F120000, //awbb_GridCorr_R_Out[0][2]
	0x0F120000, //awbb_GridCorr_R_Out[0][3]
	0x0F120000, //awbb_GridCorr_R_Out[0][4]
	0x0F120000, //awbb_GridCorr_R_Out[0][5]
	0x0F12000A, //awbb_GridCorr_R_Out[1][0]
	0x0F12000A, //awbb_GridCorr_R_Out[1][1]
	0x0F120000, //awbb_GridCorr_R_Out[1][2]
	0x0F120000, //awbb_GridCorr_R_Out[1][3]
	0x0F120000, //awbb_GridCorr_R_Out[1][4]
	0x0F120000, //awbb_GridCorr_R_Out[1][5]
	0x0F12000A, //awbb_GridCorr_R_Out[2][0]
	0x0F12000A, //awbb_GridCorr_R_Out[2][1]
	0x0F120000, //awbb_GridCorr_R_Out[2][2]
	0x0F120000, //awbb_GridCorr_R_Out[2][3]
	0x0F120000, //awbb_GridCorr_R_Out[2][4]
	0x0F120000, //awbb_GridCorr_R_Out[2][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[0][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[0][1]
	0x0F120000, //awbb_GridCorr_B_Out[0][2]
	0x0F120000, //awbb_GridCorr_B_Out[0][3]
	0x0F120000, //awbb_GridCorr_B_Out[0][4]
	0x0F120000, //awbb_GridCorr_B_Out[0][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[1][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[1][1]
	0x0F120000, //awbb_GridCorr_B_Out[1][2]
	0x0F120000, //awbb_GridCorr_B_Out[1][3]
	0x0F120000, //awbb_GridCorr_B_Out[1][4]
	0x0F120000, //awbb_GridCorr_B_Out[1][5]
	0x0F12FFD2, //awbb_GridCorr_B_Out[2][0]
	0x0F12FFD2, //awbb_GridCorr_B_Out[2][1]
	0x0F120000, //awbb_GridCorr_B_Out[2][2]
	0x0F120000, //awbb_GridCorr_B_Out[2][3]
	0x0F120000, //awbb_GridCorr_B_Out[2][4]
	0x0F120000, //awbb_GridCorr_B_Out[2][5]

	//===================================================================
	// CCM
	//===================================================================
	0x002A07D2,
	0x0F1200C0, //SARR_AwbCcmCord_0_
	0x0F1200E0, //SARR_AwbCcmCord_1_
	0x0F120110, //SARR_AwbCcmCord_2_
	0x0F120139, //SARR_AwbCcmCord_3_
	0x0F120166, //SARR_AwbCcmCord_4_
	0x0F12019F, //SARR_AwbCcmCord_5_

	//	param_start	TVAR_wbt_pBaseCcms
	0x002A07C4,
	0x0F124000, //TVAR_wbt_pBaseCcms
	0x0F127000,

	0x002A4000,
	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[0]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[1]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[2]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[3]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[4]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[5]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[6]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[7]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[8]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[9]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[10]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[11]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[12]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[13]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[14]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[15]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[16]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[17]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[18]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[19]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[20]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[21]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[22]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[23]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[24]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[25]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[26]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[27]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[28]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[29]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[30]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[31]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[32]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[33]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[34]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[35]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[36]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[37]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[38]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[39]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[40]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[41]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[42]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[43]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[44]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[45]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[46]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[47]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[48]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[49]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[50]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[51]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[52]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[53]

	0x0F1201EA, //01E2//TVAR_wbt_pBaseCcms[54]
	0x0F12FFAC, //FF9A//TVAR_wbt_pBaseCcms[55]
	0x0F12FFE3, //FFE8//TVAR_wbt_pBaseCcms[56]
	0x0F12FF45, //FF45//TVAR_wbt_pBaseCcms[57]
	0x0F120140, //0140//TVAR_wbt_pBaseCcms[58]
	0x0F12FF4F, //FF4F//TVAR_wbt_pBaseCcms[59]
	0x0F12FFC3, //FFC3//TVAR_wbt_pBaseCcms[60]
	0x0F12FFD5, //FFD5//TVAR_wbt_pBaseCcms[61]
	0x0F120173, //0173//TVAR_wbt_pBaseCcms[62]
	0x0F120137, //0128//TVAR_wbt_pBaseCcms[63]
	0x0F1200C2, //00EA//TVAR_wbt_pBaseCcms[64]
	0x0F12FEC1, //FEA8//TVAR_wbt_pBaseCcms[65]
	0x0F1200C8, //00C8//TVAR_wbt_pBaseCcms[66]
	0x0F12FF49, //FF49//TVAR_wbt_pBaseCcms[67]
	0x0F12014B, //014B//TVAR_wbt_pBaseCcms[68]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[69]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[70]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[71]

	0x0F12011D, //00F4          //TVAR_wbt_pBaseCcms[72]
	0x0F12FFA7, //FFC2//TVAR_wbt_pBaseCcms[73]
	0x0F12FFEC, //FFFA//TVAR_wbt_pBaseCcms[74]
	0x0F12FF0D, //FF3E//TVAR_wbt_pBaseCcms[75]
	0x0F120193, //0163//TVAR_wbt_pBaseCcms[76]
	0x0F12FF34, //FF5F//TVAR_wbt_pBaseCcms[77]
	0x0F12FFCE, //FFCE//TVAR_wbt_pBaseCcms[78]
	0x0F12FFDF, //FFDF//TVAR_wbt_pBaseCcms[79]
	0x0F12015E, //015E//TVAR_wbt_pBaseCcms[80]
	0x0F120095, //0095//TVAR_wbt_pBaseCcms[81]
	0x0F120096, //0096//TVAR_wbt_pBaseCcms[82]
	0x0F12FF0B, //FF0B//TVAR_wbt_pBaseCcms[83]
	0x0F1200C3, //00C3//TVAR_wbt_pBaseCcms[84]
	0x0F12FF5C, //FF5C//TVAR_wbt_pBaseCcms[85]
	0x0F12013D, //013D//TVAR_wbt_pBaseCcms[86]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[87]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[88]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[89]

	0x0F12011D, //00F4          //TVAR_wbt_pBaseCcms[90]
	0x0F12FFA7, //FFC2//TVAR_wbt_pBaseCcms[91]
	0x0F12FFEC, //FFFA//TVAR_wbt_pBaseCcms[92]
	0x0F12FF0D, //FF3E//TVAR_wbt_pBaseCcms[93]
	0x0F120193, //0163//TVAR_wbt_pBaseCcms[94]
	0x0F12FF34, //FF5F//TVAR_wbt_pBaseCcms[95]
	0x0F12FFCE, //FFCE//TVAR_wbt_pBaseCcms[96]
	0x0F12FFDF, //FFDF//TVAR_wbt_pBaseCcms[97]
	0x0F12015E, //015E//TVAR_wbt_pBaseCcms[98]
	0x0F120095, //0095//TVAR_wbt_pBaseCcms[99]
	0x0F120096, //0096//TVAR_wbt_pBaseCcms[100]
	0x0F12FF0B, //FF0B//TVAR_wbt_pBaseCcms[101]
	0x0F1200C3, //00C3//TVAR_wbt_pBaseCcms[102]
	0x0F12FF5C, //FF5C//TVAR_wbt_pBaseCcms[103]
	0x0F12013D, //013D//TVAR_wbt_pBaseCcms[104]
	0x0F12FF68, //FF68//TVAR_wbt_pBaseCcms[105]
	0x0F120109, //0109//TVAR_wbt_pBaseCcms[106]
	0x0F1200F4, //00F4//TVAR_wbt_pBaseCcms[107]
	//	param_end	TVAR_wbt_pBasecms


	0x002A07CC,
	0x0F1240D8, //#TVAR_wbt_pOutdoorCcm
	0x0F127000,

	//	param_start	TVAR_wbt_pOutdoorCcm
	0x002A40D8,
	0x0F1201F6, //01F6//01F8//TVAR_wbt_pOutdoorCcm[0]
	0x0F12FF9F, //FF9F//FFAF//TVAR_wbt_pOutdoorCcm[1]
	0x0F12FFE5, //FFE5//FFD3//TVAR_wbt_pOutdoorCcm[2]
	0x0F12FED2, //FED2//FEC4//TVAR_wbt_pOutdoorCcm[3]
	0x0F120193, //0193//0191//TVAR_wbt_pOutdoorCcm[4]
	0x0F12FF23, //FF23//FF33//TVAR_wbt_pOutdoorCcm[5]
	0x0F12FFF7, //FFF7//FFED//TVAR_wbt_pOutdoorCcm[6]
	0x0F12000C, //000C//0017//TVAR_wbt_pOutdoorCcm[7]
	0x0F120211, //0211//0210//TVAR_wbt_pOutdoorCcm[8]
	0x0F1200FF, //00F1//00E3//TVAR_wbt_pOutdoorCcm[9]
	0x0F1200EC, //00FA//0107//TVAR_wbt_pOutdoorCcm[10]
	0x0F12FF2E, //FF2E//FF2F//TVAR_wbt_pOutdoorCcm[11]
	0x0F120220, //0220//0220//TVAR_wbt_pOutdoorCcm[12]
	0x0F12FFE7, //FFE7//FFE7//TVAR_wbt_pOutdoorCcm[13]
	0x0F1201A1, //01A1//01A1//TVAR_wbt_pOutdoorCcm[14]
	0x0F12FEC7, //FEC7//FEC8//TVAR_wbt_pOutdoorCcm[15]
	0x0F12016D, //016D//017D//TVAR_wbt_pOutdoorCcm[16]
	0x0F120153, //0153//0142//TVAR_wbt_pOutdoorCcm[17]
	//	param_end	TVAR_wbt_pOutdoorCcm


	0x002A2A64,
	0x0F120001, //#MVAR_AAIO_bFIT
	0x002A2A68,
	0x0F120001, //#MVAR_AAIO_bAutoCCMandASH
	0x002A2A3C,
	0x0F1201DD, //#Mon_AAIO_PrevFrmData_NormBr

	//===================================================================
	// AFIT
	//===================================================================

	//	param_start	afit_uNoiseIndInDoor
	0x002A085C,
	0x0F12004A, //0049//#afit_uNoiseIndInDoor_0_
	0x0F12004E, //005F//#afit_uNoiseIndInDoor_1_
	0x0F1200CB, //00CB//#afit_uNoiseIndInDoor_2_
	0x0F1201C0, //01E0//#afit_uNoiseIndInDoor_3_
	0x0F120200, //0220//#afit_uNoiseIndInDoor_4_

	0x002A08C0,
	0x0F120007, //0007//700008C0//AFIT16_BRIGHTNESS
	0x0F120000, //0000//700008C2           //AFIT16_CONTRAST
	0x0F120000, //0000//700008C4           //AFIT16_SATURATION
	0x0F120002, //0000//700008C6           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//700008C8           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//700008CA           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//700008CC
	0x0F1203FF, //03FF//700008CE           //AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//700008D0           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//700008D2           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//700008D4           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//700008D6           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//700008D8           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//700008DA           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//700008DC           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//700008DE           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//700008E0           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//700008E2           //AFIT16_demsharpmix1_iTune
	0x0F120010, //0010//700008E4//AFIT16_demsharpmix1_iHystThLow
	0x0F120010, //0010//700008E6//AFIT16_demsharpmix1_iHystThHigh
	0x0F1201F4, //01F4//700008E8//AFIT16_demsharpmix1_iHystCenter
	0x0F12006E, //003C//700008EA           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0008//700008EC           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//700008EE           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//700008F0           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//700008F2           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//700008F4           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//700008F6           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh
	0x0F121701, //1701//700008F8           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level
	0x0F120229, //0229//700008FA           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8
	0x0F121403, //1403//700008FC           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAl
	0x0F120004, //0004//700008FE           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotTh
	0x0F120300, //0300//70000900           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iCold
	0x0F120000, //0000//70000902           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoi
	0x0F1202FF, //02FF//70000904           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [
	0x0F1205E8, //09E8//70000906           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadial
	0x0F121414, //1414//70000908           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_
	0x0F120301, //0301//7000090A           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHigh
	0x0F120007, //0007//7000090C           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F124000, //4000//7000090E
	0x0F127803, //7803//70000910
	0x0F123C50, //3C50//70000912
	0x0F12003C, //003C//70000914
	0x0F121E80, //1E80//70000916           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_i
	0x0F121E08, //1E08//70000918           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosai
	0x0F12000A, //000A//7000091A           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_
	0x0F120000, //0000//7000091C           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaici
	0x0F12120A, //120A//7000091E           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpe
	0x0F121400, //0F00//70000920           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iW
	0x0F120200, //0200//70000922           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nS
	0x0F12FF00, //FF00//70000924           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpeni
	0x0F120200, //0200//70000926           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demshar
	0x0F121B11, //1B11//70000928           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_i
	0x0F120000, //0000//7000092A           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1
	0x0F120009, //0009//7000092C           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpm
	0x0F120406, //0406//7000092E           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix
	0x0F120605, //0605//70000930           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharp
	0x0F120307, //0307//70000932
	0x0F120609, //0609//70000934
	0x0F122C07, //2C07//70000936
	0x0F12142C, //142C//70000938
	0x0F120B18, //0718//7000093A//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F12800B, //8007//7000093C//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120880, //0880//7000093E           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iD
	0x0F120B50, //0B50//70000940           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYO
	0x0F120080, //0080//70000942           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSatura
	0x0F120101, //0101//70000944           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClu
	0x0F120707, //0707//70000946           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClus
	0x0F124601, //4601//70000948           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_Disp
	0x0F12A444, //C844//7000094A           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenTh
	0x0F1250A4, //50C8//7000094C           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing
	0x0F120500, //0500//7000094E           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Dem
	0x0F120303, //0003//70000950           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosa
	0x0F121001, //1C01//70000952           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demos
	0x0F120710, //0714//70000954           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demos
	0x0F121448, //1464//70000956           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaici
	0x0F125A03, //5A04//70000958           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpen
	0x0F12281E, //3C1E//7000095A           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpe
	0x0F12200F, //400F//7000095C           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpe
	0x0F120204, //0204//7000095E           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsh
	0x0F121403, //1403//70000960           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd
	0x0F120114, //0114//70000962           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000964           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_n
	0x0F124446, //4446//70000966           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_Dis
	0x0F12646E, //646E//70000968           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_
	0x0F120028, //0028//7000096A           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosa
	0x0F12030A, //030A//7000096C           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8
	0x0F120000, //0000//7000096E           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_De
	0x0F12141E, //141E//70000970           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_D
	0x0F12FF07, //FF07//70000972           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  A
	0x0F120432, //0432//70000974           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demo
	0x0F120000, //0000//70000976           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sha
	0x0F120F0F, //0F0F//70000978           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Shar
	0x0F120440, //0440//7000097A           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8
	0x0F120302, //0302//7000097C           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_
	0x0F121414, //1414//7000097E           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000980           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_
	0x0F124601, //4601//70000982           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a
	0x0F126E44, //6E44//70000984           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_i
	0x0F122864, //2864//70000986           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosa
	0x0F120A00, //0A00//70000988           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8
	0x0F120003, //0003//7000098A           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_
	0x0F121E00, //1E00//7000098C           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_
	0x0F120714, //0714//7000098E           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_D
	0x0F1232FF, //32FF//70000990           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demo
	0x0F120004, //0004//70000992           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sh
	0x0F120F00, //0F00//70000994           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_S
	0x0F12400F, //400F//70000996           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sh
	0x0F120204, //0204//70000998           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_
	0x0F120003, //0003//7000099A           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//7000099C
	0x0F120000, //0000//7000099E//AFIT16_BRIGHTNESS
	0x0F120000, //0000//700009A0           //AFIT16_CONTRAST
	0x0F120000, //0000//700009A2           //AFIT16_SATURATION
	0x0F120002, //0000//700009A4           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//700009A6           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//700009A8           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//700009AA
	0x0F1203FF, //03FF//700009AC           //AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//700009AE           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//700009B0           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//700009B2           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//700009B4           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//700009B6           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//700009B8           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//700009BA           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//700009BC           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//700009BE           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//700009C0           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//700009C2//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//700009C4//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//700009C6//AFIT16_demsharpmix1_iHystCenter
	0x0F12006E, //006E//700009C8           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//700009CA           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//700009CC           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//700009CE           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//700009D0           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//700009D2           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//700009D4           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh
	0x0F121701, //1701//700009D6           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level
	0x0F120229, //0229//700009D8           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8
	0x0F121403, //1403//700009DA           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAl
	0x0F120004, //0004//700009DC           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotTh
	0x0F120300, //0300//700009DE           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iCold
	0x0F120000, //0000//700009E0           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoi
	0x0F1202FF, //02FF//700009E2           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [
	0x0F1205E8, //05E8//700009E4           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadial
	0x0F121414, //1414//700009E6           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_
	0x0F120301, //0301//700009E8           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHigh
	0x0F120007, //0007//700009EA           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F122000, //2000//700009EC
	0x0F125003, //5003//700009EE
	0x0F123228, //3228//700009F0
	0x0F120032, //0032//700009F2
	0x0F121E80, //1E80//700009F4           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_i
	0x0F121E08, //1E08//700009F6           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosai
	0x0F12000A, //000A//700009F8           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_
	0x0F120000, //0000//700009FA           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaici
	0x0F12120A, //120A//700009FC           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpe
	0x0F121400, //1400//700009FE           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iW
	0x0F120200, //0200//70000A00           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nS
	0x0F12FF00, //FF00//70000A02           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpeni
	0x0F120200, //0200//70000A04           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demshar
	0x0F121B11, //1B11//70000A06           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_i
	0x0F120000, //0000//70000A08           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1
	0x0F120009, //0009//70000A0A           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpm
	0x0F120406, //0406//70000A0C           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix
	0x0F120605, //0605//70000A0E           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharp
	0x0F120307, //0307//70000A10
	0x0F120609, //0609//70000A12
	0x0F122C07, //2C07//70000A14
	0x0F12142C, //142C//70000A16
	0x0F120518, //0518//70000A18//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000A1A//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120580, //0580//70000A1C           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iD
	0x0F120080, //0080//70000A1E           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYO
	0x0F120080, //0080//70000A20           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSatura
	0x0F120101, //0101//70000A22           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClu
	0x0F120707, //0707//70000A24           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClus
	0x0F124B01, //4B01//70000A26           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_Disp
	0x0F12494B, //444B 494B//70000A28           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_i
	0x0F125044, //503C 5044//70000A2A           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosa
	0x0F120500, //0500//70000A2C           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Dem
	0x0F120603, //0503//70000A2E           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosa
	0x0F120D03, //0D02//70000A30           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demos
	0x0F12071E, //071E//70000A32           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demos
	0x0F121432, //1432//70000A34           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaici
	0x0F125A01, //5A01//70000A36           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpen
	0x0F12281E, //281E//70000A38           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpe
	0x0F12200F, //200F//70000A3A           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpe
	0x0F120204, //0204//70000A3C           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsh
	0x0F121E03, //1E03//70000A3E           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd
	0x0F12011E, //011E//70000A40           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000A42           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_n
	0x0F123A3C, //3A3C//70000A44           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_Dis
	0x0F12585A, //585A//70000A46           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_
	0x0F120028, //0028//70000A48           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosa
	0x0F12030A, //030A//70000A4A           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8
	0x0F120000, //0000//70000A4C           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_De
	0x0F12141E, //141E//70000A4E           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_D
	0x0F12FF07, //FF07//70000A50           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  A
	0x0F120432, //0432//70000A52           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demo
	0x0F120000, //0000//70000A54           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sha
	0x0F120F0F, //0F0F//70000A56           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Shar
	0x0F120440, //0440//70000A58           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8
	0x0F120302, //0302//70000A5A           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_
	0x0F121E1E, //1E1E//70000A5C           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000A5E           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_
	0x0F123C01, //3C01//70000A60           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a
	0x0F125A3A, //5A3A//70000A62           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_i
	0x0F122858, //2858//70000A64           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosa
	0x0F120A00, //0A00//70000A66           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8
	0x0F120003, //0003//70000A68           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_
	0x0F121E00, //1E00//70000A6A           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_
	0x0F120714, //0714//70000A6C           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_D
	0x0F1232FF, //32FF//70000A6E           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demo
	0x0F120004, //0004//70000A70           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sh
	0x0F120F00, //0F00//70000A72           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_S
	0x0F12400F, //400F//70000A74           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sh
	0x0F120204, //0204//70000A76           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_
	0x0F120003, //0003//70000A78           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//70000A7A
	0x0F120000, //0000//70000A7C//AFIT16_BRIGHTNESS
	0x0F120000, //0000//70000A7E           //AFIT16_CONTRAST
	0x0F120000, //0000//70000A80           //AFIT16_SATURATION
	0x0F120000, //0000//70000A82           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//70000A84           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//70000A86           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//70000A88
	0x0F1203FF, //03FF//70000A8A           //AFIT16_Demosaicing_iSatVal
	0x0F12009E, //009E//70000A8C           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//70000A8E           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//70000A90           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//70000A92           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//70000A94           //AFIT16_demsharpmix1_iHighThreshold
	0x0F12012C, //012C//70000A96           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//70000A98           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//70000A9A           //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A//70000A9C           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//70000A9E           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//70000AA0//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//70000AA2//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//70000AA4//AFIT16_demsharpmix1_iHystCenter
	0x0F12008C, //008C//70000AA6           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//70000AA8           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12003C, //003C//70000AAA           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F12001E, //001E//70000AAC           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12003C, //003C//70000AAE           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F12001E, //001E//70000AB0           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//70000AB2           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh
	0x0F121701, //1701//70000AB4           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level
	0x0F120229, //0229//70000AB6           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8
	0x0F121403, //1403//70000AB8           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAl
	0x0F120004, //0004//70000ABA           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotTh
	0x0F120300, //0300//70000ABC           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iCold
	0x0F120000, //0000//70000ABE           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoi
	0x0F1202FF, //02FF//70000AC0           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [
	0x0F1205DE, //05DE//70000AC2           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadial
	0x0F121414, //1414//70000AC4           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_
	0x0F120301, //0301//70000AC6           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHigh
	0x0F120007, //0007//70000AC8           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//70000ACA
	0x0F122803, //2803//70000ACC
	0x0F12261E, //261E//70000ACE
	0x0F120026, //0026//70000AD0
	0x0F121E80, //1E80//70000AD2           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_i
	0x0F121E08, //1E08//70000AD4           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosai
	0x0F12010A, //010A//70000AD6           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_
	0x0F120001, //0001//70000AD8           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaici
	0x0F123C0A, //3C0A//70000ADA           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpe
	0x0F122300, //2300//70000ADC           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iW
	0x0F120200, //0200//70000ADE           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nS
	0x0F12FF00, //FF00//70000AE0           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpeni
	0x0F120200, //0200//70000AE2           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demshar
	0x0F121B11, //1B11//70000AE4           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_i
	0x0F120000, //0000//70000AE6           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1
	0x0F120009, //0009//70000AE8           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpm
	0x0F120406, //0406//70000AEA           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix
	0x0F120605, //0605//70000AEC           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharp
	0x0F120307, //0307//70000AEE
	0x0F120609, //0609//70000AF0
	0x0F121C07, //1C07//70000AF2
	0x0F121014, //1014//70000AF4
	0x0F120510, //0510//70000AF6//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000AF8//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120080, //0080//70000AFA           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iD
	0x0F120080, //0080//70000AFC           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYO
	0x0F120080, //0080//70000AFE           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSatura
	0x0F120101, //0101//70000B00           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClu
	0x0F120707, //0707//70000B02           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClus
	0x0F124B01, //4B01//70000B04           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_Disp
	0x0F122A4B, //2A4B//70000B06           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenTh
	0x0F125020, //5020//70000B08           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing
	0x0F120500, //0500//70000B0A           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Dem
	0x0F121C03, //1C03//70000B0C           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosa
	0x0F120D0C, //0D0C//70000B0E           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demos
	0x0F120823, //0823//70000B10           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demos
	0x0F121428, //1428//70000B12           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaici
	0x0F126401, //6401//70000B14           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpen
	0x0F12282D, //282D//70000B16           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpe
	0x0F122012, //2012//70000B18           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpe
	0x0F120204, //0204//70000B1A           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsh
	0x0F122803, //2803//70000B1C           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd
	0x0F120128, //0128//70000B1E           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000B20           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_n
	0x0F122224, //2224//70000B22           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_Dis
	0x0F123236, //3236//70000B24           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_
	0x0F120028, //0028//70000B26           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosa
	0x0F12030A, //030A//70000B28           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8
	0x0F120410, //0410//70000B2A           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_De
	0x0F12141E, //141E//70000B2C           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_D
	0x0F12FF07, //FF07//70000B2E           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  A
	0x0F120432, //0432//70000B30           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demo
	0x0F124050, //4050//70000B32           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sha
	0x0F120F0F, //0F0F//70000B34           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Shar
	0x0F120440, //0440//70000B36           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8
	0x0F120302, //0302//70000B38           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_
	0x0F122828, //2828//70000B3A           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000B3C           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_
	0x0F122401, //2401//70000B3E           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a
	0x0F123622, //3622//70000B40           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_i
	0x0F122832, //2832//70000B42           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosa
	0x0F120A00, //0A00//70000B44           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8
	0x0F121003, //1003//70000B46           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_
	0x0F121E04, //1E04//70000B48           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_
	0x0F120714, //0714//70000B4A           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_D
	0x0F1232FF, //32FF//70000B4C           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demo
	0x0F125004, //5004//70000B4E           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sh
	0x0F120F40, //0F40//70000B50           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_S
	0x0F12400F, //400F//70000B52           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sh
	0x0F120204, //0204//70000B54           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_
	0x0F120003, //0003//70000B56           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//70000B58
	0x0F120000, //0000//70000B5A//AFIT16_BRIGHTNESS
	0x0F120000, //0000//70000B5C           //AFIT16_CONTRAST
	0x0F120000, //0000//70000B5E           //AFIT16_SATURATION
	0x0F120000, //0000//70000B60           //AFIT16_SHARP_BLUR
	0x0F120000, //0000//70000B62           //AFIT16_GLAMOUR
	0x0F1200C1, //00C1//70000B64           //AFIT16_sddd8a_edge_high
	0x0F120000, //0000//70000B66
	0x0F1203FF, //03FF//70000B68           //AFIT16_Demosaicing_iSatVal
	0x0F12009E, //009E//70000B6A           //AFIT16_Sharpening_iReduceEdgeThresh
	0x0F12017C, //017C//70000B6C           //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//70000B6E           //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//70000B70           //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//70000B72           //AFIT16_demsharpmix1_iHighThreshold
	0x0F1200C8, //00C8//70000B74           //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8//70000B76           //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046//70000B78           //AFIT16_demsharpmix1_iLowSat
	0x0F120050, //0050//70000B7A           //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//70000B7C           //AFIT16_demsharpmix1_iTune
	0x0F120001, //0001//70000B7E//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//70000B80//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//70000B82//AFIT16_demsharpmix1_iHystCenter
	0x0F12008C, //008C//70000B84           //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//70000B86           //AFIT16_Sharpening_iHighSharpClamp
	0x0F12002D, //002D//70000B88           //AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F120019, //0019//70000B8A           //AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F12002D, //002D//70000B8C           //AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F120019, //0019//70000B8E           //AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//70000B90           //AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh
	0x0F121701, //1701//70000B92           //AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level
	0x0F120229, //0229//70000B94           //AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8
	0x0F121403, //1403//70000B96           //AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAl
	0x0F120004, //0004//70000B98           //AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotTh
	0x0F120300, //0300//70000B9A           //AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iCold
	0x0F120000, //0000//70000B9C           //AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoi
	0x0F1202FF, //02FF//70000B9E           //AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [
	0x0F1205DE, //05DE//70000BA0           //AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadial
	0x0F121414, //1414//70000BA2           //AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_
	0x0F120301, //0301//70000BA4           //AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHigh
	0x0F120007, //0007//70000BA6           //AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//70000BA8
	0x0F122303, //2303//70000BAA
	0x0F12231A, //231A//70000BAC
	0x0F120023, //0023//70000BAE
	0x0F121E80, //1E80//70000BB0           //AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_i
	0x0F121E08, //1E08//70000BB2           //AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosai
	0x0F12010A, //010A//70000BB4           //AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_
	0x0F120001, //0001//70000BB6           //AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaici
	0x0F123C0A, //3C0A//70000BB8           //AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpe
	0x0F122300, //2300//70000BBA           //AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iW
	0x0F120200, //0200//70000BBC           //AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nS
	0x0F12FF00, //FF00//70000BBE           //AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpeni
	0x0F120200, //0200//70000BC0           //AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demshar
	0x0F121E10, //1E10//70000BC2           //AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_i
	0x0F120000, //0000//70000BC4           //AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1
	0x0F120009, //0009//70000BC6           //AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpm
	0x0F120406, //0406//70000BC8           //AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix
	0x0F120705, //0705//70000BCA           //AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharp
	0x0F120306, //0306//70000BCC
	0x0F120509, //0509//70000BCE
	0x0F122806, //2806//70000BD0
	0x0F121428, //1428//70000BD2
	0x0F120518, //0518//70000BD4//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8005//70000BD6//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120080, //0080//70000BD8           //AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iD
	0x0F120080, //0080//70000BDA           //AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYO
	0x0F120080, //0080//70000BDC           //AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSatura
	0x0F120101, //0101//70000BDE           //AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClu
	0x0F120707, //0707//70000BE0           //AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClus
	0x0F124B01, //4B01//70000BE2           //AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_Disp
	0x0F122A4B, //2A4B//70000BE4           //AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenTh
	0x0F125020, //5020//70000BE6           //AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing
	0x0F120500, //0500//70000BE8           //AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Dem
	0x0F121C03, //1C03//70000BEA           //AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosa
	0x0F120D0C, //0D0C//70000BEC           //AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demos
	0x0F120823, //0823//70000BEE           //AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demos
	0x0F121428, //1428//70000BF0           //AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaici
	0x0F126401, //6401//70000BF2           //AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpen
	0x0F12282D, //282D//70000BF4           //AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpe
	0x0F122012, //2012//70000BF6           //AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpe
	0x0F120204, //0204//70000BF8           //AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsh
	0x0F123C03, //3C03//70000BFA           //AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd
	0x0F12013C, //013C//70000BFC           //AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000BFE           //AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_n
	0x0F121C1E, //1C1E//70000C00           //AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_Dis
	0x0F121E22, //1E22//70000C02           //AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_
	0x0F120028, //0028//70000C04           //AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosa
	0x0F12030A, //030A//70000C06           //AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8
	0x0F120214, //0214//70000C08           //AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_De
	0x0F120E14, //0E14//70000C0A           //AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_D
	0x0F12FF06, //FF06//70000C0C           //AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  A
	0x0F120432, //0432//70000C0E           //AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demo
	0x0F124052, //4052//70000C10           //AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sha
	0x0F12150C, //150C//70000C12           //AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Shar
	0x0F120440, //0440//70000C14           //AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8
	0x0F120302, //0302//70000C16           //AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_
	0x0F123C3C, //3C3C//70000C18           //AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a
	0x0F120101, //0101//70000C1A           //AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_
	0x0F121E01, //1E01//70000C1C           //AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a
	0x0F12221C, //221C//70000C1E           //AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_i
	0x0F12281E, //281E//70000C20           //AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosa
	0x0F120A00, //0A00//70000C22           //AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8
	0x0F121403, //1403//70000C24           //AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_
	0x0F121402, //1402//70000C26           //AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_
	0x0F12060E, //060E//70000C28           //AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_D
	0x0F1232FF, //32FF//70000C2A           //AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demo
	0x0F125204, //5204//70000C2C           //AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sh
	0x0F120C40, //0C40//70000C2E           //AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_S
	0x0F124015, //4015//70000C30           //AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sh
	0x0F120204, //0204//70000C32           //AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_
	0x0F120003, //0003//70000C34           //AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//70000C36
	0x0F120003, //0000//0000//70000C38//AFIT16_BRIGHTNESS
	0x0F120000, //0000//0000//70000C3A//AFIT16_CONTRAST
	0x0F120000, //0000//0000//70000C3C//AFIT16_SATURATION
	0x0F120000, //0000//0000//70000C3E//AFIT16_SHARP_BLUR
	0x0F120000, //0000//0000//70000C40//AFIT16_GLAMOUR
	0x0F1200C1, //00C1//00C1//70000C42//AFIT16_sddd8a_edge_high
	0x0F120000, //0000//0000//70000C44
	0x0F1203FF, //03FF//03FF//70000C46//AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C//0008//70000C48//AFIT16_Sharpening_iReduceEdgeThresh
	0x0F120251, //0251//017C//70000C4A//AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF//03FF//70000C4C//AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C//000C//70000C4E//AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010//0010//70000C50//AFIT16_demsharpmix1_iHighThreshold
	0x0F120032, //0032//0032//70000C52//AFIT16_demsharpmix1_iLowBright
	0x0F12028A, //028A//028A//70000C54//AFIT16_demsharpmix1_iHighBright
	0x0F120032, //0032//0032//70000C56//AFIT16_demsharpmix1_iLowSat
	0x0F1201F4, //01F4//01F4//70000C58//AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070//0070//70000C5A//AFIT16_demsharpmix1_iTune
	0x0F120002, //0002//0002//70000C5C//AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0000//0000//70000C5E//AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //0320//0320//70000C60//AFIT16_demsharpmix1_iHystCenter
	0x0F120044, //0044//0070//70000C62//AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0014//0014//70000C64//AFIT16_Sharpening_iHighSharpClamp
	0x0F120046, //0046//0046//70000C66//AFIT16_Sharpening_iLowSharpClamp_Bin
	0x0F120019, //0019//0019//70000C68//AFIT16_Sharpening_iHighSharpClamp_Bin
	0x0F120046, //0046//0046//70000C6A//AFIT16_Sharpening_iLowSharpClamp_sBin
	0x0F120019, //0019//0019//70000C6C//AFIT16_Sharpening_iHighSharpClamp_sBin
	0x0F120A24, //0A24//0A24//70000C6E//AFIT8_sddd8a_edge_low [7:0] AFIT8_sddd8a_repl_thresh [15:
	0x0F121701, //1701//1701//70000C70//AFIT8_sddd8a_repl_force [7:0] AFIT8_sddd8a_sat_level [15:
	0x0F120229, //0229//0229//70000C72//AFIT8_sddd8a_sat_thr[7:0] AFIT8_sddd8a_sat_mpl [15:8]
	0x0F120503, //0503//0503//70000C74//AFIT8_sddd8a_sat_noise[7:0] AFIT8_sddd8a_iMaxSlopeAllowed
	0x0F12080F, //080F//0101//70000C76//AFIT8_sddd8a_iHotThreshHigh[7:0] AFIT8_sddd8a_iHotThreshL
	0x0F120808, //0808//0101//70000C78//AFIT8_sddd8a_iColdThreshHigh[7:0] AFIT8_sddd8a_iColdThres
	0x0F120000, //0000//0000//70000C7A//AFIT8_sddd8a_AddNoisePower1[7:0] AFIT8_sddd8a_AddNoisePow
	0x0F1200FF, //00FF//02FF//70000C7C//AFIT8_sddd8a_iSatSat[7:0] AFIT8_sddd8a_iRadialTune [15:8]
	0x0F12012D, //012D//0396//70000C7E//AFIT8_sddd8a_iRadialLimit [7:0] AFIT8_sddd8a_iRadialPower
	0x0F121414, //1414//1414//70000C80//AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0] AFIT8_sddd8a_iHigh
	0x0F120301, //0301//0301//70000C82//AFIT8_sddd8a_iLowSlopeThresh[7:0] AFIT8_sddd8a_iHighSlope
	0x0F120007, //0007//0007//70000C84//AFIT8_sddd8a_iSquaresRounding [7:0]
	0x0F121000, //1000//1000//70000C86
	0x0F122003, //2003//2003//70000C88
	0x0F121020, //1020//1020//70000C8A
	0x0F120010, //0010//0010//70000C8C
	0x0F121EFF, //1EFF//1E80//70000C8E//AFIT8_Demosaicing_iCentGrad[7:0] AFIT8_Demosaicing_iMonoc
	0x0F121E06, //1E06//1E06//70000C90//AFIT8_Demosaicing_iDecisionThresh[7:0] AFIT8_Demosaicing_
	0x0F12060A, //060A//030C//70000C92//AFIT8_Demosaicing_iEnhThresh[7:0] AFIT8_Demosaicing_iGRDe
	0x0F120306, //0306//0103//70000C94//AFIT8_Demosaicing_iGBDenoiseVal[7:0] AFIT8_Demosaicing_iN
	0x0F128B0A, //8B0A//5A0A//70000C96//AFIT8_Demosaicing_iDFD_ReduceCoeff[7:0] AFIT8_Sharpening_
	0x0F122837, //2837//2D00//70000C98//AFIT8_Sharpening_iMShThresh[7:0] AFIT8_Sharpening_iWSharp
	0x0F120110, //0110//0100//70000C9A//AFIT8_Sharpening_iWShThresh[7:0] AFIT8_Sharpening_nSharpW
	0x0F12FF00, //FF00//FF00//70000C9C//AFIT8_Sharpening_iReduceNegative[7:0] AFIT8_Sharpening_iS
	0x0F120200, //0200//0200//70000C9E//AFIT8_demsharpmix1_iRGBMultiplier[7:0] AFIT8_demsharpmix1
	0x0F121E10, //1E10//1E10//70000CA0//AFIT8_demsharpmix1_iBCoeff[7:0] AFIT8_demsharpmix1_iGCoef
	0x0F120000, //0000//0000//70000CA2//AFIT8_demsharpmix1_iWideMult[7:0] AFIT8_demsharpmix1_iNar
	0x0F120009, //0009//0009//70000CA4//AFIT8_demsharpmix1_iHystFalloff[7:0] AFIT8_demsharpmix1_i
	0x0F120406, //0406//0406//70000CA6//AFIT8_demsharpmix1_iHystWidth[7:0] AFIT8_demsharpmix1_iHy
	0x0F120705, //0705//0705//70000CA8//AFIT8_demsharpmix1_iHystFallHigh[7:0] AFIT8_demsharpmix1_
	0x0F120305, //0305//0305//70000CAA
	0x0F120609, //0609//0609//70000CAC
	0x0F122C07, //2C07//2C07//70000CAE
	0x0F12142C, //142C//142C//70000CB0
	0x0F120B18, //0B18//0B18//70000CB2//[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F12800B, //800B//800B//70000CB4//[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShadingPower[15:8]
	0x0F120080, //0080//0080//70000CB6//AFIT8_RGBGamma2_iLinearity [7:0]  AFIT8_RGBGamma2_iDarkRe
	0x0F120080, //0080//0080//70000CB8//AFIT8_ccm_oscar_iSaturation[7:0]   AFIT8_RGB2YUV_iYOffset
	0x0F120080, //0080//0080//70000CBA//AFIT8_RGB2YUV_iRGBGain [7:0]   AFIT8_RGB2YUV_iSaturation
	0x0F125050, //5050//0101//70000CBC//AFIT8_sddd8a_iClustThresh_H [7:0]  AFIT8_sddd8a_iClustThr
	0x0F120101, //0101//0A0A//70000CBE//AFIT8_sddd8a_iClustMulT_H [7:0]   AFIT8_sddd8a_iClustMulT
	0x0F123201, //3201//3201//70000CC0//AFIT8_sddd8a_nClustLevel_H [7:0]   AFIT8_sddd8a_DispTH_Lo
	0x0F121832, //1832//1428//70000CC2//AFIT8_sddd8a_DispTH_High [7:0]   AFIT8_sddd8a_iDenThreshL
	0x0F12210C, //210C//100C//70000CC4//AFIT8_sddd8a_iDenThreshHigh[7:0]   AFIT8_Demosaicing_iEdg
	0x0F120A00, //0A00//0500//70000CC6//AFIT8_Demosaicing_iEdgeDesatThrLow [7:0]   AFIT8_Demosaic
	0x0F121E04, //1E04//1E02//70000CC8//AFIT8_Demosaicing_iEdgeDesatLimit[7:0]  AFIT8_Demosaicing
	0x0F120A08, //0A08//040C//70000CCA//AFIT8_Demosaicing_iDemSharpenHigh[7:0]   AFIT8_Demosaicin
	0x0F12070C, //070C//0828//70000CCC//AFIT8_Demosaicing_iDemShLowLimit [7:0]   AFIT8_Demosaicin
	0x0F123264, //3264//5064//70000CCE//AFIT8_Demosaicing_iDemBlurLow[7:0]   AFIT8_Demosaicing_iD
	0x0F125A02, //5A02//4605//70000CD0//AFIT8_Demosaicing_iDemBlurRange[7:0]   AFIT8_Sharpening_i
	0x0F121040, //1040//1E68//70000CD2//AFIT8_Sharpening_iHighSharpPower[7:0]   AFIT8_Sharpening_
	0x0F124012, //4012//201E//70000CD4//AFIT8_Sharpening_iHighShDenoise [7:0]   AFIT8_Sharpening_
	0x0F120604, //0604//0604//70000CD6//AFIT8_Sharpening_iReduceEdgeSlope [7:0]  AFIT8_demsharpmi
	0x0F124606, //4606//4606//70000CD8//AFIT8_demsharpmix1_iNarrFiltReduce [7:0]  AFIT8_sddd8a_iC
	0x0F120146, //0146//0146//70000CDA//AFIT8_sddd8a_iClustThresh_C_Bin [7:0]   AFIT8_sddd8a_iClu
	0x0F120101, //0101//0101//70000CDC//AFIT8_sddd8a_iClustMulT_C_Bin [7:0]   AFIT8_sddd8a_nClust
	0x0F121C18, //1C18//1C18//70000CDE//AFIT8_sddd8a_DispTH_Low_Bin [7:0]   AFIT8_sddd8a_DispTH_H
	0x0F121819, //1819//1819//70000CE0//AFIT8_sddd8a_iDenThreshLow_Bin [7:0]   AFIT8_sddd8a_iDenT
	0x0F120028, //0028//0028//70000CE2//AFIT8_Demosaicing_iEdgeDesat_Bin[7:0]   AFIT8_Demosaicing
	0x0F12030A, //030A//030A//70000CE4//AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0]  AFIT8_Demo
	0x0F120514, //0514//0514//70000CE6//AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0]  AFIT8_Demosai
	0x0F120C14, //0C14//0C14//70000CE8//AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0]  AFIT8_Demosa
	0x0F12FF05, //FF05//FF05//70000CEA//AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0]  AFIT8_
	0x0F120432, //0432//0432//70000CEC//AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0]  AFIT8_Demosaici
	0x0F124052, //4052//4052//70000CEE//AFIT8_Sharpening_iLowSharpPower_Bin [7:0]  AFIT8_Sharpeni
	0x0F121514, //1514//1514//70000CF0//AFIT8_Sharpening_iLowShDenoise_Bin [7:0]  AFIT8_Sharpenin
	0x0F120440, //0440//0440//70000CF2//AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0]  AFIT8_Shar
	0x0F120302, //0302//0302//70000CF4//AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0]  AFIT8_demsh
	0x0F124646, //4646//4646//70000CF6//AFIT8_sddd8a_iClustThresh_H_sBin[7:0]   AFIT8_sddd8a_iClu
	0x0F120101, //0101//0101//70000CF8//AFIT8_sddd8a_iClustMulT_H_sBin [7:0]   AFIT8_sddd8a_iClus
	0x0F121801, //1801//1801//70000CFA//AFIT8_sddd8a_nClustLevel_H_sBin [7:0]   AFIT8_sddd8a_Disp
	0x0F12191C, //191C//191C//70000CFC//AFIT8_sddd8a_DispTH_High_sBin [7:0]   AFIT8_sddd8a_iDenTh
	0x0F122818, //2818//2818//70000CFE//AFIT8_sddd8a_iDenThreshHigh_sBin[7:0]   AFIT8_Demosaicing
	0x0F120A00, //0A00//0A00//70000D00//AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0]  AFIT8_Demo
	0x0F121403, //1403//1403//70000D02//AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0]  AFIT8_Demos
	0x0F121405, //1405//1405//70000D04//AFIT8_Demosaicing_iDemSharpenHigh_sBin [7:0]  AFIT8_Demos
	0x0F12050C, //050C//050C//70000D06//AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0]  AFIT8_Demosa
	0x0F1232FF, //32FF//32FF//70000D08//AFIT8_Demosaicing_iDemBlurLow_sBin [7:0]  AFIT8_Demosaici
	0x0F125204, //5204//5204//70000D0A//AFIT8_Demosaicing_iDemBlurRange_sBin [7:0]  AFIT8_Sharpen
	0x0F121440, //1440//1440//70000D0C//AFIT8_Sharpening_iHighSharpPower_sBin [7:0]  AFIT8_Sharpe
	0x0F124015, //4015//4015//70000D0E//AFIT8_Sharpening_iHighShDenoise_sBin [7:0]  AFIT8_Sharpen
	0x0F120204, //0204//0204//70000D10//AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0]  AFIT8_demsh
	0x0F120003, //0003//0003//70000D12//AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]
	0x0F120001, //0001//0001//70000D14

	0x0F12BA7A, //70000D16
	0x0F124FDE, //70000D18
	0x0F12137F, //70000D1A
	0x0F123BDE, //70000D1C
	0x0F122102, //70000D1E
	0x0F1200B5, //70000D20

	//===================================================================
	// Brightness setting
	//===================================================================
	0x002A1300,
	0x0F12019D,

	0x002A1306,
	0x0F120280,
};

static const u32 s5k5ccgx_hd_init_reg[] = {
	//****************************************/
	0xFCFCD000,
	//****************************************/
	//===================================================================
	// History
	//===================================================================
	//20100717 : 1st release
	//20100806 : 2nd release for EVT0.1
	//20101028 : 3rd release for EVT1
	//WRITE #awbb_otp_disable  0000                            //awb otp use
	//==========================================================================================
	//-->The below registers are for FACTORY ONLY. if you change them without prior notification
	//   YOU are RESPONSIBLE for the FAILURE that will happen in the future.
	//==========================================================================================
	//===================================================================
	// Reset & Trap and Patch
	//===================================================================

	// Start of Trap and Patch
	//  2010-08-11 13:53:35
	0x00100001,
	0x10300000,
	0x00140001,

	0xFFFF000A, //p10
	// Start of Patch data
	// Start of Patch data
	0x00287000,
	/*++ Add ESD */
	0x002A0150,
	0x0F12AAAA,
	/*-- Add ESD */
	0x002A352C,
	0x0F12B570, // 7000352C
	0x0F124A24, // 7000352E
	0x0F124924, // 70003530
	0x0F124825, // 70003532
	0x0F124B25, // 70003534
	0x0F122500, // 70003536
	0x0F12801D, // 70003538
	0x0F12C004, // 7000353A
	0x0F126001, // 7000353C
	0x0F124924, // 7000353E
	0x0F124824, // 70003540
	0x0F12F000, // 70003542
	0x0F12FBBD, // 70003544
	0x0F124924, // 70003546
	0x0F124824, // 70003548
	0x0F12F000, // 7000354A
	0x0F12FBB9, // 7000354C
	0x0F124824, // 7000354E
	0x0F124E24, // 70003550
	0x0F126430, // 70003552
	0x0F124924, // 70003554
	0x0F124825, // 70003556
	0x0F12F000, // 70003558
	0x0F12FBB2, // 7000355A
	0x0F124924, // 7000355C
	0x0F120030, // 7000355E
	0x0F123080, // 70003560
	0x0F126141, // 70003562
	0x0F124C23, // 70003564
	0x0F128365, // 70003566
	0x0F124923, // 70003568
	0x0F124824, // 7000356A
	0x0F12F000, // 7000356C
	0x0F12FBA8, // 7000356E
	0x0F124923, // 70003570
	0x0F124824, // 70003572
	0x0F12F000, // 70003574
	0x0F12FBA4, // 70003576
	0x0F124923, // 70003578
	0x0F124824, // 7000357A
	0x0F12F000, // 7000357C
	0x0F12FBA0, // 7000357E
	0x0F124923, // 70003580
	0x0F124824, // 70003582
	0x0F12F000, // 70003584
	0x0F12FB9C, // 70003586
	0x0F128125, // 70003588
	0x0F124923, // 7000358A
	0x0F124823, // 7000358C
	0x0F12F000, // 7000358E
	0x0F12FB97, // 70003590
	0x0F124923, // 70003592
	0x0F124823, // 70003594
	0x0F12F000, // 70003596
	0x0F12FB93, // 70003598
	0x0F1283A5, // 7000359A
	0x0F124922, // 7000359C
	0x0F124823, // 7000359E
	0x0F12F000, // 700035A0
	0x0F12FB8E, // 700035A2
	0x0F122101, // 700035A4
	0x0F120349, // 700035A6
	0x0F120020, // 700035A8
	0x0F123020, // 700035AA
	0x0F128041, // 700035AC
	0x0F122185, // 700035AE
	0x0F128081, // 700035B0
	0x0F12491F, // 700035B2
	0x0F1280C1, // 700035B4
	0x0F12481F, // 700035B6
	0x0F126730, // 700035B8
	0x0F12BC70, // 700035BA
	0x0F12BC08, // 700035BC
	0x0F124718, // 700035BE
	0x0F1200CA, // 700035C0
	0x0F125CC1, // 700035C2
	0x0F1203BD, // 700035C4
	0x0F120000, // 700035C6
	0x0F121C08, // 700035C8
	0x0F127000, // 700035CA
	0x0F123290, // 700035CC
	0x0F127000, // 700035CE
	0x0F123657, // 700035D0
	0x0F127000, // 700035D2
	0x0F12D9E7, // 700035D4
	0x0F120000, // 700035D6
	0x0F12383F, // 700035D8
	0x0F127000, // 700035DA
	0x0F12395D, // 700035DC
	0x0F120000, // 700035DE
	0x0F1238D1, // 700035E0
	0x0F127000, // 700035E2
	0x0F120000, // 700035E4
	0x0F127000, // 700035E6
	0x0F12399D, // 700035E8
	0x0F127000, // 700035EA
	0x0F12F903, // 700035EC
	0x0F120000, // 700035EE
	0x0F123AC1, // 700035F0
	0x0F127000, // 700035F2
	0x0F123FC8, // 700035F4
	0x0F127000, // 700035F6
	0x0F12368F, // 700035F8
	0x0F127000, // 700035FA
	0x0F12495F, // 700035FC
	0x0F120000, // 700035FE
	0x0F1236ED, // 70003600
	0x0F127000, // 70003602
	0x0F12E421, // 70003604
	0x0F120000, // 70003606
	0x0F1237AB, // 70003608
	0x0F127000, // 7000360A
	0x0F12216D, // 7000360C
	0x0F120000, // 7000360E
	0x0F12381F, // 70003610
	0x0F127000, // 70003612
	0x0F120179, // 70003614
	0x0F120001, // 70003616
	0x0F123BD5, // 70003618
	0x0F127000, // 7000361A
	0x0F1204C9, // 7000361C
	0x0F120000, // 7000361E
	0x0F123B25, // 70003620
	0x0F127000, // 70003622
	0x0F125027, // 70003624
	0x0F120000, // 70003626
	0x0F123BE1, // 70003628
	0x0F127000, // 7000362A
	0x0F1242B7, // 7000362C
	0x0F120000, // 7000362E
	0x0F1207FF, // 70003630
	0x0F120000, // 70003632
	0x0F123C5F, // 70003634
	0x0F127000, // 70003636
	0x0F12B570, // 70003638
	0x0F12000D, // 7000363A
	0x0F124CFC, // 7000363C
	0x0F128821, // 7000363E
	0x0F12F000, // 70003640
	0x0F12FB46, // 70003642
	0x0F128820, // 70003644
	0x0F124AFB, // 70003646
	0x0F120081, // 70003648
	0x0F125055, // 7000364A
	0x0F121C40, // 7000364C
	0x0F128020, // 7000364E
	0x0F12BC70, // 70003650
	0x0F12BC08, // 70003652
	0x0F124718, // 70003654
	0x0F126801, // 70003656
	0x0F120409, // 70003658
	0x0F120C09, // 7000365A
	0x0F126840, // 7000365C
	0x0F120400, // 7000365E
	0x0F120C00, // 70003660
	0x0F124AF5, // 70003662
	0x0F128992, // 70003664
	0x0F122A00, // 70003666
	0x0F12D00D, // 70003668
	0x0F122300, // 7000366A
	0x0F121A80, // 7000366C
	0x0F12D400, // 7000366E
	0x0F120003, // 70003670
	0x0F120418, // 70003672
	0x0F120C00, // 70003674
	0x0F124BF1, // 70003676
	0x0F121851, // 70003678
	0x0F12891B, // 7000367A
	0x0F12428B, // 7000367C
	0x0F12D300, // 7000367E
	0x0F12000B, // 70003680
	0x0F120419, // 70003682
	0x0F120C09, // 70003684
	0x0F124AEE, // 70003686
	0x0F128151, // 70003688
	0x0F128190, // 7000368A
	0x0F124770, // 7000368C
	0x0F12B510, // 7000368E
	0x0F124CEC, // 70003690
	0x0F1248ED, // 70003692
	0x0F1278A1, // 70003694
	0x0F122900, // 70003696
	0x0F12D101, // 70003698
	0x0F1287C1, // 7000369A
	0x0F12E004, // 7000369C
	0x0F127AE1, // 7000369E
	0x0F122900, // 700036A0
	0x0F12D001, // 700036A2
	0x0F122101, // 700036A4
	0x0F1287C1, // 700036A6
	0x0F12F000, // 700036A8
	0x0F12FB1A, // 700036AA
	0x0F1249E7, // 700036AC
	0x0F128B08, // 700036AE
	0x0F1206C2, // 700036B0
	0x0F12D50A, // 700036B2
	0x0F127AA2, // 700036B4
	0x0F120652, // 700036B6
	0x0F12D507, // 700036B8
	0x0F122210, // 700036BA
	0x0F124390, // 700036BC
	0x0F128308, // 700036BE
	0x0F1248E3, // 700036C0
	0x0F127AE1, // 700036C2
	0x0F126B00, // 700036C4
	0x0F12F000, // 700036C6
	0x0F12FB13, // 700036C8
	0x0F1248DB, // 700036CA
	0x0F1289C0, // 700036CC
	0x0F122801, // 700036CE
	0x0F12D109, // 700036D0
	0x0F1278A0, // 700036D2
	0x0F122800, // 700036D4
	0x0F12D006, // 700036D6
	0x0F127AE0, // 700036D8
	0x0F122800, // 700036DA
	0x0F12D003, // 700036DC
	0x0F127AA0, // 700036DE
	0x0F122140, // 700036E0
	0x0F124308, // 700036E2
	0x0F1272A0, // 700036E4
	0x0F12BC10, // 700036E6
	0x0F12BC08, // 700036E8
	0x0F124718, // 700036EA
	0x0F12B570, // 700036EC
	0x0F124DD7, // 700036EE
	0x0F124CD7, // 700036F0
	0x0F128B28, // 700036F2
	0x0F120701, // 700036F4
	0x0F12D507, // 700036F6
	0x0F122108, // 700036F8
	0x0F124388, // 700036FA
	0x0F128328, // 700036FC
	0x0F1249D5, // 700036FE
	0x0F126B20, // 70003700
	0x0F126B89, // 70003702
	0x0F12F000, // 70003704
	0x0F12FAFC, // 70003706
	0x0F128B28, // 70003708
	0x0F1206C1, // 7000370A
	0x0F12D5A0, // 7000370C
	0x0F1249CD, // 7000370E
	0x0F127A8A, // 70003710
	0x0F120652, // 70003712
	0x0F12D49C, // 70003714
	0x0F122210, // 70003716
	0x0F124390, // 70003718
	0x0F128328, // 7000371A
	0x0F127AC9, // 7000371C
	0x0F126B20, // 7000371E
	0x0F12F000, // 70003720
	0x0F12FAE6, // 70003722
	0x0F12E794, // 70003724
	0x0F12B5F8, // 70003726
	0x0F1249CB, // 70003728
	0x0F128F08, // 7000372A
	0x0F12000C, // 7000372C
	0x0F123480, // 7000372E
	0x0F122800, // 70003730
	0x0F12D000, // 70003732
	0x0F128360, // 70003734
	0x0F122000, // 70003736
	0x0F128708, // 70003738
	0x0F124DC8, // 7000373A
	0x0F1226FF, // 7000373C
	0x0F128828, // 7000373E
	0x0F121C76, // 70003740
	0x0F122702, // 70003742
	0x0F122803, // 70003744
	0x0F12D112, // 70003746
	0x0F128868, // 70003748
	0x0F122800, // 7000374A
	0x0F12D10F, // 7000374C
	0x0F1288E8, // 7000374E
	0x0F122800, // 70003750
	0x0F12D10C, // 70003752
	0x0F12F000, // 70003754
	0x0F12FADC, // 70003756
	0x0F122800, // 70003758
	0x0F12D008, // 7000375A
	0x0F128B60, // 7000375C
	0x0F122800, // 7000375E
	0x0F12D001, // 70003760
	0x0F1280EE, // 70003762
	0x0F1280AF, // 70003764
	0x0F122001, // 70003766
	0x0F127268, // 70003768
	0x0F12F000, // 7000376A
	0x0F12FAD9, // 7000376C
	0x0F128828, // 7000376E
	0x0F122802, // 70003770
	0x0F12D10E, // 70003772
	0x0F128868, // 70003774
	0x0F122800, // 70003776
	0x0F12D10B, // 70003778
	0x0F1288E8, // 7000377A
	0x0F122800, // 7000377C
	0x0F12D108, // 7000377E
	0x0F128B60, // 70003780
	0x0F122800, // 70003782
	0x0F12D001, // 70003784
	0x0F1280EE, // 70003786
	0x0F1280AF, // 70003788
	0x0F122001, // 7000378A
	0x0F127268, // 7000378C
	0x0F12F000, // 7000378E
	0x0F12FAC7, // 70003790
	0x0F1288E8, // 70003792
	0x0F122800, // 70003794
	0x0F12D006, // 70003796
	0x0F121FC1, // 70003798
	0x0F1239FD, // 7000379A
	0x0F12D003, // 7000379C
	0x0F122001, // 7000379E
	0x0F12BCF8, // 700037A0
	0x0F12BC08, // 700037A2
	0x0F124718, // 700037A4
	0x0F122000, // 700037A6
	0x0F12E7FA, // 700037A8
	0x0F12B570, // 700037AA
	0x0F124CAC, // 700037AC
	0x0F128860, // 700037AE
	0x0F122800, // 700037B0
	0x0F12D00C, // 700037B2
	0x0F128820, // 700037B4
	0x0F124DA3, // 700037B6
	0x0F122800, // 700037B8
	0x0F12D009, // 700037BA
	0x0F120029, // 700037BC
	0x0F1231A0, // 700037BE
	0x0F127AC9, // 700037C0
	0x0F122900, // 700037C2
	0x0F12D004, // 700037C4
	0x0F127AA8, // 700037C6
	0x0F122180, // 700037C8
	0x0F124308, // 700037CA
	0x0F1272A8, // 700037CC
	0x0F12E73F, // 700037CE
	0x0F122800, // 700037D0
	0x0F12D003, // 700037D2
	0x0F12F7FF, // 700037D4
	0x0F12FFA7, // 700037D6
	0x0F122800, // 700037D8
	0x0F12D1F8, // 700037DA
	0x0F122000, // 700037DC
	0x0F128060, // 700037DE
	0x0F128820, // 700037E0
	0x0F122800, // 700037E2
	0x0F12D003, // 700037E4
	0x0F122008, // 700037E6
	0x0F12F000, // 700037E8
	0x0F12FAA2, // 700037EA
	0x0F12E00B, // 700037EC
	0x0F12489C, // 700037EE
	0x0F123020, // 700037F0
	0x0F128880, // 700037F2
	0x0F122800, // 700037F4
	0x0F12D103, // 700037F6
	0x0F127AA8, // 700037F8
	0x0F122101, // 700037FA
	0x0F124308, // 700037FC
	0x0F1272A8, // 700037FE
	0x0F122010, // 70003800
	0x0F12F000, // 70003802
	0x0F12FA95, // 70003804
	0x0F128820, // 70003806
	0x0F122800, // 70003808
	0x0F12D1E0, // 7000380A
	0x0F12488A, // 7000380C
	0x0F1289C0, // 7000380E
	0x0F122801, // 70003810
	0x0F12D1DC, // 70003812
	0x0F127AA8, // 70003814
	0x0F1221BF, // 70003816
	0x0F124008, // 70003818
	0x0F1272A8, // 7000381A
	0x0F12E718, // 7000381C
	0x0F126800, // 7000381E
	0x0F124990, // 70003820
	0x0F128188, // 70003822
	0x0F124890, // 70003824
	0x0F122201, // 70003826
	0x0F128981, // 70003828
	0x0F124890, // 7000382A
	0x0F120252, // 7000382C
	0x0F124291, // 7000382E
	0x0F12D902, // 70003830
	0x0F122102, // 70003832
	0x0F128181, // 70003834
	0x0F124770, // 70003836
	0x0F122101, // 70003838
	0x0F128181, // 7000383A
	0x0F124770, // 7000383C
	0x0F12B5F1, // 7000383E
	0x0F124E80, // 70003840
	0x0F128834, // 70003842
	0x0F122C00, // 70003844
	0x0F12D03F, // 70003846
	0x0F122001, // 70003848
	0x0F122C08, // 7000384A
	0x0F12D000, // 7000384C
	0x0F122000, // 7000384E
	0x0F1270B0, // 70003850
	0x0F124D7F, // 70003852
	0x0F122800, // 70003854
	0x0F12D009, // 70003856
	0x0F12F000, // 70003858
	0x0F12FA72, // 7000385A
	0x0F120028, // 7000385C
	0x0F1238F0, // 7000385E
	0x0F126328, // 70003860
	0x0F127AB0, // 70003862
	0x0F12217E, // 70003864
	0x0F124008, // 70003866
	0x0F1272B0, // 70003868
	0x0F12E00F, // 7000386A
	0x0F124F7A, // 7000386C
	0x0F123780, // 7000386E
	0x0F128B78, // 70003870
	0x0F122800, // 70003872
	0x0F12D005, // 70003874
	0x0F12F000, // 70003876
	0x0F12FA6B, // 70003878
	0x0F122000, // 7000387A
	0x0F128378, // 7000387C
	0x0F124976, // 7000387E
	0x0F128708, // 70003880
	0x0F122000, // 70003882
	0x0F12F000, // 70003884
	0x0F12FA6C, // 70003886
	0x0F124879, // 70003888
	0x0F126328, // 7000388A
	0x0F1278B1, // 7000388C
	0x0F122700, // 7000388E
	0x0F120038, // 70003890
	0x0F122900, // 70003892
	0x0F12D008, // 70003894
	0x0F124972, // 70003896
	0x0F123920, // 70003898
	0x0F128ACA, // 7000389A
	0x0F122A00, // 7000389C
	0x0F12D003, // 7000389E
	0x0F128B09, // 700038A0
	0x0F122900, // 700038A2
	0x0F12D000, // 700038A4
	0x0F122001, // 700038A6
	0x0F127170, // 700038A8
	0x0F122C02, // 700038AA
	0x0F12D102, // 700038AC
	0x0F124868, // 700038AE
	0x0F123860, // 700038B0
	0x0F126328, // 700038B2
	0x0F122201, // 700038B4
	0x0F122C02, // 700038B6
	0x0F12D000, // 700038B8
	0x0F122200, // 700038BA
	0x0F124861, // 700038BC
	0x0F122110, // 700038BE
	0x0F12300A, // 700038C0
	0x0F12F000, // 700038C2
	0x0F12FA55, // 700038C4
	0x0F128037, // 700038C6
	0x0F129900, // 700038C8
	0x0F120020, // 700038CA
	0x0F12600C, // 700038CC
	0x0F12E767, // 700038CE
	0x0F12B538, // 700038D0
	0x0F124865, // 700038D2
	0x0F124669, // 700038D4
	0x0F123848, // 700038D6
	0x0F12F000, // 700038D8
	0x0F12FA52, // 700038DA
	0x0F124A5E, // 700038DC
	0x0F124862, // 700038DE
	0x0F128F51, // 700038E0
	0x0F122400, // 700038E2
	0x0F123020, // 700038E4
	0x0F122900, // 700038E6
	0x0F12D00A, // 700038E8
	0x0F128754, // 700038EA
	0x0F126941, // 700038EC
	0x0F126451, // 700038EE
	0x0F126491, // 700038F0
	0x0F12466B, // 700038F2
	0x0F128819, // 700038F4
	0x0F1287D1, // 700038F6
	0x0F12885B, // 700038F8
	0x0F120011, // 700038FA
	0x0F123140, // 700038FC
	0x0F12800B, // 700038FE
	0x0F128F91, // 70003900
	0x0F122900, // 70003902
	0x0F12D002, // 70003904
	0x0F128794, // 70003906
	0x0F126940, // 70003908
	0x0F126490, // 7000390A
	0x0F12F000, // 7000390C
	0x0F12FA40, // 7000390E
	0x0F12BC38, // 70003910
	0x0F12BC08, // 70003912
	0x0F124718, // 70003914
	0x0F12B5F8, // 70003916
	0x0F124C56, // 70003918
	0x0F1289E0, // 7000391A
	0x0F12F000, // 7000391C
	0x0F12FA40, // 7000391E
	0x0F120006, // 70003920
	0x0F128A20, // 70003922
	0x0F12F000, // 70003924
	0x0F12FA44, // 70003926
	0x0F120007, // 70003928
	0x0F12484F, // 7000392A
	0x0F124D4A, // 7000392C
	0x0F123020, // 7000392E
	0x0F126CA9, // 70003930
	0x0F126940, // 70003932
	0x0F121809, // 70003934
	0x0F120200, // 70003936
	0x0F12F000, // 70003938
	0x0F12FA42, // 7000393A
	0x0F120400, // 7000393C
	0x0F120C00, // 7000393E
	0x0F12002A, // 70003940
	0x0F12326E, // 70003942
	0x0F120011, // 70003944
	0x0F12390A, // 70003946
	0x0F122305, // 70003948
	0x0F12F000, // 7000394A
	0x0F12FA3F, // 7000394C
	0x0F124C43, // 7000394E
	0x0F1261A0, // 70003950
	0x0F128FEB, // 70003952
	0x0F120002, // 70003954
	0x0F120031, // 70003956
	0x0F120018, // 70003958
	0x0F12F000, // 7000395A
	0x0F12FA3F, // 7000395C
	0x0F12466B, // 7000395E
	0x0F120005, // 70003960
	0x0F128018, // 70003962
	0x0F12483C, // 70003964
	0x0F1269A2, // 70003966
	0x0F123040, // 70003968
	0x0F128800, // 7000396A
	0x0F120039, // 7000396C
	0x0F12F000, // 7000396E
	0x0F12FA35, // 70003970
	0x0F12466B, // 70003972
	0x0F120006, // 70003974
	0x0F128058, // 70003976
	0x0F120021, // 70003978
	0x0F129800, // 7000397A
	0x0F12311C, // 7000397C
	0x0F12F000, // 7000397E
	0x0F12FA35, // 70003980
	0x0F124935, // 70003982
	0x0F123180, // 70003984
	0x0F12808D, // 70003986
	0x0F1280CE, // 70003988
	0x0F128BA1, // 7000398A
	0x0F124836, // 7000398C
	0x0F123820, // 7000398E
	0x0F128001, // 70003990
	0x0F128BE1, // 70003992
	0x0F128041, // 70003994
	0x0F128C21, // 70003996
	0x0F128081, // 70003998
	0x0F12E701, // 7000399A
	0x0F12B5F8, // 7000399C
	0x0F124E2E, // 7000399E
	0x0F126C70, // 700039A0
	0x0F126CB1, // 700039A2
	0x0F120200, // 700039A4
	0x0F12F000, // 700039A6
	0x0F12FA0B, // 700039A8
	0x0F120400, // 700039AA
	0x0F120C00, // 700039AC
	0x0F122401, // 700039AE
	0x0F120364, // 700039B0
	0x0F1242A0, // 700039B2
	0x0F12D200, // 700039B4
	0x0F120004, // 700039B6
	0x0F124A27, // 700039B8
	0x0F120020, // 700039BA
	0x0F12327E, // 700039BC
	0x0F121F91, // 700039BE
	0x0F122303, // 700039C0
	0x0F12F000, // 700039C2
	0x0F12FA03, // 700039C4
	0x0F120405, // 700039C6
	0x0F120C2D, // 700039C8
	0x0F124A23, // 700039CA
	0x0F120020, // 700039CC
	0x0F12325A, // 700039CE
	0x0F120011, // 700039D0
	0x0F12390A, // 700039D2
	0x0F122305, // 700039D4
	0x0F12F000, // 700039D6
	0x0F12F9F9, // 700039D8
	0x0F12491F, // 700039DA
	0x0F1264C8, // 700039DC
	0x0F12491F, // 700039DE
	0x0F124E21, // 700039E0
	0x0F1288C8, // 700039E2
	0x0F122701, // 700039E4
	0x0F122800, // 700039E6
	0x0F12D009, // 700039E8
	0x0F124C23, // 700039EA
	0x0F1238FF, // 700039EC
	0x0F121E40, // 700039EE
	0x0F12D00A, // 700039F0
	0x0F122804, // 700039F2
	0x0F12D042, // 700039F4
	0x0F122806, // 700039F6
	0x0F12D101, // 700039F8
	0x0F122000, // 700039FA
	0x0F1280C8, // 700039FC
	0x0F1282B7, // 700039FE
	0x0F122001, // 70003A00
	0x0F12F000, // 70003A02
	0x0F12F9FB, // 70003A04
	0x0F12E6CB, // 70003A06
	0x0F12000D, // 70003A08
	0x0F12724F, // 70003A0A
	0x0F122001, // 70003A0C
	0x0F12F000, // 70003A0E
	0x0F12F9FD, // 70003A10
	0x0F12F000, // 70003A12
	0x0F12FA03, // 70003A14
	0x0F124910, // 70003A16
	0x0F123148, // 70003A18
	0x0F12C903, // 70003A1A
	0x0F124348, // 70003A1C
	0x0F120A00, // 70003A1E
	0x0F126160, // 70003A20
	0x0F1220FF, // 70003A22
	0x0F121D40, // 70003A24
	0x0F1280E8, // 70003A26
	0x0F12480C, // 70003A28
	0x0F123040, // 70003A2A
	0x0F127707, // 70003A2C
	0x0F12E7E6, // 70003A2E
	0x0F123290, // 70003A30
	0x0F127000, // 70003A32
	0x0F123294, // 70003A34
	0x0F127000, // 70003A36
	0x0F1204A8, // 70003A38
	0x0F127000, // 70003A3A
	0x0F1215DC, // 70003A3C
	0x0F127000, // 70003A3E
	0x0F125000, // 70003A40
	0x0F12D000, // 70003A42
	0x0F121E84, // 70003A44
	0x0F127000, // 70003A46
	0x0F121BE4, // 70003A48
	0x0F127000, // 70003A4A
	0x0F122EA8, // 70003A4C
	0x0F127000, // 70003A4E
	0x0F1221A4, // 70003A50
	0x0F127000, // 70003A52
	0x0F120100, // 70003A54
	0x0F127000, // 70003A56
	0x0F123F48, // 70003A58
	0x0F127000, // 70003A5A
	0x0F1231A0, // 70003A5C
	0x0F127000, // 70003A5E
	0x0F1201E8, // 70003A60
	0x0F127000, // 70003A62
	0x0F12F2A0, // 70003A64
	0x0F12D000, // 70003A66
	0x0F122A44, // 70003A68
	0x0F127000, // 70003A6A
	0x0F12F400, // 70003A6C
	0x0F12D000, // 70003A6E
	0x0F122024, // 70003A70
	0x0F127000, // 70003A72
	0x0F121650, // 70003A74
	0x0F127000, // 70003A76
	0x0F122A64, // 70003A78
	0x0F127000, // 70003A7A
	0x0F124982, // 70003A7C
	0x0F12724F, // 70003A7E
	0x0F1220FF, // 70003A80
	0x0F121DC0, // 70003A82
	0x0F1280C8, // 70003A84
	0x0F12F000, // 70003A86
	0x0F12F9D1, // 70003A88
	0x0F124980, // 70003A8A
	0x0F126ACA, // 70003A8C
	0x0F12604A, // 70003A8E
	0x0F122800, // 70003A90
	0x0F12D006, // 70003A92
	0x0F12436A, // 70003A94
	0x0F120001, // 70003A96
	0x0F120010, // 70003A98
	0x0F12F000, // 70003A9A
	0x0F12F991, // 70003A9C
	0x0F126160, // 70003A9E
	0x0F12E001, // 70003AA0
	0x0F12436A, // 70003AA2
	0x0F126162, // 70003AA4
	0x0F128BF0, // 70003AA6
	0x0F122800, // 70003AA8
	0x0F12D001, // 70003AAA
	0x0F12F7FF, // 70003AAC
	0x0F12FF33, // 70003AAE
	0x0F122000, // 70003AB0
	0x0F12F000, // 70003AB2
	0x0F12F9AB, // 70003AB4
	0x0F124974, // 70003AB6
	0x0F1220FF, // 70003AB8
	0x0F121DC0, // 70003ABA
	0x0F1280C8, // 70003ABC
	0x0F12E79E, // 70003ABE
	0x0F12B510, // 70003AC0
	0x0F12F000, // 70003AC2
	0x0F12F9BB, // 70003AC4
	0x0F124870, // 70003AC6
	0x0F1288C0, // 70003AC8
	0x0F121FC1, // 70003ACA
	0x0F1239FD, // 70003ACC
	0x0F12D103, // 70003ACE
	0x0F12496F, // 70003AD0
	0x0F1220FF, // 70003AD2
	0x0F121C40, // 70003AD4
	0x0F128048, // 70003AD6
	0x0F12E605, // 70003AD8
	0x0F12B5F8, // 70003ADA
	0x0F122400, // 70003ADC
	0x0F124D6D, // 70003ADE
	0x0F12486D, // 70003AE0
	0x0F12210E, // 70003AE2
	0x0F128041, // 70003AE4
	0x0F122101, // 70003AE6
	0x0F128001, // 70003AE8
	0x0F12F000, // 70003AEA
	0x0F12F9AF, // 70003AEC
	0x0F12486B, // 70003AEE
	0x0F128840, // 70003AF0
	0x0F12F000, // 70003AF2
	0x0F12F9B3, // 70003AF4
	0x0F124E6A, // 70003AF6
	0x0F12270D, // 70003AF8
	0x0F12073F, // 70003AFA
	0x0F1219E8, // 70003AFC
	0x0F128803, // 70003AFE
	0x0F1200E2, // 70003B00
	0x0F121991, // 70003B02
	0x0F12804B, // 70003B04
	0x0F128843, // 70003B06
	0x0F1252B3, // 70003B08
	0x0F128882, // 70003B0A
	0x0F1280CA, // 70003B0C
	0x0F1288C0, // 70003B0E
	0x0F128088, // 70003B10
	0x0F123508, // 70003B12
	0x0F12042D, // 70003B14
	0x0F120C2D, // 70003B16
	0x0F121C64, // 70003B18
	0x0F120424, // 70003B1A
	0x0F120C24, // 70003B1C
	0x0F122C07, // 70003B1E
	0x0F12D3EC, // 70003B20
	0x0F12E63D, // 70003B22
	0x0F12B5F0, // 70003B24
	0x0F12B085, // 70003B26
	0x0F126801, // 70003B28
	0x0F129103, // 70003B2A
	0x0F126881, // 70003B2C
	0x0F12040A, // 70003B2E
	0x0F120C12, // 70003B30
	0x0F12495C, // 70003B32
	0x0F128B89, // 70003B34
	0x0F122900, // 70003B36
	0x0F12D001, // 70003B38
	0x0F120011, // 70003B3A
	0x0F12E000, // 70003B3C
	0x0F122100, // 70003B3E
	0x0F129102, // 70003B40
	0x0F126840, // 70003B42
	0x0F120401, // 70003B44
	0x0F129803, // 70003B46
	0x0F120C09, // 70003B48
	0x0F12F000, // 70003B4A
	0x0F12F98F, // 70003B4C
	0x0F124854, // 70003B4E
	0x0F123080, // 70003B50
	0x0F128900, // 70003B52
	0x0F122800, // 70003B54
	0x0F12D039, // 70003B56
	0x0F122100, // 70003B58
	0x0F124854, // 70003B5A
	0x0F124D52, // 70003B5C
	0x0F124684, // 70003B5E
	0x0F124B53, // 70003B60
	0x0F124C4F, // 70003B62
	0x0F1288DA, // 70003B64
	0x0F120048, // 70003B66
	0x0F1200D7, // 70003B68
	0x0F12193E, // 70003B6A
	0x0F12197F, // 70003B6C
	0x0F12183F, // 70003B6E
	0x0F125A36, // 70003B70
	0x0F128AFF, // 70003B72
	0x0F12437E, // 70003B74
	0x0F1200B6, // 70003B76
	0x0F120C37, // 70003B78
	0x0F121906, // 70003B7A
	0x0F123680, // 70003B7C
	0x0F128177, // 70003B7E
	0x0F121C52, // 70003B80
	0x0F1200D2, // 70003B82
	0x0F121914, // 70003B84
	0x0F121952, // 70003B86
	0x0F121812, // 70003B88
	0x0F125A24, // 70003B8A
	0x0F128AD2, // 70003B8C
	0x0F124354, // 70003B8E
	0x0F1200A2, // 70003B90
	0x0F120C12, // 70003B92
	0x0F128272, // 70003B94
	0x0F12891C, // 70003B96
	0x0F12895B, // 70003B98
	0x0F124367, // 70003B9A
	0x0F12435A, // 70003B9C
	0x0F121943, // 70003B9E
	0x0F123340, // 70003BA0
	0x0F1289DB, // 70003BA2
	0x0F129C02, // 70003BA4
	0x0F1218BA, // 70003BA6
	0x0F124363, // 70003BA8
	0x0F1218D2, // 70003BAA
	0x0F120212, // 70003BAC
	0x0F120C12, // 70003BAE
	0x0F12466B, // 70003BB0
	0x0F12521A, // 70003BB2
	0x0F124663, // 70003BB4
	0x0F127DDB, // 70003BB6
	0x0F12435A, // 70003BB8
	0x0F129B03, // 70003BBA
	0x0F120252, // 70003BBC
	0x0F120C12, // 70003BBE
	0x0F12521A, // 70003BC0
	0x0F121C49, // 70003BC2
	0x0F120409, // 70003BC4
	0x0F120C09, // 70003BC6
	0x0F122904, // 70003BC8
	0x0F12D3C9, // 70003BCA
	0x0F12B005, // 70003BCC
	0x0F12BCF0, // 70003BCE
	0x0F12BC08, // 70003BD0
	0x0F124718, // 70003BD2
	0x0F12B510, // 70003BD4
	0x0F12F7FF, // 70003BD6
	0x0F12FF80, // 70003BD8
	0x0F12F000, // 70003BDA
	0x0F12F94F, // 70003BDC
	0x0F12E582, // 70003BDE
	0x0F12B570, // 70003BE0
	0x0F126804, // 70003BE2
	0x0F12F000, // 70003BE4
	0x0F12F952, // 70003BE6
	0x0F124D32, // 70003BE8
	0x0F128C29, // 70003BEA
	0x0F121A40, // 70003BEC
	0x0F1242A0, // 70003BEE
	0x0F12D901, // 70003BF0
	0x0F120020, // 70003BF2
	0x0F12E003, // 70003BF4
	0x0F12F000, // 70003BF6
	0x0F12F949, // 70003BF8
	0x0F128C29, // 70003BFA
	0x0F121A40, // 70003BFC
	0x0F126268, // 70003BFE
	0x0F12F000, // 70003C00
	0x0F12F94C, // 70003C02
	0x0F1262A8, // 70003C04
	0x0F12F000, // 70003C06
	0x0F12F951, // 70003C08
	0x0F126328, // 70003C0A
	0x0F128869, // 70003C0C
	0x0F122900, // 70003C0E
	0x0F12D000, // 70003C10
	0x0F1262A8, // 70003C12
	0x0F124828, // 70003C14
	0x0F126B00, // 70003C16
	0x0F128C00, // 70003C18
	0x0F122800, // 70003C1A
	0x0F12D11B, // 70003C1C
	0x0F126AA8, // 70003C1E
	0x0F12F000, // 70003C20
	0x0F12F94C, // 70003C22
	0x0F1261E8, // 70003C24
	0x0F124A1E, // 70003C26
	0x0F123280, // 70003C28
	0x0F128B91, // 70003C2A
	0x0F122900, // 70003C2C
	0x0F12D00B, // 70003C2E
	0x0F120011, // 70003C30
	0x0F123120, // 70003C32
	0x0F128809, // 70003C34
	0x0F124288, // 70003C36
	0x0F12D907, // 70003C38
	0x0F1261E9, // 70003C3A
	0x0F128C28, // 70003C3C
	0x0F121A08, // 70003C3E
	0x0F1262A8, // 70003C40
	0x0F12F000, // 70003C42
	0x0F12F92B, // 70003C44
	0x0F1262A8, // 70003C46
	0x0F12E502, // 70003C48
	0x0F128BD1, // 70003C4A
	0x0F124288, // 70003C4C
	0x0F12D800, // 70003C4E
	0x0F120008, // 70003C50
	0x0F1261E8, // 70003C52
	0x0F12E4FC, // 70003C54
	0x0F12F000, // 70003C56
	0x0F12F919, // 70003C58
	0x0F1261E8, // 70003C5A
	0x0F12E4F8, // 70003C5C
	0x0F12B510, // 70003C5E
	0x0F12F000, // 70003C60
	0x0F12F934, // 70003C62
	0x0F12480E, // 70003C64
	0x0F1230A0, // 70003C66
	0x0F128841, // 70003C68
	0x0F122900, // 70003C6A
	0x0F12D007, // 70003C6C
	0x0F124A07, // 70003C6E
	0x0F123280, // 70003C70
	0x0F126953, // 70003C72
	0x0F124A11, // 70003C74
	0x0F12428B, // 70003C76
	0x0F12D202, // 70003C78
	0x0F128880, // 70003C7A
	0x0F1281D0, // 70003C7C
	0x0F12E532, // 70003C7E
	0x0F1288C0, // 70003C80
	0x0F1281D0, // 70003C82
	0x0F12E52F, // 70003C84
	0x0F120000, // 70003C86
	0x0F1231A0, // 70003C88
	0x0F127000, // 70003C8A
	0x0F1229E4, // 70003C8C
	0x0F127000, // 70003C8E
	0x0F12C100, // 70003C90
	0x0F12D000, // 70003C92
	0x0F12A006, // 70003C94
	0x0F120000, // 70003C96
	0x0F12A000, // 70003C98
	0x0F12D000, // 70003C9A
	0x0F12064C, // 70003C9C
	0x0F127000, // 70003C9E
	0x0F123F48, // 70003CA0
	0x0F127000, // 70003CA2
	0x0F1207C4, // 70003CA4
	0x0F127000, // 70003CA6
	0x0F1207E8, // 70003CA8
	0x0F127000, // 70003CAA
	0x0F122B24, // 70003CAC
	0x0F127000, // 70003CAE
	0x0F121FA0, // 70003CB0
	0x0F127000, // 70003CB2
	0x0F121E3C, // 70003CB4
	0x0F127000, // 70003CB6
	0x0F1221A4, // 70003CB8
	0x0F127000, // 70003CBA
	0x0F12E200, // 70003CBC
	0x0F12D000, // 70003CBE
	0x0F124778, // 70003CC0
	0x0F1246C0, // 70003CC2
	0x0F12C000, // 70003CC4
	0x0F12E59F, // 70003CC6
	0x0F12FF1C, // 70003CC8
	0x0F12E12F, // 70003CCA
	0x0F121F63, // 70003CCC
	0x0F120001, // 70003CCE
	0x0F124778, // 70003CD0
	0x0F1246C0, // 70003CD2
	0x0F12C000, // 70003CD4
	0x0F12E59F, // 70003CD6
	0x0F12FF1C, // 70003CD8
	0x0F12E12F, // 70003CDA
	0x0F121EDF, // 70003CDC
	0x0F120001, // 70003CDE
	0x0F124778, // 70003CE0
	0x0F1246C0, // 70003CE2
	0x0F12C000, // 70003CE4
	0x0F12E59F, // 70003CE6
	0x0F12FF1C, // 70003CE8
	0x0F12E12F, // 70003CEA
	0x0F12495F, // 70003CEC
	0x0F120000, // 70003CEE
	0x0F124778, // 70003CF0
	0x0F1246C0, // 70003CF2
	0x0F12C000, // 70003CF4
	0x0F12E59F, // 70003CF6
	0x0F12FF1C, // 70003CF8
	0x0F12E12F, // 70003CFA
	0x0F12E403, // 70003CFC
	0x0F120000, // 70003CFE
	0x0F124778, // 70003D00
	0x0F1246C0, // 70003D02
	0x0F12C000, // 70003D04
	0x0F12E59F, // 70003D06
	0x0F12FF1C, // 70003D08
	0x0F12E12F, // 70003D0A
	0x0F1224B3, // 70003D0C
	0x0F120001, // 70003D0E
	0x0F124778, // 70003D10
	0x0F1246C0, // 70003D12
	0x0F12C000, // 70003D14
	0x0F12E59F, // 70003D16
	0x0F12FF1C, // 70003D18
	0x0F12E12F, // 70003D1A
	0x0F12EECD, // 70003D1C
	0x0F120000, // 70003D1E
	0x0F124778, // 70003D20
	0x0F1246C0, // 70003D22
	0x0F12C000, // 70003D24
	0x0F12E59F, // 70003D26
	0x0F12FF1C, // 70003D28
	0x0F12E12F, // 70003D2A
	0x0F12F049, // 70003D2C
	0x0F120000, // 70003D2E
	0x0F124778, // 70003D30
	0x0F1246C0, // 70003D32
	0x0F12C000, // 70003D34
	0x0F12E59F, // 70003D36
	0x0F12FF1C, // 70003D38
	0x0F12E12F, // 70003D3A
	0x0F1212DF, // 70003D3C
	0x0F120000, // 70003D3E
	0x0F124778, // 70003D40
	0x0F1246C0, // 70003D42
	0x0F12C000, // 70003D44
	0x0F12E59F, // 70003D46
	0x0F12FF1C, // 70003D48
	0x0F12E12F, // 70003D4A
	0x0F12F05B, // 70003D4C
	0x0F120000, // 70003D4E
	0x0F124778, // 70003D50
	0x0F1246C0, // 70003D52
	0x0F12C000, // 70003D54
	0x0F12E59F, // 70003D56
	0x0F12FF1C, // 70003D58
	0x0F12E12F, // 70003D5A
	0x0F12F07B, // 70003D5C
	0x0F120000, // 70003D5E
	0x0F124778, // 70003D60
	0x0F1246C0, // 70003D62
	0x0F12C000, // 70003D64
	0x0F12E59F, // 70003D66
	0x0F12FF1C, // 70003D68
	0x0F12E12F, // 70003D6A
	0x0F12FE6D, // 70003D6C
	0x0F120000, // 70003D6E
	0x0F124778, // 70003D70
	0x0F1246C0, // 70003D72
	0x0F12C000, // 70003D74
	0x0F12E59F, // 70003D76
	0x0F12FF1C, // 70003D78
	0x0F12E12F, // 70003D7A
	0x0F123295, // 70003D7C
	0x0F120000, // 70003D7E
	0x0F124778, // 70003D80
	0x0F1246C0, // 70003D82
	0x0F12C000, // 70003D84
	0x0F12E59F, // 70003D86
	0x0F12FF1C, // 70003D88
	0x0F12E12F, // 70003D8A
	0x0F12234F, // 70003D8C
	0x0F120000, // 70003D8E
	0x0F124778, // 70003D90
	0x0F1246C0, // 70003D92
	0x0F12C000, // 70003D94
	0x0F12E59F, // 70003D96
	0x0F12FF1C, // 70003D98
	0x0F12E12F, // 70003D9A
	0x0F124521, // 70003D9C
	0x0F120000, // 70003D9E
	0x0F124778, // 70003DA0
	0x0F1246C0, // 70003DA2
	0x0F12C000, // 70003DA4
	0x0F12E59F, // 70003DA6
	0x0F12FF1C, // 70003DA8
	0x0F12E12F, // 70003DAA
	0x0F127C0D, // 70003DAC
	0x0F120000, // 70003DAE
	0x0F124778, // 70003DB0
	0x0F1246C0, // 70003DB2
	0x0F12C000, // 70003DB4
	0x0F12E59F, // 70003DB6
	0x0F12FF1C, // 70003DB8
	0x0F12E12F, // 70003DBA
	0x0F127C2B, // 70003DBC
	0x0F120000, // 70003DBE
	0x0F124778, // 70003DC0
	0x0F1246C0, // 70003DC2
	0x0F12F004, // 70003DC4
	0x0F12E51F, // 70003DC6
	0x0F1224C4, // 70003DC8
	0x0F120001, // 70003DCA
	0x0F124778, // 70003DCC
	0x0F1246C0, // 70003DCE
	0x0F12C000, // 70003DD0
	0x0F12E59F, // 70003DD2
	0x0F12FF1C, // 70003DD4
	0x0F12E12F, // 70003DD6
	0x0F123183, // 70003DD8
	0x0F120000, // 70003DDA
	0x0F124778, // 70003DDC
	0x0F1246C0, // 70003DDE
	0x0F12C000, // 70003DE0
	0x0F12E59F, // 70003DE2
	0x0F12FF1C, // 70003DE4
	0x0F12E12F, // 70003DE6
	0x0F12302F, // 70003DE8
	0x0F120000, // 70003DEA
	0x0F124778, // 70003DEC
	0x0F1246C0, // 70003DEE
	0x0F12C000, // 70003DF0
	0x0F12E59F, // 70003DF2
	0x0F12FF1C, // 70003DF4
	0x0F12E12F, // 70003DF6
	0x0F12EF07, // 70003DF8
	0x0F120000, // 70003DFA
	0x0F124778, // 70003DFC
	0x0F1246C0, // 70003DFE
	0x0F12C000, // 70003E00
	0x0F12E59F, // 70003E02
	0x0F12FF1C, // 70003E04
	0x0F12E12F, // 70003E06
	0x0F1248FB, // 70003E08
	0x0F120000, // 70003E0A
	0x0F124778, // 70003E0C
	0x0F1246C0, // 70003E0E
	0x0F12C000, // 70003E10
	0x0F12E59F, // 70003E12
	0x0F12FF1C, // 70003E14
	0x0F12E12F, // 70003E16
	0x0F12F0B1, // 70003E18
	0x0F120000, // 70003E1A
	0x0F124778, // 70003E1C
	0x0F1246C0, // 70003E1E
	0x0F12C000, // 70003E20
	0x0F12E59F, // 70003E22
	0x0F12FF1C, // 70003E24
	0x0F12E12F, // 70003E26
	0x0F12EEDF, // 70003E28
	0x0F120000, // 70003E2A
	0x0F124778, // 70003E2C
	0x0F1246C0, // 70003E2E
	0x0F12C000, // 70003E30
	0x0F12E59F, // 70003E32
	0x0F12FF1C, // 70003E34
	0x0F12E12F, // 70003E36
	0x0F12AEF1, // 70003E38
	0x0F120000, // 70003E3A
	0x0F124778, // 70003E3C
	0x0F1246C0, // 70003E3E
	0x0F12C000, // 70003E40
	0x0F12E59F, // 70003E42
	0x0F12FF1C, // 70003E44
	0x0F12E12F, // 70003E46
	0x0F1202EB, // 70003E48
	0x0F120001, // 70003E4A
	0x0F124778, // 70003E4C
	0x0F1246C0, // 70003E4E
	0x0F12C000, // 70003E50
	0x0F12E59F, // 70003E52
	0x0F12FF1C, // 70003E54
	0x0F12E12F, // 70003E56
	0x0F12FD21, // 70003E58
	0x0F120000, // 70003E5A
	0x0F124778, // 70003E5C
	0x0F1246C0, // 70003E5E
	0x0F12C000, // 70003E60
	0x0F12E59F, // 70003E62
	0x0F12FF1C, // 70003E64
	0x0F12E12F, // 70003E66
	0x0F12FDAF, // 70003E68
	0x0F120000, // 70003E6A
	0x0F124778, // 70003E6C
	0x0F1246C0, // 70003E6E
	0x0F12C000, // 70003E70
	0x0F12E59F, // 70003E72
	0x0F12FF1C, // 70003E74
	0x0F12E12F, // 70003E76
	0x0F125027, // 70003E78
	0x0F120000, // 70003E7A
	0x0F124778, // 70003E7C
	0x0F1246C0, // 70003E7E
	0x0F12C000, // 70003E80
	0x0F12E59F, // 70003E82
	0x0F12FF1C, // 70003E84
	0x0F12E12F, // 70003E86
	0x0F1204C9, // 70003E88
	0x0F120000, // 70003E8A
	0x0F124778, // 70003E8C
	0x0F1246C0, // 70003E8E
	0x0F12C000, // 70003E90
	0x0F12E59F, // 70003E92
	0x0F12FF1C, // 70003E94
	0x0F12E12F, // 70003E96
	0x0F1239DF, // 70003E98
	0x0F120000, // 70003E9A
	0x0F124778, // 70003E9C
	0x0F1246C0, // 70003E9E
	0x0F12C000, // 70003EA0
	0x0F12E59F, // 70003EA2
	0x0F12FF1C, // 70003EA4
	0x0F12E12F, // 70003EA6
	0x0F126177, // 70003EA8
	0x0F120000, // 70003EAA
	0x0F124778, // 70003EAC
	0x0F1246C0, // 70003EAE
	0x0F12C000, // 70003EB0
	0x0F12E59F, // 70003EB2
	0x0F12FF1C, // 70003EB4
	0x0F12E12F, // 70003EB6
	0x0F12424F, // 70003EB8
	0x0F120000, // 70003EBA
	0x0F124778, // 70003EBC
	0x0F1246C0, // 70003EBE
	0x0F12C000, // 70003EC0
	0x0F12E59F, // 70003EC2
	0x0F12FF1C, // 70003EC4
	0x0F12E12F, // 70003EC6
	0x0F123F0D, // 70003EC8
	0x0F120000, // 70003ECA
	0x0F124778, // 70003ECC
	0x0F1246C0, // 70003ECE
	0x0F12C000, // 70003ED0
	0x0F12E59F, // 70003ED2
	0x0F12FF1C, // 70003ED4
	0x0F12E12F, // 70003ED6
	0x0F1202B9, // 70003ED8
	0x0F120001, // 70003EDA
	// End of Patch Data(Last : 70003EDAh)
	// Total Size 2480 (09B0)
	// Addr : 352C , Size : 2478(9AEh)

	//	TNP_USER_MBCV_CONTROL
	//	TNP_FLS_SEC_CONFIG
	//	TNP_SINGLE_FRAME_CAPTURE
	//	TNP_CAPTURE_DONE_INFO
	//	TNP_5CC_SENSOR_TUNE
	//	TNP_GAS_ALPHA_OTP
	//	TNP_FR_ACCURATE_DYNAMIC
	//	TNP_ADLC_TUNE

	0x10000001,

	0x0028D000,
	0x002A0070,
	0x0F120007, // clks_src_gf_force_enable


	//MBCV Control
	0x00287000,
	0x002A04B4,
	0x0F120064,

	// AFIT by Normalized Brightness Tuning parameter
	0x00287000,
	0x002A3302,
	0x0F120001, // on/off AFIT by NB option

	0x0F120005, //0005                 // NormBR[0]
	0x0F120066, //00C8                 // NormBR[1]
	0x0F1200C8, //00F4                 // NormBR[2]
	0x0F120320, //0320                 // NormBR[3]
	0x0F120375, //0375                 // NormBR[4]



	// Flash
	0x002A3F82,
	0x0F120000,	                  // TNP_Regs_PreflashStart
	0x0F120000,	                  // TNP_Regs_PreflashEnd
	0x0F120260,	                  // TNP_Regs_PreWP_r
	0x0F120240, // TNP_Regs_PreWP_b

	0x002A3F98,	                  // BR Tuning
	0x0F120100,	                  // TNP_Regs_BrRatioIn_0_
	0x0F120150,
	0x0F120200,
	0x0F120300,
	0x0F120400,

	0x0F120100,	                  // TNP_Regs_BrRatioOut_0_
	0x0F1200A0,
	0x0F120080,
	0x0F120040,
	0x0F120020,

	0x0F120030,	                  // WP Tuning
	0x0F120040,	                  // TNP_Regs_WPThresTbl_0_
	0x0F120048,
	0x0F120050,
	0x0F120060,

	0x0F120100,	                  // TNP_Regs_WPWeightTbl_0_
	0x0F1200C0,
	0x0F120080,
	0x0F12000A,
	0x0F120000,

	0x0F120120,	                  // T_BR tune
	0x0F120150,	                  // TNP_Regs_FlBRIn_0_
	0x0F120200,

	0x0F12003C,	                  //TNP_Regs_FlBRInOut_0_
	0x0F12003B,
	0x0F12002C,

	0x002A0430,	                  //REG_TC_FLS_Mode
	0x0F120002,
	0x002A3F80,	                  //TNP_Regs_FastFlashAlg
	0x0F120000,

	0x002A165E,
	0x0F120240, //0244 0258 AWB R point                            //0258 0245 0258
	0x0F120244, //024D 0220 AWB B point                            //0220 0245 0245


	//                           //                           //                           //           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           ///
	// Analog & APS settings                           //                           //           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           ///
	// This register is for FACTORY ONLY. If you change it without prior notification
	// YOU are RESPONSIBLE for the FAILURE that will happen in the future                                        //
	//                           //                           //                           //           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           //
	//                           //                           //                           //                           //                           ///

	//========================================================================================
	// 5CC EVT0 analog register setting
	// '10.07.14. Initial Draft
	// '10.07.24. sE404=0000 -> 1FC0 (Depedestal 0 -> -64d)
	// '10.08.16. sF410=0001 -> 0000 (for SHBN)
	// '10.08.25. sF438=0020 -> 0002 (VTGSL=2.96V) by APS
	//            sF43A=0020 -> 0001 (VRG=2.83V) by APS
	// '10.09.28. sF402=1F02 -> 3F02 ([13]: pixel bias powerdown according to HADR) for Darkshad
	//		    sF416=0000 -> 0001 (AAC_EN enable) for Darkshading
	//========================================================================================
	//============================= Analog & APS Control =====================================
	0x0028D000,
	0x002AF2AC,
	0x0F120100, // analog gain; 0200 x16 0100 x8 0080 x4 0040 x2 0020 x1
	0x002AF400,
	0x0F12001D, // ldb_en[4] ld_en[3] clp_en[2](N/A) smp_en[1] dshut_en[0]
	0x0F123F02, // cds_test[15:0]; refer to the ATOP_TEST_INFORMATION.

	0x002AF40A,
	0x0F120054, // adc_sat[7:0]=84d (500mV)
	0x0F120002, // ms[2:0]; 2h@Normal 2h@PLA 1h@CNT.AVG
	0x0F120008, // rmp_option[7:0]; [3]SL_Low_PWR_SAVE On
	0x0F120000, // msoff_en; No MS if gain gain is lower than x2
	0x0F1200A4, // rmp_init[7:0]

	0x002AF416,
	0x0F120001, // dbs_option[11:4] dbs_mode[3:2] dbs_bist_en[1] aac_en[0]

	0x002AF41E,
	0x0F120065, // comp2_bias[7:4] comp1_bias[3:0]

	0x002AF422,
	0x0F120005, // pix_bias[3:0]

	0x002AF426,
	0x0F1200D4, // clp_lvl[7:0]

	0x002AF42A,
	0x0F120001, // ref_option[7:0]; [4]OB_PIX monit en [3]Clamp monit en [2]Monit amp en [1]Clam

	0x002AF42E,
	0x0F120406, // fb_lv[11:10] pd_fblv[9] capa_ctrl_en[8] pd_inrush_ctrl[7] pd_reg_ntg[6] pd_re

	0x002AF434,
	0x0F120003, // dbr_clk_sel[1:0]; PLL_mode=3h ROSC_mode=0h
	0x0F120004, // reg_tune_pix[7:0]
	0x0F120002, // reg_tune_tgsl[7:0] (2.96V)
	0x0F120001, // reg_tune_rg[7:0] (2.83V)
	0x0F120004, // reg_tune_ntg[7:0]

	0x002AF446,
	0x0F120000, // blst_en_cintr[15:0]

	0x002AF466,
	0x0F120000, // srx_en[0]

	0x002A0054,
	0x0F120028, // pll_pd[10](0:enable 1:disable) div_clk_en[0](0:enable 1:disable)
	0x0F128888, // div_dbr[7:4]
	0x002AF132,
	0x0F124006,	         //ki 0413                   // tgr_frame_decription 4
	0x002AF142,
	0x0F120000,	         //ki 0413                   // tgr_frame_decription 4

	0x002AF152,
	0x0F120206, // tgr_frame_decription 7
	0x002AF1A2,
	0x0F120200, // tgr_frame_params_descriptor_3
	0x002AF1B2,
	0x0F120202, // tgr_frame_params_descriptor_6
	//==========================================================================================

	//============================= Line-ADLC Tuning ===========================================
	0x002AE412,
	0x0F120008, // adlc_tune_offset_gr[7:0]
	0x0F120008, // adlc_tune_offset_r[7:0]
	0x0F120010, // adlc_tune_offset_b[7:0]
	0x0F120010, // adlc_tune_offset_gb[7:0]
	0x002AE42E,
	0x0F120004, // adlc_qec[2:0]
	//==========================================================================================

	//===================================================================
	// AWB white locus setting - Have to be written after TnP
	//===================================================================
	0x00287000,
	0x002A1014,
	0x0F12012C,	         //0132                   //0138                  //awbb_IntcR
	0x0F12010B,	         //010A                   //011C                  //awbb_IntcB

	//===================================================================
	// AF
	//===================================================================
	//1. AF interface setting
	0x002A01A2,
	0x0F120003, //REG_TC_IPRM_CM_Init_AfModeType                          // VCM_I2C actuator
	0x0F120000, //REG_TC_IPRM_CM_Init_PwmConfig1                         // No PWM
	0x0F120000, //REG_TC_IPRM_CM_Init_PwmConfig2
	0x0F120041, //REG_TC_IPRM_CM_Init_GpioConfig1                          // Use GPIO_4 for ena
	0x0F120000, //REG_TC_IPRM_CM_Init_GpioConfig2
	0x0F122A0C, //REG_TC_IPRM_CM_Init_Mi2cBits                          // Use GPIO_5 for SCL GP
	0x0F120190, //REG_TC_IPRM_CM_Init_Mi2cRateKhz                          // MI2C Speed : 400KH

	//2. AF window setting
	0x002A022C,
	0x0F120100, //REG_TC_AF_FstWinStartX
	0x0F1200E3, //REG_TC_AF_FstWinStartY
	0x0F120200, //REG_TC_AF_FstWinSizeX
	0x0F120238, //REG_TC_AF_FstWinSizeY
	0x0F12018C, //REG_TC_AF_ScndWinStartX
	0x0F120166, //REG_TC_AF_ScndWinStartY
	0x0F1200E6, //REG_TC_AF_ScndWinSizeX
	0x0F120132, //REG_TC_AF_ScndWinSizeY
	0x0F120001, //REG_TC_AF_WinSizesUpdated

	//3. AF Fine Search Settings
	0x002A063A,
	0x0F1200C0, //#skl_af_StatOvlpExpFactor
	0x002A064A,
	0x0F120000, //0000                            //#skl_af_bAfStatOff
	0x002A1488,
	0x0F120000, //#af_search_usAeStable
	0x002A1494,
	0x0F121000, //#af_search_usSingleAfFlags 1000- fine search disable 1002- fine search on
	0x002A149E,
	0x0F120002, //#af_search_usFinePeakCount
	0x0F120000, //#af_search_usFineMaxScale
	0x002A142C,
	0x0F120601, //#af_pos_usFineStepNumSize
	0x002A14A2,
	0x0F120000, //#af_search_usCapturePolicy 0000 Shutter_Priority_Current

	//4.  AF Peak Threshold Setting
	0x002A1498,
	0x0F120001, //#af_search_usMinPeakSamples
	0x002A148A,
	0x0F1200F0, //#af_search_usPeakThr  for
	0x0F120090, //#af_search_usPeakThrLow

	//5.  AF Default Position
	0x002A1420,
	0x0F120000, //#af_pos_usHomePos
	0x0F124040, //#af_pos_usLowConfPos

	//6. AF statistics
	0x002A14B4,
	0x0F120280, //#af_search_usConfThr_4_  LowEdgeBoth GRAD
	0x002A14C0,
	0x0F1203A0, //#af_search_usConfThr_10_ LowLight HPF
	0x0F120320, //#af_search_usConfThr_11_
	0x002A14F4,
	0x0F120030, //#af_stat_usMinStatVal
	0x002A1514,
	0x0F120060, //#af_scene_usSceneLowNormBrThr
	// AF Scene Settings
	0x002A151E,
	0x0F120003, //#af_scene_usSaturatedScene



	//7. AF Lens Position Table Settings
	0x002A1434,
	0x0F120011, //#af_pos_usTableLastInd 10h_ 1h = 17 Steps

	0x0F120030, //#af_pos_usTable_0_  48
	0x0F120034, //#af_pos_usTable_1_  51
	0x0F120038, //#af_pos_usTable_2_  54
	0x0F12003C, //#af_pos_usTable_3_  57
	0x0F120040, /* #af_pos_usTable_4_ 61 */
	0x0F120044, //#af_pos_usTable_5_  65
	0x0F120048, //#af_pos_usTable_6_  69
	0x0F12004C, //#af_pos_usTable_7_  73
	0x0F120050, //#af_pos_usTable_8_  78
	0x0F120054, //#af_pos_usTable_9_  83
	0x0F120058, //#af_pos_usTable_10_ 89
	0x0F12005C, //#af_pos_usTable_11_ 89
	0x0F120060, //#af_pos_usTable_12_ 89
	0x0F120064, //#af_pos_usTable_13_ 89
	0x0F120068, //#af_pos_usTable_14_ 89
	0x0F12006C, //#af_pos_usTable_15_ 89
	0x0F120070, //#af_pos_usTable_16_ 89
	0x0F120074, //#af_pos_usTable_17_ 89


	//8. Continuous AF setting
	//8-1 Continuous AF timing
	0x002A152A,
	0x0F120040, //40 //30  //af_refocus_usFlFrames_ lens movement each 64frame
	0x002A154A,
	0x0F120010, //18 //0C  //af_scene_usResetNWaitFr (4 frame) lens movement each 64frame

	//8-2 Continuous AF sensitivity
	0x002A154C, //
	0x0F120000, //0010
	0x0F120000, //03FF
	0x0F120000, //0000


	0x002A1526, //Continuous AF sensitivity tuning
	0x0F128080, //
	0x0F12A0A0, //


	//8-3 Continuos AF, lens movement
	0x002A1424,
	0x0F126060, // af_pos_usMiddlePos  MSB_macro LSB_ normal lens moving direction lens ̵
	0x002A148E, // usPeakFrontThr
	0x0F120002,


	//9. VCM AF driver with PWM/I2C
	0x002A1558,
	0x0F128000, //#afd_usParam[0]  I2C power down command
	0x0F120006, //#afd_usParam[1]  Position Right Shift
	0x0F123FF0, //#afd_usParam[2]  I2C Data Mask
	0x0F1203E8, //#afd_usParam[3]  PWM Period
	0x0F120000, //#afd_usParam[4]  PWM Divider
	0x0F120200, //#afd_usParam[5]  SlowMotion Delay    reduce lens collision noise.
	0x0F120004, //#afd_usParam[6]  SlowMotion Threshold
	0x0F120100, //#afd_usParam[7]  Signal Shaping
	0x0F120040, //#afd_usParam[8]  Signal Shaping level
	0x0F120080, //#afd_usParam[9]  Signal Shaping level
	0x0F1200C0, //#afd_usParam[10] Signal Shaping level
	0x0F1200E0, //#afd_usParam[11] Signal Shaping level

	0x002A0224,
	0x0F120003, //REG_TC_AF_AfCmd                  //Initialize AF subsystem (AF driver AF algor

	//===================================================================
	// Flash setting
	//===================================================================
	0x002A018C,
	0x0F120001, //REG_TC_IPRM_AuxConfig                  // bit[0] : Flash is in use bit[1] : Me
	0x0F120003, //REG_TC_IPRM_AuxPolarity                  // bit[0] : Flash polarity (1 is acti
	0x0F120003, //REG_TC_IPRM_AuxGpios                  //1-4 : Flash GPIO number If GPIO number

	//===================================================================
	// 1-H timing setting
	//===================================================================
	0x002A1686,
	0x0F12005C, //senHal_uAddColsBin
	0x0F12005C, //senHal_uAddColsNoBin
	0x0F12085C, //senHal_uMinColsHorBin
	0x0F12085C, //senHal_uMinColsNoHorBin
	0x0F12025A, //senHal_uMinColsAddAnalogBin

	//===================================================================
	// Forbidden area setting
	//===================================================================
	0x002A1844,
	0x0F120000, //senHal_bSRX                  //SRX off

	0x002A1680,
	0x0F120002, //senHal_NExpLinesCheckFine                  //0004                  //extend Fo

	0x002A0ED2,
	0x0F120FA0,	                  //setot_uOnlineClocksDiv40

	//===================================================================
	// Preview subsampling mode
	//===================================================================
	0x002A18F8,
	0x0F120001, //senHal_bAACActiveWait2Start
	0x002A18F6,
	0x0F120001, //senHal_bAlwaysAAC
	0x002A182C,
	0x0F120001, //senHal_bSenAAC
	0x002A0EE4,
	0x0F120001, //setot_bUseDigitalHbin
	0x002A1674,
	0x0F120002, //senHal_SenBinFactor                  // 2:2x2 4:4x4
	0x0F120002, //senHal_SamplingType                  // 0:Full 1:digital 2:PLA 3:CA
	0x0F120000, //senHal_SamplingMode                  // 0:2x2	1:4x4

	//===================================================================
	// PLL setting for Max frequency (EVT0.1) 2010.08.05 - Do not remove
	//===================================================================
	0x002A19AE,
	0x0F12EA60, //pll_uMaxSysFreqKhz
	0x0F127530, //pll_uMaxPVIFreq4KH
	0x002A19C2,
	0x0F127530, //pll_uMaxMIPIFreq4KH
	0x002A0244,
	0x0F127530, //REG_0TC_PCFG_usMaxOut4KHzRate
	0x002A0336,
	0x0F127530, //REG_0TC_CCFG_usMaxOut4KHzRate

	//===================================================================
	// Init Parameters
	//===================================================================
	//MCLK
	0x002A0188,
	0x0F125DC0, //REG_TC_IPRM_InClockLSBs
	0x0F120000, //REG_TC_IPRM_InClockMSBs
	0x002A01B2,
	0x0F120001, //REG_TC_IPRM_UseNPviClocks
	0x0F120002, //REG_TC_IPRM_UseNMipiClocks
	0x002A01B8,
	0x0F120001, //REG_TC_IPRM_bBlockInternalPllCalc                  //1:pll bypass


	//SCLK & PCLK                    // clock set 0
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98	            4Mhz
	0x0F1254F8,	                  //57E4	                  //61A8	            4Mhz

	//SCLK & PCLK                    // clock set 1
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98	            4Mhz
	0x0F1254F8,	                  //57E4	                  //61A8	            4Mhz

	//SCLK & PCLK                    // clock set 2
	0x0F1238A4,	                  //38A4	                  //36B0
	0x0F1254F0,	                  //4E20	                  //3A98	            4Mhz
	0x0F1254F8,	                  //57E4	                  //61A8	            4Mhz

	0x002A1B78,
	0x0F1238A4, //  REGM_gSensorClocks_0__PLL_usClkFreqDiv4
	0x0F120074, //  REGM_gSensorClocks_0__PLL_PllHW_M
	0x0F120004, //  REGM_gSensorClocks_0__PLL_PllHW_P
	0x0F120000, //  REGM_gSensorClocks_0__PLL_PllHW_S
	0x0F120002, //  REGM_gSensorClocks_0__PLL_PllHW_VS
	0x0F120003, //  REGM_gSensorClocks_0__PLL_PllHW_VP
	0x0F120001, //  REGM_gSensorClocks_0__PLL_PllHW_SysDiv
	0x0F120001, //  REGM_gSensorClocks_0__PLL_PllHW_OS
	0x0F120001, //  REGM_gSensorClocks_0__PLL_PllHW_OP
	0x0F120001, //  REGM_gSensorClocks_0__PLL_PllHW_PviDiv
	0x0F120006, //  REGM_gSensorClocks_0__PLL_PllHW_DblDiv
	0x0F12000C, //  REGM_gSensorClocks_0__PLL_PllHW_OIF_dphy_val
	0x0F125DC0, //  REGM_gSensorClocks_0__InputClk
	0x0F120000,
	0x0F1254F6, //  REGM_gSensorClocks_0__usPviFreqDiv4
	0x0F12000C, //  REGM_gSensorClocks_0__usSysDiv
	0x0F120001, //  REGM_gSensorClocks_0__usOIFDenum

	0x002A1B9C,
	0x0F1238A4, //  REGM_gSensorClocks_1__PLL_usClkFreqDiv4
	0x0F120074, //  REGM_gSensorClocks_1__PLL_PllHW_M
	0x0F120004, //  REGM_gSensorClocks_1__PLL_PllHW_P
	0x0F120000, //  REGM_gSensorClocks_1__PLL_PllHW_S
	0x0F120002, //  REGM_gSensorClocks_1__PLL_PllHW_VS
	0x0F120003, //  REGM_gSensorClocks_1__PLL_PllHW_VP
	0x0F120001, //  REGM_gSensorClocks_1__PLL_PllHW_SysDiv
	0x0F120001, //  REGM_gSensorClocks_1__PLL_PllHW_OS
	0x0F120001, //  REGM_gSensorClocks_1__PLL_PllHW_OP
	0x0F120001, //  REGM_gSensorClocks_1__PLL_PllHW_PviDiv
	0x0F120006, //  REGM_gSensorClocks_1__PLL_PllHW_DblDiv
	0x0F12000C, //  REGM_gSensorClocks_1__PLL_PllHW_OIF_dphy_val
	0x0F125DC0, //  REGM_gSensorClocks_1__InputClk
	0x0F120000,
	0x0F1254F6, //  REGM_gSensorClocks_1__usPviFreqDiv4
	0x0F12000C, //  REGM_gSensorClocks_1__usSysDiv
	0x0F120001, //  REGM_gSensorClocks_1__usOIFDenum

	0x002A1BC0,
	0x0F1238A4, //  REGM_gSensorClocks_2__PLL_usClkFreqDiv4
	0x0F120074, //  REGM_gSensorClocks_2__PLL_PllHW_M
	0x0F120004, //  REGM_gSensorClocks_2__PLL_PllHW_P
	0x0F120000, //  REGM_gSensorClocks_2__PLL_PllHW_S
	0x0F120002, //  REGM_gSensorClocks_2__PLL_PllHW_VS
	0x0F120003, //  REGM_gSensorClocks_2__PLL_PllHW_VP
	0x0F120001, //  REGM_gSensorClocks_2__PLL_PllHW_SysDiv
	0x0F120001, //  REGM_gSensorClocks_2__PLL_PllHW_OS
	0x0F120001, //  REGM_gSensorClocks_2__PLL_PllHW_OP
	0x0F120001, //  REGM_gSensorClocks_2__PLL_PllHW_PviDiv
	0x0F120006, //  REGM_gSensorClocks_2__PLL_PllHW_DblDiv
	0x0F12000C, //  REGM_gSensorClocks_2__PLL_PllHW_OIF_dphy_val
	0x0F125DC0, //  REGM_gSensorClocks_2__InputClk
	0x0F120000,
	0x0F1254F6, //  REGM_gSensorClocks_2__usPviFreqDiv4
	0x0F12000C, //  REGM_gSensorClocks_2__usSysDiv
	0x0F120001, //  REGM_gSensorClocks_2__usOIFDenum


	0x002A01CC,
	0x0F120001, //REG_TC_IPRM_InitParamsUpdated

	0xFFFF000A,
	//===================================================================
	// Input Width & Height
	//===================================================================
	0x002A01F6,
	0x0F1205C0,	                  //0800                   //REG_TC_GP_PrevReqInputWidth
	0x0F12033C,	                  //0600                   //REG_TC_GP_PrevReqInputHeight
	0x0F120120,	                  //0000                   //REG_TC_GP_PrevInputWidthOfs
	0x0F120162,	                  //0000                   //REG_TC_GP_PrevInputHeightOfs
	0x0F120800, //REG_TC_GP_CapReqInputWidth	                  //Sensor Crop Width	2048
	0x0F120600, //REG_TC_GP_CapReqInputHeight	                  //Sensor Crop Height 1536
	0x0F120000, //REG_TC_GP_CapInputWidthOfs	                  //Sensor HOffset 0
	0x0F120000, //REG_TC_GP_CapInputHeightOfs	                  //Sensor VOffset 0

	0x002A1676,
	0x0F120002,	                           // 0:Full 1:digital 2:PLA 3:CA

	0x002A0216,
	0x0F120001,	                           //for input size change

	0x002A0216,
	0x0F120001, //REG_TC_GP_bUseReqInputInPre
	0x0F120001, //REG_TC_GP_bUseReqInputInCap

	0x002A043C,
	0x0F120800, //REG_TC_PZOOM_ZoomInputWidth
	0x0F120600, //REG_TC_PZOOM_ZoomInputHeight
	0x0F120000, //REG_TC_PZOOM_ZoomInputWidthOfs
	0x0F120000, //REG_TC_PZOOM_ZoomInputHeightOfs

	//===================================================================
	// Preview 0 1024x768 system 52M PCLK 54M
	//===================================================================
	0x002A023E,
	0x0F120500, //REG_0TC_PCFG_usWidth
	0x0F1202D0, //REG_0TC_PCFG_usHeight
	0x0F120005, //REG_0TC_PCFG_Format
	0x0F1254F6,	                  //7148	                  //REG_0TC_PCFG_usMaxOut4KH
	0x0F1254F6,	                  //7148	                  //REG_0TC_PCFG_usMinOut4KH

	0x002A024C,
	0x0F120012, //REG_0TC_PCFG_PVIMask    => cmk 2010.10.29 s0042 => s0052 Invert Y C order
	0x0F120010, //REG_0TC_PCFG_OIFMask

	0x002A0254,
	0x0F120001, //REG_0TC_PCFG_uClockInd
	0x0F120000, //REG_0TC_PCFG_usFrTimeType
	0x0F120002, //REG_0TC_PCFG_FrRateQualityType
	0x0F1201B8, //1A0                   //REG_0TC_PCFG_usMaxFrTimeMsecMult10                  //
	0x0F12014D, //REG_0TC_PCFG_usMinFrTimeMsecMult10                  //min frame time : 30fps 0

	0x0F120000, //REG_0TC_PCFG_bSmearOutput
	0x0F120000, //REG_0TC_PCFG_sSaturation
	0x0F120000, //REG_0TC_PCFG_sSharpBlur
	0x0F120000, //REG_0TC_PCFG_sColorTemp
	0x0F120000, //REG_0TC_PCFG_uDeviceGammaIndex
#if 1 /* [P4W] fix rotation to 180*/
	0x0F120003, //REG_0TC_PCFG_uPrevMirror
	0x0F120003, //REG_0TC_PCFG_uCaptureMirror
#endif
	0x0F120000, //REG_0TC_PCFG_uRotation


	//===================================================================
	// Capture 0 2048x1536 system 52M PCLK 54M
	//===================================================================
	0x002A032E,
	0x0F120000, //REG_0TC_CCFG_uCaptureMode

	0x0F120800, //REG_0TC_CCFG_usWidth
	0x0F120600, //REG_0TC_CCFG_usHeight
	0x0F120005, //REG_0TC_CCFG_Format                              //PCAM 5:YUV   9:JPEG
	0x0F1254F6,	                  //REG_0TC_CCFG_usMaxOut4KHzRate
	0x0F1254F6,	                  //REG_0TC_CCFG_usMinOut4KHzRate

	0x002A033E,
	0x0F120010, //REG_0TC_CCFG_PVIMask        => cmk 2010.10.29 s0042 => s0052 Invert Y C order
	0x0F120010, //REG_0TC_CCFG_OIFMask
	0x0F1203C0, //REG_0TC_CCFG_usJpegPacketSize

	0x002A0346,
	0x0F120001, //REG_0TC_CCFG_uClockInd
	0x0F120002, //REG_0TC_CCFG_usFrTimeType
	0x0F120002, //REG_0TC_CCFG_FrRateQualityType
	0x0F120535, //REG_0TC_CCFG_usMaxFrTimeMsecMult10
	0x0F12029A, //REG_0TC_CCFG_usMinFrTimeMsecMult10
	0x0F120000, //REG_0TC_CCFG_bSmearOutput
	0x0F120000, //REG_0TC_CCFG_sSaturation
	0x0F120000, //REG_0TC_CCFG_sSharpBlur
	0x0F120000, //REG_0TC_CCFG_sColorTemp
	0x0F120000, //REG_0TC_CCFG_uDeviceGammaIndex

	0x002A0426,
	0x0F120055, //REG_TC_BRC_usCaptureQuality


	0x002A1E5C, //Mon_LT_uDefMinFrExpDelta
	0x0F120000,




	/* PREVIEW */
	/* 0x002A0208, */
	/* 0x0F120000, */ /* REG_TC_GP_ActivePrevConfig */
	/* 0x002A0210, */
	/* 0x0F120000, */ /* REG_TC_GP_ActiveCapConfig */
	/* 0x002A020C, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevOpenAfterChange */
	/* 0x002A01F4, */
	/* 0x0F120001, */ /* REG_TC_GP_NewConfigSync */
	/* 0x002A020A, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevConfigChanged */
	/* 0x002A0212 ,*/
	/* 0x0F120001, */ /* REG_TC_GP_CapConfigChanged */
	/* 0x002A01E8, */
	/* 0x0F120000, */ /* REG_TC_GP_EnableCapture */
	/* 0x0F120001, */ /* REG_TC_GP_EnableCaptureChanged */

	/* 0xFFFF0064, */ /* Delay 100ms */

	//===================================================================
	// AFC
	//===================================================================
	//Auto
	0x002A0F08,
	0x0F120001, //AFC_Default60Hz   01:60hz 00:50Hz
	0x002A04A4,
	0x0F12067F, //REG_TC_DBG_AutoAlgEnBits 065f : Manual AFC on   067f : Manual AFC off


	//===================================================================
	// Shading (AF module)
	//===================================================================
	// TVAR_ash_pGAS_high
	0x002A0D22,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F12000F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,

	// TVAR_ash_pGAS_low
	0x0F126E49,
	0x0F12FB98,
	0x0F12F348,
	0x0F121BD6,
	0x0F12EBEF,
	0x0F1203D3,
	0x0F12EC8D,
	0x0F12F239,
	0x0F120E64,
	0x0F12F7EA,
	0x0F12FD3B,
	0x0F120A7C,
	0x0F12FC9C,
	0x0F120BD3,
	0x0F12F2E5,
	0x0F120619,
	0x0F120772,
	0x0F12F0B0,
	0x0F12184E,
	0x0F12F95F,
	0x0F120B1A,
	0x0F12FC45,
	0x0F12F716,
	0x0F120DCD,
	0x0F12EF24,
	0x0F120221,
	0x0F12F6BD,
	0x0F1204CB,
	0x0F1200B1,
	0x0F12FEB0,
	0x0F120268,
	0x0F1202C7,
	0x0F12010A,
	0x0F12FF93,
	0x0F12036D,
	0x0F12F859,
	0x0F1281D0,
	0x0F12FA32,
	0x0F12EFDB,
	0x0F12234D,
	0x0F12E799,
	0x0F120337,
	0x0F12EB05,
	0x0F12E8F9,
	0x0F12152E,
	0x0F12F0D5,
	0x0F120842,
	0x0F12043A,
	0x0F12F461,
	0x0F120E58,
	0x0F12F658,
	0x0F12075D,
	0x0F12F78D,
	0x0F12FDE9,
	0x0F12277A,
	0x0F12FFDE,
	0x0F12FD3B,
	0x0F12FE50,
	0x0F120AD1,
	0x0F12FE2C,
	0x0F12E90D,
	0x0F12F7B0,
	0x0F1205DB,
	0x0F1202CD,
	0x0F12F4F1,
	0x0F1202A8,
	0x0F12FDDC,
	0x0F120B59,
	0x0F12F74E,
	0x0F1203D5,
	0x0F12FF4F,
	0x0F1200F7,
	0x0F126A44,
	0x0F12FAD6,
	0x0F12F261,
	0x0F121F28,
	0x0F12E691,
	0x0F1207D2,
	0x0F12EE85,
	0x0F12F426,
	0x0F120F26,
	0x0F12F34B,
	0x0F120036,
	0x0F120C0F,
	0x0F12FDA9,
	0x0F1209EA,
	0x0F12F27A,
	0x0F120CD5,
	0x0F1201E1,
	0x0F12ED41,
	0x0F121DB5,
	0x0F12FD26,
	0x0F1203F7,
	0x0F12F7BB,
	0x0F12FE81,
	0x0F1212D3,
	0x0F12E061,
	0x0F12F81C,
	0x0F1207B1,
	0x0F120408,
	0x0F12F860,
	0x0F12FC9A,
	0x0F120DDE,
	0x0F120C9C,
	0x0F12F2A4,
	0x0F1202EB,
	0x0F12099B,
	0x0F12F5A6,
	0x0F127243,
	0x0F12F74D,
	0x0F12F74B,
	0x0F121800,
	0x0F12EF22,
	0x0F120263,
	0x0F12EBE7,
	0x0F12F5A4,
	0x0F1209D3,
	0x0F12FAB8,
	0x0F12FDFF,
	0x0F12086B,
	0x0F120338,
	0x0F120514,
	0x0F12F840,
	0x0F120768,
	0x0F12FE55,
	0x0F12F884,
	0x0F121488,
	0x0F12FFCD,
	0x0F12035B,
	0x0F12FA4E,
	0x0F1201DB,
	0x0F1206D6,
	0x0F12EE19,
	0x0F12FEA3,
	0x0F12FE8C,
	0x0F1203A3,
	0x0F12FDDB,
	0x0F12FD9B,
	0x0F12035E,
	0x0F1203F2,
	0x0F12FCBD,
	0x0F120300,
	0x0F12FF2E,
	0x0F12FE03,

	0x002A04A8,
	0x0F120001, //REG_TC_DBG_ReInitCmd

	//===================================================================
	// Shading - Alpha
	//===================================================================
	0x002A07E8,
	0x0F1200BC, //TVAR_ash_AwbAshCord_0_                  //HOR
	0x0F1200ED, //TVAR_ash_AwbAshCord_1_                  //INCA
	0x0F120101, //TVAR_ash_AwbAshCord_2_                  //WW
	0x0F12012D, //TVAR_ash_AwbAshCord_3_                  //CW
	0x0F120166, //TVAR_ash_AwbAshCord_4_                  //D50
	0x0F120184, //TVAR_ash_AwbAshCord_5_                  //D65
	0x0F1201A0, //TVAR_ash_AwbAshCord_6_                  //D75
	0x002A07FE,
	0x0F123200, //TVAR_ash_GASAlpha_0__0_
	0x0F124000, //TVAR_ash_GASAlpha_0__1_
	0x0F124000, //TVAR_ash_GASAlpha_0__2_
	0x0F123C00, //TVAR_ash_GASAlpha_0__3_
	0x0F123200, //TVAR_ash_GASAlpha_1__0_
	0x0F124000, //TVAR_ash_GASAlpha_1__1_
	0x0F124000, //TVAR_ash_GASAlpha_1__2_
	0x0F123C00, //TVAR_ash_GASAlpha_1__3_
	0x0F123200, //TVAR_ash_GASAlpha_2__0_
	0x0F124000, //TVAR_ash_GASAlpha_2__1_
	0x0F124000, //TVAR_ash_GASAlpha_2__2_
	0x0F123C00, //TVAR_ash_GASAlpha_2__3_
	0x0F123200, //TVAR_ash_GASAlpha_3__0_
	0x0F124000, //TVAR_ash_GASAlpha_3__1_
	0x0F124000, //TVAR_ash_GASAlpha_3__2_
	0x0F123C00, //TVAR_ash_GASAlpha_3__3_
	0x0F123200, //TVAR_ash_GASAlpha_4__0_
	0x0F124000, //TVAR_ash_GASAlpha_4__1_
	0x0F124000, //TVAR_ash_GASAlpha_4__2_
	0x0F123C00, //TVAR_ash_GASAlpha_4__3_
	0x0F123200, //TVAR_ash_GASAlpha_5__0_
	0x0F124000, //TVAR_ash_GASAlpha_5__1_
	0x0F124000, //TVAR_ash_GASAlpha_5__2_
	0x0F123C00, //TVAR_ash_GASAlpha_5__3_
	0x0F124000, //TVAR_ash_GASAlpha_6__0_
	0x0F124000, //TVAR_ash_GASAlpha_6__1_
	0x0F124000, //TVAR_ash_GASAlpha_6__2_
	0x0F123C00, //TVAR_ash_GASAlpha_6__3_

	0x002A0836,
	0x0F123E00, //TVAR_ash_GASOutdoorAlpha_0_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_1_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_2_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_3_

	//===================================================================
	// Gamma
	//===================================================================
	//	param_start	SARR_usGammaLutRGBIndoor
	0x002A0660,
	0x0F120000,
	0x0F120023,
	0x0F120044,
	0x0F12007B,
	0x0F1200BB,
	0x0F120102,
	0x0F12012F,
	0x0F120143,
	0x0F120155,
	0x0F120172,
	0x0F12018C,
	0x0F1201A4,
	0x0F1201BC,
	0x0F1201EC,
	0x0F12021D,
	0x0F12027E,
	0x0F1202DF,
	0x0F12033F,
	0x0F12039F,
	0x0F1203FF,
	0x0F120000,
	0x0F120023,
	0x0F120044,
	0x0F12007B,
	0x0F1200BB,
	0x0F120102,
	0x0F12012F,
	0x0F120143,
	0x0F120155,
	0x0F120172,
	0x0F12018C,
	0x0F1201A4,
	0x0F1201BC,
	0x0F1201EC,
	0x0F12021D,
	0x0F12027E,
	0x0F1202DF,
	0x0F12033F,
	0x0F12039F,
	0x0F1203FF,
	0x0F120000,
	0x0F120023,
	0x0F120044,
	0x0F12007B,
	0x0F1200BB,
	0x0F120102,
	0x0F12012F,
	0x0F120143,
	0x0F120155,
	0x0F120172,
	0x0F12018C,
	0x0F1201A4,
	0x0F1201BC,
	0x0F1201EC,
	0x0F12021D,
	0x0F12027E,
	0x0F1202DF,
	0x0F12033F,
	0x0F12039F,
	0x0F1203FF,

	//s002A06D8
	0x0F120001, //saRR_usDualGammaLutRGBOutdoor[0][0]
	0x0F120011, //saRR_usDualGammaLutRGBOutdoor[0][1]
	0x0F120028, //saRR_usDualGammaLutRGBOutdoor[0][2]
	0x0F120059, //saRR_usDualGammaLutRGBOutdoor[0][3]
	0x0F12009D, //saRR_usDualGammaLutRGBOutdoor[0][4]
	0x0F1200F2, //saRR_usDualGammaLutRGBOutdoor[0][5]
	0x0F120128, //saRR_usDualGammaLutRGBOutdoor[0][6]
	0x0F12013D, //saRR_usDualGammaLutRGBOutdoor[0][7]
	0x0F12014E, //saRR_usDualGammaLutRGBOutdoor[0][8]
	0x0F120168, //saRR_usDualGammaLutRGBOutdoor[0][9]
	0x0F12017C, //saRR_usDualGammaLutRGBOutdoor[0][10]
	0x0F120190, //saRR_usDualGammaLutRGBOutdoor[0][11]
	0x0F1201A4, //saRR_usDualGammaLutRGBOutdoor[0][12]
	0x0F1201CC, //saRR_usDualGammaLutRGBOutdoor[0][13]
	0x0F1201F4, //saRR_usDualGammaLutRGBOutdoor[0][14]
	0x0F120243, //saRR_usDualGammaLutRGBOutdoor[0][15]
	0x0F120293, //saRR_usDualGammaLutRGBOutdoor[0][16]
	0x0F1202E9, //saRR_usDualGammaLutRGBOutdoor[0][17]
	0x0F120338, //saRR_usDualGammaLutRGBOutdoor[0][18]
	0x0F12038E, //saRR_usDualGammaLutRGBOutdoor[0][19]
	0x0F120001, //saRR_usDualGammaLutRGBOutdoor[1][0]
	0x0F120011, //saRR_usDualGammaLutRGBOutdoor[1][1]
	0x0F120028, //saRR_usDualGammaLutRGBOutdoor[1][2]
	0x0F120059, //saRR_usDualGammaLutRGBOutdoor[1][3]
	0x0F12009D, //saRR_usDualGammaLutRGBOutdoor[1][4]
	0x0F1200F2, //saRR_usDualGammaLutRGBOutdoor[1][5]
	0x0F120128, //saRR_usDualGammaLutRGBOutdoor[1][6]
	0x0F12013D, //saRR_usDualGammaLutRGBOutdoor[1][7]
	0x0F12014E, //saRR_usDualGammaLutRGBOutdoor[1][8]
	0x0F120168, //saRR_usDualGammaLutRGBOutdoor[1][9]
	0x0F12017C, //saRR_usDualGammaLutRGBOutdoor[1][10]
	0x0F120190, //saRR_usDualGammaLutRGBOutdoor[1][11]
	0x0F1201A4, //saRR_usDualGammaLutRGBOutdoor[1][12]
	0x0F1201CC, //saRR_usDualGammaLutRGBOutdoor[1][13]
	0x0F1201F4, //saRR_usDualGammaLutRGBOutdoor[1][14]
	0x0F120243, //saRR_usDualGammaLutRGBOutdoor[1][15]
	0x0F120293, //saRR_usDualGammaLutRGBOutdoor[1][16]
	0x0F1202E9, //saRR_usDualGammaLutRGBOutdoor[1][17]
	0x0F120338, //saRR_usDualGammaLutRGBOutdoor[1][18]
	0x0F12038E, //saRR_usDualGammaLutRGBOutdoor[1][19]
	0x0F120001, //saRR_usDualGammaLutRGBOutdoor[2][0]
	0x0F120011, //saRR_usDualGammaLutRGBOutdoor[2][1]
	0x0F120028, //saRR_usDualGammaLutRGBOutdoor[2][2]
	0x0F120059, //saRR_usDualGammaLutRGBOutdoor[2][3]
	0x0F12009D, //saRR_usDualGammaLutRGBOutdoor[2][4]
	0x0F1200F2, //saRR_usDualGammaLutRGBOutdoor[2][5]
	0x0F120128, //saRR_usDualGammaLutRGBOutdoor[2][6]
	0x0F12013D, //saRR_usDualGammaLutRGBOutdoor[2][7]
	0x0F12014E, //saRR_usDualGammaLutRGBOutdoor[2][8]
	0x0F120168, //saRR_usDualGammaLutRGBOutdoor[2][9]
	0x0F12017C, //saRR_usDualGammaLutRGBOutdoor[2][10]
	0x0F120190, //saRR_usDualGammaLutRGBOutdoor[2][11]
	0x0F1201A4, //saRR_usDualGammaLutRGBOutdoor[2][12]
	0x0F1201CC, //saRR_usDualGammaLutRGBOutdoor[2][13]
	0x0F1201F4, //saRR_usDualGammaLutRGBOutdoor[2][14]
	0x0F120243, //saRR_usDualGammaLutRGBOutdoor[2][15]
	0x0F120293, //saRR_usDualGammaLutRGBOutdoor[2][16]
	0x0F1202E9, //saRR_usDualGammaLutRGBOutdoor[2][17]
	0x0F120338, //saRR_usDualGammaLutRGBOutdoor[2][18]
	0x0F12038E, //saRR_usDualGammaLutRGBOutdoor[2][19]

	//===================================================================
	// AE - shutter
	//===================================================================
	//****************************************/
	// AE 2009 03 08 - based on TN
	//****************************************/

	//add ki 11.02.18
	// SLOW AE
	// SLOW AE
	0x002A13F2,
	0x0F120014,	                  // 0010 ae_GainIn_0_			                  //
	0x0F120032,	                  // 0020	ae_GainIn_1_
	0x0F120078,	                  // 0040	ae_GainIn_2_
	0x0F1200AA,	                  // 0080	ae_GainIn_3_
	0x0F120100,	                  // fix 0100	ae_GainIn_4_
	0x0F120140,	                  // 0200	ae_GainIn_5_
	0x0F1201B8,	                  // 0400	ae_GainIn_6_
	0x0F120400,	                  // 0800	ae_GainIn_7_
	0x0F122000,	                  // 2000	ae_GainIn_8_

	0x0F120046,	                  //0050	                  // 0010	ae_GainOut_0
	0x0F120078,	                  //0070	                  // 0020	ae_GainOut_1
	0x0F1200BE,	                  //00A0	                  // 0040	ae_GainOut_2
	0x0F1200DC,	                  //00D0	                  // 0080	ae_GainOut_3
	0x0F120100,	                  // fix 0100	ae_GainOut_4_		                  //
	0x0F12010E,	                  // 0200	ae_GainOut_5_		                  //
	0x0F120140,	                  // 0400	ae_GainOut_6_		                  //
	0x0F1201F4,	                  // 0800	ae_GainOut_7_		                  //
	0x0F120200,	                  // 2000	ae_GainOut_8_		                  //


	0x002A13BC,
	0x0F120100,										//00
	0x0F120100,			//000C		ae_ContrastS_1_//
	0x0F120100,			//001C		ae_ContrastS_2_//
	0x0F120100,			//0020		ae_ContrastS_3_//
	0x0F120100,			//0020		ae_ContrastS_4_//
	0x0F120100,			//0020		ae_ContrastS_5_//
	0x0F120100,			//0020		ae_ContrastS_6_//
	0x0F120100,			//0020		ae_ContrastS_7_//

	//============================================================
	// Frame rate setting
	//============================================================
	// How to set
	// 1. Exposure value
	// dec2hex((1 / (frame rate you want(ms))) * 100d * 5d)
	//
	//
	// 2. Analog Digital gain
	// dec2hex((Analog gain you want) * 256d)
	//              Ex1) Simple Caculation for x3.25?:   3.25x256 = 832[dec] = 0340[hex]
	//============================================================
	//MBR


	0x002A01DE,
	0x0F120000, //REG_TC_bUseMBR                  //MBR off
	//MBR off is needed to prevent a shorter integration time when the scene has blurring in Nig

	//AE_Target
	0x002A1308,
	0x0F12003E, //TVAR_ae_BrAve
	0x002A130E,
	0x0F12000F, //ae_StatMode
	//ae_StatMode bit[3] BLC has to be bypassed to prevent AE weight change especially backlight

	//AE_state
	0x002A04EE,
	0x0F120105, //010E                   //#lt_uLimitHigh
	0x0F1200FA, //00F5                   //#lt_uLimitLow

	0x002A0500,
	0x0F120001,	         //lt_uInitPostToleranceCnt

	//For 60Hz
	0x002A0504,
	0x0F123415, //3415                   //#lt_uMaxExp1
	0x002A0508,
	0x0F123415, //26e8          //681F                   //#lt_uMaxExp2
	0x002A050C,
	0x0F123415, //26e8          //8227                   //#lt_uMaxExp3
	0x002A0510,
	0x0F12C350, //#lt_uMaxExp4

	0x002A0514,
	0x0F123415, //#lt_uCapMaxExp1
	0x002A0518,
	0x0F123415, //681F                   //#lt_uCapMaxExp2
	0x002A051C,
	0x0F123415, //8227                   //#lt_uCapMaxExp3
	0x002A0520,
	0x0F12C350, //#lt_uCapMaxExp4

	0x002A0524,
	0x0F120200, //1E0                   //#lt_uMaxAnGain1
	0x0F120240, //1E0                   //#lt_uMaxAnGain2
	0x0F120340, //0300                   //#lt_uMaxAnGain3
	0x0F120A00, //#lt_uMaxAnGain4

	0x0F120100, //#lt_uMaxDigGain
	0x0F128000, //#lt_uMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	0x0F120200, //#lt_uCapMaxAnGain1
	0x0F120240, //#lt_uCapMaxAnGain2
	0x0F120340, //300                   //#lt_uCapMaxAnGain3
	0x0F120A00, //#lt_uCapMaxAnGain4

	0x0F120100, //#lt_uCapMaxDigGain
	0x0F128000, //#lt_uCapMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

	//===================================================================
	//AE - Weights
	//===================================================================
	0x002A1316,
	0x0F120101, //ae_WeightTbl_16[0]   0000
	0x0F120101, //ae_WeightTbl_16[1]   0000
	0x0F120101, //ae_WeightTbl_16[2]   0000
	0x0F120101, //ae_WeightTbl_16[3]   0000
	0x0F120101, //ae_WeightTbl_16[4]   0101
	0x0F120101, //ae_WeightTbl_16[5]   0101
	0x0F120101, //ae_WeightTbl_16[6]   0101
	0x0F120101, //ae_WeightTbl_16[7]   0101
	0x0F120101, //ae_WeightTbl_16[8]   0101
	0x0F120202, //ae_WeightTbl_16[9]   0201
	0x0F120202, //ae_WeightTbl_16[10]  0102
	0x0F120101, //ae_WeightTbl_16[11]  0101
	0x0F120101, //ae_WeightTbl_16[12]  0101
	0x0F120202, //ae_WeightTbl_16[13]  0202
	0x0F120202, //ae_WeightTbl_16[14]  0202
	0x0F120101, //ae_WeightTbl_16[15]  0101
	0x0F120101, //ae_WeightTbl_16[16]  0101
	0x0F120202, //ae_WeightTbl_16[17]  0202
	0x0F120202, //ae_WeightTbl_16[18]  0202
	0x0F120101, //ae_WeightTbl_16[19]  0101
	0x0F120101, //ae_WeightTbl_16[20]  0201
	0x0F120202, //ae_WeightTbl_16[21]  0202
	0x0F120202, //ae_WeightTbl_16[22]  0202
	0x0F120101, //ae_WeightTbl_16[23]  0102
	0x0F120101, //ae_WeightTbl_16[24]  0201
	0x0F120101, //ae_WeightTbl_16[25]  0202
	0x0F120101, //ae_WeightTbl_16[26]  0202
	0x0F120101, //ae_WeightTbl_16[27]  0102
	0x0F120101, //ae_WeightTbl_16[28]  0101
	0x0F120101, //ae_WeightTbl_16[29]  0101
	0x0F120101, //ae_WeightTbl_16[30]  0101
	0x0F120101, //ae_WeightTbl_16[31]  0101

	//===================================================================
	//AWB-BASIC setting
	//===================================================================
	0x002A1018,
	0x0F1202A7, //awbb_GLocusR
	0x0F120343, //awbb_GLocusB
	0x002A0FFC,
	0x0F12036C, //awbb_CrclLowT_R_c
	0x002A1000,
	0x0F12011D, //awbb_CrclLowT_B_c
	0x002A1004,
	0x0F1262C1, //awbb_CrclLowT_Rad_c
	0x002A1034,
	0x0F12074D,	         //05F0                   //awbb_GamutWidthThr1
	0x0F120433,	         //01F4                   //awbb_GamutHeightThr1
	0x0F12002A,	         //006C                   //awbb_GamutWidthThr2
	0x0F12000C,	         //0038                   //awbb_GamutHeightThr2
	0x002A1020,
	0x0F120020,	         //000C                   //awbb_MinNumOfFinalPatches
	0x0F12001E, //awbb_MinNumOfLowBrFinalPatches
	0x0F120046, //awbb_MinNumOfLowBr0_FinalPatches
	0x002A1028,
	0x0F120020,	         //awbb_MinNumOfOutdoorPatches

	0x002A291A,
	0x0F120004, // #Mon_AWB_ByPassMode                            // [0]Outdoor [1]LowBr [2]LowT

	0x002A1048,
	0x0F1200C8,	         //awbb_LowBr
	0x0F12001E,	         //awbb_LowBr_NBzone

	0x002A1008,
	0x0F120020,	         //awbb_NormalYThresh_y_low
	0x0F1200A0,	         //awbb_NormalYThresh_y_high
	0x0F120002, //awbb_LowBrYThresh_y_low
	0x0F1200A0, //awbb_LowBrYThresh_y_high



	0x002A102E,
	0x0F12054D,					         //awbb_MvEq_RBthresh

	0x002A1032,
	0x0F120000, //awbb_MovingScale10

	0x002A11C2,
	0x0F120000, //awbb_RGainOff
	0x0F120000, //awbb_BGainOff
	0x0F120000, //awbb_GGainOff
	0x0F1200C2, //awbb_Alpha_Comp_Mode
	0x0F120002, //awbb_Rpl_InvalidOutDoor
	0x0F120001, //awbb_UseGrThrCorr
	0x0F1200E4, //awbb_Use_Filters
	0x0F12053C, //awbb_GainsInit[0]
	0x0F120400, //awbb_GainsInit[1]
	0x0F12055C, //awbb_GainsInit[2]

	//===================================================================
	//AWB-Zone
	//===================================================================
	//	param_start	awbb_IndoorGrZones_m_BGrid
	0x002A0F28,
	0x0F120426,	         //03C0                   //03C0                  //03C0
	0x0F12047E,	         //03E2                   //03E2                  //03E2
	0x0F1203C6,	         //0356                   //0356                  //0356
	0x0F120496,	         //03FC                   //03FC                  //03FC
	0x0F120374,	         //031E                   //031E                  //031E
	0x0F1204A0,	         //03FE                   //03FE                  //03FE
	0x0F12033A,	         //02F0                   //02F0                  //02F0
	0x0F120498,	         //03F0                   //03F0                  //03F0
	0x0F120312,	         //02CA                   //02CA                  //02CA
	0x0F120478,	         //03CC                   //03CC                  //03CC
	0x0F1202EA,	         //02A8                   //02A8                  //02A8
	0x0F120440,	         //037A                   //037A                  //037A
	0x0F1202C2,	         //0280                   //0288                  //0288
	0x0F1203FA,	         //033C                   //033C                  //033C
	0x0F12029A,	         //0260                   //0266                  //0266
	0x0F1203BE,	         //030A                   //030A                  //031E
	0x0F120272,	         //0242                   //0246                  //0246
	0x0F120398,	         //02DC                   //02EC                  //0300
	0x0F12024E,	         //0228                   //0228                  //0228
	0x0F120372,	         //02B2                   //02CE                  //02E8
	0x0F12022A,	         //020E                   //020E                  //020E
	0x0F120340,	         //0290                   //02B0                  //02CA
	0x0F120206,	         //01F8                   //01F8                  //01F8
	0x0F120310,	         //0276                   //0292                  //02B0
	0x0F1201E2,	         //01E8                   //01E8                  //01E8
	0x0F1202DE,	         //0268                   //0276                  //0296
	0x0F1201C0,	         //01DC                   //01DC                  //01DC
	0x0F1202AE,	         //0256                   //0256                  //027A
	0x0F1201B4,	         //01E0                   //01E0                  //01E0
	0x0F12027E,	         //0238                   //0238                  //0252
	0x0F1201C0,	         //01EC                   //01EC                  //01F2
	0x0F12024C,	         //020E                   //020E                  //0226
	0x0F1201FA,	         //0000                   //0000                  //0000
	0x0F12021C,	         //0000                   //0000                  //0000
	0x0F120000,	         //0000                   //0000                  //0000
	0x0F120000,	         //0000                   //0000                  //0000
	0x0F120000,	         //0000                   //0000                  //0000
	0x0F120000,	         //0000                   //0000                  //0000
	0x0F120000,	         //0000                   //0000                  //0000
	0x0F120000,	         //0000                   //0000                  //0000
	//	param_end	awbb_IndoorGrZones_m_BGrid

	0x0F120005, //awbb_IndoorGrZones_m_Grid
	0x002A0F80,
	0x0F1200A6, //awbb_IndoorGrZones_m_Boff
	0x002A0F7C,
	0x0F120011,

	//	param_start	awbb_OutdoorGrZones_m_BGrid
	0x002A0F84,
	0x0F12023E, //awbb_OutdoorGrZones_m_BGrid[0]
	0x0F120286, //awbb_OutdoorGrZones_m_BGrid[1]
	0x0F12022C, //awbb_OutdoorGrZones_m_BGrid[2]
	0x0F1202CC, //awbb_OutdoorGrZones_m_BGrid[3]
	0x0F12021A, //awbb_OutdoorGrZones_m_BGrid[4]
	0x0F1202F0, //awbb_OutdoorGrZones_m_BGrid[5]
	0x0F120208, //awbb_OutdoorGrZones_m_BGrid[6]
	0x0F120316, //awbb_OutdoorGrZones_m_BGrid[7]
	0x0F1201F6, //awbb_OutdoorGrZones_m_BGrid[8]
	0x0F1202FE, //awbb_OutdoorGrZones_m_BGrid[9]
	0x0F1201E4, //awbb_OutdoorGrZones_m_BGrid[10]
	0x0F1202E8, //awbb_OutdoorGrZones_m_BGrid[11]
	0x0F1201D2, //awbb_OutdoorGrZones_m_BGrid[12]
	0x0F1202D2, //awbb_OutdoorGrZones_m_BGrid[13]
	0x0F1201CA, //awbb_OutdoorGrZones_m_BGrid[14]
	0x0F1202BC, //awbb_OutdoorGrZones_m_BGrid[15]
	0x0F1201CA, //awbb_OutdoorGrZones_m_BGrid[16]
	0x0F1202A6, //awbb_OutdoorGrZones_m_BGrid[17]
	0x0F1201D0, //awbb_OutdoorGrZones_m_BGrid[18]
	0x0F12028E, //awbb_OutdoorGrZones_m_BGrid[19]
	0x0F1201D6, //awbb_OutdoorGrZones_m_BGrid[20]
	0x0F120278, //awbb_OutdoorGrZones_m_BGrid[21]
	0x0F1201F8, //awbb_OutdoorGrZones_m_BGrid[22]
	0x0F120244, //awbb_OutdoorGrZones_m_BGrid[23]
	//	param_end	awbb_OutdoorGrZones_m_BGrid

	0x0F120004, //awbb_OutdoorGrZones_m_Gri
	0x002A0FB8,
	0x0F12000C, //awbb_OutdoorGrZones_ZInfo_m_GridSz
	0x002A0FBC,
	0x0F1201D8, //awbb_OutdoorGrZones_m_Bof

	//	param_start	awbb_LowBrGrZones_m_BGrid
	0x002A0FC0,
	0x0F120400, //awbb_LowBrGrZones_m_BGrid[0]
	0x0F120656, //awbb_LowBrGrZones_m_BGrid[1]
	0x0F12035A, //awbb_LowBrGrZones_m_BGrid[2]
	0x0F1205BE, //awbb_LowBrGrZones_m_BGrid[3]
	0x0F1202E6, //awbb_LowBrGrZones_m_BGrid[4]
	0x0F120524, //awbb_LowBrGrZones_m_BGrid[5]
	0x0F120290, //awbb_LowBrGrZones_m_BGrid[6]
	0x0F1204A0, //awbb_LowBrGrZones_m_BGrid[7]
	0x0F120246, //awbb_LowBrGrZones_m_BGrid[8]
	0x0F12041A, //awbb_LowBrGrZones_m_BGrid[9]
	0x0F1201FE, //awbb_LowBrGrZones_m_BGrid[10]
	0x0F1203AE, //awbb_LowBrGrZones_m_BGrid[11]
	0x0F1201C0, //awbb_LowBrGrZones_m_BGrid[12]
	0x0F12035A, //awbb_LowBrGrZones_m_BGrid[13]
	0x0F120192, //awbb_LowBrGrZones_m_BGrid[14]
	0x0F120306, //awbb_LowBrGrZones_m_BGrid[15]
	0x0F120170, //awbb_LowBrGrZones_m_BGrid[16]
	0x0F1202BA, //awbb_LowBrGrZones_m_BGrid[17]
	0x0F12015C, //awbb_LowBrGrZones_m_BGrid[18]
	0x0F120278, //awbb_LowBrGrZones_m_BGrid[19]
	0x0F12019C, //awbb_LowBrGrZones_m_BGrid[20]
	0x0F12024E, //awbb_LowBrGrZones_m_BGrid[21]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[22]
	0x0F120000, //awbb_LowBrGrZones_m_BGrid[23]

	//	param_end	awbb_LowBrGrZones_m_BGrid
	0x0F120006, //awbb_LowBrGrZones_m_GridStep
	0x002A0FF4,
	0x0F12000B, //awbb_LowBrGrZones_ZInfo_m_GridSz
	0x002A0FF8,
	0x0F120082, //awbb_LowBrGrZones_m_Boffs

	//===================================================================
	//AWB Scene Detection
	//===================================================================
	0x002A1098,
	0x0F12FE82, //awbb_SCDetectionMap_SEC_StartR_B
	0x0F12001E, //awbb_SCDetectionMap_SEC_StepR_B
	0x0F1209C4, //awbb_SCDetectionMap_SEC_SunnyNB
	0x0F120122, //awbb_SCDetectionMap_SEC_StepNB
	0x0F1200E4, //awbb_SCDetectionMap_SEC_LowTempR_B
	0x0F120096, //awbb_SCDetectionMap_SEC_SunnyNBZone
	0x0F12000E, //awbb_SCDetectionMap_SEC_LowTempR_BZone

	0x002A105C,
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__2_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__4_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__1_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__3_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__0_
	0x0F120000, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__2_
	0x0F120500, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__4_
	0x0F125555, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__1_
	0x0F125455, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__3_
	0x0F12AA55, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__0_
	0x0F12AAAA, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__2_
	0x0F12BF54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__3_
	0x0F12FF6F, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__2_
	0x0F121B54, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__4_
	0x0F12FFFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__1_
	0x0F1254FE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__3_
	0x0F12FF06, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__0_
	0x0F12FEFF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__2_
	0x0F120154, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__4_
	0x0F12BFBF, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__1_
	0x0F1254BE, //#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__3_


	//===================================================================
	//AWB - GridCorrection
	//===================================================================
	0x002A11E0,
	0x0F120002, //awbb_GridEnable

	0x002A11A8,
	0x0F12028E, //awbb_GridCon0xt_1[0]
	0x0F120306, //awbb_GridCon0xt_1[1]
	0x0F1203A6, //awbb_GridCon0xt_1[2]

	0x0F120F86, //awbb_GridCon0xt_2[0]  0F86
	0x0F12105F, //awbb_GridCon0xt_2[1]  105F
	0x0F121160, //awbb_GridCon0xt_2[2]  11AA
	0x0F121161, //awbb_GridCon0xt_2[3]  1111
	0x0F1211F2, //awbb_GridCon0xt_2[4]  120C
	0x0F1212A1, //awbb_GridCon0xt_2[5]  126D

	0x0F12008F, //awbb_GridCoeff_R_1
	0x0F1200D4, //awbb_GridCoeff_B_1
	0x0F1200C6, //awbb_GridCoeff_R_2
	0x0F1200A2, //awbb_GridCoeff_B_2

	0x002A1118,
	0x0F120000, //0032         //awbb_GridCorr_R[0][0]
	0x0F120000, //0012         //awbb_GridCorr_R[0][1]
	0x0F120000, //0012         //awbb_GridCorr_R[0][2]
	0x0F120018, //FFEC         //awbb_GridCorr_R[0][3]
	0x0F120018, //FFEC         //awbb_GridCorr_R[0][4]
	0x0F120060, //0050         //awbb_GridCorr_R[0][5]
	0x0F120000, //0032         //awbb_GridCorr_R[1][0]
	0x0F120000, //0012         //awbb_GridCorr_R[1][1]
	0x0F120000, //0012         //awbb_GridCorr_R[1][2]
	0x0F120018, //FFEC         //awbb_GridCorr_R[1][3]
	0x0F120018, //FFEC         //awbb_GridCorr_R[1][4]
	0x0F120060, //0050         //awbb_GridCorr_R[1][5]
	0x0F120000, //0032         //awbb_GridCorr_R[2][0]
	0x0F120000, //0012         //awbb_GridCorr_R[2][1]
	0x0F120000, //0012         //awbb_GridCorr_R[2][2]
	0x0F120018, //FFEC         //awbb_GridCorr_R[2][3]
	0x0F120018, //FFEC         //awbb_GridCorr_R[2][4]
	0x0F120060, //0050         //awbb_GridCorr_R[2][5]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[0][0]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[0][1]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[0][2]
	0x0F12FF22, //FE40       //awbb_GridCorr_B[0][3]
	0x0F12FF22, //FE40       //awbb_GridCorr_B[0][4]
	0x0F12FE3E, //FCE0       //awbb_GridCorr_B[0][5]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[1][0]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[1][1]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[1][2]
	0x0F12FF22, //FE40       //awbb_GridCorr_B[1][3]
	0x0F12FF22, //FE40       //awbb_GridCorr_B[1][4]
	0x0F12FE3E, //FCE0       //awbb_GridCorr_B[1][5]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[2][0]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[2][1]
	0x0F12FFD0, //FFD0       //awbb_GridCorr_B[2][2]
	0x0F12FF22, //FE40       //awbb_GridCorr_B[2][3]
	0x0F12FF22, //FE40       //awbb_GridCorr_B[2][4]
	0x0F12FE3E, //FCE0       //awbb_GridCorr_B[2][5]

	0x002A1160,
	0x0F120000, //awbb_GridCorr_R_Out[0][0]
	0x0F120000, //awbb_GridCorr_R_Out[0][1]
	0x0F120000, //awbb_GridCorr_R_Out[0][2]
	0x0F120000, //awbb_GridCorr_R_Out[0][3]
	0x0F120000, //awbb_GridCorr_R_Out[0][4]
	0x0F120000, //awbb_GridCorr_R_Out[0][5]
	0x0F120000, //awbb_GridCorr_R_Out[1][0]
	0x0F120000, //awbb_GridCorr_R_Out[1][1]
	0x0F120000, //awbb_GridCorr_R_Out[1][2]
	0x0F120000, //awbb_GridCorr_R_Out[1][3]
	0x0F120000, //awbb_GridCorr_R_Out[1][4]
	0x0F120000, //awbb_GridCorr_R_Out[1][5]
	0x0F120000, //awbb_GridCorr_R_Out[2][0]
	0x0F120000, //awbb_GridCorr_R_Out[2][1]
	0x0F120000, //awbb_GridCorr_R_Out[2][2]
	0x0F120000, //awbb_GridCorr_R_Out[2][3]
	0x0F120000, //awbb_GridCorr_R_Out[2][4]
	0x0F120000, //awbb_GridCorr_R_Out[2][5]
	0x0F12FFA0, //awbb_GridCorr_B_Out[0][0]
	0x0F12FFA0, //awbb_GridCorr_B_Out[0][1]
	0x0F12FFA0, //awbb_GridCorr_B_Out[0][2]
	0x0F12FFA0, //awbb_GridCorr_B_Out[0][3]
	0x0F12FFA0, //awbb_GridCorr_B_Out[0][4]
	0x0F12FFA0, //awbb_GridCorr_B_Out[0][5]
	0x0F12FFA0, //awbb_GridCorr_B_Out[1][0]
	0x0F12FFA0, //awbb_GridCorr_B_Out[1][1]
	0x0F12FFA0, //awbb_GridCorr_B_Out[1][2]
	0x0F12FFA0, //awbb_GridCorr_B_Out[1][3]
	0x0F12FFA0, //awbb_GridCorr_B_Out[1][4]
	0x0F12FFA0, //awbb_GridCorr_B_Out[1][5]
	0x0F12FFA0, //awbb_GridCorr_B_Out[2][0]
	0x0F12FFA0, //awbb_GridCorr_B_Out[2][1]
	0x0F12FFA0, //awbb_GridCorr_B_Out[2][2]
	0x0F12FFA0, //awbb_GridCorr_B_Out[2][3]
	0x0F12FFA0, //awbb_GridCorr_B_Out[2][4]
	0x0F12FFA0, //awbb_GridCorr_B_Out[2][5]


	 // SLOW AWB
	0x002A110E,
	0x0F120258, //0258 awbb_GainsMaxMove         //

	 //AWB Convergence Speed          //
	0x002A11D6,
	0x0F120008,
	0x0F12FFFF,	         //0190	awbb_WpFilterMaxThr          //
	0x0F120010, //00A0	         //awbb_WpFilterCoef p          //
	0x0F120020,	         //0004 awbb_WpFilterSize          //

	//===================================================================
	// CCM
	//===================================================================
	0x002A07D2,
	0x0F1200C0, //SARR_AwbCcmCord_0_
	0x0F1200E0, //SARR_AwbCcmCord_1_
	0x0F120110, //SARR_AwbCcmCord_2_
	0x0F120139, //SARR_AwbCcmCord_3_
	0x0F120166, //SARR_AwbCcmCord_4_
	0x0F12019F, //SARR_AwbCcmCord_5_

	//	param_start	TVAR_wbt_pBaseCcms
	0x002A07C4,
	0x0F124000, //TVAR_wbt_pBaseCcms
	0x0F127000,

	0x002A4000,
	0x0F1201D4, //01DA 01CF 01CE 01C0 01D4                  //TVAR_wbt_pBaseCcms[0]
	0x0F12FFCD, //FFC4 FFC3 FFB9 FFCB FFB2                  //TVAR_wbt_pBaseCcms[1]
	0x0F12FFC4, //FFCD FFDD FFE8 FFE4 FFEE                  //TVAR_wbt_pBaseCcms[2]
	0x0F12FF2A, //FF31 FF43 FF43 FF43 FF47                  //TVAR_wbt_pBaseCcms[3]
	0x0F120124, //012A 011D 011D 011D 012C                  //TVAR_wbt_pBaseCcms[4]
	0x0F12FF73, //FF6B FF6B FF6B FF6B FF5C                  //TVAR_wbt_pBaseCcms[5]
	0x0F12FFE1, //FFDA FFDA FFDA FFDA FFCE                  //TVAR_wbt_pBaseCcms[6]
	0x0F12FFBD, //FFC3 FFD1 FFD1 FFD1 FFD6                  //TVAR_wbt_pBaseCcms[7]
	0x0F120159, //015F 0156 0156 0156 0162                  //TVAR_wbt_pBaseCcms[8]
	0x0F1200EF, //0100 00FF 00FC 00F7 011D                  //TVAR_wbt_pBaseCcms[9]
	0x0F1200E0, //00DE 00CE 00CC 00D1 00C6                  //TVAR_wbt_pBaseCcms[10]
	0x0F12FED9, //FECE FEE3 FEE9 FEE9 FED2                  //TVAR_wbt_pBaseCcms[11]
	0x0F1200DA, //00D5 00CD 00CD 00CD 00C8                  //TVAR_wbt_pBaseCcms[12]
	0x0F12FF57, //FF56 FF5E FF5E FF5E FF56                  //TVAR_wbt_pBaseCcms[13]
	0x0F120119, //0123 0128 0128 0128 0139                  //TVAR_wbt_pBaseCcms[14]
	0x0F12FF74, //FF73 FF7E FF7E FF7E FF75                  //TVAR_wbt_pBaseCcms[15]
	0x0F1200DF, //00E9 00EC 00EC 00EC 00FB                  //TVAR_wbt_pBaseCcms[16]
	0x0F1200FF, //00FC 00F2 00F2 00F2 00F0                  //TVAR_wbt_pBaseCcms[17]

	0x0F1201D4, //01D4                  //TVAR_wbt_pBaseCcms[18]
	0x0F12FFCD, //FFB2                  //TVAR_wbt_pBaseCcms[19]
	0x0F12FFC4, //FFEE                  //TVAR_wbt_pBaseCcms[20]
	0x0F12FF2A, //FF47                  //TVAR_wbt_pBaseCcms[21]
	0x0F120124, //012C                  //TVAR_wbt_pBaseCcms[22]
	0x0F12FF73, //FF5C                  //TVAR_wbt_pBaseCcms[23]
	0x0F12FFE1, //FFCE                  //TVAR_wbt_pBaseCcms[24]
	0x0F12FFBD, //FFD6                  //TVAR_wbt_pBaseCcms[25]
	0x0F120159, //0162                  //TVAR_wbt_pBaseCcms[26]
	0x0F1200EF, //011D                  //TVAR_wbt_pBaseCcms[27]
	0x0F1200E0, //00C6                  //TVAR_wbt_pBaseCcms[28]
	0x0F12FED9, //FED2                  //TVAR_wbt_pBaseCcms[29]
	0x0F1200DA, //00C8                  //TVAR_wbt_pBaseCcms[30]
	0x0F12FF57, //FF56                  //TVAR_wbt_pBaseCcms[31]
	0x0F120119, //0139                  //TVAR_wbt_pBaseCcms[32]
	0x0F12FF74, //FF75                  //TVAR_wbt_pBaseCcms[33]
	0x0F1200DF, //00FB                  //TVAR_wbt_pBaseCcms[34]
	0x0F1200FF, //00F0                  //TVAR_wbt_pBaseCcms[35]

	0x0F1201C0, //01D4                  //TVAR_wbt_pBaseCcms[36]
	0x0F12FFCB, //FFB2                  //TVAR_wbt_pBaseCcms[37]
	0x0F12FFE4, //FFEE                  //TVAR_wbt_pBaseCcms[38]
	0x0F12FF43, //FF47                  //TVAR_wbt_pBaseCcms[39]
	0x0F12011D, //012C                  //TVAR_wbt_pBaseCcms[40]
	0x0F12FF6B, //FF5C                  //TVAR_wbt_pBaseCcms[41]
	0x0F12FFDA, //FFCE                  //TVAR_wbt_pBaseCcms[42]
	0x0F12FFD1, //FFD6                  //TVAR_wbt_pBaseCcms[43]
	0x0F120156, //0162                  //TVAR_wbt_pBaseCcms[44]
	0x0F1200F7, //011D                  //TVAR_wbt_pBaseCcms[45]
	0x0F1200D1, //00C6                  //TVAR_wbt_pBaseCcms[46]
	0x0F12FEE9, //FED2                  //TVAR_wbt_pBaseCcms[47]
	0x0F1200CD, //00C8                  //TVAR_wbt_pBaseCcms[48]
	0x0F12FF5E, //FF56                  //TVAR_wbt_pBaseCcms[49]
	0x0F120128, //0139                  //TVAR_wbt_pBaseCcms[50]
	0x0F12FF7E, //FF75                  //TVAR_wbt_pBaseCcms[51]
	0x0F1200EC, //00FB                  //TVAR_wbt_pBaseCcms[52]
	0x0F1200F2, //00F0                  //TVAR_wbt_pBaseCcms[53]

	0x0F1201C0, //01D4                  //TVAR_wbt_pBaseCcms[54]
	0x0F12FFCB, //FFB2                  //TVAR_wbt_pBaseCcms[55]
	0x0F12FFE4, //FFEE                  //TVAR_wbt_pBaseCcms[56]
	0x0F12FF43, //FF47                  //TVAR_wbt_pBaseCcms[57]
	0x0F12011D, //012C                  //TVAR_wbt_pBaseCcms[58]
	0x0F12FF6B, //FF5C                  //TVAR_wbt_pBaseCcms[59]
	0x0F12FFDA, //FFCE                  //TVAR_wbt_pBaseCcms[60]
	0x0F12FFD1, //FFD6                  //TVAR_wbt_pBaseCcms[61]
	0x0F120156, //0162                  //TVAR_wbt_pBaseCcms[62]
	0x0F1200F7, //011D                  //TVAR_wbt_pBaseCcms[63]
	0x0F1200D1, //00C6                  //TVAR_wbt_pBaseCcms[64]
	0x0F12FEE9, //FED2                  //TVAR_wbt_pBaseCcms[65]
	0x0F1200CD, //00C8                  //TVAR_wbt_pBaseCcms[66]
	0x0F12FF5E, //FF56                  //TVAR_wbt_pBaseCcms[67]
	0x0F120128, //0139                  //TVAR_wbt_pBaseCcms[68]
	0x0F12FF7E, //FF75                  //TVAR_wbt_pBaseCcms[69]
	0x0F1200EC, //00FB                  //TVAR_wbt_pBaseCcms[70]
	0x0F1200F2, //00F0                  //TVAR_wbt_pBaseCcms[71]

	0x0F120111, //0114                            //TVAR_wbt_pBaseCcms[72]
	0x0F12FFB5, //FFAC                  //TVAR_wbt_pBaseCcms[73]
	0x0F120000, //FFFB                  //TVAR_wbt_pBaseCcms[74]
	0x0F12FF26, //FF1D                  //TVAR_wbt_pBaseCcms[75]
	0x0F120179, //0182                  //TVAR_wbt_pBaseCcms[76]
	0x0F12FF4B, //FF40                  //TVAR_wbt_pBaseCcms[77]
	0x0F12FFE1, //FFD8                  //TVAR_wbt_pBaseCcms[78]
	0x0F12FFF0, //FFE9                  //TVAR_wbt_pBaseCcms[79]
	0x0F120151, //0155                  //TVAR_wbt_pBaseCcms[80]
	0x0F120099, //009A                  //TVAR_wbt_pBaseCcms[81]
	0x0F12008C, //008B                  //TVAR_wbt_pBaseCcms[82]
	0x0F12FF28, //FF1C                  //TVAR_wbt_pBaseCcms[83]
	0x0F1200C4, //00C2                  //TVAR_wbt_pBaseCcms[84]
	0x0F12FF7A, //FF6E                  //TVAR_wbt_pBaseCcms[85]
	0x0F120134, //0137                  //TVAR_wbt_pBaseCcms[86]
	0x0F12FF85, //FF79                  //TVAR_wbt_pBaseCcms[87]
	0x0F120105, //0106                  //TVAR_wbt_pBaseCcms[88]
	0x0F1200F2, //00F1                  //TVAR_wbt_pBaseCcms[89]

	0x0F120111, //0114                            //TVAR_wbt_pBaseCcms[90]
	0x0F12FFB5, //FFAC                  //TVAR_wbt_pBaseCcms[91]
	0x0F120000, //FFFB                  //TVAR_wbt_pBaseCcms[92]
	0x0F12FF26, //FF1D                  //TVAR_wbt_pBaseCcms[93]
	0x0F120179, //0182                  //TVAR_wbt_pBaseCcms[94]
	0x0F12FF4B, //FF40                  //TVAR_wbt_pBaseCcms[95]
	0x0F12FFE1, //FFD8                  //TVAR_wbt_pBaseCcms[96]
	0x0F12FFF0, //FFE9                  //TVAR_wbt_pBaseCcms[97]
	0x0F120151, //0155                  //TVAR_wbt_pBaseCcms[98]
	0x0F120099, //009A                  //TVAR_wbt_pBaseCcms[99]
	0x0F12008C, //008B                  //TVAR_wbt_pBaseCcms[100]
	0x0F12FF28, //FF1C                  //TVAR_wbt_pBaseCcms[101]
	0x0F1200C4, //00C2                  //TVAR_wbt_pBaseCcms[102]
	0x0F12FF7A, //FF6E                  //TVAR_wbt_pBaseCcms[103]
	0x0F120134, //0137                  //TVAR_wbt_pBaseCcms[104]
	0x0F12FF85, //FF79                  //TVAR_wbt_pBaseCcms[105]
	0x0F120105, //0106                  //TVAR_wbt_pBaseCcms[106]
	0x0F1200F2, //00F1                  //TVAR_wbt_pBaseCcms[107]
	//	param_end	TVAR_wbt_pBasecms


	0x002A07CC,
	0x0F1240D8, //#TVAR_wbt_pOutdoorCcm
	0x0F127000,

	//	param_start	TVAR_wbt_pOutdoorCcm
	0x002A40D8,
	0x0F1201BE, //0205                  //01F8                  //TVAR_wbt_pOutdoorCcm[0]
	0x0F12FFE4, //FF96                  //FFAF                  //TVAR_wbt_pOutdoorCcm[1]
	0x0F120000, //FFDF                  //FFD3                  //TVAR_wbt_pOutdoorCcm[2]
	0x0F12FEF9, //FEC8                  //FEC4                  //TVAR_wbt_pOutdoorCcm[3]
	0x0F120149, //01A4                  //0191                  //TVAR_wbt_pOutdoorCcm[4]
	0x0F12FF70, //FF1C                  //FF33                  //TVAR_wbt_pOutdoorCcm[5]
	0x0F12003C, //FFF7                  //FFED                  //TVAR_wbt_pOutdoorCcm[6]
	0x0F120023, //000C                  //0017                  //TVAR_wbt_pOutdoorCcm[7]
	0x0F1201DD, //0211                  //0210                  //TVAR_wbt_pOutdoorCcm[8]
	0x0F1200D4, //0107                  //00E3                  //TVAR_wbt_pOutdoorCcm[9]
	0x0F1200F8, //00F3                  //0107                  //TVAR_wbt_pOutdoorCcm[10]
	0x0F12FF74, //FF1F                  //FF2F                  //TVAR_wbt_pOutdoorCcm[11]
	0x0F120212, //0220                  //0220                  //TVAR_wbt_pOutdoorCcm[12]
	0x0F120039, //FFE7                  //FFE7                  //TVAR_wbt_pOutdoorCcm[13]
	0x0F120184, //01A1                  //01A1                  //TVAR_wbt_pOutdoorCcm[14]
	0x0F12FF28, //FEC7                  //FEC8                  //TVAR_wbt_pOutdoorCcm[15]
	0x0F120133, //016D                  //017D                  //TVAR_wbt_pOutdoorCcm[16]
	0x0F120153, //0153                  //0142                  //TVAR_wbt_pOutdoorCcm[17]
	//	param_end	TVAR_wbt_pOutdoorCcm

	0x002A2A64,
	0x0F120001, //#MVAR_AAIO_bFIT
	0x002A2A68,
	0x0F120001, //#MVAR_AAIO_bAutoCCMandASH
	0x002A2A3C,
	0x0F1201DD, //#Mon_AAIO_PrevFrmData_NormBr

	//===================================================================
	// AFIT
	//===================================================================

	//	param_start	afit_uNoiseIndInDoor
	0x002A085C,
	0x0F12004A, //0049                  //#afit_uNoiseIndInDoor_0_
	0x0F12004E, //005F                  //#afit_uNoiseIndInDoor_1_
	0x0F1200CB, //00CB                  //#afit_uNoiseIndInDoor_2_
	0x0F1201C0, //01E0                  //#afit_uNoiseIndInDoor_3_
	0x0F120200, //0220                  //#afit_uNoiseIndInDoor_4_


	0x002A08C0,
	0x0F120030, //0007         //700008C0         //AFIT16_BRIGHTNESS
	0x0F120000, //0000         //700008C2                    //AFIT16_CONTRAST
	0x0F120010, //0000         //700008C4                    //AFIT16_SATURATION
	0x0F120000, //0000         //700008C6                    //AFIT16_SHARP_BLUR
	0x0F120000, //0000         //700008C8                    //AFIT16_GLAMOUR
	0x0F1200C1, //00C1         //700008CA                    //AFIT16_sddd8a_edge_high
	0x0F120000, //0000         //700008CC
	0x0F1203FF, //03FF         //700008CE                    //AFIT16_Demosaicing_iSatVal
	0x0F12009C, //009C         //700008D0                    //AFIT16_Sharpening_iReduceEdgeThre
	0x0F12017C, //017C         //700008D2                    //AFIT16_demsharpmix1_iRGBOffset
	0x0F1203FF, //03FF         //700008D4                    //AFIT16_demsharpmix1_iDemClamp
	0x0F12000C, //000C         //700008D6                    //AFIT16_demsharpmix1_iLowThreshold
	0x0F120010, //0010         //700008D8                    //AFIT16_demsharpmix1_iHighThreshol
	0x0F12012C, //012C         //700008DA                    //AFIT16_demsharpmix1_iLowBright
	0x0F1203E8, //03E8         //700008DC                    //AFIT16_demsharpmix1_iHighBright
	0x0F120046, //0046         //700008DE                    //AFIT16_demsharpmix1_iLowSat
	0x0F12005A, //005A         //700008E0                    //AFIT16_demsharpmix1_iHighSat
	0x0F120070, //0070         //700008E2                    //AFIT16_demsharpmix1_iTune
	0x0F120001, //0010         //700008E4         //AFIT16_demsharpmix1_iHystThLow
	0x0F120000, //0010         //700008E6         //AFIT16_demsharpmix1_iHystThHigh
	0x0F120320, //01F4         //700008E8         //AFIT16_demsharpmix1_iHystCenter
	0x0F12006E, //003C         //700008EA                    //AFIT16_Sharpening_iLowSharpClamp
	0x0F120014, //0008         //700008EC                    //AFIT16_Sharpening_iHighSharpClamp
	0x0F12006E, //003C         //700008EE                    //AFIT16_Sharpening_iLowSharpClamp_
	0x0F120014, //001E         //700008F0                    //AFIT16_Sharpening_iHighSharpClamp
	0x0F12006E, //003C         //700008F2                    //AFIT16_Sharpening_iLowSharpClamp_
	0x0F120014, //001E         //700008F4                    //AFIT16_Sharpening_iHighSharpClamp
	0x0F120A24, //0A24         //700008F6                    //AFIT8_sddd8a_edge_low [7:0] AFIT8
	0x0F121701, //1701         //700008F8                    //AFIT8_sddd8a_repl_force [7:0] AFI
	0x0F120229, //0229         //700008FA                    //AFIT8_sddd8a_sat_thr[7:0] AFIT8_s
	0x0F121403, //1403         //700008FC                    //AFIT8_sddd8a_sat_noise[7:0] AFIT8
	0x0F120004, //0004         //700008FE                    //AFIT8_sddd8a_iHotThreshHigh[7:0]
	0x0F120300, //0300         //70000900                    //AFIT8_sddd8a_iColdThreshHigh[7:0]
	0x0F120000, //0000         //70000902                    //AFIT8_sddd8a_AddNoisePower1[7:0]
	0x0F1202FF, //02FF         //70000904                    //AFIT8_sddd8a_iSatSat[7:0] AFIT8_s
	0x0F1205E8, //09E8         //70000906                    //AFIT8_sddd8a_iRadialLimit [7:0] A
	0x0F121414, //1414         //70000908                    //AFIT8_sddd8a_iLowMaxSlopeAllowed
	0x0F120301, //0301         //7000090A                    //AFIT8_sddd8a_iLowSlopeThresh[7:0]
	0x0F120007, //0007         //7000090C                    //AFIT8_sddd8a_iSquaresRounding [7:
	0x0F122000, //4000         //7000090E
	0x0F125003, //7803         //70000910
	0x0F123228, //3C50         //70000912
	0x0F120032, //003C         //70000914
	0x0F121E80, //1E80         //70000916                    //AFIT8_Demosaicing_iCentGrad[7:0]
	0x0F121E08, //1E08         //70000918                    //AFIT8_Demosaicing_iDecisionThresh
	0x0F12000A, //000A         //7000091A                    //AFIT8_Demosaicing_iEnhThresh[7:0]
	0x0F120000, //0000         //7000091C                    //AFIT8_Demosaicing_iGBDenoiseVal[7
	0x0F12270A, //120A         //7000091E                    //AFIT8_Demosaicing_iDFD_ReduceCoef
	0x0F120010, //0F00         //70000920                    //AFIT8_Sharpening_iMShThresh[7:0]
	0x0F120200, //0200         //70000922                    //AFIT8_Sharpening_iWShThresh[7:0]
	0x0F12FF00, //FF00         //70000924                    //AFIT8_Sharpening_iReduceNegative[
	0x0F120200, //0200         //70000926                    //AFIT8_demsharpmix1_iRGBMultiplier
	0x0F121B11, //1B11         //70000928                    //AFIT8_demsharpmix1_iBCoeff[7:0] A
	0x0F120000, //0000         //7000092A                    //AFIT8_demsharpmix1_iWideMult[7:0]
	0x0F120009, //0009         //7000092C                    //AFIT8_demsharpmix1_iHystFalloff[7
	0x0F120406, //0406         //7000092E                    //AFIT8_demsharpmix1_iHystWidth[7:0
	0x0F120605, //0605         //70000930                    //AFIT8_demsharpmix1_iHystFallHigh[
	0x0F120307, //0307         //70000932
	0x0F120609, //0609         //70000934
	0x0F122C07, //2C07         //70000936
	0x0F12142C, //142C         //70000938
	0x0F120518, //0718         //7000093A         //[15:8]iUVNRStrengthL [7:0]iMaxThreshH
	0x0F128005, //8007         //7000093C         //[7:0]iUVNRStrengthH AFIT8_byr_cgras_iShading
	0x0F120594, //0880         //7000093E                    //AFIT8_RGBGamma2_iLinearity [7:0]
	0x0F120080, //0B50         //70000940                    //AFIT8_ccm_oscar_iSaturation[7:0]
	0x0F120080, //0080         //70000942                    //AFIT8_RGB2YUV_iRGBGain [7:0]   AF
	0x0F120101, //0101         //70000944                    //AFIT8_sddd8a_iClustThresh_H [7:0]
	0x0F120707, //0707         //70000946                    //AFIT8_sddd8a_iClustMulT_H [7:0]
	0x0F124B01, //4601         //70000948                    //AFIT8_sddd8a_nClustLevel_H [7:0]
	0x0F12314B, //C844         //7000094A                    //AFIT8_sddd8a_DispTH_High [7:0]
	0x0F125038, //50C8         //7000094C                    //AFIT8_sddd8a_iDenThreshHigh[7:0]
	0x0F120500, //0500         //7000094E                    //AFIT8_Demosaicing_iEdgeDesatThrLo
	0x0F120903, //0003         //70000950                    //AFIT8_Demosaicing_iEdgeDesatLimit
	0x0F121003, //1C01         //70000952                    //AFIT8_Demosaicing_iDemSharpenHigh
	0x0F12071E, //0714         //70000954                    //AFIT8_Demosaicing_iDemShLowLimit
	0x0F121432, //1464         //70000956                    //AFIT8_Demosaicing_iDemBlurLow[7:0
	0x0F125F01, //5A04         //70000958                    //AFIT8_Demosaicing_iDemBlurRange[7
	0x0F122829, //3C1E         //7000095A                    //AFIT8_Sharpening_iHighSharpPower[
	0x0F12200F, //400F         //7000095C                    //AFIT8_Sharpening_iHighShDenoise [
	0x0F120204, //0204         //7000095E                    //AFIT8_Sharpening_iReduceEdgeSlope
	0x0F120103, //1403         //70000960                    //AFIT8_demsharpmix1_iNarrFiltReduc
	0x0F120701, //0114         //70000962                    //AFIT8_sddd8a_iClustThresh_C_Bin [
	0x0F120101, //0101         //70000964                    //AFIT8_sddd8a_iClustMulT_C_Bin [7:
	0x0F124B4B, //4446         //70000966                    //AFIT8_sddd8a_DispTH_Low_Bin [7:0]
	0x0F124449, //646E         //70000968                    //AFIT8_sddd8a_iDenThreshLow_Bin [7
	0x0F120050, //0028         //7000096A                    //AFIT8_Demosaicing_iEdgeDesat_Bin[
	0x0F120305, //030A         //7000096C                    //AFIT8_Demosaicing_iEdgeDesatThrHi
	0x0F120346, //0000         //7000096E                    //AFIT8_Demosaicing_iDemSharpenLow_
	0x0F121E0D, //141E         //70000970                    //AFIT8_Demosaicing_iDemSharpThresh
	0x0F123207, //FF07         //70000972                    //AFIT8_Demosaicing_iDespeckleForDe
	0x0F120114, //0432         //70000974                    //AFIT8_Demosaicing_iDemBlurHigh_Bi
	0x0F121E6A, //0000         //70000976                    //AFIT8_Sharpening_iLowSharpPower_B
	0x0F120F28, //0F0F         //70000978                    //AFIT8_Sharpening_iLowShDenoise_Bi
	0x0F120420, //0440         //7000097A                    //AFIT8_Sharpening_iReduceEdgeMinMu
	0x0F120302, //0302         //7000097C                    //AFIT8_demsharpmix1_iWideFiltReduc
	0x0F121E1E, //1414         //7000097E                    //AFIT8_sddd8a_iClustThresh_H_sBin[
	0x0F120101, //0101         //70000980                    //AFIT8_sddd8a_iClustMulT_H_sBin [7
	0x0F124B01, //4601         //70000982                    //AFIT8_sddd8a_nClustLevel_H_sBin [
	0x0F12494B, //6E44         //70000984                    //AFIT8_sddd8a_DispTH_High_sBin [7:
	0x0F125044, //2864         //70000986                    //AFIT8_sddd8a_iDenThreshHigh_sBin[
	0x0F120500, //0A00         //70000988                    //AFIT8_Demosaicing_iEdgeDesatThrLo
	0x0F124603, //0003         //7000098A                    //AFIT8_Demosaicing_iEdgeDesatLimit
	0x0F120D03, //1E00         //7000098C                    //AFIT8_Demosaicing_iDemSharpenHigh
	0x0F12071E, //0714         //7000098E                    //AFIT8_Demosaicing_iDemShLowLimit_
	0x0F121432, //32FF         //70000990                    //AFIT8_Demosaicing_iDemBlurLow_sBi
	0x0F126A01, //0004         //70000992                    //AFIT8_Demosaicing_iDemBlurRange_s
	0x0F12281E, //0F00         //70000994                    //AFIT8_Sharpening_iHighSharpPower_
	0x0F12200F, //400F         //70000996                    //AFIT8_Sharpening_iHighShDenoise_s
	0x0F120204, //0204         //70000998                    //AFIT8_Sharpening_iReduceEdgeSlope
	0x0F120003, //0003         //7000099A                    //AFIT8_demsharpmix1_iNarrFiltReduc
	0x0F120001, //0001         //7000099C
	0x0F120030, //0000                  //7000099E                  //AFIT16_BRIGHTNESS
	0x0F120000, //0000                  //700009A0                             //AFIT16_CONTRAST
	0x0F120010, //0000                  //700009A2                             //AFIT16_SATURATI
	0x0F120000, //0000                  //700009A4                             //AFIT16_SHARP_BL
	0x0F120000, //0000                  //700009A6                             //AFIT16_GLAMOUR
	0x0F1200C1, //00C1                  //700009A8                             //AFIT16_sddd8a_e
	0x0F120000, //0000                  //700009AA
	0x0F1203FF, //03FF                  //700009AC                             //AFIT16_Demosaic
	0x0F12009C, //009C                  //700009AE                             //AFIT16_Sharpeni
	0x0F12017C, //017C                  //700009B0                             //AFIT16_demsharp
	0x0F1203FF, //03FF                  //700009B2                             //AFIT16_demsharp
	0x0F12000C, //000C                  //700009B4                             //AFIT16_demsharp
	0x0F120010, //0010                  //700009B6                             //AFIT16_demsharp
	0x0F12012C, //012C                  //700009B8                             //AFIT16_demsharp
	0x0F1203E8, //03E8                  //700009BA                             //AFIT16_demsharp
	0x0F120046, //0046                  //700009BC                             //AFIT16_demsharp
	0x0F12005A, //005A                  //700009BE                             //AFIT16_demsharp
	0x0F120070, //0070                  //700009C0                             //AFIT16_demsharp
	0x0F120001, //0001                  //700009C2                  //AFIT16_demsharpmix1_iHystT
	0x0F120000, //0000                  //700009C4                  //AFIT16_demsharpmix1_iHystT
	0x0F120320, //0320                  //700009C6                  //AFIT16_demsharpmix1_iHystC
	0x0F12006E, //006E                  //700009C8                             //AFIT16_Sharpeni
	0x0F120014, //0014                  //700009CA                             //AFIT16_Sharpeni
	0x0F12006E, //003C                  //700009CC                             //AFIT16_Sharpeni
	0x0F120014, //001E                  //700009CE                             //AFIT16_Sharpeni
	0x0F12006E, //003C                  //700009D0                             //AFIT16_Sharpeni
	0x0F120014, //001E                  //700009D2                             //AFIT16_Sharpeni
	0x0F120A24, //0A24                  //700009D4                             //AFIT8_sddd8a_ed
	0x0F121701, //1701                  //700009D6                             //AFIT8_sddd8a_re
	0x0F120229, //0229                  //700009D8                             //AFIT8_sddd8a_sa
	0x0F121403, //1403                  //700009DA                             //AFIT8_sddd8a_sa
	0x0F120004, //0004                  //700009DC                             //AFIT8_sddd8a_iH
	0x0F120300, //0300                  //700009DE                             //AFIT8_sddd8a_iC
	0x0F120000, //0000                  //700009E0                             //AFIT8_sddd8a_Ad
	0x0F1202FF, //02FF                  //700009E2                             //AFIT8_sddd8a_iS
	0x0F1205E8, //05E8                  //700009E4                             //AFIT8_sddd8a_iR
	0x0F121414, //1414                  //700009E6                             //AFIT8_sddd8a_iL
	0x0F120301, //0301                  //700009E8                             //AFIT8_sddd8a_iL
	0x0F120007, //0007                  //700009EA                             //AFIT8_sddd8a_iS
	0x0F122000, //2000                  //700009EC
	0x0F125003, //5003                  //700009EE
	0x0F123228, //3228                  //700009F0
	0x0F120032, //0032                  //700009F2
	0x0F121E80, //1E80                  //700009F4                             //AFIT8_Demosaici
	0x0F121E08, //1E08                  //700009F6                             //AFIT8_Demosaici
	0x0F12000A, //000A                  //700009F8                             //AFIT8_Demosaici
	0x0F120000, //0000                  //700009FA                             //AFIT8_Demosaici
	0x0F12270A, //120A                  //700009FC                             //AFIT8_Demosaici
	0x0F120010, //1400                  //700009FE                             //AFIT8_Sharpenin
	0x0F120200, //0200                  //70000A00                             //AFIT8_Sharpenin
	0x0F12FF00, //FF00                  //70000A02                             //AFIT8_Sharpenin
	0x0F120200, //0200                  //70000A04                             //AFIT8_demsharpm
	0x0F121B11, //1B11                  //70000A06                             //AFIT8_demsharpm
	0x0F120000, //0000                  //70000A08                             //AFIT8_demsharpm
	0x0F120009, //0009                  //70000A0A                             //AFIT8_demsharpm
	0x0F120406, //0406                  //70000A0C                             //AFIT8_demsharpm
	0x0F120605, //0605                  //70000A0E                             //AFIT8_demsharpm
	0x0F120307, //0307                  //70000A10
	0x0F120609, //0609                  //70000A12
	0x0F122C07, //2C07                  //70000A14
	0x0F12142C, //142C                  //70000A16
	0x0F120518, //0518                  //70000A18                  //[15:8]iUVNRStrengthL [7:0]
	0x0F128005, //8005                  //70000A1A                  //[7:0]iUVNRStrengthH AFIT8_
	0x0F120594, //0580                  //70000A1C                             //AFIT8_RGBGamma2
	0x0F120080, //0080                  //70000A1E                             //AFIT8_ccm_oscar
	0x0F120080, //0080                  //70000A20                             //AFIT8_RGB2YUV_i
	0x0F120101, //0101                  //70000A22                             //AFIT8_sddd8a_iC
	0x0F120707, //0707                  //70000A24                             //AFIT8_sddd8a_iC
	0x0F124B01, //4B01                  //70000A26                             //AFIT8_sddd8a_nC
	0x0F12314B, //444B 494B                  //70000A28                             //AFIT8_sddd
	0x0F125038, //503C 5044                  //70000A2A                             //AFIT8_sddd
	0x0F120500, //0500                  //70000A2C                             //AFIT8_Demosaici
	0x0F120903, //0503                  //70000A2E                             //AFIT8_Demosaici
	0x0F121003, //0D02                  //70000A30                             //AFIT8_Demosaici
	0x0F12071E, //071E                  //70000A32                             //AFIT8_Demosaici
	0x0F121432, //1432                  //70000A34                             //AFIT8_Demosaici
	0x0F125F01, //5A01                  //70000A36                             //AFIT8_Demosaici
	0x0F122829, //281E                  //70000A38                             //AFIT8_Sharpenin
	0x0F12200F, //200F                  //70000A3A                             //AFIT8_Sharpenin
	0x0F120204, //0204                  //70000A3C                             //AFIT8_Sharpenin
	0x0F120103, //1E03                  //70000A3E                             //AFIT8_demsharpm
	0x0F120701, //011E                  //70000A40                             //AFIT8_sddd8a_iC
	0x0F120101, //0101                  //70000A42                             //AFIT8_sddd8a_iC
	0x0F124B4B, //3A3C                  //70000A44                             //AFIT8_sddd8a_Di
	0x0F124449, //585A                  //70000A46                             //AFIT8_sddd8a_iD
	0x0F120050, //0028                  //70000A48                             //AFIT8_Demosaici
	0x0F120305, //030A                  //70000A4A                             //AFIT8_Demosaici
	0x0F120346, //0000                  //70000A4C                             //AFIT8_Demosaici
	0x0F121E0D, //141E                  //70000A4E                             //AFIT8_Demosaici
	0x0F123207, //FF07                  //70000A50                             //AFIT8_Demosaici
	0x0F120114, //0432                  //70000A52                             //AFIT8_Demosaici
	0x0F121E6A, //0000                  //70000A54                             //AFIT8_Sharpenin
	0x0F120F28, //0F0F                  //70000A56                             //AFIT8_Sharpenin
	0x0F120420, //0440                  //70000A58                             //AFIT8_Sharpenin
	0x0F120302, //0302                  //70000A5A                             //AFIT8_demsharpm
	0x0F121E1E, //1E1E                  //70000A5C                             //AFIT8_sddd8a_iC
	0x0F120101, //0101                  //70000A5E                             //AFIT8_sddd8a_iC
	0x0F124B01, //3C01                  //70000A60                             //AFIT8_sddd8a_nC
	0x0F12494B, //5A3A                  //70000A62                             //AFIT8_sddd8a_Di
	0x0F125044, //2858                  //70000A64                             //AFIT8_sddd8a_iD
	0x0F120500, //0A00                  //70000A66                             //AFIT8_Demosaici
	0x0F124603, //0003                  //70000A68                             //AFIT8_Demosaici
	0x0F120D03, //1E00                  //70000A6A                             //AFIT8_Demosaici
	0x0F12071E, //0714                  //70000A6C                             //AFIT8_Demosaici
	0x0F121432, //32FF                  //70000A6E                             //AFIT8_Demosaici
	0x0F126A01, //0004                  //70000A70                             //AFIT8_Demosaici
	0x0F12281E, //0F00                  //70000A72                             //AFIT8_Sharpenin
	0x0F12200F, //400F                  //70000A74                             //AFIT8_Sharpenin
	0x0F120204, //0204                  //70000A76                             //AFIT8_Sharpenin
	0x0F120003, //0003                  //70000A78                             //AFIT8_demsharpm
	0x0F120001, //0001                  //70000A7A
	0x0F120000, //0000                  //70000A7C                  //AFIT16_BRIGHTNESS
	0x0F120000, //0000                  //70000A7E                             //AFIT16_CONTRAST
	0x0F120000, //0000                  //70000A80                             //AFIT16_SATURATI
	0x0F120000, //0000                  //70000A82                             //AFIT16_SHARP_BL
	0x0F120000, //0000                  //70000A84                             //AFIT16_GLAMOUR
	0x0F1200C1, //00C1                  //70000A86                             //AFIT16_sddd8a_e
	0x0F120000, //0000                  //70000A88
	0x0F1203FF, //03FF                  //70000A8A                             //AFIT16_Demosaic
	0x0F12009E, //009E                  //70000A8C                             //AFIT16_Sharpeni
	0x0F12017C, //017C                  //70000A8E                             //AFIT16_demsharp
	0x0F1203FF, //03FF                  //70000A90                             //AFIT16_demsharp
	0x0F12000C, //000C                  //70000A92                             //AFIT16_demsharp
	0x0F120010, //0010                  //70000A94                             //AFIT16_demsharp
	0x0F12012C, //012C                  //70000A96                             //AFIT16_demsharp
	0x0F1203E8, //03E8                  //70000A98                             //AFIT16_demsharp
	0x0F120046, //0046                  //70000A9A                             //AFIT16_demsharp
	0x0F12005A, //005A                  //70000A9C                             //AFIT16_demsharp
	0x0F120070, //0070                  //70000A9E                             //AFIT16_demsharp
	0x0F120001, //0001                  //70000AA0                  //AFIT16_demsharpmix1_iHystT
	0x0F120000, //0000                  //70000AA2                  //AFIT16_demsharpmix1_iHystT
	0x0F120320, //0320                  //70000AA4                  //AFIT16_demsharpmix1_iHystC
	0x0F12008C, //008C                  //70000AA6                             //AFIT16_Sharpeni
	0x0F120014, //0014                  //70000AA8                             //AFIT16_Sharpeni
	0x0F12008C, //003C                  //70000AAA                             //AFIT16_Sharpeni
	0x0F120014, //001E                  //70000AAC                             //AFIT16_Sharpeni
	0x0F12008C, //003C                  //70000AAE                             //AFIT16_Sharpeni
	0x0F120014, //001E                  //70000AB0                             //AFIT16_Sharpeni
	0x0F120A24, //0A24                  //70000AB2                             //AFIT8_sddd8a_ed
	0x0F121701, //1701                  //70000AB4                             //AFIT8_sddd8a_re
	0x0F120229, //0229                  //70000AB6                             //AFIT8_sddd8a_sa
	0x0F121403, //1403                  //70000AB8                             //AFIT8_sddd8a_sa
	0x0F120004, //0004                  //70000ABA                             //AFIT8_sddd8a_iH
	0x0F120300, //0300                  //70000ABC                             //AFIT8_sddd8a_iC
	0x0F120000, //0000                  //70000ABE                             //AFIT8_sddd8a_Ad
	0x0F1202FF, //02FF                  //70000AC0                             //AFIT8_sddd8a_iS
	0x0F1205DE, //05DE                  //70000AC2                             //AFIT8_sddd8a_iR
	0x0F121414, //1414                  //70000AC4                             //AFIT8_sddd8a_iL
	0x0F120301, //0301                  //70000AC6                             //AFIT8_sddd8a_iL
	0x0F120007, //0007                  //70000AC8                             //AFIT8_sddd8a_iS
	0x0F121000, //1000                  //70000ACA
	0x0F122803, //2803                  //70000ACC
	0x0F12261E, //261E                  //70000ACE
	0x0F120026, //0026                  //70000AD0
	0x0F121E80, //1E80                  //70000AD2                             //AFIT8_Demosaici
	0x0F121E08, //1E08                  //70000AD4                             //AFIT8_Demosaici
	0x0F12010A, //010A                  //70000AD6                             //AFIT8_Demosaici
	0x0F120001, //0001                  //70000AD8                             //AFIT8_Demosaici
	0x0F124C0A, //3C0A                  //70000ADA                             //AFIT8_Demosaici
	0x0F122B12, //2300                  //70000ADC                             //AFIT8_Sharpenin
	0x0F120207, //0200                  //70000ADE                             //AFIT8_Sharpenin
	0x0F12FF00, //FF00                  //70000AE0                             //AFIT8_Sharpenin
	0x0F120200, //0200                  //70000AE2                             //AFIT8_demsharpm
	0x0F121B11, //1B11                  //70000AE4                             //AFIT8_demsharpm
	0x0F120000, //0000                  //70000AE6                             //AFIT8_demsharpm
	0x0F120009, //0009                  //70000AE8                             //AFIT8_demsharpm
	0x0F120406, //0406                  //70000AEA                             //AFIT8_demsharpm
	0x0F120605, //0605                  //70000AEC                             //AFIT8_demsharpm
	0x0F120307, //0307                  //70000AEE
	0x0F120609, //0609                  //70000AF0
	0x0F121C07, //1C07                  //70000AF2
	0x0F121014, //1014                  //70000AF4
	0x0F120510, //0510                  //70000AF6                  //[15:8]iUVNRStrengthL [7:0]
	0x0F128005, //8005                  //70000AF8                  //[7:0]iUVNRStrengthH AFIT8_
	0x0F120080, //0080                  //70000AFA                             //AFIT8_RGBGamma2
	0x0F120080, //0080                  //70000AFC                             //AFIT8_ccm_oscar
	0x0F120080, //0080                  //70000AFE                             //AFIT8_RGB2YUV_i
	0x0F120101, //0101                  //70000B00                             //AFIT8_sddd8a_iC
	0x0F120707, //0707                  //70000B02                             //AFIT8_sddd8a_iC
	0x0F124B01, //4B01                  //70000B04                             //AFIT8_sddd8a_nC
	0x0F12144B, //2A4B                  //70000B06                             //AFIT8_sddd8a_Di
	0x0F125014, //5020                  //70000B08                             //AFIT8_sddd8a_iD
	0x0F120500, //0500                  //70000B0A                             //AFIT8_Demosaici
	0x0F121B03, //1C03                  //70000B0C                             //AFIT8_Demosaici
	0x0F123003, //0D0C                  //70000B0E                             //AFIT8_Demosaici
	0x0F120823, //0823                  //70000B10                             //AFIT8_Demosaici
	0x0F121428, //1428                  //70000B12                             //AFIT8_Demosaici
	0x0F128601, //6401                  //70000B14                             //AFIT8_Demosaici
	0x0F12283E, //282D                  //70000B16                             //AFIT8_Sharpenin
	0x0F122012, //2012                  //70000B18                             //AFIT8_Sharpenin
	0x0F120204, //0204                  //70000B1A                             //AFIT8_Sharpenin
	0x0F120103, //2803                  //70000B1C                             //AFIT8_demsharpm
	0x0F120701, //0128                  //70000B1E                             //AFIT8_sddd8a_iC
	0x0F120101, //0101                  //70000B20                             //AFIT8_sddd8a_iC
	0x0F124B4B, //2224                  //70000B22                             //AFIT8_sddd8a_Di
	0x0F120000, //3236                  //70000B24                             //AFIT8_sddd8a_iD
	0x0F120050, //0028                  //70000B26                             //AFIT8_Demosaici
	0x0F120305, //030A                  //70000B28                             //AFIT8_Demosaici
	0x0F120C5C, //0410                  //70000B2A                             //AFIT8_Demosaici
	0x0F12230D, //141E                  //70000B2C                             //AFIT8_Demosaici
	0x0F122807, //FF07                  //70000B2E                             //AFIT8_Demosaici
	0x0F120114, //0432                  //70000B30                             //AFIT8_Demosaici
	0x0F122D74, //4050                  //70000B32                             //AFIT8_Sharpenin
	0x0F120908, //0F0F                  //70000B34                             //AFIT8_Sharpenin
	0x0F120420, //0440                  //70000B36                             //AFIT8_Sharpenin
	0x0F120302, //0302                  //70000B38                             //AFIT8_demsharpm
	0x0F122828, //2828                  //70000B3A                             //AFIT8_sddd8a_iC
	0x0F120101, //0101                  //70000B3C                             //AFIT8_sddd8a_iC
	0x0F124B01, //2401                  //70000B3E                             //AFIT8_sddd8a_nC
	0x0F12004B, //3622                  //70000B40                             //AFIT8_sddd8a_Di
	0x0F125000, //2832                  //70000B42                             //AFIT8_sddd8a_iD
	0x0F120500, //0A00                  //70000B44                             //AFIT8_Demosaici
	0x0F125C03, //1003                  //70000B46                             //AFIT8_Demosaici
	0x0F120D0C, //1E04                  //70000B48                             //AFIT8_Demosaici
	0x0F120823, //0714                  //70000B4A                             //AFIT8_Demosaici
	0x0F121428, //32FF                  //70000B4C                             //AFIT8_Demosaici
	0x0F127401, //5004                  //70000B4E                             //AFIT8_Demosaici
	0x0F12082D, //0F40                  //70000B50                             //AFIT8_Sharpenin
	0x0F122009, //400F                  //70000B52                             //AFIT8_Sharpenin
	0x0F120204, //0204                  //70000B54                             //AFIT8_Sharpenin
	0x0F120003, //0003                  //70000B56                             //AFIT8_demsharpm
	0x0F120001, //0001                  //70000B58
	0x0F120000, //0000                  //70000B5A                  //AFIT16_BRIGHTNESS
	0x0F120000, //0000                  //70000B5C                             //AFIT16_CONTRAST
	0x0F120000, //0000                  //70000B5E                             //AFIT16_SATURATI
	0x0F120000, //0000                  //70000B60                             //AFIT16_SHARP_BL
	0x0F120000, //0000                  //70000B62                             //AFIT16_GLAMOUR
	0x0F1200C1, //00C1                  //70000B64                             //AFIT16_sddd8a_e
	0x0F120000, //0000                  //70000B66
	0x0F1203FF, //03FF                  //70000B68                             //AFIT16_Demosaic
	0x0F12009E, //009E                  //70000B6A                             //AFIT16_Sharpeni
	0x0F12017C, //017C                  //70000B6C                             //AFIT16_demsharp
	0x0F1203FF, //03FF                  //70000B6E                             //AFIT16_demsharp
	0x0F12000C, //000C                  //70000B70                             //AFIT16_demsharp
	0x0F120010, //0010                  //70000B72                             //AFIT16_demsharp
	0x0F1200C8, //00C8                  //70000B74                             //AFIT16_demsharp
	0x0F1203E8, //03E8                  //70000B76                             //AFIT16_demsharp
	0x0F120046, //0046                  //70000B78                             //AFIT16_demsharp
	0x0F120050, //0050                  //70000B7A                             //AFIT16_demsharp
	0x0F120070, //0070                  //70000B7C                             //AFIT16_demsharp
	0x0F120001, //0001                  //70000B7E                  //AFIT16_demsharpmix1_iHystT
	0x0F120000, //0000                  //70000B80                  //AFIT16_demsharpmix1_iHystT
	0x0F120320, //0320                  //70000B82                  //AFIT16_demsharpmix1_iHystC
	0x0F12008C, //008C                  //70000B84                             //AFIT16_Sharpeni
	0x0F120014, //0014                  //70000B86                             //AFIT16_Sharpeni
	0x0F12008C, //002D                  //70000B88                             //AFIT16_Sharpeni
	0x0F120014, //0019                  //70000B8A                             //AFIT16_Sharpeni
	0x0F12008C, //002D                  //70000B8C                             //AFIT16_Sharpeni
	0x0F120014, //0019                  //70000B8E                             //AFIT16_Sharpeni
	0x0F120A24, //0A24                  //70000B90                             //AFIT8_sddd8a_ed
	0x0F121701, //1701                  //70000B92                             //AFIT8_sddd8a_re
	0x0F120229, //0229                  //70000B94                             //AFIT8_sddd8a_sa
	0x0F121403, //1403                  //70000B96                             //AFIT8_sddd8a_sa
	0x0F120004, //0004                  //70000B98                             //AFIT8_sddd8a_iH
	0x0F120300, //0300                  //70000B9A                             //AFIT8_sddd8a_iC
	0x0F120000, //0000                  //70000B9C                             //AFIT8_sddd8a_Ad
	0x0F1202FF, //02FF                  //70000B9E                             //AFIT8_sddd8a_iS
	0x0F1205DE, //05DE                  //70000BA0                             //AFIT8_sddd8a_iR
	0x0F121414, //1414                  //70000BA2                             //AFIT8_sddd8a_iL
	0x0F120301, //0301                  //70000BA4                             //AFIT8_sddd8a_iL
	0x0F120007, //0007                  //70000BA6                             //AFIT8_sddd8a_iS
	0x0F121000, //1000                  //70000BA8
	0x0F122303, //2303                  //70000BAA
	0x0F12231A, //231A                  //70000BAC
	0x0F120023, //0023                  //70000BAE
	0x0F121E80, //1E80                  //70000BB0                             //AFIT8_Demosaici
	0x0F121E08, //1E08                  //70000BB2                             //AFIT8_Demosaici
	0x0F12010A, //010A                  //70000BB4                             //AFIT8_Demosaici
	0x0F120001, //0001                  //70000BB6                             //AFIT8_Demosaici
	0x0F127D0A, //3C0A                  //70000BB8                             //AFIT8_Demosaici
	0x0F122C24, //2300                  //70000BBA                             //AFIT8_Sharpenin
	0x0F120207, //0200                  //70000BBC                             //AFIT8_Sharpenin
	0x0F12FF00, //FF00                  //70000BBE                             //AFIT8_Sharpenin
	0x0F120200, //0200                  //70000BC0                             //AFIT8_demsharpm
	0x0F121E10, //1E10                  //70000BC2                             //AFIT8_demsharpm
	0x0F120000, //0000                  //70000BC4                             //AFIT8_demsharpm
	0x0F120009, //0009                  //70000BC6                             //AFIT8_demsharpm
	0x0F120406, //0406                  //70000BC8                             //AFIT8_demsharpm
	0x0F120705, //0705                  //70000BCA                             //AFIT8_demsharpm
	0x0F120306, //0306                  //70000BCC
	0x0F120509, //0509                  //70000BCE
	0x0F122806, //2806                  //70000BD0
	0x0F121428, //1428                  //70000BD2
	0x0F120518, //0518                  //70000BD4                  //[15:8]iUVNRStrengthL [7:0]
	0x0F128005, //8005                  //70000BD6                  //[7:0]iUVNRStrengthH AFIT8_
	0x0F120080, //0080                  //70000BD8                             //AFIT8_RGBGamma2
	0x0F120080, //0080                  //70000BDA                             //AFIT8_ccm_oscar
	0x0F120080, //0080                  //70000BDC                             //AFIT8_RGB2YUV_i
	0x0F120101, //0101                  //70000BDE                             //AFIT8_sddd8a_iC
	0x0F120707, //0707                  //70000BE0                             //AFIT8_sddd8a_iC
	0x0F124B01, //4B01                  //70000BE2                             //AFIT8_sddd8a_nC
	0x0F12144B, //2A4B                  //70000BE4                             //AFIT8_sddd8a_Di
	0x0F125014, //5020                  //70000BE6                             //AFIT8_sddd8a_iD
	0x0F120500, //0500                  //70000BE8                             //AFIT8_Demosaici
	0x0F122B03, //1C03                  //70000BEA                             //AFIT8_Demosaici
	0x0F126303, //0D0C                  //70000BEC                             //AFIT8_Demosaici
	0x0F120823, //0823                  //70000BEE                             //AFIT8_Demosaici
	0x0F121428, //1428                  //70000BF0                             //AFIT8_Demosaici
	0x0F12CC01, //6401                  //70000BF2                             //AFIT8_Demosaici
	0x0F12283E, //282D                  //70000BF4                             //AFIT8_Sharpenin
	0x0F122012, //2012                  //70000BF6                             //AFIT8_Sharpenin
	0x0F120204, //0204                  //70000BF8                             //AFIT8_Sharpenin
	0x0F120103, //3C03                  //70000BFA                             //AFIT8_demsharpm
	0x0F120701, //013C                  //70000BFC                             //AFIT8_sddd8a_iC
	0x0F120101, //0101                  //70000BFE                             //AFIT8_sddd8a_iC
	0x0F124B4B, //1C1E                  //70000C00                             //AFIT8_sddd8a_Di
	0x0F120000, //1E22                  //70000C02                             //AFIT8_sddd8a_iD
	0x0F120050, //0028                  //70000C04                             //AFIT8_Demosaici
	0x0F120305, //030A                  //70000C06                             //AFIT8_Demosaici
	0x0F120C5C, //0214                  //70000C08                             //AFIT8_Demosaici
	0x0F12230D, //0E14                  //70000C0A                             //AFIT8_Demosaici
	0x0F122808, //FF06                  //70000C0C                             //AFIT8_Demosaici
	0x0F120114, //0432                  //70000C0E                             //AFIT8_Demosaici
	0x0F122D74, //4052                  //70000C10                             //AFIT8_Sharpenin
	0x0F120908, //150C                  //70000C12                             //AFIT8_Sharpenin
	0x0F120420, //0440                  //70000C14                             //AFIT8_Sharpenin
	0x0F120302, //0302                  //70000C16                             //AFIT8_demsharpm
	0x0F123C3C, //3C3C                  //70000C18                             //AFIT8_sddd8a_iC
	0x0F120101, //0101                  //70000C1A                             //AFIT8_sddd8a_iC
	0x0F124B01, //1E01                  //70000C1C                             //AFIT8_sddd8a_nC
	0x0F12004B, //221C                  //70000C1E                             //AFIT8_sddd8a_Di
	0x0F125000, //281E                  //70000C20                             //AFIT8_sddd8a_iD
	0x0F120500, //0A00                  //70000C22                             //AFIT8_Demosaici
	0x0F125C03, //1403                  //70000C24                             //AFIT8_Demosaici
	0x0F120D0C, //1402                  //70000C26                             //AFIT8_Demosaici
	0x0F120823, //060E                  //70000C28                             //AFIT8_Demosaici
	0x0F121428, //32FF                  //70000C2A                             //AFIT8_Demosaici
	0x0F127401, //5204                  //70000C2C                             //AFIT8_Demosaici
	0x0F12082D, //0C40                  //70000C2E                             //AFIT8_Sharpenin
	0x0F122009, //4015                  //70000C30                             //AFIT8_Sharpenin
	0x0F120204, //0204                  //70000C32                             //AFIT8_Sharpenin
	0x0F120003, //0003                  //70000C34                             //AFIT8_demsharpm
	0x0F120001, //0001                  //70000C36
	0x0F120000, //0000                  //0000                  //70000C38                  //AF
	0x0F120000, //0000                  //0000                  //70000C3A                  //AF
	0x0F120000, //0000                  //0000                  //70000C3C                  //AF
	0x0F120000, //0000                  //0000                  //70000C3E                  //AF
	0x0F120000, //0000                  //0000                  //70000C40                  //AF
	0x0F1200C1, //00C1                  //00C1                  //70000C42                  //AF
	0x0F120000, //0000                  //0000                  //70000C44
	0x0F1203FF, //03FF                  //03FF                  //70000C46                  //AF
	0x0F12009C, //009C                  //0008                  //70000C48                  //AF
	0x0F120251, //0251                  //017C                  //70000C4A                  //AF
	0x0F1203FF, //03FF                  //03FF                  //70000C4C                  //AF
	0x0F12000C, //000C                  //000C                  //70000C4E                  //AF
	0x0F120010, //0010                  //0010                  //70000C50                  //AF
	0x0F120032, //0032                  //0032                  //70000C52                  //AF
	0x0F12028A, //028A                  //028A                  //70000C54                  //AF
	0x0F120032, //0032                  //0032                  //70000C56                  //AF
	0x0F1201F4, //01F4                  //01F4                  //70000C58                  //AF
	0x0F120070, //0070                  //0070                  //70000C5A                  //AF
	0x0F120002, //0002                  //0002                  //70000C5C                  //AF
	0x0F120000, //0000                  //0000                  //70000C5E                  //AF
	0x0F120320, //0320                  //0320                  //70000C60                  //AF
	0x0F120044, //0044                  //0070                  //70000C62                  //AF
	0x0F120014, //0014                  //0014                  //70000C64                  //AF
	0x0F120044, //0046                  //0046                  //70000C66                  //AF
	0x0F120014, //0019                  //0019                  //70000C68                  //AF
	0x0F120044, //0046                  //0046                  //70000C6A                  //AF
	0x0F120014, //0019                  //0019                  //70000C6C                  //AF
	0x0F120A24, //0A24                  //0A24                  //70000C6E                  //AF
	0x0F121701, //1701                  //1701                  //70000C70                  //AF
	0x0F120229, //0229                  //0229                  //70000C72                  //AF
	0x0F120503, //0503                  //0503                  //70000C74                  //AF
	0x0F12080F, //080F                  //0101                  //70000C76                  //AF
	0x0F120808, //0808                  //0101                  //70000C78                  //AF
	0x0F120000, //0000                  //0000                  //70000C7A                  //AF
	0x0F1200FF, //00FF                  //02FF                  //70000C7C                  //AF
	0x0F12012D, //012D                  //0396                  //70000C7E                  //AF
	0x0F121414, //1414                  //1414                  //70000C80                  //AF
	0x0F120301, //0301                  //0301                  //70000C82                  //AF
	0x0F120007, //0007                  //0007                  //70000C84                  //AF
	0x0F121000, //1000                  //1000                  //70000C86
	0x0F122003, //2003                  //2003                  //70000C88
	0x0F121020, //1020                  //1020                  //70000C8A
	0x0F120010, //0010                  //0010                  //70000C8C
	0x0F121EFF, //1EFF                  //1E80                  //70000C8E                  //AF
	0x0F121E06, //1E06                  //1E06                  //70000C90                  //AF
	0x0F12060A, //060A                  //030C                  //70000C92                  //AF
	0x0F120306, //0306                  //0103                  //70000C94                  //AF
	0x0F12810A, //8B0A                  //5A0A                  //70000C96                  //AF
	0x0F1215C4, //2837                  //2D00                  //70000C98                  //AF
	0x0F120107, //0110                  //0100                  //70000C9A                  //AF
	0x0F12FF00, //FF00                  //FF00                  //70000C9C                  //AF
	0x0F120200, //0200                  //0200                  //70000C9E                  //AF
	0x0F121E10, //1E10                  //1E10                  //70000CA0                  //AF
	0x0F120000, //0000                  //0000                  //70000CA2                  //AF
	0x0F120009, //0009                  //0009                  //70000CA4                  //AF
	0x0F120406, //0406                  //0406                  //70000CA6                  //AF
	0x0F120705, //0705                  //0705                  //70000CA8                  //AF
	0x0F120305, //0305                  //0305                  //70000CAA
	0x0F120609, //0609                  //0609                  //70000CAC
	0x0F122C07, //2C07                  //2C07                  //70000CAE
	0x0F12142C, //142C                  //142C                  //70000CB0
	0x0F120B18, //0B18                  //0B18                  //70000CB2                  //[1
	0x0F12800B, //800B                  //800B                  //70000CB4                  //[7
	0x0F120080, //0080                  //0080                  //70000CB6                  //AF
	0x0F120080, //0080                  //0080                  //70000CB8                  //AF
	0x0F120080, //0080                  //0080                  //70000CBA                  //AF
	0x0F125050, //5050                  //0101                  //70000CBC                  //AF
	0x0F120101, //0101                  //0A0A                  //70000CBE                  //AF
	0x0F123201, //3201                  //3201                  //70000CC0                  //AF
	0x0F120032, //1832                  //1428                  //70000CC2                  //AF
	0x0F122100, //210C                  //100C                  //70000CC4                  //AF
	0x0F120A00, //0A00                  //0500                  //70000CC6                  //AF
	0x0F125004, //1E04                  //1E02                  //70000CC8                  //AF
	0x0F12A400, //0A08                  //040C                  //70000CCA                  //AF
	0x0F12070C, //070C                  //0828                  //70000CCC                  //AF
	0x0F123264, //3264                  //5064                  //70000CCE                  //AF
	0x0F12F802, //5A02                  //4605                  //70000CD0                  //AF
	0x0F12103E, //1040                  //1E68                  //70000CD2                  //AF
	0x0F124012, //4012                  //201E                  //70000CD4                  //AF
	0x0F120604, //0604                  //0604                  //70000CD6                  //AF
	0x0F125006, //4606                  //4606                  //70000CD8                  //AF
	0x0F120150, //0146                  //0146                  //70000CDA                  //AF
	0x0F120101, //0101                  //0101                  //70000CDC                  //AF
	0x0F123232, //1C18                  //1C18                  //70000CDE                  //AF
	0x0F120000, //1819                  //1819                  //70000CE0                  //AF
	0x0F120021, //0028                  //0028                  //70000CE2                  //AF
	0x0F12040A, //030A                  //030A                  //70000CE4                  //AF
	0x0F12085E, //0514                  //0514                  //70000CE6                  //AF
	0x0F120C0A, //0C14                  //0C14                  //70000CE8                  //AF
	0x0F123207, //FF05                  //FF05                  //70000CEA                  //AF
	0x0F120119, //0432                  //0432                  //70000CEC                  //AF
	0x0F12406A, //4052                  //4052                  //70000CEE                  //AF
	0x0F120908, //1514                  //1514                  //70000CF0                  //AF
	0x0F120440, //0440                  //0440                  //70000CF2                  //AF
	0x0F120606, //0302                  //0302                  //70000CF4                  //AF
	0x0F124646, //4646                  //4646                  //70000CF6                  //AF
	0x0F120101, //0101                  //0101                  //70000CF8                  //AF
	0x0F123201, //1801                  //1801                  //70000CFA                  //AF
	0x0F120032, //191C                  //191C                  //70000CFC                  //AF
	0x0F122100, //2818                  //2818                  //70000CFE                  //AF
	0x0F120A00, //0A00                  //0A00                  //70000D00                  //AF
	0x0F125E04, //1403                  //1403                  //70000D02                  //AF
	0x0F120A08, //1405                  //1405                  //70000D04                  //AF
	0x0F12070C, //050C                  //050C                  //70000D06                  //AF
	0x0F121932, //32FF                  //32FF                  //70000D08                  //AF
	0x0F126A01, //5204                  //5204                  //70000D0A                  //AF
	0x0F120840, //1440                  //1440                  //70000D0C                  //AF
	0x0F124009, //4015                  //4015                  //70000D0E                  //AF
	0x0F120604, //0204                  //0204                  //70000D10                  //AF
	0x0F120006, //0003                  //0003                  //70000D12                  //AF
	0x0F120001, //0001                  //0001                  //70000D14

	0x0F12BA7A, //70000D16
	0x0F124FDE, //70000D18
	0x0F12137F, //70000D1A
	0x0F123BDE, //70000D1C
	0x0F12BF02, //70000D1E
	0x0F1200B5, //70000D20

	//===================================================================
	// Brightness setting
	//===================================================================
	0x002A1300,
	0x0F12019D,

	0x002A1306,
	0x0F120280,


	0x002a3fea,
	0x0f120800, //analog filter update Green


	/* TNP_Regs_bUseAccurateFR */
	/* 0x00287000, */
	/* 0x002A3FE4, */
	/* 0x0F120001, */ /* on/off TNP_Regs_bAccuDynamicFR */
	/* 0x0F1234A2, */ /* on/off TNP_Regs_usMinAccuDynamicFrTme */
	/* 0x0F1240FD, */ /* on/off TNP_Regs_usMaxAccuDynamicFrTme */
};

/* Return preview mode */
static const u32 s5k5ccgx_preview_return[] =  {
	0xFCFCD000,
	0x00287000,

	0x002A0C7E,
	0x0F120396, //70000C7E //AFIT8_sddd8a_iRadialLimit [7:0], AFIT8_sddd8a_iRadialPower [15:8]

	0x002A0CC4,
	0x0F12100C, //70000CC4	//AFIT8_sddd8a_iDenThreshHigh[7:0],   AFIT8_Demosaicing_iEdgeDesat [15:8]

	0x002A0836,
	0x0F123E00, //TVAR_ash_GASOutdoorAlpha_0_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_1_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_2_
	0x0F124000, //TVAR_ash_GASOutdoorAlpha_3_

	0x002A0D1E,
	0x0F122102, //70000D1E

	//PREVIEW
	0x002A0208,
	0x0F120000, //REG_TC_GP_ActivePrevConfig
	0x002A0210,
	0x0F120000, //REG_TC_GP_ActiveCapConfig
	0x002A020C,
	0x0F120001, //REG_TC_GP_PrevOpenAfterChange
	0x002A01F4,
	0x0F120001, //REG_TC_GP_NewConfigSync
	0x002A020A,
	0x0F120001, //REG_TC_GP_PrevConfigChanged
	0x002A0212,
	0x0F120001, //REG_TC_GP_CapConfigChanged
	0x002A01E8,
	0x0F120000, //REG_TC_GP_EnableCapture
	0x0F120001, //REG_TC_GP_EnableCaptureChanged
};

/* Not used */
static const u32 s5k5ccgx_highlight_snapshot[] = {
0xFCFCD000,
0x00287000,

0x002A0C7E,
0x0F12032D,	//70000C7E	//AFIT8_sddd8a_iRadialLimit [7:0], AFIT8_sddd8a_iRadialPower [15:8]

0x002A0CC4,
0x0F12210E,	//70000CC4	//AFIT8_sddd8a_iDenThreshHigh[7:0],   AFIT8_Demosaicing_iEdgeDesat [15:8]

0x002A0836,
0x0F123A00,	//TVAR_ash_GASOutdoorAlpha_0_
0x0F124000,	//TVAR_ash_GASOutdoorAlpha_1_
0x0F124000,	//TVAR_ash_GASOutdoorAlpha_2_
0x0F124000,	//TVAR_ash_GASOutdoorAlpha_3_

0x002A0D1E,
0x0F12A102,	//70000D1E

0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120001,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged

0xFFFF00A0,   //160ms
};

/* 2048x1536 capture (Capture config0) */
static const u32 s5k5ccgx_snapshot[] =
{
	0xFCFCD000,
	0x00287000,

	0x002A0D1E,
	0x0F12A102,	//70000D1E

	0x002A0210,
	0x0F120000,	//REG_TC_GP_ActiveCapConfig
	0x002A01F4,
	0x0F120001,	//REG_TC_GP_NewConfigSync
	0x002A0212,
	0x0F120001,	//REG_TC_GP_CapConfigChanged
	0x002A01E8,
	0x0F120001,	//REG_TC_GP_EnableCapture
	0x0F120001,	//REG_TC_GP_EnableCaptureChanged

	0xFFFF00A0,   //160ms
};

/* 640x480 capture (Capture config1) */
static const u32 s5k5ccgx_snapshot_vga[] = {
0xFCFCD000,
0x00287000,

0x002A0D1E,
0x0F12A102,	//70000D1E

0x002A0210,
0x0F120001,	//REG_TC_GP_ActiveCapConfig
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120001,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged

0xFFFF00A0,   //160ms
};

/* Not used */
static const u32 s5k5ccgx_lowlight_snapshot[] = {
0xFCFCD000,
0x00287000,

0x002A0D1E,
0x0F12A102,	//70000D1E

0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120001,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged

0xFFFF00A0,   //160ms
};

/* Not used */
static const u32 s5k5ccgx_lowlight_snapshot_off[] = {
};

/* Not used */
static const u32 s5k5ccgx_night_snapshot[] = {
0xFCFCD000,
0x00287000,

0x002A0D1E,
0x0F12A102,	//70000D1E

0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120001,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged

0xFFFF012C,   //300ms
};

/* Not used */
static const u32 s5k5ccgx_night_snapshot_off[] = {
};

/* Not used */
static const u32 s5k5ccgx_flash_normal_snapshot[] = {
0xFCFCD000,
0x00287000,
0x002A0D1E,
0x0F12A102,	//70000D1E
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120001,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

/* Not used */
static const u32 s5k5ccgx_flash_lowlight_snapshot[] = {
0xFCFCD000,
0x00287000,
0x002A0D1E,
0x0F12A102,	//70000D1E
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120001,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

/* For 2048x1152 cap */
static const u32 s5k5ccgx_change_wide_cap[] = {
//================================
// 17.Input Size Setting
//================================

0x00287000,
0x002A01F6,
0x0F120800,	//REG_TC_GP_PrevReqInputWidth //800h=2048d
0x0F120480,	//REG_TC_GP_PrevReqInputHeight //600h=1536d
0x0F120000,	//REG_TC_GP_PrevInputWidthOfs
0x0F1200C0,	//REG_TC_GP_PrevInputHeightOfs (600h-480h)/2
0x0F120800,	//REG_TC_GP_CapReqInputWidth //800h=2048d
0x0F120480,	//REG_TC_GP_CapReqInputHeight //600h=1536
0x0F120000,	//REG_TC_GP_CapInputWidthOfs
0x0F1200C0,	//REG_TC_GP_CapInputHeightOfs
0x002A0216,
0x0F120001,	//REG_TC_GP_bUseReqInputInPre
0x0F120001,	//REG_TC_GP_bUseReqInputInCap
0x002A043C,
0x0F120800,	//REG_TC_PZOOM_ZoomInputWidth //800h=2048d
0x0F120480,	//REG_TC_PZOOM_ZoomInputHeight //600h=1536
0x0F120000,	//REG_TC_PZOOM_ZoomInputWidthOfs
0x0F1200C0,	//REG_TC_PZOOM_ZoomInputHeightOfs

//================================
// 18.Preview & Capture Configration Setting
//================================

//Preview Config  10fps~30fps
0x002A023E,
0x0F120400,	//REG_0TC_PCFG_usWidth //280h=640d
0x0F120240,	//REG_0TC_PCFG_usHeight //1E0h=480d


//Capture Config 0  2048x1536 7.5~15fps
0x002A032E,
0x0F120000,	//REG_0TC_CCFG_uCaptureMode
0x0F120800,	//REG_0TC_CCFG_usWidth //800h=2048d
0x0F120480,	//REG_0TC_CCFG_usHeight //600h=1536d
};

#ifdef CONFIG_VIDEO_S5K5CCGX_P2
/* Wide capture 2048x1100 */
static const u32 s5k5ccgx_change_wide_cap_p2[] = {
//================================
// 17.Input Size Setting
//================================

0x00287000,
0x002A01F6,
0x0F120800,	//REG_TC_GP_PrevReqInputWidth //800h=2048d
0x0F12044C,	//REG_TC_GP_PrevReqInputHeight //600h=1536d
0x0F120000,	//REG_TC_GP_PrevInputWidthOfs
0x0F1200DA,	//REG_TC_GP_PrevInputHeightOfs (600h-480h)/2
0x0F120800,	//REG_TC_GP_CapReqInputWidth //800h=2048d
0x0F12044C,	//REG_TC_GP_CapReqInputHeight //600h=1536
0x0F120000,	//REG_TC_GP_CapInputWidthOfs
0x0F1200DA,	//REG_TC_GP_CapInputHeightOfs
0x002A0216,
0x0F120001,	//REG_TC_GP_bUseReqInputInPre
0x0F120001,	//REG_TC_GP_bUseReqInputInCap
0x002A043C,
0x0F120800,	//REG_TC_PZOOM_ZoomInputWidth //800h=2048d
0x0F12044C,	//REG_TC_PZOOM_ZoomInputHeight //600h=1536
0x0F120000,	//REG_TC_PZOOM_ZoomInputWidthOfs
0x0F1200DA,	//REG_TC_PZOOM_ZoomInputHeightOfs

//================================
// 18.Preview & Capture Configration Setting
//================================

//Preview Config  10fps~30fps
0x002A023E,
0x0F120400,	//REG_0TC_PCFG_usWidth //280h=640d
0x0F120226,	//REG_0TC_PCFG_usHeight //1E0h=480d


//Capture Config 0  2048x1536 7.5~15fps
0x002A032E,
0x0F120000,	//REG_0TC_CCFG_uCaptureMode
0x0F120800,	//REG_0TC_CCFG_usWidth //800h=2048d
0x0F12044C,	//REG_0TC_CCFG_usHeight //600h=1536d
};
#endif

/* To change Wide Capture to Normal Capture,
 * We have to restore capture configuration before starting Normal Capture.
 */
static const u32 s5k5ccgx_restore_capture_reg[] = {
//================================
// 17.Input Size Setting
//================================

0x00287000,
0x002A01F6,
0x0F120800,	//REG_TC_GP_PrevReqInputWidth //800h=2048d
0x0F120600,	//REG_TC_GP_PrevReqInputHeight //600h=1536d
0x0F120000,	//REG_TC_GP_PrevInputWidthOfs
0x0F120000,	//REG_TC_GP_PrevInputHeightOfs
0x0F120800,	//REG_TC_GP_CapReqInputWidth //800h=2048d
0x0F120600,	//REG_TC_GP_CapReqInputHeight //600h=1536
0x0F120000,	//REG_TC_GP_CapInputWidthOfs
0x0F120000,	//REG_TC_GP_CapInputHeightOfs
0x002A0216,
0x0F120001,	//REG_TC_GP_bUseReqInputInPre
0x0F120001,	//REG_TC_GP_bUseReqInputInCap
0x002A043C,
0x0F120800,	//REG_TC_PZOOM_ZoomInputWidth //800h=2048d
0x0F120600,	//REG_TC_PZOOM_ZoomInputHeight //600h=1536
0x0F120000,	//REG_TC_PZOOM_ZoomInputWidthOfs
0x0F120000,	//REG_TC_PZOOM_ZoomInputHeightOfs

//================================
// 18.Preview & Capture Configration Setting
//================================

//Preview Config  10fps~30fps
0x002A023E,
0x0F120400,	//REG_0TC_PCFG_usWidth //280h=640d
0x0F120300,	//REG_0TC_PCFG_usHeight //1E0h=480d


//Capture Config 0  2048x1536 7.5~15fps
0x002A032E,
0x0F120000,	//REG_0TC_CCFG_uCaptureMode
0x0F120800,	//REG_0TC_CCFG_usWidth //800h=2048d
0x0F120600,	//REG_0TC_CCFG_usHeight //600h=1536d
};

static const u32 s5k5ccgx_get_light_status[] = {
0xFCFCD000,
0x002C7000,
0x002E2A3C,
};

static const u32 s5k5ccgx_get_iso_reg[] = {
0xFCFCD000,
0x002C7000,
0x002E2A18,
};

static const u32 s5k5ccgx_get_shutterspeed_reg[] = {
0xFCFCD000,
0x002C7000,
0x002E2A14,
};

static const u32 s5k5ccgx_fps_auto[] = {
0x00287000,
0x002A025A,
0x0F1203E8, //REG_0TC_PCFG_usMaxFrTimeMsecMult10
0x0F12014E, //REG_0TC_PCFG_usMinFrTimeMsecMult10

/* DSLIM.
//PREVIEW
0x002A0208,
0x0F120000, //REG_TC_GP_ActivePrevConfig
0x002A020C,
0x0F120001, //REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001, //REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001, //REG_TC_GP_PrevConfigChanged
0x002A01E8,
0x0F120000, //REG_TC_GP_EnablePreview
0x0F120001, //REG_TC_GP_EnablePreviewChanged
*/
};

static const u32 s5k5ccgx_fps_15fix[] = {
0xFCFCD000,
0x00287000,
0x002A025A,
0x0F12029A,	//REG_0TC_PCFG_usMaxFrTimeMsecMult10	//max frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS
0x0F12029A,	//REG_0TC_PCFG_usMinFrTimeMsecMult10	//min frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS

/* DSLIM.
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
*/
};

static const u32 s5k5ccgx_fps_25fix[] = {
0xFCFCD000,
0x00287000,
0x002A025A,
0x0F120190, //14E,//REG_0TC_PCFG_usMaxFrTimeMsecMult10	//max frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS
0x0F120190, //14E,//REG_0TC_PCFG_usMinFrTimeMsecMult10	//min frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS


/* DSLIM.
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
*/
};


static const u32 s5k5ccgx_fps_30fix[] = {
0xFCFCD000,
0x00287000,
0x002A025A,
0x0F12014E,	//REG_0TC_PCFG_usMaxFrTimeMsecMult10	//max frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS
0x0F12014E,	//REG_0TC_PCFG_usMinFrTimeMsecMult10	//min frame time : 30fps 014D 15fps 029a; a6a - 3.75 fps; 0535 - 7.5FPS

/* DSLIM.
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
*/
};



/* effect off = normal */
static const u32 s5k5ccgx_effect_off[] = {
0xFCFCD000,
0x00287000,

0x002A0648,
0x0F120001,		//skl_af_bPregmOff	Pre/Post Gamma Off ()

0x002A01E2,
0x0F120000,		//REG_TC_GP_SpecialEffects	00:Normal Mode
};

static const u32 s5k5ccgx_effect_mono[] = {
0xFCFCD000,
0x00287000,
0x002A01E2,
0x0F120001,		//REG_TC_GP_SpecialEffects	01:Mono Mode
};

static const u32 s5k5ccgx_effect_sepia[] = {
0xFCFCD000,
0x00287000,
0x002A01E2,
0x0F120004,		//REG_TC_GP_SpecialEffects	04:Sepia Mode
};

static const u32 s5k5ccgx_effect_negative[] = {
0xFCFCD000,
0x00287000,
0x002A01E2,
0x0F120003,		//REG_TC_GP_SpecialEffects	03:Negative Mode
};

static const u32 s5k5ccgx_wb_auto[] = {
	0xFCFCD000,
	0x00287000,
	0x002A2A62,
	0x0F120001,		//Mon_AAIO_bAWB		AWB ON
};

static const u32 s5k5ccgx_wb_daylight[] = {
	0xFCFCD000,
	0x00287000,
	0x002A2A62,
	0x0F120000,		//Mon_AAIO_bAWB		AWB OFF

	0x002A0470,
	0x0F120620,		//REG_SF_USER_Rgain
	0x0F120001,		//REG_SF_USER_RgainChanged
	0x0F120400,		//REG_SF_USER_Ggain
	0x0F120001,		//REG_SF_USER_GgainChanged
	0x0F120540,		//REG_SF_USER_Bgain
	0x0F120001,		//REG_SF_USER_BgainChaged
};

static const u32 s5k5ccgx_wb_cloudy[] = {
	0xFCFCD000,
	0x00287000,
	0x002A2A62,
	0x0F120000,		//Mon_AAIO_bAWB		AWB OFF

	0x002A0470,
	0x0F1207B0,               //REG_SF_USER_Rgain
	0x0F120001,		//REG_SF_USER_RgainChanged
	0x0F120400,		//REG_SF_USER_Ggain
	0x0F120001,		//REG_SF_USER_GgainChanged
	0x0F1204A8,               //REG_SF_USER_Bgain
	0x0F120001,		//REG_SF_USER_BgainChaged
};

static const u32 s5k5ccgx_wb_fluorescent[] = {
	0xFCFCD000,
	0x00287000,
	0x002A2A62,
	0x0F120000,		//Mon_AAIO_bAWB		AWB OFF

	0x002A0470,
	0x0F120560,		//REG_SF_USER_Rgain
	0x0F120001,		//REG_SF_USER_RgainChanged
	0x0F120400,		//REG_SF_USER_Ggain
	0x0F120001,		//REG_SF_USER_GgainChanged
	0x0F1208A0,		//REG_SF_USER_Bgain
	0x0F120001,		//REG_SF_USER_BgainChaged
};

static const u32 s5k5ccgx_wb_incandescent[] = {
	0xFCFCD000,
	0x00287000,
	0x002A2A62,
	0x0F120000,		//Mon_AAIO_bAWB		AWB OFF

	0x002A0470,
	0x0F1203C0,		//REG_SF_USER_Rgain
	0x0F120001,		//REG_SF_USER_RgainChanged
	0x0F120400,		//REG_SF_USER_Ggain
	0x0F120001,		//REG_SF_USER_GgainChanged
	0x0F120980,		//REG_SF_USER_Bgain
	0x0F120001,		//REG_SF_USER_BgainChaged
};


static const u32 s5k5ccgx_brightness_m_4[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F12001A, //TVAR_ae_BrAve

};

static const u32 s5k5ccgx_brightness_m_3[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F12001F, //TVAR_ae_BrAve

};

static const u32 s5k5ccgx_brightness_m_2[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F120028, //TVAR_ae_BrAve

};

static const u32 s5k5ccgx_brightness_m_1[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F120032, //TVAR_ae_BrAve

};

static const u32 s5k5ccgx_brightness_0[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F12003E, //TVAR_ae_BrAve

};

static const u32 s5k5ccgx_brightness_p_1[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F12004A,//TVAR_ae_BrAves

};

static const u32 s5k5ccgx_brightness_p_2[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F120065,//TVAR_ae_BrAve

};

static const u32 s5k5ccgx_brightness_p_3[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F120075,//TVAR_ae_BrAve

};

static const u32 s5k5ccgx_brightness_p_4[] = {
0xFCFCD000,
0x00287000,

0x002A1308,
0x0F12008B,//TVAR_ae_BrAv

};

static const u32 s5k5ccgx_scene_off[] = {
// ==========================================================
//	CAMERA_SCENE_OFF
// ==========================================================
0xFCFCD000,
0x00287000,
0x002A2A62,
0x0F120001,		//Mon_AAIO_bAWB		0: AWB OFF, 1: AWB ON

// Center (Metering)
0xFCFCD000,
0x00287000,
0x002A1316,		//ae_WeightTbl_16

0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120201,
0x0F120102,
0x0F120101,
0x0F120101,
0x0F120202,
0x0F120202,
0x0F120101,
0x0F120101,
0x0F120202,
0x0F120202,
0x0F120101,
0x0F120201,
0x0F120202,
0x0F120202,
0x0F120102,
0x0F120201,
0x0F120202,
0x0F120202,
0x0F120102,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,

//	01. Portait / Landscape / Text / Fall Color Off

0x00287000,
0x002A1308,
0x0F12003E,		//TVAR_ae_BrAve
0x002A01D0,
0x0F120000,		//REG_TC_UserBrightness
0x0F120000,		//REG_TC_UserContrast
0x002A01D4,
0x0F120000,		//REG_TC_UserSaturation
0x0F120000,		//REG_TC_UserSharpBlur

//	02. Night / Firework Off
0x00287000,
0x002A025A,
0x0F1203E8,	//REG_0TC_PCFG_usMaxFrTimeMsecMult10
0x0F12014E,	//REG_0TC_PCFG_usMinFrTimeMsecMult10

0x002A034C,
0x0F120535,	//REG_0TC_CCFG_usMaxFrTimeMsecMult10
0x0F12029A,	//REG_0TC_CCFG_usMinFrTimeMsecMult10

//add ki 11.02.18
// SLOW AE
0x002A13F2,
0x0F120010,	// 0010 ae_GainIn_0_			//
0x0F120020,	// 0020	ae_GainIn_1_			//
0x0F120040,	// 0040	ae_GainIn_2_			//
0x0F120080,	// 0080	ae_GainIn_3_			//
0x0F120100,	// fix 0100	ae_GainIn_4_			//
0x0F120200,	// 0200	ae_GainIn_5_			//
0x0F120400,	// 0400	ae_GainIn_6_			//
0x0F120800,	// 0800	ae_GainIn_7_			//
0x0F122000,	// 2000	ae_GainIn_8_			//

0x0F120010,	//0050	// 0010	ae_GainOut_0_	p	//
0x0F120020,	//0070	// 0020	ae_GainOut_1_ p//
0x0F120040,	//00A0	// 0040	ae_GainOut_2_	p	//
0x0F120080,	//00D0	// 0080	ae_GainOut_3_	p	//
0x0F120100,	// fix 0100	ae_GainOut_4_		//
0x0F120200,	// 0200	ae_GainOut_5_		//
0x0F120400,	// 0400	ae_GainOut_6_		//
0x0F120800,	// 0800	ae_GainOut_7_		//
0x0F122000,	// 2000	ae_GainOut_8_		//


//AE_state
0x002A04EE,
0x0F12010E,      //#lt_uLimitHigh
0x0F1200F5,      //#lt_uLimitLow

0x00287000,
0x002A0504,
0x0F123415,		//lt_uMaxExp1		3415h = 13333d =  33.3325ms
0x002A0508,
0x0F12681F,		//lt_uMaxExp2		681Fh = 26655d =  66.6375ms
0x002A050C,
0x0F128227,		//lt_uMaxExp3		8227h = 33319d =  83.2975ms
0x002A0510,
0x0F12C350,		//lt_uMaxExp4		C350h = 50000d = 125.0000ms
0x0F120000,

0x002A0514,
0x0F123415,		//lt_uCapMaxExp1		3415h = 13333d =  33.3325ms
0x002A0518,
0x0F12681F,		//lt_uCapMaxExp2		681Fh = 26655d =  66.6375ms
0x002A051C,
0x0F128227,		//lt_uCapMaxExp3		8227h = 33319d =  83.2975ms
0x002A0520,
0x0F12C350,		//lt_uCapMaxExp4		C350h = 50000d = 125.0000ms
0x0F120000,

0x002A0524,
0x0F1201E0,		//lt_uMaxAnGain1
0x0F1201E0,		//lt_uMaxAnGain2
0x0F120300,		//lt_uMaxAnGain3
0x0F120840,		//lt_uMaxAnGain4

0x0F120100,		//lt_uMaxDigGain
0x0F128000,		//lt_uMaxTotGain

0x0F1201E0,		//lt_uCapMaxAnGain1
0x0F1201E0,		//lt_uCapMaxAnGain2
0x0F120300,		//lt_uCapMaxAnGain3
0x0F120710,		//lt_uCapMaxAnGain4

0x0F120100,		//lt_uCapMaxDigGain
0x0F128000,		//lt_uCapMaxTotGain

0x002A08E4,
0x0F120010,		//AFIT16_demsharpmix1_iHystThLow
0x0F120010,		//AFIT16_demsharpmix1_iHystThHigh
0x002A0940,
0x0F120B50,		//[15:8] AFIT8_RGB2YUV_iYOffset, [7:0] AFIT8_ccm_oscar_iSaturation


//	03. ISO Auto

0x002A04A4,
0x0F12067F,		//REG_TC_DBG_AutoAlgEnBits		Auto Algorithm Enable
0x002A048C,
0x0F120001,		//REG_SF_USER_FlickerQuant		0:No AFC, 1:50Hz, 2:60Hz
0x0F120001,		//REG_SF_USER_FlickerQuantChanged

0x002A05EA,
0x0F120100,		//lt_bUseSecISODgain

0x002A0486,
0x0F120000,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x002A048A,
0x0F120001,		//REG_SF_USER_IsoChanged

0x002A3302,
0x0F120000,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0D1E,
0x0F122102,	 //70000D1E

//PREVIEW
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

static const u32 s5k5ccgx_scene_portrait[] = {
// ==========================================================
//	CAMERA_SCENE_PORTRAIT (Auto/Center/Br0/Auto/Sharp-1/Sat0)
// ==========================================================
0xFCFCD000,
0x00287000,
0x002A01D0,
0x0F120000,		//REG_TC_UserBrightness
0x002A01D4,
0x0F120000,		//REG_TC_UserSaturation
0x0F12FFF6,		//REG_TC_UserSharpBlur
};

static const u32 s5k5ccgx_scene_landscape[] = {
// ==========================================================
//	CAMERA_SCENE_LANDSCAPE (Auto/Matrix/Br0/Auto/Sharp+1/Sat+1)
// ==========================================================
0xFCFCD000,
0x00287000,
0x002A01D0,
0x0F120000,		//REG_TC_UserBrightness
0x002A01D4,
0x0F12001E,		//REG_TC_UserSaturation
0x0F12000A,		//REG_TC_UserSharpBlur

0x002A1316,		//ae_WeightTbl_16

0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,



};

static const u32 s5k5ccgx_scene_sports[] = {
// ==========================================================
//  CAMERA_SCENE_SPORTS (Sport/Center/Br0/Auto/Sharp0/Sat0)
// ==========================================================
0xFCFCD000,
0x00287000,

0x002A04EE,
0x0F120112,		//lt_uLimitHigh
0x0F1200EE,		//lt_uLimitLow

0x002A0504,
0x0F120002, //3415  //lt_uMaxExp1  3415h = 13333d =  33.3325ms
0x002A0508,
0x0F120D05, //3415  //lt_uMaxExp2  3415h = 13333d =  33.3325ms
0x002A050C,
0x0F121A0A, //3415  //lt_uMaxExp3  3415h = 13333d =  33.3325ms
0x002A0510,
0x0F123415,  //lt_uMaxExp4  3415h = 13333d =  33.3325ms

0x002A0514,
0x0F120002, //3415  //lt_uCapMaxExp1  3415h = 13333d =  33.3325ms
0x002A0518,
0x0F120D05, //3415  //lt_uCapMaxExp2  3415h = 13333d =  33.3325ms
0x002A051C,
0x0F121A0A, //3415  //lt_uCapMaxExp3  3415h = 13333d =  33.3325ms
0x002A0520,
0x0F123415,  //lt_uCapMaxExp4  3415h = 13333d =  33.3325ms

0x002A0524,
0x0F120200, //lt_uMaxAnGain1
0x0F120200, //lt_uMaxAnGain2
0x0F120200, //lt_uMaxAnGain3
0x0F120200, //lt_uMaxAnGain4

0x0F120200, //lt_uMaxDigGain
0x0F128000, //lt_uMaxTotGain  Total-gain is limited by #lt_uMaxTotGain

0x0F120200, //lt_uCapMaxAnGain1
0x0F120200, //lt_uCapMaxAnGain2
0x0F120200, //lt_uCapMaxAnGain3
0x0F120200, //lt_uCapMaxAnGain4

0x0F120200, //lt_uCapMaxDigGain
0x0F128000, //lt_uCapMaxTotGain  Total-gain is limited by #lt_uMaxTotGain




// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,  //AFIT by Normalized Brightness Tunning Parameter

0x002A0D1E,
0x0F122102,

//Preview
0x002A0208,
0x0F120000, //REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000, //REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001, //REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001, //REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001, //REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001, //REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000, //REG_TC_GP_EnableCapture
0x0F120001, //REG_TC_GP_EnableCaptureChanged
};

static const u32 s5k5ccgx_scene_party[] = {
// ==========================================================
//	CAMERA_SCENE_PARTYINDOOR (ISO200/Center/Br0/Auto/Sharp0/Sat+1)
// ==========================================================
0xFCFCD000,
0x00287000,
0x002A01D0,
0x0F120000,		//REG_TC_UserBrightness
0x002A01D4,
0x0F12001E,		//REG_TC_UserSaturation
0x0F120000,		//REG_TC_UserSharpBlur


0x002A04EE,
0x0F120112,		//lt_uLimitHigh
0x0F1200EE,		//lt_uLimitLow

0x002A052C,
0x0F120200,		//lt_Dgain

0x002A05EA,
0x0F120220,		//lt_bUseSecISODgain

// ISO Gain
0x002A0486,
0x0F120003,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x0F120300,		//REG_SF_USER_IsoVal
0x0F120001,		//REG_SF_USER_IsoChanged

// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0D1E,
0x0F122102,	 //70000D1E

//PREVIEW
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

static const u32 s5k5ccgx_scene_beach[] = {
// ==========================================================
//	CAMERA_SCENE_BEACHSNOW (ISO50/Center/Br+1/Auto/Sharp0/Sat+1)
// ==========================================================

0xFCFCD000,
0x00287000,
0x002A01D0,
0x0F120020,		//REG_TC_UserBrightness
0x002A01D4,
0x0F12001E,		//REG_TC_UserSaturation
0x0F120000,		//REG_TC_UserSharpBlur

//ISO 50

0x002A0504,
0x0F12C350,		//lt_uMaxExp1		C350h = 50000d = 125.0000ms
0x002A0508,
0x0F12C350,		//lt_uMaxExp2		C350h = 50000d = 125.0000ms
0x002A050C,
0x0F12C350,		//lt_uMaxExp3		C350h = 50000d = 125.0000ms
0x002A0510,
0x0F12C350,		//lt_uMaxExp4		C350h = 50000d = 125.0000ms

0x002A0514,
0x0F12C350,		//lt_uCapMaxExp1		C350h = 50000d = 125.0000ms
0x002A0518,
0x0F12C350,		//lt_uCapMaxExp2		C350h = 50000d = 125.0000ms
0x002A051C,
0x0F12C350,		//lt_uCapMaxExp3		C350h = 50000d = 125.0000ms
0x002A0520,
0x0F12C350,		//lt_uCapMaxExp4		C350h = 50000d = 125.0000ms

0x002A05EA,
0x0F120150,		//lt_bUseSecISODgain

// ISO Gain
0x002A0486,
0x0F120003,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x0F120100,		//REG_SF_USER_IsoVal
0x0F120001,		//REG_SF_USER_IsoChanged

// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0D1E,
0x0F122102,	 //70000D1E

//PREVIEW
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

static const u32 s5k5ccgx_scene_sunset[] = {
// Use MWB Daylight
0xFCFCD000,
0x00287000,
0x002A2A62,
0x0F120000,		//Mon_AAIO_bAWB		AWB OFF

0x002A0470,
0x0F120600,		//REG_SF_USER_Rgain
0x0F120001,		//REG_SF_USER_RgainChanged
0x0F120400,		//REG_SF_USER_Ggain
0x0F120001,		//REG_SF_USER_GgainChanged
0x0F120526,		//REG_SF_USER_Bgain
0x0F120001,		//REG_SF_USER_BgainChaged
};

static const u32 s5k5ccgx_scene_dawn[] = {
// Use MWB CWF
0xFCFCD000,
0x00287000,
0x002A2A62,
0x0F120000,		//Mon_AAIO_bAWB		AWB OFF

0x002A0470,
0x0F120530,		//REG_SF_USER_Rgain
0x0F120001,		//REG_SF_USER_RgainChanged
0x0F120400,		//REG_SF_USER_Ggain
0x0F120001,		//REG_SF_USER_GgainChanged
0x0F1207E6,		//REG_SF_USER_Bgain
0x0F120001,		//REG_SF_USER_BgainChaged
};

static const u32 s5k5ccgx_scene_fall[] = {
0xFCFCD000,
0x00287000,
0x002A01D0,
0x0F120000,		//REG_TC_UserBrightness
0x002A01D4,
0x0F120032,		//REG_TC_UserSaturation
0x0F120000,		//REG_TC_UserSharpBlur

};

static const u32 s5k5ccgx_scene_nightshot[] = {
// ==========================================================
//	CAMERA_SCENE_NIGHT (Night/Center/Br0/Auto/Sharp0/Sat0)
// ==========================================================

0xFCFCD000,
0x00287000,

0x002A025A, // 0602 09C4(4fps)->0682(6fps)
0x0F120682,	//REG_0TC_PCFG_usMaxFrTimeMsecMult10

0x002A034C,
0x0F121388,	//REG_0TC_CCFG_usMaxFrTimeMsecMult10
0x0F121388,	//REG_0TC_CCFG_usMinFrTimeMsecMult10


0x002A0504,
0x0F123415,		//lt_uMaxExp1		3415h = 13333d =  33.3325ms
0x002A0508,
0x0F12681F,		//lt_uMaxExp2		681Fh = 26655d =  66.6375ms
0x002A050C,
0x0F128227,		//lt_uMaxExp3		8227h = 33319d =  83.2975ms
0x002A0510,
0x0F121A80,		//lt_uMaxExp4		00061A80h = 400000d =  1000ms
0x0F120006,

0x002A0514,
0x0F123415,		//lt_uCapMaxExp1		3415h = 13333d =  33.3325ms
0x002A0518,
0x0F12681F,		//lt_uCapMaxExp2		681Fh = 26655d =  66.6375ms
0x002A051C,
0x0F128227,		//lt_uCapMaxExp3		8227h = 33319d =  83.2975ms
0x002A0520,
0x0F121A80,		//lt_uCapMaxExp4		00061A80h = 400000d =  1000ms
0x0F120006,

0x002A0524,
0x0F1201D0,		//lt_uMaxAnGain1		0180h	= 0384d	= x1.5000
0x0F1201D0,		//lt_uMaxAnGain2		0180h	= 0384d	= x1.5000
0x0F1202C0,		//lt_uMaxAnGain3		0250h	= 0592d	= x2.3125
0x0F120B00,		//lt_uMaxAnGain4 0602 0800->0B00 0710h	= 1808d	= x7.0625

0x0F120100,		//lt_uMaxDigGain
0x0F128000,		//lt_uMaxTotGain

0x0F1201D0,		//lt_uCapMaxAnGain1		0180h	= 0384d	= x1.5000
0x0F1201D0,		//lt_uCapMaxAnGain2		0180h	= 0384d	= x1.5000
0x0F1202C0,		//lt_uCapMaxAnGain3		0250h	= 0592d	= x2.3125
0x0F120800,		//lt_uCapMaxAnGain4		0710h	= 1808d	= x7.0625

0x0F120100,		//lt_uCapMaxDigGain
0x0F128000,		//lt_uCapMaxTotGain

0x002A08E4,
0x0F120000,	//AFIT16_demsharpmix1_iHystThLow
0x0F120000,	//AFIT16_demsharpmix1_iHystThHigh
0x002A0940,
0x0F121080,	//[15:8] AFIT8_RGB2YUV_iYOffset, [7:0] AFIT8_ccm_oscar_iSaturation

0x002A0D1E,
0x0F122102,	 //70000D1E

//PREVIEW
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

static const u32 s5k5ccgx_scene_backlight[] = {
0xFCFCD000,
0x00287000,
0x002A1316,		//ae_WeightTbl_16

0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120101,
0x0F120101,
0x0F120000,
0x0F120000,
0x0F120f01,
0x0F12010f,
0x0F120000,
0x0F120000,
0x0F120f01,
0x0F12010f,
0x0F120000,
0x0F120000,
0x0F120101,
0x0F120101,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
};

/* Not Used */
static const u32 s5k5ccgx_scene_firework[] = {
// ==========================================================
//	CAMERA_SCENE_FIREWORK (ISO50/Center/Br0/Auto/Sharp0/Sat0)
// ==========================================================

0xFCFCD000,
0x00287000,

0x002A025A,
0x0F1209C4,	//REG_0TC_PCFG_usMaxFrTimeMsecMult10

0x002A034C,
0x0F122710,	//REG_0TC_CCFG_usMaxFrTimeMsecMult10
0x0F122710,	//REG_0TC_CCFG_usMinFrTimeMsecMult10


0x002A0504,
0x0F123415,		//lt_uMaxExp1		3415h = 13333d =  33.3325ms
0x002A0508,
0x0F12681F,		//lt_uMaxExp2		681Fh = 26655d =  66.6375ms
0x002A050C,
0x0F128227,		//lt_uMaxExp3		8227h = 33319d =  83.2975ms
0x002A0510,
0x0F121A80,		//lt_uMaxExp4		00061A80h = 400000d =  1000ms
0x0F120006,

0x002A0514,
0x0F123415,		//lt_uCapMaxExp1		3415h = 13333d =  33.3325ms
0x002A0518,
0x0F12681F,		//lt_uCapMaxExp2		681Fh = 26655d =  66.6375ms
0x002A051C,
0x0F128227,		//lt_uCapMaxExp3		8227h = 33319d =  83.2975ms
0x002A0520,
0x0F121A80,		//lt_uCapMaxExp4		00061A80h = 400000d =  1000ms
0x0F120006,

//ISO 50


0x002A05EA,
0x0F120150,		//lt_bUseSecISODgain

// ISO Gain
0x002A0486,
0x0F120003,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x0F120100,		//REG_SF_USER_IsoVal
0x0F120001,		//REG_SF_USER_IsoChanged

// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0D1E,
0x0F122102,	 //70000D1E

//PREVIEW
0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

static const u32 s5k5ccgx_scene_text[] = {
// ==========================================================
//	CAMERA_SCENE_TEXT (Auto/Center/Br0/Auto/Sharp+2/Sat0)
// ==========================================================
0xFCFCD000,
0x00287000,
0x002A01D0,
0x0F120000,		//REG_TC_UserBrightness
0x002A01D4,
0x0F120000,		//REG_TC_UserSaturation
0x0F120014,		//REG_TC_UserSharpBlur
};

static const u32 s5k5ccgx_scene_candle[] = {
// Use MWB Daylight
0xFCFCD000,
0x00287000,
0x002A2A62,
0x0F120000,		//Mon_AAIO_bAWB		AWB OFF

0x002A0470,
0x0F120600,		//REG_SF_USER_Rgain
0x0F120001,		//REG_SF_USER_RgainChanged
0x0F120400,		//REG_SF_USER_Ggain
0x0F120001,		//REG_SF_USER_GgainChanged
0x0F120526,		//REG_SF_USER_Bgain
0x0F120001,		//REG_SF_USER_BgainChaged
};


static const u32 s5k5ccgx_metering_normal[] = {
0xFCFCD000,
0x00287000,
0x002A1316,		//ae_WeightTbl_16

0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
};

static const u32 s5k5ccgx_metering_spot[] = {
0xFCFCD000,
0x00287000,
0x002A1316,		//ae_WeightTbl_16

0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120101,
0x0F120101,
0x0F120000,
0x0F120000,
0x0F120f01,
0x0F12010f,
0x0F120000,
0x0F120000,
0x0F120f01,
0x0F12010f,
0x0F120000,
0x0F120000,
0x0F120101,
0x0F120101,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
};


static const u32 s5k5ccgx_metering_center[] = {
0xFCFCD000,
0x00287000,
0x002A1316,		//ae_WeightTbl_16

0x0F120000,
0x0F120000,
0x0F120000,
0x0F120000,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120201,
0x0F120102,
0x0F120101,
0x0F120101,
0x0F120202,
0x0F120202,
0x0F120101,
0x0F120101,
0x0F120202,
0x0F120202,
0x0F120101,
0x0F120201,
0x0F120202,
0x0F120202,
0x0F120102,
0x0F120201,
0x0F120202,
0x0F120202,
0x0F120102,
0x0F120101,
0x0F120101,
0x0F120101,
0x0F120101,
};

/* Not used */
static const u32 s5k5ccgx_iso_auto[] = {
0xFCFCD000,
0x00287000,

//0002A167C,
//00F120000,		//senHal_ExpMinPixels

0x002A04A4,
0x0F12067F,		//REG_TC_DBG_AutoAlgEnBits		Auto Algorithm Enable
0x002A048C,
0x0F120001,		//REG_SF_USER_FlickerQuant		0:No AFC, 1:50Hz, 2:60Hz
0x0F120001,		//REG_SF_USER_FlickerQuantChanged

0x002A0504,
0x0F123415,		//lt_uMaxExp1		3415h = 13333d =  33.3325ms
0x002A0508,
0x0F12681F,		//lt_uMaxExp2		681Fh = 26655d =  66.6375ms
0x002A050C,
0x0F128227,		//lt_uMaxExp3		8227h = 33319d =  83.2975ms
0x002A0510,
0x0F12C350,		//lt_uMaxExp4		C350h = 50000d = 125.0000ms

0x002A0514,
0x0F123415,		//lt_uCapMaxExp1		3415h = 13333d =  33.3325ms
0x002A0518,
0x0F12681F,		//lt_uCapMaxExp2		681Fh = 26655d =  66.6375ms
0x002A051C,
0x0F128227,		//lt_uCapMaxExp3		8227h = 33319d =  83.2975ms
0x002A0520,
0x0F12C350,		//lt_uCapMaxExp4		C350h = 50000d = 125.0000ms

0x002A0486,
0x0F120000,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x002A048A,
0x0F120001,		//REG_SF_USER_IsoChanged

0x002A3302,
0x0F120000,		//AFIT by Normalized Brightness Tunning Parameter

//Preview
0x002A0208,
0x0F120000,		//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,		//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,		//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,		//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,		//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,		//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

/* Not used */
static const u32 s5k5ccgx_iso_50[] = {

	0xFCFCD000,
0x00287000,

//0002A167C,
//00F120000,		//senHal_ExpMinPixels

0x002A04A4,
0x0F12065F,		//REG_TC_DBG_AutoAlgEnBits		Auto Flicker Off
0x002A048C,
0x0F120001,		//REG_SF_USER_FlickerQuant		0:No AFC, 1:50Hz, 2:60Hz
0x0F120001,		//REG_SF_USER_FlickerQuantChanged

0x002A0504,
0x0F12C350,		//lt_uMaxExp1		C350h = 50000d = 125.0000ms
0x002A0508,
0x0F12C350,		//lt_uMaxExp2		C350h = 50000d = 125.0000ms
0x002A050C,
0x0F12C350,		//lt_uMaxExp3		C350h = 50000d = 125.0000ms
0x002A0510,
0x0F12C350,		//lt_uMaxExp4		C350h = 50000d = 125.0000ms

0x002A0514,
0x0F12C350,		//lt_uCapMaxExp1		C350h = 50000d = 125.0000ms
0x002A0518,
0x0F12C350,		//lt_uCapMaxExp2		C350h = 50000d = 125.0000ms
0x002A051C,
0x0F12C350,		//lt_uCapMaxExp3		C350h = 50000d = 125.0000ms
0x002A0520,
0x0F12C350,		//lt_uCapMaxExp4		C350h = 50000d = 125.0000ms

0x002A05EA,
0x0F120100,		//lt_bUseSecISODgain

// ISO Gain
0x002A0486,
0x0F120003,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x0F120100,		//REG_SF_USER_IsoVal
0x0F120001,		//REG_SF_USER_IsoChanged

// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

/* Not used */
static const u32 s5k5ccgx_iso_100[] = {
0xFCFCD000,
0x00287000,

//0002A167C,
//00F120000,		//senHal_ExpMinPixels

0x002A04A4,
0x0F12065F,		//REG_TC_DBG_AutoAlgEnBits		Auto Flicker Off
0x002A048C,
0x0F120001,		//REG_SF_USER_FlickerQuant		0:No AFC, 1:50Hz, 2:60Hz
0x0F120001,		//REG_SF_USER_FlickerQuantChanged

0x002A0504,
0x0F12C350,		//lt_uMaxExp1		C350h = 50000d = 125.0000ms
0x002A0508,
0x0F12C350,		//lt_uMaxExp2		C350h = 50000d = 125.0000ms
0x002A050C,
0x0F12C350,		//lt_uMaxExp3		C350h = 50000d = 125.0000ms
0x002A0510,
0x0F12C350,		//lt_uMaxExp4		C350h = 50000d = 125.0000ms

0x002A0514,
0x0F12C350,		//lt_uCapMaxExp1		C350h = 50000d = 125.0000ms
0x002A0518,
0x0F12C350,		//lt_uCapMaxExp2		C350h = 50000d = 125.0000ms
0x002A051C,
0x0F12C350,		//lt_uCapMaxExp3		C350h = 50000d = 125.0000ms
0x002A0520,
0x0F12C350,		//lt_uCapMaxExp4		C350h = 50000d = 125.0000ms

0x002A05EA,
0x0F120100,		//lt_bUseSecISODgain

// ISO Gain
0x002A0486,
0x0F120003,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x0F120200,		//REG_SF_USER_IsoVal
0x0F120001,		//REG_SF_USER_IsoChanged

// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

/* Not used */
static const u32 s5k5ccgx_iso_200[] = {
0xFCFCD000,
0x00287000,

//0002A167C,
//00F120000,		//senHal_ExpMinPixels

0x002A04A4,
0x0F12065F,		//REG_TC_DBG_AutoAlgEnBits		Auto Flicker Off
0x002A048C,
0x0F120001,		//REG_SF_USER_FlickerQuant		0:No AFC, 1:50Hz, 2:60Hz
0x0F120001,		//REG_SF_USER_FlickerQuantChanged

0x002A0504,
0x0F12C350,		//lt_uMaxExp1		C350h = 50000d = 125.0000ms
0x002A0508,
0x0F12C350,		//lt_uMaxExp2		C350h = 50000d = 125.0000ms
0x002A050C,
0x0F12C350,		//lt_uMaxExp3		C350h = 50000d = 125.0000ms
0x002A0510,
0x0F12C350,		//lt_uMaxExp4		C350h = 50000d = 125.0000ms

0x002A0514,
0x0F12C350,		//lt_uCapMaxExp1		C350h = 50000d = 125.0000ms
0x002A0518,
0x0F12C350,		//lt_uCapMaxExp2		C350h = 50000d = 125.0000ms
0x002A051C,
0x0F12C350,		//lt_uCapMaxExp3		C350h = 50000d = 125.0000ms
0x002A0520,
0x0F12C350,		//lt_uCapMaxExp4		C350h = 50000d = 125.0000ms

0x002A05EA,
0x0F120100,		//lt_bUseSecISODgain

// ISO Gain
0x002A0486,
0x0F120003,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x0F120400,		//REG_SF_USER_IsoVal
0x0F120001,		//REG_SF_USER_IsoChanged

// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

/* Not used */
static const u32 s5k5ccgx_iso_400[] = {
0xFCFCD000,
0x00287000,

//0002A167C,
//00F120000,		//senHal_ExpMinPixels

0x002A04A4,
0x0F12065F,		//REG_TC_DBG_AutoAlgEnBits		Auto Flicker Off
0x002A048C,
0x0F120001,		//REG_SF_USER_FlickerQuant		0:No AFC, 1:50Hz, 2:60Hz
0x0F120001,		//REG_SF_USER_FlickerQuantChanged

0x002A0504,
0x0F12C350,		//lt_uMaxExp1		C350h = 50000d = 125.0000ms
0x002A0508,
0x0F12C350,		//lt_uMaxExp2		C350h = 50000d = 125.0000ms
0x002A050C,
0x0F12C350,		//lt_uMaxExp3		C350h = 50000d = 125.0000ms
0x002A0510,
0x0F12C350,		//lt_uMaxExp4		C350h = 50000d = 125.0000ms

0x002A0514,
0x0F12C350,		//lt_uCapMaxExp1		C350h = 50000d = 125.0000ms
0x002A0518,
0x0F12C350,		//lt_uCapMaxExp2		C350h = 50000d = 125.0000ms
0x002A051C,
0x0F12C350,		//lt_uCapMaxExp3		C350h = 50000d = 125.0000ms
0x002A0520,
0x0F12C350,		//lt_uCapMaxExp4		C350h = 50000d = 125.0000ms

0x002A05EA,
0x0F120100,		//lt_bUseSecISODgain

// ISO Gain
0x002A0486,
0x0F120003,		//REG_SF_USER_IsoType		0:OFF 3:ISO
0x0F120800,		//REG_SF_USER_IsoVal
0x0F120001,		//REG_SF_USER_IsoChanged

// AFIT by Normalized Brightness Tuning parameter
0x002A3302,
0x0F120001,		//AFIT by Normalized Brightness Tunning Parameter

0x002A0208,
0x0F120000,	//REG_TC_GP_ActivePrevConfig
0x002A0210,
0x0F120000,	//REG_TC_GP_ActiveCapConfig
0x002A020C,
0x0F120001,	//REG_TC_GP_PrevOpenAfterChange
0x002A01F4,
0x0F120001,	//REG_TC_GP_NewConfigSync
0x002A020A,
0x0F120001,	//REG_TC_GP_PrevConfigChanged
0x002A0212,
0x0F120001,	//REG_TC_GP_CapConfigChanged
0x002A01E8,
0x0F120000,	//REG_TC_GP_EnableCapture
0x0F120001,	//REG_TC_GP_EnableCaptureChanged
};

static const u32 s5k5ccgx_ae_lock[] = {
0xFCFCD000,
0x00287000,
0x002A2A5A,
0x0F120000, //Mon_AAIO_bAE
};


static const u32 s5k5ccgx_awb_lock[] = {
0xFCFCD000,
0x00287000,
0x002A11D6,
0x0F12FFFF, //awbb_WpFilterMinThr
};


static const u32 s5k5ccgx_ae_unlock[] = {
0xFCFCD000,
0x00287000,
0x002A2A5A,
0x0F120001, //Mon_AAIO_bAE
};


static const u32 s5k5ccgx_awb_unlock[] = {
0xFCFCD000,
0x00287000,
0x002A11D6,
0x0F12001E, //awbb_WpFilterMinThr
};


static const u32 s5k5ccgx_af_abort[] = {
0xFCFCD000,
0x00287000,
0x002A0224,
0x0F120001,   // REG_TC_AF_AfCmd = 1, Abort A
};

static const u32 s5k5ccgx_af_off_reg[] = {
	0xFCFCD000,
	0x00287000,
	0x002A0226,
	0x0F120000,
	0xFFFF0049, /* 73 ms delay,  Min 1 frame delay */
	0x002A0224, /* write [7000 0226, REG_TC_AF_AfCmdParam] */
	0x0F120004, /* write lens position from 0000 to 00FF. 0000 means infinity and 00FF means macro.*/
	0xFFFF0118, /* 280ms Delay */
};

static const u32 s5k5ccgx_af_normal_on[] = {
	0xFCFCD000,
	0x00287000,
	0x002A0224,
	0x0F120004, /* write [7000 0224, REG_TC_AF_AfCmd] = 0004 , manual AF. */

	0x002A0226, /* write [7000 0226, REG_TC_AF_AfCmdParam] */
	0x0F120000, /* write lens position from 0000 to 00FF. 0000 means infinity and 00FF means macro. */

	0xFFFF0096, /* 150ms Delay */

	/* #af_search_usSingleAfFlags, 1040 : macro mode on,  2nd search off,
	1042 : macro mode on, 2nd search(fine search) on
	1000 : macro mode off, 2nd search off,
	1002 : macro mode off, 2nd search on */
	0x002A1494,
	0x0F121002,
};

static const u32 s5k5ccgx_af_night_normal_on[] = {
	0xFCFCD000,
	0x00287000,
	0x002A0224,
	0x0F120004, /* write [7000 0224, REG_TC_AF_AfCmd] = 0004 , manual AF. */

	0x002A0226, /* write [7000 0226, REG_TC_AF_AfCmdParam] */
	0x0F120000, /* write lens position from 0000 to 00FF. 0000 means infinity and 00FF means macro.*/

	0xFFFF00FA, /* 250ms Delay*/

	/* #af_search_usSingleAfFlags, 1040 : macro mode on,  2nd search off,
	1042 : macro mode on, 2nd search(fine search) on
	1000 : macro mode off, 2nd search off,
	1002 : macro mode off, 2nd search on */
	0x002A1494,
	0x0F121002,
};

static const u32 s5k5ccgx_af_macro_on[] = {
	0xFCFCD000,
	0x00287000,
	0x002A0224,
	0x0F120004, /* write [7000 0224, REG_TC_AF_AfCmd] = 0004 , manual AF. */

	0x002A0226, /* write [7000 0226, REG_TC_AF_AfCmdParam] */
	0x0F120095, /* write lens position from 0000 to 00FF. 0000 means infinity and 00FF means macro. */

	0xFFFF0096, /* 150ms Delay */

	/* #af_search_usSingleAfFlags, 1040 : macro mode on,  2nd search off,
	1042 : macro mode on, 2nd search(fine search) on
	1000 : macro mode off, 2nd search off,
	1002 : macro mode off, 2nd search on */

	0x002A1494,
	0x0F121042,

	/* when user use lens position 16(10h) -> lens position 0(00h)
	MSB 10 b means user uses #af_pos_usTable_16_ as start position.
	LSB 00 b means user uses #af_pos_usTable_0_ as end position
	refer to 5.3 macro mode setting.
	"#af_pos_usMacroStartEnd" is only used in macro AF condition.
	(normal AF doesn't use "#af_pos_usMacroStartEnd") */
	0x002A1426,
	0x0F121000, /* #af_pos_usMacroStartEn */
};

static const u32 s5k5ccgx_af_do[] = {
0xFCFCD000,
0x00287000,
0x002A0224,
0x0F120005,   // REG_TC_AF_AfCmd = 5, single A
};

static const u32 s5k5ccgx_720P_af_do[] = {
0xFCFCD000,
0x00287000,

/* set AF operation value for 720P */
0x002A0226,
0x0F120010, /* REG_TC_AF_AfParam */

/* 720P 1frame(50ms) delay  */
0xFFFF0032, /* 50ms Delay */

/* set AF start cmd value for 720P */
0x002A0224,
0x0F120006, /* REG_TC_AF_AfCmd = 5, single A */
};

static const u32 s5k5ccgx_1st_720P_af_do[] = {
0xFCFCD000,
0x00287000,

0xFFFF01F4, /* tuning point */

/* set AF operation value for 720P */
0x002A0226,
0x0F120010, /* REG_TC_AF_AfParam */

/* 720P 1frame(50ms) delay  */
0xFFFF0032, /* 50ms Delay */

/* set AF start cmd value for 720P */
0x002A0224,
0x0F120006, /* REG_TC_AF_AfCmd = 5, single A */
};

static const u32 s5k5ccgx_contrast_m_2[] = {
//0FCFCD000,
//000287000,
//0002A01D2,
//00F12FF80,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_contrast_m_1[] = {
//0FCFCD000,
//000287000,
//0002A01D2,
//00F12FFC0,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_contrast_0[] = {
//0FCFCD000,
//000287000,
//0002A01D2,
//00F120000,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_contrast_p_1[] = {
//0FCFCD000,
//000287000,
//0002A01D2,
//00F120040,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_contrast_p_2[] = {
//FCFCD000,
//00287000,
//002A01D2,
//0F120080,		//REG_TC_UserContrast
};


static const u32 s5k5ccgx_saturation_m_2[] = {
//FCFCD000,
//00287000,
//002A01D4,
//0F12FF80,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_saturation_m_1[] = {
//FCFCD000,
//00287000,
//002A01D4,
//0F12FFC0,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_saturation_0[] = {
//FCFCD000,
//00287000,
//002A01D4,
//0F120000,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_saturation_p_1[] = {
//FCFCD000,
//00287000,
//002A01D4,
//0F120040,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_saturation_p_2[] = {
//FCFCD000,
//00287000,
//002A01D4,
//0F12007E,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_sharpness_m_2[] = {
//FCFCD000,
//00287000,
//002A01D6,
//0F12FFC0,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_sharpness_m_1[] = {
//FCFCD000,
//00287000,
//002A01D6,
//0F12FFE0,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_sharpness_0[] = {
//FCFCD000,
//00287000,
//002A01D6,
//0F120000,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_sharpness_p_1[] = {
//FCFCD000,
//00287000,
//002A01D6,
//0F120005,		//REG_TC_UserContrast
};

static const u32 s5k5ccgx_sharpness_p_2[] = {
0xFCFCD000,
0x00287000,
0x002A01D6,
0x0F120010,		//REG_TC_UserContrast
};


static const u32 s5k5ccgx_dtp_on[] = {
0xFCFCD000,
0x0028D000,
0x002AB054,
0x0F120001,
};

static const u32 s5k5ccgx_dtp_off[] = {
0xFCFCD000,
0x0028D000,
0x002AB054,
0x0F120000,
};

static const u32 s5k5ccgx_pll_on[] = {
0xFCFCD000,
0x00287000,
0x002A0ED8,
0x0F120001,
};

static const u32 s5k5ccgx_pll_off[] = {
0xFCFCD000,
0x00287000,
0x002A0ED8,
0x0F120000,
};

static const u32 s5k5ccgx_preflash_start[] = {
0xFCFCD000,
0x00287000,
0x002A3F82,
0x0F120001,		// TNP_Regs_PreflashStart
};

static const u32 s5k5ccgx_preflash_end[] = {
0xFCFCD000,
0x00287000,
0x002A3F84,
0x0F120001,		// TNP_Regs_PreflashEnd
};

static const u32 s5k5ccgx_mainflash_start[] = {
0xFCFCD000,
0x00287000,
0x002A3F80,		//TNP_Regs_FastFlashAlg
0x0F120001,
};

static const u32 s5k5ccgx_mainflash_end[] = {
};

static const u32 s5k5ccgx_flash_ae_set[] = {
0xFCFCD000,
0x00287000,
0x002A0500,
0x0F120000,
};

static const u32 s5k5ccgx_flash_ae_clear[] = {
0xFCFCD000,
0x00287000,
0x002A0500,
0x0F120002,
};

static const u32 s5k5ccgx_get_ae_stable_reg[] = {
0xFCFCD000,
0x002C7000,
0x002E1E3C,
};

static const u32 s5k5ccgx_get_esd_reg[] = {
0xFCFCD000,
0x002C7000,
0x002E0150,
};

#endif /* __S5K5CCGX_REG_P4W_H__ */
