/*
 * Driver for S5K5BBGX 2M ISP from Samsung
 *
 * Copyright (C) 2011,
 * DongSeong Lim<dongseong.lim@samsung.com>
 *
 * This	program	is free	software; you can redistribute it and/or modify
 * it under the	terms of the GNU General Public	License	as published by
 * the Free Software Foundation; either	version	2 of the License, or
 * (at your option) any	later version.
 */
#ifndef	__S5K5BBGX_SETFILE_H
#define	__S5K5BBGX_SETFILE_H

#include <linux/types.h>


static const u32 s5k5bbgx_common[] = {

	0xFCFCD000,
	0x00100001,	/*S/W Reset*/
	0x10300000,	/*contint_host_int*/
	0x00140001,	/*sw_load_complete - Release CORE (Arm)	from reset
			state*/
	0xFFFF000A,

	/*0x0028D000,*/	/*Driving Current*/
	/*0x002A1082,*/
	/*0x0F1203ff,*/	/*cregs_d0_d4_cd10 D4[9:8], D3[7:6], D2[5:4], D1[3:2],
			D0[1:0]*/
	/*0x002A1084,*/
	/*0x0F1203ff,*/	/*cregs_d5_d9_cd10 D9[9:8], D8[7:6], D7[5:4], D6[3:2],
			D5[1:0]*/
	/*0x002A1088,*/
	/*0x0F120fcf,*/	/*cregs_clks_output_cd10 SDA[11:10], SCL[9:8],
			PCLK[7:6], VSYNC[3:2],	HSYNC[1:0]*/

	0x0028D000,
	0x002AF404,
	0x0F120038,	/*aig_adc_sat[7:0] : 850mV*/
	0x0F120001,	/*ms[2:0]; 2h@Normal, 2h@PLA, 1h@CNT.AVG*/
	0x0F12000C,	/*aig_sig_mx[5:0]*/
	0x0F120006,	/*aig_rst_mx[5:0]*/
	0x0F120008,	/*rmp_option[7:0]; [3]SL_Low_PWR_SAVE On*/
	0x002AF418,
	0x0F120003,	/*aig_dbr_clk_sel[1:0]*/
	0x002AF41C,
	0x0F120140,	/*aig_bist_sig_width_e[10:0]*/
	0x0F120140,	/*aig_bist_sig_width_o[10:0]*/
	0x0F120066,	/*aig_bist_sig_width_o[10:0]*/
	0x0F120005,	/*aig_pix_bias[3:0]*/
	0x002AF426,
	0x0F1200D4,	/*aig_clp_lvl[7:0]*/
	0x002AF42A,
	0x0F120001,	/*aig_ref_option[0] SL_Low_PWR_SAVE On*/
	0x002AF430,
	0x0F120001,	/*aig_pd_cp_rosc[0]*/
	0x0F120001,	/*aig_pd_ncp_rosc[0]*/
	0x002AF43A,
	0x0F120000,	/*aig_pd_fblv[0]*/
	0x002AF440,
	0x0F120044,	/*aig_rosc_tune_ncp[7:4] aig_rosc_tune_cp[3:0]*/
	0x002AF44A,
	0x0F120000,	/*aig_fb_lv[1:0]*/
	0x002AF45C,
	0x0F120000,	/*aig_dshut_en[0]*/
	0x0F120000,	/*aig_srx_en[0]*/
	0x002AF462,
	0x0F120001,	/*aig_pdb_atop[0]*/
	0x002AF46E,
	0x0F121F02,	/*aig_cds_test[15:0]*/
	0x002AF474,
	0x0F12000E,	/*aig_stx_gap[4:0]*/
	0x002AE42E,
	0x0F120004,	/*adlc_qec[2:0]*/
	0x00287000,
	0x002A13E0,
	0x0F120000,	/*senHal_bSRX	SRX OFF*/
	0x002A13C8,
	0x0F120001,	/*senHal_bSenAAC AAC Enable*/
	0x002A12D8,
	0x0F120464,	/*senHal_ContPtrs_senModesDataArr[78]*/
	0x0F120468,	/*senHal_ContPtrs_senModesDataArr[79]*/
	0x002A12F6,
	0x0F120000,	/*senHal_ContPtrs_senModesDataArr[93]*/
	0x002A13CC,
	0x0F121FC0,	/*senHal_bSen11ADLC [12:0] : Write tuning value	to E404
			register*/
	0x002A13EC,
	0x0F120001,	/*senHal_DarklevelTuneMode*/
	0x002A184C,
	0x0F121EE1,
	0x00287000,
	0x002A040E,
	0x0F120003,	/*skl_usConfigStbySettings*/
	0xFFFF000A,
	0x002A1218,
	0x0F120002,	/*senHal_SenBinFactor*/
	0x0F120002,	/*senHal_SamplingType*/
	0x002A0C9A,
	0x0F120001,	/*setot_bUseDigitalHbin*/
	0x002A1438,
	0x0F12F468,	/*senHal_TuneStr_AngTuneData1[0]*/
	0x0F120000,	/*senHal_TuneStr_AngTuneData1[1] not use binninb block
			0x0000, use binnin blcok 0x0000*/
	0x0F120008,	/*senHal_TuneStr_AngTuneData1[2] not use binninb block
			0x000A, use binnin blcok 0x0008*/
	0x0F120006,	/*senHal_TuneStr_AngTuneData1[3] not use binninb block
			0x0005, use binnin blcok 0x0006*/
	0x0F120000,	/*senHal_TuneStr_AngTuneData1[4]*/
	0xFFFF000A,
	0x002A0416,
	0x0F12F400,		/*skl_usStbyBackupReg[0][0]*/
	0x0F120074,		/*skl_usStbyBackupReg[0][1]*/
	0x0F12E42E,		/*skl_usStbyBackupReg[1][0]*/
	0x0F120030,		/*skl_usStbyBackupReg[1][1]*/
	0x002A378C,
	0x0F120000,	/* On/off regiSter bUSeOTP*/
	0x002A0AD8,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F128608,
	0x0F12E960,
	0x0F120243,
	0x0F12128B,
	0x0F12F073,
	0x0F120270,
	0x0F12DF47,
	0x0F12F226,
	0x0F121A31,
	0x0F12DFDA,
	0x0F121200,
	0x0F1205A9,
	0x0F120F16,
	0x0F120F5E,
	0x0F12DF10,
	0x0F1225BF,
	0x0F12FCF0,
	0x0F12DE1B,
	0x0F12025B,
	0x0F12FA8B,
	0x0F12163B,
	0x0F12DF44,
	0x0F12FB2D,
	0x0F1230E6,
	0x0F12FE07,
	0x0F12F47C,
	0x0F1209F2,
	0x0F120AED,
	0x0F12FA09,
	0x0F12E70E,
	0x0F120158,
	0x0F121110,
	0x0F12E28C,
	0x0F120DFB,
	0x0F12074B,
	0x0F12FBE5,
	0x0F12961C,
	0x0F12E21A,
	0x0F120ADF,
	0x0F120A67,
	0x0F12F8A6,
	0x0F12FDC3,
	0x0F12D590,
	0x0F12FA69,
	0x0F1208D5,
	0x0F12F635,
	0x0F12057E,
	0x0F12043B,
	0x0F12155C,
	0x0F1200C6,
	0x0F12F042,
	0x0F12176A,
	0x0F12F818,
	0x0F12F1F3,
	0x0F12026F,
	0x0F1208F6,
	0x0F120CCF,
	0x0F12E42D,
	0x0F120A92,
	0x0F1210EC,
	0x0F12005F,
	0x0F12F02C,
	0x0F120672,
	0x0F1209BF,
	0x0F12F4B5,
	0x0F12FC22,
	0x0F12FD50,
	0x0F120C26,
	0x0F12EED3,
	0x0F1207C3,
	0x0F12080F,
	0x0F12F6CF,
	0x0F127A3B,
	0x0F12E9DC,
	0x0F12088E,
	0x0F1201C8,
	0x0F12043C,
	0x0F12F7E2,
	0x0F12E391,
	0x0F12F3C4,
	0x0F121422,
	0x0F12E845,
	0x0F120D16,
	0x0F1206CA,
	0x0F120DEB,
	0x0F121324,
	0x0F12E814,
	0x0F1216B7,
	0x0F1202AC,
	0x0F12DE4D,
	0x0F1201EA,
	0x0F12F0C2,
	0x0F120E06,
	0x0F12EC6D,
	0x0F12FDF0,
	0x0F122B46,
	0x0F120710,
	0x0F12F84C,
	0x0F120E52,
	0x0F120675,
	0x0F12F0D7,
	0x0F12ED40,
	0x0F12F3AD,
	0x0F12179A,
	0x0F12DE9B,
	0x0F1210BA,
	0x0F120825,
	0x0F12FE0A,
	0x0F1288E9,
	0x0F12E9E0,
	0x0F12043D,
	0x0F120A17,
	0x0F12FC21,
	0x0F12FB58,
	0x0F12DCE0,
	0x0F12F24C,
	0x0F121A19,
	0x0F12E011,
	0x0F1211A3,
	0x0F120649,
	0x0F120D04,
	0x0F120E15,
	0x0F12E112,
	0x0F1227BD,
	0x0F12F7AA,
	0x0F12E06A,
	0x0F120A16,
	0x0F12FD23,
	0x0F121226,
	0x0F12DA34,
	0x0F1207A4,
	0x0F122AD3,
	0x0F12FE27,
	0x0F12EE64,
	0x0F120CAD,
	0x0F1211C5,
	0x0F12EC55,
	0x0F12ED98,
	0x0F12F88A,
	0x0F121842,
	0x0F12E1D5,
	0x0F1208FD,
	0x0F120FB6,
	0x0F12F801,
	0x002A0378,
	0x0F120001,	/*REG_TC_DBG_RelnitCmd*/
	0x002A05E8,
	0x0F1200E4,	/*TVAR_ash_AwbAshCord_0_ Horizon*/
	0x0F1200F0,	/*TVAR_ash_AwbAshCord_1_ IncandA*/
	0x0F120100,	/*TVAR_ash_AwbAshCord_2_ WW*/
	0x0F120120,	/*TVAR_ash_AwbAshCord_3_ CW*/
	0x0F120150,	/*TVAR_ash_AwbAshCord_4_ D50*/
	0x0F120180,	/*TVAR_ash_AwbAshCord_5_ D65*/
	0x0F1201A0,	/*TVAR_ash_AwbAshCord_6_ D75*/
	0x002A05FE,
	0x0F123800,	/*TVAR_ash_GASAlpha_0__0_ Horizon*/
	0x0F124000,	/*TVAR_ash_GASAlpha_0__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_0__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_0__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_1__0_ IncandA*/
	0x0F124000,	/*TVAR_ash_GASAlpha_1__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_1__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_1__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_2__0_ WW*/
	0x0F124000,	/*TVAR_ash_GASAlpha_2__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_2__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_2__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_3__0_ CW*/
	0x0F124000,	/*TVAR_ash_GASAlpha_3__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_3__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_3__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_4__0_ D50*/
	0x0F124000,	/*TVAR_ash_GASAlpha_4__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_4__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_4__3_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__0_ D65*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__3_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__0_ D75*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__3_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_0_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_1_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_2_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_3_*/
	0x00287000,
	0x002A2744,
	0x0F12B510,    /* 70002744*/
	0x0F124A1C,    /* 70002746*/
	0x0F1221FB,    /* 70002748*/
	0x0F12481C,    /* 7000274A*/
	0x0F12C004,    /* 7000274C*/
	0x0F126001,    /* 7000274E*/
	0x0F12491B,    /* 70002750*/
	0x0F12481C,    /* 70002752*/
	0x0F12F000,    /* 70002754*/
	0x0F12FA0E,    /* 70002756*/
	0x0F12491B,    /* 70002758*/
	0x0F12481C,    /* 7000275A*/
	0x0F12F000,    /* 7000275C*/
	0x0F12FA0A,    /* 7000275E*/
	0x0F12491B,    /* 70002760*/
	0x0F12481C,    /* 70002762*/
	0x0F12F000,    /* 70002764*/
	0x0F12FA06,    /* 70002766*/
	0x0F12491B,    /* 70002768*/
	0x0F12481C,    /* 7000276A*/
	0x0F12F000,    /* 7000276C*/
	0x0F12FA02,    /* 7000276E*/
	0x0F12491B,    /* 70002770*/
	0x0F12481C,    /* 70002772*/
	0x0F12F000,    /* 70002774*/
	0x0F12F9FE,    /* 70002776*/
	0x0F12491B,    /* 70002778*/
	0x0F12481C,    /* 7000277A*/
	0x0F12F000,    /* 7000277C*/
	0x0F12F9FA,    /* 7000277E*/
	0x0F12491B,    /* 70002780*/
	0x0F12481C,    /* 70002782*/
	0x0F12F000,    /* 70002784*/
	0x0F12F9F6,    /* 70002786*/
	0x0F12481B,    /* 70002788*/
	0x0F122130,    /* 7000278A*/
	0x0F128001,    /* 7000278C*/
	0x0F1221C0,    /* 7000278E*/
	0x0F128041,    /* 70002790*/
	0x0F122104,    /* 70002792*/
	0x0F128081,    /* 70002794*/
	0x0F122100,    /* 70002796*/
	0x0F1280C1,    /* 70002798*/
	0x0F128101,    /* 7000279A*/
	0x0F124917,    /* 7000279C*/
	0x0F122016,    /* 7000279E*/
	0x0F1283C8,    /* 700027A0*/
	0x0F124917,    /* 700027A2*/
	0x0F124817,    /* 700027A4*/
	0x0F12F000,    /* 700027A6*/
	0x0F12F9E5,    /* 700027A8*/
	0x0F124917,    /* 700027AA*/
	0x0F124817,    /* 700027AC*/
	0x0F12F000,    /* 700027AE*/
	0x0F12F9E1,    /* 700027B0*/
	0x0F12BC10,    /* 700027B2*/
	0x0F12BC08,    /* 700027B4*/
	0x0F124718,    /* 700027B6*/
	0x0F120000,    /* 700027B8*/
	0x0F125BB1,    /* 700027BA*/
	0x0F121770,    /* 700027BC*/
	0x0F127000,    /* 700027BE*/
	0x0F122811,    /* 700027C0*/
	0x0F127000,    /* 700027C2*/
	0x0F12C0BB,    /* 700027C4*/
	0x0F120000,    /* 700027C6*/
	0x0F12284F,    /* 700027C8*/
	0x0F127000,    /* 700027CA*/
	0x0F123609,    /* 700027CC*/
	0x0F120000,    /* 700027CE*/
	0x0F122867,    /* 700027D0*/
	0x0F127000,    /* 700027D2*/
	0x0F1277C7,    /* 700027D4*/
	0x0F120000,    /* 700027D6*/
	0x0F1228F3,    /* 700027D8*/
	0x0F127000,    /* 700027DA*/
	0x0F12727D,    /* 700027DC*/
	0x0F120000,    /* 700027DE*/
	0x0F122949,    /* 700027E0*/
	0x0F127000,    /* 700027E2*/
	0x0F129919,    /* 700027E4*/
	0x0F120000,    /* 700027E6*/
	0x0F122987,    /* 700027E8*/
	0x0F127000,    /* 700027EA*/
	0x0F121C63,    /* 700027EC*/
	0x0F120000,    /* 700027EE*/
	0x0F1229E7,    /* 700027F0*/
	0x0F127000,    /* 700027F2*/
	0x0F1204CB,    /* 700027F4*/
	0x0F120000,    /* 700027F6*/
	0x0F122C7C,    /* 700027F8*/
	0x0F127000,    /* 700027FA*/
	0x0F120CA8,    /* 700027FC*/
	0x0F127000,    /* 700027FE*/
	0x0F122B1D,    /* 70002800*/
	0x0F127000,    /* 70002802*/
	0x0F1250AF,    /* 70002804*/
	0x0F120000,    /* 70002806*/
	0x0F122B2D,    /* 70002808*/
	0x0F127000,    /* 7000280A*/
	0x0F125623,    /* 7000280C*/
	0x0F120000,    /* 7000280E*/
	0x0F12B4F0,    /* 70002810*/
	0x0F126801,    /* 70002812*/
	0x0F12468C,    /* 70002814*/
	0x0F126846,    /* 70002816*/
	0x0F122200,    /* 70002818*/
	0x0F1249C7,    /* 7000281A*/
	0x0F122000,    /* 7000281C*/
	0x0F122724,    /* 7000281E*/
	0x0F124357,    /* 70002820*/
	0x0F12183B,    /* 70002822*/
	0x0F124664,    /* 70002824*/
	0x0F125CE5,    /* 70002826*/
	0x0F12005C,    /* 70002828*/
	0x0F125B34,    /* 7000282A*/
	0x0F12072D,    /* 7000282C*/
	0x0F120F2D,    /* 7000282E*/
	0x0F12800D,    /* 70002830*/
	0x0F12804C,    /* 70002832*/
	0x0F12808B,    /* 70002834*/
	0x0F122301,    /* 70002836*/
	0x0F1280CB,    /* 70002838*/
	0x0F122300,    /* 7000283A*/
	0x0F1280CB,    /* 7000283C*/
	0x0F121C40,    /* 7000283E*/
	0x0F122824,    /* 70002840*/
	0x0F12D3EE,    /* 70002842*/
	0x0F121C52,    /* 70002844*/
	0x0F122A04,    /* 70002846*/
	0x0F12D3E8,    /* 70002848*/
	0x0F12BCF0,    /* 7000284A*/
	0x0F124770,    /* 7000284C*/
	0x0F12B510,    /* 7000284E*/
	0x0F12F000,    /* 70002850*/
	0x0F12F998,    /* 70002852*/
	0x0F1248B9,    /* 70002854*/
	0x0F127A81,    /* 70002856*/
	0x0F1248B9,    /* 70002858*/
	0x0F126B00,    /* 7000285A*/
	0x0F12F000,    /* 7000285C*/
	0x0F12F99A,    /* 7000285E*/
	0x0F12BC10,    /* 70002860*/
	0x0F12BC08,    /* 70002862*/
	0x0F124718,    /* 70002864*/
	0x0F12B5F8,    /* 70002866*/
	0x0F126805,    /* 70002868*/
	0x0F126844,    /* 7000286A*/
	0x0F124EB5,    /* 7000286C*/
	0x0F128861,    /* 7000286E*/
	0x0F128AB0,    /* 70002870*/
	0x0F128A72,    /* 70002872*/
	0x0F122301,    /* 70002874*/
	0x0F124368,    /* 70002876*/
	0x0F121889,    /* 70002878*/
	0x0F1217C2,    /* 7000287A*/
	0x0F120E12,    /* 7000287C*/
	0x0F121810,    /* 7000287E*/
	0x0F121202,    /* 70002880*/
	0x0F128820,    /* 70002882*/
	0x0F12029B,    /* 70002884*/
	0x0F1218C0,    /* 70002886*/
	0x0F12F000,    /* 70002888*/
	0x0F12F98C,    /* 7000288A*/
	0x0F129000,    /* 7000288C*/
	0x0F128AF6,    /* 7000288E*/
	0x0F124268,    /* 70002890*/
	0x0F12210A,    /* 70002892*/
	0x0F124370,    /* 70002894*/
	0x0F12F000,    /* 70002896*/
	0x0F12F98D,    /* 70002898*/
	0x0F12436E,    /* 7000289A*/
	0x0F120007,    /* 7000289C*/
	0x0F12210A,    /* 7000289E*/
	0x0F120030,    /* 700028A0*/
	0x0F12F000,    /* 700028A2*/
	0x0F12F987,    /* 700028A4*/
	0x0F129A00,    /* 700028A6*/
	0x0F120039,    /* 700028A8*/
	0x0F12F000,    /* 700028AA*/
	0x0F12F989,    /* 700028AC*/
	0x0F120002,    /* 700028AE*/
	0x0F128820,    /* 700028B0*/
	0x0F121880,    /* 700028B2*/
	0x0F128020,    /* 700028B4*/
	0x0F1248A4,    /* 700028B6*/
	0x0F1288C1,    /* 700028B8*/
	0x0F1248A2,    /* 700028BA*/
	0x0F123820,    /* 700028BC*/
	0x0F128B40,    /* 700028BE*/
	0x0F124240,    /* 700028C0*/
	0x0F124350,    /* 700028C2*/
	0x0F12F000,    /* 700028C4*/
	0x0F12F976,    /* 700028C6*/
	0x0F128861,    /* 700028C8*/
	0x0F121840,    /* 700028CA*/
	0x0F128060,    /* 700028CC*/
	0x0F12BCF8,    /* 700028CE*/
	0x0F12BC08,    /* 700028D0*/
	0x0F124718,    /* 700028D2*/
	0x0F12B570,    /* 700028D4*/
	0x0F124C9B,    /* 700028D6*/
	0x0F123C20,    /* 700028D8*/
	0x0F128B20,    /* 700028DA*/
	0x0F12F000,    /* 700028DC*/
	0x0F12F978,    /* 700028DE*/
	0x0F124D99,    /* 700028E0*/
	0x0F1280E8,    /* 700028E2*/
	0x0F128B60,    /* 700028E4*/
	0x0F12F000,    /* 700028E6*/
	0x0F12F97B,    /* 700028E8*/
	0x0F128128,    /* 700028EA*/
	0x0F12BC70,    /* 700028EC*/
	0x0F12BC08,    /* 700028EE*/
	0x0F124718,    /* 700028F0*/
	0x0F12B508,    /* 700028F2*/
	0x0F124895,    /* 700028F4*/
	0x0F124669,    /* 700028F6*/
	0x0F12F000,    /* 700028F8*/
	0x0F12F97A,    /* 700028FA*/
	0x0F124894,    /* 700028FC*/
	0x0F12214D,    /* 700028FE*/
	0x0F128201,    /* 70002900*/
	0x0F122196,    /* 70002902*/
	0x0F128281,    /* 70002904*/
	0x0F12211D,    /* 70002906*/
	0x0F128301,    /* 70002908*/
	0x0F12F7FF,    /* 7000290A*/
	0x0F12FFE3,    /* 7000290C*/
	0x0F12F000,    /* 7000290E*/
	0x0F12F977,    /* 70002910*/
	0x0F12466B,    /* 70002912*/
	0x0F128818,    /* 70002914*/
	0x0F128859,    /* 70002916*/
	0x0F121A40,    /* 70002918*/
	0x0F12498E,    /* 7000291A*/
	0x0F126348,    /* 7000291C*/
	0x0F12488A,    /* 7000291E*/
	0x0F129900,    /* 70002920*/
	0x0F123876,    /* 70002922*/
	0x0F12F000,    /* 70002924*/
	0x0F12F974,    /* 70002926*/
	0x0F12466B,    /* 70002928*/
	0x0F12488A,    /* 7000292A*/
	0x0F128819,    /* 7000292C*/
	0x0F123080,    /* 7000292E*/
	0x0F1284C1,    /* 70002930*/
	0x0F128859,    /* 70002932*/
	0x0F128501,    /* 70002934*/
	0x0F124987,    /* 70002936*/
	0x0F122000,    /* 70002938*/
	0x0F123920,    /* 7000293A*/
	0x0F127088,    /* 7000293C*/
	0x0F123140,    /* 7000293E*/
	0x0F127388,    /* 70002940*/
	0x0F12B001,    /* 70002942*/
	0x0F12BC08,    /* 70002944*/
	0x0F124718,    /* 70002946*/
	0x0F12B570,    /* 70002948*/
	0x0F120004,    /* 7000294A*/
	0x0F126820,    /* 7000294C*/
	0x0F126865,    /* 7000294E*/
	0x0F12F000,    /* 70002950*/
	0x0F12F966,    /* 70002952*/
	0x0F120402,    /* 70002954*/
	0x0F124880,    /* 70002956*/
	0x0F120C12,    /* 70002958*/
	0x0F128142,    /* 7000295A*/
	0x0F12487F,    /* 7000295C*/
	0x0F128801,    /* 7000295E*/
	0x0F122900,    /* 70002960*/
	0x0F12D008,    /* 70002962*/
	0x0F12497E,    /* 70002964*/
	0x0F12002B,    /* 70002966*/
	0x0F126D8A,    /* 70002968*/
	0x0F122105,    /* 7000296A*/
	0x0F121C80,    /* 7000296C*/
	0x0F12F000,    /* 7000296E*/
	0x0F12F95F,    /* 70002970*/
	0x0F126020,    /* 70002972*/
	0x0F12E005,    /* 70002974*/
	0x0F12487B,    /* 70002976*/
	0x0F12002B,    /* 70002978*/
	0x0F122105,    /* 7000297A*/
	0x0F12F000,    /* 7000297C*/
	0x0F12F958,    /* 7000297E*/
	0x0F126020,    /* 70002980*/
	0x0F126820,    /* 70002982*/
	0x0F12E7B2,    /* 70002984*/
	0x0F12B5F8,    /* 70002986*/
	0x0F124975,    /* 70002988*/
	0x0F122200,    /* 7000298A*/
	0x0F123160,    /* 7000298C*/
	0x0F1283CA,    /* 7000298E*/
	0x0F126800,    /* 70002990*/
	0x0F124669,    /* 70002992*/
	0x0F12F000,    /* 70002994*/
	0x0F12F92C,    /* 70002996*/
	0x0F12466B,    /* 70002998*/
	0x0F128818,    /* 7000299A*/
	0x0F12F000,    /* 7000299C*/
	0x0F12F918,    /* 7000299E*/
	0x0F120005,    /* 700029A0*/
	0x0F12466B,    /* 700029A2*/
	0x0F128858,    /* 700029A4*/
	0x0F12F000,    /* 700029A6*/
	0x0F12F91B,    /* 700029A8*/
	0x0F120004,    /* 700029AA*/
	0x0F122101,    /* 700029AC*/
	0x0F121928,    /* 700029AE*/
	0x0F1202C9,    /* 700029B0*/
	0x0F121A08,    /* 700029B2*/
	0x0F120286,    /* 700029B4*/
	0x0F120029,    /* 700029B6*/
	0x0F120030,    /* 700029B8*/
	0x0F12F000,    /* 700029BA*/
	0x0F12F941,    /* 700029BC*/
	0x0F120005,    /* 700029BE*/
	0x0F122701,    /* 700029C0*/
	0x0F1202BF,    /* 700029C2*/
	0x0F120021,    /* 700029C4*/
	0x0F120030,    /* 700029C6*/
	0x0F12F000,    /* 700029C8*/
	0x0F12F93A,    /* 700029CA*/
	0x0F124964,    /* 700029CC*/
	0x0F124A61,    /* 700029CE*/
	0x0F123140,    /* 700029D0*/
	0x0F1232A0,    /* 700029D2*/
	0x0F12800D,    /* 700029D4*/
	0x0F128395,    /* 700029D6*/
	0x0F12804F,    /* 700029D8*/
	0x0F1283D7,    /* 700029DA*/
	0x0F128088,    /* 700029DC*/
	0x0F120011,    /* 700029DE*/
	0x0F123120,    /* 700029E0*/
	0x0F128008,    /* 700029E2*/
	0x0F12E773,    /* 700029E4*/
	0x0F12B510,    /* 700029E6*/
	0x0F12485C,    /* 700029E8*/
	0x0F128980,    /* 700029EA*/
	0x0F122800,    /* 700029EC*/
	0x0F12D001,    /* 700029EE*/
	0x0F12F000,    /* 700029F0*/
	0x0F12F92C,    /* 700029F2*/
	0x0F12E734,    /* 700029F4*/
	0x0F12B5FE,    /* 700029F6*/
	0x0F122600,    /* 700029F8*/
	0x0F12495B,    /* 700029FA*/
	0x0F122000,    /* 700029FC*/
	0x0F126108,    /* 700029FE*/
	0x0F1260C8,    /* 70002A00*/
	0x0F12485A,    /* 70002A02*/
	0x0F128901,    /* 70002A04*/
	0x0F124852,    /* 70002A06*/
	0x0F123020,    /* 70002A08*/
	0x0F1288C0,    /* 70002A0A*/
	0x0F129000,    /* 70002A0C*/
	0x0F120840,    /* 70002A0E*/
	0x0F129002,    /* 70002A10*/
	0x0F124856,    /* 70002A12*/
	0x0F128800,    /* 70002A14*/
	0x0F129001,    /* 70002A16*/
	0x0F124853,    /* 70002A18*/
	0x0F123040,    /* 70002A1A*/
	0x0F128B05,    /* 70002A1C*/
	0x0F122900,    /* 70002A1E*/
	0x0F12D01F,    /* 70002A20*/
	0x0F124E52,    /* 70002A22*/
	0x0F122700,    /* 70002A24*/
	0x0F1280F7,    /* 70002A26*/
	0x0F122400,    /* 70002A28*/
	0x0F12E016,    /* 70002A2A*/
	0x0F12494E,    /* 70002A2C*/
	0x0F120060,    /* 70002A2E*/
	0x0F1239C0,    /* 70002A30*/
	0x0F121841,    /* 70002A32*/
	0x0F122020,    /* 70002A34*/
	0x0F125E08,    /* 70002A36*/
	0x0F129902,    /* 70002A38*/
	0x0F121840,    /* 70002A3A*/
	0x0F129900,    /* 70002A3C*/
	0x0F12F000,    /* 70002A3E*/
	0x0F12F8FF,    /* 70002A40*/
	0x0F124B4A,    /* 70002A42*/
	0x0F120202,    /* 70002A44*/
	0x0F1200A1,    /* 70002A46*/
	0x0F12330C,    /* 70002A48*/
	0x0F12505A,    /* 70002A4A*/
	0x0F120002,    /* 70002A4C*/
	0x0F124342,    /* 70002A4E*/
	0x0F120210,    /* 70002A50*/
	0x0F121DDA,    /* 70002A52*/
	0x0F1232F9,    /* 70002A54*/
	0x0F125050,    /* 70002A56*/
	0x0F121C64,    /* 70002A58*/
	0x0F1242A5,    /* 70002A5A*/
	0x0F12DCE6,    /* 70002A5C*/
	0x0F128137,    /* 70002A5E*/
	0x0F12E042,    /* 70002A60*/
	0x0F122400,    /* 70002A62*/
	0x0F12E031,    /* 70002A64*/
	0x0F124940,    /* 70002A66*/
	0x0F120060,    /* 70002A68*/
	0x0F1239C0,    /* 70002A6A*/
	0x0F121841,    /* 70002A6C*/
	0x0F122020,    /* 70002A6E*/
	0x0F125E08,    /* 70002A70*/
	0x0F129902,    /* 70002A72*/
	0x0F121840,    /* 70002A74*/
	0x0F129900,    /* 70002A76*/
	0x0F12F000,    /* 70002A78*/
	0x0F12F8E2,    /* 70002A7A*/
	0x0F124A3B,    /* 70002A7C*/
	0x0F1200A1,    /* 70002A7E*/
	0x0F12320C,    /* 70002A80*/
	0x0F125853,    /* 70002A82*/
	0x0F123A0C,    /* 70002A84*/
	0x0F128852,    /* 70002A86*/
	0x0F124353,    /* 70002A88*/
	0x0F123380,    /* 70002A8A*/
	0x0F120A1F,    /* 70002A8C*/
	0x0F1223FF,    /* 70002A8E*/
	0x0F121C5B,    /* 70002A90*/
	0x0F121A9B,    /* 70002A92*/
	0x0F12469C,    /* 70002A94*/
	0x0F124343,    /* 70002A96*/
	0x0F1218FF,    /* 70002A98*/
	0x0F124B34,    /* 70002A9A*/
	0x0F12330C,    /* 70002A9C*/
	0x0F12505F,    /* 70002A9E*/
	0x0F120003,    /* 70002AA0*/
	0x0F124343,    /* 70002AA2*/
	0x0F124660,    /* 70002AA4*/
	0x0F124343,    /* 70002AA6*/
	0x0F124831,    /* 70002AA8*/
	0x0F125840,    /* 70002AAA*/
	0x0F124350,    /* 70002AAC*/
	0x0F123080,    /* 70002AAE*/
	0x0F124A2F,    /* 70002AB0*/
	0x0F120A00,    /* 70002AB2*/
	0x0F121818,    /* 70002AB4*/
	0x0F125050,    /* 70002AB6*/
	0x0F120039,    /* 70002AB8*/
	0x0F124379,    /* 70002ABA*/
	0x0F123180,    /* 70002ABC*/
	0x0F120A09,    /* 70002ABE*/
	0x0F124281,    /* 70002AC0*/
	0x0F12D201,    /* 70002AC2*/
	0x0F121A40,    /* 70002AC4*/
	0x0F121986,    /* 70002AC6*/
	0x0F121C64,    /* 70002AC8*/
	0x0F1242A5,    /* 70002ACA*/
	0x0F12DCCB,    /* 70002ACC*/
	0x0F120868,    /* 70002ACE*/
	0x0F121980,    /* 70002AD0*/
	0x0F120029,    /* 70002AD2*/
	0x0F12F000,    /* 70002AD4*/
	0x0F12F8B4,    /* 70002AD6*/
	0x0F123008,    /* 70002AD8*/
	0x0F120900,    /* 70002ADA*/
	0x0F129A01,    /* 70002ADC*/
	0x0F124923,    /* 70002ADE*/
	0x0F124290,    /* 70002AE0*/
	0x0F12D901,    /* 70002AE2*/
	0x0F128888,    /* 70002AE4*/
	0x0F1280C8,    /* 70002AE6*/
	0x0F124920,    /* 70002AE8*/
	0x0F1288C8,    /* 70002AEA*/
	0x0F122800,    /* 70002AEC*/
	0x0F12D001,    /* 70002AEE*/
	0x0F121E40,    /* 70002AF0*/
	0x0F1280C8,    /* 70002AF2*/
	0x0F129801,    /* 70002AF4*/
	0x0F122800,    /* 70002AF6*/
	0x0F12D00D,    /* 70002AF8*/
	0x0F124A1B,    /* 70002AFA*/
	0x0F123AC0,    /* 70002AFC*/
	0x0F127B90,    /* 70002AFE*/
	0x0F122802,    /* 70002B00*/
	0x0F12D001,    /* 70002B02*/
	0x0F122803,    /* 70002B04*/
	0x0F12D106,    /* 70002B06*/
	0x0F1288C9,    /* 70002B08*/
	0x0F122900,    /* 70002B0A*/
	0x0F12D003,    /* 70002B0C*/
	0x0F122100,    /* 70002B0E*/
	0x0F120040,    /* 70002B10*/
	0x0F121880,    /* 70002B12*/
	0x0F128081,    /* 70002B14*/
	0x0F12BCFE,    /* 70002B16*/
	0x0F12BC08,    /* 70002B18*/
	0x0F124718,    /* 70002B1A*/
	0x0F12B510,    /* 70002B1C*/
	0x0F126800,    /* 70002B1E*/
	0x0F12F000,    /* 70002B20*/
	0x0F12F89C,    /* 70002B22*/
	0x0F124911,    /* 70002B24*/
	0x0F122001,    /* 70002B26*/
	0x0F128108,    /* 70002B28*/
	0x0F12E699,    /* 70002B2A*/
	0x0F12B510,    /* 70002B2C*/
	0x0F12F000,    /* 70002B2E*/
	0x0F12F89D,    /* 70002B30*/
	0x0F12F7FF,    /* 70002B32*/
	0x0F12FF60,    /* 70002B34*/
	0x0F12E693,    /* 70002B36*/
	0x0F124140,    /* 70002B38*/
	0x0F12D000,    /* 70002B3A*/
	0x0F1219DC,    /* 70002B3C*/
	0x0F127000,    /* 70002B3E*/
	0x0F121B60,    /* 70002B40*/
	0x0F127000,    /* 70002B42*/
	0x0F120DD4,    /* 70002B44*/
	0x0F127000,    /* 70002B46*/
	0x0F1222AC,    /* 70002B48*/
	0x0F127000,    /* 70002B4A*/
	0x0F120F88,    /* 70002B4C*/
	0x0F127000,    /* 70002B4E*/
	0x0F121E8C,    /* 70002B50*/
	0x0F127000,    /* 70002B52*/
	0x0F12214C,    /* 70002B54*/
	0x0F127000,    /* 70002B56*/
	0x0F121A10,    /* 70002B58*/
	0x0F127000,    /* 70002B5A*/
	0x0F123780,    /* 70002B5C*/
	0x0F127000,    /* 70002B5E*/
	0x0F122384,    /* 70002B60*/
	0x0F127000,    /* 70002B62*/
	0x0F12065C,    /* 70002B64*/
	0x0F127000,    /* 70002B66*/
	0x0F121C8C,    /* 70002B68*/
	0x0F127000,    /* 70002B6A*/
	0x0F122C7C,    /* 70002B6C*/
	0x0F127000,    /* 70002B6E*/
	0x0F122D88,    /* 70002B70*/
	0x0F127000,    /* 70002B72*/
	0x0F124778,    /* 70002B74*/
	0x0F1246C0,    /* 70002B76*/
	0x0F12C000,    /* 70002B78*/
	0x0F12E59F,    /* 70002B7A*/
	0x0F12FF1C,    /* 70002B7C*/
	0x0F12E12F,    /* 70002B7E*/
	0x0F12CE77,    /* 70002B80*/
	0x0F120000,    /* 70002B82*/
	0x0F124778,    /* 70002B84*/
	0x0F1246C0,    /* 70002B86*/
	0x0F12C000,    /* 70002B88*/
	0x0F12E59F,    /* 70002B8A*/
	0x0F12FF1C,    /* 70002B8C*/
	0x0F12E12F,    /* 70002B8E*/
	0x0F123609,    /* 70002B90*/
	0x0F120000,    /* 70002B92*/
	0x0F124778,    /* 70002B94*/
	0x0F1246C0,    /* 70002B96*/
	0x0F12C000,    /* 70002B98*/
	0x0F12E59F,    /* 70002B9A*/
	0x0F12FF1C,    /* 70002B9C*/
	0x0F12E12F,    /* 70002B9E*/
	0x0F129F91,    /* 70002BA0*/
	0x0F120000,    /* 70002BA2*/
	0x0F124778,    /* 70002BA4*/
	0x0F1246C0,    /* 70002BA6*/
	0x0F12C000,    /* 70002BA8*/
	0x0F12E59F,    /* 70002BAA*/
	0x0F12FF1C,    /* 70002BAC*/
	0x0F12E12F,    /* 70002BAE*/
	0x0F122AE3,    /* 70002BB0*/
	0x0F120000,    /* 70002BB2*/
	0x0F124778,    /* 70002BB4*/
	0x0F1246C0,    /* 70002BB6*/
	0x0F12F004,    /* 70002BB8*/
	0x0F12E51F,    /* 70002BBA*/
	0x0F12D1DC,    /* 70002BBC*/
	0x0F120000,    /* 70002BBE*/
	0x0F124778,    /* 70002BC0*/
	0x0F1246C0,    /* 70002BC2*/
	0x0F12C000,    /* 70002BC4*/
	0x0F12E59F,    /* 70002BC6*/
	0x0F12FF1C,    /* 70002BC8*/
	0x0F12E12F,    /* 70002BCA*/
	0x0F126869,    /* 70002BCC*/
	0x0F120000,    /* 70002BCE*/
	0x0F124778,    /* 70002BD0*/
	0x0F1246C0,    /* 70002BD2*/
	0x0F12C000,    /* 70002BD4*/
	0x0F12E59F,    /* 70002BD6*/
	0x0F12FF1C,    /* 70002BD8*/
	0x0F12E12F,    /* 70002BDA*/
	0x0F1268BD,    /* 70002BDC*/
	0x0F120000,    /* 70002BDE*/
	0x0F124778,    /* 70002BE0*/
	0x0F1246C0,    /* 70002BE2*/
	0x0F12C000,    /* 70002BE4*/
	0x0F12E59F,    /* 70002BE6*/
	0x0F12FF1C,    /* 70002BE8*/
	0x0F12E12F,    /* 70002BEA*/
	0x0F1268DB,    /* 70002BEC*/
	0x0F120000,    /* 70002BEE*/
	0x0F124778,    /* 70002BF0*/
	0x0F1246C0,    /* 70002BF2*/
	0x0F12C000,    /* 70002BF4*/
	0x0F12E59F,    /* 70002BF6*/
	0x0F12FF1C,    /* 70002BF8*/
	0x0F12E12F,    /* 70002BFA*/
	0x0F121BC9,    /* 70002BFC*/
	0x0F120000,    /* 70002BFE*/
	0x0F124778,    /* 70002C00*/
	0x0F1246C0,    /* 70002C02*/
	0x0F12C000,    /* 70002C04*/
	0x0F12E59F,    /* 70002C06*/
	0x0F12FF1C,    /* 70002C08*/
	0x0F12E12F,    /* 70002C0A*/
	0x0F1271B9,    /* 70002C0C*/
	0x0F120000,    /* 70002C0E*/
	0x0F124778,    /* 70002C10*/
	0x0F1246C0,    /* 70002C12*/
	0x0F12C000,    /* 70002C14*/
	0x0F12E59F,    /* 70002C16*/
	0x0F12FF1C,    /* 70002C18*/
	0x0F12E12F,    /* 70002C1A*/
	0x0F127249,    /* 70002C1C*/
	0x0F120000,    /* 70002C1E*/
	0x0F124778,    /* 70002C20*/
	0x0F1246C0,    /* 70002C22*/
	0x0F12C000,    /* 70002C24*/
	0x0F12E59F,    /* 70002C26*/
	0x0F12FF1C,    /* 70002C28*/
	0x0F12E12F,    /* 70002C2A*/
	0x0F1298CD,    /* 70002C2C*/
	0x0F120000,    /* 70002C2E*/
	0x0F124778,    /* 70002C30*/
	0x0F1246C0,    /* 70002C32*/
	0x0F12C000,    /* 70002C34*/
	0x0F12E59F,    /* 70002C36*/
	0x0F12FF1C,    /* 70002C38*/
	0x0F12E12F,    /* 70002C3A*/
	0x0F12987F,    /* 70002C3C*/
	0x0F120000,    /* 70002C3E*/
	0x0F124778,    /* 70002C40*/
	0x0F1246C0,    /* 70002C42*/
	0x0F12F004,    /* 70002C44*/
	0x0F12E51F,    /* 70002C46*/
	0x0F12D378,    /* 70002C48*/
	0x0F120000,    /* 70002C4A*/
	0x0F124778,    /* 70002C4C*/
	0x0F1246C0,    /* 70002C4E*/
	0x0F12C000,    /* 70002C50*/
	0x0F12E59F,    /* 70002C52*/
	0x0F12FF1C,    /* 70002C54*/
	0x0F12E12F,    /* 70002C56*/
	0x0F1204CB,    /* 70002C58*/
	0x0F120000,    /* 70002C5A*/
	0x0F124778,    /* 70002C5C*/
	0x0F1246C0,    /* 70002C5E*/
	0x0F12C000,    /* 70002C60*/
	0x0F12E59F,    /* 70002C62*/
	0x0F12FF1C,    /* 70002C64*/
	0x0F12E12F,    /* 70002C66*/
	0x0F1250AF,    /* 70002C68*/
	0x0F120000,    /* 70002C6A*/
	0x0F124778,    /* 70002C6C*/
	0x0F1246C0,    /* 70002C6E*/
	0x0F12C000,    /* 70002C70*/
	0x0F12E59F,    /* 70002C72*/
	0x0F12FF1C,    /* 70002C74*/
	0x0F12E12F,    /* 70002C76*/
	0x0F125623,    /* 70002C78*/
	0x0F120000,    /* 70002C7A*/
	0x0028D000,
	0x002A1000,
	0x0F120001,
	0x00287000,
	0x002A00F4,
	0x0F125DC0,	/*REG_TC_IPRM_InClockLSBs*/
	0x0F120000,	/*REG_TC_IPRM_InClockMSBs   5DC0h=24000d=24Mhz*/
	0x002A0110,
	0x0F120002,	/*REG_TC_IPRM_UseNPviClocks*/
	0x0F120000,	/*REG_TC_IPRM_bBlockInternalPllCalc*/
	0x0F12222E,	/*REG_TC_IPRM_OpClk4KHz_0   222Eh=8750d*4=35000d=35Mhz*/
	0x0F12445C,	/*REG_TC_IPRM_MinOutRate4KHz_0
			445CEh=8750d*4=35000d=35Mhz*/
	0x0F12445C,	/*REG_TC_IPRM_MaxOutRate4KHz_0
			445Ch=8750d*4=35000d=35Mhz*/
	0x0F12222E,	/*REG_TC_IPRM_OpClk4KHz_1*/
	0x0F12222E,	/*REG_TC_IPRM_MinOutRate4KHz_1*/
	0x0F12222E,	/*REG_TC_IPRM_MaxOutRate4KHz_1*/
	0x002A0126,
	0x0F120001,	/*REG_TC_IPRM_InitParamsUpdated*/
	/*0x002A0144,*/
	/*0x0F120640,*/	/*REG_TC_GP_PrevReqInputWidth 640h=1600d*/
	/*0x0F1204B0,*/	/*REG_TC_GP_PrevReqInputHeight 4b0h=1200d*/
	/*0x0F120000,*/	/*REG_TC_GP_PrevInputWidthOfs*/
	/*0x0F120000,*/	/*REG_TC_GP_PrevInputHeightOfs*/
	/*0x0F120640,*/	/*REG_TC_GP_CapReqInputWidth  640h=1600d*/
	/*0x0F1204B0,*/	/*REG_TC_GP_CapReqInputHeight 4b0h=1200d*/
	/*0x0F120000,*/	/*REG_TC_GP_CapInputWidthOfs*/
	/*0x0F120000,*/	/*REG_TC_GP_CapInputHeightOfs*/
	/*0x002A0164,*/
	/*0x0F120001,*/	/*REG_TC_GP_bUseReqInputInPre*/
	/*0x0F120001,*/	/*REG_TC_GP_bUseReqInputInCap*/
	/*0x002A0310,*/
	/*0x0F120640,*/	/*REG_TC_PZOOM_ZoomInputWidth	 640h=1600d*/
	/*0x0F1204b0,*/	/*REG_TC_PZOOM_ZoomInputHeight	 4b0h=1200d*/
	/*0x0F120000,*/	/*REG_TC_PZOOM_ZoomInputWidthOfs*/
	/*0x0F120000,*/	/*REG_TC_PZOOM_ZoomInputHeightOfs*/
	0x002A0170,
	0x0F120280,	/*0500	0320	REG_0TC_PCFG_usWidth*/
	0x0F1201E0,	/*03C0	0258	REG_0TC_PCFG_usHeight*/
	0x0F120005,	/*0005	0005	REG_0TC_PCFG_Format 0	RGB565;
			1 RGB888; 5 Full YUV422; 6 Reduced YUV422; 7 Bayer*/
	0x0F12222E,	/*445C	222E	REG_0TC_PCFG_usMaxOut4KHzRate*/
	0x0F12222E,	/*445C	222E	REG_0TC_PCFG_usMinOut4KHzRate*/
	0x0F120042,	/*0042	0042	REG_0TC_PCFG_PVIMask*/
	0x0F120010,	/*0010	0010	REG_0TC_PCFG_OIFMask*/
	0x0F120001,	/*0000	0001	REG_0TC_PCFG_uClockInd*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_usFrTimeType 0: dynamic
			1:fix not accurate 2: fixed_Accurate*/
	0x0F120001,	/*0000	0001	REG_0TC_PCFG_FrRateQualityType 1b: FR
			(bin) 2b: Quality (no-bin)*/
	0x0F120535,	/*0535	0535	REG_0TC_PCFG_uSMaxFrTimeMSecMult10 max
			frame time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F1202bb,	/*029A	029A	REG_0TC_PCFG_uSMinFrTimeMSecMult10  max
			frame	time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_bSmearOutput*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_SSaturation*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_SSharpBlur*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_SColorTemp*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_uDeviceGammaIndex 1:Mirror
			(X) 2:Mirror(Y) 4:STAT	Mirror(X) 8:STAT Mirror(Y)*/
	0x0F120003,	/*0000	0001	REG_0TC_PCFG_uPrevMirror*/
	0x0F120003,	/*0000	0001	REG_0TC_PCFG_uCaptureMirror*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_uRotation*/
	0x002A0198,
	0x0F120280,	/*0280	REG_1TC_PCFG_uSWidth	2   70000198  640*/
	0x0F1201E0,	/*01E0	REG_1TC_PCFG_uSHeight	2   7000019A  480*/
	0x0F120005,	/*0005	REG_1TC_PCFG_Format	2   7000019C  0	RGB565;
			1 RGB888; 5 Full YUV422; 6 Reduced YUV422; 7 Bayer*/
	0x0F12222E,	/*222E	REG_1TC_PCFG_uSMaxOut4KHzRate	2   7000019E*/
	0x0F12222E,	/*222E	REG_1TC_PCFG_uSMinOut4KHzRate	2   700001A0*/
	0x0F120042,	/*0042	REG_1TC_PCFG_PVIMaSk		2   700001A2*/
	0x0F120010,	/*0010	REG_1TC_PCFG_OIFMaSk		2   700001A4*/
	0x0F120001,	/*0001	REG_1TC_PCFG_uClockInd		2   700001A6*/
	0x0F120002,	/*0000	REG_1TC_PCFG_uSFrTimeType	2   700001A8
			0: dynamic 1:fix not accurate 2: fixed_Accurate*/
	0x0F120001,	/*0001	REG_1TC_PCFG_FrRateQualityType	2   700001AA*/
	0x0F12014D,	/*01A0	REG_1TC_PCFG_uSMaxFrTimeMSecMult10
								2   700001AC
			max frame	time : 30fpS:014D 15fpS:029a
			7.5fpS:0535 3.75fpS:a6a*/
	0x0F12014D,	/*014D	REG_1TC_PCFG_uSMinFrTimeMSecMult10
								2   700001AE
			max frame	time : 30fpS:014D 15fpS:029a
			7.5fpS:0535 3.75fpS:a6a*/
	0x0F120000,	/*0000	REG_1TC_PCFG_bSmearOutput	2   700001B0*/
	0x0F120000,	/*0000	REG_1TC_PCFG_SSaturation	2   700001B2*/
	0x0F120000,	/*0000	REG_1TC_PCFG_SSharpBlur		2   700001B4*/
	0x0F120000,	/*0000	REG_1TC_PCFG_SColorTemp		2   700001B6*/
	0x0F120000,	/*0000	REG_1TC_PCFG_uDeviceGammaIndex	2   700001B8*/
	0x0F120003,	/*0000	REG_1TC_PCFG_uPrevMirror	2   700001BA*/
	0x0F120003,	/*0000	REG_1TC_PCFG_uCaptureMirror	2   700001BC*/
	0x0F120000,	/*0000	REG_1TC_PCFG_uRotation		2   700001BE*/
	0x002A01C0,
	0x0F120280,	/*0320	REG_2TC_PCFG_uSWidth*/
	0x0F1201e0,	/*0258	REG_2TC_PCFG_uSHeight*/
	0x0F120005,	/*REG_2TC_PCFG_Format*/
	0x0F12222E,	/*REG_2TC_PCFG_uSMaxOut4KHzRate*/
	0x0F12222E,	/*REG_2TC_PCFG_uSMinOut4KHzRate*/
	0x0F120042,	/*REG_2TC_PCFG_PVIMaSk*/
	0x0F120010,	/*REG_2TC_PCFG_OIFMaSk*/
	0x0F120001,	/*REG_2TC_PCFG_uClockInd*/
	0x0F120000,	/*REG_2TC_PCFG_uSFrTimeType*/
	0x0F120001,	/*REG_2TC_PCFG_FrRateQualityType 1b: FR	(bin)
			2b: Quality (no-bin)*/
	0x0F1207D0,	/*REG_2TC_PCFG_uSMaxFrTimeMSecMult10max	frame time :
			30fpS 014D; 15fpS 029a; a6a - 3.75	fpS; 0535 -
			7.5FPS*/
	0x0F12029A,	/*REG_2TC_PCFG_uSMinFrTimeMSecMult10	2   700001D6*/
	0x0F120000,	/*REG_2TC_PCFG_bSmearOutput		2   700001D8*/
	0x0F120000,	/*REG_2TC_PCFG_SSaturation		2   700001DA*/
	0x0F120000,	/*REG_2TC_PCFG_SSharpBlur		2   700001DC*/
	0x0F120000,	/*REG_2TC_PCFG_SColorTemp		2   700001DE*/
	0x0F120000,	/*REG_2TC_PCFG_uDeviceGammaIndex	2   700001E0*/
	0x0F120003,	/*REG_2TC_PCFG_uPrevMirror		2   700001E2
			[0] : x [1]: Y [2] Stat X	[3] Stat Y*/
	0x0F120003,	/*REG_2TC_PCFG_uCaptureMirror		2   700001E4*/
	0x0F120000,	/*REG_2TC_PCFG_uRotation		2   700001E6*/
	0x002A01E8,
	0x0F120280,	/*0320		REG_3TC_PCFG_uSWidth	2   700001E8*/
	0x0F1201e0,	/*0258		REG_3TC_PCFG_uSHeight	2   700001EA*/
	0x0F120005,	/*REG_3TC_PCFG_Format			2   700001EC*/
	0x0F12222E,	/*REG_3TC_PCFG_uSMaxOut4KHzRate		2   700001EE*/
	0x0F12222E,	/*REG_3TC_PCFG_uSMinOut4KHzRate		2   700001F0*/
	0x0F120042,	/*REG_3TC_PCFG_PVIMaSk			2   700001F2*/
	0x0F120010,	/*REG_3TC_PCFG_OIFMaSk			2   700001F4*/
	0x0F120001,	/*REG_3TC_PCFG_uClockInd		2   700001F6*/
	0x0F120002,	/*REG_3TC_PCFG_uSFrTimeType		2   700001F8
			0: dynamic 1:fix not accurate 2: fixed_Accurate*/
	0x0F120001,	/*REG_3TC_PCFG_FrRateQualityType	2   700001FA*/
	0x0F120190,	/*REG_3TC_PCFG_uSMaxFrTimeMSecMult10	2   700001FC
			max frame time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F120000,	/*REG_3TC_PCFG_uSMinFrTimeMSecMult10	2   700001FE
			max frame time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F120000,	/*REG_3TC_PCFG_bSmearOutput		2   70000200*/
	0x0F120000,	/*REG_3TC_PCFG_SSaturation		2   70000202*/
	0x0F120000,	/*REG_3TC_PCFG_SSharpBlur		2   70000204*/
	0x0F120000,	/*REG_3TC_PCFG_SColorTemp		2   70000206*/
	0x0F120000,	/*REG_3TC_PCFG_uDeviceGammaIndex	2   70000208*/
	0x0F120003,	/*REG_3TC_PCFG_uPrevMirror		2   7000020A*/
	0x0F120003,	/*REG_3TC_PCFG_uCaptureMirror		2   7000020C*/
	0x0F120000,	/*REG_3TC_PCFG_uRotation		2   7000020E*/
	0x002A0238,
	0x0F120001,	/*REG_0TC_CCFG_uCaptureMode		2   70000238*/
	0x0F120640,	/*REG_0TC_CCFG_uSWidth			2   7000023A*/
	0x0F1204B0,	/*REG_0TC_CCFG_uSHeight			2   7000023C*/
	0x0F120005,	/*REG_0TC_CCFG_Format			2   7000023E*/
	0x0F12222E,	/*REG_0TC_CCFG_uSMaxOut4KHzRate		2   70000240*/
	0x0F12222E,	/*REG_0TC_CCFG_uSMinOut4KHzRate		2   70000242*/
	0x0F120042,	/*REG_0TC_CCFG_PVIMaSk			2   70000244*/
	0x0F120000,	/*REG_0TC_CCFG_OIFMaSk			2   70000246*/
	0x0F120001,	/*REG_0TC_CCFG_uClockInd		2   70000248*/
	0x0F120002,	/*REG_0TC_CCFG_uSFrTimeType		2   7000024A*/
	0x0F120002,	/*REG_0TC_CCFG_FrRateQualityType	2   7000024C*/
	0x0F120514,	/*0535	REG_0TC_CCFG_uSMaxFrTimeMSecMult10
								2   7000024E*/
	0x0F120514,	/*0535	REG_0TC_CCFG_uSMinFrTimeMSecMult10
								2   70000250*/
	0x0F120000,	/*REG_0TC_CCFG_bSmearOutput		2   70000252*/
	0x0F120000,	/*REG_0TC_CCFG_SSaturation		2   70000254*/
	0x0F120000,	/*REG_0TC_CCFG_SSharpBlur		2   70000256*/
	0x0F120000,	/*REG_0TC_CCFG_SColorTemp		2   70000258*/
	0x0F120000,	/*REG_0TC_CCFG_uDeviceGammaIndex	2   7000025A*/
	0x0F120001,	/*REG_1TC_CCFG_uCaptureMode		2   7000025C*/
	0x0F120640,	/*REG_1TC_CCFG_uSWidth			2   7000025E*/
	0x0F1204B0,	/*REG_1TC_CCFG_uSHeight			2   70000260*/
	0x0F120005,	/*REG_1TC_CCFG_Format			2   70000262*/
	0x0F12445C,	/*222E	REG_1TC_CCFG_uSMaxOut4KHzRate	2   70000264*/
	0x0F12445C,	/*222E	REG_1TC_CCFG_uSMinOut4KHzRate	2   70000266*/
	0x0F120042,	/*REG_1TC_CCFG_PVIMaSk			2   70000268*/
	0x0F120010,	/*0000	REG_1TC_CCFG_OIFMaSk		2   7000026A*/
	0x0F120000,/*0001	REG_1TC_CCFG_uClockInd		2   7000026C*/
	0x0F120000,	/*REG_1TC_CCFG_uSFrTimeType		2   7000026E*/
	0x0F120002,	/*REG_1TC_CCFG_FrRateQualityType	2   70000270*/
	0x0F121388,	/*REG_1TC_CCFG_uSMaxFrTimeMSecMult10	2   70000272*/
	0x0F121388,	/*REG_1TC_CCFG_uSMinFrTimeMSecMult10	2   70000274*/
	0x0F120000,	/*REG_1TC_CCFG_bSmearOutput		2   70000276*/
	0x0F120000,	/*REG_1TC_CCFG_SSaturation		2   70000278*/
	0x0F120000,	/*REG_1TC_CCFG_SSharpBlur		2   7000027A*/
	0x0F120000,	/*REG_1TC_CCFG_SColorTemp		2   7000027C*/
	0x0F120000,	/*REG_1TC_CCFG_uDeviceGammaIndex	2   7000027E*/
	0x002A1218,
	0x0F120002,		/*SenHal_SenBinFactor*/
	0xFFFF0064,
	0x00287000,
	0x002A0CC0,
	0x0F120001,	/*AFC_Default BIT[0]  1:60Hz 0:50Hz*/
	0x002A0374,
	0x0F12067F,	/*REG_TC_DBG BIT[5] : Auto Flicker Disable*/

	/*Int Time limit*/
	0x00287000,
	0x002A1220,
	0x0F1201B7, /*senHal_ExpMinPixels*/



	0x002A10C0,
	0x0F120040,	/*TVAR_ae_BrAve*/
	0x002A10C6,
	0x0F12000F,	/*ae_StatMode*/
	0x002A03B2,
	0x0F12010E,	/*lt_uLimitHigh*/
	0x0F1200F5,	/*lt_uLimitLow*/
	0x002A03C4,
	0x0F123415,	/*lt_uMaxExp1 3415h=13333d/400d=33.3325ms*/
	0x002A03C8,
	0x0F12681F,	/*lt_uMaxExp2 681Fh=26655d/400d=66.6375ms*/
	0x002A03CC,
	0x0F128227,	/*lt_uMaxExp3 8227h=33319d/400d=83.2975ms*/
	0x002A03D0,
	0x0F120D40,	/*lt_uMaxExp4 30D40h=50000d/400d=500ms*/
	0x0F120003,
	0x002A03D4,
	0x0F123415,	/*lt_uCapMaxExp1 3415h=13333d/400d=33.3325ms*/
	0x002A03D8,
	0x0F12681F,	/*lt_uCapMaxExp2 681Fh=26655d/400d=66.6375ms*/
	0x002A03DC,
	0x0F128227,	/*lt_uCapMaxExp3 8227h=33319d/400d=83.2975ms*/
	0x002A03E0,
	0x0F120D40,	/*lt_uCapMaxExp4 30D40h=50000d/400d=500ms*/
	0x0F120003,
	0x002A03E4,
	0x0F120230,	/*lt_uMaxAnGain1 0230h=0560d/256d=x2.1875*/
	0x0F120260,	/*lt_uMaxAnGain2 0260h=0608d/256d=x2.375*/
	0x0F120370,	/*lt_uMaxAnGain3 0370h=0704d/256d=x3.4375*/
	0x0F120880,	/*lt_uMaxAnGain4 0710h=2176d/256d=x8.5*/
	0x0F120100,	/*lt_uMaxDigGain*/
	0x0F128000,	/*lt_uMaxTotGain*/
	0x0F120230,	/*lt_uCapMaxAnGain1 0230h=0560d/256d=x2.1875*/
	0x0F120260,	/*lt_uCapMaxAnGain2 0260h=0608d/256d=x2.375*/
	0x0F120380,	/*lt_uCapMaxAnGain3 0370h=0704d/256d=x3.4375*/
	0x0F120880,	/*lt_uCapMaxAnGain4 0710h=2176d/256d=x8.5*/
	0x0F120100,	/*lt_uCapMaxDigGain*/
	0x0F128000,	/*lt_uCapMaxTotGain*/
	0x002A10CE,
	0x0F120000,	/*ae_WeightTbl_16[0]*/
	0x0F120101,	/*ae_WeightTbl_16[1]*/
	0x0F120101,	/*ae_WeightTbl_16[2]*/
	0x0F120000,	/*ae_WeightTbl_16[3]*/
	0x0F120101,	/*ae_WeightTbl_16[4]*/
	0x0F120101,	/*ae_WeightTbl_16[5]*/
	0x0F120101,	/*ae_WeightTbl_16[6]*/
	0x0F120101,	/*ae_WeightTbl_16[7]*/
	0x0F120201,	/*ae_WeightTbl_16[8]*/
	0x0F120303,	/*ae_WeightTbl_16[9]*/
	0x0F120303,	/*ae_WeightTbl_16[10]*/
	0x0F120102,	/*ae_WeightTbl_16[11]*/
	0x0F120201,	/*ae_WeightTbl_16[12]*/
	0x0F120403,	/*ae_WeightTbl_16[13]*/
	0x0F120304,	/*ae_WeightTbl_16[14]*/
	0x0F120102,	/*ae_WeightTbl_16[15]*/
	0x0F120201,	/*ae_WeightTbl_16[16]*/
	0x0F120403,	/*ae_WeightTbl_16[17]*/
	0x0F120304,	/*ae_WeightTbl_16[18]*/
	0x0F120102,	/*ae_WeightTbl_16[19]*/
	0x0F120201,	/*ae_WeightTbl_16[20]*/
	0x0F120403,	/*ae_WeightTbl_16[21]*/
	0x0F120304,	/*ae_WeightTbl_16[22]*/
	0x0F120102,	/*ae_WeightTbl_16[23]*/
	0x0F120201,	/*ae_WeightTbl_16[24]*/
	0x0F120303,	/*ae_WeightTbl_16[25]*/
	0x0F120303,	/*ae_WeightTbl_16[26]*/
	0x0F120102,	/*ae_WeightTbl_16[27]*/
	0x0F120201,	/*ae_WeightTbl_16[28]*/
	0x0F120202,	/*ae_WeightTbl_16[29]*/
	0x0F120202,	/*ae_WeightTbl_16[30]*/
	0x0F120102,	/*ae_WeightTbl_16[31]*/
	0x002A0DCC,	/*AWB Init White Locus*/
	0x0F120138,	/*awbb_IntcR*/
	0x0F12011C,	/*awbb_IntcB*/
	0x0F1202A7,	/*awbb_GLocusR*/
	0x0F120343,	/*awbb_GLocusB*/
	0x002A0DEC,
	0x0F1205F0,	/*awbb_GamutWidthThr1*/
	0x0F1201F4,	/*awbb_GamutHeightThr1*/
	0x0F12006C,	/*awbb_GamutWidthThr2*/
	0x0F120038,	/*awbb_GamutHeightThr2*/
	0x002A0DD8,
	0x0F12000C,	/*awbb_MinNumOfFinalPatches*/
	0x002A0E50,
	0x0F12FE82,	/*awbb_SCDetectionMap_SEC_StartR_B*/
	0x0F12001E,	/*awbb_SCDetectionMap_SEC_StepR_B*/
	0x0F120640,	/*awbb_SCDetectionMap_SEC_SunnyNB*/
	0x0F120122,	/*awbb_SCDetectionMap_SEC_StepNB*/
	0x0F1200E4,	/*awbb_SCDetectionMap_SEC_LowTempR_B*/
	0x0F120096,	/*awbb_SCDetectionMap_SEC_SunnyNBZone*/
	0x0F12000E,	/*awbb_SCDetectionMap_SEC_LowTempR_BZone*/
	0x002A0DB4,	/*LowTemp Zone*/
	0x0F12036C,	/*awbb_CrclLowT_R_c*/
	0x002A0DB8,
	0x0F12011D,	/*awbb_CrclLowT_B_c*/
	0x002A0DBC,
	0x0F1262C1,	/*awbb_CrclLowT_Rad_c*/
	0x002A22BA,
	0x0F120006,	/*Mon_AWB_ByPassMode*/
	0x002A0DEA,
	0x0F120000,	/*awbb_movingscale10*/
	0x002A0F7A,
	0x0F120000,	/*awbb_RGainOff*/
	0x0F120000,	/*awbb_BGainOff*/
	0x0F120000,	/*awbb_GGainOff*/
	0x0F1200C2,	/*awbb_Alpha_Comp_Mode*/
	0x0F120002,	/*awbb_Rpl_InvalidOutDoor*/
	0x0F120001,	/*awbb_UseGrThrCorr*/
	0x0F1200E4,	/*awbb_Use_Filters*/

	0x0F12053C,	/*awbb_GainsInit[0]*/
	0x0F120400,	/*awbb_GainsInit[1]*/
	0x0F1207ac,	/*7AC,	55C,	awbb_GainsInit[2]*/

	0x0F12001E,	/*awbb_WpFilterMinThr*/
	0x0F120190,	/*awbb_WpFilterMaxThr*/
	0x0F120064,	/*awbb_WpFilterCoef*/

	0x0F120004,	/*awbb_WpFilterSize*/
	0x0F120001,	/*awbb_otp_disable*/
	0x0F120002,	/*awbb_GridEnable*/
	0x002A0CE0,
	0x0F1203F8,	/*03F8	03B5	awbb_IndoorGrZones_m_BGrid[0]*/
	0x0F120422,	/*0422	03DF	awbb_IndoorGrZones_m_BGrid[1]*/
	0x0F120390,	/*03B4	032D	awbb_IndoorGrZones_m_BGrid[2]*/
	0x0F12042A,	/*0408	03D5	awbb_IndoorGrZones_m_BGrid[3]*/
	0x0F120352,	/*0370	0303	awbb_IndoorGrZones_m_BGrid[4]*/
	0x0F12041E,	/*03EE	03BB	awbb_IndoorGrZones_m_BGrid[5]*/
	0x0F120318,	/*032C	02DB	awbb_IndoorGrZones_m_BGrid[6]*/
	0x0F1203DC,	/*03FC,	03D4	0397	awbb_IndoorGrZones_m_BGrid[7]*/
	0x0F1202E4,	/*02E4,	0302	02B1	awbb_IndoorGrZones_m_BGrid[8]*/
	0x0F12039C,	/*03BA,	03BA	036B	awbb_IndoorGrZones_m_BGrid[9]*/
	0x0F1202B8,	/*02B8,	02DA	0289	awbb_IndoorGrZones_m_BGrid[10]*/
	0x0F120368,	/*037E,	0374	0349	awbb_IndoorGrZones_m_BGrid[11]*/
	0x0F120290,	/*0290,	02B0	026F	awbb_IndoorGrZones_m_BGrid[12]*/
	0x0F12033E,	/*034A,	0328	0329	awbb_IndoorGrZones_m_BGrid[13]*/
	0x0F120274,	/*0274,	0288	0257	awbb_IndoorGrZones_m_BGrid[14]*/
	0x0F120316,	/*031A,	0300	0309	awbb_IndoorGrZones_m_BGrid[15]*/
	0x0F120252,	/*0270	0241	awbb_IndoorGrZones_m_BGrid[16]*/
	0x0F1202F8,	/*02DE	02DD	awbb_IndoorGrZones_m_BGrid[17]*/
	0x0F120232,	/*0258	0227	awbb_IndoorGrZones_m_BGrid[18]*/
	0x0F1202E0,	/*02BE	02C3	awbb_IndoorGrZones_m_BGrid[19]*/
	0x0F12021E,	/*0240	0213	awbb_IndoorGrZones_m_BGrid[20]*/
	0x0F1202C8,	/*02A0	02AF	awbb_IndoorGrZones_m_BGrid[21]*/
	0x0F120206,	/*0228	0209	awbb_IndoorGrZones_m_BGrid[22]*/
	0x0F1202B2,	/*0296	0295	awbb_IndoorGrZones_m_BGrid[23]*/
	0x0F1201FA,	/*0212	020D	awbb_IndoorGrZones_m_BGrid[24]*/
	0x0F1202A2,	/*0284	0285	awbb_IndoorGrZones_m_BGrid[25]*/
	0x0F1201F4,	/*0208	0223	awbb_IndoorGrZones_m_BGrid[26]*/
	0x0F120294,	/*0274	0261	awbb_IndoorGrZones_m_BGrid[27]*/
	0x0F120200,	/*020C	0000	awbb_IndoorGrZones_m_BGrid[28]*/
	0x0F120288,	/*026E	0000	awbb_IndoorGrZones_m_BGrid[29]*/
	0x0F120214,	/*0222	0000	awbb_IndoorGrZones_m_BGrid[30]*/
	0x0F120250,	/*0260	0000	awbb_IndoorGrZones_m_BGrid[31]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[32]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[33]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[34]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[35]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[36]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[37]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[38]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[39]*/
	0x0F120005,	/*awbb_IndoorGrZones_m_GridStep*/
	0x002A0D34,
	0x0F120010,	/*awbb_IndoorGrZones_ZInfo_m_GridSz*/
	0x002A0D38,
	0x0F1200FE,	/*awbb_IndoorGrZones_m_Boff*/
	0x002A0D3C,
	0x0F120294,	/*0294	02A4 02B0	02B6	02B8	02A2	02B8
			029F	awbb_OutdoorGrZones_m_BGrid[0]*/
	0x0F1202F2,	/*02F2	02F2 02F0	02F2	02F2	02D4	02F2
			02CE	awbb_OutdoorGrZones_m_BGrid[1]*/
	0x0F120276,	/*0276	0276 028A	0276	028E	0282	028E
			0282	awbb_OutdoorGrZones_m_BGrid[2]*/
	0x0F12030A,	/*030A	030A 02FC	030A	030A	02EE	030A
			02DA	awbb_OutdoorGrZones_m_BGrid[3]*/
	0x0F120258,	/*0258	0258 026C	0258	026E	027A	027A
			026D	awbb_OutdoorGrZones_m_BGrid[4]*/
	0x0F12030A,	/*0302	0302 030A	0302	030A	030A	030A
			02C2	awbb_OutdoorGrZones_m_BGrid[5]*/
	0x0F120246,	/*0246	0246 0258	0246	025E	027A	0274
			0256	awbb_OutdoorGrZones_m_BGrid[6]*/
	0x0F1202FA,	/*02EA	02EA 0302	02EA	02FE	030A	02FE
			02A6	awbb_OutdoorGrZones_m_BGrid[7]*/
	0x0F120256,	/*0256	0256 0246	0256	0264	0274	0282
			026E	awbb_OutdoorGrZones_m_BGrid[8]*/
	0x0F1202DC,	/*02B8	02B8 02EA	02B8	02D0	02FE	02DC
			028A	awbb_OutdoorGrZones_m_BGrid[9]*/
	0x0F120000,	/*0000	0000 0256	0000	0000	0282	0000
			0000	awbb_OutdoorGrZones_m_BGrid[10]*/
	0x0F120000,	/*0000	0000 02B8	0000	0000	02DC	0000
			0000	awbb_OutdoorGrZones_m_BGrid[11]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[12]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[13]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[14]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[15]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[16]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[17]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[18]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[19]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[20]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[21]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[22]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[23]*/
	0x0F120005,	/*awbb_OutdoorGrZones_m_GridStep*/
	0x002A0D70,
	0x0F120005,	/*awbb_OutdoorGrZones_ZInfo_m_GridSz*/
	0x002A0D74,
	0x0F1201EB,	/*awbb_OutdoorGrZones_m_Boffs*/
	0x002A0D78,
	0x0F1203CE,	/*awbb_LowBrGrZones_m_BGrid[0]*/
	0x0F12046E,	/*awbb_LowBrGrZones_m_BGrid[1]*/
	0x0F12034E,	/*awbb_LowBrGrZones_m_BGrid[2]*/
	0x0F120474,	/*awbb_LowBrGrZones_m_BGrid[3]*/
	0x0F1202EA,	/*awbb_LowBrGrZones_m_BGrid[4]*/
	0x0F120434,	/*awbb_LowBrGrZones_m_BGrid[5]*/
	0x0F12028C,	/*awbb_LowBrGrZones_m_BGrid[6]*/
	0x0F1203F0,	/*awbb_LowBrGrZones_m_BGrid[7]*/
	0x0F120244,	/*awbb_LowBrGrZones_m_BGrid[8]*/
	0x0F120380,	/*awbb_LowBrGrZones_m_BGrid[9]*/
	0x0F12020E,	/*awbb_LowBrGrZones_m_BGrid[10]*/
	0x0F120330,	/*awbb_LowBrGrZones_m_BGrid[11]*/
	0x0F1201EC,	/*awbb_LowBrGrZones_m_BGrid[12]*/
	0x0F1202EC,	/*awbb_LowBrGrZones_m_BGrid[13]*/
	0x0F1201D0,	/*awbb_LowBrGrZones_m_BGrid[14]*/
	0x0F1202BC,	/*awbb_LowBrGrZones_m_BGrid[15]*/
	0x0F1201C8,	/*awbb_LowBrGrZones_m_BGrid[16]*/
	0x0F120296,	/*awbb_LowBrGrZones_m_BGrid[17]*/
	0x0F1201D2,	/*awbb_LowBrGrZones_m_BGrid[18]*/
	0x0F120266,	/*awbb_LowBrGrZones_m_BGrid[19]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[20]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[21]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[22]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[23]*/
	0x0F120006,	/*awbb_LowBrGrZones_m_GridStep*/
	0x002A0DAC,
	0x0F12000A,	/*awbb_LowBrGrZones_ZInfo_m_GridSz*/
	0x002A0DB0,
	0x0F1200E2,	/*awbb_LowBrGrZones_m_Boffs*/
	0x002A0F60,
	0x0F1202E2,	/*awbb_GridConst_1[0]*/
	0x0F12034B,	/*awbb_GridConst_1[1]*/
	0x0F120399,	/*awbb_GridConst_1[2]*/
	0x0F12102D,	/*awbb_GridConst_2[0]*/
	0x0F1210DE,	/*awbb_GridConst_2[1]*/
	0x0F12116E,	/*awbb_GridConst_2[2]*/
	0x0F12117B,	/*awbb_GridConst_2[3]*/
	0x0F12120A,	/*11FF	awbb_GridConst_2[4]*/
	0x0F121247,	/*awbb_GridConst_2[5]*/
	0x0F1202C4,	/*awbb_GridCoeff_R_1*/
	0x0F1202E4,	/*awbb_GridCoeff_B_1*/
	0x0F1200C3,	/*awbb_GridCoeff_R_2*/
	0x0F1200A6,	/*awbb_GridCoeff_B_2*/
	0x002A0ED0,

	0x0F120046,	/*0046,	0046	000A	000A	awbb_GridCorr_R[0][0]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[0][1]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[0][2]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[0][3]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[0][4]*/
	0x0F120028,	/*0028,	0028	0000	001E	awbb_GridCorr_R[0][5]*/
	0x0F120046,	/*0046,	0046	000A	000A	awbb_GridCorr_R[1][0]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[1][1]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[1][2]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[1][3]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[1][4]*/
	0x0F120028,	/*0028,	0028	0000	001E	awbb_GridCorr_R[1][5]*/
	0x0F120046,	/*0046,	0046	000A	000A	awbb_GridCorr_R[2][0]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[2][1]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[2][2]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[2][3]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[2][4]*/
	0x0F120028,	/*0028,	0028	0000	001E	awbb_GridCorr_R[2][5]*/
	0x0F12FFD8,	/*FFD8,	FFD8	FFD8	FFD8	awbb_GridCorr_B[0][0]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[0][1]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[0][2]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[0][3]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[0][4]*/
	0x0F12FF9C,	/*FF9C,	FF9C	FE70	001E	awbb_GridCorr_B[0][5]*/
	0x0F12FFD8,	/*FFD8,	FFD8	FFD8	FFD8	awbb_GridCorr_B[1][0]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[1][1]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[1][2]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[1][3]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[1][4]*/
	0x0F12FF9C,	/*FF9C,	FF9C	FE70	001E	awbb_GridCorr_B[1][5]*/
	0x0F12FFD8,	/*FFD8,	FFD8	FFD8	FFD8	awbb_GridCorr_B[2][0]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[2][1]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[2][2]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[2][3]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[2][4]*/
	0x0F12FF9C,	/*FF9C,	FF9C	FE70	001E	awbb_GridCorr_B[2][5]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][0]*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[0][1]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][2]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][3]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][4]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][5]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][0]*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[1][1]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][2]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][3]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][4]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][5]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][0]*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[2][1]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][2]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][3]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][4]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][5]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][0]*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[0][1]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][2]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][3]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][4]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][5]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][0]*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[1][1]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][2]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][3]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][4]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][5]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][0]*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[2][1]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][2]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][3]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][4]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][5]*/
	0x002A05D2,
	0x0F1200E4,	/*SARR_AwbCcmCord[0]*/
	0x0F1200F0,	/*SARR_AwbCcmCord[1]*/
	0x0F120100,	/*SARR_AwbCcmCord[2]*/
	0x0F120120,	/*SARR_AwbCcmCord[3]*/
	0x0F120150,	/*SARR_AwbCcmCord[4]*/
	0x0F120180,	/*SARR_AwbCcmCord[5]*/
	0x002A05C4,
	0x0F123800,	/*TVAR_wbt_pBaseCcms*/
	0x0F127000,
	0x002A05CC,
	0x0F1238D8,	/*TVAR_wbt_pOutdoorCcm*/
	0x0F127000,
	0x002A3800,
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[0]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[1]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[2]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[3]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[4]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[5]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[6]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[7]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[8]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[9]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[10]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[11]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[12]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[13]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[14]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[15]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[16]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[17]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[18]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[19]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[20]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[21]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[22]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[23]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[24]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[25]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[26]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[27]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[28]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[29]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[30]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[31]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[32]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[33]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[34]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[35]*/
	0x0F1201C4,	/*01D3	01D0	TVAR_wbt_pBaseCcms[36]*/
	0x0F12FFAC,	/*FFBB	FFA1	TVAR_wbt_pBaseCcms[37]*/
	0x0F12FFFB,	/*FFDD	FFFA	TVAR_wbt_pBaseCcms[38]*/
	0x0F12FF6F,	/*FF6F	FF6F	TVAR_wbt_pBaseCcms[39]*/
	0x0F120140,	/*0140	0140	TVAR_wbt_pBaseCcms[40]*/
	0x0F12FF49,	/*FF49	FF49	TVAR_wbt_pBaseCcms[41]*/
	0x0F12FFC1,	/*FFC1	FFC1	TVAR_wbt_pBaseCcms[42]*/
	0x0F12001F,	/*001F	001F	TVAR_wbt_pBaseCcms[43]*/
	0x0F1201BD,	/*01BD	01BD	TVAR_wbt_pBaseCcms[44]*/
	0x0F12013F,	/*013F	013F	TVAR_wbt_pBaseCcms[45]*/
	0x0F1200E1,	/*00E1	00E1	TVAR_wbt_pBaseCcms[46]*/
	0x0F12FF43,	/*FF43	FF43	TVAR_wbt_pBaseCcms[47]*/
	0x0F120191,	/*0191	0191	TVAR_wbt_pBaseCcms[48]*/
	0x0F12FFC0,	/*FFC0	FFC0	TVAR_wbt_pBaseCcms[49]*/
	0x0F1201B7,	/*01B7	01B7	TVAR_wbt_pBaseCcms[50]*/
	0x0F12FF30,	/*FF30	FF30	TVAR_wbt_pBaseCcms[51]*/
	0x0F12015F,	/*015F	015F	TVAR_wbt_pBaseCcms[52]*/
	0x0F120106,	/*0106	0106	TVAR_wbt_pBaseCcms[53]*/
	0x0F1201B5,	/*01C6,	01D0	TVAR_wbt_pBaseCcms[54]*/
	0x0F12FFC6,	/*FFBE,	FFA1	TVAR_wbt_pBaseCcms[55]*/
	0x0F12FFEF,	/*FFE6,	FFFA	TVAR_wbt_pBaseCcms[56]*/
	0x0F12FF6F,	/*FF6F,	FF6F	TVAR_wbt_pBaseCcms[57]*/
	0x0F120140,	/*0140,	0140	TVAR_wbt_pBaseCcms[58]*/
	0x0F12FF49,	/*FF49,	FF49	TVAR_wbt_pBaseCcms[59]*/
	0x0F12FFC1,	/*FFC1,	FFC1	TVAR_wbt_pBaseCcms[60]*/
	0x0F12001F,	/*001F,	001F	TVAR_wbt_pBaseCcms[61]*/
	0x0F1201BD,	/*01BD,	01BD	TVAR_wbt_pBaseCcms[62]*/
	0x0F12013F,	/*013F,	013F	TVAR_wbt_pBaseCcms[63]*/
	0x0F1200E1,	/*00E1,	00E1	TVAR_wbt_pBaseCcms[64]*/
	0x0F12FF43,	/*FF43,	FF43	TVAR_wbt_pBaseCcms[65]*/
	0x0F120191,	/*0191,	0191	TVAR_wbt_pBaseCcms[66]*/
	0x0F12FFC0,	/*FFC0,	FFC0	TVAR_wbt_pBaseCcms[67]*/
	0x0F1201B7,	/*01B7,	01B7	TVAR_wbt_pBaseCcms[68]*/
	0x0F12FF30,	/*FF30,	FF30	TVAR_wbt_pBaseCcms[69]*/
	0x0F12015F,	/*015F,	015F	TVAR_wbt_pBaseCcms[70]*/
	0x0F120106,	/*0106,	0106	TVAR_wbt_pBaseCcms[71]*/
	0x0F1201B7,	/*C8	01BF	TVAR_wbt_pBaseCcms[72]*/
	0x0F12FFC4,	/*FFBA	FFBF	TVAR_wbt_pBaseCcms[73]*/
	0x0F120001,	/*FFE8	FFFE	TVAR_wbt_pBaseCcms[74]*/
	0x0F12FF6D,	/*FF6D	FF6F	FF6D	TVAR_wbt_pBaseCcms[75]*/
	0x0F1201B4,	/*01B4	0140	01B4	TVAR_wbt_pBaseCcms[76]*/
	0x0F12FF66,	/*FF66	FF49	FF66	TVAR_wbt_pBaseCcms[77]*/
	0x0F12FFCA,	/*FFCA	FFC1	FFCA	TVAR_wbt_pBaseCcms[78]*/
	0x0F12FFCE,	/*FFCE	001F	FFCE	TVAR_wbt_pBaseCcms[79]*/
	0x0F12017B,	/*017B	01BD	017B	TVAR_wbt_pBaseCcms[80]*/
	0x0F120136,	/*0136	013F	0136	TVAR_wbt_pBaseCcms[81]*/
	0x0F120132,	/*0132	00E1	0132	TVAR_wbt_pBaseCcms[82]*/
	0x0F12FF85,	/*FF85	FF43	FF85	TVAR_wbt_pBaseCcms[83]*/
	0x0F12018B,	/*018B	0191	018B	TVAR_wbt_pBaseCcms[84]*/
	0x0F12FF73,	/*FF73	FFC0	FF73	TVAR_wbt_pBaseCcms[85]*/
	0x0F120191,	/*0191	01B7	0191	TVAR_wbt_pBaseCcms[86]*/
	0x0F12FF3F,	/*FF3F	FF30	FF3F	TVAR_wbt_pBaseCcms[87]*/
	0x0F12015B,	/*015B	015F	015B	TVAR_wbt_pBaseCcms[88]*/
	0x0F1200D0,	/*00D0	0106	00D0	TVAR_wbt_pBaseCcms[89]*/
	0x0F1201CA,	/*01CA	01C1	TVAR_wbt_pBaseCcms[90]*/
	0x0F12FFBE,	/*FFBE	FFC5	TVAR_wbt_pBaseCcms[91]*/
	0x0F12FFF1,	/*FFF1	FFF5	TVAR_wbt_pBaseCcms[92]*/
	0x0F12FEFB,	/*FF15	FF3B	TVAR_wbt_pBaseCcms[93]*/
	0x0F12021C,	/*01F3	0217	TVAR_wbt_pBaseCcms[94]*/
	0x0F12FF6B,	/*FF7B	FF32	TVAR_wbt_pBaseCcms[95]*/
	0x0F12FFC1,	/*FFC1	FFC1	TVAR_wbt_pBaseCcms[96]*/
	0x0F12FFC5,	/*FFC5	FFC5	TVAR_wbt_pBaseCcms[97]*/
	0x0F12018A,	/*018A	018B	TVAR_wbt_pBaseCcms[98]*/
	0x0F1200FB,	/*00FB	0136	TVAR_wbt_pBaseCcms[99]*/
	0x0F120167,	/*0167	0132	TVAR_wbt_pBaseCcms[100]*/
	0x0F12FF8C,	/*FF8C	FF85	TVAR_wbt_pBaseCcms[101]*/
	0x0F12018B,	/*018B	018B	TVAR_wbt_pBaseCcms[102]*/
	0x0F12FF73,	/*FF73	FF73	TVAR_wbt_pBaseCcms[103]*/
	0x0F120191,	/*0191	0191	TVAR_wbt_pBaseCcms[104]*/
	0x0F12FF3F,	/*FF3F	FF3F	TVAR_wbt_pBaseCcms[105]*/
	0x0F12015B,	/*015B	015B	TVAR_wbt_pBaseCcms[106]*/
	0x0F1200D0,	/*00D0	00D0	TVAR_wbt_pBaseCcms[107]*/
	0x002A38D8,
	0x0F120221,	/*022C	0235	TVAR_wbt_pOutdoorCcm[0]*/
	0x0F120005,	/*FFD8	FFEF	TVAR_wbt_pOutdoorCcm[1]*/
	0x0F120012,	/*0034	0014	TVAR_wbt_pOutdoorCcm[2]*/
	0x0F12FF67,	/*FF67	FF67	TVAR_wbt_pOutdoorCcm[3]*/
	0x0F12027D,	/*027D	027D	TVAR_wbt_pOutdoorCcm[4]*/
	0x0F12FFBA,	/*FFBA	FFBA	TVAR_wbt_pOutdoorCcm[5]*/
	0x0F12000D,	/*000D	000D	TVAR_wbt_pOutdoorCcm[6]*/
	0x0F120062,	/*0062	0062	TVAR_wbt_pOutdoorCcm[7]*/
	0x0F1202A7,	/*02A7	02A7	TVAR_wbt_pOutdoorCcm[8]*/
	0x0F1200C7,	/*00C7	00C9	TVAR_wbt_pOutdoorCcm[9]*/
	0x0F12011F,	/*011F	0123	TVAR_wbt_pOutdoorCcm[10]*/
	0x0F12FF3C,	/*FF3C	FF36	TVAR_wbt_pOutdoorCcm[11]*/
	0x0F1201AD,	/*01AD	01AD	TVAR_wbt_pOutdoorCcm[12]*/
	0x0F12FFC8,	/*FFC8	FFC8	TVAR_wbt_pOutdoorCcm[13]*/
	0x0F120202,	/*0202	0202	TVAR_wbt_pOutdoorCcm[14]*/
	0x0F12FFCF,	/*FFCF	FFCF	TVAR_wbt_pOutdoorCcm[15]*/
	0x0F120257,	/*0257	0257	TVAR_wbt_pOutdoorCcm[16]*/
	0x0F12022C,	/*022C	022C	TVAR_wbt_pOutdoorCcm[17]*/
	0x002A23DC,
	0x0F1201DD,	/*Mon_AAIO_PrevFrmData_NormBr*/
	0x002A0460,
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[0][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[0][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[0][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[0][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[0][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[0][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[0][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[0][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[0][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[0][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[0][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[0][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[0][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[0][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[0][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[0][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[0][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[0][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[0][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[0][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[1][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[1][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[1][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[1][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[1][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[1][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[1][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[1][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[1][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[1][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[1][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[1][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[1][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[1][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[1][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[1][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[1][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[1][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[1][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[1][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[2][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[2][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[2][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[2][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[2][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[2][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[2][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[2][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[2][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[2][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[2][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[2][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[2][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[2][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[2][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[2][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[2][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[2][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[2][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[2][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[0][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[0][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[0][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[0][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[0][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[0][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[0][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[0][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[0][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[0][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[0][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[0][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[0][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[0][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[0][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[0][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[0][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[0][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[0][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[0][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[1][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[1][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[1][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[1][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[1][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[1][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[1][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[1][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[1][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[1][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[1][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[1][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[1][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[1][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[1][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[1][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[1][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[1][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[1][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[1][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[2][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[2][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[2][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[2][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[2][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[2][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[2][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[2][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[2][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[2][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[2][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[2][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[2][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[2][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[2][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[2][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[2][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[2][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[2][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[2][19]*/
	0x002A065C,
	0x0F12003F,	/*afit_uNoiseIndInDoor_0_*/
	0x0F120041,	/*afit_uNoiseIndInDoor_1_*/
	0x0F1200CB,	/*afit_uNoiseIndInDoor_2_*/
	0x0F1201E0,	/*afit_uNoiseIndInDoor_3_*/
	0x0F120220,	/*afit_uNoiseIndInDoor_4_*/
	0x002A3780,
	0x0F120000,	/*on/off AFIT by NB option*/
	0x0F120014,	/*SARR_uNormBrInDoor*/
	0x0F1200D2,	/*SARR_uNormBrInDoor*/
	0x0F120384,	/*SARR_uNormBrInDoor*/
	0x0F1207D0,	/*SARR_uNormBrInDoor*/
	0x0F121388,	/*SARR_uNormBrInDoor*/
	0x002A06BC,
	0x0F120000,	/*AFIT16_BRIGHTNESS*/
	0x0F120000,	/*AFIT16_CONTRAST*/
	0x0F120014,	/*AFIT16_SATURATION*/
	0x0F120000,	/*AFIT16_SHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F12005A,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F12001E,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F12001E,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201F4,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120005,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120005,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F12001E,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F120A3B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F12001E,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120002,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128003,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F121982,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120B80,	/*0A80	AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F124601,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F126444,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F129650,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F121E00,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121464,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121404,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F120F14,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F121403,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120114,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F124446,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F122832,	/*5064	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F12141E,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F126407,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120414,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A0A,	/*1414	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120F0F,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F124601,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F126E44,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122864,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121E00,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F120004,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120F00,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120014,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F12005A,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F120064,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F120064,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F12001E,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120005,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120002,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128003,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120A6E,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F122801,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F12231E,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12961E,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A02,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120764,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F12143C,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121401,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F120F14,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F121E28,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120A0C,	/*1419	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F120200,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123C07,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A0A,	/*1414	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120F0F,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F121E1E,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F123C01,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F125A3A,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122858,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121E00,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F120004,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120F00,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120000,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F12005A,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F12001E,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120005,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120001,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128002,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120080,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122A03,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A02,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120864,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F129601,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F122814,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400A,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F12191B,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12070C,	/*0F19	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F12021E,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123208,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A28,	/*1450	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120A28,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F122828,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F122401,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F123622,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122832,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121003,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121E04,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F125004,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120F40,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120000,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F1200C8,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F120050,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12002D,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F120019,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],AFIT8_sddd8a_repl_thresh
			[15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],AFIT8_sddd8a_sat_level
			[15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],AFIT8_sddd8a_sat_mpl
			[15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F12033B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120005,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120001,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128002,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120080,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122003,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A02,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120864,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F122814,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400A,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F12191B,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12070C,	/*0F19	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F12021E,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123208,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A28,	/*1450	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120A28,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F123C3C,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F121E01,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F12221C,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F12281E,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121402,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F12060E,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F125204,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120C40,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F124015,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120000,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F120032,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F12028A,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120032,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F1201F4,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120002,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201AA,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F12003C,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120050,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F120046,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F120019,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F120503,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F12080F,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120808,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F12022D,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12061E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120606,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A03,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120028,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120002,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120001,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128001,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120080,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F121219,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12320D,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120A0A,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122304,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A08,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120832,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F122A0A,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F124006,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120604,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125006,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F12191B,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12070C,	/*0F19	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120A28,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F12040A,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F120820,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F12280A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123208,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120532,	/*0A64	AFIT8_Sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F12062A,	/*AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120606,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F124646,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F121801,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F12191C,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122818,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121405,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F12050C,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F125204,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F121440,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F124015,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F127DFA,	/*ConstAfitBaseVals*/
	0x0F12FFBD,	/*ConstAfitBaseVals_1_*/
	0x0F1226FE,	/*ConstAfitBaseVals_2_*/
	0x0F12F7BC,	/*ConstAfitBaseVals_3_*/
	0x0F127E06,	/*ConstAfitBaseVals_4_*/
	0x0F1200D3,	/*ConstAfitBaseVals_5_*/
	0x002A0156,
	0x0F120000,		/*REG_TC_GP_ActivePrevConfig*/
	0x002A015E,
	0x0F120000,		/*REG_TC_GP_ActiveCapConfig*/
	0x002A015A,
	0x0F120001,		/*REG_TC_GP_PrevOpenAfterChange*/
	0x002A0142,
	0x0F120001,		/*REG_TC_GP_NewConfigSync*/
	0x002A0158,
	0x0F120001,		/*REG_TC_GP_PrevConfigChanged*/
	0x002A0160,
	0x0F120001,		/*REG_TC_GP_CapConfigChanged*/
	0x002A013A,
	0x0F120001,		/*REG_TC_GP_EnablePreview*/
	0x0F120001,		/*REG_TC_GP_EnablePreviewChanged*/
	0xFFFF0096,

};

/* Set-data based on SKT VT standard ,when using 3G network
* 8fps
*/
static const u32 s5k5bbgx_vt_common[] = {
	0xFCFCD000,
	0x00100001,	/*sw_reset*/
	/*For divided ARM CLK 1/2*/
	/*WRITE	D00000A0	0000*/
	0x10300000,	/*contint_host_int*/
	0x00140001,	/*sw_load_complete-Release CORE (Arm) from reset state*/
	0x01520084,	/*make alive voltage low*/
	0xFFFF000A,
	/* Start of Patch data*/
	0x00287000,
	0x002A2744,
	0x0F12B510,	/* 70002744*/
	0x0F124A12,	/* 70002746*/
	0x0F12217B,	/* 70002748*/
	0x0F124812,	/* 7000274A*/
	0x0F12C004,	/* 7000274C*/
	0x0F126001,	/* 7000274E*/
	0x0F124911,	/* 70002750*/
	0x0F124812,	/* 70002752*/
	0x0F12F000,	/* 70002754*/
	0x0F12F926,	/* 70002756*/
	0x0F124911,	/* 70002758*/
	0x0F124812,	/* 7000275A*/
	0x0F12F000,	/* 7000275C*/
	0x0F12F922,	/* 7000275E*/
	0x0F124911,	/* 70002760*/
	0x0F124812,	/* 70002762*/
	0x0F12F000,	/* 70002764*/
	0x0F12F91E,	/* 70002766*/
	0x0F124911,	/* 70002768*/
	0x0F124812,	/* 7000276A*/
	0x0F12F000,	/* 7000276C*/
	0x0F12F91A,	/* 7000276E*/
	0x0F124911,	/* 70002770*/
	0x0F124812,	/* 70002772*/
	0x0F12F000,	/* 70002774*/
	0x0F12F916,	/* 70002776*/
	0x0F124911,	/* 70002778*/
	0x0F124812,	/* 7000277A*/
	0x0F12F000,	/* 7000277C*/
	0x0F12F912,	/* 7000277E*/
	0x0F124911,	/* 70002780*/
	0x0F124812,	/* 70002782*/
	0x0F12F000,	/* 70002784*/
	0x0F12F90E,	/* 70002786*/
	0x0F12BC10,	/* 70002788*/
	0x0F12BC08,	/* 7000278A*/
	0x0F124718,	/* 7000278C*/
	0x0F120000,	/* 7000278E*/
	0x0F120000,	/* 70002790*/
	0x0F125BB1,	/* 70002792*/
	0x0F121770,	/* 70002794*/
	0x0F127000,	/* 70002796*/
	0x0F1227D1,	/* 70002798*/
	0x0F127000,	/* 7000279A*/
	0x0F12C0BB,	/* 7000279C*/
	0x0F120000,	/* 7000279E*/
	0x0F12280F,	/* 700027A0*/
	0x0F127000,	/* 700027A2*/
	0x0F123609,	/* 700027A4*/
	0x0F120000,	/* 700027A6*/
	0x0F122827,	/* 700027A8*/
	0x0F127000,	/* 700027AA*/
	0x0F1277C7,	/* 700027AC*/
	0x0F120000,	/* 700027AE*/
	0x0F1228B3,	/* 700027B0*/
	0x0F127000,	/* 700027B2*/
	0x0F12727D,	/* 700027B4*/
	0x0F120000,	/* 700027B6*/
	0x0F1228CD,	/* 700027B8*/
	0x0F127000,	/* 700027BA*/
	0x0F129919,	/* 700027BC*/
	0x0F120000,	/* 700027BE*/
	0x0F12290B,	/* 700027C0*/
	0x0F127000,	/* 700027C2*/
	0x0F121C63,	/* 700027C4*/
	0x0F120000,	/* 700027C6*/
	0x0F12296B,	/* 700027C8*/
	0x0F127000,	/* 700027CA*/
	0x0F1204CB,	/* 700027CC*/
	0x0F120000,	/* 700027CE*/
	0x0F12B4F0,	/* 700027D0*/
	0x0F126801,	/* 700027D2*/
	0x0F12468C,	/* 700027D4*/
	0x0F126846,	/* 700027D6*/
	0x0F122200,	/* 700027D8*/
	0x0F124968,	/* 700027DA*/
	0x0F122000,	/* 700027DC*/
	0x0F122724,	/* 700027DE*/
	0x0F124357,	/* 700027E0*/
	0x0F12183B,	/* 700027E2*/
	0x0F124664,	/* 700027E4*/
	0x0F125CE5,	/* 700027E6*/
	0x0F12005C,	/* 700027E8*/
	0x0F125B34,	/* 700027EA*/
	0x0F12072D,	/* 700027EC*/
	0x0F120F2D,	/* 700027EE*/
	0x0F12800D,	/* 700027F0*/
	0x0F12804C,	/* 700027F2*/
	0x0F12808B,	/* 700027F4*/
	0x0F122301,	/* 700027F6*/
	0x0F1280CB,	/* 700027F8*/
	0x0F122300,	/* 700027FA*/
	0x0F1280CB,	/* 700027FC*/
	0x0F121C40,	/* 700027FE*/
	0x0F122824,	/* 70002800*/
	0x0F12D3EE,	/* 70002802*/
	0x0F121C52,	/* 70002804*/
	0x0F122A04,	/* 70002806*/
	0x0F12D3E8,	/* 70002808*/
	0x0F12BCF0,	/* 7000280A*/
	0x0F124770,	/* 7000280C*/
	0x0F12B510,	/* 7000280E*/
	0x0F12F000,	/* 70002810*/
	0x0F12F8D0,	/* 70002812*/
	0x0F12485A,	/* 70002814*/
	0x0F127A81,	/* 70002816*/
	0x0F12485A,	/* 70002818*/
	0x0F126B00,	/* 7000281A*/
	0x0F12F000,	/* 7000281C*/
	0x0F12F8D2,	/* 7000281E*/
	0x0F12BC10,	/* 70002820*/
	0x0F12BC08,	/* 70002822*/
	0x0F124718,	/* 70002824*/
	0x0F12B5F8,	/* 70002826*/
	0x0F126805,	/* 70002828*/
	0x0F126844,	/* 7000282A*/
	0x0F124E56,	/* 7000282C*/
	0x0F128861,	/* 7000282E*/
	0x0F128AB0,	/* 70002830*/
	0x0F128A72,	/* 70002832*/
	0x0F122301,	/* 70002834*/
	0x0F124368,	/* 70002836*/
	0x0F121889,	/* 70002838*/
	0x0F1217C2,	/* 7000283A*/
	0x0F120E12,	/* 7000283C*/
	0x0F121810,	/* 7000283E*/
	0x0F121202,	/* 70002840*/
	0x0F128820,	/* 70002842*/
	0x0F12029B,	/* 70002844*/
	0x0F1218C0,	/* 70002846*/
	0x0F12F000,	/* 70002848*/
	0x0F12F8C4,	/* 7000284A*/
	0x0F129000,	/* 7000284C*/
	0x0F128AF6,	/* 7000284E*/
	0x0F124268,	/* 70002850*/
	0x0F12210A,	/* 70002852*/
	0x0F124370,	/* 70002854*/
	0x0F12F000,	/* 70002856*/
	0x0F12F8C5,	/* 70002858*/
	0x0F12436E,	/* 7000285A*/
	0x0F120007,	/* 7000285C*/
	0x0F12210A,	/* 7000285E*/
	0x0F120030,	/* 70002860*/
	0x0F12F000,	/* 70002862*/
	0x0F12F8BF,	/* 70002864*/
	0x0F129A00,	/* 70002866*/
	0x0F120039,	/* 70002868*/
	0x0F12F000,	/* 7000286A*/
	0x0F12F8C1,	/* 7000286C*/
	0x0F120002,	/* 7000286E*/
	0x0F128820,	/* 70002870*/
	0x0F121880,	/* 70002872*/
	0x0F128020,	/* 70002874*/
	0x0F124845,	/* 70002876*/
	0x0F1288C1,	/* 70002878*/
	0x0F124843,	/* 7000287A*/
	0x0F123820,	/* 7000287C*/
	0x0F128B40,	/* 7000287E*/
	0x0F124240,	/* 70002880*/
	0x0F124350,	/* 70002882*/
	0x0F12F000,	/* 70002884*/
	0x0F12F8AE,	/* 70002886*/
	0x0F128861,	/* 70002888*/
	0x0F121840,	/* 7000288A*/
	0x0F128060,	/* 7000288C*/
	0x0F12BCF8,	/* 7000288E*/
	0x0F12BC08,	/* 70002890*/
	0x0F124718,	/* 70002892*/
	0x0F12B570,	/* 70002894*/
	0x0F124C3C,	/* 70002896*/
	0x0F123C20,	/* 70002898*/
	0x0F128B20,	/* 7000289A*/
	0x0F12F000,	/* 7000289C*/
	0x0F12F8B0,	/* 7000289E*/
	0x0F124D3A,	/* 700028A0*/
	0x0F1280E8,	/* 700028A2*/
	0x0F128B60,	/* 700028A4*/
	0x0F12F000,	/* 700028A6*/
	0x0F12F8B3,	/* 700028A8*/
	0x0F128128,	/* 700028AA*/
	0x0F12BC70,	/* 700028AC*/
	0x0F12BC08,	/* 700028AE*/
	0x0F124718,	/* 700028B0*/
	0x0F12B510,	/* 700028B2*/
	0x0F124836,	/* 700028B4*/
	0x0F12214D,	/* 700028B6*/
	0x0F128201,	/* 700028B8*/
	0x0F122196,	/* 700028BA*/
	0x0F128281,	/* 700028BC*/
	0x0F12211D,	/* 700028BE*/
	0x0F128301,	/* 700028C0*/
	0x0F12F7FF,	/* 700028C2*/
	0x0F12FFE7,	/* 700028C4*/
	0x0F12F000,	/* 700028C6*/
	0x0F12F8AB,	/* 700028C8*/
	0x0F12E7A9,	/* 700028CA*/
	0x0F12B570,	/* 700028CC*/
	0x0F120004,	/* 700028CE*/
	0x0F126820,	/* 700028D0*/
	0x0F126865,	/* 700028D2*/
	0x0F12F000,	/* 700028D4*/
	0x0F12F8AC,	/* 700028D6*/
	0x0F120402,	/* 700028D8*/
	0x0F12482E,	/* 700028DA*/
	0x0F120C12,	/* 700028DC*/
	0x0F128142,	/* 700028DE*/
	0x0F12482D,	/* 700028E0*/
	0x0F128801,	/* 700028E2*/
	0x0F122900,	/* 700028E4*/
	0x0F12D008,	/* 700028E6*/
	0x0F12492C,	/* 700028E8*/
	0x0F12002B,	/* 700028EA*/
	0x0F126D8A,	/* 700028EC*/
	0x0F122105,	/* 700028EE*/
	0x0F121C80,	/* 700028F0*/
	0x0F12F000,	/* 700028F2*/
	0x0F12F8A5,	/* 700028F4*/
	0x0F126020,	/* 700028F6*/
	0x0F12E005,	/* 700028F8*/
	0x0F124829,	/* 700028FA*/
	0x0F12002B,	/* 700028FC*/
	0x0F122105,	/* 700028FE*/
	0x0F12F000,	/* 70002900*/
	0x0F12F89E,	/* 70002902*/
	0x0F126020,	/* 70002904*/
	0x0F126820,	/* 70002906*/
	0x0F12E7D0,	/* 70002908*/
	0x0F12B5F8,	/* 7000290A*/
	0x0F124923,	/* 7000290C*/
	0x0F122200,	/* 7000290E*/
	0x0F123160,	/* 70002910*/
	0x0F1283CA,	/* 70002912*/
	0x0F126800,	/* 70002914*/
	0x0F124669,	/* 70002916*/
	0x0F12F000,	/* 70002918*/
	0x0F12F89A,	/* 7000291A*/
	0x0F12466B,	/* 7000291C*/
	0x0F128818,	/* 7000291E*/
	0x0F12F000,	/* 70002920*/
	0x0F12F86E,	/* 70002922*/
	0x0F120005,	/* 70002924*/
	0x0F12466B,	/* 70002926*/
	0x0F128858,	/* 70002928*/
	0x0F12F000,	/* 7000292A*/
	0x0F12F871,	/* 7000292C*/
	0x0F120004,	/* 7000292E*/
	0x0F122101,	/* 70002930*/
	0x0F121928,	/* 70002932*/
	0x0F1202C9,	/* 70002934*/
	0x0F121A08,	/* 70002936*/
	0x0F120286,	/* 70002938*/
	0x0F120029,	/* 7000293A*/
	0x0F120030,	/* 7000293C*/
	0x0F12F000,	/* 7000293E*/
	0x0F12F88F,	/* 70002940*/
	0x0F120005,	/* 70002942*/
	0x0F122701,	/* 70002944*/
	0x0F1202BF,	/* 70002946*/
	0x0F120021,	/* 70002948*/
	0x0F120030,	/* 7000294A*/
	0x0F12F000,	/* 7000294C*/
	0x0F12F888,	/* 7000294E*/
	0x0F124912,	/* 70002950*/
	0x0F124A0E,	/* 70002952*/
	0x0F123140,	/* 70002954*/
	0x0F123AC0,	/* 70002956*/
	0x0F12800D,	/* 70002958*/
	0x0F128395,	/* 7000295A*/
	0x0F12804F,	/* 7000295C*/
	0x0F1283D7,	/* 7000295E*/
	0x0F128088,	/* 70002960*/
	0x0F120011,	/* 70002962*/
	0x0F123120,	/* 70002964*/
	0x0F128008,	/* 70002966*/
	0x0F12E791,	/* 70002968*/
	0x0F12B510,	/* 7000296A*/
	0x0F12480A,	/* 7000296C*/
	0x0F128980,	/* 7000296E*/
	0x0F122800,	/* 70002970*/
	0x0F12D001,	/* 70002972*/
	0x0F12F000,	/* 70002974*/
	0x0F12F87A,	/* 70002976*/
	0x0F12E752,	/* 70002978*/
	0x0F120000,	/* 7000297A*/
	0x0F124140,	/* 7000297C*/
	0x0F12D000,	/* 7000297E*/
	0x0F1219DC,	/* 70002980*/
	0x0F127000,	/* 70002982*/
	0x0F121B60,	/* 70002984*/
	0x0F127000,	/* 70002986*/
	0x0F120DD4,	/* 70002988*/
	0x0F127000,	/* 7000298A*/
	0x0F1222AC,	/* 7000298C*/
	0x0F127000,	/* 7000298E*/
	0x0F121E8C,	/* 70002990*/
	0x0F127000,	/* 70002992*/
	0x0F121A10,	/* 70002994*/
	0x0F127000,	/* 70002996*/
	0x0F123780,	/* 70002998*/
	0x0F127000,	/* 7000299A*/
	0x0F122384,	/* 7000299C*/
	0x0F127000,	/* 7000299E*/
	0x0F12065C,	/* 700029A0*/
	0x0F127000,	/* 700029A2*/
	0x0F124778,	/* 700029A4*/
	0x0F1246C0,	/* 700029A6*/
	0x0F12C000,	/* 700029A8*/
	0x0F12E59F,	/* 700029AA*/
	0x0F12FF1C,	/* 700029AC*/
	0x0F12E12F,	/* 700029AE*/
	0x0F12CE77,	/* 700029B0*/
	0x0F120000,	/* 700029B2*/
	0x0F124778,	/* 700029B4*/
	0x0F1246C0,	/* 700029B6*/
	0x0F12C000,	/* 700029B8*/
	0x0F12E59F,	/* 700029BA*/
	0x0F12FF1C,	/* 700029BC*/
	0x0F12E12F,	/* 700029BE*/
	0x0F123609,	/* 700029C0*/
	0x0F120000,	/* 700029C2*/
	0x0F124778,	/* 700029C4*/
	0x0F1246C0,	/* 700029C6*/
	0x0F12C000,	/* 700029C8*/
	0x0F12E59F,	/* 700029CA*/
	0x0F12FF1C,	/* 700029CC*/
	0x0F12E12F,	/* 700029CE*/
	0x0F129F91,	/* 700029D0*/
	0x0F120000,	/* 700029D2*/
	0x0F124778,	/* 700029D4*/
	0x0F1246C0,	/* 700029D6*/
	0x0F12C000,	/* 700029D8*/
	0x0F12E59F,	/* 700029DA*/
	0x0F12FF1C,	/* 700029DC*/
	0x0F12E12F,	/* 700029DE*/
	0x0F122AE3,	/* 700029E0*/
	0x0F120000,	/* 700029E2*/
	0x0F124778,	/* 700029E4*/
	0x0F1246C0,	/* 700029E6*/
	0x0F12F004,	/* 700029E8*/
	0x0F12E51F,	/* 700029EA*/
	0x0F12D1DC,	/* 700029EC*/
	0x0F120000,	/* 700029EE*/
	0x0F124778,	/* 700029F0*/
	0x0F1246C0,	/* 700029F2*/
	0x0F12C000,	/* 700029F4*/
	0x0F12E59F,	/* 700029F6*/
	0x0F12FF1C,	/* 700029F8*/
	0x0F12E12F,	/* 700029FA*/
	0x0F126869,	/* 700029FC*/
	0x0F120000,	/* 700029FE*/
	0x0F124778,	/* 70002A00*/
	0x0F1246C0,	/* 70002A02*/
	0x0F12C000,	/* 70002A04*/
	0x0F12E59F,	/* 70002A06*/
	0x0F12FF1C,	/* 70002A08*/
	0x0F12E12F,	/* 70002A0A*/
	0x0F1268BD,	/* 70002A0C*/
	0x0F120000,	/* 70002A0E*/
	0x0F124778,	/* 70002A10*/
	0x0F1246C0,	/* 70002A12*/
	0x0F12C000,	/* 70002A14*/
	0x0F12E59F,	/* 70002A16*/
	0x0F12FF1C,	/* 70002A18*/
	0x0F12E12F,	/* 70002A1A*/
	0x0F1268DB,	/* 70002A1C*/
	0x0F120000,	/* 70002A1E*/
	0x0F124778,	/* 70002A20*/
	0x0F1246C0,	/* 70002A22*/
	0x0F12C000,	/* 70002A24*/
	0x0F12E59F,	/* 70002A26*/
	0x0F12FF1C,	/* 70002A28*/
	0x0F12E12F,	/* 70002A2A*/
	0x0F1271B9,	/* 70002A2C*/
	0x0F120000,	/* 70002A2E*/
	0x0F124778,	/* 70002A30*/
	0x0F1246C0,	/* 70002A32*/
	0x0F12C000,	/* 70002A34*/
	0x0F12E59F,	/* 70002A36*/
	0x0F12FF1C,	/* 70002A38*/
	0x0F12E12F,	/* 70002A3A*/
	0x0F1298CD,	/* 70002A3C*/
	0x0F120000,	/* 70002A3E*/
	0x0F124778,	/* 70002A40*/
	0x0F1246C0,	/* 70002A42*/
	0x0F12C000,	/* 70002A44*/
	0x0F12E59F,	/* 70002A46*/
	0x0F12FF1C,	/* 70002A48*/
	0x0F12E12F,	/* 70002A4A*/
	0x0F12987F,	/* 70002A4C*/
	0x0F120000,	/* 70002A4E*/
	0x0F124778,	/* 70002A50*/
	0x0F1246C0,	/* 70002A52*/
	0x0F12C000,	/* 70002A54*/
	0x0F12E59F,	/* 70002A56*/
	0x0F12FF1C,	/* 70002A58*/
	0x0F12E12F,	/* 70002A5A*/
	0x0F121BC9,	/* 70002A5C*/
	0x0F120000,	/* 70002A5E*/
	0x0F124778,	/* 70002A60*/
	0x0F1246C0,	/* 70002A62*/
	0x0F12F004,	/* 70002A64*/
	0x0F12E51F,	/* 70002A66*/
	0x0F12D378,	/* 70002A68*/
	0x0F120000,	/* 70002A6A*/
	0x0F124778,	/* 70002A6C*/
	0x0F1246C0,	/* 70002A6E*/
	0x0F12C000,	/* 70002A70*/
	0x0F12E59F,	/* 70002A72*/
	0x0F12FF1C,	/* 70002A74*/
	0x0F12E12F,	/* 70002A76*/
	0x0F1204CB,	/* 70002A78*/
	0x0F120000,	/* 70002A7A*/
	/* End of Patch	Data(Last : 70002A7Ah)*/
	/* This	parameter should be set	before HOST command interrupt
	* (1000 0001)*/
	0x002A378C,
	0x0F120000,	/* On/off register bUseOTP*/
	0x002A0DCC,
	0x0F120138,	/*awbb_IntcR*/
	0x0F12011C,	/*awbb_IntcB*/
	/*===================================================================*/
	/*Analog & APS Control*/
	/*===================================================================*/
	0x0028D000,
	0x002AF404,
	0x0F120038,	/* aig_adc_sat[7:0] : 850mV, revised by	Ana 20100524*/
	0x0F120001,	/* aig_ms[2:0] : revised by Ana	20100202*/
	0x0F12000C,	/* aig_sig_mx[5:0]*/
	0x0F120006,	/* aig_rst_mx[5:0]*/
	0x0F120008,	/* aig_rmp_option[3] SL_Low_PWR_SAVE On	:
			revised by Ana 20100204*/
	0x002AF418,
	0x0F120003,	/* aig_dbr_clk_sel[1:0]	: revised by Ana 20100201*/
	0x002AF41C,
	0x0F120140,	/* aig_bist_sig_width_e[10:0]*/
	0x0F120140,	/* aig_bist_sig_width_o[10:0]*/
	0x0F120066,	/* aig_bist_sig_width_o[10:0]*/
	0x0F120005,	/* aig_pix_bias[3:0]*/
	0x002AF426,
	0x0F1200D4,	/* aig_clp_lvl[7:0]*/
	0x002AF42A,
	0x0F120001,	/* aig_ref_option[0] SL_Low_PWR_SAVE On	:
			revised by Ana 20100204*/
	0x002AF430,
	0x0F120001,	/* aig_pd_cp_rosc[0] : revised by Ana 20100201*/
	0x0F120001,	/* aig_pd_ncp_rosc[0] :	revised	by Ana 20100201*/
	0x002AF43A,
	0x0F120000,	/* aig_pd_fblv[0] : revised by Ana 20100203*/
	0x002AF440,
	0x0F120044,	/* aig_rosc_tune_ncp[7:4]*/
	/* aig_rosc_tune_cp[3:0]*/
	0x002AF44A,
	0x0F120000,	/* aig_fb_lv[1:0] : revised by Ana 20100204*/
	0x002AF45C,
	0x0F120000,	/* aig_dshut_en[0] : revised by	APS 20100223*/
	0x0F120000,	/* aig_srx_en[0]*/
	0x002AF462,
	0x0F120001,	/* aig_pdb_atop[0]*/
	0x002AF46E,
	0x0F121F02,	/* aig_cds_test[15:0]*/
	0x002AF474,
	0x0F12000E,	/* aig_stx_gap[4:0]*/
	/*====================================================================*/
	0x002AE42E,
	0x0F120004,	/* adlc_qec[2:0] : revised by
			Dithered L-ADLC Designer 20100203*/
	0x00287000,
	0x002A13E0,
	0x0F120000,	/*700013E0 SRX OFF*/
	0x002A13C8,
	0x0F120001,	/*700013C8 AAC Enable*/
	0x002A12D8,
	0x0F120464,	/*700012d8*/
	0x0F120468,	/*700012da*/
	0x002A12F6,
	0x0F120000,	/*700012f6*/
	0x002A13CC,
	0x0F121FC0,	/* [12:0] : Write tuning value to E404 register*/
	0x002A13EC,
	0x0F120001,
	0x002A184C,
	0x0F121EE1,
	0x0028D000,
	0x002A1000,
	0x0F120001,
	0x00287000,
	0x002A040E,
	0x0F120003,	/*STBY TnP enable setting STBY TnP enable setting [0]
			bit STBY enable,[1] bit STBY ø TnP ? on/off bit*/
	0xFFFF000A,
	/*H-Digital binning & V-PLA*/
	0x002A1218,
	0x0F120002,	/*subsampling number.*/
	0x0F120002,	/*subsampling number.*/
	0x002A0C9A,
	0x0F120001,	/* setot_bUseDigitalHbin  0 : do not use bin block*/
	0x002A1438,
	0x0F12F468,	/* senHal_TuneStr_AngTuneData1[0]  : tuning register
			setting.*/
	0x0F120000,	/* not use binninb block 0x0000	,use binnin blcok
			0x0000*/
	0x0F120008,	/* not use binninb block 0x000A	,use binnin blcok
			0x0008*/
	0x0F120006,	/* not use binninb block 0x0005	,use binnin blcok
			0x0006*/
	0x0F120000,	/* 0x0000 , 0x0000*/
	0xFFFF000A,
	0x002A0416,
	0x0F12F400,
	0x0F120074,
	0x0F12E42E,
	0x0F120030,
	/*clk Settings*/
	0x00287000,
	0x002A00F4,
	0x0F125DC0,	/*REG_TC_IPRM_InClockLSBs		2   700000F4*/
	0x002A0110,
	0x0F120003,	/*REG_TC_IPRM_UseNPviClocks		2   70000110*/
	0x0F120000,	/*REG_TC_IPRM_bBlockInternalPllCalc	2   70000112*/
	/*SYSTEM CLOCK*/
	0x0F12222E,	/*REG_TC_IPRM_OpClk4KHz_0		2   70000114
			35000Khz/4=HEX()*/
	0x0F12445C,	/*REG_TC_IPRM_MinOutRate4KHz_0		2   70000116*/
	0x0F12445C,	/*REG_TC_IPRM_MaxOutRate4KHz_0		2   70000118*/
	0x0F121117,	/*1770		REG_TC_IPRM_OpClk4KHz_1	2   7000011A
			24000Khz/4*/
	0x0F12222E,	/*REG_TC_IPRM_MinOutRate4KHz_1		2   7000011C
			36000khz/4 =2328hex*/
	0x0F12222E,	/*REG_TC_IPRM_MaxOutRate4KHz_1		2   7000011E*/
	0x0F120BB8,	/*REG_TC_IPRM_OpClk4KHz_2		2   70000120
			12000Khz*/
	0x0F1205DC,	/*REG_TC_IPRM_MinOutRate4KHz_2		2   70000122*/
	0x0F121770,	/*REG_TC_IPRM_MaxOutRate4KHz_2		2   70000124*/
	0x0F120001,	/*REG_TC_IPRM_InitParamsUpdated		2   70000126*/
	0xFFFF0064,
	0x002A1218,
	0x0F120002,
	/*===================================================================*/
	/*Preview0 1600x1200 system 32M	PCLK 70M From APS*/
	/*===================================================================*/
	0x002A0144,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,
	/*Preview0 for 7.5~15fps*/
	0x002A0170,
	0x0F120280,	/*REG_0TC_PCFG_usWidth			2   70000170*/
	0x0F1201e0,	/*REG_0TC_PCFG_usHeight			2   70000172*/
	0x0F120005,	/*REG_0TC_PCFG_Format			2   70000174*/
	0x0F12222E,	/*REG_0TC_PCFG_usMaxOut4KHzRate		2   70000176*/
	0x0F12222E,	/*REG_0TC_PCFG_usMinOut4KHzRate		2   70000178*/
	0x0F120042,	/*REG_0TC_PCFG_PVIMask			2   7000017A*/
	0x0F120010,	/*REG_0TC_PCFG_OIFMask			2   7000017C*/
	0x0F120001,	/*REG_0TC_PCFG_uClockInd		2   7000017E*/
	0x0F120002,	/*REG_0TC_PCFG_usFrTimeType		2   70000180
			0b : dynamic 01:fix not accurate 02b: fixed_Accurate*/
	0x0F120001,	/*REG_0TC_PCFG_FrRateQualityType	2   70000182
			1b: FR (bin) 2b: Quality (no-bin)*/
	0x0F1204E2,	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10	2   70000184
			max frame	time : 30fps 014D 15fps	029a; a6a -
			3.75 fps; 0535 - 7.5FPS*/
	0x0F1204E2,	/*REG_0TC_PCFG_usMinFrTimeMsecMult10	2   70000186*/
	0x0F120000,	/*REG_0TC_PCFG_bSmearOutput		2   70000188*/
	0x0F120000,	/*REG_0TC_PCFG_sSaturation		2   7000018A*/
	0x0F120000,	/*REG_0TC_PCFG_sSharpBlur		2   7000018C*/
	0x0F120000,	/*REG_0TC_PCFG_sColorTemp		2   7000018E*/
	0x0F120000,	/*REG_0TC_PCFG_uDeviceGammaIndex	2   70000190*/
	0x0F120003,	/*REG_0TC_PCFG_uPrevMirror		2   70000192*/
	0x0F120003,	/*REG_0TC_PCFG_uCaptureMirror		2   70000194*/
	0x0F120000,	/*REG_0TC_PCFG_uRotation		2   70000196*/
	/*Preview1 for fixed 15fps*/
	0x0F120320,	/*REG_1TC_PCFG_usWidth			2   70000198*/
	0x0F120258,	/*REG_1TC_PCFG_usHeight			2   7000019A*/
	0x0F120005,	/*REG_1TC_PCFG_Format			2   7000019C*/
	0x0F12222E,	/*REG_1TC_PCFG_usMaxOut4KHzRate		2   7000019E*/
	0x0F12222E,	/*REG_1TC_PCFG_usMinOut4KHzRate		2   700001A0*/
	0x0F120042,	/*REG_1TC_PCFG_PVIMask			2   700001A2*/
	0x0F120010,	/*REG_1TC_PCFG_OIFMask			2   700001A4*/
	0x0F120001,	/*REG_1TC_PCFG_uClockInd		2   700001A6*/
	0x0F120000,	/*REG_1TC_PCFG_usFrTimeType		2   700001A8*/
	0x0F120001,	/*REG_1TC_PCFG_FrRateQualityType	2   700001AA*/
	0x0F12029A,	/*REG_1TC_PCFG_usMaxFrTimeMsecMult10	2   700001AC*/
	0x0F12029A,	/*REG_1TC_PCFG_usMinFrTimeMsecMult10	2   700001AE*/
	0x0F120000,	/*REG_1TC_PCFG_bSmearOutput		2   700001B0*/
	0x0F120000,	/*REG_1TC_PCFG_sSaturation		2   700001B2*/
	0x0F120000,	/*REG_1TC_PCFG_sSharpBlur		2   700001B4*/
	0x0F120000,	/*REG_1TC_PCFG_sColorTemp		2   700001B6*/
	0x0F120000,	/*REG_1TC_PCFG_uDeviceGammaIndex	2   700001B8*/
	0x0F120003,	/*REG_1TC_PCFG_uPrevMirror		2   700001BA*/
	0x0F120003,	/*REG_1TC_PCFG_uCaptureMirror		2   700001BC*/
	0x0F120000,	/*REG_1TC_PCFG_uRotation		2   700001BE*/
	/*Preview2 for nightshot*/
	0x0F120320,	/*REG_2TC_PCFG_usWidth			2   700001C0*/
	0x0F120258,	/*REG_2TC_PCFG_usHeight			2   700001C2*/
	0x0F120005,	/*REG_2TC_PCFG_Format			2   700001C4*/
	0x0F12222E,	/*REG_2TC_PCFG_usMaxOut4KHzRate		2   700001C6*/
	0x0F12222E,	/*REG_2TC_PCFG_usMinOut4KHzRate		2   700001C8*/
	0x0F120042,	/*REG_2TC_PCFG_PVIMask			2   700001CA*/
	0x0F120010,	/*REG_2TC_PCFG_OIFMask			2   700001CC*/
	0x0F120000,	/*REG_2TC_PCFG_uClockInd		2   700001CE*/
	0x0F120000,	/*REG_2TC_PCFG_usFrTimeType		2   700001D0*/
	0x0F120001,	/*REG_2TC_PCFG_FrRateQualityType	2   700001D2
			1b: FR (bin) 2b:	Quality	(no-bin)*/
	0x0F12014D,	/*REG_2TC_PCFG_usMaxFrTimeMsecMult10	2   700001D4
			max frame time :	30fps 014D 15fps 029a; a6a -
			3.75 fps; 0535 - 7.5FPS*/
	0x0F12014D,	/*REG_2TC_PCFG_usMinFrTimeMsecMult10	2   700001D6*/
	0x0F120000,	/*REG_2TC_PCFG_bSmearOutput		2   700001D8*/
	0x0F120000,	/*REG_2TC_PCFG_sSaturation		2   700001DA*/
	0x0F120000,	/*REG_2TC_PCFG_sSharpBlur		2   700001DC*/
	0x0F120000,	/*REG_2TC_PCFG_sColorTemp		2   700001DE*/
	0x0F120000,	/*REG_2TC_PCFG_uDeviceGammaIndex	2   700001E0*/
	0x0F120003,	/*REG_2TC_PCFG_uPrevMirror		2   700001E2
			[0] : x [1]: Y [2] Stat X	[3] Stat Y*/
	0x0F120003,	/*REG_2TC_PCFG_uCaptureMirror		2   700001E4*/
	0x0F120000,	/*REG_2TC_PCFG_uRotation		2   700001E6*/
	0x002A0238,
	0x0F120001,	/*REG_0TC_CCFG_uCaptureMode		2   70000238*/
	0x0F120640,	/*REG_0TC_CCFG_usWidth			2   7000023A*/
	0x0F1204B0,	/*REG_0TC_CCFG_usHeight			2   7000023C*/
	0x0F120005,	/*REG_0TC_CCFG_Format			2   7000023E*/
	0x0F12222E,	/*REG_0TC_CCFG_usMaxOut4KHzRate		2   70000240*/
	0x0F12222E,	/*REG_0TC_CCFG_usMinOut4KHzRate		2   70000242*/
	0x0F120042,	/*REG_0TC_CCFG_PVIMask			2   70000244*/
	0x0F120000,	/*REG_0TC_CCFG_OIFMask			2   70000246*/
	0x0F120001,	/*REG_0TC_CCFG_uClockInd		2   70000248*/
	0x0F120000,	/*REG_0TC_CCFG_usFrTimeType		2   7000024A*/
	0x0F120002,	/*REG_0TC_CCFG_FrRateQualityType	2   7000024C*/
	0x0F1205D0,	/*REG_0TC_CCFG_usMaxFrTimeMsecMult10	2   7000024E*/
	0x0F1204D0,	/*REG_0TC_CCFG_usMinFrTimeMsecMult10	2   70000250*/
	0x0F120000,	/*REG_0TC_CCFG_bSmearOutput		2   70000252*/
	0x0F120000,	/*REG_0TC_CCFG_sSaturation		2   70000254*/
	0x0F120000,	/*REG_0TC_CCFG_sSharpBlur		2   70000256*/
	0x0F120000,	/*REG_0TC_CCFG_sColorTemp		2   70000258*/
	0x0F120000,	/*REG_0TC_CCFG_uDeviceGammaIndex	2   7000025A*/
	0x0F120001,	/*REG_1TC_CCFG_uCaptureMode		2   7000025C*/
	0x0F120640,	/*REG_1TC_CCFG_usWidth			2   7000025E*/
	0x0F1204B0,	/*REG_1TC_CCFG_usHeight			2   70000260*/
	0x0F120005,	/*REG_1TC_CCFG_Format			2   70000262*/
	0x0F12222E,	/*REG_1TC_CCFG_usMaxOut4KHzRate		2   70000264*/
	0x0F12222E,	/*REG_1TC_CCFG_usMinOut4KHzRate		2   70000266*/
	0x0F120042,	/*REG_1TC_CCFG_PVIMask			2   70000268*/
	0x0F120000,	/*REG_1TC_CCFG_OIFMask			2   7000026A*/
	0x0F120001,	/*REG_1TC_CCFG_uClockInd		2   7000026C*/
	0x0F120000,	/*REG_1TC_CCFG_usFrTimeType		2   7000026E*/
	0x0F120002,	/*REG_1TC_CCFG_FrRateQualityType	2   70000270*/
	0x0F121388,	/*REG_1TC_CCFG_usMaxFrTimeMsecMult10	2   70000272*/
	0x0F121388,	/*REG_1TC_CCFG_usMinFrTimeMsecMult10	2   70000274*/
	0x0F120000,	/*REG_1TC_CCFG_bSmearOutput		2   70000276*/
	0x0F120000,	/*REG_1TC_CCFG_sSaturation		2   70000278*/
	0x0F120000,	/*REG_1TC_CCFG_sSharpBlur		2   7000027A*/
	0x0F120000,	/*REG_1TC_CCFG_sColorTemp		2   7000027C*/
	0x0F120000,	/*REG_1TC_CCFG_uDeviceGammaIndex	2   7000027E*/
	0x002A1218,
	0x0F120002,
	/*PREVIEW*/
	0x002A0156,
	0x0F120000,
	0x002A015E,
	0x0F120000,
	0x002A015A,
	0x0F120001,
	0x002A0142,
	0x0F120001,
	0x002A0158,
	0x0F120001,
	0x002A0160,
	0x0F120001,
	0x002A013A,
	0x0F120001,
	0x0F120001,
	0xFFFF0064,
	/*===================================================================*/
	/*AFC*/
	/*===================================================================*/
	/*Auto*/
	0x00287000,
	0x002A0CC0,
	0x0F120001,	/*AFC_Default60Hz   01:60hz 00:50Hz*/
	0x002A0374,
	0x0F12067F,	/*REG_TC_DBG_AutoAlgEnBits*/
	/*===================================================================*/
	/*Shading*/
	/*===================================================================*/
	/* TVAR_ash_pGAS_high*/
	0x00287000,
	0x002A0AD8,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	/* TVAR_ash_pGAS_low*/
	0x0F128608,
	0x0F12E960,
	0x0F120243,
	0x0F12128B,
	0x0F12F073,
	0x0F120270,
	0x0F12DF47,
	0x0F12F226,
	0x0F121A31,
	0x0F12DFDA,
	0x0F121200,
	0x0F1205A9,
	0x0F120F16,
	0x0F120F5E,
	0x0F12DF10,
	0x0F1225BF,
	0x0F12FCF0,
	0x0F12DE1B,
	0x0F12025B,
	0x0F12FA8B,
	0x0F12163B,
	0x0F12DF44,
	0x0F12FB2D,
	0x0F1230E6,
	0x0F12FE07,
	0x0F12F47C,
	0x0F1209F2,
	0x0F120AED,
	0x0F12FA09,
	0x0F12E70E,
	0x0F120158,
	0x0F121110,
	0x0F12E28C,
	0x0F120DFB,
	0x0F12074B,
	0x0F12FBE5,
	0x0F12961C,
	0x0F12E21A,
	0x0F120ADF,
	0x0F120A67,
	0x0F12F8A6,
	0x0F12FDC3,
	0x0F12D590,
	0x0F12FA69,
	0x0F1208D5,
	0x0F12F635,
	0x0F12057E,
	0x0F12043B,
	0x0F12155C,
	0x0F1200C6,
	0x0F12F042,
	0x0F12176A,
	0x0F12F818,
	0x0F12F1F3,
	0x0F12026F,
	0x0F1208F6,
	0x0F120CCF,
	0x0F12E42D,
	0x0F120A92,
	0x0F1210EC,
	0x0F12005F,
	0x0F12F02C,
	0x0F120672,
	0x0F1209BF,
	0x0F12F4B5,
	0x0F12FC22,
	0x0F12FD50,
	0x0F120C26,
	0x0F12EED3,
	0x0F1207C3,
	0x0F12080F,
	0x0F12F6CF,
	0x0F127A3B,
	0x0F12E9DC,
	0x0F12088E,
	0x0F1201C8,
	0x0F12043C,
	0x0F12F7E2,
	0x0F12E391,
	0x0F12F3C4,
	0x0F121422,
	0x0F12E845,
	0x0F120D16,
	0x0F1206CA,
	0x0F120DEB,
	0x0F121324,
	0x0F12E814,
	0x0F1216B7,
	0x0F1202AC,
	0x0F12DE4D,
	0x0F1201EA,
	0x0F12F0C2,
	0x0F120E06,
	0x0F12EC6D,
	0x0F12FDF0,
	0x0F122B46,
	0x0F120710,
	0x0F12F84C,
	0x0F120E52,
	0x0F120675,
	0x0F12F0D7,
	0x0F12ED40,
	0x0F12F3AD,
	0x0F12179A,
	0x0F12DE9B,
	0x0F1210BA,
	0x0F120825,
	0x0F12FE0A,
	0x0F1288E9,
	0x0F12E9E0,
	0x0F12043D,
	0x0F120A17,
	0x0F12FC21,
	0x0F12FB58,
	0x0F12DCE0,
	0x0F12F24C,
	0x0F121A19,
	0x0F12E011,
	0x0F1211A3,
	0x0F120649,
	0x0F120D04,
	0x0F120E15,
	0x0F12E112,
	0x0F1227BD,
	0x0F12F7AA,
	0x0F12E06A,
	0x0F120A16,
	0x0F12FD23,
	0x0F121226,
	0x0F12DA34,
	0x0F1207A4,
	0x0F122AD3,
	0x0F12FE27,
	0x0F12EE64,
	0x0F120CAD,
	0x0F1211C5,
	0x0F12EC55,
	0x0F12ED98,
	0x0F12F88A,
	0x0F121842,
	0x0F12E1D5,
	0x0F1208FD,
	0x0F120FB6,
	0x0F12F801,
	0x002A0378,
	0x0F120001,	/*REG_TC_DBG_RelnitCmd*/
	/*===================================================================*/
	/*Shading - Alpha*/
	/*===================================================================*/
	0x002A05E8,
	0x0F1200E4,	/*TVAR_ash_AwbAshCord[0]		2   70000568*/
	0x0F1200F0,	/*TVAR_ash_AwbAshCord[1]		2   7000056A*/
	0x0F120100,	/*TVAR_ash_AwbAshCord[2]		2   7000056C*/
	0x0F120120,	/*TVAR_ash_AwbAshCord[3]		2   7000056E*/
	0x0F120150,	/*TVAR_ash_AwbAshCord[4]		2   70000570*/
	0x0F120180,	/*TVAR_ash_AwbAshCord[5]		2   70000572*/
	0x0F1201A0,	/*TVAR_ash_AwbAshCord[6]		2   70000574*/
	0x002A05FE,
	0x0F123800,	/*TVAR_ash_GASAlpha[0][0]		2   7000057E*/
	0x0F124000,	/*TVAR_ash_GASAlpha[0][1]		2   70000580*/
	0x0F124000,	/*TVAR_ash_GASAlpha[0][2]		2   70000582*/
	0x0F124000,	/*TVAR_ash_GASAlpha[0][3]		2   70000584*/
	0x0F123800,	/*TVAR_ash_GASAlpha[1][0]		2   70000586*/
	0x0F124000,	/*TVAR_ash_GASAlpha[1][1]		2   70000588*/
	0x0F124000,	/*TVAR_ash_GASAlpha[1][2]		2   7000058A*/
	0x0F124000,	/*TVAR_ash_GASAlpha[1][3]		2   7000058C*/
	0x0F123800,	/*TVAR_ash_GASAlpha[2][0]		2   7000058E*/
	0x0F124000,	/*TVAR_ash_GASAlpha[2][1]		2   70000590*/
	0x0F124000,	/*TVAR_ash_GASAlpha[2][2]		2   70000592*/
	0x0F124000,	/*TVAR_ash_GASAlpha[2][3]		2   70000594*/
	0x0F123800,	/*TVAR_ash_GASAlpha[3][0]		2   70000596*/
	0x0F124000,	/*TVAR_ash_GASAlpha[3][1]		2   70000598*/
	0x0F124000,	/*TVAR_ash_GASAlpha[3][2]		2   7000059A*/
	0x0F124000,	/*TVAR_ash_GASAlpha[3][3]		2   7000059C*/
	0x0F123800,	/*TVAR_ash_GASAlpha[4][0]		2   7000059E*/
	0x0F124000,	/*TVAR_ash_GASAlpha[4][1]		2   700005A0*/
	0x0F124000,	/*TVAR_ash_GASAlpha[4][2]		2   700005A2*/
	0x0F124000,	/*TVAR_ash_GASAlpha[4][3]		2   700005A4*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][0]		2   700005A6*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][1]		2   700005A8*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][2]		2   700005AA*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][3]		2   700005AC*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][0]		2   700005AE*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][1]		2   700005B0*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][2]		2   700005B2*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][3]		2   700005B4*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[0]		2   700005B6*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[1]		2   700005B8*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[2]		2   700005BA*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[3]		2   700005BC*/
	/*===================================================================*/
	/*Gamma*/
	/*===================================================================*/
	0x002A0460,
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[0][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[0][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[0][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[0][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[0][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[0][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[0][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[0][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[0][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[0][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[0][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[0][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[0][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[0][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[0][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[0][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[0][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[0][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[0][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[0][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[1][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[1][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[1][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[1][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[1][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[1][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[1][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[1][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[1][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[1][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[1][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[1][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[1][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[1][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[1][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[1][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[1][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[1][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[1][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[1][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[2][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[2][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[2][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[2][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[2][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[2][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[2][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[2][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[2][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[2][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[2][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[2][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[2][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[2][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[2][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[2][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[2][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[2][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[2][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[2][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[0][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[0][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[0][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[0][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[0][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[0][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[0][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[0][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[0][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[0][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[0][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[0][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[0][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[0][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[0][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[0][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[0][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[0][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[0][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[0][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[1][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[1][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[1][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[1][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[1][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[1][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[1][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[1][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[1][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[1][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[1][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[1][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[1][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[1][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[1][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[1][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[1][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[1][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[1][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[1][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[2][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[2][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[2][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[2][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[2][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[2][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[2][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[2][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[2][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[2][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[2][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[2][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[2][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[2][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[2][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[2][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[2][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[2][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[2][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[2][19]*/


	/*===================================================================*/
	/*AE - shutter*/
	/*===================================================================*/
	/*AE_Target*/
	0x002A10C0,
	0x0F120045,	/*TVAR_ae_BrAve*/
	0x002A10C6,
	0x0F12000F,	/*ae_StatMode				2   70001046*/
	/*AE_state,*/
	0x002A03B2,
	0x0F12010E,	/*#lt_uLimitHigh*/
	0x0F1200F5,	/*#lt_uLimitLow*/
	/*For 60Hz,*/
	0x002A03C4,
	0x0F123415,	/*#lt_uMaxExp1*/
	0x002A03C8,
	0x0F12681F,	/*#lt_uMaxExp2*/
	0x002A03CC,
	0x0F128227,	/*#lt_uMaxExp3*/
	0x002A03D0,
	0x0F120D40,	/*C350	#lt_uMaxExp4*/
	0x0F120003,	/*0000	#lt_uMaxExp4*/
	0x002A03D4,
	0x0F123415,	/*#lt_uCapMaxExp1*/
	0x002A03D8,
	0x0F12681F,	/*#lt_uCapMaxExp2*/
	0x002A03DC,
	0x0F128227,	/*#lt_uCapMaxExp3*/
	0x002A03E0,
	0x0F120D40,	/*C350 #lt_uCapMaxExp4*/
	0x0F120003,	/*0000 #lt_uCapMaxExp4*/
	0x002A03E4,
	0x0F1201C0,	/*0230	#lt_uMaxAnGain1*/
	0x0F1201D0,	/*0260	#lt_uMaxAnGain2*/
	0x0F1202D0,	/*0380	#lt_uMaxAnGain3*/
	0x0F120700,	/*#lt_uMaxAnGain4*/
	0x0F120100,	/*#lt_uMaxDigGain*/
	0x0F128000,	/*#lt_uMaxTotGain  Total-gain is limited by
			#lt_uMaxTotGain*/
	0x0F1201C0,	/*#lt_uCapMaxAnGain1*/
	0x0F1201D0,	/*#lt_uCapMaxAnGain2*/
	0x0F1202D0,	/*#lt_uCapMaxAnGain3*/
	0x0F120700,	/*#lt_uCapMaxAnGain4*/
	0x0F120100,	/*#lt_uCapMaxDigGain*/
	0x0F128000,	/*#lt_uCapMaxTotGain  Total-gain is limited by
			#lt_uMaxTotGain*/
	/*===================================================================*/
	/*AE - Weights*/
	/*===================================================================*/
	0x002A10CE,
	0x0F120000,	/*ae_WeightTbl_16[0]			2   7000104E*/
	0x0F120101,	/*ae_WeightTbl_16[1]			2   70001050*/
	0x0F120101,	/*ae_WeightTbl_16[2]			2   70001052*/
	0x0F120000,	/*ae_WeightTbl_16[3]			2   70001054*/
	0x0F120101,	/*ae_WeightTbl_16[4]			2   70001056*/
	0x0F120101,	/*ae_WeightTbl_16[5]			2   70001058*/
	0x0F120101,	/*ae_WeightTbl_16[6]			2   7000105A*/
	0x0F120101,	/*ae_WeightTbl_16[7]			2   7000105C*/
	0x0F120201,	/*ae_WeightTbl_16[8]			2   7000105E*/
	0x0F120303,	/*ae_WeightTbl_16[9]			2   70001060*/
	0x0F120303,	/*ae_WeightTbl_16[10]			2   70001062*/
	0x0F120102,	/*ae_WeightTbl_16[11]			2   70001064*/
	0x0F120201,	/*ae_WeightTbl_16[12]			2   70001066*/
	0x0F120403,	/*ae_WeightTbl_16[13]			2   70001068*/
	0x0F120304,	/*ae_WeightTbl_16[14]			2   7000106A*/
	0x0F120102,	/*ae_WeightTbl_16[15]			2   7000106C*/
	0x0F120201,	/*ae_WeightTbl_16[16]			2   7000106E*/
	0x0F120403,	/*ae_WeightTbl_16[17]			2   70001070*/
	0x0F120304,	/*ae_WeightTbl_16[18]			2   70001072*/
	0x0F120102,	/*ae_WeightTbl_16[19]			2   70001074*/
	0x0F120201,	/*ae_WeightTbl_16[20]			2   70001076*/
	0x0F120403,	/*ae_WeightTbl_16[21]			2   70001078*/
	0x0F120304,	/*ae_WeightTbl_16[22]			2   7000107A*/
	0x0F120102,	/*ae_WeightTbl_16[23]			2   7000107C*/
	0x0F120201,	/*ae_WeightTbl_16[24]			2   7000107E*/
	0x0F120303,	/*ae_WeightTbl_16[25]			2   70001080*/
	0x0F120303,	/*ae_WeightTbl_16[26]			2   70001082*/
	0x0F120102,	/*ae_WeightTbl_16[27]			2   70001084*/
	0x0F120201,	/*ae_WeightTbl_16[28]			2   70001086*/
	0x0F120202,	/*ae_WeightTbl_16[29]			2   70001088*/
	0x0F120202,	/*ae_WeightTbl_16[30]			2   7000108A*/
	0x0F120102,	/*ae_WeightTbl_16[31]			2   7000108C*/
	/*===================================================================*/
	/*AWB-BASIC setting*/
	/*===================================================================*/
	0x002A0DCC,
	0x0F120138,	/*awbb_IntcR*/
	0x0F12011C,	/*awbb_IntcB*/
	0x0F1202A7,	/*awbb_GLocusR*/
	0x0F120343,	/*awbb_GLocusB*/
	0x002A0DB4,
	0x0F12036C,	/*awbb_CrclLowT_R_c*/
	0x002A0DB8,
	0x0F12011D,	/*awbb_CrclLowT_B_c*/
	0x002A0DBC,
	0x0F1262C1,	/*awbb_CrclLowT_Rad_c*/
	0x002A0DEC,
	0x0F1205F0,	/*awbb_GamutWidthThr1*/
	0x0F1201F4,	/*awbb_GamutHeightThr1*/
	0x0F12006C,	/*awbb_GamutWidthThr2*/
	0x0F120038,	/*awbb_GamutHeightThr2*/
	0x002A0DD8,
	0x0F12000C,	/*awbb_MinNumOfFinalPatches*/
	0x0F12001E,	/*awbb_MinNumOfLowBrFinalPatches*/
	0x0F120046,	/*awbb_MinNumOfLowBr0_FinalPatches*/
	0x002A22BA,
	0x0F120006,	/* #Mon_AWB_ByPassMode [0]Outdoor [1]LowBr [2]LowTemp*/
	0x002A0F7A,
	0x0F120000,	/*awbb_RGainOff				2   70000EFA*/
	0x0F120000,	/*awbb_BGainOff				2   70000EFC*/
	0x0F120000,	/*awbb_GGainOff				2   70000EFE*/
	0x0F1200C2,	/*awbb_Alpha_Comp_Mode			2   70000F00*/
	0x0F120002,	/*awbb_Rpl_InvalidOutDoor		2   70000F02*/
	0x0F120001,	/*awbb_UseGrThrCorr			2   70000F04*/
	0x0F1200E4,	/*awbb_Use_Filters			2   70000F06*/
	0x0F12053C,	/*awbb_GainsInit[0]			2   70000F08*/
	0x0F120400,	/*awbb_GainsInit[1]			2   70000F0A*/
	0x0F12055C,	/*awbb_GainsInit[2]			2   70000F0C*/
	0x0F12001E,	/*awbb_WpFilterMinThr			2   70000F0E*/
	0x0F120190,	/*awbb_WpFilterMaxThr			2   70000F10*/
	0x0F1200A0,	/*awbb_WpFilterCoef			2   70000F12*/
	0x0F120004,	/*awbb_WpFilterSize			2   70000F14*/
	0x0F120001,	/*awbb_otp_disable			2   70000F16*/
	/*===================================================================*/
	/*AWB-Zone*/
	/*===================================================================*/
	/*	param_start	awbb_IndoorGrZones_m_BGrid*/
	0x002A0CE0,
	0x0F1203F8,	/*03B5	awbb_IndoorGrZones_m_BGrid[0]*/
	0x0F120422,	/*03DF	awbb_IndoorGrZones_m_BGrid[1]*/
	0x0F1203B4,	/*032D	awbb_IndoorGrZones_m_BGrid[2]*/
	0x0F120408,	/*03D5	awbb_IndoorGrZones_m_BGrid[3]*/
	0x0F120370,	/*0303	awbb_IndoorGrZones_m_BGrid[4]*/
	0x0F1203EE,	/*03BB	awbb_IndoorGrZones_m_BGrid[5]*/
	0x0F12032C,	/*02DB	awbb_IndoorGrZones_m_BGrid[6]*/
	0x0F1203D4,	/*0397	awbb_IndoorGrZones_m_BGrid[7]*/
	0x0F120302,	/*02B1	awbb_IndoorGrZones_m_BGrid[8]*/
	0x0F1203BA,	/*036B	awbb_IndoorGrZones_m_BGrid[9]*/
	0x0F1202DA,	/*0289	awbb_IndoorGrZones_m_BGrid[10]*/
	0x0F120374,	/*0349	awbb_IndoorGrZones_m_BGrid[11]*/
	0x0F1202B0,	/*026F	awbb_IndoorGrZones_m_BGrid[12]*/
	0x0F120328,	/*0329	awbb_IndoorGrZones_m_BGrid[13]*/
	0x0F120288,	/*0257	awbb_IndoorGrZones_m_BGrid[14]*/
	0x0F120300,	/*0309	awbb_IndoorGrZones_m_BGrid[15]*/
	0x0F120270,	/*0241	awbb_IndoorGrZones_m_BGrid[16]*/
	0x0F1202DE,	/*02DD	awbb_IndoorGrZones_m_BGrid[17]*/
	0x0F120258,	/*0227	awbb_IndoorGrZones_m_BGrid[18]*/
	0x0F1202BE,	/*02C3	awbb_IndoorGrZones_m_BGrid[19]*/
	0x0F120240,	/*0213	awbb_IndoorGrZones_m_BGrid[20]*/
	0x0F1202A0,	/*02AF	awbb_IndoorGrZones_m_BGrid[21]*/
	0x0F120228,	/*0209	awbb_IndoorGrZones_m_BGrid[22]*/
	0x0F120296,	/*0295	awbb_IndoorGrZones_m_BGrid[23]*/
	0x0F120212,	/*020D	awbb_IndoorGrZones_m_BGrid[24]*/
	0x0F120284,	/*0285	awbb_IndoorGrZones_m_BGrid[25]*/
	0x0F120208,	/*0223	awbb_IndoorGrZones_m_BGrid[26]*/
	0x0F120274,	/*0261	awbb_IndoorGrZones_m_BGrid[27]*/
	0x0F12020C,	/*0000	awbb_IndoorGrZones_m_BGrid[28]*/
	0x0F12026E,	/*0000	awbb_IndoorGrZones_m_BGrid[29]*/
	0x0F120222,	/*0000	awbb_IndoorGrZones_m_BGrid[30]*/
	0x0F120260,	/*0000	awbb_IndoorGrZones_m_BGrid[31]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[32]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[33]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[34]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[35]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[36]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[37]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[38]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[39]*/
	/*	param_end	awbb_IndoorGrZones_m_BGrid*/
	0x0F120005,	/*awbb_IndoorGrZones_m_Grid*/
	0x002A0D38,
	0x0F1200FE,	/*awbb_IndoorGrZones_m_Boff*/
	/*	param_start	awbb_OutdoorGrZones_m_BGrid*/
	0x002A0D3C,
	0x0F1202B8,	/*029F	awbb_OutdoorGrZones_m_BGrid[0]*/
	0x0F1202F2,	/*02CE	awbb_OutdoorGrZones_m_BGrid[1]*/
	0x0F12028E,	/*0282	awbb_OutdoorGrZones_m_BGrid[2]*/
	0x0F12030A,	/*02DA	awbb_OutdoorGrZones_m_BGrid[3]*/
	0x0F12027A,	/*026D	awbb_OutdoorGrZones_m_BGrid[4]*/
	0x0F12030A,	/*02C2	awbb_OutdoorGrZones_m_BGrid[5]*/
	0x0F120274,	/*0256	awbb_OutdoorGrZones_m_BGrid[6]*/
	0x0F1202FE,	/*02A6	awbb_OutdoorGrZones_m_BGrid[7]*/
	0x0F120282,	/*026E	awbb_OutdoorGrZones_m_BGrid[8]*/
	0x0F1202DC,	/*028A	awbb_OutdoorGrZones_m_BGrid[9]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[10]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[11]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[12]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[13]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[14]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[15]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[16]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[17]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[18]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[19]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[20]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[21]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[22]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[23]*/
	/*	param_end	awbb_OutdoorGrZones_m_BGrid*/
	0x0F120005,	/*awbb_OutdoorGrZones_m_Gri*/
	0x002A0D70,
	0x0F120005,	/*awbb_OutdoorGrZones_ZInfo_m_GridSz*/
	0x002A0D74,
	0x0F1201EB,	/*awbb_OutdoorGrZones_m_Bof*/
	/*	param_start	awbb_LowBrGrZones_m_BGrid*/
	0x002A0D78,
	0x0F1203CE,	/*awbb_LowBrGrZones_m_BGrid[0]*/
	0x0F12046E,	/*awbb_LowBrGrZones_m_BGrid[1]*/
	0x0F12034E,	/*awbb_LowBrGrZones_m_BGrid[2]*/
	0x0F120474,	/*awbb_LowBrGrZones_m_BGrid[3]*/
	0x0F1202EA,	/*awbb_LowBrGrZones_m_BGrid[4]*/
	0x0F120434,	/*awbb_LowBrGrZones_m_BGrid[5]*/
	0x0F12028C,	/*awbb_LowBrGrZones_m_BGrid[6]*/
	0x0F1203F0,	/*awbb_LowBrGrZones_m_BGrid[7]*/
	0x0F120244,	/*awbb_LowBrGrZones_m_BGrid[8]*/
	0x0F120380,	/*awbb_LowBrGrZones_m_BGrid[9]*/
	0x0F12020E,	/*awbb_LowBrGrZones_m_BGrid[10]*/
	0x0F120330,	/*awbb_LowBrGrZones_m_BGrid[11]*/
	0x0F1201EC,	/*awbb_LowBrGrZones_m_BGrid[12]*/
	0x0F1202EC,	/*awbb_LowBrGrZones_m_BGrid[13]*/
	0x0F1201D0,	/*awbb_LowBrGrZones_m_BGrid[14]*/
	0x0F1202BC,	/*awbb_LowBrGrZones_m_BGrid[15]*/
	0x0F1201C8,	/*awbb_LowBrGrZones_m_BGrid[16]*/
	0x0F120296,	/*awbb_LowBrGrZones_m_BGrid[17]*/
	0x0F1201D2,	/*awbb_LowBrGrZones_m_BGrid[18]*/
	0x0F120266,	/*awbb_LowBrGrZones_m_BGrid[19]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[20]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[21]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[22]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[23]*/
	/*	param_end	awbb_LowBrGrZones_m_BGrid*/
	0x0F120006,	/*awbb_LowBrGrZones_m_GridS*/
	0x002A0DB0,
	0x0F1200E2,	/*awbb_LowBrGrZones_m_Boffs*/
	/*===================================================================*/
	/*AWB Scene Detection*/
	/*===================================================================*/
	0x002A0E50,
	0x0F12FE82,	/*awbb_SCDetectionMap_SEC_StartR_B	2   70000DD0*/
	0x0F12001E,	/*awbb_SCDetectionMap_SEC_StepR_B	2   70000DD2*/
	0x0F120E74,	/*awbb_SCDetectionMap_SEC_SunnyNB	2   70000DD4*/
	0x0F120122,	/*awbb_SCDetectionMap_SEC_StepNB	2   70000DD6*/
	0x0F1200E4,	/*awbb_SCDetectionMap_SEC_LowTempR_B	2   70000DD8*/
	0x0F120096,	/*awbb_SCDetectionMap_SEC_SunnyNBZone	2   70000DDA*/
	0x0F12000E,	/*awbb_SCDetectionMap_SEC_LowTempR_BZone
								2   70000DDC*/
	0x002A0E14,
	0x0F120000,	/*#awbb_SCDetectionMap_SEC	0000
			WRITE	   70000D94	0000
			awbb_SCDetectionMap_SEC_SceneDetectionMap*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__2_
			WRITE	   70000D96	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__4_
			WRITE	   70000D98	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__1_
			WRITE	   70000D9A	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__3_
			WRITE	   70000D9C	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__0_
			WRITE	   70000D9E	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__2_
			WRITE	   70000DA0	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__4_
			WRITE	   70000DA2	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__1_
			WRITE	   70000DA4	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__3_
			WRITE	   70000DA6	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__0_
			WRITE	   70000DA8	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__2_
			WRITE	   70000DAA	0000*/
	0x0F120500,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__4_
			WRITE	   70000DAC	0500*/
	0x0F125555,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__1_
			WRITE	   70000DAE	5555*/
	0x0F125455,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__3_
			WRITE	   70000DB0	5455*/
	0x0F12AA55,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__0_
			WRITE	   70000DB2	AA55*/
	0x0F12AAAA,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__2_
			WRITE	   70000DB4	AAAA*/
	0x0F12BF54,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__4_
			WRITE	   70000DB6	BF54*/
	0x0F12FFFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__1_
			WRITE	   70000DB8	FFFF*/
	0x0F1254FE,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__3_
			WRITE	   70000DBA	54FE*/
	0x0F12FF6F,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__0_
			WRITE	   70000DBC	FF6F*/
	0x0F12FEFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__2_
			WRITE	   70000DBE	FEFF*/
	0x0F121B54,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__4_
			WRITE	   70000DC0	1B54*/
	0x0F12FFFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__1_
			WRITE	   70000DC2	FFFF*/
	0x0F1254FE,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__3_
			WRITE	   70000DC4	54FE*/
	0x0F12FF06,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__0_
			WRITE	   70000DC6	FF06*/
	0x0F12FEFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__2_
			WRITE	   70000DC8	FEFF*/
	0x0F120154,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__4_
			WRITE	   70000DCA	0154*/
	0x0F12BFBF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__1_
			WRITE	   70000DCC	BFBF*/
	0x0F1254BE,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__3_
			 WRITE	   70000DCE	54BE*/
	0x002A0F86,
	0x0F120074,	/*E0	awbb_Use_Filters e4*/
	0x002A0F8E,
	0x0F12001E,	/*awbb_WpFilterMinThr 1e*/
	/*===================================================================*/
	/*AWB -	GridCorrection*/
	/*===================================================================*/
	0x002A0F98,
	0x0F120002,	/*awbb_GridEnable			2   70000F18*/
	0x002A0F60,
	0x0F1202E2,	/*awbb_GridConst_1[0]			2   70000EE0*/
	0x0F12034B,	/*awbb_GridConst_1[1]			2   70000EE2*/
	0x0F120399,	/*awbb_GridConst_1[2]			2   70000EE4*/
	0x0F12102D,	/*awbb_GridConst_2[0]			2   70000EE6*/
	0x0F1210DE,	/*awbb_GridConst_2[1]			2   70000EE8*/
	0x0F12116E,	/*awbb_GridConst_2[2]			2   70000EEA*/
	0x0F12117B,	/*awbb_GridConst_2[3]			2   70000EEC*/
	0x0F121206,	/*awbb_GridConst_2[4]			2   70000EEE*/
	0x0F12127F,	/*awbb_GridConst_2[5]			2   70000EF0*/
	0x0F1202C4,	/*awbb_GridCoeff_R_1			2   70000EF2*/
	0x0F1202E4,	/*awbb_GridCoeff_B_1			2   70000EF4*/
	0x0F1200C3,	/*awbb_GridCoeff_R_2			2   70000EF6*/
	0x0F1200A6,	/*awbb_GridCoeff_B_2			2   70000EF8*/
	0x002A0ED0,
	0x0F12000A,	/*awbb_GridCorr_R[0][0]			2   70000ED0*/
	0x0F120028,	/*awbb_GridCorr_R[0][1]			2   70000ED2*/
	0x0F120028,	/*awbb_GridCorr_R[0][2]			2   70000ED4*/
	0x0F12FFEC,	/*awbb_GridCorr_R[0][3]			2   70000ED6*/
	0x0F12FFEC,	/*awbb_GridCorr_R[0][4]			2   70000ED8*/
	0x0F12001E,	/*awbb_GridCorr_R[0][5]			2   70000EDA*/
	0x0F12000A,	/*awbb_GridCorr_R[1][0]			2   70000EDC*/
	0x0F120028,	/*awbb_GridCorr_R[1][1]			2   70000EDE*/
	0x0F120028,	/*awbb_GridCorr_R[1][2]			2   70000EE0*/
	0x0F12FFEC,	/*awbb_GridCorr_R[1][3]			2   70000EE2*/
	0x0F12FFEC,	/*awbb_GridCorr_R[1][4]			2   70000EE4*/
	0x0F12001E,	/*awbb_GridCorr_R[1][5]			2   70000EE6*/
	0x0F12000A,	/*awbb_GridCorr_R[2][0]			2   70000EE8*/
	0x0F120028,	/*awbb_GridCorr_R[2][1]			2   70000EEA*/
	0x0F120028,	/*awbb_GridCorr_R[2][2]			2   70000EEC*/
	0x0F12FFEC,	/*awbb_GridCorr_R[2][3]			2   70000EEE*/
	0x0F12FFEC,	/*awbb_GridCorr_R[2][4]			2   70000EF0*/
	0x0F12001E,	/*awbb_GridCorr_R[2][5]			2   70000EF2*/
	0x0F12FFD8,	/*awbb_GridCorr_B[0][0]			2   70000EF4*/
	0x0F12003C,	/*awbb_GridCorr_B[0][1]			2   70000EF6*/
	0x0F12003C,	/*awbb_GridCorr_B[0][2]			2   70000EF8*/
	0x0F120000,	/*awbb_GridCorr_B[0][3]			2   70000EFA*/
	0x0F120000,	/*awbb_GridCorr_B[0][4]			2   70000EFC*/
	0x0F12001E,	/*awbb_GridCorr_B[0][5]			2   70000EFE*/
	0x0F12FFD8,	/*awbb_GridCorr_B[1][0]			2   70000F00*/
	0x0F12003C,	/*awbb_GridCorr_B[1][1]			2   70000F02*/
	0x0F12003C,	/*awbb_GridCorr_B[1][2]			2   70000F04*/
	0x0F120000,	/*awbb_GridCorr_B[1][3]			2   70000F06*/
	0x0F120000,	/*awbb_GridCorr_B[1][4]			2   70000F08*/
	0x0F12001E,	/*awbb_GridCorr_B[1][5]			2   70000F0A*/
	0x0F12FFD8,	/*awbb_GridCorr_B[2][0]			2   70000F0C*/
	0x0F12003C,	/*awbb_GridCorr_B[2][1]			2   70000F0E*/
	0x0F12003C,	/*awbb_GridCorr_B[2][2]			2   70000F10*/
	0x0F120000,	/*awbb_GridCorr_B[2][3]			2   70000F12*/
	0x0F120000,	/*awbb_GridCorr_B[2][4]			2   70000F14*/
	0x0F12001E,	/*awbb_GridCorr_B[2][5]			2   70000F16*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][0]		2   70000F18*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[0][1]		2   70000F1A*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][2]		2   70000F1C*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][3]		2   70000F1E*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][4]		2   70000F20*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][5]		2   70000F22*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][0]		2   70000F24*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[1][1]		2   70000F26*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][2]		2   70000F28*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][3]		2   70000F2A*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][4]		2   70000F2C*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][5]		2   70000F2E*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][0]		2   70000F30*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[2][1]		2   70000F32*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][2]		2   70000F34*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][3]		2   70000F36*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][4]		2   70000F38*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][5]		2   70000F3A*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][0]		2   70000F3C*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[0][1]		2   70000F3E*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][2]		2   70000F40*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][3]		2   70000F42*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][4]		2   70000F44*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][5]		2   70000F46*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][0]		2   70000F48*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[1][1]		2   70000F4A*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][2]		2   70000F4C*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][3]		2   70000F4E*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][4]		2   70000F50*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][5]		2   70000F52*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][0]		2   70000F54*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[2][1]		2   70000F56*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][2]		2   70000F58*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][3]		2   70000F5A*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][4]		2   70000F5C*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][5]		2   70000F5E*/
	/*===================================================================*/
	/*CCM*/
	/*===================================================================*/
	0x002A05D2,
	0x0F1200E4,	/*#SARR_AwbCcmCord		2   70000552*/
	0x0F1200F0,	/*#SARR_AwbCcmCord_1_		2   70000554*/
	0x0F120100,	/*#SARR_AwbCcmCord_2_		2   70000556*/
	0x0F120120,	/*#SARR_AwbCcmCord_3_		2   70000558*/
	0x0F120150,	/*#SARR_AwbCcmCord_4_		2   7000055A*/
	0x0F120180,	/*#SARR_AwbCcmCord_5_		2   7000055C*/
	/*	param_start	TVAR_wbt_pBaseCcms*/
	0x002A05C4,
	0x0F123800,
	0x0F127000,
	0x002A3800,
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[0]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[1]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[2]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[3]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[4]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[5]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[6]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[7]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[8]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[9]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[10]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[11]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[12]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[13]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[14]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[15]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[16]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[17]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[18]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[19]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[20]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[21]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[22]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[23]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[24]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[25]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[26]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[27]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[28]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[29]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[30]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[31]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[32]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[33]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[34]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[35]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[36]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[37]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[38]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[39]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[40]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[41]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[42]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[43]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[44]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[45]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[46]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[47]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[48]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[49]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[50]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[51]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[52]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[53]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[54]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[55]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[56]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[57]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[58]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[59]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[60]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[61]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[62]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[63]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[64]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[65]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[66]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[67]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[68]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[69]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[70]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[71]*/
	0x0F1201BF,	/*TVAR_wbt_pBaseCcms[72]*/
	0x0F12FFBF,	/*TVAR_wbt_pBaseCcms[73]*/
	0x0F12FFFE,	/*TVAR_wbt_pBaseCcms[74]*/
	0x0F12FF6D,	/*TVAR_wbt_pBaseCcms[75]*/
	0x0F1201B4,	/*TVAR_wbt_pBaseCcms[76]*/
	0x0F12FF66,	/*TVAR_wbt_pBaseCcms[77]*/
	0x0F12FFCA,	/*TVAR_wbt_pBaseCcms[78]*/
	0x0F12FFCE,	/*TVAR_wbt_pBaseCcms[79]*/
	0x0F12017B,	/*TVAR_wbt_pBaseCcms[80]*/
	0x0F120136,	/*TVAR_wbt_pBaseCcms[81]*/
	0x0F120132,	/*TVAR_wbt_pBaseCcms[82]*/
	0x0F12FF85,	/*TVAR_wbt_pBaseCcms[83]*/
	0x0F12018B,	/*TVAR_wbt_pBaseCcms[84]*/
	0x0F12FF73,	/*TVAR_wbt_pBaseCcms[85]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[86]*/
	0x0F12FF3F,	/*TVAR_wbt_pBaseCcms[87]*/
	0x0F12015B,	/*TVAR_wbt_pBaseCcms[88]*/
	0x0F1200D0,	/*TVAR_wbt_pBaseCcms[89]*/
	0x0F1201BF,	/*TVAR_wbt_pBaseCcms[90]*/
	0x0F12FFBF,	/*TVAR_wbt_pBaseCcms[91]*/
	0x0F12FFFE,	/*TVAR_wbt_pBaseCcms[92]*/
	0x0F12FF6D,	/*TVAR_wbt_pBaseCcms[93]*/
	0x0F1201B4,	/*TVAR_wbt_pBaseCcms[94]*/
	0x0F12FF66,	/*TVAR_wbt_pBaseCcms[95]*/
	0x0F12FFCA,	/*TVAR_wbt_pBaseCcms[96]*/
	0x0F12FFCE,	/*TVAR_wbt_pBaseCcms[97]*/
	0x0F12017B,	/*TVAR_wbt_pBaseCcms[98]*/
	0x0F120136,	/*TVAR_wbt_pBaseCcms[99]*/
	0x0F120132,	/*TVAR_wbt_pBaseCcms[100]*/
	0x0F12FF85,	/*TVAR_wbt_pBaseCcms[101]*/
	0x0F12018B,	/*TVAR_wbt_pBaseCcms[102]*/
	0x0F12FF73,	/*TVAR_wbt_pBaseCcms[103]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[104]*/
	0x0F12FF3F,	/*TVAR_wbt_pBaseCcms[105]*/
	0x0F12015B,	/*TVAR_wbt_pBaseCcms[106]*/
	0x0F1200D0,	/*TVAR_wbt_pBaseCcms[107]*/
	/*	param_end	TVAR_wbt_pBaseCcms*/
	/*	param_start	TVAR_wbt_pOutdoorCcm*/
	0x002A05CC,
	0x0F1238D8,	/*#TVAR_wbt_pOutdoorCcm*/
	0x0F127000,
	0x002A38D8,
	0x0F120235,	/*TVAR_wbt_pOutdoorCcm[0]*/
	0x0F12FFEF,	/*TVAR_wbt_pOutdoorCcm[1]*/
	0x0F120014,	/*TVAR_wbt_pOutdoorCcm[2]*/
	0x0F12FF67,	/*TVAR_wbt_pOutdoorCcm[3]*/
	0x0F12027D,	/*TVAR_wbt_pOutdoorCcm[4]*/
	0x0F12FFBA,	/*TVAR_wbt_pOutdoorCcm[5]*/
	0x0F12000D,	/*TVAR_wbt_pOutdoorCcm[6]*/
	0x0F120062,	/*TVAR_wbt_pOutdoorCcm[7]*/
	0x0F1202A7,	/*TVAR_wbt_pOutdoorCcm[8]*/
	0x0F1200C9,	/*TVAR_wbt_pOutdoorCcm[9]*/
	0x0F120123,	/*TVAR_wbt_pOutdoorCcm[10]*/
	0x0F12FF36,	/*TVAR_wbt_pOutdoorCcm[11]*/
	0x0F1201AD,	/*TVAR_wbt_pOutdoorCcm[12]*/
	0x0F12FFC8,	/*TVAR_wbt_pOutdoorCcm[13]*/
	0x0F120202,	/*TVAR_wbt_pOutdoorCcm[14]*/
	0x0F12FFCF,	/*TVAR_wbt_pOutdoorCcm[15]*/
	0x0F120257,	/*TVAR_wbt_pOutdoorCcm[16]*/
	0x0F12022C,	/*TVAR_wbt_pOutdoorCcm[17]*/
	/*	param_end	TVAR_wbt_pOutdoorCcm*/
	0x002A2404,
	0x0F120001,	/*#MVAR_AAIO_bFIT*/
	0x002A2408,
	0x0F120001,	/*#MVAR_AAIO_bAutoCCMandASH*/
	0x002A23DC,
	0x0F1201DD,	/*#Mon_AAIO_PrevFrmData_NormBr*/
	/*===================================================================*/
	/*AFIT*/
	/*===================================================================*/
	/*	param_start	afit_uNoiseIndInDoor*/
	0x002A065C,
	0x0F12004A,	/*#afit_uNoiseIndInDoor_0_*/
	0x0F12005F,	/*#afit_uNoiseIndInDoor_1_*/
	0x0F1200CB,	/*#afit_uNoiseIndInDoor_2_*/
	0x0F1201E0,	/*#afit_uNoiseIndInDoor_3_*/
	0x0F120220,	/*#afit_uNoiseIndInDoor_4_*/
	/*	param_end	afit_uNoiseIndInDoor*/
	/*	param_start	TVAR_afit_pBaseVals*/
	0x002A06BC,
	0x0F120000,	/*#AfitBaseVals		 AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_0__1_	 AFIT16_CONTRAST*/
	0x0F120014,	/*#AfitBaseVals_0__2_	 AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_0__3_	 AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_0__4_	 AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_0__5_	 AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_0__6_	 AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_0__7_
					AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_0__8_  AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_0__9_	 AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_0__10_
					AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_0__11_
					AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*#AfitBaseVals_0__12_  AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_0__13_ AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_0__14_	 AFIT16_demsharpmix1_iLowSat*/
	0x0F12005A,	/*#AfitBaseVals_0__15_	 AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_0__16_	 AFIT16_demsharpmix1_iTune*/
	0x0F12001E,	/*#AfitBaseVals_0__17_  AFIT16_demsharpmix1_iHystThLow*/
	0x0F12001E,	/*#AfitBaseVals_0__18_ AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201F4,	/*#AfitBaseVals_0__19_ AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*#AfitBaseVals_0__20_
					 AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120046,	/*#AfitBaseVals_0__21_
					AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120005,	/*#AfitBaseVals_0__22_
					AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120005,	/*#AfitBaseVals_0__23_
					AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F12003C,	/*#AfitBaseVals_0__24_AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_0__25_
					AFIT16_Sharpening_iHighSharpClamp*/
	0x0F12003C,	/*#AfitBaseVals_0__26_
					AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_0__27_
					AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12003C,	/*#AfitBaseVals_0__28_
					AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F12001E,	/*#AfitBaseVals_0__29_
					AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_0__30_
			AFIT8_sddd8a_edge_low [7:0],
					AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_0__31_
				AFIT8_sddd8a_repl_force [7:0],
					AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_0__32_AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_0__33_AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__34_AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__35_AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__36_AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_0__37_AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F120A3B,	/*#AfitBaseVals_0__38_AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_0__40_AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_0__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_0__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_0__43_
			AFIT8_Demosaicing_iDesatThresh[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_0__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_0__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_0__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F12001E,	/*#AfitBaseVals_0__47_AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120002,	/*#AfitBaseVals_0__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_0__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*#AfitBaseVals_0__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*#AfitBaseVals_0__51_AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_0__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_0__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_0__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*#AfitBaseVals_0__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128003,	/*#AfitBaseVals_0__56_
			AFIT8_YUV422_DENOISE_iYSupport [7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F121982,	/*#AfitBaseVals_0__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120A80,	/*#AfitBaseVals_0__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_0__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_0__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F124601,	/*#AfitBaseVals_0__62_AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F126444,	/*#AfitBaseVals_0__63_AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F129650,	/*#AfitBaseVals_0__64_AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*#AfitBaseVals_0__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F121E00,	/*#AfitBaseVals_0__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120714,	/*#AfitBaseVals_0__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121464,	/*#AfitBaseVals_0__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121404,	/*#AfitBaseVals_0__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F120F14,	/*#AfitBaseVals_0__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_0__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_0__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F121403,	/*#AfitBaseVals_0__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_0__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_0__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F124446,	/*#AfitBaseVals_0__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F125064,	/*#AfitBaseVals_0__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_0__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_0__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F12141E,	/*#AfitBaseVals_0__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F126407,	/*#AfitBaseVals_0__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120414,	/*#AfitBaseVals_0__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_0__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_0__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_0__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_0__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F124601,	/*#AfitBaseVals_0__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F126E44,	/*#AfitBaseVals_0__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122864,	/*#AfitBaseVals_0__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_0__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_0__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121E00,	/*#AfitBaseVals_0__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F120714,	/*#AfitBaseVals_0__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_0__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F120004,	/*#AfitBaseVals_0__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120F00,	/*#AfitBaseVals_0__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_0__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_0__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_0__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_1__0_ AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_1__1_ AFIT16_CONTRAST*/
	0x0F120014,	/*#AfitBaseVals_1__2_ AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_1__3_ AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_1__4_ AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_1__5_ AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_1__6_ AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_1__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_1__8_ AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_1__9_ AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_1__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_1__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*#AfitBaseVals_1__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_1__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_1__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F12005A,	/*#AfitBaseVals_1__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_1__16_AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*#AfitBaseVals_1__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_1__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*#AfitBaseVals_1__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*#AfitBaseVals_1__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120046,	/*#AfitBaseVals_1__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_1__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_1__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F120064,	/*#AfitBaseVals_1__24_AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_1__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F120064,	/*#AfitBaseVals_1__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_1__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12003C,	/*#AfitBaseVals_1__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F12001E,	/*#AfitBaseVals_1__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_1__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_1__31_AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_1__32_AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_1__33_AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_1__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*#AfitBaseVals_1__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_1__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_1__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_1__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_1__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_1__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_1__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_1__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_1__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120005,	/*#AfitBaseVals_1__47_AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120002,	/*#AfitBaseVals_1__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_1__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*#AfitBaseVals_1__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*#AfitBaseVals_1__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_1__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_1__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_1__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*#AfitBaseVals_1__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128003,	/*#AfitBaseVals_1__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120A6E,	/*#AfitBaseVals_1__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_1__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_1__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_1__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_1__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F122801,	/*#AfitBaseVals_1__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F12231E,	/*#AfitBaseVals_1__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12961E,	/*#AfitBaseVals_1__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*#AfitBaseVals_1__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A02,	/*#AfitBaseVals_1__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120764,	/*#AfitBaseVals_1__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F12143C,	/*#AfitBaseVals_1__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121401,	/*#AfitBaseVals_1__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F120F14,	/*#AfitBaseVals_1__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_1__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_1__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*#AfitBaseVals_1__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_1__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_1__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F121E28,	/*#AfitBaseVals_1__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12140F,	/*#AfitBaseVals_1__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_1__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_1__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F120200,	/*#AfitBaseVals_1__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*#AfitBaseVals_1__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123C07,	/*#AfitBaseVals_1__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_1__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121414,	/*#AfitBaseVals_1__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_1__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_1__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_1__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F121E1E,	/*#AfitBaseVals_1__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_1__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F123C01,	/*#AfitBaseVals_1__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F125A3A,	/*#AfitBaseVals_1__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122858,	/*#AfitBaseVals_1__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_1__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_1__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121E00,	/*#AfitBaseVals_1__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F120714,	/*#AfitBaseVals_1__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_1__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F120004,	/*#AfitBaseVals_1__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120F00,	/*#AfitBaseVals_1__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_1__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_1__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_1__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_2__0_AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_2__1_AFIT16_CONTRAST*/
	0x0F120000,	/*#AfitBaseVals_2__2_AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_2__3_AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_2__4_AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_2__5_AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_2__6_AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_2__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_2__8_AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_2__9_AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_2__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_2__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*#AfitBaseVals_2__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_2__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_2__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F12005A,	/*#AfitBaseVals_2__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_2__16_AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*#AfitBaseVals_2__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_2__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*#AfitBaseVals_2__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*#AfitBaseVals_2__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120032,	/*#AfitBaseVals_2__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_2__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_2__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F1200B4,	/*#AfitBaseVals_2__24_AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_2__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F1200B4,	/*#AfitBaseVals_2__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_2__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12003C,	/*#AfitBaseVals_2__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F12001E,	/*#AfitBaseVals_2__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_2__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_2__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_2__32_
			AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_2__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__35_AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__36_AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_2__37_AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*#AfitBaseVals_2__38_AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_2__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_2__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_2__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_2__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_2__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_2__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_2__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_2__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120005,	/*#AfitBaseVals_2__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120001,	/*#AfitBaseVals_2__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_2__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*#AfitBaseVals_2__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*#AfitBaseVals_2__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_2__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_2__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_2__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*#AfitBaseVals_2__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128002,	/*#AfitBaseVals_2__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120080,	/*#AfitBaseVals_2__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_2__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_2__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_2__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_2__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*#AfitBaseVals_2__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*#AfitBaseVals_2__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*#AfitBaseVals_2__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122A03,	/*#AfitBaseVals_2__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A02,	/*#AfitBaseVals_2__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120864,	/*#AfitBaseVals_2__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*#AfitBaseVals_2__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F129601,	/*#AfitBaseVals_2__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F122814,	/*#AfitBaseVals_2__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400A,	/*#AfitBaseVals_2__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_2__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*#AfitBaseVals_2__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_2__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_2__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F12191B,	/*#AfitBaseVals_2__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120D0F,	/*#AfitBaseVals_2__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_2__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_2__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F12021E,	/*#AfitBaseVals_2__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*#AfitBaseVals_2__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123208,	/*#AfitBaseVals_2__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_2__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121450,	/*#AfitBaseVals_2__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120A28,	/*#AfitBaseVals_2__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_2__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_2__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F122828,	/*#AfitBaseVals_2__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_2__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F122401,	/*#AfitBaseVals_2__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F123622,	/*#AfitBaseVals_2__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122832,	/*#AfitBaseVals_2__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_2__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121003,	/*#AfitBaseVals_2__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121E04,	/*#AfitBaseVals_2__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F120714,	/*#AfitBaseVals_2__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_2__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F125004,	/*#AfitBaseVals_2__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120F40,	/*#AfitBaseVals_2__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_2__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_2__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_2__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_3__0_AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_3__1_AFIT16_CONTRAST*/
	0x0F120000,	/*#AfitBaseVals_3__2_AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_3__3_AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_3__4_AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_3__5_AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_3__6_AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_3__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_3__8_AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_3__9_AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_3__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_3__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F1200C8,	/*#AfitBaseVals_3__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_3__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_3__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F120050,	/*#AfitBaseVals_3__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_3__16_AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*#AfitBaseVals_3__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_3__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*#AfitBaseVals_3__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*#AfitBaseVals_3__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120032,	/*#AfitBaseVals_3__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_3__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_3__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F1200B4,	/*#AfitBaseVals_3__24_
			AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_3__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F1200B4,	/*#AfitBaseVals_3__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_3__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12002D,	/*#AfitBaseVals_3__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F120019,	/*#AfitBaseVals_3__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_3__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_3__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_3__32_
			AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_3__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_3__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*#AfitBaseVals_3__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_3__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_3__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_3__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_3__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_3__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_3__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_3__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_3__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120005,	/*#AfitBaseVals_3__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120001,	/*#AfitBaseVals_3__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_3__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*#AfitBaseVals_3__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*#AfitBaseVals_3__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_3__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_3__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_3__
			54_AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*#AfitBaseVals_3__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128002,	/*#AfitBaseVals_3__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120080,	/*#AfitBaseVals_3__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_3__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_3__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_3__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_3__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*#AfitBaseVals_3__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*#AfitBaseVals_3__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*#AfitBaseVals_3__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122003,	/*#AfitBaseVals_3__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A02,	/*#AfitBaseVals_3__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120864,	/*#AfitBaseVals_3__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*#AfitBaseVals_3__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*#AfitBaseVals_3__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F122814,	/*#AfitBaseVals_3__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400A,	/*#AfitBaseVals_3__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_3__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*#AfitBaseVals_3__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_3__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_3__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F12191B,	/*#AfitBaseVals_3__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120D0F,	/*#AfitBaseVals_3__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_3__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_3__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F12021E,	/*#AfitBaseVals_3__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*#AfitBaseVals_3__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123208,	/*#AfitBaseVals_3__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_3__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121450,	/*#AfitBaseVals_3__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120A28,	/*#AfitBaseVals_3__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_3__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_3__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F123C3C,	/*#AfitBaseVals_3__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_3__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F121E01,	/*#AfitBaseVals_3__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F12221C,	/*#AfitBaseVals_3__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F12281E,	/*#AfitBaseVals_3__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_3__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*#AfitBaseVals_3__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121402,	/*#AfitBaseVals_3__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F12060E,	/*#AfitBaseVals_3__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_3__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F125204,	/*#AfitBaseVals_3__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120C40,	/*#AfitBaseVals_3__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F124015,	/*#AfitBaseVals_3__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_3__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_3__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_4__0_AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_4__1_AFIT16_CONTRAST*/
	0x0F120000,	/*#AfitBaseVals_4__2_AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_4__3_AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_4__4_AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_4__5_AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_4__6_AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_4__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_4__8_AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_4__9_AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_4__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_4__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F120032,	/*#AfitBaseVals_4__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F12028A,	/*#AfitBaseVals_4__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120032,	/*#AfitBaseVals_4__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F1201F4,	/*#AfitBaseVals_4__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_4__16_AFIT16_demsharpmix1_iTune*/
	0x0F120002,	/*#AfitBaseVals_4__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_4__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201AA,	/*#AfitBaseVals_4__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F12003C,	/*#AfitBaseVals_4__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120050,	/*#AfitBaseVals_4__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_4__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_4__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F1200B4,	/*#AfitBaseVals_4__24_
			AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_4__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F1200B4,	/*#AfitBaseVals_4__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_4__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F120046,	/*#AfitBaseVals_4__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F120019,	/*#AfitBaseVals_4__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_4__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_4__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_4__32_
			AFIT8_sddd8a_sat_thr[7:0], AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F120503,	/*#AfitBaseVals_4__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F12080F,	/*#AfitBaseVals_4__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120808,	/*#AfitBaseVals_4__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_4__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_4__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12022D,	/*#AfitBaseVals_4__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_4__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_4__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_4__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12061E,	/*#AfitBaseVals_4__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_4__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120606,	/*#AfitBaseVals_4__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A03,	/*#AfitBaseVals_4__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120028,	/*#AfitBaseVals_4__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120002,	/*#AfitBaseVals_4__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120001,	/*#AfitBaseVals_4__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_4__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*#AfitBaseVals_4__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*#AfitBaseVals_4__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_4__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_4__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_4__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*#AfitBaseVals_4__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128001,	/*#AfitBaseVals_4__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120080,	/*#AfitBaseVals_4__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_4__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_4__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_4__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_4__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*#AfitBaseVals_4__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F121219,	/*#AfitBaseVals_4__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12320D,	/*#AfitBaseVals_4__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120A0A,	/*#AfitBaseVals_4__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122304,	/*#AfitBaseVals_4__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A08,	/*#AfitBaseVals_4__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120832,	/*#AfitBaseVals_4__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*#AfitBaseVals_4__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*#AfitBaseVals_4__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F122A0A,	/*#AfitBaseVals_4__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F124006,	/*#AfitBaseVals_4__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120604,	/*#AfitBaseVals_4__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125006,	/*#AfitBaseVals_4__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_4__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_4__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F12191B,	/*#AfitBaseVals_4__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120D0F,	/*#AfitBaseVals_4__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120A28,	/*#AfitBaseVals_4__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F12040A,	/*#AfitBaseVals_4__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F120820,	/*#AfitBaseVals_4__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F12280A,	/*#AfitBaseVals_4__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123208,	/*#AfitBaseVals_4__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_4__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F120A64,	/*#AfitBaseVals_4__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F12062A,	/*#AfitBaseVals_4__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_4__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120606,	/*#AfitBaseVals_4__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F124646,	/*#AfitBaseVals_4__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_4__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F121801,	/*#AfitBaseVals_4__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F12191C,	/*#AfitBaseVals_4__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122818,	/*#AfitBaseVals_4__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_4__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*#AfitBaseVals_4__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121405,	/*#AfitBaseVals_4__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F12050C,	/*#AfitBaseVals_4__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_4__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F125204,	/*#AfitBaseVals_4__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F121440,	/*#AfitBaseVals_4__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F124015,	/*#AfitBaseVals_4__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_4__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_4__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	/*	param_end	TVAR_afit_pBaseVals*/
	/*	param_start	afit_pConstBaseVals*/
	0x0F127DFA,	/*#ConstAfitBaseVals	Because	of Edge,
			disable the iGradientWide*/
	0x0F12FFBD,	/*#ConstAfitBaseVals_1_*/
	0x0F1226FE,	/*#ConstAfitBaseVals_2_*/
	0x0F12F7BC,	/*#ConstAfitBaseVals_3_*/
	0x0F127E06,	/*#ConstAfitBaseVals_4_*/
	0x0F1200D3,	/*#ConstAfitBaseVals_5_*/
	/*	param_end	afit_pConstBaseVals*/
	/* AFIT	by Normalized Brightness Tuning	parameter*/
	0x002A3780,
	0x0F120000,	/* on/off AFIT by NB option 0000 : Ni  0001:Nb*/
	0x0F120014,	/* NormBR[0]*/
	0x002A3782,
	0x0F1200D2,	/* NormBR[1]*/
	0x002A3782,
	0x0F120384,	/* NormBR[2]*/
	0x002A3782,
	0x0F1207D0,	/* NormBR[3]*/
	0x002A3782,
	0x0F121388,	/* NormBR[4]*/
};


/* Set-data based on Samsung Reliabilty	Group standard
* ,when	using WIFI. 15fps
*/
static const u32 s5k5bbgx_vt_wifi_common[] = {
	0xFCFCD000,
	/*===================================================================*/
	/* Reset*/
	/*===================================================================*/
	0x00100001,	/*sw_reset*/
	0x10300000,	/*contint_host_int*/
	0x00140001,	/*sw_load_complete-Release CORE (Arm) from reset state*/
	0x01520084,	/*make alive voltage low*/
	0xFFFF000A,
	/* Start of	Patch data*/
	0x00287000,
	0x002A2744,
	0x0F12B510,	/* 70002744*/
	0x0F124A12,	/* 70002746*/
	0x0F12217B,	/* 70002748*/
	0x0F124812,	/* 7000274A*/
	0x0F12C004,	/* 7000274C*/
	0x0F126001,	/* 7000274E*/
	0x0F124911,	/* 70002750*/
	0x0F124812,	/* 70002752*/
	0x0F12F000,	/* 70002754*/
	0x0F12F926,	/* 70002756*/
	0x0F124911,	/* 70002758*/
	0x0F124812,	/* 7000275A*/
	0x0F12F000,	/* 7000275C*/
	0x0F12F922,	/* 7000275E*/
	0x0F124911,	/* 70002760*/
	0x0F124812,	/* 70002762*/
	0x0F12F000,	/* 70002764*/
	0x0F12F91E,	/* 70002766*/
	0x0F124911,	/* 70002768*/
	0x0F124812,	/* 7000276A*/
	0x0F12F000,	/* 7000276C*/
	0x0F12F91A,	/* 7000276E*/
	0x0F124911,	/* 70002770*/
	0x0F124812,	/* 70002772*/
	0x0F12F000,	/* 70002774*/
	0x0F12F916,	/* 70002776*/
	0x0F124911,	/* 70002778*/
	0x0F124812,	/* 7000277A*/
	0x0F12F000,	/* 7000277C*/
	0x0F12F912,	/* 7000277E*/
	0x0F124911,	/* 70002780*/
	0x0F124812,	/* 70002782*/
	0x0F12F000,	/* 70002784*/
	0x0F12F90E,	/* 70002786*/
	0x0F12BC10,	/* 70002788*/
	0x0F12BC08,	/* 7000278A*/
	0x0F124718,	/* 7000278C*/
	0x0F120000,	/* 7000278E*/
	0x0F120000,	/* 70002790*/
	0x0F125BB1,	/* 70002792*/
	0x0F121770,	/* 70002794*/
	0x0F127000,	/* 70002796*/
	0x0F1227D1,	/* 70002798*/
	0x0F127000,	/* 7000279A*/
	0x0F12C0BB,	/* 7000279C*/
	0x0F120000,	/* 7000279E*/
	0x0F12280F,	/* 700027A0*/
	0x0F127000,	/* 700027A2*/
	0x0F123609,	/* 700027A4*/
	0x0F120000,	/* 700027A6*/
	0x0F122827,	/* 700027A8*/
	0x0F127000,	/* 700027AA*/
	0x0F1277C7,	/* 700027AC*/
	0x0F120000,	/* 700027AE*/
	0x0F1228B3,	/* 700027B0*/
	0x0F127000,	/* 700027B2*/
	0x0F12727D,	/* 700027B4*/
	0x0F120000,	/* 700027B6*/
	0x0F1228CD,	/* 700027B8*/
	0x0F127000,	/* 700027BA*/
	0x0F129919,	/* 700027BC*/
	0x0F120000,	/* 700027BE*/
	0x0F12290B,	/* 700027C0*/
	0x0F127000,	/* 700027C2*/
	0x0F121C63,	/* 700027C4*/
	0x0F120000,	/* 700027C6*/
	0x0F12296B,	/* 700027C8*/
	0x0F127000,	/* 700027CA*/
	0x0F1204CB,	/* 700027CC*/
	0x0F120000,	/* 700027CE*/
	0x0F12B4F0,	/* 700027D0*/
	0x0F126801,	/* 700027D2*/
	0x0F12468C,	/* 700027D4*/
	0x0F126846,	/* 700027D6*/
	0x0F122200,	/* 700027D8*/
	0x0F124968,	/* 700027DA*/
	0x0F122000,	/* 700027DC*/
	0x0F122724,	/* 700027DE*/
	0x0F124357,	/* 700027E0*/
	0x0F12183B,	/* 700027E2*/
	0x0F124664,	/* 700027E4*/
	0x0F125CE5,	/* 700027E6*/
	0x0F12005C,	/* 700027E8*/
	0x0F125B34,	/* 700027EA*/
	0x0F12072D,	/* 700027EC*/
	0x0F120F2D,	/* 700027EE*/
	0x0F12800D,	/* 700027F0*/
	0x0F12804C,	/* 700027F2*/
	0x0F12808B,	/* 700027F4*/
	0x0F122301,	/* 700027F6*/
	0x0F1280CB,	/* 700027F8*/
	0x0F122300,	/* 700027FA*/
	0x0F1280CB,	/* 700027FC*/
	0x0F121C40,	/* 700027FE*/
	0x0F122824,	/* 70002800*/
	0x0F12D3EE,	/* 70002802*/
	0x0F121C52,	/* 70002804*/
	0x0F122A04,	/* 70002806*/
	0x0F12D3E8,	/* 70002808*/
	0x0F12BCF0,	/* 7000280A*/
	0x0F124770,	/* 7000280C*/
	0x0F12B510,	/* 7000280E*/
	0x0F12F000,	/* 70002810*/
	0x0F12F8D0,	/* 70002812*/
	0x0F12485A,	/* 70002814*/
	0x0F127A81,	/* 70002816*/
	0x0F12485A,	/* 70002818*/
	0x0F126B00,	/* 7000281A*/
	0x0F12F000,	/* 7000281C*/
	0x0F12F8D2,	/* 7000281E*/
	0x0F12BC10,	/* 70002820*/
	0x0F12BC08,	/* 70002822*/
	0x0F124718,	/* 70002824*/
	0x0F12B5F8,	/* 70002826*/
	0x0F126805,	/* 70002828*/
	0x0F126844,	/* 7000282A*/
	0x0F124E56,	/* 7000282C*/
	0x0F128861,	/* 7000282E*/
	0x0F128AB0,	/* 70002830*/
	0x0F128A72,	/* 70002832*/
	0x0F122301,	/* 70002834*/
	0x0F124368,	/* 70002836*/
	0x0F121889,	/* 70002838*/
	0x0F1217C2,	/* 7000283A*/
	0x0F120E12,	/* 7000283C*/
	0x0F121810,	/* 7000283E*/
	0x0F121202,	/* 70002840*/
	0x0F128820,	/* 70002842*/
	0x0F12029B,	/* 70002844*/
	0x0F1218C0,	/* 70002846*/
	0x0F12F000,	/* 70002848*/
	0x0F12F8C4,	/* 7000284A*/
	0x0F129000,	/* 7000284C*/
	0x0F128AF6,	/* 7000284E*/
	0x0F124268,	/* 70002850*/
	0x0F12210A,	/* 70002852*/
	0x0F124370,	/* 70002854*/
	0x0F12F000,	/* 70002856*/
	0x0F12F8C5,	/* 70002858*/
	0x0F12436E,	/* 7000285A*/
	0x0F120007,	/* 7000285C*/
	0x0F12210A,	/* 7000285E*/
	0x0F120030,	/* 70002860*/
	0x0F12F000,	/* 70002862*/
	0x0F12F8BF,	/* 70002864*/
	0x0F129A00,	/* 70002866*/
	0x0F120039,	/* 70002868*/
	0x0F12F000,	/* 7000286A*/
	0x0F12F8C1,	/* 7000286C*/
	0x0F120002,	/* 7000286E*/
	0x0F128820,	/* 70002870*/
	0x0F121880,	/* 70002872*/
	0x0F128020,	/* 70002874*/
	0x0F124845,	/* 70002876*/
	0x0F1288C1,	/* 70002878*/
	0x0F124843,	/* 7000287A*/
	0x0F123820,	/* 7000287C*/
	0x0F128B40,	/* 7000287E*/
	0x0F124240,	/* 70002880*/
	0x0F124350,	/* 70002882*/
	0x0F12F000,	/* 70002884*/
	0x0F12F8AE,	/* 70002886*/
	0x0F128861,	/* 70002888*/
	0x0F121840,	/* 7000288A*/
	0x0F128060,	/* 7000288C*/
	0x0F12BCF8,	/* 7000288E*/
	0x0F12BC08,	/* 70002890*/
	0x0F124718,	/* 70002892*/
	0x0F12B570,	/* 70002894*/
	0x0F124C3C,	/* 70002896*/
	0x0F123C20,	/* 70002898*/
	0x0F128B20,	/* 7000289A*/
	0x0F12F000,	/* 7000289C*/
	0x0F12F8B0,	/* 7000289E*/
	0x0F124D3A,	/* 700028A0*/
	0x0F1280E8,	/* 700028A2*/
	0x0F128B60,	/* 700028A4*/
	0x0F12F000,	/* 700028A6*/
	0x0F12F8B3,	/* 700028A8*/
	0x0F128128,	/* 700028AA*/
	0x0F12BC70,	/* 700028AC*/
	0x0F12BC08,	/* 700028AE*/
	0x0F124718,	/* 700028B0*/
	0x0F12B510,	/* 700028B2*/
	0x0F124836,	/* 700028B4*/
	0x0F12214D,	/* 700028B6*/
	0x0F128201,	/* 700028B8*/
	0x0F122196,	/* 700028BA*/
	0x0F128281,	/* 700028BC*/
	0x0F12211D,	/* 700028BE*/
	0x0F128301,	/* 700028C0*/
	0x0F12F7FF,	/* 700028C2*/
	0x0F12FFE7,	/* 700028C4*/
	0x0F12F000,	/* 700028C6*/
	0x0F12F8AB,	/* 700028C8*/
	0x0F12E7A9,	/* 700028CA*/
	0x0F12B570,	/* 700028CC*/
	0x0F120004,	/* 700028CE*/
	0x0F126820,	/* 700028D0*/
	0x0F126865,	/* 700028D2*/
	0x0F12F000,	/* 700028D4*/
	0x0F12F8AC,	/* 700028D6*/
	0x0F120402,	/* 700028D8*/
	0x0F12482E,	/* 700028DA*/
	0x0F120C12,	/* 700028DC*/
	0x0F128142,	/* 700028DE*/
	0x0F12482D,	/* 700028E0*/
	0x0F128801,	/* 700028E2*/
	0x0F122900,	/* 700028E4*/
	0x0F12D008,	/* 700028E6*/
	0x0F12492C,	/* 700028E8*/
	0x0F12002B,	/* 700028EA*/
	0x0F126D8A,	/* 700028EC*/
	0x0F122105,	/* 700028EE*/
	0x0F121C80,	/* 700028F0*/
	0x0F12F000,	/* 700028F2*/
	0x0F12F8A5,	/* 700028F4*/
	0x0F126020,	/* 700028F6*/
	0x0F12E005,	/* 700028F8*/
	0x0F124829,	/* 700028FA*/
	0x0F12002B,	/* 700028FC*/
	0x0F122105,	/* 700028FE*/
	0x0F12F000,	/* 70002900*/
	0x0F12F89E,	/* 70002902*/
	0x0F126020,	/* 70002904*/
	0x0F126820,	/* 70002906*/
	0x0F12E7D0,	/* 70002908*/
	0x0F12B5F8,	/* 7000290A*/
	0x0F124923,	/* 7000290C*/
	0x0F122200,	/* 7000290E*/
	0x0F123160,	/* 70002910*/
	0x0F1283CA,	/* 70002912*/
	0x0F126800,	/* 70002914*/
	0x0F124669,	/* 70002916*/
	0x0F12F000,	/* 70002918*/
	0x0F12F89A,	/* 7000291A*/
	0x0F12466B,	/* 7000291C*/
	0x0F128818,	/* 7000291E*/
	0x0F12F000,	/* 70002920*/
	0x0F12F86E,	/* 70002922*/
	0x0F120005,	/* 70002924*/
	0x0F12466B,	/* 70002926*/
	0x0F128858,	/* 70002928*/
	0x0F12F000,	/* 7000292A*/
	0x0F12F871,	/* 7000292C*/
	0x0F120004,	/* 7000292E*/
	0x0F122101,	/* 70002930*/
	0x0F121928,	/* 70002932*/
	0x0F1202C9,	/* 70002934*/
	0x0F121A08,	/* 70002936*/
	0x0F120286,	/* 70002938*/
	0x0F120029,	/* 7000293A*/
	0x0F120030,	/* 7000293C*/
	0x0F12F000,	/* 7000293E*/
	0x0F12F88F,	/* 70002940*/
	0x0F120005,	/* 70002942*/
	0x0F122701,	/* 70002944*/
	0x0F1202BF,	/* 70002946*/
	0x0F120021,	/* 70002948*/
	0x0F120030,	/* 7000294A*/
	0x0F12F000,	/* 7000294C*/
	0x0F12F888,	/* 7000294E*/
	0x0F124912,	/* 70002950*/
	0x0F124A0E,	/* 70002952*/
	0x0F123140,	/* 70002954*/
	0x0F123AC0,	/* 70002956*/
	0x0F12800D,	/* 70002958*/
	0x0F128395,	/* 7000295A*/
	0x0F12804F,	/* 7000295C*/
	0x0F1283D7,	/* 7000295E*/
	0x0F128088,	/* 70002960*/
	0x0F120011,	/* 70002962*/
	0x0F123120,	/* 70002964*/
	0x0F128008,	/* 70002966*/
	0x0F12E791,	/* 70002968*/
	0x0F12B510,	/* 7000296A*/
	0x0F12480A,	/* 7000296C*/
	0x0F128980,	/* 7000296E*/
	0x0F122800,	/* 70002970*/
	0x0F12D001,	/* 70002972*/
	0x0F12F000,	/* 70002974*/
	0x0F12F87A,	/* 70002976*/
	0x0F12E752,	/* 70002978*/
	0x0F120000,	/* 7000297A*/
	0x0F124140,	/* 7000297C*/
	0x0F12D000,	/* 7000297E*/
	0x0F1219DC,	/* 70002980*/
	0x0F127000,	/* 70002982*/
	0x0F121B60,	/* 70002984*/
	0x0F127000,	/* 70002986*/
	0x0F120DD4,	/* 70002988*/
	0x0F127000,	/* 7000298A*/
	0x0F1222AC,	/* 7000298C*/
	0x0F127000,	/* 7000298E*/
	0x0F121E8C,	/* 70002990*/
	0x0F127000,	/* 70002992*/
	0x0F121A10,	/* 70002994*/
	0x0F127000,	/* 70002996*/
	0x0F123780,	/* 70002998*/
	0x0F127000,	/* 7000299A*/
	0x0F122384,	/* 7000299C*/
	0x0F127000,	/* 7000299E*/
	0x0F12065C,	/* 700029A0*/
	0x0F127000,	/* 700029A2*/
	0x0F124778,	/* 700029A4*/
	0x0F1246C0,	/* 700029A6*/
	0x0F12C000,	/* 700029A8*/
	0x0F12E59F,	/* 700029AA*/
	0x0F12FF1C,	/* 700029AC*/
	0x0F12E12F,	/* 700029AE*/
	0x0F12CE77,	/* 700029B0*/
	0x0F120000,	/* 700029B2*/
	0x0F124778,	/* 700029B4*/
	0x0F1246C0,	/* 700029B6*/
	0x0F12C000,	/* 700029B8*/
	0x0F12E59F,	/* 700029BA*/
	0x0F12FF1C,	/* 700029BC*/
	0x0F12E12F,	/* 700029BE*/
	0x0F123609,	/* 700029C0*/
	0x0F120000,	/* 700029C2*/
	0x0F124778,	/* 700029C4*/
	0x0F1246C0,	/* 700029C6*/
	0x0F12C000,	/* 700029C8*/
	0x0F12E59F,	/* 700029CA*/
	0x0F12FF1C,	/* 700029CC*/
	0x0F12E12F,	/* 700029CE*/
	0x0F129F91,	/* 700029D0*/
	0x0F120000,	/* 700029D2*/
	0x0F124778,	/* 700029D4*/
	0x0F1246C0,	/* 700029D6*/
	0x0F12C000,	/* 700029D8*/
	0x0F12E59F,	/* 700029DA*/
	0x0F12FF1C,	/* 700029DC*/
	0x0F12E12F,	/* 700029DE*/
	0x0F122AE3,	/* 700029E0*/
	0x0F120000,	/* 700029E2*/
	0x0F124778,	/* 700029E4*/
	0x0F1246C0,	/* 700029E6*/
	0x0F12F004,	/* 700029E8*/
	0x0F12E51F,	/* 700029EA*/
	0x0F12D1DC,	/* 700029EC*/
	0x0F120000,	/* 700029EE*/
	0x0F124778,	/* 700029F0*/
	0x0F1246C0,	/* 700029F2*/
	0x0F12C000,	/* 700029F4*/
	0x0F12E59F,	/* 700029F6*/
	0x0F12FF1C,	/* 700029F8*/
	0x0F12E12F,	/* 700029FA*/
	0x0F126869,	/* 700029FC*/
	0x0F120000,	/* 700029FE*/
	0x0F124778,	/* 70002A00*/
	0x0F1246C0,	/* 70002A02*/
	0x0F12C000,	/* 70002A04*/
	0x0F12E59F,	/* 70002A06*/
	0x0F12FF1C,	/* 70002A08*/
	0x0F12E12F,	/* 70002A0A*/
	0x0F1268BD,	/* 70002A0C*/
	0x0F120000,	/* 70002A0E*/
	0x0F124778,	/* 70002A10*/
	0x0F1246C0,	/* 70002A12*/
	0x0F12C000,	/* 70002A14*/
	0x0F12E59F,	/* 70002A16*/
	0x0F12FF1C,	/* 70002A18*/
	0x0F12E12F,	/* 70002A1A*/
	0x0F1268DB,	/* 70002A1C*/
	0x0F120000,	/* 70002A1E*/
	0x0F124778,	/* 70002A20*/
	0x0F1246C0,	/* 70002A22*/
	0x0F12C000,	/* 70002A24*/
	0x0F12E59F,	/* 70002A26*/
	0x0F12FF1C,	/* 70002A28*/
	0x0F12E12F,	/* 70002A2A*/
	0x0F1271B9,	/* 70002A2C*/
	0x0F120000,	/* 70002A2E*/
	0x0F124778,	/* 70002A30*/
	0x0F1246C0,	/* 70002A32*/
	0x0F12C000,	/* 70002A34*/
	0x0F12E59F,	/* 70002A36*/
	0x0F12FF1C,	/* 70002A38*/
	0x0F12E12F,	/* 70002A3A*/
	0x0F1298CD,	/* 70002A3C*/
	0x0F120000,	/* 70002A3E*/
	0x0F124778,	/* 70002A40*/
	0x0F1246C0,	/* 70002A42*/
	0x0F12C000,	/* 70002A44*/
	0x0F12E59F,	/* 70002A46*/
	0x0F12FF1C,	/* 70002A48*/
	0x0F12E12F,	/* 70002A4A*/
	0x0F12987F,	/* 70002A4C*/
	0x0F120000,	/* 70002A4E*/
	0x0F124778,	/* 70002A50*/
	0x0F1246C0,	/* 70002A52*/
	0x0F12C000,	/* 70002A54*/
	0x0F12E59F,	/* 70002A56*/
	0x0F12FF1C,	/* 70002A58*/
	0x0F12E12F,	/* 70002A5A*/
	0x0F121BC9,	/* 70002A5C*/
	0x0F120000,	/* 70002A5E*/
	0x0F124778,	/* 70002A60*/
	0x0F1246C0,	/* 70002A62*/
	0x0F12F004,	/* 70002A64*/
	0x0F12E51F,	/* 70002A66*/
	0x0F12D378,	/* 70002A68*/
	0x0F120000,	/* 70002A6A*/
	0x0F124778,	/* 70002A6C*/
	0x0F1246C0,	/* 70002A6E*/
	0x0F12C000,	/* 70002A70*/
	0x0F12E59F,	/* 70002A72*/
	0x0F12FF1C,	/* 70002A74*/
	0x0F12E12F,	/* 70002A76*/
	0x0F1204CB,	/* 70002A78*/
	0x0F120000,	/* 70002A7A*/
	0x002A378C,
	0x0F120000,	/* On/off register bUseOTP*/
	0x002A0DCC,
	0x0F120138,	/*awbb_IntcR*/
	0x0F12011C,	/*awbb_IntcB*/
	/*===================================================================*/
	/*Analog & APS Control*/
	/*===================================================================*/
	0x0028D000,
	0x002AF404,
	0x0F120038,	/* aig_adc_sat[7:0] : 850mV, revised by	Ana 20100524*/
	0x0F120001,	/* aig_ms[2:0] : revised by Ana	20100202*/
	0x0F12000C,	/* aig_sig_mx[5:0]*/
	0x0F120006,	/* aig_rst_mx[5:0]*/
	0x0F120008,	/* aig_rmp_option[3] SL_Low_PWR_SAVE On	:
			revised by Ana 20100204*/
	0x002AF418,
	0x0F120003,	/* aig_dbr_clk_sel[1:0]	: revised by Ana 20100201*/
	0x002AF41C,
	0x0F120140,	/* aig_bist_sig_width_e[10:0]*/
	0x0F120140,	/* aig_bist_sig_width_o[10:0]*/
	0x0F120066,	/* aig_bist_sig_width_o[10:0]*/
	0x0F120005,	/* aig_pix_bias[3:0]*/
	0x002AF426,
	0x0F1200D4,	/* aig_clp_lvl[7:0]*/
	0x002AF42A,
	0x0F120001,	/* aig_ref_option[0] SL_Low_PWR_SAVE On	:
			revised by Ana 20100204*/
	0x002AF430,
	0x0F120001,	/* aig_pd_cp_rosc[0] : revised by Ana 20100201*/
	0x0F120001,	/* aig_pd_ncp_rosc[0] :	revised	by Ana 20100201*/
	0x002AF43A,
	0x0F120000,	/* aig_pd_fblv[0] : revised by Ana 20100203*/
	0x002AF440,
	0x0F120044,	/* aig_rosc_tune_ncp[7:4]*/
	/* aig_rosc_tune_cp[3:0]*/
	0x002AF44A,
	0x0F120000,	/* aig_fb_lv[1:0] : revised by Ana 20100204*/
	0x002AF45C,
	0x0F120000,	/* aig_dshut_en[0] : revised by	APS 20100223*/
	0x0F120000,	/* aig_srx_en[0]*/
	0x002AF462,
	0x0F120001,	/* aig_pdb_atop[0]*/
	0x002AF46E,
	0x0F121F02,	/* aig_cds_test[15:0]*/
	0x002AF474,
	0x0F12000E,	/* aig_stx_gap[4:0]*/
	0x002AE42E,
	0x0F120004,	/* adlc_qec[2:0] : revised by Dithered L-ADLC Designer
			20100203*/
	0x00287000,
	0x002A13E0,
	0x0F120000,	/*700013E0 SRX OFF*/
	0x002A13C8,
	0x0F120001,	/*700013C8 AAC Enable*/
	0x002A12D8,
	0x0F120464,	/*700012d8*/
	0x0F120468,	/*700012da*/
	0x002A12F6,
	0x0F120000,	/*700012f6*/
	0x002A13CC,
	0x0F121FC0,	/* [12:0] : Write tuning value to E404 register*/
	0x002A13EC,
	0x0F120001,
	0x002A184C,
	0x0F121EE1,
	0x0028D000,
	0x002A1000,
	0x0F120001,
	0x00287000,
	0x002A040E,
	0x0F120003,	/*STBY TnP enable setting STBY TnP enable setting [0]
			bit  STBY enable,[1] bit STBY ø TnP ? on/off bit*/
	0xFFFF000A,
	/*H-Digital	binning	& V-PLA*/
	0x002A1218,
	0x0F120002,	/*subsampling number.*/
	0x0F120002,	/*subsampling number.*/
	0x002A0C9A,
	0x0F120001,	/* setot_bUseDigitalHbin  0 : do not use bin block*/
	/*			      1	: use binning block*/
	0x002A1438,
	0x0F12F468,	/* senHal_TuneStr_AngTuneData1[0]  : tuning register
			setting.*/
	0x0F120000,	/* not use binninb block 0x0000	,use binnin blcok
			0x0000*/
	0x0F120008,	/* not use binninb block 0x000A	,use binnin blcok
			0x0008*/
	0x0F120006,	/* not use binninb block 0x0005	, use binnin blcok
			0x0006*/
	0x0F120000,	/* 0x0000 , 0x0000*/
	0xFFFF000A,
	/* Backup Register*/
	0x002A0416,
	0x0F12F400,
	0x0F120074,
	0x0F12E42E,
	0x0F120030,
	/*clk Settings*/
	0x00287000,
	0x002A00F4,
	0x0F125DC0,	/*REG_TC_IPRM_InClockLSBs		2   700000F4*/
	/*0x0F120000*/	/*REG_TC_IPRM_InClockMSBs		2   700000F6*/
	0x002A0110,
	0x0F120003,	/*REG_TC_IPRM_UseNPviClocks		2   70000110*/
	0x0F120000,	/*REG_TC_IPRM_bBlockInternalPllCalc	2   70000112*/
	/*SYSTEM CLOCK*/
	0x0F12222E,	/*REG_TC_IPRM_OpClk4KHz_0		2   70000114
			35000Khz/4=HEX()*/
	0x0F12445C,	/*REG_TC_IPRM_MinOutRate4KHz_0		2   70000116*/
	0x0F12445C,	/*REG_TC_IPRM_MaxOutRate4KHz_0		2   70000118*/
	0x0F121117,	/*1770	    REG_TC_IPRM_OpClk4KHz_1	2	7000011A
			24000Khz/4*/
	0x0F12222E,	/*REG_TC_IPRM_MinOutRate4KHz_1		2   7000011C
			36000khz/4 =2328hex*/
	0x0F12222E,	/*REG_TC_IPRM_MaxOutRate4KHz_1		2   7000011E*/
	0x0F120BB8,	/*REG_TC_IPRM_OpClk4KHz_2		2   70000120
			12000Khz*/
	0x0F1205DC,	/*REG_TC_IPRM_MinOutRate4KHz_2		2   70000122*/
	0x0F121770,	/*REG_TC_IPRM_MaxOutRate4KHz_2		2   70000124*/
	0x0F120001,	/*REG_TC_IPRM_InitParamsUpdated		2   70000126*/
	0xFFFF0064,
	0x002A1218,
	0x0F120002,
	/*===================================================================*/
	/*Preview0 1600x1200 system	32M PCLK 70M From APS*/
	/*===================================================================*/
	0x002A0144,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,
	/*Preview0 for 7.5~15fps*/
	0x002A0170,
	0x0F120280,	/*REG_0TC_PCFG_usWidth			2   70000170*/
	0x0F1201e0,	/*REG_0TC_PCFG_usHeight			2   70000172*/
	0x0F120005,	/*REG_0TC_PCFG_Format			2   70000174*/
	0x0F12222E,	/*REG_0TC_PCFG_usMaxOut4KHzRate		2   70000176*/
	0x0F12222E,	/*REG_0TC_PCFG_usMinOut4KHzRate		2   70000178*/
	0x0F120042,	/*REG_0TC_PCFG_PVIMask			2   7000017A*/
	0x0F120010,	/*REG_0TC_PCFG_OIFMask			2   7000017C*/
	0x0F120001,	/*REG_0TC_PCFG_uClockInd		2   7000017E*/
	0x0F120002,	/*REG_0TC_PCFG_usFrTimeType		2   70000180
			0b : dynamic 01:fix not accurate 02b: fixed_Accurate*/
	0x0F120001,	/*REG_0TC_PCFG_FrRateQualityType	2   70000182
			1b: FR (bin) 2b: Quality (no-bin)*/
	0x0F12029a,	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10	2   70000184
			max frame	time : 30fps 014D 15fps	029a; a6a -
			3.75 fps; 0535 - 7.5FPS*/
	0x0F12029A,	/*REG_0TC_PCFG_usMinFrTimeMsecMult10	2   70000186*/
	0x0F120000,	/*REG_0TC_PCFG_bSmearOutput		2   70000188*/
	0x0F120000,	/*REG_0TC_PCFG_sSaturation		2   7000018A*/
	0x0F120000,	/*REG_0TC_PCFG_sSharpBlur		2   7000018C*/
	0x0F120000,	/*REG_0TC_PCFG_sColorTemp		2   7000018E*/
	0x0F120000,	/*REG_0TC_PCFG_uDeviceGammaIndex	2   70000190*/
	0x0F120000,	/*REG_0TC_PCFG_uPrevMirror		2   70000192*/
	0x0F120000,	/*REG_0TC_PCFG_uCaptureMirror		2   70000194*/
	0x0F120000,	/*REG_0TC_PCFG_uRotation		2   70000196*/
	/*Preview1 for fixed 15fps*/
	0x0F120280,	/*REG_1TC_PCFG_usWidth			2   70000198*/
	0x0F1201e0,	/*REG_1TC_PCFG_usHeight			2   7000019A*/
	0x0F120005,	/*REG_1TC_PCFG_Format			2   7000019C*/
	0x0F12222E,	/*REG_1TC_PCFG_usMaxOut4KHzRate		2   7000019E*/
	0x0F12222E,	/*REG_1TC_PCFG_usMinOut4KHzRate		2   700001A0*/
	0x0F120042,	/*REG_1TC_PCFG_PVIMask			2   700001A2*/
	0x0F120010,	/*REG_1TC_PCFG_OIFMask			2   700001A4*/
	0x0F120001,	/*REG_1TC_PCFG_uClockInd		2   700001A6*/
	0x0F120000,	/*REG_1TC_PCFG_usFrTimeType		2   700001A8*/
	0x0F120001,	/*REG_1TC_PCFG_FrRateQualityType	2   700001AA*/
	0x0F12029A,	/*REG_1TC_PCFG_usMaxFrTimeMsecMult10	2   700001AC*/
	0x0F12029A,	/*REG_1TC_PCFG_usMinFrTimeMsecMult10	2   700001AE*/
	0x0F120000,	/*REG_1TC_PCFG_bSmearOutput		2   700001B0*/
	0x0F120000,	/*REG_1TC_PCFG_sSaturation		2   700001B2*/
	0x0F120000,	/*REG_1TC_PCFG_sSharpBlur		2   700001B4*/
	0x0F120000,	/*REG_1TC_PCFG_sColorTemp		2   700001B6*/
	0x0F120000,	/*REG_1TC_PCFG_uDeviceGammaIndex	2   700001B8*/
	0x0F120000,	/*REG_1TC_PCFG_uPrevMirror		2   700001BA*/
	0x0F120000,	/*REG_1TC_PCFG_uCaptureMirror		2   700001BC*/
	0x0F120000,	/*REG_1TC_PCFG_uRotation		2   700001BE*/
	/*Preview2 for nightshot*/
	0x0F120320,	/*REG_2TC_PCFG_usWidth			2   700001C0*/
	0x0F120258,	/*REG_2TC_PCFG_usHeight			2   700001C2*/
	0x0F120005,	/*REG_2TC_PCFG_Format			2   700001C4*/
	0x0F12222E,	/*REG_2TC_PCFG_usMaxOut4KHzRate		2   700001C6*/
	0x0F12222E,	/*REG_2TC_PCFG_usMinOut4KHzRate		2   700001C8*/
	0x0F120042,	/*REG_2TC_PCFG_PVIMask			2   700001CA*/
	0x0F120010,	/*REG_2TC_PCFG_OIFMask			2   700001CC*/
	0x0F120000,	/*REG_2TC_PCFG_uClockInd		2   700001CE*/
	0x0F120000,	/*REG_2TC_PCFG_usFrTimeType		2   700001D0*/
	0x0F120001,	/*REG_2TC_PCFG_FrRateQualityType	2   700001D2
			1b: FR (bin) 2b:	Quality	(no-bin)*/
	0x0F12014D,	/*REG_2TC_PCFG_usMaxFrTimeMsecMult10	2   700001D4
			max frame time :	30fps 014D 15fps 029a; a6a -
			3.75 fps; 0535 - 7.5FPS*/
	0x0F12014D,	/*REG_2TC_PCFG_usMinFrTimeMsecMult10	2   700001D6*/
	0x0F120000,	/*REG_2TC_PCFG_bSmearOutput		2   700001D8*/
	0x0F120000,	/*REG_2TC_PCFG_sSaturation		2   700001DA*/
	0x0F120000,	/*REG_2TC_PCFG_sSharpBlur		2   700001DC*/
	0x0F120000,	/*REG_2TC_PCFG_sColorTemp		2   700001DE*/
	0x0F120000,	/*REG_2TC_PCFG_uDeviceGammaIndex	2   700001E0*/
	0x0F120000,	/*REG_2TC_PCFG_uPrevMirror		2   700001E2
			[0] : x [1]: Y [2] Stat X	[3] Stat Y*/
	0x0F120000,	/*REG_2TC_PCFG_uCaptureMirror		2   700001E4*/
	0x0F120000,	/*REG_2TC_PCFG_uRotation		2   700001E6*/
	0x002A0238,
	0x0F120001,	/*REG_0TC_CCFG_uCaptureMode		2   70000238*/
	0x0F120640,	/*REG_0TC_CCFG_usWidth			2   7000023A*/
	0x0F1204B0,	/*REG_0TC_CCFG_usHeight			2   7000023C*/
	0x0F120005,	/*REG_0TC_CCFG_Format			2   7000023E*/
	0x0F12222E,	/*REG_0TC_CCFG_usMaxOut4KHzRate		2   70000240*/
	0x0F12222E,	/*REG_0TC_CCFG_usMinOut4KHzRate		2   70000242*/
	0x0F120042,	/*REG_0TC_CCFG_PVIMask			2   70000244*/
	0x0F120000,	/*REG_0TC_CCFG_OIFMask			2   70000246*/
	0x0F120001,	/*REG_0TC_CCFG_uClockInd		2   70000248*/
	0x0F120000,	/*REG_0TC_CCFG_usFrTimeType		2   7000024A*/
	0x0F120002,	/*REG_0TC_CCFG_FrRateQualityType	2   7000024C*/
	0x0F1205D0,	/*REG_0TC_CCFG_usMaxFrTimeMsecMult10	2   7000024E*/
	0x0F1204D0,	/*REG_0TC_CCFG_usMinFrTimeMsecMult10	2   70000250*/
	0x0F120000,	/*REG_0TC_CCFG_bSmearOutput		2   70000252*/
	0x0F120000,	/*REG_0TC_CCFG_sSaturation		2   70000254*/
	0x0F120000,	/*REG_0TC_CCFG_sSharpBlur		2   70000256*/
	0x0F120000,	/*REG_0TC_CCFG_sColorTemp		2   70000258*/
	0x0F120000,	/*REG_0TC_CCFG_uDeviceGammaIndex	2   7000025A*/
	0x0F120001,	/*REG_1TC_CCFG_uCaptureMode		2   7000025C*/
	0x0F120640,	/*REG_1TC_CCFG_usWidth			2   7000025E*/
	0x0F1204B0,	/*REG_1TC_CCFG_usHeight			2   70000260*/
	0x0F120005,	/*REG_1TC_CCFG_Format			2   70000262*/
	0x0F12222E,	/*REG_1TC_CCFG_usMaxOut4KHzRate		2   70000264*/
	0x0F12222E,	/*REG_1TC_CCFG_usMinOut4KHzRate		2   70000266*/
	0x0F120042,	/*REG_1TC_CCFG_PVIMask			2   70000268*/
	0x0F120000,	/*REG_1TC_CCFG_OIFMask			2   7000026A*/
	0x0F120001,	/*REG_1TC_CCFG_uClockInd		2   7000026C*/
	0x0F120000,	/*REG_1TC_CCFG_usFrTimeType		2   7000026E*/
	0x0F120002,	/*REG_1TC_CCFG_FrRateQualityType	2   70000270*/
	0x0F121388,	/*REG_1TC_CCFG_usMaxFrTimeMsecMult10	2   70000272*/
	0x0F121388,	/*REG_1TC_CCFG_usMinFrTimeMsecMult10	2   70000274*/
	0x0F120000,	/*REG_1TC_CCFG_bSmearOutput		2   70000276*/
	0x0F120000,	/*REG_1TC_CCFG_sSaturation		2   70000278*/
	0x0F120000,	/*REG_1TC_CCFG_sSharpBlur		2   7000027A*/
	0x0F120000,	/*REG_1TC_CCFG_sColorTemp		2   7000027C*/
	0x0F120000,	/*REG_1TC_CCFG_uDeviceGammaIndex	2   7000027E*/
	0x002A1218,
	0x0F120002,
	/*PREVIEW*/
	0x002A0156,
	0x0F120001,
	0x002A015E,
	0x0F120000,
	0x002A015A,
	0x0F120001,
	0x002A0142,
	0x0F120001,
	0x002A0158,
	0x0F120001,
	0x002A0160,
	0x0F120001,
	0x002A013A,
	0x0F120001,
	0x0F120001,
	0xFFFF0064,
	/*===================================================================*/
	/*AFC*/
	/*===================================================================*/
	/*Auto*/
	0x00287000,
	0x002A0CC0,
	0x0F120001,	/*AFC_Default60Hz   01:60hz 00:50Hz*/
	0x002A0374,
	0x0F12067F,	/*REG_TC_DBG_AutoAlgEnBits*/
	/*===================================================================*/
	/*Shading*/
	/*===================================================================*/
	/* TVAR_ash_pGAS_high*/
	0x00287000,
	0x002A0AD8,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	/* TVAR_ash_pGAS_low*/
	0x0F128608,
	0x0F12E960,
	0x0F120243,
	0x0F12128B,
	0x0F12F073,
	0x0F120270,
	0x0F12DF47,
	0x0F12F226,
	0x0F121A31,
	0x0F12DFDA,
	0x0F121200,
	0x0F1205A9,
	0x0F120F16,
	0x0F120F5E,
	0x0F12DF10,
	0x0F1225BF,
	0x0F12FCF0,
	0x0F12DE1B,
	0x0F12025B,
	0x0F12FA8B,
	0x0F12163B,
	0x0F12DF44,
	0x0F12FB2D,
	0x0F1230E6,
	0x0F12FE07,
	0x0F12F47C,
	0x0F1209F2,
	0x0F120AED,
	0x0F12FA09,
	0x0F12E70E,
	0x0F120158,
	0x0F121110,
	0x0F12E28C,
	0x0F120DFB,
	0x0F12074B,
	0x0F12FBE5,
	0x0F12961C,
	0x0F12E21A,
	0x0F120ADF,
	0x0F120A67,
	0x0F12F8A6,
	0x0F12FDC3,
	0x0F12D590,
	0x0F12FA69,
	0x0F1208D5,
	0x0F12F635,
	0x0F12057E,
	0x0F12043B,
	0x0F12155C,
	0x0F1200C6,
	0x0F12F042,
	0x0F12176A,
	0x0F12F818,
	0x0F12F1F3,
	0x0F12026F,
	0x0F1208F6,
	0x0F120CCF,
	0x0F12E42D,
	0x0F120A92,
	0x0F1210EC,
	0x0F12005F,
	0x0F12F02C,
	0x0F120672,
	0x0F1209BF,
	0x0F12F4B5,
	0x0F12FC22,
	0x0F12FD50,
	0x0F120C26,
	0x0F12EED3,
	0x0F1207C3,
	0x0F12080F,
	0x0F12F6CF,
	0x0F127A3B,
	0x0F12E9DC,
	0x0F12088E,
	0x0F1201C8,
	0x0F12043C,
	0x0F12F7E2,
	0x0F12E391,
	0x0F12F3C4,
	0x0F121422,
	0x0F12E845,
	0x0F120D16,
	0x0F1206CA,
	0x0F120DEB,
	0x0F121324,
	0x0F12E814,
	0x0F1216B7,
	0x0F1202AC,
	0x0F12DE4D,
	0x0F1201EA,
	0x0F12F0C2,
	0x0F120E06,
	0x0F12EC6D,
	0x0F12FDF0,
	0x0F122B46,
	0x0F120710,
	0x0F12F84C,
	0x0F120E52,
	0x0F120675,
	0x0F12F0D7,
	0x0F12ED40,
	0x0F12F3AD,
	0x0F12179A,
	0x0F12DE9B,
	0x0F1210BA,
	0x0F120825,
	0x0F12FE0A,
	0x0F1288E9,
	0x0F12E9E0,
	0x0F12043D,
	0x0F120A17,
	0x0F12FC21,
	0x0F12FB58,
	0x0F12DCE0,
	0x0F12F24C,
	0x0F121A19,
	0x0F12E011,
	0x0F1211A3,
	0x0F120649,
	0x0F120D04,
	0x0F120E15,
	0x0F12E112,
	0x0F1227BD,
	0x0F12F7AA,
	0x0F12E06A,
	0x0F120A16,
	0x0F12FD23,
	0x0F121226,
	0x0F12DA34,
	0x0F1207A4,
	0x0F122AD3,
	0x0F12FE27,
	0x0F12EE64,
	0x0F120CAD,
	0x0F1211C5,
	0x0F12EC55,
	0x0F12ED98,
	0x0F12F88A,
	0x0F121842,
	0x0F12E1D5,
	0x0F1208FD,
	0x0F120FB6,
	0x0F12F801,
	0x002A0378,
	0x0F120001,	/*REG_TC_DBG_RelnitCmd*/
	/*===================================================================*/
	/*Shading -	Alpha*/
	/*===================================================================*/
	0x002A05E8,
	0x0F1200E4,	/*TVAR_ash_AwbAshCord[0]		2   70000568*/
	0x0F1200F0,	/*TVAR_ash_AwbAshCord[1]		2   7000056A*/
	0x0F120100,	/*TVAR_ash_AwbAshCord[2]		2   7000056C*/
	0x0F120120,	/*TVAR_ash_AwbAshCord[3]		2   7000056E*/
	0x0F120150,	/*TVAR_ash_AwbAshCord[4]		2   70000570*/
	0x0F120180,	/*TVAR_ash_AwbAshCord[5]		2   70000572*/
	0x0F1201A0,	/*TVAR_ash_AwbAshCord[6]		2   70000574*/
	0x0F124000,	/*TVAR_ash_GASAlpha[0][1]		2   70000580*/
	0x0F124000,	/*TVAR_ash_GASAlpha[0][2]		2   70000582*/
	0x0F124000,	/*TVAR_ash_GASAlpha[0][3]		2   70000584*/
	0x0F123800,	/*TVAR_ash_GASAlpha[1][0]		2   70000586*/
	0x0F124000,	/*TVAR_ash_GASAlpha[1][1]		2   70000588*/
	0x0F124000,	/*TVAR_ash_GASAlpha[1][2]		2   7000058A*/
	0x0F124000,	/*TVAR_ash_GASAlpha[1][3]		2   7000058C*/
	0x0F123800,	/*TVAR_ash_GASAlpha[2][0]		2   7000058E*/
	0x0F124000,	/*TVAR_ash_GASAlpha[2][1]		2   70000590*/
	0x0F124000,	/*TVAR_ash_GASAlpha[2][2]		2   70000592*/
	0x0F124000,	/*TVAR_ash_GASAlpha[2][3]		2   70000594*/
	0x0F123800,	/*TVAR_ash_GASAlpha[3][0]		2   70000596*/
	0x0F124000,	/*TVAR_ash_GASAlpha[3][1]		2   70000598*/
	0x0F124000,	/*TVAR_ash_GASAlpha[3][2]		2   7000059A*/
	0x0F124000,	/*TVAR_ash_GASAlpha[3][3]		2   7000059C*/
	0x0F123800,	/*TVAR_ash_GASAlpha[4][0]		2   7000059E*/
	0x0F124000,	/*TVAR_ash_GASAlpha[4][1]		2   700005A0*/
	0x0F124000,	/*TVAR_ash_GASAlpha[4][2]		2   700005A2*/
	0x0F124000,	/*TVAR_ash_GASAlpha[4][3]		2   700005A4*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][0]		2   700005A6*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][1]		2   700005A8*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][2]		2   700005AA*/
	0x0F124000,	/*TVAR_ash_GASAlpha[5][3]		2   700005AC*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][0]		2   700005AE*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][1]		2   700005B0*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][2]		2   700005B2*/
	0x0F124000,	/*TVAR_ash_GASAlpha[6][3]		2   700005B4*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[0]		2   700005B6*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[1]		2   700005B8*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[2]		2   700005BA*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha[3]		2   700005BC*/
	/*===================================================================*/
	/*Gamma*/
	/*===================================================================*/
	/*	param_start SARR_usGammaLutRGBIndoor*/
	0x002A0460,
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[0][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[0][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[0][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[0][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[0][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[0][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[0][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[0][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[0][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[0][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[0][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[0][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[0][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[0][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[0][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[0][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[0][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[0][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[0][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[0][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[1][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[1][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[1][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[1][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[1][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[1][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[1][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[1][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[1][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[1][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[1][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[1][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[1][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[1][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[1][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[1][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[1][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[1][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[1][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[1][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBIndoor[2][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBIndoor[2][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBIndoor[2][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBIndoor[2][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBIndoor[2][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBIndoor[2][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBIndoor[2][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBIndoor[2][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBIndoor[2][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBIndoor[2][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBIndoor[2][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBIndoor[2][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBIndoor[2][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBIndoor[2][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBIndoor[2][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBIndoor[2][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBIndoor[2][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBIndoor[2][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBIndoor[2][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBIndoor[2][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[0][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[0][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[0][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[0][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[0][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[0][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[0][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[0][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[0][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[0][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[0][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[0][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[0][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[0][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[0][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[0][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[0][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[0][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[0][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[0][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[1][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[1][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[1][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[1][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[1][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[1][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[1][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[1][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[1][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[1][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[1][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[1][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[1][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[1][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[1][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[1][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[1][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[1][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[1][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[1][19]*/
	0x0F120000,	/*0000	0000	saRR_usDualGammaLutRGBOutdoor[2][0]*/
	0x0F120004,	/*0008	0002	saRR_usDualGammaLutRGBOutdoor[2][1]*/
	0x0F12000C,	/*0013	0006	saRR_usDualGammaLutRGBOutdoor[2][2]*/
	0x0F120024,	/*002C	0011	saRR_usDualGammaLutRGBOutdoor[2][3]*/
	0x0F12006E,	/*0061	0036	saRR_usDualGammaLutRGBOutdoor[2][4]*/
	0x0F1200D1,	/*00C8	009A	saRR_usDualGammaLutRGBOutdoor[2][5]*/
	0x0F120119,	/*0113	00FD	saRR_usDualGammaLutRGBOutdoor[2][6]*/
	0x0F120139,	/*0132	0129	saRR_usDualGammaLutRGBOutdoor[2][7]*/
	0x0F120157,	/*014C	014B	saRR_usDualGammaLutRGBOutdoor[2][8]*/
	0x0F12018E,	/*0179	0184	saRR_usDualGammaLutRGBOutdoor[2][9]*/
	0x0F1201C3,	/*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[2][10]*/
	0x0F1201F3,	/*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[2][11]*/
	0x0F12021F,	/*01F4	0216	saRR_usDualGammaLutRGBOutdoor[2][12]*/
	0x0F120269,	/*0239	025E	saRR_usDualGammaLutRGBOutdoor[2][13]*/
	0x0F1202A6,	/*0278	0299	saRR_usDualGammaLutRGBOutdoor[2][14]*/
	0x0F1202FF,	/*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[2][15]*/
	0x0F120351,	/*0333	0341	saRR_usDualGammaLutRGBOutdoor[2][16]*/
	0x0F120395,	/*037B	037F	saRR_usDualGammaLutRGBOutdoor[2][17]*/
	0x0F1203CE,	/*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[2][18]*/
	0x0F1203FF,	/*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[2][19]*/
	/*===================================================================*/
	/*AE - shutter*/
	/*===================================================================*/
	/*AE_Target*/
	0x002A10C0,
	0x0F120045,	/*TVAR_ae_BrAve*/
	0x002A10C6,
	0x0F12000F,	/*ae_StatMode				2   70001046*/
	/*AE_state*/
	0x002A03B2,
	0x0F12010E,	/*#lt_uLimitHigh*/
	0x0F1200F5,	/*#lt_uLimitLow*/
	/*For 60Hz*/
	0x002A03C4,
	0x0F123415,	/*#lt_uMaxExp1*/
	0x002A03C8,
	0x0F12681F,	/*#lt_uMaxExp2*/
	0x002A03CC,
	0x0F128227,	/*#lt_uMaxExp3*/
	0x002A03D0,
	0x0F120D40,	/*C350	#lt_uMaxExp4*/
	0x0F120003,	/*0000	#lt_uMaxExp4*/
	0x002A03D4,
	0x0F123415,	/*#lt_uCapMaxExp1*/
	0x002A03D8,
	0x0F12681F,	/*#lt_uCapMaxExp2*/
	0x002A03DC,
	0x0F128227,	/*#lt_uCapMaxExp3*/
	0x002A03E0,
	0x0F120D40,	/*C350 #lt_uCapMaxExp4*/
	0x0F120003,	/*0000 #lt_uCapMaxExp4*/
	0x002A03E4,
	0x0F1201C0,	/*0230	#lt_uMaxAnGain1*/
	0x0F1201D0,	/*0260	#lt_uMaxAnGain2*/
	0x0F1202D0,	/*0380	#lt_uMaxAnGain3*/
	0x0F120700,	/*#lt_uMaxAnGain4*/
	0x0F120100,	/*#lt_uMaxDigGain*/
	0x0F128000,	/*#lt_uMaxTotGain  Total-gain is limited by
			#lt_uMaxTotGain*/
	0x0F1201C0,	/*#lt_uCapMaxAnGain1*/
	0x0F1201D0,	/*#lt_uCapMaxAnGain2*/
	0x0F1202D0,	/*#lt_uCapMaxAnGain3*/
	0x0F120700,	/*#lt_uCapMaxAnGain4*/
	0x0F120100,	/*#lt_uCapMaxDigGain*/
	0x0F128000,	/*#lt_uCapMaxTotGain  Total-gain is limited by
			#lt_uMaxTotGain*/
	/*===================================================================*/
	/*AE - Weights*/
	/*===================================================================*/
	0x002A10CE,
	0x0F120000,	/*ae_WeightTbl_16[0]			2   7000104E*/
	0x0F120101,	/*ae_WeightTbl_16[1]			2   70001050*/
	0x0F120101,	/*ae_WeightTbl_16[2]			2   70001052*/
	0x0F120000,	/*ae_WeightTbl_16[3]			2   70001054*/
	0x0F120101,	/*ae_WeightTbl_16[4]			2   70001056*/
	0x0F120101,	/*ae_WeightTbl_16[5]			2   70001058*/
	0x0F120101,	/*ae_WeightTbl_16[6]			2   7000105A*/
	0x0F120101,	/*ae_WeightTbl_16[7]			2   7000105C*/
	0x0F120201,	/*ae_WeightTbl_16[8]			2   7000105E*/
	0x0F120303,	/*ae_WeightTbl_16[9]			2   70001060*/
	0x0F120303,	/*ae_WeightTbl_16[10]			2   70001062*/
	0x0F120102,	/*ae_WeightTbl_16[11]			2   70001064*/
	0x0F120201,	/*ae_WeightTbl_16[12]			2   70001066*/
	0x0F120403,	/*ae_WeightTbl_16[13]			2   70001068*/
	0x0F120304,	/*ae_WeightTbl_16[14]			2   7000106A*/
	0x0F120102,	/*ae_WeightTbl_16[15]			2   7000106C*/
	0x0F120201,	/*ae_WeightTbl_16[16]			2   7000106E*/
	0x0F120403,	/*ae_WeightTbl_16[17]			2   70001070*/
	0x0F120304,	/*ae_WeightTbl_16[18]			2   70001072*/
	0x0F120102,	/*ae_WeightTbl_16[19]			2   70001074*/
	0x0F120201,	/*ae_WeightTbl_16[20]			2   70001076*/
	0x0F120403,	/*ae_WeightTbl_16[21]			2   70001078*/
	0x0F120304,	/*ae_WeightTbl_16[22]			2   7000107A*/
	0x0F120102,	/*ae_WeightTbl_16[23]			2   7000107C*/
	0x0F120201,	/*ae_WeightTbl_16[24]			2   7000107E*/
	0x0F120303,	/*ae_WeightTbl_16[25]			2   70001080*/
	0x0F120303,	/*ae_WeightTbl_16[26]			2   70001082*/
	0x0F120102,	/*ae_WeightTbl_16[27]			2   70001084*/
	0x0F120201,	/*ae_WeightTbl_16[28]			2   70001086*/
	0x0F120202,	/*ae_WeightTbl_16[29]			2   70001088*/
	0x0F120202,	/*ae_WeightTbl_16[30]			2   7000108A*/
	0x0F120102,	/*ae_WeightTbl_16[31]			2   7000108C*/
	/*===================================================================*/
	/*AWB-BASIC	setting*/
	/*===================================================================*/
	0x002A0DCC,
	0x0F120138,	/*awbb_IntcR*/
	0x0F12011C,	/*awbb_IntcB*/
	0x0F1202A7,	/*awbb_GLocusR*/
	0x0F120343,	/*awbb_GLocusB*/
	0x002A0DB4,
	0x0F12036C,	/*awbb_CrclLowT_R_c*/
	0x002A0DB8,
	0x0F12011D,	/*awbb_CrclLowT_B_c*/
	0x002A0DBC,
	0x0F1262C1,	/*awbb_CrclLowT_Rad_c*/
	0x002A0DEC,
	0x0F1205F0,	/*awbb_GamutWidthThr1*/
	0x0F1201F4,	/*awbb_GamutHeightThr1*/
	0x0F12006C,	/*awbb_GamutWidthThr2*/
	0x0F120038,	/*awbb_GamutHeightThr2*/
	0x002A0DD8,
	0x0F12000C,	/*awbb_MinNumOfFinalPatches*/
	0x0F12001E,	/*awbb_MinNumOfLowBrFinalPatches*/
	0x0F120046,	/*awbb_MinNumOfLowBr0_FinalPatches*/
	0x002A22BA,
	0x0F120006,	/* #Mon_AWB_ByPassMode [0]Outdoor [1]LowBr [2]LowTemp*/
	0x002A0F7A,
	0x0F120000,	/*awbb_RGainOff				2   70000EFA*/
	0x0F120000,	/*awbb_BGainOff				2   70000EFC*/
	0x0F120000,	/*awbb_GGainOff				2   70000EFE*/
	0x0F1200C2,	/*awbb_Alpha_Comp_Mode			2   70000F00*/
	0x0F120002,	/*awbb_Rpl_InvalidOutDoor		2   70000F02*/
	0x0F120001,	/*awbb_UseGrThrCorr			2   70000F04*/
	0x0F1200E4,	/*awbb_Use_Filters			2   70000F06*/
	0x0F12053C,	/*awbb_GainsInit[0]			2   70000F08*/
	0x0F120400,	/*awbb_GainsInit[1]			2   70000F0A*/
	0x0F12055C,	/*awbb_GainsInit[2]			2   70000F0C*/
	0x0F12001E,	/*awbb_WpFilterMinThr			2   70000F0E*/
	0x0F120190,	/*awbb_WpFilterMaxThr			2   70000F10*/
	0x0F1200A0,	/*awbb_WpFilterCoef			2   70000F12*/
	0x0F120004,	/*awbb_WpFilterSize			2   70000F14*/
	0x0F120001,	/*awbb_otp_disable			2   70000F16*/
	/*===================================================================*/
	/*AWB-Zone*/
	/*===================================================================*/
	/*	param_start awbb_IndoorGrZones_m_BGrid*/
	0x002A0CE0,
	0x0F1203F8,	/*03B5	awbb_IndoorGrZones_m_BGrid[0]*/
	0x0F120422,	/*03DF	awbb_IndoorGrZones_m_BGrid[1]*/
	0x0F1203B4,	/*032D	awbb_IndoorGrZones_m_BGrid[2]*/
	0x0F120408,	/*03D5	awbb_IndoorGrZones_m_BGrid[3]*/
	0x0F120370,	/*0303	awbb_IndoorGrZones_m_BGrid[4]*/
	0x0F1203EE,	/*03BB	awbb_IndoorGrZones_m_BGrid[5]*/
	0x0F12032C,	/*02DB	awbb_IndoorGrZones_m_BGrid[6]*/
	0x0F1203D4,	/*0397	awbb_IndoorGrZones_m_BGrid[7]*/
	0x0F120302,	/*02B1	awbb_IndoorGrZones_m_BGrid[8]*/
	0x0F1203BA,	/*036B	awbb_IndoorGrZones_m_BGrid[9]*/
	0x0F1202DA,	/*0289	awbb_IndoorGrZones_m_BGrid[10]*/
	0x0F120374,	/*0349	awbb_IndoorGrZones_m_BGrid[11]*/
	0x0F1202B0,	/*026F	awbb_IndoorGrZones_m_BGrid[12]*/
	0x0F120328,	/*0329	awbb_IndoorGrZones_m_BGrid[13]*/
	0x0F120288,	/*0257	awbb_IndoorGrZones_m_BGrid[14]*/
	0x0F120300,	/*0309	awbb_IndoorGrZones_m_BGrid[15]*/
	0x0F120270,	/*0241	awbb_IndoorGrZones_m_BGrid[16]*/
	0x0F1202DE,	/*02DD	awbb_IndoorGrZones_m_BGrid[17]*/
	0x0F120258,	/*0227	awbb_IndoorGrZones_m_BGrid[18]*/
	0x0F1202BE,	/*02C3	awbb_IndoorGrZones_m_BGrid[19]*/
	0x0F120240,	/*0213	awbb_IndoorGrZones_m_BGrid[20]*/
	0x0F1202A0,	/*02AF	awbb_IndoorGrZones_m_BGrid[21]*/
	0x0F120228,	/*0209	awbb_IndoorGrZones_m_BGrid[22]*/
	0x0F120296,	/*0295	awbb_IndoorGrZones_m_BGrid[23]*/
	0x0F120212,	/*020D	awbb_IndoorGrZones_m_BGrid[24]*/
	0x0F120284,	/*0285	awbb_IndoorGrZones_m_BGrid[25]*/
	0x0F120208,	/*0223	awbb_IndoorGrZones_m_BGrid[26]*/
	0x0F120274,	/*0261	awbb_IndoorGrZones_m_BGrid[27]*/
	0x0F12020C,	/*0000	awbb_IndoorGrZones_m_BGrid[28]*/
	0x0F12026E,	/*0000	awbb_IndoorGrZones_m_BGrid[29]*/
	0x0F120222,	/*0000	awbb_IndoorGrZones_m_BGrid[30]*/
	0x0F120260,	/*0000	awbb_IndoorGrZones_m_BGrid[31]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[32]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[33]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[34]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[35]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[36]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[37]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[38]*/
	0x0F120000,	/*0000	awbb_IndoorGrZones_m_BGrid[39]*/
	/*	param_end   awbb_IndoorGrZones_m_BGrid*/
	0x0F120005,	/*awbb_IndoorGrZones_m_Grid*/
	0x002A0D38,
	0x0F1200FE,	/*awbb_IndoorGrZones_m_Boff*/
	/*	param_start awbb_OutdoorGrZones_m_BGrid*/
	0x002A0D3C,
	0x0F1202B8,	/*029F	awbb_OutdoorGrZones_m_BGrid[0]*/
	0x0F1202F2,	/*02CE	awbb_OutdoorGrZones_m_BGrid[1]*/
	0x0F12028E,	/*0282	awbb_OutdoorGrZones_m_BGrid[2]*/
	0x0F12030A,	/*02DA	awbb_OutdoorGrZones_m_BGrid[3]*/
	0x0F12027A,	/*026D	awbb_OutdoorGrZones_m_BGrid[4]*/
	0x0F12030A,	/*02C2	awbb_OutdoorGrZones_m_BGrid[5]*/
	0x0F120274,	/*0256	awbb_OutdoorGrZones_m_BGrid[6]*/
	0x0F1202FE,	/*02A6	awbb_OutdoorGrZones_m_BGrid[7]*/
	0x0F120282,	/*026E	awbb_OutdoorGrZones_m_BGrid[8]*/
	0x0F1202DC,	/*028A	awbb_OutdoorGrZones_m_BGrid[9]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[10]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[11]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[12]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[13]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[14]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[15]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[16]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[17]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[18]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[19]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[20]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[21]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[22]*/
	0x0F120000,	/*0000	awbb_OutdoorGrZones_m_BGrid[23]*/
	/*	param_end   awbb_OutdoorGrZones_m_BGrid*/
	0x0F120005,	/*awbb_OutdoorGrZones_m_Gri*/
	0x002A0D70,
	0x0F120005,	/*awbb_OutdoorGrZones_ZInfo_m_GridSz*/
	0x002A0D74,
	0x0F1201EB,	/*awbb_OutdoorGrZones_m_Bof*/
	/*	param_start awbb_LowBrGrZones_m_BGrid*/
	0x002A0D78,
	0x0F1203CE,	/*awbb_LowBrGrZones_m_BGrid[0]*/
	0x0F12046E,	/*awbb_LowBrGrZones_m_BGrid[1]*/
	0x0F12034E,	/*awbb_LowBrGrZones_m_BGrid[2]*/
	0x0F120474,	/*awbb_LowBrGrZones_m_BGrid[3]*/
	0x0F1202EA,	/*awbb_LowBrGrZones_m_BGrid[4]*/
	0x0F120434,	/*awbb_LowBrGrZones_m_BGrid[5]*/
	0x0F12028C,	/*awbb_LowBrGrZones_m_BGrid[6]*/
	0x0F1203F0,	/*awbb_LowBrGrZones_m_BGrid[7]*/
	0x0F120244,	/*awbb_LowBrGrZones_m_BGrid[8]*/
	0x0F120380,	/*awbb_LowBrGrZones_m_BGrid[9]*/
	0x0F12020E,	/*awbb_LowBrGrZones_m_BGrid[10]*/
	0x0F120330,	/*awbb_LowBrGrZones_m_BGrid[11]*/
	0x0F1201EC,	/*awbb_LowBrGrZones_m_BGrid[12]*/
	0x0F1202EC,	/*awbb_LowBrGrZones_m_BGrid[13]*/
	0x0F1201D0,	/*awbb_LowBrGrZones_m_BGrid[14]*/
	0x0F1202BC,	/*awbb_LowBrGrZones_m_BGrid[15]*/
	0x0F1201C8,	/*awbb_LowBrGrZones_m_BGrid[16]*/
	0x0F120296,	/*awbb_LowBrGrZones_m_BGrid[17]*/
	0x0F1201D2,	/*awbb_LowBrGrZones_m_BGrid[18]*/
	0x0F120266,	/*awbb_LowBrGrZones_m_BGrid[19]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[20]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[21]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[22]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[23]*/
	/*	param_end   awbb_LowBrGrZones_m_BGrid*/
	0x0F120006,	/*awbb_LowBrGrZones_m_GridS*/
	0x002A0DB0,
	0x0F1200E2,	/*awbb_LowBrGrZones_m_Boffs*/
	/*===================================================================*/
	/*AWB Scene	Detection*/
	/*===================================================================*/
	0x002A0E50,
	0x0F12FE82,	/*awbb_SCDetectionMap_SEC_StartR_B	2   70000DD0*/
	0x0F12001E,	/*awbb_SCDetectionMap_SEC_StepR_B	2   70000DD2*/
	0x0F120E74,	/*awbb_SCDetectionMap_SEC_SunnyNB	2   70000DD4*/
	0x0F120122,	/*awbb_SCDetectionMap_SEC_StepNB	2   70000DD6*/
	0x0F1200E4,	/*awbb_SCDetectionMap_SEC_LowTempR_B	2   70000DD8*/
	0x0F120096,	/*awbb_SCDetectionMap_SEC_SunnyNBZone	2   70000DDA*/
	0x0F12000E,	/*awbb_SCDetectionMap_SEC_LowTempR_BZone 2   70000DDC*/
	0x002A0E14,
	0x0F120000,	/*#awbb_SCDetectionMap_SEC  0000
							WRITE      70000D94
			0000  awbb_SCDetectionMap_SEC_SceneDetectionMap*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__2_
			WRITE      70000D96	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_0__4_
			WRITE      70000D98	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__1_
			WRITE      70000D9A	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_1__3_
			WRITE      70000D9C	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__0_
			WRITE      70000D9E	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__2_
			WRITE      70000DA0	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_2__4_
			WRITE      70000DA2	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__1_
			WRITE      70000DA4	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_3__3_
			WRITE      70000DA6	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__0_
			WRITE      70000DA8	0000*/
	0x0F120000,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__2_
			WRITE      70000DAA	0000*/
	0x0F120500,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_4__4_
			WRITE      70000DAC	0500*/
	0x0F125555,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__1_
			WRITE      70000DAE	5555*/
	0x0F125455,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_5__3_
			WRITE      70000DB0	5455*/
	0x0F12AA55,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__0_
			WRITE      70000DB2	AA55*/
	0x0F12AAAA,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__2_
			WRITE      70000DB4	AAAA*/
	0x0F12BF54,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_6__4_
			WRITE      70000DB6	BF54*/
	0x0F12FFFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__1_
			WRITE      70000DB8	FFFF*/
	0x0F1254FE,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_7__3_
			WRITE      70000DBA	54FE*/
	0x0F12FF6F,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__0_
			WRITE      70000DBC	FF6F*/
	0x0F12FEFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__2_
			WRITE      70000DBE	FEFF*/
	0x0F121B54,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_8__4_
			WRITE      70000DC0	1B54*/
	0x0F12FFFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__1_
			WRITE      70000DC2	FFFF*/
	0x0F1254FE,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_9__3_
			WRITE      70000DC4	54FE*/
	0x0F12FF06,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__0_
			WRITE	   70000DC6 FF06*/
	0x0F12FEFF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__2_
			WRITE	   70000DC8 FEFF*/
	0x0F120154,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_10__4_
			WRITE	   70000DCA 0154*/
	0x0F12BFBF,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__1_
			WRITE	   70000DCC BFBF*/
	0x0F1254BE,	/*#awbb_SCDetectionMap_SEC_SceneDetectionMap_11__3_
			WRITE	   70000DCE 54BE*/
	0x002A0F86,
	0x0F120074,	/*E0	awbb_Use_Filters e4*/
	0x002A0F8E,
	0x0F12001E,	/*awbb_WpFilterMinThr 1e*/
	/*===================================================================*/
	/*AWB - GridCorrection*/
	/*===================================================================*/
	0x002A0F98,
	0x0F120002,	/*awbb_GridEnable			2   70000F18*/
	0x002A0F60,
	0x0F1202E2,	/*awbb_GridConst_1[0]		2   70000EE0*/
	0x0F12034B,	/*awbb_GridConst_1[1]		2   70000EE2*/
	0x0F120399,	/*awbb_GridConst_1[2]		2   70000EE4*/
	0x0F12102D,	/*awbb_GridConst_2[0]		2   70000EE6*/
	0x0F1210DE,	/*awbb_GridConst_2[1]		2   70000EE8*/
	0x0F12116E,	/*awbb_GridConst_2[2]		2   70000EEA*/
	0x0F12117B,	/*awbb_GridConst_2[3]		2   70000EEC*/
	0x0F121206,	/*awbb_GridConst_2[4]		2   70000EEE*/
	0x0F12127F,	/*awbb_GridConst_2[5]		2   70000EF0*/
	0x0F1202C4,	/*awbb_GridCoeff_R_1		2   70000EF2*/
	0x0F1202E4,	/*awbb_GridCoeff_B_1		2   70000EF4*/
	0x0F1200C3,	/*awbb_GridCoeff_R_2		2   70000EF6*/
	0x0F1200A6,	/*awbb_GridCoeff_B_2		2   70000EF8*/
	0x002A0ED0,
	0x0F12000A,	/*awbb_GridCorr_R[0][0]		2   70000ED0*/
	0x0F120028,	/*awbb_GridCorr_R[0][1]		2   70000ED2*/
	0x0F120028,	/*awbb_GridCorr_R[0][2]		2   70000ED4*/
	0x0F12FFEC,	/*awbb_GridCorr_R[0][3]		2   70000ED6*/
	0x0F12FFEC,	/*awbb_GridCorr_R[0][4]		2   70000ED8*/
	0x0F12001E,	/*awbb_GridCorr_R[0][5]		2   70000EDA*/
	0x0F12000A,	/*awbb_GridCorr_R[1][0]		2   70000EDC*/
	0x0F120028,	/*awbb_GridCorr_R[1][1]		2   70000EDE*/
	0x0F120028,	/*awbb_GridCorr_R[1][2]		2   70000EE0*/
	0x0F12FFEC,	/*awbb_GridCorr_R[1][3]		2   70000EE2*/
	0x0F12FFEC,	/*awbb_GridCorr_R[1][4]		2   70000EE4*/
	0x0F12001E,	/*awbb_GridCorr_R[1][5]		2   70000EE6*/
	0x0F12000A,	/*awbb_GridCorr_R[2][0]		2   70000EE8*/
	0x0F120028,	/*awbb_GridCorr_R[2][1]		2   70000EEA*/
	0x0F120028,	/*awbb_GridCorr_R[2][2]		2   70000EEC*/
	0x0F12FFEC,	/*awbb_GridCorr_R[2][3]		2   70000EEE*/
	0x0F12FFEC,	/*awbb_GridCorr_R[2][4]		2   70000EF0*/
	0x0F12001E,	/*awbb_GridCorr_R[2][5]		2   70000EF2*/
	0x0F12FFD8,	/*awbb_GridCorr_B[0][0]		2   70000EF4*/
	0x0F12003C,	/*awbb_GridCorr_B[0][1]		2   70000EF6*/
	0x0F12003C,	/*awbb_GridCorr_B[0][2]		2   70000EF8*/
	0x0F120000,	/*awbb_GridCorr_B[0][3]		2   70000EFA*/
	0x0F120000,	/*awbb_GridCorr_B[0][4]		2   70000EFC*/
	0x0F12001E,	/*awbb_GridCorr_B[0][5]		2   70000EFE*/
	0x0F12FFD8,	/*awbb_GridCorr_B[1][0]		2   70000F00*/
	0x0F12003C,	/*awbb_GridCorr_B[1][1]		2   70000F02*/
	0x0F12003C,	/*awbb_GridCorr_B[1][2]		2   70000F04*/
	0x0F120000,	/*awbb_GridCorr_B[1][3]		2   70000F06*/
	0x0F120000,	/*awbb_GridCorr_B[1][4]		2   70000F08*/
	0x0F12001E,	/*awbb_GridCorr_B[1][5]		2   70000F0A*/
	0x0F12FFD8,	/*awbb_GridCorr_B[2][0]		2   70000F0C*/
	0x0F12003C,	/*awbb_GridCorr_B[2][1]		2   70000F0E*/
	0x0F12003C,	/*awbb_GridCorr_B[2][2]		2   70000F10*/
	0x0F120000,	/*awbb_GridCorr_B[2][3]		2   70000F12*/
	0x0F120000,	/*awbb_GridCorr_B[2][4]		2   70000F14*/
	0x0F12001E,	/*awbb_GridCorr_B[2][5]		2   70000F16*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][0]	2   70000F18*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[0][1]	2   70000F1A*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][2]	2   70000F1C*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][3]	2   70000F1E*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][4]	2   70000F20*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][5]	2   70000F22*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][0]	2   70000F24*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[1][1]	2   70000F26*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][2]	2   70000F28*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][3]	2   70000F2A*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][4]	2   70000F2C*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][5]	2   70000F2E*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][0]	2   70000F30*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[2][1]	2   70000F32*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][2]	2   70000F34*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][3]	2   70000F36*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][4]	2   70000F38*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][5]	2   70000F3A*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][0]	2   70000F3C*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[0][1]	2   70000F3E*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][2]	2   70000F40*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][3]	2   70000F42*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][4]	2   70000F44*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][5]	2   70000F46*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][0]	2   70000F48*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[1][1]	2   70000F4A*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][2]	2   70000F4C*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][3]	2   70000F4E*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][4]	2   70000F50*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][5]	2   70000F52*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][0]	2   70000F54*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[2][1]	2   70000F56*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][2]	2   70000F58*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][3]	2   70000F5A*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][4]	2   70000F5C*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][5]	2   70000F5E*/
	/*===================================================================*/
	/*CCM*/
	/*===================================================================*/
	0x002A05D2,
	0x0F1200E4,	/*#SARR_AwbCcmCord	    2	70000552*/
	0x0F1200F0,	/*#SARR_AwbCcmCord_1_	    2	70000554*/
	0x0F120100,	/*#SARR_AwbCcmCord_2_	    2	70000556*/
	0x0F120120,	/*#SARR_AwbCcmCord_3_	    2	70000558*/
	0x0F120150,	/*#SARR_AwbCcmCord_4_	    2	7000055A*/
	0x0F120180,	/*#SARR_AwbCcmCord_5_	    2	7000055C*/
	/*	param_start TVAR_wbt_pBaseCcms*/
	0x002A05C4,
	0x0F123800,
	0x0F127000,
	0x002A3800,
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[0]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[1]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[2]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[3]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[4]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[5]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[6]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[7]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[8]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[9]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[10]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[11]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[12]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[13]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[14]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[15]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[16]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[17]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[18]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[19]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[20]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[21]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[22]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[23]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[24]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[25]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[26]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[27]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[28]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[29]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[30]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[31]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[32]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[33]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[34]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[35]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[36]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[37]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[38]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[39]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[40]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[41]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[42]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[43]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[44]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[45]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[46]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[47]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[48]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[49]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[50]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[51]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[52]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[53]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[54]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[55]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[56]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[57]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[58]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[59]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[60]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[61]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[62]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[63]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[64]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[65]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[66]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[67]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[68]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[69]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[70]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[71]*/
	0x0F1201BF,	/*TVAR_wbt_pBaseCcms[72]*/
	0x0F12FFBF,	/*TVAR_wbt_pBaseCcms[73]*/
	0x0F12FFFE,	/*TVAR_wbt_pBaseCcms[74]*/
	0x0F12FF6D,	/*TVAR_wbt_pBaseCcms[75]*/
	0x0F1201B4,	/*TVAR_wbt_pBaseCcms[76]*/
	0x0F12FF66,	/*TVAR_wbt_pBaseCcms[77]*/
	0x0F12FFCA,	/*TVAR_wbt_pBaseCcms[78]*/
	0x0F12FFCE,	/*TVAR_wbt_pBaseCcms[79]*/
	0x0F12017B,	/*TVAR_wbt_pBaseCcms[80]*/
	0x0F120136,	/*TVAR_wbt_pBaseCcms[81]*/
	0x0F120132,	/*TVAR_wbt_pBaseCcms[82]*/
	0x0F12FF85,	/*TVAR_wbt_pBaseCcms[83]*/
	0x0F12018B,	/*TVAR_wbt_pBaseCcms[84]*/
	0x0F12FF73,	/*TVAR_wbt_pBaseCcms[85]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[86]*/
	0x0F12FF3F,	/*TVAR_wbt_pBaseCcms[87]*/
	0x0F12015B,	/*TVAR_wbt_pBaseCcms[88]*/
	0x0F1200D0,	/*TVAR_wbt_pBaseCcms[89]*/
	0x0F1201BF,	/*TVAR_wbt_pBaseCcms[90]*/
	0x0F12FFBF,	/*TVAR_wbt_pBaseCcms[91]*/
	0x0F12FFFE,	/*TVAR_wbt_pBaseCcms[92]*/
	0x0F12FF6D,	/*TVAR_wbt_pBaseCcms[93]*/
	0x0F1201B4,	/*TVAR_wbt_pBaseCcms[94]*/
	0x0F12FF66,	/*TVAR_wbt_pBaseCcms[95]*/
	0x0F12FFCA,	/*TVAR_wbt_pBaseCcms[96]*/
	0x0F12FFCE,	/*TVAR_wbt_pBaseCcms[97]*/
	0x0F12017B,	/*TVAR_wbt_pBaseCcms[98]*/
	0x0F120136,	/*TVAR_wbt_pBaseCcms[99]*/
	0x0F120132,	/*TVAR_wbt_pBaseCcms[100]*/
	0x0F12FF85,	/*TVAR_wbt_pBaseCcms[101]*/
	0x0F12018B,	/*TVAR_wbt_pBaseCcms[102]*/
	0x0F12FF73,	/*TVAR_wbt_pBaseCcms[103]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[104]*/
	0x0F12FF3F,	/*TVAR_wbt_pBaseCcms[105]*/
	0x0F12015B,	/*TVAR_wbt_pBaseCcms[106]*/
	0x0F1200D0,	/*TVAR_wbt_pBaseCcms[107]*/
	/*	param_end   TVAR_wbt_pBaseCcms*/
	/*	param_start TVAR_wbt_pOutdoorCcm*/
	0x002A05CC,
	0x0F1238D8,	/*#TVAR_wbt_pOutdoorCcm*/
	0x0F127000,
	0x002A38D8,
	0x0F120235,	/*TVAR_wbt_pOutdoorCcm[0]*/
	0x0F12FFEF,	/*TVAR_wbt_pOutdoorCcm[1]*/
	0x0F120014,	/*TVAR_wbt_pOutdoorCcm[2]*/
	0x0F12FF67,	/*TVAR_wbt_pOutdoorCcm[3]*/
	0x0F12027D,	/*TVAR_wbt_pOutdoorCcm[4]*/
	0x0F12FFBA,	/*TVAR_wbt_pOutdoorCcm[5]*/
	0x0F12000D,	/*TVAR_wbt_pOutdoorCcm[6]*/
	0x0F120062,	/*TVAR_wbt_pOutdoorCcm[7]*/
	0x0F1202A7,	/*TVAR_wbt_pOutdoorCcm[8]*/
	0x0F1200C9,	/*TVAR_wbt_pOutdoorCcm[9]*/
	0x0F120123,	/*TVAR_wbt_pOutdoorCcm[10]*/
	0x0F12FF36,	/*TVAR_wbt_pOutdoorCcm[11]*/
	0x0F1201AD,	/*TVAR_wbt_pOutdoorCcm[12]*/
	0x0F12FFC8,	/*TVAR_wbt_pOutdoorCcm[13]*/
	0x0F120202,	/*TVAR_wbt_pOutdoorCcm[14]*/
	0x0F12FFCF,	/*TVAR_wbt_pOutdoorCcm[15]*/
	0x0F120257,	/*TVAR_wbt_pOutdoorCcm[16]*/
	0x0F12022C,	/*TVAR_wbt_pOutdoorCcm[17]*/
	/*	param_end   TVAR_wbt_pOutdoorCcm*/
	0x002A2404,
	0x0F120001,	/*#MVAR_AAIO_bFIT*/
	0x002A2408,
	0x0F120001,	/*#MVAR_AAIO_bAutoCCMandASH*/
	0x002A23DC,
	0x0F1201DD,	/*#Mon_AAIO_PrevFrmData_NormBr*/
	/*===================================================================*/
	/*AFIT*/
	/*===================================================================*/
	/*	param_start afit_uNoiseIndInDoor*/
	0x002A065C,
	0x0F12004A,	/*#afit_uNoiseIndInDoor_0_*/
	0x0F12005F,	/*#afit_uNoiseIndInDoor_1_*/
	0x0F1200CB,	/*#afit_uNoiseIndInDoor_2_*/
	0x0F1201E0,	/*#afit_uNoiseIndInDoor_3_*/
	0x0F120220,	/*#afit_uNoiseIndInDoor_4_*/
	/*	param_end   afit_uNoiseIndInDoor*/
	/*	param_start TVAR_afit_pBaseVals*/
	0x002A06BC,
	0x0F120000,	/*#AfitBaseVals	     AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_0__1_	 AFIT16_CONTRAST*/
	0x0F120014,	/*#AfitBaseVals_0__2_	 AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_0__3_	 AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_0__4_	 AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_0__5_	 AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_0__6_	 AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_0__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_0__8_	AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_0__9_	 AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_0__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_0__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*#AfitBaseVals_0__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_0__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_0__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F12005A,	/*#AfitBaseVals_0__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_0__16_AFIT16_demsharpmix1_iTune*/
	0x0F12001E,	/*#AfitBaseVals_0__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F12001E,	/*#AfitBaseVals_0__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201F4,	/*#AfitBaseVals_0__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*#AfitBaseVals_0__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120046,	/*#AfitBaseVals_0__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120005,	/*#AfitBaseVals_0__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120005,	/*#AfitBaseVals_0__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F12003C,	/*#AfitBaseVals_0__24_AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_0__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F12003C,	/*#AfitBaseVals_0__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_0__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12003C,	/*#AfitBaseVals_0__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F12001E,	/*#AfitBaseVals_0__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_0__30_AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_0__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_0__32_
			AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_0__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_0__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F120A3B,	/*#AfitBaseVals_0__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_0__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_0__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_0__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_0__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_0__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_0__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_0__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F12001E,	/*#AfitBaseVals_0__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120002,	/*#AfitBaseVals_0__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_0__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*#AfitBaseVals_0__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*#AfitBaseVals_0__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_0__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_0__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_0__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*#AfitBaseVals_0__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128003,	/*#AfitBaseVals_0__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F121982,	/*#AfitBaseVals_0__57_AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120A80,	/*#AfitBaseVals_0__58_AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_0__59_AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__60_AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_0__61_AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F124601,	/*#AfitBaseVals_0__62_AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F126444,	/*#AfitBaseVals_0__63_AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F129650,	/*#AfitBaseVals_0__64_AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*#AfitBaseVals_0__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F121E00,	/*#AfitBaseVals_0__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120714,	/*#AfitBaseVals_0__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121464,	/*#AfitBaseVals_0__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121404,	/*#AfitBaseVals_0__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F120F14,	/*#AfitBaseVals_0__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_0__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_0__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F121403,	/*#AfitBaseVals_0__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_0__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_0__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F124446,	/*#AfitBaseVals_0__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F125064,	/*#AfitBaseVals_0__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_0__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_0__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F120000,	/*#AfitBaseVals_0__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F12141E,	/*#AfitBaseVals_0__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F126407,	/*#AfitBaseVals_0__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120414,	/*#AfitBaseVals_0__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_0__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_0__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_0__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F121414,	/*#AfitBaseVals_0__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_0__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F124601,	/*#AfitBaseVals_0__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F126E44,	/*#AfitBaseVals_0__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122864,	/*#AfitBaseVals_0__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_0__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_0__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121E00,	/*#AfitBaseVals_0__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F120714,	/*#AfitBaseVals_0__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_0__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F120004,	/*#AfitBaseVals_0__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120F00,	/*#AfitBaseVals_0__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_0__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_0__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_0__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_1__0_	 AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_1__1_	 AFIT16_CONTRAST*/
	0x0F120014,	/*#AfitBaseVals_1__2_	 AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_1__3_	 AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_1__4_	 AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_1__5_	 AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_1__6_	 AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_1__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_1__8_  AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_1__9_	 AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_1__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_1__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*#AfitBaseVals_1__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_1__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_1__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F12005A,	/*#AfitBaseVals_1__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_1__16_AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*#AfitBaseVals_1__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_1__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*#AfitBaseVals_1__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*#AfitBaseVals_1__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120046,	/*#AfitBaseVals_1__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_1__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_1__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F120064,	/*#AfitBaseVals_1__24_
			AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_1__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F120064,	/*#AfitBaseVals_1__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_1__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12003C,	/*#AfitBaseVals_1__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F12001E,	/*#AfitBaseVals_1__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_1__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_1__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_1__32_
			AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_1__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_1__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*#AfitBaseVals_1__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_1__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_1__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_1__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_1__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_1__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_1__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_1__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_1__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120005,	/*#AfitBaseVals_1__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120002,	/*#AfitBaseVals_1__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_1__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*#AfitBaseVals_1__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*#AfitBaseVals_1__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_1__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_1__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_1__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*#AfitBaseVals_1__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128003,	/*#AfitBaseVals_1__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120A6E,	/*#AfitBaseVals_1__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_1__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_1__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_1__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_1__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F122801,	/*#AfitBaseVals_1__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F12231E,	/*#AfitBaseVals_1__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12961E,	/*#AfitBaseVals_1__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_1__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*#AfitBaseVals_1__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A02,	/*#AfitBaseVals_1__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120764,	/*#AfitBaseVals_1__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F12143C,	/*#AfitBaseVals_1__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121401,	/*#AfitBaseVals_1__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F120F14,	/*#AfitBaseVals_1__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_1__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_1__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*#AfitBaseVals_1__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_1__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_1__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F121E28,	/*#AfitBaseVals_1__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12140F,	/*#AfitBaseVals_1__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_1__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_1__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F120200,	/*#AfitBaseVals_1__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*#AfitBaseVals_1__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123C07,	/*#AfitBaseVals_1__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_1__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121414,	/*#AfitBaseVals_1__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_1__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_1__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_1__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F121E1E,	/*#AfitBaseVals_1__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_1__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F123C01,	/*#AfitBaseVals_1__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F125A3A,	/*#AfitBaseVals_1__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122858,	/*#AfitBaseVals_1__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_1__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_1__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121E00,	/*#AfitBaseVals_1__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F120714,	/*#AfitBaseVals_1__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_1__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F120004,	/*#AfitBaseVals_1__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120F00,	/*#AfitBaseVals_1__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_1__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_1__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_1__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_2__0_	 AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_2__1_	 AFIT16_CONTRAST*/
	0x0F120000,	/*#AfitBaseVals_2__2_	 AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_2__3_	 AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_2__4_	 AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_2__5_	 AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_2__6_	 AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_2__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_2__8_ AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_2__9_	 AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_2__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_2__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*#AfitBaseVals_2__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_2__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_2__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F12005A,	/*#AfitBaseVals_2__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_2__16_AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*#AfitBaseVals_2__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_2__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*#AfitBaseVals_2__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*#AfitBaseVals_2__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120032,	/*#AfitBaseVals_2__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_2__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_2__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F1200B4,	/*#AfitBaseVals_2__24_
			AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_2__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F1200B4,	/*#AfitBaseVals_2__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_2__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12003C,	/*#AfitBaseVals_2__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F12001E,	/*#AfitBaseVals_2__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_2__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_2__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_2__32_
			AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_2__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_2__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*#AfitBaseVals_2__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_2__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_2__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_2__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_2__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_2__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_2__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_2__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_2__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120005,	/*#AfitBaseVals_2__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120001,	/*#AfitBaseVals_2__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_2__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*#AfitBaseVals_2__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*#AfitBaseVals_2__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_2__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_2__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_2__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*#AfitBaseVals_2__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128002,	/*#AfitBaseVals_2__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120080,	/*#AfitBaseVals_2__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_2__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_2__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_2__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_2__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*#AfitBaseVals_2__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*#AfitBaseVals_2__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*#AfitBaseVals_2__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_2__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122A03,	/*#AfitBaseVals_2__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A02,	/*#AfitBaseVals_2__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120864,	/*#AfitBaseVals_2__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*#AfitBaseVals_2__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F129601,	/*#AfitBaseVals_2__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F122814,	/*#AfitBaseVals_2__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400A,	/*#AfitBaseVals_2__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_2__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*#AfitBaseVals_2__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_2__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_2__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F12191B,	/*#AfitBaseVals_2__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120D0F,	/*#AfitBaseVals_2__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_2__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_2__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F12021E,	/*#AfitBaseVals_2__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*#AfitBaseVals_2__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123208,	/*#AfitBaseVals_2__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_2__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121450,	/*#AfitBaseVals_2__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120A28,	/*#AfitBaseVals_2__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_2__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_2__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F122828,	/*#AfitBaseVals_2__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_2__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F122401,	/*#AfitBaseVals_2__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F123622,	/*#AfitBaseVals_2__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122832,	/*#AfitBaseVals_2__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_2__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121003,	/*#AfitBaseVals_2__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121E04,	/*#AfitBaseVals_2__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F120714,	/*#AfitBaseVals_2__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_2__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F125004,	/*#AfitBaseVals_2__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120F40,	/*#AfitBaseVals_2__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F12400F,	/*#AfitBaseVals_2__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_2__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_2__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_3__0_	 AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_3__1_	 AFIT16_CONTRAST*/
	0x0F120000,	/*#AfitBaseVals_3__2_	 AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_3__3_	 AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_3__4_	 AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_3__5_	 AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_3__6_	 AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_3__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_3__8_  AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_3__9_	 AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_3__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_3__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F1200C8,	/*#AfitBaseVals_3__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*#AfitBaseVals_3__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*#AfitBaseVals_3__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F120050,	/*#AfitBaseVals_3__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_3__16_AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*#AfitBaseVals_3__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_3__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*#AfitBaseVals_3__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*#AfitBaseVals_3__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120032,	/*#AfitBaseVals_3__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_3__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_3__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F1200B4,	/*#AfitBaseVals_3__24_
			AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_3__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F1200B4,	/*#AfitBaseVals_3__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_3__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F12002D,	/*#AfitBaseVals_3__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F120019,	/*#AfitBaseVals_3__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_3__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_3__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_3__32_
			AFIT8_sddd8a_sat_thr[7:0],AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*#AfitBaseVals_3__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_3__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12033B,	/*#AfitBaseVals_3__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_3__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_3__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_3__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*#AfitBaseVals_3__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_3__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*#AfitBaseVals_3__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_3__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*#AfitBaseVals_3__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120005,	/*#AfitBaseVals_3__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120001,	/*#AfitBaseVals_3__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_3__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*#AfitBaseVals_3__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*#AfitBaseVals_3__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_3__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_3__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_3__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*#AfitBaseVals_3__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128002,	/*#AfitBaseVals_3__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120080,	/*#AfitBaseVals_3__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_3__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_3__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_3__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_3__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*#AfitBaseVals_3__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*#AfitBaseVals_3__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*#AfitBaseVals_3__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*#AfitBaseVals_3__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122003,	/*#AfitBaseVals_3__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A02,	/*#AfitBaseVals_3__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120864,	/*#AfitBaseVals_3__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*#AfitBaseVals_3__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*#AfitBaseVals_3__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F122814,	/*#AfitBaseVals_3__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F12400A,	/*#AfitBaseVals_3__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*#AfitBaseVals_3__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*#AfitBaseVals_3__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_3__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_3__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F12191B,	/*#AfitBaseVals_3__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120D0F,	/*#AfitBaseVals_3__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*#AfitBaseVals_3__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*#AfitBaseVals_3__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F12021E,	/*#AfitBaseVals_3__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*#AfitBaseVals_3__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123208,	/*#AfitBaseVals_3__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_3__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F121450,	/*#AfitBaseVals_3__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F120A28,	/*#AfitBaseVals_3__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_3__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120302,	/*#AfitBaseVals_3__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F123C3C,	/*#AfitBaseVals_3__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_3__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F121E01,	/*#AfitBaseVals_3__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F12221C,	/*#AfitBaseVals_3__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F12281E,	/*#AfitBaseVals_3__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_3__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*#AfitBaseVals_3__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121402,	/*#AfitBaseVals_3__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F12060E,	/*#AfitBaseVals_3__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_3__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F125204,	/*#AfitBaseVals_3__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F120C40,	/*#AfitBaseVals_3__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F124015,	/*#AfitBaseVals_3__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_3__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_3__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*#AfitBaseVals_4__0_	 AFIT16_BRIGHTNESS*/
	0x0F120000,	/*#AfitBaseVals_4__1_	 AFIT16_CONTRAST*/
	0x0F120000,	/*#AfitBaseVals_4__2_	 AFIT16_SATURATION*/
	0x0F120000,	/*#AfitBaseVals_4__3_	 AFIT16_SHARP_BLUR*/
	0x0F120000,	/*#AfitBaseVals_4__4_	 AFIT16_GLAMOUR*/
	0x0F1200C1,	/*#AfitBaseVals_4__5_	 AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*#AfitBaseVals_4__6_	 AFIT16_Demosaicing_iSatVal*/
	0x0F12009C,	/*#AfitBaseVals_4__7_
			AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*#AfitBaseVals_4__8_  AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*#AfitBaseVals_4__9_	 AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*#AfitBaseVals_4__10_
			AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*#AfitBaseVals_4__11_
			AFIT16_demsharpmix1_iHighThreshold*/
	0x0F120032,	/*#AfitBaseVals_4__12_AFIT16_demsharpmix1_iLowBright*/
	0x0F12028A,	/*#AfitBaseVals_4__13_AFIT16_demsharpmix1_iHighBright*/
	0x0F120032,	/*#AfitBaseVals_4__14_AFIT16_demsharpmix1_iLowSat*/
	0x0F1201F4,	/*#AfitBaseVals_4__15_AFIT16_demsharpmix1_iHighSat*/
	0x0F120070,	/*#AfitBaseVals_4__16_AFIT16_demsharpmix1_iTune*/
	0x0F120002,	/*#AfitBaseVals_4__17_AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*#AfitBaseVals_4__18_AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201AA,	/*#AfitBaseVals_4__19_AFIT16_demsharpmix1_iHystCenter*/
	0x0F12003C,	/*#AfitBaseVals_4__20_
			AFIT16_YUV422_DENOISE_iUVLowThresh*/
	0x0F120050,	/*#AfitBaseVals_4__21_
			AFIT16_YUV422_DENOISE_iUVHighThresh*/
	0x0F120000,	/*#AfitBaseVals_4__22_
			AFIT16_YUV422_DENOISE_iYLowThresh*/
	0x0F120000,	/*#AfitBaseVals_4__23_
			AFIT16_YUV422_DENOISE_iYHighThresh*/
	0x0F1200B4,	/*#AfitBaseVals_4__24_
			AFIT16_Sharpening_iLowSharpClamp*/
	0x0F120014,	/*#AfitBaseVals_4__25_
			AFIT16_Sharpening_iHighSharpClamp*/
	0x0F1200B4,	/*#AfitBaseVals_4__26_
			AFIT16_Sharpening_iLowSharpClamp_Bin*/
	0x0F120014,	/*#AfitBaseVals_4__27_
			AFIT16_Sharpening_iHighSharpClamp_Bin*/
	0x0F120046,	/*#AfitBaseVals_4__28_
			AFIT16_Sharpening_iLowSharpClamp_sBin*/
	0x0F120019,	/*#AfitBaseVals_4__29_
			AFIT16_Sharpening_iHighSharpClamp_sBin*/
	0x0F120A24,	/*#AfitBaseVals_4__30_
			AFIT8_sddd8a_edge_low [7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*#AfitBaseVals_4__31_
			AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level	[15:8]*/
	0x0F120229,	/*#AfitBaseVals_4__32_
			AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F120503,	/*#AfitBaseVals_4__33_
			AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxSlopeAllowed [15:8]*/
	0x0F12080F,	/*#AfitBaseVals_4__34_
			AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow [15:8]*/
	0x0F120808,	/*#AfitBaseVals_4__35_
			AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*#AfitBaseVals_4__36_
			AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_4__37_
			AFIT8_sddd8a_iSatSat[7:0],
			AFIT8_sddd8a_iRadialTune [15:8]*/
	0x0F12022D,	/*#AfitBaseVals_4__38_
			AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*#AfitBaseVals_4__39_
			AFIT8_sddd8a_iLowMaxSlopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxSlopeAllowed [15:8]*/
	0x0F120301,	/*#AfitBaseVals_4__40_
			AFIT8_sddd8a_iLowSlopeThresh[7:0],
			AFIT8_sddd8a_iHighSlopeThresh [15:8]*/
	0x0F12FF07,	/*#AfitBaseVals_4__41_
			AFIT8_sddd8a_iSquaresRounding [7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12061E,	/*#AfitBaseVals_4__42_
			AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*#AfitBaseVals_4__43_
			AFIT8_Demosaicing_iDesatThresh	[7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120606,	/*#AfitBaseVals_4__44_
			AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A03,	/*#AfitBaseVals_4__45_
			AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120028,	/*#AfitBaseVals_4__46_
			AFIT8_Sharpening_iMSharpen [7:0],
			AFIT8_Sharpening_iMShThresh [15:8]*/
	0x0F120002,	/*#AfitBaseVals_4__47_
			AFIT8_Sharpening_iWSharpen [7:0],
			AFIT8_Sharpening_iWShThresh [15:8]*/
	0x0F120001,	/*#AfitBaseVals_4__48_
			AFIT8_Sharpening_nSharpWidth [7:0],
			AFIT8_Sharpening_iReduceNegative	[15:8]*/
	0x0F1200FF,	/*#AfitBaseVals_4__49_
			AFIT8_Sharpening_iShDespeckle [7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*#AfitBaseVals_4__50_
			AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*#AfitBaseVals_4__51_
			AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*#AfitBaseVals_4__52_
			AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff [15:8]*/
	0x0F120600,	/*#AfitBaseVals_4__53_
			AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth	[15:8]*/
	0x0F120504,	/*#AfitBaseVals_4__54_
			AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*#AfitBaseVals_4__55_
			AFIT8_demsharpmix1_iHystTune [7:0],
			*	AFIT8_YUV422_DENOISE_iUVSupport	[15:8]*/
	0x0F128001,	/*#AfitBaseVals_4__56_
			AFIT8_YUV422_DENOISE_iYSupport	[7:0],
			AFIT8_byr_cgras_iShadingPower [15:8]*/
	0x0F120080,	/*#AfitBaseVals_4__57_
			AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce	[15:8]*/
	0x0F120080,	/*#AfitBaseVals_4__58_
			AFIT8_ccm_oscar_iSaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*#AfitBaseVals_4__59_
			AFIT8_RGB2YUV_iRGBGain	[7:0],
			AFIT8_RGB2YUV_iSaturation [15:8]*/
	0x0F125050,	/*#AfitBaseVals_4__60_
			AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*#AfitBaseVals_4__61_
			AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*#AfitBaseVals_4__62_
			AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F121219,	/*#AfitBaseVals_4__63_
			AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12320D,	/*#AfitBaseVals_4__64_
			AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120A0A,	/*#AfitBaseVals_4__65_
			AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122304,	/*#AfitBaseVals_4__66_
			AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemSharpenLow [15:8]*/
	0x0F120A08,	/*#AfitBaseVals_4__67_
			AFIT8_Demosaicing_iDemSharpenHigh[7:0],
			AFIT8_Demosaicing_iDemSharpThresh [15:8]*/
	0x0F120832,	/*#AfitBaseVals_4__68_
			AFIT8_Demosaicing_iDemShLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*#AfitBaseVals_4__69_
			AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*#AfitBaseVals_4__70_
			AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_Sharpening_iLowSharpPower [15:8]*/
	0x0F122A0A,	/*#AfitBaseVals_4__71_
			AFIT8_Sharpening_iHighSharpPower[7:0],
			AFIT8_Sharpening_iLowShDenoise [15:8]*/
	0x0F124006,	/*#AfitBaseVals_4__72_
			AFIT8_Sharpening_iHighShDenoise [7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120604,	/*#AfitBaseVals_4__73_
			AFIT8_Sharpening_iReduceEdgeSlope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125006,	/*#AfitBaseVals_4__74_
			AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*#AfitBaseVals_4__75_
			AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin	[15:8]*/
	0x0F120101,	/*#AfitBaseVals_4__76_
			AFIT8_sddd8a_iClustMulT_C_Bin [7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin [15:8]*/
	0x0F12191B,	/*#AfitBaseVals_4__77_
			AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120D0F,	/*#AfitBaseVals_4__78_
			AFIT8_sddd8a_iDenThreshLow_Bin	[7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120A28,	/*#AfitBaseVals_4__79_
			AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F12040A,	/*#AfitBaseVals_4__80_
			AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin [15:8]*/
	0x0F120820,	/*#AfitBaseVals_4__81_
			AFIT8_Demosaicing_iDemSharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemSharpenHigh_Bin [15:8]*/
	0x0F12280A,	/*#AfitBaseVals_4__82_
			AFIT8_Demosaicing_iDemSharpThresh_Bin [7:0],
			AFIT8_Demosaicing_iDemShLowLimit_Bin [15:8]*/
	0x0F123208,	/*#AfitBaseVals_4__83_
			AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin [15:8]*/
	0x0F120114,	/*#AfitBaseVals_4__84_
			AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin	[15:8]*/
	0x0F120A64,	/*#AfitBaseVals_4__85_
			AFIT8_Sharpening_iLowSharpPower_Bin [7:0],
			AFIT8_Sharpening_iHighSharpPower_Bin [15:8]*/
	0x0F12062A,	/*#AfitBaseVals_4__86_
			AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_Sharpening_iHighShDenoise_Bin	[15:8]*/
	0x0F120440,	/*#AfitBaseVals_4__87_
			AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_Sharpening_iReduceEdgeSlope_Bin [15:8]*/
	0x0F120606,	/*#AfitBaseVals_4__88_
			AFIT8_demsharpmix1_iWideFiltReduce_Bin	[7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin [15:8]*/
	0x0F124646,	/*#AfitBaseVals_4__89_
			AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*#AfitBaseVals_4__90_
			AFIT8_sddd8a_iClustMulT_H_sBin	[7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin	[15:8]*/
	0x0F121801,	/*#AfitBaseVals_4__91_
			AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin [15:8]*/
	0x0F12191C,	/*#AfitBaseVals_4__92_
			AFIT8_sddd8a_DispTH_High_sBin [7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin	[15:8]*/
	0x0F122818,	/*#AfitBaseVals_4__93_
			AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*#AfitBaseVals_4__94_
			AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*#AfitBaseVals_4__95_
			AFIT8_Demosaicing_iEdgeDesatLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpenLow_sBin [15:8]*/
	0x0F121405,	/*#AfitBaseVals_4__96_
			AFIT8_Demosaicing_iDemSharpenHigh_sBin	[7:0],
			AFIT8_Demosaicing_iDemSharpThresh_sBin [15:8]*/
	0x0F12050C,	/*#AfitBaseVals_4__97_
			AFIT8_Demosaicing_iDemShLowLimit_sBin [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*#AfitBaseVals_4__98_
			AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin	[15:8]*/
	0x0F125204,	/*#AfitBaseVals_4__99_
			AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_Sharpening_iLowSharpPower_sBin [15:8]*/
	0x0F121440,	/*#AfitBaseVals_4__100_
			AFIT8_Sharpening_iHighSharpPower_sBin [7:0],
			AFIT8_Sharpening_iLowShDenoise_sBin [15:8]*/
	0x0F124015,	/*#AfitBaseVals_4__101_
			AFIT8_Sharpening_iHighShDenoise_sBin	[7:0],
			AFIT8_Sharpening_iReduceEdgeMinMult_sBin [15:8]*/
	0x0F120204,	/*#AfitBaseVals_4__102_
			AFIT8_Sharpening_iReduceEdgeSlope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*#AfitBaseVals_4__103_
			AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	/*	param_end   TVAR_afit_pBaseVals*/
	/*	param_start afit_pConstBaseVals*/
	0x0F127DFA,	/*#ConstAfitBaseVals	Because	of Edge,
			disable the iGradientWide*/
	0x0F12FFBD,	/*#ConstAfitBaseVals_1_*/
	0x0F1226FE,	/*#ConstAfitBaseVals_2_*/
	0x0F12F7BC,	/*#ConstAfitBaseVals_3_*/
	0x0F127E06,	/*#ConstAfitBaseVals_4_*/
	0x0F1200D3,	/*#ConstAfitBaseVals_5_*/
	/*	param_end   afit_pConstBaseVals*/
	/* AFIT by Normalized Brightness Tuning parameter*/
	0x002A3780,
	0x0F120000,	/* on/off AFIT by NB option 0000 : Ni  0001:Nb*/
	0x0F120014,	/* NormBR[0]*/
	0x002A3782,
	0x0F1200D2,	/* NormBR[1]*/
	0x002A3782,
	0x0F120384,	/* NormBR[2]*/
	0x002A3782,
	0x0F1207D0,	/* NormBR[3]*/
	0x002A3782,
	0x0F121388,	/* NormBR[4]*/

};

/*===========================================
* CAMERA_PREVIEW - ?   ?  *
============================================*/

static const u32 s5k5bbgx_preview[] = {
	/*PREVIEW*/
	0xFCFCD000,
	0x00287000,
	0x002A0156,	/*#REG_TC_GP_ActivePrevConfig*/
	0x0F120000,
	0x002A015E,	/*#REG_TC_GP_ActiveCapConfig*/
	0x0F120000,
	0x002A015A,	/*#REG_TC_GP_PrevOpenAfterChange*/
	0x0F120001,
	0x002A0142,	/*#REG_TC_GP_NewConfigSync*/
	0x0F120001,
	0x002A0158,	/*#REG_TC_GP_PrevConfigChanged*/
	0x0F120001,
	0x002A0160,	/*#REG_TC_GP_CapConfigChanged*/
	0x0F120001,
	0x002A013A,	/*#REG_TC_GP_EnablePreview*/
	0x0F120001,
	0x002A013C,	/*#REG_TC_GP_EnablePreviewChanged*/
	0x0F120001,
	0xffff0096, /* 150ms */
};

/*===========================================
*	CAMERA_SNAPSHOT	 - ?		  *
============================================*/

static const u32 s5k5bbgx_capture[] = {
	/*Capture*/
	0xFCFCD000,
	0x00287000,
	0x002A015E,	/*#REG_TC_GP_ActiveCapConfig*/
	0x0F120000,
	0x002A0142,	/*#REG_TC_GP_NewConfigSync*/
	0x0F120001,
	0x002A0160,	/*#REG_TC_GP_CapConfigChanged*/
	0x0F120001,
	0x002A013E,	/*#REG_TC_GP_EnableCapture*/
	0x0F120001,
	0x002A0140,	/*#REG_TC_GP_EnableCaptureChanged*/
	0x0F120001,
	0xffff0096, /* 150ms */
};

static const u32 s5k5bbgx_mode_check_capture_staus[] = {
	0x002C7000,
	0x002E0142,
};

static const u32 s5k5bbgx_recording_common[] = {
	0xFCFCD000,
	0x00100001,	/*S/W Reset*/
	0x10300000, /*contint_host_int*/
	0x00140001, /*sw_load_complete - Release CORE (Arm) from reset state*/
	0xFFFF000A,

	/*0x0028D000,*/	/*Driving Current*/
	/*0x002A1082,*/
	/*0x0F1203ff,*/	/*cregs_d0_d4_cd10 D4[9:8], D3[7:6], D2[5:4],
			D1[3:2], D0[1:0]*/
	/*0x002A1084,*/
	/*0x0F1203ff,*/	/*cregs_d5_d9_cd10 D9[9:8], D8[7:6], D7[5:4],
			D6[3:2], D5[1:0]*/
	/*0x002A1088,*/
	/*0x0F120fcf,*/	/*cregs_clks_output_cd10 SDA[11:10], SCL[9:8],
			PCLK[7:6], VSYNC[3:2],	HSYNC[1:0]*/

	0x0028D000,
	0x002AF404,
	0x0F120038,	/*aig_adc_sat[7:0] : 850mV*/
	0x0F120001,	/*ms[2:0]; 2h@Normal, 2h@PLA, 1h@CNT.AVG*/
	0x0F12000C,	/*aig_sig_mx[5:0]*/
	0x0F120006,	/*aig_rst_mx[5:0]*/
	0x0F120008,	/*rmp_option[7:0]; [3]SL_Low_PWR_SAVE On*/
	0x002AF418,
	0x0F120003,	/*aig_dbr_clk_sel[1:0]*/
	0x002AF41C,
	0x0F120140,	/*aig_bist_sig_width_e[10:0]*/
	0x0F120140,	/*aig_bist_sig_width_o[10:0]*/
	0x0F120066,	/*aig_bist_sig_width_o[10:0]*/
	0x0F120005,	/*aig_pix_bias[3:0]*/
	0x002AF426,
	0x0F1200D4,	/*aig_clp_lvl[7:0]*/
	0x002AF42A,
	0x0F120001,	/*aig_ref_option[0] SL_Low_PWR_SAVE On*/
	0x002AF430,
	0x0F120001,	/*aig_pd_cp_rosc[0]*/
	0x0F120001,	/*aig_pd_ncp_rosc[0]*/
	0x002AF43A,
	0x0F120000,	/*aig_pd_fblv[0]*/
	0x002AF440,
	0x0F120044,	/*aig_rosc_tune_ncp[7:4] aig_rosc_tune_cp[3:0]*/
	0x002AF44A,
	0x0F120000,	/*aig_fb_lv[1:0]*/
	0x002AF45C,
	0x0F120000,	/*aig_dshut_en[0]*/
	0x0F120000,	/*aig_srx_en[0]*/
	0x002AF462,
	0x0F120001,	/*aig_pdb_atop[0]*/
	0x002AF46E,
	0x0F121F02,	/*aig_cds_test[15:0]*/
	0x002AF474,
	0x0F12000E,	/*aig_stx_gap[4:0]*/
	0x002AE42E,
	0x0F120004,	/*adlc_qec[2:0]*/
	0x00287000,
	0x002A13E0,
	0x0F120000,	/*senHal_bSRX	SRX OFF*/
	0x002A13C8,
	0x0F120001,	/*senHal_bSenAAC AAC Enable*/
	0x002A12D8,
	0x0F120464,	/*senHal_ContPtrs_senModesDataArr[78]*/
	0x0F120468,	/*senHal_ContPtrs_senModesDataArr[79]*/
	0x002A12F6,
	0x0F120000,	/*senHal_ContPtrs_senModesDataArr[93]*/
	0x002A13CC,
	0x0F121FC0,	/*senHal_bSen11ADLC [12:0] : Write tuning value	to E404
			register*/
	0x002A13EC,
	0x0F120001,	/*senHal_DarklevelTuneMode*/
	0x002A184C,
	0x0F121EE1,
	0x00287000,
	0x002A040E,
	0x0F120003,	/*skl_usConfigStbySettings*/
	0xFFFF000A,
	0x002A1218,
	0x0F120002,	/*senHal_SenBinFactor*/
	0x0F120002,	/*senHal_SamplingType*/
	0x002A0C9A,
	0x0F120001,	/*setot_bUseDigitalHbin*/
	0x002A1438,
	0x0F12F468,	/*senHal_TuneStr_AngTuneData1[0]*/
	0x0F120000,	/*senHal_TuneStr_AngTuneData1[1] not use binninb block
			0x0000	,use binnin blcok 0x0000*/
	0x0F120008,	/*senHal_TuneStr_AngTuneData1[2] not use binninb block
			0x000A	,use binnin blcok 0x0008*/
	0x0F120006,	/*senHal_TuneStr_AngTuneData1[3] not use binninb block
			0x0005	,use binnin blcok 0x0006*/
	0x0F120000,	/*senHal_TuneStr_AngTuneData1[4]*/
	0xFFFF000A,
	0x002A0416,
	0x0F12F400,		/*skl_usStbyBackupReg[0][0]*/
	0x0F120074,		/*skl_usStbyBackupReg[0][1]*/
	0x0F12E42E,		/*skl_usStbyBackupReg[1][0]*/
	0x0F120030,		/*skl_usStbyBackupReg[1][1]*/
	0x002A378C,
	0x0F120000,	/* On/off regiSter bUSeOTP*/
	0x002A0AD8,
	0x0F120F00,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F00,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120F00,
	0x0F12000F,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120000,
	0x0F120000,
	0x0F12000F,
	0x0F120F0F,
	0x0F120F00,
	0x0F120F00,
	0x0F120000,
	0x0F120F0F,
	0x0F120000,
	0x0F120F0F,
	0x0F12000F,
	0x0F12000F,
	0x0F120F00,
	0x0F128608,
	0x0F12E960,
	0x0F120243,
	0x0F12128B,
	0x0F12F073,
	0x0F120270,
	0x0F12DF47,
	0x0F12F226,
	0x0F121A31,
	0x0F12DFDA,
	0x0F121200,
	0x0F1205A9,
	0x0F120F16,
	0x0F120F5E,
	0x0F12DF10,
	0x0F1225BF,
	0x0F12FCF0,
	0x0F12DE1B,
	0x0F12025B,
	0x0F12FA8B,
	0x0F12163B,
	0x0F12DF44,
	0x0F12FB2D,
	0x0F1230E6,
	0x0F12FE07,
	0x0F12F47C,
	0x0F1209F2,
	0x0F120AED,
	0x0F12FA09,
	0x0F12E70E,
	0x0F120158,
	0x0F121110,
	0x0F12E28C,
	0x0F120DFB,
	0x0F12074B,
	0x0F12FBE5,
	0x0F12961C,
	0x0F12E21A,
	0x0F120ADF,
	0x0F120A67,
	0x0F12F8A6,
	0x0F12FDC3,
	0x0F12D590,
	0x0F12FA69,
	0x0F1208D5,
	0x0F12F635,
	0x0F12057E,
	0x0F12043B,
	0x0F12155C,
	0x0F1200C6,
	0x0F12F042,
	0x0F12176A,
	0x0F12F818,
	0x0F12F1F3,
	0x0F12026F,
	0x0F1208F6,
	0x0F120CCF,
	0x0F12E42D,
	0x0F120A92,
	0x0F1210EC,
	0x0F12005F,
	0x0F12F02C,
	0x0F120672,
	0x0F1209BF,
	0x0F12F4B5,
	0x0F12FC22,
	0x0F12FD50,
	0x0F120C26,
	0x0F12EED3,
	0x0F1207C3,
	0x0F12080F,
	0x0F12F6CF,
	0x0F127A3B,
	0x0F12E9DC,
	0x0F12088E,
	0x0F1201C8,
	0x0F12043C,
	0x0F12F7E2,
	0x0F12E391,
	0x0F12F3C4,
	0x0F121422,
	0x0F12E845,
	0x0F120D16,
	0x0F1206CA,
	0x0F120DEB,
	0x0F121324,
	0x0F12E814,
	0x0F1216B7,
	0x0F1202AC,
	0x0F12DE4D,
	0x0F1201EA,
	0x0F12F0C2,
	0x0F120E06,
	0x0F12EC6D,
	0x0F12FDF0,
	0x0F122B46,
	0x0F120710,
	0x0F12F84C,
	0x0F120E52,
	0x0F120675,
	0x0F12F0D7,
	0x0F12ED40,
	0x0F12F3AD,
	0x0F12179A,
	0x0F12DE9B,
	0x0F1210BA,
	0x0F120825,
	0x0F12FE0A,
	0x0F1288E9,
	0x0F12E9E0,
	0x0F12043D,
	0x0F120A17,
	0x0F12FC21,
	0x0F12FB58,
	0x0F12DCE0,
	0x0F12F24C,
	0x0F121A19,
	0x0F12E011,
	0x0F1211A3,
	0x0F120649,
	0x0F120D04,
	0x0F120E15,
	0x0F12E112,
	0x0F1227BD,
	0x0F12F7AA,
	0x0F12E06A,
	0x0F120A16,
	0x0F12FD23,
	0x0F121226,
	0x0F12DA34,
	0x0F1207A4,
	0x0F122AD3,
	0x0F12FE27,
	0x0F12EE64,
	0x0F120CAD,
	0x0F1211C5,
	0x0F12EC55,
	0x0F12ED98,
	0x0F12F88A,
	0x0F121842,
	0x0F12E1D5,
	0x0F1208FD,
	0x0F120FB6,
	0x0F12F801,
	0x002A0378,
	0x0F120001,	/*REG_TC_DBG_RelnitCmd*/
	0x002A05E8,
	0x0F1200E4,	/*TVAR_ash_AwbAshCord_0_ Horizon*/
	0x0F1200F0,	/*TVAR_ash_AwbAshCord_1_ IncandA*/
	0x0F120100,	/*TVAR_ash_AwbAshCord_2_ WW*/
	0x0F120120,	/*TVAR_ash_AwbAshCord_3_ CW*/
	0x0F120150,	/*TVAR_ash_AwbAshCord_4_ D50*/
	0x0F120180,	/*TVAR_ash_AwbAshCord_5_ D65*/
	0x0F1201A0,	/*TVAR_ash_AwbAshCord_6_ D75*/
	0x002A05FE,
	0x0F123800,	/*TVAR_ash_GASAlpha_0__0_ Horizon*/
	0x0F124000,	/*TVAR_ash_GASAlpha_0__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_0__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_0__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_1__0_ IncandA*/
	0x0F124000,	/*TVAR_ash_GASAlpha_1__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_1__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_1__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_2__0_ WW*/
	0x0F124000,	/*TVAR_ash_GASAlpha_2__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_2__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_2__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_3__0_ CW*/
	0x0F124000,	/*TVAR_ash_GASAlpha_3__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_3__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_3__3_*/
	0x0F123800,	/*TVAR_ash_GASAlpha_4__0_ D50*/
	0x0F124000,	/*TVAR_ash_GASAlpha_4__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_4__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_4__3_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__0_ D65*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_5__3_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__0_ D75*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__1_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__2_*/
	0x0F124000,	/*TVAR_ash_GASAlpha_6__3_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_0_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_1_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_2_*/
	0x0F124000,	/*TVAR_ash_GASOutdoorAlpha_3_*/
	0x00287000,
	0x002A2744,
	0x0F12B510,    /* 70002744*/
	0x0F124A1C,    /* 70002746*/
	0x0F1221FB,    /* 70002748*/
	0x0F12481C,    /* 7000274A*/
	0x0F12C004,    /* 7000274C*/
	0x0F126001,    /* 7000274E*/
	0x0F12491B,    /* 70002750*/
	0x0F12481C,    /* 70002752*/
	0x0F12F000,    /* 70002754*/
	0x0F12FA0E,    /* 70002756*/
	0x0F12491B,    /* 70002758*/
	0x0F12481C,    /* 7000275A*/
	0x0F12F000,    /* 7000275C*/
	0x0F12FA0A,    /* 7000275E*/
	0x0F12491B,    /* 70002760*/
	0x0F12481C,    /* 70002762*/
	0x0F12F000,    /* 70002764*/
	0x0F12FA06,    /* 70002766*/
	0x0F12491B,    /* 70002768*/
	0x0F12481C,    /* 7000276A*/
	0x0F12F000,    /* 7000276C*/
	0x0F12FA02,    /* 7000276E*/
	0x0F12491B,    /* 70002770*/
	0x0F12481C,    /* 70002772*/
	0x0F12F000,    /* 70002774*/
	0x0F12F9FE,    /* 70002776*/
	0x0F12491B,    /* 70002778*/
	0x0F12481C,    /* 7000277A*/
	0x0F12F000,    /* 7000277C*/
	0x0F12F9FA,    /* 7000277E*/
	0x0F12491B,    /* 70002780*/
	0x0F12481C,    /* 70002782*/
	0x0F12F000,    /* 70002784*/
	0x0F12F9F6,    /* 70002786*/
	0x0F12481B,    /* 70002788*/
	0x0F122130,    /* 7000278A*/
	0x0F128001,    /* 7000278C*/
	0x0F1221C0,    /* 7000278E*/
	0x0F128041,    /* 70002790*/
	0x0F122104,    /* 70002792*/
	0x0F128081,    /* 70002794*/
	0x0F122100,    /* 70002796*/
	0x0F1280C1,    /* 70002798*/
	0x0F128101,    /* 7000279A*/
	0x0F124917,    /* 7000279C*/
	0x0F122016,    /* 7000279E*/
	0x0F1283C8,    /* 700027A0*/
	0x0F124917,    /* 700027A2*/
	0x0F124817,    /* 700027A4*/
	0x0F12F000,    /* 700027A6*/
	0x0F12F9E5,    /* 700027A8*/
	0x0F124917,    /* 700027AA*/
	0x0F124817,    /* 700027AC*/
	0x0F12F000,    /* 700027AE*/
	0x0F12F9E1,    /* 700027B0*/
	0x0F12BC10,    /* 700027B2*/
	0x0F12BC08,    /* 700027B4*/
	0x0F124718,    /* 700027B6*/
	0x0F120000,    /* 700027B8*/
	0x0F125BB1,    /* 700027BA*/
	0x0F121770,    /* 700027BC*/
	0x0F127000,    /* 700027BE*/
	0x0F122811,    /* 700027C0*/
	0x0F127000,    /* 700027C2*/
	0x0F12C0BB,    /* 700027C4*/
	0x0F120000,    /* 700027C6*/
	0x0F12284F,    /* 700027C8*/
	0x0F127000,    /* 700027CA*/
	0x0F123609,    /* 700027CC*/
	0x0F120000,    /* 700027CE*/
	0x0F122867,    /* 700027D0*/
	0x0F127000,    /* 700027D2*/
	0x0F1277C7,    /* 700027D4*/
	0x0F120000,    /* 700027D6*/
	0x0F1228F3,    /* 700027D8*/
	0x0F127000,    /* 700027DA*/
	0x0F12727D,    /* 700027DC*/
	0x0F120000,    /* 700027DE*/
	0x0F122949,    /* 700027E0*/
	0x0F127000,    /* 700027E2*/
	0x0F129919,    /* 700027E4*/
	0x0F120000,    /* 700027E6*/
	0x0F122987,    /* 700027E8*/
	0x0F127000,    /* 700027EA*/
	0x0F121C63,    /* 700027EC*/
	0x0F120000,    /* 700027EE*/
	0x0F1229E7,    /* 700027F0*/
	0x0F127000,    /* 700027F2*/
	0x0F1204CB,    /* 700027F4*/
	0x0F120000,    /* 700027F6*/
	0x0F122C7C,    /* 700027F8*/
	0x0F127000,    /* 700027FA*/
	0x0F120CA8,    /* 700027FC*/
	0x0F127000,    /* 700027FE*/
	0x0F122B1D,    /* 70002800*/
	0x0F127000,    /* 70002802*/
	0x0F1250AF,    /* 70002804*/
	0x0F120000,    /* 70002806*/
	0x0F122B2D,    /* 70002808*/
	0x0F127000,    /* 7000280A*/
	0x0F125623,    /* 7000280C*/
	0x0F120000,    /* 7000280E*/
	0x0F12B4F0,    /* 70002810*/
	0x0F126801,    /* 70002812*/
	0x0F12468C,    /* 70002814*/
	0x0F126846,    /* 70002816*/
	0x0F122200,    /* 70002818*/
	0x0F1249C7,    /* 7000281A*/
	0x0F122000,    /* 7000281C*/
	0x0F122724,    /* 7000281E*/
	0x0F124357,    /* 70002820*/
	0x0F12183B,    /* 70002822*/
	0x0F124664,    /* 70002824*/
	0x0F125CE5,    /* 70002826*/
	0x0F12005C,    /* 70002828*/
	0x0F125B34,    /* 7000282A*/
	0x0F12072D,    /* 7000282C*/
	0x0F120F2D,    /* 7000282E*/
	0x0F12800D,    /* 70002830*/
	0x0F12804C,    /* 70002832*/
	0x0F12808B,    /* 70002834*/
	0x0F122301,    /* 70002836*/
	0x0F1280CB,    /* 70002838*/
	0x0F122300,    /* 7000283A*/
	0x0F1280CB,    /* 7000283C*/
	0x0F121C40,    /* 7000283E*/
	0x0F122824,    /* 70002840*/
	0x0F12D3EE,    /* 70002842*/
	0x0F121C52,    /* 70002844*/
	0x0F122A04,    /* 70002846*/
	0x0F12D3E8,    /* 70002848*/
	0x0F12BCF0,    /* 7000284A*/
	0x0F124770,    /* 7000284C*/
	0x0F12B510,    /* 7000284E*/
	0x0F12F000,    /* 70002850*/
	0x0F12F998,    /* 70002852*/
	0x0F1248B9,    /* 70002854*/
	0x0F127A81,    /* 70002856*/
	0x0F1248B9,    /* 70002858*/
	0x0F126B00,    /* 7000285A*/
	0x0F12F000,    /* 7000285C*/
	0x0F12F99A,    /* 7000285E*/
	0x0F12BC10,    /* 70002860*/
	0x0F12BC08,    /* 70002862*/
	0x0F124718,    /* 70002864*/
	0x0F12B5F8,    /* 70002866*/
	0x0F126805,    /* 70002868*/
	0x0F126844,    /* 7000286A*/
	0x0F124EB5,    /* 7000286C*/
	0x0F128861,    /* 7000286E*/
	0x0F128AB0,    /* 70002870*/
	0x0F128A72,    /* 70002872*/
	0x0F122301,    /* 70002874*/
	0x0F124368,    /* 70002876*/
	0x0F121889,    /* 70002878*/
	0x0F1217C2,    /* 7000287A*/
	0x0F120E12,    /* 7000287C*/
	0x0F121810,    /* 7000287E*/
	0x0F121202,    /* 70002880*/
	0x0F128820,    /* 70002882*/
	0x0F12029B,    /* 70002884*/
	0x0F1218C0,    /* 70002886*/
	0x0F12F000,    /* 70002888*/
	0x0F12F98C,    /* 7000288A*/
	0x0F129000,    /* 7000288C*/
	0x0F128AF6,    /* 7000288E*/
	0x0F124268,    /* 70002890*/
	0x0F12210A,    /* 70002892*/
	0x0F124370,    /* 70002894*/
	0x0F12F000,    /* 70002896*/
	0x0F12F98D,    /* 70002898*/
	0x0F12436E,    /* 7000289A*/
	0x0F120007,    /* 7000289C*/
	0x0F12210A,    /* 7000289E*/
	0x0F120030,    /* 700028A0*/
	0x0F12F000,    /* 700028A2*/
	0x0F12F987,    /* 700028A4*/
	0x0F129A00,    /* 700028A6*/
	0x0F120039,    /* 700028A8*/
	0x0F12F000,    /* 700028AA*/
	0x0F12F989,    /* 700028AC*/
	0x0F120002,    /* 700028AE*/
	0x0F128820,    /* 700028B0*/
	0x0F121880,    /* 700028B2*/
	0x0F128020,    /* 700028B4*/
	0x0F1248A4,    /* 700028B6*/
	0x0F1288C1,    /* 700028B8*/
	0x0F1248A2,    /* 700028BA*/
	0x0F123820,    /* 700028BC*/
	0x0F128B40,    /* 700028BE*/
	0x0F124240,    /* 700028C0*/
	0x0F124350,    /* 700028C2*/
	0x0F12F000,    /* 700028C4*/
	0x0F12F976,    /* 700028C6*/
	0x0F128861,    /* 700028C8*/
	0x0F121840,    /* 700028CA*/
	0x0F128060,    /* 700028CC*/
	0x0F12BCF8,    /* 700028CE*/
	0x0F12BC08,    /* 700028D0*/
	0x0F124718,    /* 700028D2*/
	0x0F12B570,    /* 700028D4*/
	0x0F124C9B,    /* 700028D6*/
	0x0F123C20,    /* 700028D8*/
	0x0F128B20,    /* 700028DA*/
	0x0F12F000,    /* 700028DC*/
	0x0F12F978,    /* 700028DE*/
	0x0F124D99,    /* 700028E0*/
	0x0F1280E8,    /* 700028E2*/
	0x0F128B60,    /* 700028E4*/
	0x0F12F000,    /* 700028E6*/
	0x0F12F97B,    /* 700028E8*/
	0x0F128128,    /* 700028EA*/
	0x0F12BC70,    /* 700028EC*/
	0x0F12BC08,    /* 700028EE*/
	0x0F124718,    /* 700028F0*/
	0x0F12B508,    /* 700028F2*/
	0x0F124895,    /* 700028F4*/
	0x0F124669,    /* 700028F6*/
	0x0F12F000,    /* 700028F8*/
	0x0F12F97A,    /* 700028FA*/
	0x0F124894,    /* 700028FC*/
	0x0F12214D,    /* 700028FE*/
	0x0F128201,    /* 70002900*/
	0x0F122196,    /* 70002902*/
	0x0F128281,    /* 70002904*/
	0x0F12211D,    /* 70002906*/
	0x0F128301,    /* 70002908*/
	0x0F12F7FF,    /* 7000290A*/
	0x0F12FFE3,    /* 7000290C*/
	0x0F12F000,    /* 7000290E*/
	0x0F12F977,    /* 70002910*/
	0x0F12466B,    /* 70002912*/
	0x0F128818,    /* 70002914*/
	0x0F128859,    /* 70002916*/
	0x0F121A40,    /* 70002918*/
	0x0F12498E,    /* 7000291A*/
	0x0F126348,    /* 7000291C*/
	0x0F12488A,    /* 7000291E*/
	0x0F129900,    /* 70002920*/
	0x0F123876,    /* 70002922*/
	0x0F12F000,    /* 70002924*/
	0x0F12F974,    /* 70002926*/
	0x0F12466B,    /* 70002928*/
	0x0F12488A,    /* 7000292A*/
	0x0F128819,    /* 7000292C*/
	0x0F123080,    /* 7000292E*/
	0x0F1284C1,    /* 70002930*/
	0x0F128859,    /* 70002932*/
	0x0F128501,    /* 70002934*/
	0x0F124987,    /* 70002936*/
	0x0F122000,    /* 70002938*/
	0x0F123920,    /* 7000293A*/
	0x0F127088,    /* 7000293C*/
	0x0F123140,    /* 7000293E*/
	0x0F127388,    /* 70002940*/
	0x0F12B001,    /* 70002942*/
	0x0F12BC08,    /* 70002944*/
	0x0F124718,    /* 70002946*/
	0x0F12B570,    /* 70002948*/
	0x0F120004,    /* 7000294A*/
	0x0F126820,    /* 7000294C*/
	0x0F126865,    /* 7000294E*/
	0x0F12F000,    /* 70002950*/
	0x0F12F966,    /* 70002952*/
	0x0F120402,    /* 70002954*/
	0x0F124880,    /* 70002956*/
	0x0F120C12,    /* 70002958*/
	0x0F128142,    /* 7000295A*/
	0x0F12487F,    /* 7000295C*/
	0x0F128801,    /* 7000295E*/
	0x0F122900,    /* 70002960*/
	0x0F12D008,    /* 70002962*/
	0x0F12497E,    /* 70002964*/
	0x0F12002B,    /* 70002966*/
	0x0F126D8A,    /* 70002968*/
	0x0F122105,    /* 7000296A*/
	0x0F121C80,    /* 7000296C*/
	0x0F12F000,    /* 7000296E*/
	0x0F12F95F,    /* 70002970*/
	0x0F126020,    /* 70002972*/
	0x0F12E005,    /* 70002974*/
	0x0F12487B,    /* 70002976*/
	0x0F12002B,    /* 70002978*/
	0x0F122105,    /* 7000297A*/
	0x0F12F000,    /* 7000297C*/
	0x0F12F958,    /* 7000297E*/
	0x0F126020,    /* 70002980*/
	0x0F126820,    /* 70002982*/
	0x0F12E7B2,    /* 70002984*/
	0x0F12B5F8,    /* 70002986*/
	0x0F124975,    /* 70002988*/
	0x0F122200,    /* 7000298A*/
	0x0F123160,    /* 7000298C*/
	0x0F1283CA,    /* 7000298E*/
	0x0F126800,    /* 70002990*/
	0x0F124669,    /* 70002992*/
	0x0F12F000,    /* 70002994*/
	0x0F12F92C,    /* 70002996*/
	0x0F12466B,    /* 70002998*/
	0x0F128818,    /* 7000299A*/
	0x0F12F000,    /* 7000299C*/
	0x0F12F918,    /* 7000299E*/
	0x0F120005,    /* 700029A0*/
	0x0F12466B,    /* 700029A2*/
	0x0F128858,    /* 700029A4*/
	0x0F12F000,    /* 700029A6*/
	0x0F12F91B,    /* 700029A8*/
	0x0F120004,    /* 700029AA*/
	0x0F122101,    /* 700029AC*/
	0x0F121928,    /* 700029AE*/
	0x0F1202C9,    /* 700029B0*/
	0x0F121A08,    /* 700029B2*/
	0x0F120286,    /* 700029B4*/
	0x0F120029,    /* 700029B6*/
	0x0F120030,    /* 700029B8*/
	0x0F12F000,    /* 700029BA*/
	0x0F12F941,    /* 700029BC*/
	0x0F120005,    /* 700029BE*/
	0x0F122701,    /* 700029C0*/
	0x0F1202BF,    /* 700029C2*/
	0x0F120021,    /* 700029C4*/
	0x0F120030,    /* 700029C6*/
	0x0F12F000,    /* 700029C8*/
	0x0F12F93A,    /* 700029CA*/
	0x0F124964,    /* 700029CC*/
	0x0F124A61,    /* 700029CE*/
	0x0F123140,    /* 700029D0*/
	0x0F1232A0,    /* 700029D2*/
	0x0F12800D,    /* 700029D4*/
	0x0F128395,    /* 700029D6*/
	0x0F12804F,    /* 700029D8*/
	0x0F1283D7,    /* 700029DA*/
	0x0F128088,    /* 700029DC*/
	0x0F120011,    /* 700029DE*/
	0x0F123120,    /* 700029E0*/
	0x0F128008,    /* 700029E2*/
	0x0F12E773,    /* 700029E4*/
	0x0F12B510,    /* 700029E6*/
	0x0F12485C,    /* 700029E8*/
	0x0F128980,    /* 700029EA*/
	0x0F122800,    /* 700029EC*/
	0x0F12D001,    /* 700029EE*/
	0x0F12F000,    /* 700029F0*/
	0x0F12F92C,    /* 700029F2*/
	0x0F12E734,    /* 700029F4*/
	0x0F12B5FE,    /* 700029F6*/
	0x0F122600,    /* 700029F8*/
	0x0F12495B,    /* 700029FA*/
	0x0F122000,    /* 700029FC*/
	0x0F126108,    /* 700029FE*/
	0x0F1260C8,    /* 70002A00*/
	0x0F12485A,    /* 70002A02*/
	0x0F128901,    /* 70002A04*/
	0x0F124852,    /* 70002A06*/
	0x0F123020,    /* 70002A08*/
	0x0F1288C0,    /* 70002A0A*/
	0x0F129000,    /* 70002A0C*/
	0x0F120840,    /* 70002A0E*/
	0x0F129002,    /* 70002A10*/
	0x0F124856,    /* 70002A12*/
	0x0F128800,    /* 70002A14*/
	0x0F129001,    /* 70002A16*/
	0x0F124853,    /* 70002A18*/
	0x0F123040,    /* 70002A1A*/
	0x0F128B05,    /* 70002A1C*/
	0x0F122900,    /* 70002A1E*/
	0x0F12D01F,    /* 70002A20*/
	0x0F124E52,    /* 70002A22*/
	0x0F122700,    /* 70002A24*/
	0x0F1280F7,    /* 70002A26*/
	0x0F122400,    /* 70002A28*/
	0x0F12E016,    /* 70002A2A*/
	0x0F12494E,    /* 70002A2C*/
	0x0F120060,    /* 70002A2E*/
	0x0F1239C0,    /* 70002A30*/
	0x0F121841,    /* 70002A32*/
	0x0F122020,    /* 70002A34*/
	0x0F125E08,    /* 70002A36*/
	0x0F129902,    /* 70002A38*/
	0x0F121840,    /* 70002A3A*/
	0x0F129900,    /* 70002A3C*/
	0x0F12F000,    /* 70002A3E*/
	0x0F12F8FF,    /* 70002A40*/
	0x0F124B4A,    /* 70002A42*/
	0x0F120202,    /* 70002A44*/
	0x0F1200A1,    /* 70002A46*/
	0x0F12330C,    /* 70002A48*/
	0x0F12505A,    /* 70002A4A*/
	0x0F120002,    /* 70002A4C*/
	0x0F124342,    /* 70002A4E*/
	0x0F120210,    /* 70002A50*/
	0x0F121DDA,    /* 70002A52*/
	0x0F1232F9,    /* 70002A54*/
	0x0F125050,    /* 70002A56*/
	0x0F121C64,    /* 70002A58*/
	0x0F1242A5,    /* 70002A5A*/
	0x0F12DCE6,    /* 70002A5C*/
	0x0F128137,    /* 70002A5E*/
	0x0F12E042,    /* 70002A60*/
	0x0F122400,    /* 70002A62*/
	0x0F12E031,    /* 70002A64*/
	0x0F124940,    /* 70002A66*/
	0x0F120060,    /* 70002A68*/
	0x0F1239C0,    /* 70002A6A*/
	0x0F121841,    /* 70002A6C*/
	0x0F122020,    /* 70002A6E*/
	0x0F125E08,    /* 70002A70*/
	0x0F129902,    /* 70002A72*/
	0x0F121840,    /* 70002A74*/
	0x0F129900,    /* 70002A76*/
	0x0F12F000,    /* 70002A78*/
	0x0F12F8E2,    /* 70002A7A*/
	0x0F124A3B,    /* 70002A7C*/
	0x0F1200A1,    /* 70002A7E*/
	0x0F12320C,    /* 70002A80*/
	0x0F125853,    /* 70002A82*/
	0x0F123A0C,    /* 70002A84*/
	0x0F128852,    /* 70002A86*/
	0x0F124353,    /* 70002A88*/
	0x0F123380,    /* 70002A8A*/
	0x0F120A1F,    /* 70002A8C*/
	0x0F1223FF,    /* 70002A8E*/
	0x0F121C5B,    /* 70002A90*/
	0x0F121A9B,    /* 70002A92*/
	0x0F12469C,    /* 70002A94*/
	0x0F124343,    /* 70002A96*/
	0x0F1218FF,    /* 70002A98*/
	0x0F124B34,    /* 70002A9A*/
	0x0F12330C,    /* 70002A9C*/
	0x0F12505F,    /* 70002A9E*/
	0x0F120003,    /* 70002AA0*/
	0x0F124343,    /* 70002AA2*/
	0x0F124660,    /* 70002AA4*/
	0x0F124343,    /* 70002AA6*/
	0x0F124831,    /* 70002AA8*/
	0x0F125840,    /* 70002AAA*/
	0x0F124350,    /* 70002AAC*/
	0x0F123080,    /* 70002AAE*/
	0x0F124A2F,    /* 70002AB0*/
	0x0F120A00,    /* 70002AB2*/
	0x0F121818,    /* 70002AB4*/
	0x0F125050,    /* 70002AB6*/
	0x0F120039,    /* 70002AB8*/
	0x0F124379,    /* 70002ABA*/
	0x0F123180,    /* 70002ABC*/
	0x0F120A09,    /* 70002ABE*/
	0x0F124281,    /* 70002AC0*/
	0x0F12D201,    /* 70002AC2*/
	0x0F121A40,    /* 70002AC4*/
	0x0F121986,    /* 70002AC6*/
	0x0F121C64,    /* 70002AC8*/
	0x0F1242A5,    /* 70002ACA*/
	0x0F12DCCB,    /* 70002ACC*/
	0x0F120868,    /* 70002ACE*/
	0x0F121980,    /* 70002AD0*/
	0x0F120029,    /* 70002AD2*/
	0x0F12F000,    /* 70002AD4*/
	0x0F12F8B4,    /* 70002AD6*/
	0x0F123008,    /* 70002AD8*/
	0x0F120900,    /* 70002ADA*/
	0x0F129A01,    /* 70002ADC*/
	0x0F124923,    /* 70002ADE*/
	0x0F124290,    /* 70002AE0*/
	0x0F12D901,    /* 70002AE2*/
	0x0F128888,    /* 70002AE4*/
	0x0F1280C8,    /* 70002AE6*/
	0x0F124920,    /* 70002AE8*/
	0x0F1288C8,    /* 70002AEA*/
	0x0F122800,    /* 70002AEC*/
	0x0F12D001,    /* 70002AEE*/
	0x0F121E40,    /* 70002AF0*/
	0x0F1280C8,    /* 70002AF2*/
	0x0F129801,    /* 70002AF4*/
	0x0F122800,    /* 70002AF6*/
	0x0F12D00D,    /* 70002AF8*/
	0x0F124A1B,    /* 70002AFA*/
	0x0F123AC0,    /* 70002AFC*/
	0x0F127B90,    /* 70002AFE*/
	0x0F122802,    /* 70002B00*/
	0x0F12D001,    /* 70002B02*/
	0x0F122803,    /* 70002B04*/
	0x0F12D106,    /* 70002B06*/
	0x0F1288C9,    /* 70002B08*/
	0x0F122900,    /* 70002B0A*/
	0x0F12D003,    /* 70002B0C*/
	0x0F122100,    /* 70002B0E*/
	0x0F120040,    /* 70002B10*/
	0x0F121880,    /* 70002B12*/
	0x0F128081,    /* 70002B14*/
	0x0F12BCFE,    /* 70002B16*/
	0x0F12BC08,    /* 70002B18*/
	0x0F124718,    /* 70002B1A*/
	0x0F12B510,    /* 70002B1C*/
	0x0F126800,    /* 70002B1E*/
	0x0F12F000,    /* 70002B20*/
	0x0F12F89C,    /* 70002B22*/
	0x0F124911,    /* 70002B24*/
	0x0F122001,    /* 70002B26*/
	0x0F128108,    /* 70002B28*/
	0x0F12E699,    /* 70002B2A*/
	0x0F12B510,    /* 70002B2C*/
	0x0F12F000,    /* 70002B2E*/
	0x0F12F89D,    /* 70002B30*/
	0x0F12F7FF,    /* 70002B32*/
	0x0F12FF60,    /* 70002B34*/
	0x0F12E693,    /* 70002B36*/
	0x0F124140,    /* 70002B38*/
	0x0F12D000,    /* 70002B3A*/
	0x0F1219DC,    /* 70002B3C*/
	0x0F127000,    /* 70002B3E*/
	0x0F121B60,    /* 70002B40*/
	0x0F127000,    /* 70002B42*/
	0x0F120DD4,    /* 70002B44*/
	0x0F127000,    /* 70002B46*/
	0x0F1222AC,    /* 70002B48*/
	0x0F127000,    /* 70002B4A*/
	0x0F120F88,    /* 70002B4C*/
	0x0F127000,    /* 70002B4E*/
	0x0F121E8C,    /* 70002B50*/
	0x0F127000,    /* 70002B52*/
	0x0F12214C,    /* 70002B54*/
	0x0F127000,    /* 70002B56*/
	0x0F121A10,    /* 70002B58*/
	0x0F127000,    /* 70002B5A*/
	0x0F123780,    /* 70002B5C*/
	0x0F127000,    /* 70002B5E*/
	0x0F122384,    /* 70002B60*/
	0x0F127000,    /* 70002B62*/
	0x0F12065C,    /* 70002B64*/
	0x0F127000,    /* 70002B66*/
	0x0F121C8C,    /* 70002B68*/
	0x0F127000,    /* 70002B6A*/
	0x0F122C7C,    /* 70002B6C*/
	0x0F127000,    /* 70002B6E*/
	0x0F122D88,    /* 70002B70*/
	0x0F127000,    /* 70002B72*/
	0x0F124778,    /* 70002B74*/
	0x0F1246C0,    /* 70002B76*/
	0x0F12C000,    /* 70002B78*/
	0x0F12E59F,    /* 70002B7A*/
	0x0F12FF1C,    /* 70002B7C*/
	0x0F12E12F,    /* 70002B7E*/
	0x0F12CE77,    /* 70002B80*/
	0x0F120000,    /* 70002B82*/
	0x0F124778,    /* 70002B84*/
	0x0F1246C0,    /* 70002B86*/
	0x0F12C000,    /* 70002B88*/
	0x0F12E59F,    /* 70002B8A*/
	0x0F12FF1C,    /* 70002B8C*/
	0x0F12E12F,    /* 70002B8E*/
	0x0F123609,    /* 70002B90*/
	0x0F120000,    /* 70002B92*/
	0x0F124778,    /* 70002B94*/
	0x0F1246C0,    /* 70002B96*/
	0x0F12C000,    /* 70002B98*/
	0x0F12E59F,    /* 70002B9A*/
	0x0F12FF1C,    /* 70002B9C*/
	0x0F12E12F,    /* 70002B9E*/
	0x0F129F91,    /* 70002BA0*/
	0x0F120000,    /* 70002BA2*/
	0x0F124778,    /* 70002BA4*/
	0x0F1246C0,    /* 70002BA6*/
	0x0F12C000,    /* 70002BA8*/
	0x0F12E59F,    /* 70002BAA*/
	0x0F12FF1C,    /* 70002BAC*/
	0x0F12E12F,    /* 70002BAE*/
	0x0F122AE3,    /* 70002BB0*/
	0x0F120000,    /* 70002BB2*/
	0x0F124778,    /* 70002BB4*/
	0x0F1246C0,    /* 70002BB6*/
	0x0F12F004,    /* 70002BB8*/
	0x0F12E51F,    /* 70002BBA*/
	0x0F12D1DC,    /* 70002BBC*/
	0x0F120000,    /* 70002BBE*/
	0x0F124778,    /* 70002BC0*/
	0x0F1246C0,    /* 70002BC2*/
	0x0F12C000,    /* 70002BC4*/
	0x0F12E59F,    /* 70002BC6*/
	0x0F12FF1C,    /* 70002BC8*/
	0x0F12E12F,    /* 70002BCA*/
	0x0F126869,    /* 70002BCC*/
	0x0F120000,    /* 70002BCE*/
	0x0F124778,    /* 70002BD0*/
	0x0F1246C0,    /* 70002BD2*/
	0x0F12C000,    /* 70002BD4*/
	0x0F12E59F,    /* 70002BD6*/
	0x0F12FF1C,    /* 70002BD8*/
	0x0F12E12F,    /* 70002BDA*/
	0x0F1268BD,    /* 70002BDC*/
	0x0F120000,    /* 70002BDE*/
	0x0F124778,    /* 70002BE0*/
	0x0F1246C0,    /* 70002BE2*/
	0x0F12C000,    /* 70002BE4*/
	0x0F12E59F,    /* 70002BE6*/
	0x0F12FF1C,    /* 70002BE8*/
	0x0F12E12F,    /* 70002BEA*/
	0x0F1268DB,    /* 70002BEC*/
	0x0F120000,    /* 70002BEE*/
	0x0F124778,    /* 70002BF0*/
	0x0F1246C0,    /* 70002BF2*/
	0x0F12C000,    /* 70002BF4*/
	0x0F12E59F,    /* 70002BF6*/
	0x0F12FF1C,    /* 70002BF8*/
	0x0F12E12F,    /* 70002BFA*/
	0x0F121BC9,    /* 70002BFC*/
	0x0F120000,    /* 70002BFE*/
	0x0F124778,    /* 70002C00*/
	0x0F1246C0,    /* 70002C02*/
	0x0F12C000,    /* 70002C04*/
	0x0F12E59F,    /* 70002C06*/
	0x0F12FF1C,    /* 70002C08*/
	0x0F12E12F,    /* 70002C0A*/
	0x0F1271B9,    /* 70002C0C*/
	0x0F120000,    /* 70002C0E*/
	0x0F124778,    /* 70002C10*/
	0x0F1246C0,    /* 70002C12*/
	0x0F12C000,    /* 70002C14*/
	0x0F12E59F,    /* 70002C16*/
	0x0F12FF1C,    /* 70002C18*/
	0x0F12E12F,    /* 70002C1A*/
	0x0F127249,    /* 70002C1C*/
	0x0F120000,    /* 70002C1E*/
	0x0F124778,    /* 70002C20*/
	0x0F1246C0,    /* 70002C22*/
	0x0F12C000,    /* 70002C24*/
	0x0F12E59F,    /* 70002C26*/
	0x0F12FF1C,    /* 70002C28*/
	0x0F12E12F,    /* 70002C2A*/
	0x0F1298CD,    /* 70002C2C*/
	0x0F120000,    /* 70002C2E*/
	0x0F124778,    /* 70002C30*/
	0x0F1246C0,    /* 70002C32*/
	0x0F12C000,    /* 70002C34*/
	0x0F12E59F,    /* 70002C36*/
	0x0F12FF1C,    /* 70002C38*/
	0x0F12E12F,    /* 70002C3A*/
	0x0F12987F,    /* 70002C3C*/
	0x0F120000,    /* 70002C3E*/
	0x0F124778,    /* 70002C40*/
	0x0F1246C0,    /* 70002C42*/
	0x0F12F004,    /* 70002C44*/
	0x0F12E51F,    /* 70002C46*/
	0x0F12D378,    /* 70002C48*/
	0x0F120000,    /* 70002C4A*/
	0x0F124778,    /* 70002C4C*/
	0x0F1246C0,    /* 70002C4E*/
	0x0F12C000,    /* 70002C50*/
	0x0F12E59F,    /* 70002C52*/
	0x0F12FF1C,    /* 70002C54*/
	0x0F12E12F,    /* 70002C56*/
	0x0F1204CB,    /* 70002C58*/
	0x0F120000,    /* 70002C5A*/
	0x0F124778,    /* 70002C5C*/
	0x0F1246C0,    /* 70002C5E*/
	0x0F12C000,    /* 70002C60*/
	0x0F12E59F,    /* 70002C62*/
	0x0F12FF1C,    /* 70002C64*/
	0x0F12E12F,    /* 70002C66*/
	0x0F1250AF,    /* 70002C68*/
	0x0F120000,    /* 70002C6A*/
	0x0F124778,    /* 70002C6C*/
	0x0F1246C0,    /* 70002C6E*/
	0x0F12C000,    /* 70002C70*/
	0x0F12E59F,    /* 70002C72*/
	0x0F12FF1C,    /* 70002C74*/
	0x0F12E12F,    /* 70002C76*/
	0x0F125623,    /* 70002C78*/
	0x0F120000,    /* 70002C7A*/
	0x0028D000,
	0x002A1000,
	0x0F120001,
	0x00287000,
	0x002A00F4,
	0x0F125DC0,	/*REG_TC_IPRM_InClockLSBs*/
	0x0F120000,	/*REG_TC_IPRM_InClockMSBs   5DC0h=24000d=24Mhz*/
	0x002A0110,
	0x0F120002,	/*REG_TC_IPRM_UseNPviClocks*/
	0x0F120000,	/*REG_TC_IPRM_bBlockInternalPllCalc*/
	0x0F12222E,	/*REG_TC_IPRM_OpClk4KHz_0   222Eh=8750d*4=35000d=35Mhz*/
	0x0F12445C,	/*REG_TC_IPRM_MinOutRate4KHz_0
			445CEh=8750d*4=35000d=35Mhz*/
	0x0F12445C,	/*REG_TC_IPRM_MaxOutRate4KHz_0
			445Ch=8750d*4=35000d=35Mhz*/
	0x0F12222E,	/*REG_TC_IPRM_OpClk4KHz_1*/
	0x0F12222E,	/*REG_TC_IPRM_MinOutRate4KHz_1*/
	0x0F12222E,	/*REG_TC_IPRM_MaxOutRate4KHz_1*/
	0x002A0126,
	0x0F120001,	/*REG_TC_IPRM_InitParamsUpdated*/
	/*0x002A0144,*/
	/*0x0F120640,*/	/*REG_TC_GP_PrevReqInputWidth 640h=1600d*/
	/*0x0F1204B0,*/	/*REG_TC_GP_PrevReqInputHeight 4b0h=1200d*/
	/*0x0F120000,*/	/*REG_TC_GP_PrevInputWidthOfs*/
	/*0x0F120000,*/	/*REG_TC_GP_PrevInputHeightOfs*/
	/*0x0F120640,*/	/*REG_TC_GP_CapReqInputWidth  640h=1600d*/
	/*0x0F1204B0,*/	/*REG_TC_GP_CapReqInputHeight 4b0h=1200d*/
	/*0x0F120000,*/	/*REG_TC_GP_CapInputWidthOfs*/
	/*0x0F120000,*/	/*REG_TC_GP_CapInputHeightOfs*/
	/*0x002A0164,*/
	/*0x0F120001,*/	/*REG_TC_GP_bUseReqInputInPre*/
	/*0x0F120001,*/	/*REG_TC_GP_bUseReqInputInCap*/
	/*0x002A0310,*/
	/*0x0F120640,*/	/*REG_TC_PZOOM_ZoomInputWidth	 640h=1600d*/
	/*0x0F1204b0,*/	/*REG_TC_PZOOM_ZoomInputHeight	 4b0h=1200d*/
	/*0x0F120000,*/	/*REG_TC_PZOOM_ZoomInputWidthOfs*/
	/*0x0F120000,*/	/*REG_TC_PZOOM_ZoomInputHeightOfs*/
	0x002A0170,
	0x0F120280,	/*0500	0320	REG_0TC_PCFG_usWidth*/
	0x0F1201E0,	/*03C0	0258	REG_0TC_PCFG_usHeight*/
	0x0F120005,	/*0005	0005	REG_0TC_PCFG_Format 0	RGB565;
			1 RGB888; 5 Full YUV422; 6 Reduced YUV422; 7 Bayer*/
	0x0F12222E,	/*445C	222E	REG_0TC_PCFG_usMaxOut4KHzRate*/
	0x0F12222E,	/*445C	222E	REG_0TC_PCFG_usMinOut4KHzRate*/
	0x0F120042,	/*0042	0042	REG_0TC_PCFG_PVIMask*/
	0x0F120010,	/*0010	0010	REG_0TC_PCFG_OIFMask*/
	0x0F120001,	/*0000	0001	REG_0TC_PCFG_uClockInd*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_usFrTimeType 0: dynamic 1:
			fix not accurate 2: fixed_Accurate*/
	0x0F120001,	/*0000	0001	REG_0TC_PCFG_FrRateQualityType 1b: FR
			(bin) 2b: Quality (no-bin)*/
	0x0F120535,	/*0535	0535	REG_0TC_PCFG_uSMaxFrTimeMSecMult10 max
			frame time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F1202bb,	/*029A	029A	REG_0TC_PCFG_uSMinFrTimeMSecMult10
			max frame	time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_bSmearOutput*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_SSaturation*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_SSharpBlur*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_SColorTemp*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_uDeviceGammaIndex 1:Mirror
			(X) 2:Mirror(Y) 4:STAT	Mirror(X) 8:STAT Mirror(Y)*/
	0x0F120003,	/*0000	0001	REG_0TC_PCFG_uPrevMirror*/
	0x0F120003,	/*0000	0001	REG_0TC_PCFG_uCaptureMirror*/
	0x0F120000,	/*0000	0000	REG_0TC_PCFG_uRotation*/
	0x002A0198,
	0x0F120280,	/*0280	REG_1TC_PCFG_uSWidth		2   70000198
			640*/
	0x0F1201E0,	/*01E0	REG_1TC_PCFG_uSHeight		2   7000019A
			480*/
	0x0F120005,	/*0005	REG_1TC_PCFG_Format		2   7000019C
			0 RGB565; 1 RGB888; 5	Full YUV422; 6 Reduced YUV422;
			7 Bayer*/
	0x0F12222E,	/*222E	REG_1TC_PCFG_uSMaxOut4KHzRate	2   7000019E*/
	0x0F12222E,	/*222E	REG_1TC_PCFG_uSMinOut4KHzRate	2   700001A0*/
	0x0F120042,	/*0042	REG_1TC_PCFG_PVIMaSk		2   700001A2*/
	0x0F120010,	/*0010	REG_1TC_PCFG_OIFMaSk		2   700001A4*/
	0x0F120001,	/*0001	REG_1TC_PCFG_uClockInd		2   700001A6*/
	0x0F120002,	/*0000	REG_1TC_PCFG_uSFrTimeType	2   700001A8
			0: dynamic 1:fix not accurate 2: fixed_Accurate*/
	0x0F120001,	/*0001	REG_1TC_PCFG_FrRateQualityType	2  700001AA*/
	0x0F12014D,	/*01A0	REG_1TC_PCFG_uSMaxFrTimeMSecMult10 2   700001AC
			max frame	time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F12014D,	/*014D	REG_1TC_PCFG_uSMinFrTimeMSecMult10 2   700001AE
			max frame	time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F120000,	/*0000	REG_1TC_PCFG_bSmearOutput	2   700001B0*/
	0x0F120000,	/*0000	REG_1TC_PCFG_SSaturation	2   700001B2*/
	0x0F120000,	/*0000	REG_1TC_PCFG_SSharpBlur		2   700001B4*/
	0x0F120000,	/*0000	REG_1TC_PCFG_SColorTemp		2   700001B6*/
	0x0F120000,	/*0000	REG_1TC_PCFG_uDeviceGammaIndex	2   700001B8*/
	0x0F120003,	/*0000	REG_1TC_PCFG_uPrevMirror	2   700001BA*/
	0x0F120003,	/*0000	REG_1TC_PCFG_uCaptureMirror	2   700001BC*/
	0x0F120000, /*0000	REG_1TC_PCFG_uRotation		2   700001BE*/
	0x002A01C0,
	0x0F120280,	/*0320	REG_2TC_PCFG_uSWidth*/
	0x0F1201e0,	/*0258	REG_2TC_PCFG_uSHeight*/
	0x0F120005,	/*REG_2TC_PCFG_Format*/
	0x0F12222E,	/*REG_2TC_PCFG_uSMaxOut4KHzRate*/
	0x0F12222E,	/*REG_2TC_PCFG_uSMinOut4KHzRate*/
	0x0F120042,	/*REG_2TC_PCFG_PVIMaSk*/
	0x0F120010,	/*REG_2TC_PCFG_OIFMaSk*/
	0x0F120001,	/*REG_2TC_PCFG_uClockInd*/
	0x0F120000,	/*REG_2TC_PCFG_uSFrTimeType*/
	0x0F120001,	/*REG_2TC_PCFG_FrRateQualityType 1b: FR	(bin) 2b:
			Quality (no-bin)*/
	0x0F1207D0,	/*REG_2TC_PCFG_uSMaxFrTimeMSecMult10max	frame time :
			30fpS 014D; 15fpS 029a; a6a - 3.75 fpS; 0535 - 7.5FPS*/
	0x0F12029A,	/*REG_2TC_PCFG_uSMinFrTimeMSecMult10	2   700001D6*/
	0x0F120000, /*REG_2TC_PCFG_bSmearOutput			2   700001D8*/
	0x0F120000,	/*REG_2TC_PCFG_SSaturation		2   700001DA*/
	0x0F120000,	/*REG_2TC_PCFG_SSharpBlur		2   700001DC*/
	0x0F120000,	/*REG_2TC_PCFG_SColorTemp		2   700001DE*/
	0x0F120000, /*REG_2TC_PCFG_uDeviceGammaIndex		2   700001E0*/
	0x0F120003,	/*REG_2TC_PCFG_uPrevMirror		2   700001E2
			[0] : x [1]: Y [2] Stat X	[3] Stat Y*/
	0x0F120003,	/*REG_2TC_PCFG_uCaptureMirror		2   700001E4*/
	0x0F120000, /*REG_2TC_PCFG_uRotation			2   700001E6*/
	0x002A01E8,
	0x0F120280,	/*0320		REG_3TC_PCFG_uSWidth	2   700001E8*/
	0x0F1201e0,	/*0258		REG_3TC_PCFG_uSHeight	2   700001EA*/
	0x0F120005,	/*REG_3TC_PCFG_Format			2   700001EC*/
	0x0F12222E,	/*REG_3TC_PCFG_uSMaxOut4KHzRate		2   700001EE*/
	0x0F12222E,	/*REG_3TC_PCFG_uSMinOut4KHzRate		2   700001F0*/
	0x0F120042,	/*REG_3TC_PCFG_PVIMaSk			2   700001F2*/
	0x0F120010,	/*REG_3TC_PCFG_OIFMaSk			2   700001F4*/
	0x0F120001,	/*REG_3TC_PCFG_uClockInd		2   700001F6*/
	0x0F120002,	/*REG_3TC_PCFG_uSFrTimeType		2   700001F8
			0: dynamic 1:fix not accurate 2: fixed_Accurate*/
	0x0F120001,	/*REG_3TC_PCFG_FrRateQualityType	2   700001FA*/
	0x0F120190,	/*REG_3TC_PCFG_uSMaxFrTimeMSecMult10	2   700001FC
			max frame time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F120000,	/*REG_3TC_PCFG_uSMinFrTimeMSecMult10	2   700001FE
			max frame time : 30fpS:014D 15fpS:029a 7.5fpS:0535
			3.75fpS:a6a*/
	0x0F120000,	/*REG_3TC_PCFG_bSmearOutput		2   70000200*/
	0x0F120000,	/*REG_3TC_PCFG_SSaturation		2   70000202*/
	0x0F120000,	/*REG_3TC_PCFG_SSharpBlur		2   70000204*/
	0x0F120000,	/*REG_3TC_PCFG_SColorTemp		2   70000206*/
	0x0F120000,	/*REG_3TC_PCFG_uDeviceGammaIndex	2   70000208*/
	0x0F120003,	/*REG_3TC_PCFG_uPrevMirror		2   7000020A*/
	0x0F120003,	/*REG_3TC_PCFG_uCaptureMirror		2   7000020C*/
	0x0F120000,	/*REG_3TC_PCFG_uRotation		2   7000020E*/
	0x002A0238,
	0x0F120001, /*REG_0TC_CCFG_uCaptureMode			2    70000238*/
	0x0F120640,	/*REG_0TC_CCFG_uSWidth			2   7000023A*/
	0x0F1204B0,	/*REG_0TC_CCFG_uSHeight			2   7000023C*/
	0x0F120005, /*REG_0TC_CCFG_Format			2    7000023E*/
	0x0F12222E,	/*REG_0TC_CCFG_uSMaxOut4KHzRate		2   70000240*/
	0x0F12222E,	/*REG_0TC_CCFG_uSMinOut4KHzRate		2   70000242*/
	0x0F120042,	/*REG_0TC_CCFG_PVIMaSk			2   70000244*/
	0x0F120000,	/*REG_0TC_CCFG_OIFMaSk			2   70000246*/
	0x0F120001, /*REG_0TC_CCFG_uClockInd			2    70000248*/
	0x0F120002,	/*REG_0TC_CCFG_uSFrTimeType		2   7000024A*/
	0x0F120002, /*REG_0TC_CCFG_FrRateQualityType		2   7000024C*/
	0x0F120514,	/*0535	REG_0TC_CCFG_uSMaxFrTimeMSecMult10 2  7000024E*/
	0x0F120514,	/*0535	REG_0TC_CCFG_uSMinFrTimeMSecMult10 2  70000250*/
	0x0F120000, /*REG_0TC_CCFG_bSmearOutput			2   70000252*/
	0x0F120000,	/*REG_0TC_CCFG_SSaturation		2   70000254*/
	0x0F120000,	/*REG_0TC_CCFG_SSharpBlur		2   70000256*/
	0x0F120000,	/*REG_0TC_CCFG_SColorTemp		2   70000258*/
	0x0F120000, /*REG_0TC_CCFG_uDeviceGammaIndex		2   7000025A*/
	0x0F120001, /*REG_1TC_CCFG_uCaptureMode			2   7000025C*/
	0x0F120640,	/*REG_1TC_CCFG_uSWidth			2   7000025E*/
	0x0F1204B0,	/*REG_1TC_CCFG_uSHeight			2   70000260*/
	0x0F120005, /*REG_1TC_CCFG_Format			2   70000262*/
	0x0F12445C,	/*222E	REG_1TC_CCFG_uSMaxOut4KHzRate	2   70000264*/
	0x0F12445C,	/*222E	REG_1TC_CCFG_uSMinOut4KHzRate	2   70000266*/
	0x0F120042,	/*REG_1TC_CCFG_PVIMaSk			2   70000268*/
	0x0F120010,	/*0000	REG_1TC_CCFG_OIFMaSk		2   7000026A*/
	0x0F120000,/*0001	REG_1TC_CCFG_uClockInd		2   7000026C*/
	0x0F120000,	/*REG_1TC_CCFG_uSFrTimeType		2   7000026E*/
	0x0F120002, /*REG_1TC_CCFG_FrRateQualityType		2   70000270*/
	0x0F121388,	/*REG_1TC_CCFG_uSMaxFrTimeMSecMult10	2   70000272*/
	0x0F121388,	/*REG_1TC_CCFG_uSMinFrTimeMSecMult10	2   70000274*/
	0x0F120000, /*REG_1TC_CCFG_bSmearOutput			2   70000276*/
	0x0F120000,	/*REG_1TC_CCFG_SSaturation		2   70000278*/
	0x0F120000,	/*REG_1TC_CCFG_SSharpBlur		2   7000027A*/
	0x0F120000,	/*REG_1TC_CCFG_SColorTemp		2   7000027C*/
	0x0F120000, /*REG_1TC_CCFG_uDeviceGammaIndex		2   7000027E*/
	0x002A1218,
	0x0F120002,		/*SenHal_SenBinFactor*/
	0xFFFF0064,
	0x00287000,
	0x002A0CC0,
	0x0F120001,	/*AFC_Default BIT[0]  1:60Hz 0:50Hz*/
	0x002A0374,
	0x0F12067F,	/*REG_TC_DBG BIT[5] : Auto Flicker Disable*/

	/*Int Time limit*/
	0x00287000,
	0x002A1220,
	0x0F1201B7, /*senHal_ExpMinPixels*/

	0x002A10C0,
	0x0F120040,	/*TVAR_ae_BrAve*/
	0x002A10C6,
	0x0F12000F,	/*ae_StatMode*/
	0x002A03B2,
	0x0F12010E,	/*lt_uLimitHigh*/
	0x0F1200F5,	/*lt_uLimitLow*/
	0x002A03C4,
	0x0F123415,	/*lt_uMaxExp1 3415h=13333d/400d=33.3325ms*/
	0x002A03C8,
	0x0F12681F,	/*lt_uMaxExp2 681Fh=26655d/400d=66.6375ms*/
	0x002A03CC,
	0x0F128227,	/*lt_uMaxExp3 8227h=33319d/400d=83.2975ms*/
	0x002A03D0,
	0x0F120D40,	/*lt_uMaxExp4 30D40h=50000d/400d=500ms*/
	0x0F120003,
	0x002A03D4,
	0x0F123415,	/*lt_uCapMaxExp1 3415h=13333d/400d=33.3325ms*/
	0x002A03D8,
	0x0F12681F,	/*lt_uCapMaxExp2 681Fh=26655d/400d=66.6375ms*/
	0x002A03DC,
	0x0F128227,	/*lt_uCapMaxExp3 8227h=33319d/400d=83.2975ms*/
	0x002A03E0,
	0x0F120D40,	/*lt_uCapMaxExp4 30D40h=50000d/400d=500ms*/
	0x0F120003,
	0x002A03E4,
	0x0F120230,	/*lt_uMaxAnGain1 0230h=0560d/256d=x2.1875*/
	0x0F120260,	/*lt_uMaxAnGain2 0260h=0608d/256d=x2.375*/
	0x0F120370,	/*lt_uMaxAnGain3 0370h=0704d/256d=x3.4375*/
	0x0F120880,	/*lt_uMaxAnGain4 0710h=2176d/256d=x8.5*/
	0x0F120100,	/*lt_uMaxDigGain*/
	0x0F128000,	/*lt_uMaxTotGain*/
	0x0F120230,	/*lt_uCapMaxAnGain1 0230h=0560d/256d=x2.1875*/
	0x0F120260,	/*lt_uCapMaxAnGain2 0260h=0608d/256d=x2.375*/
	0x0F120380,	/*lt_uCapMaxAnGain3 0370h=0704d/256d=x3.4375*/
	0x0F120880,	/*lt_uCapMaxAnGain4 0710h=2176d/256d=x8.5*/
	0x0F120100,	/*lt_uCapMaxDigGain*/
	0x0F128000,	/*lt_uCapMaxTotGain*/
	0x002A10CE,
	0x0F120000,	/*ae_WeightTbl_16[0]*/
	0x0F120101,	/*ae_WeightTbl_16[1]*/
	0x0F120101,	/*ae_WeightTbl_16[2]*/
	0x0F120000,	/*ae_WeightTbl_16[3]*/
	0x0F120101,	/*ae_WeightTbl_16[4]*/
	0x0F120101,	/*ae_WeightTbl_16[5]*/
	0x0F120101,	/*ae_WeightTbl_16[6]*/
	0x0F120101,	/*ae_WeightTbl_16[7]*/
	0x0F120201,	/*ae_WeightTbl_16[8]*/
	0x0F120303,	/*ae_WeightTbl_16[9]*/
	0x0F120303,	/*ae_WeightTbl_16[10]*/
	0x0F120102,	/*ae_WeightTbl_16[11]*/
	0x0F120201,	/*ae_WeightTbl_16[12]*/
	0x0F120403,	/*ae_WeightTbl_16[13]*/
	0x0F120304,	/*ae_WeightTbl_16[14]*/
	0x0F120102,	/*ae_WeightTbl_16[15]*/
	0x0F120201,	/*ae_WeightTbl_16[16]*/
	0x0F120403,	/*ae_WeightTbl_16[17]*/
	0x0F120304,	/*ae_WeightTbl_16[18]*/
	0x0F120102,	/*ae_WeightTbl_16[19]*/
	0x0F120201,	/*ae_WeightTbl_16[20]*/
	0x0F120403,	/*ae_WeightTbl_16[21]*/
	0x0F120304,	/*ae_WeightTbl_16[22]*/
	0x0F120102,	/*ae_WeightTbl_16[23]*/
	0x0F120201,	/*ae_WeightTbl_16[24]*/
	0x0F120303,	/*ae_WeightTbl_16[25]*/
	0x0F120303,	/*ae_WeightTbl_16[26]*/
	0x0F120102,	/*ae_WeightTbl_16[27]*/
	0x0F120201,	/*ae_WeightTbl_16[28]*/
	0x0F120202,	/*ae_WeightTbl_16[29]*/
	0x0F120202,	/*ae_WeightTbl_16[30]*/
	0x0F120102,	/*ae_WeightTbl_16[31]*/
	0x002A0DCC,	/*AWB Init White Locus*/
	0x0F120138,	/*awbb_IntcR*/
	0x0F12011C,	/*awbb_IntcB*/
	0x0F1202A7,	/*awbb_GLocusR*/
	0x0F120343,	/*awbb_GLocusB*/
	0x002A0DEC,
	0x0F1205F0,	/*awbb_GamutWidthThr1*/
	0x0F1201F4,	/*awbb_GamutHeightThr1*/
	0x0F12006C,	/*awbb_GamutWidthThr2*/
	0x0F120038,	/*awbb_GamutHeightThr2*/
	0x002A0DD8,
	0x0F12000C,	/*awbb_MinNumOfFinalPatches*/
	0x002A0E50,
	0x0F12FE82,	/*awbb_SCDetectionMap_SEC_StartR_B*/
	0x0F12001E,	/*awbb_SCDetectionMap_SEC_StepR_B*/
	0x0F120640,	/*awbb_SCDetectionMap_SEC_SunnyNB*/
	0x0F120122,	/*awbb_SCDetectionMap_SEC_StepNB*/
	0x0F1200E4,	/*awbb_SCDetectionMap_SEC_LowTempR_B*/
	0x0F120096,	/*awbb_SCDetectionMap_SEC_SunnyNBZone*/
	0x0F12000E,	/*awbb_SCDetectionMap_SEC_LowTempR_BZone*/
	0x002A0DB4,	/*LowTemp Zone*/
	0x0F12036C,	/*awbb_CrclLowT_R_c*/
	0x002A0DB8,
	0x0F12011D,	/*awbb_CrclLowT_B_c*/
	0x002A0DBC,
	0x0F1262C1,	/*awbb_CrclLowT_Rad_c*/
	0x002A22BA,
	0x0F120006,	/*Mon_AWB_ByPassMode*/
	0x002A0DEA,
	0x0F120000,	/*awbb_movingscale10*/
	0x002A0F7A,
	0x0F120000,	/*awbb_RGainOff*/
	0x0F120000,	/*awbb_BGainOff*/
	0x0F120000,	/*awbb_GGainOff*/
	0x0F1200C2,	/*awbb_Alpha_Comp_Mode*/
	0x0F120002,	/*awbb_Rpl_InvalidOutDoor*/
	0x0F120001,	/*awbb_UseGrThrCorr*/
	0x0F1200E4,	/*awbb_Use_Filters*/

	0x0F12053C,	/*awbb_GainsInit[0]*/
	0x0F120400,	/*awbb_GainsInit[1]*/
	0x0F1207ac,	/*7AC,	55C, *awbb_GainsInit[2]*/

	0x0F12001E,	/*awbb_WpFilterMinThr*/
	0x0F120190,	/*awbb_WpFilterMaxThr*/
	0x0F120010,	/*awbb_WpFilterCoef*/
	0x0F120004,	/*awbb_WpFilterSize*/
	0x0F120001,	/*awbb_otp_disable*/
	0x0F120002,	/*awbb_GridEnable*/
	0x002A0CE0,
	0x0F1203F8,	/*03F8	03B5	awbb_IndoorGrZones_m_BGrid[0]*/
	0x0F120422,	/*0422	03DF	awbb_IndoorGrZones_m_BGrid[1]*/
	0x0F120390,	/*03B4	032D	awbb_IndoorGrZones_m_BGrid[2]*/
	0x0F12042A,	/*0408	03D5	awbb_IndoorGrZones_m_BGrid[3]*/
	0x0F120352,	/*0370	0303	awbb_IndoorGrZones_m_BGrid[4]*/
	0x0F12041E,	/*03EE	03BB	awbb_IndoorGrZones_m_BGrid[5]*/
	0x0F120318,	/*032C	02DB	awbb_IndoorGrZones_m_BGrid[6]*/
	0x0F1203DC,	/*03FC,	03D4	0397	awbb_IndoorGrZones_m_BGrid[7]*/
	0x0F1202E4,	/*02E4,	0302	02B1	awbb_IndoorGrZones_m_BGrid[8]*/
	0x0F12039C,	/*03BA,	03BA	036B	awbb_IndoorGrZones_m_BGrid[9]*/
	0x0F1202B8,	/*02B8,	02DA	0289	awbb_IndoorGrZones_m_BGrid[10]*/
	0x0F120368,	/*037E,	0374	0349	awbb_IndoorGrZones_m_BGrid[11]*/
	0x0F120290,	/*0290,	02B0	026F	awbb_IndoorGrZones_m_BGrid[12]*/
	0x0F12033E,	/*034A,	0328	0329	awbb_IndoorGrZones_m_BGrid[13]*/
	0x0F120274,	/*0274,	0288	0257	awbb_IndoorGrZones_m_BGrid[14]*/
	0x0F120316,	/*031A,	0300	0309	awbb_IndoorGrZones_m_BGrid[15]*/
	0x0F120252,	/*0270	0241	awbb_IndoorGrZones_m_BGrid[16]*/
	0x0F1202F8,	/*02DE	02DD	awbb_IndoorGrZones_m_BGrid[17]*/
	0x0F120232,	/*0258	0227	awbb_IndoorGrZones_m_BGrid[18]*/
	0x0F1202E0,	/*02BE	02C3	awbb_IndoorGrZones_m_BGrid[19]*/
	0x0F12021E,	/*0240	0213	awbb_IndoorGrZones_m_BGrid[20]*/
	0x0F1202C8,	/*02A0	02AF	awbb_IndoorGrZones_m_BGrid[21]*/
	0x0F120206,	/*0228	0209	awbb_IndoorGrZones_m_BGrid[22]*/
	0x0F1202B2,	/*0296	0295	awbb_IndoorGrZones_m_BGrid[23]*/
	0x0F1201FA,	/*0212	020D	awbb_IndoorGrZones_m_BGrid[24]*/
	0x0F1202A2,	/*0284	0285	awbb_IndoorGrZones_m_BGrid[25]*/
	0x0F1201F4,	/*0208	0223	awbb_IndoorGrZones_m_BGrid[26]*/
	0x0F120294,	/*0274	0261	awbb_IndoorGrZones_m_BGrid[27]*/
	0x0F120200,	/*020C	0000	awbb_IndoorGrZones_m_BGrid[28]*/
	0x0F120288,	/*026E	0000	awbb_IndoorGrZones_m_BGrid[29]*/
	0x0F120214,	/*0222	0000	awbb_IndoorGrZones_m_BGrid[30]*/
	0x0F120250,	/*0260	0000	awbb_IndoorGrZones_m_BGrid[31]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[32]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[33]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[34]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[35]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[36]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[37]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[38]*/
	0x0F120000,	/*0000	0000	awbb_IndoorGrZones_m_BGrid[39]*/
	0x0F120005,	/*awbb_IndoorGrZones_m_GridStep*/
	0x002A0D34,
	0x0F120010,	/*awbb_IndoorGrZones_ZInfo_m_GridSz*/
	0x002A0D38,
	0x0F1200FE,	/*awbb_IndoorGrZones_m_Boff*/
	0x002A0D3C,
	0x0F120294,	/*0294	02A4 02B0	02B6	02B8	02A2	02B8
			029F	awbb_OutdoorGrZones_m_BGrid[0]*/
	0x0F1202F2,	/*02F2	02F2 02F0	02F2	02F2	02D4	02F2
			02CE	awbb_OutdoorGrZones_m_BGrid[1]*/
	0x0F120276,	/*0276	0276 028A	0276	028E	0282	028E
			0282	awbb_OutdoorGrZones_m_BGrid[2]*/
	0x0F12030A,	/*030A	030A 02FC	030A	030A	02EE	030A
			02DA	awbb_OutdoorGrZones_m_BGrid[3]*/
	0x0F120258,	/*0258	0258 026C	0258	026E	027A	027A
			026D	awbb_OutdoorGrZones_m_BGrid[4]*/
	0x0F12030A,	/*0302	0302 030A	0302	030A	030A	030A
			02C2	awbb_OutdoorGrZones_m_BGrid[5]*/
	0x0F120246,	/*0246	0246 0258	0246	025E	027A	0274
			0256	awbb_OutdoorGrZones_m_BGrid[6]*/
	0x0F1202FA,	/*02EA	02EA 0302	02EA	02FE	030A	02FE
			02A6	awbb_OutdoorGrZones_m_BGrid[7]*/
	0x0F120256,	/*0256	0256 0246	0256	0264	0274	0282
			026E	awbb_OutdoorGrZones_m_BGrid[8]*/
	0x0F1202DC,	/*02B8	02B8 02EA	02B8	02D0	02FE	02DC
			028A	awbb_OutdoorGrZones_m_BGrid[9]*/
	0x0F120000,	/*0000	0000 0256	0000	0000	0282	0000
			0000	awbb_OutdoorGrZones_m_BGrid[10]*/
	0x0F120000,	/*0000	0000 02B8	0000	0000	02DC	0000
			0000	awbb_OutdoorGrZones_m_BGrid[11]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[12]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[13]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[14]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[15]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[16]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[17]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[18]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[19]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[20]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[21]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[22]*/
	0x0F120000,	/*0000	0000 0000	0000	0000	0000	0000
			0000	awbb_OutdoorGrZones_m_BGrid[23]*/
	0x0F120005,	/*awbb_OutdoorGrZones_m_GridStep*/
	0x002A0D70,
	0x0F120005,	/*awbb_OutdoorGrZones_ZInfo_m_GridSz*/
	0x002A0D74,
	0x0F1201EB,	/*awbb_OutdoorGrZones_m_Boffs*/
	0x002A0D78,
	0x0F1203CE,	/*awbb_LowBrGrZones_m_BGrid[0]*/
	0x0F12046E,	/*awbb_LowBrGrZones_m_BGrid[1]*/
	0x0F12034E,	/*awbb_LowBrGrZones_m_BGrid[2]*/
	0x0F120474,	/*awbb_LowBrGrZones_m_BGrid[3]*/
	0x0F1202EA,	/*awbb_LowBrGrZones_m_BGrid[4]*/
	0x0F120434,	/*awbb_LowBrGrZones_m_BGrid[5]*/
	0x0F12028C,	/*awbb_LowBrGrZones_m_BGrid[6]*/
	0x0F1203F0,	/*awbb_LowBrGrZones_m_BGrid[7]*/
	0x0F120244,	/*awbb_LowBrGrZones_m_BGrid[8]*/
	0x0F120380,	/*awbb_LowBrGrZones_m_BGrid[9]*/
	0x0F12020E,	/*awbb_LowBrGrZones_m_BGrid[10]*/
	0x0F120330,	/*awbb_LowBrGrZones_m_BGrid[11]*/
	0x0F1201EC,	/*awbb_LowBrGrZones_m_BGrid[12]*/
	0x0F1202EC,	/*awbb_LowBrGrZones_m_BGrid[13]*/
	0x0F1201D0,	/*awbb_LowBrGrZones_m_BGrid[14]*/
	0x0F1202BC,	/*awbb_LowBrGrZones_m_BGrid[15]*/
	0x0F1201C8,	/*awbb_LowBrGrZones_m_BGrid[16]*/
	0x0F120296,	/*awbb_LowBrGrZones_m_BGrid[17]*/
	0x0F1201D2,	/*awbb_LowBrGrZones_m_BGrid[18]*/
	0x0F120266,	/*awbb_LowBrGrZones_m_BGrid[19]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[20]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[21]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[22]*/
	0x0F120000,	/*awbb_LowBrGrZones_m_BGrid[23]*/
	0x0F120006,	/*awbb_LowBrGrZones_m_GridStep*/
	0x002A0DAC,
	0x0F12000A,	/*awbb_LowBrGrZones_ZInfo_m_GridSz*/
	0x002A0DB0,
	0x0F1200E2,	/*awbb_LowBrGrZones_m_Boffs*/
	0x002A0F60,
	0x0F1202E2,	/*awbb_GridConst_1[0]*/
	0x0F12034B,	/*awbb_GridConst_1[1]*/
	0x0F120399,	/*awbb_GridConst_1[2]*/
	0x0F12102D,	/*awbb_GridConst_2[0]*/
	0x0F1210DE,	/*awbb_GridConst_2[1]*/
	0x0F12116E,	/*awbb_GridConst_2[2]*/
	0x0F12117B,	/*awbb_GridConst_2[3]*/
	0x0F12120A,	/*11FF	awbb_GridConst_2[4]*/
	0x0F121247,	/*awbb_GridConst_2[5]*/
	0x0F1202C4,	/*awbb_GridCoeff_R_1*/
	0x0F1202E4,	/*awbb_GridCoeff_B_1*/
	0x0F1200C3,	/*awbb_GridCoeff_R_2*/
	0x0F1200A6,	/*awbb_GridCoeff_B_2*/
	0x002A0ED0,
	0x0F120046,	/*0046,	0046	000A	000A	awbb_GridCorr_R[0][0]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[0][1]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[0][2]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[0][3]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[0][4]*/
	0x0F120028,	/*0028,	0028	0000	001E	awbb_GridCorr_R[0][5]*/
	0x0F120046,	/*0046,	0046	000A	000A	awbb_GridCorr_R[1][0]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[1][1]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[1][2]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[1][3]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[1][4]*/
	0x0F120028,	/*0028,	0028	0000	001E	awbb_GridCorr_R[1][5]*/
	0x0F120046,	/*0046,	0046	000A	000A	awbb_GridCorr_R[2][0]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[2][1]*/
	0x0F120000,	/*0000,	0028	0028	0028	awbb_GridCorr_R[2][2]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[2][3]*/
	0x0F12FFEC,	/*FFEC,	FFEC	FFEC	FFEC	awbb_GridCorr_R[2][4]*/
	0x0F120028,	/*0028,	0028	0000	001E	awbb_GridCorr_R[2][5]*/
	0x0F12FFD8,	/*FFD8,	FFD8	FFD8	FFD8	awbb_GridCorr_B[0][0]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[0][1]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[0][2]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[0][3]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[0][4]*/
	0x0F12FF9C,	/*FF9C,	FF9C	FE70	001E	awbb_GridCorr_B[0][5]*/
	0x0F12FFD8,	/*FFD8,	FFD8	FFD8	FFD8	awbb_GridCorr_B[1][0]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[1][1]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[1][2]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[1][3]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[1][4]*/
	0x0F12FF9C,	/*FF9C,	FF9C	FE70	001E	awbb_GridCorr_B[1][5]*/
	0x0F12FFD8,	/*FFD8,	FFD8	FFD8	FFD8	awbb_GridCorr_B[2][0]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[2][1]*/
	0x0F12FFCE,	/*0050,	003C	003C	003C	awbb_GridCorr_B[2][2]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[2][3]*/
	0x0F12FFCE,	/*FFCE,	FFCE	FFCE	0000	awbb_GridCorr_B[2][4]*/
	0x0F12FF9C,	/*FF9C,	FF9C	FE70	001E	awbb_GridCorr_B[2][5]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][0]*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[0][1]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][2]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][3]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][4]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[0][5]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][0]*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[1][1]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][2]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][3]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][4]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[1][5]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][0]*/
	0x0F12FFE0,	/*awbb_GridCorr_R_Out[2][1]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][2]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][3]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][4]*/
	0x0F120000,	/*awbb_GridCorr_R_Out[2][5]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][0]*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[0][1]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][2]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][3]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][4]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[0][5]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][0]*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[1][1]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][2]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][3]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][4]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[1][5]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][0]*/
	0x0F12FFDE,	/*awbb_GridCorr_B_Out[2][1]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][2]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][3]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][4]*/
	0x0F120000,	/*awbb_GridCorr_B_Out[2][5]*/
	0x002A05D2,
	0x0F1200E4,	/*SARR_AwbCcmCord[0]*/
	0x0F1200F0,	/*SARR_AwbCcmCord[1]*/
	0x0F120100,	/*SARR_AwbCcmCord[2]*/
	0x0F120120,	/*SARR_AwbCcmCord[3]*/
	0x0F120150,	/*SARR_AwbCcmCord[4]*/
	0x0F120180,	/*SARR_AwbCcmCord[5]*/
	0x002A05C4,
	0x0F123800,	/*TVAR_wbt_pBaseCcms*/
	0x0F127000,
	0x002A05CC,
	0x0F1238D8,	/*TVAR_wbt_pOutdoorCcm*/
	0x0F127000,
	0x002A3800,
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[0]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[1]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[2]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[3]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[4]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[5]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[6]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[7]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[8]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[9]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[10]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[11]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[12]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[13]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[14]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[15]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[16]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[17]*/
	0x0F1201D0,	/*TVAR_wbt_pBaseCcms[18]*/
	0x0F12FFA1,	/*TVAR_wbt_pBaseCcms[19]*/
	0x0F12FFFA,	/*TVAR_wbt_pBaseCcms[20]*/
	0x0F12FF6F,	/*TVAR_wbt_pBaseCcms[21]*/
	0x0F120140,	/*TVAR_wbt_pBaseCcms[22]*/
	0x0F12FF49,	/*TVAR_wbt_pBaseCcms[23]*/
	0x0F12FFC1,	/*TVAR_wbt_pBaseCcms[24]*/
	0x0F12001F,	/*TVAR_wbt_pBaseCcms[25]*/
	0x0F1201BD,	/*TVAR_wbt_pBaseCcms[26]*/
	0x0F12013F,	/*TVAR_wbt_pBaseCcms[27]*/
	0x0F1200E1,	/*TVAR_wbt_pBaseCcms[28]*/
	0x0F12FF43,	/*TVAR_wbt_pBaseCcms[29]*/
	0x0F120191,	/*TVAR_wbt_pBaseCcms[30]*/
	0x0F12FFC0,	/*TVAR_wbt_pBaseCcms[31]*/
	0x0F1201B7,	/*TVAR_wbt_pBaseCcms[32]*/
	0x0F12FF30,	/*TVAR_wbt_pBaseCcms[33]*/
	0x0F12015F,	/*TVAR_wbt_pBaseCcms[34]*/
	0x0F120106,	/*TVAR_wbt_pBaseCcms[35]*/
	0x0F1201C4,	/*01D3	01D0	TVAR_wbt_pBaseCcms[36]*/
	0x0F12FFAC,	/*FFBB	FFA1	TVAR_wbt_pBaseCcms[37]*/
	0x0F12FFFB,	/*FFDD	FFFA	TVAR_wbt_pBaseCcms[38]*/
	0x0F12FF6F,	/*FF6F	FF6F	TVAR_wbt_pBaseCcms[39]*/
	0x0F120140,	/*0140	0140	TVAR_wbt_pBaseCcms[40]*/
	0x0F12FF49,	/*FF49	FF49	TVAR_wbt_pBaseCcms[41]*/
	0x0F12FFC1,	/*FFC1	FFC1	TVAR_wbt_pBaseCcms[42]*/
	0x0F12001F,	/*001F	001F	TVAR_wbt_pBaseCcms[43]*/
	0x0F1201BD,	/*01BD	01BD	TVAR_wbt_pBaseCcms[44]*/
	0x0F12013F,	/*013F	013F	TVAR_wbt_pBaseCcms[45]*/
	0x0F1200E1,	/*00E1	00E1	TVAR_wbt_pBaseCcms[46]*/
	0x0F12FF43,	/*FF43	FF43	TVAR_wbt_pBaseCcms[47]*/
	0x0F120191,	/*0191	0191	TVAR_wbt_pBaseCcms[48]*/
	0x0F12FFC0,	/*FFC0	FFC0	TVAR_wbt_pBaseCcms[49]*/
	0x0F1201B7,	/*01B7	01B7	TVAR_wbt_pBaseCcms[50]*/
	0x0F12FF30,	/*FF30	FF30	TVAR_wbt_pBaseCcms[51]*/
	0x0F12015F,	/*015F	015F	TVAR_wbt_pBaseCcms[52]*/
	0x0F120106,	/*0106	0106	TVAR_wbt_pBaseCcms[53]*/
	0x0F1201B5,	/*01C6,	01D0	TVAR_wbt_pBaseCcms[54]*/
	0x0F12FFC6,	/*FFBE,	FFA1	TVAR_wbt_pBaseCcms[55]*/
	0x0F12FFEF,	/*FFE6,	FFFA	TVAR_wbt_pBaseCcms[56]*/
	0x0F12FF6F,	/*FF6F,	FF6F	TVAR_wbt_pBaseCcms[57]*/
	0x0F120140,	/*0140,	0140	TVAR_wbt_pBaseCcms[58]*/
	0x0F12FF49,	/*FF49,	FF49	TVAR_wbt_pBaseCcms[59]*/
	0x0F12FFC1,	/*FFC1,	FFC1	TVAR_wbt_pBaseCcms[60]*/
	0x0F12001F,	/*001F,	001F	TVAR_wbt_pBaseCcms[61]*/
	0x0F1201BD,	/*01BD,	01BD	TVAR_wbt_pBaseCcms[62]*/
	0x0F12013F,	/*013F,	013F	TVAR_wbt_pBaseCcms[63]*/
	0x0F1200E1,	/*00E1,	00E1	TVAR_wbt_pBaseCcms[64]*/
	0x0F12FF43,	/*FF43,	FF43	TVAR_wbt_pBaseCcms[65]*/
	0x0F120191,	/*0191,	0191	TVAR_wbt_pBaseCcms[66]*/
	0x0F12FFC0,	/*FFC0,	FFC0	TVAR_wbt_pBaseCcms[67]*/
	0x0F1201B7,	/*01B7,	01B7	TVAR_wbt_pBaseCcms[68]*/
	0x0F12FF30,	/*FF30,	FF30	TVAR_wbt_pBaseCcms[69]*/
	0x0F12015F,	/*015F,	015F	TVAR_wbt_pBaseCcms[70]*/
	0x0F120106,	/*0106,	0106	TVAR_wbt_pBaseCcms[71]*/
	0x0F1201B7,	/*C8	01BF	TVAR_wbt_pBaseCcms[72]*/
	0x0F12FFC4,	/*FFBA	FFBF	TVAR_wbt_pBaseCcms[73]*/
	0x0F120001,	/*FFE8	FFFE	TVAR_wbt_pBaseCcms[74]*/
	0x0F12FF6D,	/*FF6D	FF6F	FF6D	TVAR_wbt_pBaseCcms[75]*/
	0x0F1201B4,	/*01B4	0140	01B4	TVAR_wbt_pBaseCcms[76]*/
	0x0F12FF66,	/*FF66	FF49	FF66	TVAR_wbt_pBaseCcms[77]*/
	0x0F12FFCA,	/*FFCA	FFC1	FFCA	TVAR_wbt_pBaseCcms[78]*/
	0x0F12FFCE,	/*FFCE	001F	FFCE	TVAR_wbt_pBaseCcms[79]*/
	0x0F12017B,	/*017B	01BD	017B	TVAR_wbt_pBaseCcms[80]*/
	0x0F120136,	/*0136	013F	0136	TVAR_wbt_pBaseCcms[81]*/
	0x0F120132,	/*0132	00E1	0132	TVAR_wbt_pBaseCcms[82]*/
	0x0F12FF85,	/*FF85	FF43	FF85	TVAR_wbt_pBaseCcms[83]*/
	0x0F12018B,	/*018B	0191	018B	TVAR_wbt_pBaseCcms[84]*/
	0x0F12FF73,	/*FF73	FFC0	FF73	TVAR_wbt_pBaseCcms[85]*/
	0x0F120191,	/*0191	01B7	0191	TVAR_wbt_pBaseCcms[86]*/
	0x0F12FF3F,	/*FF3F	FF30	FF3F	TVAR_wbt_pBaseCcms[87]*/
	0x0F12015B,	/*015B	015F	015B	TVAR_wbt_pBaseCcms[88]*/
	0x0F1200D0,	/*00D0	0106	00D0	TVAR_wbt_pBaseCcms[89]*/
	0x0F1201CA,	/*01CA	01C1	TVAR_wbt_pBaseCcms[90]*/
	0x0F12FFBE,	/*FFBE	FFC5	TVAR_wbt_pBaseCcms[91]*/
	0x0F12FFF1,	/*FFF1	FFF5	TVAR_wbt_pBaseCcms[92]*/
	0x0F12FEFB,	/*FF15	FF3B	TVAR_wbt_pBaseCcms[93]*/
	0x0F12021C,	/*01F3	0217	TVAR_wbt_pBaseCcms[94]*/
	0x0F12FF6B,	/*FF7B	FF32	TVAR_wbt_pBaseCcms[95]*/
	0x0F12FFC1,	/*FFC1	FFC1	TVAR_wbt_pBaseCcms[96]*/
	0x0F12FFC5,	/*FFC5	FFC5	TVAR_wbt_pBaseCcms[97]*/
	0x0F12018A,	/*018A	018B	TVAR_wbt_pBaseCcms[98]*/
	0x0F1200FB,	/*00FB	0136	TVAR_wbt_pBaseCcms[99]*/
	0x0F120167,	/*0167	0132	TVAR_wbt_pBaseCcms[100]*/
	0x0F12FF8C,	/*FF8C	FF85	TVAR_wbt_pBaseCcms[101]*/
	0x0F12018B,	/*018B	018B	TVAR_wbt_pBaseCcms[102]*/
	0x0F12FF73,	/*FF73	FF73	TVAR_wbt_pBaseCcms[103]*/
	0x0F120191,	/*0191	0191	TVAR_wbt_pBaseCcms[104]*/
	0x0F12FF3F,	/*FF3F	FF3F	TVAR_wbt_pBaseCcms[105]*/
	0x0F12015B,	/*015B	015B	TVAR_wbt_pBaseCcms[106]*/
	0x0F1200D0,	/*00D0	00D0	TVAR_wbt_pBaseCcms[107]*/
	0x002A38D8,
	0x0F120221,	/*022C	0235	TVAR_wbt_pOutdoorCcm[0]*/
	0x0F120005,	/*FFD8	FFEF	TVAR_wbt_pOutdoorCcm[1]*/
	0x0F120012,	/*0034	0014	TVAR_wbt_pOutdoorCcm[2]*/
	0x0F12FF67,	/*FF67	FF67	TVAR_wbt_pOutdoorCcm[3]*/
	0x0F12027D,	/*027D	027D	TVAR_wbt_pOutdoorCcm[4]*/
	0x0F12FFBA,	/*FFBA	FFBA	TVAR_wbt_pOutdoorCcm[5]*/
	0x0F12000D,	/*000D	000D	TVAR_wbt_pOutdoorCcm[6]*/
	0x0F120062,	/*0062	0062	TVAR_wbt_pOutdoorCcm[7]*/
	0x0F1202A7,	/*02A7	02A7	TVAR_wbt_pOutdoorCcm[8]*/
	0x0F1200C7,	/*00C7	00C9	TVAR_wbt_pOutdoorCcm[9]*/
	0x0F12011F,	/*011F	0123	TVAR_wbt_pOutdoorCcm[10]*/
	0x0F12FF3C,	/*FF3C	FF36	TVAR_wbt_pOutdoorCcm[11]*/
	0x0F1201AD,	/*01AD	01AD	TVAR_wbt_pOutdoorCcm[12]*/
	0x0F12FFC8,	/*FFC8	FFC8	TVAR_wbt_pOutdoorCcm[13]*/
	0x0F120202,	/*0202	0202	TVAR_wbt_pOutdoorCcm[14]*/
	0x0F12FFCF,	/*FFCF	FFCF	TVAR_wbt_pOutdoorCcm[15]*/
	0x0F120257,	/*0257	0257	TVAR_wbt_pOutdoorCcm[16]*/
	0x0F12022C,	/*022C	022C	TVAR_wbt_pOutdoorCcm[17]*/
	0x002A23DC,
	0x0F1201DD,	/*Mon_AAIO_PrevFrmData_NormBr*/
	0x002A0460,
	0x0F120000, /*0000	0000	saRR_usDualGammaLutRGBIndoor[0][0]*/
	0x0F120004, /*0008	0002	saRR_usDualGammaLutRGBIndoor[0][1]*/
	0x0F12000C, /*0013	0006	saRR_usDualGammaLutRGBIndoor[0][2]*/
	0x0F120024, /*002C	0011	saRR_usDualGammaLutRGBIndoor[0][3]*/
	0x0F12006E, /*0061	0036	saRR_usDualGammaLutRGBIndoor[0][4]*/
	0x0F1200D1, /*00C8	009A	saRR_usDualGammaLutRGBIndoor[0][5]*/
	0x0F120119, /*0113	00FD	saRR_usDualGammaLutRGBIndoor[0][6]*/
	0x0F120139, /*0132	0129	saRR_usDualGammaLutRGBIndoor[0][7]*/
	0x0F120157, /*014C	014B	saRR_usDualGammaLutRGBIndoor[0][8]*/
	0x0F12018E, /*0179	0184	saRR_usDualGammaLutRGBIndoor[0][9]*/
	0x0F1201C3, /*01A4	01B8	saRR_usDualGammaLutRGBIndoor[0][10]*/
	0x0F1201F3, /*01CD	01EA	saRR_usDualGammaLutRGBIndoor[0][11]*/
	0x0F12021F, /*01F4	0216	saRR_usDualGammaLutRGBIndoor[0][12]*/
	0x0F120269, /*0239	025E	saRR_usDualGammaLutRGBIndoor[0][13]*/
	0x0F1202A6, /*0278	0299	saRR_usDualGammaLutRGBIndoor[0][14]*/
	0x0F1202FF, /*02E0	02F9	saRR_usDualGammaLutRGBIndoor[0][15]*/
	0x0F120351, /*0333	0341	saRR_usDualGammaLutRGBIndoor[0][16]*/
	0x0F120395, /*037B	037F	saRR_usDualGammaLutRGBIndoor[0][17]*/
	0x0F1203CE, /*03BF	03BF	saRR_usDualGammaLutRGBIndoor[0][18]*/
	0x0F1203FF, /*03FF	03FF	saRR_usDualGammaLutRGBIndoor[0][19]*/
	0x0F120000, /*0000	0000	saRR_usDualGammaLutRGBIndoor[1][0]*/
	0x0F120004, /*0008	0002	saRR_usDualGammaLutRGBIndoor[1][1]*/
	0x0F12000C, /*0013	0006	saRR_usDualGammaLutRGBIndoor[1][2]*/
	0x0F120024, /*002C	0011	saRR_usDualGammaLutRGBIndoor[1][3]*/
	0x0F12006E, /*0061	0036	saRR_usDualGammaLutRGBIndoor[1][4]*/
	0x0F1200D1, /*00C8	009A	saRR_usDualGammaLutRGBIndoor[1][5]*/
	0x0F120119, /*0113	00FD	saRR_usDualGammaLutRGBIndoor[1][6]*/
	0x0F120139, /*0132	0129	saRR_usDualGammaLutRGBIndoor[1][7]*/
	0x0F120157, /*014C	014B	saRR_usDualGammaLutRGBIndoor[1][8]*/
	0x0F12018E, /*0179	0184	saRR_usDualGammaLutRGBIndoor[1][9]*/
	0x0F1201C3, /*01A4	01B8	saRR_usDualGammaLutRGBIndoor[1][10]*/
	0x0F1201F3, /*01CD	01EA	saRR_usDualGammaLutRGBIndoor[1][11]*/
	0x0F12021F, /*01F4	0216	saRR_usDualGammaLutRGBIndoor[1][12]*/
	0x0F120269, /*0239	025E	saRR_usDualGammaLutRGBIndoor[1][13]*/
	0x0F1202A6, /*0278	0299	saRR_usDualGammaLutRGBIndoor[1][14]*/
	0x0F1202FF, /*02E0	02F9	saRR_usDualGammaLutRGBIndoor[1][15]*/
	0x0F120351, /*0333	0341	saRR_usDualGammaLutRGBIndoor[1][16]*/
	0x0F120395, /*037B	037F	saRR_usDualGammaLutRGBIndoor[1][17]*/
	0x0F1203CE, /*03BF	03BF	saRR_usDualGammaLutRGBIndoor[1][18]*/
	0x0F1203FF, /*03FF	03FF	saRR_usDualGammaLutRGBIndoor[1][19]*/
	0x0F120000, /*0000	0000	saRR_usDualGammaLutRGBIndoor[2][0]*/
	0x0F120004, /*0008	0002	saRR_usDualGammaLutRGBIndoor[2][1]*/
	0x0F12000C, /*0013	0006	saRR_usDualGammaLutRGBIndoor[2][2]*/
	0x0F120024, /*002C	0011	saRR_usDualGammaLutRGBIndoor[2][3]*/
	0x0F12006E, /*0061	0036	saRR_usDualGammaLutRGBIndoor[2][4]*/
	0x0F1200D1, /*00C8	009A	saRR_usDualGammaLutRGBIndoor[2][5]*/
	0x0F120119, /*0113	00FD	saRR_usDualGammaLutRGBIndoor[2][6]*/
	0x0F120139, /*0132	0129	saRR_usDualGammaLutRGBIndoor[2][7]*/
	0x0F120157, /*014C	014B	saRR_usDualGammaLutRGBIndoor[2][8]*/
	0x0F12018E, /*0179	0184	saRR_usDualGammaLutRGBIndoor[2][9]*/
	0x0F1201C3, /*01A4	01B8	saRR_usDualGammaLutRGBIndoor[2][10]*/
	0x0F1201F3, /*01CD	01EA	saRR_usDualGammaLutRGBIndoor[2][11]*/
	0x0F12021F, /*01F4	0216	saRR_usDualGammaLutRGBIndoor[2][12]*/
	0x0F120269, /*0239	025E	saRR_usDualGammaLutRGBIndoor[2][13]*/
	0x0F1202A6, /*0278	0299	saRR_usDualGammaLutRGBIndoor[2][14]*/
	0x0F1202FF, /*02E0	02F9	saRR_usDualGammaLutRGBIndoor[2][15]*/
	0x0F120351, /*0333	0341	saRR_usDualGammaLutRGBIndoor[2][16]*/
	0x0F120395, /*037B	037F	saRR_usDualGammaLutRGBIndoor[2][17]*/
	0x0F1203CE, /*03BF	03BF	saRR_usDualGammaLutRGBIndoor[2][18]*/
	0x0F1203FF, /*03FF	03FF	saRR_usDualGammaLutRGBIndoor[2][19]*/
	0x0F120000, /*0000	0000	saRR_usDualGammaLutRGBOutdoor[0][0]*/
	0x0F120004, /*0008	0002	saRR_usDualGammaLutRGBOutdoor[0][1]*/
	0x0F12000C, /*0013	0006	saRR_usDualGammaLutRGBOutdoor[0][2]*/
	0x0F120024, /*002C	0011	saRR_usDualGammaLutRGBOutdoor[0][3]*/
	0x0F12006E, /*0061	0036	saRR_usDualGammaLutRGBOutdoor[0][4]*/
	0x0F1200D1, /*00C8	009A	saRR_usDualGammaLutRGBOutdoor[0][5]*/
	0x0F120119, /*0113	00FD	saRR_usDualGammaLutRGBOutdoor[0][6]*/
	0x0F120139, /*0132	0129	saRR_usDualGammaLutRGBOutdoor[0][7]*/
	0x0F120157, /*014C	014B	saRR_usDualGammaLutRGBOutdoor[0][8]*/
	0x0F12018E, /*0179	0184	saRR_usDualGammaLutRGBOutdoor[0][9]*/
	0x0F1201C3, /*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[0][10]*/
	0x0F1201F3, /*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[0][11]*/
	0x0F12021F, /*01F4	0216	saRR_usDualGammaLutRGBOutdoor[0][12]*/
	0x0F120269, /*0239	025E	saRR_usDualGammaLutRGBOutdoor[0][13]*/
	0x0F1202A6, /*0278	0299	saRR_usDualGammaLutRGBOutdoor[0][14]*/
	0x0F1202FF, /*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[0][15]*/
	0x0F120351, /*0333	0341	saRR_usDualGammaLutRGBOutdoor[0][16]*/
	0x0F120395, /*037B	037F	saRR_usDualGammaLutRGBOutdoor[0][17]*/
	0x0F1203CE, /*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[0][18]*/
	0x0F1203FF, /*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[0][19]*/
	0x0F120000, /*0000	0000	saRR_usDualGammaLutRGBOutdoor[1][0]*/
	0x0F120004, /*0008	0002	saRR_usDualGammaLutRGBOutdoor[1][1]*/
	0x0F12000C, /*0013	0006	saRR_usDualGammaLutRGBOutdoor[1][2]*/
	0x0F120024, /*002C	0011	saRR_usDualGammaLutRGBOutdoor[1][3]*/
	0x0F12006E, /*0061	0036	saRR_usDualGammaLutRGBOutdoor[1][4]*/
	0x0F1200D1, /*00C8	009A	saRR_usDualGammaLutRGBOutdoor[1][5]*/
	0x0F120119, /*0113	00FD	saRR_usDualGammaLutRGBOutdoor[1][6]*/
	0x0F120139, /*0132	0129	saRR_usDualGammaLutRGBOutdoor[1][7]*/
	0x0F120157, /*014C	014B	saRR_usDualGammaLutRGBOutdoor[1][8]*/
	0x0F12018E, /*0179	0184	saRR_usDualGammaLutRGBOutdoor[1][9]*/
	0x0F1201C3, /*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[1][10]*/
	0x0F1201F3, /*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[1][11]*/
	0x0F12021F, /*01F4	0216	saRR_usDualGammaLutRGBOutdoor[1][12]*/
	0x0F120269, /*0239	025E	saRR_usDualGammaLutRGBOutdoor[1][13]*/
	0x0F1202A6, /*0278	0299	saRR_usDualGammaLutRGBOutdoor[1][14]*/
	0x0F1202FF, /*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[1][15]*/
	0x0F120351, /*0333	0341	saRR_usDualGammaLutRGBOutdoor[1][16]*/
	0x0F120395, /*037B	037F	saRR_usDualGammaLutRGBOutdoor[1][17]*/
	0x0F1203CE, /*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[1][18]*/
	0x0F1203FF, /*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[1][19]*/
	0x0F120000, /*0000	0000	saRR_usDualGammaLutRGBOutdoor[2][0]*/
	0x0F120004, /*0008	0002	saRR_usDualGammaLutRGBOutdoor[2][1]*/
	0x0F12000C, /*0013	0006	saRR_usDualGammaLutRGBOutdoor[2][2]*/
	0x0F120024, /*002C	0011	saRR_usDualGammaLutRGBOutdoor[2][3]*/
	0x0F12006E, /*0061	0036	saRR_usDualGammaLutRGBOutdoor[2][4]*/
	0x0F1200D1, /*00C8	009A	saRR_usDualGammaLutRGBOutdoor[2][5]*/
	0x0F120119, /*0113	00FD	saRR_usDualGammaLutRGBOutdoor[2][6]*/
	0x0F120139, /*0132	0129	saRR_usDualGammaLutRGBOutdoor[2][7]*/
	0x0F120157, /*014C	014B	saRR_usDualGammaLutRGBOutdoor[2][8]*/
	0x0F12018E, /*0179	0184	saRR_usDualGammaLutRGBOutdoor[2][9]*/
	0x0F1201C3, /*01A4	01B8	saRR_usDualGammaLutRGBOutdoor[2][10]*/
	0x0F1201F3, /*01CD	01EA	saRR_usDualGammaLutRGBOutdoor[2][11]*/
	0x0F12021F, /*01F4	0216	saRR_usDualGammaLutRGBOutdoor[2][12]*/
	0x0F120269, /*0239	025E	saRR_usDualGammaLutRGBOutdoor[2][13]*/
	0x0F1202A6, /*0278	0299	saRR_usDualGammaLutRGBOutdoor[2][14]*/
	0x0F1202FF, /*02E0	02F9	saRR_usDualGammaLutRGBOutdoor[2][15]*/
	0x0F120351, /*0333	0341	saRR_usDualGammaLutRGBOutdoor[2][16]*/
	0x0F120395, /*037B	037F	saRR_usDualGammaLutRGBOutdoor[2][17]*/
	0x0F1203CE, /*03BF	03BF	saRR_usDualGammaLutRGBOutdoor[2][18]*/
	0x0F1203FF, /*03FF	03FF	saRR_usDualGammaLutRGBOutdoor[2][19]*/
	0x002A065C,
	0x0F12003F,	/*afit_uNoiseIndInDoor_0_*/
	0x0F120041,	/*afit_uNoiseIndInDoor_1_*/
	0x0F1200CB,	/*afit_uNoiseIndInDoor_2_*/
	0x0F1201E0,	/*afit_uNoiseIndInDoor_3_*/
	0x0F120220,	/*afit_uNoiseIndInDoor_4_*/
	0x002A3780,
	0x0F120000,	/*on/off AFIT by NB option*/
	0x0F120014,	/*SARR_uNormBrInDoor*/
	0x0F1200D2,	/*SARR_uNormBrInDoor*/
	0x0F120384,	/*SARR_uNormBrInDoor*/
	0x0F1207D0,	/*SARR_uNormBrInDoor*/
	0x0F121388,	/*SARR_uNormBrInDoor*/
	0x002A06BC,
	0x0F120000,	/*AFIT16_BRIGHTNESS*/
	0x0F120000,	/*AFIT16_CONTRAST*/
	0x0F120014,	/*AFIT16_SATURATION*/
	0x0F120000,	/*AFIT16_SHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_Sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F12005A,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F12001E,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F12001E,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201F4,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120005,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120005,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F12001E,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F120A3B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F12001E,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120002,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128003,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F121982,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120B80,	/*0A80	AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F124601,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F126444,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F129650,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F121E00,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121464,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121404,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F120F14,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F121403,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120114,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F124446,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F122832,	/*5064	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F12141E,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F126407,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120414,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A0A,	/*1414	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120F0F,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F124601,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F126E44,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122864,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121E00,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F120004,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120F00,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120014,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F12005A,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120046,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F120064,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F120064,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F12001E,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F12033B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120005,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120002,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128003,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120A6E,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F122801,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F12231E,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12961E,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A02,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120764,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F12143C,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F121401,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F120F14,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F121E28,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F120A0C,	/*1419	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F120200,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123C07,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A0A,	/*1414	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120F0F,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F121E1E,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F123C01,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F125A3A,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122858,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F120003,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121E00,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F120004,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120F00,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120000,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F12012C,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F12005A,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12003C,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F12001E,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F12033B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120005,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120001,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121102,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001B,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120306,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128002,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120080,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122A03,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A02,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120864,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F129601,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F122814,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400A,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F12191B,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12070C,	/*0F19	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F12021E,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123208,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A28,	/*1450	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120A28,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F122828,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F122401,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F123622,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122832,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121003,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121E04,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F120714,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F125004,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120F40,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F12400F,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120000,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F1200C8,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F1203E8,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120046,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F120050,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120008,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F120320,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120032,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F12002D,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F120019,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F121403,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F12033B,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12081E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120F0F,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120012,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120005,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120001,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128002,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120080,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F122319,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12960F,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120000,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122003,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A02,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120864,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F122814,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F12400A,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125003,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F12191B,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12070C,	/*0F19	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120028,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F120300,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F12021E,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F121E0A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123208,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120A28,	/*1450	AFIT8_sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F120A28,	/*AFIT8_sharpening_iLowshDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120302,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F123C3C,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F121E01,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F12221C,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F12281E,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121402,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F12060E,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F125204,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F120C40,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F124015,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F120000,	/*AFIT16_BRIGHTNEss*/
	0x0F120000,	/*AFIT16_CONTRAsT*/
	0x0F120000,	/*AFIT16_sATURATION*/
	0x0F120000,	/*AFIT16_sHARP_BLUR*/
	0x0F120000,	/*AFIT16_GLAMOUR*/
	0x0F1200C1,	/*AFIT16_sddd8a_edge_high*/
	0x0F1203FF,	/*AFIT16_Demosaicing_isatVal*/
	0x0F12009C,	/*AFIT16_sharpening_iReduceEdgeThresh*/
	0x0F12017C,	/*AFIT16_demsharpmix1_iRGBOffset*/
	0x0F1203FF,	/*AFIT16_demsharpmix1_iDemClamp*/
	0x0F12000C,	/*AFIT16_demsharpmix1_iLowThreshold*/
	0x0F120010,	/*AFIT16_demsharpmix1_iHighThreshold*/
	0x0F120032,	/*AFIT16_demsharpmix1_iLowBright*/
	0x0F12028A,	/*AFIT16_demsharpmix1_iHighBright*/
	0x0F120032,	/*AFIT16_demsharpmix1_iLowsat*/
	0x0F1201F4,	/*AFIT16_demsharpmix1_iHighsat*/
	0x0F120070,	/*AFIT16_demsharpmix1_iTune*/
	0x0F120002,	/*AFIT16_demsharpmix1_iHystThLow*/
	0x0F120000,	/*AFIT16_demsharpmix1_iHystThHigh*/
	0x0F1201AA,	/*AFIT16_demsharpmix1_iHystCenter*/
	0x0F12003C,	/*AFIT16_YUV422_DENOIsE_iUVLowThresh*/
	0x0F120050,	/*AFIT16_YUV422_DENOIsE_iUVHighThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYLowThresh*/
	0x0F120000,	/*AFIT16_YUV422_DENOIsE_iYHighThresh*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp*/
	0x0F1200B4,	/*AFIT16_sharpening_iLowsharpClamp_Bin*/
	0x0F120014,	/*AFIT16_sharpening_iHighsharpClamp_Bin*/
	0x0F120046,	/*AFIT16_sharpening_iLowsharpClamp_sBin*/
	0x0F120019,	/*AFIT16_sharpening_iHighsharpClamp_sBin*/
	0x0F120A24,	/*AFIT8_sddd8a_edge_low	[7:0],
			AFIT8_sddd8a_repl_thresh [15:8]*/
	0x0F121701,	/*AFIT8_sddd8a_repl_force [7:0],
			AFIT8_sddd8a_sat_level [15:8]*/
	0x0F120229,	/*AFIT8_sddd8a_sat_thr[7:0],
			AFIT8_sddd8a_sat_mpl [15:8]*/
	0x0F120503,	/*AFIT8_sddd8a_sat_noise[7:0],
			AFIT8_sddd8a_iMaxslopeAllowed [15:8]*/
	0x0F12080F,	/*AFIT8_sddd8a_iHotThreshHigh[7:0],
			AFIT8_sddd8a_iHotThreshLow	[15:8]*/
	0x0F120808,	/*AFIT8_sddd8a_iColdThreshHigh[7:0],
			AFIT8_sddd8a_iColdThreshLow [15:8]*/
	0x0F120000,	/*AFIT8_sddd8a_AddNoisePower1[7:0],
			AFIT8_sddd8a_AddNoisePower2 [15:8]*/
	0x0F1200FF,	/*AFIT8_sddd8a_isatsat[7:0],
			AFIT8_sddd8a_iRadialTune	[15:8]*/
	0x0F12022D,	/*AFIT8_sddd8a_iRadialLimit [7:0],
			AFIT8_sddd8a_iRadialPower [15:8]*/
	0x0F121414,	/*AFIT8_sddd8a_iLowMaxslopeAllowed [7:0],
			AFIT8_sddd8a_iHighMaxslopeAllowed [15:8]*/
	0x0F120301,	/*AFIT8_sddd8a_iLowslopeThresh[7:0],
			AFIT8_sddd8a_iHighslopeThresh [15:8]*/
	0x0F12FF07,	/*AFIT8_sddd8a_isquaresRounding	[7:0],
			AFIT8_Demosaicing_iCentGrad [15:8]*/
	0x0F12061E,	/*AFIT8_Demosaicing_iMonochrom [7:0],
			AFIT8_Demosaicing_iDecisionThresh [15:8]*/
	0x0F120A1E,	/*AFIT8_Demosaicing_iDesatThresh [7:0],
			AFIT8_Demosaicing_iEnhThresh [15:8]*/
	0x0F120606,	/*AFIT8_Demosaicing_iGRDenoiseVal [7:0],
			AFIT8_Demosaicing_iGBDenoiseVal [15:8]*/
	0x0F120A03,	/*AFIT8_Demosaicing_iNearGrayDesat[7:0],
			AFIT8_Demosaicing_iDFD_ReduceCoeff [15:8]*/
	0x0F120028,	/*AFIT8_sharpening_iMsharpen [7:0],
			AFIT8_sharpening_iMshThresh [15:8]*/
	0x0F120002,	/*AFIT8_sharpening_iWsharpen [7:0],
			AFIT8_sharpening_iWshThresh [15:8]*/
	0x0F120001,	/*AFIT8_sharpening_nsharpWidth [7:0],
			AFIT8_sharpening_iReduceNegative [15:8]*/
	0x0F1200FF,	/*AFIT8_sharpening_ishDespeckle	[7:0],
			AFIT8_demsharpmix1_iRGBMultiplier [15:8]*/
	0x0F121002,	/*AFIT8_demsharpmix1_iFilterPower [7:0],
			AFIT8_demsharpmix1_iBCoeff [15:8]*/
	0x0F12001E,	/*AFIT8_demsharpmix1_iGCoeff [7:0],
			AFIT8_demsharpmix1_iWideMult [15:8]*/
	0x0F120900,	/*AFIT8_demsharpmix1_iNarrMult [7:0],
			AFIT8_demsharpmix1_iHystFalloff	[15:8]*/
	0x0F120600,	/*AFIT8_demsharpmix1_iHystMinMult [7:0],
			AFIT8_demsharpmix1_iHystWidth [15:8]*/
	0x0F120504,	/*AFIT8_demsharpmix1_iHystFallLow [7:0],
			AFIT8_demsharpmix1_iHystFallHigh [15:8]*/
	0x0F120307,	/*AFIT8_demsharpmix1_iHystTune [7:0],
			* AFIT8_YUV422_DENOIsE_iUVsupport [15:8]*/
	0x0F128001,	/*AFIT8_YUV422_DENOIsE_iYsupport [7:0],
			AFIT8_byr_cgras_ishadingPower	[15:8]*/
	0x0F120080,	/*AFIT8_RGBGamma2_iLinearity [7:0],
			AFIT8_RGBGamma2_iDarkReduce [15:8]*/
	0x0F120080,	/*AFIT8_ccm_oscar_isaturation[7:0],
			AFIT8_RGB2YUV_iYOffset [15:8]*/
	0x0F120080,	/*AFIT8_RGB2YUV_iRGBGain [7:0],
			AFIT8_RGB2YUV_isaturation [15:8]*/
	0x0F125050,	/*AFIT8_sddd8a_iClustThresh_H [7:0],
			AFIT8_sddd8a_iClustThresh_C [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H [7:0],
			AFIT8_sddd8a_iClustMulT_C [15:8]*/
	0x0F121B01,	/*AFIT8_sddd8a_nClustLevel_H [7:0],
			AFIT8_sddd8a_DispTH_Low [15:8]*/
	0x0F121219,	/*AFIT8_sddd8a_DispTH_High [7:0],
			AFIT8_sddd8a_iDenThreshLow [15:8]*/
	0x0F12320D,	/*AFIT8_sddd8a_iDenThreshHigh[7:0],
			AFIT8_Demosaicing_iEdgeDesat [15:8]*/
	0x0F120A0A,	/*AFIT8_Demosaicing_iEdgeDesatThrLow [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh [15:8]*/
	0x0F122304,	/*AFIT8_Demosaicing_iEdgeDesatLimit[7:0],
			AFIT8_Demosaicing_iDemsharpenLow [15:8]*/
	0x0F120A08,	/*AFIT8_Demosaicing_iDemsharpenHigh[7:0],
			AFIT8_Demosaicing_iDemsharpThresh [15:8]*/
	0x0F120832,	/*AFIT8_Demosaicing_iDemshLowLimit [7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp [15:8]*/
	0x0F121432,	/*AFIT8_Demosaicing_iDemBlurLow[7:0],
			AFIT8_Demosaicing_iDemBlurHigh [15:8]*/
	0x0F12A001,	/*AFIT8_Demosaicing_iDemBlurRange[7:0],
			AFIT8_sharpening_iLowsharpPower [15:8]*/
	0x0F122A0A,	/*AFIT8_sharpening_iHighsharpPower[7:0],
			AFIT8_sharpening_iLowshDenoise [15:8]*/
	0x0F124006,	/*AFIT8_sharpening_iHighshDenoise [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult [15:8]*/
	0x0F120604,	/*AFIT8_sharpening_iReduceEdgeslope [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce [15:8]*/
	0x0F125006,	/*AFIT8_demsharpmix1_iNarrFiltReduce [7:0],
			AFIT8_sddd8a_iClustThresh_H_Bin [15:8]*/
	0x0F120150,	/*AFIT8_sddd8a_iClustThresh_C_Bin [7:0],
			AFIT8_sddd8a_iClustMulT_H_Bin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_C_Bin	[7:0],
			AFIT8_sddd8a_nClustLevel_H_Bin	[15:8]*/
	0x0F12191B,	/*AFIT8_sddd8a_DispTH_Low_Bin [7:0],
			AFIT8_sddd8a_DispTH_High_Bin [15:8]*/
	0x0F12070C,	/*0F19	AFIT8_sddd8a_iDenThreshLow_Bin [7:0],
			AFIT8_sddd8a_iDenThreshHigh_Bin [15:8]*/
	0x0F120A28,	/*AFIT8_Demosaicing_iEdgeDesat_Bin[7:0],
			AFIT8_Demosaicing_iEdgeDesatThrLow_Bin [15:8]*/
	0x0F12040A,	/*AFIT8_Demosaicing_iEdgeDesatThrHigh_Bin [7:0],
			AFIT8_Demosaicing_iEdgeDesatLimit_Bin	[15:8]*/
	0x0F120820,	/*AFIT8_Demosaicing_iDemsharpenLow_Bin [7:0],
			AFIT8_Demosaicing_iDemsharpenHigh_Bin [15:8]*/
	0x0F12280A,	/*AFIT8_Demosaicing_iDemsharpThresh_Bin	[7:0],
			AFIT8_Demosaicing_iDemshLowLimit_Bin [15:8]*/
	0x0F123208,	/*AFIT8_Demosaicing_iDespeckleForDemsharp_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurLow_Bin	[15:8]*/
	0x0F120114,	/*AFIT8_Demosaicing_iDemBlurHigh_Bin [7:0],
			AFIT8_Demosaicing_iDemBlurRange_Bin [15:8]*/
	0x0F120532,	/*0A64	AFIT8_Sharpening_iLowsharpPower_Bin [7:0],
			AFIT8_sharpening_iHighsharpPower_Bin [15:8]*/
	0x0F12062A,	/*AFIT8_Sharpening_iLowShDenoise_Bin [7:0],
			AFIT8_sharpening_iHighshDenoise_Bin [15:8]*/
	0x0F120440,	/*AFIT8_Sharpening_iReduceEdgeMinMult_Bin [7:0],
			AFIT8_sharpening_iReduceEdgeslope_Bin	[15:8]*/
	0x0F120606,	/*AFIT8_demsharpmix1_iWideFiltReduce_Bin [7:0],
			AFIT8_demsharpmix1_iNarrFiltReduce_Bin	[15:8]*/
	0x0F124646,	/*AFIT8_sddd8a_iClustThresh_H_sBin[7:0],
			AFIT8_sddd8a_iClustThresh_C_sBin [15:8]*/
	0x0F120101,	/*AFIT8_sddd8a_iClustMulT_H_sBin [7:0],
			AFIT8_sddd8a_iClustMulT_C_sBin [15:8]*/
	0x0F121801,	/*AFIT8_sddd8a_nClustLevel_H_sBin [7:0],
			AFIT8_sddd8a_DispTH_Low_sBin	[15:8]*/
	0x0F12191C,	/*AFIT8_sddd8a_DispTH_High_sBin	[7:0],
			AFIT8_sddd8a_iDenThreshLow_sBin [15:8]*/
	0x0F122818,	/*AFIT8_sddd8a_iDenThreshHigh_sBin[7:0],
			AFIT8_Demosaicing_iEdgeDesat_sBin [15:8]*/
	0x0F120A00,	/*AFIT8_Demosaicing_iEdgeDesatThrLow_sBin [7:0],
			AFIT8_Demosaicing_iEdgeDesatThrHigh_sBin [15:8]*/
	0x0F121403,	/*AFIT8_Demosaicing_iEdgeDesatLimit_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpenLow_sBin [15:8]*/
	0x0F121405,	/*AFIT8_Demosaicing_iDemsharpenHigh_sBin [7:0],
			AFIT8_Demosaicing_iDemsharpThresh_sBin	[15:8]*/
	0x0F12050C,	/*AFIT8_Demosaicing_iDemshLowLimit_sBin	[7:0],
			AFIT8_Demosaicing_iDespeckleForDemsharp_sBin [15:8]*/
	0x0F1232FF,	/*AFIT8_Demosaicing_iDemBlurLow_sBin [7:0],
			AFIT8_Demosaicing_iDemBlurHigh_sBin [15:8]*/
	0x0F125204,	/*AFIT8_Demosaicing_iDemBlurRange_sBin [7:0],
			AFIT8_sharpening_iLowsharpPower_sBin [15:8]*/
	0x0F121440,	/*AFIT8_sharpening_iHighsharpPower_sBin	[7:0],
			AFIT8_sharpening_iLowshDenoise_sBin [15:8]*/
	0x0F124015,	/*AFIT8_sharpening_iHighshDenoise_sBin [7:0],
			AFIT8_sharpening_iReduceEdgeMinMult_sBin	[15:8]*/
	0x0F120204,	/*AFIT8_sharpening_iReduceEdgeslope_sBin [7:0],
			AFIT8_demsharpmix1_iWideFiltReduce_sBin [15:8]*/
	0x0F120003,	/*AFIT8_demsharpmix1_iNarrFiltReduce_sBin [7:0]*/
	0x0F127DFA,	/*ConstAfitBaseVals*/
	0x0F12FFBD,	/*ConstAfitBaseVals_1_*/
	0x0F1226FE,	/*ConstAfitBaseVals_2_*/
	0x0F12F7BC,	/*ConstAfitBaseVals_3_*/
	0x0F127E06,	/*ConstAfitBaseVals_4_*/
	0x0F1200D3,	/*ConstAfitBaseVals_5_*/

	0x002A0156,
	0x0F120003,	 /*REG_TC_GP_ActivePrevConfig*/
	0x002A015E,
	0x0F120000,	 /*REG_TC_GP_ActiveCapConfig*/
	0x002A015A,
	0x0F120001,	 /*REG_TC_GP_PrevOpenAfterChange*/
	0x002A0142,
	0x0F120001,	 /*REG_TC_GP_NewConfigSync*/
	0x002A0158,
	0x0F120001,	 /*REG_TC_GP_PrevConfigChanged*/
	0x002A0160,
	0x0F120001,	 /*REG_TC_GP_CapConfigChanged*/
	0x002A013A,
	0x0F120001,	 /*REG_TC_GP_EnablePreview*/
	0x0F120001,	 /*REG_TC_GP_EnablePreviewChanged*/
	0xFFFF0096,
};

static const u32 s5k5bbgx_stream_stop[]	= {
	0xFCFCD000,
	0x00287000,
	0x002A01F0,
	0x0F120000, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged*/
	/*0xffff0096, 150ms*/
};

#if (0)
static const u32 s5k5bbgx_stream_start[] = {
	0xFCFCD000,
	0x002AB00C,
	0x0F120001,
};
#endif

/*=================================
*	CAMERA_BRIGHTNESS_1 (1/9) M4   *
==================================*/
static const u32 s5k5bbgx_bright_m4[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F12FF00,
};

/*=================================
*	CAMERA_BRIGHTNESS_2 (2/9) M3  *
==================================*/

static const u32 s5k5bbgx_bright_m3[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F12FF00,
};

/*=================================
	CAMERA_BRIGHTNESS_3 (3/9) M2
==================================*/
static const u32 s5k5bbgx_bright_m2[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F12FF9B,
};

/*=================================
	CAMERA_BRIGHTNESS_4 (4/9) M1
==================================*/

static const u32 s5k5bbgx_bright_m1[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F12FF9D,
};

/*=================================
	CAMERA_BRIGHTNESS_5 (5/9) Default
==================================*/
static const u32 s5k5bbgx_bright_default[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F120000,
};

/*=================================
	CAMERA_BRIGHTNESS_6 (6/9) P1
==================================*/
static const u32 s5k5bbgx_bright_p1[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F120020,
};

/*=================================
	CAMERA_BRIGHTNESS_7 (7/9) P2
==================================*/
static const u32 s5k5bbgx_bright_p2[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F120040,
};

/*=================================
	CAMERA_BRIGHTNESS_8 (8/9) P3
==================================*/
static const u32 s5k5bbgx_bright_p3[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F120060,
};

/*=================================
	CAMERA_BRIGHTNESS_9 (9/9) P4
==================================*/
static const u32 s5k5bbgx_bright_p4[] = {
	0xFCFCD000,
	0x00287000,
	0x002A012A,
	0x0F120080,
};

/*******************************************************
* CAMERA_VT_PRETTY_0 Default
* 200s self cam	pretty
*******************************************************/
static const u32 s5k5bbgx_vt_pretty_default[] = {
	/* 0xffff000A, */
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120018,
	0x0F12005A,
	0x0F1200DF,
	0x0F12013F,
	0x0F120186,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120018,
	0x0F12005A,
	0x0F1200DF,
	0x0F12013F,
	0x0F120186,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120018,
	0x0F12005A,
	0x0F1200DF,
	0x0F12013F,
	0x0F120186,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,
};


/*******************************************************
*	CAMERA_VT_PRETTY_1
*******************************************************/
static const u32 s5k5bbgx_vt_pretty_1[]	= {
	/*0xffff000A,*/
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000,
	0x0F12000D,
	0x0F12001B,
	0x0F120046,
	0x0F1200AA,
	0x0F120120,
	0x0F120190,
	0x0F1201E0,
	0x0F120250,
	0x0F1202A5,
	0x0F120320,
	0x0F120370,
	0x0F1203B0,
	0x0F1203D8,
	0x0F1203F2,
	0x0F120400,

	0x0F120000,
	0x0F12000D,
	0x0F12001B,
	0x0F120046,
	0x0F1200AA,
	0x0F120120,
	0x0F120190,
	0x0F1201E0,
	0x0F120250,
	0x0F1202A5,
	0x0F120320,
	0x0F120370,
	0x0F1203B0,
	0x0F1203D8,
	0x0F1203F2,
	0x0F120400,

	0x0F120000,
	0x0F12000D,
	0x0F12001B,
	0x0F120046,
	0x0F1200AA,
	0x0F120120,
	0x0F120190,
	0x0F1201E0,
	0x0F120250,
	0x0F1202A5,
	0x0F120320,
	0x0F120370,
	0x0F1203B0,
	0x0F1203D8,
	0x0F1203F2,
	0x0F120400,
};


/*******************************************************
*	CAMERA_VT_PRETTY_2				*
*******************************************************/
static const u32 s5k5bbgx_vt_pretty_2[]	= {
	/* 0xffff000A, */
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000, /* 0000 */
	0x0F12000D, /* 000D */
	0x0F12001B, /* 001B */
	0x0F120055, /* 0050 */
	0x0F1200C0, /* 00B4 */
	0x0F120164, /* 0154 */
	0x0F1201C0, /* 01B8 */
	0x0F120220, /* 0212 */
	0x0F1202A0, /* 0294 */
	0x0F1202F0, /* 02E4 */
	0x0F120365, /* 0352 */
	0x0F1203A0, /* 0398 */
	0x0F1203D4, /* 03D4 */
	0x0F1203E8, /* 03E8 */
	0x0F1203F7, /* 03F7 */
	0x0F120400, /* 0400 */

	0x0F120000, /* 0000 */
	0x0F12000D, /* 000D */
	0x0F12001B, /* 001B */
	0x0F120055, /* 0050 */
	0x0F1200C0, /* 00B4 */
	0x0F120164, /* 0154 */
	0x0F1201C0, /* 01B8 */
	0x0F120220, /* 0212 */
	0x0F1202A0, /* 0294 */
	0x0F1202F0, /* 02E4 */
	0x0F120365, /* 0352 */
	0x0F1203A0, /* 0398 */
	0x0F1203D4, /* 03D4 */
	0x0F1203E8, /* 03E8 */
	0x0F1203F7, /* 03F7 */
	0x0F120400, /* 0400 */

	0x0F120000, /* 0000 */
	0x0F12000D, /* 000D */
	0x0F12001B, /* 001B */
	0x0F120055, /* 0050 */
	0x0F1200C0, /* 00B4 */
	0x0F120164, /* 0154 */
	0x0F1201C0, /* 01B8 */
	0x0F120220, /* 0212 */
	0x0F1202A0, /* 0294 */
	0x0F1202F0, /* 02E4 */
	0x0F120365, /* 0352 */
	0x0F1203A0, /* 0398 */
	0x0F1203D4, /* 03D4 */
	0x0F1203E8, /* 03E8 */
	0x0F1203F7, /* 03F7 */
	0x0F120400, /* 0400 */
};


/*******************************************************
*	CAMERA_VT_PRETTY_3
*******************************************************/
static const u32 s5k5bbgx_vt_pretty_3[]	= {
	/* 0xffff000A, */
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000, /* 0000, 0000,  */
	0x0F12000D, /* 000D, 000D,  */
	0x0F12001B, /* 001B, 001B,  */
	0x0F120064, /* 0064, 0064,  */
	0x0F1200E5, /* 00E5, 00DC,  */
	0x0F120190, /* 95, 0195, 0186,	*/
	0x0F1201F5, /* 01F5, 01EA,  */
	0x0F120260, /* 0265, 024E,  */
	0x0F1202E5, /* 02F0, 02DA,  */
	0x0F12032A, /* 30, 0335, 0320,	*/
	0x0F12038A, /* 90, 0395, 038E,	*/
	0x0F1203C5, /* CA, 03D0, 03CA, / */
	0x0F1203E0, /* E5, 03E8, 03E8,	*/
	0x0F1203EC, /* F0, 03F2, 03F2,	*/
	0x0F1203F7, /* 03F7, 03F7,  */
	0x0F120400, /* 0400, 0400,  */

	0x0F120000, /* 0000, 0000, 0000,  */
	0x0F12000D, /* 000D, 000D, 000D,  */
	0x0F12001B, /* 001B, 001B, 001B,  */
	0x0F120064, /* 0064, 0064, 0064,  */
	0x0F1200E5, /* 00E5, 00E5, 00DC,  */
	0x0F120190, /* 0195, 0195, 0186,  */
	0x0F1201F5, /* 01F5, 01F5, 01EA,  */
	0x0F120260, /* 0260, 0265, 024E,  */
	0x0F1202E5, /* 02E5, 02F0, 02DA,  */
	0x0F12032A, /* 0330, 0335, 0320,  */
	0x0F12038A, /* 0390, 0395, 038E,  */
	0x0F1203C5, /* 03CA, 03D0, 03CA,  */
	0x0F1203E0, /* 03E5, 03E8, 03E8,  */
	0x0F1203EC, /* 03F0, 03F2, 03F2,  */
	0x0F1203F7, /* 03F7, 03F7, 03F7,  */
	0x0F120400, /* 0400, 0400, 0400,  */

	0x0F120000, /* 0000, 0000, 0000,  */
	0x0F12000D, /* 000D, 000D, 000D,  */
	0x0F12001B, /* 001B, 001B, 001B,  */
	0x0F120064, /* 0064, 0064, 0064,  */
	0x0F1200E5, /* 00E5, 00E5, 00DC,  */
	0x0F120190, /* 0195, 0195, 0186,  */
	0x0F1201F5, /* 01F5, 01F5, 01EA,  */
	0x0F120260, /* 0260, 0265, 024E,  */
	0x0F1202E5, /* 02E5, 02F0, 02DA,  */
	0x0F12032A, /* 0330, 0335, 0320,  */
	0x0F12038A, /* 0390, 0395, 038E,  */
	0x0F1203C5, /* 03CA, 03D0, 03CA,  */
	0x0F1203E0, /* 03E5, 03E8, 03E8,  */
	0x0F1203EC, /* 03F0, 03F2, 03F2,  */
	0x0F1203F7, /* 03F7, 03F7, 03F7,  */
	0x0F120400, /* 0400, 0400, 0400,  */
};

static const u32 s5k5bbgx_vt_7fps[] = {
	/* Fixed 7fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120535, /* 7fps */
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */

	0xffff0096, /* delay 150ms */

	0x0028D000, /* mipi */
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bbgx_vt_10fps[] = {
	/*  Fixed 10fps	Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F1203E8, /* 10fps */
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync	*/
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged  */

	0xffff0096, /* delay 150ms */

	0x0028D000, /* mipi */
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bbgx_vt_12fps[] = {
	/*  Fixed 12fps	Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120341, /* 12fps */
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */

	0xffff0096, /* delay 150ms */

	0x0028D000, /* mipi */
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bbgx_vt_15fps[] = {
	/* Fixed 15fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F12029A, /* 15fps*/
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged  */

	0xffff0096, /* delay 150ms */

	0x0028D000, /*mipi */
	0x002AB0CC,
	0x0F12000B,
};

/*******************************************************
*	CAMERA_DTP_ON
*******************************************************/
static const u32 s5k5bbgx_pattern_on[] = {
	0xffff01f4, /* Delay 500ms*/

	0xFCFCD000,
	0x0028D000,
	0x002AB054,
	0x0F120005, /*5:8bit Mode, 1:10Bit Mode*/

	0xffff0032, /* Delay 50msec */
};

/*******************************************************
*	CAMERA_DTP_OFF
*******************************************************/
static const u32 s5k5bbgx_pattern_off[]	= {
	0xFCFCD000,
	0x0028D000,
	0x002AB054,
	0x0F120000,
};

#endif /* __S5K5BBGX_SETFILE_H */
