/*
 * Driver for S5K5BAFX 2M ISP from Samsung
 *
 * Copyright (C) 2011,
 * DongSeong Lim<dongseong.lim@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef __S5K5BAFX_SETFILE_H
#define __S5K5BAFX_SETFILE_H

#include <linux/types.h>

/*
 * s5k5bafx register configuration for combinations of initialization
 */
/* 2M mipi setting-common from PARTRON */
/*******************************************************
* Name		: S5K5BAFX Initial Setfile
* PLL mode	: MCLK=24MHz / SYSCLK=28MHz / PCLK=48MHz
* FPS		: VGA 7.5~15fps / UXGA 7.5fps / recording 25fps
* Made by	: ZEROHOY
* Date		: 2011.03.07
* History	:
*******************************************************/
static const u32 s5k5bafx_common[] = {
	/* Self-Cam */
	0xFCFCD000,

	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064,

	/* Trap and Patch */
	0x00287000,
	0x002A1668,
	0x0F12B5FE, /*70001668*/
	0x0F120007, /*7000166A*/
	0x0F12683C, /*7000166C*/
	0x0F12687E, /*7000166E*/
	0x0F121DA5, /*70001670*/
	0x0F1288A0, /*70001672*/
	0x0F122800, /*70001674*/
	0x0F12D00B, /*70001676*/
	0x0F1288A8, /*70001678*/
	0x0F122800, /*7000167A*/
	0x0F12D008, /*7000167C*/
	0x0F128820, /*7000167E*/
	0x0F128829, /*70001680*/
	0x0F124288, /*70001682*/
	0x0F12D301, /*70001684*/
	0x0F121A40, /*70001686*/
	0x0F12E000, /*70001688*/
	0x0F121A08, /*7000168A*/
	0x0F129001, /*7000168C*/
	0x0F12E001, /*7000168E*/
	0x0F122019, /*70001690*/
	0x0F129001, /*70001692*/
	0x0F124916, /*70001694*/
	0x0F12466B, /*70001696*/
	0x0F128A48, /*70001698*/
	0x0F128118, /*7000169A*/
	0x0F128A88, /*7000169C*/
	0x0F128158, /*7000169E*/
	0x0F124814, /*700016A0*/
	0x0F128940, /*700016A2*/
	0x0F120040, /*700016A4*/
	0x0F122103, /*700016A6*/
	0x0F12F000, /*700016A8*/
	0x0F12F826, /*700016AA*/
	0x0F1288A1, /*700016AC*/
	0x0F124288, /*700016AE*/
	0x0F12D908, /*700016B0*/
	0x0F128828, /*700016B2*/
	0x0F128030, /*700016B4*/
	0x0F128868, /*700016B6*/
	0x0F128070, /*700016B8*/
	0x0F1288A8, /*700016BA*/
	0x0F126038, /*700016BC*/
	0x0F12BCFE, /*700016BE*/
	0x0F12BC08, /*700016C0*/
	0x0F124718, /*700016C2*/
	0x0F1288A9, /*700016C4*/
	0x0F124288, /*700016C6*/
	0x0F12D906, /*700016C8*/
	0x0F128820, /*700016CA*/
	0x0F128030, /*700016CC*/
	0x0F128860, /*700016CE*/
	0x0F128070, /*700016D0*/
	0x0F1288A0, /*700016D2*/
	0x0F126038, /*700016D4*/
	0x0F12E7F2, /*700016D6*/
	0x0F129801, /*700016D8*/
	0x0F12A902, /*700016DA*/
	0x0F12F000, /*700016DC*/
	0x0F12F812, /*700016DE*/
	0x0F120033, /*700016E0*/
	0x0F120029, /*700016E2*/
	0x0F129A02, /*700016E4*/
	0x0F120020, /*700016E6*/
	0x0F12F000, /*700016E8*/
	0x0F12F814, /*700016EA*/
	0x0F126038, /*700016EC*/
	0x0F12E7E6, /*700016EE*/
	0x0F121A28, /*700016F0*/
	0x0F127000, /*700016F2*/
	0x0F120D64, /*700016F4*/
	0x0F127000, /*700016F6*/
	0x0F124778, /*700016F8*/
	0x0F1246C0, /*700016FA*/
	0x0F12F004, /*700016FC*/
	0x0F12E51F, /*700016FE*/
	0x0F12A464, /*70001700*/
	0x0F120000, /*70001702*/
	0x0F124778, /*70001704*/
	0x0F1246C0, /*70001706*/
	0x0F12C000, /*70001708*/
	0x0F12E59F, /*7000170A*/
	0x0F12FF1C, /*7000170C*/
	0x0F12E12F, /*7000170E*/
	0x0F126009, /*70001710*/
	0x0F120000, /*70001712*/
	0x0F124778, /*70001714*/
	0x0F1246C0, /*70001716*/
	0x0F12C000, /*70001718*/
	0x0F12E59F, /*7000171A*/
	0x0F12FF1C, /*7000171C*/
	0x0F12E12F, /*7000171E*/
	0x0F12622F, /*70001720*/
	0x0F120000, /*70001722*/
	0x002A2080,
	0x0F12B510, /*70002080*/
	0x0F12F000, /*70002082*/
	0x0F12F8F4, /*70002084*/
	0x0F12BC10, /*70002086*/
	0x0F12BC08, /*70002088*/
	0x0F124718, /*7000208A*/
	0x0F12B5F0, /*7000208C*/
	0x0F12B08B, /*7000208E*/
	0x0F120006, /*70002090*/
	0x0F122000, /*70002092*/
	0x0F129004, /*70002094*/
	0x0F126835, /*70002096*/
	0x0F126874, /*70002098*/
	0x0F1268B0, /*7000209A*/
	0x0F12900A, /*7000209C*/
	0x0F1268F0, /*7000209E*/
	0x0F129009, /*700020A0*/
	0x0F124F7D, /*700020A2*/
	0x0F128979, /*700020A4*/
	0x0F12084A, /*700020A6*/
	0x0F1288A8, /*700020A8*/
	0x0F1288A3, /*700020AA*/
	0x0F124298, /*700020AC*/
	0x0F12D300, /*700020AE*/
	0x0F120018, /*700020B0*/
	0x0F12F000, /*700020B2*/
	0x0F12F907, /*700020B4*/
	0x0F129007, /*700020B6*/
	0x0F120021, /*700020B8*/
	0x0F120028, /*700020BA*/
	0x0F12AA04, /*700020BC*/
	0x0F12F000, /*700020BE*/
	0x0F12F909, /*700020C0*/
	0x0F129006, /*700020C2*/
	0x0F1288A8, /*700020C4*/
	0x0F122800, /*700020C6*/
	0x0F12D102, /*700020C8*/
	0x0F1227FF, /*700020CA*/
	0x0F121C7F, /*700020CC*/
	0x0F12E047, /*700020CE*/
	0x0F1288A0, /*700020D0*/
	0x0F122800, /*700020D2*/
	0x0F12D101, /*700020D4*/
	0x0F122700, /*700020D6*/
	0x0F12E042, /*700020D8*/
	0x0F128820, /*700020DA*/
	0x0F12466B, /*700020DC*/
	0x0F128198, /*700020DE*/
	0x0F128860, /*700020E0*/
	0x0F1281D8, /*700020E2*/
	0x0F128828, /*700020E4*/
	0x0F128118, /*700020E6*/
	0x0F128868, /*700020E8*/
	0x0F128158, /*700020EA*/
	0x0F12A802, /*700020EC*/
	0x0F12C803, /*700020EE*/
	0x0F12F000, /*700020F0*/
	0x0F12F8F8, /*700020F2*/
	0x0F129008, /*700020F4*/
	0x0F128ABA, /*700020F6*/
	0x0F129808, /*700020F8*/
	0x0F12466B, /*700020FA*/
	0x0F124342, /*700020FC*/
	0x0F129202, /*700020FE*/
	0x0F128820, /*70002100*/
	0x0F128198, /*70002102*/
	0x0F128860, /*70002104*/
	0x0F1281D8, /*70002106*/
	0x0F12980A, /*70002108*/
	0x0F129903, /*7000210A*/
	0x0F12F000, /*7000210C*/
	0x0F12F8EA, /*7000210E*/
	0x0F129A02, /*70002110*/
	0x0F1217D1, /*70002112*/
	0x0F120E09, /*70002114*/
	0x0F121889, /*70002116*/
	0x0F121209, /*70002118*/
	0x0F124288, /*7000211A*/
	0x0F12DD1F, /*7000211C*/
	0x0F128820, /*7000211E*/
	0x0F12466B, /*70002120*/
	0x0F128198, /*70002122*/
	0x0F128860, /*70002124*/
	0x0F1281D8, /*70002126*/
	0x0F12980A, /*70002128*/
	0x0F129903, /*7000212A*/
	0x0F12F000, /*7000212C*/
	0x0F12F8DA, /*7000212E*/
	0x0F129001, /*70002130*/
	0x0F128828, /*70002132*/
	0x0F12466B, /*70002134*/
	0x0F128118, /*70002136*/
	0x0F128868, /*70002138*/
	0x0F128158, /*7000213A*/
	0x0F12980A, /*7000213C*/
	0x0F129902, /*7000213E*/
	0x0F12F000, /*70002140*/
	0x0F12F8D0, /*70002142*/
	0x0F128AB9, /*70002144*/
	0x0F129A08, /*70002146*/
	0x0F124351, /*70002148*/
	0x0F1217CA, /*7000214A*/
	0x0F120E12, /*7000214C*/
	0x0F121851, /*7000214E*/
	0x0F12120A, /*70002150*/
	0x0F129901, /*70002152*/
	0x0F12F000, /*70002154*/
	0x0F12F8B6, /*70002156*/
	0x0F120407, /*70002158*/
	0x0F120C3F, /*7000215A*/
	0x0F12E000, /*7000215C*/
	0x0F122700, /*7000215E*/
	0x0F128820, /*70002160*/
	0x0F12466B, /*70002162*/
	0x0F12AA05, /*70002164*/
	0x0F128198, /*70002166*/
	0x0F128860, /*70002168*/
	0x0F1281D8, /*7000216A*/
	0x0F128828, /*7000216C*/
	0x0F128118, /*7000216E*/
	0x0F128868, /*70002170*/
	0x0F128158, /*70002172*/
	0x0F12A802, /*70002174*/
	0x0F12C803, /*70002176*/
	0x0F12003B, /*70002178*/
	0x0F12F000, /*7000217A*/
	0x0F12F8BB, /*7000217C*/
	0x0F1288A1, /*7000217E*/
	0x0F1288A8, /*70002180*/
	0x0F12003A, /*70002182*/
	0x0F12F000, /*70002184*/
	0x0F12F8BE, /*70002186*/
	0x0F120004, /*70002188*/
	0x0F12A804, /*7000218A*/
	0x0F12C803, /*7000218C*/
	0x0F129A09, /*7000218E*/
	0x0F129B07, /*70002190*/
	0x0F12F000, /*70002192*/
	0x0F12F8AF, /*70002194*/
	0x0F12A806, /*70002196*/
	0x0F12C805, /*70002198*/
	0x0F120021, /*7000219A*/
	0x0F12F000, /*7000219C*/
	0x0F12F8B2, /*7000219E*/
	0x0F126030, /*700021A0*/
	0x0F12B00B, /*700021A2*/
	0x0F12BCF0, /*700021A4*/
	0x0F12BC08, /*700021A6*/
	0x0F124718, /*700021A8*/
	0x0F12B5F1, /*700021AA*/
	0x0F129900, /*700021AC*/
	0x0F12680C, /*700021AE*/
	0x0F12493A, /*700021B0*/
	0x0F12694B, /*700021B2*/
	0x0F12698A, /*700021B4*/
	0x0F124694, /*700021B6*/
	0x0F1269CD, /*700021B8*/
	0x0F126A0E, /*700021BA*/
	0x0F124F38, /*700021BC*/
	0x0F1242BC, /*700021BE*/
	0x0F12D800, /*700021C0*/
	0x0F120027, /*700021C2*/
	0x0F124937, /*700021C4*/
	0x0F126B89, /*700021C6*/
	0x0F120409, /*700021C8*/
	0x0F120C09, /*700021CA*/
	0x0F124A35, /*700021CC*/
	0x0F121E92, /*700021CE*/
	0x0F126BD2, /*700021D0*/
	0x0F120412, /*700021D2*/
	0x0F120C12, /*700021D4*/
	0x0F12429F, /*700021D6*/
	0x0F12D801, /*700021D8*/
	0x0F120020, /*700021DA*/
	0x0F12E031, /*700021DC*/
	0x0F12001F, /*700021DE*/
	0x0F12434F, /*700021E0*/
	0x0F120A3F, /*700021E2*/
	0x0F1242A7, /*700021E4*/
	0x0F12D301, /*700021E6*/
	0x0F120018, /*700021E8*/
	0x0F12E02A, /*700021EA*/
	0x0F12002B, /*700021EC*/
	0x0F12434B, /*700021EE*/
	0x0F120A1B, /*700021F0*/
	0x0F1242A3, /*700021F2*/
	0x0F12D303, /*700021F4*/
	0x0F120220, /*700021F6*/
	0x0F12F000, /*700021F8*/
	0x0F12F88C, /*700021FA*/
	0x0F12E021, /*700021FC*/
	0x0F120029, /*700021FE*/
	0x0F124351, /*70002200*/
	0x0F120A09, /*70002202*/
	0x0F1242A1, /*70002204*/
	0x0F12D301, /*70002206*/
	0x0F120028, /*70002208*/
	0x0F12E01A, /*7000220A*/
	0x0F120031, /*7000220C*/
	0x0F124351, /*7000220E*/
	0x0F120A09, /*70002210*/
	0x0F1242A1, /*70002212*/
	0x0F12D304, /*70002214*/
	0x0F120220, /*70002216*/
	0x0F120011, /*70002218*/
	0x0F12F000, /*7000221A*/
	0x0F12F87B, /*7000221C*/
	0x0F12E010, /*7000221E*/
	0x0F12491E, /*70002220*/
	0x0F128C89, /*70002222*/
	0x0F12000A, /*70002224*/
	0x0F124372, /*70002226*/
	0x0F120A12, /*70002228*/
	0x0F1242A2, /*7000222A*/
	0x0F12D301, /*7000222C*/
	0x0F120030, /*7000222E*/
	0x0F12E007, /*70002230*/
	0x0F124662, /*70002232*/
	0x0F12434A, /*70002234*/
	0x0F120A12, /*70002236*/
	0x0F1242A2, /*70002238*/
	0x0F12D302, /*7000223A*/
	0x0F120220, /*7000223C*/
	0x0F12F000, /*7000223E*/
	0x0F12F869, /*70002240*/
	0x0F124B16, /*70002242*/
	0x0F124D18, /*70002244*/
	0x0F128D99, /*70002246*/
	0x0F121FCA, /*70002248*/
	0x0F123AF9, /*7000224A*/
	0x0F12D00A, /*7000224C*/
	0x0F122001, /*7000224E*/
	0x0F120240, /*70002250*/
	0x0F128468, /*70002252*/
	0x0F120220, /*70002254*/
	0x0F12F000, /*70002256*/
	0x0F12F85D, /*70002258*/
	0x0F129900, /*7000225A*/
	0x0F126008, /*7000225C*/
	0x0F12BCF8, /*7000225E*/
	0x0F12BC08, /*70002260*/
	0x0F124718, /*70002262*/
	0x0F128D19, /*70002264*/
	0x0F128469, /*70002266*/
	0x0F129900, /*70002268*/
	0x0F126008, /*7000226A*/
	0x0F12E7F7, /*7000226C*/
	0x0F12B570, /*7000226E*/
	0x0F122200, /*70002270*/
	0x0F12490E, /*70002272*/
	0x0F12480E, /*70002274*/
	0x0F122401, /*70002276*/
	0x0F12F000, /*70002278*/
	0x0F12F852, /*7000227A*/
	0x0F120022, /*7000227C*/
	0x0F12490D, /*7000227E*/
	0x0F12480D, /*70002280*/
	0x0F122502, /*70002282*/
	0x0F12F000, /*70002284*/
	0x0F12F84C, /*70002286*/
	0x0F12490C, /*70002288*/
	0x0F12480D, /*7000228A*/
	0x0F12002A, /*7000228C*/
	0x0F12F000, /*7000228E*/
	0x0F12F847, /*70002290*/
	0x0F12BC70, /*70002292*/
	0x0F12BC08, /*70002294*/
	0x0F124718, /*70002296*/
	0x0F120D64, /*70002298*/
	0x0F127000, /*7000229A*/
	0x0F120470, /*7000229C*/
	0x0F127000, /*7000229E*/
	0x0F12A120, /*700022A0*/
	0x0F120007, /*700022A2*/
	0x0F120402, /*700022A4*/
	0x0F127000, /*700022A6*/
	0x0F1214A0, /*700022A8*/
	0x0F127000, /*700022AA*/
	0x0F12208D, /*700022AC*/
	0x0F127000, /*700022AE*/
	0x0F12622F, /*700022B0*/
	0x0F120000, /*700022B2*/
	0x0F121669, /*700022B4*/
	0x0F127000, /*700022B6*/
	0x0F126445, /*700022B8*/
	0x0F120000, /*700022BA*/
	0x0F1221AB, /*700022BC*/
	0x0F127000, /*700022BE*/
	0x0F122AA9, /*700022C0*/
	0x0F120000, /*700022C2*/
	0x0F124778, /*700022C4*/
	0x0F1246C0, /*700022C6*/
	0x0F12C000, /*700022C8*/
	0x0F12E59F, /*700022CA*/
	0x0F12FF1C, /*700022CC*/
	0x0F12E12F, /*700022CE*/
	0x0F125F49, /*700022D0*/
	0x0F120000, /*700022D2*/
	0x0F124778, /*700022D4*/
	0x0F1246C0, /*700022D6*/
	0x0F12C000, /*700022D8*/
	0x0F12E59F, /*700022DA*/
	0x0F12FF1C, /*700022DC*/
	0x0F12E12F, /*700022DE*/
	0x0F125FC7, /*700022E0*/
	0x0F120000, /*700022E2*/
	0x0F124778, /*700022E4*/
	0x0F1246C0, /*700022E6*/
	0x0F12C000, /*700022E8*/
	0x0F12E59F, /*700022EA*/
	0x0F12FF1C, /*700022EC*/
	0x0F12E12F, /*700022EE*/
	0x0F125457, /*700022F0*/
	0x0F120000, /*700022F2*/
	0x0F124778, /*700022F4*/
	0x0F1246C0, /*700022F6*/
	0x0F12C000, /*700022F8*/
	0x0F12E59F, /*700022FA*/
	0x0F12FF1C, /*700022FC*/
	0x0F12E12F, /*700022FE*/
	0x0F125FA3, /*70002300*/
	0x0F120000, /*70002302*/
	0x0F124778, /*70002304*/
	0x0F1246C0, /*70002306*/
	0x0F12C000, /*70002308*/
	0x0F12E59F, /*7000230A*/
	0x0F12FF1C, /*7000230C*/
	0x0F12E12F, /*7000230E*/
	0x0F1251F9, /*70002310*/
	0x0F120000, /*70002312*/
	0x0F124778, /*70002314*/
	0x0F1246C0, /*70002316*/
	0x0F12F004, /*70002318*/
	0x0F12E51F, /*7000231A*/
	0x0F12A464, /*7000231C*/
	0x0F120000, /*7000231E*/
	0x0F124778, /*70002320*/
	0x0F1246C0, /*70002322*/
	0x0F12C000, /*70002324*/
	0x0F12E59F, /*70002326*/
	0x0F12FF1C, /*70002328*/
	0x0F12E12F, /*7000232A*/
	0x0F12A007, /*7000232C*/
	0x0F120000, /*7000232E*/
	0x0F126546, /*70002330*/
	0x0F122062, /*70002332*/
	0x0F123120, /*70002334*/
	0x0F123220, /*70002336*/
	0x0F123130, /*70002338*/
	0x0F120030, /*7000233A*/
	0x0F12E010, /*7000233C*/
	0x0F120208, /*7000233E*/
	0x0F120058, /*70002340*/
	0x0F120000, /*70002342*/
	/* End of Trap and Patch
	Total Size 896 (0x0380)*/

	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0,
	0x002A0AE2,
	0x0F12222E,

	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	0x002A049A,
	0x0F1200FA,

	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,

	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,

	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,

	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,

	0x0F120015,

	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,

	0x002AF900,
	0x0F120067,

	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,

	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,

	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,

	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,

	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,

	0x002AF4D6,
	0x0F120090,

	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,

	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller*/
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,

	0x002A10EE,
	0x0F120000,

	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,

	0x002A1150,
	0x0F1201F4,


	0x002A1084,
	0x0F120000,
	0x0F120000,

	/* Set AE Target */
	0x002A0F4C,
	0x0F12003A,

	0x002A0478,
	0x0F120114,
	0x0F1200EB,

	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A,
	0x0F120000,
	0x002A048C,
	0x0F128214,
	0x0F120000,
	0x0F12A122,
	0x0F120000,
	0x002A0488,
	0x0F12f424,
	0x0F120000,
	0x002A043A,
	0x0F1201D0,
	0x0F1201E0,
	0x002A0494,
	0x0F120300,
	0x0F120600,
	0x0f120100,
	0x002A0F52,
	0x0F12000F,

	0x002A0E98,
	0x0F1202A8,
	0x002A0E9E,
	0x0F120298,

	/*1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001,
	0x002A03F8,
	0x0F12007F,

	0xffff000a, /* Wait10mSec */

	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0,
	0x0F120000,

	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001,
	0x0F120001,
	0x0F120000,

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770,
	0x0F122EE0,
	0x0F122EE0,

	/* System Clock 1 (System : 28Mhz, PCLK : 48Mhz)*/
	0x002A01D2,
	0x0F121B58,
	0x0F122EE0,
	0x0F122EE0,

	0x002A01DE,
	0x0F120001,
	0x0F120001,
	0xffff0064, /* 100ms Delay */

	/* Crop */
	0x002A01FA,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,

	/* Set Preview Config */
	/* Preview Config 0 (1600x1200 fixed 15fps)*/
	0x002A0242,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F120535,
	0x0F12029A,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps)*/
	0x002A0268,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F12029A,
	0x0F12014D,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	/* Set MIPI */
	0x002A03AC,
	0x0F120000,
	0x002A03F2,
	0x0F120001,
	0x0F1200C3,
	0x0F120001,

	/* Apply preview config */
	0x002A021C,
	0x0F120000,
	0x002A0220,
	0x0F120001,
	0x002A01F8,
	0x0F120001,
	0x002A021E,
	0x0F120001,
	0x002A01F0,
	0x0F120001,
	0x0F120001,

	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000,
	0x0F120640,
	0x0F1204B0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120002,
	0x0F120002,
	0x0F120535,
	0x0F120535,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A07C0,
	0x0F120004,
	0x0F120004,

	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,

	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120302,
	0x0F120203,
	0x0F120101,
	0x0F120101,
	0x0F120403,
	0x0F120304,
	0x0F120101,
	0x0F120101,
	0x0F120403,
	0x0F120304,
	0x0F120101,
	0x0F120101,
	0x0F120302,
	0x0F120203,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord*/
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,

	/* param_start	wbt_AwbCcmCord*/
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,


	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,

	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */

	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */

	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */

	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */

	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */

	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */

	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */

	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120108, /* 100 TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_ */

	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,

	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120160,
	0x0F120134,
	0x0F1200FF,
	0x0F1200D1,
	0x0F1200B1,
	0x0F12009D,
	0x0F120096,
	0x0F12009E,
	0x0F1200B3,
	0x0F1200D3,
	0x0F1200FF,
	0x0F120131,
	0x0F120159,
	0x0F12013C,
	0x0F120107,
	0x0F1200CD,
	0x0F1200A1,
	0x0F120080,
	0x0F12006B,
	0x0F120064,
	0x0F12006C,
	0x0F120080,
	0x0F1200A1,
	0x0F1200CD,
	0x0F120106,
	0x0F120139,
	0x0F120116,
	0x0F1200DC,
	0x0F1200A2,
	0x0F120073,
	0x0F120051,
	0x0F12003B,
	0x0F120033,
	0x0F12003B,
	0x0F120050,
	0x0F120073,
	0x0F1200A2,
	0x0F1200DD,
	0x0F120115,
	0x0F1200FA,
	0x0F1200BF,
	0x0F120085,
	0x0F120055,
	0x0F120031,
	0x0F12001B,
	0x0F120014,
	0x0F12001A,
	0x0F120031,
	0x0F120055,
	0x0F120085,
	0x0F1200C0,
	0x0F1200FB,
	0x0F1200EA,
	0x0F1200AF,
	0x0F120074,
	0x0F120045,
	0x0F120020,
	0x0F12000B,
	0x0F120003,
	0x0F12000A,
	0x0F120020,
	0x0F120046,
	0x0F120076,
	0x0F1200B1,
	0x0F1200ED,
	0x0F1200E6,
	0x0F1200AA,
	0x0F120071,
	0x0F120041,
	0x0F12001D,
	0x0F120008,
	0x0F120000,
	0x0F120007,
	0x0F12001E,
	0x0F120044,
	0x0F120074,
	0x0F1200B0,
	0x0F1200EC,
	0x0F1200EF,
	0x0F1200B3,
	0x0F12007A,
	0x0F12004A,
	0x0F120026,
	0x0F120011,
	0x0F12000A,
	0x0F120011,
	0x0F120029,
	0x0F12004F,
	0x0F120080,
	0x0F1200BC,
	0x0F1200F8,
	0x0F120105,
	0x0F1200C9,
	0x0F12008F,
	0x0F120060,
	0x0F12003C,
	0x0F120026,
	0x0F12001F,
	0x0F120028,
	0x0F120040,
	0x0F120066,
	0x0F120097,
	0x0F1200D4,
	0x0F120110,
	0x0F120124,
	0x0F1200EB,
	0x0F1200B1,
	0x0F120082,
	0x0F12005F,
	0x0F12004A,
	0x0F120043,
	0x0F12004C,
	0x0F120064,
	0x0F120089,
	0x0F1200BA,
	0x0F1200F8,
	0x0F12012F,
	0x0F120147,
	0x0F120116,
	0x0F1200DE,
	0x0F1200AF,
	0x0F12008E,
	0x0F12007A,
	0x0F120072,
	0x0F12007A,
	0x0F120091,
	0x0F1200B6,
	0x0F1200E8,
	0x0F120121,
	0x0F120150,
	0x0F120170,
	0x0F12013F,
	0x0F120110,
	0x0F1200E2,
	0x0F1200C0,
	0x0F1200AB,
	0x0F1200A4,
	0x0F1200AC,
	0x0F1200C3,
	0x0F1200E6,
	0x0F120117,
	0x0F120145,
	0x0F120172,
	0x0F120127,
	0x0F120100,
	0x0F1200CF,
	0x0F1200A7,
	0x0F12008D,
	0x0F12007D,
	0x0F120077,
	0x0F12007A,
	0x0F120087,
	0x0F12009E,
	0x0F1200C0,
	0x0F1200EC,
	0x0F12010F,
	0x0F120108,
	0x0F1200D8,
	0x0F1200A5,
	0x0F120080,
	0x0F120066,
	0x0F120056,
	0x0F12004F,
	0x0F120053,
	0x0F120061,
	0x0F120077,
	0x0F120098,
	0x0F1200C6,
	0x0F1200F3,
	0x0F1200E7,
	0x0F1200B4,
	0x0F120081,
	0x0F12005C,
	0x0F120041,
	0x0F120030,
	0x0F120029,
	0x0F12002E,
	0x0F12003D,
	0x0F120055,
	0x0F120076,
	0x0F1200A5,
	0x0F1200D4,
	0x0F1200CF,
	0x0F12009B,
	0x0F12006A,
	0x0F120043,
	0x0F120027,
	0x0F120016,
	0x0F12000F,
	0x0F120015,
	0x0F120025,
	0x0F12003E,
	0x0F120061,
	0x0F12008E,
	0x0F1200BF,
	0x0F1200C2,
	0x0F12008E,
	0x0F12005D,
	0x0F120037,
	0x0F12001A,
	0x0F120009,
	0x0F120002,
	0x0F120007,
	0x0F120018,
	0x0F120033,
	0x0F120057,
	0x0F120083,
	0x0F1200B3,
	0x0F1200BE,
	0x0F12008A,
	0x0F12005A,
	0x0F120034,
	0x0F120017,
	0x0F120006,
	0x0F120000,
	0x0F120006,
	0x0F120017,
	0x0F120033,
	0x0F120057,
	0x0F120083,
	0x0F1200B3,
	0x0F1200C5,
	0x0F120091,
	0x0F120061,
	0x0F12003B,
	0x0F120020,
	0x0F12000F,
	0x0F120009,
	0x0F120010,
	0x0F120021,
	0x0F12003D,
	0x0F120060,
	0x0F12008D,
	0x0F1200BE,
	0x0F1200D7,
	0x0F1200A2,
	0x0F120072,
	0x0F12004D,
	0x0F120032,
	0x0F120022,
	0x0F12001D,
	0x0F120024,
	0x0F120035,
	0x0F120050,
	0x0F120073,
	0x0F1200A0,
	0x0F1200D2,
	0x0F1200F0,
	0x0F1200BE,
	0x0F12008C,
	0x0F120068,
	0x0F12004F,
	0x0F120040,
	0x0F12003B,
	0x0F120041,
	0x0F120052,
	0x0F12006C,
	0x0F12008E,
	0x0F1200BE,
	0x0F1200ED,
	0x0F12010C,
	0x0F1200E1,
	0x0F1200AF,
	0x0F12008A,
	0x0F120072,
	0x0F120064,
	0x0F12005F,
	0x0F120065,
	0x0F120074,
	0x0F12008D,
	0x0F1200B2,
	0x0F1200E0,
	0x0F12010A,
	0x0F12012F,
	0x0F120104,
	0x0F1200D9,
	0x0F1200B3,
	0x0F120099,
	0x0F12008B,
	0x0F120086,
	0x0F12008B,
	0x0F12009B,
	0x0F1200B5,
	0x0F1200DA,
	0x0F120101,
	0x0F120128,
	0x0F12012F,
	0x0F120106,
	0x0F1200D4,
	0x0F1200AA,
	0x0F12008E,
	0x0F12007D,
	0x0F120079,
	0x0F120080,
	0x0F120093,
	0x0F1200B1,
	0x0F1200DC,
	0x0F12010C,
	0x0F120130,
	0x0F120112,
	0x0F1200E0,
	0x0F1200AB,
	0x0F120083,
	0x0F120067,
	0x0F120057,
	0x0F120051,
	0x0F120059,
	0x0F12006B,
	0x0F120089,
	0x0F1200B2,
	0x0F1200E5,
	0x0F120114,
	0x0F1200F2,
	0x0F1200BD,
	0x0F120088,
	0x0F120061,
	0x0F120044,
	0x0F120031,
	0x0F12002C,
	0x0F120033,
	0x0F120047,
	0x0F120065,
	0x0F12008C,
	0x0F1200C0,
	0x0F1200F3,
	0x0F1200DB,
	0x0F1200A5,
	0x0F120071,
	0x0F120049,
	0x0F12002A,
	0x0F120018,
	0x0F120011,
	0x0F120018,
	0x0F12002C,
	0x0F12004B,
	0x0F120072,
	0x0F1200A3,
	0x0F1200D7,
	0x0F1200CD,
	0x0F120097,
	0x0F120065,
	0x0F12003C,
	0x0F12001D,
	0x0F12000A,
	0x0F120003,
	0x0F120009,
	0x0F12001D,
	0x0F12003B,
	0x0F120063,
	0x0F120092,
	0x0F1200C4,
	0x0F1200CA,
	0x0F120094,
	0x0F120062,
	0x0F12003A,
	0x0F12001A,
	0x0F120007,
	0x0F120000,
	0x0F120006,
	0x0F120018,
	0x0F120036,
	0x0F12005C,
	0x0F12008A,
	0x0F1200BC,
	0x0F1200D1,
	0x0F12009B,
	0x0F120069,
	0x0F120042,
	0x0F120022,
	0x0F12000F,
	0x0F120008,
	0x0F12000D,
	0x0F12001F,
	0x0F12003B,
	0x0F120060,
	0x0F12008D,
	0x0F1200BF,
	0x0F1200E3,
	0x0F1200AC,
	0x0F12007A,
	0x0F120053,
	0x0F120035,
	0x0F120022,
	0x0F12001B,
	0x0F12001F,
	0x0F120030,
	0x0F12004B,
	0x0F12006D,
	0x0F12009C,
	0x0F1200CE,
	0x0F1200FE,
	0x0F1200C9,
	0x0F120095,
	0x0F12006F,
	0x0F120052,
	0x0F120040,
	0x0F120039,
	0x0F12003D,
	0x0F12004B,
	0x0F120063,
	0x0F120086,
	0x0F1200B5,
	0x0F1200E6,
	0x0F12011B,
	0x0F1200ED,
	0x0F1200BA,
	0x0F120092,
	0x0F120076,
	0x0F120065,
	0x0F12005D,
	0x0F120060,
	0x0F12006D,
	0x0F120084,
	0x0F1200A8,
	0x0F1200D6,
	0x0F120101,
	0x0F120140,
	0x0F120112,
	0x0F1200E5,
	0x0F1200BD,
	0x0F12009E,
	0x0F12008C,
	0x0F120085,
	0x0F120087,
	0x0F120094,
	0x0F1200AC,
	0x0F1200D0,
	0x0F1200F8,
	0x0F120123,
	0x0F1200F2,
	0x0F1200D1,
	0x0F1200A7,
	0x0F120087,
	0x0F120073,
	0x0F120067,
	0x0F120064,
	0x0F12006B,
	0x0F12007C,
	0x0F120094,
	0x0F1200B7,
	0x0F1200E1,
	0x0F1200FF,
	0x0F1200D6,
	0x0F1200AE,
	0x0F120085,
	0x0F120068,
	0x0F120054,
	0x0F120048,
	0x0F120045,
	0x0F12004B,
	0x0F12005B,
	0x0F120073,
	0x0F120093,
	0x0F1200BF,
	0x0F1200E9,
	0x0F1200B8,
	0x0F12008E,
	0x0F120066,
	0x0F120049,
	0x0F120035,
	0x0F120028,
	0x0F120025,
	0x0F12002B,
	0x0F12003B,
	0x0F120053,
	0x0F120072,
	0x0F12009D,
	0x0F1200C8,
	0x0F1200A2,
	0x0F120078,
	0x0F120051,
	0x0F120034,
	0x0F12001F,
	0x0F120012,
	0x0F12000E,
	0x0F120014,
	0x0F120024,
	0x0F12003B,
	0x0F12005B,
	0x0F120083,
	0x0F1200AD,
	0x0F120095,
	0x0F12006C,
	0x0F120046,
	0x0F12002A,
	0x0F120014,
	0x0F120007,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F12002D,
	0x0F12004C,
	0x0F120072,
	0x0F12009B,
	0x0F120093,
	0x0F12006A,
	0x0F120045,
	0x0F120028,
	0x0F120013,
	0x0F120005,
	0x0F120000,
	0x0F120004,
	0x0F120012,
	0x0F120028,
	0x0F120045,
	0x0F12006A,
	0x0F120093,
	0x0F12009B,
	0x0F120071,
	0x0F12004C,
	0x0F120030,
	0x0F12001A,
	0x0F12000C,
	0x0F120007,
	0x0F12000B,
	0x0F120018,
	0x0F12002C,
	0x0F120048,
	0x0F12006D,
	0x0F120097,
	0x0F1200AE,
	0x0F120083,
	0x0F12005C,
	0x0F120040,
	0x0F12002B,
	0x0F12001E,
	0x0F120018,
	0x0F12001C,
	0x0F120027,
	0x0F12003A,
	0x0F120055,
	0x0F12007B,
	0x0F1200A6,
	0x0F1200CA,
	0x0F12009E,
	0x0F120076,
	0x0F120059,
	0x0F120046,
	0x0F120039,
	0x0F120033,
	0x0F120036,
	0x0F120040,
	0x0F120052,
	0x0F12006C,
	0x0F120094,
	0x0F1200BF,
	0x0F1200EB,
	0x0F1200C3,
	0x0F120099,
	0x0F12007A,
	0x0F120066,
	0x0F12005A,
	0x0F120054,
	0x0F120056,
	0x0F12005F,
	0x0F120071,
	0x0F12008D,
	0x0F1200B6,
	0x0F1200DE,
	0x0F12010D,
	0x0F1200E7,
	0x0F1200C1,
	0x0F1200A0,
	0x0F12008A,
	0x0F12007C,
	0x0F120076,
	0x0F120078,
	0x0F120081,
	0x0F120093,
	0x0F1200B1,
	0x0F1200D5,
	0x0F1200FD,

	/* Gamma */
	0x002A04CC,
	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F120055,
	0x0F1200E6,
	0x0F120141,
	0x0F120188,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F120055,
	0x0F1200E6,
	0x0F120141,
	0x0F120188,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F120055,
	0x0F1200E6,
	0x0F120141,
	0x0F120188,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,

	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone	       */
	0x0F120000, /* awbb_LowBr0_NBzone       */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv       */

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F12038F, /* awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F12039B, /* awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F120373, /* awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F120352, /* awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203B7, /* awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120334, /* awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203B5, /* awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120318, /* awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202FF, /* awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12038D, /* awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202E7, /* awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120372, /* awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202D0, /* awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12035D, /* awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202B5, /* awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120345, /* awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202A1, /* awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F120331, /* awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12028B, /* awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12031E, /* awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120309, /* awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F12025F, /* awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202F5, /* awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120250, /* awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202DB, /* awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F120241, /* awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202C7, /* awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F120233, /* awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202B9, /* awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120223, /* awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202AB, /* awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120217, /* awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F1202A2, /* awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120207, /* awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120294, /* awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201FA, /* awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120289, /* awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201EA, /* awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F120281, /* awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201DD, /* awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F12027B, /* awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201D0, /* awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201C3, /* awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12026A, /* awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201B6, /* awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F120265, /* awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201AB, /* awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F12025B, /* awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201A1, /* awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120254, /* awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120198, /* awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F12024B, /* awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120242, /* awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120191, /* awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F12023A, /* awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F1201C5, /* awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F1201DF, /* awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */

	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F120022,
	0x0F120000,
	0x0F12010F,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F12025E,
	0x0F120282,
	0x0F120240,
	0x0F120298,
	0x0F12022A,
	0x0F12029A,
	0x0F12021A,
	0x0F12029A,
	0x0F120206,
	0x0F120298,
	0x0F1201FE,
	0x0F12028C,
	0x0F1201FA,
	0x0F120278,
	0x0F1201F8,
	0x0F120266,
	0x0F120214,
	0x0F120238,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,


	/* param_WRITE 70000CC6 */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120210,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end*/
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,


	/* Duks add*/
	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFE0, /* awbb_GridCorr_R_0__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_0__1_ */
	0x0F120000, /* awbb_GridCorr_R_0__2_ */
	0x0F120000, /* awbb_GridCorr_R_0__3_ */
	0x0F120000, /* awbb_GridCorr_R_0__4_ */
	0x0F120030, /* awbb_GridCorr_R_0__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_1__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_1__1_ */
	0x0F120000, /* awbb_GridCorr_R_1__2_ */
	0x0F120000, /* awbb_GridCorr_R_1__3_ */
	0x0F120000, /* awbb_GridCorr_R_1__4_ */
	0x0F120030, /* awbb_GridCorr_R_1__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_2__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_2__1_ */
	0x0F120000, /* awbb_GridCorr_R_2__2_ */
	0x0F120000, /* awbb_GridCorr_R_2__3_ */
	0x0F120000, /* awbb_GridCorr_R_2__4_ */
	0x0F120030, /* awbb_GridCorr_R_2__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_0__0_ */
	0x0F120000, /* awbb_GridCorr_B_0__1_ */
	0x0F120000, /* awbb_GridCorr_B_0__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_0__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_0__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_0__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_1__0_ */
	0x0F120000, /* awbb_GridCorr_B_1__1_ */
	0x0F120000, /* awbb_GridCorr_B_1__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_1__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_1__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_1__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_2__0_ */
	0x0F120000, /* awbb_GridCorr_B_2__1_ */
	0x0F120000, /* awbb_GridCorr_B_2__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_2__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_2__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_2__5_ */

	0x0F1202C6, /* awbb_GridConst_1_0_ */
	0x0F120335, /* awbb_GridConst_1_1_ */
	0x0F1203B3, /* awbb_GridConst_1_2_ */
	0x0F121021, /* awbb_GridConst_2_0  */
	0x0F12107E, /* awbb_GridConst_2_1  */
	0x0F12113E, /* awbb_GridConst_2_2  */
	0x0F12117C, /* awbb_GridConst_2_3  */
	0x0F1211C2, /* awbb_GridConst_2_4  */
	0x0F12120B, /* awbb_GridConst_2_5  */

	0x0F1200B3, /* awbb_GridCoeff_R_1 */
	0x0F1200B7, /* awbb_GridCoeff_B_1 */
	0x0F1200D3, /* awbb_GridCoeff_R_2 */
	0x0F120091, /* awbb_GridCoeff_B_2 */

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,

	/* Gamut Thresholds */
	0x002A0DAE,
	0x0F120036,
	0x0F12001C,
	0x002A0DAA,
	0x0F12071A,
	0x0F1203A4,

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120BB8,
	0x0F120096,
	0x002A0E86,
	0x0F120216,
	0x0F12029F,
	0x002A0D96,
	0x0F120BB7,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F120459,
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,

	/* awbb_ChromaClassifyEn, default : enable*/
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120210, /* 258 awbb_GainsMaxMove */
	0x0F120003,

	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/*  param_start */
	0x002A2800,
	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201FB,
	0x0F12FFA9,
	0x0F12FFEA,
	0x0F12013C,
	0x0F120140,
	0x0F12FF53,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF39,
	0x0F1201D6,
	0x0F1200C4,
	0x0F12FFC0,
	0x0F12FFBF,
	0x0F1201CD,
	0x0F120182,
	0x0F12FF91,
	0x0F1201AA,

	0x0F1201C5,
	0x0F12FF9F,
	0x0F12FFE5,
	0x0F1200E2,
	0x0F12010E,
	0x0F12FF62,
	0x0F12FF03,
	0x0F1201D0,
	0x0F12FF3E,
	0x0F12FF00,
	0x0F1201A6,
	0x0F1200BB,
	0x0F12FFBF,
	0x0F12FFDD,
	0x0F1201F6,
	0x0F1200CB,
	0x0F12FF94,
	0x0F12019E,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200E8,
	0x0F120126,
	0x0F12FF83,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF8A,
	0x0F1201F9,
	0x0F12005B,
	0x0F12FFCA,
	0x0F12FFA3,
	0x0F1201DA,
	0x0F120108,
	0x0F12FFB3,
	0x0F1201DD,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200F4,
	0x0F120139,
	0x0F12FF64,
	0x0F12FEEC,
	0x0F1201FD,
	0x0F12FF8E,
	0x0F12FEF4,
	0x0F1201BD,
	0x0F12010A,
	0x0F12FFA2,
	0x0F12FFDE,
	0x0F120208,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	/* Set NB */
	0x002A07EA,
	0x0F120000,

	/* param_start SARR_uNormBrInDoor*/
	0x0F12000A,
	0x0F120019,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,

	/* param_start SARR_uNormBrOutDoor */
	0x0F12000A,
	0x0F120019,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,


	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,


	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F12FFFE, /* SATURATION                                                         */
	0x0F12FFE2, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F1203FF, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120344, /* UVDenoise_iYLowThresh                                              */
	0x0F12033A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120018, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120016, /* 14 Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120072, /* 64 Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120114, /* UVDenoise_iYLowThresh                                              */
	0x0F12020A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12200A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120009, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F12000E, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120012, /* 0C Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006E, /* 60 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F12000E, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006C, /* 5A Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F12000A, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120014, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120068, /* 50 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120000, /* UVDenoise_iYLowThresh                                              */
	0x0F120000, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F1200FF, /* Denoise1_iUVDenThreshLow                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                         */
	0x0F120800, /* Denoise1_sensor_width                             */
	0x0F120600, /* Denoise1_sensor_height                            */
	0x0F120000, /* Denoise1_start_x                                  */
	0x0F120000, /* Denoise1_start_y                                  */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "          */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "        */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  "  */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "           */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "         */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "      */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "     */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh" */
	0x0F120000, /*  Demosaic4_iBypassSelect                          */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001,

	0x0028D000,
	0x002AB0CC,
	0x0F12000B,
	/* END of Initial*/
};

/* Set-data based on SKT VT standard ,when using 3G network
* 8fps
*/
static const u32 s5k5bafx_vt_common[] =
{
	/* VT-Call */

	0xFCFCD000,

	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* Delay */


	/* Trap and Patch  2008-11-18 10:15:41 */
	0x00287000,
	0x002A1668,
	0x0F12B5FE,
	0x0F120007,
	0x0F12683C,
	0x0F12687E,
	0x0F121DA5,
	0x0F1288A0,
	0x0F122800,
	0x0F12D00B,
	0x0F1288A8,
	0x0F122800,
	0x0F12D008,
	0x0F128820,
	0x0F128829,
	0x0F124288,
	0x0F12D301,
	0x0F121A40,
	0x0F12E000,
	0x0F121A08,
	0x0F129001,
	0x0F12E001,
	0x0F122019,
	0x0F129001,
	0x0F124916,
	0x0F12466B,
	0x0F128A48,
	0x0F128118,
	0x0F128A88,
	0x0F128158,
	0x0F124814,
	0x0F128940,
	0x0F120040,
	0x0F122103,
	0x0F12F000,
	0x0F12F826,
	0x0F1288A1,
	0x0F124288,
	0x0F12D908,
	0x0F128828,
	0x0F128030,
	0x0F128868,
	0x0F128070,
	0x0F1288A8,
	0x0F126038,
	0x0F12BCFE,
	0x0F12BC08,
	0x0F124718,
	0x0F1288A9,
	0x0F124288,
	0x0F12D906,
	0x0F128820,
	0x0F128030,
	0x0F128860,
	0x0F128070,
	0x0F1288A0,
	0x0F126038,
	0x0F12E7F2,
	0x0F129801,
	0x0F12A902,
	0x0F12F000,
	0x0F12F812,
	0x0F120033,
	0x0F120029,
	0x0F129A02,
	0x0F120020,
	0x0F12F000,
	0x0F12F814,
	0x0F126038,
	0x0F12E7E6,
	0x0F121A28,
	0x0F127000,
	0x0F120D64,
	0x0F127000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F126009,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12622F,
	0x0F120000,
	0x002A2080,
	0x0F12B510,
	0x0F12F000,
	0x0F12F8F4,
	0x0F12BC10,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F0,
	0x0F12B08B,
	0x0F120006,
	0x0F122000,
	0x0F129004,
	0x0F126835,
	0x0F126874,
	0x0F1268B0,
	0x0F12900A,
	0x0F1268F0,
	0x0F129009,
	0x0F124F7D,
	0x0F128979,
	0x0F12084A,
	0x0F1288A8,
	0x0F1288A3,
	0x0F124298,
	0x0F12D300,
	0x0F120018,
	0x0F12F000,
	0x0F12F907,
	0x0F129007,
	0x0F120021,
	0x0F120028,
	0x0F12AA04,
	0x0F12F000,
	0x0F12F909,
	0x0F129006,
	0x0F1288A8,
	0x0F122800,
	0x0F12D102,
	0x0F1227FF,
	0x0F121C7F,
	0x0F12E047,
	0x0F1288A0,
	0x0F122800,
	0x0F12D101,
	0x0F122700,
	0x0F12E042,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12F000,
	0x0F12F8F8,
	0x0F129008,
	0x0F128ABA,
	0x0F129808,
	0x0F12466B,
	0x0F124342,
	0x0F129202,
	0x0F128820,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8EA,
	0x0F129A02,
	0x0F1217D1,
	0x0F120E09,
	0x0F121889,
	0x0F121209,
	0x0F124288,
	0x0F12DD1F,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8DA,
	0x0F129001,
	0x0F128828,
	0x0F12466B,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12980A,
	0x0F129902,
	0x0F12F000,
	0x0F12F8D0,
	0x0F128AB9,
	0x0F129A08,
	0x0F124351,
	0x0F1217CA,
	0x0F120E12,
	0x0F121851,
	0x0F12120A,
	0x0F129901,
	0x0F12F000,
	0x0F12F8B6,
	0x0F120407,
	0x0F120C3F,
	0x0F12E000,
	0x0F122700,
	0x0F128820,
	0x0F12466B,
	0x0F12AA05,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12003B,
	0x0F12F000,
	0x0F12F8BB,
	0x0F1288A1,
	0x0F1288A8,
	0x0F12003A,
	0x0F12F000,
	0x0F12F8BE,
	0x0F120004,
	0x0F12A804,
	0x0F12C803,
	0x0F129A09,
	0x0F129B07,
	0x0F12F000,
	0x0F12F8AF,
	0x0F12A806,
	0x0F12C805,
	0x0F120021,
	0x0F12F000,
	0x0F12F8B2,
	0x0F126030,
	0x0F12B00B,
	0x0F12BCF0,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F1,
	0x0F129900,
	0x0F12680C,
	0x0F12493A,
	0x0F12694B,
	0x0F12698A,
	0x0F124694,
	0x0F1269CD,
	0x0F126A0E,
	0x0F124F38,
	0x0F1242BC,
	0x0F12D800,
	0x0F120027,
	0x0F124937,
	0x0F126B89,
	0x0F120409,
	0x0F120C09,
	0x0F124A35,
	0x0F121E92,
	0x0F126BD2,
	0x0F120412,
	0x0F120C12,
	0x0F12429F,
	0x0F12D801,
	0x0F120020,
	0x0F12E031,
	0x0F12001F,
	0x0F12434F,
	0x0F120A3F,
	0x0F1242A7,
	0x0F12D301,
	0x0F120018,
	0x0F12E02A,
	0x0F12002B,
	0x0F12434B,
	0x0F120A1B,
	0x0F1242A3,
	0x0F12D303,
	0x0F120220,
	0x0F12F000,
	0x0F12F88C,
	0x0F12E021,
	0x0F120029,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D301,
	0x0F120028,
	0x0F12E01A,
	0x0F120031,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D304,
	0x0F120220,
	0x0F120011,
	0x0F12F000,
	0x0F12F87B,
	0x0F12E010,
	0x0F12491E,
	0x0F128C89,
	0x0F12000A,
	0x0F124372,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D301,
	0x0F120030,
	0x0F12E007,
	0x0F124662,
	0x0F12434A,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D302,
	0x0F120220,
	0x0F12F000,
	0x0F12F869,
	0x0F124B16,
	0x0F124D18,
	0x0F128D99,
	0x0F121FCA,
	0x0F123AF9,
	0x0F12D00A,
	0x0F122001,
	0x0F120240,
	0x0F128468,
	0x0F120220,
	0x0F12F000,
	0x0F12F85D,
	0x0F129900,
	0x0F126008,
	0x0F12BCF8,
	0x0F12BC08,
	0x0F124718,
	0x0F128D19,
	0x0F128469,
	0x0F129900,
	0x0F126008,
	0x0F12E7F7,
	0x0F12B570,
	0x0F122200,
	0x0F12490E,
	0x0F12480E,
	0x0F122401,
	0x0F12F000,
	0x0F12F852,
	0x0F120022,
	0x0F12490D,
	0x0F12480D,
	0x0F122502,
	0x0F12F000,
	0x0F12F84C,
	0x0F12490C,
	0x0F12480D,
	0x0F12002A,
	0x0F12F000,
	0x0F12F847,
	0x0F12BC70,
	0x0F12BC08,
	0x0F124718,
	0x0F120D64,
	0x0F127000,
	0x0F120470,
	0x0F127000,
	0x0F12A120,
	0x0F120007,
	0x0F120402,
	0x0F127000,
	0x0F1214A0,
	0x0F127000,
	0x0F12208D,
	0x0F127000,
	0x0F12622F,
	0x0F120000,
	0x0F121669,
	0x0F127000,
	0x0F126445,
	0x0F120000,
	0x0F1221AB,
	0x0F127000,
	0x0F122AA9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125F49,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FC7,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125457,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FA3,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F1251F9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A007,
	0x0F120000,
	0x0F126546,
	0x0F122062,
	0x0F123120,
	0x0F123220,
	0x0F123130,
	0x0F120030,
	0x0F12E010,
	0x0F120208,
	0x0F120058,
	0x0F120000,
	/* End of Trap and Patch (Last : 70002342h) */
	/* Total Size 896 (0x0380)                  */

	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0,	/* setot_uOnlineClocksDiv40             */
	0x002A0AE2,
	0x0F12222E,	/* setot_usSetRomWaitStateThreshold4KHz */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */

	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,


	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,

	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,

	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,

	0x0F120015,


	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,


	0x002AF900,
	0x0F120067,


	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,

	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,

	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,

	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,

	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,

	0x002AF4D6,
	0x0F120090,

	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,

	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,

	/* sensor aig table setting   sunkyu start */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,
	0x002A1084,
	0x0F120000,
	0x0F120000,

	/* Set AE Target */
	0x002A0F4C,
	0x0F12003C, /* 3A TVAR_ae_BrAve */

	0x002A0478,
	0x0F120114,
	0x0F1200EB, /* ae boundary */


	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A, /*uMaxExp1         */
	0x0F120000,
	0x002A048C,
	0x0F128214, /*uMaxExp2         */
	0x0F120000,
	0x0F12A122, /*uMaxExp3         */
	0x0F120000,
	0x002A0488,
	0x0F12f424, /*uMaxExp4         */
	0x0F120000,
	0x002A043A,
	0x0F1201D0, /*lt_uMaxAnGain0   */
	0x0F1201E0, /*lt_uMaxAnGain0_1 */
	0x002A0494,
	0x0F120300, /*lt_uMaxAnGain1   */
	0x0F120C80, /* E00 lt_uMaxAnGain2   */
	0x0f120100,
	0x002A0F52,
	0x0F12000F, /*ae_StatMode      */

	0x002A0E98, /* bp_uMaxBrightnessFactor */
	0x0F1202B0,
	0x002A0E9E, /* bp_uMinBrightnessFactor */
	0x0F120290,

	/* 1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001, /* AFC_Default60Hz	 Auto Flicker 60Hz start 0: Auto Flicker 50Hz start */
	0x002A03F8,
	0x0F12007F, /* REG_TC_DBG_AutoAlgEnBits             default : 007F */


	0xffff000a, /* Wait10mSec */


	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0, /* REG_TC_IPRM_InClockLSBs */
	0x0F120000, /* REG_TC_IPRM_InClockMSBs */

	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001, /* REG_TC_IPRM_UseNPviClocks         */
	0x0F120001, /* REG_TC_IPRM_UseNMipiClocks        */
	0x0F120000, /* REG_TC_IPRM_bBlockInternalPllCalc */

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770, /* REG_TC_IPRM_OpClk4KHz_0      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_0 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_0 */

	/* System Clock 1 (System : 28Mhz, PCLK : 48Mhz) */
	0x002A01D2,
	0x0F121B58, /* REG_TC_IPRM_OpClk4KHz_1      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_1 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_1 */


	0x002A01DE,
	0x0F120001, /* REG_TC_IPRM_UseRegsAPI        */
	0x0F120001, /* REG_TC_IPRM_InitParamsUpdated */
	0xffff0064, /* Delay 100ms                   */



	/* Crop */
	0x002A01FA,
	0x0F120640, /* REG_TC_GP_PrevReqInputWidth  */
	0x0F1204B0, /* REG_TC_GP_PrevReqInputHeight */
	0x0F120000, /* REG_TC_GP_PrevInputWidthOfs  */
	0x0F120000, /* REG_TC_GP_PrevInputHeightOfs */


	/* Set Preview Config */
	/* Preview Config 0 (1600x1200 fixed 15fps) */
	0x002A0242,
	0x0F120280, /* REG_0TC_PCFG_usWidth               */
	0x0F1201E0, /* REG_0TC_PCFG_usHeight              */
	0x0F120005, /* REG_0TC_PCFG_Format                */
	0x0F122EE0, /* REG_0TC_PCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_PCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_PCFG_PVIMask               */
	0x0F120001, /* REG_0TC_PCFG_uClockInd             */
	0x0F120002, /* REG_0TC_PCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_PCFG_FrRateQualityType     */
	0x0F1204E2, /* REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
	0x0F1204E2, /* REG_0TC_PCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_PCFG_sSaturation           */
	0x0F120000, /* REG_0TC_PCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_PCFG_sGlamour              */
	0x0F120000, /* REG_0TC_PCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_PCFG_uDeviceGammaIndex     */
	0x0F120000, /* REG_0TC_PCFG_uPrevMirror		  */
	0x0F120000, /* REG_0TC_PCFG_uCaptureMirror	  */
	0x0F120000, /* REG_0TC_PCFG_uRotation             */

	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280, /* REG_1TC_PCFG_usWidth               */
	0x0F1201E0, /* REG_1TC_PCFG_usHeight              */
	0x0F120005, /* REG_1TC_PCFG_Format                */
	0x0F122EE0, /* REG_1TC_PCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_1TC_PCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_1TC_PCFG_PVIMask               */
	0x0F120001, /* REG_1TC_PCFG_uClockInd             */
	0x0F120000, /* REG_1TC_PCFG_usFrTimeType          */
	0x0F120000, /* REG_1TC_PCFG_FrRateQualityType     */
	0x0F12029A, /* REG_1TC_PCFG_usMaxFrTimeMsecMult10 */
	0x0F12014D, /* REG_1TC_PCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_1TC_PCFG_sSaturation           */
	0x0F120000, /* REG_1TC_PCFG_sSharpBlur            */
	0x0F120000, /* REG_1TC_PCFG_sGlamour              */
	0x0F120000, /* REG_1TC_PCFG_sColorTemp            */
	0x0F120000, /* REG_1TC_PCFG_uDeviceGammaIndex     */
	0x0F120000, /* REG_0TC_PCFG_uPrevMirror		  */
	0x0F120000, /* REG_0TC_PCFG_uCaptureMirror	  */
	0x0F120000, /* REG_1TC_PCFG_uRotation             */



	/* Set MIPI */
	0x002A03AC,
	0x0F120000, /* REG_TC_FLS_Mode        */
	0x002A03F2,
	0x0F120001, /* REG_TC_OIF_EnMipiLanes */
	0x0F1200C3, /* REG_TC_OIF_EnPackets   */
	0x0F120001, /* REG_TC_OIF_CfgChanged  */

	/* Apply preview config */
	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig     */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange  */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync        */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged    */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview        */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */



	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000, /* REG_0TC_CCFG_uCaptureMode          */
	0x0F120640, /* REG_0TC_CCFG_usWidth               */
	0x0F1204B0, /* REG_0TC_CCFG_usHeight              */
	0x0F120005, /* REG_0TC_CCFG_Format                */
	0x0F122EE0, /* REG_0TC_CCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_CCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_CCFG_PVIMask               */
	0x0F120001, /* REG_0TC_CCFG_uClockInd             */
	0x0F120002, /* REG_0TC_CCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_CCFG_FrRateQualityType     */
	0x0F1204E2, /* REG_0TC_CCFG_usMaxFrTimeMsecMult10 */
	0x0F1204E2, /* REG_0TC_CCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_CCFG_sSaturation           */
	0x0F120000, /* REG_0TC_CCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_CCFG_sGlamour              */
	0x0F120000, /* REG_0TC_CCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_CCFG_uDeviceGammaIndex     */




	/* Periodic mismatch */
	0x002A0780,
	0x0F120000, /* msm_uOffsetNoBin[0][0]    */
	0x0F120000, /* msm_uOffsetNoBin[0][1]    */
	0x0F120000, /* msm_uOffsetNoBin[1][0]    */
	0x0F120000, /* msm_uOffsetNoBin[1][1]    */
	0x0F120000, /* msm_uOffsetNoBin[2][0]    */
	0x0F120000, /* msm_uOffsetNoBin[2][1]    */
	0x0F120000, /* msm_uOffsetNoBin[3][0]    */
	0x0F120000, /* msm_uOffsetNoBin[3][1]    */

	0x002A0798,
	0x0F120000, /* msm_uOffsetBin[0][0]      */
	0x0F120000, /* msm_uOffsetBin[0][1]      */
	0x0F120000, /* msm_uOffsetBin[1][0]      */
	0x0F120000, /* msm_uOffsetBin[1][1]      */

	0x002A07C0,
	0x0F120004, /* msm_NonLinearOfsOutput[2] */
	0x0F120004, /* msm_NonLinearOfsOutput[3] */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */


	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000, /* ae_WeightTbl_16_0_ */
	0x0F120000, /* ae_WeightTbl_16_1_ */
	0x0F120000, /* ae_WeightTbl_16_2_ */
	0x0F120000, /* ae_WeightTbl_16_3_ */
	0x0F120100, /* ae_WeightTbl_16_4_ */
	0x0F120101, /* ae_WeightTbl_16_5_ */
	0x0F120101, /* ae_WeightTbl_16_6_ */
	0x0F120001, /* ae_WeightTbl_16_7_ */
	0x0F120100, /* ae_WeightTbl_16_8_ */
	0x0F120302, /* ae_WeightTbl_16_9_ */
	0x0F120203, /* ae_WeightTbl_16_10 */
	0x0F120001, /* ae_WeightTbl_16_11 */
	0x0F120100, /* ae_WeightTbl_16_12 */
	0x0F120403, /* ae_WeightTbl_16_13 */
	0x0F120304, /* ae_WeightTbl_16_14 */
	0x0F120001, /* ae_WeightTbl_16_15 */
	0x0F120100, /* ae_WeightTbl_16_16 */
	0x0F120403, /* ae_WeightTbl_16_17 */
	0x0F120304, /* ae_WeightTbl_16_18 */
	0x0F120001, /* ae_WeightTbl_16_19 */
	0x0F120100, /* ae_WeightTbl_16_20 */
	0x0F120302, /* ae_WeightTbl_16_21 */
	0x0F120203, /* ae_WeightTbl_16_22 */
	0x0F120001, /* ae_WeightTbl_16_23 */
	0x0F120100, /* ae_WeightTbl_16_24 */
	0x0F120101, /* ae_WeightTbl_16_25 */
	0x0F120101, /* ae_WeightTbl_16_26 */
	0x0F120001, /* ae_WeightTbl_16_27 */
	0x0F120000, /* ae_WeightTbl_16_28 */
	0x0F120000, /* ae_WeightTbl_16_29 */
	0x0F120000, /* ae_WeightTbl_16_30 */
	0x0F120000, /* ae_WeightTbl_16_31 */


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3, /* TVAR_ash_AwbAshCord_0_ */
	0x0F1200E5, /* TVAR_ash_AwbAshCord_1_ */
	0x0F120120, /* TVAR_ash_AwbAshCord_2_ */
	0x0F120136, /* TVAR_ash_AwbAshCord_3_ */
	0x0F120180, /* TVAR_ash_AwbAshCord_4_ */
	0x0F1201B0, /* TVAR_ash_AwbAshCord_5_ */
	0x0F120200, /* TVAR_ash_AwbAshCord_6_ */

	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3, /* SARR_AwbCcmCord_0_	Hor   */
	0x0F1200E5, /* SARR_AwbCcmCord_1_	IncaA */
	0x0F120120, /* SARR_AwbCcmCord_2_	WW    */
	0x0F120136, /* SARR_AwbCcmCord_3_	CW    */
	0x0F120180, /* SARR_AwbCcmCord_4_	D50   */
	0x0F120190, /* SARR_AwbCcmCord_5_	D65   */

	/* Target Brightness Control */
	0x002A103E,
	0x0F120000, /* SARR_IllumType_0_      */
	0x0F120009, /* SARR_IllumType_1_      */
	0x0F120018, /* SARR_IllumType_2_      */
	0x0F120032, /* SARR_IllumType_3_      */
	0x0F12004A, /* SARR_IllumType_4_      */
	0x0F120051, /* SARR_IllumType_5_      */
	0x0F120056, /* SARR_IllumType_6_      */
	0x0F12010C, /* SARe_2_R_IllumTypeF_0_ */
	0x0F12010C, /* SARe_3_R_IllumTypeF_1_ */
	0x0F120109, /* SARe_4_R_IllumTypeF_2_ */
	0x0F120105, /* SARe_5_R_IllumTypeF_3_ */
	0x0F120102, /* SARe_6_R_IllumTypeF_4_ */
	0x0F1200FB, /* SARR_IllumTypeF_5_     */
	0x0F1200F8, /* SARR_IllumTypeF_6_     */

	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */

	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */

	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */

	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */

	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */

	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */

	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */

	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_ */

	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388, /* TVAR_ash_pGAS */
	0x0F127000, /* TVAR_ash_pGAS */

	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120160, /* TVAR_ash_pGAS[0]   */
	0x0F120134, /* TVAR_ash_pGAS[1]   */
	0x0F1200FF, /* TVAR_ash_pGAS[2]   */
	0x0F1200D1, /* TVAR_ash_pGAS[3]   */
	0x0F1200B1, /* TVAR_ash_pGAS[4]   */
	0x0F12009D, /* TVAR_ash_pGAS[5]   */
	0x0F120096, /* TVAR_ash_pGAS[6]   */
	0x0F12009E, /* TVAR_ash_pGAS[7]   */
	0x0F1200B3, /* TVAR_ash_pGAS[8]   */
	0x0F1200D3, /* TVAR_ash_pGAS[9]   */
	0x0F1200FF, /* TVAR_ash_pGAS[10]  */
	0x0F120131, /* TVAR_ash_pGAS[11]  */
	0x0F120159, /* TVAR_ash_pGAS[12]  */
	0x0F12013C, /* TVAR_ash_pGAS[13]  */
	0x0F120107, /* TVAR_ash_pGAS[14]  */
	0x0F1200CD, /* TVAR_ash_pGAS[15]  */
	0x0F1200A1, /* TVAR_ash_pGAS[16]  */
	0x0F120080, /* TVAR_ash_pGAS[17]  */
	0x0F12006B, /* TVAR_ash_pGAS[18]  */
	0x0F120064, /* TVAR_ash_pGAS[19]  */
	0x0F12006C, /* TVAR_ash_pGAS[20]  */
	0x0F120080, /* TVAR_ash_pGAS[21]  */
	0x0F1200A1, /* TVAR_ash_pGAS[22]  */
	0x0F1200CD, /* TVAR_ash_pGAS[23]  */
	0x0F120106, /* TVAR_ash_pGAS[24]  */
	0x0F120139, /* TVAR_ash_pGAS[25]  */
	0x0F120116, /* TVAR_ash_pGAS[26]  */
	0x0F1200DC, /* TVAR_ash_pGAS[27]  */
	0x0F1200A2, /* TVAR_ash_pGAS[28]  */
	0x0F120073, /* TVAR_ash_pGAS[29]  */
	0x0F120051, /* TVAR_ash_pGAS[30]  */
	0x0F12003B, /* TVAR_ash_pGAS[31]  */
	0x0F120033, /* TVAR_ash_pGAS[32]  */
	0x0F12003B, /* TVAR_ash_pGAS[33]  */
	0x0F120050, /* TVAR_ash_pGAS[34]  */
	0x0F120073, /* TVAR_ash_pGAS[35]  */
	0x0F1200A2, /* TVAR_ash_pGAS[36]  */
	0x0F1200DD, /* TVAR_ash_pGAS[37]  */
	0x0F120115, /* TVAR_ash_pGAS[38]  */
	0x0F1200FA, /* TVAR_ash_pGAS[39]  */
	0x0F1200BF, /* TVAR_ash_pGAS[40]  */
	0x0F120085, /* TVAR_ash_pGAS[41]  */
	0x0F120055, /* TVAR_ash_pGAS[42]  */
	0x0F120031, /* TVAR_ash_pGAS[43]  */
	0x0F12001B, /* TVAR_ash_pGAS[44]  */
	0x0F120014, /* TVAR_ash_pGAS[45]  */
	0x0F12001A, /* TVAR_ash_pGAS[46]  */
	0x0F120031, /* TVAR_ash_pGAS[47]  */
	0x0F120055, /* TVAR_ash_pGAS[48]  */
	0x0F120085, /* TVAR_ash_pGAS[49]  */
	0x0F1200C0, /* TVAR_ash_pGAS[50]  */
	0x0F1200FB, /* TVAR_ash_pGAS[51]  */
	0x0F1200EA, /* TVAR_ash_pGAS[52]  */
	0x0F1200AF, /* TVAR_ash_pGAS[53]  */
	0x0F120074, /* TVAR_ash_pGAS[54]  */
	0x0F120045, /* TVAR_ash_pGAS[55]  */
	0x0F120020, /* TVAR_ash_pGAS[56]  */
	0x0F12000B, /* TVAR_ash_pGAS[57]  */
	0x0F120003, /* TVAR_ash_pGAS[58]  */
	0x0F12000A, /* TVAR_ash_pGAS[59]  */
	0x0F120020, /* TVAR_ash_pGAS[60]  */
	0x0F120046, /* TVAR_ash_pGAS[61]  */
	0x0F120076, /* TVAR_ash_pGAS[62]  */
	0x0F1200B1, /* TVAR_ash_pGAS[63]  */
	0x0F1200ED, /* TVAR_ash_pGAS[64]  */
	0x0F1200E6, /* TVAR_ash_pGAS[65]  */
	0x0F1200AA, /* TVAR_ash_pGAS[66]  */
	0x0F120071, /* TVAR_ash_pGAS[67]  */
	0x0F120041, /* TVAR_ash_pGAS[68]  */
	0x0F12001D, /* TVAR_ash_pGAS[69]  */
	0x0F120008, /* TVAR_ash_pGAS[70]  */
	0x0F120000, /* TVAR_ash_pGAS[71]  */
	0x0F120007, /* TVAR_ash_pGAS[72]  */
	0x0F12001E, /* TVAR_ash_pGAS[73]  */
	0x0F120044, /* TVAR_ash_pGAS[74]  */
	0x0F120074, /* TVAR_ash_pGAS[75]  */
	0x0F1200B0, /* TVAR_ash_pGAS[76]  */
	0x0F1200EC, /* TVAR_ash_pGAS[77]  */
	0x0F1200EF, /* TVAR_ash_pGAS[78]  */
	0x0F1200B3, /* TVAR_ash_pGAS[79]  */
	0x0F12007A, /* TVAR_ash_pGAS[80]  */
	0x0F12004A, /* TVAR_ash_pGAS[81]  */
	0x0F120026, /* TVAR_ash_pGAS[82]  */
	0x0F120011, /* TVAR_ash_pGAS[83]  */
	0x0F12000A, /* TVAR_ash_pGAS[84]  */
	0x0F120011, /* TVAR_ash_pGAS[85]  */
	0x0F120029, /* TVAR_ash_pGAS[86]  */
	0x0F12004F, /* TVAR_ash_pGAS[87]  */
	0x0F120080, /* TVAR_ash_pGAS[88]  */
	0x0F1200BC, /* TVAR_ash_pGAS[89]  */
	0x0F1200F8, /* TVAR_ash_pGAS[90]  */
	0x0F120105, /* TVAR_ash_pGAS[91]  */
	0x0F1200C9, /* TVAR_ash_pGAS[92]  */
	0x0F12008F, /* TVAR_ash_pGAS[93]  */
	0x0F120060, /* TVAR_ash_pGAS[94]  */
	0x0F12003C, /* TVAR_ash_pGAS[95]  */
	0x0F120026, /* TVAR_ash_pGAS[96]  */
	0x0F12001F, /* TVAR_ash_pGAS[97]  */
	0x0F120028, /* TVAR_ash_pGAS[98]  */
	0x0F120040, /* TVAR_ash_pGAS[99]  */
	0x0F120066, /* TVAR_ash_pGAS[100] */
	0x0F120097, /* TVAR_ash_pGAS[101] */
	0x0F1200D4, /* TVAR_ash_pGAS[102] */
	0x0F120110, /* TVAR_ash_pGAS[103] */
	0x0F120124, /* TVAR_ash_pGAS[104] */
	0x0F1200EB, /* TVAR_ash_pGAS[105] */
	0x0F1200B1, /* TVAR_ash_pGAS[106] */
	0x0F120082, /* TVAR_ash_pGAS[107] */
	0x0F12005F, /* TVAR_ash_pGAS[108] */
	0x0F12004A, /* TVAR_ash_pGAS[109] */
	0x0F120043, /* TVAR_ash_pGAS[110] */
	0x0F12004C, /* TVAR_ash_pGAS[111] */
	0x0F120064, /* TVAR_ash_pGAS[112] */
	0x0F120089, /* TVAR_ash_pGAS[113] */
	0x0F1200BA, /* TVAR_ash_pGAS[114] */
	0x0F1200F8, /* TVAR_ash_pGAS[115] */
	0x0F12012F, /* TVAR_ash_pGAS[116] */
	0x0F120147, /* TVAR_ash_pGAS[117] */
	0x0F120116, /* TVAR_ash_pGAS[118] */
	0x0F1200DE, /* TVAR_ash_pGAS[119] */
	0x0F1200AF, /* TVAR_ash_pGAS[120] */
	0x0F12008E, /* TVAR_ash_pGAS[121] */
	0x0F12007A, /* TVAR_ash_pGAS[122] */
	0x0F120072, /* TVAR_ash_pGAS[123] */
	0x0F12007A, /* TVAR_ash_pGAS[124] */
	0x0F120091, /* TVAR_ash_pGAS[125] */
	0x0F1200B6, /* TVAR_ash_pGAS[126] */
	0x0F1200E8, /* TVAR_ash_pGAS[127] */
	0x0F120121, /* TVAR_ash_pGAS[128] */
	0x0F120150, /* TVAR_ash_pGAS[129] */
	0x0F120170, /* TVAR_ash_pGAS[130] */
	0x0F12013F, /* TVAR_ash_pGAS[131] */
	0x0F120110, /* TVAR_ash_pGAS[132] */
	0x0F1200E2, /* TVAR_ash_pGAS[133] */
	0x0F1200C0, /* TVAR_ash_pGAS[134] */
	0x0F1200AB, /* TVAR_ash_pGAS[135] */
	0x0F1200A4, /* TVAR_ash_pGAS[136] */
	0x0F1200AC, /* TVAR_ash_pGAS[137] */
	0x0F1200C3, /* TVAR_ash_pGAS[138] */
	0x0F1200E6, /* TVAR_ash_pGAS[139] */
	0x0F120117, /* TVAR_ash_pGAS[140] */
	0x0F120145, /* TVAR_ash_pGAS[141] */
	0x0F120172, /* TVAR_ash_pGAS[142] */
	0x0F120127, /* TVAR_ash_pGAS[143] */
	0x0F120100, /* TVAR_ash_pGAS[144] */
	0x0F1200CF, /* TVAR_ash_pGAS[145] */
	0x0F1200A7, /* TVAR_ash_pGAS[146] */
	0x0F12008D, /* TVAR_ash_pGAS[147] */
	0x0F12007D, /* TVAR_ash_pGAS[148] */
	0x0F120077, /* TVAR_ash_pGAS[149] */
	0x0F12007A, /* TVAR_ash_pGAS[150] */
	0x0F120087, /* TVAR_ash_pGAS[151] */
	0x0F12009E, /* TVAR_ash_pGAS[152] */
	0x0F1200C0, /* TVAR_ash_pGAS[153] */
	0x0F1200EC, /* TVAR_ash_pGAS[154] */
	0x0F12010F, /* TVAR_ash_pGAS[155] */
	0x0F120108, /* TVAR_ash_pGAS[156] */
	0x0F1200D8, /* TVAR_ash_pGAS[157] */
	0x0F1200A5, /* TVAR_ash_pGAS[158] */
	0x0F120080, /* TVAR_ash_pGAS[159] */
	0x0F120066, /* TVAR_ash_pGAS[160] */
	0x0F120056, /* TVAR_ash_pGAS[161] */
	0x0F12004F, /* TVAR_ash_pGAS[162] */
	0x0F120053, /* TVAR_ash_pGAS[163] */
	0x0F120061, /* TVAR_ash_pGAS[164] */
	0x0F120077, /* TVAR_ash_pGAS[165] */
	0x0F120098, /* TVAR_ash_pGAS[166] */
	0x0F1200C6, /* TVAR_ash_pGAS[167] */
	0x0F1200F3, /* TVAR_ash_pGAS[168] */
	0x0F1200E7, /* TVAR_ash_pGAS[169] */
	0x0F1200B4, /* TVAR_ash_pGAS[170] */
	0x0F120081, /* TVAR_ash_pGAS[171] */
	0x0F12005C, /* TVAR_ash_pGAS[172] */
	0x0F120041, /* TVAR_ash_pGAS[173] */
	0x0F120030, /* TVAR_ash_pGAS[174] */
	0x0F120029, /* TVAR_ash_pGAS[175] */
	0x0F12002E, /* TVAR_ash_pGAS[176] */
	0x0F12003D, /* TVAR_ash_pGAS[177] */
	0x0F120055, /* TVAR_ash_pGAS[178] */
	0x0F120076, /* TVAR_ash_pGAS[179] */
	0x0F1200A5, /* TVAR_ash_pGAS[180] */
	0x0F1200D4, /* TVAR_ash_pGAS[181] */
	0x0F1200CF, /* TVAR_ash_pGAS[182] */
	0x0F12009B, /* TVAR_ash_pGAS[183] */
	0x0F12006A, /* TVAR_ash_pGAS[184] */
	0x0F120043, /* TVAR_ash_pGAS[185] */
	0x0F120027, /* TVAR_ash_pGAS[186] */
	0x0F120016, /* TVAR_ash_pGAS[187] */
	0x0F12000F, /* TVAR_ash_pGAS[188] */
	0x0F120015, /* TVAR_ash_pGAS[189] */
	0x0F120025, /* TVAR_ash_pGAS[190] */
	0x0F12003E, /* TVAR_ash_pGAS[191] */
	0x0F120061, /* TVAR_ash_pGAS[192] */
	0x0F12008E, /* TVAR_ash_pGAS[193] */
	0x0F1200BF, /* TVAR_ash_pGAS[194] */
	0x0F1200C2, /* TVAR_ash_pGAS[195] */
	0x0F12008E, /* TVAR_ash_pGAS[196] */
	0x0F12005D, /* TVAR_ash_pGAS[197] */
	0x0F120037, /* TVAR_ash_pGAS[198] */
	0x0F12001A, /* TVAR_ash_pGAS[199] */
	0x0F120009, /* TVAR_ash_pGAS[200] */
	0x0F120002, /* TVAR_ash_pGAS[201] */
	0x0F120007, /* TVAR_ash_pGAS[202] */
	0x0F120018, /* TVAR_ash_pGAS[203] */
	0x0F120033, /* TVAR_ash_pGAS[204] */
	0x0F120057, /* TVAR_ash_pGAS[205] */
	0x0F120083, /* TVAR_ash_pGAS[206] */
	0x0F1200B3, /* TVAR_ash_pGAS[207] */
	0x0F1200BE, /* TVAR_ash_pGAS[208] */
	0x0F12008A, /* TVAR_ash_pGAS[209] */
	0x0F12005A, /* TVAR_ash_pGAS[210] */
	0x0F120034, /* TVAR_ash_pGAS[211] */
	0x0F120017, /* TVAR_ash_pGAS[212] */
	0x0F120006, /* TVAR_ash_pGAS[213] */
	0x0F120000, /* TVAR_ash_pGAS[214] */
	0x0F120006, /* TVAR_ash_pGAS[215] */
	0x0F120017, /* TVAR_ash_pGAS[216] */
	0x0F120033, /* TVAR_ash_pGAS[217] */
	0x0F120057, /* TVAR_ash_pGAS[218] */
	0x0F120083, /* TVAR_ash_pGAS[219] */
	0x0F1200B3, /* TVAR_ash_pGAS[220] */
	0x0F1200C5, /* TVAR_ash_pGAS[221] */
	0x0F120091, /* TVAR_ash_pGAS[222] */
	0x0F120061, /* TVAR_ash_pGAS[223] */
	0x0F12003B, /* TVAR_ash_pGAS[224] */
	0x0F120020, /* TVAR_ash_pGAS[225] */
	0x0F12000F, /* TVAR_ash_pGAS[226] */
	0x0F120009, /* TVAR_ash_pGAS[227] */
	0x0F120010, /* TVAR_ash_pGAS[228] */
	0x0F120021, /* TVAR_ash_pGAS[229] */
	0x0F12003D, /* TVAR_ash_pGAS[230] */
	0x0F120060, /* TVAR_ash_pGAS[231] */
	0x0F12008D, /* TVAR_ash_pGAS[232] */
	0x0F1200BE, /* TVAR_ash_pGAS[233] */
	0x0F1200D7, /* TVAR_ash_pGAS[234] */
	0x0F1200A2, /* TVAR_ash_pGAS[235] */
	0x0F120072, /* TVAR_ash_pGAS[236] */
	0x0F12004D, /* TVAR_ash_pGAS[237] */
	0x0F120032, /* TVAR_ash_pGAS[238] */
	0x0F120022, /* TVAR_ash_pGAS[239] */
	0x0F12001D, /* TVAR_ash_pGAS[240] */
	0x0F120024, /* TVAR_ash_pGAS[241] */
	0x0F120035, /* TVAR_ash_pGAS[242] */
	0x0F120050, /* TVAR_ash_pGAS[243] */
	0x0F120073, /* TVAR_ash_pGAS[244] */
	0x0F1200A0, /* TVAR_ash_pGAS[245] */
	0x0F1200D2, /* TVAR_ash_pGAS[246] */
	0x0F1200F0, /* TVAR_ash_pGAS[247] */
	0x0F1200BE, /* TVAR_ash_pGAS[248] */
	0x0F12008C, /* TVAR_ash_pGAS[249] */
	0x0F120068, /* TVAR_ash_pGAS[250] */
	0x0F12004F, /* TVAR_ash_pGAS[251] */
	0x0F120040, /* TVAR_ash_pGAS[252] */
	0x0F12003B, /* TVAR_ash_pGAS[253] */
	0x0F120041, /* TVAR_ash_pGAS[254] */
	0x0F120052, /* TVAR_ash_pGAS[255] */
	0x0F12006C, /* TVAR_ash_pGAS[256] */
	0x0F12008E, /* TVAR_ash_pGAS[257] */
	0x0F1200BE, /* TVAR_ash_pGAS[258] */
	0x0F1200ED, /* TVAR_ash_pGAS[259] */
	0x0F12010C, /* TVAR_ash_pGAS[260] */
	0x0F1200E1, /* TVAR_ash_pGAS[261] */
	0x0F1200AF, /* TVAR_ash_pGAS[262] */
	0x0F12008A, /* TVAR_ash_pGAS[263] */
	0x0F120072, /* TVAR_ash_pGAS[264] */
	0x0F120064, /* TVAR_ash_pGAS[265] */
	0x0F12005F, /* TVAR_ash_pGAS[266] */
	0x0F120065, /* TVAR_ash_pGAS[267] */
	0x0F120074, /* TVAR_ash_pGAS[268] */
	0x0F12008D, /* TVAR_ash_pGAS[269] */
	0x0F1200B2, /* TVAR_ash_pGAS[270] */
	0x0F1200E0, /* TVAR_ash_pGAS[271] */
	0x0F12010A, /* TVAR_ash_pGAS[272] */
	0x0F12012F, /* TVAR_ash_pGAS[273] */
	0x0F120104, /* TVAR_ash_pGAS[274] */
	0x0F1200D9, /* TVAR_ash_pGAS[275] */
	0x0F1200B3, /* TVAR_ash_pGAS[276] */
	0x0F120099, /* TVAR_ash_pGAS[277] */
	0x0F12008B, /* TVAR_ash_pGAS[278] */
	0x0F120086, /* TVAR_ash_pGAS[279] */
	0x0F12008B, /* TVAR_ash_pGAS[280] */
	0x0F12009B, /* TVAR_ash_pGAS[281] */
	0x0F1200B5, /* TVAR_ash_pGAS[282] */
	0x0F1200DA, /* TVAR_ash_pGAS[283] */
	0x0F120101, /* TVAR_ash_pGAS[284] */
	0x0F120128, /* TVAR_ash_pGAS[285] */
	0x0F12012F, /* TVAR_ash_pGAS[286] */
	0x0F120106, /* TVAR_ash_pGAS[287] */
	0x0F1200D4, /* TVAR_ash_pGAS[288] */
	0x0F1200AA, /* TVAR_ash_pGAS[289] */
	0x0F12008E, /* TVAR_ash_pGAS[290] */
	0x0F12007D, /* TVAR_ash_pGAS[291] */
	0x0F120079, /* TVAR_ash_pGAS[292] */
	0x0F120080, /* TVAR_ash_pGAS[293] */
	0x0F120093, /* TVAR_ash_pGAS[294] */
	0x0F1200B1, /* TVAR_ash_pGAS[295] */
	0x0F1200DC, /* TVAR_ash_pGAS[296] */
	0x0F12010C, /* TVAR_ash_pGAS[297] */
	0x0F120130, /* TVAR_ash_pGAS[298] */
	0x0F120112, /* TVAR_ash_pGAS[299] */
	0x0F1200E0, /* TVAR_ash_pGAS[300] */
	0x0F1200AB, /* TVAR_ash_pGAS[301] */
	0x0F120083, /* TVAR_ash_pGAS[302] */
	0x0F120067, /* TVAR_ash_pGAS[303] */
	0x0F120057, /* TVAR_ash_pGAS[304] */
	0x0F120051, /* TVAR_ash_pGAS[305] */
	0x0F120059, /* TVAR_ash_pGAS[306] */
	0x0F12006B, /* TVAR_ash_pGAS[307] */
	0x0F120089, /* TVAR_ash_pGAS[308] */
	0x0F1200B2, /* TVAR_ash_pGAS[309] */
	0x0F1200E5, /* TVAR_ash_pGAS[310] */
	0x0F120114, /* TVAR_ash_pGAS[311] */
	0x0F1200F2, /* TVAR_ash_pGAS[312] */
	0x0F1200BD, /* TVAR_ash_pGAS[313] */
	0x0F120088, /* TVAR_ash_pGAS[314] */
	0x0F120061, /* TVAR_ash_pGAS[315] */
	0x0F120044, /* TVAR_ash_pGAS[316] */
	0x0F120031, /* TVAR_ash_pGAS[317] */
	0x0F12002C, /* TVAR_ash_pGAS[318] */
	0x0F120033, /* TVAR_ash_pGAS[319] */
	0x0F120047, /* TVAR_ash_pGAS[320] */
	0x0F120065, /* TVAR_ash_pGAS[321] */
	0x0F12008C, /* TVAR_ash_pGAS[322] */
	0x0F1200C0, /* TVAR_ash_pGAS[323] */
	0x0F1200F3, /* TVAR_ash_pGAS[324] */
	0x0F1200DB, /* TVAR_ash_pGAS[325] */
	0x0F1200A5, /* TVAR_ash_pGAS[326] */
	0x0F120071, /* TVAR_ash_pGAS[327] */
	0x0F120049, /* TVAR_ash_pGAS[328] */
	0x0F12002A, /* TVAR_ash_pGAS[329] */
	0x0F120018, /* TVAR_ash_pGAS[330] */
	0x0F120011, /* TVAR_ash_pGAS[331] */
	0x0F120018, /* TVAR_ash_pGAS[332] */
	0x0F12002C, /* TVAR_ash_pGAS[333] */
	0x0F12004B, /* TVAR_ash_pGAS[334] */
	0x0F120072, /* TVAR_ash_pGAS[335] */
	0x0F1200A3, /* TVAR_ash_pGAS[336] */
	0x0F1200D7, /* TVAR_ash_pGAS[337] */
	0x0F1200CD, /* TVAR_ash_pGAS[338] */
	0x0F120097, /* TVAR_ash_pGAS[339] */
	0x0F120065, /* TVAR_ash_pGAS[340] */
	0x0F12003C, /* TVAR_ash_pGAS[341] */
	0x0F12001D, /* TVAR_ash_pGAS[342] */
	0x0F12000A, /* TVAR_ash_pGAS[343] */
	0x0F120003, /* TVAR_ash_pGAS[344] */
	0x0F120009, /* TVAR_ash_pGAS[345] */
	0x0F12001D, /* TVAR_ash_pGAS[346] */
	0x0F12003B, /* TVAR_ash_pGAS[347] */
	0x0F120063, /* TVAR_ash_pGAS[348] */
	0x0F120092, /* TVAR_ash_pGAS[349] */
	0x0F1200C4, /* TVAR_ash_pGAS[350] */
	0x0F1200CA, /* TVAR_ash_pGAS[351] */
	0x0F120094, /* TVAR_ash_pGAS[352] */
	0x0F120062, /* TVAR_ash_pGAS[353] */
	0x0F12003A, /* TVAR_ash_pGAS[354] */
	0x0F12001A, /* TVAR_ash_pGAS[355] */
	0x0F120007, /* TVAR_ash_pGAS[356] */
	0x0F120000, /* TVAR_ash_pGAS[357] */
	0x0F120006, /* TVAR_ash_pGAS[358] */
	0x0F120018, /* TVAR_ash_pGAS[359] */
	0x0F120036, /* TVAR_ash_pGAS[360] */
	0x0F12005C, /* TVAR_ash_pGAS[361] */
	0x0F12008A, /* TVAR_ash_pGAS[362] */
	0x0F1200BC, /* TVAR_ash_pGAS[363] */
	0x0F1200D1, /* TVAR_ash_pGAS[364] */
	0x0F12009B, /* TVAR_ash_pGAS[365] */
	0x0F120069, /* TVAR_ash_pGAS[366] */
	0x0F120042, /* TVAR_ash_pGAS[367] */
	0x0F120022, /* TVAR_ash_pGAS[368] */
	0x0F12000F, /* TVAR_ash_pGAS[369] */
	0x0F120008, /* TVAR_ash_pGAS[370] */
	0x0F12000D, /* TVAR_ash_pGAS[371] */
	0x0F12001F, /* TVAR_ash_pGAS[372] */
	0x0F12003B, /* TVAR_ash_pGAS[373] */
	0x0F120060, /* TVAR_ash_pGAS[374] */
	0x0F12008D, /* TVAR_ash_pGAS[375] */
	0x0F1200BF, /* TVAR_ash_pGAS[376] */
	0x0F1200E3, /* TVAR_ash_pGAS[377] */
	0x0F1200AC, /* TVAR_ash_pGAS[378] */
	0x0F12007A, /* TVAR_ash_pGAS[379] */
	0x0F120053, /* TVAR_ash_pGAS[380] */
	0x0F120035, /* TVAR_ash_pGAS[381] */
	0x0F120022, /* TVAR_ash_pGAS[382] */
	0x0F12001B, /* TVAR_ash_pGAS[383] */
	0x0F12001F, /* TVAR_ash_pGAS[384] */
	0x0F120030, /* TVAR_ash_pGAS[385] */
	0x0F12004B, /* TVAR_ash_pGAS[386] */
	0x0F12006D, /* TVAR_ash_pGAS[387] */
	0x0F12009C, /* TVAR_ash_pGAS[388] */
	0x0F1200CE, /* TVAR_ash_pGAS[389] */
	0x0F1200FE, /* TVAR_ash_pGAS[390] */
	0x0F1200C9, /* TVAR_ash_pGAS[391] */
	0x0F120095, /* TVAR_ash_pGAS[392] */
	0x0F12006F, /* TVAR_ash_pGAS[393] */
	0x0F120052, /* TVAR_ash_pGAS[394] */
	0x0F120040, /* TVAR_ash_pGAS[395] */
	0x0F120039, /* TVAR_ash_pGAS[396] */
	0x0F12003D, /* TVAR_ash_pGAS[397] */
	0x0F12004B, /* TVAR_ash_pGAS[398] */
	0x0F120063, /* TVAR_ash_pGAS[399] */
	0x0F120086, /* TVAR_ash_pGAS[400] */
	0x0F1200B5, /* TVAR_ash_pGAS[401] */
	0x0F1200E6, /* TVAR_ash_pGAS[402] */
	0x0F12011B, /* TVAR_ash_pGAS[403] */
	0x0F1200ED, /* TVAR_ash_pGAS[404] */
	0x0F1200BA, /* TVAR_ash_pGAS[405] */
	0x0F120092, /* TVAR_ash_pGAS[406] */
	0x0F120076, /* TVAR_ash_pGAS[407] */
	0x0F120065, /* TVAR_ash_pGAS[408] */
	0x0F12005D, /* TVAR_ash_pGAS[409] */
	0x0F120060, /* TVAR_ash_pGAS[410] */
	0x0F12006D, /* TVAR_ash_pGAS[411] */
	0x0F120084, /* TVAR_ash_pGAS[412] */
	0x0F1200A8, /* TVAR_ash_pGAS[413] */
	0x0F1200D6, /* TVAR_ash_pGAS[414] */
	0x0F120101, /* TVAR_ash_pGAS[415] */
	0x0F120140, /* TVAR_ash_pGAS[416] */
	0x0F120112, /* TVAR_ash_pGAS[417] */
	0x0F1200E5, /* TVAR_ash_pGAS[418] */
	0x0F1200BD, /* TVAR_ash_pGAS[419] */
	0x0F12009E, /* TVAR_ash_pGAS[420] */
	0x0F12008C, /* TVAR_ash_pGAS[421] */
	0x0F120085, /* TVAR_ash_pGAS[422] */
	0x0F120087, /* TVAR_ash_pGAS[423] */
	0x0F120094, /* TVAR_ash_pGAS[424] */
	0x0F1200AC, /* TVAR_ash_pGAS[425] */
	0x0F1200D0, /* TVAR_ash_pGAS[426] */
	0x0F1200F8, /* TVAR_ash_pGAS[427] */
	0x0F120123, /* TVAR_ash_pGAS[428] */
	0x0F1200F2, /* TVAR_ash_pGAS[429] */
	0x0F1200D1, /* TVAR_ash_pGAS[430] */
	0x0F1200A7, /* TVAR_ash_pGAS[431] */
	0x0F120087, /* TVAR_ash_pGAS[432] */
	0x0F120073, /* TVAR_ash_pGAS[433] */
	0x0F120067, /* TVAR_ash_pGAS[434] */
	0x0F120064, /* TVAR_ash_pGAS[435] */
	0x0F12006B, /* TVAR_ash_pGAS[436] */
	0x0F12007C, /* TVAR_ash_pGAS[437] */
	0x0F120094, /* TVAR_ash_pGAS[438] */
	0x0F1200B7, /* TVAR_ash_pGAS[439] */
	0x0F1200E1, /* TVAR_ash_pGAS[440] */
	0x0F1200FF, /* TVAR_ash_pGAS[441] */
	0x0F1200D6, /* TVAR_ash_pGAS[442] */
	0x0F1200AE, /* TVAR_ash_pGAS[443] */
	0x0F120085, /* TVAR_ash_pGAS[444] */
	0x0F120068, /* TVAR_ash_pGAS[445] */
	0x0F120054, /* TVAR_ash_pGAS[446] */
	0x0F120048, /* TVAR_ash_pGAS[447] */
	0x0F120045, /* TVAR_ash_pGAS[448] */
	0x0F12004B, /* TVAR_ash_pGAS[449] */
	0x0F12005B, /* TVAR_ash_pGAS[450] */
	0x0F120073, /* TVAR_ash_pGAS[451] */
	0x0F120093, /* TVAR_ash_pGAS[452] */
	0x0F1200BF, /* TVAR_ash_pGAS[453] */
	0x0F1200E9, /* TVAR_ash_pGAS[454] */
	0x0F1200B8, /* TVAR_ash_pGAS[455] */
	0x0F12008E, /* TVAR_ash_pGAS[456] */
	0x0F120066, /* TVAR_ash_pGAS[457] */
	0x0F120049, /* TVAR_ash_pGAS[458] */
	0x0F120035, /* TVAR_ash_pGAS[459] */
	0x0F120028, /* TVAR_ash_pGAS[460] */
	0x0F120025, /* TVAR_ash_pGAS[461] */
	0x0F12002B, /* TVAR_ash_pGAS[462] */
	0x0F12003B, /* TVAR_ash_pGAS[463] */
	0x0F120053, /* TVAR_ash_pGAS[464] */
	0x0F120072, /* TVAR_ash_pGAS[465] */
	0x0F12009D, /* TVAR_ash_pGAS[466] */
	0x0F1200C8, /* TVAR_ash_pGAS[467] */
	0x0F1200A2, /* TVAR_ash_pGAS[468] */
	0x0F120078, /* TVAR_ash_pGAS[469] */
	0x0F120051, /* TVAR_ash_pGAS[470] */
	0x0F120034, /* TVAR_ash_pGAS[471] */
	0x0F12001F, /* TVAR_ash_pGAS[472] */
	0x0F120012, /* TVAR_ash_pGAS[473] */
	0x0F12000E, /* TVAR_ash_pGAS[474] */
	0x0F120014, /* TVAR_ash_pGAS[475] */
	0x0F120024, /* TVAR_ash_pGAS[476] */
	0x0F12003B, /* TVAR_ash_pGAS[477] */
	0x0F12005B, /* TVAR_ash_pGAS[478] */
	0x0F120083, /* TVAR_ash_pGAS[479] */
	0x0F1200AD, /* TVAR_ash_pGAS[480] */
	0x0F120095, /* TVAR_ash_pGAS[481] */
	0x0F12006C, /* TVAR_ash_pGAS[482] */
	0x0F120046, /* TVAR_ash_pGAS[483] */
	0x0F12002A, /* TVAR_ash_pGAS[484] */
	0x0F120014, /* TVAR_ash_pGAS[485] */
	0x0F120007, /* TVAR_ash_pGAS[486] */
	0x0F120002, /* TVAR_ash_pGAS[487] */
	0x0F120008, /* TVAR_ash_pGAS[488] */
	0x0F120016, /* TVAR_ash_pGAS[489] */
	0x0F12002D, /* TVAR_ash_pGAS[490] */
	0x0F12004C, /* TVAR_ash_pGAS[491] */
	0x0F120072, /* TVAR_ash_pGAS[492] */
	0x0F12009B, /* TVAR_ash_pGAS[493] */
	0x0F120093, /* TVAR_ash_pGAS[494] */
	0x0F12006A, /* TVAR_ash_pGAS[495] */
	0x0F120045, /* TVAR_ash_pGAS[496] */
	0x0F120028, /* TVAR_ash_pGAS[497] */
	0x0F120013, /* TVAR_ash_pGAS[498] */
	0x0F120005, /* TVAR_ash_pGAS[499] */
	0x0F120000, /* TVAR_ash_pGAS[500] */
	0x0F120004, /* TVAR_ash_pGAS[501] */
	0x0F120012, /* TVAR_ash_pGAS[502] */
	0x0F120028, /* TVAR_ash_pGAS[503] */
	0x0F120045, /* TVAR_ash_pGAS[504] */
	0x0F12006A, /* TVAR_ash_pGAS[505] */
	0x0F120093, /* TVAR_ash_pGAS[506] */
	0x0F12009B, /* TVAR_ash_pGAS[507] */
	0x0F120071, /* TVAR_ash_pGAS[508] */
	0x0F12004C, /* TVAR_ash_pGAS[509] */
	0x0F120030, /* TVAR_ash_pGAS[510] */
	0x0F12001A, /* TVAR_ash_pGAS[511] */
	0x0F12000C, /* TVAR_ash_pGAS[512] */
	0x0F120007, /* TVAR_ash_pGAS[513] */
	0x0F12000B, /* TVAR_ash_pGAS[514] */
	0x0F120018, /* TVAR_ash_pGAS[515] */
	0x0F12002C, /* TVAR_ash_pGAS[516] */
	0x0F120048, /* TVAR_ash_pGAS[517] */
	0x0F12006D, /* TVAR_ash_pGAS[518] */
	0x0F120097, /* TVAR_ash_pGAS[519] */
	0x0F1200AE, /* TVAR_ash_pGAS[520] */
	0x0F120083, /* TVAR_ash_pGAS[521] */
	0x0F12005C, /* TVAR_ash_pGAS[522] */
	0x0F120040, /* TVAR_ash_pGAS[523] */
	0x0F12002B, /* TVAR_ash_pGAS[524] */
	0x0F12001E, /* TVAR_ash_pGAS[525] */
	0x0F120018, /* TVAR_ash_pGAS[526] */
	0x0F12001C, /* TVAR_ash_pGAS[527] */
	0x0F120027, /* TVAR_ash_pGAS[528] */
	0x0F12003A, /* TVAR_ash_pGAS[529] */
	0x0F120055, /* TVAR_ash_pGAS[530] */
	0x0F12007B, /* TVAR_ash_pGAS[531] */
	0x0F1200A6, /* TVAR_ash_pGAS[532] */
	0x0F1200CA, /* TVAR_ash_pGAS[533] */
	0x0F12009E, /* TVAR_ash_pGAS[534] */
	0x0F120076, /* TVAR_ash_pGAS[535] */
	0x0F120059, /* TVAR_ash_pGAS[536] */
	0x0F120046, /* TVAR_ash_pGAS[537] */
	0x0F120039, /* TVAR_ash_pGAS[538] */
	0x0F120033, /* TVAR_ash_pGAS[539] */
	0x0F120036, /* TVAR_ash_pGAS[540] */
	0x0F120040, /* TVAR_ash_pGAS[541] */
	0x0F120052, /* TVAR_ash_pGAS[542] */
	0x0F12006C, /* TVAR_ash_pGAS[543] */
	0x0F120094, /* TVAR_ash_pGAS[544] */
	0x0F1200BF, /* TVAR_ash_pGAS[545] */
	0x0F1200EB, /* TVAR_ash_pGAS[546] */
	0x0F1200C3, /* TVAR_ash_pGAS[547] */
	0x0F120099, /* TVAR_ash_pGAS[548] */
	0x0F12007A, /* TVAR_ash_pGAS[549] */
	0x0F120066, /* TVAR_ash_pGAS[550] */
	0x0F12005A, /* TVAR_ash_pGAS[551] */
	0x0F120054, /* TVAR_ash_pGAS[552] */
	0x0F120056, /* TVAR_ash_pGAS[553] */
	0x0F12005F, /* TVAR_ash_pGAS[554] */
	0x0F120071, /* TVAR_ash_pGAS[555] */
	0x0F12008D, /* TVAR_ash_pGAS[556] */
	0x0F1200B6, /* TVAR_ash_pGAS[557] */
	0x0F1200DE, /* TVAR_ash_pGAS[558] */
	0x0F12010D, /* TVAR_ash_pGAS[559] */
	0x0F1200E7, /* TVAR_ash_pGAS[560] */
	0x0F1200C1, /* TVAR_ash_pGAS[561] */
	0x0F1200A0, /* TVAR_ash_pGAS[562] */
	0x0F12008A, /* TVAR_ash_pGAS[563] */
	0x0F12007C, /* TVAR_ash_pGAS[564] */
	0x0F120076, /* TVAR_ash_pGAS[565] */
	0x0F120078, /* TVAR_ash_pGAS[566] */
	0x0F120081, /* TVAR_ash_pGAS[567] */
	0x0F120093, /* TVAR_ash_pGAS[568] */
	0x0F1200B1, /* TVAR_ash_pGAS[569] */
	0x0F1200D5, /* TVAR_ash_pGAS[570] */
	0x0F1200FD, /* TVAR_ash_pGAS[571] */

	/* Gamma */
	0x002A04CC,
	0x0F120000, /* SARR_usGammaLutRGBIndoor[0][0]  */
	0x0F120002, /* SARR_usGammaLutRGBIndoor[0][1]  */
	0x0F120008, /* SARR_usGammaLutRGBIndoor[0][2]  */
	0x0F120016, /* SARR_usGammaLutRGBIndoor[0][3]  */
	0x0F120055, /* SARR_usGammaLutRGBIndoor[0][4]  */
	0x0F1200E6, /* SARR_usGammaLutRGBIndoor[0][5]  */
	0x0F120141, /* SARR_usGammaLutRGBIndoor[0][6]  */
	0x0F120188, /* SARR_usGammaLutRGBIndoor[0][7]  */
	0x0F1201E6, /* SARR_usGammaLutRGBIndoor[0][8]  */
	0x0F120236, /* SARR_usGammaLutRGBIndoor[0][9]  */
	0x0F1202BA, /* SARR_usGammaLutRGBIndoor[0][10] */
	0x0F12032A, /* SARR_usGammaLutRGBIndoor[0][11] */
	0x0F120385, /* SARR_usGammaLutRGBIndoor[0][12] */
	0x0F1203C2, /* SARR_usGammaLutRGBIndoor[0][13] */
	0x0F1203EA, /* SARR_usGammaLutRGBIndoor[0][14] */
	0x0F1203FF, /* SARR_usGammaLutRGBIndoor[0][15] */

	0x0F120000, /* SARR_usGammaLutRGBIndoor[1][0]  */
	0x0F120002, /* SARR_usGammaLutRGBIndoor[1][1]  */
	0x0F120008, /* SARR_usGammaLutRGBIndoor[1][2]  */
	0x0F120016, /* SARR_usGammaLutRGBIndoor[1][3]  */
	0x0F120055, /* SARR_usGammaLutRGBIndoor[1][4]  */
	0x0F1200E6, /* SARR_usGammaLutRGBIndoor[1][5]  */
	0x0F120141, /* SARR_usGammaLutRGBIndoor[1][6]  */
	0x0F120188, /* SARR_usGammaLutRGBIndoor[1][7]  */
	0x0F1201E6, /* SARR_usGammaLutRGBIndoor[1][8]  */
	0x0F120236, /* SARR_usGammaLutRGBIndoor[1][9]  */
	0x0F1202BA, /* SARR_usGammaLutRGBIndoor[1][10] */
	0x0F12032A, /* SARR_usGammaLutRGBIndoor[1][11] */
	0x0F120385, /* SARR_usGammaLutRGBIndoor[1][12] */
	0x0F1203C2, /* SARR_usGammaLutRGBIndoor[1][13] */
	0x0F1203EA, /* SARR_usGammaLutRGBIndoor[1][14] */
	0x0F1203FF, /* SARR_usGammaLutRGBIndoor[1][15] */

	0x0F120000, /* SARR_usGammaLutRGBIndoor[2][0]  */
	0x0F120002, /* SARR_usGammaLutRGBIndoor[2][1]  */
	0x0F120008, /* SARR_usGammaLutRGBIndoor[2][2]  */
	0x0F120016, /* SARR_usGammaLutRGBIndoor[2][3]  */
	0x0F120055, /* SARR_usGammaLutRGBIndoor[2][4]  */
	0x0F1200E6, /* SARR_usGammaLutRGBIndoor[2][5]  */
	0x0F120141, /* SARR_usGammaLutRGBIndoor[2][6]  */
	0x0F120188, /* SARR_usGammaLutRGBIndoor[2][7]  */
	0x0F1201E6, /* SARR_usGammaLutRGBIndoor[2][8]  */
	0x0F120236, /* SARR_usGammaLutRGBIndoor[2][9]  */
	0x0F1202BA, /* SARR_usGammaLutRGBIndoor[2][10] */
	0x0F12032A, /* SARR_usGammaLutRGBIndoor[2][11] */
	0x0F120385, /* SARR_usGammaLutRGBIndoor[2][12] */
	0x0F1203C2, /* SARR_usGammaLutRGBIndoor[2][13] */
	0x0F1203EA, /* SARR_usGammaLutRGBIndoor[2][14] */
	0x0F1203FF, /* SARR_usGammaLutRGBIndoor[2][15] */



	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone	       */
	0x0F120000, /* awbb_LowBr0_NBzone       */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv       */

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F12035E, /* awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F12036A, /* awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F120348, /* awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F120380, /* awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F120334, /* awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F120384, /* awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120318, /* awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F12037E, /* awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F1202FE, /* awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F12037A, /* awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202E6, /* awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12036C, /* awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202D0, /* awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F12035C, /* awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202B4, /* awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F120344, /* awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202A0, /* awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120330, /* awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F12028A, /* awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F12031E, /* awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F120272, /* awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F120308, /* awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F12025E, /* awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F1202F4, /* awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F120250, /* awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202DA, /* awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120240, /* awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202C6, /* awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F120232, /* awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202B8, /* awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202AA, /* awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120216, /* awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202A2, /* awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120206, /* awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F120294, /* awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F1201FA, /* awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120288, /* awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201EA, /* awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120280, /* awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201DC, /* awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F12027A, /* awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201D0, /* awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F120272, /* awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201C2, /* awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F12026A, /* awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201B6, /* awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F120264, /* awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201AA, /* awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F12025A, /* awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201A0, /* awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F120254, /* awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F120198, /* awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F12024A, /* awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F120242, /* awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120190, /* awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F12023A, /* awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F1201C4, /* awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F1201DE, /* awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */


	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F12001F,
	0x0F120000,
	0x0F12011E,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F120264,
	0x0F120279,
	0x0F120250,
	0x0F120287,
	0x0F120244,
	0x0F120287,
	0x0F120235,
	0x0F120289,
	0x0F120225,
	0x0F120287,
	0x0F120213,
	0x0F120286,
	0x0F120202,
	0x0F12027A,
	0x0F1201F3,
	0x0F120272,
	0x0F1201E9,
	0x0F120269,
	0x0F1201E2,
	0x0F120263,
	0x0F1201E0,
	0x0F12025A,
	0x0F1201E1,
	0x0F120256,
	0x0F1201EE,
	0x0F120251,
	0x0F1201F8,
	0x0F12024A,
	0x0F12020D,
	0x0F120231,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,


	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120011,
	0x0F120000,
	0x0F1201FF,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end	awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,



	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F120000, /* awbb_GridCorr_R_0__0_ */
	0x0F120000, /* awbb_GridCorr_R_0__1_ */
	0x0F120040, /* awbb_GridCorr_R_0__2_ */
	0x0F12FFF8, /* awbb_GridCorr_R_0__3_ */
	0x0F12FFE0, /* awbb_GridCorr_R_0__4_ */
	0x0F12FFD0, /* awbb_GridCorr_R_0__5_ */

	0x0F120000, /* awbb_GridCorr_R_1__0_ */
	0x0F120000, /* awbb_GridCorr_R_1__1_ */
	0x0F120040, /* awbb_GridCorr_R_1__2_ */
	0x0F12FFF8, /* awbb_GridCorr_R_1__3_ */
	0x0F12FFE0, /* awbb_GridCorr_R_1__4_ */
	0x0F12FFD0, /* awbb_GridCorr_R_1__5_ */

	0x0F120000, /* awbb_GridCorr_R_2__0_ */
	0x0F120000, /* awbb_GridCorr_R_2__1_ */
	0x0F120040, /* awbb_GridCorr_R_2__2_ */
	0x0F12FFF8, /* awbb_GridCorr_R_2__3_ */
	0x0F12FFE0, /* awbb_GridCorr_R_2__4_ */
	0x0F12FFD0, /* awbb_GridCorr_R_2__5_ */

	0x0F120000, /* awbb_GridCorr_B_0__0_ */
	0x0F120000, /* awbb_GridCorr_B_0__1_ */
	0x0F120030, /* awbb_GridCorr_B_0__2_ */
	0x0F120000, /* awbb_GridCorr_B_0__3_ */
	0x0F120018, /* awbb_GridCorr_B_0__4_ */
	0x0F120040, /* awbb_GridCorr_B_0__5_ */

	0x0F120000, /* awbb_GridCorr_B_1__0_ */
	0x0F120000, /* awbb_GridCorr_B_1__1_ */
	0x0F120030, /* awbb_GridCorr_B_1__2_ */
	0x0F120000, /* awbb_GridCorr_B_1__3_ */
	0x0F120018, /* awbb_GridCorr_B_1__4_ */
	0x0F120040, /* awbb_GridCorr_B_1__5_ */

	0x0F120000, /* awbb_GridCorr_B_2__0_ */
	0x0F120000, /* awbb_GridCorr_B_2__1_ */
	0x0F120030, /* awbb_GridCorr_B_2__2_ */
	0x0F120000, /* awbb_GridCorr_B_2__3_ */
	0x0F120018, /* awbb_GridCorr_B_2__4_ */
	0x0F120040, /* awbb_GridCorr_B_2__5_ */

	0x0F1202C6, /* awbb_GridConst_1_0_ */
	0x0F120335, /* awbb_GridConst_1_1_ */
	0x0F1203B3, /* awbb_GridConst_1_2_ */
	0x0F120FD7, /* awbb_GridConst_2_0  */
	0x0F1210C5, /* awbb_GridConst_2_1  */
	0x0F12116A, /* awbb_GridConst_2_2  */
	0x0F12117C, /* awbb_GridConst_2_3  */
	0x0F1211C2, /* awbb_GridConst_2_4  */
	0x0F12120B, /* awbb_GridConst_2_5  */

	0x0F1200B3, /* awbb_GridCoeff_R_1 */
	0x0F1200B7, /* awbb_GridCoeff_B_1 */
	0x0F1200D3, /* awbb_GridCoeff_R_2 */
	0x0F120091, /* awbb_GridCoeff_B_2 */

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F120365, /* 52A awbb_MvEq_RBthresh */

	/* Gamut Thresholds */
	0x002A0DAE,
	0x0F120036,
	0x0F12001C,
	0x002A0DAA,
	0x0F12071A,
	0x0F1203A4,

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120BB8,
	0x0F120096,
	0x002A0E86,
	0x0F120216,
	0x0F12029F,
	0x002A0D96,
	0x0F120BB7,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F12041B, /* 459 awbb_LowTempRB */
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,

	/* awbb_ChromaClassifyEn, default : enable */
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120210, /* 258 awbb_GainsMaxMove */
	0x0F120003,


	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/* param_start	TVAR_wbt_pBaseCcms */
	0x002A2800,
	0x0F1201E5, /* 01D6 01E1 01FB */
	0x0F12FFBF, /* FFC9 FFC4 FF9C */
	0x0F12FFF4, /* FFFB FFF8 FFFF */
	0x0F1200EE, /* 010A 0101 0137 */
	0x0F12019B, /* 0177 014C 0113 */
	0x0F12FF1E, /* FF24 FF55 FF6F */
	0x0F12FF38, /* FF9C FF5B FF21 */
	0x0F12026D, /* 0230 0205 0194 */
	0x0F12FEDD, /* FEB1 FF17 FF69 */
	0x0F12FF00, /* FEFF FEFE FF14 */
	0x0F1201B8, /* 01B7 01B6 0158 */
	0x0F120109, /* 0108 0107 015D */
	0x0F12FFCC, /* FFEB FFDB FFF2 */
	0x0F12FFA4, /* FFB5 FFDB FFF1 */
	0x0F120212, /* 01E4 01D1 0179 */
	0x0F120136, /* 011E 0163 017C */
	0x0F12FFA5, /* FFAD FF9E FFC3 */
	0x0F1201CF, /* 01E3 01B3 0197 */

	0x0F1201E5, /* 01D6 01E1 01FB */
	0x0F12FFBF, /* FFC9 FFC4 FF9C */
	0x0F12FFF4, /* FFFB FFF8 FFFF */
	0x0F1200EE, /* 010A 0101 0137 */
	0x0F12019B, /* 0177 014C 0113 */
	0x0F12FF1E, /* FF24 FF55 FF6F */
	0x0F12FF38, /* FF9C FF5B FF21 */
	0x0F12026D, /* 0230 0205 0194 */
	0x0F12FEDD, /* FEB1 FF17 FF69 */
	0x0F12FF00, /* FEFF FEFE FF14 */
	0x0F1201B8, /* 01B7 01B6 0158 */
	0x0F120109, /* 0108 0107 015D */
	0x0F12FFCC, /* FFEB FFDB FFF2 */
	0x0F12FFA4, /* FFB5 FFDB FFF1 */
	0x0F120212, /* 01E4 01D1 0179 */
	0x0F120136, /* 011E 0163 017C */
	0x0F12FFA5, /* FFAD FF9E FFC3 */
	0x0F1201CF, /* 01E3 01B3 0197 */

	0x0F1201E1, /* 01FB */
	0x0F12FFC4, /* FF9C */
	0x0F12FFF8, /* FFFF */
	0x0F120101, /* 0137 */
	0x0F12014C, /* 0113 */
	0x0F12FF55, /* FF6F */
	0x0F12FF5B, /* FF21 */
	0x0F120205, /* 0194 */
	0x0F12FF17, /* FF69 */
	0x0F12FEFE, /* FF14 */
	0x0F1201B6, /* 0158 */
	0x0F120107, /* 015D */
	0x0F12FFDB, /* FFF2 */
	0x0F12FFDB, /* FFF1 */
	0x0F1201D1, /* 0179 */
	0x0F120163, /* 017C */
	0x0F12FF9E, /* FFC3 */
	0x0F1201B3, /* 0197 */

	0x0F1201FB, /* 01FB 01FB */
	0x0F12FFA9, /* FFA9 FF9C */
	0x0F12FFEA, /* FFEA FFFF */
	0x0F12013C, /* 0134 0137 */
	0x0F120140, /* 0133 0113 */
	0x0F12FF53, /* FF5D FF6F */
	0x0F12FE7A, /* FE7A FF21 */
	0x0F12017D, /* 017D 0194 */
	0x0F12FEED, /* FEED FF69 */
	0x0F12FF39, /* FF39 FF14 */
	0x0F1201D6, /* 01D6 0158 */
	0x0F1200C4, /* 00C4 015D */
	0x0F12FFC0, /* FFCE FFF2 */
	0x0F12FFBF, /* FFCD FFF1 */
	0x0F1201CD, /* 01B7 0179 */
	0x0F120182, /* 0176 017C */
	0x0F12FF91, /* FFBD FFC3 */
	0x0F1201AA, /* 0191 0197 */

	0x0F1201D2, /* 01C5 01F9 020A */
	0x0F12FFC2, /* FF9F FFBC FFB2 */
	0x0F12FFFC, /* FFE5 FFF2 FFEB */
	0x0F1200E8, /* 00E2 00FA 0134 */
	0x0F120126, /* 010E 0157 0133 */
	0x0F12FF83, /* FF62 FF81 FF5D */
	0x0F12FE7A, /* FF03 FE7A FEFD */
	0x0F12017D, /* 01D0 017D 01BF */
	0x0F12FEED, /* FF3E FEED FF2A */
	0x0F12FF1C, /* FF00 FF8A FF39 */
	0x0F120194, /* 01A6 01F9 01D6 */
	0x0F12011F, /* 00BB 005B 00C4 */
	0x0F12FFEA, /* FFBF FFCA FFCE */
	0x0F12FFDE, /* FFDD FFA3 FFCD */
	0x0F1201E9, /* 01F6 01DA 01B7 */
	0x0F120178, /* 00CB 0108 0176 */
	0x0F12FFBF, /* FF94 FFB3 FFBD */
	0x0F120193, /* 019E 01DD 0191 */

	0x0F1201D2, /* 01F9 020A 01D0   R */
	0x0F12FFC2, /* FFBC FFB2 FFB4     */
	0x0F12FFFC, /* FFF2 FFEB 000C     */
	0x0F1200E8, /* 00FA 011E 0122   Y */
	0x0F120126, /* 0157 011D 0103     */
	0x0F12FF83, /* FF81 FF86 FF9B     */
	0x0F12FE7A, /* FE7A FEFD FF33   G */
	0x0F12017D, /* 017D 01BF 01C5     */
	0x0F12FEED, /* FEED FF2A FF33     */
	0x0F12FF1C, /* FF8A FF38 FF16   C */
	0x0F120194, /* 01F9 01D5 015A     */
	0x0F12011F, /* 005B 00C3 015F     */
	0x0F12FFEA, /* FFCA FFCF FFE0   B */
	0x0F12FFDE, /* FFA3 FFCE FFDF     */
	0x0F1201E9, /* 01DA 01B8 0197     */
	0x0F120178, /* 0108 0178 0178   M */
	0x0F12FFBF, /* FFB3 FFBF FFBF     */
	0x0F120193, /* 01DD 0193 0193     */

	0x0F1201F1, /* outdoor CCM */
	0x0F12FFB0,
	0x0F12FFEF,
	0x0F1200F4,
	0x0F120139,
	0x0F12FF64,
	0x0F12FEEC,
	0x0F1201FD,
	0x0F12FF8E,
	0x0F12FF4E,
	0x0F120164,
	0x0F12011D,
	0x0F12FFEA,
	0x0F12FFDE,
	0x0F1201E9,
	0x0F120178,
	0x0F12FFBF,
	0x0F120193,

	/* Set NB */
	0x002A07EA,
	0x0F120000, /* afit_bUseNoiseInd 0 : NB 1: Noise Index */

	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */


	/* Set AFIT */
	/* AFIT Start Address */
	0x002A0814,
	0x0F12082C, /* TVAR_afit_pBaseVals */
	0x0F127000, /* TVAR_afit_pBaseVals */

	/* param_start	TVAR_afit_pBaseVals */
	0x002A082C,
	0x0F120003, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F12FFFE, /* SATURATION                                                               */
	0x0F12FFE2, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120028, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120344, /* UVDenoise_iYLowThresh                                                    */
	0x0F12033A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120035, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120014, /* Denoise1_iYDenThreshLow                                                  */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120064, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120114, /* UVDenoise_iYLowThresh                                                    */
	0x0F12020A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120008, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F12000C, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120060, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120014, /* UVDenoise_iYLowThresh                                                    */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F12005A, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120014, /* UVDenoise_iYLowThresh                                                    */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F12000A, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120000, /* UVDenoise_iYLowThresh                                                    */
	0x0F120000, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */

	0x0F1200FF, /* Denoise1_iUVDenThreshLow                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                         */
	0x0F120800, /* Denoise1_sensor_width                             */
	0x0F120600, /* Denoise1_sensor_height                            */
	0x0F120000, /* Denoise1_start_x                                  */
	0x0F120000, /* Denoise1_start_y                                  */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "          */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "        */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  "  */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "           */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "         */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "      */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "     */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh" */
	0x0F120000, /*  Demosaic4_iBypassSelect                          */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */

	0x0028D000,
	0x002AB0CC,
	0x0F12000B, /* Non contious mode */
	/* VT-Call END of Initial */
};

#if 0
/* Set-data based on SKT VT standard ,when using 3G network
* 8fps, 528x432 preview size.
*/
static const u32 s5k5bafx_vt_common[] =
{
	/* VT-Call */

	0xFCFCD000,

	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* Delay */


	/* Trap and Patch  2008-11-18 10:15:41 */
	0x00287000,
	0x002A1668,
	0x0F12B5FE,
	0x0F120007,
	0x0F12683C,
	0x0F12687E,
	0x0F121DA5,
	0x0F1288A0,
	0x0F122800,
	0x0F12D00B,
	0x0F1288A8,
	0x0F122800,
	0x0F12D008,
	0x0F128820,
	0x0F128829,
	0x0F124288,
	0x0F12D301,
	0x0F121A40,
	0x0F12E000,
	0x0F121A08,
	0x0F129001,
	0x0F12E001,
	0x0F122019,
	0x0F129001,
	0x0F124916,
	0x0F12466B,
	0x0F128A48,
	0x0F128118,
	0x0F128A88,
	0x0F128158,
	0x0F124814,
	0x0F128940,
	0x0F120040,
	0x0F122103,
	0x0F12F000,
	0x0F12F826,
	0x0F1288A1,
	0x0F124288,
	0x0F12D908,
	0x0F128828,
	0x0F128030,
	0x0F128868,
	0x0F128070,
	0x0F1288A8,
	0x0F126038,
	0x0F12BCFE,
	0x0F12BC08,
	0x0F124718,
	0x0F1288A9,
	0x0F124288,
	0x0F12D906,
	0x0F128820,
	0x0F128030,
	0x0F128860,
	0x0F128070,
	0x0F1288A0,
	0x0F126038,
	0x0F12E7F2,
	0x0F129801,
	0x0F12A902,
	0x0F12F000,
	0x0F12F812,
	0x0F120033,
	0x0F120029,
	0x0F129A02,
	0x0F120020,
	0x0F12F000,
	0x0F12F814,
	0x0F126038,
	0x0F12E7E6,
	0x0F121A28,
	0x0F127000,
	0x0F120D64,
	0x0F127000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F126009,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12622F,
	0x0F120000,
	0x002A2080,
	0x0F12B510,
	0x0F12F000,
	0x0F12F8F4,
	0x0F12BC10,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F0,
	0x0F12B08B,
	0x0F120006,
	0x0F122000,
	0x0F129004,
	0x0F126835,
	0x0F126874,
	0x0F1268B0,
	0x0F12900A,
	0x0F1268F0,
	0x0F129009,
	0x0F124F7D,
	0x0F128979,
	0x0F12084A,
	0x0F1288A8,
	0x0F1288A3,
	0x0F124298,
	0x0F12D300,
	0x0F120018,
	0x0F12F000,
	0x0F12F907,
	0x0F129007,
	0x0F120021,
	0x0F120028,
	0x0F12AA04,
	0x0F12F000,
	0x0F12F909,
	0x0F129006,
	0x0F1288A8,
	0x0F122800,
	0x0F12D102,
	0x0F1227FF,
	0x0F121C7F,
	0x0F12E047,
	0x0F1288A0,
	0x0F122800,
	0x0F12D101,
	0x0F122700,
	0x0F12E042,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12F000,
	0x0F12F8F8,
	0x0F129008,
	0x0F128ABA,
	0x0F129808,
	0x0F12466B,
	0x0F124342,
	0x0F129202,
	0x0F128820,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8EA,
	0x0F129A02,
	0x0F1217D1,
	0x0F120E09,
	0x0F121889,
	0x0F121209,
	0x0F124288,
	0x0F12DD1F,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8DA,
	0x0F129001,
	0x0F128828,
	0x0F12466B,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12980A,
	0x0F129902,
	0x0F12F000,
	0x0F12F8D0,
	0x0F128AB9,
	0x0F129A08,
	0x0F124351,
	0x0F1217CA,
	0x0F120E12,
	0x0F121851,
	0x0F12120A,
	0x0F129901,
	0x0F12F000,
	0x0F12F8B6,
	0x0F120407,
	0x0F120C3F,
	0x0F12E000,
	0x0F122700,
	0x0F128820,
	0x0F12466B,
	0x0F12AA05,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12003B,
	0x0F12F000,
	0x0F12F8BB,
	0x0F1288A1,
	0x0F1288A8,
	0x0F12003A,
	0x0F12F000,
	0x0F12F8BE,
	0x0F120004,
	0x0F12A804,
	0x0F12C803,
	0x0F129A09,
	0x0F129B07,
	0x0F12F000,
	0x0F12F8AF,
	0x0F12A806,
	0x0F12C805,
	0x0F120021,
	0x0F12F000,
	0x0F12F8B2,
	0x0F126030,
	0x0F12B00B,
	0x0F12BCF0,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F1,
	0x0F129900,
	0x0F12680C,
	0x0F12493A,
	0x0F12694B,
	0x0F12698A,
	0x0F124694,
	0x0F1269CD,
	0x0F126A0E,
	0x0F124F38,
	0x0F1242BC,
	0x0F12D800,
	0x0F120027,
	0x0F124937,
	0x0F126B89,
	0x0F120409,
	0x0F120C09,
	0x0F124A35,
	0x0F121E92,
	0x0F126BD2,
	0x0F120412,
	0x0F120C12,
	0x0F12429F,
	0x0F12D801,
	0x0F120020,
	0x0F12E031,
	0x0F12001F,
	0x0F12434F,
	0x0F120A3F,
	0x0F1242A7,
	0x0F12D301,
	0x0F120018,
	0x0F12E02A,
	0x0F12002B,
	0x0F12434B,
	0x0F120A1B,
	0x0F1242A3,
	0x0F12D303,
	0x0F120220,
	0x0F12F000,
	0x0F12F88C,
	0x0F12E021,
	0x0F120029,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D301,
	0x0F120028,
	0x0F12E01A,
	0x0F120031,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D304,
	0x0F120220,
	0x0F120011,
	0x0F12F000,
	0x0F12F87B,
	0x0F12E010,
	0x0F12491E,
	0x0F128C89,
	0x0F12000A,
	0x0F124372,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D301,
	0x0F120030,
	0x0F12E007,
	0x0F124662,
	0x0F12434A,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D302,
	0x0F120220,
	0x0F12F000,
	0x0F12F869,
	0x0F124B16,
	0x0F124D18,
	0x0F128D99,
	0x0F121FCA,
	0x0F123AF9,
	0x0F12D00A,
	0x0F122001,
	0x0F120240,
	0x0F128468,
	0x0F120220,
	0x0F12F000,
	0x0F12F85D,
	0x0F129900,
	0x0F126008,
	0x0F12BCF8,
	0x0F12BC08,
	0x0F124718,
	0x0F128D19,
	0x0F128469,
	0x0F129900,
	0x0F126008,
	0x0F12E7F7,
	0x0F12B570,
	0x0F122200,
	0x0F12490E,
	0x0F12480E,
	0x0F122401,
	0x0F12F000,
	0x0F12F852,
	0x0F120022,
	0x0F12490D,
	0x0F12480D,
	0x0F122502,
	0x0F12F000,
	0x0F12F84C,
	0x0F12490C,
	0x0F12480D,
	0x0F12002A,
	0x0F12F000,
	0x0F12F847,
	0x0F12BC70,
	0x0F12BC08,
	0x0F124718,
	0x0F120D64,
	0x0F127000,
	0x0F120470,
	0x0F127000,
	0x0F12A120,
	0x0F120007,
	0x0F120402,
	0x0F127000,
	0x0F1214A0,
	0x0F127000,
	0x0F12208D,
	0x0F127000,
	0x0F12622F,
	0x0F120000,
	0x0F121669,
	0x0F127000,
	0x0F126445,
	0x0F120000,
	0x0F1221AB,
	0x0F127000,
	0x0F122AA9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125F49,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FC7,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125457,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FA3,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F1251F9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A007,
	0x0F120000,
	0x0F126546,
	0x0F122062,
	0x0F123120,
	0x0F123220,
	0x0F123130,
	0x0F120030,
	0x0F12E010,
	0x0F120208,
	0x0F120058,
	0x0F120000,
	/* End of Trap and Patch (Last : 70002342h) */
	/* Total Size 896 (0x0380)                  */

	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0,	/* setot_uOnlineClocksDiv40             */
	0x002A0AE2,
	0x0F12222E,	/* setot_usSetRomWaitStateThreshold4KHz */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */

	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,


	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,

	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,

	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,

	0x0F120015,


	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,


	0x002AF900,
	0x0F120067,


	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,

	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,

	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,

	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,

	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,

	0x002AF4D6,
	0x0F120090,

	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,

	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,

	/* sensor aig table setting   sunkyu start */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,
	0x002A1084,
	0x0F120000,
	0x0F120000,

	/* Set AE Target */
	0x002A0F4C,
	0x0F12003C, /* 3A TVAR_ae_BrAve */

	0x002A0478,
	0x0F120114,
	0x0F1200EB, /* ae boundary */


	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A, /*uMaxExp1         */
	0x0F120000,
	0x002A048C,
	0x0F128214, /*uMaxExp2         */
	0x0F120000,
	0x0F12A122, /*uMaxExp3         */
	0x0F120000,
	0x002A0488,
	0x0F12f424, /*uMaxExp4         */
	0x0F120000,
	0x002A043A,
	0x0F1201D0, /*lt_uMaxAnGain0   */
	0x0F1201E0, /*lt_uMaxAnGain0_1 */
	0x002A0494,
	0x0F120300, /*lt_uMaxAnGain1   */
	0x0F120C80, /* E00 lt_uMaxAnGain2   */
	0x0f120100,
	0x002A0F52,
	0x0F12000F, /*ae_StatMode      */

	0x002A0E98, /* bp_uMaxBrightnessFactor */
	0x0F1202B0,
	0x002A0E9E, /* bp_uMinBrightnessFactor */
	0x0F120290,

	/* 1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001, /* AFC_Default60Hz	 Auto Flicker 60Hz start 0: Auto Flicker 50Hz start */
	0x002A03F8,
	0x0F12007F, /* REG_TC_DBG_AutoAlgEnBits             default : 007F */


	0xffff000a, /* Wait10mSec */


	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0, /* REG_TC_IPRM_InClockLSBs */
	0x0F120000, /* REG_TC_IPRM_InClockMSBs */

	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001, /* REG_TC_IPRM_UseNPviClocks         */
	0x0F120001, /* REG_TC_IPRM_UseNMipiClocks        */
	0x0F120000, /* REG_TC_IPRM_bBlockInternalPllCalc */

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770, /* REG_TC_IPRM_OpClk4KHz_0      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_0 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_0 */

	/* System Clock 1 (System : 28Mhz, PCLK : 48Mhz) */
	0x002A01D2,
	0x0F121B58, /* REG_TC_IPRM_OpClk4KHz_1      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_1 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_1 */


	0x002A01DE,
	0x0F120001, /* REG_TC_IPRM_UseRegsAPI        */
	0x0F120001, /* REG_TC_IPRM_InitParamsUpdated */
	0xffff0064, /* Delay 100ms                   */



	/* Crop */
	0x002A01FA,
	0x0F120640, /* REG_TC_GP_PrevReqInputWidth  */
	0x0F1204B0, /* REG_TC_GP_PrevReqInputHeight */
	0x0F120000, /* REG_TC_GP_PrevInputWidthOfs  */
	0x0F120000, /* REG_TC_GP_PrevInputHeightOfs */


	/* Set Preview Config */
	/* Preview Config 0 (1600x1200 fixed 15fps) */
	0x002A0242,
	0x0F120280, /* REG_0TC_PCFG_usWidth               */
	0x0F1201E0, /* REG_0TC_PCFG_usHeight              */
	0x0F120005, /* REG_0TC_PCFG_Format                */
	0x0F122EE0, /* REG_0TC_PCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_PCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_PCFG_PVIMask               */
	0x0F120001, /* REG_0TC_PCFG_uClockInd             */
	0x0F120002, /* REG_0TC_PCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_PCFG_FrRateQualityType     */
	0x0F1204E2, /* REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
	0x0F1204E2, /* REG_0TC_PCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_PCFG_sSaturation           */
	0x0F120000, /* REG_0TC_PCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_PCFG_sGlamour              */
	0x0F120000, /* REG_0TC_PCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_PCFG_uDeviceGammaIndex     */
	0x0F120000, /* REG_0TC_PCFG_uPrevMirror           */
	0x0F120000, /* REG_0TC_PCFG_uCaptureMirror        */
	0x0F120000, /* REG_0TC_PCFG_uRotation             */

	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280, /* REG_1TC_PCFG_usWidth               */
	0x0F1201E0, /* REG_1TC_PCFG_usHeight              */
	0x0F120005, /* REG_1TC_PCFG_Format                */
	0x0F122EE0, /* REG_1TC_PCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_1TC_PCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_1TC_PCFG_PVIMask               */
	0x0F120001, /* REG_1TC_PCFG_uClockInd             */
	0x0F120000, /* REG_1TC_PCFG_usFrTimeType          */
	0x0F120000, /* REG_1TC_PCFG_FrRateQualityType     */
	0x0F12029A, /* REG_1TC_PCFG_usMaxFrTimeMsecMult10 */
	0x0F12014D, /* REG_1TC_PCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_1TC_PCFG_sSaturation           */
	0x0F120000, /* REG_1TC_PCFG_sSharpBlur            */
	0x0F120000, /* REG_1TC_PCFG_sGlamour              */
	0x0F120000, /* REG_1TC_PCFG_sColorTemp            */
	0x0F120000, /* REG_1TC_PCFG_uDeviceGammaIndex     */
	0x0F120000, /* REG_1TC_PCFG_uPrevMirror           */
	0x0F120000, /* REG_1TC_PCFG_uCaptureMirror        */
	0x0F120000, /* REG_1TC_PCFG_uRotation             */



	/* Set MIPI */
	0x002A03AC,
	0x0F120000, /* REG_TC_FLS_Mode        */
	0x002A03F2,
	0x0F120001, /* REG_TC_OIF_EnMipiLanes */
	0x0F1200C3, /* REG_TC_OIF_EnPackets   */
	0x0F120001, /* REG_TC_OIF_CfgChanged  */

	/* Apply preview config */
	/* 0x002A021C, */
	/* 0x0F120000, */ /* REG_TC_GP_ActivePrevConfig     */
	/* 0x002A0220, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevOpenAfterChange  */
	/* 0x002A01F8, */
	/* 0x0F120001, */ /* REG_TC_GP_NewConfigSync        */
	/* 0x002A021E, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevConfigChanged    */
	/* 0x002A01F0, */
	/* 0x0F120001, */ /* REG_TC_GP_EnablePreview        */
	/* 0x0F120001, */ /* REG_TC_GP_EnablePreviewChanged */



	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000, /* REG_0TC_CCFG_uCaptureMode          */
	0x0F120640, /* REG_0TC_CCFG_usWidth               */
	0x0F1204B0, /* REG_0TC_CCFG_usHeight              */
	0x0F120005, /* REG_0TC_CCFG_Format                */
	0x0F122EE0, /* REG_0TC_CCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_CCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_CCFG_PVIMask               */
	0x0F120001, /* REG_0TC_CCFG_uClockInd             */
	0x0F120002, /* REG_0TC_CCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_CCFG_FrRateQualityType     */
	0x0F1204E2, /* REG_0TC_CCFG_usMaxFrTimeMsecMult10 */
	0x0F1204E2, /* REG_0TC_CCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_CCFG_sSaturation           */
	0x0F120000, /* REG_0TC_CCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_CCFG_sGlamour              */
	0x0F120000, /* REG_0TC_CCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_CCFG_uDeviceGammaIndex     */

	/* Update preview and capture configuration */
	0x002A021C,
	0x0F120000,	/* #REG_TC_GP_ActivePrevConfig */
	0x002A0224,
	0x0F120000,	/* #REG_TC_GP_ActiveCapConfig */
	0x002A0220,
	0x0F120001,	/* #REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001,	/* #REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001,	/* #REG_TC_GP_PrevConfigChanged */
	0x002A0226,
	0x0F120001,	/* #REG_TC_GP_CapConfigChanged */

	/* Run preivew */
	0x002A01F0,
	0x0F120001,	/* #REG_TC_GP_EnablePreview */
	0x002A01F2,
	0x0F120001,	/* #REG_TC_GP_EnablePreviewChanged */


	0x002A0242,
	0x0F120210, /* Output_x	 528d */
	0x0F1201B0, /* Output_y	 432d */

	0x002A020A,
	0x0F1205BA, /* #REG_TC_GP_PrevZoomReqInputWidth     */
	0x0F1204B0, /* #REG_TC_GP_PrevZoomReqInputHeight    */
	0x0F120043, /* #REG_TC_GP_PrevZoomReqInputWidthOfs  */
	0x0F120000, /* #REG_TC_GP_PrevZoomReqInputHeightOfs */
	0x002A021A,
	0x0F120001, /* #REG_TC_GP_InputsChangeRequest      */

	/* Update preview configuration */
	0x002A01F8,
	0x0F120001, /* #REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* #REG_TC_GP_PrevConfigChanged */

	/* Periodic mismatch */
	0x002A0780,
	0x0F120000, /* msm_uOffsetNoBin[0][0]    */
	0x0F120000, /* msm_uOffsetNoBin[0][1]    */
	0x0F120000, /* msm_uOffsetNoBin[1][0]    */
	0x0F120000, /* msm_uOffsetNoBin[1][1]    */
	0x0F120000, /* msm_uOffsetNoBin[2][0]    */
	0x0F120000, /* msm_uOffsetNoBin[2][1]    */
	0x0F120000, /* msm_uOffsetNoBin[3][0]    */
	0x0F120000, /* msm_uOffsetNoBin[3][1]    */

	0x002A0798,
	0x0F120000, /* msm_uOffsetBin[0][0]      */
	0x0F120000, /* msm_uOffsetBin[0][1]      */
	0x0F120000, /* msm_uOffsetBin[1][0]      */
	0x0F120000, /* msm_uOffsetBin[1][1]      */

	0x002A07C0,
	0x0F120004, /* msm_NonLinearOfsOutput[2] */
	0x0F120004, /* msm_NonLinearOfsOutput[3] */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */


	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000, /* ae_WeightTbl_16_0_ */
	0x0F120000, /* ae_WeightTbl_16_1_ */
	0x0F120000, /* ae_WeightTbl_16_2_ */
	0x0F120000, /* ae_WeightTbl_16_3_ */
	0x0F120100, /* ae_WeightTbl_16_4_ */
	0x0F120101, /* ae_WeightTbl_16_5_ */
	0x0F120101, /* ae_WeightTbl_16_6_ */
	0x0F120001, /* ae_WeightTbl_16_7_ */
	0x0F120100, /* ae_WeightTbl_16_8_ */
	0x0F120302, /* ae_WeightTbl_16_9_ */
	0x0F120203, /* ae_WeightTbl_16_10 */
	0x0F120001, /* ae_WeightTbl_16_11 */
	0x0F120100, /* ae_WeightTbl_16_12 */
	0x0F120403, /* ae_WeightTbl_16_13 */
	0x0F120304, /* ae_WeightTbl_16_14 */
	0x0F120001, /* ae_WeightTbl_16_15 */
	0x0F120100, /* ae_WeightTbl_16_16 */
	0x0F120403, /* ae_WeightTbl_16_17 */
	0x0F120304, /* ae_WeightTbl_16_18 */
	0x0F120001, /* ae_WeightTbl_16_19 */
	0x0F120100, /* ae_WeightTbl_16_20 */
	0x0F120302, /* ae_WeightTbl_16_21 */
	0x0F120203, /* ae_WeightTbl_16_22 */
	0x0F120001, /* ae_WeightTbl_16_23 */
	0x0F120100, /* ae_WeightTbl_16_24 */
	0x0F120101, /* ae_WeightTbl_16_25 */
	0x0F120101, /* ae_WeightTbl_16_26 */
	0x0F120001, /* ae_WeightTbl_16_27 */
	0x0F120000, /* ae_WeightTbl_16_28 */
	0x0F120000, /* ae_WeightTbl_16_29 */
	0x0F120000, /* ae_WeightTbl_16_30 */
	0x0F120000, /* ae_WeightTbl_16_31 */


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3, /* TVAR_ash_AwbAshCord_0_ */
	0x0F1200E5, /* TVAR_ash_AwbAshCord_1_ */
	0x0F120120, /* TVAR_ash_AwbAshCord_2_ */
	0x0F120136, /* TVAR_ash_AwbAshCord_3_ */
	0x0F120180, /* TVAR_ash_AwbAshCord_4_ */
	0x0F1201B0, /* TVAR_ash_AwbAshCord_5_ */
	0x0F120200, /* TVAR_ash_AwbAshCord_6_ */

	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3, /* SARR_AwbCcmCord_0_	Hor   */
	0x0F1200E5, /* SARR_AwbCcmCord_1_	IncaA */
	0x0F120120, /* SARR_AwbCcmCord_2_	WW    */
	0x0F120136, /* SARR_AwbCcmCord_3_	CW    */
	0x0F120180, /* SARR_AwbCcmCord_4_	D50   */
	0x0F120190, /* SARR_AwbCcmCord_5_	D65   */

	/* Target Brightness Control */
	0x002A103E,
	0x0F120000, /* SARR_IllumType_0_      */
	0x0F120009, /* SARR_IllumType_1_      */
	0x0F120018, /* SARR_IllumType_2_      */
	0x0F120032, /* SARR_IllumType_3_      */
	0x0F12004A, /* SARR_IllumType_4_      */
	0x0F120051, /* SARR_IllumType_5_      */
	0x0F120056, /* SARR_IllumType_6_      */
	0x0F12010C, /* SARe_2_R_IllumTypeF_0_ */
	0x0F12010C, /* SARe_3_R_IllumTypeF_1_ */
	0x0F120109, /* SARe_4_R_IllumTypeF_2_ */
	0x0F120105, /* SARe_5_R_IllumTypeF_3_ */
	0x0F120102, /* SARe_6_R_IllumTypeF_4_ */
	0x0F1200FB, /* SARR_IllumTypeF_5_     */
	0x0F1200F8, /* SARR_IllumTypeF_6_     */

	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */

	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */

	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */

	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */

	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */

	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */

	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */

	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_ */

	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388, /* TVAR_ash_pGAS */
	0x0F127000, /* TVAR_ash_pGAS */

	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120160, /* TVAR_ash_pGAS[0]   */
	0x0F120134, /* TVAR_ash_pGAS[1]   */
	0x0F1200FF, /* TVAR_ash_pGAS[2]   */
	0x0F1200D1, /* TVAR_ash_pGAS[3]   */
	0x0F1200B1, /* TVAR_ash_pGAS[4]   */
	0x0F12009D, /* TVAR_ash_pGAS[5]   */
	0x0F120096, /* TVAR_ash_pGAS[6]   */
	0x0F12009E, /* TVAR_ash_pGAS[7]   */
	0x0F1200B3, /* TVAR_ash_pGAS[8]   */
	0x0F1200D3, /* TVAR_ash_pGAS[9]   */
	0x0F1200FF, /* TVAR_ash_pGAS[10]  */
	0x0F120131, /* TVAR_ash_pGAS[11]  */
	0x0F120159, /* TVAR_ash_pGAS[12]  */
	0x0F12013C, /* TVAR_ash_pGAS[13]  */
	0x0F120107, /* TVAR_ash_pGAS[14]  */
	0x0F1200CD, /* TVAR_ash_pGAS[15]  */
	0x0F1200A1, /* TVAR_ash_pGAS[16]  */
	0x0F120080, /* TVAR_ash_pGAS[17]  */
	0x0F12006B, /* TVAR_ash_pGAS[18]  */
	0x0F120064, /* TVAR_ash_pGAS[19]  */
	0x0F12006C, /* TVAR_ash_pGAS[20]  */
	0x0F120080, /* TVAR_ash_pGAS[21]  */
	0x0F1200A1, /* TVAR_ash_pGAS[22]  */
	0x0F1200CD, /* TVAR_ash_pGAS[23]  */
	0x0F120106, /* TVAR_ash_pGAS[24]  */
	0x0F120139, /* TVAR_ash_pGAS[25]  */
	0x0F120116, /* TVAR_ash_pGAS[26]  */
	0x0F1200DC, /* TVAR_ash_pGAS[27]  */
	0x0F1200A2, /* TVAR_ash_pGAS[28]  */
	0x0F120073, /* TVAR_ash_pGAS[29]  */
	0x0F120051, /* TVAR_ash_pGAS[30]  */
	0x0F12003B, /* TVAR_ash_pGAS[31]  */
	0x0F120033, /* TVAR_ash_pGAS[32]  */
	0x0F12003B, /* TVAR_ash_pGAS[33]  */
	0x0F120050, /* TVAR_ash_pGAS[34]  */
	0x0F120073, /* TVAR_ash_pGAS[35]  */
	0x0F1200A2, /* TVAR_ash_pGAS[36]  */
	0x0F1200DD, /* TVAR_ash_pGAS[37]  */
	0x0F120115, /* TVAR_ash_pGAS[38]  */
	0x0F1200FA, /* TVAR_ash_pGAS[39]  */
	0x0F1200BF, /* TVAR_ash_pGAS[40]  */
	0x0F120085, /* TVAR_ash_pGAS[41]  */
	0x0F120055, /* TVAR_ash_pGAS[42]  */
	0x0F120031, /* TVAR_ash_pGAS[43]  */
	0x0F12001B, /* TVAR_ash_pGAS[44]  */
	0x0F120014, /* TVAR_ash_pGAS[45]  */
	0x0F12001A, /* TVAR_ash_pGAS[46]  */
	0x0F120031, /* TVAR_ash_pGAS[47]  */
	0x0F120055, /* TVAR_ash_pGAS[48]  */
	0x0F120085, /* TVAR_ash_pGAS[49]  */
	0x0F1200C0, /* TVAR_ash_pGAS[50]  */
	0x0F1200FB, /* TVAR_ash_pGAS[51]  */
	0x0F1200EA, /* TVAR_ash_pGAS[52]  */
	0x0F1200AF, /* TVAR_ash_pGAS[53]  */
	0x0F120074, /* TVAR_ash_pGAS[54]  */
	0x0F120045, /* TVAR_ash_pGAS[55]  */
	0x0F120020, /* TVAR_ash_pGAS[56]  */
	0x0F12000B, /* TVAR_ash_pGAS[57]  */
	0x0F120003, /* TVAR_ash_pGAS[58]  */
	0x0F12000A, /* TVAR_ash_pGAS[59]  */
	0x0F120020, /* TVAR_ash_pGAS[60]  */
	0x0F120046, /* TVAR_ash_pGAS[61]  */
	0x0F120076, /* TVAR_ash_pGAS[62]  */
	0x0F1200B1, /* TVAR_ash_pGAS[63]  */
	0x0F1200ED, /* TVAR_ash_pGAS[64]  */
	0x0F1200E6, /* TVAR_ash_pGAS[65]  */
	0x0F1200AA, /* TVAR_ash_pGAS[66]  */
	0x0F120071, /* TVAR_ash_pGAS[67]  */
	0x0F120041, /* TVAR_ash_pGAS[68]  */
	0x0F12001D, /* TVAR_ash_pGAS[69]  */
	0x0F120008, /* TVAR_ash_pGAS[70]  */
	0x0F120000, /* TVAR_ash_pGAS[71]  */
	0x0F120007, /* TVAR_ash_pGAS[72]  */
	0x0F12001E, /* TVAR_ash_pGAS[73]  */
	0x0F120044, /* TVAR_ash_pGAS[74]  */
	0x0F120074, /* TVAR_ash_pGAS[75]  */
	0x0F1200B0, /* TVAR_ash_pGAS[76]  */
	0x0F1200EC, /* TVAR_ash_pGAS[77]  */
	0x0F1200EF, /* TVAR_ash_pGAS[78]  */
	0x0F1200B3, /* TVAR_ash_pGAS[79]  */
	0x0F12007A, /* TVAR_ash_pGAS[80]  */
	0x0F12004A, /* TVAR_ash_pGAS[81]  */
	0x0F120026, /* TVAR_ash_pGAS[82]  */
	0x0F120011, /* TVAR_ash_pGAS[83]  */
	0x0F12000A, /* TVAR_ash_pGAS[84]  */
	0x0F120011, /* TVAR_ash_pGAS[85]  */
	0x0F120029, /* TVAR_ash_pGAS[86]  */
	0x0F12004F, /* TVAR_ash_pGAS[87]  */
	0x0F120080, /* TVAR_ash_pGAS[88]  */
	0x0F1200BC, /* TVAR_ash_pGAS[89]  */
	0x0F1200F8, /* TVAR_ash_pGAS[90]  */
	0x0F120105, /* TVAR_ash_pGAS[91]  */
	0x0F1200C9, /* TVAR_ash_pGAS[92]  */
	0x0F12008F, /* TVAR_ash_pGAS[93]  */
	0x0F120060, /* TVAR_ash_pGAS[94]  */
	0x0F12003C, /* TVAR_ash_pGAS[95]  */
	0x0F120026, /* TVAR_ash_pGAS[96]  */
	0x0F12001F, /* TVAR_ash_pGAS[97]  */
	0x0F120028, /* TVAR_ash_pGAS[98]  */
	0x0F120040, /* TVAR_ash_pGAS[99]  */
	0x0F120066, /* TVAR_ash_pGAS[100] */
	0x0F120097, /* TVAR_ash_pGAS[101] */
	0x0F1200D4, /* TVAR_ash_pGAS[102] */
	0x0F120110, /* TVAR_ash_pGAS[103] */
	0x0F120124, /* TVAR_ash_pGAS[104] */
	0x0F1200EB, /* TVAR_ash_pGAS[105] */
	0x0F1200B1, /* TVAR_ash_pGAS[106] */
	0x0F120082, /* TVAR_ash_pGAS[107] */
	0x0F12005F, /* TVAR_ash_pGAS[108] */
	0x0F12004A, /* TVAR_ash_pGAS[109] */
	0x0F120043, /* TVAR_ash_pGAS[110] */
	0x0F12004C, /* TVAR_ash_pGAS[111] */
	0x0F120064, /* TVAR_ash_pGAS[112] */
	0x0F120089, /* TVAR_ash_pGAS[113] */
	0x0F1200BA, /* TVAR_ash_pGAS[114] */
	0x0F1200F8, /* TVAR_ash_pGAS[115] */
	0x0F12012F, /* TVAR_ash_pGAS[116] */
	0x0F120147, /* TVAR_ash_pGAS[117] */
	0x0F120116, /* TVAR_ash_pGAS[118] */
	0x0F1200DE, /* TVAR_ash_pGAS[119] */
	0x0F1200AF, /* TVAR_ash_pGAS[120] */
	0x0F12008E, /* TVAR_ash_pGAS[121] */
	0x0F12007A, /* TVAR_ash_pGAS[122] */
	0x0F120072, /* TVAR_ash_pGAS[123] */
	0x0F12007A, /* TVAR_ash_pGAS[124] */
	0x0F120091, /* TVAR_ash_pGAS[125] */
	0x0F1200B6, /* TVAR_ash_pGAS[126] */
	0x0F1200E8, /* TVAR_ash_pGAS[127] */
	0x0F120121, /* TVAR_ash_pGAS[128] */
	0x0F120150, /* TVAR_ash_pGAS[129] */
	0x0F120170, /* TVAR_ash_pGAS[130] */
	0x0F12013F, /* TVAR_ash_pGAS[131] */
	0x0F120110, /* TVAR_ash_pGAS[132] */
	0x0F1200E2, /* TVAR_ash_pGAS[133] */
	0x0F1200C0, /* TVAR_ash_pGAS[134] */
	0x0F1200AB, /* TVAR_ash_pGAS[135] */
	0x0F1200A4, /* TVAR_ash_pGAS[136] */
	0x0F1200AC, /* TVAR_ash_pGAS[137] */
	0x0F1200C3, /* TVAR_ash_pGAS[138] */
	0x0F1200E6, /* TVAR_ash_pGAS[139] */
	0x0F120117, /* TVAR_ash_pGAS[140] */
	0x0F120145, /* TVAR_ash_pGAS[141] */
	0x0F120172, /* TVAR_ash_pGAS[142] */
	0x0F120127, /* TVAR_ash_pGAS[143] */
	0x0F120100, /* TVAR_ash_pGAS[144] */
	0x0F1200CF, /* TVAR_ash_pGAS[145] */
	0x0F1200A7, /* TVAR_ash_pGAS[146] */
	0x0F12008D, /* TVAR_ash_pGAS[147] */
	0x0F12007D, /* TVAR_ash_pGAS[148] */
	0x0F120077, /* TVAR_ash_pGAS[149] */
	0x0F12007A, /* TVAR_ash_pGAS[150] */
	0x0F120087, /* TVAR_ash_pGAS[151] */
	0x0F12009E, /* TVAR_ash_pGAS[152] */
	0x0F1200C0, /* TVAR_ash_pGAS[153] */
	0x0F1200EC, /* TVAR_ash_pGAS[154] */
	0x0F12010F, /* TVAR_ash_pGAS[155] */
	0x0F120108, /* TVAR_ash_pGAS[156] */
	0x0F1200D8, /* TVAR_ash_pGAS[157] */
	0x0F1200A5, /* TVAR_ash_pGAS[158] */
	0x0F120080, /* TVAR_ash_pGAS[159] */
	0x0F120066, /* TVAR_ash_pGAS[160] */
	0x0F120056, /* TVAR_ash_pGAS[161] */
	0x0F12004F, /* TVAR_ash_pGAS[162] */
	0x0F120053, /* TVAR_ash_pGAS[163] */
	0x0F120061, /* TVAR_ash_pGAS[164] */
	0x0F120077, /* TVAR_ash_pGAS[165] */
	0x0F120098, /* TVAR_ash_pGAS[166] */
	0x0F1200C6, /* TVAR_ash_pGAS[167] */
	0x0F1200F3, /* TVAR_ash_pGAS[168] */
	0x0F1200E7, /* TVAR_ash_pGAS[169] */
	0x0F1200B4, /* TVAR_ash_pGAS[170] */
	0x0F120081, /* TVAR_ash_pGAS[171] */
	0x0F12005C, /* TVAR_ash_pGAS[172] */
	0x0F120041, /* TVAR_ash_pGAS[173] */
	0x0F120030, /* TVAR_ash_pGAS[174] */
	0x0F120029, /* TVAR_ash_pGAS[175] */
	0x0F12002E, /* TVAR_ash_pGAS[176] */
	0x0F12003D, /* TVAR_ash_pGAS[177] */
	0x0F120055, /* TVAR_ash_pGAS[178] */
	0x0F120076, /* TVAR_ash_pGAS[179] */
	0x0F1200A5, /* TVAR_ash_pGAS[180] */
	0x0F1200D4, /* TVAR_ash_pGAS[181] */
	0x0F1200CF, /* TVAR_ash_pGAS[182] */
	0x0F12009B, /* TVAR_ash_pGAS[183] */
	0x0F12006A, /* TVAR_ash_pGAS[184] */
	0x0F120043, /* TVAR_ash_pGAS[185] */
	0x0F120027, /* TVAR_ash_pGAS[186] */
	0x0F120016, /* TVAR_ash_pGAS[187] */
	0x0F12000F, /* TVAR_ash_pGAS[188] */
	0x0F120015, /* TVAR_ash_pGAS[189] */
	0x0F120025, /* TVAR_ash_pGAS[190] */
	0x0F12003E, /* TVAR_ash_pGAS[191] */
	0x0F120061, /* TVAR_ash_pGAS[192] */
	0x0F12008E, /* TVAR_ash_pGAS[193] */
	0x0F1200BF, /* TVAR_ash_pGAS[194] */
	0x0F1200C2, /* TVAR_ash_pGAS[195] */
	0x0F12008E, /* TVAR_ash_pGAS[196] */
	0x0F12005D, /* TVAR_ash_pGAS[197] */
	0x0F120037, /* TVAR_ash_pGAS[198] */
	0x0F12001A, /* TVAR_ash_pGAS[199] */
	0x0F120009, /* TVAR_ash_pGAS[200] */
	0x0F120002, /* TVAR_ash_pGAS[201] */
	0x0F120007, /* TVAR_ash_pGAS[202] */
	0x0F120018, /* TVAR_ash_pGAS[203] */
	0x0F120033, /* TVAR_ash_pGAS[204] */
	0x0F120057, /* TVAR_ash_pGAS[205] */
	0x0F120083, /* TVAR_ash_pGAS[206] */
	0x0F1200B3, /* TVAR_ash_pGAS[207] */
	0x0F1200BE, /* TVAR_ash_pGAS[208] */
	0x0F12008A, /* TVAR_ash_pGAS[209] */
	0x0F12005A, /* TVAR_ash_pGAS[210] */
	0x0F120034, /* TVAR_ash_pGAS[211] */
	0x0F120017, /* TVAR_ash_pGAS[212] */
	0x0F120006, /* TVAR_ash_pGAS[213] */
	0x0F120000, /* TVAR_ash_pGAS[214] */
	0x0F120006, /* TVAR_ash_pGAS[215] */
	0x0F120017, /* TVAR_ash_pGAS[216] */
	0x0F120033, /* TVAR_ash_pGAS[217] */
	0x0F120057, /* TVAR_ash_pGAS[218] */
	0x0F120083, /* TVAR_ash_pGAS[219] */
	0x0F1200B3, /* TVAR_ash_pGAS[220] */
	0x0F1200C5, /* TVAR_ash_pGAS[221] */
	0x0F120091, /* TVAR_ash_pGAS[222] */
	0x0F120061, /* TVAR_ash_pGAS[223] */
	0x0F12003B, /* TVAR_ash_pGAS[224] */
	0x0F120020, /* TVAR_ash_pGAS[225] */
	0x0F12000F, /* TVAR_ash_pGAS[226] */
	0x0F120009, /* TVAR_ash_pGAS[227] */
	0x0F120010, /* TVAR_ash_pGAS[228] */
	0x0F120021, /* TVAR_ash_pGAS[229] */
	0x0F12003D, /* TVAR_ash_pGAS[230] */
	0x0F120060, /* TVAR_ash_pGAS[231] */
	0x0F12008D, /* TVAR_ash_pGAS[232] */
	0x0F1200BE, /* TVAR_ash_pGAS[233] */
	0x0F1200D7, /* TVAR_ash_pGAS[234] */
	0x0F1200A2, /* TVAR_ash_pGAS[235] */
	0x0F120072, /* TVAR_ash_pGAS[236] */
	0x0F12004D, /* TVAR_ash_pGAS[237] */
	0x0F120032, /* TVAR_ash_pGAS[238] */
	0x0F120022, /* TVAR_ash_pGAS[239] */
	0x0F12001D, /* TVAR_ash_pGAS[240] */
	0x0F120024, /* TVAR_ash_pGAS[241] */
	0x0F120035, /* TVAR_ash_pGAS[242] */
	0x0F120050, /* TVAR_ash_pGAS[243] */
	0x0F120073, /* TVAR_ash_pGAS[244] */
	0x0F1200A0, /* TVAR_ash_pGAS[245] */
	0x0F1200D2, /* TVAR_ash_pGAS[246] */
	0x0F1200F0, /* TVAR_ash_pGAS[247] */
	0x0F1200BE, /* TVAR_ash_pGAS[248] */
	0x0F12008C, /* TVAR_ash_pGAS[249] */
	0x0F120068, /* TVAR_ash_pGAS[250] */
	0x0F12004F, /* TVAR_ash_pGAS[251] */
	0x0F120040, /* TVAR_ash_pGAS[252] */
	0x0F12003B, /* TVAR_ash_pGAS[253] */
	0x0F120041, /* TVAR_ash_pGAS[254] */
	0x0F120052, /* TVAR_ash_pGAS[255] */
	0x0F12006C, /* TVAR_ash_pGAS[256] */
	0x0F12008E, /* TVAR_ash_pGAS[257] */
	0x0F1200BE, /* TVAR_ash_pGAS[258] */
	0x0F1200ED, /* TVAR_ash_pGAS[259] */
	0x0F12010C, /* TVAR_ash_pGAS[260] */
	0x0F1200E1, /* TVAR_ash_pGAS[261] */
	0x0F1200AF, /* TVAR_ash_pGAS[262] */
	0x0F12008A, /* TVAR_ash_pGAS[263] */
	0x0F120072, /* TVAR_ash_pGAS[264] */
	0x0F120064, /* TVAR_ash_pGAS[265] */
	0x0F12005F, /* TVAR_ash_pGAS[266] */
	0x0F120065, /* TVAR_ash_pGAS[267] */
	0x0F120074, /* TVAR_ash_pGAS[268] */
	0x0F12008D, /* TVAR_ash_pGAS[269] */
	0x0F1200B2, /* TVAR_ash_pGAS[270] */
	0x0F1200E0, /* TVAR_ash_pGAS[271] */
	0x0F12010A, /* TVAR_ash_pGAS[272] */
	0x0F12012F, /* TVAR_ash_pGAS[273] */
	0x0F120104, /* TVAR_ash_pGAS[274] */
	0x0F1200D9, /* TVAR_ash_pGAS[275] */
	0x0F1200B3, /* TVAR_ash_pGAS[276] */
	0x0F120099, /* TVAR_ash_pGAS[277] */
	0x0F12008B, /* TVAR_ash_pGAS[278] */
	0x0F120086, /* TVAR_ash_pGAS[279] */
	0x0F12008B, /* TVAR_ash_pGAS[280] */
	0x0F12009B, /* TVAR_ash_pGAS[281] */
	0x0F1200B5, /* TVAR_ash_pGAS[282] */
	0x0F1200DA, /* TVAR_ash_pGAS[283] */
	0x0F120101, /* TVAR_ash_pGAS[284] */
	0x0F120128, /* TVAR_ash_pGAS[285] */
	0x0F12012F, /* TVAR_ash_pGAS[286] */
	0x0F120106, /* TVAR_ash_pGAS[287] */
	0x0F1200D4, /* TVAR_ash_pGAS[288] */
	0x0F1200AA, /* TVAR_ash_pGAS[289] */
	0x0F12008E, /* TVAR_ash_pGAS[290] */
	0x0F12007D, /* TVAR_ash_pGAS[291] */
	0x0F120079, /* TVAR_ash_pGAS[292] */
	0x0F120080, /* TVAR_ash_pGAS[293] */
	0x0F120093, /* TVAR_ash_pGAS[294] */
	0x0F1200B1, /* TVAR_ash_pGAS[295] */
	0x0F1200DC, /* TVAR_ash_pGAS[296] */
	0x0F12010C, /* TVAR_ash_pGAS[297] */
	0x0F120130, /* TVAR_ash_pGAS[298] */
	0x0F120112, /* TVAR_ash_pGAS[299] */
	0x0F1200E0, /* TVAR_ash_pGAS[300] */
	0x0F1200AB, /* TVAR_ash_pGAS[301] */
	0x0F120083, /* TVAR_ash_pGAS[302] */
	0x0F120067, /* TVAR_ash_pGAS[303] */
	0x0F120057, /* TVAR_ash_pGAS[304] */
	0x0F120051, /* TVAR_ash_pGAS[305] */
	0x0F120059, /* TVAR_ash_pGAS[306] */
	0x0F12006B, /* TVAR_ash_pGAS[307] */
	0x0F120089, /* TVAR_ash_pGAS[308] */
	0x0F1200B2, /* TVAR_ash_pGAS[309] */
	0x0F1200E5, /* TVAR_ash_pGAS[310] */
	0x0F120114, /* TVAR_ash_pGAS[311] */
	0x0F1200F2, /* TVAR_ash_pGAS[312] */
	0x0F1200BD, /* TVAR_ash_pGAS[313] */
	0x0F120088, /* TVAR_ash_pGAS[314] */
	0x0F120061, /* TVAR_ash_pGAS[315] */
	0x0F120044, /* TVAR_ash_pGAS[316] */
	0x0F120031, /* TVAR_ash_pGAS[317] */
	0x0F12002C, /* TVAR_ash_pGAS[318] */
	0x0F120033, /* TVAR_ash_pGAS[319] */
	0x0F120047, /* TVAR_ash_pGAS[320] */
	0x0F120065, /* TVAR_ash_pGAS[321] */
	0x0F12008C, /* TVAR_ash_pGAS[322] */
	0x0F1200C0, /* TVAR_ash_pGAS[323] */
	0x0F1200F3, /* TVAR_ash_pGAS[324] */
	0x0F1200DB, /* TVAR_ash_pGAS[325] */
	0x0F1200A5, /* TVAR_ash_pGAS[326] */
	0x0F120071, /* TVAR_ash_pGAS[327] */
	0x0F120049, /* TVAR_ash_pGAS[328] */
	0x0F12002A, /* TVAR_ash_pGAS[329] */
	0x0F120018, /* TVAR_ash_pGAS[330] */
	0x0F120011, /* TVAR_ash_pGAS[331] */
	0x0F120018, /* TVAR_ash_pGAS[332] */
	0x0F12002C, /* TVAR_ash_pGAS[333] */
	0x0F12004B, /* TVAR_ash_pGAS[334] */
	0x0F120072, /* TVAR_ash_pGAS[335] */
	0x0F1200A3, /* TVAR_ash_pGAS[336] */
	0x0F1200D7, /* TVAR_ash_pGAS[337] */
	0x0F1200CD, /* TVAR_ash_pGAS[338] */
	0x0F120097, /* TVAR_ash_pGAS[339] */
	0x0F120065, /* TVAR_ash_pGAS[340] */
	0x0F12003C, /* TVAR_ash_pGAS[341] */
	0x0F12001D, /* TVAR_ash_pGAS[342] */
	0x0F12000A, /* TVAR_ash_pGAS[343] */
	0x0F120003, /* TVAR_ash_pGAS[344] */
	0x0F120009, /* TVAR_ash_pGAS[345] */
	0x0F12001D, /* TVAR_ash_pGAS[346] */
	0x0F12003B, /* TVAR_ash_pGAS[347] */
	0x0F120063, /* TVAR_ash_pGAS[348] */
	0x0F120092, /* TVAR_ash_pGAS[349] */
	0x0F1200C4, /* TVAR_ash_pGAS[350] */
	0x0F1200CA, /* TVAR_ash_pGAS[351] */
	0x0F120094, /* TVAR_ash_pGAS[352] */
	0x0F120062, /* TVAR_ash_pGAS[353] */
	0x0F12003A, /* TVAR_ash_pGAS[354] */
	0x0F12001A, /* TVAR_ash_pGAS[355] */
	0x0F120007, /* TVAR_ash_pGAS[356] */
	0x0F120000, /* TVAR_ash_pGAS[357] */
	0x0F120006, /* TVAR_ash_pGAS[358] */
	0x0F120018, /* TVAR_ash_pGAS[359] */
	0x0F120036, /* TVAR_ash_pGAS[360] */
	0x0F12005C, /* TVAR_ash_pGAS[361] */
	0x0F12008A, /* TVAR_ash_pGAS[362] */
	0x0F1200BC, /* TVAR_ash_pGAS[363] */
	0x0F1200D1, /* TVAR_ash_pGAS[364] */
	0x0F12009B, /* TVAR_ash_pGAS[365] */
	0x0F120069, /* TVAR_ash_pGAS[366] */
	0x0F120042, /* TVAR_ash_pGAS[367] */
	0x0F120022, /* TVAR_ash_pGAS[368] */
	0x0F12000F, /* TVAR_ash_pGAS[369] */
	0x0F120008, /* TVAR_ash_pGAS[370] */
	0x0F12000D, /* TVAR_ash_pGAS[371] */
	0x0F12001F, /* TVAR_ash_pGAS[372] */
	0x0F12003B, /* TVAR_ash_pGAS[373] */
	0x0F120060, /* TVAR_ash_pGAS[374] */
	0x0F12008D, /* TVAR_ash_pGAS[375] */
	0x0F1200BF, /* TVAR_ash_pGAS[376] */
	0x0F1200E3, /* TVAR_ash_pGAS[377] */
	0x0F1200AC, /* TVAR_ash_pGAS[378] */
	0x0F12007A, /* TVAR_ash_pGAS[379] */
	0x0F120053, /* TVAR_ash_pGAS[380] */
	0x0F120035, /* TVAR_ash_pGAS[381] */
	0x0F120022, /* TVAR_ash_pGAS[382] */
	0x0F12001B, /* TVAR_ash_pGAS[383] */
	0x0F12001F, /* TVAR_ash_pGAS[384] */
	0x0F120030, /* TVAR_ash_pGAS[385] */
	0x0F12004B, /* TVAR_ash_pGAS[386] */
	0x0F12006D, /* TVAR_ash_pGAS[387] */
	0x0F12009C, /* TVAR_ash_pGAS[388] */
	0x0F1200CE, /* TVAR_ash_pGAS[389] */
	0x0F1200FE, /* TVAR_ash_pGAS[390] */
	0x0F1200C9, /* TVAR_ash_pGAS[391] */
	0x0F120095, /* TVAR_ash_pGAS[392] */
	0x0F12006F, /* TVAR_ash_pGAS[393] */
	0x0F120052, /* TVAR_ash_pGAS[394] */
	0x0F120040, /* TVAR_ash_pGAS[395] */
	0x0F120039, /* TVAR_ash_pGAS[396] */
	0x0F12003D, /* TVAR_ash_pGAS[397] */
	0x0F12004B, /* TVAR_ash_pGAS[398] */
	0x0F120063, /* TVAR_ash_pGAS[399] */
	0x0F120086, /* TVAR_ash_pGAS[400] */
	0x0F1200B5, /* TVAR_ash_pGAS[401] */
	0x0F1200E6, /* TVAR_ash_pGAS[402] */
	0x0F12011B, /* TVAR_ash_pGAS[403] */
	0x0F1200ED, /* TVAR_ash_pGAS[404] */
	0x0F1200BA, /* TVAR_ash_pGAS[405] */
	0x0F120092, /* TVAR_ash_pGAS[406] */
	0x0F120076, /* TVAR_ash_pGAS[407] */
	0x0F120065, /* TVAR_ash_pGAS[408] */
	0x0F12005D, /* TVAR_ash_pGAS[409] */
	0x0F120060, /* TVAR_ash_pGAS[410] */
	0x0F12006D, /* TVAR_ash_pGAS[411] */
	0x0F120084, /* TVAR_ash_pGAS[412] */
	0x0F1200A8, /* TVAR_ash_pGAS[413] */
	0x0F1200D6, /* TVAR_ash_pGAS[414] */
	0x0F120101, /* TVAR_ash_pGAS[415] */
	0x0F120140, /* TVAR_ash_pGAS[416] */
	0x0F120112, /* TVAR_ash_pGAS[417] */
	0x0F1200E5, /* TVAR_ash_pGAS[418] */
	0x0F1200BD, /* TVAR_ash_pGAS[419] */
	0x0F12009E, /* TVAR_ash_pGAS[420] */
	0x0F12008C, /* TVAR_ash_pGAS[421] */
	0x0F120085, /* TVAR_ash_pGAS[422] */
	0x0F120087, /* TVAR_ash_pGAS[423] */
	0x0F120094, /* TVAR_ash_pGAS[424] */
	0x0F1200AC, /* TVAR_ash_pGAS[425] */
	0x0F1200D0, /* TVAR_ash_pGAS[426] */
	0x0F1200F8, /* TVAR_ash_pGAS[427] */
	0x0F120123, /* TVAR_ash_pGAS[428] */
	0x0F1200F2, /* TVAR_ash_pGAS[429] */
	0x0F1200D1, /* TVAR_ash_pGAS[430] */
	0x0F1200A7, /* TVAR_ash_pGAS[431] */
	0x0F120087, /* TVAR_ash_pGAS[432] */
	0x0F120073, /* TVAR_ash_pGAS[433] */
	0x0F120067, /* TVAR_ash_pGAS[434] */
	0x0F120064, /* TVAR_ash_pGAS[435] */
	0x0F12006B, /* TVAR_ash_pGAS[436] */
	0x0F12007C, /* TVAR_ash_pGAS[437] */
	0x0F120094, /* TVAR_ash_pGAS[438] */
	0x0F1200B7, /* TVAR_ash_pGAS[439] */
	0x0F1200E1, /* TVAR_ash_pGAS[440] */
	0x0F1200FF, /* TVAR_ash_pGAS[441] */
	0x0F1200D6, /* TVAR_ash_pGAS[442] */
	0x0F1200AE, /* TVAR_ash_pGAS[443] */
	0x0F120085, /* TVAR_ash_pGAS[444] */
	0x0F120068, /* TVAR_ash_pGAS[445] */
	0x0F120054, /* TVAR_ash_pGAS[446] */
	0x0F120048, /* TVAR_ash_pGAS[447] */
	0x0F120045, /* TVAR_ash_pGAS[448] */
	0x0F12004B, /* TVAR_ash_pGAS[449] */
	0x0F12005B, /* TVAR_ash_pGAS[450] */
	0x0F120073, /* TVAR_ash_pGAS[451] */
	0x0F120093, /* TVAR_ash_pGAS[452] */
	0x0F1200BF, /* TVAR_ash_pGAS[453] */
	0x0F1200E9, /* TVAR_ash_pGAS[454] */
	0x0F1200B8, /* TVAR_ash_pGAS[455] */
	0x0F12008E, /* TVAR_ash_pGAS[456] */
	0x0F120066, /* TVAR_ash_pGAS[457] */
	0x0F120049, /* TVAR_ash_pGAS[458] */
	0x0F120035, /* TVAR_ash_pGAS[459] */
	0x0F120028, /* TVAR_ash_pGAS[460] */
	0x0F120025, /* TVAR_ash_pGAS[461] */
	0x0F12002B, /* TVAR_ash_pGAS[462] */
	0x0F12003B, /* TVAR_ash_pGAS[463] */
	0x0F120053, /* TVAR_ash_pGAS[464] */
	0x0F120072, /* TVAR_ash_pGAS[465] */
	0x0F12009D, /* TVAR_ash_pGAS[466] */
	0x0F1200C8, /* TVAR_ash_pGAS[467] */
	0x0F1200A2, /* TVAR_ash_pGAS[468] */
	0x0F120078, /* TVAR_ash_pGAS[469] */
	0x0F120051, /* TVAR_ash_pGAS[470] */
	0x0F120034, /* TVAR_ash_pGAS[471] */
	0x0F12001F, /* TVAR_ash_pGAS[472] */
	0x0F120012, /* TVAR_ash_pGAS[473] */
	0x0F12000E, /* TVAR_ash_pGAS[474] */
	0x0F120014, /* TVAR_ash_pGAS[475] */
	0x0F120024, /* TVAR_ash_pGAS[476] */
	0x0F12003B, /* TVAR_ash_pGAS[477] */
	0x0F12005B, /* TVAR_ash_pGAS[478] */
	0x0F120083, /* TVAR_ash_pGAS[479] */
	0x0F1200AD, /* TVAR_ash_pGAS[480] */
	0x0F120095, /* TVAR_ash_pGAS[481] */
	0x0F12006C, /* TVAR_ash_pGAS[482] */
	0x0F120046, /* TVAR_ash_pGAS[483] */
	0x0F12002A, /* TVAR_ash_pGAS[484] */
	0x0F120014, /* TVAR_ash_pGAS[485] */
	0x0F120007, /* TVAR_ash_pGAS[486] */
	0x0F120002, /* TVAR_ash_pGAS[487] */
	0x0F120008, /* TVAR_ash_pGAS[488] */
	0x0F120016, /* TVAR_ash_pGAS[489] */
	0x0F12002D, /* TVAR_ash_pGAS[490] */
	0x0F12004C, /* TVAR_ash_pGAS[491] */
	0x0F120072, /* TVAR_ash_pGAS[492] */
	0x0F12009B, /* TVAR_ash_pGAS[493] */
	0x0F120093, /* TVAR_ash_pGAS[494] */
	0x0F12006A, /* TVAR_ash_pGAS[495] */
	0x0F120045, /* TVAR_ash_pGAS[496] */
	0x0F120028, /* TVAR_ash_pGAS[497] */
	0x0F120013, /* TVAR_ash_pGAS[498] */
	0x0F120005, /* TVAR_ash_pGAS[499] */
	0x0F120000, /* TVAR_ash_pGAS[500] */
	0x0F120004, /* TVAR_ash_pGAS[501] */
	0x0F120012, /* TVAR_ash_pGAS[502] */
	0x0F120028, /* TVAR_ash_pGAS[503] */
	0x0F120045, /* TVAR_ash_pGAS[504] */
	0x0F12006A, /* TVAR_ash_pGAS[505] */
	0x0F120093, /* TVAR_ash_pGAS[506] */
	0x0F12009B, /* TVAR_ash_pGAS[507] */
	0x0F120071, /* TVAR_ash_pGAS[508] */
	0x0F12004C, /* TVAR_ash_pGAS[509] */
	0x0F120030, /* TVAR_ash_pGAS[510] */
	0x0F12001A, /* TVAR_ash_pGAS[511] */
	0x0F12000C, /* TVAR_ash_pGAS[512] */
	0x0F120007, /* TVAR_ash_pGAS[513] */
	0x0F12000B, /* TVAR_ash_pGAS[514] */
	0x0F120018, /* TVAR_ash_pGAS[515] */
	0x0F12002C, /* TVAR_ash_pGAS[516] */
	0x0F120048, /* TVAR_ash_pGAS[517] */
	0x0F12006D, /* TVAR_ash_pGAS[518] */
	0x0F120097, /* TVAR_ash_pGAS[519] */
	0x0F1200AE, /* TVAR_ash_pGAS[520] */
	0x0F120083, /* TVAR_ash_pGAS[521] */
	0x0F12005C, /* TVAR_ash_pGAS[522] */
	0x0F120040, /* TVAR_ash_pGAS[523] */
	0x0F12002B, /* TVAR_ash_pGAS[524] */
	0x0F12001E, /* TVAR_ash_pGAS[525] */
	0x0F120018, /* TVAR_ash_pGAS[526] */
	0x0F12001C, /* TVAR_ash_pGAS[527] */
	0x0F120027, /* TVAR_ash_pGAS[528] */
	0x0F12003A, /* TVAR_ash_pGAS[529] */
	0x0F120055, /* TVAR_ash_pGAS[530] */
	0x0F12007B, /* TVAR_ash_pGAS[531] */
	0x0F1200A6, /* TVAR_ash_pGAS[532] */
	0x0F1200CA, /* TVAR_ash_pGAS[533] */
	0x0F12009E, /* TVAR_ash_pGAS[534] */
	0x0F120076, /* TVAR_ash_pGAS[535] */
	0x0F120059, /* TVAR_ash_pGAS[536] */
	0x0F120046, /* TVAR_ash_pGAS[537] */
	0x0F120039, /* TVAR_ash_pGAS[538] */
	0x0F120033, /* TVAR_ash_pGAS[539] */
	0x0F120036, /* TVAR_ash_pGAS[540] */
	0x0F120040, /* TVAR_ash_pGAS[541] */
	0x0F120052, /* TVAR_ash_pGAS[542] */
	0x0F12006C, /* TVAR_ash_pGAS[543] */
	0x0F120094, /* TVAR_ash_pGAS[544] */
	0x0F1200BF, /* TVAR_ash_pGAS[545] */
	0x0F1200EB, /* TVAR_ash_pGAS[546] */
	0x0F1200C3, /* TVAR_ash_pGAS[547] */
	0x0F120099, /* TVAR_ash_pGAS[548] */
	0x0F12007A, /* TVAR_ash_pGAS[549] */
	0x0F120066, /* TVAR_ash_pGAS[550] */
	0x0F12005A, /* TVAR_ash_pGAS[551] */
	0x0F120054, /* TVAR_ash_pGAS[552] */
	0x0F120056, /* TVAR_ash_pGAS[553] */
	0x0F12005F, /* TVAR_ash_pGAS[554] */
	0x0F120071, /* TVAR_ash_pGAS[555] */
	0x0F12008D, /* TVAR_ash_pGAS[556] */
	0x0F1200B6, /* TVAR_ash_pGAS[557] */
	0x0F1200DE, /* TVAR_ash_pGAS[558] */
	0x0F12010D, /* TVAR_ash_pGAS[559] */
	0x0F1200E7, /* TVAR_ash_pGAS[560] */
	0x0F1200C1, /* TVAR_ash_pGAS[561] */
	0x0F1200A0, /* TVAR_ash_pGAS[562] */
	0x0F12008A, /* TVAR_ash_pGAS[563] */
	0x0F12007C, /* TVAR_ash_pGAS[564] */
	0x0F120076, /* TVAR_ash_pGAS[565] */
	0x0F120078, /* TVAR_ash_pGAS[566] */
	0x0F120081, /* TVAR_ash_pGAS[567] */
	0x0F120093, /* TVAR_ash_pGAS[568] */
	0x0F1200B1, /* TVAR_ash_pGAS[569] */
	0x0F1200D5, /* TVAR_ash_pGAS[570] */
	0x0F1200FD, /* TVAR_ash_pGAS[571] */

	/* Gamma */
	0x002A04CC,
	0x0F120000, /* SARR_usGammaLutRGBIndoor[0][0]  */
	0x0F120002, /* SARR_usGammaLutRGBIndoor[0][1]  */
	0x0F120008, /* SARR_usGammaLutRGBIndoor[0][2]  */
	0x0F120016, /* SARR_usGammaLutRGBIndoor[0][3]  */
	0x0F120055, /* SARR_usGammaLutRGBIndoor[0][4]  */
	0x0F1200E6, /* SARR_usGammaLutRGBIndoor[0][5]  */
	0x0F120141, /* SARR_usGammaLutRGBIndoor[0][6]  */
	0x0F120188, /* SARR_usGammaLutRGBIndoor[0][7]  */
	0x0F1201E6, /* SARR_usGammaLutRGBIndoor[0][8]  */
	0x0F120236, /* SARR_usGammaLutRGBIndoor[0][9]  */
	0x0F1202BA, /* SARR_usGammaLutRGBIndoor[0][10] */
	0x0F12032A, /* SARR_usGammaLutRGBIndoor[0][11] */
	0x0F120385, /* SARR_usGammaLutRGBIndoor[0][12] */
	0x0F1203C2, /* SARR_usGammaLutRGBIndoor[0][13] */
	0x0F1203EA, /* SARR_usGammaLutRGBIndoor[0][14] */
	0x0F1203FF, /* SARR_usGammaLutRGBIndoor[0][15] */

	0x0F120000, /* SARR_usGammaLutRGBIndoor[1][0]  */
	0x0F120002, /* SARR_usGammaLutRGBIndoor[1][1]  */
	0x0F120008, /* SARR_usGammaLutRGBIndoor[1][2]  */
	0x0F120016, /* SARR_usGammaLutRGBIndoor[1][3]  */
	0x0F120055, /* SARR_usGammaLutRGBIndoor[1][4]  */
	0x0F1200E6, /* SARR_usGammaLutRGBIndoor[1][5]  */
	0x0F120141, /* SARR_usGammaLutRGBIndoor[1][6]  */
	0x0F120188, /* SARR_usGammaLutRGBIndoor[1][7]  */
	0x0F1201E6, /* SARR_usGammaLutRGBIndoor[1][8]  */
	0x0F120236, /* SARR_usGammaLutRGBIndoor[1][9]  */
	0x0F1202BA, /* SARR_usGammaLutRGBIndoor[1][10] */
	0x0F12032A, /* SARR_usGammaLutRGBIndoor[1][11] */
	0x0F120385, /* SARR_usGammaLutRGBIndoor[1][12] */
	0x0F1203C2, /* SARR_usGammaLutRGBIndoor[1][13] */
	0x0F1203EA, /* SARR_usGammaLutRGBIndoor[1][14] */
	0x0F1203FF, /* SARR_usGammaLutRGBIndoor[1][15] */

	0x0F120000, /* SARR_usGammaLutRGBIndoor[2][0]  */
	0x0F120002, /* SARR_usGammaLutRGBIndoor[2][1]  */
	0x0F120008, /* SARR_usGammaLutRGBIndoor[2][2]  */
	0x0F120016, /* SARR_usGammaLutRGBIndoor[2][3]  */
	0x0F120055, /* SARR_usGammaLutRGBIndoor[2][4]  */
	0x0F1200E6, /* SARR_usGammaLutRGBIndoor[2][5]  */
	0x0F120141, /* SARR_usGammaLutRGBIndoor[2][6]  */
	0x0F120188, /* SARR_usGammaLutRGBIndoor[2][7]  */
	0x0F1201E6, /* SARR_usGammaLutRGBIndoor[2][8]  */
	0x0F120236, /* SARR_usGammaLutRGBIndoor[2][9]  */
	0x0F1202BA, /* SARR_usGammaLutRGBIndoor[2][10] */
	0x0F12032A, /* SARR_usGammaLutRGBIndoor[2][11] */
	0x0F120385, /* SARR_usGammaLutRGBIndoor[2][12] */
	0x0F1203C2, /* SARR_usGammaLutRGBIndoor[2][13] */
	0x0F1203EA, /* SARR_usGammaLutRGBIndoor[2][14] */
	0x0F1203FF, /* SARR_usGammaLutRGBIndoor[2][15] */



	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone	       */
	0x0F120000, /* awbb_LowBr0_NBzone       */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv       */

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F12035E, /* awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F12036A, /* awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F120348, /* awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F120380, /* awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F120334, /* awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F120384, /* awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120318, /* awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F12037E, /* awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F1202FE, /* awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F12037A, /* awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202E6, /* awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12036C, /* awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202D0, /* awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F12035C, /* awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202B4, /* awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F120344, /* awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202A0, /* awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120330, /* awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F12028A, /* awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F12031E, /* awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F120272, /* awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F120308, /* awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F12025E, /* awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F1202F4, /* awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F120250, /* awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202DA, /* awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120240, /* awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202C6, /* awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F120232, /* awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202B8, /* awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202AA, /* awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120216, /* awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202A2, /* awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120206, /* awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F120294, /* awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F1201FA, /* awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120288, /* awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201EA, /* awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120280, /* awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201DC, /* awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F12027A, /* awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201D0, /* awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F120272, /* awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201C2, /* awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F12026A, /* awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201B6, /* awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F120264, /* awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201AA, /* awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F12025A, /* awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201A0, /* awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F120254, /* awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F120198, /* awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F12024A, /* awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F120242, /* awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120190, /* awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F12023A, /* awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F1201C4, /* awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F1201DE, /* awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */


	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F12001F,
	0x0F120000,
	0x0F12011E,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F120264,
	0x0F120279,
	0x0F120250,
	0x0F120287,
	0x0F120244,
	0x0F120287,
	0x0F120235,
	0x0F120289,
	0x0F120225,
	0x0F120287,
	0x0F120213,
	0x0F120286,
	0x0F120202,
	0x0F12027A,
	0x0F1201F3,
	0x0F120272,
	0x0F1201E9,
	0x0F120269,
	0x0F1201E2,
	0x0F120263,
	0x0F1201E0,
	0x0F12025A,
	0x0F1201E1,
	0x0F120256,
	0x0F1201EE,
	0x0F120251,
	0x0F1201F8,
	0x0F12024A,
	0x0F12020D,
	0x0F120231,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,


	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120011,
	0x0F120000,
	0x0F1201FF,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end	awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,



	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F120000, /* awbb_GridCorr_R_0__0_ */
	0x0F120000, /* awbb_GridCorr_R_0__1_ */
	0x0F120040, /* awbb_GridCorr_R_0__2_ */
	0x0F12FFF8, /* awbb_GridCorr_R_0__3_ */
	0x0F12FFE0, /* awbb_GridCorr_R_0__4_ */
	0x0F12FFD0, /* awbb_GridCorr_R_0__5_ */

	0x0F120000, /* awbb_GridCorr_R_1__0_ */
	0x0F120000, /* awbb_GridCorr_R_1__1_ */
	0x0F120040, /* awbb_GridCorr_R_1__2_ */
	0x0F12FFF8, /* awbb_GridCorr_R_1__3_ */
	0x0F12FFE0, /* awbb_GridCorr_R_1__4_ */
	0x0F12FFD0, /* awbb_GridCorr_R_1__5_ */

	0x0F120000, /* awbb_GridCorr_R_2__0_ */
	0x0F120000, /* awbb_GridCorr_R_2__1_ */
	0x0F120040, /* awbb_GridCorr_R_2__2_ */
	0x0F12FFF8, /* awbb_GridCorr_R_2__3_ */
	0x0F12FFE0, /* awbb_GridCorr_R_2__4_ */
	0x0F12FFD0, /* awbb_GridCorr_R_2__5_ */

	0x0F120000, /* awbb_GridCorr_B_0__0_ */
	0x0F120000, /* awbb_GridCorr_B_0__1_ */
	0x0F120030, /* awbb_GridCorr_B_0__2_ */
	0x0F120000, /* awbb_GridCorr_B_0__3_ */
	0x0F120018, /* awbb_GridCorr_B_0__4_ */
	0x0F120040, /* awbb_GridCorr_B_0__5_ */

	0x0F120000, /* awbb_GridCorr_B_1__0_ */
	0x0F120000, /* awbb_GridCorr_B_1__1_ */
	0x0F120030, /* awbb_GridCorr_B_1__2_ */
	0x0F120000, /* awbb_GridCorr_B_1__3_ */
	0x0F120018, /* awbb_GridCorr_B_1__4_ */
	0x0F120040, /* awbb_GridCorr_B_1__5_ */

	0x0F120000, /* awbb_GridCorr_B_2__0_ */
	0x0F120000, /* awbb_GridCorr_B_2__1_ */
	0x0F120030, /* awbb_GridCorr_B_2__2_ */
	0x0F120000, /* awbb_GridCorr_B_2__3_ */
	0x0F120018, /* awbb_GridCorr_B_2__4_ */
	0x0F120040, /* awbb_GridCorr_B_2__5_ */

	0x0F1202C6, /* awbb_GridConst_1_0_ */
	0x0F120335, /* awbb_GridConst_1_1_ */
	0x0F1203B3, /* awbb_GridConst_1_2_ */
	0x0F120FD7, /* awbb_GridConst_2_0  */
	0x0F1210C5, /* awbb_GridConst_2_1  */
	0x0F12116A, /* awbb_GridConst_2_2  */
	0x0F12117C, /* awbb_GridConst_2_3  */
	0x0F1211C2, /* awbb_GridConst_2_4  */
	0x0F12120B, /* awbb_GridConst_2_5  */

	0x0F1200B3, /* awbb_GridCoeff_R_1 */
	0x0F1200B7, /* awbb_GridCoeff_B_1 */
	0x0F1200D3, /* awbb_GridCoeff_R_2 */
	0x0F120091, /* awbb_GridCoeff_B_2 */

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F120365, /* 52A awbb_MvEq_RBthresh */

	/* Gamut Thresholds */
	0x002A0DAE,
	0x0F120036,
	0x0F12001C,
	0x002A0DAA,
	0x0F12071A,
	0x0F1203A4,

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120BB8,
	0x0F120096,
	0x002A0E86,
	0x0F120216,
	0x0F12029F,
	0x002A0D96,
	0x0F120BB7,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F12041B, /* 459 awbb_LowTempRB */
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,

	/* awbb_ChromaClassifyEn, default : enable */
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120210, /* 258 awbb_GainsMaxMove */
	0x0F120003,


	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/* param_start	TVAR_wbt_pBaseCcms */
	0x002A2800,
	0x0F1201E5, /* 01D6 01E1 01FB */
	0x0F12FFBF, /* FFC9 FFC4 FF9C */
	0x0F12FFF4, /* FFFB FFF8 FFFF */
	0x0F1200EE, /* 010A 0101 0137 */
	0x0F12019B, /* 0177 014C 0113 */
	0x0F12FF1E, /* FF24 FF55 FF6F */
	0x0F12FF38, /* FF9C FF5B FF21 */
	0x0F12026D, /* 0230 0205 0194 */
	0x0F12FEDD, /* FEB1 FF17 FF69 */
	0x0F12FF00, /* FEFF FEFE FF14 */
	0x0F1201B8, /* 01B7 01B6 0158 */
	0x0F120109, /* 0108 0107 015D */
	0x0F12FFCC, /* FFEB FFDB FFF2 */
	0x0F12FFA4, /* FFB5 FFDB FFF1 */
	0x0F120212, /* 01E4 01D1 0179 */
	0x0F120136, /* 011E 0163 017C */
	0x0F12FFA5, /* FFAD FF9E FFC3 */
	0x0F1201CF, /* 01E3 01B3 0197 */

	0x0F1201E5, /* 01D6 01E1 01FB */
	0x0F12FFBF, /* FFC9 FFC4 FF9C */
	0x0F12FFF4, /* FFFB FFF8 FFFF */
	0x0F1200EE, /* 010A 0101 0137 */
	0x0F12019B, /* 0177 014C 0113 */
	0x0F12FF1E, /* FF24 FF55 FF6F */
	0x0F12FF38, /* FF9C FF5B FF21 */
	0x0F12026D, /* 0230 0205 0194 */
	0x0F12FEDD, /* FEB1 FF17 FF69 */
	0x0F12FF00, /* FEFF FEFE FF14 */
	0x0F1201B8, /* 01B7 01B6 0158 */
	0x0F120109, /* 0108 0107 015D */
	0x0F12FFCC, /* FFEB FFDB FFF2 */
	0x0F12FFA4, /* FFB5 FFDB FFF1 */
	0x0F120212, /* 01E4 01D1 0179 */
	0x0F120136, /* 011E 0163 017C */
	0x0F12FFA5, /* FFAD FF9E FFC3 */
	0x0F1201CF, /* 01E3 01B3 0197 */

	0x0F1201E1, /* 01FB */
	0x0F12FFC4, /* FF9C */
	0x0F12FFF8, /* FFFF */
	0x0F120101, /* 0137 */
	0x0F12014C, /* 0113 */
	0x0F12FF55, /* FF6F */
	0x0F12FF5B, /* FF21 */
	0x0F120205, /* 0194 */
	0x0F12FF17, /* FF69 */
	0x0F12FEFE, /* FF14 */
	0x0F1201B6, /* 0158 */
	0x0F120107, /* 015D */
	0x0F12FFDB, /* FFF2 */
	0x0F12FFDB, /* FFF1 */
	0x0F1201D1, /* 0179 */
	0x0F120163, /* 017C */
	0x0F12FF9E, /* FFC3 */
	0x0F1201B3, /* 0197 */

	0x0F1201FB, /* 01FB 01FB */
	0x0F12FFA9, /* FFA9 FF9C */
	0x0F12FFEA, /* FFEA FFFF */
	0x0F12013C, /* 0134 0137 */
	0x0F120140, /* 0133 0113 */
	0x0F12FF53, /* FF5D FF6F */
	0x0F12FE7A, /* FE7A FF21 */
	0x0F12017D, /* 017D 0194 */
	0x0F12FEED, /* FEED FF69 */
	0x0F12FF39, /* FF39 FF14 */
	0x0F1201D6, /* 01D6 0158 */
	0x0F1200C4, /* 00C4 015D */
	0x0F12FFC0, /* FFCE FFF2 */
	0x0F12FFBF, /* FFCD FFF1 */
	0x0F1201CD, /* 01B7 0179 */
	0x0F120182, /* 0176 017C */
	0x0F12FF91, /* FFBD FFC3 */
	0x0F1201AA, /* 0191 0197 */

	0x0F1201D2, /* 01C5 01F9 020A */
	0x0F12FFC2, /* FF9F FFBC FFB2 */
	0x0F12FFFC, /* FFE5 FFF2 FFEB */
	0x0F1200E8, /* 00E2 00FA 0134 */
	0x0F120126, /* 010E 0157 0133 */
	0x0F12FF83, /* FF62 FF81 FF5D */
	0x0F12FE7A, /* FF03 FE7A FEFD */
	0x0F12017D, /* 01D0 017D 01BF */
	0x0F12FEED, /* FF3E FEED FF2A */
	0x0F12FF1C, /* FF00 FF8A FF39 */
	0x0F120194, /* 01A6 01F9 01D6 */
	0x0F12011F, /* 00BB 005B 00C4 */
	0x0F12FFEA, /* FFBF FFCA FFCE */
	0x0F12FFDE, /* FFDD FFA3 FFCD */
	0x0F1201E9, /* 01F6 01DA 01B7 */
	0x0F120178, /* 00CB 0108 0176 */
	0x0F12FFBF, /* FF94 FFB3 FFBD */
	0x0F120193, /* 019E 01DD 0191 */

	0x0F1201D2, /* 01F9 020A 01D0   R */
	0x0F12FFC2, /* FFBC FFB2 FFB4     */
	0x0F12FFFC, /* FFF2 FFEB 000C     */
	0x0F1200E8, /* 00FA 011E 0122   Y */
	0x0F120126, /* 0157 011D 0103     */
	0x0F12FF83, /* FF81 FF86 FF9B     */
	0x0F12FE7A, /* FE7A FEFD FF33   G */
	0x0F12017D, /* 017D 01BF 01C5     */
	0x0F12FEED, /* FEED FF2A FF33     */
	0x0F12FF1C, /* FF8A FF38 FF16   C */
	0x0F120194, /* 01F9 01D5 015A     */
	0x0F12011F, /* 005B 00C3 015F     */
	0x0F12FFEA, /* FFCA FFCF FFE0   B */
	0x0F12FFDE, /* FFA3 FFCE FFDF     */
	0x0F1201E9, /* 01DA 01B8 0197     */
	0x0F120178, /* 0108 0178 0178   M */
	0x0F12FFBF, /* FFB3 FFBF FFBF     */
	0x0F120193, /* 01DD 0193 0193     */

	0x0F1201F1, /* outdoor CCM */
	0x0F12FFB0,
	0x0F12FFEF,
	0x0F1200F4,
	0x0F120139,
	0x0F12FF64,
	0x0F12FEEC,
	0x0F1201FD,
	0x0F12FF8E,
	0x0F12FF4E,
	0x0F120164,
	0x0F12011D,
	0x0F12FFEA,
	0x0F12FFDE,
	0x0F1201E9,
	0x0F120178,
	0x0F12FFBF,
	0x0F120193,

	/* Set NB */
	0x002A07EA,
	0x0F120000, /* afit_bUseNoiseInd 0 : NB 1: Noise Index */

	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */


	/* Set AFIT */
	/* AFIT Start Address */
	0x002A0814,
	0x0F12082C, /* TVAR_afit_pBaseVals */
	0x0F127000, /* TVAR_afit_pBaseVals */

	/* param_start	TVAR_afit_pBaseVals */
	0x002A082C,
	0x0F120003, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F12FFFE, /* SATURATION                                                               */
	0x0F12FFE2, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120028, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120344, /* UVDenoise_iYLowThresh                                                    */
	0x0F12033A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120035, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120014, /* Denoise1_iYDenThreshLow                                                  */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120064, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120114, /* UVDenoise_iYLowThresh                                                    */
	0x0F12020A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120008, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F12000C, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120060, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120014, /* UVDenoise_iYLowThresh                                                    */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F12005A, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120014, /* UVDenoise_iYLowThresh                                                    */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */

	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F12000A, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120000, /* UVDenoise_iYLowThresh                                                    */
	0x0F120000, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"  ]negati fine        */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"     ]low fine           */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"   ]high fine          */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"      ]high low thres     */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */

	0x0F1200FF, /* Denoise1_iUVDenThreshLow                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                         */
	0x0F120800, /* Denoise1_sensor_width                             */
	0x0F120600, /* Denoise1_sensor_height                            */
	0x0F120000, /* Denoise1_start_x                                  */
	0x0F120000, /* Denoise1_start_y                                  */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "          */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "        */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  "  */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "           */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "         */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "      */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "     */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh" */
	0x0F120000, /*  Demosaic4_iBypassSelect                          */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */

	0x0028D000,
	0x002AB0CC,
	0x0F12000B, /* Non contious mode */
	/* VT-Call END of Initial */
};
;

#endif
/* Set-data based on Samsung Reliabilty Group standard
* ,when using WIFI. 15fps
*/
static const u32 s5k5bafx_vt_wifi_common[] =
{
	/* Wifi_VT */

	0xFCFCD000,


	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* Delay */


	/* Trap and Patch  2008-11-18 10:15:41 */
	0x00287000,
	0x002A1668,
	0x0F12B5FE,
	0x0F120007,
	0x0F12683C,
	0x0F12687E,
	0x0F121DA5,
	0x0F1288A0,
	0x0F122800,
	0x0F12D00B,
	0x0F1288A8,
	0x0F122800,
	0x0F12D008,
	0x0F128820,
	0x0F128829,
	0x0F124288,
	0x0F12D301,
	0x0F121A40,
	0x0F12E000,
	0x0F121A08,
	0x0F129001,
	0x0F12E001,
	0x0F122019,
	0x0F129001,
	0x0F124916,
	0x0F12466B,
	0x0F128A48,
	0x0F128118,
	0x0F128A88,
	0x0F128158,
	0x0F124814,
	0x0F128940,
	0x0F120040,
	0x0F122103,
	0x0F12F000,
	0x0F12F826,
	0x0F1288A1,
	0x0F124288,
	0x0F12D908,
	0x0F128828,
	0x0F128030,
	0x0F128868,
	0x0F128070,
	0x0F1288A8,
	0x0F126038,
	0x0F12BCFE,
	0x0F12BC08,
	0x0F124718,
	0x0F1288A9,
	0x0F124288,
	0x0F12D906,
	0x0F128820,
	0x0F128030,
	0x0F128860,
	0x0F128070,
	0x0F1288A0,
	0x0F126038,
	0x0F12E7F2,
	0x0F129801,
	0x0F12A902,
	0x0F12F000,
	0x0F12F812,
	0x0F120033,
	0x0F120029,
	0x0F129A02,
	0x0F120020,
	0x0F12F000,
	0x0F12F814,
	0x0F126038,
	0x0F12E7E6,
	0x0F121A28,
	0x0F127000,
	0x0F120D64,
	0x0F127000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F126009,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12622F,
	0x0F120000,
	0x002A2080,
	0x0F12B510,
	0x0F12F000,
	0x0F12F8F4,
	0x0F12BC10,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F0,
	0x0F12B08B,
	0x0F120006,
	0x0F122000,
	0x0F129004,
	0x0F126835,
	0x0F126874,
	0x0F1268B0,
	0x0F12900A,
	0x0F1268F0,
	0x0F129009,
	0x0F124F7D,
	0x0F128979,
	0x0F12084A,
	0x0F1288A8,
	0x0F1288A3,
	0x0F124298,
	0x0F12D300,
	0x0F120018,
	0x0F12F000,
	0x0F12F907,
	0x0F129007,
	0x0F120021,
	0x0F120028,
	0x0F12AA04,
	0x0F12F000,
	0x0F12F909,
	0x0F129006,
	0x0F1288A8,
	0x0F122800,
	0x0F12D102,
	0x0F1227FF,
	0x0F121C7F,
	0x0F12E047,
	0x0F1288A0,
	0x0F122800,
	0x0F12D101,
	0x0F122700,
	0x0F12E042,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12F000,
	0x0F12F8F8,
	0x0F129008,
	0x0F128ABA,
	0x0F129808,
	0x0F12466B,
	0x0F124342,
	0x0F129202,
	0x0F128820,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8EA,
	0x0F129A02,
	0x0F1217D1,
	0x0F120E09,
	0x0F121889,
	0x0F121209,
	0x0F124288,
	0x0F12DD1F,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8DA,
	0x0F129001,
	0x0F128828,
	0x0F12466B,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12980A,
	0x0F129902,
	0x0F12F000,
	0x0F12F8D0,
	0x0F128AB9,
	0x0F129A08,
	0x0F124351,
	0x0F1217CA,
	0x0F120E12,
	0x0F121851,
	0x0F12120A,
	0x0F129901,
	0x0F12F000,
	0x0F12F8B6,
	0x0F120407,
	0x0F120C3F,
	0x0F12E000,
	0x0F122700,
	0x0F128820,
	0x0F12466B,
	0x0F12AA05,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12003B,
	0x0F12F000,
	0x0F12F8BB,
	0x0F1288A1,
	0x0F1288A8,
	0x0F12003A,
	0x0F12F000,
	0x0F12F8BE,
	0x0F120004,
	0x0F12A804,
	0x0F12C803,
	0x0F129A09,
	0x0F129B07,
	0x0F12F000,
	0x0F12F8AF,
	0x0F12A806,
	0x0F12C805,
	0x0F120021,
	0x0F12F000,
	0x0F12F8B2,
	0x0F126030,
	0x0F12B00B,
	0x0F12BCF0,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F1,
	0x0F129900,
	0x0F12680C,
	0x0F12493A,
	0x0F12694B,
	0x0F12698A,
	0x0F124694,
	0x0F1269CD,
	0x0F126A0E,
	0x0F124F38,
	0x0F1242BC,
	0x0F12D800,
	0x0F120027,
	0x0F124937,
	0x0F126B89,
	0x0F120409,
	0x0F120C09,
	0x0F124A35,
	0x0F121E92,
	0x0F126BD2,
	0x0F120412,
	0x0F120C12,
	0x0F12429F,
	0x0F12D801,
	0x0F120020,
	0x0F12E031,
	0x0F12001F,
	0x0F12434F,
	0x0F120A3F,
	0x0F1242A7,
	0x0F12D301,
	0x0F120018,
	0x0F12E02A,
	0x0F12002B,
	0x0F12434B,
	0x0F120A1B,
	0x0F1242A3,
	0x0F12D303,
	0x0F120220,
	0x0F12F000,
	0x0F12F88C,
	0x0F12E021,
	0x0F120029,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D301,
	0x0F120028,
	0x0F12E01A,
	0x0F120031,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D304,
	0x0F120220,
	0x0F120011,
	0x0F12F000,
	0x0F12F87B,
	0x0F12E010,
	0x0F12491E,
	0x0F128C89,
	0x0F12000A,
	0x0F124372,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D301,
	0x0F120030,
	0x0F12E007,
	0x0F124662,
	0x0F12434A,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D302,
	0x0F120220,
	0x0F12F000,
	0x0F12F869,
	0x0F124B16,
	0x0F124D18,
	0x0F128D99,
	0x0F121FCA,
	0x0F123AF9,
	0x0F12D00A,
	0x0F122001,
	0x0F120240,
	0x0F128468,
	0x0F120220,
	0x0F12F000,
	0x0F12F85D,
	0x0F129900,
	0x0F126008,
	0x0F12BCF8,
	0x0F12BC08,
	0x0F124718,
	0x0F128D19,
	0x0F128469,
	0x0F129900,
	0x0F126008,
	0x0F12E7F7,
	0x0F12B570,
	0x0F122200,
	0x0F12490E,
	0x0F12480E,
	0x0F122401,
	0x0F12F000,
	0x0F12F852,
	0x0F120022,
	0x0F12490D,
	0x0F12480D,
	0x0F122502,
	0x0F12F000,
	0x0F12F84C,
	0x0F12490C,
	0x0F12480D,
	0x0F12002A,
	0x0F12F000,
	0x0F12F847,
	0x0F12BC70,
	0x0F12BC08,
	0x0F124718,
	0x0F120D64,
	0x0F127000,
	0x0F120470,
	0x0F127000,
	0x0F12A120,
	0x0F120007,
	0x0F120402,
	0x0F127000,
	0x0F1214A0,
	0x0F127000,
	0x0F12208D,
	0x0F127000,
	0x0F12622F,
	0x0F120000,
	0x0F121669,
	0x0F127000,
	0x0F126445,
	0x0F120000,
	0x0F1221AB,
	0x0F127000,
	0x0F122AA9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125F49,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FC7,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125457,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FA3,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F1251F9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A007,
	0x0F120000,
	0x0F126546,
	0x0F122062,
	0x0F123120,
	0x0F123220,
	0x0F123130,
	0x0F120030,
	0x0F12E010,
	0x0F120208,
	0x0F120058,
	0x0F120000,
	/* End of Trap and Patch (Last : 70002342h) */
	/* Total Size 896 (0x0380)                  */

	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0, /* setot_uOnlineClocksDiv40             */
	0x002A0AE2,
	0x0F12222E, /* setot_usSetRomWaitStateThreshold4KHz */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */


	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,


	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,

	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,

	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,

	0x0F120015,


	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,


	0x002AF900,
	0x0F120067,
	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,

	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,

	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,

	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,

	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,

	0x002AF4D6,
	0x0F120090,


	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,

	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,

	/* sensor aig table setting */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,


	0x002A1084,
	0x0F120000, /* senHal_bUseAnalogBinning */
	0x0F120000, /* senHal_bUseAnalogVerAvg  */

	/* Set AE Target */
	0x002A0F4C,
	0x0F120038, /* 3A TVAR_ae_BrAve */

	0x002A0478,
	0x0F120114,
	0x0F1200EB, /* ae boundary */



	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A,/* uMaxExp1         */
	0x0F120000,
	0x002A048C,
	0x0F128214,/* uMaxExp2         */
	0x0F120000,
	0x0F12A122,/* uMaxExp3         */
	0x0F120000,
	0x002A0488,
	0x0F12f424,/* uMaxExp4         */
	0x0F120000,
	0x002A043A,
	0x0F1201B0,/* lt_uMaxAnGain0   */
	0x0F1201C0,/* lt_uMaxAnGain0_1 */
	0x002A0494,
	0x0F1202B0,/* lt_uMaxAnGain1   */
	0x0F120B00,/* lt_uMaxAnGain2   */
	0x0f120100,/* lt_uMaxDigGain   */
	0x002A0F52,
	0x0F12000F,/* ae_StatMode */

	/* 1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001, /* AFC_Default60Hz	 Auto Flicker 60Hz start 0: Auto Flicker 50Hz start */
	0x002A03F8,
	0x0F12007F, /* REG_TC_DBG_AutoAlgEnBits          default : 007F  */



	0xffff000a, /* Wait10mSec */

	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0, /* REG_TC_IPRM_InClockLSBs */
	0x0F120000, /* REG_TC_IPRM_InClockMSBs */

	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001, /* REG_TC_IPRM_UseNPviClocks         */
	0x0F120001, /* REG_TC_IPRM_UseNMipiClocks        */
	0x0F120000, /* REG_TC_IPRM_bBlockInternalPllCalc */

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770, /* REG_TC_IPRM_OpClk4KHz_0      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_0 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_0 */

	/* System Clock 1 (System : 28Mhz, PCLK : 48Mhz) */
	0x002A01D2,
	0x0F121B58, /* REG_TC_IPRM_OpClk4KHz_1      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_1 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_1 */


	0x002A01DE,
	0x0F120001, /* REG_TC_IPRM_UseRegsAPI        */
	0x0F120001, /* REG_TC_IPRM_InitParamsUpdated */
	0xffff0064, /* Delay 100msec                 */



	/* Crop */
	0x002A01FA,
	0x0F120640, /* REG_TC_GP_PrevReqInputWidth  */
	0x0F1204B0, /* REG_TC_GP_PrevReqInputHeight */
	0x0F120000, /* REG_TC_GP_PrevInputWidthOfs  */
	0x0F120000, /* REG_TC_GP_PrevInputHeightOfs */


	/* Set Preview Config */
	/* Preview Config 0 (1600x1200 fixed 15fps) */
	0x002A0242,
	0x0F120280, /* REG_0TC_PCFG_usWidth               */
	0x0F1201E0, /* REG_0TC_PCFG_usHeight              */
	0x0F120005, /* REG_0TC_PCFG_Format                */
	0x0F122EE0, /* REG_0TC_PCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_PCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_PCFG_PVIMask               */
	0x0F120001, /* REG_0TC_PCFG_uClockInd             */
	0x0F120002, /* REG_0TC_PCFG_usFrTimeType          */
	0x0F120001, /* REG_0TC_PCFG_FrRateQualityType     */
	0x0F12029A, /* REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
	0x0F12029A, /* REG_0TC_PCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_PCFG_sSaturation           */
	0x0F120000, /* REG_0TC_PCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_PCFG_sGlamour              */
	0x0F120000, /* REG_0TC_PCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_PCFG_uDeviceGammaIndex     */
	0x0F120003, /* REG_0TC_PCFG_uPrevMirror           */
	0x0F120003, /* REG_0TC_PCFG_uCaptureMirror        */
	0x0F120000, /* REG_0TC_PCFG_uRotation             */

	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280, /* REG_1TC_PCFG_usWidth               */
	0x0F1201E0, /* REG_1TC_PCFG_usHeight              */
	0x0F120005, /* REG_1TC_PCFG_Format                */
	0x0F122EE0, /* REG_1TC_PCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_1TC_PCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_1TC_PCFG_PVIMask               */
	0x0F120001, /* REG_1TC_PCFG_uClockInd             */
	0x0F120000, /* REG_1TC_PCFG_usFrTimeType          */
	0x0F120000, /* REG_1TC_PCFG_FrRateQualityType     */
	0x0F12029A, /* REG_1TC_PCFG_usMaxFrTimeMsecMult10 */
	0x0F12014D, /* REG_1TC_PCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_1TC_PCFG_sSaturation           */
	0x0F120000, /* REG_1TC_PCFG_sSharpBlur            */
	0x0F120000, /* REG_1TC_PCFG_sGlamour              */
	0x0F120000, /* REG_1TC_PCFG_sColorTemp            */
	0x0F120000, /* REG_1TC_PCFG_uDeviceGammaIndex     */
	0x0F120003, /* REG_1TC_PCFG_uPrevMirror           */
	0x0F120003, /* REG_1TC_PCFG_uCaptureMirror        */
	0x0F120000, /* REG_1TC_PCFG_uRotation             */



	/* Set MIPI */
	0x002A03AC,
	0x0F120000, /* REG_TC_FLS_Mode        */
	0x002A03F2,
	0x0F120001, /* REG_TC_OIF_EnMipiLanes */
	0x0F1200C3, /* REG_TC_OIF_EnPackets   */
	0x0F120001, /* REG_TC_OIF_CfgChanged  */

	/* Apply preview config */
	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig     */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange  */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync        */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged    */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview        */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */



	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 15fps) */
	0x002A0302,
	0x0F120000, /* REG_0TC_CCFG_uCaptureMode          */
	0x0F120640, /* REG_0TC_CCFG_usWidth               */
	0x0F1204B0, /* REG_0TC_CCFG_usHeight              */
	0x0F120005, /* REG_0TC_CCFG_Format                */
	0x0F122EE0, /* REG_0TC_CCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_CCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_CCFG_PVIMask               */
	0x0F120001, /* REG_0TC_CCFG_uClockInd             */
	0x0F120002, /* REG_0TC_CCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_CCFG_FrRateQualityType     */
	0x0F12029A, /* REG_0TC_CCFG_usMaxFrTimeMsecMult10 */
	0x0F12029A, /* REG_0TC_CCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_CCFG_sSaturation           */
	0x0F120000, /* REG_0TC_CCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_CCFG_sGlamour              */
	0x0F120000, /* REG_0TC_CCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_CCFG_uDeviceGammaIndex     */



	/* Periodic mismatch */
	0x002A0780,
	0x0F120000, /* msm_uOffsetNoBin[0][0] */
	0x0F120000, /* msm_uOffsetNoBin[0][1] */
	0x0F120000, /* msm_uOffsetNoBin[1][0] */
	0x0F120000, /* msm_uOffsetNoBin[1][1] */
	0x0F120000, /* msm_uOffsetNoBin[2][0] */
	0x0F120000, /* msm_uOffsetNoBin[2][1] */
	0x0F120000, /* msm_uOffsetNoBin[3][0] */
	0x0F120000, /* msm_uOffsetNoBin[3][1] */

	0x002A0798,
	0x0F120000, /* msm_uOffsetBin[0][0] */
	0x0F120000, /* msm_uOffsetBin[0][1] */
	0x0F120000, /* msm_uOffsetBin[1][0] */
	0x0F120000, /* msm_uOffsetBin[1][1] */

	0x002A07C0,
	0x0F120004, /* msm_NonLinearOfsOutput[2] */
	0x0F120004, /* msm_NonLinearOfsOutput[3] */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R */
	0x0F120400, /* awbb_GainsInit_1_:G */
	0x0F1205F0, /* awbb_GainsInit_2_:B */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start */


	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000, /* ae_WeightTbl_16_0_ */
	0x0F120000, /* ae_WeightTbl_16_1_ */
	0x0F120000, /* ae_WeightTbl_16_2_ */
	0x0F120000, /* ae_WeightTbl_16_3_ */
	0x0F120101, /* ae_WeightTbl_16_4_ */
	0x0F120101, /* ae_WeightTbl_16_5_ */
	0x0F120101, /* ae_WeightTbl_16_6_ */
	0x0F120101, /* ae_WeightTbl_16_7_ */
	0x0F120101, /* ae_WeightTbl_16_8_ */
	0x0F120302, /* ae_WeightTbl_16_9_ */
	0x0F120203, /* ae_WeightTbl_16_10 */
	0x0F120101, /* ae_WeightTbl_16_11 */
	0x0F120101, /* ae_WeightTbl_16_12 */
	0x0F120403, /* ae_WeightTbl_16_13 */
	0x0F120304, /* ae_WeightTbl_16_14 */
	0x0F120101, /* ae_WeightTbl_16_15 */
	0x0F120101, /* ae_WeightTbl_16_16 */
	0x0F120403, /* ae_WeightTbl_16_17 */
	0x0F120304, /* ae_WeightTbl_16_18 */
	0x0F120101, /* ae_WeightTbl_16_19 */
	0x0F120101, /* ae_WeightTbl_16_20 */
	0x0F120302, /* ae_WeightTbl_16_21 */
	0x0F120203, /* ae_WeightTbl_16_22 */
	0x0F120101, /* ae_WeightTbl_16_23 */
	0x0F120101, /* ae_WeightTbl_16_24 */
	0x0F120101, /* ae_WeightTbl_16_25 */
	0x0F120101, /* ae_WeightTbl_16_26 */
	0x0F120101, /* ae_WeightTbl_16_27 */
	0x0F120000, /* ae_WeightTbl_16_28 */
	0x0F120000, /* ae_WeightTbl_16_29 */
	0x0F120000, /* ae_WeightTbl_16_30 */
	0x0F120000, /* ae_WeightTbl_16_31 */


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3, /* TVAR_ash_AwbAshCord_0_ */
	0x0F1200E5, /* TVAR_ash_AwbAshCord_1_ */
	0x0F120120, /* TVAR_ash_AwbAshCord_2_ */
	0x0F120136, /* TVAR_ash_AwbAshCord_3_ */
	0x0F120180, /* TVAR_ash_AwbAshCord_4_ */
	0x0F1201B0, /* TVAR_ash_AwbAshCord_5_ */
	0x0F120200, /* TVAR_ash_AwbAshCord_6_ */

	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3, /* SARR_AwbCcmCord_0_	Hor   */
	0x0F1200E5, /* SARR_AwbCcmCord_1_	IncaA */
	0x0F120100, /* SARR_AwbCcmCord_2_	WW    */
	0x0F120116, /* SARR_AwbCcmCord_3_	CW    */
	0x0F120150, /* SARR_AwbCcmCord_4_	D50   */
	0x0F120198, /* SARR_AwbCcmCord_5_	D65   */

	/* Target Brightness Control */
	0x002A103E,
	0x0F120000, /* SARR_IllumType_0_      */
	0x0F120009, /* SARR_IllumType_1_      */
	0x0F120018, /* SARR_IllumType_2_      */
	0x0F120032, /* SARR_IllumType_3_      */
	0x0F12004A, /* SARR_IllumType_4_      */
	0x0F120051, /* SARR_IllumType_5_      */
	0x0F120056, /* SARR_IllumType_6_      */
	0x0F12010C, /* SARe_2_R_IllumTypeF_0_ */
	0x0F12010C, /* SARe_3_R_IllumTypeF_1_ */
	0x0F120109, /* SARe_4_R_IllumTypeF_2_ */
	0x0F120105, /* SARe_5_R_IllumTypeF_3_ */
	0x0F120102, /* SARe_6_R_IllumTypeF_4_ */
	0x0F1200FB, /* SARR_IllumTypeF_5_     */
	0x0F1200F8, /* SARR_IllumTypeF_6_     */

	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */

	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */

	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */

	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */

	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */

	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */

	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */

	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_ */

	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388, /* TVAR_ash_pGAS */
	0x0F127000, /* TVAR_ash_pGAS */

	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F1201CC, /* TVAR_ash_pGAS[0]   */
	0x0F120178, /* TVAR_ash_pGAS[1]   */
	0x0F12013B, /* TVAR_ash_pGAS[2]   */
	0x0F120108, /* TVAR_ash_pGAS[3]   */
	0x0F1200E4, /* TVAR_ash_pGAS[4]   */
	0x0F1200CC, /* TVAR_ash_pGAS[5]   */
	0x0F1200C5, /* TVAR_ash_pGAS[6]   */
	0x0F1200CF, /* TVAR_ash_pGAS[7]   */
	0x0F1200E8, /* TVAR_ash_pGAS[8]   */
	0x0F120111, /* TVAR_ash_pGAS[9]   */
	0x0F120142, /* TVAR_ash_pGAS[10]  */
	0x0F120183, /* TVAR_ash_pGAS[11]  */
	0x0F1201D9, /* TVAR_ash_pGAS[12]  */
	0x0F120184, /* TVAR_ash_pGAS[13]  */
	0x0F120142, /* TVAR_ash_pGAS[14]  */
	0x0F120101, /* TVAR_ash_pGAS[15]  */
	0x0F1200CF, /* TVAR_ash_pGAS[16]  */
	0x0F1200A7, /* TVAR_ash_pGAS[17]  */
	0x0F120090, /* TVAR_ash_pGAS[18]  */
	0x0F120088, /* TVAR_ash_pGAS[19]  */
	0x0F120092, /* TVAR_ash_pGAS[20]  */
	0x0F1200AC, /* TVAR_ash_pGAS[21]  */
	0x0F1200D5, /* TVAR_ash_pGAS[22]  */
	0x0F12010D, /* TVAR_ash_pGAS[23]  */
	0x0F12014E, /* TVAR_ash_pGAS[24]  */
	0x0F120190, /* TVAR_ash_pGAS[25]  */
	0x0F12014E, /* TVAR_ash_pGAS[26]  */
	0x0F12010D, /* TVAR_ash_pGAS[27]  */
	0x0F1200CA, /* TVAR_ash_pGAS[28]  */
	0x0F120094, /* TVAR_ash_pGAS[29]  */
	0x0F12006D, /* TVAR_ash_pGAS[30]  */
	0x0F120054, /* TVAR_ash_pGAS[31]  */
	0x0F12004E, /* TVAR_ash_pGAS[32]  */
	0x0F120058, /* TVAR_ash_pGAS[33]  */
	0x0F120073, /* TVAR_ash_pGAS[34]  */
	0x0F12009D, /* TVAR_ash_pGAS[35]  */
	0x0F1200D5, /* TVAR_ash_pGAS[36]  */
	0x0F12011D, /* TVAR_ash_pGAS[37]  */
	0x0F12015A, /* TVAR_ash_pGAS[38]  */
	0x0F120129, /* TVAR_ash_pGAS[39]  */
	0x0F1200E5, /* TVAR_ash_pGAS[40]  */
	0x0F1200A1, /* TVAR_ash_pGAS[41]  */
	0x0F12006B, /* TVAR_ash_pGAS[42]  */
	0x0F120042, /* TVAR_ash_pGAS[43]  */
	0x0F12002A, /* TVAR_ash_pGAS[44]  */
	0x0F120022, /* TVAR_ash_pGAS[45]  */
	0x0F12002D, /* TVAR_ash_pGAS[46]  */
	0x0F120049, /* TVAR_ash_pGAS[47]  */
	0x0F120075, /* TVAR_ash_pGAS[48]  */
	0x0F1200AF, /* TVAR_ash_pGAS[49]  */
	0x0F1200F8, /* TVAR_ash_pGAS[50]  */
	0x0F12013A, /* TVAR_ash_pGAS[51]  */
	0x0F120113, /* TVAR_ash_pGAS[52]  */
	0x0F1200CE, /* TVAR_ash_pGAS[53]  */
	0x0F120088, /* TVAR_ash_pGAS[54]  */
	0x0F120052, /* TVAR_ash_pGAS[55]  */
	0x0F12002A, /* TVAR_ash_pGAS[56]  */
	0x0F120010, /* TVAR_ash_pGAS[57]  */
	0x0F120009, /* TVAR_ash_pGAS[58]  */
	0x0F120015, /* TVAR_ash_pGAS[59]  */
	0x0F120032, /* TVAR_ash_pGAS[60]  */
	0x0F12005E, /* TVAR_ash_pGAS[61]  */
	0x0F120098, /* TVAR_ash_pGAS[62]  */
	0x0F1200E3, /* TVAR_ash_pGAS[63]  */
	0x0F120128, /* TVAR_ash_pGAS[64]  */
	0x0F12010A, /* TVAR_ash_pGAS[65]  */
	0x0F1200C4, /* TVAR_ash_pGAS[66]  */
	0x0F120080, /* TVAR_ash_pGAS[67]  */
	0x0F120049, /* TVAR_ash_pGAS[68]  */
	0x0F120020, /* TVAR_ash_pGAS[69]  */
	0x0F120008, /* TVAR_ash_pGAS[70]  */
	0x0F120000, /* TVAR_ash_pGAS[71]  */
	0x0F12000D, /* TVAR_ash_pGAS[72]  */
	0x0F12002A, /* TVAR_ash_pGAS[73]  */
	0x0F120058, /* TVAR_ash_pGAS[74]  */
	0x0F120093, /* TVAR_ash_pGAS[75]  */
	0x0F1200DD, /* TVAR_ash_pGAS[76]  */
	0x0F120123, /* TVAR_ash_pGAS[77]  */
	0x0F12010D, /* TVAR_ash_pGAS[78]  */
	0x0F1200CA, /* TVAR_ash_pGAS[79]  */
	0x0F120085, /* TVAR_ash_pGAS[80]  */
	0x0F12004E, /* TVAR_ash_pGAS[81]  */
	0x0F120026, /* TVAR_ash_pGAS[82]  */
	0x0F12000E, /* TVAR_ash_pGAS[83]  */
	0x0F120007, /* TVAR_ash_pGAS[84]  */
	0x0F120014, /* TVAR_ash_pGAS[85]  */
	0x0F120032, /* TVAR_ash_pGAS[86]  */
	0x0F120061, /* TVAR_ash_pGAS[87]  */
	0x0F12009C, /* TVAR_ash_pGAS[88]  */
	0x0F1200E8, /* TVAR_ash_pGAS[89]  */
	0x0F12012F, /* TVAR_ash_pGAS[90]  */
	0x0F120121, /* TVAR_ash_pGAS[91]  */
	0x0F1200DE, /* TVAR_ash_pGAS[92]  */
	0x0F12009A, /* TVAR_ash_pGAS[93]  */
	0x0F120063, /* TVAR_ash_pGAS[94]  */
	0x0F12003B, /* TVAR_ash_pGAS[95]  */
	0x0F120024, /* TVAR_ash_pGAS[96]  */
	0x0F12001D, /* TVAR_ash_pGAS[97]  */
	0x0F12002B, /* TVAR_ash_pGAS[98]  */
	0x0F120049, /* TVAR_ash_pGAS[99]  */
	0x0F120079, /* TVAR_ash_pGAS[100] */
	0x0F1200B5, /* TVAR_ash_pGAS[101] */
	0x0F120100, /* TVAR_ash_pGAS[102] */
	0x0F120145, /* TVAR_ash_pGAS[103] */
	0x0F12013F, /* TVAR_ash_pGAS[104] */
	0x0F120101, /* TVAR_ash_pGAS[105] */
	0x0F1200BE, /* TVAR_ash_pGAS[106] */
	0x0F120087, /* TVAR_ash_pGAS[107] */
	0x0F12005F, /* TVAR_ash_pGAS[108] */
	0x0F120048, /* TVAR_ash_pGAS[109] */
	0x0F120043, /* TVAR_ash_pGAS[110] */
	0x0F120051, /* TVAR_ash_pGAS[111] */
	0x0F120070, /* TVAR_ash_pGAS[112] */
	0x0F1200A0, /* TVAR_ash_pGAS[113] */
	0x0F1200DF, /* TVAR_ash_pGAS[114] */
	0x0F120126, /* TVAR_ash_pGAS[115] */
	0x0F120168, /* TVAR_ash_pGAS[116] */
	0x0F12016D, /* TVAR_ash_pGAS[117] */
	0x0F12012F, /* TVAR_ash_pGAS[118] */
	0x0F1200EF, /* TVAR_ash_pGAS[119] */
	0x0F1200BA, /* TVAR_ash_pGAS[120] */
	0x0F120093, /* TVAR_ash_pGAS[121] */
	0x0F12007E, /* TVAR_ash_pGAS[122] */
	0x0F120079, /* TVAR_ash_pGAS[123] */
	0x0F120087, /* TVAR_ash_pGAS[124] */
	0x0F1200A6, /* TVAR_ash_pGAS[125] */
	0x0F1200D7, /* TVAR_ash_pGAS[126] */
	0x0F120114, /* TVAR_ash_pGAS[127] */
	0x0F120158, /* TVAR_ash_pGAS[128] */
	0x0F120199, /* TVAR_ash_pGAS[129] */
	0x0F1201A6, /* TVAR_ash_pGAS[130] */
	0x0F12015E, /* TVAR_ash_pGAS[131] */
	0x0F120122, /* TVAR_ash_pGAS[132] */
	0x0F1200F1, /* TVAR_ash_pGAS[133] */
	0x0F1200CB, /* TVAR_ash_pGAS[134] */
	0x0F1200B6, /* TVAR_ash_pGAS[135] */
	0x0F1200B2, /* TVAR_ash_pGAS[136] */
	0x0F1200C0, /* TVAR_ash_pGAS[137] */
	0x0F1200DF, /* TVAR_ash_pGAS[138] */
	0x0F12010D, /* TVAR_ash_pGAS[139] */
	0x0F120145, /* TVAR_ash_pGAS[140] */
	0x0F120188, /* TVAR_ash_pGAS[141] */
	0x0F1201DF, /* TVAR_ash_pGAS[142] */
	0x0F12016C, /* TVAR_ash_pGAS[143] */
	0x0F120127, /* TVAR_ash_pGAS[144] */
	0x0F1200F2, /* TVAR_ash_pGAS[145] */
	0x0F1200CA, /* TVAR_ash_pGAS[146] */
	0x0F1200AC, /* TVAR_ash_pGAS[147] */
	0x0F12009B, /* TVAR_ash_pGAS[148] */
	0x0F120096, /* TVAR_ash_pGAS[149] */
	0x0F12009C, /* TVAR_ash_pGAS[150] */
	0x0F1200AE, /* TVAR_ash_pGAS[151] */
	0x0F1200CC, /* TVAR_ash_pGAS[152] */
	0x0F1200F4, /* TVAR_ash_pGAS[153] */
	0x0F12012D, /* TVAR_ash_pGAS[154] */
	0x0F120179, /* TVAR_ash_pGAS[155] */
	0x0F120130, /* TVAR_ash_pGAS[156] */
	0x0F1200F6, /* TVAR_ash_pGAS[157] */
	0x0F1200C4, /* TVAR_ash_pGAS[158] */
	0x0F120099, /* TVAR_ash_pGAS[159] */
	0x0F12007C, /* TVAR_ash_pGAS[160] */
	0x0F12006C, /* TVAR_ash_pGAS[161] */
	0x0F120067, /* TVAR_ash_pGAS[162] */
	0x0F12006E, /* TVAR_ash_pGAS[163] */
	0x0F12007F, /* TVAR_ash_pGAS[164] */
	0x0F12009E, /* TVAR_ash_pGAS[165] */
	0x0F1200C8, /* TVAR_ash_pGAS[166] */
	0x0F120100, /* TVAR_ash_pGAS[167] */
	0x0F120138, /* TVAR_ash_pGAS[168] */
	0x0F120107, /* TVAR_ash_pGAS[169] */
	0x0F1200CF, /* TVAR_ash_pGAS[170] */
	0x0F120097, /* TVAR_ash_pGAS[171] */
	0x0F12006D, /* TVAR_ash_pGAS[172] */
	0x0F120050, /* TVAR_ash_pGAS[173] */
	0x0F120040, /* TVAR_ash_pGAS[174] */
	0x0F12003B, /* TVAR_ash_pGAS[175] */
	0x0F120042, /* TVAR_ash_pGAS[176] */
	0x0F120055, /* TVAR_ash_pGAS[177] */
	0x0F120074, /* TVAR_ash_pGAS[178] */
	0x0F12009F, /* TVAR_ash_pGAS[179] */
	0x0F1200D9, /* TVAR_ash_pGAS[180] */
	0x0F120110, /* TVAR_ash_pGAS[181] */
	0x0F1200E9, /* TVAR_ash_pGAS[182] */
	0x0F1200AE, /* TVAR_ash_pGAS[183] */
	0x0F120077, /* TVAR_ash_pGAS[184] */
	0x0F12004D, /* TVAR_ash_pGAS[185] */
	0x0F12002F, /* TVAR_ash_pGAS[186] */
	0x0F12001F, /* TVAR_ash_pGAS[187] */
	0x0F12001A, /* TVAR_ash_pGAS[188] */
	0x0F120022, /* TVAR_ash_pGAS[189] */
	0x0F120036, /* TVAR_ash_pGAS[190] */
	0x0F120055, /* TVAR_ash_pGAS[191] */
	0x0F120081, /* TVAR_ash_pGAS[192] */
	0x0F1200BC, /* TVAR_ash_pGAS[193] */
	0x0F1200F5, /* TVAR_ash_pGAS[194] */
	0x0F1200D8, /* TVAR_ash_pGAS[195] */
	0x0F12009C, /* TVAR_ash_pGAS[196] */
	0x0F120064, /* TVAR_ash_pGAS[197] */
	0x0F12003A, /* TVAR_ash_pGAS[198] */
	0x0F12001C, /* TVAR_ash_pGAS[199] */
	0x0F12000B, /* TVAR_ash_pGAS[200] */
	0x0F120006, /* TVAR_ash_pGAS[201] */
	0x0F12000F, /* TVAR_ash_pGAS[202] */
	0x0F120024, /* TVAR_ash_pGAS[203] */
	0x0F120044, /* TVAR_ash_pGAS[204] */
	0x0F120070, /* TVAR_ash_pGAS[205] */
	0x0F1200AD, /* TVAR_ash_pGAS[206] */
	0x0F1200E6, /* TVAR_ash_pGAS[207] */
	0x0F1200D0, /* TVAR_ash_pGAS[208] */
	0x0F120095, /* TVAR_ash_pGAS[209] */
	0x0F12005D, /* TVAR_ash_pGAS[210] */
	0x0F120033, /* TVAR_ash_pGAS[211] */
	0x0F120015, /* TVAR_ash_pGAS[212] */
	0x0F120005, /* TVAR_ash_pGAS[213] */
	0x0F120000, /* TVAR_ash_pGAS[214] */
	0x0F120009, /* TVAR_ash_pGAS[215] */
	0x0F12001E, /* TVAR_ash_pGAS[216] */
	0x0F120041, /* TVAR_ash_pGAS[217] */
	0x0F12006D, /* TVAR_ash_pGAS[218] */
	0x0F1200AA, /* TVAR_ash_pGAS[219] */
	0x0F1200E4, /* TVAR_ash_pGAS[220] */
	0x0F1200D6, /* TVAR_ash_pGAS[221] */
	0x0F12009A, /* TVAR_ash_pGAS[222] */
	0x0F120062, /* TVAR_ash_pGAS[223] */
	0x0F120038, /* TVAR_ash_pGAS[224] */
	0x0F12001B, /* TVAR_ash_pGAS[225] */
	0x0F12000A, /* TVAR_ash_pGAS[226] */
	0x0F120006, /* TVAR_ash_pGAS[227] */
	0x0F120010, /* TVAR_ash_pGAS[228] */
	0x0F120026, /* TVAR_ash_pGAS[229] */
	0x0F120049, /* TVAR_ash_pGAS[230] */
	0x0F120076, /* TVAR_ash_pGAS[231] */
	0x0F1200B4, /* TVAR_ash_pGAS[232] */
	0x0F1200ED, /* TVAR_ash_pGAS[233] */
	0x0F1200E4, /* TVAR_ash_pGAS[234] */
	0x0F1200AB, /* TVAR_ash_pGAS[235] */
	0x0F120072, /* TVAR_ash_pGAS[236] */
	0x0F120049, /* TVAR_ash_pGAS[237] */
	0x0F12002C, /* TVAR_ash_pGAS[238] */
	0x0F12001C, /* TVAR_ash_pGAS[239] */
	0x0F120019, /* TVAR_ash_pGAS[240] */
	0x0F120023, /* TVAR_ash_pGAS[241] */
	0x0F12003A, /* TVAR_ash_pGAS[242] */
	0x0F12005D, /* TVAR_ash_pGAS[243] */
	0x0F12008B, /* TVAR_ash_pGAS[244] */
	0x0F1200C8, /* TVAR_ash_pGAS[245] */
	0x0F1200FF, /* TVAR_ash_pGAS[246] */
	0x0F1200FF, /* TVAR_ash_pGAS[247] */
	0x0F1200C8, /* TVAR_ash_pGAS[248] */
	0x0F120090, /* TVAR_ash_pGAS[249] */
	0x0F120066, /* TVAR_ash_pGAS[250] */
	0x0F12004A, /* TVAR_ash_pGAS[251] */
	0x0F12003A, /* TVAR_ash_pGAS[252] */
	0x0F120038, /* TVAR_ash_pGAS[253] */
	0x0F120042, /* TVAR_ash_pGAS[254] */
	0x0F120059, /* TVAR_ash_pGAS[255] */
	0x0F12007C, /* TVAR_ash_pGAS[256] */
	0x0F1200AB, /* TVAR_ash_pGAS[257] */
	0x0F1200E7, /* TVAR_ash_pGAS[258] */
	0x0F12011D, /* TVAR_ash_pGAS[259] */
	0x0F120123, /* TVAR_ash_pGAS[260] */
	0x0F1200EC, /* TVAR_ash_pGAS[261] */
	0x0F1200B7, /* TVAR_ash_pGAS[262] */
	0x0F12008E, /* TVAR_ash_pGAS[263] */
	0x0F120073, /* TVAR_ash_pGAS[264] */
	0x0F120064, /* TVAR_ash_pGAS[265] */
	0x0F120062, /* TVAR_ash_pGAS[266] */
	0x0F12006D, /* TVAR_ash_pGAS[267] */
	0x0F120083, /* TVAR_ash_pGAS[268] */
	0x0F1200A7, /* TVAR_ash_pGAS[269] */
	0x0F1200D4, /* TVAR_ash_pGAS[270] */
	0x0F12010B, /* TVAR_ash_pGAS[271] */
	0x0F120144, /* TVAR_ash_pGAS[272] */
	0x0F120156, /* TVAR_ash_pGAS[273] */
	0x0F120114, /* TVAR_ash_pGAS[274] */
	0x0F1200E2, /* TVAR_ash_pGAS[275] */
	0x0F1200BB, /* TVAR_ash_pGAS[276] */
	0x0F12009F, /* TVAR_ash_pGAS[277] */
	0x0F120090, /* TVAR_ash_pGAS[278] */
	0x0F12008E, /* TVAR_ash_pGAS[279] */
	0x0F120099, /* TVAR_ash_pGAS[280] */
	0x0F1200B0, /* TVAR_ash_pGAS[281] */
	0x0F1200D2, /* TVAR_ash_pGAS[282] */
	0x0F1200FE, /* TVAR_ash_pGAS[283] */
	0x0F120133, /* TVAR_ash_pGAS[284] */
	0x0F12017D, /* TVAR_ash_pGAS[285] */
	0x0F120174, /* TVAR_ash_pGAS[286] */
	0x0F12012A, /* TVAR_ash_pGAS[287] */
	0x0F1200F6, /* TVAR_ash_pGAS[288] */
	0x0F1200CC, /* TVAR_ash_pGAS[289] */
	0x0F1200AD, /* TVAR_ash_pGAS[290] */
	0x0F12009C, /* TVAR_ash_pGAS[291] */
	0x0F120099, /* TVAR_ash_pGAS[292] */
	0x0F1200A4, /* TVAR_ash_pGAS[293] */
	0x0F1200BC, /* TVAR_ash_pGAS[294] */
	0x0F1200E0, /* TVAR_ash_pGAS[295] */
	0x0F12010E, /* TVAR_ash_pGAS[296] */
	0x0F120147, /* TVAR_ash_pGAS[297] */
	0x0F120193, /* TVAR_ash_pGAS[298] */
	0x0F12013A, /* TVAR_ash_pGAS[299] */
	0x0F1200FE, /* TVAR_ash_pGAS[300] */
	0x0F1200C9, /* TVAR_ash_pGAS[301] */
	0x0F12009E, /* TVAR_ash_pGAS[302] */
	0x0F12007E, /* TVAR_ash_pGAS[303] */
	0x0F12006E, /* TVAR_ash_pGAS[304] */
	0x0F12006B, /* TVAR_ash_pGAS[305] */
	0x0F120075, /* TVAR_ash_pGAS[306] */
	0x0F12008D, /* TVAR_ash_pGAS[307] */
	0x0F1200B2, /* TVAR_ash_pGAS[308] */
	0x0F1200E0, /* TVAR_ash_pGAS[309] */
	0x0F12011B, /* TVAR_ash_pGAS[310] */
	0x0F120152, /* TVAR_ash_pGAS[311] */
	0x0F120112, /* TVAR_ash_pGAS[312] */
	0x0F1200D8, /* TVAR_ash_pGAS[313] */
	0x0F12009F, /* TVAR_ash_pGAS[314] */
	0x0F120073, /* TVAR_ash_pGAS[315] */
	0x0F120054, /* TVAR_ash_pGAS[316] */
	0x0F120042, /* TVAR_ash_pGAS[317] */
	0x0F12003F, /* TVAR_ash_pGAS[318] */
	0x0F120049, /* TVAR_ash_pGAS[319] */
	0x0F120061, /* TVAR_ash_pGAS[320] */
	0x0F120085, /* TVAR_ash_pGAS[321] */
	0x0F1200B5, /* TVAR_ash_pGAS[322] */
	0x0F1200F2, /* TVAR_ash_pGAS[323] */
	0x0F120128, /* TVAR_ash_pGAS[324] */
	0x0F1200F5, /* TVAR_ash_pGAS[325] */
	0x0F1200BA, /* TVAR_ash_pGAS[326] */
	0x0F120080, /* TVAR_ash_pGAS[327] */
	0x0F120054, /* TVAR_ash_pGAS[328] */
	0x0F120034, /* TVAR_ash_pGAS[329] */
	0x0F120022, /* TVAR_ash_pGAS[330] */
	0x0F12001D, /* TVAR_ash_pGAS[331] */
	0x0F120027, /* TVAR_ash_pGAS[332] */
	0x0F12003F, /* TVAR_ash_pGAS[333] */
	0x0F120064, /* TVAR_ash_pGAS[334] */
	0x0F120092, /* TVAR_ash_pGAS[335] */
	0x0F1200CF, /* TVAR_ash_pGAS[336] */
	0x0F120109, /* TVAR_ash_pGAS[337] */
	0x0F1200E4, /* TVAR_ash_pGAS[338] */
	0x0F1200A8, /* TVAR_ash_pGAS[339] */
	0x0F12006E, /* TVAR_ash_pGAS[340] */
	0x0F120041, /* TVAR_ash_pGAS[341] */
	0x0F120021, /* TVAR_ash_pGAS[342] */
	0x0F12000E, /* TVAR_ash_pGAS[343] */
	0x0F120008, /* TVAR_ash_pGAS[344] */
	0x0F120012, /* TVAR_ash_pGAS[345] */
	0x0F120029, /* TVAR_ash_pGAS[346] */
	0x0F12004D, /* TVAR_ash_pGAS[347] */
	0x0F12007C, /* TVAR_ash_pGAS[348] */
	0x0F1200B8, /* TVAR_ash_pGAS[349] */
	0x0F1200F3, /* TVAR_ash_pGAS[350] */
	0x0F1200DF, /* TVAR_ash_pGAS[351] */
	0x0F1200A2, /* TVAR_ash_pGAS[352] */
	0x0F120068, /* TVAR_ash_pGAS[353] */
	0x0F12003B, /* TVAR_ash_pGAS[354] */
	0x0F12001A, /* TVAR_ash_pGAS[355] */
	0x0F120006, /* TVAR_ash_pGAS[356] */
	0x0F120000, /* TVAR_ash_pGAS[357] */
	0x0F120009, /* TVAR_ash_pGAS[358] */
	0x0F12001F, /* TVAR_ash_pGAS[359] */
	0x0F120042, /* TVAR_ash_pGAS[360] */
	0x0F120071, /* TVAR_ash_pGAS[361] */
	0x0F1200AE, /* TVAR_ash_pGAS[362] */
	0x0F1200E9, /* TVAR_ash_pGAS[363] */
	0x0F1200E4, /* TVAR_ash_pGAS[364] */
	0x0F1200A7, /* TVAR_ash_pGAS[365] */
	0x0F12006C, /* TVAR_ash_pGAS[366] */
	0x0F12003F, /* TVAR_ash_pGAS[367] */
	0x0F12001E, /* TVAR_ash_pGAS[368] */
	0x0F12000B, /* TVAR_ash_pGAS[369] */
	0x0F120004, /* TVAR_ash_pGAS[370] */
	0x0F12000D, /* TVAR_ash_pGAS[371] */
	0x0F120022, /* TVAR_ash_pGAS[372] */
	0x0F120044, /* TVAR_ash_pGAS[373] */
	0x0F120072, /* TVAR_ash_pGAS[374] */
	0x0F1200AE, /* TVAR_ash_pGAS[375] */
	0x0F1200EA, /* TVAR_ash_pGAS[376] */
	0x0F1200F5, /* TVAR_ash_pGAS[377] */
	0x0F1200B9, /* TVAR_ash_pGAS[378] */
	0x0F12007D, /* TVAR_ash_pGAS[379] */
	0x0F120051, /* TVAR_ash_pGAS[380] */
	0x0F12002F, /* TVAR_ash_pGAS[381] */
	0x0F12001C, /* TVAR_ash_pGAS[382] */
	0x0F120015, /* TVAR_ash_pGAS[383] */
	0x0F12001D, /* TVAR_ash_pGAS[384] */
	0x0F120031, /* TVAR_ash_pGAS[385] */
	0x0F120053, /* TVAR_ash_pGAS[386] */
	0x0F120080, /* TVAR_ash_pGAS[387] */
	0x0F1200BC, /* TVAR_ash_pGAS[388] */
	0x0F1200F7, /* TVAR_ash_pGAS[389] */
	0x0F120111, /* TVAR_ash_pGAS[390] */
	0x0F1200D6, /* TVAR_ash_pGAS[391] */
	0x0F12009C, /* TVAR_ash_pGAS[392] */
	0x0F12006F, /* TVAR_ash_pGAS[393] */
	0x0F12004E, /* TVAR_ash_pGAS[394] */
	0x0F12003A, /* TVAR_ash_pGAS[395] */
	0x0F120033, /* TVAR_ash_pGAS[396] */
	0x0F12003A, /* TVAR_ash_pGAS[397] */
	0x0F12004E, /* TVAR_ash_pGAS[398] */
	0x0F12006E, /* TVAR_ash_pGAS[399] */
	0x0F12009B, /* TVAR_ash_pGAS[400] */
	0x0F1200D5, /* TVAR_ash_pGAS[401] */
	0x0F12010F, /* TVAR_ash_pGAS[402] */
	0x0F120139, /* TVAR_ash_pGAS[403] */
	0x0F1200FD, /* TVAR_ash_pGAS[404] */
	0x0F1200C6, /* TVAR_ash_pGAS[405] */
	0x0F120098, /* TVAR_ash_pGAS[406] */
	0x0F120077, /* TVAR_ash_pGAS[407] */
	0x0F120064, /* TVAR_ash_pGAS[408] */
	0x0F12005D, /* TVAR_ash_pGAS[409] */
	0x0F120064, /* TVAR_ash_pGAS[410] */
	0x0F120076, /* TVAR_ash_pGAS[411] */
	0x0F120095, /* TVAR_ash_pGAS[412] */
	0x0F1200C2, /* TVAR_ash_pGAS[413] */
	0x0F1200F8, /* TVAR_ash_pGAS[414] */
	0x0F120135, /* TVAR_ash_pGAS[415] */
	0x0F12016C, /* TVAR_ash_pGAS[416] */
	0x0F120128, /* TVAR_ash_pGAS[417] */
	0x0F1200F2, /* TVAR_ash_pGAS[418] */
	0x0F1200C7, /* TVAR_ash_pGAS[419] */
	0x0F1200A4, /* TVAR_ash_pGAS[420] */
	0x0F120092, /* TVAR_ash_pGAS[421] */
	0x0F12008A, /* TVAR_ash_pGAS[422] */
	0x0F12008F, /* TVAR_ash_pGAS[423] */
	0x0F1200A3, /* TVAR_ash_pGAS[424] */
	0x0F1200C0, /* TVAR_ash_pGAS[425] */
	0x0F1200EA, /* TVAR_ash_pGAS[426] */
	0x0F120121, /* TVAR_ash_pGAS[427] */
	0x0F12016F, /* TVAR_ash_pGAS[428] */
	0x0F120123, /* TVAR_ash_pGAS[429] */
	0x0F1200E7, /* TVAR_ash_pGAS[430] */
	0x0F1200BD, /* TVAR_ash_pGAS[431] */
	0x0F12009C, /* TVAR_ash_pGAS[432] */
	0x0F120087, /* TVAR_ash_pGAS[433] */
	0x0F12007C, /* TVAR_ash_pGAS[434] */
	0x0F12007B, /* TVAR_ash_pGAS[435] */
	0x0F120086, /* TVAR_ash_pGAS[436] */
	0x0F120099, /* TVAR_ash_pGAS[437] */
	0x0F1200B7, /* TVAR_ash_pGAS[438] */
	0x0F1200DC, /* TVAR_ash_pGAS[439] */
	0x0F12010E, /* TVAR_ash_pGAS[440] */
	0x0F12014A, /* TVAR_ash_pGAS[441] */
	0x0F1200F1, /* TVAR_ash_pGAS[442] */
	0x0F1200C1, /* TVAR_ash_pGAS[443] */
	0x0F120096, /* TVAR_ash_pGAS[444] */
	0x0F120077, /* TVAR_ash_pGAS[445] */
	0x0F120062, /* TVAR_ash_pGAS[446] */
	0x0F120058, /* TVAR_ash_pGAS[447] */
	0x0F120057, /* TVAR_ash_pGAS[448] */
	0x0F120061, /* TVAR_ash_pGAS[449] */
	0x0F120074, /* TVAR_ash_pGAS[450] */
	0x0F120090, /* TVAR_ash_pGAS[451] */
	0x0F1200B7, /* TVAR_ash_pGAS[452] */
	0x0F1200E7, /* TVAR_ash_pGAS[453] */
	0x0F120113, /* TVAR_ash_pGAS[454] */
	0x0F1200CB, /* TVAR_ash_pGAS[455] */
	0x0F12009D, /* TVAR_ash_pGAS[456] */
	0x0F120071, /* TVAR_ash_pGAS[457] */
	0x0F120052, /* TVAR_ash_pGAS[458] */
	0x0F120040, /* TVAR_ash_pGAS[459] */
	0x0F120035, /* TVAR_ash_pGAS[460] */
	0x0F120034, /* TVAR_ash_pGAS[461] */
	0x0F12003D, /* TVAR_ash_pGAS[462] */
	0x0F12004F, /* TVAR_ash_pGAS[463] */
	0x0F12006B, /* TVAR_ash_pGAS[464] */
	0x0F120090, /* TVAR_ash_pGAS[465] */
	0x0F1200C2, /* TVAR_ash_pGAS[466] */
	0x0F1200EC, /* TVAR_ash_pGAS[467] */
	0x0F1200B0, /* TVAR_ash_pGAS[468] */
	0x0F120082, /* TVAR_ash_pGAS[469] */
	0x0F120057, /* TVAR_ash_pGAS[470] */
	0x0F12003A, /* TVAR_ash_pGAS[471] */
	0x0F120026, /* TVAR_ash_pGAS[472] */
	0x0F12001B, /* TVAR_ash_pGAS[473] */
	0x0F120019, /* TVAR_ash_pGAS[474] */
	0x0F120021, /* TVAR_ash_pGAS[475] */
	0x0F120033, /* TVAR_ash_pGAS[476] */
	0x0F12004F, /* TVAR_ash_pGAS[477] */
	0x0F120072, /* TVAR_ash_pGAS[478] */
	0x0F1200A2, /* TVAR_ash_pGAS[479] */
	0x0F1200CF, /* TVAR_ash_pGAS[480] */
	0x0F12009F, /* TVAR_ash_pGAS[481] */
	0x0F120072, /* TVAR_ash_pGAS[482] */
	0x0F120047, /* TVAR_ash_pGAS[483] */
	0x0F12002A, /* TVAR_ash_pGAS[484] */
	0x0F120016, /* TVAR_ash_pGAS[485] */
	0x0F12000A, /* TVAR_ash_pGAS[486] */
	0x0F120008, /* TVAR_ash_pGAS[487] */
	0x0F12000F, /* TVAR_ash_pGAS[488] */
	0x0F120021, /* TVAR_ash_pGAS[489] */
	0x0F12003A, /* TVAR_ash_pGAS[490] */
	0x0F12005C, /* TVAR_ash_pGAS[491] */
	0x0F12008C, /* TVAR_ash_pGAS[492] */
	0x0F1200BB, /* TVAR_ash_pGAS[493] */
	0x0F12009A, /* TVAR_ash_pGAS[494] */
	0x0F12006C, /* TVAR_ash_pGAS[495] */
	0x0F120042, /* TVAR_ash_pGAS[496] */
	0x0F120024, /* TVAR_ash_pGAS[497] */
	0x0F120010, /* TVAR_ash_pGAS[498] */
	0x0F120004, /* TVAR_ash_pGAS[499] */
	0x0F120000, /* TVAR_ash_pGAS[500] */
	0x0F120007, /* TVAR_ash_pGAS[501] */
	0x0F120018, /* TVAR_ash_pGAS[502] */
	0x0F120030, /* TVAR_ash_pGAS[503] */
	0x0F120050, /* TVAR_ash_pGAS[504] */
	0x0F120080, /* TVAR_ash_pGAS[505] */
	0x0F1200AF, /* TVAR_ash_pGAS[506] */
	0x0F12009F, /* TVAR_ash_pGAS[507] */
	0x0F120071, /* TVAR_ash_pGAS[508] */
	0x0F120046, /* TVAR_ash_pGAS[509] */
	0x0F120028, /* TVAR_ash_pGAS[510] */
	0x0F120014, /* TVAR_ash_pGAS[511] */
	0x0F120006, /* TVAR_ash_pGAS[512] */
	0x0F120003, /* TVAR_ash_pGAS[513] */
	0x0F120009, /* TVAR_ash_pGAS[514] */
	0x0F120019, /* TVAR_ash_pGAS[515] */
	0x0F120030, /* TVAR_ash_pGAS[516] */
	0x0F120051, /* TVAR_ash_pGAS[517] */
	0x0F120080, /* TVAR_ash_pGAS[518] */
	0x0F1200B0, /* TVAR_ash_pGAS[519] */
	0x0F1200AD, /* TVAR_ash_pGAS[520] */
	0x0F120080, /* TVAR_ash_pGAS[521] */
	0x0F120055, /* TVAR_ash_pGAS[522] */
	0x0F120036, /* TVAR_ash_pGAS[523] */
	0x0F120021, /* TVAR_ash_pGAS[524] */
	0x0F120015, /* TVAR_ash_pGAS[525] */
	0x0F120010, /* TVAR_ash_pGAS[526] */
	0x0F120016, /* TVAR_ash_pGAS[527] */
	0x0F120024, /* TVAR_ash_pGAS[528] */
	0x0F12003A, /* TVAR_ash_pGAS[529] */
	0x0F12005B, /* TVAR_ash_pGAS[530] */
	0x0F12008B, /* TVAR_ash_pGAS[531] */
	0x0F1200BA, /* TVAR_ash_pGAS[532] */
	0x0F1200C8, /* TVAR_ash_pGAS[533] */
	0x0F120099, /* TVAR_ash_pGAS[534] */
	0x0F12006E, /* TVAR_ash_pGAS[535] */
	0x0F12004E, /* TVAR_ash_pGAS[536] */
	0x0F12003A, /* TVAR_ash_pGAS[537] */
	0x0F12002D, /* TVAR_ash_pGAS[538] */
	0x0F12002A, /* TVAR_ash_pGAS[539] */
	0x0F12002E, /* TVAR_ash_pGAS[540] */
	0x0F12003B, /* TVAR_ash_pGAS[541] */
	0x0F120051, /* TVAR_ash_pGAS[542] */
	0x0F120072, /* TVAR_ash_pGAS[543] */
	0x0F1200A1, /* TVAR_ash_pGAS[544] */
	0x0F1200D2, /* TVAR_ash_pGAS[545] */
	0x0F1200EC, /* TVAR_ash_pGAS[546] */
	0x0F1200BE, /* TVAR_ash_pGAS[547] */
	0x0F120092, /* TVAR_ash_pGAS[548] */
	0x0F120072, /* TVAR_ash_pGAS[549] */
	0x0F12005C, /* TVAR_ash_pGAS[550] */
	0x0F120050, /* TVAR_ash_pGAS[551] */
	0x0F12004D, /* TVAR_ash_pGAS[552] */
	0x0F120050, /* TVAR_ash_pGAS[553] */
	0x0F12005D, /* TVAR_ash_pGAS[554] */
	0x0F120073, /* TVAR_ash_pGAS[555] */
	0x0F120094, /* TVAR_ash_pGAS[556] */
	0x0F1200C2, /* TVAR_ash_pGAS[557] */
	0x0F1200F4, /* TVAR_ash_pGAS[558] */
	0x0F12011A, /* TVAR_ash_pGAS[559] */
	0x0F1200E3, /* TVAR_ash_pGAS[560] */
	0x0F1200B7, /* TVAR_ash_pGAS[561] */
	0x0F120097, /* TVAR_ash_pGAS[562] */
	0x0F120081, /* TVAR_ash_pGAS[563] */
	0x0F120075, /* TVAR_ash_pGAS[564] */
	0x0F12006F, /* TVAR_ash_pGAS[565] */
	0x0F120074, /* TVAR_ash_pGAS[566] */
	0x0F120081, /* TVAR_ash_pGAS[567] */
	0x0F120097, /* TVAR_ash_pGAS[568] */
	0x0F1200B8, /* TVAR_ash_pGAS[569] */
	0x0F1200E7, /* TVAR_ash_pGAS[570] */
	0x0F120127, /* TVAR_ash_pGAS[571] */

	/* Gamma */
	0x002A04CC,
	0x0F120000, /* SARR_usGammaLutRGBIndoor[0][0]  */
	0x0F12000D, /* SARR_usGammaLutRGBIndoor[0][1]  */
	0x0F12001B, /* SARR_usGammaLutRGBIndoor[0][2]  */
	0x0F12003C, /* SARR_usGammaLutRGBIndoor[0][3]  */
	0x0F120081, /* SARR_usGammaLutRGBIndoor[0][4]  */
	0x0F1200FE, /* SARR_usGammaLutRGBIndoor[0][5]  */
	0x0F120159, /* SARR_usGammaLutRGBIndoor[0][6]  */
	0x0F1201A1, /* SARR_usGammaLutRGBIndoor[0][7]  */
	0x0F120210, /* SARR_usGammaLutRGBIndoor[0][8]  */
	0x0F120263, /* SARR_usGammaLutRGBIndoor[0][9]  */
	0x0F1202D8, /* SARR_usGammaLutRGBIndoor[0][10] */
	0x0F120338, /* SARR_usGammaLutRGBIndoor[0][11] */
	0x0F120384, /* SARR_usGammaLutRGBIndoor[0][12] */
	0x0F1203BA, /* SARR_usGammaLutRGBIndoor[0][13] */
	0x0F1203E8, /* SARR_usGammaLutRGBIndoor[0][14] */
	0x0F120400, /* SARR_usGammaLutRGBIndoor[0][15] */

	0x0F120000, /* SARR_usGammaLutRGBIndoor[1][0]  */
	0x0F12000D, /* SARR_usGammaLutRGBIndoor[1][1]  */
	0x0F12001B, /* SARR_usGammaLutRGBIndoor[1][2]  */
	0x0F12003C, /* SARR_usGammaLutRGBIndoor[1][3]  */
	0x0F120081, /* SARR_usGammaLutRGBIndoor[1][4]  */
	0x0F1200FE, /* SARR_usGammaLutRGBIndoor[1][5]  */
	0x0F120159, /* SARR_usGammaLutRGBIndoor[1][6]  */
	0x0F1201A1, /* SARR_usGammaLutRGBIndoor[1][7]  */
	0x0F120210, /* SARR_usGammaLutRGBIndoor[1][8]  */
	0x0F120263, /* SARR_usGammaLutRGBIndoor[1][9]  */
	0x0F1202D8, /* SARR_usGammaLutRGBIndoor[1][10] */
	0x0F120338, /* SARR_usGammaLutRGBIndoor[1][11] */
	0x0F120384, /* SARR_usGammaLutRGBIndoor[1][12] */
	0x0F1203BA, /* SARR_usGammaLutRGBIndoor[1][13] */
	0x0F1203E8, /* SARR_usGammaLutRGBIndoor[1][14] */
	0x0F120400, /* SARR_usGammaLutRGBIndoor[1][15] */

	0x0F120000, /* SARR_usGammaLutRGBIndoor[2][0]  */
	0x0F12000D, /* SARR_usGammaLutRGBIndoor[2][1]  */
	0x0F12001B, /* SARR_usGammaLutRGBIndoor[2][2]  */
	0x0F12003C, /* SARR_usGammaLutRGBIndoor[2][3]  */
	0x0F120081, /* SARR_usGammaLutRGBIndoor[2][4]  */
	0x0F1200FE, /* SARR_usGammaLutRGBIndoor[2][5]  */
	0x0F120159, /* SARR_usGammaLutRGBIndoor[2][6]  */
	0x0F1201A1, /* SARR_usGammaLutRGBIndoor[2][7]  */
	0x0F120210, /* SARR_usGammaLutRGBIndoor[2][8]  */
	0x0F120263, /* SARR_usGammaLutRGBIndoor[2][9]  */
	0x0F1202D8, /* SARR_usGammaLutRGBIndoor[2][10] */
	0x0F120338, /* SARR_usGammaLutRGBIndoor[2][11] */
	0x0F120384, /* SARR_usGammaLutRGBIndoor[2][12] */
	0x0F1203BA, /* SARR_usGammaLutRGBIndoor[2][13] */
	0x0F1203E8, /* SARR_usGammaLutRGBIndoor[2][14] */
	0x0F120400, /* SARR_usGammaLutRGBIndoor[2][15] */



	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone  */
	0x0F120000, /* awbb_LowBr0_NBzone */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv */

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F12038F, /* awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F12039B, /* awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F120373, /* awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F120352, /* awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203B7, /* awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120334, /* awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203B5, /* awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120318, /* awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202FF, /* awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12038D, /* awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202E7, /* awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120372, /* awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202D0, /* awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12035D, /* awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202B5, /* awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120345, /* awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202A1, /* awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F120331, /* awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12028B, /* awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12031E, /* awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120309, /* awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F12025F, /* awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202F5, /* awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120250, /* awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202DB, /* awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F120241, /* awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202C7, /* awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F120233, /* awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202B9, /* awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120223, /* awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202AB, /* awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120217, /* awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F1202A2, /* awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120207, /* awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120294, /* awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201FA, /* awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120289, /* awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201EA, /* awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F120281, /* awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201DD, /* awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F12027B, /* awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201D0, /* awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201C3, /* awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12026A, /* awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201B6, /* awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F120265, /* awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201AB, /* awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F12025B, /* awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201A1, /* awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120254, /* awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120198, /* awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F12024B, /* awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120242, /* awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120191, /* awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F12023A, /* awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F1201C5, /* awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F1201DF, /* awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */


	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F120022,
	0x0F120000,
	0x0F12010F,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F120264,
	0x0F120279,
	0x0F120250,
	0x0F120287,
	0x0F120244,
	0x0F120287,
	0x0F120235,
	0x0F120289,
	0x0F120225,
	0x0F120287,
	0x0F120213,
	0x0F120286,
	0x0F120202,
	0x0F12027A,
	0x0F1201F3,
	0x0F120272,
	0x0F1201E9,
	0x0F120269,
	0x0F1201E2,
	0x0F120263,
	0x0F1201E0,
	0x0F12025A,
	0x0F1201E1,
	0x0F120256,
	0x0F1201EE,
	0x0F120251,
	0x0F1201F8,
	0x0F12024A,
	0x0F12020D,
	0x0F120231,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,


	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120011,
	0x0F120000,
	0x0F1201FF,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end	awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,



	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFE0, /* awbb_GridCorr_R_0__0_ */
	0x0F12FFE0, /* awbb_GridCorr_R_0__1_ */
	0x0F120000, /* awbb_GridCorr_R_0__2_ */
	0x0F120000, /* awbb_GridCorr_R_0__3_ */
	0x0F120000, /* awbb_GridCorr_R_0__4_ */
	0x0F120058, /* awbb_GridCorr_R_0__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_1__0_ */
	0x0F12FFE0, /* awbb_GridCorr_R_1__1_ */
	0x0F120000, /* awbb_GridCorr_R_1__2_ */
	0x0F120000, /* awbb_GridCorr_R_1__3_ */
	0x0F120000, /* awbb_GridCorr_R_1__4_ */
	0x0F120058, /* awbb_GridCorr_R_1__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_2__0_ */
	0x0F12FFE0, /* awbb_GridCorr_R_2__1_ */
	0x0F120000, /* awbb_GridCorr_R_2__2_ */
	0x0F120000, /* awbb_GridCorr_R_2__3_ */
	0x0F120000, /* awbb_GridCorr_R_2__4_ */
	0x0F120058, /* awbb_GridCorr_R_2__5_ */

	0x0F120000, /* awbb_GridCorr_B_0__0_ */
	0x0F120000, /* awbb_GridCorr_B_0__1_ */
	0x0F120000, /* awbb_GridCorr_B_0__2_ */
	0x0F120000, /* awbb_GridCorr_B_0__3_ */
	0x0F12FFF0, /* awbb_GridCorr_B_0__4_ */
	0x0F12FED4, /* awbb_GridCorr_B_0__5_ */

	0x0F120000, /* awbb_GridCorr_B_1__0_ */
	0x0F120000, /* awbb_GridCorr_B_1__1_ */
	0x0F120000, /* awbb_GridCorr_B_1__2_ */
	0x0F120000, /* awbb_GridCorr_B_1__3_ */
	0x0F12FFF0, /* awbb_GridCorr_B_1__4_ */
	0x0F12FED4, /* awbb_GridCorr_B_1__5_ */

	0x0F120000, /* awbb_GridCorr_B_2__0_ */
	0x0F120000, /* awbb_GridCorr_B_2__1_ */
	0x0F120000, /* awbb_GridCorr_B_2__2_ */
	0x0F120000, /* awbb_GridCorr_B_2__3_ */
	0x0F12FFF0, /* awbb_GridCorr_B_2__4_ */
	0x0F12FED4, /* awbb_GridCorr_B_2__5_ */

	0x0F1202C6, /* awbb_GridConst_1_0_ */
	0x0F120335, /* awbb_GridConst_1_1_ */
	0x0F1203B3, /* awbb_GridConst_1_2_ */
	0x0F120FD7, /* awbb_GridConst_2_0  */
	0x0F1210C5, /* awbb_GridConst_2_1  */
	0x0F12116A, /* awbb_GridConst_2_2  */
	0x0F12117C, /* awbb_GridConst_2_3  */
	0x0F1211C2, /* awbb_GridConst_2_4  */
	0x0F12120B, /* awbb_GridConst_2_5  */

	0x0F1200B3, /* awbb_GridCoeff_R_1 */
	0x0F1200B7, /* awbb_GridCoeff_B_1 */
	0x0F1200D3, /* awbb_GridCoeff_R_2 */
	0x0F120091, /* awbb_GridCoeff_B_2 */

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,

	/* Gamut Thresholds */
	0x002A0DAE,
	0x0F120036,
	0x0F12001C,
	0x002A0DAA,
	0x0F12071A,
	0x0F1203A4,

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120BB8,
	0x0F120096,
	0x002A0E86,
	0x0F120216,
	0x0F12029F,
	0x002A0D96,
	0x0F120BB7,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F120459,
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000, /* awbb_OutdoorFltrSz (outdoor WB moving average filtering) */

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,

	/* awbb_ChromaClassifyEn, default : enable */
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120210, /* 258 awbb_GainsMaxMove */
	0x0F120003,


	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/* param_start	TVAR_wbt_pBaseCcms */
	0x002A2800,
	0x0F1201E1, /* 01FB */
	0x0F12FFC4, /* FF9C */
	0x0F12FFF8, /* FFFF */
	0x0F120101, /* 0137 */
	0x0F12014C, /* 0113 */
	0x0F12FF55, /* FF6F */
	0x0F12FF5B, /* FF21 */
	0x0F120205, /* 0194 */
	0x0F12FF17, /* FF69 */
	0x0F12FEFE, /* FF14 */
	0x0F1201B6, /* 0158 */
	0x0F120107, /* 015D */
	0x0F12FFDB, /* FFF2 */
	0x0F12FFDB, /* FFF1 */
	0x0F1201D1, /* 0179 */
	0x0F120163, /* 017C */
	0x0F12FF9E, /* FFC3 */
	0x0F1201B3, /* 0197 */

	0x0F1201E1, /* 01FB */
	0x0F12FFC4, /* FF9C */
	0x0F12FFF8, /* FFFF */
	0x0F120101, /* 0137 */
	0x0F12014C, /* 0113 */
	0x0F12FF55, /* FF6F */
	0x0F12FF5B, /* FF21 */
	0x0F120205, /* 0194 */
	0x0F12FF17, /* FF69 */
	0x0F12FEFE, /* FF14 */
	0x0F1201B6, /* 0158 */
	0x0F120107, /* 015D */
	0x0F12FFDB, /* FFF2 */
	0x0F12FFDB, /* FFF1 */
	0x0F1201D1, /* 0179 */
	0x0F120163, /* 017C */
	0x0F12FF9E, /* FFC3 */
	0x0F1201B3, /* 0197 */

	0x0F1201E1, /* 01FB */
	0x0F12FFC4, /* FF9C */
	0x0F12FFF8, /* FFFF */
	0x0F120101, /* 0137 */
	0x0F12014C, /* 0113 */
	0x0F12FF55, /* FF6F */
	0x0F12FF5B, /* FF21 */
	0x0F120205, /* 0194 */
	0x0F12FF17, /* FF69 */
	0x0F12FEFE, /* FF14 */
	0x0F1201B6, /* 0158 */
	0x0F120107, /* 015D */
	0x0F12FFDB, /* FFF2 */
	0x0F12FFDB, /* FFF1 */
	0x0F1201D1, /* 0179 */
	0x0F120163, /* 017C */
	0x0F12FF9E, /* FFC3 */
	0x0F1201B3, /* 0197 */

	0x0F1201FB, /* 01FB */
	0x0F12FFA9, /* FF9C */
	0x0F12FFEA, /* FFFF */
	0x0F120134, /* 0137 */
	0x0F120133, /* 0113 */
	0x0F12FF5D, /* FF6F */
	0x0F12FE7A, /* FF21 */
	0x0F12017D, /* 0194 */
	0x0F12FEED, /* FF69 */
	0x0F12FF39, /* FF14 */
	0x0F1201D6, /* 0158 */
	0x0F1200C4, /* 015D */
	0x0F12FFCE, /* FFF2 */
	0x0F12FFCD, /* FFF1 */
	0x0F1201B7, /* 0179 */
	0x0F120176, /* 017C */
	0x0F12FFBD, /* FFC3 */
	0x0F120191, /* 0197 */

	0x0F1201FB, /* 01FB */
	0x0F12FFA9, /* FF9C */
	0x0F12FFEA, /* FFFF */
	0x0F120134, /* 0137 */
	0x0F120133, /* 0113 */
	0x0F12FF5D, /* FF6F */
	0x0F12FE7A, /* FF21 */
	0x0F12017D, /* 0194 */
	0x0F12FEED, /* FF69 */
	0x0F12FF39, /* FF14 */
	0x0F1201D6, /* 0158 */
	0x0F1200C4, /* 015D */
	0x0F12FFCE, /* FFF2 */
	0x0F12FFCD, /* FFF1 */
	0x0F1201B7, /* 0179 */
	0x0F120176, /* 017C */
	0x0F12FFBD, /* FFC3 */
	0x0F120191, /* 0197 */

	0x0F1201D2, /* 01D0 */
	0x0F12FFC2, /* FFB4 */
	0x0F12FFFC, /* 000C */
	0x0F12011E, /* 0122 */
	0x0F12011D, /* 0103 */
	0x0F12FF86, /* FF9B */
	0x0F12FE78, /* FF33 */
	0x0F12017B, /* 01C5 */
	0x0F12FEEB, /* FF33 */
	0x0F12FF38, /* FF16 */
	0x0F1201D5, /* 015A */
	0x0F1200C3, /* 015F */
	0x0F12FFCF, /* FFE0 */
	0x0F12FFCE, /* FFDF */
	0x0F1201B8, /* 0197 */
	0x0F120178, /* 0178 */
	0x0F12FFBF, /* FFBF */
	0x0F120193, /* 0193 */

	0x0F1201E0, /* outdoor CCM */
	0x0F12FFBF,
	0x0F12FFFD,
	0x0F1200F5,
	0x0F120139,
	0x0F12FF74,
	0x0F12FEEC,
	0x0F1201FD,
	0x0F12FF8E,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	/* Set NB */
	0x002A07EA,
	0x0F120000, /* afit_bUseNoiseInd 0 : NB 1: Noise Index */

	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */


	/* Set AFIT */
	/* AFIT Start Address */
	0x002A0814,
	0x0F12082C, /* TVAR_afit_pBaseVals */
	0x0F127000, /* TVAR_afit_pBaseVals */

	/* param_start	TVAR_afit_pBaseVals */
	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120000, /* CONTRAST                                                               */
	0x0F120000, /* SATURATION                                                             */
	0x0F120000, /* SHARP_BLUR                                                             */
	0x0F120030, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F1203ff, /* Denoise1_iYDenThreshLow                                                */
	0x0F120028, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F1203ff, /* Denoise1_iYDenThreshHigh                                               */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120344, /* UVDenoise_iYLowThresh                                                  */
	0x0F12033A, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"    bin: desparity low */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                    */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F12090F, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                       */
	0x0F120032, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                     */
	0x0F120A0A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                        */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                      */
	0x0F120412, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                     */
	0x0F12040C, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"             */
	0x0F120005, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                   */
	0x0F120805, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                     */
	0x0F120500, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                     */
	0x0F121008, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                     */
	0x0F120164, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                           */
	0x0F1201AA, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F128028, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                               */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120032, /*  RGB2YUV_iYOffset                                                      */

	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120000, /* CONTRAST                                                               */
	0x0F120000, /* SATURATION                                                             */
	0x0F120000, /* SHARP_BLUR                                                             */
	0x0F120000, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                               */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120114, /* UVDenoise_iYLowThresh*/
	0x0F12020A, /* UVDenoise_iYHighThresh*/
	0x0F1203FF, /* UVDenoise_iUVLowThresh*/
	0x0F1203FF, /* UVDenoise_iUVHighThresh*/
	0x0F120028, /* DSMix1_iLowLimit_Wide*/
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin*/
	0x0F120014, /* DSMix1_iHighLimit_Wide*/
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin*/
	0x0F120050, /* DSMix1_iLowLimit_Fine*/
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin*/
	0x0F120046, /* DSMix1_iHighLimit_Fine*/
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin*/
	0x0F120106, /* DSMix1_iRGBOffset*/
	0x0F12006F, /* DSMix1_iDemClamp*/
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin" bin: desparity low */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin" */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F12090F, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                       */
	0x0F120032, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                     */
	0x0F120A0A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                        */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                      */
	0x0F120412, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                     */
	0x0F12040C, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"             */
	0x0F120005, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                   */
	0x0F120805, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                     */
	0x0F120500, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                     */
	0x0F121008, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                     */
	0x0F120164, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                           */
	0x0F1201A0, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F128028, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                               */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120015, /*  RGB2YUV_iYOffset                                                      */

	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120014, /* CONTRAST                                                               */
	0x0F120000, /* SATURATION                                                             */
	0x0F120000, /* SHARP_BLUR                                                             */
	0x0F120000, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                               */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120129, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120014, /* UVDenoise_iYLowThresh                                                  */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"    bin: desparity low */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                    */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F12100F, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                       */
	0x0F121032, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                     */
	0x0F120A0A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                        */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                      */
	0x0F120405, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                     */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"             */
	0x0F120003, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                   */
	0x0F120808, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                     */
	0x0F120500, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                     */
	0x0F121008, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                     */
	0x0F120164, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                           */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F128028, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                               */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120000, /*  RGB2YUV_iYOffset                                                      */

	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120014, /* CONTRAST                                                               */
	0x0F120002, /* SATURATION                                                             */
	0x0F120000, /* SHARP_BLUR                                                             */
	0x0F120000, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                               */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120014, /* UVDenoise_iYLowThresh                                                  */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"    bin: desparity low */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                    */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F122019, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                       */
	0x0F122032, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                     */
	0x0F120A0A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                        */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                      */
	0x0F120405, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                     */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"             */
	0x0F120003, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                   */
	0x0F120808, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                     */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                     */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                     */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                           */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                               */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120000, /*  RGB2YUV_iYOffset                                                      */

	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120014, /* CONTRAST                                                               */
	0x0F12000A, /* SATURATION                                                             */
	0x0F120008, /* SHARP_BLUR                                                             */
	0x0F120000, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F120006, /* Denoise1_iYDenThreshLow                                                */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                               */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120000, /* UVDenoise_iYLowThresh                                                  */
	0x0F120000, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"    bin: desparity low */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                    */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F121408, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F120F05, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F120105, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F122019, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                       */
	0x0F122032, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                     */
	0x0F120A0A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                        */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                      */
	0x0F120405, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                     */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"             */
	0x0F120003, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                   */
	0x0F120808, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                     */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                     */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                     */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                           */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F12805A, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                               */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120000, /*  RGB2YUV_iYOffset                                                      */

	0x0F1200FF, /* Denoise1_iUVDenThreshLow                         */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                        */
	0x0F120800, /* Denoise1_sensor_width                            */
	0x0F120600, /* Denoise1_sensor_height                           */
	0x0F120000, /* Denoise1_start_x                                 */
	0x0F120000, /* Denoise1_start_y                                 */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "         */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "       */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  " */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "          */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "        */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "     */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "    */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh"*/
	0x0F120000, /*  Demosaic4_iBypassSelect                         */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */

	0x0028D000,
	0x002AB0CC,
	0x0F12000B, /* Non contious mode */
	/* Wifi VT-Call END of Initial */
};

/*===========================================
* CAMERA_PREVIEW - Կ   ͽ  *
============================================*/

static const u32 s5k5bafx_preview[] =
{
	0xFCFCD000,
	0x00287000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */
	0xffff0096, /* 150ms */

	/*  MIPI */
	0x0028D000,
	0x002AB0CC,
	0x0F12000B,

};

/*===========================================
*	CAMERA_SNAPSHOT  - Կ 		  *
============================================*/

static const u32 s5k5bafx_capture[] =
{
	0xFCFCD000,
	0x00287000,

	0x002A0224,
	0x0F120000, /* REG_TC_GP_ActiveCapConfig */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A0226,
	0x0F120001, /* REG_TC_GP_CapConfigChanged */
	0x002A01F4,
	0x0F120001, /* REG_TC_GP_EnableCapture */
	0x0F120001, /* REG_TC_GP_EnableCaptureChanged */
	0xffff0096, /* 150ms */

	/*  MIPI */
	0x0028D000,
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bafx_recording_60Hz_common[] = {

	/* recording 25fps Anti-Flicker 60Hz*/

	0xFCFCD000,

	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* p100	Delay */


	/* Trap and Patch  2008-11-18 10:15:41 */
	0x00287000,
	0x002A1668,
	0x0F12B5FE,
	0x0F120007,
	0x0F12683C,
	0x0F12687E,
	0x0F121DA5,
	0x0F1288A0,
	0x0F122800,
	0x0F12D00B,
	0x0F1288A8,
	0x0F122800,
	0x0F12D008,
	0x0F128820,
	0x0F128829,
	0x0F124288,
	0x0F12D301,
	0x0F121A40,
	0x0F12E000,
	0x0F121A08,
	0x0F129001,
	0x0F12E001,
	0x0F122019,
	0x0F129001,
	0x0F124916,
	0x0F12466B,
	0x0F128A48,
	0x0F128118,
	0x0F128A88,
	0x0F128158,
	0x0F124814,
	0x0F128940,
	0x0F120040,
	0x0F122103,
	0x0F12F000,
	0x0F12F826,
	0x0F1288A1,
	0x0F124288,
	0x0F12D908,
	0x0F128828,
	0x0F128030,
	0x0F128868,
	0x0F128070,
	0x0F1288A8,
	0x0F126038,
	0x0F12BCFE,
	0x0F12BC08,
	0x0F124718,
	0x0F1288A9,
	0x0F124288,
	0x0F12D906,
	0x0F128820,
	0x0F128030,
	0x0F128860,
	0x0F128070,
	0x0F1288A0,
	0x0F126038,
	0x0F12E7F2,
	0x0F129801,
	0x0F12A902,
	0x0F12F000,
	0x0F12F812,
	0x0F120033,
	0x0F120029,
	0x0F129A02,
	0x0F120020,
	0x0F12F000,
	0x0F12F814,
	0x0F126038,
	0x0F12E7E6,
	0x0F121A28,
	0x0F127000,
	0x0F120D64,
	0x0F127000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F126009,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12622F,
	0x0F120000,
	0x002A2080,
	0x0F12B510,
	0x0F12F000,
	0x0F12F8F4,
	0x0F12BC10,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F0,
	0x0F12B08B,
	0x0F120006,
	0x0F122000,
	0x0F129004,
	0x0F126835,
	0x0F126874,
	0x0F1268B0,
	0x0F12900A,
	0x0F1268F0,
	0x0F129009,
	0x0F124F7D,
	0x0F128979,
	0x0F12084A,
	0x0F1288A8,
	0x0F1288A3,
	0x0F124298,
	0x0F12D300,
	0x0F120018,
	0x0F12F000,
	0x0F12F907,
	0x0F129007,
	0x0F120021,
	0x0F120028,
	0x0F12AA04,
	0x0F12F000,
	0x0F12F909,
	0x0F129006,
	0x0F1288A8,
	0x0F122800,
	0x0F12D102,
	0x0F1227FF,
	0x0F121C7F,
	0x0F12E047,
	0x0F1288A0,
	0x0F122800,
	0x0F12D101,
	0x0F122700,
	0x0F12E042,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12F000,
	0x0F12F8F8,
	0x0F129008,
	0x0F128ABA,
	0x0F129808,
	0x0F12466B,
	0x0F124342,
	0x0F129202,
	0x0F128820,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8EA,
	0x0F129A02,
	0x0F1217D1,
	0x0F120E09,
	0x0F121889,
	0x0F121209,
	0x0F124288,
	0x0F12DD1F,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8DA,
	0x0F129001,
	0x0F128828,
	0x0F12466B,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12980A,
	0x0F129902,
	0x0F12F000,
	0x0F12F8D0,
	0x0F128AB9,
	0x0F129A08,
	0x0F124351,
	0x0F1217CA,
	0x0F120E12,
	0x0F121851,
	0x0F12120A,
	0x0F129901,
	0x0F12F000,
	0x0F12F8B6,
	0x0F120407,
	0x0F120C3F,
	0x0F12E000,
	0x0F122700,
	0x0F128820,
	0x0F12466B,
	0x0F12AA05,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12003B,
	0x0F12F000,
	0x0F12F8BB,
	0x0F1288A1,
	0x0F1288A8,
	0x0F12003A,
	0x0F12F000,
	0x0F12F8BE,
	0x0F120004,
	0x0F12A804,
	0x0F12C803,
	0x0F129A09,
	0x0F129B07,
	0x0F12F000,
	0x0F12F8AF,
	0x0F12A806,
	0x0F12C805,
	0x0F120021,
	0x0F12F000,
	0x0F12F8B2,
	0x0F126030,
	0x0F12B00B,
	0x0F12BCF0,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F1,
	0x0F129900,
	0x0F12680C,
	0x0F12493A,
	0x0F12694B,
	0x0F12698A,
	0x0F124694,
	0x0F1269CD,
	0x0F126A0E,
	0x0F124F38,
	0x0F1242BC,
	0x0F12D800,
	0x0F120027,
	0x0F124937,
	0x0F126B89,
	0x0F120409,
	0x0F120C09,
	0x0F124A35,
	0x0F121E92,
	0x0F126BD2,
	0x0F120412,
	0x0F120C12,
	0x0F12429F,
	0x0F12D801,
	0x0F120020,
	0x0F12E031,
	0x0F12001F,
	0x0F12434F,
	0x0F120A3F,
	0x0F1242A7,
	0x0F12D301,
	0x0F120018,
	0x0F12E02A,
	0x0F12002B,
	0x0F12434B,
	0x0F120A1B,
	0x0F1242A3,
	0x0F12D303,
	0x0F120220,
	0x0F12F000,
	0x0F12F88C,
	0x0F12E021,
	0x0F120029,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D301,
	0x0F120028,
	0x0F12E01A,
	0x0F120031,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D304,
	0x0F120220,
	0x0F120011,
	0x0F12F000,
	0x0F12F87B,
	0x0F12E010,
	0x0F12491E,
	0x0F128C89,
	0x0F12000A,
	0x0F124372,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D301,
	0x0F120030,
	0x0F12E007,
	0x0F124662,
	0x0F12434A,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D302,
	0x0F120220,
	0x0F12F000,
	0x0F12F869,
	0x0F124B16,
	0x0F124D18,
	0x0F128D99,
	0x0F121FCA,
	0x0F123AF9,
	0x0F12D00A,
	0x0F122001,
	0x0F120240,
	0x0F128468,
	0x0F120220,
	0x0F12F000,
	0x0F12F85D,
	0x0F129900,
	0x0F126008,
	0x0F12BCF8,
	0x0F12BC08,
	0x0F124718,
	0x0F128D19,
	0x0F128469,
	0x0F129900,
	0x0F126008,
	0x0F12E7F7,
	0x0F12B570,
	0x0F122200,
	0x0F12490E,
	0x0F12480E,
	0x0F122401,
	0x0F12F000,
	0x0F12F852,
	0x0F120022,
	0x0F12490D,
	0x0F12480D,
	0x0F122502,
	0x0F12F000,
	0x0F12F84C,
	0x0F12490C,
	0x0F12480D,
	0x0F12002A,
	0x0F12F000,
	0x0F12F847,
	0x0F12BC70,
	0x0F12BC08,
	0x0F124718,
	0x0F120D64,
	0x0F127000,
	0x0F120470,
	0x0F127000,
	0x0F12A120,
	0x0F120007,
	0x0F120402,
	0x0F127000,
	0x0F1214A0,
	0x0F127000,
	0x0F12208D,
	0x0F127000,
	0x0F12622F,
	0x0F120000,
	0x0F121669,
	0x0F127000,
	0x0F126445,
	0x0F120000,
	0x0F1221AB,
	0x0F127000,
	0x0F122AA9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125F49,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FC7,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125457,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FA3,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F1251F9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A007,
	0x0F120000,
	0x0F126546,
	0x0F122062,
	0x0F123120,
	0x0F123220,
	0x0F123130,
	0x0F120030,
	0x0F12E010,
	0x0F120208,
	0x0F120058,
	0x0F120000,
	/* End of Trap and Patch (Last : 70002342h) */
	/* Total Size 896 (0x0380)                  */


	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0, /* setot_uOnlineClocksDiv40             */
	0x002A0AE2,
	0x0F12222E, /* setot_usSetRomWaitStateThreshold4KHz */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */


	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,


	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,

	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,
	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,
	0x0F120015,
	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,


	0x002AF900,
	0x0F120067,


	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,

	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,

	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,

	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,

	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,

	0x002AF4D6,
	0x0F120090,


	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,


	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,

	/* sensor aig table setting */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,


	0x002A1084,
	0x0F120000,
	0x0F120000,

	/* Set AE Target */
	0x002A0F4C,
	0x0F12003A, /* TVAR_ae_BrAve */

	0x002A0478,
	0x0F120114,
	0x0F1200EB, /* ae boundary */



	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A, /* uMaxExp1 */
	0x0F120000,
	0x002A048C,
	0x0F128214, /* uMaxExp2 */
	0x0F120000,
	0x0F12A122, /* uMaxExp3 */
	0x0F120000,
	0x002A0488,
	0x0F12f424, /* uMaxExp4 */
	0x0F120000,
	0x002A043A,
	0x0F1201D0, /* lt_uMaxAnGain0   */
	0x0F1201E0, /* lt_uMaxAnGain0_1 */
	0x002A0494,
	0x0F120300, /* lt_uMaxAnGain1 */
	0x0F120650, /* lt_uMaxAnGain2 */
	0x0f120100,
	0x002A0F52,
	0x0F12000F, /* ae_StatMode */

	0x002A0E98, /* bp_uMaxBrightnessFactor */
	0x0F1202A8,
	0x002A0E9E, /* bp_uMinBrightnessFactor */
	0x0F120298,

	/* 1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001, /* AFC_Default60Hz	 Auto Flicker 60Hz start 0: Auto Flicker 50Hz start */
	0x002A03F8,
	0x0F12005F, /* REG_TC_DBG_AutoAlgEnBits   default : 007F */


	0xffff000a, /* p10	Wait10mSec */

	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0, /* REG_TC_IPRM_InClockLSBs */
	0x0F120000, /* REG_TC_IPRM_InClockMSBs */

	/* Parallel or MIPI Selection */
	0x002A01C6,
	0x0F120001, /* REG_TC_IPRM_UseNPviClocks         */
	0x0F120001, /* REG_TC_IPRM_UseNMipiClocks        */
	0x0F120000, /* REG_TC_IPRM_bBlockInternalPllCalc */

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770, /* REG_TC_IPRM_OpClk4KHz_0      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_0 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_0 */

	/* System Clock 1 (System : 48Mhz, PCLK : 48Mhz) */
	0x002A01D2,
	0x0F122EE0, /* REG_TC_IPRM_OpClk4KHz_1      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_1 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_1 */



	0x002A01DE,
	0x0F120001, /* REG_TC_IPRM_UseRegsAPI        */
	0x0F120001, /* REG_TC_IPRM_InitParamsUpdated */
	0xffff0064, /* p100                          */



	/* Crop */
	0x002A01FA,
	0x0F120640, /* REG_TC_GP_PrevReqInputWidth  */
	0x0F1204B0, /* REG_TC_GP_PrevReqInputHeight */
	0x0F120000, /* REG_TC_GP_PrevInputWidthOfs  */
	0x0F120000, /* REG_TC_GP_PrevInputHeightOfs */


	/* Set Preview Config */
	/* Preview Config 0 (VGA fixed 30fps) */
	0x002A0242,
	0x0F120280, /* REG_0TC_PCFG_usWidth                */
	0x0F1201E0, /* REG_0TC_PCFG_usHeight               */
	0x0F120005, /* REG_0TC_PCFG_Format                 */
	0x0F122EE0, /* REG_0TC_PCFG_usMaxOut4KHzRate       */
	0x0F122EE0, /* REG_0TC_PCFG_usMinOut4KHzRate       */
	0x0F120052, /* REG_0TC_PCFG_PVIMask                */
	0x0F120001, /* REG_0TC_PCFG_uClockInd              */
	0x0F120002, /* REG_0TC_PCFG_usFrTimeType           */
	0x0F120001, /* REG_0TC_PCFG_FrRateQualityType      */
	0x0F12018c, /* REG_0TC_PCFG_usMaxFrTimeMsecMult10  */
	0x0F12018c, /* REG_0TC_PCFG_usMinFrTimeMsecMult10  */
	0x0F120000, /* REG_0TC_PCFG_sSaturation            */
	0x0F120000, /* REG_0TC_PCFG_sSharpBlur             */
	0x0F120000, /* REG_0TC_PCFG_sGlamour               */
	0x0F120000, /* REG_0TC_PCFG_sColorTemp             */
	0x0F120000, /* REG_0TC_PCFG_uDeviceGammaIndex      */
	0x0F120000, /* REG_0TC_PCFG_uPrevMirror            */
	0x0F120000, /* REG_0TC_PCFG_uCaptureMirror         */
	0x0F120000, /* REG_0TC_PCFG_uRotation              */

	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280, /* REG_1TC_PCFG_usWidth                */
	0x0F1201E0, /* REG_1TC_PCFG_usHeight               */
	0x0F120005, /* REG_1TC_PCFG_Format                 */
	0x0F122EE0, /* REG_1TC_PCFG_usMaxOut4KHzRate       */
	0x0F122EE0, /* REG_1TC_PCFG_usMinOut4KHzRate       */
	0x0F120052, /* REG_1TC_PCFG_PVIMask                */
	0x0F120001, /* REG_1TC_PCFG_uClockInd              */
	0x0F120000, /* REG_1TC_PCFG_usFrTimeType           */
	0x0F120000, /* REG_1TC_PCFG_FrRateQualityType      */
	0x0F12029A, /* REG_1TC_PCFG_usMaxFrTimeMsecMult10  */
	0x0F12014D, /* REG_1TC_PCFG_usMinFrTimeMsecMult10  */
	0x0F120000, /* REG_1TC_PCFG_sSaturation            */
	0x0F120000, /* REG_1TC_PCFG_sSharpBlur             */
	0x0F120000, /* REG_1TC_PCFG_sGlamour               */
	0x0F120000, /* REG_1TC_PCFG_sColorTemp             */
	0x0F120000, /* REG_1TC_PCFG_uDeviceGammaIndex      */
	0x0F120000, /* REG_1TC_PCFG_uPrevMirror            */
	0x0F120000, /* REG_1TC_PCFG_uCaptureMirror         */
	0x0F120000, /* REG_1TC_PCFG_uRotation              */


	/* Set MIPI */
	0x002A03AC,
	0x0F120000, /* REG_TC_FLS_Mode        */
	0x002A03F2,
	0x0F120001, /* REG_TC_OIF_EnMipiLanes */
	0x0F1200C3, /* REG_TC_OIF_EnPackets   */
	0x0F120001, /* REG_TC_OIF_CfgChanged  */

	/* Apply preview config */
	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */



	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000, /* REG_0TC_CCFG_uCaptureMode          */
	0x0F120640, /* REG_0TC_CCFG_usWidth               */
	0x0F1204B0, /* REG_0TC_CCFG_usHeight              */
	0x0F120005, /* REG_0TC_CCFG_Format                */
	0x0F122EE0, /* REG_0TC_CCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_CCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_CCFG_PVIMask               */
	0x0F120001, /* REG_0TC_CCFG_uClockInd             */
	0x0F120002, /* REG_0TC_CCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_CCFG_FrRateQualityType     */
	0x0F1204E2, /* REG_0TC_CCFG_usMaxFrTimeMsecMult10 */
	0x0F1204E2, /* REG_0TC_CCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_CCFG_sSaturation           */
	0x0F120000, /* REG_0TC_CCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_CCFG_sGlamour              */
	0x0F120000, /* REG_0TC_CCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_CCFG_uDeviceGammaIndex     */



	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A07C0,
	0x0F120004,
	0x0F120004,

	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,


	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000, /* ae_WeightTbl_16_0_ */
	0x0F120000, /* ae_WeightTbl_16_1_ */
	0x0F120000, /* ae_WeightTbl_16_2_ */
	0x0F120000, /* ae_WeightTbl_16_3_ */
	0x0F120101, /* ae_WeightTbl_16_4_ */
	0x0F120101, /* ae_WeightTbl_16_5_ */
	0x0F120101, /* ae_WeightTbl_16_6_ */
	0x0F120101, /* ae_WeightTbl_16_7_ */
	0x0F120101, /* ae_WeightTbl_16_8_ */
	0x0F120302, /* ae_WeightTbl_16_9_ */
	0x0F120203, /* ae_WeightTbl_16_10 */
	0x0F120101, /* ae_WeightTbl_16_11 */
	0x0F120101, /* ae_WeightTbl_16_12 */
	0x0F120403, /* ae_WeightTbl_16_13 */
	0x0F120304, /* ae_WeightTbl_16_14 */
	0x0F120101, /* ae_WeightTbl_16_15 */
	0x0F120101, /* ae_WeightTbl_16_16 */
	0x0F120403, /* ae_WeightTbl_16_17 */
	0x0F120304, /* ae_WeightTbl_16_18 */
	0x0F120101, /* ae_WeightTbl_16_19 */
	0x0F120101, /* ae_WeightTbl_16_20 */
	0x0F120302, /* ae_WeightTbl_16_21 */
	0x0F120203, /* ae_WeightTbl_16_22 */
	0x0F120101, /* ae_WeightTbl_16_23 */
	0x0F120101, /* ae_WeightTbl_16_24 */
	0x0F120101, /* ae_WeightTbl_16_25 */
	0x0F120101, /* ae_WeightTbl_16_26 */
	0x0F120101, /* ae_WeightTbl_16_27 */
	0x0F120000, /* ae_WeightTbl_16_28 */
	0x0F120000, /* ae_WeightTbl_16_29 */
	0x0F120000, /* ae_WeightTbl_16_30 */
	0x0F120000, /* ae_WeightTbl_16_31 */


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,

	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,

	/* Target Brightness Control */
	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,

	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */

	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */

	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */

	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */

	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */

	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */

	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */

	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120108, /* 100 TVAR_ash_GASOutdoorAlpha_0_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_*/

	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,

	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120160, /* TVAR_ash_pGAS[0]   */
	0x0F120134, /* TVAR_ash_pGAS[1]   */
	0x0F1200FF, /* TVAR_ash_pGAS[2]   */
	0x0F1200D1, /* TVAR_ash_pGAS[3]   */
	0x0F1200B1, /* TVAR_ash_pGAS[4]   */
	0x0F12009D, /* TVAR_ash_pGAS[5]   */
	0x0F120096, /* TVAR_ash_pGAS[6]   */
	0x0F12009E, /* TVAR_ash_pGAS[7]   */
	0x0F1200B3, /* TVAR_ash_pGAS[8]   */
	0x0F1200D3, /* TVAR_ash_pGAS[9]   */
	0x0F1200FF, /* TVAR_ash_pGAS[10]  */
	0x0F120131, /* TVAR_ash_pGAS[11]  */
	0x0F120159, /* TVAR_ash_pGAS[12]  */
	0x0F12013C, /* TVAR_ash_pGAS[13]  */
	0x0F120107, /* TVAR_ash_pGAS[14]  */
	0x0F1200CD, /* TVAR_ash_pGAS[15]  */
	0x0F1200A1, /* TVAR_ash_pGAS[16]  */
	0x0F120080, /* TVAR_ash_pGAS[17]  */
	0x0F12006B, /* TVAR_ash_pGAS[18]  */
	0x0F120064, /* TVAR_ash_pGAS[19]  */
	0x0F12006C, /* TVAR_ash_pGAS[20]  */
	0x0F120080, /* TVAR_ash_pGAS[21]  */
	0x0F1200A1, /* TVAR_ash_pGAS[22]  */
	0x0F1200CD, /* TVAR_ash_pGAS[23]  */
	0x0F120106, /* TVAR_ash_pGAS[24]  */
	0x0F120139, /* TVAR_ash_pGAS[25]  */
	0x0F120116, /* TVAR_ash_pGAS[26]  */
	0x0F1200DC, /* TVAR_ash_pGAS[27]  */
	0x0F1200A2, /* TVAR_ash_pGAS[28]  */
	0x0F120073, /* TVAR_ash_pGAS[29]  */
	0x0F120051, /* TVAR_ash_pGAS[30]  */
	0x0F12003B, /* TVAR_ash_pGAS[31]  */
	0x0F120033, /* TVAR_ash_pGAS[32]  */
	0x0F12003B, /* TVAR_ash_pGAS[33]  */
	0x0F120050, /* TVAR_ash_pGAS[34]  */
	0x0F120073, /* TVAR_ash_pGAS[35]  */
	0x0F1200A2, /* TVAR_ash_pGAS[36]  */
	0x0F1200DD, /* TVAR_ash_pGAS[37]  */
	0x0F120115, /* TVAR_ash_pGAS[38]  */
	0x0F1200FA, /* TVAR_ash_pGAS[39]  */
	0x0F1200BF, /* TVAR_ash_pGAS[40]  */
	0x0F120085, /* TVAR_ash_pGAS[41]  */
	0x0F120055, /* TVAR_ash_pGAS[42]  */
	0x0F120031, /* TVAR_ash_pGAS[43]  */
	0x0F12001B, /* TVAR_ash_pGAS[44]  */
	0x0F120014, /* TVAR_ash_pGAS[45]  */
	0x0F12001A, /* TVAR_ash_pGAS[46]  */
	0x0F120031, /* TVAR_ash_pGAS[47]  */
	0x0F120055, /* TVAR_ash_pGAS[48]  */
	0x0F120085, /* TVAR_ash_pGAS[49]  */
	0x0F1200C0, /* TVAR_ash_pGAS[50]  */
	0x0F1200FB, /* TVAR_ash_pGAS[51]  */
	0x0F1200EA, /* TVAR_ash_pGAS[52]  */
	0x0F1200AF, /* TVAR_ash_pGAS[53]  */
	0x0F120074, /* TVAR_ash_pGAS[54]  */
	0x0F120045, /* TVAR_ash_pGAS[55]  */
	0x0F120020, /* TVAR_ash_pGAS[56]  */
	0x0F12000B, /* TVAR_ash_pGAS[57]  */
	0x0F120003, /* TVAR_ash_pGAS[58]  */
	0x0F12000A, /* TVAR_ash_pGAS[59]  */
	0x0F120020, /* TVAR_ash_pGAS[60]  */
	0x0F120046, /* TVAR_ash_pGAS[61]  */
	0x0F120076, /* TVAR_ash_pGAS[62]  */
	0x0F1200B1, /* TVAR_ash_pGAS[63]  */
	0x0F1200ED, /* TVAR_ash_pGAS[64]  */
	0x0F1200E6, /* TVAR_ash_pGAS[65]  */
	0x0F1200AA, /* TVAR_ash_pGAS[66]  */
	0x0F120071, /* TVAR_ash_pGAS[67]  */
	0x0F120041, /* TVAR_ash_pGAS[68]  */
	0x0F12001D, /* TVAR_ash_pGAS[69]  */
	0x0F120008, /* TVAR_ash_pGAS[70]  */
	0x0F120000, /* TVAR_ash_pGAS[71]  */
	0x0F120007, /* TVAR_ash_pGAS[72]  */
	0x0F12001E, /* TVAR_ash_pGAS[73]  */
	0x0F120044, /* TVAR_ash_pGAS[74]  */
	0x0F120074, /* TVAR_ash_pGAS[75]  */
	0x0F1200B0, /* TVAR_ash_pGAS[76]  */
	0x0F1200EC, /* TVAR_ash_pGAS[77]  */
	0x0F1200EF, /* TVAR_ash_pGAS[78]  */
	0x0F1200B3, /* TVAR_ash_pGAS[79]  */
	0x0F12007A, /* TVAR_ash_pGAS[80]  */
	0x0F12004A, /* TVAR_ash_pGAS[81]  */
	0x0F120026, /* TVAR_ash_pGAS[82]  */
	0x0F120011, /* TVAR_ash_pGAS[83]  */
	0x0F12000A, /* TVAR_ash_pGAS[84]  */
	0x0F120011, /* TVAR_ash_pGAS[85]  */
	0x0F120029, /* TVAR_ash_pGAS[86]  */
	0x0F12004F, /* TVAR_ash_pGAS[87]  */
	0x0F120080, /* TVAR_ash_pGAS[88]  */
	0x0F1200BC, /* TVAR_ash_pGAS[89]  */
	0x0F1200F8, /* TVAR_ash_pGAS[90]  */
	0x0F120105, /* TVAR_ash_pGAS[91]  */
	0x0F1200C9, /* TVAR_ash_pGAS[92]  */
	0x0F12008F, /* TVAR_ash_pGAS[93]  */
	0x0F120060, /* TVAR_ash_pGAS[94]  */
	0x0F12003C, /* TVAR_ash_pGAS[95]  */
	0x0F120026, /* TVAR_ash_pGAS[96]  */
	0x0F12001F, /* TVAR_ash_pGAS[97]  */
	0x0F120028, /* TVAR_ash_pGAS[98]  */
	0x0F120040, /* TVAR_ash_pGAS[99]  */
	0x0F120066, /* TVAR_ash_pGAS[100] */
	0x0F120097, /* TVAR_ash_pGAS[101] */
	0x0F1200D4, /* TVAR_ash_pGAS[102] */
	0x0F120110, /* TVAR_ash_pGAS[103] */
	0x0F120124, /* TVAR_ash_pGAS[104] */
	0x0F1200EB, /* TVAR_ash_pGAS[105] */
	0x0F1200B1, /* TVAR_ash_pGAS[106] */
	0x0F120082, /* TVAR_ash_pGAS[107] */
	0x0F12005F, /* TVAR_ash_pGAS[108] */
	0x0F12004A, /* TVAR_ash_pGAS[109] */
	0x0F120043, /* TVAR_ash_pGAS[110] */
	0x0F12004C, /* TVAR_ash_pGAS[111] */
	0x0F120064, /* TVAR_ash_pGAS[112] */
	0x0F120089, /* TVAR_ash_pGAS[113] */
	0x0F1200BA, /* TVAR_ash_pGAS[114] */
	0x0F1200F8, /* TVAR_ash_pGAS[115] */
	0x0F12012F, /* TVAR_ash_pGAS[116] */
	0x0F120147, /* TVAR_ash_pGAS[117] */
	0x0F120116, /* TVAR_ash_pGAS[118] */
	0x0F1200DE, /* TVAR_ash_pGAS[119] */
	0x0F1200AF, /* TVAR_ash_pGAS[120] */
	0x0F12008E, /* TVAR_ash_pGAS[121] */
	0x0F12007A, /* TVAR_ash_pGAS[122] */
	0x0F120072, /* TVAR_ash_pGAS[123] */
	0x0F12007A, /* TVAR_ash_pGAS[124] */
	0x0F120091, /* TVAR_ash_pGAS[125] */
	0x0F1200B6, /* TVAR_ash_pGAS[126] */
	0x0F1200E8, /* TVAR_ash_pGAS[127] */
	0x0F120121, /* TVAR_ash_pGAS[128] */
	0x0F120150, /* TVAR_ash_pGAS[129] */
	0x0F120170, /* TVAR_ash_pGAS[130] */
	0x0F12013F, /* TVAR_ash_pGAS[131] */
	0x0F120110, /* TVAR_ash_pGAS[132] */
	0x0F1200E2, /* TVAR_ash_pGAS[133] */
	0x0F1200C0, /* TVAR_ash_pGAS[134] */
	0x0F1200AB, /* TVAR_ash_pGAS[135] */
	0x0F1200A4, /* TVAR_ash_pGAS[136] */
	0x0F1200AC, /* TVAR_ash_pGAS[137] */
	0x0F1200C3, /* TVAR_ash_pGAS[138] */
	0x0F1200E6, /* TVAR_ash_pGAS[139] */
	0x0F120117, /* TVAR_ash_pGAS[140] */
	0x0F120145, /* TVAR_ash_pGAS[141] */
	0x0F120172, /* TVAR_ash_pGAS[142] */
	0x0F120127, /* TVAR_ash_pGAS[143] */
	0x0F120100, /* TVAR_ash_pGAS[144] */
	0x0F1200CF, /* TVAR_ash_pGAS[145] */
	0x0F1200A7, /* TVAR_ash_pGAS[146] */
	0x0F12008D, /* TVAR_ash_pGAS[147] */
	0x0F12007D, /* TVAR_ash_pGAS[148] */
	0x0F120077, /* TVAR_ash_pGAS[149] */
	0x0F12007A, /* TVAR_ash_pGAS[150] */
	0x0F120087, /* TVAR_ash_pGAS[151] */
	0x0F12009E, /* TVAR_ash_pGAS[152] */
	0x0F1200C0, /* TVAR_ash_pGAS[153] */
	0x0F1200EC, /* TVAR_ash_pGAS[154] */
	0x0F12010F, /* TVAR_ash_pGAS[155] */
	0x0F120108, /* TVAR_ash_pGAS[156] */
	0x0F1200D8, /* TVAR_ash_pGAS[157] */
	0x0F1200A5, /* TVAR_ash_pGAS[158] */
	0x0F120080, /* TVAR_ash_pGAS[159] */
	0x0F120066, /* TVAR_ash_pGAS[160] */
	0x0F120056, /* TVAR_ash_pGAS[161] */
	0x0F12004F, /* TVAR_ash_pGAS[162] */
	0x0F120053, /* TVAR_ash_pGAS[163] */
	0x0F120061, /* TVAR_ash_pGAS[164] */
	0x0F120077, /* TVAR_ash_pGAS[165] */
	0x0F120098, /* TVAR_ash_pGAS[166] */
	0x0F1200C6, /* TVAR_ash_pGAS[167] */
	0x0F1200F3, /* TVAR_ash_pGAS[168] */
	0x0F1200E7, /* TVAR_ash_pGAS[169] */
	0x0F1200B4, /* TVAR_ash_pGAS[170] */
	0x0F120081, /* TVAR_ash_pGAS[171] */
	0x0F12005C, /* TVAR_ash_pGAS[172] */
	0x0F120041, /* TVAR_ash_pGAS[173] */
	0x0F120030, /* TVAR_ash_pGAS[174] */
	0x0F120029, /* TVAR_ash_pGAS[175] */
	0x0F12002E, /* TVAR_ash_pGAS[176] */
	0x0F12003D, /* TVAR_ash_pGAS[177] */
	0x0F120055, /* TVAR_ash_pGAS[178] */
	0x0F120076, /* TVAR_ash_pGAS[179] */
	0x0F1200A5, /* TVAR_ash_pGAS[180] */
	0x0F1200D4, /* TVAR_ash_pGAS[181] */
	0x0F1200CF, /* TVAR_ash_pGAS[182] */
	0x0F12009B, /* TVAR_ash_pGAS[183] */
	0x0F12006A, /* TVAR_ash_pGAS[184] */
	0x0F120043, /* TVAR_ash_pGAS[185] */
	0x0F120027, /* TVAR_ash_pGAS[186] */
	0x0F120016, /* TVAR_ash_pGAS[187] */
	0x0F12000F, /* TVAR_ash_pGAS[188] */
	0x0F120015, /* TVAR_ash_pGAS[189] */
	0x0F120025, /* TVAR_ash_pGAS[190] */
	0x0F12003E, /* TVAR_ash_pGAS[191] */
	0x0F120061, /* TVAR_ash_pGAS[192] */
	0x0F12008E, /* TVAR_ash_pGAS[193] */
	0x0F1200BF, /* TVAR_ash_pGAS[194] */
	0x0F1200C2, /* TVAR_ash_pGAS[195] */
	0x0F12008E, /* TVAR_ash_pGAS[196] */
	0x0F12005D, /* TVAR_ash_pGAS[197] */
	0x0F120037, /* TVAR_ash_pGAS[198] */
	0x0F12001A, /* TVAR_ash_pGAS[199] */
	0x0F120009, /* TVAR_ash_pGAS[200] */
	0x0F120002, /* TVAR_ash_pGAS[201] */
	0x0F120007, /* TVAR_ash_pGAS[202] */
	0x0F120018, /* TVAR_ash_pGAS[203] */
	0x0F120033, /* TVAR_ash_pGAS[204] */
	0x0F120057, /* TVAR_ash_pGAS[205] */
	0x0F120083, /* TVAR_ash_pGAS[206] */
	0x0F1200B3, /* TVAR_ash_pGAS[207] */
	0x0F1200BE, /* TVAR_ash_pGAS[208] */
	0x0F12008A, /* TVAR_ash_pGAS[209] */
	0x0F12005A, /* TVAR_ash_pGAS[210] */
	0x0F120034, /* TVAR_ash_pGAS[211] */
	0x0F120017, /* TVAR_ash_pGAS[212] */
	0x0F120006, /* TVAR_ash_pGAS[213] */
	0x0F120000, /* TVAR_ash_pGAS[214] */
	0x0F120006, /* TVAR_ash_pGAS[215] */
	0x0F120017, /* TVAR_ash_pGAS[216] */
	0x0F120033, /* TVAR_ash_pGAS[217] */
	0x0F120057, /* TVAR_ash_pGAS[218] */
	0x0F120083, /* TVAR_ash_pGAS[219] */
	0x0F1200B3, /* TVAR_ash_pGAS[220] */
	0x0F1200C5, /* TVAR_ash_pGAS[221] */
	0x0F120091, /* TVAR_ash_pGAS[222] */
	0x0F120061, /* TVAR_ash_pGAS[223] */
	0x0F12003B, /* TVAR_ash_pGAS[224] */
	0x0F120020, /* TVAR_ash_pGAS[225] */
	0x0F12000F, /* TVAR_ash_pGAS[226] */
	0x0F120009, /* TVAR_ash_pGAS[227] */
	0x0F120010, /* TVAR_ash_pGAS[228] */
	0x0F120021, /* TVAR_ash_pGAS[229] */
	0x0F12003D, /* TVAR_ash_pGAS[230] */
	0x0F120060, /* TVAR_ash_pGAS[231] */
	0x0F12008D, /* TVAR_ash_pGAS[232] */
	0x0F1200BE, /* TVAR_ash_pGAS[233] */
	0x0F1200D7, /* TVAR_ash_pGAS[234] */
	0x0F1200A2, /* TVAR_ash_pGAS[235] */
	0x0F120072, /* TVAR_ash_pGAS[236] */
	0x0F12004D, /* TVAR_ash_pGAS[237] */
	0x0F120032, /* TVAR_ash_pGAS[238] */
	0x0F120022, /* TVAR_ash_pGAS[239] */
	0x0F12001D, /* TVAR_ash_pGAS[240] */
	0x0F120024, /* TVAR_ash_pGAS[241] */
	0x0F120035, /* TVAR_ash_pGAS[242] */
	0x0F120050, /* TVAR_ash_pGAS[243] */
	0x0F120073, /* TVAR_ash_pGAS[244] */
	0x0F1200A0, /* TVAR_ash_pGAS[245] */
	0x0F1200D2, /* TVAR_ash_pGAS[246] */
	0x0F1200F0, /* TVAR_ash_pGAS[247] */
	0x0F1200BE, /* TVAR_ash_pGAS[248] */
	0x0F12008C, /* TVAR_ash_pGAS[249] */
	0x0F120068, /* TVAR_ash_pGAS[250] */
	0x0F12004F, /* TVAR_ash_pGAS[251] */
	0x0F120040, /* TVAR_ash_pGAS[252] */
	0x0F12003B, /* TVAR_ash_pGAS[253] */
	0x0F120041, /* TVAR_ash_pGAS[254] */
	0x0F120052, /* TVAR_ash_pGAS[255] */
	0x0F12006C, /* TVAR_ash_pGAS[256] */
	0x0F12008E, /* TVAR_ash_pGAS[257] */
	0x0F1200BE, /* TVAR_ash_pGAS[258] */
	0x0F1200ED, /* TVAR_ash_pGAS[259] */
	0x0F12010C, /* TVAR_ash_pGAS[260] */
	0x0F1200E1, /* TVAR_ash_pGAS[261] */
	0x0F1200AF, /* TVAR_ash_pGAS[262] */
	0x0F12008A, /* TVAR_ash_pGAS[263] */
	0x0F120072, /* TVAR_ash_pGAS[264] */
	0x0F120064, /* TVAR_ash_pGAS[265] */
	0x0F12005F, /* TVAR_ash_pGAS[266] */
	0x0F120065, /* TVAR_ash_pGAS[267] */
	0x0F120074, /* TVAR_ash_pGAS[268] */
	0x0F12008D, /* TVAR_ash_pGAS[269] */
	0x0F1200B2, /* TVAR_ash_pGAS[270] */
	0x0F1200E0, /* TVAR_ash_pGAS[271] */
	0x0F12010A, /* TVAR_ash_pGAS[272] */
	0x0F12012F, /* TVAR_ash_pGAS[273] */
	0x0F120104, /* TVAR_ash_pGAS[274] */
	0x0F1200D9, /* TVAR_ash_pGAS[275] */
	0x0F1200B3, /* TVAR_ash_pGAS[276] */
	0x0F120099, /* TVAR_ash_pGAS[277] */
	0x0F12008B, /* TVAR_ash_pGAS[278] */
	0x0F120086, /* TVAR_ash_pGAS[279] */
	0x0F12008B, /* TVAR_ash_pGAS[280] */
	0x0F12009B, /* TVAR_ash_pGAS[281] */
	0x0F1200B5, /* TVAR_ash_pGAS[282] */
	0x0F1200DA, /* TVAR_ash_pGAS[283] */
	0x0F120101, /* TVAR_ash_pGAS[284] */
	0x0F120128, /* TVAR_ash_pGAS[285] */
	0x0F12012F, /* TVAR_ash_pGAS[286] */
	0x0F120106, /* TVAR_ash_pGAS[287] */
	0x0F1200D4, /* TVAR_ash_pGAS[288] */
	0x0F1200AA, /* TVAR_ash_pGAS[289] */
	0x0F12008E, /* TVAR_ash_pGAS[290] */
	0x0F12007D, /* TVAR_ash_pGAS[291] */
	0x0F120079, /* TVAR_ash_pGAS[292] */
	0x0F120080, /* TVAR_ash_pGAS[293] */
	0x0F120093, /* TVAR_ash_pGAS[294] */
	0x0F1200B1, /* TVAR_ash_pGAS[295] */
	0x0F1200DC, /* TVAR_ash_pGAS[296] */
	0x0F12010C, /* TVAR_ash_pGAS[297] */
	0x0F120130, /* TVAR_ash_pGAS[298] */
	0x0F120112, /* TVAR_ash_pGAS[299] */
	0x0F1200E0, /* TVAR_ash_pGAS[300] */
	0x0F1200AB, /* TVAR_ash_pGAS[301] */
	0x0F120083, /* TVAR_ash_pGAS[302] */
	0x0F120067, /* TVAR_ash_pGAS[303] */
	0x0F120057, /* TVAR_ash_pGAS[304] */
	0x0F120051, /* TVAR_ash_pGAS[305] */
	0x0F120059, /* TVAR_ash_pGAS[306] */
	0x0F12006B, /* TVAR_ash_pGAS[307] */
	0x0F120089, /* TVAR_ash_pGAS[308] */
	0x0F1200B2, /* TVAR_ash_pGAS[309] */
	0x0F1200E5, /* TVAR_ash_pGAS[310] */
	0x0F120114, /* TVAR_ash_pGAS[311] */
	0x0F1200F2, /* TVAR_ash_pGAS[312] */
	0x0F1200BD, /* TVAR_ash_pGAS[313] */
	0x0F120088, /* TVAR_ash_pGAS[314] */
	0x0F120061, /* TVAR_ash_pGAS[315] */
	0x0F120044, /* TVAR_ash_pGAS[316] */
	0x0F120031, /* TVAR_ash_pGAS[317] */
	0x0F12002C, /* TVAR_ash_pGAS[318] */
	0x0F120033, /* TVAR_ash_pGAS[319] */
	0x0F120047, /* TVAR_ash_pGAS[320] */
	0x0F120065, /* TVAR_ash_pGAS[321] */
	0x0F12008C, /* TVAR_ash_pGAS[322] */
	0x0F1200C0, /* TVAR_ash_pGAS[323] */
	0x0F1200F3, /* TVAR_ash_pGAS[324] */
	0x0F1200DB, /* TVAR_ash_pGAS[325] */
	0x0F1200A5, /* TVAR_ash_pGAS[326] */
	0x0F120071, /* TVAR_ash_pGAS[327] */
	0x0F120049, /* TVAR_ash_pGAS[328] */
	0x0F12002A, /* TVAR_ash_pGAS[329] */
	0x0F120018, /* TVAR_ash_pGAS[330] */
	0x0F120011, /* TVAR_ash_pGAS[331] */
	0x0F120018, /* TVAR_ash_pGAS[332] */
	0x0F12002C, /* TVAR_ash_pGAS[333] */
	0x0F12004B, /* TVAR_ash_pGAS[334] */
	0x0F120072, /* TVAR_ash_pGAS[335] */
	0x0F1200A3, /* TVAR_ash_pGAS[336] */
	0x0F1200D7, /* TVAR_ash_pGAS[337] */
	0x0F1200CD, /* TVAR_ash_pGAS[338] */
	0x0F120097, /* TVAR_ash_pGAS[339] */
	0x0F120065, /* TVAR_ash_pGAS[340] */
	0x0F12003C, /* TVAR_ash_pGAS[341] */
	0x0F12001D, /* TVAR_ash_pGAS[342] */
	0x0F12000A, /* TVAR_ash_pGAS[343] */
	0x0F120003, /* TVAR_ash_pGAS[344] */
	0x0F120009, /* TVAR_ash_pGAS[345] */
	0x0F12001D, /* TVAR_ash_pGAS[346] */
	0x0F12003B, /* TVAR_ash_pGAS[347] */
	0x0F120063, /* TVAR_ash_pGAS[348] */
	0x0F120092, /* TVAR_ash_pGAS[349] */
	0x0F1200C4, /* TVAR_ash_pGAS[350] */
	0x0F1200CA, /* TVAR_ash_pGAS[351] */
	0x0F120094, /* TVAR_ash_pGAS[352] */
	0x0F120062, /* TVAR_ash_pGAS[353] */
	0x0F12003A, /* TVAR_ash_pGAS[354] */
	0x0F12001A, /* TVAR_ash_pGAS[355] */
	0x0F120007, /* TVAR_ash_pGAS[356] */
	0x0F120000, /* TVAR_ash_pGAS[357] */
	0x0F120006, /* TVAR_ash_pGAS[358] */
	0x0F120018, /* TVAR_ash_pGAS[359] */
	0x0F120036, /* TVAR_ash_pGAS[360] */
	0x0F12005C, /* TVAR_ash_pGAS[361] */
	0x0F12008A, /* TVAR_ash_pGAS[362] */
	0x0F1200BC, /* TVAR_ash_pGAS[363] */
	0x0F1200D1, /* TVAR_ash_pGAS[364] */
	0x0F12009B, /* TVAR_ash_pGAS[365] */
	0x0F120069, /* TVAR_ash_pGAS[366] */
	0x0F120042, /* TVAR_ash_pGAS[367] */
	0x0F120022, /* TVAR_ash_pGAS[368] */
	0x0F12000F, /* TVAR_ash_pGAS[369] */
	0x0F120008, /* TVAR_ash_pGAS[370] */
	0x0F12000D, /* TVAR_ash_pGAS[371] */
	0x0F12001F, /* TVAR_ash_pGAS[372] */
	0x0F12003B, /* TVAR_ash_pGAS[373] */
	0x0F120060, /* TVAR_ash_pGAS[374] */
	0x0F12008D, /* TVAR_ash_pGAS[375] */
	0x0F1200BF, /* TVAR_ash_pGAS[376] */
	0x0F1200E3, /* TVAR_ash_pGAS[377] */
	0x0F1200AC, /* TVAR_ash_pGAS[378] */
	0x0F12007A, /* TVAR_ash_pGAS[379] */
	0x0F120053, /* TVAR_ash_pGAS[380] */
	0x0F120035, /* TVAR_ash_pGAS[381] */
	0x0F120022, /* TVAR_ash_pGAS[382] */
	0x0F12001B, /* TVAR_ash_pGAS[383] */
	0x0F12001F, /* TVAR_ash_pGAS[384] */
	0x0F120030, /* TVAR_ash_pGAS[385] */
	0x0F12004B, /* TVAR_ash_pGAS[386] */
	0x0F12006D, /* TVAR_ash_pGAS[387] */
	0x0F12009C, /* TVAR_ash_pGAS[388] */
	0x0F1200CE, /* TVAR_ash_pGAS[389] */
	0x0F1200FE, /* TVAR_ash_pGAS[390] */
	0x0F1200C9, /* TVAR_ash_pGAS[391] */
	0x0F120095, /* TVAR_ash_pGAS[392] */
	0x0F12006F, /* TVAR_ash_pGAS[393] */
	0x0F120052, /* TVAR_ash_pGAS[394] */
	0x0F120040, /* TVAR_ash_pGAS[395] */
	0x0F120039, /* TVAR_ash_pGAS[396] */
	0x0F12003D, /* TVAR_ash_pGAS[397] */
	0x0F12004B, /* TVAR_ash_pGAS[398] */
	0x0F120063, /* TVAR_ash_pGAS[399] */
	0x0F120086, /* TVAR_ash_pGAS[400] */
	0x0F1200B5, /* TVAR_ash_pGAS[401] */
	0x0F1200E6, /* TVAR_ash_pGAS[402] */
	0x0F12011B, /* TVAR_ash_pGAS[403] */
	0x0F1200ED, /* TVAR_ash_pGAS[404] */
	0x0F1200BA, /* TVAR_ash_pGAS[405] */
	0x0F120092, /* TVAR_ash_pGAS[406] */
	0x0F120076, /* TVAR_ash_pGAS[407] */
	0x0F120065, /* TVAR_ash_pGAS[408] */
	0x0F12005D, /* TVAR_ash_pGAS[409] */
	0x0F120060, /* TVAR_ash_pGAS[410] */
	0x0F12006D, /* TVAR_ash_pGAS[411] */
	0x0F120084, /* TVAR_ash_pGAS[412] */
	0x0F1200A8, /* TVAR_ash_pGAS[413] */
	0x0F1200D6, /* TVAR_ash_pGAS[414] */
	0x0F120101, /* TVAR_ash_pGAS[415] */
	0x0F120140, /* TVAR_ash_pGAS[416] */
	0x0F120112, /* TVAR_ash_pGAS[417] */
	0x0F1200E5, /* TVAR_ash_pGAS[418] */
	0x0F1200BD, /* TVAR_ash_pGAS[419] */
	0x0F12009E, /* TVAR_ash_pGAS[420] */
	0x0F12008C, /* TVAR_ash_pGAS[421] */
	0x0F120085, /* TVAR_ash_pGAS[422] */
	0x0F120087, /* TVAR_ash_pGAS[423] */
	0x0F120094, /* TVAR_ash_pGAS[424] */
	0x0F1200AC, /* TVAR_ash_pGAS[425] */
	0x0F1200D0, /* TVAR_ash_pGAS[426] */
	0x0F1200F8, /* TVAR_ash_pGAS[427] */
	0x0F120123, /* TVAR_ash_pGAS[428] */
	0x0F1200F2, /* TVAR_ash_pGAS[429] */
	0x0F1200D1, /* TVAR_ash_pGAS[430] */
	0x0F1200A7, /* TVAR_ash_pGAS[431] */
	0x0F120087, /* TVAR_ash_pGAS[432] */
	0x0F120073, /* TVAR_ash_pGAS[433] */
	0x0F120067, /* TVAR_ash_pGAS[434] */
	0x0F120064, /* TVAR_ash_pGAS[435] */
	0x0F12006B, /* TVAR_ash_pGAS[436] */
	0x0F12007C, /* TVAR_ash_pGAS[437] */
	0x0F120094, /* TVAR_ash_pGAS[438] */
	0x0F1200B7, /* TVAR_ash_pGAS[439] */
	0x0F1200E1, /* TVAR_ash_pGAS[440] */
	0x0F1200FF, /* TVAR_ash_pGAS[441] */
	0x0F1200D6, /* TVAR_ash_pGAS[442] */
	0x0F1200AE, /* TVAR_ash_pGAS[443] */
	0x0F120085, /* TVAR_ash_pGAS[444] */
	0x0F120068, /* TVAR_ash_pGAS[445] */
	0x0F120054, /* TVAR_ash_pGAS[446] */
	0x0F120048, /* TVAR_ash_pGAS[447] */
	0x0F120045, /* TVAR_ash_pGAS[448] */
	0x0F12004B, /* TVAR_ash_pGAS[449] */
	0x0F12005B, /* TVAR_ash_pGAS[450] */
	0x0F120073, /* TVAR_ash_pGAS[451] */
	0x0F120093, /* TVAR_ash_pGAS[452] */
	0x0F1200BF, /* TVAR_ash_pGAS[453] */
	0x0F1200E9, /* TVAR_ash_pGAS[454] */
	0x0F1200B8, /* TVAR_ash_pGAS[455] */
	0x0F12008E, /* TVAR_ash_pGAS[456] */
	0x0F120066, /* TVAR_ash_pGAS[457] */
	0x0F120049, /* TVAR_ash_pGAS[458] */
	0x0F120035, /* TVAR_ash_pGAS[459] */
	0x0F120028, /* TVAR_ash_pGAS[460] */
	0x0F120025, /* TVAR_ash_pGAS[461] */
	0x0F12002B, /* TVAR_ash_pGAS[462] */
	0x0F12003B, /* TVAR_ash_pGAS[463] */
	0x0F120053, /* TVAR_ash_pGAS[464] */
	0x0F120072, /* TVAR_ash_pGAS[465] */
	0x0F12009D, /* TVAR_ash_pGAS[466] */
	0x0F1200C8, /* TVAR_ash_pGAS[467] */
	0x0F1200A2, /* TVAR_ash_pGAS[468] */
	0x0F120078, /* TVAR_ash_pGAS[469] */
	0x0F120051, /* TVAR_ash_pGAS[470] */
	0x0F120034, /* TVAR_ash_pGAS[471] */
	0x0F12001F, /* TVAR_ash_pGAS[472] */
	0x0F120012, /* TVAR_ash_pGAS[473] */
	0x0F12000E, /* TVAR_ash_pGAS[474] */
	0x0F120014, /* TVAR_ash_pGAS[475] */
	0x0F120024, /* TVAR_ash_pGAS[476] */
	0x0F12003B, /* TVAR_ash_pGAS[477] */
	0x0F12005B, /* TVAR_ash_pGAS[478] */
	0x0F120083, /* TVAR_ash_pGAS[479] */
	0x0F1200AD, /* TVAR_ash_pGAS[480] */
	0x0F120095, /* TVAR_ash_pGAS[481] */
	0x0F12006C, /* TVAR_ash_pGAS[482] */
	0x0F120046, /* TVAR_ash_pGAS[483] */
	0x0F12002A, /* TVAR_ash_pGAS[484] */
	0x0F120014, /* TVAR_ash_pGAS[485] */
	0x0F120007, /* TVAR_ash_pGAS[486] */
	0x0F120002, /* TVAR_ash_pGAS[487] */
	0x0F120008, /* TVAR_ash_pGAS[488] */
	0x0F120016, /* TVAR_ash_pGAS[489] */
	0x0F12002D, /* TVAR_ash_pGAS[490] */
	0x0F12004C, /* TVAR_ash_pGAS[491] */
	0x0F120072, /* TVAR_ash_pGAS[492] */
	0x0F12009B, /* TVAR_ash_pGAS[493] */
	0x0F120093, /* TVAR_ash_pGAS[494] */
	0x0F12006A, /* TVAR_ash_pGAS[495] */
	0x0F120045, /* TVAR_ash_pGAS[496] */
	0x0F120028, /* TVAR_ash_pGAS[497] */
	0x0F120013, /* TVAR_ash_pGAS[498] */
	0x0F120005, /* TVAR_ash_pGAS[499] */
	0x0F120000, /* TVAR_ash_pGAS[500] */
	0x0F120004, /* TVAR_ash_pGAS[501] */
	0x0F120012, /* TVAR_ash_pGAS[502] */
	0x0F120028, /* TVAR_ash_pGAS[503] */
	0x0F120045, /* TVAR_ash_pGAS[504] */
	0x0F12006A, /* TVAR_ash_pGAS[505] */
	0x0F120093, /* TVAR_ash_pGAS[506] */
	0x0F12009B, /* TVAR_ash_pGAS[507] */
	0x0F120071, /* TVAR_ash_pGAS[508] */
	0x0F12004C, /* TVAR_ash_pGAS[509] */
	0x0F120030, /* TVAR_ash_pGAS[510] */
	0x0F12001A, /* TVAR_ash_pGAS[511] */
	0x0F12000C, /* TVAR_ash_pGAS[512] */
	0x0F120007, /* TVAR_ash_pGAS[513] */
	0x0F12000B, /* TVAR_ash_pGAS[514] */
	0x0F120018, /* TVAR_ash_pGAS[515] */
	0x0F12002C, /* TVAR_ash_pGAS[516] */
	0x0F120048, /* TVAR_ash_pGAS[517] */
	0x0F12006D, /* TVAR_ash_pGAS[518] */
	0x0F120097, /* TVAR_ash_pGAS[519] */
	0x0F1200AE, /* TVAR_ash_pGAS[520] */
	0x0F120083, /* TVAR_ash_pGAS[521] */
	0x0F12005C, /* TVAR_ash_pGAS[522] */
	0x0F120040, /* TVAR_ash_pGAS[523] */
	0x0F12002B, /* TVAR_ash_pGAS[524] */
	0x0F12001E, /* TVAR_ash_pGAS[525] */
	0x0F120018, /* TVAR_ash_pGAS[526] */
	0x0F12001C, /* TVAR_ash_pGAS[527] */
	0x0F120027, /* TVAR_ash_pGAS[528] */
	0x0F12003A, /* TVAR_ash_pGAS[529] */
	0x0F120055, /* TVAR_ash_pGAS[530] */
	0x0F12007B, /* TVAR_ash_pGAS[531] */
	0x0F1200A6, /* TVAR_ash_pGAS[532] */
	0x0F1200CA, /* TVAR_ash_pGAS[533] */
	0x0F12009E, /* TVAR_ash_pGAS[534] */
	0x0F120076, /* TVAR_ash_pGAS[535] */
	0x0F120059, /* TVAR_ash_pGAS[536] */
	0x0F120046, /* TVAR_ash_pGAS[537] */
	0x0F120039, /* TVAR_ash_pGAS[538] */
	0x0F120033, /* TVAR_ash_pGAS[539] */
	0x0F120036, /* TVAR_ash_pGAS[540] */
	0x0F120040, /* TVAR_ash_pGAS[541] */
	0x0F120052, /* TVAR_ash_pGAS[542] */
	0x0F12006C, /* TVAR_ash_pGAS[543] */
	0x0F120094, /* TVAR_ash_pGAS[544] */
	0x0F1200BF, /* TVAR_ash_pGAS[545] */
	0x0F1200EB, /* TVAR_ash_pGAS[546] */
	0x0F1200C3, /* TVAR_ash_pGAS[547] */
	0x0F120099, /* TVAR_ash_pGAS[548] */
	0x0F12007A, /* TVAR_ash_pGAS[549] */
	0x0F120066, /* TVAR_ash_pGAS[550] */
	0x0F12005A, /* TVAR_ash_pGAS[551] */
	0x0F120054, /* TVAR_ash_pGAS[552] */
	0x0F120056, /* TVAR_ash_pGAS[553] */
	0x0F12005F, /* TVAR_ash_pGAS[554] */
	0x0F120071, /* TVAR_ash_pGAS[555] */
	0x0F12008D, /* TVAR_ash_pGAS[556] */
	0x0F1200B6, /* TVAR_ash_pGAS[557] */
	0x0F1200DE, /* TVAR_ash_pGAS[558] */
	0x0F12010D, /* TVAR_ash_pGAS[559] */
	0x0F1200E7, /* TVAR_ash_pGAS[560] */
	0x0F1200C1, /* TVAR_ash_pGAS[561] */
	0x0F1200A0, /* TVAR_ash_pGAS[562] */
	0x0F12008A, /* TVAR_ash_pGAS[563] */
	0x0F12007C, /* TVAR_ash_pGAS[564] */
	0x0F120076, /* TVAR_ash_pGAS[565] */
	0x0F120078, /* TVAR_ash_pGAS[566] */
	0x0F120081, /* TVAR_ash_pGAS[567] */
	0x0F120093, /* TVAR_ash_pGAS[568] */
	0x0F1200B1, /* TVAR_ash_pGAS[569] */
	0x0F1200D5, /* TVAR_ash_pGAS[570] */
	0x0F1200FD, /* TVAR_ash_pGAS[571] */

	/* Gamma */
	0x002A04CC,
	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[0][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[0][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[0][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[0][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[0][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[0][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[0][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[0][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[0][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[0][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[0][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[0][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[0][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[0][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[0][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[0][15] */

	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[1][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[1][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[1][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[1][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[1][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[1][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[1][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[1][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[1][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[1][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[1][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[1][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[1][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[1][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[1][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[1][15] */

	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[2][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[2][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[2][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[2][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[2][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[2][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[2][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[2][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[2][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[2][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[2][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[2][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[2][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[2][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[2][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[2][15] */


	/* Set AWB */
	0x002A0DA6,
	0x0F120000,
	0x0F120000,
	0x002A0E8C,
	0x0F120000,
	0x002A0D6C,
	0x0F120040,

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F12038F, /* awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F12039B, /* awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F120373, /* awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F120352, /* awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203B7, /* awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120334, /* awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203B5, /* awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120318, /* awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202FF, /* awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12038D, /* awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202E7, /* awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120372, /* awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202D0, /* awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12035D, /* awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202B5, /* awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120345, /* awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202A1, /* awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F120331, /* awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12028B, /* awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12031E, /* awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120309, /* awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F12025F, /* awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202F5, /* awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120250, /* awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202DB, /* awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F120241, /* awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202C7, /* awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F120233, /* awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202B9, /* awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120223, /* awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202AB, /* awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120217, /* awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F1202A2, /* awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120207, /* awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120294, /* awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201FA, /* awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120289, /* awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201EA, /* awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F120281, /* awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201DD, /* awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F12027B, /* awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201D0, /* awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201C3, /* awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12026A, /* awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201B6, /* awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F120265, /* awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201AB, /* awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F12025B, /* awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201A1, /* awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120254, /* awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120198, /* awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F12024B, /* awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120242, /* awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120191, /* awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F12023A, /* awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F1201C5, /* awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F1201DF, /* awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */


	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F120022,
	0x0F120000,
	0x0F12010F,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F12025E, /* 0264 awbb_OutdoorGrZones_m_BGrid_0__m_left    */
	0x0F120282, /* 0279 awbb_OutdoorGrZones_m_BGrid_0__m_right   */
	0x0F120240, /* 0250 awbb_OutdoorGrZones_m_BGrid_1__m_left    */
	0x0F120298, /* 0287 awbb_OutdoorGrZones_m_BGrid_1__m_right   */
	0x0F12022A, /* 0244 awbb_OutdoorGrZones_m_BGrid_2__m_left    */
	0x0F12029A, /* 0287 awbb_OutdoorGrZones_m_BGrid_2__m_right   */
	0x0F12021A, /* 0235 awbb_OutdoorGrZones_m_BGrid_3__m_left    */
	0x0F12029A, /* 0289 awbb_OutdoorGrZones_m_BGrid_3__m_right   */
	0x0F120206, /* 0225 awbb_OutdoorGrZones_m_BGrid_4__m_left    */
	0x0F120298, /* 0287 awbb_OutdoorGrZones_m_BGrid_4__m_right   */
	0x0F1201FE, /* 0213 awbb_OutdoorGrZones_m_BGrid_5__m_left    */
	0x0F12028C, /* 0286 awbb_OutdoorGrZones_m_BGrid_5__m_right   */
	0x0F1201FA, /* 0202 awbb_OutdoorGrZones_m_BGrid_6__m_left    */
	0x0F120278, /* 027A awbb_OutdoorGrZones_m_BGrid_6__m_right   */
	0x0F1201F8, /* 01F3 awbb_OutdoorGrZones_m_BGrid_7__m_left    */
	0x0F120266, /* 0272 awbb_OutdoorGrZones_m_BGrid_7__m_right   */
	0x0F120214, /* 01E9 awbb_OutdoorGrZones_m_BGrid_8__m_left    */
	0x0F120238, /* 0269 awbb_OutdoorGrZones_m_BGrid_8__m_right   */
	0x0F120000, /* 01E2 awbb_OutdoorGrZones_m_BGrid_9__m_left    */
	0x0F120000, /* 0263 awbb_OutdoorGrZones_m_BGrid_9__m_right   */
	0x0F120000, /* 01E0 awbb_OutdoorGrZones_m_BGrid_10__m_left   */
	0x0F120000, /* 025A awbb_OutdoorGrZones_m_BGrid_10__m_right  */
	0x0F120000, /* 01E1 awbb_OutdoorGrZones_m_BGrid_11__m_left   */
	0x0F120000, /* 0256 awbb_OutdoorGrZones_m_BGrid_11__m_right  */
	0x0F120000, /* 01EE awbb_OutdoorGrZones_m_BGrid_12__m_left   */
	0x0F120000, /* 0251 awbb_OutdoorGrZones_m_BGrid_12__m_right  */
	0x0F120000, /* 01F8 awbb_OutdoorGrZones_m_BGrid(26)          */
	0x0F120000, /* 024A awbb_OutdoorGrZones_m_BGrid(27)          */
	0x0F120000, /* 020D awbb_OutdoorGrZones_m_BGrid(28)          */
	0x0F120000, /* 0231 awbb_OutdoorGrZones_m_BGrid(29)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(30)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(31)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(32)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(33)          */


	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120210,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/*  7-3. Low Br grey zone                     */
	/* param_  C4start	awbb_LowBrGrZones_m_BGrid */

	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,



	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFE0, /* awbb_GridCorr_R_0__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_0__1_ */
	0x0F120000, /* awbb_GridCorr_R_0__2_ */
	0x0F120000, /* awbb_GridCorr_R_0__3_ */
	0x0F120000, /* awbb_GridCorr_R_0__4_ */
	0x0F120030, /* awbb_GridCorr_R_0__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_1__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_1__1_ */
	0x0F120000, /* awbb_GridCorr_R_1__2_ */
	0x0F120000, /* awbb_GridCorr_R_1__3_ */
	0x0F120000, /* awbb_GridCorr_R_1__4_ */
	0x0F120030, /* awbb_GridCorr_R_1__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_2__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_2__1_ */
	0x0F120000, /* awbb_GridCorr_R_2__2_ */
	0x0F120000, /* awbb_GridCorr_R_2__3_ */
	0x0F120000, /* awbb_GridCorr_R_2__4_ */
	0x0F120030, /* awbb_GridCorr_R_2__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_0__0_ */
	0x0F120000, /* awbb_GridCorr_B_0__1_ */
	0x0F120000, /* awbb_GridCorr_B_0__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_0__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_0__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_0__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_1__0_ */
	0x0F120000, /* awbb_GridCorr_B_1__1_ */
	0x0F120000, /* awbb_GridCorr_B_1__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_1__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_1__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_1__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_2__0_ */
	0x0F120000, /* awbb_GridCorr_B_2__1_ */
	0x0F120000, /* awbb_GridCorr_B_2__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_2__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_2__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_2__5_ */

	0x0F1202C6,
	0x0F120335,
	0x0F1203B3,
	0x0F121021,
	0x0F12107E,
	0x0F12113E,
	0x0F12117C,
	0x0F1211C2,
	0x0F12120B,

	0x0F1200B3,
	0x0F1200B7,
	0x0F1200D3,
	0x0F120091,

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,

	/* Gamut Thresholds */
	0x002A0DAE,
	0x0F120036,
	0x0F12001C,
	0x002A0DAA,
	0x0F12071A,
	0x0F1203A4,

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120BB8,
	0x0F120096,
	0x002A0E86,
	0x0F120216,
	0x0F12029F,
	0x002A0D96,
	0x0F120BB7,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F120459,
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,


	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120210, /* 258 awbb_GainsMaxMove */
	0x0F120003,


	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/* CCM */
	0x002A2800,
	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201FB,
	0x0F12FFA9,
	0x0F12FFEA,
	0x0F12013C,
	0x0F120140,
	0x0F12FF53,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF39,
	0x0F1201D6,
	0x0F1200C4,
	0x0F12FFC0,
	0x0F12FFBF,
	0x0F1201CD,
	0x0F120182,
	0x0F12FF91,
	0x0F1201AA,

	0x0F1201C5,
	0x0F12FF9F,
	0x0F12FFE5,
	0x0F1200E2,
	0x0F12010E,
	0x0F12FF62,
	0x0F12FF03,
	0x0F1201D0,
	0x0F12FF3E,
	0x0F12FF00,
	0x0F1201A6,
	0x0F1200BB,
	0x0F12FFBF,
	0x0F12FFDD,
	0x0F1201F6,
	0x0F1200CB,
	0x0F12FF94,
	0x0F12019E,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200E8,
	0x0F120126,
	0x0F12FF83,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF8A,
	0x0F1201F9,
	0x0F12005B,
	0x0F12FFCA,
	0x0F12FFA3,
	0x0F1201DA,
	0x0F120108,
	0x0F12FFB3,
	0x0F1201DD,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200F4,
	0x0F120139,
	0x0F12FF64,
	0x0F12FEEC,
	0x0F1201FD,
	0x0F12FF8E,
	0x0F12FEF4,
	0x0F1201BD,
	0x0F12010A,
	0x0F12FFA2,
	0x0F12FFDE,
	0x0F120208,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	/* Set NB */
	0x002A07EA,
	0x0F120000, /*afit_bUseNoiseInd 0 : NB 1: Noise Index */

	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */

	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,

	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120010, /* SATURATION                                                         */
	0x0F12FFE2, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F120028, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120344, /* UVDenoise_iYLowThresh                                              */
	0x0F12033A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120008, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120014, /* Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120064, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120114, /* UVDenoise_iYLowThresh                                              */
	0x0F12020A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000C, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120060, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12005A, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F12000A, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120000, /* UVDenoise_iYLowThresh                                              */
	0x0F120000, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F1200FF,
	0x0F1200FF,
	0x0F120800,
	0x0F120600,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120300,
	0x0F120002,
	0x0F120400,
	0x0F120106,
	0x0F120005,
	0x0F120000,
	0x0F120703,
	0x0F120000,
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */

	0x0028D000,
	0x002AB0CC,
	0x0F12000B, /* Non contious mode */
	/* Recording 25fps Anti-Flicker 60Hz END of Initial */
};

static const u32 s5k5bafx_recording_50Hz_common[] = {

	/* recording 25fps Anti-Flicker 50Hz*/

	0xFCFCD000,

	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* p100	Delay */


	/* Trap and Patch  2008-11-18 10:15:41 */
	0x00287000,
	0x002A1668,
	0x0F12B5FE,
	0x0F120007,
	0x0F12683C,
	0x0F12687E,
	0x0F121DA5,
	0x0F1288A0,
	0x0F122800,
	0x0F12D00B,
	0x0F1288A8,
	0x0F122800,
	0x0F12D008,
	0x0F128820,
	0x0F128829,
	0x0F124288,
	0x0F12D301,
	0x0F121A40,
	0x0F12E000,
	0x0F121A08,
	0x0F129001,
	0x0F12E001,
	0x0F122019,
	0x0F129001,
	0x0F124916,
	0x0F12466B,
	0x0F128A48,
	0x0F128118,
	0x0F128A88,
	0x0F128158,
	0x0F124814,
	0x0F128940,
	0x0F120040,
	0x0F122103,
	0x0F12F000,
	0x0F12F826,
	0x0F1288A1,
	0x0F124288,
	0x0F12D908,
	0x0F128828,
	0x0F128030,
	0x0F128868,
	0x0F128070,
	0x0F1288A8,
	0x0F126038,
	0x0F12BCFE,
	0x0F12BC08,
	0x0F124718,
	0x0F1288A9,
	0x0F124288,
	0x0F12D906,
	0x0F128820,
	0x0F128030,
	0x0F128860,
	0x0F128070,
	0x0F1288A0,
	0x0F126038,
	0x0F12E7F2,
	0x0F129801,
	0x0F12A902,
	0x0F12F000,
	0x0F12F812,
	0x0F120033,
	0x0F120029,
	0x0F129A02,
	0x0F120020,
	0x0F12F000,
	0x0F12F814,
	0x0F126038,
	0x0F12E7E6,
	0x0F121A28,
	0x0F127000,
	0x0F120D64,
	0x0F127000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F126009,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12622F,
	0x0F120000,
	0x002A2080,
	0x0F12B510,
	0x0F12F000,
	0x0F12F8F4,
	0x0F12BC10,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F0,
	0x0F12B08B,
	0x0F120006,
	0x0F122000,
	0x0F129004,
	0x0F126835,
	0x0F126874,
	0x0F1268B0,
	0x0F12900A,
	0x0F1268F0,
	0x0F129009,
	0x0F124F7D,
	0x0F128979,
	0x0F12084A,
	0x0F1288A8,
	0x0F1288A3,
	0x0F124298,
	0x0F12D300,
	0x0F120018,
	0x0F12F000,
	0x0F12F907,
	0x0F129007,
	0x0F120021,
	0x0F120028,
	0x0F12AA04,
	0x0F12F000,
	0x0F12F909,
	0x0F129006,
	0x0F1288A8,
	0x0F122800,
	0x0F12D102,
	0x0F1227FF,
	0x0F121C7F,
	0x0F12E047,
	0x0F1288A0,
	0x0F122800,
	0x0F12D101,
	0x0F122700,
	0x0F12E042,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12F000,
	0x0F12F8F8,
	0x0F129008,
	0x0F128ABA,
	0x0F129808,
	0x0F12466B,
	0x0F124342,
	0x0F129202,
	0x0F128820,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8EA,
	0x0F129A02,
	0x0F1217D1,
	0x0F120E09,
	0x0F121889,
	0x0F121209,
	0x0F124288,
	0x0F12DD1F,
	0x0F128820,
	0x0F12466B,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F12980A,
	0x0F129903,
	0x0F12F000,
	0x0F12F8DA,
	0x0F129001,
	0x0F128828,
	0x0F12466B,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12980A,
	0x0F129902,
	0x0F12F000,
	0x0F12F8D0,
	0x0F128AB9,
	0x0F129A08,
	0x0F124351,
	0x0F1217CA,
	0x0F120E12,
	0x0F121851,
	0x0F12120A,
	0x0F129901,
	0x0F12F000,
	0x0F12F8B6,
	0x0F120407,
	0x0F120C3F,
	0x0F12E000,
	0x0F122700,
	0x0F128820,
	0x0F12466B,
	0x0F12AA05,
	0x0F128198,
	0x0F128860,
	0x0F1281D8,
	0x0F128828,
	0x0F128118,
	0x0F128868,
	0x0F128158,
	0x0F12A802,
	0x0F12C803,
	0x0F12003B,
	0x0F12F000,
	0x0F12F8BB,
	0x0F1288A1,
	0x0F1288A8,
	0x0F12003A,
	0x0F12F000,
	0x0F12F8BE,
	0x0F120004,
	0x0F12A804,
	0x0F12C803,
	0x0F129A09,
	0x0F129B07,
	0x0F12F000,
	0x0F12F8AF,
	0x0F12A806,
	0x0F12C805,
	0x0F120021,
	0x0F12F000,
	0x0F12F8B2,
	0x0F126030,
	0x0F12B00B,
	0x0F12BCF0,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F1,
	0x0F129900,
	0x0F12680C,
	0x0F12493A,
	0x0F12694B,
	0x0F12698A,
	0x0F124694,
	0x0F1269CD,
	0x0F126A0E,
	0x0F124F38,
	0x0F1242BC,
	0x0F12D800,
	0x0F120027,
	0x0F124937,
	0x0F126B89,
	0x0F120409,
	0x0F120C09,
	0x0F124A35,
	0x0F121E92,
	0x0F126BD2,
	0x0F120412,
	0x0F120C12,
	0x0F12429F,
	0x0F12D801,
	0x0F120020,
	0x0F12E031,
	0x0F12001F,
	0x0F12434F,
	0x0F120A3F,
	0x0F1242A7,
	0x0F12D301,
	0x0F120018,
	0x0F12E02A,
	0x0F12002B,
	0x0F12434B,
	0x0F120A1B,
	0x0F1242A3,
	0x0F12D303,
	0x0F120220,
	0x0F12F000,
	0x0F12F88C,
	0x0F12E021,
	0x0F120029,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D301,
	0x0F120028,
	0x0F12E01A,
	0x0F120031,
	0x0F124351,
	0x0F120A09,
	0x0F1242A1,
	0x0F12D304,
	0x0F120220,
	0x0F120011,
	0x0F12F000,
	0x0F12F87B,
	0x0F12E010,
	0x0F12491E,
	0x0F128C89,
	0x0F12000A,
	0x0F124372,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D301,
	0x0F120030,
	0x0F12E007,
	0x0F124662,
	0x0F12434A,
	0x0F120A12,
	0x0F1242A2,
	0x0F12D302,
	0x0F120220,
	0x0F12F000,
	0x0F12F869,
	0x0F124B16,
	0x0F124D18,
	0x0F128D99,
	0x0F121FCA,
	0x0F123AF9,
	0x0F12D00A,
	0x0F122001,
	0x0F120240,
	0x0F128468,
	0x0F120220,
	0x0F12F000,
	0x0F12F85D,
	0x0F129900,
	0x0F126008,
	0x0F12BCF8,
	0x0F12BC08,
	0x0F124718,
	0x0F128D19,
	0x0F128469,
	0x0F129900,
	0x0F126008,
	0x0F12E7F7,
	0x0F12B570,
	0x0F122200,
	0x0F12490E,
	0x0F12480E,
	0x0F122401,
	0x0F12F000,
	0x0F12F852,
	0x0F120022,
	0x0F12490D,
	0x0F12480D,
	0x0F122502,
	0x0F12F000,
	0x0F12F84C,
	0x0F12490C,
	0x0F12480D,
	0x0F12002A,
	0x0F12F000,
	0x0F12F847,
	0x0F12BC70,
	0x0F12BC08,
	0x0F124718,
	0x0F120D64,
	0x0F127000,
	0x0F120470,
	0x0F127000,
	0x0F12A120,
	0x0F120007,
	0x0F120402,
	0x0F127000,
	0x0F1214A0,
	0x0F127000,
	0x0F12208D,
	0x0F127000,
	0x0F12622F,
	0x0F120000,
	0x0F121669,
	0x0F127000,
	0x0F126445,
	0x0F120000,
	0x0F1221AB,
	0x0F127000,
	0x0F122AA9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125F49,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FC7,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125457,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F125FA3,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F1251F9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F12A464,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A007,
	0x0F120000,
	0x0F126546,
	0x0F122062,
	0x0F123120,
	0x0F123220,
	0x0F123130,
	0x0F120030,
	0x0F12E010,
	0x0F120208,
	0x0F120058,
	0x0F120000,
	/* End of Trap and Patch (Last : 70002342h) */
	/* Total Size 896 (0x0380)                  */


	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0, /* setot_uOnlineClocksDiv40             */
	0x002A0AE2,
	0x0F12222E, /* setot_usSetRomWaitStateThreshold4KHz */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */


	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,


	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,

	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,
	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,
	0x0F120015,
	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,


	0x002AF900,
	0x0F120067,


	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,

	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,

	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,

	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,

	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,

	0x002AF4D6,
	0x0F120090,


	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,

	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,

	/* sensor aig table setting */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,


	0x002A1084,
	0x0F120000,
	0x0F120000,

	/* Set AE Target */
	0x002A0F4C,
	0x0F12003A, /* TVAR_ae_BrAve */

	0x002A0478,
	0x0F120114,
	0x0F1200EB, /* ae boundary */



	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A, /* uMaxExp1 */
	0x0F120000,
	0x002A048C,
	0x0F128214, /* uMaxExp2 */
	0x0F120000,
	0x0F12A122, /* uMaxExp3 */
	0x0F120000,
	0x002A0488,
	0x0F12f424, /* uMaxExp4 */
	0x0F120000,
	0x002A043A,
	0x0F1201D0, /* lt_uMaxAnGain0   */
	0x0F1201E0, /* lt_uMaxAnGain0_1 */
	0x002A0494,
	0x0F120300, /* lt_uMaxAnGain1 */
	0x0F120650, /* lt_uMaxAnGain2 */
	0x0f120100,
	0x002A0F52,
	0x0F12000F, /* ae_StatMode */

	0x002A0E98, /* bp_uMaxBrightnessFactor */
	0x0F1202A8,
	0x002A0E9E, /* bp_uMinBrightnessFactor */
	0x0F120298,

	/* 1. Auto Flicker 50Hz Start */
	0x002A0B2E,
	0x0F120000, /* AFC_Default60Hz	 Auto Flicker 60Hz start 0: Auto Flicker 50Hz start */
	0x002A03F8,
	0x0F12005F, /* REG_TC_DBG_AutoAlgEnBits   default : 007F */


	0xffff000a, /* p10	Wait10mSec */

	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0, /* REG_TC_IPRM_InClockLSBs */
	0x0F120000, /* REG_TC_IPRM_InClockMSBs */

	/* Parallel or MIPI Selection */
	0x002A01C6,
	0x0F120001, /* REG_TC_IPRM_UseNPviClocks         */
	0x0F120001, /* REG_TC_IPRM_UseNMipiClocks        */
	0x0F120000, /* REG_TC_IPRM_bBlockInternalPllCalc */

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770, /* REG_TC_IPRM_OpClk4KHz_0      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_0 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_0 */

	/* System Clock 1 (System : 48Mhz, PCLK : 48Mhz) */
	0x002A01D2,
	0x0F122EE0, /* REG_TC_IPRM_OpClk4KHz_1      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_1 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_1 */



	0x002A01DE,
	0x0F120001, /* REG_TC_IPRM_UseRegsAPI        */
	0x0F120001, /* REG_TC_IPRM_InitParamsUpdated */
	0xffff0064, /* p100                          */



	/* Crop */
	0x002A01FA,
	0x0F120640, /* REG_TC_GP_PrevReqInputWidth  */
	0x0F1204B0, /* REG_TC_GP_PrevReqInputHeight */
	0x0F120000, /* REG_TC_GP_PrevInputWidthOfs  */
	0x0F120000, /* REG_TC_GP_PrevInputHeightOfs */


	/* Set Preview Config */
	/* Preview Config 0 (VGA fixed 30fps) */
	0x002A0242,
	0x0F120280, /* REG_0TC_PCFG_usWidth                */
	0x0F1201E0, /* REG_0TC_PCFG_usHeight               */
	0x0F120005, /* REG_0TC_PCFG_Format                 */
	0x0F122EE0, /* REG_0TC_PCFG_usMaxOut4KHzRate       */
	0x0F122EE0, /* REG_0TC_PCFG_usMinOut4KHzRate       */
	0x0F120052, /* REG_0TC_PCFG_PVIMask                */
	0x0F120001, /* REG_0TC_PCFG_uClockInd              */
	0x0F120002, /* REG_0TC_PCFG_usFrTimeType           */
	0x0F120001, /* REG_0TC_PCFG_FrRateQualityType      */
	0x0F12018c, /* REG_0TC_PCFG_usMaxFrTimeMsecMult10  */
	0x0F12018c, /* REG_0TC_PCFG_usMinFrTimeMsecMult10  */
	0x0F120000, /* REG_0TC_PCFG_sSaturation            */
	0x0F120000, /* REG_0TC_PCFG_sSharpBlur             */
	0x0F120000, /* REG_0TC_PCFG_sGlamour               */
	0x0F120000, /* REG_0TC_PCFG_sColorTemp             */
	0x0F120000, /* REG_0TC_PCFG_uDeviceGammaIndex      */
	0x0F120000, /* REG_0TC_PCFG_uPrevMirror            */
	0x0F120000, /* REG_0TC_PCFG_uCaptureMirror         */
	0x0F120000, /* REG_0TC_PCFG_uRotation              */

	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280, /* REG_1TC_PCFG_usWidth                */
	0x0F1201E0, /* REG_1TC_PCFG_usHeight               */
	0x0F120005, /* REG_1TC_PCFG_Format                 */
	0x0F122EE0, /* REG_1TC_PCFG_usMaxOut4KHzRate       */
	0x0F122EE0, /* REG_1TC_PCFG_usMinOut4KHzRate       */
	0x0F120052, /* REG_1TC_PCFG_PVIMask                */
	0x0F120001, /* REG_1TC_PCFG_uClockInd              */
	0x0F120000, /* REG_1TC_PCFG_usFrTimeType           */
	0x0F120000, /* REG_1TC_PCFG_FrRateQualityType      */
	0x0F12029A, /* REG_1TC_PCFG_usMaxFrTimeMsecMult10  */
	0x0F12014D, /* REG_1TC_PCFG_usMinFrTimeMsecMult10  */
	0x0F120000, /* REG_1TC_PCFG_sSaturation            */
	0x0F120000, /* REG_1TC_PCFG_sSharpBlur             */
	0x0F120000, /* REG_1TC_PCFG_sGlamour               */
	0x0F120000, /* REG_1TC_PCFG_sColorTemp             */
	0x0F120000, /* REG_1TC_PCFG_uDeviceGammaIndex      */
	0x0F120000, /* REG_1TC_PCFG_uPrevMirror            */
	0x0F120000, /* REG_1TC_PCFG_uCaptureMirror         */
	0x0F120000, /* REG_1TC_PCFG_uRotation              */


	/* Set MIPI */
	0x002A03AC,
	0x0F120000, /* REG_TC_FLS_Mode        */
	0x002A03F2,
	0x0F120001, /* REG_TC_OIF_EnMipiLanes */
	0x0F1200C3, /* REG_TC_OIF_EnPackets   */
	0x0F120001, /* REG_TC_OIF_CfgChanged  */

	/* Apply preview config */
	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */



	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000, /* REG_0TC_CCFG_uCaptureMode          */
	0x0F120640, /* REG_0TC_CCFG_usWidth               */
	0x0F1204B0, /* REG_0TC_CCFG_usHeight              */
	0x0F120005, /* REG_0TC_CCFG_Format                */
	0x0F122EE0, /* REG_0TC_CCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_CCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_CCFG_PVIMask               */
	0x0F120001, /* REG_0TC_CCFG_uClockInd             */
	0x0F120002, /* REG_0TC_CCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_CCFG_FrRateQualityType     */
	0x0F1204E2, /* REG_0TC_CCFG_usMaxFrTimeMsecMult10 */
	0x0F1204E2, /* REG_0TC_CCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_CCFG_sSaturation           */
	0x0F120000, /* REG_0TC_CCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_CCFG_sGlamour              */
	0x0F120000, /* REG_0TC_CCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_CCFG_uDeviceGammaIndex     */



	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A07C0,
	0x0F120004,
	0x0F120004,

	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,


	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000, /* ae_WeightTbl_16_0_ */
	0x0F120000, /* ae_WeightTbl_16_1_ */
	0x0F120000, /* ae_WeightTbl_16_2_ */
	0x0F120000, /* ae_WeightTbl_16_3_ */
	0x0F120101, /* ae_WeightTbl_16_4_ */
	0x0F120101, /* ae_WeightTbl_16_5_ */
	0x0F120101, /* ae_WeightTbl_16_6_ */
	0x0F120101, /* ae_WeightTbl_16_7_ */
	0x0F120101, /* ae_WeightTbl_16_8_ */
	0x0F120302, /* ae_WeightTbl_16_9_ */
	0x0F120203, /* ae_WeightTbl_16_10 */
	0x0F120101, /* ae_WeightTbl_16_11 */
	0x0F120101, /* ae_WeightTbl_16_12 */
	0x0F120403, /* ae_WeightTbl_16_13 */
	0x0F120304, /* ae_WeightTbl_16_14 */
	0x0F120101, /* ae_WeightTbl_16_15 */
	0x0F120101, /* ae_WeightTbl_16_16 */
	0x0F120403, /* ae_WeightTbl_16_17 */
	0x0F120304, /* ae_WeightTbl_16_18 */
	0x0F120101, /* ae_WeightTbl_16_19 */
	0x0F120101, /* ae_WeightTbl_16_20 */
	0x0F120302, /* ae_WeightTbl_16_21 */
	0x0F120203, /* ae_WeightTbl_16_22 */
	0x0F120101, /* ae_WeightTbl_16_23 */
	0x0F120101, /* ae_WeightTbl_16_24 */
	0x0F120101, /* ae_WeightTbl_16_25 */
	0x0F120101, /* ae_WeightTbl_16_26 */
	0x0F120101, /* ae_WeightTbl_16_27 */
	0x0F120000, /* ae_WeightTbl_16_28 */
	0x0F120000, /* ae_WeightTbl_16_29 */
	0x0F120000, /* ae_WeightTbl_16_30 */
	0x0F120000, /* ae_WeightTbl_16_31 */


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,

	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,

	/* Target Brightness Control */
	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,

	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */

	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */

	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */

	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */

	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */

	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */

	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */

	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120108, /* 100 TVAR_ash_GASOutdoorAlpha_0_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_*/

	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,

	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120160, /* TVAR_ash_pGAS[0]   */
	0x0F120134, /* TVAR_ash_pGAS[1]   */
	0x0F1200FF, /* TVAR_ash_pGAS[2]   */
	0x0F1200D1, /* TVAR_ash_pGAS[3]   */
	0x0F1200B1, /* TVAR_ash_pGAS[4]   */
	0x0F12009D, /* TVAR_ash_pGAS[5]   */
	0x0F120096, /* TVAR_ash_pGAS[6]   */
	0x0F12009E, /* TVAR_ash_pGAS[7]   */
	0x0F1200B3, /* TVAR_ash_pGAS[8]   */
	0x0F1200D3, /* TVAR_ash_pGAS[9]   */
	0x0F1200FF, /* TVAR_ash_pGAS[10]  */
	0x0F120131, /* TVAR_ash_pGAS[11]  */
	0x0F120159, /* TVAR_ash_pGAS[12]  */
	0x0F12013C, /* TVAR_ash_pGAS[13]  */
	0x0F120107, /* TVAR_ash_pGAS[14]  */
	0x0F1200CD, /* TVAR_ash_pGAS[15]  */
	0x0F1200A1, /* TVAR_ash_pGAS[16]  */
	0x0F120080, /* TVAR_ash_pGAS[17]  */
	0x0F12006B, /* TVAR_ash_pGAS[18]  */
	0x0F120064, /* TVAR_ash_pGAS[19]  */
	0x0F12006C, /* TVAR_ash_pGAS[20]  */
	0x0F120080, /* TVAR_ash_pGAS[21]  */
	0x0F1200A1, /* TVAR_ash_pGAS[22]  */
	0x0F1200CD, /* TVAR_ash_pGAS[23]  */
	0x0F120106, /* TVAR_ash_pGAS[24]  */
	0x0F120139, /* TVAR_ash_pGAS[25]  */
	0x0F120116, /* TVAR_ash_pGAS[26]  */
	0x0F1200DC, /* TVAR_ash_pGAS[27]  */
	0x0F1200A2, /* TVAR_ash_pGAS[28]  */
	0x0F120073, /* TVAR_ash_pGAS[29]  */
	0x0F120051, /* TVAR_ash_pGAS[30]  */
	0x0F12003B, /* TVAR_ash_pGAS[31]  */
	0x0F120033, /* TVAR_ash_pGAS[32]  */
	0x0F12003B, /* TVAR_ash_pGAS[33]  */
	0x0F120050, /* TVAR_ash_pGAS[34]  */
	0x0F120073, /* TVAR_ash_pGAS[35]  */
	0x0F1200A2, /* TVAR_ash_pGAS[36]  */
	0x0F1200DD, /* TVAR_ash_pGAS[37]  */
	0x0F120115, /* TVAR_ash_pGAS[38]  */
	0x0F1200FA, /* TVAR_ash_pGAS[39]  */
	0x0F1200BF, /* TVAR_ash_pGAS[40]  */
	0x0F120085, /* TVAR_ash_pGAS[41]  */
	0x0F120055, /* TVAR_ash_pGAS[42]  */
	0x0F120031, /* TVAR_ash_pGAS[43]  */
	0x0F12001B, /* TVAR_ash_pGAS[44]  */
	0x0F120014, /* TVAR_ash_pGAS[45]  */
	0x0F12001A, /* TVAR_ash_pGAS[46]  */
	0x0F120031, /* TVAR_ash_pGAS[47]  */
	0x0F120055, /* TVAR_ash_pGAS[48]  */
	0x0F120085, /* TVAR_ash_pGAS[49]  */
	0x0F1200C0, /* TVAR_ash_pGAS[50]  */
	0x0F1200FB, /* TVAR_ash_pGAS[51]  */
	0x0F1200EA, /* TVAR_ash_pGAS[52]  */
	0x0F1200AF, /* TVAR_ash_pGAS[53]  */
	0x0F120074, /* TVAR_ash_pGAS[54]  */
	0x0F120045, /* TVAR_ash_pGAS[55]  */
	0x0F120020, /* TVAR_ash_pGAS[56]  */
	0x0F12000B, /* TVAR_ash_pGAS[57]  */
	0x0F120003, /* TVAR_ash_pGAS[58]  */
	0x0F12000A, /* TVAR_ash_pGAS[59]  */
	0x0F120020, /* TVAR_ash_pGAS[60]  */
	0x0F120046, /* TVAR_ash_pGAS[61]  */
	0x0F120076, /* TVAR_ash_pGAS[62]  */
	0x0F1200B1, /* TVAR_ash_pGAS[63]  */
	0x0F1200ED, /* TVAR_ash_pGAS[64]  */
	0x0F1200E6, /* TVAR_ash_pGAS[65]  */
	0x0F1200AA, /* TVAR_ash_pGAS[66]  */
	0x0F120071, /* TVAR_ash_pGAS[67]  */
	0x0F120041, /* TVAR_ash_pGAS[68]  */
	0x0F12001D, /* TVAR_ash_pGAS[69]  */
	0x0F120008, /* TVAR_ash_pGAS[70]  */
	0x0F120000, /* TVAR_ash_pGAS[71]  */
	0x0F120007, /* TVAR_ash_pGAS[72]  */
	0x0F12001E, /* TVAR_ash_pGAS[73]  */
	0x0F120044, /* TVAR_ash_pGAS[74]  */
	0x0F120074, /* TVAR_ash_pGAS[75]  */
	0x0F1200B0, /* TVAR_ash_pGAS[76]  */
	0x0F1200EC, /* TVAR_ash_pGAS[77]  */
	0x0F1200EF, /* TVAR_ash_pGAS[78]  */
	0x0F1200B3, /* TVAR_ash_pGAS[79]  */
	0x0F12007A, /* TVAR_ash_pGAS[80]  */
	0x0F12004A, /* TVAR_ash_pGAS[81]  */
	0x0F120026, /* TVAR_ash_pGAS[82]  */
	0x0F120011, /* TVAR_ash_pGAS[83]  */
	0x0F12000A, /* TVAR_ash_pGAS[84]  */
	0x0F120011, /* TVAR_ash_pGAS[85]  */
	0x0F120029, /* TVAR_ash_pGAS[86]  */
	0x0F12004F, /* TVAR_ash_pGAS[87]  */
	0x0F120080, /* TVAR_ash_pGAS[88]  */
	0x0F1200BC, /* TVAR_ash_pGAS[89]  */
	0x0F1200F8, /* TVAR_ash_pGAS[90]  */
	0x0F120105, /* TVAR_ash_pGAS[91]  */
	0x0F1200C9, /* TVAR_ash_pGAS[92]  */
	0x0F12008F, /* TVAR_ash_pGAS[93]  */
	0x0F120060, /* TVAR_ash_pGAS[94]  */
	0x0F12003C, /* TVAR_ash_pGAS[95]  */
	0x0F120026, /* TVAR_ash_pGAS[96]  */
	0x0F12001F, /* TVAR_ash_pGAS[97]  */
	0x0F120028, /* TVAR_ash_pGAS[98]  */
	0x0F120040, /* TVAR_ash_pGAS[99]  */
	0x0F120066, /* TVAR_ash_pGAS[100] */
	0x0F120097, /* TVAR_ash_pGAS[101] */
	0x0F1200D4, /* TVAR_ash_pGAS[102] */
	0x0F120110, /* TVAR_ash_pGAS[103] */
	0x0F120124, /* TVAR_ash_pGAS[104] */
	0x0F1200EB, /* TVAR_ash_pGAS[105] */
	0x0F1200B1, /* TVAR_ash_pGAS[106] */
	0x0F120082, /* TVAR_ash_pGAS[107] */
	0x0F12005F, /* TVAR_ash_pGAS[108] */
	0x0F12004A, /* TVAR_ash_pGAS[109] */
	0x0F120043, /* TVAR_ash_pGAS[110] */
	0x0F12004C, /* TVAR_ash_pGAS[111] */
	0x0F120064, /* TVAR_ash_pGAS[112] */
	0x0F120089, /* TVAR_ash_pGAS[113] */
	0x0F1200BA, /* TVAR_ash_pGAS[114] */
	0x0F1200F8, /* TVAR_ash_pGAS[115] */
	0x0F12012F, /* TVAR_ash_pGAS[116] */
	0x0F120147, /* TVAR_ash_pGAS[117] */
	0x0F120116, /* TVAR_ash_pGAS[118] */
	0x0F1200DE, /* TVAR_ash_pGAS[119] */
	0x0F1200AF, /* TVAR_ash_pGAS[120] */
	0x0F12008E, /* TVAR_ash_pGAS[121] */
	0x0F12007A, /* TVAR_ash_pGAS[122] */
	0x0F120072, /* TVAR_ash_pGAS[123] */
	0x0F12007A, /* TVAR_ash_pGAS[124] */
	0x0F120091, /* TVAR_ash_pGAS[125] */
	0x0F1200B6, /* TVAR_ash_pGAS[126] */
	0x0F1200E8, /* TVAR_ash_pGAS[127] */
	0x0F120121, /* TVAR_ash_pGAS[128] */
	0x0F120150, /* TVAR_ash_pGAS[129] */
	0x0F120170, /* TVAR_ash_pGAS[130] */
	0x0F12013F, /* TVAR_ash_pGAS[131] */
	0x0F120110, /* TVAR_ash_pGAS[132] */
	0x0F1200E2, /* TVAR_ash_pGAS[133] */
	0x0F1200C0, /* TVAR_ash_pGAS[134] */
	0x0F1200AB, /* TVAR_ash_pGAS[135] */
	0x0F1200A4, /* TVAR_ash_pGAS[136] */
	0x0F1200AC, /* TVAR_ash_pGAS[137] */
	0x0F1200C3, /* TVAR_ash_pGAS[138] */
	0x0F1200E6, /* TVAR_ash_pGAS[139] */
	0x0F120117, /* TVAR_ash_pGAS[140] */
	0x0F120145, /* TVAR_ash_pGAS[141] */
	0x0F120172, /* TVAR_ash_pGAS[142] */
	0x0F120127, /* TVAR_ash_pGAS[143] */
	0x0F120100, /* TVAR_ash_pGAS[144] */
	0x0F1200CF, /* TVAR_ash_pGAS[145] */
	0x0F1200A7, /* TVAR_ash_pGAS[146] */
	0x0F12008D, /* TVAR_ash_pGAS[147] */
	0x0F12007D, /* TVAR_ash_pGAS[148] */
	0x0F120077, /* TVAR_ash_pGAS[149] */
	0x0F12007A, /* TVAR_ash_pGAS[150] */
	0x0F120087, /* TVAR_ash_pGAS[151] */
	0x0F12009E, /* TVAR_ash_pGAS[152] */
	0x0F1200C0, /* TVAR_ash_pGAS[153] */
	0x0F1200EC, /* TVAR_ash_pGAS[154] */
	0x0F12010F, /* TVAR_ash_pGAS[155] */
	0x0F120108, /* TVAR_ash_pGAS[156] */
	0x0F1200D8, /* TVAR_ash_pGAS[157] */
	0x0F1200A5, /* TVAR_ash_pGAS[158] */
	0x0F120080, /* TVAR_ash_pGAS[159] */
	0x0F120066, /* TVAR_ash_pGAS[160] */
	0x0F120056, /* TVAR_ash_pGAS[161] */
	0x0F12004F, /* TVAR_ash_pGAS[162] */
	0x0F120053, /* TVAR_ash_pGAS[163] */
	0x0F120061, /* TVAR_ash_pGAS[164] */
	0x0F120077, /* TVAR_ash_pGAS[165] */
	0x0F120098, /* TVAR_ash_pGAS[166] */
	0x0F1200C6, /* TVAR_ash_pGAS[167] */
	0x0F1200F3, /* TVAR_ash_pGAS[168] */
	0x0F1200E7, /* TVAR_ash_pGAS[169] */
	0x0F1200B4, /* TVAR_ash_pGAS[170] */
	0x0F120081, /* TVAR_ash_pGAS[171] */
	0x0F12005C, /* TVAR_ash_pGAS[172] */
	0x0F120041, /* TVAR_ash_pGAS[173] */
	0x0F120030, /* TVAR_ash_pGAS[174] */
	0x0F120029, /* TVAR_ash_pGAS[175] */
	0x0F12002E, /* TVAR_ash_pGAS[176] */
	0x0F12003D, /* TVAR_ash_pGAS[177] */
	0x0F120055, /* TVAR_ash_pGAS[178] */
	0x0F120076, /* TVAR_ash_pGAS[179] */
	0x0F1200A5, /* TVAR_ash_pGAS[180] */
	0x0F1200D4, /* TVAR_ash_pGAS[181] */
	0x0F1200CF, /* TVAR_ash_pGAS[182] */
	0x0F12009B, /* TVAR_ash_pGAS[183] */
	0x0F12006A, /* TVAR_ash_pGAS[184] */
	0x0F120043, /* TVAR_ash_pGAS[185] */
	0x0F120027, /* TVAR_ash_pGAS[186] */
	0x0F120016, /* TVAR_ash_pGAS[187] */
	0x0F12000F, /* TVAR_ash_pGAS[188] */
	0x0F120015, /* TVAR_ash_pGAS[189] */
	0x0F120025, /* TVAR_ash_pGAS[190] */
	0x0F12003E, /* TVAR_ash_pGAS[191] */
	0x0F120061, /* TVAR_ash_pGAS[192] */
	0x0F12008E, /* TVAR_ash_pGAS[193] */
	0x0F1200BF, /* TVAR_ash_pGAS[194] */
	0x0F1200C2, /* TVAR_ash_pGAS[195] */
	0x0F12008E, /* TVAR_ash_pGAS[196] */
	0x0F12005D, /* TVAR_ash_pGAS[197] */
	0x0F120037, /* TVAR_ash_pGAS[198] */
	0x0F12001A, /* TVAR_ash_pGAS[199] */
	0x0F120009, /* TVAR_ash_pGAS[200] */
	0x0F120002, /* TVAR_ash_pGAS[201] */
	0x0F120007, /* TVAR_ash_pGAS[202] */
	0x0F120018, /* TVAR_ash_pGAS[203] */
	0x0F120033, /* TVAR_ash_pGAS[204] */
	0x0F120057, /* TVAR_ash_pGAS[205] */
	0x0F120083, /* TVAR_ash_pGAS[206] */
	0x0F1200B3, /* TVAR_ash_pGAS[207] */
	0x0F1200BE, /* TVAR_ash_pGAS[208] */
	0x0F12008A, /* TVAR_ash_pGAS[209] */
	0x0F12005A, /* TVAR_ash_pGAS[210] */
	0x0F120034, /* TVAR_ash_pGAS[211] */
	0x0F120017, /* TVAR_ash_pGAS[212] */
	0x0F120006, /* TVAR_ash_pGAS[213] */
	0x0F120000, /* TVAR_ash_pGAS[214] */
	0x0F120006, /* TVAR_ash_pGAS[215] */
	0x0F120017, /* TVAR_ash_pGAS[216] */
	0x0F120033, /* TVAR_ash_pGAS[217] */
	0x0F120057, /* TVAR_ash_pGAS[218] */
	0x0F120083, /* TVAR_ash_pGAS[219] */
	0x0F1200B3, /* TVAR_ash_pGAS[220] */
	0x0F1200C5, /* TVAR_ash_pGAS[221] */
	0x0F120091, /* TVAR_ash_pGAS[222] */
	0x0F120061, /* TVAR_ash_pGAS[223] */
	0x0F12003B, /* TVAR_ash_pGAS[224] */
	0x0F120020, /* TVAR_ash_pGAS[225] */
	0x0F12000F, /* TVAR_ash_pGAS[226] */
	0x0F120009, /* TVAR_ash_pGAS[227] */
	0x0F120010, /* TVAR_ash_pGAS[228] */
	0x0F120021, /* TVAR_ash_pGAS[229] */
	0x0F12003D, /* TVAR_ash_pGAS[230] */
	0x0F120060, /* TVAR_ash_pGAS[231] */
	0x0F12008D, /* TVAR_ash_pGAS[232] */
	0x0F1200BE, /* TVAR_ash_pGAS[233] */
	0x0F1200D7, /* TVAR_ash_pGAS[234] */
	0x0F1200A2, /* TVAR_ash_pGAS[235] */
	0x0F120072, /* TVAR_ash_pGAS[236] */
	0x0F12004D, /* TVAR_ash_pGAS[237] */
	0x0F120032, /* TVAR_ash_pGAS[238] */
	0x0F120022, /* TVAR_ash_pGAS[239] */
	0x0F12001D, /* TVAR_ash_pGAS[240] */
	0x0F120024, /* TVAR_ash_pGAS[241] */
	0x0F120035, /* TVAR_ash_pGAS[242] */
	0x0F120050, /* TVAR_ash_pGAS[243] */
	0x0F120073, /* TVAR_ash_pGAS[244] */
	0x0F1200A0, /* TVAR_ash_pGAS[245] */
	0x0F1200D2, /* TVAR_ash_pGAS[246] */
	0x0F1200F0, /* TVAR_ash_pGAS[247] */
	0x0F1200BE, /* TVAR_ash_pGAS[248] */
	0x0F12008C, /* TVAR_ash_pGAS[249] */
	0x0F120068, /* TVAR_ash_pGAS[250] */
	0x0F12004F, /* TVAR_ash_pGAS[251] */
	0x0F120040, /* TVAR_ash_pGAS[252] */
	0x0F12003B, /* TVAR_ash_pGAS[253] */
	0x0F120041, /* TVAR_ash_pGAS[254] */
	0x0F120052, /* TVAR_ash_pGAS[255] */
	0x0F12006C, /* TVAR_ash_pGAS[256] */
	0x0F12008E, /* TVAR_ash_pGAS[257] */
	0x0F1200BE, /* TVAR_ash_pGAS[258] */
	0x0F1200ED, /* TVAR_ash_pGAS[259] */
	0x0F12010C, /* TVAR_ash_pGAS[260] */
	0x0F1200E1, /* TVAR_ash_pGAS[261] */
	0x0F1200AF, /* TVAR_ash_pGAS[262] */
	0x0F12008A, /* TVAR_ash_pGAS[263] */
	0x0F120072, /* TVAR_ash_pGAS[264] */
	0x0F120064, /* TVAR_ash_pGAS[265] */
	0x0F12005F, /* TVAR_ash_pGAS[266] */
	0x0F120065, /* TVAR_ash_pGAS[267] */
	0x0F120074, /* TVAR_ash_pGAS[268] */
	0x0F12008D, /* TVAR_ash_pGAS[269] */
	0x0F1200B2, /* TVAR_ash_pGAS[270] */
	0x0F1200E0, /* TVAR_ash_pGAS[271] */
	0x0F12010A, /* TVAR_ash_pGAS[272] */
	0x0F12012F, /* TVAR_ash_pGAS[273] */
	0x0F120104, /* TVAR_ash_pGAS[274] */
	0x0F1200D9, /* TVAR_ash_pGAS[275] */
	0x0F1200B3, /* TVAR_ash_pGAS[276] */
	0x0F120099, /* TVAR_ash_pGAS[277] */
	0x0F12008B, /* TVAR_ash_pGAS[278] */
	0x0F120086, /* TVAR_ash_pGAS[279] */
	0x0F12008B, /* TVAR_ash_pGAS[280] */
	0x0F12009B, /* TVAR_ash_pGAS[281] */
	0x0F1200B5, /* TVAR_ash_pGAS[282] */
	0x0F1200DA, /* TVAR_ash_pGAS[283] */
	0x0F120101, /* TVAR_ash_pGAS[284] */
	0x0F120128, /* TVAR_ash_pGAS[285] */
	0x0F12012F, /* TVAR_ash_pGAS[286] */
	0x0F120106, /* TVAR_ash_pGAS[287] */
	0x0F1200D4, /* TVAR_ash_pGAS[288] */
	0x0F1200AA, /* TVAR_ash_pGAS[289] */
	0x0F12008E, /* TVAR_ash_pGAS[290] */
	0x0F12007D, /* TVAR_ash_pGAS[291] */
	0x0F120079, /* TVAR_ash_pGAS[292] */
	0x0F120080, /* TVAR_ash_pGAS[293] */
	0x0F120093, /* TVAR_ash_pGAS[294] */
	0x0F1200B1, /* TVAR_ash_pGAS[295] */
	0x0F1200DC, /* TVAR_ash_pGAS[296] */
	0x0F12010C, /* TVAR_ash_pGAS[297] */
	0x0F120130, /* TVAR_ash_pGAS[298] */
	0x0F120112, /* TVAR_ash_pGAS[299] */
	0x0F1200E0, /* TVAR_ash_pGAS[300] */
	0x0F1200AB, /* TVAR_ash_pGAS[301] */
	0x0F120083, /* TVAR_ash_pGAS[302] */
	0x0F120067, /* TVAR_ash_pGAS[303] */
	0x0F120057, /* TVAR_ash_pGAS[304] */
	0x0F120051, /* TVAR_ash_pGAS[305] */
	0x0F120059, /* TVAR_ash_pGAS[306] */
	0x0F12006B, /* TVAR_ash_pGAS[307] */
	0x0F120089, /* TVAR_ash_pGAS[308] */
	0x0F1200B2, /* TVAR_ash_pGAS[309] */
	0x0F1200E5, /* TVAR_ash_pGAS[310] */
	0x0F120114, /* TVAR_ash_pGAS[311] */
	0x0F1200F2, /* TVAR_ash_pGAS[312] */
	0x0F1200BD, /* TVAR_ash_pGAS[313] */
	0x0F120088, /* TVAR_ash_pGAS[314] */
	0x0F120061, /* TVAR_ash_pGAS[315] */
	0x0F120044, /* TVAR_ash_pGAS[316] */
	0x0F120031, /* TVAR_ash_pGAS[317] */
	0x0F12002C, /* TVAR_ash_pGAS[318] */
	0x0F120033, /* TVAR_ash_pGAS[319] */
	0x0F120047, /* TVAR_ash_pGAS[320] */
	0x0F120065, /* TVAR_ash_pGAS[321] */
	0x0F12008C, /* TVAR_ash_pGAS[322] */
	0x0F1200C0, /* TVAR_ash_pGAS[323] */
	0x0F1200F3, /* TVAR_ash_pGAS[324] */
	0x0F1200DB, /* TVAR_ash_pGAS[325] */
	0x0F1200A5, /* TVAR_ash_pGAS[326] */
	0x0F120071, /* TVAR_ash_pGAS[327] */
	0x0F120049, /* TVAR_ash_pGAS[328] */
	0x0F12002A, /* TVAR_ash_pGAS[329] */
	0x0F120018, /* TVAR_ash_pGAS[330] */
	0x0F120011, /* TVAR_ash_pGAS[331] */
	0x0F120018, /* TVAR_ash_pGAS[332] */
	0x0F12002C, /* TVAR_ash_pGAS[333] */
	0x0F12004B, /* TVAR_ash_pGAS[334] */
	0x0F120072, /* TVAR_ash_pGAS[335] */
	0x0F1200A3, /* TVAR_ash_pGAS[336] */
	0x0F1200D7, /* TVAR_ash_pGAS[337] */
	0x0F1200CD, /* TVAR_ash_pGAS[338] */
	0x0F120097, /* TVAR_ash_pGAS[339] */
	0x0F120065, /* TVAR_ash_pGAS[340] */
	0x0F12003C, /* TVAR_ash_pGAS[341] */
	0x0F12001D, /* TVAR_ash_pGAS[342] */
	0x0F12000A, /* TVAR_ash_pGAS[343] */
	0x0F120003, /* TVAR_ash_pGAS[344] */
	0x0F120009, /* TVAR_ash_pGAS[345] */
	0x0F12001D, /* TVAR_ash_pGAS[346] */
	0x0F12003B, /* TVAR_ash_pGAS[347] */
	0x0F120063, /* TVAR_ash_pGAS[348] */
	0x0F120092, /* TVAR_ash_pGAS[349] */
	0x0F1200C4, /* TVAR_ash_pGAS[350] */
	0x0F1200CA, /* TVAR_ash_pGAS[351] */
	0x0F120094, /* TVAR_ash_pGAS[352] */
	0x0F120062, /* TVAR_ash_pGAS[353] */
	0x0F12003A, /* TVAR_ash_pGAS[354] */
	0x0F12001A, /* TVAR_ash_pGAS[355] */
	0x0F120007, /* TVAR_ash_pGAS[356] */
	0x0F120000, /* TVAR_ash_pGAS[357] */
	0x0F120006, /* TVAR_ash_pGAS[358] */
	0x0F120018, /* TVAR_ash_pGAS[359] */
	0x0F120036, /* TVAR_ash_pGAS[360] */
	0x0F12005C, /* TVAR_ash_pGAS[361] */
	0x0F12008A, /* TVAR_ash_pGAS[362] */
	0x0F1200BC, /* TVAR_ash_pGAS[363] */
	0x0F1200D1, /* TVAR_ash_pGAS[364] */
	0x0F12009B, /* TVAR_ash_pGAS[365] */
	0x0F120069, /* TVAR_ash_pGAS[366] */
	0x0F120042, /* TVAR_ash_pGAS[367] */
	0x0F120022, /* TVAR_ash_pGAS[368] */
	0x0F12000F, /* TVAR_ash_pGAS[369] */
	0x0F120008, /* TVAR_ash_pGAS[370] */
	0x0F12000D, /* TVAR_ash_pGAS[371] */
	0x0F12001F, /* TVAR_ash_pGAS[372] */
	0x0F12003B, /* TVAR_ash_pGAS[373] */
	0x0F120060, /* TVAR_ash_pGAS[374] */
	0x0F12008D, /* TVAR_ash_pGAS[375] */
	0x0F1200BF, /* TVAR_ash_pGAS[376] */
	0x0F1200E3, /* TVAR_ash_pGAS[377] */
	0x0F1200AC, /* TVAR_ash_pGAS[378] */
	0x0F12007A, /* TVAR_ash_pGAS[379] */
	0x0F120053, /* TVAR_ash_pGAS[380] */
	0x0F120035, /* TVAR_ash_pGAS[381] */
	0x0F120022, /* TVAR_ash_pGAS[382] */
	0x0F12001B, /* TVAR_ash_pGAS[383] */
	0x0F12001F, /* TVAR_ash_pGAS[384] */
	0x0F120030, /* TVAR_ash_pGAS[385] */
	0x0F12004B, /* TVAR_ash_pGAS[386] */
	0x0F12006D, /* TVAR_ash_pGAS[387] */
	0x0F12009C, /* TVAR_ash_pGAS[388] */
	0x0F1200CE, /* TVAR_ash_pGAS[389] */
	0x0F1200FE, /* TVAR_ash_pGAS[390] */
	0x0F1200C9, /* TVAR_ash_pGAS[391] */
	0x0F120095, /* TVAR_ash_pGAS[392] */
	0x0F12006F, /* TVAR_ash_pGAS[393] */
	0x0F120052, /* TVAR_ash_pGAS[394] */
	0x0F120040, /* TVAR_ash_pGAS[395] */
	0x0F120039, /* TVAR_ash_pGAS[396] */
	0x0F12003D, /* TVAR_ash_pGAS[397] */
	0x0F12004B, /* TVAR_ash_pGAS[398] */
	0x0F120063, /* TVAR_ash_pGAS[399] */
	0x0F120086, /* TVAR_ash_pGAS[400] */
	0x0F1200B5, /* TVAR_ash_pGAS[401] */
	0x0F1200E6, /* TVAR_ash_pGAS[402] */
	0x0F12011B, /* TVAR_ash_pGAS[403] */
	0x0F1200ED, /* TVAR_ash_pGAS[404] */
	0x0F1200BA, /* TVAR_ash_pGAS[405] */
	0x0F120092, /* TVAR_ash_pGAS[406] */
	0x0F120076, /* TVAR_ash_pGAS[407] */
	0x0F120065, /* TVAR_ash_pGAS[408] */
	0x0F12005D, /* TVAR_ash_pGAS[409] */
	0x0F120060, /* TVAR_ash_pGAS[410] */
	0x0F12006D, /* TVAR_ash_pGAS[411] */
	0x0F120084, /* TVAR_ash_pGAS[412] */
	0x0F1200A8, /* TVAR_ash_pGAS[413] */
	0x0F1200D6, /* TVAR_ash_pGAS[414] */
	0x0F120101, /* TVAR_ash_pGAS[415] */
	0x0F120140, /* TVAR_ash_pGAS[416] */
	0x0F120112, /* TVAR_ash_pGAS[417] */
	0x0F1200E5, /* TVAR_ash_pGAS[418] */
	0x0F1200BD, /* TVAR_ash_pGAS[419] */
	0x0F12009E, /* TVAR_ash_pGAS[420] */
	0x0F12008C, /* TVAR_ash_pGAS[421] */
	0x0F120085, /* TVAR_ash_pGAS[422] */
	0x0F120087, /* TVAR_ash_pGAS[423] */
	0x0F120094, /* TVAR_ash_pGAS[424] */
	0x0F1200AC, /* TVAR_ash_pGAS[425] */
	0x0F1200D0, /* TVAR_ash_pGAS[426] */
	0x0F1200F8, /* TVAR_ash_pGAS[427] */
	0x0F120123, /* TVAR_ash_pGAS[428] */
	0x0F1200F2, /* TVAR_ash_pGAS[429] */
	0x0F1200D1, /* TVAR_ash_pGAS[430] */
	0x0F1200A7, /* TVAR_ash_pGAS[431] */
	0x0F120087, /* TVAR_ash_pGAS[432] */
	0x0F120073, /* TVAR_ash_pGAS[433] */
	0x0F120067, /* TVAR_ash_pGAS[434] */
	0x0F120064, /* TVAR_ash_pGAS[435] */
	0x0F12006B, /* TVAR_ash_pGAS[436] */
	0x0F12007C, /* TVAR_ash_pGAS[437] */
	0x0F120094, /* TVAR_ash_pGAS[438] */
	0x0F1200B7, /* TVAR_ash_pGAS[439] */
	0x0F1200E1, /* TVAR_ash_pGAS[440] */
	0x0F1200FF, /* TVAR_ash_pGAS[441] */
	0x0F1200D6, /* TVAR_ash_pGAS[442] */
	0x0F1200AE, /* TVAR_ash_pGAS[443] */
	0x0F120085, /* TVAR_ash_pGAS[444] */
	0x0F120068, /* TVAR_ash_pGAS[445] */
	0x0F120054, /* TVAR_ash_pGAS[446] */
	0x0F120048, /* TVAR_ash_pGAS[447] */
	0x0F120045, /* TVAR_ash_pGAS[448] */
	0x0F12004B, /* TVAR_ash_pGAS[449] */
	0x0F12005B, /* TVAR_ash_pGAS[450] */
	0x0F120073, /* TVAR_ash_pGAS[451] */
	0x0F120093, /* TVAR_ash_pGAS[452] */
	0x0F1200BF, /* TVAR_ash_pGAS[453] */
	0x0F1200E9, /* TVAR_ash_pGAS[454] */
	0x0F1200B8, /* TVAR_ash_pGAS[455] */
	0x0F12008E, /* TVAR_ash_pGAS[456] */
	0x0F120066, /* TVAR_ash_pGAS[457] */
	0x0F120049, /* TVAR_ash_pGAS[458] */
	0x0F120035, /* TVAR_ash_pGAS[459] */
	0x0F120028, /* TVAR_ash_pGAS[460] */
	0x0F120025, /* TVAR_ash_pGAS[461] */
	0x0F12002B, /* TVAR_ash_pGAS[462] */
	0x0F12003B, /* TVAR_ash_pGAS[463] */
	0x0F120053, /* TVAR_ash_pGAS[464] */
	0x0F120072, /* TVAR_ash_pGAS[465] */
	0x0F12009D, /* TVAR_ash_pGAS[466] */
	0x0F1200C8, /* TVAR_ash_pGAS[467] */
	0x0F1200A2, /* TVAR_ash_pGAS[468] */
	0x0F120078, /* TVAR_ash_pGAS[469] */
	0x0F120051, /* TVAR_ash_pGAS[470] */
	0x0F120034, /* TVAR_ash_pGAS[471] */
	0x0F12001F, /* TVAR_ash_pGAS[472] */
	0x0F120012, /* TVAR_ash_pGAS[473] */
	0x0F12000E, /* TVAR_ash_pGAS[474] */
	0x0F120014, /* TVAR_ash_pGAS[475] */
	0x0F120024, /* TVAR_ash_pGAS[476] */
	0x0F12003B, /* TVAR_ash_pGAS[477] */
	0x0F12005B, /* TVAR_ash_pGAS[478] */
	0x0F120083, /* TVAR_ash_pGAS[479] */
	0x0F1200AD, /* TVAR_ash_pGAS[480] */
	0x0F120095, /* TVAR_ash_pGAS[481] */
	0x0F12006C, /* TVAR_ash_pGAS[482] */
	0x0F120046, /* TVAR_ash_pGAS[483] */
	0x0F12002A, /* TVAR_ash_pGAS[484] */
	0x0F120014, /* TVAR_ash_pGAS[485] */
	0x0F120007, /* TVAR_ash_pGAS[486] */
	0x0F120002, /* TVAR_ash_pGAS[487] */
	0x0F120008, /* TVAR_ash_pGAS[488] */
	0x0F120016, /* TVAR_ash_pGAS[489] */
	0x0F12002D, /* TVAR_ash_pGAS[490] */
	0x0F12004C, /* TVAR_ash_pGAS[491] */
	0x0F120072, /* TVAR_ash_pGAS[492] */
	0x0F12009B, /* TVAR_ash_pGAS[493] */
	0x0F120093, /* TVAR_ash_pGAS[494] */
	0x0F12006A, /* TVAR_ash_pGAS[495] */
	0x0F120045, /* TVAR_ash_pGAS[496] */
	0x0F120028, /* TVAR_ash_pGAS[497] */
	0x0F120013, /* TVAR_ash_pGAS[498] */
	0x0F120005, /* TVAR_ash_pGAS[499] */
	0x0F120000, /* TVAR_ash_pGAS[500] */
	0x0F120004, /* TVAR_ash_pGAS[501] */
	0x0F120012, /* TVAR_ash_pGAS[502] */
	0x0F120028, /* TVAR_ash_pGAS[503] */
	0x0F120045, /* TVAR_ash_pGAS[504] */
	0x0F12006A, /* TVAR_ash_pGAS[505] */
	0x0F120093, /* TVAR_ash_pGAS[506] */
	0x0F12009B, /* TVAR_ash_pGAS[507] */
	0x0F120071, /* TVAR_ash_pGAS[508] */
	0x0F12004C, /* TVAR_ash_pGAS[509] */
	0x0F120030, /* TVAR_ash_pGAS[510] */
	0x0F12001A, /* TVAR_ash_pGAS[511] */
	0x0F12000C, /* TVAR_ash_pGAS[512] */
	0x0F120007, /* TVAR_ash_pGAS[513] */
	0x0F12000B, /* TVAR_ash_pGAS[514] */
	0x0F120018, /* TVAR_ash_pGAS[515] */
	0x0F12002C, /* TVAR_ash_pGAS[516] */
	0x0F120048, /* TVAR_ash_pGAS[517] */
	0x0F12006D, /* TVAR_ash_pGAS[518] */
	0x0F120097, /* TVAR_ash_pGAS[519] */
	0x0F1200AE, /* TVAR_ash_pGAS[520] */
	0x0F120083, /* TVAR_ash_pGAS[521] */
	0x0F12005C, /* TVAR_ash_pGAS[522] */
	0x0F120040, /* TVAR_ash_pGAS[523] */
	0x0F12002B, /* TVAR_ash_pGAS[524] */
	0x0F12001E, /* TVAR_ash_pGAS[525] */
	0x0F120018, /* TVAR_ash_pGAS[526] */
	0x0F12001C, /* TVAR_ash_pGAS[527] */
	0x0F120027, /* TVAR_ash_pGAS[528] */
	0x0F12003A, /* TVAR_ash_pGAS[529] */
	0x0F120055, /* TVAR_ash_pGAS[530] */
	0x0F12007B, /* TVAR_ash_pGAS[531] */
	0x0F1200A6, /* TVAR_ash_pGAS[532] */
	0x0F1200CA, /* TVAR_ash_pGAS[533] */
	0x0F12009E, /* TVAR_ash_pGAS[534] */
	0x0F120076, /* TVAR_ash_pGAS[535] */
	0x0F120059, /* TVAR_ash_pGAS[536] */
	0x0F120046, /* TVAR_ash_pGAS[537] */
	0x0F120039, /* TVAR_ash_pGAS[538] */
	0x0F120033, /* TVAR_ash_pGAS[539] */
	0x0F120036, /* TVAR_ash_pGAS[540] */
	0x0F120040, /* TVAR_ash_pGAS[541] */
	0x0F120052, /* TVAR_ash_pGAS[542] */
	0x0F12006C, /* TVAR_ash_pGAS[543] */
	0x0F120094, /* TVAR_ash_pGAS[544] */
	0x0F1200BF, /* TVAR_ash_pGAS[545] */
	0x0F1200EB, /* TVAR_ash_pGAS[546] */
	0x0F1200C3, /* TVAR_ash_pGAS[547] */
	0x0F120099, /* TVAR_ash_pGAS[548] */
	0x0F12007A, /* TVAR_ash_pGAS[549] */
	0x0F120066, /* TVAR_ash_pGAS[550] */
	0x0F12005A, /* TVAR_ash_pGAS[551] */
	0x0F120054, /* TVAR_ash_pGAS[552] */
	0x0F120056, /* TVAR_ash_pGAS[553] */
	0x0F12005F, /* TVAR_ash_pGAS[554] */
	0x0F120071, /* TVAR_ash_pGAS[555] */
	0x0F12008D, /* TVAR_ash_pGAS[556] */
	0x0F1200B6, /* TVAR_ash_pGAS[557] */
	0x0F1200DE, /* TVAR_ash_pGAS[558] */
	0x0F12010D, /* TVAR_ash_pGAS[559] */
	0x0F1200E7, /* TVAR_ash_pGAS[560] */
	0x0F1200C1, /* TVAR_ash_pGAS[561] */
	0x0F1200A0, /* TVAR_ash_pGAS[562] */
	0x0F12008A, /* TVAR_ash_pGAS[563] */
	0x0F12007C, /* TVAR_ash_pGAS[564] */
	0x0F120076, /* TVAR_ash_pGAS[565] */
	0x0F120078, /* TVAR_ash_pGAS[566] */
	0x0F120081, /* TVAR_ash_pGAS[567] */
	0x0F120093, /* TVAR_ash_pGAS[568] */
	0x0F1200B1, /* TVAR_ash_pGAS[569] */
	0x0F1200D5, /* TVAR_ash_pGAS[570] */
	0x0F1200FD, /* TVAR_ash_pGAS[571] */

	/* Gamma */
	0x002A04CC,
	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[0][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[0][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[0][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[0][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[0][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[0][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[0][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[0][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[0][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[0][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[0][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[0][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[0][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[0][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[0][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[0][15] */

	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[1][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[1][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[1][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[1][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[1][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[1][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[1][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[1][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[1][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[1][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[1][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[1][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[1][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[1][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[1][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[1][15] */

	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[2][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[2][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[2][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[2][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[2][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[2][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[2][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[2][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[2][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[2][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[2][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[2][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[2][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[2][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[2][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[2][15] */


	/* Set AWB */
	0x002A0DA6,
	0x0F120000,
	0x0F120000,
	0x002A0E8C,
	0x0F120000,
	0x002A0D6C,
	0x0F120040,

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F12038F, /* awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F12039B, /* awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F120373, /* awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F120352, /* awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203B7, /* awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120334, /* awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203B5, /* awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120318, /* awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202FF, /* awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12038D, /* awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202E7, /* awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120372, /* awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202D0, /* awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12035D, /* awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202B5, /* awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120345, /* awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202A1, /* awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F120331, /* awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12028B, /* awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12031E, /* awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120309, /* awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F12025F, /* awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202F5, /* awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120250, /* awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202DB, /* awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F120241, /* awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202C7, /* awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F120233, /* awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202B9, /* awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120223, /* awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202AB, /* awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120217, /* awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F1202A2, /* awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120207, /* awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120294, /* awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201FA, /* awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120289, /* awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201EA, /* awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F120281, /* awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201DD, /* awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F12027B, /* awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201D0, /* awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201C3, /* awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12026A, /* awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201B6, /* awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F120265, /* awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201AB, /* awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F12025B, /* awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201A1, /* awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120254, /* awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120198, /* awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F12024B, /* awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120242, /* awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120191, /* awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F12023A, /* awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F1201C5, /* awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F1201DF, /* awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */


	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F120022,
	0x0F120000,
	0x0F12010F,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F12025E, /* 0264 awbb_OutdoorGrZones_m_BGrid_0__m_left    */
	0x0F120282, /* 0279 awbb_OutdoorGrZones_m_BGrid_0__m_right   */
	0x0F120240, /* 0250 awbb_OutdoorGrZones_m_BGrid_1__m_left    */
	0x0F120298, /* 0287 awbb_OutdoorGrZones_m_BGrid_1__m_right   */
	0x0F12022A, /* 0244 awbb_OutdoorGrZones_m_BGrid_2__m_left    */
	0x0F12029A, /* 0287 awbb_OutdoorGrZones_m_BGrid_2__m_right   */
	0x0F12021A, /* 0235 awbb_OutdoorGrZones_m_BGrid_3__m_left    */
	0x0F12029A, /* 0289 awbb_OutdoorGrZones_m_BGrid_3__m_right   */
	0x0F120206, /* 0225 awbb_OutdoorGrZones_m_BGrid_4__m_left    */
	0x0F120298, /* 0287 awbb_OutdoorGrZones_m_BGrid_4__m_right   */
	0x0F1201FE, /* 0213 awbb_OutdoorGrZones_m_BGrid_5__m_left    */
	0x0F12028C, /* 0286 awbb_OutdoorGrZones_m_BGrid_5__m_right   */
	0x0F1201FA, /* 0202 awbb_OutdoorGrZones_m_BGrid_6__m_left    */
	0x0F120278, /* 027A awbb_OutdoorGrZones_m_BGrid_6__m_right   */
	0x0F1201F8, /* 01F3 awbb_OutdoorGrZones_m_BGrid_7__m_left    */
	0x0F120266, /* 0272 awbb_OutdoorGrZones_m_BGrid_7__m_right   */
	0x0F120214, /* 01E9 awbb_OutdoorGrZones_m_BGrid_8__m_left    */
	0x0F120238, /* 0269 awbb_OutdoorGrZones_m_BGrid_8__m_right   */
	0x0F120000, /* 01E2 awbb_OutdoorGrZones_m_BGrid_9__m_left    */
	0x0F120000, /* 0263 awbb_OutdoorGrZones_m_BGrid_9__m_right   */
	0x0F120000, /* 01E0 awbb_OutdoorGrZones_m_BGrid_10__m_left   */
	0x0F120000, /* 025A awbb_OutdoorGrZones_m_BGrid_10__m_right  */
	0x0F120000, /* 01E1 awbb_OutdoorGrZones_m_BGrid_11__m_left   */
	0x0F120000, /* 0256 awbb_OutdoorGrZones_m_BGrid_11__m_right  */
	0x0F120000, /* 01EE awbb_OutdoorGrZones_m_BGrid_12__m_left   */
	0x0F120000, /* 0251 awbb_OutdoorGrZones_m_BGrid_12__m_right  */
	0x0F120000, /* 01F8 awbb_OutdoorGrZones_m_BGrid(26)          */
	0x0F120000, /* 024A awbb_OutdoorGrZones_m_BGrid(27)          */
	0x0F120000, /* 020D awbb_OutdoorGrZones_m_BGrid(28)          */
	0x0F120000, /* 0231 awbb_OutdoorGrZones_m_BGrid(29)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(30)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(31)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(32)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(33)          */


	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120210,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/*  7-3. Low Br grey zone                     */
	/* param_  C4start	awbb_LowBrGrZones_m_BGrid */

	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,



	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFE0, /* awbb_GridCorr_R_0__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_0__1_ */
	0x0F120000, /* awbb_GridCorr_R_0__2_ */
	0x0F120000, /* awbb_GridCorr_R_0__3_ */
	0x0F120000, /* awbb_GridCorr_R_0__4_ */
	0x0F120030, /* awbb_GridCorr_R_0__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_1__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_1__1_ */
	0x0F120000, /* awbb_GridCorr_R_1__2_ */
	0x0F120000, /* awbb_GridCorr_R_1__3_ */
	0x0F120000, /* awbb_GridCorr_R_1__4_ */
	0x0F120030, /* awbb_GridCorr_R_1__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_2__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_2__1_ */
	0x0F120000, /* awbb_GridCorr_R_2__2_ */
	0x0F120000, /* awbb_GridCorr_R_2__3_ */
	0x0F120000, /* awbb_GridCorr_R_2__4_ */
	0x0F120030, /* awbb_GridCorr_R_2__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_0__0_ */
	0x0F120000, /* awbb_GridCorr_B_0__1_ */
	0x0F120000, /* awbb_GridCorr_B_0__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_0__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_0__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_0__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_1__0_ */
	0x0F120000, /* awbb_GridCorr_B_1__1_ */
	0x0F120000, /* awbb_GridCorr_B_1__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_1__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_1__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_1__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_2__0_ */
	0x0F120000, /* awbb_GridCorr_B_2__1_ */
	0x0F120000, /* awbb_GridCorr_B_2__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_2__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_2__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_2__5_ */

	0x0F1202C6,
	0x0F120335,
	0x0F1203B3,
	0x0F121021,
	0x0F12107E,
	0x0F12113E,
	0x0F12117C,
	0x0F1211C2,
	0x0F12120B,

	0x0F1200B3,
	0x0F1200B7,
	0x0F1200D3,
	0x0F120091,

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,

	/* Gamut Thresholds */
	0x002A0DAE,
	0x0F120036,
	0x0F12001C,
	0x002A0DAA,
	0x0F12071A,
	0x0F1203A4,

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120BB8,
	0x0F120096,
	0x002A0E86,
	0x0F120216,
	0x0F12029F,
	0x002A0D96,
	0x0F120BB7,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F120459,
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,


	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120210, /* 258 awbb_GainsMaxMove */
	0x0F120003,


	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/* CCM */
	0x002A2800,
	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201FB,
	0x0F12FFA9,
	0x0F12FFEA,
	0x0F12013C,
	0x0F120140,
	0x0F12FF53,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF39,
	0x0F1201D6,
	0x0F1200C4,
	0x0F12FFC0,
	0x0F12FFBF,
	0x0F1201CD,
	0x0F120182,
	0x0F12FF91,
	0x0F1201AA,

	0x0F1201C5,
	0x0F12FF9F,
	0x0F12FFE5,
	0x0F1200E2,
	0x0F12010E,
	0x0F12FF62,
	0x0F12FF03,
	0x0F1201D0,
	0x0F12FF3E,
	0x0F12FF00,
	0x0F1201A6,
	0x0F1200BB,
	0x0F12FFBF,
	0x0F12FFDD,
	0x0F1201F6,
	0x0F1200CB,
	0x0F12FF94,
	0x0F12019E,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200E8,
	0x0F120126,
	0x0F12FF83,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF8A,
	0x0F1201F9,
	0x0F12005B,
	0x0F12FFCA,
	0x0F12FFA3,
	0x0F1201DA,
	0x0F120108,
	0x0F12FFB3,
	0x0F1201DD,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200F4,
	0x0F120139,
	0x0F12FF64,
	0x0F12FEEC,
	0x0F1201FD,
	0x0F12FF8E,
	0x0F12FEF4,
	0x0F1201BD,
	0x0F12010A,
	0x0F12FFA2,
	0x0F12FFDE,
	0x0F120208,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	/* Set NB */
	0x002A07EA,
	0x0F120000, /*afit_bUseNoiseInd 0 : NB 1: Noise Index */

	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */

	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,

	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120010, /* SATURATION                                                         */
	0x0F12FFE2, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F120028, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120344, /* UVDenoise_iYLowThresh                                              */
	0x0F12033A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120008, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120014, /* Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120064, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120114, /* UVDenoise_iYLowThresh                                              */
	0x0F12020A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000C, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120060, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12005A, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F12000A, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120000, /* UVDenoise_iYLowThresh                                              */
	0x0F120000, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F1200FF,
	0x0F1200FF,
	0x0F120800,
	0x0F120600,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120300,
	0x0F120002,
	0x0F120400,
	0x0F120106,
	0x0F120005,
	0x0F120000,
	0x0F120703,
	0x0F120000,
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */

	0x0028D000,
	0x002AB0CC,
	0x0F12000B, /* Non contious mode */
	/* Recording 25fps Anti-Flicker 50Hz END of Initial */
};

/* Recording with 25fps, simplified for FD service */
static const u32 s5k5bafx_FD_common[] = {

	/* recording 25fps Anti-Flicker 50Hz*/

	0xFCFCD000,

	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* p100	Delay */


	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0, /* setot_uOnlineClocksDiv40             */
	0x002A0AE2,
	0x0F12222E, /* setot_usSetRomWaitStateThreshold4KHz */

	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R       */
	0x0F120400, /* awbb_GainsInit_1_:G       */
	0x0F1205F0, /* awbb_GainsInit_2_:B       */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start      */
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */


	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,


	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,

	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,
	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,
	0x0F120015,
	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,


	0x002AF900,
	0x0F120067,


	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,

	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,

	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,

	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,

	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,

	0x002AF4D6,
	0x0F120090,


	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,

	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,

	/* sensor aig table setting */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,


	0x002A1084,
	0x0F120000,
	0x0F120000,

	/* Set AE Target */
	0x002A0F4C,
	0x0F12003A, /* TVAR_ae_BrAve */

	0x002A0478,
	0x0F120114,
	0x0F1200EB, /* ae boundary */



	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A, /* uMaxExp1 */
	0x0F120000,
	0x002A048C,
	0x0F128214, /* uMaxExp2 */
	0x0F120000,
	0x0F12A122, /* uMaxExp3 */
	0x0F120000,
	0x002A0488,
	0x0F12f424, /* uMaxExp4 */
	0x0F120000,
	0x002A043A,
	0x0F1201D0, /* lt_uMaxAnGain0   */
	0x0F1201E0, /* lt_uMaxAnGain0_1 */
	0x002A0494,
	0x0F120300, /* lt_uMaxAnGain1 */
	0x0F120650, /* lt_uMaxAnGain2 */
	0x0f120100,
	0x002A0F52,
	0x0F12000F, /* ae_StatMode */

	0x002A0E98, /* bp_uMaxBrightnessFactor */
	0x0F1202A8,
	0x002A0E9E, /* bp_uMinBrightnessFactor */
	0x0F120298,

	/* 1. Auto Flicker 50Hz Start */
	0x002A0B2E,
	0x0F120000, /* AFC_Default60Hz	 Auto Flicker 60Hz start 0: Auto Flicker 50Hz start */
	0x002A03F8,
	0x0F12005F, /* REG_TC_DBG_AutoAlgEnBits   default : 007F */


	0xffff000a, /* p10	Wait10mSec */

	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0, /* REG_TC_IPRM_InClockLSBs */
	0x0F120000, /* REG_TC_IPRM_InClockMSBs */

	/* Parallel or MIPI Selection */
	0x002A01C6,
	0x0F120001, /* REG_TC_IPRM_UseNPviClocks         */
	0x0F120001, /* REG_TC_IPRM_UseNMipiClocks        */
	0x0F120000, /* REG_TC_IPRM_bBlockInternalPllCalc */

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770, /* REG_TC_IPRM_OpClk4KHz_0      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_0 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_0 */

	/* System Clock 1 (System : 48Mhz, PCLK : 48Mhz) */
	0x002A01D2,
	0x0F122EE0, /* REG_TC_IPRM_OpClk4KHz_1      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_1 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_1 */



	0x002A01DE,
	0x0F120001, /* REG_TC_IPRM_UseRegsAPI        */
	0x0F120001, /* REG_TC_IPRM_InitParamsUpdated */
	0xffff0064, /* p100                          */



	/* Crop */
	0x002A01FA,
	0x0F120640, /* REG_TC_GP_PrevReqInputWidth  */
	0x0F1204B0, /* REG_TC_GP_PrevReqInputHeight */
	0x0F120000, /* REG_TC_GP_PrevInputWidthOfs  */
	0x0F120000, /* REG_TC_GP_PrevInputHeightOfs */


	/* Set Preview Config */
	/* Preview Config 0 (VGA fixed 30fps) */
	0x002A0242,
	0x0F120280, /* REG_0TC_PCFG_usWidth                */
	0x0F1201E0, /* REG_0TC_PCFG_usHeight               */
	0x0F120005, /* REG_0TC_PCFG_Format                 */
	0x0F122EE0, /* REG_0TC_PCFG_usMaxOut4KHzRate       */
	0x0F122EE0, /* REG_0TC_PCFG_usMinOut4KHzRate       */
	0x0F120052, /* REG_0TC_PCFG_PVIMask                */
	0x0F120001, /* REG_0TC_PCFG_uClockInd              */
	0x0F120002, /* REG_0TC_PCFG_usFrTimeType           */
	0x0F120001, /* REG_0TC_PCFG_FrRateQualityType      */

#if 1	/* 25 fps */
	0x0F12018c, /* REG_0TC_PCFG_usMaxFrTimeMsecMult10  */
	0x0F12018c, /* REG_0TC_PCFG_usMinFrTimeMsecMult10  */
#else	/* 30 fps */
	/* 0x0F12014d, *//* REG_0TC_PCFG_usMaxFrTimeMsecMult10  */
	/* 0x0F12014d, *//* REG_0TC_PCFG_usMinFrTimeMsecMult10  */
#endif
	0x0F120000, /* REG_0TC_PCFG_sSaturation            */
	0x0F120000, /* REG_0TC_PCFG_sSharpBlur             */
	0x0F120000, /* REG_0TC_PCFG_sGlamour               */
	0x0F120000, /* REG_0TC_PCFG_sColorTemp             */
	0x0F120000, /* REG_0TC_PCFG_uDeviceGammaIndex      */
	0x0F120000, /* REG_0TC_PCFG_uPrevMirror            */
	0x0F120000, /* REG_0TC_PCFG_uCaptureMirror         */
	0x0F120000, /* REG_0TC_PCFG_uRotation              */


	/* Set MIPI */
	0x002A03AC,
	0x0F120000, /* REG_TC_FLS_Mode        */
	0x002A03F2,
	0x0F120001, /* REG_TC_OIF_EnMipiLanes */
	0x0F1200C3, /* REG_TC_OIF_EnPackets   */
	0x0F120001, /* REG_TC_OIF_CfgChanged  */

	/* Apply preview config */
	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */



	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000, /* REG_0TC_CCFG_uCaptureMode          */
	0x0F120640, /* REG_0TC_CCFG_usWidth               */
	0x0F1204B0, /* REG_0TC_CCFG_usHeight              */
	0x0F120005, /* REG_0TC_CCFG_Format                */
	0x0F122EE0, /* REG_0TC_CCFG_usMaxOut4KHzRate      */
	0x0F122EE0, /* REG_0TC_CCFG_usMinOut4KHzRate      */
	0x0F120052, /* REG_0TC_CCFG_PVIMask               */
	0x0F120001, /* REG_0TC_CCFG_uClockInd             */
	0x0F120002, /* REG_0TC_CCFG_usFrTimeType          */
	0x0F120002, /* REG_0TC_CCFG_FrRateQualityType     */
	0x0F1204E2, /* REG_0TC_CCFG_usMaxFrTimeMsecMult10 */
	0x0F1204E2, /* REG_0TC_CCFG_usMinFrTimeMsecMult10 */
	0x0F120000, /* REG_0TC_CCFG_sSaturation           */
	0x0F120000, /* REG_0TC_CCFG_sSharpBlur            */
	0x0F120000, /* REG_0TC_CCFG_sGlamour              */
	0x0F120000, /* REG_0TC_CCFG_sColorTemp            */
	0x0F120000, /* REG_0TC_CCFG_uDeviceGammaIndex     */



	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A07C0,
	0x0F120004,
	0x0F120004,

	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,


	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000, /* ae_WeightTbl_16_0_ */
	0x0F120000, /* ae_WeightTbl_16_1_ */
	0x0F120000, /* ae_WeightTbl_16_2_ */
	0x0F120000, /* ae_WeightTbl_16_3_ */
	0x0F120101, /* ae_WeightTbl_16_4_ */
	0x0F120101, /* ae_WeightTbl_16_5_ */
	0x0F120101, /* ae_WeightTbl_16_6_ */
	0x0F120101, /* ae_WeightTbl_16_7_ */
	0x0F120101, /* ae_WeightTbl_16_8_ */
	0x0F120302, /* ae_WeightTbl_16_9_ */
	0x0F120203, /* ae_WeightTbl_16_10 */
	0x0F120101, /* ae_WeightTbl_16_11 */
	0x0F120101, /* ae_WeightTbl_16_12 */
	0x0F120403, /* ae_WeightTbl_16_13 */
	0x0F120304, /* ae_WeightTbl_16_14 */
	0x0F120101, /* ae_WeightTbl_16_15 */
	0x0F120101, /* ae_WeightTbl_16_16 */
	0x0F120403, /* ae_WeightTbl_16_17 */
	0x0F120304, /* ae_WeightTbl_16_18 */
	0x0F120101, /* ae_WeightTbl_16_19 */
	0x0F120101, /* ae_WeightTbl_16_20 */
	0x0F120302, /* ae_WeightTbl_16_21 */
	0x0F120203, /* ae_WeightTbl_16_22 */
	0x0F120101, /* ae_WeightTbl_16_23 */
	0x0F120101, /* ae_WeightTbl_16_24 */
	0x0F120101, /* ae_WeightTbl_16_25 */
	0x0F120101, /* ae_WeightTbl_16_26 */
	0x0F120101, /* ae_WeightTbl_16_27 */
	0x0F120000, /* ae_WeightTbl_16_28 */
	0x0F120000, /* ae_WeightTbl_16_29 */
	0x0F120000, /* ae_WeightTbl_16_30 */
	0x0F120000, /* ae_WeightTbl_16_31 */


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,

	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,

	/* Target Brightness Control */
	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,


	/* Gamma */
	0x002A04CC,
	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[0][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[0][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[0][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[0][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[0][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[0][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[0][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[0][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[0][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[0][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[0][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[0][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[0][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[0][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[0][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[0][15] */

	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[1][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[1][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[1][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[1][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[1][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[1][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[1][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[1][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[1][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[1][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[1][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[1][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[1][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[1][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[1][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[1][15] */

	0x0F120000, /* 0000 SARR_usGammaLutRGBIndoor[2][0]  */
	0x0F120002, /* 0002 SARR_usGammaLutRGBIndoor[2][1]  */
	0x0F120008, /* 0008 SARR_usGammaLutRGBIndoor[2][2]  */
	0x0F120016, /* 0018 SARR_usGammaLutRGBIndoor[2][3]  */
	0x0F120055, /* 005A SARR_usGammaLutRGBIndoor[2][4]  */
	0x0F1200E6, /* 00DF SARR_usGammaLutRGBIndoor[2][5]  */
	0x0F120141, /* 013F SARR_usGammaLutRGBIndoor[2][6]  */
	0x0F120188, /* 0186 SARR_usGammaLutRGBIndoor[2][7]  */
	0x0F1201E6, /* 01E6 SARR_usGammaLutRGBIndoor[2][8]  */
	0x0F120236, /* 0236 SARR_usGammaLutRGBIndoor[2][9]  */
	0x0F1202BA, /* 02BA SARR_usGammaLutRGBIndoor[2][10] */
	0x0F12032A, /* 032A SARR_usGammaLutRGBIndoor[2][11] */
	0x0F120385, /* 0385 SARR_usGammaLutRGBIndoor[2][12] */
	0x0F1203C2, /* 03C2 SARR_usGammaLutRGBIndoor[2][13] */
	0x0F1203EA, /* 03EA SARR_usGammaLutRGBIndoor[2][14] */
	0x0F1203FF, /* 03FF SARR_usGammaLutRGBIndoor[2][15] */


	/* Set AWB */
	0x002A0DA6,
	0x0F120000,
	0x0F120000,
	0x002A0E8C,
	0x0F120000,
	0x002A0D6C,
	0x0F120040,

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F12038F, /* awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F12039B, /* awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F120373, /* awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F120352, /* awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203B7, /* awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120334, /* awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203B5, /* awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120318, /* awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203B0, /* awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202FF, /* awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12038D, /* awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202E7, /* awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120372, /* awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202D0, /* awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12035D, /* awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202B5, /* awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120345, /* awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202A1, /* awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F120331, /* awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12028B, /* awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12031E, /* awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120309, /* awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F12025F, /* awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202F5, /* awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120250, /* awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202DB, /* awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F120241, /* awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202C7, /* awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F120233, /* awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202B9, /* awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120223, /* awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202AB, /* awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120217, /* awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F1202A2, /* awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120207, /* awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120294, /* awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201FA, /* awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120289, /* awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201EA, /* awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F120281, /* awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201DD, /* awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F12027B, /* awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201D0, /* awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F120273, /* awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201C3, /* awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12026A, /* awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201B6, /* awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F120265, /* awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201AB, /* awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F12025B, /* awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201A1, /* awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120254, /* awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120198, /* awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F12024B, /* awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120242, /* awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120191, /* awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F12023A, /* awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F120192, /* awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120222, /* awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F1201C5, /* awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F1201DF, /* awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */


	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F120022,
	0x0F120000,
	0x0F12010F,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F12025E, /* 0264 awbb_OutdoorGrZones_m_BGrid_0__m_left    */
	0x0F120282, /* 0279 awbb_OutdoorGrZones_m_BGrid_0__m_right   */
	0x0F120240, /* 0250 awbb_OutdoorGrZones_m_BGrid_1__m_left    */
	0x0F120298, /* 0287 awbb_OutdoorGrZones_m_BGrid_1__m_right   */
	0x0F12022A, /* 0244 awbb_OutdoorGrZones_m_BGrid_2__m_left    */
	0x0F12029A, /* 0287 awbb_OutdoorGrZones_m_BGrid_2__m_right   */
	0x0F12021A, /* 0235 awbb_OutdoorGrZones_m_BGrid_3__m_left    */
	0x0F12029A, /* 0289 awbb_OutdoorGrZones_m_BGrid_3__m_right   */
	0x0F120206, /* 0225 awbb_OutdoorGrZones_m_BGrid_4__m_left    */
	0x0F120298, /* 0287 awbb_OutdoorGrZones_m_BGrid_4__m_right   */
	0x0F1201FE, /* 0213 awbb_OutdoorGrZones_m_BGrid_5__m_left    */
	0x0F12028C, /* 0286 awbb_OutdoorGrZones_m_BGrid_5__m_right   */
	0x0F1201FA, /* 0202 awbb_OutdoorGrZones_m_BGrid_6__m_left    */
	0x0F120278, /* 027A awbb_OutdoorGrZones_m_BGrid_6__m_right   */
	0x0F1201F8, /* 01F3 awbb_OutdoorGrZones_m_BGrid_7__m_left    */
	0x0F120266, /* 0272 awbb_OutdoorGrZones_m_BGrid_7__m_right   */
	0x0F120214, /* 01E9 awbb_OutdoorGrZones_m_BGrid_8__m_left    */
	0x0F120238, /* 0269 awbb_OutdoorGrZones_m_BGrid_8__m_right   */
	0x0F120000, /* 01E2 awbb_OutdoorGrZones_m_BGrid_9__m_left    */
	0x0F120000, /* 0263 awbb_OutdoorGrZones_m_BGrid_9__m_right   */
	0x0F120000, /* 01E0 awbb_OutdoorGrZones_m_BGrid_10__m_left   */
	0x0F120000, /* 025A awbb_OutdoorGrZones_m_BGrid_10__m_right  */
	0x0F120000, /* 01E1 awbb_OutdoorGrZones_m_BGrid_11__m_left   */
	0x0F120000, /* 0256 awbb_OutdoorGrZones_m_BGrid_11__m_right  */
	0x0F120000, /* 01EE awbb_OutdoorGrZones_m_BGrid_12__m_left   */
	0x0F120000, /* 0251 awbb_OutdoorGrZones_m_BGrid_12__m_right  */
	0x0F120000, /* 01F8 awbb_OutdoorGrZones_m_BGrid(26)          */
	0x0F120000, /* 024A awbb_OutdoorGrZones_m_BGrid(27)          */
	0x0F120000, /* 020D awbb_OutdoorGrZones_m_BGrid(28)          */
	0x0F120000, /* 0231 awbb_OutdoorGrZones_m_BGrid(29)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(30)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(31)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(32)          */
	0x0F120000, /* 0000 awbb_OutdoorGrZones_m_BGrid(33)          */


	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120210,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/*  7-3. Low Br grey zone                     */
	/* param_  C4start	awbb_LowBrGrZones_m_BGrid */

	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,



	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFE0, /* awbb_GridCorr_R_0__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_0__1_ */
	0x0F120000, /* awbb_GridCorr_R_0__2_ */
	0x0F120000, /* awbb_GridCorr_R_0__3_ */
	0x0F120000, /* awbb_GridCorr_R_0__4_ */
	0x0F120030, /* awbb_GridCorr_R_0__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_1__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_1__1_ */
	0x0F120000, /* awbb_GridCorr_R_1__2_ */
	0x0F120000, /* awbb_GridCorr_R_1__3_ */
	0x0F120000, /* awbb_GridCorr_R_1__4_ */
	0x0F120030, /* awbb_GridCorr_R_1__5_ */

	0x0F12FFE0, /* awbb_GridCorr_R_2__0_ */
	0x0F12FFE0, /* D8 awbb_GridCorr_R_2__1_ */
	0x0F120000, /* awbb_GridCorr_R_2__2_ */
	0x0F120000, /* awbb_GridCorr_R_2__3_ */
	0x0F120000, /* awbb_GridCorr_R_2__4_ */
	0x0F120030, /* awbb_GridCorr_R_2__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_0__0_ */
	0x0F120000, /* awbb_GridCorr_B_0__1_ */
	0x0F120000, /* awbb_GridCorr_B_0__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_0__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_0__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_0__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_1__0_ */
	0x0F120000, /* awbb_GridCorr_B_1__1_ */
	0x0F120000, /* awbb_GridCorr_B_1__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_1__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_1__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_1__5_ */

	0x0F120004, /* 08 awbb_GridCorr_B_2__0_ */
	0x0F120000, /* awbb_GridCorr_B_2__1_ */
	0x0F120000, /* awbb_GridCorr_B_2__2_ */
	0x0F12FFC0, /* awbb_GridCorr_B_2__3_ */
	0x0F12FFB0, /* awbb_GridCorr_B_2__4_ */
	0x0F12FF30, /* awbb_GridCorr_B_2__5_ */

	0x0F1202C6,
	0x0F120335,
	0x0F1203B3,
	0x0F121021,
	0x0F12107E,
	0x0F12113E,
	0x0F12117C,
	0x0F1211C2,
	0x0F12120B,

	0x0F1200B3,
	0x0F1200B7,
	0x0F1200D3,
	0x0F120091,

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,

	/* Gamut Thresholds */
	0x002A0DAE,
	0x0F120036,
	0x0F12001C,
	0x002A0DAA,
	0x0F12071A,
	0x0F1203A4,

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120BB8,
	0x0F120096,
	0x002A0E86,
	0x0F120216,
	0x0F12029F,
	0x002A0D96,
	0x0F120BB7,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F120459,
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,


	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120210, /* 258 awbb_GainsMaxMove */
	0x0F120003,


	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/* CCM */
	0x002A2800,
	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201E1,
	0x0F12FFC4,
	0x0F12FFF8,
	0x0F120101,
	0x0F12014C,
	0x0F12FF55,
	0x0F12FF5B,
	0x0F120205,
	0x0F12FF17,
	0x0F12FEFE,
	0x0F1201B6,
	0x0F120107,
	0x0F12FFDB,
	0x0F12FFDB,
	0x0F1201D1,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	0x0F1201FB,
	0x0F12FFA9,
	0x0F12FFEA,
	0x0F12013C,
	0x0F120140,
	0x0F12FF53,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF39,
	0x0F1201D6,
	0x0F1200C4,
	0x0F12FFC0,
	0x0F12FFBF,
	0x0F1201CD,
	0x0F120182,
	0x0F12FF91,
	0x0F1201AA,

	0x0F1201C5,
	0x0F12FF9F,
	0x0F12FFE5,
	0x0F1200E2,
	0x0F12010E,
	0x0F12FF62,
	0x0F12FF03,
	0x0F1201D0,
	0x0F12FF3E,
	0x0F12FF00,
	0x0F1201A6,
	0x0F1200BB,
	0x0F12FFBF,
	0x0F12FFDD,
	0x0F1201F6,
	0x0F1200CB,
	0x0F12FF94,
	0x0F12019E,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200E8,
	0x0F120126,
	0x0F12FF83,
	0x0F12FE7A,
	0x0F12017D,
	0x0F12FEED,
	0x0F12FF8A,
	0x0F1201F9,
	0x0F12005B,
	0x0F12FFCA,
	0x0F12FFA3,
	0x0F1201DA,
	0x0F120108,
	0x0F12FFB3,
	0x0F1201DD,

	0x0F1201D2,
	0x0F12FFC2,
	0x0F12FFFC,
	0x0F1200F4,
	0x0F120139,
	0x0F12FF64,
	0x0F12FEEC,
	0x0F1201FD,
	0x0F12FF8E,
	0x0F12FEF4,
	0x0F1201BD,
	0x0F12010A,
	0x0F12FFA2,
	0x0F12FFDE,
	0x0F120208,
	0x0F120163,
	0x0F12FF9E,
	0x0F1201B3,

	/* Set NB */
	0x002A07EA,
	0x0F120000, /*afit_bUseNoiseInd 0 : NB 1: Noise Index */

	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */

	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,

	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120010, /* SATURATION                                                         */
	0x0F12FFE2, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F120028, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120344, /* UVDenoise_iYLowThresh                                              */
	0x0F12033A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120008, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120014, /* Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120064, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120114, /* UVDenoise_iYLowThresh                                              */
	0x0F12020A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000C, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120060, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12005A, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F12000A, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120006, /* Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120050, /* Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120000, /* UVDenoise_iYLowThresh                                              */
	0x0F120000, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x0F1200FF,
	0x0F1200FF,
	0x0F120800,
	0x0F120600,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120300,
	0x0F120002,
	0x0F120400,
	0x0F120106,
	0x0F120005,
	0x0F120000,
	0x0F120703,
	0x0F120000,
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */

	0x0028D000,
	0x002AB0CC,
	0x0F12000B, /* Non contious mode */
	/* Recording 25fps Anti-Flicker 50Hz END of Initial */
};

static const u32 s5k5bafx_stream_stop[] =
{
	0xFCFCD000,
	0x00287000,
 	0x002A01F0,
	0x0F120000, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged*/
	/*0xffff0096, 150ms*/
};

#if (0)
static const u32 s5k5bafx_stream_start[] =
{
	0xFCFCD000,
	0x002AB00C,
	0x0F120001,
};
#endif

/*=================================
*	CAMERA_BRIGHTNESS_1 (1/9) M4   *
==================================*/
static const u32 s5k5bafx_bright_m4[] =
{
	/* Brightness -4 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FF80, /* REG_TC_UserBrightness */
};

/*=================================
*	CAMERA_BRIGHTNESS_2 (2/9) M3  *
==================================*/

static const u32 s5k5bafx_bright_m3[] =
{
	/* Brightness -3 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FFBC, /* REG_TC_UserBrightness*/
};

/*=================================
	CAMERA_BRIGHTNESS_3 (3/9) M2
==================================*/
static const u32 s5k5bafx_bright_m2[] =
{
	/* Brightness -2 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FFDC, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_4 (4/9) M1
==================================*/

static const u32 s5k5bafx_bright_m1[] =
{
	/* Brightness -1 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FFF2, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_5 (5/9) Default
==================================*/
static const u32 s5k5bafx_bright_default[] =
{
	/* Brightness 0 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120000, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_6 (6/9) P1
==================================*/
static const u32 s5k5bafx_bright_p1[] =
{
	/* Brightness +1 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120020, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_7 (7/9) P2
==================================*/
static const u32 s5k5bafx_bright_p2[] =
{
	/* Brightness +2 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120040, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_8 (8/9) P3
==================================*/
static const u32 s5k5bafx_bright_p3[] =
{
	/* Brightness +3 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120060, /* REG_TC_UserBrightness */

};

/*=================================
	CAMERA_BRIGHTNESS_9 (9/9) P4
==================================*/
static const u32 s5k5bafx_bright_p4[] =
{
	/* Brightness +4 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120080, /* REG_TC_UserBrightness */
};

/*******************************************************
* CAMERA_VT_PRETTY_0 Default
* 200s self cam pretty
*******************************************************/
static const u32 s5k5bafx_vt_pretty_default[] =
{
	/* 0xffff000A, */
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120018,
	0x0F12005A,
	0x0F1200DF,
	0x0F12013F,
	0x0F120186,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120018,
	0x0F12005A,
	0x0F1200DF,
	0x0F12013F,
	0x0F120186,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120018,
	0x0F12005A,
	0x0F1200DF,
	0x0F12013F,
	0x0F120186,
	0x0F1201E6,
	0x0F120236,
	0x0F1202BA,
	0x0F12032A,
	0x0F120385,
	0x0F1203C2,
	0x0F1203EA,
	0x0F1203FF,
};


/*******************************************************
*	CAMERA_VT_PRETTY_1
*******************************************************/
static const u32 s5k5bafx_vt_pretty_1[] =
{
	/*0xffff000A,*/
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000,
	0x0F12000D,
	0x0F12001B,
	0x0F120046,
	0x0F1200AA,
	0x0F120120,
	0x0F120190,
	0x0F1201E0,
	0x0F120250,
	0x0F1202A5,
	0x0F120320,
	0x0F120370,
	0x0F1203B0,
	0x0F1203D8,
	0x0F1203F2,
	0x0F120400,

	0x0F120000,
	0x0F12000D,
	0x0F12001B,
	0x0F120046,
	0x0F1200AA,
	0x0F120120,
	0x0F120190,
	0x0F1201E0,
	0x0F120250,
	0x0F1202A5,
	0x0F120320,
	0x0F120370,
	0x0F1203B0,
	0x0F1203D8,
	0x0F1203F2,
	0x0F120400,

	0x0F120000,
	0x0F12000D,
	0x0F12001B,
	0x0F120046,
	0x0F1200AA,
	0x0F120120,
	0x0F120190,
	0x0F1201E0,
	0x0F120250,
	0x0F1202A5,
	0x0F120320,
	0x0F120370,
	0x0F1203B0,
	0x0F1203D8,
	0x0F1203F2,
	0x0F120400,
};


/*******************************************************
*	CAMERA_VT_PRETTY_2				*
*******************************************************/
static const u32 s5k5bafx_vt_pretty_2[] =
{
	/* 0xffff000A, */
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000, /* 0000 */
	0x0F12000D, /* 000D */
	0x0F12001B, /* 001B */
	0x0F120055, /* 0050 */
	0x0F1200C0, /* 00B4 */
	0x0F120164, /* 0154 */
	0x0F1201C0, /* 01B8 */
	0x0F120220, /* 0212 */
	0x0F1202A0, /* 0294 */
	0x0F1202F0, /* 02E4 */
	0x0F120365, /* 0352 */
	0x0F1203A0, /* 0398 */
	0x0F1203D4, /* 03D4 */
	0x0F1203E8, /* 03E8 */
	0x0F1203F7, /* 03F7 */
	0x0F120400, /* 0400 */

	0x0F120000, /* 0000 */
	0x0F12000D, /* 000D */
	0x0F12001B, /* 001B */
	0x0F120055, /* 0050 */
	0x0F1200C0, /* 00B4 */
	0x0F120164, /* 0154 */
	0x0F1201C0, /* 01B8 */
	0x0F120220, /* 0212 */
	0x0F1202A0, /* 0294 */
	0x0F1202F0, /* 02E4 */
	0x0F120365, /* 0352 */
	0x0F1203A0, /* 0398 */
	0x0F1203D4, /* 03D4 */
	0x0F1203E8, /* 03E8 */
	0x0F1203F7, /* 03F7 */
	0x0F120400, /* 0400 */

	0x0F120000, /* 0000 */
	0x0F12000D, /* 000D */
	0x0F12001B, /* 001B */
	0x0F120055, /* 0050 */
	0x0F1200C0, /* 00B4 */
	0x0F120164, /* 0154 */
	0x0F1201C0, /* 01B8 */
	0x0F120220, /* 0212 */
	0x0F1202A0, /* 0294 */
	0x0F1202F0, /* 02E4 */
	0x0F120365, /* 0352 */
	0x0F1203A0, /* 0398 */
	0x0F1203D4, /* 03D4 */
	0x0F1203E8, /* 03E8 */
	0x0F1203F7, /* 03F7 */
	0x0F120400, /* 0400 */
};


/*******************************************************
*	CAMERA_VT_PRETTY_3
*******************************************************/
static const u32 s5k5bafx_vt_pretty_3[] =
{
	/* 0xffff000A, */
	0xFCFCD000,
	0x00287000,
	0x002A04CC,

	0x0F120000, /* 0000, 0000,  */
	0x0F12000D, /* 000D, 000D,  */
	0x0F12001B, /* 001B, 001B,  */
	0x0F120064, /* 0064, 0064,  */
	0x0F1200E5, /* 00E5, 00DC,  */
	0x0F120190, /* 95, 0195, 0186,  */
	0x0F1201F5, /* 01F5, 01EA,  */
	0x0F120260, /* 0265, 024E,  */
	0x0F1202E5, /* 02F0, 02DA,  */
	0x0F12032A, /* 30, 0335, 0320,  */
	0x0F12038A, /* 90, 0395, 038E,  */
	0x0F1203C5, /* CA, 03D0, 03CA, / */
	0x0F1203E0, /* E5, 03E8, 03E8,  */
	0x0F1203EC, /* F0, 03F2, 03F2,  */
	0x0F1203F7, /* 03F7, 03F7,  */
	0x0F120400, /* 0400, 0400,  */

	0x0F120000, /* 0000, 0000, 0000,  */
	0x0F12000D, /* 000D, 000D, 000D,  */
	0x0F12001B, /* 001B, 001B, 001B,  */
	0x0F120064, /* 0064, 0064, 0064,  */
	0x0F1200E5, /* 00E5, 00E5, 00DC,  */
	0x0F120190, /* 0195, 0195, 0186,  */
	0x0F1201F5, /* 01F5, 01F5, 01EA,  */
	0x0F120260, /* 0260, 0265, 024E,  */
	0x0F1202E5, /* 02E5, 02F0, 02DA,  */
	0x0F12032A, /* 0330, 0335, 0320,  */
	0x0F12038A, /* 0390, 0395, 038E,  */
	0x0F1203C5, /* 03CA, 03D0, 03CA,  */
	0x0F1203E0, /* 03E5, 03E8, 03E8,  */
	0x0F1203EC, /* 03F0, 03F2, 03F2,  */
	0x0F1203F7, /* 03F7, 03F7, 03F7,  */
	0x0F120400, /* 0400, 0400, 0400,  */

	0x0F120000, /* 0000, 0000, 0000,  */
	0x0F12000D, /* 000D, 000D, 000D,  */
	0x0F12001B, /* 001B, 001B, 001B,  */
	0x0F120064, /* 0064, 0064, 0064,  */
	0x0F1200E5, /* 00E5, 00E5, 00DC,  */
	0x0F120190, /* 0195, 0195, 0186,  */
	0x0F1201F5, /* 01F5, 01F5, 01EA,  */
	0x0F120260, /* 0260, 0265, 024E,  */
	0x0F1202E5, /* 02E5, 02F0, 02DA,  */
	0x0F12032A, /* 0330, 0335, 0320,  */
	0x0F12038A, /* 0390, 0395, 038E,  */
	0x0F1203C5, /* 03CA, 03D0, 03CA,  */
	0x0F1203E0, /* 03E5, 03E8, 03E8,  */
	0x0F1203EC, /* 03F0, 03F2, 03F2,  */
	0x0F1203F7, /* 03F7, 03F7, 03F7,  */
	0x0F120400, /* 0400, 0400, 0400,  */
};

/* Don't delete it. */
static const u32 s5k5bafx_fps_auto[] = {
	0xFCFCD000,
	0x00287000,
};

static const u32 s5k5bafx_fps_7fix[] =
{
	/* Fixed 7fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120535, /* 7fps */
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */

	0xffff0096, /* delay 150ms */

	0x0028D000, /* mipi */
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bafx_fps_10fix[] =
{
	/*  Fixed 10fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F1203E8, /* 10fps */
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync  */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged  */

	0xffff0096, /* delay 150ms */

	0x0028D000, /* mipi */
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bafx_fps_12fix[] =
{
	/*  Fixed 12fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120341, /* 12fps */
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */

	0xffff0096, /* delay 150ms */

	0x0028D000, /* mipi */
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bafx_fps_15fix[] =
{
	/* Fixed 15fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F12029A, /* 15fps*/
	0x0F120000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged  */

	0xffff0096, /* delay 150ms */

	0x0028D000, /*mipi */
	0x002AB0CC,
	0x0F12000B,
};

static const u32 s5k5bafx_fps_25fix[] = {
	/* Fixed 25fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120190, /* 15fps*/
	0x0F120000,
};

#ifdef SUPPORT_FACTORY_TEST
/*******************************************************
*	CAMERA_DTP_ON
*******************************************************/
static const u32 s5k5bafx_pattern_on[] = {
	0xffff01f4, /* Delay 500ms*/

	0xfcfcd000,
	0x00287000,

	0x002A07EC,
	0x0F12FFF0, /* SARR_uNormBrInDoor[0] */
	0x0F12FFF1, /* SARR_uNormBrInDoor[1] */
	0x0F12FFF2, /* SARR_uNormBrInDoor[2] */
	0x0F12FFF3, /* SARR_uNormBrInDoor[3] */
	0x0F12FFF4, /* SARR_uNormBrInDoor[4] */

	0x002A07F6,
	0x0F12FFF0, /* SARR_uNormBrOutDoor[0] */
	0x0F12FFF1, /* SARR_uNormBrOutDoor[1] */
	0x0F12FFF2, /* SARR_uNormBrOutDoor[2] */
	0x0F12FFF3, /* SARR_uNormBrOutDoor[3] */
	0x0F12FFF4, /* SARR_uNormBrOutDoor[4] */

	0xfcfcd000,
	0x0028d000,
	0x002a4100,
	0x0f1208a3, /* gas bypass */
	0x002a6600,
	0x0f120001, /* ccm bypass */
	0x002a6800,
	0x0f120001, /* gamma bypass */
	0x002a4400,
	0x0f120001, /* awb bypass */

	0x00287000,
	0x002A03b6,
	0x0F120001,
	0x002A03ba,
	0x0F120001, /* LEI control */

	0x0028D000,
	0x002A3118,
	0x0F120320, /* Colorbar pattern x size */
	0x0F120258, /* Colorbar pattern y size */
	0x0F120000,
	0x002A3100,
	0x0F120002, /* Colorbar pattern */

	0xffff0032, /* Delay 50msec */
};

/*******************************************************
*	CAMERA_DTP_OFF
*******************************************************/
static const u32 s5k5bafx_pattern_off[] = {

	0xfcfcd000,
	0x00287000,

	0x002A07EC,
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	0x002A07F6,
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */

	0xfcfcd000,
	0x0028d000,
	0x002a4100,
	0x0f1208a2, /* gas bypass */
	0x002a6600,
	0x0f120000, /* ccm bypass */
	0x002a6800,
	0x0f120000, /* gamma bypass */
	0x002a4400,
	0x0f120000, /* awb bypass */

	0x00287000,
	0x002A03F8,
	0x0F120079,

	0xffff012c, /* Delay 300ms */
	0x002A03F8,
	0x0F12007F,

	0x0028D000,
	0x002A3118,
	0x0F120320, /* Colorbar pattern x size */
	0x0F120258, /* Colorbar pattern y size */
	0x0F120000,
	0x002A3100,
	0x0F120000, /* Colorbar pattern */
};
#endif /* SUPPORT_FACTORY_TEST */

#endif /* __S5K5BAFX_SETFILE_H */
