/*
 * Driver for S5K5BAFX 2M ISP from Samsung
 * latest version: 11/09/26
 * 
 * Copyright (C) 2011,
 * DongSeong Lim<dongseong.lim@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
#ifndef __S5K5BAFX_REGS_H
#define __S5K5BAFX_REGS_H

#include <linux/types.h>

/*
 * s5k5bafx register configuration for combinations of initialization
 */
/* 2M mipi setting-common from PARTRON */
/*******************************************************
* Name		: S5K5BAFX Initial Setfile
* PLL mode	: MCLK=24MHz / SYSCLK=28MHz / PCLK=48MHz
* FPS		: VGA 7.5~15fps / UXGA 7.5fps / recording 25fps
* Made by	: ZEROHOY
* Date		: 2011.03.07
* History	:
*******************************************************/
static const u32 s5k5bafx_common[] = {
	/* Self-Cam */
	0xFCFCD000,

	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064,

	/* Trap and Patch */
	0x00287000,
	0x002A1668,
	0x0F12B5FE, /*70001668*/
	0x0F120007, /*7000166A*/
	0x0F12683C, /*7000166C*/
	0x0F12687E, /*7000166E*/
	0x0F121DA5, /*70001670*/
	0x0F1288A0, /*70001672*/
	0x0F122800, /*70001674*/
	0x0F12D00B, /*70001676*/
	0x0F1288A8, /*70001678*/
	0x0F122800, /*7000167A*/
	0x0F12D008, /*7000167C*/
	0x0F128820, /*7000167E*/
	0x0F128829, /*70001680*/
	0x0F124288, /*70001682*/
	0x0F12D301, /*70001684*/
	0x0F121A40, /*70001686*/
	0x0F12E000, /*70001688*/
	0x0F121A08, /*7000168A*/
	0x0F129001, /*7000168C*/
	0x0F12E001, /*7000168E*/
	0x0F122019, /*70001690*/
	0x0F129001, /*70001692*/
	0x0F124916, /*70001694*/
	0x0F12466B, /*70001696*/
	0x0F128A48, /*70001698*/
	0x0F128118, /*7000169A*/
	0x0F128A88, /*7000169C*/
	0x0F128158, /*7000169E*/
	0x0F124814, /*700016A0*/
	0x0F128940, /*700016A2*/
	0x0F120040, /*700016A4*/
	0x0F122103, /*700016A6*/
	0x0F12F000, /*700016A8*/
	0x0F12F826, /*700016AA*/
	0x0F1288A1, /*700016AC*/
	0x0F124288, /*700016AE*/
	0x0F12D908, /*700016B0*/
	0x0F128828, /*700016B2*/
	0x0F128030, /*700016B4*/
	0x0F128868, /*700016B6*/
	0x0F128070, /*700016B8*/
	0x0F1288A8, /*700016BA*/
	0x0F126038, /*700016BC*/
	0x0F12BCFE, /*700016BE*/
	0x0F12BC08, /*700016C0*/
	0x0F124718, /*700016C2*/
	0x0F1288A9, /*700016C4*/
	0x0F124288, /*700016C6*/
	0x0F12D906, /*700016C8*/
	0x0F128820, /*700016CA*/
	0x0F128030, /*700016CC*/
	0x0F128860, /*700016CE*/
	0x0F128070, /*700016D0*/
	0x0F1288A0, /*700016D2*/
	0x0F126038, /*700016D4*/
	0x0F12E7F2, /*700016D6*/
	0x0F129801, /*700016D8*/
	0x0F12A902, /*700016DA*/
	0x0F12F000, /*700016DC*/
	0x0F12F812, /*700016DE*/
	0x0F120033, /*700016E0*/
	0x0F120029, /*700016E2*/
	0x0F129A02, /*700016E4*/
	0x0F120020, /*700016E6*/
	0x0F12F000, /*700016E8*/
	0x0F12F814, /*700016EA*/
	0x0F126038, /*700016EC*/
	0x0F12E7E6, /*700016EE*/
	0x0F121A28, /*700016F0*/
	0x0F127000, /*700016F2*/
	0x0F120D64, /*700016F4*/
	0x0F127000, /*700016F6*/
	0x0F124778, /*700016F8*/
	0x0F1246C0, /*700016FA*/
	0x0F12F004, /*700016FC*/
	0x0F12E51F, /*700016FE*/
	0x0F12A464, /*70001700*/
	0x0F120000, /*70001702*/
	0x0F124778, /*70001704*/
	0x0F1246C0, /*70001706*/
	0x0F12C000, /*70001708*/
	0x0F12E59F, /*7000170A*/
	0x0F12FF1C, /*7000170C*/
	0x0F12E12F, /*7000170E*/
	0x0F126009, /*70001710*/
	0x0F120000, /*70001712*/
	0x0F124778, /*70001714*/
	0x0F1246C0, /*70001716*/
	0x0F12C000, /*70001718*/
	0x0F12E59F, /*7000171A*/
	0x0F12FF1C, /*7000171C*/
	0x0F12E12F, /*7000171E*/
	0x0F12622F, /*70001720*/
	0x0F120000, /*70001722*/
	0x002A2080,
	0x0F12B510, /*70002080*/
	0x0F12F000, /*70002082*/
	0x0F12F8F4, /*70002084*/
	0x0F12BC10, /*70002086*/
	0x0F12BC08, /*70002088*/
	0x0F124718, /*7000208A*/
	0x0F12B5F0, /*7000208C*/
	0x0F12B08B, /*7000208E*/
	0x0F120006, /*70002090*/
	0x0F122000, /*70002092*/
	0x0F129004, /*70002094*/
	0x0F126835, /*70002096*/
	0x0F126874, /*70002098*/
	0x0F1268B0, /*7000209A*/
	0x0F12900A, /*7000209C*/
	0x0F1268F0, /*7000209E*/
	0x0F129009, /*700020A0*/
	0x0F124F7D, /*700020A2*/
	0x0F128979, /*700020A4*/
	0x0F12084A, /*700020A6*/
	0x0F1288A8, /*700020A8*/
	0x0F1288A3, /*700020AA*/
	0x0F124298, /*700020AC*/
	0x0F12D300, /*700020AE*/
	0x0F120018, /*700020B0*/
	0x0F12F000, /*700020B2*/
	0x0F12F907, /*700020B4*/
	0x0F129007, /*700020B6*/
	0x0F120021, /*700020B8*/
	0x0F120028, /*700020BA*/
	0x0F12AA04, /*700020BC*/
	0x0F12F000, /*700020BE*/
	0x0F12F909, /*700020C0*/
	0x0F129006, /*700020C2*/
	0x0F1288A8, /*700020C4*/
	0x0F122800, /*700020C6*/
	0x0F12D102, /*700020C8*/
	0x0F1227FF, /*700020CA*/
	0x0F121C7F, /*700020CC*/
	0x0F12E047, /*700020CE*/
	0x0F1288A0, /*700020D0*/
	0x0F122800, /*700020D2*/
	0x0F12D101, /*700020D4*/
	0x0F122700, /*700020D6*/
	0x0F12E042, /*700020D8*/
	0x0F128820, /*700020DA*/
	0x0F12466B, /*700020DC*/
	0x0F128198, /*700020DE*/
	0x0F128860, /*700020E0*/
	0x0F1281D8, /*700020E2*/
	0x0F128828, /*700020E4*/
	0x0F128118, /*700020E6*/
	0x0F128868, /*700020E8*/
	0x0F128158, /*700020EA*/
	0x0F12A802, /*700020EC*/
	0x0F12C803, /*700020EE*/
	0x0F12F000, /*700020F0*/
	0x0F12F8F8, /*700020F2*/
	0x0F129008, /*700020F4*/
	0x0F128ABA, /*700020F6*/
	0x0F129808, /*700020F8*/
	0x0F12466B, /*700020FA*/
	0x0F124342, /*700020FC*/
	0x0F129202, /*700020FE*/
	0x0F128820, /*70002100*/
	0x0F128198, /*70002102*/
	0x0F128860, /*70002104*/
	0x0F1281D8, /*70002106*/
	0x0F12980A, /*70002108*/
	0x0F129903, /*7000210A*/
	0x0F12F000, /*7000210C*/
	0x0F12F8EA, /*7000210E*/
	0x0F129A02, /*70002110*/
	0x0F1217D1, /*70002112*/
	0x0F120E09, /*70002114*/
	0x0F121889, /*70002116*/
	0x0F121209, /*70002118*/
	0x0F124288, /*7000211A*/
	0x0F12DD1F, /*7000211C*/
	0x0F128820, /*7000211E*/
	0x0F12466B, /*70002120*/
	0x0F128198, /*70002122*/
	0x0F128860, /*70002124*/
	0x0F1281D8, /*70002126*/
	0x0F12980A, /*70002128*/
	0x0F129903, /*7000212A*/
	0x0F12F000, /*7000212C*/
	0x0F12F8DA, /*7000212E*/
	0x0F129001, /*70002130*/
	0x0F128828, /*70002132*/
	0x0F12466B, /*70002134*/
	0x0F128118, /*70002136*/
	0x0F128868, /*70002138*/
	0x0F128158, /*7000213A*/
	0x0F12980A, /*7000213C*/
	0x0F129902, /*7000213E*/
	0x0F12F000, /*70002140*/
	0x0F12F8D0, /*70002142*/
	0x0F128AB9, /*70002144*/
	0x0F129A08, /*70002146*/
	0x0F124351, /*70002148*/
	0x0F1217CA, /*7000214A*/
	0x0F120E12, /*7000214C*/
	0x0F121851, /*7000214E*/
	0x0F12120A, /*70002150*/
	0x0F129901, /*70002152*/
	0x0F12F000, /*70002154*/
	0x0F12F8B6, /*70002156*/
	0x0F120407, /*70002158*/
	0x0F120C3F, /*7000215A*/
	0x0F12E000, /*7000215C*/
	0x0F122700, /*7000215E*/
	0x0F128820, /*70002160*/
	0x0F12466B, /*70002162*/
	0x0F12AA05, /*70002164*/
	0x0F128198, /*70002166*/
	0x0F128860, /*70002168*/
	0x0F1281D8, /*7000216A*/
	0x0F128828, /*7000216C*/
	0x0F128118, /*7000216E*/
	0x0F128868, /*70002170*/
	0x0F128158, /*70002172*/
	0x0F12A802, /*70002174*/
	0x0F12C803, /*70002176*/
	0x0F12003B, /*70002178*/
	0x0F12F000, /*7000217A*/
	0x0F12F8BB, /*7000217C*/
	0x0F1288A1, /*7000217E*/
	0x0F1288A8, /*70002180*/
	0x0F12003A, /*70002182*/
	0x0F12F000, /*70002184*/
	0x0F12F8BE, /*70002186*/
	0x0F120004, /*70002188*/
	0x0F12A804, /*7000218A*/
	0x0F12C803, /*7000218C*/
	0x0F129A09, /*7000218E*/
	0x0F129B07, /*70002190*/
	0x0F12F000, /*70002192*/
	0x0F12F8AF, /*70002194*/
	0x0F12A806, /*70002196*/
	0x0F12C805, /*70002198*/
	0x0F120021, /*7000219A*/
	0x0F12F000, /*7000219C*/
	0x0F12F8B2, /*7000219E*/
	0x0F126030, /*700021A0*/
	0x0F12B00B, /*700021A2*/
	0x0F12BCF0, /*700021A4*/
	0x0F12BC08, /*700021A6*/
	0x0F124718, /*700021A8*/
	0x0F12B5F1, /*700021AA*/
	0x0F129900, /*700021AC*/
	0x0F12680C, /*700021AE*/
	0x0F12493A, /*700021B0*/
	0x0F12694B, /*700021B2*/
	0x0F12698A, /*700021B4*/
	0x0F124694, /*700021B6*/
	0x0F1269CD, /*700021B8*/
	0x0F126A0E, /*700021BA*/
	0x0F124F38, /*700021BC*/
	0x0F1242BC, /*700021BE*/
	0x0F12D800, /*700021C0*/
	0x0F120027, /*700021C2*/
	0x0F124937, /*700021C4*/
	0x0F126B89, /*700021C6*/
	0x0F120409, /*700021C8*/
	0x0F120C09, /*700021CA*/
	0x0F124A35, /*700021CC*/
	0x0F121E92, /*700021CE*/
	0x0F126BD2, /*700021D0*/
	0x0F120412, /*700021D2*/
	0x0F120C12, /*700021D4*/
	0x0F12429F, /*700021D6*/
	0x0F12D801, /*700021D8*/
	0x0F120020, /*700021DA*/
	0x0F12E031, /*700021DC*/
	0x0F12001F, /*700021DE*/
	0x0F12434F, /*700021E0*/
	0x0F120A3F, /*700021E2*/
	0x0F1242A7, /*700021E4*/
	0x0F12D301, /*700021E6*/
	0x0F120018, /*700021E8*/
	0x0F12E02A, /*700021EA*/
	0x0F12002B, /*700021EC*/
	0x0F12434B, /*700021EE*/
	0x0F120A1B, /*700021F0*/
	0x0F1242A3, /*700021F2*/
	0x0F12D303, /*700021F4*/
	0x0F120220, /*700021F6*/
	0x0F12F000, /*700021F8*/
	0x0F12F88C, /*700021FA*/
	0x0F12E021, /*700021FC*/
	0x0F120029, /*700021FE*/
	0x0F124351, /*70002200*/
	0x0F120A09, /*70002202*/
	0x0F1242A1, /*70002204*/
	0x0F12D301, /*70002206*/
	0x0F120028, /*70002208*/
	0x0F12E01A, /*7000220A*/
	0x0F120031, /*7000220C*/
	0x0F124351, /*7000220E*/
	0x0F120A09, /*70002210*/
	0x0F1242A1, /*70002212*/
	0x0F12D304, /*70002214*/
	0x0F120220, /*70002216*/
	0x0F120011, /*70002218*/
	0x0F12F000, /*7000221A*/
	0x0F12F87B, /*7000221C*/
	0x0F12E010, /*7000221E*/
	0x0F12491E, /*70002220*/
	0x0F128C89, /*70002222*/
	0x0F12000A, /*70002224*/
	0x0F124372, /*70002226*/
	0x0F120A12, /*70002228*/
	0x0F1242A2, /*7000222A*/
	0x0F12D301, /*7000222C*/
	0x0F120030, /*7000222E*/
	0x0F12E007, /*70002230*/
	0x0F124662, /*70002232*/
	0x0F12434A, /*70002234*/
	0x0F120A12, /*70002236*/
	0x0F1242A2, /*70002238*/
	0x0F12D302, /*7000223A*/
	0x0F120220, /*7000223C*/
	0x0F12F000, /*7000223E*/
	0x0F12F869, /*70002240*/
	0x0F124B16, /*70002242*/
	0x0F124D18, /*70002244*/
	0x0F128D99, /*70002246*/
	0x0F121FCA, /*70002248*/
	0x0F123AF9, /*7000224A*/
	0x0F12D00A, /*7000224C*/
	0x0F122001, /*7000224E*/
	0x0F120240, /*70002250*/
	0x0F128468, /*70002252*/
	0x0F120220, /*70002254*/
	0x0F12F000, /*70002256*/
	0x0F12F85D, /*70002258*/
	0x0F129900, /*7000225A*/
	0x0F126008, /*7000225C*/
	0x0F12BCF8, /*7000225E*/
	0x0F12BC08, /*70002260*/
	0x0F124718, /*70002262*/
	0x0F128D19, /*70002264*/
	0x0F128469, /*70002266*/
	0x0F129900, /*70002268*/
	0x0F126008, /*7000226A*/
	0x0F12E7F7, /*7000226C*/
	0x0F12B570, /*7000226E*/
	0x0F122200, /*70002270*/
	0x0F12490E, /*70002272*/
	0x0F12480E, /*70002274*/
	0x0F122401, /*70002276*/
	0x0F12F000, /*70002278*/
	0x0F12F852, /*7000227A*/
	0x0F120022, /*7000227C*/
	0x0F12490D, /*7000227E*/
	0x0F12480D, /*70002280*/
	0x0F122502, /*70002282*/
	0x0F12F000, /*70002284*/
	0x0F12F84C, /*70002286*/
	0x0F12490C, /*70002288*/
	0x0F12480D, /*7000228A*/
	0x0F12002A, /*7000228C*/
	0x0F12F000, /*7000228E*/
	0x0F12F847, /*70002290*/
	0x0F12BC70, /*70002292*/
	0x0F12BC08, /*70002294*/
	0x0F124718, /*70002296*/
	0x0F120D64, /*70002298*/
	0x0F127000, /*7000229A*/
	0x0F120470, /*7000229C*/
	0x0F127000, /*7000229E*/
	0x0F12A120, /*700022A0*/
	0x0F120007, /*700022A2*/
	0x0F120402, /*700022A4*/
	0x0F127000, /*700022A6*/
	0x0F1214A0, /*700022A8*/
	0x0F127000, /*700022AA*/
	0x0F12208D, /*700022AC*/
	0x0F127000, /*700022AE*/
	0x0F12622F, /*700022B0*/
	0x0F120000, /*700022B2*/
	0x0F121669, /*700022B4*/
	0x0F127000, /*700022B6*/
	0x0F126445, /*700022B8*/
	0x0F120000, /*700022BA*/
	0x0F1221AB, /*700022BC*/
	0x0F127000, /*700022BE*/
	0x0F122AA9, /*700022C0*/
	0x0F120000, /*700022C2*/
	0x0F124778, /*700022C4*/
	0x0F1246C0, /*700022C6*/
	0x0F12C000, /*700022C8*/
	0x0F12E59F, /*700022CA*/
	0x0F12FF1C, /*700022CC*/
	0x0F12E12F, /*700022CE*/
	0x0F125F49, /*700022D0*/
	0x0F120000, /*700022D2*/
	0x0F124778, /*700022D4*/
	0x0F1246C0, /*700022D6*/
	0x0F12C000, /*700022D8*/
	0x0F12E59F, /*700022DA*/
	0x0F12FF1C, /*700022DC*/
	0x0F12E12F, /*700022DE*/
	0x0F125FC7, /*700022E0*/
	0x0F120000, /*700022E2*/
	0x0F124778, /*700022E4*/
	0x0F1246C0, /*700022E6*/
	0x0F12C000, /*700022E8*/
	0x0F12E59F, /*700022EA*/
	0x0F12FF1C, /*700022EC*/
	0x0F12E12F, /*700022EE*/
	0x0F125457, /*700022F0*/
	0x0F120000, /*700022F2*/
	0x0F124778, /*700022F4*/
	0x0F1246C0, /*700022F6*/
	0x0F12C000, /*700022F8*/
	0x0F12E59F, /*700022FA*/
	0x0F12FF1C, /*700022FC*/
	0x0F12E12F, /*700022FE*/
	0x0F125FA3, /*70002300*/
	0x0F120000, /*70002302*/
	0x0F124778, /*70002304*/
	0x0F1246C0, /*70002306*/
	0x0F12C000, /*70002308*/
	0x0F12E59F, /*7000230A*/
	0x0F12FF1C, /*7000230C*/
	0x0F12E12F, /*7000230E*/
	0x0F1251F9, /*70002310*/
	0x0F120000, /*70002312*/
	0x0F124778, /*70002314*/
	0x0F1246C0, /*70002316*/
	0x0F12F004, /*70002318*/
	0x0F12E51F, /*7000231A*/
	0x0F12A464, /*7000231C*/
	0x0F120000, /*7000231E*/
	0x0F124778, /*70002320*/
	0x0F1246C0, /*70002322*/
	0x0F12C000, /*70002324*/
	0x0F12E59F, /*70002326*/
	0x0F12FF1C, /*70002328*/
	0x0F12E12F, /*7000232A*/
	0x0F12A007, /*7000232C*/
	0x0F120000, /*7000232E*/
	0x0F126546, /*70002330*/
	0x0F122062, /*70002332*/
	0x0F123120, /*70002334*/
	0x0F123220, /*70002336*/
	0x0F123130, /*70002338*/
	0x0F120030, /*7000233A*/
	0x0F12E010, /*7000233C*/
	0x0F120208, /*7000233E*/
	0x0F120058, /*70002340*/
	0x0F120000, /*70002342*/
	/* End of Trap and Patch
	Total Size 896 (0x0380)*/

	0x0028D000,
	0x002A1000,
	0x0F120001,


	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,


	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,


	0x00287000,
	0x002A0ADC,
	0x0F120AF0,
	0x002A0AE2,
	0x0F12222E,

	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	0x002A049A,
	0x0F1200FA,

	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,

	0x002AC202,
	0x0F120700,

	0x002AF260,
	0x0F120001,

	0x002AF414,
	0x0F120030,
                                                                       
	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,

	0x002AF700,
	0x0F120040,

	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,

	0x0F120015,

	0x0F120001,
	0x0F120040,

	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,
                                                                                                             
	0x002AF900,
	0x0F120067,
                                                                                                             
	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,
                                                                                                             
	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,
                                                                                                             
	0x002AF41A,
	0x0F1200FF,
	0x0F120003,

	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,

	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,
                                                                                
	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,
                                                                                
	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,
                                                                                
	0x002AF4D6,
	0x0F120090,

	0x0F120000,

	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,

	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,

	0x002AF418,
	0x0F120083,

	0x002AF454,
	0x0F120001,

	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,

	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,
	
	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,

	/* CFPN Canceller*/
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,
                                                                        
	0x002A10EE,
	0x0F120000,

	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,

	0x002A1150,
	0x0F1201F4,


	0x002A1084,
	0x0F120000,
	0x0F120000,

	/* Set AE Target */
	0x002A0F4C,
	0x0F12003C, /* 3c-- */

	0x002A0478,
	0x0F120114,
	0x0F1200FB, /* 0EB */

	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A,
	0x0F120000,
	0x002A048C,
	0x0F128214,
	0x0F120000,
	0x0F12A122,
	0x0F120000,
	0x002A0488,
	0x0F12f424,
	0x0F120000,
	0x002A043A,
	0x0F120200,
	0x0F120200,
	0x002A0494,
	0x0F120340,
	0x0F120600,
	0x0f120100,
	0x002A0F52,
	0x0F12000F,

	0x002A0E98,
	0x0F1202A8,
	0x002A0E9E,
	0x0F120298,

	/*1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001,
	0x002A03F8,
	0x0F12007F,

	0xffff000a, /* Wait10mSec */

	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0,
	0x0F120000,

	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001,
	0x0F120001,
	0x0F120000,

	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770,
	0x0F122EE0,
	0x0F122EE0,

	/* System Clock 1 (System : 28Mhz, PCLK : 48Mhz)*/
	0x002A01D2,
	0x0F121B58,
	0x0F122EE0,
	0x0F122EE0,

	0x002A01DE,
	0x0F120001,
	0x0F120001,
	0xffff0064, /* 100ms Delay */

	/* Crop */
	0x002A01FA,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,

	/* Set Preview Config */
	/* Preview Config 0 (1600x1200 fixed 15fps)*/
	0x002A0242,
#if 0
	/*++ 640x480 */
	/* 0x0F120280, */ /* REG_0TC_PCFG_usWidth */
	/* 0x0F1201E0, */ /* REG_0TC_PCFG_usHeight */
	/*-- 640x480 */
#else
	/*++ 800x600 */
	0x0F120320, /* REG_0TC_PCFG_usWidth */
	0x0F120258, /* REG_0TC_PCFG_usHeight */
	/*-- 800x600 */
#endif
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F120535,
	0x0F12029A,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps)*/
	0x002A0268,
#if 0
	/*++ 640x480 */
	/* 0x0F120280, */ /* REG_1TC_PCFG_usWidth */
	/* 0x0F1201E0, */ /* REG_1TC_PCFG_usHeight */
	/*-- 640x480 */
#else
	/*++ 800x600 */
	0x0F120320, /* REG_1TC_PCFG_usWidth */
	0x0F120258, /* REG_1TC_PCFG_usHeight */
	/*-- 800x600 */
#endif
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F12029A,
	0x0F12014D,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	/* Set MIPI */
	0x002A03AC,
	0x0F120000,
	0x002A03F2,
	0x0F120001,
	0x0F1200C3,
	0x0F120001,

	/* Apply preview config */
	/* 0x002A021C, */
	/* 0x0F120000, */
	/* 0x002A0220, */
	/* 0x0F120001, */
	/* 0x002A01F8, */
	/* 0x0F120001, */
	/* 0x002A021E, */
	/* 0x0F120001, */
	/* 0x002A01F0, */
	/* 0x0F120001, */
	/* 0x0F120001, */

	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000,
	0x0F120640,
	0x0F1204B0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120002,
	0x0F120002,
	0x0F120535,
	0x0F120535,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A07C0,
	0x0F120004,
	0x0F120004,

	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,

	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120201,   /*0302     0101*/
	0x0F120102,   /*0203     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120302,   /*0403     0101*/
	0x0F120203,   /*0304     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120302,   /*0403     0101*/
	0x0F120203,   /*0304     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120201,   /*0302     0101*/
	0x0F120102,   /*0203     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/


	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord*/
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,

	/* param_start	wbt_AwbCcmCord*/
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,


	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,

	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /*00E0 TVAR_ash_GASAlpha[0]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[1]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[2]  */
	0x0F1200F0, /*0100 TVAR_ash_GASAlpha[3]  */

	0x0F1200F8, /*00F0 TVAR_ash_GASAlpha[4]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[5]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[6]  */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[7]  */

	0x0F1200F8, /*00F0 TVAR_ash_GASAlpha[8]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[9]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[10] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[11] */

	0x0F1200F8, /*00F8 TVAR_ash_GASAlpha[12] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[13] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[14] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[15] */

	0x0F1200F8, /*00F8 TVAR_ash_GASAlpha[16] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[17] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[18] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[19] */

	0x0F120100, /*0100 TVAR_ash_GASAlpha[20] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[21] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[22] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[23] */

	0x0F120100, /*0100 TVAR_ash_GASAlpha[24] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[25] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[26] */
	0x0F1200F0, /*00E8 TVAR_ash_GASAlpha[27] */

	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* 100 TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_ */
	0x0F1200F8, /* TVAR_ash_GASOutdoorAlpha_3_ */

	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,

	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120198,
	0x0F120176,
	0x0F120140,
	0x0F12010B,
	0x0F1200E7,
	0x0F1200D0,
	0x0F1200C6,
	0x0F1200CE,
	0x0F1200E4,
	0x0F120109,
	0x0F12013A,
	0x0F12016D,
	0x0F120199,
	0x0F120175,
	0x0F12013C,
	0x0F120105,
	0x0F1200D3,
	0x0F1200AC,
	0x0F120093,
	0x0F12008A,
	0x0F120091,
	0x0F1200AA,
	0x0F1200D0,
	0x0F120102,
	0x0F12013E,
	0x0F120171,
	0x0F12014F,
	0x0F12010C,
	0x0F1200CF,
	0x0F12009A,
	0x0F120070,
	0x0F120055,
	0x0F12004C,
	0x0F120055,
	0x0F12006F,
	0x0F12009A,
	0x0F1200CF,
	0x0F12010E,
	0x0F12014D,
	0x0F120130,
	0x0F1200E9,
	0x0F1200A7,
	0x0F120070,
	0x0F120045,
	0x0F12002A,
	0x0F120020,
	0x0F12002A,
	0x0F120045,
	0x0F120071,
	0x0F1200AA,
	0x0F1200E8,
	0x0F12012E,
	0x0F12011C,
	0x0F1200D7,
	0x0F120091,
	0x0F120057,
	0x0F12002D,
	0x0F120012,
	0x0F12000A,
	0x0F120013,
	0x0F12002F,
	0x0F12005B,
	0x0F120094,
	0x0F1200D6,
	0x0F120119,
	0x0F120116,
	0x0F1200D0,
	0x0F12008C,
	0x0F12004F,
	0x0F120024,
	0x0F12000A,
	0x0F120000,
	0x0F12000A,
	0x0F120027,
	0x0F120054,
	0x0F120090,
	0x0F1200D1,
	0x0F120113,
	0x0F12011D,
	0x0F1200D7,
	0x0F120095,
	0x0F120057,
	0x0F12002B,
	0x0F120011,
	0x0F120008,
	0x0F120012,
	0x0F120030,
	0x0F12005C,
	0x0F120099,
	0x0F1200DA,
	0x0F12011D,
	0x0F120133,
	0x0F1200EF,
	0x0F1200AC,
	0x0F12006F,
	0x0F120043,
	0x0F120028,
	0x0F12001F,
	0x0F12002A,
	0x0F120047,
	0x0F120077,
	0x0F1200B1,
	0x0F1200F2,
	0x0F120135,
	0x0F120153,
	0x0F120113,
	0x0F1200D2,
	0x0F120098,
	0x0F12006A,
	0x0F12004E,
	0x0F120046,
	0x0F120053,
	0x0F120070,
	0x0F12009E,
	0x0F1200D7,
	0x0F120117,
	0x0F120155,
	0x0F12017B,
	0x0F120141,
	0x0F120100,
	0x0F1200C9,
	0x0F1200A0,
	0x0F120086,
	0x0F120080,
	0x0F12008A,
	0x0F1200A5,
	0x0F1200CF,
	0x0F120108,
	0x0F120144,
	0x0F12017B,
	0x0F12019F,
	0x0F120171,
	0x0F120133,
	0x0F1200FC,
	0x0F1200D5,
	0x0F1200BC,
	0x0F1200B5,
	0x0F1200BF,
	0x0F1200D8,
	0x0F120105,
	0x0F12013A,
	0x0F12016F,
	0x0F12019D,
	0x0F120149,
	0x0F12012C,
	0x0F1200FC,
	0x0F1200CE,
	0x0F1200AE,
	0x0F12009A,
	0x0F120092,
	0x0F120096,
	0x0F1200A6,
	0x0F1200C3,
	0x0F1200E9,
	0x0F120116,
	0x0F120135,
	0x0F120131,
	0x0F1200FE,
	0x0F1200CE,
	0x0F1200A3,
	0x0F120082,
	0x0F12006D,
	0x0F120066,
	0x0F12006B,
	0x0F12007B,
	0x0F120096,
	0x0F1200BF,
	0x0F1200EF,
	0x0F12011A,
	0x0F120117,
	0x0F1200D8,
	0x0F1200A2,
	0x0F120077,
	0x0F120058,
	0x0F120043,
	0x0F12003A,
	0x0F120041,
	0x0F120052,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200FC,
	0x0F1200FF,
	0x0F1200BC,
	0x0F120084,
	0x0F120058,
	0x0F120038,
	0x0F120023,
	0x0F12001A,
	0x0F120021,
	0x0F120035,
	0x0F120052,
	0x0F12007A,
	0x0F1200AB,
	0x0F1200E2,
	0x0F1200EF,
	0x0F1200AE,
	0x0F120072,
	0x0F120046,
	0x0F120025,
	0x0F120010,
	0x0F120009,
	0x0F12000F,
	0x0F120023,
	0x0F120040,
	0x0F12006A,
	0x0F120099,
	0x0F1200CF,
	0x0F1200E7,
	0x0F1200AA,
	0x0F12006E,
	0x0F12003F,
	0x0F12001E,
	0x0F120009,
	0x0F120000,
	0x0F120007,
	0x0F12001B,
	0x0F12003A,
	0x0F120064,
	0x0F120093,
	0x0F1200C9,
	0x0F1200EC,
	0x0F1200B0,
	0x0F120075,
	0x0F120045,
	0x0F120023,
	0x0F12000E,
	0x0F120006,
	0x0F12000D,
	0x0F120021,
	0x0F12003E,
	0x0F120068,
	0x0F120097,
	0x0F1200CD,
	0x0F1200FD,
	0x0F1200C0,
	0x0F120088,
	0x0F120057,
	0x0F120035,
	0x0F120020,
	0x0F120018,
	0x0F12001F,
	0x0F120032,
	0x0F12004F,
	0x0F120077,
	0x0F1200A6,
	0x0F1200DD,
	0x0F120116,
	0x0F1200DA,
	0x0F1200A3,
	0x0F120075,
	0x0F120052,
	0x0F12003C,
	0x0F120034,
	0x0F12003C,
	0x0F12004E,
	0x0F12006A,
	0x0F120090,
	0x0F1200C0,
	0x0F1200F4,
	0x0F120132,
	0x0F1200FD,
	0x0F1200C5,
	0x0F12009A,
	0x0F120078,
	0x0F120065,
	0x0F12005F,
	0x0F120064,
	0x0F120073,
	0x0F12008C,
	0x0F1200B3,
	0x0F1200E1,
	0x0F12010E,
	0x0F120150,
	0x0F120122,
	0x0F1200ED,
	0x0F1200C1,
	0x0F1200A1,
	0x0F12008B,
	0x0F120082,
	0x0F120087,
	0x0F120096,
	0x0F1200B3,
	0x0F1200DB,
	0x0F120102,
	0x0F12012D,
	0x0F120149,
	0x0F12012C,
	0x0F1200FC,
	0x0F1200CE,
	0x0F1200AE,
	0x0F12009A,
	0x0F120092,
	0x0F120096,
	0x0F1200A6,
	0x0F1200C3,
	0x0F1200E9,
	0x0F120116,
	0x0F120135,
	0x0F120131,
	0x0F1200FE,
	0x0F1200CE,
	0x0F1200A3,
	0x0F120082,
	0x0F12006D,
	0x0F120066,
	0x0F12006B,
	0x0F12007B,
	0x0F120096,
	0x0F1200BF,
	0x0F1200EF,
	0x0F12011A,
	0x0F120117,
	0x0F1200D8,
	0x0F1200A2,
	0x0F120077,
	0x0F120058,
	0x0F120043,
	0x0F12003A,
	0x0F120041,
	0x0F120052,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200FC,
	0x0F1200FF,
	0x0F1200BC,
	0x0F120084,
	0x0F120058,
	0x0F120038,
	0x0F120023,
	0x0F12001A,
	0x0F120021,
	0x0F120035,
	0x0F120052,
	0x0F12007A,
	0x0F1200AB,
	0x0F1200E2,
	0x0F1200EF,
	0x0F1200AE,
	0x0F120072,
	0x0F120046,
	0x0F120025,
	0x0F120010,
	0x0F120009,
	0x0F12000F,
	0x0F120023,
	0x0F120040,
	0x0F12006A,
	0x0F120099,
	0x0F1200CF,
	0x0F1200E7,
	0x0F1200AA,
	0x0F12006E,
	0x0F12003F,
	0x0F12001E,
	0x0F120009,
	0x0F120000,
	0x0F120007,
	0x0F12001B,
	0x0F12003A,
	0x0F120064,
	0x0F120093,
	0x0F1200C9,
	0x0F1200EC,
	0x0F1200B0,
	0x0F120075,
	0x0F120045,
	0x0F120023,
	0x0F12000E,
	0x0F120006,
	0x0F12000D,
	0x0F120021,
	0x0F12003E,
	0x0F120068,
	0x0F120097,
	0x0F1200CD,
	0x0F1200FD,
	0x0F1200C0,
	0x0F120088,
	0x0F120057,
	0x0F120035,
	0x0F120020,
	0x0F120018,
	0x0F12001F,
	0x0F120032,
	0x0F12004F,
	0x0F120077,
	0x0F1200A6,
	0x0F1200DD,
	0x0F120116,
	0x0F1200DA,
	0x0F1200A3,
	0x0F120075,
	0x0F120052,
	0x0F12003C,
	0x0F120034,
	0x0F12003C,
	0x0F12004E,
	0x0F12006A,
	0x0F120090,
	0x0F1200C0,
	0x0F1200F4,
	0x0F120132,
	0x0F1200FD,
	0x0F1200C5,
	0x0F12009A,
	0x0F120078,
	0x0F120065,
	0x0F12005F,
	0x0F120064,
	0x0F120073,
	0x0F12008C,
	0x0F1200B3,
	0x0F1200E1,
	0x0F12010E,
	0x0F120150,
	0x0F120122,
	0x0F1200ED,
	0x0F1200C1,
	0x0F1200A1,
	0x0F12008B,
	0x0F120082,
	0x0F120087,
	0x0F120096,
	0x0F1200B3,
	0x0F1200DB,
	0x0F120102,
	0x0F12012D,
	0x0F120100,
	0x0F1200EC,
	0x0F1200C4,
	0x0F1200A2,
	0x0F120089,
	0x0F12007C,
	0x0F12007A,
	0x0F120082,
	0x0F120094,
	0x0F1200B0,
	0x0F1200D5,
	0x0F120102,
	0x0F120124,
	0x0F1200E9,
	0x0F1200BF,
	0x0F12009C,
	0x0F12007F,
	0x0F120068,
	0x0F12005A,
	0x0F120057,
	0x0F12005F,
	0x0F120071,
	0x0F12008A,
	0x0F1200AF,
	0x0F1200DC,
	0x0F120109,
	0x0F1200D1,
	0x0F12009E,
	0x0F120077,
	0x0F12005B,
	0x0F120044,
	0x0F120036,
	0x0F120031,
	0x0F12003A,
	0x0F12004D,
	0x0F120068,
	0x0F12008B,
	0x0F1200B6,
	0x0F1200E7,
	0x0F1200BC,
	0x0F120088,
	0x0F12005E,
	0x0F12003F,
	0x0F120029,
	0x0F12001B,
	0x0F120016,
	0x0F12001F,
	0x0F120032,
	0x0F12004D,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200AF,
	0x0F12007C,
	0x0F120050,
	0x0F120030,
	0x0F12001B,
	0x0F12000C,
	0x0F120007,
	0x0F12000E,
	0x0F120021,
	0x0F120039,
	0x0F12005C,
	0x0F120084,
	0x0F1200B4,
	0x0F1200AA,
	0x0F120079,
	0x0F12004E,
	0x0F12002C,
	0x0F120014,
	0x0F120005,
	0x0F120000,
	0x0F120006,
	0x0F120018,
	0x0F120031,
	0x0F120053,
	0x0F120079,
	0x0F1200A9,
	0x0F1200AD,
	0x0F12007F,
	0x0F120055,
	0x0F120031,
	0x0F12001A,
	0x0F12000A,
	0x0F120004,
	0x0F12000B,
	0x0F12001B,
	0x0F120031,
	0x0F120052,
	0x0F120078,
	0x0F1200A6,
	0x0F1200BB,
	0x0F12008D,
	0x0F120065,
	0x0F120042,
	0x0F120029,
	0x0F12001A,
	0x0F120015,
	0x0F12001A,
	0x0F120028,
	0x0F120040,
	0x0F12005D,
	0x0F120084,
	0x0F1200B4,
	0x0F1200D5,
	0x0F1200A7,
	0x0F12007E,
	0x0F12005E,
	0x0F120043,
	0x0F120033,
	0x0F12002E,
	0x0F120033,
	0x0F120040,
	0x0F120056,
	0x0F120073,
	0x0F120099,
	0x0F1200C8,
	0x0F1200F5,
	0x0F1200C8,
	0x0F12009E,
	0x0F12007F,
	0x0F120067,
	0x0F120058,
	0x0F120056,
	0x0F120058,
	0x0F120062,
	0x0F120074,
	0x0F120092,
	0x0F1200B9,
	0x0F1200E4,
	0x0F120113,
	0x0F1200ED,
	0x0F1200C3,
	0x0F1200A1,
	0x0F12008A,
	0x0F12007A,
	0x0F120074,
	0x0F120077,
	0x0F120081,
	0x0F120097,
	0x0F1200B6,
	0x0F1200DA,
	0x0F120102,

	/* Gamma */
	0x002A04CC,
	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F120055,
	0x0F1200F2, /*0F2*/
	0x0F120148, /*148*/
	0x0F12018E, /*18A*/
	0x0F1201F6,
	0x0F12024A,
	0x0F1202CC,
	0x0F120338,
	0x0F12038C,
	0x0F1203C6,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F120055,
	0x0F1200F2, /*0F2*/
	0x0F120148, /*148*/
	0x0F12018E, /*18A*/
	0x0F1201F6,
	0x0F12024A,
	0x0F1202CC,
	0x0F120338,
	0x0F12038C,
	0x0F1203C6,
	0x0F1203EA,
	0x0F1203FF,

	0x0F120000,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F120055,
	0x0F1200F2, /*0F2*/
	0x0F120148, /*148*/
	0x0F12018E, /*18A*/
	0x0F1201F6,
	0x0F12024A,
	0x0F1202CC,
	0x0F120338,
	0x0F12038C,
	0x0F1203C6,
	0x0F1203EA,
	0x0F1203FF,

	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone	       */
	0x0F120000, /* awbb_LowBr0_NBzone       */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv       */

	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F1203B4, /*03B4 038F awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F1203BE, /*03C0 039B awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F12039A, /*037C 0373 awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203C4, /*03C8 03B0 awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F12037C, /*035E 0352 awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203C8, /*03C8 03B7 awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F12035E, /*0340 0334 awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203C0, /*03C0 03B5 awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120344, /*0328 0318 awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203AC, /*03B0 03B0 awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F12032A, /*0310 02FF awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F120394, /*039E 038D awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F12030E, /*02FA 02E7 awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120378, /*0384 0372 awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202F6, /*02DC 02D0 awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12035C, /*036C 035D awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202DC, /*02CA 02B5 awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120344, /*035A 0345 awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202C6, /*02B4 02A1 awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F12032A, /*0340 0331 awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F1202B0, /*029E 028B awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12030E, /*0324 031E awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F120298, /*028C 0273 awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F1202F8, /*0306 0309 awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F120286, /*027A 025F awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202E2, /*02F6 02F5 awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120270, /*026A 0250 awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202D0, /*02E4 02DB awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F12025E, /*025A 0241 awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202BC, /*02DA 02C7 awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F12024A, /*024C 0233 awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202AC, /*02CE 02B9 awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120238, /*023A 0223 awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202A0, /*02C4 02AB awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120226, /*0230 0217 awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F12029A, /*02B8 02A2 awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120214, /*0220 0207 awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120296, /*02AC 0294 awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F120202, /*0212 01FA awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120294, /*02AA 0289 awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201F4, /*0204 01EA awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F120290, /*02A6 0281 awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201E6, /*01FA 01DD awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F12028A, /*02A0 027B awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201D8, /*01EE 01D0 awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F120288, /*029C 0273 awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201CA, /*01E0 01C3 awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12027E, /*0294 026A awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201C0, /*01D4 01B6 awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F120274, /*028A 0265 awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201B2, /*01C8 01AB awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F12026C, /*0282 025B awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201AA, /*01C0 01A1 awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120264, /*027A 0254 awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F1201A6, /*01BC 0198 awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F12025C, /*0272 024B awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F1201A2, /*01B8 0192 awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F12024C, /*0262 0242 awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F1201A8, /*01BC 0191 awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F120238, /*024E 023A awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F1201D6, /*01EC 0192 awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F1201F0, /*0206 0222 awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F120000, /*0000 01C5 awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F120000, /*0000 01DF awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */

	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F12001F,
	0x0F120000,
	0x0F120108,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,

	/* Outdoor Gray Zone */
	0x0F12025E, /*025E*/
	0x0F120282, /*0282*/
	0x0F120246, /*0240*/
	0x0F12029E, /*0298*/
	0x0F120230, /*022A*/
	0x0F1202A0, /*029A*/
	0x0F120220, /*021A*/
	0x0F1202A0, /*029A*/
	0x0F12020E, /*0206*/
	0x0F12029E, /*0298*/
	0x0F120206, /*01FE*/
	0x0F120292, /*028C*/
	0x0F120200, /*01FA*/
	0x0F12027E, /*0278*/
	0x0F1201FE, /*01F8*/
	0x0F12026A, /*0266*/
	0x0F12021A, /*0214*/
	0x0F12023E, /*0238*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,


	/* param_WRITE 70000CC6 */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120208,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,

	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */


	/* 42param_end*/
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,

	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,


	/* Duks add*/
	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */

	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_0__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__2_       */
	0x0F12001E, /*0014 awbb_GridCorr_R_0__3_       */
	0x0F120000, /*0000 awbb_GridCorr_R_0__4_       */
	0x0F120082, /*005A awbb_GridCorr_R_0__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__2_       */
	0x0F12001E, /*0014 awbb_GridCorr_R_1__3_       */
	0x0F120000, /*0000 awbb_GridCorr_R_1__4_       */
	0x0F120082, /*005A awbb_GridCorr_R_1__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__2_       */
	0x0F12001E, /*0014 awbb_GridCorr_R_2__3_       */
	0x0F120000, /*0000 awbb_GridCorr_R_2__4_       */
	0x0F120082, /*005A awbb_GridCorr_R_2__5_       */

	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_0__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_0__1_     */
	0x0F12001E, /*001E awbb_GridCorr_B_0__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_0__3_     */
	0x0F12FF88, /*FF88 awbb_GridCorr_B_0__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_0__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_1__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_1__1_     */
	0x0F12001E, /*001E awbb_GridCorr_B_1__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_1__3_     */
	0x0F12FF88, /*FF88 awbb_GridCorr_B_1__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_1__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_2__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_2__1_     */
	0x0F12001E, /*001E awbb_GridCorr_B_2__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_2__3_     */
	0x0F12FF88, /*FF88 awbb_GridCorr_B_2__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_2__5_     */

	0x0F1202EA, /*awbb_GridConst_1_0_    */
	0x0F120335, /* awbb_GridConst_1_1_ */
	0x0F120388, /*awbb_GridConst_1_2_    */
	          
	0x0F121032, /* 1032 awbb_GridConst_2_0    */
	0x0F1210B2, /* 10B2 awbb_GridConst_2_1    */
	0x0F121140, /* 1160 awbb_GridConst_2_2    */
	0x0F121141, /* 1161 awbb_GridConst_2_3    */
	0x0F1211BE, /* 11BE awbb_GridConst_2_4    */
	0x0F12124C, /* 124C awbb_GridConst_2_5    */

	0x0F1200B3, /* awbb_GridCoeff_R_1 */
	0x0F1200B7, /* awbb_GridCoeff_B_1 */
	0x0F1200D3, /* awbb_GridCoeff_R_2 */
	0x0F120091, /* awbb_GridCoeff_B_2 */

	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,  /*--- 52A awbb_MvEq_RBthresh */

	/* Gamut Thresholds */
	0x002A0DAA,
	0x0F120664, /*--- 71A */
	0x0F120355, /*--- 3A4 */
	0x002A0DAE,
	0x0F12002C, /*--- 36 */
	0x0F120024, /*--- 1C */

	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120E01,
	0x0F120096,
	0x002A0E86,
	0x0F120256, /*-- 256 */
	0x0F120248, /*-- 248 */
	0x002A0D96,
	0x0F120E00,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F12041B, /* 459 awbb_LowTempRB */
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,

	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,

	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,

	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,

	/* awbb_ChromaClassifyEn, default : enable*/
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120258,
	0x0F120003,

	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,

	/*  param_start */
	0x002A2800,
	0x0F12010D, /*-0136---*/  /* H */
	0x0F12FFA7, /*-FF8B---*/
	0x0F12FFF5, /*-FFE8---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/

	0x0F12010D, /*-010D---*/  /* A */
	0x0F12FFA7, /*-FFA7---*/
	0x0F12FFF5, /*-FFF5---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/

	0x0F1201EA, /*01E9*/  /* WW */
	0x0F12FFB9, /*FFAE*/
	0x0F12FFDB, /*FFE6*/
	0x0F120127, /*0127*/
	0x0F120109, /*0109*/
	0x0F12FF3C, /*FF3C*/
	0x0F12FF2B, /*FF2B*/
	0x0F12021B, /*021B*/
	0x0F12FF48, /*FF48*/
	0x0F12FF03, /*FF03*/
	0x0F120207, /*0207*/
	0x0F120113, /*0113*/
	0x0F12FFCA, /*FFCA*/
	0x0F12FF93, /*FF93*/
	0x0F12016F, /*016F*/
	0x0F120164, /*0164*/
	0x0F12FF55, /*FF55*/
	0x0F120163, /*0163*/

	0x0F1201EA, /*01E9*/  /* CW */
	0x0F12FFB9, /*FFAE*/
	0x0F12FFDB, /*FFE6*/
	0x0F120127, /*0127*/
	0x0F120109, /*0109*/
	0x0F12FF3C, /*FF3C*/
	0x0F12FF2B, /*FF2B*/
	0x0F12021B, /*021B*/
	0x0F12FF48, /*FF48*/
	0x0F12FF03, /*FF03*/
	0x0F120207, /*0207*/
	0x0F120113, /*0113*/
	0x0F12FFCA, /*FFCA*/
	0x0F12FF93, /*FF93*/
	0x0F12016F, /*016F*/
	0x0F120164, /*0164*/
	0x0F12FF55, /*FF55*/
	0x0F120163, /*0163*/

	0x0F120194, /*-r018A---*/  /* D50 */
	0x0F12FFAD, /*-rFFA0---*/
	0x0F12FFFE, /*-rFFE9---*/
	0x0F1200C5, /*-y00C5---*/
	0x0F120103, /*-y0103---*/
	0x0F12FF5D, /*-yFF5D---*/
	0x0F12FEE3, /*-gFEFE---*/
	0x0F1201AE, /*-g021D---*/
	0x0F12FF27, /*-gFF2C---*/
	0x0F12FF18, /*- FF18---*/
	0x0F12018F, /*- 018F---*/
	0x0F1200C8, /*- 00C8---*/
	0x0F12FFE8, /*- FFE1---*/
	0x0F12FFAA, /*- FFA0---*/
	0x0F1201C8, /*- 01D9---*/
	0x0F120132, /*- 0132---*/
	0x0F12FF3E, /*- FF3E---*/
	0x0F120100, /*- 0100---*/

	0x0F120194, /*-r018A---*/  /* D65 */
	0x0F12FFAD, /*-rFFA0---*/
	0x0F12FFFE, /*-rFFE9---*/
	0x0F1200C5, /*-y00C5---*/
	0x0F120103, /*-y0103---*/
	0x0F12FF5D, /*-yFF5D---*/
	0x0F12FEE3, /*-gFEFE---*/
	0x0F1201AE, /*-g021D---*/
	0x0F12FF27, /*-gFF2C---*/
	0x0F12FF18, /*- FF18---*/
	0x0F12018F, /*- 018F---*/
	0x0F1200C8, /*- 00C8---*/
	0x0F12FFE8, /*- FFE1---*/
	0x0F12FFAA, /*- FFA0---*/
	0x0F1201C8, /*- 01D9---*/
	0x0F120132, /*- 0132---*/
	0x0F12FF3E, /*- FF3E---*/
	0x0F120100, /*- 0100---*/


	0x0F1201CC, /*--01CC--*/ /* OUT */
	0x0F12FFC3, /*--FFC3--*/
	0x0F120009, /*--0009--*/
	0x0F1200A2, /*--009D--*/
	0x0F120106, /*--00FA--*/
	0x0F12FF3F, /*--FF50--*/
	0x0F12FED8, /*--FED8--*/
	0x0F1201FE, /*--01FE--*/
	0x0F12FF08, /*--FF08--*/
	0x0F12FEC7, /*--FEC7--*/
	0x0F1200F5, /*--00F5--*/
	0x0F120119, /*--0119--*/
	0x0F12FFDF, /*--FFDF--*/
	0x0F120024, /*--0024--*/
	0x0F1201A8, /*--01A8--*/
	0x0F120170, /*--0170--*/
	0x0F12FFAD, /*--FFAD--*/
	0x0F12011B, /*--011B--*/

	/* Set NB */
	0x002A07EA,
	0x0F120000,

	/* param_start SARR_uNormBrInDoor*/
	0x0F12000A,
	0x0F120019,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,

	/* param_start SARR_uNormBrOutDoor */
	0x0F12000A,
	0x0F120019,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,


	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,


	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120004, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F1203FF, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120344, /* UVDenoise_iYLowThresh                                              */
	0x0F12033A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120012, /*  RGB2YUV_iYOffset                                                  */

	0x002A08AA, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120016, /* 14 Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120072, /* 64 Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120114, /* UVDenoise_iYLowThresh                                              */
	0x0F12020A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12200A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120009, /*  RGB2YUV_iYOffset                                                  */

	0x002A0928, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120012, /* 0C Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006E, /* 60 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x002A09A6, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006C, /* 5A Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x002A0A24, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120068, /* 50 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120000, /* UVDenoise_iYLowThresh                                              */
	0x0F120000, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */

	0x002A0AA2, /* --                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshLow                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                         */
	0x0F120800, /* Denoise1_sensor_width                             */
	0x0F120600, /* Denoise1_sensor_height                            */
	0x0F120000, /* Denoise1_start_x                                  */
	0x0F120000, /* Denoise1_start_y                                  */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "          */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "        */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  "  */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "           */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "         */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "      */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "     */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh" */
	0x0F120000, /*  Demosaic4_iBypassSelect                          */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,

	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001,

	0x0028D000,
	0x002AB0CC,
	0x0F12000B,
	/* END of Initial*/
};

/* Set-data based on SKT VT standard ,when using 3G network */
/* 8fps */
static const u32 s5k5bafx_vt_common[] =
{
	/* SKT-VT - continuous*/
	0xFCFCD000,
	
	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* Delay */
	
	
	/* Trap and Patch */
	0x00287000,
	0x002A1668,
	0x0F12B5FE, /*70001668*/
	0x0F120007, /*7000166A*/
	0x0F12683C, /*7000166C*/
	0x0F12687E, /*7000166E*/
	0x0F121DA5, /*70001670*/
	0x0F1288A0, /*70001672*/
	0x0F122800, /*70001674*/
	0x0F12D00B, /*70001676*/
	0x0F1288A8, /*70001678*/
	0x0F122800, /*7000167A*/
	0x0F12D008, /*7000167C*/
	0x0F128820, /*7000167E*/
	0x0F128829, /*70001680*/
	0x0F124288, /*70001682*/
	0x0F12D301, /*70001684*/
	0x0F121A40, /*70001686*/
	0x0F12E000, /*70001688*/
	0x0F121A08, /*7000168A*/
	0x0F129001, /*7000168C*/
	0x0F12E001, /*7000168E*/
	0x0F122019, /*70001690*/
	0x0F129001, /*70001692*/
	0x0F124916, /*70001694*/
	0x0F12466B, /*70001696*/
	0x0F128A48, /*70001698*/
	0x0F128118, /*7000169A*/
	0x0F128A88, /*7000169C*/
	0x0F128158, /*7000169E*/
	0x0F124814, /*700016A0*/
	0x0F128940, /*700016A2*/
	0x0F120040, /*700016A4*/
	0x0F122103, /*700016A6*/
	0x0F12F000, /*700016A8*/
	0x0F12F826, /*700016AA*/
	0x0F1288A1, /*700016AC*/
	0x0F124288, /*700016AE*/
	0x0F12D908, /*700016B0*/
	0x0F128828, /*700016B2*/
	0x0F128030, /*700016B4*/
	0x0F128868, /*700016B6*/
	0x0F128070, /*700016B8*/
	0x0F1288A8, /*700016BA*/
	0x0F126038, /*700016BC*/
	0x0F12BCFE, /*700016BE*/
	0x0F12BC08, /*700016C0*/
	0x0F124718, /*700016C2*/
	0x0F1288A9, /*700016C4*/
	0x0F124288, /*700016C6*/
	0x0F12D906, /*700016C8*/
	0x0F128820, /*700016CA*/
	0x0F128030, /*700016CC*/
	0x0F128860, /*700016CE*/
	0x0F128070, /*700016D0*/
	0x0F1288A0, /*700016D2*/
	0x0F126038, /*700016D4*/
	0x0F12E7F2, /*700016D6*/
	0x0F129801, /*700016D8*/
	0x0F12A902, /*700016DA*/
	0x0F12F000, /*700016DC*/
	0x0F12F812, /*700016DE*/
	0x0F120033, /*700016E0*/
	0x0F120029, /*700016E2*/
	0x0F129A02, /*700016E4*/
	0x0F120020, /*700016E6*/
	0x0F12F000, /*700016E8*/
	0x0F12F814, /*700016EA*/
	0x0F126038, /*700016EC*/
	0x0F12E7E6, /*700016EE*/
	0x0F121A28, /*700016F0*/
	0x0F127000, /*700016F2*/
	0x0F120D64, /*700016F4*/
	0x0F127000, /*700016F6*/
	0x0F124778, /*700016F8*/
	0x0F1246C0, /*700016FA*/
	0x0F12F004, /*700016FC*/
	0x0F12E51F, /*700016FE*/
	0x0F12A464, /*70001700*/
	0x0F120000, /*70001702*/
	0x0F124778, /*70001704*/
	0x0F1246C0, /*70001706*/
	0x0F12C000, /*70001708*/
	0x0F12E59F, /*7000170A*/
	0x0F12FF1C, /*7000170C*/
	0x0F12E12F, /*7000170E*/
	0x0F126009, /*70001710*/
	0x0F120000, /*70001712*/
	0x0F124778, /*70001714*/
	0x0F1246C0, /*70001716*/
	0x0F12C000, /*70001718*/
	0x0F12E59F, /*7000171A*/
	0x0F12FF1C, /*7000171C*/
	0x0F12E12F, /*7000171E*/
	0x0F12622F, /*70001720*/
	0x0F120000, /*70001722*/
	0x002A2080,
	0x0F12B510, /*70002080*/
	0x0F12F000, /*70002082*/
	0x0F12F8F4, /*70002084*/
	0x0F12BC10, /*70002086*/
	0x0F12BC08, /*70002088*/
	0x0F124718, /*7000208A*/
	0x0F12B5F0, /*7000208C*/
	0x0F12B08B, /*7000208E*/
	0x0F120006, /*70002090*/
	0x0F122000, /*70002092*/
	0x0F129004, /*70002094*/
	0x0F126835, /*70002096*/
	0x0F126874, /*70002098*/
	0x0F1268B0, /*7000209A*/
	0x0F12900A, /*7000209C*/
	0x0F1268F0, /*7000209E*/
	0x0F129009, /*700020A0*/
	0x0F124F7D, /*700020A2*/
	0x0F128979, /*700020A4*/
	0x0F12084A, /*700020A6*/
	0x0F1288A8, /*700020A8*/
	0x0F1288A3, /*700020AA*/
	0x0F124298, /*700020AC*/
	0x0F12D300, /*700020AE*/
	0x0F120018, /*700020B0*/
	0x0F12F000, /*700020B2*/
	0x0F12F907, /*700020B4*/
	0x0F129007, /*700020B6*/
	0x0F120021, /*700020B8*/
	0x0F120028, /*700020BA*/
	0x0F12AA04, /*700020BC*/
	0x0F12F000, /*700020BE*/
	0x0F12F909, /*700020C0*/
	0x0F129006, /*700020C2*/
	0x0F1288A8, /*700020C4*/
	0x0F122800, /*700020C6*/
	0x0F12D102, /*700020C8*/
	0x0F1227FF, /*700020CA*/
	0x0F121C7F, /*700020CC*/
	0x0F12E047, /*700020CE*/
	0x0F1288A0, /*700020D0*/
	0x0F122800, /*700020D2*/
	0x0F12D101, /*700020D4*/
	0x0F122700, /*700020D6*/
	0x0F12E042, /*700020D8*/
	0x0F128820, /*700020DA*/
	0x0F12466B, /*700020DC*/
	0x0F128198, /*700020DE*/
	0x0F128860, /*700020E0*/
	0x0F1281D8, /*700020E2*/
	0x0F128828, /*700020E4*/
	0x0F128118, /*700020E6*/
	0x0F128868, /*700020E8*/
	0x0F128158, /*700020EA*/
	0x0F12A802, /*700020EC*/
	0x0F12C803, /*700020EE*/
	0x0F12F000, /*700020F0*/
	0x0F12F8F8, /*700020F2*/
	0x0F129008, /*700020F4*/
	0x0F128ABA, /*700020F6*/
	0x0F129808, /*700020F8*/
	0x0F12466B, /*700020FA*/
	0x0F124342, /*700020FC*/
	0x0F129202, /*700020FE*/
	0x0F128820, /*70002100*/
	0x0F128198, /*70002102*/
	0x0F128860, /*70002104*/
	0x0F1281D8, /*70002106*/
	0x0F12980A, /*70002108*/
	0x0F129903, /*7000210A*/
	0x0F12F000, /*7000210C*/
	0x0F12F8EA, /*7000210E*/
	0x0F129A02, /*70002110*/
	0x0F1217D1, /*70002112*/
	0x0F120E09, /*70002114*/
	0x0F121889, /*70002116*/
	0x0F121209, /*70002118*/
	0x0F124288, /*7000211A*/
	0x0F12DD1F, /*7000211C*/
	0x0F128820, /*7000211E*/
	0x0F12466B, /*70002120*/
	0x0F128198, /*70002122*/
	0x0F128860, /*70002124*/
	0x0F1281D8, /*70002126*/
	0x0F12980A, /*70002128*/
	0x0F129903, /*7000212A*/
	0x0F12F000, /*7000212C*/
	0x0F12F8DA, /*7000212E*/
	0x0F129001, /*70002130*/
	0x0F128828, /*70002132*/
	0x0F12466B, /*70002134*/
	0x0F128118, /*70002136*/
	0x0F128868, /*70002138*/
	0x0F128158, /*7000213A*/
	0x0F12980A, /*7000213C*/
	0x0F129902, /*7000213E*/
	0x0F12F000, /*70002140*/
	0x0F12F8D0, /*70002142*/
	0x0F128AB9, /*70002144*/
	0x0F129A08, /*70002146*/
	0x0F124351, /*70002148*/
	0x0F1217CA, /*7000214A*/
	0x0F120E12, /*7000214C*/
	0x0F121851, /*7000214E*/
	0x0F12120A, /*70002150*/
	0x0F129901, /*70002152*/
	0x0F12F000, /*70002154*/
	0x0F12F8B6, /*70002156*/
	0x0F120407, /*70002158*/
	0x0F120C3F, /*7000215A*/
	0x0F12E000, /*7000215C*/
	0x0F122700, /*7000215E*/
	0x0F128820, /*70002160*/
	0x0F12466B, /*70002162*/
	0x0F12AA05, /*70002164*/
	0x0F128198, /*70002166*/
	0x0F128860, /*70002168*/
	0x0F1281D8, /*7000216A*/
	0x0F128828, /*7000216C*/
	0x0F128118, /*7000216E*/
	0x0F128868, /*70002170*/
	0x0F128158, /*70002172*/
	0x0F12A802, /*70002174*/
	0x0F12C803, /*70002176*/
	0x0F12003B, /*70002178*/
	0x0F12F000, /*7000217A*/
	0x0F12F8BB, /*7000217C*/
	0x0F1288A1, /*7000217E*/
	0x0F1288A8, /*70002180*/
	0x0F12003A, /*70002182*/
	0x0F12F000, /*70002184*/
	0x0F12F8BE, /*70002186*/
	0x0F120004, /*70002188*/
	0x0F12A804, /*7000218A*/
	0x0F12C803, /*7000218C*/
	0x0F129A09, /*7000218E*/
	0x0F129B07, /*70002190*/
	0x0F12F000, /*70002192*/
	0x0F12F8AF, /*70002194*/
	0x0F12A806, /*70002196*/
	0x0F12C805, /*70002198*/
	0x0F120021, /*7000219A*/
	0x0F12F000, /*7000219C*/
	0x0F12F8B2, /*7000219E*/
	0x0F126030, /*700021A0*/
	0x0F12B00B, /*700021A2*/
	0x0F12BCF0, /*700021A4*/
	0x0F12BC08, /*700021A6*/
	0x0F124718, /*700021A8*/
	0x0F12B5F1, /*700021AA*/
	0x0F129900, /*700021AC*/
	0x0F12680C, /*700021AE*/
	0x0F12493A, /*700021B0*/
	0x0F12694B, /*700021B2*/
	0x0F12698A, /*700021B4*/
	0x0F124694, /*700021B6*/
	0x0F1269CD, /*700021B8*/
	0x0F126A0E, /*700021BA*/
	0x0F124F38, /*700021BC*/
	0x0F1242BC, /*700021BE*/
	0x0F12D800, /*700021C0*/
	0x0F120027, /*700021C2*/
	0x0F124937, /*700021C4*/
	0x0F126B89, /*700021C6*/
	0x0F120409, /*700021C8*/
	0x0F120C09, /*700021CA*/
	0x0F124A35, /*700021CC*/
	0x0F121E92, /*700021CE*/
	0x0F126BD2, /*700021D0*/
	0x0F120412, /*700021D2*/
	0x0F120C12, /*700021D4*/
	0x0F12429F, /*700021D6*/
	0x0F12D801, /*700021D8*/
	0x0F120020, /*700021DA*/
	0x0F12E031, /*700021DC*/
	0x0F12001F, /*700021DE*/
	0x0F12434F, /*700021E0*/
	0x0F120A3F, /*700021E2*/
	0x0F1242A7, /*700021E4*/
	0x0F12D301, /*700021E6*/
	0x0F120018, /*700021E8*/
	0x0F12E02A, /*700021EA*/
	0x0F12002B, /*700021EC*/
	0x0F12434B, /*700021EE*/
	0x0F120A1B, /*700021F0*/
	0x0F1242A3, /*700021F2*/
	0x0F12D303, /*700021F4*/
	0x0F120220, /*700021F6*/
	0x0F12F000, /*700021F8*/
	0x0F12F88C, /*700021FA*/
	0x0F12E021, /*700021FC*/
	0x0F120029, /*700021FE*/
	0x0F124351, /*70002200*/
	0x0F120A09, /*70002202*/
	0x0F1242A1, /*70002204*/
	0x0F12D301, /*70002206*/
	0x0F120028, /*70002208*/
	0x0F12E01A, /*7000220A*/
	0x0F120031, /*7000220C*/
	0x0F124351, /*7000220E*/
	0x0F120A09, /*70002210*/
	0x0F1242A1, /*70002212*/
	0x0F12D304, /*70002214*/
	0x0F120220, /*70002216*/
	0x0F120011, /*70002218*/
	0x0F12F000, /*7000221A*/
	0x0F12F87B, /*7000221C*/
	0x0F12E010, /*7000221E*/
	0x0F12491E, /*70002220*/
	0x0F128C89, /*70002222*/
	0x0F12000A, /*70002224*/
	0x0F124372, /*70002226*/
	0x0F120A12, /*70002228*/
	0x0F1242A2, /*7000222A*/
	0x0F12D301, /*7000222C*/
	0x0F120030, /*7000222E*/
	0x0F12E007, /*70002230*/
	0x0F124662, /*70002232*/
	0x0F12434A, /*70002234*/
	0x0F120A12, /*70002236*/
	0x0F1242A2, /*70002238*/
	0x0F12D302, /*7000223A*/
	0x0F120220, /*7000223C*/
	0x0F12F000, /*7000223E*/
	0x0F12F869, /*70002240*/
	0x0F124B16, /*70002242*/
	0x0F124D18, /*70002244*/
	0x0F128D99, /*70002246*/
	0x0F121FCA, /*70002248*/
	0x0F123AF9, /*7000224A*/
	0x0F12D00A, /*7000224C*/
	0x0F122001, /*7000224E*/
	0x0F120240, /*70002250*/
	0x0F128468, /*70002252*/
	0x0F120220, /*70002254*/
	0x0F12F000, /*70002256*/
	0x0F12F85D, /*70002258*/
	0x0F129900, /*7000225A*/
	0x0F126008, /*7000225C*/
	0x0F12BCF8, /*7000225E*/
	0x0F12BC08, /*70002260*/
	0x0F124718, /*70002262*/
	0x0F128D19, /*70002264*/
	0x0F128469, /*70002266*/
	0x0F129900, /*70002268*/
	0x0F126008, /*7000226A*/
	0x0F12E7F7, /*7000226C*/
	0x0F12B570, /*7000226E*/
	0x0F122200, /*70002270*/
	0x0F12490E, /*70002272*/
	0x0F12480E, /*70002274*/
	0x0F122401, /*70002276*/
	0x0F12F000, /*70002278*/
	0x0F12F852, /*7000227A*/
	0x0F120022, /*7000227C*/
	0x0F12490D, /*7000227E*/
	0x0F12480D, /*70002280*/
	0x0F122502, /*70002282*/
	0x0F12F000, /*70002284*/
	0x0F12F84C, /*70002286*/
	0x0F12490C, /*70002288*/
	0x0F12480D, /*7000228A*/
	0x0F12002A, /*7000228C*/
	0x0F12F000, /*7000228E*/
	0x0F12F847, /*70002290*/
	0x0F12BC70, /*70002292*/
	0x0F12BC08, /*70002294*/
	0x0F124718, /*70002296*/
	0x0F120D64, /*70002298*/
	0x0F127000, /*7000229A*/
	0x0F120470, /*7000229C*/
	0x0F127000, /*7000229E*/
	0x0F12A120, /*700022A0*/
	0x0F120007, /*700022A2*/
	0x0F120402, /*700022A4*/
	0x0F127000, /*700022A6*/
	0x0F1214A0, /*700022A8*/
	0x0F127000, /*700022AA*/
	0x0F12208D, /*700022AC*/
	0x0F127000, /*700022AE*/
	0x0F12622F, /*700022B0*/
	0x0F120000, /*700022B2*/
	0x0F121669, /*700022B4*/
	0x0F127000, /*700022B6*/
	0x0F126445, /*700022B8*/
	0x0F120000, /*700022BA*/
	0x0F1221AB, /*700022BC*/
	0x0F127000, /*700022BE*/
	0x0F122AA9, /*700022C0*/
	0x0F120000, /*700022C2*/
	0x0F124778, /*700022C4*/
	0x0F1246C0, /*700022C6*/
	0x0F12C000, /*700022C8*/
	0x0F12E59F, /*700022CA*/
	0x0F12FF1C, /*700022CC*/
	0x0F12E12F, /*700022CE*/
	0x0F125F49, /*700022D0*/
	0x0F120000, /*700022D2*/
	0x0F124778, /*700022D4*/
	0x0F1246C0, /*700022D6*/
	0x0F12C000, /*700022D8*/
	0x0F12E59F, /*700022DA*/
	0x0F12FF1C, /*700022DC*/
	0x0F12E12F, /*700022DE*/
	0x0F125FC7, /*700022E0*/
	0x0F120000, /*700022E2*/
	0x0F124778, /*700022E4*/
	0x0F1246C0, /*700022E6*/
	0x0F12C000, /*700022E8*/
	0x0F12E59F, /*700022EA*/
	0x0F12FF1C, /*700022EC*/
	0x0F12E12F, /*700022EE*/
	0x0F125457, /*700022F0*/
	0x0F120000, /*700022F2*/
	0x0F124778, /*700022F4*/
	0x0F1246C0, /*700022F6*/
	0x0F12C000, /*700022F8*/
	0x0F12E59F, /*700022FA*/
	0x0F12FF1C, /*700022FC*/
	0x0F12E12F, /*700022FE*/
	0x0F125FA3, /*70002300*/
	0x0F120000, /*70002302*/
	0x0F124778, /*70002304*/
	0x0F1246C0, /*70002306*/
	0x0F12C000, /*70002308*/
	0x0F12E59F, /*7000230A*/
	0x0F12FF1C, /*7000230C*/
	0x0F12E12F, /*7000230E*/
	0x0F1251F9, /*70002310*/
	0x0F120000, /*70002312*/
	0x0F124778, /*70002314*/
	0x0F1246C0, /*70002316*/
	0x0F12F004, /*70002318*/
	0x0F12E51F, /*7000231A*/
	0x0F12A464, /*7000231C*/
	0x0F120000, /*7000231E*/
	0x0F124778, /*70002320*/
	0x0F1246C0, /*70002322*/
	0x0F12C000, /*70002324*/
	0x0F12E59F, /*70002326*/
	0x0F12FF1C, /*70002328*/
	0x0F12E12F, /*7000232A*/
	0x0F12A007, /*7000232C*/
	0x0F120000, /*7000232E*/
	0x0F126546, /*70002330*/
	0x0F122062, /*70002332*/
	0x0F123120, /*70002334*/
	0x0F123220, /*70002336*/
	0x0F123130, /*70002338*/
	0x0F120030, /*7000233A*/
	0x0F12E010, /*7000233C*/
	0x0F120208, /*7000233E*/
	0x0F120058, /*70002340*/
	0x0F120000, /*70002342*/
	/* End of Trap and Patch
	Total Size 896 (0x0380)*/
	
	0x0028D000,
	0x002A1000,
	0x0F120001,
	
	
	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,
	
	
	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,
	
	
	0x00287000,
	0x002A0ADC,
	0x0F120AF0,
	0x002A0AE2,
	0x0F12222E,
	
	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	0x002A049A,
	0x0F1201F4, /*--*/ 
	
	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,
	
	0x002AC202,
	0x0F120700,
	
	0x002AF260,
	0x0F120001,
	
	0x002AF414,
	0x0F120030,
	
	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,
	
	0x002AF700,
	0x0F120040,
	
	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,
	
	0x0F120015,
	
	
	0x0F120001,
	0x0F120040,
	
	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,
	
	
	0x002AF900,
	0x0F120067,
	
	
	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,
	
	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,
	
	0x002AF41A,
	0x0F1200FF,
	0x0F120003,
	
	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,
	
	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,
	
	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,
	
	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,
	
	0x002AF4D6,
	0x0F120090,
	
	0x0F120000,
	
	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,
	
	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,
	
	0x002AF418,
	0x0F120083,
	
	0x002AF454,
	0x0F120001,
	
	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,
	
	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,

	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,
	
	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,
	
	/* sensor aig table setting   sunkyu start */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,
	0x002A1084,
	0x0F120000,
	0x0F120000,
	
	/* Set AE Target */
	0x002A0F4C,
	0x0F12003c, /* --- */
	
	0x002A0478,
	0x0F120114,
	0x0F1200FB, /* 0EB */
	
	/* Set Frame Rate */
	0x002A0484,
	0x0F124074,
	0x0F120000,
	0x002A048C,
	0x0F1280E8,
	0x0F120000,
	0x0F12A604,
	0x0F120000,
	0x002A0488,
	0x0F12f424,
	0x0F120000,
	0x002A043A,
	0x0F120200, /* p-gain */
	0x0F120200,
	0x002A0494,
	0x0F120300, /* c-gain */
	0x0F120600, /* 600 */
	0x0f120100,
	0x002A0F52,
	0x0F12000F,
	
	0x002A0E98,
	0x0F1202B0,
	0x002A0E9E,
	0x0F120290,
	
	/* 1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001,
	0x002A03F8,
	0x0F12007F,
	
	0xffff000a, /* Wait10mSec */
	
	
	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0,
	0x0F120000,
	
	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001,
	0x0F120001,
	0x0F120000,
	
	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770,
	0x0F122EE0,
	0x0F122EE0,
	
	/* System Clock 1 (System : 28Mhz, PCLK : 48Mhz) */
	0x002A01D2,
	0x0F121B58,
	0x0F122EE0,
	0x0F122EE0,
	
	0x002A01DE,
	0x0F120001,
	0x0F120001,
	0xffff0064, /* 100ms Delay */
	
	/* Crop */
	0x002A01FA,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,
	
	/* Set Preview Config */
	/* Preview Config 0 (1600x1200 fixed 15fps) */
	0x002A0242,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052, /*--*/
	0x0F120001,
	0x0F120000, /*-0-*/
	0x0F120000, /*-0-*/
	0x0F1204E2, /*-535-*/
	0x0F1204E2, /*-29A-*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F12029A,
	0x0F12014D,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Set MIPI */
	0x002A03AC,
	0x0F120000,
	0x002A03F2,
	0x0F120001,
	0x0F1200C3,
	0x0F120001,
	
	/* Apply preview config */
	/* 0x002A021C, */
	/* 0x0F120000, */
	/* 0x002A0220, */
	/* 0x0F120001, */
	/* 0x002A01F8, */
	/* 0x0F120001, */
	/* 0x002A021E, */
	/* 0x0F120001, */
	/* 0x002A01F0, */
	/* 0x0F120001, */
	/* 0x0F120001, */
	
	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000,
	0x0F120640,
	0x0F1204B0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120002,
	0x0F120002,
	0x0F1204E2,
	0x0F1204E2,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	0x002A07C0,
	0x0F120004,
	0x0F120004,
	
	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	
	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120201,   /*0302     0101*/
	0x0F120102,   /*0203     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120302,   /*0403     0101*/
	0x0F120203,   /*0304     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120302,   /*0403     0101*/
	0x0F120203,   /*0304     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120201,   /*0302     0101*/
	0x0F120102,   /*0203     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	
	
	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200E0,
	0x0F120110,
	0x0F120128,
	0x0F120140,
	0x0F12015E,
	0x0F120190,
	0x0F1201B0,
	
	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200E0,
	0x0F120110,
	0x0F120128,
	0x0F120140,
	0x0F12015E,
	0x0F120190,


	
	/* Target Brightness Control */
	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,
	
	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /*00E0 TVAR_ash_GASAlpha[0]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[1]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[2]  */
	0x0F1200F0, /*0100 TVAR_ash_GASAlpha[3]  */
	
	0x0F1200F8, /*00F0 TVAR_ash_GASAlpha[4]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[5]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[6]  */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[7]  */
	
	0x0F1200F8, /*00F0 TVAR_ash_GASAlpha[8]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[9]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[10] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[11] */
	
	0x0F1200F8, /*00F8 TVAR_ash_GASAlpha[12] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[13] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[14] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[15] */
	
	0x0F120100, /*00F8 TVAR_ash_GASAlpha[16] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[17] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[18] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[19] */
	
	0x0F120100, /*0100 TVAR_ash_GASAlpha[20] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[21] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[22] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[23] */
	
	0x0F120100, /*0100 TVAR_ash_GASAlpha[24] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[25] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[26] */
	0x0F1200F0, /*00E8 TVAR_ash_GASAlpha[27] */
	
	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* 100 TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_ */
	
	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,
	
	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120198,
	0x0F120176,
	0x0F120140,
	0x0F12010B,
	0x0F1200E7,
	0x0F1200D0,
	0x0F1200C6,
	0x0F1200CE,
	0x0F1200E4,
	0x0F120109,
	0x0F12013A,
	0x0F12016D,
	0x0F120199,
	0x0F120175,
	0x0F12013C,
	0x0F120105,
	0x0F1200D3,
	0x0F1200AC,
	0x0F120093,
	0x0F12008A,
	0x0F120091,
	0x0F1200AA,
	0x0F1200D0,
	0x0F120102,
	0x0F12013E,
	0x0F120171,
	0x0F12014F,
	0x0F12010C,
	0x0F1200CF,
	0x0F12009A,
	0x0F120070,
	0x0F120055,
	0x0F12004C,
	0x0F120055,
	0x0F12006F,
	0x0F12009A,
	0x0F1200CF,
	0x0F12010E,
	0x0F12014D,
	0x0F120130,
	0x0F1200E9,
	0x0F1200A7,
	0x0F120070,
	0x0F120045,
	0x0F12002A,
	0x0F120020,
	0x0F12002A,
	0x0F120045,
	0x0F120071,
	0x0F1200AA,
	0x0F1200E8,
	0x0F12012E,
	0x0F12011C,
	0x0F1200D7,
	0x0F120091,
	0x0F120057,
	0x0F12002D,
	0x0F120012,
	0x0F12000A,
	0x0F120013,
	0x0F12002F,
	0x0F12005B,
	0x0F120094,
	0x0F1200D6,
	0x0F120119,
	0x0F120116,
	0x0F1200D0,
	0x0F12008C,
	0x0F12004F,
	0x0F120024,
	0x0F12000A,
	0x0F120000,
	0x0F12000A,
	0x0F120027,
	0x0F120054,
	0x0F120090,
	0x0F1200D1,
	0x0F120113,
	0x0F12011D,
	0x0F1200D7,
	0x0F120095,
	0x0F120057,
	0x0F12002B,
	0x0F120011,
	0x0F120008,
	0x0F120012,
	0x0F120030,
	0x0F12005C,
	0x0F120099,
	0x0F1200DA,
	0x0F12011D,
	0x0F120133,
	0x0F1200EF,
	0x0F1200AC,
	0x0F12006F,
	0x0F120043,
	0x0F120028,
	0x0F12001F,
	0x0F12002A,
	0x0F120047,
	0x0F120077,
	0x0F1200B1,
	0x0F1200F2,
	0x0F120135,
	0x0F120153,
	0x0F120113,
	0x0F1200D2,
	0x0F120098,
	0x0F12006A,
	0x0F12004E,
	0x0F120046,
	0x0F120053,
	0x0F120070,
	0x0F12009E,
	0x0F1200D7,
	0x0F120117,
	0x0F120155,
	0x0F12017B,
	0x0F120141,
	0x0F120100,
	0x0F1200C9,
	0x0F1200A0,
	0x0F120086,
	0x0F120080,
	0x0F12008A,
	0x0F1200A5,
	0x0F1200CF,
	0x0F120108,
	0x0F120144,
	0x0F12017B,
	0x0F12019F,
	0x0F120171,
	0x0F120133,
	0x0F1200FC,
	0x0F1200D5,
	0x0F1200BC,
	0x0F1200B5,
	0x0F1200BF,
	0x0F1200D8,
	0x0F120105,
	0x0F12013A,
	0x0F12016F,
	0x0F12019D,
	0x0F120149,
	0x0F12012C,
	0x0F1200FC,
	0x0F1200CE,
	0x0F1200AE,
	0x0F12009A,
	0x0F120092,
	0x0F120096,
	0x0F1200A6,
	0x0F1200C3,
	0x0F1200E9,
	0x0F120116,
	0x0F120135,
	0x0F120131,
	0x0F1200FE,
	0x0F1200CE,
	0x0F1200A3,
	0x0F120082,
	0x0F12006D,
	0x0F120066,
	0x0F12006B,
	0x0F12007B,
	0x0F120096,
	0x0F1200BF,
	0x0F1200EF,
	0x0F12011A,
	0x0F120117,
	0x0F1200D8,
	0x0F1200A2,
	0x0F120077,
	0x0F120058,
	0x0F120043,
	0x0F12003A,
	0x0F120041,
	0x0F120052,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200FC,
	0x0F1200FF,
	0x0F1200BC,
	0x0F120084,
	0x0F120058,
	0x0F120038,
	0x0F120023,
	0x0F12001A,
	0x0F120021,
	0x0F120035,
	0x0F120052,
	0x0F12007A,
	0x0F1200AB,
	0x0F1200E2,
	0x0F1200EF,
	0x0F1200AE,
	0x0F120072,
	0x0F120046,
	0x0F120025,
	0x0F120010,
	0x0F120009,
	0x0F12000F,
	0x0F120023,
	0x0F120040,
	0x0F12006A,
	0x0F120099,
	0x0F1200CF,
	0x0F1200E7,
	0x0F1200AA,
	0x0F12006E,
	0x0F12003F,
	0x0F12001E,
	0x0F120009,
	0x0F120000,
	0x0F120007,
	0x0F12001B,
	0x0F12003A,
	0x0F120064,
	0x0F120093,
	0x0F1200C9,
	0x0F1200EC,
	0x0F1200B0,
	0x0F120075,
	0x0F120045,
	0x0F120023,
	0x0F12000E,
	0x0F120006,
	0x0F12000D,
	0x0F120021,
	0x0F12003E,
	0x0F120068,
	0x0F120097,
	0x0F1200CD,
	0x0F1200FD,
	0x0F1200C0,
	0x0F120088,
	0x0F120057,
	0x0F120035,
	0x0F120020,
	0x0F120018,
	0x0F12001F,
	0x0F120032,
	0x0F12004F,
	0x0F120077,
	0x0F1200A6,
	0x0F1200DD,
	0x0F120116,
	0x0F1200DA,
	0x0F1200A3,
	0x0F120075,
	0x0F120052,
	0x0F12003C,
	0x0F120034,
	0x0F12003C,
	0x0F12004E,
	0x0F12006A,
	0x0F120090,
	0x0F1200C0,
	0x0F1200F4,
	0x0F120132,
	0x0F1200FD,
	0x0F1200C5,
	0x0F12009A,
	0x0F120078,
	0x0F120065,
	0x0F12005F,
	0x0F120064,
	0x0F120073,
	0x0F12008C,
	0x0F1200B3,
	0x0F1200E1,
	0x0F12010E,
	0x0F120150,
	0x0F120122,
	0x0F1200ED,
	0x0F1200C1,
	0x0F1200A1,
	0x0F12008B,
	0x0F120082,
	0x0F120087,
	0x0F120096,
	0x0F1200B3,
	0x0F1200DB,
	0x0F120102,
	0x0F12012D,
	0x0F120149,
	0x0F12012C,
	0x0F1200FC,
	0x0F1200CE,
	0x0F1200AE,
	0x0F12009A,
	0x0F120092,
	0x0F120096,
	0x0F1200A6,
	0x0F1200C3,
	0x0F1200E9,
	0x0F120116,
	0x0F120135,
	0x0F120131,
	0x0F1200FE,
	0x0F1200CE,
	0x0F1200A3,
	0x0F120082,
	0x0F12006D,
	0x0F120066,
	0x0F12006B,
	0x0F12007B,
	0x0F120096,
	0x0F1200BF,
	0x0F1200EF,
	0x0F12011A,
	0x0F120117,
	0x0F1200D8,
	0x0F1200A2,
	0x0F120077,
	0x0F120058,
	0x0F120043,
	0x0F12003A,
	0x0F120041,
	0x0F120052,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200FC,
	0x0F1200FF,
	0x0F1200BC,
	0x0F120084,
	0x0F120058,
	0x0F120038,
	0x0F120023,
	0x0F12001A,
	0x0F120021,
	0x0F120035,
	0x0F120052,
	0x0F12007A,
	0x0F1200AB,
	0x0F1200E2,
	0x0F1200EF,
	0x0F1200AE,
	0x0F120072,
	0x0F120046,
	0x0F120025,
	0x0F120010,
	0x0F120009,
	0x0F12000F,
	0x0F120023,
	0x0F120040,
	0x0F12006A,
	0x0F120099,
	0x0F1200CF,
	0x0F1200E7,
	0x0F1200AA,
	0x0F12006E,
	0x0F12003F,
	0x0F12001E,
	0x0F120009,
	0x0F120000,
	0x0F120007,
	0x0F12001B,
	0x0F12003A,
	0x0F120064,
	0x0F120093,
	0x0F1200C9,
	0x0F1200EC,
	0x0F1200B0,
	0x0F120075,
	0x0F120045,
	0x0F120023,
	0x0F12000E,
	0x0F120006,
	0x0F12000D,
	0x0F120021,
	0x0F12003E,
	0x0F120068,
	0x0F120097,
	0x0F1200CD,
	0x0F1200FD,
	0x0F1200C0,
	0x0F120088,
	0x0F120057,
	0x0F120035,
	0x0F120020,
	0x0F120018,
	0x0F12001F,
	0x0F120032,
	0x0F12004F,
	0x0F120077,
	0x0F1200A6,
	0x0F1200DD,
	0x0F120116,
	0x0F1200DA,
	0x0F1200A3,
	0x0F120075,
	0x0F120052,
	0x0F12003C,
	0x0F120034,
	0x0F12003C,
	0x0F12004E,
	0x0F12006A,
	0x0F120090,
	0x0F1200C0,
	0x0F1200F4,
	0x0F120132,
	0x0F1200FD,
	0x0F1200C5,
	0x0F12009A,
	0x0F120078,
	0x0F120065,
	0x0F12005F,
	0x0F120064,
	0x0F120073,
	0x0F12008C,
	0x0F1200B3,
	0x0F1200E1,
	0x0F12010E,
	0x0F120150,
	0x0F120122,
	0x0F1200ED,
	0x0F1200C1,
	0x0F1200A1,
	0x0F12008B,
	0x0F120082,
	0x0F120087,
	0x0F120096,
	0x0F1200B3,
	0x0F1200DB,
	0x0F120102,
	0x0F12012D,
	0x0F120100,
	0x0F1200EC,
	0x0F1200C4,
	0x0F1200A2,
	0x0F120089,
	0x0F12007C,
	0x0F12007A,
	0x0F120082,
	0x0F120094,
	0x0F1200B0,
	0x0F1200D5,
	0x0F120102,
	0x0F120124,
	0x0F1200E9,
	0x0F1200BF,
	0x0F12009C,
	0x0F12007F,
	0x0F120068,
	0x0F12005A,
	0x0F120057,
	0x0F12005F,
	0x0F120071,
	0x0F12008A,
	0x0F1200AF,
	0x0F1200DC,
	0x0F120109,
	0x0F1200D1,
	0x0F12009E,
	0x0F120077,
	0x0F12005B,
	0x0F120044,
	0x0F120036,
	0x0F120031,
	0x0F12003A,
	0x0F12004D,
	0x0F120068,
	0x0F12008B,
	0x0F1200B6,
	0x0F1200E7,
	0x0F1200BC,
	0x0F120088,
	0x0F12005E,
	0x0F12003F,
	0x0F120029,
	0x0F12001B,
	0x0F120016,
	0x0F12001F,
	0x0F120032,
	0x0F12004D,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200AF,
	0x0F12007C,
	0x0F120050,
	0x0F120030,
	0x0F12001B,
	0x0F12000C,
	0x0F120007,
	0x0F12000E,
	0x0F120021,
	0x0F120039,
	0x0F12005C,
	0x0F120084,
	0x0F1200B4,
	0x0F1200AA,
	0x0F120079,
	0x0F12004E,
	0x0F12002C,
	0x0F120014,
	0x0F120005,
	0x0F120000,
	0x0F120006,
	0x0F120018,
	0x0F120031,
	0x0F120053,
	0x0F120079,
	0x0F1200A9,
	0x0F1200AD,
	0x0F12007F,
	0x0F120055,
	0x0F120031,
	0x0F12001A,
	0x0F12000A,
	0x0F120004,
	0x0F12000B,
	0x0F12001B,
	0x0F120031,
	0x0F120052,
	0x0F120078,
	0x0F1200A6,
	0x0F1200BB,
	0x0F12008D,
	0x0F120065,
	0x0F120042,
	0x0F120029,
	0x0F12001A,
	0x0F120015,
	0x0F12001A,
	0x0F120028,
	0x0F120040,
	0x0F12005D,
	0x0F120084,
	0x0F1200B4,
	0x0F1200D5,
	0x0F1200A7,
	0x0F12007E,
	0x0F12005E,
	0x0F120043,
	0x0F120033,
	0x0F12002E,
	0x0F120033,
	0x0F120040,
	0x0F120056,
	0x0F120073,
	0x0F120099,
	0x0F1200C8,
	0x0F1200F5,
	0x0F1200C8,
	0x0F12009E,
	0x0F12007F,
	0x0F120067,
	0x0F120058,
	0x0F120056,
	0x0F120058,
	0x0F120062,
	0x0F120074,
	0x0F120092,
	0x0F1200B9,
	0x0F1200E4,
	0x0F120113,
	0x0F1200ED,
	0x0F1200C3,
	0x0F1200A1,
	0x0F12008A,
	0x0F12007A,
	0x0F120074,
	0x0F120077,
	0x0F120081,
	0x0F120097,
	0x0F1200B6,
	0x0F1200DA,
	0x0F120102,
	
	/* Gamma */
	0x002A04CC,
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone	       */
	0x0F120000, /* awbb_LowBr0_NBzone       */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv       */
	
	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F120324, /*0324  0324  awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F120330, /*0330  0330  awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F12030E, /*030E  030E  awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F120330, /*0330  0330  awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F1202EE, /*02EE  02EE  awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F120330, /*0330  0330  awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F1202D0, /*02D0  02D0  awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F120340, /*0340  0340  awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F1202B8, /*02B8  02B8  awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F120344, /*0344  0336  awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F1202A2, /*02A2  02A2  awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F120332, /*0328  031A  awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F12028A, /*028A  028A  awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120312, /*02FE  02F4  awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F120278, /*0278  0278  awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F1202F2, /*02D6  02D6  awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F120260, /*0260  0260  awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F1202CC, /*02C2  02C2  awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F120250, /*0250  0250  awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F1202AE, /*02AE  02AE  awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12023C, /*023C  023C  awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12029E, /*029E  029E  awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F12022A, /*022A  022A  awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120292, /*0292  0292  awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F120218, /*0218  0218  awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F120288, /*0288  0288  awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120206, /*0206  0206  awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F120282, /*0282  0282  awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F1201F4, /*01F4  01F4  awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F120280, /*0280  0280  awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F1201E6, /*01E6  01E6  awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F12027C, /*027C  027C  awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F1201D8, /*01D8  01D8  awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F12027A, /*027A  027A  awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F1201C8, /*01C8  01C8  awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F120274, /*0274  0274  awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F1201BC, /*01BC  01BC  awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120270, /*0270  0270  awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F1201B2, /*01B2  01B2  awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120266, /*0266  0266  awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201A4, /*01A4  01A4  awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F12025E, /*025E  025E  awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F12019C, /*019C  019C  awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F120256, /*0256  0256  awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F120198, /*0198  0198  awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F12024E, /*024E  024E  awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F120192, /*0192  0192  awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12023E, /*023E  023E  awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F120198, /*0198  0198  awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F12022A, /*022A  022A  awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201C6, /*01C6  01C6  awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F1201E0, /*01E0  01E0  awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F120000, /*0000  0000  awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /*0000  0000 awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /*0000  0000 awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /*0000  0000 awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /*0000  0000 awbb_IndoorGrZones_m_BGrid_33__m_right */
	
	
	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F12001A, /*--1F--*/
	0x0F120000,
	0x0F120158, /*--108--*/
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,
	
	/* Outdoor Gray Zone */
	0x0F12025E, /*025E*/
	0x0F120282, /*0282*/
	0x0F120246, /*0240*/
	0x0F12029E, /*0298*/
	0x0F120230, /*022A*/
	0x0F1202A0, /*029A*/
	0x0F120220, /*021A*/
	0x0F1202A0, /*029A*/
	0x0F12020E, /*0206*/
	0x0F12029E, /*0298*/
	0x0F120206, /*01FE*/
	0x0F120292, /*028C*/
	0x0F120200, /*01FA*/
	0x0F12027E, /*0278*/
	0x0F1201FE, /*01F8*/
	0x0F12026A, /*0266*/
	0x0F12021A, /*0214*/
	0x0F12023E, /*0238*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	
	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120208,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,
	
	/* Low Brightness Gray Zone */
	0x0F1202FC, /*031F awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120340, /*0495 awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202D8, /*02FC awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120344, /*0495 awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202B6, /*02D9 awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F12034A, /*0495 awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F120292, /*02B6 awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F12034E, /*0495 awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120270, /*0293 awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120354, /*0495 awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F12024E, /*0270 awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120358, /*0495 awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12022A, /*024E awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F12035E, /*0495 awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F120208, /*022B awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120364, /*0495 awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F1201E4, /*0208 awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F120368, /*048A awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201C2, /*01E5 awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F12036E, /*0455 awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F12019E, /*01C2 awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F120372, /*041F awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12017C, /*019F awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F120378, /*03EA awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12015A, /*017D awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F12037E, /*03B4 awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F120136, /*015A awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F120348, /*037F awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120130, /*0137 awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120314, /*0349 awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F12012E, /*0130 awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F1202DE, /*0314 awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012E, /*012F awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202B0, /*02DE awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012E, /*012F awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F12028A, /*02B1 awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012C, /*012E awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F120264, /*028B awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012C, /*012D awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F12023E, /*0265 awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /*012C awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F120218, /*023F awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012A, /*012C awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F1201F2, /*0219 awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012A, /*012B awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201CC, /*01F3 awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F120000, /*012A awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F120000, /*01CD awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /*0000 awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /*0000 awbb_LowBrGrZones_m_BGrid_24__m_right */
	
	
	/* 42param_end	awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120017, /*18 */
	0x0F120000,
	0x0F1200CE, /* AF */
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,
	
	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,
	
	
	/* Duks add*/
	0x002A0D8C,
	0x0F120065, /* awbb_GridEnable */
	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */
	
	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_0__0_       */
	0x0F12FFCE, /*FFCE awbb_GridCorr_R_0__1_       */
	0x0F120078, /*00A0 awbb_GridCorr_R_0__2_       */
	0x0F12FFEC, /*0014 awbb_GridCorr_R_0__3_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_0__4_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_0__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__0_       */
	0x0F12FFCE, /*FFCE awbb_GridCorr_R_1__1_       */
	0x0F120078, /*00A0 awbb_GridCorr_R_1__2_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__3_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__4_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__0_       */
	0x0F12FFCE, /*FFCE awbb_GridCorr_R_2__1_       */
	0x0F120078, /*00A0 awbb_GridCorr_R_2__2_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__3_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__4_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__5_       */
	
	0x0F12FFF4, /*FFF4 awbb_GridCorr_B_0__0_     */
	0x0F12FFF4, /*FFF4 awbb_GridCorr_B_0__1_     */
	0x0F12FF38, /*FF38 awbb_GridCorr_B_0__2_     */
	0x0F12FFD8, /*0000 awbb_GridCorr_B_0__3_     */
	0x0F120000, /*0000 awbb_GridCorr_B_0__4_     */
	0x0F120000, /*0000 awbb_GridCorr_B_0__5_     */
	0x0F12FFF4, /*FFF4 awbb_GridCorr_B_1__0_     */
	0x0F12FFF4, /*FFF4 awbb_GridCorr_B_1__1_     */
	0x0F12FF38, /*FF38 awbb_GridCorr_B_1__2_     */
	0x0F12FFD8, /*0000 awbb_GridCorr_B_1__3_     */
	0x0F120000, /*0000 awbb_GridCorr_B_1__4_     */
	0x0F120000, /*0000 awbb_GridCorr_B_1__5_     */
	0x0F12FFF4, /*FFF4 awbb_GridCorr_B_2__0_     */
	0x0F12FFF4, /*FFF4 awbb_GridCorr_B_2__1_     */
	0x0F12FF38, /*FF38 awbb_GridCorr_B_2__2_     */
	0x0F12FFD8, /*0000 awbb_GridCorr_B_2__3_     */
	0x0F120000, /*0000 awbb_GridCorr_B_2__4_     */
	0x0F120000, /*0000 awbb_GridCorr_B_2__5_     */
	
	0x0F1202EA,  /*02EA awbb_GridConst_1_0_    */
	0x0F120335,  /*0335 awbb_GridConst_1_1_    */
	0x0F120388,  /*0388 awbb_GridConst_1_2_    */
	
	0x0F121009,  /*1009 1009 1009 awbb_GridConst_2_0    */
	0x0F1210C8,  /*10C8 10C8 10B3 awbb_GridConst_2_1    */
	0x0F121135,  /*1135 1117 10FF awbb_GridConst_2_2    */
	0x0F121156,  /*1163 1141 1120 awbb_GridConst_2_3    */
	0x0F12118C,  /*118C 115D 115D awbb_GridConst_2_4    */
	0x0F1211BE,  /*11BE 11BE 11BE awbb_GridConst_2_5    */
	
	0x0F1200B3,  /*00B3 awbb_GridCoeff_R_1    */
	0x0F1200B7,  /*00B7 awbb_GridCoeff_B_1    */
	0x0F1200D3,  /*00D3 awbb_GridCoeff_R_2    */
	0x0F120091,  /*0091 awbb_GridCoeff_B_2    */
	
	/* White Locus */
	0x002A0D66,
	0x0F120133, /* 133        0131 */
	0x0F12010F, /* 10F        0128 */
	0x002A0D74,
	0x0F12052A, /*F5A*/  /*--- 52A awbb_MvEq_RBthresh */
	
	/* Gamut Thresholds */
	0x002A0DAA,
	0x0F120664, /*--- 71A */
	0x0F120355, /*--- 3A4 */
	0x002A0DAE,
	0x0F12002C, /*--- 36 */
	0x0F120024, /*--- 1C */
	
	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120E01,
	0x0F120096,
	0x002A0E86,
	0x0F120256, /*-- 256 */
	0x0F120248, /*-- 248 */
	0x002A0D96,
	0x0F120E00,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F12041B, /* 459 awbb_LowTempRB */
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120026, /*32 darkBr */
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,
	
	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,
	
	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,
	
	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,
	
	/* awbb_ChromaClassifyEn, default : enable */
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120258, 
	0x0F120003,
	
	
	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,
	
	/* param_start	TVAR_wbt_pBaseCcms */
	0x002A2800,
	0x0F1201CD, /*-0149---*/  /* H */
	0x0F12FF86, /*-FF79---*/
	0x0F12FFEC, /*-FFE6---*/
	0x0F1200F3, /*-006E---*/
	0x0F1200E3, /*-00E5---*/
	0x0F12FF31, /*-FF0F---*/
	0x0F12FF5F, /*-FF21---*/
	0x0F1201E9, /*-01E2---*/
	0x0F12FF30, /*-FF20---*/
	0x0F12FED6, /*-FEED---*/
	0x0F1201D3, /*-0198---*/
	0x0F1200F4, /*-0198---*/
	0x0F12FFDC, /*-FF95---*/
	0x0F12FFA9, /*-FFA3---*/
	0x0F1201A6, /*-0260---*/
	0x0F120139, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F120139, /*-00F4---*/
	
	0x0F1201CD, /*-0149---*/  /* A */
	0x0F12FF86, /*-FF79---*/
	0x0F12FFEC, /*-FFE6---*/
	0x0F1200F3, /*-006E---*/
	0x0F1200E3, /*-00E5---*/
	0x0F12FF31, /*-FF0F---*/
	0x0F12FF5F, /*-FF21---*/
	0x0F1201E9, /*-01E2---*/
	0x0F12FF30, /*-FF20---*/
	0x0F12FED6, /*-FEED---*/
	0x0F1201D3, /*-0198---*/
	0x0F1200F4, /*-0198---*/
	0x0F12FFDC, /*-FF95---*/
	0x0F12FFA9, /*-FFA3---*/
	0x0F1201A6, /*-0260---*/
	0x0F120139, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F120139, /*-00F4---*/
	
	0x0F1201DB, /*-0205   01A5*/  /* WW */
	0x0F12FF94, /*-FF92   FF9D*/
	0x0F12FFFA, /*-FFE6   FFE1*/
	0x0F1200F3, /*-00FE   00D9*/
	0x0F1200E3, /*-00E2   0153*/
	0x0F12FF31, /*-FF33   FF25*/
	0x0F12FF43, /*-FF1E   FF25*/
	0x0F1201E9, /*-0222   028C*/
	0x0F12FF4B, /*-FF68   FF25*/
	0x0F12FED6, /*-FF03   FEBF*/
	0x0F1201D3, /*-0207   01B6*/
	0x0F1200F4, /*-0113   00F7*/
	0x0F12FFDC, /*-FFE3   FF81*/
	0x0F12FFA9, /*-FFC0   FF8C*/
	0x0F1201A6, /*-0181   01AE*/
	0x0F120139, /*-0164   00FC*/
	0x0F12FF33, /*-FF55   FF48*/
	0x0F120139, /*-0163   010D*/
	
	0x0F1201DB, /*-0205  01BD*/  /* CW */
	0x0F12FF94, /*-FF92  FF89*/
	0x0F12FFFA, /*-FFE6  FFDE*/
	0x0F1200F3, /*-00FE  0098*/
	0x0F1200E3, /*-00E2  00B8*/
	0x0F12FF31, /*-FF33  FF69*/
	0x0F12FF43, /*-FF1E  FF15*/
	0x0F1201E9, /*-0222  025A*/
	0x0F12FF4B, /*-FF68  FF65*/
	0x0F12FED6, /*-FF03  FF03*/
	0x0F1201D3, /*-0207  0207*/
	0x0F1200F4, /*-0113  0113*/
	0x0F12FFDC, /*-FFE3  FFDA*/
	0x0F12FFA9, /*-FFC0  FFB8*/
	0x0F1201A6, /*-0181  0166*/
	0x0F120139, /*-0164  0164*/
	0x0F12FF33, /*-FF55  FF55*/
	0x0F120139, /*-0163  0163*/
	
	0x0F1201CD, /*-014D---*/  /* D50 */
	0x0F12FFAB, /*-FFAA---*/
	0x0F12FFF3, /*-FFF0---*/
	0x0F1200DC, /*-00C5---*/
	0x0F12011F, /*-0103---*/
	0x0F12FF57, /*-FF5D---*/
	0x0F12FF3D, /*-FF3D---*/
	0x0F1201F6, /*-01F6---*/
	0x0F12FF58, /*-FF58---*/
	0x0F12FF18, /*-FF18---*/
	0x0F12018F, /*-018F---*/
	0x0F1200C8, /*-00C8---*/
	0x0F12FFEC, /*-FFEC---*/
	0x0F12FFAB, /*-FFAB---*/
	0x0F1201E4, /*-01E4---*/
	0x0F120132, /*-0132---*/
	0x0F12FF3E, /*-FF3E---*/
	0x0F120100, /*-0100---*/
	
	0x0F1201CD, /*-014D 018A---*/  /* D65 */   
	0x0F12FFAB, /*-FFAA FFC1---*/
	0x0F12FFF3, /*-FFF0 FFF5---*/
	0x0F1200DC, /*-00C5 0086---*/
	0x0F12011F, /*-0103 00D2---*/
	0x0F12FF57, /*-FF5D FF73---*/
	0x0F12FF3D, /*-FF3D FF0B---*/
	0x0F1201F6, /*-01F6 0232---*/
	0x0F12FF58, /*-FF58 FF49---*/
	0x0F12FF18, /*-FF18 FF43---*/
	0x0F12018F, /*-018F 01BA---*/
	0x0F1200C8, /*-00C8 00F3---*/
	0x0F12FFEC, /*-FFEC FFE2---*/
	0x0F12FFAB, /*-FFAB FFB6---*/
	0x0F1201E4, /*-01E4 01E6---*/
	0x0F120132, /*-0132 018F---*/
	0x0F12FF3E, /*-FF3E FF8C---*/
	0x0F120100, /*-0100 0137---*/
	
	0x0F1201CC, /*--01CC--*/ /* OUT */
	0x0F12FFC3, /*--FFC3--*/
	0x0F120009, /*--0009--*/
	0x0F1200A2, /*--009D--*/
	0x0F120106, /*--00FA--*/
	0x0F12FF3F, /*--FF50--*/
	0x0F12FED8, /*--FED8--*/
	0x0F1201FE, /*--01FE--*/
	0x0F12FF08, /*--FF08--*/
	0x0F12FEC7, /*--FEC7--*/
	0x0F1200F5, /*--00F5--*/
	0x0F120119, /*--0119--*/
	0x0F12FFDF, /*--FFDF--*/
	0x0F120024, /*--0024--*/
	0x0F1201A8, /*--01A8--*/
	0x0F120170, /*--0170--*/
	0x0F12FFAD, /*--FFAD--*/
	0x0F12011B, /*--011B--*/
	
	/* Set NB */
	0x002A07EA,
	0x0F120000,
	
	/* param_start	SARR_uNormBrInDoor */
	0x0F120010,
	0x0F12001E,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,
	
	/* param_start	SARR_uNormBrOutDoor */
	0x0F120010,
	0x0F12001E,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,
	
	
	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,


	
	/* param_start	TVAR_afit_pBaseVals */
	0x002A082C,
	0x0F12000E, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                                 */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120344, /* UVDenoise_iYLowThresh                                                    */
	0x0F12033A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F12803c, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120038, /*  RGB2YUV_iYOffset                                                  */
	
	0x002A08AA, /* --                                                         */
	0x0F120006, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120016, /* 14 Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120072, /* 64 Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120114, /* UVDenoise_iYLowThresh                                                    */
	0x0F12020A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F121014, /* -- "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F121014, /* -- "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12200A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /*--  RGB2YUV_iYOffset                                                  */
	
	0x002A0928, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F120012, /* 0C Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F12006E, /* 60 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120014, /* UVDenoise_iYLowThresh                                                    */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                       */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12200F, /* -- "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12200F, /* -- "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */
	
	0x002A09A6, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                                 */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F12006C, /* 5A Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120014, /* UVDenoise_iYLowThresh                                                    */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F12000F, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F12000A, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F12080F, /* -- "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F120508, /* -- "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12200A, /* -- "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12200A, /* -- "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */
	
	0x002A0A24, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                               */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                               */
	0x0F120000, /* SHARP_BLUR                                                               */
	0x0F120000, /* GLAMOUR                                                                  */
	0x0F1203FF, /* Disparity_iSatSat                                                        */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                              */
	0x0F120068, /* 50 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                             */
	0x0F120002, /* Denoise1_iLowWWideThresh                                                 */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                                */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                  */
	0x0F12000A, /* Denoise1_iHighWideThresh                                                 */
	0x0F1203FF, /* Denoise1_iSatSat                                                         */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                   */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                  */
	0x0F120000, /* UVDenoise_iYLowThresh                                                    */
	0x0F120000, /* UVDenoise_iYHighThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                   */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                  */
	0x0F120002, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                                */
	0x0F120002, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                               */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                                    */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                                */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                                   */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                               */
	0x0F120106, /* DSMix1_iRGBOffset                                                        */
	0x0F12006F, /* DSMix1_iDemClamp                                                         */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"     bin: desparity low  */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"       */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin           */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                      */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                        */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"              */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                      */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                       */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                                */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                       */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                            */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                              */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                        */
	0x0F12020F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F120502, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122005, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122005, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                        */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                       */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"                     */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                       */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                       */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                       */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                             */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                               */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                             */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                                 */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                                 */
	0x0F120000, /* RGB2YUV_iYOffset                                                         */
	
	0x002A0AA2, /* --                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshLow                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                         */
	0x0F120800, /* Denoise1_sensor_width                             */
	0x0F120600, /* Denoise1_sensor_height                            */
	0x0F120000, /* Denoise1_start_x                                  */
	0x0F120000, /* Denoise1_start_y                                  */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "          */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "        */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  "  */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "           */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "         */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "      */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "     */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh" */
	0x0F120000, /*  Demosaic4_iBypassSelect                          */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,
	
	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001,
	
	0x0028D000,
	0x002AB0CC,
	0x0F12000B,
	/*SKT-VT END of Initial*/


};


/* Set-data based on Samsung Reliabilty Group standard */
/* ,when using WIFI. 15fps*/
static const u32 s5k5bafx_vt_wifi_common[] =
{
	/* wifi 15fps vt-call 110815 */
	0xFCFCD000,
	
	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064,
	
	/* Trap and Patch */
	0x00287000,
	0x002A1668,
	0x0F12B5FE, /*70001668*/
	0x0F120007, /*7000166A*/
	0x0F12683C, /*7000166C*/
	0x0F12687E, /*7000166E*/
	0x0F121DA5, /*70001670*/
	0x0F1288A0, /*70001672*/
	0x0F122800, /*70001674*/
	0x0F12D00B, /*70001676*/
	0x0F1288A8, /*70001678*/
	0x0F122800, /*7000167A*/
	0x0F12D008, /*7000167C*/
	0x0F128820, /*7000167E*/
	0x0F128829, /*70001680*/
	0x0F124288, /*70001682*/
	0x0F12D301, /*70001684*/
	0x0F121A40, /*70001686*/
	0x0F12E000, /*70001688*/
	0x0F121A08, /*7000168A*/
	0x0F129001, /*7000168C*/
	0x0F12E001, /*7000168E*/
	0x0F122019, /*70001690*/
	0x0F129001, /*70001692*/
	0x0F124916, /*70001694*/
	0x0F12466B, /*70001696*/
	0x0F128A48, /*70001698*/
	0x0F128118, /*7000169A*/
	0x0F128A88, /*7000169C*/
	0x0F128158, /*7000169E*/
	0x0F124814, /*700016A0*/
	0x0F128940, /*700016A2*/
	0x0F120040, /*700016A4*/
	0x0F122103, /*700016A6*/
	0x0F12F000, /*700016A8*/
	0x0F12F826, /*700016AA*/
	0x0F1288A1, /*700016AC*/
	0x0F124288, /*700016AE*/
	0x0F12D908, /*700016B0*/
	0x0F128828, /*700016B2*/
	0x0F128030, /*700016B4*/
	0x0F128868, /*700016B6*/
	0x0F128070, /*700016B8*/
	0x0F1288A8, /*700016BA*/
	0x0F126038, /*700016BC*/
	0x0F12BCFE, /*700016BE*/
	0x0F12BC08, /*700016C0*/
	0x0F124718, /*700016C2*/
	0x0F1288A9, /*700016C4*/
	0x0F124288, /*700016C6*/
	0x0F12D906, /*700016C8*/
	0x0F128820, /*700016CA*/
	0x0F128030, /*700016CC*/
	0x0F128860, /*700016CE*/
	0x0F128070, /*700016D0*/
	0x0F1288A0, /*700016D2*/
	0x0F126038, /*700016D4*/
	0x0F12E7F2, /*700016D6*/
	0x0F129801, /*700016D8*/
	0x0F12A902, /*700016DA*/
	0x0F12F000, /*700016DC*/
	0x0F12F812, /*700016DE*/
	0x0F120033, /*700016E0*/
	0x0F120029, /*700016E2*/
	0x0F129A02, /*700016E4*/
	0x0F120020, /*700016E6*/
	0x0F12F000, /*700016E8*/
	0x0F12F814, /*700016EA*/
	0x0F126038, /*700016EC*/
	0x0F12E7E6, /*700016EE*/
	0x0F121A28, /*700016F0*/
	0x0F127000, /*700016F2*/
	0x0F120D64, /*700016F4*/
	0x0F127000, /*700016F6*/
	0x0F124778, /*700016F8*/
	0x0F1246C0, /*700016FA*/
	0x0F12F004, /*700016FC*/
	0x0F12E51F, /*700016FE*/
	0x0F12A464, /*70001700*/
	0x0F120000, /*70001702*/
	0x0F124778, /*70001704*/
	0x0F1246C0, /*70001706*/
	0x0F12C000, /*70001708*/
	0x0F12E59F, /*7000170A*/
	0x0F12FF1C, /*7000170C*/
	0x0F12E12F, /*7000170E*/
	0x0F126009, /*70001710*/
	0x0F120000, /*70001712*/
	0x0F124778, /*70001714*/
	0x0F1246C0, /*70001716*/
	0x0F12C000, /*70001718*/
	0x0F12E59F, /*7000171A*/
	0x0F12FF1C, /*7000171C*/
	0x0F12E12F, /*7000171E*/
	0x0F12622F, /*70001720*/
	0x0F120000, /*70001722*/
	0x002A2080,
	0x0F12B510, /*70002080*/
	0x0F12F000, /*70002082*/
	0x0F12F8F4, /*70002084*/
	0x0F12BC10, /*70002086*/
	0x0F12BC08, /*70002088*/
	0x0F124718, /*7000208A*/
	0x0F12B5F0, /*7000208C*/
	0x0F12B08B, /*7000208E*/
	0x0F120006, /*70002090*/
	0x0F122000, /*70002092*/
	0x0F129004, /*70002094*/
	0x0F126835, /*70002096*/
	0x0F126874, /*70002098*/
	0x0F1268B0, /*7000209A*/
	0x0F12900A, /*7000209C*/
	0x0F1268F0, /*7000209E*/
	0x0F129009, /*700020A0*/
	0x0F124F7D, /*700020A2*/
	0x0F128979, /*700020A4*/
	0x0F12084A, /*700020A6*/
	0x0F1288A8, /*700020A8*/
	0x0F1288A3, /*700020AA*/
	0x0F124298, /*700020AC*/
	0x0F12D300, /*700020AE*/
	0x0F120018, /*700020B0*/
	0x0F12F000, /*700020B2*/
	0x0F12F907, /*700020B4*/
	0x0F129007, /*700020B6*/
	0x0F120021, /*700020B8*/
	0x0F120028, /*700020BA*/
	0x0F12AA04, /*700020BC*/
	0x0F12F000, /*700020BE*/
	0x0F12F909, /*700020C0*/
	0x0F129006, /*700020C2*/
	0x0F1288A8, /*700020C4*/
	0x0F122800, /*700020C6*/
	0x0F12D102, /*700020C8*/
	0x0F1227FF, /*700020CA*/
	0x0F121C7F, /*700020CC*/
	0x0F12E047, /*700020CE*/
	0x0F1288A0, /*700020D0*/
	0x0F122800, /*700020D2*/
	0x0F12D101, /*700020D4*/
	0x0F122700, /*700020D6*/
	0x0F12E042, /*700020D8*/
	0x0F128820, /*700020DA*/
	0x0F12466B, /*700020DC*/
	0x0F128198, /*700020DE*/
	0x0F128860, /*700020E0*/
	0x0F1281D8, /*700020E2*/
	0x0F128828, /*700020E4*/
	0x0F128118, /*700020E6*/
	0x0F128868, /*700020E8*/
	0x0F128158, /*700020EA*/
	0x0F12A802, /*700020EC*/
	0x0F12C803, /*700020EE*/
	0x0F12F000, /*700020F0*/
	0x0F12F8F8, /*700020F2*/
	0x0F129008, /*700020F4*/
	0x0F128ABA, /*700020F6*/
	0x0F129808, /*700020F8*/
	0x0F12466B, /*700020FA*/
	0x0F124342, /*700020FC*/
	0x0F129202, /*700020FE*/
	0x0F128820, /*70002100*/
	0x0F128198, /*70002102*/
	0x0F128860, /*70002104*/
	0x0F1281D8, /*70002106*/
	0x0F12980A, /*70002108*/
	0x0F129903, /*7000210A*/
	0x0F12F000, /*7000210C*/
	0x0F12F8EA, /*7000210E*/
	0x0F129A02, /*70002110*/
	0x0F1217D1, /*70002112*/
	0x0F120E09, /*70002114*/
	0x0F121889, /*70002116*/
	0x0F121209, /*70002118*/
	0x0F124288, /*7000211A*/
	0x0F12DD1F, /*7000211C*/
	0x0F128820, /*7000211E*/
	0x0F12466B, /*70002120*/
	0x0F128198, /*70002122*/
	0x0F128860, /*70002124*/
	0x0F1281D8, /*70002126*/
	0x0F12980A, /*70002128*/
	0x0F129903, /*7000212A*/
	0x0F12F000, /*7000212C*/
	0x0F12F8DA, /*7000212E*/
	0x0F129001, /*70002130*/
	0x0F128828, /*70002132*/
	0x0F12466B, /*70002134*/
	0x0F128118, /*70002136*/
	0x0F128868, /*70002138*/
	0x0F128158, /*7000213A*/
	0x0F12980A, /*7000213C*/
	0x0F129902, /*7000213E*/
	0x0F12F000, /*70002140*/
	0x0F12F8D0, /*70002142*/
	0x0F128AB9, /*70002144*/
	0x0F129A08, /*70002146*/
	0x0F124351, /*70002148*/
	0x0F1217CA, /*7000214A*/
	0x0F120E12, /*7000214C*/
	0x0F121851, /*7000214E*/
	0x0F12120A, /*70002150*/
	0x0F129901, /*70002152*/
	0x0F12F000, /*70002154*/
	0x0F12F8B6, /*70002156*/
	0x0F120407, /*70002158*/
	0x0F120C3F, /*7000215A*/
	0x0F12E000, /*7000215C*/
	0x0F122700, /*7000215E*/
	0x0F128820, /*70002160*/
	0x0F12466B, /*70002162*/
	0x0F12AA05, /*70002164*/
	0x0F128198, /*70002166*/
	0x0F128860, /*70002168*/
	0x0F1281D8, /*7000216A*/
	0x0F128828, /*7000216C*/
	0x0F128118, /*7000216E*/
	0x0F128868, /*70002170*/
	0x0F128158, /*70002172*/
	0x0F12A802, /*70002174*/
	0x0F12C803, /*70002176*/
	0x0F12003B, /*70002178*/
	0x0F12F000, /*7000217A*/
	0x0F12F8BB, /*7000217C*/
	0x0F1288A1, /*7000217E*/
	0x0F1288A8, /*70002180*/
	0x0F12003A, /*70002182*/
	0x0F12F000, /*70002184*/
	0x0F12F8BE, /*70002186*/
	0x0F120004, /*70002188*/
	0x0F12A804, /*7000218A*/
	0x0F12C803, /*7000218C*/
	0x0F129A09, /*7000218E*/
	0x0F129B07, /*70002190*/
	0x0F12F000, /*70002192*/
	0x0F12F8AF, /*70002194*/
	0x0F12A806, /*70002196*/
	0x0F12C805, /*70002198*/
	0x0F120021, /*7000219A*/
	0x0F12F000, /*7000219C*/
	0x0F12F8B2, /*7000219E*/
	0x0F126030, /*700021A0*/
	0x0F12B00B, /*700021A2*/
	0x0F12BCF0, /*700021A4*/
	0x0F12BC08, /*700021A6*/
	0x0F124718, /*700021A8*/
	0x0F12B5F1, /*700021AA*/
	0x0F129900, /*700021AC*/
	0x0F12680C, /*700021AE*/
	0x0F12493A, /*700021B0*/
	0x0F12694B, /*700021B2*/
	0x0F12698A, /*700021B4*/
	0x0F124694, /*700021B6*/
	0x0F1269CD, /*700021B8*/
	0x0F126A0E, /*700021BA*/
	0x0F124F38, /*700021BC*/
	0x0F1242BC, /*700021BE*/
	0x0F12D800, /*700021C0*/
	0x0F120027, /*700021C2*/
	0x0F124937, /*700021C4*/
	0x0F126B89, /*700021C6*/
	0x0F120409, /*700021C8*/
	0x0F120C09, /*700021CA*/
	0x0F124A35, /*700021CC*/
	0x0F121E92, /*700021CE*/
	0x0F126BD2, /*700021D0*/
	0x0F120412, /*700021D2*/
	0x0F120C12, /*700021D4*/
	0x0F12429F, /*700021D6*/
	0x0F12D801, /*700021D8*/
	0x0F120020, /*700021DA*/
	0x0F12E031, /*700021DC*/
	0x0F12001F, /*700021DE*/
	0x0F12434F, /*700021E0*/
	0x0F120A3F, /*700021E2*/
	0x0F1242A7, /*700021E4*/
	0x0F12D301, /*700021E6*/
	0x0F120018, /*700021E8*/
	0x0F12E02A, /*700021EA*/
	0x0F12002B, /*700021EC*/
	0x0F12434B, /*700021EE*/
	0x0F120A1B, /*700021F0*/
	0x0F1242A3, /*700021F2*/
	0x0F12D303, /*700021F4*/
	0x0F120220, /*700021F6*/
	0x0F12F000, /*700021F8*/
	0x0F12F88C, /*700021FA*/
	0x0F12E021, /*700021FC*/
	0x0F120029, /*700021FE*/
	0x0F124351, /*70002200*/
	0x0F120A09, /*70002202*/
	0x0F1242A1, /*70002204*/
	0x0F12D301, /*70002206*/
	0x0F120028, /*70002208*/
	0x0F12E01A, /*7000220A*/
	0x0F120031, /*7000220C*/
	0x0F124351, /*7000220E*/
	0x0F120A09, /*70002210*/
	0x0F1242A1, /*70002212*/
	0x0F12D304, /*70002214*/
	0x0F120220, /*70002216*/
	0x0F120011, /*70002218*/
	0x0F12F000, /*7000221A*/
	0x0F12F87B, /*7000221C*/
	0x0F12E010, /*7000221E*/
	0x0F12491E, /*70002220*/
	0x0F128C89, /*70002222*/
	0x0F12000A, /*70002224*/
	0x0F124372, /*70002226*/
	0x0F120A12, /*70002228*/
	0x0F1242A2, /*7000222A*/
	0x0F12D301, /*7000222C*/
	0x0F120030, /*7000222E*/
	0x0F12E007, /*70002230*/
	0x0F124662, /*70002232*/
	0x0F12434A, /*70002234*/
	0x0F120A12, /*70002236*/
	0x0F1242A2, /*70002238*/
	0x0F12D302, /*7000223A*/
	0x0F120220, /*7000223C*/
	0x0F12F000, /*7000223E*/
	0x0F12F869, /*70002240*/
	0x0F124B16, /*70002242*/
	0x0F124D18, /*70002244*/
	0x0F128D99, /*70002246*/
	0x0F121FCA, /*70002248*/
	0x0F123AF9, /*7000224A*/
	0x0F12D00A, /*7000224C*/
	0x0F122001, /*7000224E*/
	0x0F120240, /*70002250*/
	0x0F128468, /*70002252*/
	0x0F120220, /*70002254*/
	0x0F12F000, /*70002256*/
	0x0F12F85D, /*70002258*/
	0x0F129900, /*7000225A*/
	0x0F126008, /*7000225C*/
	0x0F12BCF8, /*7000225E*/
	0x0F12BC08, /*70002260*/
	0x0F124718, /*70002262*/
	0x0F128D19, /*70002264*/
	0x0F128469, /*70002266*/
	0x0F129900, /*70002268*/
	0x0F126008, /*7000226A*/
	0x0F12E7F7, /*7000226C*/
	0x0F12B570, /*7000226E*/
	0x0F122200, /*70002270*/
	0x0F12490E, /*70002272*/
	0x0F12480E, /*70002274*/
	0x0F122401, /*70002276*/
	0x0F12F000, /*70002278*/
	0x0F12F852, /*7000227A*/
	0x0F120022, /*7000227C*/
	0x0F12490D, /*7000227E*/
	0x0F12480D, /*70002280*/
	0x0F122502, /*70002282*/
	0x0F12F000, /*70002284*/
	0x0F12F84C, /*70002286*/
	0x0F12490C, /*70002288*/
	0x0F12480D, /*7000228A*/
	0x0F12002A, /*7000228C*/
	0x0F12F000, /*7000228E*/
	0x0F12F847, /*70002290*/
	0x0F12BC70, /*70002292*/
	0x0F12BC08, /*70002294*/
	0x0F124718, /*70002296*/
	0x0F120D64, /*70002298*/
	0x0F127000, /*7000229A*/
	0x0F120470, /*7000229C*/
	0x0F127000, /*7000229E*/
	0x0F12A120, /*700022A0*/
	0x0F120007, /*700022A2*/
	0x0F120402, /*700022A4*/
	0x0F127000, /*700022A6*/
	0x0F1214A0, /*700022A8*/
	0x0F127000, /*700022AA*/
	0x0F12208D, /*700022AC*/
	0x0F127000, /*700022AE*/
	0x0F12622F, /*700022B0*/
	0x0F120000, /*700022B2*/
	0x0F121669, /*700022B4*/
	0x0F127000, /*700022B6*/
	0x0F126445, /*700022B8*/
	0x0F120000, /*700022BA*/
	0x0F1221AB, /*700022BC*/
	0x0F127000, /*700022BE*/
	0x0F122AA9, /*700022C0*/
	0x0F120000, /*700022C2*/
	0x0F124778, /*700022C4*/
	0x0F1246C0, /*700022C6*/
	0x0F12C000, /*700022C8*/
	0x0F12E59F, /*700022CA*/
	0x0F12FF1C, /*700022CC*/
	0x0F12E12F, /*700022CE*/
	0x0F125F49, /*700022D0*/
	0x0F120000, /*700022D2*/
	0x0F124778, /*700022D4*/
	0x0F1246C0, /*700022D6*/
	0x0F12C000, /*700022D8*/
	0x0F12E59F, /*700022DA*/
	0x0F12FF1C, /*700022DC*/
	0x0F12E12F, /*700022DE*/
	0x0F125FC7, /*700022E0*/
	0x0F120000, /*700022E2*/
	0x0F124778, /*700022E4*/
	0x0F1246C0, /*700022E6*/
	0x0F12C000, /*700022E8*/
	0x0F12E59F, /*700022EA*/
	0x0F12FF1C, /*700022EC*/
	0x0F12E12F, /*700022EE*/
	0x0F125457, /*700022F0*/
	0x0F120000, /*700022F2*/
	0x0F124778, /*700022F4*/
	0x0F1246C0, /*700022F6*/
	0x0F12C000, /*700022F8*/
	0x0F12E59F, /*700022FA*/
	0x0F12FF1C, /*700022FC*/
	0x0F12E12F, /*700022FE*/
	0x0F125FA3, /*70002300*/
	0x0F120000, /*70002302*/
	0x0F124778, /*70002304*/
	0x0F1246C0, /*70002306*/
	0x0F12C000, /*70002308*/
	0x0F12E59F, /*7000230A*/
	0x0F12FF1C, /*7000230C*/
	0x0F12E12F, /*7000230E*/
	0x0F1251F9, /*70002310*/
	0x0F120000, /*70002312*/
	0x0F124778, /*70002314*/
	0x0F1246C0, /*70002316*/
	0x0F12F004, /*70002318*/
	0x0F12E51F, /*7000231A*/
	0x0F12A464, /*7000231C*/
	0x0F120000, /*7000231E*/
	0x0F124778, /*70002320*/
	0x0F1246C0, /*70002322*/
	0x0F12C000, /*70002324*/
	0x0F12E59F, /*70002326*/
	0x0F12FF1C, /*70002328*/
	0x0F12E12F, /*7000232A*/
	0x0F12A007, /*7000232C*/
	0x0F120000, /*7000232E*/
	0x0F126546, /*70002330*/
	0x0F122062, /*70002332*/
	0x0F123120, /*70002334*/
	0x0F123220, /*70002336*/
	0x0F123130, /*70002338*/
	0x0F120030, /*7000233A*/
	0x0F12E010, /*7000233C*/
	0x0F120208, /*7000233E*/
	0x0F120058, /*70002340*/
	0x0F120000, /*70002342*/
	/* End of Trap and Patch
	Total Size 896 (0x0380)*/
	
	0x0028D000,
	0x002A1000,
	0x0F120001,
	
	
	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,
	
	
	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,
	
	
	0x00287000,
	0x002A0ADC,
	0x0F120AF0,
	0x002A0AE2,
	0x0F12222E,
	
	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */
	
	
	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,
	
	
	0x002AC202,
	0x0F120700,
	
	0x002AF260,
	0x0F120001,
	
	0x002AF414,
	0x0F120030,
	
	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,
	
	0x002AF700,
	0x0F120040,
	
	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,
	
	0x0F120015,
	
	
	0x0F120001,
	0x0F120040,
	
	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,
	
	
	0x002AF900,
	0x0F120067,
	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,
	
	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,
	
	0x002AF41A,
	0x0F1200FF,
	0x0F120003,
	
	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,
	
	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,
	
	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,
	
	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,
	
	0x002AF4D6,
	0x0F120090,
	
	
	0x0F120000,
	
	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,
	
	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,
	
	0x002AF418,
	0x0F120083,
	
	0x002AF454,
	0x0F120001,
	
	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,
	
	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,
	
	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,
	
	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,
	
	/* sensor aig table setting */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,
	
	
	0x002A1084,
	0x0F120000, /* senHal_bUseAnalogBinning */
	0x0F120000, /* senHal_bUseAnalogVerAvg  */
	
	/* Set AE Target */
	0x002A0F4C,
	0x0F12003C, /* -- */
	
	0x002A0478,
	0x0F120114,
	0x0F1200FB, /* 0EB */
	
	/* Set Frame Rate */
	0x002A0484,
	0x0F122710,
	0x0F120000,
	0x002A048C,
	0x0F124E20, /* 8214 */
	0x0F120000,
	0x0F1261A8, /* A122 */
	0x0F120000,
	0x002A0488,
	0x0F128214, /* f424 */
	0x0F120000,
	0x002A043A,
	0x0F120340,
	0x0F120600,
	0x002A0494,
	0x0F120340,
	0x0F120600,
	0x0f120100,
	0x002A0F52,
	0x0F12000F,

	0x002A0E98,
	0x0F1202B0,
	0x002A0E9E,
	0x0F120290,
	
	/* 1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001,
	0x002A03F8,
	0x0F12007F,
	
	0xffff000a, /* Wait10mSec */
	
	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0,
	0x0F120000,
	
	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001,
	0x0F120001,
	0x0F120000,
	
	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770,
	0x0F122EE0,
	0x0F122EE0,
	
	/* System Clock 1 (System : 28Mhz, PCLK : 48Mhz) */
	0x002A01D2,                
	0x0F121B58,
	0x0F122EE0,
	0x0F122EE0,
	
	0x002A01DE,
	0x0F120001,
	0x0F120001,
	0xffff0064, /* 100ms Delay */
	
	/* Crop */
	0x002A01FA,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,
	
	/* Set Preview Config */
	/* Preview Config 0 (1600x1200 fixed 15fps) */
	0x002A0242,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052, /*-*/
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F12029A, /*-535-*/
	0x0F12029A, /*-29A-*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F12029A,
	0x0F12014D,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Set MIPI */
	0x002A03AC,
	0x0F120000,
	0x002A03F2,
	0x0F120001,
	0x0F1200C3,
	0x0F120001,
	
	/* Apply preview config */
	/* 0x002A021C, */
	/* 0x0F120000, */
	/* 0x002A0220, */
	/* 0x0F120001, */
	/* 0x002A01F8, */
	/* 0x0F120001, */
	/* 0x002A021E, */
	/* 0x0F120001, */
	/* 0x002A01F0, */
	/* 0x0F120001, */
	/* 0x0F120001, */
	
	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 15fps) */
	0x002A0302,
	0x0F120000,
	0x0F120640,
	0x0F1204B0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120002,
	0x0F120002,
	0x0F120535,
	0x0F120535,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Periodic mismatch */
	0x002A0780,
	0x0F120000, /* msm_uOffsetNoBin[0][0] */
	0x0F120000, /* msm_uOffsetNoBin[0][1] */
	0x0F120000, /* msm_uOffsetNoBin[1][0] */
	0x0F120000, /* msm_uOffsetNoBin[1][1] */
	0x0F120000, /* msm_uOffsetNoBin[2][0] */
	0x0F120000, /* msm_uOffsetNoBin[2][1] */
	0x0F120000, /* msm_uOffsetNoBin[3][0] */
	0x0F120000, /* msm_uOffsetNoBin[3][1] */
	
	0x002A0798,
	0x0F120000, /* msm_uOffsetBin[0][0] */
	0x0F120000, /* msm_uOffsetBin[0][1] */
	0x0F120000, /* msm_uOffsetBin[1][0] */
	0x0F120000, /* msm_uOffsetBin[1][1] */
	
	0x002A07C0,
	0x0F120004, /* msm_NonLinearOfsOutput[2] */
	0x0F120004, /* msm_NonLinearOfsOutput[3] */
	
	0x002A0B94,
	0x0F120580, /* awbb_GainsInit_0_:R */
	0x0F120400, /* awbb_GainsInit_1_:G */
	0x0F1205F0, /* awbb_GainsInit_2_:B */
	0x002A04A0,
	0x0F128000, /* lt_uLeiInit:AE start */
	
	
	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120201,   /*0302     0101*/
	0x0F120102,   /*0203     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120302,   /*0403     0101*/
	0x0F120203,   /*0304     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120302,   /*0403     0101*/
	0x0F120203,   /*0304     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120201,   /*0302     0101*/
	0x0F120102,   /*0203     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120101,   /*0101     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	0x0F120000,   /*0000     0101*/
	
	
	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,
	
	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,

	
	/* Target Brightness Control */
	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,
	
	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /*00E0 TVAR_ash_GASAlpha[0]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[1]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[2]  */
	0x0F1200F0, /*0100 TVAR_ash_GASAlpha[3]  */
	
	0x0F1200F8, /*00F0 TVAR_ash_GASAlpha[4]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[5]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[6]  */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[7]  */
	
	0x0F1200F8, /*00F0 TVAR_ash_GASAlpha[8]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[9]  */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[10] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[11] */
	
	0x0F1200F8, /*00F8 TVAR_ash_GASAlpha[12] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[13] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[14] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[15] */
	
	0x0F1200F8, /*00F8 TVAR_ash_GASAlpha[16] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[17] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[18] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[19] */
	
	0x0F120100, /*0100 TVAR_ash_GASAlpha[20] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[21] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[22] */
	0x0F1200F0, /*00F0 TVAR_ash_GASAlpha[23] */
	
	0x0F120100, /*0100 TVAR_ash_GASAlpha[24] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[25] */
	0x0F120100, /*0100 TVAR_ash_GASAlpha[26] */
	0x0F1200F0, /*00E8 TVAR_ash_GASAlpha[27] */
	
	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_ */
	0x0F1200F0, /* TVAR_ash_GASOutdoorAlpha_3_ */
	
	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,
	
	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120198,
	0x0F120176,
	0x0F120140,
	0x0F12010B,
	0x0F1200E7,
	0x0F1200D0,
	0x0F1200C6,
	0x0F1200CE,
	0x0F1200E4,
	0x0F120109,
	0x0F12013A,
	0x0F12016D,
	0x0F120199,
	0x0F120175,
	0x0F12013C,
	0x0F120105,
	0x0F1200D3,
	0x0F1200AC,
	0x0F120093,
	0x0F12008A,
	0x0F120091,
	0x0F1200AA,
	0x0F1200D0,
	0x0F120102,
	0x0F12013E,
	0x0F120171,
	0x0F12014F,
	0x0F12010C,
	0x0F1200CF,
	0x0F12009A,
	0x0F120070,
	0x0F120055,
	0x0F12004C,
	0x0F120055,
	0x0F12006F,
	0x0F12009A,
	0x0F1200CF,
	0x0F12010E,
	0x0F12014D,
	0x0F120130,
	0x0F1200E9,
	0x0F1200A7,
	0x0F120070,
	0x0F120045,
	0x0F12002A,
	0x0F120020,
	0x0F12002A,
	0x0F120045,
	0x0F120071,
	0x0F1200AA,
	0x0F1200E8,
	0x0F12012E,
	0x0F12011C,
	0x0F1200D7,
	0x0F120091,
	0x0F120057,
	0x0F12002D,
	0x0F120012,
	0x0F12000A,
	0x0F120013,
	0x0F12002F,
	0x0F12005B,
	0x0F120094,
	0x0F1200D6,
	0x0F120119,
	0x0F120116,
	0x0F1200D0,
	0x0F12008C,
	0x0F12004F,
	0x0F120024,
	0x0F12000A,
	0x0F120000,
	0x0F12000A,
	0x0F120027,
	0x0F120054,
	0x0F120090,
	0x0F1200D1,
	0x0F120113,
	0x0F12011D,
	0x0F1200D7,
	0x0F120095,
	0x0F120057,
	0x0F12002B,
	0x0F120011,
	0x0F120008,
	0x0F120012,
	0x0F120030,
	0x0F12005C,
	0x0F120099,
	0x0F1200DA,
	0x0F12011D,
	0x0F120133,
	0x0F1200EF,
	0x0F1200AC,
	0x0F12006F,
	0x0F120043,
	0x0F120028,
	0x0F12001F,
	0x0F12002A,
	0x0F120047,
	0x0F120077,
	0x0F1200B1,
	0x0F1200F2,
	0x0F120135,
	0x0F120153,
	0x0F120113,
	0x0F1200D2,
	0x0F120098,
	0x0F12006A,
	0x0F12004E,
	0x0F120046,
	0x0F120053,
	0x0F120070,
	0x0F12009E,
	0x0F1200D7,
	0x0F120117,
	0x0F120155,
	0x0F12017B,
	0x0F120141,
	0x0F120100,
	0x0F1200C9,
	0x0F1200A0,
	0x0F120086,
	0x0F120080,
	0x0F12008A,
	0x0F1200A5,
	0x0F1200CF,
	0x0F120108,
	0x0F120144,
	0x0F12017B,
	0x0F12019F,
	0x0F120171,
	0x0F120133,
	0x0F1200FC,
	0x0F1200D5,
	0x0F1200BC,
	0x0F1200B5,
	0x0F1200BF,
	0x0F1200D8,
	0x0F120105,
	0x0F12013A,
	0x0F12016F,
	0x0F12019D,
	0x0F120149,
	0x0F12012C,
	0x0F1200FC,
	0x0F1200CE,
	0x0F1200AE,
	0x0F12009A,
	0x0F120092,
	0x0F120096,
	0x0F1200A6,
	0x0F1200C3,
	0x0F1200E9,
	0x0F120116,
	0x0F120135,
	0x0F120131,
	0x0F1200FE,
	0x0F1200CE,
	0x0F1200A3,
	0x0F120082,
	0x0F12006D,
	0x0F120066,
	0x0F12006B,
	0x0F12007B,
	0x0F120096,
	0x0F1200BF,
	0x0F1200EF,
	0x0F12011A,
	0x0F120117,
	0x0F1200D8,
	0x0F1200A2,
	0x0F120077,
	0x0F120058,
	0x0F120043,
	0x0F12003A,
	0x0F120041,
	0x0F120052,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200FC,
	0x0F1200FF,
	0x0F1200BC,
	0x0F120084,
	0x0F120058,
	0x0F120038,
	0x0F120023,
	0x0F12001A,
	0x0F120021,
	0x0F120035,
	0x0F120052,
	0x0F12007A,
	0x0F1200AB,
	0x0F1200E2,
	0x0F1200EF,
	0x0F1200AE,
	0x0F120072,
	0x0F120046,
	0x0F120025,
	0x0F120010,
	0x0F120009,
	0x0F12000F,
	0x0F120023,
	0x0F120040,
	0x0F12006A,
	0x0F120099,
	0x0F1200CF,
	0x0F1200E7,
	0x0F1200AA,
	0x0F12006E,
	0x0F12003F,
	0x0F12001E,
	0x0F120009,
	0x0F120000,
	0x0F120007,
	0x0F12001B,
	0x0F12003A,
	0x0F120064,
	0x0F120093,
	0x0F1200C9,
	0x0F1200EC,
	0x0F1200B0,
	0x0F120075,
	0x0F120045,
	0x0F120023,
	0x0F12000E,
	0x0F120006,
	0x0F12000D,
	0x0F120021,
	0x0F12003E,
	0x0F120068,
	0x0F120097,
	0x0F1200CD,
	0x0F1200FD,
	0x0F1200C0,
	0x0F120088,
	0x0F120057,
	0x0F120035,
	0x0F120020,
	0x0F120018,
	0x0F12001F,
	0x0F120032,
	0x0F12004F,
	0x0F120077,
	0x0F1200A6,
	0x0F1200DD,
	0x0F120116,
	0x0F1200DA,
	0x0F1200A3,
	0x0F120075,
	0x0F120052,
	0x0F12003C,
	0x0F120034,
	0x0F12003C,
	0x0F12004E,
	0x0F12006A,
	0x0F120090,
	0x0F1200C0,
	0x0F1200F4,
	0x0F120132,
	0x0F1200FD,
	0x0F1200C5,
	0x0F12009A,
	0x0F120078,
	0x0F120065,
	0x0F12005F,
	0x0F120064,
	0x0F120073,
	0x0F12008C,
	0x0F1200B3,
	0x0F1200E1,
	0x0F12010E,
	0x0F120150,
	0x0F120122,
	0x0F1200ED,
	0x0F1200C1,
	0x0F1200A1,
	0x0F12008B,
	0x0F120082,
	0x0F120087,
	0x0F120096,
	0x0F1200B3,
	0x0F1200DB,
	0x0F120102,
	0x0F12012D,
	0x0F120149,
	0x0F12012C,
	0x0F1200FC,
	0x0F1200CE,
	0x0F1200AE,
	0x0F12009A,
	0x0F120092,
	0x0F120096,
	0x0F1200A6,
	0x0F1200C3,
	0x0F1200E9,
	0x0F120116,
	0x0F120135,
	0x0F120131,
	0x0F1200FE,
	0x0F1200CE,
	0x0F1200A3,
	0x0F120082,
	0x0F12006D,
	0x0F120066,
	0x0F12006B,
	0x0F12007B,
	0x0F120096,
	0x0F1200BF,
	0x0F1200EF,
	0x0F12011A,
	0x0F120117,
	0x0F1200D8,
	0x0F1200A2,
	0x0F120077,
	0x0F120058,
	0x0F120043,
	0x0F12003A,
	0x0F120041,
	0x0F120052,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200FC,
	0x0F1200FF,
	0x0F1200BC,
	0x0F120084,
	0x0F120058,
	0x0F120038,
	0x0F120023,
	0x0F12001A,
	0x0F120021,
	0x0F120035,
	0x0F120052,
	0x0F12007A,
	0x0F1200AB,
	0x0F1200E2,
	0x0F1200EF,
	0x0F1200AE,
	0x0F120072,
	0x0F120046,
	0x0F120025,
	0x0F120010,
	0x0F120009,
	0x0F12000F,
	0x0F120023,
	0x0F120040,
	0x0F12006A,
	0x0F120099,
	0x0F1200CF,
	0x0F1200E7,
	0x0F1200AA,
	0x0F12006E,
	0x0F12003F,
	0x0F12001E,
	0x0F120009,
	0x0F120000,
	0x0F120007,
	0x0F12001B,
	0x0F12003A,
	0x0F120064,
	0x0F120093,
	0x0F1200C9,
	0x0F1200EC,
	0x0F1200B0,
	0x0F120075,
	0x0F120045,
	0x0F120023,
	0x0F12000E,
	0x0F120006,
	0x0F12000D,
	0x0F120021,
	0x0F12003E,
	0x0F120068,
	0x0F120097,
	0x0F1200CD,
	0x0F1200FD,
	0x0F1200C0,
	0x0F120088,
	0x0F120057,
	0x0F120035,
	0x0F120020,
	0x0F120018,
	0x0F12001F,
	0x0F120032,
	0x0F12004F,
	0x0F120077,
	0x0F1200A6,
	0x0F1200DD,
	0x0F120116,
	0x0F1200DA,
	0x0F1200A3,
	0x0F120075,
	0x0F120052,
	0x0F12003C,
	0x0F120034,
	0x0F12003C,
	0x0F12004E,
	0x0F12006A,
	0x0F120090,
	0x0F1200C0,
	0x0F1200F4,
	0x0F120132,
	0x0F1200FD,
	0x0F1200C5,
	0x0F12009A,
	0x0F120078,
	0x0F120065,
	0x0F12005F,
	0x0F120064,
	0x0F120073,
	0x0F12008C,
	0x0F1200B3,
	0x0F1200E1,
	0x0F12010E,
	0x0F120150,
	0x0F120122,
	0x0F1200ED,
	0x0F1200C1,
	0x0F1200A1,
	0x0F12008B,
	0x0F120082,
	0x0F120087,
	0x0F120096,
	0x0F1200B3,
	0x0F1200DB,
	0x0F120102,
	0x0F12012D,
	0x0F120100,
	0x0F1200EC,
	0x0F1200C4,
	0x0F1200A2,
	0x0F120089,
	0x0F12007C,
	0x0F12007A,
	0x0F120082,
	0x0F120094,
	0x0F1200B0,
	0x0F1200D5,
	0x0F120102,
	0x0F120124,
	0x0F1200E9,
	0x0F1200BF,
	0x0F12009C,
	0x0F12007F,
	0x0F120068,
	0x0F12005A,
	0x0F120057,
	0x0F12005F,
	0x0F120071,
	0x0F12008A,
	0x0F1200AF,
	0x0F1200DC,
	0x0F120109,
	0x0F1200D1,
	0x0F12009E,
	0x0F120077,
	0x0F12005B,
	0x0F120044,
	0x0F120036,
	0x0F120031,
	0x0F12003A,
	0x0F12004D,
	0x0F120068,
	0x0F12008B,
	0x0F1200B6,
	0x0F1200E7,
	0x0F1200BC,
	0x0F120088,
	0x0F12005E,
	0x0F12003F,
	0x0F120029,
	0x0F12001B,
	0x0F120016,
	0x0F12001F,
	0x0F120032,
	0x0F12004D,
	0x0F12006F,
	0x0F120097,
	0x0F1200C9,
	0x0F1200AF,
	0x0F12007C,
	0x0F120050,
	0x0F120030,
	0x0F12001B,
	0x0F12000C,
	0x0F120007,
	0x0F12000E,
	0x0F120021,
	0x0F120039,
	0x0F12005C,
	0x0F120084,
	0x0F1200B4,
	0x0F1200AA,
	0x0F120079,
	0x0F12004E,
	0x0F12002C,
	0x0F120014,
	0x0F120005,
	0x0F120000,
	0x0F120006,
	0x0F120018,
	0x0F120031,
	0x0F120053,
	0x0F120079,
	0x0F1200A9,
	0x0F1200AD,
	0x0F12007F,
	0x0F120055,
	0x0F120031,
	0x0F12001A,
	0x0F12000A,
	0x0F120004,
	0x0F12000B,
	0x0F12001B,
	0x0F120031,
	0x0F120052,
	0x0F120078,
	0x0F1200A6,
	0x0F1200BB,
	0x0F12008D,
	0x0F120065,
	0x0F120042,
	0x0F120029,
	0x0F12001A,
	0x0F120015,
	0x0F12001A,
	0x0F120028,
	0x0F120040,
	0x0F12005D,
	0x0F120084,
	0x0F1200B4,
	0x0F1200D5,
	0x0F1200A7,
	0x0F12007E,
	0x0F12005E,
	0x0F120043,
	0x0F120033,
	0x0F12002E,
	0x0F120033,
	0x0F120040,
	0x0F120056,
	0x0F120073,
	0x0F120099,
	0x0F1200C8,
	0x0F1200F5,
	0x0F1200C8,
	0x0F12009E,
	0x0F12007F,
	0x0F120067,
	0x0F120058,
	0x0F120056,
	0x0F120058,
	0x0F120062,
	0x0F120074,
	0x0F120092,
	0x0F1200B9,
	0x0F1200E4,
	0x0F120113,
	0x0F1200ED,
	0x0F1200C3,
	0x0F1200A1,
	0x0F12008A,
	0x0F12007A,
	0x0F120074,
	0x0F120077,
	0x0F120081,
	0x0F120097,
	0x0F1200B6,
	0x0F1200DA,
	0x0F120102,
	
	/* Gamma */
	0x002A04CC,
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone  */
	0x0F120000, /* awbb_LowBr0_NBzone */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv */
	
	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F1203B4, /*03B4 038F awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F1203BE, /*03C0 039B awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F12039A, /*037C 0373 awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203C4, /*03C8 03B0 awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F12037C, /*035E 0352 awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203C8, /*03C8 03B7 awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F12035E, /*0340 0334 awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203C0, /*03C0 03B5 awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120344, /*0328 0318 awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203AC, /*03B0 03B0 awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F12032A, /*0310 02FF awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F120394, /*039E 038D awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F12030E, /*02FA 02E7 awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120378, /*0384 0372 awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202F6, /*02DC 02D0 awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12035C, /*036C 035D awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202DC, /*02CA 02B5 awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F120344, /*035A 0345 awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202C6, /*02B4 02A1 awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F12032A, /*0340 0331 awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F1202B0, /*029E 028B awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F12030E, /*0324 031E awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F120298, /*028C 0273 awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F1202F8, /*0306 0309 awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F120286, /*027A 025F awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202E2, /*02F6 02F5 awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F120270, /*026A 0250 awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202D0, /*02E4 02DB awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F12025E, /*025A 0241 awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202BC, /*02DA 02C7 awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F12024A, /*024C 0233 awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202AC, /*02CE 02B9 awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F120238, /*023A 0223 awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202A0, /*02C4 02AB awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120226, /*0230 0217 awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F12029A, /*02B8 02A2 awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120214, /*0220 0207 awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F120296, /*02AC 0294 awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F120202, /*0212 01FA awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F120294, /*02AA 0289 awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F1201F4, /*0204 01EA awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F120290, /*02A6 0281 awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201E6, /*01FA 01DD awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F12028A, /*02A0 027B awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201D8, /*01EE 01D0 awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F120288, /*029C 0273 awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201CA, /*01E0 01C3 awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F12027E, /*0294 026A awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201C0, /*01D4 01B6 awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F120274, /*028A 0265 awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201B2, /*01C8 01AB awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F12026C, /*0282 025B awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201AA, /*01C0 01A1 awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F120264, /*027A 0254 awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F1201A6, /*01BC 0198 awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F12025C, /*0272 024B awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F1201A2, /*01B8 0192 awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F12024C, /*0262 0242 awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F1201A8, /*01BC 0191 awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F120238, /*024E 023A awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F1201D6, /*01EC 0192 awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F1201F0, /*0206 0222 awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F120000, /*0000 01C5 awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F120000, /*0000 01DF awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */
	
	
	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F12001F,
	0x0F120000,
	0x0F120108,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,
	
	/* Outdoor Gray Zone */
	0x0F12025E, /*025E*/
	0x0F120282, /*0282*/
	0x0F120246, /*0240*/
	0x0F12029E, /*0298*/
	0x0F120230, /*022A*/
	0x0F1202A0, /*029A*/
	0x0F120220, /*021A*/
	0x0F1202A0, /*029A*/
	0x0F12020E, /*0206*/
	0x0F12029E, /*0298*/
	0x0F120206, /*01FE*/
	0x0F120292, /*028C*/
	0x0F120200, /*01FA*/
	0x0F12027E, /*0278*/
	0x0F1201FE, /*01F8*/
	0x0F12026A, /*0266*/
	0x0F12021A, /*0214*/
	0x0F12023E, /*0238*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	
	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120208,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,
	
	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */
	
	
	/* 42param_end	awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,
	
	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,
	
	
	/* Duks add*/
	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */
	
	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_0__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__2_       */
	0x0F120014, /*0050 awbb_GridCorr_R_0__3_       */
	0x0F12FFF0, /*0000 awbb_GridCorr_R_0__4_       */
	0x0F1200C0, /*005A awbb_GridCorr_R_0__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__2_       */
	0x0F120014, /*0050 awbb_GridCorr_R_1__3_       */
	0x0F12FFF0, /*0000 awbb_GridCorr_R_1__4_       */
	0x0F1200C0, /*005A awbb_GridCorr_R_1__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__2_       */
	0x0F120014, /*0050 awbb_GridCorr_R_2__3_       */
	0x0F12FFF0, /*0000 awbb_GridCorr_R_2__4_       */
	0x0F1200C0, /*005A awbb_GridCorr_R_2__5_       */
	
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_0__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_0__1_     */
	0x0F120028, /*FFD8 awbb_GridCorr_B_0__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_0__3_     */
	0x0F12FFA8, /*FF88 awbb_GridCorr_B_0__4_     */
	0x0F12FE50, /*FEA0 awbb_GridCorr_B_0__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_1__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_1__1_     */
	0x0F120028, /*FFD8 awbb_GridCorr_B_1__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_1__3_     */
	0x0F12FFA8, /*FF88 awbb_GridCorr_B_1__4_     */
	0x0F12FE50, /*FEA0 awbb_GridCorr_B_1__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_2__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_2__1_     */
	0x0F120028, /*FFD8 awbb_GridCorr_B_2__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_2__3_     */
	0x0F12FFA8, /*FF88 awbb_GridCorr_B_2__4_     */
	0x0F12FE50, /*FEA0 awbb_GridCorr_B_2__5_     */
	
	0x0F1202EA, /*awbb_GridConst_1_0_    */
	0x0F120335, /* awbb_GridConst_1_1_ */
	0x0F120388, /*awbb_GridConst_1_2_    */
	          
	0x0F121032, /* 1032 awbb_GridConst_2_0    */
	0x0F1210B2, /* 10B2 awbb_GridConst_2_1    */
	0x0F12115B, /* 1160 awbb_GridConst_2_2    */
	0x0F12115C, /* 1161 awbb_GridConst_2_3    */
	0x0F1211BE, /* 11BE awbb_GridConst_2_4    */
	0x0F12124C, /* 124C awbb_GridConst_2_5    */
	
	0x0F1200B3, /* awbb_GridCoeff_R_1 */
	0x0F1200B7, /* awbb_GridCoeff_B_1 */
	0x0F1200D3, /* awbb_GridCoeff_R_2 */
	0x0F120091, /* awbb_GridCoeff_B_2 */
	
	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,  /*--- 52A awbb_MvEq_RBthresh */
	
	/* Gamut Thresholds */
	0x002A0DAA,
	0x0F120664, /*--- 71A */
	0x0F120355, /*--- 3A4 */
	0x002A0DAE,
	0x0F12002C, /*--- 36 */
	0x0F120024, /*--- 1C */
	
	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120E01,
	0x0F120096,
	0x002A0E86,
	0x0F120256, /*-- 256 */
	0x0F120248, /*-- 248 */
	0x002A0D96,
	0x0F120E00,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F12041B, /* 459 awbb_LowTempRB */
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,
	
	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,
	
	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,
	
	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,
	
	/* awbb_ChromaClassifyEn, default : enable */
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120258,
	0x0F120003,
	
	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,
	
	/* param_start	TVAR_wbt_pBaseCcms */
	0x002A2800,
	0x0F12010D, /*-0136---*/  /* H */
	0x0F12FFA7, /*-FF8B---*/
	0x0F12FFF5, /*-FFE8---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/

	0x0F12010D, /*-010D---*/  /* A */
	0x0F12FFA7, /*-FFA7---*/
	0x0F12FFF5, /*-FFF5---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/
	
	0x0F1201EA, /*01E9*/  /* WW */
	0x0F12FFB9, /*FFAE*/
	0x0F12FFDB, /*FFE6*/
	0x0F120127, /*0127*/
	0x0F120109, /*0109*/
	0x0F12FF3C, /*FF3C*/
	0x0F12FF2B, /*FF2B*/
	0x0F12021B, /*021B*/
	0x0F12FF48, /*FF48*/
	0x0F12FF03, /*FF03*/
	0x0F120207, /*0207*/
	0x0F120113, /*0113*/
	0x0F12FFCA, /*FFCA*/
	0x0F12FF93, /*FF93*/
	0x0F12016F, /*016F*/
	0x0F120164, /*0164*/
	0x0F12FF55, /*FF55*/
	0x0F120163, /*0163*/
	
	0x0F1201EA, /*01E9*/  /* CW */
	0x0F12FFB9, /*FFAE*/
	0x0F12FFDB, /*FFE6*/
	0x0F120127, /*0127*/
	0x0F120109, /*0109*/
	0x0F12FF3C, /*FF3C*/
	0x0F12FF2B, /*FF2B*/
	0x0F12021B, /*021B*/
	0x0F12FF48, /*FF48*/
	0x0F12FF03, /*FF03*/
	0x0F120207, /*0207*/
	0x0F120113, /*0113*/
	0x0F12FFCA, /*FFCA*/
	0x0F12FF93, /*FF93*/
	0x0F12016F, /*016F*/
	0x0F120164, /*0164*/
	0x0F12FF55, /*FF55*/
	0x0F120163, /*0163*/
	
	0x0F12018A, /*-r014D---*/  /* D50 */
	0x0F12FFA0, /*-rFFA7---*/
	0x0F12FFE9, /*-rFFF4---*/
	0x0F1200C5, /*-y00C5---*/
	0x0F120103, /*-y0103---*/
	0x0F12FF5D, /*-yFF5D---*/
	0x0F12FEFE, /*-gFF16---*/
	0x0F12021D, /*-g0209---*/
	0x0F12FF2C, /*-gFF42---*/
	0x0F12FF18, /*- FF18---*/
	0x0F12018F, /*- 018F---*/
	0x0F1200C8, /*- 00C8---*/
	0x0F12FFE1, /*- FFE1---*/
	0x0F12FFA0, /*- FFA0---*/
	0x0F1201D9, /*- 01D9---*/
	0x0F120132, /*- 0132---*/
	0x0F12FF3E, /*- FF3E---*/
	0x0F120100, /*- 0100---*/
	
	0x0F12018A, /*-r014D---*/  /* D65 */
	0x0F12FFA0, /*-rFFA7---*/
	0x0F12FFE9, /*-rFFF4---*/
	0x0F1200C5, /*-y00C5---*/
	0x0F120103, /*-y0103---*/
	0x0F12FF5D, /*-yFF5D---*/
	0x0F12FEFE, /*-gFF16---*/
	0x0F12021D, /*-g0209---*/
	0x0F12FF2C, /*-gFF42---*/
	0x0F12FF18, /*- FF18---*/
	0x0F12018F, /*- 018F---*/
	0x0F1200C8, /*- 00C8---*/
	0x0F12FFE1, /*- FFE1---*/
	0x0F12FFA0, /*- FFA0---*/
	0x0F1201D9, /*- 01D9---*/
	0x0F120132, /*- 0132---*/
	0x0F12FF3E, /*- FF3E---*/
	0x0F120100, /*- 0100---*/
	
	
	0x0F1201CC, /*--01CC--*/ /* OUT */
	0x0F12FFC3, /*--FFC3--*/
	0x0F120009, /*--0009--*/
	0x0F1200A2, /*--009D--*/
	0x0F120106, /*--00FA--*/
	0x0F12FF3F, /*--FF50--*/
	0x0F12FED8, /*--FED8--*/
	0x0F1201FE, /*--01FE--*/
	0x0F12FF08, /*--FF08--*/
	0x0F12FEC7, /*--FEC7--*/
	0x0F1200F5, /*--00F5--*/
	0x0F120119, /*--0119--*/
	0x0F12FFDF, /*--FFDF--*/
	0x0F120024, /*--0024--*/
	0x0F1201A8, /*--01A8--*/
	0x0F120170, /*--0170--*/
	0x0F12FFAD, /*--FFAD--*/
	0x0F12011B, /*--011B--*/
	
	/* Set NB */
	0x002A07EA,
	0x0F120000,
	
	/* param_start	SARR_uNormBrInDoor */
	0x0F120008,
	0x0F120016,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,
	
	/* param_start	SARR_uNormBrOutDoor */
	0x0F120008,
	0x0F120016,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,
	
	
	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,


	
	0x002A082C,
	0x0F120020, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                               */
	0x0F120014, /* SATURATION                                                         */
	0x0F12ffb0, /* SHARP_BLUR                                                         */
	0x0F120008, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F1203FF, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120344, /* UVDenoise_iYLowThresh                                                  */
	0x0F12033A, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                    */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                      */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F12803c, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120058, /*  RGB2YUV_iYOffset                                                  */
	
	0x002A08AA, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120000, /* CONTRAST                                                               */
	0x0F120020, /* SATURATION                                                         */
	0x0F12ffe0, /* SHARP_BLUR                                                         */
	0x0F120004, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F120016, /* 14 Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120072, /* 64 Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120114, /* UVDenoise_iYLowThresh*/
	0x0F12020A, /* UVDenoise_iYHighThresh*/
	0x0F1203FF, /* UVDenoise_iUVLowThresh*/
	0x0F1203FF, /* UVDenoise_iUVHighThresh*/
	0x0F120028, /* DSMix1_iLowLimit_Wide*/
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin*/
	0x0F120014, /* DSMix1_iHighLimit_Wide*/
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin*/
	0x0F120050, /* DSMix1_iLowLimit_Fine*/
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin*/
	0x0F120046, /* DSMix1_iHighLimit_Fine*/
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin*/
	0x0F120106, /* DSMix1_iRGBOffset*/
	0x0F12006F, /* DSMix1_iDemClamp*/
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin" bin: desparity low */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12200A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                      */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F12003C, /*--  RGB2YUV_iYOffset                                                  */
	         
	0x002A0928, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                             */
	0x0F120000, /* SHARP_BLUR                                                             */
	0x0F120000, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F120012, /* 0C Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F12006E, /* 60 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120014, /* UVDenoise_iYLowThresh                                                  */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"    bin: desparity low */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120000, /*  RGB2YUV_iYOffset                                                      */
	
	0x002A09A6, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                             */
	0x0F120000, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F12006C, /* 5A Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120014, /* UVDenoise_iYLowThresh                                                  */
	0x0F12000A, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                                 */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"    bin: desparity low */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                    */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                     */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                          */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                     */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                     */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                           */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                               */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                               */
	0x0F120000, /*  RGB2YUV_iYOffset                                                      */
	
	0x002A0A24, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                             */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                                */
	0x0F1203FF, /* Disparity_iSatSat                                                      */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                            */
	0x0F120068, /* 50 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                           */
	0x0F120002, /* Denoise1_iLowWWideThresh                                               */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                              */
	0x0F12000A, /* Denoise1_iLowWideThresh                                                */
	0x0F12000A, /* Denoise1_iHighWideThresh                                               */
	0x0F1203FF, /* Denoise1_iSatSat                                                       */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                                 */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                                */
	0x0F120000, /* UVDenoise_iYLowThresh                                                  */
	0x0F120000, /* UVDenoise_iYHighThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                                 */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                                */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                                  */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                              */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                             */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                              */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                             */
	0x0F120106, /* DSMix1_iRGBOffset                                                      */
	0x0F12006F, /* DSMix1_iDemClamp                                                       */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"    bin: desparity low */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"  bin: desparity high */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin"     */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin         */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                      */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"            */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                    */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                     */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                              */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                            */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                      */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                     */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                    */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"             */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                     */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                     */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                           */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                             */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                           */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                      */
	
	0x002A0AA2, /* --                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshLow                         */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                        */
	0x0F120800, /* Denoise1_sensor_width                            */
	0x0F120600, /* Denoise1_sensor_height                           */
	0x0F120000, /* Denoise1_start_x                                 */
	0x0F120000, /* Denoise1_start_y                                 */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "         */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "       */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  " */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "          */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "        */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "     */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "    */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh"*/
	0x0F120000, /*  Demosaic4_iBypassSelect                         */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,
	
	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */
	
	0x0028D000,
	0x002AB0CC,
	0x0F12000B,
	/* Wifi VT-Call END 110815 */
	


	
};

/*===========================================
* CAMERA_PREVIEW - Կ   ͽ  *
============================================*/

static const u32 s5k5bafx_preview[] =
{
	0xFCFCD000,
	0x00287000,

	0x002A021C,
	0x0F120000, /* REG_TC_GP_ActivePrevConfig */
	0x002A0220,
	0x0F120001, /* REG_TC_GP_PrevOpenAfterChange */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A021E,
	0x0F120001, /* REG_TC_GP_PrevConfigChanged */
	0x002A01F0,
	0x0F120001, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged */
	0xffff0096, /* 150ms */

	/*  MIPI */
	0x0028D000,
	0x002AB0CC,
	0x0F12000B,

};

/*===========================================
*	CAMERA_SNAPSHOT  - Կ 		  *
============================================*/

static const u32 s5k5bafx_capture[] =
{
	0xFCFCD000,
	0x00287000,

	0x002A0224,
	0x0F120000, /* REG_TC_GP_ActiveCapConfig */
	0x002A01F8,
	0x0F120001, /* REG_TC_GP_NewConfigSync */
	0x002A0226,
	0x0F120001, /* REG_TC_GP_CapConfigChanged */
	0x002A01F4,
	0x0F120001, /* REG_TC_GP_EnableCapture */
	0x0F120001, /* REG_TC_GP_EnableCaptureChanged */
	0xffff0096, /* 150ms */

	/*  MIPI */
	0x0028D000,
	0x002AB0CC,
	0x0F12000B,
};

#if defined(CONFIG_TARGET_LOCALE_KOR) || \
	defined(CONFIG_TARGET_LOCALE_NAATT) || \
	defined(CONFIG_MACH_P8LTE)
static const u32 s5k5bafx_recording_60Hz_common[] = {
	
	/* recording 25fps Anti-Flicker 60Hz*/
	
	0xFCFCD000,
	
	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064,
	
	/* Trap and Patch */
	0x00287000,
	0x002A1668,
	0x0F12B5FE, /*70001668*/
	0x0F120007, /*7000166A*/
	0x0F12683C, /*7000166C*/
	0x0F12687E, /*7000166E*/
	0x0F121DA5, /*70001670*/
	0x0F1288A0, /*70001672*/
	0x0F122800, /*70001674*/
	0x0F12D00B, /*70001676*/
	0x0F1288A8, /*70001678*/
	0x0F122800, /*7000167A*/
	0x0F12D008, /*7000167C*/
	0x0F128820, /*7000167E*/
	0x0F128829, /*70001680*/
	0x0F124288, /*70001682*/
	0x0F12D301, /*70001684*/
	0x0F121A40, /*70001686*/
	0x0F12E000, /*70001688*/
	0x0F121A08, /*7000168A*/
	0x0F129001, /*7000168C*/
	0x0F12E001, /*7000168E*/
	0x0F122019, /*70001690*/
	0x0F129001, /*70001692*/
	0x0F124916, /*70001694*/
	0x0F12466B, /*70001696*/
	0x0F128A48, /*70001698*/
	0x0F128118, /*7000169A*/
	0x0F128A88, /*7000169C*/
	0x0F128158, /*7000169E*/
	0x0F124814, /*700016A0*/
	0x0F128940, /*700016A2*/
	0x0F120040, /*700016A4*/
	0x0F122103, /*700016A6*/
	0x0F12F000, /*700016A8*/
	0x0F12F826, /*700016AA*/
	0x0F1288A1, /*700016AC*/
	0x0F124288, /*700016AE*/
	0x0F12D908, /*700016B0*/
	0x0F128828, /*700016B2*/
	0x0F128030, /*700016B4*/
	0x0F128868, /*700016B6*/
	0x0F128070, /*700016B8*/
	0x0F1288A8, /*700016BA*/
	0x0F126038, /*700016BC*/
	0x0F12BCFE, /*700016BE*/
	0x0F12BC08, /*700016C0*/
	0x0F124718, /*700016C2*/
	0x0F1288A9, /*700016C4*/
	0x0F124288, /*700016C6*/
	0x0F12D906, /*700016C8*/
	0x0F128820, /*700016CA*/
	0x0F128030, /*700016CC*/
	0x0F128860, /*700016CE*/
	0x0F128070, /*700016D0*/
	0x0F1288A0, /*700016D2*/
	0x0F126038, /*700016D4*/
	0x0F12E7F2, /*700016D6*/
	0x0F129801, /*700016D8*/
	0x0F12A902, /*700016DA*/
	0x0F12F000, /*700016DC*/
	0x0F12F812, /*700016DE*/
	0x0F120033, /*700016E0*/
	0x0F120029, /*700016E2*/
	0x0F129A02, /*700016E4*/
	0x0F120020, /*700016E6*/
	0x0F12F000, /*700016E8*/
	0x0F12F814, /*700016EA*/
	0x0F126038, /*700016EC*/
	0x0F12E7E6, /*700016EE*/
	0x0F121A28, /*700016F0*/
	0x0F127000, /*700016F2*/
	0x0F120D64, /*700016F4*/
	0x0F127000, /*700016F6*/
	0x0F124778, /*700016F8*/
	0x0F1246C0, /*700016FA*/
	0x0F12F004, /*700016FC*/
	0x0F12E51F, /*700016FE*/
	0x0F12A464, /*70001700*/
	0x0F120000, /*70001702*/
	0x0F124778, /*70001704*/
	0x0F1246C0, /*70001706*/
	0x0F12C000, /*70001708*/
	0x0F12E59F, /*7000170A*/
	0x0F12FF1C, /*7000170C*/
	0x0F12E12F, /*7000170E*/
	0x0F126009, /*70001710*/
	0x0F120000, /*70001712*/
	0x0F124778, /*70001714*/
	0x0F1246C0, /*70001716*/
	0x0F12C000, /*70001718*/
	0x0F12E59F, /*7000171A*/
	0x0F12FF1C, /*7000171C*/
	0x0F12E12F, /*7000171E*/
	0x0F12622F, /*70001720*/
	0x0F120000, /*70001722*/
	0x002A2080,
	0x0F12B510, /*70002080*/
	0x0F12F000, /*70002082*/
	0x0F12F8F4, /*70002084*/
	0x0F12BC10, /*70002086*/
	0x0F12BC08, /*70002088*/
	0x0F124718, /*7000208A*/
	0x0F12B5F0, /*7000208C*/
	0x0F12B08B, /*7000208E*/
	0x0F120006, /*70002090*/
	0x0F122000, /*70002092*/
	0x0F129004, /*70002094*/
	0x0F126835, /*70002096*/
	0x0F126874, /*70002098*/
	0x0F1268B0, /*7000209A*/
	0x0F12900A, /*7000209C*/
	0x0F1268F0, /*7000209E*/
	0x0F129009, /*700020A0*/
	0x0F124F7D, /*700020A2*/
	0x0F128979, /*700020A4*/
	0x0F12084A, /*700020A6*/
	0x0F1288A8, /*700020A8*/
	0x0F1288A3, /*700020AA*/
	0x0F124298, /*700020AC*/
	0x0F12D300, /*700020AE*/
	0x0F120018, /*700020B0*/
	0x0F12F000, /*700020B2*/
	0x0F12F907, /*700020B4*/
	0x0F129007, /*700020B6*/
	0x0F120021, /*700020B8*/
	0x0F120028, /*700020BA*/
	0x0F12AA04, /*700020BC*/
	0x0F12F000, /*700020BE*/
	0x0F12F909, /*700020C0*/
	0x0F129006, /*700020C2*/
	0x0F1288A8, /*700020C4*/
	0x0F122800, /*700020C6*/
	0x0F12D102, /*700020C8*/
	0x0F1227FF, /*700020CA*/
	0x0F121C7F, /*700020CC*/
	0x0F12E047, /*700020CE*/
	0x0F1288A0, /*700020D0*/
	0x0F122800, /*700020D2*/
	0x0F12D101, /*700020D4*/
	0x0F122700, /*700020D6*/
	0x0F12E042, /*700020D8*/
	0x0F128820, /*700020DA*/
	0x0F12466B, /*700020DC*/
	0x0F128198, /*700020DE*/
	0x0F128860, /*700020E0*/
	0x0F1281D8, /*700020E2*/
	0x0F128828, /*700020E4*/
	0x0F128118, /*700020E6*/
	0x0F128868, /*700020E8*/
	0x0F128158, /*700020EA*/
	0x0F12A802, /*700020EC*/
	0x0F12C803, /*700020EE*/
	0x0F12F000, /*700020F0*/
	0x0F12F8F8, /*700020F2*/
	0x0F129008, /*700020F4*/
	0x0F128ABA, /*700020F6*/
	0x0F129808, /*700020F8*/
	0x0F12466B, /*700020FA*/
	0x0F124342, /*700020FC*/
	0x0F129202, /*700020FE*/
	0x0F128820, /*70002100*/
	0x0F128198, /*70002102*/
	0x0F128860, /*70002104*/
	0x0F1281D8, /*70002106*/
	0x0F12980A, /*70002108*/
	0x0F129903, /*7000210A*/
	0x0F12F000, /*7000210C*/
	0x0F12F8EA, /*7000210E*/
	0x0F129A02, /*70002110*/
	0x0F1217D1, /*70002112*/
	0x0F120E09, /*70002114*/
	0x0F121889, /*70002116*/
	0x0F121209, /*70002118*/
	0x0F124288, /*7000211A*/
	0x0F12DD1F, /*7000211C*/
	0x0F128820, /*7000211E*/
	0x0F12466B, /*70002120*/
	0x0F128198, /*70002122*/
	0x0F128860, /*70002124*/
	0x0F1281D8, /*70002126*/
	0x0F12980A, /*70002128*/
	0x0F129903, /*7000212A*/
	0x0F12F000, /*7000212C*/
	0x0F12F8DA, /*7000212E*/
	0x0F129001, /*70002130*/
	0x0F128828, /*70002132*/
	0x0F12466B, /*70002134*/
	0x0F128118, /*70002136*/
	0x0F128868, /*70002138*/
	0x0F128158, /*7000213A*/
	0x0F12980A, /*7000213C*/
	0x0F129902, /*7000213E*/
	0x0F12F000, /*70002140*/
	0x0F12F8D0, /*70002142*/
	0x0F128AB9, /*70002144*/
	0x0F129A08, /*70002146*/
	0x0F124351, /*70002148*/
	0x0F1217CA, /*7000214A*/
	0x0F120E12, /*7000214C*/
	0x0F121851, /*7000214E*/
	0x0F12120A, /*70002150*/
	0x0F129901, /*70002152*/
	0x0F12F000, /*70002154*/
	0x0F12F8B6, /*70002156*/
	0x0F120407, /*70002158*/
	0x0F120C3F, /*7000215A*/
	0x0F12E000, /*7000215C*/
	0x0F122700, /*7000215E*/
	0x0F128820, /*70002160*/
	0x0F12466B, /*70002162*/
	0x0F12AA05, /*70002164*/
	0x0F128198, /*70002166*/
	0x0F128860, /*70002168*/
	0x0F1281D8, /*7000216A*/
	0x0F128828, /*7000216C*/
	0x0F128118, /*7000216E*/
	0x0F128868, /*70002170*/
	0x0F128158, /*70002172*/
	0x0F12A802, /*70002174*/
	0x0F12C803, /*70002176*/
	0x0F12003B, /*70002178*/
	0x0F12F000, /*7000217A*/
	0x0F12F8BB, /*7000217C*/
	0x0F1288A1, /*7000217E*/
	0x0F1288A8, /*70002180*/
	0x0F12003A, /*70002182*/
	0x0F12F000, /*70002184*/
	0x0F12F8BE, /*70002186*/
	0x0F120004, /*70002188*/
	0x0F12A804, /*7000218A*/
	0x0F12C803, /*7000218C*/
	0x0F129A09, /*7000218E*/
	0x0F129B07, /*70002190*/
	0x0F12F000, /*70002192*/
	0x0F12F8AF, /*70002194*/
	0x0F12A806, /*70002196*/
	0x0F12C805, /*70002198*/
	0x0F120021, /*7000219A*/
	0x0F12F000, /*7000219C*/
	0x0F12F8B2, /*7000219E*/
	0x0F126030, /*700021A0*/
	0x0F12B00B, /*700021A2*/
	0x0F12BCF0, /*700021A4*/
	0x0F12BC08, /*700021A6*/
	0x0F124718, /*700021A8*/
	0x0F12B5F1, /*700021AA*/
	0x0F129900, /*700021AC*/
	0x0F12680C, /*700021AE*/
	0x0F12493A, /*700021B0*/
	0x0F12694B, /*700021B2*/
	0x0F12698A, /*700021B4*/
	0x0F124694, /*700021B6*/
	0x0F1269CD, /*700021B8*/
	0x0F126A0E, /*700021BA*/
	0x0F124F38, /*700021BC*/
	0x0F1242BC, /*700021BE*/
	0x0F12D800, /*700021C0*/
	0x0F120027, /*700021C2*/
	0x0F124937, /*700021C4*/
	0x0F126B89, /*700021C6*/
	0x0F120409, /*700021C8*/
	0x0F120C09, /*700021CA*/
	0x0F124A35, /*700021CC*/
	0x0F121E92, /*700021CE*/
	0x0F126BD2, /*700021D0*/
	0x0F120412, /*700021D2*/
	0x0F120C12, /*700021D4*/
	0x0F12429F, /*700021D6*/
	0x0F12D801, /*700021D8*/
	0x0F120020, /*700021DA*/
	0x0F12E031, /*700021DC*/
	0x0F12001F, /*700021DE*/
	0x0F12434F, /*700021E0*/
	0x0F120A3F, /*700021E2*/
	0x0F1242A7, /*700021E4*/
	0x0F12D301, /*700021E6*/
	0x0F120018, /*700021E8*/
	0x0F12E02A, /*700021EA*/
	0x0F12002B, /*700021EC*/
	0x0F12434B, /*700021EE*/
	0x0F120A1B, /*700021F0*/
	0x0F1242A3, /*700021F2*/
	0x0F12D303, /*700021F4*/
	0x0F120220, /*700021F6*/
	0x0F12F000, /*700021F8*/
	0x0F12F88C, /*700021FA*/
	0x0F12E021, /*700021FC*/
	0x0F120029, /*700021FE*/
	0x0F124351, /*70002200*/
	0x0F120A09, /*70002202*/
	0x0F1242A1, /*70002204*/
	0x0F12D301, /*70002206*/
	0x0F120028, /*70002208*/
	0x0F12E01A, /*7000220A*/
	0x0F120031, /*7000220C*/
	0x0F124351, /*7000220E*/
	0x0F120A09, /*70002210*/
	0x0F1242A1, /*70002212*/
	0x0F12D304, /*70002214*/
	0x0F120220, /*70002216*/
	0x0F120011, /*70002218*/
	0x0F12F000, /*7000221A*/
	0x0F12F87B, /*7000221C*/
	0x0F12E010, /*7000221E*/
	0x0F12491E, /*70002220*/
	0x0F128C89, /*70002222*/
	0x0F12000A, /*70002224*/
	0x0F124372, /*70002226*/
	0x0F120A12, /*70002228*/
	0x0F1242A2, /*7000222A*/
	0x0F12D301, /*7000222C*/
	0x0F120030, /*7000222E*/
	0x0F12E007, /*70002230*/
	0x0F124662, /*70002232*/
	0x0F12434A, /*70002234*/
	0x0F120A12, /*70002236*/
	0x0F1242A2, /*70002238*/
	0x0F12D302, /*7000223A*/
	0x0F120220, /*7000223C*/
	0x0F12F000, /*7000223E*/
	0x0F12F869, /*70002240*/
	0x0F124B16, /*70002242*/
	0x0F124D18, /*70002244*/
	0x0F128D99, /*70002246*/
	0x0F121FCA, /*70002248*/
	0x0F123AF9, /*7000224A*/
	0x0F12D00A, /*7000224C*/
	0x0F122001, /*7000224E*/
	0x0F120240, /*70002250*/
	0x0F128468, /*70002252*/
	0x0F120220, /*70002254*/
	0x0F12F000, /*70002256*/
	0x0F12F85D, /*70002258*/
	0x0F129900, /*7000225A*/
	0x0F126008, /*7000225C*/
	0x0F12BCF8, /*7000225E*/
	0x0F12BC08, /*70002260*/
	0x0F124718, /*70002262*/
	0x0F128D19, /*70002264*/
	0x0F128469, /*70002266*/
	0x0F129900, /*70002268*/
	0x0F126008, /*7000226A*/
	0x0F12E7F7, /*7000226C*/
	0x0F12B570, /*7000226E*/
	0x0F122200, /*70002270*/
	0x0F12490E, /*70002272*/
	0x0F12480E, /*70002274*/
	0x0F122401, /*70002276*/
	0x0F12F000, /*70002278*/
	0x0F12F852, /*7000227A*/
	0x0F120022, /*7000227C*/
	0x0F12490D, /*7000227E*/
	0x0F12480D, /*70002280*/
	0x0F122502, /*70002282*/
	0x0F12F000, /*70002284*/
	0x0F12F84C, /*70002286*/
	0x0F12490C, /*70002288*/
	0x0F12480D, /*7000228A*/
	0x0F12002A, /*7000228C*/
	0x0F12F000, /*7000228E*/
	0x0F12F847, /*70002290*/
	0x0F12BC70, /*70002292*/
	0x0F12BC08, /*70002294*/
	0x0F124718, /*70002296*/
	0x0F120D64, /*70002298*/
	0x0F127000, /*7000229A*/
	0x0F120470, /*7000229C*/
	0x0F127000, /*7000229E*/
	0x0F12A120, /*700022A0*/
	0x0F120007, /*700022A2*/
	0x0F120402, /*700022A4*/
	0x0F127000, /*700022A6*/
	0x0F1214A0, /*700022A8*/
	0x0F127000, /*700022AA*/
	0x0F12208D, /*700022AC*/
	0x0F127000, /*700022AE*/
	0x0F12622F, /*700022B0*/
	0x0F120000, /*700022B2*/
	0x0F121669, /*700022B4*/
	0x0F127000, /*700022B6*/
	0x0F126445, /*700022B8*/
	0x0F120000, /*700022BA*/
	0x0F1221AB, /*700022BC*/
	0x0F127000, /*700022BE*/
	0x0F122AA9, /*700022C0*/
	0x0F120000, /*700022C2*/
	0x0F124778, /*700022C4*/
	0x0F1246C0, /*700022C6*/
	0x0F12C000, /*700022C8*/
	0x0F12E59F, /*700022CA*/
	0x0F12FF1C, /*700022CC*/
	0x0F12E12F, /*700022CE*/
	0x0F125F49, /*700022D0*/
	0x0F120000, /*700022D2*/
	0x0F124778, /*700022D4*/
	0x0F1246C0, /*700022D6*/
	0x0F12C000, /*700022D8*/
	0x0F12E59F, /*700022DA*/
	0x0F12FF1C, /*700022DC*/
	0x0F12E12F, /*700022DE*/
	0x0F125FC7, /*700022E0*/
	0x0F120000, /*700022E2*/
	0x0F124778, /*700022E4*/
	0x0F1246C0, /*700022E6*/
	0x0F12C000, /*700022E8*/
	0x0F12E59F, /*700022EA*/
	0x0F12FF1C, /*700022EC*/
	0x0F12E12F, /*700022EE*/
	0x0F125457, /*700022F0*/
	0x0F120000, /*700022F2*/
	0x0F124778, /*700022F4*/
	0x0F1246C0, /*700022F6*/
	0x0F12C000, /*700022F8*/
	0x0F12E59F, /*700022FA*/
	0x0F12FF1C, /*700022FC*/
	0x0F12E12F, /*700022FE*/
	0x0F125FA3, /*70002300*/
	0x0F120000, /*70002302*/
	0x0F124778, /*70002304*/
	0x0F1246C0, /*70002306*/
	0x0F12C000, /*70002308*/
	0x0F12E59F, /*7000230A*/
	0x0F12FF1C, /*7000230C*/
	0x0F12E12F, /*7000230E*/
	0x0F1251F9, /*70002310*/
	0x0F120000, /*70002312*/
	0x0F124778, /*70002314*/
	0x0F1246C0, /*70002316*/
	0x0F12F004, /*70002318*/
	0x0F12E51F, /*7000231A*/
	0x0F12A464, /*7000231C*/
	0x0F120000, /*7000231E*/
	0x0F124778, /*70002320*/
	0x0F1246C0, /*70002322*/
	0x0F12C000, /*70002324*/
	0x0F12E59F, /*70002326*/
	0x0F12FF1C, /*70002328*/
	0x0F12E12F, /*7000232A*/
	0x0F12A007, /*7000232C*/
	0x0F120000, /*7000232E*/
	0x0F126546, /*70002330*/
	0x0F122062, /*70002332*/
	0x0F123120, /*70002334*/
	0x0F123220, /*70002336*/
	0x0F123130, /*70002338*/
	0x0F120030, /*7000233A*/
	0x0F12E010, /*7000233C*/
	0x0F120208, /*7000233E*/
	0x0F120058, /*70002340*/
	0x0F120000, /*70002342*/
	/* End of Trap and Patch
	Total Size 896 (0x0380)*/
	
	0x0028D000,
	0x002A1000,
	0x0F120001,
	
	
	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,
	
	
	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,
	
	
	0x00287000,
	0x002A0ADC,
	0x0F120AF0,
	0x002A0AE2,
	0x0F12222E,
	
	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */
	
	
	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,
	
	
	0x002AC202,
	0x0F120700,
	
	0x002AF260,
	0x0F120001,
	
	0x002AF414,
	0x0F120030,
	
	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,
	
	0x002AF700,
	0x0F120040,
	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,
	0x0F120015,
	0x0F120001,
	0x0F120040,
	
	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,
	
	
	0x002AF900,
	0x0F120067,
	
	
	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,
	
	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,
	
	0x002AF41A,
	0x0F1200FF,
	0x0F120003,
	
	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,
	
	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,
	
	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,
	
	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,
	
	0x002AF4D6,
	0x0F120090,
	
	
	0x0F120000,
	
	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,
	
	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,
	
	0x002AF418,
	0x0F120083,
	
	0x002AF454,
	0x0F120001,
	
	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,
	
	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,


	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,
	
	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,
	
	/* sensor aig table setting */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,
	
	
	0x002A1084,
	0x0F120000,
	0x0F120000,
	
	/* Set AE Target */
	0x002A0F4C,
	0x0F12003C, /* -- */
	
	0x002A0478,
	0x0F120114,
	0x0F1200EB,
	
	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A,
	0x0F120000,
	0x002A048C,
	0x0F128214,
	0x0F120000,
	0x0F12A122,
	0x0F120000,
	0x002A0488,
	0x0F12f424,
	0x0F120000,
	0x002A043A,
	0x0F120200,
	0x0F120200,
	0x002A0494,
	0x0F120300,
	0x0F120600,
	0x0f120100,
	0x002A0F52,
	0x0F12000F,
	
	0x002A0E98,
	0x0F1202A8,
	0x002A0E9E,
	0x0F120298,
	
	/* 1. Auto Flicker 60Hz Start */
	0x002A0B2E,
	0x0F120001,
	0x002A03F8,
	0x0F12005F,
	
	0xffff000a, /* Wait10mSec */
	
	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0,
	0x0F120000,
	
	/* Parallel or MIP Selection */
	0x002A01C6,
	0x0F120001,
	0x0F120001,
	0x0F120000,
	
	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770,
	0x0F122EE0,
	0x0F122EE0,
	
	/* System Clock 1 (System : 48Mhz, PCLK : 48Mhz) */
	0x002A01D2,                
	0x0F121B58,
	0x0F122EE0,
	0x0F122EE0,
	
	0x002A01DE,
	0x0F120001,
	0x0F120001,
	0xffff0064, /* 100ms Delay */
	
	/* Crop */
	0x002A01FA,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,
	
	/* Set Preview Config */
	/* Preview Config 0 (VGA fixed 25fps) */
	0x002A0242,
#if 0
	/*++ 640x480 */
	/* 0x0F120280, */ /* REG_0TC_PCFG_usWidth */
	/* 0x0F1201E0, */ /* REG_0TC_PCFG_usHeight */
	/*-- 640x480 */
#else
	/*++ 800x600 */
	0x0F120320, /* REG_0TC_PCFG_usWidth */
	0x0F120258, /* REG_0TC_PCFG_usHeight */
	/*-- 800x600 */
#endif
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052, /*-*/
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F1201A0, /*-535-*/
	0x0F1201A0, /*-29A-*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F12029A,
	0x0F12014D,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Set MIPI */
	0x002A03AC,
	0x0F120000,
	0x002A03F2,
	0x0F120001,
	0x0F1200C3,
	0x0F120001,
	
	/* Apply preview config */
	/* 0x002A021C, */
	/* 0x0F120000, */ /* REG_TC_GP_ActivePrevConfig */
	/* 0x002A0220, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevOpenAfterChange */
	/* 0x002A01F8, */
	/* 0x0F120001, */ /* REG_TC_GP_NewConfigSync */
	/* 0x002A021E, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevConfigChanged */
	/* 0x002A01F0, */
	/* 0x0F120001, */ /* REG_TC_GP_EnablePreview */
	/* 0x0F120001, */ /* REG_TC_GP_EnablePreviewChanged */
	
	
	
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000,
	0x0F120640,
	0x0F1204B0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120002,
	0x0F120002,
	0x0F120535,
	0x0F120535,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	0x002A07C0,
	0x0F120004,
	0x0F120004,
	
	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	
	
	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120302,
	0x0F120203,
	0x0F120101,
	0x0F120101,
	0x0F120403,
	0x0F120304,
	0x0F120101,
	0x0F120101,
	0x0F120403,
	0x0F120304,
	0x0F120101,
	0x0F120101,
	0x0F120302,
	0x0F120203,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	
	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,
	
	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,
	
	/* Target Brightness Control */
	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,
	
	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */
	
	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */
	
	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */
	
	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* 100 TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_*/
	
	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,
	
	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120160,
	0x0F120134,
	0x0F1200FF,
	0x0F1200D1,
	0x0F1200B1,
	0x0F12009D,
	0x0F120096,
	0x0F12009E,
	0x0F1200B3,
	0x0F1200D3,
	0x0F1200FF,
	0x0F120131,
	0x0F120159,
	0x0F12013C,
	0x0F120107,
	0x0F1200CD,
	0x0F1200A1,
	0x0F120080,
	0x0F12006B,
	0x0F120064,
	0x0F12006C,
	0x0F120080,
	0x0F1200A1,
	0x0F1200CD,
	0x0F120106,
	0x0F120139,
	0x0F120116,
	0x0F1200DC,
	0x0F1200A2,
	0x0F120073,
	0x0F120051,
	0x0F12003B,
	0x0F120033,
	0x0F12003B,
	0x0F120050,
	0x0F120073,
	0x0F1200A2,
	0x0F1200DD,
	0x0F120115,
	0x0F1200FA,
	0x0F1200BF,
	0x0F120085,
	0x0F120055,
	0x0F120031,
	0x0F12001B,
	0x0F120014,
	0x0F12001A,
	0x0F120031,
	0x0F120055,
	0x0F120085,
	0x0F1200C0,
	0x0F1200FB,
	0x0F1200EA,
	0x0F1200AF,
	0x0F120074,
	0x0F120045,
	0x0F120020,
	0x0F12000B,
	0x0F120003,
	0x0F12000A,
	0x0F120020,
	0x0F120046,
	0x0F120076,
	0x0F1200B1,
	0x0F1200ED,
	0x0F1200E6,
	0x0F1200AA,
	0x0F120071,
	0x0F120041,
	0x0F12001D,
	0x0F120008,
	0x0F120000,
	0x0F120007,
	0x0F12001E,
	0x0F120044,
	0x0F120074,
	0x0F1200B0,
	0x0F1200EC,
	0x0F1200EF,
	0x0F1200B3,
	0x0F12007A,
	0x0F12004A,
	0x0F120026,
	0x0F120011,
	0x0F12000A,
	0x0F120011,
	0x0F120029,
	0x0F12004F,
	0x0F120080,
	0x0F1200BC,
	0x0F1200F8,
	0x0F120105,
	0x0F1200C9,
	0x0F12008F,
	0x0F120060,
	0x0F12003C,
	0x0F120026,
	0x0F12001F,
	0x0F120028,
	0x0F120040,
	0x0F120066,
	0x0F120097,
	0x0F1200D4,
	0x0F120110,
	0x0F120124,
	0x0F1200EB,
	0x0F1200B1,
	0x0F120082,
	0x0F12005F,
	0x0F12004A,
	0x0F120043,
	0x0F12004C,
	0x0F120064,
	0x0F120089,
	0x0F1200BA,
	0x0F1200F8,
	0x0F12012F,
	0x0F120147,
	0x0F120116,
	0x0F1200DE,
	0x0F1200AF,
	0x0F12008E,
	0x0F12007A,
	0x0F120072,
	0x0F12007A,
	0x0F120091,
	0x0F1200B6,
	0x0F1200E8,
	0x0F120121,
	0x0F120150,
	0x0F120170,
	0x0F12013F,
	0x0F120110,
	0x0F1200E2,
	0x0F1200C0,
	0x0F1200AB,
	0x0F1200A4,
	0x0F1200AC,
	0x0F1200C3,
	0x0F1200E6,
	0x0F120117,
	0x0F120145,
	0x0F120172,
	0x0F120127,
	0x0F120100,
	0x0F1200CF,
	0x0F1200A7,
	0x0F12008D,
	0x0F12007D,
	0x0F120077,
	0x0F12007A,
	0x0F120087,
	0x0F12009E,
	0x0F1200C0,
	0x0F1200EC,
	0x0F12010F,
	0x0F120108,
	0x0F1200D8,
	0x0F1200A5,
	0x0F120080,
	0x0F120066,
	0x0F120056,
	0x0F12004F,
	0x0F120053,
	0x0F120061,
	0x0F120077,
	0x0F120098,
	0x0F1200C6,
	0x0F1200F3,
	0x0F1200E7,
	0x0F1200B4,
	0x0F120081,
	0x0F12005C,
	0x0F120041,
	0x0F120030,
	0x0F120029,
	0x0F12002E,
	0x0F12003D,
	0x0F120055,
	0x0F120076,
	0x0F1200A5,
	0x0F1200D4,
	0x0F1200CF,
	0x0F12009B,
	0x0F12006A,
	0x0F120043,
	0x0F120027,
	0x0F120016,
	0x0F12000F,
	0x0F120015,
	0x0F120025,
	0x0F12003E,
	0x0F120061,
	0x0F12008E,
	0x0F1200BF,
	0x0F1200C2,
	0x0F12008E,
	0x0F12005D,
	0x0F120037,
	0x0F12001A,
	0x0F120009,
	0x0F120002,
	0x0F120007,
	0x0F120018,
	0x0F120033,
	0x0F120057,
	0x0F120083,
	0x0F1200B3,
	0x0F1200BE,
	0x0F12008A,
	0x0F12005A,
	0x0F120034,
	0x0F120017,
	0x0F120006,
	0x0F120000,
	0x0F120006,
	0x0F120017,
	0x0F120033,
	0x0F120057,
	0x0F120083,
	0x0F1200B3,
	0x0F1200C5,
	0x0F120091,
	0x0F120061,
	0x0F12003B,
	0x0F120020,
	0x0F12000F,
	0x0F120009,
	0x0F120010,
	0x0F120021,
	0x0F12003D,
	0x0F120060,
	0x0F12008D,
	0x0F1200BE,
	0x0F1200D7,
	0x0F1200A2,
	0x0F120072,
	0x0F12004D,
	0x0F120032,
	0x0F120022,
	0x0F12001D,
	0x0F120024,
	0x0F120035,
	0x0F120050,
	0x0F120073,
	0x0F1200A0,
	0x0F1200D2,
	0x0F1200F0,
	0x0F1200BE,
	0x0F12008C,
	0x0F120068,
	0x0F12004F,
	0x0F120040,
	0x0F12003B,
	0x0F120041,
	0x0F120052,
	0x0F12006C,
	0x0F12008E,
	0x0F1200BE,
	0x0F1200ED,
	0x0F12010C,
	0x0F1200E1,
	0x0F1200AF,
	0x0F12008A,
	0x0F120072,
	0x0F120064,
	0x0F12005F,
	0x0F120065,
	0x0F120074,
	0x0F12008D,
	0x0F1200B2,
	0x0F1200E0,
	0x0F12010A,
	0x0F12012F,
	0x0F120104,
	0x0F1200D9,
	0x0F1200B3,
	0x0F120099,
	0x0F12008B,
	0x0F120086,
	0x0F12008B,
	0x0F12009B,
	0x0F1200B5,
	0x0F1200DA,
	0x0F120101,
	0x0F120128,
	0x0F12012F,
	0x0F120106,
	0x0F1200D4,
	0x0F1200AA,
	0x0F12008E,
	0x0F12007D,
	0x0F120079,
	0x0F120080,
	0x0F120093,
	0x0F1200B1,
	0x0F1200DC,
	0x0F12010C,
	0x0F120130,
	0x0F120112,
	0x0F1200E0,
	0x0F1200AB,
	0x0F120083,
	0x0F120067,
	0x0F120057,
	0x0F120051,
	0x0F120059,
	0x0F12006B,
	0x0F120089,
	0x0F1200B2,
	0x0F1200E5,
	0x0F120114,
	0x0F1200F2,
	0x0F1200BD,
	0x0F120088,
	0x0F120061,
	0x0F120044,
	0x0F120031,
	0x0F12002C,
	0x0F120033,
	0x0F120047,
	0x0F120065,
	0x0F12008C,
	0x0F1200C0,
	0x0F1200F3,
	0x0F1200DB,
	0x0F1200A5,
	0x0F120071,
	0x0F120049,
	0x0F12002A,
	0x0F120018,
	0x0F120011,
	0x0F120018,
	0x0F12002C,
	0x0F12004B,
	0x0F120072,
	0x0F1200A3,
	0x0F1200D7,
	0x0F1200CD,
	0x0F120097,
	0x0F120065,
	0x0F12003C,
	0x0F12001D,
	0x0F12000A,
	0x0F120003,
	0x0F120009,
	0x0F12001D,
	0x0F12003B,
	0x0F120063,
	0x0F120092,
	0x0F1200C4,
	0x0F1200CA,
	0x0F120094,
	0x0F120062,
	0x0F12003A,
	0x0F12001A,
	0x0F120007,
	0x0F120000,
	0x0F120006,
	0x0F120018,
	0x0F120036,
	0x0F12005C,
	0x0F12008A,
	0x0F1200BC,
	0x0F1200D1,
	0x0F12009B,
	0x0F120069,
	0x0F120042,
	0x0F120022,
	0x0F12000F,
	0x0F120008,
	0x0F12000D,
	0x0F12001F,
	0x0F12003B,
	0x0F120060,
	0x0F12008D,
	0x0F1200BF,
	0x0F1200E3,
	0x0F1200AC,
	0x0F12007A,
	0x0F120053,
	0x0F120035,
	0x0F120022,
	0x0F12001B,
	0x0F12001F,
	0x0F120030,
	0x0F12004B,
	0x0F12006D,
	0x0F12009C,
	0x0F1200CE,
	0x0F1200FE,
	0x0F1200C9,
	0x0F120095,
	0x0F12006F,
	0x0F120052,
	0x0F120040,
	0x0F120039,
	0x0F12003D,
	0x0F12004B,
	0x0F120063,
	0x0F120086,
	0x0F1200B5,
	0x0F1200E6,
	0x0F12011B,
	0x0F1200ED,
	0x0F1200BA,
	0x0F120092,
	0x0F120076,
	0x0F120065,
	0x0F12005D,
	0x0F120060,
	0x0F12006D,
	0x0F120084,
	0x0F1200A8,
	0x0F1200D6,
	0x0F120101,
	0x0F120140,
	0x0F120112,
	0x0F1200E5,
	0x0F1200BD,
	0x0F12009E,
	0x0F12008C,
	0x0F120085,
	0x0F120087,
	0x0F120094,
	0x0F1200AC,
	0x0F1200D0,
	0x0F1200F8,
	0x0F120123,
	0x0F1200F2,
	0x0F1200D1,
	0x0F1200A7,
	0x0F120087,
	0x0F120073,
	0x0F120067,
	0x0F120064,
	0x0F12006B,
	0x0F12007C,
	0x0F120094,
	0x0F1200B7,
	0x0F1200E1,
	0x0F1200FF,
	0x0F1200D6,
	0x0F1200AE,
	0x0F120085,
	0x0F120068,
	0x0F120054,
	0x0F120048,
	0x0F120045,
	0x0F12004B,
	0x0F12005B,
	0x0F120073,
	0x0F120093,
	0x0F1200BF,
	0x0F1200E9,
	0x0F1200B8,
	0x0F12008E,
	0x0F120066,
	0x0F120049,
	0x0F120035,
	0x0F120028,
	0x0F120025,
	0x0F12002B,
	0x0F12003B,
	0x0F120053,
	0x0F120072,
	0x0F12009D,
	0x0F1200C8,
	0x0F1200A2,
	0x0F120078,
	0x0F120051,
	0x0F120034,
	0x0F12001F,
	0x0F120012,
	0x0F12000E,
	0x0F120014,
	0x0F120024,
	0x0F12003B,
	0x0F12005B,
	0x0F120083,
	0x0F1200AD,
	0x0F120095,
	0x0F12006C,
	0x0F120046,
	0x0F12002A,
	0x0F120014,
	0x0F120007,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F12002D,
	0x0F12004C,
	0x0F120072,
	0x0F12009B,
	0x0F120093,
	0x0F12006A,
	0x0F120045,
	0x0F120028,
	0x0F120013,
	0x0F120005,
	0x0F120000,
	0x0F120004,
	0x0F120012,
	0x0F120028,
	0x0F120045,
	0x0F12006A,
	0x0F120093,
	0x0F12009B,
	0x0F120071,
	0x0F12004C,
	0x0F120030,
	0x0F12001A,
	0x0F12000C,
	0x0F120007,
	0x0F12000B,
	0x0F120018,
	0x0F12002C,
	0x0F120048,
	0x0F12006D,
	0x0F120097,
	0x0F1200AE,
	0x0F120083,
	0x0F12005C,
	0x0F120040,
	0x0F12002B,
	0x0F12001E,
	0x0F120018,
	0x0F12001C,
	0x0F120027,
	0x0F12003A,
	0x0F120055,
	0x0F12007B,
	0x0F1200A6,
	0x0F1200CA,
	0x0F12009E,
	0x0F120076,
	0x0F120059,
	0x0F120046,
	0x0F120039,
	0x0F120033,
	0x0F120036,
	0x0F120040,
	0x0F120052,
	0x0F12006C,
	0x0F120094,
	0x0F1200BF,
	0x0F1200EB,
	0x0F1200C3,
	0x0F120099,
	0x0F12007A,
	0x0F120066,
	0x0F12005A,
	0x0F120054,
	0x0F120056,
	0x0F12005F,
	0x0F120071,
	0x0F12008D,
	0x0F1200B6,
	0x0F1200DE,
	0x0F12010D,
	0x0F1200E7,
	0x0F1200C1,
	0x0F1200A0,
	0x0F12008A,
	0x0F12007C,
	0x0F120076,
	0x0F120078,
	0x0F120081,
	0x0F120093,
	0x0F1200B1,
	0x0F1200D5,
	0x0F1200FD,
	
	/* Gamma */
	0x002A04CC,
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone	       */
	0x0F120000, /* awbb_LowBr0_NBzone       */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv       */
	
	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F1203B4, /*038F awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F1203C0, /*039B awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F12037C, /*0373 awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203C8, /*03B0 awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F12035E, /*0352 awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203C8, /*03B7 awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120340, /*0334 awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203C0, /*03B5 awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120328, /*0318 awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203B0, /*03B0 awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F120310, /*02FF awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12039E, /*038D awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202FA, /*02E7 awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120384, /*0372 awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202DC, /*02D0 awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12036C, /*035D awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202CA, /*02B5 awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F12035A, /*0345 awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202B4, /*02A1 awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F120340, /*0331 awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12029E, /*028B awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F120324, /*031E awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F12028C, /*0273 awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120306, /*0309 awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F12027A, /*025F awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202F6, /*02F5 awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F12026A, /*0250 awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202E4, /*02DB awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F12025A, /*0241 awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202DA, /*02C7 awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F12024C, /*0233 awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202CE, /*02B9 awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F12023A, /*0223 awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202C4, /*02AB awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120230, /*0217 awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F1202B8, /*02A2 awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120220, /*0207 awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F1202AC, /*0294 awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F120212, /*01FA awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F1202AA, /*0289 awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F120204, /*01EA awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F1202A6, /*0281 awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201FA, /*01DD awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F1202A0, /*027B awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201EE, /*01D0 awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F12029C, /*0273 awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201E0, /*01C3 awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F120294, /*026A awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201D4, /*01B6 awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F12028A, /*0265 awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201C8, /*01AB awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F120282, /*025B awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201C0, /*01A1 awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F12027A, /*0254 awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F1201BC, /*0198 awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F120272, /*024B awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F1201B8, /*0192 awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120262, /*0242 awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F1201BC, /*0191 awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F12024E, /*023A awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F1201EC, /*0192 awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120206, /*0222 awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F120000, /*01C5 awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F120000, /*01DF awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */
	
	
	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F12001F,
	0x0F120000,
	0x0F12010E,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,
	
	/* Outdoor Gray Zone */
	0x0F12025E, /*025E*/
	0x0F120282, /*0282*/
	0x0F120246, /*0240*/
	0x0F12029E, /*0298*/
	0x0F120230, /*022A*/
	0x0F1202A0, /*029A*/
	0x0F120220, /*021A*/
	0x0F1202A0, /*029A*/
	0x0F12020E, /*0206*/
	0x0F12029E, /*0298*/
	0x0F120206, /*01FE*/
	0x0F120292, /*028C*/
	0x0F120200, /*01FA*/
	0x0F12027E, /*0278*/
	0x0F1201FE, /*01F8*/
	0x0F12026A, /*0266*/
	0x0F12021A, /*0214*/
	0x0F12023E, /*0238*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	
	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120208,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,
	
	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */
	
	
	/* 42param_end awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,
	
	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,
	
	
	/* Duks add*/
	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */
	
	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_0__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__2_       */
	0x0F120050, /*0050 awbb_GridCorr_R_0__3_       */
	0x0F120000, /*FFF0 awbb_GridCorr_R_0__4_       */
	0x0F12005A, /*005A awbb_GridCorr_R_0__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__2_       */
	0x0F120050, /*0050 awbb_GridCorr_R_1__3_       */
	0x0F120000, /*FFF0 awbb_GridCorr_R_1__4_       */
	0x0F12005A, /*005A awbb_GridCorr_R_1__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__2_       */
	0x0F120050, /*0050 awbb_GridCorr_R_2__3_       */
	0x0F120000, /*FFF0 awbb_GridCorr_R_2__4_       */
	0x0F12005A, /*005A awbb_GridCorr_R_2__5_       */
	
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_0__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_0__1_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_0__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_0__3_     */
	0x0F12FF88, /*FFAC awbb_GridCorr_B_0__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_0__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_1__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_1__1_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_1__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_1__3_     */
	0x0F12FF88, /*FFAC awbb_GridCorr_B_1__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_1__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_2__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_2__1_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_2__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_2__3_     */
	0x0F12FF88, /*FFAC awbb_GridCorr_B_2__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_2__5_     */
	
	0x0F1202EA, /*awbb_GridConst_1_0_    */
	0x0F120335, /*awbb_GridConst_1_1_    */
	0x0F120388, /*awbb_GridConst_1_2_    */
	
	0x0F121032, /*1032 awbb_GridConst_2_0    */
	0x0F1210B2, /*10B2 awbb_GridConst_2_1    */
	0x0F121140, /*1124 awbb_GridConst_2_2    */
	0x0F121141, /*112A awbb_GridConst_2_3    */
	0x0F1211BE, /*11A4 awbb_GridConst_2_4    */
	0x0F12124C, /*1272 awbb_GridConst_2_5    */
	
	0x0F1200B3, /*awbb_GridCoeff_R_1    */
	0x0F1200B7, /*awbb_GridCoeff_B_1    */
	0x0F1200D3, /*awbb_GridCoeff_R_2    */
	0x0F120091, /*awbb_GridCoeff_B_2    */
	
	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,  /*--- 52A awbb_MvEq_RBthresh */
	
	/* Gamut Thresholds */
	0x002A0DAA,
	0x0F120664, /*--- 71A */
	0x0F120355, /*--- 3A4 */
	0x002A0DAE,
	0x0F12002C, /*--- 36 */
	0x0F120024, /*--- 1C */
	
	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120E01,
	0x0F120096,
	0x002A0E86,
	0x0F120256, /*-- 256 */
	0x0F120248, /*-- 248 */
	0x002A0D96,
	0x0F120E00,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F12041B, /* 459 awbb_LowTempRB */
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,
	
	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,
	
	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,
	
	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,
	
	/* awbb_ChromaClassifyEn, default : enable*/
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120258,
	0x0F120003,
	
	
	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,
	
	/* CCM */
	0x002A2800,
	0x0F12010D, /*-0136---*/  /* H */
	0x0F12FFA7, /*-FF8B---*/
	0x0F12FFF5, /*-FFE8---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/
	
	0x0F12010D, /*-010D---*/  /* A */
	0x0F12FFA7, /*-FFA7---*/
	0x0F12FFF5, /*-FFF5---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/
	
	0x0F120205, /*01A5   01A5*/  /* WW */
	0x0F12FF92, /*FF9D   FF9D*/
	0x0F12FFE6, /*FFE1   FFE1*/
	0x0F1200FE, /*00F2   00D9*/
	0x0F1200E2, /*0116   0153*/
	0x0F12FF33, /*FF48   FF25*/
	0x0F12FF1E, /*FF3A   FF25*/
	0x0F120222, /*0263   028C*/
	0x0F12FF68, /*FF3A   FF25*/
	0x0F12FF03, /*FEBF   FEBF*/
	0x0F120207, /*01B6   01B6*/
	0x0F120113, /*00F7   00F7*/
	0x0F12FFE3, /*FF81   FF81*/
	0x0F12FFC0, /*FF8C   FF8C*/
	0x0F120181, /*01AE   01AE*/
	0x0F120164, /*00FC   00FC*/
	0x0F12FF55, /*FF48   FF48*/
	0x0F120163, /*010D   010D*/
	
	0x0F120205, /*01BD  01BD*/  /* CW */
	0x0F12FF92, /*FF89  FF89*/
	0x0F12FFE6, /*FFDE  FFDE*/
	0x0F1200FE, /*00C9  0098*/
	0x0F1200E2, /*00B1  00B8*/
	0x0F12FF33, /*FF3F  FF69*/
	0x0F12FF1E, /*FF2D  FF15*/
	0x0F120222, /*0230  025A*/
	0x0F12FF68, /*FF77  FF65*/
	0x0F12FF03, /*FF03  FF03*/
	0x0F120207, /*0207  0207*/
	0x0F120113, /*0113  0113*/
	0x0F12FFE3, /*FFDA  FFDA*/
	0x0F12FFC0, /*FFB8  FFB8*/
	0x0F120181, /*0166  0166*/
	0x0F120164, /*0164  0164*/
	0x0F12FF55, /*FF55  FF55*/
	0x0F120163, /*0163  0163*/
	
	0x0F12018A, /*-0171---*/  /* D50 */
	0x0F12FFC1, /*-FFAF---*/
	0x0F12FFF5, /*-FFF3---*/
	0x0F120086, /*-0086---*/
	0x0F1200D2, /*-00D2---*/
	0x0F12FF73, /*-FF73---*/
	0x0F12FF0B, /*-FF17---*/
	0x0F120232, /*-022B---*/
	0x0F12FF49, /*-FF54---*/
	0x0F12FF43, /*-FF43---*/
	0x0F1201BA, /*-01BA---*/
	0x0F1200F3, /*-00F3---*/
	0x0F12FFE2, /*-FFF6---*/
	0x0F12FFB6, /*-FFD0---*/
	0x0F1201E6, /*-01B8---*/
	0x0F12018F, /*-018F---*/
	0x0F12FF8C, /*-FF8C---*/
	0x0F120137, /*-0137---*/
	
	0x0F12018A, /*-0180---*/  /* D65 */   
	0x0F12FFC1, /*-FFC2---*/
	0x0F12FFF5, /*-FFFD---*/
	0x0F120086, /*-0086---*/
	0x0F1200D2, /*-00D2---*/
	0x0F12FF73, /*-FF73---*/
	0x0F12FF0B, /*-FF25---*/
	0x0F120232, /*-022B---*/
	0x0F12FF49, /*-FF61---*/
	0x0F12FF43, /*-FF43---*/
	0x0F1201BA, /*-01BA---*/
	0x0F1200F3, /*-00F3---*/
	0x0F12FFE2, /*-FFED---*/
	0x0F12FFB6, /*-FFC4---*/
	0x0F1201E6, /*-01CD---*/
	0x0F12018F, /*-018F---*/
	0x0F12FF8C, /*-FF8C---*/
	0x0F120137, /*-0137---*/
	
	0x0F1201CC, /*----*/ /* OUT */
	0x0F12FFC3, /*----*/
	0x0F120009, /*----*/
	0x0F12009D, /*----*/
	0x0F1200FA, /*----*/
	0x0F12FF50, /*----*/
	0x0F12FED8, /*----*/
	0x0F1201FE, /*----*/
	0x0F12FF08, /*----*/
	0x0F12FEC7, /*----*/
	0x0F1200F5, /*----*/
	0x0F120119, /*----*/
	0x0F12FFDF, /*----*/
	0x0F120024, /*----*/
	0x0F1201A8, /*----*/
	0x0F120170, /*----*/
	0x0F12FFAD, /*----*/
	0x0F12011B, /*----*/
	
	/* Set NB */
	0x002A07EA,
	0x0F120000,
	
	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A,
	0x0F120019,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,
	
	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A,
	0x0F120019,
	0x0F12007D,
	0x0F1202BC,
	0x0F1207D0,

	
	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,
	
	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F1203FF, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120344, /* UVDenoise_iYLowThresh                                              */
	0x0F12033A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120012, /*  RGB2YUV_iYOffset                                                  */
	
	0x002A08AA, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120016, /* 14 Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120072, /* 64 Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120114, /* UVDenoise_iYLowThresh                                              */
	0x0F12020A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12200A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120009, /*  RGB2YUV_iYOffset                                                  */
	
	0x002A0928, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120012, /* 0C Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006E, /* 60 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */
	
	0x002A09A6, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006C, /* 5A Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */
	
	0x002A0A24, /* --                                                         */
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120068, /* 50 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120000, /* UVDenoise_iYLowThresh                                              */
	0x0F120000, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */
	
	0x002A0AA2, /* --                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshLow                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                         */
	0x0F120800, /* Denoise1_sensor_width                             */
	0x0F120600, /* Denoise1_sensor_height                            */
	0x0F120000, /* Denoise1_start_x                                  */
	0x0F120000, /* Denoise1_start_y                                  */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "          */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "        */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  "  */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "           */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "         */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "      */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "     */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh" */
	0x0F120000, /*  Demosaic4_iBypassSelect                          */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,
	
	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001,
	
	0x0028D000,
	0x002AB0CC,
	0x0F12000B,

	/* Recording 25fps Anti-Flicker 60Hz END of Initial */
};
#else
/* Recording with 25fps */
static const u32 s5k5bafx_recording_50Hz_common[] = {

	/* recording 25fps Anti-Flicker 50Hz*/
	
	0xFCFCD000,
	
	/* ARM Go */
	0x0028D000,
	0x002A1030,
	0x0F120000,
	0x002A0014,
	0x0F120001,
	0xffff0064, /* p100	Delay */
	
	
	/* Trap and Patch  2008-11-18 10:15:41 */
	0x00287000,
	0x002A1668,
	0x0F12B5FE, /*70001668*/
	0x0F120007, /*7000166A*/
	0x0F12683C, /*7000166C*/
	0x0F12687E, /*7000166E*/
	0x0F121DA5, /*70001670*/
	0x0F1288A0, /*70001672*/
	0x0F122800, /*70001674*/
	0x0F12D00B, /*70001676*/
	0x0F1288A8, /*70001678*/
	0x0F122800, /*7000167A*/
	0x0F12D008, /*7000167C*/
	0x0F128820, /*7000167E*/
	0x0F128829, /*70001680*/
	0x0F124288, /*70001682*/
	0x0F12D301, /*70001684*/
	0x0F121A40, /*70001686*/
	0x0F12E000, /*70001688*/
	0x0F121A08, /*7000168A*/
	0x0F129001, /*7000168C*/
	0x0F12E001, /*7000168E*/
	0x0F122019, /*70001690*/
	0x0F129001, /*70001692*/
	0x0F124916, /*70001694*/
	0x0F12466B, /*70001696*/
	0x0F128A48, /*70001698*/
	0x0F128118, /*7000169A*/
	0x0F128A88, /*7000169C*/
	0x0F128158, /*7000169E*/
	0x0F124814, /*700016A0*/
	0x0F128940, /*700016A2*/
	0x0F120040, /*700016A4*/
	0x0F122103, /*700016A6*/
	0x0F12F000, /*700016A8*/
	0x0F12F826, /*700016AA*/
	0x0F1288A1, /*700016AC*/
	0x0F124288, /*700016AE*/
	0x0F12D908, /*700016B0*/
	0x0F128828, /*700016B2*/
	0x0F128030, /*700016B4*/
	0x0F128868, /*700016B6*/
	0x0F128070, /*700016B8*/
	0x0F1288A8, /*700016BA*/
	0x0F126038, /*700016BC*/
	0x0F12BCFE, /*700016BE*/
	0x0F12BC08, /*700016C0*/
	0x0F124718, /*700016C2*/
	0x0F1288A9, /*700016C4*/
	0x0F124288, /*700016C6*/
	0x0F12D906, /*700016C8*/
	0x0F128820, /*700016CA*/
	0x0F128030, /*700016CC*/
	0x0F128860, /*700016CE*/
	0x0F128070, /*700016D0*/
	0x0F1288A0, /*700016D2*/
	0x0F126038, /*700016D4*/
	0x0F12E7F2, /*700016D6*/
	0x0F129801, /*700016D8*/
	0x0F12A902, /*700016DA*/
	0x0F12F000, /*700016DC*/
	0x0F12F812, /*700016DE*/
	0x0F120033, /*700016E0*/
	0x0F120029, /*700016E2*/
	0x0F129A02, /*700016E4*/
	0x0F120020, /*700016E6*/
	0x0F12F000, /*700016E8*/
	0x0F12F814, /*700016EA*/
	0x0F126038, /*700016EC*/
	0x0F12E7E6, /*700016EE*/
	0x0F121A28, /*700016F0*/
	0x0F127000, /*700016F2*/
	0x0F120D64, /*700016F4*/
	0x0F127000, /*700016F6*/
	0x0F124778, /*700016F8*/
	0x0F1246C0, /*700016FA*/
	0x0F12F004, /*700016FC*/
	0x0F12E51F, /*700016FE*/
	0x0F12A464, /*70001700*/
	0x0F120000, /*70001702*/
	0x0F124778, /*70001704*/
	0x0F1246C0, /*70001706*/
	0x0F12C000, /*70001708*/
	0x0F12E59F, /*7000170A*/
	0x0F12FF1C, /*7000170C*/
	0x0F12E12F, /*7000170E*/
	0x0F126009, /*70001710*/
	0x0F120000, /*70001712*/
	0x0F124778, /*70001714*/
	0x0F1246C0, /*70001716*/
	0x0F12C000, /*70001718*/
	0x0F12E59F, /*7000171A*/
	0x0F12FF1C, /*7000171C*/
	0x0F12E12F, /*7000171E*/
	0x0F12622F, /*70001720*/
	0x0F120000, /*70001722*/
	0x002A2080,
	0x0F12B510, /*70002080*/
	0x0F12F000, /*70002082*/
	0x0F12F8F4, /*70002084*/
	0x0F12BC10, /*70002086*/
	0x0F12BC08, /*70002088*/
	0x0F124718, /*7000208A*/
	0x0F12B5F0, /*7000208C*/
	0x0F12B08B, /*7000208E*/
	0x0F120006, /*70002090*/
	0x0F122000, /*70002092*/
	0x0F129004, /*70002094*/
	0x0F126835, /*70002096*/
	0x0F126874, /*70002098*/
	0x0F1268B0, /*7000209A*/
	0x0F12900A, /*7000209C*/
	0x0F1268F0, /*7000209E*/
	0x0F129009, /*700020A0*/
	0x0F124F7D, /*700020A2*/
	0x0F128979, /*700020A4*/
	0x0F12084A, /*700020A6*/
	0x0F1288A8, /*700020A8*/
	0x0F1288A3, /*700020AA*/
	0x0F124298, /*700020AC*/
	0x0F12D300, /*700020AE*/
	0x0F120018, /*700020B0*/
	0x0F12F000, /*700020B2*/
	0x0F12F907, /*700020B4*/
	0x0F129007, /*700020B6*/
	0x0F120021, /*700020B8*/
	0x0F120028, /*700020BA*/
	0x0F12AA04, /*700020BC*/
	0x0F12F000, /*700020BE*/
	0x0F12F909, /*700020C0*/
	0x0F129006, /*700020C2*/
	0x0F1288A8, /*700020C4*/
	0x0F122800, /*700020C6*/
	0x0F12D102, /*700020C8*/
	0x0F1227FF, /*700020CA*/
	0x0F121C7F, /*700020CC*/
	0x0F12E047, /*700020CE*/
	0x0F1288A0, /*700020D0*/
	0x0F122800, /*700020D2*/
	0x0F12D101, /*700020D4*/
	0x0F122700, /*700020D6*/
	0x0F12E042, /*700020D8*/
	0x0F128820, /*700020DA*/
	0x0F12466B, /*700020DC*/
	0x0F128198, /*700020DE*/
	0x0F128860, /*700020E0*/
	0x0F1281D8, /*700020E2*/
	0x0F128828, /*700020E4*/
	0x0F128118, /*700020E6*/
	0x0F128868, /*700020E8*/
	0x0F128158, /*700020EA*/
	0x0F12A802, /*700020EC*/
	0x0F12C803, /*700020EE*/
	0x0F12F000, /*700020F0*/
	0x0F12F8F8, /*700020F2*/
	0x0F129008, /*700020F4*/
	0x0F128ABA, /*700020F6*/
	0x0F129808, /*700020F8*/
	0x0F12466B, /*700020FA*/
	0x0F124342, /*700020FC*/
	0x0F129202, /*700020FE*/
	0x0F128820, /*70002100*/
	0x0F128198, /*70002102*/
	0x0F128860, /*70002104*/
	0x0F1281D8, /*70002106*/
	0x0F12980A, /*70002108*/
	0x0F129903, /*7000210A*/
	0x0F12F000, /*7000210C*/
	0x0F12F8EA, /*7000210E*/
	0x0F129A02, /*70002110*/
	0x0F1217D1, /*70002112*/
	0x0F120E09, /*70002114*/
	0x0F121889, /*70002116*/
	0x0F121209, /*70002118*/
	0x0F124288, /*7000211A*/
	0x0F12DD1F, /*7000211C*/
	0x0F128820, /*7000211E*/
	0x0F12466B, /*70002120*/
	0x0F128198, /*70002122*/
	0x0F128860, /*70002124*/
	0x0F1281D8, /*70002126*/
	0x0F12980A, /*70002128*/
	0x0F129903, /*7000212A*/
	0x0F12F000, /*7000212C*/
	0x0F12F8DA, /*7000212E*/
	0x0F129001, /*70002130*/
	0x0F128828, /*70002132*/
	0x0F12466B, /*70002134*/
	0x0F128118, /*70002136*/
	0x0F128868, /*70002138*/
	0x0F128158, /*7000213A*/
	0x0F12980A, /*7000213C*/
	0x0F129902, /*7000213E*/
	0x0F12F000, /*70002140*/
	0x0F12F8D0, /*70002142*/
	0x0F128AB9, /*70002144*/
	0x0F129A08, /*70002146*/
	0x0F124351, /*70002148*/
	0x0F1217CA, /*7000214A*/
	0x0F120E12, /*7000214C*/
	0x0F121851, /*7000214E*/
	0x0F12120A, /*70002150*/
	0x0F129901, /*70002152*/
	0x0F12F000, /*70002154*/
	0x0F12F8B6, /*70002156*/
	0x0F120407, /*70002158*/
	0x0F120C3F, /*7000215A*/
	0x0F12E000, /*7000215C*/
	0x0F122700, /*7000215E*/
	0x0F128820, /*70002160*/
	0x0F12466B, /*70002162*/
	0x0F12AA05, /*70002164*/
	0x0F128198, /*70002166*/
	0x0F128860, /*70002168*/
	0x0F1281D8, /*7000216A*/
	0x0F128828, /*7000216C*/
	0x0F128118, /*7000216E*/
	0x0F128868, /*70002170*/
	0x0F128158, /*70002172*/
	0x0F12A802, /*70002174*/
	0x0F12C803, /*70002176*/
	0x0F12003B, /*70002178*/
	0x0F12F000, /*7000217A*/
	0x0F12F8BB, /*7000217C*/
	0x0F1288A1, /*7000217E*/
	0x0F1288A8, /*70002180*/
	0x0F12003A, /*70002182*/
	0x0F12F000, /*70002184*/
	0x0F12F8BE, /*70002186*/
	0x0F120004, /*70002188*/
	0x0F12A804, /*7000218A*/
	0x0F12C803, /*7000218C*/
	0x0F129A09, /*7000218E*/
	0x0F129B07, /*70002190*/
	0x0F12F000, /*70002192*/
	0x0F12F8AF, /*70002194*/
	0x0F12A806, /*70002196*/
	0x0F12C805, /*70002198*/
	0x0F120021, /*7000219A*/
	0x0F12F000, /*7000219C*/
	0x0F12F8B2, /*7000219E*/
	0x0F126030, /*700021A0*/
	0x0F12B00B, /*700021A2*/
	0x0F12BCF0, /*700021A4*/
	0x0F12BC08, /*700021A6*/
	0x0F124718, /*700021A8*/
	0x0F12B5F1, /*700021AA*/
	0x0F129900, /*700021AC*/
	0x0F12680C, /*700021AE*/
	0x0F12493A, /*700021B0*/
	0x0F12694B, /*700021B2*/
	0x0F12698A, /*700021B4*/
	0x0F124694, /*700021B6*/
	0x0F1269CD, /*700021B8*/
	0x0F126A0E, /*700021BA*/
	0x0F124F38, /*700021BC*/
	0x0F1242BC, /*700021BE*/
	0x0F12D800, /*700021C0*/
	0x0F120027, /*700021C2*/
	0x0F124937, /*700021C4*/
	0x0F126B89, /*700021C6*/
	0x0F120409, /*700021C8*/
	0x0F120C09, /*700021CA*/
	0x0F124A35, /*700021CC*/
	0x0F121E92, /*700021CE*/
	0x0F126BD2, /*700021D0*/
	0x0F120412, /*700021D2*/
	0x0F120C12, /*700021D4*/
	0x0F12429F, /*700021D6*/
	0x0F12D801, /*700021D8*/
	0x0F120020, /*700021DA*/
	0x0F12E031, /*700021DC*/
	0x0F12001F, /*700021DE*/
	0x0F12434F, /*700021E0*/
	0x0F120A3F, /*700021E2*/
	0x0F1242A7, /*700021E4*/
	0x0F12D301, /*700021E6*/
	0x0F120018, /*700021E8*/
	0x0F12E02A, /*700021EA*/
	0x0F12002B, /*700021EC*/
	0x0F12434B, /*700021EE*/
	0x0F120A1B, /*700021F0*/
	0x0F1242A3, /*700021F2*/
	0x0F12D303, /*700021F4*/
	0x0F120220, /*700021F6*/
	0x0F12F000, /*700021F8*/
	0x0F12F88C, /*700021FA*/
	0x0F12E021, /*700021FC*/
	0x0F120029, /*700021FE*/
	0x0F124351, /*70002200*/
	0x0F120A09, /*70002202*/
	0x0F1242A1, /*70002204*/
	0x0F12D301, /*70002206*/
	0x0F120028, /*70002208*/
	0x0F12E01A, /*7000220A*/
	0x0F120031, /*7000220C*/
	0x0F124351, /*7000220E*/
	0x0F120A09, /*70002210*/
	0x0F1242A1, /*70002212*/
	0x0F12D304, /*70002214*/
	0x0F120220, /*70002216*/
	0x0F120011, /*70002218*/
	0x0F12F000, /*7000221A*/
	0x0F12F87B, /*7000221C*/
	0x0F12E010, /*7000221E*/
	0x0F12491E, /*70002220*/
	0x0F128C89, /*70002222*/
	0x0F12000A, /*70002224*/
	0x0F124372, /*70002226*/
	0x0F120A12, /*70002228*/
	0x0F1242A2, /*7000222A*/
	0x0F12D301, /*7000222C*/
	0x0F120030, /*7000222E*/
	0x0F12E007, /*70002230*/
	0x0F124662, /*70002232*/
	0x0F12434A, /*70002234*/
	0x0F120A12, /*70002236*/
	0x0F1242A2, /*70002238*/
	0x0F12D302, /*7000223A*/
	0x0F120220, /*7000223C*/
	0x0F12F000, /*7000223E*/
	0x0F12F869, /*70002240*/
	0x0F124B16, /*70002242*/
	0x0F124D18, /*70002244*/
	0x0F128D99, /*70002246*/
	0x0F121FCA, /*70002248*/
	0x0F123AF9, /*7000224A*/
	0x0F12D00A, /*7000224C*/
	0x0F122001, /*7000224E*/
	0x0F120240, /*70002250*/
	0x0F128468, /*70002252*/
	0x0F120220, /*70002254*/
	0x0F12F000, /*70002256*/
	0x0F12F85D, /*70002258*/
	0x0F129900, /*7000225A*/
	0x0F126008, /*7000225C*/
	0x0F12BCF8, /*7000225E*/
	0x0F12BC08, /*70002260*/
	0x0F124718, /*70002262*/
	0x0F128D19, /*70002264*/
	0x0F128469, /*70002266*/
	0x0F129900, /*70002268*/
	0x0F126008, /*7000226A*/
	0x0F12E7F7, /*7000226C*/
	0x0F12B570, /*7000226E*/
	0x0F122200, /*70002270*/
	0x0F12490E, /*70002272*/
	0x0F12480E, /*70002274*/
	0x0F122401, /*70002276*/
	0x0F12F000, /*70002278*/
	0x0F12F852, /*7000227A*/
	0x0F120022, /*7000227C*/
	0x0F12490D, /*7000227E*/
	0x0F12480D, /*70002280*/
	0x0F122502, /*70002282*/
	0x0F12F000, /*70002284*/
	0x0F12F84C, /*70002286*/
	0x0F12490C, /*70002288*/
	0x0F12480D, /*7000228A*/
	0x0F12002A, /*7000228C*/
	0x0F12F000, /*7000228E*/
	0x0F12F847, /*70002290*/
	0x0F12BC70, /*70002292*/
	0x0F12BC08, /*70002294*/
	0x0F124718, /*70002296*/
	0x0F120D64, /*70002298*/
	0x0F127000, /*7000229A*/
	0x0F120470, /*7000229C*/
	0x0F127000, /*7000229E*/
	0x0F12A120, /*700022A0*/
	0x0F120007, /*700022A2*/
	0x0F120402, /*700022A4*/
	0x0F127000, /*700022A6*/
	0x0F1214A0, /*700022A8*/
	0x0F127000, /*700022AA*/
	0x0F12208D, /*700022AC*/
	0x0F127000, /*700022AE*/
	0x0F12622F, /*700022B0*/
	0x0F120000, /*700022B2*/
	0x0F121669, /*700022B4*/
	0x0F127000, /*700022B6*/
	0x0F126445, /*700022B8*/
	0x0F120000, /*700022BA*/
	0x0F1221AB, /*700022BC*/
	0x0F127000, /*700022BE*/
	0x0F122AA9, /*700022C0*/
	0x0F120000, /*700022C2*/
	0x0F124778, /*700022C4*/
	0x0F1246C0, /*700022C6*/
	0x0F12C000, /*700022C8*/
	0x0F12E59F, /*700022CA*/
	0x0F12FF1C, /*700022CC*/
	0x0F12E12F, /*700022CE*/
	0x0F125F49, /*700022D0*/
	0x0F120000, /*700022D2*/
	0x0F124778, /*700022D4*/
	0x0F1246C0, /*700022D6*/
	0x0F12C000, /*700022D8*/
	0x0F12E59F, /*700022DA*/
	0x0F12FF1C, /*700022DC*/
	0x0F12E12F, /*700022DE*/
	0x0F125FC7, /*700022E0*/
	0x0F120000, /*700022E2*/
	0x0F124778, /*700022E4*/
	0x0F1246C0, /*700022E6*/
	0x0F12C000, /*700022E8*/
	0x0F12E59F, /*700022EA*/
	0x0F12FF1C, /*700022EC*/
	0x0F12E12F, /*700022EE*/
	0x0F125457, /*700022F0*/
	0x0F120000, /*700022F2*/
	0x0F124778, /*700022F4*/
	0x0F1246C0, /*700022F6*/
	0x0F12C000, /*700022F8*/
	0x0F12E59F, /*700022FA*/
	0x0F12FF1C, /*700022FC*/
	0x0F12E12F, /*700022FE*/
	0x0F125FA3, /*70002300*/
	0x0F120000, /*70002302*/
	0x0F124778, /*70002304*/
	0x0F1246C0, /*70002306*/
	0x0F12C000, /*70002308*/
	0x0F12E59F, /*7000230A*/
	0x0F12FF1C, /*7000230C*/
	0x0F12E12F, /*7000230E*/
	0x0F1251F9, /*70002310*/
	0x0F120000, /*70002312*/
	0x0F124778, /*70002314*/
	0x0F1246C0, /*70002316*/
	0x0F12F004, /*70002318*/
	0x0F12E51F, /*7000231A*/
	0x0F12A464, /*7000231C*/
	0x0F120000, /*7000231E*/
	0x0F124778, /*70002320*/
	0x0F1246C0, /*70002322*/
	0x0F12C000, /*70002324*/
	0x0F12E59F, /*70002326*/
	0x0F12FF1C, /*70002328*/
	0x0F12E12F, /*7000232A*/
	0x0F12A007, /*7000232C*/
	0x0F120000, /*7000232E*/
	0x0F126546, /*70002330*/
	0x0F122062, /*70002332*/
	0x0F123120, /*70002334*/
	0x0F123220, /*70002336*/
	0x0F123130, /*70002338*/
	0x0F120030, /*7000233A*/
	0x0F12E010, /*7000233C*/
	0x0F120208, /*7000233E*/
	0x0F120058, /*70002340*/
	0x0F120000, /*70002342*/
	/* End of Trap and Patch
	Total Size 896 (0x0380)*/
	
	0x0028D000,
	0x002A1000,
	0x0F120001,
	
	
	0x00287000,
	0x002A1662,
	0x0F1203B0,
	0x0F1203B0,
	
	
	0x00287000,
	0x002A1658,
	0x0F129C40,
	0x0F120000,
	0x0F129C40,
	0x0F120000,
	
	
	0x00287000,
	0x002A0ADC,
	0x0F120AF0,
	0x002A0AE2,
	0x0F12222E,
	
	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	0x002A049A,
	0x0F1200FA, /* lt_uMinExp   0.5ms  */
	
	
	/* Set CIS/APS/Analog */
	0x0028D000,
	0x002AF106,
	0x0F120001,
	0x002AF206,
	0x0F120001,
	
	
	0x002AC202,
	0x0F120700,
	
	0x002AF260,
	0x0F120001,
	
	0x002AF414,
	0x0F120030,
	
	0x002AC204,
	0x0F120100,
	0x002AF402,
	0x0F120092,
	0x0F12007F,
	
	0x002AF700,
	0x0F120040,
	0x002AF708,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120040,
	0x0F120001,
	0x0F120015,
	0x0F120001,
	0x0F120040,
	
	0x002AF48A,
	0x0F120048,
	0x002AF10A,
	0x0F12008B,
	
	
	0x002AF900,
	0x0F120067,
	
	
	0x002AF406,
	0x0F120092,
	0x0F12007F,
	0x0F120003,
	
	0x0F120003,
	0x0F120003,
	0x002AF442,
	0x0F120000,
	0x0F120000,
	0x002AF448,
	0x0F120000,
	0x002AF456,
	0x0F120001,
	0x0F120010,
	0x0F120000,
	
	0x002AF41A,
	0x0F1200FF,
	0x0F120003,
	
	0x002AF420,
	0x0F120030,
	0x002AF410,
	0x0F120001,
	
	0x0F120000,
	0x002AF416,
	0x0F120001,
	0x002AF424,
	0x0F120000,
	0x002AF422,
	0x0F120000,
	
	0x002AF41E,
	0x0F120000,
	0x002AF428,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF430,
	0x0F120000,
	0x0F120000,
	
	0x0F120008,
	0x0F120005,
	0x0F12000F,
	0x0F120001,
	0x0F120040,
	0x0F120040,
	0x0F120010,
	
	0x002AF4D6,
	0x0F120090,
	
	
	0x0F120000,
	
	0x002AF47C,
	0x0F12000C,
	0x0F120000,
	0x002AF49A,
	0x0F120008,
	0x0F120000,
	0x002AF4A2,
	0x0F120008,
	0x0F120000,
	0x002AF4B2,
	0x0F120013,
	0x0F120000,
	0x0F120013,
	0x0F120000,
	0x002AF4AA,
	0x0F12009B,
	0x0F1200FB,
	0x0F12009B,
	0x0F1200FB,
	0x002AF474,
	0x0F120017,
	0x0F12005F,
	0x0F120017,
	0x0F12008F,
	
	0x002AF48C,
	0x0F120017,
	0x0F12009B,
	0x002AF4C8,
	0x0F120163,
	0x0F120193,
	0x002AF490,
	0x0F120191,
	
	0x002AF418,
	0x0F120083,
	
	0x002AF454,
	0x0F120001,
	
	0x002AF702,
	0x0F120081,
	0x002AF4D2,
	0x0F120000,
	
	/* For ESD Check */
	0x00287000,
	0x002A0132,
	0x0F12AAAA,
	
	/* Set FPN Gain Input */
	0x002A1176,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F120100,
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120004,
	
	/* CFPN Canceller */
	0x002A116C,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120002,
	0x002A0AE8,
	0x0F120000,
	
	/* sensor aig table setting */
	0x002A10EE,
	0x0F120000,
	0x002A10F2,
	0x0F120000,
	0x002A1152,
	0x0F120030,
	0x0F120028,
	0x0F120030,
	0x002A1148,
	0x0F1200FB,
	0x002A1144,
	0x0F1200FB,
	0x002A1150,
	0x0F1201F4,
	
	
	0x002A1084,
	0x0F120000,
	0x0F120000,
	
	/* Set AE Target */
	0x002A0F4C,
	0x0F12003C, /* -- */
	
	0x002A0478,
	0x0F120114,
	0x0F1200EB, /* ae boundary */
	
	
	
	/* Set Frame Rate */
	0x002A0484,
	0x0F12410A, /* uMaxExp1 */
	0x0F120000,
	0x002A048C,
	0x0F128214, /* uMaxExp2 */
	0x0F120000,
	0x0F12A122, /* uMaxExp3 */
	0x0F120000,
	0x002A0488,
	0x0F12f424, /* uMaxExp4 */
	0x0F120000,
	0x002A043A,
	0x0F120200,
	0x0F120200,
	0x002A0494,
	0x0F120300,
	0x0F120600,
	0x0f120100,
	0x002A0F52,
	0x0F12000F, /* ae_StatMode */
	
	0x002A0E98, /* bp_uMaxBrightnessFactor */
	0x0F1202A8,
	0x002A0E9E, /* bp_uMinBrightnessFactor */
	0x0F120298,
	
	/* 1. Auto Flicker 50Hz Start */
	0x002A0B2E,
	0x0F120000, /* AFC_Default60Hz	 Auto Flicker 60Hz start 0: Auto Flicker 50Hz start */
	0x002A03F8,
	0x0F12005F, /* REG_TC_DBG_AutoAlgEnBits   default : 007F */
	
	
	0xffff000a, /* p10	Wait10mSec */
	
	/* Set PLL */
	/* External CLOCK (MCLK) */
	0x002A01B8,
	0x0F125DC0, /* REG_TC_IPRM_InClockLSBs */
	0x0F120000, /* REG_TC_IPRM_InClockMSBs */
	
	/* Parallel or MIPI Selection */
	0x002A01C6,
	0x0F120001, /* REG_TC_IPRM_UseNPviClocks         */
	0x0F120001, /* REG_TC_IPRM_UseNMipiClocks        */
	0x0F120000, /* REG_TC_IPRM_bBlockInternalPllCalc */
	
	/* System Clock 0 (System : 24Mhz, PCLK : 48Mhz) */
	0x002A01CC,
	0x0F121770, /* REG_TC_IPRM_OpClk4KHz_0      */
	0x0F122EE0, /* REG_TC_IPRM_MinOutRate4KHz_0 */
	0x0F122EE0, /* REG_TC_IPRM_MaxOutRate4KHz_0 */
	
	/* System Clock 1 (System : 48Mhz, PCLK : 48Mhz) */
	0x002A01D2,                
	0x0F121B58,
	0x0F122EE0,
	0x0F122EE0,
	
	0x002A01DE,
	0x0F120001,
	0x0F120001,
	0xffff0064, /* 100ms Delay */
	
	/* Crop */
	0x002A01FA,
	0x0F120640,
	0x0F1204B0,
	0x0F120000,
	0x0F120000,
	
	/* Set Preview Config */
	/* Preview Config 0 (VGA fixed 30fps) */
	0x002A0242,
#if 0
	/*++ 640x480 */
	/* 0x0F120280, */ /* REG_0TC_PCFG_usWidth */
	/* 0x0F1201E0, */ /* REG_0TC_PCFG_usHeight */
	/*-- 640x480 */
#else
	/*++ 800x600 */
	0x0F120320, /* REG_0TC_PCFG_usWidth */
	0x0F120258, /* REG_0TC_PCFG_usHeight */
	/*-- 800x600 */
#endif
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052, /*-*/
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F120190, /*-535-*/
	0x0F120190, /*-29A-*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Preview Config 1 (640x480, Not Fixed 15 ~ 30fps) */
	0x002A0268,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F12029A,
	0x0F12014D,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Set MIPI */
	0x002A03AC,
	0x0F120000, /* REG_TC_FLS_Mode        */
	0x002A03F2,
	0x0F120001, /* REG_TC_OIF_EnMipiLanes */
	0x0F1200C3, /* REG_TC_OIF_EnPackets   */
	0x0F120001, /* REG_TC_OIF_CfgChanged  */
	
	/* Apply preview config */
	/* 0x002A021C, */
	/* 0x0F120000, */ /* REG_TC_GP_ActivePrevConfig */
	/* 0x002A0220, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevOpenAfterChange */
	/* 0x002A01F8, */
	/* 0x0F120001, */ /* REG_TC_GP_NewConfigSync */
	/* 0x002A021E, */
	/* 0x0F120001, */ /* REG_TC_GP_PrevConfigChanged */
	/* 0x002A01F0, */
	/* 0x0F120001, */ /* REG_TC_GP_EnablePreview */
	/* 0x0F120001, */ /* REG_TC_GP_EnablePreviewChanged */
	
	
	/* Set Capture Config */
	/* Capture Config 0 (1600x1200 fixed 8fps) */
	0x002A0302,
	0x0F120000,
	0x0F120640,
	0x0F1204B0,
	0x0F120005,
	0x0F122EE0,
	0x0F122EE0,
	0x0F120052,
	0x0F120001,
	0x0F120002,
	0x0F120002,
	0x0F120535,
	0x0F120535,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	/* Periodic mismatch */
	0x002A0780,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	0x002A0798,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	0x002A07C0,
	0x0F120004,
	0x0F120004,
	
	0x002A0B94,
	0x0F120580,
	0x0F120400,
	0x0F1205F0,
	0x002A04A0,
	0x0F128000,
	
	
	/* Set AE Weights */
	0x002A0F5A,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120302,
	0x0F120203,
	0x0F120101,
	0x0F120101,
	0x0F120403,
	0x0F120304,
	0x0F120101,
	0x0F120101,
	0x0F120403,
	0x0F120304,
	0x0F120101,
	0x0F120101,
	0x0F120302,
	0x0F120203,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	
	/* Set GAS & CCM White Point */
	/* param_start	TVAR_ash_AwbAshCord */
	0x002A0704,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F1201B0,
	0x0F120200,
	
	/* param_start	wbt_AwbCcmCord */
	0x002A06F2,
	0x0F1200B3,
	0x0F1200E5,
	0x0F120120,
	0x0F120136,
	0x0F120180,
	0x0F120190,
	
	/* Target Brightness Control */
	0x002A103E,
	0x0F120000,
	0x0F120009,
	0x0F120018,
	0x0F120032,
	0x0F12004A,
	0x0F120051,
	0x0F120056,
	0x0F12010C,
	0x0F12010C,
	0x0F120109,
	0x0F120105,
	0x0F120102,
	0x0F1200FB,
	0x0F1200F8,
	
	/* TVAR_ash_GASAlpha(Indoor) */
	0x002A0712,
	0x0F120100, /* TVAR_ash_GASAlpha[0]  */
	0x0F120100, /* TVAR_ash_GASAlpha[1]  */
	0x0F120100, /* TVAR_ash_GASAlpha[2]  */
	0x0F120100, /* TVAR_ash_GASAlpha[3]  */
	
	0x0F120100, /* TVAR_ash_GASAlpha[4]  */
	0x0F120100, /* TVAR_ash_GASAlpha[5]  */
	0x0F120100, /* TVAR_ash_GASAlpha[6]  */
	0x0F120100, /* TVAR_ash_GASAlpha[7]  */
	
	0x0F120100, /* TVAR_ash_GASAlpha[8]  */
	0x0F120100, /* TVAR_ash_GASAlpha[9]  */
	0x0F120100, /* TVAR_ash_GASAlpha[10] */
	0x0F120100, /* TVAR_ash_GASAlpha[11] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[12] */
	0x0F120100, /* TVAR_ash_GASAlpha[13] */
	0x0F120100, /* TVAR_ash_GASAlpha[14] */
	0x0F120100, /* TVAR_ash_GASAlpha[15] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[16] */
	0x0F120100, /* TVAR_ash_GASAlpha[17] */
	0x0F120100, /* TVAR_ash_GASAlpha[18] */
	0x0F120100, /* TVAR_ash_GASAlpha[19] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[20] */
	0x0F120100, /* TVAR_ash_GASAlpha[21] */
	0x0F120100, /* TVAR_ash_GASAlpha[22] */
	0x0F120100, /* TVAR_ash_GASAlpha[23] */
	
	0x0F120100, /* TVAR_ash_GASAlpha[24] */
	0x0F120100, /* TVAR_ash_GASAlpha[25] */
	0x0F120100, /* TVAR_ash_GASAlpha[26] */
	0x0F120100, /* TVAR_ash_GASAlpha[27] */
	
	/* TVAR_ash_GASAlpha(Outdoor) */
	0x0F120100, /* 100 TVAR_ash_GASOutdoorAlpha_0_ */
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_1_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_2_*/
	0x0F120100, /* TVAR_ash_GASOutdoorAlpha_3_*/
	
	/* GAS LUT Start Address */
	0x002A0754,
	0x0F122388,
	0x0F127000,
	
	/* param_start	TVAR_ash_pGAS */
	0x002A2388,
	0x0F120160,
	0x0F120134,
	0x0F1200FF,
	0x0F1200D1,
	0x0F1200B1,
	0x0F12009D,
	0x0F120096,
	0x0F12009E,
	0x0F1200B3,
	0x0F1200D3,
	0x0F1200FF,
	0x0F120131,
	0x0F120159,
	0x0F12013C,
	0x0F120107,
	0x0F1200CD,
	0x0F1200A1,
	0x0F120080,
	0x0F12006B,
	0x0F120064,
	0x0F12006C,
	0x0F120080,
	0x0F1200A1,
	0x0F1200CD,
	0x0F120106,
	0x0F120139,
	0x0F120116,
	0x0F1200DC,
	0x0F1200A2,
	0x0F120073,
	0x0F120051,
	0x0F12003B,
	0x0F120033,
	0x0F12003B,
	0x0F120050,
	0x0F120073,
	0x0F1200A2,
	0x0F1200DD,
	0x0F120115,
	0x0F1200FA,
	0x0F1200BF,
	0x0F120085,
	0x0F120055,
	0x0F120031,
	0x0F12001B,
	0x0F120014,
	0x0F12001A,
	0x0F120031,
	0x0F120055,
	0x0F120085,
	0x0F1200C0,
	0x0F1200FB,
	0x0F1200EA,
	0x0F1200AF,
	0x0F120074,
	0x0F120045,
	0x0F120020,
	0x0F12000B,
	0x0F120003,
	0x0F12000A,
	0x0F120020,
	0x0F120046,
	0x0F120076,
	0x0F1200B1,
	0x0F1200ED,
	0x0F1200E6,
	0x0F1200AA,
	0x0F120071,
	0x0F120041,
	0x0F12001D,
	0x0F120008,
	0x0F120000,
	0x0F120007,
	0x0F12001E,
	0x0F120044,
	0x0F120074,
	0x0F1200B0,
	0x0F1200EC,
	0x0F1200EF,
	0x0F1200B3,
	0x0F12007A,
	0x0F12004A,
	0x0F120026,
	0x0F120011,
	0x0F12000A,
	0x0F120011,
	0x0F120029,
	0x0F12004F,
	0x0F120080,
	0x0F1200BC,
	0x0F1200F8,
	0x0F120105,
	0x0F1200C9,
	0x0F12008F,
	0x0F120060,
	0x0F12003C,
	0x0F120026,
	0x0F12001F,
	0x0F120028,
	0x0F120040,
	0x0F120066,
	0x0F120097,
	0x0F1200D4,
	0x0F120110,
	0x0F120124,
	0x0F1200EB,
	0x0F1200B1,
	0x0F120082,
	0x0F12005F,
	0x0F12004A,
	0x0F120043,
	0x0F12004C,
	0x0F120064,
	0x0F120089,
	0x0F1200BA,
	0x0F1200F8,
	0x0F12012F,
	0x0F120147,
	0x0F120116,
	0x0F1200DE,
	0x0F1200AF,
	0x0F12008E,
	0x0F12007A,
	0x0F120072,
	0x0F12007A,
	0x0F120091,
	0x0F1200B6,
	0x0F1200E8,
	0x0F120121,
	0x0F120150,
	0x0F120170,
	0x0F12013F,
	0x0F120110,
	0x0F1200E2,
	0x0F1200C0,
	0x0F1200AB,
	0x0F1200A4,
	0x0F1200AC,
	0x0F1200C3,
	0x0F1200E6,
	0x0F120117,
	0x0F120145,
	0x0F120172,
	0x0F120127,
	0x0F120100,
	0x0F1200CF,
	0x0F1200A7,
	0x0F12008D,
	0x0F12007D,
	0x0F120077,
	0x0F12007A,
	0x0F120087,
	0x0F12009E,
	0x0F1200C0,
	0x0F1200EC,
	0x0F12010F,
	0x0F120108,
	0x0F1200D8,
	0x0F1200A5,
	0x0F120080,
	0x0F120066,
	0x0F120056,
	0x0F12004F,
	0x0F120053,
	0x0F120061,
	0x0F120077,
	0x0F120098,
	0x0F1200C6,
	0x0F1200F3,
	0x0F1200E7,
	0x0F1200B4,
	0x0F120081,
	0x0F12005C,
	0x0F120041,
	0x0F120030,
	0x0F120029,
	0x0F12002E,
	0x0F12003D,
	0x0F120055,
	0x0F120076,
	0x0F1200A5,
	0x0F1200D4,
	0x0F1200CF,
	0x0F12009B,
	0x0F12006A,
	0x0F120043,
	0x0F120027,
	0x0F120016,
	0x0F12000F,
	0x0F120015,
	0x0F120025,
	0x0F12003E,
	0x0F120061,
	0x0F12008E,
	0x0F1200BF,
	0x0F1200C2,
	0x0F12008E,
	0x0F12005D,
	0x0F120037,
	0x0F12001A,
	0x0F120009,
	0x0F120002,
	0x0F120007,
	0x0F120018,
	0x0F120033,
	0x0F120057,
	0x0F120083,
	0x0F1200B3,
	0x0F1200BE,
	0x0F12008A,
	0x0F12005A,
	0x0F120034,
	0x0F120017,
	0x0F120006,
	0x0F120000,
	0x0F120006,
	0x0F120017,
	0x0F120033,
	0x0F120057,
	0x0F120083,
	0x0F1200B3,
	0x0F1200C5,
	0x0F120091,
	0x0F120061,
	0x0F12003B,
	0x0F120020,
	0x0F12000F,
	0x0F120009,
	0x0F120010,
	0x0F120021,
	0x0F12003D,
	0x0F120060,
	0x0F12008D,
	0x0F1200BE,
	0x0F1200D7,
	0x0F1200A2,
	0x0F120072,
	0x0F12004D,
	0x0F120032,
	0x0F120022,
	0x0F12001D,
	0x0F120024,
	0x0F120035,
	0x0F120050,
	0x0F120073,
	0x0F1200A0,
	0x0F1200D2,
	0x0F1200F0,
	0x0F1200BE,
	0x0F12008C,
	0x0F120068,
	0x0F12004F,
	0x0F120040,
	0x0F12003B,
	0x0F120041,
	0x0F120052,
	0x0F12006C,
	0x0F12008E,
	0x0F1200BE,
	0x0F1200ED,
	0x0F12010C,
	0x0F1200E1,
	0x0F1200AF,
	0x0F12008A,
	0x0F120072,
	0x0F120064,
	0x0F12005F,
	0x0F120065,
	0x0F120074,
	0x0F12008D,
	0x0F1200B2,
	0x0F1200E0,
	0x0F12010A,
	0x0F12012F,
	0x0F120104,
	0x0F1200D9,
	0x0F1200B3,
	0x0F120099,
	0x0F12008B,
	0x0F120086,
	0x0F12008B,
	0x0F12009B,
	0x0F1200B5,
	0x0F1200DA,
	0x0F120101,
	0x0F120128,
	0x0F12012F,
	0x0F120106,
	0x0F1200D4,
	0x0F1200AA,
	0x0F12008E,
	0x0F12007D,
	0x0F120079,
	0x0F120080,
	0x0F120093,
	0x0F1200B1,
	0x0F1200DC,
	0x0F12010C,
	0x0F120130,
	0x0F120112,
	0x0F1200E0,
	0x0F1200AB,
	0x0F120083,
	0x0F120067,
	0x0F120057,
	0x0F120051,
	0x0F120059,
	0x0F12006B,
	0x0F120089,
	0x0F1200B2,
	0x0F1200E5,
	0x0F120114,
	0x0F1200F2,
	0x0F1200BD,
	0x0F120088,
	0x0F120061,
	0x0F120044,
	0x0F120031,
	0x0F12002C,
	0x0F120033,
	0x0F120047,
	0x0F120065,
	0x0F12008C,
	0x0F1200C0,
	0x0F1200F3,
	0x0F1200DB,
	0x0F1200A5,
	0x0F120071,
	0x0F120049,
	0x0F12002A,
	0x0F120018,
	0x0F120011,
	0x0F120018,
	0x0F12002C,
	0x0F12004B,
	0x0F120072,
	0x0F1200A3,
	0x0F1200D7,
	0x0F1200CD,
	0x0F120097,
	0x0F120065,
	0x0F12003C,
	0x0F12001D,
	0x0F12000A,
	0x0F120003,
	0x0F120009,
	0x0F12001D,
	0x0F12003B,
	0x0F120063,
	0x0F120092,
	0x0F1200C4,
	0x0F1200CA,
	0x0F120094,
	0x0F120062,
	0x0F12003A,
	0x0F12001A,
	0x0F120007,
	0x0F120000,
	0x0F120006,
	0x0F120018,
	0x0F120036,
	0x0F12005C,
	0x0F12008A,
	0x0F1200BC,
	0x0F1200D1,
	0x0F12009B,
	0x0F120069,
	0x0F120042,
	0x0F120022,
	0x0F12000F,
	0x0F120008,
	0x0F12000D,
	0x0F12001F,
	0x0F12003B,
	0x0F120060,
	0x0F12008D,
	0x0F1200BF,
	0x0F1200E3,
	0x0F1200AC,
	0x0F12007A,
	0x0F120053,
	0x0F120035,
	0x0F120022,
	0x0F12001B,
	0x0F12001F,
	0x0F120030,
	0x0F12004B,
	0x0F12006D,
	0x0F12009C,
	0x0F1200CE,
	0x0F1200FE,
	0x0F1200C9,
	0x0F120095,
	0x0F12006F,
	0x0F120052,
	0x0F120040,
	0x0F120039,
	0x0F12003D,
	0x0F12004B,
	0x0F120063,
	0x0F120086,
	0x0F1200B5,
	0x0F1200E6,
	0x0F12011B,
	0x0F1200ED,
	0x0F1200BA,
	0x0F120092,
	0x0F120076,
	0x0F120065,
	0x0F12005D,
	0x0F120060,
	0x0F12006D,
	0x0F120084,
	0x0F1200A8,
	0x0F1200D6,
	0x0F120101,
	0x0F120140,
	0x0F120112,
	0x0F1200E5,
	0x0F1200BD,
	0x0F12009E,
	0x0F12008C,
	0x0F120085,
	0x0F120087,
	0x0F120094,
	0x0F1200AC,
	0x0F1200D0,
	0x0F1200F8,
	0x0F120123,
	0x0F1200F2,
	0x0F1200D1,
	0x0F1200A7,
	0x0F120087,
	0x0F120073,
	0x0F120067,
	0x0F120064,
	0x0F12006B,
	0x0F12007C,
	0x0F120094,
	0x0F1200B7,
	0x0F1200E1,
	0x0F1200FF,
	0x0F1200D6,
	0x0F1200AE,
	0x0F120085,
	0x0F120068,
	0x0F120054,
	0x0F120048,
	0x0F120045,
	0x0F12004B,
	0x0F12005B,
	0x0F120073,
	0x0F120093,
	0x0F1200BF,
	0x0F1200E9,
	0x0F1200B8,
	0x0F12008E,
	0x0F120066,
	0x0F120049,
	0x0F120035,
	0x0F120028,
	0x0F120025,
	0x0F12002B,
	0x0F12003B,
	0x0F120053,
	0x0F120072,
	0x0F12009D,
	0x0F1200C8,
	0x0F1200A2,
	0x0F120078,
	0x0F120051,
	0x0F120034,
	0x0F12001F,
	0x0F120012,
	0x0F12000E,
	0x0F120014,
	0x0F120024,
	0x0F12003B,
	0x0F12005B,
	0x0F120083,
	0x0F1200AD,
	0x0F120095,
	0x0F12006C,
	0x0F120046,
	0x0F12002A,
	0x0F120014,
	0x0F120007,
	0x0F120002,
	0x0F120008,
	0x0F120016,
	0x0F12002D,
	0x0F12004C,
	0x0F120072,
	0x0F12009B,
	0x0F120093,
	0x0F12006A,
	0x0F120045,
	0x0F120028,
	0x0F120013,
	0x0F120005,
	0x0F120000,
	0x0F120004,
	0x0F120012,
	0x0F120028,
	0x0F120045,
	0x0F12006A,
	0x0F120093,
	0x0F12009B,
	0x0F120071,
	0x0F12004C,
	0x0F120030,
	0x0F12001A,
	0x0F12000C,
	0x0F120007,
	0x0F12000B,
	0x0F120018,
	0x0F12002C,
	0x0F120048,
	0x0F12006D,
	0x0F120097,
	0x0F1200AE,
	0x0F120083,
	0x0F12005C,
	0x0F120040,
	0x0F12002B,
	0x0F12001E,
	0x0F120018,
	0x0F12001C,
	0x0F120027,
	0x0F12003A,
	0x0F120055,
	0x0F12007B,
	0x0F1200A6,
	0x0F1200CA,
	0x0F12009E,
	0x0F120076,
	0x0F120059,
	0x0F120046,
	0x0F120039,
	0x0F120033,
	0x0F120036,
	0x0F120040,
	0x0F120052,
	0x0F12006C,
	0x0F120094,
	0x0F1200BF,
	0x0F1200EB,
	0x0F1200C3,
	0x0F120099,
	0x0F12007A,
	0x0F120066,
	0x0F12005A,
	0x0F120054,
	0x0F120056,
	0x0F12005F,
	0x0F120071,
	0x0F12008D,
	0x0F1200B6,
	0x0F1200DE,
	0x0F12010D,
	0x0F1200E7,
	0x0F1200C1,
	0x0F1200A0,
	0x0F12008A,
	0x0F12007C,
	0x0F120076,
	0x0F120078,
	0x0F120081,
	0x0F120093,
	0x0F1200B1,
	0x0F1200D5,
	0x0F1200FD,
	
	/* Gamma */
	0x002A04CC,
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	0x0F120000, /*0000*/
	0x0F120002, /*0002*/
	0x0F120005, /*0008*/
	0x0F12000A, /*001A*/
	0x0F120072, /*0066*/
	0x0F120106, /*00E6*/
	0x0F120150, /*0141*/
	0x0F12018E, /*0188*/
	0x0F1201F4, /*01E6*/
	0x0F120240, /*0236*/
	0x0F1202C4, /*02BA*/
	0x0F120332, /*032A*/
	0x0F120385, /*0385*/
	0x0F1203C2, /*03C2*/
	0x0F1203EA, /*03EA*/
	0x0F1203FF, /*03FF*/
	
	/* Set AWB */
	0x002A0DA6,
	0x0F120000, /* awbb_LowBr_NBzone	       */
	0x0F120000, /* awbb_LowBr0_NBzone       */
	0x002A0E8C,
	0x0F120000, /* awbb_LowBr0_PatchNumZone */
	0x002A0D6C,
	0x0F120040, /* awbb_YMedMoveToYAv       */
	
	/* Indoor Gray Zone */
	0x002A0B9C,
	0x0F1203B4, /*038F awbb_IndoorGrZones_m_BGrid_0__m_left   */
	0x0F1203C0, /*039B awbb_IndoorGrZones_m_BGrid_0__m_right  */
	0x0F12037C, /*0373 awbb_IndoorGrZones_m_BGrid_1__m_left   */
	0x0F1203C8, /*03B0 awbb_IndoorGrZones_m_BGrid_1__m_right  */
	0x0F12035E, /*0352 awbb_IndoorGrZones_m_BGrid_2__m_left   */
	0x0F1203C8, /*03B7 awbb_IndoorGrZones_m_BGrid_2__m_right  */
	0x0F120340, /*0334 awbb_IndoorGrZones_m_BGrid_3__m_left   */
	0x0F1203C0, /*03B5 awbb_IndoorGrZones_m_BGrid_3__m_right  */
	0x0F120328, /*0318 awbb_IndoorGrZones_m_BGrid_4__m_left   */
	0x0F1203B0, /*03B0 awbb_IndoorGrZones_m_BGrid_4__m_right  */
	0x0F120310, /*02FF awbb_IndoorGrZones_m_BGrid_5__m_left   */
	0x0F12039E, /*038D awbb_IndoorGrZones_m_BGrid_5__m_right  */
	0x0F1202FA, /*02E7 awbb_IndoorGrZones_m_BGrid_6__m_left   */
	0x0F120384, /*0372 awbb_IndoorGrZones_m_BGrid_6__m_right  */
	0x0F1202DC, /*02D0 awbb_IndoorGrZones_m_BGrid_7__m_left   */
	0x0F12036C, /*035D awbb_IndoorGrZones_m_BGrid_7__m_right  */
	0x0F1202CA, /*02B5 awbb_IndoorGrZones_m_BGrid_8__m_left   */
	0x0F12035A, /*0345 awbb_IndoorGrZones_m_BGrid_8__m_right  */
	0x0F1202B4, /*02A1 awbb_IndoorGrZones_m_BGrid_9__m_left   */
	0x0F120340, /*0331 awbb_IndoorGrZones_m_BGrid_9__m_right  */
	0x0F12029E, /*028B awbb_IndoorGrZones_m_BGrid_10__m_left  */
	0x0F120324, /*031E awbb_IndoorGrZones_m_BGrid_10__m_right */
	0x0F12028C, /*0273 awbb_IndoorGrZones_m_BGrid_11__m_left  */
	0x0F120306, /*0309 awbb_IndoorGrZones_m_BGrid_11__m_right */
	0x0F12027A, /*025F awbb_IndoorGrZones_m_BGrid_12__m_left  */
	0x0F1202F6, /*02F5 awbb_IndoorGrZones_m_BGrid_12__m_right */
	0x0F12026A, /*0250 awbb_IndoorGrZones_m_BGrid_13__m_left  */
	0x0F1202E4, /*02DB awbb_IndoorGrZones_m_BGrid_13__m_right */
	0x0F12025A, /*0241 awbb_IndoorGrZones_m_BGrid_14__m_left  */
	0x0F1202DA, /*02C7 awbb_IndoorGrZones_m_BGrid_14__m_right */
	0x0F12024C, /*0233 awbb_IndoorGrZones_m_BGrid_15__m_left  */
	0x0F1202CE, /*02B9 awbb_IndoorGrZones_m_BGrid_15__m_right */
	0x0F12023A, /*0223 awbb_IndoorGrZones_m_BGrid_16__m_left  */
	0x0F1202C4, /*02AB awbb_IndoorGrZones_m_BGrid_16__m_right */
	0x0F120230, /*0217 awbb_IndoorGrZones_m_BGrid_17__m_left  */
	0x0F1202B8, /*02A2 awbb_IndoorGrZones_m_BGrid_17__m_right */
	0x0F120220, /*0207 awbb_IndoorGrZones_m_BGrid_18__m_left  */
	0x0F1202AC, /*0294 awbb_IndoorGrZones_m_BGrid_18__m_right */
	0x0F120212, /*01FA awbb_IndoorGrZones_m_BGrid_19__m_left  */
	0x0F1202AA, /*0289 awbb_IndoorGrZones_m_BGrid_19__m_right */
	0x0F120204, /*01EA awbb_IndoorGrZones_m_BGrid_20__m_left  */
	0x0F1202A6, /*0281 awbb_IndoorGrZones_m_BGrid_20__m_right */
	0x0F1201FA, /*01DD awbb_IndoorGrZones_m_BGrid_21__m_left  */
	0x0F1202A0, /*027B awbb_IndoorGrZones_m_BGrid_21__m_right */
	0x0F1201EE, /*01D0 awbb_IndoorGrZones_m_BGrid_22__m_left  */
	0x0F12029C, /*0273 awbb_IndoorGrZones_m_BGrid_22__m_right */
	0x0F1201E0, /*01C3 awbb_IndoorGrZones_m_BGrid_23__m_left  */
	0x0F120294, /*026A awbb_IndoorGrZones_m_BGrid_23__m_right */
	0x0F1201D4, /*01B6 awbb_IndoorGrZones_m_BGrid_24__m_left  */
	0x0F12028A, /*0265 awbb_IndoorGrZones_m_BGrid_24__m_right */
	0x0F1201C8, /*01AB awbb_IndoorGrZones_m_BGrid_25__m_left  */
	0x0F120282, /*025B awbb_IndoorGrZones_m_BGrid_25__m_right */
	0x0F1201C0, /*01A1 awbb_IndoorGrZones_m_BGrid_26__m_left  */
	0x0F12027A, /*0254 awbb_IndoorGrZones_m_BGrid_26__m_right */
	0x0F1201BC, /*0198 awbb_IndoorGrZones_m_BGrid_27__m_left  */
	0x0F120272, /*024B awbb_IndoorGrZones_m_BGrid_27__m_right */
	0x0F1201B8, /*0192 awbb_IndoorGrZones_m_BGrid_28__m_left  */
	0x0F120262, /*0242 awbb_IndoorGrZones_m_BGrid_28__m_right */
	0x0F1201BC, /*0191 awbb_IndoorGrZones_m_BGrid_29__m_left  */
	0x0F12024E, /*023A awbb_IndoorGrZones_m_BGrid_29__m_right */
	0x0F1201EC, /*0192 awbb_IndoorGrZones_m_BGrid_30__m_left  */
	0x0F120206, /*0222 awbb_IndoorGrZones_m_BGrid_30__m_right */
	0x0F120000, /*01C5 awbb_IndoorGrZones_m_BGrid_31__m_left  */
	0x0F120000, /*01DF awbb_IndoorGrZones_m_BGrid_31__m_right */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_left  */
	0x0F120000, /*0000 awbb_IndoorGrZones_m_BGrid_32__m_right */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_left  */
	0x0F120000, /* awbb_IndoorGrZones_m_BGrid_33__m_right */
	
	
	/* param_end	awbb_IndoorGrZones_m_BGrid */
	0x002A0C3C,
	0x0F120004,
	0x0F120000,
	0x0F12001F,
	0x0F120000,
	0x0F12010E,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0C50,
	0x0F1200E0,
	0x0F120000,
	
	/* Outdoor Gray Zone */
	0x0F12025E, /*025E*/
	0x0F120282, /*0282*/
	0x0F120246, /*0240*/
	0x0F12029E, /*0298*/
	0x0F120230, /*022A*/
	0x0F1202A0, /*029A*/
	0x0F120220, /*021A*/
	0x0F1202A0, /*029A*/
	0x0F12020E, /*0206*/
	0x0F12029E, /*0298*/
	0x0F120206, /*01FE*/
	0x0F120292, /*028C*/
	0x0F120200, /*01FA*/
	0x0F12027E, /*0278*/
	0x0F1201FE, /*01F8*/
	0x0F12026A, /*0266*/
	0x0F12021A, /*0214*/
	0x0F12023E, /*0238*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	
	
	/* param_WRITE 70000CC6  B2end	awbb_OutdoorGrZones_m_BGrid */
	0x002A0CB8,
	0x0F120004,
	0x0F120000,
	0x0F120009,
	0x0F120000,
	0x0F120208,
	0x0F120000,
	0x0F120020,
	0x0F120000,
	0x002A0CCC,
	0x0F1200C0,
	0x0F120000,
	
	/* Low Brightness Gray Zone */
	0x0F12031F, /* awbb_LowBrGrZones_m_BGrid_0__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_0__m_right  */
	0x0F1202FC, /* awbb_LowBrGrZones_m_BGrid_1__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_1__m_right  */
	0x0F1202D9, /* awbb_LowBrGrZones_m_BGrid_2__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_2__m_right  */
	0x0F1202B6, /* awbb_LowBrGrZones_m_BGrid_3__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_3__m_right  */
	0x0F120293, /* awbb_LowBrGrZones_m_BGrid_4__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_4__m_right  */
	0x0F120270, /* awbb_LowBrGrZones_m_BGrid_5__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_5__m_right  */
	0x0F12024E, /* awbb_LowBrGrZones_m_BGrid_6__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_6__m_right  */
	0x0F12022B, /* awbb_LowBrGrZones_m_BGrid_7__m_left   */
	0x0F120495, /* awbb_LowBrGrZones_m_BGrid_7__m_right  */
	0x0F120208, /* awbb_LowBrGrZones_m_BGrid_8__m_left   */
	0x0F12048A, /* awbb_LowBrGrZones_m_BGrid_8__m_right  */
	0x0F1201E5, /* awbb_LowBrGrZones_m_BGrid_9__m_left   */
	0x0F120455, /* awbb_LowBrGrZones_m_BGrid_9__m_right  */
	0x0F1201C2, /* awbb_LowBrGrZones_m_BGrid_10__m_left  */
	0x0F12041F, /* awbb_LowBrGrZones_m_BGrid_10__m_right */
	0x0F12019F, /* awbb_LowBrGrZones_m_BGrid_11__m_left  */
	0x0F1203EA, /* awbb_LowBrGrZones_m_BGrid_11__m_right */
	0x0F12017D, /* awbb_LowBrGrZones_m_BGrid_12__m_left  */
	0x0F1203B4, /* awbb_LowBrGrZones_m_BGrid_12__m_right */
	0x0F12015A, /* awbb_LowBrGrZones_m_BGrid_13__m_left  */
	0x0F12037F, /* awbb_LowBrGrZones_m_BGrid_13__m_right */
	0x0F120137, /* awbb_LowBrGrZones_m_BGrid_14__m_left  */
	0x0F120349, /* awbb_LowBrGrZones_m_BGrid_14__m_right */
	0x0F120130, /* awbb_LowBrGrZones_m_BGrid_15__m_left  */
	0x0F120314, /* awbb_LowBrGrZones_m_BGrid_15__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_16__m_left  */
	0x0F1202DE, /* awbb_LowBrGrZones_m_BGrid_16__m_right */
	0x0F12012F, /* awbb_LowBrGrZones_m_BGrid_17__m_left  */
	0x0F1202B1, /* awbb_LowBrGrZones_m_BGrid_17__m_right */
	0x0F12012E, /* awbb_LowBrGrZones_m_BGrid_18__m_left  */
	0x0F12028B, /* awbb_LowBrGrZones_m_BGrid_18__m_right */
	0x0F12012D, /* awbb_LowBrGrZones_m_BGrid_19__m_left  */
	0x0F120265, /* awbb_LowBrGrZones_m_BGrid_19__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_20__m_left  */
	0x0F12023F, /* awbb_LowBrGrZones_m_BGrid_20__m_right */
	0x0F12012C, /* awbb_LowBrGrZones_m_BGrid_21__m_left  */
	0x0F120219, /* awbb_LowBrGrZones_m_BGrid_21__m_right */
	0x0F12012B, /* awbb_LowBrGrZones_m_BGrid_22__m_left  */
	0x0F1201F3, /* awbb_LowBrGrZones_m_BGrid_22__m_right */
	0x0F12012A, /* awbb_LowBrGrZones_m_BGrid_23__m_left  */
	0x0F1201CD, /* awbb_LowBrGrZones_m_BGrid_23__m_right */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_left  */
	0x0F120000, /* awbb_LowBrGrZones_m_BGrid_24__m_right */
	
	
	/* 42param_end awbb_LowBrGrZones_m_BGrid */
	0x0F120005,
	0x0F120000,
	0x0F120018,
	0x0F120000,
	0x0F1200AF,
	0x0F120000,
	0x0F120002,
	0x0F120000,
	0x002A0D48,
	0x0F1200E0,
	0x0F120000,
	
	/* Lowtemp circle */
	0x0F12032F,
	0x0F120000,
	0x0F12017A,
	0x0F120000,
	0x0F127300,
	0x0F120000,
	0x0F12000A,
	0x0F120000,
	0x002A0D60,
	0x0F1200E0,
	0x0F120000,
	0x002A0D82,
	0x0F120001,
	
	
	/* Duks add*/
	0x002A0D8E,
	0x0F120002, /* awbb_GridEnable */
	
	/* Grid coefficients and Contrants */
	0x002A0DCE,
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_0__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_0__2_       */
	0x0F120050, /*0050 awbb_GridCorr_R_0__3_       */
	0x0F120000, /*FFF0 awbb_GridCorr_R_0__4_       */
	0x0F12005A, /*005A awbb_GridCorr_R_0__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_1__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_1__2_       */
	0x0F120050, /*0050 awbb_GridCorr_R_1__3_       */
	0x0F120000, /*FFF0 awbb_GridCorr_R_1__4_       */
	0x0F12005A, /*005A awbb_GridCorr_R_1__5_       */
	0x0F12FFEC, /*FFEC awbb_GridCorr_R_2__0_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__1_       */
	0x0F12FFE2, /*FFE2 awbb_GridCorr_R_2__2_       */
	0x0F120050, /*0050 awbb_GridCorr_R_2__3_       */
	0x0F120000, /*FFF0 awbb_GridCorr_R_2__4_       */
	0x0F12005A, /*005A awbb_GridCorr_R_2__5_       */
	
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_0__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_0__1_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_0__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_0__3_     */
	0x0F12FF88, /*FFAC awbb_GridCorr_B_0__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_0__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_1__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_1__1_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_1__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_1__3_     */
	0x0F12FF88, /*FFAC awbb_GridCorr_B_1__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_1__5_     */
	0x0F12FFB5, /*FFB5 awbb_GridCorr_B_2__0_     */
	0x0F12FFC9, /*FFC9 awbb_GridCorr_B_2__1_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_2__2_     */
	0x0F12FFD8, /*FFD8 awbb_GridCorr_B_2__3_     */
	0x0F12FF88, /*FFAC awbb_GridCorr_B_2__4_     */
	0x0F12FEA0, /*FEA0 awbb_GridCorr_B_2__5_     */
	
	0x0F1202EA, /*awbb_GridConst_1_0_    */
	0x0F120335, /*awbb_GridConst_1_1_    */
	0x0F120388, /*awbb_GridConst_1_2_    */
	
	0x0F121032, /*1032 awbb_GridConst_2_0    */
	0x0F1210B2, /*10B2 awbb_GridConst_2_1    */
	0x0F121140, /*1124 awbb_GridConst_2_2    */
	0x0F121141, /*112A awbb_GridConst_2_3    */
	0x0F1211BE, /*11A4 awbb_GridConst_2_4    */
	0x0F12124C, /*1272 awbb_GridConst_2_5    */
	
	0x0F1200B3, /*awbb_GridCoeff_R_1    */
	0x0F1200B7, /*awbb_GridCoeff_B_1    */
	0x0F1200D3, /*awbb_GridCoeff_R_2    */
	0x0F120091, /*awbb_GridCoeff_B_2    */
	
	/* White Locus */
	0x002A0D66,
	0x0F120133,
	0x0F12010F,
	0x002A0D74,
	0x0F12052A,  /*--- 52A awbb_MvEq_RBthresh */
	
	/* Gamut Thresholds */
	0x002A0DAA,
	0x0F120664, /*--- 71A */
	0x0F120355, /*--- 3A4 */
	0x002A0DAE,
	0x0F12002C, /*--- 36 */
	0x0F120024, /*--- 1C */
	
	/* SceneDetection Thresholds */
	0x002A0D92,
	0x0F120E01,
	0x0F120096,
	0x002A0E86,
	0x0F120256, /*-- 256 */
	0x0F120248, /*-- 248 */
	0x002A0D96,
	0x0F120E00,
	0x0F120096,
	0x002A0DB2,
	0x0F1200DA,
	0x002A0D9A,
	0x0F12000A,
	0x002A0DB4,
	0x0F12041B, /* 459 awbb_LowTempRB */
	0x002A0DA4,
	0x0F12000E,
	0x002A0D64,
	0x0F120032,
	0x002A0DA6,
	0x0F12001E,
	0x002A0D9C,
	0x0F12001B,
	0x0F12000E,
	0x0F120008,
	0x0F120004,
	
	/* AWB Debug.(Outdoor Pink) */
	0x002A0E30,
	0x0F120000,
	0x002A0E84,
	0x0F120000,
	
	/* UseInvalidOutdoor option */
	0x002A0D88,
	0x0F120001,
	
	/* AWB input Y-Filter setting */
	0x002A0C48,
	0x0F120020,
	0x002A0C50,
	0x0F1200E0,
	0x002A0CC4,
	0x0F120020,
	0x002A0CCC,
	0x0F1200C0,
	
	/* awbb_ChromaClassifyEn, default : enable*/
	0x002A0DC2,
	0x0F120030,
	0x0F1200C8,
	0x0F12012C,
	0x0F120258,
	0x0F120003,
	
	
	/* Set CCM */
	/* CCM Start Address */
	0x002A06D0,
	0x0F122800,
	0x0F127000,
	0x0F122824,
	0x0F127000,
	0x0F122848,
	0x0F127000,
	0x0F12286C,
	0x0F127000,
	0x0F122890,
	0x0F127000,
	0x0F1228B4,
	0x0F127000,
	0x002A06EC,
	0x0F1228D8,
	0x0F127000,
	
	/* CCM */
	0x002A2800,
	0x0F12010D, /*-0136---*/  /* H */
	0x0F12FFA7, /*-FF8B---*/
	0x0F12FFF5, /*-FFE8---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/
	
	0x0F12010D, /*-010D---*/  /* A */
	0x0F12FFA7, /*-FFA7---*/
	0x0F12FFF5, /*-FFF5---*/
	0x0F12003B, /*-0037---*/
	0x0F1200EF, /*-00CD---*/
	0x0F12FF38, /*-FF5E---*/
	0x0F12FE42, /*-FE42---*/
	0x0F120270, /*-0270---*/
	0x0F12FF71, /*-FF71---*/
	0x0F12FEED, /*-FEED---*/
	0x0F120198, /*-0198---*/
	0x0F120198, /*-0198---*/
	0x0F12FF95, /*-FF95---*/
	0x0F12FFA3, /*-FFA3---*/
	0x0F120260, /*-0260---*/
	0x0F1200EC, /*-00EC---*/
	0x0F12FF33, /*-FF33---*/
	0x0F1200F4, /*-00F4---*/
	
	0x0F120205, /*01A5   01A5*/  /* WW */
	0x0F12FF92, /*FF9D   FF9D*/
	0x0F12FFE6, /*FFE1   FFE1*/
	0x0F1200FE, /*00F2   00D9*/
	0x0F1200E2, /*0116   0153*/
	0x0F12FF33, /*FF48   FF25*/
	0x0F12FF1E, /*FF3A   FF25*/
	0x0F120222, /*0263   028C*/
	0x0F12FF68, /*FF3A   FF25*/
	0x0F12FF03, /*FEBF   FEBF*/
	0x0F120207, /*01B6   01B6*/
	0x0F120113, /*00F7   00F7*/
	0x0F12FFE3, /*FF81   FF81*/
	0x0F12FFC0, /*FF8C   FF8C*/
	0x0F120181, /*01AE   01AE*/
	0x0F120164, /*00FC   00FC*/
	0x0F12FF55, /*FF48   FF48*/
	0x0F120163, /*010D   010D*/
	
	0x0F120205, /*01BD  01BD*/  /* CW */
	0x0F12FF92, /*FF89  FF89*/
	0x0F12FFE6, /*FFDE  FFDE*/
	0x0F1200FE, /*00C9  0098*/
	0x0F1200E2, /*00B1  00B8*/
	0x0F12FF33, /*FF3F  FF69*/
	0x0F12FF1E, /*FF2D  FF15*/
	0x0F120222, /*0230  025A*/
	0x0F12FF68, /*FF77  FF65*/
	0x0F12FF03, /*FF03  FF03*/
	0x0F120207, /*0207  0207*/
	0x0F120113, /*0113  0113*/
	0x0F12FFE3, /*FFDA  FFDA*/
	0x0F12FFC0, /*FFB8  FFB8*/
	0x0F120181, /*0166  0166*/
	0x0F120164, /*0164  0164*/
	0x0F12FF55, /*FF55  FF55*/
	0x0F120163, /*0163  0163*/
	
	0x0F12018A, /*-0171---*/  /* D50 */
	0x0F12FFC1, /*-FFAF---*/
	0x0F12FFF5, /*-FFF3---*/
	0x0F120086, /*-0086---*/
	0x0F1200D2, /*-00D2---*/
	0x0F12FF73, /*-FF73---*/
	0x0F12FF0B, /*-FF17---*/
	0x0F120232, /*-022B---*/
	0x0F12FF49, /*-FF54---*/
	0x0F12FF43, /*-FF43---*/
	0x0F1201BA, /*-01BA---*/
	0x0F1200F3, /*-00F3---*/
	0x0F12FFE2, /*-FFF6---*/
	0x0F12FFB6, /*-FFD0---*/
	0x0F1201E6, /*-01B8---*/
	0x0F12018F, /*-018F---*/
	0x0F12FF8C, /*-FF8C---*/
	0x0F120137, /*-0137---*/
	
	0x0F12018A, /*-0180---*/  /* D65 */   
	0x0F12FFC1, /*-FFC2---*/
	0x0F12FFF5, /*-FFFD---*/
	0x0F120086, /*-0086---*/
	0x0F1200D2, /*-00D2---*/
	0x0F12FF73, /*-FF73---*/
	0x0F12FF0B, /*-FF25---*/
	0x0F120232, /*-022B---*/
	0x0F12FF49, /*-FF61---*/
	0x0F12FF43, /*-FF43---*/
	0x0F1201BA, /*-01BA---*/
	0x0F1200F3, /*-00F3---*/
	0x0F12FFE2, /*-FFED---*/
	0x0F12FFB6, /*-FFC4---*/
	0x0F1201E6, /*-01CD---*/
	0x0F12018F, /*-018F---*/
	0x0F12FF8C, /*-FF8C---*/
	0x0F120137, /*-0137---*/
	
	0x0F1201CC, /*----*/ /* OUT */
	0x0F12FFC3, /*----*/
	0x0F120009, /*----*/
	0x0F12009D, /*----*/
	0x0F1200FA, /*----*/
	0x0F12FF50, /*----*/
	0x0F12FED8, /*----*/
	0x0F1201FE, /*----*/
	0x0F12FF08, /*----*/
	0x0F12FEC7, /*----*/
	0x0F1200F5, /*----*/
	0x0F120119, /*----*/
	0x0F12FFDF, /*----*/
	0x0F120024, /*----*/
	0x0F1201A8, /*----*/
	0x0F120170, /*----*/
	0x0F12FFAD, /*----*/
	0x0F12011B, /*----*/
	
	/* Set NB */
	0x002A07EA,
	0x0F120000, /*afit_bUseNoiseInd 0 : NB 1: Noise Index */
	
	/* param_start	SARR_uNormBrInDoor */
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */
	
	/* param_start	SARR_uNormBrOutDoor */
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */
	
	/* Set AFIT */
	0x002A0814,
	0x0F12082C,
	0x0F127000,
	
	0x002A082C,
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F1203FF, /* Denoise1_iYDenThreshLow                                            */
	0x0F1203FF, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh                                           */
	0x0F1203FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120344, /* UVDenoise_iYLowThresh                                              */
	0x0F12033A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120C0F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120C0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12023F, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F12030A, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F120003, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F120011, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F120900, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F120000, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12980A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120000, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120000, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12000A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F126E14, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120012, /*  RGB2YUV_iYOffset                                                  */
	
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120016, /* 14 Denoise1_iYDenThreshLow                                            */
	0x0F12000E, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120072, /* 64 Denoise1_iYDenThreshHigh                                           */
	0x0F1200FF, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120114, /* UVDenoise_iYLowThresh                                              */
	0x0F12020A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120000, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120046, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F12050F, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120A0F, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120303, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120303, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F12020A, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120305, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F12101E, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F12101E, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F12200A, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120005, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120400, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120400, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120000, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120A00, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F12100A, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128030, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120009, /*  RGB2YUV_iYOffset                                                  */
	
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F120012, /* 0C Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006E, /* 60 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */
	
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F12006C, /* 5A Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120014, /* UVDenoise_iYLowThresh                                              */
	0x0F12000A, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120014, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120050, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120010, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120480, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122028, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122028, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F122000, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120403, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120402, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120203, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F12803C, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120180, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */
	
	0x0F120000, /* BRIGHTNESS                                                         */
	0x0F120000, /* CONTRAST                                                           */
	0x0F120000, /* SATURATION                                                         */
	0x0F120000, /* SHARP_BLUR                                                         */
	0x0F120000, /* GLAMOUR                                                            */
	0x0F1203FF, /* Disparity_iSatSat                                                  */
	0x0F12000F, /* 06 Denoise1_iYDenThreshLow                                            */
	0x0F120006, /* Denoise1_iYDenThreshLow_Bin                                        */
	0x0F120068, /* 50 Denoise1_iYDenThreshHigh                                           */
	0x0F120050, /* Denoise1_iYDenThreshHigh_Bin                                       */
	0x0F120002, /* Denoise1_iLowWWideThresh                                           */
	0x0F12000A, /* Denoise1_iHighWWideThresh                                          */
	0x0F12000A, /* Denoise1_iLowWideThresh                                            */
	0x0F12000A, /* Denoise1_iHighWideThresh                                           */
	0x0F1203FF, /* Denoise1_iSatSat                                                   */
	0x0F1203FF, /* Demosaic4_iHystGrayLow                                             */
	0x0F120000, /* Demosaic4_iHystGrayHigh                                            */
	0x0F120000, /* UVDenoise_iYLowThresh                                              */
	0x0F120000, /* UVDenoise_iYHighThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVLowThresh                                             */
	0x0F1203FF, /* UVDenoise_iUVHighThresh                                            */
	0x0F120028, /* DSMix1_iLowLimit_Wide                                              */
	0x0F120032, /* DSMix1_iLowLimit_Wide_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Wide                                             */
	0x0F120032, /* DSMix1_iHighLimit_Wide_Bin                                         */
	0x0F120030, /* DSMix1_iLowLimit_Fine                                              */
	0x0F120032, /* DSMix1_iLowLimit_Fine_Bin                                          */
	0x0F120000, /* DSMix1_iHighLimit_Fine                                             */
	0x0F120032, /* DSMix1_iHighLimit_Fine_Bin                                         */
	0x0F120106, /* DSMix1_iRGBOffset                                                  */
	0x0F12006F, /* DSMix1_iDemClamp                                                   */
	0x0F120202, /* "Disparity_iDispTH_LowDisparity_iDispTH_Low_Bin"                   */
	0x0F120502, /* "Disparity_iDispTH_High Disparity_iDispTH_High_Bin"                */
	0x0F120202, /* "Despeckle_iCorrectionLevelColdDespeckle_iCorrectionLevelCold_Bin" */
	0x0F120202, /* Despeckle_iCorrectionLevelHotDespeckle_iCorrectionLevelHot_Bin     */
	0x0F12140A, /* "Despeckle_iColdThreshLowDespeckle_iColdThreshHigh"                */
	0x0F12140A, /* "Despeckle_iHotThreshLowDespeckle_iHotThreshHigh"                  */
	0x0F122828, /* "Denoise1_iLowMaxSlopeAllowedDenoise1_iHighMaxSlopeAllowed"        */
	0x0F120606, /* "Denoise1_iLowSlopeThreshDenoise1_iHighSlopeThresh"                */
	0x0F120205, /* "Denoise1_iRadialPowerDenoise1_iRadialDivideShift"                 */
	0x0F120880, /* "Denoise1_iRadialLimitDenoise1_iLWBNoise"                          */
	0x0F12000F, /* "Denoise1_iWideDenoise1_iWideWide"                                 */
	0x0F120005, /* "Demosaic4_iHystGrayRangeUVDenoise_iYSupport"                      */
	0x0F122803, /* "UVDenoise_iUVSupportDSMix1_iLowPower_Wide"                        */
	0x0F122811, /* "DSMix1_iLowPower_Wide_BinDSMix1_iHighPower_Wide"                  */
	0x0F120A0F, /* "DSMix1_iHighPower_Wide_BinDSMix1_iLowThresh_Wide"                 */
	0x0F12050A, /* "DSMix1_iHighThresh_WideDSMix1_iReduceNegativeWide"                */
	0x0F122020, /* "DSMix1_iLowPower_FineDSMix1_iLowPower_Fine_Bin"                   */
	0x0F122020, /* "DSMix1_iHighPower_FineDSMix1_iHighPower_Fine_Bin"                 */
	0x0F126400, /* "DSMix1_iLowThresh_FineDSMix1_iHighThresh_Fine"                    */
	0x0F120007, /* "DSMix1_iReduceNegativeFineDSMix1_iRGBMultiplier"                  */
	0x0F120408, /* "Mixer1_iNLowNoisePowerMixer1_iNLowNoisePower_Bin"                 */
	0x0F120406, /* "Mixer1_iNVeryLowNoisePowerMixer1_iNVeryLowNoisePower_Bin"         */
	0x0F120000, /* "Mixer1_iNHighNoisePowerMixer1_iNHighNoisePower_Bin"               */
	0x0F120608, /* "Mixer1_iWLowNoisePowerMixer1_iWVeryLowNoisePower"                 */
	0x0F120000, /* "Mixer1_iWHighNoisePowerMixer1_iWLowNoiseCeilGain"                 */
	0x0F121006, /* "Mixer1_iWHighNoiseCeilGainMixer1_iWNoiseCeilGain"                 */
	0x0F120180, /* "CCM_Oscar_iSaturationCCM_Oscar_bSaturation"                       */
	0x0F120180, /* "RGBGamma2_iLinearityRGBGamma2_bLinearity"                         */
	0x0F120100, /* "RGBGamma2_iDarkReduceRGBGamma2_bDarkReduce"                       */
	0x0F128050, /* "byr_gas2_iShadingPowerRGB2YUV_iRGBGain"                           */
	0x0F120140, /* "RGB2YUV_iSaturationRGB2YUV_bGainOffset"                           */
	0x0F120000, /*  RGB2YUV_iYOffset                                                  */
	
	0x0F1200FF, /* Denoise1_iUVDenThreshLow                          */
	0x0F1200FF, /* Denoise1_iUVDenThreshHigh                         */
	0x0F120800, /* Denoise1_sensor_width                             */
	0x0F120600, /* Denoise1_sensor_height                            */
	0x0F120000, /* Denoise1_start_x                                  */
	0x0F120000, /* Denoise1_start_y                                  */
	0x0F120000, /* "Denoise1_iYDenSmoothDenoise1_iWSharp  "          */
	0x0F120300, /* "Denoise1_iWWSharp Denoise1_iRadialTune  "        */
	0x0F120002, /* "Denoise1_iOutputBrightnessDenoise1_binning_x  "  */
	0x0F120400, /* "Denoise1_binning_yDemosaic4_iFDeriv  "           */
	0x0F120106, /* "Demosaic4_iFDerivNeiDemosaic4_iSDeriv  "         */
	0x0F120005, /* "Demosaic4_iSDerivNeiDemosaic4_iEnhancerG  "      */
	0x0F120000, /* "Demosaic4_iEnhancerRBDemosaic4_iEnhancerV  "     */
	0x0F120703, /* "Demosaic4_iDecisionThreshDemosaic4_iDesatThresh" */
	0x0F120000, /*  Demosaic4_iBypassSelect                          */
	0x0F12FFD6,
	0x0F1253C1,
	0x0F12E1FE,
	0x0F120001,
	
	/* Update Changed Registers */
	0x002A03FC,
	0x0F120001, /* REG_TC_DBG_ReInitCmd */
	
	0x0028D000,
	0x002AB0CC,
	0x0F12000B, /* Non contious mode */
	/* Recording 25fps Anti-Flicker 50Hz END of Initial */
};
#endif

static const u32 s5k5bafx_stream_stop[] =
{
	0xFCFCD000,
	0x00287000,
 	0x002A01F0,
	0x0F120000, /* REG_TC_GP_EnablePreview */
	0x0F120001, /* REG_TC_GP_EnablePreviewChanged*/
};

#if (0)
static const u32 s5k5bafx_stream_start[] =
{
	0xFCFCD000,
	0x002AB00C,
	0x0F120001,
};
#endif

/*=================================
*	CAMERA_BRIGHTNESS_1 (1/9) M4   *
==================================*/
static const u32 s5k5bafx_bright_m4[] =
{
	/* Brightness -4 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FF88, /* REG_TC_UserBrightness */
};

/*=================================
*	CAMERA_BRIGHTNESS_2 (2/9) M3  *
==================================*/

static const u32 s5k5bafx_bright_m3[] =
{
	/* Brightness -3 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FFBC, /* REG_TC_UserBrightness*/
};

/*=================================
	CAMERA_BRIGHTNESS_3 (3/9) M2
==================================*/
static const u32 s5k5bafx_bright_m2[] =
{
	/* Brightness -2 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FFDC, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_4 (4/9) M1
==================================*/

static const u32 s5k5bafx_bright_m1[] =
{
	/* Brightness -1 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F12FFF2, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_5 (5/9) Default
==================================*/
static const u32 s5k5bafx_bright_default[] =
{
	/* Brightness 0 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120000, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_6 (6/9) P1
==================================*/
static const u32 s5k5bafx_bright_p1[] =
{
	/* Brightness +1 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120020, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_7 (7/9) P2
==================================*/
static const u32 s5k5bafx_bright_p2[] =
{
	/* Brightness +2 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120040, /* REG_TC_UserBrightness */
};

/*=================================
	CAMERA_BRIGHTNESS_8 (8/9) P3
==================================*/
static const u32 s5k5bafx_bright_p3[] =
{
	/* Brightness +3 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120060, /* REG_TC_UserBrightness */

};

/*=================================
	CAMERA_BRIGHTNESS_9 (9/9) P4
==================================*/
static const u32 s5k5bafx_bright_p4[] =
{
	/* Brightness +4 */
	0xFCFCD000,
	0x00287000,
	0x002A01E4,
	0x0F120080, /* REG_TC_UserBrightness */
};

/*******************************************************
* CAMERA_VT_PRETTY_0 Default
* 200s self cam pretty
*******************************************************/
static const u32 s5k5bafx_vt_pretty_default[] =
{
	/* 0xffff000A, */
	0xFCFCD000,

};


/*******************************************************
*	CAMERA_VT_PRETTY_1
*******************************************************/
static const u32 s5k5bafx_vt_pretty_1[] =
{
	/*0xffff000A,*/
	0xFCFCD000,

};


/*******************************************************
*	CAMERA_VT_PRETTY_2				*
*******************************************************/
static const u32 s5k5bafx_vt_pretty_2[] =
{
	/* 0xffff000A, */
	0xFCFCD000,

};


/*******************************************************
*	CAMERA_VT_PRETTY_3
*******************************************************/
static const u32 s5k5bafx_vt_pretty_3[] =
{
	/* 0xffff000A, */
	0xFCFCD000,

};

/* Don't delete it. */
static const u32 s5k5bafx_fps_auto[] = {
	0xFCFCD000,
	0x00287000,
};

static const u32 s5k5bafx_fps_7fix[] =
{
	/* Fixed 7fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120535, /* 7fps */
	0x0F120000,

	/* 0x002A021C, */
	/* 0x0F120000, *//* REG_TC_GP_ActivePrevConfig */
	/* 0x002A0220, */
	/* 0x0F120001, *//* REG_TC_GP_PrevOpenAfterChange */
	/* 0x002A01F8, */
	/* 0x0F120001, *//* REG_TC_GP_NewConfigSync */
	/* 0x002A021E, */
	/* 0x0F120001, *//* REG_TC_GP_PrevConfigChanged */
	/* 0x002A01F0, */
	/* 0x0F120001, *//* REG_TC_GP_EnablePreview */
	/* 0x0F120001, *//* REG_TC_GP_EnablePreviewChanged */

	/* 0xffff0096, *//* delay 150ms */

	/* 0x0028D000, *//* mipi */
	/* 0x002AB0CC, */
	/* 0x0F12000B, */
};

static const u32 s5k5bafx_fps_10fix[] =
{
	/*  Fixed 10fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F1203E8, /* 10fps */
	0x0F120000,
};

static const u32 s5k5bafx_fps_12fix[] =
{
	/*  Fixed 12fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120341, /* 12fps */
	0x0F120000,
};

static const u32 s5k5bafx_fps_15fix[] =
{
	/* Fixed 15fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F12029A, /* 15fps*/
	0x0F120000,
};

static const u32 s5k5bafx_fps_25fix[] =
{
	/* Fixed 25fps Mode */
	0xFCFCD000,
	0x00287000,

	0x002A0252,
	0x0F120000, /* FrRateQualityType */
	0x002A0250,
	0x0F120002, /* usFrTimeType */
	0x002A0254,
	0x0F120190, /* 15fps*/
	0x0F120000,
};

#ifdef SUPPORT_FACTORY_TEST
/*******************************************************
*	CAMERA_DTP_ON
*******************************************************/
static const u32 s5k5bafx_pattern_on[] = {
	0xffff01f4, /* Delay 500ms*/

	0xfcfcd000,
	0x00287000,

	0x002A07EC,
	0x0F12FFF0, /* SARR_uNormBrInDoor[0] */
	0x0F12FFF1, /* SARR_uNormBrInDoor[1] */
	0x0F12FFF2, /* SARR_uNormBrInDoor[2] */
	0x0F12FFF3, /* SARR_uNormBrInDoor[3] */
	0x0F12FFF4, /* SARR_uNormBrInDoor[4] */
	
	0x002A07F6,
	0x0F12FFF0, /* SARR_uNormBrOutDoor[0] */
	0x0F12FFF1, /* SARR_uNormBrOutDoor[1] */
	0x0F12FFF2, /* SARR_uNormBrOutDoor[2] */
	0x0F12FFF3, /* SARR_uNormBrOutDoor[3] */
	0x0F12FFF4, /* SARR_uNormBrOutDoor[4] */

	0xfcfcd000,
	0x0028d000,
	0x002a4100,
	0x0f1208a3, /* gas bypass */
	0x002a6600,
	0x0f120001, /* ccm bypass */
	0x002a6800,
	0x0f120001, /* gamma bypass */
	0x002a4400,
	0x0f120001, /* awb bypass */

	0x00287000,
	0x002A03b6,
	0x0F120001,
	0x002A03ba,
	0x0F120001, /* LEI control */

	0x0028D000,
	0x002A3118,
	0x0F120320, /* Colorbar pattern x size */
	0x0F120258, /* Colorbar pattern y size */
	0x0F120000,
	0x002A3100,
	0x0F120002, /* Colorbar pattern */
	
	0xffff0032, /* Delay 50msec */
};

/*******************************************************
*	CAMERA_DTP_OFF
*******************************************************/
static const u32 s5k5bafx_pattern_off[] = {

	0xfcfcd000,
	0x00287000,

	0x002A07EC,
	0x0F12000A, /* SARR_uNormBrInDoor[0] */
	0x0F120019, /* SARR_uNormBrInDoor[1] */
	0x0F12007D, /* SARR_uNormBrInDoor[2] */
	0x0F1202BC, /* SARR_uNormBrInDoor[3] */
	0x0F1207D0, /* SARR_uNormBrInDoor[4] */

	0x002A07F6,
	0x0F12000A, /* SARR_uNormBrOutDoor[0] */
	0x0F120019, /* SARR_uNormBrOutDoor[1] */
	0x0F12007D, /* SARR_uNormBrOutDoor[2] */
	0x0F1202BC, /* SARR_uNormBrOutDoor[3] */
	0x0F1207D0, /* SARR_uNormBrOutDoor[4] */

	0xfcfcd000,
	0x0028d000,
	0x002a4100,
	0x0f1208a2, /* gas bypass */
	0x002a6600,
	0x0f120000, /* ccm bypass */
	0x002a6800,
	0x0f120000, /* gamma bypass */
	0x002a4400,
	0x0f120000, /* awb bypass */

	0x00287000,
	0x002A03F8,
	0x0F120079,

	0xffff012c, /* Delay 300ms */
	0x002A03F8,
	0x0F12007F,

	0x0028D000,
	0x002A3118,
	0x0F120320, /* Colorbar pattern x size */
	0x0F120258, /* Colorbar pattern y size */
	0x0F120000,
	0x002A3100,
	0x0F120000, /* Colorbar pattern */
};
#endif /* SUPPORT_FACTORY_TEST */

#endif /* __S5K5BAFX_REGS_H */
