/* drivers/media/video/s5k5ccgx_regs-p4w.h
 *
 * Driver for s5k5ccgx (5MP Camera) from SEC(LSI), firmware EVT1.1
 *
 * Copyright (C) 2010, SAMSUNG ELECTRONICS
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Change Date: 2012.06.28
 */

#ifndef __ISX012_REGS_H__
#define __ISX012_REGS_H__

#define	AE_OFSETVAL 3450	//for tuning // max 5.1times
#define	AE_MAXDIFF 4000	//for tuning // max =< 5000
#define GLOWLIGHT_DEFAULT 0x002B	//for tuning
#define GLOWLIGHT_ISO50 0xB52A	//for tuning
#define GLOWLIGHT_ISO100 0x9DBA	//for tuning
#define GLOWLIGHT_ISO200 0x864A	//for tuning
#define GLOWLIGHT_ISO400 0x738A	//for tuning

#define ESD_VALUE	0xA6A6

/* change 4129 to 4802 */
#define AE_SCL_SUBRACT_VALUE		4802

static const uint16_t aeoffset_table[] = { /* normal 4.6times */
	0, 35, 70, 103, 136, 167, 198, 228, 257, 285,
	313, 339, 366, 391, 416, 441, 465, 488, 511, 533,
	555, 576, 597, 618, 638, 657, 677, 696, 714, 732,
	750, 768, 785, 802, 818, 835, 851, 866, 882, 897,
	912, 927, 941, 955, 969, 983, 997, 1010, 1023, 1036,
	1049, 1061, 1074, 1086, 1098, 1109, 1121, 1133, 1144, 1155,
	1166, 1177, 1187, 1198, 1208, 1219, 1229, 1239, 1248, 1258,
	1268, 1277, 1286, 1296, 1305, 1314, 1322, 1331, 1340, 1348,
	1357, 1365, 1373, 1381, 1389, 1397, 1405, 1413, 1420, 1428,
	1435, 1443, 1450, 1457, 1464, 1471, 1478, 1485, 1492, 1499,
	1505, 1512, 1518, 1525, 1531, 1538, 1544, 1550, 1556, 1562,
	1568, 1574, 1580, 1585, 1591, 1597, 1602, 1608, 1613, 1619,
	1624, 1629, 1635, 1640, 1645, 1650, 1655, 1660, 1665, 1670,
	1675, 1679, 1684, 1689, 1693, 1698, 1703, 1707, 1712, 1716,
	1720, 1725, 1729, 1733, 1737, 1742, 1746, 1750, 1754, 1758,
	1762, 1766, 1770, 1774, 1777, 1781, 1785, 1789, 1792, 1796,
	1800, 1803, 1807, 1810, 1814, 1817, 1821, 1824, 1828, 1831,
	1834, 1837, 1841, 1844, 1847, 1850, 1853, 1856, 1860, 1863,
	1866, 1869, 1872, 1875, 1877, 1880, 1883, 1886, 1889, 1892,
	1894, 1897, 1900, 1903, 1905, 1908, 1911, 1913, 1916, 1918,
	1921, 1923, 1926, 1928, 1931, 1933, 1936, 1938, 1941, 1943,
	1945, 1948, 1950, 1952, 1954, 1957, 1959, 1961, 1963, 1965,
	1968, 1970, 1972, 1974, 1976, 1978, 1980, 1982, 1984, 1986,
	1988, 1990, 1992, 1994, 1996, 1998, 2000, 2002, 2003, 2005,
	2007, 2009, 2011, 2013, 2014, 2016, 2018, 2020, 2021, 2023,
	2025, 2026, 2028, 2030, 2031, 2033, 2034, 2036, 2038, 2039,
	2041, 2042, 2044, 2045, 2047, 2048, 2050, 2051, 2053, 2054,
	2056, 2057, 2059, 2060, 2061, 2063, 2064, 2066, 2067, 2068,
	2070, 2071, 2072, 2074, 2075, 2076, 2077, 2079, 2080, 2081,
	2082, 2084, 2085, 2086, 2087, 2089, 2090, 2091, 2092, 2093,
	2094, 2096, 2097, 2098, 2099, 2100, 2101, 2102, 2103, 2104,
	2105, 2106, 2107, 2109, 2110, 2111, 2112, 2113, 2114, 2115,
	2116, 2117, 2118, 2119, 2120, 2120, 2121, 2122, 2123, 2124,
	2125, 2126, 2127, 2128, 2129, 2130, 2130, 2131, 2132, 2133,
	2134, 2135, 2136, 2136, 2137, 2138, 2139, 2140, 2141, 2141,
	2142, 2143, 2144, 2144, 2145, 2146, 2147, 2148, 2148, 2149,
	2150, 2150, 2151, 2152, 2153, 2153, 2154, 2155, 2155, 2156,
	2157, 2158, 2158, 2159, 2160, 2160, 2161, 2162, 2162, 2163,
	2163, 2164, 2165, 2165, 2166, 2167, 2167, 2168, 2168, 2169,
	2170, 2170, 2171, 2171, 2172, 2172, 2173, 2174, 2174, 2175,
	2175, 2176, 2176, 2177, 2177, 2178, 2179, 2179, 2180, 2180,
	2181, 2181, 2182, 2182, 2183, 2183, 2184, 2184, 2185, 2185,
	2186, 2186, 2186, 2187, 2187, 2188, 2188, 2189, 2189, 2190,
	2190, 2191, 2191, 2191, 2192, 2192, 2193, 2193, 2194, 2194,
	2194, 2195, 2195, 2196, 2196, 2196, 2197, 2197, 2198, 2198,
	2198, 2199, 2199, 2200, 2200, 2200, 2201, 2201, 2201, 2202,
	2202, 2203, 2203, 2203, 2204, 2204, 2204, 2205, 2205, 2205,
	2206, 2206, 2206, 2207, 2207, 2207, 2208, 2208, 2208, 2209,
	2209, 2209, 2210, 2210, 2210, 2210, 2211, 2211, 2211, 2212,
	2212, 2212, 2213, 2213, 2213, 2213, 2214, 2214, 2214, 2214,
};

static const isx012_regset_t ISX012_Init_Reg[] =
{
/////////////////////////////////////
//AF driver setting// AF driver//
/////////////////////////////////////
{0x66C2,0x0C,0x01},//AF_INTERNAL_LENSDRV_ADRS
{0x66C3,0x02,0x01},//AF_INTERNAL_LENSDRV_SIZE
{0x66C5,0x14,0x01},//AF_INTERNAL_LENSDRV_SHIFT
{0x66C8,0x0000,0x02},//AF_INTERNAL_LENSDRV_FIXEDPTN
{0x66CA,0x000F,0x02},
{0x000B,0x01,0x01},//AF_EXT : AF driver start

//////////////////////////////////////////
//	ISX012_Initial_Setting.ini	//
//////////////////////////////////////////
// AE window add V02
{0x6000,0x06,0x01},    // CENTER_FIXWEIGHT_00_TYPE1 :
{0x6001,0x06,0x01},    // CENTER_FIXWEIGHT_01_TYPE1 :
{0x6002,0x06,0x01},    // CENTER_FIXWEIGHT_02_TYPE1 :
{0x6003,0x06,0x01},    // CENTER_FIXWEIGHT_03_TYPE1 :
{0x6004,0x06,0x01},    // CENTER_FIXWEIGHT_04_TYPE1 :
{0x6005,0x06,0x01},    // CENTER_FIXWEIGHT_05_TYPE1 :
{0x6006,0x06,0x01},    // CENTER_FIXWEIGHT_06_TYPE1 :
{0x6007,0x06,0x01},    // CENTER_FIXWEIGHT_07_TYPE1 :
{0x6008,0x06,0x01},    // CENTER_FIXWEIGHT_08_TYPE1 :
{0x6009,0x0C,0x01},    // CENTER_FIXWEIGHT_09_TYPE1 :
{0x600A,0x0C,0x01},    // CENTER_FIXWEIGHT_10_TYPE1 :
{0x600B,0x0C,0x01},    // CENTER_FIXWEIGHT_11_TYPE1 :
{0x600C,0x10,0x01},    // CENTER_FIXWEIGHT_12_TYPE1 :
{0x600D,0x10,0x01},    // CENTER_FIXWEIGHT_13_TYPE1 :
{0x600E,0x10,0x01},    // CENTER_FIXWEIGHT_14_TYPE1 :
{0x600F,0x0C,0x01},    // CENTER_FIXWEIGHT_15_TYPE1 :
{0x6010,0x0C,0x01},    // CENTER_FIXWEIGHT_16_TYPE1 :
{0x6011,0x0C,0x01},    // CENTER_FIXWEIGHT_17_TYPE1 :
{0x6012,0x0C,0x01},    // CENTER_FIXWEIGHT_18_TYPE1 :
{0x6013,0x0C,0x01},    // CENTER_FIXWEIGHT_19_TYPE1 :
{0x6014,0x18,0x01},    // CENTER_FIXWEIGHT_20_TYPE1 :
{0x6015,0x18,0x01},    // CENTER_FIXWEIGHT_21_TYPE1 :
{0x6016,0x18,0x01},    // CENTER_FIXWEIGHT_22_TYPE1 :
{0x6017,0x18,0x01},    // CENTER_FIXWEIGHT_23_TYPE1 :
{0x6018,0x18,0x01},    // CENTER_FIXWEIGHT_24_TYPE1 :
{0x6019,0x0C,0x01},    // CENTER_FIXWEIGHT_25_TYPE1 :
{0x601A,0x0C,0x01},    // CENTER_FIXWEIGHT_26_TYPE1 :
{0x601B,0x0C,0x01},    // CENTER_FIXWEIGHT_27_TYPE1 :
{0x601C,0x18,0x01},    // CENTER_FIXWEIGHT_28_TYPE1 :
{0x601D,0x18,0x01},    // CENTER_FIXWEIGHT_29_TYPE1 :
{0x601E,0x1E,0x01},    // CENTER_FIXWEIGHT_30_TYPE1 :
{0x601F,0x1E,0x01},    // CENTER_FIXWEIGHT_31_TYPE1 :
{0x6020,0x1E,0x01},    // CENTER_FIXWEIGHT_32_TYPE1 :
{0x6021,0x18,0x01},    // CENTER_FIXWEIGHT_33_TYPE1 :
{0x6022,0x18,0x01},    // CENTER_FIXWEIGHT_34_TYPE1 :
{0x6023,0x0C,0x01},    // CENTER_FIXWEIGHT_35_TYPE1 :
{0x6024,0x0C,0x01},    // CENTER_FIXWEIGHT_36_TYPE1 :
{0x6025,0x18,0x01},    // CENTER_FIXWEIGHT_37_TYPE1 :
{0x6026,0x18,0x01},    // CENTER_FIXWEIGHT_38_TYPE1 :
{0x6027,0x1E,0x01},    // CENTER_FIXWEIGHT_39_TYPE1 :
{0x6028,0x1E,0x01},    // CENTER_FIXWEIGHT_40_TYPE1 :
{0x6029,0x1E,0x01},    // CENTER_FIXWEIGHT_41_TYPE1 :
{0x602A,0x18,0x01},    // CENTER_FIXWEIGHT_42_TYPE1 :
{0x602B,0x18,0x01},    // CENTER_FIXWEIGHT_43_TYPE1 :
{0x602C,0x0C,0x01},    // CENTER_FIXWEIGHT_44_TYPE1 :
{0x602D,0x0C,0x01},    // CENTER_FIXWEIGHT_45_TYPE1 :
{0x602E,0x0C,0x01},    // CENTER_FIXWEIGHT_46_TYPE1 :
{0x602F,0x18,0x01},    // CENTER_FIXWEIGHT_47_TYPE1 :
{0x6030,0x18,0x01},    // CENTER_FIXWEIGHT_48_TYPE1 :
{0x6031,0x18,0x01},    // CENTER_FIXWEIGHT_49_TYPE1 :
{0x6032,0x18,0x01},    // CENTER_FIXWEIGHT_50_TYPE1 :
{0x6033,0x18,0x01},    // CENTER_FIXWEIGHT_51_TYPE1 :
{0x6034,0x0C,0x01},    // CENTER_FIXWEIGHT_52_TYPE1 :
{0x6035,0x0C,0x01},    // CENTER_FIXWEIGHT_53_TYPE1 :
{0x6036,0x0C,0x01},    // CENTER_FIXWEIGHT_54_TYPE1 :
{0x6037,0x0C,0x01},    // CENTER_FIXWEIGHT_55_TYPE1 :
{0x6038,0x0C,0x01},    // CENTER_FIXWEIGHT_56_TYPE1 :
{0x6039,0x0C,0x01},    // CENTER_FIXWEIGHT_57_TYPE1 :
{0x603A,0x0C,0x01},    // CENTER_FIXWEIGHT_58_TYPE1 :
{0x603B,0x0C,0x01},    // CENTER_FIXWEIGHT_59_TYPE1 :
{0x603C,0x0C,0x01},    // CENTER_FIXWEIGHT_60_TYPE1 :
{0x603D,0x0C,0x01},    // CENTER_FIXWEIGHT_61_TYPE1 :
{0x603E,0x0C,0x01},    // CENTER_FIXWEIGHT_62_TYPE1 :


//AF filter
{0x6D14,0x0001,0x02},    // HPF_HBPF_CORSL_Y1 :
{0x6D16,0x0001,0x02},    // HPF_HBPF_CORSL_Y2 :
{0x6D18,0x0002,0x02},    // HPF_HBPF_CORSL_Y3 :
{0x6D1A,0x0005,0x02},    // HPF_HBPF_CORSL_Y4 :

{0x6D20,0x0004,0x02},    // HPF_HBPF_CORL_Y1 :
{0x6D22,0x0004,0x02},    // HPF_HBPF_CORL_Y2 :
{0x6D24,0x000F,0x02},    // HPF_HBPF_CORL_Y3 :
{0x6D26,0x001E,0x02},    // HPF_HBPF_CORL_Y4 :

{0x6D2C,0x000E,0x02},    // HPF_HBPF_CORH_Y1 :
{0x6D2E,0x000F,0x02},    // HPF_HBPF_CORH_Y2 :
{0x6D30,0x0022,0x02},    // HPF_HBPF_CORH_Y3 :
{0x6D32,0x004D,0x02},    // HPF_HBPF_CORH_Y4 :

{0x6D44,0x0001,0x02},    // HPF_LBPF_CORSL_Y1 :
{0x6D46,0x0001,0x02},    // HPF_LBPF_CORSL_Y2 :
{0x6D48,0x0002,0x02},    // HPF_LBPF_CORSL_Y3 :
{0x6D4A,0x0004,0x02},    // HPF_LBPF_CORSL_Y4 :

{0x6D50,0x03FF,0x02},    // HPF_LBPF_CORL_Y1 :
{0x6D52,0x03FF,0x02},    // HPF_LBPF_CORL_Y2 :
{0x6D54,0x03FF,0x02},    // HPF_LBPF_CORL_Y3 :
{0x6D56,0x03FF,0x02},    // HPF_LBPF_CORL_Y4 :

{0x6D5C,0x03FF,0x02},    // HPF_LBPF_CORH_Y1 :
{0x6D5E,0x03FF,0x02},    // HPF_LBPF_CORH_Y2 :
{0x6D60,0x03FF,0x02},    // HPF_LBPF_CORH_Y3 :
{0x6D62,0x03FF,0x02},    // HPF_LBPF_CORH_Y4 :

{0x6D74,0x0001,0x02},    // HPF_VHBPF_CORSL_Y1 :
{0x6D76,0x0001,0x02},    // HPF_VHBPF_CORSL_Y2 :
{0x6D78,0x0002,0x02},    // HPF_VHBPF_CORSL_Y3 :
{0x6D7A,0x0005,0x02},    // HPF_VHBPF_CORSL_Y4 :

{0x6D80,0x0004,0x02},    // HPF_VHBPF_CORL_Y1 :
{0x6D82,0x0005,0x02},    // HPF_VHBPF_CORL_Y2 :
{0x6D84,0x000C,0x02},    // HPF_VHBPF_CORL_Y3 :
{0x6D86,0x001C,0x02},    // HPF_VHBPF_CORL_Y4 :

{0x6D8C,0x000D,0x02},    // HPF_VHBPF_CORH_Y1 :
{0x6D8E,0x0010,0x02},    // HPF_VHBPF_CORH_Y2 :
{0x6D90,0x0026,0x02},    // HPF_VHBPF_CORH_Y3 :
{0x6D92,0x004D,0x02},    // HPF_VHBPF_CORH_Y4 :

// CAF ߰κ
{0x6622,0x0004,0x02},    // AF_CAF_PARAM_WOBBLE_STEP :
{0x6624,0x0008,0x02},    // AF_CAF_CLIMB_STEP :
{0x6687,0x01,0x01},    // AF_CAF_CLIMB_PEAK_BACK_STEP_ENABLE :
{0x6698,0x00,0x01},    // AF_CAF_WOBBLE_FILTER_ENABLE :
{0x66A4,0x06,0x01},    // AF_CAF_OPD_FLAT_MOVE_ENABLE :
{0x66B0,0x0002,0x02},    // AF_CAF_WAIT_FOR_AF_STABLE_TH :
{0x5003,0x04,0x01},    // Z1_HOLD = 1
//110819
{0x6696,0x16,0x01},	//AF_CAF_WOBBLE_START_INTERVAL_COUNTER
{0x6716,0x0000,0x02},    // CAF_LVD_WOB_HBPF_VAL1 :
{0x6718,0x0000,0x02},    // CAF_LVD_WOB_HBPF_VAL2 :
{0x671A,0x00C8,0x02},    // CAF_LVD_WOB_HBPF_RATE1 :
{0x671C,0x00C8,0x02},    // CAF_LVD_WOB_HBPF_RATE2 :
{0x671E,0x00,0x01},    // CAF_LVD_WOB_HBPF_SHIFT :
{0x6720,0x0000,0x02},    // CAF_LVD_WOB_LBPF_VAL1 :
{0x6722,0x0000,0x02},    // CAF_LVD_WOB_LBPF_VAL2 :
{0x6724,0x0014,0x02},    // CAF_LVD_WOB_LBPF_RATE1 :
{0x6726,0x0014,0x02},    // CAF_LVD_WOB_LBPF_RATE2 :
{0x6728,0x00,0x01},    // CAF_LVD_WOB_LBPF_SHIFT :
{0x672A,0x0000,0x02},    // CAF_LVD_CLMP_HBPF_VAL1 :
{0x672C,0x0000,0x02},    // CAF_LVD_CLMP_HBPF_VAL2 :
{0x672E,0x012C,0x02},    // CAF_LVD_CLMP_HBPF_RATE1 :
{0x6730,0x012C,0x02},    // CAF_LVD_CLMP_HBPF_RATE2 :
{0x6732,0x00,0x01},    // CAF_LVD_CLMP_HBPF_SHIFT :
{0x6734,0x0000,0x02},    // CAF_LVD_CLMP_LBPF_VAL1 :
{0x6736,0x0000,0x02},    // CAF_LVD_CLMP_LBPF_VAL2 :
{0x6738,0x0046,0x02},    // CAF_LVD_CLMP_LBPF_RATE1 :
{0x673A,0x0046,0x02},    // CAF_LVD_CLMP_LBPF_RATE2 :
{0x673C,0x00,0x01},    // CAF_LVD_CLMP_LBPF_SHIFT :
{0x661E,0x00C8,0x02},    //AF_CAF_FAR_POSITION
{0x6620,0x02BC,0x02},    //AF_CAF_NEAR_POSITION

//߰úκ SAFκ
{0x00B2,0x02,0x01},    // AFMODE_MONI : manual AF mode
{0x028E,0x00,0x01},    // AF_SN1_2 :
{0x028F,0x00,0x01},    // AF_SN3_4 :
{0x0290,0x00,0x01},    // AF_SN5_6 :
{0x0291,0x00,0x01},    // AF_SN7_8 :
{0x0292,0x00,0x01},    // AF_SN9_10 :
{0x0293,0x00,0x01},    // AF_SN11_12 :
{0x6604,0x00,0x01},    // AF_SEARCH_DIR :
{0x6616,0x01,0x01},    // AF_DIRECTBACK_F :On=1
{0x661B,0x03,0x01},    // AF_OPDDATA_SAVE :
{0x661C,0x00,0x01},    // AF_MONOTONY_POS :
{0x663E,0x00,0x01},    // AF_SEARCH_SECOND_DIR :
{0x663F,0x01,0x01},    // AF_DIRECTBACK_SECOND_F :
{0x6674,0x00,0x01},    // AF_MONICHG_MOVE_F : AF off zero position (01) ġ (00) 
{0x6675,0x01,0x01},    // CAP_AF_CANCEL_F : 1  capture忡 AFڵ ĵ
{0x6676,0x02,0x01},    // AF_SAxF_MODE :
{0x669E,0x02,0x01},    // AF_SECOND_WND_CHK :
{0x6600,0x00C8,0x02},    // AF_SEARCH_AREA_LOW :
{0x6602,0x02BC,0x02},    // AF_SEARCH_AREA_HIGH :
{0x6640,0x02,0x01},    // AF_DROPN_ON_PEAK_DETECT_SECOND :
{0x6641,0x02,0x01},    // AF_UPN_ON_PEAK_DETECT_SECOND :
{0x6642,0x02,0x01},        //AF_DROPRATE_ON_DETECT_SECOND_HBPF
{0x6643,0x02,0x01},        //AF_DROPRATE_ON_DETECT_SECOND_LBPF
{0x6644,0x14,0x01},    // AF_UPRATE_ON_PEAK_DETECT_HBPF_SECOND :
{0x6646,0x08,0x01},    // AF_OPD_WEIGHT_TH :
{0x664A,0x04,0x01},    // AF_DROPN_ON_PEAK_DETECT :
{0x664B,0x02,0x01},    // AF_UPN_ON_PEAK_DETECT :
{0x664C,0xFF,0x01},    // AF_UPRATE_ON_PEAK_DETECT_HBPF :
{0x665A,0x00C8,0x02},    // AF_LENSPOS_ON_AFNG :
{0x665C,0x0018,0x02},    // AF_DRV_AMOUNT_TONEAR_F :
{0x665E,0x0003,0x02},    // AF_DRV_AMOUNT_TONEAR_S :
{0x6660,0x0018,0x02},    // AF_DRV_AMOUNT_TOFAR_F :
{0x6662,0x0003,0x02},    // AF_DRV_AMOUNT_TOFAR_S :
{0x6666,0x00C8,0x02},    // AF_AREA_LOW_TYPE1 :
{0x6668,0x02BC,0x02},    // AF_AREA_HIGH_TYPE1 :
{0x669A,0x01F4,0x02},    // AF_OPD_MONOTONYUP_HBPF_TH :
{0x66E4,0x50,0x01},    // AF_TH_1STDEPEND_HBPF_RATE :
{0x66EE,0x03E8,0x02},    // AF_LVD_HBPF_VAL1_1ST :
{0x66F0,0x4E20,0x02},    // AF_LVD_HBPF_VAL2_1ST :
{0x66F2,0x004C,0x02},    // AF_LVD_HBPF_RATE1_1ST :
{0x66F4,0x0019,0x02},    // AF_LVD_HBPF_RATE2_1ST :
{0x66F6,0x00,0x01},    // AF_LVD_HBPF_SHIFT_1ST :
{0x6702,0x03E8,0x02},    // AF_LVD_HBPF_VAL1_2ND :
{0x6704,0x4E20,0x02},    // AF_LVD_HBPF_VAL2_2ND :
{0x6706,0x0003,0x02},    // AF_LVD_HBPF_RATE1_2ND :
{0x6708,0x0003,0x02},    // AF_LVD_HBPF_RATE2_2ND :
{0x670A,0x00,0x01},    // AF_LVD_HBPF_SHIFT_2ND :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
//chooys add
{0x6677,0x00,0x01},    // AF_SEND_PARTITION : Use=1
{0x6678,0x20,0x01},    // AF_SENDNUM_ALL
{0x6679,0x01,0x01},    // AF_SENDNUM_UP
{0x667A,0x01,0x01},    // AF_SENDNUM_DOWN
{0x667C,0x0002,0x02},    // AF_SENDAMOUNT_ADDLIMIT
{0x667E,0x0020,0x02},     //AF_SENDLINE

// AF opd_TH
{0x660E,0x5A,0x01},    // AF_HBPF_PEAK_OPD_TH_MIN
{0x6610,0x5A,0x01},    // AF_HBPF_PEAK_OPD_TH_MAX

{0x66E4,0xC8,0x01},
{0x66E5,0xC8,0x01},

//AF opd window setting
{0x6A30,0x044E,0x02},    // AF_OPD0_HDELAY :
{0x6A32,0x02E5,0x02},    // AF_OPD0_VDELAY :
{0x6A34,0x01D8,0x02},    // AF_OPD0_HVALID :
{0x6A36,0x01D8,0x02},    // AF_OPD0_VVALID :
{0x6A38,0x0412,0x02},    // AF_OPD1_HDELAY :
{0x6A3A,0x02A9,0x02},    // AF_OPD1_VDELAY :
{0x6A3C,0x0251,0x02},    // AF_OPD1_HVALID :
{0x6A3E,0x0251,0x02},    // AF_OPD1_VVALID :
{0x6A40,0x04B4,0x02},    // AF_OPD2_HDELAY :
{0x6A42,0x0114,0x02},    // AF_OPD2_VDELAY :
{0x6A44,0x0118,0x02},    // AF_OPD2_HVALID :
{0x6A46,0x0118,0x02},    // AF_OPD2_VVALID :
{0x6A48,0x0469,0x02},    // AF_OPD3_HDELAY :
{0x6A4A,0x00C9,0x02},    // AF_OPD3_VDELAY :
{0x6A4C,0x01AE,0x02},    // AF_OPD3_HVALID :
{0x6A4E,0x01AE,0x02},    // AF_OPD3_VVALID :
{0x6A50,0x04C6,0x02},    // AF_OPD4_HDELAY :
{0x6A52,0x035D,0x02},    // AF_OPD4_VDELAY :
{0x6A54,0x00E6,0x02},    // AF_OPD4_HVALID :
{0x6A56,0x00E6,0x02},    // AF_OPD4_VVALID :
{0x6A58,0x048A,0x02},    // AF_OPD5_HDELAY :
{0x6A5A,0x0321,0x02},    // AF_OPD5_VDELAY :
{0x6A5C,0x015F,0x02},    // AF_OPD5_HVALID :
{0x6A5E,0x015F,0x02},    // AF_OPD5_VVALID :
{0x6A60,0x04B4,0x02},    // AF_OPD6_HDELAY :
{0x6A62,0x0579,0x02},    // AF_OPD6_VDELAY :
{0x6A64,0x0118,0x02},    // AF_OPD6_HVALID :
{0x6A66,0x0118,0x02},    // AF_OPD6_VVALID :
{0x6A68,0x0469,0x02},    // AF_OPD7_HDELAY :
{0x6A6A,0x052C,0x02},    // AF_OPD7_VDELAY :
{0x6A6C,0x01AE,0x02},    // AF_OPD7_HVALID :
{0x6A6E,0x01AE,0x02},    // AF_OPD7_VVALID :
{0x6A70,0x021D,0x02},    // AF_OPD8_HDELAY :
{0x6A72,0x02F5,0x02},    // AF_OPD8_VDELAY :
{0x6A74,0x01AE,0x02},    // AF_OPD8_HVALID :
{0x6A76,0x01AE,0x02},    // AF_OPD8_VVALID :
{0x6A78,0x06A4,0x02},    // AF_OPD9_HDELAY :
{0x6A7A,0x02F5,0x02},    // AF_OPD9_VDELAY :
{0x6A7C,0x01AE,0x02},    // AF_OPD9_HVALID :
{0x6A7E,0x01AE,0x02},    // AF_OPD9_VVALID :
{0x6A80,0x06,0x01},    // AF_OPD1A_WEIGHT :
{0x6A81,0x05,0x01},    // AF_OPD1B_WEIGHT :
{0x6A82,0x02,0x01},    // AF_OPD2A_WEIGHT :
{0x6A83,0x02,0x01},    // AF_OPD2B_WEIGHT :
{0x6A84,0x08,0x01},    // AF_OPD3A_WEIGHT :
{0x6A85,0x07,0x01},    // AF_OPD3B_WEIGHT :
{0x6A86,0x04,0x01},    // AF_OPD4A_WEIGHT :
{0x6A87,0x03,0x01},    // AF_OPD4B_WEIGHT :
{0x6A88,0x01,0x01},    // AF_OPD5A_WEIGHT :
{0x6A89,0x01,0x01},    // AF_OPD5B_WEIGHT :


//lee haknoh add
{0x661C,0x00,0x01},
//S,66BE,0F,8,    //AF_JUDGE_CONF
//S,669A,01F4,16,    //AF_OPD_MONOTONYUP_HBPF_TH
//S,669C,03E8,16,    //AF_OPD_MONOTONYUP_LBPF_TH
{0x673D,0x01,0x01},    //AF_MANUAL_MOVE_TYTPE : manual mode AF_MANUAL_POS ̵ 
{0x6648,0x00C8,0x02},    //AF_MANUAL_POS
{0x66E0,0x00C8,0x02},    //AF_POS_INF_SET
{0x66E2,0x02BC,0x02},    //AF_POS_MACRO_SET
{0x00B2,0x02,0x01}, //AFMODE_MONI : Manual AF mode


//߰  κ
{0x00F7,0x52,0x01},    // INIT_QLTY0 : Standard 82
{0x00F8,0x59,0x01},    // INIT_QLTY1 : Fine 89
{0x00F9,0x5F,0x01},    // INIT_QLTY2 : SuperFine 95

//minimum shutter speed
{0x6800,0x03,0x01},    //SHTMINLINE

/////// Normal AE Line //////
// normal capture AE line
{0x0326,0x21,0x01},    // SHTCTRLTIME1_TYPE1 :
{0x0327,0x19,0x01},    // AGCGAIN1_TYPE1 :
{0x0328,0x52,0x01},    // SHTCTRLTIME2_TYPE1 :
{0x0329,0x23,0x01},    // AGCGAIN2_TYPE1 :
{0x032A,0x3E,0x01},    // SHTCTRLTIME3_TYPE1 :
{0x032B,0x3F,0x01},    // AGCGAIN3_TYPE1 :

// normal preview AE line
{0x032C,0x7C,0x01},    // SHTCTRLTIME1_TYPE2
{0x032D,0x3D,0x01},    // AGCGAIN1_TYPE2
{0x032E,0x7C,0x01},    // SHTCTRLTIME2_TYPE2
{0x032F,0x3D,0x01},    // AGCGAIN2_TYPE2
{0x0330,0x3E,0x01},    // SHTCTRLTIME3_TYPE2
{0x0331,0x3F,0x01},    // AGCGAIN3_TYPE2

// flash ae line
{0x0332,0x42,0x01},    // SHTCTRLTIME1_TYPE3 :
{0x0333,0x3C,0x01},    // AGCGAIN1_TYPE3 :
{0x0334,0x42,0x01},    // SHTCTRLTIME2_TYPE3 :
{0x0335,0x3C,0x01},    // AGCGAIN2_TYPE3 :
{0x0336,0x21,0x01},    // SHTCTRLTIME3_TYPE3 :
{0x0337,0x3C,0x01},    // AGCGAIN3_TYPE3 :

//sports ae line
{0x0338,0x00,0x01},    // SHTCTRLTIME1_TYPE4
{0x0339,0x14,0x01},    // AGCGAIN1_TYPE4
{0x033A,0x21,0x01},    // SHTCTRLTIME2_TYPE4
{0x033B,0x19,0x01},    // AGCGAIN2_TYPE4
{0x033C,0x3E,0x01},    // SHTCTRLTIME3_TYPE4
{0x033D,0x3D,0x01},    // AGCGAIN3_TYPE4

//night mode AF ae line
{0x033E,0xFF,0x01},    // SHTCTRLTIME1_TYPE5 :
{0x033F,0x00,0x01},    // AGCGAIN1_TYPE5 :
{0x0340,0xFF,0x01},    // SHTCTRLTIME2_TYPE5 :
{0x0341,0x00,0x01},    // AGCGAIN2_TYPE5 :
{0x0342,0xA6,0x01},    // SHTCTRLTIME3_TYPE5 :
{0x0343,0x49,0x01},    // AGCGAIN3_TYPE5 :

//night mode capture ae line
{0x0344,0xFF,0x01},    // SHTCTRLTIME1_TYPE6 :
{0x0345,0x00,0x01},    // AGCGAIN1_TYPE6 :
{0x0346,0xFF,0x01},    // SHTCTRLTIME2_TYPE6 :
{0x0347,0x00,0x01},    // AGCGAIN2_TYPE6 :
{0x0348,0xFA,0x01},    // SHTCTRLTIME3_TYPE6 :
{0x0349,0x3B,0x01},    // AGCGAIN3_TYPE6 :

// fire mode line
{0x0356,0x01,0x01},    // SHTCTRLTIME1_TYPE9 :
{0x0357,0x04,0x01},    // AGCGAIN1_TYPE9 :
{0x0358,0x01,0x01},    // SHTCTRLTIME2_TYPE9 :
{0x0359,0x04,0x01},    // AGCGAIN2_TYPE9 :
{0x035A,0xF8,0x01},    // SHTCTRLTIME3_TYPE9 :
{0x035B,0x04,0x01},    // AGCGAIN3_TYPE9 :

// fire mode AF line
{0x035C,0x01,0x01},    // SHTCTRLTIME1_TYPE10 :
{0x035D,0x04,0x01},    // AGCGAIN1_TYPE10 :
{0x035E,0x01,0x01},    // SHTCTRLTIME2_TYPE10 :
{0x035F,0x04,0x01},    // AGCGAIN2_TYPE10 :
{0x0360,0x21,0x01},    // SHTCTRLTIME3_TYPE10 :
{0x0361,0x3E,0x01},    // AGCGAIN3_TYPE10 :


//AE ref tunning
{0x5E8A,0x02,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x02,0x01},    // EVREF_GAIN_B :
{0x5E8C,0xFD,0x01},    // EVREF_GAIN_C :
{0x5E8D,0xFD,0x01},    // EVREF_GAIN_D :
{0x5E8E,0xFD,0x01},    // EVREF_GAIN_E :
{0x5E8F,0x90,0x01},    // EVREF_TH_A :
{0x5E90,0x94,0x01},    // EVREF_TH_B :
{0x5E91,0xA5,0x01},    // EVREF_TH_C :
{0x5E92,0xC0,0x01},    // EVREF_TH_D :
{0x5E93,0xD5,0x01},    // EVREF_TH_E :


//gamma Ilumi
{0x9211,0x58,0x01},    // GAIN_TH_A_TYPE3 :
{0x9212,0x63,0x01},    // GAIN_TH_B_TYPE3 :
{0x9213,0x9F,0x01},    // GAIN_TH_C_TYPE3 :

{0x984E,0x0A,0x01},    // GAMMA0_0CLIP_A :
{0x984F,0x0A,0x01},    // GAMMA0_0CLIP_B :
{0x9850,0x05,0x01},    // GAMMA0_0CLIP_C :
{0x9851,0x1E,0x01},    // GAMMA0_SLOPE_A :
{0x9852,0x1E,0x01},    // GAMMA0_SLOPE_B :
{0x9853,0x1E,0x01},    // GAMMA0_SLOPE_C :
{0x9854,0x0A,0x01},    // GAMMA1_0CLIP_A :
{0x9855,0x0F,0x01},    // GAMMA1_0CLIP_B :
{0x9856,0x0F,0x01},    // GAMMA1_0CLIP_C :
{0x9857,0x32,0x01},    // GAMMA1_SLOPE_A :
{0x9858,0x1E,0x01},    // GAMMA1_SLOPE_B :
{0x9859,0x1E,0x01},    // GAMMA1_SLOPE_C :


//Gammma Table 0
{0x7000,0x0000,0x02},    // G0_KNOT_G0 :
{0x7002,0x0015,0x02},    // G0_KNOT_G1 :
{0x7004,0x002C,0x02},    // G0_KNOT_G2 :
{0x7006,0x0041,0x02},    // G0_KNOT_G3 :
{0x7008,0x004D,0x02},    // G0_KNOT_G4 :
{0x700A,0x005B,0x02},    // G0_KNOT_G5 :
{0x700C,0x0060,0x02},    // G0_KNOT_G6 :
{0x700E,0x0068,0x02},    // G0_KNOT_G7 :
{0x7010,0x006F,0x02},    // G0_KNOT_G8 :
{0x7012,0x0078,0x02},    // G0_KNOT_G9 :
{0x7014,0x0057,0x02},    // G0_KNOT_G10 :
{0x7016,0x0090,0x02},    // G0_KNOT_G11 :
{0x7018,0x00BB,0x02},    // G0_KNOT_G12 :
{0x701A,0x00D6,0x02},    // G0_KNOT_G13 :
{0x701C,0x00E5,0x02},    // G0_KNOT_G14 :
{0x701E,0x00F0,0x02},    // G0_KNOT_G15 :
{0x7020,0x00F9,0x02},    // G0_KNOT_G16 :
{0x7022,0x0103,0x02},    // G0_KNOT_G17 :
{0x7024,0x010C,0x02},    // G0_KNOT_G18 :
{0x7026,0x00,0x01},    // G0_KNOT_R0_OFFSET :
{0x7027,0x00,0x01},    // G0_KNOT_R2_OFFSET :
{0x7028,0x00,0x01},    // G0_KNOT_R4_OFFSET :
{0x7029,0x00,0x01},    // G0_KNOT_R6_OFFSET :
{0x702A,0x00,0x01},    // G0_KNOT_R8_OFFSET :
{0x702B,0x00,0x01},    // G0_KNOT_R10_OFFSET :
{0x702C,0x00,0x01},    // G0_KNOT_R12_OFFSET :
{0x702D,0x00,0x01},    // G0_KNOT_R14_OFFSET :
{0x702E,0x00,0x01},    // G0_KNOT_R16_OFFSET :
{0x702F,0x00,0x01},    // G0_KNOT_R18_OFFSET :
{0x7030,0x00,0x01},    // G0_KNOT_B0_OFFSET :
{0x7031,0x00,0x01},    // G0_KNOT_B2_OFFSET :
{0x7032,0x00,0x01},    // G0_KNOT_B4_OFFSET :
{0x7033,0x00,0x01},    // G0_KNOT_B6_OFFSET :
{0x7034,0x00,0x01},    // G0_KNOT_B8_OFFSET :
{0x7035,0x00,0x01},    // G0_KNOT_B10_OFFSET :
{0x7036,0x00,0x01},    // G0_KNOT_B12_OFFSET :
{0x7037,0x00,0x01},    // G0_KNOT_B14_OFFSET :
{0x7038,0x00,0x01},    // G0_KNOT_B16_OFFSET :
{0x7039,0x00,0x01},    // G0_KNOT_B18_OFFSET :
{0x703A,0x0611,0x02},    // G0_LOWGM_ON_R :
{0x703C,0x1E0A,0x02},    // G0_0CLIP_R :
{0x703E,0x0611,0x02},    // G0_LOWGM_ON_G :
{0x7040,0x1E0A,0x02},    // G0_0CLIP_G :
{0x7042,0x0611,0x02},    // G0_LOWGM_ON_B :
{0x7044,0x1E0A,0x02},    // G0_0CLIP_B :
{0x7046,0x9C,0x01},    // G0_KNOT_GAINCTRL_TH_L :
{0x7047,0xA1,0x01},    // G0_KNOT_GAINCTRL_TH_H :
{0x7048,0x0000,0x02},    // G0_KNOT_L_G0 :
{0x704A,0x0007,0x02},    // G0_KNOT_L_G1 :
{0x704C,0x0016,0x02},    // G0_KNOT_L_G2 :
{0x704E,0x002A,0x02},    // G0_KNOT_L_G3 :
{0x7050,0x0039,0x02},    // G0_KNOT_L_G4 :
{0x7052,0x004A,0x02},    // G0_KNOT_L_G5 :
{0x7054,0x0051,0x02},    // G0_KNOT_L_G6 :
{0x7056,0x005D,0x02},    // G0_KNOT_L_G7 :
{0x7058,0x0065,0x02},    // G0_KNOT_L_G8 :
{0x705A,0x006C,0x02},    // G0_KNOT_L_G9 :
{0x705C,0x004E,0x02},    // G0_KNOT_L_G10 :
{0x705E,0x0083,0x02},    // G0_KNOT_L_G11 :
{0x7060,0x00AA,0x02},    // G0_KNOT_L_G12 :
{0x7062,0x00C8,0x02},    // G0_KNOT_L_G13 :
{0x7064,0x00E1,0x02},    // G0_KNOT_L_G14 :
{0x7066,0x00F5,0x02},    // G0_KNOT_L_G15 :
{0x7068,0x0100,0x02},    // G0_KNOT_L_G16 :
{0x706A,0x0106,0x02},    // G0_KNOT_L_G17 :
{0x706C,0x010C,0x02},    // G0_KNOT_L_G18 :

//Gammma Table 1
{0x7200,0x0000,0x02},    // G1_KNOT_G0 :
{0x7202,0x0008,0x02},    // G1_KNOT_G1 :
{0x7204,0x0020,0x02},    // G1_KNOT_G2 :
{0x7206,0x0037,0x02},    // G1_KNOT_G3 :
{0x7208,0x004D,0x02},    // G1_KNOT_G4 :
{0x720A,0x0064,0x02},    // G1_KNOT_G5 :
{0x720C,0x006E,0x02},    // G1_KNOT_G6 :
{0x720E,0x0072,0x02},    // G1_KNOT_G7 :
{0x7210,0x007A,0x02},    // G1_KNOT_G8 :
{0x7212,0x007E,0x02},    // G1_KNOT_G9 :
{0x7214,0x0064,0x02},    // G1_KNOT_G10 :
{0x7216,0x0093,0x02},    // G1_KNOT_G11 :
{0x7218,0x00B7,0x02},    // G1_KNOT_G12 :
{0x721A,0x00CD,0x02},    // G1_KNOT_G13 :
{0x721C,0x00DD,0x02},    // G1_KNOT_G14 :
{0x721E,0x00ED,0x02},    // G1_KNOT_G15 :
{0x7220,0x00F9,0x02},    // G1_KNOT_G16 :
{0x7222,0x0102,0x02},    // G1_KNOT_G17 :
{0x7224,0x0101,0x02},    // G1_KNOT_G18 :
{0x7226,0x00,0x01},    // G1_KNOT_R0_OFFSET :
{0x7227,0x00,0x01},    // G1_KNOT_R2_OFFSET :
{0x7228,0x00,0x01},    // G1_KNOT_R4_OFFSET :
{0x7229,0x00,0x01},    // G1_KNOT_R6_OFFSET :
{0x722A,0x00,0x01},    // G1_KNOT_R8_OFFSET :
{0x722B,0x00,0x01},    // G1_KNOT_R10_OFFSET :
{0x722C,0x00,0x01},    // G1_KNOT_R12_OFFSET :
{0x722D,0x00,0x01},    // G1_KNOT_R14_OFFSET :
{0x722E,0x00,0x01},    // G1_KNOT_R16_OFFSET :
{0x722F,0x00,0x01},    // G1_KNOT_R18_OFFSET :
{0x7230,0x00,0x01},    // G1_KNOT_B0_OFFSET :
{0x7231,0x00,0x01},    // G1_KNOT_B2_OFFSET :
{0x7232,0x00,0x01},    // G1_KNOT_B4_OFFSET :
{0x7233,0x00,0x01},    // G1_KNOT_B6_OFFSET :
{0x7234,0x00,0x01},    // G1_KNOT_B8_OFFSET :
{0x7235,0x00,0x01},    // G1_KNOT_B10_OFFSET :
{0x7236,0x00,0x01},    // G1_KNOT_B12_OFFSET :
{0x7237,0x00,0x01},    // G1_KNOT_B14_OFFSET :
{0x7238,0x00,0x01},    // G1_KNOT_B16_OFFSET :
{0x7239,0x00,0x01},    // G1_KNOT_B18_OFFSET :
{0x723A,0x0321,0x02},    // G1_LOWGM_ON_R :
{0x723C,0x0C00,0x02},    // G1_0CLIP_R :
{0x723E,0x0321,0x02},    // G1_LOWGM_ON_G :
{0x7240,0x0C00,0x02},    // G1_0CLIP_G :
{0x7242,0x0321,0x02},    // G1_LOWGM_ON_B :
{0x7244,0x0C00,0x02},    // G1_0CLIP_B :


//Gammma Table 2
{0x7400,0x0000,0x02},    // G2_KNOT_G0 :
{0x7402,0x000A,0x02},    // G2_KNOT_G1 :
{0x7404,0x0023,0x02},    // G2_KNOT_G2 :
{0x7406,0x0038,0x02},    // G2_KNOT_G3 :
{0x7408,0x003F,0x02},    // G2_KNOT_G4 :
{0x740A,0x0047,0x02},    // G2_KNOT_G5 :
{0x740C,0x004F,0x02},    // G2_KNOT_G6 :
{0x740E,0x0058,0x02},    // G2_KNOT_G7 :
{0x7410,0x005F,0x02},    // G2_KNOT_G8 :
{0x7412,0x0068,0x02},    // G2_KNOT_G9 :
{0x7414,0x0044,0x02},    // G2_KNOT_G10 :
{0x7416,0x0083,0x02},    // G2_KNOT_G11 :
{0x7418,0x00B6,0x02},    // G2_KNOT_G12 :
{0x741A,0x00D1,0x02},    // G2_KNOT_G13 :
{0x741C,0x00E4,0x02},    // G2_KNOT_G14 :
{0x741E,0x00F0,0x02},    // G2_KNOT_G15 :
{0x7420,0x00F9,0x02},    // G2_KNOT_G16 :
{0x7422,0x0103,0x02},    // G2_KNOT_G17 :
{0x7424,0x010C,0x02},    // G2_KNOT_G18 :
{0x7426,0x00,0x01},    // G2_KNOT_R0_OFFSET :
{0x7427,0x00,0x01},    // G2_KNOT_R2_OFFSET :
{0x7428,0x00,0x01},    // G2_KNOT_R4_OFFSET :
{0x7429,0x00,0x01},    // G2_KNOT_R6_OFFSET :
{0x742A,0x00,0x01},    // G2_KNOT_R8_OFFSET :
{0x742B,0x00,0x01},    // G2_KNOT_R10_OFFSET :
{0x742C,0x00,0x01},    // G2_KNOT_R12_OFFSET :
{0x742D,0x00,0x01},    // G2_KNOT_R14_OFFSET :
{0x742E,0x00,0x01},    // G2_KNOT_R16_OFFSET :
{0x742F,0x00,0x01},    // G2_KNOT_R18_OFFSET :
{0x7430,0x00,0x01},    // G2_KNOT_B0_OFFSET :
{0x7431,0x00,0x01},    // G2_KNOT_B2_OFFSET :
{0x7432,0x00,0x01},    // G2_KNOT_B4_OFFSET :
{0x7433,0x00,0x01},    // G2_KNOT_B6_OFFSET :
{0x7434,0x00,0x01},    // G2_KNOT_B8_OFFSET :
{0x7435,0x00,0x01},    // G2_KNOT_B10_OFFSET :
{0x7436,0x00,0x01},    // G2_KNOT_B12_OFFSET :
{0x7437,0x00,0x01},    // G2_KNOT_B14_OFFSET :
{0x7438,0x00,0x01},    // G2_KNOT_B16_OFFSET :
{0x7439,0x00,0x01},    // G2_KNOT_B18_OFFSET :
{0x743A,0x0611,0x02},    // G2_LOWGM_ON_R :
{0x743C,0x1E0A,0x02},    // G2_0CLIP_R :
{0x743E,0x0611,0x02},    // G2_LOWGM_ON_G :
{0x7440,0x1E0A,0x02},    // G2_0CLIP_G :
{0x7442,0x0611,0x02},    // G2_LOWGM_ON_B :
{0x7444,0x1E0A,0x02},    // G2_0CLIP_B :


//AWB tuning
{0x64A4,0xFF,0x01},    // OUTFRM_LEFT00 :
{0x64A5,0xFF,0x01},    // OUTFRM_LEFT01 :
{0x64A6,0xFF,0x01},    // OUTFRM_LEFT02 :
{0x64A7,0xFF,0x01},    // OUTFRM_LEFT03 :
{0x64A8,0xFF,0x01},    // OUTFRM_LEFT04 :
{0x64A9,0xFF,0x01},    // OUTFRM_LEFT05 :
{0x64AA,0xFF,0x01},    // OUTFRM_LEFT06 :
{0x64AB,0xFF,0x01},    // OUTFRM_LEFT07 :
{0x64AC,0xFF,0x01},    // OUTFRM_LEFT08 :
{0x64AD,0xFD,0x01},    // OUTFRM_LEFT09 :
{0x64AE,0xCB,0x01},    // OUTFRM_LEFT10 :
{0x64AF,0xA9,0x01},    // OUTFRM_LEFT11 :
{0x64B0,0x90,0x01},    // OUTFRM_LEFT12 :
{0x64B1,0x7D,0x01},    // OUTFRM_LEFT13 :
{0x64B2,0x70,0x01},    // OUTFRM_LEFT14 :
{0x64B3,0x65,0x01},    // OUTFRM_LEFT15 :
{0x64B4,0x5C,0x01},    // OUTFRM_LEFT16 :
{0x64B5,0x55,0x01},    // OUTFRM_LEFT17 :
{0x64B6,0x4F,0x01},    // OUTFRM_LEFT18 :
{0x64B7,0x32,0x01},    // OUTFRM_LEFT19 :
{0x64B8,0x4D,0x01},    // OUTFRM_LEFT20 :
{0x64B9,0x40,0x01},    // OUTFRM_LEFT21 :
{0x64BA,0x2D,0x01},    // OUTFRM_LEFT22 :
{0x64BB,0x2B,0x01},    // OUTFRM_LEFT23 :
{0x64BC,0x29,0x01},    // OUTFRM_LEFT24 :
{0x64BD,0x27,0x01},    // OUTFRM_LEFT25 :
{0x64BE,0x25,0x01},    // OUTFRM_LEFT26 :
{0x64BF,0x23,0x01},    // OUTFRM_LEFT27 :
{0x64C0,0x21,0x01},    // OUTFRM_LEFT28 :
{0x64C1,0x1F,0x01},    // OUTFRM_LEFT29 :
{0x64C2,0x1D,0x01},    // OUTFRM_LEFT30 :
{0x64C3,0x1B,0x01},    // OUTFRM_LEFT31 :
{0x64C4,0x1A,0x01},    // OUTFRM_LEFT32 :
{0x64C5,0x1A,0x01},    // OUTFRM_LEFT33 :
{0x64C6,0x1A,0x01},    // OUTFRM_LEFT34 :
{0x64C7,0x28,0x01},    // OUTFRM_LEFT35 :
{0x64C8,0x27,0x01},    // OUTFRM_LEFT36 :
{0x64C9,0x26,0x01},    // OUTFRM_LEFT37 :
{0x64CA,0xFF,0x01},    // OUTFRM_RIGHT00 :
{0x64CB,0xFF,0x01},    // OUTFRM_RIGHT01 :
{0x64CC,0xFF,0x01},    // OUTFRM_RIGHT02 :
{0x64CD,0xFF,0x01},    // OUTFRM_RIGHT03 :
{0x64CE,0xFF,0x01},    // OUTFRM_RIGHT04 :
{0x64CF,0xFF,0x01},    // OUTFRM_RIGHT05 :
{0x64D0,0xFF,0x01},    // OUTFRM_RIGHT06 :
{0x64D1,0xFF,0x01},    // OUTFRM_RIGHT07 :
{0x64D2,0xFF,0x01},    // OUTFRM_RIGHT08 :
{0x64D3,0xFF,0x01},    // OUTFRM_RIGHT09 :
{0x64D4,0xD3,0x01},    // OUTFRM_RIGHT10 :
{0x64D5,0xB1,0x01},    // OUTFRM_RIGHT11 :
{0x64D6,0x98,0x01},    // OUTFRM_RIGHT12 :
{0x64D7,0x85,0x01},    // OUTFRM_RIGHT13 :
{0x64D8,0x78,0x01},    // OUTFRM_RIGHT14 :
{0x64D9,0x6D,0x01},    // OUTFRM_RIGHT15 :
{0x64DA,0x64,0x01},    // OUTFRM_RIGHT16 :
{0x64DB,0x5D,0x01},    // OUTFRM_RIGHT17 :
{0x64DC,0x57,0x01},    // OUTFRM_RIGHT18 :
{0x64DD,0x63,0x01},    // OUTFRM_RIGHT19 :
{0x64DE,0x5E,0x01},    // OUTFRM_RIGHT20 :
{0x64DF,0x5A,0x01},    // OUTFRM_RIGHT21 :
{0x64E0,0x56,0x01},    // OUTFRM_RIGHT22 :
{0x64E1,0x52,0x01},    // OUTFRM_RIGHT23 :
{0x64E2,0x50,0x01},    // OUTFRM_RIGHT24 :
{0x64E3,0x4E,0x01},    // OUTFRM_RIGHT25 :
{0x64E4,0x4C,0x01},    // OUTFRM_RIGHT26 :
{0x64E5,0x4A,0x01},    // OUTFRM_RIGHT27 :
{0x64E6,0x48,0x01},    // OUTFRM_RIGHT28 :
{0x64E7,0x46,0x01},    // OUTFRM_RIGHT29 :
{0x64E8,0x44,0x01},    // OUTFRM_RIGHT30 :
{0x64E9,0x43,0x01},    // OUTFRM_RIGHT31 :
{0x64EA,0x42,0x01},    // OUTFRM_RIGHT32 :
{0x64EB,0x42,0x01},    // OUTFRM_RIGHT33 :
{0x64EC,0x42,0x01},    // OUTFRM_RIGHT34 :
{0x64ED,0x30,0x01},    // OUTFRM_RIGHT35 :
{0x64EE,0x2F,0x01},    // OUTFRM_RIGHT36 :
{0x64EF,0x2E,0x01},    // OUTFRM_RIGHT37 :
{0x64F0,0x2163,0x02},    // OUTFRM_TOP :
{0x64F2,0x1400,0x02},    // OUTFRM_BOTM :
{0x64F4,0x19,0x01},    // OUTFRM_FLTOP :
{0x64F5,0x14,0x01},    // OUTFRM_FLBOTM :
{0x64F6,0xFF,0x01},    // OUTAIM_LEFT00 :
{0x64F7,0xFF,0x01},    // OUTAIM_LEFT01 :
{0x64F8,0xFF,0x01},    // OUTAIM_LEFT02 :
{0x64F9,0xFF,0x01},    // OUTAIM_LEFT03 :
{0x64FA,0xFF,0x01},    // OUTAIM_LEFT04 :
{0x64FB,0xFF,0x01},    // OUTAIM_LEFT05 :
{0x64FC,0xFF,0x01},    // OUTAIM_LEFT06 :
{0x64FD,0xFF,0x01},    // OUTAIM_LEFT07 :
{0x64FE,0xFF,0x01},    // OUTAIM_LEFT08 :
{0x64FF,0xFF,0x01},    // OUTAIM_LEFT09 :
{0x6500,0x91,0x01},    // OUTAIM_LEFT10 :
{0x6501,0x91,0x01},    // OUTAIM_LEFT11 :
{0x6502,0x91,0x01},    // OUTAIM_LEFT12 :
{0x6503,0x66,0x01},    // OUTAIM_LEFT13 :
{0x6504,0x5D,0x01},    // OUTAIM_LEFT14 :
{0x6505,0x3C,0x01},    // OUTAIM_LEFT15 :
{0x6506,0x3C,0x01},    // OUTAIM_LEFT16 :
{0x6507,0x3C,0x01},    // OUTAIM_LEFT17 :
{0x6508,0x3A,0x01},    // OUTAIM_LEFT18 :
{0x6509,0x39,0x01},    // OUTAIM_LEFT19 :
{0x650A,0x40,0x01},    // OUTAIM_LEFT20 :
{0x650B,0x46,0x01},    // OUTAIM_LEFT21 :
{0x650C,0x42,0x01},    // OUTAIM_LEFT22 :
{0x650D,0x3D,0x01},    // OUTAIM_LEFT23 :
{0x650E,0x3A,0x01},    // OUTAIM_LEFT24 :
{0x650F,0x3E,0x01},    // OUTAIM_LEFT25 :
{0x6510,0x38,0x01},    // OUTAIM_LEFT26 :
{0x6511,0x36,0x01},    // OUTAIM_LEFT27 :
{0x6512,0x34,0x01},    // OUTAIM_LEFT28 :
{0x6513,0x32,0x01},    // OUTAIM_LEFT29 :
{0x6514,0x30,0x01},    // OUTAIM_LEFT30 :
{0x6515,0x2F,0x01},    // OUTAIM_LEFT31 :
{0x6516,0x2D,0x01},    // OUTAIM_LEFT32 :
{0x6517,0x2C,0x01},    // OUTAIM_LEFT33 :
{0x6518,0x2B,0x01},    // OUTAIM_LEFT34 :
{0x6519,0x2A,0x01},    // OUTAIM_LEFT35 :
{0x651A,0x29,0x01},    // OUTAIM_LEFT36 :
{0x651B,0x28,0x01},    // OUTAIM_LEFT37 :
{0x651C,0xFF,0x01},    // OUTAIM_RIGHT00 :
{0x651D,0xFF,0x01},    // OUTAIM_RIGHT01 :
{0x651E,0xFF,0x01},    // OUTAIM_RIGHT02 :
{0x651F,0xFF,0x01},    // OUTAIM_RIGHT03 :
{0x6520,0xFF,0x01},    // OUTAIM_RIGHT04 :
{0x6521,0xFF,0x01},    // OUTAIM_RIGHT05 :
{0x6522,0xFF,0x01},    // OUTAIM_RIGHT06 :
{0x6523,0xFF,0x01},    // OUTAIM_RIGHT07 :
{0x6524,0xFF,0x01},    // OUTAIM_RIGHT08 :
{0x6525,0xFF,0x01},    // OUTAIM_RIGHT09 :
{0x6526,0xD9,0x01},    // OUTAIM_RIGHT10 :
{0x6527,0xB7,0x01},    // OUTAIM_RIGHT11 :
{0x6528,0x96,0x01},    // OUTAIM_RIGHT12 :
{0x6529,0x6C,0x01},    // OUTAIM_RIGHT13 :
{0x652A,0x64,0x01},    // OUTAIM_RIGHT14 :
{0x652B,0x62,0x01},    // OUTAIM_RIGHT15 :
{0x652C,0x62,0x01},    // OUTAIM_RIGHT16 :
{0x652D,0x61,0x01},    // OUTAIM_RIGHT17 :
{0x652E,0x60,0x01},    // OUTAIM_RIGHT18 :
{0x652F,0x5E,0x01},    // OUTAIM_RIGHT19 :
{0x6530,0x5B,0x01},    // OUTAIM_RIGHT20 :
{0x6531,0x4F,0x01},    // OUTAIM_RIGHT21 :
{0x6532,0x48,0x01},    // OUTAIM_RIGHT22 :
{0x6533,0x43,0x01},    // OUTAIM_RIGHT23 :
{0x6534,0x41,0x01},    // OUTAIM_RIGHT24 :
{0x6535,0x40,0x01},    // OUTAIM_RIGHT25 :
{0x6536,0x3D,0x01},    // OUTAIM_RIGHT26 :
{0x6537,0x3B,0x01},    // OUTAIM_RIGHT27 :
{0x6538,0x39,0x01},    // OUTAIM_RIGHT28 :
{0x6539,0x37,0x01},    // OUTAIM_RIGHT29 :
{0x653A,0x36,0x01},    // OUTAIM_RIGHT30 :
{0x653B,0x35,0x01},    // OUTAIM_RIGHT31 :
{0x653C,0x33,0x01},    // OUTAIM_RIGHT32 :
{0x653D,0x32,0x01},    // OUTAIM_RIGHT33 :
{0x653E,0x31,0x01},    // OUTAIM_RIGHT34 :
{0x653F,0x30,0x01},    // OUTAIM_RIGHT35 :
{0x6540,0x2F,0x01},    // OUTAIM_RIGHT36 :
{0x6541,0x2E,0x01},    // OUTAIM_RIGHT37 :
{0x6542,0x1F40,0x02},    // OUTAIM_TOP :
{0x6544,0x1752,0x02},    // OUTAIM_BOTM :
{0x6546,0x19,0x01},    // OUTAIM_FLTOP :
{0x6547,0x17,0x01},    // OUTAIM_FLBOTM :

{0x657A,0x82,0x01},    // IN_CTMP_FRM_BG0 :
{0x657B,0x78,0x01},    // IN_CTMP_FRM_BG1 :
{0x657C,0x65,0x01},    // IN_CTMP_FRM_BG2 :
{0x657D,0x5B,0x01},    // IN_CTMP_FRM_BG3 :
{0x657E,0x55,0x01},    // IN_CTMP_FRM_BG4 :
{0x657F,0x4F,0x01},    // IN_CTMP_FRM_BG5 :
{0x6580,0x49,0x01},    // IN_CTMP_FRM_BG6 :
{0x6581,0x43,0x01},    // IN_CTMP_FRM_BG7 :
{0x6582,0x3E,0x01},    // IN_CTMP_FRM_BG8 :
{0x6583,0x35,0x01},    // IN_CTMP_FRM_BG9 :
{0x6584,0x30,0x01},    // IN_CTMP_FRM_BG10 :
{0x6585,0x23,0x01},    // IN_CTMP_FRM_RG0 :
{0x6586,0x33,0x01},    // IN_CTMP_FRM_RG1 :
{0x6587,0x3F,0x01},    // IN_CTMP_FRM_RG2 :
{0x6588,0x53,0x01},    // IN_CTMP_FRM_RG3 :
{0x6589,0x63,0x01},    // IN_CTMP_FRM_RG4 :
{0x658A,0x76,0x01},    // IN_CTMP_FRM_RG5 :
{0x658B,0x9A,0x01},    // IN_CTMP_FRM_RG6 :
{0x658C,0x00,0x01},    // IN_CTMP_WEIGHT00_01 :
{0x658D,0x00,0x01},    // IN_CTMP_WEIGHT02_03 :
{0x658E,0x00,0x01},    // IN_CTMP_WEIGHT04_05 :
{0x658F,0x00,0x01},    // IN_CTMP_WEIGHT06_07 :
{0x6590,0x00,0x01},    // IN_CTMP_WEIGHT08_09 :
{0x6591,0x00,0x01},    // IN_CTMP_WEIGHT10_11 :
{0x6592,0x00,0x01},    // IN_CTMP_WEIGHT12_13 :
{0x6593,0x00,0x01},    // IN_CTMP_WEIGHT14_15 :
{0x6594,0x00,0x01},    // IN_CTMP_WEIGHT16_17 :
{0x6595,0x00,0x01},    // IN_CTMP_WEIGHT18_19 :
{0x6596,0x00,0x01},    // IN_CTMP_WEIGHT20_21 :
{0x6597,0x00,0x01},    // IN_CTMP_WEIGHT22_23 :
{0x6598,0x00,0x01},    // IN_CTMP_WEIGHT24_25 :
{0x6599,0x00,0x01},    // IN_CTMP_WEIGHT26_27 :
{0x659A,0x00,0x01},    // IN_CTMP_WEIGHT28_29 :
{0x659B,0x00,0x01},    // IN_CTMP_WEIGHT30_31 :
{0x659C,0x00,0x01},    // IN_CTMP_WEIGHT32_33 :
{0x659D,0x00,0x01},    // IN_CTMP_WEIGHT34_35 :
{0x659E,0x00,0x01},    // IN_CTMP_WEIGHT36_37 :
{0x659F,0x00,0x01},    // IN_CTMP_WEIGHT38_39 :
{0x65A0,0x00,0x01},    // IN_CTMP_WEIGHT40_41 :
{0x65A1,0x00,0x01},    // IN_CTMP_WEIGHT42_43 :
{0x65A2,0x00,0x01},    // IN_CTMP_WEIGHT44_45 :
{0x65A3,0x00,0x01},    // IN_CTMP_WEIGHT46_47 :
{0x65A4,0x00,0x01},    // IN_CTMP_WEIGHT48_49 :
{0x65A5,0x00,0x01},    // IN_CTMP_WEIGHT50_51 :
{0x65A6,0x00,0x01},    // IN_CTMP_WEIGHT52_53 :
{0x65A7,0x00,0x01},    // IN_CTMP_WEIGHT54_55 :
{0x65A8,0x00,0x01},    // IN_CTMP_WEIGHT56_57 :
{0x65A9,0x10,0x01},    // IN_CTMP_WEIGHT58_59 :

{0x65AA,0x78,0x01},    // OUT_CTMP_FRM_BG0 :
{0x65AB,0x74,0x01},    // OUT_CTMP_FRM_BG1 :
{0x65AC,0x70,0x01},    // OUT_CTMP_FRM_BG2 :
{0x65AD,0x6D,0x01},    // OUT_CTMP_FRM_BG3 :
{0x65AE,0x69,0x01},    // OUT_CTMP_FRM_BG4 :
{0x65AF,0x66,0x01},    // OUT_CTMP_FRM_BG5 :
{0x65B0,0x61,0x01},    // OUT_CTMP_FRM_BG6 :
{0x65B1,0x5D,0x01},    // OUT_CTMP_FRM_BG7 :
{0x65B2,0x52,0x01},    // OUT_CTMP_FRM_BG8 :
{0x65B3,0x4B,0x01},    // OUT_CTMP_FRM_BG9 :
{0x65B4,0x44,0x01},    // OUT_CTMP_FRM_BG10 :
{0x65B5,0x19,0x01},    // OUT_CTMP_FRM_RG0 :
{0x65B6,0x27,0x01},    // OUT_CTMP_FRM_RG1 :
{0x65B7,0x32,0x01},    // OUT_CTMP_FRM_RG2 :
{0x65B8,0x3A,0x01},    // OUT_CTMP_FRM_RG3 :
{0x65B9,0x43,0x01},    // OUT_CTMP_FRM_RG4 :
{0x65BA,0x4A,0x01},    // OUT_CTMP_FRM_RG5 :
{0x65BB,0x5E,0x01},    // OUT_CTMP_FRM_RG6 :
{0x65BC,0x00,0x01},    // OUT_CTMP_WEIGHT00_01 :
{0x65BD,0x00,0x01},    // OUT_CTMP_WEIGHT02_03 :
{0x65BE,0x00,0x01},    // OUT_CTMP_WEIGHT04_05 :
{0x65BF,0x00,0x01},    // OUT_CTMP_WEIGHT06_07 :
{0x65C0,0x33,0x01},    // OUT_CTMP_WEIGHT08_09 :
{0x65C1,0x00,0x01},    // OUT_CTMP_WEIGHT10_11 :
{0x65C2,0x30,0x01},    // OUT_CTMP_WEIGHT12_13 :
{0x65C3,0x33,0x01},    // OUT_CTMP_WEIGHT14_15 :
{0x65C4,0x00,0x01},    // OUT_CTMP_WEIGHT16_17 :
{0x65C5,0x30,0x01},    // OUT_CTMP_WEIGHT18_19 :
{0x65C6,0x33,0x01},    // OUT_CTMP_WEIGHT20_21 :
{0x65C7,0x00,0x01},    // OUT_CTMP_WEIGHT22_23 :
{0x65C8,0x30,0x01},    // OUT_CTMP_WEIGHT24_25 :
{0x65C9,0x33,0x01},    // OUT_CTMP_WEIGHT26_27 :
{0x65CA,0x00,0x01},    // OUT_CTMP_WEIGHT28_29 :
{0x65CB,0x30,0x01},    // OUT_CTMP_WEIGHT30_31 :
{0x65CC,0x44,0x01},    // OUT_CTMP_WEIGHT32_33 :
{0x65CD,0x00,0x01},    // OUT_CTMP_WEIGHT34_35 :
{0x65CE,0x40,0x01},    // OUT_CTMP_WEIGHT36_37 :
{0x65CF,0x55,0x01},    // OUT_CTMP_WEIGHT38_39 :
{0x65D0,0x05,0x01},    // OUT_CTMP_WEIGHT40_41 :
{0x65D1,0x20,0x01},    // OUT_CTMP_WEIGHT42_43 :
{0x65D2,0x72,0x01},    // OUT_CTMP_WEIGHT44_45 :
{0x65D3,0x07,0x01},    // OUT_CTMP_WEIGHT46_47 :
{0x65D4,0x00,0x01},    // OUT_CTMP_WEIGHT48_49 :
{0x65D5,0x00,0x01},    // OUT_CTMP_WEIGHT50_51 :
{0x65D6,0x00,0x01},    // OUT_CTMP_WEIGHT52_53 :
{0x65D7,0x00,0x01},    // OUT_CTMP_WEIGHT54_55 :
{0x65D8,0x00,0x01},    // OUT_CTMP_WEIGHT56_57 :
{0x65D9,0x00,0x01},    // OUT_CTMP_WEIGHT58_59 :

{0x6400,0xAA,0x01},    // INFRM_LEFT00 :
{0x6401,0xAA,0x01},    // INFRM_LEFT01 :
{0x6402,0xAA,0x01},    // INFRM_LEFT02 :
{0x6403,0xAA,0x01},    // INFRM_LEFT03 :
{0x6404,0xAA,0x01},    // INFRM_LEFT04 :
{0x6405,0xAA,0x01},    // INFRM_LEFT05 :
{0x6406,0xAA,0x01},    // INFRM_LEFT06 :
{0x6407,0xAA,0x01},    // INFRM_LEFT07 :
{0x6408,0xAA,0x01},    // INFRM_LEFT08 :
{0x6409,0xAE,0x01},    // INFRM_LEFT09 :
{0x640A,0xA0,0x01},    // INFRM_LEFT10 :
{0x640B,0x8C,0x01},    // INFRM_LEFT11 :
{0x640C,0x72,0x01},    // INFRM_LEFT12 :
{0x640D,0x64,0x01},    // INFRM_LEFT13 :
{0x640E,0x5A,0x01},    // INFRM_LEFT14 :
{0x640F,0x52,0x01},    // INFRM_LEFT15 :
{0x6410,0x48,0x01},    // INFRM_LEFT16 :
{0x6411,0x43,0x01},    // INFRM_LEFT17 :
{0x6412,0x3D,0x01},    // INFRM_LEFT18 :
{0x6413,0x37,0x01},    // INFRM_LEFT19 :
{0x6414,0x33,0x01},    // INFRM_LEFT20 :
{0x6415,0x30,0x01},    // INFRM_LEFT21 :
{0x6416,0x2E,0x01},    // INFRM_LEFT22 :
{0x6417,0x2B,0x01},    // INFRM_LEFT23 :
{0x6418,0x28,0x01},    // INFRM_LEFT24 :
{0x6419,0x26,0x01},    // INFRM_LEFT25 :
{0x641A,0x24,0x01},    // INFRM_LEFT26 :
{0x641B,0x23,0x01},    // INFRM_LEFT27 :
{0x641C,0x22,0x01},    // INFRM_LEFT28 :
{0x641D,0x22,0x01},    // INFRM_LEFT29 :
{0x641E,0x21,0x01},    // INFRM_LEFT30 :
{0x641F,0x20,0x01},    // INFRM_LEFT31 :
{0x6420,0x1D,0x01},    // INFRM_LEFT32 :
{0x6421,0x1A,0x01},    // INFRM_LEFT33 :
{0x6422,0x18,0x01},    // INFRM_LEFT34 :
{0x6423,0x17,0x01},    // INFRM_LEFT35 :
{0x6424,0x16,0x01},    // INFRM_LEFT36 :
{0x6425,0x17,0x01},    // INFRM_LEFT37 :
{0x6426,0xAF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xAF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xAF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xAF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xAF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xAF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xAF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xAF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xAF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xAA,0x01},    // INFRM_RIGHT09 :
{0x6430,0xB2,0x01},    // INFRM_RIGHT10 :
{0x6431,0xB4,0x01},    // INFRM_RIGHT11 :
{0x6432,0xB6,0x01},    // INFRM_RIGHT12 :
{0x6433,0xB4,0x01},    // INFRM_RIGHT13 :
{0x6434,0x9B,0x01},    // INFRM_RIGHT14 :
{0x6435,0x8E,0x01},    // INFRM_RIGHT15 :
{0x6436,0x84,0x01},    // INFRM_RIGHT16 :
{0x6437,0x7A,0x01},    // INFRM_RIGHT17 :
{0x6438,0x72,0x01},    // INFRM_RIGHT18 :
{0x6439,0x6A,0x01},    // INFRM_RIGHT19 :
{0x643A,0x63,0x01},    // INFRM_RIGHT20 :
{0x643B,0x5E,0x01},    // INFRM_RIGHT21 :
{0x643C,0x58,0x01},    // INFRM_RIGHT22 :
{0x643D,0x53,0x01},    // INFRM_RIGHT23 :
{0x643E,0x4E,0x01},    // INFRM_RIGHT24 :
{0x643F,0x4A,0x01},    // INFRM_RIGHT25 :
{0x6440,0x46,0x01},    // INFRM_RIGHT26 :
{0x6441,0x42,0x01},    // INFRM_RIGHT27 :
{0x6442,0x3F,0x01},    // INFRM_RIGHT28 :
{0x6443,0x3C,0x01},    // INFRM_RIGHT29 :
{0x6444,0x3A,0x01},    // INFRM_RIGHT30 :
{0x6445,0x38,0x01},    // INFRM_RIGHT31 :
{0x6446,0x37,0x01},    // INFRM_RIGHT32 :
{0x6447,0x35,0x01},    // INFRM_RIGHT33 :
{0x6448,0x33,0x01},    // INFRM_RIGHT34 :
{0x6449,0x32,0x01},    // INFRM_RIGHT35 :
{0x644A,0x32,0x01},    // INFRM_RIGHT36 :
{0x644B,0x32,0x01},    // INFRM_RIGHT37 :
{0x644C,0x24FA,0x02},    // INFRM_TOP :
{0x644E,0x0940,0x02},    // INFRM_BOTM :
{0x6450,0x19,0x01},    // INFRM_FLTOP :
{0x6451,0x10,0x01},    // INFRM_FLBOTM :
{0x6452,0x91,0x01},    // INAIM_LEFT00 :
{0x6453,0x91,0x01},    // INAIM_LEFT01 :
{0x6454,0x91,0x01},    // INAIM_LEFT02 :
{0x6455,0x91,0x01},    // INAIM_LEFT03 :
{0x6456,0x91,0x01},    // INAIM_LEFT04 :
{0x6457,0x91,0x01},    // INAIM_LEFT05 :
{0x6458,0x91,0x01},    // INAIM_LEFT06 :
{0x6459,0x91,0x01},    // INAIM_LEFT07 :
{0x645A,0x91,0x01},    // INAIM_LEFT08 :
{0x645B,0x91,0x01},    // INAIM_LEFT09 :
{0x645C,0x91,0x01},    // INAIM_LEFT10 :
{0x645D,0x91,0x01},    // INAIM_LEFT11 :
{0x645E,0x91,0x01},    // INAIM_LEFT12 :
{0x645F,0x66,0x01},    // INAIM_LEFT13 :
{0x6460,0x71,0x01},    // INAIM_LEFT14 :
{0x6461,0x5A,0x01},    // INAIM_LEFT15 :
{0x6462,0x4E,0x01},    // INAIM_LEFT16 :
{0x6463,0x47,0x01},    // INAIM_LEFT17 :
{0x6464,0x42,0x01},    // INAIM_LEFT18 :
{0x6465,0x3C,0x01},    // INAIM_LEFT19 :
{0x6466,0x38,0x01},    // INAIM_LEFT20 :
{0x6467,0x36,0x01},    // INAIM_LEFT21 :
{0x6468,0x33,0x01},    // INAIM_LEFT22 :
{0x6469,0x30,0x01},    // INAIM_LEFT23 :
{0x646A,0x2F,0x01},    // INAIM_LEFT24 :
{0x646B,0x2B,0x01},    // INAIM_LEFT25 :
{0x646C,0x29,0x01},    // INAIM_LEFT26 :
{0x646D,0x27,0x01},    // INAIM_LEFT27 :
{0x646E,0x26,0x01},    // INAIM_LEFT28 :
{0x646F,0x28,0x01},    // INAIM_LEFT29 :
{0x6470,0x2A,0x01},    // INAIM_LEFT30 :
{0x6471,0x28,0x01},    // INAIM_LEFT31 :
{0x6472,0x26,0x01},    // INAIM_LEFT32 :
{0x6473,0x24,0x01},    // INAIM_LEFT33 :
{0x6474,0x29,0x01},    // INAIM_LEFT34 :
{0x6475,0x28,0x01},    // INAIM_LEFT35 :
{0x6476,0x29,0x01},    // INAIM_LEFT36 :
{0x6477,0x26,0x01},    // INAIM_LEFT37 :
{0x6478,0xFF,0x01},    // INAIM_RIGHT00 :
{0x6479,0xFF,0x01},    // INAIM_RIGHT01 :
{0x647A,0xFF,0x01},    // INAIM_RIGHT02 :
{0x647B,0xFF,0x01},    // INAIM_RIGHT03 :
{0x647C,0xFF,0x01},    // INAIM_RIGHT04 :
{0x647D,0xFF,0x01},    // INAIM_RIGHT05 :
{0x647E,0xFF,0x01},    // INAIM_RIGHT06 :
{0x647F,0xFF,0x01},    // INAIM_RIGHT07 :
{0x6480,0xFF,0x01},    // INAIM_RIGHT08 :
{0x6481,0xFF,0x01},    // INAIM_RIGHT09 :
{0x6482,0xD9,0x01},    // INAIM_RIGHT10 :
{0x6483,0xB7,0x01},    // INAIM_RIGHT11 :
{0x6484,0x96,0x01},    // INAIM_RIGHT12 :
{0x6485,0x68,0x01},    // INAIM_RIGHT13 :
{0x6486,0x72,0x01},    // INAIM_RIGHT14 :
{0x6487,0x71,0x01},    // INAIM_RIGHT15 :
{0x6488,0x6E,0x01},    // INAIM_RIGHT16 :
{0x6489,0x6A,0x01},    // INAIM_RIGHT17 :
{0x648A,0x65,0x01},    // INAIM_RIGHT18 :
{0x648B,0x60,0x01},    // INAIM_RIGHT19 :
{0x648C,0x5B,0x01},    // INAIM_RIGHT20 :
{0x648D,0x56,0x01},    // INAIM_RIGHT21 :
{0x648E,0x51,0x01},    // INAIM_RIGHT22 :
{0x648F,0x4C,0x01},    // INAIM_RIGHT23 :
{0x6490,0x47,0x01},    // INAIM_RIGHT24 :
{0x6491,0x44,0x01},    // INAIM_RIGHT25 :
{0x6492,0x41,0x01},    // INAIM_RIGHT26 :
{0x6493,0x3E,0x01},    // INAIM_RIGHT27 :
{0x6494,0x3B,0x01},    // INAIM_RIGHT28 :
{0x6495,0x39,0x01},    // INAIM_RIGHT29 :
{0x6496,0x37,0x01},    // INAIM_RIGHT30 :
{0x6497,0x34,0x01},    // INAIM_RIGHT31 :
{0x6498,0x33,0x01},    // INAIM_RIGHT32 :
{0x6499,0x32,0x01},    // INAIM_RIGHT33 :
{0x649A,0x31,0x01},    // INAIM_RIGHT34 :
{0x649B,0x30,0x01},    // INAIM_RIGHT35 :
{0x649C,0x2F,0x01},    // INAIM_RIGHT36 :
{0x649D,0x2E,0x01},    // INAIM_RIGHT37 :
{0x649E,0x1E00,0x02},    // INAIM_TOP :
{0x64A0,0x0DFF,0x02},    // INAIM_BOTM :
{0x64A2,0x18,0x01},    // INAIM_FLTOP :
{0x64A3,0x09,0x01},    // INAIM_FLBOTM :

//AWB setting
{0x629A,0x13,0x01},    // CAT_AWB_2 : OPDG  off
{0x629B,0x41,0x01},    // CAT_AWB_3 : outdoor_ġ on
{0x625F,0x15,0x01},    // CAT_AWB_1 : MWB userǥ ǥ (AWBÿ  )
{0x629C,0x80,0x01},    // FRMOUT_RATIO_BLEND1_OUT
{0x6224,0x04,0x01},    // ATW_DELAY
{0x6226,0x08,0x01},    // ATW_GAINS_IN_NR :
{0x6227,0x04,0x01},    // ATW_GAINS_IN :
{0x6228,0x08,0x01},    // ATW_GAINS_OUT_NR :
{0x6229,0x04,0x01},    // ATW_GAINS_OUT :

//Bluesky threshold 
{0x6548,0x18F7,0x02},    // OUTAIM_TOP_BLUESKY :

//Hue, Gain setting
{0x6E86,0x0000,0x02},    // IBYHUE1_POS1 :
{0x6E88,0xFFF5,0x02},    // IRYHUE1_POS1 :
{0x6E8A,0xFFF8,0x02},    // IBYHUE2_POS1 :
{0x6E8C,0xFFF5,0x02},    // IRYHUE2_POS1 :
{0x6E8E,0xFFF8,0x02},    // IBYHUE3_POS1 :
{0x6E90,0xFFEE,0x02},    // IRYHUE3_POS1 :
{0x6E92,0x0000,0x02},    // IBYHUE4_POS1 :
{0x6E94,0xFFEC,0x02},    // IRYHUE4_POS1 :
{0x6E96,0x0000,0x02},    // IBYHUE1_POS2 :
{0x6E98,0xFFF5,0x02},    // IRYHUE1_POS2 :
{0x6E9A,0xFFFD,0x02},    // IBYHUE2_POS2 :
{0x6E9C,0xFFF5,0x02},    // IRYHUE2_POS2 :
{0x6E9E,0xFFFD,0x02},    // IBYHUE3_POS2 :
{0x6EA0,0xFFEE,0x02},    // IRYHUE3_POS2 :
{0x6EA2,0x0000,0x02},    // IBYHUE4_POS2 :
{0x6EA4,0xFFEC,0x02},    // IRYHUE4_POS2 :
{0x6EA6,0x0000,0x02},    // IBYHUE1_POS3 :
{0x6EA8,0xFFF5,0x02},    // IRYHUE1_POS3 :
{0x6EAA,0xFFF8,0x02},    // IBYHUE2_POS3 :
{0x6EAC,0xFFF5,0x02},    // IRYHUE2_POS3 :
{0x6EAE,0xFFF8,0x02},    // IBYHUE3_POS3 :
{0x6EB0,0xFFEE,0x02},    // IRYHUE3_POS3 :
{0x6EB2,0x0000,0x02},    // IBYHUE4_POS3 :
{0x6EB4,0xFFEC,0x02},    // IRYHUE4_POS3 :
{0x6EB6,0x0000,0x02},    // IBYHUE1_POS4 :
{0x6EB8,0xFFF5,0x02},    // IRYHUE1_POS4 :
{0x6EBA,0xFFF8,0x02},    // IBYHUE2_POS4 :
{0x6EBC,0xFFF5,0x02},    // IRYHUE2_POS4 :
{0x6EBE,0xFFF8,0x02},    // IBYHUE3_POS4 :
{0x6EC0,0xFFEE,0x02},    // IRYHUE3_POS4 :
{0x6EC2,0x0000,0x02},    // IBYHUE4_POS4 :
{0x6EC4,0xFFEC,0x02},    // IRYHUE4_POS4 :
{0x6EC6,0x0000,0x02},    // IBYHUE1_POS5 :
{0x6EC8,0xFFF5,0x02},    // IRYHUE1_POS5 :
{0x6ECA,0xFFF8,0x02},    // IBYHUE2_POS5 :
{0x6ECC,0xFFF5,0x02},    // IRYHUE2_POS5 :
{0x6ECE,0xFFF8,0x02},    // IBYHUE3_POS5 :
{0x6ED0,0xFFEE,0x02},    // IRYHUE3_POS5 :
{0x6ED2,0x0000,0x02},    // IBYHUE4_POS5 :
{0x6ED4,0xFFEC,0x02},    // IRYHUE4_POS5 :
{0x6ED6,0x0000,0x02},    // IBYHUE1_POS6 :
{0x6ED8,0xFFF5,0x02},    // IRYHUE1_POS6 :
{0x6EDA,0xFFF8,0x02},    // IBYHUE2_POS6 :
{0x6EDC,0xFFF5,0x02},    // IRYHUE2_POS6 :
{0x6EDE,0xFFF8,0x02},    // IBYHUE3_POS6 :
{0x6EE0,0xFFEE,0x02},    // IRYHUE3_POS6 :
{0x6EE2,0x0000,0x02},    // IBYHUE4_POS6 :
{0x6EE4,0xFFEC,0x02},    // IRYHUE4_POS6 :
{0x6EE6,0x0000,0x02},    // IBYHUE1_POS7 :
{0x6EE8,0xFFF5,0x02},    // IRYHUE1_POS7 :
{0x6EEA,0xFFEA,0x02},    // IBYHUE2_POS7 :
{0x6EEC,0xFFF5,0x02},    // IRYHUE2_POS7 :
{0x6EEE,0xFFEA,0x02},    // IBYHUE3_POS7 :
{0x6EF0,0xFFEE,0x02},    // IRYHUE3_POS7 :
{0x6EF2,0x0000,0x02},    // IBYHUE4_POS7 :
{0x6EF4,0xFFEC,0x02},    // IRYHUE4_POS7 :
{0x6EF6,0xFFF2,0x02},    // IBYHUE1_OUT :
{0x6EF8,0x0000,0x02},    // IRYHUE1_OUT :
{0x6EFA,0xFFFA,0x02},    // IBYHUE2_OUT :
{0x6EFC,0x0000,0x02},    // IRYHUE2_OUT :
{0x6EFE,0xFFFA,0x02},    // IBYHUE3_OUT :
{0x6F00,0xFFE7,0x02},    // IRYHUE3_OUT :
{0x6F02,0xFFF2,0x02},    // IBYHUE4_OUT :
{0x6F04,0xFFE7,0x02},    // IRYHUE4_OUT :
{0x6F06,0x0000,0x02},    // IBYHUE1_R2_POS4 :
{0x6F08,0xFFF5,0x02},    // IRYHUE1_R2_POS4 :
{0x6F0A,0xFFF8,0x02},    // IBYHUE2_R2_POS4 :
{0x6F0C,0xFFF5,0x02},    // IRYHUE2_R2_POS4 :
{0x6F0E,0xFFF8,0x02},    // IBYHUE3_R2_POS4 :
{0x6F10,0xFFEE,0x02},    // IRYHUE3_R2_POS4 :
{0x6F12,0x0000,0x02},    // IBYHUE4_R2_POS4 :
{0x6F14,0xFFEC,0x02},    // IRYHUE4_R2_POS4 :
{0x6F16,0x0000,0x02},    // IBYHUE1_R2_POS5 :
{0x6F18,0xFFF5,0x02},    // IRYHUE1_R2_POS5 :
{0x6F1A,0xFFF8,0x02},    // IBYHUE2_R2_POS5 :
{0x6F1C,0xFFF5,0x02},    // IRYHUE2_R2_POS5 :
{0x6F1E,0xFFF8,0x02},    // IBYHUE3_R2_POS5 :
{0x6F20,0xFFEE,0x02},    // IRYHUE3_R2_POS5 :
{0x6F22,0x0000,0x02},    // IBYHUE4_R2_POS5 :
{0x6F24,0xFFEC,0x02},    // IRYHUE4_R2_POS5 :
{0x6F26,0x4B,0x01},    // IRYGAIN1_POS1 :
{0x6F27,0x50,0x01},    // IBYGAIN1_POS1 :
{0x6F28,0x4B,0x01},    // IRYGAIN2_POS1 :
{0x6F29,0x57,0x01},    // IBYGAIN2_POS1 :
{0x6F2A,0x56,0x01},    // IRYGAIN3_POS1 :
{0x6F2B,0x57,0x01},    // IBYGAIN3_POS1 :
{0x6F2C,0x56,0x01},    // IRYGAIN4_POS1 :
{0x6F2D,0x50,0x01},    // IBYGAIN4_POS1 :
{0x6F2E,0x4B,0x01},    // IRYGAIN1_POS2 :
{0x6F2F,0x50,0x01},    // IBYGAIN1_POS2 :
{0x6F30,0x4B,0x01},    // IRYGAIN2_POS2 :
{0x6F31,0x57,0x01},    // IBYGAIN2_POS2 :
{0x6F32,0x54,0x01},    // IRYGAIN3_POS2 :
{0x6F33,0x57,0x01},    // IBYGAIN3_POS2 :
{0x6F34,0x54,0x01},    // IRYGAIN4_POS2 :
{0x6F35,0x50,0x01},    // IBYGAIN4_POS2 :
{0x6F36,0x4B,0x01},    // IRYGAIN1_POS3 :
{0x6F37,0x50,0x01},    // IBYGAIN1_POS3 :
{0x6F38,0x4B,0x01},    // IRYGAIN2_POS3 :
{0x6F39,0x57,0x01},    // IBYGAIN2_POS3 :
{0x6F3A,0x50,0x01},    // IRYGAIN3_POS3 :
{0x6F3B,0x57,0x01},    // IBYGAIN3_POS3 :
{0x6F3C,0x50,0x01},    // IRYGAIN4_POS3 :
{0x6F3D,0x50,0x01},    // IBYGAIN4_POS3 :
{0x6F3E,0x4B,0x01},    // IRYGAIN1_POS4 :
{0x6F3F,0x50,0x01},    // IBYGAIN1_POS4 :
{0x6F40,0x4B,0x01},    // IRYGAIN2_POS4 :
{0x6F41,0x57,0x01},    // IBYGAIN2_POS4 :
{0x6F42,0x50,0x01},    // IRYGAIN3_POS4 :
{0x6F43,0x57,0x01},    // IBYGAIN3_POS4 :
{0x6F44,0x50,0x01},    // IRYGAIN4_POS4 :
{0x6F45,0x50,0x01},    // IBYGAIN4_POS4 :
{0x6F46,0x4B,0x01},    // IRYGAIN1_POS5 :
{0x6F47,0x50,0x01},    // IBYGAIN1_POS5 :
{0x6F48,0x4B,0x01},    // IRYGAIN2_POS5 :
{0x6F49,0x57,0x01},    // IBYGAIN2_POS5 :
{0x6F4A,0x50,0x01},    // IRYGAIN3_POS5 :
{0x6F4B,0x57,0x01},    // IBYGAIN3_POS5 :
{0x6F4C,0x50,0x01},    // IRYGAIN4_POS5 :
{0x6F4D,0x50,0x01},    // IBYGAIN4_POS5 :
{0x6F4E,0x4B,0x01},    // IRYGAIN1_POS6 :
{0x6F4F,0x50,0x01},    // IBYGAIN1_POS6 :
{0x6F50,0x4B,0x01},    // IRYGAIN2_POS6 :
{0x6F51,0x57,0x01},    // IBYGAIN2_POS6 :
{0x6F52,0x50,0x01},    // IRYGAIN3_POS6 :
{0x6F53,0x57,0x01},    // IBYGAIN3_POS6 :
{0x6F54,0x50,0x01},    // IRYGAIN4_POS6 :
{0x6F55,0x50,0x01},    // IBYGAIN4_POS6 :
{0x6F56,0x4B,0x01},    // IRYGAIN1_POS7 :
{0x6F57,0x50,0x01},    // IBYGAIN1_POS7 :
{0x6F58,0x4B,0x01},    // IRYGAIN2_POS7 :
{0x6F59,0x57,0x01},    // IBYGAIN2_POS7 :
{0x6F5A,0x50,0x01},    // IRYGAIN3_POS7 :
{0x6F5B,0x57,0x01},    // IBYGAIN3_POS7 :
{0x6F5C,0x50,0x01},    // IRYGAIN4_POS7 :
{0x6F5D,0x50,0x01},    // IBYGAIN4_POS7 :
{0x6F5E,0x50,0x01},    // IRYGAIN1_OUT :
{0x6F5F,0x5A,0x01},    // IBYGAIN1_OUT :
{0x6F60,0x50,0x01},    // IRYGAIN2_OUT :
{0x6F61,0x51,0x01},    // IBYGAIN2_OUT :
{0x6F62,0x64,0x01},    // IRYGAIN3_OUT :
{0x6F63,0x51,0x01},    // IBYGAIN3_OUT :
{0x6F64,0x64,0x01},    // IRYGAIN4_OUT :
{0x6F65,0x5A,0x01},    // IBYGAIN4_OUT :
{0x6F66,0x4B,0x01},    // IRYGAIN1_R2_POS4 :
{0x6F67,0x50,0x01},    // IBYGAIN1_R2_POS4 :
{0x6F68,0x4B,0x01},    // IRYGAIN2_R2_POS4 :
{0x6F69,0x57,0x01},    // IBYGAIN2_R2_POS4 :
{0x6F6A,0x50,0x01},    // IRYGAIN3_R2_POS4 :
{0x6F6B,0x57,0x01},    // IBYGAIN3_R2_POS4 :
{0x6F6C,0x50,0x01},    // IRYGAIN4_R2_POS4 :
{0x6F6D,0x50,0x01},    // IBYGAIN4_R2_POS4 :
{0x6F6E,0x4B,0x01},    // IRYGAIN1_R2_POS5 :
{0x6F6F,0x50,0x01},    // IBYGAIN1_R2_POS5 :
{0x6F70,0x4B,0x01},    // IRYGAIN2_R2_POS5 :
{0x6F71,0x57,0x01},    // IBYGAIN2_R2_POS5 :
{0x6F72,0x50,0x01},    // IRYGAIN3_R2_POS5 :
{0x6F73,0x57,0x01},    // IBYGAIN3_R2_POS5 :
{0x6F74,0x50,0x01},    // IRYGAIN4_R2_POS5 :
{0x6F75,0x50,0x01},    // IBYGAIN4_R2_POS5 :


//LMT outdoor setting
{0x6E54,0xFFB1,0x02},    // LM_GRG_OUT :
{0x6E56,0x0015,0x02},    // LM_GRB_OUT :
{0x6E58,0xFFE5,0x02},    // LM_GGR_OUT :
{0x6E5A,0xFFFA,0x02},    // LM_GGB_OUT :
{0x6E5C,0xFFDA,0x02},    // LM_GBR_OUT :
{0x6E5E,0xFFE9,0x02},    // LM_GBG_OUT :

//MC3 ON&OFF
{0x6C49,0xF5,0x01},    // MAIN_CONFIG4 :


////////////////////////////////////////////////////////////////

{0x941F,0x00,0x01},    // AP_N_GC_POS_CORE_A : <<N뿪 Coring  ھ  A
{0x9420,0x00,0x01},    // AP_N_GC_POS_CORE_B :
{0x9421,0x02,0x01},    // AP_N_GC_POS_CORE_C1 :
{0x9422,0x01,0x01},    // AP_N_GC_POS_CORE_C2 :
{0x9423,0x20,0x01},    // AP_N_GC_POS_SLOPE_A : <<N뿪 Coring    A
{0x9424,0x0D,0x01},    // AP_N_GC_POS_SLOPE_B :
{0x9425,0x0F,0x01},    // AP_N_GC_POS_SLOPE_C1 :
{0x9426,0x08,0x01},    // AP_N_GC_POS_SLOPE_C2 :
{0x9427,0x00,0x01},    // AP_N_GC_NEG_CORE_A : <<N뿪 Coring ھ A
{0x9428,0x00,0x01},    // AP_N_GC_NEG_CORE_B :
{0x9429,0x02,0x01},    // AP_N_GC_NEG_CORE_C1 :
{0x942A,0x01,0x01},    // AP_N_GC_NEG_CORE_C2 :
{0x942B,0x20,0x01},    // AP_N_GC_NEG_SLOPE_A : <<N뿪 Coring    A
{0x942C,0x13,0x01},    // AP_N_GC_NEG_SLOPE_B :
{0x942D,0x10,0x01},    // AP_N_GC_NEG_SLOPE_C1 :
{0x942E,0x08,0x01},    // AP_N_GC_NEG_SLOPE_C2 :
{0x942F,0x20,0x01},    // AP_N_GAIN_POS_A : <<N뿪 POST Gain  A
{0x9430,0x3C,0x01},    // AP_N_GAIN_POS_B :
{0x9431,0x33,0x01},    // AP_N_GAIN_POS_C1 :
{0x9432,0x30,0x01},    // AP_N_GAIN_POS_C2 :
{0x9433,0x20,0x01},    // AP_N_GAIN_NEG_A : <<N뿪 POST Gain  A
{0x9434,0x48,0x01},    // AP_N_GAIN_NEG_B :
{0x9435,0x37,0x01},    // AP_N_GAIN_NEG_C1 :
{0x9436,0x38,0x01},    // AP_N_GAIN_NEG_C2 :
////////////////////////////////////////////////////////////////

{0x9437,0x01,0x01},    // AP_H_GC_POS_CORE_A : <<H뿪 Coring ھ A
{0x9438,0x01,0x01},    // AP_H_GC_POS_CORE_B :
{0x9439,0x00,0x01},    // AP_H_GC_POS_CORE_C1 :
{0x943A,0x00,0x01},    // AP_H_GC_POS_CORE_C2 :
{0x943B,0x38,0x01},    // AP_H_GC_POS_SLOPE_A : <<H뿪 Coring    A
{0x943C,0x3F,0x01},    // AP_H_GC_POS_SLOPE_B :
{0x943D,0x30,0x01},    // AP_H_GC_POS_SLOPE_C1 :
{0x943E,0x13,0x01},    // AP_H_GC_POS_SLOPE_C2 :
{0x943F,0x00,0x01},    // AP_H_GC_NEG_CORE_A : <<H뿪 Coring ھ A
{0x9440,0x01,0x01},    // AP_H_GC_NEG_CORE_B :
{0x9441,0x00,0x01},    // AP_H_GC_NEG_CORE_C1 :
{0x9442,0x00,0x01},    // AP_H_GC_NEG_CORE_C2 :
{0x9443,0x38,0x01},    // AP_H_GC_NEG_SLOPE_A : <<H뿪 Coring    A
{0x9444,0x09,0x01},    // AP_H_GC_NEG_SLOPE_B :
{0x9445,0x2D,0x01},    // AP_H_GC_NEG_SLOPE_C1 :
{0x9446,0x0A,0x01},    // AP_H_GC_NEG_SLOPE_C2 :
{0x9447,0x50,0x01},    // AP_H_GAIN_POS_A : <<H뿪 POST Gain  A
{0x9448,0x38,0x01},    // AP_H_GAIN_POS_B :
{0x9449,0x72,0x01},    // AP_H_GAIN_POS_C1 :
{0x944A,0x72,0x01},    // AP_H_GAIN_POS_C2 :
{0x944B,0x50,0x01},    // AP_H_GAIN_NEG_A : <<H뿪 POST Gain  A
{0x944C,0x40,0x01},    // AP_H_GAIN_NEG_B :
{0x944D,0x66,0x01},    // AP_H_GAIN_NEG_C1 :
{0x944E,0x96,0x01},    // AP_H_GAIN_NEG_C2 :
{0x944F,0x01,0x01},    // AP_L_GC_POS_CORE_A : <<L뿪 Coring ھ A
{0x9450,0x00,0x01},    // AP_L_GC_POS_CORE_B :
{0x9451,0x00,0x01},    // AP_L_GC_POS_CORE_C1 :
{0x9452,0x04,0x01},    // AP_L_GC_POS_CORE_C2
{0x9453,0x24,0x01},    // AP_L_GC_POS_SLOPE_A : <<L뿪 Coring    A
{0x9454,0x20,0x01},    // AP_L_GC_POS_SLOPE_B :
{0x9455,0x08,0x01},    // AP_L_GC_POS_SLOPE_C1 :
{0x9456,0x08,0x01},    // AP_L_GC_POS_SLOPE_C2 :
{0x9457,0x01,0x01},    // AP_L_GC_NEG_CORE_A : <L뿪 Coring ھ A
{0x9458,0x00,0x01},    // AP_L_GC_NEG_CORE_B :
{0x9459,0x00,0x01},    // AP_L_GC_NEG_CORE_C1
{0x945A,0x04,0x01},    // AP_L_GC_NEG_CORE_C2
{0x945B,0x24,0x01},    // AP_L_GC_NEG_SLOPE_A : <<L뿪 Coring    A
{0x945C,0x20,0x01},    // AP_L_GC_NEG_SLOPE_B :
{0x945D,0x04,0x01},    // AP_L_GC_NEG_SLOPE_C1 :
{0x945E,0x04,0x01},    // AP_L_GC_NEG_SLOPE_C2 :
{0x945F,0x0A,0x01},    // AP_L_GAIN_POS_A : <<L뿪 POST Gain  A
{0x9460,0x11,0x01},    // AP_L_GAIN_POS_B :
{0x9461,0x1C,0x01},    // AP_L_GAIN_POS_C1 :
{0x9462,0x60,0x01},    // AP_L_GAIN_POS_C2 :
{0x9463,0x08,0x01},    // AP_L_GAIN_NEG_A : <<L뿪 POST Gain  A
{0x9464,0x0B,0x01},    // AP_L_GAIN_NEG_B :
{0x9465,0x0A,0x01},    // AP_L_GAIN_NEG_C1 :
{0x9466,0x20,0x01},    // AP_L_GAIN_NEG_C2 :
////////////////////////////////////////////////////////////////
{0x9468,0x0200,0x02},    // AP_N_GC_POS_TH_A : <<N뿪 Coring   Ӱġ A
{0x946A,0x00C0,0x02},    // AP_N_GC_POS_TH_B :
{0x946C,0x0168,0x02},    // AP_N_GC_POS_TH_C1 :
{0x946E,0x0168,0x02},    // AP_N_GC_POS_TH_C2 :
{0x9470,0x0200,0x02},    // AP_N_GC_NEG_TH_A : <<N뿪 Coring   Ӱġ A
{0x9472,0x00C0,0x02},    // AP_N_GC_NEG_TH_B :
{0x9474,0x00B4,0x02},    // AP_N_GC_NEG_TH_C1 :
{0x9476,0x00B4,0x02},    // AP_N_GC_NEG_TH_C2 :
{0x9478,0x0000,0x02},    // AP_N_LD_DARK_TH_A : <<δ뿪 LevelDepend ֵ Ӱġ A
{0x947A,0x0000,0x02},    // AP_N_LD_DARK_TH_B :
{0x947C,0x0000,0x02},    // AP_N_LD_DARK_TH_C1 :
{0x947E,0x0000,0x02},    // AP_N_LD_DARK_TH_C2 :
{0x9480,0x0096,0x02},    // AP_N_LD_HIGH_TH0_X_A: <<δ뿪 LevelDepend ֵ Ӱġ0 A
{0x9482,0x0050,0x02},    // AP_N_LD_HIGH_TH0_X_B :
{0x9484,0x0050,0x02},    // AP_N_LD_HIGH_TH0_X_C1 :
{0x9486,0x0050,0x02},    // AP_N_LD_HIGH_TH0_X_C2 :
{0x9488,0x0080,0x02},    // AP_N_LD_HIGH_TH0_Y_A : <<δ뿪 LevelDepend ֵ Ӱġ0  Gain A
{0x948A,0x0080,0x02},    // AP_N_LD_HIGH_TH0_Y_B :
{0x948C,0x0080,0x02},    // AP_N_LD_HIGH_TH0_Y_C1 :
{0x948E,0x0080,0x02},    // AP_N_LD_HIGH_TH0_Y_C2 :
{0x9490,0x00C8,0x02},    // AP_N_LD_HIGH_TH1_X_A : <<N뿪 LevelDepend ֵ Ӱġ1 A
{0x9492,0x012C,0x02},    // AP_N_LD_HIGH_TH1_X_B :
{0x9494,0x00C8,0x02},    // AP_N_LD_HIGH_TH1_X_C1 :
{0x9496,0x00C8,0x02},    // AP_N_LD_HIGH_TH1_X_C2
{0x9498,0x01F4,0x02},    // AP_N_LD_HIGH_TH2_X_A : <<N뿪 LevelDepend ֵ Ӱġ2 A
{0x949A,0x0200,0x02},    // AP_N_LD_HIGH_TH2_X_B :
{0x949C,0x0200,0x02},    // AP_N_LD_HIGH_TH2_X_C1 :
{0x949E,0x0200,0x02},    // AP_N_LD_HIGH_TH2_X_C2 :
////////////////////////////////////////////////////////////////

{0x94A0,0x0050,0x02},    // AP_H_GC_POS_TH_A : <<H뿪 Coring   Ӱġ A
{0x94A2,0x00A0,0x02},    // AP_H_GC_POS_TH_B :
{0x94A4,0x0033,0x02},    // AP_H_GC_POS_TH_C1 :
{0x94A6,0x0033,0x02},    // AP_H_GC_POS_TH_C2 :
{0x94A8,0x0050,0x02},    // AP_H_GC_NEG_TH_A : <<H뿪 Coring   Ӱġ A
{0x94AA,0x00A0,0x02},    // AP_H_GC_NEG_TH_B :
{0x94AC,0x0033,0x02},    // AP_H_GC_NEG_TH_C1 :
{0x94AE,0x0033,0x02},    // AP_H_GC_NEG_TH_C2 :
{0x94B0,0x0021,0x02},    // AP_H_LD_DARK_TH_A : <<H뿪 LevelDepend ֵ Ӱġ A
{0x94B2,0x0000,0x02},    // AP_H_LD_DARK_TH_B :
{0x94B4,0x0000,0x02},    // AP_H_LD_DARK_TH_C1 :
{0x94B6,0x0000,0x02},    // AP_H_LD_DARK_TH_C2
{0x94B8,0x01F4,0x02},    // AP_H_LD_HIGH_TH0_X_A : <<H뿪 LevelDepend ֵ Ӱġ0 A
{0x94BA,0x0083,0x02},    // AP_H_LD_HIGH_TH0_X_B :
{0x94BC,0x0064,0x02},    // AP_H_LD_HIGH_TH0_X_C1 :
{0x94BE,0x0064,0x02},    // AP_H_LD_HIGH_TH0_X_C2 :
{0x94C0,0x0080,0x02},    // AP_H_LD_HIGH_TH0_Y_A : <<H뿪 LevelDepend ֵ Ӱġ0  Gain A
{0x94C2,0x0080,0x02},    // AP_H_LD_HIGH_TH0_Y_B :
{0x94C4,0x0080,0x02},    // AP_H_LD_HIGH_TH0_Y_C1 :
{0x94C6,0x0080,0x02},    // AP_H_LD_HIGH_TH0_Y_C2 :
{0x94C8,0x0244,0x02},    // AP_H_LD_HIGH_TH1_X_A : <<H뿪 LevelDepend ֵ Ӱġ1 A
{0x94CA,0x01AA,0x02},    // AP_H_LD_HIGH_TH1_X_B :
{0x94CC,0x00C8,0x02},    // AP_H_LD_HIGH_TH1_X_C1 :
{0x94CE,0x00C8,0x02},    // AP_H_LD_HIGH_TH1_X_C2 :
{0x94D0,0x02EC,0x02},    // AP_H_LD_HIGH_TH2_X_A : <<H뿪 LevelDepend ֵ Ӱġ2 A
{0x94D2,0x01EF,0x02},    // AP_H_LD_HIGH_TH2_X_B :
{0x94D4,0x01E0,0x02},    // AP_H_LD_HIGH_TH2_X_C1 :
{0x94D6,0x01E0,0x02},    // AP_H_LD_HIGH_TH2_X_C2 :
{0x94D8,0x0001,0x02},    // AP_L_GC_POS_TH_A : <<L뿪 Coring   Ӱġ A
{0x94DA,0x0040,0x02},    // AP_L_GC_POS_TH_B :
{0x94DC,0x0010,0x02},    // AP_L_GC_POS_TH_C1 :
{0x94DE,0x0010,0x02},    // AP_L_GC_POS_TH_C2 :
{0x94E0,0x0001,0x02},    // AP_L_GC_NEG_TH_A : <<L뿪 Coring   Ӱġ A
{0x94E2,0x0030,0x02},    // AP_L_GC_NEG_TH_B :
{0x94E4,0x0020,0x02},    // AP_L_GC_NEG_TH_C1 :
{0x94E6,0x0020,0x02},    // AP_L_GC_NEG_TH_C2 :
{0x94E8,0x0000,0x02},    // AP_L_LD_DARK_TH_A : <<L뿪 LevelDepend ֵ Ӱġ A
{0x94EA,0x0000,0x02},    // AP_L_LD_DARK_TH_B :
{0x94EC,0x0000,0x02},    // AP_L_LD_DARK_TH_C1 :
{0x94EE,0x0000,0x02},    // AP_L_LD_DARK_TH_C2 :
{0x94F0,0x015E,0x02},    // AP_L_LD_HIGH_TH0_X_A : <<L뿪 LevelDepend ֵ Ӱġ0 A
{0x94F2,0x015E,0x02},    // AP_L_LD_HIGH_TH0_X_B :
{0x94F4,0x0010,0x02},    // AP_L_LD_HIGH_TH0_X_C1 :
{0x94F6,0x0010,0x02},    // AP_L_LD_HIGH_TH0_X_C2 :
{0x94F8,0x0080,0x02},    // AP_L_LD_HIGH_TH0_Y_A : <<L뿪 LevelDepend ֵ Ӱġ0  Gain A
{0x94FA,0x0080,0x02},    // AP_L_LD_HIGH_TH0_Y_B :
{0x94FC,0x0080,0x02},    // AP_L_LD_HIGH_TH0_Y_C1 :
{0x94FE,0x0080,0x02},    // AP_L_LD_HIGH_TH0_Y_C2 :
{0x9500,0x0226,0x02},    // AP_L_LD_HIGH_TH1_X_A : <<L뿪 LevelDepend ֵ Ӱġ1 A
{0x9502,0x0226,0x02},    // AP_L_LD_HIGH_TH1_X_B :
{0x9504,0x0020,0x02},    // AP_L_LD_HIGH_TH1_X_C1 :
{0x9506,0x0020,0x02},    // AP_L_LD_HIGH_TH1_X_C2 :
{0x9508,0x02A2,0x02},    // AP_L_LD_HIGH_TH2_X_A : <<L뿪 LevelDepend ֵ Ӱġ2 A
{0x950A,0x028A,0x02},    // AP_L_LD_HIGH_TH2_X_B :
{0x950C,0x0050,0x02},    // AP_L_LD_HIGH_TH2_X_C1 :
{0x950E,0x0050,0x02},    // AP_L_LD_HIGH_TH2_X_C2 :

//blend Ʈ 

{0x9510,0x0020,0x02},    // AP_POST_LIM_POS_A : <<
{0x9512,0x0060,0x02},    // AP_POST_LIM_POS_B :
{0x9514,0x0060,0x02},    // AP_POST_LIM_POS_C1 :
{0x9516,0x0060,0x02},    // AP_POST_LIM_POS_C2 :
{0x9518,0x0030,0x02},    // AP_POST_LIM_NEG_A : <<
{0x951A,0x0048,0x02},    // AP_POST_LIM_NEG_B :
{0x951C,0x0048,0x02},    // AP_POST_LIM_NEG_C1 :
{0x951E,0x0048,0x02},    // AP_POST_LIM_NEG_C2 :
{0x9520,0x0000,0x02},    // AP_POST_CORE_POS_A : <<
{0x9522,0x0000,0x02},    // AP_POST_CORE_POS_B :
{0x9524,0x0001,0x02},    // AP_POST_CORE_POS_C1 :
{0x9526,0x0001,0x02},    // AP_POST_CORE_POS_C2 :
{0x9528,0x0002,0x02},    // AP_POST_CORE_NEG_A : <
{0x952A,0x0000,0x02},    // AP_POST_CORE_NEG_B :
{0x952C,0x0000,0x02},    // AP_POST_CORE_NEG_C1 :
{0x952E,0x0000,0x02},    // AP_POST_CORE_NEG_C2 :

//level defender 

{0x9530,0x0000,0x02},    // AP_N_LD_DARK_SLOPE_A : << N뿪 LevelDepend ֵ  A
{0x9532,0x0000,0x02},
{0x9534,0x0000,0x02},    // AP_N_LD_DARK_SLOPE_B :
{0x9536,0x0000,0x02},
{0x9538,0x0000,0x02},    // AP_N_LD_DARK_SLOPE_C1 :
{0x953A,0x0000,0x02},
{0x953C,0x0000,0x02},    // AP_N_LD_DARK_SLOPE_C2 :
{0x953E,0x0000,0x02},
{0x9540,0x0061,0x02},    // AP_N_LD_HIGH_SLOPE0_A : << N뿪 LevelDepend ֵ Ӱġ0Ӱġ1  A
{0x9542,0x0000,0x02},
{0x9544,0x0031,0x02},    // AP_N_LD_HIGH_SLOPE0_B :
{0x9546,0x0000,0x02},
{0x9548,0x0000,0x02},    // AP_N_LD_HIGH_SLOPE0_C1 :
{0x954A,0x0000,0x02},
{0x954C,0x0000,0x02},    // AP_N_LD_HIGH_SLOPE0_C2 :
{0x954E,0x0000,0x02},
{0x9550,0x001C,0x02},    // AP_N_LD_HIGH_SLOPE1_A : <<N뿪 LevelDepend ֵ Ӱġ1Ӱġ2  A
{0x9552,0x0000,0x02},
{0x9554,0x000C,0x02},    // AP_N_LD_HIGH_SLOPE1_B :
{0x9556,0x0000,0x02},
{0x9558,0x001A,0x02},    // AP_N_LD_HIGH_SLOPE1_C1 :
{0x955A,0x0000,0x02},
{0x955C,0x001A,0x02},    // AP_N_LD_HIGH_SLOPE1_C2 :
{0x955E,0x0000,0x02},
{0x9560,0x0000,0x02},    // AP_N_LD_HIGH_SLOPE2_A : <<N뿪 LevelDepend ֵ Ӱġ2˽  A
{0x9562,0x0000,0x02},
{0x9564,0x0005,0x02},    // AP_N_LD_HIGH_SLOPE2_B :
{0x9566,0x0000,0x02},
{0x9568,0x0014,0x02},    // AP_N_LD_HIGH_SLOPE2_C1 :
{0x956A,0x0000,0x02},
{0x956C,0x0014,0x02},    // AP_N_LD_HIGH_SLOPE2_C2 :
{0x956E,0x0000,0x02},
{0x9570,0x0000,0x02},    // AP_H_LD_DARK_SLOPE_A : <<H뿪 LevelDepend ֵ  A
{0x9572,0x0000,0x02},
{0x9574,0x0000,0x02},    // AP_H_LD_DARK_SLOPE_B :
{0x9576,0x0000,0x02},
{0x9578,0x0000,0x02},    // AP_H_LD_DARK_SLOPE_C1 :
{0x957A,0x0000,0x02},
{0x957C,0x0000,0x02},    // AP_H_LD_DARK_SLOPE_C2 :
{0x957E,0x0000,0x02},
{0x9580,0x0025,0x02},    // AP_H_LD_HIGH_SLOPE0_A : <<H뿪 LevelDepend ֵ Ӱġ0Ӱġ1  A
{0x9582,0x0000,0x02},
{0x9584,0x0025,0x02},    // AP_H_LD_HIGH_SLOPE0_B :
{0x9586,0x0000,0x02},
{0x9588,0x0064,0x02},    // AP_H_LD_HIGH_SLOPE0_C1 :
{0x958A,0x0000,0x02},
{0x958C,0x004D,0x02},    // AP_H_LD_HIGH_SLOPE0_C2 :
{0x958E,0x0000,0x02},
{0x9590,0x0050,0x02},    // AP_H_LD_HIGH_SLOPE1_A : <<H뿪 LevelDepend ֵ Ӱġ1Ӱġ2  A
{0x9592,0x0000,0x02},
{0x9594,0x0050,0x02},    // AP_H_LD_HIGH_SLOPE1_B :
{0x9596,0x0000,0x02},
{0x9598,0x0004,0x02},    // AP_H_LD_HIGH_SLOPE1_C1 :
{0x959A,0x0000,0x02},
{0x959C,0x000C,0x02},    // AP_H_LD_HIGH_SLOPE1_C2 :
{0x959E,0x0000,0x02},
{0x95A0,0x0000,0x02},    // AP_H_LD_HIGH_SLOPE2_A : <<H뿪 LevelDepend ֵ Ӱġ2˽  A
{0x95A2,0x0000,0x02},
{0x95A4,0x0000,0x02},    // AP_H_LD_HIGH_SLOPE2_B :
{0x95A6,0x0000,0x02},
{0x95A8,0x000D,0x02},    // AP_H_LD_HIGH_SLOPE2_C1 :
{0x95AA,0x0000,0x02},
{0x95AC,0x000D,0x02},    // AP_H_LD_HIGH_SLOPE2_C2 :
{0x95AE,0x0000,0x02},
{0x95B0,0x0000,0x02},    // AP_L_LD_DARK_SLOPE_A : <<L뿪 LevelDepend ֵ  A
{0x95B2,0x0000,0x02},
{0x95B4,0x0000,0x02},    // AP_L_LD_DARK_SLOPE_B :
{0x95B6,0x0000,0x02},
{0x95B8,0x0000,0x02},    // AP_L_LD_DARK_SLOPE_C1 :
{0x95BA,0x0000,0x02},
{0x95BC,0x0000,0x02},    // AP_L_LD_DARK_SLOPE_C2 :
{0x95BE,0x0000,0x02},
{0x95C0,0x0020,0x02},    // AP_L_LD_HIGH_SLOPE0_A : <<L뿪 LevelDepend ֵ Ӱġ0Ӱġ1  A
{0x95C2,0x0000,0x02},
{0x95C4,0x0023,0x02},    // AP_L_LD_HIGH_SLOPE0_B :
{0x95C6,0x0000,0x02},
{0x95C8,0x012C,0x02},    // AP_L_LD_HIGH_SLOPE0_C1 :
{0x95CA,0x0000,0x02},
{0x95CC,0x012C,0x02},    // AP_L_LD_HIGH_SLOPE0_C2 :
{0x95CE,0x0000,0x02},
{0x95D0,0x0051,0x02},    // AP_L_LD_HIGH_SLOPE1_A : <<L뿪 LevelDepend ֵ Ӱġ1Ӱġ2  A
{0x95D2,0x0000,0x02},
{0x95D4,0x0050,0x02},    // AP_L_LD_HIGH_SLOPE1_B :
{0x95D6,0x0000,0x02},
{0x95D8,0x0058,0x02},    // AP_L_LD_HIGH_SLOPE1_C1 :
{0x95DA,0x0000,0x02},
{0x95DC,0x0058,0x02},    // AP_L_LD_HIGH_SLOPE1_C2 :
{0x95DE,0x0000,0x02},
{0x95E0,0x0000,0x02},    // AP_L_LD_HIGH_SLOPE2_A : <<L뿪 LevelDepend ֵ Ӱġ2˽  A
{0x95E2,0x0000,0x02},
{0x95E4,0x0050,0x02},    // AP_L_LD_HIGH_SLOPE2_B :
{0x95E6,0x0000,0x02},
{0x95E8,0x002A,0x02},    // AP_L_LD_HIGH_SLOPE2_C1 :
{0x95EA,0x0000,0x02},
{0x95EC,0x002A,0x02},    // AP_L_LD_HIGH_SLOPE2_C2 :
{0x95EE,0x0000,0x02},

//C-sup tuning
{0x6C47,0x0F,0x01},    // MAIN_CONFIG2 :
{0x6C48,0x03,0x01},    // MAIN_CONFIG3 :
{0x9805,0x0A,0x01},    // CS_SLP_C_A :
{0x9806,0x0A,0x01},    // CS_SLP_C_B :
{0x9807,0x0A,0x01},    // CS_SLP_C_C :
{0x9808,0x20,0x01},    // CS_SLP_YC_A :
{0x9809,0x20,0x01},    // CS_SLP_YC_B :
{0x980A,0x20,0x01},    // CS_SLP_YC_C :
{0x980B,0x20,0x01},    // CS_SLP_Y_A :
{0x980C,0x20,0x01},    // CS_SLP_Y_B :
{0x980D,0x20,0x01},    // CS_SLP_Y_C :
{0x980E,0x14,0x01},    // CS_CBHLEV_A :
{0x980F,0x14,0x01},    // CS_CBHLEV_B :
{0x9810,0x14,0x01},    // CS_CBHLEV_C :
{0x9811,0x14,0x01},    // CS_CRHLEV_A :
{0x9812,0x14,0x01},    // CS_CRHLEV_B :
{0x9813,0x14,0x01},    // CS_CRHLEV_C :
{0x9802,0x77,0x01},    // CS_YHCOEF_A :
{0x9803,0x77,0x01},    // CS_YHCOEF_B :
{0x9804,0x77,0x01},    // CS_YHCOEF_C :
{0x9808,0x20,0x01},    // CS_SLP_YC_A :
{0x9809,0x20,0x01},    // CS_SLP_YC_B :
{0x980A,0x20,0x01},    // CS_SLP_YC_C :
{0x980B,0x20,0x01},    // CS_SLP_Y_A :
{0x980C,0x20,0x01},    // CS_SLP_Y_B :
{0x980D,0x20,0x01},    // CS_SLP_Y_C :
{0x9814,0x14,0x01},    // CS_CBHLEV_Y_A :
{0x9815,0x14,0x01},    // CS_CBHLEV_Y_B :
{0x9816,0x14,0x01},    // CS_CBHLEV_Y_C :
{0x9817,0x00,0x01},    // CS_CRHLEV_Y_A :
{0x9818,0x00,0x01},    // CS_CRHLEV_Y_B :
{0x9819,0x00,0x01},    // CS_CRHLEV_Y_C :
{0x9836,0x0000,0x02},    // CS_CBLLEV_Y_A :
{0x9838,0x0000,0x02},    // CS_CBLLEV_Y_B :
{0x983A,0x0000,0x02},    // CS_CBLLEV_Y_C :
{0x983C,0xFFEC,0x02},    // CS_CRLLEV_Y_A :
{0x983E,0xFFEC,0x02},    // CS_CRLLEV_Y_B :
{0x9840,0xFFEC,0x02},    // CS_CRLLEV_Y_C :
{0x981A,0x03,0x01},    // CS_SLP_YC_L_A :
{0x981B,0x03,0x01},    // CS_SLP_YC_L_B :
{0x981C,0x03,0x01},    // CS_SLP_YC_L_C :
{0x981D,0x32,0x01},    // CS_SLP_Y_L_A :
{0x981E,0x20,0x01},    // CS_SLP_Y_L_B :
{0x981F,0x20,0x01},    // CS_SLP_Y_L_C :
{0x9820,0x1E,0x01},    // CS_YLCOEF_A :
{0x9821,0x1E,0x01},    // CS_YLCOEF_B :
{0x9822,0x1E,0x01},    // CS_YLCOEF_C :
{0x9823,0x32,0x01},    // CS_CBHLEV_Y_L_A :
{0x9824,0x32,0x01},    // CS_CBHLEV_Y_L_B :
{0x9825,0x32,0x01},    // CS_CBHLEV_Y_L_C :
{0x9826,0x32,0x01},    // CS_CRHLEV_Y_L_A :
{0x9827,0x32,0x01},    // CS_CRHLEV_Y_L_B :
{0x9828,0x32,0x01},    // CS_CRHLEV_Y_L_C :
{0x982A,0xFFEC,0x02},    // CS_CBLLEV_A :
{0x982C,0xFFEC,0x02},    // CS_CBLLEV_B :
{0x982E,0xFFEC,0x02},    // CS_CBLLEV_C :
{0x9830,0xFFEC,0x02},    // CS_CRLLEV_A :
{0x9832,0xFFEC,0x02},    // CS_CRLLEV_B :
{0x9834,0xFFEC,0x02},    // CS_CRLLEV_C :
{0x9836,0x0000,0x02},    // CS_CBLLEV_Y_A :
{0x9838,0x0000,0x02},    // CS_CBLLEV_Y_B :
{0x983A,0x0000,0x02},    // CS_CBLLEV_Y_C :
{0x983C,0xFFEC,0x02},    // CS_CRLLEV_Y_A :
{0x983E,0xFFEC,0x02},    // CS_CRLLEV_Y_B :
{0x9840,0xFFEC,0x02},    // CS_CRLLEV_Y_C :
{0x9842,0xFFCE,0x02},    // CS_CBLLEV_Y_L_A :
{0x9844,0xFFCE,0x02},    // CS_CBLLEV_Y_L_B :
{0x9846,0xFFCE,0x02},    // CS_CBLLEV_Y_L_C :
{0x9848,0xFFCE,0x02},    // CS_CRLLEV_Y_L_A :
{0x984A,0xFFCE,0x02},    // CS_CRLLEV_Y_L_B :
{0x984C,0xFFCE,0x02},    // CS_CRLLEV_Y_L_C :

//CNR
{0x6C4A,0x07,0x01},    // MAIN_CONFIG5 :
{0x6C4C,0x190A,0x02},    // CNR_CTRL_TH_H :
{0x6C4E,0x1000,0x02},    // CNR_CTRL_TH_L :
{0x9866,0x40,0x01},    // CNR_PREHNR_GAIN_A :
{0x9867,0x00,0x01},    // CNR_PREHNR_GAIN_B :
{0x9868,0x00,0x01},    // CNR_PREHNR_GAIN_C :
{0x9869,0x32,0x01},    // CNR_NLM_TH_CR_H_A :
{0x986A,0x04,0x01},    // CNR_NLM_TH_CR_H_B :
{0x986B,0x0E,0x01},    // CNR_NLM_TH_CR_H_C :
{0x986C,0x32,0x01},    // CNR_NLM_TH_CR_L_A :
{0x986D,0x04,0x01},    // CNR_NLM_TH_CR_L_B :
{0x986E,0x0E,0x01},    // CNR_NLM_TH_CR_L_C :
{0x986F,0x32,0x01},    // CNR_NLM_TH_CR_M_H_A :
{0x9870,0x04,0x01},    // CNR_NLM_TH_CR_M_H_B :
{0x9871,0x0E,0x01},    // CNR_NLM_TH_CR_M_H_C :
{0x9872,0x32,0x01},    // CNR_NLM_TH_CR_M_L_A :
{0x9873,0x04,0x01},    // CNR_NLM_TH_CR_M_L_B :
{0x9874,0x0E,0x01},    // CNR_NLM_TH_CR_M_L_C :
{0x9875,0x32,0x01},    // CNR_NLM_TH_CB_H_A :
{0x9876,0x04,0x01},    // CNR_NLM_TH_CB_H_B :
{0x9877,0x0E,0x01},    // CNR_NLM_TH_CB_H_C :
{0x9878,0x32,0x01},    // CNR_NLM_TH_CB_L_A :
{0x9879,0x04,0x01},    // CNR_NLM_TH_CB_L_B :
{0x987A,0x0E,0x01},    // CNR_NLM_TH_CB_L_C :
{0x987B,0x32,0x01},    // CNR_NLM_TH_CB_M_H_A :
{0x987C,0x04,0x01},    // CNR_NLM_TH_CB_M_H_B :
{0x987D,0x0E,0x01},    // CNR_NLM_TH_CB_M_H_C :
{0x987E,0x32,0x01},    // CNR_NLM_TH_CB_M_L_A :
{0x987F,0x04,0x01},    // CNR_NLM_TH_CB_M_L_B :
{0x9880,0x0E,0x01},    // CNR_NLM_TH_CB_M_L_C :
{0x9881,0x7F,0x01},    // CNR_VE_TH_CR_H_A :
{0x9882,0x01,0x01},    // CNR_VE_TH_CR_H_B :
{0x9883,0x04,0x01},    // CNR_VE_TH_CR_H_C :
{0x9884,0x7F,0x01},    // CNR_VE_TH_CR_L_A :
{0x9885,0x01,0x01},    // CNR_VE_TH_CR_L_B :
{0x9886,0x04,0x01},    // CNR_VE_TH_CR_L_C :
{0x9887,0x7F,0x01},    // CNR_VE_TH_CR_M_H_A :
{0x9888,0x01,0x01},    // CNR_VE_TH_CR_M_H_B :
{0x9889,0x04,0x01},    // CNR_VE_TH_CR_M_H_C :
{0x988A,0x7F,0x01},    // CNR_VE_TH_CR_M_L_A :
{0x988B,0x01,0x01},    // CNR_VE_TH_CR_M_L_B :
{0x988C,0x04,0x01},    // CNR_VE_TH_CR_M_L_C :
{0x988D,0x7F,0x01},    // CNR_VE_TH_CB_H_A :
{0x988E,0x01,0x01},    // CNR_VE_TH_CB_H_B :
{0x988F,0x04,0x01},    // CNR_VE_TH_CB_H_C :
{0x9890,0x7F,0x01},    // CNR_VE_TH_CB_L_A :
{0x9891,0x01,0x01},    // CNR_VE_TH_CB_L_B :
{0x9892,0x04,0x01},    // CNR_VE_TH_CB_L_C :
{0x9893,0x7F,0x01},    // CNR_VE_TH_CB_M_H_A :
{0x9894,0x01,0x01},    // CNR_VE_TH_CB_M_H_B :
{0x9895,0x04,0x01},    // CNR_VE_TH_CB_M_H_C :
{0x9896,0x7F,0x01},    // CNR_VE_TH_CB_M_L_A :
{0x9897,0x01,0x01},    // CNR_VE_TH_CB_M_L_B :
{0x9898,0x04,0x01},    // CNR_VE_TH_CB_M_L_C :
{0x9881,0x7F,0x01},    // CNR_VE_TH_CR_H_A :
{0x9882,0x01,0x01},    // CNR_VE_TH_CR_H_B :
{0x9883,0x04,0x01},    // CNR_VE_TH_CR_H_C :
{0x9884,0x7F,0x01},    // CNR_VE_TH_CR_L_A :
{0x9885,0x01,0x01},    // CNR_VE_TH_CR_L_B :
{0x9886,0x04,0x01},    // CNR_VE_TH_CR_L_C :
{0x9887,0x7F,0x01},    // CNR_VE_TH_CR_M_H_A :
{0x9888,0x01,0x01},    // CNR_VE_TH_CR_M_H_B :
{0x9889,0x04,0x01},    // CNR_VE_TH_CR_M_H_C :
{0x988A,0x7F,0x01},    // CNR_VE_TH_CR_M_L_A :
{0x988B,0x01,0x01},    // CNR_VE_TH_CR_M_L_B :
{0x988C,0x04,0x01},    // CNR_VE_TH_CR_M_L_C :
{0x988D,0x7F,0x01},    // CNR_VE_TH_CB_H_A :
{0x988E,0x01,0x01},    // CNR_VE_TH_CB_H_B :
{0x988F,0x04,0x01},    // CNR_VE_TH_CB_H_C :
{0x9890,0x7F,0x01},    // CNR_VE_TH_CB_L_A :
{0x9891,0x01,0x01},    // CNR_VE_TH_CB_L_B :
{0x9892,0x04,0x01},    // CNR_VE_TH_CB_L_C :
{0x9893,0x7F,0x01},    // CNR_VE_TH_CB_M_H_A :
{0x9894,0x01,0x01},    // CNR_VE_TH_CB_M_H_B :
{0x9895,0x04,0x01},    // CNR_VE_TH_CB_M_H_C :
{0x9896,0x7F,0x01},    // CNR_VE_TH_CB_M_L_A :
{0x9897,0x01,0x01},    // CNR_VE_TH_CB_M_L_B :
{0x9898,0x04,0x01},    // CNR_VE_TH_CB_M_L_C :
{0x989A,0x0066,0x02},    // CNR_COEF_CR_H_A :
{0x989C,0x0100,0x02},    // CNR_COEF_CR_H_B :
{0x989E,0x0100,0x02},    // CNR_COEF_CR_H_C :
{0x98A0,0x0066,0x02},    // CNR_COEF_CR_L_A :
{0x98A2,0x0100,0x02},    // CNR_COEF_CR_L_B :
{0x98A4,0x0100,0x02},    // CNR_COEF_CR_L_C :
{0x98A6,0x0066,0x02},    // CNR_COEF_CR_M_H_A :
{0x98A8,0x0100,0x02},    // CNR_COEF_CR_M_H_B :
{0x98AA,0x0100,0x02},    // CNR_COEF_CR_M_H_C :
{0x98AC,0x0066,0x02},    // CNR_COEF_CR_M_L_A :
{0x98AE,0x0100,0x02},    // CNR_COEF_CR_M_L_B :
{0x98B0,0x0100,0x02},    // CNR_COEF_CR_M_L_C :
{0x98B2,0x0066,0x02},    // CNR_COEF_CB_H_A :
{0x98B4,0x0100,0x02},    // CNR_COEF_CB_H_B :
{0x98B6,0x0100,0x02},    // CNR_COEF_CB_H_C :
{0x98B8,0x0066,0x02},    // CNR_COEF_CB_L_A :
{0x98BA,0x0100,0x02},    // CNR_COEF_CB_L_B :
{0x98BC,0x0100,0x02},    // CNR_COEF_CB_L_C :
{0x98BE,0x0066,0x02},    // CNR_COEF_CB_M_H_A :
{0x98C0,0x0100,0x02},    // CNR_COEF_CB_M_H_B :
{0x98C2,0x0100,0x02},    // CNR_COEF_CB_M_H_C :
{0x98C4,0x0066,0x02},    // CNR_COEF_CB_M_L_A :
{0x98C6,0x0100,0x02},    // CNR_COEF_CB_M_L_B :
{0x98C8,0x0100,0x02},    // CNR_COEF_CB_M_L_C :
{0x98CA,0x1770,0x02},    // CNR_EDGE_GAIN_CR_H_A :
{0x98CC,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_H_B :
{0x98CE,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_H_C :
{0x98D0,0x1770,0x02},    // CNR_EDGE_GAIN_CR_L_A :
{0x98D2,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_L_B :
{0x98D4,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_L_C :
{0x98D6,0x1770,0x02},    // CNR_EDGE_GAIN_CR_M_H_A :
{0x98D8,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_M_H_B :
{0x98DA,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_M_H_C :
{0x98DC,0x1770,0x02},    // CNR_EDGE_GAIN_CR_M_L_A :
{0x98DE,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_M_L_B :
{0x98E0,0x07D0,0x02},    // CNR_EDGE_GAIN_CR_M_L_C :
{0x98E2,0x1770,0x02},    // CNR_EDGE_GAIN_CB_H_A :
{0x98E4,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_H_B :
{0x98E6,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_H_C :
{0x98E8,0x1770,0x02},    // CNR_EDGE_GAIN_CB_L_A :
{0x98EA,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_L_B :
{0x98EC,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_L_C :
{0x98EE,0x1770,0x02},    // CNR_EDGE_GAIN_CB_M_H_A :
{0x98F0,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_M_H_B :
{0x98F2,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_M_H_C :
{0x98F4,0x1770,0x02},    // CNR_EDGE_GAIN_CB_M_L_A :
{0x98F6,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_M_L_B :
{0x98F8,0x07D0,0x02},    // CNR_EDGE_GAIN_CB_M_L_C :
{0x98FA,0x7530,0x02},    // CNR_EDGE_TH_CR_H_A :
{0x98FC,0x0000,0x02},    // CNR_EDGE_TH_CR_H_B :
{0x98FE,0x0000,0x02},    // CNR_EDGE_TH_CR_H_C :
{0x9900,0x7530,0x02},    // CNR_EDGE_TH_CR_L_A :
{0x9902,0x0000,0x02},    // CNR_EDGE_TH_CR_L_B :
{0x9904,0x0000,0x02},    // CNR_EDGE_TH_CR_L_C :
{0x9906,0x7530,0x02},    // CNR_EDGE_TH_CR_M_H_A :
{0x9908,0x0000,0x02},    // CNR_EDGE_TH_CR_M_H_B :
{0x990A,0x0000,0x02},    // CNR_EDGE_TH_CR_M_H_C :
{0x990C,0x7530,0x02},    // CNR_EDGE_TH_CR_M_L_A :
{0x990E,0x0000,0x02},    // CNR_EDGE_TH_CR_M_L_B :
{0x9910,0x0000,0x02},    // CNR_EDGE_TH_CR_M_L_C :
{0x9912,0x7530,0x02},    // CNR_EDGE_TH_CB_H_A :
{0x9914,0x0000,0x02},    // CNR_EDGE_TH_CB_H_B :
{0x9916,0x0000,0x02},    // CNR_EDGE_TH_CB_H_C :
{0x9918,0x7530,0x02},    // CNR_EDGE_TH_CB_L_A :
{0x991A,0x0000,0x02},    // CNR_EDGE_TH_CB_L_B :
{0x991C,0x0000,0x02},    // CNR_EDGE_TH_CB_L_C :
{0x991E,0x7530,0x02},    // CNR_EDGE_TH_CB_M_H_A :
{0x9920,0x0000,0x02},    // CNR_EDGE_TH_CB_M_H_B :
{0x9922,0x0000,0x02},    // CNR_EDGE_TH_CB_M_H_C :
{0x9924,0x7530,0x02},    // CNR_EDGE_TH_CB_M_L_A :
{0x9926,0x0000,0x02},    // CNR_EDGE_TH_CB_M_L_B :
{0x9928,0x0000,0x02},    // CNR_EDGE_TH_CB_M_L_C :

//ITP NR
{0x5005,0xBB,0x01},    // DM_SW1 :
{0x5006,0x03,0x01},    // DM_SW2 :
{0x9608,0x0000,0x02},    // DS_GRADCORE_A :
{0x960A,0x0004,0x02},    // DS_GRADCORE_B :
{0x960C,0x0000,0x02},    // DS_GRADCORE_C1 :
{0x960E,0x0000,0x02},    // DS_GRADCORE_C2 :
{0x9610,0x000A,0x02},    // DS_GRADLIM_A :
{0x9612,0x0019,0x02},    // DS_GRADLIM_B :
{0x9614,0x0020,0x02},    // DS_GRADLIM_C1 :
{0x9616,0x0020,0x02},    // DS_GRADLIM_C2 :
{0x9600,0x0080,0x02},    // DS_NOISELVL_A :
{0x9602,0x0039,0x02},    // DS_NOISELVL_B :
{0x9604,0x0030,0x02},    // DS_NOISELVL_C1 :
{0x9606,0x0030,0x02},    // DS_NOISELVL_C2
{0x9670,0x14,0x01},    // YN_SLOPELIMIT_A :
{0x9671,0x20,0x01},    // YN_SLOPELIMIT_B :
{0x9672,0x20,0x01},    // YN_SLOPELIMIT_C1 :
{0x9673,0x20,0x01},    // YN_SLOPELIMIT_C2 :
{0x9674,0x0032,0x02},    // YN_LNRTH_CORE_A :
{0x9676,0x0006,0x02},    // YN_LNRTH_CORE_B :
{0x9678,0x0003,0x02},    // YN_LNRTH_CORE_C1 :
{0x967A,0x0003,0x02},    // YN_LNRTH_CORE_C2 :
{0x967C,0x0032,0x02},    // YN_LNRTH_LIM_A :
{0x967E,0x0058,0x02},    // YN_LNRTH_LIM_B :
{0x9680,0x00A0,0x02},    // YN_LNRTH_LIM_C1 :
{0x9682,0x00A0,0x02},    // YN_LNRTH_LIM_C2 :
{0x9684,0x000F,0x02},    // LN_CNRTH_A :
{0x9686,0x0014,0x02},    // LN_CNRTH_B :
{0x9688,0x0014,0x02},    // LN_CNRTH_C1 :
{0x968A,0x0014,0x02},    // LN_CNRTH_C2 :
{0x968C,0x0100,0x02},    // CS_BLEND_LL_A :
{0x968E,0x0000,0x02},    // CS_BLEND_LL_B :
{0x9690,0x03FF,0x02},    // CS_BLEND_LL_C1 :
{0x9692,0x03FF,0x02},    // CS_BLEND_LL_C2 :
{0x9628,0x0008,0x02},    // DS_HLNLBLENDCORE_A :
{0x962A,0x0003,0x02},    // DS_HLNLBLENDCORE_B :
{0x962C,0x0000,0x02},    // DS_HLNLBLENDCORE_C1 :
{0x962E,0x0000,0x02},    // DS_HLNLBLENDCORE_C2 :
{0x9630,0x0018,0x02},    // DS_HLNLBLENDLIM_A :
{0x9632,0x0024,0x02},    // DS_HLNLBLENDLIM_B :
{0x9634,0x0028,0x02},    // DS_HLNLBLENDLIM_C1 :
{0x9636,0x0028,0x02},    // DS_HLNLBLENDLIM_C2 :
{0x9638,0x0000,0x02},    // DS_MNBLENDCORE_A :
{0x963A,0x000C,0x02},    // DS_MNBLENDCORE_B :
{0x963C,0x0000,0x02},    // DS_MNBLENDCORE_C1 :
{0x963E,0x0000,0x02},    // DS_MNBLENDCORE_C2 :
{0x9640,0x0020,0x02},    // DS_MNBLENDLIM_A :
{0x9642,0x0030,0x02},    // DS_MNBLENDLIM_B :
{0x9644,0x0080,0x02},    // DS_MNBLENDLIM_C1 :
{0x9646,0x0080,0x02},    // DS_MNBLENDLIM_C2 :
{0x9648,0x0008,0x02},    // DS_MHBLENDCORE_A :
{0x964A,0x0005,0x02},    // DS_MHBLENDCORE_B :
{0x964C,0x0001,0x02},    // DS_MHBLENDCORE_C1 :
{0x964E,0x0001,0x02},    // DS_MHBLENDCORE_C2 :
{0x9650,0x0018,0x02},    // DS_MHBLENDLIM_A :
{0x9652,0x0041,0x02},    // DS_MHBLENDLIM_B :
{0x9654,0x005A,0x02},    // DS_MHBLENDLIM_C1 :
{0x9656,0x0050,0x02},    // DS_MHBLENDLIM_C2 :
{0x9668,0x0008,0x02},    // DS_NAPMSKLIM_A :
{0x966A,0x0010,0x02},    // DS_NAPMSKLIM_B :
{0x966C,0x0018,0x02},    // DS_NAPMSKLIM_C1 :
{0x966E,0x0018,0x02},    // DS_NAPMSKLIM_C2 :
{0x9618,0x0018,0x02},    // DS_ZIPSUPCORE_A :
{0x961A,0x0018,0x02},    // DS_ZIPSUPCORE_B :
{0x961C,0x0004,0x02},    // DS_ZIPSUPCORE_C1 :
{0x961E,0x0004,0x02},    // DS_ZIPSUPCORE_C2 :
{0x9620,0x0010,0x02},    // DS_ZIPSUPLIM_A :
{0x9622,0x0010,0x02},    // DS_ZIPSUPLIM_B :
{0x9624,0x0010,0x02},    // DS_ZIPSUPLIM_C1 :
{0x9626,0x0010,0x02},    // DS_ZIPSUPLIM_C2 :
{0x9658,0x0020,0x02},    // DS_ICDCORE_A :
{0x965A,0x0010,0x02},    // DS_ICDCORE_B :
{0x965C,0x0000,0x02},    // DS_ICDCORE_C1 :
{0x965E,0x0000,0x02},    // DS_ICDCORE_C2 :
{0x9660,0x0020,0x02},    // DS_ICDLIM_A :
{0x9662,0x0040,0x02},    // DS_ICDLIM_B :
{0x9664,0x0040,0x02},    // DS_ICDLIM_C1 :
{0x9666,0x0040,0x02},    // DS_ICDLIM_C2 :
{0x9694,0x000C,0x02},    // CS_EDGE_CSUP_CORE_A :
{0x9696,0x000C,0x02},    // CS_EDGE_CSUP_CORE_B :
{0x9698,0x000C,0x02},    // CS_EDGE_CSUP_CORE_C1 :
{0x969A,0x0006,0x02},    // CS_EDGE_CSUP_CORE_C2 :
{0x969C,0x000C,0x02},    // CS_EDGE_CSUP_LIM_A :
{0x969E,0x000C,0x02},    // CS_EDGE_CSUP_LIM_B :
{0x96A0,0x0010,0x02},    // CS_EDGE_CSUP_LIM_C1 :
{0x96A2,0x0008,0x02},    // CS_EDGE_CSUP_LIM_C2 :
{0x96A4,0x0180,0x02},    // CS_SPOT_CSUP_CORE_A :
{0x96A6,0x0180,0x02},    // CS_SPOT_CSUP_CORE_B :
{0x96A8,0x0100,0x02},    // CS_SPOT_CSUP_CORE_C1 :
{0x96AA,0x0100,0x02},    // CS_SPOT_CSUP_CORE_C2 :
{0x96AC,0x000A,0x02},    // CS_SPOT_CSUP_LIM_A :
{0x96AE,0x000A,0x02},    // CS_SPOT_CSUP_LIM_B :
{0x96B0,0x0018,0x02},    // CS_SPOT_CSUP_LIM_C1 :
{0x96B2,0x0018,0x02},    // CS_SPOT_CSUP_LIM_C2 :

//LMT  Blend 
{0x9800,0x40,0x01},    //
{0x9801,0x80,0x01},    //

//ο Type  
{0x9217,0x3C,0x01},    // GAIN_TH_A_TYPE5 :
{0x9218,0x28,0x01},    // GAIN_TH_B_TYPE5 :
{0x9219,0x1E,0x01},    // GAIN_TH_C_TYPE5 :

//CNR  
{0x928F,0x05,0x01},    // CNR_PREHNR_GAIN_SEL :
{0x9290,0x05,0x01},    // CNR_NLM_TH_CR_H_SEL :
{0x9291,0x05,0x01},    // CNR_NLM_TH_CR_L_SEL :
{0x9292,0x05,0x01},    // CNR_NLM_TH_CR_M_H_SEL :
{0x9293,0x05,0x01},    // CNR_NLM_TH_CR_M_L_SEL :
{0x9294,0x05,0x01},    // CNR_NLM_TH_CB_H_SEL :
{0x9295,0x05,0x01},    // CNR_NLM_TH_CB_L_SEL :
{0x9296,0x05,0x01},    // CNR_NLM_TH_CB_M_H_SEL :
{0x9297,0x05,0x01},    // CNR_NLM_TH_CB_M_L_SEL :
{0x9298,0x05,0x01},    // CNR_VE_TH_CR_H_SEL :
{0x9299,0x05,0x01},    // CNR_VE_TH_CR_L_SEL :
{0x929A,0x05,0x01},    // CNR_VE_TH_CR_M_H_SEL :
{0x929B,0x05,0x01},    // CNR_VE_TH_CR_M_L_SEL :
{0x929C,0x05,0x01},    // CNR_VE_TH_CB_H_SEL :
{0x929D,0x05,0x01},    // CNR_VE_TH_CB_L_SEL :
{0x929E,0x05,0x01},    // CNR_VE_TH_CB_M_H_SEL :
{0x929F,0x05,0x01},    // CNR_VE_TH_CB_M_L_SEL :
{0x92A0,0x05,0x01},    // CNR_COEF_CR_H_SEL :
{0x92A1,0x05,0x01},    // CNR_COEF_CR_L_SEL :
{0x92A2,0x05,0x01},    // CNR_COEF_CR_M_H_SEL :
{0x92A3,0x05,0x01},    // CNR_COEF_CR_M_L_SEL :
{0x92A4,0x05,0x01},    // CNR_COEF_CB_H_SEL :
{0x92A5,0x05,0x01},    // CNR_COEF_CB_L_SEL :
{0x92A6,0x05,0x01},    // CNR_COEF_CB_M_H_SEL :
{0x92A7,0x05,0x01},    // CNR_COEF_CB_M_L_SEL :
{0x92A8,0x05,0x01},    // CNR_EDGE_GAIN_CR_H_SEL :
{0x92A9,0x05,0x01},    // CNR_EDGE_GAIN_CR_L_SEL :
{0x92AA,0x05,0x01},    // CNR_EDGE_GAIN_CR_M_H_SEL :
{0x92AB,0x05,0x01},    // CNR_EDGE_GAIN_CR_M_L_SEL :
{0x92AC,0x05,0x01},    // CNR_EDGE_GAIN_CB_H_SEL :
{0x92AD,0x05,0x01},    // CNR_EDGE_GAIN_CB_L_SEL :
{0x92AE,0x05,0x01},    // CNR_EDGE_GAIN_CB_M_H_SEL :
{0x92AF,0x05,0x01},    // CNR_EDGE_GAIN_CB_M_L_SEL :
{0x92B0,0x05,0x01},    // CNR_EDGE_TH_CR_H_SEL :
{0x92B1,0x05,0x01},    // CNR_EDGE_TH_CR_L_SEL :
{0x92B2,0x05,0x01},    // CNR_EDGE_TH_CR_M_H_SEL :
{0x92B3,0x05,0x01},    // CNR_EDGE_TH_CR_M_L_SEL :
{0x92B4,0x05,0x01},    // CNR_EDGE_TH_CB_H_SEL :
{0x92B5,0x05,0x01},    // CNR_EDGE_TH_CB_L_SEL :
{0x92B6,0x05,0x01},    // CNR_EDGE_TH_CB_M_H_SEL :
{0x92B7,0x05,0x01},    // CNR_EDGE_TH_CB_M_L_SEL :

////////////////MWB & AWB Ʃ////////////
{0x6244,0x0B81,0x02},    // USER0R :
{0x6246,0x1832,0x02},    // USER0B :
{0x6248,0x0C9E,0x02},    // USER1R : Daylight
{0x624A,0x1766,0x02},    // USER1B :
{0x624C,0x09C8,0x02},    // USER2R : Cloudy
{0x624E,0x1A06,0x02},    // USER2B :
{0x6250,0x0D61,0x02},    // USER3R : Fluorescent
{0x6252,0x1161,0x02},    // USER3B :
{0x6254,0x130B,0x02},    // USER4R : A
{0x6256,0x0E92,0x02},    // USER4B :

{0x6270,0x0000,0x02},    // USER2_CONT_SHIFT_R : Cloudy cont shift
{0x6272,0x0000,0x02},    // USER2_CONT_SHIFT_B :
{0x62C6,0x1096,0x02},    // A_LIGHT_R :
{0x62C8,0x0F26,0x02},    // A_LIGHT_B :
{0x62CA,0x00B0,0x02},    // A_LIGHT_AIM_SHIFT_R :
{0x62CC,0x00C0,0x02},    // A_LIGHT_AIM_SHIFT_B :
{0x62CE,0x04,0x01},    // A_LIGHT_SCOPE_S_UP :
{0x62CF,0x04,0x01},    // A_LIGHT_SCOPE_S_DOWN :
{0x62D0,0x04,0x01},    // A_LIGHT_SCOPE_S_RIGHT :
{0x62D1,0x04,0x01},    // A_LIGHT_SCOPE_S_LEFT :
{0x62D2,0x14,0x01},    // A_LIGHT_SCOPE_L_UP :
{0x62D3,0x14,0x01},    // A_LIGHT_SCOPE_L_DOWN :
{0x62D4,0x14,0x01},    // A_LIGHT_SCOPE_L_RIGHT :
{0x62D5,0x14,0x01},    // A_LIGHT_SCOPE_L_LEFT :
{0x62D6,0x1217,0x02},    // H_LIGHT_R :
{0x62D8,0x0B95,0x02},    // H_LIGHT_B :
{0x62DA,0xFF7E,0x02},    // H_LIGHT_AIM_SHIFT_R :
{0x62DC,0xFF36,0x02},    // H_LIGHT_AIM_SHIFT_B :
{0x62DE,0x04,0x01},    // H_LIGHT_SCOPE_S_UP :
{0x62DF,0x04,0x01},    // H_LIGHT_SCOPE_S_DOWN :
{0x62E0,0x04,0x01},    // H_LIGHT_SCOPE_S_RIGHT :
{0x62E1,0x04,0x01},    // H_LIGHT_SCOPE_S_LEFT :
{0x62E2,0x14,0x01},    // H_LIGHT_SCOPE_L_UP :
{0x62E3,0x17,0x01},    // H_LIGHT_SCOPE_L_DOWN :
{0x62E4,0x26,0x01},    // H_LIGHT_SCOPE_L_RIGHT :
{0x62E5,0x19,0x01},    // H_LIGHT_SCOPE_L_LEFT :

/////MC3 Setting/////
{0x7600,0x07,0x01},    // MC3_PXDEF0_SEL :
{0x7601,0x07,0x01},    // MC3_PYDEF0_SEL :
{0x7602,0x07,0x01},    // MC3_PXDEF1_SEL :
{0x7603,0x07,0x01},    // MC3_PYDEF1_SEL :
{0x7604,0x07,0x01},    // MC3_PXDEF2_SEL :
{0x7605,0x07,0x01},    // MC3_PYDEF2_SEL :
{0x7606,0x07,0x01},    // MC3_PXDEF3_SEL :
{0x7607,0x07,0x01},    // MC3_PYDEF3_SEL :
{0x7608,0x40,0x01},    // MC3_PXDEF0_A :
{0x7609,0x40,0x01},    // MC3_PXDEF0_B :
{0x760A,0x40,0x01},    // MC3_PXDEF0_C :
{0x760B,0x40,0x01},    // MC3_PYDEF0_A :
{0x760C,0x40,0x01},    // MC3_PYDEF0_B :
{0x760D,0x40,0x01},    // MC3_PYDEF0_C :
{0x760E,0x40,0x01},    // MC3_PXDEF1_A :
{0x760F,0x40,0x01},    // MC3_PXDEF1_B :
{0x7610,0x40,0x01},    // MC3_PXDEF1_C :
{0x7611,0x40,0x01},    // MC3_PYDEF1_A :
{0x7612,0x40,0x01},    // MC3_PYDEF1_B :
{0x7613,0x40,0x01},    // MC3_PYDEF1_C :
{0x7614,0x40,0x01},    // MC3_PXDEF2_A :
{0x7615,0x40,0x01},    // MC3_PXDEF2_B :
{0x7616,0x40,0x01},    // MC3_PXDEF2_C :
{0x7617,0x40,0x01},    // MC3_PYDEF2_A :
{0x7618,0x40,0x01},    // MC3_PYDEF2_B :
{0x7619,0x40,0x01},    // MC3_PYDEF2_C :
{0x761A,0x40,0x01},    // MC3_PXDEF3_A :
{0x761B,0x40,0x01},    // MC3_PXDEF3_B :
{0x761C,0x40,0x01},    // MC3_PXDEF3_C :
{0x761D,0x40,0x01},    // MC3_PYDEF3_A :
{0x761E,0x40,0x01},    // MC3_PYDEF3_B :
{0x761F,0x40,0x01},    // MC3_PYDEF3_C :
{0x7620,0x00,0x01},    // MC3_LUMSL0_IN :
{0x7621,0x06,0x01},    // MC3_LUMSL1_IN :
{0x7622,0x03,0x01},    // MC3_LUMSL2_IN :
{0x7623,0x06,0x01},    // MC3_LUMSL3_IN :
{0x7624,0x00,0x01},    // MC3_LUMSL0_OUT :
{0x7625,0x03,0x01},    // MC3_LUMSL1_OUT :
{0x7626,0x00,0x01},    // MC3_LUMSL2_OUT :
{0x7627,0x00,0x01},    // MC3_LUMSL3_OUT :
{0x7628,0x0000,0x02},    // MC3_L0DEF0_IN :
{0x762A,0x008C,0x02},    // MC3_L0DEF1_IN :
{0x762C,0x0078,0x02},    // MC3_L0DEF2_IN :
{0x762E,0x00E6,0x02},    // MC3_L0DEF3_IN :
{0x7630,0x0000,0x02},    // MC3_L0DEF0_OUT :
{0x7632,0x0082,0x02},    // MC3_L0DEF1_OUT :
{0x7634,0x0000,0x02},    // MC3_L0DEF2_OUT :
{0x7636,0x0000,0x02},    // MC3_L0DEF3_OUT :
{0x7638,0x41,0x01},    // MC3_RDEF0_POS1 :
{0x7639,0x10,0x01},    // MC3_RDEF1_POS1 :
{0x763A,0x15,0x01},    // MC3_RDEF2_POS1 :
{0x763B,0x71,0x01},    // MC3_RDEF3_POS1 :
{0x763C,0x41,0x01},    // MC3_RDEF0_POS2 :
{0x763D,0x10,0x01},    // MC3_RDEF1_POS2 :
{0x763E,0x15,0x01},    // MC3_RDEF2_POS2 :
{0x763F,0x71,0x01},    // MC3_RDEF3_POS2 :
{0x7640,0x3C,0x01},    // MC3_RDEF0_POS3 :
{0x7641,0x10,0x01},    // MC3_RDEF1_POS3 :
{0x7642,0x15,0x01},    // MC3_RDEF2_POS3 :
{0x7643,0x71,0x01},    // MC3_RDEF3_POS3 :
{0x7644,0x46,0x01},    // MC3_RDEF0_POS4 :
{0x7645,0x32,0x01},    // MC3_RDEF1_POS4 :
{0x7646,0x15,0x01},    // MC3_RDEF2_POS4 :
{0x7647,0x71,0x01},    // MC3_RDEF3_POS4 :
{0x7648,0x46,0x01},    // MC3_RDEF0_POS5 :
{0x7649,0x32,0x01},    // MC3_RDEF1_POS5 :
{0x764A,0x15,0x01},    // MC3_RDEF2_POS5 :
{0x764B,0x71,0x01},    // MC3_RDEF3_POS5 :
{0x764C,0x46,0x01},    // MC3_RDEF0_POS6 :
{0x764D,0x10,0x01},    // MC3_RDEF1_POS6 :
{0x764E,0x15,0x01},    // MC3_RDEF2_POS6 :
{0x764F,0x71,0x01},    // MC3_RDEF3_POS6 :
{0x7650,0x46,0x01},    // MC3_RDEF0_POS7 :
{0x7651,0x10,0x01},    // MC3_RDEF1_POS7 :
{0x7652,0x15,0x01},    // MC3_RDEF2_POS7 :
{0x7653,0x71,0x01},    // MC3_RDEF3_POS7 :
{0x7654,0x2D,0x01},    // MC3_RDEF0_OUT :
{0x7655,0x10,0x01},    // MC3_RDEF1_OUT :
{0x7656,0x15,0x01},    // MC3_RDEF2_OUT :
{0x7657,0x54,0x01},    // MC3_RDEF3_OUT :
{0x7658,0x46,0x01},    // MC3_RDEF0_R2_POS4 :
{0x7659,0x32,0x01},    // MC3_RDEF1_R2_POS4 :
{0x765A,0x15,0x01},    // MC3_RDEF2_R2_POS4 :
{0x765B,0x71,0x01},    // MC3_RDEF3_R2_POS4 :
{0x765C,0x46,0x01},    // MC3_RDEF0_R2_POS5 :
{0x765D,0x32,0x01},    // MC3_RDEF1_R2_POS5 :
{0x765E,0x15,0x01},    // MC3_RDEF2_R2_POS5 :
{0x765F,0x71,0x01},    // MC3_RDEF3_R2_POS5 :
{0x7660,0xFFBA,0x02},    // MC3_X0DEF0_POS1 :
{0x7662,0xFFBA,0x02},    // MC3_Y0DEF0_POS1 :
{0x7664,0xFFFE,0x02},    // MC3_X0DEF1_POS1 :
{0x7666,0x000D,0x02},    // MC3_Y0DEF1_POS1 :
{0x7668,0x0002,0x02},    // MC3_X0DEF2_POS1 :
{0x766A,0xFFF6,0x02},    // MC3_Y0DEF2_POS1 :
{0x766C,0x003B,0x02},    // MC3_X0DEF3_POS1 :
{0x766E,0xFFBB,0x02},    // MC3_Y0DEF3_POS1 :
{0x7670,0xFFBA,0x02},    // MC3_X0DEF0_POS2 :
{0x7672,0xFFBA,0x02},    // MC3_Y0DEF0_POS2 :
{0x7674,0xFFFE,0x02},    // MC3_X0DEF1_POS2 :
{0x7676,0x000D,0x02},    // MC3_Y0DEF1_POS2 :
{0x7678,0x0002,0x02},    // MC3_X0DEF2_POS2 :
{0x767A,0xFFF6,0x02},    // MC3_Y0DEF2_POS2 :
{0x767C,0x003B,0x02},    // MC3_X0DEF3_POS2 :
{0x767E,0xFFBB,0x02},    // MC3_Y0DEF3_POS2 :
{0x7680,0xFFCE,0x02},    // MC3_X0DEF0_POS3 :
{0x7682,0xFFBA,0x02},    // MC3_Y0DEF0_POS3 :
{0x7684,0xFFFE,0x02},    // MC3_X0DEF1_POS3 :
{0x7686,0x000D,0x02},    // MC3_Y0DEF1_POS3 :
{0x7688,0x0002,0x02},    // MC3_X0DEF2_POS3 :
{0x768A,0xFFF6,0x02},    // MC3_Y0DEF2_POS3 :
{0x768C,0x003B,0x02},    // MC3_X0DEF3_POS3 :
{0x768E,0xFFBB,0x02},    // MC3_Y0DEF3_POS3 :
{0x7690,0xFFCE,0x02},    // MC3_X0DEF0_POS4 :
{0x7692,0xFFC9,0x02},    // MC3_Y0DEF0_POS4 :
{0x7694,0xFFD0,0x02},    // MC3_X0DEF1_POS4 :
{0x7696,0x0037,0x02},    // MC3_Y0DEF1_POS4 :
{0x7698,0x0002,0x02},    // MC3_X0DEF2_POS4 :
{0x769A,0xFFF6,0x02},    // MC3_Y0DEF2_POS4 :
{0x769C,0x003B,0x02},    // MC3_X0DEF3_POS4 :
{0x769E,0xFFBB,0x02},    // MC3_Y0DEF3_POS4 :
{0x76A0,0xFFCE,0x02},    // MC3_X0DEF0_POS5 :
{0x76A2,0xFFC9,0x02},    // MC3_Y0DEF0_POS5 :
{0x76A4,0xFFD0,0x02},    // MC3_X0DEF1_POS5 :
{0x76A6,0x0037,0x02},    // MC3_Y0DEF1_POS5 :
{0x76A8,0x0002,0x02},    // MC3_X0DEF2_POS5 :
{0x76AA,0xFFF6,0x02},    // MC3_Y0DEF2_POS5 :
{0x76AC,0x003B,0x02},    // MC3_X0DEF3_POS5 :
{0x76AE,0xFFBB,0x02},    // MC3_Y0DEF3_POS5 :
{0x76B0,0xFFCE,0x02},    // MC3_X0DEF0_POS6 :
{0x76B2,0xFFC9,0x02},    // MC3_Y0DEF0_POS6 :
{0x76B4,0xFFFE,0x02},    // MC3_X0DEF1_POS6 :
{0x76B6,0x000D,0x02},    // MC3_Y0DEF1_POS6 :
{0x76B8,0x0002,0x02},    // MC3_X0DEF2_POS6 :
{0x76BA,0xFFF6,0x02},    // MC3_Y0DEF2_POS6 :
{0x76BC,0x003B,0x02},    // MC3_X0DEF3_POS6 :
{0x76BE,0xFFBB,0x02},    // MC3_Y0DEF3_POS6 :
{0x76C0,0xFFCE,0x02},    // MC3_X0DEF0_POS7 :
{0x76C2,0xFFC9,0x02},    // MC3_Y0DEF0_POS7 :
{0x76C4,0xFFFE,0x02},    // MC3_X0DEF1_POS7 :
{0x76C6,0x000D,0x02},    // MC3_Y0DEF1_POS7 :
{0x76C8,0x0002,0x02},    // MC3_X0DEF2_POS7 :
{0x76CA,0xFFF6,0x02},    // MC3_Y0DEF2_POS7 :
{0x76CC,0x003B,0x02},    // MC3_X0DEF3_POS7 :
{0x76CE,0xFFBB,0x02},    // MC3_Y0DEF3_POS7 :
{0x76D0,0xFF7E,0x02},    // MC3_X0DEF0_OUT :
{0x76D2,0xFFE2,0x02},    // MC3_Y0DEF0_OUT :
{0x76D4,0xFFFE,0x02},    // MC3_X0DEF1_OUT :
{0x76D6,0x000D,0x02},    // MC3_Y0DEF1_OUT :
{0x76D8,0x0002,0x02},    // MC3_X0DEF2_OUT :
{0x76DA,0xFFF6,0x02},    // MC3_Y0DEF2_OUT :
{0x76DC,0xFFC4,0x02},    // MC3_X0DEF3_OUT :
{0x76DE,0xFFEC,0x02},    // MC3_Y0DEF3_OUT :
{0x76E0,0xFFCE,0x02},    // MC3_X0DEF0_R2_POS4 :
{0x76E2,0xFFC9,0x02},    // MC3_Y0DEF0_R2_POS4 :
{0x76E4,0xFFD0,0x02},    // MC3_X0DEF1_R2_POS4 :
{0x76E6,0x0037,0x02},    // MC3_Y0DEF1_R2_POS4 :
{0x76E8,0x0002,0x02},    // MC3_X0DEF2_R2_POS4 :
{0x76EA,0xFFF6,0x02},    // MC3_Y0DEF2_R2_POS4 :
{0x76EC,0x003B,0x02},    // MC3_X0DEF3_R2_POS4 :
{0x76EE,0xFFBB,0x02},    // MC3_Y0DEF3_R2_POS4 :
{0x76F0,0xFFCE,0x02},    // MC3_X0DEF0_R2_POS5 :
{0x76F2,0xFFC9,0x02},    // MC3_Y0DEF0_R2_POS5 :
{0x76F4,0xFFD0,0x02},    // MC3_X0DEF1_R2_POS5 :
{0x76F6,0x0037,0x02},    // MC3_Y0DEF1_R2_POS5 :
{0x76F8,0x0002,0x02},    // MC3_X0DEF2_R2_POS5 :
{0x76FA,0xFFF6,0x02},    // MC3_Y0DEF2_R2_POS5 :
{0x76FC,0x003B,0x02},    // MC3_X0DEF3_R2_POS5 :
{0x76FE,0xFFBB,0x02},    // MC3_Y0DEF3_R2_POS5 :
{0x7700,0x0019,0x02},    // MC3_PXDEF0_POS1 :
{0x7702,0xFF66,0x02},    // MC3_PYDEF0_POS1 :
{0x7704,0x0000,0x02},    // MC3_PXDEF1_POS1 :
{0x7706,0x0000,0x02},    // MC3_PYDEF1_POS1 :
{0x7708,0x0000,0x02},    // MC3_PXDEF2_POS1 :
{0x770A,0x0000,0x02},    // MC3_PYDEF2_POS1 :
{0x770C,0xFFD7,0x02},    // MC3_PXDEF3_POS1 :
{0x770E,0x0068,0x02},    // MC3_PYDEF3_POS1 :
{0x7710,0x0000,0x02},    // MC3_PXDEF0_POS2 :
{0x7712,0xFF66,0x02},    // MC3_PYDEF0_POS2 :
{0x7714,0x0033,0x02},    // MC3_PXDEF1_POS2 :
{0x7716,0xFF4C,0x02},    // MC3_PYDEF1_POS2 :
{0x7718,0x0000,0x02},    // MC3_PXDEF2_POS2 :
{0x771A,0x00B3,0x02},    // MC3_PYDEF2_POS2 :
{0x771C,0xFFD7,0x02},    // MC3_PXDEF3_POS2 :
{0x771E,0x0068,0x02},    // MC3_PYDEF3_POS2 :
{0x7720,0x0000,0x02},    // MC3_PXDEF0_POS3 :
{0x7722,0xFF80,0x02},    // MC3_PYDEF0_POS3 :
{0x7724,0x0000,0x02},    // MC3_PXDEF1_POS3 :
{0x7726,0x0000,0x02},    // MC3_PYDEF1_POS3 :
{0x7728,0x0000,0x02},    // MC3_PXDEF2_POS3 :
{0x772A,0x0000,0x02},    // MC3_PYDEF2_POS3 :
{0x772C,0xFFD7,0x02},    // MC3_PXDEF3_POS3 :
{0x772E,0x0068,0x02},    // MC3_PYDEF3_POS3 :
{0x7730,0x0000,0x02},    // MC3_PXDEF0_POS4 :
{0x7732,0xFFCC,0x02},    // MC3_PYDEF0_POS4 :
{0x7734,0x0000,0x02},    // MC3_PXDEF1_POS4 :
{0x7736,0x0000,0x02},    // MC3_PYDEF1_POS4 :
{0x7738,0x0000,0x02},    // MC3_PXDEF2_POS4 :
{0x773A,0x0000,0x02},    // MC3_PYDEF2_POS4 :
{0x773C,0xFFD7,0x02},    // MC3_PXDEF3_POS4 :
{0x773E,0x0068,0x02},    // MC3_PYDEF3_POS4 :
{0x7740,0x0000,0x02},    // MC3_PXDEF0_POS5 :
{0x7742,0xFFCC,0x02},    // MC3_PYDEF0_POS5 :
{0x7744,0x0000,0x02},    // MC3_PXDEF1_POS5 :
{0x7746,0x0000,0x02},    // MC3_PYDEF1_POS5 :
{0x7748,0x0000,0x02},    // MC3_PXDEF2_POS5 :
{0x774A,0x0000,0x02},    // MC3_PYDEF2_POS5 :
{0x774C,0xFFD7,0x02},    // MC3_PXDEF3_POS5 :
{0x774E,0x0068,0x02},    // MC3_PYDEF3_POS5 :
{0x7750,0xFFB3,0x02},    // MC3_PXDEF0_POS6 :
{0x7752,0x0000,0x02},    // MC3_PYDEF0_POS6 :
{0x7754,0x0033,0x02},    // MC3_PXDEF1_POS6 :
{0x7756,0xFF4C,0x02},    // MC3_PYDEF1_POS6 :
{0x7758,0x0000,0x02},    // MC3_PXDEF2_POS6 :
{0x775A,0x00B3,0x02},    // MC3_PYDEF2_POS6 :
{0x775C,0xFFD7,0x02},    // MC3_PXDEF3_POS6 :
{0x775E,0x0068,0x02},    // MC3_PYDEF3_POS6 :
{0x7760,0xFFB3,0x02},    // MC3_PXDEF0_POS7 :
{0x7762,0x0000,0x02},    // MC3_PYDEF0_POS7 :
{0x7764,0x0000,0x02},    // MC3_PXDEF1_POS7 :
{0x7766,0x0000,0x02},    // MC3_PYDEF1_POS7 :
{0x7768,0x0000,0x02},    // MC3_PXDEF2_POS7 :
{0x776A,0x0000,0x02},    // MC3_PYDEF2_POS7 :
{0x776C,0xFFD7,0x02},    // MC3_PXDEF3_POS7 :
{0x776E,0x0068,0x02},    // MC3_PYDEF3_POS7 :
{0x7770,0x0019,0x02},    // MC3_PXDEF0_OUT :
{0x7772,0xFFE6,0x02},    // MC3_PYDEF0_OUT :
{0x7774,0x0000,0x02},    // MC3_PXDEF1_OUT :
{0x7776,0x0000,0x02},    // MC3_PYDEF1_OUT :
{0x7778,0x0000,0x02},    // MC3_PXDEF2_OUT :
{0x777A,0x0000,0x02},    // MC3_PYDEF2_OUT :
{0x777C,0xFFE1,0x02},    // MC3_PXDEF3_OUT :
{0x777E,0xFFEB,0x02},    // MC3_PYDEF3_OUT :
{0x7780,0x0000,0x02},    // MC3_PXDEF0_R2_POS4 :
{0x7782,0xFFCC,0x02},    // MC3_PYDEF0_R2_POS4 :
{0x7784,0x0000,0x02},    // MC3_PXDEF1_R2_POS4 :
{0x7786,0x0000,0x02},    // MC3_PYDEF1_R2_POS4 :
{0x7788,0x0000,0x02},    // MC3_PXDEF2_R2_POS4 :
{0x778A,0x0000,0x02},    // MC3_PYDEF2_R2_POS4 :
{0x778C,0xFFD7,0x02},    // MC3_PXDEF3_R2_POS4 :
{0x778E,0x0068,0x02},    // MC3_PYDEF3_R2_POS4 :
{0x7790,0x0000,0x02},    // MC3_PXDEF0_R2_POS5 :
{0x7792,0xFFCC,0x02},    // MC3_PYDEF0_R2_POS5 :
{0x7794,0x0000,0x02},    // MC3_PXDEF1_R2_POS5 :
{0x7796,0x0000,0x02},    // MC3_PYDEF1_R2_POS5 :
{0x7798,0x0000,0x02},    // MC3_PXDEF2_R2_POS5 :
{0x779A,0x0000,0x02},    // MC3_PYDEF2_R2_POS5 :
{0x779C,0xFFD7,0x02},    // MC3_PXDEF3_R2_POS5 :
{0x779E,0x0068,0x02},    // MC3_PYDEF3_R2_POS5 :


{0x6C44,0x13,0x01},    // G_CTRL_SEL :
{0x0363,0x95,0x01},    // PICT3_GAMMA_MONI1 :
{0x0366,0x95,0x01},    // PICT3_GAMMA_CAP1 :


///////Scene Mode Setting////////////
{0x0282,0x20,0x01},    //AWB_SN1 :
{0x0283,0x20,0x01},    //AWB_SN2 :
{0x0284,0x20,0x01},    //AWB_SN3 :
{0x0285,0x20,0x01},    //AWB_SN4 :
{0x0286,0x20,0x01},    //AWB_SN5 :
{0x0287,0x25,0x01},    //AWB_SN6 :
{0x0288,0x20,0x01},    //AWB_SN7 :
{0x0289,0x20,0x01},    //AWB_SN8 :
{0x028A,0x20,0x01},    //AWB_SN9 :
{0x028B,0x20,0x01},    //AWB_SN10 :
{0x028C,0x20,0x01},    //AWB_SN11 :
{0x028D,0x20,0x01},    //AWB_SN12 :
{0x028E,0x00,0x01},    //AF_SN1_2 :
{0x028F,0x00,0x01},    //AF_SN3_4 :
{0x0290,0x00,0x01},    //AF_SN5_6 :
{0x0291,0x00,0x01},    //AF_SN7_8 :
{0x0292,0x00,0x01},    //AF_SN9_10 :
{0x0293,0x00,0x01},    //AF_SN11_12 :
{0x0294,0x00,0x01},    //AE_SN1 :
{0x0295,0x00,0x01},    //AE_SN2 :
{0x0296,0x00,0x01},    //AE_SN3 :
{0x0297,0x40,0x01},    //AE_SN4 :
{0x0298,0x20,0x01},    //AE_SN5 :
{0x0299,0x00,0x01},    //AE_SN6 :
{0x029A,0x00,0x01},    //AE_SN7 :
{0x029B,0x00,0x01},    //AE_SN8 :
{0x029C,0x60,0x01},    //AE_SN9 :
{0x029D,0x00,0x01},    //AE_SN10 :
{0x029E,0x00,0x01},    //AE_SN11 :
{0x029F,0x00,0x01},    //AE_SN12 :
{0x02A8,0x00,0x01},    //ISO_TYPE1 : AUTO
{0x02A9,0x04,0x01},    //ISO_TYPE2 : ISO50
{0x02AA,0x0A,0x01},    //ISO_TYPE3 : ISO200
{0x02AB,0x00,0x01},    //ISO_TYPE4 : AUTO
{0x02AC,0x01,0x01},    //AE_SUB_SN1 :
{0x02AD,0x00,0x01},    //AE_SUB_SN2 :
{0x02AE,0x01,0x01},    //AE_SUB_SN3 :
{0x02AF,0x01,0x01},    //AE_SUB_SN4 :
{0x02B0,0x01,0x01},    //AE_SUB_SN5 :
{0x02B1,0x01,0x01},    //AE_SUB_SN6 :
{0x02B2,0x01,0x01},    //AE_SUB_SN7 :
{0x02B3,0x01,0x01},    //AE_SUB_SN8 :
{0x02B4,0x01,0x01},    //AE_SUB_SN9 :
{0x02B5,0x01,0x01},    //AE_SUB_SN10 :
{0x02B6,0x02,0x01},    //AE_SUB_SN11 :
{0x02B7,0x01,0x01},    //AE_SUB_SN12 :
{0x02EA,0x00,0x01},    //EVREF_MONI_SN1_2 :
{0x02EB,0x00,0x01},    //EVREF_MONI_SN3_4 :
{0x02EC,0x03,0x01},    //EVREF_MONI_SN5_6 :
{0x02ED,0x00,0x01},    //EVREF_MONI_SN7_8 :
{0x02EE,0x00,0x01},    //EVREF_MONI_SN9_10 :
{0x02EF,0x00,0x01},    //EVREF_MONI_SN11_12 :
{0x02F0,0x01,0x01},    //EVREF_CAP_SN1_2 :
{0x02F1,0x00,0x01},    //EVREF_CAP_SN3_4 :
{0x02F2,0x03,0x01},    //EVREF_CAP_SN5_6 :
{0x02F3,0x00,0x01},    //EVREF_CAP_SN7_8 :
{0x02F4,0x00,0x01},    //EVREF_CAP_SN9_10 :
{0x02F5,0x00,0x01},    //EVREF_CAP_SN11_12 :
{0x02F6,0x00,0x01},    //EVREF_MOVIE_SN1_2 :
{0x02F7,0x00,0x01},    //EVREF_MOVIE_SN3_4 :
{0x02F8,0x03,0x01},    //EVREF_MOVIE_SN5_6 :
{0x02F9,0x00,0x01},    //EVREF_MOVIE_SN7_8 :
{0x02FA,0x00,0x01},    //EVREF_MOVIE_SN9_10 :
{0x02FB,0x00,0x01},    //EVREF_MOVIE_SN11_12 :
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x0390,0xA4,0x01},    //PICT1_SN2 :
{0x0391,0x00,0x01},    //PICT1_SN3 :
{0x0392,0x04,0x01},    //PICT1_SN4 :
{0x0393,0x04,0x01},    //PICT1_SN5 :
{0x0394,0x00,0x01},    //PICT1_SN6 :
{0x0395,0x50,0x01},    //PICT1_SN7 :
{0x0396,0x0A,0x01},    //PICT1_SN8 :
{0x0397,0x00,0x01},    //PICT1_SN9 :
{0x0398,0xA0,0x01},    //PICT1_SN10 :
{0x0399,0x00,0x01},    //PICT1_SN11 :
{0x039A,0x00,0x01},    //PICT1_SN12 :
{0x039B,0x00,0x01},    //UIHUE_TYPE1 :
{0x039C,0x00,0x01},    //UIHUE_TYPE2 :
{0x039D,0x00,0x01},    //UIHUE_TYPE3 :
{0x039E,0x80,0x01},    //UISATURATION_TYPE1 :
{0x039F,0x9E,0x01},    //UISATURATION_TYPE2 :
{0x03A0,0x80,0x01},    //UISATURATION_TYPE3 :
{0x03A1,0x20,0x01},    //UISHARPNESS_POS_TYPE1 :
{0x03A2,0x14,0x01},    //UISHARPNESS_POS_TYPE2 :
{0x03A3,0x2C,0x01},    //UISHARPNESS_POS_TYPE3 :
{0x03A4,0x20,0x01},    //UISHARPNESS_NEG_TYPE1 :
{0x03A5,0x14,0x01},    //UISHARPNESS_NEG_TYPE2 :
{0x03A6,0x2C,0x01},    //UISHARPNESS_NEG_TYPE3 :
{0x0308,0x11,0x01},    //AELINE_MONI_SN1_2 :
{0x0309,0x13,0x01},    //AELINE_MONI_SN3_4 :
{0x030A,0x11,0x01},    //AELINE_MONI_SN5_6 :
{0x030B,0x41,0x01},    //AELINE_MONI_SN7_8 :
{0x030C,0x19,0x01},    //AELINE_MONI_SN9_10 :
{0x030D,0x11,0x01},    //AELINE_MONI_SN11_12 :
{0x030E,0x11,0x01},    //AELINE_HALF_SN1_2 :
{0x030F,0x13,0x01},    //AELINE_HALF_SN3_4 :
{0x0310,0x11,0x01},    //AELINE_HALF_SN5_6 :
{0x0311,0x41,0x01},    //AELINE_HALF_SN7_8 :
{0x0312,0x19,0x01},    //AELINE_HALF_SN9_10 :
{0x0313,0x11,0x01},    //AELINE_HALF_SN11_12 :
{0x0314,0x11,0x01},    //AELINE_HALF_AFEND_SN1_2 :
{0x0315,0x13,0x01},    //AELINE_HALF_AFEND_SN3_4 :
{0x0316,0x11,0x01},    //AELINE_HALF_AFEND_SN5_6 :
{0x0317,0x41,0x01},    //AELINE_HALF_AFEND_SN7_8 :
{0x0318,0x19,0x01},    //AELINE_HALF_AFEND_SN9_10 :
{0x0319,0x11,0x01},    //AELINE_HALF_AFEND_SN11_12 :
{0x031A,0x00,0x01},    //AELINE_CAP_SN1_2 :
{0x031B,0x03,0x01},    //AELINE_CAP_SN3_4 :
{0x031C,0x00,0x01},    //AELINE_CAP_SN5_6 :
{0x031D,0x50,0x01},    //AELINE_CAP_SN7_8 :
{0x031E,0x08,0x01},    //AELINE_CAP_SN9_10 :
{0x031F,0x00,0x01},    //AELINE_CAP_SN11_12 :
{0x0320,0x22,0x01},    //AELINE_MOVIE_SN1_2 :
{0x0321,0x22,0x01},    //AELINE_MOVIE_SN3_4 :
{0x0322,0x22,0x01},    //AELINE_MOVIE_SN5_6 :
{0x0323,0x22,0x01},    //AELINE_MOVIE_SN7_8 :
{0x0324,0x22,0x01},    //AELINE_MOVIE_SN9_10 :
{0x0325,0x22,0x01},    //AELINE_MOVIE_SN11_12 :
{0x02DB,0x33,0x01},    //VADD_SHTGAIN_CTRL_SN1_2 :
{0x02DC,0x33,0x01},    //VADD_SHTGAIN_CTRL_SN3_4 :
{0x02DD,0x33,0x01},    //VADD_SHTGAIN_CTRL_SN5_6 :
{0x02DE,0x33,0x01},    //VADD_SHTGAIN_CTRL_SN7_8 :
{0x02DF,0x33,0x01},    //VADD_SHTGAIN_CTRL_SN9_10 :
{0x02E0,0x33,0x01},    //VADD_SHTGAIN_CTRL_SN11_12 :
{0x0383,0x80,0x01},    // MC3_MODE_SN_1 :
{0x0384,0x80,0x01},    // MC3_MODE_SN_2 :
{0x0385,0x80,0x01},    // MC3_MODE_SN_3 :
{0x0386,0x80,0x01},    // MC3_MODE_SN_4 :
{0x0387,0x80,0x01},    // MC3_MODE_SN_5 :
{0x0388,0x80,0x01},    // MC3_MODE_SN_6 :
{0x0389,0x80,0x01},    // MC3_MODE_SN_7 :
{0x038A,0x80,0x01},    // MC3_MODE_SN_8 :
{0x038B,0x80,0x01},    // MC3_MODE_SN_9 :
{0x038C,0x80,0x01},    // MC3_MODE_SN_10 :
{0x038D,0x80,0x01},    // MC3_MODE_SN_11 :
{0x038E,0x80,0x01},    // MC3_MODE_SN_12 :

///AWBʱǥ
{0x6238,0x0BE3,0x02},    // INIT_CONT_INR :
{0x623A,0x1718,0x02},    // INIT_CONT_INB :
{0x623C,0x0BBB,0x02},    // INIT_CONT_OUTR :
{0x623E,0x18B7,0x02},    // INIT_CONT_OUTB :

//bluesky brightness setting
{0x6298,0xB0,0x01},    // SHADE_JUDGPOS :
{0x6299,0xB5,0x01},    // BLUESKY_JUDGPOS :

//EV SEL gain step
{0x5E6B,0x04,0x01},    // EVSEL_GAIN_P1_3 :
{0x5E6C,0x08,0x01},    // EVSEL_GAIN_P2_3 :
{0x5E6D,0x0C,0x01},    // EVSEL_GAIN_P3_3 :
{0x5E6E,0x10,0x01},    // EVSEL_GAIN_P4_3 :
{0x5E6F,0x14,0x01},    // EVSEL_GAIN_P5_3 :
{0x5E70,0x18,0x01},    // EVSEL_GAIN_P6_3 :
{0x5E71,0x05,0x01},    // EVSEL_GAIN_M1_3 :
{0x5E72,0x0A,0x01},    // EVSEL_GAIN_M2_3 :
{0x5E73,0x0F,0x01},    // EVSEL_GAIN_M3_3 :
{0x5E74,0x16,0x01},    // EVSEL_GAIN_M4_3 :
{0x5E75,0x1B,0x01},    // EVSEL_GAIN_M5_3 :
{0x5E76,0x20,0x01},    // EVSEL_GAIN_M6_3 :

//In, Out judge
{0x62A2,0x8C,0x01},    // INOUT_WEIGHT_AREA_ST : 140
{0x6258,0xA0,0x01},    // IN_JUDGPOS : 160
{0x6259,0xA1,0x01},    // OUT_JUDGPOS : 161
{0x62A3,0xA4,0x01},    // INOUT_WEIGHT_AREA_ED : 164
{0x62A4,0x92,0x01},    // IN_LUMST : 146
{0x62A5,0x9C,0x01},    // OUT_LUMST : 156

//ISO output setting
{0x5E3F,0x00,0x01},    // ISOSENS_OUT_SEL :

/* ++CONFIG_MACH_KONA */
{0x008C,0x03,0x01},
{0x008D,0x03,0x01},
{0x008E,0x03,0x01},
{0x0082,0x01,0x01},
/* --CONFIG_MACH_KONA */
};

// ISX012-0
// MIPI 2LANE      648
//        PLL   648MHz
//        DCK       81
// inifile
// size address data
//
static const isx012_regset_t ISX012_Pll_Setting_2[] =
{
{0x0007,0x01,0x01},                   // PLL_CKSEL                 : PLL 648MHz
{0x0008,0x03,0x01},                   // SRCCK_DIV                 : 1/8 frequency

{0x0004,0x03,0x01},                  //I2C_ADR_SEL 2: 0x3C MIPI selected, 3: 0x3D MIPI selected
{0x5008,0x00,0x01},                  //ENDIAN_SEL : 0:Little Endian
{0x6DA8,0x01,0x01},                  //SHD_CoEF (OTP shading ON flag)
{0x6DA9,0x09,0x01},                  // WHITE_CTRL
{0x6DCB,0x22,0x01},    // YGAM_CONFIG2 :

{0x00C4,0x11,0x01},                   // VIF_CLKCONFIG1            : VIFSEL and VIFDIV setting value with full frame pixel setting for other then JPG
{0x00C5,0x11,0x01},                   // VIF_CLKCONFIG2            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other then JPG
{0x00C6,0x11,0x01},                   // VIF_CLKCONFIG3            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other then JPG
{0x00C7,0x11,0x01},                   // VIF_CLKCONFIG4            : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other then JPG
{0x00C8,0x11,0x01},                   // VIF_CLKCONFIG5            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00C9,0x11,0x01},                   // VIF_CLKCONFIG6            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00CA,0x11,0x01},                   // VIF_CLKCONFIG7            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for JPG mode
{0x018C,0x0000,0x02},                // VADJ_SENS_1_1             : VMAX adjustment value for full frame pixel
{0x018E,0x0000,0x02},                // VADJ_SENS_1_2             : VMAX adjustment value for 1/2 sub-sampling
{0x0190,0x0000,0x02},                // VADJ_SENS_1_4             : VMAX adjustment value for 1/4 sub-sampling
{0x0192,0x0000,0x02},                // VADJ_SENS_1_8             : VMAX adjustment value for 1/8 sub-sampling
{0x0194,0x0000,0x02},                // VADJ_SENS_HD_1_1          : VMAX adjustment value for HD full frame pixel
{0x0196,0x0000,0x02},                // VADJ_SENS_HD_1_2          : VMAX adjustment value for HD 1/2 sub-sampling
{0x6A16,0x0400,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_1 : Detection window vertical size with all 32 windows for FLC full frame pixel
{0x6A18,0x03C0,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_2 : Detection window vertical size with all 32 windows for FLC 1/2 sub-sampling
{0x6A1A,0x01E0,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_4 : Detection window vertical size with all 32 windows for FLC 1/4 sub-sampling
{0x6A1C,0x00E0,0x02},                // FLC_OPD_HEIGHT_NORMAL_1_8 : Detection window vertical size with all 32 windows for FLC 1/8 sub-sampling
{0x6A1E,0x0400,0x02},                // FLC_OPD_HEIGHT_HD_1_1     : Detection window vertical size with all 32 windows for FLC HD full frame pixel
{0x6A20,0x02C0,0x02},                // FLC_OPD_HEIGHT_HD_1_2     : Detection window vertical size with all 32 windows for FLC HD 1/2 sub-sampling
{0x0016,0x0010,0x02},                // GPIO_FUNCSEL              : GPIO setting
{0x5C01,0x00,0x01},                   // RGLANESEL                 : Select 1Lane or 2Lane

{0x5C04,0x06,0x01},                   // RGTLPX                    : //0x5C04   0x4  ->  0x6
{0x5C05,0x05,0x01},                   // RGTCLKPREPARE             : //0x5C05   0x3  ->  0x5
{0x5C06,0x14,0x01},                   // RGTCLKZERO                :
{0x5C07,0x02,0x01},                   // RGTCLKPRE                 :
{0x5C08,0x0D,0x01},                   // RGTCLKPOST                : //0x5C08   0x11 ->  0xD
{0x5C09,0x07,0x01},                   // RGTCLKTRAIL               : //0x5C09   0x5  ->  0x7
{0x5C0A,0x0A,0x01},                   // RGTHSEXIT                 : //0x5C0A   0x7  ->  0xA
{0x5C0B,0x05,0x01},                   // RGTHSPREPARE              : //0x5C0B   0x3  ->  0x5
{0x5C0C,0x08,0x01},                   // RGTHSZERO                 : //0x5C0C   0x7  ->  0x8
{0x5C0D,0x07,0x01},                   // RGTHSTRAIL                : //0x5C0D   0x5  ->  0x7

{0x0009,0x01,0x01},                 // EXT_PLL_CKSEL       : PLL 648MHz
{0x00D0,0x11,0x01},                 // VIF_CLKCONFIG_EXT1  : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG and interleave mode
{0x00D1,0x11,0x01},                 // VIF_CLKCONFIG_EXT2  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG and interleave mode
{0x00D4,0x11,0x01},                 // VIF_CLKCONFIG_EXT5  : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00D5,0x11,0x01},                 // VIF_CLKCONFIG_EXT6  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00D8,0x11,0x01},                 // VIF_CLKCONFIG_EXT9  : VIFSEL and VIFDIV setting value with full frame pixel setting for other than JPG
{0x00D9,0x11,0x01},                 // VIF_CLKCONFIG_EXT10 : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other than JPG

//init Preview setting
{0x0089,0x00,0x01},//OUTFMT_MONI
{0x0090,0x0280,0x02},//HSIZE_MONI : 640
{0x0096,0x01E0,0x02},//VSIZE_MONI : 480
{0x0083,0x01,0x01},//SENSMODE_MONI
{0x0086,0x02,0x01},//FPSTYPE_MONI
{0x0081,0x00,0x01},//MODESEL
{0x0082,0x01,0x01},//MONI_REFRESH

//jpeg setting
//Apex40 is not Jpeg Capture

//Fast mode setting
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT

//Select sensor inversion link control
{0x501A,0x00,0x01},    //SENS_REVERSE_CTRL

//shading
{0x6DBC,0x03,0x01},    // WHITE_EDGE_MAX :
{0x6DF6,0xFF,0x01},    // WHITE_SHD_JUDGE_BODY_COLOR_RATIO :
{0x6DF7,0xF0,0x01},    // WHITE_SHD_JUDGE_RED_RATIO :
{0x6DAD,0x0C,0x01},    // WHITE_OFSET1_UP :
{0x6DAE,0x0C,0x01},    // WHITE_OFSET1_DOWN :
{0x6DAF,0x11,0x01},    // WHITE_OFSET1_RIGHT :
{0x6DB0,0x1B,0x01},    // WHITE_OFSET1_LEFT :
{0x6DB1,0x0D,0x01},    // WHITE_OFSET2_UP :
{0x6DB2,0x13,0x01},    // WHITE_OFSET2_DOWN :
{0x6DB3,0x11,0x01},    // WHITE_OFSET2_RIGHT :
{0x6DB4,0x17,0x01},    // WHITE_OFSET2_LEFT :

//addtional code
{0xF200,0xB9B9,0x02},
{0xF202,0x4E12,0x02},
{0xF204,0x6055,0x02},
{0xF206,0x008B,0x02},
{0xF208,0xF177,0x02},
{0xF20A,0xFA70,0x02},
{0xF20C,0x0000,0x02},
{0xF20E,0x0000,0x02},
{0xF210,0x0000,0x02},
{0xF212,0x0000,0x02},
{0xF214,0x0000,0x02},
{0xF216,0x0000,0x02},
{0xF218,0x0000,0x02},
{0xF21A,0x0000,0x02},
{0xF21C,0x0000,0x02},
{0xF21E,0x0000,0x02},
{0xF220,0x0000,0x02},
{0xF222,0x0000,0x02},
{0xF224,0x0000,0x02},
{0xF226,0x0000,0x02},
{0xF228,0x0000,0x02},
{0xF22A,0x0000,0x02},
{0xF22C,0x0000,0x02},
{0xF22E,0x0000,0x02},
{0xF230,0x0000,0x02},
{0xF232,0x0000,0x02},
{0xF234,0x0000,0x02},
{0xF236,0x0000,0x02},
{0xF238,0x0000,0x02},
{0xF23A,0x0000,0x02},
{0xF23C,0x0000,0x02},
{0xF23E,0x0000,0x02},
{0xF240,0x0000,0x02},
{0xF242,0x0000,0x02},
{0xF244,0xB47E,0x02},
{0xF246,0x4808,0x02},
{0xF248,0x7800,0x02},
{0xF24A,0x07C0,0x02},
{0xF24C,0x0FC0,0x02},
{0xF24E,0xF687,0x02},
{0xF250,0xF8ED,0x02},
{0xF252,0xF68E,0x02},
{0xF254,0xFE2B,0x02},
{0xF256,0xF688,0x02},
{0xF258,0xFF6B,0x02},
{0xF25A,0xF693,0x02},
{0xF25C,0xFB6B,0x02},
{0xF25E,0xF687,0x02},
{0xF260,0xF947,0x02},
{0xF262,0xBC7E,0x02},
{0xF264,0xF688,0x02},
{0xF266,0xFD8F,0x02},
{0xF268,0x239C,0x02},
{0xF26A,0x0018,0x02},


{0x0006,0x16,0x01},                  //INCK_SET : 24MHz
};

// ISX012-0
// MIPI 2LANE 432/LANE
//        PLL   432MHz
//        DCK       54
// inifile
// size address data
//
static const isx012_regset_t ISX012_Pll_Setting_3[] =
{
{0x0007,0x00,0x01},                  // PLL_CKSEL                 : PLL 432MHz
{0x0008,0x00,0x01},                  // SRCCK_DIV                 : 1/5 frequency

{0x0004,0x03,0x01},                  //I2C_ADR_SEL 2: 0x3C MIPI selected, 3: 0x3D MIPI selected
{0x5008,0x00,0x01},                  //ENDIAN_SEL : 0:Little Endian
{0x6DA8,0x01,0x01},                  //SHD_CoEF (OTP shading ON flag)
{0x6DA9,0x09,0x01},                  // WHITE_CTRL
{0x6DCB,0x22,0x01},    // YGAM_CONFIG2 :

{0x00C4,0x11,0x01},                  // VIF_CLKCONFIG1            : VIFSEL and VIFDIV setting value with full frame pixel setting for other then JPG
{0x00C5,0x11,0x01},                  // VIF_CLKCONFIG2            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other then JPG
{0x00C6,0x11,0x01},                  // VIF_CLKCONFIG3            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other then JPG
{0x00C7,0x11,0x01},                  // VIF_CLKCONFIG4            : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other then JPG
{0x00C8,0x11,0x01},                  // VIF_CLKCONFIG5            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00C9,0x11,0x01},                  // VIF_CLKCONFIG6            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00CA,0x11,0x01},                  // VIF_CLKCONFIG7            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for JPG mode
{0x00CC,0x11,0x01},                  // VIF_CLKCONFIG9            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG and interleave mode
{0x00CD,0x11,0x01},                  // VIF_CLKCONFIG10           : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG and interleave mode
{0x6A12,0x11,0x01},                  // VIF_CLKCONFIG13 for RAW8  : VIFSEL and VIFDIV setting value with full frame pixel setting for RAW mode
{0x6A13,0x11,0x01},                  // VIF_CLKCONFIG14 for RAW8  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for RAW mode
{0x6A14,0x11,0x01},                  // VIF_CLKCONFIG15 for RAW8  : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for RAW mode
{0x6A15,0x11,0x01},                  // VIF_CLKCONFIG16 for RAW8  : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for RAW mode
{0x018C,0x0000,0x02},                // VADJ_SENS_1_1             : VMAX adjustment value for full frame pixel
{0x018E,0x0012,0x02},                // VADJ_SENS_1_2             : VMAX adjustment value for 1/2 sub-sampling
{0x0190,0x0000,0x02},               // VADJ_SENS_1_4             : VMAX adjustment value for 1/4 sub-sampling
{0x0192,0x0000,0x02},               // VADJ_SENS_1_8             : VMAX adjustment value for 1/8 sub-sampling
{0x0194,0x0027,0x02},               // VADJ_SENS_HD_1_1          : VMAX adjustment value for HD full frame pixel
{0x0196,0x0015,0x02},               // VADJ_SENS_HD_1_2          : VMAX adjustment value for HD 1/2 sub-sampling
{0x6A16,0x0440,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_1 : Detection window vertical size with all 32 windows for FLC full frame pixel
{0x6A18,0x03C0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_2 : Detection window vertical size with all 32 windows for FLC 1/2 sub-sampling
{0x6A1A,0x01E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_4 : Detection window vertical size with all 32 windows for FLC 1/4 sub-sampling
{0x6A1C,0x00E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_8 : Detection window vertical size with all 32 windows for FLC 1/8 sub-sampling
{0x6A1E,0x0420,0x02},               // FLC_OPD_HEIGHT_HD_1_1     : Detection window vertical size with all 32 windows for FLC HD full frame pixel
{0x6A20,0x02C0,0x02},               // FLC_OPD_HEIGHT_HD_1_2     : Detection window vertical size with all 32 windows for FLC HD 1/2 sub-sampling
{0x0016,0x0010,0x02},               // GPIO_FUNCSEL              : GPIO setting
{0x5C01,0x00,0x01},                  // RGLANESEL                 :
{0x5C04,0x04,0x01},                  // RGTLPX                    :
{0x5C05,0x03,0x01},                  // RGTCLKPREPARE             :
{0x5C06,0x0E,0x01},                  // RGTCLKZERO                :
{0x5C07,0x02,0x01},                  // RGTCLKPRE                 :
{0x5C08,0x0B,0x01},                  // RGTCLKPOST                :
{0x5C09,0x05,0x01},                  // RGTCLKTRAIL               :
{0x5C0A,0x07,0x01},                  // RGTHSEXIT                 :
{0x5C0B,0x03,0x01},                  // RGTHSPREPARE              :
{0x5C0C,0x07,0x01},                  // RGTHSZERO                 :
{0x5C0D,0x05,0x01},                  // RGTHSTRAIL                :

{0x0009,0x01,0x01},		//
{0x000A,0x03,0x01},		// EXT_SRCCK_DIV	: 1/8 frequency
{0x00D8,0x11,0x01},                 // VIF_CLKCONFIG_EXT9  : VIFSEL and VIFDIV setting value with full frame pixel setting for other than JPG
{0x00D9,0x11,0x01},                 // VIF_CLKCONFIG_EXT10 : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other than JPG
{0x00DA,0x11,0x01},                 // VIF_CLKCONFIG_EXT11 : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other than JPG
{0x00DB,0x11,0x01},                 // VIF_CLKCONFIG_EXT12 : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other than JPG
{0x00AC,0x02,0x01},                 //

//init Preview setting
{0x0089,0x00,0x01},//OUTFMT_MONI
{0x0090,0x0280,0x02},//HSIZE_MONI : 640
{0x0096,0x01E0,0x02},//VSIZE_MONI : 480
{0x0083,0x01,0x01},//SENSMODE_MONI
{0x0086,0x02,0x01},//FPSTYPE_MONI
{0x0081,0x00,0x01},//MODESEL
{0x0082,0x01,0x01},//MONI_REFRESH

//jpeg setting
//Apex40 is not Jpeg Capture

//Fast mode setting
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT

//Select sensor inversion link control
{0x501A,0x00,0x01},    //SENS_REVERSE_CTRL

//shading
{0x6DBC,0x03,0x01},    // WHITE_EDGE_MAX :
{0x6DF6,0xFF,0x01},    // WHITE_SHD_JUDGE_BODY_COLOR_RATIO :
{0x6DF7,0xF0,0x01},    // WHITE_SHD_JUDGE_RED_RATIO :
{0x6DAD,0x0C,0x01},    // WHITE_OFSET1_UP :
{0x6DAE,0x0C,0x01},    // WHITE_OFSET1_DOWN :
{0x6DAF,0x11,0x01},    // WHITE_OFSET1_RIGHT :
{0x6DB0,0x1B,0x01},    // WHITE_OFSET1_LEFT :
{0x6DB1,0x0D,0x01},    // WHITE_OFSET2_UP :
{0x6DB2,0x13,0x01},    // WHITE_OFSET2_DOWN :
{0x6DB3,0x11,0x01},    // WHITE_OFSET2_RIGHT :
{0x6DB4,0x17,0x01},    // WHITE_OFSET2_LEFT :

//additional code
{0xF200,0xB9B9,0x02},
{0xF202,0x4E12,0x02},
{0xF204,0x6055,0x02},
{0xF206,0x008B,0x02},
{0xF208,0xF177,0x02},
{0xF20A,0xFA70,0x02},
{0xF20C,0x0000,0x02},
{0xF20E,0x0000,0x02},
{0xF210,0x0000,0x02},
{0xF212,0x0000,0x02},
{0xF214,0x0000,0x02},
{0xF216,0x0000,0x02},
{0xF218,0x0000,0x02},
{0xF21A,0x0000,0x02},
{0xF21C,0x0000,0x02},
{0xF21E,0x0000,0x02},
{0xF220,0x0000,0x02},
{0xF222,0x0000,0x02},
{0xF224,0x0000,0x02},
{0xF226,0x0000,0x02},
{0xF228,0x0000,0x02},
{0xF22A,0x0000,0x02},
{0xF22C,0x0000,0x02},
{0xF22E,0x0000,0x02},
{0xF230,0x0000,0x02},
{0xF232,0x0000,0x02},
{0xF234,0x0000,0x02},
{0xF236,0x0000,0x02},
{0xF238,0x0000,0x02},
{0xF23A,0x0000,0x02},
{0xF23C,0x0000,0x02},
{0xF23E,0x0000,0x02},
{0xF240,0x0000,0x02},
{0xF242,0x0000,0x02},
{0xF244,0xB47E,0x02},
{0xF246,0x4808,0x02},
{0xF248,0x7800,0x02},
{0xF24A,0x07C0,0x02},
{0xF24C,0x0FC0,0x02},
{0xF24E,0xF687,0x02},
{0xF250,0xF8ED,0x02},
{0xF252,0xF68E,0x02},
{0xF254,0xFE2B,0x02},
{0xF256,0xF688,0x02},
{0xF258,0xFF6B,0x02},
{0xF25A,0xF693,0x02},
{0xF25C,0xFB6B,0x02},
{0xF25E,0xF687,0x02},
{0xF260,0xF947,0x02},
{0xF262,0xBC7E,0x02},
{0xF264,0xF688,0x02},
{0xF266,0xFD8F,0x02},
{0xF268,0x239C,0x02},
{0xF26A,0x0018,0x02},

{0x0006,0x16,0x01},                  //INCK_SET : 24MHz
};

// ISX012-0
// MIPI 2LANE 432/LANE
//        PLL   432MHz
//        DCK       54
// inifile
// size address data
//
static const isx012_regset_t ISX012_Pll_Setting_4[] =
{
{0x0007,0x00,0x01},                  // PLL_CKSEL                 : PLL 432MHz
{0x0008,0x00,0x01},                  // SRCCK_DIV                 : 1/5 frequency

{0x0004,0x03,0x01},                  //I2C_ADR_SEL 2: 0x3C MIPI selected, 3: 0x3D MIPI selected
{0x5008,0x00,0x01},                  //ENDIAN_SEL : 0:Little Endian
{0x6DA8,0x01,0x01},                  //SHD_CoEF (OTP shading ON flag)
{0x6DA9,0x09,0x01},                  // WHITE_CTRL
{0x6DCB,0x22,0x01},    // YGAM_CONFIG2 :

{0x00C4,0x11,0x01},                  // VIF_CLKCONFIG1            : VIFSEL and VIFDIV setting value with full frame pixel setting for other then JPG
{0x00C5,0x11,0x01},                  // VIF_CLKCONFIG2            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other then JPG
{0x00C6,0x11,0x01},                  // VIF_CLKCONFIG3            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other then JPG
{0x00C7,0x11,0x01},                  // VIF_CLKCONFIG4            : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other then JPG
{0x00C8,0x11,0x01},                  // VIF_CLKCONFIG5            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG mode
{0x00C9,0x11,0x01},                  // VIF_CLKCONFIG6            : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG mode
{0x00CA,0x11,0x01},                  // VIF_CLKCONFIG7            : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for JPG mode
{0x00CC,0x11,0x01},                  // VIF_CLKCONFIG9            : VIFSEL and VIFDIV setting value with full frame pixel setting for JPG and interleave mode
{0x00CD,0x11,0x01},                  // VIF_CLKCONFIG10           : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for JPG and interleave mode
{0x6A12,0x11,0x01},                  // VIF_CLKCONFIG13 for RAW8  : VIFSEL and VIFDIV setting value with full frame pixel setting for RAW mode
{0x6A13,0x11,0x01},                  // VIF_CLKCONFIG14 for RAW8  : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for RAW mode
{0x6A14,0x11,0x01},                  // VIF_CLKCONFIG15 for RAW8  : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for RAW mode
{0x6A15,0x11,0x01},                  // VIF_CLKCONFIG16 for RAW8  : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for RAW mode
{0x018C,0x0026,0x02},                // VADJ_SENS_1_1             : VMAX adjustment value for full frame pixel
{0x018E,0x0012,0x02},                // VADJ_SENS_1_2             : VMAX adjustment value for 1/2 sub-sampling
{0x0190,0x0000,0x02},               // VADJ_SENS_1_4             : VMAX adjustment value for 1/4 sub-sampling
{0x0192,0x0000,0x02},               // VADJ_SENS_1_8             : VMAX adjustment value for 1/8 sub-sampling
{0x0194,0x0027,0x02},               // VADJ_SENS_HD_1_1          : VMAX adjustment value for HD full frame pixel
{0x0196,0x0015,0x02},               // VADJ_SENS_HD_1_2          : VMAX adjustment value for HD 1/2 sub-sampling
{0x6A16,0x0440,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_1 : Detection window vertical size with all 32 windows for FLC full frame pixel
{0x6A18,0x03C0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_2 : Detection window vertical size with all 32 windows for FLC 1/2 sub-sampling
{0x6A1A,0x01E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_4 : Detection window vertical size with all 32 windows for FLC 1/4 sub-sampling
{0x6A1C,0x00E0,0x02},               // FLC_OPD_HEIGHT_NORMAL_1_8 : Detection window vertical size with all 32 windows for FLC 1/8 sub-sampling
{0x6A1E,0x0420,0x02},               // FLC_OPD_HEIGHT_HD_1_1     : Detection window vertical size with all 32 windows for FLC HD full frame pixel
{0x6A20,0x02C0,0x02},               // FLC_OPD_HEIGHT_HD_1_2     : Detection window vertical size with all 32 windows for FLC HD 1/2 sub-sampling
{0x0016,0x0010,0x02},               // GPIO_FUNCSEL              : GPIO setting
{0x5C01,0x00,0x01},                  // RGLANESEL                 :
{0x5C04,0x04,0x01},                  // RGTLPX                    :
{0x5C05,0x03,0x01},                  // RGTCLKPREPARE             :
{0x5C06,0x0E,0x01},                  // RGTCLKZERO                :
{0x5C07,0x02,0x01},                  // RGTCLKPRE                 :
{0x5C08,0x0B,0x01},                  // RGTCLKPOST                :
{0x5C09,0x05,0x01},                  // RGTCLKTRAIL               :
{0x5C0A,0x07,0x01},                  // RGTHSEXIT                 :
{0x5C0B,0x03,0x01},                  // RGTHSPREPARE              :
{0x5C0C,0x07,0x01},                  // RGTHSZERO                 :
{0x5C0D,0x05,0x01},                  // RGTHSTRAIL                :

{0x6A9E,0x15C0,0x02},                //HMAX_1_1(0x6A9E)=0x15C0

{0x0009,0x01,0x01},		//
{0x000A,0x03,0x01},		// EXT_SRCCK_DIV	: 1/8 frequency
{0x00D8,0x11,0x01},                 // VIF_CLKCONFIG_EXT9  : VIFSEL and VIFDIV setting value with full frame pixel setting for other than JPG
{0x00D9,0x11,0x01},                 // VIF_CLKCONFIG_EXT10 : VIFSEL and VIFDIV setting value with 1/2 sub-sampling setting for other than JPG
{0x00DA,0x11,0x01},                 // VIF_CLKCONFIG_EXT11 : VIFSEL and VIFDIV setting value with 1/4 sub-sampling setting for other than JPG
{0x00DB,0x11,0x01},                 // VIF_CLKCONFIG_EXT12 : VIFSEL and VIFDIV setting value with 1/8 sub-sampling setting for other than JPG
{0x00AC,0x00,0x01},                 //

//init Preview setting
{0x0089,0x00,0x01},//OUTFMT_MONI
{0x0090,0x0280,0x02},//HSIZE_MONI : 640
{0x0096,0x01E0,0x02},//VSIZE_MONI : 480
{0x0083,0x01,0x01},//SENSMODE_MONI
{0x0086,0x02,0x01},//FPSTYPE_MONI
{0x0081,0x00,0x01},//MODESEL
{0x0082,0x01,0x01},//MONI_REFRESH

//jpeg setting
//Apex40 is not Jpeg Capture

//Fast mode setting
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT

//Select sensor inversion link control
{0x501A,0x00,0x01},    //SENS_REVERSE_CTRL

//shading
{0x6DBC,0x03,0x01},    // WHITE_EDGE_MAX :
{0x6DF6,0xFF,0x01},    // WHITE_SHD_JUDGE_BODY_COLOR_RATIO :
{0x6DF7,0xF0,0x01},    // WHITE_SHD_JUDGE_RED_RATIO :
{0x6DAD,0x0C,0x01},    // WHITE_OFSET1_UP :
{0x6DAE,0x0C,0x01},    // WHITE_OFSET1_DOWN :
{0x6DAF,0x11,0x01},    // WHITE_OFSET1_RIGHT :
{0x6DB0,0x1B,0x01},    // WHITE_OFSET1_LEFT :
{0x6DB1,0x0D,0x01},    // WHITE_OFSET2_UP :
{0x6DB2,0x13,0x01},    // WHITE_OFSET2_DOWN :
{0x6DB3,0x11,0x01},    // WHITE_OFSET2_RIGHT :
{0x6DB4,0x17,0x01},    // WHITE_OFSET2_LEFT :

//additional code
{0xF200,0xB9B9,0x02},
{0xF202,0x4E12,0x02},
{0xF204,0x6055,0x02},
{0xF206,0x008B,0x02},
{0xF208,0xF177,0x02},
{0xF20A,0xFA70,0x02},
{0xF20C,0x0000,0x02},
{0xF20E,0x0000,0x02},
{0xF210,0x0000,0x02},
{0xF212,0x0000,0x02},
{0xF214,0x0000,0x02},
{0xF216,0x0000,0x02},
{0xF218,0x0000,0x02},
{0xF21A,0x0000,0x02},
{0xF21C,0x0000,0x02},
{0xF21E,0x0000,0x02},
{0xF220,0x0000,0x02},
{0xF222,0x0000,0x02},
{0xF224,0x0000,0x02},
{0xF226,0x0000,0x02},
{0xF228,0x0000,0x02},
{0xF22A,0x0000,0x02},
{0xF22C,0x0000,0x02},
{0xF22E,0x0000,0x02},
{0xF230,0x0000,0x02},
{0xF232,0x0000,0x02},
{0xF234,0x0000,0x02},
{0xF236,0x0000,0x02},
{0xF238,0x0000,0x02},
{0xF23A,0x0000,0x02},
{0xF23C,0x0000,0x02},
{0xF23E,0x0000,0x02},
{0xF240,0x0000,0x02},
{0xF242,0x0000,0x02},
{0xF244,0xB47E,0x02},
{0xF246,0x4808,0x02},
{0xF248,0x7800,0x02},
{0xF24A,0x07C0,0x02},
{0xF24C,0x0FC0,0x02},
{0xF24E,0xF687,0x02},
{0xF250,0xF8ED,0x02},
{0xF252,0xF68E,0x02},
{0xF254,0xFE2B,0x02},
{0xF256,0xF688,0x02},
{0xF258,0xFF6B,0x02},
{0xF25A,0xF693,0x02},
{0xF25C,0xFB6B,0x02},
{0xF25E,0xF687,0x02},
{0xF260,0xF947,0x02},
{0xF262,0xBC7E,0x02},
{0xF264,0xF688,0x02},
{0xF266,0xFD8F,0x02},
{0xF268,0x239C,0x02},
{0xF26A,0x0018,0x02},

{0x0006,0x16,0x01},                  //INCK_SET : 24MHz
};

static const isx012_regset_t ISX012_Preview_SizeSetting[] =
{
{0x0090,0x0280,0x02},    //HSIZE_MONI : 640
{0x0096,0x01E0,0x02},    //VSIZE_MONI : 480
};

static const isx012_regset_t ISX012_Preview_Mode[] =
{
{0x5000,0x00,0x01}, /* CPUEXT, added by SAMSUNG TN */
{0x5E32,0x0F,0x01}, /* for Fast-AE reset */
{0x5E3D,0x0A,0x01}, /* for Fast-AE reset */
{0x0181,0x00,0x01},    // CAP_HALF_AE_CTRL

{0x0089,0x00,0x01},    //OUTFMT_MONI
{0x0083,0x01,0x01},    //SENSMODE_MONI
{0x0086,0x02,0x01},    //FPSTYPE_MONI
{0x0012,0xFF,0x01},    //INTCLR0
{0x00F7,0x52,0x01},    // INIT_QLTY0 : Standard 82
{0x00F8,0x59,0x01},    // INIT_QLTY1 : Fine 89
{0x00F9,0x5F,0x01},    // INIT_QLTY2 : SuperFine 95
{0x0081,0x00,0x01},    //MODESEL
{0x0082,0x01,0x01},    //MONI_REFRESH
{0xFFFF,0x1E,0x01},    //$wait,30
};

static const isx012_regset_t ISX012_Camcorder_Mode_ON[] =
{
//SN setting
{0x0308,0x02,0x01},    // AELINE_MONI_SN1_2 :
{0x0320,0x02,0x01},    // AELINE_MONI_SN1_2 :
{0x00B2,0x02,0x01},    /* AFMODE_MONI : manual mode */

//BRIGHTNESS setting
{0x01C6,0x10,0x01},    //UIBRIGHTNESS

//AE speed
{0x02AC,0x00,0x01},    // AE_SUB_SN1 :
{0x5E2D,0x0C,0x01},    // AEMOVECNT :
{0x5E2E,0x20,0x01},    // AEINDEADBAND :
{0x5E2F,0x08,0x01},    // AEOUTDEADBAND :
{0x5E30,0xA0,0x01},    // AESPEED :

{0x5E31,0x0F,0x01},    // AESPEED_INIT :
{0x5E32,0x0F,0x01},    // AESPEED_FAST :

{0x621E,0x18,0x01},    // AIM_NR_TH_UP :
{0x621F,0x18,0x01},    // AIM_NR_TH_DOWN :
{0x6220,0x18,0x01},    // AIM_NR_TH_RIGHT :
{0x6221,0x18,0x01},    // AIM_NR_TH_LEFT :

//AWB speed
{0x6222,0x00,0x01},    // INIT_AIMW :
{0x6223,0x04,0x01},    // INIT_GAINS :
{0x6224,0x10,0x01},    // ATW_DELAY :
{0x6225,0x00,0x01},    // ATW_AIMW :

{0x6226,0x20,0x01},    // ATW_GAINS_IN_NR :
{0x6227,0x30,0x01},    // ATW_GAINS_IN :
{0x6228,0x20,0x01},    // ATW_GAINS_OUT_NR :
{0x6229,0x30,0x01},    // ATW_GAINS_OUT :
{0x622A,0x0D,0x01},    // ALLWB_GAINS :

//Gammma Table 0
{0x7000,0x0000,0x02},    // G0_KNOT_G0 :
{0x7002,0x0000,0x02},    // G0_KNOT_G1 :
{0x7004,0x001E,0x02},    // G0_KNOT_G2 :
{0x7006,0x0038,0x02},    // G0_KNOT_G3 :
{0x7008,0x0046,0x02},    // G0_KNOT_G4 :
{0x700A,0x0053,0x02},    // G0_KNOT_G5 :
{0x700C,0x005A,0x02},    // G0_KNOT_G6 :
{0x700E,0x0063,0x02},    // G0_KNOT_G7 :
{0x7010,0x006D,0x02},    // G0_KNOT_G8 :
{0x7012,0x0076,0x02},    // G0_KNOT_G9 :
{0x7014,0x0055,0x02},    // G0_KNOT_G10 :
{0x7016,0x008E,0x02},    // G0_KNOT_G11 :
{0x7018,0x00B9,0x02},    // G0_KNOT_G12 :
{0x701A,0x00D5,0x02},    // G0_KNOT_G13 :
{0x701C,0x00E4,0x02},    // G0_KNOT_G14 :
{0x701E,0x00F0,0x02},    // G0_KNOT_G15 :
{0x7020,0x00F9,0x02},    // G0_KNOT_G16 :
{0x7022,0x0103,0x02},    // G0_KNOT_G17 :
{0x7024,0x010C,0x02},    // G0_KNOT_G18 :
{0x7026,0x00,0x01},    // G0_KNOT_R0_OFFSET :
{0x7027,0x00,0x01},    // G0_KNOT_R2_OFFSET :
{0x7028,0x00,0x01},    // G0_KNOT_R4_OFFSET :
{0x7029,0x00,0x01},    // G0_KNOT_R6_OFFSET :
{0x702A,0x00,0x01},    // G0_KNOT_R8_OFFSET :
{0x702B,0x00,0x01},    // G0_KNOT_R10_OFFSET :
{0x702C,0x00,0x01},    // G0_KNOT_R12_OFFSET :
{0x702D,0x00,0x01},    // G0_KNOT_R14_OFFSET :
{0x702E,0x00,0x01},    // G0_KNOT_R16_OFFSET :
{0x702F,0x00,0x01},    // G0_KNOT_R18_OFFSET :
{0x7030,0x00,0x01},    // G0_KNOT_B0_OFFSET :
{0x7031,0x00,0x01},    // G0_KNOT_B2_OFFSET :
{0x7032,0x00,0x01},    // G0_KNOT_B4_OFFSET :
{0x7033,0x00,0x01},    // G0_KNOT_B6_OFFSET :
{0x7034,0x00,0x01},    // G0_KNOT_B8_OFFSET :
{0x7035,0x00,0x01},    // G0_KNOT_B10_OFFSET :
{0x7036,0x00,0x01},    // G0_KNOT_B12_OFFSET :
{0x7037,0x00,0x01},    // G0_KNOT_B14_OFFSET :
{0x7038,0x00,0x01},    // G0_KNOT_B16_OFFSET :
{0x7039,0x00,0x01},    // G0_KNOT_B18_OFFSET :
{0x703A,0x0611,0x02},    // G0_LOWGM_ON_R :
{0x703C,0x1E0A,0x02},    // G0_0CLIP_R :
{0x703E,0x0611,0x02},    // G0_LOWGM_ON_G :
{0x7040,0x1E0A,0x02},    // G0_0CLIP_G :
{0x7042,0x0611,0x02},    // G0_LOWGM_ON_B :
{0x7044,0x1E0A,0x02},    // G0_0CLIP_B :
{0x7046,0x91,0x01},    // G0_KNOT_GAINCTRL_TH_L :
{0x7047,0x96,0x01},    // G0_KNOT_GAINCTRL_TH_H :
{0x7048,0x0000,0x02},    // G0_KNOT_L_G0 :
{0x704A,0x0000,0x02},    // G0_KNOT_L_G1 :
{0x704C,0x000E,0x02},    // G0_KNOT_L_G2 :
{0x704E,0x002F,0x02},    // G0_KNOT_L_G3 :
{0x7050,0x003D,0x02},    // G0_KNOT_L_G4 :
{0x7052,0x004A,0x02},    // G0_KNOT_L_G5 :
{0x7054,0x0051,0x02},    // G0_KNOT_L_G6 :
{0x7056,0x005A,0x02},    // G0_KNOT_L_G7 :
{0x7058,0x0061,0x02},    // G0_KNOT_L_G8 :
{0x705A,0x006A,0x02},    // G0_KNOT_L_G9 :
{0x705C,0x0049,0x02},    // G0_KNOT_L_G10 :
{0x705E,0x0082,0x02},    // G0_KNOT_L_G11 :
{0x7060,0x00AD,0x02},    // G0_KNOT_L_G12 :
{0x7062,0x00CC,0x02},    // G0_KNOT_L_G13 :
{0x7064,0x00E1,0x02},    // G0_KNOT_L_G14 :
{0x7066,0x00ED,0x02},    // G0_KNOT_L_G15 :
{0x7068,0x00F6,0x02},    // G0_KNOT_L_G16 :
{0x706A,0x0106,0x02},    // G0_KNOT_L_G17 :
{0x706C,0x010C,0x02},    // G0_KNOT_L_G18 :


{0x6400,0x00,0x01},    // INFRM_LEFT00 :
{0x6401,0x00,0x01},    // INFRM_LEFT01 :
{0x6402,0x00,0x01},    // INFRM_LEFT02 :
{0x6403,0x00,0x01},    // INFRM_LEFT03 :
{0x6404,0x00,0x01},    // INFRM_LEFT04 :
{0x6405,0x00,0x01},    // INFRM_LEFT05 :
{0x6406,0x00,0x01},    // INFRM_LEFT06 :
{0x6407,0x00,0x01},    // INFRM_LEFT07 :
{0x6408,0x00,0x01},    // INFRM_LEFT08 :
{0x6409,0x00,0x01},    // INFRM_LEFT09 :
{0x640A,0x00,0x01},    // INFRM_LEFT10 :
{0x640B,0x00,0x01},    // INFRM_LEFT11 :
{0x640C,0x00,0x01},    // INFRM_LEFT12 :
{0x640D,0x00,0x01},    // INFRM_LEFT13 :
{0x640E,0x00,0x01},    // INFRM_LEFT14 :
{0x640F,0x00,0x01},    // INFRM_LEFT15 :
{0x6410,0x00,0x01},    // INFRM_LEFT16 :
{0x6411,0x00,0x01},    // INFRM_LEFT17 :
{0x6412,0x00,0x01},    // INFRM_LEFT18 :
{0x6413,0x00,0x01},    // INFRM_LEFT19 :
{0x6414,0x00,0x01},    // INFRM_LEFT20 :
{0x6415,0x00,0x01},    // INFRM_LEFT21 :
{0x6416,0x00,0x01},    // INFRM_LEFT22 :
{0x6417,0x00,0x01},    // INFRM_LEFT23 :
{0x6418,0x00,0x01},    // INFRM_LEFT24 :
{0x6419,0x00,0x01},    // INFRM_LEFT25 :
{0x641A,0x00,0x01},    // INFRM_LEFT26 :
{0x641B,0x00,0x01},    // INFRM_LEFT27 :
{0x641C,0x00,0x01},    // INFRM_LEFT28 :
{0x641D,0x00,0x01},    // INFRM_LEFT29 :
{0x641E,0x00,0x01},    // INFRM_LEFT30 :
{0x641F,0x00,0x01},    // INFRM_LEFT31 :
{0x6420,0x00,0x01},    // INFRM_LEFT32 :
{0x6421,0x00,0x01},    // INFRM_LEFT33 :
{0x6422,0x00,0x01},    // INFRM_LEFT34 :
{0x6423,0x00,0x01},    // INFRM_LEFT35 :
{0x6424,0x00,0x01},    // INFRM_LEFT36 :
{0x6425,0x00,0x01},    // INFRM_LEFT37 :
{0x6426,0xFF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xFF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xFF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xFF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xFF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xFF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xFF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xFF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xFF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xFF,0x01},    // INFRM_RIGHT09 :
{0x6430,0xFF,0x01},    // INFRM_RIGHT10 :
{0x6431,0xFF,0x01},    // INFRM_RIGHT11 :
{0x6432,0xFF,0x01},    // INFRM_RIGHT12 :
{0x6433,0xFF,0x01},    // INFRM_RIGHT13 :
{0x6434,0xFF,0x01},    // INFRM_RIGHT14 :
{0x6435,0xFF,0x01},    // INFRM_RIGHT15 :
{0x6436,0xFF,0x01},    // INFRM_RIGHT16 :
{0x6437,0xFF,0x01},    // INFRM_RIGHT17 :
{0x6438,0xFF,0x01},    // INFRM_RIGHT18 :
{0x6439,0xFF,0x01},    // INFRM_RIGHT19 :
{0x643A,0xFF,0x01},    // INFRM_RIGHT20 :
{0x643B,0xFF,0x01},    // INFRM_RIGHT21 :
{0x643C,0xFF,0x01},    // INFRM_RIGHT22 :
{0x643D,0xFF,0x01},    // INFRM_RIGHT23 :
{0x643E,0xFF,0x01},    // INFRM_RIGHT24 :
{0x643F,0xFF,0x01},    // INFRM_RIGHT25 :
{0x6440,0xFF,0x01},    // INFRM_RIGHT26 :
{0x6441,0xFF,0x01},    // INFRM_RIGHT27 :
{0x6442,0xFF,0x01},    // INFRM_RIGHT28 :
{0x6443,0xFF,0x01},    // INFRM_RIGHT29 :
{0x6444,0xFF,0x01},    // INFRM_RIGHT30 :
{0x6445,0xFF,0x01},    // INFRM_RIGHT31 :
{0x6446,0xFF,0x01},    // INFRM_RIGHT32 :
{0x6447,0xFF,0x01},    // INFRM_RIGHT33 :
{0x6448,0xFF,0x01},    // INFRM_RIGHT34 :
{0x6449,0xFF,0x01},    // INFRM_RIGHT35 :
{0x644A,0xFF,0x01},    // INFRM_RIGHT36 :
{0x644B,0xFF,0x01},    // INFRM_RIGHT37 :
{0x644C,0xFFFF,0x02},	 // INFRM_TOP :
{0x644E,0x0000,0x02},	 // INFRM_BOTM :
{0x6450,0x25,0x01},    // INFRM_FLTOP :
{0x6451,0x00,0x01},    // INFRM_FLBOTM :
{0x6452,0x91,0x01},    // INAIM_LEFT00 :
{0x6453,0x91,0x01},    // INAIM_LEFT01 :
{0x6454,0x91,0x01},    // INAIM_LEFT02 :
{0x6455,0x91,0x01},    // INAIM_LEFT03 :
{0x6456,0x91,0x01},    // INAIM_LEFT04 :
{0x6457,0x91,0x01},    // INAIM_LEFT05 :
{0x6458,0x91,0x01},    // INAIM_LEFT06 :
{0x6459,0x91,0x01},    // INAIM_LEFT07 :
{0x645A,0x91,0x01},    // INAIM_LEFT08 :
{0x645B,0x91,0x01},    // INAIM_LEFT09 :
{0x645C,0x91,0x01},    // INAIM_LEFT10 :
{0x645D,0x91,0x01},    // INAIM_LEFT11 :
{0x645E,0x91,0x01},    // INAIM_LEFT12 :
{0x645F,0x66,0x01},    // INAIM_LEFT13 :
{0x6460,0x5D,0x01},    // INAIM_LEFT14 :
{0x6461,0x69,0x01},    // INAIM_LEFT15 :
{0x6462,0x54,0x01},    // INAIM_LEFT16 :
{0x6463,0x4B,0x01},    // INAIM_LEFT17 :
{0x6464,0x42,0x01},    // INAIM_LEFT18 :
{0x6465,0x3C,0x01},    // INAIM_LEFT19 :
{0x6466,0x38,0x01},    // INAIM_LEFT20 :
{0x6467,0x36,0x01},    // INAIM_LEFT21 :
{0x6468,0x35,0x01},    // INAIM_LEFT22 :
{0x6469,0x33,0x01},    // INAIM_LEFT23 :
{0x646A,0x32,0x01},    // INAIM_LEFT24 :
{0x646B,0x30,0x01},    // INAIM_LEFT25 :
{0x646C,0x2F,0x01},    // INAIM_LEFT26 :
{0x646D,0x2D,0x01},    // INAIM_LEFT27 :
{0x646E,0x2C,0x01},    // INAIM_LEFT28 :
{0x646F,0x2B,0x01},    // INAIM_LEFT29 :
{0x6470,0x2A,0x01},    // INAIM_LEFT30 :
{0x6471,0x28,0x01},    // INAIM_LEFT31 :
{0x6472,0x26,0x01},    // INAIM_LEFT32 :
{0x6473,0x24,0x01},    // INAIM_LEFT33 :
{0x6474,0x29,0x01},    // INAIM_LEFT34 :
{0x6475,0x28,0x01},    // INAIM_LEFT35 :
{0x6476,0x29,0x01},    // INAIM_LEFT36 :
{0x6477,0x26,0x01},    // INAIM_LEFT37 :
{0x6478,0xFF,0x01},    // INAIM_RIGHT00 :
{0x6479,0xFF,0x01},    // INAIM_RIGHT01 :
{0x647A,0xFF,0x01},    // INAIM_RIGHT02 :
{0x647B,0xFF,0x01},    // INAIM_RIGHT03 :
{0x647C,0xFF,0x01},    // INAIM_RIGHT04 :
{0x647D,0xFF,0x01},    // INAIM_RIGHT05 :
{0x647E,0xFF,0x01},    // INAIM_RIGHT06 :
{0x647F,0xFF,0x01},    // INAIM_RIGHT07 :
{0x6480,0xFF,0x01},    // INAIM_RIGHT08 :
{0x6481,0xFF,0x01},    // INAIM_RIGHT09 :
{0x6482,0xD9,0x01},    // INAIM_RIGHT10 :
{0x6483,0xB7,0x01},    // INAIM_RIGHT11 :
{0x6484,0x96,0x01},    // INAIM_RIGHT12 :
{0x6485,0x68,0x01},    // INAIM_RIGHT13 :
{0x6486,0x70,0x01},    // INAIM_RIGHT14 :
{0x6487,0x72,0x01},    // INAIM_RIGHT15 :
{0x6488,0x71,0x01},    // INAIM_RIGHT16 :
{0x6489,0x6B,0x01},    // INAIM_RIGHT17 :
{0x648A,0x65,0x01},    // INAIM_RIGHT18 :
{0x648B,0x60,0x01},    // INAIM_RIGHT19 :
{0x648C,0x5B,0x01},    // INAIM_RIGHT20 :
{0x648D,0x56,0x01},    // INAIM_RIGHT21 :
{0x648E,0x51,0x01},    // INAIM_RIGHT22 :
{0x648F,0x4C,0x01},    // INAIM_RIGHT23 :
{0x6490,0x47,0x01},    // INAIM_RIGHT24 :
{0x6491,0x44,0x01},    // INAIM_RIGHT25 :
{0x6492,0x41,0x01},    // INAIM_RIGHT26 :
{0x6493,0x3E,0x01},    // INAIM_RIGHT27 :
{0x6494,0x3B,0x01},    // INAIM_RIGHT28 :
{0x6495,0x39,0x01},    // INAIM_RIGHT29 :
{0x6496,0x37,0x01},    // INAIM_RIGHT30 :
{0x6497,0x34,0x01},    // INAIM_RIGHT31 :
{0x6498,0x33,0x01},    // INAIM_RIGHT32 :
{0x6499,0x32,0x01},    // INAIM_RIGHT33 :
{0x649A,0x31,0x01},    // INAIM_RIGHT34 :
{0x649B,0x30,0x01},    // INAIM_RIGHT35 :
{0x649C,0x2F,0x01},    // INAIM_RIGHT36 :
{0x649D,0x2E,0x01},    // INAIM_RIGHT37 :
{0x649E,0x1E00,0x02},	 // INAIM_TOP :
{0x64A0,0x0F48,0x02},	 // INAIM_BOTM :
{0x64A2,0x18,0x01},    // INAIM_FLTOP :
{0x64A3,0x11,0x01},    // INAIM_FLBOTM :
{0x64A4,0x00,0x01},   // OUTFRM_LEFT00 :
{0x64A5,0x00,0x01},   // OUTFRM_LEFT01 :
{0x64A6,0x00,0x01},   // OUTFRM_LEFT02 :
{0x64A7,0x00,0x01},   // OUTFRM_LEFT03 :
{0x64A8,0x00,0x01},   // OUTFRM_LEFT04 :
{0x64A9,0x00,0x01},   // OUTFRM_LEFT05 :
{0x64AA,0x00,0x01},   // OUTFRM_LEFT06 :
{0x64AB,0x00,0x01},   // OUTFRM_LEFT07 :
{0x64AC,0x00,0x01},   // OUTFRM_LEFT08 :
{0x64AD,0x00,0x01},   // OUTFRM_LEFT09 :
{0x64AE,0x00,0x01},   // OUTFRM_LEFT10 :
{0x64AF,0x00,0x01},   // OUTFRM_LEFT11 :
{0x64B0,0x00,0x01},   // OUTFRM_LEFT12 :
{0x64B1,0x00,0x01},   // OUTFRM_LEFT13 :
{0x64B2,0x00,0x01},   // OUTFRM_LEFT14 :
{0x64B3,0x00,0x01},   // OUTFRM_LEFT15 :
{0x64B4,0x00,0x01},   // OUTFRM_LEFT16 :
{0x64B5,0x00,0x01},   // OUTFRM_LEFT17 :
{0x64B6,0x00,0x01},   // OUTFRM_LEFT18 :
{0x64B7,0x00,0x01},   // OUTFRM_LEFT19 :
{0x64B8,0x00,0x01},   // OUTFRM_LEFT20 :
{0x64B9,0x00,0x01},   // OUTFRM_LEFT21 :
{0x64BA,0x00,0x01},   // OUTFRM_LEFT22 :
{0x64BB,0x00,0x01},   // OUTFRM_LEFT23 :
{0x64BC,0x00,0x01},   // OUTFRM_LEFT24 :
{0x64BD,0x00,0x01},   // OUTFRM_LEFT25 :
{0x64BE,0x00,0x01},   // OUTFRM_LEFT26 :
{0x64BF,0x00,0x01},   // OUTFRM_LEFT27 :
{0x64C0,0x00,0x01},   // OUTFRM_LEFT28 :
{0x64C1,0x00,0x01},   // OUTFRM_LEFT29 :
{0x64C2,0x00,0x01},   // OUTFRM_LEFT30 :
{0x64C3,0x00,0x01},   // OUTFRM_LEFT31 :
{0x64C4,0x00,0x01},   // OUTFRM_LEFT32 :
{0x64C5,0x00,0x01},   // OUTFRM_LEFT33 :
{0x64C6,0x00,0x01},   // OUTFRM_LEFT34 :
{0x64C7,0x00,0x01},   // OUTFRM_LEFT35 :
{0x64C8,0x00,0x01},   // OUTFRM_LEFT36 :
{0x64C9,0x00,0x01},   // OUTFRM_LEFT37 :
{0x64CA,0xFF,0x01},   // OUTFRM_RIGHT00 :
{0x64CB,0xFF,0x01},   // OUTFRM_RIGHT01 :
{0x64CC,0xFF,0x01},   // OUTFRM_RIGHT02 :
{0x64CD,0xFF,0x01},   // OUTFRM_RIGHT03 :
{0x64CE,0xFF,0x01},   // OUTFRM_RIGHT04 :
{0x64CF,0xFF,0x01},   // OUTFRM_RIGHT05 :
{0x64D0,0xFF,0x01},   // OUTFRM_RIGHT06 :
{0x64D1,0xFF,0x01},   // OUTFRM_RIGHT07 :
{0x64D2,0xFF,0x01},   // OUTFRM_RIGHT08 :
{0x64D3,0xFF,0x01},   // OUTFRM_RIGHT09 :
{0x64D4,0xFF,0x01},   // OUTFRM_RIGHT10 :
{0x64D5,0xFF,0x01},   // OUTFRM_RIGHT11 :
{0x64D6,0xFF,0x01},   // OUTFRM_RIGHT12 :
{0x64D7,0xFF,0x01},   // OUTFRM_RIGHT13 :
{0x64D8,0xFF,0x01},   // OUTFRM_RIGHT14 :
{0x64D9,0xFF,0x01},   // OUTFRM_RIGHT15 :
{0x64DA,0xFF,0x01},   // OUTFRM_RIGHT16 :
{0x64DB,0xFF,0x01},   // OUTFRM_RIGHT17 :
{0x64DC,0xFF,0x01},   // OUTFRM_RIGHT18 :
{0x64DD,0xFF,0x01},   // OUTFRM_RIGHT19 :
{0x64DE,0xFF,0x01},   // OUTFRM_RIGHT20 :
{0x64DF,0xFF,0x01},   // OUTFRM_RIGHT21 :
{0x64E0,0xFF,0x01},   // OUTFRM_RIGHT22 :
{0x64E1,0xFF,0x01},   // OUTFRM_RIGHT23 :
{0x64E2,0xFF,0x01},   // OUTFRM_RIGHT24 :
{0x64E3,0xFF,0x01},   // OUTFRM_RIGHT25 :
{0x64E4,0xFF,0x01},   // OUTFRM_RIGHT26 :
{0x64E5,0xFF,0x01},   // OUTFRM_RIGHT27 :
{0x64E6,0xFF,0x01},   // OUTFRM_RIGHT28 :
{0x64E7,0xFF,0x01},   // OUTFRM_RIGHT29 :
{0x64E8,0xFF,0x01},   // OUTFRM_RIGHT30 :
{0x64E9,0xFF,0x01},   // OUTFRM_RIGHT31 :
{0x64EA,0xFF,0x01},   // OUTFRM_RIGHT32 :
{0x64EB,0xFF,0x01},   // OUTFRM_RIGHT33 :
{0x64EC,0xFF,0x01},   // OUTFRM_RIGHT34 :
{0x64ED,0xFF,0x01},   // OUTFRM_RIGHT35 :
{0x64EE,0xFF,0x01},   // OUTFRM_RIGHT36 :
{0x64EF,0xFF,0x01},   // OUTFRM_RIGHT37 :
{0x64F0,0x24F0,0x02},	// OUTFRM_TOP :
{0x64F2,0x1400,0x02},	// OUTFRM_BOTM :
{0x64F4,0x37,0x01},   // OUTFRM_FLTOP :
{0x64F5,0x00,0x01},   // OUTFRM_FLBOTM :

//AWB
{0x6232,0x07,0x01},//ATW_SFTLMT_OUT_NR
{0x6234,0x05,0x01},//ATW_SFTLMT_OUT

/////MC3 Setting/////
{0x7600,0x07,0x01},    // MC3_PXDEF0_SEL :
{0x7601,0x07,0x01},    // MC3_PYDEF0_SEL :
{0x7602,0x07,0x01},    // MC3_PXDEF1_SEL :
{0x7603,0x07,0x01},    // MC3_PYDEF1_SEL :
{0x7604,0x07,0x01},    // MC3_PXDEF2_SEL :
{0x7605,0x07,0x01},    // MC3_PYDEF2_SEL :
{0x7606,0x07,0x01},    // MC3_PXDEF3_SEL :
{0x7607,0x07,0x01},    // MC3_PYDEF3_SEL :
{0x7608,0x40,0x01},    // MC3_PXDEF0_A :
{0x7609,0x40,0x01},    // MC3_PXDEF0_B :
{0x760A,0x40,0x01},    // MC3_PXDEF0_C :
{0x760B,0x40,0x01},    // MC3_PYDEF0_A :
{0x760C,0x40,0x01},    // MC3_PYDEF0_B :
{0x760D,0x40,0x01},    // MC3_PYDEF0_C :
{0x760E,0x40,0x01},    // MC3_PXDEF1_A :
{0x760F,0x40,0x01},    // MC3_PXDEF1_B :
{0x7610,0x40,0x01},    // MC3_PXDEF1_C :
{0x7611,0x40,0x01},    // MC3_PYDEF1_A :
{0x7612,0x40,0x01},    // MC3_PYDEF1_B :
{0x7613,0x40,0x01},    // MC3_PYDEF1_C :
{0x7614,0x40,0x01},    // MC3_PXDEF2_A :
{0x7615,0x40,0x01},    // MC3_PXDEF2_B :
{0x7616,0x40,0x01},    // MC3_PXDEF2_C :
{0x7617,0x40,0x01},    // MC3_PYDEF2_A :
{0x7618,0x40,0x01},    // MC3_PYDEF2_B :
{0x7619,0x40,0x01},    // MC3_PYDEF2_C :
{0x761A,0x40,0x01},    // MC3_PXDEF3_A :
{0x761B,0x40,0x01},    // MC3_PXDEF3_B :
{0x761C,0x40,0x01},    // MC3_PXDEF3_C :
{0x761D,0x40,0x01},    // MC3_PYDEF3_A :
{0x761E,0x40,0x01},    // MC3_PYDEF3_B :
{0x761F,0x40,0x01},    // MC3_PYDEF3_C :
{0x7620,0x00,0x01},    // MC3_LUMSL0_IN :
{0x7621,0x06,0x01},    // MC3_LUMSL1_IN :
{0x7622,0x03,0x01},    // MC3_LUMSL2_IN :
{0x7623,0x06,0x01},    // MC3_LUMSL3_IN :
{0x7624,0x00,0x01},    // MC3_LUMSL0_OUT :
{0x7625,0x03,0x01},    // MC3_LUMSL1_OUT :
{0x7626,0x00,0x01},    // MC3_LUMSL2_OUT :
{0x7627,0x00,0x01},    // MC3_LUMSL3_OUT :
{0x7628,0x0000,0x02},    // MC3_L0DEF0_IN :
{0x762A,0x008C,0x02},    // MC3_L0DEF1_IN :
{0x762C,0x0078,0x02},    // MC3_L0DEF2_IN :
{0x762E,0x00E6,0x02},    // MC3_L0DEF3_IN :
{0x7630,0x0000,0x02},    // MC3_L0DEF0_OUT :
{0x7632,0x0082,0x02},    // MC3_L0DEF1_OUT :
{0x7634,0x0000,0x02},    // MC3_L0DEF2_OUT :
{0x7636,0x0000,0x02},    // MC3_L0DEF3_OUT :
{0x7638,0x41,0x01},    // MC3_RDEF0_POS1 :
{0x7639,0x10,0x01},    // MC3_RDEF1_POS1 :
{0x763A,0x15,0x01},    // MC3_RDEF2_POS1 :
{0x763B,0x71,0x01},    // MC3_RDEF3_POS1 :
{0x763C,0x41,0x01},    // MC3_RDEF0_POS2 :
{0x763D,0x10,0x01},    // MC3_RDEF1_POS2 :
{0x763E,0x15,0x01},    // MC3_RDEF2_POS2 :
{0x763F,0x71,0x01},    // MC3_RDEF3_POS2 :
{0x7640,0x3C,0x01},    // MC3_RDEF0_POS3 :
{0x7641,0x10,0x01},    // MC3_RDEF1_POS3 :
{0x7642,0x15,0x01},    // MC3_RDEF2_POS3 :
{0x7643,0x71,0x01},    // MC3_RDEF3_POS3 :
{0x7644,0x46,0x01},    // MC3_RDEF0_POS4 :
{0x7645,0x32,0x01},    // MC3_RDEF1_POS4 :
{0x7646,0x15,0x01},    // MC3_RDEF2_POS4 :
{0x7647,0x71,0x01},    // MC3_RDEF3_POS4 :
{0x7648,0x46,0x01},    // MC3_RDEF0_POS5 :
{0x7649,0x32,0x01},    // MC3_RDEF1_POS5 :
{0x764A,0x15,0x01},    // MC3_RDEF2_POS5 :
{0x764B,0x71,0x01},    // MC3_RDEF3_POS5 :
{0x764C,0x46,0x01},    // MC3_RDEF0_POS6 :
{0x764D,0x10,0x01},    // MC3_RDEF1_POS6 :
{0x764E,0x15,0x01},    // MC3_RDEF2_POS6 :
{0x764F,0x71,0x01},    // MC3_RDEF3_POS6 :
{0x7650,0x46,0x01},    // MC3_RDEF0_POS7 :
{0x7651,0x10,0x01},    // MC3_RDEF1_POS7 :
{0x7652,0x15,0x01},    // MC3_RDEF2_POS7 :
{0x7653,0x71,0x01},    // MC3_RDEF3_POS7 :
{0x7654,0x2D,0x01},    // MC3_RDEF0_OUT :
{0x7655,0x10,0x01},    // MC3_RDEF1_OUT :
{0x7656,0x15,0x01},    // MC3_RDEF2_OUT :
{0x7657,0x54,0x01},    // MC3_RDEF3_OUT :
{0x7658,0x46,0x01},    // MC3_RDEF0_R2_POS4 :
{0x7659,0x32,0x01},    // MC3_RDEF1_R2_POS4 :
{0x765A,0x15,0x01},    // MC3_RDEF2_R2_POS4 :
{0x765B,0x71,0x01},    // MC3_RDEF3_R2_POS4 :
{0x765C,0x46,0x01},    // MC3_RDEF0_R2_POS5 :
{0x765D,0x32,0x01},    // MC3_RDEF1_R2_POS5 :
{0x765E,0x15,0x01},    // MC3_RDEF2_R2_POS5 :
{0x765F,0x71,0x01},    // MC3_RDEF3_R2_POS5 :
{0x7660,0xFFBA,0x02},    // MC3_X0DEF0_POS1 :
{0x7662,0xFFBA,0x02},    // MC3_Y0DEF0_POS1 :
{0x7664,0xFFFE,0x02},    // MC3_X0DEF1_POS1 :
{0x7666,0x000D,0x02},    // MC3_Y0DEF1_POS1 :
{0x7668,0x0002,0x02},    // MC3_X0DEF2_POS1 :
{0x766A,0xFFF6,0x02},    // MC3_Y0DEF2_POS1 :
{0x766C,0x003B,0x02},    // MC3_X0DEF3_POS1 :
{0x766E,0xFFBB,0x02},    // MC3_Y0DEF3_POS1 :
{0x7670,0xFFBA,0x02},    // MC3_X0DEF0_POS2 :
{0x7672,0xFFBA,0x02},    // MC3_Y0DEF0_POS2 :
{0x7674,0xFFFE,0x02},    // MC3_X0DEF1_POS2 :
{0x7676,0x000D,0x02},    // MC3_Y0DEF1_POS2 :
{0x7678,0x0002,0x02},    // MC3_X0DEF2_POS2 :
{0x767A,0xFFF6,0x02},    // MC3_Y0DEF2_POS2 :
{0x767C,0x003B,0x02},    // MC3_X0DEF3_POS2 :
{0x767E,0xFFBB,0x02},    // MC3_Y0DEF3_POS2 :
{0x7680,0xFFCE,0x02},    // MC3_X0DEF0_POS3 :
{0x7682,0xFFBA,0x02},    // MC3_Y0DEF0_POS3 :
{0x7684,0xFFFE,0x02},    // MC3_X0DEF1_POS3 :
{0x7686,0x000D,0x02},    // MC3_Y0DEF1_POS3 :
{0x7688,0x0002,0x02},    // MC3_X0DEF2_POS3 :
{0x768A,0xFFF6,0x02},    // MC3_Y0DEF2_POS3 :
{0x768C,0x003B,0x02},    // MC3_X0DEF3_POS3 :
{0x768E,0xFFBB,0x02},    // MC3_Y0DEF3_POS3 :
{0x7690,0xFFCE,0x02},    // MC3_X0DEF0_POS4 :
{0x7692,0xFFC9,0x02},    // MC3_Y0DEF0_POS4 :
{0x7694,0xFFD0,0x02},    // MC3_X0DEF1_POS4 :
{0x7696,0x0037,0x02},    // MC3_Y0DEF1_POS4 :
{0x7698,0x0002,0x02},    // MC3_X0DEF2_POS4 :
{0x769A,0xFFF6,0x02},    // MC3_Y0DEF2_POS4 :
{0x769C,0x003B,0x02},    // MC3_X0DEF3_POS4 :
{0x769E,0xFFBB,0x02},    // MC3_Y0DEF3_POS4 :
{0x76A0,0xFFCE,0x02},    // MC3_X0DEF0_POS5 :
{0x76A2,0xFFC9,0x02},    // MC3_Y0DEF0_POS5 :
{0x76A4,0xFFD0,0x02},    // MC3_X0DEF1_POS5 :
{0x76A6,0x0037,0x02},    // MC3_Y0DEF1_POS5 :
{0x76A8,0x0002,0x02},    // MC3_X0DEF2_POS5 :
{0x76AA,0xFFF6,0x02},    // MC3_Y0DEF2_POS5 :
{0x76AC,0x003B,0x02},    // MC3_X0DEF3_POS5 :
{0x76AE,0xFFBB,0x02},    // MC3_Y0DEF3_POS5 :
{0x76B0,0xFFCE,0x02},    // MC3_X0DEF0_POS6 :
{0x76B2,0xFFC9,0x02},    // MC3_Y0DEF0_POS6 :
{0x76B4,0xFFFE,0x02},    // MC3_X0DEF1_POS6 :
{0x76B6,0x000D,0x02},    // MC3_Y0DEF1_POS6 :
{0x76B8,0x0002,0x02},    // MC3_X0DEF2_POS6 :
{0x76BA,0xFFF6,0x02},    // MC3_Y0DEF2_POS6 :
{0x76BC,0x003B,0x02},    // MC3_X0DEF3_POS6 :
{0x76BE,0xFFBB,0x02},    // MC3_Y0DEF3_POS6 :
{0x76C0,0xFFCE,0x02},    // MC3_X0DEF0_POS7 :
{0x76C2,0xFFC9,0x02},    // MC3_Y0DEF0_POS7 :
{0x76C4,0xFFFE,0x02},    // MC3_X0DEF1_POS7 :
{0x76C6,0x000D,0x02},    // MC3_Y0DEF1_POS7 :
{0x76C8,0x0002,0x02},    // MC3_X0DEF2_POS7 :
{0x76CA,0xFFF6,0x02},    // MC3_Y0DEF2_POS7 :
{0x76CC,0x003B,0x02},    // MC3_X0DEF3_POS7 :
{0x76CE,0xFFBB,0x02},    // MC3_Y0DEF3_POS7 :
{0x76D0,0xFF7E,0x02},    // MC3_X0DEF0_OUT :
{0x76D2,0xFFE2,0x02},    // MC3_Y0DEF0_OUT :
{0x76D4,0xFFFE,0x02},    // MC3_X0DEF1_OUT :
{0x76D6,0x000D,0x02},    // MC3_Y0DEF1_OUT :
{0x76D8,0x0002,0x02},    // MC3_X0DEF2_OUT :
{0x76DA,0xFFF6,0x02},    // MC3_Y0DEF2_OUT :
{0x76DC,0xFFC4,0x02},    // MC3_X0DEF3_OUT :
{0x76DE,0xFFEC,0x02},    // MC3_Y0DEF3_OUT :
{0x76E0,0xFFCE,0x02},    // MC3_X0DEF0_R2_POS4 :
{0x76E2,0xFFC9,0x02},    // MC3_Y0DEF0_R2_POS4 :
{0x76E4,0xFFD0,0x02},    // MC3_X0DEF1_R2_POS4 :
{0x76E6,0x0037,0x02},    // MC3_Y0DEF1_R2_POS4 :
{0x76E8,0x0002,0x02},    // MC3_X0DEF2_R2_POS4 :
{0x76EA,0xFFF6,0x02},    // MC3_Y0DEF2_R2_POS4 :
{0x76EC,0x003B,0x02},    // MC3_X0DEF3_R2_POS4 :
{0x76EE,0xFFBB,0x02},    // MC3_Y0DEF3_R2_POS4 :
{0x76F0,0xFFCE,0x02},    // MC3_X0DEF0_R2_POS5 :
{0x76F2,0xFFC9,0x02},    // MC3_Y0DEF0_R2_POS5 :
{0x76F4,0xFFD0,0x02},    // MC3_X0DEF1_R2_POS5 :
{0x76F6,0x0037,0x02},    // MC3_Y0DEF1_R2_POS5 :
{0x76F8,0x0002,0x02},    // MC3_X0DEF2_R2_POS5 :
{0x76FA,0xFFF6,0x02},    // MC3_Y0DEF2_R2_POS5 :
{0x76FC,0x003B,0x02},    // MC3_X0DEF3_R2_POS5 :
{0x76FE,0xFFBB,0x02},    // MC3_Y0DEF3_R2_POS5 :
{0x7700,0x0019,0x02},    // MC3_PXDEF0_POS1 :
{0x7702,0xFF66,0x02},    // MC3_PYDEF0_POS1 :
{0x7704,0x0000,0x02},    // MC3_PXDEF1_POS1 :
{0x7706,0x0000,0x02},    // MC3_PYDEF1_POS1 :
{0x7708,0x0000,0x02},    // MC3_PXDEF2_POS1 :
{0x770A,0x0000,0x02},    // MC3_PYDEF2_POS1 :
{0x770C,0xFFD7,0x02},    // MC3_PXDEF3_POS1 :
{0x770E,0x0068,0x02},    // MC3_PYDEF3_POS1 :
{0x7710,0x0000,0x02},    // MC3_PXDEF0_POS2 :
{0x7712,0xFF66,0x02},    // MC3_PYDEF0_POS2 :
{0x7714,0x0033,0x02},    // MC3_PXDEF1_POS2 :
{0x7716,0xFF4C,0x02},    // MC3_PYDEF1_POS2 :
{0x7718,0x0000,0x02},    // MC3_PXDEF2_POS2 :
{0x771A,0x00B3,0x02},    // MC3_PYDEF2_POS2 :
{0x771C,0xFFD7,0x02},    // MC3_PXDEF3_POS2 :
{0x771E,0x0068,0x02},    // MC3_PYDEF3_POS2 :
{0x7720,0x0000,0x02},    // MC3_PXDEF0_POS3 :
{0x7722,0xFF80,0x02},    // MC3_PYDEF0_POS3 :
{0x7724,0x0000,0x02},    // MC3_PXDEF1_POS3 :
{0x7726,0x0000,0x02},    // MC3_PYDEF1_POS3 :
{0x7728,0x0000,0x02},    // MC3_PXDEF2_POS3 :
{0x772A,0x0000,0x02},    // MC3_PYDEF2_POS3 :
{0x772C,0xFFD7,0x02},    // MC3_PXDEF3_POS3 :
{0x772E,0x0068,0x02},    // MC3_PYDEF3_POS3 :
{0x7730,0x0000,0x02},    // MC3_PXDEF0_POS4 :
{0x7732,0xFFCC,0x02},    // MC3_PYDEF0_POS4 :
{0x7734,0x0000,0x02},    // MC3_PXDEF1_POS4 :
{0x7736,0x0000,0x02},    // MC3_PYDEF1_POS4 :
{0x7738,0x0000,0x02},    // MC3_PXDEF2_POS4 :
{0x773A,0x0000,0x02},    // MC3_PYDEF2_POS4 :
{0x773C,0xFFD7,0x02},    // MC3_PXDEF3_POS4 :
{0x773E,0x0068,0x02},    // MC3_PYDEF3_POS4 :
{0x7740,0x0000,0x02},    // MC3_PXDEF0_POS5 :
{0x7742,0xFFCC,0x02},    // MC3_PYDEF0_POS5 :
{0x7744,0x0000,0x02},    // MC3_PXDEF1_POS5 :
{0x7746,0x0000,0x02},    // MC3_PYDEF1_POS5 :
{0x7748,0x0000,0x02},    // MC3_PXDEF2_POS5 :
{0x774A,0x0000,0x02},    // MC3_PYDEF2_POS5 :
{0x774C,0xFFD7,0x02},    // MC3_PXDEF3_POS5 :
{0x774E,0x0068,0x02},    // MC3_PYDEF3_POS5 :
{0x7750,0xFFB3,0x02},    // MC3_PXDEF0_POS6 :
{0x7752,0x0000,0x02},    // MC3_PYDEF0_POS6 :
{0x7754,0x0033,0x02},    // MC3_PXDEF1_POS6 :
{0x7756,0xFF4C,0x02},    // MC3_PYDEF1_POS6 :
{0x7758,0x0000,0x02},    // MC3_PXDEF2_POS6 :
{0x775A,0x00B3,0x02},    // MC3_PYDEF2_POS6 :
{0x775C,0xFFD7,0x02},    // MC3_PXDEF3_POS6 :
{0x775E,0x0068,0x02},    // MC3_PYDEF3_POS6 :
{0x7760,0xFFB3,0x02},    // MC3_PXDEF0_POS7 :
{0x7762,0x0000,0x02},    // MC3_PYDEF0_POS7 :
{0x7764,0x0000,0x02},    // MC3_PXDEF1_POS7 :
{0x7766,0x0000,0x02},    // MC3_PYDEF1_POS7 :
{0x7768,0x0000,0x02},    // MC3_PXDEF2_POS7 :
{0x776A,0x0000,0x02},    // MC3_PYDEF2_POS7 :
{0x776C,0xFFD7,0x02},    // MC3_PXDEF3_POS7 :
{0x776E,0x0068,0x02},    // MC3_PYDEF3_POS7 :
{0x7770,0x0019,0x02},    // MC3_PXDEF0_OUT :
{0x7772,0xFFE6,0x02},    // MC3_PYDEF0_OUT :
{0x7774,0x0000,0x02},    // MC3_PXDEF1_OUT :
{0x7776,0x0000,0x02},    // MC3_PYDEF1_OUT :
{0x7778,0x0000,0x02},    // MC3_PXDEF2_OUT :
{0x777A,0x0000,0x02},    // MC3_PYDEF2_OUT :
{0x777C,0xFFE1,0x02},    // MC3_PXDEF3_OUT :
{0x777E,0xFFEB,0x02},    // MC3_PYDEF3_OUT :
{0x7780,0x0000,0x02},    // MC3_PXDEF0_R2_POS4 :
{0x7782,0xFFCC,0x02},    // MC3_PYDEF0_R2_POS4 :
{0x7784,0x0000,0x02},    // MC3_PXDEF1_R2_POS4 :
{0x7786,0x0000,0x02},    // MC3_PYDEF1_R2_POS4 :
{0x7788,0x0000,0x02},    // MC3_PXDEF2_R2_POS4 :
{0x778A,0x0000,0x02},    // MC3_PYDEF2_R2_POS4 :
{0x778C,0xFFD7,0x02},    // MC3_PXDEF3_R2_POS4 :
{0x778E,0x0068,0x02},    // MC3_PYDEF3_R2_POS4 :
{0x7790,0x0000,0x02},    // MC3_PXDEF0_R2_POS5 :
{0x7792,0xFFCC,0x02},    // MC3_PYDEF0_R2_POS5 :
{0x7794,0x0000,0x02},    // MC3_PXDEF1_R2_POS5 :
{0x7796,0x0000,0x02},    // MC3_PYDEF1_R2_POS5 :
{0x7798,0x0000,0x02},    // MC3_PXDEF2_R2_POS5 :
{0x779A,0x0000,0x02},    // MC3_PYDEF2_R2_POS5 :
{0x779C,0xFFD7,0x02},    // MC3_PXDEF3_R2_POS5 :
{0x779E,0x0068,0x02},    // MC3_PYDEF3_R2_POS5 :

};

static const isx012_regset_t ISX012_Camcorder_Mode_OFF[] = {
//SN setting
{0x0308,0x11,0x01},    // AELINE_MONI_SN1_2 :
{0x0320,0x22,0x01},    // AELINE_MONI_SN1_2 :
{0x00B2,0x02,0x01},    // AFMODE_MONI :
//BRIGHTNESS setting
{0x01C6,0x00,0x01},    // UIBRIGHTNESS
//AE speed
{0x02AC,0x01,0x01},    // AE_SUB_SN1 :
{0x5E2D,0x08,0x01},    // AEMOVECNT :
{0x5E2E,0x1A,0x01},    // AEINDEADBAND :
{0x5E2F,0x04,0x01},    // AEOUTDEADBAND :
{0x5E30,0x20,0x01},    // AESPEED :
{0x5E31,0x0F,0x01},    // AESPEED_INIT :
{0x5E32,0x0F,0x01},    // AESPEED_FAST :
{0x621E,0x20,0x01},    // AIM_NR_TH_UP :
{0x621F,0x20,0x01},    // AIM_NR_TH_DOWN :
{0x6220,0x20,0x01},    // AIM_NR_TH_RIGHT :
{0x6221,0x20,0x01},    // AIM_NR_TH_LEFT :
//AWB speed
{0x6222,0x00,0x01},    // INIT_AIMW :
{0x6223,0x04,0x01},    // INIT_GAINS :
{0x6224,0x04,0x01},    // ATW_DELAY :
{0x6225,0x00,0x01},    // ATW_AIMW :
{0x6226,0x08,0x01},    // ATW_GAINS_IN_NR :
{0x6227,0x04,0x01},    // ATW_GAINS_IN :
{0x6228,0x08,0x01},    // ATW_GAINS_OUT_NR :
{0x6229,0x04,0x01},    // ATW_GAINS_OUT :
{0x622A,0x02,0x01},    // ALLWB_GAINS :
//Gammma Table 0
{0x7000,0x0000,0x02},	 // G0_KNOT_G0 :
{0x7002,0x0015,0x02},	 // G0_KNOT_G1 :
{0x7004,0x002C,0x02},	 // G0_KNOT_G2 :
{0x7006,0x0041,0x02},	 // G0_KNOT_G3 :
{0x7008,0x004D,0x02},	 // G0_KNOT_G4 :
{0x700A,0x005B,0x02},	 // G0_KNOT_G5 :
{0x700C,0x0060,0x02},	 // G0_KNOT_G6 :
{0x700E,0x0068,0x02},	 // G0_KNOT_G7 :
{0x7010,0x006F,0x02},	 // G0_KNOT_G8 :
{0x7012,0x0078,0x02},	 // G0_KNOT_G9 :
{0x7014,0x0057,0x02},	 // G0_KNOT_G10 :
{0x7016,0x0090,0x02},	 // G0_KNOT_G11 :
{0x7018,0x00BB,0x02},	 // G0_KNOT_G12 :
{0x701A,0x00D6,0x02},	 // G0_KNOT_G13 :
{0x701C,0x00E5,0x02},	 // G0_KNOT_G14 :
{0x701E,0x00F0,0x02},	 // G0_KNOT_G15 :
{0x7020,0x00F9,0x02},	 // G0_KNOT_G16 :
{0x7022,0x0103,0x02},	 // G0_KNOT_G17 :
{0x7024,0x010C,0x02},	 // G0_KNOT_G18 :
{0x7026,0x00,0x01},    // G0_KNOT_R0_OFFSET :
{0x7027,0x00,0x01},    // G0_KNOT_R2_OFFSET :
{0x7028,0x00,0x01},    // G0_KNOT_R4_OFFSET :
{0x7029,0x00,0x01},    // G0_KNOT_R6_OFFSET :
{0x702A,0x00,0x01},    // G0_KNOT_R8_OFFSET :
{0x702B,0x00,0x01},    // G0_KNOT_R10_OFFSET :
{0x702C,0x00,0x01},    // G0_KNOT_R12_OFFSET :
{0x702D,0x00,0x01},    // G0_KNOT_R14_OFFSET :
{0x702E,0x00,0x01},    // G0_KNOT_R16_OFFSET :
{0x702F,0x00,0x01},    // G0_KNOT_R18_OFFSET :
{0x7030,0x00,0x01},    // G0_KNOT_B0_OFFSET :
{0x7031,0x00,0x01},    // G0_KNOT_B2_OFFSET :
{0x7032,0x00,0x01},    // G0_KNOT_B4_OFFSET :
{0x7033,0x00,0x01},    // G0_KNOT_B6_OFFSET :
{0x7034,0x00,0x01},    // G0_KNOT_B8_OFFSET :
{0x7035,0x00,0x01},    // G0_KNOT_B10_OFFSET :
{0x7036,0x00,0x01},    // G0_KNOT_B12_OFFSET :
{0x7037,0x00,0x01},    // G0_KNOT_B14_OFFSET :
{0x7038,0x00,0x01},    // G0_KNOT_B16_OFFSET :
{0x7039,0x00,0x01},    // G0_KNOT_B18_OFFSET :
{0x703A,0x0611,0x02},	 // G0_LOWGM_ON_R :
{0x703C,0x1E0A,0x02},	 // G0_0CLIP_R :
{0x703E,0x0611,0x02},	 // G0_LOWGM_ON_G :
{0x7040,0x1E0A,0x02},	 // G0_0CLIP_G :
{0x7042,0x0611,0x02},	 // G0_LOWGM_ON_B :
{0x7044,0x1E0A,0x02},	 // G0_0CLIP_B :
{0x7046,0x9C,0x01},    // G0_KNOT_GAINCTRL_TH_L :
{0x7047,0xA1,0x01},    // G0_KNOT_GAINCTRL_TH_H :
{0x7048,0x0000,0x02},	 // G0_KNOT_L_G0 :
{0x704A,0x0007,0x02},	 // G0_KNOT_L_G1 :
{0x704C,0x0016,0x02},	 // G0_KNOT_L_G2 :
{0x704E,0x002A,0x02},	 // G0_KNOT_L_G3 :
{0x7050,0x0039,0x02},	 // G0_KNOT_L_G4 :
{0x7052,0x004A,0x02},	 // G0_KNOT_L_G5 :
{0x7054,0x0051,0x02},	 // G0_KNOT_L_G6 :
{0x7056,0x005D,0x02},	 // G0_KNOT_L_G7 :
{0x7058,0x0065,0x02},	 // G0_KNOT_L_G8 :
{0x705A,0x006C,0x02},	 // G0_KNOT_L_G9 :
{0x705C,0x004E,0x02},	 // G0_KNOT_L_G10 :
{0x705E,0x0083,0x02},	 // G0_KNOT_L_G11 :
{0x7060,0x00AA,0x02},	 // G0_KNOT_L_G12 :
{0x7062,0x00C8,0x02},	 // G0_KNOT_L_G13 :
{0x7064,0x00E1,0x02},	 // G0_KNOT_L_G14 :
{0x7066,0x00F5,0x02},	 // G0_KNOT_L_G15 :
{0x7068,0x0100,0x02},	 // G0_KNOT_L_G16 :
{0x706A,0x0106,0x02},	 // G0_KNOT_L_G17 :
{0x706C,0x010C,0x02},	 // G0_KNOT_L_G18 :
{0x6400,0xAA,0x01},    // INFRM_LEFT00 :
{0x6401,0xAA,0x01},    // INFRM_LEFT01 :
{0x6402,0xAA,0x01},    // INFRM_LEFT02 :
{0x6403,0xAA,0x01},    // INFRM_LEFT03 :
{0x6404,0xAA,0x01},    // INFRM_LEFT04 :
{0x6405,0xAA,0x01},    // INFRM_LEFT05 :
{0x6406,0xAA,0x01},    // INFRM_LEFT06 :
{0x6407,0xAA,0x01},    // INFRM_LEFT07 :
{0x6408,0xAA,0x01},    // INFRM_LEFT08 :
{0x6409,0xAE,0x01},    // INFRM_LEFT09 :
{0x640A,0xA0,0x01},    // INFRM_LEFT10 :
{0x640B,0x8C,0x01},    // INFRM_LEFT11 :
{0x640C,0x72,0x01},    // INFRM_LEFT12 :
{0x640D,0x64,0x01},    // INFRM_LEFT13 :
{0x640E,0x5A,0x01},    // INFRM_LEFT14 :
{0x640F,0x52,0x01},    // INFRM_LEFT15 :
{0x6410,0x48,0x01},    // INFRM_LEFT16 :
{0x6411,0x43,0x01},    // INFRM_LEFT17 :
{0x6412,0x3D,0x01},    // INFRM_LEFT18 :
{0x6413,0x37,0x01},    // INFRM_LEFT19 :
{0x6414,0x33,0x01},    // INFRM_LEFT20 :
{0x6415,0x30,0x01},    // INFRM_LEFT21 :
{0x6416,0x2E,0x01},    // INFRM_LEFT22 :
{0x6417,0x2B,0x01},    // INFRM_LEFT23 :
{0x6418,0x28,0x01},    // INFRM_LEFT24 :
{0x6419,0x26,0x01},    // INFRM_LEFT25 :
{0x641A,0x24,0x01},    // INFRM_LEFT26 :
{0x641B,0x23,0x01},    // INFRM_LEFT27 :
{0x641C,0x22,0x01},    // INFRM_LEFT28 :
{0x641D,0x22,0x01},    // INFRM_LEFT29 :
{0x641E,0x21,0x01},    // INFRM_LEFT30 :
{0x641F,0x20,0x01},    // INFRM_LEFT31 :
{0x6420,0x1D,0x01},    // INFRM_LEFT32 :
{0x6421,0x1A,0x01},    // INFRM_LEFT33 :
{0x6422,0x18,0x01},    // INFRM_LEFT34 :
{0x6423,0x17,0x01},    // INFRM_LEFT35 :
{0x6424,0x16,0x01},    // INFRM_LEFT36 :
{0x6425,0x17,0x01},    // INFRM_LEFT37 :
{0x6426,0xAF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xAF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xAF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xAF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xAF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xAF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xAF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xAF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xAF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xAA,0x01},    // INFRM_RIGHT09 :
{0x6430,0xB2,0x01},    // INFRM_RIGHT10 :
{0x6431,0xB4,0x01},    // INFRM_RIGHT11 :
{0x6432,0xB6,0x01},    // INFRM_RIGHT12 :
{0x6433,0xB4,0x01},    // INFRM_RIGHT13 :
{0x6434,0x9B,0x01},    // INFRM_RIGHT14 :
{0x6435,0x8E,0x01},    // INFRM_RIGHT15 :
{0x6436,0x84,0x01},    // INFRM_RIGHT16 :
{0x6437,0x7A,0x01},    // INFRM_RIGHT17 :
{0x6438,0x72,0x01},    // INFRM_RIGHT18 :
{0x6439,0x6A,0x01},    // INFRM_RIGHT19 :
{0x643A,0x63,0x01},    // INFRM_RIGHT20 :
{0x643B,0x5E,0x01},    // INFRM_RIGHT21 :
{0x643C,0x58,0x01},    // INFRM_RIGHT22 :
{0x643D,0x53,0x01},    // INFRM_RIGHT23 :
{0x643E,0x4E,0x01},    // INFRM_RIGHT24 :
{0x643F,0x4A,0x01},    // INFRM_RIGHT25 :
{0x6440,0x46,0x01},    // INFRM_RIGHT26 :
{0x6441,0x42,0x01},    // INFRM_RIGHT27 :
{0x6442,0x3F,0x01},    // INFRM_RIGHT28 :
{0x6443,0x3C,0x01},    // INFRM_RIGHT29 :
{0x6444,0x3A,0x01},    // INFRM_RIGHT30 :
{0x6445,0x38,0x01},    // INFRM_RIGHT31 :
{0x6446,0x37,0x01},    // INFRM_RIGHT32 :
{0x6447,0x35,0x01},    // INFRM_RIGHT33 :
{0x6448,0x33,0x01},    // INFRM_RIGHT34 :
{0x6449,0x32,0x01},    // INFRM_RIGHT35 :
{0x644A,0x32,0x01},    // INFRM_RIGHT36 :
{0x644B,0x32,0x01},    // INFRM_RIGHT37 :
{0x644C,0x24FA,0x02},	 // INFRM_TOP :
{0x644E,0x0940,0x02},	 // INFRM_BOTM :
{0x6450,0x19,0x01},    // INFRM_FLTOP :
{0x6451,0x10,0x01},    // INFRM_FLBOTM :
{0x6452,0x91,0x01},    // INAIM_LEFT00 :
{0x6453,0x91,0x01},    // INAIM_LEFT01 :
{0x6454,0x91,0x01},    // INAIM_LEFT02 :
{0x6455,0x91,0x01},    // INAIM_LEFT03 :
{0x6456,0x91,0x01},    // INAIM_LEFT04 :
{0x6457,0x91,0x01},    // INAIM_LEFT05 :
{0x6458,0x91,0x01},    // INAIM_LEFT06 :
{0x6459,0x91,0x01},    // INAIM_LEFT07 :
{0x645A,0x91,0x01},    // INAIM_LEFT08 :
{0x645B,0x91,0x01},    // INAIM_LEFT09 :
{0x645C,0x91,0x01},    // INAIM_LEFT10 :
{0x645D,0x91,0x01},    // INAIM_LEFT11 :
{0x645E,0x91,0x01},    // INAIM_LEFT12 :
{0x645F,0x66,0x01},    // INAIM_LEFT13 :
{0x6460,0x71,0x01},    // INAIM_LEFT14 :
{0x6461,0x5A,0x01},    // INAIM_LEFT15 :
{0x6462,0x4E,0x01},    // INAIM_LEFT16 :
{0x6463,0x47,0x01},    // INAIM_LEFT17 :
{0x6464,0x42,0x01},    // INAIM_LEFT18 :
{0x6465,0x3C,0x01},    // INAIM_LEFT19 :
{0x6466,0x38,0x01},    // INAIM_LEFT20 :
{0x6467,0x36,0x01},    // INAIM_LEFT21 :
{0x6468,0x33,0x01},    // INAIM_LEFT22 :
{0x6469,0x30,0x01},    // INAIM_LEFT23 :
{0x646A,0x2F,0x01},    // INAIM_LEFT24 :
{0x646B,0x2B,0x01},    // INAIM_LEFT25 :
{0x646C,0x29,0x01},    // INAIM_LEFT26 :
{0x646D,0x27,0x01},    // INAIM_LEFT27 :
{0x646E,0x26,0x01},    // INAIM_LEFT28 :
{0x646F,0x28,0x01},    // INAIM_LEFT29 :
{0x6470,0x2A,0x01},    // INAIM_LEFT30 :
{0x6471,0x28,0x01},    // INAIM_LEFT31 :
{0x6472,0x26,0x01},    // INAIM_LEFT32 :
{0x6473,0x24,0x01},    // INAIM_LEFT33 :
{0x6474,0x29,0x01},    // INAIM_LEFT34 :
{0x6475,0x28,0x01},    // INAIM_LEFT35 :
{0x6476,0x29,0x01},    // INAIM_LEFT36 :
{0x6477,0x26,0x01},    // INAIM_LEFT37 :
{0x6478,0xFF,0x01},    // INAIM_RIGHT00 :
{0x6479,0xFF,0x01},    // INAIM_RIGHT01 :
{0x647A,0xFF,0x01},    // INAIM_RIGHT02 :
{0x647B,0xFF,0x01},    // INAIM_RIGHT03 :
{0x647C,0xFF,0x01},    // INAIM_RIGHT04 :
{0x647D,0xFF,0x01},    // INAIM_RIGHT05 :
{0x647E,0xFF,0x01},    // INAIM_RIGHT06 :
{0x647F,0xFF,0x01},    // INAIM_RIGHT07 :
{0x6480,0xFF,0x01},    // INAIM_RIGHT08 :
{0x6481,0xFF,0x01},    // INAIM_RIGHT09 :
{0x6482,0xD9,0x01},    // INAIM_RIGHT10 :
{0x6483,0xB7,0x01},    // INAIM_RIGHT11 :
{0x6484,0x96,0x01},    // INAIM_RIGHT12 :
{0x6485,0x68,0x01},    // INAIM_RIGHT13 :
{0x6486,0x72,0x01},    // INAIM_RIGHT14 :
{0x6487,0x71,0x01},    // INAIM_RIGHT15 :
{0x6488,0x6E,0x01},    // INAIM_RIGHT16 :
{0x6489,0x6A,0x01},    // INAIM_RIGHT17 :
{0x648A,0x65,0x01},    // INAIM_RIGHT18 :
{0x648B,0x60,0x01},    // INAIM_RIGHT19 :
{0x648C,0x5B,0x01},    // INAIM_RIGHT20 :
{0x648D,0x56,0x01},    // INAIM_RIGHT21 :
{0x648E,0x51,0x01},    // INAIM_RIGHT22 :
{0x648F,0x4C,0x01},    // INAIM_RIGHT23 :
{0x6490,0x47,0x01},    // INAIM_RIGHT24 :
{0x6491,0x44,0x01},    // INAIM_RIGHT25 :
{0x6492,0x41,0x01},    // INAIM_RIGHT26 :
{0x6493,0x3E,0x01},    // INAIM_RIGHT27 :
{0x6494,0x3B,0x01},    // INAIM_RIGHT28 :
{0x6495,0x39,0x01},    // INAIM_RIGHT29 :
{0x6496,0x37,0x01},    // INAIM_RIGHT30 :
{0x6497,0x34,0x01},    // INAIM_RIGHT31 :
{0x6498,0x33,0x01},    // INAIM_RIGHT32 :
{0x6499,0x32,0x01},    // INAIM_RIGHT33 :
{0x649A,0x31,0x01},    // INAIM_RIGHT34 :
{0x649B,0x30,0x01},    // INAIM_RIGHT35 :
{0x649C,0x2F,0x01},    // INAIM_RIGHT36 :
{0x649D,0x2E,0x01},    // INAIM_RIGHT37 :
{0x649E,0x1E00,0x02},	 // INAIM_TOP :
{0x64A0,0x0DFF,0x02},	 // INAIM_BOTM :
{0x64A2,0x18,0x01},    // INAIM_FLTOP :
{0x64A3,0x09,0x01},    // INAIM_FLBOTM :
{0x64A4,0xFF,0x01},    // OUTFRM_LEFT00 :
{0x64A5,0xFF,0x01},    // OUTFRM_LEFT01 :
{0x64A6,0xFF,0x01},    // OUTFRM_LEFT02 :
{0x64A7,0xFF,0x01},    // OUTFRM_LEFT03 :
{0x64A8,0xFF,0x01},    // OUTFRM_LEFT04 :
{0x64A9,0xFF,0x01},    // OUTFRM_LEFT05 :
{0x64AA,0xFF,0x01},    // OUTFRM_LEFT06 :
{0x64AB,0xFF,0x01},    // OUTFRM_LEFT07 :
{0x64AC,0xFF,0x01},    // OUTFRM_LEFT08 :
{0x64AD,0xFD,0x01},    // OUTFRM_LEFT09 :
{0x64AE,0xCB,0x01},    // OUTFRM_LEFT10 :
{0x64AF,0xA9,0x01},    // OUTFRM_LEFT11 :
{0x64B0,0x90,0x01},    // OUTFRM_LEFT12 :
{0x64B1,0x7D,0x01},    // OUTFRM_LEFT13 :
{0x64B2,0x70,0x01},    // OUTFRM_LEFT14 :
{0x64B3,0x65,0x01},    // OUTFRM_LEFT15 :
{0x64B4,0x5C,0x01},    // OUTFRM_LEFT16 :
{0x64B5,0x55,0x01},    // OUTFRM_LEFT17 :
{0x64B6,0x4F,0x01},    // OUTFRM_LEFT18 :
{0x64B7,0x32,0x01},    // OUTFRM_LEFT19 :
{0x64B8,0x4D,0x01},    // OUTFRM_LEFT20 :
{0x64B9,0x40,0x01},    // OUTFRM_LEFT21 :
{0x64BA,0x2D,0x01},    // OUTFRM_LEFT22 :
{0x64BB,0x2B,0x01},    // OUTFRM_LEFT23 :
{0x64BC,0x29,0x01},    // OUTFRM_LEFT24 :
{0x64BD,0x27,0x01},    // OUTFRM_LEFT25 :
{0x64BE,0x25,0x01},    // OUTFRM_LEFT26 :
{0x64BF,0x23,0x01},    // OUTFRM_LEFT27 :
{0x64C0,0x21,0x01},    // OUTFRM_LEFT28 :
{0x64C1,0x1F,0x01},    // OUTFRM_LEFT29 :
{0x64C2,0x1D,0x01},    // OUTFRM_LEFT30 :
{0x64C3,0x1B,0x01},    // OUTFRM_LEFT31 :
{0x64C4,0x1A,0x01},    // OUTFRM_LEFT32 :
{0x64C5,0x1A,0x01},    // OUTFRM_LEFT33 :
{0x64C6,0x1A,0x01},    // OUTFRM_LEFT34 :
{0x64C7,0x28,0x01},    // OUTFRM_LEFT35 :
{0x64C8,0x27,0x01},    // OUTFRM_LEFT36 :
{0x64C9,0x26,0x01},    // OUTFRM_LEFT37 :
{0x64CA,0xFF,0x01},   // OUTFRM_RIGHT00 :
{0x64CB,0xFF,0x01},   // OUTFRM_RIGHT01 :
{0x64CC,0xFF,0x01},   // OUTFRM_RIGHT02 :
{0x64CD,0xFF,0x01},   // OUTFRM_RIGHT03 :
{0x64CE,0xFF,0x01},   // OUTFRM_RIGHT04 :
{0x64CF,0xFF,0x01},   // OUTFRM_RIGHT05 :
{0x64D0,0xFF,0x01},   // OUTFRM_RIGHT06 :
{0x64D1,0xFF,0x01},   // OUTFRM_RIGHT07 :
{0x64D2,0xFF,0x01},   // OUTFRM_RIGHT08 :
{0x64D3,0xFF,0x01},   // OUTFRM_RIGHT09 :
{0x64D4,0xD3,0x01},    // OUTFRM_RIGHT10 :
{0x64D5,0xB1,0x01},    // OUTFRM_RIGHT11 :
{0x64D6,0x98,0x01},    // OUTFRM_RIGHT12 :
{0x64D7,0x85,0x01},    // OUTFRM_RIGHT13 :
{0x64D8,0x78,0x01},    // OUTFRM_RIGHT14 :
{0x64D9,0x6D,0x01},    // OUTFRM_RIGHT15 :
{0x64DA,0x64,0x01},    // OUTFRM_RIGHT16 :
{0x64DB,0x5D,0x01},    // OUTFRM_RIGHT17 :
{0x64DC,0x57,0x01},    // OUTFRM_RIGHT18 :
{0x64DD,0x63,0x01},    // OUTFRM_RIGHT19 :
{0x64DE,0x5E,0x01},    // OUTFRM_RIGHT20 :
{0x64DF,0x5A,0x01},    // OUTFRM_RIGHT21 :
{0x64E0,0x56,0x01},    // OUTFRM_RIGHT22 :
{0x64E1,0x52,0x01},    // OUTFRM_RIGHT23 :
{0x64E2,0x50,0x01},    // OUTFRM_RIGHT24 :
{0x64E3,0x4E,0x01},    // OUTFRM_RIGHT25 :
{0x64E4,0x4C,0x01},    // OUTFRM_RIGHT26 :
{0x64E5,0x4A,0x01},    // OUTFRM_RIGHT27 :
{0x64E6,0x48,0x01},    // OUTFRM_RIGHT28 :
{0x64E7,0x46,0x01},    // OUTFRM_RIGHT29 :
{0x64E8,0x44,0x01},    // OUTFRM_RIGHT30 :
{0x64E9,0x43,0x01},    // OUTFRM_RIGHT31 :
{0x64EA,0x42,0x01},    // OUTFRM_RIGHT32 :
{0x64EB,0x42,0x01},    // OUTFRM_RIGHT33 :
{0x64EC,0x42,0x01},    // OUTFRM_RIGHT34 :
{0x64ED,0x30,0x01},    // OUTFRM_RIGHT35 :
{0x64EE,0x2F,0x01},    // OUTFRM_RIGHT36 :
{0x64EF,0x2E,0x01},    // OUTFRM_RIGHT37 :
{0x64F0,0x2163,0x02},    // OUTFRM_TOP :
{0x64F2,0x1400,0x02},	// OUTFRM_BOTM :
{0x64F4,0x19,0x01},    // OUTFRM_FLTOP :
{0x64F5,0x14,0x01},    // OUTFRM_FLBOTM :
//AWB
{0x6232,0xFF,0x01},    // ATW_SFTLMT_OUT_NR
{0x6234,0xFF,0x01},    // ATW_SFTLMT_OUT
/////MC3 Setting/////
{0x7600,0x07,0x01},    // MC3_PXDEF0_SEL :
{0x7601,0x07,0x01},    // MC3_PYDEF0_SEL :
{0x7602,0x07,0x01},    // MC3_PXDEF1_SEL :
{0x7603,0x07,0x01},    // MC3_PYDEF1_SEL :
{0x7604,0x07,0x01},    // MC3_PXDEF2_SEL :
{0x7605,0x07,0x01},    // MC3_PYDEF2_SEL :
{0x7606,0x07,0x01},    // MC3_PXDEF3_SEL :
{0x7607,0x07,0x01},    // MC3_PYDEF3_SEL :
{0x7608,0x40,0x01},    // MC3_PXDEF0_A :
{0x7609,0x40,0x01},    // MC3_PXDEF0_B :
{0x760A,0x40,0x01},    // MC3_PXDEF0_C :
{0x760B,0x40,0x01},    // MC3_PYDEF0_A :
{0x760C,0x40,0x01},    // MC3_PYDEF0_B :
{0x760D,0x40,0x01},    // MC3_PYDEF0_C :
{0x760E,0x40,0x01},    // MC3_PXDEF1_A :
{0x760F,0x40,0x01},    // MC3_PXDEF1_B :
{0x7610,0x40,0x01},    // MC3_PXDEF1_C :
{0x7611,0x40,0x01},    // MC3_PYDEF1_A :
{0x7612,0x40,0x01},    // MC3_PYDEF1_B :
{0x7613,0x40,0x01},    // MC3_PYDEF1_C :
{0x7614,0x40,0x01},    // MC3_PXDEF2_A :
{0x7615,0x40,0x01},    // MC3_PXDEF2_B :
{0x7616,0x40,0x01},    // MC3_PXDEF2_C :
{0x7617,0x40,0x01},    // MC3_PYDEF2_A :
{0x7618,0x40,0x01},    // MC3_PYDEF2_B :
{0x7619,0x40,0x01},    // MC3_PYDEF2_C :
{0x761A,0x40,0x01},    // MC3_PXDEF3_A :
{0x761B,0x40,0x01},    // MC3_PXDEF3_B :
{0x761C,0x40,0x01},    // MC3_PXDEF3_C :
{0x761D,0x40,0x01},    // MC3_PYDEF3_A :
{0x761E,0x40,0x01},    // MC3_PYDEF3_B :
{0x761F,0x40,0x01},    // MC3_PYDEF3_C :
{0x7620,0x00,0x01},    // MC3_LUMSL0_IN :
{0x7621,0x06,0x01},    // MC3_LUMSL1_IN :
{0x7622,0x03,0x01},    // MC3_LUMSL2_IN :
{0x7623,0x06,0x01},    // MC3_LUMSL3_IN :
{0x7624,0x00,0x01},    // MC3_LUMSL0_OUT :
{0x7625,0x03,0x01},    // MC3_LUMSL1_OUT :
{0x7626,0x00,0x01},    // MC3_LUMSL2_OUT :
{0x7627,0x00,0x01},    // MC3_LUMSL3_OUT :
{0x7628,0x0000,0x02},	 // MC3_L0DEF0_IN :
{0x762A,0x008C,0x02},	 // MC3_L0DEF1_IN :
{0x762C,0x0078,0x02},	 // MC3_L0DEF2_IN :
{0x762E,0x00E6,0x02},	 // MC3_L0DEF3_IN :
{0x7630,0x0000,0x02},	 // MC3_L0DEF0_OUT :
{0x7632,0x0082,0x02},	 // MC3_L0DEF1_OUT :
{0x7634,0x0000,0x02},	 // MC3_L0DEF2_OUT :
{0x7636,0x0000,0x02},	 // MC3_L0DEF3_OUT :
{0x7638,0x41,0x01},    // MC3_RDEF0_POS1 :
{0x7639,0x10,0x01},    // MC3_RDEF1_POS1 :
{0x763A,0x15,0x01},    // MC3_RDEF2_POS1 :
{0x763B,0x71,0x01},    // MC3_RDEF3_POS1 :
{0x763C,0x41,0x01},    // MC3_RDEF0_POS2 :
{0x763D,0x10,0x01},    // MC3_RDEF1_POS2 :
{0x763E,0x15,0x01},    // MC3_RDEF2_POS2 :
{0x763F,0x71,0x01},    // MC3_RDEF3_POS2 :
{0x7640,0x3C,0x01},    // MC3_RDEF0_POS3 :
{0x7641,0x10,0x01},    // MC3_RDEF1_POS3 :
{0x7642,0x15,0x01},    // MC3_RDEF2_POS3 :
{0x7643,0x71,0x01},    // MC3_RDEF3_POS3 :
{0x7644,0x46,0x01},    // MC3_RDEF0_POS4 :
{0x7645,0x32,0x01},    // MC3_RDEF1_POS4 :
{0x7646,0x15,0x01},    // MC3_RDEF2_POS4 :
{0x7647,0x71,0x01},    // MC3_RDEF3_POS4 :
{0x7648,0x46,0x01},    // MC3_RDEF0_POS5 :
{0x7649,0x32,0x01},    // MC3_RDEF1_POS5 :
{0x764A,0x15,0x01},    // MC3_RDEF2_POS5 :
{0x764B,0x71,0x01},    // MC3_RDEF3_POS5 :
{0x764C,0x46,0x01},    // MC3_RDEF0_POS6 :
{0x764D,0x10,0x01},    // MC3_RDEF1_POS6 :
{0x764E,0x15,0x01},    // MC3_RDEF2_POS6 :
{0x764F,0x71,0x01},    // MC3_RDEF3_POS6 :
{0x7650,0x46,0x01},    // MC3_RDEF0_POS7 :
{0x7651,0x10,0x01},    // MC3_RDEF1_POS7 :
{0x7652,0x15,0x01},    // MC3_RDEF2_POS7 :
{0x7653,0x71,0x01},    // MC3_RDEF3_POS7 :
{0x7654,0x2D,0x01},    // MC3_RDEF0_OUT :
{0x7655,0x10,0x01},    // MC3_RDEF1_OUT :
{0x7656,0x15,0x01},    // MC3_RDEF2_OUT :
{0x7657,0x54,0x01},    // MC3_RDEF3_OUT :
{0x7658,0x46,0x01},    // MC3_RDEF0_R2_POS4 :
{0x7659,0x32,0x01},    // MC3_RDEF1_R2_POS4 :
{0x765A,0x15,0x01},    // MC3_RDEF2_R2_POS4 :
{0x765B,0x71,0x01},    // MC3_RDEF3_R2_POS4 :
{0x765C,0x46,0x01},    // MC3_RDEF0_R2_POS5 :
{0x765D,0x32,0x01},    // MC3_RDEF1_R2_POS5 :
{0x765E,0x15,0x01},    // MC3_RDEF2_R2_POS5 :
{0x765F,0x71,0x01},    // MC3_RDEF3_R2_POS5 :
{0x7660,0xFFBA,0x02},	 // MC3_X0DEF0_POS1 :
{0x7662,0xFFBA,0x02},	 // MC3_Y0DEF0_POS1 :
{0x7664,0xFFFE,0x02},	 // MC3_X0DEF1_POS1 :
{0x7666,0x000D,0x02},	 // MC3_Y0DEF1_POS1 :
{0x7668,0x0002,0x02},	 // MC3_X0DEF2_POS1 :
{0x766A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS1 :
{0x766C,0x003B,0x02},	 // MC3_X0DEF3_POS1 :
{0x766E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS1 :
{0x7670,0xFFBA,0x02},	 // MC3_X0DEF0_POS2 :
{0x7672,0xFFBA,0x02},	 // MC3_Y0DEF0_POS2 :
{0x7674,0xFFFE,0x02},	 // MC3_X0DEF1_POS2 :
{0x7676,0x000D,0x02},	 // MC3_Y0DEF1_POS2 :
{0x7678,0x0002,0x02},	 // MC3_X0DEF2_POS2 :
{0x767A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS2 :
{0x767C,0x003B,0x02},	 // MC3_X0DEF3_POS2 :
{0x767E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS2 :
{0x7680,0xFFCE,0x02},	 // MC3_X0DEF0_POS3 :
{0x7682,0xFFBA,0x02},	 // MC3_Y0DEF0_POS3 :
{0x7684,0xFFFE,0x02},	 // MC3_X0DEF1_POS3 :
{0x7686,0x000D,0x02},	 // MC3_Y0DEF1_POS3 :
{0x7688,0x0002,0x02},	 // MC3_X0DEF2_POS3 :
{0x768A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS3 :
{0x768C,0x003B,0x02},	 // MC3_X0DEF3_POS3 :
{0x768E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS3 :
{0x7690,0xFFCE,0x02},	 // MC3_X0DEF0_POS4 :
{0x7692,0xFFC9,0x02},	 // MC3_Y0DEF0_POS4 :
{0x7694,0xFFD0,0x02},	 // MC3_X0DEF1_POS4 :
{0x7696,0x0037,0x02},	 // MC3_Y0DEF1_POS4 :
{0x7698,0x0002,0x02},	 // MC3_X0DEF2_POS4 :
{0x769A,0xFFF6,0x02},	 // MC3_Y0DEF2_POS4 :
{0x769C,0x003B,0x02},	 // MC3_X0DEF3_POS4 :
{0x769E,0xFFBB,0x02},	 // MC3_Y0DEF3_POS4 :
{0x76A0,0xFFCE,0x02},	 // MC3_X0DEF0_POS5 :
{0x76A2,0xFFC9,0x02},	 // MC3_Y0DEF0_POS5 :
{0x76A4,0xFFD0,0x02},	 // MC3_X0DEF1_POS5 :
{0x76A6,0x0037,0x02},	 // MC3_Y0DEF1_POS5 :
{0x76A8,0x0002,0x02},	 // MC3_X0DEF2_POS5 :
{0x76AA,0xFFF6,0x02},	 // MC3_Y0DEF2_POS5 :
{0x76AC,0x003B,0x02},	 // MC3_X0DEF3_POS5 :
{0x76AE,0xFFBB,0x02},	 // MC3_Y0DEF3_POS5 :
{0x76B0,0xFFCE,0x02},	 // MC3_X0DEF0_POS6 :
{0x76B2,0xFFC9,0x02},	 // MC3_Y0DEF0_POS6 :
{0x76B4,0xFFFE,0x02},	 // MC3_X0DEF1_POS6 :
{0x76B6,0x000D,0x02},	 // MC3_Y0DEF1_POS6 :
{0x76B8,0x0002,0x02},	 // MC3_X0DEF2_POS6 :
{0x76BA,0xFFF6,0x02},	 // MC3_Y0DEF2_POS6 :
{0x76BC,0x003B,0x02},	 // MC3_X0DEF3_POS6 :
{0x76BE,0xFFBB,0x02},	 // MC3_Y0DEF3_POS6 :
{0x76C0,0xFFCE,0x02},	 // MC3_X0DEF0_POS7 :
{0x76C2,0xFFC9,0x02},	 // MC3_Y0DEF0_POS7 :
{0x76C4,0xFFFE,0x02},	 // MC3_X0DEF1_POS7 :
{0x76C6,0x000D,0x02},	 // MC3_Y0DEF1_POS7 :
{0x76C8,0x0002,0x02},	 // MC3_X0DEF2_POS7 :
{0x76CA,0xFFF6,0x02},	 // MC3_Y0DEF2_POS7 :
{0x76CC,0x003B,0x02},	 // MC3_X0DEF3_POS7 :
{0x76CE,0xFFBB,0x02},	 // MC3_Y0DEF3_POS7 :
{0x76D0,0xFF7E,0x02},	 // MC3_X0DEF0_OUT :
{0x76D2,0xFFE2,0x02},	 // MC3_Y0DEF0_OUT :
{0x76D4,0xFFFE,0x02},	 // MC3_X0DEF1_OUT :
{0x76D6,0x000D,0x02},	 // MC3_Y0DEF1_OUT :
{0x76D8,0x0002,0x02},	 // MC3_X0DEF2_OUT :
{0x76DA,0xFFF6,0x02},	 // MC3_Y0DEF2_OUT :
{0x76DC,0xFFC4,0x02},	 // MC3_X0DEF3_OUT :
{0x76DE,0xFFEC,0x02},	 // MC3_Y0DEF3_OUT :
{0x76E0,0xFFCE,0x02},	 // MC3_X0DEF0_R2_POS4 :
{0x76E2,0xFFC9,0x02},	 // MC3_Y0DEF0_R2_POS4 :
{0x76E4,0xFFD0,0x02},	 // MC3_X0DEF1_R2_POS4 :
{0x76E6,0x0037,0x02},	 // MC3_Y0DEF1_R2_POS4 :
{0x76E8,0x0002,0x02},	 // MC3_X0DEF2_R2_POS4 :
{0x76EA,0xFFF6,0x02},	 // MC3_Y0DEF2_R2_POS4 :
{0x76EC,0x003B,0x02},	 // MC3_X0DEF3_R2_POS4 :
{0x76EE,0xFFBB,0x02},	 // MC3_Y0DEF3_R2_POS4 :
{0x76F0,0xFFCE,0x02},	 // MC3_X0DEF0_R2_POS5 :
{0x76F2,0xFFC9,0x02},	 // MC3_Y0DEF0_R2_POS5 :
{0x76F4,0xFFD0,0x02},	 // MC3_X0DEF1_R2_POS5 :
{0x76F6,0x0037,0x02},	 // MC3_Y0DEF1_R2_POS5 :
{0x76F8,0x0002,0x02},	 // MC3_X0DEF2_R2_POS5 :
{0x76FA,0xFFF6,0x02},	 // MC3_Y0DEF2_R2_POS5 :
{0x76FC,0x003B,0x02},	 // MC3_X0DEF3_R2_POS5 :
{0x76FE,0xFFBB,0x02},	 // MC3_Y0DEF3_R2_POS5 :
{0x7700,0x0019,0x02},	 // MC3_PXDEF0_POS1 :
{0x7702,0xFF66,0x02},	 // MC3_PYDEF0_POS1 :
{0x7704,0x0000,0x02},	 // MC3_PXDEF1_POS1 :
{0x7706,0x0000,0x02},	 // MC3_PYDEF1_POS1 :
{0x7708,0x0000,0x02},	 // MC3_PXDEF2_POS1 :
{0x770A,0x0000,0x02},	 // MC3_PYDEF2_POS1 :
{0x770C,0xFFD7,0x02},	 // MC3_PXDEF3_POS1 :
{0x770E,0x0068,0x02},	 // MC3_PYDEF3_POS1 :
{0x7710,0x0000,0x02},	 // MC3_PXDEF0_POS2 :
{0x7712,0xFF66,0x02},	 // MC3_PYDEF0_POS2 :
{0x7714,0x0033,0x02},	 // MC3_PXDEF1_POS2 :
{0x7716,0xFF4C,0x02},	 // MC3_PYDEF1_POS2 :
{0x7718,0x0000,0x02},	 // MC3_PXDEF2_POS2 :
{0x771A,0x00B3,0x02},	 // MC3_PYDEF2_POS2 :
{0x771C,0xFFD7,0x02},	 // MC3_PXDEF3_POS2 :
{0x771E,0x0068,0x02},	 // MC3_PYDEF3_POS2 :
{0x7720,0x0000,0x02},	 // MC3_PXDEF0_POS3 :
{0x7722,0xFF80,0x02},	 // MC3_PYDEF0_POS3 :
{0x7724,0x0000,0x02},	 // MC3_PXDEF1_POS3 :
{0x7726,0x0000,0x02},	 // MC3_PYDEF1_POS3 :
{0x7728,0x0000,0x02},	 // MC3_PXDEF2_POS3 :
{0x772A,0x0000,0x02},	 // MC3_PYDEF2_POS3 :
{0x772C,0xFFD7,0x02},	 // MC3_PXDEF3_POS3 :
{0x772E,0x0068,0x02},	 // MC3_PYDEF3_POS3 :
{0x7730,0x0000,0x02},	 // MC3_PXDEF0_POS4 :
{0x7732,0xFFCC,0x02},	 // MC3_PYDEF0_POS4 :
{0x7734,0x0000,0x02},	 // MC3_PXDEF1_POS4 :
{0x7736,0x0000,0x02},	 // MC3_PYDEF1_POS4 :
{0x7738,0x0000,0x02},	 // MC3_PXDEF2_POS4 :
{0x773A,0x0000,0x02},	 // MC3_PYDEF2_POS4 :
{0x773C,0xFFD7,0x02},	 // MC3_PXDEF3_POS4 :
{0x773E,0x0068,0x02},	 // MC3_PYDEF3_POS4 :
{0x7740,0x0000,0x02},	 // MC3_PXDEF0_POS5 :
{0x7742,0xFFCC,0x02},	 // MC3_PYDEF0_POS5 :
{0x7744,0x0000,0x02},	 // MC3_PXDEF1_POS5 :
{0x7746,0x0000,0x02},	 // MC3_PYDEF1_POS5 :
{0x7748,0x0000,0x02},	 // MC3_PXDEF2_POS5 :
{0x774A,0x0000,0x02},	 // MC3_PYDEF2_POS5 :
{0x774C,0xFFD7,0x02},	 // MC3_PXDEF3_POS5 :
{0x774E,0x0068,0x02},	 // MC3_PYDEF3_POS5 :
{0x7750,0xFFB3,0x02},	 // MC3_PXDEF0_POS6 :
{0x7752,0x0000,0x02},	 // MC3_PYDEF0_POS6 :
{0x7754,0x0033,0x02},	 // MC3_PXDEF1_POS6 :
{0x7756,0xFF4C,0x02},	 // MC3_PYDEF1_POS6 :
{0x7758,0x0000,0x02},	 // MC3_PXDEF2_POS6 :
{0x775A,0x00B3,0x02},	 // MC3_PYDEF2_POS6 :
{0x775C,0xFFD7,0x02},	 // MC3_PXDEF3_POS6 :
{0x775E,0x0068,0x02},	 // MC3_PYDEF3_POS6 :
{0x7760,0xFFB3,0x02},	 // MC3_PXDEF0_POS7 :
{0x7762,0x0000,0x02},	 // MC3_PYDEF0_POS7 :
{0x7764,0x0000,0x02},	 // MC3_PXDEF1_POS7 :
{0x7766,0x0000,0x02},	 // MC3_PYDEF1_POS7 :
{0x7768,0x0000,0x02},	 // MC3_PXDEF2_POS7 :
{0x776A,0x0000,0x02},	 // MC3_PYDEF2_POS7 :
{0x776C,0xFFD7,0x02},	 // MC3_PXDEF3_POS7 :
{0x776E,0x0068,0x02},	 // MC3_PYDEF3_POS7 :
{0x7770,0x0019,0x02},	 // MC3_PXDEF0_OUT :
{0x7772,0xFFE6,0x02},	 // MC3_PYDEF0_OUT :
{0x7774,0x0000,0x02},	 // MC3_PXDEF1_OUT :
{0x7776,0x0000,0x02},	 // MC3_PYDEF1_OUT :
{0x7778,0x0000,0x02},	 // MC3_PXDEF2_OUT :
{0x777A,0x0000,0x02},	 // MC3_PYDEF2_OUT :
{0x777C,0xFFE1,0x02},	 // MC3_PXDEF3_OUT :
{0x777E,0xFFEB,0x02},	 // MC3_PYDEF3_OUT :
{0x7780,0x0000,0x02},	 // MC3_PXDEF0_R2_POS4 :
{0x7782,0xFFCC,0x02},	 // MC3_PYDEF0_R2_POS4 :
{0x7784,0x0000,0x02},	 // MC3_PXDEF1_R2_POS4 :
{0x7786,0x0000,0x02},	 // MC3_PYDEF1_R2_POS4 :
{0x7788,0x0000,0x02},	 // MC3_PXDEF2_R2_POS4 :
{0x778A,0x0000,0x02},	 // MC3_PYDEF2_R2_POS4 :
{0x778C,0xFFD7,0x02},	 // MC3_PXDEF3_R2_POS4 :
{0x778E,0x0068,0x02},	 // MC3_PYDEF3_R2_POS4 :
{0x7790,0x0000,0x02},	 // MC3_PXDEF0_R2_POS5 :
{0x7792,0xFFCC,0x02},	 // MC3_PYDEF0_R2_POS5 :
{0x7794,0x0000,0x02},	 // MC3_PXDEF1_R2_POS5 :
{0x7796,0x0000,0x02},	 // MC3_PYDEF1_R2_POS5 :
{0x7798,0x0000,0x02},	 // MC3_PXDEF2_R2_POS5 :
{0x779A,0x0000,0x02},	 // MC3_PYDEF2_R2_POS5 :
{0x779C,0xFFD7,0x02},	 // MC3_PXDEF3_R2_POS5 :
{0x779E,0x0068,0x02},	 // MC3_PYDEF3_R2_POS5 :
};

static const isx012_regset_t ISX012_Halfrelease_Mode[] =
{
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B1,0x01,0x01},    //AF_RESTART_F :
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x00,0x01},    //AFMODE_HREL :
//{0xFFFF,0x42,0x01},  //$wait, 66
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t ISX012_Barcode_SAF[] =
{
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B1,0x01,0x01},    //AF_RESTART_F :
//{0xFFFF,0x21,0x01},  //$wait, 33
{0x00B2,0x00,0x01},    //AFMODE_MONI :
};

static const isx012_regset_t ISX012_Lowlux_night_Halfrelease_Mode[] =
{
{0x660E,0x04,0x01},    // AF_HBPF_PEAK_OPD_TH_MIN
{0x6610,0x04,0x01},    // AF_HBPF_PEAK_OPD_TH_MAX
{0x664A,0x01,0x01},    // AF_DROPN_ON_PEAK_DETECT :
{0x6640,0x01,0x01},    // AF_DROPN_ON_PEAK_DETECT_SECOND :
{0x0289,0x21,0x01},    //AWB_SN8
{0x6674,0x01,0x01},    // AF_MONICHG_MOVE_F
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B1,0x01,0x01},    //AF_RESTART_F
{0x00B3,0x00,0x01},    //AFMODE_HREL :
//{0xFFFF,0x42,0x01},  //$wait, 66
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t ISX012_AF_Cancel_Macro_ON[] =
{
{0x6674,0x00,0x01},    // AF_MONICHG_MOVE_F
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x02BC,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x00B1,0x01,0x01},    //AF_RESTART_F
};

static const isx012_regset_t ISX012_AF_Cancel_Macro_OFF[] =
{
{0x6674,0x00,0x01},    // AF_MONICHG_MOVE_F
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x00C8,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x00B1,0x01,0x01},    //AF_RESTART_F
};

static const isx012_regset_t ISX012_AF_ReStart[] =
{
{0x00B1,0x01,0x01},    //AF_RESTART_F
{0x0082,0x01,0x01},    // MONI_REFRESH
};

static const isx012_regset_t ISX012_AF_Macro_OFF[] =
{
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x00C8,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x66DC,0x02BC,0x02},    //AF_JUDGE_MONO_POS_S
{0x665A,0x00C8,0x02},    // AF_LENSPOS_ON_AFNG :
{0x028E,0x00,0x01},    //AF_SEARCH_DIR : NEAR->FAR
{0x00B3,0x00,0x01},    //AFMODE_HREL : Manual AF mode
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
//{0xFFFF,0x21,0x01},  //$wait, 33
};

static const isx012_regset_t ISX012_AF_Macro_ON[] =
{
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6648,0x02BC,0x02},    //AF_MANUAL_POS : MANUA AF search start position
{0x66DC,0x00C8,0x02},    //AF_JUDGE_MONO_POS_S
{0x665A,0x02BC,0x02},    // AF_LENSPOS_ON_AFNG :
{0x028E,0x01,0x01},    //AF_SEARCH_DIR : NEAR->FAR
{0x00B3,0x00,0x01},    //AFMODE_HREL : Manual AF mode
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
//{0xFFFF,0x21,0x01},  //$wait, 33
};

static const isx012_regset_t ISX012_AF_SAF[] =
{
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B1,0x01,0x01},    //AF_RESTART_F :
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x00,0x01},    //AFMODE_HREL :
//{0xFFFF,0x42,0x01},  //$wait, 66
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t ISX012_AF_SAF_OFF[] =
{
{0x6674,0x00,0x01},    // AF_MONICHG_MOVE_F
{0x0082,0x01,0x01},    // MONI_REFRESH
//{0xFFFF,0x42,0x01},  //$wait, 66
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x03,0x01},    //AFMODE_HREL : AF OFF
};

static const isx012_regset_t ISX012_AF_TouchSAF_OFF[] =
{
{0x6674,0x00,0x01},    // AF_MONICHG_MOVE_F
{0x0082,0x01,0x01},    // MONI_REFRESH
//{0xFFFF,0x42,0x01},  //$wait, 66
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x03,0x01},    //AFMODE_HREL : AF OFF
{0x0081,0x00,0x01},    //MODESEL
};

static const isx012_regset_t ISX012_Camcorder_SAF_Start[] =
{
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B1,0x01,0x01}, /* AF_RESTART_F */
//{0xFFFF,0x21,0x01}, /* $wait, 33 */
{0x00B2,0x00,0x01}, /* AFMODE_MONI */
};

static const isx012_regset_t ISX012_Camcorder_CAF_Start[] =
{
{0x00B2,0x01,0x01}, /* AFMODE_MONI */
};

static const isx012_regset_t ISX012_AF_Window_Reset[] =
{
//AF opd window setting
{0x6A30,0x044E,0x02},    // AF_OPD0_HDELAY :
{0x6A32,0x02E5,0x02},    // AF_OPD0_VDELAY :
{0x6A34,0x01D8,0x02},    // AF_OPD0_HVALID :
{0x6A36,0x01D8,0x02},    // AF_OPD0_VVALID :
{0x6A38,0x0412,0x02},    // AF_OPD1_HDELAY :
{0x6A3A,0x02A9,0x02},    // AF_OPD1_VDELAY :
{0x6A3C,0x0251,0x02},    // AF_OPD1_HVALID :
{0x6A3E,0x0251,0x02},    // AF_OPD1_VVALID :
{0x6A40,0x04B4,0x02},    // AF_OPD2_HDELAY :
{0x6A42,0x0114,0x02},    // AF_OPD2_VDELAY :
{0x6A44,0x0118,0x02},    // AF_OPD2_HVALID :
{0x6A46,0x0118,0x02},    // AF_OPD2_VVALID :
{0x6A48,0x0469,0x02},    // AF_OPD3_HDELAY :
{0x6A4A,0x00C9,0x02},    // AF_OPD3_VDELAY :
{0x6A4C,0x01AE,0x02},    // AF_OPD3_HVALID :
{0x6A4E,0x01AE,0x02},    // AF_OPD3_VVALID :
{0x6A50,0x04C6,0x02},    // AF_OPD4_HDELAY :
{0x6A52,0x035D,0x02},    // AF_OPD4_VDELAY :
{0x6A54,0x00E6,0x02},    // AF_OPD4_HVALID :
{0x6A56,0x00E6,0x02},    // AF_OPD4_VVALID :
{0x6A58,0x048A,0x02},    // AF_OPD5_HDELAY :
{0x6A5A,0x0321,0x02},    // AF_OPD5_VDELAY :
{0x6A5C,0x015F,0x02},    // AF_OPD5_HVALID :
{0x6A5E,0x015F,0x02},    // AF_OPD5_VVALID :
{0x6A60,0x04B4,0x02},    // AF_OPD6_HDELAY :
{0x6A62,0x0579,0x02},    // AF_OPD6_VDELAY :
{0x6A64,0x0118,0x02},    // AF_OPD6_HVALID :
{0x6A66,0x0118,0x02},    // AF_OPD6_VVALID :
{0x6A68,0x0469,0x02},    // AF_OPD7_HDELAY :
{0x6A6A,0x052C,0x02},    // AF_OPD7_VDELAY :
{0x6A6C,0x01AE,0x02},    // AF_OPD7_HVALID :
{0x6A6E,0x01AE,0x02},    // AF_OPD7_VVALID :
{0x6A70,0x021D,0x02},    // AF_OPD8_HDELAY :
{0x6A72,0x02F5,0x02},    // AF_OPD8_VDELAY :
{0x6A74,0x01AE,0x02},    // AF_OPD8_HVALID :
{0x6A76,0x01AE,0x02},    // AF_OPD8_VVALID :
{0x6A78,0x06A4,0x02},    // AF_OPD9_HDELAY :
{0x6A7A,0x02F5,0x02},    // AF_OPD9_VDELAY :
{0x6A7C,0x01AE,0x02},    // AF_OPD9_HVALID :
{0x6A7E,0x01AE,0x02},    // AF_OPD9_VVALID :
{0x6A80,0x06,0x01},    // AF_OPD1A_WEIGHT :
{0x6A81,0x05,0x01},    // AF_OPD1B_WEIGHT :
{0x6A82,0x02,0x01},    // AF_OPD2A_WEIGHT :
{0x6A83,0x02,0x01},    // AF_OPD2B_WEIGHT :
{0x6A84,0x08,0x01},    // AF_OPD3A_WEIGHT :
{0x6A85,0x07,0x01},    // AF_OPD3B_WEIGHT :
{0x6A86,0x04,0x01},    // AF_OPD4A_WEIGHT :
{0x6A87,0x03,0x01},    // AF_OPD4B_WEIGHT :
{0x6A88,0x01,0x01},    // AF_OPD5A_WEIGHT :
{0x6A89,0x01,0x01},    // AF_OPD5B_WEIGHT :
{0x6646,0x08,0x01},    // AF_OPD_WEIGHT_TH :
};

/* Added by Samsung TN */
static const isx012_regset_t ISX012_AF_Window_Set[] =
{
{0x6A80,0x00,0x01},
{0x6A81,0x00,0x01},
{0x6A82,0x00,0x01},
{0x6A83,0x00,0x01},
{0x6A84,0x08,0x01},
{0x6A85,0x00,0x01},
{0x6A86,0x00,0x01},
{0x6A87,0x00,0x01},
{0x6A88,0x00,0x01},
{0x6A89,0x00,0x01},
{0x6646,0x08,0x01},
};

static const isx012_regset_t isx012_Contrast_Minus_2[] =
{
{0x01C7,0x58,0x01},    //UICONTRAST
};

static const isx012_regset_t isx012_Contrast_Minus_1[] =
{
{0x01C7,0x6C,0x01},    //UICONTRAST
};

static const isx012_regset_t isx012_Contrast_Default[] =
{
{0x01C7,0x80,0x01},    //UICONTRAST
};

static const isx012_regset_t isx012_Contrast_Plus_1[] =
{
{0x01C7,0x94,0x01},    //UICONTRAST
};

static const isx012_regset_t isx012_Contrast_Plus_2[] =
{
{0x01C7,0xA8,0x01},    //UICONTRAST
};

static const isx012_regset_t isx012_Effect_Sketch[] =
{
{0x01C5,0x06,0x01}, /* FMODE */
{0x6C5F,0x04,0x01}, /* SKETCH_APGAIN */
};

static const isx012_regset_t isx012_Effect_Pastel[] =
{
{0x01C5,0x05,0x01}, /* FMODE */
};

static const isx012_regset_t isx012_Effect_Black_White[] =
{
{0x01C5,0x04,0x01},    //FMODE
};

static const isx012_regset_t ISX012_Effect_Negative[] =
{
{0x01C5,0x02,0x01},    //FMODE
};

static const isx012_regset_t isx012_Effect_Solar[] =
{
{0x01C5,0x01,0x01},    /* FMODE */
};

static const isx012_regset_t isx012_Effect_Normal[] =
{
{0x01C5,0x00,0x01},    //FMODE
};

static const isx012_regset_t isx012_Effect_Sepia[] =
{
{0x01C5,0x03,0x01},    //FMODE
};

static const isx012_regset_t isx012_Metering_Center[] =
{
{0x02AC,0x01,0x01},    //AE_SUB_SN1
{0x02B6,0x01,0x01},    //AE_SUB_SN11
};

static const isx012_regset_t isx012_Metering_Matrix[] =
{
{0x02AC,0x00,0x01},    //AE_SUB_SN1
};

static const isx012_regset_t isx012_Metering_Spot[] =
{
{0x02AC,0x02,0x01},    //AE_SUB_SN1
{0x02B6,0x02,0x01},    //AE_SUB_SN11
};

static const isx012_regset_t ISX012_ExpSetting_Default[] =
{
{0x0180,0x00,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_M1Step[] =
{
{0x0180,0xFF,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_M2Step[] =
{
{0x0180,0xFE,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_M3Step[] =
{
{0x0180,0xFD,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_M4Step[] =
{
{0x0180,0xFC,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_P1Step[] =
{
{0x0180,0x01,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_P2Step[] =
{
{0x0180,0x02,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_P3Step[] =
{
{0x0180,0x03,0x01},    //EVSEL
};

static const isx012_regset_t ISX012_ExpSetting_P4Step[] =
{
{0x0180,0x04,0x01},    //EVSEL
};

static const isx012_regset_t isx012_ISO_50[] =
{
{0x02A8,0x04,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t isx012_ISO_100[] =
{
{0x02A8,0x07,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t isx012_ISO_200[] =
{
{0x02A8,0x0A,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t isx012_ISO_400[] =
{
{0x02A8,0x0D,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};

#if 0
static const isx012_regset_t ISX012_ISO_800[] =
{
{0x02A8,0x10,0x01},    //ISO_TYPE1
{0x5E8A,0x00,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x00,0x01},    // EVREF_GAIN_B :
{0x0362,0x57,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x57,0x01},    // PICT3_GAMMA_CAP0 :
};
#endif

static const isx012_regset_t isx012_ISO_Auto[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1
{0x5E8A,0x02,0x01},    // EVREF_GAIN_A :
{0x5E8B,0x02,0x01},    // EVREF_GAIN_B :
{0x0362,0x55,0x01},    // PICT3_GAMMA_MONI0 :
{0x0365,0x55,0x01},    // PICT3_GAMMA_CAP0 :
};

static const isx012_regset_t ISX012_Capture_SizeSetting[] =
{
{0x0092,0x0A20,0x02},    //HSIZE_CAP : 2592
{0x0098,0x0798,0x02},    //VSIZE_CAP : 1944
};

static const isx012_regset_t ISX012_Capture_Mode[] =
{
{0x008A,0x00,0x01},    //OUTFMT_CAP
{0x0084,0x00,0x01},    //SENSMODE_CAP
{0x0087,0x03,0x01},    //FPSTYPE_CAP
{0x0012,0xFF,0x01},    //INTCLR0
{0x0081,0x02,0x01},    //MODESEL
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t ISX012_Lowlux_Night_Capture_Mode[] =
{
{0x03A0,0xA0,0x01},    //UISATURATION_TYPE3 :
{0x039D,0xF4,0x01},    //UIHUE_TYPE3 :
{0x982A,0xFFD8,0x02},    // CS_CBLLEV_A :
{0x9830,0xFFD8,0x02},    // CS_CRLLEV_A :
{0x9805,0x06,0x01},    // CS_SLP_C_A :
{0x008A,0x00,0x01},    //OUTFMT_CAP
{0x0084,0x00,0x01},    //SENSMODE_CAP
{0x0087,0x03,0x01},    //FPSTYPE_CAP
{0x0012,0xFF,0x01},    //INTCLR0
{0x0081,0x02,0x01},    //MODESEL
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t isx012_Saturation_Default[] =
{
{0x039E,0x80,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t isx012_Saturation_Minus_1[] =
{
{0x039E,0x62,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t isx012_Saturation_Minus_2[] =
{
{0x039E,0x44,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t isx012_Saturation_Plus_1[] =
{
{0x039E,0x9E,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t isx012_Saturation_Plus_2[] =
{
{0x039E,0xBC,0x01},    //UISATURATION_TYPE1
};

static const isx012_regset_t isx012_Scene_Default[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Landscape[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x039F,0x9E,0x01},    //UISATURATION_TYPE2 :
{0x03A3,0x2C,0x01},    //UISHARPNESS_POS_TYPE3 : +1
{0x03A6,0x2C,0x01},    //UISHARPNESS_NEG_TYPE3 : +1
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x01,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Sports[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x02,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Party_Indoor[] =
{
{0x02A8,0x0A,0x01},    //ISO_TYPE1 : ISO200
{0x039F,0x9E,0x01},    //UISATURATION_TYPE2 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x04,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Beach_Snow[] =
{
{0x02A8,0x04,0x01},    //ISO_TYPE1 : ISO50
{0x039F,0x9E,0x01},    //UISATURATION_TYPE2 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x04,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Sunset[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x0287,0x25,0x01},    //AWB_SN6 : daylight
{0x0394,0x00,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Duskdawn[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x0287,0x27,0x01},    //AWB_SN6 : CWF
{0x0394,0x00,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Candle_Light[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x0287,0x25,0x01},    //AWB_SN6 : daylight
{0x0394,0x00,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Fall_Color[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x039F,0xBC,0x01},    //UISATURATION_TYPE2 :
{0x0287,0x20,0x01},    //AWB_SN6 : AWB
{0x0394,0x04,0x01},    //PICT1_SN6 :
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x05,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Portrait[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x50,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Nightshot[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x07,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Fireworks[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : AUTO
{0x5E06,0x04,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x08,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Text[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x03A3,0x38,0x01},    //UISHARPNESS_POS_TYPE3 : +2
{0x03A6,0x38,0x01},    //UISHARPNESS_NEG_TYPE3 : +2
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0xA0,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Scene_Backlight[] =
{
{0x02A8,0x00,0x01},    //ISO_TYPE1 : Auto
{0x5E06,0x02,0x01},    //SHTCTRLMAG3
{0x038F,0x00,0x01},    //PICT1_SN1 :
{0x6742,0x0012,0x02},    // AF_SEARCH_OFFSET_FAR :
{0x6744,0x0006,0x02},    // AF_SEARCH_OFFSET_NEAR :
{0x500B,0x01,0x01},    // FAST_SHT_MODE_SEL
{0x0280,0x00,0x01},    //SCENE_SELECT
};

static const isx012_regset_t isx012_Sharpness_Default[] =
{
{0x00A1,0x20,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x20,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t isx012_Sharpness_Minus_1[] =
{
{0x00A1,0x14,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x14,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t isx012_Sharpness_Minus_2[] =
{
{0x00A1,0x08,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x08,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t isx012_Sharpness_Plus_1[] =
{
{0x00A1,0x2C,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x2C,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t isx012_Sharpness_Plus_2[] =
{
{0x00A1,0x38,0x01},    //UISHARPNESS_POS_TYPE1
{0x00A4,0x38,0x01},    //UISHARPNESS_NEG_TYPE1
};

static const isx012_regset_t isx012_WB_Auto[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_WB_Cloudy[] =
{
{0x0282,0x26,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_WB_Sunny[] =
{
{0x0282,0x25,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_WB_Fluorescent[] =
{
{0x0282,0x27,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_WB_Tungsten[] =
{
{0x0282,0x28,0x01},    //AWB_SN1
};

static const isx012_regset_t ISX012_Image_Quality_Standard[] =
{
{0x00F6,0x00,0x01},    //JPG_QLTY
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t ISX012_Image_Quality_Fine[] =
{
{0x00F6,0x01,0x01},    //JPG_QLTY
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t ISX012_Image_Quality_Super_Fine[] =
{
{0x00F6,0x02,0x01},    //JPG_QLTY
{0x0082,0x01,0x01},    //MONI_REFRESH
};

static const isx012_regset_t ISX012_Image_Quality_Table[] =
{
{0x00F7,0x52,0x01},    // INIT_QLTY0 : Standard 82
{0x00F8,0x59,0x01},    // INIT_QLTY1 : Fine 89
{0x00F9,0x5F,0x01},    // INIT_QLTY2 : SuperFine 95
};

static const isx012_regset_t ISX012_Sensor_Off_VCM[] =
{
{0x6674,0x00,0x01},    // AF_MONICHG_MOVE_F
{0x00B2,0x02,0x01},    //AFMODE_MONI : Manual AF mode
{0x0081,0x00,0x01},    //MODESEL : Monitoring mode
{0x6600,0x0000,0x02},    // AF_SEARCH_AREA_LOW
{0x6666,0x0000,0x02},    // AF_AREA_LOW_TYPE1
{0x6648,0x00C8,0x02},    // AF_MANUAL_POS :
{0x00B1,0x01,0x01},    //AF_RESTART_F
{0xFFFF,0x64,0x01},    // $wait, 100
{0x6648,0x0019,0x02},    // AF_MANUAL_POS :
{0x00B1,0x01,0x01},    // AF_RESTART_F
{0xFFFF,0x64,0x01},    // $wait, 100
};

static const isx012_regset_t isx012_1280_Preview_E[] =
{
{0x0090,0x0500,0x02},	 //HSIZE_MONI : 1280
{0x0096,0x02D0,0x02},	 //VSIZE_MONI : 720
};

static const isx012_regset_t isx012_1024_768_Preview[] = {
{0x0090,0x0400,0x02}, /* HSIZE_MONI : 1024 */
{0x0096,0x0300,0x02}, /* VSIZE_MONI : 768 */
};

static const isx012_regset_t isx012_800_Preview[] =
{
{0x0090,0x0320,0x02},	 //HSIZE_MONI : 800
{0x0096,0x01E0,0x02},	 //VSIZE_MONI : 480
};

static const isx012_regset_t isx012_720_Preview[] =
{
{0x0090,0x02D0,0x02},	 //HSIZE_MONI : 720
{0x0096,0x01E0,0x02},	 //VSIZE_MONI : 480
};

static const isx012_regset_t isx012_640_Preview[] =
{
{0x0090,0x0280,0x02},	 //HSIZE_MONI : 640
{0x0096,0x01E0,0x02},	 //VSIZE_MONI : 480
};

#if defined(CONFIG_MACH_P4NOTELTE_KOR_SKT) \
	|| defined(CONFIG_MACH_P4NOTELTE_KOR_KT) \
	|| defined(CONFIG_MACH_P4NOTELTE_KOR_LGT) /*For 4G VT call in Domestic*/
static const isx012_regset_t isx012_480_Preview[] = {
{0x0090, 0x01E0, 0x02},		/* HSIZE_MONI : 480 */
{0x0096, 0x0280, 0x02},		/* VSIZE_MONI : 640 */
};
#endif

static const isx012_regset_t isx012_320_Preview[] =
{
{0x0090,0x0140,0x02},	 //HSIZE_MONI : 320
{0x0096,0x00F0,0x02},	 //VSIZE_MONI :240

};
static const isx012_regset_t isx012_176_Preview[] =
{
{0x0090,0x00B0,0x02},	 //HSIZE_MONI : 176
{0x0096,0x0090,0x02},	 //VSIZE_MONI : 144
};


static const isx012_regset_t isx012_5M_Capture[] = {
{0x0092,0x0A00,0x02}, /* HSIZE_CAP: 2560 */
{0x0098,0x0780,0x02}, /* VSIZE_CAP: 1920 */
};

static const isx012_regset_t isx012_4M_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_3M_Capture[] = {
{0x0092,0x0800,0x02}, /* HSIZE_CAP : 2048 */
{0x0098,0x0600,0x02}, /* VSIZE_CAP : 1536 */
};

static const isx012_regset_t isx012_2_4M_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_1_5M_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_960_720_Capture[] = {
{0x0092,0x03C0,0x02}, /* HSIZE_CAP : 960 */
{0x0098,0x02D0,0x02}, /* VSIZE_CAP : 720 */
};

static const isx012_regset_t isx012_1M_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_4K_WIDE_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_VGA_Capture[] = {
{0x0092,0x0280,0x02}, /* HSIZE_CAP : 640 */
{0x0098,0x01E0,0x02}, /* VSIZE_CAP : 480 */
};

static const isx012_regset_t isx012_QVGA_Capture[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_DTP_init[] =
{
{0x01BC,0x50,0x01},//Shading Gain off
{0x5E00,0x07,0x01},//Flicker off

// Pre-WB
{0x6804,0x1000,0x02}, // NORMR
{0x6806,0x1000,0x02}, // NORMB
{0x6808,0x0100,0x02}, // AWBPRER
{0x680A,0x0100,0x02}, // AWBPREB
{0x6818,0x00,0x01},    //REFERENCE SENSITIVITY RATIO OF SENSOR (R/G)
{0x6819,0x00,0x01},    //REFERENCE SENSITIVITY RATIO OF SENSOR (B/G)

{0x036B,0x11,0x01},
{0x0377,0x11,0x01},
{0x0383,0x11,0x01},

//
{0x6C44,0x00,0x01},    // G_CTRL_SEL :

//CNR
{0x6C4A,0x07,0x01},    // MAIN_CONFIG5 :

//ITP NR
{0x5005,0xBB,0x01},    // DM_SW1 :
{0x5006,0x03,0x01},    // DM_SW2 :
{0x0362,0x00,0x01},

{0x6C0B,0x04,0x01},    // PICT_FLAG :
{0x9800,0x80,0x01},    // LMT_WEIGHT_A :
{0x9801,0x80,0x01},    // LMT_WEIGHT_B :

{0x6C46,0x00,0x01},    // MAIN_CONFIG1 :
{0x6C47,0x00,0x01},    // MAIN_CONFIG2 :
{0x6C48,0x00,0x01},    // MAIN_CONFIG3 :
{0x6C49,0x00,0x01},    // MAIN_CONFIG4 :
{0x6C4A,0x00,0x01},    // MAIN_CONFIG5 :


{0x5001,0x04,0x01},    // MUTECNT :
{0x5002,0x00,0x01},    // WDT_EN :
{0x5003,0x07,0x01},    // Z1_SEL1 :
{0x5004,0x00,0x01},    // Z1_SEL2 :
{0x5005,0x00,0x01},    // DM_SW1 :
{0x5006,0x00,0x01},    // DM_SW2 :
{0x5007,0x00,0x01},    // CLMP_CTRL :
{0x5009,0x00,0x01},    // CPUSLEEP_EN :
{0x500A,0x00,0x01},    // FAST_MODECHG_EN :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL :
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT :
{0x500E,0x06D0,0x02},    // SYSINT3_VDLY_1_1 :
{0x5010,0x02F8,0x02},    // SYSINT3_VDLY_1_2 :
{0x5012,0x0118,0x02},    // SYSINT3_VDLY_1_4 :
{0x5014,0x0028,0x02},    // SYSINT3_VDLY_1_8 :
{0x5016,0x0370,0x02},    // SYSINT3_VDLY_1_1_HD :
{0x5018,0x0208,0x02},    // SYSINT3_VDLY_1_2_HD :
{0x501A,0x00,0x01},    // SENS_REVERSE_CTRL :
{0x501B,0x19,0x01},    // EEP_ADDRESS :
{0x501C,0x5180,0x02},    // SRCCK :
{0x501E,0x0001,0x02},

{0x6E86,0x0000,0x02},    // IBYHUE1_POS1 :
{0x6E88,0xFFF5,0x02},    // IRYHUE1_POS1 :
{0x6E8A,0xFFF8,0x02},    // IBYHUE2_POS1 :
{0x6E8C,0xFFF5,0x02},    // IRYHUE2_POS1 :
{0x6E8E,0xFFF8,0x02},    // IBYHUE3_POS1 :
{0x6E90,0xFFEE,0x02},    // IRYHUE3_POS1 :
{0x6E92,0x0000,0x02},    // IBYHUE4_POS1 :
{0x6E94,0xFFEC,0x02},    // IRYHUE4_POS1 :
{0x6F26,0x4E,0x01},    // IRYGAIN1_POS1 :
{0x6F27,0x50,0x01},    // IBYGAIN1_POS1 :
{0x6F28,0x4E,0x01},    // IRYGAIN2_POS1 :
{0x6F29,0x5A,0x01},    // IBYGAIN2_POS1 :
{0x6F2A,0x50,0x01},    // IRYGAIN3_POS1 :
{0x6F2B,0x5A,0x01},    // IBYGAIN3_POS1 :
{0x6F2C,0x50,0x01},    // IRYGAIN4_POS1 :
{0x6F2D,0x50,0x01},    // IBYGAIN4_POS1 :

//ae
{0x5E12,0x0000,0x02},
{0x5E14,0x0000,0x02},
{0x0294,0x03,0x01},

//AWB
{0x625F,0x35,0x01},//CAT_AWB_1
{0x0282,0x05,0x01},//AWB_SN1
//S, 5000, 3F, 8,    // CPUEXT :


{0x5021,0x00,0x01},    // PG_GAIN_SEL :
{0x5022,0x01,0x01},    // PG_WIDTH_SEL :
{0x5023,0x04,0x01},    // PG_MODE_SEL :
{0x5024,0x0000,0x02},    // PG_LEVEL_SEL :
{0x5026,0x00,0x01},    // PG_DATEN_OFF_SEL :
{0x5020,0x01,0x01},    // PGSEL :

};

static const isx012_regset_t isx012_DTP_stop[] =
{
{0x01BC,0x57,0x01},    // Shading Gain off
{0x5E00,0x00,0x01},    // Flicker off
{0x6804,0x11F0,0x02},    // NORMR
{0x6806,0x106F,0x02},    // NORMB
{0x6808,0x014C,0x02},    // AWBPRER
{0x680A,0x021E,0x02},    // AWBPREB
{0x6818,0x00,0x01},    // REFERENCE SENSITIVITY RATIO OF SENSOR (R/G)
{0x6819,0x00,0x01},    // REFERENCE SENSITIVITY RATIO OF SENSOR (B/G)
{0x036B,0x80,0x01},    //
{0x0377,0x80,0x01},    //
{0x0383,0x80,0x01},    //
{0x6C44,0x13,0x01},    // G_CTRL_SEL :
{0x6C4A,0x07,0x01},    // MAIN_CONFIG5 :
{0x5005,0xBB,0x01},    // DM_SW1 :
{0x5006,0x03,0x01},    // DM_SW2 :
{0x0362,0x55,0x01},    //
{0x6C0B,0x00,0x01},    // PICT_FLAG :
{0x9800,0x40,0x01},    // LMT_WEIGHT_A :
{0x9801,0x80,0x01},    // LMT_WEIGHT_B :
{0x6C46,0x1C,0x01},    // MAIN_CONFIG1 :
{0x6C47,0x0F,0x01},    // MAIN_CONFIG2 :
{0x6C48,0x03,0x01},    // MAIN_CONFIG3 :
{0x6C49,0xF5,0x01},    // MAIN_CONFIG4 :
{0x6C4A,0x07,0x01},    // MAIN_CONFIG5 :
{0x5001,0x04,0x01},    // MUTECNT :
{0x5002,0x01,0x01},    // WDT_EN :
{0x5003,0x04,0x01},    // Z1_SEL1 :
{0x5004,0x00,0x01},    // Z1_SEL2 :
{0x5005,0xBB,0x01},    // DM_SW1 :
{0x5006,0x03,0x01},    // DM_SW2 :
{0x5007,0x01,0x01},    // CLMP_CTRL :
{0x5009,0x00,0x01},    // CPUSLEEP_EN :
{0x500A,0x00,0x01},    // FAST_MODECHG_EN :
{0x500B,0x00,0x01},    // FAST_SHT_MODE_SEL :
{0x500C,0x00FA,0x02},    // FAST_SHT_LIMIT_COUNT :
{0x500E,0x06D0,0x02},    // SYSINT3_VDLY_1_1 :
{0x5010,0x02F8,0x02},    // SYSINT3_VDLY_1_2 :
{0x5012,0x0118,0x02},    // SYSINT3_VDLY_1_4 :
{0x5014,0x0028,0x02},    // SYSINT3_VDLY_1_8 :
{0x5016,0x0370,0x02},    // SYSINT3_VDLY_1_1_HD :
{0x5018,0x0208,0x02},    // SYSINT3_VDLY_1_2_HD :
{0x501A,0x00,0x01},    // SENS_REVERSE_CTRL :
{0x501B,0x50,0x01},    // EEP_ADDRESS :
{0x501C,0x5180,0x02},    // SRCCK :
{0x501E,0x0001,0x02},
{0x6E86,0x0000,0x02},    // IBYHUE1_POS1 :
{0x6E88,0xFFF5,0x02},    // IRYHUE1_POS1 :
{0x6E8A,0xFFF8,0x02},    // IBYHUE2_POS1 :
{0x6E8C,0xFFF5,0x02},    // IRYHUE2_POS1 :
{0x6E8E,0xFFF8,0x02},    // IBYHUE3_POS1 :
{0x6E90,0xFFEE,0x02},    // IRYHUE3_POS1 :
{0x6E92,0x0000,0x02},    // IBYHUE4_POS1 :
{0x6E94,0xFFEC,0x02},    // IRYHUE4_POS1 :
{0x6F26,0x4E,0x01},    // IRYGAIN1_POS1 :
{0x6F27,0x50,0x01},    // IBYGAIN1_POS1 :
{0x6F28,0x4E,0x01},    // IRYGAIN2_POS1 :
{0x6F29,0x5A,0x01},    // IBYGAIN2_POS1 :
{0x6F2A,0x50,0x01},    // IRYGAIN3_POS1 :
{0x6F2B,0x5A,0x01},    // IBYGAIN3_POS1 :
{0x6F2C,0x50,0x01},    // IRYGAIN4_POS1 :
{0x6F2D,0x50,0x01},    // IBYGAIN4_POS1 :
{0x5E12,0x014A,0x02},    //
{0x5E14,0x000D,0x02},    //
{0x0294,0x00,0x01},    //
{0x625F,0x35,0x01},    // CAT_AWB_1
{0x0282,0x20,0x01},    // AWB_SN1
{0x5021,0x00,0x01},    // PG_GAIN_SEL :
{0x5022,0x00,0x01},    // PG_WIDTH_SEL :
{0x5023,0x00,0x01},    // PG_MODE_SEL :
{0x5024,0x0000,0x02},    // PG_LEVEL_SEL :
{0x5026,0x00,0x01},    // PG_DATEN_OFF_SEL :
{0x5020,0x00,0x01},    // PGSEL :

};

static const isx012_regset_t isx012_Preview_Return[] =
{
{0x0282,0x20,0x01},    //AWB_SN1

};

static const isx012_regset_t isx012_Capture_Start[] =
{
	{0x008A,0x00,0x01},    //OUTFMT_CAP
	{0x0084,0x00,0x01},	  //SENSMODE_CAP
	{0x0087,0x03,0x01},    //FPSTYPE_CAP
	{0x0012,0x06,0x01},    //INTCLR0
	{0x0081,0x02,0x01},    //MODESEL
	{0x0082,0x01,0x01},    //MONI_REFRESH
};
#if 0
static const isx012_regset_t isx012_Preview_Return[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};
#endif

static const isx012_regset_t isx012_fps_auto[] =
{
{0x0308,0x11,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x0012,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t isx012_fps_7fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x0D59,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t isx012_fps_15fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x041C,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t isx012_fps_25fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x00E1,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t isx012_fps_30fix[] =
{
{0x0308,0x02,0x01}, /* AELINE_MONI_SN1_2 */
{0x018E,0x0012,0x02}, /* VADJ_SENS_1_2 */
};

static const isx012_regset_t isx012_ae_lock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_ae_unlock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_awb_lock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};

static const isx012_regset_t isx012_awb_unlock[] =
{
{0x0282,0x20,0x01},    //AWB_SN1
};


static const isx012_regset_t ISX012_Shading_Nocal[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0x61,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xBE,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x9E,0x01},
{0xED09,0x2C,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x47,0x01},
{0xED0C,0x49,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0x61,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xA8,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x31,0x01},
{0xED15,0xA1,0x01},
{0xED16,0xC7,0x01},
{0xED17,0x4C,0x01},
{0xED18,0xDE,0x01},
{0xED19,0xC1,0x01},
{0xED1A,0xD2,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x76,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x10,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xC6,0x01},
{0xED22,0x40,0x01},
{0xED23,0xA2,0x01},
{0xED24,0x99,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xDC,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFC,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0xA6,0x01},
{0xED2D,0x41,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x49,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0x8C,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0B,0x01},
{0xED36,0x91,0x01},
{0xED37,0x86,0x01},
{0xED38,0x3D,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x39,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x50,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x16,0x01},
{0xED40,0xCF,0x01},
{0xED41,0xBC,0x01},
{0xED42,0x45,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x41,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xE8,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x16,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x86,0x01},
{0xED4E,0x3E,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xC1,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x02,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAE,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x44,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0xF9,0x01},
{0xED5C,0xCA,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x0C,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x98,0x01},
{0xED61,0xE2,0x01},
{0xED62,0xA8,0x01},
{0xED63,0x26,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xC1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x1C,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x93,0x01},
{0xED6C,0xA7,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xD9,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x54,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x93,0x01},
{0xED77,0xAA,0x01},
{0xED78,0x98,0x01},
{0xED79,0xE5,0x01},
{0xED7A,0x32,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x29,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x8E,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBB,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xA4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0x84,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF1,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA2,0x01},
{0xED96,0x43,0x01},
{0xED97,0x99,0x01},
{0xED98,0xE4,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x25,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB1,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x24,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x00,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEA,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0xC6,0x01},
{0xEDB1,0x3B,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0x99,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA4,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB2,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCD,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x86,0x01},
{0xEDC7,0x3D,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x01,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x80,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC3,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x25,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB1,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCC,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC7,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0xA6,0x01},
{0xEDDD,0x39,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0x91,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x54,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x1B,0x01},
{0xEDE5,0xFC,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0x46,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x71,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x46,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x17,0x01},
{0xEDF0,0xD9,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0x86,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x09,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x6A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x1E,0x01},
{0xEDFB,0x25,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x67,0x01},
{0xEDFE,0x45,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x69,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0xF6,0x01},
{0xEE04,0x93,0x01},
{0xEE05,0x9A,0x01},
{0xEE06,0xFA,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0x26,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xB9,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x6E,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x2D,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x49,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0xB9,0x01},
{0xEE17,0x52,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0x98,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x1E,0x01},
{0xEE1C,0x22,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xA7,0x01},
{0xEE1F,0x48,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x49,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xB4,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x1F,0x01},
{0xEE27,0x31,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4B,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x28,0x01},
{0xEF55,0xC2,0x01},
{0xEF56,0x11,0x01},
{0xEF57,0x8C,0x01},
{0xEF58,0x46,0x01},
{0xEF59,0x34,0x01},
{0xEF5A,0xA2,0x01},
{0xEF5B,0x12,0x01},
{0xEF5C,0xCD,0x01},
{0xEF5D,0x08,0x01},
{0xEF5E,0x47,0x01},
{0xEF5F,0x27,0x01},
{0xEF60,0xAA,0x01},
{0xEF61,0x10,0x01},
{0xEF62,0x7F,0x01},
{0xEF63,0xC2,0x01},
{0xEF64,0xF3,0x01},
{0xEF65,0x1C,0x01},
{0xEF66,0xE4,0x01},
{0xEF67,0x40,0x01},
{0xEF68,0x27,0x01},
{0xEF69,0x3C,0x01},
{0xEF6A,0xFB,0x01},
{0xEF6B,0xA1,0x01},
{0xEF6C,0x90,0x01},
{0xEF6D,0x7C,0x01},
{0xEF6E,0x92,0x01},
{0xEF6F,0x63,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC5,0x01},
{0xEF72,0x0C,0x01},
{0xEF73,0x66,0x01},
{0xEF74,0x31,0x01},
{0xEF75,0xA4,0x01},
{0xEF76,0x49,0x01},
{0xEF77,0x0E,0x01},
{0xEF78,0x7F,0x01},
{0xEF79,0xA0,0x01},
{0xEF7A,0xB3,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB6,0x01},
{0xEF7D,0x34,0x01},
{0xEF7E,0x85,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4D,0x01},
{0xEF81,0x61,0x01},
{0xEF82,0x0B,0x01},
{0xEF83,0x68,0x01},
{0xEF84,0xB6,0x01},
{0xEF85,0x73,0x01},
{0xEF86,0x9B,0x01},
{0xEF87,0xBB,0x01},
{0xEF88,0x0C,0x01},
{0xEF89,0x45,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x17,0x01},
{0xEF8C,0x11,0x01},
{0xEF8D,0x49,0x01},
{0xEF8E,0x51,0x01},
{0xEF8F,0xF4,0x01},
{0xEF90,0xC2,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD4,0x01},
{0xEF93,0x94,0x01},
{0xEF94,0xC5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0B,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x62,0x01},
{0xEF9B,0x62,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD5,0x01},
{0xEF9E,0xA4,0x01},
{0xEF9F,0xC6,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x2F,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x22,0x01},
{0xEFA7,0x13,0x01},
{0xEFA8,0xB4,0x01},
{0xEFA9,0xC0,0x01},
{0xEFAA,0x86,0x01},
{0xEFAB,0x37,0x01},
{0xEFAC,0x7B,0x01},
{0xEFAD,0x29,0x01},
{0xEFAE,0x8A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x52,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA4,0x01},
{0xEFB4,0xF4,0x01},
{0xEFB5,0x25,0x01},
{0xEFB6,0x38,0x01},
{0xEFB7,0xD9,0x01},
{0xEFB8,0x01,0x01},
{0xEFB9,0xCD,0x01},
{0xEFBA,0x5B,0x01},
{0xEFBB,0xA0,0x01},
{0xEFBC,0x72,0x01},
{0xEFBD,0x14,0x01},
{0xEFBE,0xA9,0x01},
{0xEFBF,0xCC,0x01},
{0xEFC0,0xC5,0x01},
{0xEFC1,0x34,0x01},
{0xEFC2,0xE3,0x01},
{0xEFC3,0xF1,0x01},
{0xEFC4,0x0F,0x01},
{0xEFC5,0x74,0x01},
{0xEFC6,0x50,0x01},
{0xEFC7,0xF3,0x01},
{0xEFC8,0x98,0x01},
{0xEFC9,0xC2,0x01},
{0xEFCA,0x40,0x01},
{0xEFCB,0x86,0x01},
{0xEFCC,0x35,0x01},
{0xEFCD,0xD4,0x01},
{0xEFCE,0x29,0x01},
{0xEFCF,0xD0,0x01},
{0xEFD0,0x86,0x01},
{0xEFD1,0xFE,0x01},
{0xEFD2,0x23,0x01},
{0xEFD3,0x9E,0x01},
{0xEFD4,0xE8,0x01},
{0xEFD5,0x28,0x01},
{0xEFD6,0x87,0x01},
{0xEFD7,0x3A,0x01},
{0xEFD8,0xE7,0x01},
{0xEFD9,0x21,0x01},
{0xEFDA,0x10,0x01},
{0xEFDB,0x89,0x01},
{0xEFDC,0x3E,0x01},
{0xEFDD,0x64,0x01},
{0xEFDE,0xA2,0x01},
{0xEFDF,0x0D,0x01},
{0xEFE0,0x41,0x01},
{0xEFE1,0xC8,0x01},
{0xEFE2,0x41,0x01},
{0xEFE3,0x14,0x01},
{0xEFE4,0x02,0x01},
{0xEFE5,0x11,0x01},
{0xEFE6,0x8A,0x01},
{0xEFE7,0x4C,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},


//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x12,0x01},
{0xEFEF,0x42,0x01},
{0xEFF0,0x51,0x01},
{0xEFF1,0x89,0x01},
{0xEFF2,0x38,0x01},
{0xEFF3,0xD4,0x01},
{0xEFF4,0x21,0x01},
{0xEFF5,0x10,0x01},
{0xEFF6,0xAD,0x01},
{0xEFF7,0xA8,0x01},
{0xEFF8,0x45,0x01},
{0xEFF9,0x18,0x01},
{0xEFFA,0x4A,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7D,0x01},
{0xEFFD,0xBA,0x01},
{0xEFFE,0xD3,0x01},
{0xEFFF,0x1C,0x01},
{0xF000,0xE4,0x01},
{0xF001,0x40,0x01},
{0xF002,0x27,0x01},
{0xF003,0x3C,0x01},
{0xF004,0xF8,0x01},
{0xF005,0x69,0x01},
{0xF006,0x10,0x01},
{0xF007,0x7B,0x01},
{0xF008,0x8E,0x01},
{0xF009,0x63,0x01},
{0xF00A,0x1A,0x01},
{0xF00B,0xC6,0x01},
{0xF00C,0x10,0x01},
{0xF00D,0xA6,0x01},
{0xF00E,0x31,0x01},
{0xF00F,0xA6,0x01},
{0xF010,0x59,0x01},
{0xF011,0x8E,0x01},
{0xF012,0x7E,0x01},
{0xF013,0x9A,0x01},
{0xF014,0xB3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB6,0x01},
{0xF017,0x38,0x01},
{0xF018,0xA5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x4F,0x01},
{0xF01B,0x79,0x01},
{0xF01C,0xCB,0x01},
{0xF01D,0x68,0x01},
{0xF01E,0xBA,0x01},
{0xF01F,0x53,0x01},
{0xF020,0x9B,0x01},
{0xF021,0xBB,0x01},
{0xF022,0x0C,0x01},
{0xF023,0x65,0x01},
{0xF024,0x24,0x01},
{0xF025,0x17,0x01},
{0xF026,0x21,0x01},
{0xF027,0xC9,0x01},
{0xF028,0x51,0x01},
{0xF029,0xFC,0x01},
{0xF02A,0xF2,0x01},
{0xF02B,0x9B,0x01},
{0xF02C,0xD3,0x01},
{0xF02D,0x94,0x01},
{0xF02E,0xC5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x48,0x01},
{0xF033,0x43,0x01},
{0xF034,0x66,0x01},
{0xF035,0x92,0x01},
{0xF036,0x96,0x01},
{0xF037,0xD7,0x01},
{0xF038,0xA0,0x01},
{0xF039,0xE6,0x01},
{0xF03A,0x2C,0x01},
{0xF03B,0x2F,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x93,0x01},
{0xF042,0xB5,0x01},
{0xF043,0xCC,0x01},
{0xF044,0x46,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7C,0x01},
{0xF047,0x29,0x01},
{0xF048,0x8A,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x12,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0x00,0x01},
{0xF04F,0xA6,0x01},
{0xF050,0x38,0x01},
{0xF051,0xD7,0x01},
{0xF052,0x01,0x01},
{0xF053,0x0D,0x01},
{0xF054,0x5C,0x01},
{0xF055,0xA2,0x01},
{0xF056,0x82,0x01},
{0xF057,0x94,0x01},
{0xF058,0xAA,0x01},
{0xF059,0xD8,0x01},
{0xF05A,0x45,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xE5,0x01},
{0xF05D,0xC9,0x01},
{0xF05E,0xCF,0x01},
{0xF05F,0x73,0x01},
{0xF060,0x50,0x01},
{0xF061,0x03,0x01},
{0xF062,0x99,0x01},
{0xF063,0xC3,0x01},
{0xF064,0x4C,0x01},
{0xF065,0xE6,0x01},
{0xF066,0x35,0x01},
{0xF067,0xD7,0x01},
{0xF068,0x21,0x01},
{0xF069,0x10,0x01},
{0xF06A,0x84,0x01},
{0xF06B,0xF2,0x01},
{0xF06C,0x03,0x01},
{0xF06D,0x9E,0x01},
{0xF06E,0xE8,0x01},
{0xF06F,0x2C,0x01},
{0xF070,0xA7,0x01},
{0xF071,0x3A,0x01},
{0xF072,0xE8,0x01},
{0xF073,0x11,0x01},
{0xF074,0x90,0x01},
{0xF075,0x87,0x01},
{0xF076,0x18,0x01},
{0xF077,0x94,0x01},
{0xF078,0x21,0x01},
{0xF079,0x09,0x01},
{0xF07A,0x2D,0x01},
{0xF07B,0x68,0x01},
{0xF07C,0x41,0x01},
{0xF07D,0x11,0x01},
{0xF07E,0xDA,0x01},
{0xF07F,0x10,0x01},
{0xF080,0x88,0x01},
{0xF081,0x2A,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000C,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFF,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t ISX012_Shading_0[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0x61,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xBE,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x9E,0x01},
{0xED09,0x2C,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x47,0x01},
{0xED0C,0x49,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0x61,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xA8,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x31,0x01},
{0xED15,0xA1,0x01},
{0xED16,0xC7,0x01},
{0xED17,0x4C,0x01},
{0xED18,0xDE,0x01},
{0xED19,0xC1,0x01},
{0xED1A,0xD2,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x76,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x10,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xC6,0x01},
{0xED22,0x40,0x01},
{0xED23,0xA2,0x01},
{0xED24,0x99,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xDC,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFC,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0xA6,0x01},
{0xED2D,0x41,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x49,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0x8C,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0B,0x01},
{0xED36,0x91,0x01},
{0xED37,0x86,0x01},
{0xED38,0x3D,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x39,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x50,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x16,0x01},
{0xED40,0xCF,0x01},
{0xED41,0xBC,0x01},
{0xED42,0x45,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x41,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xE8,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x16,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x86,0x01},
{0xED4E,0x3E,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xC1,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x02,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAE,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x44,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0xF9,0x01},
{0xED5C,0xCA,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x0C,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x98,0x01},
{0xED61,0xE2,0x01},
{0xED62,0xA8,0x01},
{0xED63,0x26,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xC1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x1C,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x93,0x01},
{0xED6C,0xA7,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xD9,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x54,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x93,0x01},
{0xED77,0xAA,0x01},
{0xED78,0x98,0x01},
{0xED79,0xE5,0x01},
{0xED7A,0x32,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x29,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x8E,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBB,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xA4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0x84,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF1,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA2,0x01},
{0xED96,0x43,0x01},
{0xED97,0x99,0x01},
{0xED98,0xE4,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x25,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB1,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x24,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x00,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEA,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0xC6,0x01},
{0xEDB1,0x3B,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0x99,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA4,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB2,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCD,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x86,0x01},
{0xEDC7,0x3D,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x01,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x80,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC3,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x25,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB1,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCC,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC7,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0xA6,0x01},
{0xEDDD,0x39,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0x91,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x54,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x1B,0x01},
{0xEDE5,0xFC,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0x46,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x71,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x46,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x17,0x01},
{0xEDF0,0xD9,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0x86,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x09,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x6A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x1E,0x01},
{0xEDFB,0x25,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x67,0x01},
{0xEDFE,0x45,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x69,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0xF6,0x01},
{0xEE04,0x93,0x01},
{0xEE05,0x9A,0x01},
{0xEE06,0xFA,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0x26,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xB9,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x6E,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x2D,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x49,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0xB9,0x01},
{0xEE17,0x52,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0x98,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x1E,0x01},
{0xEE1C,0x22,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xA7,0x01},
{0xEE1F,0x48,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x49,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xB4,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x1F,0x01},
{0xEE27,0x31,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4B,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x28,0x01},
{0xEF55,0xC2,0x01},
{0xEF56,0x11,0x01},
{0xEF57,0x8C,0x01},
{0xEF58,0x46,0x01},
{0xEF59,0x34,0x01},
{0xEF5A,0xA2,0x01},
{0xEF5B,0x12,0x01},
{0xEF5C,0xCD,0x01},
{0xEF5D,0x08,0x01},
{0xEF5E,0x47,0x01},
{0xEF5F,0x27,0x01},
{0xEF60,0xAA,0x01},
{0xEF61,0x10,0x01},
{0xEF62,0x7F,0x01},
{0xEF63,0xC2,0x01},
{0xEF64,0xF3,0x01},
{0xEF65,0x1C,0x01},
{0xEF66,0xE4,0x01},
{0xEF67,0x40,0x01},
{0xEF68,0x27,0x01},
{0xEF69,0x3C,0x01},
{0xEF6A,0xFB,0x01},
{0xEF6B,0xA1,0x01},
{0xEF6C,0x90,0x01},
{0xEF6D,0x7C,0x01},
{0xEF6E,0x92,0x01},
{0xEF6F,0x63,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC5,0x01},
{0xEF72,0x0C,0x01},
{0xEF73,0x66,0x01},
{0xEF74,0x31,0x01},
{0xEF75,0xA4,0x01},
{0xEF76,0x49,0x01},
{0xEF77,0x0E,0x01},
{0xEF78,0x7F,0x01},
{0xEF79,0xA0,0x01},
{0xEF7A,0xB3,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB6,0x01},
{0xEF7D,0x34,0x01},
{0xEF7E,0x85,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4D,0x01},
{0xEF81,0x61,0x01},
{0xEF82,0x0B,0x01},
{0xEF83,0x68,0x01},
{0xEF84,0xB6,0x01},
{0xEF85,0x73,0x01},
{0xEF86,0x9B,0x01},
{0xEF87,0xBB,0x01},
{0xEF88,0x0C,0x01},
{0xEF89,0x45,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x17,0x01},
{0xEF8C,0x11,0x01},
{0xEF8D,0x49,0x01},
{0xEF8E,0x51,0x01},
{0xEF8F,0xF4,0x01},
{0xEF90,0xC2,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD4,0x01},
{0xEF93,0x94,0x01},
{0xEF94,0xC5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0B,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x62,0x01},
{0xEF9B,0x62,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD5,0x01},
{0xEF9E,0xA4,0x01},
{0xEF9F,0xC6,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x2F,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x22,0x01},
{0xEFA7,0x13,0x01},
{0xEFA8,0xB4,0x01},
{0xEFA9,0xC0,0x01},
{0xEFAA,0x86,0x01},
{0xEFAB,0x37,0x01},
{0xEFAC,0x7B,0x01},
{0xEFAD,0x29,0x01},
{0xEFAE,0x8A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x52,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA4,0x01},
{0xEFB4,0xF4,0x01},
{0xEFB5,0x25,0x01},
{0xEFB6,0x38,0x01},
{0xEFB7,0xD9,0x01},
{0xEFB8,0x01,0x01},
{0xEFB9,0xCD,0x01},
{0xEFBA,0x5B,0x01},
{0xEFBB,0xA0,0x01},
{0xEFBC,0x72,0x01},
{0xEFBD,0x14,0x01},
{0xEFBE,0xA9,0x01},
{0xEFBF,0xCC,0x01},
{0xEFC0,0xC5,0x01},
{0xEFC1,0x34,0x01},
{0xEFC2,0xE3,0x01},
{0xEFC3,0xF1,0x01},
{0xEFC4,0x0F,0x01},
{0xEFC5,0x74,0x01},
{0xEFC6,0x50,0x01},
{0xEFC7,0xF3,0x01},
{0xEFC8,0x98,0x01},
{0xEFC9,0xC2,0x01},
{0xEFCA,0x40,0x01},
{0xEFCB,0x86,0x01},
{0xEFCC,0x35,0x01},
{0xEFCD,0xD4,0x01},
{0xEFCE,0x29,0x01},
{0xEFCF,0xD0,0x01},
{0xEFD0,0x86,0x01},
{0xEFD1,0xFE,0x01},
{0xEFD2,0x23,0x01},
{0xEFD3,0x9E,0x01},
{0xEFD4,0xE8,0x01},
{0xEFD5,0x28,0x01},
{0xEFD6,0x87,0x01},
{0xEFD7,0x3A,0x01},
{0xEFD8,0xE7,0x01},
{0xEFD9,0x21,0x01},
{0xEFDA,0x10,0x01},
{0xEFDB,0x89,0x01},
{0xEFDC,0x3E,0x01},
{0xEFDD,0x64,0x01},
{0xEFDE,0xA2,0x01},
{0xEFDF,0x0D,0x01},
{0xEFE0,0x41,0x01},
{0xEFE1,0xC8,0x01},
{0xEFE2,0x41,0x01},
{0xEFE3,0x14,0x01},
{0xEFE4,0x02,0x01},
{0xEFE5,0x11,0x01},
{0xEFE6,0x8A,0x01},
{0xEFE7,0x4C,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},


//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x12,0x01},
{0xEFEF,0x42,0x01},
{0xEFF0,0x51,0x01},
{0xEFF1,0x89,0x01},
{0xEFF2,0x38,0x01},
{0xEFF3,0xD4,0x01},
{0xEFF4,0x21,0x01},
{0xEFF5,0x10,0x01},
{0xEFF6,0xAD,0x01},
{0xEFF7,0xA8,0x01},
{0xEFF8,0x45,0x01},
{0xEFF9,0x18,0x01},
{0xEFFA,0x4A,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7D,0x01},
{0xEFFD,0xBA,0x01},
{0xEFFE,0xD3,0x01},
{0xEFFF,0x1C,0x01},
{0xF000,0xE4,0x01},
{0xF001,0x40,0x01},
{0xF002,0x27,0x01},
{0xF003,0x3C,0x01},
{0xF004,0xF8,0x01},
{0xF005,0x69,0x01},
{0xF006,0x10,0x01},
{0xF007,0x7B,0x01},
{0xF008,0x8E,0x01},
{0xF009,0x63,0x01},
{0xF00A,0x1A,0x01},
{0xF00B,0xC6,0x01},
{0xF00C,0x10,0x01},
{0xF00D,0xA6,0x01},
{0xF00E,0x31,0x01},
{0xF00F,0xA6,0x01},
{0xF010,0x59,0x01},
{0xF011,0x8E,0x01},
{0xF012,0x7E,0x01},
{0xF013,0x9A,0x01},
{0xF014,0xB3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB6,0x01},
{0xF017,0x38,0x01},
{0xF018,0xA5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x4F,0x01},
{0xF01B,0x79,0x01},
{0xF01C,0xCB,0x01},
{0xF01D,0x68,0x01},
{0xF01E,0xBA,0x01},
{0xF01F,0x53,0x01},
{0xF020,0x9B,0x01},
{0xF021,0xBB,0x01},
{0xF022,0x0C,0x01},
{0xF023,0x65,0x01},
{0xF024,0x24,0x01},
{0xF025,0x17,0x01},
{0xF026,0x21,0x01},
{0xF027,0xC9,0x01},
{0xF028,0x51,0x01},
{0xF029,0xFC,0x01},
{0xF02A,0xF2,0x01},
{0xF02B,0x9B,0x01},
{0xF02C,0xD3,0x01},
{0xF02D,0x94,0x01},
{0xF02E,0xC5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x48,0x01},
{0xF033,0x43,0x01},
{0xF034,0x66,0x01},
{0xF035,0x92,0x01},
{0xF036,0x96,0x01},
{0xF037,0xD7,0x01},
{0xF038,0xA0,0x01},
{0xF039,0xE6,0x01},
{0xF03A,0x2C,0x01},
{0xF03B,0x2F,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x93,0x01},
{0xF042,0xB5,0x01},
{0xF043,0xCC,0x01},
{0xF044,0x46,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7C,0x01},
{0xF047,0x29,0x01},
{0xF048,0x8A,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x12,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0x00,0x01},
{0xF04F,0xA6,0x01},
{0xF050,0x38,0x01},
{0xF051,0xD7,0x01},
{0xF052,0x01,0x01},
{0xF053,0x0D,0x01},
{0xF054,0x5C,0x01},
{0xF055,0xA2,0x01},
{0xF056,0x82,0x01},
{0xF057,0x94,0x01},
{0xF058,0xAA,0x01},
{0xF059,0xD8,0x01},
{0xF05A,0x45,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xE5,0x01},
{0xF05D,0xC9,0x01},
{0xF05E,0xCF,0x01},
{0xF05F,0x73,0x01},
{0xF060,0x50,0x01},
{0xF061,0x03,0x01},
{0xF062,0x99,0x01},
{0xF063,0xC3,0x01},
{0xF064,0x4C,0x01},
{0xF065,0xE6,0x01},
{0xF066,0x35,0x01},
{0xF067,0xD7,0x01},
{0xF068,0x21,0x01},
{0xF069,0x10,0x01},
{0xF06A,0x84,0x01},
{0xF06B,0xF2,0x01},
{0xF06C,0x03,0x01},
{0xF06D,0x9E,0x01},
{0xF06E,0xE8,0x01},
{0xF06F,0x2C,0x01},
{0xF070,0xA7,0x01},
{0xF071,0x3A,0x01},
{0xF072,0xE8,0x01},
{0xF073,0x11,0x01},
{0xF074,0x90,0x01},
{0xF075,0x87,0x01},
{0xF076,0x18,0x01},
{0xF077,0x94,0x01},
{0xF078,0x21,0x01},
{0xF079,0x09,0x01},
{0xF07A,0x2D,0x01},
{0xF07B,0x68,0x01},
{0xF07C,0x41,0x01},
{0xF07D,0x11,0x01},
{0xF07E,0xDA,0x01},
{0xF07F,0x10,0x01},
{0xF080,0x88,0x01},
{0xF081,0x2A,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000C,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFF,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t ISX012_Shading_1[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0x61,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xBE,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x9E,0x01},
{0xED09,0x2C,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x47,0x01},
{0xED0C,0x49,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0x61,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xA8,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x31,0x01},
{0xED15,0xA1,0x01},
{0xED16,0xC7,0x01},
{0xED17,0x4C,0x01},
{0xED18,0xDE,0x01},
{0xED19,0xC1,0x01},
{0xED1A,0xD2,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x76,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x10,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xC6,0x01},
{0xED22,0x40,0x01},
{0xED23,0xA2,0x01},
{0xED24,0x99,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xDC,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFC,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0xA6,0x01},
{0xED2D,0x41,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x49,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0x8C,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0B,0x01},
{0xED36,0x91,0x01},
{0xED37,0x86,0x01},
{0xED38,0x3D,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x39,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x50,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x16,0x01},
{0xED40,0xCF,0x01},
{0xED41,0xBC,0x01},
{0xED42,0x45,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x41,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xE8,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x16,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x86,0x01},
{0xED4E,0x3E,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xC1,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x02,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAE,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x44,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0xF9,0x01},
{0xED5C,0xCA,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x0C,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x98,0x01},
{0xED61,0xE2,0x01},
{0xED62,0xA8,0x01},
{0xED63,0x26,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xC1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x1C,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x93,0x01},
{0xED6C,0xA7,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xD9,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x54,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x93,0x01},
{0xED77,0xAA,0x01},
{0xED78,0x98,0x01},
{0xED79,0xE5,0x01},
{0xED7A,0x32,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x29,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x8E,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBB,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xA4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0x84,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF1,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA2,0x01},
{0xED96,0x43,0x01},
{0xED97,0x99,0x01},
{0xED98,0xE4,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x25,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB1,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x24,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x00,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEA,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0xC6,0x01},
{0xEDB1,0x3B,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0x99,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA4,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB2,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCD,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x86,0x01},
{0xEDC7,0x3D,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x01,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x80,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC3,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x25,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB1,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCC,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC7,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0xA6,0x01},
{0xEDDD,0x39,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0x91,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x54,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x1B,0x01},
{0xEDE5,0xFC,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0x46,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x71,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x46,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x17,0x01},
{0xEDF0,0xD9,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0x86,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x09,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x6A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x1E,0x01},
{0xEDFB,0x25,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x67,0x01},
{0xEDFE,0x45,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x69,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0xF6,0x01},
{0xEE04,0x93,0x01},
{0xEE05,0x9A,0x01},
{0xEE06,0xFA,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0x26,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xB9,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x6E,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x2D,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x49,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0xB9,0x01},
{0xEE17,0x52,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0x98,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x1E,0x01},
{0xEE1C,0x22,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xA7,0x01},
{0xEE1F,0x48,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x49,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xB4,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x1F,0x01},
{0xEE27,0x31,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4B,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x0B,0x01},
{0xEF55,0xFA,0x01},
{0xEF56,0x10,0x01},
{0xEF57,0x87,0x01},
{0xEF58,0x24,0x01},
{0xEF59,0x24,0x01},
{0xEF5A,0xA1,0x01},
{0xEF5B,0x09,0x01},
{0xEF5C,0x7D,0x01},
{0xEF5D,0x08,0x01},
{0xEF5E,0x44,0x01},
{0xEF5F,0x0A,0x01},
{0xEF60,0x0A,0x01},
{0xEF61,0x50,0x01},
{0xEF62,0x7B,0x01},
{0xEF63,0xAA,0x01},
{0xEF64,0x53,0x01},
{0xEF65,0x9C,0x01},
{0xEF66,0xDF,0x01},
{0xEF67,0x18,0x01},
{0xEF68,0xC7,0x01},
{0xEF69,0x3A,0x01},
{0xEF6A,0xEC,0x01},
{0xEF6B,0xF9,0x01},
{0xEF6C,0x0F,0x01},
{0xEF6D,0x79,0x01},
{0xEF6E,0x80,0x01},
{0xEF6F,0x03,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC3,0x01},
{0xEF72,0xF8,0x01},
{0xEF73,0xE5,0x01},
{0xEF74,0x30,0x01},
{0xEF75,0x9D,0x01},
{0xEF76,0x01,0x01},
{0xEF77,0x4E,0x01},
{0xEF78,0x7B,0x01},
{0xEF79,0x8C,0x01},
{0xEF7A,0x53,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB4,0x01},
{0xEF7D,0x2C,0x01},
{0xEF7E,0x45,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4B,0x01},
{0xEF81,0x49,0x01},
{0xEF82,0x8B,0x01},
{0xEF83,0x66,0x01},
{0xEF84,0xA0,0x01},
{0xEF85,0xF3,0x01},
{0xEF86,0x9A,0x01},
{0xEF87,0xB9,0x01},
{0xEF88,0x04,0x01},
{0xEF89,0x45,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x16,0x01},
{0xEF8C,0x09,0x01},
{0xEF8D,0xC9,0x01},
{0xEF8E,0x50,0x01},
{0xEF8F,0xEC,0x01},
{0xEF90,0x42,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD1,0x01},
{0xEF93,0x88,0x01},
{0xEF94,0xA5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0A,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x60,0x01},
{0xEF9B,0x32,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD2,0x01},
{0xEF9E,0x88,0x01},
{0xEF9F,0x66,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x2E,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x12,0x01},
{0xEFA7,0x93,0x01},
{0xEFA8,0xB2,0x01},
{0xEFA9,0xA4,0x01},
{0xEFAA,0x86,0x01},
{0xEFAB,0x36,0x01},
{0xEFAC,0x77,0x01},
{0xEFAD,0x19,0x01},
{0xEFAE,0x4A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x52,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA3,0x01},
{0xEFB4,0xE4,0x01},
{0xEFB5,0x25,0x01},
{0xEFB6,0x37,0x01},
{0xEFB7,0xCF,0x01},
{0xEFB8,0xD1,0x01},
{0xEFB9,0xCC,0x01},
{0xEFBA,0x5A,0x01},
{0xEFBB,0x9A,0x01},
{0xEFBC,0x52,0x01},
{0xEFBD,0x14,0x01},
{0xEFBE,0xA8,0x01},
{0xEFBF,0xC0,0x01},
{0xEFC0,0x05,0x01},
{0xEFC1,0x34,0x01},
{0xEFC2,0xD8,0x01},
{0xEFC3,0x79,0x01},
{0xEFC4,0xCF,0x01},
{0xEFC5,0x71,0x01},
{0xEFC6,0x42,0x01},
{0xEFC7,0xA3,0x01},
{0xEFC8,0x98,0x01},
{0xEFC9,0xC0,0x01},
{0xEFCA,0x30,0x01},
{0xEFCB,0xA6,0x01},
{0xEFCC,0x34,0x01},
{0xEFCD,0xCA,0x01},
{0xEFCE,0xB1,0x01},
{0xEFCF,0x8F,0x01},
{0xEFD0,0x81,0x01},
{0xEFD1,0xE0,0x01},
{0xEFD2,0x73,0x01},
{0xEFD3,0x9D,0x01},
{0xEFD4,0xE3,0x01},
{0xEFD5,0x04,0x01},
{0xEFD6,0x47,0x01},
{0xEFD7,0x39,0x01},
{0xEFD8,0xDB,0x01},
{0xEFD9,0xA9,0x01},
{0xEFDA,0x8F,0x01},
{0xEFDB,0x83,0x01},
{0xEFDC,0x06,0x01},
{0xEFDD,0xE4,0x01},
{0xEFDE,0xA0,0x01},
{0xEFDF,0x03,0x01},
{0xEFE0,0xFD,0x01},
{0xEFE1,0xA7,0x01},
{0xEFE2,0x3F,0x01},
{0xEFE3,0x03,0x01},
{0xEFE4,0x62,0x01},
{0xEFE5,0x10,0x01},
{0xEFE6,0x84,0x01},
{0xEFE7,0x12,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},



//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x0B,0x01},
{0xEFEF,0x12,0x01},
{0xEFF0,0x11,0x01},
{0xEFF1,0x88,0x01},
{0xEFF2,0x2E,0x01},
{0xEFF3,0x94,0x01},
{0xEFF4,0x21,0x01},
{0xEFF5,0x0E,0x01},
{0xEFF6,0x99,0x01},
{0xEFF7,0xE8,0x01},
{0xEFF8,0x44,0x01},
{0xEFF9,0x10,0x01},
{0xEFFA,0x22,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7C,0x01},
{0xEFFD,0xB6,0x01},
{0xEFFE,0xB3,0x01},
{0xEFFF,0x1C,0x01},
{0xF000,0xE3,0x01},
{0xF001,0x38,0x01},
{0xF002,0xC7,0x01},
{0xF003,0x3B,0x01},
{0xF004,0xF4,0x01},
{0xF005,0x39,0x01},
{0xF006,0x10,0x01},
{0xF007,0x7A,0x01},
{0xF008,0x8A,0x01},
{0xF009,0x53,0x01},
{0xF00A,0x9A,0x01},
{0xF00B,0xC5,0x01},
{0xF00C,0x0C,0x01},
{0xF00D,0x86,0x01},
{0xF00E,0x31,0x01},
{0xF00F,0xA5,0x01},
{0xF010,0x49,0x01},
{0xF011,0xCE,0x01},
{0xF012,0x7D,0x01},
{0xF013,0x94,0x01},
{0xF014,0xA3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB6,0x01},
{0xF017,0x38,0x01},
{0xF018,0xA5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x4F,0x01},
{0xF01B,0x79,0x01},
{0xF01C,0x8B,0x01},
{0xF01D,0x68,0x01},
{0xF01E,0xB4,0x01},
{0xF01F,0x43,0x01},
{0xF020,0x1B,0x01},
{0xF021,0xBB,0x01},
{0xF022,0x0C,0x01},
{0xF023,0x45,0x01},
{0xF024,0x24,0x01},
{0xF025,0x17,0x01},
{0xF026,0x19,0x01},
{0xF027,0xC9,0x01},
{0xF028,0x51,0x01},
{0xF029,0xFA,0x01},
{0xF02A,0xD2,0x01},
{0xF02B,0x1B,0x01},
{0xF02C,0xD3,0x01},
{0xF02D,0x94,0x01},
{0xF02E,0xC5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x48,0x01},
{0xF033,0x43,0x01},
{0xF034,0x66,0x01},
{0xF035,0x82,0x01},
{0xF036,0x96,0x01},
{0xF037,0xD6,0x01},
{0xF038,0x98,0x01},
{0xF039,0xC6,0x01},
{0xF03A,0x2C,0x01},
{0xF03B,0x2F,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x13,0x01},
{0xF042,0xB5,0x01},
{0xF043,0xC8,0x01},
{0xF044,0x06,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7B,0x01},
{0xF047,0x29,0x01},
{0xF048,0x8A,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x12,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0xFC,0x01},
{0xF04F,0x65,0x01},
{0xF050,0x38,0x01},
{0xF051,0xD4,0x01},
{0xF052,0xF9,0x01},
{0xF053,0xCC,0x01},
{0xF054,0x5B,0x01},
{0xF055,0xA0,0x01},
{0xF056,0x82,0x01},
{0xF057,0x14,0x01},
{0xF058,0xAA,0x01},
{0xF059,0xD4,0x01},
{0xF05A,0x05,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xE2,0x01},
{0xF05D,0xA9,0x01},
{0xF05E,0x4F,0x01},
{0xF05F,0x73,0x01},
{0xF060,0x4E,0x01},
{0xF061,0xF3,0x01},
{0xF062,0x18,0x01},
{0xF063,0xC3,0x01},
{0xF064,0x48,0x01},
{0xF065,0xC6,0x01},
{0xF066,0x35,0x01},
{0xF067,0xD4,0x01},
{0xF068,0x01,0x01},
{0xF069,0xD0,0x01},
{0xF06A,0x82,0x01},
{0xF06B,0xEA,0x01},
{0xF06C,0xD3,0x01},
{0xF06D,0x1D,0x01},
{0xF06E,0xE7,0x01},
{0xF06F,0x24,0x01},
{0xF070,0x47,0x01},
{0xF071,0x3A,0x01},
{0xF072,0xE5,0x01},
{0xF073,0xF1,0x01},
{0xF074,0x0F,0x01},
{0xF075,0x86,0x01},
{0xF076,0x0A,0x01},
{0xF077,0x34,0x01},
{0xF078,0xA1,0x01},
{0xF079,0x06,0x01},
{0xF07A,0x19,0x01},
{0xF07B,0xE8,0x01},
{0xF07C,0x40,0x01},
{0xF07D,0x0D,0x01},
{0xF07E,0xB2,0x01},
{0xF07F,0x90,0x01},
{0xF080,0x86,0x01},
{0xF081,0x1C,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000D,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFE,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t ISX012_Shading_2[] =
{
{0x01BC,0x50,0x01},    // CXC OFF SHD OFF
{0xEB00,0x8282,0x02},	//valid_code
{0xEB02,0xFE,0x01},
{0xEB03,0x84,0x01},
{0xEB04,0x3F,0x01},
{0xEB05,0x01,0x01},
{0xEB06,0x50,0x01},
{0xEB07,0x08,0x01},
{0xEB08,0x14,0x01},
{0xEB09,0xFF,0x01},
{0xEB0A,0x45,0x01},
{0xEB0B,0x80,0x01},
{0xEB0C,0x01,0x01},
{0xEB0D,0x68,0x01},
{0xEB0E,0x04,0x01},
{0xEB0F,0x1A,0x01},
{0xEB10,0x81,0x01},
{0xEB11,0x86,0x01},
{0xEB12,0x3F,0x01},
{0xEB13,0xE1,0x01},
{0xEB14,0x4F,0x01},
{0xEB15,0x00,0x01},
{0xEB16,0x14,0x01},
{0xEB17,0x02,0x01},
{0xEB18,0xC5,0x01},
{0xEB19,0x7F,0x01},
{0xEB1A,0x11,0x01},
{0xEB1B,0x60,0x01},
{0xEB1C,0x00,0x01},
{0xEB1D,0x1A,0x01},
{0xEB1E,0x81,0x01},
{0xEB1F,0x46,0x01},
{0xEB20,0xA0,0x01},
{0xEB21,0x01,0x01},
{0xEB22,0x48,0x01},
{0xEB23,0x00,0x01},
{0xEB24,0x12,0x01},
{0xEB25,0x81,0x01},
{0xEB26,0x05,0x01},
{0xEB27,0x20,0x01},
{0xEB28,0xF1,0x01},
{0xEB29,0x4F,0x01},
{0xEB2A,0x00,0x01},
{0xEB2B,0x14,0x01},
{0xEB2C,0x82,0x01},
{0xEB2D,0x85,0x01},
{0xEB2E,0x80,0x01},
{0xEB2F,0x21,0x01},
{0xEB30,0x60,0x01},
{0xEB31,0x04,0x01},
{0xEB32,0x12,0x01},
{0xEB33,0x81,0x01},
{0xEB34,0x84,0x01},
{0xEB35,0xE0,0x01},
{0xEB36,0x00,0x01},
{0xEB37,0x28,0x01},
{0xEB38,0x04,0x01},
{0xEB39,0x0C,0x01},
{0xEB3A,0x82,0x01},
{0xEB3B,0x43,0x01},
{0xEB3C,0x20,0x01},
{0xEB3D,0x11,0x01},
{0xEB3E,0x68,0x01},
{0xEB3F,0x04,0x01},
{0xEB40,0x1A,0x01},
{0xEB41,0x82,0x01},
{0xEB42,0x83,0x01},
{0xEB43,0xE0,0x01},
{0xEB44,0x00,0x01},
{0xEB45,0x20,0x01},
{0xEB46,0x00,0x01},
{0xEB47,0x06,0x01},
{0xEB48,0xFF,0x01},
{0xEB49,0x41,0x01},
{0xEB4A,0x80,0x01},
{0xEB4B,0x10,0x01},
{0xEB4C,0x30,0x01},
{0xEB4D,0x08,0x01},
{0xEB4E,0x14,0x01},
{0xEB4F,0x02,0x01},
{0xEB50,0x45,0x01},
{0xEB51,0xC0,0x01},
{0xEB52,0x10,0x01},
{0xEB53,0x30,0x01},
{0xEB54,0x04,0x01},
{0xEB55,0x04,0x01},
{0xEB56,0x01,0x01},
{0xEB57,0xC0,0x01},
{0xEB58,0x3F,0x01},
{0xEB59,0x10,0x01},
{0xEB5A,0x10,0x01},
{0xEB5B,0x04,0x01},
{0xEB5C,0x0A,0x01},
{0xEB5D,0x80,0x01},
{0xEB5E,0x03,0x01},
{0xEB5F,0xE0,0x01},
{0xEB60,0x10,0x01},
{0xEB61,0x28,0x01},
{0xEB62,0x04,0x01},
{0xEB63,0x0A,0x01},
{0xEB64,0x81,0x01},
{0xEB65,0x01,0x01},
{0xEB66,0x00,0x01},
{0xEB67,0x10,0x01},
{0xEB68,0x00,0x01},
{0xEB69,0x04,0x01},
{0xEB6A,0x04,0x01},
{0xEB6B,0x01,0x01},
{0xEB6C,0x42,0x01},
{0xEB6D,0xE0,0x01},
{0xEB6E,0x10,0x01},
{0xEB6F,0x38,0x01},
{0xEB70,0xFC,0x01},
{0xEB71,0x0D,0x01},
{0xEB72,0x7F,0x01},
{0xEB73,0x43,0x01},
{0xEB74,0x60,0x01},
{0xEB75,0x00,0x01},
{0xEB76,0x08,0x01},
{0xEB77,0x08,0x01},
{0xEB78,0x02,0x01},
{0xEB79,0x81,0x01},
{0xEB7A,0x41,0x01},
{0xEB7B,0x80,0x01},
{0xEB7C,0x10,0x01},
{0xEB7D,0x30,0x01},
{0xEB7E,0x04,0x01},
{0xEB7F,0x0C,0x01},
{0xEB80,0x01,0x01},
{0xEB81,0x43,0x01},
{0xEB82,0xC0,0x01},
{0xEB83,0x20,0x01},
{0xEB84,0x28,0x01},
{0xEB85,0x08,0x01},
{0xEB86,0x06,0x01},
{0xEB87,0x02,0x01},
{0xEB88,0xC2,0x01},
{0xEB89,0xA0,0x01},
{0xEB8A,0x30,0x01},
{0xEB8B,0x30,0x01},
{0xEB8C,0x0C,0x01},
{0xEB8D,0x12,0x01},
{0xEB8E,0x83,0x01},
{0xEB8F,0x84,0x01},
{0xEB90,0x00,0x01},
{0xEB91,0x21,0x01},
{0xEB92,0x40,0x01},
{0xEB93,0x0C,0x01},
{0xEB94,0x0C,0x01},
{0xEB95,0x82,0x01},
{0xEB96,0x03,0x01},
{0xEB97,0xC1,0x01},
{0xEB98,0x40,0x01},
{0xEB99,0x40,0x01},
{0xEB9A,0x08,0x01},
{0xEB9B,0x10,0x01},
{0xEB9C,0x03,0x01},
{0xEB9D,0xC4,0x01},
{0xEB9E,0x00,0x01},
{0xEB9F,0x21,0x01},
{0xEBA0,0x38,0x01},
{0xEBA1,0x08,0x01},
{0xEBA2,0x0E,0x01},
{0xEBA3,0x82,0x01},
{0xEBA4,0xC3,0x01},
{0xEBA5,0x20,0x01},
{0xEBA6,0x41,0x01},
{0xEBA7,0x48,0x01},
{0xEBA8,0x00,0x01},
{0xEBA9,0x14,0x01},
{0xEBAA,0x83,0x01},
{0xEBAB,0x44,0x01},
{0xEBAC,0x20,0x01},
{0xEBAD,0x11,0x01},
{0xEBAE,0x48,0x01},
{0xEBAF,0x08,0x01},
{0xEBB0,0x0E,0x01},
{0xEBB1,0x82,0x01},
{0xEBB2,0x83,0x01},
{0xEBB3,0xE0,0x01},
{0xEBB4,0x30,0x01},
{0xEBB5,0x48,0x01},
{0xEBB6,0x10,0x01},
{0xEBB7,0x12,0x01},
{0xEBB8,0x00,0x01},
{0xEBB9,0xC5,0x01},
{0xEBBA,0x20,0x01},
{0xEBBB,0x11,0x01},
{0xEBBC,0x48,0x01},
{0xEBBD,0x04,0x01},
{0xEBBE,0x12,0x01},
{0xEBBF,0x04,0x01},
{0xEBC0,0x3B,0x01},
{0xEBC1,0xC1,0x01},
{0xEBC2,0x1E,0x01},
{0xEBC3,0xC8,0x01},
{0xEBC4,0x0F,0x01},
{0xEBC5,0xF8,0x01},
{0xEBC6,0x02,0x01},
{0xEBC7,0xBB,0x01},
{0xEBC8,0x60,0x01},
{0xEBC9,0x0F,0x01},
{0xEBCA,0xB8,0x01},
{0xEBCB,0x0F,0x01},
{0xEBCC,0xEA,0x01},
{0xEBCD,0x83,0x01},
{0xEBCE,0x3A,0x01},
{0xEBCF,0xC1,0x01},
{0xEBD0,0x4E,0x01},
{0xEBD1,0xB0,0x01},
{0xEBD2,0x07,0x01},
{0xEBD3,0xF2,0x01},
{0xEBD4,0x03,0x01},
{0xEBD5,0xBE,0x01},
{0xEBD6,0xC0,0x01},
{0xEBD7,0x2E,0x01},
{0xEBD8,0xD8,0x01},
{0xEBD9,0x03,0x01},
{0xEBDA,0xEE,0x01},
{0xEBDB,0x83,0x01},
{0xEBDC,0xFA,0x01},
{0xEBDD,0xA0,0x01},
{0xEBDE,0x2E,0x01},
{0xEBDF,0xB0,0x01},
{0xEBE0,0x0B,0x01},
{0xEBE1,0xEC,0x01},
{0xEBE2,0x05,0x01},
{0xEBE3,0xBD,0x01},
{0xEBE4,0x60,0x01},
{0xEBE5,0x2F,0x01},
{0xEBE6,0xD0,0x01},
{0xEBE7,0x07,0x01},
{0xEBE8,0xEC,0x01},
{0xEBE9,0x02,0x01},
{0xEBEA,0xBC,0x01},
{0xEBEB,0x40,0x01},
{0xEBEC,0x2F,0x01},
{0xEBED,0xD0,0x01},
{0xEBEE,0x13,0x01},
{0xEBEF,0xEE,0x01},
{0xEBF0,0x84,0x01},
{0xEBF1,0xBB,0x01},
{0xEBF2,0x00,0x01},
{0xEBF3,0x1F,0x01},
{0xEBF4,0xC8,0x01},
{0xEBF5,0xFF,0x01},
{0xEBF6,0xEF,0x01},
{0xEBF7,0x00,0x01},
{0xEBF8,0x7D,0x01},
{0xEBF9,0x60,0x01},
{0xEBFA,0x2F,0x01},
{0xEBFB,0xD0,0x01},
{0xEBFC,0x0B,0x01},
{0xEBFD,0xF4,0x01},
{0xEBFE,0x85,0x01},
{0xEBFF,0x7D,0x01},
{0xEC00,0x61,0x01},
{0xEC01,0x0F,0x01},
{0xEC02,0xC0,0x01},
{0xEC03,0xFF,0x01},
{0xEC04,0xF7,0x01},
{0xEC05,0x7F,0x01},
{0xEC06,0x3D,0x01},
{0xEC07,0x40,0x01},
{0xEC08,0xFF,0x01},
{0xEC09,0xDF,0x01},
{0xEC0A,0x07,0x01},
{0xEC0B,0xFA,0x01},
{0xEC0C,0x81,0x01},
{0xEC0D,0x3E,0x01},
{0xEC0E,0x61,0x01},
{0xEC0F,0x4F,0x01},
{0xEC10,0xD8,0x01},
{0xEC11,0x0B,0x01},
{0xEC12,0xFC,0x01},
{0xEC13,0xFE,0x01},
{0xEC14,0x3D,0x01},
{0xEC15,0xC0,0x01},
{0xEC16,0xFF,0x01},
{0xEC17,0xFF,0x01},
{0xEC18,0x03,0x01},
{0xEC19,0xFC,0x01},
{0xEC1A,0x82,0x01},
{0xEC1B,0xBE,0x01},
{0xEC1C,0xA0,0x01},
{0xEC1D,0x6F,0x01},
{0xEC1E,0xF8,0x01},
{0xEC1F,0x1B,0x01},
{0xEC20,0xFE,0x01},
{0xEC21,0x83,0x01},
{0xEC22,0xBF,0x01},
{0xEC23,0xE0,0x01},
{0xEC24,0x0F,0x01},
{0xEC25,0x10,0x01},
{0xEC26,0x00,0x01},
{0xEC27,0x00,0x01},
{0xEC28,0x82,0x01},
{0xEC29,0xC0,0x01},
{0xEC2A,0x60,0x01},
{0xEC2B,0x30,0x01},
{0xEC2C,0x18,0x01},
{0xEC2D,0x20,0x01},
{0xEC2E,0x04,0x01},
{0xEC2F,0x08,0x01},
{0xEC30,0x81,0x01},
{0xEC31,0x21,0x01},
{0xEC32,0x30,0x01},
{0xEC33,0x08,0x01},
{0xEC34,0x08,0x01},
{0xEC35,0x08,0x01},
{0xEC36,0x82,0x01},
{0xEC37,0x01,0x01},
{0xEC38,0x81,0x01},
{0xEC39,0x50,0x01},
{0xEC3A,0x08,0x01},
{0xEC3B,0x14,0x01},
{0xEC3C,0x02,0x01},
{0xEC3D,0x09,0x01},
{0xEC3E,0x41,0x01},
{0xEC3F,0x42,0x01},
{0xEC40,0x70,0x01},
{0xEC41,0x20,0x01},
{0xEC42,0x0C,0x01},
{0xEC43,0x06,0x01},
{0xEC44,0x84,0x01},
{0xEC45,0x42,0x01},
{0xEC46,0xE1,0x01},
{0xEC47,0x40,0x01},
{0xEC48,0x38,0x01},
{0xEC49,0x1C,0x01},
{0xEC4A,0x0C,0x01},
{0xEC4B,0x07,0x01},
{0xEC4C,0x03,0x01},
{0xEC4D,0xA2,0x01},
{0xEC4E,0x80,0x01},
{0xEC4F,0x28,0x01},
{0xEC50,0x18,0x01},
{0xEC51,0x10,0x01},
{0xEC52,0x87,0x01},
{0xEC53,0x43,0x01},
{0xEC54,0x61,0x01},
{0xEC55,0x41,0x01},
{0xEC56,0x48,0x01},
{0xEC57,0x14,0x01},
{0xEC58,0x10,0x01},
{0xEC59,0x07,0x01},
{0xEC5A,0xC2,0x01},
{0xEC5B,0x81,0x01},
{0xEC5C,0x80,0x01},
{0xEC5D,0x30,0x01},
{0xEC5E,0x20,0x01},
{0xEC5F,0x0C,0x01},
{0xEC60,0x87,0x01},
{0xEC61,0x83,0x01},
{0xEC62,0xC1,0x01},
{0xEC63,0x40,0x01},
{0xEC64,0x38,0x01},
{0xEC65,0x14,0x01},
{0xEC66,0x0A,0x01},
{0xEC67,0x07,0x01},
{0xEC68,0xC3,0x01},
{0xEC69,0xC1,0x01},
{0xEC6A,0x70,0x01},
{0xEC6B,0x30,0x01},
{0xEC6C,0x20,0x01},
{0xEC6D,0x0C,0x01},
{0xEC6E,0x08,0x01},
{0xEC6F,0xC3,0x01},
{0xEC70,0xE1,0x01},
{0xEC71,0x60,0x01},
{0xEC72,0x30,0x01},
{0xEC73,0x10,0x01},
{0xEC74,0x0E,0x01},
{0xEC75,0x85,0x01},
{0xEC76,0xC2,0x01},
{0xEC77,0xC1,0x01},
{0xEC78,0x70,0x01},
{0xEC79,0x30,0x01},
{0xEC7A,0x1C,0x01},
{0xEC7B,0x0C,0x01},

//SHD1(from CO1)
{0xED02,0xE6,0x01},
{0xED03,0xD9,0x01},
{0xED04,0x92,0x01},
{0xED05,0x7C,0x01},
{0xED06,0xD8,0x01},
{0xED07,0xB4,0x01},
{0xED08,0x1E,0x01},
{0xED09,0x32,0x01},
{0xED0A,0x75,0x01},
{0xED0B,0x67,0x01},
{0xED0C,0x4A,0x01},
{0xED0D,0xD7,0x01},
{0xED0E,0xA9,0x01},
{0xED0F,0x12,0x01},
{0xED10,0x76,0x01},
{0xED11,0xBC,0x01},
{0xED12,0x34,0x01},
{0xED13,0x1E,0x01},
{0xED14,0x37,0x01},
{0xED15,0xA1,0x01},
{0xED16,0x87,0x01},
{0xED17,0x4E,0x01},
{0xED18,0xDE,0x01},
{0xED19,0x41,0x01},
{0xED1A,0xD3,0x01},
{0xED1B,0x77,0x01},
{0xED1C,0x8C,0x01},
{0xED1D,0x94,0x01},
{0xED1E,0x9C,0x01},
{0xED1F,0x14,0x01},
{0xED20,0xC9,0x01},
{0xED21,0xA6,0x01},
{0xED22,0x41,0x01},
{0xED23,0xA2,0x01},
{0xED24,0xC1,0x01},
{0xED25,0x8F,0x01},
{0xED26,0x66,0x01},
{0xED27,0xE6,0x01},
{0xED28,0xF3,0x01},
{0xED29,0x19,0x01},
{0xED2A,0xFF,0x01},
{0xED2B,0xB0,0x01},
{0xED2C,0x66,0x01},
{0xED2D,0x42,0x01},
{0xED2E,0xC1,0x01},
{0xED2F,0x91,0x01},
{0xED30,0x91,0x01},
{0xED31,0x75,0x01},
{0xED32,0xA2,0x01},
{0xED33,0x74,0x01},
{0xED34,0x1C,0x01},
{0xED35,0x0F,0x01},
{0xED36,0x91,0x01},
{0xED37,0x26,0x01},
{0xED38,0x3E,0x01},
{0xED39,0x87,0x01},
{0xED3A,0x51,0x01},
{0xED3B,0x4E,0x01},
{0xED3C,0x5C,0x01},
{0xED3D,0x54,0x01},
{0xED3E,0x83,0x01},
{0xED3F,0x96,0x01},
{0xED40,0xD0,0x01},
{0xED41,0xBC,0x01},
{0xED42,0xA5,0x01},
{0xED43,0x35,0x01},
{0xED44,0x83,0x01},
{0xED45,0x61,0x01},
{0xED46,0xCE,0x01},
{0xED47,0x67,0x01},
{0xED48,0xF2,0x01},
{0xED49,0x33,0x01},
{0xED4A,0x1C,0x01},
{0xED4B,0x1A,0x01},
{0xED4C,0xC1,0x01},
{0xED4D,0x46,0x01},
{0xED4E,0x3F,0x01},
{0xED4F,0x83,0x01},
{0xED50,0xD9,0x01},
{0xED51,0x0D,0x01},
{0xED52,0x57,0x01},
{0xED53,0x06,0x01},
{0xED54,0x23,0x01},
{0xED55,0x14,0x01},
{0xED56,0xAF,0x01},
{0xED57,0xE4,0x01},
{0xED58,0x64,0x01},
{0xED59,0x2A,0x01},
{0xED5A,0x43,0x01},
{0xED5B,0x01,0x01},
{0xED5C,0xCB,0x01},
{0xED5D,0x56,0x01},
{0xED5E,0x10,0x01},
{0xED5F,0x03,0x01},
{0xED60,0x18,0x01},
{0xED61,0xE4,0x01},
{0xED62,0xA8,0x01},
{0xED63,0xE6,0x01},
{0xED64,0x41,0x01},
{0xED65,0x9E,0x01},
{0xED66,0xE1,0x01},
{0xED67,0xCE,0x01},
{0xED68,0x59,0x01},
{0xED69,0x20,0x01},
{0xED6A,0xB3,0x01},
{0xED6B,0x13,0x01},
{0xED6C,0xA8,0x01},
{0xED6D,0x74,0x01},
{0xED6E,0x04,0x01},
{0xED6F,0x25,0x01},
{0xED70,0x13,0x01},
{0xED71,0xE1,0x01},
{0xED72,0xC8,0x01},
{0xED73,0x47,0x01},
{0xED74,0x56,0x01},
{0xED75,0xD2,0x01},
{0xED76,0x13,0x01},
{0xED77,0xAB,0x01},
{0xED78,0x98,0x01},
{0xED79,0x25,0x01},
{0xED7A,0x33,0x01},
{0xED7B,0x9A,0x01},
{0xED7C,0x49,0x01},
{0xED7D,0xCF,0x01},
{0xED7E,0x64,0x01},
{0xED7F,0x96,0x01},
{0xED80,0x73,0x01},
{0xED81,0x95,0x01},
{0xED82,0xBC,0x01},
{0xED83,0xA4,0x01},
{0xED84,0xC4,0x01},
{0xED85,0x26,0x01},
{0xED86,0x0A,0x01},
{0xED87,0x59,0x01},
{0xED88,0x08,0x01},
{0xED89,0x40,0x01},
{0xED8A,0x00,0x01},
{0xED8B,0xC2,0x01},
{0xED8C,0x10,0x01},
{0xED8D,0x88,0x01},
{0xED8E,0xB0,0x01},
{0xED8F,0xA4,0x01},
{0xED90,0x27,0x01},
{0xED91,0x59,0x01},
{0xED92,0xF9,0x01},
{0xED93,0x0B,0x01},
{0xED94,0x64,0x01},
{0xED95,0xA8,0x01},
{0xED96,0x43,0x01},
{0xED97,0x19,0x01},
{0xED98,0xE6,0x01},
{0xED99,0x68,0x01},
{0xED9A,0x45,0x01},
{0xED9B,0x2F,0x01},
{0xED9C,0x2B,0x01},
{0xED9D,0xB9,0x01},
{0xED9E,0xC9,0x01},
{0xED9F,0x42,0x01},
{0xEDA0,0x18,0x01},
{0xEDA1,0x32,0x01},
{0xEDA2,0x90,0x01},
{0xEDA3,0x80,0x01},
{0xEDA4,0x3C,0x01},
{0xEDA5,0x44,0x01},
{0xEDA6,0x22,0x01},
{0xEDA7,0x2F,0x01},
{0xEDA8,0xF1,0x01},
{0xEDA9,0x09,0x01},
{0xEDAA,0x57,0x01},
{0xEDAB,0x04,0x01},
{0xEDAC,0x53,0x01},
{0xEDAD,0x99,0x01},
{0xEDAE,0xEC,0x01},
{0xEDAF,0x90,0x01},
{0xEDB0,0x66,0x01},
{0xEDB1,0x3C,0x01},
{0xEDB2,0x6D,0x01},
{0xEDB3,0xA9,0x01},
{0xEDB4,0x4C,0x01},
{0xEDB5,0x50,0x01},
{0xEDB6,0xA6,0x01},
{0xEDB7,0x32,0x01},
{0xEDB8,0x12,0x01},
{0xEDB9,0x94,0x01},
{0xEDBA,0x64,0x01},
{0xEDBB,0xA4,0x01},
{0xEDBC,0x23,0x01},
{0xEDBD,0x25,0x01},
{0xEDBE,0x71,0x01},
{0xEDBF,0x49,0x01},
{0xEDC0,0x51,0x01},
{0xEDC1,0xB4,0x01},
{0xEDC2,0x02,0x01},
{0xEDC3,0x17,0x01},
{0xEDC4,0xCE,0x01},
{0xEDC5,0x98,0x01},
{0xEDC6,0x06,0x01},
{0xEDC7,0x3E,0x01},
{0xEDC8,0xBC,0x01},
{0xEDC9,0x31,0x01},
{0xEDCA,0x50,0x01},
{0xEDCB,0x63,0x01},
{0xEDCC,0x86,0x01},
{0xEDCD,0x63,0x01},
{0xEDCE,0x16,0x01},
{0xEDCF,0xC4,0x01},
{0xEDD0,0x2C,0x01},
{0xEDD1,0x45,0x01},
{0xEDD2,0x2C,0x01},
{0xEDD3,0x43,0x01},
{0xEDD4,0xB9,0x01},
{0xEDD5,0x4A,0x01},
{0xEDD6,0x53,0x01},
{0xEDD7,0xCE,0x01},
{0xEDD8,0x82,0x01},
{0xEDD9,0x96,0x01},
{0xEDDA,0xC8,0x01},
{0xEDDB,0x40,0x01},
{0xEDDC,0x06,0x01},
{0xEDDD,0x3A,0x01},
{0xEDDE,0xBE,0x01},
{0xEDDF,0xC1,0x01},
{0xEDE0,0xD0,0x01},
{0xEDE1,0x75,0x01},
{0xEDE2,0x64,0x01},
{0xEDE3,0x34,0x01},
{0xEDE4,0x9B,0x01},
{0xEDE5,0xFE,0x01},
{0xEDE6,0x4C,0x01},
{0xEDE7,0xA6,0x01},
{0xEDE8,0x39,0x01},
{0xEDE9,0x7D,0x01},
{0xEDEA,0x89,0x01},
{0xEDEB,0x8D,0x01},
{0xEDEC,0x5D,0x01},
{0xEDED,0x4A,0x01},
{0xEDEE,0xE3,0x01},
{0xEDEF,0x97,0x01},
{0xEDF0,0xDA,0x01},
{0xEDF1,0x50,0x01},
{0xEDF2,0xE6,0x01},
{0xEDF3,0x3A,0x01},
{0xEDF4,0xB3,0x01},
{0xEDF5,0x39,0x01},
{0xEDF6,0x50,0x01},
{0xEDF7,0x76,0x01},
{0xEDF8,0x7A,0x01},
{0xEDF9,0xF4,0x01},
{0xEDFA,0x9E,0x01},
{0xEDFB,0x2A,0x01},
{0xEDFC,0x61,0x01},
{0xEDFD,0x87,0x01},
{0xEDFE,0x46,0x01},
{0xEDFF,0xC0,0x01},
{0xEE00,0x99,0x01},
{0xEE01,0xD0,0x01},
{0xEE02,0x6B,0x01},
{0xEE03,0x02,0x01},
{0xEE04,0x94,0x01},
{0xEE05,0x1A,0x01},
{0xEE06,0xFD,0x01},
{0xEE07,0xB8,0x01},
{0xEE08,0xE6,0x01},
{0xEE09,0x40,0x01},
{0xEE0A,0xC0,0x01},
{0xEE0B,0xF1,0x01},
{0xEE0C,0xD0,0x01},
{0xEE0D,0x75,0x01},
{0xEE0E,0x80,0x01},
{0xEE0F,0xE4,0x01},
{0xEE10,0x9E,0x01},
{0xEE11,0x33,0x01},
{0xEE12,0xE1,0x01},
{0xEE13,0xA7,0x01},
{0xEE14,0x4B,0x01},
{0xEE15,0xFD,0x01},
{0xEE16,0x21,0x01},
{0xEE17,0x53,0x01},
{0xEE18,0x7C,0x01},
{0xEE19,0xAE,0x01},
{0xEE1A,0x64,0x01},
{0xEE1B,0x9E,0x01},
{0xEE1C,0x26,0x01},
{0xEE1D,0x89,0x01},
{0xEE1E,0xC7,0x01},
{0xEE1F,0x49,0x01},
{0xEE20,0xE4,0x01},
{0xEE21,0x99,0x01},
{0xEE22,0x12,0x01},
{0xEE23,0x7D,0x01},
{0xEE24,0xCA,0x01},
{0xEE25,0xB4,0x01},
{0xEE26,0x9F,0x01},
{0xEE27,0x37,0x01},
{0xEE28,0xC5,0x01},
{0xEE29,0x47,0x01},
{0xEE2A,0x4D,0x01},
{0xEE2B,0xC2,0x01},
{0xEE2C,0x19,0x01},
{0xEE2D,0x0F,0x01},
{0xEE2E,0x73,0x01},
{0xEE2F,0xE2,0x01},
{0xEE30,0x13,0x01},
{0xEE31,0x1C,0x01},
{0xEE32,0xF5,0x01},
{0xEE33,0xE0,0x01},
{0xEE34,0xC6,0x01},
{0xEE35,0x3B,0x01},
{0xEE36,0xB6,0x01},
{0xEE37,0xB1,0x01},
{0xEE38,0xCE,0x01},
{0xEE39,0x6D,0x01},
{0xEE3A,0xB8,0x01},
{0xEE3B,0xF3,0x01},
{0xEE3C,0x9B,0x01},
{0xEE3D,0xF2,0x01},
{0xEE3E,0x18,0x01},
{0xEE3F,0x27,0x01},
{0xEE40,0x3D,0x01},
{0xEE41,0xBF,0x01},
{0xEE42,0xE9,0x01},
{0xEE43,0xCE,0x01},
{0xEE44,0x6E,0x01},
{0xEE45,0xBA,0x01},
{0xEE46,0x83,0x01},
{0xEE47,0x9A,0x01},
{0xEE48,0xE4,0x01},
{0xEE49,0x50,0x01},
{0xEE4A,0x66,0x01},
{0xEE4B,0x36,0x01},
{0xEE4C,0x8A,0x01},
{0xEE4D,0x29,0x01},
{0xEE4E,0x4D,0x01},
{0xEE4F,0x61,0x01},
{0xEE50,0x3A,0x01},
{0xEE51,0xA3,0x01},
{0xEE52,0x18,0x01},
{0xEE53,0xD2,0x01},
{0xEE54,0x50,0x01},
{0xEE55,0x26,0x01},
{0xEE56,0x36,0x01},
{0xEE57,0xA8,0x01},
{0xEE58,0x21,0x01},
{0xEE59,0xCE,0x01},
{0xEE5A,0x6E,0x01},
{0xEE5B,0xB2,0x01},
{0xEE5C,0x03,0x01},
{0xEE5D,0x9A,0x01},
{0xEE5E,0xE0,0x01},
{0xEE5F,0x1C,0x01},
{0xEE60,0x46,0x01},
{0xEE61,0x34,0x01},
{0xEE62,0x72,0x01},
{0xEE63,0x41,0x01},
{0xEE64,0x8C,0x01},
{0xEE65,0x58,0x01},
{0xEE66,0xE8,0x01},
{0xEE67,0xC2,0x01},
{0xEE68,0x95,0x01},
{0xEE69,0xB5,0x01},
{0xEE6A,0x88,0x01},
{0xEE6B,0x65,0x01},
{0xEE6C,0x2E,0x01},
{0xEE6D,0x72,0x01},
{0xEE6E,0x39,0x01},
{0xEE6F,0x8C,0x01},
{0xEE70,0x62,0x01},
{0xEE71,0x48,0x01},
{0xEE72,0x83,0x01},
{0xEE73,0x1A,0x01},
{0xEE74,0xE4,0x01},
{0xEE75,0x28,0x01},
{0xEE76,0x06,0x01},
{0xEE77,0x35,0x01},
{0xEE78,0x6A,0x01},
{0xEE79,0xF9,0x01},
{0xEE7A,0x4B,0x01},
{0xEE7B,0x53,0x01},
{0xEE7C,0xB8,0x01},
{0xEE7D,0x92,0x01},
{0xEE7E,0x13,0x01},
{0xEE7F,0xA2,0x01},
{0xEE80,0xCC,0x01},
{0xEE81,0x64,0x01},
{0xEE82,0x27,0x01},
{0xEE83,0x3B,0x01},
{0xEE84,0x29,0x01},
{0xEE85,0x0A,0x01},
{0xEE86,0x54,0x01},
{0xEE87,0xBC,0x01},
{0xEE88,0xF2,0x01},
{0xEE89,0x96,0x01},
{0xEE8A,0xC1,0x01},
{0xEE8B,0x40,0x01},
{0xEE8C,0xA6,0x01},
{0xEE8D,0x35,0x01},
{0xEE8E,0x7A,0x01},
{0xEE8F,0xB1,0x01},
{0xEE90,0x8C,0x01},
{0xEE91,0x54,0x01},
{0xEE92,0xC8,0x01},
{0xEE93,0xF2,0x01},
{0xEE94,0x92,0x01},
{0xEE95,0x9D,0x01},
{0xEE96,0x64,0x01},
{0xEE97,0xE4,0x01},
{0xEE98,0x23,0x01},
{0xEE99,0x13,0x01},
{0xEE9A,0xA9,0x01},
{0xEE9B,0x48,0x01},
{0xEE9C,0x47,0x01},
{0xEE9D,0x40,0x01},
{0xEE9E,0x42,0x01},
{0xEE9F,0x13,0x01},
{0xEEA0,0x9F,0x01},
{0xEEA1,0x58,0x01},
{0xEEA2,0xE5,0x01},
{0xEEA3,0x2C,0x01},
{0xEEA4,0x7F,0x01},
{0xEEA5,0xD9,0x01},
{0xEEA6,0x8C,0x01},
{0xEEA7,0x5B,0x01},
{0xEEA8,0x12,0x01},
{0xEEA9,0x43,0x01},
{0xEEAA,0x14,0x01},
{0xEEAB,0xAA,0x01},
{0xEEAC,0x80,0x01},
{0xEEAD,0x04,0x01},
{0xEEAE,0x25,0x01},
{0xEEAF,0x06,0x01},
{0xEEB0,0x51,0x01},
{0xEEB1,0x08,0x01},
{0xEEB2,0x40,0x01},
{0xEEB3,0x00,0x01},
{0xEEB4,0xB2,0x01},
{0xEEB5,0x10,0x01},
{0xEEB6,0x86,0x01},
{0xEEB7,0x98,0x01},
{0xEEB8,0x64,0x01},
{0xEEB9,0x25,0x01},
{0xEEBA,0x4A,0x01},
{0xEEBB,0xB9,0x01},
{0xEEBC,0x0A,0x01},
{0xEEBD,0x5D,0x01},
{0xEEBE,0x1C,0x01},
{0xEEBF,0x13,0x01},
{0xEEC0,0x97,0x01},
{0xEEC1,0xC4,0x01},
{0xEEC2,0x18,0x01},
{0xEEC3,0x85,0x01},
{0xEEC4,0x2A,0x01},
{0xEEC5,0x21,0x01},
{0xEEC6,0x41,0x01},
{0xEEC7,0xC9,0x01},
{0xEEC8,0x41,0x01},
{0xEEC9,0x12,0x01},
{0xEECA,0x02,0x01},
{0xEECB,0x10,0x01},
{0xEECC,0x80,0x01},
{0xEECD,0x2C,0x01},
{0xEECE,0x64,0x01},
{0xEECF,0x21,0x01},
{0xEED0,0x27,0x01},
{0xEED1,0x61,0x01},
{0xEED2,0xC9,0x01},
{0xEED3,0x52,0x01},
{0xEED4,0xB0,0x01},
{0xEED5,0x42,0x01},
{0xEED6,0x17,0x01},
{0xEED7,0xC8,0x01},
{0xEED8,0x04,0x01},
{0xEED9,0xE6,0x01},
{0xEEDA,0x32,0x01},
{0xEEDB,0x58,0x01},
{0xEEDC,0x29,0x01},
{0xEEDD,0xCB,0x01},
{0xEEDE,0x4C,0x01},
{0xEEDF,0x74,0x01},
{0xEEE0,0x92,0x01},
{0xEEE1,0x91,0x01},
{0xEEE2,0x8E,0x01},
{0xEEE3,0x48,0x01},
{0xEEE4,0x84,0x01},
{0xEEE5,0x22,0x01},
{0xEEE6,0x1D,0x01},
{0xEEE7,0x01,0x01},
{0xEEE8,0xC9,0x01},
{0xEEE9,0x4D,0x01},
{0xEEEA,0x7E,0x01},
{0xEEEB,0x82,0x01},
{0xEEEC,0x15,0x01},
{0xEEED,0xB5,0x01},
{0xEEEE,0x04,0x01},
{0xEEEF,0xE6,0x01},
{0xEEF0,0x33,0x01},
{0xEEF1,0x99,0x01},
{0xEEF2,0x69,0x01},
{0xEEF3,0x0D,0x01},
{0xEEF4,0x5D,0x01},
{0xEEF5,0x06,0x01},
{0xEEF6,0x33,0x01},
{0xEEF7,0x15,0x01},
{0xEEF8,0xAF,0x01},
{0xEEF9,0xEC,0x01},
{0xEEFA,0xA4,0x01},
{0xEEFB,0x28,0x01},
{0xEEFC,0x35,0x01},
{0xEEFD,0xE9,0x01},
{0xEEFE,0x09,0x01},
{0xEEFF,0x4F,0x01},
{0xEF00,0x8E,0x01},
{0xEF01,0x02,0x01},
{0xEF02,0x95,0x01},
{0xEF03,0xB1,0x01},
{0xEF04,0xC4,0x01},
{0xEF05,0x25,0x01},
{0xEF06,0x31,0x01},
{0xEF07,0x94,0x01},
{0xEF08,0xB1,0x01},
{0xEF09,0x4D,0x01},
{0xEF0A,0x6C,0x01},
{0xEF0B,0x94,0x01},
{0xEF0C,0x43,0x01},
{0xEF0D,0x99,0x01},
{0xEF0E,0xD4,0x01},
{0xEF0F,0xEC,0x01},
{0xEF10,0xC5,0x01},
{0xEF11,0x31,0x01},
{0xEF12,0x69,0x01},
{0xEF13,0xC9,0x01},
{0xEF14,0x0B,0x01},
{0xEF15,0x58,0x01},
{0xEF16,0xE6,0x01},
{0xEF17,0x52,0x01},
{0xEF18,0x16,0x01},
{0xEF19,0xBE,0x01},
{0xEF1A,0xD4,0x01},
{0xEF1B,0x45,0x01},
{0xEF1C,0x32,0x01},
{0xEF1D,0x8E,0x01},
{0xEF1E,0x79,0x01},
{0xEF1F,0x4D,0x01},
{0xEF20,0x6A,0x01},
{0xEF21,0xA4,0x01},
{0xEF22,0x83,0x01},
{0xEF23,0x1C,0x01},
{0xEF24,0xF2,0x01},
{0xEF25,0xDC,0x01},
{0xEF26,0x26,0x01},
{0xEF27,0x3A,0x01},
{0xEF28,0xA3,0x01},
{0xEF29,0xE1,0x01},
{0xEF2A,0x4D,0x01},
{0xEF2B,0x65,0x01},
{0xEF2C,0x5C,0x01},
{0xEF2D,0xC3,0x01},
{0xEF2E,0x98,0x01},
{0xEF2F,0xD4,0x01},
{0xEF30,0x3C,0x01},
{0xEF31,0xE6,0x01},
{0xEF32,0x35,0x01},
{0xEF33,0x9D,0x01},
{0xEF34,0x09,0x01},
{0xEF35,0x8E,0x01},
{0xEF36,0x6B,0x01},
{0xEF37,0xAC,0x01},
{0xEF38,0xE3,0x01},
{0xEF39,0x9B,0x01},
{0xEF3A,0xF4,0x01},
{0xEF3B,0x34,0x01},
{0xEF3C,0x07,0x01},
{0xEF3D,0x3E,0x01},
{0xEF3E,0xDA,0x01},
{0xEF3F,0xC1,0x01},
{0xEF40,0x8F,0x01},
{0xEF41,0x74,0x01},
{0xEF42,0xEA,0x01},
{0xEF43,0x13,0x01},
{0xEF44,0x9C,0x01},
{0xEF45,0xF4,0x01},
{0xEF46,0xF0,0x01},
{0xEF47,0xA6,0x01},
{0xEF48,0x3C,0x01},
{0xEF49,0xC0,0x01},
{0xEF4A,0x49,0x01},
{0xEF4B,0x0F,0x01},
{0xEF4C,0x72,0x01},
{0xEF4D,0xEA,0x01},
{0xEF4E,0xD3,0x01},
{0xEF4F,0x9C,0x01},
{0xEF50,0xFE,0x01},
{0xEF51,0x04,0x01},
{0xEF52,0xA7,0x01},
{0xEF53,0x3D,0x01},

//SHD2 CW+TL84 33:66

{0xED00,0x9191,0x02},//
{0xEF54,0x2F,0x01},
{0xEF55,0xF2,0x01},
{0xEF56,0x51,0x01},
{0xEF57,0x8D,0x01},
{0xEF58,0x50,0x01},
{0xEF59,0x74,0x01},
{0xEF5A,0xA2,0x01},
{0xEF5B,0x14,0x01},
{0xEF5C,0xE1,0x01},
{0xEF5D,0xC8,0x01},
{0xEF5E,0x47,0x01},
{0xEF5F,0x2E,0x01},
{0xEF60,0xD2,0x01},
{0xEF61,0x10,0x01},
{0xEF62,0x80,0x01},
{0xEF63,0xC8,0x01},
{0xEF64,0x13,0x01},
{0xEF65,0x9D,0x01},
{0xEF66,0xE5,0x01},
{0xEF67,0x48,0x01},
{0xEF68,0x87,0x01},
{0xEF69,0x3C,0x01},
{0xEF6A,0xFE,0x01},
{0xEF6B,0xC9,0x01},
{0xEF6C,0x50,0x01},
{0xEF6D,0x7D,0x01},
{0xEF6E,0x96,0x01},
{0xEF6F,0x83,0x01},
{0xEF70,0x9A,0x01},
{0xEF71,0xC6,0x01},
{0xEF72,0x10,0x01},
{0xEF73,0xA6,0x01},
{0xEF74,0x31,0x01},
{0xEF75,0xA5,0x01},
{0xEF76,0x61,0x01},
{0xEF77,0xCE,0x01},
{0xEF78,0x7F,0x01},
{0xEF79,0xA4,0x01},
{0xEF7A,0xD3,0x01},
{0xEF7B,0x19,0x01},
{0xEF7C,0xB6,0x01},
{0xEF7D,0x38,0x01},
{0xEF7E,0xA5,0x01},
{0xEF7F,0x28,0x01},
{0xEF80,0x4E,0x01},
{0xEF81,0x69,0x01},
{0xEF82,0x4B,0x01},
{0xEF83,0x68,0x01},
{0xEF84,0xBA,0x01},
{0xEF85,0x93,0x01},
{0xEF86,0x1B,0x01},
{0xEF87,0xBC,0x01},
{0xEF88,0x0C,0x01},
{0xEF89,0x65,0x01},
{0xEF8A,0x24,0x01},
{0xEF8B,0x17,0x01},
{0xEF8C,0x19,0x01},
{0xEF8D,0x49,0x01},
{0xEF8E,0x51,0x01},
{0xEF8F,0xF6,0x01},
{0xEF90,0xE2,0x01},
{0xEF91,0x1B,0x01},
{0xEF92,0xD5,0x01},
{0xEF93,0x98,0x01},
{0xEF94,0xC5,0x01},
{0xEF95,0x25,0x01},
{0xEF96,0x0B,0x01},
{0xEF97,0x01,0x01},
{0xEF98,0x48,0x01},
{0xEF99,0x43,0x01},
{0xEF9A,0x64,0x01},
{0xEF9B,0x72,0x01},
{0xEF9C,0x96,0x01},
{0xEF9D,0xD6,0x01},
{0xEF9E,0xA8,0x01},
{0xEF9F,0xE6,0x01},
{0xEFA0,0x2C,0x01},
{0xEFA1,0x30,0x01},
{0xEFA2,0x51,0x01},
{0xEFA3,0x48,0x01},
{0xEFA4,0x40,0x01},
{0xEFA5,0x1C,0x01},
{0xEFA6,0x22,0x01},
{0xEFA7,0x93,0x01},
{0xEFA8,0xB4,0x01},
{0xEFA9,0xC8,0x01},
{0xEFAA,0xA6,0x01},
{0xEFAB,0x37,0x01},
{0xEFAC,0x7C,0x01},
{0xEFAD,0x29,0x01},
{0xEFAE,0x8A,0x01},
{0xEFAF,0x48,0x01},
{0xEFB0,0x30,0x01},
{0xEFB1,0x62,0x01},
{0xEFB2,0x12,0x01},
{0xEFB3,0xA4,0x01},
{0xEFB4,0xF8,0x01},
{0xEFB5,0x65,0x01},
{0xEFB6,0x38,0x01},
{0xEFB7,0xDB,0x01},
{0xEFB8,0x11,0x01},
{0xEFB9,0x0D,0x01},
{0xEFBA,0x5C,0x01},
{0xEFBB,0xA0,0x01},
{0xEFBC,0x72,0x01},
{0xEFBD,0x94,0x01},
{0xEFBE,0xA9,0x01},
{0xEFBF,0xD0,0x01},
{0xEFC0,0x05,0x01},
{0xEFC1,0x35,0x01},
{0xEFC2,0xE5,0x01},
{0xEFC3,0x11,0x01},
{0xEFC4,0xD0,0x01},
{0xEFC5,0x74,0x01},
{0xEFC6,0x52,0x01},
{0xEFC7,0x03,0x01},
{0xEFC8,0x19,0x01},
{0xEFC9,0xC3,0x01},
{0xEFCA,0x48,0x01},
{0xEFCB,0xC6,0x01},
{0xEFCC,0x35,0x01},
{0xEFCD,0xD7,0x01},
{0xEFCE,0x41,0x01},
{0xEFCF,0x10,0x01},
{0xEFD0,0x88,0x01},
{0xEFD1,0x06,0x01},
{0xEFD2,0x54,0x01},
{0xEFD3,0x9E,0x01},
{0xEFD4,0xE9,0x01},
{0xEFD5,0x30,0x01},
{0xEFD6,0xC7,0x01},
{0xEFD7,0x3A,0x01},
{0xEFD8,0xEA,0x01},
{0xEFD9,0x41,0x01},
{0xEFDA,0x50,0x01},
{0xEFDB,0x8A,0x01},
{0xEFDC,0x4E,0x01},
{0xEFDD,0xB4,0x01},
{0xEFDE,0x22,0x01},
{0xEFDF,0x10,0x01},
{0xEFE0,0x51,0x01},
{0xEFE1,0x48,0x01},
{0xEFE2,0x42,0x01},
{0xEFE3,0x19,0x01},
{0xEFE4,0x2A,0x01},
{0xEFE5,0x91,0x01},
{0xEFE6,0x8B,0x01},
{0xEFE7,0x5A,0x01},
{0xEFE8,0x04,0x01},
{0xEFE9,0x00,0x01},
{0xEFEA,0x00,0x01},
{0xEFEB,0x00,0x01},
{0xEFEC,0x00,0x01},
{0xEFED,0x00,0x01},



//SHD3 D65+TL84 C01//
{0xED00,0x9191,0x02},//
{0xEFEE,0x21,0x01},
{0xEFEF,0xAA,0x01},
{0xEFF0,0xD1,0x01},
{0xEFF1,0x8B,0x01},
{0xEFF2,0x4A,0x01},
{0xEFF3,0x64,0x01},
{0xEFF4,0x22,0x01},
{0xEFF5,0x15,0x01},
{0xEFF6,0xD9,0x01},
{0xEFF7,0x28,0x01},
{0xEFF8,0x47,0x01},
{0xEFF9,0x26,0x01},
{0xEFFA,0xA2,0x01},
{0xEFFB,0x50,0x01},
{0xEFFC,0x7F,0x01},
{0xEFFD,0xC6,0x01},
{0xEFFE,0x23,0x01},
{0xEFFF,0x9D,0x01},
{0xF000,0xE6,0x01},
{0xF001,0x54,0x01},
{0xF002,0xE7,0x01},
{0xF003,0x3C,0x01},
{0xF004,0x00,0x01},
{0xF005,0xBA,0x01},
{0xF006,0xD0,0x01},
{0xF007,0x7C,0x01},
{0xF008,0x98,0x01},
{0xF009,0xA3,0x01},
{0xF00A,0x9A,0x01},
{0xF00B,0xC7,0x01},
{0xF00C,0x18,0x01},
{0xF00D,0x06,0x01},
{0xF00E,0x32,0x01},
{0xF00F,0xAA,0x01},
{0xF010,0x81,0x01},
{0xF011,0x8E,0x01},
{0xF012,0x80,0x01},
{0xF013,0xA4,0x01},
{0xF014,0xE3,0x01},
{0xF015,0x19,0x01},
{0xF016,0xB7,0x01},
{0xF017,0x3C,0x01},
{0xF018,0xC5,0x01},
{0xF019,0x28,0x01},
{0xF01A,0x51,0x01},
{0xF01B,0x89,0x01},
{0xF01C,0x8B,0x01},
{0xF01D,0x69,0x01},
{0xF01E,0xC4,0x01},
{0xF01F,0x93,0x01},
{0xF020,0x9B,0x01},
{0xF021,0xBC,0x01},
{0xF022,0x10,0x01},
{0xF023,0x65,0x01},
{0xF024,0x24,0x01},
{0xF025,0x18,0x01},
{0xF026,0x21,0x01},
{0xF027,0x09,0x01},
{0xF028,0x52,0x01},
{0xF029,0x00,0x01},
{0xF02A,0x33,0x01},
{0xF02B,0x9C,0x01},
{0xF02C,0xD5,0x01},
{0xF02D,0x9C,0x01},
{0xF02E,0xE5,0x01},
{0xF02F,0x25,0x01},
{0xF030,0x0A,0x01},
{0xF031,0x01,0x01},
{0xF032,0x88,0x01},
{0xF033,0x43,0x01},
{0xF034,0x68,0x01},
{0xF035,0xA2,0x01},
{0xF036,0x16,0x01},
{0xF037,0xD9,0x01},
{0xF038,0xAC,0x01},
{0xF039,0x06,0x01},
{0xF03A,0x2D,0x01},
{0xF03B,0x30,0x01},
{0xF03C,0x51,0x01},
{0xF03D,0x48,0x01},
{0xF03E,0x40,0x01},
{0xF03F,0x1E,0x01},
{0xF040,0x42,0x01},
{0xF041,0x93,0x01},
{0xF042,0xB6,0x01},
{0xF043,0xDC,0x01},
{0xF044,0xC6,0x01},
{0xF045,0x37,0x01},
{0xF046,0x7E,0x01},
{0xF047,0x31,0x01},
{0xF048,0xCA,0x01},
{0xF049,0x48,0x01},
{0xF04A,0x32,0x01},
{0xF04B,0x72,0x01},
{0xF04C,0x92,0x01},
{0xF04D,0xA5,0x01},
{0xF04E,0x08,0x01},
{0xF04F,0x26,0x01},
{0xF050,0x39,0x01},
{0xF051,0xDC,0x01},
{0xF052,0x19,0x01},
{0xF053,0x8D,0x01},
{0xF054,0x5C,0x01},
{0xF055,0xA4,0x01},
{0xF056,0x92,0x01},
{0xF057,0x14,0x01},
{0xF058,0xAB,0x01},
{0xF059,0xE0,0x01},
{0xF05A,0xA5,0x01},
{0xF05B,0x35,0x01},
{0xF05C,0xEA,0x01},
{0xF05D,0x09,0x01},
{0xF05E,0x10,0x01},
{0xF05F,0x75,0x01},
{0xF060,0x58,0x01},
{0xF061,0x33,0x01},
{0xF062,0x99,0x01},
{0xF063,0xC4,0x01},
{0xF064,0x58,0x01},
{0xF065,0x66,0x01},
{0xF066,0x36,0x01},
{0xF067,0xDB,0x01},
{0xF068,0x61,0x01},
{0xF069,0xD0,0x01},
{0xF06A,0x86,0x01},
{0xF06B,0x02,0x01},
{0xF06C,0x64,0x01},
{0xF06D,0x1E,0x01},
{0xF06E,0xEB,0x01},
{0xF06F,0x40,0x01},
{0xF070,0x47,0x01},
{0xF071,0x3B,0x01},
{0xF072,0xEE,0x01},
{0xF073,0x51,0x01},
{0xF074,0x10,0x01},
{0xF075,0x8A,0x01},
{0xF076,0x36,0x01},
{0xF077,0x54,0x01},
{0xF078,0x22,0x01},
{0xF079,0x0E,0x01},
{0xF07A,0x51,0x01},
{0xF07B,0x88,0x01},
{0xF07C,0x42,0x01},
{0xF07D,0x1A,0x01},
{0xF07E,0x2A,0x01},
{0xF07F,0x11,0x01},
{0xF080,0x8B,0x01},
{0xF081,0x48,0x01},
{0xF082,0x04,0x01},
{0xF083,0x00,0x01},
{0xF084,0x00,0x01},
{0xF085,0x00,0x01},
{0xF086,0x00,0x01},
{0xF087,0x00,0x01},
{0xF088,0xBE,0x01},
{0xF089,0x51,0x01},
{0xF08A,0x4E,0x01},
{0xF08B,0x6F,0x01},
{0xF08C,0x6C,0x01},
{0xF08D,0x43,0x01},
{0xF08E,0x1B,0x01},
{0xF08F,0xDA,0x01},
{0xF090,0xEC,0x01},
{0xF091,0x46,0x01},
{0xF092,0x38,0x01},
{0xF093,0xBB,0x01},
{0xF094,0xC1,0x01},
{0xF095,0xCD,0x01},
{0xF096,0x69,0x01},
{0xF097,0x26,0x01},
{0xF098,0x93,0x01},
{0xF099,0x98,0x01},
{0xF09A,0xC1,0x01},
{0xF09B,0x20,0x01},
{0xF09C,0x26,0x01},
{0xF09D,0x32,0x01},
{0xF09E,0xA5,0x01},
{0xF09F,0xB1,0x01},
{0xF0A0,0x8D,0x01},
{0xF0A1,0x67,0x01},
{0xF0A2,0x0E,0x01},
{0xF0A3,0x23,0x01},
{0xF0A4,0x97,0x01},
{0xF0A5,0xB0,0x01},
{0xF0A6,0x6C,0x01},
{0xF0A7,0x25,0x01},
{0xF0A8,0x2C,0x01},
{0xF0A9,0x71,0x01},
{0xF0AA,0x41,0x01},
{0xF0AB,0x0C,0x01},
{0xF0AC,0x69,0x01},
{0xF0AD,0x14,0x01},
{0xF0AE,0xB3,0x01},
{0xF0AF,0x96,0x01},
{0xF0B0,0xA6,0x01},
{0xF0B1,0xE8,0x01},
{0xF0B2,0x64,0x01},
{0xF0B3,0x26,0x01},
{0xF0B4,0x3A,0x01},
{0xF0B5,0x79,0x01},
{0xF0B6,0x4A,0x01},
{0xF0B7,0x5B,0x01},
{0xF0B8,0x18,0x01},
{0xF0B9,0xA3,0x01},
{0xF0BA,0x97,0x01},
{0xF0BB,0xA9,0x01},
{0xF0BC,0xBC,0x01},
{0xF0BD,0x24,0x01},
{0xF0BE,0x23,0x01},
{0xF0BF,0x13,0x01},
{0xF0C0,0xE1,0x01},
{0xF0C1,0xC8,0x01},
{0xF0C2,0x4C,0x01},
{0xF0C3,0xAA,0x01},
{0xF0C4,0xA2,0x01},
{0xF0C5,0x97,0x01},
{0xF0C6,0xB6,0x01},
{0xF0C7,0x14,0x01},
{0xF0C8,0x05,0x01},
{0xF0C9,0x24,0x01},
{0xF0CA,0x06,0x01},
{0xF0CB,0x09,0x01},
{0xF0CC,0xC8,0x01},
{0xF0CD,0x42,0x01},
{0xF0CE,0x48,0x01},
{0xF0CF,0x82,0x01},
{0xF0D0,0x14,0x01},
{0xF0D1,0xB8,0x01},
{0xF0D2,0xC0,0x01},
{0xF0D3,0xE5,0x01},
{0xF0D4,0x28,0x01},
{0xF0D5,0x21,0x01},
{0xF0D6,0x39,0x01},
{0xF0D7,0x08,0x01},
{0xF0D8,0x40,0x01},
{0xF0D9,0x14,0x01},
{0xF0DA,0x62,0x01},
{0xF0DB,0x92,0x01},
{0xF0DC,0xA4,0x01},
{0xF0DD,0xC4,0x01},
{0xF0DE,0x05,0x01},
{0xF0DF,0x30,0x01},
{0xF0E0,0x58,0x01},
{0xF0E1,0xA1,0x01},
{0xF0E2,0x49,0x01},
{0xF0E3,0x46,0x01},
{0xF0E4,0x22,0x01},
{0xF0E5,0xB2,0x01},
{0xF0E6,0x91,0x01},
{0xF0E7,0x9A,0x01},
{0xF0E8,0x58,0x01},
{0xF0E9,0xA5,0x01},
{0xF0EA,0x2F,0x01},
{0xF0EB,0x96,0x01},
{0xF0EC,0x99,0x01},
{0xF0ED,0x8B,0x01},
{0xF0EE,0x54,0x01},
{0xF0EF,0x74,0x01},
{0xF0F0,0x32,0x01},
{0xF0F1,0x13,0x01},
{0xF0F2,0x9D,0x01},
{0xF0F3,0x38,0x01},
{0xF0F4,0xC5,0x01},
{0xF0F5,0x2D,0x01},
{0xF0F6,0x90,0x01},
{0xF0F7,0x59,0x01},
{0xF0F8,0x4D,0x01},
{0xF0F9,0x64,0x01},
{0xF0FA,0xEE,0x01},
{0xF0FB,0x62,0x01},
{0xF0FC,0x16,0x01},
{0xF0FD,0xAE,0x01},
{0xF0FE,0x84,0x01},
{0xF0FF,0x25,0x01},
{0xF100,0x2E,0x01},
{0xF101,0x8B,0x01},
{0xF102,0x31,0x01},
{0xF103,0xCD,0x01},
{0xF104,0x6F,0x01},
{0xF105,0x60,0x01},
{0xF106,0xC3,0x01},
{0xF107,0x19,0x01},
{0xF108,0xC7,0x01},
{0xF109,0x14,0x01},
{0xF10A,0x26,0x01},
{0xF10B,0x31,0x01},
{0xF10C,0x97,0x01},
{0xF10D,0x41,0x01},
{0xF10E,0x8D,0x01},
{0xF10F,0x6D,0x01},
{0xF110,0x86,0x01},
{0xF111,0xE3,0x01},
{0xF112,0x9C,0x01},
{0xF113,0xE2,0x01},
{0xF114,0xD8,0x01},
{0xF115,0x06,0x01},
{0xF116,0x36,0x01},
{0xF117,0xB5,0x01},
{0xF118,0xE9,0x01},
{0xF119,0x4D,0x01},
{0xF11A,0x70,0x01},
{0xF11B,0x68,0x01},
{0xF11C,0x03,0x01},
{0xF11D,0x00,0x01},
{0xF11E,0x00,0x01},
{0xF11F,0x00,0x01},
{0xF120,0x00,0x01},
{0xF121,0x00,0x01},


//SHD TH
{0x6C32,0x1964,0x02},    // SHD_INP_TH_HB_H_R2
{0x6C34,0x18CE,0x02},    // SHD_INP_TH_HB_L_R2
{0x6C36,0x10CC,0x02},    // SHD_INP_TH_LB_H_R2
{0x6C38,0x1004,0x02},    // SHD_INP_TH_LB_L_R2
{0x6C3C,0x10CC,0x02},    // SHD_INP_TH_HB_H_RB
{0x6C3E,0x1004,0x02},    // SHD_INP_TH_HB_L_RB
{0x6C40,0x0000,0x02},    // SHD_INP_TH_LB_H_RB
{0x6C42,0x0000,0x02},    // SHD_INP_TH_LB_L_RB

//PreWB_offset (for SHD2)
{0x6828,0x0013,0x02},    // SHD_PRER_OFFSET_R2 :
//PreWB_offset (for SHD3)
{0x682C,0x000B,0x02},    // SHD_PRER_OFFSET_RB :
{0x6830,0xFFFD,0x02},    // SHD_PREB_OFFSET_RB :

// CXC/SHD EN
{0x01BC,0x57,0x01},    // CXC ON SHD ON INP ON GAIN OFF
};

static const isx012_regset_t ISX012_Flash_ON[] =
{
//Flash_ON_SET
{0x00B7,0x15,0x01},    // LED_ON
{0x0016,0x10,0x01},    // GPIO_FUNCSEL
{0x0181,0x05,0x01},    // CAP_HALF_AE_CTRL
{0x01AE,0x01,0x01},    // HALF_AWB_CTRL
{0x6223,0x01,0x01},    // INIT_GAINS
{0x6226,0x01,0x01},    // ATW_GAINS_IN_NR
{0x6227,0x01,0x01},    // ATW_GAINS_IN
{0x6228,0x01,0x01},    // ATW_GAINS_OUT_NR
{0x6229,0x01,0x01},    // ATW_GAINS_OUT
{0x5E3D,0x0F,0x01},    // FASTMOVE_TIMEOUT
{0x5E32,0x0F,0x01},    // AESPEED_FAST
{0x5E2E,0x1A,0x01},    // AEIINDEADBAND
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x01AF,0x01,0x01},    // CAP_AWB_CTRL
{0x6224,0x01,0x01},    // ATW_DELAY
//AWB boundary set
{0x6400,0x00,0x01},    // INFRM_LEFT00 :
{0x6401,0x00,0x01},    // INFRM_LEFT01 :
{0x6402,0x00,0x01},    // INFRM_LEFT02 :
{0x6403,0x00,0x01},    // INFRM_LEFT03 :
{0x6404,0x00,0x01},    // INFRM_LEFT04 :
{0x6405,0x00,0x01},    // INFRM_LEFT05 :
{0x6406,0x00,0x01},    // INFRM_LEFT06 :
{0x6407,0x00,0x01},    // INFRM_LEFT07 :
{0x6408,0x00,0x01},    // INFRM_LEFT08 :
{0x6409,0x00,0x01},    // INFRM_LEFT09 :
{0x640A,0x00,0x01},    // INFRM_LEFT10 :
{0x640B,0x00,0x01},    // INFRM_LEFT11 :
{0x640C,0x00,0x01},    // INFRM_LEFT12 :
{0x640D,0x00,0x01},    // INFRM_LEFT13 :
{0x640E,0x00,0x01},    // INFRM_LEFT14 :
{0x640F,0x00,0x01},    // INFRM_LEFT15 :
{0x6410,0x00,0x01},    // INFRM_LEFT16 :
{0x6411,0x00,0x01},    // INFRM_LEFT17 :
{0x6412,0x00,0x01},    // INFRM_LEFT18 :
{0x6413,0x00,0x01},    // INFRM_LEFT19 :
{0x6414,0x00,0x01},    // INFRM_LEFT20 :
{0x6415,0x00,0x01},    // INFRM_LEFT21 :
{0x6416,0x00,0x01},    // INFRM_LEFT22 :
{0x6417,0x00,0x01},    // INFRM_LEFT23 :
{0x6418,0x00,0x01},    // INFRM_LEFT24 :
{0x6419,0x00,0x01},    // INFRM_LEFT25 :
{0x641A,0x00,0x01},    // INFRM_LEFT26 :
{0x641B,0x00,0x01},    // INFRM_LEFT27 :
{0x641C,0x00,0x01},    // INFRM_LEFT28 :
{0x641D,0x00,0x01},    // INFRM_LEFT29 :
{0x641E,0x00,0x01},    // INFRM_LEFT30 :
{0x641F,0x00,0x01},    // INFRM_LEFT31 :
{0x6420,0x00,0x01},    // INFRM_LEFT32 :
{0x6421,0x00,0x01},    // INFRM_LEFT33 :
{0x6422,0x00,0x01},    // INFRM_LEFT34 :
{0x6423,0x00,0x01},    // INFRM_LEFT35 :
{0x6424,0x00,0x01},    // INFRM_LEFT36 :
{0x6425,0x00,0x01},    // INFRM_LEFT37 :
{0x6426,0xFF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xFF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xFF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xFF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xFF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xFF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xFF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xFF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xFF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xFF,0x01},    // INFRM_RIGHT09 :
{0x6430,0xFF,0x01},    // INFRM_RIGHT10 :
{0x6431,0xFF,0x01},    // INFRM_RIGHT11 :
{0x6432,0xFF,0x01},    // INFRM_RIGHT12 :
{0x6433,0xFF,0x01},    // INFRM_RIGHT13 :
{0x6434,0xFF,0x01},    // INFRM_RIGHT14 :
{0x6435,0xFF,0x01},    // INFRM_RIGHT15 :
{0x6436,0xFF,0x01},    // INFRM_RIGHT16 :
{0x6437,0xFF,0x01},    // INFRM_RIGHT17 :
{0x6438,0xFF,0x01},    // INFRM_RIGHT18 :
{0x6439,0xFF,0x01},    // INFRM_RIGHT19 :
{0x643A,0xFF,0x01},    // INFRM_RIGHT20 :
{0x643B,0xFF,0x01},    // INFRM_RIGHT21 :
{0x643C,0xFF,0x01},    // INFRM_RIGHT22 :
{0x643D,0xFF,0x01},    // INFRM_RIGHT23 :
{0x643E,0xFF,0x01},    // INFRM_RIGHT24 :
{0x643F,0xFF,0x01},    // INFRM_RIGHT25 :
{0x6440,0xFF,0x01},    // INFRM_RIGHT26 :
{0x6441,0xFF,0x01},    // INFRM_RIGHT27 :
{0x6442,0xFF,0x01},    // INFRM_RIGHT28 :
{0x6443,0xFF,0x01},    // INFRM_RIGHT29 :
{0x6444,0xFF,0x01},    // INFRM_RIGHT30 :
{0x6445,0xFF,0x01},    // INFRM_RIGHT31 :
{0x6446,0xFF,0x01},    // INFRM_RIGHT32 :
{0x6447,0xFF,0x01},    // INFRM_RIGHT33 :
{0x6448,0xFF,0x01},    // INFRM_RIGHT34 :
{0x6449,0xFF,0x01},    // INFRM_RIGHT35 :
{0x644A,0xFF,0x01},    // INFRM_RIGHT36 :
{0x644B,0xFF,0x01},    // INFRM_RIGHT37 :
{0x644C,0x25C2,0x02},    // INFRM_TOP :
{0x644E,0x0348,0x02},    // INFRM_BOTM :
{0x6450,0x1D,0x01},    // INFRM_FLTOP :
{0x6451,0x00,0x01},    // INFRM_FLBOTM :
//halfrelease_mode value
{0x0082,0x01,0x01},    // MONI_REFRESH
{0x00B1,0x01,0x01},    //AF_RESTART_F :
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x00,0x01},    //AFMODE_HREL :
{0xFFFF,0x42,0x01},//$wait, 66
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t ISX012_Flash_OFF[] =
{
//Flash_OFF_RESET
{0x00B7,0x00,0x01},    // LED_ON
{0x0016,0x10,0x01},    // GPIO_FUNCSEL
{0x0181,0x00,0x01},    // CAP_HALF_AE_CTRL
{0x01AE,0x00,0x01},    // HALF_AWB_CTRL
{0x6223,0x04,0x01},    // INIT_GAINS
{0x6226,0x08,0x01},    // ATW_GAINS_IN_NR
{0x6227,0x04,0x01},    // ATW_GAINS_IN
{0x6228,0x08,0x01},    // ATW_GAINS_OUT_NR
{0x6229,0x04,0x01},    // ATW_GAINS_OUT
{0x5E3D,0x0A,0x01},    // FASTMOVE_TIMEOUT
{0x5E32,0x0F,0x01},    // AESPEED_FAST
{0x5E2E,0x1A,0x01},    // AEIINDEADBAND
{0x500A,0x00,0x01},    // FAST_MODECHG_EN
{0x01AF,0x00,0x01},    // CAP_AWB_CTRL
{0x6224,0x04,0x01},    // ATW_DELAY
//AWB boundary reset
{0x6400,0xAA,0x01},    // INFRM_LEFT00 :
{0x6401,0xAA,0x01},    // INFRM_LEFT01 :
{0x6402,0xAA,0x01},    // INFRM_LEFT02 :
{0x6403,0xAA,0x01},    // INFRM_LEFT03 :
{0x6404,0xAA,0x01},    // INFRM_LEFT04 :
{0x6405,0xAA,0x01},    // INFRM_LEFT05 :
{0x6406,0xAA,0x01},    // INFRM_LEFT06 :
{0x6407,0xAA,0x01},    // INFRM_LEFT07 :
{0x6408,0xAA,0x01},    // INFRM_LEFT08 :
{0x6409,0xAE,0x01},    // INFRM_LEFT09 :
{0x640A,0xA0,0x01},    // INFRM_LEFT10 :
{0x640B,0x8C,0x01},    // INFRM_LEFT11 :
{0x640C,0x72,0x01},    // INFRM_LEFT12 :
{0x640D,0x64,0x01},    // INFRM_LEFT13 :
{0x640E,0x5A,0x01},    // INFRM_LEFT14 :
{0x640F,0x52,0x01},    // INFRM_LEFT15 :
{0x6410,0x48,0x01},    // INFRM_LEFT16 :
{0x6411,0x43,0x01},    // INFRM_LEFT17 :
{0x6412,0x3D,0x01},    // INFRM_LEFT18 :
{0x6413,0x37,0x01},    // INFRM_LEFT19 :
{0x6414,0x33,0x01},    // INFRM_LEFT20 :
{0x6415,0x30,0x01},    // INFRM_LEFT21 :
{0x6416,0x2E,0x01},    // INFRM_LEFT22 :
{0x6417,0x2B,0x01},    // INFRM_LEFT23 :
{0x6418,0x28,0x01},    // INFRM_LEFT24 :
{0x6419,0x26,0x01},    // INFRM_LEFT25 :
{0x641A,0x24,0x01},    // INFRM_LEFT26 :
{0x641B,0x23,0x01},    // INFRM_LEFT27 :
{0x641C,0x22,0x01},    // INFRM_LEFT28 :
{0x641D,0x22,0x01},    // INFRM_LEFT29 :
{0x641E,0x21,0x01},    // INFRM_LEFT30 :
{0x641F,0x20,0x01},    // INFRM_LEFT31 :
{0x6420,0x1D,0x01},    // INFRM_LEFT32 :
{0x6421,0x1A,0x01},    // INFRM_LEFT33 :
{0x6422,0x18,0x01},    // INFRM_LEFT34 :
{0x6423,0x17,0x01},    // INFRM_LEFT35 :
{0x6424,0x16,0x01},    // INFRM_LEFT36 :
{0x6425,0x17,0x01},    // INFRM_LEFT37 :
{0x6426,0xAF,0x01},    // INFRM_RIGHT00 :
{0x6427,0xAF,0x01},    // INFRM_RIGHT01 :
{0x6428,0xAF,0x01},    // INFRM_RIGHT02 :
{0x6429,0xAF,0x01},    // INFRM_RIGHT03 :
{0x642A,0xAF,0x01},    // INFRM_RIGHT04 :
{0x642B,0xAF,0x01},    // INFRM_RIGHT05 :
{0x642C,0xAF,0x01},    // INFRM_RIGHT06 :
{0x642D,0xAF,0x01},    // INFRM_RIGHT07 :
{0x642E,0xAF,0x01},    // INFRM_RIGHT08 :
{0x642F,0xAA,0x01},    // INFRM_RIGHT09 :
{0x6430,0xB2,0x01},    // INFRM_RIGHT10 :
{0x6431,0xB4,0x01},    // INFRM_RIGHT11 :
{0x6432,0xB6,0x01},    // INFRM_RIGHT12 :
{0x6433,0xB4,0x01},    // INFRM_RIGHT13 :
{0x6434,0x9B,0x01},    // INFRM_RIGHT14 :
{0x6435,0x8E,0x01},    // INFRM_RIGHT15 :
{0x6436,0x84,0x01},    // INFRM_RIGHT16 :
{0x6437,0x7A,0x01},    // INFRM_RIGHT17 :
{0x6438,0x72,0x01},    // INFRM_RIGHT18 :
{0x6439,0x6A,0x01},    // INFRM_RIGHT19 :
{0x643A,0x63,0x01},    // INFRM_RIGHT20 :
{0x643B,0x5E,0x01},    // INFRM_RIGHT21 :
{0x643C,0x58,0x01},    // INFRM_RIGHT22 :
{0x643D,0x53,0x01},    // INFRM_RIGHT23 :
{0x643E,0x4E,0x01},    // INFRM_RIGHT24 :
{0x643F,0x4A,0x01},    // INFRM_RIGHT25 :
{0x6440,0x46,0x01},    // INFRM_RIGHT26 :
{0x6441,0x42,0x01},    // INFRM_RIGHT27 :
{0x6442,0x3F,0x01},    // INFRM_RIGHT28 :
{0x6443,0x3C,0x01},    // INFRM_RIGHT29 :
{0x6444,0x3A,0x01},    // INFRM_RIGHT30 :
{0x6445,0x38,0x01},    // INFRM_RIGHT31 :
{0x6446,0x37,0x01},    // INFRM_RIGHT32 :
{0x6447,0x35,0x01},    // INFRM_RIGHT33 :
{0x6448,0x33,0x01},    // INFRM_RIGHT34 :
{0x6449,0x32,0x01},    // INFRM_RIGHT35 :
{0x644A,0x32,0x01},    // INFRM_RIGHT36 :
{0x644B,0x32,0x01},    // INFRM_RIGHT37 :
{0x644C,0x24FA,0x02},    // INFRM_TOP :
{0x644E,0x0940,0x02},    // INFRM_BOTM :
{0x6450,0x19,0x01},    // INFRM_FLTOP :
{0x6451,0x10,0x01},    // INFRM_FLBOTM :
////Flash_ON_RESET
{0x0308,0x11,0x01},    // AELINE_MONI_SN1_2 :
{0x0309,0x13,0x01},    // AELINE_MONI_SN3_4 :
{0x030B,0x41,0x01},    // AELINE_MONI_SN7_8 :
{0x030D,0x11,0x01},    // AELINE_MONI_SN11_12 :
{0x030E,0x11,0x01},    // AELINE_HALF_SN1_2 :
{0x030F,0x13,0x01},    // AELINE_HALF_SN3_4 :
{0x0311,0x41,0x01},    // AELINE_HALF_SN7_8 :
{0x0313,0x11,0x01},    // AELINE_HALF_SN11_12 :
{0x0314,0x11,0x01},    // AELINE_HALF_AFEND_SN1_2 :
{0x0315,0x13,0x01},    // AELINE_HALF_AFEND_SN3_4 :
{0x0317,0x41,0x01},    // AELINE_HALF_AFEND_SN7_8 :
{0x0319,0x11,0x01},    // AELINE_HALF_AFEND_SN11_12 :
{0x031A,0x00,0x01},    // AELINE_CAP_SN1_2 :
{0x031B,0x03,0x01},    // AELINE_CAP_SN3_4 :
{0x031D,0x50,0x01},    // AELINE_CAP_SN7_8 :
{0x031F,0x00,0x01},    // AELINE_CAP_SN11_12 :
{0x0294,0x00,0x01},    // AE_SN1
{0x0297,0x00,0x01},    // AE_SN4
{0x029A,0x00,0x01},    // AE_SN7
{0x029E,0x00,0x01},    // AE_SN11
};

static const isx012_regset_t ISX012_Flash_AELINE[] =
{
//Flash_ON_SET
{0x0308,0x12,0x01},    // AELINE_MONI_SN1_2 :
{0x0309,0x23,0x01},    // AELINE_MONI_SN3_4 :
{0x030B,0x42,0x01},    // AELINE_MONI_SN7_8 :
{0x030D,0x12,0x01},    // AELINE_MONI_SN11_12 :
{0x030E,0x12,0x01},    // AELINE_HALF_SN1_2 :
{0x030F,0x23,0x01},    // AELINE_HALF_SN3_4 :
{0x0311,0x42,0x01},    // AELINE_HALF_SN7_8 :
{0x0313,0x12,0x01},    // AELINE_HALF_SN11_12 :
{0x0314,0x12,0x01},    // AELINE_HALF_AFEND_SN1_2 :
{0x0315,0x23,0x01},    // AELINE_HALF_AFEND_SN3_4 :
{0x0317,0x42,0x01},    // AELINE_HALF_AFEND_SN7_8 :
{0x0319,0x12,0x01},    // AELINE_HALF_AFEND_SN11_12 :
{0x031A,0x02,0x01},    // AELINE_CAP_SN1_2 :
{0x031B,0x23,0x01},    // AELINE_CAP_SN3_4 :
{0x031D,0x52,0x01},    // AELINE_CAP_SN7_8 :
{0x031F,0x02,0x01},    // AELINE_CAP_SN11_12 :
};

static const isx012_regset_t ISX012_ae_manual_mode[] =
{
{0x0294,0x02,0x01}, /* AE_SN1 */
{0x0297,0x02,0x01}, /* AE_SN4 */
{0x029A,0x02,0x01}, /* AE_SN7 */
{0x029E,0x02,0x01}, /* AE_SN11 */
{0xFFFF,0x42,0x01}, /* $wait, 66 */
};

static const isx012_regset_t ISX012_flash_fast_ae_awb[] =
{
{0x5E32,0x0A,0x01},
{0x5E3D,0x05,0x01}, /* Don't fix me. 0x05 */

{0x0181,0x01,0x01},    // CAP_HALF_AE_CTRL
{0x00B2,0x03,0x01},    //AFMODE_MONI : AF OFF
{0x00B3,0x03,0x01},    //AFMODE_HREL : AF OFF
{0x0081,0x01,0x01},    //MODESEL
};

static const isx012_regset_t ISX012_Lowlux_Night_Reset[] =
{
{0x039D,0x00,0x01},    //UIHUE_TYPE3 :
{0x03A0,0x80,0x01},    //UISATURATION_TYPE3 :
{0x982A,0xFFEC,0x02},	 // CS_CBLLEV_A :
{0x9830,0xFFEC,0x02},	 // CS_CRLLEV_A :
{0x9805,0x0A,0x01},    // CS_SLP_C_A :
{0x6A9E,0x15C0,0x02},	 //HMAX_1_1(0x6A9E)=0x15C0
{0x00AC,0x00,0x01},    //
{0x660E,0x5A,0x01},    // AF_HBPF_PEAK_OPD_TH_MIN
{0x6610,0x5A,0x01},    // AF_HBPF_PEAK_OPD_TH_MAX
{0x664A,0x04,0x01},    // AF_DROPN_ON_PEAK_DETECT :
{0x6640,0x02,0x01},    // AF_DROPN_ON_PEAK_DETECT_SECOND :
{0x0289,0x20,0x01},    //AWB_SN8
};

#endif /* __ISX012_REGS_H__ */
