/*
 * midas-thermistor.c - thermistor of MIDAS Project
 *
 * Copyright (C) 2011 Samsung Electrnoics
 * SangYoung Son <hello.son@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <mach/midas-thermistor.h>
#ifdef CONFIG_SEC_THERMISTOR
#include <mach/sec_thermistor.h>
#endif

#if defined(CONFIG_MACH_C1_KOR_SKT) || defined(CONFIG_MACH_C1_KOR_KT) || \
	defined(CONFIG_MACH_C1_KOR_LGT) || defined(CONFIG_MACH_BAFFIN)
extern int siopLevellimit;
#endif

#ifdef CONFIG_S3C_ADC
#if defined(CONFIG_MACH_M0) || defined(CONFIG_MACH_P4NOTE) || defined(CONFIG_MACH_SP7160LTE) || defined(CONFIG_MACH_TAB3)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  204,	 800 },
	{  210,	 790 },
	{  216,	 780 },
	{  223,	 770 },
	{  230,	 760 },
	{  237,	 750 },
	{  244,	 740 },
	{  252,	 730 },
	{  260,	 720 },
	{  268,	 710 },
	{  276,	 700 },
	{  285,	 690 },
	{  294,	 680 },
	{  303,	 670 },
	{  312,	 660 },
	{  322,	 650 },
	{  332,	 640 },
	{  342,	 630 },
	{  353,	 620 },
	{  364,	 610 },
	{  375,	 600 },
	{  387,	 590 },
	{  399,	 580 },
	{  411,	 570 },
	{  423,	 560 },
	{  436,	 550 },
	{  450,	 540 },
	{  463,	 530 },
	{  477,	 520 },
	{  492,	 510 },
	{  507,	 500 },
	{  522,	 490 },
	{  537,	 480 },
	{  553,	 470 },
	{  569,	 460 },
	{  586,	 450 },
	{  603,	 440 },
	{  621,	 430 },
	{  638,	 420 },
	{  657,	 410 },
	{  675,	 400 },
	{  694,	 390 },
	{  713,	 380 },
	{  733,	 370 },
	{  753,	 360 },
	{  773,	 350 },
	{  794,	 340 },
	{  815,	 330 },
	{  836,	 320 },
	{  858,	 310 },
	{  880,	 300 },
	{  902,	 290 },
	{  924,	 280 },
	{  947,	 270 },
	{  969,	 260 },
	{  992,	 250 },
	{ 1015,	 240 },
	{ 1039,	 230 },
	{ 1062,	 220 },
	{ 1086,	 210 },
	{ 1109,	 200 },
	{ 1133,	 190 },
	{ 1156,	 180 },
	{ 1180,	 170 },
	{ 1204,	 160 },
	{ 1227,	 150 },
	{ 1250,	 140 },
	{ 1274,	 130 },
	{ 1297,	 120 },
	{ 1320,	 110 },
	{ 1343,	 100 },
	{ 1366,	  90 },
	{ 1388,	  80 },
	{ 1410,	  70 },
	{ 1432,	  60 },
	{ 1454,	  50 },
	{ 1475,	  40 },
	{ 1496,	  30 },
	{ 1516,	  20 },
	{ 1536,	  10 },
	{ 1556,	   0 },
	{ 1576,	 -10 },
	{ 1595,	 -20 },
	{ 1613,	 -30 },
	{ 1631,	 -40 },
	{ 1649,	 -50 },
	{ 1666,	 -60 },
	{ 1683,	 -70 },
	{ 1699,  -80 },
	{ 1714,  -90 },
	{ 1730, -100 },
	{ 1744, -110 },
	{ 1759, -120 },
	{ 1773, -130 },
	{ 1786, -140 },
	{ 1799, -150 },
	{ 1811, -160 },
	{ 1823, -170 },
	{ 1835, -180 },
	{ 1846, -190 },
	{ 1856, -200 },
};
#elif defined(CONFIG_MACH_C1)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  178,	 800 },
	{  186,	 790 },
	{  193,	 780 },
	{  198,	 770 },
	{  204,	 760 },
	{  210,	 750 },
	{  220,	 740 },
	{  226,	 730 },
	{  232,	 720 },
	{  247,	 710 },
	{  254,	 700 },
	{  261,	 690 },
	{  270,	 680 },
	{  278,	 670 },
	{  285,	 660 },
	{  292,	 650 },
	{  304,	 640 },
	{  319,	 630 },
	{  325,	 620 },
	{  331,	 610 },
	{  343,	 600 },
	{  354,	 590 },
	{  373,	 580 },
	{  387,	 570 },
	{  392,	 560 },
	{  408,	 550 },
	{  422,	 540 },
	{  433,	 530 },
	{  452,	 520 },
	{  466,	 510 },
	{  479,	 500 },
	{  497,	 490 },
	{  510,	 480 },
	{  529,	 470 },
	{  545,	 460 },
	{  562,	 450 },
	{  578,	 440 },
	{  594,	 430 },
	{  620,	 420 },
	{  632,	 410 },
	{  651,	 400 },
	{  663,	 390 },
	{  681,	 380 },
	{  705,	 370 },
	{  727,	 360 },
	{  736,	 350 },
	{  778,	 340 },
	{  793,	 330 },
	{  820,	 320 },
	{  834,	 310 },
	{  859,	 300 },
	{  872,	 290 },
	{  891,	 280 },
	{  914,	 270 },
	{  939,	 260 },
	{  951,	 250 },
	{  967,	 240 },
	{  999,	 230 },
	{ 1031,	 220 },
	{ 1049,	 210 },
	{ 1073,	 200 },
	{ 1097,	 190 },
	{ 1128,	 180 },
	{ 1140,	 170 },
	{ 1171,	 160 },
	{ 1188,	 150 },
	{ 1198,	 140 },
	{ 1223,	 130 },
	{ 1236,	 120 },
	{ 1274,	 110 },
	{ 1290,	 100 },
	{ 1312,	  90 },
	{ 1321,	  80 },
	{ 1353,	  70 },
	{ 1363,	  60 },
	{ 1404,	  50 },
	{ 1413,	  40 },
	{ 1444,	  30 },
	{ 1461,	  20 },
	{ 1470,	  10 },
	{ 1516,	   0 },
	{ 1522,	 -10 },
	{ 1533,	 -20 },
	{ 1540,	 -30 },
	{ 1558,	 -40 },
	{ 1581,	 -50 },
	{ 1595,	 -60 },
	{ 1607,	 -70 },
	{ 1614,  -80 },
	{ 1627,  -90 },
	{ 1655, -100 },
	{ 1664, -110 },
	{ 1670, -120 },
	{ 1676, -130 },
	{ 1692, -140 },
	{ 1713, -150 },
	{ 1734, -160 },
	{ 1746, -170 },
	{ 1789, -180 },
	{ 1805, -190 },
	{ 1824, -200 },
};
#elif defined(CONFIG_MACH_GC1)/*Sample # 3*/
#if defined(CONFIG_MACH_GC1_USA_ATT)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 250,	700 },
	{ 254,	690 },
	{ 258,	680 },
	{ 262,	670 },
	{ 266,	660 },
	{ 270,	650 },
	{ 276,	640 },
	{ 282,	630 },
	{ 288,	620 },
	{ 294,	610 },
	{ 300,	600 },
	{ 302,	590 },
	{ 304,	580 },
	{ 306,	570 },
	{ 308,	560 },
	{ 400,	550 },
	{ 414,	540 },
	{ 428,	530 },
	{ 442,	520 },
	{ 456,	510 },
	{ 470,	500 },
	{ 486,	490 },
	{ 502,	480 },
	{ 518,	470 },
	{ 534,	460 },
	{ 550,	450 },
	{ 566,	440 },
	{ 582,	430 },
	{ 598,	420 },
	{ 614,	410 },
	{ 630,	400 },
	{ 650,	390 },
	{ 670,	380 },
	{ 690,	370 },
	{ 710,	360 },
	{ 730,	350 },
	{ 750,	340 },
	{ 770,	330 },
	{ 790,	320 },
	{ 810,	310 },
	{ 830,	300 },
	{ 854,	290 },
	{ 878,	280 },
	{ 902,	270 },
	{ 926,	260 },
	{ 950,	250 },
	{ 970,	240 },
	{ 990,	230 },
	{ 1010,	220 },
	{ 1030,	210 },
	{ 1050,	200 },
	{ 1078,	190 },
	{ 1106,	180 },
	{ 1134,	170 },
	{ 1162,	160 },
	{ 1190,	150 },
	{ 1214,	140 },
	{ 1238,	130 },
	{ 1262,	120 },
	{ 1286,	110 },
	{ 1310,	100 },
	{ 1328,	90 },
	{ 1346,	80 },
	{ 1364,	70 },
	{ 1382,	60 },
	{ 1400,	50 },
	{ 1425,	40 },
	{ 1450,	30 },
	{ 1475,	20 },
	{ 1500,	10 },
	{ 1525,	0 },
	{ 1544,	-10 },
	{ 1563,	-20 },
	{ 1582,	-30 },
	{ 1601,	-40 },
	{ 1620,	-50 },
	{ 1634,	-60 },
	{ 1648,	-70 },
	{ 1662,	-80 },
	{ 1676,	-90 },
	{ 1690,	-100 },
};
#elif defined(CONFIG_TARGET_LOCALE_KOR)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  250,	 650 },
	{  259,	 640 },
	{  270,	 630 },
	{  279,	 620 },
	{  297,	 610 },
	{  312,	 600 },
	{  324,	 590 },
	{  336,	 580 },
	{  344,	 570 },
	{  358,	 560 },
	{  369,	 550 },
	{  378,	 540 },
	{  390,	 530 },
	{  405,	 520 },
	{  419,	 510 },
	{  433,	 500 },
	{  447,	 490 },
	{  464,	 480 },
	{  471,	 470 },
	{  485,	 460 },
	{  510,	 450 },
	{  515,	 440 },
	{  537,	 430 },
	{  552,	 420 },
	{  577,	 410 },
	{  591,	 400 },
	{  606,	 390 },
	{  621,	 380 },
	{  655,	 370 },
	{  677,	 360 },
	{  711,	 350 },
	{  727,	 340 },
	{  730,	 330 },
	{  755,	 320 },
	{  795,	 310 },
	{  819,	 300 },
	{  832,	 290 },
	{  855,	 280 },
	{  883,	 270 },
	{  895,	 260 },
	{  939,	 250 },
	{  946,	 240 },
	{  958,	 230 },
	{ 986,	 220 },
	{ 1023,	 210 },
	{ 1055,	 200 },
	{ 1065,	 190 },
	{ 1118,	 180 },
	{ 1147,	 170 },
	{ 1171,	 160 },
	{ 1190,	 150 },
	{ 1220,	 140 },
	{ 1224,	 130 },
	{ 1251,	 120 },
	{ 1271,	 110 },
	{ 1316,	 100 },
	{ 1325,	  90 },
	{ 1333,	  80 },
	{ 1365,	  70 },
	{ 1382,	  60 },
	{ 1404,	  50 },
	{ 1445,	  40 },
	{ 1461,	  30 },
	{ 1469,	  20 },
	{ 1492,	  10 },
	{ 1518,	   0 },
	{ 1552,	 -10 },
	{ 1560,	 -20 },
	{ 1588,	 -30 },
	{ 1592,	 -40 },
	{ 1613,	 -50 },
	{ 1632,	 -60 },
	{ 1647,	 -70 },
	{ 1661,	-80 },
	{ 1685,	-90 },
	{ 1692,	-100 },
};
#elif defined(CONFIG_MACH_GC1_USA_VZW)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 240, 700 },
	{ 248, 690 },
	{ 256, 680 },
	{ 264, 670 },
	{ 272, 660 },
	{ 280, 650 },
	{ 292, 640 },
	{ 304, 630 },
	{ 317, 620 },
	{ 330, 610 },
	{ 341, 600 },
	{ 352, 590 },
	{ 364, 580 },
	{ 376, 570 },
	{ 388, 560 },
	{ 400, 550 },
	{ 414, 540 },
	{ 428, 530 },
	{ 442, 520 },
	{ 456, 510 },
	{ 470, 500 },
	{ 487, 490 },
	{ 504, 480 },
	{ 520, 470 },
	{ 540, 460 },
	{ 560, 450 },
	{ 566, 440 },
	{ 572, 430 },
	{ 578, 420 },
	{ 584, 410 },
	{ 590, 400 },
	{ 628, 390 },
	{ 666, 380 },
	{ 704, 370 },
	{ 742, 360 },
	{ 780, 350 },
	{ 798, 340 },
	{ 816, 330 },
	{ 834, 320 },
	{ 852, 310 },
	{ 870, 300 },
	{ 894, 290 },
	{ 918, 280 },
	{ 942, 270 },
	{ 966, 260 },
	{ 990, 250 },
	{ 1028, 240 },
	{ 1066, 230 },
	{ 1104, 220 },
	{ 1142, 210 },
	{ 1180, 200 },
	{ 1202, 190 },
	{ 1224, 180 },
	{ 1246, 170 },
	{ 1268, 160 },
	{ 1290, 150 },
	{ 1316, 140 },
	{ 1342, 130 },
	{ 1368, 120 },
	{ 1394, 110 },
	{ 1420, 100 },
	{ 1430, 90 },
	{ 1440, 80 },
	{ 1450, 70 },
	{ 1460, 60 },
	{ 1470, 50 },
	{ 1477, 40 },
	{ 1484, 30 },
	{ 1492, 20 },
	{ 1500, 15 },
	{ 1523, 0 },
	{ 1546, -10 },
	{ 1569, -20 },
	{ 1592, -30 },
	{ 1616, -40 },
	{ 1640, -49 },
	{ 1648, -60 },
	{ 1656, -70 },
	{ 1664, -80 },
	{ 1672, -90 },
	{ 1680, -100 },
};
#else/*EUR*/
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  250,	 700 },
	{  259,	 690 },
	{  270,	 680 },
	{  279,	 670 },
	{  289,	 660 },
	{  297,	 650 },
	{  312,	 640 },
	{  314,	 630 },
	{  324,	 620 },
	{  336,	 610 },
	{  344,	 600 },
	{  358,	 590 },
	{  369,	 580 },
	{  378,	 570 },
	{  390,	 560 },
	{  405,	 550 },
	{  419,	 540 },
	{  433,	 530 },
	{  447,	 520 },
	{  464,	 510 },
	{  471,	 500 },
	{  485,	 490 },
	{  510,	 480 },
	{  515,	 470 },
	{  537,	 460 },
	{  552,	 450 },
	{  577,	 440 },
	{  591,	 430 },
	{  606,	 420 },
	{  621,	 410 },
	{  636,	 400 },
	{  655,	 390 },
	{  677,	 380 },
	{  711,	 370 },
	{  727,	 360 },
	{  730,	 350 },
	{  755,	 340 },
	{  776,	 330 },
	{  795,	 320 },
	{  819,	 310 },
	{  832,	 300 },
	{  855,	 290 },
	{  883,	 280 },
	{  895,	 270 },
	{  939,	 260 },
	{  946,	 250 },
	{  958,	 240 },
	{  974,	 230 },
	{ 986,	 220 },
	{ 1023,	 210 },
	{ 1055,	 200 },
	{ 1065,	 190 },
	{ 1118,	 180 },
	{ 1147,	 170 },
	{ 1171,	 160 },
	{ 1190,	 150 },
	{ 1220,	 140 },
	{ 1224,	 130 },
	{ 1251,	 120 },
	{ 1271,	 110 },
	{ 1316,	 100 },
	{ 1325,	  90 },
	{ 1333,	  80 },
	{ 1365,	  70 },
	{ 1382,	  60 },
	{ 1404,	  50 },
	{ 1445,	  40 },
	{ 1461,	  30 },
	{ 1469,	  20 },
	{ 1492,	  10 },
	{ 1518,	   0 },
	{ 1552,	 -10 },
	{ 1560,	 -20 },
	{ 1588,	 -30 },
	{ 1592,	 -40 },
	{ 1613,	 -50 },
	{ 1632,	 -60 },
	{ 1647,	 -70 },
	{ 1661,	-80 },
	{ 1685,	-90 },
	{ 1692,	-100 },
};
#endif
#elif defined(CONFIG_MACH_M3)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  264,  700 },
	{  293,  670 },
	{  315,  650 },
	{  338,  630 },
	{  348,  620 },
	{  371,  600 },
	{  436,  550 },
	{  509,  500 },
	{  599,  450 },
	{  629,  430 },
	{  651,  420 },
	{  692,  400 },
	{  790,  350 },
	{  909,  300 },
	{ 1027,  250 },
	{ 1141,  200 },
	{ 1246,  150 },
	{ 1364,  100 },
	{ 1460,   50 },
	{ 1573,    0 },
	{ 1614,  -30 },
	{ 1650,  -50 },
	{ 1735, -100 },
	{ 1800, -150 },
	{ 1857, -200 },
	{ 1910, -250 },
	{ 1970, -300 },
};
#elif defined(CONFIG_MACH_T0)
#if defined(CONFIG_TARGET_LOCALE_KOR)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  200,	 800 },
	{  207,	 790 },
	{  214,	 780 },
	{  221,	 770 },
	{  228,	 760 },
	{  235,	 750 },
	{  248,	 740 },
	{  260,	 730 },
	{  273,	 720 },
	{  286,	 710 },
	{  299,	 700 },
	{  310,	 690 },
	{  321,	 680 },
	{  332,	 670 },
	{  345,	 660 },
	{  355,	 650 },
	{  370,	 640 },
	{  381,	 630 },
	{  393,	 620 },
	{  406,	 610 },
	{  423,	 600 },
	{  435,	 590 },
	{  448,	 580 },
	{  460,	 570 },
	{  473,	 560 },
	{  485,	 550 },
	{  498,	 540 },
	{  511,	 530 },
	{  524,	 520 },
	{  537,	 510 },
	{  550,	 500 },
	{  566,	 490 },
	{  582,	 480 },
	{  598,	 470 },
	{  614,	 460 },
	{  630,	 450 },
	{  649,	 440 },
	{  668,	 430 },
	{  687,	 420 },
	{  706,	 410 },
	{  725,	 400 },
	{  744,	 390 },
	{  763,	 380 },
	{  782,	 370 },
	{  801,	 360 },
	{  820,	 350 },
	{  841,	 340 },
	{  862,	 330 },
	{  883,	 320 },
	{  904,	 310 },
	{  925,	 300 },
	{  946,	 290 },
	{  967,	 280 },
	{  988,	 270 },
	{ 1009,	 260 },
	{ 1030,	 250 },
	{ 1050,	 240 },
	{ 1070,	 230 },
	{ 1090,	 220 },
	{ 1110,	 210 },
	{ 1130,	 200 },
	{ 1154,	 190 },
	{ 1178,	 180 },
	{ 1202,	 170 },
	{ 1226,	 160 },
	{ 1250,	 150 },
	{ 1272,	 140 },
	{ 1294,	 130 },
	{ 1315,	 120 },
	{ 1337,	 110 },
	{ 1359,	 100 },
	{ 1381,	  90 },
	{ 1403,	  80 },
	{ 1424,	  70 },
	{ 1446,	  60 },
	{ 1468,	  50 },
	{ 1489,	  40 },
	{ 1510,	  30 },
	{ 1532,	  20 },
	{ 1553,	  10 },
	{ 1574,	   0 },
	{ 1591,	 -10 },
	{ 1609,	 -20 },
	{ 1626,	 -30 },
	{ 1644,	 -40 },
	{ 1661,	 -50 },
	{ 1676,	 -60 },
	{ 1691,	 -70 },
	{ 1707,  -80 },
	{ 1722,  -90 },
	{ 1737, -100 },
	{ 1749, -110 },
	{ 1760, -120 },
	{ 1772, -130 },
	{ 1783, -140 },
	{ 1795, -150 },
	{ 1803, -160 },
	{ 1811, -170 },
	{ 1819, -180 },
	{ 1827, -190 },
	{ 1836, -200 },
};
#elif defined(CONFIG_MACH_T0_EUR_LTE) || defined(CONFIG_MACH_T0_USA_ATT)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 332,	 650 },
	{ 389,	 600 },
	{ 460,	 550 },
	{ 530,	 500 },
	{ 617,	 450 },
	{ 735,	 400 },
	{ 803,	 350 },
	{ 913,	 300 },
	{ 992,	 250 },
	{ 1126,	 200 },
	{ 1265,	 150 },
	{ 1370,	 100 },
	{ 1475,	  50 },
	{ 1530,	   0 },
	{ 1635,  -50 },
	{ 1724, -100 },
	{ 1803, -150 },
	{ 1855, -200 },
};
#elif defined(CONFIG_MACH_T0_USA_VZW) || defined(CONFIG_MACH_T0_USA_SPR) || \
	defined(CONFIG_MACH_T0_USA_USCC)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 193,	 800 },
	{ 222,	 750 },
	{ 272,	 700 },
	{ 320,	 650 },
	{ 379,	 600 },
	{ 439,	 550 },
	{ 519,	 500 },
	{ 555,	 480 },
	{ 605,	 450 },
	{ 698,	 400 },
	{ 802,	 350 },
	{ 906,	 300 },
	{ 1016,	 250 },
	{ 1127,	 200 },
	{ 1247,	 150 },
	{ 1360,	 100 },
	{ 1467,	  50 },
	{ 1567,	   0 },
	{ 1633,  -50 },
	{ 1725,	-100 },
	{ 1790,	-150 },
	{ 1839,	-200 },
	{ 1903,	-250 },
};
#elif defined(CONFIG_MACH_T0_CHN_CTC)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  200,  800 },
	{  207,  790 },
	{  214,  780 },
	{  221,  770 },
	{  228,  760 },
	{  235,  750 },
	{  248,  740 },
	{  260,  730 },
	{  273,  720 },
	{  286,  710 },
	{  299,  700 },
	{  310,  690 },
	{  321,  680 },
	{  332,  670 },
	{  345,  660 },
	{  353,  650 },
	{  358,  640 },
	{  363,  630 },
	{  370,  620 },
	{  375,  610 },
	{  381,  600 },
	{  393,  590 },
	{  423,  580 },
	{  435,  570 },
	{  448,  560 },
	{  460,  550 },
	{  473,  540 },
	{  485,  530 },
	{  511,  520 },
	{  524,  510 },
	{  537,  500 },
	{  550,  490 },
	{  566,  480 },
	{  582,  470 },
	{  598,  460 },
	{  620,  450 },
	{  649,  440 },
	{  668,  430 },
	{  687,  420 },
	{  706,  410 },
	{  725,  400 },
	{  744,  390 },
	{  763,  380 },
	{  782,  370 },
	{  801,  360 },
	{  820,  350 },
	{  841,  340 },
	{  862,  330 },
	{  883,  320 },
	{  904,  310 },
	{  925,  300 },
	{  946,  290 },
	{  967,  280 },
	{  988,  270 },
	{ 1009,  260 },
	{ 1030,  250 },
	{ 1050,  240 },
	{ 1070,  230 },
	{ 1090,  220 },
	{ 1110,  210 },
	{ 1130,  200 },
	{ 1154,  190 },
	{ 1178,  180 },
	{ 1202,  170 },
	{ 1226,  160 },
	{ 1250,  150 },
	{ 1272,  140 },
	{ 1294,  130 },
	{ 1315,  120 },
	{ 1337,  110 },
	{ 1359,  100 },
	{ 1381,   90 },
	{ 1403,   80 },
	{ 1424,   70 },
	{ 1446,   60 },
	{ 1468,   50 },
	{ 1489,   40 },
	{ 1510,   30 },
	{ 1532,   20 },
	{ 1553,   10 },
	{ 1574,    0 },
	{ 1591,  -10 },
	{ 1609,  -20 },
	{ 1626,  -30 },
	{ 1644,  -40 },
	{ 1661,  -50 },
	{ 1676,  -60 },
	{ 1691,  -70 },
	{ 1707,  -80 },
	{ 1722,  -90 },
	{ 1737, -100 },
	{ 1749, -110 },
	{ 1760, -120 },
	{ 1772, -130 },
	{ 1783, -140 },
	{ 1795, -150 },
	{ 1803, -160 },
	{ 1811, -170 },
	{ 1819, -180 },
	{ 1827, -190 },
	{ 1836, -200 },
};
#elif defined(CONFIG_MACH_T0_CHN_OPEN_DUOS)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 358,   600 },
	{ 500,   500 },
	{ 600,   400 },
	{ 794,   300 },
	{ 1132,  200 },
	{ 1363,  100 },
	{ 1574,    0 },
	{ 1732, -100 },
	{ 1860, -200 },
};
#else	/* T0 3G(default) */
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 358,   600 },
	{ 500,   500 },
	{ 698,   400 },
	{ 898,   300 },
	{ 1132,  200 },
	{ 1363,  100 },
	{ 1574,    0 },
	{ 1732, -100 },
	{ 1860, -200 },
};
#endif
#elif defined(CONFIG_MACH_BAFFIN_KOR_SKT) || \
	defined(CONFIG_MACH_BAFFIN_KOR_KT) || \
	defined(CONFIG_MACH_BAFFIN_KOR_LGT)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  170,  800 },
	{  176,  790 },
	{  183,  780 },
	{  189,  770 },
	{  195,  760 },
	{  202,  750 },
	{  210,  740 },
	{  217,  730 },
	{  225,  720 },
	{  232,  710 },
	{  240,  700 },
	{  247,  690 },
	{  255,  680 },
	{  262,  670 },
	{  269,  660 },
	{  276,  650 },
	{  279,  640 },
	{  303,  630 },
	{  320,  620 },
	{  330,  610 },
	{  340,  600 },
	{  354,  590 },
	{  363,  580 },
	{  373,  570 },
	{  382,  560 },
	{  390,  550 },
	{  405,  540 },
	{  418,  530 },
	{  433,  520 },
	{  448,  510 },
	{  465,  500 },
	{  483,  490 },
	{  500,  480 },
	{  512,  470 },
	{  523,  460 },
	{  535,  450 },
	{  550,  440 },
	{  580,  430 },
	{  585,  420 },
	{  605,  410 },
	{  635,  400 },
	{  648,  390 },
	{  665,  380 },
	{  682,  370 },
	{  706,  360 },
	{  723,  350 },
	{  748,  340 },
	{  773,  330 },
	{  795,  320 },
	{  807,  310 },
	{  820,  300 },
	{  835,  290 },
	{  855,  280 },
	{  878,  270 },
	{  899,  260 },
	{  920,  250 },
	{  937,  240 },
	{  962,  230 },
	{  992,  220 },
	{ 1025,  210 },
	{ 1050,  200 },
	{ 1074,  190 },
	{ 1102,  180 },
	{ 1121,  170 },
	{ 1150,  160 },
	{ 1176,  150 },
	{ 1192,  140 },
	{ 1230,  130 },
	{ 1248,  120 },
	{ 1284,  110 },
	{ 1305,  100 },
	{ 1322,   90 },
	{ 1333,   80 },
	{ 1360,   70 },
	{ 1375,   60 },
	{ 1410,   50 },
	{ 1420,   40 },
	{ 1454,   30 },
	{ 1478,   20 },
	{ 1495,   10 },
	{ 1515,    0 },
	{ 1532,  -10 },
	{ 1543,  -20 },
	{ 1560,  -30 },
	{ 1580,  -40 },
	{ 1605,  -50 },
	{ 1635,  -60 },
	{ 1648,  -70 },
	{ 1657,  -80 },
	{ 1667,  -90 },
	{ 1685, -100 },
	{ 1697, -110 },
	{ 1705, -120 },
	{ 1716, -130 },
	{ 1735, -140 },
	{ 1760, -150 },
	{ 1772, -160 },
	{ 1785, -170 },
	{ 1798, -180 },
	{ 1810, -190 },
	{ 1824, -200 },
};
#elif defined(CONFIG_MACH_SUPERIOR_KOR_SKT)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{  149,  800 },
	{  154,  790 },
	{  159,  780 },
	{  164,  770 },
	{  169,  760 },
	{  174,  750 },
	{  181,  740 },
	{  188,  730 },
	{  195,  720 },
	{  202,  710 },
	{  209,  700 },
	{  217,  690 },
	{  225,  680 },
	{  233,  670 },
	{  241,  660 },
	{  249,  650 },
	{  258,  640 },
	{  268,  630 },
	{  277,  620 },
	{  287,  610 },
	{  296,  600 },
	{  307,  590 },
	{  317,  580 },
	{  328,  570 },
	{  338,  560 },
	{  349,  550 },
	{  361,  540 },
	{  374,  530 },
	{  386,  520 },
	{  399,  510 },
	{  411,  500 },
	{  426,  490 },
	{  441,  480 },
	{  455,  470 },
	{  470,  460 },
	{  485,  450 },
	{  501,  440 },
	{  517,  430 },
	{  532,  420 },
	{  548,  410 },
	{  564,  400 },
	{  583,  390 },
	{  601,  380 },
	{  620,  370 },
	{  638,  360 },
	{  657,  350 },
	{  677,  340 },
	{  697,  330 },
	{  717,  320 },
	{  737,  310 },
	{  757,  300 },
	{  781,  290 },
	{  804,  280 },
	{  828,  270 },
	{  851,  260 },
	{  875,  250 },
	{  898,  240 },
	{  920,  230 },
	{  943,  220 },
	{  965,  210 },
	{  988,  200 },
	{ 1013,  190 },
	{ 1038,  180 },
	{ 1063,  170 },
	{ 1088,  160 },
	{ 1113,  150 },
	{ 1137,  140 },
	{ 1162,  130 },
	{ 1186,  120 },
	{ 1211,  110 },
	{ 1235,  100 },
	{ 1260,   90 },
	{ 1286,   80 },
	{ 1311,   70 },
	{ 1337,   60 },
	{ 1362,   50 },
	{ 1383,   40 },
	{ 1404,   30 },
	{ 1426,   20 },
	{ 1447,   10 },
	{ 1468,    0 },
	{ 1488,  -10 },
	{ 1508,  -20 },
	{ 1527,  -30 },
	{ 1547,  -40 },
	{ 1567,  -50 },
	{ 1585,  -60 },
	{ 1603,  -70 },
	{ 1621,  -80 },
	{ 1639,  -90 },
	{ 1657, -100 },
	{ 1674, -110 },
	{ 1690, -120 },
	{ 1707, -130 },
	{ 1723, -140 },
	{ 1740, -150 },
	{ 1755, -160 },
	{ 1769, -170 },
	{ 1784, -180 },
	{ 1798, -190 },
	{ 1813, -200 },
};
#elif defined(CONFIG_MACH_GD2)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 178,	800 },
	{ 184,	790 },
	{ 191,	780 },
	{ 198,	770 },
	{ 205,	760 },
	{ 212,	750 },
	{ 219,	740 },
	{ 226,	730 },
	{ 233,	720 },
	{ 240,	710 },
	{ 247,	700 },
	{ 256,	690 },
	{ 265,	680 },
	{ 274,	670 },
	{ 283,	660 },
	{ 293,	650 },
	{ 304,	640 },
	{ 315,	630 },
	{ 326,	620 },
	{ 336,	610 },
	{ 346,	600 },
	{ 358,	590 },
	{ 371,	580 },
	{ 384,	570 },
	{ 397,	560 },
	{ 410,	550 },
	{ 424,	540 },
	{ 439,	530 },
	{ 454,	520 },
	{ 469,	510 },
	{ 484,	500 },
	{ 497,	490 },
	{ 510,	480 },
	{ 524,	470 },
	{ 538,	460 },
	{ 552,	450 },
	{ 570,	440 },
	{ 588,	430 },
	{ 605,	420 },
	{ 622,	410 },
	{ 639,	400 },
	{ 653,	390 },
	{ 667,	380 },
	{ 680,	370 },
	{ 693,	360 },
	{ 706,	350 },
	{ 728,	340 },
	{ 749,	330 },
	{ 770,	320 },
	{ 791,	310 },
	{ 812,	300 },
	{ 830,	290 },
	{ 848,	280 },
	{ 867,	270 },
	{ 886,	260 },
	{ 905,	250 },
	{ 928,	240 },
	{ 952,	230 },
	{ 976,	220 },
	{ 1000,	210 },
	{ 1024,	200 },
	{ 1044,	190 },
	{ 1064,	180 },
	{ 1084,	170 },
	{ 1104,	160 },
	{ 1124,	150 },
	{ 1154,	140 },
	{ 1183,	130 },
	{ 1212,	120 },
	{ 1241,	110 },
	{ 1270,	100 },
	{ 1291,	90 },
	{ 1312,	80 },
	{ 1334,	70 },
	{ 1356,	60 },
	{ 1378,	50 },
	{ 1395,	40 },
	{ 1413,	30 },
	{ 1431,	20 },
	{ 1449,	10 },
	{ 1467,	0 },
	{ 1485,	-10 },
	{ 1503,	-20 },
	{ 1521,	-30 },
	{ 1539,	-40 },
	{ 1557,	-50 },
	{ 1575,	-60 },
	{ 1594,	-70 },
	{ 1613,	-80 },
	{ 1632,	-90 },
	{ 1651,	-100 },
	{ 1669,	-110 },
	{ 1687,	-120 },
	{ 1705,	-130 },
	{ 1723,	-140 },
	{ 1741,	-150 },
	{ 1762,	-160 },
	{ 1784,	-170 },
	{ 1806,	-180 },
	{ 1828,	-190 },
	{ 1850,	-200 },
};
#elif defined(CONFIG_MACH_ZEST)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 210, 800 },
	{ 216, 790 },
	{ 222, 780 },
	{ 228, 770 },
	{ 235, 760 },
	{ 242, 750 },
	{ 250, 740 },
	{ 258, 730 },
	{ 266, 720 },
	{ 274, 710 },
	{ 283, 700 },
	{ 292, 690 },
	{ 302, 680 },
	{ 312, 670 },
	{ 322, 660 },
	{ 332, 650 },
	{ 342, 640 },
	{ 353, 630 },
	{ 364, 620 },
	{ 376, 610 },
	{ 388, 600 },
	{ 400, 590 },
	{ 412, 580 },
	{ 424, 570 },
	{ 436, 560 },
	{ 448, 550 },
	{ 461, 540 },
	{ 474, 530 },
	{ 489, 520 },
	{ 504, 510 },
	{ 521, 500 },
	{ 538, 490 },
	{ 554, 480 },
	{ 570, 470 },
	{ 586, 460 },
	{ 603, 450 },
	{ 622, 440 },
	{ 641, 430 },
	{ 661, 420 },
	{ 680, 410 },
	{ 700, 400 },
	{ 720, 390 },
	{ 740, 380 },
	{ 760, 370 },
	{ 780, 360 },
	{ 800, 350 },
	{ 820, 340 },
	{ 841, 330 },
	{ 862, 320 },
	{ 883, 310 },
	{ 905, 300 },
	{ 927, 290 },
	{ 949, 280 },
	{ 972, 270 },
	{ 994, 260 },
	{ 1017, 250 },
	{ 1040, 240 },
	{ 1064, 230 },
	{ 1087, 220 },
	{ 1111, 210 },
	{ 1134, 200 },
	{ 1158, 190 },
	{ 1181, 180 },
	{ 1205, 170 },
	{ 1228, 160 },
	{ 1252, 150 },
	{ 1276, 140 },
	{ 1299, 130 },
	{ 1322, 120 },
	{ 1344, 110 },
	{ 1366, 100 },
	{ 1388, 90 },
	{ 1410, 80 },
	{ 1431, 70 },
	{ 1452, 60 },
	{ 1473, 50 },
	{ 1493, 40 },
	{ 1513, 30 },
	{ 1533, 20 },
	{ 1553, 10 },
	{ 1573, 0 },
	{ 1593, -10 },
	{ 1612, -20 },
	{ 1631, -30 },
	{ 1647, -40 },
	{ 1664, -50 },
	{ 1681, -60 },
	{ 1697, -70 },
	{ 1713, -80 },
	{ 1729, -90 },
	{ 1745, -100 },
	{ 1759, -110 },
	{ 1773, -120 },
	{ 1786, -130 },
	{ 1799, -140 },
	{ 1811, -150 },
	{ 1823, -160 },
	{ 1834, -170 },
	{ 1845, -180 },
	{ 1855, -190 },
	{ 1865, -200 },
};
#elif defined(CONFIG_MACH_GC2PD)
#if defined(CONFIG_GC2PD_LTE) && !defined(CONFIG_TARGET_LOCALE_USA)
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 173, 800 },
	{ 179, 790 },
	{ 185, 780 },
	{ 191, 770 },
	{ 197, 760 },
	{ 203, 750 },
	{ 211, 740 },
	{ 218, 730 },
	{ 225, 720 },
	{ 232, 710 },
	{ 239, 700 },
	{ 248, 690 },
	{ 258, 680 },
	{ 268, 670 },
	{ 278, 660 },
	{ 288, 650 },
	{ 297, 640 },
	{ 306, 630 },
	{ 315, 620 },
	{ 324, 610 },
	{ 333, 600 },
	{ 345, 590 },
	{ 357, 580 },
	{ 370, 570 },
	{ 383, 560 },
	{ 396, 550 },
	{ 409, 540 },
	{ 423, 530 },
	{ 437, 520 },
	{ 451, 510 },
	{ 465, 500 },
	{ 477, 490 },
	{ 489, 480 },
	{ 501, 470 },
	{ 513, 460 },
	{ 525, 450 },
	{ 556, 440 },
	{ 586, 430 },
	{ 616, 420 },
	{ 646, 410 },
	{ 676, 400 },
	{ 691, 390 },
	{ 706, 380 },
	{ 721, 370 },
	{ 736, 360 },
	{ 751, 350 },
	{ 777, 340 },
	{ 803, 330 },
	{ 828, 320 },
	{ 853, 310 },
	{ 878, 300 },
	{ 894, 290 },
	{ 910, 280 },
	{ 926, 270 },
	{ 942, 260 },
	{ 958, 250 },
	{ 985, 240 },
	{ 1013, 230 },
	{ 1041, 220 },
	{ 1069, 210 },
	{ 1097, 200 },
	{ 1124, 190 },
	{ 1150, 180 },
	{ 1176, 170 },
	{ 1202, 160 },
	{ 1228, 150 },
	{ 1248, 140 },
	{ 1268, 130 },
	{ 1287, 120 },
	{ 1306, 110 },
	{ 1325, 100 },
	{ 1345, 90 },
	{ 1366, 80 },
	{ 1387, 70 },
	{ 1408, 60 },
	{ 1429, 50 },
	{ 1457, 40 },
	{ 1484, 30 },
	{ 1511, 20 },
	{ 1538, 10 },
	{ 1565, 0 },
	{ 1582, -10 },
	{ 1599, -20 },
	{ 1615, -30 },
	{ 1631, -40 },
	{ 1648, -50 },
	{ 1664, -60 },
	{ 1681, -70 },
	{ 1698, -80 },
	{ 1715, -90 },
	{ 1732, -100 },
	{ 1748, -110 },
	{ 1764, -120 },
	{ 1779, -130 },
	{ 1794, -140 },
	{ 1809, -150 },
	{ 1816, -160 },
	{ 1824, -170 },
	{ 1832, -180 },
	{ 1840, -190 },
	{ 1848, -200 },
};
#else/* 3G, LTE-ATT, */
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{	175,	800	},
	{	181,	790	},
	{	187,	780	},
	{	194,	770	},
	{	201,	760	},
	{	208,	750	},
	{	217,	740	},
	{	226,	730	},
	{	234,	720	},
	{	242,	710	},
	{	250,	700	},
	{	259,	690	},
	{	268,	680	},
	{	276,	670	},
	{	284,	660	},
	{	292,	650	},
	{	302,	640	},
	{	312,	630	},
	{	322,	620	},
	{	332,	610	},
	{	342,	600	},
	{	354,	590	},
	{	366,	580	},
	{	378,	570	},
	{	390,	560	},
	{	402,	550	},
	{	417,	540	},
	{	432,	530	},
	{	447,	520	},
	{	462,	510	},
	{	477,	500	},
	{	493,	490	},
	{	508,	480	},
	{	523,	470	},
	{	538,	460	},
	{	553,	450	},
	{	570,	440	},
	{	588,	430	},
	{	606,	420	},
	{	624,	410	},
	{	642,	400	},
	{	662,	390	},
	{	682,	380	},
	{	702,	370	},
	{	722,	360	},
	{	742,	350	},
	{	762,	340	},
	{	782,	330	},
	{	803,	320	},
	{	824,	310	},
	{	845,	300	},
	{	867,	290	},
	{	889,	280	},
	{	910,	270	},
	{	931,	260	},
	{	952,	250	},
	{	975,	240	},
	{	998,	230	},
	{	1021,	220	},
	{	1044,	210	},
	{	1067,	200	},
	{	1092,	190	},
	{	1116,	180	},
	{	1140,	170	},
	{	1164,	160	},
	{	1188,	150	},
	{	1210,	140	},
	{	1233,	130	},
	{	1256,	120	},
	{	1279,	110	},
	{	1302,	100	},
	{	1325,	90	},
	{	1348,	80	},
	{	1372,	70	},
	{	1396,	60	},
	{	1420,	50	},
	{	1442,	40	},
	{	1464,	30	},
	{	1487,	20	},
	{	1510,	10	},
	{	1533,	0	},
	{	1551,	-10	},
	{	1570,	-20	},
	{	1589,	-30	},
	{	1608,	-40	},
	{	1627,	-50	},
	{	1644,	-60	},
	{	1661,	-70	},
	{	1678,	-80	},
	{	1694,	-90	},
	{	1710,	-100	},
	{	1723,	-110	},
	{	1736,	-120	},
	{	1748,	-130	},
	{	1760,	-140	},
	{	1772,	-150	},
	{	1784,	-160	},
	{	1796,	-170	},
	{	1808,	-180	},
	{	1820,	-190	},
	{	1832,	-200	},
};
#endif
#else	/* sample */
static struct adc_table_data ap_adc_temper_table_battery[] = {
	{ 305,  650 },
	{ 566,  430 },
	{ 1494,   0 },
	{ 1571, -50 },
};
#endif

int convert_adc(int adc_data, int channel)
{
	int adc_value;
	int low, mid, high;
	struct adc_table_data *temper_table = NULL;
	pr_debug("%s\n", __func__);

	low = mid = high = 0;
	switch (channel) {
	case 1:
		temper_table = ap_adc_temper_table_battery;
		high = ARRAY_SIZE(ap_adc_temper_table_battery) - 1;
		break;
	case 2:
		temper_table = ap_adc_temper_table_battery;
		high = ARRAY_SIZE(ap_adc_temper_table_battery) - 1;
		break;
	default:
		pr_info("%s: not exist temper table for ch(%d)\n", __func__,
							channel);
		return -EINVAL;
		break;
	}

	/* Out of table range */
	if (adc_data <= temper_table[low].adc) {
		adc_value = temper_table[low].value;
		return adc_value;
	} else if (adc_data >= temper_table[high].adc) {
		adc_value = temper_table[high].value;
		return adc_value;
	}

	while (low <= high) {
		mid = (low + high) / 2;
		if (temper_table[mid].adc > adc_data)
			high = mid - 1;
		else if (temper_table[mid].adc < adc_data)
			low = mid + 1;
		else
			break;
	}
	adc_value = temper_table[mid].value;

	/* high resolution */
	if (adc_data < temper_table[mid].adc)
		adc_value = temper_table[mid].value +
			((temper_table[mid-1].value - temper_table[mid].value) *
			(temper_table[mid].adc - adc_data) /
			(temper_table[mid].adc - temper_table[mid-1].adc));
	else
		adc_value = temper_table[mid].value -
			((temper_table[mid].value - temper_table[mid+1].value) *
			(adc_data - temper_table[mid].adc) /
			(temper_table[mid+1].adc - temper_table[mid].adc));

	pr_debug("%s: adc data(%d), adc value(%d)\n", __func__,
					adc_data, adc_value);
	return adc_value;

}
#endif

#ifdef CONFIG_SEC_THERMISTOR
#if defined(CONFIG_MACH_GC1)
static struct sec_therm_adc_table temper_table_ap[] = {
	{241,	700},
	{260,	650},
	{301,	600},
	{351,	550},
	{367,	540},
	{383,	530},
	{399,	520},
	{415,	510},
	{431,	500},
	{442,	490},
	{454,	480},
	{465,	470},
	{477,	460},
	{488,	450},
	{508,	440},
	{528,	430},
	{548,	420},
	{568,	410},
	{587,	400},
	{604,	390},
	{622,	380},
	{639,	370},
	{657,	360},
	{674,	350},
	{696,	340},
	{718,	330},
	{740,	320},
	{762,	310},
	{784,	300},
};
#elif defined(CONFIG_MACH_KONA)
static struct sec_therm_adc_table temper_table_ap[] = {
	{	174,  800 },
	{	185,  790 },
	{	196,  780 },
	{	208,  770 },
	{	219,  760 },
	{	228,  750 },
	{	235,  740 },
	{	242,  730 },
	{	250,  720 },
	{	258,  710 },
	{	268,  700 },
	{	275,  690 },
	{	282,  680 },
	{	290,  670 },
	{	297,  660 },
	{	304,  650 },
	{	312,  640 },
	{	320,  630 },
	{	328,  620 },
	{	336,  610 },
	{	344,  600 },
	{	356,  590 },
	{	368,  580 },
	{	380,  570 },
	{	393,  560 },
	{	407,  550 },
	{	420,  540 },
	{	433,  530 },
	{	447,  520 },
	{	460,  510 },
	{	473,  500 },
	{	489,  490 },
	{	505,  480 },
	{	521,  470 },
	{	537,  460 },
	{	552,  450 },
	{	567,  440 },
	{	583,  430 },
	{	598,  420 },
	{	613,  410 },
	{	628,  400 },
	{	649,  390 },
	{	670,  380 },
	{	792,  370 },
	{	715,  360 },
	{	738,  350 },
	{	759,  340 },
	{	780,  330 },
	{	800,  320 },
	{	821,  310 },
	{	842,  300 },
	{	867,  290 },
	{	893,  280 },
	{	928,  270 },
	{	949,  260 },
	{	969,  250 },
	{	992,  240 },
	{ 1015,  230 },
	{ 1038,  220 },
	{ 1061,  210 },
	{ 1085,  200 },
	{ 1110,  190 },
	{ 1138,  180 },
	{ 1164,  170 },
	{ 1189,  160 },
	{ 1214,  150 },
	{ 1230,  140 },
	{ 1257,  130 },
	{ 1284,  120 },
	{ 1314,  110 },
	{ 1343,  100 },
	{ 1366,   90 },
	{ 1388,   80 },
	{ 1410,   70 },
	{ 1432,   60 },
	{ 1454,   50 },
	{ 1475,   40 },
	{ 1496,   30 },
	{ 1516,   20 },
	{ 1536,   10 },
	{ 1556,	0 },
	{ 1576,  -10 },
	{ 1595,  -20 },
	{ 1613,  -30 },
	{ 1631,  -40 },
	{ 1649,  -50 },
	{ 1666,  -60 },
	{ 1683,  -70 },
	{ 1699,  -80 },
	{ 1714,  -90 },
	{ 1730, -100 },
	{ 1744, -110 },
	{ 1759, -120 },
	{ 1773, -130 },
	{ 1786, -140 },
	{ 1799, -150 },
	{ 1811, -160 },
	{ 1823, -170 },
	{ 1835, -180 },
	{ 1846, -190 },
	{ 1856, -200 },
};
#elif defined(CONFIG_MACH_GC2PD)
static struct sec_therm_adc_table temper_table_ap[] = {
	{210,	750},
	{241,	700},
	{287,	650},
	{327,	600},
	{387,	550},
	{400,	540},
	{413,	530},
	{426,	520},
	{439,	510},
	{452,	500},
	{465,	490},
	{479,	480},
	{492,	470},
	{506,	460},
	{519,	450},
	{540,	440},
	{561,	430},
	{582,	420},
	{603,	410},
	{624,	400},
	{641,	390},
	{658,	380},
	{675,	370},
	{692,	360},
	{709,	350},
	{728,	340},
	{746,	330},
	{765,	320},
	{783,	310},
	{802,	300},
	{811,	250},
};
#elif defined(CONFIG_MACH_IPCAM)
static struct sec_therm_adc_table temper_table_ap[] = {
	{100,800},
	{125,750},
	{151,700},
	{184,650},
	{223,600},
	{264,550},
	{316,500},
	{371,450},
	{483,400},
	{536,350},
	{628,300},
	{695,250},
	{861,200},
	{945,150},
	{1067,100},
	{1184,50},
	{1345,0},
	{1400,-50},
	{1523, -100},
	{1587, -150},
};
#elif defined(CONFIG_MACH_GD2)
static struct sec_therm_adc_table temper_table_ap[] = {
	{260, 700},
	{273, 690},
	{287, 680},
	{300, 670},
	{314, 660},
	{327, 650},
	{340, 640},
	{353, 630},
	{365, 620},
	{378, 610},
	{391, 600},
	{399, 590},
	{407, 580},
	{416, 570},
	{424, 560},
	{432, 550},
	{439, 540},
	{446, 530},
	{454, 520},
	{461, 510},
	{468, 500},
	{492, 490},
	{515, 480},
	{539, 470},
	{562, 460},
	{586, 450},
	{596, 440},
	{607, 430},
	{617, 420},
	{628, 410},
	{638, 400},
	{658, 390},
	{677, 380},
	{697, 370},
	{716, 360},
	{736, 350},
	{750, 340},
	{764, 330},
	{777, 320},
	{791, 310},
	{805, 300},
};
#else
static struct sec_therm_adc_table temper_table_ap[] = {
	{196,	700},
	{211,	690},
	{242,	685},
	{249,	680},
	{262,	670},
	{275,	660},
	{288,	650},
	{301,	640},
	{314,	630},
	{328,	620},
	{341,	610},
	{354,	600},
	{366,	590},
	{377,	580},
	{389,	570},
	{404,	560},
	{419,	550},
	{434,	540},
	{452,	530},
	{469,	520},
	{487,	510},
	{498,	500},
	{509,	490},
	{520,	480},
	{529,	470},
	{538,	460},
	{547,	450},
	{556,	440},
	{564,	430},
	{573,	420},
	{581,	410},
	{590,	400},
	{615,	390},
	{640,	380},
	{665,	370},
	{690,	360},
	{715,	350},
	{736,	340},
	{758,	330},
	{779,	320},
	{801,	310},
	{822,	300},
};
#endif

/* when the next level is same as prev, returns -1 */
static int get_midas_siop_level(int temp)
{
	static int prev_temp = 400;
	static int prev_level = 0;
	int level = -1;

#if defined(CONFIG_MACH_C1_KOR_SKT) || defined(CONFIG_MACH_C1_KOR_KT) || \
	defined(CONFIG_MACH_C1_KOR_LGT)
	if (temp > prev_temp) {
		if (temp >= 540)
			level = 4;
		else if (temp >= 530)
			level = 3;
		else if (temp >= 480)
			level = 2;
		else if (temp >= 440)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 410)
			level = 0;
		else if (temp < 440)
			level = 1;
		else if (temp < 480)
			level = 2;
		else if (temp < 530)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}

	if (siopLevellimit != 0 && level > siopLevellimit)
		level = siopLevellimit;

#elif defined(CONFIG_MACH_P4NOTE) || defined(CONFIG_MACH_SP7160LTE) || defined(CONFIG_MACH_TAB3)
	if (temp > prev_temp) {
		if (temp >= 620)
			level = 4;
		else if (temp >= 610)
			level = 3;
		else if (temp >= 580)
			level = 2;
		else if (temp >= 550)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 520)
			level = 0;
		else if (temp < 550)
			level = 1;
		else if (temp < 580)
			level = 2;
		else if (temp < 610)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}
#elif defined(CONFIG_MACH_KONA)
	if (temp > prev_temp) {
		if (temp >= 720)
			level = 4;
		else if (temp >= 700)
			level = 3;
		else if (temp >= 680)
			level = 2;
		else if (temp >= 660)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 640)
			level = 0;
		else if (temp < 660)
			level = 1;
		else if (temp < 680)
			level = 2;
		else if (temp < 700)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}
#elif defined(CONFIG_MACH_T0)
	if (temp > prev_temp) {
		if (temp >= 620)
			level = 4;
		else if (temp >= 610)
			level = 3;
		else if (temp >= 570)
			level = 2;
		else if (temp >= 540)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 510)
			level = 0;
		else if (temp < 540)
			level = 1;
		else if (temp < 570)
			level = 2;
		else if (temp < 610)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}
#elif defined(CONFIG_MACH_GC1) || defined(CONFIG_MACH_GC2PD) || defined(CONFIG_MACH_IPCAM)
	if (temp > prev_temp) {
		if (temp >= 590)
			level = 4;
		else if (temp >= 580)
			level = 3;
		else if (temp >= 550)
			level = 2;
		else if (temp >= 520)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 480)
			level = 0;
		else if (temp < 520)
			level = 1;
		else if (temp < 550)
			level = 2;
		else if (temp < 580)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}

#elif defined(CONFIG_MACH_BAFFIN_KOR_SKT) || \
	defined(CONFIG_MACH_BAFFIN_KOR_KT)
	if (temp > prev_temp) {
		if (temp >= 560)
			level = 4;
		else if (temp >= 550)
			level = 3;
		else if (temp >= 530)
			level = 2;
		else if (temp >= 460)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 410)
			level = 0;
		else if (temp < 460)
			level = 1;
		else if (temp < 530)
			level = 2;
		else if (temp < 550)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}

	if (siopLevellimit != 0 && level > siopLevellimit)
		level = siopLevellimit;

#elif defined(CONFIG_MACH_BAFFIN_KOR_LGT)
	if (temp > prev_temp) {
		if (temp >= 550)
			level = 4;
		else if (temp >= 540)
			level = 3;
		else if (temp >= 510)
			level = 2;
		else if (temp >= 450)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 410)
			level = 0;
		else if (temp < 450)
			level = 1;
		else if (temp < 510)
			level = 2;
		else if (temp < 540)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}

	if (siopLevellimit != 0 && level > siopLevellimit)
		level = siopLevellimit;

#elif defined(CONFIG_MACH_SUPERIOR_KOR_SKT)
	if (temp > prev_temp) {
		if (temp >= 540)
			level = 4;
		else if (temp >= 530)
			level = 3;
		else if (temp >= 480)
			level = 2;
		else if (temp >= 440)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 410)
			level = 0;
		else if (temp < 440)
			level = 1;
		else if (temp < 480)
			level = 2;
		else if (temp < 530)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}

	if (siopLevellimit != 0 && level > siopLevellimit)
		level = siopLevellimit;
#elif defined(CONFIG_MACH_GD2)
	if (temp > prev_temp) {
		if (temp >= 620)
			level = 4;
		else if (temp >= 610)
			level = 3;
		else if (temp >= 570)
			level = 2;
		else if (temp >= 540)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 510)
			level = 0;
		else if (temp < 540)
			level = 1;
		else if (temp < 570)
			level = 2;
		else if (temp < 610)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}
#else
	if (temp > prev_temp) {
		if (temp >= 540)
			level = 4;
		else if (temp >= 530)
			level = 3;
		else if (temp >= 480)
			level = 2;
		else if (temp >= 440)
			level = 1;
		else
			level = 0;
	} else {
		if (temp < 410)
			level = 0;
		else if (temp < 440)
			level = 1;
		else if (temp < 480)
			level = 2;
		else if (temp < 530)
			level = 3;
		else
			level = 4;

		if (level > prev_level)
			level = prev_level;
	}
#endif

	prev_temp = temp;
	if (prev_level == level)
		return -1;

	prev_level = level;

	return level;
}

static struct sec_therm_platform_data sec_therm_pdata = {
	.adc_channel	= 1,
	.adc_arr_size	= ARRAY_SIZE(temper_table_ap),
	.adc_table	= temper_table_ap,
	.polling_interval = 30 * 1000, /* msecs */
	.get_siop_level = get_midas_siop_level,
};

struct platform_device sec_device_thermistor = {
	.name = "sec-thermistor",
	.id = -1,
	.dev.platform_data = &sec_therm_pdata,
};
#endif

#ifdef CONFIG_STMPE811_ADC
/* temperature table for ADC ch7 */
static struct adc_table_data temper_table_battery[] = {
	{	1856, -20	},
	{	1846, -19	},
	{	1835, -18	},
	{	1823, -17	},
	{	1811, -16	},
	{	1799, -15	},
	{	1786, -14	},
	{	1773, -13	},
	{	1759, -12	},
	{	1744, -11	},
	{	1730, -10	},
	{	1714, -9	},
	{	1699, -8	},
	{	1683, -7	},
	{	1666, -6	},
	{	1649, -5	},
	{	1631, -4	},
	{	1613, -3	},
	{	1595, -2	},
	{	1576, -1	},
	{	1556, 0		},
	{	1536, 1		},
	{	1516, 2		},
	{	1496, 3		},
	{	1475, 4		},
	{	1454, 5		},
	{	1432, 6		},
	{	1410, 7		},
	{	1388, 8		},
	{	1366, 9		},
	{	1343, 10	},
	{	1320, 11	},
	{	1297, 12	},
	{	1274, 13	},
	{	1250, 14	},
	{	1227, 15	},
	{	1204, 16	},
	{	1180, 17	},
	{	1156, 18	},
	{	1133, 19	},
	{	1109, 20	},
	{	1086, 21	},
	{	1062, 22	},
	{	1039, 23	},
	{	1015, 24	},
	{	992,  25	},
	{	969,  26	},
	{	947,  27	},
	{	924,  28	},
	{	902,  29	},
	{	880,  30	},
	{	858,  31	},
	{	836,  32	},
	{	815,  33	},
	{	794,  34	},
	{	773,  35	},
	{	753,  36	},
	{	733,  37	},
	{	713,  38	},
	{	694,  39	},
	{	675,  40	},
	{	657,  41	},
	{	638,  42	},
	{	621,  43	},
	{	603,  44	},
	{	586,  45	},
	{	569,  46	},
	{	553,  47	},
	{	537,  48	},
	{	522,  49	},
	{	507,  50	},
	{	492,  51	},
	{	477,  52	},
	{	463,  53	},
	{	450,  54	},
	{	436,  55	},
	{	423,  56	},
	{	411,  57	},
	{	399,  58	},
	{	387,  59	},
	{	375,  60	},
	{	364,  61	},
	{	353,  62	},
	{	342,  63	},
	{	332,  64	},
	{	322,  65	},
	{	312,  66	},
	{	303,  67	},
	{	294,  68	},
	{	285,  69	},
	{	276,  70	},
	{	268,  71	},
	{	260,  72	},
	{	252,  73	},
	{	244,  74	},
	{	237,  75	},
	{	230,  76	},
	{	223,  77	},
	{	216,  78	},
	{	210,  79	},
	{	204,  80	},
};

#if !defined(CONFIG_MACH_TAB3)
struct stmpe811_platform_data stmpe811_pdata = {
	.adc_table_ch4 = temper_table_battery,
	.table_size_ch4 = ARRAY_SIZE(temper_table_battery),
	.adc_table_ch7 = temper_table_battery,
	.table_size_ch7 = ARRAY_SIZE(temper_table_battery),

	.irq_gpio = GPIO_ADC_INT,
};
#endif
#endif

