/* linux/arch/arm/mach-exynos/include/mach/regs-hdmi.h
 *
 * Copyright (c) 2010 Samsung Electronics
 *		http://www.samsung.com/
 *
 * HDMI register header file for Samsung TVOUT driver
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ARCH_ARM_REGS_HDMI_H
#define __ARCH_ARM_REGS_HDMI_H

/*
 * Register part
*/

#ifdef CONFIG_HDMI_14A_3D

#define S5P_HDMI_I2C_PHY_BASE(x)		(x)

#define HDMI_I2C_CON				S5P_HDMI_I2C_PHY_BASE(0x0000)
#define HDMI_I2C_STAT				S5P_HDMI_I2C_PHY_BASE(0x0004)
#define HDMI_I2C_ADD				S5P_HDMI_I2C_PHY_BASE(0x0008)
#define HDMI_I2C_DS				S5P_HDMI_I2C_PHY_BASE(0x000c)
#define HDMI_I2C_LC				S5P_HDMI_I2C_PHY_BASE(0x0010)

#define S5P_HDMI_CTRL_BASE(x)			(x)
#define S5P_HDMI_BASE(x)			((x) + 0x00010000)
#define S5P_HDMI_SPDIF_BASE(x)			((x) + 0x00030000)
#define S5P_HDMI_I2S_BASE(x)			((x) + 0x00040000)
#define S5P_HDMI_TG_BASE(x)			((x) + 0x00050000)
#define S5P_HDMI_EFUSE_BASE(x)			((x) + 0x00060000)

/* HDMIControlRegister */
#define S5P_HDMI_INTC_CON0			S5P_HDMI_CTRL_BASE(0x000)
#define S5P_HDMI_INTC_FLAG0			S5P_HDMI_CTRL_BASE(0x004)
#define S5P_HDMI_AES_KEY_LOAD			S5P_HDMI_CTRL_BASE(0x008)
#define S5P_HDMI_HPD_STATUS			S5P_HDMI_CTRL_BASE(0x00C)

#define S5P_HDMI_INTC_CON1			S5P_HDMI_CTRL_BASE(0x010)
#define S5P_HDMI_INTC_FLAG1			S5P_HDMI_CTRL_BASE(0x014)
#define S5P_HDMI_PHY_STATUS0			S5P_HDMI_CTRL_BASE(0x020)
#define S5P_HDMI_PHY_STATUS_PLL			S5P_HDMI_CTRL_BASE(0x028)
#define S5P_HDMI_PHY_CON_0			S5P_HDMI_CTRL_BASE(0x030)

#define S5P_HDMI_HPD_CTRL			S5P_HDMI_CTRL_BASE(0x040)
#define S5P_HDMI_HPD_th_0			S5P_HDMI_CTRL_BASE(0x050)
#define S5P_HDMI_HPD_th_1			S5P_HDMI_CTRL_BASE(0x054)
#define S5P_HDMI_HPD_th_2			S5P_HDMI_CTRL_BASE(0x058)
#define S5P_HDMI_HPD_th_3			S5P_HDMI_CTRL_BASE(0x05C)

#define S5P_HDMI_AUDIO_CLKSEL			S5P_HDMI_CTRL_BASE(0x070)
#define S5P_HDMI_PHY_RSTOUT			S5P_HDMI_CTRL_BASE(0x074)
#define S5P_HDMI_PHY_VPLL			S5P_HDMI_CTRL_BASE(0x078)
#define S5P_HDMI_PHY_CMU			S5P_HDMI_CTRL_BASE(0x07C)
#define S5P_HDMI_CORE_RSTOUT			S5P_HDMI_CTRL_BASE(0x080)

/* HDMICoreRegister */
#define S5P_HDMI_CON_0				S5P_HDMI_BASE(0x000)
#define S5P_HDMI_CON_1				S5P_HDMI_BASE(0x004)
#define S5P_HDMI_CON_2				S5P_HDMI_BASE(0x008)
#define S5P_HDMI_SIM_MODE			S5P_HDMI_BASE(0x00C)
#define S5P_HDMI_SYS_STATUS			S5P_HDMI_BASE(0x010)
#define S5P_HDMI_PHY_STATUS			S5P_HDMI_BASE(0x014)
#define S5P_HDMI_STATUS_EN			S5P_HDMI_BASE(0x020)
#define S5P_HDMI_HPD				S5P_HDMI_BASE(0x030)
#define S5P_HDMI_MODE_SEL			S5P_HDMI_BASE(0x040)
#define S5P_HDMI_ENC_EN				S5P_HDMI_BASE(0x044)

#define S5P_HDMI_YMAX				S5P_HDMI_BASE(0x060)
#define S5P_HDMI_YMIN				S5P_HDMI_BASE(0x064)
#define S5P_HDMI_CMAX				S5P_HDMI_BASE(0x068)
#define S5P_HDMI_CMIN				S5P_HDMI_BASE(0x06c)

#define S5P_HDMI_DI_PREFIX			S5P_HDMI_BASE(0x078)
#define S5P_HDMI_VBI_ST_MG			S5P_HDMI_BASE(0x080)
#define S5P_HDMI_END_MG				S5P_HDMI_BASE(0x084)

#define S5P_HDMI_AUTH_ST_MG0			S5P_HDMI_BASE(0x090)
#define S5P_HDMI_AUTH_ST_MG1			S5P_HDMI_BASE(0x094)
#define S5P_HDMI_AUTH_END_MG0			S5P_HDMI_BASE(0x098)
#define S5P_HDMI_AUTH_END_MG1			S5P_HDMI_BASE(0x09C)

#define S5P_HDMI_H_BLANK_0			S5P_HDMI_BASE(0x0a0)
#define S5P_HDMI_H_BLANK_1			S5P_HDMI_BASE(0x0a4)

#define S5P_HDMI_V2_BLANK_0			S5P_HDMI_BASE(0x0b0)
#define S5P_HDMI_V2_BLANK_1			S5P_HDMI_BASE(0x0b4)
#define S5P_HDMI_V1_BLANK_0			S5P_HDMI_BASE(0x0b8)
#define S5P_HDMI_V1_BLANK_1			S5P_HDMI_BASE(0x0bC)

#define S5P_HDMI_V_LINE_0			S5P_HDMI_BASE(0x0c0)
#define S5P_HDMI_V_LINE_1			S5P_HDMI_BASE(0x0c4)
#define S5P_HDMI_H_LINE_0			S5P_HDMI_BASE(0x0c8)
#define S5P_HDMI_H_LINE_1			S5P_HDMI_BASE(0x0cC)
#define S5P_HDMI_HSYNC_POL			S5P_HDMI_BASE(0x0E0)

#define S5P_HDMI_VSYNC_POL			S5P_HDMI_BASE(0x0e4)
#define S5P_HDMI_INT_PRO_MODE			S5P_HDMI_BASE(0x0e8)

#define S5P_HDMI_V_BLANK_F0_0			S5P_HDMI_BASE(0x110)
#define S5P_HDMI_V_BLANK_F0_1			S5P_HDMI_BASE(0x114)
#define S5P_HDMI_V_BLANK_F1_0			S5P_HDMI_BASE(0x118)
#define S5P_HDMI_V_BLANK_F1_1			S5P_HDMI_BASE(0x11C)

#define S5P_HDMI_H_SYNC_START_0			S5P_HDMI_BASE(0x120)
#define S5P_HDMI_H_SYNC_START_1			S5P_HDMI_BASE(0x124)
#define S5P_HDMI_H_SYNC_END_0			S5P_HDMI_BASE(0x128)
#define S5P_HDMI_H_SYNC_END_1			S5P_HDMI_BASE(0x12C)

#define S5P_HDMI_V_SYNC_LINE_BEF_2_0		S5P_HDMI_BASE(0x130)
#define S5P_HDMI_V_SYNC_LINE_BEF_2_1		S5P_HDMI_BASE(0x134)
#define S5P_HDMI_V_SYNC_LINE_BEF_1_0		S5P_HDMI_BASE(0x138)
#define S5P_HDMI_V_SYNC_LINE_BEF_1_1		S5P_HDMI_BASE(0x13C)

#define S5P_HDMI_V_SYNC_LINE_AFT_2_0		S5P_HDMI_BASE(0x140)
#define S5P_HDMI_V_SYNC_LINE_AFT_2_1		S5P_HDMI_BASE(0x144)
#define S5P_HDMI_V_SYNC_LINE_AFT_1_0		S5P_HDMI_BASE(0x148)
#define S5P_HDMI_V_SYNC_LINE_AFT_1_1		S5P_HDMI_BASE(0x14C)

#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_2_0	S5P_HDMI_BASE(0x150)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_2_1	S5P_HDMI_BASE(0x154)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_1_0	S5P_HDMI_BASE(0x158)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_1_1	S5P_HDMI_BASE(0x15C)

#define S5P_HDMI_V_BLANK_F2_0			S5P_HDMI_BASE(0x160)
#define S5P_HDMI_V_BLANK_F2_1			S5P_HDMI_BASE(0x164)
#define S5P_HDMI_V_BLANK_F3_0			S5P_HDMI_BASE(0x168)
#define S5P_HDMI_V_BLANK_F3_1			S5P_HDMI_BASE(0x16C)
#define S5P_HDMI_V_BLANK_F4_0			S5P_HDMI_BASE(0x170)
#define S5P_HDMI_V_BLANK_F4_1			S5P_HDMI_BASE(0x174)
#define S5P_HDMI_V_BLANK_F5_0			S5P_HDMI_BASE(0x178)
#define S5P_HDMI_V_BLANK_F5_1			S5P_HDMI_BASE(0x17C)

#define S5P_HDMI_V_SYNC_LINE_AFT_3_0		S5P_HDMI_BASE(0x180)
#define S5P_HDMI_V_SYNC_LINE_AFT_3_1		S5P_HDMI_BASE(0x184)
#define S5P_HDMI_V_SYNC_LINE_AFT_4_0		S5P_HDMI_BASE(0x188)
#define S5P_HDMI_V_SYNC_LINE_AFT_4_1		S5P_HDMI_BASE(0x18C)
#define S5P_HDMI_V_SYNC_LINE_AFT_5_0		S5P_HDMI_BASE(0x190)
#define S5P_HDMI_V_SYNC_LINE_AFT_5_1		S5P_HDMI_BASE(0x194)
#define S5P_HDMI_V_SYNC_LINE_AFT_6_0		S5P_HDMI_BASE(0x198)
#define S5P_HDMI_V_SYNC_LINE_AFT_6_1		S5P_HDMI_BASE(0x19C)

#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_3_0	S5P_HDMI_BASE(0x1A0)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_3_1	S5P_HDMI_BASE(0x1A4)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_4_0	S5P_HDMI_BASE(0x1A8)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_4_1	S5P_HDMI_BASE(0x1AC)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_5_0	S5P_HDMI_BASE(0x1B0)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_5_1	S5P_HDMI_BASE(0x1B4)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_6_0	S5P_HDMI_BASE(0x1B8)
#define S5P_HDMI_V_SYNC_LINE_AFT_PXL_6_1	S5P_HDMI_BASE(0x1BC)

#define S5P_HDMI_VACT_SPACE_1_0			S5P_HDMI_BASE(0x1C0)
#define S5P_HDMI_VACT_SPACE_1_1			S5P_HDMI_BASE(0x1C4)
#define S5P_HDMI_VACT_SPACE_2_0			S5P_HDMI_BASE(0x1C8)
#define S5P_HDMI_VACT_SPACE_2_1			S5P_HDMI_BASE(0x1CC)
#define S5P_HDMI_VACT_SPACE_3_0			S5P_HDMI_BASE(0x1D0)
#define S5P_HDMI_VACT_SPACE_3_1			S5P_HDMI_BASE(0x1D4)
#define S5P_HDMI_VACT_SPACE_4_0			S5P_HDMI_BASE(0x1D8)
#define S5P_HDMI_VACT_SPACE_4_1			S5P_HDMI_BASE(0x1DC)
#define S5P_HDMI_VACT_SPACE_5_0			S5P_HDMI_BASE(0x1E0)
#define S5P_HDMI_VACT_SPACE_5_1			S5P_HDMI_BASE(0x1E4)
#define S5P_HDMI_VACT_SPACE_6_0			S5P_HDMI_BASE(0x1E8)
#define S5P_HDMI_VACT_SPACE_6_1			S5P_HDMI_BASE(0x1EC)
#define S5P_HDMI_CSC_MUX			S5P_HDMI_BASE(0x1F0)
#define S5P_HDMI_SYNC_GEN_MUX			S5P_HDMI_BASE(0x1F4)

#define S5P_HDMI_GCP_CON			S5P_HDMI_BASE(0x200)
#define S5P_HDMI_GCP_CON_EX			S5P_HDMI_BASE(0x204)
#define S5P_HDMI_GCP_BYTE1			S5P_HDMI_BASE(0x210)
#define S5P_HDMI_GCP_BYTE2			S5P_HDMI_BASE(0x214)
#define S5P_HDMI_GCP_BYTE3			S5P_HDMI_BASE(0x218)

#define S5P_HDMI_ASP_CON			S5P_HDMI_BASE(0x300)
#define S5P_HDMI_ASP_SP_FLAT			S5P_HDMI_BASE(0x304)
#define S5P_HDMI_ASP_CHCFG0			S5P_HDMI_BASE(0x310)
#define S5P_HDMI_ASP_CHCFG1			S5P_HDMI_BASE(0x314)
#define S5P_HDMI_ASP_CHCFG2			S5P_HDMI_BASE(0x318)
#define S5P_HDMI_ASP_CHCFG3			S5P_HDMI_BASE(0x31c)

#define S5P_HDMI_ACR_CON			S5P_HDMI_BASE(0x400)
#define S5P_HDMI_ACR_MCTS0			S5P_HDMI_BASE(0x410)
#define S5P_HDMI_ACR_MCTS1			S5P_HDMI_BASE(0x414)
#define S5P_HDMI_ACR_MCTS2			S5P_HDMI_BASE(0x418)
#define S5P_HDMI_ACR_CTS0			S5P_HDMI_BASE(0x420)
#define S5P_HDMI_ACR_CTS1			S5P_HDMI_BASE(0x424)
#define S5P_HDMI_ACR_CTS2			S5P_HDMI_BASE(0x428)
#define S5P_HDMI_ACR_N0				S5P_HDMI_BASE(0x430)
#define S5P_HDMI_ACR_N1				S5P_HDMI_BASE(0x434)
#define S5P_HDMI_ACR_N2				S5P_HDMI_BASE(0x438)
#define S5P_HDMI_ACR_LSB2			S5P_HDMI_BASE(0x440)
#define S5P_HDMI_ACR_TXCNT			S5P_HDMI_BASE(0x444)
#define S5P_HDMI_ACR_TXINTERNAL			S5P_HDMI_BASE(0x448)
#define S5P_HDMI_ACR_CTS_OFFSET			S5P_HDMI_BASE(0x44c)

#define S5P_HDMI_ACP_CON			S5P_HDMI_BASE(0x500)
#define S5P_HDMI_ACP_TYPE			S5P_HDMI_BASE(0x514)
#define S5P_HDMI_ACP_DATA00			S5P_HDMI_BASE(0x520)
#define S5P_HDMI_ACP_DATA01			S5P_HDMI_BASE(0x524)
#define S5P_HDMI_ACP_DATA02			S5P_HDMI_BASE(0x528)
#define S5P_HDMI_ACP_DATA03			S5P_HDMI_BASE(0x52C)
#define S5P_HDMI_ACP_DATA04			S5P_HDMI_BASE(0x530)
#define S5P_HDMI_ACP_DATA05			S5P_HDMI_BASE(0x534)
#define S5P_HDMI_ACP_DATA06			S5P_HDMI_BASE(0x538)
#define S5P_HDMI_ACP_DATA07			S5P_HDMI_BASE(0x53c)
#define S5P_HDMI_ACP_DATA08			S5P_HDMI_BASE(0x540)
#define S5P_HDMI_ACP_DATA09			S5P_HDMI_BASE(0x544)
#define S5P_HDMI_ACP_DATA10			S5P_HDMI_BASE(0x548)
#define S5P_HDMI_ACP_DATA11			S5P_HDMI_BASE(0x54c)
#define S5P_HDMI_ACP_DATA12			S5P_HDMI_BASE(0x550)
#define S5P_HDMI_ACP_DATA13			S5P_HDMI_BASE(0x554)
#define S5P_HDMI_ACP_DATA14			S5P_HDMI_BASE(0x558)
#define S5P_HDMI_ACP_DATA15			S5P_HDMI_BASE(0x55c)
#define S5P_HDMI_ACP_DATA16			S5P_HDMI_BASE(0x560)

#define S5P_HDMI_ISRC_CON			S5P_HDMI_BASE(0x600)
#define S5P_HDMI_ISRC1_HEADER1			S5P_HDMI_BASE(0x614)
#define S5P_HDMI_ISRC1_DATA00			S5P_HDMI_BASE(0x620)
#define S5P_HDMI_ISRC1_DATA01			S5P_HDMI_BASE(0x624)
#define S5P_HDMI_ISRC1_DATA02			S5P_HDMI_BASE(0x628)
#define S5P_HDMI_ISRC1_DATA03			S5P_HDMI_BASE(0x62c)
#define S5P_HDMI_ISRC1_DATA04			S5P_HDMI_BASE(0x630)
#define S5P_HDMI_ISRC1_DATA05			S5P_HDMI_BASE(0x634)
#define S5P_HDMI_ISRC1_DATA06			S5P_HDMI_BASE(0x638)
#define S5P_HDMI_ISRC1_DATA07			S5P_HDMI_BASE(0x63c)
#define S5P_HDMI_ISRC1_DATA08			S5P_HDMI_BASE(0x640)
#define S5P_HDMI_ISRC1_DATA09			S5P_HDMI_BASE(0x644)
#define S5P_HDMI_ISRC1_DATA10			S5P_HDMI_BASE(0x648)
#define S5P_HDMI_ISRC1_DATA11			S5P_HDMI_BASE(0x64c)
#define S5P_HDMI_ISRC1_DATA12			S5P_HDMI_BASE(0x650)
#define S5P_HDMI_ISRC1_DATA13			S5P_HDMI_BASE(0x654)
#define S5P_HDMI_ISRC1_DATA14			S5P_HDMI_BASE(0x658)
#define S5P_HDMI_ISRC1_DATA15			S5P_HDMI_BASE(0x65c)
#define S5P_HDMI_ISRC2_DATA00			S5P_HDMI_BASE(0x6A0)
#define S5P_HDMI_ISRC2_DATA01			S5P_HDMI_BASE(0x6A4)
#define S5P_HDMI_ISRC2_DATA02			S5P_HDMI_BASE(0x6A8)
#define S5P_HDMI_ISRC2_DATA03			S5P_HDMI_BASE(0x6Ac)
#define S5P_HDMI_ISRC2_DATA04			S5P_HDMI_BASE(0x6B0)
#define S5P_HDMI_ISRC2_DATA05			S5P_HDMI_BASE(0x6B4)
#define S5P_HDMI_ISRC2_DATA06			S5P_HDMI_BASE(0x6B8)
#define S5P_HDMI_ISRC2_DATA07			S5P_HDMI_BASE(0x6Bc)
#define S5P_HDMI_ISRC2_DATA08			S5P_HDMI_BASE(0x6C0)
#define S5P_HDMI_ISRC2_DATA09			S5P_HDMI_BASE(0x6C4)
#define S5P_HDMI_ISRC2_DATA10			S5P_HDMI_BASE(0x6C8)
#define S5P_HDMI_ISRC2_DATA11			S5P_HDMI_BASE(0x6Cc)
#define S5P_HDMI_ISRC2_DATA12			S5P_HDMI_BASE(0x6D0)
#define S5P_HDMI_ISRC2_DATA13			S5P_HDMI_BASE(0x6D4)
#define S5P_HDMI_ISRC2_DATA14			S5P_HDMI_BASE(0x6D8)
#define S5P_HDMI_ISRC2_DATA15			S5P_HDMI_BASE(0x6Dc)

#define S5P_HDMI_AVI_CON			S5P_HDMI_BASE(0x700)
#define S5P_HDMI_AVI_HEADER0			S5P_HDMI_BASE(0x710)
#define S5P_HDMI_AVI_HEADER1			S5P_HDMI_BASE(0x714)
#define S5P_HDMI_AVI_HEADER2			S5P_HDMI_BASE(0x718)
#define S5P_HDMI_AVI_CHECK_SUM			S5P_HDMI_BASE(0x71C)
#define S5P_HDMI_AVI_BYTE1			S5P_HDMI_BASE(0x720)
#define S5P_HDMI_AVI_BYTE2			S5P_HDMI_BASE(0x724)
#define S5P_HDMI_AVI_BYTE3			S5P_HDMI_BASE(0x728)
#define S5P_HDMI_AVI_BYTE4			S5P_HDMI_BASE(0x72c)
#define S5P_HDMI_AVI_BYTE5			S5P_HDMI_BASE(0x730)
#define S5P_HDMI_AVI_BYTE6			S5P_HDMI_BASE(0x734)
#define S5P_HDMI_AVI_BYTE7			S5P_HDMI_BASE(0x738)
#define S5P_HDMI_AVI_BYTE8			S5P_HDMI_BASE(0x73c)
#define S5P_HDMI_AVI_BYTE9			S5P_HDMI_BASE(0x740)
#define S5P_HDMI_AVI_BYTE10			S5P_HDMI_BASE(0x744)
#define S5P_HDMI_AVI_BYTE11			S5P_HDMI_BASE(0x748)
#define S5P_HDMI_AVI_BYTE12			S5P_HDMI_BASE(0x74c)
#define S5P_HDMI_AVI_BYTE13			S5P_HDMI_BASE(0x750)

#define S5P_HDMI_AUI_CON			S5P_HDMI_BASE(0x800)
#define S5P_HDMI_AUI_HEADER0			S5P_HDMI_BASE(0x810)
#define S5P_HDMI_AUI_HEADER1			S5P_HDMI_BASE(0x814)
#define S5P_HDMI_AUI_HEADER2			S5P_HDMI_BASE(0x818)
#define S5P_HDMI_AUI_CHECK_SUM			S5P_HDMI_BASE(0x81C)
#define S5P_HDMI_AUI_BYTE1			S5P_HDMI_BASE(0x820)
#define S5P_HDMI_AUI_BYTE2			S5P_HDMI_BASE(0x824)
#define S5P_HDMI_AUI_BYTE3			S5P_HDMI_BASE(0x828)
#define S5P_HDMI_AUI_BYTE4			S5P_HDMI_BASE(0x82c)
#define S5P_HDMI_AUI_BYTE5			S5P_HDMI_BASE(0x830)
#define S5P_HDMI_AUI_BYTE6			S5P_HDMI_BASE(0x834)
#define S5P_HDMI_AUI_BYTE7			S5P_HDMI_BASE(0x838)
#define S5P_HDMI_AUI_BYTE8			S5P_HDMI_BASE(0x83C)
#define S5P_HDMI_AUI_BYTE9			S5P_HDMI_BASE(0x840)
#define S5P_HDMI_AUI_BYTE10			S5P_HDMI_BASE(0x844)
#define S5P_HDMI_AUI_BYTE11			S5P_HDMI_BASE(0x848)
#define S5P_HDMI_AUI_BYTE12			S5P_HDMI_BASE(0x84C)

#define S5P_HDMI_MPG_CON			S5P_HDMI_BASE(0x900)
#define S5P_HDMI_MPG_CHECK_SUM			S5P_HDMI_BASE(0x91C)
#define S5P_HDMI_MPG_BYTE1			S5P_HDMI_BASE(0x920)
#define S5P_HDMI_MPG_BYTE2			S5P_HDMI_BASE(0x924)
#define S5P_HDMI_MPG_BYTE3			S5P_HDMI_BASE(0x928)
#define S5P_HDMI_MPG_BYTE4			S5P_HDMI_BASE(0x92c)
#define S5P_HDMI_MPG_BYTE5			S5P_HDMI_BASE(0x930)
#define S5P_HDMI_MPG_BYTE6			S5P_HDMI_BASE(0x934)

#define S5P_HDMI_SPD_CON			S5P_HDMI_BASE(0xA00)
#define S5P_HDMI_SPD_HEADER0			S5P_HDMI_BASE(0xA10)
#define S5P_HDMI_SPD_HEADER1			S5P_HDMI_BASE(0xA14)
#define S5P_HDMI_SPD_HEADER2			S5P_HDMI_BASE(0xA18)
#define S5P_HDMI_SPD_DATA00			S5P_HDMI_BASE(0xA20)
#define S5P_HDMI_SPD_DATA01			S5P_HDMI_BASE(0xA24)
#define S5P_HDMI_SPD_DATA02			S5P_HDMI_BASE(0xA28)
#define S5P_HDMI_SPD_DATA03			S5P_HDMI_BASE(0xA2c)
#define S5P_HDMI_SPD_DATA04			S5P_HDMI_BASE(0xA30)
#define S5P_HDMI_SPD_DATA05			S5P_HDMI_BASE(0xA34)
#define S5P_HDMI_SPD_DATA06			S5P_HDMI_BASE(0xA38)
#define S5P_HDMI_SPD_DATA07			S5P_HDMI_BASE(0xA3c)
#define S5P_HDMI_SPD_DATA08			S5P_HDMI_BASE(0xA40)
#define S5P_HDMI_SPD_DATA09			S5P_HDMI_BASE(0xA44)
#define S5P_HDMI_SPD_DATA10			S5P_HDMI_BASE(0xA48)
#define S5P_HDMI_SPD_DATA11			S5P_HDMI_BASE(0xA4c)
#define S5P_HDMI_SPD_DATA12			S5P_HDMI_BASE(0xA50)
#define S5P_HDMI_SPD_DATA13			S5P_HDMI_BASE(0xA54)
#define S5P_HDMI_SPD_DATA14			S5P_HDMI_BASE(0xA58)
#define S5P_HDMI_SPD_DATA15			S5P_HDMI_BASE(0xA5c)
#define S5P_HDMI_SPD_DATA16			S5P_HDMI_BASE(0xA60)
#define S5P_HDMI_SPD_DATA17			S5P_HDMI_BASE(0xA64)
#define S5P_HDMI_SPD_DATA18			S5P_HDMI_BASE(0xA68)
#define S5P_HDMI_SPD_DATA19			S5P_HDMI_BASE(0xA6c)
#define S5P_HDMI_SPD_DATA20			S5P_HDMI_BASE(0xA70)
#define S5P_HDMI_SPD_DATA21			S5P_HDMI_BASE(0xA74)
#define S5P_HDMI_SPD_DATA22			S5P_HDMI_BASE(0xA78)
#define S5P_HDMI_SPD_DATA23			S5P_HDMI_BASE(0xA7c)
#define S5P_HDMI_SPD_DATA24			S5P_HDMI_BASE(0xA80)
#define S5P_HDMI_SPD_DATA25			S5P_HDMI_BASE(0xA84)
#define S5P_HDMI_SPD_DATA26			S5P_HDMI_BASE(0xA88)
#define S5P_HDMI_SPD_DATA27			S5P_HDMI_BASE(0xA8c)

#define S5P_HDMI_GAMUT_CON			S5P_HDMI_BASE(0xB00)
#define S5P_HDMI_GAMUT_HEADER0			S5P_HDMI_BASE(0xB10)
#define S5P_HDMI_GAMUT_HEADER1			S5P_HDMI_BASE(0xB14)
#define S5P_HDMI_GAMUT_HEADER2			S5P_HDMI_BASE(0xB18)
#define S5P_HDMI_GAMUT_DATA00			S5P_HDMI_BASE(0xB20)
#define S5P_HDMI_GAMUT_DATA01			S5P_HDMI_BASE(0xB24)
#define S5P_HDMI_GAMUT_DATA02			S5P_HDMI_BASE(0xB28)
#define S5P_HDMI_GAMUT_DATA03			S5P_HDMI_BASE(0xB2c)
#define S5P_HDMI_GAMUT_DATA04			S5P_HDMI_BASE(0xB30)
#define S5P_HDMI_GAMUT_DATA05			S5P_HDMI_BASE(0xB34)
#define S5P_HDMI_GAMUT_DATA06			S5P_HDMI_BASE(0xB38)
#define S5P_HDMI_GAMUT_DATA07			S5P_HDMI_BASE(0xB3c)
#define S5P_HDMI_GAMUT_DATA08			S5P_HDMI_BASE(0xB40)
#define S5P_HDMI_GAMUT_DATA09			S5P_HDMI_BASE(0xB44)
#define S5P_HDMI_GAMUT_DATA10			S5P_HDMI_BASE(0xB48)
#define S5P_HDMI_GAMUT_DATA11			S5P_HDMI_BASE(0xB4c)
#define S5P_HDMI_GAMUT_DATA12			S5P_HDMI_BASE(0xB50)
#define S5P_HDMI_GAMUT_DATA13			S5P_HDMI_BASE(0xB54)
#define S5P_HDMI_GAMUT_DATA14			S5P_HDMI_BASE(0xB58)
#define S5P_HDMI_GAMUT_DATA15			S5P_HDMI_BASE(0xB5c)
#define S5P_HDMI_GAMUT_DATA16			S5P_HDMI_BASE(0xB60)
#define S5P_HDMI_GAMUT_DATA17			S5P_HDMI_BASE(0xB64)
#define S5P_HDMI_GAMUT_DATA18			S5P_HDMI_BASE(0xB68)
#define S5P_HDMI_GAMUT_DATA19			S5P_HDMI_BASE(0xB6c)
#define S5P_HDMI_GAMUT_DATA20			S5P_HDMI_BASE(0xB70)
#define S5P_HDMI_GAMUT_DATA21			S5P_HDMI_BASE(0xB74)
#define S5P_HDMI_GAMUT_DATA22			S5P_HDMI_BASE(0xB78)
#define S5P_HDMI_GAMUT_DATA23			S5P_HDMI_BASE(0xB7c)
#define S5P_HDMI_GAMUT_DATA24			S5P_HDMI_BASE(0xB80)
#define S5P_HDMI_GAMUT_DATA25			S5P_HDMI_BASE(0xB84)
#define S5P_HDMI_GAMUT_DATA26			S5P_HDMI_BASE(0xB88)
#define S5P_HDMI_GAMUT_DATA27			S5P_HDMI_BASE(0xB8c)

#define S5P_HDMI_VSI_CON			S5P_HDMI_BASE(0xC00)
#define S5P_HDMI_VSI_HEADER0			S5P_HDMI_BASE(0xC10)
#define S5P_HDMI_VSI_HEADER1			S5P_HDMI_BASE(0xC14)
#define S5P_HDMI_VSI_HEADER2			S5P_HDMI_BASE(0xC18)
#define S5P_HDMI_VSI_DATA00			S5P_HDMI_BASE(0xC20)
#define S5P_HDMI_VSI_DATA01			S5P_HDMI_BASE(0xC24)
#define S5P_HDMI_VSI_DATA02			S5P_HDMI_BASE(0xC28)
#define S5P_HDMI_VSI_DATA03			S5P_HDMI_BASE(0xC2c)
#define S5P_HDMI_VSI_DATA04			S5P_HDMI_BASE(0xC30)
#define S5P_HDMI_VSI_DATA05			S5P_HDMI_BASE(0xC34)
#define S5P_HDMI_VSI_DATA06			S5P_HDMI_BASE(0xC38)
#define S5P_HDMI_VSI_DATA07			S5P_HDMI_BASE(0xC3c)
#define S5P_HDMI_VSI_DATA08			S5P_HDMI_BASE(0xC40)
#define S5P_HDMI_VSI_DATA09			S5P_HDMI_BASE(0xC44)
#define S5P_HDMI_VSI_DATA10			S5P_HDMI_BASE(0xC48)
#define S5P_HDMI_VSI_DATA11			S5P_HDMI_BASE(0xC4c)
#define S5P_HDMI_VSI_DATA12			S5P_HDMI_BASE(0xC50)
#define S5P_HDMI_VSI_DATA13			S5P_HDMI_BASE(0xC54)
#define S5P_HDMI_VSI_DATA14			S5P_HDMI_BASE(0xC58)
#define S5P_HDMI_VSI_DATA15			S5P_HDMI_BASE(0xC5c)
#define S5P_HDMI_VSI_DATA16			S5P_HDMI_BASE(0xC60)
#define S5P_HDMI_VSI_DATA17			S5P_HDMI_BASE(0xC64)
#define S5P_HDMI_VSI_DATA18			S5P_HDMI_BASE(0xC68)
#define S5P_HDMI_VSI_DATA19			S5P_HDMI_BASE(0xC6c)
#define S5P_HDMI_VSI_DATA20			S5P_HDMI_BASE(0xC70)
#define S5P_HDMI_VSI_DATA21			S5P_HDMI_BASE(0xC74)
#define S5P_HDMI_VSI_DATA22			S5P_HDMI_BASE(0xC78)
#define S5P_HDMI_VSI_DATA23			S5P_HDMI_BASE(0xC7c)
#define S5P_HDMI_VSI_DATA24			S5P_HDMI_BASE(0xC80)
#define S5P_HDMI_VSI_DATA25			S5P_HDMI_BASE(0xC84)
#define S5P_HDMI_VSI_DATA26			S5P_HDMI_BASE(0xC88)
#define S5P_HDMI_VSI_DATA27			S5P_HDMI_BASE(0xC8c)

#define S5P_HDMI_DC_CONTROL			S5P_HDMI_BASE(0xD00)
#define S5P_HDMI_VIDEO_PATTERN_GEN		S5P_HDMI_BASE(0xD04)
#define S5P_HDMI_HPD_GEN0			S5P_HDMI_BASE(0xD08)
#define S5P_HDMI_HPD_GEN1			S5P_HDMI_BASE(0xD0C)
#define S5P_HDMI_HPD_GEN2			S5P_HDMI_BASE(0xD10)
#define S5P_HDMI_HPD_GEN3			S5P_HDMI_BASE(0xD14)

#define S5P_HDMI_DIM_CON			S5P_HDMI_BASE(0xD30)

#define S5P_HDMI_HDCP_RX_SHA1_0_0		S5P_HDMI_BASE(0x7000)
#define S5P_HDMI_HDCP_RX_SHA1_0_1		S5P_HDMI_BASE(0x7004)
#define S5P_HDMI_HDCP_RX_SHA1_0_2		S5P_HDMI_BASE(0x7008)
#define S5P_HDMI_HDCP_RX_SHA1_0_3		S5P_HDMI_BASE(0x700c)
#define S5P_HDMI_HDCP_RX_SHA1_1_0		S5P_HDMI_BASE(0x7010)
#define S5P_HDMI_HDCP_RX_SHA1_1_1		S5P_HDMI_BASE(0x7014)
#define S5P_HDMI_HDCP_RX_SHA1_1_2		S5P_HDMI_BASE(0x7018)
#define S5P_HDMI_HDCP_RX_SHA1_1_3		S5P_HDMI_BASE(0x701c)
#define S5P_HDMI_HDCP_RX_SHA1_2_0		S5P_HDMI_BASE(0x7020)
#define S5P_HDMI_HDCP_RX_SHA1_2_1		S5P_HDMI_BASE(0x7024)
#define S5P_HDMI_HDCP_RX_SHA1_2_2		S5P_HDMI_BASE(0x7028)
#define S5P_HDMI_HDCP_RX_SHA1_2_3		S5P_HDMI_BASE(0x702c)
#define S5P_HDMI_HDCP_RX_SHA1_3_0		S5P_HDMI_BASE(0x7030)
#define S5P_HDMI_HDCP_RX_SHA1_3_1		S5P_HDMI_BASE(0x7034)
#define S5P_HDMI_HDCP_RX_SHA1_3_2		S5P_HDMI_BASE(0x7038)
#define S5P_HDMI_HDCP_RX_SHA1_3_3		S5P_HDMI_BASE(0x703c)
#define S5P_HDMI_HDCP_RX_SHA1_4_0		S5P_HDMI_BASE(0x7040)
#define S5P_HDMI_HDCP_RX_SHA1_4_1		S5P_HDMI_BASE(0x7044)
#define S5P_HDMI_HDCP_RX_SHA1_4_2		S5P_HDMI_BASE(0x7048)
#define S5P_HDMI_HDCP_RX_SHA1_4_3		S5P_HDMI_BASE(0x704c)

#define S5P_HDMI_HDCP_RX_KSV_0_0		S5P_HDMI_BASE(0x7050)
#define S5P_HDMI_HDCP_RX_KSV_0_1		S5P_HDMI_BASE(0x7054)
#define S5P_HDMI_HDCP_RX_KSV_0_2		S5P_HDMI_BASE(0x7058)
#define S5P_HDMI_HDCP_RX_KSV_0_3		S5P_HDMI_BASE(0x705c)
#define S5P_HDMI_HDCP_RX_KSV_0_4		S5P_HDMI_BASE(0x7060)

#define S5P_HDMI_HDCP_KSV_LIST_CON		S5P_HDMI_BASE(0x7064)
#define S5P_HDMI_HDCP_SHA_RESULT		S5P_HDMI_BASE(0x7070)
#define S5P_HDMI_HDCP_CTRL1			S5P_HDMI_BASE(0x7080)
#define S5P_HDMI_HDCP_CTRL2			S5P_HDMI_BASE(0x7084)
#define S5P_HDMI_HDCP_CHECK_RESULT		S5P_HDMI_BASE(0x7090)

#define S5P_HDMI_HDCP_BKSV_0_0			S5P_HDMI_BASE(0x70a0)
#define S5P_HDMI_HDCP_BKSV_0_1			S5P_HDMI_BASE(0x70a4)
#define S5P_HDMI_HDCP_BKSV_0_2			S5P_HDMI_BASE(0x70a8)
#define S5P_HDMI_HDCP_BKSV_0_3			S5P_HDMI_BASE(0x70ac)
#define S5P_HDMI_HDCP_BKSV_1			S5P_HDMI_BASE(0x70b0)

#define S5P_HDMI_HDCP_AKSV_0_0			S5P_HDMI_BASE(0x70c0)
#define S5P_HDMI_HDCP_AKSV_0_1			S5P_HDMI_BASE(0x70c4)
#define S5P_HDMI_HDCP_AKSV_0_2			S5P_HDMI_BASE(0x70c8)
#define S5P_HDMI_HDCP_AKSV_0_3			S5P_HDMI_BASE(0x70cc)
#define S5P_HDMI_HDCP_AKSV_1			S5P_HDMI_BASE(0x70d0)

#define S5P_HDMI_HDCP_An_0_0			S5P_HDMI_BASE(0x70e0)
#define S5P_HDMI_HDCP_An_0_1			S5P_HDMI_BASE(0x70e4)
#define S5P_HDMI_HDCP_An_0_2			S5P_HDMI_BASE(0x70e8)
#define S5P_HDMI_HDCP_An_0_3			S5P_HDMI_BASE(0x70ec)
#define S5P_HDMI_HDCP_An_1_0			S5P_HDMI_BASE(0x70f0)
#define S5P_HDMI_HDCP_An_1_1			S5P_HDMI_BASE(0x70f4)
#define S5P_HDMI_HDCP_An_1_2			S5P_HDMI_BASE(0x70f8)
#define S5P_HDMI_HDCP_An_1_3			S5P_HDMI_BASE(0x70fc)

#define S5P_HDMI_HDCP_BCAPS			S5P_HDMI_BASE(0x7100)
#define S5P_HDMI_HDCP_BSTATUS_0			S5P_HDMI_BASE(0x7110)
#define S5P_HDMI_HDCP_BSTATUS_1			S5P_HDMI_BASE(0x7114)
#define S5P_HDMI_HDCP_Ri_0			S5P_HDMI_BASE(0x7140)
#define S5P_HDMI_HDCP_Ri_1			S5P_HDMI_BASE(0x7144)
#define S5P_HDMI_HDCP_I2C_INT			S5P_HDMI_BASE(0x7180)
#define S5P_HDMI_HDCP_AN_INT			S5P_HDMI_BASE(0x7190)
#define S5P_HDMI_HDCP_WDT_INT			S5P_HDMI_BASE(0x71a0)
#define S5P_HDMI_HDCP_RI_INT			S5P_HDMI_BASE(0x71b0)

#define S5P_HDMI_HDCP_RI_COMPARE_0		S5P_HDMI_BASE(0x71d0)
#define S5P_HDMI_HDCP_RI_COMPARE_1		S5P_HDMI_BASE(0x71d4)
#define S5P_HDMI_HDCP_FRAME_COUNT		S5P_HDMI_BASE(0x71e0)

#define S5P_HDMI_RGB_ROUND_EN			S5P_HDMI_BASE(0xD500)

#define S5P_HDMI_VACT_SPACE_R_0			S5P_HDMI_BASE(0xD504)
#define S5P_HDMI_VACT_SPACE_R_1			S5P_HDMI_BASE(0xD508)

#define S5P_HDMI_VACT_SPACE_G_0			S5P_HDMI_BASE(0xD50C)
#define S5P_HDMI_VACT_SPACE_G_1			S5P_HDMI_BASE(0xD510)

#define S5P_HDMI_VACT_SPACE_B_0			S5P_HDMI_BASE(0xD514)
#define S5P_HDMI_VACT_SPACE_B_1			S5P_HDMI_BASE(0xD518)

#define S5P_HDMI_BLUE_SCREEN_B_0		S5P_HDMI_BASE(0xD520)
#define S5P_HDMI_BLUE_SCREEN_B_1		S5P_HDMI_BASE(0xD524)
#define S5P_HDMI_BLUE_SCREEN_G_0		S5P_HDMI_BASE(0xD528)
#define S5P_HDMI_BLUE_SCREEN_G_1		S5P_HDMI_BASE(0xD52C)
#define S5P_HDMI_BLUE_SCREEN_R_0		S5P_HDMI_BASE(0xD530)
#define S5P_HDMI_BLUE_SCREEN_R_1		S5P_HDMI_BASE(0xD534)

/* HDMISPDIFregister */
#define S5P_HDMI_SPDIFIN_CLK_CTRL		S5P_HDMI_SPDIF_BASE(0x0000)
#define S5P_HDMI_SPDIFIN_OP_CTRL		S5P_HDMI_SPDIF_BASE(0x0004)
#define S5P_HDMI_SPDIFIN_IRQ_MASK		S5P_HDMI_SPDIF_BASE(0x0008)
#define S5P_HDMI_SPDIFIN_IRQ_STATUS		S5P_HDMI_SPDIF_BASE(0x000C)
#define S5P_HDMI_SPDIFIN_CONFIG_1		S5P_HDMI_SPDIF_BASE(0x0010)
#define S5P_HDMI_SPDIFIN_CONFIG_2		S5P_HDMI_SPDIF_BASE(0x0014)
#define S5P_HDMI_SPDIFIN_USER_VALUE_1		S5P_HDMI_SPDIF_BASE(0x0020)
#define S5P_HDMI_SPDIFIN_USER_VALUE_2		S5P_HDMI_SPDIF_BASE(0x0024)
#define S5P_HDMI_SPDIFIN_USER_VALUE_3		S5P_HDMI_SPDIF_BASE(0x0028)
#define S5P_HDMI_SPDIFIN_USER_VALUE_4		S5P_HDMI_SPDIF_BASE(0x002C)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_1		S5P_HDMI_SPDIF_BASE(0x0030)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_2		S5P_HDMI_SPDIF_BASE(0x0034)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_3		S5P_HDMI_SPDIF_BASE(0x0038)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_4		S5P_HDMI_SPDIF_BASE(0x003C)
#define S5P_HDMI_SPDIFIN_CH_STATUS_1		S5P_HDMI_SPDIF_BASE(0x0040)
#define S5P_HDMI_SPDIFIN_FRAME_PERIOD_1		S5P_HDMI_SPDIF_BASE(0x0048)
#define S5P_HDMI_SPDIFIN_FRAME_PERIOD_2		S5P_HDMI_SPDIF_BASE(0x004C)
#define S5P_HDMI_SPDIFIN_Pc_INFO_1		S5P_HDMI_SPDIF_BASE(0x0050)
#define S5P_HDMI_SPDIFIN_Pc_INFO_2		S5P_HDMI_SPDIF_BASE(0x0054)
#define S5P_HDMI_SPDIFIN_Pd_INFO_1		S5P_HDMI_SPDIF_BASE(0x0058)
#define S5P_HDMI_SPDIFIN_Pd_INFO_2		S5P_HDMI_SPDIF_BASE(0x005C)
#define S5P_HDMI_SPDIFIN_DATA_BUF_0_1		S5P_HDMI_SPDIF_BASE(0x0060)
#define S5P_HDMI_SPDIFIN_DATA_BUF_0_2		S5P_HDMI_SPDIF_BASE(0x0064)
#define S5P_HDMI_SPDIFIN_DATA_BUF_0_3		S5P_HDMI_SPDIF_BASE(0x0068)
#define S5P_HDMI_SPDIFIN_USER_BUF_0		S5P_HDMI_SPDIF_BASE(0x006C)
#define S5P_HDMI_SPDIFIN_DATA_BUF_1_1		S5P_HDMI_SPDIF_BASE(0x0070)
#define S5P_HDMI_SPDIFIN_DATA_BUF_1_2		S5P_HDMI_SPDIF_BASE(0x0074)
#define S5P_HDMI_SPDIFIN_DATA_BUF_1_3		S5P_HDMI_SPDIF_BASE(0x0078)
#define S5P_HDMI_SPDIFIN_USER_BUF_1		S5P_HDMI_SPDIF_BASE(0x007C)

/* HDMII2Sregister */
#define S5P_HDMI_I2S_CLK_CON			S5P_HDMI_I2S_BASE(0x000)
#define S5P_HDMI_I2S_CON_1			S5P_HDMI_I2S_BASE(0x004)
#define S5P_HDMI_I2S_CON_2			S5P_HDMI_I2S_BASE(0x008)
#define S5P_HDMI_I2S_PIN_SEL_0			S5P_HDMI_I2S_BASE(0x00c)
#define S5P_HDMI_I2S_PIN_SEL_1			S5P_HDMI_I2S_BASE(0x010)
#define S5P_HDMI_I2S_PIN_SEL_2			S5P_HDMI_I2S_BASE(0x014)
#define S5P_HDMI_I2S_PIN_SEL_3			S5P_HDMI_I2S_BASE(0x018)
#define S5P_HDMI_I2S_DSD_CON			S5P_HDMI_I2S_BASE(0x01c)
#define S5P_HDMI_I2S_MUX_CON			S5P_HDMI_I2S_BASE(0x020)
#define S5P_HDMI_I2S_CH_ST_CON			S5P_HDMI_I2S_BASE(0x024)
#define S5P_HDMI_I2S_CH_ST_0			S5P_HDMI_I2S_BASE(0x028)
#define S5P_HDMI_I2S_CH_ST_1			S5P_HDMI_I2S_BASE(0x02c)
#define S5P_HDMI_I2S_CH_ST_2			S5P_HDMI_I2S_BASE(0x030)
#define S5P_HDMI_I2S_CH_ST_3			S5P_HDMI_I2S_BASE(0x034)
#define S5P_HDMI_I2S_CH_ST_4			S5P_HDMI_I2S_BASE(0x038)
#define S5P_HDMI_I2S_CH_ST_SH_0			S5P_HDMI_I2S_BASE(0x03c)
#define S5P_HDMI_I2S_CH_ST_SH_1			S5P_HDMI_I2S_BASE(0x040)
#define S5P_HDMI_I2S_CH_ST_SH_2			S5P_HDMI_I2S_BASE(0x044)
#define S5P_HDMI_I2S_CH_ST_SH_3			S5P_HDMI_I2S_BASE(0x048)
#define S5P_HDMI_I2S_CH_ST_SH_4			S5P_HDMI_I2S_BASE(0x04c)
#define S5P_HDMI_I2S_VD_DATA			S5P_HDMI_I2S_BASE(0x050)
#define S5P_HDMI_I2S_MUX_CH			S5P_HDMI_I2S_BASE(0x054)
#define S5P_HDMI_I2S_MUX_CUV			S5P_HDMI_I2S_BASE(0x058)
#define S5P_HDMI_I2S_IRQ_MASK			S5P_HDMI_I2S_BASE(0x05c)
#define S5P_HDMI_I2S_IRQ_STATUS			S5P_HDMI_I2S_BASE(0x060)

/* HDMITGregister */
#define S5P_HDMI_TG_CMD				S5P_HDMI_TG_BASE(0x000)
#define S5P_HDMI_TG_CFG				S5P_HDMI_TG_BASE(0x004)
#define S5P_HDMI_TG_CB_SZ			S5P_HDMI_TG_BASE(0x008)
#define S5P_HDMI_TG_INDELAY_L			S5P_HDMI_TG_BASE(0x00c)
#define S5P_HDMI_TG_INDELAY_H			S5P_HDMI_TG_BASE(0x010)
#define S5P_HDMI_TG_POL_CTRL			S5P_HDMI_TG_BASE(0x014)
#define S5P_HDMI_TG_H_FSZ_L			S5P_HDMI_TG_BASE(0x018)
#define S5P_HDMI_TG_H_FSZ_H			S5P_HDMI_TG_BASE(0x01c)
#define S5P_HDMI_TG_HACT_ST_L			S5P_HDMI_TG_BASE(0x020)
#define S5P_HDMI_TG_HACT_ST_H			S5P_HDMI_TG_BASE(0x024)
#define S5P_HDMI_TG_HACT_SZ_L			S5P_HDMI_TG_BASE(0x028)
#define S5P_HDMI_TG_HACT_SZ_H			S5P_HDMI_TG_BASE(0x02c)
#define S5P_HDMI_TG_V_FSZ_L			S5P_HDMI_TG_BASE(0x030)
#define S5P_HDMI_TG_V_FSZ_H			S5P_HDMI_TG_BASE(0x034)
#define S5P_HDMI_TG_VSYNC_L			S5P_HDMI_TG_BASE(0x038)
#define S5P_HDMI_TG_VSYNC_H			S5P_HDMI_TG_BASE(0x03c)
#define S5P_HDMI_TG_VSYNC2_L			S5P_HDMI_TG_BASE(0x040)
#define S5P_HDMI_TG_VSYNC2_H			S5P_HDMI_TG_BASE(0x044)
#define S5P_HDMI_TG_VACT_ST_L			S5P_HDMI_TG_BASE(0x048)
#define S5P_HDMI_TG_VACT_ST_H			S5P_HDMI_TG_BASE(0x04c)
#define S5P_HDMI_TG_VACT_SZ_L			S5P_HDMI_TG_BASE(0x050)
#define S5P_HDMI_TG_VACT_SZ_H			S5P_HDMI_TG_BASE(0x054)
#define S5P_HDMI_TG_FIELD_CHG_L			S5P_HDMI_TG_BASE(0x058)
#define S5P_HDMI_TG_FIELD_CHG_H			S5P_HDMI_TG_BASE(0x05c)
#define S5P_HDMI_TG_VACT_ST2_L			S5P_HDMI_TG_BASE(0x060)
#define S5P_HDMI_TG_VACT_ST2_H			S5P_HDMI_TG_BASE(0x064)

#define S5P_HDMI_TG_VACT_ST3_L			S5P_HDMI_TG_BASE(0x068)
#define S5P_HDMI_TG_VACT_ST3_H			S5P_HDMI_TG_BASE(0x06c)
#define S5P_HDMI_TG_VACT_ST4_L			S5P_HDMI_TG_BASE(0x070)
#define S5P_HDMI_TG_VACT_ST4_H			S5P_HDMI_TG_BASE(0x074)

#define S5P_HDMI_TG_VSYNC_TOP_HDMI_L		S5P_HDMI_TG_BASE(0x078)
#define S5P_HDMI_TG_VSYNC_TOP_HDMI_H		S5P_HDMI_TG_BASE(0x07c)
#define S5P_HDMI_TG_VSYNC_BOT_HDMI_L		S5P_HDMI_TG_BASE(0x080)
#define S5P_HDMI_TG_VSYNC_BOT_HDMI_H		S5P_HDMI_TG_BASE(0x084)
#define S5P_HDMI_TG_FIELD_TOP_HDMI_L		S5P_HDMI_TG_BASE(0x088)
#define S5P_HDMI_TG_FIELD_TOP_HDMI_H		S5P_HDMI_TG_BASE(0x08c)
#define S5P_HDMI_TG_FIELD_BOT_HDMI_L		S5P_HDMI_TG_BASE(0x090)
#define S5P_HDMI_TG_FIELD_BOT_HDMI_H		S5P_HDMI_TG_BASE(0x094)

#define S5P_HDMI_TG_3D				S5P_HDMI_TG_BASE(0x0F0)

#define S5P_HDMI_MHL_HSYNC_WIDTH		S5P_HDMI_TG_BASE(0x17C)
#define S5P_HDMI_MHL_VSYNC_WIDTH		S5P_HDMI_TG_BASE(0x180)
#define S5P_HDMI_MHL_CLK_INV			S5P_HDMI_TG_BASE(0x184)

/* HDMIE-FUSEregiseter */
#define S5P_HDMI_EFUSE_CTRL			S5P_HDMI_EFUSE_BASE(0x000)
#define S5P_HDMI_EFUSE_STATUS			S5P_HDMI_EFUSE_BASE(0x004)
#define S5P_HDMI_EFUSE_ADDR_WIDTH		S5P_HDMI_EFUSE_BASE(0x008)
#define S5P_HDMI_EFUSE_SIGDEV_ASSERT		S5P_HDMI_EFUSE_BASE(0x00c)
#define S5P_HDMI_EFUSE_SIGDEV_DEASSERT		S5P_HDMI_EFUSE_BASE(0x010)
#define S5P_HDMI_EFUSE_PRCHG_ASSERT		S5P_HDMI_EFUSE_BASE(0x014)
#define S5P_HDMI_EFUSE_PRCHG_DEASSERT		S5P_HDMI_EFUSE_BASE(0x018)
#define S5P_HDMI_EFUSE_FSET_ASSERT		S5P_HDMI_EFUSE_BASE(0x01c)
#define S5P_HDMI_EFUSE_FSET_DEASSERT		S5P_HDMI_EFUSE_BASE(0x020)
#define S5P_HDMI_EFUSE_SENSING			S5P_HDMI_EFUSE_BASE(0x024)
#define S5P_HDMI_EFUSE_SCK_ASSERT		S5P_HDMI_EFUSE_BASE(0x028)
#define S5P_HDMI_EFUSE_SCK_DEASSERT		S5P_HDMI_EFUSE_BASE(0x02c)
#define S5P_HDMI_EFUSE_SDOUT_OFFSET		S5P_HDMI_EFUSE_BASE(0x030)
#define S5P_HDMI_EFUSE_READ_OFFSET		S5P_HDMI_EFUSE_BASE(0x034)
#else

#define S5P_HDMI_I2C_PHY_BASE(x)		(x)

#define HDMI_I2C_CON				S5P_HDMI_I2C_PHY_BASE(0x0000)
#define HDMI_I2C_STAT				S5P_HDMI_I2C_PHY_BASE(0x0004)
#define HDMI_I2C_ADD				S5P_HDMI_I2C_PHY_BASE(0x0008)
#define HDMI_I2C_DS				S5P_HDMI_I2C_PHY_BASE(0x000c)
#define HDMI_I2C_LC				S5P_HDMI_I2C_PHY_BASE(0x0010)

#define S5P_HDMI_CTRL_BASE(x)			(x)
#define S5P_HDMI_BASE(x)			((x) + 0x00010000)
#define S5P_HDMI_SPDIF_BASE(x)			((x) + 0x00030000)
#define S5P_HDMI_I2S_BASE(x)			((x) + 0x00040000)
#define S5P_HDMI_TG_BASE(x)			((x) + 0x00050000)
#define S5P_HDMI_EFUSE_BASE(x)			((x) + 0x00060000)

#define S5P_HDMI_INTC_CON			S5P_HDMI_CTRL_BASE(0x0000)
#define S5P_HDMI_INTC_FLAG			S5P_HDMI_CTRL_BASE(0x0004)
#define S5P_HDMI_HDCP_KEY_LOAD			S5P_HDMI_CTRL_BASE(0x0008)
#define S5P_HDMI_HPD_STATUS			S5P_HDMI_CTRL_BASE(0x000C)
#define S5P_HDMI_AUDIO_CLKSEL			S5P_HDMI_CTRL_BASE(0x0010)
#define S5P_HDMI_PHY_RSTOUT			S5P_HDMI_CTRL_BASE(0x0014)
#define S5P_HDMI_PHY_VPLL			S5P_HDMI_CTRL_BASE(0x0018)
#define S5P_HDMI_PHY_CMU			S5P_HDMI_CTRL_BASE(0x001C)
#define S5P_HDMI_CORE_RSTOUT			S5P_HDMI_CTRL_BASE(0x0020)

#define S5P_HDMI_CON_0				S5P_HDMI_BASE(0x0000)
#define S5P_HDMI_CON_1				S5P_HDMI_BASE(0x0004)
#define S5P_HDMI_CON_2				S5P_HDMI_BASE(0x0008)
#define S5P_HDMI_SYS_STATUS			S5P_HDMI_BASE(0x0010)
#define S5P_HDMI_PHY_STATUS			S5P_HDMI_BASE(0x0014)
#define S5P_HDMI_STATUS_EN			S5P_HDMI_BASE(0x0020)
#define S5P_HDMI_HPD				S5P_HDMI_BASE(0x0030)
#define S5P_HDMI_MODE_SEL			S5P_HDMI_BASE(0x0040)
#define S5P_HDMI_ENC_EN				S5P_HDMI_BASE(0x0044)

#define S5P_HDMI_BLUE_SCREEN_0			S5P_HDMI_BASE(0x0050)
#define S5P_HDMI_BLUE_SCREEN_1			S5P_HDMI_BASE(0x0054)
#define S5P_HDMI_BLUE_SCREEN_2			S5P_HDMI_BASE(0x0058)

#define S5P_HDMI_YMAX				S5P_HDMI_BASE(0x0060)
#define S5P_HDMI_YMIN				S5P_HDMI_BASE(0x0064)
#define S5P_HDMI_CMAX				S5P_HDMI_BASE(0x0068)
#define S5P_HDMI_CMIN				S5P_HDMI_BASE(0x006C)

#define S5P_HDMI_H_BLANK_0			S5P_HDMI_BASE(0x00A0)
#define S5P_HDMI_H_BLANK_1			S5P_HDMI_BASE(0x00A4)
#define S5P_HDMI_V_BLANK_0			S5P_HDMI_BASE(0x00B0)
#define S5P_HDMI_V_BLANK_1			S5P_HDMI_BASE(0x00B4)
#define S5P_HDMI_V_BLANK_2			S5P_HDMI_BASE(0x00B8)
#define S5P_HDMI_H_V_LINE_0			S5P_HDMI_BASE(0x00C0)
#define S5P_HDMI_H_V_LINE_1			S5P_HDMI_BASE(0x00C4)
#define S5P_HDMI_H_V_LINE_2			S5P_HDMI_BASE(0x00C8)

#define S5P_HDMI_SYNC_MODE			S5P_HDMI_BASE(0x00E4)
#define S5P_HDMI_INT_PRO_MODE			S5P_HDMI_BASE(0x00E8)

#define S5P_HDMI_V_BLANK_F_0			S5P_HDMI_BASE(0x0110)
#define S5P_HDMI_V_BLANK_F_1			S5P_HDMI_BASE(0x0114)
#define S5P_HDMI_V_BLANK_F_2			S5P_HDMI_BASE(0x0118)
#define S5P_HDMI_H_SYNC_GEN_0			S5P_HDMI_BASE(0x0120)
#define S5P_HDMI_H_SYNC_GEN_1			S5P_HDMI_BASE(0x0124)
#define S5P_HDMI_H_SYNC_GEN_2			S5P_HDMI_BASE(0x0128)
#define S5P_HDMI_V_SYNC_GEN_1_0			S5P_HDMI_BASE(0x0130)
#define S5P_HDMI_V_SYNC_GEN_1_1			S5P_HDMI_BASE(0x0134)
#define S5P_HDMI_V_SYNC_GEN_1_2			S5P_HDMI_BASE(0x0138)
#define S5P_HDMI_V_SYNC_GEN_2_0			S5P_HDMI_BASE(0x0140)
#define S5P_HDMI_V_SYNC_GEN_2_1			S5P_HDMI_BASE(0x0144)
#define S5P_HDMI_V_SYNC_GEN_2_2			S5P_HDMI_BASE(0x0148)
#define S5P_HDMI_V_SYNC_GEN_3_0			S5P_HDMI_BASE(0x0150)
#define S5P_HDMI_V_SYNC_GEN_3_1			S5P_HDMI_BASE(0x0154)
#define S5P_HDMI_V_SYNC_GEN_3_2			S5P_HDMI_BASE(0x0158)

#define S5P_HDMI_ASP_CON			S5P_HDMI_BASE(0x0160)
#define S5P_HDMI_ASP_SP_FLAT			S5P_HDMI_BASE(0x0164)
#define S5P_HDMI_ASP_CHCFG0			S5P_HDMI_BASE(0x0170)
#define S5P_HDMI_ASP_CHCFG1			S5P_HDMI_BASE(0x0174)
#define S5P_HDMI_ASP_CHCFG2			S5P_HDMI_BASE(0x0178)
#define S5P_HDMI_ASP_CHCFG3			S5P_HDMI_BASE(0x017C)

#define S5P_HDMI_ACR_CON			S5P_HDMI_BASE(0x0180)
#define S5P_HDMI_ACR_MCTS0			S5P_HDMI_BASE(0x0184)
#define S5P_HDMI_ACR_MCTS1			S5P_HDMI_BASE(0x0188)
#define S5P_HDMI_ACR_MCTS2			S5P_HDMI_BASE(0x018C)
#define S5P_HDMI_ACR_CTS0			S5P_HDMI_BASE(0x0190)
#define S5P_HDMI_ACR_CTS1			S5P_HDMI_BASE(0x0194)
#define S5P_HDMI_ACR_CTS2			S5P_HDMI_BASE(0x0198)
#define S5P_HDMI_ACR_N0				S5P_HDMI_BASE(0x01A0)
#define S5P_HDMI_ACR_N1				S5P_HDMI_BASE(0x01A4)
#define S5P_HDMI_ACR_N2				S5P_HDMI_BASE(0x01A8)
#define S5P_HDMI_ACR_LSB2			S5P_HDMI_BASE(0x01B0)
#define S5P_HDMI_ACR_TXCNT			S5P_HDMI_BASE(0x01B4)
#define S5P_HDMI_ACR_TXINTERVAL			S5P_HDMI_BASE(0x01B8)
#define S5P_HDMI_ACR_CTS_OFFSET			S5P_HDMI_BASE(0x01BC)

#define S5P_HDMI_GCP_CON			S5P_HDMI_BASE(0x01C0)
#define S5P_HDMI_GCP_BYTE1			S5P_HDMI_BASE(0x01D0)
#define S5P_HDMI_GCP_BYTE2			S5P_HDMI_BASE(0x01D4)
#define S5P_HDMI_GCP_BYTE3			S5P_HDMI_BASE(0x01D8)

#define S5P_HDMI_ACP_CON			S5P_HDMI_BASE(0x01E0)
#define S5P_HDMI_ACP_TYPE			S5P_HDMI_BASE(0x01E4)
#define S5P_HDMI_ACP_DATA			S5P_HDMI_BASE(0x0200)

#define S5P_HDMI_ISRC_CON			S5P_HDMI_BASE(0x0250)
#define S5P_HDMI_ISRC1_HEADER1			S5P_HDMI_BASE(0x0264)
#define S5P_HDMI_ISRC1_DATA			S5P_HDMI_BASE(0x0270)
#define S5P_HDMI_ISRC2_DATA			S5P_HDMI_BASE(0x02b0)

#define S5P_HDMI_AVI_CON			S5P_HDMI_BASE(0x0300)
#define S5P_HDMI_AVI_CHECK_SUM			S5P_HDMI_BASE(0x0310)
#define S5P_HDMI_AVI_DATA			S5P_HDMI_BASE(0x0320)

#define S5P_HDMI_AUI_CON			S5P_HDMI_BASE(0x0360)
#define S5P_HDMI_AUI_CHECK_SUM			S5P_HDMI_BASE(0x0370)

#define S5P_HDMI_AUI_BYTE1			S5P_HDMI_BASE(0x0380)
#define S5P_HDMI_AUI_BYTE2			S5P_HDMI_BASE(0x0384)
#define S5P_HDMI_AUI_BYTE3			S5P_HDMI_BASE(0x0388)
#define S5P_HDMI_AUI_BYTE4			S5P_HDMI_BASE(0x038c)
#define S5P_HDMI_AUI_BYTE5			S5P_HDMI_BASE(0x0390)

#define S5P_HDMI_MPG_CON			S5P_HDMI_BASE(0x03A0)
#define S5P_HDMI_MPG_CHECK_SUM			S5P_HDMI_BASE(0x03B0)
#define S5P_HDMI_MPG_DATA			S5P_HDMI_BASE(0x03c0)

#define S5P_HDMI_SPD_CON			S5P_HDMI_BASE(0x0400)
#define S5P_HDMI_SPD_HEADER			S5P_HDMI_BASE(0x0410)
#define S5P_HDMI_SPD_DATA			S5P_HDMI_BASE(0x0420)

#define S5P_HDMI_HDCP_RX_SHA1_0_0		S5P_HDMI_BASE(0x0600)
#define S5P_HDMI_HDCP_RX_SHA1_0_1		S5P_HDMI_BASE(0x0604)
#define S5P_HDMI_HDCP_RX_SHA1_0_2		S5P_HDMI_BASE(0x0608)
#define S5P_HDMI_HDCP_RX_SHA1_0_3		S5P_HDMI_BASE(0x060C)
#define S5P_HDMI_HDCP_RX_SHA1_1_0		S5P_HDMI_BASE(0x0610)
#define S5P_HDMI_HDCP_RX_SHA1_1_1		S5P_HDMI_BASE(0x0614)
#define S5P_HDMI_HDCP_RX_SHA1_1_2		S5P_HDMI_BASE(0x0618)
#define S5P_HDMI_HDCP_RX_SHA1_1_3		S5P_HDMI_BASE(0x061C)
#define S5P_HDMI_HDCP_RX_SHA1_2_0		S5P_HDMI_BASE(0x0620)
#define S5P_HDMI_HDCP_RX_SHA1_2_1		S5P_HDMI_BASE(0x0624)
#define S5P_HDMI_HDCP_RX_SHA1_2_2		S5P_HDMI_BASE(0x0628)
#define S5P_HDMI_HDCP_RX_SHA1_2_3		S5P_HDMI_BASE(0x062C)
#define S5P_HDMI_HDCP_RX_SHA1_3_0		S5P_HDMI_BASE(0x0630)
#define S5P_HDMI_HDCP_RX_SHA1_3_1		S5P_HDMI_BASE(0x0634)
#define S5P_HDMI_HDCP_RX_SHA1_3_2		S5P_HDMI_BASE(0x0638)
#define S5P_HDMI_HDCP_RX_SHA1_3_3		S5P_HDMI_BASE(0x063C)
#define S5P_HDMI_HDCP_RX_SHA1_4_0		S5P_HDMI_BASE(0x0640)
#define S5P_HDMI_HDCP_RX_SHA1_4_1		S5P_HDMI_BASE(0x0644)
#define S5P_HDMI_HDCP_RX_SHA1_4_2		S5P_HDMI_BASE(0x0648)
#define S5P_HDMI_HDCP_RX_SHA1_4_3		S5P_HDMI_BASE(0x064C)

#define S5P_HDMI_HDCP_RX_KSV_0_0		S5P_HDMI_BASE(0x0650)
#define S5P_HDMI_HDCP_RX_KSV_0_1		S5P_HDMI_BASE(0x0654)
#define S5P_HDMI_HDCP_RX_KSV_0_2		S5P_HDMI_BASE(0x0658)
#define S5P_HDMI_HDCP_RX_KSV_0_3		S5P_HDMI_BASE(0x065C)
#define S5P_HDMI_HDCP_RX_KSV_0_4		S5P_HDMI_BASE(0x0660)

#define S5P_HDMI_HDCP_KSV_LIST_CON		S5P_HDMI_BASE(0x0664)
#define S5P_HDMI_HDCP_SHA_RESULT		S5P_HDMI_BASE(0x0670)
#define S5P_HDMI_HDCP_CTRL1			S5P_HDMI_BASE(0x0680)
#define S5P_HDMI_HDCP_CTRL2			S5P_HDMI_BASE(0x0684)
#define S5P_HDMI_HDCP_CHECK_RESULT		S5P_HDMI_BASE(0x0690)

#define S5P_HDMI_HDCP_BKSV_0_0			S5P_HDMI_BASE(0x06A0)
#define S5P_HDMI_HDCP_BKSV_0_1			S5P_HDMI_BASE(0x06A4)
#define S5P_HDMI_HDCP_BKSV_0_2			S5P_HDMI_BASE(0x06A8)
#define S5P_HDMI_HDCP_BKSV_0_3			S5P_HDMI_BASE(0x06AC)
#define S5P_HDMI_HDCP_BKSV_1			S5P_HDMI_BASE(0x06B0)

#define S5P_HDMI_HDCP_AKSV_0_0			S5P_HDMI_BASE(0x06C0)
#define S5P_HDMI_HDCP_AKSV_0_1			S5P_HDMI_BASE(0x06C4)
#define S5P_HDMI_HDCP_AKSV_0_2			S5P_HDMI_BASE(0x06C8)
#define S5P_HDMI_HDCP_AKSV_0_3			S5P_HDMI_BASE(0x06CC)
#define S5P_HDMI_HDCP_AKSV_1			S5P_HDMI_BASE(0x06D0)

#define S5P_HDMI_HDCP_An_0_0			S5P_HDMI_BASE(0x06E0)
#define S5P_HDMI_HDCP_An_0_1			S5P_HDMI_BASE(0x06E4)
#define S5P_HDMI_HDCP_An_0_2			S5P_HDMI_BASE(0x06E8)
#define S5P_HDMI_HDCP_An_0_3			S5P_HDMI_BASE(0x06EC)
#define S5P_HDMI_HDCP_An_1_0			S5P_HDMI_BASE(0x06F0)
#define S5P_HDMI_HDCP_An_1_1			S5P_HDMI_BASE(0x06F4)
#define S5P_HDMI_HDCP_An_1_2			S5P_HDMI_BASE(0x06F8)
#define S5P_HDMI_HDCP_An_1_3			S5P_HDMI_BASE(0x06FC)

#define S5P_HDMI_HDCP_BCAPS			S5P_HDMI_BASE(0x0700)
#define S5P_HDMI_HDCP_BSTATUS_0			S5P_HDMI_BASE(0x0710)
#define S5P_HDMI_HDCP_BSTATUS_1			S5P_HDMI_BASE(0x0714)
#define S5P_HDMI_HDCP_Ri_0			S5P_HDMI_BASE(0x0740)
#define S5P_HDMI_HDCP_Ri_1			S5P_HDMI_BASE(0x0744)

#define S5P_HDMI_HDCP_I2C_INT			S5P_HDMI_BASE(0x0780)
#define S5P_HDMI_HDCP_AN_INT			S5P_HDMI_BASE(0x0790)
#define S5P_HDMI_HDCP_WDT_INT			S5P_HDMI_BASE(0x07a0)
#define S5P_HDMI_HDCP_RI_INT			S5P_HDMI_BASE(0x07b0)

#define S5P_HDMI_HDCP_RI_COMPARE_0		S5P_HDMI_BASE(0x07d0)
#define S5P_HDMI_HDCP_RI_COMPARE_1		S5P_HDMI_BASE(0x07d4)
#define S5P_HDMI_HDCP_FRAME_COUNT		S5P_HDMI_BASE(0x07e0)

#define S5P_HDMI_GAMUT_CON			S5P_HDMI_BASE(0x0500)
#define S5P_HDMI_GAMUT_HEADER0			S5P_HDMI_BASE(0x0504)
#define S5P_HDMI_GAMUT_HEADER1			S5P_HDMI_BASE(0x0508)
#define S5P_HDMI_GAMUT_HEADER2			S5P_HDMI_BASE(0x050c)
#define S5P_HDMI_GAMUT_DATA			S5P_HDMI_BASE(0x0510)

#define S5P_HDMI_DC_CONTROL			S5P_HDMI_BASE(0x05C0)
#define S5P_HDMI_VIDEO_PATTERN_GEN		S5P_HDMI_BASE(0x05C4)
#define S5P_HDMI_HPD_GEN			S5P_HDMI_BASE(0x05C8)

#define S5P_HDMI_SPDIFIN_CLK_CTRL		S5P_HDMI_SPDIF_BASE(0x0000)
#define S5P_HDMI_SPDIFIN_OP_CTRL		S5P_HDMI_SPDIF_BASE(0x0004)
#define S5P_HDMI_SPDIFIN_IRQ_MASK		S5P_HDMI_SPDIF_BASE(0x0008)
#define S5P_HDMI_SPDIFIN_IRQ_STATUS		S5P_HDMI_SPDIF_BASE(0x000C)
#define S5P_HDMI_SPDIFIN_CONFIG_1		S5P_HDMI_SPDIF_BASE(0x0010)
#define S5P_HDMI_SPDIFIN_CONFIG_2		S5P_HDMI_SPDIF_BASE(0x0014)
#define S5P_HDMI_SPDIFIN_USER_VALUE_1		S5P_HDMI_SPDIF_BASE(0x0020)
#define S5P_HDMI_SPDIFIN_USER_VALUE_2		S5P_HDMI_SPDIF_BASE(0x0024)
#define S5P_HDMI_SPDIFIN_USER_VALUE_3		S5P_HDMI_SPDIF_BASE(0x0028)
#define S5P_HDMI_SPDIFIN_USER_VALUE_4		S5P_HDMI_SPDIF_BASE(0x002C)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_1		S5P_HDMI_SPDIF_BASE(0x0030)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_2		S5P_HDMI_SPDIF_BASE(0x0034)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_3		S5P_HDMI_SPDIF_BASE(0x0038)
#define S5P_HDMI_SPDIFIN_CH_STATUS_0_4		S5P_HDMI_SPDIF_BASE(0x003C)
#define S5P_HDMI_SPDIFIN_CH_STATUS_1		S5P_HDMI_SPDIF_BASE(0x0040)
#define S5P_HDMI_SPDIFIN_FRAME_PERIOD_1		S5P_HDMI_SPDIF_BASE(0x0048)
#define S5P_HDMI_SPDIFIN_FRAME_PERIOD_2		S5P_HDMI_SPDIF_BASE(0x004C)
#define S5P_HDMI_SPDIFIN_Pc_INFO_1		S5P_HDMI_SPDIF_BASE(0x0050)
#define S5P_HDMI_SPDIFIN_Pc_INFO_2		S5P_HDMI_SPDIF_BASE(0x0054)
#define S5P_HDMI_SPDIFIN_Pd_INFO_1		S5P_HDMI_SPDIF_BASE(0x0058)
#define S5P_HDMI_SPDIFIN_Pd_INFO_2		S5P_HDMI_SPDIF_BASE(0x005C)
#define S5P_HDMI_SPDIFIN_DATA_BUF_0_1		S5P_HDMI_SPDIF_BASE(0x0060)
#define S5P_HDMI_SPDIFIN_DATA_BUF_0_2		S5P_HDMI_SPDIF_BASE(0x0064)
#define S5P_HDMI_SPDIFIN_DATA_BUF_0_3		S5P_HDMI_SPDIF_BASE(0x0068)
#define S5P_HDMI_SPDIFIN_USER_BUF_0		S5P_HDMI_SPDIF_BASE(0x006C)
#define S5P_HDMI_SPDIFIN_DATA_BUF_1_1		S5P_HDMI_SPDIF_BASE(0x0070)
#define S5P_HDMI_SPDIFIN_DATA_BUF_1_2		S5P_HDMI_SPDIF_BASE(0x0074)
#define S5P_HDMI_SPDIFIN_DATA_BUF_1_3		S5P_HDMI_SPDIF_BASE(0x0078)
#define S5P_HDMI_SPDIFIN_USER_BUF_1		S5P_HDMI_SPDIF_BASE(0x007C)

#define S5P_HDMI_I2S_CLK_CON			S5P_HDMI_I2S_BASE(0x0000)
#define S5P_HDMI_I2S_CON_1			S5P_HDMI_I2S_BASE(0x0004)
#define S5P_HDMI_I2S_CON_2			S5P_HDMI_I2S_BASE(0x0008)
#define S5P_HDMI_I2S_PIN_SEL_0			S5P_HDMI_I2S_BASE(0x000C)
#define S5P_HDMI_I2S_PIN_SEL_1			S5P_HDMI_I2S_BASE(0x0010)
#define S5P_HDMI_I2S_PIN_SEL_2			S5P_HDMI_I2S_BASE(0x0014)
#define S5P_HDMI_I2S_PIN_SEL_3			S5P_HDMI_I2S_BASE(0x0018)
#define S5P_HDMI_I2S_DSD_CON			S5P_HDMI_I2S_BASE(0x001C)
#define S5P_HDMI_I2S_MUX_CON			S5P_HDMI_I2S_BASE(0x0020)
#define S5P_HDMI_I2S_CH_ST_CON			S5P_HDMI_I2S_BASE(0x0024)
#define S5P_HDMI_I2S_CH_ST_0			S5P_HDMI_I2S_BASE(0x0028)
#define S5P_HDMI_I2S_CH_ST_1			S5P_HDMI_I2S_BASE(0x002C)
#define S5P_HDMI_I2S_CH_ST_2			S5P_HDMI_I2S_BASE(0x0030)
#define S5P_HDMI_I2S_CH_ST_3			S5P_HDMI_I2S_BASE(0x0034)
#define S5P_HDMI_I2S_CH_ST_4			S5P_HDMI_I2S_BASE(0x0038)
#define S5P_HDMI_I2S_CH_ST_SH_0			S5P_HDMI_I2S_BASE(0x003C)
#define S5P_HDMI_I2S_CH_ST_SH_1			S5P_HDMI_I2S_BASE(0x0040)
#define S5P_HDMI_I2S_CH_ST_SH_2			S5P_HDMI_I2S_BASE(0x0044)
#define S5P_HDMI_I2S_CH_ST_SH_3			S5P_HDMI_I2S_BASE(0x0048)
#define S5P_HDMI_I2S_CH_ST_SH_4			S5P_HDMI_I2S_BASE(0x004C)
#define S5P_HDMI_I2S_VD_DATA			S5P_HDMI_I2S_BASE(0x0050)
#define S5P_HDMI_I2S_MUX_CH			S5P_HDMI_I2S_BASE(0x0054)
#define S5P_HDMI_I2S_MUX_CUV			S5P_HDMI_I2S_BASE(0x0058)
#define S5P_HDMI_I2S_IRQ_MASK			S5P_HDMI_I2S_BASE(0x005C)
#define S5P_HDMI_I2S_IRQ_STATUS			S5P_HDMI_I2S_BASE(0x0060)
#define S5P_HDMI_I2S_CH0_L_0			S5P_HDMI_I2S_BASE(0x0064)
#define S5P_HDMI_I2S_CH0_L_1			S5P_HDMI_I2S_BASE(0x0068)
#define S5P_HDMI_I2S_CH0_L_2			S5P_HDMI_I2S_BASE(0x006C)
#define S5P_HDMI_I2S_CH0_L_3			S5P_HDMI_I2S_BASE(0x0070)
#define S5P_HDMI_I2S_CH0_R_0			S5P_HDMI_I2S_BASE(0x0074)
#define S5P_HDMI_I2S_CH0_R_1			S5P_HDMI_I2S_BASE(0x0078)
#define S5P_HDMI_I2S_CH0_R_2			S5P_HDMI_I2S_BASE(0x007C)
#define S5P_HDMI_I2S_CH0_R_3			S5P_HDMI_I2S_BASE(0x0080)
#define S5P_HDMI_I2S_CH1_L_0			S5P_HDMI_I2S_BASE(0x0084)
#define S5P_HDMI_I2S_CH1_L_1			S5P_HDMI_I2S_BASE(0x0088)
#define S5P_HDMI_I2S_CH1_L_2			S5P_HDMI_I2S_BASE(0x008C)
#define S5P_HDMI_I2S_CH1_L_3			S5P_HDMI_I2S_BASE(0x0090)
#define S5P_HDMI_I2S_CH1_R_0			S5P_HDMI_I2S_BASE(0x0094)
#define S5P_HDMI_I2S_CH1_R_1			S5P_HDMI_I2S_BASE(0x0098)
#define S5P_HDMI_I2S_CH1_R_2			S5P_HDMI_I2S_BASE(0x009C)
#define S5P_HDMI_I2S_CH1_R_3			S5P_HDMI_I2S_BASE(0x00A0)
#define S5P_HDMI_I2S_CH2_L_0			S5P_HDMI_I2S_BASE(0x00A4)
#define S5P_HDMI_I2S_CH2_L_1			S5P_HDMI_I2S_BASE(0x00A8)
#define S5P_HDMI_I2S_CH2_L_2			S5P_HDMI_I2S_BASE(0x00AC)
#define S5P_HDMI_I2S_CH2_L_3			S5P_HDMI_I2S_BASE(0x00B0)
#define S5P_HDMI_I2S_CH2_R_0			S5P_HDMI_I2S_BASE(0x00B4)
#define S5P_HDMI_I2S_CH2_R_1			S5P_HDMI_I2S_BASE(0x00B8)
#define S5P_HDMI_I2S_CH2_R_2			S5P_HDMI_I2S_BASE(0x00BC)
#define S5P_HDMI_I2S_Ch2_R_3			S5P_HDMI_I2S_BASE(0x00C0)
#define S5P_HDMI_I2S_CH3_L_0			S5P_HDMI_I2S_BASE(0x00C4)
#define S5P_HDMI_I2S_CH3_L_1			S5P_HDMI_I2S_BASE(0x00C8)
#define S5P_HDMI_I2S_CH3_L_2			S5P_HDMI_I2S_BASE(0x00CC)
#define S5P_HDMI_I2S_CH3_R_0			S5P_HDMI_I2S_BASE(0x00D0)
#define S5P_HDMI_I2S_CH3_R_1			S5P_HDMI_I2S_BASE(0x00D4)
#define S5P_HDMI_I2S_CH3_R_2			S5P_HDMI_I2S_BASE(0x00D8)
#define S5P_HDMI_I2S_CUV_L_R			S5P_HDMI_I2S_BASE(0x00DC)

#define S5P_HDMI_TG_CMD				S5P_HDMI_TG_BASE(0x0000)
#define S5P_HDMI_TG_H_FSZ_L			S5P_HDMI_TG_BASE(0x0018)
#define S5P_HDMI_TG_H_FSZ_H			S5P_HDMI_TG_BASE(0x001C)
#define S5P_HDMI_TG_HACT_ST_L			S5P_HDMI_TG_BASE(0x0020)
#define S5P_HDMI_TG_HACT_ST_H			S5P_HDMI_TG_BASE(0x0024)
#define S5P_HDMI_TG_HACT_SZ_L			S5P_HDMI_TG_BASE(0x0028)
#define S5P_HDMI_TG_HACT_SZ_H			S5P_HDMI_TG_BASE(0x002C)
#define S5P_HDMI_TG_V_FSZ_L			S5P_HDMI_TG_BASE(0x0030)
#define S5P_HDMI_TG_V_FSZ_H			S5P_HDMI_TG_BASE(0x0034)
#define S5P_HDMI_TG_VSYNC_L			S5P_HDMI_TG_BASE(0x0038)
#define S5P_HDMI_TG_VSYNC_H			S5P_HDMI_TG_BASE(0x003C)
#define S5P_HDMI_TG_VSYNC2_L			S5P_HDMI_TG_BASE(0x0040)
#define S5P_HDMI_TG_VSYNC2_H			S5P_HDMI_TG_BASE(0x0044)
#define S5P_HDMI_TG_VACT_ST_L			S5P_HDMI_TG_BASE(0x0048)
#define S5P_HDMI_TG_VACT_ST_H			S5P_HDMI_TG_BASE(0x004C)
#define S5P_HDMI_TG_VACT_SZ_L			S5P_HDMI_TG_BASE(0x0050)
#define S5P_HDMI_TG_VACT_SZ_H			S5P_HDMI_TG_BASE(0x0054)
#define S5P_HDMI_TG_FIELD_CHG_L			S5P_HDMI_TG_BASE(0x0058)
#define S5P_HDMI_TG_FIELD_CHG_H			S5P_HDMI_TG_BASE(0x005C)
#define S5P_HDMI_TG_VACT_ST2_L			S5P_HDMI_TG_BASE(0x0060)
#define S5P_HDMI_TG_VACT_ST2_H			S5P_HDMI_TG_BASE(0x0064)

#define S5P_HDMI_TG_VSYNC_TOP_HDMI_L		S5P_HDMI_TG_BASE(0x0078)
#define S5P_HDMI_TG_VSYNC_TOP_HDMI_H		S5P_HDMI_TG_BASE(0x007C)
#define S5P_HDMI_TG_VSYNC_BOT_HDMI_L		S5P_HDMI_TG_BASE(0x0080)
#define S5P_HDMI_TG_VSYNC_BOT_HDMI_H		S5P_HDMI_TG_BASE(0x0084)
#define S5P_HDMI_TG_FIELD_TOP_HDMI_L		S5P_HDMI_TG_BASE(0x0088)
#define S5P_HDMI_TG_FIELD_TOP_HDMI_H		S5P_HDMI_TG_BASE(0x008C)
#define S5P_HDMI_TG_FIELD_BOT_HDMI_L		S5P_HDMI_TG_BASE(0x0090)
#define S5P_HDMI_TG_FIELD_BOT_HDMI_H		S5P_HDMI_TG_BASE(0x0094)

#define S5P_HDMI_EFUSE_CTRL			S5P_HDMI_EFUSE_BASE(0x0000)
#define S5P_HDMI_EFUSE_STATUS			S5P_HDMI_EFUSE_BASE(0x0004)
#define S5P_HDMI_EFUSE_ADDR_WIDTH		S5P_HDMI_EFUSE_BASE(0x0008)
#define S5P_HDMI_EFUSE_SIGDEV_ASSERT		S5P_HDMI_EFUSE_BASE(0x000c)
#define S5P_HDMI_EFUSE_SIGDEV_DEASSERT		S5P_HDMI_EFUSE_BASE(0x0010)
#define S5P_HDMI_EFUSE_PRCHG_ASSERT		S5P_HDMI_EFUSE_BASE(0x0014)
#define S5P_HDMI_EFUSE_PRCHG_DEASSERT		S5P_HDMI_EFUSE_BASE(0x0018)
#define S5P_HDMI_EFUSE_FSET_ASSERT		S5P_HDMI_EFUSE_BASE(0x001c)
#define S5P_HDMI_EFUSE_FSET_DEASSERT		S5P_HDMI_EFUSE_BASE(0x0020)
#define S5P_HDMI_EFUSE_SENSING			S5P_HDMI_EFUSE_BASE(0x0024)
#define S5P_HDMI_EFUSE_SCK_ASSERT		S5P_HDMI_EFUSE_BASE(0x0028)
#define S5P_HDMI_EFUSE_SCK_DEASSERT		S5P_HDMI_EFUSE_BASE(0x002c)
#define S5P_HDMI_EFUSE_SDOUT_OFFSET		S5P_HDMI_EFUSE_BASE(0x0030)
#define S5P_HDMI_EFUSE_READ_OFFSET		S5P_HDMI_EFUSE_BASE(0x0034)
#endif

#define S5P_HDMI_AUI_SZ				5
#define S5P_HDMI_GCP_SZ				3
#define S5P_HDMI_SPD_SZ				28
#define S5P_HDMI_AVI_SZ				13
#define S5P_HDMI_MPG_SZ				5
#define S5P_HDMI_GMU_SX				28
#define S5P_HDMI_ISRC_SZ			16
#define S5P_HDMI_ACP_SZ				17

/*
 * Bit definition part
 */

/* Control Register */

/* INTC_CON */
#define S5P_HDMI_INTC_ACT_HI			(1 << 7)
#define S5P_HDMI_INTC_ACT_LOW			(0 << 7)
#define S5P_HDMI_INTC_EN_GLOBAL			(1 << 6)
#define S5P_HDMI_INTC_DIS_GLOBAL		(0 << 6)
#define S5P_HDMI_INTC_EN_I2S			(1 << 5)
#define S5P_HDMI_INTC_DIS_I2S			(0 << 5)
#define S5P_HDMI_INTC_EN_CEC			(1 << 4)
#define S5P_HDMI_INTC_DIS_CEC			(0 << 4)
#define S5P_HDMI_INTC_EN_HPD_PLUG		(1 << 3)
#define S5P_HDMI_INTC_DIS_HPD_PLUG		(0 << 3)
#define S5P_HDMI_INTC_EN_HPD_UNPLUG		(1 << 2)
#define S5P_HDMI_INTC_DIS_HPD_UNPLUG		(0 << 2)
#define S5P_HDMI_INTC_EN_SPDIF			(1 << 1)
#define S5P_HDMI_INTC_DIS_SPDIF			(0 << 1)
#define S5P_HDMI_INTC_EN_HDCP			(1 << 0)
#define S5P_HDMI_INTC_DIS_HDCP			(0 << 0)

/* INTC_FLAG */
#define S5P_HDMI_INTC_FLAG_I2S			(1 << 5)
#define S5P_HDMI_INTC_FLAG_CEC			(1 << 4)
#define S5P_HDMI_INTC_FLAG_HPD_PLUG		(1 << 3)
#define S5P_HDMI_INTC_FLAG_HPD_UNPLUG		(1 << 2)
#define S5P_HDMI_INTC_FLAG_SPDIF		(1 << 1)
#define S5P_HDMI_INTC_FLAG_HDCP			(1 << 0)

/* HDCP_KEY_LOAD_DONE */
#define S5P_HDMI_HDCP_KEY_LOAD_DONE		(1 << 0)

/* HPD_STATUS */
#define S5P_HDMI_HPD_PLUGED			(1 << 0)

/* AUDIO_CLKSEL */
#define S5P_HDMI_AUDIO_SPDIF_CLK		(1 << 0)
#define S5P_HDMI_AUDIO_PCLK			(0 << 0)

/* HDMI_PHY_RSTOUT */
#define S5P_HDMI_PHY_SW_RSTOUT			(1 << 0)

/* HDMI_PHY_VPLL */
#define S5P_HDMI_PHY_VPLL_LOCK			(1 << 7)
#define S5P_HDMI_PHY_VPLL_CODE_MASK		(0x7 << 0)

/* HDMI_PHY_CMU */
#define S5P_HDMI_PHY_CMU_LOCK			(1 << 7)
#define S5P_HDMI_PHY_CMU_CODE_MASK		(0x7 << 0)

/* HDMI_CORE_RSTOUT */
#define S5P_HDMI_CORE_SW_RSTOUT			(1 << 0)

/* Core Register */

/* HDMI_CON_0 */
#define S5P_HDMI_BLUE_SCR_EN			(1 << 5)
#define S5P_HDMI_BLUE_SCR_DIS			(0 << 5)
#define S5P_HDMI_ENC_OPTION			(1 << 4)
#define S5P_HDMI_ASP_EN				(1 << 2)
#define S5P_HDMI_ASP_DIS			(0 << 2)
#define S5P_HDMI_PWDN_ENB_NORMAL		(1 << 1)
#define S5P_HDMI_PWDN_ENB_PD			(0 << 1)
#define S5P_HDMI_EN				(1 << 0)
#define S5P_HDMI_DIS				(~(1 << 0))

/* HDMI_CON_1 */
#define S5P_HDMI_PX_LMT_CTRL_BYPASS		(0 << 5)
#define S5P_HDMI_PX_LMT_CTRL_RGB		(1 << 5)
#define S5P_HDMI_PX_LMT_CTRL_YPBPR		(2 << 5)
#define S5P_HDMI_PX_LMT_CTRL_RESERVED		(3 << 5)
#define S5P_HDMI_CON_PXL_REP_RATIO_MASK		(1 << 1 | 1 << 0)
#define S5P_HDMI_DOUBLE_PIXEL_REPETITION	(0x01)

/* HDMI_CON_2 */
#define S5P_HDMI_VID_PREAMBLE_EN		(0 << 5)
#define S5P_HDMI_VID_PREAMBLE_DIS		(1 << 5)
#define S5P_HDMI_GUARD_BAND_EN			(0 << 1)
#define S5P_HDMI_GUARD_BAND_DIS			(1 << 1)

/* STATUS */
#define S5P_HDMI_AUTHEN_ACK_AUTH		(1 << 7)
#define S5P_HDMI_AUTHEN_ACK_NOT			(0 << 7)
#define S5P_HDMI_AUD_FIFO_OVF_FULL		(1 << 6)
#define S5P_HDMI_AUD_FIFO_OVF_NOT		(0 << 6)
#define S5P_HDMI_UPDATE_RI_INT_OCC		(1 << 4)
#define S5P_HDMI_UPDATE_RI_INT_NOT		(0 << 4)
#define S5P_HDMI_UPDATE_RI_INT_CLEAR		(1 << 4)
#define S5P_HDMI_UPDATE_PJ_INT_OCC		(1 << 3)
#define S5P_HDMI_UPDATE_PJ_INT_NOT		(0 << 3)
#define S5P_HDMI_UPDATE_PJ_INT_CLEAR		(1 << 3)
#define S5P_HDMI_WRITE_INT_OCC			(1 << 2)
#define S5P_HDMI_WRITE_INT_NOT			(0 << 2)
#define S5P_HDMI_WRITE_INT_CLEAR		(1 << 2)
#define S5P_HDMI_WATCHDOG_INT_OCC		(1 << 1)
#define S5P_HDMI_WATCHDOG_INT_NOT		(0 << 1)
#define S5P_HDMI_WATCHDOG_INT_CLEAR		(1 << 1)
#define S5P_HDMI_WTFORACTIVERX_INT_OCC		(1)
#define S5P_HDMI_WTFORACTIVERX_INT_NOT		(0)
#define S5P_HDMI_WTFORACTIVERX_INT_CLEAR	(1)

/* PHY_STATUS */
#define S5P_HDMI_PHY_STATUS_READY		(1)

/* STATUS_EN */
#define S5P_HDMI_AUD_FIFO_OVF_EN		(1 << 6)
#define S5P_HDMI_AUD_FIFO_OVF_DIS		(0 << 6)
#define S5P_HDMI_UPDATE_RI_INT_EN		(1 << 4)
#define S5P_HDMI_UPDATE_RI_INT_DIS		(0 << 4)
#define S5P_HDMI_UPDATE_PJ_INT_EN		(1 << 3)
#define S5P_HDMI_UPDATE_PJ_INT_DIS		(0 << 3)
#define S5P_HDMI_WRITE_INT_EN			(1 << 2)
#define S5P_HDMI_WRITE_INT_DIS			(0 << 2)
#define S5P_HDMI_WATCHDOG_INT_EN		(1 << 1)
#define S5P_HDMI_WATCHDOG_INT_DIS		(0 << 1)
#define S5P_HDMI_WTFORACTIVERX_INT_EN		(1)
#define S5P_HDMI_WTFORACTIVERX_INT_DIS		(0)
#define S5P_HDMI_INT_EN_ALL			(S5P_HDMI_UPDATE_RI_INT_EN|\
						S5P_HDMI_UPDATE_PJ_INT_DIS|\
						S5P_HDMI_WRITE_INT_EN|\
						S5P_HDMI_WATCHDOG_INT_EN|\
						S5P_HDMI_WTFORACTIVERX_INT_EN)
#define S5P_HDMI_INT_DIS_ALL			(~0x1F)

/* HPD */
#define S5P_HDMI_SW_HPD_PLUGGED			(1 << 1)
#define S5P_HDMI_SW_HPD_UNPLUGGED		(0 << 1)
#define S5P_HDMI_HPD_SEL_I_HPD			(1)
#define S5P_HDMI_HPD_SEL_SW_HPD			(0)

/* MODE_SEL */
#define S5P_HDMI_MODE_EN			(1 << 1)
#define S5P_HDMI_MODE_DIS			(0 << 1)
#define S5P_HDMI_DVI_MODE_EN			(1)
#define S5P_HDMI_DVI_MODE_DIS			(0)

/* ENC_EN */
#define S5P_HDMI_HDCP_ENC_ENABLE		(1)
#define S5P_HDMI_HDCP_ENC_DISABLE		(0)

/* Video Related Register */

/* BLUESCREEN_0/1/2 */

/* HDMI_YMAX/YMIN/CMAX/CMIN */

/* H_BLANK_0/1 */

/* V_BLANK_0/1/2 */

/* H_V_LINE_0/1/2 */

/* VSYNC_POL */
#define S5P_HDMI_V_SYNC_POL_ACT_LOW		(1)
#define S5P_HDMI_V_SYNC_POL_ACT_HIGH		(0)

/* INT_PRO_MODE */
#define S5P_HDMI_INTERLACE_MODE			(1)
#define S5P_HDMI_PROGRESSIVE_MODE		(0)

/* V_BLANK_F_0/1/2 */

/* H_SYNC_GEN_0/1/2 */

/* V_SYNC_GEN1_0/1/2 */

/* V_SYNC_GEN2_0/1/2 */

/* V_SYNC_GEN3_0/1/2 */

/* Audio Related Packet Register */

/* ASP_CON */
#define S5P_HDMI_AUD_DST_DOUBLE			(1 << 7)
#define S5P_HDMI_AUD_NO_DST_DOUBLE		(0 << 7)
#define S5P_HDMI_AUD_TYPE_SAMPLE		(0 << 5)
#define S5P_HDMI_AUD_TYPE_ONE_BIT		(1 << 5)
#define S5P_HDMI_AUD_TYPE_HBR			(2 << 5)
#define S5P_HDMI_AUD_TYPE_DST			(3 << 5)
#define S5P_HDMI_AUD_MODE_TWO_CH		(0 << 4)
#define S5P_HDMI_AUD_MODE_MULTI_CH		(1 << 4)
#define S5P_HDMI_AUD_SP_AUD3_EN			(1 << 3)
#define S5P_HDMI_AUD_SP_AUD2_EN			(1 << 2)
#define S5P_HDMI_AUD_SP_AUD1_EN			(1 << 1)
#define S5P_HDMI_AUD_SP_AUD0_EN			(1 << 0)
#define S5P_HDMI_AUD_SP_ALL_DIS			(0 << 0)

#define S5P_HDMI_AUD_SET_SP_PRE(x)		((x) & 0xF)

/* ASP_SP_FLAT */
#define S5P_HDMI_ASP_SP_FLAT_AUD_SAMPLE		(0)

/* ASP_CHCFG0/1/2/3 */
#define S5P_HDMI_SPK3R_SEL_I_PCM0L		(0 << 27)
#define S5P_HDMI_SPK3R_SEL_I_PCM0R		(1 << 27)
#define S5P_HDMI_SPK3R_SEL_I_PCM1L		(2 << 27)
#define S5P_HDMI_SPK3R_SEL_I_PCM1R		(3 << 27)
#define S5P_HDMI_SPK3R_SEL_I_PCM2L		(4 << 27)
#define S5P_HDMI_SPK3R_SEL_I_PCM2R		(5 << 27)
#define S5P_HDMI_SPK3R_SEL_I_PCM3L		(6 << 27)
#define S5P_HDMI_SPK3R_SEL_I_PCM3R		(7 << 27)
#define S5P_HDMI_SPK3L_SEL_I_PCM0L		(0 << 24)
#define S5P_HDMI_SPK3L_SEL_I_PCM0R		(1 << 24)
#define S5P_HDMI_SPK3L_SEL_I_PCM1L		(2 << 24)
#define S5P_HDMI_SPK3L_SEL_I_PCM1R		(3 << 24)
#define S5P_HDMI_SPK3L_SEL_I_PCM2L		(4 << 24)
#define S5P_HDMI_SPK3L_SEL_I_PCM2R		(5 << 24)
#define S5P_HDMI_SPK3L_SEL_I_PCM3L		(6 << 24)
#define S5P_HDMI_SPK3L_SEL_I_PCM3R		(7 << 24)
#define S5P_HDMI_SPK2R_SEL_I_PCM0L		(0 << 19)
#define S5P_HDMI_SPK2R_SEL_I_PCM0R		(1 << 19)
#define S5P_HDMI_SPK2R_SEL_I_PCM1L		(2 << 19)
#define S5P_HDMI_SPK2R_SEL_I_PCM1R		(3 << 19)
#define S5P_HDMI_SPK2R_SEL_I_PCM2L		(4 << 19)
#define S5P_HDMI_SPK2R_SEL_I_PCM2R		(5 << 19)
#define S5P_HDMI_SPK2R_SEL_I_PCM3L		(6 << 19)
#define S5P_HDMI_SPK2R_SEL_I_PCM3R		(7 << 19)
#define S5P_HDMI_SPK2L_SEL_I_PCM0L		(0 << 16)
#define S5P_HDMI_SPK2L_SEL_I_PCM0R		(1 << 16)
#define S5P_HDMI_SPK2L_SEL_I_PCM1L		(2 << 16)
#define S5P_HDMI_SPK2L_SEL_I_PCM1R		(3 << 16)
#define S5P_HDMI_SPK2L_SEL_I_PCM2L		(4 << 16)
#define S5P_HDMI_SPK2L_SEL_I_PCM2R		(5 << 16)
#define S5P_HDMI_SPK2L_SEL_I_PCM3L		(6 << 16)
#define S5P_HDMI_SPK2L_SEL_I_PCM3R		(7 << 16)
#define S5P_HDMI_SPK1R_SEL_I_PCM0L		(0 << 11)
#define S5P_HDMI_SPK1R_SEL_I_PCM0R		(1 << 11)
#define S5P_HDMI_SPK1R_SEL_I_PCM1L		(2 << 11)
#define S5P_HDMI_SPK1R_SEL_I_PCM1R		(3 << 11)
#define S5P_HDMI_SPK1R_SEL_I_PCM2L		(4 << 11)
#define S5P_HDMI_SPK1R_SEL_I_PCM2R		(5 << 11)
#define S5P_HDMI_SPK1R_SEL_I_PCM3L		(6 << 11)
#define S5P_HDMI_SPK1R_SEL_I_PCM3R		(7 << 11)
#define S5P_HDMI_SPK1L_SEL_I_PCM0L		(0 << 8)
#define S5P_HDMI_SPK1L_SEL_I_PCM0R		(1 << 8)
#define S5P_HDMI_SPK1L_SEL_I_PCM1L		(2 << 8)
#define S5P_HDMI_SPK1L_SEL_I_PCM1R		(3 << 8)
#define S5P_HDMI_SPK1L_SEL_I_PCM2L		(4 << 8)
#define S5P_HDMI_SPK1L_SEL_I_PCM2R		(5 << 8)
#define S5P_HDMI_SPK1L_SEL_I_PCM3L		(6 << 8)
#define S5P_HDMI_SPK1L_SEL_I_PCM3R		(7 << 8)
#define S5P_HDMI_SPK0R_SEL_I_PCM0L		(0 << 3)
#define S5P_HDMI_SPK0R_SEL_I_PCM0R		(1 << 3)
#define S5P_HDMI_SPK0R_SEL_I_PCM1L		(2 << 3)
#define S5P_HDMI_SPK0R_SEL_I_PCM1R		(3 << 3)
#define S5P_HDMI_SPK0R_SEL_I_PCM2L		(4 << 3)
#define S5P_HDMI_SPK0R_SEL_I_PCM2R		(5 << 3)
#define S5P_HDMI_SPK0R_SEL_I_PCM3L		(6 << 3)
#define S5P_HDMI_SPK0R_SEL_I_PCM3R		(7 << 3)
#define S5P_HDMI_SPK0L_SEL_I_PCM0L		(0)
#define S5P_HDMI_SPK0L_SEL_I_PCM0R		(1)
#define S5P_HDMI_SPK0L_SEL_I_PCM1L		(2)
#define S5P_HDMI_SPK0L_SEL_I_PCM1R		(3)
#define S5P_HDMI_SPK0L_SEL_I_PCM2L		(4)
#define S5P_HDMI_SPK0L_SEL_I_PCM2R		(5)
#define S5P_HDMI_SPK0L_SEL_I_PCM3L		(6)
#define S5P_HDMI_SPK0L_SEL_I_PCM3R		(7)

/* ACR_CON */
#define S5P_HDMI_ALT_CTS_RATE_CTS_1		(0 << 3)
#define S5P_HDMI_ALT_CTS_RATE_CTS_11		(1 << 3)
#define S5P_HDMI_ALT_CTS_RATE_CTS_21		(2 << 3)
#define S5P_HDMI_ALT_CTS_RATE_CTS_31		(3 << 3)
#define S5P_HDMI_ACR_TX_MODE_NO_TX		(0)
#define S5P_HDMI_ACR_TX_MODE_TX_ONCE		(1)
#define S5P_HDMI_ACR_TX_MODE_TXCNT_VBI		(2)
#define S5P_HDMI_ACR_TX_MODE_TX_VPC		(3)
#define S5P_HDMI_ACR_TX_MODE_MESURE_CTS		(4)

/* ACR_MCTS0/1/2 */

/* ACR_CTS0/1/2 */

/* ACR_N0/1/2 */

/* ACR_LSB2 */
#define S5P_HDMI_ACR_LSB2_MASK			(0xFF)

/* ACR_TXCNT */
#define S5P_HDMI_ACR_TXCNT_MASK			(0x1F)

/* ACR_TXINTERNAL */
#define S5P_HDMI_ACR_TX_INTERNAL_MASK		(0xFF)

/* ACR_CTS_OFFSET */
#define S5P_HDMI_ACR_CTS_OFFSET_MASK		(0xFF)

/* GCP_CON */
#define S5P_HDMI_GCP_CON_EN_1ST_VSYNC		(1 << 3)
#define S5P_HDMI_GCP_CON_EN_2ST_VSYNC		(1 << 2)
#define S5P_HDMI_GCP_CON_TRANS_EVERY_VSYNC	(2)
#define S5P_HDMI_GCP_CON_NO_TRAN		(0)
#define S5P_HDMI_GCP_CON_TRANS_ONCE		(1)
#define S5P_HDMI_GCP_CON_TRANS_EVERY_VSYNC	(2)

/* GCP_BYTE1 */
#define S5P_HDMI_GCP_BYTE1_MASK			(0xFF)

/* GCP_BYTE2 */
#define S5P_HDMI_GCP_BYTE2_PP_MASK		(0xF << 4)
#define S5P_HDMI_GCP_24BPP			(1 << 2)
#define S5P_HDMI_GCP_30BPP			(1 << 0 | 1 << 2)
#define S5P_HDMI_GCP_36BPP			(1 << 1 | 1 << 2)
#define S5P_HDMI_GCP_48BPP			(1 << 0 | 1 << 1 | 1 << 2)

/* GCP_BYTE3 */
#define S5P_HDMI_GCP_BYTE3_MASK			(0xFF)

/* ACP Packet Register */

/* ACP_CON */
#define S5P_HDMI_ACP_FR_RATE_MASK		(0x1F << 3)
#define S5P_HDMI_ACP_CON_NO_TRAN		(0)
#define S5P_HDMI_ACP_CON_TRANS_ONCE		(1)
#define S5P_HDMI_ACP_CON_TRANS_EVERY_VSYNC	(2)

/* ACP_TYPE */
#define S5P_HDMI_ACP_TYPE_MASK			(0xFF)

/* ACP_DATA00~16 */
#define S5P_HDMI_ACP_DATA_MASK			(0xFF)

/* ISRC1/2 Packet Register */

/* ISRC_CON */
#define S5P_HDMI_ISRC_FR_RATE_MASK		(0x1F << 3)
#define S5P_HDMI_ISRC_EN			(1 << 2)
#define S5P_HDMI_ISRC_DIS			(0 << 2)

/* ISRC1_HEADER1 */
#define S5P_HDMI_ISRC1_HEADER_MASK		(0xFF)

/* ISRC1_DATA 00~15 */
#define S5P_HDMI_ISRC1_DATA_MASK		(0xFF)

/* ISRC2_DATA 00~15 */
#define S5P_HDMI_ISRC2_DATA_MASK		(0xFF)

/* AVI InfoFrame Register */

/* AVI_CON */

/* AVI_CHECK_SUM */

/* AVI_DATA01~13 */
#define S5P_HDMI_AVI_PIXEL_REPETITION_DOUBLE	(1<<0)
#define S5P_HDMI_AVI_PICTURE_ASPECT_4_3		(1<<4)
#define S5P_HDMI_AVI_PICTURE_ASPECT_16_9	(1<<5)

/* Audio InfoFrame Register */

/* AUI_CON */

/* AUI_CHECK_SUM */

/* AUI_DATA1~5 */

/* MPEG Source InfoFrame registers */

/* MPG_CON */

/* HDMI_MPG_CHECK_SUM */

/* MPG_DATA1~5 */

/* Source Product Descriptor Infoframe registers */

/* SPD_CON */

/* SPD_HEADER0/1/2 */

/* SPD_DATA0~27 */

/* HDCP Register */

/* HDCP_SHA1_00~19 */

/* HDCP_KSV_LIST_0~4 */

/* HDCP_KSV_LIST_CON */
#define S5P_HDMI_HDCP_KSV_WRITE_DONE		(0x1 << 3)
#define S5P_HDMI_HDCP_KSV_LIST_EMPTY		(0x1 << 2)
#define S5P_HDMI_HDCP_KSV_END			(0x1 << 1)
#define S5P_HDMI_HDCP_KSV_READ			(0x1 << 0)

/* HDCP_CTRL1 */
#define S5P_HDMI_HDCP_EN_PJ_EN			(1 << 4)
#define S5P_HDMI_HDCP_EN_PJ_DIS			(~(1 << 4))
#define S5P_HDMI_HDCP_SET_REPEATER_TIMEOUT	(1 << 2)
#define S5P_HDMI_HDCP_CLEAR_REPEATER_TIMEOUT	(~(1 << 2))
#define S5P_HDMI_HDCP_CP_DESIRED_EN		(1 << 1)
#define S5P_HDMI_HDCP_CP_DESIRED_DIS		(~(1 << 1))
#define S5P_HDMI_HDCP_ENABLE_1_1_FEATURE_EN	(1)
#define S5P_HDMI_HDCP_ENABLE_1_1_FEATURE_DIS	(~(1))

/* HDCP_CHECK_RESULT */
#define S5P_HDMI_HDCP_Pi_MATCH_RESULT_Y		((0x1 << 3) | (0x1 << 2))
#define S5P_HDMI_HDCP_Pi_MATCH_RESULT_N		((0x1 << 3) | (0x0 << 2))
#define S5P_HDMI_HDCP_Ri_MATCH_RESULT_Y		((0x1 << 1) | (0x1 << 0))
#define S5P_HDMI_HDCP_Ri_MATCH_RESULT_N		((0x1 << 1) | (0x0 << 0))
#define S5P_HDMI_HDCP_CLR_ALL_RESULTS		(0)

/* HDCP_BKSV0~4 */
/* HDCP_AKSV0~4 */

/* HDCP_BCAPS */
#define S5P_HDMI_HDCP_BCAPS_REPEATER		(1 << 6)
#define S5P_HDMI_HDCP_BCAPS_READY		(1 << 5)
#define S5P_HDMI_HDCP_BCAPS_FAST		(1 << 4)
#define S5P_HDMI_HDCP_BCAPS_1_1_FEATURES	(1 << 1)
#define S5P_HDMI_HDCP_BCAPS_FAST_REAUTH		(1)

/* HDCP_BSTATUS_0/1 */
/* HDCP_Ri_0/1 */
/* HDCP_I2C_INT */
/* HDCP_AN_INT */
/* HDCP_WATCHDOG_INT */
/* HDCP_RI_INT/1 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_1 */
/* HDCP_Frame_Count */

/* Gamut Metadata Packet Register */

/* GAMUT_CON */
/* GAMUT_HEADER0 */
/* GAMUT_HEADER1 */
/* GAMUT_HEADER2 */
/* GAMUT_METADATA0~27 */

/* Video Mode Register */

/* VIDEO_PATTERN_GEN */
/* HPD_GEN */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */
/* HDCP_Ri_Compare_0 */

/* SPDIF Register */

/* SPDIFIN_CLK_CTRL */
#define S5P_HDMI_SPDIFIN_READY_CLK_DOWN		(1 << 1)
#define S5P_HDMI_SPDIFIN_CLK_ON			(1)

/* SPDIFIN_OP_CTRL */
#define S5P_HDMI_SPDIFIN_SW_RESET		(0)
#define S5P_HDMI_SPDIFIN_STATUS_CHECK_MODE	(1)
#define S5P_HDMI_SPDIFIN_STATUS_CHK_OP_MODE	(3)

/* SPDIFIN_IRQ_MASK */

/* SPDIFIN_IRQ_STATUS */
#define S5P_HDMI_SPDIFIN_IRQ_OVERFLOW_EN			(1 << 7)
#define S5P_HDMI_SPDIFIN_IRQ_ABNORMAL_PD_EN			(1 << 6)
#define S5P_HDMI_SPDIFIN_IRQ_SH_NOT_DETECTED_RIGHTTIME_EN	(1 << 5)
#define S5P_HDMI_SPDIFIN_IRQ_SH_DETECTED_EN			(1 << 4)
#define S5P_HDMI_SPDIFIN_IRQ_SH_NOT_DETECTED_EN			(1 << 3)
#define S5P_HDMI_SPDIFIN_IRQ_WRONG_PREAMBLE_EN			(1 << 2)
#define S5P_HDMI_SPDIFIN_IRQ_CH_STATUS_RECOVERED_EN		(1 << 1)
#define S5P_HDMI_SPDIFIN_IRQ_WRONG_SIG_EN			(1 << 0)

/* SPDIFIN_CONFIG_1 */
#define S5P_HDMI_SPDIFIN_CFG_FILTER_3_SAMPLE			(0 << 6)
#define S5P_HDMI_SPDIFIN_CFG_FILTER_2_SAMPLE			(1 << 6)
#define S5P_HDMI_SPDIFIN_CFG_LINEAR_PCM_TYPE			(0 << 5)
#define S5P_HDMI_SPDIFIN_CFG_NO_LINEAR_PCM_TYPE			(1 << 5)
#define S5P_HDMI_SPDIFIN_CFG_PCPD_AUTO_SET			(0 << 4)
#define S5P_HDMI_SPDIFIN_CFG_PCPD_MANUAL_SET			(1 << 4)
#define S5P_HDMI_SPDIFIN_CFG_WORD_LENGTH_A_SET			(0 << 3)
#define S5P_HDMI_SPDIFIN_CFG_WORD_LENGTH_M_SET			(1 << 3)
#define S5P_HDMI_SPDIFIN_CFG_U_V_C_P_NEGLECT			(0 << 2)
#define S5P_HDMI_SPDIFIN_CFG_U_V_C_P_REPORT			(1 << 2)
#define S5P_HDMI_SPDIFIN_CFG_BURST_SIZE_1			(0 << 1)
#define S5P_HDMI_SPDIFIN_CFG_BURST_SIZE_2			(1 << 1)
#define S5P_HDMI_SPDIFIN_CFG_DATA_ALIGN_16BIT			(0 << 0)
#define S5P_HDMI_SPDIFIN_CFG_DATA_ALIGN_32BIT			(1 << 0)

/* SPDIFIN_CONFIG_2 */
#define S5P_HDMI_SPDIFIN_CFG2_NO_CLK_DIV			(0)

/* SPDIFIN_USER_VALUE_1 */
/* SPDIFIN_USER_VALUE_2 */
/* SPDIFIN_USER_VALUE_3 */
/* SPDIFIN_USER_VALUE_4 */
/* SPDIFIN_CH_STATUS_0_1 */
/* SPDIFIN_CH_STATUS_0_2 */
/* SPDIFIN_CH_STATUS_0_3 */
/* SPDIFIN_CH_STATUS_0_4 */
/* SPDIFIN_CH_STATUS_1 */
/* SPDIFIN_FRAME_PERIOD_1 */
/* SPDIFIN_FRAME_PERIOD_2 */
/* SPDIFIN_PC_INFO_1 */
/* SPDIFIN_PC_INFO_2 */
/* SPDIFIN_PD_INFO_1 */
/* SPDIFIN_PD_INFO_2 */
/* SPDIFIN_DATA_BUF_0_1 */
/* SPDIFIN_DATA_BUF_0_2 */
/* SPDIFIN_DATA_BUF_0_3 */
/* SPDIFIN_USER_BUF_0 */
/* SPDIFIN_USER_BUF_1_1 */
/* SPDIFIN_USER_BUF_1_2 */
/* SPDIFIN_USER_BUF_1_3 */
/* SPDIFIN_USER_BUF_1 */

/* I2S Register */

/* I2S_CLK_CON */
#define S5P_HDMI_I2S_CLK_DIS			(0)
#define S5P_HDMI_I2S_CLK_EN			(1)

/* I2S_CON_1 */
#define S5P_HDMI_I2S_SCLK_FALLING_EDGE		(0 << 1)
#define S5P_HDMI_I2S_SCLK_RISING_EDGE		(1 << 1)
#define S5P_HDMI_I2S_L_CH_LOW_POL		(0)
#define S5P_HDMI_I2S_L_CH_HIGH_POL		(1)

/* I2S_CON_2 */
#define S5P_HDMI_I2S_MSB_FIRST_MODE		(0 << 6)
#define S5P_HDMI_I2S_LSB_FIRST_MODE		(1 << 6)
#define S5P_HDMI_I2S_BIT_CH_32FS		(0 << 4)
#define S5P_HDMI_I2S_BIT_CH_48FS		(1 << 4)
#define S5P_HDMI_I2S_BIT_CH_RESERVED		(2 << 4)
#define S5P_HDMI_I2S_SDATA_16BIT		(1 << 2)
#define S5P_HDMI_I2S_SDATA_20BIT		(2 << 2)
#define S5P_HDMI_I2S_SDATA_24BIT		(3 << 2)
#define S5P_HDMI_I2S_BASIC_FORMAT		(0)
#define S5P_HDMI_I2S_L_JUST_FORMAT		(2)
#define S5P_HDMI_I2S_R_JUST_FORMAT		(3)
#define S5P_HDMI_I2S_CON_2_CLR			(~(0xFF))
#define S5P_HDMI_I2S_SET_BIT_CH(x)		(((x) & 0x7) << 4)
#define S5P_HDMI_I2S_SET_SDATA_BIT(x)		(((x) & 0x7) << 2)

/* I2S_PIN_SEL_0 */
#define S5P_HDMI_I2S_SEL_SCLK(x)		(((x) & 0x7) << 4)
#define S5P_HDMI_I2S_SEL_SCLK_DEFAULT_1		(0x7 << 4)
#define S5P_HDMI_I2S_SEL_LRCK(x)		((x) & 0x7)
#define S5P_HDMI_I2S_SEL_LRCK_DEFAULT_0		(0x7)

/* I2S_PIN_SEL_1 */
#define S5P_HDMI_I2S_SEL_SDATA1(x)		(((x) & 0x7) << 4)
#define S5P_HDMI_I2S_SEL_SDATA1_DEFAULT_3	(0x7 << 4)
#define S5P_HDMI_I2S_SEL_SDATA2(x)		((x) & 0x7)
#define S5P_HDMI_I2S_SEL_SDATA2_DEFAULT_2	(0x7)

/* I2S_PIN_SEL_2 */
#define S5P_HDMI_I2S_SEL_SDATA3(x)		(((x) & 0x7) << 4)
#define S5P_HDMI_I2S_SEL_SDATA3_DEFAULT_5	(0x7 << 4)
#define S5P_HDMI_I2S_SEL_SDATA2(x)		((x) & 0x7)
#define S5P_HDMI_I2S_SEL_SDATA2_DEFAULT_4	(0x7)

/* I2S_PIN_SEL_3 */
#define S5P_HDMI_I2S_SEL_DSD(x)			((x) & 0x7)
#define S5P_HDMI_I2S_SEL_DSD_DEFAULT_6		(0x7)

/* I2S_DSD_CON */
#define S5P_HDMI_I2S_DSD_CLK_RI_EDGE		(1 << 1)
#define S5P_HDMI_I2S_DSD_CLK_FA_EDGE		(0 << 1)
#define S5P_HDMI_I2S_DSD_ENABLE			(1)
#define S5P_HDMI_I2S_DSD_DISABLE		(0)

/* I2S_MUX_CON */
#define S5P_HDMI_I2S_NOISE_FILTER_ZERO		(0 << 5)
#define S5P_HDMI_I2S_NOISE_FILTER_2_STAGE	(1 << 5)
#define S5P_HDMI_I2S_NOISE_FILTER_3_STAGE	(2 << 5)
#define S5P_HDMI_I2S_NOISE_FILTER_4_STAGE	(3 << 5)
#define S5P_HDMI_I2S_NOISE_FILTER_5_STAGE	(4 << 5)
#define S5P_HDMI_I2S_IN_DISABLE			(1 << 4)
#define S5P_HDMI_I2S_IN_ENABLE			(0 << 4)
#define S5P_HDMI_I2S_AUD_SPDIF			(0 << 2)
#define S5P_HDMI_I2S_AUD_I2S			(1 << 2)
#define S5P_HDMI_I2S_AUD_DSD			(2 << 2)
#define S5P_HDMI_I2S_CUV_SPDIF_ENABLE		(0 << 1)
#define S5P_HDMI_I2S_CUV_I2S_ENABLE		(1 << 1)
#define S5P_HDMI_I2S_MUX_DISABLE		(0)
#define S5P_HDMI_I2S_MUX_ENABLE			(1)
#define S5P_HDMI_I2S_MUX_CON_CLR		(~(0xFF))

/* I2S_CH_ST_CON */
#define S5P_HDMI_I2S_CH_STATUS_RELOAD		(1)
#define S5P_HDMI_I2S_CH_ST_CON_CLR		(~(1))

/* I2S_CH_ST_0 / I2S_CH_ST_SH_0 */
#define S5P_HDMI_I2S_CH_STATUS_MODE_0		(0 << 6)
#define S5P_HDMI_I2S_2AUD_CH_WITHOUT_PREEMPH	(0 << 3)
#define S5P_HDMI_I2S_2AUD_CH_WITH_PREEMPH	(1 << 3)
#define S5P_HDMI_I2S_DEFAULT_EMPHASIS		(0 << 3)
#define S5P_HDMI_I2S_COPYRIGHT			(0 << 2)
#define S5P_HDMI_I2S_NO_COPYRIGHT		(1 << 2)
#define S5P_HDMI_I2S_LINEAR_PCM			(0 << 1)
#define S5P_HDMI_I2S_NO_LINEAR_PCM		(1 << 1)
#define S5P_HDMI_I2S_CONSUMER_FORMAT		(0)
#define S5P_HDMI_I2S_PROF_FORMAT		(1)
#define S5P_HDMI_I2S_CH_ST_0_CLR		(~(0xFF))

/* I2S_CH_ST_1 / I2S_CH_ST_SH_1 */
#define S5P_HDMI_I2S_CD_PLAYER			(0x00)
#define S5P_HDMI_I2S_DAT_PLAYER			(0x03)
#define S5P_HDMI_I2S_DCC_PLAYER			(0x43)
#define S5P_HDMI_I2S_MINI_DISC_PLAYER		(0x49)

/* I2S_CH_ST_2 / I2S_CH_ST_SH_2 */
#define S5P_HDMI_I2S_CHANNEL_NUM_MASK		(0xF << 4)
#define S5P_HDMI_I2S_SOURCE_NUM_MASK		(0xF)
#define S5P_HDMI_I2S_SET_CHANNEL_NUM(x)		(((x) & (0xF)) << 4)
#define S5P_HDMI_I2S_SET_SOURCE_NUM(x)		((x) & (0xF))

/* I2S_CH_ST_3 / I2S_CH_ST_SH_3 */
#define S5P_HDMI_I2S_CLK_ACCUR_LEVEL_1		(1 << 4)
#define S5P_HDMI_I2S_CLK_ACCUR_LEVEL_2		(0 << 4)
#define S5P_HDMI_I2S_CLK_ACCUR_LEVEL_3		(2 << 4)
#define S5P_HDMI_I2S_SAMPLING_FREQ_44_1		(0x0)
#define S5P_HDMI_I2S_SAMPLING_FREQ_48		(0x2)
#define S5P_HDMI_I2S_SAMPLING_FREQ_32		(0x3)
#define S5P_HDMI_I2S_SAMPLING_FREQ_96		(0xA)
#define S5P_HDMI_I2S_SET_SAMPLING_FREQ(x)	((x) & (0xF))

/* I2S_CH_ST_4 / I2S_CH_ST_SH_4 */
#define S5P_HDMI_I2S_ORG_SAMPLING_FREQ_44_1	(0xF << 4)
#define S5P_HDMI_I2S_ORG_SAMPLING_FREQ_88_2	(0x7 << 4)
#define S5P_HDMI_I2S_ORG_SAMPLING_FREQ_22_05	(0xB << 4)
#define S5P_HDMI_I2S_ORG_SAMPLING_FREQ_176_4	(0x3 << 4)
#define S5P_HDMI_I2S_WORD_LENGTH_NOT_DEFINE	(0x0 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX24_20BITS	(0x1 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX24_22BITS	(0x2 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX24_23BITS	(0x4 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX24_24BITS	(0x5 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX24_21BITS	(0x6 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX20_16BITS	(0x1 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX20_18BITS	(0x2 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX20_19BITS	(0x4 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX20_20BITS	(0x5 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX20_17BITS	(0x6 << 1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX_24BITS	(1)
#define S5P_HDMI_I2S_WORD_LENGTH_MAX_20BITS	(0)

/* I2S_VD_DATA */
#define S5P_HDMI_I2S_VD_AUD_SAMPLE_RELIABLE	(0)
#define S5P_HDMI_I2S_VD_AUD_SAMPLE_UNRELIABLE	(1)

/* I2S_MUX_CH */
#define S5P_HDMI_I2S_CH3_R_EN			(1 << 7)
#define S5P_HDMI_I2S_CH3_L_EN			(1 << 6)
#define S5P_HDMI_I2S_CH3_EN			(3 << 6)
#define S5P_HDMI_I2S_CH2_R_EN			(1 << 5)
#define S5P_HDMI_I2S_CH2_L_EN			(1 << 4)
#define S5P_HDMI_I2S_CH2_EN			(3 << 4)
#define S5P_HDMI_I2S_CH1_R_EN			(1 << 3)
#define S5P_HDMI_I2S_CH1_L_EN			(1 << 2)
#define S5P_HDMI_I2S_CH1_EN			(3 << 2)
#define S5P_HDMI_I2S_CH0_R_EN			(1 << 1)
#define S5P_HDMI_I2S_CH0_L_EN			(1)
#define S5P_HDMI_I2S_CH0_EN			(3)
#define S5P_HDMI_I2S_CH_ALL_EN			(0xFF)
#define S5P_HDMI_I2S_MUX_CH_CLR			(~S5P_HDMI_I2S_CH_ALL_EN)

/* I2S_MUX_CUV */
#define S5P_HDMI_I2S_CUV_R_EN			(1 << 1)
#define S5P_HDMI_I2S_CUV_L_EN			(1)
#define S5P_HDMI_I2S_CUV_RL_EN			(0x03)

/* I2S_IRQ_MASK */
#define S5P_HDMI_I2S_INT2_DIS			(0 << 1)
#define S5P_HDMI_I2S_INT2_EN			(1 << 1)

/* I2S_IRQ_STATUS */
#define S5P_HDMI_I2S_INT2_STATUS		(1 << 1)

/* I2S_CH0_L_0 */
/* I2S_CH0_L_1 */
/* I2S_CH0_L_2 */
/* I2S_CH0_L_3 */
/* I2S_CH0_R_0 */
/* I2S_CH0_R_1 */
/* I2S_CH0_R_2 */
/* I2S_CH0_R_3 */
/* I2S_CH1_L_0 */
/* I2S_CH1_L_1 */
/* I2S_CH1_L_2 */
/* I2S_CH1_L_3 */
/* I2S_CH1_R_0 */
/* I2S_CH1_R_1 */
/* I2S_CH1_R_2 */
/* I2S_CH1_R_3 */
/* I2S_CH2_L_0 */
/* I2S_CH2_L_1 */
/* I2S_CH2_L_2 */
/* I2S_CH2_L_3 */
/* I2S_CH2_R_0 */
/* I2S_CH2_R_1 */
/* I2S_CH2_R_2 */
/* I2S_Ch2_R_3 */
/* I2S_CH3_L_0 */
/* I2S_CH3_L_1 */
/* I2S_CH3_L_2 */
/* I2S_CH3_R_0 */
/* I2S_CH3_R_1 */
/* I2S_CH3_R_2 */

/* I2S_CUV_L_R */
#define S5P_HDMI_I2S_CUV_R_DATA_MASK		(0x7 << 4)
#define S5P_HDMI_I2S_CUV_L_DATA_MASK		(0x7)

/* Timing Generator Register */
/* TG_CMD */
#define S5P_HDMI_GETSYNC_TYPE			(1 << 4)
#define S5P_HDMI_GETSYNC			(1 << 3)
#define S5P_HDMI_FIELD				(1 << 1)
#define S5P_HDMI_TG				(1)

/* TG_CFG */
/* TG_CB_SZ */
/* TG_INDELAY_L */
/* TG_INDELAY_H */
/* TG_POL_CTRL */

/* TG_H_FSZ_L */
/* TG_H_FSZ_H */
/* TG_HACT_ST_L */
/* TG_HACT_ST_H */
/* TG_HACT_SZ_L */
/* TG_HACT_SZ_H */
/* TG_V_FSZ_L */
/* TG_V_FSZ_H */
/* TG_VSYNC_L */
/* TG_VSYNC_H */
/* TG_VSYNC2_L */
/* TG_VSYNC2_H */
/* TG_VACT_ST_L */
/* TG_VACT_ST_H */
/* TG_VACT_SZ_L */
/* TG_VACT_SZ_H */
/* TG_FIELD_CHG_L */
/* TG_FIELD_CHG_H */
/* TG_VACT_ST2_L */
/* TG_VACT_ST2_H */
/* TG_VACT_SC_ST_L */
/* TG_VACT_SC_ST_H */
/* TG_VACT_SC_SZ_L */
/* TG_VACT_SC_SZ_H */

/* TG_VSYNC_TOP_HDMI_L */
/* TG_VSYNC_TOP_HDMI_H */
/* TG_VSYNC_BOT_HDMI_L */
/* TG_VSYNC_BOT_HDMI_H */
/* TG_FIELD_TOP_HDMI_L */
/* TG_FIELD_TOP_HDMI_H */
/* TG_FIELD_BOT_HDMI_L */
/* TG_FIELD_BOT_HDMI_H */
/* TG_HSYNC_HDOUT_ST_L */
/* TG_HSYNC_HDOUT_ST_H */
/* TG_HSYNC_HDOUT_END_L */
/* TG_HSYNC_HDOUT_END_H */
/* TG_VSYNC_HDOUT_ST_L */
/* TG_VSYNC_HDOUT_ST_H */
/* TG_VSYNC_HDOUT_END_L */
/* TG_VSYNC_HDOUT_END_H */
/* TG_VSYNC_HDOUT_DLY_L */
/* TG_VSYNC_HDOUT_DLY_H */
/* TG_BT_ERR_RANGE */
/* TG_BT_ERR_RESULT */
/* TG_COR_THR */
/* TG_COR_NUM */
/* TG_BT_CON */
/* TG_BT_H_FSZ_L */
/* TG_BT_H_FSZ_H */
/* TG_BT_HSYNC_ST */
/* TG_BT_HSYNC_SZ */
/* TG_BT_FSZ_L */
/* TG_BT_FSZ_H */
/* TG_BT_VACT_T_ST_L */
/* TG_BT_VACT_T_ST_H */
/* TG_BT_VACT_B_ST_L */
/* TG_BT_VACT_B_ST_H */
/* TG_BT_VACT_SZ_L */
/* TG_BT_VACT_SZ_H */
/* TG_BT_VSYNC_SZ */

/* HDCP E-FUSE Control Register */
/* HDCP_E_FUSE_CTRL */
#define S5P_HDMI_EFUSE_CTRL_HDCP_KEY_READ	(1)

/* HDCP_E_FUSE_STATUS */
#define S5P_HDMI_EFUSE_ECC_FAIL			(1 << 2)
#define S5P_HDMI_EFUSE_ECC_BUSY			(1 << 1)
#define S5P_HDMI_EFUSE_ECC_DONE			(1)

/* EFUSE_ADDR_WIDTH */
/* EFUSE_SIGDEV_ASSERT */
/* EFUSE_SIGDEV_DE-ASSERT */
/* EFUSE_PRCHG_ASSERT */
/* EFUSE_PRCHG_DE-ASSERT */
/* EFUSE_FSET_ASSERT */
/* EFUSE_FSET_DE-ASSERT */
/* EFUSE_SENSING */
/* EFUSE_SCK_ASSERT */
/* EFUSE_SCK_DEASSERT */
/* EFUSE_SDOUT_OFFSET */
/* EFUSE_READ_OFFSET */

/* HDCP_SHA_RESULT */
#define S5P_HDMI_HDCP_SHA_VALID_NO_RD		(0 << 1)
#define S5P_HDMI_HDCP_SHA_VALID_RD		(1 << 1)
#define S5P_HDMI_HDCP_SHA_VALID			(1)
#define S5P_HDMI_HDCP_SHA_NO_VALID		(0)

/* DC_CONTRAL */
#define S5P_HDMI_DC_CTL_12			(1 << 1)
#define S5P_HDMI_DC_CTL_8			(0)
#define S5P_HDMI_DC_CTL_10			(1)
#endif	/* __ARCH_ARM_REGS_HDMI_H */
