#ifndef __MACH_GPIO_MIDAS_H
#define __MACH_GPIO_MIDAS_H __FILE__

#include <mach/gpio.h>

extern void midas_config_gpio_table(void);
extern void midas_config_sleep_gpio_table(void);

#define GPIO_eMMC_EN		EXYNOS4_GPK0(2)

#define GPIO_BOOT_MODE		EXYNOS4_GPX0(3)

#if defined(CONFIG_MFD_MAX14577)
#define GPIO_IF_PMIC_SDA	EXYNOS4_GPA0(6)
#define GPIO_IF_PMIC_SCL	EXYNOS4_GPA0(7)
#define GPIO_IF_PMIC_IRQ	EXYNOS4_GPX1(5)
#else
#define GPIO_FUEL_SDA		EXYNOS4_GPA0(6)
#define GPIO_FUEL_SCL		EXYNOS4_GPA0(7)
#define GPIO_CHG_INTB		EXYNOS4_GPX1(5)
#endif

#define GPIO_PMIC_SDA		EXYNOS4_GPB(2)
#define GPIO_PMIC_SCL		EXYNOS4_GPB(3)

#if 1
#define GPIO_SHUB_SPI_SCK	EXYNOS4_GPB(4)
#define GPIO_SHUB_SPI_SSN	EXYNOS4_GPB(5)
#define GPIO_SHUB_SPI_MISO	EXYNOS4_GPB(6)
#define GPIO_SHUB_SPI_MOSI	EXYNOS4_GPB(7)
#else
#define GPIO_CAM_SPI_SCLK	EXYNOS4_GPB(4)
#define GPIO_CAM_SPI_SSN	EXYNOS4_GPB(5)
#define GPIO_CAM_SPI_MISO	EXYNOS4_GPB(6)
#define GPIO_CAM_SPI_MOSI	EXYNOS4_GPB(7)
#endif

#define GPIO_CAM_MCLK		EXYNOS4212_GPJ1(3)
#define GPIO_VTCAM_MCLK		EXYNOS4212_GPM2(2)

#define GPIO_ISP_STANDBY	EXYNOS4212_GPM0(1)
#define GPIO_CAM_IO_EN		EXYNOS4212_GPM0(2)
#define GPIO_ISP_CORE_EN	EXYNOS4212_GPM0(3)
#define GPIO_CAM_AF_EN		EXYNOS4212_GPM0(4)
#define GPIO_CAM_VT_nRST	EXYNOS4212_GPJ1(0)

#if 1
#define GPIO_8M_CAM_SCL_18V	EXYNOS4_GPD1(0)
#define GPIO_8M_CAM_SDA_18V	EXYNOS4_GPD1(1)
#else
#define GPIO_8M_CAM_SCL_18V	EXYNOS4212_GPM4(0)
#define GPIO_8M_CAM_SDA_18V	EXYNOS4212_GPM4(1)
#define GPIO_8M_CAM_SCL_18V_00	EXYNOS4_GPD1(0)
#define GPIO_8M_CAM_SDA_18V_00	EXYNOS4_GPD1(1)
#endif

#define GPIO_VT_CAM_SCL_18V	EXYNOS4212_GPM4(2)
#define GPIO_VT_CAM_SDA_18V	EXYNOS4212_GPM4(3)
#define GPIO_VT_CAM_ID		EXYNOS4_GPF1(2)

/* Sensors & NFC*/
#define GPIO_AP_MCU_INT		EXYNOS4_GPX0(0)
#define GPIO_MCU_AP_INT		EXYNOS4_GPX0(2)
#define GPIO_MCU_AP_INT_2	EXYNOS4_GPX0(4)
#define GPIO_MCU_NRST		EXYNOS4_GPX0(5)
/* Sensors & NFC*/

#define GPIO_TF_EN		EXYNOS4_GPY2(0)
#define GPIO_DET_35		EXYNOS4_GPX0(1)

#define GPIO_PMIC_IRQ		EXYNOS4_GPX0(7)

#define GPIO_TSP_INT		EXYNOS4212_GPM2(3)
#define GPIO_TSP_SDA_18V	EXYNOS4_GPA1(2)
#define GPIO_TSP_SCL_18V	EXYNOS4_GPA1(3)

#define GPIO_BT_nRST		EXYNOS4_GPX3(0)
#define GPIO_BT_EN		EXYNOS4_GPL0(6)
#define GPIO_BT_WAKE		EXYNOS4_GPX3(1)
#define GPIO_BT_HOST_WAKE	EXYNOS4_GPX2(6)
#define IRQ_BT_HOST_WAKE	IRQ_EINT(22)

#define GPIO_BT_RXD		EXYNOS4_GPA0(0)
#define GPIO_BT_RXD_AF		2

#define GPIO_BT_TXD		EXYNOS4_GPA0(1)
#define GPIO_BT_TXD_AF		2

#define GPIO_BT_CTS		EXYNOS4_GPA0(2)
#define GPIO_BT_CTS_AF		2

#define GPIO_BT_RTS		EXYNOS4_GPA0(3)
#define GPIO_BT_RTS_AF		2

#define GPIO_3_TOUCH_SCL	EXYNOS4_GPL0(1)
#define GPIO_3_TOUCH_SDA	EXYNOS4_GPL0(2)

#define GPIO_POGO_VBATT_EN	EXYNOS4_GPL0(3)
#define GPIO_POGO_VBUS_EN	EXYNOS4_GPL0(4)

#define GPIO_3_TOUCH_INT	EXYNOS4212_GPJ0(3)
#define GPIO_3_TOUCH_EN		EXYNOS4212_GPM0(0)

#define GPIO_PWM0		EXYNOS4_GPD0(0)
#define GPIO_PWM1		EXYNOS4_GPD0(1)
#define GPIO_PWM2		EXYNOS4_GPD0(2)
#define GPIO_PWM3		EXYNOS4_GPD0(3)

#define GPIO_VIBTONE_EN		EXYNOS4212_GPJ0(6)

#define GPIO_WLAN_EN		EXYNOS4212_GPJ0(0)
#define GPIO_WLAN_EN_AF		1
#define GPIO_WLAN_HOST_WAKE	EXYNOS4_GPX2(5)
#define GPIO_WLAN_HOST_WAKE_AF	0xF
#define GPIO_WLAN_SDIO_CLK	EXYNOS4_GPK3(0)
#define GPIO_WLAN_SDIO_CLK_AF	2
#define GPIO_WLAN_SDIO_CMD	EXYNOS4_GPK3(1)
#define GPIO_WLAN_SDIO_CMD_AF	2
#define GPIO_WLAN_SDIO_D0	EXYNOS4_GPK3(3)
#define GPIO_WLAN_SDIO_D0_AF	2
#define GPIO_WLAN_SDIO_D1	EXYNOS4_GPK3(4)
#define GPIO_WLAN_SDIO_D1_AF	2
#define GPIO_WLAN_SDIO_D2	EXYNOS4_GPK3(5)
#define GPIO_WLAN_SDIO_D2_AF	2
#define GPIO_WLAN_SDIO_D3	EXYNOS4_GPK3(6)
#define GPIO_WLAN_SDIO_D3_AF	2

#define GPIO_LCD_22V_EN		EXYNOS4212_GPM4(4)
#define GPIO_LCD_22V_EN_00		EXYNOS4_GPC0(1)

#define GPIO_ISP_TXD		EXYNOS4212_GPM4(5)
#define GPIO_ISP_RXD		EXYNOS4212_GPM4(6)

#define GPIO_TA_EN		EXYNOS4_GPL2(2)

#define GPIO_MHL_SDA_1_8V_00	EXYNOS4_GPB(2)
#define GPIO_MHL_SCL_1_8V_00	EXYNOS4_GPB(3)

#define GPIO_MLCD_RST		EXYNOS4_GPF2(1)
#define GPIO_OLED_DET		EXYNOS4_GPF3(0)

#define GPIO_PMIC_DVS1		EXYNOS4212_GPM3(0)
#define GPIO_PMIC_DVS2		EXYNOS4212_GPM3(1)

/* Definitions for Sii 9244B0 */
#define GPIO_PMIC_DVS3		EXYNOS4212_GPM3(2)
#define GPIO_BUCK2_SEL		EXYNOS4_GPF3(1)
#define GPIO_BUCK3_SEL		EXYNOS4_GPF3(2)
#define GPIO_BUCK4_SEL		EXYNOS4_GPF3(3)

#define GPIO_RGB_SDA_1_8V	EXYNOS4_GPF0(0)
#define GPIO_RGB_SCL_1_8V	EXYNOS4_GPF0(1)
#define GPIO_RGB_INT		EXYNOS4_GPX2(2)
#define GPIO_VOL_UP			EXYNOS4_GPX2(2)
#define GPIO_VOL_DOWN		EXYNOS4_GPX3(3)

#define GPIO_TORCH_EN		EXYNOS4212_GPJ1(1)
#define GPIO_TORCH_SET		EXYNOS4212_GPJ1(2)

#define GPIO_HDMI_CEC		NULL
#define GPIO_HDMI_HPD		EXYNOS4_GPX3(7)

#define GPIO_nPOWER		EXYNOS4_GPX2(7)
#define GPIO_OK_KEY		EXYNOS4_GPX3(5)

#define GPIO_FUEL_ALERT		EXYNOS4_GPX2(3)

#define GPIO_WPC_INT		EXYNOS4_GPX3(0)

#define GPIO_VIBTONE_PWM	EXYNOS4_GPD0(1)

#define GPIO_CODEC_SDA_18V	EXYNOS4_GPD0(2)
#define GPIO_CODEC_SCL_18V	EXYNOS4_GPD0(3)
#define GPIO_CODEC_SDA_18V_00		EXYNOS4_GPB(0)
#define GPIO_CODEC_SCL_18V_00		EXYNOS4_GPB(1)


#define GPIO_CODEC_LDO_EN	EXYNOS4212_GPJ0(4)

#define GPIO_WM8994_LDO		EXYNOS4212_GPJ0(4)
#define GPIO_YMU_LDO_EN		EXYNOS4_GPX3(6)
#define GPIO_MAIN_MIC_SW	EXYNOS4_GPX3(2)

#define GPIO_OK_KEY_ANDROID	EXYNOS4_GPX0(1)		/*system_rev == 11*/
#define GPIO_OK_KEY_ANDROID_F EXYNOS4_GPX1(3)	/*system_rev >= 15*/

#endif /* __MACH_GPIO_MIDAS_H */
