#ifndef __MACH_GPIO_P10_H
#define __MACH_GPIO_P10 __FILE__

#include <mach/gpio.h>

extern void p10_config_gpio_table(void);
extern void p10_config_sleep_gpio_table(void);

/**
 * Main GPIO function mapping.
 */
#define	GPIO_BT_UART_RXD		EXYNOS5_GPA0(0)
#define	GPIO_BT_UART_TXD		EXYNOS5_GPA0(1)
#define	GPIO_BT_UART_CTS		EXYNOS5_GPA0(2)
#define	GPIO_BT_UART_RTS		EXYNOS5_GPA0(3)

#define	GPIO_HDMI_DCDC_EN		EXYNOS5_GPA0(4)

#define	GPIO_CHG_SDA_18V		EXYNOS5_GPE0(1)
#define	GPIO_CHG_SCL_18V		EXYNOS5_GPE0(2)

#define	GPIO_AP_RXD			EXYNOS5_GPA1(0)
#define	GPIO_AP_TXD			EXYNOS5_GPA1(1)

#define	GPIO_TSP_SDA_18V		EXYNOS5_GPA1(2)
#define	GPIO_TSP_SCL_18V		EXYNOS5_GPA1(3)

#define	GPIO_IPC_RXD			EXYNOS5_GPA1(4)
#define	GPIO_IPC_TXD			EXYNOS5_GPA1(5)

#define	GPIO_MM_SDA_18V			EXYNOS5_GPA2(0)
#define	GPIO_MM_SCL_18V			EXYNOS5_GPA2(1)

#define	GPIO_AP_PMIC_SDA		EXYNOS5_GPA2(2)
#define	GPIO_AP_PMIC_SCL		EXYNOS5_GPA2(3)

#define	GPIO_5M_SPI_CLK			EXYNOS5_GPA2(4)
#define	GPIO_5M_SPI_CS			EXYNOS5_GPA2(5)
#define	GPIO_5M_SPI_DI			EXYNOS5_GPA2(6)
#define	GPIO_5M_SPI_DO			EXYNOS5_GPA2(7)

#define	GPIO_OTG_EN			EXYNOS5_GPB0(3)

#define	GPIO_USB30_EN			EXYNOS5_GPB0(4)

#define	GPIO_POGO_SPDIF			EXYNOS5_GPB1(0)

#define	GPIO_LCD_PWM_IN_18V		EXYNOS5_GPB2(0)

#define	GPIO_ACCESSORY_CHECK	EXYNOS5_GPE0(4)
#define	GPIO_ACCESSORY_EN	EXYNOS5_GPH1(5)
#define	GPIO_ACCESSORY_INT	EXYNOS5_GPX3(2)

#define	GPIO_ADC_INT		EXYNOS5_GPX2(4)
#define	GPIO_ADC_SCL_18V	EXYNOS5_GPV3(0)
#define	GPIO_ADC_SDA_18V	EXYNOS5_GPV3(1)

#define	GPIO_MOTOR_PWM			EXYNOS5_GPB2(1)

#define	GPIO_CODEC_SDA_18V		EXYNOS5_GPB2(2)
#define	GPIO_CODEC_SCL_18V		EXYNOS5_GPB2(3)

#define	GPIO_DISP_SDA_18V		EXYNOS5_GPB3(0)
#define	GPIO_DISP_SCL_18V		EXYNOS5_GPB3(1)

#define	GPIO_SENSE_SDA_18V		EXYNOS5_GPB3(2)
#define	GPIO_SENSE_SCL_18V		EXYNOS5_GPB3(3)

#define	GPIO_NAND_CLK			EXYNOS5_GPC0(0)
#define	GPIO_NAND_CMD			EXYNOS5_GPC0(1)

#define	GPIO_eMMC_EN			EXYNOS5_GPC0(2)

#define	GPIO_NAND_D0			EXYNOS5_GPC0(3)
#define	GPIO_NAND_D1			EXYNOS5_GPC0(4)
#define	GPIO_NAND_D2			EXYNOS5_GPC0(5)
#define	GPIO_NAND_D3			EXYNOS5_GPC0(6)
#define	GPIO_NAND_D4			EXYNOS5_GPC1(0)
#define	GPIO_NAND_D5			EXYNOS5_GPC1(1)
#define	GPIO_NAND_D6			EXYNOS5_GPC1(2)
#define	GPIO_NAND_D7			EXYNOS5_GPC1(3)

#define	GPIO_BTREG_ON		EXYNOS5_GPH0(0)
#define   IRQ_BT_HOST_WAKE	IRQ_EINT(22)

#define	GPIO_T_FLASH_CLK		EXYNOS5_GPC3(0)
#define	GPIO_T_FLASH_CMD		EXYNOS5_GPC3(1)
#define	GPIO_T_FLASH_D0			EXYNOS5_GPC3(3)
#define	GPIO_T_FLASH_D1			EXYNOS5_GPC3(4)
#define	GPIO_T_FLASH_D2			EXYNOS5_GPC3(5)
#define	GPIO_T_FLASH_D3			EXYNOS5_GPC3(6)

#define	GPIO_GPS_UART_RXD		EXYNOS5_GPD0(0)
#define	GPIO_GPS_UART_TXD		EXYNOS5_GPD0(1)
#define	GPIO_GPS_UART_CTS		EXYNOS5_GPD0(2)
#define	GPIO_GPS_UART_RTS		EXYNOS5_GPD0(3)

#define	GPIO_HDMI_EN			EXYNOS5_GPD1(0)

#define	GPIO_TOUCH_EN			EXYNOS5_GPD1(1)

#define	GPIO_LCD_ID			EXYNOS5_GPD1(4)

#define	GPIO_MOTOR_EN			EXYNOS5_GPD1(6)

#define	GPIO_NFC_EN			EXYNOS5_GPD1(7)

#define	GPIO_TA_INT			EXYNOS5_GPX0(0)

#define	GPIO_DET_35			EXYNOS5_GPX0(1)

#define	GPIO_AP_PMIC_IRQ		EXYNOS5_GPX0(2)

#define	GPIO_CHG_INT			EXYNOS5_GPX0(4)

/*#define	GPIO_POGO_DET			EXYNOS5_GPX0(5) */

#define	GPIO_DOCK_INT		EXYNOS5_GPX3(0)


#define	GPIO_DP_HPD			EXYNOS5_GPX0(7)

#define	GPIO_DPRAM_A0		EXYNOS5_GPY3(0)
#define	GPIO_DPRAM_A1		EXYNOS5_GPY3(1)
#define	GPIO_DPRAM_A2		EXYNOS5_GPY3(2)
#define	GPIO_DPRAM_A3		EXYNOS5_GPY3(3)
#define	GPIO_DPRAM_A4		EXYNOS5_GPY3(4)
#define	GPIO_DPRAM_A5		EXYNOS5_GPY3(5)
#define	GPIO_DPRAM_A6		EXYNOS5_GPY3(6)
#define	GPIO_DPRAM_A7		EXYNOS5_GPY3(7)
#define	GPIO_DPRAM_A8		EXYNOS5_GPY4(0)
#define	GPIO_DPRAM_A9		EXYNOS5_GPY4(1)
#define	GPIO_DPRAM_A10		EXYNOS5_GPY4(2)
#define	GPIO_DPRAM_A11		EXYNOS5_GPY4(3)
#define	GPIO_DPRAM_A12		EXYNOS5_GPY4(4)
#define	GPIO_DPRAM_A13		EXYNOS5_GPY4(5)
#define	GPIO_DPRAM_CSN		EXYNOS5_GPY0(0)
#define	GPIO_DPRAM_D0		EXYNOS5_GPY5(0)
#define	GPIO_DPRAM_D1		EXYNOS5_GPY5(1)
#define	GPIO_DPRAM_D2		EXYNOS5_GPY5(2)
#define	GPIO_DPRAM_D3		EXYNOS5_GPY5(3)
#define	GPIO_DPRAM_D4		EXYNOS5_GPY5(4)
#define	GPIO_DPRAM_D5		EXYNOS5_GPY5(5)
#define	GPIO_DPRAM_D6		EXYNOS5_GPY5(6)
#define	GPIO_DPRAM_D7		EXYNOS5_GPY5(7)
#define	GPIO_DPRAM_D8		EXYNOS5_GPY6(0)
#define	GPIO_DPRAM_D9		EXYNOS5_GPY6(1)
#define	GPIO_DPRAM_D10		EXYNOS5_GPY6(2)
#define	GPIO_DPRAM_D11		EXYNOS5_GPY6(3)
#define	GPIO_DPRAM_D12		EXYNOS5_GPY6(4)
#define	GPIO_DPRAM_D13		EXYNOS5_GPY6(5)
#define	GPIO_DPRAM_D14		EXYNOS5_GPY6(6)
#define	GPIO_DPRAM_D15		EXYNOS5_GPY6(7)
#define	GPIO_DPRAM_INT		EXYNOS5_GPX0(5)
#define	GPIO_DPRAM_REN		EXYNOS5_GPY0(4)
#define	GPIO_DPRAM_WEN		EXYNOS5_GPY0(5)

#define	GPIO_ACC_INT			EXYNOS5_GPX1(4)

#define	GPIO_NFC_WAKE			EXYNOS5_GPX1(5)

#define	GPIO_SPI_INT			EXYNOS5_GPX1(6)

#define	GPIO_NFC_IRQ			EXYNOS5_GPX1(7)

#define	GPIO_VOL_UP			EXYNOS5_GPX2(0)
#define	GPIO_VOL_DOWN			EXYNOS5_GPX2(1)

#define	GPIO_MSENSE_RDY			EXYNOS5_GPX2(2)

#define	GPIO_ADC_INT			EXYNOS5_GPX2(4)

#define	GPIO_WLAN_HOST_WAKE		EXYNOS5_GPX2(5)

#define	GPIO_BT_HOST_WAKE		EXYNOS5_GPX2(6)

#define	GPIO_nPOWER			EXYNOS5_GPX2(7)

#define	GPIO_FUEL_ALERT		EXYNOS5_GPX2(3)
#define	GPIO_FUEL_SCL_18V	EXYNOS5_GPZ(6)
#define	GPIO_FUEL_SDA_18V	EXYNOS5_GPZ(5)

#define	GPIO_GPS_PWR_EN		EXYNOS5_GPE1(0)
#define	GPIO_GPS_nRST		EXYNOS5_GPE0(6)
#define	GPIO_GPS_CTS		EXYNOS5_GPA0(6)
#define	GPIO_GPS_RTS		EXYNOS5_GPA0(7)
#define	GPIO_GPS_RXD		EXYNOS5_GPA0(4)
#define	GPIO_GPS_TXD		EXYNOS5_GPA0(5)

#define	GPIO_GPS_CTS_AF		2
#define	GPIO_GPS_RTS_AF		2
#define	GPIO_GPS_RXD_AF		2
#define	GPIO_GPS_TXD_AF		2


#define	GPIO_T_FLASH_DETECT		EXYNOS5_GPX3(4)

#define	GPIO_EAR_SEND_END		EXYNOS5_GPX3(5)

#define	GPIO_HDMI_CEC			EXYNOS5_GPX3(6)
#define	GPIO_HDMI_HPD			EXYNOS5_GPX3(7)

#define	GPIO_TF_EN			EXYNOS5_GPY2(0)

#define	GPIO_5M_CAM_RESET		EXYNOS5_GPE0(0)

#define	GPIO_CAM_FLASH_EN		EXYNOS5_GPE0(3)
#define	GPIO_CAM_FLASH_SET		EXYNOS5_GPE0(4)

#define	GPIO_UART_SEL			EXYNOS5_GPE0(5)

#define	GPIO_GPS_nRST			EXYNOS5_GPE0(6)

#define	GPIO_ISP_TXD			EXYNOS5_GPE0(7)

#define	GPIO_GPS_EN			EXYNOS5_GPE1(0)

#define	GPIO_ISP_RXD			EXYNOS5_GPE1(1)

#define	GPIO_5M_CAM_SDA_18V		EXYNOS5_GPF0(0)
#define	GPIO_5M_CAM_SCL_18V		EXYNOS5_GPF0(1)

#define	GPIO_VT_CAM_SDA_18V		EXYNOS5_GPF0(2)
#define	GPIO_VT_CAM_SCL_18V		EXYNOS5_GPF0(3)

#define	GPIO_NFC_SPI_CLK		EXYNOS5_GPF1(0)
#define	GPIO_NFC_SPI_CS			EXYNOS5_GPF1(1)
#define	GPIO_NFC_SPI_MISO		EXYNOS5_GPF1(2)
#define	GPIO_NFC_SPI_MOSI		EXYNOS5_GPF1(3)

#define	GPIO_NFC_CLK_REQ		EXYNOS5_GPG0(2)

#define	GPIO_2MIC_WAKE			EXYNOS5_GPG0(3)
#define	GPIO_2MIC_RST			EXYNOS5_GPG0(4)

#define	GPIO_LED_BACKLIGHT_RESET	EXYNOS5_GPG0(5)

#define	GPIO_HDMI_LS_EN			EXYNOS5_GPG0(7)

#define	GPIO_MHL_DSCL_18V	EXYNOS5_GPB3(1)
#define	GPIO_MHL_DSDA_18V	EXYNOS5_GPB3(0)
#define	GPIO_MHL_INT		EXYNOS5_GPG0(6)
#define	GPIO_MHL_RST		EXYNOS5_GPG0(7)
#define	GPIO_MHL_SCL_18V	EXYNOS5_GPA0(5)
#define	GPIO_MHL_SDA_18V	EXYNOS5_GPA0(4)

#define MHL_INT_IRQ		gpio_to_irq(GPIO_MHL_INT)
#define GPIO_MHL_INT_AF		S3C_GPIO_SFN(0xF)

#define	GPIO_MOTOR_EN		EXYNOS5_GPD1(6)
#define	GPIO_MOTOR_PWM		EXYNOS5_GPB2(1)
#define	GPIO_MOTOR_SCL_18V	EXYNOS5_GPD1(3)
#define	GPIO_MOTOR_SDA_18V	EXYNOS5_GPD1(2)

#define	GPIO_MSENSE_RDY		EXYNOS5_GPX2(2)
#define	GPIO_MSENSE_RST		EXYNOS5_GPG2(0)
#define	GPIO_MSENSE_SDA		EXYNOS5_GPV2(7)
#define	GPIO_MSENSE_SCL		EXYNOS5_GPV2(6)

#define	GPIO_PS_ALS_SDA		EXYNOS5_GPG0(0)
#define	GPIO_PS_ALS_SCL		EXYNOS5_GPG0(1)
#define	GPIO_PS_VOUT		EXYNOS5_GPH1(2)
#define	GPIO_HUM_SDA		EXYNOS5_GPV2(5)
#define	GPIO_HUM_SCL		EXYNOS5_GPV2(4)

#define	GPIO_CAM_FLASH_EN_T		EXYNOS5_GPG1(0)
#define	GPIO_CAM_FLASH_SET_T		EXYNOS5_GPG1(1)

#define	GPIO_TOUCH_CHG			EXYNOS5_GPG1(2)
#define	GPIO_TOUCH_RESET		EXYNOS5_GPG1(3)

#define	GPIO_TA_nCHG			EXYNOS5_GPG1(4)
#define	GPIO_TA_EN			EXYNOS5_GPG1(5)
#define	GPIO_TA_nCONNECTED	EXYNOS5_GPX0(0)

#define	GPIO_CAM_VT_nRST		EXYNOS5_GPG1(6)

#define	GPIO_MSENSE_RST			EXYNOS5_GPG2(0)

#define	GPIO_VTCAM_MCLK			EXYNOS5_GPG2(1)

#define	GPIO_USB_SEL1			EXYNOS5_GPH0(1)

#define	GPIO_TP				EXYNOS5_GPH0(2)

#define	GPIO_CAM_MCLK			EXYNOS5_GPH0(3)

#define	GPIO_WM8994_LDO			EXYNOS5_GPH1(1)

#define	GPIO_ALS_nRST			EXYNOS5_GPH1(2)

#define	GPIO_BT_WAKE			EXYNOS5_GPH1(3)

#define	GPIO_LCD_EN			EXYNOS5_GPH1(7)

#define	GPIO_MM_I2S_CLK			EXYNOS5_GPZ(0)
#define	GPIO_MM_I2S_SYNC		EXYNOS5_GPZ(2)
#define	GPIO_MM_I2S_DI			EXYNOS5_GPZ(3)
#define	GPIO_MM_I2S_DO			EXYNOS5_GPZ(4)

#define	GPIO_BUCK4_SEL			EXYNOS5_GPV0(0)

#define	GPIO_BUCK3_SEL			EXYNOS5_GPV0(1)

#define	GPIO_5M_CORE_EN			EXYNOS5_GPV0(2)

#define	GPIO_CAM_IO_EN			EXYNOS5_GPV0(3)

#define	GPIO_BUCK2_SEL			EXYNOS5_GPV0(4)

#define	GPIO_PMIC_DVS3			EXYNOS5_GPV0(5)
#define	GPIO_PMIC_DVS2			EXYNOS5_GPV0(6)
#define	GPIO_PMIC_DVS1			EXYNOS5_GPV0(7)

#define	GPIO_WLREG_ON			EXYNOS5_GPV1(0)

#define	GPIO_HW_REV3			EXYNOS5_GPV1(1)
#define	GPIO_HW_REV2			EXYNOS5_GPV1(2)
#define	GPIO_HW_REV1			EXYNOS5_GPV1(3)
#define	GPIO_HW_REV0			EXYNOS5_GPV1(4)

#define GPIO_WLAN_EN            EXYNOS5_GPV1(0)
#define GPIO_WLAN_EN_AF         1
#define GPIO_WLAN_HOST_WAKE     EXYNOS5_GPX2(5)
#define GPIO_WLAN_HOST_WAKE_AF  0xF
#define GPIO_WLAN_SDIO_CLK      EXYNOS5_GPC3(0)
#define GPIO_WLAN_SDIO_CLK_AF   2
#define GPIO_WLAN_SDIO_CMD      EXYNOS5_GPC3(1)
#define GPIO_WLAN_SDIO_CMD_AF   2
#define GPIO_WLAN_SDIO_D0       EXYNOS5_GPC3(3)
#define GPIO_WLAN_SDIO_D0_AF    2
#define GPIO_WLAN_SDIO_D1       EXYNOS5_GPC3(4)
#define GPIO_WLAN_SDIO_D1_AF    2
#define GPIO_WLAN_SDIO_D2       EXYNOS5_GPC3(5)
#define GPIO_WLAN_SDIO_D2_AF    2
#define GPIO_WLAN_SDIO_D3       EXYNOS5_GPC3(6)
#define GPIO_WLAN_SDIO_D3_AF    2
/**
 *  Remappig for downward compatibility.
 */
#define	GPIO_PMIC_IRQ		GPIO_AP_PMIC_IRQ

#define	GPIO_5M_nRST		GPIO_5M_CAM_RESET

/* Definitions for DPRAM */
#define GPIO_DPRAM_CSN		EXYNOS5_GPY0(0)
#define GPIO_DPRAM_CSN0		EXYNOS5_GPY0(0)
#define GPIO_DPRAM_CSN1		EXYNOS5_GPY0(1)
#define GPIO_DPRAM_CSN2		EXYNOS5_GPY0(2)
#define GPIO_DPRAM_CSN3		EXYNOS5_GPY0(3)
#define GPIO_DPRAM_REN		EXYNOS5_GPY0(4)
#define GPIO_DPRAM_WEN		EXYNOS5_GPY0(5)
/* #define GPIO_DPRAM_LBN		EXYNOS4_GPY1(0) // for via modem */
/* #define GPIO_DPRAM_UBN		EXYNOS4_GPY1(1) // for via modem */
#define GPIO_SROM_ADDR_BUS_LOW	EXYNOS5_GPY3(0)
#define GPIO_SROM_ADDR_BUS_HIGH	EXYNOS5_GPY4(0)
#define GPIO_SROM_DATA_BUS_LOW	EXYNOS5_GPY5(0)
#define GPIO_SROM_DATA_BUS_HIGH	EXYNOS5_GPY6(0)

/* Definitions for CMC221 */
#define CP_CMC221_PMIC_PWRON	EXYNOS5_GPD1(5)
#define CP_CMC221_CPU_RST	EXYNOS5_GPB0(1)
#define GPIO_LTE_ACTIVE		EXYNOS5_GPX1(6)
#define LTE_ACTIVE_IRQ		IRQ_EINT(14)	/* IRQ of GPX1[6] */

#define GPIO_CMC_IDPRAM_INT_00	EXYNOS5_GPX0(5)
#define CMC_IDPRAM_INT_IRQ_00	IRQ_EINT(5)	/* IRQ of GPX0[5] */

#define GPIO_CMC_IDPRAM_STATUS	EXYNOS5_GPX0(3) /* CMC2AP_INT_1 */
#define GPIO_CMC_IDPRAM_WAKEUP	EXYNOS5_GPX1(2) /* AP2CMC_INT_3 */
/* #define GPIO_ACTIVE_STATE	EXYNOS4_GPF1(1) // for USB */
#define GPIO_IPC_SLAVE_WAKEUP	EXYNOS5_GPX0(6) /* AP2CMC_INT_1 */
#define GPIO_IPC_HOST_WAKEUP	EXYNOS5_GPX1(0) /* CMC2AP_INT_2 */

#define	GPIO_CMC_CLK_18V	GPIO_NFC_SPI_CLK
#define	GPIO_CMC_CS_18V		GPIO_NFC_SPI_CS

#define	GPIO_FM34_BYPASS	EXYNOS5_GPH1(4)
#define	GPIO_FM34_PWDN		GPIO_2MIC_WAKE
#define	GPIO_FM34_RESET		GPIO_2MIC_RST
#define	GPIO_FM34_SCL_18V	GPIO_MM_SCL_18V
#define	GPIO_FM34_SDA_18V	GPIO_MM_SDA_18V

#define	GPIO_ES305_WAKEUP	GPIO_2MIC_WAKE
#define	GPIO_ES305_RESET	GPIO_2MIC_RST

#endif /* __MACH_GPIO_P10_H */
