#ifndef __MACH_GPIO_MIDAS_H
#define __MACH_GPIO_MIDAS_H __FILE__

#include <mach/gpio.h>

extern void midas_config_gpio_table(void);
extern void midas_config_sleep_gpio_table(void);

#define GPIO_eMMC_EN		EXYNOS4_GPK0(2)
/* Camera */
#define GPIO_CAM_MCLK		EXYNOS4212_GPJ1(3)
#define GPIO_VTCAM_MCLK		EXYNOS4212_GPM2(2)

#ifdef CONFIG_VIDEO_ISX012
#define GPIO_5M_nRST		EXYNOS4_GPL1(1)
#define GPIO_5M_nSTBY		EXYNOS4212_GPJ0(7)
#else
#define GPIO_3M_nRST		EXYNOS4_GPL1(1)
#endif
#define GPIO_VT_CAM_nSTBY	EXYNOS4212_GPM1(6)
#define GPIO_CAM_EN		EXYNOS4212_GPJ0(6)
#define GPIO_3M_nSTBY		EXYNOS4212_GPJ0(7)
#define GPIO_VT_CAM_nRST	EXYNOS4212_GPJ1(0)
#define GPIO_CAM_A_28V_EN	EXYNOS4212_GPM3(7)

#if defined(CONFIG_30PIN_CONN)
/* 30pin Accessory */
#define GPIO_ACCESSORY_EN	EXYNOS4_GPL2(6)
#define GPIO_ACCESSORY_OUT_5V	EXYNOS4_GPX3(5)
#define GPIO_ACCESSORY_INT	EXYNOS4_GPX1(3)
#define GPIO_DOCK_INT		EXYNOS4_GPX0(4)
#endif /* CONFIG_30PIN_CONN */

#if defined(CONFIG_SAMSUNG_MUIC)
/* fuelgauge */
#define GPIO_IF_FUEL_SCL	EXYNOS4_GPY0(3)
#define GPIO_IF_FUEL_SDA	EXYNOS4_GPY0(2)

#define GPIO_IF_PMIC_SDA	EXYNOS4212_GPM2(0)
#define GPIO_IF_PMIC_SCL	EXYNOS4212_GPM2(1)
#define GPIO_IF_PMIC_IRQ	EXYNOS4_GPX1(5)
#endif /* CONFIG_SAMSUNG_MUIC */

/* Sensors*/
#define GPIO_PS_ALS_SCL_28V	EXYNOS4_GPL0(1)
#define GPIO_PS_ALS_SDA_28V	EXYNOS4_GPL0(2)
#define GPIO_PS_ALS_INT		EXYNOS4_GPX0(2)
#if defined(CONFIG_GPS_BCMxxxxx)
#define GPIO_GPS_PWR_EN		EXYNOS4_GPL2(2)
#endif
#if defined(CONFIG_GPS_BCMxxxxx) && defined(CONFIG_GPS_BCM47521)
#define GPIO_GPS_HOST_WAKE	EXYNOS4_GPX1(5)
#define GPIO_GPS_HOST_WAKE_AF		0xF
#endif

#define GPIO_GSENSE_SDA_18V	EXYNOS4_GPD1(2)
#define GPIO_GSENSE_SCL_18V	EXYNOS4_GPD1(3)
#define GPIO_ACC_INT		EXYNOS4_GPX0(0)
#define GPIO_ACC_INT1		EXYNOS4_GPX0(6)

#define GPIO_MSENSOR_SDA_18V	EXYNOS4_GPY2(4)
#define GPIO_MSENSOR_SCL_18V	EXYNOS4_GPY2(5)
#define GPIO_RF_TOUCH		EXYNOS4_GPX1(7)
#if defined(CONFIG_TARGET_TAB3_3G10) ||\
	defined(CONFIG_TARGET_TAB3_WIFI10) ||\
	defined(CONFIG_TARGET_TAB3_LTE10)
#define GPIO_ADJ_DET		EXYNOS4212_GPM4(7)
#else
#define GPIO_ADJ_DET		EXYNOS4_GPF0(6)
#endif
#define GPIO_GRIP_SDA_28V	EXYNOS4_GPC1(3)
#define GPIO_GRIP_SCL_28V	EXYNOS4_GPC1(4)
/* Sensors*/

#define GPIO_TF_EN		EXYNOS4_GPY2(0)
#define GPIO_DET_35		EXYNOS4_GPX0(3)

#define GPIO_MIC_BIAS_EN	EXYNOS4212_GPM0(0) /* 7inch only */
/* define GPIO_SUB_MIC_BIAS_EN	*/
#define GPIO_EAR_MIC_BIAS_EN	EXYNOS4212_GPJ0(1) /* obsolete */
#define GPIO_EAR_SEND_END	EXYNOS4_GPX3(6)
#define GPIO_LINEOUT_EN		EXYNOS4212_GPJ1(2)

#define GPIO_PMIC_IRQ		EXYNOS4_GPX0(7)

#define GPIO_BT_EN		EXYNOS4_GPL0(6)
#define GPIO_BT_WAKE		EXYNOS4_GPX3(1)
#define GPIO_BT_HOST_WAKE	EXYNOS4_GPX2(6)
#define IRQ_BT_HOST_WAKE	IRQ_EINT(22)

#define GPIO_BT_RXD		EXYNOS4_GPA0(0)
#define GPIO_BT_RXD_AF		2

#define GPIO_BT_TXD		EXYNOS4_GPA0(1)
#define GPIO_BT_TXD_AF		2

#define GPIO_BT_CTS		EXYNOS4_GPA0(2)
#define GPIO_BT_CTS_AF		2

#define GPIO_BT_RTS		EXYNOS4_GPA0(3)
#define GPIO_BT_RTS_AF		2

#if defined (CONFIG_GPS_BCMxxxxx)
#define GPIO_GPS_RXD		EXYNOS4_GPA0(4)
#define GPIO_GPS_RXD_AF		2
#define GPIO_GPS_TXD		EXYNOS4_GPA0(5)
#define GPIO_GPS_TXD_AF		2
#define GPIO_GPS_CTS		EXYNOS4_GPA0(6)
#define GPIO_GPS_CTS_AF		2
#define GPIO_GPS_RTS		EXYNOS4_GPA0(7)
#define GPIO_GPS_RTS_AF		2
#endif

#define GPIO_FLM_RXD		EXYNOS4_GPA1(4)
#define GPIO_FLM_RXD_AF		2

#define GPIO_FLM_TXD		EXYNOS4_GPA1(5)
#define GPIO_FLM_TXD_AF		2

#define GPIO_HDMI_EN		EXYNOS4_GPL0(4)	/* obsolete */

#if defined(CONFIG_TARGET_TAB3_3G8) || \
	defined(CONFIG_TARGET_TAB3_WIFI8) || \
	defined(CONFIG_TARGET_TAB3_LTE8)
#define GPIO_TSP_INT		EXYNOS4_GPB(4)
#elif defined(CONFIG_TAB3_01_BD)
#define GPIO_TSP_INT		EXYNOS4_GPB(4)
#else
#define GPIO_TSP_INT		EXYNOS4212_GPM2(3)
#endif
#define GPIO_TSP_SDA_18V	EXYNOS4_GPA1(2)
#define GPIO_TSP_SCL_18V	EXYNOS4_GPA1(3)
#define GPIO_TSP_RST		EXYNOS4212_GPM0(4)
#define GPIO_TSP_VENDOR1	EXYNOS4212_GPM4(5)
#define GPIO_TSP_VENDOR2	EXYNOS4_GPB(5)
#define GPIO_TSP_VENDOR3	EXYNOS4_GPB(7)
#define GPIO_TSP_LDO_ON2	EXYNOS4_GPB(7)
#define GPIO_TSP_LDO_ON1	EXYNOS4_GPC1(0)
#define GPIO_TSP_LDO_ON		EXYNOS4_GPC1(1)
#define GPIO_TSK_EN		EXYNOS4212_GPM0(5)

#if defined(CONFIG_TARGET_TAB3_3G8) || \
	defined(CONFIG_TARGET_TAB3_WIFI8) || \
	defined(CONFIG_TARGET_TAB3_LTE8)
#define GPIO_OK_KEY		EXYNOS4_GPX1(2)
#define GPIO_HALL_INT_N		EXYNOS4_GPX2(4)
#define GPIO_FUEL_ALERT         EXYNOS4_GPX2(3)
#else
#if !defined(CONFIG_QC_MODEM)
#define GPIO_OK_KEY		EXYNOS4_GPX1(2)
#define GPIO_HALL_INT_N	EXYNOS4_GPX2(4)
#else
#define GPIO_OK_KEY		EXYNOS4_GPX2(4)
#define GPIO_HALL_INT_N	EXYNOS4_GPX1(5)
#endif
#endif
#define GPIO_nPOWER		EXYNOS4_GPX2(7)
#define GPIO_VOL_UP		EXYNOS4_GPX2(2)
#define GPIO_VOL_DOWN		EXYNOS4_GPX3(3)

#define GPIO_MOTOR_EN		EXYNOS4_GPL2(4) /* 7inch only */

#define GPIO_WLAN_EN		EXYNOS4212_GPM3(5)
#define GPIO_WLAN_EN_AF		1
#define GPIO_WLAN_HOST_WAKE	EXYNOS4_GPX2(5)
#define GPIO_WLAN_HOST_WAKE_AF	0xF
#define GPIO_WLAN_SDIO_CLK	EXYNOS4_GPK3(0)
#define GPIO_WLAN_SDIO_CLK_AF	2
#define GPIO_WLAN_SDIO_CMD	EXYNOS4_GPK3(1)
#define GPIO_WLAN_SDIO_CMD_AF	2
#define GPIO_WLAN_SDIO_D0	EXYNOS4_GPK3(3)
#define GPIO_WLAN_SDIO_D0_AF	2
#define GPIO_WLAN_SDIO_D1	EXYNOS4_GPK3(4)
#define GPIO_WLAN_SDIO_D1_AF	2
#define GPIO_WLAN_SDIO_D2	EXYNOS4_GPK3(5)
#define GPIO_WLAN_SDIO_D2_AF	2
#define GPIO_WLAN_SDIO_D3	EXYNOS4_GPK3(6)
#define GPIO_WLAN_SDIO_D3_AF	2

#if defined(CONFIG_IR_REMOCON_GPIO)
#define GPIO_IRDA_CONTROL	EXYNOS4_GPL0(3)
#elif defined(CONFIG_IR_REMOCON_MC96)
#define GPIO_IRDA_WAKE		EXYNOS4_GPL0(3)
#define GPIO_IRDA_IRQ		EXYNOS4212_GPM0(6)
#define GPIO_IRDA_SDA		EXYNOS4_GPY0(0)
#define GPIO_IRDA_SCL		EXYNOS4_GPY0(1)
#define GPIO_IR_LED_EN          EXYNOS4212_GPJ0(3)
#elif defined(CONFIG_IR_REMOCON_FPGA)
#define GPIO_FPGA_CDONE		EXYNOS4_GPL2(6)
#define GPIO_FPGA_CRESET	EXYNOS4_GPL2(7)
#define GPIO_IRDA_IRQ		EXYNOS4212_GPM0(6)
#define GPIO_IRDA_SDA		EXYNOS4_GPY0(0)
#define GPIO_IRDA_SCL		EXYNOS4_GPY0(1)
#define GPIO_IRDA_WAKE		EXYNOS4_GPL0(3)
#define GPIO_IR_LED_EN          EXYNOS4212_GPJ0(3)
#endif

#define GPIO_MHL_SDA_1_8V	EXYNOS4_GPY2(2)
#define GPIO_MHL_SCL_1_8V	EXYNOS4_GPY2(3)

#if defined(CONFIG_30PIN_CONN)
/* USB/UART switch */
#define GPIO_USB_SEL0		EXYNOS4_GPY0(4)
#define GPIO_USB_SEL1		EXYNOS4_GPY0(5)
#define GPIO_USB_SEL_CP		EXYNOS4212_GPM0(7)
#define GPIO_UART_SEL		EXYNOS4_GPL2(7)
#define GPIO_UART_SEL2		EXYNOS4212_GPJ0(0)

/* charger */
#define GPIO_CHG_SDA		EXYNOS4212_GPM2(0)
#define GPIO_CHG_SCL		EXYNOS4212_GPM2(1)
#define GPIO_TA_EN		EXYNOS4212_GPJ0(4)
#define GPIO_TA_nCHG		EXYNOS4212_GPM0(3)
#define GPIO_TA_nCONNECTED	EXYNOS4_GPX1(4)

/* adc */
#define GPIO_ADC_SCL		EXYNOS4212_GPM4(0)
#define GPIO_ADC_SDA		EXYNOS4212_GPM4(1)
#define GPIO_ADC_INT		EXYNOS4_GPX0(1)

/* fuelgauge */
#define GPIO_FUEL_SCL		EXYNOS4_GPY0(3)
#define GPIO_FUEL_SDA		EXYNOS4_GPY0(2)
#define GPIO_FUEL_ALERT		EXYNOS4_GPX2(3)
#define GPIO_IF_CON_SENSE	EXYNOS4_GPX3(0)
#endif /* CONFIG_30PIN_CONN */

#define GPIO_PMIC_DVS1		EXYNOS4212_GPM3(0)
#define GPIO_PMIC_DVS2		EXYNOS4212_GPM3(1)
#define GPIO_PMIC_DVS3		EXYNOS4212_GPM3(2)
#if !defined(CONFIG_QC_MODEM)
#define GPIO_BUCK2_SEL		EXYNOS4_GPF0(5)
#define GPIO_BUCK3_SEL		EXYNOS4_GPX2(0)
#define GPIO_BUCK4_SEL		EXYNOS4_GPX2(1)
#else
#define GPIO_BUCK2_SEL		EXYNOS4_GPL2(1)
#define GPIO_BUCK3_SEL		EXYNOS4_GPL2(2)
#define GPIO_BUCK4_SEL		EXYNOS4_GPL2(3)
#endif

/* Definitions for Sii 9244B0 */
#define GPIO_MHL_RST		EXYNOS4_GPF3(4)
#define GPIO_MHL_INT		EXYNOS4_GPF3(5)
#define GPIO_MHL_INT_AF		S3C_GPIO_SFN(0xF)
#define GPIO_MHL_WAKE_UP	EXYNOS4212_GPJ1(4)

#define MHL_INT_IRQ		gpio_to_irq(GPIO_MHL_INT)
#define MHL_WAKEUP_IRQ		gpio_to_irq(GPIO_MHL_WAKE_UP)

/* #define GPIO_HDMI_CEC	*/
#define GPIO_HDMI_HPD		EXYNOS4_GPX3(7)

#define GPIO_CODEC_LDO_EN	EXYNOS4212_GPM4(4)
#define GPIO_WM8994_LDO		EXYNOS4212_GPM4(4)


/* Modem Interface GPIOs - M0 HSIC */
#define GPIO_ACTIVE_STATE	EXYNOS4_GPL0(0)
#define GPIO_PDA_ACTIVE		EXYNOS4_GPL1(0)
#define GPIO_PHONE_ON		EXYNOS4_GPL2(5)
#define GPIO_SUSPEND_REQUEST	EXYNOS4212_GPM2(4)
#define GPIO_CP_REQ_RESET	EXYNOS4212_GPM3(3)
#define GPIO_IPC_SLAVE_WAKEUP	EXYNOS4_GPX1(0)
#define GPIO_IPC_HOST_WAKEUP	EXYNOS4_GPX1(1)
#define GPIO_CP_DUMP_INT	EXYNOS4212_GPJ0(5)
#define GPIO_PHONE_ACTIVE	EXYNOS4_GPX1(6)
#define GPIO_CP_RST		EXYNOS4_GPX3(2)
#define GPIO_AP_DUMP_INT	EXYNOS4212_GPM3(4)


#if defined(CONFIG_TDMB) || defined(CONFIG_TDMB_MODULE)
#define GPIO_TDMB_EN		EXYNOS4_GPL0(0)
#define GPIO_TDMB_INT		EXYNOS4_GPF0(2)
#define GPIO_TDMB_IRQ		gpio_to_irq(GPIO_TDMB_INT)
#define GPIO_TDMB_INT_AF	0xf
#define GPIO_TDMB_SPI_CLK	EXYNOS4_GPC1(1)
#define GPIO_TDMB_SPI_CS	EXYNOS4_GPC1(2)
#define GPIO_TDMB_SPI_MISO	EXYNOS4_GPC1(3)
#define GPIO_TDMB_SPI_MOSI	EXYNOS4_GPC1(4)
#endif

#if defined(CONFIG_FB_S5P_S6C1372)
#define GPIO_LCD_PCLK			EXYNOS4_GPF0(3)
#define GPIO_LCD_EN			EXYNOS4_GPC0(1)
#define GPIO_LED_BACKLIGHT_PWM		EXYNOS4_GPD0(1)
#define GPIO_LED_BACKLIGHT_RESET	EXYNOS4212_GPM0(1)
#define GPIO_LVDS_NSHDN			EXYNOS4212_GPM0(2)
#endif

#if defined(CONFIG_FB_S5P_S6D7AA0)
#define GPIO_LCD_22V_EN_00		EXYNOS4_GPC0(1)
#define GPIO_MLCD_RST			EXYNOS4_GPF0(4)
#define GPIO_LED_BACKLIGHT_PWM		EXYNOS4_GPD0(1)
#define GPIO_LED_BACKLIGHT_RESET	EXYNOS4212_GPM0(1)
#define GPIO_LED_BACKLIGHT_SDA		EXYNOS4212_GPM4(3)
#define GPIO_LED_BACKLIGHT_SCL		EXYNOS4212_GPM4(2)
#define GPIO_ERR_FG			EXYNOS4_GPF0(7)
#endif

#if defined(CONFIG_QC_MODEM)
/* Modem Interface GPIOs - MDM */
#define GPIO_MODEM_BOOT_MODE		EXYNOS4_GPD0(1)
#define GPIO_MDM2AP_HSIC_READY		EXYNOS4_GPF1(1)
#define GPIO_AP2MDM_STATUS		EXYNOS4_GPF1(6)
#define GPIO_MDM2AP_HSIC_PWR_ACTIVE	EXYNOS4_GPF2(2)	/* AP2MDM_IPC2 */
#define GPIO_WCN_PRIORITY		EXYNOS4_GPC0(0)
#define GPIO_MDM_LTE_FRAME_SYNC		EXYNOS4_GPF2(4)
#define GPIO_AP2MDM_ERR_FATAL		EXYNOS4212_GPJ0(1)
#define GPIO_AP2MDM_PON_RESET_N		EXYNOS4_GPL2(5)
#define GPIO_AP2MDM_WAKEUP		EXYNOS4212_GPM2(4)
#define GPIO_AP2MDM_SOFT_RESET		EXYNOS4212_GPM3(3)
#define GPIO_AP2MDM_PMIC_RESET_N	EXYNOS4_GPL0(0)
#define GPIO_MDM2AP_STATUS		EXYNOS4_GPX0(5)
#define GPIO_MDM2AP_HSIC_RESUME_REQ	EXYNOS4_GPX3(5)	/* AP2MDM_IPC3 */
#define GPIO_AP2MDM_VDDMIN		EXYNOS4_GPX1(0)
#define GPIO_MDM2AP_VDDMIN		EXYNOS4_GPX1(1)
#define GPIO_MDM2AP_ERR_FATAL		EXYNOS4_GPX1(3)
#define GPIO_MDM_LTE_ACTIVE		EXYNOS4_GPX1(6)
#define GPIO_AP2MDM_HSIC_PORT_ACTIVE	EXYNOS4_GPX3(2)	/* AP2MDM_IPC1 */
#ifdef CONFIG_SIM_DETECT
#define GPIO_SIM_DETECT			EXYNOS4_GPX1(7) /* sim detect */
#endif
#endif

#endif /* __MACH_GPIO_MIDAS_H */
