#ifndef __MACH_GPIO_MIDAS_H
#define __MACH_GPIO_MIDAS_H __FILE__

#include <mach/gpio.h>

extern void midas_config_gpio_table(void);
extern void midas_config_sleep_gpio_table(void);

#define GPIO_eMMC_EN		EXYNOS4_GPK0(2)

#define GPIO_BOOT_MODE		EXYNOS4_GPX0(3)

/* MUIC gpio */
#define GPIO_MUIC_SDA		EXYNOS4_GPF0(0)
#define GPIO_MUIC_SCL		EXYNOS4_GPF0(1)
#define GPIO_MUIC_IRQ		EXYNOS4_GPX3(0)

#define GPIO_USB_SEL1		EXYNOS4212_GPJ0(6)

#if defined(CONFIG_IPCAM_01_BD)
#define GPIO_V_BUS_EN		EXYNOS4212_GPJ1(1)
#endif /* CONFIG_IPCAM_01_BD */
#define GPIO_V_BUS_INT		EXYNOS4_GPX2(4)

#define GPIO_PMIC_SDA		EXYNOS4_GPD0(2)
#define GPIO_PMIC_SCL		EXYNOS4_GPD0(3)
#define GPIO_PMIC_IRQ		EXYNOS4_GPX0(7)

#define GPIO_FM_SCL		EXYNOS4_GPY0(2)
#define GPIO_FM_SDA		EXYNOS4_GPY0(3)

//#define GPIO_CAM_SPI_SCLK	EXYNOS4_GPB(4)
//#define GPIO_CAM_SPI_SSN	EXYNOS4_GPB(5)
//#define GPIO_CAM_SPI_MISO	EXYNOS4_GPB(6)
//#define GPIO_CAM_SPI_MOSI	EXYNOS4_GPB(7)

#define GPIO_CAM_MCLK		EXYNOS4212_GPJ1(3)
#define GPIO_VTCAM_MCLK		EXYNOS4212_GPM2(2)

#define GPIO_IR_FILTER_ON_18V		EXYNOS4212_GPM0(1)
#define GPIO_IR_FILTER_OFF_18V	EXYNOS4212_GPM0(2)
#define GPIO_IR_FILTER_EN_18V		EXYNOS4212_GPM0(3)

//#define GPIO_ISP_STANDBY	EXYNOS4212_GPM0(1)
#define GPIO_CAM_IO_EN		EXYNOS4212_GPM0(7)
#define GPIO_ISP_CORE_EN	EXYNOS4212_GPM0(3)
#define GPIO_CAM_AF_EN		EXYNOS4212_GPM0(4)
#define GPIO_CAM_VT_nRST	EXYNOS4212_GPM1(6)

//#define GPIO_8M_CAM_SCL_18V	EXYNOS4_GPD1(0)
//#define GPIO_8M_CAM_SDA_18V	EXYNOS4_GPD1(1)

#define GPIO_VT_CAM_SCL_18V	EXYNOS4212_GPM4(2)
#define GPIO_VT_CAM_SDA_18V	EXYNOS4212_GPM4(3)
#define GPIO_VT_CAM_ID		EXYNOS4_GPF1(2)

/* define for prevent kernel build error */
#define GPIO_TF_EN		EXYNOS4_GPK2(2) /* for SD Card */

//#define GPIO_DET_35		EXYNOS4_GPX0(1)

#define GPIO_MIC_BIAS_EN	EXYNOS4_GPF1(7)
//#define GPIO_SUB_MIC_BIAS_EN	EXYNOS4_GPF2(0)
//#define GPIO_THIRD_MIC_BIAS_EN	EXYNOS4212_GPJ0(2)

//#define GPIO_PMU_RST		EXYNOS4_GPX3(2)

#define GPIO_TSP_INT		EXYNOS4212_GPM2(3)
#define GPIO_TSP_SDA_18V	EXYNOS4_GPA1(2)
#define GPIO_TSP_SCL_18V	EXYNOS4_GPA1(3)

#define GPIO_BT_EN		EXYNOS4_GPL0(6)
#define GPIO_BT_WAKE		EXYNOS4_GPX3(1)
#define GPIO_BT_HOST_WAKE	EXYNOS4_GPX2(6)
#define IRQ_BT_HOST_WAKE	IRQ_EINT(22)

#define GPIO_BT_RXD		EXYNOS4_GPA0(0)
#define GPIO_BT_RXD_AF		2

#define GPIO_BT_TXD		EXYNOS4_GPA0(1)
#define GPIO_BT_TXD_AF		2

#define GPIO_BT_CTS		EXYNOS4_GPA0(2)
#define GPIO_BT_CTS_AF		2

#define GPIO_BT_RTS		EXYNOS4_GPA0(3)
#define GPIO_BT_RTS_AF		2

//#define GPIO_GPS_RXD		EXYNOS4_GPA0(4)
//#define GPIO_GPS_RXD_AF		2

//#define GPIO_GPS_TXD		EXYNOS4_GPA0(5)
//#define GPIO_GPS_TXD_AF		2

//#define GPIO_GPS_CTS		EXYNOS4_GPA0(6)
//#define GPIO_GPS_CTS_AF		2

//#define GPIO_GPS_RTS		EXYNOS4_GPA0(7)
//#define GPIO_GPS_RTS_AF		2

//#define GPIO_FLM_RXD		EXYNOS4_GPA1(4)
//#define GPIO_FLM_RXD_AF		2

//#define GPIO_FLM_TXD		EXYNOS4_GPA1(5)
//#define GPIO_FLM_TXD_AF		2

#define GPIO_3_TOUCH_SCL	EXYNOS4_GPA1(2)
#define GPIO_3_TOUCH_SDA	EXYNOS4_GPA1(3)
#define GPIO_3_TOUCH_INT	EXYNOS4_GPL0(0)
//#define GPIO_3_TOUCH_EN		EXYNOS4212_GPM0(0)

//#define GPIO_HDMI_EN		EXYNOS4_GPL0(4)

//#define GPIO_VIBTONE_EN		EXYNOS4212_GPJ0(6)

#define GPIO_WLAN_EN		EXYNOS4212_GPJ0(0)
#define GPIO_WLAN_EN_AF		1
#define GPIO_WLAN_HOST_WAKE	EXYNOS4_GPX2(5)
#define GPIO_WLAN_HOST_WAKE_AF	0xF
#define GPIO_WLAN_SDIO_CLK	EXYNOS4_GPK3(0)
#define GPIO_WLAN_SDIO_CLK_AF	2
#define GPIO_WLAN_SDIO_CMD	EXYNOS4_GPK3(1)
#define GPIO_WLAN_SDIO_CMD_AF	2
#define GPIO_WLAN_SDIO_D0	EXYNOS4_GPK3(3)
#define GPIO_WLAN_SDIO_D0_AF	2
#define GPIO_WLAN_SDIO_D1	EXYNOS4_GPK3(4)
#define GPIO_WLAN_SDIO_D1_AF	2
#define GPIO_WLAN_SDIO_D2	EXYNOS4_GPK3(5)
#define GPIO_WLAN_SDIO_D2_AF	2
#define GPIO_WLAN_SDIO_D3	EXYNOS4_GPK3(6)
#define GPIO_WLAN_SDIO_D3_AF	2

//#define GPIO_LCD_22V_EN		EXYNOS4212_GPM4(4)
//#define GPIO_LCD_22V_EN_00		EXYNOS4_GPC0(1)

//#define GPIO_ISP_TXD		EXYNOS4212_GPM4(5)
//#define GPIO_ISP_RXD		EXYNOS4212_GPM4(6)

//#define GPIO_TA_EN		EXYNOS4_GPL2(2)

//#define GPIO_MHL_SEL		EXYNOS4_GPL0(3)

//#define GPIO_MHL_SDA_1_8V	EXYNOS4_GPF0(4)
//#define GPIO_MHL_SCL_1_8V	EXYNOS4_GPF0(6)
//#define GPIO_MHL_SDA_1_8V_00	EXYNOS4_GPB(2)
//#define GPIO_MHL_SCL_1_8V_00	EXYNOS4_GPB(3)

//#define GPIO_OTG_EN		EXYNOS4_GPF0(7)

#define GPIO_OLED_ID		EXYNOS4_GPF1(0)
#define GPIO_ISP_RESET		EXYNOS4_GPF1(3)
//#define GPIO_FUEL_SCL		EXYNOS4_GPF1(4)
//#define GPIO_FUEL_SDA		EXYNOS4_GPF1(5)

#define GPIO_MLCD_RST		EXYNOS4_GPF2(1)
//#define GPIO_S_LED_I2C_SCL	EXYNOS4_GPF2(6)
//#define GPIO_S_LED_I2C_SDA	EXYNOS4_GPF2(7)
#define GPIO_OLED_DET		EXYNOS4_GPF3(0)

#define GPIO_PMIC_DVS1		EXYNOS4212_GPM3(0)
#define GPIO_PMIC_DVS2		EXYNOS4212_GPM3(1)

/* Definitions for Sii 9244B0 */
#define GPIO_PMIC_DVS3		EXYNOS4212_GPM3(2)
#define GPIO_BUCK2_SEL		EXYNOS4_GPF3(1)
#define GPIO_BUCK3_SEL		EXYNOS4_GPF3(2)
#define GPIO_BUCK4_SEL		EXYNOS4_GPF3(3)
//#define GPIO_MHL_RST		EXYNOS4_GPF3(4)
//#define GPIO_MHL_INT		EXYNOS4_GPF3(5)
#define GPIO_MHL_INT_AF		S3C_GPIO_SFN(0xF)
//#define GPIO_MHL_WAKE_UP	EXYNOS4212_GPJ1(4)

//#define GPIO_RGB_INT		EXYNOS4_GPX2(2)
#define GPIO_VOL_UP		EXYNOS4_GPX2(2)
#define GPIO_VOL_DOWN		EXYNOS4_GPX2(3)
//#define GPIO_VOL_UP_00		EXYNOS4_GPX2(2)
//#define GPIO_VOL_DOWN_00	EXYNOS4_GPX3(3)

#define GPIO_IR_LED_ON		EXYNOS4212_GPJ1(0)
//#define GPIO_TORCH_EN		EXYNOS4212_GPJ1(1)
//#define GPIO_TORCH_SET		EXYNOS4212_GPJ1(2)

//#define GPIO_MHL_DSCL_2_8V	EXYNOS4_GPK1(0)
//#define GPIO_MHL_DSDA_2_8V	EXYNOS4_GPK1(2)

//#define MHL_INT_IRQ		gpio_to_irq(GPIO_MHL_INT)
//#define MHL_WAKEUP_IRQ		gpio_to_irq(GPIO_MHL_WAKE_UP)

//#define GPIO_HDMI_CEC		EXYNOS4_GPX3(6)
//#define GPIO_HDMI_HPD		EXYNOS4_GPX3(7)

#define GPIO_nPOWER		EXYNOS4_GPX2(7)
#define GPIO_RESET_KEY		EXYNOS4_GPY2(3)
#define GPIO_EASY_SETUP		EXYNOS4_GPX3(6)

//#define GPIO_OK_KEY		EXYNOS4_GPX3(5)

//#define GPIO_FUEL_ALERT		EXYNOS4_GPX2(3)

#define IR_LED_PWM	EXYNOS4_GPD0(1)

//#define GPIO_CODEC_SDA_18V	EXYNOS4_GPD0(2)
//#define GPIO_CODEC_SCL_18V	EXYNOS4_GPD0(3)
#define GPIO_CODEC_SDA_18V_00		EXYNOS4_GPB(0)
#define GPIO_CODEC_SCL_18V_00		EXYNOS4_GPB(1)

/* service led */
#define GPIO_LED1_EN		EXYNOS4_GPL0(2)
#define GPIO_LED2_EN		EXYNOS4_GPL0(1)
#define GPIO_LED3_EN		EXYNOS4_GPL0(4)
/* debug led */
#define GPIO_SW_LED1_EN		EXYNOS4212_GPM0(5)
#define GPIO_SW_LED2_EN		EXYNOS4212_GPM0(6)

#define GPIO_WM8994_LDO		EXYNOS4212_GPJ0(4)

#define GPIO_FM_RST		EXYNOS4_GPC1(0)

//#define GPIO_OK_KEY_ANDROID	EXYNOS4_GPX0(1)		/*system_rev == 11*/
//#define GPIO_OK_KEY_ANDROID_F EXYNOS4_GPX1(3)	/*system_rev >= 15*/

//#define GPIO_FM_INT_REV15	EXYNOS4_GPX1(4)
//#define GPIO_FM_INT_REV07	EXYNOS4_GPX1(3)
#define GPIO_FM_INT		EXYNOS4_GPX1(3)
#define GPIO_FM_MIC_SW		EXYNOS4_GPL0(3)

#endif /* __MACH_GPIO_MIDAS_H */
