/*
 * Copyright 2012, The Android Open Source Project
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#define LOG_TAG "GraphicsOperation"

#include "config.h"
#include "GraphicsOperation.h"

#include "AndroidLog.h"
//AndroidJB4.3 Merge  - START
//#include "LinearAllocator.h"
#include <utils/LinearAllocator.h>
//AndroidJB4.3 Merge  - END
namespace WebCore {
namespace GraphicsOperation {

//AndroidJB4.3 Merge  - START
//void* Operation::operator new(size_t size, LinearAllocator* allocator)
void* Operation::operator new(size_t size, android::LinearAllocator* allocator) 
//AndroidJB4.3 Merge  - END
{
    return allocator->alloc(size);
}

void* Operation::operator new(size_t size)
{
    ALOGE("Cannot allocate a new Operation directly!");
    CRASH();
    return (void*) 0xBADBEEF;
}

void Operation::operator delete(void*)
{
    ALOGE("Cannot call delete on an Operation!");
    CRASH();
}

} // namespace GraphicsOperation
} // namespace WebCore
