/*
 * Copyright 2010, The Android Open Source Project
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ANDROID_APP_L10N_UTIL_H_
#define ANDROID_APP_L10N_UTIL_H_
#pragma once

#include "base/string16.h"
#include "jni/jni_utils.h"

#define IDS_AUTOFILL_DIALOG_ADDRESS_NAME_SEPARATOR 0
#define IDS_AUTOFILL_DIALOG_ADDRESS_SUMMARY_NAME_FORMAT 1
#define IDS_AUTOFILL_DIALOG_ADDRESS_SUMMARY_SEPARATOR 2
#define IDS_AUTOFILL_DIALOG_ADDRESS_SUMMARY_FORMAT 3
#define IDS_AUTOFILL_ATTENTION_IGNORED_RE 4
#define IDS_AUTOFILL_REGION_IGNORED_RE 5
#define IDS_AUTOFILL_COMPANY_RE 6
#define IDS_AUTOFILL_ADDRESS_LINE_1_RE 7
#define IDS_AUTOFILL_ADDRESS_LINE_1_LABEL_RE 8
#define IDS_AUTOFILL_ADDRESS_LINE_2_RE 9
#define IDS_AUTOFILL_ADDRESS_LINE_3_RE 10
#define IDS_AUTOFILL_COUNTRY_RE 11
#define IDS_AUTOFILL_ZIP_CODE_RE 12
#define IDS_AUTOFILL_ZIP_4_RE 13
#define IDS_AUTOFILL_CITY_RE 14
#define IDS_AUTOFILL_STATE_RE 15
#define IDS_AUTOFILL_ADDRESS_TYPE_SAME_AS_RE 16
#define IDS_AUTOFILL_ADDRESS_TYPE_USE_MY_RE 17
#define IDS_AUTOFILL_BILLING_DESIGNATOR_RE 18
#define IDS_AUTOFILL_SHIPPING_DESIGNATOR_RE 19
#define IDS_AUTOFILL_EMAIL_RE 20
#define IDS_AUTOFILL_USERNAME_RE 21
#define IDS_AUTOFILL_NAME_RE 22
#define IDS_AUTOFILL_NAME_SPECIFIC_RE 23
#define IDS_AUTOFILL_FIRST_NAME_RE 24
#define IDS_AUTOFILL_MIDDLE_INITIAL_RE 25
#define IDS_AUTOFILL_MIDDLE_NAME_RE 26
#define IDS_AUTOFILL_LAST_NAME_RE 27
#define IDS_AUTOFILL_PHONE_RE 28
#define IDS_AUTOFILL_AREA_CODE_RE 29
#define IDS_AUTOFILL_PHONE_PREFIX_RE 30
#define IDS_AUTOFILL_PHONE_SUFFIX_RE 31
#define IDS_AUTOFILL_PHONE_EXTENSION_RE 32
#define IDS_AUTOFILL_NAME_ON_CARD_RE 33
#define IDS_AUTOFILL_NAME_ON_CARD_CONTEXTUAL_RE 34
#define IDS_AUTOFILL_CARD_CVC_RE 35
#define IDS_AUTOFILL_CARD_NUMBER_RE 36
#define IDS_AUTOFILL_EXPIRATION_MONTH_RE 37
#define IDS_AUTOFILL_EXPIRATION_DATE_RE 38
#define IDS_AUTOFILL_CARD_IGNORED_RE 39
#define IDS_AUTOFILL_FAX_RE 40
#define IDS_AUTOFILL_COUNTRY_CODE_RE 41
#define IDS_AUTOFILL_AREA_CODE_NOTEXT_RE 42
#define IDS_AUTOFILL_PHONE_PREFIX_SEPARATOR_RE 43
#define IDS_AUTOFILL_PHONE_SUFFIX_SEPARATOR_RE 44
#define IDS_AUTOFILL_DIALOG_PROVINCE 45
#define IDS_AUTOFILL_DIALOG_POSTAL_CODE 46
#define IDS_AUTOFILL_DIALOG_STATE 47
#define IDS_AUTOFILL_DIALOG_ZIP_CODE 48
#define IDS_AUTOFILL_DIALOG_COUNTY 49
#define IDS_AUTOFILL_DIALOG_ISLAND 50
#define IDS_AUTOFILL_DIALOG_DISTRICT 51
#define IDS_AUTOFILL_DIALOG_DEPARTMENT 52
#define IDS_AUTOFILL_DIALOG_PREFECTURE 53
#define IDS_AUTOFILL_DIALOG_PARISH 54
#define IDS_AUTOFILL_DIALOG_AREA 55
#define IDS_AUTOFILL_DIALOG_EMIRATE 56
// Don't forget to update the count if you add a new message ID!
// (And also update frameworks/base/core/java/android/webkitsec/L10nUtils.java)
#define ANDROID_L10N_IDS_MESSAGE_COUNT 57

namespace l10n_util {
string16 GetStringUTF16(int message_id);
string16 GetStringFUTF16(int message_id, const string16& a, const string16& b, const string16& c);
std::string GetApplicationLocale();
}
#endif
