/* linux/drivers/media/video/samsung/tv20/s5pc100/regs/regs-hdmi.h
 *
 * Hdmi register header file for Samsung TVOut driver
 *
 * Copyright (c) 2009 Samsung Electronics
 * 	http://www.samsungsemi.com/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_REGS_HDMI_H

#include <mach/map.h>

#define S5P_HDMI_BASE(x) (x)

#define S5P_HDMI_CON_0 			S5P_HDMI_BASE(0x0000)
#define S5P_HDMI_CON_1			S5P_HDMI_BASE(0x0004)
#define S5P_HDMI_CON_2			S5P_HDMI_BASE(0x0008)
#define S5P_STATUS			S5P_HDMI_BASE(0x0010)
#define S5P_STATUS_EN			S5P_HDMI_BASE(0x0020)
#define S5P_HPD				S5P_HDMI_BASE(0x0030)
#define S5P_MODE_SEL			S5P_HDMI_BASE(0x0040)
#define S5P_ENC_EN			S5P_HDMI_BASE(0x0044)
#define S5P_BLUE_SCREEN_0		S5P_HDMI_BASE(0x0050)
#define S5P_BLUE_SCREEN_1		S5P_HDMI_BASE(0x0054)
#define S5P_BLUE_SCREEN_2		S5P_HDMI_BASE(0x0058)
#define S5P_HDMI_YMAX			S5P_HDMI_BASE(0x0060)
#define S5P_HDMI_YMIN			S5P_HDMI_BASE(0x0064)
#define S5P_HDMI_CMAX			S5P_HDMI_BASE(0x0068)
#define S5P_HDMI_CMIN			S5P_HDMI_BASE(0x006C)
#define S5P_VBI_ST_MG			S5P_HDMI_BASE(0x0080)
#define S5P_VBI_END_MG			S5P_HDMI_BASE(0x0084)
#define S5P_VACT_ST_MG			S5P_HDMI_BASE(0x0088)
#define S5P_VACT_END_MG			S5P_HDMI_BASE(0x008C)
#define S5P_H_BLANK_0			S5P_HDMI_BASE(0x00A0)
#define S5P_H_BLANK_1			S5P_HDMI_BASE(0x00A4)
#define S5P_V_BLANK_0			S5P_HDMI_BASE(0x00B0)
#define S5P_V_BLANK_1			S5P_HDMI_BASE(0x00B4)
#define S5P_V_BLANK_2			S5P_HDMI_BASE(0x00B8)
#define S5P_H_V_LINE_0			S5P_HDMI_BASE(0x00C0)
#define S5P_H_V_LINE_1			S5P_HDMI_BASE(0x00C4)
#define S5P_H_V_LINE_2			S5P_HDMI_BASE(0x00C8)
#define S5P_SYNC_MODE			S5P_HDMI_BASE(0x00E4)
#define S5P_INT_PRO_MODE		S5P_HDMI_BASE(0x00E8)
#define S5P_SEND_PER_START0		S5P_HDMI_BASE(0x00f0)
#define S5P_SEND_PER_START1		S5P_HDMI_BASE(0x00f4)
#define S5P_SEND_PER_END0		S5P_HDMI_BASE(0x0100)
#define S5P_SEND_PER_END1		S5P_HDMI_BASE(0x0104)
#define S5P_SEND_PER_END2		S5P_HDMI_BASE(0x0108)
#define S5P_V_BLANK_F_0			S5P_HDMI_BASE(0x0110)
#define S5P_V_BLANK_F_1			S5P_HDMI_BASE(0x0114)
#define S5P_V_BLANK_F_2			S5P_HDMI_BASE(0x0118)
#define S5P_H_SYNC_GEN_0		S5P_HDMI_BASE(0x0120)
#define S5P_H_SYNC_GEN_1		S5P_HDMI_BASE(0x0124)
#define S5P_H_SYNC_GEN_2		S5P_HDMI_BASE(0x0128)
#define S5P_V_SYNC_GEN_1_0		S5P_HDMI_BASE(0x0130)
#define S5P_V_SYNC_GEN_1_1		S5P_HDMI_BASE(0x0134)
#define S5P_V_SYNC_GEN_1_2		S5P_HDMI_BASE(0x0138)
#define S5P_V_SYNC_GEN_2_0		S5P_HDMI_BASE(0x0140)
#define S5P_V_SYNC_GEN_2_1		S5P_HDMI_BASE(0x0144)
#define S5P_V_SYNC_GEN_2_2		S5P_HDMI_BASE(0x0148)
#define S5P_V_SYNC_GEN_3_0		S5P_HDMI_BASE(0x0150)
#define S5P_V_SYNC_GEN_3_1		S5P_HDMI_BASE(0x0154)
#define S5P_V_SYNC_GEN_3_2		S5P_HDMI_BASE(0x0158)
#define S5P_ASP_CON 			S5P_HDMI_BASE(0x0160)
#define S5P_ASP_SP_FLAT			S5P_HDMI_BASE(0x0164)
#define S5P_ASP_CHCFG0			S5P_HDMI_BASE(0x0170)
#define S5P_ASP_CHCFG1			S5P_HDMI_BASE(0x0174)
#define S5P_ASP_CHCFG2			S5P_HDMI_BASE(0x0178)
#define S5P_ASP_CHCFG3			S5P_HDMI_BASE(0x017C)
#define S5P_ACR_CON			S5P_HDMI_BASE(0x0180)
#define S5P_ACR_MCTS0			S5P_HDMI_BASE(0x0184)
#define S5P_ACR_MCTS1			S5P_HDMI_BASE(0x0188)
#define S5P_ACR_MCTS2			S5P_HDMI_BASE(0x018C)
#define S5P_ACR_CTS0			S5P_HDMI_BASE(0x0190)
#define S5P_ACR_CTS1			S5P_HDMI_BASE(0x0194)
#define S5P_ACR_CTS2			S5P_HDMI_BASE(0x0198)
#define S5P_ACR_N0			S5P_HDMI_BASE(0x01A0)
#define S5P_ACR_N1			S5P_HDMI_BASE(0x01A4)
#define S5P_ACR_N2			S5P_HDMI_BASE(0x01A8)
#define S5P_ACR_LSB2			S5P_HDMI_BASE(0x01B0)
#define S5P_ACR_TXCNT			S5P_HDMI_BASE(0x01B4)
#define S5P_ACR_TXINTERVAL		S5P_HDMI_BASE(0x01B8)
#define S5P_ACR_CTS_OFFSET		S5P_HDMI_BASE(0x01BC)
#define S5P_GCP_CON			S5P_HDMI_BASE(0x01C0)
#define S5P_GCP_BYTE1			S5P_HDMI_BASE(0x01D0)
#define S5P_ACP_CON			S5P_HDMI_BASE(0x01E0)
#define S5P_ACP_TYPE			S5P_HDMI_BASE(0x01E4)

#define S5P_ACP_DATA0			S5P_HDMI_BASE(0x0200)
#define S5P_ACP_DATA1			S5P_HDMI_BASE(0x0204)
#define S5P_ACP_DATA2			S5P_HDMI_BASE(0x0208)
#define S5P_ACP_DATA3			S5P_HDMI_BASE(0x020c)
#define S5P_ACP_DATA4			S5P_HDMI_BASE(0x0210)
#define S5P_ACP_DATA5			S5P_HDMI_BASE(0x0214)
#define S5P_ACP_DATA6			S5P_HDMI_BASE(0x0218)
#define S5P_ACP_DATA7			S5P_HDMI_BASE(0x021c)
#define S5P_ACP_DATA8			S5P_HDMI_BASE(0x0220)
#define S5P_ACP_DATA9			S5P_HDMI_BASE(0x0224)
#define S5P_ACP_DATA10			S5P_HDMI_BASE(0x0228)
#define S5P_ACP_DATA11			S5P_HDMI_BASE(0x022c)
#define S5P_ACP_DATA12			S5P_HDMI_BASE(0x0230)
#define S5P_ACP_DATA13			S5P_HDMI_BASE(0x0234)
#define S5P_ACP_DATA14			S5P_HDMI_BASE(0x0238)
#define S5P_ACP_DATA15			S5P_HDMI_BASE(0x023c)
#define S5P_ACP_DATA16			S5P_HDMI_BASE(0x0240)

#define S5P_ISRC_CON			S5P_HDMI_BASE(0x0250)
#define S5P_ISRC1_HEADER1		S5P_HDMI_BASE(0x0264)

#define S5P_ISRC1_DATA0 		S5P_HDMI_BASE(0x0270)
#define S5P_ISRC1_DATA1			S5P_HDMI_BASE(0x0274)
#define S5P_ISRC1_DATA2			S5P_HDMI_BASE(0x0278)
#define S5P_ISRC1_DATA3			S5P_HDMI_BASE(0x027c)
#define S5P_ISRC1_DATA4			S5P_HDMI_BASE(0x0280)
#define S5P_ISRC1_DATA5			S5P_HDMI_BASE(0x0284)
#define S5P_ISRC1_DATA6			S5P_HDMI_BASE(0x0288)
#define S5P_ISRC1_DATA7			S5P_HDMI_BASE(0x028c)
#define S5P_ISRC1_DATA8			S5P_HDMI_BASE(0x0290)
#define S5P_ISRC1_DATA9			S5P_HDMI_BASE(0x0294)
#define S5P_ISRC1_DATA10		S5P_HDMI_BASE(0x0298)
#define S5P_ISRC1_DATA11		S5P_HDMI_BASE(0x029c)
#define S5P_ISRC1_DATA12		S5P_HDMI_BASE(0x02a0)
#define S5P_ISRC1_DATA13		S5P_HDMI_BASE(0x02a4)
#define S5P_ISRC1_DATA14		S5P_HDMI_BASE(0x02a8)
#define S5P_ISRC1_DATA15		S5P_HDMI_BASE(0x02ac)

#define S5P_ISRC2_DATA0 		S5P_HDMI_BASE(0x02b0)
#define S5P_ISRC2_DATA1			S5P_HDMI_BASE(0x02b4)
#define S5P_ISRC2_DATA2			S5P_HDMI_BASE(0x02b8)
#define S5P_ISRC2_DATA3			S5P_HDMI_BASE(0x02bc)
#define S5P_ISRC2_DATA4			S5P_HDMI_BASE(0x02c0)
#define S5P_ISRC2_DATA5			S5P_HDMI_BASE(0x02c4)
#define S5P_ISRC2_DATA6			S5P_HDMI_BASE(0x02c8)
#define S5P_ISRC2_DATA7			S5P_HDMI_BASE(0x02cc)
#define S5P_ISRC2_DATA8			S5P_HDMI_BASE(0x02d0)
#define S5P_ISRC2_DATA9			S5P_HDMI_BASE(0x02d4)
#define S5P_ISRC2_DATA10		S5P_HDMI_BASE(0x02d8)
#define S5P_ISRC2_DATA11		S5P_HDMI_BASE(0x02dc)
#define S5P_ISRC2_DATA12		S5P_HDMI_BASE(0x02e0)
#define S5P_ISRC2_DATA13		S5P_HDMI_BASE(0x02e4)
#define S5P_ISRC2_DATA14		S5P_HDMI_BASE(0x02e8)
#define S5P_ISRC2_DATA15		S5P_HDMI_BASE(0x02ec)

#define S5P_AVI_CON			S5P_HDMI_BASE(0x0300)
#define S5P_AVI_CHECK_SUM		S5P_HDMI_BASE(0x0310)

#define S5P_AVI_BYTE1			S5P_HDMI_BASE(0x0320)
#define S5P_AVI_BYTE2			S5P_HDMI_BASE(0x0324)
#define S5P_AVI_BYTE3			S5P_HDMI_BASE(0x0328)
#define S5P_AVI_BYTE4			S5P_HDMI_BASE(0x032c)
#define S5P_AVI_BYTE5			S5P_HDMI_BASE(0x0330)
#define S5P_AVI_BYTE6			S5P_HDMI_BASE(0x0334)
#define S5P_AVI_BYTE7			S5P_HDMI_BASE(0x0338)
#define S5P_AVI_BYTE8			S5P_HDMI_BASE(0x033c)
#define S5P_AVI_BYTE9			S5P_HDMI_BASE(0x0340)
#define S5P_AVI_BYTE10			S5P_HDMI_BASE(0x0344)
#define S5P_AVI_BYTE11			S5P_HDMI_BASE(0x0348)
#define S5P_AVI_BYTE12			S5P_HDMI_BASE(0x034c)
#define S5P_AVI_BYTE13			S5P_HDMI_BASE(0x0350)

#define S5P_AUI_CON			S5P_HDMI_BASE(0x0360)
#define S5P_AUI_CHECK_SUM		S5P_HDMI_BASE(0x0370)

#define S5P_AUI_BYTE1			S5P_HDMI_BASE(0x0380)
#define S5P_AUI_BYTE2			S5P_HDMI_BASE(0x0384)
#define S5P_AUI_BYTE3			S5P_HDMI_BASE(0x0388)
#define S5P_AUI_BYTE4			S5P_HDMI_BASE(0x038c)
#define S5P_AUI_BYTE5			S5P_HDMI_BASE(0x0390)

#define S5P_MPG_CON			S5P_HDMI_BASE(0x03A0)
#define S5P_MPG_CHECK_SUM		S5P_HDMI_BASE(0x03B0)

#define S5P_MPEG_BYTE1			S5P_HDMI_BASE(0x03c0)
#define S5P_MPEG_BYTE2			S5P_HDMI_BASE(0x03c4)
#define S5P_MPEG_BYTE3			S5P_HDMI_BASE(0x03c8)
#define S5P_MPEG_BYTE4			S5P_HDMI_BASE(0x03cc)
#define S5P_MPEG_BYTE5			S5P_HDMI_BASE(0x03d0)

#define S5P_SPD_CON			S5P_HDMI_BASE(0x0400)
#define S5P_SPD_HEADER0			S5P_HDMI_BASE(0x0410)
#define S5P_SPD_HEADER1			S5P_HDMI_BASE(0x0414)
#define S5P_SPD_HEADER2			S5P_HDMI_BASE(0x0418)

#define S5P_SPD_DATA0			S5P_HDMI_BASE(0x0420)
#define S5P_SPD_DATA1			S5P_HDMI_BASE(0x0424)
#define S5P_SPD_DATA2			S5P_HDMI_BASE(0x0428)
#define S5P_SPD_DATA3			S5P_HDMI_BASE(0x042c)
#define S5P_SPD_DATA4			S5P_HDMI_BASE(0x0430)
#define S5P_SPD_DATA5			S5P_HDMI_BASE(0x0434)
#define S5P_SPD_DATA6			S5P_HDMI_BASE(0x0438)
#define S5P_SPD_DATA7			S5P_HDMI_BASE(0x043c)
#define S5P_SPD_DATA8			S5P_HDMI_BASE(0x0440)
#define S5P_SPD_DATA9			S5P_HDMI_BASE(0x0444)
#define S5P_SPD_DATA10			S5P_HDMI_BASE(0x0448)
#define S5P_SPD_DATA11			S5P_HDMI_BASE(0x044c)
#define S5P_SPD_DATA12			S5P_HDMI_BASE(0x0450)
#define S5P_SPD_DATA13			S5P_HDMI_BASE(0x0454)
#define S5P_SPD_DATA14			S5P_HDMI_BASE(0x0458)
#define S5P_SPD_DATA15			S5P_HDMI_BASE(0x045c)
#define S5P_SPD_DATA16			S5P_HDMI_BASE(0x0460)
#define S5P_SPD_DATA17			S5P_HDMI_BASE(0x0464)
#define S5P_SPD_DATA18			S5P_HDMI_BASE(0x0468)
#define S5P_SPD_DATA19			S5P_HDMI_BASE(0x046c)
#define S5P_SPD_DATA20			S5P_HDMI_BASE(0x0470)
#define S5P_SPD_DATA21			S5P_HDMI_BASE(0x0474)
#define S5P_SPD_DATA22			S5P_HDMI_BASE(0x0478)
#define S5P_SPD_DATA23			S5P_HDMI_BASE(0x048c)
#define S5P_SPD_DATA24			S5P_HDMI_BASE(0x0480)
#define S5P_SPD_DATA25			S5P_HDMI_BASE(0x0484)
#define S5P_SPD_DATA26			S5P_HDMI_BASE(0x0488)
#define S5P_SPD_DATA27			S5P_HDMI_BASE(0x048c)
#define S5P_HDMI_CSC_CON		S5P_HDMI_BASE(0x0490)
#define S5P_HDMI_Y_G_COEF_L		S5P_HDMI_BASE(0x04A0)
#define S5P_HDMI_Y_G_COEF_H		S5P_HDMI_BASE(0x04A4)
#define S5P_HDMI_Y_B_COEF_L		S5P_HDMI_BASE(0x04A8)
#define S5P_HDMI_Y_B_COEF_H		S5P_HDMI_BASE(0x04AC)
#define S5P_HDMI_Y_R_COEF_L		S5P_HDMI_BASE(0x04B0)
#define S5P_HDMI_Y_R_COEF_H		S5P_HDMI_BASE(0x04B4)
#define S5P_HDMI_CB_G_COEF_L		S5P_HDMI_BASE(0x04B8)
#define S5P_HDMI_CB_G_COEF_H		S5P_HDMI_BASE(0x04BC)
#define S5P_HDMI_CB_B_COEF_L		S5P_HDMI_BASE(0x04C0)
#define S5P_HDMI_CB_B_COEF_H		S5P_HDMI_BASE(0x04C4)
#define S5P_HDMI_CB_R_COEF_L		S5P_HDMI_BASE(0x04C8)
#define S5P_HDMI_CB_R_COEF_H		S5P_HDMI_BASE(0x04CC)
#define S5P_HDMI_CR_G_COEF_L		S5P_HDMI_BASE(0x04D0)
#define S5P_HDMI_CR_G_COEF_H		S5P_HDMI_BASE(0x04D4)
#define S5P_HDMI_CR_B_COEF_L		S5P_HDMI_BASE(0x04D8)
#define S5P_HDMI_CR_B_COEF_H		S5P_HDMI_BASE(0x04DC)
#define S5P_HDMI_CR_R_COEF_L		S5P_HDMI_BASE(0x04E0)
#define S5P_HDMI_CR_R_COEF_H		S5P_HDMI_BASE(0x04E4)

#define S5P_HDCP_RX_SHA1_0_0		S5P_HDMI_BASE(0x0600)
#define S5P_HDCP_RX_SHA1_0_1		S5P_HDMI_BASE(0x0604)
#define S5P_HDCP_RX_SHA1_0_2		S5P_HDMI_BASE(0x0608)
#define S5P_HDCP_RX_SHA1_0_3		S5P_HDMI_BASE(0x060C)
#define S5P_HDCP_RX_SHA1_1_0		S5P_HDMI_BASE(0x0610)
#define S5P_HDCP_RX_SHA1_1_1		S5P_HDMI_BASE(0x0614)
#define S5P_HDCP_RX_SHA1_1_2		S5P_HDMI_BASE(0x0618)
#define S5P_HDCP_RX_SHA1_1_3		S5P_HDMI_BASE(0x061C)
#define S5P_HDCP_RX_SHA1_2_0		S5P_HDMI_BASE(0x0620)
#define S5P_HDCP_RX_SHA1_2_1		S5P_HDMI_BASE(0x0624)
#define S5P_HDCP_RX_SHA1_2_2		S5P_HDMI_BASE(0x0628)
#define S5P_HDCP_RX_SHA1_2_3		S5P_HDMI_BASE(0x062C)
#define S5P_HDCP_RX_SHA1_3_0		S5P_HDMI_BASE(0x0630)
#define S5P_HDCP_RX_SHA1_3_1		S5P_HDMI_BASE(0x0634)
#define S5P_HDCP_RX_SHA1_3_2		S5P_HDMI_BASE(0x0638)
#define S5P_HDCP_RX_SHA1_3_3		S5P_HDMI_BASE(0x063C)
#define S5P_HDCP_RX_SHA1_4_0		S5P_HDMI_BASE(0x0640)
#define S5P_HDCP_RX_SHA1_4_1		S5P_HDMI_BASE(0x0644)
#define S5P_HDCP_RX_SHA1_4_2		S5P_HDMI_BASE(0x0648)
#define S5P_HDCP_RX_SHA1_4_3		S5P_HDMI_BASE(0x064C)
#define S5P_HDCP_RX_KSV_0_0		S5P_HDMI_BASE(0x0650)
#define S5P_HDCP_RX_KSV_0_1		S5P_HDMI_BASE(0x0654)
#define S5P_HDCP_RX_KSV_0_2		S5P_HDMI_BASE(0x0658)
#define S5P_HDCP_RX_KSV_0_3		S5P_HDMI_BASE(0x065C)
#define S5P_HDCP_RX_KSV_0_4		S5P_HDMI_BASE(0x0660)
#define S5P_HDCP_RX_KSV_LIST_CTRL	S5P_HDMI_BASE(0x0664)
#define S5P_HDCP_AUTH_STATUS		S5P_HDMI_BASE(0x0670)
#define S5P_HDCP_CTRL			S5P_HDMI_BASE(0x0680)
#define S5P_HDCP_CHECK_RESULT		S5P_HDMI_BASE(0x0690)

#define S5P_HDCP_BKSV_0_0		S5P_HDMI_BASE(0x06A0)
#define S5P_HDCP_BKSV_0_1		S5P_HDMI_BASE(0x06A4)
#define S5P_HDCP_BKSV_0_2		S5P_HDMI_BASE(0x06A8)
#define S5P_HDCP_BKSV_0_3		S5P_HDMI_BASE(0x06AC)
#define S5P_HDCP_BKSV_1			S5P_HDMI_BASE(0x06B0)
#define S5P_HDCP_AKSV_0_0		S5P_HDMI_BASE(0x06C0)
#define S5P_HDCP_AKSV_0_1		S5P_HDMI_BASE(0x06C4)
#define S5P_HDCP_AKSV_0_2		S5P_HDMI_BASE(0x06C8)
#define S5P_HDCP_AKSV_0_3		S5P_HDMI_BASE(0x06CC)
#define S5P_HDCP_AKSV_1			S5P_HDMI_BASE(0x06D0)
#define S5P_HDCP_An_0_0			S5P_HDMI_BASE(0x06E0)
#define S5P_HDCP_An_0_1			S5P_HDMI_BASE(0x06E4)
#define S5P_HDCP_An_0_2			S5P_HDMI_BASE(0x06E8)
#define S5P_HDCP_An_0_3			S5P_HDMI_BASE(0x06EC)
#define S5P_HDCP_An_1_0			S5P_HDMI_BASE(0x06F0)
#define S5P_HDCP_An_1_1			S5P_HDMI_BASE(0x06F4)
#define S5P_HDCP_An_1_2			S5P_HDMI_BASE(0x06F8)
#define S5P_HDCP_An_1_3			S5P_HDMI_BASE(0x06FC)
#define S5P_HDCP_BCAPS			S5P_HDMI_BASE(0x0700)
#define S5P_HDCP_BSTATUS_0		S5P_HDMI_BASE(0x0710)
#define S5P_HDCP_BSTATUS_1		S5P_HDMI_BASE(0x0714)
#define S5P_HDCP_Ri_0			S5P_HDMI_BASE(0x0740)
#define S5P_HDCP_Ri_1			S5P_HDMI_BASE(0x0744)
#define S5P_HDCP_Pj			S5P_HDMI_BASE(0x0750)
#define S5P_HDCP_OFFSET_TX_0		S5P_HDMI_BASE(0x0760)
#define S5P_HDCP_OFFSET_TX_1		S5P_HDMI_BASE(0x0764)
#define S5P_HDCP_OFFSET_TX_2		S5P_HDMI_BASE(0x0768)
#define S5P_HDCP_OFFSET_TX_3		S5P_HDMI_BASE(0x076C)
#define S5P_HDCP_CYCLE_AA		S5P_HDMI_BASE(0x0770)
#define S5P_TG_CMD			S5P_HDMI_BASE(0x1000)
#define S5P_TG_H_FSZ_L			S5P_HDMI_BASE(0x1018)
#define S5P_TG_H_FSZ_H			S5P_HDMI_BASE(0x101C)
#define S5P_TG_HACT_ST_L		S5P_HDMI_BASE(0x1020)
#define S5P_TG_HACT_ST_H		S5P_HDMI_BASE(0x1024)
#define S5P_TG_HACT_SZ_L		S5P_HDMI_BASE(0x1028)
#define S5P_TG_HACT_SZ_H		S5P_HDMI_BASE(0x102C)
#define S5P_TG_V_FSZ_L			S5P_HDMI_BASE(0x1030)
#define S5P_TG_V_FSZ_H			S5P_HDMI_BASE(0x1034)
#define S5P_TG_VSYNC_L			S5P_HDMI_BASE(0x1038)
#define S5P_TG_VSYNC_H			S5P_HDMI_BASE(0x103C)
#define S5P_TG_VSYNC2_L			S5P_HDMI_BASE(0x1040)
#define S5P_TG_VSYNC2_H			S5P_HDMI_BASE(0x1044)
#define S5P_TG_VACT_ST_L		S5P_HDMI_BASE(0x1048)
#define S5P_TG_VACT_ST_H		S5P_HDMI_BASE(0x104C)
#define S5P_TG_VACT_SZ_L		S5P_HDMI_BASE(0x1050)
#define S5P_TG_VACT_SZ_H		S5P_HDMI_BASE(0x1054)
#define S5P_TG_FIELD_CHG_L		S5P_HDMI_BASE(0x1058)
#define S5P_TG_FIELD_CHG_H		S5P_HDMI_BASE(0x105C)
#define S5P_TG_VACT_ST2_L		S5P_HDMI_BASE(0x1060)
#define S5P_TG_VACT_ST2_H		S5P_HDMI_BASE(0x1064)
#define S5P_TG_VSYNC_TOP_HDMI_L		S5P_HDMI_BASE(0x1078)
#define S5P_TG_VSYNC_TOP_HDMI_H		S5P_HDMI_BASE(0x107C)
#define S5P_TG_VSYNC_BOT_HDMI_L		S5P_HDMI_BASE(0x1080)
#define S5P_TG_VSYNC_BOT_HDMI_H		S5P_HDMI_BASE(0x1084)
#define S5P_TG_FIELD_TOP_HDMI_L		S5P_HDMI_BASE(0x1088)
#define S5P_TG_FIELD_TOP_HDMI_H		S5P_HDMI_BASE(0x108C)
#define S5P_TG_FIELD_BOT_HDMI_L		S5P_HDMI_BASE(0x1090)
#define S5P_TG_FIELD_BOT_HDMI_H		S5P_HDMI_BASE(0x1094)
#define S5P_SPDIFIN_CLK_CTRL		S5P_HDMI_BASE(0x5000)
#define S5P_SPDIFIN_OP_CTRL		S5P_HDMI_BASE(0x5004)
#define S5P_SPDIFIN_IRQ_MASK		S5P_HDMI_BASE(0x5008)
#define S5P_SPDIFIN_IRQ_STATUS		S5P_HDMI_BASE(0x500C)
#define S5P_SPDIFIN_CONFIG_1		S5P_HDMI_BASE(0x5010)
#define S5P_SPDIFIN_CONFIG_2		S5P_HDMI_BASE(0x5014)
#define S5P_SPDIFIN_USER_VALUE_1	S5P_HDMI_BASE(0x5020)
#define S5P_SPDIFIN_USER_VALUE_2	S5P_HDMI_BASE(0x5024)
#define S5P_SPDIFIN_USER_VALUE_3	S5P_HDMI_BASE(0x5028)
#define S5P_SPDIFIN_USER_VALUE_4	S5P_HDMI_BASE(0x502C)
#define S5P_SPDIFIN_CH_STATUS_0_1	S5P_HDMI_BASE(0x5030)
#define S5P_SPDIFIN_CH_STATUS_0_2	S5P_HDMI_BASE(0x5034)
#define S5P_SPDIFIN_CH_STATUS_0_3	S5P_HDMI_BASE(0x5038)
#define S5P_SPDIFIN_CH_STATUS_0_4	S5P_HDMI_BASE(0x503C)
#define S5P_SPDIFIN_CH_STATUS_1		S5P_HDMI_BASE(0x5040)
#define S5P_SPDIFIN_FRAME_PERIOD_1	S5P_HDMI_BASE(0x5048)
#define S5P_SPDIFIN_FRAME_PERIOD_2	S5P_HDMI_BASE(0x504C)
#define S5P_SPDIFIN_Pc_INFO_1		S5P_HDMI_BASE(0x5050)
#define S5P_SPDIFIN_Pc_INFO_2		S5P_HDMI_BASE(0x5054)
#define S5P_SPDIFIN_Pd_INFO_1		S5P_HDMI_BASE(0x5058)
#define S5P_SPDIFIN_Pd_INFO_2		S5P_HDMI_BASE(0x505C)
#define S5P_SPDIFIN_DATA_BUF_0_1	S5P_HDMI_BASE(0x5060)
#define S5P_SPDIFIN_DATA_BUF_0_2	S5P_HDMI_BASE(0x5064)
#define S5P_SPDIFIN_DATA_BUF_0_3	S5P_HDMI_BASE(0x5068)
#define S5P_SPDIFIN_USER_BUF_0		S5P_HDMI_BASE(0x506C)
#define S5P_SPDIFIN_DATA_BUF_1_1	S5P_HDMI_BASE(0x5070)
#define S5P_SPDIFIN_DATA_BUF_1_2	S5P_HDMI_BASE(0x5074)
#define S5P_SPDIFIN_DATA_BUF_1_3	S5P_HDMI_BASE(0x5078)
#define S5P_SPDIFIN_USER_BUF_1		S5P_HDMI_BASE(0x507C)
#define S5P_HAES_CON			S5P_HDMI_BASE(0x6000)
#define S5P_HAES_DATA_SIZE_L		S5P_HDMI_BASE(0x6020)
#define S5P_HAES_DATA_SIZE_H		S5P_HDMI_BASE(0x6024)
#define S5P_HAES_DATA			S5P_HDMI_BASE(0x6030)

#define HDMI_TPGEN_0			S5P_HDMI_BASE(0x500)
#define HDMI_TPGEN_1			S5P_HDMI_BASE(0x504)
#define HDMI_TPGEN_2			S5P_HDMI_BASE(0x508)
#define HDMI_TPGEN_3			S5P_HDMI_BASE(0x50c)
#define HDMI_TPGEN_4			S5P_HDMI_BASE(0x510)
#define HDMI_TPGEN_5			S5P_HDMI_BASE(0x514)
#define HDMI_TPGEN_6			S5P_HDMI_BASE(0x518)

#define BLUE_SCR_EN			(1<<5)
#define BLUE_SCR_DIS			(0<<5)
#define ASP_EN				(1<<2)
#define ASP_DIS				(0<<2)
#define PWDN_ENB_NORMAL			(1<<1)
#define PWDN_ENB_PD			(0<<1)
#define HDMI_EN				(1<<0)
#define HDMI_DIS			(~HDMI_EN)

#define PX_LMT_CTRL_BYPASS		(0<<5)
#define PX_LMT_CTRL_RGB			(1<<5)
#define PX_LMT_CTRL_YPBPR		(2<<5)
#define PX_LMT_CTRL_RESERVED		(3<<5)

#define VID_PREAMBLE_EN			(0<<5)
#define VID_PREAMBLE_DIS		(1<<5)
#define GUARD_BAND_EN			(0<<1)
#define GUARD_BAND_DIS			(1<<1)


#define AUTHEN_ACK_AUTH			(1<<7)
#define AUTHEN_ACK_NOT			(0<<7)
#define AUD_FIFO_OVF_FULL		(1<<6)
#define AUD_FIFO_OVF_NOT		(0<<6)
#define UPDATE_RI_INT_OCC		(1<<4)
#define UPDATE_RI_INT_NOT		(0<<4)
#define UPDATE_RI_INT_CLEAR		(1<<4)
#define UPDATE_PJ_INT_OCC		(1<<3)
#define UPDATE_PJ_INT_NOT		(0<<3)
#define UPDATE_PJ_INT_CLEAR		(1<<3)
#define EXCHANGEKSV_INT_OCC		(1<<2)
#define EXCHANGEKSV_INT_NOT		(0<<2)
#define EXCHANGEKSV_INT_CLEAR		(1<<2)
#define WATCHDOG_INT_OCC		(1<<1)
#define WATCHDOG_INT_NOT		(0<<1)
#define WATCHDOG_INT_CLEAR		(1<<1)
#define WTFORACTIVERX_INT_OCC		(1)
#define WTFORACTIVERX_INT_NOT		(0)
#define WTFORACTIVERX_INT_CLEAR		(1)

#define AUD_FIFO_OVF_EN			(1<<6)
#define AUD_FIFO_OVF_DIS		(0<<6)
#define UPDATE_RI_INT_EN		(1<<4)
#define UPDATE_RI_INT_DIS		(0<<4)
#define UPDATE_PJ_INT_EN		(1<<3)
#define UPDATE_PJ_INT_DIS		(0<<3)
#define EXCHANGEKSV_INT_EN		(1<<2)
#define EXCHANGEKSV_INT_DIS		(0<<2)
#define WATCHDOG_INT_EN			(1<<1)
#define WATCHDOG_INT_DIS		(0<<1)
#define WTFORACTIVERX_INT_EN		(1)
#define WTFORACTIVERX_INT_DIS		(0)
#define HDCP_STATUS_EN_ALL		(UPDATE_RI_INT_EN|\
					UPDATE_PJ_INT_DIS|\
					EXCHANGEKSV_INT_EN|\
					WATCHDOG_INT_EN|\
					WTFORACTIVERX_INT_EN)

#define HDCP_STATUS_DIS_ALL		(~0x1f)

#define SW_HPD_PLUGGED			(1<<1)
#define SW_HPD_UNPLUGGED		(0<<1)

#define HDMI_MODE_EN			(1<<1)
#define HDMI_MODE_DIS			(0<<1)
#define DVI_MODE_EN			(1)
#define DVI_MODE_DIS			(0)

#define HDCP_ENC_ENABLE			(1)
#define HDCP_ENC_DISABLE		(0)

#define SET_BLUESCREEN_0(a)		(0xff&(a))

#define SET_BLUESCREEN_1(a)		(0xff&(a))

#define SET_BLUESCREEN_2(a)		(0xff&(a))

#define SET_HDMI_YMAX(a)		(0xff&(a))

#define SET_HDMI_YMIN(a)		(0xff&(a))

#define SET_HDMI_CMAX(a)		(0xff&(a))

#define SET_HDMI_CMIN(a)		(0xff&(a))


#define SET_VBI_ST_MG(a)		(0xff&(a))

#define SET_VBI_END_MG(a)		(0xff&(a))

#define SET_VACT_ST_MG(a)		(0xff&(a))


#define SET_H_BLANK_L(a)		(0xff&(a))

#define SET_H_BLANK_H(a)		(0x7&((a)>>8))

#define SET_V2_BLANK_L(a)		(0xff&(a))

#define SET_V1_BLANK_L(a)		((0x1f&(a))<<3)
#define SET_V2_BLANK_H(a)		(0x7&((a)>>8))

#define SET_V1_BLANK_H(a)		(0x3f&((a)>>5))

#define SET_V_LINE_L(a)			(0xff&(a))

#define SET_H_LINE_L(a)			((0xf&(a))<<4)
#define SET_V_LINE_H(a)			(0xf&((a)>>8))

#define SET_H_LINE_H(a)			(0xff&((a)>>4))

#define V_SYNC_POL_ACT_LOW		(1)
#define V_SYNC_POL_ACT_HIGH		(0)

#define INT_PRO_MODE_INTERLACE		(1)
#define INT_PRO_MODE_PROGRESSIVE		(0)

#define SET_V_BOT_ST_L(a)		(0xff&(a))

#define SET_V_BOT_END_L(a)		((0x1f&(a))<<3)
#define SET_V_BOT_ST_H(a)		(0x7&((a)>>8))

#define SET_V_BOT_END_H(a)		(0x3f&((a)>>5))


#define SET_HSYNC_START_L(a)		(0xff&(a))

#define SET_HSYNC_END_L(a)		((0x3f&(a))<<2)
#define SET_HSYNC_START_H(a)		(0x3&((a)>>8))

#define SET_HSYNC_POL_ACT_LOW		(1<<4)
#define SET_HSYNC_POL_ACT_HIGH		(0<<4)
#define SET_HSYNC_END_H(a)		(0xf&((a)>>6))

#define SET_VSYNC_T_END_L(a)		(0xff&(a))

#define SET_VSYNC_T_ST_L(a)		((0xf&(a))<<4)
#define SET_VSYNC_T_END_H(a)		(0xf&((a)>>8))

#define SET_VSYNC_T_ST_H(a)		(0xff&((a)>>4))

#define SET_VSYNC_B_END_L(a)		(0xff&(a))

#define SET_VSYNC_B_ST_L(a)		((0xf&(a))<<4)
#define SET_VSYNC_B_END_H(a)		(0xf&((a)>>8))

#define SET_VSYNC_B_ST_H(a)		(0xff&((a)>>4))


#define SET_VSYNC_H_POST_END_L(a)	(0xff&(a))

#define SET_VSYNC_H_POST_ST_L(a)	((0xf&(a))<<4)
#define SET_VSYNC_H_POST_END_H(a)	(0xf&((a)>>8))

#define SET_VSYNC_H_POST_ST_H(a)	(0xff&((a)>>4))


#define SACD_EN				(1<<5)
#define SACD_DIS			(0<<5)
#define AUD_MODE_MULTI_CH		(1<<4)
#define AUD_MODE_2_CH			(0<<4)
#define SET_SP_PRE(a)			(0xf&(a))

#define SET_SP_FLAT(a)			(0xf&(a))


#define SPK3R_SEL_I_PCM0L		(0<<27)
#define SPK3R_SEL_I_PCM0R		(1<<27)
#define SPK3R_SEL_I_PCM1L		(2<<27)
#define SPK3R_SEL_I_PCM1R		(3<<27)
#define SPK3R_SEL_I_PCM2L		(4<<27)
#define SPK3R_SEL_I_PCM2R		(5<<27)
#define SPK3R_SEL_I_PCM3L		(6<<27)
#define SPK3R_SEL_I_PCM3R		(7<<27)
#define SPK3L_SEL_I_PCM0L		(0<<24)
#define SPK3L_SEL_I_PCM0R		(1<<24)
#define SPK3L_SEL_I_PCM1L		(2<<24)
#define SPK3L_SEL_I_PCM1R		(3<<24)
#define SPK3L_SEL_I_PCM2L		(4<<24)
#define SPK3L_SEL_I_PCM2R		(5<<24)
#define SPK3L_SEL_I_PCM3L		(6<<24)
#define SPK3L_SEL_I_PCM3R		(7<<24)
#define SPK2R_SEL_I_PCM0L		(0<<19)
#define SPK2R_SEL_I_PCM0R		(1<<19)
#define SPK2R_SEL_I_PCM1L		(2<<19)
#define SPK2R_SEL_I_PCM1R		(3<<19)
#define SPK2R_SEL_I_PCM2L		(4<<19)
#define SPK2R_SEL_I_PCM2R		(5<<19)
#define SPK2R_SEL_I_PCM3L		(6<<19)
#define SPK2R_SEL_I_PCM3R		(7<<19)
#define SPK2L_SEL_I_PCM0L		(0<<16)
#define SPK2L_SEL_I_PCM0R		(1<<16)
#define SPK2L_SEL_I_PCM1L		(2<<16)
#define SPK2L_SEL_I_PCM1R		(3<<16)
#define SPK2L_SEL_I_PCM2L		(4<<16)
#define SPK2L_SEL_I_PCM2R		(5<<16)
#define SPK2L_SEL_I_PCM3L		(6<<16)
#define SPK2L_SEL_I_PCM3R		(7<<16)
#define SPK1R_SEL_I_PCM0L		(0<<11)
#define SPK1R_SEL_I_PCM0R		(1<<11)
#define SPK1R_SEL_I_PCM1L		(2<<11)
#define SPK1R_SEL_I_PCM1R		(3<<11)
#define SPK1R_SEL_I_PCM2L		(4<<11)
#define SPK1R_SEL_I_PCM2R		(5<<11)
#define SPK1R_SEL_I_PCM3L		(6<<11)
#define SPK1R_SEL_I_PCM3R		(7<<11)
#define SPK1L_SEL_I_PCM0L		(0<<8)
#define SPK1L_SEL_I_PCM0R		(1<<8)
#define SPK1L_SEL_I_PCM1L		(2<<8)
#define SPK1L_SEL_I_PCM1R		(3<<8)
#define SPK1L_SEL_I_PCM2L		(4<<8)
#define SPK1L_SEL_I_PCM2R		(5<<8)
#define SPK1L_SEL_I_PCM3L		(6<<8)
#define SPK1L_SEL_I_PCM3R		(7<<8)
#define SPK0R_SEL_I_PCM0L		(0<<3)
#define SPK0R_SEL_I_PCM0R		(1<<3)
#define SPK0R_SEL_I_PCM1L		(2<<3)
#define SPK0R_SEL_I_PCM1R		(3<<3)
#define SPK0R_SEL_I_PCM2L		(4<<3)
#define SPK0R_SEL_I_PCM2R		(5<<3)
#define SPK0R_SEL_I_PCM3L		(6<<3)
#define SPK0R_SEL_I_PCM3R		(7<<3)
#define SPK0L_SEL_I_PCM0L		(0)
#define SPK0L_SEL_I_PCM0R		(1)
#define SPK0L_SEL_I_PCM1L		(2)
#define SPK0L_SEL_I_PCM1R		(3)
#define SPK0L_SEL_I_PCM2L		(4)
#define SPK0L_SEL_I_PCM2R		(5)
#define SPK0L_SEL_I_PCM3L		(6)
#define SPK0L_SEL_I_PCM3R		(7)

#define ALT_CTS_RATE_CTS_1		(0<<3)
#define ALT_CTS_RATE_CTS_11		(1<<3)
#define ALT_CTS_RATE_CTS_21		(2<<3)
#define ALT_CTS_RATE_CTS_31		(3<<3)
#define ACR_TX_MODE_NO_TX		(0)
#define ACR_TX_MODE_TX_ONCE		(1)
#define ACR_TX_MODE_TXCNT_VBI		(2)
#define ACR_TX_MODE_TX_VPC		(3)
#define ACR_TX_MODE_MESURE_CTS		(4)


#define SET_ACR_MCTS(a)			(0xfffff&(a))


#define SET_ACR_CTS(a)			(0xfffff&(a))


#define SET_ACR_N(a)			(0xfffff&(a))

#define SET_ACR_LSB2(a)			(0xff&(a))

#define SET_ACR_TXCNT(a)		(0x1f&(a))

#define SET_ACR_TX_INTERNAL(a)		(0xff&(a))

#define SET_ACR_CTS_OFFSET(a)		(0xff&(a))

#define GCP_CON_NO_TRAN			(0)
#define GCP_CON_TRANS_ONCE		(1)
#define GCP_CON_TRANS_EVERY_VSYNC	(2)

#define SET_GCP_BYTE1(a)		(0xff&(a))


#define SET_ACP_FR_RATE(a)		((0x1f&(a))<<3)
#define ACP_CON_NO_TRAN			(0)
#define ACP_CON_TRANS_ONCE		(1)
#define ACP_CON_TRANS_EVERY_VSYNC	(2)

#define SET_ACP_TYPE(a)			(0xff&(a))

#define SET_ACP_DATA(a)			(0xff&(a))

#define SET_ISRC_FR_RATE(a)		((0x1f&(a))<<3)
#define ISRC_EN				(1<<2)
#define ISRC_DIS			(0<<2)
#define ISRC_TX_CON_NO_TRANS		(0)
#define ISRC_TX_CON_TRANS_ONCE		(1)
#define ISRC_TX_CON_TRANS_EVERY_VSYNC	(2)

#define SET_ISRC1_HEADER(a)		(0xff&(a))

#define SET_ISRC1_DATA(a)		(0xff&(a))

#define SET_ISRC2_DATA(a)		(0xff&(a))


#define AVI_TX_CON_NO_TRANS		(0)
#define AVI_TX_CON_TRANS_ONCE		(1)
#define AVI_TX_CON_TRANS_EVERY_VSYNC	(2)


#define SET_AVI_CHECK_SUM(a)		(0xff&(a))

#define SET_AVI_BYTE(a)			(0xff&(a))


#define AUI_TX_CON_NO_TRANS		(0)
#define AUI_TX_CON_TRANS_ONCE		(1)
#define AUI_TX_CON_TRANS_EVERY_VSYNC	(2)


#define SET_AUI_CHECK_SUM(a)		(0xff&(a))

#define SET_AUI_BYTE(a)			(0xff&(a))


#define MPG_TX_CON_NO_TRANS		(0)
#define MPG_TX_CON_TRANS_ONCE		(1)
#define MPG_TX_CON_TRANS_EVERY_VSYNC	(2)


#define SET_MPG_CHECK_SUM(a)		(0xff&(a))


#define SET_MPG_BYTE(a)			(0xff&(a))


#define SPD_TX_CON_NO_TRANS		(0)
#define SPD_TX_CON_TRANS_ONCE		(1)
#define SPD_TX_CON_TRANS_EVERY_VSYNC	(2)


#define SET_SPD_HEADER(a)		(0xff&(a))

#define SET_SPD_DATA(a)			(0xff&(a))


#define OUT_OFFSET_SEL_RGB_FR		(0<<4)
#define OUT_OFFSET_SEL_RGB_LR		(2<<4)
#define OUT_OFFSET_SEL_YCBCR		(3<<4)
#define IN_CLIP_EN			(1<<2)
#define IN_CLIP_DIS			(0<<2)
#define IN_OFFSET_SEL_RGB_FR		(0)
#define IN_OFFSET_SEL_RGB_LR		(2)
#define IN_OFFSET_SEL_YCBCR		(3)

#define SET_HDMI_CSC_COEF_L(a)		(0xff&(a))
#define SET_HDMI_CSC_COEF_H(a)		(0x3&((a)>>8))

#define SET_HDMI_SHA1(a)		(0xff&(a))

#define GETSYNC_TYPE_EN			(1<<4)
#define GETSYNC_TYPE_DIS		(0<<4)
#define GETSYNC_EN			(1<<3)
#define GETSYNC_DIS			(0<<3)
#define FIELD_EN			(1<<2)
#define FIELD_DIS			(0<<2)
#define TG_EN				(1)
#define TG_DIS				(0)

#define SET_TG_H_FSZ_L(a)		(0xff&(a))

#define SET_TG_H_FSZ_H(a)		(0x1f&((a)>>8))

#define SET_TG_HACT_ST_L(a)		(0xff&(a))

#define SET_TG_HACT_ST_H(a)		(0xf&((a)>>8))

#define SET_TG_HACT_SZ_L(a)		(0xff&(a))

#define SET_TG_HACT_SZ_H(a)		(0xf&((a)>>8))

#define SET_TG_V_FSZ_L(a)		(0xff&(a))

#define SET_TG_V_FSZ_H(a)		(0x7&((a)>>8))

#define SET_TG_VSYNC_L(a)		(0xff&(a))

#define SET_TG_VSYNC_H(a)		(0x7&((a)>>8))

#define SET_TG_VSYNC2_L(a)		(0xff&(a))

#define SET_TG_VSYNC2_H(a)		(0x7&((a)>>8))

#define SET_TG_VACT_ST_L(a)		(0xff&(a))

#define SET_TG_VACT_ST_H(a)		(0x7&((a)>>8))

#define SET_TG_VACT_SZ_L(a)		(0xff&(a))

#define SET_TG_VACT_SZ_H(a)		(0x7&((a)>>8))

#define SET_TG_FIELD_CHG_L(a)		(0xff&(a))

#define SET_TG_FIELD_CHG_H(a)		(0x7&((a)>>8))

#define SET_TG_VACT_ST2_L(a)		(0xff&(a))

#define SET_TG_VACT_ST2_H(a)		(0x7&((a)>>8))

#define SET_TG_VSYNC_TOP_HDMI_L(a)	(0xff&(a))

#define SET_TG_VSYNC_TOP_HDMI_H(a)	(0x7&((a)>>8))

#define SET_TG_VSYNC_BOT_HDMI_L(a)	(0xff&(a))

#define SET_TG_VSYNC_BOT_HDMI_H(a)	(0x7&((a)>>8))

#define SET_TG_FIELD_TOP_HDMI_L(a)	(0xff&(a))

#define SET_TG_FIELD_TOP_HDMI_H(a)	(0x7&((a)>>8))

#define SET_TG_FIELD_BOT_HDMI_L(a)	(0xff&(a))

#define SET_TG_FIELD_BOT_HDMI_H(a)	(0x7&((a)>>8))


#define IRQ_WRONG_SIGNAL_ENABLE			(1<<0)
#define IRQ_CH_STATUS_RECOVERED_ENABLE		(1<<1)
#define IRQ_WRONG_PREAMBLE_ENABLE		(1<<2)
#define IRQ_STREAM_HEADER_NOT_DETECTED_ENABLE	(1<<3)
#define IRQ_STREAM_HEADER_DETECTED_ENABLE	(1<<4)
#define IRQ_STREAM_HEADER_NOT_DETECTED_AT_RIGHTTIME_ENABLE	(1<<5)
#define IRQ_ABNORMAL_PD_ENABLE					(1<<6)
#define IRQ_BUFFER_OVERFLOW_ENABLE				(1<<7)

#define CONFIG_FILTER_3_SAMPLE			(0<<6)
#define CONFIG_FILTER_2_SAMPLE			(1<<6)
#define CONFIG_LINEAR_PCM_TYPE			(0<<5)
#define CONFIG_NON_LINEAR_PCM_TYPE		(1<<5)
#define CONFIG_PCPD_AUTO_SET			(0<<4)
#define CONFIG_PCPD_MANUAL_SET			(1<<4)
#define CONFIG_WORD_LENGTH_AUTO_SET		(0<<3)
#define CONFIG_WORD_LENGTH_MANUAL_SET		(1<<3)
#define CONFIG_U_V_C_P_NEGLECT			(0<<2)
#define CONFIG_U_V_C_P_REPORT			(1<<2)
#define CONFIG_BURST_SIZE_1			(0<<1)
#define CONFIG_BURST_SIZE_2			(1<<1)
#define CONFIG_DATA_ALIGN_16BIT			(0<<0)
#define CONFIG_DATA_ALIGN_32BIT			(1<<0)


#define AUTHEN_ACK_POS				7
#define AUD_FIFO_OVF_POS			6

#define UPDATE_RI_INT_POS			4
#define UPDATE_PJ_INT_POS			3
#define EXCHANGEKSV_INT_POS			2
#define WATCHDOG_INT_POS			1
#define WTFORACTIVERX_INT_POS			0

#define AUTHENTICATED				(0x1<<7)
#define NOT_YET_AUTHENTICATED			(0x0<<7)
#define AUD_FIFO_OVF_INT_OCCURRED		(0x1<<6)
#define AUD_FIFO_OVF_INT_NOT_OCCURRED		(0x0<<6)

#define UPDATE_RI_INT_OCCURRED			(0x1<<4)
#define UPDATE_RI_INT_NOT_OCCURRED		(0x0<<4)
#define UPDATE_PJ_INT_OCCURRED			(0x1<<3)
#define UPDATE_PJ_INT_NOT_OCCURRED		(0x0<<3)
#define EXCHANGEKSV_INT_OCCURRED		(0x1<<2)
#define EXCHANGEKSV_INT_NOT_OCCURRED		(0x0<<2)
#define WATCHDOG_INT_OCCURRED			(0x1<<1)
#define WATCHDOG_INT_NOT_OCCURRED		(0x0<<1)
#define WTFORACTIVERX_INT_OCCURRED		(0x1<<0)
#define WTFORACTIVERX_INT_NOT_OCCURRED		(0x0<<0)

#define AUD_FIFO_OVF_INT_EN			(0x1<<6)
#define AUD_FIFO_OVF_INT_DIS			(0x0<<6)



#define EN_PJ_EN				(0x1<<4)
#define EN_PJ_DIS				(~EN_PJ_EN)

#define SET_REPEATER_TIMEOUT			(0x1<<2)
#define CLEAR_REPEATER_TIMEOUT			(~SET_REPEATER_TIMEOUT)
#define CP_DESIRED_EN				(0x1<<1)
#define CP_DESIRED_DIS				(~CP_DESIRED_EN)
#define ENABLE_1_DOT_1_FEATURE_EN		(0x1<<0)
#define ENABLE_1_DOT_1_FEATURE_DIS		(~ENABLE_1_DOT_1_FEATURE_EN)

#define Pi_MATCH_RESULT__YES			((0x1<<3)<<(0x1<<2))
#define Pi_MATCH_RESULT__NO			((0x1<<3)<<(0x0<<2))
#define Ri_MATCH_RESULT__YES			((0x1<<1)<<(0x1<<0))
#define Ri_MATCH_RESULT__NO			((0x1<<1)<<(0x0<<0))
#define CLEAR_ALL_RESULTS			0x0

#define HDCP_ENC_DIS				(0x0<<0)

#define REPEATER_SET				(0x1<<6)
#define REPEATERP_CLEAR				(0x1<<6)
#define READY_SET				(0x1<<5)
#define READY_CLEAR				(0x1<<5)
#define FAST_SET				(0x1<<4)
#define FAST_CLEAR				(0x1<<4)

#define ONE_DOT_ONE_FEATURES_SET		(0x1<<1)
#define ONE_DOT_ONE_FEATURES_CLEAR		(0x1<<1)
#define FAST_REAUTHENTICATION_SET		(0x1<<0)
#define FAST_REAUTHENTICATION_CLEAR		(0x1<<0)


#define SCRAMBLER_KEY_START_EN			(0x1<<7)
#define SCRAMBLER_KEY_START_DIS			(~SCRAMBLER_KEY_START_EN)
#define SCRAMBLER_KEY_DONE			(0x1<<6)
#define SCRAMBLER_KEY_GENERATING		(0x0<<6)
#define HAES_START_EN				(0x1<<0)
#define HAES_DECRYPTION_DONE			(0x0<<0)


#define AN_SIZE					8
#define AKSV_SIZE				5
#define BKSV_SIZE				5
#define HDCPLink_Addr				0x74


#define CABLE_PLUGGED				(1<<1)
#define CABLE_UNPLUGGED				(0<<1)

#define DDC_Addr				0xA0
#define eDDC_Addr				0x60
#define HDCPLink_Addr				0x74

#define HDCP_Bksv				0x00
#define HDCP_Aksv				0x10
#define HDCP_Ainfo				0x15
#define HDCP_An					0x18
#define HDCP_Ri					0x08
#define HDCP_Bcaps				0x40
#define HDCP_BStatus				0x41
#define HDCP_Pj					0x0a

#define HDCP_KSVFIFO				0x43
#define HDCP_SHA1				0x20

#define HDMI_MODE_HDMI				0
#define HDMI_MODE_DVI				1

#define EDID_SEGMENT_ID				0x60
#define EDID_SEGMENT0				0x00
#define EDID_SEGMENT1				0x01

#define EDID_DEVICE_ID				0xA0
#define EDID_ADDR_START				0x00
#define EDID_ADDR_EXT				0x80
#define EDID_RCOUNT				127

#define EDID_POS_EXTENSION			0x7E
#define EDID_POS_CHECKSUM			0x7F
#define VALID_EDID				0xA5
#define NO_VALID_EDID				0

#define EDID_POS_RBUFFER0			0x00
#define EDID_POS_RBUFFER1			0x80
#define EDID_POS_RBUFFER2			0x100
#define EDID_POS_RBUFFER3			0x180

#define EDID_TIMING_EXT_TAG_ADDR_POS		0x80
#define EDID_TIMING_EXT_REV_NUMBER		0x81
#define EDID_DETAILED_TIMING_OFFSET_POS		0x82
#define EDID_COLOR_SPACE_ADDR			0x83
#define EDID_DATA_BLOCK_ADDRESS			0x84
#define EDID_TIMING_EXT_TAG_VAL			0x02
#define EDID_YCBCR444_CS_MASK			0x20
#define EDID_YCBCR422_CS_MASK			0x10
#define EDID_TAG_CODE_MASK			0xE0
#define EDID_DATA_BLOCK_SIZE_MASK		0x1F
#define EDID_NATIVE_RESOLUTION_MASK		0x80

#define EDID_SHORT_AUD_DEC_TAG			0x20
#define EDID_SHORT_VID_DEC_TAG			0x40
#define EDID_HDMI_VSDB_TAG			0x60
#define EDID_SPEAKER_ALLOCATION_TAG		0x80

#define COLOR_SPACE_RGB				0
#define COLOR_SPACE_YCBCR444			1
#define COLOR_SPACE_YCBCR422			2

#define SHORT_VID_720_480P_4_3_NT		0x01
#define SHORT_VID_720_480P_16_9_NT		0x02
#define SHORT_VID_1280_720P_16_9_NT		0x04
#define SHORT_VID_1920_1080i_16_9_NT		0x08
#define SHORT_VID_720_576P_4_3_PAL		0x10
#define SHORT_VID_720_576P_16_9_PAL		0x20
#define SHORT_VID_1280_720P_16_9_PAL		0x40
#define SHORT_VID_1920_1080i_16_9_PAL		0x80

#define SET_HDMI_RESOLUTION_480P		0x00
#define SET_HDMI_RESOLUTION_720P		0x01
#define SET_HDMI_RESOLUTION_1080i		0x02


#define HDMI_WAIT_TIMEOUT			20
#define AUTHENTICATION_SUCCESS			0
#define AUTHENTICATION_FAILURE			1
#define AUTHENTICATION_FAIL_CNT			2


#define HDCP_MAX_DEVS				128
#define HDCP_KSV_SIZE				5

#define CMD_IIC_ADDRMODE_CHANGE			0xFF

#define IIC_ADDRMODE_1				0
#define IIC_ADDRMODE_2				1
#define IIC_ADDRMODE_3				2
#define HDMI_IIC_ADDRMODE			IIC_ADDRMODE_1

#define IIC_ACK					0
#define IIC_NOACK				1

#define EDID_POS_ERROR				512
#define R_VAL_RETRY_CNT				5

#define CABLE_INSERT				1
#define CABLE_REMOVE				(~CABLE_INSERT)

#endif


