/* drivers/media/video/s5k4ecgx_regs_1_1.h
 *
 * Driver for s5k4ecgx (5MP Camera) from SEC(LSI), firmware EVT1.1
 *
 * Copyright (C) 2010, SAMSUNG ELECTRONICS
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */


#ifndef __S5K4ECGX_REGS_1_1_H__
#define __S5K4ECGX_REGS_1_1_H__

/* ARM Initiation */
static const u32 s5k4ecgx_init_reg1[] = {
	0xFCFCD000,
	0x00100001,
	0x10300000,
	0x00140001,
};

static const u32 s5k4ecgx_init_reg2[] = {
	/* Drive current setting */
	0x0028D000,
	0x002A1082,
	0x0F120155,	/*d0_d4_cd10, d0_d4_cd10 9:0*/
	0x0F120155,	/*d5_d9_cd10, d5_d9_cd10 9:0*/
	0x0F120055,	/*gpio_cd10, gpio_cd10*/
	0x0F120555,	/*clks_output_cd10, clks_output_cd10 11:0*/
	0x002A100E,
	0x0F120000,	/*pclk_delay_r*/

	0x002A007A,
	0x0F120000,

	/* ISP FE(ADLC) */
	0x002AE406,
	0x0F120092,
	0x002AE410,
	0x0F123804,
	0x002AE41A,
	0x0F120010,	/*101022 ADD adlcptune_total */
	0x002AE420,
	0x0F120003,
	0x0F120060,
	0x002AE42E,
	0x0F120004,
	0x002AF400,
	0x0F125A3C,
	0x0F120023,
	0x0F128080,
	0x0F1203AF,
	0x0F12000A,
	0x0F12AA54,
	0x0F120040,
	0x0F12464E,
	0x0F120240,
	0x0F120240,
	0x0F120040,
	0x0F121000,
	0x0F12555C,
	0x0F12D000,
	0x0F120010,
	0x0F120202,
	0x0F120401,
	0x0F120022,
	0x0F120088,
	0x0F12009F,
	0x0F120000,
	0x0F121800,
	0x0F120088,
	0x0F120000,
	0x0F122428,
	0x0F120000,
	0x0F1203EE,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x002AF552,
	0x0F120708,
	0x0F12080C,

	/* For subsampling Size */
	0x00287000,
	0x002A18BC,
	0x0F120004,
	0x0F1205B6,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F120007,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F12024E,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F1205B6,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F12024F,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120075,
	0x0F1200CF,
	0x0F120000,
	0x0F120000,
	0x0F120075,
	0x0F1200D6,
	0x0F120000,
	0x0F120000,
	0x0F120004,
	0x0F1201F4,
	0x0F120000,
	0x0F120000,
	0x0F1200F0,
	0x0F1201F4,
	0x0F12029E,
	0x0F1205B2,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1201F8,
	0x0F120228,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120208,
	0x0F120238,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120218,
	0x0F120238,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F120009,
	0x0F1200DE,
	0x0F1205C0,
	0x0F120000,
	0x0F120000,
	0x0F1200DF,
	0x0F1200E4,
	0x0F1201F8,
	0x0F1201FD,
	0x0F1205B6,
	0x0F1205BB,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1201F8,
	0x0F120000,
	0x0F120000,
	0x0F120077,
	0x0F12007E,
	0x0F12024F,
	0x0F12025E,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	/* For Capture */
	0x0F120004,
	0x0F1209D1,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F1209D5,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F1209D5,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F120326,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F1209D1,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F1209D5,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F120327,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F120084,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F12008D,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F1202AA,
	0x0F120000,
	0x0F120000,
	0x0F1200AA,
	0x0F1202AA,
	0x0F1203AD,
	0x0F1209CD,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202AE,
	0x0F1202DE,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202BE,
	0x0F1202EE,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202CE,
	0x0F1202EE,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F120009,
	0x0F120095,
	0x0F1209DB,
	0x0F120000,
	0x0F120000,
	0x0F120096,
	0x0F12009B,
	0x0F1202AE,
	0x0F1202B3,
	0x0F1209D1,
	0x0F1209D6,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202AE,
	0x0F120000,
	0x0F120000,
	0x0F120009,
	0x0F120010,
	0x0F120327,
	0x0F120336,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A1AF8,
	0x0F125A3C,	/*#senHal_TuneStr_AngTuneData1_2_D000F400
			  register at subsampling*/

	0x002A1896,
	0x0F120002,	/*#senHal_SamplingType	0002 03EE: PLA setting*/
	0x0F120000,	/*#senHal_SamplingMode 0 : 2 PLA / 1 : 4PLA*/
	0x0F120003,	/*#senHal_PLAOption
			  [0] VPLA enable , [1] HPLA enable*/

	0x002A189E,
	0x0F120FB0,	/*#senHal_ExpMinPixels*/

	0x002A18AC,
	0x0F120060,	/*#senHal_uAddColsBin*/
	0x0F120060,	/*#senHal_uAddColsNoBin*/
	0x0F1205C0,	/*#senHal_uMinColsBin*/
	0x0F1205C0,	/*#senHal_uMinColsNoBin*/

	0x002A1AEA,
	0x0F128080,	/*#senHal_SubF404Tune*/
	0x0F120080,	/*#senHal_FullF404Tune*/
	0x002A1AE0,
	0x0F120000,	/*#senHal_bSenAAC*/

	0x002A1A72,
	0x0F120000,	/*#senHal_bSRX	SRX off*/
	0x002A18A2,
	0x0F120004,	/*#senHal_NExpLinesCheckFine,
			  extend Forbidden area line*/
	0x002A1A6A,
	0x0F12009A,	/*#senHal_usForbiddenRightOfs,
			  extend right Forbidden area line*/
	0x002A385E,
	0x0F12024C,	/*#Mon_Sen_uExpPixelsOfs*/

	0x002A0EE6,
	0x0F120000,	/*#setot_bUseDigitalHbin*/
	0x002A1B2A,
	0x0F120300,	/*#senHal_TuneStr2_usAngTuneGainTh  2   70001B2A*/
	0x0F1200D6,	/*#senHal_TuneStr2_AngTuneF4CA_0_   2   70001B2C*/
	0x0F12008D,	/*#senHal_TuneStr2_AngTuneF4CA_1_   2   70001B2E*/
	0x0F1200CF,	/*#senHal_TuneStr2_AngTuneF4C2_0_   2   70001B30*/
	0x0F120084,	/*#senHal_TuneStr2_AngTuneF4C2_1_   2   70001B32*/

	/* OTP setting */

	0x002A0722,
	0x0F120100,	/*#skl_OTP_usWaitTime,
			  This register should be positioned in
			  front of D0001000*/
	0x002A0726,
	0x0F120001,	/*#skl_bUseOTPfunc, This is OTP on/off function*/
	0x002A08D6,
	0x0F120001,	/*#ash_bUseOTPData*/
	0x002A146E,
	0x0F120000,	/*#awbb_otp_disable*/
	0x002A08DC,
	0x0F120001,	/*#ash_bUseGasAlphaOTP*/

	/* TnP setting */
	/* Start of Patch data */
	0x002A3AF8,    /* TnP */
	0x0F12B570,    /* 70003AF8 */
	0x0F124B33,    /* 70003AFA */
	0x0F12216F,    /* 70003AFC */
	0x0F124833,    /* 70003AFE */
	0x0F128C80,    /* 70003B00 */
	0x0F122200,    /* 70003B02 */
	0x0F12C008,    /* 70003B04 */
	0x0F126001,    /* 70003B06 */
	0x0F124931,    /* 70003B08 */
	0x0F124832,    /* 70003B0A */
	0x0F122401,    /* 70003B0C */
	0x0F12F000,    /* 70003B0E */
	0x0F12FB1F,    /* 70003B10 */
	0x0F124931,    /* 70003B12 */
	0x0F124831,    /* 70003B14 */
	0x0F122502,    /* 70003B16 */
	0x0F120022,    /* 70003B18 */
	0x0F12F000,    /* 70003B1A */
	0x0F12FB19,    /* 70003B1C */
	0x0F124830,    /* 70003B1E */
	0x0F120261,    /* 70003B20 */
	0x0F128001,    /* 70003B22 */
	0x0F122100,    /* 70003B24 */
	0x0F128041,    /* 70003B26 */
	0x0F12492E,    /* 70003B28 */
	0x0F12482F,    /* 70003B2A */
	0x0F126041,    /* 70003B2C */
	0x0F12492F,    /* 70003B2E */
	0x0F12482F,    /* 70003B30 */
	0x0F12002A,    /* 70003B32 */
	0x0F122403,    /* 70003B34 */
	0x0F12F000,    /* 70003B36 */
	0x0F12FB0B,    /* 70003B38 */
	0x0F12482B,    /* 70003B3A */
	0x0F12492D,    /* 70003B3C */
	0x0F1230C0,    /* 70003B3E */
	0x0F1263C1,    /* 70003B40 */
	0x0F124929,    /* 70003B42 */
	0x0F12482C,    /* 70003B44 */
	0x0F123980,    /* 70003B46 */
	0x0F126408,    /* 70003B48 */
	0x0F12482C,    /* 70003B4A */
	0x0F12492C,    /* 70003B4C */
	0x0F126388,    /* 70003B4E */
	0x0F12492C,    /* 70003B50 */
	0x0F12482D,    /* 70003B52 */
	0x0F122504,    /* 70003B54 */
	0x0F120022,    /* 70003B56 */
	0x0F12F000,    /* 70003B58 */
	0x0F12FAFA,    /* 70003B5A */
	0x0F12492B,    /* 70003B5C */
	0x0F12482C,    /* 70003B5E */
	0x0F122405,    /* 70003B60 */
	0x0F12002A,    /* 70003B62 */
	0x0F12F000,    /* 70003B64 */
	0x0F12F86C,    /* 70003B66 */
	0x0F124829,    /* 70003B68 */
	0x0F12492A,    /* 70003B6A */
	0x0F120022,    /* 70003B6C */
	0x0F122506,    /* 70003B6E */
	0x0F121D80,    /* 70003B70 */
	0x0F12F000,    /* 70003B72 */
	0x0F12F865,    /* 70003B74 */
	0x0F124826,    /* 70003B76 */
	0x0F124927,    /* 70003B78 */
	0x0F122407,    /* 70003B7A */
	0x0F12002A,    /* 70003B7C */
	0x0F12300C,    /* 70003B7E */
	0x0F12F000,    /* 70003B80 */
	0x0F12F85E,    /* 70003B82 */
	0x0F124822,    /* 70003B84 */
	0x0F124925,    /* 70003B86 */
	0x0F120022,    /* 70003B88 */
	0x0F122508,    /* 70003B8A */
	0x0F123010,    /* 70003B8C */
	0x0F12F000,    /* 70003B8E */
	0x0F12F857,    /* 70003B90 */
	0x0F124923,    /* 70003B92 */
	0x0F124823,    /* 70003B94 */
	0x0F122409,    /* 70003B96 */
	0x0F12002A,    /* 70003B98 */
	0x0F12F000,    /* 70003B9A */
	0x0F12FAD9,    /* 70003B9C */
	0x0F124922,    /* 70003B9E */
	0x0F124822,    /* 70003BA0 */
	0x0F120022,    /* 70003BA2 */
	0x0F12250A,    /* 70003BA4 */
	0x0F12F000,    /* 70003BA6 */
	0x0F12FAD3,    /* 70003BA8 */
	0x0F124921,    /* 70003BAA */
	0x0F124821,    /* 70003BAC */
	0x0F12240B,    /* 70003BAE */
	0x0F12002A,    /* 70003BB0 */
	0x0F12F000,    /* 70003BB2 */
	0x0F12FACD,    /* 70003BB4 */
	0x0F124920,    /* 70003BB6 */
	0x0F124820,    /* 70003BB8 */
	0x0F120022,    /* 70003BBA */
	0x0F12F000,    /* 70003BBC */
	0x0F12FAC8,    /* 70003BBE */
	0x0F12BC70,    /* 70003BC0 */
	0x0F12BC08,    /* 70003BC2 */
	0x0F124718,    /* 70003BC4 */
	0x0F120000,    /* 70003BC6 */
	0x0F12017B,    /* 70003BC8 */
	0x0F124EC2,    /* 70003BCA */
	0x0F121F6C,    /* 70003BCC */
	0x0F127000,    /* 70003BCE */
	0x0F123C59,    /* 70003BD0 */
	0x0F127000,    /* 70003BD2 */
	0x0F12E38B,    /* 70003BD4 */
	0x0F120000,    /* 70003BD6 */
	0x0F123C91,    /* 70003BD8 */
	0x0F127000,    /* 70003BDA */
	0x0F12C3B1,    /* 70003BDC */
	0x0F120000,    /* 70003BDE */
	0x0F124780,    /* 70003BE0 */
	0x0F127000,    /* 70003BE2 */
	0x0F123CEF,    /* 70003BE4 */
	0x0F127000,    /* 70003BE6 */
	0x0F120080,    /* 70003BE8 */
	0x0F127000,    /* 70003BEA */
	0x0F123D2B,    /* 70003BEC */
	0x0F127000,    /* 70003BEE */
	0x0F12B49D,    /* 70003BF0 */
	0x0F120000,    /* 70003BF2 */
	0x0F123DD7,    /* 70003BF4 */
	0x0F127000,    /* 70003BF6 */
	0x0F123D8B,    /* 70003BF8 */
	0x0F127000,    /* 70003BFA */
	0x0F12FFFF,    /* 70003BFC */
	0x0F1200FF,    /* 70003BFE */
	0x0F1217E0,    /* 70003C00 */
	0x0F127000,    /* 70003C02 */
	0x0F123F53,    /* 70003C04 */
	0x0F127000,    /* 70003C06 */
	0x0F12053D,    /* 70003C08 */
	0x0F120000,    /* 70003C0A */
	0x0F120000,    /* 70003C0C */
	0x0F120A89,    /* 70003C0E */
	0x0F126CD2,    /* 70003C10 */
	0x0F120000,    /* 70003C12 */
	0x0F1202C9,    /* 70003C14 */
	0x0F120000,    /* 70003C16 */
	0x0F120000,    /* 70003C18 */
	0x0F120A9A,    /* 70003C1A */
	0x0F120000,    /* 70003C1C */
	0x0F1202D2,    /* 70003C1E */
	0x0F123FA1,    /* 70003C20 */
	0x0F127000,    /* 70003C22 */
	0x0F129E65,    /* 70003C24 */
	0x0F120000,    /* 70003C26 */
	0x0F124015,    /* 70003C28 */
	0x0F127000,    /* 70003C2A */
	0x0F127C49,    /* 70003C2C */
	0x0F120000,    /* 70003C2E */
	0x0F124089,    /* 70003C30 */
	0x0F127000,    /* 70003C32 */
	0x0F127C63,    /* 70003C34 */
	0x0F120000,    /* 70003C36 */
	0x0F1240A5,    /* 70003C38 */
	0x0F127000,    /* 70003C3A */
	0x0F128F01,    /* 70003C3C */
	0x0F120000,    /* 70003C3E */
	0x0F12B570,    /* 70003C40 */
	0x0F12000C,    /* 70003C42 */
	0x0F120015,    /* 70003C44 */
	0x0F120029,    /* 70003C46 */
	0x0F12F000,    /* 70003C48 */
	0x0F12FA8A,    /* 70003C4A */
	0x0F1249F8,    /* 70003C4C */
	0x0F1200A8,    /* 70003C4E */
	0x0F12500C,    /* 70003C50 */
	0x0F12BC70,    /* 70003C52 */
	0x0F12BC08,    /* 70003C54 */
	0x0F124718,    /* 70003C56 */
	0x0F126808,    /* 70003C58 */
	0x0F120400,    /* 70003C5A */
	0x0F120C00,    /* 70003C5C */
	0x0F126849,    /* 70003C5E */
	0x0F120409,    /* 70003C60 */
	0x0F120C09,    /* 70003C62 */
	0x0F124AF3,    /* 70003C64 */
	0x0F128992,    /* 70003C66 */
	0x0F122A00,    /* 70003C68 */
	0x0F12D00D,    /* 70003C6A */
	0x0F122300,    /* 70003C6C */
	0x0F121A89,    /* 70003C6E */
	0x0F12D400,    /* 70003C70 */
	0x0F12000B,    /* 70003C72 */
	0x0F120419,    /* 70003C74 */
	0x0F120C09,    /* 70003C76 */
	0x0F1223FF,    /* 70003C78 */
	0x0F1233C1,    /* 70003C7A */
	0x0F121810,    /* 70003C7C */
	0x0F124298,    /* 70003C7E */
	0x0F12D800,    /* 70003C80 */
	0x0F120003,    /* 70003C82 */
	0x0F120418,    /* 70003C84 */
	0x0F120C00,    /* 70003C86 */
	0x0F124AEB,    /* 70003C88 */
	0x0F128150,    /* 70003C8A */
	0x0F128191,    /* 70003C8C */
	0x0F124770,    /* 70003C8E */
	0x0F12B5F3,    /* 70003C90 */
	0x0F120004,    /* 70003C92 */
	0x0F12B081,    /* 70003C94 */
	0x0F129802,    /* 70003C96 */
	0x0F126800,    /* 70003C98 */
	0x0F120600,    /* 70003C9A */
	0x0F120E00,    /* 70003C9C */
	0x0F122201,    /* 70003C9E */
	0x0F120015,    /* 70003CA0 */
	0x0F120021,    /* 70003CA2 */
	0x0F123910,    /* 70003CA4 */
	0x0F12408A,    /* 70003CA6 */
	0x0F1240A5,    /* 70003CA8 */
	0x0F124FE4,    /* 70003CAA */
	0x0F120016,    /* 70003CAC */
	0x0F122C10,    /* 70003CAE */
	0x0F12DA03,    /* 70003CB0 */
	0x0F128839,    /* 70003CB2 */
	0x0F1243A9,    /* 70003CB4 */
	0x0F128039,    /* 70003CB6 */
	0x0F12E002,    /* 70003CB8 */
	0x0F128879,    /* 70003CBA */
	0x0F1243B1,    /* 70003CBC */
	0x0F128079,    /* 70003CBE */
	0x0F12F000,    /* 70003CC0 */
	0x0F12FA56,    /* 70003CC2 */
	0x0F122C10,    /* 70003CC4 */
	0x0F12DA03,    /* 70003CC6 */
	0x0F128839,    /* 70003CC8 */
	0x0F124329,    /* 70003CCA */
	0x0F128039,    /* 70003CCC */
	0x0F12E002,    /* 70003CCE */
	0x0F128879,    /* 70003CD0 */
	0x0F124331,    /* 70003CD2 */
	0x0F128079,    /* 70003CD4 */
	0x0F1249DA,    /* 70003CD6 */
	0x0F128809,    /* 70003CD8 */
	0x0F122900,    /* 70003CDA */
	0x0F12D102,    /* 70003CDC */
	0x0F12F000,    /* 70003CDE */
	0x0F12FA4F,    /* 70003CE0 */
	0x0F122000,    /* 70003CE2 */
	0x0F129902,    /* 70003CE4 */
	0x0F126008,    /* 70003CE6 */
	0x0F12BCFE,    /* 70003CE8 */
	0x0F12BC08,    /* 70003CEA */
	0x0F124718,    /* 70003CEC */
	0x0F12B538,    /* 70003CEE */
	0x0F129C04,    /* 70003CF0 */
	0x0F120015,    /* 70003CF2 */
	0x0F12002A,    /* 70003CF4 */
	0x0F129400,    /* 70003CF6 */
	0x0F12F000,    /* 70003CF8 */
	0x0F12FA4A,    /* 70003CFA */
	0x0F124AD1,    /* 70003CFC */
	0x0F128811,    /* 70003CFE */
	0x0F122900,    /* 70003D00 */
	0x0F12D00F,    /* 70003D02 */
	0x0F128820,    /* 70003D04 */
	0x0F124281,    /* 70003D06 */
	0x0F12D20C,    /* 70003D08 */
	0x0F128861,    /* 70003D0A */
	0x0F128853,    /* 70003D0C */
	0x0F124299,    /* 70003D0E */
	0x0F12D200,    /* 70003D10 */
	0x0F121E40,    /* 70003D12 */
	0x0F120400,    /* 70003D14 */
	0x0F120C00,    /* 70003D16 */
	0x0F128020,    /* 70003D18 */
	0x0F128851,    /* 70003D1A */
	0x0F128061,    /* 70003D1C */
	0x0F124368,    /* 70003D1E */
	0x0F121840,    /* 70003D20 */
	0x0F126060,    /* 70003D22 */
	0x0F12BC38,    /* 70003D24 */
	0x0F12BC08,    /* 70003D26 */
	0x0F124718,    /* 70003D28 */
	0x0F12B5F8,    /* 70003D2A */
	0x0F120004,    /* 70003D2C */
	0x0F126808,    /* 70003D2E */
	0x0F120400,    /* 70003D30 */
	0x0F120C00,    /* 70003D32 */
	0x0F122201,    /* 70003D34 */
	0x0F120015,    /* 70003D36 */
	0x0F120021,    /* 70003D38 */
	0x0F123910,    /* 70003D3A */
	0x0F12408A,    /* 70003D3C */
	0x0F1240A5,    /* 70003D3E */
	0x0F124FBE,    /* 70003D40 */
	0x0F120016,    /* 70003D42 */
	0x0F122C10,    /* 70003D44 */
	0x0F12DA03,    /* 70003D46 */
	0x0F128839,    /* 70003D48 */
	0x0F1243A9,    /* 70003D4A */
	0x0F128039,    /* 70003D4C */
	0x0F12E002,    /* 70003D4E */
	0x0F128879,    /* 70003D50 */
	0x0F1243B1,    /* 70003D52 */
	0x0F128079,    /* 70003D54 */
	0x0F12F000,    /* 70003D56 */
	0x0F12FA23,    /* 70003D58 */
	0x0F122C10,    /* 70003D5A */
	0x0F12DA03,    /* 70003D5C */
	0x0F128838,    /* 70003D5E */
	0x0F124328,    /* 70003D60 */
	0x0F128038,    /* 70003D62 */
	0x0F12E002,    /* 70003D64 */
	0x0F128878,    /* 70003D66 */
	0x0F124330,    /* 70003D68 */
	0x0F128078,    /* 70003D6A */
	0x0F1248B6,    /* 70003D6C */
	0x0F128800,    /* 70003D6E */
	0x0F120400,    /* 70003D70 */
	0x0F12D507,    /* 70003D72 */
	0x0F124BB5,    /* 70003D74 */
	0x0F127819,    /* 70003D76 */
	0x0F124AB5,    /* 70003D78 */
	0x0F127810,    /* 70003D7A */
	0x0F127018,    /* 70003D7C */
	0x0F127011,    /* 70003D7E */
	0x0F1249B4,    /* 70003D80 */
	0x0F128188,    /* 70003D82 */
	0x0F12BCF8,    /* 70003D84 */
	0x0F12BC08,    /* 70003D86 */
	0x0F124718,    /* 70003D88 */
	0x0F12B538,    /* 70003D8A */
	0x0F1248B2,    /* 70003D8C */
	0x0F124669,    /* 70003D8E */
	0x0F12F000,    /* 70003D90 */
	0x0F12FA0E,    /* 70003D92 */
	0x0F1248B1,    /* 70003D94 */
	0x0F1249B0,    /* 70003D96 */
	0x0F1269C2,    /* 70003D98 */
	0x0F122400,    /* 70003D9A */
	0x0F1231A8,    /* 70003D9C */
	0x0F122A00,    /* 70003D9E */
	0x0F12D008,    /* 70003DA0 */
	0x0F1261C4,    /* 70003DA2 */
	0x0F12684A,    /* 70003DA4 */
	0x0F126242,    /* 70003DA6 */
	0x0F126282,    /* 70003DA8 */
	0x0F12466B,    /* 70003DAA */
	0x0F12881A,    /* 70003DAC */
	0x0F126302,    /* 70003DAE */
	0x0F12885A,    /* 70003DB0 */
	0x0F126342,    /* 70003DB2 */
	0x0F126A02,    /* 70003DB4 */
	0x0F122A00,    /* 70003DB6 */
	0x0F12D00A,    /* 70003DB8 */
	0x0F126204,    /* 70003DBA */
	0x0F126849,    /* 70003DBC */
	0x0F126281,    /* 70003DBE */
	0x0F12466B,    /* 70003DC0 */
	0x0F128819,    /* 70003DC2 */
	0x0F126301,    /* 70003DC4 */
	0x0F128859,    /* 70003DC6 */
	0x0F126341,    /* 70003DC8 */
	0x0F1249A5,    /* 70003DCA */
	0x0F1288C9,    /* 70003DCC */
	0x0F1263C1,    /* 70003DCE */
	0x0F12F000,    /* 70003DD0 */
	0x0F12F9F6,    /* 70003DD2 */
	0x0F12E7A6,    /* 70003DD4 */
	0x0F12B5F0,    /* 70003DD6 */
	0x0F12B08B,    /* 70003DD8 */
	0x0F1220FF,    /* 70003DDA */
	0x0F121C40,    /* 70003DDC */
	0x0F1249A1,    /* 70003DDE */
	0x0F1289CC,    /* 70003DE0 */
	0x0F124E9E,    /* 70003DE2 */
	0x0F126AB1,    /* 70003DE4 */
	0x0F124284,    /* 70003DE6 */
	0x0F12D101,    /* 70003DE8 */
	0x0F12489F,    /* 70003DEA */
	0x0F126081,    /* 70003DEC */
	0x0F126A70,    /* 70003DEE */
	0x0F120200,    /* 70003DF0 */
	0x0F12F000,    /* 70003DF2 */
	0x0F12F9ED,    /* 70003DF4 */
	0x0F120400,    /* 70003DF6 */
	0x0F120C00,    /* 70003DF8 */
	0x0F124A96,    /* 70003DFA */
	0x0F128A11,    /* 70003DFC */
	0x0F129109,    /* 70003DFE */
	0x0F122101,    /* 70003E00 */
	0x0F120349,    /* 70003E02 */
	0x0F124288,    /* 70003E04 */
	0x0F12D200,    /* 70003E06 */
	0x0F120001,    /* 70003E08 */
	0x0F124A92,    /* 70003E0A */
	0x0F128211,    /* 70003E0C */
	0x0F124D97,    /* 70003E0E */
	0x0F128829,    /* 70003E10 */
	0x0F129108,    /* 70003E12 */
	0x0F124A8B,    /* 70003E14 */
	0x0F122303,    /* 70003E16 */
	0x0F123222,    /* 70003E18 */
	0x0F121F91,    /* 70003E1A */
	0x0F12F000,    /* 70003E1C */
	0x0F12F9DE,    /* 70003E1E */
	0x0F128028,    /* 70003E20 */
	0x0F12488E,    /* 70003E22 */
	0x0F124987,    /* 70003E24 */
	0x0F126BC2,    /* 70003E26 */
	0x0F126AC0,    /* 70003E28 */
	0x0F124282,    /* 70003E2A */
	0x0F12D201,    /* 70003E2C */
	0x0F128CC8,    /* 70003E2E */
	0x0F128028,    /* 70003E30 */
	0x0F1288E8,    /* 70003E32 */
	0x0F129007,    /* 70003E34 */
	0x0F122240,    /* 70003E36 */
	0x0F124310,    /* 70003E38 */
	0x0F1280E8,    /* 70003E3A */
	0x0F122000,    /* 70003E3C */
	0x0F120041,    /* 70003E3E */
	0x0F12194B,    /* 70003E40 */
	0x0F12001E,    /* 70003E42 */
	0x0F123680,    /* 70003E44 */
	0x0F128BB2,    /* 70003E46 */
	0x0F12AF04,    /* 70003E48 */
	0x0F12527A,    /* 70003E4A */
	0x0F124A7D,    /* 70003E4C */
	0x0F12188A,    /* 70003E4E */
	0x0F128897,    /* 70003E50 */
	0x0F1283B7,    /* 70003E52 */
	0x0F1233A0,    /* 70003E54 */
	0x0F12891F,    /* 70003E56 */
	0x0F12AE01,    /* 70003E58 */
	0x0F125277,    /* 70003E5A */
	0x0F128A11,    /* 70003E5C */
	0x0F128119,    /* 70003E5E */
	0x0F121C40,    /* 70003E60 */
	0x0F120400,    /* 70003E62 */
	0x0F120C00,    /* 70003E64 */
	0x0F122806,    /* 70003E66 */
	0x0F12D3E9,    /* 70003E68 */
	0x0F12F000,    /* 70003E6A */
	0x0F12F9BF,    /* 70003E6C */
	0x0F12F000,    /* 70003E6E */
	0x0F12F9C5,    /* 70003E70 */
	0x0F124F79,    /* 70003E72 */
	0x0F1237A8,    /* 70003E74 */
	0x0F122800,    /* 70003E76 */
	0x0F12D10A,    /* 70003E78 */
	0x0F121FE0,    /* 70003E7A */
	0x0F1238FD,    /* 70003E7C */
	0x0F12D001,    /* 70003E7E */
	0x0F121CC0,    /* 70003E80 */
	0x0F12D105,    /* 70003E82 */
	0x0F124874,    /* 70003E84 */
	0x0F128829,    /* 70003E86 */
	0x0F123818,    /* 70003E88 */
	0x0F126840,    /* 70003E8A */
	0x0F124348,    /* 70003E8C */
	0x0F126078,    /* 70003E8E */
	0x0F124972,    /* 70003E90 */
	0x0F126878,    /* 70003E92 */
	0x0F126B89,    /* 70003E94 */
	0x0F124288,    /* 70003E96 */
	0x0F12D300,    /* 70003E98 */
	0x0F120008,    /* 70003E9A */
	0x0F126078,    /* 70003E9C */
	0x0F122000,    /* 70003E9E */
	0x0F120041,    /* 70003EA0 */
	0x0F12AA04,    /* 70003EA2 */
	0x0F125A53,    /* 70003EA4 */
	0x0F12194A,    /* 70003EA6 */
	0x0F12269C,    /* 70003EA8 */
	0x0F1252B3,    /* 70003EAA */
	0x0F12AB01,    /* 70003EAC */
	0x0F125A59,    /* 70003EAE */
	0x0F1232A0,    /* 70003EB0 */
	0x0F128111,    /* 70003EB2 */
	0x0F121C40,    /* 70003EB4 */
	0x0F120400,    /* 70003EB6 */
	0x0F120C00,    /* 70003EB8 */
	0x0F122806,    /* 70003EBA */
	0x0F12D3F0,    /* 70003EBC */
	0x0F124965,    /* 70003EBE */
	0x0F129809,    /* 70003EC0 */
	0x0F128208,    /* 70003EC2 */
	0x0F129808,    /* 70003EC4 */
	0x0F128028,    /* 70003EC6 */
	0x0F129807,    /* 70003EC8 */
	0x0F1280E8,    /* 70003ECA */
	0x0F121FE0,    /* 70003ECC */
	0x0F1238FD,    /* 70003ECE */
	0x0F12D13B,    /* 70003ED0 */
	0x0F124D64,    /* 70003ED2 */
	0x0F1289E8,    /* 70003ED4 */
	0x0F121FC1,    /* 70003ED6 */
	0x0F1239FF,    /* 70003ED8 */
	0x0F12D136,    /* 70003EDA */
	0x0F124C5F,    /* 70003EDC */
	0x0F128AE0,    /* 70003EDE */
	0x0F12F000,    /* 70003EE0 */
	0x0F12F994,    /* 70003EE2 */
	0x0F120006,    /* 70003EE4 */
	0x0F128B20,    /* 70003EE6 */
	0x0F12F000,    /* 70003EE8 */
	0x0F12F998,    /* 70003EEA */
	0x0F129000,    /* 70003EEC */
	0x0F126AA1,    /* 70003EEE */
	0x0F126878,    /* 70003EF0 */
	0x0F121809,    /* 70003EF2 */
	0x0F120200,    /* 70003EF4 */
	0x0F12F000,    /* 70003EF6 */
	0x0F12F96B,    /* 70003EF8 */
	0x0F120400,    /* 70003EFA */
	0x0F120C00,    /* 70003EFC */
	0x0F120022,    /* 70003EFE */
	0x0F123246,    /* 70003F00 */
	0x0F120011,    /* 70003F02 */
	0x0F12310A,    /* 70003F04 */
	0x0F122305,    /* 70003F06 */
	0x0F12F000,    /* 70003F08 */
	0x0F12F968,    /* 70003F0A */
	0x0F1266E8,    /* 70003F0C */
	0x0F126B23,    /* 70003F0E */
	0x0F120002,    /* 70003F10 */
	0x0F120031,    /* 70003F12 */
	0x0F120018,    /* 70003F14 */
	0x0F12F000,    /* 70003F16 */
	0x0F12F989,    /* 70003F18 */
	0x0F12466B,    /* 70003F1A */
	0x0F128518,    /* 70003F1C */
	0x0F126EEA,    /* 70003F1E */
	0x0F126B60,    /* 70003F20 */
	0x0F129900,    /* 70003F22 */
	0x0F12F000,    /* 70003F24 */
	0x0F12F982,    /* 70003F26 */
	0x0F12466B,    /* 70003F28 */
	0x0F128558,    /* 70003F2A */
	0x0F120029,    /* 70003F2C */
	0x0F12980A,    /* 70003F2E */
	0x0F123170,    /* 70003F30 */
	0x0F12F000,    /* 70003F32 */
	0x0F12F983,    /* 70003F34 */
	0x0F120028,    /* 70003F36 */
	0x0F123060,    /* 70003F38 */
	0x0F128A02,    /* 70003F3A */
	0x0F124946,    /* 70003F3C */
	0x0F123128,    /* 70003F3E */
	0x0F12808A,    /* 70003F40 */
	0x0F128A42,    /* 70003F42 */
	0x0F1280CA,    /* 70003F44 */
	0x0F128A80,    /* 70003F46 */
	0x0F128108,    /* 70003F48 */
	0x0F12B00B,    /* 70003F4A */
	0x0F12BCF0,    /* 70003F4C */
	0x0F12BC08,    /* 70003F4E */
	0x0F124718,    /* 70003F50 */
	0x0F12B570,    /* 70003F52 */
	0x0F122400,    /* 70003F54 */
	0x0F124D46,    /* 70003F56 */
	0x0F124846,    /* 70003F58 */
	0x0F128881,    /* 70003F5A */
	0x0F124846,    /* 70003F5C */
	0x0F128041,    /* 70003F5E */
	0x0F122101,    /* 70003F60 */
	0x0F128001,    /* 70003F62 */
	0x0F12F000,    /* 70003F64 */
	0x0F12F972,    /* 70003F66 */
	0x0F124842,    /* 70003F68 */
	0x0F123820,    /* 70003F6A */
	0x0F128BC0,    /* 70003F6C */
	0x0F12F000,    /* 70003F6E */
	0x0F12F975,    /* 70003F70 */
	0x0F124B42,    /* 70003F72 */
	0x0F12220D,    /* 70003F74 */
	0x0F120712,    /* 70003F76 */
	0x0F1218A8,    /* 70003F78 */
	0x0F128806,    /* 70003F7A */
	0x0F1200E1,    /* 70003F7C */
	0x0F1218C9,    /* 70003F7E */
	0x0F1281CE,    /* 70003F80 */
	0x0F128846,    /* 70003F82 */
	0x0F12818E,    /* 70003F84 */
	0x0F128886,    /* 70003F86 */
	0x0F12824E,    /* 70003F88 */
	0x0F1288C0,    /* 70003F8A */
	0x0F128208,    /* 70003F8C */
	0x0F123508,    /* 70003F8E */
	0x0F12042D,    /* 70003F90 */
	0x0F120C2D,    /* 70003F92 */
	0x0F121C64,    /* 70003F94 */
	0x0F120424,    /* 70003F96 */
	0x0F120C24,    /* 70003F98 */
	0x0F122C07,    /* 70003F9A */
	0x0F12D3EC,    /* 70003F9C */
	0x0F12E658,    /* 70003F9E */
	0x0F12B510,    /* 70003FA0 */
	0x0F124834,    /* 70003FA2 */
	0x0F124C34,    /* 70003FA4 */
	0x0F1288C0,    /* 70003FA6 */
	0x0F128060,    /* 70003FA8 */
	0x0F122001,    /* 70003FAA */
	0x0F128020,    /* 70003FAC */
	0x0F124831,    /* 70003FAE */
	0x0F123820,    /* 70003FB0 */
	0x0F128BC0,    /* 70003FB2 */
	0x0F12F000,    /* 70003FB4 */
	0x0F12F952,    /* 70003FB6 */
	0x0F1288E0,    /* 70003FB8 */
	0x0F124A31,    /* 70003FBA */
	0x0F122800,    /* 70003FBC */
	0x0F12D003,    /* 70003FBE */
	0x0F124930,    /* 70003FC0 */
	0x0F128849,    /* 70003FC2 */
	0x0F122900,    /* 70003FC4 */
	0x0F12D009,    /* 70003FC6 */
	0x0F122001,    /* 70003FC8 */
	0x0F1203C0,    /* 70003FCA */
	0x0F128050,    /* 70003FCC */
	0x0F1280D0,    /* 70003FCE */
	0x0F122000,    /* 70003FD0 */
	0x0F128090,    /* 70003FD2 */
	0x0F128110,    /* 70003FD4 */
	0x0F12BC10,    /* 70003FD6 */
	0x0F12BC08,    /* 70003FD8 */
	0x0F124718,    /* 70003FDA */
	0x0F128050,    /* 70003FDC */
	0x0F128920,    /* 70003FDE */
	0x0F1280D0,    /* 70003FE0 */
	0x0F128960,    /* 70003FE2 */
	0x0F120400,    /* 70003FE4 */
	0x0F121400,    /* 70003FE6 */
	0x0F128090,    /* 70003FE8 */
	0x0F1289A1,    /* 70003FEA */
	0x0F120409,    /* 70003FEC */
	0x0F121409,    /* 70003FEE */
	0x0F128111,    /* 70003FF0 */
	0x0F1289E3,    /* 70003FF2 */
	0x0F128A24,    /* 70003FF4 */
	0x0F122B00,    /* 70003FF6 */
	0x0F12D104,    /* 70003FF8 */
	0x0F1217C3,    /* 70003FFA */
	0x0F120F5B,    /* 70003FFC */
	0x0F121818,    /* 70003FFE */
	0x0F1210C0,    /* 70004000 */
	0x0F128090,    /* 70004002 */
	0x0F122C00,    /* 70004004 */
	0x0F12D1E6,    /* 70004006 */
	0x0F1217C8,    /* 70004008 */
	0x0F120F40,    /* 7000400A */
	0x0F121840,    /* 7000400C */
	0x0F1210C0,    /* 7000400E */
	0x0F128110,    /* 70004010 */
	0x0F12E7E0,    /* 70004012 */
	0x0F12B510,    /* 70004014 */
	0x0F12000C,    /* 70004016 */
	0x0F124919,    /* 70004018 */
	0x0F122204,    /* 7000401A */
	0x0F126820,    /* 7000401C */
	0x0F125E8A,    /* 7000401E */
	0x0F120140,    /* 70004020 */
	0x0F121A80,    /* 70004022 */
	0x0F120280,    /* 70004024 */
	0x0F128849,    /* 70004026 */
	0x0F12F000,    /* 70004028 */
	0x0F12F920,    /* 7000402A */
	0x0F126020,    /* 7000402C */
	0x0F12E7D2,    /* 7000402E */
	0x0F1238D4,    /* 70004030 */
	0x0F127000,    /* 70004032 */
	0x0F1217D0,    /* 70004034 */
	0x0F127000,    /* 70004036 */
	0x0F125000,    /* 70004038 */
	0x0F12D000,    /* 7000403A */
	0x0F121100,    /* 7000403C */
	0x0F12D000,    /* 7000403E */
	0x0F12171A,    /* 70004040 */
	0x0F127000,    /* 70004042 */
	0x0F124780,    /* 70004044 */
	0x0F127000,    /* 70004046 */
	0x0F122FCA,    /* 70004048 */
	0x0F127000,    /* 7000404A */
	0x0F122FC5,    /* 7000404C */
	0x0F127000,    /* 7000404E */
	0x0F122FC6,    /* 70004050 */
	0x0F127000,    /* 70004052 */
	0x0F122ED8,    /* 70004054 */
	0x0F127000,    /* 70004056 */
	0x0F122BD0,    /* 70004058 */
	0x0F127000,    /* 7000405A */
	0x0F1217E0,    /* 7000405C */
	0x0F127000,    /* 7000405E */
	0x0F122DE8,    /* 70004060 */
	0x0F127000,    /* 70004062 */
	0x0F1237E0,    /* 70004064 */
	0x0F127000,    /* 70004066 */
	0x0F12210C,    /* 70004068 */
	0x0F127000,    /* 7000406A */
	0x0F121484,    /* 7000406C */
	0x0F127000,    /* 7000406E */
	0x0F12A006,    /* 70004070 */
	0x0F120000,    /* 70004072 */
	0x0F120724,    /* 70004074 */
	0x0F127000,    /* 70004076 */
	0x0F12A000,    /* 70004078 */
	0x0F12D000,    /* 7000407A */
	0x0F122270,    /* 7000407C */
	0x0F127000,    /* 7000407E */
	0x0F122558,    /* 70004080 */
	0x0F127000,    /* 70004082 */
	0x0F12146C,    /* 70004084 */
	0x0F127000,    /* 70004086 */
	0x0F12B510,    /* 70004088 */
	0x0F12000C,    /* 7000408A */
	0x0F12492E,    /* 7000408C */
	0x0F122208,    /* 7000408E */
	0x0F126820,    /* 70004090 */
	0x0F125E8A,    /* 70004092 */
	0x0F120140,    /* 70004094 */
	0x0F121A80,    /* 70004096 */
	0x0F120280,    /* 70004098 */
	0x0F1288C9,    /* 7000409A */
	0x0F12F000,    /* 7000409C */
	0x0F12F8E6,    /* 7000409E */
	0x0F126020,    /* 700040A0 */
	0x0F12E798,    /* 700040A2 */
	0x0F12B5FE,    /* 700040A4 */
	0x0F12000C,    /* 700040A6 */
	0x0F126825,    /* 700040A8 */
	0x0F126866,    /* 700040AA */
	0x0F1268A0,    /* 700040AC */
	0x0F129001,    /* 700040AE */
	0x0F1268E7,    /* 700040B0 */
	0x0F121BA8,    /* 700040B2 */
	0x0F1242B5,    /* 700040B4 */
	0x0F12DA00,    /* 700040B6 */
	0x0F121B70,    /* 700040B8 */
	0x0F129000,    /* 700040BA */
	0x0F124922,    /* 700040BC */
	0x0F124823,    /* 700040BE */
	0x0F12884A,    /* 700040C0 */
	0x0F128843,    /* 700040C2 */
	0x0F12435A,    /* 700040C4 */
	0x0F122304,    /* 700040C6 */
	0x0F125ECB,    /* 700040C8 */
	0x0F120A92,    /* 700040CA */
	0x0F1218D2,    /* 700040CC */
	0x0F1202D2,    /* 700040CE */
	0x0F120C12,    /* 700040D0 */
	0x0F1288CB,    /* 700040D2 */
	0x0F128880,    /* 700040D4 */
	0x0F124343,    /* 700040D6 */
	0x0F120A98,    /* 700040D8 */
	0x0F122308,    /* 700040DA */
	0x0F125ECB,    /* 700040DC */
	0x0F1218C0,    /* 700040DE */
	0x0F1202C0,    /* 700040E0 */
	0x0F120C00,    /* 700040E2 */
	0x0F120411,    /* 700040E4 */
	0x0F120400,    /* 700040E6 */
	0x0F121409,    /* 700040E8 */
	0x0F121400,    /* 700040EA */
	0x0F121A08,    /* 700040EC */
	0x0F124917,    /* 700040EE */
	0x0F1239E0,    /* 700040F0 */
	0x0F126148,    /* 700040F2 */
	0x0F129801,    /* 700040F4 */
	0x0F123040,    /* 700040F6 */
	0x0F127880,    /* 700040F8 */
	0x0F122800,    /* 700040FA */
	0x0F12D103,    /* 700040FC */
	0x0F129801,    /* 700040FE */
	0x0F120029,    /* 70004100 */
	0x0F12F000,    /* 70004102 */
	0x0F12F8B9,    /* 70004104 */
	0x0F128839,    /* 70004106 */
	0x0F129800,    /* 70004108 */
	0x0F124281,    /* 7000410A */
	0x0F12D814,    /* 7000410C */
	0x0F128879,    /* 7000410E */
	0x0F129800,    /* 70004110 */
	0x0F124281,    /* 70004112 */
	0x0F12D20C,    /* 70004114 */
	0x0F129801,    /* 70004116 */
	0x0F120029,    /* 70004118 */
	0x0F12F000,    /* 7000411A */
	0x0F12F8B5,    /* 7000411C */
	0x0F129801,    /* 7000411E */
	0x0F120029,    /* 70004120 */
	0x0F12F000,    /* 70004122 */
	0x0F12F8B1,    /* 70004124 */
	0x0F129801,    /* 70004126 */
	0x0F120029,    /* 70004128 */
	0x0F12F000,    /* 7000412A */
	0x0F12F8AD,    /* 7000412C */
	0x0F12E003,    /* 7000412E */
	0x0F129801,    /* 70004130 */
	0x0F120029,    /* 70004132 */
	0x0F12F000,    /* 70004134 */
	0x0F12F8A8,    /* 70004136 */
	0x0F129801,    /* 70004138 */
	0x0F120032,    /* 7000413A */
	0x0F120039,    /* 7000413C */
	0x0F12F000,    /* 7000413E */
	0x0F12F8AB,    /* 70004140 */
	0x0F126020,    /* 70004142 */
	0x0F12E5D0,    /* 70004144 */
	0x0F120000,    /* 70004146 */
	0x0F122558,    /* 70004148 */
	0x0F127000,    /* 7000414A */
	0x0F122AB8,    /* 7000414C */
	0x0F127000,    /* 7000414E */
	0x0F124778,    /* 70004150 */
	0x0F1246C0,    /* 70004152 */
	0x0F12C000,    /* 70004154 */
	0x0F12E59F,    /* 70004156 */
	0x0F12FF1C,    /* 70004158 */
	0x0F12E12F,    /* 7000415A */
	0x0F121789,    /* 7000415C */
	0x0F120001,    /* 7000415E */
	0x0F124778,    /* 70004160 */
	0x0F1246C0,    /* 70004162 */
	0x0F12C000,    /* 70004164 */
	0x0F12E59F,    /* 70004166 */
	0x0F12FF1C,    /* 70004168 */
	0x0F12E12F,    /* 7000416A */
	0x0F1216F1,    /* 7000416C */
	0x0F120001,    /* 7000416E */
	0x0F124778,    /* 70004170 */
	0x0F1246C0,    /* 70004172 */
	0x0F12C000,    /* 70004174 */
	0x0F12E59F,    /* 70004176 */
	0x0F12FF1C,    /* 70004178 */
	0x0F12E12F,    /* 7000417A */
	0x0F12C3B1,    /* 7000417C */
	0x0F120000,    /* 7000417E */
	0x0F124778,    /* 70004180 */
	0x0F1246C0,    /* 70004182 */
	0x0F12C000,    /* 70004184 */
	0x0F12E59F,    /* 70004186 */
	0x0F12FF1C,    /* 70004188 */
	0x0F12E12F,    /* 7000418A */
	0x0F12C36D,    /* 7000418C */
	0x0F120000,    /* 7000418E */
	0x0F124778,    /* 70004190 */
	0x0F1246C0,    /* 70004192 */
	0x0F12C000,    /* 70004194 */
	0x0F12E59F,    /* 70004196 */
	0x0F12FF1C,    /* 70004198 */
	0x0F12E12F,    /* 7000419A */
	0x0F12F6D7,    /* 7000419C */
	0x0F120000,    /* 7000419E */
	0x0F124778,    /* 700041A0 */
	0x0F1246C0,    /* 700041A2 */
	0x0F12C000,    /* 700041A4 */
	0x0F12E59F,    /* 700041A6 */
	0x0F12FF1C,    /* 700041A8 */
	0x0F12E12F,    /* 700041AA */
	0x0F12B49D,    /* 700041AC */
	0x0F120000,    /* 700041AE */
	0x0F124778,    /* 700041B0 */
	0x0F1246C0,    /* 700041B2 */
	0x0F12C000,    /* 700041B4 */
	0x0F12E59F,    /* 700041B6 */
	0x0F12FF1C,    /* 700041B8 */
	0x0F12E12F,    /* 700041BA */
	0x0F127EDF,    /* 700041BC */
	0x0F120000,    /* 700041BE */
	0x0F124778,    /* 700041C0 */
	0x0F1246C0,    /* 700041C2 */
	0x0F12C000,    /* 700041C4 */
	0x0F12E59F,    /* 700041C6 */
	0x0F12FF1C,    /* 700041C8 */
	0x0F12E12F,    /* 700041CA */
	0x0F12448D,    /* 700041CC */
	0x0F120000,    /* 700041CE */
	0x0F124778,    /* 700041D0 */
	0x0F1246C0,    /* 700041D2 */
	0x0F12F004,    /* 700041D4 */
	0x0F12E51F,    /* 700041D6 */
	0x0F1229EC,    /* 700041D8 */
	0x0F120001,    /* 700041DA */
	0x0F124778,    /* 700041DC */
	0x0F1246C0,    /* 700041DE */
	0x0F12C000,    /* 700041E0 */
	0x0F12E59F,    /* 700041E2 */
	0x0F12FF1C,    /* 700041E4 */
	0x0F12E12F,    /* 700041E6 */
	0x0F122EF1,    /* 700041E8 */
	0x0F120000,    /* 700041EA */
	0x0F124778,    /* 700041EC */
	0x0F1246C0,    /* 700041EE */
	0x0F12C000,    /* 700041F0 */
	0x0F12E59F,    /* 700041F2 */
	0x0F12FF1C,    /* 700041F4 */
	0x0F12E12F,    /* 700041F6 */
	0x0F12EE03,    /* 700041F8 */
	0x0F120000,    /* 700041FA */
	0x0F124778,    /* 700041FC */
	0x0F1246C0,    /* 700041FE */
	0x0F12C000,    /* 70004200 */
	0x0F12E59F,    /* 70004202 */
	0x0F12FF1C,    /* 70004204 */
	0x0F12E12F,    /* 70004206 */
	0x0F12A58B,    /* 70004208 */
	0x0F120000,    /* 7000420A */
	0x0F124778,    /* 7000420C */
	0x0F1246C0,    /* 7000420E */
	0x0F12C000,    /* 70004210 */
	0x0F12E59F,    /* 70004212 */
	0x0F12FF1C,    /* 70004214 */
	0x0F12E12F,    /* 70004216 */
	0x0F127C49,    /* 70004218 */
	0x0F120000,    /* 7000421A */
	0x0F124778,    /* 7000421C */
	0x0F1246C0,    /* 7000421E */
	0x0F12C000,    /* 70004220 */
	0x0F12E59F,    /* 70004222 */
	0x0F12FF1C,    /* 70004224 */
	0x0F12E12F,    /* 70004226 */
	0x0F127C63,    /* 70004228 */
	0x0F120000,    /* 7000422A */
	0x0F124778,    /* 7000422C */
	0x0F1246C0,    /* 7000422E */
	0x0F12C000,    /* 70004230 */
	0x0F12E59F,    /* 70004232 */
	0x0F12FF1C,    /* 70004234 */
	0x0F12E12F,    /* 70004236 */
	0x0F122DB7,    /* 70004238 */
	0x0F120000,    /* 7000423A */
	0x0F124778,    /* 7000423C */
	0x0F1246C0,    /* 7000423E */
	0x0F12C000,    /* 70004240 */
	0x0F12E59F,    /* 70004242 */
	0x0F12FF1C,    /* 70004244 */
	0x0F12E12F,    /* 70004246 */
	0x0F12EB3D,    /* 70004248 */
	0x0F120000,    /* 7000424A */
	0x0F124778,    /* 7000424C */
	0x0F1246C0,    /* 7000424E */
	0x0F12C000,    /* 70004250 */
	0x0F12E59F,    /* 70004252 */
	0x0F12FF1C,    /* 70004254 */
	0x0F12E12F,    /* 70004256 */
	0x0F12F061,    /* 70004258 */
	0x0F120000,    /* 7000425A */
	0x0F124778,    /* 7000425C */
	0x0F1246C0,    /* 7000425E */
	0x0F12C000,    /* 70004260 */
	0x0F12E59F,    /* 70004262 */
	0x0F12FF1C,    /* 70004264 */
	0x0F12E12F,    /* 70004266 */
	0x0F12F0EF,    /* 70004268 */
	0x0F120000,    /* 7000426A */
	0x0F124778,    /* 7000426C */
	0x0F1246C0,    /* 7000426E */
	0x0F12F004,    /* 70004270 */
	0x0F12E51F,    /* 70004272 */
	0x0F122824,    /* 70004274 */
	0x0F120001,    /* 70004276 */
	0x0F124778,    /* 70004278 */
	0x0F1246C0,    /* 7000427A */
	0x0F12C000,    /* 7000427C */
	0x0F12E59F,    /* 7000427E */
	0x0F12FF1C,    /* 70004280 */
	0x0F12E12F,    /* 70004282 */
	0x0F128EDD,    /* 70004284 */
	0x0F120000,    /* 70004286 */
	0x0F124778,    /* 70004288 */
	0x0F1246C0,    /* 7000428A */
	0x0F12C000,    /* 7000428C */
	0x0F12E59F,    /* 7000428E */
	0x0F12FF1C,    /* 70004290 */
	0x0F12E12F,    /* 70004292 */
	0x0F128DCB,    /* 70004294 */
	0x0F120000,    /* 70004296 */
	0x0F124778,    /* 70004298 */
	0x0F1246C0,    /* 7000429A */
	0x0F12C000,    /* 7000429C */
	0x0F12E59F,    /* 7000429E */
	0x0F12FF1C,    /* 700042A0 */
	0x0F12E12F,    /* 700042A2 */
	0x0F128E17,    /* 700042A4 */
	0x0F120000,    /* 700042A6 */
	/* End of Patch Data(Last : 700042A6h)*/
	/* Total Size 1968 */
	/* Addr : 3AF8 , Size : 1966(7AEh) */


	/*#define	TNP_USER_MBCV_CONTROL			*/
	/*#define TNP_4EC_MBR_TUNE					*/
	/*#define TNP_4EC_FORBIDDEN_TUNE			*/
	/*#define TNP_AF_FINESEARCH_DRIVEBACK		*/
	/*#define TNP_FLASH_ALG						*/
	/*#define TNP_GAS_ALPHA_OTP					*/
	/*#define	TNP_AWB_MODUL_COMP				*/


	/*TNP_Regs_usCintrTh         2   70004780	*/
	/*TNP_Regs_usFixedCintc      2   70004782	*/
	/*TNP_Regs_FlsWeightRIn_0_   2   70004784	*/
	/*TNP_Regs_FlsWeightRIn_1_   2   70004786	*/
	/*TNP_Regs_FlsWeightRIn_2_   2   70004788	*/
	/*TNP_Regs_FlsWeightRIn_3_   2   7000478A	*/
	/*TNP_Regs_FlsWeightRIn_4_   2   7000478C	*/
	/*TNP_Regs_FlsWeightRIn_5_   2   7000478E	*/
	/*TNP_Regs_FlsWeightROut_0_  2   70004790	*/
	/*TNP_Regs_FlsWeightROut_1_  2   70004792	*/
	/*TNP_Regs_FlsWeightROut_2_  2   70004794	*/
	/*TNP_Regs_FlsWeightROut_3_  2   70004796	*/
	/*TNP_Regs_FlsWeightROut_4_  2   70004798	*/
	/*TNP_Regs_FlsWeightROut_5_  2   7000479A	*/

	/*TNP_Regs_FlBRIn_0_         2   7000479C	*/
	/*TNP_Regs_FlBRIn_1_         2   7000479E	*/
	/*TNP_Regs_FlBRIn_2_         2   700047A0	*/
	/*TNP_Regs_FlBRInOut_0_      2   700047A2	*/
	/*TNP_Regs_FlBRInOut_1_      2   700047A4	*/
	/*TNP_Regs_FlBRInOut_2_      2   700047A6	*/

	0x0028D000,
	0x002A1000,
	0x0F120001,

	/* AF setting */
	0x00287000,
	0x002A01FC,
	0x0F120001,	/* #REG_TC_IPRM_LedGpio	*/
	0x002A1720,
	0x0F120100,
	0x002A01FE,
	0x0F120003,
	0x0F120000,
	0x002A0204,
	0x0F120061,
	0x002A020C,
	0x0F122F0C,
	0x0F120190,
	0x002A0294,
	0x0F120100,
	0x0F1200E3,
	0x0F120200,
	0x0F120238,
	0x0F1201C6,
	0x0F120166,
	0x0F120074,
	0x0F120132,
	0x0F120001,

	0x002A070E,
	0x0F1200C0,
	0x002A071E,
	0x0F120001,
	0x002A163C,
	0x0F120000,
	0x002A1648,
	0x0F129002,
	0x002A1652,
	0x0F120002,
	0x0F120000,
	0x002A15E0,
	0x0F120902,

	0x002A164C,
	0x0F120003,
	0x002A163E,
	0x0F1200D5,
	0x0F120098,
	0x002A15D4,
	0x0F120000,
	0x0F12D000,
	0x002A169A,
	0x0F12FF95,
	0x002A166A,
	0x0F120280,
	0x002A1676,
	0x0F1203A0,
	0x0F120320,
	0x002A16BC,
	0x0F120030,
	0x002A16E0,
	0x0F120060,
	0x002A16D4,
	0x0F120010,
	0x002A1656,
	0x0F120000,
	0x002A15E6,
	0x0F12003C,

	0x0F120018,	/*#af_pos_usTableLastInd*/
	0x0F12002A,
	0x0F120030,
	0x0F120036,
	0x0F12003C,
	0x0F120042,
	0x0F120048,
	0x0F12004E,
	0x0F120054,
	0x0F12005A,
	0x0F120060,
	0x0F120066,
	0x0F12006C,
	0x0F120072,
	0x0F120078,
	0x0F12007E,
	0x0F120084,
	0x0F12008A,
	0x0F120090,
	0x0F120096,
	0x0F12009C,
	0x0F1200A2,
	0x0F1200A8,
	0x0F1200AE,
	0x0F1200B4,
	0x0F1200BA,	/*#af_pos_usTable_24_*/

	0x002A1722,
	0x0F128000,
	0x0F120006,
	0x0F123FF0,
	0x0F1203E8,
	0x0F120000,
	0x0F120020,
	0x0F120010,
	0x0F120008,
	0x0F120040,
	0x0F120080,
	0x0F1200C0,
	0x0F1200E0,

	0x002A028C,
	0x0F120003,	/*#REG_TC_AF_AfCmd*/

	/* GAS TBL setting */
	0x002A08B4,
	0x0F120001,	/*#wbt_bUseOutdoorASH*/

	/*TVAR_ash_AwbAshCord, Refer Mon_AWB_RotGain*/
	0x002A08BC,
	0x0F1200C0,	/*#TVAR_ash_AwbAshCord_0_ 2300K*/
	0x0F1200DF,	/*#TVAR_ash_AwbAshCord_1_ 2750K*/
	0x0F120100,	/*#TVAR_ash_AwbAshCord_2_ 3300K*/
	0x0F120125,	/*#TVAR_ash_AwbAshCord_3_ 4150K*/
	0x0F12015F,	/*#TVAR_ash_AwbAshCord_4_ 5250K*/
	0x0F12017C,	/*#TVAR_ash_AwbAshCord_5_ 6400K*/
	0x0F120194,	/*#TVAR_ash_AwbAshCord_6_ 7500K*/


	0x002A08F6,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x0F124500,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x002A08F4,
	0x0F120001,	/*#ash_bUseGasAlpha*/

	/* AE START */

	/*AE WEIGHT */
	0x002A1492,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120202,
	0x0F120202,
	0x0F120102,

	0x002A1484,
	0x0F12003C,	/*#TVAR_ae_BrAve*/
	0x002A148A,
	0x0F12000F,	/*#ae_StatMode*/
	0x002A058C,
	0x0F123520,
	0x0F120000,	/*#lt_uMaxExp1*/
	0x0F12C350,
	0x0F120000,	/*#lt_uMaxExp2*/
	0x0F123520,
	0x0F120000,	/*#lt_uCapMaxExp1*/
	0x0F12C350,
	0x0F120000,	/*#lt_uCapMaxExp2*/
	0x0F120470,	/*#lt_uMaxAnGain1*/
	0x0F120C00,	/*#lt_uMaxAnGain2*/
	0x0F120100,	/*#lt_uMaxDigGain*/
	0x0F121000,	/*#lt_uMaxTotGain*/

	0x002A0544,
	0x0F120111,	/*#lt_uLimitHigh*/
	0x0F1200EF,	/*#lt_uLimitLow*/

	0x002A0F2A,
	0x0F120001,	/*#AFC_Default60Hz*/
	0x002A0F30,
	0x0F120002,	/*#AFC_D_ConvAccelerPower*/

	0x002A0608,
	0x0F120001,	/*#lt_ExpGain_uSubsamplingmode*/
	0x0F120001,	/*#lt_ExpGain_uNonSubsampling*/
	0x0F120800,	/*#lt_ExpGain_ExpCurveGainMaxStr*/
	0x0F120100,	/*#lt_ExpGain_ExpCurveGainMaxStr_0__uMaxDigGain*/
	0x0F120001,
	0x0F120000,	/*#lt_ExpGain_ExpCurveGainMaxStr_0__ulExpIn_0_*/
	0x0F120A3C,
	0x0F120000,
	0x0F120D04,
	0x0F120000,
	0x0F124008,
	0x0F120000,
	0x0F127000,
	0x0F120000,
	0x0F129C00,
	0x0F120000,
	0x0F12AD00,
	0x0F120001,
	0x0F12F1D4,
	0x0F120002,
	0x0F12DC00,
	0x0F120005,
	0x0F12DC00,
	0x0F120005,
	0x0F120001,
	0x0F120000,	/*#lt_ExpGain_ExpCurveGainMaxStr_0__ulExpOut_0_*/
	0x0F120A3C,
	0x0F120000,
	0x0F120D05,
	0x0F120000,
	0x0F123408,
	0x0F120000,
	0x0F123408,
	0x0F120000,
	0x0F126810,
	0x0F120000,
	0x0F128214,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F120650,	/*#lt_ExpGain_ExpCurveGainMaxStr_1_*/
	0x0F120100,	/*#lt_ExpGain_ExpCurveGainMaxStr_1__uMaxDigGain*/

	0x002A06B8,
	0x0F12452C,
	0x0F120004,	/*#lt_uMaxLei*/

	0x002A05D0,
	0x0F120000,	/*#lt_mbr_Peak_behind*/

	/* AWB init Start point */
	0x002A145E,
	0x0F120688, /* 0400 */
	0x0F1203C8, /* 0428 */
	0x0F120658, /* 9B3  */

	/* AWB Init */
	/*White Locus */
	0x002A11F0,
	0x0F12012C,	/*#awbb_IntcR*/
	0x0F120121,	/*#awbb_IntcB*/

	/* IndoorZone*/
	0x002A101C,
	0x0F12039A,
	0x0F1203E8,
	0x0F12033C,
	0x0F1203AE,
	0x0F1202DE,
	0x0F120376,
	0x0F12029C,
	0x0F12033C,
	0x0F12027E,
	0x0F120312,
	0x0F12025E,
	0x0F1202F6,
	0x0F12023E,
	0x0F1202DA,
	0x0F12022A,
	0x0F1202BC,
	0x0F120214,
	0x0F1202A2,
	0x0F1201FE,
	0x0F120292,
	0x0F1201F0,
	0x0F120284,
	0x0F1201E0,
	0x0F120276,
	0x0F1201D2,
	0x0F120266,
	0x0F1201C4,
	0x0F120258,
	0x0F1201D8,
	0x0F120216,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x0F120005,	/*#awbb_IndoorGrZones_m_GridStep*/
	0x002A1070,
	0x0F12000F,	/*#awbb_IndoorGrZones_ZInfo_m_GridSz*/
	0x002A1074,
	0x0F12013C,	/*#awbb_IndoorGrZones_m_Boffs*/

	/*Outdoor Zone*/
	0x002A1078,
	0x0F120260,
	0x0F1202A2,
	0x0F120256,
	0x0F1202BA,
	0x0F12024C,
	0x0F1202C0,
	0x0F120240,
	0x0F1202C4,
	0x0F120236,
	0x0F1202B6,
	0x0F12022A,
	0x0F1202A8,
	0x0F120228,
	0x0F1202A0,
	0x0F120224,
	0x0F120298,
	0x0F12022C,
	0x0F120292,
	0x0F120232,
	0x0F12028A,
	0x0F120250,
	0x0F120282,
	0x0F120000,
	0x0F120000,

	0x0F120004,	/*#awbb_OutdoorGrZones_m_GridStep*/
	0x002A10AC,
	0x0F12000B,	/*#awbb_OutdoorGrZones_ZInfo_m_GridSz*/
	0x002A10B0,
	0x0F1201DE,	/*#awbb_OutdoorGrZones_m_Boffs*/

	/*LowBR Zone*/
	0x002A10B4,
	0x0F120350,
	0x0F120422,
	0x0F1202C4,
	0x0F120452,
	0x0F120278,
	0x0F12041C,
	0x0F120230,
	0x0F1203EE,
	0x0F1201F0,
	0x0F120392,
	0x0F1201C0,
	0x0F120340,
	0x0F120194,
	0x0F120302,
	0x0F12016E,
	0x0F1202C2,
	0x0F120148,
	0x0F120286,
	0x0F12018A,
	0x0F120242,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x0F120006,	/*#awbb_LowBrGrZones_m_GridStep*/
	0x002A10E8,
	0x0F12000A,	/*#awbb_LowBrGrZones_ZInfo_m_GridSz*/
	0x002A10EC,
	0x0F120106,	/*#awbb_LowBrGrZones_m_Boffs*/

	/*LowTemp Zone*/
	0x002A10F0,
	0x0F120380,
	0x0F120000,	/*#awbb_CrclLowT_R_c*/
	0x0F120168,
	0x0F120000,	/*#awbb_CrclLowT_B_c*/
	0x0F122D90,
	0x0F120000,	/*#awbb_CrclLowT_Rad_c*/

	/*AWB Convergence Speed*/
	0x002A1464,
	0x0F120008,
	0x0F120190,
	0x0F1200A0,

	0x002A1228,
	0x0F1200C0,
	0x002A122C,
	0x0F120010,
	0x002A122A,
	0x0F120010,

	0x002A120A,
	0x0F1205D5,	/*#awbb_MvEq_RBthresh*/
	0x002A120E,
	0x0F120000,

	0x0F120771,
	0x0F1203A4,
	0x0F120036,
	0x0F12002A,

	0x002A1278,
	0x0F12FEF7,
	0x0F120021,
	0x0F120E74,
	0x0F120E74,
	0x0F12018F,
	0x0F120096,
	0x0F12000E,
	0x002A1224,
	0x0F120032,
	0x0F12001E,
	0x0F1200C0,
	0x0F120010,
	0x0F120002, /*awbb_YThreshLow_Low */
	0x002A2BA4,
	0x0F120006,	/*#Mon_AWB_ByPassMode*/

	0x002A146C,
	0x0F120002,	/*#awbb_GridEnable*/

	/*Grid*/
	0x002A1434,
	0x0F120300,	/* awbb_GridConst_1			*/
	0x0F12036E,	/* awbb_GridConst_1_1_  */
	0x0F1203C2,	/* awbb_GridConst_1_2_  */
	0x0F121074,	/* awbb_GridConst_2     */
	0x0F1210C2,	/* awbb_GridConst_2_1_  */
	0x0F121104,	/* awbb_GridConst_2_2_  */
	0x0F121142,	/* awbb_GridConst_2_3_  */
	0x0F1211BB,	/* awbb_GridConst_2_4_  */
	0x0F12123B,	/* awbb_GridConst_2_5_  */
	0x0F1200AB,	/* awbb_GridCoeff_R_1   */
	0x0F1200BF,	/* awbb_GridCoeff_B_1   */
	0x0F1200D2,	/* awbb_GridCoeff_R_2   */
	0x0F120093,	/* awbb_GridCoeff_B_2   */

	/*Indoor Grid Offset*/
	0x002A13A4,
	0x0F120000,
	0x0F12FFD0,
	0x0F12FFD0,
	0x0F120000,
	0x0F120008,
	0x0F120008,
	0x0F120000,
	0x0F12FFD0,
	0x0F12FFD0,
	0x0F120000,
	0x0F120008,
	0x0F120008,
	0x0F120000,
	0x0F12FFD0,
	0x0F12FFD0,
	0x0F120000,
	0x0F120008,
	0x0F120008,
	0x0F12FFE0,
	0x0F12FFE0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFB0,
	0x0F12FFB0,
	0x0F12FFE0,
	0x0F12FFE0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFB0,
	0x0F12FFB0,
	0x0F12FFE0,
	0x0F12FFE0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFB0,
	0x0F12FFB0,

	/*Outdoor Grid Offset*/
	0x0F12FFB8,
	0x0F12FFD8,
	0x0F12FFD8,
	0x0F12FFD8,
	0x0F120000,
	0x0F120000,
	0x0F12FFB8,
	0x0F12FFD8,
	0x0F12FFD8,
	0x0F12FFD8,
	0x0F120000,
	0x0F120000,
	0x0F12FFB8,
	0x0F12FFD8,
	0x0F12FFD8,
	0x0F12FFD8,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F12FFD0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F120000,
	0x0F12FFD0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F120000,
	0x0F12FFD0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFC0,

	0x002A1208,
	0x0F120020,

	0x002A144E,
	0x0F120000,	/*#awbb_RGainOff*/
	0x0F120000,	/*#awbb_BGainOff*/
	0x0F120000,	/*#awbb_GGainOff*/

	/*RGB Indoor Gamma*/
	0x002A0734,
	0x0F120001,
	0x0F120007,
	0x0F120010,
	0x0F120028,
	0x0F120062,
	0x0F1200D3,
	0x0F120130,
	0x0F120158,
	0x0F12017D,
	0x0F1201BE,
	0x0F1201F8,
	0x0F12022C,
	0x0F12025B,
	0x0F1202AA,
	0x0F1202EC,
	0x0F12034E,
	0x0F120396,
	0x0F1203C6,
	0x0F1203E9,
	0x0F1203F9,
	0x0F120001,
	0x0F120007,
	0x0F120010,
	0x0F120028,
	0x0F120062,
	0x0F1200D3,
	0x0F120130,
	0x0F120158,
	0x0F12017D,
	0x0F1201BE,
	0x0F1201F8,
	0x0F12022C,
	0x0F12025B,
	0x0F1202AA,
	0x0F1202EC,
	0x0F12034E,
	0x0F120396,
	0x0F1203C6,
	0x0F1203E9,
	0x0F1203F9,
	0x0F120001,
	0x0F120007,
	0x0F120010,
	0x0F120028,
	0x0F120062,
	0x0F1200D3,
	0x0F120130,
	0x0F120158,
	0x0F12017D,
	0x0F1201BE,
	0x0F1201F8,
	0x0F12022C,
	0x0F12025B,
	0x0F1202AA,
	0x0F1202EC,
	0x0F12034E,
	0x0F120396,
	0x0F1203C6,
	0x0F1203E9,
	0x0F1203F9,

	/*RGB Outdoor Gamma*/
	0x0F120000,
	0x0F12000F,
	0x0F120020,
	0x0F120043,
	0x0F120086,
	0x0F1200ED,
	0x0F12013E,
	0x0F120163,
	0x0F120185,
	0x0F1201BF,
	0x0F1201F2,
	0x0F120221,
	0x0F12024A,
	0x0F120294,
	0x0F1202D0,
	0x0F12032A,
	0x0F12036A,
	0x0F12039F,
	0x0F1203CC,
	0x0F1203F9,
	0x0F120000,
	0x0F12000F,
	0x0F120020,
	0x0F120043,
	0x0F120086,
	0x0F1200ED,
	0x0F12013E,
	0x0F120163,
	0x0F120185,
	0x0F1201BF,
	0x0F1201F2,
	0x0F120221,
	0x0F12024A,
	0x0F120294,
	0x0F1202D0,
	0x0F12032A,
	0x0F12036A,
	0x0F12039F,
	0x0F1203CC,
	0x0F1203F9,
	0x0F120000,
	0x0F12000F,
	0x0F120020,
	0x0F120043,
	0x0F120086,
	0x0F1200ED,
	0x0F12013E,
	0x0F120163,
	0x0F120185,
	0x0F1201BF,
	0x0F1201F2,
	0x0F120221,
	0x0F12024A,
	0x0F120294,
	0x0F1202D0,
	0x0F12032A,
	0x0F12036A,
	0x0F12039F,
	0x0F1203CC,
	0x0F1203F9,

	/*CCM*/
	0x002A08A6,
	0x0F1200C0,
	0x0F1200D0,
	0x0F1200E0,
	0x0F120110,
	0x0F12017C,
	0x0F120194,

	0x0F120001,

	0x002A0898,
	0x0F124800,
	0x0F127000,
	0x002A08A0,
	0x0F1248D8,
	0x0F127000,

	0x002A4800,
	0x0F12010F,	/*hor*/
	0x0F12FF90,
	0x0F12FF7D,
	0x0F12FEF1,
	0x0F120137,
	0x0F12FF68,
	0x0F12FFEE,
	0x0F12FF8A,
	0x0F12013A,
	0x0F12006E,
	0x0F120089,
	0x0F12FEFE,
	0x0F120175,
	0x0F12FF4A,
	0x0F1200D6,
	0x0F12FEFE,
	0x0F120113,
	0x0F1200E6,
	0x0F12010F,	/*incaA*/
	0x0F12FF90,
	0x0F12FF7D,
	0x0F12FEF1,
	0x0F120137,
	0x0F12FF68,
	0x0F12FFEE,
	0x0F12FF8A,
	0x0F12013A,
	0x0F12006E,
	0x0F120089,
	0x0F12FEFE,
	0x0F120175,
	0x0F12FF4A,
	0x0F1200D6,
	0x0F12FEFE,
	0x0F120113,
	0x0F1200E6,
	0x0F12010F,	/*WW*/
	0x0F12FF90,
	0x0F12FF7D,
	0x0F12FEF1,
	0x0F120137,
	0x0F12FF68,
	0x0F12FFEE,
	0x0F12FF8A,
	0x0F12013A,
	0x0F12006E,
	0x0F120089,
	0x0F12FEFE,
	0x0F120175,
	0x0F12FF4A,
	0x0F1200D6,
	0x0F12FEFE,
	0x0F120113,
	0x0F1200E6,
	0x0F12017B,	/*CW*/
	0x0F12FFB5,
	0x0F12FFF9,
	0x0F12FF5E,
	0x0F12019D,
	0x0F12FFA2,
	0x0F12FFD9,
	0x0F12FFCB,
	0x0F12012C,
	0x0F1200C9,
	0x0F1200B0,
	0x0F12FF2F,
	0x0F1200CA,
	0x0F12FF91,
	0x0F12015E,
	0x0F12FF47,
	0x0F120129,
	0x0F120125,
	0x0F1201BC,	/*D50*/
	0x0F12FFB5,
	0x0F12FFF0,
	0x0F12FF32,
	0x0F1201E8,
	0x0F12FF87,
	0x0F12FFC8,
	0x0F12FFC1,
	0x0F12013A,
	0x0F120112,
	0x0F1200EE,
	0x0F12FF99,
	0x0F12009D,
	0x0F12FF71,
	0x0F120197,
	0x0F12FF0C,
	0x0F12013D,
	0x0F12013D,
	0x0F1201BC,	/*D65*/
	0x0F12FFB5,
	0x0F12FFF0,
	0x0F12FF32,
	0x0F1201E8,
	0x0F12FF87,
	0x0F12FFC8,
	0x0F12FFC1,
	0x0F12013A,
	0x0F120112,
	0x0F1200EE,
	0x0F12FF99,
	0x0F12009D,
	0x0F12FF71,
	0x0F120197,
	0x0F12FF0C,
	0x0F12013D,
	0x0F12013D,

	0x0F12019F,	/*#TVAR_wbt_pOutdoorCcm[0]*/
	0x0F12FFBF,
	0x0F12FFFD,
	0x0F12FF10,
	0x0F1201D4,
	0x0F12FFA4,
	0x0F12FFE8,
	0x0F12FFE0,
	0x0F1201C2,
	0x0F120087,
	0x0F1200A5,
	0x0F12FF17,
	0x0F1201DD,
	0x0F12FF0E,
	0x0F12010B,
	0x0F12FF24,
	0x0F1200F0,
	0x0F1201DB,

	/*AFIT*/
	0x002A0944,
	0x0F120050,	/*#afit_uNoiseIndInDoor_0_*/
	0x0F120103,	/*#afit_uNoiseIndInDoor_1_*/
	0x0F120196,	/*#afit_uNoiseIndInDoor_2_*/
	0x0F120245,	/*#afit_uNoiseIndInDoor_3_*/
	0x0F120300,	/*#afit_uNoiseIndInDoor_4_*/

	0x002A097A,
	0x0F120001,	/*#afit_bUseSenBpr*/
	0x0F1201CC,	/*#afit_usBprThr_0_*/
	0x0F1201CC,	/*#afit_usBprThr_1_*/
	0x0F1201CC,	/*#afit_usBprThr_2_*/
	0x0F1201CC,	/*#afit_usBprThr_3_*/
	0x0F1201CC,	/*#afit_usBprThr_4_*/
	0x0F120180,	/*#afit_NIContrastAFITValue*/
	0x0F120196,	/*#afit_NIContrastTh*/

	0x002A0976,
	0x0F120070,
	0x0F120005,

	0x002A0938,
	0x0F120000,
	0x0F120014,	/*#SARR_uNormBrInDoor_0_*/
	0x0F1200D2,	/*#SARR_uNormBrInDoor_1_*/
	0x0F120384,	/*#SARR_uNormBrInDoor_2_*/
	0x0F1207D0,	/*#SARR_uNormBrInDoor_3_*/
	0x0F121388,	/*#SARR_uNormBrInDoor_4_*/

	0x002A098C,
	0x0F120000,	/*AFIT 0*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F12005F,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120040,
	0x0F1200A0,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F123604,
	0x0F12032A,
	0x0F120403,
	0x0F121B06,
	0x0F126015,
	0x0F1200C0,
	0x0F126080,
	0x0F124080,
	0x0F120640,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120000,
	0x0F120400,
	0x0F12365A,
	0x0F12102A,
	0x0F12000B,
	0x0F120600,
	0x0F125A0F,
	0x0F120505,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123028,
	0x0F120418,
	0x0F120101,
	0x0F120800,
	0x0F121804,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120705,
	0x0F120206,
	0x0F120304,
	0x0F120309,
	0x0F120305,
	0x0F122006,
	0x0F121320,
	0x0F121014,
	0x0F121010,
	0x0F120C10,
	0x0F121A0C,
	0x0F124A18,
	0x0F120080,
	0x0F120050,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F122A36,
	0x0F126024,
	0x0F122A36,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F123601,
	0x0F12242A,
	0x0F123660,
	0x0F12FF2A,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,	/*AFIT 1*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120051,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F122404,
	0x0F12031B,
	0x0F120103,
	0x0F121205,
	0x0F12400D,
	0x0F120080,
	0x0F121980,
	0x0F12272E,
	0x0F120629,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120300,
	0x0F12245A,
	0x0F121018,
	0x0F12000B,
	0x0F120B00,
	0x0F125A0F,
	0x0F120505,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123828,
	0x0F120425,
	0x0F120101,
	0x0F120800,
	0x0F121004,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120205,
	0x0F120304,
	0x0F120409,
	0x0F120306,
	0x0F120407,
	0x0F122204,
	0x0F12021C,
	0x0F121102,
	0x0F120611,
	0x0F121A02,
	0x0F128018,
	0x0F120080,
	0x0F120074,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F12141D,
	0x0F126024,
	0x0F121217,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F122401,
	0x0F12241B,
	0x0F121E60,
	0x0F12FF18,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,	/*AFIT 2*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120043,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F121B04,
	0x0F120312,
	0x0F120003,
	0x0F120C03,
	0x0F122806,
	0x0F120060,
	0x0F121580,
	0x0F122020,
	0x0F120620,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120300,
	0x0F12145A,
	0x0F121010,
	0x0F12000B,
	0x0F120E00,
	0x0F125A0F,
	0x0F120504,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123828,
	0x0F120428,
	0x0F120101,
	0x0F128000,
	0x0F120A04,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120207,
	0x0F120304,
	0x0F120409,
	0x0F120306,
	0x0F120407,
	0x0F122404,
	0x0F120221,
	0x0F121202,
	0x0F120613,
	0x0F121A02,
	0x0F128018,
	0x0F120080,
	0x0F120080,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F12121B,
	0x0F126024,
	0x0F120C0C,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F121B01,
	0x0F122412,
	0x0F120C60,
	0x0F12FF0C,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,	/*AFIT 3*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120032,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F121504,
	0x0F12030F,
	0x0F120003,
	0x0F120902,
	0x0F122004,
	0x0F120050,
	0x0F121140,
	0x0F12201C,
	0x0F120620,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120300,
	0x0F12145A,
	0x0F121010,
	0x0F12000B,
	0x0F121000,
	0x0F125A0F,
	0x0F120503,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123C28,
	0x0F12042C,
	0x0F120101,
	0x0F12FF00,
	0x0F120904,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120206,
	0x0F120304,
	0x0F120409,
	0x0F120305,
	0x0F120406,
	0x0F122804,
	0x0F120228,
	0x0F121402,
	0x0F120618,
	0x0F121A02,
	0x0F128018,
	0x0F120080,
	0x0F120080,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F120F15,
	0x0F126024,
	0x0F120A0A,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F121501,
	0x0F12240F,
	0x0F120A60,
	0x0F12FF0A,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,	/*AFIT 4*/
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120032,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F120F04,
	0x0F12030C,
	0x0F120003,
	0x0F120602,
	0x0F121803,
	0x0F120040,
	0x0F120E20,
	0x0F122018,
	0x0F120620,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120200,
	0x0F12145A,
	0x0F121010,
	0x0F12000B,
	0x0F121200,
	0x0F125A0F,
	0x0F120502,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F124028,
	0x0F120430,
	0x0F120101,
	0x0F12FF00,
	0x0F120804,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120205,
	0x0F120304,
	0x0F120409,
	0x0F120306,
	0x0F120407,
	0x0F122C04,
	0x0F12022C,
	0x0F121402,
	0x0F120618,
	0x0F121A02,
	0x0F128018,
	0x0F120080,
	0x0F120080,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F120C0F,
	0x0F126024,
	0x0F120808,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F120F01,
	0x0F12240C,
	0x0F120860,
	0x0F12FF08,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F1223CE,
	0x0F12FDC8,
	0x0F12112E,
	0x0F1283A5,
	0x0F12FE67,
	0x0F120000,

	/*System Setting*/
	0x002A01F8,
	0x0F125DC0,	/*#REG_TC_IPRM_InClockLSBs, MCLK: 24Mhz*/
	0x002A0212,
	0x0F120002,	/*#REG_TC_IPRM_UseNPviClocks*/
	0x0F120000,	/*#REG_TC_IPRM_UseNMipiClocks*/
	0x0F120000,	/*#REG_TC_IPRM_NumberOfMipiLanes*/
	0x002A021A,
	0x0F123A98,	/*#REG_TC_IPRM_OpClk4KHz_0, SCLK: 60Mhz*/
	0x0F124F1A,	/*#REG_TC_IPRM_MinOutRate4KHz_0	PCLK Min : 81Mhz*/
	0x0F124F1A,	/*#REG_TC_IPRM_MaxOutRate4KHz_0	PCLK Max : 81Mhz*/
	0x0F124F1A,	/*#REG_TC_IPRM_OpClk4KHz_1	SCLK	 : 81Mhz*/
	0x0F124F1A,	/*#REG_TC_IPRM_MinOutRate4KHz_1	PCLK Min : 81Mhz*/
	0x0F124F1A,	/*#REG_TC_IPRM_MaxOutRate4KHz_1 PCLK Max : 81Mhz*/
	0x002A022C,
	0x0F120001,	/*#REG_TC_IPRM_InitParamsUpdated*/

	/*ETC.. Setting*/
	0x002A0478,
	0x0F12005F,	/*#REG_TC_BRC_usPrevQuality*/
	0x0F12005F,	/*#REG_TC_BRC_usCaptureQuality*/

	0x0F120001,	/*#REG_TC_THUMB_Thumb_bActive*/
	0x0F120280,	/*#REG_TC_THUMB_Thumb_uWidth*/
	0x0F1201E0,	/*#REG_TC_THUMB_Thumb_uHeight*/
	0x0F120005,	/*#REG_TC_THUMB_Thumb_Format*/

	0x002A17DC,
	0x0F120054,	/*#jpeg_ManualMBCV*/
	0x002A1AE4,
	0x0F12001C,	/*#senHal_bExtraAddLine*/
	0x002A0284,
	0x0F120001,	/*#REG_TC_GP_bBypassScalerJpg*/
	0x002A028A,
	0x0F120001,	/*#REG_TC_GP_bUse1FrameCaptureMode
			  0 : Continuous mode,1 : Single frame mode*/

	/*Configuration Setting*/
	0x002A02A6,
	0x0F120280,	/*#REG_0TC_PCFG_usWidth	   : 640*/
	0x0F1201E0,	/*#REG_0TC_PCFG_usHeight   : 480*/
	0x0F120005,	/*#REG_0TC_PCFG_Format	5 : YUV	7 : Raw	9 : JPG*/
	0x0F124F1A,	/*#REG_0TC_PCFG_usMaxOut4KHzRate*/
	0x0F124F1A,	/*#REG_0TC_PCFG_usMinOut4KHzRate*/
	0x0F120100,	/*#REG_0TC_PCFG_OutClkPerPix88*/
	0x0F120300,	/*#REG_0TC_PCFG_uBpp88*/
	0x0F120052,	/*#REG_0TC_PCFG_PVIMask*/
	0x0F120000,	/*#REG_0TC_PCFG_OIFMask*/
	0x0F1201E0,	/*#REG_0TC_PCFG_usJpegPacketSize*/
	0x0F120000,	/*#REG_0TC_PCFG_usJpegTotalPackets*/
	0x0F120000,	/*#REG_0TC_PCFG_uClockInd*/
	0x0F120000,	/*#REG_0TC_PCFG_usFrTimeType*/
	0x0F120001,	/*#REG_0TC_PCFG_FrRateQualityType*/
	0x0F12029A,	/*#REG_0TC_PCFG_usMaxFrTimeMsecMult10*/
	0x0F12014A,	/*#REG_0TC_PCFG_usMinFrTimeMsecMult10*/
	0x002A02D0,
	0x0F120000,	/*#REG_0TC_PCFG_uPrevMirror*/
	0x0F120000,	/*#REG_0TC_PCFG_uCaptureMirror*/
	0x0F120000,	/*#REG_0TC_PCFG_uRotation*/

	0x002A0396,
	0x0F120000,	/*#REG_0TC_CCFG_uCaptureMode*/
	0x0F120A00,	/*#REG_0TC_CCFG_usWidth*/
	0x0F120780,	/*#REG_0TC_CCFG_usHeight*/
	0x0F120009,	/*#REG_0TC_CCFG_Format*/
	0x0F124F1A,	/*#REG_0TC_CCFG_usMaxOut4KHzRate*/
	0x0F124F1A,	/*#REG_0TC_CCFG_usMinOut4KHzRate*/
	0x0F120100,	/*#REG_0TC_CCFG_OutClkPerPix88*/
	0x0F120300,	/*#REG_0TC_CCFG_uBpp88*/
	0x0F120042,	/*#REG_0TC_CCFG_PVIMask*/
	0x0F120000,	/*#REG_0TC_CCFG_OIFMask*/
	0x0F1201E0,	/*#REG_0TC_CCFG_usJpegPacketSize*/
	0x0F120000,	/*#REG_0TC_CCFG_usJpegTotalPackets*/
	0x0F120001,	/*#REG_0TC_CCFG_uClockInd*/
	0x0F120000,	/*#REG_0TC_CCFG_usFrTimeType*/
	0x0F120002,	/*#REG_0TC_CCFG_FrRateQualityType*/
	0x0F120535,	/*#REG_0TC_CCFG_usMaxFrTimeMsecMult10*/
	0x0F12029A,	/*#REG_0TC_CCFG_usMinFrTimeMsecMult10*/

	0x002A0250,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x002A0494,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,

	0x002A0262,
	0x0F120001,
	0x0F120001,
	0x0F120000,	/*#REG_TC_GP_ActivePrevConfig*/
	0x002A026A,
	0x0F120001,	/*#REG_TC_GP_PrevOpenAfterChange*/
	0x002A024E,
	0x0F120001,	/*#REG_TC_GP_NewConfigSync*/
	0x002A0268,
	0x0F120001,	/*#REG_TC_GP_PrevConfigChanged*/
	0x002A0270,
	0x0F120001,	/*#REG_TC_GP_CapConfigChanged*/
	0x002A023E,
	0x0F120001,	/*#REG_TC_GP_EnablePreview*/
	0x0F120001,	/*#REG_TC_GP_EnablePreviewChanged*/
};

static const u32 s5k4ecgx_DTP_init[] = {
	0x0028D000,
	0x002AB054,
	0x0F120001,
	0x00287000,
};

static const u32 s5k4ecgx_DTP_stop[] = {
	0x0028D000,
	0x002AB054,
	0x0F120000,
	0x00287000,
};

static const u32 s5k4ecgx_FPS_Auto[] = {
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014A,
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};

static const u32 s5k4ecgx_FPS_5[] = {

};

static const u32 s5k4ecgx_FPS_7[] = {
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F120535,
	0x0F120535,
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};

static const u32 s5k4ecgx_FPS_10[] = {

};

static const u32 s5k4ecgx_FPS_15[] = {
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12029A,
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};

static const u32 s5k4ecgx_FPS_30[] = {
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F12014D,
	0x0F12014D,
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};

static const u32 s5k4ecgx_FPS_60[] = {

};

static const u32 s5k4ecgx_FPS_120[] = {

};

static const u32 s5k4ecgx_Effect_Normal[] = {
	0x002A023C,
	0x0F120000,
};

static const u32 s5k4ecgx_Effect_Solarization[] = {
	0x002A023C,
	0x0F120002,
};

static const u32 s5k4ecgx_Effect_Negative[] = {
	0x002A023C,
	0x0F120003,
};

static const u32 s5k4ecgx_Effect_Sepia[] = {
	0x002A023C,
	0x0F120004,
};

static const u32 s5k4ecgx_Effect_Black_White[] = {
	0x002A023C,
	0x0F120001,
};


static const u32 s5k4ecgx_WB_Auto[] = {
	0x002A04E6,
	0x0F12077F,
};

static const u32 s5k4ecgx_WB_Sunny[] = {
	0x002A04E6,
	0x0F120777,
	0x002A04BA,
	0x0F1205E0,
	0x0F120001,
	0x0F120400,
	0x0F120001,
	0x0F120530,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_WB_Cloudy[] = {
	0x002A04E6,
	0x0F120777,
	0x002A04BA,
	0x0F120710,
	0x0F120001,
	0x0F120400,
	0x0F120001,
	0x0F120420,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_WB_Tungsten[] = {
	0x002A04E6,
	0x0F120777,
	0x002A04BA,
	0x0F120390,
	0x0F120001,
	0x0F120400,
	0x0F120001,
	0x0F120920,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_WB_Fluorescent[] = {
	0x002A04E6,
	0x0F120777,
	0x002A04BA,
	0x0F120505,
	0x0F120001,
	0x0F120400,
	0x0F120001,
	0x0F120875,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_WDR_on[] = {
	0x002A1BEA,
	0x0F120000,
};

static const u32 s5k4ecgx_WDR_off[] = {
	0x002A1BEA,
	0x0F120001,
};

static const u32 s5k4ecgx_ISO_Auto[] = {
	0x002A0938,
	0x0F120000,

	0x002A0F2A,
	0x0F120001,
	0x002A04E6,
	0x0F12077F,

	0x002A04D0,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x002A06C2,
	0x0F120200,
};

static const u32 s5k4ecgx_ISO_100[] = {
	0x002A04E6,
	0x0F12065F,
	0x002A04D6,
	0x0F120000,
	0x0F120001,

	0x002A04D0,
	0x0F120001,
	0x0F1201A0,
	0x0F120001,
	0x002A06C2,
	0x0F120100,

	0x002A0938,
	0x0F120001,
};

static const u32 s5k4ecgx_ISO_200[] = {
	0x002A04E6,
	0x0F12065F,
	0x002A04D6,
	0x0F120000,
	0x0F120001,

	0x002A04D0,
	0x0F120001,
	0x0F120340,
	0x0F120001,
	0x002A06C2,
	0x0F120100,

	0x002A0938,
	0x0F120001,
};

static const u32 s5k4ecgx_ISO_400[] = {
	0x002A04E6,
	0x0F12065F,
	0x002A04D6,
	0x0F120000,
	0x0F120001,

	0x002A04D0,
	0x0F120001,
	0x0F120680,
	0x0F120001,
	0x002A06C2,
	0x0F120100,

	0x002A0938,
	0x0F120001,
};

static const u32 s5k4ecgx_Metering_Matrix[] = {
	0x002A1492,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
};

static const u32 s5k4ecgx_Metering_Center[] = {
	0x002A1492,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120202,
	0x0F120202,
	0x0F120102,
};

static const u32 s5k4ecgx_Metering_Spot[] = {
	0x002A1492,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120000,
	0x0F12010F,
	0x0F120F01,
	0x0F120000,
	0x0F120000,
	0x0F12010F,
	0x0F120F01,
	0x0F120000,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
};

static const u32 s5k4ecgx_EV_Minus_4[] = {
	0x002A0230,
	0x0F12FF30,
};

static const u32 s5k4ecgx_EV_Minus_3[] = {
	0x002A0230,
	0x0F12FFA0,
};

static const u32 s5k4ecgx_EV_Minus_2[] = {
	0x002A0230,
	0x0F12FFC8,
};

static const u32 s5k4ecgx_EV_Minus_1[] = {
	0x002A0230,
	0x0F12FFE0,
};

static const u32 s5k4ecgx_EV_Default[] = {
	0x002A0230,
	0x0F120000,
};

static const u32 s5k4ecgx_EV_Plus_1[] = {
	0x002A0230,
	0x0F120020,
};

static const u32 s5k4ecgx_EV_Plus_2[] = {
	0x002A0230,
	0x0F120038,
};

static const u32 s5k4ecgx_EV_Plus_3[] = {
	0x002A0230,
	0x0F120060,
};

static const u32 s5k4ecgx_EV_Plus_4[] = {
	0x002A0230,
	0x0F12007F,
};

static const u32 s5k4ecgx_Contrast_Minus_4[] = {
	0x002A0232,
	0x0F12FF81,
};

static const u32 s5k4ecgx_Contrast_Minus_3[] = {
	0x002A0232,
	0x0F12FFA0,
};

static const u32 s5k4ecgx_Contrast_Minus_2[] = {
	0x002A0232,
	0x0F12FFC0,
};

static const u32 s5k4ecgx_Contrast_Minus_1[] = {
	0x002A0232,
	0x0F12FFE0,
};

static const u32 s5k4ecgx_Contrast_Default[] = {
	0x002A0232,
	0x0F120000,
};

static const u32 s5k4ecgx_Contrast_Plus_1[] = {
	0x002A0232,
	0x0F120020,
};

static const u32 s5k4ecgx_Contrast_Plus_2[] = {
	0x002A0232,
	0x0F120040,
};

static const u32 s5k4ecgx_Contrast_Plus_3[] = {
	0x002A0232,
	0x0F120060,
};

static const u32 s5k4ecgx_Contrast_Plus_4[] = {
	0x002A0232,
	0x0F12007F,
};

static const u32 s5k4ecgx_Sharpness_Minus_3[] = {
	0x002A0A28,
	0x0F120000,
	0x002A0ADE,
	0x0F120000,
	0x002A0B94,
	0x0F120000,
	0x002A0C4A,
	0x0F120000,
	0x002A0D00,
	0x0F120000,
};

static const u32 s5k4ecgx_Sharpness_Minus_2[] = {
	0x002A0A28,
	0x0F122010,
	0x002A0ADE,
	0x0F122010,
	0x002A0B94,
	0x0F122010,
	0x002A0C4A,
	0x0F122010,
	0x002A0D00,
	0x0F122010,
};

static const u32 s5k4ecgx_Sharpness_Minus_1[] = {
	0x002A0A28,
	0x0F124020,
	0x002A0ADE,
	0x0F124020,
	0x002A0B94,
	0x0F124020,
	0x002A0C4A,
	0x0F124020,
	0x002A0D00,
	0x0F124020,
};

static const u32 s5k4ecgx_Sharpness_Default[] = {
	0x002A0A28,
	0x0F126024,
	0x002A0ADE,
	0x0F126024,
	0x002A0B94,
	0x0F126024,
	0x002A0C4A,
	0x0F126024,
	0x002A0D00,
	0x0F126024,
};

static const u32 s5k4ecgx_Sharpness_Plus_1[] = {
	0x002A0A28,
	0x0F128040,
	0x002A0ADE,
	0x0F128040,
	0x002A0B94,
	0x0F128040,
	0x002A0C4A,
	0x0F128040,
	0x002A0D00,
	0x0F128040,
};

static const u32 s5k4ecgx_Sharpness_Plus_2[] = {
	0x002A0A28,
	0x0F12A060,
	0x002A0ADE,
	0x0F12A060,
	0x002A0B94,
	0x0F12A060,
	0x002A0C4A,
	0x0F12A060,
	0x002A0D00,
	0x0F12A060,
};

static const u32 s5k4ecgx_Sharpness_Plus_3[] = {
	0x002A0A28,
	0x0F12C080,
	0x002A0ADE,
	0x0F12C080,
	0x002A0B94,
	0x0F12C080,
	0x002A0C4A,
	0x0F12C080,
	0x002A0D00,
	0x0F12C080,
};

static const u32 s5k4ecgx_Saturation_Minus_2[] = {
	0x002A0234,
	0x0F12FF81,
};

static const u32 s5k4ecgx_Saturation_Minus_1[] = {
	0x002A0234,
	0x0F12FFC0,
};

static const u32 s5k4ecgx_Saturation_Default[] = {
	0x002A0234,
	0x0F120000,
};

static const u32 s5k4ecgx_Saturation_Plus_1[] = {
	0x002A0234,
	0x0F120040,
};

static const u32 s5k4ecgx_Saturation_Plus_2[] = {
	0x002A0234,
	0x0F12007F,
};

static const u32 s5k4ecgx_Jpeg_Quality_High[] = {
	0x002A0478,
	0x0F12005F,
	0x0F12005F,
};

static const u32 s5k4ecgx_Jpeg_Quality_Normal[] = {
	0x002A0478,
	0x0F120056,
	0x0F120056,
};

static const u32 s5k4ecgx_Jpeg_Quality_Low[] = {
	0x002A0478,
	0x0F12004F,
	0x0F12004F,
};

static const u32 s5k4ecgx_Scene_Default[] = {
	0x002A1492,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120202,
	0x0F120202,
	0x0F120102,

	0x002A0938,
	0x0F120000,

	0x002A06B8,
	0x0F12452C,
	0x0F120004,

	0x002A0F2A,
	0x0F120001,
	0x002A0F30,
	0x0F120001,
	0x002A04E6,
	0x0F12077F,

	0x002A04D0,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x002A06C2,
	0x0F120200,

	0x002A2C66,
	0x0F120001,

	0x002A1484,
	0x0F12003C,
	0x002A148A,
	0x0F12000F,
	0x002A058C,
	0x0F123520,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F120470,
	0x0F120C00,
	0x0F120100,
	0x0F121000,

	0x002A0544,
	0x0F120111,
	0x0F1200EF,

	0x002A0608,
	0x0F120001,
	0x0F120001,

	0x002A0A28,
	0x0F126024,
	0x002A0ADE,
	0x0F126024,
	0x002A0B94,
	0x0F126024,
	0x002A0C4A,
	0x0F126024,
	0x002A0D00,
	0x0F126024,

	0x002A0234,
	0x0F120000,

	0x002A0638,
	0x0F120001,
	0x0F120000,
	0x002A063C,
	0x0F120A3C,
	0x0F120000,
	0x002A0640,
	0x0F120D05,
	0x0F120000,
	0x002A0644,
	0x0F123408,
	0x0F120000,
	0x002A0648,
	0x0F123408,
	0x0F120000,
	0x002A064C,
	0x0F126810,
	0x0F120000,
	0x002A0650,
	0x0F128214,
	0x0F120000,
	0x002A0654,
	0x0F12C350,
	0x0F120000,
	0x002A0658,
	0x0F12C350,
	0x0F120000,
	0x002A065C,
	0x0F12C350,
	0x0F120000,

	0x002A03B4,
	0x0F120535,
	0x0F12029A,

	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
	0x002A0270,
	0x0F120001,
	0x002A023E,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Portrait[] = {
	0x002A0A28,
	0x0F124020,
	0x002A0ADE,
	0x0F124020,
	0x002A0B94,
	0x0F124020,
	0x002A0C4A,
	0x0F124020,
	0x002A0D00,
	0x0F124020,
};

static const u32 s5k4ecgx_Scene_Nightshot[] = {
	0x002A06B8,
	0x0F12FFFF,
	0x0F1200FF,

	0x002A0608,
	0x0F120000,
	0x0F120000,

	0x002A058C,
	0x0F12F424,
	0x0F120001,
	0x0F12D090,
	0x0F120007,
	0x0F12F424,
	0x0F120001,
	0x0F12D090,
	0x0F120007,
	0x0F120100,
	0x0F120800,
	0x0F120100,
	0x0F122000,

	0x002A03B4,
	0x0F121388,
	0x0F121388,
	0x002A02C2,
	0x0F1209C4,
	0x0F12014A,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
	0x002A0270,
	0x0F120001,
	0x002A023E,
	0x0F120001,
	0x0F120001,

	0x002A0A1E,
	0x0F121580,
};

static const u32 s5k4ecgx_Scene_Backlight[] = {
	0x002A1492,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120000,
	0x0F12010F,
	0x0F120F01,
	0x0F120000,
	0x0F120000,
	0x0F12010F,
	0x0F120F01,
	0x0F120000,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
};

static const u32 s5k4ecgx_Scene_Landscape[] = {
	0x002A1492,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x002A0A28,
	0x0F12E082,
	0x002A0ADE,
	0x0F12E082,
	0x002A0B94,
	0x0F12E082,
	0x002A0C4A,
	0x0F12E082,
	0x002A0D00,
	0x0F12E082,
	0x002A0234,
	0x0F120030,
};

static const u32 s5k4ecgx_Scene_Sports[] = {
	0x002A0608,
	0x0F120000,
	0x0F120000,

	0x002A058C,
	0x0F123520,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F120200,
	0x0F120200,
	0x0F120200,
	0x0F120200,

	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
	0x002A0270,
	0x0F120001,
	0x002A023E,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Party_Indoor[] = {
	0x002A04E6,
	0x0F12065F,
	0x002A04D6,
	0x0F120000,
	0x0F120001,

	0x002A04D0,
	0x0F120001,
	0x0F120340,
	0x0F120001,
	0x002A06C2,
	0x0F120100,

	0x002A0938,
	0x0F120001,

	0x002A0234,
	0x0F120030,
};

static const u32 s5k4ecgx_Scene_Beach_Snow[] = {
	0x002A1484,
	0x0F120045,	/*#TVAR_ae_BrAve*/
	0x002A04E6,
	0x0F12065F,
	0x002A04D6,
	0x0F120000,
	0x0F120001,
	0x002A04D0,
	0x0F120001,
	0x0F1200D0,
	0x0F120001,
	0x002A06C2,
	0x0F120100,

	0x002A0938,
	0x0F120001,

	0x002A0234,
	0x0F120030,
};

static const u32 s5k4ecgx_Scene_Sunset[] = {
	0x002A04E6,
	0x0F120777,

	0x002A04BA,
	0x0F1205E0,
	0x0F120001,
	0x0F120400,
	0x0F120001,
	0x0F120530,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Duskdawn[] = {
	0x002A04E6,
	0x0F120777,
	0x002A04BA,
	0x0F120505,
	0x0F120001,
	0x0F120400,
	0x0F120001,
	0x0F120875,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Fall_Color[] = {
	0x002A0234,
	0x0F120060,
};

static const u32 s5k4ecgx_Scene_Fireworks[] = {
	0x002A0638,
	0x0F120001,
	0x0F120000,
	0x002A063C,
	0x0F121478,
	0x0F120000,
	0x002A0640,
	0x0F121A0A,
	0x0F120000,
	0x002A0644,
	0x0F126810,
	0x0F120000,
	0x002A0648,
	0x0F126810,
	0x0F120000,
	0x002A064C,
	0x0F12D020,
	0x0F120000,
	0x002A0650,
	0x0F120428,
	0x0F120001,
	0x002A0654,
	0x0F121A80,
	0x0F120006,
	0x002A0658,
	0x0F121A80,
	0x0F120006,
	0x002A065C,
	0x0F121A80,
	0x0F120006,

	0x002A03B4,
	0x0F122710,
	0x0F122710,

	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
	0x002A0270,
	0x0F120001,
	0x002A023E,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Text[] = {
	0x002A0A28,
	0x0F12A060,
	0x002A0ADE,
	0x0F12A060,
	0x002A0B94,
	0x0F12A060,
	0x002A0C4A,
	0x0F12A060,
	0x002A0D00,
	0x0F12A060,
};

static const u32 s5k4ecgx_Scene_Candle_Light[] = {
	0x002A04E6,
	0x0F120777,
	0x002A04BA,
	0x0F1205E0,
	0x0F120001,
	0x0F120400,
	0x0F120001,
	0x0F120530,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Night_Capture[] = {
	0x002A0608,
	0x0F120000,	/*#lt_ExpGain_uSubsamplingmode*/
	0x0F120000,	/*#lt_ExpGain_uNonSubsampling*/
};

static const u32 s5k4ecgx_AF_Return_Inf_pos[] = {
	0x002A15D6,
	0x0F12D000,
};

static const u32 s5k4ecgx_AF_Return_Macro_pos[] = {
	0x002A15E8,
	0x0F120018,
	0x0F12002A,
	0x0F120030,
	0x0F120036,
	0x0F12003C,
	0x0F120042,
	0x0F120048,
	0x0F12004E,
	0x0F120054,
	0x0F12005A,
	0x0F120060,
	0x0F120066,
	0x0F12006C,
	0x0F120072,
	0x0F120078,
	0x0F12007E,
	0x0F120084,
	0x0F12008A,
	0x0F120090,
	0x0F120096,
	0x0F12009C,
	0x0F1200A2,
	0x0F1200A8,
	0x0F1200AE,
	0x0F1200B4,
	0x0F1200BA,
};

static const u32 s5k4ecgx_AF_Normal_mode_1[] = {
	0x002A028E,
	0x0F120000,
};

static const u32 s5k4ecgx_AF_Normal_mode_2[] = {
	0x002A028C,
	0x0F120004,
};

static const u32 s5k4ecgx_AF_Normal_mode_3[] = {
	0x002A1648,
	0x0F129002,
};

static const u32 s5k4ecgx_AF_Macro_mode_1[] = {
	0x002A028E,
	0x0F1200D0,
};

static const u32 s5k4ecgx_AF_Macro_mode_2[] = {
	0x002A028C,
	0x0F120004,
};

static const u32 s5k4ecgx_AF_Macro_mode_3[] = {
	0x002A1648,
	0x0F129042,
	0x002A15DA,
	0x0F121800,
};

static const u32 s5k4ecgx_AF_Low_Light_Mode_On[] = {
	0x002A15DA,
	0x0F120C00,

	0x002A15E8,
	0x0F12000C,
	0x0F12002A,
	0x0F120033,
	0x0F12003C,
	0x0F120045,
	0x0F12004E,
	0x0F120057,
	0x0F120063,
	0x0F12006F,
	0x0F12007B,
	0x0F120087,
	0x0F120093,
	0x0F1200A2,
	0x0F1200B1,
};

static const u32 s5k4ecgx_AF_Low_Light_Mode_Off[] = {
	0x002A15DA,
	0x0F121800,

	0x002A15E8,
	0x0F120018,
	0x0F12002A,
	0x0F120030,
	0x0F120036,
	0x0F12003C,
	0x0F120042,
	0x0F120048,
	0x0F12004E,
	0x0F120054,
	0x0F12005A,
	0x0F120060,
	0x0F120066,
	0x0F12006C,
	0x0F120072,
	0x0F120078,
	0x0F12007E,
	0x0F120084,
	0x0F12008A,
	0x0F120090,
	0x0F120096,
	0x0F12009C,
	0x0F1200A2,
	0x0F1200A8,
	0x0F1200AE,
	0x0F1200B4,
	0x0F1200BA,
};

static const u32 s5k4ecgx_Single_AF_Start[] = {
	0x002A028C,
	0x0F120005,
};

static const u32 s5k4ecgx_Single_AF_Off_1[] = {
	0x002A028E,
	0x0F120000,
};

static const u32 s5k4ecgx_Single_AF_Off_2[] = {
	0x002A028C,
	0x0F120004,
};

static const u32 s5k4ecgx_Single_AF_Off_3[] = {

};


static const u32 s5k4ecgx_Face_Detection_On[] = {
	0x002A0294,
	0x0F120100,
	0x0F1200E3,
	0x0F120200,
	0x0F120238,
	0x0F1201C6,
	0x0F120166,
	0x0F120074,
	0x0F120132,
	0x0F120001,
};

static const u32 s5k4ecgx_Face_Detection_Off[] = {
	0x002A0294,
	0x0F120100,
	0x0F1200E3,
	0x0F120200,
	0x0F120238,
	0x0F1201C6,
	0x0F120166,
	0x0F120074,
	0x0F120132,
	0x0F120001,
};

static const u32 s5k4ecgx_Low_Cap_On[] = {
	0x002A06B8,
	0x0F12FFFF,
	0x0F1200FF, /*#lt_uMaxLei*/

	0x002A0A1C,
	0x0F12008A, /*#Gamma linearity*/

	0x002A0608,
	0x0F120001,	/*#lt_ExpGain_uSubsamplingmode*/
	0x0F120001,	/*#lt_ExpGain_uNonSubsampling*/
	0x0F120900,	/*#lt_ExpGain_ExpCurveGainMaxStr*/

	0x002A0938,
	0x0F120001,
	0x0F120012,	/*#SARR_uNormBrInDoor_0_*/
	0x0F120022,	/*#SARR_uNormBrInDoor_1_*/
	0x0F120384,	/*#SARR_uNormBrInDoor_2_*/
	0x0F1207D0,	/*#SARR_uNormBrInDoor_3_*/
	0x0F121388,	/*#SARR_uNormBrInDoor_4_*/
};

static const u32 s5k4ecgx_Low_Cap_Off[] = {
	0x002A06B8,
	0x0F12452C,
	0x0F120004,	/*#lt_uMaxLei*/

	0x002A0A1C,
	0x0F120080, /*#Gamma linearity*/


	0x002A0608,
	0x0F120001,	/*#lt_ExpGain_uSubsamplingmode*/
	0x0F120001,	/*#lt_ExpGain_uNonSubsampling*/
	0x0F120800,	/*#lt_ExpGain_ExpCurveGainMaxStr*/

	0x002A0938,
	0x0F120000,
	0x0F120014,	/*#SARR_uNormBrInDoor_0_*/
	0x0F1200D2,	/*#SARR_uNormBrInDoor_1_*/
	0x0F120384,	/*#SARR_uNormBrInDoor_2_*/
	0x0F1207D0,	/*#SARR_uNormBrInDoor_3_*/
	0x0F121388,	/*#SARR_uNormBrInDoor_4_*/
};

/* restores crop settings to full resolution */
static const u32 s5k4ecgx_Reset_Crop[] = {
	0x002A0250,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x002A0494,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,

	0x002A0262,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Capture_Start[] = {
	0x002A0A1E,
	0x0F120050,

	0x002A0AD4,
	0x0F120074,

	0x002A0242,
	0x0F120001,

	0x002A024E,
	0x0F120001,

	0x002A0244,
	0x0F120001,
};

static const u32 s5k4ecgx_Preview_Return[] = {
	0x002A0A1E,
	0x0F120028,

	0x002A0AD4,
	0x0F12003C,

	0x002A05D0,
	0x0F120000,

	0x002A0972,
	0x0F120000,

	0x002A0242,
	0x0F120000,

	0x002A024E,
	0x0F120001,

	0x002A0244,
	0x0F120001,
};

static const u32 s5k4ecgx_Flash_init[] = {
	0x002A0484,
	0x0F120002,	/* capture flash on */

	0x002A183A,
	0x0F120001,	/* one frame AE*/

	0x002A17F6,
	0x0F120258,	/* AWB R point */
	0x0F120228,	/* AWB B point */

	0x002A1840,
	0x0F120001,	/* Fls AE tune start */

	0x0F120100,	/* fls_afl_FlsAFIn  Rin */
	0x0F120120,
	0x0F120180,
	0x0F120200,
	0x0F120400,
	0x0F120800,
	0x0F120A00,
	0x0F121000,

	0x0F120100,	/* fls_afl_FlsAFOut  Rout */
	0x0F1200A0,
	0x0F120090,
	0x0F120080,
	0x0F120070,
	0x0F120045,
	0x0F120030,
	0x0F120010,

	0x002A1884,
	0x0F120100,	/* fls_afl_FlsNBOut  flash NB default */
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,

	0x002A1826,

	0x0F120100,	/* fls_afl_FlashWP_Weight  flash NB default */
	0x0F1200C0,
	0x0F120080,
	0x0F12000A,
	0x0F120000,

	0x0F120030,	/* fls_afl_FlashWP_Weight  flash NB default */
	0x0F120040,
	0x0F120048,
	0x0F120050,
	0x0F120060,

	0x002A4784,
	0x0F1200A0,	/* TNP_Regs_FlsWeightRIn  weight tune start in*/
	0x0F1200C0,
	0x0F1200D0,
	0x0F120100,
	0x0F120200,
	0x0F120300,

	0x0F120088,	/* TNP_Regs_FlsWeightROut  weight tune start out*/
	0x0F1200B0,
	0x0F1200C0,
	0x0F120100,
	0x0F120200,
	0x0F120300,

	0x002A479C,

	0x0F120120,	/*Fls  BRIn  */
	0x0F120150,
	0x0F120200,

	0x0F12003C,	/* Fls  BROut*/
	0x0F12003B,
	0x0F120030,

};

static const u32 s5k4ecgx_Pre_Flash_Start[] = {
	0x002A0588, /* set AE speed to fast */
	0x0F120000,

	0x002A17FC, /* fls_afl_FlashWP_Weight_0_  Pre_Flash_Start */
	0x0F120001,
};

static const u32 s5k4ecgx_Pre_Flash_End[] = {
	0x002A0588, /* set AE speed to normal */
	0x0F120002,

	0x002A1800, /* fls_afl_FlashWP_Weight_0_  Pre_Flash_end */
	0x0F120001,
};

static const u32 s5k4ecgx_Flash_Start[] = {
	0x002A17E8,	/* fls_afl_FlashMode : Flash alg start */
	0x0F120001,

	0x002A180C,	/* fls_afl_FlashWP_Weight_4_  flash br avg */
	0x0F120027,
};

static const u32 s5k4ecgx_Flash_End[] = {
	0x002A17E8,	/* fls_afl_FlashMode  Flash alg end */
	0x0F120000,
};

/* 2560 x 1920 */
static const u32 s5k4ecgx_5M_Capture[] = {
	0x002A0398,
	0x0F120A00,
	0x0F120780,
	0x0F120009,

	0x002A03B2,
	0x0F120002,
	0x002A03B0,
	0x0F120002,
	0x002A0270,
	0x0F120001,
};
/* 2048 x 1536 */
static const u32 s5k4ecgx_3M_Capture[] = {
	0x002A0398,
	0x0F120800,  /* REG_0TC_CCFG_usWidth */
	0x0F120600,  /* REG_0TC_CCFG_usWidth */
	0x0F120009,  /* REG_0TC_CCFG_Format */

	0x002A03B2,
	0x0F120002,  /* REG_0TC_CCFG_FrRateQualityType */
	0x002A03B0,
	0x0F120002,  /* REG_0TC_CCFG_usFrTimeType */
	0x002A024E,
	0x0F120001,  /* REG_TC_GP_NewConfigSync */
	0x002A0270,
	0x0F120001,  /* REG_TC_GP_CapConfigChanged */
};
/* 1600 x 1200 */
static const u32 s5k4ecgx_2M_Capture[] = {
	0x002A0398,
	0x0F120640,
	0x0F1204B0,
	0x0F120009,
	0x002A03B2,
	0x0F120002,
	0x002A03B0,
	0x0F120002,
	0x002A024E,
	0x0F120001,
	0x002A0270,
	0x0F120001,
};
/* 1280 x 960 */
static const u32 s5k4ecgx_1M_Capture[] = {
	0x002A0398,
	0x0F120500,
	0x0F1203C0,
	0x0F120009,
	0x002A03B2,
	0x0F120002,
	0x002A03B0,
	0x0F120002,
	0x002A024E,
	0x0F120001,
	0x002A0270,
	0x0F120001,
};
/* 640 x 480 */
static const u32 s5k4ecgx_VGA_Capture[] = {
	0x002A0398,
	0x0F120280,
	0x0F1201E0,
	0x0F120009,
	0x002A03B2,
	0x0F120002,
	0x002A03B0,
	0x0F120002,
	0x002A024E,
	0x0F120001,
	0x002A0270,
	0x0F120001,
};
/* 720 x 480 */
static const u32 s5k4ecgx_720_Preview[] = {
	0x002A0250,
	0x0F120A00,
	0x0F1206A8,
	0x0F120010,
	0x0F120078,
	0x0F120A00,
	0x0F1206A8,
	0x0F120010,
	0x0F120078,
	0x002A0494,
	0x0F120A00,
	0x0F1206A8,
	0x0F120000,
	0x0F120000,
	0x0F120A00,
	0x0F1206A8,
	0x0F120000,
	0x0F120000,

	0x002A0262,
	0x0F120001,
	0x0F120001,

	0x002A0A1E,
	0x0F120028,
	0x002A0AD4,
	0x0F12003C,

	0x002A02A6,
	0x0F1202D0,
	0x0F1201E0,
	0x0F120005,
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};
/* 640 x 480 */
static const u32 s5k4ecgx_640_Preview[] = {
	0x002A0250,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x002A0494,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,

	0x002A0262,
	0x0F120001,
	0x0F120001,

	0x002A0A1E,
	0x0F120028,
	0x002A0AD4,
	0x0F12003C,

	0x002A02A6,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014A, /* Flicker */
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};
/* 352 x 288 */
static const u32 s5k4ecgx_352_Preview[] = {
	0x002A0250,
	0x0F120928,
	0x0F120780,
	0x0F12007C,
	0x0F12000C,
	0x0F120928,
	0x0F120780,
	0x0F12007C,
	0x0F12000C,
	0x002A0494,
	0x0F120928,
	0x0F120780,
	0x0F120000,
	0x0F120000,
	0x0F120928,
	0x0F120780,
	0x0F120000,
	0x0F120000,

	0x002A0262,
	0x0F120001,
	0x0F120001,

	0x002A0A1E,
	0x0F120028,
	0x002A0AD4,
	0x0F12003C,

	0x002A02A6,
	0x0F120160,
	0x0F120120,
	0x0F120005,
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};
/* 176 x 144 */
static const u32 s5k4ecgx_176_Preview[] = {
	0x002A0250,
	0x0F120928,
	0x0F120780,
	0x0F12007C,
	0x0F12000C,
	0x0F120928,
	0x0F120780,
	0x0F12007C,
	0x0F12000C,
	0x002A0494,
	0x0F120928,
	0x0F120780,
	0x0F120000,
	0x0F120000,
	0x0F120928,
	0x0F120780,
	0x0F120000,
	0x0F120000,

	0x002A0262,
	0x0F120001,
	0x0F120001,

	0x002A0A1E,
	0x0F120028,
	0x002A0AD4,
	0x0F12003C,

	0x002A02A6,
	0x0F1200B0,
	0x0F120090,
	0x0F120005,
	0x002A02B4,
	0x0F120052,
	0x002A02BE,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,
	0x002A02D0,
	0x0F120000,
	0x0F120000,
	0x002A0266,
	0x0F120000,
	0x002A026A,
	0x0F120001,
	0x002A024E,
	0x0F120001,
	0x002A0268,
	0x0F120001,
};

static const u32 s5k4ecgx_AE_AWB_Lock_On[] = {
	0x002A2C5E,
	0x0F120000,
};

static const u32 s5k4ecgx_AE_AWB_Lock_Off[] = {
	0x002A2C5E,
	0x0F120001,
};

static const u32 s5k4ecgx_Get_AE_Stable_Status[] = {
	0x002E2C74,
};

static const u32 s5k4ecgx_Get_Light_Level[] = {
	0x002C7000,
	0x002E2C18,
};

static const u32 s5k4ecgx_get_1st_af_search_status[] = {
	0x002E2EEE,
};

static const u32 s5k4ecgx_get_2nd_af_search_status[] = {
	0x002E2207,
};

static const u32 s5k4ecgx_get_capture_status[] = {
	0x002E0530,
};

static const u32 s5k4ecgx_get_esd_status[] = {
	0xFCFCD000,
	0x002CD000,
	0x002E0060,
};

static const u32 s5k4ecgx_get_iso_reg[] = {
	0x002C7000,
	0x002E2BC4,
};

static const u32 s5k4ecgx_get_shutterspeed_reg[] = {
	0x002C7000,
	0x002E2BC0,
};

#endif /* __S5K4ECGX_REGS_1_0_H__ */
