/* drivers/media/video/s5k4ecgx_regs_1_0.h
 *
 * Driver for s5k4ecgx (5MP Camera) from SEC(LSI), firmware EVT1.0
 *
 * Copyright (C) 2010, SAMSUNG ELECTRONICS
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */


#ifndef __S5K4ECGX_REGS_1_0_H__
#define __S5K4ECGX_REGS_1_0_H__

/* ARM initialization */
static const u32 s5k4ecgx_init_reg1_v1[] = {
	/* direct addressing, hw addresses */
	0xFCFCD000,
	0x00040000,
	0xFCFCD000,
	0x00100001,
	0xFCFCD000,
	0x10300000,
	0x00140001,
};

static const u32 s5k4ecgx_init_reg2_v1[] = {
	/* start analog settings, indirect addressing mode */
	0x0028D000,

	0x002A007A,
	0x0F120000,

	0x002AE406,
	0x0F120092,

	0x002AE410,
	0x0F123804,

	0x002AE420,
	0x0F120003,
	0x0F120060,

	0x002AE42E,
	0x0F120004,

	0x002AF400,
	0x0F125A3C,
	0x0F120023,
	0x0F128080,
	0x0F1203AF,
	0x0F12000A,
	0x0F12AA54,
	0x0F120040,
	0x0F12464E,
	0x0F120240,
	0x0F120240,
	0x0F120040,
	0x0F121000,
	0x0F125558,
	0x0F12D000,
	0x0F120010,
	0x0F120202,
	0x0F120401,
	0x0F120022,
	0x0F120088,
	0x0F12009F,
	0x0F120000,
	0x0F121800,
	0x0F120088,
	0x0F120000,
	0x0F122428,
	0x0F120000,
	0x0F1203EE,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002AF480,
	0x0F120004,
	0x0F1205B6,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F120007,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F12024E,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F1205B6,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F12024F,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120075,
	0x0F1200CF,
	0x0F120000,
	0x0F120000,
	0x0F120075,
	0x0F1200D6,
	0x0F120000,
	0x0F120000,
	0x0F120004,
	0x0F1201F4,
	0x0F120000,
	0x0F120000,
	0x0F1200F0,
	0x0F1201F4,
	0x0F12029E,
	0x0F1205B2,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1201F8,
	0x0F120228,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120208,
	0x0F120238,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002AF590,
	0x0F120000,

	0x002AF500,
	0x0F120218,
	0x0F120238,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F120009,
	0x0F1200DE,
	0x0F1205C0,
	0x0F120000,
	0x0F120000,
	0x0F1200DF,
	0x0F1200E4,
	0x0F1201F8,
	0x0F1201FD,
	0x0F1205B6,
	0x0F1205BB,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1201F8,
	0x0F120000,
	0x0F120000,
	0x0F120077,
	0x0F12007E,
	0x0F12024F,
	0x0F12025E,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120708,
	0x0F12080C,

	0x002A1082,
	0x0F125555,
	0x0F125555,

	0x002A1088,
	0x0F12055D,

	0x002A100E,
	0x0F120000,

	/* switch to sw address bank */
	0x00287000,

	0x002A0716,
	0x0F120100,

	/* Start of Patch Data for firmware */
	0x002A3A10,
	0x0F12B5F8,
	0x0F124A3E,
	0x0F12493E,
	0x0F12483F,
	0x0F12C004,
	0x0F126001,
	0x0F124C3E,
	0x0F122500,
	0x0F128265,
	0x0F128025,
	0x0F12493D,
	0x0F12483E,
	0x0F122701,
	0x0F12002A,
	0x0F12F000,
	0x0F12FC38,
	0x0F12493C,
	0x0F12483D,
	0x0F122602,
	0x0F12003A,
	0x0F12F000,
	0x0F12FC32,
	0x0F12493B,
	0x0F12483C,
	0x0F120032,
	0x0F122703,
	0x0F12F000,
	0x0F12FC2C,
	0x0F128225,
	0x0F12493A,
	0x0F12483A,
	0x0F122604,
	0x0F12003A,
	0x0F12F000,
	0x0F12FC25,
	0x0F12200E,
	0x0F128420,
	0x0F122701,
	0x0F1283E7,
	0x0F124937,
	0x0F124837,
	0x0F120032,
	0x0F122405,
	0x0F12F000,
	0x0F12FC1B,
	0x0F124936,
	0x0F124836,
	0x0F122606,
	0x0F120022,
	0x0F12F000,
	0x0F12FC15,
	0x0F124C28,
	0x0F123460,
	0x0F1281E7,
	0x0F124825,
	0x0F123824,
	0x0F1286C5,
	0x0F124932,
	0x0F124832,
	0x0F120032,
	0x0F122707,
	0x0F12F000,
	0x0F12FC09,
	0x0F124931,
	0x0F124831,
	0x0F122608,
	0x0F12003A,
	0x0F12F000,
	0x0F12FC03,
	0x0F124930,
	0x0F124830,
	0x0F120032,
	0x0F122709,
	0x0F12F000,
	0x0F12FBFD,
	0x0F122005,
	0x0F128160,
	0x0F12492E,
	0x0F12482E,
	0x0F126281,
	0x0F128225,
	0x0F128265,
	0x0F12482D,
	0x0F128320,
	0x0F12482D,
	0x0F128360,
	0x0F120270,
	0x0F1283A0,
	0x0F122005,
	0x0F120300,
	0x0F1283E0,
	0x0F124828,
	0x0F12492A,
	0x0F123840,
	0x0F126001,
	0x0F12492A,
	0x0F12482A,
	0x0F12240A,
	0x0F12003A,
	0x0F12F000,
	0x0F12FBE3,
	0x0F124929,
	0x0F124829,
	0x0F120022,
	0x0F12250B,
	0x0F12F000,
	0x0F12FBDD,
	0x0F124820,
	0x0F124927,
	0x0F123080,
	0x0F126381,
	0x0F124927,
	0x0F124827,
	0x0F12240C,
	0x0F12002A,
	0x0F12F000,
	0x0F12FBD3,
	0x0F124926,
	0x0F124826,
	0x0F120022,
	0x0F12F000,
	0x0F12FBCE,
	0x0F12BCF8,
	0x0F12BC08,
	0x0F124718,
	0x0F120000,
	0x0F120174,
	0x0F124EC1,
	0x0F12FFFE,
	0x0F120000,
	0x0F121EF0,
	0x0F127000,
	0x0F124780,
	0x0F127000,
	0x0F123BF3,
	0x0F127000,
	0x0F12A1D9,
	0x0F120000,
	0x0F123B9D,
	0x0F127000,
	0x0F12A0BD,
	0x0F120000,
	0x0F123C8D,
	0x0F127000,
	0x0F12217B,
	0x0F120000,
	0x0F123CE9,
	0x0F127000,
	0x0F12E0DF,
	0x0F120000,
	0x0F123E73,
	0x0F127000,
	0x0F12053B,
	0x0F120000,
	0x0F123D71,
	0x0F127000,
	0x0F12509B,
	0x0F120000,
	0x0F123FF9,
	0x0F127000,
	0x0F12D42F,
	0x0F120000,
	0x0F123EB5,
	0x0F127000,
	0x0F1249D1,
	0x0F120000,
	0x0F123F4F,
	0x0F127000,
	0x0F121E57,
	0x0F120000,
	0x0F124033,
	0x0F127000,
	0x0F1200C0,
	0x0F127000,
	0x0F124E34,
	0x0F120000,
	0x0F127C53,
	0x0F120000,
	0x0F1240BF,
	0x0F127000,
	0x0F1240FB,
	0x0F127000,
	0x0F12F5D7,
	0x0F120000,
	0x0F12406F,
	0x0F127000,
	0x0F12BAB1,
	0x0F120000,
	0x0F124187,
	0x0F127000,
	0x0F124129,
	0x0F127000,
	0x0F12C10D,
	0x0F120000,
	0x0F124203,
	0x0F127000,
	0x0F12B231,
	0x0F120000,
	0x0F12B570,
	0x0F12000C,
	0x0F126820,
	0x0F126865,
	0x0F12F000,
	0x0F12FB84,
	0x0F124BFC,
	0x0F120402,
	0x0F120C12,
	0x0F12819A,
	0x0F1248FB,
	0x0F1289C1,
	0x0F12428A,
	0x0F12D305,
	0x0F124AFA,
	0x0F128986,
	0x0F128852,
	0x0F1242B2,
	0x0F12D300,
	0x0F128199,
	0x0F128801,
	0x0F122900,
	0x0F12D008,
	0x0F1249F7,
	0x0F12002B,
	0x0F126E0A,
	0x0F122105,
	0x0F121C80,
	0x0F12F000,
	0x0F12FB74,
	0x0F126020,
	0x0F12E006,
	0x0F12899A,
	0x0F1248F3,
	0x0F12002B,
	0x0F122105,
	0x0F12F000,
	0x0F12FB6C,
	0x0F126020,
	0x0F126820,
	0x0F12BC70,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F8,
	0x0F120004,
	0x0F122000,
	0x0F129000,
	0x0F120020,
	0x0F122501,
	0x0F123810,
	0x0F122601,
	0x0F1240A5,
	0x0F124086,
	0x0F124FEA,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F1243A8,
	0x0F128038,
	0x0F12E002,
	0x0F128878,
	0x0F1243B0,
	0x0F128078,
	0x0F12F000,
	0x0F12FB59,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F124328,
	0x0F128038,
	0x0F12E002,
	0x0F128878,
	0x0F124330,
	0x0F128078,
	0x0F1248DA,
	0x0F122105,
	0x0F128982,
	0x0F1248DD,
	0x0F12466B,
	0x0F12F000,
	0x0F12FB41,
	0x0F121C41,
	0x0F124CD7,
	0x0F120049,
	0x0F120040,
	0x0F121909,
	0x0F121900,
	0x0F12466B,
	0x0F128A89,
	0x0F128A80,
	0x0F12881A,
	0x0F12F000,
	0x0F12FB45,
	0x0F128A61,
	0x0F120540,
	0x0F1202C9,
	0x0F120D40,
	0x0F124301,
	0x0F1248D4,
	0x0F128081,
	0x0F1249D4,
	0x0F1248D4,
	0x0F123120,
	0x0F128BC0,
	0x0F128809,
	0x0F121841,
	0x0F120020,
	0x0F123060,
	0x0F128A82,
	0x0F124291,
	0x0F12D205,
	0x0F128AC0,
	0x0F1249CF,
	0x0F127388,
	0x0F122001,
	0x0F1231A0,
	0x0F1270C8,
	0x0F12BCF8,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F8,
	0x0F1248C6,
	0x0F122200,
	0x0F1230A0,
	0x0F1281C2,
	0x0F126808,
	0x0F124669,
	0x0F12F000,
	0x0F12FB29,
	0x0F12466B,
	0x0F128818,
	0x0F12F000,
	0x0F12FB2D,
	0x0F120005,
	0x0F12466B,
	0x0F128858,
	0x0F12F000,
	0x0F12FB30,
	0x0F120004,
	0x0F122101,
	0x0F121928,
	0x0F1202C9,
	0x0F121A08,
	0x0F120286,
	0x0F120029,
	0x0F120030,
	0x0F12F000,
	0x0F12FB2E,
	0x0F120005,
	0x0F122701,
	0x0F1202BF,
	0x0F120021,
	0x0F120030,
	0x0F12F000,
	0x0F12FB27,
	0x0F1249B5,
	0x0F124AB8,
	0x0F123140,
	0x0F123220,
	0x0F12808D,
	0x0F128295,
	0x0F1280CF,
	0x0F1282D7,
	0x0F128108,
	0x0F128310,
	0x0F12E7CE,
	0x0F126808,
	0x0F120400,
	0x0F120C00,
	0x0F126849,
	0x0F120409,
	0x0F120C09,
	0x0F124AAA,
	0x0F128A12,
	0x0F122A00,
	0x0F12D00D,
	0x0F122300,
	0x0F121A89,
	0x0F12D400,
	0x0F12000B,
	0x0F120419,
	0x0F120C09,
	0x0F1223FF,
	0x0F1233C1,
	0x0F121810,
	0x0F124298,
	0x0F12D800,
	0x0F120003,
	0x0F120418,
	0x0F120C00,
	0x0F124AA9,
	0x0F128150,
	0x0F128191,
	0x0F124770,
	0x0F12B5F8,
	0x0F122400,
	0x0F124DA7,
	0x0F124F9E,
	0x0F1248A7,
	0x0F128C39,
	0x0F128041,
	0x0F122101,
	0x0F128001,
	0x0F12F000,
	0x0F12FAFB,
	0x0F1248A5,
	0x0F128BC0,
	0x0F12F000,
	0x0F12FAFF,
	0x0F12260D,
	0x0F120736,
	0x0F122000,
	0x0F1200E1,
	0x0F1219CA,
	0x0F120041,
	0x0F12194B,
	0x0F12199B,
	0x0F12881B,
	0x0F121851,
	0x0F12844B,
	0x0F121C40,
	0x0F120400,
	0x0F120C00,
	0x0F122804,
	0x0F12D3F4,
	0x0F123508,
	0x0F12042D,
	0x0F120C2D,
	0x0F121C64,
	0x0F120424,
	0x0F120C24,
	0x0F122C07,
	0x0F12D3E9,
	0x0F12E78A,
	0x0F12B5F0,
	0x0F12B087,
	0x0F126808,
	0x0F129006,
	0x0F126848,
	0x0F120405,
	0x0F120C2D,
	0x0F126888,
	0x0F120403,
	0x0F120C1B,
	0x0F124892,
	0x0F128B80,
	0x0F122800,
	0x0F12D100,
	0x0F122300,
	0x0F12001C,
	0x0F124A90,
	0x0F12466E,
	0x0F121E91,
	0x0F121E88,
	0x0F12C607,
	0x0F12498F,
	0x0F120023,
	0x0F122207,
	0x0F120028,
	0x0F12F000,
	0x0F12FAD3,
	0x0F12487E,
	0x0F128BC1,
	0x0F122900,
	0x0F12D030,
	0x0F122100,
	0x0F124888,
	0x0F124A7B,
	0x0F12380A,
	0x0F1288C0,
	0x0F1200C3,
	0x0F12189A,
	0x0F124696,
	0x0F124A86,
	0x0F121C40,
	0x0F12189B,
	0x0F12469C,
	0x0F124B76,
	0x0F1200C0,
	0x0F1218C6,
	0x0F121887,
	0x0F120048,
	0x0F124672,
	0x0F124663,
	0x0F121812,
	0x0F12181B,
	0x0F128C52,
	0x0F128EDB,
	0x0F12435A,
	0x0F120092,
	0x0F120C15,
	0x0F124A6F,
	0x0F121882,
	0x0F12235A,
	0x0F12529D,
	0x0F121833,
	0x0F121838,
	0x0F128C5B,
	0x0F128EC0,
	0x0F124343,
	0x0F120098,
	0x0F120C00,
	0x0F123260,
	0x0F128050,
	0x0F121C49,
	0x0F120409,
	0x0F120C09,
	0x0F122904,
	0x0F12D3E3,
	0x0F124A66,
	0x0F12325A,
	0x0F120013,
	0x0F123308,
	0x0F12E00A,
	0x0F124870,
	0x0F124971,
	0x0F12380A,
	0x0F1288C0,
	0x0F1200C2,
	0x0F121852,
	0x0F123236,
	0x0F121C40,
	0x0F1200C0,
	0x0F121843,
	0x0F123336,
	0x0F122100,
	0x0F124864,
	0x0F123020,
	0x0F124684,
	0x0F124E69,
	0x0F120048,
	0x0F123E0A,
	0x0F128937,
	0x0F125A15,
	0x0F128976,
	0x0F12437D,
	0x0F125A1F,
	0x0F124377,
	0x0F124E65,
	0x0F1219ED,
	0x0F121986,
	0x0F123660,
	0x0F1289F6,
	0x0F124366,
	0x0F1219AD,
	0x0F12022D,
	0x0F120C2D,
	0x0F12AE04,
	0x0F125235,
	0x0F124666,
	0x0F127C76,
	0x0F124375,
	0x0F129E06,
	0x0F12026D,
	0x0F120C2D,
	0x0F125235,
	0x0F121C49,
	0x0F122904,
	0x0F12D3E1,
	0x0F12B007,
	0x0F12BCF0,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F8,
	0x0F120004,
	0x0F12F7FF,
	0x0F12FF53,
	0x0F122101,
	0x0F12000D,
	0x0F120020,
	0x0F123810,
	0x0F124081,
	0x0F1240A5,
	0x0F124F4A,
	0x0F12000E,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F1243A8,
	0x0F128038,
	0x0F12E002,
	0x0F128878,
	0x0F1243B0,
	0x0F128078,
	0x0F12F000,
	0x0F12FA5E,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F124328,
	0x0F128038,
	0x0F12E6EC,
	0x0F128878,
	0x0F124330,
	0x0F128078,
	0x0F12E6E8,
	0x0F12B5F8,
	0x0F120004,
	0x0F124F48,
	0x0F124949,
	0x0F1278FA,
	0x0F122001,
	0x0F122A00,
	0x0F12D102,
	0x0F122000,
	0x0F1286C8,
	0x0F12E003,
	0x0F127AFA,
	0x0F122A00,
	0x0F12D000,
	0x0F1286C8,
	0x0F122101,
	0x0F12000D,
	0x0F120020,
	0x0F123810,
	0x0F124081,
	0x0F1240A5,
	0x0F12000E,
	0x0F122C10,
	0x0F12DA04,
	0x0F124932,
	0x0F128808,
	0x0F1243A8,
	0x0F128008,
	0x0F12E003,
	0x0F124930,
	0x0F128848,
	0x0F1243B0,
	0x0F128048,
	0x0F12F000,
	0x0F12FA39,
	0x0F122C10,
	0x0F12DA04,
	0x0F12482C,
	0x0F128801,
	0x0F124329,
	0x0F128001,
	0x0F12E003,
	0x0F124829,
	0x0F128841,
	0x0F124331,
	0x0F128041,
	0x0F124934,
	0x0F128B08,
	0x0F1206C2,
	0x0F12D50A,
	0x0F127ABA,
	0x0F120652,
	0x0F12D507,
	0x0F122210,
	0x0F124390,
	0x0F128308,
	0x0F124830,
	0x0F127AF9,
	0x0F126B00,
	0x0F12F000,
	0x0F12FA27,
	0x0F12481C,
	0x0F123060,
	0x0F1289C0,
	0x0F122800,
	0x0F12D009,
	0x0F1278F8,
	0x0F122800,
	0x0F12D006,
	0x0F127AF8,
	0x0F122800,
	0x0F12D003,
	0x0F127AB8,
	0x0F122140,
	0x0F124308,
	0x0F1272B8,
	0x0F12E69B,
	0x0F12B5F8,
	0x0F120004,
	0x0F124826,
	0x0F128981,
	0x0F122900,
	0x0F12D007,
	0x0F128940,
	0x0F122800,
	0x0F12D104,
	0x0F12481E,
	0x0F1222BF,
	0x0F127A81,
	0x0F124011,
	0x0F127281,
	0x0F122101,
	0x0F12000D,
	0x0F120020,
	0x0F123810,
	0x0F124081,
	0x0F1240A5,
	0x0F124F0E,
	0x0F12000E,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F1243A8,
	0x0F128038,
	0x0F12E002,
	0x0F128878,
	0x0F1243B0,
	0x0F128078,
	0x0F12F000,
	0x0F12F9FE,
	0x0F122C10,
	0x0F12DA2D,
	0x0F128838,
	0x0F124328,
	0x0F128038,
	0x0F12E674,
	0x0F1221C0,
	0x0F127000,
	0x0F124780,
	0x0F127000,
	0x0F122D00,
	0x0F127000,
	0x0F122AD0,
	0x0F127000,
	0x0F120924,
	0x0F127000,
	0x0F121100,
	0x0F12D000,
	0x0F12E300,
	0x0F12D000,
	0x0F1229D0,
	0x0F127000,
	0x0F122C30,
	0x0F127000,
	0x0F125000,
	0x0F12D000,
	0x0F12A006,
	0x0F120000,
	0x0F12A000,
	0x0F12D000,
	0x0F1206F8,
	0x0F127000,
	0x0F120888,
	0x0F127000,
	0x0F1221DA,
	0x0F127000,
	0x0F1208AC,
	0x0F127000,
	0x0F1220BC,
	0x0F127000,
	0x0F121ECC,
	0x0F127000,
	0x0F122FA4,
	0x0F127000,
	0x0F12235C,
	0x0F127000,
	0x0F120234,
	0x0F127000,
	0x0F128878,
	0x0F124330,
	0x0F128078,
	0x0F12E646,
	0x0F12B570,
	0x0F124D99,
	0x0F124C99,
	0x0F128B28,
	0x0F120701,
	0x0F12D507,
	0x0F122108,
	0x0F124388,
	0x0F128328,
	0x0F124997,
	0x0F126B20,
	0x0F1268C9,
	0x0F12F000,
	0x0F12F9C4,
	0x0F128B28,
	0x0F1206C1,
	0x0F12D50A,
	0x0F124994,
	0x0F127A8A,
	0x0F120652,
	0x0F12D406,
	0x0F122210,
	0x0F124390,
	0x0F128328,
	0x0F127AC9,
	0x0F126B20,
	0x0F12F000,
	0x0F12F9A6,
	0x0F12E5DC,
	0x0F12B570,
	0x0F124D8E,
	0x0F124C8F,
	0x0F1288EA,
	0x0F122A14,
	0x0F12D101,
	0x0F122200,
	0x0F1281A2,
	0x0F12F000,
	0x0F12F9B3,
	0x0F1288E8,
	0x0F122821,
	0x0F12D10F,
	0x0F128B28,
	0x0F122800,
	0x0F12D10C,
	0x0F12200C,
	0x0F125E20,
	0x0F128961,
	0x0F124288,
	0x0F12DC07,
	0x0F124882,
	0x0F123880,
	0x0F126B80,
	0x0F12F000,
	0x0F12F9AB,
	0x0F1289A0,
	0x0F121C40,
	0x0F1281A0,
	0x0F12E5BE,
	0x0F12B5F8,
	0x0F120004,
	0x0F122101,
	0x0F12000D,
	0x0F120020,
	0x0F123810,
	0x0F124081,
	0x0F1240A5,
	0x0F124F7E,
	0x0F12000E,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F1243A8,
	0x0F128038,
	0x0F12E002,
	0x0F128878,
	0x0F1243B0,
	0x0F128078,
	0x0F12F000,
	0x0F12F99A,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F124328,
	0x0F128038,
	0x0F12E002,
	0x0F128878,
	0x0F124330,
	0x0F128078,
	0x0F124874,
	0x0F128800,
	0x0F120400,
	0x0F12D504,
	0x0F12F000,
	0x0F12F993,
	0x0F12496E,
	0x0F122012,
	0x0F1280C8,
	0x0F12E5E3,
	0x0F12B570,
	0x0F124E6A,
	0x0F128881,
	0x0F1278F2,
	0x0F124D6E,
	0x0F124C6A,
	0x0F122A00,
	0x0F12D005,
	0x0F128A62,
	0x0F121889,
	0x0F128081,
	0x0F128B61,
	0x0F128029,
	0x0F12E004,
	0x0F128A22,
	0x0F121889,
	0x0F128081,
	0x0F128B21,
	0x0F128029,
	0x0F12F000,
	0x0F12F982,
	0x0F1278F0,
	0x0F122800,
	0x0F12D002,
	0x0F128BE0,
	0x0F1282E8,
	0x0F12E57B,
	0x0F128BA0,
	0x0F1282E8,
	0x0F12E578,
	0x0F12B430,
	0x0F12680B,
	0x0F12684D,
	0x0F12688C,
	0x0F1268C8,
	0x0F124A5F,
	0x0F128054,
	0x0F124958,
	0x0F1278CC,
	0x0F124959,
	0x0F122C00,
	0x0F12D003,
	0x0F128A49,
	0x0F121808,
	0x0F128090,
	0x0F12E002,
	0x0F128A09,
	0x0F121808,
	0x0F128090,
	0x0F1280D3,
	0x0F128115,
	0x0F12BC30,
	0x0F124770,
	0x0F12B5F3,
	0x0F120004,
	0x0F12B081,
	0x0F129802,
	0x0F126800,
	0x0F120600,
	0x0F120E00,
	0x0F122201,
	0x0F120015,
	0x0F120021,
	0x0F123910,
	0x0F12408A,
	0x0F1240A5,
	0x0F124F4D,
	0x0F120016,
	0x0F122C10,
	0x0F12DA03,
	0x0F128839,
	0x0F1243A9,
	0x0F128039,
	0x0F12E002,
	0x0F128879,
	0x0F1243B1,
	0x0F128079,
	0x0F12F000,
	0x0F12F950,
	0x0F122C10,
	0x0F12DA03,
	0x0F128839,
	0x0F124329,
	0x0F128039,
	0x0F12E002,
	0x0F128879,
	0x0F124331,
	0x0F128079,
	0x0F124946,
	0x0F128809,
	0x0F122900,
	0x0F12D102,
	0x0F12F000,
	0x0F12F949,
	0x0F122000,
	0x0F129902,
	0x0F126008,
	0x0F12BCFE,
	0x0F12BC08,
	0x0F124718,
	0x0F12B538,
	0x0F124C40,
	0x0F1289E5,
	0x0F12F000,
	0x0F12F946,
	0x0F121FE8,
	0x0F1238FD,
	0x0F12D132,
	0x0F1289E0,
	0x0F121FC1,
	0x0F1239FF,
	0x0F12D12E,
	0x0F12483C,
	0x0F1269E1,
	0x0F126840,
	0x0F121809,
	0x0F120200,
	0x0F12F000,
	0x0F12F8BA,
	0x0F120400,
	0x0F120C00,
	0x0F124A38,
	0x0F122305,
	0x0F120011,
	0x0F123114,
	0x0F12F000,
	0x0F12F938,
	0x0F120002,
	0x0F1266E0,
	0x0F124D34,
	0x0F128CE0,
	0x0F123D14,
	0x0F1289E9,
	0x0F12F000,
	0x0F12F88A,
	0x0F12466B,
	0x0F128018,
	0x0F128A29,
	0x0F128D20,
	0x0F126EE2,
	0x0F12F000,
	0x0F12F883,
	0x0F12466B,
	0x0F128058,
	0x0F120021,
	0x0F129800,
	0x0F123170,
	0x0F12F000,
	0x0F12F92A,
	0x0F120020,
	0x0F123060,
	0x0F128A02,
	0x0F124928,
	0x0F123980,
	0x0F12808A,
	0x0F128A42,
	0x0F1280CA,
	0x0F128A80,
	0x0F128108,
	0x0F12BC38,
	0x0F12BC08,
	0x0F124718,
	0x0F12B5F8,
	0x0F120004,
	0x0F126808,
	0x0F120400,
	0x0F120C00,
	0x0F122201,
	0x0F120015,
	0x0F120021,
	0x0F123910,
	0x0F12408A,
	0x0F1240A5,
	0x0F124F17,
	0x0F120016,
	0x0F122C10,
	0x0F12DA03,
	0x0F128839,
	0x0F1243A9,
	0x0F128039,
	0x0F12E002,
	0x0F128879,
	0x0F1243B1,
	0x0F128079,
	0x0F12F000,
	0x0F12F90D,
	0x0F122C10,
	0x0F12DA03,
	0x0F128838,
	0x0F124328,
	0x0F128038,
	0x0F12E002,
	0x0F128878,
	0x0F124330,
	0x0F128078,
	0x0F12480D,
	0x0F128800,
	0x0F120400,
	0x0F12D507,
	0x0F124B12,
	0x0F127819,
	0x0F124A12,
	0x0F127810,
	0x0F127018,
	0x0F127011,
	0x0F124905,
	0x0F128188,
	0x0F12E513,
	0x0F120000,
	0x0F122FA4,
	0x0F127000,
	0x0F12235C,
	0x0F127000,
	0x0F120140,
	0x0F127000,
	0x0F1220BC,
	0x0F127000,
	0x0F122DF0,
	0x0F127000,
	0x0F1247E0,
	0x0F127000,
	0x0F121100,
	0x0F12D000,
	0x0F122EE2,
	0x0F127000,
	0x0F12F400,
	0x0F12D000,
	0x0F123200,
	0x0F12D000,
	0x0F1216DE,
	0x0F127000,
	0x0F1236F8,
	0x0F127000,
	0x0F122B90,
	0x0F127000,
	0x0F1217B4,
	0x0F127000,
	0x0F122EDD,
	0x0F127000,
	0x0F122EDE,
	0x0F127000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F1213D5,
	0x0F120001,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A083,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A035,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12A1D9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F122D27,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F127D47,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F127AB1,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F127ACB,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12F004,
	0x0F12E51F,
	0x0F122630,
	0x0F120001,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12ED4D,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12EDDB,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F124EB5,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12053B,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F1249D1,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12D411,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F121E57,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F122603,
	0x0F120001,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12BC3D,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F122601,
	0x0F120001,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12BAB1,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12B89F,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12F077,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12C10D,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12C0C9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12EAF9,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F122E61,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12E86B,
	0x0F120000,
	0x0F124778,
	0x0F1246C0,
	0x0F12C000,
	0x0F12E59F,
	0x0F12FF1C,
	0x0F12E12F,
	0x0F12B231,
	0x0F120000,
	/* End of Patch Data*/

	/* switch to firmware address bank */
	0x0028D000,
	0x002A1000,
	0x0F120001,
	/* End of factory settings*/

	/* Switch to sw address bank */
	0x00287000,

	0x002A479E,
	0x0F120001,

	0x002A1432,
	0x0F120000,

	0x002A47EE,
	0x0F120001,
	0x0F12000A,
	0x0F120014,
	0x0F120070,
	0x0F120005,
	0x0F125A3C,

	0x002A4780,
	0x0F120000,
	0x0F120014,
	0x0F1200D2,
	0x0F120384,
	0x0F1207D0,
	0x0F121388,
	0x0F120180,
	0x0F120196,
	0x0F120054,
	0x0F120001,
	0x0F1201CC,
	0x0F1201CC,
	0x0F1201CC,
	0x0F1201CC,
	0x0F1201CC,

	0x002A0EF0,
	0x0F120001,

	0x002A0EF6,
	0x0F120002,

	0x002A1A84,
	0x0F12001C,

	0x002A01F8,
	0x0F120000,

	0x002A16E4,
	0x0F120100,

	0x002A01FA,
	0x0F120003,
	0x0F120000,

	0x002A0200,
	0x0F120061,

	0x002A0208,
	0x0F122F0C,
	0x0F120190,

	0x002A028E,
	0x0F120100,
	0x0F1200E3,
	0x0F120200,
	0x0F120238,
	0x0F1201C6,
	0x0F120166,
	0x0F120074,
	0x0F120132,
	0x0F120001,

	0x002A0702,
	0x0F1200FF,

	0x002A1600,
	0x0F120000,

	0x002A0712,
	0x0F120001,

	0x002A160C,
	0x0F129002,

	0x002A1616,
	0x0F120003,

	0x002A15A4,
	0x0F120902,

	0x002A1618,
	0x0F120000,

	0x002A1610,
	0x0F120003,

	0x002A1602,
	0x0F1200E5,
	0x0F120098,

	0x002A1598,
	0x0F120000,
	0x0F12D000,

	0x002A165E,
	0x0F12FF95,

	0x002A162E,
	0x0F120280,

	0x002A163A,
	0x0F1203A0,
	0x0F120320,

	0x002A1680,
	0x0F120030,

	0x002A16A4,
	0x0F120060,

	0x002A1698,
	0x0F120010,

	0x002A161A,
	0x0F120000,

	0x002A15AA,
	0x0F12003C,
	0x0F120018,
	0x0F12002A,
	0x0F120030,
	0x0F120036,
	0x0F12003C,
	0x0F120042,
	0x0F120048,
	0x0F12004E,
	0x0F120054,
	0x0F12005A,
	0x0F120060,
	0x0F120066,
	0x0F12006C,
	0x0F120072,
	0x0F120078,
	0x0F12007E,
	0x0F120084,
	0x0F12008A,
	0x0F120090,
	0x0F120096,
	0x0F12009C,
	0x0F1200A2,
	0x0F1200A8,
	0x0F1200AE,
	0x0F1200B4,
	0x0F1200BA,

	0x002A16E6,
	0x0F128000,
	0x0F120006,
	0x0F123FF0,
	0x0F1203E8,
	0x0F120000,
	0x0F120080,
	0x0F120009,
	0x0F120020,
	0x0F120040,
	0x0F120080,
	0x0F1200C0,
	0x0F1200E0,

	0x002A0286,
	0x0F120003,

	0x002A11B4,
	0x0F12012C,
	0x0F120121,

	0x002A1A00,
	0x0F12192E,
	0x0F127000,

	0x002A185C,
	0x0F120004,
	0x0F1209D1,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F1209D5,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F1209D5,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F120326,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F1209D1,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F1209D5,
	0x0F120000,
	0x0F120000,
	0x0F1202AA,
	0x0F120327,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F120084,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F12008D,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F1202AA,
	0x0F120000,
	0x0F120000,
	0x0F1200AA,
	0x0F1202AA,
	0x0F1203AD,
	0x0F1209CD,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202AE,
	0x0F1202DE,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202BE,
	0x0F1202EE,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202CE,
	0x0F1202EE,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F120009,
	0x0F120095,
	0x0F1209DB,
	0x0F120000,
	0x0F120000,
	0x0F120096,
	0x0F12009B,
	0x0F1202AE,
	0x0F1202B3,
	0x0F1209D1,
	0x0F1209D6,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1202AE,
	0x0F120000,
	0x0F120000,
	0x0F120009,
	0x0F120010,
	0x0F120327,
	0x0F120336,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120004,
	0x0F1205B6,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F120007,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F12024E,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F1205B6,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F1205BA,
	0x0F120000,
	0x0F120000,
	0x0F1201F4,
	0x0F12024F,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120075,
	0x0F1200CF,
	0x0F120000,
	0x0F120000,
	0x0F120075,
	0x0F1200D6,
	0x0F120000,
	0x0F120000,
	0x0F120004,
	0x0F1201F4,
	0x0F120000,
	0x0F120000,
	0x0F1200F0,
	0x0F1201F4,
	0x0F12029E,
	0x0F1205B2,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1201F8,
	0x0F120228,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120208,
	0x0F120238,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120218,
	0x0F120238,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F120009,
	0x0F1200DE,
	0x0F1205C0,
	0x0F120000,
	0x0F120000,
	0x0F1200DF,
	0x0F1200E4,
	0x0F1201F8,
	0x0F1201FD,
	0x0F1205B6,
	0x0F1205BB,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1201F8,
	0x0F120000,
	0x0F120000,
	0x0F120077,
	0x0F12007E,
	0x0F12024F,
	0x0F12025E,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A1836,
	0x0F120002,
	0x0F120000,
	0x0F120003,

	0x002A183E,
	0x0F120FB0,

	0x002A184C,
	0x0F120060,
	0x0F120060,
	0x0F1205C0,
	0x0F1205C0,

	0x002A1A8A,
	0x0F128080,
	0x0F120080,

	0x002A1A80,
	0x0F120000,

	0x002A1A12,
	0x0F120000,

	0x002A1842,
	0x0F120004,

	0x002A1A0A,
	0x0F12009A,

	0x002A3776,
	0x0F12024C,

	0x002A0EB2,
	0x0F120000,

	0x002A08C6,
	0x0F120001,

	0x002A08A4,
	0x0F120001,

	0x002A08E2,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124000,
	0x0F124500,
	0x0F124000,
	0x0F124000,
	0x0F124000,

	0x002A08E0,
	0x0F120001,

	0x002A1456,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120202,
	0x0F120202,
	0x0F120102,

	0x002A1448,
	0x0F12003C,

	0x002A144E,
	0x0F12000F,

	0x002A0580,
	0x0F123520,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F120470,
	0x0F120C00,
	0x0F120100,
	0x0F121000,

	0x002A0538,
	0x0F120111,
	0x0F1200EF,

	0x002A05FC,
	0x0F120000,
	0x0F120001,
	0x0F120600,
	0x0F120100,
	0x0F120001,
	0x0F120000,
	0x0F120A3C,
	0x0F120000,
	0x0F120D04,
	0x0F120000,
	0x0F124008,
	0x0F120000,
	0x0F127000,
	0x0F120000,
	0x0F129C00,
	0x0F120000,
	0x0F12AD00,
	0x0F120001,
	0x0F12F1D4,
	0x0F120002,
	0x0F12DC00,
	0x0F120005,
	0x0F12DC00,
	0x0F120005,
	0x0F120001,
	0x0F120000,
	0x0F120A3C,
	0x0F120000,
	0x0F120D05,
	0x0F120000,
	0x0F123408,
	0x0F120000,
	0x0F123408,
	0x0F120000,
	0x0F126810,
	0x0F120000,
	0x0F128214,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F120650,
	0x0F120100,

	0x002A06AC,
	0x0F12452C,
	0x0F120004,

	0x002A0280,
	0x0F120001,

	0x002A05C4,
	0x0F120000,

	0x002A0476,
	0x0F120001,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,

	0x002A01F4,
	0x0F125DC0,

	0x002A020E,
	0x0F120002,
	0x0F120000,
	0x0F120000,

	0x002A0216,
	0x0F123A98,
	0x0F124F1A,
	0x0F124F1A,
	0x0F124F1A,
	0x0F124F1A,
	0x0F124F1A,

	0x002A0228,
	0x0F120001,

	0x002A02A0,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x0F124F1A,
	0x0F124F1A,

	0x002A02AE,
	0x0F120052,

	0x002A02B6,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,

	0x002A02AA,
	0x0F120080,

	0x002A024C,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,

	0x002A048E,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,

	0x002A025E,
	0x0F120001,
	0x0F120001,

	0x002A0392,
	0x0F120A00,
	0x0F120780,
	0x0F120009,
	0x0F124F1A,
	0x0F124F1A,

	0x002A03A0,
	0x0F120002,

	0x002A03A8,
	0x0F120001,
	0x0F120000,
	0x0F120002,
	0x0F120535,
	0x0F12029A,

	0x002A039C,
	0x0F120080,

	0x002A0476,
	0x0F120001,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,

	0x002A0262,
	0x0F120000,

	0x002A0266,
	0x0F120001,

	0x002A024A,
	0x0F120001,

	0x002A0264,
	0x0F120001,

	0x002A026C,
	0x0F120001,

	0x002A023A,
	0x0F120001,
	0x0F120001,

	0x002A0472,
	0x0F12005F,
	0x0F12005F,

	0x002A0FE0,
	0x0F1203B8,
	0x0F1203CE,
	0x0F120350,
	0x0F1203C4,
	0x0F1202F2,
	0x0F120394,
	0x0F1202C0,
	0x0F120364,
	0x0F12029E,
	0x0F120334,
	0x0F12027C,
	0x0F120312,
	0x0F12025E,
	0x0F1202F2,
	0x0F120246,
	0x0F1202D0,
	0x0F120230,
	0x0F1202B0,
	0x0F120218,
	0x0F12029E,
	0x0F120208,
	0x0F120290,
	0x0F1201F8,
	0x0F120284,
	0x0F1201E8,
	0x0F120276,
	0x0F1201DA,
	0x0F12026A,
	0x0F1201CE,
	0x0F12025E,
	0x0F1201EC,
	0x0F12022E,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120005,

	0x002A1034,
	0x0F120010,

	0x002A1038,
	0x0F120126,

	0x002A103C,
	0x0F12026C,
	0x0F12029A,
	0x0F12025C,
	0x0F1202B6,
	0x0F12024E,
	0x0F1202C0,
	0x0F120240,
	0x0F1202BE,
	0x0F12023A,
	0x0F1202B4,
	0x0F12023A,
	0x0F1202AA,
	0x0F120240,
	0x0F12029E,
	0x0F12025C,
	0x0F120294,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120004,

	0x002A1070,
	0x0F120008,

	0x002A1074,
	0x0F1201E2,

	0x002A1078,
	0x0F120350,
	0x0F120422,
	0x0F1202C4,
	0x0F120452,
	0x0F120278,
	0x0F12041C,
	0x0F120230,
	0x0F1203EE,
	0x0F1201F0,
	0x0F120392,
	0x0F1201C0,
	0x0F120340,
	0x0F120194,
	0x0F120302,
	0x0F12016E,
	0x0F1202C2,
	0x0F120148,
	0x0F120286,
	0x0F12018A,
	0x0F120242,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120006,

	0x002A10AC,
	0x0F12000A,

	0x002A10B0,
	0x0F120106,

	0x002A10B4,
	0x0F120380,
	0x0F120000,
	0x0F120168,
	0x0F120000,
	0x0F122D90,
	0x0F120000,

	0x002A1428,
	0x0F120008,
	0x0F120190,
	0x0F1200A0,

	0x002A11EC,
	0x0F1200C0,

	0x002A11F0,
	0x0F120010,

	0x002A11EE,
	0x0F120010,

	0x002A11CE,
	0x0F1205D5,

	0x002A11D2,
	0x0F120000,
	0x0F120771,
	0x0F1203A4,
	0x0F120036,
	0x0F12002A,

	0x002A08AC,
	0x0F1200C0,
	0x0F1200DF,
	0x0F120100,
	0x0F120125,
	0x0F12015F,
	0x0F12017C,
	0x0F120194,

	0x002A123C,
	0x0F12FEF7,
	0x0F120021,
	0x0F120E74,
	0x0F120E74,
	0x0F12018F,
	0x0F120096,
	0x0F12000E,

	0x002A11E8,
	0x0F120032,
	0x0F12001E,

	0x002A2ABC,
	0x0F120006,

	0x002A1430,
	0x0F120002,

	0x002A140A,
	0x0F1200AB,
	0x0F1200BF,
	0x0F1200D2,
	0x0F120093,

	0x002A13F8,
	0x0F120300,
	0x0F12036E,
	0x0F1203C2,
	0x0F121015,
	0x0F1210E1,
	0x0F121154,
	0x0F1211A8,
	0x0F1211BB,
	0x0F12123B,

	0x002A1368,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F120030,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F120030,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120008,
	0x0F120030,
	0x0F12FFE0,
	0x0F12FFE0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFA0,
	0x0F12FE36,
	0x0F12FFE0,
	0x0F12FFE0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFA0,
	0x0F12FE36,
	0x0F12FFE0,
	0x0F12FFE0,
	0x0F12FFC0,
	0x0F12FFC0,
	0x0F12FFA0,
	0x0F12FE36,
	0x0F12FFEA,
	0x0F12FFEA,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFEA,
	0x0F12FFEA,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFEA,
	0x0F12FFEA,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F12FFC8,
	0x0F120014,
	0x0F120014,
	0x0F120014,
	0x0F12FDA0,
	0x0F12FCF0,
	0x0F12FCD0,
	0x0F120014,
	0x0F120014,
	0x0F120014,
	0x0F12FDA0,
	0x0F12FCF0,
	0x0F12FCD0,
	0x0F120014,
	0x0F120014,
	0x0F120014,
	0x0F12FDA0,
	0x0F12FCF0,
	0x0F12FCD0,

	0x002A13FE,
	0x0F121015,
	0x0F12106C,
	0x0F1210CA,
	0x0F121142,
	0x0F1211BB,
	0x0F12123B,
	0x0F1200AB,
	0x0F1200BF,
	0x0F1200D2,
	0x0F120093,

	0x002A11CC,
	0x0F120020,

	0x002A1412,
	0x0F120000,
	0x0F120000,
	0x0F120000,

	0x002A0724,
	0x0F120001,
	0x0F120007,
	0x0F120010,
	0x0F120028,
	0x0F120062,
	0x0F1200D3,
	0x0F120130,
	0x0F120158,
	0x0F12017D,
	0x0F1201BE,
	0x0F1201F8,
	0x0F12022C,
	0x0F12025B,
	0x0F1202AA,
	0x0F1202EC,
	0x0F12034E,
	0x0F120396,
	0x0F1203C6,
	0x0F1203E9,
	0x0F1203F9,
	0x0F120001,
	0x0F120007,
	0x0F120010,
	0x0F120028,
	0x0F120062,
	0x0F1200D3,
	0x0F120130,
	0x0F120158,
	0x0F12017D,
	0x0F1201BE,
	0x0F1201F8,
	0x0F12022C,
	0x0F12025B,
	0x0F1202AA,
	0x0F1202EC,
	0x0F12034E,
	0x0F120396,
	0x0F1203C6,
	0x0F1203E9,
	0x0F1203F9,
	0x0F120001,
	0x0F120007,
	0x0F120010,
	0x0F120028,
	0x0F120062,
	0x0F1200D3,
	0x0F120130,
	0x0F120158,
	0x0F12017D,
	0x0F1201BE,
	0x0F1201F8,
	0x0F12022C,
	0x0F12025B,
	0x0F1202AA,
	0x0F1202EC,
	0x0F12034E,
	0x0F120396,
	0x0F1203C6,
	0x0F1203E9,
	0x0F1203F9,
	0x0F120000,
	0x0F12000F,
	0x0F120020,
	0x0F120043,
	0x0F120086,
	0x0F1200ED,
	0x0F12013E,
	0x0F120163,
	0x0F120185,
	0x0F1201BF,
	0x0F1201F2,
	0x0F120221,
	0x0F12024A,
	0x0F120294,
	0x0F1202D0,
	0x0F12032A,
	0x0F12036A,
	0x0F12039F,
	0x0F1203CC,
	0x0F1203F9,
	0x0F120000,
	0x0F12000F,
	0x0F120020,
	0x0F120043,
	0x0F120086,
	0x0F1200ED,
	0x0F12013E,
	0x0F120163,
	0x0F120185,
	0x0F1201BF,
	0x0F1201F2,
	0x0F120221,
	0x0F12024A,
	0x0F120294,
	0x0F1202D0,
	0x0F12032A,
	0x0F12036A,
	0x0F12039F,
	0x0F1203CC,
	0x0F1203F9,
	0x0F120000,
	0x0F12000F,
	0x0F120020,
	0x0F120043,
	0x0F120086,
	0x0F1200ED,
	0x0F12013E,
	0x0F120163,
	0x0F120185,
	0x0F1201BF,
	0x0F1201F2,
	0x0F120221,
	0x0F12024A,
	0x0F120294,
	0x0F1202D0,
	0x0F12032A,
	0x0F12036A,
	0x0F12039F,
	0x0F1203CC,
	0x0F1203F9,

	0x002A0896,
	0x0F1200C0,
	0x0F120100,
	0x0F120125,
	0x0F12015F,
	0x0F12017C,
	0x0F120194,
	0x0F120001,

	0x002A0888,
	0x0F124800,
	0x0F127000,

	0x002A4800,
	0x0F12016C,
	0x0F12FF94,
	0x0F12FFCE,
	0x0F12FF20,
	0x0F1201BF,
	0x0F12FF53,
	0x0F12003F,
	0x0F120007,
	0x0F1201DF,
	0x0F120110,
	0x0F1200DF,
	0x0F12FF47,
	0x0F120206,
	0x0F12FF7F,
	0x0F120191,
	0x0F12FF06,
	0x0F1201BA,
	0x0F120108,
	0x0F12016C,
	0x0F12FF94,
	0x0F12FFCE,
	0x0F12FF20,
	0x0F1201BF,
	0x0F12FF53,
	0x0F12003F,
	0x0F120007,
	0x0F1201DF,
	0x0F120110,
	0x0F1200DF,
	0x0F12FF47,
	0x0F120206,
	0x0F12FF7F,
	0x0F120191,
	0x0F12FF06,
	0x0F1201BA,
	0x0F120108,
	0x0F12016C,
	0x0F12FF94,
	0x0F12FFCE,
	0x0F12FF20,
	0x0F1201BF,
	0x0F12FF53,
	0x0F12003F,
	0x0F120007,
	0x0F1201DF,
	0x0F120110,
	0x0F1200DF,
	0x0F12FF47,
	0x0F120206,
	0x0F12FF7F,
	0x0F120191,
	0x0F12FF06,
	0x0F1201BA,
	0x0F120108,
	0x0F120208,
	0x0F12FFD3,
	0x0F12FFE9,
	0x0F12FF5B,
	0x0F12025A,
	0x0F12FF80,
	0x0F12FFC8,
	0x0F12FFC1,
	0x0F12013A,
	0x0F120112,
	0x0F1200EE,
	0x0F12FF99,
	0x0F12009E,
	0x0F12FF5F,
	0x0F1201A8,
	0x0F12FF75,
	0x0F120187,
	0x0F1201BF,
	0x0F120208,
	0x0F12FFD3,
	0x0F12FFE9,
	0x0F12FF5B,
	0x0F12025A,
	0x0F12FF80,
	0x0F12FFC8,
	0x0F12FFC1,
	0x0F12013A,
	0x0F120112,
	0x0F1200EE,
	0x0F12FF99,
	0x0F12009E,
	0x0F12FF5F,
	0x0F1201A8,
	0x0F12FF75,
	0x0F120187,
	0x0F1201BF,
	0x0F120208,
	0x0F12FFD3,
	0x0F12FFE9,
	0x0F12FF5B,
	0x0F12025A,
	0x0F12FF80,
	0x0F12FFC8,
	0x0F12FFC1,
	0x0F12013A,
	0x0F120112,
	0x0F1200EE,
	0x0F12FF99,
	0x0F12009E,
	0x0F12FF5F,
	0x0F1201A8,
	0x0F12FF75,
	0x0F120187,
	0x0F1201BF,

	0x002A0890,
	0x0F1248D8,
	0x0F127000,

	0x002A48D8,
	0x0F1201AA,
	0x0F12FFB6,
	0x0F12FFD4,
	0x0F12FF6C,
	0x0F1201E8,
	0x0F12FF79,
	0x0F120000,
	0x0F12FFF5,
	0x0F12023C,
	0x0F1200BF,
	0x0F1200E0,
	0x0F12FF5B,
	0x0F12022D,
	0x0F12FF9B,
	0x0F1201E1,
	0x0F12FF34,
	0x0F12014B,
	0x0F1201B6,

	0x002A0924,
	0x0F120050,
	0x0F1200B0,
	0x0F120196,
	0x0F120245,
	0x0F120300,

	0x002A0958,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120032,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120040,
	0x0F1200A0,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F123604,
	0x0F12032A,
	0x0F120403,
	0x0F121B06,
	0x0F126015,
	0x0F1200C0,
	0x0F126080,
	0x0F124080,
	0x0F120640,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120000,
	0x0F120400,
	0x0F12365A,
	0x0F12102A,
	0x0F12000B,
	0x0F120600,
	0x0F125A0F,
	0x0F120505,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123028,
	0x0F120418,
	0x0F120101,
	0x0F120800,
	0x0F121804,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120205,
	0x0F120304,
	0x0F120409,
	0x0F120306,
	0x0F120407,
	0x0F121C04,
	0x0F120214,
	0x0F121002,
	0x0F120610,
	0x0F120F02,
	0x0F124A18,
	0x0F120080,
	0x0F120040,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F122A36,
	0x0F126024,
	0x0F122A36,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F123601,
	0x0F12242A,
	0x0F123660,
	0x0F12FF2A,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120032,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F122404,
	0x0F12031B,
	0x0F120103,
	0x0F121205,
	0x0F12400D,
	0x0F120080,
	0x0F122080,
	0x0F123040,
	0x0F120630,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120300,
	0x0F12245A,
	0x0F121018,
	0x0F12000B,
	0x0F120B00,
	0x0F125A0F,
	0x0F120505,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123428,
	0x0F12041C,
	0x0F120101,
	0x0F120800,
	0x0F121004,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120205,
	0x0F120304,
	0x0F120409,
	0x0F120306,
	0x0F120407,
	0x0F121F04,
	0x0F120218,
	0x0F121102,
	0x0F120611,
	0x0F121002,
	0x0F128018,
	0x0F120080,
	0x0F120080,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F121B24,
	0x0F126024,
	0x0F121010,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F122401,
	0x0F12241B,
	0x0F121E60,
	0x0F12FF18,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120032,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F121B04,
	0x0F120312,
	0x0F120003,
	0x0F120C03,
	0x0F122806,
	0x0F120060,
	0x0F121580,
	0x0F122020,
	0x0F120620,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120300,
	0x0F12145A,
	0x0F121010,
	0x0F12000B,
	0x0F120E00,
	0x0F125A0F,
	0x0F120504,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123828,
	0x0F120428,
	0x0F120101,
	0x0F128000,
	0x0F120A04,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120207,
	0x0F120304,
	0x0F120409,
	0x0F120306,
	0x0F120407,
	0x0F122404,
	0x0F120221,
	0x0F121202,
	0x0F120613,
	0x0F121202,
	0x0F128018,
	0x0F120080,
	0x0F120080,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F12121B,
	0x0F126024,
	0x0F120C0C,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F121B01,
	0x0F122412,
	0x0F120C60,
	0x0F12FF0C,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120032,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F121504,
	0x0F12030F,
	0x0F120003,
	0x0F120902,
	0x0F122004,
	0x0F120050,
	0x0F121140,
	0x0F12201C,
	0x0F120620,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120300,
	0x0F12145A,
	0x0F121010,
	0x0F12000B,
	0x0F121000,
	0x0F125A0F,
	0x0F120503,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F123C28,
	0x0F12042C,
	0x0F120101,
	0x0F12FF00,
	0x0F120904,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120206,
	0x0F120304,
	0x0F120409,
	0x0F120305,
	0x0F120406,
	0x0F122804,
	0x0F120228,
	0x0F121402,
	0x0F120618,
	0x0F121402,
	0x0F128018,
	0x0F120080,
	0x0F120080,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F120F15,
	0x0F126024,
	0x0F120A0A,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F121501,
	0x0F12240F,
	0x0F120A60,
	0x0F12FF0A,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F120000,
	0x0F1200C0,
	0x0F120064,
	0x0F120384,
	0x0F120032,
	0x0F1201F4,
	0x0F120070,
	0x0F120040,
	0x0F1200A0,
	0x0F120100,
	0x0F120010,
	0x0F120060,
	0x0F120100,
	0x0F121430,
	0x0F120201,
	0x0F120204,
	0x0F120F04,
	0x0F12030C,
	0x0F120003,
	0x0F120602,
	0x0F121803,
	0x0F120040,
	0x0F120E20,
	0x0F122018,
	0x0F120620,
	0x0F120306,
	0x0F122003,
	0x0F12FF01,
	0x0F120404,
	0x0F120200,
	0x0F12145A,
	0x0F121010,
	0x0F12000B,
	0x0F121200,
	0x0F125A0F,
	0x0F120502,
	0x0F121802,
	0x0F120000,
	0x0F122006,
	0x0F124028,
	0x0F120430,
	0x0F120101,
	0x0F12FF00,
	0x0F120804,
	0x0F124008,
	0x0F120540,
	0x0F128006,
	0x0F120020,
	0x0F120000,
	0x0F121800,
	0x0F120000,
	0x0F121E10,
	0x0F12000B,
	0x0F120607,
	0x0F120005,
	0x0F120607,
	0x0F120405,
	0x0F120205,
	0x0F120304,
	0x0F120409,
	0x0F120306,
	0x0F120407,
	0x0F122C04,
	0x0F12022C,
	0x0F121402,
	0x0F120618,
	0x0F121402,
	0x0F128018,
	0x0F120080,
	0x0F120080,
	0x0F120180,
	0x0F120A0A,
	0x0F120101,
	0x0F120C0F,
	0x0F126024,
	0x0F120808,
	0x0F12FFFF,
	0x0F120808,
	0x0F120A01,
	0x0F12010A,
	0x0F120F01,
	0x0F12240C,
	0x0F120860,
	0x0F12FF08,
	0x0F1208FF,
	0x0F120008,
	0x0F120001,
	0x0F1223CE,
	0x0F12FDC8,
	0x0F12112E,
	0x0F1293A5,
	0x0F12FE67,
	0x0F120000,

	0xFCFCD000,
	0x00287000,
	0x002A01A2,
	0x0F120A0A,

	0xFCFCD000,
	0x00040001,
};

static const u32 s5k4ecgx_DTP_init_v1[] = {
	0x0028D000,
	0x002AB054,
	0x0F120001,
	0x00287000,
};

static const u32 s5k4ecgx_DTP_stop_v1[] = {
	0x0028D000,
	0x002AB054,
	0x0F120000,
	0x00287000,
};

static const u32 s5k4ecgx_Effect_Normal_v1[] = {
	0x002A0238,
	0x0F120000,
};

static const u32 s5k4ecgx_Effect_Negative_v1[] = {
	0x002A0238,
	0x0F120003,
};

static const u32 s5k4ecgx_Effect_Sepia_v1[] = {
	0x002A0238,
	0x0F120004,
};

static const u32 s5k4ecgx_Effect_Black_White_v1[] = {
	0x002A0238,
	0x0F120001,
};

static const u32 s5k4ecgx_WB_Auto_v1[] = {
	0x002a04E0,
	0x0f12077F,
};

static const u32 s5k4ecgx_WB_Sunny_v1[] = {
	0x002a04E0,
	0x0f120777,
	0x002a04B4,
	0x0f1205E0,
	0x0f120001,
	0x0f120400,
	0x0f120001,
	0x0f120530,
	0x0f120001,
	0x0f120001,
};

static const u32 s5k4ecgx_WB_Cloudy_v1[] = {
	0x002a04E0,
	0x0f120777,
	0x002a04B4,/* USER RGB Gain */
	0x0f120710,/* R */
	0x0f120001,/* Changed */
	0x0f120400,/* G */
	0x0f120001,
	0x0f120420,/* B  480-reference */
	0x0f120001,
	0x0f120001,
};

static const u32 s5k4ecgx_WB_Tungsten_v1[] = {
	0x002a04E0,
	0x0f120777,
	0x002a04B4,
	0x0f120390,
	0x0f120001,
	0x0f120400,
	0x0f120001,
	0x0f120920,
	0x0f120001,
	0x0f120001,
};

static const u32 s5k4ecgx_WB_Fluorescent_v1[] = {
	0x002a04E0,
	0x0f120777,
	0x002a04B4,
	0x0f120505,
	0x0f120001,
	0x0f120400,
	0x0f120001,
	0x0f120875,
	0x0f120001,
	0x0f120001,
};

static const u32 s5k4ecgx_WDR_on_v1[] = {
	0x002A1B4A,
	0x0F120000,
};

static const u32 s5k4ecgx_WDR_off_v1[] = {
	0x002A1B4A,
	0x0F120001,
};

static const u32 s5k4ecgx_ISO_Auto_v1[] = {
	0x002A4780,
	0x0F120000,

	0x002A0EF0,
	0x0F120001,
	0x002A04E0,
	0x0F12077F,
	0x002A04CA,
	0x0F120000,

	0x002A04CA,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x002A06B6,
	0x0F120200,
};

static const u32 s5k4ecgx_ISO_100_v1[] = {
	0x002A04E0,
	0x0F12065F,
	0x002A04D0,
	0x0F120000,
	0x0F120001,

	0x002A04CA,
	0x0F120001,
	0x0F1201A0,
	0x0F120001,
	0x002A06B6,
	0x0F120100,

	0x002A4780,
	0x0F120001,
};

static const u32 s5k4ecgx_ISO_200_v1[] = {
	0x002A04E0,
	0x0F12065F,
	0x002A04D0,
	0x0F120000,
	0x0F120001,

	0x002A04CA,
	0x0F120001,
	0x0F120340,
	0x0F120001,
	0x002A06B6,
	0x0F120100,

	0x002A4780,
	0x0F120001,
};

static const u32 s5k4ecgx_ISO_400_v1[] = {
	0x002A04E0,
	0x0F12065F,
	0x002A04D0,
	0x0F120000,
	0x0F120001,

	0x002A04CA,
	0x0F120001,
	0x0F120680,
	0x0F120001,
	0x002A06B6,
	0x0F120100,

	0x002A4780,
	0x0F120001,
};

static const u32 s5k4ecgx_Metering_Matrix_v1[] = {
	0x002A1456,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
};

static const u32 s5k4ecgx_Metering_Center_v1[] = {
	0x002A1456,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120202,
	0x0F120202,
	0x0F120102,
};

static const u32 s5k4ecgx_Metering_Spot_v1[] = {
	0x002A1456,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120101,
	0x0f120101,
	0x0f120000,
	0x0f120000,
	0x0f12010f,
	0x0f120f01,
	0x0f120000,
	0x0f120000,
	0x0f12010f,
	0x0f120f01,
	0x0f120000,
	0x0f120000,
	0x0f120101,
	0x0f120101,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
	0x0f120000,
};

static const u32 s5k4ecgx_EV_Minus_4_v1[] = {
	0x002A022C,
	0x0F12FF30,
};

static const u32 s5k4ecgx_EV_Minus_3_v1[] = {
	0x002A022C,
	0x0F12FFA0,
};

static const u32 s5k4ecgx_EV_Minus_2_v1[] = {
	0x002A022C,
	0x0F12FFC8,
};

static const u32 s5k4ecgx_EV_Minus_1_v1[] = {
	0x002A022C,
	0x0F12FFE0,
};

static const u32 s5k4ecgx_EV_Default_v1[] = {
	0x002A022C,
	0x0F120000,
};

static const u32 s5k4ecgx_EV_Plus_1_v1[] = {
	0x002A022C,
	0x0F120020,
};

static const u32 s5k4ecgx_EV_Plus_2_v1[] = {
	0x002A022C,
	0x0F120038,
};

static const u32 s5k4ecgx_EV_Plus_3_v1[] = {
	0x002A022C,
	0x0F120060,
};

static const u32 s5k4ecgx_EV_Plus_4_v1[] = {
	0x002A022C,
	0x0F12007F,
};

static const u32 s5k4ecgx_Contrast_Minus_4_v1[] = {
	0x002A022E,
	0x0F12FF81,
};

static const u32 s5k4ecgx_Contrast_Minus_3_v1[] = {
	0x002A022E,
	0x0F12FFA0,
};

static const u32 s5k4ecgx_Contrast_Minus_2_v1[] = {
	0x002A022E,
	0x0F12FFC0,
};

static const u32 s5k4ecgx_Contrast_Minus_1_v1[] = {
	0x002A022E,
	0x0F12FFE0,
};

static const u32 s5k4ecgx_Contrast_Default_v1[] = {
	0x002A022E,
	0x0F120000,
};

static const u32 s5k4ecgx_Contrast_Plus_1_v1[] = {
	0x002A022E,
	0x0F120020,
};

static const u32 s5k4ecgx_Contrast_Plus_2_v1[] = {
	0x002A022E,
	0x0F120040,
};

static const u32 s5k4ecgx_Contrast_Plus_3_v1[] = {
	0x002A022E,
	0x0F120060,
};

static const u32 s5k4ecgx_Contrast_Plus_4_v1[] = {
	0x002A022E,
	0x0F12007F,
};

static const u32 s5k4ecgx_Sharpness_Minus_3_v1[] = {
	0x002A09F4,
	0x0F120000,
	0x002A0AAA,
	0x0F120000,
	0x002A0B60,
	0x0F120000,
	0x002A0C16,
	0x0F120000,
	0x002A0CCC,
	0x0F120000,
};

static const u32 s5k4ecgx_Sharpness_Minus_2_v1[] = {
	0x002A09F4,
	0x0F122010,
	0x002A0AAA,
	0x0F122010,
	0x002A0B60,
	0x0F122010,
	0x002A0C16,
	0x0F122010,
	0x002A0CCC,
	0x0F122010,
};

static const u32 s5k4ecgx_Sharpness_Minus_1_v1[] = {
	0x002A09F4,
	0x0F124020,
	0x002A0AAA,
	0x0F124020,
	0x002A0B60,
	0x0F124020,
	0x002A0C16,
	0x0F124020,
	0x002A0CCC,
	0x0F124020,
};

static const u32 s5k4ecgx_Sharpness_Default_v1[] = {
	0x002A09F4,
	0x0F126024,
	0x002A0AAA,
	0x0F126024,
	0x002A0B60,
	0x0F126024,
	0x002A0C16,
	0x0F126024,
	0x002A0CCC,
	0x0F126024,
};

static const u32 s5k4ecgx_Sharpness_Plus_1_v1[] = {
	0x002A09F4,
	0x0F128040,
	0x002A0AAA,
	0x0F128040,
	0x002A0B60,
	0x0F128040,
	0x002A0C16,
	0x0F128040,
	0x002A0CCC,
	0x0F128040,
};

static const u32 s5k4ecgx_Sharpness_Plus_2_v1[] = {
	0x002A09F4,
	0x0F12A060,
	0x002A0AAA,
	0x0F12A060,
	0x002A0B60,
	0x0F12A060,
	0x002A0C16,
	0x0F12A060,
	0x002A0CCC,
	0x0F12A060,
};

static const u32 s5k4ecgx_Sharpness_Plus_3_v1[] = {
	0x002A09F4,
	0x0F12C080,
	0x002A0AAA,
	0x0F12C080,
	0x002A0B60,
	0x0F12C080,
	0x002A0C16,
	0x0F12C080,
	0x002A0CCC,
	0x0F12C080,
};

static const u32 s5k4ecgx_Saturation_Minus_2_v1[] = {
	0x002A0230,
	0x0F12FF81,
};

static const u32 s5k4ecgx_Saturation_Minus_1_v1[] = {
	0x002A0230,
	0x0F12FFC0,
};

static const u32 s5k4ecgx_Saturation_Default_v1[] = {
	0x002A0230,
	0x0F120000,
};

static const u32 s5k4ecgx_Saturation_Plus_1_v1[] = {
	0x002A0230,
	0x0F120040,
};

static const u32 s5k4ecgx_Saturation_Plus_2_v1[] = {
	0x002A0230,
	0x0F12007F,
};

static const u32 s5k4ecgx_Jpeg_Quality_High_v1[] = {
	0x002A0472,
	0x0F12005F,
	0x0F12005F,
};

static const u32 s5k4ecgx_Jpeg_Quality_Normal_v1[] = {
	0x002A0472,
	0x0F120050,
	0x0F120050,
};

static const u32 s5k4ecgx_Jpeg_Quality_Low_v1[] = {
	0x002A0472,
	0x0F12004B,
	0x0F12004B,
};

static const u32 s5k4ecgx_Scene_Default_v1[] = {
	0x002A1456,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120000,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120101,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120403,
	0x0F120304,
	0x0F120102,
	0x0F120201,
	0x0F120303,
	0x0F120303,
	0x0F120102,
	0x0F120201,
	0x0F120202,
	0x0F120202,
	0x0F120102,

	0x002A4780,
	0x0F120000,

	0x002A06AC,
	0x0F12452C,
	0x0F120004,

	0x002A0EF0,
	0x0F120001,
	0x002A0EF6,
	0x0F120001,
	0x002A04E0,
	0x0F12077F,
	0x002A04CA,
	0x0F120000,

	0x002A04CA,
	0x0F120000,
	0x0F120000,
	0x0F120001,
	0x002A06B6,
	0x0F120200,

	0x002a2B7E,
	0x0f120001,


	0x002A1448,
	0x0F12003C,
	0x002A144E,
	0x0F12000F,
	0x002A0580,
	0x0F123520,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F12C350,
	0x0F120000,
	0x0F120470,
	0x0F120C00,
	0x0F120100,
	0x0F121000,

	0x002A0538,
	0x0F120111,
	0x0F1200EF,


	0x002A05FC,
	0x0F120000,
	0x0F120001,

	0x002A09F4,
	0x0F126024,
	0x002A0AAA,
	0x0F126024,
	0x002A0B60,
	0x0F126024,
	0x002A0C16,
	0x0F126024,
	0x002A0CCC,
	0x0F126024,

	0x002A0230,
	0x0F120000,

	0x002A062C,
	0x0F120001,
	0x0F120000,
	0x002A0630,
	0x0F120A3C,
	0x0F120000,
	0x002A0634,
	0x0F120D05,
	0x0F120000,
	0x002A0638,
	0x0F123408,
	0x0F120000,
	0x002A063C,
	0x0F123408,
	0x0F120000,
	0x002A0640,
	0x0F126810,
	0x0F120000,
	0x002A0644,
	0x0F128214,
	0x0F120000,
	0x002A0648,
	0x0F12C350,
	0x0F120000,
	0x002A064C,
	0x0F12C350,
	0x0F120000,
	0x002A0650,
	0x0F12C350,
	0x0F120000,

	0x002A03AE,
	0x0F120535,
	0x0F12029A,


	0x002A0262,
	0x0F120000,
	0x002A0266,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0264,
	0x0F120001,
	0x002A026C,
	0x0F120001,
	0x002A023A,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Portrait_v1[] = {
	0x002A09F4,
	0x0F124020,
	0x002A0AAA,
	0x0F124020,
	0x002A0B60,
	0x0F124020,
	0x002A0C16,
	0x0F124020,
	0x002A0CCC,
	0x0F124020,
};

static const u32 s5k4ecgx_Scene_Nightshot_v1[] = {
	0x002A06AC,
	0x0F12FFFF,
	0x0F1200FF,

	0x002A05FC,
	0x0F120000,
	0x0F120000,

	0x002A0580,
	0x0F12F424,
	0x0F120001,
	0x0F12F424,
	0x0F120001,
	0x0F12F424,
	0x0F120001,
	0x0F12F424,
	0x0F120001,
	0x0F120100,
	0x0F120700,
	0x0F120100,
	0x0F122000,

	0x002A03AE,
	0x0F121388,
	0x0F121388,

	0x002A02BC,
	0x0F1209C4,
	0x0F12014D,

	0x002A0262,
	0x0F120000,

	0x002A0266,
	0x0F120001,

	0x002A024A,
	0x0F120001,

	0x002A0264,
	0x0F120001,

	0x002A026C,
	0x0F120001,

	0x002A023A,
	0x0F120001,
	0x0F120001,

	0x002A09EA,
	0x0F121580,
};

static const u32 s5k4ecgx_Scene_Landscape_v1[] = {
	0x002A1456,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x0f120101,
	0x002A09F4,
	0x0F128040,
	0x002A0AAA,
	0x0F128040,
	0x002A0B60,
	0x0F128040,
	0x002A0C16,
	0x0F128040,
	0x002A0CCC,
	0x0F128040,
	0x002A0230,
	0x0F120040,
};

static const u32 s5k4ecgx_Scene_Sports_v1[] = {
	0x002A05FC,

	0x0F120000,
	0x0F120000,

	0x002A0580,
	0x0F123520,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F123520,
	0x0F120000,
	0x0F120200,
	0x0F120200,
	0x0F120200,
	0x0F120200,

	0x002A0262,
	0x0F120000,
	0x002A0266,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0264,
	0x0F120001,
	0x002A026C,
	0x0F120001,
	0x002A023A,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Party_Indoor_v1[] = {
	0x002A04E0,
	0x0F12065F,
	0x002A04D0,
	0x0F120000,
	0x0F120001,

	0x002A04CA,
	0x0F120001,
	0x0F120340,
	0x0F120001,
	0x002A06B6,
	0x0F120100,


	0x002A4780,
	0x0F120001,

	0x002A0230,
	0x0F120031,
};

static const u32 s5k4ecgx_Scene_Beach_Snow_v1[] = {
	0x002A04E0,
	0x0F12065F,
	0x002A04D0,
	0x0F120000,
	0x0F120001,
	0x002A04CA,
	0x0F120001,
	0x0F1200D0,
	0x0F120001,
	0x002A06B6,
	0x0F120100,


	0x002A4780,
	0x0F120001,

	0x002A0230,
	0x0F120031,
};

static const u32 s5k4ecgx_Scene_Sunset_v1[] = {
	0x002a2B7E,
	0x0f120000,

	0x002a04B4,
	0x0f1205E0,
	0x0f120001,
	0x0f120400,
	0x0f120001,
	0x0f120520,
	0x0f120001,
};

static const u32 s5k4ecgx_Scene_Duskdawn_v1[] = {
	0x002a2B7E,
	0x0f120000,

	0x002a04B4,
	0x0f120575,
	0x0f120001,
	0x0f120400,
	0x0f120001,
	0x0f120835,
	0x0f120001,
};

static const u32 s5k4ecgx_Scene_Fireworks_v1[] = {
	0x002A062C,
	0x0F120001,
	0x0F120000,
	0x002A0630,
	0x0F121478,
	0x0F120000,
	0x002A0634,
	0x0F121A0A,
	0x0F120000,
	0x002A0638,
	0x0F126810,
	0x0F120000,
	0x002A063C,
	0x0F126810,
	0x0F120000,
	0x002A0640,
	0x0F12D020,
	0x0F120000,
	0x002A0644,
	0x0F120428,
	0x0F120001,
	0x002A0648,
	0x0F121A80,
	0x0F120006,
	0x002A064C,
	0x0F121A80,
	0x0F120006,
	0x002A0650,
	0x0F121A80,
	0x0F120006,

	0x002A03AE,
	0x0F122710,
	0x0F122710,

	0x002A0262,
	0x0F120000,
	0x002A0266,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0264,
	0x0F120001,
	0x002A026C,
	0x0F120001,
	0x002A023A,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Scene_Candle_Light_v1[] = {
	0x002a04E0,
	0x0f120777,
	0x002a04B4,
	0x0f1205E0,
	0x0f120001,
	0x0f120400,
	0x0f120001,
	0x0f120530,
	0x0f120001,
};

static const u32 s5k4ecgx_Night_Capture_v1[] = {
	0x002A09EA,
	0x0F120AAA,
	0x002A0AA0,
	0x0F120AAA,
};


static const u32 s5k4ecgx_AF_Return_Inf_pos_v1[] = {
	0x002A159A,
	0x0F12D02A,
};

static const u32 s5k4ecgx_AF_Return_Macro_pos_v1[] = {
	0x002A15AC,
	0x0F120018,
	0x0F12002A,
	0x0F120030,
	0x0F120036,
	0x0F12003C,
	0x0F120042,
	0x0F120048,
	0x0F12004E,
	0x0F120054,
	0x0F12005A,
	0x0F120060,
	0x0F120066,
	0x0F12006C,
	0x0F120072,
	0x0F120078,
	0x0F12007E,
	0x0F120084,
	0x0F12008A,
	0x0F120090,
	0x0F120096,
	0x0F12009C,
	0x0F1200A2,
	0x0F1200A8,
	0x0F1200AE,
	0x0F1200B4,
	0x0F1200BA,
};

static const u32 s5k4ecgx_AF_Normal_mode_1_v1[] = {
	0x002A0288,
	0x0F12002A,
};

static const u32 s5k4ecgx_AF_Normal_mode_2_v1[] = {
	0x002A0286,
	0x0F120004,
};


static const u32 s5k4ecgx_AF_Normal_mode_3_v1[] = {
	0x002A160C,
	0x0F129002,
};

static const u32 s5k4ecgx_AF_Macro_mode_1_v1[] = {
	0x002A0288,
	0x0F1200D0,
};

static const u32 s5k4ecgx_AF_Macro_mode_2_v1[] = {
	0x002A0286,
	0x0F120004,
};

static const u32 s5k4ecgx_AF_Macro_mode_3_v1[] = {
	0x002A160C,
	0x0F129042,
	0x002A159E,
	0x0F121800,
};

static const u32 s5k4ecgx_AF_Low_Light_Mode_On_v1[] = {
	0x002A1616,
	0x0F120003,

	0x002A15A4,
	0x0F120902,

	0x002A159E,
	0x0F120C00,

	0x002A15AC,
	0x0F12002A,
	0x0F120033,
	0x0F12003C,
	0x0F120045,
	0x0F12004E,
	0x0F120057,
	0x0F120063,
	0x0F12006F,
	0x0F12007B,
	0x0F120087,
	0x0F120093,
	0x0F1200A2,
	0x0F1200B1,
};

static const u32 s5k4ecgx_AF_Low_Light_Mode_Off_v1[] = {
	0x002A1616,
	0x0F120003,

	0x002A15A4,
	0x0F120902,

	0x002A159E,
	0x0F121800,

	0x002A15AC,
	0x0F120018,
	0x0F12002A,
	0x0F120030,
	0x0F120036,
	0x0F12003C,
	0x0F120042,
	0x0F120048,
	0x0F12004E,
	0x0F120054,
	0x0F12005A,
	0x0F120060,
	0x0F120066,
	0x0F12006C,
	0x0F120072,
	0x0F120078,
	0x0F12007E,
	0x0F120084,
	0x0F12008A,
	0x0F120090,
	0x0F120096,
	0x0F12009C,
	0x0F1200A2,
	0x0F1200A8,
	0x0F1200AE,
	0x0F1200B4,
	0x0F1200BA,
};

static const u32 s5k4ecgx_Single_AF_Start_v1[] = {
	0x002A0286,
	0x0F120005,
};

static const u32 s5k4ecgx_Single_AF_Off_1_v1[] = {
	0x002A0288,
	0x0F120000,
};

static const u32 s5k4ecgx_Single_AF_Off_2_v1[] = {
	0x002A0286,
	0x0F120004,
};

static const u32 s5k4ecgx_Face_Detection_On_v1[] = {
	0x002A028E,
	0x0F120100,
	0x0F1200E3,
	0x0F120200,
	0x0F120238,
	0x0F1201C6,
	0x0F120166,
	0x0F120074,
	0x0F120132,
	0x0F120001,
};

static const u32 s5k4ecgx_Face_Detection_Off_v1[] = {
	0x002A028E,
	0x0F120100,
	0x0F1200E3,
	0x0F120200,
	0x0F120238,
	0x0F1201C6,
	0x0F120166,
	0x0F120074,
	0x0F120132,
	0x0F120001,
};

static const u32 s5k4ecgx_Low_Cap_On_v1[] = {
	0x002A09EA,
	0x0F120D58,
	0x002A0AA0,
	0x0F120A53,
};

static const u32 s5k4ecgx_Low_Cap_Off_v1[] = {
	0x002A09EA,
	0x0F120040,
	0x002A0AA0,
	0x0F120080,
};

/* restores crop settings to full resolution */
static const u32 s5k4ecgx_Reset_Crop_v1[] = {
	0x002A024C,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x0F120A00,
	0x0F120780,
	0x0F120010,
	0x0F12000C,
	0x002A048E,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,
	0x0F120A00,
	0x0F120780,
	0x0F120000,
	0x0F120000,

	0x002A025E,
	0x0F120001,
	0x0F120001,
};

static const u32 s5k4ecgx_Capture_Start_v1[] = {
	0x002A1A00,
	0x0F12185C,
	0x0F127000,
	0x002A023E,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0240,
	0x0F120001,
};

static const u32 s5k4ecgx_Preview_Return_v1[] = {
	0x002A05C4,
	0x0F120000,
	0x002A1A00,
	0x0F12192E,
	0x0F127000,
	0x002A0952,
	0x0F120000,
	0x002A023E,
	0x0F120000,
	0x002A024A,
	0x0F120001,
	0x002A0240,
	0x0F120001,
};

static const u32 s5k4ecgx_Flash_init_v1[] = {
	0x002A17DC,
	0x0F120001, /* one frame AE */

	0x002A17AE,
	0x0F120270, /* AWB R point */

	0x002A17B0,
	0x0F120210, /* AWB B point */

	0x002A17E2,
	0x0F120001, /* Flash AE tune start*/
	0x0F120030, /* 0x100 for Rin output */
	0x0F120040,
	0x0F120050,
	0x0F120060,
	0x0F120070,
	0x0F120080,
	0x0F120090,
	0x0F1200A0,
	0x0F120050, /* 0x100 for Rout output-20 */
	0x0F120014,
	0x0F12000A,
	0x0F120008,
	0x0F120005,
	0x0F120004,
	0x0F120002,
	0x0F120001,

	0x002A1824,
	0x0F120100, /* 0x100 for NB output */
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,
	0x0F120100,

	0x002A17B4,
	0x0F120100,
	0x0F1200A0,
	0x0F120080,
	0x0F120020,
	0x0F120001,

	0x002A17C8,
	0x0F120025,
	0x0F120030,
	0x0F120050,
	0x0F120070,
	0x0F120080,
};

static const u32 s5k4ecgx_Pre_Flash_Start_v1[] = {
	0x002A057C, /* set AE speed to fast */
	0x0F120000,

	0x002A1F06, /* fls_afl_FlashWP_Weight_0_  Pre_Flash_Start */
	0x0F120001,
};

static const u32 s5k4ecgx_Pre_Flash_End_v1[] = {
	0x002A057C, /* set AE speed to normal */
	0x0F120002,

	0x002A1F08, /* fls_afl_FlashWP_Weight_0_  Pre_Flash_end */
	0x0F120001,
};

static const u32 s5k4ecgx_Flash_Start_v1[] = {
	0x002A17A8,
	0x0F120001,

	0x002A047E,
	0x0F120002,

	0x002A1448,
	0x0F120027,
};

static const u32 s5k4ecgx_Flash_End_v1[] = {
	0x002A17A8,
	0x0F120000,

	0x002A047E,
	0x0F120000,

	0x002A1448,
	0x0F12003C,
};

static const u32 s5k4ecgx_5M_Capture_v1[] = {  /* 2560 x 1920 */
	0x002A0392,
	0x0F120A00,
	0x0F120780,
	0x0F120009,

	0x002A03AC,
	0x0F120002,

	0x002A03AA,
	0x0F120000,

	0x002A026C,
	0x0F120001,
};

static const u32 s5k4ecgx_3M_Capture_v1[] = {  /* 2048 x 1536 */
	0x002A0392,
	0x0F120800,
	0x0F120600,
	0x0F120009,

	0x002A03AC,
	0x0F120002,

	0x002A03AA,
	0x0F120000,

	0x002A024A,
	0x0F120001,

	0x002A026C,
	0x0F120001,
};

static const u32 s5k4ecgx_2M_Capture_v1[] = {  /* 1600 x 1200 */
	0x002A0392,
	0x0F120640,
	0x0F1204B0,
	0x0F120009,

	0x002A03AC,
	0x0F120002,

	0x002A03AA,
	0x0F120000,

	0x002A024A,
	0x0F120001,

	0x002A026C,
	0x0F120001,
};

static const u32 s5k4ecgx_1M_Capture_v1[] = {  /* 1280 x 960 */
	0x002A0392,
	0x0F120500,
	0x0F1203C0,
	0x0F120009,

	0x002A03AC,
	0x0F120002,

	0x002A03AA,
	0x0F120000,

	0x002A024A,
	0x0F120001,

	0x002A026C,
	0x0F120001,
};

static const u32 s5k4ecgx_VGA_Capture_v1[] = {  /* 640 x 480 */
	0x002A0392,
	0x0F120280,
	0x0F1201E0,
	0x0F120009,

	0x002A03AC,
	0x0F120002,

	0x002A03AA,
	0x0F120000,

	0x002A024A,
	0x0F120001,

	0x002A026C,
	0x0F120001,
};

static const u32 s5k4ecgx_720_Preview_v1[] = {  /* 720 x 480 */
	0x002A02A0,
	0x0F1202D0,
	0x0F1201E0,
	0x0F120005,
	0x002A02AE,
	0x0F120052,
	0x002A02B8,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,
	0x002A02CA,
	0x0F120000,
	0x0F120000,
	0x002A0262,
	0x0F120000,
	0x002A0266,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0264,
	0x0F120001,
};

static const u32 s5k4ecgx_640_Preview_v1[] = {  /* 640 x 480 */
	0x002A02A0,
	0x0F120280,
	0x0F1201E0,
	0x0F120005,
	0x002A02AE,
	0x0F120052,
	0x002A02B8,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,
	0x002A02CA,
	0x0F120000,
	0x0F120000,
	0x002A0262,
	0x0F120000,
	0x002A0266,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0264,
	0x0F120001,
};

static const u32 s5k4ecgx_352_Preview_v1[] = {  /* 352 x 288 */
	0x002A02A0,
	0x0F120160,
	0x0F120120,
	0x0F120005,
	0x002A02AE,
	0x0F120052,
	0x002A02B8,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,
	0x002A02CA,
	0x0F120000,
	0x0F120000,
	0x002A0262,
	0x0F120000,
	0x002A0266,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0264,
	0x0F120001,
};

static const u32 s5k4ecgx_176_Preview_v1[] = {  /* 176 x 144 */
	0x002A02A0,
	0x0F1200B0,
	0x0F120090,
	0x0F120005,
	0x002A02AE,
	0x0F120052,
	0x002A02B8,
	0x0F120000,
	0x0F120001,
	0x0F12029A,
	0x0F12014D,
	0x002A02CA,
	0x0F120000,
	0x0F120000,
	0x002A0262,
	0x0F120000,
	0x002A0266,
	0x0F120001,
	0x002A024A,
	0x0F120001,
	0x002A0264,
	0x0F120001,
};

static const u32 s5k4ecgx_AE_AWB_Lock_On_v1[] = {
	0x002A2B76,  /* AE Lock On */
	0x0F120000,
	0x002A2B7E,  /* AWB Lock On */
	0x0F120000,
};

static const u32 s5k4ecgx_AE_AWB_Lock_Off_v1[] = {
	0x002A2B76,  /* AE Lock Off */
	0x0F120001,
	0x002A2B7E,  /* AWB Lock Off */
	0x0F120001,
};

static const u32 s5k4ecgx_Get_AE_Stable_Status_v1[] = {
	0x002E2B8C,
};

static const u32 s5k4ecgx_Get_Light_Level_v1[] = {
	0x002C7000,
	0x002E2B30,
};

static const u32 s5k4ecgx_get_1st_af_search_status_v1[] = {
	0x002E2E06,
};

static const u32 s5k4ecgx_get_2nd_af_search_status_v1[] = {
	0x002E2167,
};

static const u32 s5k4ecgx_get_capture_status_v1[] = {
	0x002E1F02,
};

static const u32 s5k4ecgx_get_esd_status_v1[] = {
	0xFCFCD000,
	0x002CD000,
	0x002E0060,
};

static const u32 s5k4ecgx_get_iso_reg_v1[] = {
	0x002C7000,
	0x002E2ADC,
};

static const u32 s5k4ecgx_get_shutterspeed_reg_v1[] = {
	0x002C7000,
	0x002E2AD8,
};

#endif /* __S5K4ECGX_REGS_1_0_H__ */
