#include "INC_INCLUDES.h"

extern PLL_MODE			m_ucPLL_Mode;

static INC_UINT32 g_uiKOREnsembleFullFreq[MAX_KOREABAND_FULL_CHANNEL] = 
{
	175280,177008,178736,181280,183008,
	184736,187280,189008,190736,193280,	
	195008,196736,199280,201008,202736,
	205280,207008,208736,211280,213008,	
	214736
};

static INC_UINT32 g_uiKOREnsembleNormalFreq[MAX_KOREABAND_FULL_CHANNEL] = 
{
	181280,183008,184736,205280,207008,
	208736
};

static INC_UINT8 g_acKorI2CValue_12000[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//12000KHz 7AK.dat(175.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1C, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 7BK.dat(177.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1D, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 7CK.dat(178.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1D, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 8AK.dat(181.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1D, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 8BK.dat(183.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1E, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 8CK.dat(184.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1E, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 9AK.dat(187.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1E, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 9BK.dat(189.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1F, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 9CK.dat(190.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1F, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10AK.dat(193.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1F, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10BK.dat(195.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x20, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10CK.dat(196.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x20, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11AK.dat(199.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x20, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11BK.dat(201.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x21, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11CK.dat(202.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x21, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12AK.dat(205.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x21, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12BK.dat(207.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x22, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12CK.dat(208.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x22, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13AK.dat(211.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x22, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13BK.dat(213.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13CK.dat(214.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acKorI2CValue_19200[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//19200KHz 7AK.dat(175.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x41, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7BK.dat(177.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x44, 
		0x4D, 0x09, 0x11, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7CK.dat(178.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x47, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8AK.dat(181.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x4B, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8BK.dat(183.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x45, 
		0x4D, 0x0D, 0x99, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8CK.dat(184.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x41, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9AK.dat(187.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x45, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9BK.dat(189.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x48, 
		0x4D, 0x09, 0x11, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9CK.dat(190.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x4B, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10AK.dat(193.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x4F, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10BK.dat(195.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x42, 
		0x4D, 0x09, 0x11, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10CK.dat(196.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x45, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11AK.dat(199.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x49, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11BK.dat(201.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1F, 0x42, 
		0x4D, 0x0D, 0x99, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0x4C, 0x04, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11CK.dat(202.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x4F, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12AK.dat(205.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x43, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12BK.dat(207.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x46, 
		0x4D, 0x09, 0x11, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12CK.dat(208.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x49, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13AK.dat(211.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x4D, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13BK.dat(213.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x40, 
		0x4D, 0x09, 0x11, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13CK.dat(214.736Mhz)
		0x75, 0x9F, 0xF7, 0x74, 0x22, 0x25, 0x1C, 0x0D, 0xE4, 0xE0, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x43, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acKorI2CValue_24576[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//24576KHz 7AK.dat(175.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x43, 
		0x4D, 0x04, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7BK.dat(177.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x46, 
		0x4D, 0x10, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7CK.dat(178.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x1C, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8AK.dat(181.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x4E, 
		0x4D, 0x1B, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8BK.dat(183.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x42, 
		0x4D, 0x07, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8CK.dat(184.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x45, 
		0x4D, 0x13, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9AK.dat(187.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4A, 
		0x4D, 0x12, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9BK.dat(189.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4D, 
		0x4D, 0x1E, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9CK.dat(190.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x41, 
		0x4D, 0x0A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10AK.dat(193.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x46, 
		0x4D, 0x09, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10BK.dat(195.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x49, 
		0x4D, 0x15, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10CK.dat(196.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4D, 
		0x4D, 0x01, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11AK.dat(199.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x42, 
		0x4D, 0x00, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11BK.dat(201.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x45, 
		0x4D, 0x0C, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11CK.dat(202.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x48, 
		0x4D, 0x18, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12AK.dat(205.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4D, 
		0x4D, 0x17, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12BK.dat(207.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x41, 
		0x4D, 0x03, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12CK.dat(208.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x44, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13AK.dat(211.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x49, 
		0x4D, 0x0E, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13BK.dat(213.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x4C, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13CK.dat(214.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x40, 
		0x4D, 0x06, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acKorI2CValue_27000[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//27000KHz 7AK.dat(175.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x44, 
		0x4D, 0x16, 0x4C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7BK.dat(177.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x47, 
		0x4D, 0x18, 0x9A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7CK.dat(178.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x4A, 
		0x4D, 0x1A, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8AK.dat(181.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x4F, 
		0x4D, 0x0B, 0xA2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8BK.dat(183.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x42, 
		0x4D, 0x0D, 0xF0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8CK.dat(184.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x45, 
		0x4D, 0x10, 0x3E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9AK.dat(187.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x4A, 
		0x4D, 0x00, 0xF8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9BK.dat(189.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x4D, 
		0x4D, 0x03, 0x46, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9CK.dat(190.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x40, 
		0x4D, 0x05, 0x94, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10AK.dat(193.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x44, 
		0x4D, 0x16, 0x4C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10BK.dat(195.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x47, 
		0x4D, 0x18, 0x9A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10CK.dat(196.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x4A, 
		0x4D, 0x1A, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11AK.dat(199.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x4F, 
		0x4D, 0x0B, 0xA2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11BK.dat(201.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x42, 
		0x4D, 0x0D, 0xF0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11CK.dat(202.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x45, 
		0x4D, 0x10, 0x3E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12AK.dat(205.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4A, 
		0x4D, 0x00, 0xF8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12BK.dat(207.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4D, 
		0x4D, 0x03, 0x46, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12CK.dat(208.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x40, 
		0x4D, 0x05, 0x94, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13AK.dat(211.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x44, 
		0x4D, 0x16, 0x4C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13BK.dat(213.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x47, 
		0x4D, 0x18, 0x9A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13CK.dat(214.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4A, 
		0x4D, 0x1A, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};


INC_UINT32 g_uiBandIIIEnsemblVal[MAX_BAND_III_CHANNEL] = 
{
	174928,176640,178352,180064,181936,
	183648,185360,187072,188928,190640,
	192352,194064,195936,197648,199360,
	201072,202928,204640,206352,208064,
	209936,211648,213360,215072,210096,
	216928,218640,220352,222064,217088,
	223936,225648,227360,229072,224096,
	230784,232496,234208,235776,237488,
	239200,
};

static INC_UINT8 g_acBandIIII2CValue_12000[MAX_BAND_III_CHANNEL][RF500_REG_CTRL] = 
{
	{	//12000KHz 5A.dat(174.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1C, 0x4E, 
		0x4D, 0x03, 0x6A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 5B.dat(176.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1D, 0x42, 
		0x4D, 0x15, 0x82, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 5C.dat(178.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1D, 0x47, 
		0x4D, 0x07, 0x98, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 5D.dat(180.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1D, 0x4B, 
		0x4D, 0x19, 0xB0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 6A.dat(181.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1E, 0x40, 
		0x4D, 0x19, 0x6E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 6B.dat(183.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1E, 0x45, 
		0x4D, 0x0B, 0x86, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 6C.dat(185.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1E, 0x49, 
		0x4D, 0x1D, 0x9C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 6D.dat(187.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1E, 0x4E, 
		0x4D, 0x0F, 0xB4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 7A.dat(188.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1F, 0x43, 
		0x4D, 0x0E, 0x14, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 7B.dat(190.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1F, 0x48, 
		0x4D, 0x00, 0x2C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 7C.dat(192.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x1F, 0x4C, 
		0x4D, 0x12, 0x42, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 7D.dat(194.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x20, 0x41, 
		0x4D, 0x04, 0x5A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 8A.dat(195.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x20, 0x46, 
		0x4D, 0x04, 0x18, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 8B.dat(197.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x20, 0x4A, 
		0x4D, 0x16, 0x30, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 8C.dat(199.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x20, 0x4F, 
		0x4D, 0x08, 0x46, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 8D.dat(201.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x21, 0x43, 
		0x4D, 0x1A, 0x5E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 9A.dat(202.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x21, 0x48, 
		0x4D, 0x18, 0xC0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 9B.dat(204.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x21, 0x4D, 
		0x4D, 0x0A, 0xD6, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 9C.dat(206.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x22, 0x41, 
		0x4D, 0x1C, 0xEE, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 9D.dat(208.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x22, 0x46, 
		0x4D, 0x0F, 0x04, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10A.dat(209.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x22, 0x4B, 
		0x4D, 0x0E, 0xC4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10B.dat(211.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x40, 
		0x4D, 0x00, 0xDA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10C.dat(213.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x44, 
		0x4D, 0x12, 0xF2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10D.dat(215.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x49, 
		0x4D, 0x05, 0x08, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 10N.dat(210.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x22, 0x4B, 
		0x4D, 0x1C, 0x6A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11A.dat(216.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x4E, 
		0x4D, 0x03, 0x6A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11B.dat(218.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x24, 0x42, 
		0x4D, 0x15, 0x82, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11C.dat(220.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x24, 0x47, 
		0x4D, 0x07, 0x98, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11D.dat(222.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x24, 0x4B, 
		0x4D, 0x19, 0xB0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 11N.dat(217.088Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x4E, 
		0x4D, 0x11, 0x12, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12A.dat(223.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x40, 
		0x4D, 0x19, 0x6E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12B.dat(225.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x45, 
		0x4D, 0x0B, 0x86, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12C.dat(227.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x49, 
		0x4D, 0x1D, 0x9C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12D.dat(229.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x4E, 
		0x4D, 0x0F, 0xB4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 12N.dat(224.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x41, 
		0x4D, 0x07, 0x16, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13A.dat(230.784Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x26, 0x43, 
		0x4D, 0x01, 0xCA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13B.dat(232.496Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x26, 0x47, 
		0x4D, 0x13, 0xE2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13C.dat(234.208Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x26, 0x4C, 
		0x4D, 0x05, 0xFA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13D.dat(235.776Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x27, 0x40, 
		0x4D, 0x0B, 0xC6, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13E.dat(237.488Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x27, 0x44, 
		0x4D, 0x1D, 0xDE, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz 13F.dat(239.200Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x27, 0x49, 
		0x4D, 0x0F, 0xF6, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acBandIIII2CValue_19200[MAX_BAND_III_CHANNEL][RF500_REG_CTRL] = 
{
	{	//19200KHz 5A.dat(174.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x40, 
		0x4D, 0x1A, 0x22, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 5B.dat(176.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x43, 
		0x4D, 0x15, 0x70, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 5C.dat(178.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x46, 
		0x4D, 0x10, 0xC0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 5D.dat(180.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x49, 
		0x4D, 0x0C, 0x0E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 6A.dat(181.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x4C, 
		0x4D, 0x0F, 0xE4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 6B.dat(183.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x12, 0x4F, 
		0x4D, 0x0B, 0x34, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 6C.dat(185.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x42, 
		0x4D, 0x06, 0x82, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 6D.dat(187.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x45, 
		0x4D, 0x01, 0xD0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7A.dat(188.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x48, 
		0x4D, 0x04, 0xCC, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7B.dat(190.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x4B, 
		0x4D, 0x00, 0x1C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7C.dat(192.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x13, 0x4D, 
		0x4D, 0x1B, 0x6A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7D.dat(194.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x40, 
		0x4D, 0x16, 0xB8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8A.dat(195.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x43, 
		0x4D, 0x1A, 0x90, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8B.dat(197.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x46, 
		0x4D, 0x15, 0xDE, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8C.dat(199.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x49, 
		0x4D, 0x11, 0x2C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8D.dat(201.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x4C, 
		0x4D, 0x0C, 0x7A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9A.dat(202.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x14, 0x4F, 
		0x4D, 0x0F, 0x78, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9B.dat(204.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x42, 
		0x4D, 0x0A, 0xC6, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9C.dat(206.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x45, 
		0x4D, 0x06, 0x16, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9D.dat(208.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x48, 
		0x4D, 0x01, 0x64, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10A.dat(209.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x4B, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10B.dat(211.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x4E, 
		0x4D, 0x00, 0x88, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10C.dat(213.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x40, 
		0x4D, 0x1B, 0xD8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10D.dat(215.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x43, 
		0x4D, 0x17, 0x26, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10N.dat(210.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x15, 0x4B, 
		0x4D, 0x0D, 0xC2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11A.dat(216.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x46, 
		0x4D, 0x1A, 0x22, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11B.dat(218.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x49, 
		0x4D, 0x15, 0x70, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11C.dat(220.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x4C, 
		0x4D, 0x10, 0xC0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11D.dat(222.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x4F, 
		0x4D, 0x0C, 0x0E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11N.dat(217.088Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x47, 
		0x4D, 0x02, 0xAC, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12A.dat(223.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x42, 
		0x4D, 0x0F, 0xE4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12B.dat(225.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x45, 
		0x4D, 0x0B, 0x34, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12C.dat(227.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x48, 
		0x4D, 0x06, 0x82, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12D.dat(229.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x4B, 
		0x4D, 0x01, 0xD0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12N.dat(224.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x42, 
		0x4D, 0x18, 0x6E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13A.dat(230.784Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x4D, 
		0x4D, 0x1D, 0x1E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13B.dat(232.496Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x40, 
		0x4D, 0x18, 0x6E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13C.dat(234.208Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x43, 
		0x4D, 0x13, 0xBC, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13D.dat(235.776Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x46, 
		0x4D, 0x07, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13E.dat(237.488Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x49, 
		0x4D, 0x02, 0xAA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13F.dat(239.200Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x4B, 
		0x4D, 0x1D, 0xFA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acBandIIII2CValue_24576[MAX_BAND_III_CHANNEL][RF500_REG_CTRL] = 
{
	{	//24576KHz 5A.dat(174.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x42, 
		0x4D, 0x0E, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 5B.dat(176.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x45, 
		0x4D, 0x19, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 5C.dat(178.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x04, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 5D.dat(180.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x4C, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 6A.dat(181.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x40, 
		0x4D, 0x04, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 6B.dat(183.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x43, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 6C.dat(185.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x46, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 6D.dat(187.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4A, 
		0x4D, 0x05, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7A.dat(188.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4D, 
		0x4D, 0x19, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7B.dat(190.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x41, 
		0x4D, 0x04, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7C.dat(192.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x44, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7D.dat(194.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x47, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8A.dat(195.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4B, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8B.dat(197.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4E, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8C.dat(199.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x42, 
		0x4D, 0x05, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8D.dat(201.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x45, 
		0x4D, 0x10, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9A.dat(202.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x49, 
		0x4D, 0x04, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9B.dat(204.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4C, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9C.dat(206.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4F, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9D.dat(208.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x43, 
		0x4D, 0x05, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10A.dat(209.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x46, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10B.dat(211.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x4A, 
		0x4D, 0x05, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10C.dat(213.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x4D, 
		0x4D, 0x10, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10D.dat(215.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x40, 
		0x4D, 0x1B, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10N.dat(210.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x47, 
		0x4D, 0x04, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11A.dat(216.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x44, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11B.dat(218.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x47, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11C.dat(220.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x4B, 
		0x4D, 0x05, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11D.dat(222.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x4E, 
		0x4D, 0x10, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11N.dat(217.088Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x44, 
		0x4D, 0x19, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12A.dat(223.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x42, 
		0x4D, 0x05, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12B.dat(225.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x45, 
		0x4D, 0x10, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12C.dat(227.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x48, 
		0x4D, 0x1B, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12D.dat(229.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x4C, 
		0x4D, 0x06, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12N.dat(224.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x42, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13A.dat(230.784Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x4F, 
		0x4D, 0x11, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13B.dat(232.496Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x42, 
		0x4D, 0x1C, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13C.dat(234.208Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x46, 
		0x4D, 0x07, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13D.dat(235.776Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x49, 
		0x4D, 0x09, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13E.dat(237.488Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x4C, 
		0x4D, 0x14, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13F.dat(239.200Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x4F, 
		0x4D, 0x1F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acBandIIII2CValue_27000[MAX_BAND_III_CHANNEL][RF500_REG_CTRL] = 
{
	{	//27000KHz 5A.dat(174.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x4D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x44, 
		0x4D, 0x02, 0x46, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 5B.dat(176.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x47, 
		0x4D, 0x03, 0xAC, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x07, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 5C.dat(178.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x4A, 
		0x4D, 0x05, 0x10, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 5D.dat(180.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x13, 0x4D, 
		0x4D, 0x06, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x06, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 6A.dat(181.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x40, 
		0x4D, 0x10, 0xF4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 6B.dat(183.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x43, 
		0x4D, 0x12, 0x58, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x06, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 6C.dat(185.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x46, 
		0x4D, 0x13, 0xBE, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x05, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 6D.dat(187.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x49, 
		0x4D, 0x15, 0x22, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7A.dat(188.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x14, 0x4C, 
		0x4D, 0x1E, 0xB8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7B.dat(190.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x40, 
		0x4D, 0x00, 0x1E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7C.dat(192.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x43, 
		0x4D, 0x01, 0x82, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7D.dat(194.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x46, 
		0x4D, 0x02, 0xE6, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x04, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xF3, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8A.dat(195.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x0D, 0x66, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8B.dat(197.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x4C, 
		0x4D, 0x0E, 0xCA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x00, 0x05, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8C.dat(199.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x15, 0x4F, 
		0x4D, 0x10, 0x30, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x04, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8D.dat(201.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x42, 
		0x4D, 0x11, 0x94, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9A.dat(202.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x45, 
		0x4D, 0x1B, 0x2A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9B.dat(204.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x48, 
		0x4D, 0x1C, 0x8E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9C.dat(206.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4B, 
		0x4D, 0x1D, 0xF4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9D.dat(208.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x16, 0x4E, 
		0x4D, 0x1F, 0x58, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10A.dat(209.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x42, 
		0x4D, 0x09, 0xD8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10B.dat(211.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x45, 
		0x4D, 0x0B, 0x3C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10C.dat(213.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x48, 
		0x4D, 0x0C, 0xA2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10D.dat(215.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4B, 
		0x4D, 0x0E, 0x06, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10N.dat(210.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x42, 
		0x4D, 0x12, 0xF2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11A.dat(216.928Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4E, 
		0x4D, 0x17, 0x9C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11B.dat(218.640Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x41, 
		0x4D, 0x19, 0x00, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11C.dat(220.352Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x44, 
		0x4D, 0x1A, 0x66, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11D.dat(222.064Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x47, 
		0x4D, 0x1B, 0xCA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11N.dat(217.088Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4F, 
		0x4D, 0x00, 0xB6, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12A.dat(223.936Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4B, 
		0x4D, 0x06, 0x4A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12B.dat(225.648Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4E, 
		0x4D, 0x07, 0xAE, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12C.dat(227.360Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x41, 
		0x4D, 0x09, 0x12, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12D.dat(229.072Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x44, 
		0x4D, 0x0A, 0x78, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12N.dat(224.096Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4B, 
		0x4D, 0x0F, 0x64, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13A.dat(230.784Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x47, 
		0x4D, 0x0B, 0xDC, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13B.dat(232.496Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x4A, 
		0x4D, 0x0D, 0x42, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13C.dat(234.208Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x4D, 
		0x4D, 0x0E, 0xA6, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13D.dat(235.776Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x40, 
		0x4D, 0x07, 0xDA, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13E.dat(237.488Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x43, 
		0x4D, 0x09, 0x3E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13F.dat(239.200Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x46, 
		0x4D, 0x0A, 0xA4, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};


static INC_UINT32 g_uiLBandEnsemblVal[MAX_L_BAND_CHANNEL] = 
{
	1452960,1454672,1456384,1458096,1459808,
	1461520,1463232,1464944,1466656,1468368,
	1470080,1471792,1473504,1475216,1476928,
	1478640,1480352,1482064,1483776,1485488,
	1487200,1488912,1490624
};

static INC_UINT8 g_acLBandI2CValue_19200[MAX_L_BAND_CHANNEL][RF500_REG_CTRL] = 
{
	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x11, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x42, 0x50, 0x53, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x11, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x42, 0x50, 0xBE, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x11, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x43, 0x50, 0x29, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x04, 
		0x00, 0x1D, 0x4A, 0x50, 0x1B, 0x80, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0x77, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x44, 0x4A, 0x00, 0x00, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x06, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0x77, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x44, 0x50, 0x6A, 0xA2, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x44, 0x50, 0xD5, 0xAC, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x45, 0x50, 0x40, 0x9E, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x04, 
		0x00, 0x1D, 0x4C, 0x50, 0xE4, 0xD6, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x46, 0x50, 0x16, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x46, 0x50, 0x81, 0xA2, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x46, 0x50, 0xEC, 0x9E, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x47, 0x50, 0x57, 0xA2, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x47, 0x50, 0xC2, 0x9E, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x48, 0x50, 0x2D, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x48, 0x50, 0x98, 0xA2, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x49, 0x50, 0x03, 0x9E, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x49, 0x50, 0x6E, 0x9E, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x02, 
		0x00, 0x0F, 0x41, 0x50, 0x3B, 0xC0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x02, 
		0x00, 0x0F, 0x41, 0x50, 0x83, 0x14, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x03, 
		0x00, 0x16, 0x4A, 0x50, 0xAF, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0xF7, 0x0E, 0x00, 0x35, 0x10, 0x02, 
		0x00, 0x0F, 0x42, 0x50, 0x11, 0xC0, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x9C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xFE, 0xEE, 0xEE, 0x01, 0x0F, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x47, 0x04, 0x00, 0xF0, 0x77, 0x0E, 0x00, 0x35, 0x10, 0x02, 
		0x00, 0x0F, 0x42, 0x50, 0x59, 0x14, 0x04, 0xB0, 0x4F, 0x00, 0x08, 0x10, 0x27, 0x12, 0x0B, 0x16, 
		0x00, 0x20, 0x08, 0x08, 0xE1, 0x43, 0x44, 0x40, 0x00, 0x00, 0x18, 0x00, 0x2C, 0x24, 0x2C, 0x2F, 
		0xFF, 0x77, 0x59, 0xAA, 0xFF, 0xF3, 0x1C, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},
};

static INC_UINT32 g_uiChinaEnsemblVal[MAX_CHINA_CHANNEL] = 
{
	168160,169872,171584,173296,175008,
	176720,178432,180144,181856,184160,
	185872,187584,189296,191008,192720,
	194432,196144,197856,200160,201872,
	203584,205296,207008,208720,210432,
	212144,213856,216432,218144,219856,
	221568,
};

static INC_UINT8 g_acChinaI2CValue_19200[MAX_CHINA_CHANNEL][RF500_REG_CTRL] = 
{
	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x6C, 0x1A, 0x70, 0x03, 
		0x00, 0x14, 0x45, 0x4D, 0x07, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x6C, 0x1A, 0x70, 0x03, 
		0x00, 0x14, 0x48, 0x4D, 0x12, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x59, 0x1A, 0x70, 0x04, 
		0x00, 0x1B, 0x4A, 0x4D, 0x12, 0x2A, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x59, 0x1A, 0x70, 0x03, 
		0x00, 0x14, 0x4F, 0x4D, 0x08, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x69, 0x1A, 0x70, 0x03, 
		0x00, 0x15, 0x42, 0x4D, 0x13, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x69, 0x1A, 0x70, 0x03, 
		0x00, 0x15, 0x45, 0x4D, 0x1E, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x59, 0x1A, 0x70, 0x03, 
		0x00, 0x15, 0x49, 0x4D, 0x09, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x48, 0x1A, 0x70, 0x02, 
		0x00, 0x0E, 0x48, 0x4D, 0x0D, 0xC0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x02, 0x00, 0xF0, 0xF7, 0x00, 0x48, 0x1A, 0x70, 0x03, 
		0x00, 0x15, 0x4F, 0x4D, 0x1F, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x37, 0x1A, 0x70, 0x03, 
		0x00, 0x16, 0x44, 0x4D, 0x0F, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x37, 0x1A, 0x70, 0x03, 
		0x00, 0x16, 0x47, 0x4D, 0x1A, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x37, 0x1A, 0x70, 0x02, 
		0x00, 0x0F, 0x42, 0x4D, 0x03, 0xC0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x02, 0x00, 0x14, 0x3C, 0x00, 0x37, 0x1A, 0x70, 0x02, 
		0x00, 0x0F, 0x44, 0x4D, 0x0B, 0x16, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x37, 0x1A, 0x70, 0x03, 
		0x00, 0x17, 0x41, 0x4D, 0x1B, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x02, 0x00, 0x14, 0x3C, 0x00, 0x37, 0x1A, 0x70, 0x03, 
		0x00, 0x17, 0x45, 0x4D, 0x06, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x37, 0x1A, 0x70, 0x03, 
		0x00, 0x17, 0x48, 0x4D, 0x11, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x02, 0x00, 0x14, 0x3C, 0x00, 0x37, 0x1A, 0x70, 0x04, 
		0x00, 0x1F, 0x4A, 0x4D, 0x10, 0xD4, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x37, 0x1A, 0x70, 0x03, 
		0x00, 0x17, 0x4F, 0x4D, 0x07, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x36, 0x1A, 0x70, 0x03, 
		0x00, 0x18, 0x43, 0x4D, 0x17, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x36, 0x1A, 0x70, 0x03, 
		0x00, 0x18, 0x47, 0x4D, 0x02, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x16, 0x1A, 0x70, 0x03, 
		0x00, 0x18, 0x4A, 0x4D, 0x0D, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x15, 0x1A, 0x70, 0x02, 
		0x00, 0x10, 0x49, 0x4D, 0x05, 0xC0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x15, 0x1A, 0x70, 0x03, 
		0x00, 0x19, 0x41, 0x4D, 0x03, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x15, 0x1A, 0x70, 0x03, 
		0x00, 0x19, 0x44, 0x4D, 0x0E, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x15, 0x1A, 0x70, 0x03, 
		0x00, 0x19, 0x47, 0x4D, 0x19, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x15, 0x1A, 0x70, 0x02, 
		0x00, 0x11, 0x42, 0x4D, 0x03, 0x16, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x02, 0x00, 0xF0, 0xF7, 0x00, 0x15, 0x1A, 0x70, 0x02, 
		0x00, 0x11, 0x44, 0x4D, 0x0A, 0x6B, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xE0, 0xF7, 0x00, 0x14, 0x1A, 0x70, 0x03, 
		0x00, 0x1A, 0x43, 0x4D, 0x10, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x00, 0x14, 0x1A, 0x70, 0x03, 
		0x00, 0x1A, 0x46, 0x4D, 0x1B, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x01, 0x14, 0x1A, 0x70, 0x03, 
		0x00, 0x13, 0x4F, 0x4D, 0x14, 0xF8, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{
		0x00, 0x00, 0xEF, 0xFF, 0x00, 0x05, 0xEE, 0xEE, 0xEE, 0xEE, 0xFE, 0xEE, 0xEE, 0xEE, 0x00, 0x00, 
		0x2E, 0x20, 0xF5, 0x70, 0x01, 0xF4, 0x49, 0x04, 0x00, 0xF0, 0xF7, 0x01, 0x14, 0x1A, 0x70, 0x04, 
		0x00, 0x1A, 0x4D, 0x4D, 0x11, 0xA0, 0x04, 0xB0, 0x4F, 0x00, 0x09, 0x10, 0x27, 0x32, 0x0B, 0x16, 
		0x00, 0x20, 0x38, 0x38, 0xE0, 0x23, 0x44, 0x40, 0x00, 0x00, 0x0B, 0x00, 0x1C, 0x3C, 0x24, 0x27, 
		0xFF, 0x70, 0x59, 0xAA, 0xFF, 0xF7, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6C, 0x0F, 
		0xE0, 0x00, 0x00, 0xDC, 0x05, 0x00, 0x99, 0x40, 0xDC, 0x05, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},
};

static INC_UINT32 g_uiRoamingEnsemblVal[MAX_ROAMING_CHANNEL] = 
{
	217280,219008,220736,223280,225008,
	226736,229280,231008,232736,235280,
	237008, 238736
};

static INC_UINT8 g_acRoamingI2CValue_12000[MAX_ROAMING_CHANNEL][RF500_REG_CTRL] = 
{
	{	//12000KHz R1.dat(217.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x23, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R2.dat(219.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x24, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R3.dat(220.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x24, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R4.dat(223.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x24, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R5.dat(225.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R6.dat(226.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R7.dat(229.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x25, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R8.dat(231.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x26, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R9.dat(232.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x26, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R10.dat(235.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x26, 0x4F, 
		0x4D, 0x01, 0x74, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R11.dat(237.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x27, 0x43, 
		0x4D, 0x14, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//12000KHz R12.dat(238.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x34, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x27, 0x48, 
		0x4D, 0x08, 0x5C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acRoamingI2CValue_19200[MAX_ROAMING_CHANNEL][RF500_REG_CTRL] = 
{
	{	//19200KHz R1.dat(217.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x47, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R2.dat(219.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x4A, 
		0x4D, 0x09, 0x12, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R3.dat(220.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x16, 0x4D, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R4.dat(223.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x41, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R5.dat(225.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x44, 
		0x4D, 0x09, 0x12, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R6.dat(226.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x47, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R7.dat(229.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x4B, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R8.dat(231.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x17, 0x4E, 
		0x4D, 0x09, 0x12, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R9.dat(232.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x41, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R10.dat(235.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x45, 
		0x4D, 0x0C, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R11.dat(237.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x48, 
		0x4D, 0x09, 0x12, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz R12.dat(238.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x53, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x02, 0x00, 0x18, 0x4B, 
		0x4D, 0x05, 0x3A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acRoamingI2CValue_24576[MAX_ROAMING_CHANNEL][RF500_REG_CTRL] = 
{
	{	//24576KHz R1.dat(217.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x45, 
		0x4D, 0x05, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R2.dat(219.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x48, 
		0x4D, 0x11, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R3.dat(220.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x4B, 
		0x4D, 0x1D, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R4.dat(223.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x40, 
		0x4D, 0x1C, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R5.dat(225.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x44, 
		0x4D, 0x08, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R6.dat(226.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x47, 
		0x4D, 0x14, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R7.dat(229.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x4C, 
		0x4D, 0x13, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R8.dat(231.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1B, 0x4F, 
		0x4D, 0x1F, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R9.dat(232.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x43, 
		0x4D, 0x0B, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R10.dat(235.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x48, 
		0x4D, 0x0A, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R11.dat(237.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x4B, 
		0x4D, 0x16, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz R12.dat(238.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x6A, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1C, 0x4F, 
		0x4D, 0x02, 0xA0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acRoamingI2CValue_27000[MAX_ROAMING_CHANNEL][RF500_REG_CTRL] = 
{
	{	//27000KHz R1.dat(217.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x17, 0x4F, 
		0x4D, 0x0B, 0xA2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R2.dat(219.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x42, 
		0x4D, 0x0D, 0xF0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R3.dat(220.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x45, 
		0x4D, 0x10, 0x3E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R4.dat(223.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4A, 
		0x4D, 0x00, 0xF8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R5.dat(225.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x18, 0x4D, 
		0x4D, 0x03, 0x46, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R6.dat(226.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x40, 
		0x4D, 0x05, 0x93, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R7.dat(229.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x44, 
		0x4D, 0x16, 0x4C, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R8.dat(231.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x47, 
		0x4D, 0x18, 0x9A, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R9.dat(232.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x4A, 
		0x4D, 0x1A, 0xE8, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R10.dat(235.280Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x19, 0x4F, 
		0x4D, 0x0B, 0xA2, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R11.dat(237.008Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x42, 
		0x4D, 0x0D, 0xF0, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz R12.dat(238.736Mhz)
		0x55, 0x9F, 0xF7, 0x74, 0x23, 0x25, 0x1C, 0x0D, 0xE4, 0xE8, 0xEE, 0xEE, 0xEC, 0xEC, 0x80, 0xC0, 
		0x75, 0x7F, 0x03, 0xE8, 0x2C, 0xF2, 0x45, 0x3F, 0xCA, 0x01, 0x31, 0xE0, 0x03, 0x00, 0x1A, 0x45, 
		0x4D, 0x10, 0x3E, 0x01, 0xF4, 0x4B, 0x0F, 0x38, 0x4A, 0x00, 0x00, 0x00, 0x03, 0x02, 0x02, 0x8B, 
		0x18, 0x84, 0x00, 0x38, 0x15, 0xFF, 0x00, 0x00, 0x00, 0xB8, 0x3A, 0xBF, 0x88, 0x00, 0x07, 0x07, 
		0x03, 0x02, 0x02, 0x3E, 0x37, 0x3E, 0x36, 0x36, 0x36, 0x12, 0x43, 0x80, 0x00, 0x00, 0x0C, 0xFF, 
		0xE0, 0x00, 0x00, 0x4C, 0x04, 0x00, 0x99, 0x40, 0xE8, 0x03, 0x00, 0x20, 0x80, 0x06, 0x60, 0x40, 
		0x08, 0x64, 0x0F, 0xCB, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	},
};

INC_UINT32 INC_GET_KOREABAND_FULL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_FULL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleFullFreq[uiIndex];
}

INC_UINT32 INC_GET_KOREABAND_NORMAL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_NORMAL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleNormalFreq[uiIndex];
}

INC_UINT16 INC_FIND_LBAND_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_L_BAND_CHANNEL; uiLoop++){
		if(g_uiLBandEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT16 INC_FIND_CHINA_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_CHINA_CHANNEL; uiLoop++){
		if(g_uiChinaEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT16 INC_FIND_ROAMING_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_ROAMING_CHANNEL; uiLoop++){
		if(g_uiRoamingEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT16 INC_FIND_BANDIII_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_BAND_III_CHANNEL; uiLoop++){
		if(g_uiBandIIIEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT16 INC_FIND_KOR_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_KOREABAND_FULL_CHANNEL; uiLoop++){
		if(g_uiKOREnsembleFullFreq[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT8 INC_RF500_I2C_WRITE(INC_UINT8 ucI2CID, INC_UINT8 *pucData, INC_UINT32 uLength)
{
	INC_INT16 nLoop;
	for(nLoop = 0 ;nLoop < (INC_INT16)uLength; nLoop++){
		INC_CMD_WRITE(ucI2CID, APB_RF_BASE+nLoop, (INC_UINT16)pucData[nLoop]);
	}

	return INC_SUCCESS;
}

INC_UINT8 INC_RF500_START(INC_UINT8 ucI2CID, INC_UINT32 ulRFChannel, ENSEMBLE_BAND ucBand)
{
	INC_UINT16 uiPos;
	INC_UINT8* pDataBuff = INC_NULL;

	if(ucBand == KOREA_BAND_ENABLE){
		uiPos = INC_FIND_KOR_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_12000KHZ : pDataBuff = g_acKorI2CValue_12000[uiPos]; break;
		case INPUT_CLOCK_19200KHZ : pDataBuff = g_acKorI2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : pDataBuff = g_acKorI2CValue_24576[uiPos]; break;
		case INPUT_CLOCK_27000KHZ : pDataBuff = g_acKorI2CValue_27000[uiPos]; break;
		default : pDataBuff = g_acKorI2CValue_19200[uiPos]; break;
		}
	}
	else if(ucBand == BANDIII_ENABLE){
		uiPos = INC_FIND_BANDIII_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_12000KHZ : pDataBuff = g_acBandIIII2CValue_12000[uiPos]; break;
		case INPUT_CLOCK_19200KHZ : pDataBuff = g_acBandIIII2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : pDataBuff = g_acBandIIII2CValue_24576[uiPos]; break;
		case INPUT_CLOCK_27000KHZ : pDataBuff = g_acBandIIII2CValue_27000[uiPos]; break;
		default : pDataBuff = g_acBandIIII2CValue_19200[uiPos]; break;
		}
	}
	else if(ucBand == LBAND_ENABLE){
		uiPos = INC_FIND_LBAND_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_12000KHZ : 
		case INPUT_CLOCK_19200KHZ : 
		case INPUT_CLOCK_24576KHZ : 
		case INPUT_CLOCK_27000KHZ : pDataBuff = g_acLBandI2CValue_19200[uiPos]; break;
		default : pDataBuff = g_acLBandI2CValue_19200[uiPos]; break;
		}
	}
    else if(ucBand == CHINA_ENABLE){
		uiPos = INC_FIND_CHINA_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_12000KHZ : 
		case INPUT_CLOCK_19200KHZ : 
		case INPUT_CLOCK_24576KHZ : 
		case INPUT_CLOCK_27000KHZ : pDataBuff = g_acChinaI2CValue_19200[uiPos]; break;
		default : pDataBuff = g_acChinaI2CValue_19200[uiPos]; break;
		}
	}
    else if(ucBand == ROAMING_ENABLE){
		uiPos = INC_FIND_ROAMING_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_12000KHZ : pDataBuff = g_acRoamingI2CValue_12000[uiPos]; break;
		case INPUT_CLOCK_19200KHZ : pDataBuff = g_acRoamingI2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : pDataBuff = g_acRoamingI2CValue_24576[uiPos]; break;
		case INPUT_CLOCK_27000KHZ : pDataBuff = g_acRoamingI2CValue_27000[uiPos]; break;
		default : pDataBuff = g_acRoamingI2CValue_19200[uiPos]; break;
		}
	}
	else if(ucBand == EXTERNAL_ENABLE) return INC_SUCCESS;
	else return INC_ERROR;

	if(pDataBuff == INC_NULL) return INC_ERROR;

	if(INC_RF500_I2C_WRITE(ucI2CID, pDataBuff, RF500_REG_CTRL) == INC_ERROR) return INC_ERROR;

	return INC_SUCCESS;
}


