/* linux/arch/arm/mach-s5pv210/include/mach/regs-gpio.h
 *
 * Copyright (c) 2010 Samsung Electronics Co., Ltd.
 *		http://www.samsung.com
 *
 * S5PV210 - GPIO (including EINT) register definitions
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_REGS_GPIO_H
#define __ASM_ARCH_REGS_GPIO_H __FILE__

#include <mach/map.h>


/* Base addresses for each of the banks */

#define S5PV210_GPA0_BASE		(S5P_VA_GPIO + 0x000)
#define S5PV210_GPA1_BASE		(S5P_VA_GPIO + 0x020)
#define S5PV210_GPB_BASE 		(S5P_VA_GPIO + 0x040)
#define S5PV210_GPC0_BASE		(S5P_VA_GPIO + 0x060)
#define S5PV210_GPC1_BASE		(S5P_VA_GPIO + 0x080)
#define S5PV210_GPD0_BASE		(S5P_VA_GPIO + 0x0A0)
#define S5PV210_GPD1_BASE		(S5P_VA_GPIO + 0x0C0)
#define S5PV210_GPE0_BASE		(S5P_VA_GPIO + 0x0E0)
#define S5PV210_GPE1_BASE		(S5P_VA_GPIO + 0x100)
#define S5PV210_GPF0_BASE		(S5P_VA_GPIO + 0x120)
#define S5PV210_GPF1_BASE		(S5P_VA_GPIO + 0x140)
#define S5PV210_GPF2_BASE		(S5P_VA_GPIO + 0x160)
#define S5PV210_GPF3_BASE		(S5P_VA_GPIO + 0x180)
#define S5PV210_GPG0_BASE		(S5P_VA_GPIO + 0x1A0)
#define S5PV210_GPG1_BASE		(S5P_VA_GPIO + 0x1C0)
#define S5PV210_GPG2_BASE		(S5P_VA_GPIO + 0x1E0)
#define S5PV210_GPG3_BASE		(S5P_VA_GPIO + 0x200)
#define S5PV210_GPH0_BASE		(S5P_VA_GPIO + 0xC00)
#define S5PV210_GPH1_BASE		(S5P_VA_GPIO + 0xC20)
#define S5PV210_GPH2_BASE		(S5P_VA_GPIO + 0xC40)
#define S5PV210_GPH3_BASE		(S5P_VA_GPIO + 0xC60)
#define S5PV210_GPI_BASE 		(S5P_VA_GPIO + 0x220)
#define S5PV210_GPJ0_BASE		(S5P_VA_GPIO + 0x240)
#define S5PV210_GPJ1_BASE		(S5P_VA_GPIO + 0x260)
#define S5PV210_GPJ2_BASE		(S5P_VA_GPIO + 0x280)
#define S5PV210_GPJ3_BASE		(S5P_VA_GPIO + 0x2A0)
#define S5PV210_GPJ4_BASE		(S5P_VA_GPIO + 0x2C0)
#define S5PV210_MP01_BASE		(S5P_VA_GPIO + 0x2E0)
#define S5PV210_MP02_BASE		(S5P_VA_GPIO + 0x300)
#define S5PV210_MP03_BASE		(S5P_VA_GPIO + 0x320)
#define S5PV210_MP04_BASE		(S5P_VA_GPIO + 0x340)
#define S5PV210_MP05_BASE		(S5P_VA_GPIO + 0x360)
#define S5PV210_MP06_BASE		(S5P_VA_GPIO + 0x380)
#define S5PV210_MP07_BASE		(S5P_VA_GPIO + 0x3A0)
#define S5PV210_MP10_BASE		(S5P_VA_GPIO + 0x3C0)
#define S5PV210_MP11_BASE		(S5P_VA_GPIO + 0x3E0)
#define S5PV210_MP12_BASE		(S5P_VA_GPIO + 0x400)
#define S5PV210_MP13_BASE		(S5P_VA_GPIO + 0x420)
#define S5PV210_MP14_BASE		(S5P_VA_GPIO + 0x440)
#define S5PV210_MP15_BASE		(S5P_VA_GPIO + 0x460)
#define S5PV210_MP16_BASE		(S5P_VA_GPIO + 0x480)
#define S5PV210_MP17_BASE		(S5P_VA_GPIO + 0x4A0)
#define S5PV210_MP18_BASE		(S5P_VA_GPIO + 0x4C0)
#define S5PV210_MP20_BASE		(S5P_VA_GPIO + 0x4E0)
#define S5PV210_MP21_BASE		(S5P_VA_GPIO + 0x500)
#define S5PV210_MP22_BASE		(S5P_VA_GPIO + 0x520)
#define S5PV210_MP23_BASE		(S5P_VA_GPIO + 0x540)
#define S5PV210_MP24_BASE		(S5P_VA_GPIO + 0x560)
#define S5PV210_MP25_BASE		(S5P_VA_GPIO + 0x580)
#define S5PV210_MP26_BASE		(S5P_VA_GPIO + 0x5A0)
#define S5PV210_MP27_BASE		(S5P_VA_GPIO + 0x5C0)
#define S5PV210_MP28_BASE		(S5P_VA_GPIO + 0x5E0)
#define S5PV210_ETC0_BASE		(S5P_VA_GPIO + 0x600)
#define S5PV210_ETC1_BASE		(S5P_VA_GPIO + 0x620)
#define S5PV210_ETC2_BASE		(S5P_VA_GPIO + 0x640)
#define S5PV210_ETC4_BASE		(S5P_VA_GPIO + 0x660)

#define S5PV210_GPA0_INT_CON		(S5P_VA_GPIO + 0x700)
#define S5PV210_GPA0_INT_FLTCON0		(S5P_VA_GPIO + 0x800)
#define S5PV210_GPA0_INT_FLTCON1		(S5P_VA_GPIO + 0x804)
#define S5PV210_GPA0_INT_MASK		(S5P_VA_GPIO + 0x900)
#define S5PV210_GPA0_INT_PEND		(S5P_VA_GPIO + 0xA00)
#define S5PV210_GPA0_INT_FIXPRI		(S5P_VA_GPIO + 0xB14)

#define S5PV210_GPA1_INT_CON		(S5P_VA_GPIO + 0x704)
#define S5PV210_GPA1_INT_FLTCON0		(S5P_VA_GPIO + 0x808)
#define S5PV210_GPA1_INT_FLTCON1		(S5P_VA_GPIO + 0x80C)
#define S5PV210_GPA1_INT_MASK		(S5P_VA_GPIO + 0x904)
#define S5PV210_GPA1_INT_PEND		(S5P_VA_GPIO + 0xA04)
#define S5PV210_GPA1_INT_FIXPRI		(S5P_VA_GPIO + 0xB18)

#define S5PV210_GPB_INT_CON		(S5P_VA_GPIO + 0x708)
#define S5PV210_GPB_INT_FLTCON0		(S5P_VA_GPIO + 0x810)
#define S5PV210_GPB_INT_FLTCON1		(S5P_VA_GPIO + 0x814)
#define S5PV210_GPB_INT_MASK		(S5P_VA_GPIO + 0x908)
#define S5PV210_GPB_INT_PEND		(S5P_VA_GPIO + 0xA08)
#define S5PV210_GPB_INT_FIXPRI		(S5P_VA_GPIO + 0xB1C)

#define S5PV210_GPC0_INT_CON		(S5P_VA_GPIO + 0x70C)
#define S5PV210_GPC0_INT_FLTCON0		(S5P_VA_GPIO + 0x818)
#define S5PV210_GPC0_INT_FLTCON1		(S5P_VA_GPIO + 0x81C)
#define S5PV210_GPC0_INT_MASK		(S5P_VA_GPIO + 0x90C)
#define S5PV210_GPC0_INT_PEND		(S5P_VA_GPIO + 0xA0C)
#define S5PV210_GPC0_INT_FIXPRI		(S5P_VA_GPIO + 0xB20)

#define S5PV210_GPC1_INT_CON		(S5P_VA_GPIO + 0x710)
#define S5PV210_GPC1_INT_FLTCON0		(S5P_VA_GPIO + 0x820)
#define S5PV210_GPC1_INT_FLTCON1		(S5P_VA_GPIO + 0x824)
#define S5PV210_GPC1_INT_MASK		(S5P_VA_GPIO + 0x910)
#define S5PV210_GPC1_INT_PEND		(S5P_VA_GPIO + 0xA10)
#define S5PV210_GPC1_INT_FIXPRI		(S5P_VA_GPIO + 0xB24)

#define S5PV210_GPD0_INT_CON		(S5P_VA_GPIO + 0x714)
#define S5PV210_GPD0_INT_FLTCON0		(S5P_VA_GPIO + 0x828)
#define S5PV210_GPD0_INT_FLTCON1		(S5P_VA_GPIO + 0x82C)
#define S5PV210_GPD0_INT_MASK		(S5P_VA_GPIO + 0x914)
#define S5PV210_GPD0_INT_PEND		(S5P_VA_GPIO + 0xA14)
#define S5PV210_GPD0_INT_FIXPRI		(S5P_VA_GPIO + 0xB28)

#define S5PV210_GPD1_INT_CON		(S5P_VA_GPIO + 0x718)
#define S5PV210_GPD1_INT_FLTCON0		(S5P_VA_GPIO + 0x830)
#define S5PV210_GPD1_INT_FLTCON1		(S5P_VA_GPIO + 0x834)
#define S5PV210_GPD1_INT_MASK		(S5P_VA_GPIO + 0x918)
#define S5PV210_GPD1_INT_PEND		(S5P_VA_GPIO + 0xA18)
#define S5PV210_GPD1_INT_FIXPRI		(S5P_VA_GPIO + 0xB2C)

#define S5PV210_GPE0_INT_CON		(S5P_VA_GPIO + 0x71C)
#define S5PV210_GPE0_INT_FLTCON0		(S5P_VA_GPIO + 0x838)
#define S5PV210_GPE0_INT_FLTCON1		(S5P_VA_GPIO + 0x83C)
#define S5PV210_GPE0_INT_MASK		(S5P_VA_GPIO + 0x91C)
#define S5PV210_GPE0_INT_PEND		(S5P_VA_GPIO + 0xA1C)
#define S5PV210_GPE0_INT_FIXPRI		(S5P_VA_GPIO + 0xB30)

#define S5PV210_GPE1_INT_CON		(S5P_VA_GPIO + 0x720)
#define S5PV210_GPE1_INT_FLTCON0		(S5P_VA_GPIO + 0x840)
#define S5PV210_GPE1_INT_FLTCON1		(S5P_VA_GPIO + 0x844)
#define S5PV210_GPE1_INT_MASK		(S5P_VA_GPIO + 0x920)
#define S5PV210_GPE1_INT_PEND		(S5P_VA_GPIO + 0xA20)
#define S5PV210_GPE1_INT_FIXPRI		(S5P_VA_GPIO + 0xB34)

#define S5PV210_GPF0_INT_CON		(S5P_VA_GPIO + 0x724)
#define S5PV210_GPF0_INT_FLTCON0		(S5P_VA_GPIO + 0x848)
#define S5PV210_GPF0_INT_FLTCON1		(S5P_VA_GPIO + 0x84C)
#define S5PV210_GPF0_INT_MASK		(S5P_VA_GPIO + 0x924)
#define S5PV210_GPF0_INT_PEND		(S5P_VA_GPIO + 0xA24)
#define S5PV210_GPF0_INT_FIXPRI		(S5P_VA_GPIO + 0xB38)

#define S5PV210_GPF1_INT_CON		(S5P_VA_GPIO + 0x728)
#define S5PV210_GPF1_INT_FLTCON0		(S5P_VA_GPIO + 0x850)
#define S5PV210_GPF1_INT_FLTCON1		(S5P_VA_GPIO + 0x854)
#define S5PV210_GPF1_INT_MASK		(S5P_VA_GPIO + 0x928)
#define S5PV210_GPF1_INT_PEND		(S5P_VA_GPIO + 0xA28)
#define S5PV210_GPF1_INT_FIXPRI		(S5P_VA_GPIO + 0xB3C)

#define S5PV210_GPF2_INT_CON		(S5P_VA_GPIO + 0x72C)
#define S5PV210_GPF2_INT_FLTCON0		(S5P_VA_GPIO + 0x858)
#define S5PV210_GPF2_INT_FLTCON1		(S5P_VA_GPIO + 0x85C)
#define S5PV210_GPF2_INT_MASK		(S5P_VA_GPIO + 0x92C)
#define S5PV210_GPF2_INT_PEND		(S5P_VA_GPIO + 0xA2C)
#define S5PV210_GPF2_INT_FIXPRI		(S5P_VA_GPIO + 0xB40)

#define S5PV210_GPF3_INT_CON		(S5P_VA_GPIO + 0x730)
#define S5PV210_GPF3_INT_FLTCON0		(S5P_VA_GPIO + 0x860)
#define S5PV210_GPF3_INT_FLTCON1		(S5P_VA_GPIO + 0x864)
#define S5PV210_GPF3_INT_MASK		(S5P_VA_GPIO + 0x930)
#define S5PV210_GPF3_INT_PEND		(S5P_VA_GPIO + 0xA30)
#define S5PV210_GPF3_INT_FIXPRI		(S5P_VA_GPIO + 0xB44)

#define S5PV210_GPG0_INT_CON		(S5P_VA_GPIO + 0x734)
#define S5PV210_GPG0_INT_FLTCON0		(S5P_VA_GPIO + 0x868)
#define S5PV210_GPG0_INT_FLTCON1		(S5P_VA_GPIO + 0x86C)
#define S5PV210_GPG0_INT_MASK		(S5P_VA_GPIO + 0x934)
#define S5PV210_GPG0_INT_PEND		(S5P_VA_GPIO + 0xA34)
#define S5PV210_GPG0_INT_FIXPRI		(S5P_VA_GPIO + 0xB48)

#define S5PV210_GPG1_INT_CON		(S5P_VA_GPIO + 0x738)
#define S5PV210_GPG1_INT_FLTCON0		(S5P_VA_GPIO + 0x870)
#define S5PV210_GPG1_INT_FLTCON1		(S5P_VA_GPIO + 0x874)
#define S5PV210_GPG1_INT_MASK		(S5P_VA_GPIO + 0x938)
#define S5PV210_GPG1_INT_PEND		(S5P_VA_GPIO + 0xA38)
#define S5PV210_GPG1_INT_FIXPRI		(S5P_VA_GPIO + 0xB4C)

#define S5PV210_GPG2_INT_CON		(S5P_VA_GPIO + 0x73C)
#define S5PV210_GPG2_INT_FLTCON0		(S5P_VA_GPIO + 0x878)
#define S5PV210_GPG2_INT_FLTCON1		(S5P_VA_GPIO + 0x87C)
#define S5PV210_GPG2_INT_MASK		(S5P_VA_GPIO + 0x93C)
#define S5PV210_GPG2_INT_PEND		(S5P_VA_GPIO + 0xA3C)
#define S5PV210_GPG2_INT_FIXPRI		(S5P_VA_GPIO + 0xB50)

#define S5PV210_GPG3_INT_CON		(S5P_VA_GPIO + 0x740)
#define S5PV210_GPG3_INT_FLTCON0		(S5P_VA_GPIO + 0x880)
#define S5PV210_GPG3_INT_FLTCON1		(S5P_VA_GPIO + 0x884)
#define S5PV210_GPG3_INT_MASK		(S5P_VA_GPIO + 0x940)
#define S5PV210_GPG3_INT_PEND		(S5P_VA_GPIO + 0xA40)
#define S5PV210_GPG3_INT_FIXPRI		(S5P_VA_GPIO + 0xB54)

#define S5PV210_GPJ0_INT_CON		(S5P_VA_GPIO + 0x744)
#define S5PV210_GPJ0_INT_FLTCON0		(S5P_VA_GPIO + 0x888)
#define S5PV210_GPJ0_INT_FLTCON1		(S5P_VA_GPIO + 0x88C)
#define S5PV210_GPJ0_INT_MASK		(S5P_VA_GPIO + 0x944)
#define S5PV210_GPJ0_INT_PEND		(S5P_VA_GPIO + 0xA44)
#define S5PV210_GPJ0_INT_FIXPRI		(S5P_VA_GPIO + 0xB58)

#define S5PV210_GPJ1_INT_CON		(S5P_VA_GPIO + 0x748)
#define S5PV210_GPJ1_INT_FLTCON0		(S5P_VA_GPIO + 0x890)
#define S5PV210_GPJ1_INT_FLTCON1		(S5P_VA_GPIO + 0x894)
#define S5PV210_GPJ1_INT_MASK		(S5P_VA_GPIO + 0x948)
#define S5PV210_GPJ1_INT_PEND		(S5P_VA_GPIO + 0xA48)
#define S5PV210_GPJ1_INT_FIXPRI		(S5P_VA_GPIO + 0xB5C)

#define S5PV210_GPJ2_INT_CON		(S5P_VA_GPIO + 0x74C)
#define S5PV210_GPJ2_INT_FLTCON0		(S5P_VA_GPIO + 0x898)
#define S5PV210_GPJ2_INT_FLTCON1		(S5P_VA_GPIO + 0x89C)
#define S5PV210_GPJ2_INT_MASK		(S5P_VA_GPIO + 0x94C)
#define S5PV210_GPJ2_INT_PEND		(S5P_VA_GPIO + 0xA4C)
#define S5PV210_GPJ2_INT_FIXPRI		(S5P_VA_GPIO + 0xB60)

#define S5PV210_GPJ3_INT_CON		(S5P_VA_GPIO + 0x750)
#define S5PV210_GPJ3_INT_FLTCON0		(S5P_VA_GPIO + 0x8A0)
#define S5PV210_GPJ3_INT_FLTCON1		(S5P_VA_GPIO + 0x8A4)
#define S5PV210_GPJ3_INT_MASK		(S5P_VA_GPIO + 0x950)
#define S5PV210_GPJ3_INT_PEND		(S5P_VA_GPIO + 0xA50)
#define S5PV210_GPJ3_INT_FIXPRI		(S5P_VA_GPIO + 0xB64)

#define S5PV210_GPJ4_INT_CON		(S5P_VA_GPIO + 0x754)
#define S5PV210_GPJ4_INT_FLTCON0		(S5P_VA_GPIO + 0x8A8)
#define S5PV210_GPJ4_INT_FLTCON1		(S5P_VA_GPIO + 0x8AC)
#define S5PV210_GPJ4_INT_MASK		(S5P_VA_GPIO + 0x954)
#define S5PV210_GPJ4_INT_PEND		(S5P_VA_GPIO + 0xA54)
#define S5PV210_GPJ4_INT_FIXPRI		(S5P_VA_GPIO + 0xB68)

#define S5PV210_EXT_INT_GRPPRI		(S5P_VA_GPIO + 0xB00)
#define S5PV210_EXT_INT_PRIO		(S5P_VA_GPIO + 0xB04)
#define S5PV210_EXT_INT_SVC		(S5P_VA_GPIO + 0xB08)
#define S5PV210_EXT_INT_SVC_PND		(S5P_VA_GPIO + 0xB0C)
#define S5PV210_EXT_INT_GRPFIXPRI	(S5P_VA_GPIO + 0xB10)

#define S5PV210_EINT30CON		(S5P_VA_GPIO + 0xE00)
#define S5P_EINT_CON(x)			(S5PV210_EINT30CON + ((x) * 0x4))

#define S5PV210_EINT30FLTCON0		(S5P_VA_GPIO + 0xE80)
#define S5P_EINT_FLTCON(x,y)		(S5PV210_EINT30FLTCON0 + ((x) * 0x8) + ((y) * 0x4))

#define S5PV210_EINT30MASK		(S5P_VA_GPIO + 0xF00)
#define S5P_EINT_MASK(x)		(S5PV210_EINT30MASK + ((x) * 0x4))

#define S5PV210_EINT30PEND		(S5P_VA_GPIO + 0xF40)
#define S5P_EINT_PEND(x)		(S5PV210_EINT30PEND + ((x) * 0x4))

#define EINT_REG_NR(x)			(EINT_OFFSET(x) >> 3)

#define eint_offset(irq)		((irq) < IRQ_EINT16_31 ? ((irq)-IRQ_EINT0)\
						: (irq-S5P_IRQ_EINT_BASE))

#define eint_irq_to_bit(irq)		(1 << (EINT_OFFSET(irq) & 0x7))

#define eint_conf_reg(irq)		((eint_offset(irq)) >> 3)
#define eint_filt_reg(irq)		((eint_offset(irq)) >> 2)
#define eint_mask_reg(irq)		((eint_offset(irq)) >> 3)
#define eint_pend_reg(irq)		((eint_offset(irq)) >> 3)

/* values for S5P_EXTINT0 */
#define S5P_EXTINT_LOWLEV		(0x00)
#define S5P_EXTINT_HILEV		(0x01)
#define S5P_EXTINT_FALLEDGE		(0x02)
#define S5P_EXTINT_RISEEDGE		(0x03)
#define S5P_EXTINT_BOTHEDGE		(0x04)

#define EINT_MODE		S3C_GPIO_SFN(0xf)

#define EINT_GPIO_0(x)		S5PV210_GPH0(x)
#define EINT_GPIO_1(x)		S5PV210_GPH1(x)
#define EINT_GPIO_2(x)		S5PV210_GPH2(x)
#define EINT_GPIO_3(x)		S5PV210_GPH3(x)

#endif /* __ASM_ARCH_REGS_GPIO_H */
