/*
 * Samsung Handset Platform
 * Copyright (c) 2000 Software Center, Samsung Electronics, Inc.
 * All rights reserved.
 */
/** 
 * @description	Defines the error codes pertaining to WML Script module
 * @author	venkat.nj@samsung.com
 */

#ifndef _WMLS_ERR_H_
#define _WMLS_ERR_H_

/* Common error codes */
#define WMLS_OK					0
#define	WMLS_ERR_MEM_ALLOC		-1
#define WMLS_ERR_INVALID_TYPE	-2
#define WMLS_ERR_VAL_NOT_FOUND	-3
#define WMLS_ERR_INVALID_PARAM	-4
#define WMLS_ERR_NAME_ALREADY_PRESENT	-5

/* WMLS Syntax specific error codes */
#define YAL_ERR_FUNCTION_ARG_MISMATCH	-100
#define YAL_ERR_INVALID_LIB_CALL		-101
#define YAL_ERR_MISSING_RPAREN			-102
#define YAL_ERR_ID_DECLARED				-103
#define YAL_ERR_INVALID_COMP_UNIT		-104
#define YAL_ERR_MISSING_ID				-105
#define YAL_ERR_UNDECL_NAME				-106
#define YAL_ERR_MULTIPLE_ACCESS			-107
#define YAL_ERR_ILLEGAL_BREAK			-108
#define YAL_ERR_ILLEGAL_CONTINUE		-109
#define YAL_ERR_INVALID_BRACE			-110

/* WMLS Execution specific error codes */
/* fatal errors */
	/* bytecode errors */
		/* bytecode verification err */
#define WMLS_ERR_VERIFICATION_FAILURE
#define WMLS_ERR_VERIFICATION_NULL_DOC
#define WMLS_ERR_VERIFICATION_MAJOR_VERSION
#define WMLS_ERR_VERIFICATION_MINOR_VERSION
#define WMLS_ERR_VERIFICATION_CODE_SIZE
#define WMLS_ERR_VERIFICATION_INVALID_CONSTANT_TYPE
#define WMLS_ERR_VERIFICATION_NEGATIVE_SIZE
#define WMLS_ERR_VERIFICATION_DUPLICATE_DOMAIN_PRAGMA
#define WMLS_ERR_VERIFICATION_DUPLICATE_PATH_PRAGMA
#define WMLS_ERR_VERIFICATION_INVALID_PRAGMA_TYPE
#define WMLS_ERR_VERIFICATION_PRAGMA_VALUE
#define WMLS_ERR_VERIFICATION_FUNCTION_INDEX
#define WMLS_ERR_VERIFICATION_FUNCTION_NAME
#define WMLS_ERR_VERIFICATION_FUNCTION_ARGUMENT_NUMBER
#define WMLS_ERR_VERIFICATION_FUNCTION_SIZE
#define WMLS_ERR_VERIFICATION_STRING_FORMAT
#define WMLS_ERR_VERIFICATION_INVALID_UTF_8
#define WMLS_ERR_VERIFICATION_VARIABLE_INDEX
#define WMLS_ERR_VERIFICATION_CONSTANT_INDEX
#define WMLS_ERR_VERIFICATION_LIBRARY_INDEX
#define WMLS_ERR_VERIFICATION_INVALID_IP

#define WMLS_ERR_FATAL_LIBRARY_FUNCTION
#define WMLS_ERR_INVALID_FUNCTION_ARGUMENTS
#define WMLS_ERR_EXTERNAL_FUNCTION_NOT_FOUND
#define WMLS_ERR_UNABLE_TO_LOAD_COMPILATION_UNIT
#define WMLS_ERR_ACCESS_VIOLATION
#define WMLS_ERR_STACK_UNDERFLOW

#define WMLS_ERR_PROGRAMMED_ABORT

#define WMLS_ERR_STACK_OVERFLOW
#define WMLS_ERR_OUT_OF_MEMORY

	/* external exceptions */
#define WMLS_ERR_USER_INITIATED
#define WMLS_ERR_SYSTEM_INITIATED

/* non-fatal errors */
	/* computational errors */
#define WMLS_ERR_DIVIDE_BY_ZERO
#define WMLS_ERR_INTEGER_OVERFLOW
#define WMLS_ERR_FLOATING_POINT_OVERFLOW
#define WMLS_ERR_FLOATING_POINT_UNDERFLOW
/* constant reference errors */
#define WMLS_ERR_NOT_NUMBER_CONSTANT
#define WMLS_ERR_INFINITE_FLOATING_POINT_CONSTANT
#define WMLS_ERR_ILLEGAL_FLOATING_POINT_REFERENCE
/* conversion errors */
#define WMLS_ERR_INTEGER_TOO_LARGE
#define WMLS_ERR_FLOATING_POINT_TOO_LARGE
#define WMLS_ERR_FLOATING_POINT_TOO_SMALL

#endif	/*_WMLS_ERR_H_*/
