/* Copyright (c) 2015-2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/regmap.h>
#include "msm-digital-cdc.h"
#include "msm-digital-cdc-registers.h"

/*
 * Default register reset values that are common across different versions
 * are defined here. If a register reset value is changed based on version
 * then remove it from this structure and add it in version specific
 * structures.
 */
struct reg_default
	msm89xx_cdc_core_defaults[MSM89XX_CDC_CORE_CACHE_SIZE] = {
	{MSM89XX_CDC_CORE_CLK_RX_RESET_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_TX_RESET_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_DMIC_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_RX_I2S_CTL, 0x13},
	{MSM89XX_CDC_CORE_CLK_TX_I2S_CTL, 0x13},
	{MSM89XX_CDC_CORE_CLK_OTHR_RESET_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_TX_CLK_EN_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_OTHR_CTL, 0x04},
	{MSM89XX_CDC_CORE_CLK_RX_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_MCLK_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_PDM_CTL, 0x00},
	{MSM89XX_CDC_CORE_CLK_SD_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_B5_CTL, 0x68},
	{MSM89XX_CDC_CORE_RX2_B5_CTL, 0x68},
	{MSM89XX_CDC_CORE_RX3_B5_CTL, 0x68},
	{MSM89XX_CDC_CORE_RX1_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_VOL_CTL_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_VOL_CTL_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_VOL_CTL_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX1_VOL_CTL_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX2_VOL_CTL_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_RX3_VOL_CTL_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_TOP_GAIN_UPDATE, 0x00},
	{MSM89XX_CDC_CORE_TOP_CTL, 0x01},
	{MSM89XX_CDC_CORE_DEBUG_DESER1_CTL, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_DESER2_CTL, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_B1_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_B2_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_DEBUG_B3_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B5_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B5_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B6_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B7_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B7_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_GAIN_B8_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_B8_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_CTL, 0x40},
	{MSM89XX_CDC_CORE_IIR2_CTL, 0x40},
	{MSM89XX_CDC_CORE_IIR1_GAIN_TIMER_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_GAIN_TIMER_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR1_COEF_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_IIR2_COEF_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX1_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX1_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX1_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX2_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX2_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX2_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX3_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_RX3_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_TX_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ1_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B1_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B2_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B3_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_EQ2_B4_CTL, 0x00},
	{MSM89XX_CDC_CORE_CONN_TX_I2S_SD1_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX1_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX2_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX3_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX4_VOL_CTL_TIMER, 0x00},
	{MSM89XX_CDC_CORE_TX1_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX2_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX3_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX4_VOL_CTL_GAIN, 0x00},
	{MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG, 0x00},
	{MSM89XX_CDC_CORE_TX1_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX2_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX3_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX4_MUX_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX1_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX2_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX3_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX4_CLK_FS_CTL, 0x03},
	{MSM89XX_CDC_CORE_TX1_DMIC_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX2_DMIC_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX3_DMIC_CTL, 0x00},
	{MSM89XX_CDC_CORE_TX4_DMIC_CTL, 0x00},
};

static const u8 msm89xx_cdc_core_reg_readable[MSM89XX_CDC_CORE_CACHE_SIZE] = {
		[MSM89XX_CDC_CORE_CLK_RX_RESET_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_DMIC_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_CLK_EN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_MCLK_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_PDM_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_SD_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_TOP_GAIN_UPDATE] = 1,
		[MSM89XX_CDC_CORE_TOP_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER1_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER2_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B1_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B2_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B3_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_I2S_SD1_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX1_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_DMIC_CTL] = 1,
};

static const u8 msm89xx_cdc_core_reg_writeable[MSM89XX_CDC_CORE_CACHE_SIZE] = {
		[MSM89XX_CDC_CORE_CLK_RX_RESET_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_DMIC_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_I2S_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_RESET_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_TX_CLK_EN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_OTHR_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_RX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_MCLK_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_PDM_CTL] = 1,
		[MSM89XX_CDC_CORE_CLK_SD_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_RX1_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX2_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_RX3_VOL_CTL_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_TOP_GAIN_UPDATE] = 1,
		[MSM89XX_CDC_CORE_TOP_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER1_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_DESER2_CTL] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B1_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B2_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_DEBUG_B3_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B5_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B6_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B7_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_B8_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_GAIN_TIMER_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR1_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_IIR2_COEF_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_RX3_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ1_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B1_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B2_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B3_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_EQ2_B4_CTL] = 1,
		[MSM89XX_CDC_CORE_CONN_TX_I2S_SD1_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_TIMER] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_GAIN] = 1,
		[MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG] = 1,
		[MSM89XX_CDC_CORE_TX1_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_MUX_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_CLK_FS_CTL] = 1,
		[MSM89XX_CDC_CORE_TX1_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX2_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX3_DMIC_CTL] = 1,
		[MSM89XX_CDC_CORE_TX4_DMIC_CTL] = 1,
};

bool msm89xx_cdc_core_readable_reg(struct device *dev, unsigned int reg)
{
	return msm89xx_cdc_core_reg_readable[reg];
}

bool msm89xx_cdc_core_writeable_reg(struct device *dev, unsigned int reg)
{
	return msm89xx_cdc_core_reg_writeable[reg];
}

bool msm89xx_cdc_core_volatile_reg(struct device *dev, unsigned int reg)
{
	switch (reg) {
	case MSM89XX_CDC_CORE_RX1_B1_CTL:
	case MSM89XX_CDC_CORE_RX2_B1_CTL:
	case MSM89XX_CDC_CORE_RX3_B1_CTL:
	case MSM89XX_CDC_CORE_RX1_B6_CTL:
	case MSM89XX_CDC_CORE_RX2_B6_CTL:
	case MSM89XX_CDC_CORE_RX3_B6_CTL:
	case MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG:
	case MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL:
	case MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL:
	case MSM89XX_CDC_CORE_CLK_MCLK_CTL:
	case MSM89XX_CDC_CORE_CLK_PDM_CTL:
		return true;
	default:
		return false;
	}
}
