 /* Copyright (c) 2015-2016, 2018, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef DIGITAL_CDC_REGISTERS_H
#define DIGITAL_CDC_REGISTERS_H

#define MSM89XX_CDC_CORE_CLK_RX_RESET_CTL	(0x00)
#define MSM89XX_CDC_CORE_CLK_TX_RESET_B1_CTL	(0x04)
#define MSM89XX_CDC_CORE_CLK_DMIC_B1_CTL	(0x08)
#define MSM89XX_CDC_CORE_CLK_RX_I2S_CTL		(0x0C)
#define MSM89XX_CDC_CORE_CLK_TX_I2S_CTL		(0x10)
#define MSM89XX_CDC_CORE_CLK_OTHR_RESET_B1_CTL	(0x14)
#define MSM89XX_CDC_CORE_CLK_TX_CLK_EN_B1_CTL	(0x18)
#define MSM89XX_CDC_CORE_CLK_OTHR_CTL		(0x1C)
#define MSM89XX_CDC_CORE_CLK_RX_B1_CTL		(0x20)
#define MSM89XX_CDC_CORE_CLK_MCLK_CTL		(0x24)
#define MSM89XX_CDC_CORE_CLK_PDM_CTL		(0x28)
#define MSM89XX_CDC_CORE_CLK_SD_CTL		(0x2C)
#define MSM89XX_CDC_CORE_RX1_B1_CTL		(0x40)
#define MSM89XX_CDC_CORE_RX2_B1_CTL		(0x60)
#define MSM89XX_CDC_CORE_RX3_B1_CTL		(0x80)
#define MSM89XX_CDC_CORE_RX1_B2_CTL		(0x44)
#define MSM89XX_CDC_CORE_RX2_B2_CTL		(0x64)
#define MSM89XX_CDC_CORE_RX3_B2_CTL		(0x84)
#define MSM89XX_CDC_CORE_RX1_B3_CTL		(0x48)
#define MSM89XX_CDC_CORE_RX2_B3_CTL		(0x68)
#define MSM89XX_CDC_CORE_RX3_B3_CTL		(0x88)
#define MSM89XX_CDC_CORE_RX1_B4_CTL		(0x4C)
#define MSM89XX_CDC_CORE_RX2_B4_CTL		(0x6C)
#define MSM89XX_CDC_CORE_RX3_B4_CTL		(0x8C)
#define MSM89XX_CDC_CORE_RX1_B5_CTL		(0x50)
#define MSM89XX_CDC_CORE_RX2_B5_CTL		(0x70)
#define MSM89XX_CDC_CORE_RX3_B5_CTL		(0x90)
#define MSM89XX_CDC_CORE_RX1_B6_CTL		(0x54)
#define MSM89XX_CDC_CORE_RX2_B6_CTL		(0x74)
#define MSM89XX_CDC_CORE_RX3_B6_CTL		(0x94)
#define MSM89XX_CDC_CORE_RX1_VOL_CTL_B1_CTL	(0x58)
#define MSM89XX_CDC_CORE_RX2_VOL_CTL_B1_CTL	(0x78)
#define MSM89XX_CDC_CORE_RX3_VOL_CTL_B1_CTL	(0x98)
#define MSM89XX_CDC_CORE_RX1_VOL_CTL_B2_CTL	(0x5C)
#define MSM89XX_CDC_CORE_RX2_VOL_CTL_B2_CTL	(0x7C)
#define MSM89XX_CDC_CORE_RX3_VOL_CTL_B2_CTL	(0x9C)
#define MSM89XX_CDC_CORE_TOP_GAIN_UPDATE	(0xA0)
#define MSM89XX_CDC_CORE_TOP_CTL		(0xA4)
#define MSM89XX_CDC_CORE_DEBUG_DESER1_CTL	(0xE0)
#define MSM89XX_CDC_CORE_DEBUG_DESER2_CTL	(0xE4)
#define MSM89XX_CDC_CORE_DEBUG_B1_CTL_CFG	(0xE8)
#define MSM89XX_CDC_CORE_DEBUG_B2_CTL_CFG	(0xEC)
#define MSM89XX_CDC_CORE_DEBUG_B3_CTL_CFG	(0xF0)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B1_CTL	(0x100)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B1_CTL	(0x140)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B2_CTL	(0x104)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B2_CTL	(0x144)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B3_CTL	(0x108)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B3_CTL	(0x148)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B4_CTL	(0x10C)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B4_CTL	(0x14C)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B5_CTL	(0x110)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B5_CTL	(0x150)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B6_CTL	(0x114)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B6_CTL	(0x154)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B7_CTL	(0x118)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B7_CTL	(0x158)
#define MSM89XX_CDC_CORE_IIR1_GAIN_B8_CTL	(0x11C)
#define MSM89XX_CDC_CORE_IIR2_GAIN_B8_CTL	(0x15C)
#define MSM89XX_CDC_CORE_IIR1_CTL		(0x120)
#define MSM89XX_CDC_CORE_IIR2_CTL		(0x160)
#define MSM89XX_CDC_CORE_IIR1_GAIN_TIMER_CTL	(0x124)
#define MSM89XX_CDC_CORE_IIR2_GAIN_TIMER_CTL	(0x164)
#define MSM89XX_CDC_CORE_IIR1_COEF_B1_CTL	(0x128)
#define MSM89XX_CDC_CORE_IIR2_COEF_B1_CTL	(0x168)
#define MSM89XX_CDC_CORE_IIR1_COEF_B2_CTL	(0x12C)
#define MSM89XX_CDC_CORE_IIR2_COEF_B2_CTL	(0x16C)
#define MSM89XX_CDC_CORE_CONN_RX1_B1_CTL	(0x180)
#define MSM89XX_CDC_CORE_CONN_RX1_B2_CTL	(0x184)
#define MSM89XX_CDC_CORE_CONN_RX1_B3_CTL	(0x188)
#define MSM89XX_CDC_CORE_CONN_RX2_B1_CTL	(0x18C)
#define MSM89XX_CDC_CORE_CONN_RX2_B2_CTL	(0x190)
#define MSM89XX_CDC_CORE_CONN_RX2_B3_CTL	(0x194)
#define MSM89XX_CDC_CORE_CONN_RX3_B1_CTL	(0x198)
#define MSM89XX_CDC_CORE_CONN_RX3_B2_CTL	(0x19C)
#define MSM89XX_CDC_CORE_CONN_TX_B1_CTL		(0x1A0)
#define MSM89XX_CDC_CORE_CONN_EQ1_B1_CTL	(0x1A8)
#define MSM89XX_CDC_CORE_CONN_EQ1_B2_CTL	(0x1AC)
#define MSM89XX_CDC_CORE_CONN_EQ1_B3_CTL	(0x1B0)
#define MSM89XX_CDC_CORE_CONN_EQ1_B4_CTL	(0x1B4)
#define MSM89XX_CDC_CORE_CONN_EQ2_B1_CTL	(0x1B8)
#define MSM89XX_CDC_CORE_CONN_EQ2_B2_CTL	(0x1BC)
#define MSM89XX_CDC_CORE_CONN_EQ2_B3_CTL	(0x1C0)
#define MSM89XX_CDC_CORE_CONN_EQ2_B4_CTL	(0x1C4)
#define MSM89XX_CDC_CORE_CONN_TX_I2S_SD1_CTL	(0x1C8)
#define MSM89XX_CDC_CORE_TX1_VOL_CTL_TIMER	(0x280)
#define MSM89XX_CDC_CORE_TX2_VOL_CTL_TIMER	(0x2A0)
#define MSM89XX_CDC_CORE_TX3_VOL_CTL_TIMER	(0x2C0)
#define MSM89XX_CDC_CORE_TX4_VOL_CTL_TIMER	(0x2E0)
#define MSM89XX_CDC_CORE_TX1_VOL_CTL_GAIN	(0x284)
#define MSM89XX_CDC_CORE_TX2_VOL_CTL_GAIN	(0x2A4)
#define MSM89XX_CDC_CORE_TX3_VOL_CTL_GAIN	(0x2C4)
#define MSM89XX_CDC_CORE_TX4_VOL_CTL_GAIN	(0x2E4)
#define MSM89XX_CDC_CORE_TX1_VOL_CTL_CFG	(0x288)
#define MSM89XX_CDC_CORE_TX2_VOL_CTL_CFG	(0x2A8)
#define MSM89XX_CDC_CORE_TX3_VOL_CTL_CFG	(0x2C8)
#define MSM89XX_CDC_CORE_TX4_VOL_CTL_CFG	(0x2E8)
#define MSM89XX_CDC_CORE_TX1_MUX_CTL		(0x28C)
#define MSM89XX_CDC_CORE_TX2_MUX_CTL		(0x2AC)
#define MSM89XX_CDC_CORE_TX3_MUX_CTL		(0x2CC)
#define MSM89XX_CDC_CORE_TX4_MUX_CTL		(0x2EC)
#define MSM89XX_CDC_CORE_TX1_CLK_FS_CTL		(0x290)
#define MSM89XX_CDC_CORE_TX2_CLK_FS_CTL		(0x2B0)
#define MSM89XX_CDC_CORE_TX3_CLK_FS_CTL		(0x2D0)
#define MSM89XX_CDC_CORE_TX4_CLK_FS_CTL		(0x2F0)
#define MSM89XX_CDC_CORE_TX1_DMIC_CTL		(0x294)
#define MSM89XX_CDC_CORE_TX2_DMIC_CTL		(0x2B4)
#define MSM89XX_CDC_CORE_TX3_DMIC_CTL		(0x2D4)
#define MSM89XX_CDC_CORE_TX4_DMIC_CTL		(0x2F4)

#define MSM89XX_CDC_CORE_NUM_REGISTERS \
		(MSM89XX_CDC_CORE_TX4_DMIC_CTL+1)
#define MSM89XX_CDC_CORE_MAX_REGISTER \
		(MSM89XX_CDC_CORE_NUM_REGISTERS-1)
#define MSM89XX_CDC_CORE_CACHE_SIZE \
		MSM89XX_CDC_CORE_NUM_REGISTERS
#endif
