/*
 * Copyright (c) 2018 Samsung Electronics Co., Ltd. All Rights Reserved
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
*/

#ifndef __CONFIG_SECURITY_DEFEX_CATCH_LIST_H
#define __CONFIG_SECURITY_DEFEX_CATCH_LIST_H

#include "defex_config.h"

//DEFINES//////////////////////////////////////////////////////////////////////
#define defex_do_str(s)		#s
#define defex_make_str(s)	defex_do_str(s)

#define SYSCALL_CATCH(name, errno) \
	[__NR_##name] = { \
	.local_syscall = __DEFEX_##name, \
	.err_code = (errno) \
}

enum defex_local_syscall {
	__DEFEX_empty = 0,
	__DEFEX_rmdir,
	__DEFEX_utimes,
	__DEFEX_stat,
	__DEFEX_lstat,
	__DEFEX_umount,
	__DEFEX_utime,
	__DEFEX_futimesat,
	__DEFEX_uselib,
	__DEFEX_send,
	__DEFEX_ustat,
	__DEFEX_getdents,
	__DEFEX_recv,
	__DEFEX_fork,
	__DEFEX_vfork,
	__DEFEX_sigprocmask,
	__DEFEX_sigpending,
	__DEFEX_sigaction,
	__DEFEX_sigaltstack,
	__DEFEX_sigsuspend,
	__DEFEX_truncate64,
	__DEFEX_ftruncate64,
	__DEFEX_fstat64,
	__DEFEX_fstatat64,
	__DEFEX_statfs64,
	__DEFEX_stat64,
	__DEFEX_lstat64,
	__DEFEX_eventfd,
	__DEFEX_epoll_create,
	__DEFEX_shmget,
	__DEFEX_shmctl,
	__DEFEX_semctl,
	__DEFEX_move_pages,
	__DEFEX_lookup_dcookie,
	__DEFEX_truncate,
	__DEFEX_ftruncate,
	__DEFEX_chdir,
	__DEFEX_chroot,
	__DEFEX_fchmod,
	__DEFEX_fchmodat,
	__DEFEX_fchownat,
	__DEFEX_fchown,
	__DEFEX_open,   // -> included to the source
	__DEFEX_openat, // -> included to the source
	__DEFEX_write,  // -> included to the source
	__DEFEX_writev,
	__DEFEX_pwrite64,
	__DEFEX_pwritev,
	__DEFEX_sendfile,
	__DEFEX_signalfd4,
	__DEFEX_vmsplice,
	__DEFEX_splice,
	__DEFEX_tee,
	__DEFEX_fsync,
	__DEFEX_fdatasync,
	__DEFEX_sync_file_range,
	__DEFEX_acct,
	__DEFEX_sched_setparam,
	__DEFEX_sched_setscheduler,
	__DEFEX_sched_setaffinity,
	__DEFEX_reboot,
	__DEFEX_mq_timedsend,
	__DEFEX_mq_timedreceive,
	__DEFEX_msgrcv,
	__DEFEX_msgsnd,
	__DEFEX_semtimedop,
	__DEFEX_add_key,
	__DEFEX_request_key,
	__DEFEX_keyctl,
	__DEFEX_mmap,
	__DEFEX_mincore,
	__DEFEX_mbind,
	__DEFEX_set_mempolicy,
	__DEFEX_migrate_pages,
	__DEFEX_accept4,
	__DEFEX_recvmmsg,
	__DEFEX_link,
	__DEFEX_unlink,
	__DEFEX_mknod,
	__DEFEX_chmod,
	__DEFEX_chown,
	__DEFEX_mknodat,
	__DEFEX_mkdirat,
	__DEFEX_unlinkat,
	__DEFEX_symlinkat,
	__DEFEX_linkat,
	__DEFEX_mkdir,
	__DEFEX_lchown,
	__DEFEX_rename,
	__DEFEX_epoll_wait,
	__DEFEX_sysctl,
	__DEFEX_renameat,
	__DEFEX_umount2,
	__DEFEX_mount,
	__DEFEX_pivot_root,
	__DEFEX_utimensat,
	__DEFEX_fcntl,
	__DEFEX_kexec_load,
	__DEFEX_ptrace,
	__DEFEX_setgroups,
	__DEFEX_settimeofday,
	__DEFEX_delete_module,
	__DEFEX_init_module,
	__DEFEX_capset,
	__DEFEX_setpriority,
	__DEFEX_setregid,
	__DEFEX_setgid,
	__DEFEX_setreuid,
	__DEFEX_setuid,
	__DEFEX_setresuid,
	__DEFEX_setresgid,
	__DEFEX_setpgid,
	__DEFEX_setfsuid, // -> included to the source
	__DEFEX_setfsgid, // -> included to the source
	__DEFEX_getsid,
	__DEFEX_setsid,
	__DEFEX_sethostname,
	__DEFEX_setdomainname,
	__DEFEX_setrlimit,
	__DEFEX_umask, // -> included to the source
	__DEFEX_prctl,
	__DEFEX_getcpu,
	__DEFEX_kill,
	__DEFEX_tgkill,
	__DEFEX_tkill,
	__DEFEX_rt_tgsigqueueinfo,
	__DEFEX_rt_sigqueueinfo,
	__DEFEX_listen,
	__DEFEX_accept,
	__DEFEX_shutdown,
	__DEFEX_shmat,
	__DEFEX_shmdt,
	__DEFEX_semget,
	__DEFEX_semop,
	__DEFEX_faccessat,
	__DEFEX_fchdir,
	__DEFEX_fstat,
	__DEFEX_readlinkat,
	__DEFEX_statfs,
	__DEFEX_fstatfs,
	__DEFEX_getcwd,
	__DEFEX_futex,
	__DEFEX_perf_event_open,
	__DEFEX_socket,
	__DEFEX_bind,
	__DEFEX_connect,
	__DEFEX_sendto,
	__DEFEX_mprotect,
	__DEFEX_mremap,
	__DEFEX_pselect6,
	__DEFEX_ioctl,
	__DEFEX_ioprio_set,
	__DEFEX_pipe2,
	__DEFEX_getdents64,
	__DEFEX_setitimer,
	__DEFEX_capget,
	__DEFEX_getresuid,
	__DEFEX_getresgid,
	__DEFEX_rt_sigprocmask,
	__DEFEX_socketpair,
	__DEFEX_getsockname,
	__DEFEX_getpeername,
	__DEFEX_recvfrom,
	__DEFEX_setsockopt,
	__DEFEX_sendmsg,
	__DEFEX_recvmsg,
	__DEFEX_socketcall,
	__DEFEX_rt_sigsuspend,
	__DEFEX_rt_sigpending,
	__DEFEX_rt_sigaction,
	__DEFEX_signal,
	__DEFEX_remap_file_pages,
	__DEFEX_ppoll,
	__DEFEX_dup,
	__DEFEX_dup3,
	__DEFEX_eventfd2,
	__DEFEX_timerfd_create,
	__DEFEX_timerfd_gettime,
	__DEFEX_timerfd_settime,
	__DEFEX_epoll_create1,
	__DEFEX_epoll_ctl,
	__DEFEX_epoll_pwait,
	__DEFEX_rt_sigtimedwait,
	__DEFEX_clone,
	__DEFEX_execve, //  -> included to the source
	__DEFEX_setxattr,
	__DEFEX_lsetxattr,
	__DEFEX_fsetxattr,
	__DEFEX_removexattr,
	__DEFEX_lremovexattr,
	__DEFEX_fremovexattr,
	__DEFEX_inotify_init1,
	__DEFEX_syscalls,
};

struct local_syscall_struct {
	enum defex_local_syscall local_syscall;
	long int err_code;
};

const struct local_syscall_struct *get_local_syscall(int syscall_no);
const struct local_syscall_struct *get_local_syscall_compat(int syscall_no);
int syscall_local2global(int syscall_no);

#endif /* __CONFIG_SECURITY_DEFEX_CATCH_LIST_H */
