/*
 * max77833.h - Driver for the Maxim 77833
 *
 *  Copyright (C) 2011 Samsung Electrnoics
 *  Seoyoung Jeong <seo0.jeong@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * This driver is based on max8997.h
 *
 * MAX77833 has Flash LED, SVC LED, Haptic, MUIC devices.
 * The devices share the same I2C bus and included in
 * this mfd driver.
 */

#ifndef __MAX77833_H__
#define __MAX77833_H__
#include <linux/platform_device.h>
#include <linux/regmap.h>
#include <linux/battery/sec_charging_common.h>

#define MFD_DEV_NAME "max77833"
#define M2SH(m) ((m) & 0x0F ? ((m) & 0x03 ? ((m) & 0x01 ? 0 : 1) : ((m) & 0x04 ? 2 : 3)) : \
		((m) & 0x30 ? ((m) & 0x10 ? 4 : 5) : ((m) & 0x40 ? 6 : 7)))

#ifdef CONFIG_SS_VIBRATOR
struct max77833_haptic_platform_data
{
    int mode;
    int divisor;
};
#endif

struct max77833_regulator_data {
	int id;
	struct regulator_init_data *initdata;
	struct device_node *reg_node;
};

struct max77833_platform_data {
	/* IRQ */
	int irq_base;
	int irq_gpio;
	bool wakeup;
	struct muic_platform_data *muic_pdata;

#if defined(CONFIG_CHARGER_MAX77833) || defined(CONFIG_FUELGAUGE_MAX77833)
	sec_charger_platform_data_t *charger_data;
	sec_fuelgauge_platform_data_t *fuelgauge_data;
#endif

	int num_regulators;
	struct max77833_regulator_data *regulators;
#ifdef CONFIG_SS_VIBRATOR
	/* haptic motor data */
	struct max77833_haptic_platform_data *haptic_data;
#endif
	struct mfd_cell *sub_devices;
	int num_subdevs;
};

struct max77833
{
	struct regmap *regmap;
};

extern struct max77833_haptic_platform_data max77833_haptic_pdata;
#endif /* __MAX77833_H__ */

