/*
 * dbmdx-interface.h  --  DBMDX interface definitions
 *
 * Copyright (C) 2014 DSP Group
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef _DBMDX_H
#define _DBMDX_H

#include <linux/device.h>
#include <sound/soc.h>

enum dbmdx_va_speeds {
	DBMDX_VA_SPEED_NORMAL = 0,
	DBMDX_VA_SPEED_BUFFERING,
	DBMDX_VA_SPEED_MAX,
	DBMDX_VA_NR_OF_SPEEDS,
};

struct va_speed {
	u32	cfg;
	u32	uart_baud;
	u32	i2c_rate;
	u32	spi_rate;
};

struct dbmdx_platform_data {
	int				gpio_wakeup;
	int				gpio_reset;
	int				gpio_sv;
	int				gpio_d2strap1;
	int				gpio_d2strap1_rst_val;
	int				wakeup_set_value;
	int				send_wakeup_seq;
	int				use_gpio_for_wakeup;

	const char			*va_firmware_name;
	const char			*vqe_firmware_name;
	const char			*vqe_non_overlay_firmware_name;
	int				firmware_id;

	int				constant_clk_rate;
	int				master_clk_rate;

	int				feature_va;
	int				feature_vqe;
	int				feature_fw_overlay;
	unsigned int			va_cfg_values;
	u32				*va_cfg_value;
	unsigned int			vqe_cfg_values;
	u32				*vqe_cfg_value;
	unsigned int			vqe_modes_values;
	u32				*vqe_modes_value;

	int				auto_buffering;
	int				auto_detection;
	int				send_uevent_on_detection;
	int				uart_low_speed_enabled;

	int				detection_buffer_channels;
	u32				min_samples_chunk_size;
	u32				pcm_streaming_mode;

	struct va_speed	va_speed_cfg[DBMDX_VA_NR_OF_SPEEDS];
	u32				va_mic_config[3];
	u32				va_initial_mic_config;
	int				va_audio_channels;
	u32				vqe_tdm_bypass_config;
	unsigned int			va_buffering_pcm_rate;

	unsigned int			va_recovery_disabled;
};
int dbmdx_get_samples(char *buffer, unsigned int samples);
int dbmdx_codec_lock(void);
int dbmdx_start_pcm_streaming(struct snd_pcm_substream *substream);
int dbmdx_stop_pcm_streaming(void);
int dbmdx_codec_unlock(void);

#endif
