/*
 * include/linux/ccic/ccic_alternate.h - S2MM005 USB CCIC Alternate mode header file
 * 
 * Copyright (C) 2016 Samsung Electronics
 * Author: Wookwang Lee <wookwang.lee@samsung.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */
#ifndef __LINUX_CCIC_ALTERNATE_MODE_H__
#define __LINUX_CCIC_ALTERNATE_MODE_H__
#if defined(CONFIG_CCIC_ALTERNATE_MODE)
typedef union
{
	uint32_t        DATA;
	struct
	{
		uint8_t     BDATA[4];
	}BYTES;
	struct
	{
		uint32_t    VDM_command:5,
				    Rsvd2_VDM_header:1,
				    VDM_command_type:2,
				    Object_Position:3,
				    Rsvd_VDM_header:2,
			    	Structured_VDM_Version:2,
				    VDM_Type:1,
				    Standard_Vendor_ID:16;
	}BITS;
}U_DATA_MSG_VDM_HEADER_Type;

typedef union
{
	uint32_t        DATA;
	struct
	{
		uint8_t     BDATA[4];
	}BYTES;
	struct
	{
		uint32_t    USB_Vendor_ID:16,
			    	Rsvd_ID_header:10,
				    Modal_Operation_Supported:1,
				    Product_Type:3,
				    Data_Capable_USB_Device:1,
				    Data_Capable_USB_Host:1;
	}BITS;
}U_DATA_MSG_ID_HEADER_Type;

typedef union
{
	uint32_t        DATA;
	struct
	{
		uint8_t     BDATA[4];
	}BYTES;
	struct
	{
		uint32_t    Cert_TID:20,
			    	Rsvd_cert_VDOer:12;
	}BITS;
}U_CERT_STAT_VDO_Type;

typedef union
{
	uint32_t        DATA;
	struct
	{
		uint8_t     BDATA[4];
	}BYTES;
	struct
	{
		uint32_t    Device_Version:16,
			    	Product_ID:16;
	}BITS;
}U_PRODUCT_VDO_Type;

typedef union
{
	uint32_t        DATA;
	struct
	{
		uint8_t     BDATA[4];
	}BYTES;
	struct
	{
		uint32_t    USB_Superspeed_Signaling_Support:3,
				    SOP_contoller_present:1,
				    Vbus_through_cable:1,
				    Vbus_Current_Handling_Capability:2,
				    SSRX2_Directionality_Support:1,
				    SSRX1_Directionality_Support:1,
				    SSTX2_Directionality_Support:1,
				    SSTX1_Directionality_Support:1,
				    Cable_Termination_Type:2,
				    Cable_Latency:4,
				    TypeC_to_Plug_Receptacle:1,
				    TypeC_to_ABC:2,
				    Rsvd_CABLE_VDO:4,
				    Cable_Firmware_Version:4,
				    Cable_HW_Version:4;
	}BITS;
}U_CABLE_VDO_Type;

typedef union
{
	uint32_t        DATA;
	struct
	{
		uint8_t     BDATA[4];
	}BYTES;
	struct
	{
		uint32_t    SVID_1:16,
				    SVID_0:16;
	}BITS;
}U_VDO1_Type;

/* CCIC Dock Observer Callback parameter */
enum {
	CCIC_DOCK_DETACHED	= 0,
	CCIC_DOCK_HMT		= 105,
	CCIC_DOCK_ABNORMAL	= 106,
	CCIC_DOCK_NEW		= 200,  /* For New uevent */
};

enum VDM_MSG_IRQ_State {
	VDM_DISCOVER_ID		=	(1 << 0),
	VDM_DISCOVER_SVIDS	=	(1 << 1),
	VDM_DISCOVER_MODES	=	(1 << 2),
	VDM_ENTER_MODE		=	(1 << 3),
	VDM_EXIT_MODE 		=	(1 << 4),
};


#define ALTERNATE_MODE_NOT_READY	(1 << 0)
#define ALTERNATE_MODE_READY		(1 << 1)
#define ALTERNATE_MODE_STOP		(1 << 2)
#define ALTERNATE_MODE_START		(1 << 3)
#define ALTERNATE_MODE_RESET		(1 << 4)

// VMD Message Register I2C address by S.LSI
#define REG_VDM_MSG_REQ					0x02C0

#define REG_TX_DIS_ID_RESPONSE			0x0400
#define REG_TX_DIS_SVID_RESPONSE		0x0420
#define REG_TX_DIS_MODE_RESPONSE		0x0440
#define REG_TX_ENTER_MODE_RESPONSE		0x0460
#define REG_TX_EXIT_MODE_RESPONSE		0x0480
#define REG_TX_DIS_ATTENTION_RESPONSE	0x04A0

#define REG_RX_DIS_ID_CABLE				0x0500
#define REG_RX_DIS_ID					0x0520
#define REG_RX_DIS_SVID					0x0540
#define REG_RX_MODE						0x0560
#define REG_RX_ENTER_MODE				0x0580
#define REG_RX_EXIT_MODE				0x05A0
#define REG_RX_DIS_ATTENTION			0x05C0

#define GEAR_VR_DETACH_WAIT_MS 1000
#define DISPLAY_PORT_SVID		0xFF01

void send_alternate_message(void * data, int cmd);
void receive_alternate_message(void * data, VDM_MSG_IRQ_STATUS_Type *VDM_MSG_IRQ_State);
int ccic_register_switch_device(int mode);
void acc_detach_check(struct work_struct *work);
void set_enable_alternate_mode(int mode);
#else
inline void send_alternate_message(void * data, int cmd) {}
inline void receive_alternate_message(void * data, VDM_MSG_IRQ_STATUS_Type *VDM_MSG_IRQ_State) {}
inline int ccic_register_switch_device(int mode) {}
inline void acc_detach_check(struct work_struct *work) {}
inline void set_enable_alternate_mode(int mode) {}
#endif
#endif
