/*
 * =================================================================
 *
 *       Filename:  smart_mtp_s6e3.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_S6E3HF4_AMB526JS01_H_
#define _SS_DSI_SMART_DIMMING_S6E3HF4_AMB526JS01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

static int id1, id2, id3;
static int hero, hero2, hero2_a2_revM;

#define LUMINANCE_MAX 74
#define HMT_LUMINANCE_MAX 37
#define GAMMA_SET_MAX 35
#define GRAY_SCALE_MAX 256
#define RGB_COMPENSATION 27

/* BIT_SHIFT is used for right bit shfit */
#define BIT_SHIFT 22
#define BIT_SHFIT_MUL 4194304 // pow(2,BIT_SHIFT)

/* 6.5*4194304 */
#define VREG0_REF_6P5 27262976
/* 6.4*4194304 */
#define VREG0_REF_6P4 26843546
/* 6.3*4194304 */
#define VREG0_REF_6P3 26424115
/* 6.2*4194304 */
#define VREG0_REF_6P2 26004685

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

/* TP */
enum {
	VT = 0,
	V1 = 1,
	V7 = 2,
	V11 = 3,
	V23 = 4,
	V35 = 5,
	V51 = 6,
	V87 = 7,
	V151 = 8,
	V203 = 9,
	V255 = 10,
	V_MAX,
};

/* RGB */
enum {
	R = 0,
	G = 1,
	B = 2,
	RGB_MAX,
};

static char V_LIST[V_MAX][5] = {
	"VT",
	"V1",
	"V7",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	/* read C8h 1st ~ 35th */
	char MTP_ORIGN[GAMMA_SET_MAX];

	/* copy MTP_ORIGN -> MTP */
	int MTP[V_MAX][RGB_MAX];

	/* TP's gamma voltage */
	int RGB_OUTPUT[V_MAX][RGB_MAX];

	/* GRAY (0~255) */
	int GRAY[GRAY_SCALE_MAX][RGB_MAX];

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;

	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP+1];
	char *hbm_payload;
	int hbm_brightness_level;

	struct illuminance_table hmt_gen_table[HMT_LUMINANCE_MAX];
} __packed;

/* V0,V1,V7,V11,V23,V35,V51,V87,V151,V203,V255 */
static int INFLECTION_VOLTAGE_ARRAY[V_MAX] = {0, 1, 7, 11, 23, 35, 51, 87, 151, 203, 255};

static int vt_coefficient[] = {
   	  0,  12,  24,  36,
	 48,  60,  72,  84,
	 96, 108, 138, 148,
	158, 168, 178, 186,
};

// center (max) gamma value (Hex)
static int center_gamma[V_MAX][RGB_MAX] = {
	{0x0, 0x0, 0x0},		/* VT */
 	{0x80, 0x80, 0x80},		/* V1 */
 	{0x80, 0x80, 0x80},		/* V7 */
 	{0x80, 0x80, 0x80},		/* V11 */
 	{0x80, 0x80, 0x80},		/* V23 */
 	{0x80, 0x80, 0x80},		/* V35 */
 	{0x80, 0x80, 0x80},		/* V51 */
 	{0x80, 0x80, 0x80},		/* V87 */
 	{0x80, 0x80, 0x80},		/* V151 */
 	{0x80, 0x80, 0x80},		/* V203 */
	{0x100, 0x100, 0x100},	/* V255 */
};

/* fraction for gamma code */
static int fraction[V_MAX][2] = {
/* {numerator, denominator} */
	{0,  860},		/* VT */
	{0,  256},		/* V1 */
	{64, 320},		/* V7 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{72, 860},		/* V255 */
};

/* 443 is made but not used */
static int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {443, 465, 488, 510, 533, 555, 578, 600};

/* HERO REV A */

static unsigned int base_luminance_revA[LUMINANCE_MAX][2] = {
	{2, 	473956352},
	{3, 	473956352},
	{4, 	473956352},
	{5, 	473956352},
	{6,		473956352},
	{7, 	473956352},
	{8, 	473956352},
	{9, 	473956352},
	{10,	473956352},
	{11,	473956352},
	{12,	473956352},
	{13,	473956352},
	{14,	473956352},
	{15,	473956352},
	{16,	473956352},
	{17,	473956352},
	{19,	473956352},
	{20,	473956352},
	{21,	473956352},
	{22,	473956352},
	{24,	473956352},
	{25,	473956352},
	{27,	473956352},
	{29,	473956352},
	{30,	473956352},
	{32,	473956352},
	{34,	473956352},
	{37,	473956352},
	{39,	473956352},
	{41,	473956352},
	{44,	473956352},
	{47,	473956352},
	{50,	473956352},
	{53,	473956352},
	{56,	473956352},
	{60,	473956352},
	{64,	473956352},
	{68,	473956352},
	{72,	469762048},
	{77,	503316480},
	{82,	532676608},
	{87,	553648128},
	{93,	595591168},
	{98,	620756992},
	{105,	662700032},
	{110,	692060160},
	{119,	738197504},
	{126,	780140544},
	{134,	822083584},
	{143,	859832320},
	{152,	910163968},
	{162,	956301312},
	{172,	1019215872},
	{183,	1077936128},
	{195,	1077936128},
	{207,	1077936128},
	{220,	1077936128},
	{234,	1077936128},
	{249,	1077936128},
	{265,	1149239296},
	{282,	1199570944},
	{300,	1287651328},
	{316,	1342177280},
	{333,	1421869056},
	{360,	1509949440},
};

static int gradation_offset_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 7,	11, 15, 17, 20, 24, 24, 19},
	{0, 7,	10, 13, 16, 18, 22, 24, 19},
	{0, 6,	9,	12, 13, 15, 19, 22, 19},
	{0, 6,	9,	12, 13, 15, 18, 21, 19},
	{0, 6,	8,	12, 13, 14, 18, 21, 19},
	{0, 6,	8,	11, 12, 13, 17, 20, 18},
	{0, 5,	7,	10, 11, 12, 16, 19, 17},
	{0, 5,	7,	9,	10, 11, 15, 18, 17},
	{0, 5,	6,	9,	10, 11, 14, 17, 16},
	{0, 4,	6,	8,	9,	10, 13, 16, 15},
	{0, 4,	6,	8,	9,	10, 13, 16, 15},
	{0, 4,	5,	7,	8,	9,	12, 15, 15},
	{0, 4,	5,	7,	8,	9,	11, 15, 14},
	{0, 4,	5,	7,	7,	8,	11, 14, 14},
	{0, 4,	5,	6,	7,	8,	10, 14, 14},
	{0, 4,	5,	6,	6,	7,	10, 13, 13},
	{0, 3,	4,	5,	6,	6,	9,	12, 12},
	{0, 3,	4,	5,	6,	6,	9,	12, 12},
	{0, 3,	4,	5,	6,	6,	8,	12, 12},
	{0, 3,	4,	5,	5,	6,	8,	12, 12},
	{0, 3,	4,	5,	5,	5,	8,	11, 11},
	{0, 3,	4,	4,	4,	5,	7,	10, 10},
	{0, 3,	3,	4,	4,	5,	7,	10, 10},
	{0, 3,	3,	4,	4,	4,	6,	9,	9},
	{0, 3,	3,	4,	4,	4,	6,	9,	9},
	{0, 3,	3,	4,	3,	4,	6,	9,	9},
	{0, 3,	3,	3,	3,	3,	6,	8,	8},
	{0, 3,	3,	3,	3,	3,	6,	8,	8},
	{0, 3,	3,	3,	3,	3,	5,	7,	8},
	{0, 3,	3,	3,	3,	3,	5,	7,	7},
	{0, 3,	3,	3,	3,	3,	5,	7,	7},
	{0, 3,	2,	3,	3,	2,	4,	6,	7},
	{0, 3,	2,	3,	2,	2,	4,	6,	6},
	{0, 3,	2,	3,	2,	2,	4,	5,	6},
	{0, 3,	2,	2,	2,	2,	4,	5,	6},
	{0, 3,	1,	2,	2,	1,	4,	5,	5},
	{0, 2,	1,	2,	2,	1,	3,	4,	5},
	{0, 2,	1,	2,	2,	1,	3,	4,	4},
	{0, 2,	1,	2,	2,	1,	3,	4,	4},
	{0, 2,	2,	2,	2,	1,	2,	4,	3},
	{0, 2,	2,	1,	1,	1,	3,	4,	3},
	{0, 3,	2,	1,	1,	2,	3,	4,	3},
	{0, 1,	3,	2,	1,	1,	2,	3,	3},
	{0, 2,	3,	1,	1,	1,	2,	3,	3},
	{0, 2,	3,	3,	2,	1,	2,	3,	3},
	{0, 2,	4,	2,	1,	1,	2,	3,	3},
	{0, 1,	3,	2,	1,	2,	1,	2,	3},
	{0, 0,	3,	2,	2,	1,	2,	2,	2},
	{0, 0,	3,	1,	1,	1,	2,	2,	2},
	{0, 1,	3,	2,	1,	1,	1,	2,	2},
	{0, 2,	4,	2,	1,	1,	2,	2,	2},
	{0, 1,	4,	2,	1,	0,	1,	1,	2},
	{0, 1,	3,	1,	1,	0,	1,	1,	2},
	{0, 1,	4,	2,	1,	1,	1,	2,	2},
	{0, 1,	3,	1,	1,	1,	1,	1,	2},
	{0, 1,	3,	1,	1,	1,	1,	1,	2},
	{0, 1,	3,	1,	1,	1,	0,	1,	1},
	{0, 1,	3,	1,	1,	1,	0,	1,	1},
	{0, 1,	2,	1,	1,	1,	0,	1,	1},
	{0, 0,	2,	1,	0,	1,	1,	1,	0},
	{0, 0,	1,	1,	0,	0,	0,	0,	0},
	{0, 0,	1,	0,	0,	0,	0,	0,	0},
	{0, 0,	1,	-1, 0,	-1, 0,	0,	0},
	{0, -1, 0,	-1, -1, -1, -1, 0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-5,	1,	-6, -4, 0,	-3, -3, 0,	-2, -10,	1,	-4, -16,	4,	-8, -11,	2,	-6, -6, 3,	-6, -5, 3,	-7,0,0,0},
	{-4,	1,	-5, -3, 0,	-3, -3, 0,	-2, -9, 1,	-4, -12,	3,	-7, -10,	3,	-7, -6, 3,	-6, -5, 3,	-7,0,0,0},
	{-2,	1,	-4, -3, 0,	-2, -2, 0,	-2, -7, 2,	-4, -10,	2,	-6, -10,	3,	-8, -7, 2,	-6, -1, 3,	-7,0,0,0},
	{-2,	0,	-4, -2, 0,	-2, -3, 0,	-2, -6, 2,	-4, -9, 3,	-6, -7, 3,	-7, -7, 3,	-8, -2, 3,	-7,0,0,0},
	{-2,	0,	-4, -1, 0,	-1, -2, 0,	-2, -6, 2,	-4, -7, 2,	-6, -5, 3,	-8, -7, 3,	-7, -4, 4,	-8,0,0,0},
	{-1,	0,	-3, -1, 0,	-1, -2, 0,	-2, -5, 1,	-4, -7, 2,	-5, -5, 4,	-8, -7, 3,	-8, -4, 3,	-8,0,0,0},
	{0, 0,	-2, -1, 0,	-1, -2, 0,	-2, -5, 1,	-4, -7, 2,	-5, -4, 4,	-9, -5, 3,	-8, -3, 4,	-8,0,0,0},
	{0, 0,	-2, -1, 0,	-1, -1, 0,	-1, -4, 1,	-3, -5, 2,	-4, -4, 4,	-9, -4, 4,	-8, -4, 3,	-8,0,0,0},
	{0, 0,	-1, 0,	0,	-1, -2, 0,	-2, -3, 1,	-2, -6, 2,	-5, -3, 3,	-8, -5, 4,	-10,	-3, 4,	-10,0,0,0},
	{1, 0,	0,	0,	0,	-1, -2, 0,	-2, -4, 1,	-3, -5, 2,	-5, -3, 3,	-6, -4, 4,	-10,	-3, 4,	-8,0,0,0},
	{1, 0,	0,	0,	0,	-1, -2, 0,	-1, -3, 1,	-3, -5, 2,	-5, -3, 3,	-6, -3, 4,	-10,	-2, 4,	-8,0,0,0},
	{1, 0,	0,	0,	0,	0,	-1, 0,	-1, -3, 1,	-3, -5, 2,	-5, -2, 3,	-6, -4, 4,	-10,	-1, 5,	-11,0,0,0},
	{1, 0,	0,	0,	0,	0,	-1, 0,	-1, -2, 1,	-2, -4, 2,	-4, -2, 3,	-6, -3, 5,	-11,	-1, 3,	-8,0,0,0},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-2, 1,	-2, -4, 2,	-4, -3, 2,	-6, -2, 4,	-10,	-2, 6,	-13,0,0,0},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-2, 1,	-2, -4, 1,	-4, -3, 2,	-5, -2, 5,	-12,	-2, 4,	-10,0,0,0},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-2, 1,	-2, -4, 1,	-4, -3, 2,	-5, -2, 4,	-10,	0,	6,	-14,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-2, 1,	-2, -3, 1,	-3, -3, 1,	-4, -3, 4,	-10,	0,	7,	-16,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -4, 1,	-4, -3, 1,	-4, -2, 4,	-9, 0,	7,	-16,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -3, 1,	-3, -3, 1,	-4, -3, 5,	-10,	0,	5,	-10,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -3, 1,	-3, -3, 1,	-4, -2, 5,	-10,	0,	4,	-10,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -3, 1,	-3, -4, 1,	-4, -3, 4,	-8, 0,	6,	-14,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -4, 1,	-4, -2, 1,	-3, -2, 5,	-10,	1,	7,	-16,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -3, 1,	-3, -2, 1,	-3, -3, 4,	-9, 0,	6,	-14,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3, 1,	-3, -3, 1,	-3, -3, 5,	-11,	0,	7,	-16,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3, 1,	-2, -3, 1,	-4, -2, 4,	-10,	0,	7,	-14,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3, 0,	-2, -2, 1,	-2, -3, 4,	-10,	0,	6,	-13,0,0,0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3, 1,	-2, -2, 1,	-3, -2, 4,	-8, 0,	8,	-18,0,0,0},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -2, 1,	-3, -3, 3,	-8, 0,	7,	-16,0,0,0},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -1, 1,	-2, -2, 4,	-8, 0,	8,	-17,0,0,0},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -1, 1,	-2, -3, 4,	-8, 1,	7,	-14,0,0,0},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -1, 0,	-2, -4, 3,	-8, 0,	6,	-14,0,0,0},
	{2, 0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -1, 1,	-2, -1, 4,	-8, 0,	6,	-14,0,0,0},
	{2, 0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, -1, 0,	-2, -2, 3,	-8, 0,	6,	-12,0,0,0},
	{2, 0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	-1, -2, 3,	-8, -1, 8,	-17,0,0,0},
	{2, 0,	2,	2,	0,	2,	0,	0,	-1, 0,	0,	0,	-1, 0,	0,	-1, 0,	-2, -1, 3,	-7, -1, 6,	-14,0,0,0},
	{2, 0,	2,	2,	0,	2,	0,	0,	-1, 0,	0,	0,	-1, 0,	0,	0,	0,	-1, -1, 3,	-7, -1, 5,	-11,0,0,0},
	{2, 0,	2,	2,	0,	2,	0,	0,	-1, 0,	0,	0,	-1, 0,	0,	0,	0,	0,	-1, 4,	-9, 0,	6,	-13,0,0,0},
	{2, 0,	2,	2,	0,	2,	0,	0,	-1, 0,	0,	0,	-1, 0,	0,	0,	0,	0,	0,	4,	-8, 0,	5,	-10,0,0,0},
	{2, 0,	2,	2,	0,	2,	0,	0,	-1, 0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 3,	-8, -1, 4,	-10,0,0,0},
	{2, 0,	2,	2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 3,	-8, 0,	4,	-9,0,0,0},
	{2, 0,	2,	2,	0,	2,	0,	0,	0,	0,	0,	1,	0,	0,	0,	1,	0,	0,	0,	2,	-6, -2, 4,	-10,0,0,0},
	{2, 0,	2,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	2,	-6, -1, 3,	-8,0,0,0},
	{2, 0,	2,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	2,	-6, -1, 4,	-8,0,0,0},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	1,	0,	0,	0,	1,	0,	0,	0,	2,	-5, -1, 3,	-6,0,0,0},
	{1, 0,	1,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-4, -3, 4,	-8,0,0,0},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	2,	-4, -2, 3,	-8,0,0,0},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-4, -3, 3,	-7,0,0,0},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-4, -4, 3,	-8,0,0,0},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	-1, 0,	0,	0,	-1, 0,	0,	0,	1,	-3, -3, 3,	-6,0,0,0},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	0,	0,	-1, -1, 0,	0,	0,	0,	0,	-1, 1,	-4, -4, 2,	-6,0,0,0},
	{1, 0,	1,	1,	0,	1,	1,	0,	1,	-1, 0,	-1, 0,	0,	0,	0,	0,	0,	-1, 1,	-3, -2, 3,	-6,0,0,0},
	{1, 0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	1,	0,	0,	0,	1,	0,	1,	0,	1,	-2, -4, 2,	-6,0,0,0},
	{1, 0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	-2, -3, 2,	-6,0,0,0},
	{1, 0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-2, -3, 2,	-4,0,0,0},
	{1, 0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	-1, 0,	0,	0,	0,	0,	0,	0,	-2, -2, 2,	-4,0,0,0},
	{1, 0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	-1, 0,	0,	1,	0,	0,	-1, 0,	-2, -2, 1,	-4,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	0,	1,	0,	0,	0,	0,	-2, -1, 1,	-2,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	0,	0,	1,	0,	0,	0,	0,	-2, -1, 0,	-2,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,0,0,0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,0,0,0},
};

/* HERO rev C */

static unsigned int base_luminance_revC[LUMINANCE_MAX][2] = {
	{2,	    485909238 },
	{3,	    485909238 },
	{4,	    485909238 },
	{5,	    485909238 },
	{6,	    485909238 },
	{7,	    485909238 },
	{8,	    485909238 },
	{9,	    485909238 },
	{10,	485909238 },
	{11,	485909238 },
	{12,	485909238 },
	{13,	485909238 },
	{14,	485909238 },
	{15,	485909238 },
	{16,	485909238 },
	{17,	485909238 },
	{19,	485909238 },
	{20,	485909238 },
	{21,	485909238 },
	{22,	485909238 },
	{24,	485909238 },
	{25,	485909238 },
	{27,	485909238 },
	{29,	485909238 },
	{30,	485909238 },
	{32,	485909238 },
	{34,	485909238 },
	{37,	485909238 },
	{39,	485909238 },
	{41,	485909238 },
	{44,	485909238 },
	{47,	485909238 },
	{50,	485909238 },
	{53,	485909238 },
	{56,	485909238 },
	{60,	485909238 },
	{64,	485909238 },
	{68,	508780436 },
	{72,	532226595 },
	{77,	572587609 },
	{82,	606038247 },
	{87,	640527419 },
	{93,	676060365 },
	{98,	703398144 },
	{105,	750278022 },
	{111,	788972715 },
	{119,	838837528 },
	{126,	890373719 },
	{134,	932812175 },
	{143,	987379611 },
	{152,	1043643384},
	{162,	1113411129},
	{172,	1161294047},
	{183,	1222697574},
	{195,	1222697574},
	{207,	1222697574},
	{220,	1222697574},
	{234,	1222697574},
	{249,	1222697574},
	{265,	1285830728},
	{282,	1363884783},
	{300,	1444454361},
	{316,	1513526759},
	{333,	1570054049},
	{350,	1627713756},
	{357,	1656969429},
	{365,	1686509598},
	{372,	1686509598},
	{380,	1686509598},
	{387,	1686509598},
	{395,	1686509598},
	{403,	1686509598},
	{412,	1731354279},
	{420,	1761607680},
};

static int gradation_offset_revC[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{1,	9,	14,	20,	25,	28,	32,	32,	19},
	{0,	7,	13,	19,	23,	26,	28,	30,	19},
	{0,	7,	11,	18,	21,	24,	26,	29,	19},
	{0,	7,	11,	17,	19,	21,	22,	25,	19},
	{0,	7,	11,	15,	18,	20,	21,	24,	19},
	{0,	8,	11,	14,	17,	19,	20,	23,	19},
	{0,	6,	9,	13,	16,	18,	20,	23,	19},
	{0,	6,	9,	13,	16,	18,	19,	23,	19},
	{0,	4,	7,	12,	15,	16,	18,	21,	19},
	{0,	6,	7,	12,	15,	16,	17,	20,	19},
	{0,	6,	7,	11,	14,	15,	16,	19,	19},
	{0,	5,	7,	10,	13,	14,	15,	18,	19},
	{0,	5,	6,	9,	12,	13,	14,	17,	18},
	{0,	4,	7,	9,	12,	13,	14,	17,	18},
	{0,	5,	6,	9,	12,	13,	14,	17,	18},
	{0,	5,	6,	8,	11,	12,	13,	16,	17},
	{0,	3,	7,	7,	10,	11,	11,	14,	17},
	{1,	5,	3,	4,	10,	11,	11,	14,	16},
	{0,	6,	5,	7,	10,	11,	11,	14,	15},
	{0,	4,	5,	6,	8,	10,	10,	13,	15},
	{0,	4,	5,	6,	8,	9,	9,	12,	14},
	{0,	4,	5,	6,	8,	9,	9,	12,	14},
	{0,	4,	5,	6,	8,	9,	9,	12,	14},
	{0,	4,	5,	6,	8,	9,	9,	12,	14},
	{0,	4,	5,	6,	7,	8,	8,	11,	13},
	{0,	4,	4,	5,	7,	8,	8,	11,	13},
	{0,	4,	4,	5,	6,	7,	7,	10,	12},
	{0,	4,	4,	4,	5,	6,	6,	8,	9},
	{0,	4,	4,	4,	5,	6,	6,	8,	9},
	{0,	4,	4,	4,	5,	5,	5,	7,	9},
	{0,	4,	4,	4,	5,	5,	5,	7,	9},
	{0,	4,	4,	4,	5,	5,	5,	6,	8},
	{0,	4,	3,	3,	5,	5,	5,	6,	8},
	{0,	4,	3,	3,	5,	5,	5,	6,	8},
	{0,	4,	3,	3,	5,	5,	5,	6,	8},
	{0,	4,	3,	3,	4,	4,	4,	5,	7},
	{0,	3,	3,	3,	4,	4,	4,	5,	7},
	{0,	3,	2,	2,	3,	3,	4,	5,	7},
	{0,	3,	2,	2,	2,	3,	4,	5,	7},
	{0,	4,	3,	4,	3,	3,	3,	3,	5},
	{0,	4,	4,	4,	3,	3,	4,	5,	5},
	{0,	4,	6,	5,	5,	4,	4,	5,	2},
	{0,	4,	4,	4,	4,	4,	4,	4,	5},
	{0,	1,	5,	3,	4,	4,	4,	4,	4},
	{0,	3,	4,	5,	3,	3,	4,	4,	3},
	{0,	3,	4,	4,	3,	4,	3,	4,	3},
	{0,	3,	6,	5,	4,	4,	4,	5,	3},
	{0,	3,	6,	6,	4,	4,	3,	3,	2},
	{0,	4,	7,	5,	4,	4,	3,	3,	2},
	{0,	4,	7,	5,	4,	4,	3,	3,	2},
	{0,	4,	7,	6,	4,	4,	3,	3,	2},
	{0,	4,	7,	6,	4,	4,	3,	3,	2},
	{0,	4,	6,	6,	5,	5,	4,	4,	2},
	{0,	3,	5,	5,	2,	2,	2,	3,	1},
	{0,	3,	6,	4,	3,	3,	2,	2,	1},
	{0,	3,	6,	4,	3,	3,	2,	2,	1},
	{0,	3,	6,	4,	3,	3,	2,	2,	1},
	{0,	3,	6,	4,	3,	3,	2,	2,	1},
	{0,	3,	5,	3,	2,	2,	1,	1,	1},
	{0,	1,	3,	3,	2,	2,	2,	2,	1},
	{0,	2,	4,	3,	2,	1,	1,	1,	0},
	{0,	2,	2,	2,	2,	2,	1,	0,	0},
	{0,	2,	2,	1,	1,	1,	0,	0,	0},
	{0,	1,	2,	1,	1,	0,	0,	0,	0},
	{0,	1,	2,	1,	1,	1,	1,	1,	0},
	{0,	1,	2,	2,	1,	0,	0,	1,	0},
	{0,	0,	2,	2,	0,	0,	0,	0,	0},
	{0,	1,	1,	2,	1,	1,	1,	0,	0},
	{0,	1,	1,	1,	0,	0,	0,	0,	0},
	{0,	1,	1,	1,	0,	0,	0,	0,	0},
	{0,	1,	1,	1,	0,	0,	0,	0,	0},
	{0,	1,	1,	1,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_revC[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-9,	1,	-8,	-4,	-2,	-4,	-3,	0,	-3,	-10,	2,	-9,	-11,	5,	-12,	0,	2,	-12,	-11,	1,	-7,	-10,	1,	-4,	-10,	1,	-4},
	{-4,	3,	-4,	-4,	-2,	-4,	-3,	0,	-4,	-12,	0,	-9,	-15,	2,	-15,	-11,	4,	-11,	-6,	1,	-13,	0,	-3,	-5,	-14,	1,	-5},
	{-2,	3,	-2,	-3,	-1,	-3,	-1,	1,	-2,	-14,	-3,	-12,	-16,	-1,	-15,	-14,	0,	-14,	-6,	1,	-15,	-17,	0,	-10,	-17,	0,	-10},
	{-2,	3,	-2,	-2,	-2,	-2,	-8,	-2,	-6,	-7,	0,	-7,	-14,	1,	-13,	-12,	2,	-12,	-9,	2,	-14,	-13,	1,	-8,	-13,	1,	-8},
	{-1,	3,	-1,	-3,	-3,	-4,	-3,	0,	-3,	-8,	1,	-6,	-15,	-1,	-14,	-9,	1,	-10,	-10,	1,	-13,	-18,	2,	-8,	-18,	2,	-8},
	{-1,	2,	-1,	-3,	-2,	-3,	-1,	0,	-2,	-9,	-1,	-8,	-12,	0,	-12,	-14,	1,	-15,	-13,	2,	-16,	-13,	2,	-10,	-13,	2,	-10},
	{-1,	1,	-1,	-1,	-1,	-2,	-3,	0,	-2,	-9,	0,	-8,	-11,	-1,	-12,	-15,	-1,	-17,	-12,	-1,	-16,	-12,	2,	-11,	-12,	2,	-11},
	{-1,	2,	-1,	-2,	-3,	-3,	-2,	-1,	-2,	-8,	0,	-6,	-14,	-1,	-14,	-14,	-1,	-17,	-12,	0,	-19,	-14,	-2,	-16,	-16,	-2,	-16},
	{-1,	1,	-1,	-3,	-2,	-3,	-1,	-1,	1,	-11,	-2,	-11,	-9,	-1,	-11,	-9,	2,	-14,	-13,	1,	-15,	-3,	1,	-16,	13,	0,	15},
	{-3,	-1,	-3,	-1,	-1,	0,	0,	0,	-1,	-6,	0,	-7,	-16,	-5,	-16,	-8,	3,	-12,	-7,	5,	-10,	-6,	2,	-18,	8,	6,	8},
	{1,	3,	2,	-4,	-6,	-5,	0,	1,	-1,	-10,	-3,	-9,	-10,	0,	-9,	-10,	0,	-14,	-5,	7,	-9,	-5,	0,	-19,	2,	0,	2},
	{-1,	0,	-1,	1,	0,	0,	-1,	0,	-1,	-9,	-4,	-9,	-10,	-1,	-10,	-9,	2,	-14,	-5,	6,	-10,	-8,	1,	-19,	2,	0,	2},
	{-2,	-1,	-1,	-1,	-3,	-3,	2,	3,	1,	-7,	-1,	-6,	-12,	-4,	-13,	-6,	5,	-10,	-6,	4,	-13,	-6,	3,	-17,	5,	2,	5},
	{2,	2,	2,	-1,	-2,	-2,	-3,	-2,	-2,	-4,	1,	-3,	-14,	-6,	-16,	-3,	7,	-7,	-9,	2,	-16,	-7,	1,	-19,	3,	-1,	3},
	{-1,	0,	-1,	0,	-1,	0,	0,	0,	-1,	-7,	-3,	-6,	-11,	-2,	-13,	-7,	3,	-10,	-7,	3,	-13,	-10,	2,	-22,	6,	2,	5},
	{2,	2,	2,	-3,	-4,	-4,	2,	2,	2,	-4,	0,	-4,	-14,	-5,	-15,	-5,	4,	-7,	-10,	3,	-15,	-9,	3,	-20,	9,	5,	7},
	{2,	1,	2,	-3,	-4,	-3,	-4,	-3,	-4,	-1,	3,	-1,	-11,	-3,	-11,	-8,	2,	-8,	-5,	7,	-11,	-6,	6,	-18,	-3,	-3,	-4},
	{3,	2,	3,	-3,	-4,	-3,	3,	2,	3,	-2,	3,	-2,	-8,	-3,	-8,	-12,	-3,	-14,	-7,	6,	-13,	-6,	4,	-20,	1,	-3,	-1},
	{2,	1,	2,	-3,	-3,	-4,	3,	2,	3,	-6,	-2,	-6,	-9,	-3,	-9,	-10,	0,	-11,	-6,	6,	-12,	-7,	6,	-19,	5,	3,	4},
	{3,	2,	3,	-3,	-4,	-3,	-2,	-3,	-3,	0,	3,	0,	-7,	-1,	-7,	-10,	-1,	-10,	-7,	6,	-13,	-5,	6,	-18,	2,	-2,	-2},
	{1,	0,	1,	-2,	-3,	-2,	-2,	-3,	-3,	0,	3,	0,	-8,	-2,	-8,	-6,	2,	-6,	-8,	4,	-14,	-4,	7,	-18,	1,	-3,	-1},
	{0,	0,	1,	0,	-2,	-1,	-2,	-3,	-2,	-3,	-1,	-3,	-6,	0,	-6,	-7,	1,	-8,	-6,	5,	-12,	-8,	7,	-20,	1,	-3,	-3},
	{0,	-1,	0,	-2,	-3,	-2,	3,	2,	3,	-4,	-2,	-4,	-8,	-2,	-8,	-7,	0,	-8,	-9,	3,	-14,	-7,	7,	-20,	1,	-3,	-3},
	{0,	-1,	0,	-2,	-3,	-2,	3,	2,	3,	-5,	-3,	-5,	-8,	-3,	-8,	-6,	0,	-7,	-10,	3,	-15,	-8,	5,	-21,	2,	-3,	-3},
	{1,	1,	1,	-1,	-4,	-1,	-2,	-3,	-3,	-3,	-1,	-3,	-5,	0,	-5,	-6,	1,	-6,	-8,	4,	-12,	-8,	5,	-21,	1,	-3,	-3},
	{1,	1,	1,	-1,	-4,	-1,	-2,	-3,	-3,	0,	3,	0,	-7,	-3,	-7,	-8,	-1,	-9,	-7,	4,	-11,	-8,	3,	-23,	1,	-1,	-4},
	{2,	1,	2,	-4,	-5,	-4,	1,	0,	1,	-4,	0,	-3,	-4,	-1,	-4,	-5,	1,	-6,	-9,	2,	-14,	-7,	6,	-21,	3,	2,	-1},
	{0,	-1,	0,	-2,	-3,	-2,	3,	2,	3,	-3,	-1,	-3,	-3,	0,	-3,	-5,	1,	-6,	-5,	5,	-8,	-3,	10,	-17,	7,	5,	2},
	{1,	0,	1,	-3,	-5,	-4,	0,	-2,	0,	0,	3,	0,	-6,	-3,	-5,	-2,	3,	-3,	-7,	2,	-11,	-4,	10,	-17,	5,	2,	-1},
	{1,	0,	1,	0,	-2,	0,	-2,	-3,	-3,	-3,	0,	-2,	-2,	0,	-2,	0,	6,	-1,	-7,	3,	-8,	-1,	12,	-14,	1,	-1,	-5},
	{1,	0,	1,	-2,	-3,	-1,	2,	0,	1,	-5,	-3,	-5,	0,	3,	0,	-4,	2,	-4,	-4,	4,	-5,	-5,	9,	-18,	0,	-1,	-8},
	{0,	0,	0,	1,	-1,	1,	-2,	-3,	-2,	-2,	0,	-1,	-3,	-1,	-3,	-6,	-1,	-7,	-1,	7,	-3,	-3,	13,	-14,	-3,	2,	-5},
	{0,	-1,	0,	-1,	-2,	0,	2,	0,	1,	-4,	-3,	-4,	-6,	-3,	-6,	-3,	2,	-3,	-4,	3,	-6,	-2,	15,	-11,	-5,	-1,	-8},
	{1,	0,	1,	-3,	-5,	-3,	4,	3,	4,	-2,	0,	-2,	-9,	-6,	-8,	0,	4,	0,	-7,	-1,	-9,	-4,	12,	-15,	-2,	1,	-5},
	{0,	0,	0,	0,	-2,	1,	1,	0,	0,	-5,	-3,	-4,	-5,	-3,	-4,	-3,	1,	-4,	-4,	1,	-6,	-6,	10,	-17,	-3,	-1,	-8},
	{1,	0,	2,	-1,	-2,	-2,	-1,	-3,	-1,	-1,	0,	0,	-2,	0,	-2,	0,	4,	-2,	-7,	-1,	-9,	-6,	10,	-15,	-1,	2,	-5},
	{1,	0,	1,	-1,	-2,	0,	2,	0,	1,	-3,	-3,	-3,	-5,	-2,	-5,	-3,	1,	-4,	-4,	2,	-5,	-8,	9,	-18,	-3,	-1,	-8},
	{1,	1,	1,	-1,	-3,	-2,	-1,	-3,	-1,	0,	1,	0,	-2,	1,	-1,	-5,	-2,	-6,	-1,	4,	-2,	-10,	7,	-20,	-1,	2,	-5},
	{0,	0,	2,	1,	-2,	-1,	-1,	-3,	-2,	0,	1,	2,	-1,	0,	-1,	1,	3,	-1,	-6,	-1,	-8,	-10,	7,	-18,	-4,	1,	-5},
	{0,	-1,	0,	0,	-1,	-1,	0,	-2,	1,	-1,	-1,	-1,	-4,	-2,	-4,	3,	6,	2,	-3,	2,	-4,	0,	15,	-11,	-7,	-3,	-8},
	{-1,	-1,	0,	0,	-2,	0,	3,	1,	0,	-4,	-3,	-2,	-1,	1,	0,	0,	1,	-1,	-5,	-1,	-7,	-6,	11,	-13,	5,	5,	-2},
	{-1,	-1,	1,	1,	-2,	-1,	-1,	-2,	-1,	0,	1,	0,	-4,	-2,	-4,	2,	4,	2,	-1,	2,	-4,	-9,	9,	-15,	22,	20,	15},
	{-1,	-1,	0,	0,	-2,	-1,	3,	1,	3,	-3,	-2,	-2,	-1,	0,	-1,	-1,	1,	-2,	-5,	-1,	-7,	-5,	11,	-10,	6,	5,	0},
	{0,	-1,	1,	2,	1,	0,	-1,	-2,	-1,	1,	2,	1,	-5,	-3,	-4,	-4,	-2,	-4,	-2,	2,	-3,	-3,	14,	-8,	10,	8,	3},
	{0,	0,	1,	2,	1,	1,	2,	1,	1,	-4,	-3,	-2,	0,	0,	-1,	0,	1,	0,	-4,	-1,	-6,	-5,	11,	-10,	15,	13,	6},
	{0,	0,	1,	2,	0,	1,	-2,	-2,	-2,	2,	0,	1,	-3,	-3,	-3,	-3,	-1,	-3,	-1,	2,	-2,	-5,	11,	-7,	13,	14,	9},
	{1,	0,	1,	-2,	-3,	-3,	2,	1,	2,	-2,	-3,	-2,	0,	0,	-1,	-1,	2,	0,	-4,	-1,	-6,	-8,	7,	-10,	17,	17,	12},
	{0,	0,	1,	-1,	-3,	-1,	0,	-2,	-1,	0,	1,	0,	-3,	-3,	-3,	-4,	-1,	-2,	-1,	3,	-3,	-2,	11,	-7,	14,	14,	10},
	{1,	0,	1,	-1,	-2,	-2,	2,	1,	1,	-3,	-2,	-1,	-1,	0,	-1,	-1,	2,	0,	1,	4,	0,	-5,	8,	-9,	12,	11,	7},
	{0,	0,	1,	-1,	-2,	-1,	-1,	-1,	-2,	1,	1,	3,	-2,	-2,	-4,	-3,	-1,	-3,	3,	7,	3,	-2,	10,	-5,	14,	14,	10},
	{1,	0,	2,	-1,	-2,	-2,	1,	2,	1,	-2,	-3,	-1,	-1,	0,	-1,	-5,	-4,	-5,	5,	10,	6,	0,	10,	-2,	12,	11,	7},
	{0,	-1,	1,	-2,	-2,	-3,	0,	-1,	0,	1,	1,	0,	1,	3,	2,	-7,	-7,	-8,	2,	6,	3,	0,	9,	-5,	16,	15,	10},
	{0,	0,	1,	0,	-1,	0,	1,	2,	1,	-2,	-3,	-2,	-2,	-1,	-1,	-4,	-4,	-4,	0,	3,	0,	-3,	7,	-8,	19,	20,	13},
	{0,	0,	1,	-3,	-3,	-2,	4,	3,	3,	-3,	-4,	-2,	2,	4,	2,	2,	3,	2,	-5,	-3,	-6,	-2,	7,	-5,	22,	19,	15},
	{-1,	0,	1,	1,	0,	1,	-2,	-3,	-2,	3,	0,	1,	-1,	0,	0,	-1,	0,	-2,	-2,	0,	-2,	1,	10,	-1,	19,	17,	12},
	{0,	1,	2,	0,	-2,	-1,	1,	1,	1,	-1,	-3,	-1,	2,	2,	2,	-4,	-3,	-4,	1,	3,	0,	-2,	7,	-2,	16,	15,	9},
	{0,	0,	2,	-1,	-1,	-1,	-2,	-3,	-2,	3,	1,	2,	0,	-1,	-1,	-2,	0,	-1,	-2,	-1,	-3,	0,	9,	1,	13,	13,	6},
	{-1,	0,	0,	-1,	-2,	0,	1,	0,	0,	0,	-2,	0,	2,	2,	1,	-5,	-4,	-4,	1,	2,	-1,	-5,	4,	-2,	11,	15,	9},
	{0,	1,	2,	-1,	-2,	-1,	0,	0,	0,	0,	-1,	0,	0,	0,	1,	-2,	-1,	-2,	1,	2,	1,	-2,	6,	-1,	4,	8,	3},
	{1,	1,	1,	0,	-1,	0,	-1,	0,	0,	0,	0,	-1,	1,	0,	1,	-1,	-1,	-1,	3,	3,	3,	-3,	-2,	-2,	0,	0,	-1},
	{0,	1,	1,	-1,	-2,	-1,	1,	0,	1,	0,	0,	-1,	-1,	-1,	-1,	0,	0,	0,	-1,	0,	-2,	-5,	2,	-3,	8,	12,	8},
	{1,	1,	2,	-1,	-1,	-1,	0,	0,	0,	0,	-1,	0,	-1,	-1,	-1,	-2,	-1,	-2,	2,	2,	1,	1,	6,	3,	2,	5,	1},
	{0,	0,	1,	1,	0,	1,	-1,	0,	0,	1,	-1,	0,	0,	1,	0,	-2,	-2,	-1,	2,	2,	1,	0,	4,	2,	2,	4,	2},
	{1,	1,	2,	-1,	-1,	-2,	0,	0,	0,	1,	0,	1,	0,	0,	0,	-1,	0,	-1,	2,	2,	1,	-1,	3,	2,	0,	3,	0},
	{1,	1,	2,	1,	1,	1,	-1,	0,	0,	1,	-1,	1,	0,	0,	-1,	1,	1,	1,	-1,	0,	-1,	-3,	0,	-2,	6,	9,	7},
	{1,	1,	1,	0,	0,	1,	-1,	-1,	-2,	0,	-1,	0,	2,	2,	2,	-1,	0,	-1,	0,	-1,	0,	-4,	0,	-2,	6,	7,	6},
	{2,	2,	2,	0,	0,	1,	0,	0,	-1,	0,	-1,	0,	-1,	0,	-1,	1,	1,	2,	1,	0,	-1,	-4,	-1,	-2,	7,	8,	7},
	{-1,	0,	-1,	0,	0,	0,	1,	1,	1,	0,	-2,	0,	-2,	0,	-2,	0,	0,	0,	-1,	-2,	-2,	-1,	4,	2,	6,	8,	6},
	{-1,	0,	0,	-1,	-1,	-1,	1,	1,	1,	1,	-1,	0,	0,	1,	-1,	0,	0,	1,	1,	1,	0,	-1,	0,	-1,	7,	8,	6},
	{0,	0,	0,	-1,	-1,	0,	-2,	-2,	-3,	3,	2,	3,	0,	0,	-1,	0,	1,	1,	0,	-1,	-1,	-2,	0,	-2,	6,	8,	6},
	{1,	1,	1,	-1,	-1,	-1,	0,	0,	-1,	1,	0,	1,	1,	2,	1,	0,	0,	0,	0,	0,	-1,	-1,	-1,	-1,	6,	7,	6},
	{2,	3,	3,	-1,	-1,	0,	1,	0,	-1,	0,	0,	0,	1,	1,	0,	-1,	0,	1,	1,	0,	-1,	-3,	-2,	-2,	7,	7,	6},
	{1,	2,	1,	-2,	-2,	-1,	1,	1,	0,	1,	0,	2,	1,	1,	-1,	0,	1,	1,	-1,	-1,	-1,	-2,	-2,	-3,	0,	1,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

/* HERO2 revA */

static unsigned int base_luminance_hero2_revA[LUMINANCE_MAX][2] = {
	{2, 	485909238 },
	{3, 	485909238 },
	{4, 	485909238 },
	{5, 	485909238 },
	{6, 	485909238 },
	{7, 	485909238 },
	{8, 	485909238 },
	{9, 	485909238 },
	{10,	485909238 },
	{11,	485909238 },
	{12,	485909238 },
	{13,	485909238 },
	{14,	485909238 },
	{15,	485909238 },
	{16,	485909238 },
	{17,	485909238 },
	{19,	485909238 },
	{20,	485909238 },
	{21,	485909238 },
	{22,	485909238 },
	{24,	485909238 },
	{25,	485909238 },
	{27,	485909238 },
	{29,	485909238 },
	{30,	485909238 },
	{32,	485909238 },
	{34,	485909238 },
	{37,	485909238 },
	{39,	485909238 },
	{41,	485909238 },
	{44,	485909238 },
	{47,	485909238 },
	{50,	485909238 },
	{53,	485909238 },
	{56,	485909238 },
	{60,	485909238 },
	{64,	485909238 },
	{68,	508780436 },
	{72,	532226595 },
	{77,	572587609 },
	{82,	606038247 },
	{87,	640527419 },
	{93,	676060365 },
	{98,	703398144 },
	{105,	750278022 },
	{111,	788972715 },
	{119,	838837528 },
	{126,	879932331 },
	{134,	911458223 },
	{143,	965349562 },
	{152,	1020933762},
	{162,	1078219461},
	{172,	1137215126},
	{183,	1210278755},
	{195,	1210278755},
	{207,	1210278755},
	{220,	1210278755},
	{234,	1210278755},
	{249,	1222697574},
	{265,	1285830728},
	{282,	1350701444},
	{300,	1444454361},
	{316,	1513526759},
	{333,	1570054049},
	{350,	1656969429},
	{357,	1671703923},
	{365,	1701386511},
	{372,	1701386511},
	{380,	1701386511},
	{387,	1701386511},
	{395,	1701386511},
	{403,	1716334719},
	{412,	1746445247},
	{420,	1761607680},
};

static int gradation_offset_hero2_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{3, 7,	9,	13, 18, 18, 20, 13, 9},
	{1, 6,	8,	13, 18, 22, 24, 15, 12},
	{1, 4,	7,	12, 16, 19, 20, 16, 13},
	{1, 3,	5,	10, 14, 16, 18, 15, 11},
	{1, 4,	6,	11, 14, 16, 18, 14, 8},
	{1, 4,	5,	9,	13, 15, 17, 16, 9},
	{1, 4,	5,	9,	12, 14, 16, 15, 9},
	{1, 3,	4,	8,	11, 13, 15, 16, 9},
	{1, 3,	4,	7,	11, 13, 15, 17, 10},
	{1, 3,	3,	6,	10, 12, 14, 17, 11},
	{1, 3,	3,	6,	10, 12, 14, 17, 11},
	{0, 3,	3,	6,	9,	11, 13, 16, 11},
	{0, 3,	3,	6,	9,	11, 13, 16, 15},
	{0, 2,	1,	4,	7,	9,	11, 15, 14},
	{0, 3,	2,	4,	7,	9,	11, 15, 14},
	{0, 3,	1,	4,	7,	9,	11, 14, 13},
	{0, 2,	1,	3,	6,	8,	9,	13, 12},
	{0, 1,	1,	2,	5,	7,	8,	12, 11},
	{0, 1,	0,	2,	5,	7,	8,	12, 11},
	{0, 0,	1,	2,	5,	7,	8,	12, 11},
	{0, 0,	1,	2,	5,	7,	8,	12, 12},
	{0, 3,	1,	2,	5,	7,	8,	12, 12},
	{0, 0,	0,	1,	4,	5,	7,	11, 11},
	{0, 0,	1,	2,	4,	6,	7,	11, 12},
	{0, -1, -1, 1,	3,	4,	6,	10, 9},
	{0, 2,	1,	1,	3,	5,	6,	10, 10},
	{0, 1,	0,	1,	3,	4,	5,	8,	9},
	{0, 1,	0,	1,	3,	4,	5,	9,	10},
	{0, 1,	0,	1,	3,	4,	5,	8,	8},
	{0, 0,	0,	1,	3,	4,	5,	8,	10},
	{0, 1,	0,	1,	3,	4,	5,	8,	10},
	{0, 1,	1,	0,	2,	3,	4,	7,	10},
	{0, 3,	0,	1,	2,	3,	4,	7,	6},
	{0, 1,	-1, 0,	2,	3,	3,	6,	6},
	{0, 0,	0,	1,	2,	3,	3,	6,	7},
	{0, 0,	0,	0,	2,	3,	3,	5,	6},
	{0, 0,	-1, 0,	1,	2,	2,	4,	6},
	{0, 1,	-1, 0,	1,	1,	2,	3,	2},
	{0, 4,	1,	2,	2,	3,	4,	4,	4},
	{0, 1,	0,	2,	1,	2,	3,	5,	5},
	{0, 1,	1,	1,	1,	2,	3,	5,	6},
	{0, 4,	2,	2,	1,	2,	3,	5,	6},
	{0, 2,	3,	2,	2,	2,	3,	5,	6},
	{0, 2,	3,	3,	2,	3,	3,	4,	5},
	{0, 6,	4,	4,	2,	2,	3,	4,	5},
	{0, 4,	4,	3,	2,	3,	3,	4,	5},
	{0, 4,	5,	3,	2,	2,	3,	4,	5},
	{0, 3,	4,	3,	2,	2,	2,	4,	5},
	{0, 5,	5,	4,	3,	3,	2,	3,	4},
	{0, 6,	7,	4,	3,	3,	3,	4,	5},
	{0, 6,	7,	4,	4,	3,	3,	4,	5},
	{0, 5,	8,	4,	3,	3,	3,	4,	5},
	{0, 5,	9,	5,	4,	3,	3,	4,	6},
	{0, 6,	6,	4,	2,	2,	3,	4,	6},
	{0, 6,	7,	3,	2,	2,	3,	3,	4},
	{0, 6,	7,	3,	2,	2,	2,	3,	4},
	{0, 2,	6,	3,	2,	2,	3,	3,	4},
	{0, 5,	7,	3,	2,	2,	2,	2,	4},
	{0, 2,	8,	2,	2,	1,	1,	2,	3},
	{0, 2,	5,	3,	2,	1,	1,	2,	2},
	{0, 2,	5,	1,	1,	1,	1,	1,	1},
	{0, 4,	5,	3,	2,	1,	1,	1,	2},
	{0, 1,	4,	1,	1,	0,	0,	1,	2},
	{0, 0,	5,	0,	1,	0,	1,	1,	1},
	{0, 2,	2,	0,	1,	0,	1,	1,	2},
	{0, 3,	4,	0,	-1, 0,	0,	0,	1},
	{0, -2, 3,	0,	1,	0,	1,	0,	2},
	{0, 1,	6,	0,	0,	0,	0,	0,	1},
	{0, 0,	4,	1,	1,	0,	1,	0,	1},
	{0, 0,	5,	0,	0,	0,	0,	0,	1},
	{0, 0,	3,	-2, -1, -1, -1, 0,	1},
	{0, 0,	2,	0,	0,	1,	1,	1,	3},
	{0, -1, 2,	0,	0,	0,	0,	-1, -1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_hero2_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-9,	0,	-9, -1, 1,	-1, -2, 2,	-1, -5, 5,	-1, -8, 6,	-8, 4,	13, 1,	1,	2,	-6, -3, 8,	-3, -4, 6,	-5},
	{-7,	0,	-7, -2, 1,	-2, -2, 1,	-2, -7, 2,	-5, -13,	2,	-10,	-11,	-1, -11,	-4, 0,	-8, -4, 8,	-4, -11,	0,	-12},
	{-5,	1,	-5, 0,	1,	0,	-3, 0,	-3, -8, 1,	-5, -12,	0,	-10,	-10,	0,	-10,	-3, 2,	-7, -13,	-1, -13,	-11,	0,	-12},
	{-4,	1,	-4, 0,	1,	0,	-3, 0,	-3, -7, 1,	-5, -12,	0,	-9, -10,	1,	-9, -5, 1,	-10,	-10,	0,	-10,	-8, 1,	-9},
	{-4,	0,	-5, -1, 0,	0,	-3, 0,	-3, -7, 0,	-6, -11,	1,	-9, -11,	1,	-9, -8, -1, -12,	-1, 8,	0,	0,	7,	-1},
	{-4,	0,	-4, 0,	0,	0,	-3, 0,	-3, -5, 1,	-4, -11,	0,	-9, -12,	-1, -11,	-7, 1,	-11,	-9, 0,	-8, 1,	7,	-1},
	{-3,	0,	-4, 0,	0,	0,	-3, 0,	-2, -5, 0,	-5, -10,	0,	-8, -9, 0,	-10,	-10,	0,	-14,	1,	8,	1,	-7, -1, -8},
	{-2,	0,	-3, 0,	0,	0,	-2, 0,	-2, -6, 1,	-5, -9, 0,	-8, -7, 2,	-10,	-9, 0,	-13,	-5, 1,	-6, -4, 0,	-6},
	{-2,	0,	-2, 0,	0,	-1, -2, 0,	-1, -4, 0,	-4, -11,	-1, -9, -9, 1,	-11,	-8, 0,	-12,	-5, 0,	-7, -2, 1,	-4},
	{-1,	0,	-2, 0,	0,	0,	-2, 0,	-2, -3, 1,	-2, -9, -1, -8, -8, 1,	-11,	-8, 0,	-13,	-5, -1, -8, -4, 0,	-5},
	{-1,	0,	-2, 0,	0,	0,	-1, 0,	-1, -4, 0,	-3, -9, -1, -8, -8, 1,	-12,	-8, 0,	-12,	-2, 2,	-12,	0,	3,	-1},
	{0, 0,	-2, -1, 0,	-1, -1, 0,	-1, -3, 1,	-2, -9, 0,	-8, -7, 1,	-11,	-8, 0,	-12,	-2, 0,	-15,	1,	2,	0},
	{0, 0,	-1, -1, 0,	-2, -1, 0,	-1, -3, 0,	-2, -9, 0,	-8, -6, 1,	-11,	-10,	-1, -14,	-4, 2,	-17,	13, -11,	13},
	{0, 0,	-1, 0,	0,	0,	1,	0,	1,	-3, 1,	-2, -7, 1,	-5, -4, 2,	-9, -11,	-1, -15,	-7, -2, -20,	18, -7, 17},
	{0, 0,	-2, 0,	0,	0,	-1, 0,	-1, -1, 2,	0,	-7, 0,	-6, -5, 1,	-10,	-12,	-1, -16,	-6, -2, -19,	21, -1, 20},
	{0, 0,	-1, 0,	1,	0,	0,	0,	-1, -4, 0,	-2, -7, -1, -6, -5, 1,	-10,	-11,	-1, -16,	-4, 3,	-16,	19, -2, 16},
	{1, 0,	-1, 0,	1,	0,	0,	0,	0,	-2, 1,	-1, -7, -1, -6, -5, 1,	-9, -7, 2,	-13,	-8, -1, -19,	17, -2, 15},
	{1, 0,	-1, 0,	1,	1,	0,	-1, 0,	0,	2,	0,	-5, 0,	-5, -5, 2,	-8, -7, 2,	-11,	-8, 1,	-20,	18, -1, 15},
	{1, 0,	0,	0,	0,	-1, 0,	1,	1,	-1, 1,	-1, -5, 1,	-5, -7, 0,	-9, -6, 3,	-12,	-11,	-1, -23,	22, 2,	18},
	{1, 0,	-1, -1, 0,	0,	0,	-1, 0,	0,	1,	0,	-5, 1,	-5, -7, 0,	-9, -7, 3,	-11,	-14,	2,	-22,	-14,	3,	-13},
	{1, 0,	-1, 0,	0,	1,	0,	-1, -1, -1, 1,	0,	-5, -1, -5, -8, 0,	-9, -9, 1,	-14,	-12,	2,	-19,	-16,	11, -12},
	{1, 0,	-1, -1, 1,	0,	1,	-1, -1, 0,	1,	1,	-6, -1, -6, -8, 0,	-9, -9, 0,	-13,	-15,	0,	-24,	-20,	-1, -14},
	{1, 0,	-1, 0,	0,	1,	1,	1,	0,	-1, 1,	0,	-4, 0,	-3, -4, 2,	-6, -11,	-2, -15,	-15,	-1, -25,	-16,	3,	-6},
	{1, 0,	0,	0,	0,	0,	0,	-1, 0,	0,	0,	0,	-4, 0,	-3, -7, -1, -9, -10,	0,	-13,	-13,	0,	-23,	-19,	1,	-7},
	{1, 0,	-1, 0,	0,	1,	1,	0,	0,	0,	0,	1,	-1, 3,	0,	-4, 2,	-6, -11,	-2, -15,	-13,	-1, -24,	-13,	-1, -11},
	{1, 0,	0,	0,	1,	0,	0,	-1, 0,	0,	1,	0,	-1, 2,	0,	-8, -1, -10,	-10,	-1, -13,	-15,	-2, -27,	-15,	-1, -13},
	{1, 0,	0,	1,	0,	0,	-1, 0,	-1, 0,	1,	1,	-1, 2,	0,	-4, 1,	-6, -7, 3,	-7, -10,	3,	-22,	-16,	-2, -11},
	{1, 0,	-1, 0,	0,	1,	0,	-1, 0,	0,	1,	0,	-2, 1,	-1, -4, 1,	-6, -9, 0,	-10,	-18,	-2, -26,	-13,	2,	-8},
	{0, -1, -1, 1,	0,	0,	0,	1,	0,	0,	0,	1,	-2, 0,	-1, -5, 1,	-7, -8, 0,	-9, -12,	2,	-23,	-16,	2,	-13},
	{2, 0,	0,	0,	0,	0,	0,	0,	1,	-1, 0,	-1, -2, 0,	-1, -4, 1,	-6, -9, -1, -9, -14,	1,	-25,	-17,	0,	-13},
	{0, -1, -2, 1,	0,	1,	0,	1,	0,	-1, -1, 0,	-1, 0,	-1, -5, 0,	-7, -9, -1, -9, -14,	-1, -24,	-17,	0,	-14},
	{1, 0,	0,	1,	0,	0,	0,	-1, 1,	1,	1,	1,	-1, 1,	0,	-5, -1, -6, -6, -1, -7, -15,	-1, -26,	-15,	0,	-12},
	{1, 0,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	1,	0,	1,	1,	-5, -1, -7, -6, -1, -7, -17,	-2, -27,	-9, 0,	-7},
	{2, 0,	0,	0,	0,	0,	1,	0,	0,	1,	1,	2,	-1, -1, -1, -6, -1, -6, -2, 2,	-4, -16,	1,	-23,	-10,	1,	-8},
	{1, 0,	-1, 1,	0,	1,	-1, -1, 0,	0,	0,	0,	0,	0,	1,	-5, -1, -6, 0,	4,	-1, -19,	-3, -26,	-4, 0,	-11},
	{1, 0,	0,	1,	0,	0,	0,	-1, 0,	0,	1,	1,	0,	-1, 0,	-7, -3, -7, -2, 2,	-4, -13,	3,	-21,	0,	2,	-6},
	{1, 0,	-1, 1,	0,	1,	1,	0,	1,	1,	0,	1,	2,	2,	2,	-3, -1, -5, -4, 1,	-5, -15,	2,	-24,	-3, 1,	-10},
	{2, 0,	1,	1,	0,	1,	0,	-1, -1, 0,	0,	1,	1,	1,	2,	1,	3,	-1, -1, 2,	-2, -6, 5,	-14,	4,	3,	1},
	{2, 0,	1,	1,	0,	0,	0,	-1, 1,	0,	-1, 0,	-2, -1, -1, -1, -1, -4, -7, -2, -8, -1, 14, -7, -3, -2, -9},
	{2, 0,	0,	0,	0,	1,	1,	0,	-1, 0,	-1, 1,	1,	1,	1,	-2, -1, -5, -5, 0,	-4, -12,	3,	-17,	4,	4,	0},
	{2, 0,	-1, 0,	0,	1,	1,	0,	1,	1,	1,	1,	-2, -1, 0,	-2, -1, -5, -2, 2,	-2, -13,	1,	-20,	-1, 2,	-5},
	{1, 0,	0,	0,	0,	1,	1,	0,	0,	1,	0,	1,	1,	2,	2,	-2, -1, -4, 1,	4,	1,	-17,	-2, -23,	-4, 0,	-8},
	{2, 0,	0,	0,	0,	0,	1,	0,	0,	0,	0,	2,	0,	-1, -1, -1, 0,	-3, -3, 0,	-4, -18,	-3, -24,	-2, 4,	-6},
	{2, 0,	0,	0,	0,	1,	-1, 0,	0,	0,	-1, 1,	0,	0,	0,	-2, -1, -4, 1,	4,	0,	-14,	3,	-17,	-1, 3,	-5},
	{2, -1, -1, -1, 0,	0,	0,	0,	1,	0,	0,	0,	1,	1,	1,	0,	1,	-1, 0,	3,	0,	-16,	0,	-20,	2,	6,	-1},
	{1, -1, -1, 0,	0,	1,	0,	0,	0,	0,	-1, 0,	0,	0,	0,	-1, 0,	-2, -2, 0,	-3, -12,	3,	-16,	-1, 4,	-4},
	{1, -1, -1, -1, 0,	0,	1,	0,	1,	0,	-1, 0,	1,	0,	2,	1,	2,	0,	-4, 0,	-4, -10,	4,	-11,	-3, 1,	-7},
	{1, -1, -1, 0,	1,	1,	0,	1,	0,	0,	-1, 1,	0,	-1, -1, 0,	1,	-1, 2,	3,	1,	-11,	0,	-14,	-7, 2,	-10},
	{2, -1, 0,	0,	1,	0,	0,	0,	1,	0,	-1, 0,	-1, -1, -1, 0,	0,	-1, 1,	4,	1,	-9, 4,	-10,	-3, 1,	-7},
	{1, 0,	-1, -1, 0,	0,	0,	0,	1,	1,	-1, 1,	0,	0,	0,	-2, -1, -2, 0,	2,	-1, -10,	1,	-12,	-6, 2,	-9},
	{2, 0,	0,	0,	0,	1,	0,	0,	0,	0,	-1, 1,	-1, -1, -1, -1, -1, -2, -1, 0,	-3, -8, 5,	-9, -5, 5,	-6},
	{3, 0,	0,	0,	0,	1,	0,	0,	1,	1,	0,	0,	0,	0,	1,	-1, -1, -3, 0,	2,	0,	-10,	2,	-11,	-7, 2,	-9},
	{1, -1, 0,	0,	0,	1,	-1, 0,	0,	1,	0,	1,	0,	0,	1,	0,	0,	-1, -1, 0,	-3, -11,	-1, -13,	-9, 2,	-9},
	{2, -1, -1, 0,	0,	0,	0,	1,	1,	1,	-1, 1,	1,	1,	1,	0,	0,	-1, -3, -1, -4, -9, -1, -10,	-8, 0,	-10},
	{2, 0,	0,	0,	0,	0,	0,	0,	1,	0,	-1, 0,	2,	1,	1,	0,	0,	0,	0,	1,	-1, -6, 2,	-8, 0,	9,	0},
	{3, 0,	0,	-1, 0,	0,	0,	0,	1,	1,	-1, 1,	0,	0,	-1, 1,	0,	0,	1,	3,	0,	-11,	0,	-10,	-3, 5,	-3},
	{2, -1, 0,	0,	0,	0,	-1, 1,	1,	1,	-1, 1,	0,	0,	-1, 0,	-1, -1, -1, 0,	-2, -8, 0,	-8, -5, 2,	-6},
	{1, -1, -1, 0,	0,	0,	-1, 0,	1,	2,	0,	0,	-1, -1, 0,	0,	-1, -1, 2,	2,	0,	-10,	0,	-9, -8, -1, -7},
	{1, 0,	-1, 0,	0,	0,	0,	0,	1,	0,	-1, 0,	1,	1,	1,	2,	2,	2,	1,	0,	-1, -12,	-2, -9, -2, 1,	-4},
	{2, 0,	0,	0,	0,	-1, -1, 0,	1,	0,	-1, 0,	0,	-1, 0,	1,	1,	0,	1,	3,	1,	-9, -1, -6, -1, 0,	-4},
	{1, 0,	-1, 0,	0,	1,	-1, 0,	0,	0,	0,	0,	1,	0,	1,	2,	2,	1,	-2, 0,	-2, -5, 2,	-2, 3,	3,	0},
	{1, -1, -1, 0,	0,	0,	-1, 0,	0,	0,	-1, 0,	1,	1,	1,	2,	2,	2,	1,	1,	1,	-4, -1, -3, -4, 2,	-4},
	{1, 0,	-1, 0,	0,	1,	-1, 0,	0,	0,	0,	0,	1,	1,	1,	2,	2,	2,	1,	0,	-1, -6, -2, -4, -7, -1, -6},
	{1, 0,	0,	0,	0,	0,	-1, 0,	0,	1,	0,	0,	-1, -1, 0,	1,	1,	1,	0,	-1, -1, -5, -1, -3, -2, 3,	-2},
	{1, 0,	0,	0,	0,	0,	0,	0,	1,	-1, -1, -1, 1,	1,	1,	0,	-1, -1, -1, -1, -2, -6, 0,	-2, -7, 1,	-3},
	{0, 0,	-1, 0,	0,	0,	-1, 0,	0,	1,	0,	0,	0,	0,	0,	-1, -1, 0,	2,	1,	0,	-5, -1, -2, -2, 3,	1},
	{1, 0,	1,	0,	0,	-1, -1, 0,	0,	0,	-1, 1,	0,	0,	-2, 1,	0,	2,	-1, -1, -2, -4, 0,	-1, -7, -1, -3},
	{0, -1, -1, 0,	0,	-1, -1, 0,	1,	1,	0,	0,	1,	1,	1,	0,	0,	1,	1,	0,	0,	-4, 0,	-2, -2, 3,	1},
	{0, -1, -1, 0,	0,	-1, -1, 0,	1,	1,	0,	1,	0,	0,	0,	1,	1,	1,	-1, -2, -2, -2, 1,	0,	-3, 3,	-1},
	{1, 0,	0,	1,	0,	0,	-1, 0,	0,	1,	0,	0,	0,	1,	1,	1,	0,	1,	1,	1,	0,	-3, 0,	-1, -6, 0,	-3},
	{1, 0,	0,	0,	0,	0,	0,	0,	1,	1,	0,	0,	0,	0,	0,	1,	1,	1,	0,	-1, -1, -4, -1, -2, 0,	2,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static unsigned int base_luminance_hero2_revF[LUMINANCE_MAX][2] = {
		/* level * 4194304 */
	{2,		501092936  },
	{3,		501092936  },
	{4,		501092936  },
	{5,		501092936  },
	{6,		501092936  },
	{7,		501092936  },
	{8,		501092936  },
	{9,		501092936  },
	{10,	501092936  },
	{11,	501092936  },
	{12,	501092936  },
	{13,	501092936  },
	{14,	501092936  },
	{15,	501092936  },
	{16,	501092936  },
	{17,	501092936  },
	{19,	501092936  },
	{20,	501092936  },
	{21,	501092936  },
	{22,	501092936  },
	{24,	501092936  },
	{25,	501092936  },
	{27,	501092936  },
	{29,	501092936  },
	{30,	501092936  },
	{32,	501092936  },
	{34,	501092936  },
	{37,	501092936  },
	{39,	501092936  },
	{41,	501092936  },
	{44,	501092936  },
	{47,	501092936  },
	{50,	501092936  },
	{53,	501092936  },
	{56,	501092936  },
	{60,	501092936  },
	{64,	501092936  },
	{68,	516531820  },
	{72,	540170159  },
	{77,	572587609  },
	{82,	614562971  },
	{87,	658163097  },
	{93,	694219861  },
	{98,	721952168  },
	{105,	769492702  },
	{111,	808718664  },
	{119,	859250926  },
	{126,	922101482  },
	{134,	954436145  },
	{143,	1020933762 },
	{152,	1078219461 },
	{162,	1149220188 },
	{172,	1197929057 },
	{183,	1247742833 },
	{195,	1247742833 },
	{207,	1247742833 },
	{220,	1247742833 },
	{234,	1247742833 },
	{249,	1285830728 },
	{265,	1337587920 },
	{282,	1390461151 },
	{300,	1458128116 },
	{316,	1527552622 },
	{333,	1598742117 },
	{350,	1656969429 },
	{357,	1671703923 },
	{365,	1701386511 },
	{372,	1701386511 },
	{380,	1701386511 },
	{387,	1701386511 },
	{395,	1701386511 },
	{403,	1716334719 },
	{412,	1731354279 },
	{420,	1761607680 },
};

static int gradation_offset_hero2_revF[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 8,	15, 26, 34, 38, 42, 46, 46},
	{0, 8,	15, 25, 32, 36, 40, 45, 45},
	{0, 6,	11, 20, 25, 28, 32, 36, 36},
	{0, 6,	10, 18, 22, 25, 29, 33, 33},
	{0, 6,	10, 16, 20, 24, 27, 30, 30},
	{0, 6,	9,	14, 18, 21, 24, 28, 28},
	{0, 5,	8,	13, 16, 19, 22, 26, 26},
	{0, 5,	7,	12, 15, 18, 21, 25, 25},
	{0, 4,	6,	11, 14, 16, 19, 23, 23},
	{0, 4,	6,	11, 14, 16, 19, 23, 23},
	{0, 4,	6,	10, 13, 15, 18, 22, 22},
	{0, 4,	6,	10, 13, 15, 18, 22, 22},
	{0, 4,	4,	8,	13, 15, 18, 22, 22},
	{0, 4,	4,	8,	11, 13, 16, 20, 20},
	{0, 5,	5,	8,	11, 13, 16, 20, 20},
	{0, 3,	3,	6,	10, 12, 15, 18, 18},
	{0, 4,	4,	7,	9,	11, 13, 16, 16},
	{0, 5,	4,	6,	8,	10, 13, 16, 16},
	{0, 4,	4,	6,	8,	10, 12, 15, 15},
	{0, 3,	4,	6,	8,	9,	11, 14, 14},
	{0, 4,	3,	6,	7,	9,	11, 14, 14},
	{0, 3,	3,	5,	7,	9,	11, 14, 14},
	{0, 2,	3,	4,	6,	8,	10, 13, 13},
	{0, 2,	2,	4,	5,	7,	9,	12, 12},
	{0, 2,	2,	4,	5,	7,	8,	11, 11},
	{0, 3,	3,	4,	5,	6,	7,	10, 10},
	{0, 2,	2,	3,	4,	5,	6,	9,	9},
	{0, 3,	3,	3,	4,	5,	6,	9,	9},
	{0, 3,	2,	4,	4,	5,	6,	9,	9},
	{0, 2,	2,	3,	4,	5,	6,	8,	8},
	{0, 3,	3,	3,	4,	5,	6,	8,	8},
	{0, 2,	2,	2,	3,	4,	5,	7,	7},
	{0, 2,	1,	2,	3,	4,	5,	7,	7},
	{0, 3,	2,	2,	3,	3,	4,	6,	6},
	{0, 2,	1,	1,	2,	2,	3,	4,	4},
	{0, 2,	1,	1,	2,	2,	3,	4,	4},
	{0, 2,	0,	1,	2,	2,	3,	4,	4},
	{0, 1,	1,	1,	2,	2,	2,	3,	3},
	{0, 2,	1,	1,	2,	3,	3,	4,	4},
	{0, 3,	1,	1,	1,	2,	2,	4,	5},
	{0, 3,	2,	2,	1,	1,	2,	3,	3},
	{0, 3,	1,	1,	1,	2,	2,	3,	3},
	{0, 1,	3,	3,	1,	2,	2,	3,	4},
	{0, 3,	2,	3,	2,	2,	2,	3,	4},
	{0, 0,	1,	2,	2,	2,	2,	3,	4},
	{0, 1,	2,	2,	2,	2,	3,	4,	5},
	{0, 1,	3,	3,	2,	2,	2,	3,	4},
	{0, 0,	2,	2,	2,	2,	2,	3,	3},
	{0, 2,	1,	3,	2,	2,	3,	3,	3},
	{0, 3,	3,	3,	2,	3,	2,	3,	3},
	{0, 1,	3,	3,	2,	2,	2,	3,	3},
	{0, 1,	3,	2,	2,	2,	2,	3,	4},
	{0, 2,	3,	2,	2,	1,	2,	2,	3},
	{0, 4,	4,	2,	2,	2,	2,	3,	3},
	{0, 2,	3,	3,	2,	2,	1,	2,	2},
	{0, 2,	4,	3,	2,	2,	1,	2,	3},
	{0, 2,	3,	2,	2,	2,	1,	1,	3},
	{0, 0,	0,	0,	0,	0,	0,	1,	1},
	{0, 0,	0,	1,	0,	0,	0,	0,	0},
	{0, 3,	3,	1,	0,	0,	0,	0,	0},
	{0, 1,	1,	0,	0,	0,	0,	0,	0},
	{0, 0,	1,	0,	0,	0,	0,	0,	1},
	{0, 2,	3,	1,	0,	1,	0,	0,	1},
	{0, 2,	3,	1,	0,	0,	0,	0,	1},
	{0, 0,	1,	1,	0,	0,	0,	0,	1},
	{0, 1,	1,	0,	0,	0,	0,	0,	1},
	{0, 1,	1,	0,	0,	0,	0,	0,	0},
	{0, 1,	1,	0,	0,	0,	0,	0,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_hero2_revF[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-4,	1,	-7,	0,	1,	-2,	-3,	1,	-5,	-4,	1,	-11,	-2,	1,	-15,	1,	1,	-11,	1,	0,	-9,	-6,	1,	-13,	-30,	-16,	-37},
	{-4,	-1,	-7,	-1,	0,	-2,	-5,	-1,	-6,	-6,	-1,	-13,	-5,	-1,	-16,	-3,	0,	-13,	-1,	-1,	-14,	-8,	-1,	-15,	-29,	-15,	-36},
	{-2,	0,	-5,	-1,	0,	-1,	-2,	0,	-4,	-6,	0,	-10,	-5,	-1,	-16,	0,	1,	-12,	0,	-1,	-14,	-6,	1,	-15,	-28,	-14,	-36},
	{-2,	0,	-4,	-1,	0,	-2,	-2,	0,	-3,	-6,	-1,	-11,	-4,	0,	-15,	-1,	1,	-12,	-1,	-1,	-15,	-6,	1,	-15,	-28,	-13,	-35},
	{-1,	0,	-3,	0,	0,	-1,	-2,	0,	-3,	-5,	0,	-9,	-6,	-1,	-15,	-2,	-2,	-15,	0,	1,	-12,	-6,	1,	-15,	-27,	-13,	-35},
	{0,	0,	-2,	-1,	0,	-2,	-1,	0,	-2,	-4,	1,	-7,	-5,	0,	-15,	0,	1,	-13,	0,	1,	-13,	-9,	-1,	-17,	-26,	-11,	-33},
	{0,	0,	-2,	0,	0,	-1,	-2,	0,	-2,	-4,	0,	-6,	-4,	1,	-13,	-1,	0,	-13,	-1,	0,	-15,	-7,	0,	-15,	-26,	-11,	-32},
	{1,	0,	-1,	0,	0,	-1,	-1,	0,	-2,	-5,	0,	-6,	-3,	1,	-12,	-2,	-1,	-14,	-2,	0,	-16,	-7,	1,	-14,	-26,	-11,	-33},
	{1,	0,	-1,	0,	0,	0,	-1,	0,	-2,	-5,	0,	-6,	-3,	1,	-12,	0,	1,	-13,	0,	1,	-14,	-6,	2,	-14,	-26,	-10,	-33},
	{2,	0,	0,	1,	0,	0,	-2,	-1,	-2,	-5,	0,	-6,	-4,	-1,	-13,	0,	1,	-12,	-1,	1,	-15,	-6,	2,	-14,	-26,	-10,	-33},
	{2,	0,	0,	0,	0,	0,	-1,	0,	-2,	-3,	0,	-4,	-4,	-1,	-13,	-1,	1,	-12,	0,	1,	-14,	-8,	-1,	-17,	-26,	-10,	-32},
	{2,	0,	0,	0,	0,	-1,	0,	0,	-1,	-4,	-1,	-5,	-4,	-1,	-12,	-2,	0,	-13,	-1,	1,	-16,	-9,	-1,	-17,	-26,	-10,	-32},
	{3,	0,	1,	0,	0,	0,	0,	0,	-1,	-3,	1,	-3,	-8,	-5,	-16,	-2,	-1,	-13,	-2,	-1,	-17,	-9,	-1,	-17,	-26,	-10,	-32},
	{3,	0,	1,	0,	0,	0,	1,	1,	0,	-4,	0,	-4,	-4,	-1,	-12,	-1,	0,	-12,	-1,	0,	-16,	-9,	-1,	-16,	-25,	-10,	-32},
	{3,	0,	1,	0,	0,	0,	0,	0,	-1,	-3,	0,	-3,	-5,	-1,	-12,	-3,	-1,	-14,	-2,	-1,	-16,	-4,	-2,	-26,	-18,	-9,	-23},
	{3,	0,	1,	0,	0,	0,	0,	1,	0,	-2,	1,	-2,	-5,	-3,	-13,	-2,	0,	-12,	-1,	-1,	-17,	0,	1,	-21,	11,	-9,	-18},
	{3,	0,	1,	0,	0,	0,	0,	0,	-1,	-3,	0,	-3,	-3,	0,	-10,	-2,	-1,	-12,	0,	2,	-15,	0,	1,	-25,	-7,	-8,	-6},
	{3,	0,	1,	0,	0,	0,	0,	0,	0,	-1,	1,	-1,	-3,	0,	-10,	-1,	0,	-10,	-4,	-2,	-18,	-2,	1,	-25,	-6,	-7,	-5},
	{3,	0,	1,	0,	0,	0,	0,	0,	-1,	-1,	1,	-1,	-3,	-1,	-10,	-2,	-1,	-10,	0,	1,	-15,	-1,	2,	-24,	15,	-7,	-13},
	{3,	0,	1,	1,	0,	0,	-1,	-1,	-1,	-3,	0,	-2,	-2,	0,	-9,	0,	2,	-9,	0,	2,	-14,	1,	1,	-22,	13,	-7,	-10},
	{3,	0,	1,	1,	0,	1,	0,	1,	-1,	-3,	-1,	-2,	-2,	1,	-7,	-3,	-1,	-10,	-2,	0,	-16,	0,	1,	-22,	-7,	-7,	-4},
	{3,	0,	2,	1,	0,	1,	0,	1,	0,	-3,	0,	-2,	-2,	-1,	-9,	-4,	-2,	-10,	-2,	-1,	-16,	-1,	0,	-23,	-7,	-7,	-16},
	{3,	0,	2,	1,	0,	1,	0,	0,	0,	-1,	0,	0,	-2,	-1,	-8,	-4,	-1,	-10,	-3,	-2,	-17,	0,	0,	-23,	-7,	-2,	-1},
	{3,	0,	2,	1,	0,	1,	1,	1,	0,	-2,	0,	0,	-1,	0,	-7,	-4,	-1,	-9,	-4,	-3,	-17,	1,	0,	-22,	-6,	-7,	-6},
	{3,	0,	1,	2,	0,	1,	-1,	0,	-1,	-3,	-1,	-1,	-1,	0,	-7,	-3,	-1,	-9,	0,	2,	-11,	1,	0,	-23,	15,	-7,	-3},
	{3,	0,	2,	1,	0,	0,	-1,	0,	-1,	-1,	0,	0,	-2,	0,	-7,	0,	2,	-5,	2,	3,	-8,	1,	-1,	-23,	16,	-6,	-8},
	{4,	0,	2,	1,	0,	1,	-1,	0,	-1,	-1,	1,	0,	0,	1,	-5,	-1,	2,	-5,	4,	3,	-5,	0,	-1,	-23,	14,	-6,	-5},
	{4,	0,	2,	1,	0,	1,	-1,	0,	-1,	-1,	1,	1,	-1,	0,	-6,	-1,	2,	-5,	2,	1,	-7,	-2,	-3,	-25,	12,	-3,	-3},
	{4,	0,	2,	1,	0,	1,	0,	0,	0,	-3,	-2,	-1,	0,	1,	-4,	-2,	1,	-6,	2,	1,	-6,	-4,	-4,	-26,	12,	-6,	-5},
	{3,	0,	2,	2,	0,	2,	-1,	0,	-1,	-3,	-1,	-1,	-1,	-1,	-6,	-2,	0,	-5,	1,	0,	-7,	2,	1,	-21,	14,	-6,	-2},
	{4,	0,	2,	1,	0,	1,	-1,	0,	-1,	-1,	0,	1,	-1,	-1,	-6,	-4,	-1,	-6,	0,	-1,	-8,	1,	1,	-22,	14,	-6,	-4},
	{4,	0,	2,	1,	0,	1,	-1,	0,	-2,	-1,	0,	1,	-1,	0,	-4,	-2,	-1,	-6,	0,	-2,	-6,	1,	0,	-21,	13,	-6,	-8},
	{4,	0,	2,	1,	0,	1,	-1,	0,	0,	-1,	0,	0,	-1,	-1,	-4,	-3,	-2,	-6,	0,	-2,	-6,	-1,	-2,	-24,	12,	-6,	-6},
	{3,	0,	2,	0,	0,	1,	0,	0,	-1,	0,	1,	2,	-1,	-1,	-4,	-1,	2,	-3,	3,	-1,	-3,	-3,	-3,	-24,	13,	-2,	-7},
	{3,	0,	2,	1,	0,	1,	-1,	0,	-1,	-1,	0,	1,	1,	1,	-2,	1,	2,	-3,	5,	1,	2,	2,	2,	-18,	19,	-1,	-2},
	{3,	0,	2,	1,	0,	1,	0,	0,	0,	-1,	0,	1,	0,	0,	-3,	0,	1,	-2,	2,	-2,	-1,	3,	2,	-17,	14,	-4,	-4},
	{3,	0,	2,	1,	0,	1,	0,	-1,	1,	-1,	0,	0,	0,	-1,	-3,	-2,	0,	-3,	3,	-3,	-1,	1,	1,	-18,	15,	-4,	-5},
	{3,	0,	2,	0,	0,	1,	0,	0,	0,	-1,	0,	1,	2,	0,	-2,	-1,	0,	-3,	6,	1,	4,	2,	1,	-17,	15,	-4,	-5},
	{3,	0,	2,	0,	1,	1,	0,	-1,	0,	-1,	0,	1,	0,	-2,	-4,	-2,	0,	-3,	6,	2,	4,	-3,	-2,	-22,	17,	0,	-2},
	{4,	0,	3,	1,	0,	1,	1,	0,	-1,	0,	1,	3,	1,	0,	-2,	-2,	-1,	-3,	5,	0,	2,	-4,	-2,	-23,	-11,	0,	4},
	{4,	0,	2,	0,	0,	0,	0,	0,	1,	0,	1,	2,	2,	2,	-1,	2,	2,	0,	4,	-1,	2,	2,	4,	-12,	6,	-2,	-2},
	{3,	0,	2,	1,	0,	2,	1,	0,	1,	0,	1,	2,	2,	0,	-3,	0,	2,	0,	1,	-3,	-1,	1,	1,	-15,	18,	2,	2},
	{4,	0,	2,	0,	0,	1,	0,	0,	0,	0,	0,	1,	1,	1,	0,	0,	0,	-2,	4,	1,	3,	0,	1,	-15,	13,	0,	-3},
	{4,	0,	2,	1,	0,	1,	-1,	0,	-1,	1,	0,	2,	1,	1,	0,	2,	2,	1,	4,	1,	2,	-3,	-1,	-18,	-3,	3,	-1},
	{4,	0,	2,	1,	0,	1,	0,	0,	0,	0,	0,	2,	1,	0,	-2,	1,	1,	0,	2,	-2,	-1,	0,	4,	-11,	11,	0,	-5},
	{4,	0,	2,	0,	0,	1,	1,	0,	0,	0,	0,	2,	0,	0,	-2,	-1,	-1,	-3,	1,	-1,	-2,	-3,	0,	-14,	12,	3,	-3},
	{4,	0,	1,	0,	0,	2,	0,	1,	0,	0,	-1,	0,	1,	1,	0,	1,	3,	1,	0,	-2,	-2,	-2,	-2,	-14,	15,	6,	0},
	{3,	0,	2,	1,	0,	1,	0,	1,	1,	2,	1,	3,	-1,	-1,	-2,	0,	0,	-1,	2,	0,	0,	-2,	-1,	-13,	3,	0,	-6},
	{5,	0,	3,	0,	0,	0,	0,	0,	1,	1,	0,	2,	0,	0,	0,	0,	0,	-2,	0,	-1,	-2,	2,	2,	-7,	2,	0,	-6},
	{5,	0,	3,	0,	0,	0,	0,	0,	1,	1,	1,	2,	0,	0,	-1,	0,	-1,	-2,	3,	3,	1,	0,	0,	-9,	6,	3,	-3},
	{5,	0,	3,	0,	0,	1,	1,	0,	0,	0,	0,	1,	1,	1,	0,	1,	1,	-1,	3,	3,	2,	0,	0,	-6,	6,	3,	-3},
	{4,	0,	2,	0,	0,	1,	1,	0,	1,	0,	1,	1,	1,	-1,	0,	2,	2,	0,	1,	0,	-1,	-3,	-2,	-10,	2,	0,	-8},
	{4,	0,	2,	1,	0,	1,	1,	1,	2,	1,	1,	1,	0,	0,	1,	3,	2,	0,	1,	0,	-1,	2,	1,	-6,	7,	3,	-4},
	{4,	0,	2,	0,	0,	1,	1,	0,	1,	1,	1,	1,	0,	1,	1,	2,	1,	0,	-1,	0,	-3,	-3,	-2,	-5,	5,	-1,	-6},
	{4,	0,	2,	0,	0,	0,	0,	0,	1,	1,	0,	1,	0,	0,	0,	2,	1,	-1,	1,	2,	1,	2,	2,	-2,	11,	3,	-2},
	{5,	0,	3,	1,	0,	0,	-1,	0,	0,	2,	0,	1,	0,	1,	1,	2,	0,	-1,	1,	1,	1,	0,	-1,	-5,	6,	1,	-7},
	{5,	0,	3,	1,	0,	1,	-1,	0,	-1,	2,	1,	3,	-1,	-1,	-1,	0,	-1,	-1,	2,	1,	1,	3,	3,	-1,	2,	-1,	-10},
	{4,	0,	3,	1,	0,	1,	1,	0,	0,	0,	0,	1,	1,	1,	2,	3,	1,	1,	-2,	-3,	-2,	-1,	0,	-3,	-1,	0,	-4},
	{3,	0,	2,	1,	0,	1,	1,	0,	1,	0,	0,	1,	1,	1,	1,	2,	0,	0,	3,	0,	3,	3,	3,	2,	4,	3,	-2},
	{2,	0,	1,	0,	0,	1,	1,	0,	0,	1,	0,	2,	2,	1,	2,	2,	2,	1,	4,	1,	4,	-1,	0,	0,	3,	0,	-5},
	{3,	0,	1,	0,	0,	1,	1,	0,	0,	1,	0,	1,	-1,	-1,	0,	1,	-1,	0,	1,	0,	1,	-3,	-3,	-2,	7,	3,	-2},
	{3,	0,	1,	0,	0,	1,	1,	0,	1,	1,	0,	1,	-2,	-2,	-1,	0,	-1,	-1,	4,	3,	4,	-4,	-3,	-3,	0,	-2,	-4},
	{3,	0,	2,	1,	0,	0,	0,	0,	1,	0,	-1,	0,	-1,	-1,	0,	1,	-1,	-1,	0,	0,	0,	-2,	-1,	0,	3,	1,	-2},
	{2,	0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	-1,	-1,	0,	2,	0,	0,	0,	0,	1,	-4,	-4,	-2,	1,	-2,	-5},
	{2,	0,	0,	1,	0,	1,	1,	0,	0,	0,	0,	1,	0,	0,	0,	-1,	-2,	-2,	0,	0,	0,	-1,	-1,	2,	3,	1,	-2},
	{1,	0,	0,	1,	0,	1,	0,	0,	0,	1,	0,	1,	-2,	-2,	-1,	1,	-1,	0,	-3,	-3,	-2,	-4,	-4,	-2,	5,	3,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static unsigned int base_luminance_hero2_revL[LUMINANCE_MAX][2] = {
	/* level * 4194304 */
	{2,	486539264},
	{3,	486539264},
	{4,	486539264},
	{5,	486539264},
	{6,	486539264},
	{7,	486539264},
	{8,	486539264},
	{9,	486539264},
	{10,	486539264},
	{11,	486539264},
	{12,	486539264},
	{13,	486539264},
	{14,	486539264},
	{15,	486539264},
	{16,	486539264},
	{17,	486539264},
	{19,	486539264},
	{20,	486539264},
	{21,	486539264},
	{22,	486539264},
	{24,	486539264},
	{25,	486539264},
	{27,	486539264},
	{29,	486539264},
	{30,	486539264},
	{32,	486539264},
	{34,	486539264},
	{37,	486539264},
	{39,	486539264},
	{41,	486539264},
	{44,	486539264},
	{47,	486539264},
	{50,	486539264},
	{53,	486539264},
	{56,	486539264},
	{60,	486539264},
	{64,	486539264},
	{68,	507510784},
	{72,	532676608},
	{77,	574619648},
	{82,	595591168},
	{87,	641728512},
	{93,	683671552},
	{98,	721420288},
	{105,	759169024},
	{111,	809500672},
	{119,	859832320},
	{126,	910163968},
	{134,	956301312},
	{143,	1010827264},
	{152,	1056964608},
	{162,	1111490560},
	{172,	1161822208},
	{183,	1233125376},
	{195,	1233125376},
	{207,	1233125376},
	{220,	1233125376},
	{234,	1233125376},
	{249,	1258291200},
	{265,	1325400064},
	{282,	1392508928},
	{300,	1459617792},
	{316,	1514143744},
	{333,	1585446912},
	{350,	1656750080},
	{357,	1673527296},
	{365,	1702887424},
	{372,	1702887424},
	{380,	1702887424},
	{387,	1702887424},
	{395,	1702887424},
	{403,	1715470336},
	{412,	1744830464},
	{420,	1761607680},
};

static int gradation_offset_hero2_revL[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0,	6,	13,	19,	25,	28,	31,	31,	31},
	{0,	5,	9,	16,	21,	25,	28,	28,	28},
	{0,	5,	9,	15,	19,	22,	25,	27,	27},
	{0,	5,	9,	14,	18,	20,	22,	24,	24},
	{0,	5,	8,	13,	17,	19,	21,	24,	24},
	{0,	4,	7,	12,	16,	18,	20,	23,	23},
	{0,	4,	6,	11,	15,	17,	19,	22,	22},
	{0,	3,	5,	10,	14,	15,	17,	20,	20},
	{0,	3,	5,	9,	13,	14,	16,	19,	19},
	{0,	4,	5,	9,	13,	14,	16,	19,	19},
	{0,	3,	5,	8,	12,	13,	15,	18,	18},
	{0,	3,	4,	7,	11,	12,	14,	17,	17},
	{0,	3,	4,	7,	11,	12,	14,	17,	17},
	{0,	2,	4,	7,	10,	11,	13,	16,	17},
	{0,	2,	3,	6,	10,	11,	13,	16,	17},
	{0,	2,	3,	5,	9,	11,	13,	16,	18},
	{0,	2,	3,	5,	9,	10,	11,	14,	16},
	{0,	2,	2,	4,	8,	9,	10,	14,	16},
	{0,	2,	2,	4,	8,	9,	10,	14,	16},
	{0,	2,	2,	4,	7,	8,	9,	13,	15},
	{0,	2,	2,	3,	6,	7,	8,	12,	14},
	{0,	2,	1,	3,	6,	7,	8,	12,	14},
	{0,	2,	1,	3,	6,	7,	8,	11,	13},
	{0,	1,	1,	3,	6,	7,	8,	11,	13},
	{0,	1,	1,	3,	5,	6,	7,	10,	12},
	{0,	1,	1,	2,	5,	6,	7,	10,	12},
	{0,	1,	1,	2,	4,	5,	6,	9,	11},
	{0,	1,	1,	2,	4,	4,	5,	8,	10},
	{0,	1,	1,	2,	4,	4,	5,	8,	10},
	{0,	1,	1,	1,	4,	4,	5,	8,	10},
	{0,	1,	1,	1,	3,	3,	4,	6,	8},
	{0,	0,	1,	1,	3,	3,	4,	6,	8},
	{0,	0,	0,	0,	3,	3,	4,	6,	8},
	{0,	0,	0,	0,	2,	2,	3,	5,	7},
	{0,	0,	0,	0,	2,	2,	2,	4,	6},
	{0,	0,	0,	0,	2,	2,	2,	4,	6},
	{0,	0,	0,	0,	2,	2,	2,	4,	6},
	{0,	2,	0,	0,	2,	1,	2,	3,	5},
	{0,	2,	0,	0,	1,	1,	2,	3,	5},
	{0,	1,	0,	1,	1,	1,	2,	4,	5},
	{0,	1,	1,	0,	1,	1,	2,	4,	5},
	{0,	0,	1,	1,	1,	1,	2,	5,	6},
	{0,	0,	2,	1,	1,	1,	2,	3,	4},
	{0,	0,	1,	1,	1,	1,	2,	3,	4},
	{0,	1,	2,	1,	1,	1,	1,	3,	4},
	{0,	0,	2,	1,	2,	1,	2,	4,	5},
	{0,	0,	3,	2,	1,	1,	1,	2,	4},
	{0,	0,	3,	2,	2,	2,	2,	3,	4},
	{0,	0,	2,	2,	2,	1,	2,	3,	4},
	{0,	0,	3,	2,	1,	1,	1,	2,	3},
	{0,	0,	3,	2,	1,	1,	2,	3,	4},
	{0,	0,	3,	2,	1,	1,	1,	1,	3},
	{0,	1,	4,	2,	1,	1,	1,	1,	3},
	{0,	1,	2,	1,	1,	1,	1,	1,	2},
	{0,	0,	2,	1,	1,	1,	1,	1,	2},
	{0,	1,	2,	1,	1,	1,	0,	1,	2},
	{0,	0,	1,	1,	0,	0,	0,	0,	1},
	{0,	0,	1,	0,	0,	0,	0,	0,	1},
	{0,	1,	1,	0,	0,	0,	0,	0,	0},
	{0,	1,	1,	0,	0,	0,	0,	0,	0},
	{0,	2,	0,	0,	0,	0,	0,	0,	1},
	{0,	2,	0,	0,	0,	0,	0,	0,	1},
	{0,	0,	0,	0,	0,	0,	0,	0,	1},
	{0,	1,	1,	0,	0,	0,	0,	0,	1},
	{0,	1,	1,	0,	0,	0,	0,	0,	0},
	{0,	1,	1,	0,	0,	0,	0,	0,	1},
	{0,	1,	1,	1,	0,	0,	0,	0,	0},
	{0,	0,	1,	1,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	1},
	{0,	0,	0,	0,	0,	0,	0,	0,	1},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_hero2_revL[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-7,	0,	-10,	-2,	0,	-2,	-5,	0,	-6,	-9,	1,	-8,	-15,	0,	-15,	-7,	1,	-12,	-6,	1,	-15,	-9,	4,	-14,	-13,	4,	-22},
	{-6,	0,	-9,	-1,	1,	-1,	-4,	1,	-4,	-9,	1,	-9,	-15,	0,	-15,	-11,	-1,	-13,	-9,	0,	-17,	1,	0,	-14,	-13,	4,	-20},
	{-4,	0,	-7,	-2,	0,	-2,	-3,	1,	-3,	-10,	1,	-10,	-12,	2,	-14,	-10,	1,	-12,	-10,	0,	-19,	1,	0,	-14,	-13,	4,	-20},
	{-3,	0,	-6,	-2,	0,	-2,	-4,	0,	-3,	-8,	1,	-9,	-12,	0,	-15,	-7,	3,	-10,	-8,	3,	-17,	1,	5,	-14,	-15,	1,	-22},
	{-2,	0,	-5,	-2,	0,	-2,	-3,	0,	-3,	-8,	1,	-9,	-11,	2,	-14,	-6,	3,	-11,	-9,	3,	-16,	-2,	2,	-18,	-15,	1,	-22},
	{-2,	0,	-5,	-1,	0,	-1,	-2,	0,	-2,	-8,	1,	-9,	-12,	0,	-15,	-6,	3,	-11,	-8,	2,	-17,	-5,	3,	-20,	-15,	2,	-22},
	{-1,	0,	-4,	-1,	0,	-1,	-2,	0,	-2,	-7,	1,	-8,	-11,	0,	-14,	-8,	1,	-14,	-8,	2,	-16,	-5,	4,	-21,	-15,	2,	-22},
	{-1,	0,	-4,	0,	0,	0,	-2,	1,	-2,	-7,	0,	-9,	-10,	2,	-13,	-5,	4,	-11,	-6,	3,	-15,	-6,	5,	-22,	-12,	4,	-19},
	{0,	0,	-3,	0,	0,	0,	-3,	0,	-3,	-5,	1,	-7,	-10,	2,	-13,	-4,	4,	-10,	-7,	4,	-15,	-5,	4,	-22,	-16,	0,	-23},
	{0,	0,	-3,	0,	0,	0,	-2,	0,	-2,	-5,	1,	-7,	-11,	0,	-14,	-4,	3,	-10,	-7,	3,	-16,	-5,	3,	-23,	-16,	0,	-23},
	{1,	0,	-2,	-1,	0,	0,	-1,	0,	-2,	-6,	1,	-6,	-9,	2,	-14,	-2,	4,	-9,	-8,	2,	-18,	-5,	3,	-21,	-13,	2,	-21},
	{1,	0,	-2,	0,	0,	0,	-2,	0,	-2,	-4,	2,	-5,	-10,	0,	-14,	-1,	4,	-8,	-8,	2,	-18,	-7,	2,	-25,	3,	-3,	-1},
	{1,	0,	-2,	0,	0,	0,	-2,	0,	-2,	-4,	2,	-5,	-10,	0,	-14,	-1,	4,	-8,	-8,	2,	-18,	-7,	2,	-25,	3,	-3,	-1},
	{2,	0,	-1,	0,	0,	0,	-2,	0,	-2,	-5,	1,	-6,	-8,	3,	-12,	-1,	4,	-7,	-9,	2,	-19,	-7,	2,	-26,	-2,	11,	-2},
	{1,	0,	-2,	1,	0,	1,	-2,	0,	-2,	-4,	0,	-5,	-10,	1,	-13,	-3,	4,	-9,	-9,	0,	-20,	-8,	1,	-27,	5,	9,	2},
	{2,	0,	-1,	0,	0,	0,	-2,	0,	-2,	-3,	1,	-3,	-9,	1,	-13,	-7,	-1,	-11,	-11,	-2,	-22,	-9,	1,	-28,	-2,	2,	-4},
	{2,	0,	-1,	0,	0,	0,	-1,	0,	-1,	-4,	0,	-4,	-11,	-1,	-13,	-2,	2,	-8,	-7,	3,	-19,	-7,	5,	-26,	-3,	3,	-5},
	{1,	0,	-1,	1,	0,	0,	-2,	0,	-1,	-2,	1,	-3,	-10,	0,	-13,	-2,	3,	-6,	-8,	3,	-18,	-11,	-2,	-32,	-3,	2,	-5},
	{1,	0,	-1,	1,	0,	0,	-1,	0,	-1,	-3,	1,	-3,	-10,	-1,	-13,	-3,	2,	-7,	-8,	2,	-18,	-13,	-3,	-33,	0,	2,	-5},
	{2,	0,	-1,	0,	0,	0,	-1,	0,	-1,	-3,	1,	-3,	-7,	1,	-10,	-4,	3,	-6,	-8,	2,	-18,	-10,	-1,	-32,	1,	4,	-2},
	{1,	0,	-1,	1,	0,	0,	-1,	0,	0,	-2,	1,	-3,	-7,	2,	-10,	-2,	2,	-4,	-6,	3,	-17,	-12,	-2,	-33,	-3,	3,	-5},
	{2,	0,	-1,	0,	0,	1,	1,	1,	0,	-3,	1,	-2,	-8,	1,	-11,	-2,	2,	-4,	-7,	2,	-17,	-13,	-4,	-35,	-2,	3,	-5},
	{2,	0,	-1,	0,	0,	1,	1,	1,	0,	-4,	0,	-3,	-8,	0,	-10,	-3,	0,	-5,	-9,	1,	-19,	-5,	5,	-27,	-4,	2,	-7},
	{2,	0,	-1,	1,	0,	1,	-1,	0,	0,	-3,	0,	-3,	-9,	-1,	-11,	-3,	-1,	-5,	-10,	-1,	-19,	-7,	3,	-30,	-4,	1,	-6},
	{2,	0,	-1,	0,	0,	1,	0,	0,	0,	-3,	0,	-3,	-5,	2,	-7,	-4,	0,	-4,	-8,	1,	-17,	-6,	3,	-30,	-3,	2,	-7},
	{2,	0,	-1,	1,	0,	1,	-1,	0,	0,	-2,	1,	-2,	-6,	0,	-9,	-5,	-1,	-5,	-9,	-1,	-17,	-8,	1,	-32,	-3,	3,	-6},
	{2,	0,	-1,	0,	0,	1,	0,	0,	0,	-2,	1,	-2,	-3,	3,	-6,	-5,	-2,	-6,	-5,	2,	-13,	-10,	0,	-33,	-2,	2,	-7},
	{2,	0,	0,	1,	0,	1,	-1,	0,	-1,	-2,	0,	-2,	-4,	2,	-6,	0,	3,	-1,	-4,	3,	-11,	-11,	0,	-35,	-3,	2,	-8},
	{2,	0,	0,	1,	0,	1,	-1,	-1,	-1,	-2,	0,	-2,	-4,	2,	-6,	-1,	2,	-2,	-5,	1,	-12,	-13,	-2,	-36,	-3,	2,	-8},
	{2,	0,	0,	1,	0,	1,	-1,	-1,	-1,	-1,	1,	-1,	-6,	-1,	-8,	-1,	2,	-1,	-6,	-1,	-13,	-15,	-3,	-38,	-4,	2,	-9},
	{2,	0,	0,	1,	0,	1,	-1,	-1,	-1,	-1,	1,	-1,	-2,	3,	-4,	-2,	1,	-1,	-3,	2,	-9,	-6,	6,	-28,	-4,	3,	-10},
	{2,	0,	0,	1,	0,	1,	-1,	-1,	-1,	-1,	0,	-1,	-3,	2,	-5,	-2,	0,	-1,	-5,	1,	-10,	-9,	4,	-30,	-4,	2,	-10},
	{2,	0,	0,	1,	0,	1,	-1,	0,	0,	0,	1,	0,	-4,	-1,	-6,	-3,	-1,	-2,	-6,	-1,	-10,	-10,	1,	-32,	-3,	2,	-10},
	{2,	0,	0,	1,	0,	1,	-1,	0,	0,	0,	1,	0,	-1,	3,	-2,	0,	0,	0,	-6,	-1,	-10,	-11,	2,	-32,	-2,	1,	-10},
	{2,	0,	0,	1,	0,	1,	-1,	0,	0,	0,	0,	0,	-1,	3,	-2,	0,	0,	0,	1,	6,	-4,	-10,	2,	-31,	-2,	0,	-10},
	{2,	0,	0,	1,	0,	1,	-1,	-1,	0,	0,	1,	0,	-2,	1,	-3,	0,	-1,	0,	0,	5,	-4,	-13,	-1,	-33,	-3,	0,	-11},
	{2,	0,	0,	1,	0,	1,	-1,	-1,	0,	-1,	0,	0,	-1,	1,	-3,	-2,	-3,	-1,	0,	4,	-4,	-16,	-3,	-35,	-3,	-1,	-12},
	{2,	0,	0,	0,	0,	1,	0,	0,	-1,	-1,	0,	0,	-3,	-1,	-5,	2,	2,	3,	0,	3,	-4,	-6,	7,	-25,	-4,	0,	-12},
	{2,	0,	1,	0,	0,	0,	0,	-1,	0,	1,	1,	1,	-2,	1,	-3,	3,	3,	4,	0,	2,	-4,	-7,	5,	-26,	-4,	0,	-12},
	{2,	0,	0,	1,	0,	2,	0,	0,	0,	0,	0,	0,	-2,	1,	-4,	1,	-1,	2,	-2,	0,	-6,	-13,	1,	-29,	-3,	-3,	-13},
	{3,	0,	1,	0,	0,	1,	0,	1,	1,	0,	0,	1,	1,	3,	-2,	1,	-1,	2,	-2,	-1,	-6,	-15,	-1,	-30,	-4,	-2,	-13},
	{2,	0,	0,	1,	0,	1,	1,	0,	1,	-1,	0,	-1,	0,	3,	-1,	-1,	-3,	0,	4,	5,	1,	-26,	-14,	-41,	-5,	-2,	-14},
	{2,	0,	0,	2,	0,	1,	0,	0,	0,	0,	1,	1,	0,	2,	-2,	-1,	-3,	0,	-1,	0,	-5,	-9,	5,	-22,	5,	5,	-6},
	{1,	0,	0,	2,	0,	1,	0,	0,	1,	0,	0,	1,	-1,	1,	-3,	2,	1,	3,	-1,	0,	-4,	-10,	3,	-23,	4,	5,	-6},
	{2,	0,	1,	1,	0,	0,	0,	0,	1,	1,	1,	1,	-1,	2,	-2,	1,	0,	1,	3,	5,	0,	-11,	2,	-23,	4,	4,	-7},
	{1,	0,	0,	1,	0,	1,	-1,	-1,	0,	0,	0,	0,	-2,	-1,	-4,	2,	2,	3,	-1,	1,	-3,	-14,	-3,	-25,	1,	5,	-8},
	{2,	0,	1,	1,	0,	1,	-1,	0,	-1,	1,	0,	2,	0,	2,	-1,	2,	2,	3,	0,	1,	-3,	-5,	6,	-16,	1,	4,	-8},
	{1,	0,	1,	1,	0,	0,	0,	-1,	0,	-1,	0,	0,	-1,	0,	-3,	-1,	-2,	-1,	1,	3,	-1,	-9,	1,	-19,	1,	4,	-9},
	{1,	0,	0,	2,	0,	0,	-1,	0,	0,	1,	0,	1,	-2,	-1,	-4,	1,	1,	2,	0,	2,	-2,	-11,	-1,	-19,	-1,	3,	-10},
	{1,	0,	1,	1,	0,	1,	-1,	0,	-1,	1,	0,	1,	0,	1,	-1,	2,	2,	2,	1,	2,	-1,	-3,	7,	-11,	-1,	1,	-9},
	{1,	0,	1,	1,	0,	1,	-1,	0,	-1,	0,	0,	0,	0,	2,	0,	0,	-1,	0,	-3,	-2,	-4,	-9,	0,	-14,	-3,	1,	-11},
	{0,	0,	0,	2,	0,	1,	0,	0,	0,	0,	0,	0,	-1,	0,	-1,	0,	-1,	0,	-1,	1,	-1,	-2,	7,	-7,	-3,	-1,	-11},
	{1,	0,	0,	1,	0,	0,	0,	0,	0,	1,	0,	1,	-1,	0,	-1,	3,	2,	2,	-1,	1,	-1,	-2,	6,	-6,	-4,	-1,	-12},
	{2,	0,	1,	1,	0,	1,	1,	2,	2,	0,	0,	-1,	-1,	-1,	-2,	1,	1,	0,	-5,	-4,	-5,	5,	12,	1,	5,	9,	-2},
	{3,	0,	1,	0,	0,	1,	1,	1,	-1,	0,	-1,	0,	-1,	-1,	-2,	2,	0,	2,	-5,	-5,	-6,	3,	9,	-1,	4,	7,	-1},
	{2,	0,	1,	1,	0,	1,	1,	2,	2,	0,	-1,	-1,	-1,	-1,	-1,	2,	0,	1,	0,	1,	0,	-5,	1,	-7,	4,	5,	-2},
	{2,	0,	1,	1,	0,	1,	1,	1,	0,	1,	0,	2,	-1,	-1,	-2,	1,	0,	1,	-3,	-4,	-3,	5,	8,	2,	2,	6,	-2},
	{2,	0,	1,	1,	0,	1,	1,	1,	0,	3,	2,	3,	-3,	-3,	-4,	1,	0,	1,	-3,	-4,	-3,	5,	8,	2,	2,	6,	-2},
	{2,	0,	1,	0,	0,	0,	1,	1,	1,	-1,	-1,	-1,	1,	0,	0,	2,	-1,	1,	-4,	-4,	-4,	4,	6,	1,	1,	3,	-3},
	{2,	0,	1,	0,	0,	0,	1,	0,	0,	1,	1,	2,	0,	-1,	0,	0,	-2,	0,	1,	0,	1,	5,	6,	2,	1,	2,	-3},
	{1,	0,	0,	1,	1,	1,	0,	-1,	0,	1,	0,	1,	-3,	-4,	-2,	1,	0,	1,	-3,	-3,	-3,	-2,	-2,	-4,	-4,	-2,	-5},
	{2,	0,	1,	2,	2,	2,	0,	0,	0,	-1,	-1,	1,	-2,	-4,	-3,	0,	0,	0,	2,	3,	2,	-3,	-2,	-4,	-4,	-3,	-5},
	{2,	0,	2,	0,	0,	0,	-1,	-2,	-1,	2,	2,	2,	0,	-1,	1,	-2,	-3,	-3,	-7,	-6,	-6,	1,	0,	0,	-5,	-4,	-4},
	{2,	0,	0,	-1,	0,	0,	1,	1,	1,	1,	0,	0,	0,	-1,	1,	-2,	-3,	-2,	-3,	-4,	-3,	-2,	0,	-2,	-7,	-5,	-4},
	{2,	0,	0,	-1,	0,	1,	2,	0,	1,	-3,	-3,	-2,	2,	1,	2,	-2,	-3,	-2,	-3,	-3,	-3,	4,	4,	4,	5,	6,	4},
	{2,	0,	1,	0,	0,	1,	0,	1,	0,	0,	-1,	1,	-1,	-2,	-2,	0,	0,	1,	-3,	-3,	-3,	-6,	-6,	-5,	3,	4,	4},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static unsigned int base_luminance_hero2_revM[LUMINANCE_MAX][2] = {
	{2, 499122176},
	{3, 499122176},
	{4, 499122176},
	{5, 499122176},
	{6, 499122176},
	{7, 499122176},
	{8, 499122176},
	{9, 499122176},
	{10,	499122176},
	{11,	499122176},
	{12,	499122176},
	{13,	499122176},
	{14,	499122176},
	{15,	499122176},
	{16,	499122176},
	{17,	499122176},
	{19,	499122176},
	{20,	499122176},
	{21,	499122176},
	{22,	499122176},
	{24,	499122176},
	{25,	499122176},
	{27,	499122176},
	{29,	499122176},
	{30,	499122176},
	{32,	499122176},
	{34,	499122176},
	{37,	499122176},
	{39,	499122176},
	{41,	499122176},
	{44,	499122176},
	{47,	499122176},
	{50,	499122176},
	{53,	499122176},
	{56,	499122176},
	{60,	499122176},
	{64,	499122176},
	{68,	524288000},
	{72,	549453824},
	{77,	578813952},
	{82,	616562688},
	{87,	650117120},
	{93,	696254464},
	{98,	729808896},
	{105,	780140544},
	{111,	817889280},
	{119,	868220928},
	{126,	922746880},
	{134,	964689920},
	{143,	1019215872},
	{152,	1065353216},
	{162,	1111490560},
	{172,	1174405120},
	{183,	1224736768},
	{195,	1224736768},
	{207,	1224736768},
	{220,	1224736768},
	{234,	1224736768},
	{249,	1258291200},
	{265,	1337982976},
	{282,	1392508928},
	{300,	1459617792},
	{316,	1526726656},
	{333,	1585446912},
	{350,	1644167168},
	{357,	1686110208},
	{365,	1702887424},
	{372,	1702887424},
	{380,	1702887424},
	{387,	1702887424},
	{395,	1702887424},
	{403,	1715470336},
	{412,	1744830464},
	{420,	1761607680},
};

static int gradation_offset_hero2_revM[LUMINANCE_MAX][9] = {
	{0,	7,	11,	17,	21,	25,	28,	28,	28},
	{0,	6,	10,	16,	18,	22,	25,	25,	25},
	{0,	6,	9,	14,	16,	19,	21,	21,	21},
	{0,	5,	7,	13,	15,	18,	21,	21,	21},
	{0,	6,	8,	13,	15,	18,	21,	22,	22},
	{0,	5,	7,	12,	13,	16,	19,	21,	21},
	{0,	5,	6,	11,	13,	15,	18,	20,	20},
	{0,	4,	5,	10,	12,	14,	17,	20,	21},
	{0,	4,	4,	9,	11,	13,	16,	17,	18},
	{0,	4,	4,	8,	10,	12,	15,	17,	18},
	{0,	5,	5,	8,	10,	12,	15,	16,	17},
	{0,	3,	3,	7,	9,	12,	15,	17,	18},
	{0,	2,	2,	6,	8,	11,	14,	17,	19},
	{0,	2,	2,	5,	7,	9,	12,	15,	18},
	{0,	3,	3,	5,	7,	9,	11,	15,	17},
	{0,	3,	2,	5,	7,	9,	11,	14,	17},
	{0,	3,	2,	4,	6,	8,	11,	13,	14},
	{0,	3,	2,	4,	5,	7,	9,	12,	13},
	{0,	3,	2,	4,	5,	7,	9,	12,	13},
	{0,	3,	2,	4,	5,	7,	9,	12,	13},
	{0,	3,	2,	4,	5,	7,	9,	12,	13},
	{0,	3,	1,	4,	5,	6,	8,	11,	13},
	{0,	4,	2,	4,	5,	6,	8,	11,	13},
	{0,	3,	1,	3,	4,	5,	7,	10,	11},
	{0,	3,	2,	3,	3,	4,	6,	9,	11},
	{0,	3,	1,	3,	3,	4,	6,	9,	11},
	{0,	3,	1,	3,	3,	4,	6,	9,	11},
	{0,	3,	1,	2,	3,	4,	6,	9,	11},
	{0,	3,	1,	2,	3,	4,	6,	9,	11},
	{0,	3,	1,	2,	2,	3,	4,	8,	10},
	{0,	2,	0,	1,	2,	2,	4,	7,	9},
	{0,	3,	0,	1,	2,	2,	4,	7,	8},
	{0,	0,	0,	1,	1,	2,	4,	7,	8},
	{0,	1,	0,	0,	1,	2,	3,	6,	8},
	{0,	2,	0,	0,	1,	2,	3,	5,	7},
	{0,	1,	0,	1,	1,	1,	2,	4,	7},
	{0,	1,	0,	0,	0,	0,	2,	4,	6},
	{0,	0,	0,	1,	2,	2,	3,	5,	6},
	{0,	1,	0,	1,	1,	1,	3,	5,	7},
	{0,	1,	0,	0,	0,	1,	2,	4,	5},
	{0,	1,	0,	1,	0,	1,	2,	4,	5},
	{0,	1,	1,	1,	0,	1,	2,	4,	4},
	{0,	0,	1,	1,	0,	1,	2,	4,	5},
	{0,	0,	1,	0,	1,	1,	2,	4,	5},
	{0,	0,	2,	0,	0,	1,	2,	4,	5},
	{0,	1,	1,	1,	1,	1,	2,	4,	5},
	{0,	1,	2,	2,	1,	1,	2,	3,	4},
	{0,	1,	1,	2,	1,	1,	1,	3,	4},
	{0,	1,	1,	1,	1,	1,	2,	3,	4},
	{0,	1,	1,	1,	1,	0,	1,	3,	4},
	{0,	1,	2,	1,	1,	1,	2,	3,	4},
	{0,	0,	3,	2,	0,	0,	1,	2,	3},
	{0,	0,	3,	2,	1,	1,	1,	2,	3},
	{0,	1,	1,	0,	0,	0,	0,	2,	3},
	{0,	0,	1,	0,	0,	0,	0,	1,	3},
	{0,	1,	2,	0,	0,	0,	0,	1,	2},
	{0,	0,	2,	0,	0,	0,	0,	1,	2},
	{0,	0,	2,	0,	0,	0,	0,	1,	2},
	{0,	0,	2,	0,	0,	0,	0,	0,	1},
	{0,	1,	2,	0,	0,	0,	1,	1,	1},
	{0,	0,	1,	0,	0,	0,	0,	0,	1},
	{0,	1,	1,	0,	0,	0,	1,	0,	1},
	{0,	0,	1,	0,	0,	0,	0,	1,	1},
	{0,	1,	0,	0,	0,	0,	0,	0,	1},
	{0,	0,	1,	0,	0,	0,	0,	1,	1},
	{0,	0,	0,	0,	0,	0,	0,	0,	1},
	{0,	0,	1,	0,	0,	0,	0,	0,	1},
	{0,	0,	0,	0,	0,	0,	0,	0,	1},
	{0,	0,	0,	0,	1,	0,	0,	0,	1},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_hero2_revM[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-9,	0,	-8,	-3,	0,	-2,	-4,	0,	-4,	-9,	1,	-4,	-18,	0,	-10,	-10,	1,	-9,	-6,	1,	-10,	-34,	-27,	-35,	-23,	-6,	-28},
	{-6,	0,	-7,	-3,	0,	-2,	-3,	0,	-3,	-9,	-1,	-7,	-12,	1,	-8,	-15,	0,	-11,	-2,	0,	-11,	-34,	-27,	-34,	-22,	-7,	-28},
	{-5,	0,	-6,	-2,	0,	-1,	-3,	0,	-3,	-7,	0,	-6,	-11,	0,	-9,	-11,	1,	-9,	-4,	1,	-9,	-25,	-17,	-24,	-21,	-6,	-28},
	{-4,	0,	-5,	-2,	0,	-1,	-2,	0,	-2,	-6,	0,	-6,	-11,	0,	-9,	-12,	0,	-9,	-7,	0,	-12,	-9,	-2,	-8,	-24,	-10,	-31},
	{-3,	0,	-4,	-2,	0,	-1,	-2,	0,	-2,	-6,	0,	-6,	-11,	0,	-9,	-10,	0,	-10,	-8,	0,	-12,	-2,	3,	-2,	-20,	-8,	-27},
	{-2,	0,	-3,	-2,	0,	-1,	-1,	0,	-2,	-6,	0,	-5,	-8,	1,	-9,	-11,	-1,	-12,	-10,	0,	-13,	-1,	3,	-2,	-16,	-4,	-23},
	{-2,	0,	-3,	-1,	0,	0,	-1,	0,	-2,	-6,	-1,	-5,	-9,	0,	-10,	-7,	1,	-9,	-9,	1,	-12,	-7,	0,	-7,	-14,	1,	-20},
	{-1,	0,	-2,	-1,	0,	-1,	-1,	0,	-2,	-5,	0,	-4,	-9,	-1,	-10,	-9,	0,	-11,	-8,	1,	-11,	-6,	0,	-7,	-13,	0,	-19},
	{-1,	0,	-2,	-1,	0,	-1,	0,	0,	-1,	-4,	0,	-4,	-9,	1,	-10,	-8,	0,	-11,	-6,	1,	-11,	-6,	2,	-6,	-15,	-1,	-22},
	{0,	0,	-1,	-1,	0,	0,	0,	0,	-1,	-4,	0,	-4,	-8,	0,	-9,	-6,	1,	-9,	-7,	1,	-12,	-9,	-2,	-9,	-15,	-1,	-22},
	{0,	0,	-1,	-1,	0,	0,	0,	0,	-1,	-3,	0,	-3,	-8,	-1,	-10,	-7,	1,	-8,	-7,	0,	-13,	-6,	2,	-6,	-14,	0,	-20},
	{1,	0,	0,	-1,	0,	-1,	0,	0,	-1,	-3,	0,	-3,	-8,	-1,	-10,	-10,	-1,	-12,	-7,	-1,	-14,	-5,	1,	-6,	-11,	2,	-18},
	{1,	0,	0,	0,	0,	0,	0,	0,	-1,	-3,	0,	-3,	-8,	-1,	-10,	-10,	-1,	-10,	-6,	-1,	-13,	-6,	0,	-8,	-13,	0,	-18},
	{1,	0,	0,	0,	0,	0,	0,	0,	-1,	-1,	1,	-1,	-7,	0,	-10,	-7,	2,	-6,	-6,	0,	-14,	-6,	-1,	-10,	-12,	0,	-17},
	{1,	0,	0,	0,	0,	-1,	0,	0,	0,	-2,	1,	-2,	-7,	0,	-9,	-7,	2,	-7,	-5,	2,	-13,	-7,	-2,	-11,	-9,	1,	-15},
	{1,	0,	0,	-1,	0,	-1,	0,	0,	0,	-1,	0,	-2,	-8,	-1,	-10,	-7,	1,	-7,	-5,	2,	-12,	-3,	1,	-9,	-10,	0,	-15},
	{2,	0,	1,	0,	1,	0,	0,	0,	1,	-1,	1,	-2,	-7,	-1,	-9,	-7,	0,	-6,	-9,	-2,	-16,	-5,	1,	-6,	-13,	1,	-20},
	{2,	0,	1,	0,	1,	0,	0,	0,	0,	0,	1,	-1,	-6,	1,	-8,	-6,	1,	-5,	-6,	1,	-13,	-4,	2,	-5,	-1,	1,	-8},
	{2,	0,	1,	1,	1,	1,	0,	0,	-1,	-1,	1,	-1,	-6,	1,	-8,	-7,	1,	-5,	-8,	-2,	-16,	-1,	5,	-3,	3,	4,	-5},
	{2,	0,	1,	1,	1,	1,	0,	0,	-1,	-1,	1,	-1,	-6,	1,	-8,	-7,	1,	-5,	-8,	-2,	-16,	-1,	5,	-3,	3,	4,	-5},
	{2,	0,	1,	0,	0,	-1,	0,	0,	1,	-1,	0,	-2,	-6,	0,	-8,	-7,	-1,	-6,	-9,	-2,	-14,	-7,	-1,	-8,	-12,	1,	-16},
	{2,	0,	1,	0,	1,	0,	1,	0,	1,	-1,	0,	-2,	-7,	-1,	-9,	-5,	2,	-2,	-6,	0,	-12,	-3,	3,	-5,	-13,	-1,	-17},
	{2,	0,	1,	0,	0,	0,	0,	0,	0,	-1,	0,	-2,	-6,	-1,	-8,	-5,	1,	-2,	-9,	-2,	-15,	-5,	0,	-8,	-9,	2,	-14},
	{2,	0,	1,	0,	0,	-1,	0,	0,	0,	0,	0,	0,	-4,	-1,	-6,	-5,	1,	-4,	-7,	0,	-11,	-6,	0,	-7,	-8,	1,	-15},
	{2,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	-3,	1,	-4,	-5,	1,	-3,	-5,	2,	-10,	-2,	4,	-5,	-9,	-1,	-15},
	{2,	0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	-1,	-2,	1,	-4,	-6,	1,	-3,	-7,	-1,	-12,	-4,	1,	-8,	-5,	2,	-12},
	{2,	0,	1,	0,	0,	1,	0,	0,	-1,	0,	-1,	0,	-3,	0,	-5,	-6,	0,	-3,	-5,	2,	-9,	-8,	1,	-22,	-3,	5,	-9},
	{2,	0,	1,	0,	0,	0,	1,	0,	1,	0,	1,	0,	-4,	-1,	-6,	-6,	0,	-4,	-9,	-2,	-12,	-10,	0,	-25,	-6,	2,	-11},
	{2,	0,	1,	0,	0,	1,	1,	0,	-1,	0,	0,	0,	-4,	-1,	-6,	-7,	-1,	-3,	-8,	-2,	-11,	-10,	1,	-22,	-4,	5,	-8},
	{2,	0,	1,	0,	0,	0,	1,	0,	1,	0,	0,	0,	-2,	1,	-4,	-5,	-1,	-2,	-2,	3,	-7,	-15,	-2,	-24,	-6,	2,	-10},
	{2,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-2,	-1,	-5,	-3,	2,	1,	-4,	2,	-7,	-13,	-2,	-24,	-3,	4,	-7},
	{2,	0,	1,	-1,	0,	0,	1,	1,	0,	1,	0,	0,	-3,	-1,	-4,	-3,	1,	-1,	-5,	-2,	-7,	-14,	-1,	-25,	-7,	2,	-13},
	{2,	0,	1,	0,	0,	0,	0,	0,	-1,	1,	0,	1,	0,	2,	-2,	-6,	-2,	-4,	-5,	-2,	-7,	-15,	-2,	-26,	-8,	2,	-15},
	{2,	0,	1,	1,	0,	1,	1,	1,	1,	1,	1,	1,	-3,	-1,	-5,	-6,	-2,	-3,	-2,	2,	-5,	-13,	-1,	-22,	-10,	-1,	-16},
	{2,	0,	1,	0,	0,	-1,	2,	1,	2,	0,	0,	0,	-2,	-1,	-4,	-7,	-2,	-3,	1,	4,	-2,	-10,	3,	-20,	-6,	2,	-12},
	{2,	0,	2,	1,	0,	0,	-1,	0,	-1,	0,	-1,	0,	-1,	0,	-3,	-1,	2,	2,	0,	2,	-4,	-10,	1,	-22,	-9,	0,	-14},
	{2,	0,	2,	0,	0,	-1,	1,	0,	1,	1,	1,	1,	1,	1,	-1,	0,	3,	2,	-3,	0,	-6,	-13,	-2,	-24,	-5,	2,	-9},
	{1,	0,	1,	2,	0,	1,	-1,	-2,	0,	1,	0,	0,	-2,	-1,	-4,	-6,	-2,	-2,	-1,	1,	-4,	-13,	0,	-22,	-1,	5,	-6},
	{2,	0,	2,	1,	1,	1,	0,	-1,	-2,	1,	0,	1,	-1,	0,	-3,	-4,	-1,	0,	-2,	-1,	-6,	-16,	-2,	-25,	-5,	2,	-9},
	{2,	0,	1,	1,	1,	2,	0,	0,	0,	2,	0,	1,	0,	1,	-1,	-4,	-2,	-1,	0,	2,	-4,	-12,	2,	-19,	3,	2,	1},
	{2,	0,	2,	2,	1,	0,	0,	-1,	0,	0,	0,	1,	1,	1,	-2,	-4,	-2,	-1,	0,	4,	-1,	-9,	2,	-16,	0,	-1,	-3},
	{2,	0,	2,	1,	0,	0,	1,	0,	0,	0,	0,	1,	1,	1,	-2,	-2,	1,	2,	-2,	1,	-3,	-6,	3,	-13,	6,	2,	1},
	{1,	0,	1,	1,	0,	1,	0,	0,	0,	1,	0,	1,	-1,	1,	-3,	-1,	1,	3,	-4,	-1,	-5,	-7,	0,	-15,	4,	-1,	-5},
	{2,	0,	1,	0,	0,	1,	1,	0,	0,	2,	0,	1,	-1,	0,	-3,	-3,	-1,	0,	1,	2,	-2,	-11,	-1,	-18,	7,	3,	-2},
	{1,	0,	2,	1,	0,	2,	1,	0,	0,	1,	1,	1,	-1,	0,	-2,	0,	1,	2,	-3,	-1,	-4,	-9,	2,	-15,	4,	1,	-5},
	{2,	0,	1,	1,	1,	1,	1,	0,	1,	1,	1,	1,	0,	0,	-2,	-2,	0,	0,	-2,	1,	-2,	-11,	-1,	-18,	7,	5,	-2},
	{1,	0,	1,	2,	0,	1,	0,	0,	1,	1,	0,	0,	1,	2,	0,	-2,	-1,	0,	-2,	-1,	-4,	-6,	4,	-12,	11,	9,	2},
	{1,	0,	1,	1,	0,	2,	2,	1,	2,	1,	0,	-1,	0,	1,	0,	0,	2,	2,	1,	1,	-1,	-9,	1,	-14,	8,	4,	0},
	{1,	0,	0,	1,	1,	2,	1,	1,	0,	1,	0,	2,	-1,	0,	-2,	-2,	-1,	1,	-2,	-1,	-3,	-7,	4,	-11,	4,	1,	-4},
	{1,	0,	1,	1,	1,	1,	3,	2,	2,	0,	-1,	0,	0,	1,	-1,	0,	2,	3,	-1,	-1,	-3,	-6,	2,	-10,	-5,	-2,	-11},
	{1,	0,	1,	1,	0,	0,	1,	0,	1,	1,	0,	0,	-1,	0,	-1,	0,	1,	2,	-1,	0,	-2,	-6,	3,	-8,	-1,	1,	-8},
	{0,	0,	0,	1,	0,	2,	1,	1,	0,	1,	0,	1,	1,	2,	0,	-1,	0,	1,	-2,	-1,	-2,	-6,	1,	-9,	3,	4,	-4},
	{0,	0,	0,	1,	0,	1,	0,	0,	-1,	0,	0,	1,	0,	0,	0,	0,	2,	2,	-1,	0,	-2,	-9,	-1,	-12,	6,	7,	0},
	{1,	0,	1,	0,	0,	0,	5,	5,	5,	-1,	-2,	-1,	0,	1,	0,	0,	2,	2,	-2,	-1,	-2,	-5,	2,	-7,	2,	4,	-3},
	{1,	0,	1,	0,	0,	0,	4,	3,	3,	0,	0,	1,	-1,	0,	0,	1,	2,	2,	1,	2,	0,	-4,	4,	-4,	-2,	1,	-6},
	{1,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	2,	2,	-1,	-1,	-2,	-1,	6,	-1,	3,	3,	-1},
	{1,	0,	1,	0,	0,	0,	1,	0,	1,	1,	0,	1,	-1,	0,	-1,	0,	1,	1,	1,	2,	1,	-4,	2,	-4,	0,	1,	-4},
	{0,	0,	0,	1,	0,	0,	1,	0,	2,	1,	0,	-1,	-1,	-1,	0,	1,	1,	2,	-1,	-1,	-2,	-7,	0,	-7,	3,	4,	0},
	{0,	0,	0,	1,	0,	1,	0,	0,	0,	1,	1,	2,	1,	1,	0,	1,	1,	2,	2,	2,	0,	-2,	3,	0,	0,	0,	-1},
	{0,	0,	0,	0,	0,	1,	1,	1,	1,	0,	-2,	-1,	1,	1,	2,	0,	1,	1,	-1,	-1,	-2,	-2,	4,	0,	5,	2,	2},
	{0,	0,	0,	2,	0,	1,	1,	1,	2,	0,	0,	-1,	-1,	-2,	-1,	0,	1,	2,	0,	1,	0,	-2,	2,	-1,	1,	1,	-1},
	{0,	0,	0,	0,	0,	0,	1,	0,	2,	1,	0,	0,	-1,	-2,	-1,	-1,	0,	0,	-2,	-2,	-2,	-1,	3,	1,	3,	4,	2},
	{0,	0,	0,	-1,	0,	-1,	2,	1,	2,	-1,	-2,	-2,	1,	0,	1,	0,	2,	2,	-3,	-2,	-3,	-3,	-2,	-2,	1,	4,	1},
	{0,	0,	0,	1,	1,	1,	-1,	-1,	-1,	0,	-1,	-1,	1,	0,	1,	-3,	-2,	-1,	0,	1,	1,	0,	1,	1,	-2,	1,	-1},
	{0,	0,	0,	0,	0,	1,	2,	1,	1,	0,	-1,	-1,	-1,	-1,	0,	0,	1,	0,	-3,	-3,	-2,	-3,	-1,	-2,	0,	4,	2},
	{0,	0,	0,	-1,	0,	-1,	1,	0,	1,	0,	-1,	0,	2,	2,	2,	-3,	-2,	-2,	0,	0,	0,	-1,	2,	1,	-2,	1,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

static int gradation_offset_hero2_a2_line[LUMINANCE_MAX][9]={
	{ 0, 8, 15, 26, 34, 38, 42, 46, 46},
	{ 0, 8, 15, 25, 32, 36, 40, 45, 45},
	{ 0, 6, 11, 20, 25, 28, 32, 36, 36},
	{ 0, 6, 10, 18, 22, 25, 29, 33, 33},
	{ 0, 6, 10, 16, 20, 24, 27, 30, 30},
	{ 0, 6, 9, 14, 18, 21, 24, 28, 28},
	{ 0, 5, 8, 13, 16, 19, 22, 26, 26},
	{ 0, 5, 7, 12, 15, 18, 21, 25, 25},
	{ 0, 4, 6, 11, 14, 16, 19, 23, 23},
	{ 0, 4, 6, 11, 14, 16, 19, 23, 23},
	{ 0, 4, 6, 10, 13, 15, 18, 22, 22},
	{ 0, 4, 6, 10, 13, 15, 18, 22, 22},
	{ 0, 4, 4, 8, 13, 15, 18, 22, 22},
	{ 0, 4, 4, 8, 11, 13, 16, 20, 20},
	{ 0, 5, 5, 8, 11, 13, 16, 20, 20},
	{ 0, 3, 3, 6, 10, 12, 15, 18, 18},
	{ 0, 4, 4, 7, 9, 11, 13, 16, 16},
	{ 0, 5, 4, 6, 8, 10, 13, 16, 16},
	{ 0, 4, 4, 6, 8, 10, 12, 15, 15},
	{ 0, 3, 4, 6, 8, 9, 11, 14, 14},
	{ 0, 4, 3, 6, 7, 9, 11, 14, 14},
	{ 0, 3, 3, 5, 7, 9, 11, 14, 14},
	{ 0, 2, 3, 4, 6, 8, 10, 13, 13},
	{ 0, 2, 2, 4, 5, 7, 9, 12, 12},
	{ 0, 2, 2, 4, 5, 7, 8, 11, 11},
	{ 0, 3, 3, 4, 5, 6, 7, 10, 10},
	{ 0, 2, 2, 3, 4, 5, 6, 9, 9},
	{ 0, 3, 3, 3, 4, 5, 6, 9, 9},
	{ 0, 3, 2, 4, 4, 5, 6, 9, 9},
	{ 0, 2, 2, 3, 4, 5, 6, 8, 8},
	{ 0, 3, 3, 3, 4, 5, 6, 8, 8},
	{ 0, 2, 2, 2, 3, 4, 5, 7, 7},
	{ 0, 2, 1, 2, 3, 4, 5, 7, 7},
	{ 0, 3, 2, 2, 3, 3, 4, 6, 6},
	{ 0, 2, 1, 1, 2, 2, 3, 4, 4},
	{ 0, 2, 1, 1, 2, 2, 3, 4, 4},
	{ 0, 2, 0, 1, 2, 2, 3, 4, 4},
	{ 0, 1, 1, 1, 2, 2, 2, 3, 3},
	{ 0, 2, 1, 1, 2, 3, 3, 4, 4},
	{ 0, 3, 1, 1, 1, 2, 2, 4, 5},
	{ 0, 3, 2, 2, 1, 1, 2, 3, 3},
	{ 0, 3, 1, 1, 1, 2, 2, 3, 3},
	{ 0, 1, 3, 3, 1, 2, 2, 3, 4},
	{ 0, 3, 2, 3, 2, 2, 2, 3, 4},
	{ 0, 0, 1, 2, 2, 2, 2, 3, 4},
	{ 0, 1, 2, 2, 2, 2, 3, 4, 5},
	{ 0, 1, 3, 3, 2, 2, 2, 3, 4},
	{ 0, 0, 2, 2, 2, 2, 2, 3, 3},
	{ 0, 2, 1, 3, 2, 2, 3, 3, 3},
	{ 0, 3, 3, 3, 2, 3, 2, 3, 3},
	{ 0, 1, 3, 3, 2, 2, 2, 3, 3},
	{ 0, 1, 3, 2, 2, 2, 2, 3, 4},
	{ 0, 2, 3, 2, 2, 1, 2, 2, 3},
	{ 0, 4, 4, 2, 2, 2, 2, 3, 3},
	{ 0, 2, 3, 3, 2, 2, 1, 2, 2},
	{ 0, 2, 4, 3, 2, 2, 1, 2, 3},
	{ 0, 2, 3, 2, 2, 2, 1, 1, 3},
	{ 0, 0, 0, 0, 0, 0, 0, 1, 1},
	{ 0, 0, 0, 1, 0, 0, 0, 0, 0},
	{ 0, 3, 3, 1, 0, 0, 0, 0, 0},
	{ 0, 1, 1, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 1, 0, 0, 0, 0, 0, 1},
	{ 0, 2, 3, 1, 0, 1, 0, 0, 1},
	{ 0, 2, 3, 1, 0, 0, 0, 0, 1},
	{ 0, 0, 1, 1, 0, 0, 0, 0, 1},
	{ 0, 1, 1, 0, 0, 0, 0, 0, 1},
	{ 0, 1, 1, 0, 0, 0, 0, 0, 0},
	{ 0, 1, 1, 0, 0, 0, 0, 0, 1},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

static int rgb_offset_hero2_a2_line[LUMINANCE_MAX][RGB_COMPENSATION] = {
	{ -4, 1, -7, 0, 1, -2, -3, 1, -5, -4, 1, -11, -2, 1, -15, 1, 1, -11, 1, 0, -9, -6, 1, -13, -30, -16, -37},
	{ -4, -1, -7, -1, 0, -2, -5, -1, -6, -6, -1, -13, -5, -1, -16, -3, 0, -13, -1, -1, -14, -8, -1, -15, -29, -15, -36},
	{ -2, 0, -5, -1, 0, -1, -2, 0, -4, -6, 0, -10, -5, -1, -16, 0, 1, -12, 0, -1, -14, -6, 1, -15, -28, -14, -36},
	{ -2, 0, -4, -1, 0, -2, -2, 0, -3, -6, -1, -11, -4, 0, -15, -1, 1, -12, -1, -1, -15, -6, 1, -15, -28, -13, -35},
	{ -1, 0, -3, 0, 0, -1, -2, 0, -3, -5, 0, -9, -6, -1, -15, -2, -2, -15, 0, 1, -12, -6, 1, -15, -27, -13, -35},
	{ 0, 0, -2, -1, 0, -2, -1, 0, -2, -4, 1, -7, -5, 0, -15, 0, 1, -13, 0, 1, -13, -9, -1, -17, -26, -11, -33},
	{ 0, 0, -2, 0, 0, -1, -2, 0, -2, -4, 0, -6, -4, 1, -13, -1, 0, -13, -1, 0, -15, -7, 0, -15, -26, -11, -32},
	{ 1, 0, -1, 0, 0, -1, -1, 0, -2, -5, 0, -6, -3, 1, -12, -2, -1, -14, -2, 0, -16, -7, 1, -14, -26, -11, -33},
	{ 1, 0, -1, 0, 0, 0, -1, 0, -2, -5, 0, -6, -3, 1, -12, 0, 1, -13, 0, 1, -14, -6, 2, -14, -26, -10, -33},
	{ 2, 0, 0, 1, 0, 0, -2, -1, -2, -5, 0, -6, -4, -1, -13, 0, 1, -12, -1, 1, -15, -6, 2, -14, -26, -10, -33},
	{ 2, 0, 0, 0, 0, 0, -1, 0, -2, -3, 0, -4, -4, -1, -13, -1, 1, -12, 0, 1, -14, -8, -1, -17, -26, -10, -32},
	{ 2, 0, 0, 0, 0, -1, 0, 0, -1, -4, -1, -5, -4, -1, -12, -2, 0, -13, -1, 1, -16, -9, -1, -17, -26, -10, -32},
	{ 3, 0, 1, 0, 0, 0, 0, 0, -1, -3, 1, -3, -8, -5, -16, -2, -1, -13, -2, -1, -17, -9, -1, -17, -26, -10, -32},
	{ 3, 0, 1, 0, 0, 0, 1, 1, 0, -4, 0, -4, -4, -1, -12, -1, 0, -12, -1, 0, -16, -9, -1, -16, -25, -10, -32},
	{ 3, 0, 1, 0, 0, 0, 0, 0, -1, -3, 0, -3, -5, -1, -12, -3, -1, -14, -2, -1, -16, -4, -2, -26, -18, -9, -23},
	{ 3, 0, 1, 0, 0, 0, 0, 1, 0, -2, 1, -2, -5, -3, -13, -2, 0, -12, -1, -1, -17, 0, 1, -21, 11, -9, -18},
	{ 3, 0, 1, 0, 0, 0, 0, 0, -1, -3, 0, -3, -3, 0, -10, -2, -1, -12, 0, 2, -15, 0, 1, -25, -7, -8, -6},
	{ 3, 0, 1, 0, 0, 0, 0, 0, 0, -1, 1, -1, -3, 0, -10, -1, 0, -10, -4, -2, -18, -2, 1, -25, -6, -7, -5},
	{ 3, 0, 1, 0, 0, 0, 0, 0, -1, -1, 1, -1, -3, -1, -10, -2, -1, -10, 0, 1, -15, -1, 2, -24, 15, -7, -13},
	{ 3, 0, 1, 1, 0, 0, -1, -1, -1, -3, 0, -2, -2, 0, -9, 0, 2, -9, 0, 2, -14, 1, 1, -22, 13, -7, -10},
	{ 3, 0, 1, 1, 0, 1, 0, 1, -1, -3, -1, -2, -2, 1, -7, -3, -1, -10, -2, 0, -16, 0, 1, -22, -7, -7, -4},
	{ 3, 0, 2, 1, 0, 1, 0, 1, 0, -3, 0, -2, -2, -1, -9, -4, -2, -10, -2, -1, -16, -1, 0, -23, -7, -7, -16},
	{ 3, 0, 2, 1, 0, 1, 0, 0, 0, -1, 0, 0, -2, -1, -8, -4, -1, -10, -3, -2, -17, 0, 0, -23, -7, -2, -1},
	{ 3, 0, 2, 1, 0, 1, 1, 1, 0, -2, 0, 0, -1, 0, -7, -4, -1, -9, -4, -3, -17, 1, 0, -22, -6, -7, -6},
	{ 3, 0, 1, 2, 0, 1, -1, 0, -1, -3, -1, -1, -1, 0, -7, -3, -1, -9, 0, 2, -11, 1, 0, -23, 15, -7, -3},
	{ 3, 0, 2, 1, 0, 0, -1, 0, -1, -1, 0, 0, -2, 0, -7, 0, 2, -5, 2, 3, -8, 1, -1, -23, 16, -6, -8},
	{ 4, 0, 2, 1, 0, 1, -1, 0, -1, -1, 1, 0, 0, 1, -5, -1, 2, -5, 4, 3, -5, 0, -1, -23, 14, -6, -5},
	{ 4, 0, 2, 1, 0, 1, -1, 0, -1, -1, 1, 1, -1, 0, -6, -1, 2, -5, 2, 1, -7, -2, -3, -25, 12, -3, -3},
	{ 4, 0, 2, 1, 0, 1, 0, 0, 0, -3, -2, -1, 0, 1, -4, -2, 1, -6, 2, 1, -6, -4, -4, -26, 12, -6, -5},
	{ 3, 0, 2, 2, 0, 2, -1, 0, -1, -3, -1, -1, -1, -1, -6, -2, 0, -5, 1, 0, -7, 2, 1, -21, 14, -6, -2},
	{ 4, 0, 2, 1, 0, 1, -1, 0, -1, -1, 0, 1, -1, -1, -6, -4, -1, -6, 0, -1, -8, 1, 1, -22, 14, -6, -4},
	{ 4, 0, 2, 1, 0, 1, -1, 0, -2, -1, 0, 1, -1, 0, -4, -2, -1, -6, 0, -2, -6, 1, 0, -21, 13, -6, -8},
	{ 4, 0, 2, 1, 0, 1, -1, 0, 0, -1, 0, 0, -1, -1, -4, -3, -2, -6, 0, -2, -6, -1, -2, -24, 12, -6, -6},
	{ 3, 0, 2, 0, 0, 1, 0, 0, -1, 0, 1, 2, -1, -1, -4, -1, 2, -3, 3, -1, -3, -3, -3, -24, 13, -2, -7},
	{ 3, 0, 2, 1, 0, 1, -1, 0, -1, -1, 0, 1, 1, 1, -2, 1, 2, -3, 5, 1, 2, 2, 2, -18, 19, -1, -2},
	{ 3, 0, 2, 1, 0, 1, 0, 0, 0, -1, 0, 1, 0, 0, -3, 0, 1, -2, 2, -2, -1, 3, 2, -17, 14, -4, -4},
	{ 3, 0, 2, 1, 0, 1, 0, -1, 1, -1, 0, 0, 0, -1, -3, -2, 0, -3, 3, -3, -1, 1, 1, -18, 15, -4, -5},
	{ 3, 0, 2, 0, 0, 1, 0, 0, 0, -1, 0, 1, 2, 0, -2, -1, 0, -3, 6, 1, 4, 2, 1, -17, 15, -4, -5},
	{ 3, 0, 2, 0, 1, 1, 0, -1, 0, -1, 0, 1, 0, -2, -4, -2, 0, -3, 6, 2, 4, -3, -2, -22, 17, 0, -2},
	{ 4, 0, 3, 1, 0, 1, 1, 0, -1, 0, 1, 3, 1, 0, -2, -2, -1, -3, 5, 0, 2, -4, -2, -23, -11, 0, 4},
	{ 4, 0, 2, 0, 0, 0, 0, 0, 1, 0, 1, 2, 2, 2, -1, 2, 2, 0, 4, -1, 2, 2, 4, -12, 6, -2, -2},
	{ 3, 0, 2, 1, 0, 2, 1, 0, 1, 0, 1, 2, 2, 0, -3, 0, 2, 0, 1, -3, -1, 1, 1, -15, 18, 2, 2},
	{ 4, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, -2, 4, 1, 3, 0, 1, -15, 13, 0, -3},
	{ 4, 0, 2, 1, 0, 1, -1, 0, -1, 1, 0, 2, 1, 1, 0, 2, 2, 1, 4, 1, 2, -3, -1, -18, -3, 3, -1},
	{ 4, 0, 2, 1, 0, 1, 0, 0, 0, 0, 0, 2, 1, 0, -2, 1, 1, 0, 2, -2, -1, 0, 4, -11, 11, 0, -5},
	{ 4, 0, 2, 0, 0, 1, 1, 0, 0, 0, 0, 2, 0, 0, -2, -1, -1, -3, 1, -1, -2, -3, 0, -14, 12, 3, -3},
	{ 4, 0, 1, 0, 0, 2, 0, 1, 0, 0, -1, 0, 1, 1, 0, 1, 3, 1, 0, -2, -2, -2, -2, -14, 15, 6, 0},
	{ 3, 0, 2, 1, 0, 1, 0, 1, 1, 2, 1, 3, -1, -1, -2, 0, 0, -1, 2, 0, 0, -2, -1, -13, 3, 0, -6},
	{ 5, 0, 3, 0, 0, 0, 0, 0, 1, 1, 0, 2, 0, 0, 0, 0, 0, -2, 0, -1, -2, 2, 2, -7, 2, 0, -6},
	{ 5, 0, 3, 0, 0, 0, 0, 0, 1, 1, 1, 2, 0, 0, -1, 0, -1, -2, 3, 3, 1, 0, 0, -9, 6, 3, -3},
	{ 5, 0, 3, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, -1, 3, 3, 2, 0, 0, -6, 6, 3, -3},
	{ 4, 0, 2, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, -1, 0, 2, 2, 0, 1, 0, -1, -3, -2, -10, 2, 0, -8},
	{ 4, 0, 2, 1, 0, 1, 1, 1, 2, 1, 1, 1, 0, 0, 1, 3, 2, 0, 1, 0, -1, 2, 1, -6, 7, 3, -4},
	{ 4, 0, 2, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 2, 1, 0, -1, 0, -3, -3, -2, -5, 5, -1, -6},
	{ 4, 0, 2, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 2, 1, -1, 1, 2, 1, 2, 2, -2, 11, 3, -2},
	{ 5, 0, 3, 1, 0, 0, -1, 0, 0, 2, 0, 1, 0, 1, 1, 2, 0, -1, 1, 1, 1, 0, -1, -5, 6, 1, -7},
	{ 5, 0, 3, 1, 0, 1, -1, 0, -1, 2, 1, 3, -1, -1, -1, 0, -1, -1, 2, 1, 1, 3, 3, -1, 2, -1, -10},
	{ 4, 0, 3, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 2, 3, 1, 1, -2, -3, -2, -1, 0, -3, -1, 0, -4},
	{ 3, 0, 2, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 2, 0, 0, 3, 0, 3, 3, 3, 2, 4, 3, -2},
	{ 2, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 2, 2, 1, 2, 2, 2, 1, 4, 1, 4, -1, 0, 0, 3, 0, -5},
	{ 3, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, -1, -1, 0, 1, -1, 0, 1, 0, 1, -3, -3, -2, 7, 3, -2},
	{ 3, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, -2, -2, -1, 0, -1, -1, 4, 3, 4, -4, -3, -3, 0, -2, -4},
	{ 3, 0, 2, 1, 0, 0, 0, 0, 1, 0, -1, 0, -1, -1, 0, 1, -1, -1, 0, 0, 0, -2, -1, 0, 3, 1, -2},
	{ 2, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, -1, -1, 0, 2, 0, 0, 0, 0, 1, -4, -4, -2, 1, -2, -5},
	{ 2, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, -1, -2, -2, 0, 0, 0, -1, -1, 2, 3, 1, -2},
	{ 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, -2, -2, -1, 1, -1, 0, -3, -3, -2, -4, -4, -2, 5, 3, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
};

static unsigned int base_luminance_hero2_a2_line[LUMINANCE_MAX][2] = {//4194304
	{ 2, 499122176 },
	{ 3, 499122176 },
	{ 4, 499122176 },
	{ 5, 499122176 },
	{ 6, 499122176 },
	{ 7, 499122176 },
	{ 8, 499122176 },
	{ 9, 499122176 },
	{ 10, 499122176 },
	{ 11, 499122176 },
	{ 12, 499122176 },
	{ 13, 499122176 },
	{ 14, 499122176 },
	{ 15, 499122176 },
	{ 16, 499122176 },
	{ 17, 499122176 },
	{ 19, 499122176 },
	{ 20, 859832320 },
	{ 21, 499122176 },
	{ 22, 499122176 },
	{ 24, 499122176 },
	{ 25, 499122176 },
	{ 27, 499122176 },
	{ 29, 499122176 },
	{ 30, 499122176 },
	{ 32, 499122176 },
	{ 34, 499122176 },
	{ 37, 499122176 },
	{ 39, 499122176 },
	{ 41, 499122176 },
	{ 44, 499122176 },
	{ 47, 499122176 },
	{ 50, 499122176 },
	{ 53, 499122176 },
	{ 56, 499122176 },
	{ 60, 499122176 },
	{ 64, 499122176 },
	{ 68, 515899392 },
	{ 72, 536870912 },
	{ 77, 570425344 },
	{ 82, 612368384 },
	{ 87, 654311424 },
	{ 93, 692060160 },
	{ 98, 1056964608 },
	{ 105, 767557632 },
	{ 111, 805306368 },
	{ 119, 855638016 },
	{ 126, 918552576 },
	{ 134, 952107008 },
	{ 143, 1019215872 },
	{ 152, 1077936128 },
	{ 162, 1145044992 },
	{ 172, 1195376640 },
	{ 183, 817889280},
	{ 195, 1245708288 },
	{ 207, 1245708288 },
	{ 220, 1245708288 },
	{ 234, 1245708288 },
	{ 249, 1283457024 },
	{ 265, 1333788672 },
	{ 282, 1388314624 },
	{ 300, 1455423488 },
	{ 316, 1526726656 },
	{ 333, 1598029824 },
	{ 350, 1656750080 },
	{ 357, 1669332992 },
	{ 365, 1698693120 },
	{ 372, 1698693120 },
	{ 380, 1698693120 },
	{ 387, 1698693120 },
	{ 395, 1698693120 },
	{ 403, 1715470336 },
	{ 412, 1728053248 },
	{ 420, 1761607680 },
};

/************
 *	  HMT   *
 ************/
static unsigned int base_luminance_reverse_hmt_single_a2_line[HMT_LUMINANCE_MAX][2] = {
	{ 10, 41943040 },
	{ 11, 46137344 },
	{ 12, 50331648 },
	{ 13, 54525952 },
	{ 14, 58720256 },
	{ 15, 62914560 },
	{ 16, 67108864 },
	{ 17, 71303168 },
	{ 19, 79691776 },
	{ 20, 83886080 },
	{ 21, 88080384 },
	{ 22, 92274688 },
	{ 23, 96468992 },
	{ 25, 104857600 },
	{ 27, 113246208 },
	{ 29, 121634816 },
	{ 31, 130023424 },
	{ 33, 138412032 },
	{ 35, 146800640 },
	{ 37, 155189248 },
	{ 39, 163577856 },
	{ 41, 171966464 },
	{ 44, 184549376 },
	{ 47, 197132288 },
	{ 50, 209715200 },
	{ 53, 222298112 },
	{ 56, 234881024 },
	{ 60, 251658240 },
	{ 64, 268435456 },
	{ 68, 285212672 },
	{ 72, 301989888 },
	{ 77, 322961408 },
	{ 82, 343932928 },
	{ 87, 364904448 },
	{ 93, 390070272 },
	{ 99, 415236096 },
	{ 105, 440401920 },
};

static int rgb_offset_reverse_hmt_single_a2_line[HMT_LUMINANCE_MAX][27]={
	{ 0, 0, -1, 0, 0, 0, 0, 0, -1, -4, 2, -6, -2, 4, -10, -2, 5, -11, 1, 5, -12, 9, 2, -6, 13, 4, 8},
	{ 1, 0, 0, 0, 0, 0, -2, 0, -1, -3, 2, -5, -3, 5, -11, -1, 4, -9, 2, 5, -10, 9, 2, -10, 13, 4, 6},
	{ 1, 0, 1, 0, 0, 0, -2, 0, -1, -4, 2, -5, -4, 5, -10, -1, 4, -10, 0, 5, -10, 9, 2, -10, 13, 4, 6},
	{ 1, 0, 0, 0, 0, 0, 0, 0, 0, -3, 2, -4, -3, 4, -10, -1, 5, -10, 2, 5, -12, 7, 2, -10, 11, 4, 8},
	{ 1, 0, 0, 0, 0, 0, 0, 0, 0, -3, 1, -4, -4, 4, -10, -2, 4, -9, 1, 5, -10, 7, 6, -11, 7, 1, 1},
	{ 1, 0, 0, 0, 0, 0, -2, 0, -2, -3, 1, -4, -2, 4, -9, -2, 4, -9, 1, 4, -10, 7, 6, -12, 6, 1, 0},
	{ 1, 0, 0, 0, 0, 0, 0, 0, 0, -4, 1, -4, -3, 4, -9, -1, 4, -9, 0, 4, -10, 5, 6, -12, 5, 1, 0},
	{ 1, 0, 0, 0, 0, 0, 0, 0, -1, -4, 1, -3, -1, 4, -8, -2, 4, -10, 1, 5, -10, 5, 7, -14, 10, 1, 3},
	{ 2, 0, 1, 0, 0, 0, 0, 0, 0, -3, 1, -3, -3, 3, -8, -1, 4, -8, 1, 5, -10, 5, 7, -14, 10, 1, 0},
	{ 2, 0, 1, 0, 0, 0, 0, 0, -1, -3, 1, -2, -4, 3, -8, -1, 4, -8, 0, 4, -9, 3, 6, -14, 9, 3, 0},
	{ 2, 0, 1, 0, 0, 0, 0, 0, 0, -4, 1, -3, -2, 3, -7, -2, 4, -8, 1, 5, -10, 5, 6, -13, 6, 3, 0},
	{ 2, 0, 1, 0, 0, 0, -1, 0, 0, -2, 1, -4, -4, 3, -7, -2, 3, -8, 0, 5, -10, 5, 6, -13, 6, 3, 0},
	{ 2, 0, 1, 0, 0, 0, 0, 0, 0, -1, 1, -2, -4, 3, -8, -2, 3, -7, 0, 6, -12, 5, 6, -13, 5, 1, 0},
	{ 1, 0, 0, 0, 0, 1, -1, 0, 0, -1, 1, -2, -4, 3, -7, -2, 3, -7, 0, 5, -11, 5, 7, -14, 5, 2, -2},
	{ 2, 0, 1, 0, 0, 0, 0, 0, 0, -2, 1, -3, -3, 3, -6, -2, 3, -7, 0, 5, -11, 3, 6, -14, 4, 1, -2},
	{ 3, 0, 1, 0, 0, 0, 0, 0, 0, -1, 1, -2, -4, 3, -6, -2, 3, -8, -1, 5, -12, 3, 6, -14, 4, 1, -2},
	{ 2, 0, 2, 0, 0, 0, -1, 0, 0, -3, 0, -2, -2, 3, -6, -2, 3, -8, -1, 5, -11, 3, 6, -14, 4, 1, -2},
	{ 1, 0, 1, 0, 0, 1, 0, 0, 0, -1, 1, -2, -3, 2, -6, -2, 3, -8, 0, 5, -10, 2, 6, -15, 6, 3, -2},
	{ 2, 0, 1, 0, 0, 0, 0, 0, 0, -2, 0, -2, -3, 2, -6, -2, 3, -6, 0, 5, -10, 2, 6, -15, 4, 4, -5},
	{ 2, 0, 2, 0, 0, 0, -1, 0, 0, -1, 0, -1, -3, 2, -6, -3, 2, -6, -1, 5, -11, 2, 6, -15, 6, 6, -5},
	{ 3, 0, 3, 0, 0, 0, -1, 0, 0, -2, 0, -2, -3, 2, -5, -1, 3, -6, -1, 5, -10, 2, 6, -15, 4, 2, -5},
	{ 3, 0, 3, 0, 0, 0, 0, 0, -2, -2, 0, -1, -3, 2, -5, -3, 3, -7, 0, 4, -9, 1, 7, -14, 1, 0, -7},
	{ 3, 0, 2, 0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 2, -4, -2, 3, -7, 0, 4, -8, 1, 8, -17, 1, 0, -8},
	{ 4, 0, 3, 0, 0, 0, 0, 0, 0, -1, 0, -1, -3, 1, -4, -2, 3, -7, -1, 4, -10, 0, 6, -15, 3, 2, -6},
	{ 4, 0, 4, 0, 0, 0, 0, 0, 0, -3, 0, -2, -3, 1, -4, -2, 2, -6, -2, 4, -10, 1, 7, -16, 4, 3, -6},
	{ 5, 0, 4, 0, 0, 0, 0, 0, -1, -2, 0, -1, -4, 1, -4, -2, 2, -6, -2, 4, -10, 1, 7, -16, 4, 3, -6},
	{ 4, 0, 3, 0, 0, 0, 0, 0, -1, -2, 0, -1, -3, 1, -4, -2, 3, -6, -1, 4, -8, 0, 7, -16, 2, 2, -6},
	{ 4, 0, 4, 0, 0, 0, 0, 0, -1, -2, 0, -1, -1, 1, -2, -3, 2, -6, -2, 4, -10, 1, 8, -16, 3, 3, -6},
	{ 4, 0, 4, 1, 0, 0, -1, 0, -1, 0, 0, -1, -2, 1, -2, -3, 2, -6, -2, 4, -8, 0, 8, -18, 5, 3, -3},
	{ 4, -1, 4, -1, 0, -1, -1, 0, -1, -1, 0, -1, -2, 1, -2, -3, 2, -6, -1, 4, -8, 0, 8, -16, 5, 3, -3},
	{ 4, -1, 4, 0, 0, -1, -1, 0, -1, -2, 0, -1, -2, 1, -2, -2, 2, -6, -2, 4, -9, 0, 8, -16, 5, 3, -3},
	{ 4, 0, 4, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 1, -2, -1, 2, -4, -2, 3, -8, 2, 6, -12, 5, 3, -5},
	{ 4, -1, 4, 0, 0, 0, 0, 0, 0, 0, 0, -1, -2, 1, -3, -2, 1, -4, 0, 3, -7, 1, 7, -15, 5, 3, -5},
	{ 4, 0, 4, 0, 0, 0, 0, 0, 0, -2, 0, -2, -1, 1, -2, -2, 1, -4, -1, 3, -7, 1, 7, -14, 6, 4, -5},
	{ 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 1, -2, -3, 1, -4, -2, 3, -7, 2, 7, -14, 6, 4, -5},
	{ 5, 0, 4, 0, 0, 0, -2, 0, -1, 0, 0, 0, -1, 0, -2, -3, 1, -4, 0, 3, -6, 0, 6, -13, 2, 0, -6},
	{ 4, -1, 4, 0, 0, 0, -2, 0, -1, 0, 0, 0, -1, 1, -2, -3, 1, -4, -1, 3, -6, 0, 6, -14, 4, 1, -6},
};

static int gradation_offset_reverse_hmt_single_a2_line[HMT_LUMINANCE_MAX][9] = {
	{ 0, 0, 1, 4, 8, 9, 10, 12, 12},
	{ 0, 0, 1, 3, 6, 8, 10, 12, 12},
	{ 0, 1, 1, 4, 6, 8, 11, 12, 12},
	{ 0, 1, 1, 3, 6, 8, 9, 12, 12},
	{ 0, 1, 1, 3, 6, 8, 10, 12, 13},
	{ 0, 1, 1, 3, 6, 8, 10, 11, 12},
	{ 0, 2, 2, 2, 5, 7, 9, 11, 12},
	{ 0, 2, 1, 2, 5, 7, 9, 11, 12},
	{ 0, 3, 1, 1, 5, 7, 8, 11, 12},
	{ 0, 3, 1, 1, 5, 6, 9, 12, 12},
	{ 0, 1, 0, 2, 5, 7, 9, 11, 12},
	{ 0, 3, 1, 2, 6, 8, 10, 11, 12},
	{ 0, 3, 0, 2, 4, 7, 8, 11, 12},
	{ 0, 3, 1, 3, 5, 8, 9, 10, 13},
	{ 0, 2, 1, 3, 5, 7, 9, 12, 12},
	{ 0, 1, 1, 3, 4, 6, 8, 12, 12},
	{ 0, 1, 1, 3, 5, 7, 9, 12, 12},
	{ 0, 2, 2, 3, 5, 6, 8, 11, 12},
	{ 0, 2, 3, 4, 6, 7, 9, 11, 12},
	{ 0, 2, 2, 4, 5, 7, 8, 11, 12},
	{ 0, 2, 1, 4, 5, 6, 8, 11, 12},
	{ 0, 2, 1, 4, 5, 7, 9, 11, 13},
	{ 0, 2, 1, 3, 5, 6, 8, 10, 12},
	{ 0, 2, 1, 4, 5, 6, 8, 11, 12},
	{ 0, 2, 1, 4, 5, 7, 8, 11, 12},
	{ 0, 2, 1, 3, 5, 6, 8, 11, 12},
	{ 0, 2, 2, 5, 5, 6, 8, 10, 12},
	{ 0, 1, 3, 4, 5, 7, 8, 10, 12},
	{ 0, 1, 3, 5, 5, 7, 8, 10, 12},
	{ 0, 2, 5, 6, 6, 7, 9, 11, 11},
	{ 0, 3, 5, 6, 7, 8, 9, 11, 11},
	{ 0, -1, 0, 2, 3, 3, 5, 8, 8},
	{ 0, -1, 0, 3, 3, 3, 5, 7, 8},
	{ 0, 0, 1, 3, 3, 4, 5, 7, 8},
	{ 0, 1, 1, 3, 3, 3, 4, 7, 8},
	{ 0, -1, 2, 4, 3, 3, 5, 8, 8},
	{ 0, 1, 2, 4, 4, 4, 6, 8, 8},
};

static unsigned int base_luminance_reverse_hmt_single[][2] = {
	{10,	239075328},
	{11,	255852544},
	{12,	276824064},
	{13,	301989888},
	{14,	322961408},
	{15,	339738624},
	{16,	360710144},
	{17,	385875968},
	{19,	419430400},
	{20,	444596224},
	{21,	457179136},
	{22,	478150656},
	{23,	494927872},
	{25,	528482304},
	{27,	566231040},
	{29,	599785472},
	{31,	637534208},
	{33,	671088640},
	{35,	713031680},
	{37,	746586112},
	{39,	788529152},
	{41,	826277888},
	{44,	876609536},
	{47,	931135488},
	{50,	964689920},
	{53,	1035993088},
	{56,	1086324736},
	{60,	1136656384},
	{64,	1199570944},
	{68,	1262485504},
	{72,	1317011456},
	{77,	1023410176},
	{82,	1082130432},
	{87,	1132462080},
	{93,	1186988032},
	{99,	1241513984},
	{105,	1325400064},
};

static int gradation_offset_reverse_hmt_single[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0,	2,	1,	3,	5,	7,	8,	9,	10},
	{0,	3,	3,	3,	5,	6,	8,	9,	9},
	{0,	2,	2,	3,	5,	7,	7,	9,	15},
	{0,	2,	2,	3,	4,	6,	7,	9,	14},
	{0,	2,	3,	4,	5,	6,	8,	9,	8},
	{0,	1,	3,	4,	5,	6,	7,	8,	11},
	{0,	0,	2,	3,	4,	6,	7,	8,	11},
	{0,	0,	3,	4,	4,	6,	7,	9,	8},
	{0,	0,	4,	4,	5,	5,	6,	9,	8},
	{0,	1,	3,	4,	4,	5,	7,	9,	10},
	{0,	1,	3,	4,	5,	5,	7,	9,	9},
	{0,	1,	3,	3,	4,	6,	7,	8,	9},
	{0,	1,	3,	3,	5,	5,	7,	9,	8},
	{0,	1,	3,	3,	4,	5,	7,	8,	9},
	{0,	2,	2,	3,	4,	5,	7,	9,	8},
	{0,	3,	3,	4,	4,	6,	7,	9,	9},
	{0,	2,	2,	3,	4,	5,	7,	9,	9},
	{0,	3,	2,	4,	4,	6,	7,	8,	10},
	{0,	3,	2,	4,	4,	5,	6,	8,	10},
	{0,	4,	3,	5,	5,	6,	7,	8,	11},
	{0,	3,	3,	5,	4,	6,	7,	8,	10},
	{0,	4,	3,	4,	4,	5,	6,	8,	9},
	{0,	4,	4,	3,	4,	5,	6,	9,	8},
	{0,	4,	5,	4,	4,	6,	7,	8,	9},
	{0,	3,	5,	5,	4,	5,	6,	8,	9},
	{0,	4,	6,	4,	5,	5,	6,	8,	9},
	{0,	4,	5,	5,	5,	6,	6,	8,	10},
	{0,	2,	5,	4,	5,	5,	6,	9,	9},
	{0,	3,	6,	5,	5,	6,	7,	9,	9},
	{0,	3,	6,	5,	5,	5,	6,	8,	8},
	{0,	4,	6,	6,	4,	5,	6,	8,	8},
	{0,	5,	7,	6,	5,	6,	6,	8,	9},
	{0,	4,	7,	6,	6,	6,	6,	9,	8},
	{0,	4,	7,	6,	6,	6,	6,	8,	9},
	{0,	5,	8,	7,	6,	7,	6,	8,	9},
	{0,	4,	7,	6,	6,	7,	6,	8,	9},
	{0,	5,	7,	6,	6,	6,	6,	8,	8},
};

static int rgb_offset_reverse_hmt_single[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{1,	0,	0,	0,	0,	1,	0,	0,	-1,	-2,	1,	-2,	-5,	3,	-8,	-3,	4,	-8,	-3,	3,	-8,	-6,	5,	-12,	-6,	5,	-12},
	{1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	-1,	-5,	3,	-8,	-3,	4,	-8,	-4,	4,	-8,	-6,	5,	-12,	-6,	5,	-12},
	{0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	-2,	-4,	3,	-7,	-4,	3,	-8,	-3,	4,	-10,	-7,	5,	-12,	-7,	5,	-12},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	-2,	0,	-1,	-5,	3,	-6,	-3,	3,	-7,	-3,	4,	-10,	-7,	5,	-12,	-7,	5,	-12},
	{0,	0,	0,	0,	0,	0,	0,	0,	-1,	-1,	0,	-1,	-4,	3,	-6,	-3,	4,	-8,	-2,	2,	-6,	-5,	5,	-11,	-5,	5,	-11},
	{2,	0,	1,	0,	0,	0,	0,	0,	0,	-1,	0,	-2,	-4,	2,	-6,	-4,	3,	-8,	-3,	4,	-8,	-8,	7,	-14,	-8,	7,	-14},
	{1,	0,	0,	1,	0,	1,	0,	0,	0,	-1,	0,	-1,	-4,	3,	-6,	-2,	3,	-6,	-4,	3,	-8,	-6,	7,	-14,	-6,	7,	-14},
	{2,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	-4,	3,	-6,	-4,	3,	-7,	-3,	3,	-8,	-4,	5,	-11,	-4,	5,	-11},
	{1,	0,	1,	1,	0,	0,	0,	0,	0,	-1,	0,	-2,	-2,	2,	-4,	-5,	4,	-9,	-4,	4,	-8,	-2,	5,	-11,	-2,	5,	-11},
	{1,	0,	1,	0,	0,	0,	0,	0,	1,	0,	0,	-1,	-4,	2,	-6,	-4,	3,	-7,	-4,	3,	-8,	-7,	7,	-15,	-7,	7,	-15},
	{1,	0,	1,	0,	0,	1,	0,	0,	0,	0,	0,	-1,	-2,	2,	-4,	-4,	3,	-8,	-4,	3,	-8,	-6,	7,	-14,	-6,	7,	-14},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-4,	2,	-4,	-4,	3,	-7,	-4,	3,	-8,	-5,	7,	-14,	-5,	7,	-14},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3,	2,	-5,	-5,	3,	-8,	-2,	3,	-6,	-4,	5,	-12,	-4,	5,	-12},
	{1,	0,	1,	1,	0,	0,	1,	0,	1,	0,	0,	0,	-3,	2,	-4,	-3,	3,	-7,	-3,	3,	-6,	-6,	7,	-15,	-6,	7,	-15},
	{1,	0,	1,	0,	0,	1,	1,	0,	0,	0,	0,	0,	-3,	2,	-4,	-4,	3,	-7,	-4,	3,	-8,	-5,	6,	-13,	-5,	6,	-13},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	-3,	2,	-4,	-5,	3,	-7,	-4,	3,	-7,	-4,	6,	-13,	-4,	10,	-13},
	{2,	0,	1,	1,	0,	1,	0,	0,	0,	0,	0,	0,	-4,	1,	-4,	-4,	3,	-7,	-4,	3,	-7,	-5,	6,	-13,	0,	10,	0},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-3,	1,	-4,	-3,	2,	-6,	-5,	3,	-8,	-5,	6,	-14,	-4,	5,	-4},
	{1,	0,	2,	0,	0,	0,	1,	0,	0,	0,	0,	0,	-2,	1,	-3,	-4,	2,	-6,	-5,	3,	-8,	-6,	6,	-14,	-4,	5,	-4},
	{2,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	-3,	1,	-3,	-3,	2,	-6,	-5,	3,	-7,	-6,	7,	-16,	-4,	0,	-4},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	1,	-3,	-4,	2,	-6,	-3,	3,	-6,	-6,	7,	-15,	-5,	5,	-5},
	{2,	0,	1,	1,	0,	0,	0,	0,	-1,	0,	0,	0,	-2,	1,	-3,	-3,	3,	-6,	-5,	3,	-6,	-6,	6,	-14,	-5,	5,	-3},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	1,	-2,	-3,	2,	-6,	-6,	3,	-7,	-5,	5,	-12,	3,	15,	2},
	{2,	0,	2,	0,	0,	0,	1,	0,	0,	0,	0,	0,	-2,	1,	-3,	-4,	2,	-6,	-6,	3,	-6,	-5,	6,	-13,	0,	8,	-3},
	{3,	0,	2,	0,	0,	0,	0,	0,	-1,	0,	0,	0,	-2,	1,	-2,	-4,	2,	-5,	-5,	3,	-7,	-5,	6,	-12,	0,	9,	-1},
	{2,	0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	1,	-2,	-1,	2,	-4,	-6,	3,	-7,	-4,	6,	-12,	-3,	9,	-4},
	{2,	0,	2,	0,	0,	1,	1,	0,	0,	0,	0,	-2,	-2,	0,	-2,	-2,	2,	-4,	-5,	3,	-7,	-4,	6,	-14,	-9,	3,	-7},
	{3,	0,	3,	0,	0,	1,	0,	0,	-1,	0,	0,	-1,	-1,	0,	-2,	-3,	2,	-4,	-5,	3,	-7,	-6,	5,	-12,	0,	10,	-2},
	{3,	0,	3,	0,	0,	1,	0,	0,	-1,	-1,	0,	-1,	-1,	0,	-2,	-3,	2,	-5,	-6,	2,	-6,	-6,	6,	-13,	4,	11,	1},
	{3,	0,	2,	0,	0,	1,	0,	0,	0,	0,	0,	-1,	0,	0,	-1,	-2,	2,	-4,	-5,	3,	-6,	-6,	6,	-12,	3,	12,	-1},
	{2,	0,	2,	0,	0,	1,	0,	0,	0,	0,	0,	0,	-1,	1,	-2,	-2,	2,	-4,	-5,	2,	-6,	-7,	5,	-12,	4,	12,	0},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-2,	0,	-2,	-5,	1,	-4,	-4,	3,	-6,	-6,	7,	-14,	4,	6,	-2},
	{3,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-2,	0,	-2,	-3,	1,	-4,	-5,	2,	-6,	-5,	5,	-12,	7,	15,	5},
	{3,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	-2,	-3,	1,	-4,	-4,	2,	-5,	-7,	6,	-13,	1,	10,	1},
	{3,	0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	-1,	-3,	1,	-3,	-4,	2,	-6,	-7,	6,	-13,	3,	10,	0},
	{4,	0,	4,	0,	0,	-1,	0,	0,	0,	0,	0,	-1,	-2,	0,	-2,	-2,	1,	-2,	-5,	2,	-5,	-6,	6,	-12,	4,	11,	0},
	{3,	0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-2,	-3,	1,	-3,	-3,	2,	-4,	-6,	5,	-12,	3,	11,	-1},
};

static unsigned int base_luminance_reverse_hmt_single_revF[][2] = {
	{10,	239075328},
	{11,	255852544},
	{12,	276824064},
	{13,	301989888},
	{14,	322961408},
	{15,	339738624},
	{16,	360710144},
	{17,	385875968},
	{19,	419430400},
	{20,	444596224},
	{21,	457179136},
	{22,	478150656},
	{23,	494927872},
	{25,	528482304},
	{27,	566231040},
	{29,	599785472},
	{31,	637534208},
	{33,	671088640},
	{35,	713031680},
	{37,	746586112},
	{39,	788529152},
	{41,	826277888},
	{44,	876609536},
	{47,	931135488},
	{50,	964689920},
	{53,	1035993088},
	{56,	1086324736},
	{60,	1136656384},
	{64,	1199570944},
	{68,	1262485504},
	{72,	1317011456},
	{77,	1023410176},
	{82,	1082130432},
	{87,	1132462080},
	{93,	1186988032},
	{99,	1241513984},
	{105,	1325400064},
};


static unsigned int base_luminance_reverse_hmt_single_revL[][2] = {
	{10,	230686720},
	{11,	251658240},
	{12,	276824064},
	{13,	293601280},
	{14,	314572800},
	{15,	339738624},
	{16,	360710144},
	{17,	381681664},
	{19,	423624704},
	{20,	440401920},
	{21,	457179136},
	{22,	478150656},
	{23,	503316480},
	{25,	528482304},
	{27,	583008256},
	{29,	616562688},
	{31,	658505728},
	{33,	692060160},
	{35,	729808896},
	{37,	767557632},
	{39,	813694976},
	{41,	847249408},
	{44,	897581056},
	{47,	952107008},
	{50,	1006632960},
	{53,	1056964608},
	{56,	1115684864},
	{60,	1174405120},
	{64,	1237319680},
	{68,	1304428544},
	{72,	1367343104},
	{77,	1056964608},
	{82,	1115684864},
	{87,	1161822208},
	{93,	1220542464},
	{99,	1296039936},
	{105,	1350565888},
};

static int gradation_offset_reverse_hmt_single_revF[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0,	0,	1,	4,	8,	9,	10,	12,	12},
	{0,	0,	1,	3,	6,	8,	10,	12,	12},
	{0,	1,	1,	4,	6,	8,	11,	12,	12},
	{0,	1,	1,	3,	6,	8,	9,	12,	12},
	{0,	1,	1,	3,	6,	8,	10,	12,	13},
	{0,	1,	1,	3,	6,	8,	10,	11,	12},
	{0,	2,	2,	2,	5,	7,	9,	11,	12},
	{0,	2,	1,	2,	5,	7,	9,	11,	12},
	{0,	3,	1,	1,	5,	7,	8,	11,	12},
	{0,	3,	1,	1,	5,	6,	9,	12,	12},
	{0,	1,	0,	2,	5,	7,	9,	11,	12},
	{0,	3,	1,	2,	6,	8,	10,	11,	12},
	{0,	3,	0,	2,	4,	7,	8,	11,	12},
	{0,	3,	1,	3,	5,	8,	9,	10,	13},
	{0,	2,	1,	3,	5,	7,	9,	12,	12},
	{0,	1,	1,	3,	4,	6,	8,	12,	12},
	{0,	1,	1,	3,	5,	7,	9,	12,	12},
	{0,	2,	2,	3,	5,	6,	8,	11,	12},
	{0,	2,	3,	4,	6,	7,	9,	11,	12},
	{0,	2,	2,	4,	5,	7,	8,	11,	12},
	{0,	2,	1,	4,	5,	6,	8,	11,	12},
	{0,	2,	1,	4,	5,	7,	9,	11,	13},
	{0,	2,	1,	3,	5,	6,	8,	10,	12},
	{0,	2,	1,	4,	5,	6,	8,	11,	12},
	{0,	2,	1,	4,	5,	7,	8,	11,	12},
	{0,	2,	1,	3,	5,	6,	8,	11,	12},
	{0,	2,	2,	5,	5,	6,	8,	10,	12},
	{0,	1,	3,	4,	5,	7,	8,	10,	12},
	{0,	1,	3,	5,	5,	7,	8,	10,	12},
	{0,	2,	5,	6,	6,	7,	9,	11,	11},
	{0,	3,	5,	6,	7,	8,	9,	11,	11},
	{0,	-1,	0,	2,	3,	3,	5,	8,	8},
	{0,	-1,	0,	3,	3,	3,	5,	7,	8},
	{0,	0,	1,	3,	3,	4,	5,	7,	8},
	{0,	1,	1,	3,	3,	3,	4,	7,	8},
	{0,	-1,	2,	4,	3,	3,	5,	8,	8},
	{0,	1,	2,	4,	4,	4,	6,	8,	8},
};

static int gradation_offset_reverse_hmt_single_revL[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0,	-1,	0,	4,	6,	7,	9,	11,	12},
	{0,	-2,	1,	4,	6,	8,	9,	11,	12},
	{0,	-2,	1,	4,	6,	7,	10,	11,	12},
	{0,	-2,	0,	4,	6,	8,	9,	11,	12},
	{0,	-2,	1,	3,	6,	7,	9,	11,	12},
	{0,	-2,	1,	4,	6,	8,	9,	11,	12},
	{0,	-2,	1,	3,	5,	7,	8,	11,	12},
	{0,	-2,	0,	3,	6,	7,	9,	11,	12},
	{0,	-1,	-1,	2,	5,	7,	8,	11,	12},
	{0,	-1,	0,	3,	6,	8,	8,	11,	12},
	{0,	-1,	-1,	3,	5,	7,	8,	11,	12},
	{0,	0,	0,	3,	5,	7,	9,	11,	12},
	{0,	0,	0,	3,	5,	7,	8,	11,	12},
	{0,	1,	0,	3,	5,	7,	8,	11,	12},
	{0,	0,	0,	3,	5,	7,	7,	11,	12},
	{0,	-1,	0,	4,	5,	7,	8,	11,	12},
	{0,	0,	1,	4,	5,	7,	7,	10,	12},
	{0,	0,	1,	4,	5,	6,	7,	10,	12},
	{0,	0,	2,	4,	6,	6,	8,	10,	12},
	{0,	-1,	2,	5,	6,	7,	7,	10,	12},
	{0,	-2,	1,	4,	5,	6,	8,	11,	13},
	{0,	-1,	2,	4,	5,	7,	8,	11,	13},
	{0,	-1,	3,	4,	5,	6,	7,	10,	12},
	{0,	-1,	2,	5,	6,	6,	8,	10,	12},
	{0,	-1,	4,	5,	6,	7,	7,	10,	12},
	{0,	-1,	3,	4,	5,	6,	8,	10,	12},
	{0,	-1,	3,	5,	5,	6,	7,	10,	12},
	{0,	0,	4,	5,	5,	7,	8,	10,	12},
	{0,	0,	4,	5,	5,	7,	7,	10,	12},
	{0,	0,	4,	5,	5,	7,	8,	10,	11},
	{0,	0,	4,	5,	6,	6,	7,	9,	11},
	{0,	-3,	2,	3,	3,	4,	4,	7,	8},
	{0,	-2,	2,	4,	3,	4,	4,	6,	8},
	{0,	-1,	3,	4,	3,	4,	4,	6,	8},
	{0,	-1,	3,	4,	3,	4,	4,	6,	8},
	{0,	1,	4,	4,	4,	4,	5,	7,	8},
	{0,	0,	4,	4,	4,	5,	4,	7,	8},
};


static int rgb_offset_reverse_hmt_single_revF[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{0, 0,	-1, 0,	0,	0,	0,	0,	-1, -4, 2,	-6, -2, 4,	-10,	-2, 5,	-11,	1,	5,	-12,	9,	2,	-6, 13, 4,	8},
	{1, 0,	0,	0,	0,	0,	-2, 0,	-1, -3, 2,	-5, -3, 5,	-11,	-1, 4,	-9, 2,	5,	-10,	9,	2,	-10,	13, 4,	6},
	{1, 0,	1,	0,	0,	0,	-2, 0,	-1, -4, 2,	-5, -4, 5,	-10,	-1, 4,	-10,	0,	5,	-10,	9,	2,	-10,	13, 4,	6},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-3, 2,	-4, -3, 4,	-10,	-1, 5,	-10,	2,	5,	-12,	7,	2,	-10,	11, 4,	8},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-3, 1,	-4, -4, 4,	-10,	-2, 4,	-9, 1,	5,	-10,	7,	6,	-11,	7,	1,	1},
	{1, 0,	0,	0,	0,	0,	-2, 0,	-2, -3, 1,	-4, -2, 4,	-9, -2, 4,	-9, 1,	4,	-10,	7,	6,	-12,	6,	1,	0},
	{1, 0,	0,	0,	0,	0,	0,	0,	0,	-4, 1,	-4, -3, 4,	-9, -1, 4,	-9, 0,	4,	-10,	5,	6,	-12,	5,	1,	0},
	{1, 0,	0,	0,	0,	0,	0,	0,	-1, -4, 1,	-3, -1, 4,	-8, -2, 4,	-10,	1,	5,	-10,	5,	7,	-14,	10, 1,	3},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-3, 1,	-3, -3, 3,	-8, -1, 4,	-8, 1,	5,	-10,	5,	7,	-14,	10, 1,	0},
	{2, 0,	1,	0,	0,	0,	0,	0,	-1, -3, 1,	-2, -4, 3,	-8, -1, 4,	-8, 0,	4,	-9, 3,	6,	-14,	9,	3,	0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-4, 1,	-3, -2, 3,	-7, -2, 4,	-8, 1,	5,	-10,	5,	6,	-13,	6,	3,	0},
	{2, 0,	1,	0,	0,	0,	-1, 0,	0,	-2, 1,	-4, -4, 3,	-7, -2, 3,	-8, 0,	5,	-10,	5,	6,	-13,	6,	3,	0},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 1,	-2, -4, 3,	-8, -2, 3,	-7, 0,	6,	-12,	5,	6,	-13,	5,	1,	0},
	{1, 0,	0,	0,	0,	1,	-1, 0,	0,	-1, 1,	-2, -4, 3,	-7, -2, 3,	-7, 0,	5,	-11,	5,	7,	-14,	5,	2,	-2},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-2, 1,	-3, -3, 3,	-6, -2, 3,	-7, 0,	5,	-11,	3,	6,	-14,	4,	1,	-2},
	{3, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 1,	-2, -4, 3,	-6, -2, 3,	-8, -1, 5,	-12,	3,	6,	-14,	4,	1,	-2},
	{2, 0,	2,	0,	0,	0,	-1, 0,	0,	-3, 0,	-2, -2, 3,	-6, -2, 3,	-8, -1, 5,	-11,	3,	6,	-14,	4,	1,	-2},
	{1, 0,	1,	0,	0,	1,	0,	0,	0,	-1, 1,	-2, -3, 2,	-6, -2, 3,	-8, 0,	5,	-10,	2,	6,	-15,	6,	3,	-2},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -3, 2,	-6, -2, 3,	-6, 0,	5,	-10,	2,	6,	-15,	4,	4,	-5},
	{2, 0,	2,	0,	0,	0,	-1, 0,	0,	-1, 0,	-1, -3, 2,	-6, -3, 2,	-6, -1, 5,	-11,	2,	6,	-15,	6,	6,	-5},
	{3, 0,	3,	0,	0,	0,	-1, 0,	0,	-2, 0,	-2, -3, 2,	-5, -1, 3,	-6, -1, 5,	-10,	2,	6,	-15,	4,	2,	-5},
	{3, 0,	3,	0,	0,	0,	0,	0,	-2, -2, 0,	-1, -3, 2,	-5, -3, 3,	-7, 0,	4,	-9, 1,	7,	-14,	1,	0,	-7},
	{3, 0,	2,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -3, 2,	-4, -2, 3,	-7, 0,	4,	-8, 1,	8,	-17,	1,	0,	-8},
	{4, 0,	3,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -3, 1,	-4, -2, 3,	-7, -1, 4,	-10,	0,	6,	-15,	3,	2,	-6},
	{4, 0,	4,	0,	0,	0,	0,	0,	0,	-3, 0,	-2, -3, 1,	-4, -2, 2,	-6, -2, 4,	-10,	1,	7,	-16,	4,	3,	-6},
	{5, 0,	4,	0,	0,	0,	0,	0,	-1, -2, 0,	-1, -4, 1,	-4, -2, 2,	-6, -2, 4,	-10,	1,	7,	-16,	4,	3,	-6},
	{4, 0,	3,	0,	0,	0,	0,	0,	-1, -2, 0,	-1, -3, 1,	-4, -2, 3,	-6, -1, 4,	-8, 0,	7,	-16,	2,	2,	-6},
	{4, 0,	4,	0,	0,	0,	0,	0,	-1, -2, 0,	-1, -1, 1,	-2, -3, 2,	-6, -2, 4,	-10,	1,	8,	-16,	3,	3,	-6},
	{4, 0,	4,	1,	0,	0,	-1, 0,	-1, 0,	0,	-1, -2, 1,	-2, -3, 2,	-6, -2, 4,	-8, 0,	8,	-18,	5,	3,	-3},
	{4, -1, 4,	-1, 0,	-1, -1, 0,	-1, -1, 0,	-1, -2, 1,	-2, -3, 2,	-6, -1, 4,	-8, 0,	8,	-16,	5,	3,	-3},
	{4, -1, 4,	0,	0,	-1, -1, 0,	-1, -2, 0,	-1, -2, 1,	-2, -2, 2,	-6, -2, 4,	-9, 0,	8,	-16,	5,	3,	-3},
	{4, 0,	4,	0,	0,	0,	-1, 0,	0,	0,	0,	-1, -1, 1,	-2, -1, 2,	-4, -2, 3,	-8, 2,	6,	-12,	5,	3,	-5},
	{4, -1, 4,	0,	0,	0,	0,	0,	0,	0,	0,	-1, -2, 1,	-3, -2, 1,	-4, 0,	3,	-7, 1,	7,	-15,	5,	3,	-5},
	{4, 0,	4,	0,	0,	0,	0,	0,	0,	-2, 0,	-2, -1, 1,	-2, -2, 1,	-4, -1, 3,	-7, 1,	7,	-14,	6,	4,	-5},
	{4, 0,	4,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-2, -3, 1,	-4, -2, 3,	-7, 2,	7,	-14,	6,	4,	-5},
	{5, 0,	4,	0,	0,	0,	-2, 0,	-1, 0,	0,	0,	-1, 0,	-2, -3, 1,	-4, 0,	3,	-6, 0,	6,	-13,	2,	0,	-6},
	{4, -1, 4,	0,	0,	0,	-2, 0,	-1, 0,	0,	0,	-1, 1,	-2, -3, 1,	-4, -1, 3,	-6, 0,	6,	-14,	4,	1,	-6},
};

static int rgb_offset_reverse_hmt_single_revL[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	-2,	3,	-6,	-8,	6,	-12,	-7,	6,	-14,	-3,	6,	-12,	-9,	6,	-21,	6,	-12,	1},
	{0,	0,	0,	0,	0,	0,	-2,	0,	-2,	-5,	2,	-6,	-6,	6,	-12,	-6,	6,	-13,	-4,	7,	-15,	-7,	8,	-21,	10,	-8,	1},
	{0,	0,	0,	0,	0,	-1,	-2,	0,	-1,	-4,	2,	-5,	-6,	6,	-12,	-7,	6,	-14,	-5,	4,	-10,	-5,	10,	-21,	12,	-6,	-2},
	{0,	0,	0,	0,	0,	0,	-2,	0,	-1,	-3,	2,	-4,	-7,	5,	-12,	-6,	6,	-12,	-5,	5,	-12,	-5,	10,	-21,	12,	-6,	-2},
	{0,	0,	1,	0,	0,	0,	0,	0,	-1,	-3,	2,	-4,	-6,	5,	-11,	-7,	6,	-13,	-4,	5,	-12,	-11,	9,	-19,	2,	0,	-2},
	{0,	0,	0,	0,	0,	0,	-1,	0,	-1,	-4,	2,	-5,	-5,	5,	-11,	-6,	5,	-12,	-5,	6,	-14,	-15,	5,	-22,	0,	0,	-4},
	{0,	0,	1,	0,	0,	0,	-1,	0,	-1,	-3,	2,	-4,	-6,	5,	-11,	-6,	5,	-12,	-5,	6,	-14,	-15,	5,	-22,	0,	0,	-4},
	{0,	0,	1,	0,	0,	0,	-1,	0,	-1,	-3,	1,	-4,	-6,	4,	-10,	-6,	6,	-12,	-7,	5,	-12,	-15,	7,	-22,	2,	2,	-4},
	{0,	0,	2,	1,	0,	0,	0,	0,	-2,	-3,	1,	-3,	-6,	4,	-10,	-6,	5,	-12,	-7,	6,	-14,	-15,	7,	-22,	2,	2,	-4},
	{0,	0,	1,	0,	0,	0,	0,	0,	-1,	-3,	1,	-4,	-5,	4,	-9,	-7,	5,	-11,	-5,	6,	-14,	-17,	5,	-23,	2,	3,	-4},
	{1,	0,	2,	0,	0,	0,	-1,	0,	-1,	-3,	1,	-4,	-6,	4,	-9,	-6,	5,	-11,	-5,	7,	-14,	-17,	5,	-23,	1,	2,	-5},
	{1,	0,	2,	0,	0,	0,	-1,	0,	-1,	-2,	1,	-3,	-4,	3,	-8,	-7,	5,	-11,	-7,	5,	-12,	-18,	4,	-24,	6,	8,	-1},
	{0,	0,	1,	0,	0,	0,	0,	0,	0,	-2,	1,	-3,	-3,	3,	-7,	-6,	5,	-11,	-8,	6,	-13,	-18,	4,	-24,	6,	8,	-1},
	{0,	0,	2,	0,	0,	0,	0,	0,	-1,	-1,	1,	-3,	-3,	3,	-6,	-7,	5,	-11,	-7,	6,	-13,	-17,	5,	-23,	6,	8,	-1},
	{1,	0,	2,	0,	0,	0,	-1,	0,	-1,	-2,	1,	-2,	-3,	3,	-6,	-6,	4,	-10,	-8,	7,	-14,	-16,	6,	-22,	-6,	0,	-9},
	{1,	0,	2,	0,	0,	0,	0,	0,	0,	-2,	1,	-3,	-3,	2,	-6,	-6,	4,	-9,	-7,	6,	-12,	-14,	8,	-20,	-6,	1,	-9},
	{1,	0,	2,	0,	0,	0,	0,	0,	-1,	-1,	1,	-2,	-4,	2,	-6,	-7,	4,	-10,	-7,	6,	-13,	-14,	8,	-20,	-4,	1,	-7},
	{1,	0,	3,	0,	0,	0,	0,	0,	0,	-1,	0,	-2,	-3,	2,	-6,	-6,	4,	-10,	-7,	6,	-13,	-14,	8,	-21,	-4,	1,	-8},
	{1,	0,	2,	0,	0,	0,	0,	0,	-1,	-1,	1,	-2,	-3,	2,	-5,	-5,	4,	-9,	-7,	5,	-12,	-14,	8,	-22,	-5,	0,	-8},
	{1,	0,	3,	0,	0,	0,	-1,	0,	-1,	-1,	0,	-2,	-3,	2,	-5,	-5,	4,	-8,	-7,	6,	-13,	-14,	8,	-23,	-4,	2,	-8},
	{2,	0,	3,	0,	0,	0,	-1,	0,	-1,	0,	0,	-1,	-4,	2,	-6,	-5,	3,	-8,	-7,	5,	-10,	-18,	5,	-25,	-4,	0,	-10},
	{3,	0,	3,	0,	0,	0,	0,	0,	0,	-2,	0,	-2,	-3,	2,	-5,	-6,	4,	-8,	-5,	5,	-11,	-17,	6,	-24,	-4,	0,	-10},
	{3,	0,	4,	1,	0,	0,	-1,	0,	-1,	-1,	0,	-1,	-3,	2,	-5,	-6,	4,	-8,	-6,	5,	-10,	-17,	7,	-24,	-7,	-1,	-13},
	{3,	0,	4,	1,	0,	0,	-2,	0,	-1,	-2,	0,	-2,	-3,	1,	-4,	-5,	4,	-8,	-6,	5,	-11,	-16,	7,	-23,	-6,	-1,	-13},
	{3,	0,	4,	0,	0,	0,	-1,	0,	0,	-1,	0,	-1,	-3,	2,	-4,	-5,	3,	-8,	-5,	5,	-11,	-16,	7,	-22,	-6,	-1,	-12},
	{3,	0,	4,	0,	0,	0,	0,	0,	0,	-2,	0,	-2,	-1,	1,	-3,	-5,	3,	-8,	-6,	4,	-10,	-16,	8,	-21,	-6,	3,	-11},
	{4,	0,	4,	0,	0,	0,	0,	0,	0,	-2,	0,	-2,	-2,	1,	-4,	-5,	3,	-8,	-6,	5,	-10,	-16,	5,	-21,	-5,	5,	-11},
	{2,	0,	3,	1,	0,	0,	0,	0,	0,	-1,	0,	-1,	-3,	1,	-4,	-4,	3,	-6,	-6,	4,	-10,	-16,	5,	-21,	-5,	6,	-11},
	{3,	0,	4,	0,	0,	0,	0,	0,	0,	-2,	0,	-1,	-2,	1,	-4,	-5,	3,	-6,	-4,	4,	-9,	-15,	5,	-20,	-5,	6,	-10},
	{3,	0,	4,	0,	0,	0,	0,	0,	-1,	-1,	0,	0,	-1,	1,	-3,	-4,	2,	-6,	-5,	4,	-9,	-15,	5,	-20,	-5,	6,	-10},
	{3,	0,	4,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-2,	1,	-3,	-3,	3,	-6,	-5,	4,	-8,	-13,	5,	-20,	-5,	6,	-10},
	{3,	0,	3,	0,	0,	0,	0,	0,	0,	-1,	0,	0,	-3,	1,	-3,	-2,	2,	-4,	-5,	4,	-7,	-8,	4,	-19,	-5,	4,	-9},
	{3,	0,	3,	0,	0,	0,	-1,	0,	0,	0,	0,	-1,	-2,	1,	-3,	-3,	2,	-5,	-6,	3,	-8,	-6,	6,	-18,	-3,	4,	-9},
	{3,	0,	4,	1,	0,	0,	0,	0,	0,	-1,	0,	-1,	-1,	1,	-2,	-3,	2,	-5,	-6,	3,	-8,	-6,	5,	-18,	-4,	4,	-11},
	{2,	0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	1,	-2,	-2,	2,	-5,	-4,	3,	-7,	-7,	7,	-16,	-4,	4,	-12},
	{2,	0,	3,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	0,	-2,	-2,	2,	-5,	-4,	3,	-6,	-9,	4,	-18,	-7,	0,	-15},
	{3,	0,	4,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	-1,	0,	-1,	-2,	1,	-4,	-4,	2,	-5,	-9,	7,	-16,	-7,	-1,	-15},
};

static unsigned int base_luminance_reverse_hmt_single_revM[][2] = {
	{10,	239075328},
	{11,	260046848},
	{12,	276824064},
	{13,	301989888},
	{14,	322961408},
	{15,	343932928},
	{16,	360710144},
	{17,	377487360},
	{19,	411041792},
	{20,	432013312},
	{21,	457179136},
	{22,	499122176},
	{23,	515899392},
	{25,	553648128},
	{27,	595591168},
	{29,	633339904},
	{31,	675282944},
	{33,	704643072},
	{35,	742391808},
	{37,	775946240},
	{39,	817889280},
	{41,	843055104},
	{44,	897581056},
	{47,	952107008},
	{50,	1010827264},
	{53,	1061158912},
	{56,	1098907648},
	{60,	1157627904},
	{64,	1220542464},
	{68,	1279262720},
	{72,	1321205760},
	{77,	1019215872},
	{82,	1073741824},
	{87,	1119879168},
	{93,	1191182336},
	{99,	1241513984},
	{105,	1304428544},
};

static int gradation_offset_reverse_hmt_single_revM[][9] = {
	{0, 2,	3,	4,	7,	9,	10, 12, 12},
	{0, 0,	3,	5,	7,	9,	11, 12, 12},
	{0, 0,	3,	5,	7,	9,	11, 12, 12},
	{0, 0,	2,	5,	7,	9,	10, 12, 12},
	{0, 1,	3,	5,	7,	9,	10, 12, 12},
	{0, 1,	2,	5,	7,	9,	10, 12, 12},
	{0, 2,	3,	5,	6,	8,	10, 12, 12},
	{0, 3,	3,	4,	7,	9,	10, 12, 12},
	{0, 3,	3,	4,	7,	8,	9,	12, 12},
	{0, 3,	2,	4,	7,	9,	9,	12, 12},
	{0, 2,	2,	4,	6,	8,	9,	12, 12},
	{0, 3,	1,	3,	5,	8,	9,	12, 12},
	{0, 2,	1,	3,	6,	8,	9,	12, 12},
	{0, 3,	2,	3,	6,	7,	9,	12, 12},
	{0, 3,	3,	5,	7,	9,	9,	12, 12},
	{0, 3,	2,	4,	6,	8,	9,	12, 12},
	{0, 4,	4,	4,	6,	8,	9,	12, 12},
	{0, 4,	4,	4,	6,	8,	8,	12, 12},
	{0, 4,	5,	5,	6,	7,	9,	12, 12},
	{0, 5,	6,	6,	7,	8,	9,	12, 12},
	{0, 5,	5,	5,	6,	7,	9,	12, 12},
	{0, 2,	6,	5,	6,	8,	9,	12, 12},
	{0, 3,	6,	6,	6,	8,	8,	11, 12},
	{0, 4,	6,	7,	6,	8,	9,	11, 12},
	{0, 3,	7,	7,	6,	9,	9,	11, 12},
	{0, 5,	8,	6,	6,	8,	9,	11, 12},
	{0, 4,	8,	7,	6,	8,	8,	11, 12},
	{0, 5,	9,	7,	6,	9,	9,	11, 12},
	{0, 6,	9,	8,	6,	8,	8,	11, 12},
	{0, 8,	10, 8,	7,	9,	9,	11, 11},
	{0, 9,	10, 8,	8,	9,	10, 11, 11},
	{0, 4,	7,	5,	5,	4,	5,	8,	9},
	{0, 4,	7,	6,	5,	5,	6,	8,	9},
	{0, 5,	8,	6,	5,	5,	5,	7,	9},
	{0, 5,	8,	6,	5,	5,	6,	7,	9},
	{0, 7,	8,	6,	5,	5,	5,	8,	10},
	{0, 6,	9,	6,	5,	5,	6,	8,	9},
};
static int rgb_offset_reverse_hmt_single_revM[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{1,	0,	0,	0,	0,	0,	0,	0,	-1,	-2,	2,	-6,	-7,	4,	-10,	-6,	4,	-8,	-4,	5,	-12,	-4,	8,	-6,	6,	5,	4},
	{1,	0,	0,	0,	0,	0,	0,	0,	-1,	-1,	2,	-5,	-6,	4,	-9,	-7,	4,	-9,	-2,	4,	-8,	-4,	10,	-5,	6,	5,	4},
	{1,	0,	0,	0,	0,	0,	0,	0,	0,	-2,	2,	-5,	-5,	4,	-8,	-7,	3,	-8,	-3,	4,	-10,	-2,	11,	-4,	6,	5,	4},
	{0,	0,	0,	1,	0,	0,	-1,	0,	-2,	-2,	1,	-4,	-5,	3,	-8,	-8,	4,	-10,	-3,	5,	-10,	-2,	13,	-4,	6,	5,	6},
	{1,	0,	0,	0,	0,	-1,	0,	0,	0,	-2,	2,	-4,	-4,	4,	-8,	-6,	3,	-8,	-4,	5,	-12,	-3,	13,	-5,	7,	6,	6},
	{1,	0,	0,	0,	0,	0,	0,	0,	-2,	-2,	1,	-3,	-4,	4,	-8,	-7,	3,	-8,	-3,	4,	-8,	-4,	8,	-9,	5,	6,	4},
	{0,	0,	0,	0,	0,	0,	1,	0,	0,	-2,	2,	-4,	-4,	3,	-8,	-7,	4,	-8,	-3,	3,	-8,	-4,	8,	-9,	5,	6,	4},
	{0,	0,	0,	0,	0,	1,	1,	0,	0,	-2,	1,	-4,	-5,	3,	-8,	-5,	3,	-8,	-5,	4,	-10,	-4,	8,	-9,	4,	5,	4},
	{1,	0,	0,	0,	0,	0,	0,	0,	0,	-3,	1,	-4,	-3,	3,	-7,	-7,	4,	-8,	-4,	4,	-10,	-2,	11,	-7,	4,	6,	3},
	{1,	0,	0,	0,	0,	0,	0,	0,	-1,	-1,	1,	-2,	-4,	3,	-6,	-6,	3,	-8,	-4,	5,	-11,	-4,	8,	-9,	6,	7,	5},
	{2,	0,	1,	0,	0,	0,	0,	0,	0,	0,	1,	-2,	-3,	3,	-6,	-6,	3,	-8,	-5,	5,	-11,	-6,	8,	-11,	6,	7,	5},
	{1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	-2,	-5,	3,	-8,	-7,	3,	-7,	-4,	4,	-10,	-8,	4,	-13,	9,	11,	7},
	{1,	0,	1,	0,	0,	0,	1,	0,	0,	-1,	1,	-3,	-4,	3,	-6,	-6,	3,	-7,	-5,	4,	-10,	-8,	5,	-14,	9,	11,	6},
	{1,	0,	1,	0,	0,	0,	1,	0,	-1,	-1,	1,	-2,	-3,	3,	-6,	-5,	3,	-7,	-4,	4,	-9,	-8,	5,	-14,	8,	11,	6},
	{1,	0,	0,	0,	0,	0,	0,	0,	-2,	-2,	0,	-2,	-4,	3,	-6,	-6,	3,	-7,	-4,	5,	-10,	-8,	8,	-14,	5,	6,	4},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	1,	-2,	-3,	2,	-6,	-6,	3,	-7,	-5,	5,	-10,	-8,	8,	-14,	4,	6,	2},
	{1,	0,	0,	0,	0,	0,	0,	0,	-1,	-1,	0,	-2,	-5,	2,	-6,	-4,	3,	-6,	-5,	4,	-10,	-8,	2,	-14,	7,	11,	5},
	{1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	1,	-2,	-3,	2,	-5,	-5,	3,	-7,	-6,	4,	-10,	-8,	3,	-14,	6,	11,	5},
	{1,	0,	1,	1,	0,	0,	0,	0,	0,	-1,	0,	-2,	-3,	2,	-5,	-5,	3,	-6,	-4,	4,	-9,	-8,	5,	-14,	6,	11,	4},
	{1,	0,	1,	0,	0,	0,	0,	0,	-1,	-1,	0,	-2,	-4,	2,	-5,	-4,	3,	-6,	-4,	4,	-8,	-8,	4,	-14,	6,	11,	4},
	{2,	0,	1,	1,	0,	1,	0,	0,	0,	0,	1,	-2,	-3,	2,	-4,	-5,	2,	-6,	-4,	4,	-9,	-8,	4,	-14,	6,	11,	4},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	-1,	-3,	2,	-5,	-6,	3,	-8,	-4,	4,	-8,	-8,	7,	-14,	5,	11,	4},
	{2,	0,	2,	1,	0,	0,	0,	0,	0,	-1,	1,	-2,	-1,	1,	-4,	-4,	3,	-6,	-6,	4,	-10,	-6,	6,	-12,	0,	6,	-2},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	-1,	0,	-1,	-2,	2,	-4,	-4,	3,	-6,	-4,	4,	-8,	-7,	9,	-12,	2,	5,	-1},
	{1,	0,	2,	1,	0,	0,	0,	0,	-1,	0,	0,	-1,	-3,	2,	-4,	-4,	3,	-6,	-4,	4,	-8,	-7,	9,	-12,	2,	5,	0},
	{2,	0,	3,	0,	0,	-1,	0,	0,	-1,	-1,	0,	-1,	-3,	1,	-4,	-4,	2,	-6,	-5,	4,	-8,	-5,	9,	-14,	4,	6,	1},
	{2,	0,	3,	0,	0,	0,	0,	0,	-1,	-1,	0,	-1,	-1,	1,	-3,	-5,	3,	-6,	-4,	4,	-8,	-9,	5,	-10,	4,	9,	1},
	{3,	0,	3,	0,	0,	0,	0,	0,	0,	-1,	0,	-2,	-2,	1,	-3,	-4,	3,	-6,	-4,	4,	-8,	-8,	6,	-14,	4,	10,	2},
	{3,	0,	3,	0,	0,	0,	0,	0,	-1,	0,	0,	-1,	-1,	1,	-2,	-4,	2,	-6,	-6,	4,	-9,	-6,	7,	-11,	3,	10,	0},
	{2,	0,	2,	0,	0,	0,	0,	0,	-1,	0,	0,	-1,	-3,	1,	-4,	-3,	2,	-5,	-5,	4,	-8,	-6,	7,	-11,	3,	10,	0},
	{3,	0,	3,	0,	0,	0,	0,	0,	-1,	0,	0,	0,	-2,	1,	-3,	-4,	2,	-5,	-4,	3,	-8,	-6,	9,	-11,	2,	9,	0},
	{1,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	-2,	-3,	2,	-4,	-3,	3,	-6,	-5,	5,	-12,	-1,	3,	-4},
	{2,	0,	3,	1,	0,	0,	0,	0,	-1,	0,	0,	0,	-1,	1,	-2,	-2,	2,	-4,	-3,	3,	-6,	-5,	6,	-14,	-1,	2,	-4},
	{1,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	-2,	-3,	1,	-4,	-2,	4,	-6,	-5,	6,	-14,	-1,	2,	-4},
	{2,	0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	-2,	-2,	2,	-4,	-2,	4,	-5,	-3,	7,	-12,	-1,	3,	-5},
	{2,	0,	2,	1,	0,	0,	1,	0,	0,	0,	0,	0,	0,	1,	-2,	-4,	2,	-2,	-3,	5,	-5,	-7,	3,	-12,	-3,	1,	-10},
	{2,	0,	3,	0,	0,	0,	1,	0,	0,	0,	0,	-1,	0,	0,	-1,	-4,	1,	-2,	-4,	3,	-4,	-6,	5,	-10,	-2,	2,	-9},
};

#endif
