/*
 * =================================================================
 *
 *       Filename:  smart_mtp_s6e3.h
 *
 *    Description:  Smart dimming algorithm implementation
 *
 *        Company:  Samsung Electronics
 *
 * ================================================================
 */
/*
<one line to give the program's name and a brief idea of what it does.>
Copyright (C) 2012, Samsung Electronics. All rights reserved.

*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
*/
#ifndef _SS_DSI_SMART_DIMMING_S6E3HF4_AMB509ME01_H_
#define _SS_DSI_SMART_DIMMING_S6E3HF4_AMB509ME01_H_

#include "../ss_dsi_panel_common.h"
#include "../ss_dsi_smart_dimming_common.h"

static int id1, id2, id3;

#define LUMINANCE_MAX 74
#define HMT_LUMINANCE_MAX 37
#define GAMMA_SET_MAX 35
#define GRAY_SCALE_MAX 256
#define RGB_COMPENSATION 27

/* BIT_SHIFT is used for right bit shfit */
#define BIT_SHIFT 22
#define BIT_SHFIT_MUL 4194304 // pow(2,BIT_SHIFT)

/* 6.5*4194304 */
#define VREG0_REF_6P5 27262976
/* 6.4*4194304 */
#define VREG0_REF_6P4 26843546
/* 6.3*4194304 */
#define VREG0_REF_6P3 26424115
/* 6.2*4194304 */
#define VREG0_REF_6P2 26004685

enum {
	GAMMA_CURVE_1P9 = 0,
	GAMMA_CURVE_2P15,
	GAMMA_CURVE_2P2,
};

/* TP */
enum {
	VT = 0,
	V1 = 1,
	V7 = 2,
	V11 = 3,
	V23 = 4,
	V35 = 5,
	V51 = 6,
	V87 = 7,
	V151 = 8,
	V203 = 9,
	V255 = 10,
	V_MAX,
};

/* RGB */
enum {
	R = 0,
	G = 1,
	B = 2,
	RGB_MAX,
};

static char V_LIST[V_MAX][5] = {
	"VT",
	"V1",
	"V7",
	"V11",
	"V23",
	"V35",
	"V51",
	"V87",
	"V151",
	"V203",
	"V255",
};

struct illuminance_table {
	int lux;
	char gamma_setting[GAMMA_SET_MAX];
} __packed;

struct SMART_DIM {
	/* read C8h 1st ~ 35th */
	char MTP_ORIGN[GAMMA_SET_MAX];

	/* copy MTP_ORIGN -> MTP */
	int MTP[V_MAX][RGB_MAX];

	/* TP's gamma voltage */
	int RGB_OUTPUT[V_MAX][RGB_MAX];

	/* GRAY (0~255) */
	int GRAY[GRAY_SCALE_MAX][RGB_MAX];

	/* Because of AID funtion, below members are added*/
	int lux_table_max;
	int *plux_table;
	struct illuminance_table gen_table[LUMINANCE_MAX];

	int brightness_level;
	int ldi_revision;
	int vregout_voltage;

	/* HBM interpolation */
	struct illuminance_table hbm_interpolation_table[HBM_INTERPOLATION_STEP+1];
	char *hbm_payload;
	int hbm_brightness_level;

	struct illuminance_table hmt_gen_table[HMT_LUMINANCE_MAX];
} __packed;

/* V0,V1,V7,V11,V23,V35,V51,V87,V151,V203,V255 */
static int INFLECTION_VOLTAGE_ARRAY[V_MAX] = {0, 1, 7, 11, 23, 35, 51, 87, 151, 203, 255};

static int vt_coefficient[] = {
   	  0,  12,  24,  36,
	 48,  60,  72,  84,
	 96, 108, 138, 148,
	158, 168, 178, 186,
};

// center (max) gamma value (Hex)
static int center_gamma[V_MAX][RGB_MAX] = {
	{0x0, 0x0, 0x0},		/* VT */
 	{0x80, 0x80, 0x80},		/* V1 */
 	{0x80, 0x80, 0x80},		/* V7 */
 	{0x80, 0x80, 0x80},		/* V11 */
 	{0x80, 0x80, 0x80},		/* V23 */
 	{0x80, 0x80, 0x80},		/* V35 */
 	{0x80, 0x80, 0x80},		/* V51 */
 	{0x80, 0x80, 0x80},		/* V87 */
 	{0x80, 0x80, 0x80},		/* V151 */
 	{0x80, 0x80, 0x80},		/* V203 */
	{0x100, 0x100, 0x100},	/* V255 */
};

/* fraction for gamma code */
static int fraction[V_MAX][2] = {
/* {numerator, denominator} */
	{0,  860},		/* VT */
	{0,  256},		/* V1 */
	{64, 320},		/* V7 */
	{64, 320},		/* V11 */
	{64, 320},		/* V23 */
	{64, 320},		/* V35 */
	{64, 320},		/* V51 */
	{64, 320},		/* V87 */
	{64, 320},		/* V151 */
	{64, 320},		/* V203 */
	{72, 860},		/* V255 */
};

/* 443 is made but not used */
static int hbm_interpolation_candela_table[HBM_INTERPOLATION_STEP] = {443, 465, 488, 510, 533, 555, 578, 600};

/* HERO2 revA */
static unsigned int base_luminance_poseidon_revA[LUMINANCE_MAX][2] = {
	{2, 122},
	{3, 122},
	{4, 122},
	{5, 122},
	{6, 122},
	{7, 122},
	{8, 122},
	{9, 122},
	{10,	122},
	{11,	122},
	{12,	122},
	{13,	122},
	{14,	122},
	{15,	122},
	{16,	122},
	{17,	122},
	{19,	122},
	{20,	122},
	{21,	122},
	{22,	122},
	{24,	122},
	{25,	122},
	{27,	122},
	{29,	122},
	{30,	122},
	{32,	122},
	{34,	122},
	{37,	122},
	{39,	122},
	{41,	122},
	{44,	122},
	{47,	122},
	{50,	122},
	{53,	122},
	{56,	122},
	{60,	122},
	{64,	122},
	{68,	125},
	{72,	131},
	{77,	139},
	{82,	148},
	{87,	157},
	{93,	167},
	{98,	176},
	{105,	186},
	{111,	197},
	{119,	209},
	{126,	222},
	{134,	235},
	{143,	245},
	{152,	262},
	{162,	275},
	{172,	285},
	{183,	300},
	{195,	300},
	{207,	300},
	{220,	300},
	{234,	300},
	{249,	310},
	{265,	324},
	{282,	340},
	{300,	355},
	{316,	368},
	{333,	387},
	{350,	393},
	{357,	396},
	{365,	408},
	{372,	408},
	{380,	408},
	{387,	408},
	{395,	408},
	{403,	411},
	{412,	415},
	{420,	420},
};

static int gradation_offset_poseidon_revA[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{3, 8,	9,	11, 13, 15, 18, 21, 16},
	{2, 7,	9,	11, 13, 15, 18, 21, 17},
	{2, 7,	9,	11, 13, 15, 18, 21, 16},
	{1, 6,	9,	13, 15, 17, 20, 23, 18},
	{1, 6,	8,	11, 13, 15, 18, 21, 16},
	{2, 7,	9,	11, 13, 15, 19, 22, 17},
	{1, 5,	6,	9,	11, 13, 16, 20, 15},
	{1, 6,	7,	9,	11, 13, 16, 19, 15},
	{0, 5,	5,	8,	11, 13, 16, 19, 14},
	{0, 4,	5,	7,	9,	11, 15, 19, 14},
	{0, 4,	4,	7,	9,	11, 14, 18, 12},
	{0, 4,	4,	6,	8,	10, 13, 17, 10},
	{0, 4,	4,	5,	8,	10, 13, 17, 10},
	{0, 3,	3,	5,	7,	9,	12, 16, 8},
	{0, 3,	3,	5,	7,	9,	12, 16, 7},
	{0, 3,	3,	4,	6,	8,	11, 15, 6},
	{0, 4,	3,	4,	6,	8,	10, 14, 6},
	{0, 3,	3,	3,	5,	7,	9,	13, 14},
	{0, 4,	3,	3,	5,	7,	9,	13, 14},
	{0, 4,	3,	3,	5,	7,	9,	13, 14},
	{0, 4,	2,	3,	4,	6,	8,	12, 14},
	{0, 4,	3,	3,	4,	5,	7,	11, 12},
	{0, 4,	2,	2,	4,	5,	7,	11, 12},
	{0, 3,	2,	2,	4,	5,	7,	11, 13},
	{0, 4,	2,	2,	3,	4,	6,	10, 11},
	{0, 3,	2,	1,	3,	4,	6,	9,	11},
	{0, 3,	2,	1,	3,	4,	6,	9,	11},
	{0, 3,	2,	1,	3,	4,	6,	9,	11},
	{0, 3,	2,	1,	2,	3,	5,	8,	10},
	{0, 2,	2,	1,	2,	3,	5,	8,	10},
	{0, 3,	1,	1,	2,	2,	4,	7,	9},
	{0, 3,	1,	1,	2,	2,	4,	7,	8},
	{0, 3,	1,	0,	2,	2,	4,	6,	8},
	{0, 2,	0,	0,	1,	1,	3,	5,	7},
	{0, 3,	0,	0,	1,	1,	2,	4,	6},
	{0, 2,	0,	0,	1,	1,	2,	4,	6},
	{0, 2,	0,	0,	1,	1,	2,	4,	5},
	{0, 2,	1,	1,	2,	2,	3,	5,	7},
	{0, 2,	1,	1,	1,	1,	3,	5,	6},
	{0, 3,	1,	0,	1,	1,	2,	4,	5},
	{0, 3,	2,	2,	1,	1,	3,	5,	6},
	{0, 2,	2,	1,	1,	2,	2,	4,	5},
	{0, 3,	3,	2,	1,	2,	3,	4,	5},
	{0, 2,	2,	2,	1,	2,	3,	4,	6},
	{0, 1,	3,	1,	0,	2,	2,	4,	5},
	{0, 0,	3,	2,	1,	1,	2,	4,	5},
	{0, 0,	3,	2,	0,	1,	2,	3,	4},
	{0, 0,	3,	2,	0,	2,	2,	3,	4},
	{0, 1,	3,	2,	0,	1,	2,	4,	5},
	{0, 1,	2,	2,	1,	1,	2,	4,	5},
	{0, 1,	4,	2,	0,	0,	1,	2,	4},
	{0, 1,	3,	2,	0,	1,	1,	2,	4},
	{0, 2,	3,	2,	1,	0,	1,	2,	4},
	{0, 1,	2,	2,	2,	2,	1,	3,	5},
	{0, 1,	3,	1,	1,	1,	1,	3,	4},
	{0, 1,	2,	2,	1,	1,	1,	2,	4},
	{0, 1,	2,	1,	1,	1,	1,	2,	3},
	{0, 1,	2,	1,	1,	1,	1,	2,	3},
	{0, 0,	2,	1,	1,	0,	1,	2,	2},
	{0, 0,	1,	1,	0,	0,	0,	2,	1},
	{0, 2,	1,	0,	0,	0,	0,	0,	0},
	{0, 2,	0,	0,	0,	0,	1,	1,	1},
	{0, 1,	0,	0,	0,	0,	0,	0,	0},
	{0, 1,	1,	1,	0,	0,	0,	1,	1},
	{1, 0,	0,	0,	0,	0,	0,	1,	1},
	{0, 0,	0,	0,	0,	0,	0,	1,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	1,	0,	0,	0,	0,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_poseidon_revA[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-3,	0,	-3, -2, 0,	-2, -2, 0,	-1, -7, 1,	-4, -7, 2,	-8, -8, 2,	-10,	-5, 3,	-7, -9, 4,	-8, -13,	5,	-18},
	{-2,	0,	-2, -2, 0,	-2, -2, 0,	-1, -7, 1,	-4, -7, 2,	-8, -8, 2,	-10,	-5, 3,	-7, -9, 4,	-8, -17,	1,	-23},
	{-2,	0,	-2, -2, 0,	-2, -2, 0,	-1, -7, 1,	-4, -7, 2,	-8, -8, 2,	-10,	-5, 3,	-7, -9, 4,	-8, -13,	5,	-18},
	{-1,	1,	-1, -2, 0,	-2, -3, -1, -2, -9, -2, -7, -8, 0,	-10,	-8, 1,	-11,	-8, 1,	-10,	-9, 3,	-8, -16,	3,	-21},
	{-1,	1,	-1, -2, 0,	-2, -2, 0,	-1, -8, 0,	-5, -7, 2,	-8, -8, 2,	-10,	-5, 3,	-7, -9, 4,	-8, -13,	5,	-18},
	{-2,	0,	-2, -2, 0,	-2, -2, 0,	-1, -7, 1,	-4, -7, 2,	-8, -8, 2,	-10,	-9, 0,	-11,	-9, 4,	-8, -14,	4,	-20},
	{-1,	1,	-1, -1, 1,	-1, -1, 1,	0,	-7, 1,	-4, -6, 3,	-7, -7, 3,	-9, -4, 4,	-6, -12,	0,	-11,	-11,	6,	-17},
	{-1,	0,	-1, -2, 0,	-1, -1, 0,	-1, -6, 1,	-4, -7, 2,	-7, -7, 0,	-10,	-5, 3,	-8, -8, 4,	-8, -14,	3,	-20},
	{0, 0,	-1, -2, 0,	-1, -1, 0,	-1, -6, 0,	-3, -8, 0,	-9, -6, 1,	-10,	-6, 2,	-10,	-7, 4,	-8, -13,	3,	-19},
	{0, 0,	0,	-1, 0,	-1, -1, 0,	-1, -5, 1,	-2, -6, 2,	-8, -5, 2,	-10,	-9, -1, -12,	-10,	0,	-12,	-17,	0,	-22},
	{0, 0,	0,	-1, 0,	-1, 0,	0,	0,	-6, 0,	-3, -6, 2,	-8, -5, 1,	-10,	-6, 2,	-10,	-9, 0,	-12,	-13,	2,	-19},
	{1, 0,	1,	-1, 0,	-1, -1, 0,	-1, -4, 0,	-1, -5, 2,	-7, -3, 2,	-8, -7, 3,	-10,	-9, 1,	-13,	-10,	4,	-16},
	{1, 0,	1,	-1, 0,	-1, 0,	0,	0,	-3, 1,	-1, -8, 0,	-10,	-4, 2,	-8, -6, 2,	-10,	-9, 1,	-14,	-13,	0,	-19},
	{1, 0,	1,	0,	0,	0,	-1, 0,	-1, -3, 1,	-1, -7, 0,	-7, -3, 2,	-7, -6, 1,	-12,	-9, 1,	-15,	-9, 1,	-16},
	{1, 0,	1,	0,	0,	0,	-1, 0,	-1, -4, 0,	-1, -6, 1,	-7, -5, 1,	-8, -7, 1,	-12,	-10,	0,	-17,	-7, 2,	-15},
	{2, 0,	1,	-1, 0,	0,	0,	0,	0,	-3, 0,	-2, -6, 1,	-7, -3, 2,	-6, -8, 0,	-14,	-8, 1,	-16,	-6, -1, -14},
	{2, 0,	2,	-1, 0,	-1, 0,	0,	0,	-3, 0,	-1, -6, 0,	-8, -5, 1,	-7, -4, 3,	-10,	-7, 1,	-16,	-6, -2, -13},
	{2, 0,	1,	-1, 0,	0,	0,	0,	0,	-2, 1,	0,	-5, 1,	-6, -3, 1,	-5, -6, 2,	-12,	-10,	4,	-11,	-16,	4,	-21},
	{1, -1, 1,	-1, 0,	-1, 0,	0,	0,	-2, 1,	1,	-5, 1,	-7, -4, 0,	-5, -5, 2,	-12,	-10,	4,	-12,	-18,	1,	-23},
	{1, -1, 0,	-1, 0,	0,	0,	0,	0,	-1, 1,	1,	-6, 0,	-7, -4, 0,	-6, -6, 1,	-12,	-10,	4,	-13,	-15,	4,	-19},
	{1, -1, 1,	-1, 0,	-1, 1,	0,	1,	-3, 0,	-1, -3, 2,	-4, -5, 0,	-5, -5, 2,	-12,	-11,	2,	-14,	-16,	2,	-20},
	{1, -1, 0,	-1, 0,	0,	0,	0,	0,	-2, 0,	0,	-3, 2,	-4, -2, 3,	-2, -3, 3,	-11,	-11,	2,	-15,	-14,	3,	-18},
	{1, -1, 1,	-1, 0,	-1, 1,	0,	1,	-2, 0,	0,	-4, 1,	-5, -2, 2,	-2, -5, 2,	-13,	-11,	2,	-16,	-11,	5,	-15},
	{1, -1, 1,	0,	0,	0,	0,	0,	0,	-2, 0,	0,	-4, 0,	-5, -3, 1,	-4, -5, 2,	-12,	-12,	1,	-18,	-13,	2,	-17},
	{1, -1, 1,	-1, 0,	-1, 1,	0,	1,	-2, 0,	0,	-2, 2,	-3, -2, 2,	-2, -4, 4,	-9, -12,	1,	-20,	-10,	4,	-14},
	{1, -1, 1,	0,	0,	0,	0,	0,	0,	0,	1,	2,	-4, 0,	-5, -1, 2,	-2, -6, 3,	-10,	-6, 5,	-15,	-12,	1,	-16},
	{1, -1, 1,	0,	0,	0,	0,	0,	0,	0,	1,	2,	-4, 0,	-5, -3, 1,	-3, -6, 1,	-10,	-6, 5,	-16,	-9, 3,	-13},
	{1, -1, 1,	0,	0,	0,	0,	0,	0,	0,	1,	2,	-4, -1, -5, -3, 0,	-3, -7, 1,	-11,	-8, 2,	-19,	-11,	0,	-15},
	{1, -1, 1,	0,	0,	0,	0,	0,	0,	0,	1,	2,	-1, 2,	-1, -3, 0,	-4, -7, 1,	-10,	-7, 3,	-18,	-8, 2,	-12},
	{1, -1, 1,	0,	0,	0,	0,	0,	0,	0,	1,	2,	-2, 1,	-2, -3, 0,	-3, -6, 0,	-9, -8, 3,	-19,	-10,	-1, -14},
	{1, -1, 1,	0,	0,	0,	1,	0,	1,	-1, 0,	1,	-2, 2,	-2, 1,	3,	1,	-6, 1,	-9, -8, 1,	-20,	-7, 1,	-10},
	{1, -1, 1,	0,	0,	0,	1,	0,	1,	-1, 0,	1,	-2, 1,	-2, 1,	3,	0,	-7, 0,	-9, -9, 1,	-21,	-4, 3,	-7},
	{1, -1, 1,	0,	0,	0,	1,	0,	1,	-1, 0,	1,	-2, 0,	-3, -1, 1,	-1, -5, 0,	-8, -4, 5,	-17,	-6, 1,	-9},
	{1, -1, 1,	0,	0,	0,	1,	0,	1,	-1, 0,	1,	0,	1,	-1, 2,	3,	2,	-5, 0,	-8, -5, 5,	-17,	-8, -2, -12},
	{1, -1, 1,	0,	0,	0,	1,	0,	1,	-1, 0,	1,	0,	1,	-1, 3,	3,	2,	-1, 4,	-3, -6, 5,	-18,	-1, 1,	-6},
	{1, -1, 1,	0,	0,	0,	1,	0,	1,	-1, -1, 1,	1,	2,	-1, 0,	1,	1,	0,	4,	-3, -8, 4,	-18,	0,	1,	-7},
	{1, -1, 1,	0,	0,	0,	1,	0,	1,	-1, -1, 1,	0,	1,	-1, 1,	1,	1,	-1, 4,	-3, -10,	2,	-19,	7,	4,	-1},
	{1, -1, 1,	0,	0,	1,	1,	0,	0,	0,	0,	2,	-2, 0,	-2, -1, -1, -1, -2, 2,	-4, -10,	2,	-20,	-4, 0,	-10},
	{2, -1, 1,	1,	0,	1,	0,	0,	0,	0,	0,	1,	0,	0,	-1, -1, 0,	-1, -2, 1,	-4, -13,	0,	-14,	-10,	6,	-16},
	{2, 0,	2,	0,	0,	0,	0,	0,	1,	1,	1,	2,	-1, 0,	-3, 1,	2,	2,	-3, 0,	-5, -7, 4,	-10,	-8, 1,	-13},
	{2, -1, 2,	-1, 0,	0,	1,	0,	1,	0,	0,	1,	-2, 0,	-2, 2,	2,	2,	-4, -1, -7, -9, 1,	-13,	-9, 2,	-13},
	{2, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	2,	-1, -1, -3, 0,	1,	1,	0,	1,	-3, -10,	1,	-11,	-10,	2,	-15},
	{2, -1, 1,	0,	0,	0,	0,	0,	1,	0,	0,	1,	0,	0,	-1, -1, -1, -1, -2, 1,	-4, -6, 3,	-8, -6, 5,	-12},
	{2, -1, 1,	0,	0,	1,	1,	0,	1,	-1, 0,	1,	0,	-1, -2, -1, -1, -1, -1, 3,	-1, -5, 3,	-8, -13,	1,	-18},
	{2, 0,	2,	0,	0,	1,	1,	0,	0,	0,	0,	2,	0,	1,	-1, -1, -1, -1, -1, 2,	-2, -6, 1,	-10,	-5, 4,	-12},
	{2, 0,	1,	0,	0,	1,	0,	0,	0,	0,	0,	2,	1,	1,	0,	1,	0,	1,	0,	2,	-2, -7, 1,	-11,	-2, 6,	-9},
	{2, 0,	1,	1,	0,	1,	0,	0,	1,	0,	0,	1,	0,	1,	0,	0,	0,	0,	-2, 0,	-3, -2, 4,	-5, -10,	-1, -12},
	{1, 0,	1,	1,	0,	2,	0,	0,	0,	0,	0,	1,	1,	1,	0,	-1, -1, -1, 1,	3,	0,	-3, 2,	-7, -6, 2,	-9},
	{2, 0,	1,	0,	0,	1,	1,	0,	1,	0,	1,	1,	1,	1,	0,	0,	-1, 0,	-4, -2, -5, -5, 1,	-9, -7, 4,	-11},
	{2, -1, 1,	0,	0,	2,	1,	0,	0,	-1, 0,	0,	1,	1,	1,	-1, -1, -1, -2, 0,	-3, -7, 0,	-11,	-9, 1,	-14},
	{1, -1, 0,	0,	0,	1,	1,	0,	1,	1,	0,	2,	1,	1,	1,	1,	1,	2,	-2, 0,	-3, -1, 4,	-5, -10,	-1, -16},
	{1, 0,	0,	0,	0,	1,	0,	0,	0,	0,	0,	2,	2,	1,	0,	0,	0,	1,	1,	2,	1,	-3, 3,	-7, -8, 2,	-13},
	{2, 0,	1,	0,	0,	1,	0,	0,	0,	-1, 0,	1,	1,	1,	1,	2,	2,	2,	1,	3,	1,	-5, 2,	-9, -10,	-1, -15},
	{3, 0,	2,	0,	0,	1,	1,	0,	0,	-1, 0,	1,	-1, 0,	-1, 1,	0,	0,	2,	4,	2,	-8, 1,	-10,	-11,	0,	-16},
	{2, -1, 1,	0,	0,	1,	0,	0,	0,	1,	1,	2,	0,	0,	1,	0,	-1, -1, -1, 1,	-1, -10,	0,	-11,	-4, 3,	-11},
	{2, -1, 1,	0,	0,	1,	1,	0,	0,	-1, 0,	0,	0,	1,	1,	1,	0,	0,	-1, 1,	-1, -6, 4,	-7, -7, 1,	-12},
	{2, -1, 1,	0,	0,	1,	0,	0,	0,	1,	0,	0,	0,	0,	1,	1,	0,	0,	-1, 0,	-1, -7, 4,	-7, -1, 3,	-7},
	{1, -1, 0,	0,	0,	1,	1,	0,	0,	1,	0,	1,	0,	0,	1,	0,	-1, -1, 0,	1,	-1, -9, 3,	-8, -3, 0,	-10},
	{1, -1, 0,	0,	0,	1,	-1, 0,	0,	0,	0,	0,	0,	0,	0,	2,	2,	1,	-1, 0,	-1, -10,	1,	-9, 3,	-1, -3},
	{0, -1, 0,	0,	0,	1,	1,	0,	1,	-1, 0,	1,	1,	0,	0,	-1, -2, -2, 1,	2,	1,	-12,	-1, -10,	10, 2,	3},
	{0, -1, -1, 0,	0,	0,	1,	0,	1,	0,	1,	1,	-1, -1, 0,	1,	1,	0,	2,	2,	2,	-5, 2,	-2, 9,	2,	2},
	{0, -1, 0,	-1, 0,	-1, 1,	0,	2,	0,	0,	0,	1,	1,	0,	0,	-2, -1, -2, -1, -2, -7, 1,	-3, 7,	4,	1},
	{-1,	-1, -1, 0,	0,	1,	0,	0,	1,	0,	0,	0,	-1, -1, -1, 3,	2,	2,	-2, -1, -1, -3, 4,	1,	7,	2,	1},
	{-1,	-2, -1, -1, 0,	-1, 1,	0,	2,	-1, 0,	-1, 0,	-1, 0,	0,	0,	-1, 1,	1,	2,	-7, -1, -3, 0,	-1, -6},
	{0, 0,	1,	0,	0,	0,	0,	-1, 0,	-1, 0,	1,	-1, -1, -1, -2, -3, -3, 0,	0,	0,	-3, -2, -3, -2, 2,	-1},
	{1, 0,	1,	-1, 0,	0,	1,	0,	1,	-2, -1, -2, -1, -1, 0,	-1, -2, -2, 0,	0,	0,	-4, -2, -3, -6, -1, -4},
	{0, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, -1, 0,	-1, -1, -2, 1,	1,	2,	-4, -2, -2, 2,	3,	3},
	{0, 0,	0,	0,	0,	0,	-1, -1, 0,	0,	0,	0,	0,	0,	0,	-1, -1, -1, 1,	1,	1,	-4, -1, -2, -6, 0,	-3},
	{0, 0,	1,	-1, 0,	-1, 0,	-1, 0,	-1, 0,	0,	0,	-1, 0,	-1, -1, -2, 0,	0,	1,	-4, -3, -3, -7, -2, -6},
	{0, 0,	0,	-1, 0,	0,	0,	-1, 0,	-1, 0,	-1, 0,	-1, 0,	-1, -1, -1, 1,	1,	1,	-4, -3, -2, -5, 1,	-3},
	{0, 0,	1,	-1, 0,	-1, 0,	-1, 0,	0,	0,	0,	-1, 0,	0,	0,	-1, -1, 1,	1,	1,	-3, -3, -2, -7, -2, -6},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};

/* HERO2 revC */
static unsigned int base_luminance_poseidon_revC[LUMINANCE_MAX][2] = {
	{2, 118},
	{3, 118},
	{4, 118},
	{5, 118},
	{6, 118},
	{7, 118},
	{8, 118},
	{9, 118},
	{10,	118},
	{11,	118},
	{12,	118},
	{13,	118},
	{14,	118},
	{15,	118},
	{16,	118},
	{17,	118},
	{19,	118},
	{20,	118},
	{21,	118},
	{22,	118},
	{24,	118},
	{25,	118},
	{27,	118},
	{29,	118},
	{30,	118},
	{32,	118},
	{34,	118},
	{37,	118},
	{39,	118},
	{41,	118},
	{44,	118},
	{47,	118},
	{50,	118},
	{53,	118},
	{56,	118},
	{60,	118},
	{64,	118},
	{68,	123},
	{72,	131},
	{77,	138},
	{82,	148},
	{87,	155},
	{93,	166},
	{98,	174},
	{105,	185},
	{111,	197},
	{119,	208},
	{126,	219},
	{134,	231},
	{143,	243},
	{152,	256},
	{162,	268},
	{172,	279},
	{183,	298},
	{195,	298},
	{207,	298},
	{220,	298},
	{234,	298},
	{249,	306},
	{265,	320},
	{282,	334},
	{300,	352},
	{316,	364},
	{333,	380},
	{350,	397},
	{357,	401},
	{365,	412},
	{372,	412},
	{380,	412},
	{387,	412},
	{395,	412},
	{403,	413},
	{412,	416},
	{420,	420},
};

static int gradation_offset_poseidon_revC[LUMINANCE_MAX][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 8,	14, 22, 28, 31, 25, 22, 16},
	{0, 7,	12, 19, 23, 26, 29, 21, 17},
	{0, 7,	11, 17, 20, 23, 27, 21, 18},
	{0, 6,	10, 17, 19, 23, 26, 22, 18},
	{0, 6,	10, 15, 18, 21, 25, 28, 22},
	{0, 6,	9,	14, 16, 18, 21, 25, 18},
	{0, 4,	7,	13, 15, 18, 21, 22, 19},
	{0, 4,	6,	12, 14, 16, 19, 22, 21},
	{0, 4,	6,	11, 13, 15, 19, 23, 20},
	{0, 4,	5,	10, 12, 14, 17, 20, 16},
	{0, 4,	5,	10, 12, 14, 17, 21, 18},
	{0, 4,	5,	9,	11, 13, 16, 20, 22},
	{0, 3,	4,	9,	11, 13, 16, 20, 20},
	{0, 4,	5,	8,	10, 11, 14, 18, 19},
	{0, 4,	4,	8,	10, 11, 14, 18, 20},
	{0, 4,	4,	7,	9,	11, 14, 18, 20},
	{0, 4,	4,	7,	8,	9,	12, 16, 18},
	{0, 4,	4,	6,	7,	9,	11, 15, 17},
	{0, 3,	4,	6,	7,	8,	10, 14, 16},
	{0, 3,	3,	6,	7,	8,	10, 14, 16},
	{0, 3,	3,	6,	6,	7,	9,	13, 15},
	{0, 4,	3,	6,	6,	7,	9,	13, 15},
	{0, 3,	3,	5,	5,	6,	8,	12, 14},
	{0, 3,	3,	4,	5,	6,	8,	12, 14},
	{0, 3,	2,	5,	5,	6,	8,	12, 14},
	{0, 3,	2,	5,	5,	5,	7,	11, 13},
	{0, 3,	2,	4,	4,	5,	7,	11, 13},
	{0, 2,	2,	3,	3,	4,	6,	9,	11},
	{0, 2,	1,	3,	3,	3,	5,	8,	10},
	{0, 2,	1,	3,	3,	3,	5,	8,	10},
	{0, 2,	1,	3,	3,	3,	5,	8,	10},
	{0, 3,	1,	3,	3,	3,	5,	8,	10},
	{0, 2,	1,	3,	3,	3,	4,	7,	9},
	{0, 1,	0,	2,	2,	2,	3,	6,	8},
	{0, 1,	0,	1,	2,	2,	4,	6,	8},
	{0, 1,	0,	1,	1,	1,	3,	5,	7},
	{0, 2,	0,	1,	1,	1,	2,	4,	6},
	{0, 3,	2,	2,	2,	1,	2,	4,	6},
	{0, 3,	2,	3,	2,	1,	3,	5,	7},
	{0, 3,	4,	2,	2,	2,	3,	5,	6},
	{0, 3,	3,	3,	2,	2,	3,	5,	6},
	{0, 2,	2,	3,	2,	2,	3,	5,	6},
	{0, 2,	2,	3,	1,	1,	2,	4,	6},
	{0, 3,	5,	4,	3,	2,	3,	5,	7},
	{0, 3,	4,	4,	3,	3,	3,	5,	7},
	{0, 0,	3,	3,	2,	2,	3,	5,	7},
	{0, 2,	5,	4,	3,	2,	2,	4,	6},
	{0, 2,	4,	4,	3,	2,	2,	4,	5},
	{0, 2,	4,	4,	3,	2,	2,	4,	5},
	{0, 2,	3,	3,	3,	2,	2,	4,	5},
	{0, 2,	5,	4,	3,	2,	2,	4,	5},
	{0, 2,	4,	3,	2,	2,	2,	3,	5},
	{0, 3,	5,	4,	2,	2,	2,	3,	5},
	{0, 2,	5,	4,	2,	2,	1,	3,	5},
	{0, 3,	5,	5,	3,	2,	1,	2,	4},
	{0, 0,	5,	4,	3,	2,	1,	2,	4},
	{0, 3,	4,	4,	2,	2,	1,	2,	4},
	{0, 0,	4,	3,	2,	1,	1,	2,	4},
	{0, 0,	3,	2,	1,	0,	0,	1,	2},
	{0, 1,	2,	1,	0,	0,	0,	1,	1},
	{0, 1,	2,	1,	0,	0,	0,	0,	1},
	{0, 1,	2,	0,	0,	0,	0,	0,	1},
	{0, 1,	1,	0,	0,	0,	0,	0,	1},
	{0, 1,	1,	0,	0,	0,	0,	0,	0},
	{0, 1,	1,	0,	0,	0,	0,	0,	1},
	{0, 1,	1,	0,	0,	0,	0,	0,	1},
	{0, 1,	1,	0,	0,	0,	0,	0,	0},
	{0, 1,	2,	1,	0,	0,	0,	0,	0},
	{0, 1,	1,	1,	0,	0,	0,	0,	0},
	{0, 1,	1,	1,	0,	0,	0,	0,	0},
	{0, 0,	1,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0},
};

static int rgb_offset_poseidon_revC[LUMINANCE_MAX][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{-7,	3,	-5, -4, 0,	-3, -5, 0,	-5, -13,	0,	-8, -15,	1,	-12,	-7, 0,	-9, -4, 1,	-3, -11,	-1, -1, -4, -1, -17},
	{-5,	2,	-4, -3, 0,	-2, -4, 0,	-5, -10,	1,	-7, -12,	0,	-12,	-7, 1,	-8, -4, 1,	-9, -11,	1,	1,	-4, 1,	-17},
	{-4,	1,	-3, -3, 0,	-3, -4, 0,	-4, -9, 0,	-7, -14,	1,	-11,	-8, 2,	-8, -9, 0,	-12,	-18,	0,	5,	-4, 1,	-16},
	{-3,	1,	-3, -3, 0,	-3, -3, 0,	-4, -9, 0,	-8, -12,	0,	-11,	-11,	0,	-10,	-9, 1,	-12,	-21,	3,	3,	-9, 1,	-19},
	{-2,	1,	-2, -2, 0,	-2, -3, 0,	-4, -8, 0,	-7, -12,	0,	-12,	-7, 1,	-9, -11,	0,	-13,	-31,	0,	-16,	-9, 1,	-18},
	{-1,	1,	-1, -3, 0,	-3, -2, 0,	-3, -6, 1,	-5, -10,	1,	-10,	-6, 2,	-8, -9, 2,	-12,	-26,	2,	-13,	-8, 3,	-17},
	{0, 1,	0,	-2, 0,	-2, -2, 0,	-3, -8, 0,	-7, -8, 1,	-9, -8, 0,	-11,	-9, 1,	-12,	-34,	-1, -15,	-13,	0,	-20},
	{0, 1,	0,	-1, 0,	-1, -2, 0,	-3, -6, 0,	-6, -8, 0,	-8, -5, 1,	-10,	-9, 1,	-12,	-11,	-1, -15,	-9, 0,	-19},
	{0, 0,	0,	-1, 0,	-1, -2, 0,	-3, -6, 0,	-5, -7, 0,	-10,	-6, 0,	-10,	-12,	0,	-13,	-11,	0,	-16,	-64,	0,	10},
	{0, 0,	0,	-1, 0,	-1, -1, 0,	-2, -5, 0,	-5, -7, 1,	-8, -6, 0,	-11,	-7, 3,	-11,	-11,	2,	-16,	-60,	3,	16},
	{0, 0,	1,	0,	0,	-1, -1, 0,	-2, -5, 0,	-5, -7, 0,	-9, -7, 0,	-11,	-7, 2,	-11,	-12,	2,	-17,	-64,	2,	12},
	{1, 0,	1,	-1, 0,	-1, -1, 0,	-2, -4, 0,	-4, -7, 1,	-8, -5, 0,	-10,	-9, 2,	-12,	-12,	0,	-19,	-22,	0,	-3},
	{1, 0,	2,	-1, 0,	-1, -1, 0,	-2, -5, 0,	-5, -7, 0,	-8, -6, 0,	-11,	-8, 1,	-13,	-12,	0,	-19,	-11,	1,	-2},
	{0, 0,	1,	0,	0,	-1, -1, 0,	-2, -4, 1,	-4, -6, 1,	-7, -3, 2,	-7, -8, 2,	-13,	-15,	0,	-20,	-11,	2,	-2},
	{0, 0,	1,	0,	0,	-1, 0,	0,	-1, -5, 0,	-5, -6, 1,	-7, -4, 1,	-8, -7, 0,	-14,	-17,	0,	-22,	-11,	1,	-3},
	{0, 0,	1,	0,	0,	-1, 0,	0,	-1, -4, 0,	-3, -5, 0,	-8, -7, 0,	-9, -9, 0,	-15,	-17,	0,	-21,	-14,	0,	-6},
	{1, 0,	1,	-1, 0,	-1, 0,	0,	-1, -3, 0,	-3, -4, 2,	-6, -4, 2,	-6, -10,	0,	-15,	-12,	-1, -20,	-16,	3,	-4},
	{1, 0,	2,	-1, 0,	-2, 0,	0,	-1, -3, 1,	-2, -4, 1,	-6, -5, 0,	-7, -6, 2,	-13,	-14,	0,	-21,	-10,	3,	-4},
	{1, -1, 1,	-1, 0,	0,	-1, 0,	-2, -2, 1,	-2, -4, 1,	-6, -3, 2,	-4, -7, 1,	-14,	-12,	0,	-19,	-8, 2,	-4},
	{1, -1, 1,	-1, 0,	0,	0,	0,	-1, -4, 0,	-3, -3, 1,	-6, -4, 1,	-5, -7, 2,	-13,	-13,	0,	-20,	-8, 1,	-4},
	{0, -1, 1,	0,	0,	0,	0,	0,	-1, -4, 0,	-3, -3, 2,	-5, -2, 1,	-4, -9, 1,	-14,	-11,	1,	-20,	-7, 2,	-4},
	{1, -1, 2,	-1, 0,	-2, 1,	0,	0,	-4, 0,	-3, -2, 2,	-4, -3, 1,	-4, -9, 0,	-15,	-12,	0,	-21,	-4, 1,	-5},
	{1, -1, 2,	-1, 0,	-1, 0,	0,	-1, -2, 0,	-1, -2, 2,	-4, -3, 1,	-4, -7, 2,	-12,	-11,	0,	-21,	-5, 1,	-5},
	{1, -1, 2,	-1, 0,	-1, 0,	0,	-1, -2, 1,	-1, -3, 0,	-5, -2, 1,	-3, -8, 0,	-13,	-13,	0,	-23,	-7, 2,	-5},
	{1, -1, 1,	-1, 0,	0,	0,	0,	-1, -3, 0,	-2, -2, 1,	-4, -3, 1,	-4, -8, 0,	-13,	-12,	-1, -22,	-4, 0,	-6},
	{1, -1, 2,	-1, 0,	-1, 0,	0,	0,	-2, 0,	-2, -3, 1,	-5, -1, 2,	-2, -7, 2,	-10,	-12,	-1, -23,	-8, 2,	-6},
	{1, -1, 1,	-1, 0,	0,	0,	0,	0,	-2, 0,	-2, -1, 1,	-3, -3, 1,	-3, -8, 0,	-12,	-14,	-1, -24,	-8, 2,	-6},
	{1, -1, 2,	-1, 0,	0,	0,	0,	-1, 0,	0,	0,	0,	2,	-2, -3, 1,	-3, -6, 0,	-10,	-10,	3,	-19,	-6, 2,	-6},
	{1, -1, 1,	-1, 0,	0,	1,	0,	0,	-1, 1,	0,	0,	2,	-2, -1, 2,	-1, -4, 2,	-8, -9, 3,	-20,	-5, 1,	-7},
	{1, -1, 2,	-1, 0,	-1, 1,	0,	0,	-1, 1,	0,	0,	1,	-2, -1, 2,	-1, -5, 1,	-8, -9, 3,	-21,	-6, 2,	-7},
	{1, -1, 1,	-1, 0,	0,	1,	0,	1,	-1, 1,	-1, 0,	1,	-2, -1, 1,	-1, -6, 0,	-9, -10,	2,	-22,	-7, 2,	-8},
	{1, -1, 1,	-1, 0,	1,	1,	0,	-1, -1, 0,	0,	0,	1,	-2, -2, 0,	-2, -6, 0,	-9, -11,	1,	-23,	-6, 2,	-8},
	{1, -1, 1,	0,	0,	1,	0,	0,	-1, -1, 0,	0,	-1, 0,	-3, -1, 1,	-1, -2, 3,	-4, -12,	0,	-24,	-6, 1,	-9},
	{2, 0,	3,	0,	0,	0,	0,	0,	1,	-1, 0,	-1, 2,	2,	0,	-2, 0,	-2, -1, 3,	-3, -13,	0,	-23,	-7, 1,	-9},
	{2, 0,	3,	1,	1,	1,	0,	0,	1,	-1, 0,	-1, 0,	0,	-2, -2, -1, -2, -6, -1, -7, -8, 4,	-19,	-7, 2,	-8},
	{2, -1, 3,	0,	0,	0,	0,	0,	1,	0,	0,	0,	2,	2,	0,	-1, 1,	0,	-6, -1, -8, -8, 2,	-20,	-9, 2,	-9},
	{1, -1, 2,	0,	0,	0,	1,	0,	2,	-1, 0,	-1, 2,	2,	0,	0,	1,	1,	-1, 3,	-3, -9, 4,	-18,	-5, 2,	-7},
	{1, -1, 2,	-1, 0,	-1, 1,	0,	1,	-1, 0,	-1, 3,	2,	1,	3,	3,	3,	-1, 2,	-3, -10,	2,	-21,	-5, 2,	-7},
	{1, -1, 0,	-1, 0,	0,	1,	0,	0,	-1, 0,	0,	2,	1,	0,	1,	2,	2,	-2, 1,	-3, -12,	0,	-22,	-6, 0,	-10},
	{1, -1, 1,	0,	0,	0,	0,	0,	1,	-1, 0,	0,	0,	0,	-1, 1,	1,	1,	-4, 0,	-5, -8, 4,	-17,	-7, 1,	-9},
	{1, -1, 1,	-1, 0,	-1, 0,	0,	0,	1,	1,	2,	0,	0,	-2, -1, 0,	0,	0,	2,	-2, -9, 3,	-17,	-9, 1,	-11},
	{0, -1, 1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	1,	1,	-1, 2,	2,	3,	-1, 2,	-2, -9, 2,	-17,	-7, 0,	-11},
	{1, 0,	2,	0,	0,	-1, 1,	0,	0,	0,	0,	1,	1,	1,	0,	3,	2,	3,	0,	2,	-2, -11,	-1, -19,	-9, 0,	-12},
	{0, -1, 0,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	2,	2,	1,	1,	0,	1,	-1, 2,	-2, -12,	0,	-19,	-8, -1, -12},
	{1, -2, 1,	-1, 0,	-1, 0,	0,	1,	1,	1,	1,	0,	0,	-1, 0,	0,	0,	-3, 0,	-4, -8, 3,	-15,	-9, 0,	-12},
	{1, -1, 1,	0,	0,	0,	0,	0,	0,	0,	0,	1,	2,	1,	0,	-1, 0,	0,	-2, 0,	-4, -9, 2,	-15,	-9, -1, -13},
	{2, -1, 1,	-1, 0,	1,	0,	0,	-1, 0,	0,	0,	2,	1,	0,	1,	0,	0,	1,	3,	0,	-11,	0,	-16,	-4, 3,	-9},
	{1, -1, 1,	-1, 0,	-1, 0,	0,	0,	1,	1,	2,	0,	0,	-1, 3,	2,	2,	1,	3,	0,	-12,	-1, -17,	-5, 3,	-9},
	{2, -1, 2,	-1, 0,	0,	0,	0,	0,	-1, 0,	0,	1,	1,	1,	3,	2,	2,	-2, 0,	-3, -6, 3,	-11,	-5, 2,	-10},
	{2, -1, 0,	-1, 0,	1,	0,	0,	0,	0,	0,	1,	1,	0,	-1, 1,	0,	0,	1,	3,	0,	-9, 0,	-13,	-6, 3,	-9},
	{1, -1, 0,	0,	0,	2,	0,	0,	-2, 0,	0,	1,	1,	0,	0,	2,	2,	2,	2,	3,	0,	-9, 0,	-12,	-6, 1,	-11},
	{2, -1, 1,	0,	0,	0,	0,	0,	1,	0,	1,	0,	0,	1,	1,	1,	0,	0,	-2, 0,	-3, -5, 3,	-8, -8, 1,	-11},
	{0, -1, 1,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	1,	1,	2,	1,	2,	-2, -1, -3, -8, 2,	-9, -8, 0,	-12},
	{1, 0,	1,	-1, 0,	0,	0,	0,	0,	1,	1,	1,	1,	2,	1,	1,	0,	1,	2,	3,	1,	-7, 1,	-9, -8, 0,	-12},
	{1, -1, 1,	0,	0,	-1, -1, 0,	0,	0,	0,	0,	1,	1,	1,	2,	1,	2,	2,	3,	1,	-3, 4,	-5, -8, 1,	-11},
	{1, -1, 1,	0,	0,	-1, -1, 0,	0,	1,	0,	1,	-1, 0,	-1, 3,	2,	3,	2,	2,	1,	-4, 3,	-6, -7, 0,	-11},
	{1, -1, 1,	-1, 0,	-1, 0,	0,	0,	0,	0,	-1, 2,	1,	2,	0,	0,	0,	2,	2,	1,	-4, 2,	-6, -9, 0,	-12},
	{1, 0,	2,	0,	0,	0,	0,	0,	-1, 0,	0,	0,	1,	1,	1,	2,	1,	2,	-1, -1, -3, -5, 1,	-6, -9, 0,	-12},
	{1, 0,	0,	0,	0,	2,	0,	0,	-1, 0,	0,	1,	0,	0,	0,	3,	2,	3,	3,	3,	1,	-4, 1,	-5, -8, -1, -10},
	{0, 0,	1,	0,	0,	1,	0,	0,	0,	0,	1,	1,	2,	1,	1,	3,	2,	3,	3,	3,	2,	-5, 0,	-6, -2, 2,	-4},
	{1, 0,	2,	-1, 0,	0,	0,	0,	1,	1,	1,	1,	0,	0,	0,	3,	1,	2,	0,	0,	-1, -1, 3,	-1, -5, 1,	-5},
	{0, 0,	1,	1,	0,	1,	0,	1,	1,	1,	1,	1,	-2, -2, -2, 1,	0,	1,	4,	3,	2,	-3, 1,	-2, -5, 0,	-5},
	{1, 0,	1,	0,	1,	1,	-1, 0,	0,	1,	0,	0,	-2, -1, -1, 3,	1,	3,	-2, -1, -2, 0,	4,	1,	-7, -1, -5},
	{0, -1, 0,	0,	0,	0,	0,	0,	0,	1,	1,	2,	-1, -1, -1, 1,	0,	1,	0,	0,	0,	0,	4,	1,	-1, 3,	0},
	{-1,	0,	0,	1,	0,	1,	-1, 0,	0,	0,	1,	0,	0,	-1, 0,	1,	0,	1,	-1, 0,	-1, -4, 0,	-2, -4, 3,	-1},
	{-1,	-1, 0,	0,	0,	0,	1,	1,	1,	-1, 0,	-1, -1, -1, 0,	2,	0,	1,	-2, 0,	-1, -4, -1, -2, -5, 1,	-3},
	{-2,	-1, -2, 1,	0,	2,	0,	1,	0,	0,	0,	0,	0,	0,	0,	1,	0,	1,	0,	1,	0,	-4, -1, -2, -4, 2,	-2},
	{-1,	-1, 0,	0,	0,	0,	-1, 0,	0,	0,	0,	0,	1,	1,	1,	1,	0,	1,	0,	1,	0,	-4, -1, -2, -6, 1,	-3},
	{-2,	-1, -1, 0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	1,	0,	1,	-1, 1,	-1, 0,	-1, -4, -1, -2, -6, 0,	-3},
	{-2,	-1, -2, 1,	0,	2,	-1, 0,	-1, -1, 0,	-1, 1,	1,	2,	2,	0,	1,	-2, 0,	-1, -5, -2, -3, -6, 1,	-2},
	{-1,	0,	0,	0,	0,	1,	1,	1,	1,	-1, -1, -1, 0,	1,	0,	1,	-1, 1,	-2, 0,	-2, -3, -1, -1, -7, 1,	-3},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0},
};


/************
 *	  HMT   *
 ************/

static unsigned int base_luminance_reverse_hmt_single[][2] = {
	{10,	32},
	{11,	34},
	{12,	36},
	{13,	39},
	{14,	42},
	{15,	46},
	{16,	49},
	{17,	52},
	{19,	59},
	{20,	62},
	{21,	66},
	{22,	69},
	{23,	72},
	{25,	78},
	{27,	85},
	{29,	89},
	{31,	96},
	{33,	102},
	{35,	107},
	{37,	112},
	{39,	118},
	{41,	125},
	{44,	132},
	{47,	142},
	{50,	150},
	{53,	158},
	{56,	168},
	{60,	178},
	{64,	190},
	{68,	200},
	{72,	212},
	{77,	224},
	{82,	237},
	{87,	248},
	{93,	263},
	{99,	276},
	{105,	290},
};

static int gradation_offset_reverse_hmt_single[][9] = {
/*	V255 V203 V151 V87 V51 V35 V23 V11 V7 */
	{0, 1,	1,	2,	4,	4,	4,	5,	6},
	{0, 1,	0,	3,	3,	3,	4,	5,	6},
	{0, 1,	1,	2,	3,	4,	4,	5,	6},
	{0, 2,	1,	3,	3,	4,	5,	5,	6},
	{0, 2,	1,	2,	3,	4,	4,	6,	6},
	{0, 1,	1,	2,	3,	4,	4,	5,	6},
	{0, 1,	1,	1,	2,	3,	4,	6,	6},
	{0, 1,	1,	2,	3,	4,	5,	5,	6},
	{0, 0,	0,	1,	2,	3,	4,	5,	6},
	{0, 0,	1,	2,	3,	4,	4,	5,	6},
	{0, 0,	1,	2,	2,	3,	5,	5,	6},
	{0, 0,	1,	2,	3,	3,	4,	5,	6},
	{0, 0,	1,	1,	2,	4,	4,	5,	6},
	{0, 0,	2,	3,	2,	3,	5,	6,	6},
	{0, 0,	1,	2,	2,	3,	4,	5,	6},
	{0, 1,	2,	2,	3,	3,	4,	5,	6},
	{0, 1,	1,	1,	3,	3,	4,	5,	6},
	{0, 2,	1,	1,	2,	3,	4,	5,	5},
	{0, 2,	1,	2,	3,	3,	4,	5,	5},
	{0, 2,	1,	1,	2,	3,	4,	5,	5},
	{0, 2,	0,	2,	3,	3,	4,	5,	5},
	{0, 2,	1,	2,	3,	3,	4,	5,	5},
	{0, 3,	2,	2,	3,	3,	4,	5,	5},
	{0, 3,	3,	3,	3,	4,	4,	5,	5},
	{0, 3,	2,	2,	2,	3,	4,	5,	5},
	{0, 3,	2,	3,	2,	4,	3,	4,	5},
	{0, 3,	3,	2,	2,	3,	4,	4,	5},
	{0, 3,	5,	4,	3,	3,	4,	5,	5},
	{0, 4,	4,	3,	3,	3,	4,	5,	5},
	{0, 3,	5,	3,	2,	3,	4,	5,	5},
	{0, 3,	5,	4,	3,	3,	4,	4,	5},
	{0, 4,	5,	4,	3,	3,	4,	5,	5},
	{0, 5,	7,	5,	3,	3,	3,	5,	5},
	{0, 5,	7,	5,	3,	3,	4,	5,	5},
	{0, 5,	7,	5,	3,	3,	3,	5,	5},
	{0, 5,	9,	5,	4,	4,	4,	5,	6},
	{0, 7,	8,	5,	3,	3,	3,	5,	6},
};

static int rgb_offset_reverse_hmt_single[][RGB_COMPENSATION] = {
/*	R255 G255 B255 R203 G203 B203 R151 G151 B151
	R87 G87 B87 R51 G51 B51 R35 G35 B35
	R23 G23 B23 R11 G11 B11
*/
	{0, 0,	0,	-1, 0,	-1, -2, 0,	-2, -2, 1,	-3, -2, 2,	-4, -4, 2,	-6, -3, 4,	-9, -9, 4,	-9, -3, 2,	1},
	{0, 0,	0,	0,	0,	0,	-2, 0,	-2, -2, 1,	-3, -2, 2,	-4, -4, 2,	-6, -4, 4,	-9, -8, 4,	-8, -3, 2,	0},
	{0, 0,	0,	-1, 0,	-1, -1, 0,	-1, -3, 1,	-4, -3, 1,	-4, -1, 2,	-4, -4, 4,	-10,	-7, 4,	-9, -3, 2,	0},
	{0, 0,	0,	-1, 0,	0,	0,	0,	-1, -3, 1,	-3, -2, 2,	-4, -3, 2,	-5, -2, 2,	-6, -6, 5,	-11,	-3, 2,	-1},
	{0, 0,	0,	-1, 0,	0,	-1, 0,	-1, -3, 1,	-4, -3, 1,	-4, -2, 2,	-4, -3, 3,	-8, -6, 5,	-10,	-4, 2,	-1},
	{0, 0,	-1, -2, 0,	-1, 0,	0,	0,	-2, 1,	-3, -3, 1,	-4, -2, 2,	-4, -1, 3,	-7, -7, 5,	-11,	-4, 2,	-2},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-2, 1,	-3, -2, 1,	-4, -2, 1,	-4, -3, 3,	-8, -2, 4,	-10,	-4, 2,	-2},
	{0, 0,	0,	0,	0,	-1, 0,	0,	0,	-3, 1,	-3, -1, 1,	-3, -1, 1,	-4, -3, 3,	-6, -4, 5,	-11,	-4, 3,	-2},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-3, 1,	-3, -1, 1,	-2, -2, 1,	-4, -4, 3,	-7, -1, 4,	-10,	-4, 3,	-2},
	{0, 0,	0,	0,	0,	-1, 0,	0,	0,	-2, 1,	-2, -3, 1,	-4, -2, 1,	-4, -3, 3,	-8, -6, 5,	-11,	-4, 3,	-2},
	{0, 0,	0,	-1, 0,	0,	0,	0,	0,	-1, 1,	-2, -3, 1,	-4, -3, 1,	-4, -2, 2,	-6, -3, 6,	-12,	-4, 3,	-3},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-2, -3, 1,	-4, -2, 2,	-4, -4, 2,	-6, -2, 6,	-12,	-4, 3,	-3},
	{0, 0,	0,	-1, 0,	0,	0,	0,	0,	-2, 1,	-2, -2, 1,	-4, -3, 1,	-4, -3, 2,	-6, -7, 6,	-13,	-4, 3,	-3},
	{0, 0,	0,	0,	0,	0,	0,	0,	-1, -2, 1,	-2, -3, 1,	-4, -3, 1,	-4, -2, 2,	-6, -5, 5,	-12,	-4, 3,	-3},
	{0, 0,	1,	0,	0,	0,	0,	0,	-1, -1, 0,	-2, -3, 1,	-4, -3, 1,	-4, -4, 2,	-6, -2, 5,	-12,	-4, 3,	-3},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-2, -2, 1,	-3, -3, 2,	-4, -3, 2,	-6, -2, 5,	-10,	-4, 3,	-3},
	{0, 0,	0,	0,	0,	0,	0,	0,	-1, -2, 1,	-2, -2, 1,	-3, -3, 2,	-4, -4, 2,	-6, -4, 5,	-11,	-4, 3,	-3},
	{0, 0,	0,	0,	0,	0,	1,	0,	0,	-1, 0,	-1, -3, 1,	-4, -3, 1,	-4, -3, 2,	-5, -1, 5,	-10,	-1, 4,	-1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -3, 1,	-4, -3, 1,	-4, -3, 2,	-6, -5, 5,	-11,	-1, 4,	-1},
	{0, 0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	-1, -3, 1,	-4, -3, 1,	-4, -3, 2,	-5, -2, 5,	-11,	-4, 5,	-1},
	{0, 0,	1,	0,	0,	0,	0,	0,	-1, -2, 0,	-2, -3, 1,	-4, -3, 1,	-3, -3, 2,	-6, -4, 4,	-10,	-4, 5,	-1},
	{0, 0,	1,	0,	0,	0,	0,	0,	-1, -1, 0,	-2, -2, 1,	-3, -2, 1,	-3, -4, 2,	-6, -3, 4,	-10,	-3, 4,	-1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-2, 0,	-1, -1, 1,	-3, -2, 1,	-3, -3, 2,	-6, -4, 5,	-10,	-3, 4,	-1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	-2, 1,	-4, -2, 1,	-4, -4, 2,	-6, -4, 5,	-12,	-2, 4,	-1},
	{0, 0,	0,	0,	0,	0,	1,	0,	0,	-2, 0,	-1, -2, 1,	-4, -2, 1,	-3, -3, 2,	-6, -3, 5,	-11,	-1, 3,	0},
	{0, 0,	1,	1,	0,	0,	1,	0,	0,	-1, 0,	0,	-3, 1,	-4, -2, 1,	-3, -3, 2,	-5, -5, 5,	-12,	-1, 3,	-1},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	-1, 0,	0,	-2, 1,	-3, -2, 1,	-3, -3, 1,	-4, -4, 5,	-12,	-1, 4,	-2},
	{0, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -1, 1,	-2, -3, 1,	-4, -4, 2,	-5, -3, 4,	-10,	-1, 4,	-5},
	{0, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 0,	-1, -1, 1,	-3, -2, 1,	-2, -2, 2,	-4, -5, 4,	-10,	-1, 4,	-6},
	{0, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, 1,	-2, -3, 1,	-3, -3, 1,	-4, -4, 5,	-11,	-3, 3,	-6},
	{0, 0,	1,	1,	0,	0,	1,	0,	0,	-1, 0,	-1, -2, 0,	-2, -2, 1,	-3, -3, 2,	-4, -3, 5,	-10,	-4, 3,	-6},
	{1, 0,	1,	0,	0,	0,	0,	0,	0,	-1, 0,	-2, -2, 0,	-2, -2, 1,	-3, -2, 2,	-4, -3, 4,	-9, -5, 1,	-6},
	{0, 0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	-1, -2, 1,	-2, -2, 1,	-2, -1, 2,	-4, -3, 4,	-8, -5, 2,	-6},
	{0, 0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	-1, -1, 0,	-2, -2, 1,	-3, -3, 2,	-4, -3, 3,	-8, -5, 3,	-6},
	{1, 0,	2,	0,	0,	0,	0,	0,	0,	0,	0,	-1, -2, 0,	-2, -2, 1,	-3, -3, 1,	-4, -3, 3,	-8, -5, 4,	-6},
	{0, 0,	0,	-1, 0,	0,	0,	0,	0,	0,	0,	-1, -1, 0,	-2, -1, 1,	-2, -3, 1,	-4, -3, 3,	-8, -8, 1,	-12},
	{1, 0,	2,	0,	0,	0,	0,	0,	1,	2,	0,	-1, -4, 0,	-2, -2, 1,	-2, -3, 1,	-4, -4, 3,	-8, -8, 1,	-12},
};
#endif
